﻿USE sofia;
DROP TABLE IF EXISTS sofia.engoke_vpl;
CREATE TABLE engoke_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engoke_vpl WRITE;
INSERT INTO engoke_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the first times the Lord created the heavens and the earth. ");
INSERT INTO engoke_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","And the earth was waste and empty, and darkness was upon the face of the abyss; and a wind from before the Lord blew upon the face of the waters. ");
INSERT INTO engoke_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","And the Lord said, Let there be light; and there was light. ");
INSERT INTO engoke_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","And the Lord saw the light that it was good. And the Lord distinguished between the light and between the darkness. ");
INSERT INTO engoke_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","And the Lord called the light the Day, and the darkness He called the Night. And there was evening, and there was morning, Day the First. ");
INSERT INTO engoke_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","And the Lord said, Let there be an expanse in the midst of the waters, and let it distinguish between waters and waters. ");
INSERT INTO engoke_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","And the Lord made the expanse, and distinguished between the waters which were under the expanse, and between the waters which were above the expanse: and it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","And the Lord called the expanse the Heavens. And it was evening, and it was morning, the Second Day. ");
INSERT INTO engoke_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","And the Lord said, The waters shall be collected under the heavens into one region, and the dry land shall appear. And it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","And the Lord called the dry land Earth, and the place of the collection of waters He called Sea. And the Lord saw that it was good. ");
INSERT INTO engoke_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","And the Lord said, The earth shall bring forth grass; the plant whose germ-seed is to be sown; the fruit-tree making fruit according to its kind, whose germ-seed is in it upon the earth; and it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","And the earth put forth grass; the herb, whose germ-seed is sown after its kind; and the tree making fruit, whose seed is in it after its kind. And the Lord saw that it was good. ");
INSERT INTO engoke_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","And it was evening, and it was morning, Day the Third. ");
INSERT INTO engoke_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","And the Lord said, There shall be Lights in the expanse of heaven, to distinguish between the day and the night; and they shall be for signs and for times, for the numbering of days and years. ");
INSERT INTO engoke_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","And they shall be for luminaries in the expanse of heaven to shine upon the earth; and it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","And the Lord made the two great luminaries: the greater luminary to rule in the day; and the smaller luminary to rule in the night, and the stars. ");
INSERT INTO engoke_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","And the Lord set them in the expanse of heaven to shine upon the earth, ");
INSERT INTO engoke_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","and to rule in the day and in the night, and to distinguish between light and darkness. And the Lord saw that it was good. ");
INSERT INTO engoke_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","And there was evening, and there was morning, Day the Fourth. ");
INSERT INTO engoke_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","And the Lord said, Let the waters generate the moving creature (having) life; and the fowl which flieth over the earth on the face of the expanse of heaven. ");
INSERT INTO engoke_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","And the Lord created the great taninia and every living animal which moveth, which the waters generated according to their kind, and every fowl which flieth according to his kind; and the Lord saw that it was good. ");
INSERT INTO engoke_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","And the Lord blessed them, saying, Spread abroad and become many, and fill the waters of the seas; and let the fowl become many on the earth. ");
INSERT INTO engoke_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","And it was evening, and it was morning, Day the Fifth. ");
INSERT INTO engoke_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","And the Lord said, Let the earth produce the living animal after its kind, cattle, and reptile, and beast of the earth, according to its kind; and it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","And the Lord mad, the beast of the earth after its kind, and cattle after their kind, and every reptile of the earth after its kind; and the Lord saw that it was good. ");
INSERT INTO engoke_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","And the Lord said, Let us make Man in Our image, as Our likeness; and shall have dominion over the fish of the sea, and over the fowl of the heavens, and over the cattle, and over all the earth, and over every reptile which moveth upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","And the Lord created the Adam in His image, in the image of the Lord He created him; male and female He created them. ");
INSERT INTO engoke_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","And the Lord blessed them, and said to them, spread abroad, and become many, and fill the earth, and be strong upon it; and have dominion over the fish of the sea, and over the fowl of the heavens, and over every living thing that moveth upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","And the Lord said, Behold, I have given to you every plant which seedeth green-seed which is upon all the earth; and every tree in which is the fruit of the tree which seedeth germ-seed; unto you it shall be for food, ");
INSERT INTO engoke_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","and unto every beast of the earth, and to every fowl of the heavens, and to every reptile upon the earth in which is the breath of life, every green herb to eat; and it was so. ");
INSERT INTO engoke_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","And the Lord saw all that He had made, and, behold, it was very steadfast. And it was evening, and it was morning, Day the Sixth. ");
INSERT INTO engoke_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","And the heavens and the earth and all their host were completed. ");
INSERT INTO engoke_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","And the Lord finished in the Seventh Day His work which He had wrought, and rested in the Seventh Day from all His work which He had wrought. ");
INSERT INTO engoke_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","And the Lord blessed the Seventh Day and made it holy, because in it He rested from all His work which the Lord had created to make. ");
INSERT INTO engoke_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","These are the memorials of the heavens and the earth, when they were created in the day when the Lord God made the earth and the heavens. ");
INSERT INTO engoke_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","And all trees of the field were not yet in the earth, and every herb of the field had not yet sprung up, because the Lord God had not caused rain to come upon the earth, and there was no man to cultivate the ground. ");
INSERT INTO engoke_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","And a mist ascended from the earth, and moistened all the face of the ground. ");
INSERT INTO engoke_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","And the Lord God created Adam from dust of the ground, and breathed upon his face the breath of lives, and it became in Adam a Discoursing Spirit. ");
INSERT INTO engoke_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","And the Lord God planted a garden in a region of pleasantness in the time of the beginning, and He made to dwell there the man whom He had created. ");
INSERT INTO engoke_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","And the Lord God caused to grow from the earth every tree desirable to look upon, and good for food, and the Tree of Life (Lives) in the midst of the garden, and the Tree of whose fruit they who eat know between good and evil. ");
INSERT INTO engoke_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","And a river went forth from Eden to water the garden, and from thence it was divided and became four heads of rivers (or four chief rivers). ");
INSERT INTO engoke_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first is Pishon, that which encompasseth all the land of Havilah, where is gold; ");
INSERT INTO engoke_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","and the gold of that land is good; there is bedalcha and Burilla stones. ");
INSERT INTO engoke_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","And the name of the second river is Gichon, which encompasseth all the land of Kush. ");
INSERT INTO engoke_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","And the name of the third river is Digelatlh, which goeth to the east of Athur. And the fourth river is Pherat. ");
INSERT INTO engoke_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","And the Lord God took Adam and placed him in the garden of Eden to culture it and keep it. ");
INSERT INTO engoke_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And the Lord God commanded Adam, saying, Of every tree of the garden eating thou mayest eat; ");
INSERT INTO engoke_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","but of the tree of whose fruit they who eat know between good and evil thou shalt not eat; for in the day that thou eatest of it dying thou shalt die. ");
INSERT INTO engoke_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","And the Lord God said, It is not right that Adam should be solitary; I will make for him a helper as for his sake (or, as suited to him: Heb., kenegdo, as his counterpart). ");
INSERT INTO engoke_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And the Lord God created from the earth every beast of the field and every fowl of the heavens, and brought them to Adam to see what he would call him; and every (name by) which Adam called the living animal, that was its name. ");
INSERT INTO engoke_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","And Adam called the name of all cattle, and of the fowl of the heaven, and of every beast of the field; but to Adam was not found a helper as for him. ");
INSERT INTO engoke_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","And the Lord God threw a sleep upon Adam, and he slept; and He took one of his ribs, and filled with flesh in place thereof; ");
INSERT INTO engoke_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","and the Lord God builded the rib which He took from Adam into Woman, and He brought her unto Adam. ");
INSERT INTO engoke_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","And Adam said, This now (this time) is bone of my bone, and flesh of my flesh: this shall be called Woman, because from her husband this was taken. ");
INSERT INTO engoke_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Therefore shall a man forsake the couch (beth mishkeb, the sleeping-house) of his father and his mother, and shall cleave to his wife, and they shall be of one flesh. ");
INSERT INTO engoke_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","And they were both naked, Adam and his wife, and were not ashamed. ");
INSERT INTO engoke_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","And the serpent (chivja) was more crafty than all the animals of the field which the Lord God bad made. And he said to the woman, Is it in truth (that) the Lord said, You shall not eat of every tree of the garden? ");
INSERT INTO engoke_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","And the woman said to the serpent, Of the fruit of the trees of the garden we may eat; ");
INSERT INTO engoke_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","but of the fruit of the tree which is in the midst of the garden, the Lord hath said, You shall not eat of it, nor approach to it, lest you die. ");
INSERT INTO engoke_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","And the serpent said to the woman. Not to die will you die: ");
INSERT INTO engoke_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","for it is manifest before the Lord, that in the day in which you eat of it your eyes will be opened, and you will be (ki-rabrebin) as the Great-ones, knowing good and evil. ");
INSERT INTO engoke_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","And the woman saw that the tree was good to eat, and that it was salutary to the eyes, and a tree desirable to contemplate; and she took of its fruitage (aiba) and ate; and she gave to her husband with her, and he ate. ");
INSERT INTO engoke_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","And the eyes of both of them were opened, and they knew that they were naked; and they sewed for themselves the leaves of the fig tree, and made for themselves cinctures. ");
INSERT INTO engoke_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","And they heard the voice of the Word of the Lord God walking in the garden in the evening of the day; and Adam and his wife hid themselves from before the Lord God among the trees of the garden. ");
INSERT INTO engoke_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","And the Lord God called to Adam and said to him, Where art thou? ");
INSERT INTO engoke_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","And he said, The voice of Thy Word heard I in the garden, and I was afraid, because I (was) naked, and I would hide. ");
INSERT INTO engoke_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","And He said, Who showed thee that thou wast naked? Of the tree of which I commanded that eating of it thou shouldst not eat, hast thou eaten? ");
INSERT INTO engoke_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","And Adam said, The woman whom Thou gavest (to be) with me, she gave to me of the tree, and I did eat. ");
INSERT INTO engoke_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","And the Lord God said to the woman, What is this that thou hast done? And the woman said, The serpent led me astray, and I did eat. ");
INSERT INTO engoke_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","And the Lord God said to the serpent, Because thou hast done this, more accursed art thou than all cattle, and than all the beasts of the held; upon thy belly shalt thou go, and the dust shalt thou eat all the days of thy life. ");
INSERT INTO engoke_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And I will put enmity between thee and between the woman, and between thy son and her son. He will remember thee, what thou didst to him (at) from the beginning, and thou shalt be observant unto him at the end. ");
INSERT INTO engoke_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","And to the woman He said, Multiplying, I will multiply thy sorrows and thy pains. In sorrow shalt thou bring forth children; and unto thy husband shall be thy desire, and lie. He shall rule over thee. ");
INSERT INTO engoke_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","And unto Adam He said, Because thou hast obeyed the word of thy wife, and hast eaten of the tree (about) which I commanded thee, saying, Thou shalt not eat of it, accursed is the ground on thy account. With labour shalt thou eat from it all the days of thy life. ");
INSERT INTO engoke_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Thorns and thistles it shall put forth for thee, and thou shalt eat the herb of the field. ");
INSERT INTO engoke_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In the sweat of thy face shalt thou eat bread, until that thou return to the earth, because from it thou wast created; for dust thou art, and to dust thou wilt return. ");
INSERT INTO engoke_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","And Adam called the name of his wife Hava, because she was the mother of all the children of men. ");
INSERT INTO engoke_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","And the Lord God made for Adam and for his wife vestments of honor upon the skin of their flesh, and clothed them. ");
INSERT INTO engoke_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","And the Lord God said, Behold, man is become singular (or alone, yechid) in the world by himself, knowing good and evil; and now, lest he stretch forth his hand and take also of the Tree of Life, and eat, and live forever. ");
INSERT INTO engoke_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","And the Lord God sent him forth from the Garden of Eden to till the ground from whence he had been created. ");
INSERT INTO engoke_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","And He drove out the man, and before the garden of Eden he caused to dwell the kerubaya, and the sharp sword which revolved to keep the way of the Tree of Life. ");
INSERT INTO engoke_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","And Adam knew Hava his wife, and she conceived, and gave birth to Kain; and she said I have acquired the man from before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","And she added to give birth to his brother, Habel. And Habel was a shepherd of the flock, and Kain a man working on the ground. ");
INSERT INTO engoke_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","And it was at the end (or complement) of days, that Kain brought of the product of the earth an oblation before the Lord; ");
INSERT INTO engoke_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","and Habel he brought also of the first-born of his sheep and of their fatlings. And there was acceptableness before the Lord in Habel and in his oblation; ");
INSERT INTO engoke_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but in Kain and his oblation there was not acceptableness. And it was greatly displeasing to Kain, and his countenance was downcast. ");
INSERT INTO engoke_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","And the Lord said to Kain, Why art thou displeased, and why is thy countenance downcast? ");
INSERT INTO engoke_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If thou doest thy work well, is it not remitted to thee? And if thou doest not thy work well, thy sin unto the day of judgment is reserved, when it will be exacted of thee, if thou convert not: but if thou convert, it is remitted to thee. ");
INSERT INTO engoke_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","And Kain spake with Habel his brother; and it was in their being in the field that Kain arose against Habel his brother, and killed him. ");
INSERT INTO engoke_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","And the Lord said to Kain, Where is Habel thy brother? And he said, I know not; am I the keeper of my brother? ");
INSERT INTO engoke_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","And He said, What hast thou done? The voice of the blood of generations which were to come from thy brother complaineth before Me, from the earth! ");
INSERT INTO engoke_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","And now, accursed art thou from the earth, which hath opened her mouth and received the blood of thy brother from thy hand. ");
INSERT INTO engoke_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When thou tillest the earth, it shall not add to give its virtue to thee; a castaway and a wanderer shalt thou be in the earth. ");
INSERT INTO engoke_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","And Kain said before the Lord, Greater is my guilt than may be forgiven. ");
INSERT INTO engoke_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Behold, Thou hast rejected me this day from the face of the earth, and from Thy presence it is not possible to hide; and I shall be a castaway and a wanderer in the earth, and anyone who findeth me will slay me. ");
INSERT INTO engoke_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","And the Lord said to him, Therefore anyone who killeth Kain, unto seven generations it shall be exacted of him. And the Lord set unto Kain a sign, lest anyone who found him should kill him. ");
INSERT INTO engoke_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","And Kain went out from before the Lord, and dwelt in the land of the wanderer and outcast, which was made for him in the beginnings in the Garden of Eden. ");
INSERT INTO engoke_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","And Kain knew his wife, and she conceived and bare Hanoch, and he became the builder of a city, and called the name of the city after the name of his son Hanoch. ");
INSERT INTO engoke_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","And there was born to Hanoch Irad, and Irad begat Mahujael; and Mahujael begat Methu-sael, and Methusael begat Lemek. ");
INSERT INTO engoke_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","And Lemek took unto him two wives, the name of the one Ada, and the name of the second Zillah. ");
INSERT INTO engoke_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","And Ada bare Javal; he was the master (rab) of all dwellers in tents and lords of cattle. ");
INSERT INTO engoke_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","And the name of his brother was Juval. He was the master of all who play upon the mouth of the pipe, who know the song of the harp and of the organ. ");
INSERT INTO engoke_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","And Zillah also, she bare Tuval-kain, the master of all them who understand the working of brass and iron. And the sister of Tuval-kain was Naamah. ");
INSERT INTO engoke_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","And Lemek said to his wives Ada and Zillah, Hear my voice, wives of Lemek, attend to my words: I have not slain a man, that on his account I should bear the condemnation of death; or destroyed a young man, that on his account my posterity should be consumed. ");
INSERT INTO engoke_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If seven generations are suspended unto Kain, will there not be to Lemek his son seventy and seven? ");
INSERT INTO engoke_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam knew yet his wife, and she bare a son, and called his name Sheth; Because, said she, the Lord hath given me another son instead of Habel, whom Kain slew. ");
INSERT INTO engoke_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And to Sheth also was born a son, and he called his name Enosh. Then in his days the sons of men desisted (or forbore) from praying in the name of the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the book of the generations of Adam. In the day that the Lord God created man, in the resemblance of Elohim He made him; ");
INSERT INTO engoke_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Male and female He created them; and He blessed them, and called their name Man, in the day that they were created. ");
INSERT INTO engoke_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","And Adam lived a hundred and thirty years, and begat in his resemblance (one) who was like to himself, and he called his name Sheth. ");
INSERT INTO engoke_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","And the days of Adam after he had begotten Sheth were eight hundred years, and be begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","And all the days of Adam which he lived were nine hundred and thirty years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","And Sheth lived a hundred and five years, and begat Enosh. ");
INSERT INTO engoke_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","And Sheth lived after he had begotton Enosh eight hundred and seven years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","And all the days of Sheth were nine hundred and twelve years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","And Enosh lived ninety years, and begat Keinan. ");
INSERT INTO engoke_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","And Enosh lived after he had begotten Keinan eight hundred and fifteen years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","And all the days of Enosh were nine hundred and five years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","And Keinan lived seventy years, and begat Mahalalel. ");
INSERT INTO engoke_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","And Keinan lived after he had begotten Mahalalel eight hundred and forty years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","And all the days of Keinan were nine hundred and ten years, and be died. ");
INSERT INTO engoke_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","And Mahalalel lived sixty and five years, and begat Jered. ");
INSERT INTO engoke_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","And Mahalalel lived after he had begotten Jered eight hundred and thirty years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","And all the days of Mahalalel were eight hundred and ninety and five years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","And Jered lived an hundred and sixty and two years, and begat Hanok. ");
INSERT INTO engoke_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","And Jered lived after he had begotten Hanok eight hundred years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","And all the days of Jared were nine hundred and sixty and two years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","And Hanok lived sixty and five years, and begat Methushelach. ");
INSERT INTO engoke_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","And Hanok walked in the fear of the Lord, after he had begotten Methushelach, three hundred years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","And all the days of Hanok were three hundred and sixty and five years. ");
INSERT INTO engoke_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","And Hanok walked in the fear of the Lord; and he was not; for the Lord had not made him to die. ");
INSERT INTO engoke_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","And Methushelach lived an hundred and eighty and seven years, and begat Lemek. ");
INSERT INTO engoke_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","And Methushelach lived after he had begotten Lemek seven hundred and eighty and two years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","And all the days of Methushelach were nine hundred and sixty and nine years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","And Lemek lived a hundred and eighty and two years, and begat a son. ");
INSERT INTO engoke_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","And he called his name Noach, saying, This shall console us from the works and from the labour of our hands from the earth which the Lord bath cursed. ");
INSERT INTO engoke_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","And Lemek lived, after he had begotten Noach, five hundred and ninety and five years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","And all the days of Lemek were seven hundred and seventy and seven years, and he died. ");
INSERT INTO engoke_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","And Noach was a son of five hundred years, and Noach begat Shem, Cham, and Japheth. ");
INSERT INTO engoke_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","And it was when the sons of men had begun to multiply upon the earth, and daughters were born to them, ");
INSERT INTO engoke_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","that the sons of the mighty saw the daughters of men that they were beautiful, and took to them wives of all whom they pleased. ");
INSERT INTO engoke_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","And the Lord said, This evil generation shall not stand before me forever, because they are flesh, and their works are evil. A term (or length) will I give them, an hundred and twenty years, if they may be converted. ");
INSERT INTO engoke_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Giants were in the earth in those days; and also when, after that the sons of the mighty had gone in unto the daughters of men, there were born from them giants who from of old were men of name. ");
INSERT INTO engoke_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","And the Lord saw that the wickedness of man had multiplied in the earth, and that every formation (or image) of the thought of his heart was only evil every day. ");
INSERT INTO engoke_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","And it repented the Lord in His Word that He had made men upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","And He said, (in His Word,) that He would break their strength according to His pleasure. And the Lord said, Man whom I have made will I blot out I from the face of the earth; from man to the beast, to the reptile, and to the fowls of heaven; because it repenteth Me in My Word that I have made them. ");
INSERT INTO engoke_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noach found mercy before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","These are the memorials of Noach. Noach was a man righteous and perfect in his generation; in the fear of the Lord walked Noach. ");
INSERT INTO engoke_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","And Noach begat three sons, Shem, Cham, and Yapeth. ");
INSERT INTO engoke_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","And the earth was corrupted before the Lord, and the earth was filled with violences. ");
INSERT INTO engoke_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","And the Lord saw the earth, and, behold, it was corrupt, because all flesh had corrupted, each one, his way upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","And the Lord said to Noach, The end of all flesh cometh before Me, because the earth is filled with violences from the face of their wicked works; and, behold, I will destroy them with the earth. ");
INSERT INTO engoke_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make thee an ark with the wood of cedar; dwellings shalt thou make in the ark, and overlay it within and without with pitch. ");
INSERT INTO engoke_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","And thus shalt thou make it: three hundred cubits shall be the length of the ark, fifty cubits its breadth, and thirty cubits its height. ");
INSERT INTO engoke_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","A light shalt thou make to the ark, and at a cubit shalt thou complete it above, and the door of the ark thou shalt place in its side. Lower dwellings, second and third, shalt thou make in it. ");
INSERT INTO engoke_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","And I, behold, I do bring the deluge of waters upon the earth to destroy all flesh in which is the breath of life from under the heavens. Everything that is on the earth shall die. ");
INSERT INTO engoke_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","And I will establish My covenant with thee; and thou shalt enter into the ark, thou, and thy sons, and thy wife, and the wives of thy sons with thee. ");
INSERT INTO engoke_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And of all that liveth of all flesh two and two of all that enter into the ark to abide with thee, male and female shall they be. ");
INSERT INTO engoke_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of fowl according to its kind, and of cattle according to her kind, and of every creeping thing of the earth after his kind, two of all shall enter with thee to abide. ");
INSERT INTO engoke_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And thou, take with thee of all food which is eaten, and gather to be with thee; and it shall be for thee and for them to eat. ");
INSERT INTO engoke_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","And Noach did according to all which the Lord had commanded him, so did he. ");
INSERT INTO engoke_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","And the Lord said to Noach, Enter thou and all the men of thy house into the ark; for thee have I seen righteous before Me in this generation. ");
INSERT INTO engoke_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Of all clean animals take thou seven and seven, male and female; and of animals not clean, two and two, male and female. ");
INSERT INTO engoke_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Also of the fowls of heaven, seven and seven, male and female, to continue the seed upon the face of all the earth. ");
INSERT INTO engoke_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Because yet a time of seven days and I will cause rain to descend upon the earth forty days and forty nights, and I will blot out every subsistence which I have made upon all the face of the earth. ");
INSERT INTO engoke_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noach did according to all that the Lord had instructed him. ");
INSERT INTO engoke_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","And Noach was a son of six hundred years; and the deluge of waters was upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","And Noach entered, and his sons, and his wife, and the wives of his sons with him, into the ark from before the water of the deluge. ");
INSERT INTO engoke_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Of animals clean, and of animals not clean, and of birds, and of all which creepeth upon the earth, ");
INSERT INTO engoke_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","two and two, they entered with Noach into the ark, male and female, as the Lord had instructed Noach. ");
INSERT INTO engoke_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And it was at the time of seven days, and the waters of the deluge were upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six-hundredth year of the life of Noach, in the second month, in the seven-teenth day of the month, in that day were all the springs of the great abyss upbroken, and the windows of heaven opened, ");
INSERT INTO engoke_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","and the rain came down upon the earth forty days and forty nights. ");
INSERT INTO engoke_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","In that very day entered Noach, and Shem, Cham, and Yapheth, sons of Noach, and the wife of Noach, and the three wives of his sons with them, into the ark; ");
INSERT INTO engoke_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They, and every animal after his kind, and all cattle after its kind, and every, reptile which creepeth upon the earth after its kind, and every fowl after its kind, every bird, everyone that flieth: ");
INSERT INTO engoke_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","And they entered with Noach into the ark, two and two of all flesh in which is the breath of life; ");
INSERT INTO engoke_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","And they, entering, male and female of all flesh, entered, as the Lord had commanded him, and the Lord protected them by His Word. ");
INSERT INTO engoke_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","And there was a deluge forty days upon the earth, and the waters increased, and took up the ark, and it was lifted up above the earth. ");
INSERT INTO engoke_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","And the waters prevailed and increased mightily upon the earth, and the ark went upon the faces of the waters. ");
INSERT INTO engoke_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","And the waters prevailed most mightily over the earth, and all the high hills were covered which were under all the heavens. ");
INSERT INTO engoke_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fifteen cubits upward did the waters prevail, and the mountains were covered; ");
INSERT INTO engoke_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","And all flesh died which moved upon the earth, of fowl, and of cattle, and of the wild beast, and of every reptile which creepeth upon the earth, and every man. ");
INSERT INTO engoke_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Everything in whose nostrils was the breath of the Spirit of life, of all which was upon the dry ground, died. ");
INSERT INTO engoke_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","And every subsistence was blotted out that was upon the faces of the earth, from man to the beast, to the reptile, and to the fowl of heaven, it was blotted out from the earth, and Noach was left alone, and they who were with him in the ark. ");
INSERT INTO engoke_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","And the waters prevailed upon the earth an hundred and fifty days. ");
INSERT INTO engoke_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","And the Lord remembered Noach, and every living thing, and all the cattle which were with him in the ark; and the Lord caused a wind to pass over the earth, and the waters rested, ");
INSERT INTO engoke_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","and the springs of the abyss were shut, and the windows of the heavens, and the rain from the heavens was restrained, and the waters turned from on the earth, going and returning; ");
INSERT INTO engoke_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","And the waters diminished from the end of a hundred and fifty days. ");
INSERT INTO engoke_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","And the ark rested on the seventh month, on the seventeenth day of the month, upon the mountains of Kardu. ");
INSERT INTO engoke_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","And the waters went and diminished until the tenth month: in the tenth, on the first of the mouth, the heads of the mountains appeared. ");
INSERT INTO engoke_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","And it was at the end of forty days, and Noach opened the windows of the ark which he had made. ");
INSERT INTO engoke_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","And he sent forth a raven, and going he went out, and returned until the waters were dried upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","And he sent forth a dove from (being) with him, to see whether the waters were lightened (or consumed) from the surface of the earth. ");
INSERT INTO engoke_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the dove found no rest for the dividing of her foot, and she returned unto him into the ark, because the waters were upon all the earth; and he stretched forth his hand, and took her, and brought her to be with him in the ark. ");
INSERT INTO engoke_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","And he prolonged yet seven days, and afterward added to send forth the dove from the ark. ");
INSERT INTO engoke_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","And the dove came to him at the time of evening, and, behold, a leaf of olive broken off was in her mouth; and Noach knew that the waters were lightened from upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","And he prolonged yet other seven days, and sent forth the dove, and she added not to return to be with him again. ");
INSERT INTO engoke_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","And it was in the six-hundredth and first year, in the beginning of the first month, the waters were dried from off the earth; and Noach removed the covering of the ark, and looked, and, behold, the faces of the ground were dry. ");
INSERT INTO engoke_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","And in the second month, in the seventeenth day of the month, the earth was fully dry. ");
INSERT INTO engoke_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","And the Lord spake with Noach, saying: ");
INSERT INTO engoke_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Go forth from the ark, thou, and thy wife, and thy sons, and the wives of thy sons with thee. ");
INSERT INTO engoke_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Every living thing which is with thee of all flesh, of fowl, and of cattle, and every creeping thing that creepeth upon the earth, bring forth with thee, and they shall generate in the earth, and spread abroad and multiply upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","And Noach went forth, and his sons, and his wife, and the wives of his sons with him; ");
INSERT INTO engoke_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every animal, every reptile and bird, everything which moveth upon the earth after their kind, went forth from the ark. ");
INSERT INTO engoke_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","And Noach builded an altar before the Lord, and took of every clean beast and of every clean bird, and uplifted an offering upon the altar. ");
INSERT INTO engoke_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","And the Lord received with approval his oblation; and the Lord said in His Word, I will not add to curse again the earth on account of the guilt of man, because the creations of the heart of man are evil from his infancy; and I will not add again to smite every living thing as I have done. ");
INSERT INTO engoke_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Yet all the days of the earth, seed-time and harvest, and cold and heat, and summer and winter, and day and night, shall not cease. ");
INSERT INTO engoke_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","And the Lord blessed Noach and his sons, and said to them, Spread abroad, and multiply, and fill the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","And the fear of you and the dread of you shall be upon every beast of the earth, and upon every fowl of the heavens, in all which creepeth upon the earth, and in all fish of the sea; into your hands shall they be delivered. ");
INSERT INTO engoke_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every moving thing that liveth, for you it shall be to eat; as the green herb I have given you the whole. ");
INSERT INTO engoke_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But the flesh with its life-blood you shall not eat. ");
INSERT INTO engoke_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","And also your blood of your lives will I require, from every beast will I require it, and from the hand of man. From the hand of the man who sheddeth the blood of his brother will I require the life of man. ");
INSERT INTO engoke_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoso sheddeth the blood of man, by witnesses, upon the sentence of the judges, his blood shall be shed; because in the image of the Lord made He man. ");
INSERT INTO engoke_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","And you, spread abroad and multiply; bring forth in the earth and multiply therein. ");
INSERT INTO engoke_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","And the Lord spake to Noach, and to his sons with him, saying, ");
INSERT INTO engoke_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","and I, behold, I establish my covenant with you and with your children after you, ");
INSERT INTO engoke_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living thing which is with you, of fowl, of cattle, and of every beast of the field that is with you, of all going forth from the ark of every animal of the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","And I will establish My covenant with you, and all flesh shall not again be consumed by the waters of a deluge, nor shall there be again a deluge to destroy the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And the Lord said, This is the sign of the covenant which I appoint (give) between My Word, and between you, and between every living soul that is with you unto perpetual generations. ");
INSERT INTO engoke_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I have set My bow in the cloud, and it shall be for a sign of the covenant between My Word and between the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","And it shall be that when clouding I becloud the earth, the bow shall be seen in the cloud, ");
INSERT INTO engoke_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","and I will remember the covenant which is between My Word, and between You, and between every living soul of all flesh; and there shall not be again the waters of a deluge to destroy all flesh. ");
INSERT INTO engoke_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","And the bow shall be in the cloud, and I will look upon it, to remember the everlasting covenant between the Word of the Lord and between every living soul of all flesh that is upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","And the Lord said, This is the sign of the covenant which I have established between My Word and between all flesh which is upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","And the sons of Noach who went forth from the ark were Shem and Cham and Yapheth: and Cham is the father of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three are the sons of Noach and from them was the whole earth Overspread. ");
INSERT INTO engoke_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","And Noach began to be a man working on the earth; and he planted a vineyard, ");
INSERT INTO engoke_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","and he drank of the wine, and was drunk; and he was uncovered in the midst of his tent. ");
INSERT INTO engoke_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","And Cham the father of Kenaan saw the nakedness of his father, and he showed to his two brethren without. ");
INSERT INTO engoke_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","And Shem and Yapheth took a mantle, and laid it upon the shoulders of both, and went backward, and covered the nakedness of their father; and their faces were averted, and the nakedness of their father they saw not. ");
INSERT INTO engoke_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","And Noach awoke from his wine, and knew that which his youngest son had done unto him; ");
INSERT INTO engoke_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","and he said; Accursed be Kenaan, A working servant shall he be to his brethren. ");
INSERT INTO engoke_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","And he said: Blessed be the Lord the God of Shem, And Kenaan shall be servant unto them. ");
INSERT INTO engoke_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","The Lord shall enlarge Yapheth, And He shall make his Shekinah to dwell in the tabernacles of Shem: And Kenaan shall be servant unto them. ");
INSERT INTO engoke_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","And Noach lived after the deluge three hundred and fifty years. ");
INSERT INTO engoke_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","And all the days of Noach were nine hundred and fifty years; and he died. ");
INSERT INTO engoke_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","And these are the generations of the sons of Noach, Shem, Cham, and Yapheth; and sons were born to them after the deluge. ");
INSERT INTO engoke_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Yepheth, Gomer, and Magog, and Madai, and Yavan, and Thuval, and Meshek, and Tiras. ");
INSERT INTO engoke_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","And the sons of Gomer, Ashkenaz, and Rephath, and Thogarmah. ");
INSERT INTO engoke_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","And the sons of Yavan, Elishah and Tharshish, and Dodanim. ");
INSERT INTO engoke_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","From these were the isles (nagvath) of the peoples divided in their lands, each according to his language, according to their families in their nations. ");
INSERT INTO engoke_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","And the sons of Cham, Kush, and Mizraim, and Phut, and Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","And the sons of Kush, Seba, and Chavilah, and Sabetha, and Raamah, and Sabtekah. And the sons of Raamah, Sheba and Dedan. ");
INSERT INTO engoke_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","And Kush begat Nimrod: he began to be a powerful man in the earth. ");
INSERT INTO engoke_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a powerful man before the Lord: therefore it is said, Like Nimrod the man of might before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","And the head (beginning) of his kingdom was Bavel, and Erek, and Akad, and Kalneh in the land of Bavel. ");
INSERT INTO engoke_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From that land he went forth to Athura, and built Nineveh, and the city of Rechov, and Kalach, ");
INSERT INTO engoke_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, between Nineveh and Kalach, which was a great city. ");
INSERT INTO engoke_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","And Mizraim begat the Ludaee, and Anamaee, and Lehabaee, and Naphtuhaee, ");
INSERT INTO engoke_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","and Pathrusaee, and Kasluchaee, from whom came forth the Pelishtaee and Kaputkaee. ");
INSERT INTO engoke_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","And Kenaan begat Zidon his firstborn, and Cheth, ");
INSERT INTO engoke_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","and the Jebusaee, and Amoraee, and Girgashee, ");
INSERT INTO engoke_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","and Hivaaee, and Arkaee, and Antasaee, ");
INSERT INTO engoke_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","and Arvadaee, and Zemaraee, and Chamathaee: and afterwards the seed of the Kenaanaee were scattered abroad. ");
INSERT INTO engoke_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","And the frontier of Kenaanaah was from Zidon, coming to Gerar and to Azza, coming unto Sedom, and Amorah, and Admah, and Zeboim, unto Lasha. ");
INSERT INTO engoke_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are the sons of Cham, according to their progenies, to their languages, in their lands, in their peoples. ");
INSERT INTO engoke_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","And of Shem was born: (also he is the father of all the sons of Eber, and the brother of Yapheth the Great:) ");
INSERT INTO engoke_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem, Elim, and Asshur, and Arphaxad, and Lud, and Aram. ");
INSERT INTO engoke_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","And the sons of Aram, Uz, and Chul, and Gether, and Mash. ");
INSERT INTO engoke_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","And Arphaxad begat Shelach; and Shelach begat Eber. ");
INSERT INTO engoke_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","And to Eber were born two sons: the name of the one was Peleg: because in his day the earth was divided. And the name of his brother was Yoktan. ");
INSERT INTO engoke_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","And Yoktan begat Almodad, and Shaleph, and Chatsarmaveth, and Yarech, ");
INSERT INTO engoke_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","and Chadoram, and Uzal, and Dikelah, ");
INSERT INTO engoke_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","and Obal, and Avimael, and Sheba, ");
INSERT INTO engoke_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","and Ophir, and Chavilah, and Yobab: all these are the sons of Yoktan. ");
INSERT INTO engoke_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","And their dwelling was from Mesha, coming to Sephar, an eastern mountain. ");
INSERT INTO engoke_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the sons of Shem, according to their progenies, according to their languages, in their lands, in their peoples. ");
INSERT INTO engoke_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are the progenies of the sons of Noach, by their generations, in their peoples: and by them were the peoples outspread in the earth after the deluge. ");
INSERT INTO engoke_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","And all the earth was of one language and one speech. ");
INSERT INTO engoke_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","And it was in their migrations at the beginning, that they found a plain in the land of Babel; and dwelt there. ");
INSERT INTO engoke_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","And they said, a man to his companion, Come, let us cast bricks and bake them in the fire. And they had brick for stone, and bitumen for mortar. ");
INSERT INTO engoke_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","And they said, Come, let us build a city, and a tower, the bead of it coming to the pinnacle of the heavens. And we will make to us a name, lest we be dispersed upon the face of all the earth. ");
INSERT INTO engoke_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","And the Lord was revealed to punish the work of the city and the tower which the sons of men had builded. ");
INSERT INTO engoke_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","And the Lord said, Behold, the people are one and the language one with all of them: and this is what they begin to do. And now nothing will be restrained from them of what they imagine to do. ");
INSERT INTO engoke_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, We will be manifest, and will confuse their language there, that a man shall not bear the language of his companion. ");
INSERT INTO engoke_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","And the Lord dispersed them from thence upon the face of all the earth, and they were restrained from building the city. ");
INSERT INTO engoke_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Therefore the name of it is called Confusion, because the Lord there confused the tongue of all the earth, and from thence the Lord dispersed them upon the face of all the earth. ");
INSERT INTO engoke_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","These are the generations of Shem. Shem was a son of a hundred years, and he begat Arphaxad, two years after the deluge. ");
INSERT INTO engoke_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And Shem lived after he had begotten Arphaxad five hundred years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","And Arphaxad lived thirty and five years, and begat Shelach. ");
INSERT INTO engoke_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And Arphaxad lived after he had begotten Shelach four hundred and thirty years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","And Shelach lived thirty years, and begat Eber. ");
INSERT INTO engoke_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And Shelach lived after he had begotten Eber four hundred and three years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","And Eber lived thirty and four years, and begat Peleg. ");
INSERT INTO engoke_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And Eber lived after he had begotten Peleg four hundred and thirty years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","And Peleg lived thirty years, and begat Reu. ");
INSERT INTO engoke_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And Peleg lived after he had begotten Reu two hundred and nine years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","And Reu lived thirty and two years, and begat Serug. ");
INSERT INTO engoke_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And Reu lived after he had begotten Serug two hundred and seven years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","And Serug lived thirty years, and begat Nachor. ");
INSERT INTO engoke_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And Serug lived after he had begotten Nachor two hundred years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","And Nachor lived twenty and nine years, and begat Terach. ");
INSERT INTO engoke_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And Nachor lived after he had begotten Terach a hundred and nineteen years, and begat sons and daughters. ");
INSERT INTO engoke_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","And Terach lived seventy years, and begat Abram, Nachor, and Haran. ");
INSERT INTO engoke_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","And these are the generations of Terach. Terach begat Abram, Nachor, and Haran; and Haran begat Lot. ");
INSERT INTO engoke_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","And Haran died before Terach his father in the land of his nativity, in Ura of the Kasdaee. ");
INSERT INTO engoke_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Abram and Nachor took to them wives: the name of the wife of Abram, Sara; and the name of the wife of Nachor, Milcha, daughter of Haran the father of Milcha and the father of Yiska. ");
INSERT INTO engoke_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","And Sara was barren, she had no child. ");
INSERT INTO engoke_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","And Terach took Abram his son, and Lot the son of Haran, the son of his son, and Sara his daughter-in-law, wife of Abram his son, and went forth with them from Ura of the Kasdaee to go to the land of Kenaan. And they came to Charan, and dwelt there. ");
INSERT INTO engoke_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","And the days of Terach were two hundred and five years, and Terach died in Charan. ");
INSERT INTO engoke_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","And the Lord said to ABRAM, Go thou away from thy country, and from the house of thy father, to the land which I will show thee. ");
INSERT INTO engoke_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","And I will make thee to (be) a great people, and will bless thee, and magnify thy name, and thou shalt be blessed. ");
INSERT INTO engoke_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","And I will bless him who blesseth thee, and him who curseth thee I will curse; and through thee all the progenies of the earth shall be blessed. ");
INSERT INTO engoke_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","And Abram went away, according as the Lord had spoken to him, and Lot went with him. And Abram was a son of seventy and five years in his forthgoing from Charan. ");
INSERT INTO engoke_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Abram took Sara his wife, and Lot his brother’s son, and all the possessions which they possessed, and the souls whom they had made subject to the law in Charan, and went forth to go into the land of Kenaan; and they came unto the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","And Abram traversed through the land unto the place of Shekim unto the plain of Moreh; and the Kenaanah was then in the land. ");
INSERT INTO engoke_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","And the Lord revealed Himself unto Abram, and said, To thy sons will I give this land. And he builded there an altar before the Lord who had been revealed to him. ");
INSERT INTO engoke_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","And he ascended from thence to the mountain east of Beth El, and spread out his tabernacle, having Beth El on the west and Ai on the east; and he builded there an altar before the Lord, and prayed in the name of the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","And Abram migrated, going and migrating to the south. ");
INSERT INTO engoke_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","And there was a famine in the land, and Abram went down to Mizraim, to sojourn there, because the famine was strong in the land. ");
INSERT INTO engoke_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","And it was that as he drew nigh to enter Mizraim he said to Sara his wife, Behold, now I know that thou art a woman beautiful in sight; ");
INSERT INTO engoke_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","And it will be that when the Mizraee see thee they will say, This is his wife; and they will kill me, and thee will they reserve. ");
INSERT INTO engoke_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Say now, thou art my sister, that it may be well with me through thee, and my life may be preserved through thy words. ");
INSERT INTO engoke_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And it was that when Abram had entered into Mizraim, the Mizraee saw the woman that she was singularly fair; ");
INSERT INTO engoke_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","And the princes of Pharaoh saw her, and extolled her to Pharaoh; and the woman was taken to the house of Pharaoh. ");
INSERT INTO engoke_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","And Abram was well treated on account of her. And he had sheep, and oxen, and asses, and servants, and maidens, and camels. ");
INSERT INTO engoke_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","And the Lord brought upon Pharaoh great plagues, and upon the men of his house, for the affair of Sara the wife of Abram. ");
INSERT INTO engoke_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","And Pharaoh called Abram and said, What is this that thou hast done to me? Why didst thou not show me that she is thy wife? ");
INSERT INTO engoke_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why saidst thou, She is my sister, so that I would have taken her to me to wife? And now, behold thy wife: take, and go. ");
INSERT INTO engoke_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","And Pharaoh instructed the men concerning him, and they, conducted him away, and his wife, and all that he had. ");
INSERT INTO engoke_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","And Abram went up from Mizraim, he and his wife, and all that he had, and Lot with him, unto the south. ");
INSERT INTO engoke_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","And Abram was exceeding strong in cattle, in silver, and in gold; ");
INSERT INTO engoke_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","And he proceeded according to his encampments from the south, and unto Bethel, unto the place where he had spread his tabernacle at the first, between Bethel and Ai; ");
INSERT INTO engoke_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","To the place of the altar which he had there made at the first: and Abram prayed there in the Name of the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","And Lot also, who went with Abram, had sheep and oxen and tents. ");
INSERT INTO engoke_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","And the land could not support them, that they might dwell together. ");
INSERT INTO engoke_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","And there was contention between the shepherds of the flock of Abram and the shepherds of the flock of Lot; and the Kenaanah and: the Pherizaah then dwelt in the land. ");
INSERT INTO engoke_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","And Abram said to Lot, Let there not now be contention between me and thee, and between my shepherds and thy shepherds; for men, brethren, are we. ");
INSERT INTO engoke_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not all the land before thee? Separate now from me: if thou to the north, I to the south; and if thou to the south, I to the north. ");
INSERT INTO engoke_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","And Lot lifted up his eyes, and saw all the plain of Yardena that it was altogether a watered place, before the Lord had destroyed Sedom and Amorah, as the garden of the Lord, as the land of Mizraim coming unto Zoar. ");
INSERT INTO engoke_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","And Lot chose to him all the plain of Yardena; and Lot went forth before, and they were separated each man from his brother. ");
INSERT INTO engoke_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram dwelt in the land of Kenaan, and Lot dwelt in the cities of the plain, and extended unto Sedom. ");
INSERT INTO engoke_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","And the men of Sedom were wicked in their riches, and guilty in their bodies before the Lord greatly. ");
INSERT INTO engoke_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","And the Lord said to Abram, after Lot was separated from him, Lift up now thine eyes and see, from the place where thou art, thence to the north and to the south, and to the east and to the west; ");
INSERT INTO engoke_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","For all this land that thou seest, to thee will I give it, and to thy children forever. ");
INSERT INTO engoke_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","And I will place thy children numerous as the dust of the earth; so that as it is not possible for a man to number the dust of the earth, so also thy sons shall not be numbered. ");
INSERT INTO engoke_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Arise, go through the land, in its length and in its breadth; for unto thee will I give it. ");
INSERT INTO engoke_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","And Abram spread (his tent), and came and dwelt in the plain of Mamre which is near Hebron, and builded there an altar before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","And it was in the days of Amraphel, king of Babel, Ariok, king of Elasar, Kedar-laomer, king of Elam, and Thidal, king of peoples, ");
INSERT INTO engoke_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","they made war with Bera, king of Sedom, and with Birsha, king of Amora, Shenab, king of Admah, Shemeber, king of Zeboim, and the king of Bela, which is Zoar. ");
INSERT INTO engoke_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these were assembled at the plain of the field, which is (now) the place of the sea of salt. ");
INSERT INTO engoke_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twelve years they had served Kedar-laomer, and in the thirteenth year they rebelled. ");
INSERT INTO engoke_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","And in the fourteenth year came Kedar-laomer, and the kings who were with him, and smote the giants who were in Ashtaroth Karnaim, and the mighty who were in Chemta, and the terrible ones who were in Shaveh Kiryathaim, ");
INSERT INTO engoke_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horaee who were in the mountain of Seir, unto the plain of Paran which lieth upon the desert. ");
INSERT INTO engoke_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","And they turned, and came to the plain of the division of judgment, which is Rekam, and smote all the fields of the Amalkaah, and also the Amoraah who dwelt in Ein-gadey. ");
INSERT INTO engoke_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","And the king of Sedom, and the king of Amoraah, and the king of Admah, and the king of Zeboim, and tile king of Bela, which is Zoar, went forth and set the battle in array against them in the plain of the field, ");
INSERT INTO engoke_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","with Kedar-laomer king of Elam, and Thidal, king of peoples, and Amraphel, king of Babel, and Ariok, king of Elasar; four kings against five. ");
INSERT INTO engoke_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","And the plain of the field had many pits, from which, they raised asphalta; and the kings of Sedom and Amorah fled, and they fell there; and they who remained fled to the mountain. ");
INSERT INTO engoke_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","And they took all the possession of Sedom and Amorah, and, all their food, and went. ");
INSERT INTO engoke_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","And they captured Lot and his substance, son of the brother of Abram, and went. And he had dwelt in Sedom. ");
INSERT INTO engoke_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","And (one) came from those escaped, and showed to Abram the Ivraah; and he had remained in the plain of Moreh Amoraah, the brother of Eshkol and brother of Aner; and they were Abram’s men of covenant. ");
INSERT INTO engoke_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","And Abram heard that his brother had been captured; and he armed the young men born in his house, three hundred and eighteen, and pursued unto Dan. ");
INSERT INTO engoke_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","And he divided against them by night, he and his servants, and smote them, and pursued them unto Hoba, which was northward of Damasek. ");
INSERT INTO engoke_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","And he recovered all the substance, and Lot also, the son of his brother; and his substance he recovered, the women also, and the people. ");
INSERT INTO engoke_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","And the king of Sedom came out to meet him after returning from the smiting of Kedar-laomer and the kings who were with him, at the plain of Mephana, which was the king’s place of racing. ");
INSERT INTO engoke_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","And Malki-zedek, king of Yerushelem, brought forth bread and wine (chemar), and he was minister (meshamesh) before EL ILLAAH, ");
INSERT INTO engoke_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","and he blessed him, and said: “Blessed be Abram before El Illah, Whose possession is heaven and earth; ");
INSERT INTO engoke_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","And blessed be El Illah (Most High), Who hath delivered thine enemies into thine hand.” And he gave him one in ten of the whole. ");
INSERT INTO engoke_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","And the king of Sedom said to Abram, Give me the souls, and the substance take thou. ");
INSERT INTO engoke_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","And Abram said to the king of Sedom, I have uplifted my hands in prayer before the Lord God most high, whose possession is heaven and earth: ");
INSERT INTO engoke_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","If from a thread unto the sole of a sandal I take of all that is thine, (and not that thou shouldst say, I have enriched Abram,) ");
INSERT INTO engoke_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","except of the food for the young men, and the share of the men who went with me, Amer, Eshkol, and Mamre, these will receive their shares. ");
INSERT INTO engoke_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things the word (pithgama) of the Lord came to Abram in prophecy, saying, Fear not, Abram: My Word (Memra) shall be thy strength, and thy exceeding great reward. ");
INSERT INTO engoke_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","And Abram said, Lord God, what wilt Thou give me, and I go without a child: and this son of business (bar phargama) who is in My house is the Damasekah Elieser? ");
INSERT INTO engoke_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","And Abram said, Behold, Thou hast not given me a child, and, behold, the son of my house is my heir. ");
INSERT INTO engoke_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","And, lo, the word (pithgama) of the Lord was with him, saying, This shall not be thy heir, but a son whom thou shalt beget will be thine heir. ");
INSERT INTO engoke_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","And He led him without, and said, Behold now the heavens, and number the stars, if thou art able to number them; and He said to him, So will be thy sons. ");
INSERT INTO engoke_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","And he believed in the Word of the Lord, (Memra da Yeya,) and He reckoned it to him unto justification. ");
INSERT INTO engoke_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","And He said to him, I am the Lord, who brought thee forth from Ura of the Kasdaee, to give thee this land to inherit it. ");
INSERT INTO engoke_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","And he said, Lord God, by what may I know that I shall inherit it? ");
INSERT INTO engoke_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","And He said to him, Bring Me three calves, and three goats, and three rams, and a turtle dove, and the young of a pigeon. ");
INSERT INTO engoke_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","And he brought before Him all these. And be divided them equally, and set the divisions a division against his fellow; but the birds he did not divide. ");
INSERT INTO engoke_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","And the fowl descended upon the divisions, and Abram drave them away. ");
INSERT INTO engoke_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","And it was sunset, and sleep fell upon Abram: and, lo, a horror of great darkness fell upon him. ");
INSERT INTO engoke_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","And He said unto Abram, Knowing thou shalt know that thy sons will be sojourners (or aliens) in a land not theirs, and they will serve among them; and they will afflict them four hundred years. ");
INSERT INTO engoke_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","And the people whom they will serve I will judge, and go forth with much substance. ");
INSERT INTO engoke_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","And thou shalt be gathered to thy fathers in peace, and shalt be buried in good old age. ");
INSERT INTO engoke_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","And in the fourth age (or generation) they will return hither; because not (yet) complete is the guilt of the Amoraah. ");
INSERT INTO engoke_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","And it was at the going away of the sun, and there was darkness. And behold a furnace that burned, and a flame of fire which passed between those divisions. ");
INSERT INTO engoke_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","In that day the Lord compacted with Abram a covenant, saying, To thy sons will I give this land; from the river of Mizraim unto the great river, the river of Pherat, the Shalmaee, ");
INSERT INTO engoke_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","and the Kenizaee, and the Kadmonaee, ");
INSERT INTO engoke_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","and the Hittaee, and the Pherizaee, and the Gibbaraee, ");
INSERT INTO engoke_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","and the Amoraee, and the Kenaanaee, and the Girgashaee, and the Yebusaee. ");
INSERT INTO engoke_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","And Sara wife of Abram had no child; and she had an handmaid, a Mizretha, and her name was Hagar. ");
INSERT INTO engoke_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","And Sara said to Abram, Behold now, the Lord hath restrained me from childbearing; go in now to my handmaid, if, perhaps, I may have sons from her. And Abram received the word of Sara. ");
INSERT INTO engoke_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","And Sara wife of Abram took Hagar her handmaid, the Mizretha, at the end of ten years of Abram’s dwelling in the land of Kenaan, and gave her to Abram her husband to be his wife; ");
INSERT INTO engoke_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","And he went in unto Hagar, and she conceived, and she saw that she had conceived, and her mistress was despised in her eyes. ");
INSERT INTO engoke_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","And Sara said to Abram, I have (a cause of) judgment against thee. I have given my handmaid to thee, and she seeth that she hath conceived, and I am despised in her eyes: the Lord judge between me and thee. ");
INSERT INTO engoke_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","And Abram said to Sara, Behold, thy handmaid is in thy hand, do to her as is pleasing in thine eyes: and Sara afflicted her, and she fled from before her. ");
INSERT INTO engoke_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","And the Angel of the Lord found her at the fountain of water in the wilderness, at the fountain in the way of Hagra. ");
INSERT INTO engoke_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","And he said, Hagar handmaid of Sara, whence comest thou, and whither art thou going? And she said, From before Sara my mistress do I escape. ");
INSERT INTO engoke_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","And the Angel of the Lord said to her, Return to thy mistress and be subject under her hand. ");
INSERT INTO engoke_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","And the Angel of the Lord said to her: Multiplying I will multiply thy sons, and they shall not be numbered for multitude. ");
INSERT INTO engoke_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","And the Angel of the Lord said to her, Behold, thou hast conceived, and shalt give birth to a son, and thou shalt call his name Yishmael, because the Lord hath heard thy prayer. ");
INSERT INTO engoke_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","And he will be untameable by man, and he will be needy to everyone, and also all men will be needy to him, and before the face of all his brethren will he dwell. ");
INSERT INTO engoke_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","And she prayed in the Name of the Lord who had spoken with her; and she said: Thou art Eloha, seeing all: for she said, I also have begun to see after that He hath been revealed to me. ");
INSERT INTO engoke_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Therefore she called the name of the well, The well at which appeared the Angel of the Covenant: behold, it is between Rekam and Hagra. ");
INSERT INTO engoke_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","And Hagar bare to Abram a son, and Abram called the name of his son whom Hagar bare Yishmael. ");
INSERT INTO engoke_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","And Abram was son of eighty and six years when Hagar bare Yishmael unto Abram. ");
INSERT INTO engoke_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","And Abram was son of ninety and nine years: and the Lord was revealed to Abram, and said to him, I am EI-shadai; serve before Me, and be perfect; ");
INSERT INTO engoke_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","And I will set a covenant between My Word and thee, and I will multiply thee exceedingly much. ");
INSERT INTO engoke_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","And Abram fell on his face: and the Lord spake with him, saying, ");
INSERT INTO engoke_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Behold, I have dedicated My covenant with thee, and thou shalt be the father of many peoples, ");
INSERT INTO engoke_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","and thy name shall no more be called Abram; but thy name shall be Abraham, because the father of many peoples have I appointed (given) thee. ");
INSERT INTO engoke_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","And I will spread thee abroad very greatly, and I will appoint to thee that assemblies and kings who shall rule the peoples, from thee shall come forth. ");
INSERT INTO engoke_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","And I will establish My covenant between My Word and thee, and thy sons after thee unto perpetual generations, to be unto thee a God, and to thy sons after thee. ");
INSERT INTO engoke_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","And I will give to thee and to thy sons after thee the land of thy habitation, all the land of Kenaan, for an everlasting possession; and I will be unto them Eloha. ");
INSERT INTO engoke_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","And the Lord said to Abraham, And thou My covenant shalt keep, thou and thy sons after thee in their generations. ");
INSERT INTO engoke_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is My covenant which you shall keep between My Word and you and thy sons after thee, to circumcise every male that is among you. ");
INSERT INTO engoke_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","And you shall circumcise the flesh of your foreskin, and it shall be for the sign of the covenant between My Word and you. ");
INSERT INTO engoke_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","And the son of eight days shall be circumcised among you; every male in your generations, born in the house, or bought with money, of every son of the peoples, who is not of thy sons, circumcising you shall circumcise ");
INSERT INTO engoke_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","the one born in the house, and him bought with money; and it shall be My covenant in your flesh for a covenant forever. ");
INSERT INTO engoke_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","And the male who is not circumcised in the flesh of his foreskin, that man shall perish from the people (because) he hath made void My covenant. ");
INSERT INTO engoke_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","And the Lord said to Abraham, The name of Sara thy wife shall not be called Sara, for Sarah shall be her name: ");
INSERT INTO engoke_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","And I will bless her, and I will also give thee a son from her; and I will bless her, and assemblies and kings which have dominion over peoples from her shall be. ");
INSERT INTO engoke_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","And Abraham fell upon his face and rejoiced, and said in his heart, Will the son of a hundred years have a child, and Sarah the daughter of ninety years bring forth? ");
INSERT INTO engoke_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","And Abraham said before the Lord, O that Yishmael may be established before thee! ");
INSERT INTO engoke_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","And the Lord said, In verity Sarah thy wife shall bear thee a son, and thou shalt call his name Izhak; and I will establish My covenant with him for an everlasting covenant to his sons after him. ");
INSERT INTO engoke_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","And concerning Yishmael I have accepted thy prayer. Behold, I have blessed him, and I will spread him abroad very greatly. Twelve princes will he beget, and I will set him (as) a great people. ");
INSERT INTO engoke_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But My covenant I will establish with Izhak, whom Sarah shall bear to thee, at this time, in the year following. ");
INSERT INTO engoke_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","And when He had ended to speak with him, the Glory of the Lord ascended up from Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","And Abraham took Yishmael his son, and everyone born in his house, and everyone bought with his money, every male, the men of the house of Abraham, and circumcised the flesh of their foreskin in that very same day when the Lord had spoken with him. ");
INSERT INTO engoke_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","And Abraham was son of ninety and nine years, when he circumcised the flesh of his foreskin. ");
INSERT INTO engoke_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","And Yishmael his son was son of thirteen years, when the flesh of his foreskin was circumcised. ");
INSERT INTO engoke_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","In that same day Abraham was circumcised, and Yishmael his son, ");
INSERT INTO engoke_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","And all the men of his house, (whether) born in his house, or bought with money from the sons of the Gentiles, were circumcised with him. ");
INSERT INTO engoke_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","And the Lord was revealed to him in the Vale of Mamre; and he sat in the door of the tent while the day was hot. ");
INSERT INTO engoke_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","And lie lifted up his eyes and looked, and, behold, three men stood towards him; and he saw, and ran from the door of the tent to meet them, and worshipped upon the earth. ");
INSERT INTO engoke_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","And he said, Lord, if now I have found favour in Thine eyes, pass not, I pray, from Thy servant. ");
INSERT INTO engoke_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Accept now a little water, and wash your feet, and recline under the tree, ");
INSERT INTO engoke_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","and take a mouthful of bread, and strengthen your hearts, afterward you shall pass on; because for this you have come over unto your servant. And He said, So do as thou hast spoken. ");
INSERT INTO engoke_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","And Abraham hastened to the tent to Sarah, and said, Make haste with three seyin of the flour of meal, mix and make cakes. ");
INSERT INTO engoke_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","And to the herd ran Abraham, and took a calf, tender and good, and gave to a young man, and he hastened to dress him. ");
INSERT INTO engoke_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","And he took butter and milk, and the calf which he had prepared, and set before them, and he waited upon them under the tree, and they ate. ");
INSERT INTO engoke_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","And He said to him, Where is Sarah thy wife? And he said, Behold, in the tent. ");
INSERT INTO engoke_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","And He said, Returning I will return to thee, according to the time that you shall revive, and, behold, Sarah thy wife shall have a son. And Sarah heard in the door of the tent, and it was behind Him. ");
INSERT INTO engoke_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","And Abraham and Sarah were old and advanced in days, and with Sarah had ceased to be the way of women. ");
INSERT INTO engoke_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","And Sarah laughed within herself, saying, After that I am old shall I have a child, and my lord (being also) old? ");
INSERT INTO engoke_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","And the Lord said to Abraham, Wherefore laughed Sarah, saying, Can it be in truth that I shall bring forth, and I being old? ");
INSERT INTO engoke_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","What word is hidden from before the Lord? At the time I will return to thee, according to the time that you shall revive, and Sarah shall have a son. ");
INSERT INTO engoke_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","And Sarah denied, saying, I laughed not: for she was afraid. And He said, No, but thou didst laugh. ");
INSERT INTO engoke_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","And the men arose thence, and looked towards the face of Sedom; and Abraham went with them to accompany them. ");
INSERT INTO engoke_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","And the Lord said, Shall I conceal from Abraham what I am doing? ");
INSERT INTO engoke_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","And Abraham shall be indeed a people many and strong, and in him shall all the peoples of the earth be blessed; ");
INSERT INTO engoke_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","because it is manifest before me that he will instruct his children, and the men of his house after him, to keep the ways which are right before the Lord, to do righteousness and judgment; that the Lord may bring upon Abraham that which He hath spoken concerning him. ");
INSERT INTO engoke_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","And the Lord said, The cry of Sedom and Amorah (is heard before Me) because it is great, and the guilt of them is very mighty: ");
INSERT INTO engoke_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will now see, and will judge, whether they do according to the report of them which hath ascended before me. I will deal with them thoroughly unless they convert; but if they convert, I will not punish. ");
INSERT INTO engoke_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","And the men turned away from thence, and went toward Sedom. ");
INSERT INTO engoke_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","And Abraham yet ministered in prayer before the Lord. And Abraham approached, and said, Wilt Thou, in anger, destroy the righteous with the guilty? ");
INSERT INTO engoke_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","If perhaps there be fifty righteous within the city, wilt Thou in anger destroy and not forgive the place for the fifty righteous who are within it? ");
INSERT INTO engoke_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","More true are Thy judgments than that Thou shouldst do a thing like that, to destroy the just with the guilty, and that the just should be as the guilty! Thy judgments are true! Can the Judge of all the earth but do justice? ");
INSERT INTO engoke_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","And the Lord said, If I find in Sedom fifty righteous in the midst of the city, I will spare all the place for their sake. ");
INSERT INTO engoke_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","And Abraham answered and said, Behold, I have done a great thing, to speak before the Lord, and I dust and ashes! ");
INSERT INTO engoke_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Perhaps of the fifty righteous there may be wanting five: shall all the city perish through five? And He said, I will not destroy, if I find there forty and five. ");
INSERT INTO engoke_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","And he added yet to speak before Him, and said, Perhaps forty may be found there. And He said, I will not make the end on account of the forty. ");
INSERT INTO engoke_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","And he said, Let not the anger of the Lord now kindle, and I will speak. Perhaps thirty shall be found there. And He said, I will not make the end if I find there thirty. ");
INSERT INTO engoke_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","And he said, Behold, I have done a great thing to speak before the Lord: perhaps twenty shall be found there. And He said, I will not destroy for the sake of twenty. ");
INSERT INTO engoke_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","And he said, Let not now the anger of the Lord kindle, and I will speak only this time: perhaps ten may be found there. And He said, I will not destroy for the sake of the ten! ");
INSERT INTO engoke_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","And the Glory of the Lord ascended when He had ceased to speak with Abraham, and Abraham returned to his place. ");
INSERT INTO engoke_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","And two angels entered into Sedom in the evening; and Lot sat in the gate of Sedom. And Lot saw, and arose to present himself before them, and he bowed with his face to the earth. ");
INSERT INTO engoke_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","And he said, I pray my lords (ribboni) to turn aside unto the house of your servant and lodge, and wash your feet; and rising early you shall go on your way. And they said, Not so, but in the wide place will we lodge. ");
INSERT INTO engoke_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","And he was greatly in earnest with them, and they turned aside with him, and entered into his house: and he made them a supper, and dressed unleavened cakes for them, and they ate. ");
INSERT INTO engoke_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","As yet they had not slept; and the men of the city, the men of Sedom, gathered against the house, from the youth unto the old man, all the people from the extremes; ");
INSERT INTO engoke_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","And they cried to Lot, and said to him, Where are the men who came to thee tonight? Bring them forth to us, and we will know them. ");
INSERT INTO engoke_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","And Lot went out to them to the gate, and the door he shut after him. ");
INSERT INTO engoke_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","And he said, I pray you, my brethren, do not (so) wickedly. ");
INSERT INTO engoke_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Behold, now, I have two daughters, who have not known man, I would bring them to you, and you should do to them what pleases in your eyes; only to these men do nothing, because they have entered under the shadow of my dwelling. ");
INSERT INTO engoke_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","And they said, Go in, however! And they said, One came to sojourn, and, behold, he judgeth judgment! Now will we do worse to thee than to them; and they prevailed against the man, against Lot, greatly, and came nigh to shatter the door. ");
INSERT INTO engoke_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","And the men put forth their hands, and brought in Lot to be with them in the house, and shut the door. ");
INSERT INTO engoke_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","And the men who were at the gate of the house they smote with blindness, from the little to the great, and they were wearied to find the gate. ");
INSERT INTO engoke_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","And the men said to Lot, Whomsoever thou hast yet here, thy son-in-law, and thy sons, and thy daughters, and all that thou hast in the city, lead out from the place: ");
INSERT INTO engoke_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","For we will destroy this place, because their cry is great before the Lord, and the Lord hath sent us to destroy it. ");
INSERT INTO engoke_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","And Lot went forth, and spake with his sons-in-law, the takers of his daughters, and said, Arise, come forth from this place; for the Lord will destroy the city. And he was as a trifler in the eyes of his sons-in-law. ");
INSERT INTO engoke_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","And it was as the morning rose that the angels were urgent upon Lot, saying, Arise, take thy wife and thy two daughters who are found faithful with thee, lest thou be smitten with the punishment of the city. ");
INSERT INTO engoke_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But he delayed; and the men laid hold of his hands, and of the hand of his wife, and of the hand of his two daughters; for the Lord had mercy upon him; and they brought him forth, and set him without the city. ");
INSERT INTO engoke_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","And it was when he had brought them without, he said, Be merciful on thy life, look not behind thee, and stand not in all the plain, escape to the mountain for deliverance, lest thou perish. ");
INSERT INTO engoke_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","And Lot said to them, Be entreated, O Lord; ");
INSERT INTO engoke_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","behold now, Thy servant hath found mercy before Thee, and Thou hast magnified Thy goodness which Thou hast shown me in saving my life, and I cannot take refuge in the mountain, lest evil befall me, and I die. ");
INSERT INTO engoke_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Behold now, this city is nigh, to flee there; and it is (but) small; let me now escape thither. Is it not small? And my life shall be sustained. ");
INSERT INTO engoke_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","And He said to him, Behold, I have accepted thee in this thing also, in that I will not overthrow the city for which thou hast prayed. ");
INSERT INTO engoke_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haste, escape thither; for I cannot do anything until thou be come thither. Therefore be called the name of the city Zoar. ");
INSERT INTO engoke_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun had come forth upon the earth, and Lot entered Zoar. ");
INSERT INTO engoke_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","And the Lord rained upon Sedom and upon Amorah sulphur and fire from before the Lord from the heavens, ");
INSERT INTO engoke_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","and destroyed those cities and all the plain, and all the dwellers in the cities and the herbage of the earth. ");
INSERT INTO engoke_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","And his wife looked behind her, and she became a statue of salt. ");
INSERT INTO engoke_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","And Abraham ascended in the morning to the place where he had ministered in prayer before the Lord; ");
INSERT INTO engoke_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","And he looked toward Sedom and Amorah, and upon all the place of the plain land, and saw, and, behold, the smoke of the land went up as the smoke of a furnace. ");
INSERT INTO engoke_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","And it was when the Lord destroyed the cities of the plain, that the Lord remembered Abraham, and sent Lot from the midst of the overthrow, when He overthrew the cities in which Lot dwelt. ");
INSERT INTO engoke_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","And Lot went up from Zoar, and dwelt in the mountain, and his two daughters with him: for he feared to dwell in Zoar; and he dwelt in a cavern, he and his two daughters. ");
INSERT INTO engoke_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","And the elder said to the younger, Our father is aged, and there is no man in the earth to go in unto us according to the way of all the earth. ");
INSERT INTO engoke_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, we will pour father wine, and will lie with him, and raise up sons from our father. ");
INSERT INTO engoke_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","And they poured their father wine in that night; and the elder went in and lay with her father; and he knew not, in her lying down nor in her rising up. ");
INSERT INTO engoke_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","And it was in the day which followed that the elder said to the younger, Behold, I lay yesterday with the father: let us give wine also in the night, and go thou in, lie with him, and we will raise up sons from our father. ");
INSERT INTO engoke_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","And they gave that night also wine to their father, and the younger arose and lay with him; and he knew not, in her lying down nor in her rising up. ");
INSERT INTO engoke_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","And the two daughters of Lot conceived from their father; ");
INSERT INTO engoke_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","And the elder brought forth a son, and called his name Moab: he is the father of the Moabaee unto this day. ");
INSERT INTO engoke_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","And the younger also brought forth a son, and she called his name Bar Ammi: he is the father of the B’ni Ammon unto this day. ");
INSERT INTO engoke_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","And Abraham migrated from thence to the southern land, and dwelt between Rekam and Hagra; and he sojourned in Gerar. ");
INSERT INTO engoke_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","And Abraham said of Sarah his wife, She is my sister. And Abimelek, king of Gerar, sent and took Sarah. ");
INSERT INTO engoke_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","And the word came from the presence of the Lord to Abimelek in a dream of the night, and said to him, Behold, thou diest, on account of the woman whom thou hast taken, and she a man’s wife. ");
INSERT INTO engoke_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","But Abimelek had not come nigh her. And he said, Lord, wilt Thou also kill the innocent people? ");
INSERT INTO engoke_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Did he not say to me, She is my sister? And she also said, He is my brother. In the rectitude of my heart, and the cleanness of my bands, have I done this. ");
INSERT INTO engoke_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","And the Lord said to him in a dream, It is also manifest to Me that in the integrity of thy heart thou hast done this, and I have also restrained thee from sinning before Me; therefore I have not permitted thee to approach to her. ");
INSERT INTO engoke_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","And now return the mares wife; for he is a prophet, and he will pray for thee, and thou shalt live. But if thou wilt not return (her), know that dying thou shalt die, thou, and all who are thine. ");
INSERT INTO engoke_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","And Abimelek arose in the morning, and called all his servants, and spake all these words before them; and the men feared greatly. ");
INSERT INTO engoke_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","And Abimelek called Abraham, and said to him, What hast thou done to us, and in what have I sinned against thee, that thou shouldst have brought upon me and upon my kingdom a great sin? Works which are not worthy to be done hast thou done with me. ");
INSERT INTO engoke_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","And Abimelek said to Abraham, What sawest thou, that thou didst this thing? ");
INSERT INTO engoke_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","And Abraham spake, Because I said, Perhaps the fear of the Lord is not in this place, and they will kill me on account of my wife. ");
INSERT INTO engoke_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nevertheless, in truth she is my sister, the daughter of my father, but not the daughter of my mother; and she became my wife. ");
INSERT INTO engoke_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","And it was, when the people erred after the works of their hands, the Lord did bring me near to the fear of Himself, from (among) the house of my father. And I said to her, This is thy favour which thou canst do for me; in every place through which we pass, say of me, He is my brother. ");
INSERT INTO engoke_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","And Abimelek took sheep, and oxen, and servants, and handmaidens, and gave to Abraham, and returned to him Sarah his wife. ");
INSERT INTO engoke_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelek said, Behold, my land is before thee: where it is pleasant in thine eyes, dwell. ");
INSERT INTO engoke_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","And to Sarah he said, Behold, I have given a thousand seleen of silver to thy brother; behold, that is to thee a veil of honour, for my having sent to take thee, and to see thee, and all that is with thee; and concerning all whatever thou hast spoken thou art reproved. ");
INSERT INTO engoke_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","And Abraham prayed before the Lord, and the Lord healed Abimelek, and his wife, and his handmaids, and they were revived: ");
INSERT INTO engoke_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For the Lord had shut all the wombs of the house of Abimelek, on account of Sarah, the wife of Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","And the Lord remembered Sarah as He had said; and the Lord did unto Sarah according as He had spoken. ");
INSERT INTO engoke_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","And Sarah conceived and bare unto Abraham a son in his old age, in the time of which the Lord had told him. ");
INSERT INTO engoke_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","And Abraham called the name of his son who was born to him, whom Sarah bare to him, Izhak. ");
INSERT INTO engoke_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","And Abraham circumcised Izhak his son (when) the son of eight days, as the Lord had commanded him. ");
INSERT INTO engoke_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","And Abraham was the son of a hundred years when Izhak his son was born to him. ");
INSERT INTO engoke_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","And Sarah said, The Lord hath made me to have gladness; everyone who heareth will give me joy. ");
INSERT INTO engoke_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","And she said, Faithful is He who spake unto Abraham, and certified that Sarah should suckle children; for she hath born a son in his old age. ");
INSERT INTO engoke_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","And the child grew, and was weaned; and Abraham made a great feast in the day when Izhak was weaned. ");
INSERT INTO engoke_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","And Sarah observed the son of Hagar the Mizritha, whom she bare to Abraham, deriding. ");
INSERT INTO engoke_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","And she said, Cast out this handmaid and her son; for the son of the handmaid shall not inherit with my son, with Izhak. ");
INSERT INTO engoke_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","And the word was evil exceedingly in the eyes of Abraham, on account of his son. ");
INSERT INTO engoke_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","And the Lord said to Abraham, Let it not be evil in thine eyes concerning the youth and concerning thine handmaid. All that Sarah saith to thee receive from her, because in Izhak shall thy sons be called to thee. ");
INSERT INTO engoke_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","And also the son of the handmaid will I set for a people, because he is thy son. ");
INSERT INTO engoke_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","And Abraham rose up in the morning, and took bread and a skin of water, and gave to Hagar, setting upon her shoulder, and the youth, and dismissed her. And she went, and wandered in the desert of the well of Shava (Beara de Shava). ");
INSERT INTO engoke_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","And the water was finished from the skin; and she laid the youth under one of the trees, ");
INSERT INTO engoke_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","And (she) went and sat over against, as far off as a bow flight: for she said, I cannot see the death of the child. And she sat over against, and lifted up her voice and wept. ");
INSERT INTO engoke_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","And the voice of the youth was heard before the Lord; and the Angel of the Lord called to Hagar from the heavens, and said to her, What to thee, Hagar? Fear not, for the voice of the youth is heard before the Lord in the place where he is. ");
INSERT INTO engoke_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Arise, take up the youth and strengthen thine hand in him, because for a great people have I appointed him. ");
INSERT INTO engoke_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","And the Lord opened her eyes, and she saw the well of waters, and went and filled the skin with water, and gave the youth to drink. ");
INSERT INTO engoke_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","And the Word of the Lord was the Helper of the youth, and he grew and dwelt in the wilderness, and became a master of the bow. ");
INSERT INTO engoke_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","And he dwelt in the wilderness of Paran, and his mother took for him a wife from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","And it was in that time that Abimelek and Phikol, chief of his host, spake to Abraham, saying, The Word of the Lord is thy Helper in everything thou doest; ");
INSERT INTO engoke_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","And now swear to me here, by the Word of the Lord, that thou wilt not be false with me, nor with my son, nor with my son’s son; and that according to the good which I have done to thee thou wilt do with me and with the land in which thou art a sojourner. ");
INSERT INTO engoke_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Abraham said, I will swear. ");
INSERT INTO engoke_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","And Abraham reproved Abimelek, on account of the well of waters which the servants of Abimelek had taken by force. ");
INSERT INTO engoke_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","And Abimelek said, I knew not if this thing had been done, and thou also hadst not shown me, nor have I heard, but this day. ");
INSERT INTO engoke_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","And Abraham took sheep and oxen, and gave to Abimelek, and they struck both of them a covenant. ");
INSERT INTO engoke_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","And Abraham made seven lambs stand apart; and ");
INSERT INTO engoke_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek said to Abraham, What are these seven lambs which thou hast made to stand apart? ");
INSERT INTO engoke_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","And he said, That thou mayest take the seven lambs seven lambs from my hand, to testify for me that I have digged that well. ");
INSERT INTO engoke_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Therefore he called that place Beer Shava, because there they sware together. ");
INSERT INTO engoke_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","And they struck a covenant at Beer Shava. And Abimelek and Phikol, the chief of his host, arose, and returned to the land of the Phelishtaee. ");
INSERT INTO engoke_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","And he planted a tree in Beer Shava, and prayed there in the name of the Lord, the Most High God. ");
INSERT INTO engoke_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","And Abraham sojourned in the land of the Phelislitaee many days. ");
INSERT INTO engoke_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","And it was after these things that the Lord tempted Abraham; and He said to him, Abraham! And he said, Behold, I am. ");
INSERT INTO engoke_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","And He said, Take now thy son, thy only, whom thou lovest, Izhak, and go into the land of worship, and offer him before Me there, a burnt offering, upon one of the mountains which I will tell thee. ");
INSERT INTO engoke_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","And Abraham arose in the morning, and saddled his ass, and took two of his young men with him, and Izhak his son, and clave the wood for the burnt offering, and arose and went to the place of which the Lord had spoken to him. ");
INSERT INTO engoke_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","And in the third day Abraham lifted, up his eyes, and saw the place from afar. ");
INSERT INTO engoke_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","And Abraham said to his young men, Wait you here with the ass, and I and the young man will ascend yonder and worship, and return to you. ");
INSERT INTO engoke_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","And Abraham took the wood of the burnt offering, and laid on Izhak his son; and he took in his hand the fire and the knife, and they went both of them as one. ");
INSERT INTO engoke_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","And Izhak spake to Abraham his father, and said, Father! And he said, Behold, I am, my son. And he said, Behold the fire and the wood; but where is the lamb for the burnt offering? ");
INSERT INTO engoke_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","And Abraham said, The lamb for the burnt offering is revealed before the Lord, my son. And they went, both of them, as one. ");
INSERT INTO engoke_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","And they came to the place of which the Lord had told him. And Abraham builded there the altar, and set in order the woods, and bound Izhak his son, and laid him upon the altar above the woods. ");
INSERT INTO engoke_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","And Abraham stretched forth his hand and took the knife to cut off his son. ");
INSERT INTO engoke_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","And the Angel of the Lord called to him from the heavens, and said, Abraham, Abraham! And he said, Behold, I am. ");
INSERT INTO engoke_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","And he said to him, Stretch not out thy hand upon the youth, neither do anything to him: for now I know that thou fearest the Lord, and that thou hast not spared thy only son for Me. ");
INSERT INTO engoke_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","And Abraham lifted up his eyes after these (words), and saw, and behold, one ram, holden in the bush by his horns. And Abraham went and took the ram, and offered him for a burnt offering instead of his son. ");
INSERT INTO engoke_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Abraham worshipped and prayed there in that place, and said before the Lord, Here shall generations worship: wherefore it shall be paid in that day, In this mountain Abraham worshipped before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","And the Angel of the Lord called to Abraham the second time from the heavens, ");
INSERT INTO engoke_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","And said, By my Word have I sworn, saith the Lord, because thou hast done this thing, and hast not spared thy only son, ");
INSERT INTO engoke_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","therefore, blessing I will bless thee, and multiplying I will multiply thy sons as the stars of heaven and as the sand which is on the sea shore; and thy sons shall inherit the cities of their enemies. ");
INSERT INTO engoke_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","And all the peoples of the earth shall be blessed through thy son: forasmuch as thou hast received My word. ");
INSERT INTO engoke_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","And Abraham returned to his young men, and they arose and went together unto Beer Shava, and Abraham dwelt in Beer Shava. ");
INSERT INTO engoke_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","And it was after these things it was shown to Abraham, saying, Behold, Milcha, also, hath born sons to Nachor, thy brother: ");
INSERT INTO engoke_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uts his first-born, and Booz his brother, and Kemuel the father of Aram, ");
INSERT INTO engoke_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","and Kesed, and Chazu, and Phildash, and Yedlaph, and Bethuel. ");
INSERT INTO engoke_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","And Bethuel begat Revekah. These eight bare Milcha to Nahor, brother of Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","And his concubine, whose name was Reuma, she also bare Tebach, and Gacham, and Tachash, and Maaka. ");
INSERT INTO engoke_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","And the life of Sarah was a hundred and twenty and seven years, the years of the life of Sarah. ");
INSERT INTO engoke_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","And Sarah died in Kiryath-arba, which is Hebron, in the land of Kenaan. And Abraham came to mourn for Sarah, and to lament her. ");
INSERT INTO engoke_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","And Abraham rose up from the presence of his dead, and spake with the sons of Hittah, saying, ");
INSERT INTO engoke_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","I am a guest and a sojourner with you: give me the possession of a sepulchre with you, that I may bury my dead from before me. ");
INSERT INTO engoke_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","And the sons of Hittah answered Abraham, saying to him, ");
INSERT INTO engoke_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Receive from us Ribbona; a prince before the Lord art thou among us; in the best of our sepulchres bury thy dead. No man of us will refuse his sepulchre to thee for the burial of thy dead. ");
INSERT INTO engoke_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","And Abraham rose and bowed to the people of the land, the sons of Hittah. ");
INSERT INTO engoke_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","And he spake with them, saying, If you are willing in your minds that I should bury my dead from before me, receive from me, and request for me of Ephron bar Zochar ");
INSERT INTO engoke_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","That he will give me the Double Cavern, which is in the side of his field: for the full amount (shelim) of silver he shall give it to me among you for the possession of a sepulchre. ");
INSERT INTO engoke_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","But Ephron was sitting in the midst of the sons of Hittah; and Ephron the Hittite answered Abraham before the sons of Hittah, of all entering the gate of the city, saying, ");
INSERT INTO engoke_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","No, my lord; receive of me; I will present to thee the field and the cavern which is in it; to thee will I present it; in sight of the sons of my people will I present it to thee. Bury thy dead. ");
INSERT INTO engoke_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","And Abraham bowed before the people of the land. ");
INSERT INTO engoke_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","And he spake with Ephron before the people of the land, saying, Nevertheless, if thou wilt do me a grace, receive from me; I will give money for the field; take of me, and I will bury my dead there. ");
INSERT INTO engoke_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","And Ephron answered Abraham, saying to him, ");
INSERT INTO engoke_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","My lord, receive of me: the land is worth four hundred sileen of silver; between me and thee what is it? Bury thy dead. ");
INSERT INTO engoke_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","And Abraham agreed with Ephron, and Abraham weighed to Ephron the silver of which be had spoken before the sons of Hittah, four hundred sileen of silver, which is received in merchandise in every city. ");
INSERT INTO engoke_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","And Ephron confirmed the field in which is the double cavern which is before Mamre; the field, and the cavern that is therein, and all the trees which were in the field, in all its boundaries round about, ");
INSERT INTO engoke_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","To Abraham, for a purchase, in the sight of the sons of Hitah, of all entering the gate of the city. ");
INSERT INTO engoke_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","And after this Abraham buried Sarah his wife in the double cavern of the field which is before Mamre, that is Hebron, in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","And the field and the cavern which is in it were confirmed to Abraham for the possession of a sepulchre from the sons of Hittah. ");
INSERT INTO engoke_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","And Abraham was old, (and) advanced in days, and the Lord had blessed Abraham in all things. ");
INSERT INTO engoke_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","And Abraham said to his servant, the elder of his house, who had authority over all which was his, Put now thy hand under my thigh, ");
INSERT INTO engoke_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","And I will adjure thee by the Word of the Lord, the God of heaven and the God of the earth, that thou wilt not take a wife for my son from the daughters of the Kenaanaee among whom I dwell. ");
INSERT INTO engoke_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","But to my country and to my kindred thou wilt go, and take a wife for my son Izhak. ");
INSERT INTO engoke_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","And the servant said to him, Perhaps the woman will not be willing to come after me to this land, returning am I to return thy son to the land from which thou hast gone forth? ");
INSERT INTO engoke_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","And Abraham said to him, Take care that thou return not my son thither; ");
INSERT INTO engoke_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","The Lord, the God of heaven, who took me from the house of my father and from the land of my birth, and who spake to me, and sware to me, saying, I will give thee this land, will send His angel before thee, and thou wilt take a wife for my son from thence. ");
INSERT INTO engoke_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","And if the woman be not willing to come after thee, thou shalt be absolved from this my oath; only cause not my son to return thither. ");
INSERT INTO engoke_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","And the servant put his hand under the thigh of Abraham his master, and sware to him concerning that matter. ");
INSERT INTO engoke_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","And the servant took ten camels of the camels of his lord and went. And all the goods of his master were in his hand. And he arose and went to Aram, which is upon Phrath, the river, to the city of Nachor. ");
INSERT INTO engoke_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","And he made the camels rest without the city at a well of waters in the evening time, at the time when they came forth to fill. ");
INSERT INTO engoke_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","And he said, Lord God of my master Abraham, let it, I pray, be opportune with me this day, and deal thou graciously with my master Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Behold, I stand by the fountain of waters, and the daughters of the men of the city will come forth to draw water. ");
INSERT INTO engoke_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Let the maiden to whom I shall say, Reach thy waterpot, I pray, that I may drink; and she say, Drink, and I will also give thy camels drink, be she whom Thou hast prepared for Thy servant, for Izhak: and in this I shall know that Thou hast dealt graciously with my master. ");
INSERT INTO engoke_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","And it was while he had not ceased to speak that, behold, Revekah came forth, (she) who was born to Bethuel the son of Milcha, wife of Nachor, brother of Abraham, and her pitcher upon her shoulder. ");
INSERT INTO engoke_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","And the maiden was very fair to behold; a virgin, and man had not known her; and she descended to the fountain, and filled her pitcher, and came up. ");
INSERT INTO engoke_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","And the servant hasted to her presence; and said, Let me taste, I pray, a little water from thy pitcher. ");
INSERT INTO engoke_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","And she said, Drink, Ribboni; and she made haste, and held her pitcher upon her hand, and gave him to drink. ");
INSERT INTO engoke_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","And when she had ended giving him drink, she said, For thy camels also I will draw, until they shall have enough to drink. ");
INSERT INTO engoke_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","And she hastened and poured out her pitcher into the place of watering, and ran again to the well to fill, and she filled for all his camels. ");
INSERT INTO engoke_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","And the man wondered at her, gazing silently, to know whether the Lord had prospered his way or not. ");
INSERT INTO engoke_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And it was when the camels had drunk enough, the man took a ring (qadasha) of gold weighing a shekel, and two bracelets (sherin) for the hand weighing ten sileen of gold. ");
INSERT INTO engoke_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","And he said, Whose daughter art thou? Tell me, I pray, whether there be room in thy father’s house sufficient for us to lodge? ");
INSERT INTO engoke_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","And she said to him, I am the daughter of Bethuel, the son of Milcha, whom she bare to Nachor. ");
INSERT INTO engoke_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","And she said to him, There is much straw and provender with us, also room enough to lodge. ");
INSERT INTO engoke_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","And the man kneeled, and worshipped before the Lord, ");
INSERT INTO engoke_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","and said, Blessed be the Lord the God of my master Abraham, who hath not withheld His grace and His truth from my master; and me hath the Lord led in a right way to the house of my master’s brother. ");
INSERT INTO engoke_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","And the maiden ran and showed these things to her mother’s house. ");
INSERT INTO engoke_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","And Revekah had a brother whose name was Laban; and Laban ran to the man without at the fountain. ");
INSERT INTO engoke_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","And it was when he saw the ring and the bracelets upon the hands of his sister, and heard the words of Revekah his sister, saying, As this spake the man with me, that he came to the man, and, behold, he stood by the camels at the fountain; ");
INSERT INTO engoke_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","And he said, Enter, blessed of the Lord; why standest thou without? And I have a prepared house and a proper place for the camels. ");
INSERT INTO engoke_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","And the man entered the house, and he loosed the camels, and gave straw and provender for the camels, and water to wash his feet, and the feet of the men who were with him. ");
INSERT INTO engoke_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","And they set before him to eat. And he said, I will not eat until I have spoken my words. And he said, Speak. ");
INSERT INTO engoke_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","And he said, I am a servant of Abraham; ");
INSERT INTO engoke_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","And the Lord hath blessed my master much, and increased, and hath given to him sheep and oxen, silver and gold, servants and handmaidens, camels and asses. ");
INSERT INTO engoke_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","And Sarah the wife of my master bare a son to my master after she was old, and he hath given to him all that he hath. ");
INSERT INTO engoke_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","And my master adjured me, saying, Thou shalt not take a wife for my son from the daughters of Kenaan in whose land I dwell; ");
INSERT INTO engoke_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","But thou shalt go to my father’s house, and to my kindred, and take a wife for my son. ");
INSERT INTO engoke_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","And I said to my master, Perhaps the woman will not come after me. ");
INSERT INTO engoke_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","And he said to me, The Lord before whom I worship will send His angel with thee, and will prosper thy way, and thou shalt take a wife for my son from my kindred and from my father’s house. ");
INSERT INTO engoke_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Then shalt thou be absolved from my oath when thou hast gone to my kindred: and if they will not give unto thee, thou shalt be absolved from my oath. ");
INSERT INTO engoke_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","And I came this day to the fountain, and I said, Lord God of my master Abraham, if now it is pleasing before thee to prosper the way in which I go, ");
INSERT INTO engoke_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Behold, I stand at the fountain of waters, and a damsel may come forth to fill; and I will say to her, Give me to drink, I entreat, a little water from thy pitcher; ");
INSERT INTO engoke_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","And she shall say to me, Both for thee and thy camels also I will fill, let her be the wife whom the Lord hath ordained for my master’s son. ");
INSERT INTO engoke_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","And I had not left speaking in my heart, when, behold, Revekah came forth, with her pitcher upon her shoulder, and went down to the fountain and filled. And I said to her, Let me now drink. ");
INSERT INTO engoke_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","And she hastened and let down her pitcher, and said, Drink, and I will give thy camels also drink. And I drank, and the camels also she watered. ");
INSERT INTO engoke_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","And I asked her and said, Whose daughter art thou? And she said, I am the daughter of Bethuel, the son of Nachor, whom Milcha bare to him. And I set an ornament on her face, and bracelets upon her hand, ");
INSERT INTO engoke_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","and bowed down and worshipped before the Lord, and blessed the Lord God of my master Abraham who had led me in a true way, to take the daughter of my master’s brother for his son. ");
INSERT INTO engoke_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","And now, if you will act with goodness and truth with my master, show me; and if not, I will turn to the right or to the left. ");
INSERT INTO engoke_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","And Laban answered, and Bethuel, and said, From before the Lord the word hath come forth: we have no power to say to thee either evil or good. ");
INSERT INTO engoke_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Behold, Revekah is before thee; take (her) and go; and let her be the wife of thy master’s son, as the Lord hath spoken. ");
INSERT INTO engoke_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","And it was, when the servant of Abraham heard these words, he worshipped on the earth before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","And the servant brought out vessels of silver and vessels of gold and vestments, and gave to Revekah, and presents gave he to her brother and to her mother. ");
INSERT INTO engoke_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","And they ate and drank, he and the men who were with him, and they lodged and arose in the morning. And he said, Send me to my master. ");
INSERT INTO engoke_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","And her brother said, and her mother, Let the maiden abide with us a season of time, or ten months; after that she shall go. ");
INSERT INTO engoke_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","And he said to them, Keep me not back: the Lord will direct my way, and I will proceed to my master. ");
INSERT INTO engoke_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","And they said, We will call the maiden, and hear what she will say. ");
INSERT INTO engoke_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","And they called Revekah, and said to her, Wilt thou go with this man? And she said, I will go. ");
INSERT INTO engoke_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","And they dismissed Revekah their sister, and her nurse, and the servant of Abraham, and his men. ");
INSERT INTO engoke_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","And they blessed Revekah, and said to her, Thou art our sister; be thou (multiplied) unto thousands and myriads, and may thy children inherit the cities of those who hate them. ");
INSERT INTO engoke_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","And Revekah arose, and her maidens; and they rode upon camels, and went after the man. And the servant took Revekah and went. ");
INSERT INTO engoke_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","And Izhak ascended in coming from the well over which the Angel of Life (malak qayama, “the Eternal Angel”) had appeared; and he dwelt in the land of the south. ");
INSERT INTO engoke_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","And Izhak went forth to pray in the field, at the presence of the evening; and he lifted up his eyes, and looked, and, behold, the camels came. ");
INSERT INTO engoke_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","And Revekah lifted up her eyes, and saw Izhak; and she bowed herself on the camel. ");
INSERT INTO engoke_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","And she said to the servant, Who is the man who is walking in the field to meet us? And the servant said, He is my master. And she took a mantle and covered herself. ");
INSERT INTO engoke_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","And the servant recounted to Izhak all the things which he had done. ");
INSERT INTO engoke_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","And Izhak brought her to the tabernacle: and he saw, and, behold, her works were right as the works of Sarah his mother. And he took Revekah, and she became his wife, and he loved her. And Izhak was comforted after his mother. ");
INSERT INTO engoke_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","And Abraham added, and took a wife, and her name was Keturah; ");
INSERT INTO engoke_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","And she bare to him Zimran, and Yokshan, and Medan, and Midyan, and Yeshbach, and Shuvach. ");
INSERT INTO engoke_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","And Yokshan begat Sheba, and Dedan; and the sons of Dedan have been in camps and tabernacles and islands. ");
INSERT INTO engoke_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","And the sons of Midyan, Eipha, and Epher, and Hanok, and Abidah, and Eldaah: all these the sons of Keturah. ");
INSERT INTO engoke_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","And Abraham gave all that he had unto Izhak. ");
INSERT INTO engoke_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But to the sons of the concubine of Abraham gave Abraham portions, and sent them from his son Izhak, while he yet lived, eastward in the land of the sunrise. ");
INSERT INTO engoke_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","And these are the days of the years of the life of Abraham that he lived, an hundred and seventy and five years. ");
INSERT INTO engoke_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","And Abraham expired, and died in a good old age, aged, and full of days; and he was gathered unto his people. ");
INSERT INTO engoke_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","And Izhak and Ishmael his sons buried him in the twofold cave in the field of Ephron bar Zochar, the Hittah, which is before Mamre; ");
INSERT INTO engoke_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","the field that Abraham bought from the sons of Hittah: there they buried Abraham and Sarah his wife. ");
INSERT INTO engoke_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","And it was after the death of Abraham that the Lord blessed Izhak his son, and Izhak dwelt at the well over which the Eternal Angel had appeared. ");
INSERT INTO engoke_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","And these are the generations of Ishmael bar Abraham, whom Hagar the Mizretha, the handmaid of Sarah, bare to Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","And these are the names of the sons of Ishmael by their names in their generations. The firstborn of Ishmael, Nebaioth; and Kedar, and Adbeel, ");
INSERT INTO engoke_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","and Mibsam, and Mishma, and Duma, and Massa; ");
INSERT INTO engoke_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, and Thema, Yetoor, Naphish, and Kedemah. ");
INSERT INTO engoke_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These are the sons of Ishmael, and these are their names in their villages and their towns, twelve chiefs of their peoples. ");
INSERT INTO engoke_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","And these are the years of the life of Ishmael, a hundred and thirty and seven years. And he expired and died, and was gathered to his people. ");
INSERT INTO engoke_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","And they have dwelt from Havilah unto Hagra, which looketh toward Mizraim, reaching unto Athoor. In the presence of all his brethren he dwelt. ");
INSERT INTO engoke_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","And these are the generations of Izhak bar Abraham. Abraham begat Izhak; ");
INSERT INTO engoke_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","And Izhak was a son of forty years when he took Revekah, the daughter of Bethuel the Aramite of Padan Aram, the sister of Laban the Aramite, to be his wife. ");
INSERT INTO engoke_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","And Izhak prayed before the Lord for his wife, because she was barren; and the Lord hearkened to his prayer, and Revekah his wife conceived. ");
INSERT INTO engoke_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","And the children struggled in her womb; and she said, If thus, why have I conceived? And she went to seek instruction before the Lord: ");
INSERT INTO engoke_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","And the Lord said to her, Two nations are in thy womb, and two kingdoms from thy womb shall be divided, and (one) kingdom (shall be) stronger than (the other) kingdom, and the greater shall be subject to the less. ");
INSERT INTO engoke_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","And her days were fulfilled to give birth. And, behold, twins were in her womb. ");
INSERT INTO engoke_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","And the first came forth red, all of him as a garment (covering) of hair; and they called his name Esau. ");
INSERT INTO engoke_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","And afterwards came forth his brother, and his hand grasped the heel of Esau, and they called his name Jakob. And Izhak was sixty years old when he begat them. ");
INSERT INTO engoke_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","And the youths grew; and Esau was a man of idleness, a man going out into the field; and Jakob was a man of peace, a minister of the house of instruction. ");
INSERT INTO engoke_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","And Izhak loved Esau, because he ate of his hunting, and Rivekah loved Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","And Jakob dressed pottage, and Esau came from the field, and he was faint. ");
INSERT INTO engoke_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","And Esau said to Jakob, Let me taste now of that red, that red! For I am faint: (therefore he called his name Edom:) ");
INSERT INTO engoke_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","and Jakob said, Sell this day thy birthright to me. ");
INSERT INTO engoke_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","And Esau said, Behold, I am going to die, and what is this birthright to me? ");
INSERT INTO engoke_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","And Jakob said, Swear to me today; and he sware to him and he sold his birthright to Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","And Jakob gave to Esau bread and pottage of lentiles. And he ate and drank, and arose, and went: and Esau despised the birthright. ");
INSERT INTO engoke_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","And there was a famine in the land, besides the former famine that was in the days of Abraham; and Izhak went to Abimelek, king of the Philistaee, to Gerar. ");
INSERT INTO engoke_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","And the Lord appeared to him and said, Go not down into Mizraim, remain in the land as I have told thee; ");
INSERT INTO engoke_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Dwell in this land, and My Word shall be to thee for a helper; and I will bless thee. For to thee and to thy son will I give all these lands; and I will confirm the oath that I have sworn to Abraham thy father; ");
INSERT INTO engoke_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","And I will multiply thy son as the stars of heaven, and will give thy son all these lands, and through thy son shall all the peoples of the earth be blessed, ");
INSERT INTO engoke_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","because Abraham obeyed My word, and kept the keeping of My word, My commandments, My covenant, and My law. ");
INSERT INTO engoke_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","And Izhak dwelt at Gerar; ");
INSERT INTO engoke_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","and the men of the place asked respecting his wife. And he said, She is my sister; for he feared to say, My wife, lest the men of the place should kill him on account of Revekah; for she was of beautiful aspect. ");
INSERT INTO engoke_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","And it was when be had been there many days that Abimelek the king of the Philistaee looked from a window, and, behold, Izhak was sporting with Revekah his wife. ");
INSERT INTO engoke_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","And Abimelek called Izhak and said, Nevertheless, behold, she is thy wife: why then hast thou said, She is my sister? And Izhak said to him, Because I said, Lest I be killed on account of her. ");
INSERT INTO engoke_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","And Abimelek said, What is this that thou hast done to us? It might have been that some one of the people had lain with thy wife, and thou wouldst have brought upon us the guilt. ");
INSERT INTO engoke_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","And Abimelek commanded all the people saying, Whoever injureth this man shall surely be put to death. ");
INSERT INTO engoke_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","And Izhak sowed in the land, and found in that year a hundred fold on that which he had expended, (or estimated,) and the Lord blessed him; ");
INSERT INTO engoke_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","And the man increased, and went on multiplying and increasing, until he had increased greatly. ");
INSERT INTO engoke_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","And he had flocks of sheep, and herds of cattle, and many servants; and the Philistaee were envious of him. ");
INSERT INTO engoke_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","And all the wells that the servants of his father had digged in the days of Abraham the Philistaee stopped up, and filled with dust. ");
INSERT INTO engoke_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","And Abimelek said to Izhak, Go from us; for thou art much stronger than we. ");
INSERT INTO engoke_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","And Izhak went thence, and sojourned in the vale of Gerar, and dwelt there. ");
INSERT INTO engoke_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","And Izhak returned, and digged the well of water which they had digged in the days of Abraham his father, and which the Philistaee had stopped after the death of Abraham; and he called their names after the names by which his father had called them. ");
INSERT INTO engoke_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","And the servants of Izhak digged in the valley, and found there a well of flowing waters. ");
INSERT INTO engoke_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","And the shepherds of Gerar strove with the shepherds of Izhak, saying, The water is ours; and he called the name of the well Contention, because they had contended with him. ");
INSERT INTO engoke_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","And they digged another well, and they strove also on account of it, and he called the name of it Hatred. ");
INSERT INTO engoke_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","And he went up from thence, and digged another well; and for that they strove not: and he called the name of it Spaciousness. For he said, Because now hath the Lord enlarged us, and we shall spread abroad in the land. ");
INSERT INTO engoke_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","And he went up from thence to Beer Shava; ");
INSERT INTO engoke_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","and the Lord appeared to him in the night, and said, I am the God of Abraham thy father; fear not: for in thy help is My Word; and I will bless thee, and will multiply thy sons for the sake of Abraham My servant. ");
INSERT INTO engoke_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","And he builded there an altar, and prayed in the name of the Lord. And he spread there his tabernacle; and the servants of Izhak digged there a well. ");
INSERT INTO engoke_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","And Abimelek came to him from Gerar, and a company of his friends, and Phikol the chief of his host. ");
INSERT INTO engoke_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","And Izhak said to him, Why have you come to me, when you have hated me, and sent me from you? ");
INSERT INTO engoke_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","And they said, Seeing we have seen that the Word of the Lord is for thy help; and we have said, Let the oath which was between our fathers be now confirmed between us and thee, and let us enter into a covenant with thee, ");
INSERT INTO engoke_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","that thou do us no evil, as we have not injured thee, and as we have done thee only good, and we will leave thee in peace; thou art now blessed of the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","And he made them a feast, and they ate and drank. ");
INSERT INTO engoke_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","And they arose in the morning and covenanted, each man with his brother; and Izhak dismissed them, and they went from him in peace. ");
INSERT INTO engoke_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","And it was in that day that the servants of Izhak came and showed him concerning the well that they had digged. And they said to him, We have found water. ");
INSERT INTO engoke_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","And he called it Sheva, (the swearing). Wherefore the name of the city is Beer-sheva unto this day. ");
INSERT INTO engoke_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","And Esau was the son of forty years, and he took to wife Jehudith, daughter of Beeri the Hittite, and Basemath, daughter of Elon the Hittite; ");
INSERT INTO engoke_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","And they were rebels and irritators against the word of Izhak and Revekah. ");
INSERT INTO engoke_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","And it was, when Izhak was old, and his eyes were darkened from seeing, that he called Esau, his eldest son, and said to him, My son. And he said to him, Behold, I am. ");
INSERT INTO engoke_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","And he said, Behold now, I am old, I know not the day that I shall die: ");
INSERT INTO engoke_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","And now take thy weapons, thy knife and thy bow, and go out into the field, and hunt me venison, ");
INSERT INTO engoke_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","And make me food I such as I like, and bring it to me, and I will eat, and my soul shall bless thee before I die. ");
INSERT INTO engoke_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","And Revekah listened as Izhak was speaking with his son Esau. And Esau went into the field to hunt venison to bring it. ");
INSERT INTO engoke_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","And Revekah spake to Jakob, her son, saying, Behold, I have heard thy father speaking with Esau thy brother, saying, ");
INSERT INTO engoke_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bring me now venison, and make me food, and I will eat and bless thee in the presence of the Lord before I die. ");
INSERT INTO engoke_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","And now, my son, obey me in what I command thee. ");
INSERT INTO engoke_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go now to the flock, and take thee from thence two good goat-kids, and make them into food for thy father such as he loves, ");
INSERT INTO engoke_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","And carry in to thy father, that he may eat, and bless thee before he die. ");
INSERT INTO engoke_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","And Jakob said to Revekah his mother, Behold, Esau my brother is a hairy man, and I am a smooth man. ");
INSERT INTO engoke_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","It may be that my father will feel me, and I shall be in his eyes as a deceiver, and shall bring upon me curses, and not blessings. ");
INSERT INTO engoke_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","And his mother said to him, Unto me it hath been said in prophecy, that there shall be no curses upon thee, my son; only obey me, and go, and take for me. ");
INSERT INTO engoke_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","And he went, and took, and brought to his mother, and his mother made food such as his father loved. ");
INSERT INTO engoke_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","And Revekah took the vestments of Esau her elder son, (which were) clean, and were with her in the house, and clothed Jakob her younger son. ");
INSERT INTO engoke_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","And with the skins of the kids she covered his hands, and upon the smoothness of his neck. ");
INSERT INTO engoke_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","And she gave the food and the bread that she had made into the hand of Jakob her son. ");
INSERT INTO engoke_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","And he went in to his father, and said, Father! And he said, Behold me. Who art thou, my son? ");
INSERT INTO engoke_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","And Jakob said to his father, I am Esau, thy firstborn: I have done as thou hast told me. Arise now, turn thyself, and eat of my venison, that thy soul may bless me. ");
INSERT INTO engoke_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","And Izhak said to his son, What is this, thou hast so quickly found, my son? And he said, Because the Lord thy God prepared it before me. ");
INSERT INTO engoke_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","And Izhak said to Jakob, Draw near now, and I will feel thee, my son, whether thou be my son Esau or not. ");
INSERT INTO engoke_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","And Jakob drew near to Izhak his father, and he felt him, and said, The voice is the voice of Jakob; but the hands are the hands of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","And he could not be known, because his hands were hairy, like the hands of Esau his brother; and he blessed him. ");
INSERT INTO engoke_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","And he said, But art thou my son Esau? And he said, I am! ");
INSERT INTO engoke_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","And he said, Bring before me, and I will eat of my sons venison, that my soul may bless thee. And he offered to him, and he did eat; and he brought him wine, and he drank. ");
INSERT INTO engoke_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","And Izhak his father said to him, Approach now, and kiss me, my son. ");
INSERT INTO engoke_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","And he approached, and kissed him, and he smelled the fragrance of his vestments, and blessed him, and said, Lo, the smell of my son is as the fragrance of a field which the Lord hath blessed. ");
INSERT INTO engoke_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","And the Lord shall give thee of the dew of heaven, and of the goodness of the earth, and abundance of corn and of wine. ");
INSERT INTO engoke_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Let the peoples serve thee, and kingdoms be subservient to thee: be thou chief of thy brethren, and let the sons of thy mother worship thee: cursed shall they be who curse thee, and blessed shall they be who bless thee! ");
INSERT INTO engoke_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","And it was when Izhak had completed to bless Jakob, and Jakob had, going, only gone out from Izhak his father, that Esau his brother came in from his hunting. ");
INSERT INTO engoke_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","And he had also made food, and he brought it to his father, and said to his father, Arise, my father, and eat of thy son’s venison, that thy soul may bless me. ");
INSERT INTO engoke_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","And Izhak his father said to him, Who art thou? And he said, I am thy son, thy firstborn, Esau. ");
INSERT INTO engoke_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","And Izhak was wonderstruck with exceeding great wonder, and said, Who was he who prepared venison, and brought it to me, and I have eaten of all before thou camest, and I have blessed him? And blessed shall he be. ");
INSERT INTO engoke_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard the words of his father, he cried a cry, great and bitter exceedingly. And he said to his father, Bless me, also, me, father! ");
INSERT INTO engoke_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","And he said, Thy brother came with subtilty, and hath received thy blessing. ");
INSERT INTO engoke_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","And he said, Rightly is his name called Jakob, he hath dealt subtilly with me these two times; my birthright he took, and, behold, now he hath received my blessing. And he said, Hast thou not left me a blessing? ");
INSERT INTO engoke_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","And Izhak answered, and said to Esau, Behold, I have set him a chief over thee, and all his brethren I have given to him for servants, and with corn and wine have I sustained him: and for thee now what can I do, my son? ");
INSERT INTO engoke_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","And Esau said to his father, Hast thou but one blessing, father? Bless me, me also, my father. And Esau lifted up his voice and wept. ");
INSERT INTO engoke_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","And Izhak his father answered and said to him, Behold, thy habitation shall be of the best of the earth, and of the dew of heaven from above. ");
INSERT INTO engoke_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","And by thy sword shalt thou live, and thy brother obey; and it will be that when his sons shall have transgressed the words of the law, thou wilt cast his yoke from off thy neck. ");
INSERT INTO engoke_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","And Esau kept enmity towards Jakob for the blessing wherewith his father had blessed him. And Esau said in his heart, The days of mourning for father draw near and I wilt kill Jakob my brother. ");
INSERT INTO engoke_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","And the words of Esau her eldest son were shown to Revekah, and she sent and called Jakob her younger son, and said to him, Behold, Esau thy brother plotteth against thee to kill thee. ");
INSERT INTO engoke_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","And now, my son, receive from me, and arise and go to Laban my brother at Haran, ");
INSERT INTO engoke_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","And dwell with him a few days, until thy brother’s wrath turn away, ");
INSERT INTO engoke_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Until the anger of thy brother turn from thee, and what thou hast done to him be forgotten; and I will send and bring thee thence. Why should I be bereaved of both of you in one day? ");
INSERT INTO engoke_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","And Revekah said to Izhak, I am grieved in my life at the sight of the daughters of Hittah. If Jakob take a wife of the daughters of Hittah, like these of the daughters of the land, what to me is life? ");
INSERT INTO engoke_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","And Izhak called Jakob and blessed him. And he commanded him, and said to him, Thou shalt not take a wife from the daughters of Kenaan; ");
INSERT INTO engoke_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Arise, go to Padan Aram to the house of Bethuel the father of thy mother, and take to thee from thence a wife of the daughters of Laban, the brother of thy mother. ");
INSERT INTO engoke_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","And the All-sufficient God bless thee, and make thee to increase and multiply, and become an assemblage of tribes; ");
INSERT INTO engoke_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","And give the blessing of Abraham to thee and thy sons with thee, that thou mayest inherit the land of thy habitation which the Lord gave to Abraham. ");
INSERT INTO engoke_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","And Izhak sent Jakob away, and he went to Padan Aram to Laban bar Bethuel, the Aramite, the brother of Revekah, the mother of Jakob and Esau. ");
INSERT INTO engoke_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","And Esau, when he saw that Izhak had blessed Jakob, and sent him to Padan Aram to take from thence a wife, and, as he blessed him, commanded him, saying, Thou shalt not take a wife from the daughters of Kenaan, ");
INSERT INTO engoke_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","and that Jakob had obeyed his father and his mother, and had gone to Padan Aram, ");
INSERT INTO engoke_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau, considering that the daughters of Kenaan were evil in the eyes of Izhak his father, ");
INSERT INTO engoke_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","went to Ishmael, and took Mahalath, daughter of Ishmael bar Abraham, the sister of Nebaioth, over his wives, unto him to wife. ");
INSERT INTO engoke_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","And Jakob went forth from Beersheva, and went to Haran; ");
INSERT INTO engoke_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","and he arrived at a place, and lodged there, because the sun had gone. And he took of the stones of the place, and set his pillow, and lay down in that place. ");
INSERT INTO engoke_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","And he dreamed: and, behold, a ladder was planted in the earth, and the head of it reached unto the height of heaven; and, behold, the angels of the Lord ascended and descended upon it; ");
INSERT INTO engoke_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","and, behold, the Glory of the Lord stood above it, and He said, I am the God of Abraham thy father, and the God of Izhak. The land where thou sleepest, unto thee will I give it, and unto thy sons. ");
INSERT INTO engoke_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","And thy sons shall be many as the dust of the earth, and shall prevail to the west and to the east, and to the north and to the south; and through thee shall all the kindreds of the earth be blessed, and through thy sons. ");
INSERT INTO engoke_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","And, behold, My Word shall be for thy help, and I will keep thee in every place whither thou goest, and I will bring thee again to this land; for I will not leave thee until I have done what I say to thee. ");
INSERT INTO engoke_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","And Jakob awoke from his sleep, and said, Verily the Glory of the Lord dwelleth in this place, and I knew it not. ");
INSERT INTO engoke_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","And he feared and said, How awful is this place! This place is not common (ground), but a place where there is pleasantness before the Lord; and this is nigh the gate of heaven. ");
INSERT INTO engoke_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","And Jakob rose up early in the morning, and took the stone which he had set for his pillow, and set it up, a pillar, and poured oil upon the top of it. ");
INSERT INTO engoke_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","And he called the name of that place The House of God (Bethel). But Luz was the name of the city at the first. ");
INSERT INTO engoke_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","And Jakob vowed a vow, saying, If the Word of the Lord will be my help, and will keep me in that way in which I go, and will give me bread to eat, and raiment to wear, ");
INSERT INTO engoke_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","and bring me again in peace to the Lord shall be my God. ");
INSERT INTO engoke_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","And at this stone which I have set up (as) a pillar, will I worship before the Lord; and of all that Thou shalt give me, the tenth will I separate before Thee. ");
INSERT INTO engoke_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","And Jakob lifted up his feet, and came to the land of the children of the East. ");
INSERT INTO engoke_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","And he looked, and saw a well in a field; and, behold, three flocks of sheep lying near it, because from that well they watered the flocks; and a great stone was upon the mouth of the well. ");
INSERT INTO engoke_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","And thither all the flocks were gathered together; and they withdrew the stone from the mouth of the well, and watered the flock, and returned the stone upon the mouth of the well unto its place. ");
INSERT INTO engoke_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","And Jakob said to them, My brethren, whence are you? And they said, We are from Haran. ");
INSERT INTO engoke_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","And Jakob said to them, Know you Laban bar Nachor? And they said, We know. ");
INSERT INTO engoke_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","And he said, Hath he peace? And they said, Peace; and, behold, Rahel his daughter cometh with the flock. ");
INSERT INTO engoke_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","And he said, Behold, the day is yet great, it is not time to gather the cattle; water the sheep, and go to the pasture. ");
INSERT INTO engoke_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","And they said, We cannot till all the flocks are gathered, and we remove the stone from the mouth of the well, and water the flock. ");
INSERT INTO engoke_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he spake with them, Rahel came, with the flock of her father; for she was a shepherdess. ");
INSERT INTO engoke_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","And it was, when Jakob saw Rahel the daughter of Laban, the brother of his mother, and the flock of Laban the brother of his mother, that Jakob went near, and withdrew the stone from the well’s mouth, and watered the flock of Laban, his mother’s brother. ");
INSERT INTO engoke_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","And Jakob kissed Rahel, and lifted up his voice and wept. ");
INSERT INTO engoke_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","And Jakob showed Rahel that he was the son of her father’s sister, and that he was the son of Revekah. And she ran and showed to her father. ");
INSERT INTO engoke_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","And it was when Laban heard the hearing of Jakob the son of his sister, that he ran to meet him, and embraced him, and kissed him, and brought him into his house; and he narrated to Laban all these words. ");
INSERT INTO engoke_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","And Laban said to him, Thou art, however, my near (kinsman), and thou art my flesh. And he abode with him a month of days. ");
INSERT INTO engoke_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","And Laban said to Jakob, Because thou art my brother, shalt thou serve me for nothing? Tell me, what shall be thy wages? ");
INSERT INTO engoke_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","And Laban had two daughters, the name of the elder Leah, and the name of the younger Rahel. ");
INSERT INTO engoke_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","And the eyes of Leah were beautiful; but Rahel was admirable in form, and beautiful in aspect. ");
INSERT INTO engoke_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","And Jakob loved Rahel, and he said, I will serve thee seven years for Rahel thy younger daughter. ");
INSERT INTO engoke_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","And Laban said, It is better that I give her to thee than give her to another man; reside with me. ");
INSERT INTO engoke_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","And Jakob served for Rahel seven years; and they were in his eyes as a few days, inasmuch as he loved her. ");
INSERT INTO engoke_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","And Jakob said to Laban, Give me my wife; for the days of my service are fulfilled, and I will go to her. ");
INSERT INTO engoke_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","And Laban assembled all the men of the place, and made a feast. ");
INSERT INTO engoke_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","And it was in the evening, that he took Leah his daughter, and introduced her to him, and he entered to her. ");
INSERT INTO engoke_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","And Laban gave her Zilpha his handmaid unto Leah his daughter, to attend on her. ");
INSERT INTO engoke_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","And it was in the morning, and, behold, she was Leah! And he said to Laban, What is this that thou hast done to me? Was it not for Rahel that I served thee? And why hast thou been false with me? ");
INSERT INTO engoke_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","And Laban said, It is not so done in our place, to give the younger before the elder. ");
INSERT INTO engoke_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Fulfil this week, and I will give thee also that, for the service that thou shalt serve with me yet seven other years. ");
INSERT INTO engoke_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","And Jakob did so, and fulfilled the week of this; and he gave him Rahel his daughter to be his wife. ");
INSERT INTO engoke_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","And Laban gave to Rahel his daughter Bilhah her handmaid to wait upon her. ");
INSERT INTO engoke_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","And he went in also to Rahel, and he loved Rahel more than Leah. And he served yet with him seven other years. ");
INSERT INTO engoke_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","And the Lord saw that Leah was hated, and He gave her to conceive, but Rahel was barren. ");
INSERT INTO engoke_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","And Leah conceived and bare a son, and she called his name Reuben; for she said, Because my affliction was manifest before the Lord; for now will my husband love me. ");
INSERT INTO engoke_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","And she conceived again and bare a son, and she said, Because it was heard before the Lord that I had hatred, and He gave me this also; and she called his name Shemeon. ");
INSERT INTO engoke_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","And she conceived again and bare a son: and she said, This time will my husband adhere to me; for I have born him three sons: therefore she called his name Levi. ");
INSERT INTO engoke_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","And she conceived again and bare a son; and she said, This time will I give praise before the Lord: therefore she called his name Jehudah. And she ceased (stood) from bearing. ");
INSERT INTO engoke_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","And Rahel saw that she did not bear unto Jakob; and Rahel envied her sister, and she said to Jakob, Give me children; and if not, I die. ");
INSERT INTO engoke_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","And the anger of Jakob was incensed against Rahel, and he said, Why ask of me? Is it not before the Lord that thou shouldest ask, who hath denied thee the generation of the womb? ");
INSERT INTO engoke_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","And she said, Behold my handmaid Bilhah, go in unto her, and she shall bear, and I also shall nourish (children), and be builded up from her. ");
INSERT INTO engoke_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","And she gave him Bilhah her handmaid to wife; and Jakob went in unto her, ");
INSERT INTO engoke_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","and Bilhah conceived, and bare to Jakob a son. ");
INSERT INTO engoke_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","And Rahel said, The Lord hath judged me, and hath also received my prayer, and given me a son: therefore she called his name Dan. ");
INSERT INTO engoke_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","And Bilhah the handmaid of Rahel conceived again, and bare a second son to Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","And Rahel said, The Lord hath received my request: when I entreated in my prayer, I desired that I might have offspring as my sister, and also it is given me. And she called his name Naphtali. ");
INSERT INTO engoke_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","And Leah saw that she had ceased from bearing, and she took Zilpha her handmaid, and gave her to Jakob to wife. ");
INSERT INTO engoke_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","And Zilpha the handmaid of Leah bare a son to Jakob, ");
INSERT INTO engoke_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","and Leah said, There cometh prosperity; and she called his name Gad. ");
INSERT INTO engoke_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","And Zilpha the handmaid of Leah bare a second son to Jakob; ");
INSERT INTO engoke_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","And Leah said, Praise shall be mine; now will women praise me; and she called his name Asher. ");
INSERT INTO engoke_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","And Reuben went in the days of wheat harvest, and found mandrakes in the field, and he brought them to Leah his mother. And Rahel said to Leah, Give me now of thy son’s mandrakes. ");
INSERT INTO engoke_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","And she said to her, Is it a little that thou hast taken my husband, and thou wilt take also my son’s mandrakes? And Rahel said, Therefore shall he lie with thee at night for thy son’s mandrakes. ");
INSERT INTO engoke_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","And Jakob came in from the field at evening, and Leah went out to anticipate him, and said, With me thou wilt go in, because with hire have I hired thee, with the mandrakes of my son; and he lay with her that night. ");
INSERT INTO engoke_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","And the Lord received the prayer of Leah, and she conceived, and bare to Jakob a fifth son. ");
INSERT INTO engoke_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","And Leah said, The Lord hath given me my reward, because I gave my handmaid to my husband. And she called his name Issakar. ");
INSERT INTO engoke_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","And Leah conceived again, and bare a sixth son to Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","And Leah said, The Lord hath given me a good portion. This time will the habitation of my husband be with me, because I have born him six sons: therefore she called his name Zebulon. ");
INSERT INTO engoke_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","And afterward she bare a daughter, and called her name Dinah. ");
INSERT INTO engoke_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","And the remembrance of Rahel came before the Lord, and the Lord received her prayer, and gave her to conceive. ");
INSERT INTO engoke_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","And she conceived and bare a son, and she said, The Lord hath taken up my reproach. ");
INSERT INTO engoke_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","And she called his name Joseph, saying, The Lord shall add to me another son. ");
INSERT INTO engoke_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","And it was when Rahel had born Joseph, that Jakob said to Laban, Send me away, that I may go to my place, and to my land. ");
INSERT INTO engoke_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and my children, for whom I have served thee, that I may go: for thou knowest the service with which I have served thee. ");
INSERT INTO engoke_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","And Laban said to him, If now I have found grace in thine eyes, I have proved that the Lord hath blessed me for thy sake. ");
INSERT INTO engoke_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","And he said, Certify thy wages with me, and I will give. ");
INSERT INTO engoke_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","And he said to him, Thou knowest how I have served thee, and what thy flocks have been with me; ");
INSERT INTO engoke_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","For thou hadst few before me, and they have increased into a multitude: and the Lord hath blessed thee for my sake. But now, what shall I do also for my (own) house? ");
INSERT INTO engoke_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","And he said, What shall I give thee? And Jacob said, Thou shalt not give me anything; but if thou wilt do with me this matter, I will return, and, pasturing thy flocks, will keep (them). ");
INSERT INTO engoke_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I will pass through all thy flocks today, and set apart from them every lamb streaked and speckled, and every black lamb among the lambs, and the streaked and speckled among the goats, and they shall be my wages. ");
INSERT INTO engoke_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","And my righteousness shall be testified in the day following, when thou wilt come upon my reward that shall be before thee: everyone which is not streaked or speckled among the goats, and black among the lambs, that shall be (as if) stolen by me. ");
INSERT INTO engoke_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","And Laban said, Let it be according to thy word. ");
INSERT INTO engoke_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","And he set apart that day the he goats of various colour, and all the goats which were speckled or spotted, everyone which had (some) white in him, and all that were black among the lambs: and he gave them into the hand of his sons. ");
INSERT INTO engoke_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","And he set a walk of three days between them and Jakob; and Jakob pastured the flock of Laban which remained. ");
INSERT INTO engoke_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","And Jakob took to him rods of white poplars, and of almond, (or hazel,) and of plane tree, and peeled in them white peelings, (so that, where) peeled, the white which was in the rods appeared. ");
INSERT INTO engoke_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","And he fixed the rods that he had peeled in the canals, in the place of the watering of waters, the place to which they brought the flocks to drink, to be over against the flocks, that they might be incited when they came to drink. ");
INSERT INTO engoke_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","And the sheep were incited before the rods, and the sheep brought forth with chequered feet and streaked. ");
INSERT INTO engoke_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","And Jakob separated the lambs, and set before the sheep which were various coloured and all that were black among the sheep of Laban; and placed them for himself a flock apart, not mixing them with the sheep of Laban. ");
INSERT INTO engoke_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","And it was that whenever the early (prime) sheep conceived, Jakob placed the rods before the eyes of the sheep in the canals, that they might conceive before the rods: but before the late sheep he did not place them. ");
INSERT INTO engoke_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","And (so) the late ones were Laban’s, and the prime ones Jacob’s. ");
INSERT INTO engoke_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","And the man increased very greatly, and had a multitude of flocks, and handmaids, and servants, and camels, and asses. ");
INSERT INTO engoke_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","And he heard the words of Laban’s sons, saying, Jacob hath taken all that was our father’s; and of that which was our father’s he hath gotten all these possessions. ");
INSERT INTO engoke_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","And Jakob saw the looks of Laban, and, behold, they were not with him as yesterday, and the time before. ");
INSERT INTO engoke_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","And the Lord said to Jacob, Return to thy country and to thy native (place): and My Word shall be for thy help. ");
INSERT INTO engoke_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","And Jacob sent and called Rahel and Leah to the field with his flocks: ");
INSERT INTO engoke_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","And he said to them, I see the looks of your father, that they are not with me as yesterday and the time before; and the God of my father hath been to my help. ");
INSERT INTO engoke_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","And you know that with all my strength I have served your father; ");
INSERT INTO engoke_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","But your father hath lied to me, and hath changed my wages ten times; but the Lord hath not permitted him to hurt me. ");
INSERT INTO engoke_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If now he said, The streaked shall be thy wages; then all the flock bare streaked: and if now he said, The chequered shall be thy wages; all the flock bare chequered. ");
INSERT INTO engoke_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","And the Lord hath separated them from the cattle of your father, and hath given (them) to me. ");
INSERT INTO engoke_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","And it was at the time when the flocks conceived, I lifted up my eyes, and saw in a dream, and, behold, the rams which leaped upon the flock were chequered, streaked, and speckled. ");
INSERT INTO engoke_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","And the angel of the Lord said to me in a dream, Jacob. And I said, Behold, I am. ");
INSERT INTO engoke_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","And he said, Lift up now thine eyes, and see, all the rams which leap upon the flock are chequered, streaked, and speckled: because all that Laban hath done to thee is manifest before Me. ");
INSERT INTO engoke_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am Eloha, who appeared to thee at Bethel, where thou didst anoint the pillar, and where before Me thou didst swear the oath: arise now, go from this land, and return to the land of thy birth. ");
INSERT INTO engoke_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","And Rahel and Leah answered and said to him, Have we yet a portion or inheritance in our father’s house? ");
INSERT INTO engoke_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Are we not accounted as strangers by him? For he hath sold us, and hath devoured our money also. ");
INSERT INTO engoke_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Therefore, all the wealth that the Lord hath separated from our father is ours and our children’s: and now all that the Lord hath said to thee, do. ");
INSERT INTO engoke_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","And Jakob arose, and lifted up his sons and his wives upon camels; ");
INSERT INTO engoke_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","And led all his herds and all his substance which he had obtained, his herds and his substance which he had obtained in Padan Aram, to go unto Izhak his father in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","And Laban had gone to shear his flock: and Rahel took the images that were her father’s. ");
INSERT INTO engoke_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","And Jakob concealed from Laban the Aramite, and showed him not that he went. ");
INSERT INTO engoke_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","And he went, he and all that were his; and he arose and passed the Phrat, and set his face toward the mountain of Gilead. ");
INSERT INTO engoke_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","And it was shown to Laban on the third day that Jakob had gone. ");
INSERT INTO engoke_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","And he took his brethren with him, and Pursued after him; going seven days; and he overtook him in the Mountain of Gilead. ");
INSERT INTO engoke_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","And a word came from before the Lord to Laban the Aramite in a dream of the night, and He said to him, Beware, lest thou speak with Jakob from good to evil. ");
INSERT INTO engoke_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","And Laban overtook Jakob; and Jakob had spread his tent in the mountain; and Laban made his brethren abide in the mountain of Gilead. ");
INSERT INTO engoke_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","And Laban said to Jacob; What hast thou done, that thou hast hidden from me, and taken away my daughters, as captives of the sword? ");
INSERT INTO engoke_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why didst thou conceal thy going, (or conceal thyself to go,) and didst hide it from me, and not show me, that I might then have sent thee away with mirth, and with hymns, and with tambourines, and with harps? ");
INSERT INTO engoke_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nor didst thou suffer me to kiss my sons and my daughters. Now hast thou done foolishly. ");
INSERT INTO engoke_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","It is in the power of my bands to do evil with thee: but the God of thy father spake to me in the evening, saying, Beware lest thou speak to Jakob from good to evil. ");
INSERT INTO engoke_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","And now, (though) going thou wouldest go, because desiring thou bast desired the house of thy father, why hast thou taken my religion? ");
INSERT INTO engoke_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","And Jakob answered and said to Laban, Because I feared; for I said, Lest thou shouldst take away thy daughters from me. ");
INSERT INTO engoke_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","The place where thou shalt find thy religious things shall not abide: before our brethren ascertain thou what of thine is with me, and take to thee. But Jakob knew not that Rahel had carried them away. ");
INSERT INTO engoke_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","And Laban entered into the tent of Leah, and into the tent of the two concubines, but found not; and he went forth from the tent of Leah, and entered the tent of Rahel. ");
INSERT INTO engoke_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","But Rahel had taken the images, and laid them in the panniers of the camels, and sat upon them. And Laban searched all the tent, but found not. ");
INSERT INTO engoke_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","And she said to her father, Let it not be displeasing in the eyes of my lord, that I am not able to rise before thee; for the way of women is upon me. And he scrutinized, but found not the images. ");
INSERT INTO engoke_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","And Jakob was angry, and contended with Laban. And Jakob answered and said to Laban, What is my guilt, my crime, that thou hast pursued after me? ");
INSERT INTO engoke_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Now that thou hast searched all my things, what hast thou found, of all the things of thy house? Set it here before my brethren and thy brethren, and they shall decide between us both. ");
INSERT INTO engoke_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","These twenty years have I been with thee; thy ewes and thy goats have not failed, and the rams of thy flock I have not eaten. ");
INSERT INTO engoke_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","The wounded I have not brought to thee; what was deficient in number, from my hand hast thou required it. I have watched by day, and I have watched by night. ");
INSERT INTO engoke_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","(Thus) have I been; in the day the heat devoured me, and the frost came down upon me at night, and sleep passed away from my eyes. ");
INSERT INTO engoke_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","These twenty years have I served in thy house; fourteen years for thy two daughters; and six years for thy sheep; and thou hast changed my wages ten times. ");
INSERT INTO engoke_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Unless the God of my fathers, the God of Abraham, and He whom Izhak hath feared, had been my helper, even now thou hadst sent me away empty: but my labour, and the travail of my hands, have been manifest before the Lord, and He rebuked thee in the evening. ");
INSERT INTO engoke_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","And Laban answered and said to Jakob, The daughters are my daughters, and the sons my sons, and the sheep are my sheep, and all whatsoever thou seest is mine; and to these, my daughters, what can I do this day, or unto their children which they have born? ");
INSERT INTO engoke_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","And now come, let us enter into a covenant, I and thou, and it shall be for a witness between me and thee. ");
INSERT INTO engoke_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","And Jakob took a stone, and set it up as a pillar. ");
INSERT INTO engoke_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","And Jakob said to his brethren, Collect stones; and they took stones, and made a mound, and ate there upon the mound. ");
INSERT INTO engoke_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","And Laban called it Yegar Sahadutha, but Jakob called it Gal-Ed. ");
INSERT INTO engoke_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","And Laban said, This mound testifieth between me and thee today. ");
INSERT INTO engoke_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Therefore he called the name of it The Heap of Witness, and The Observatory; for he said, The Word of the Lord will observe between me and thee, when we are hidden each man from his neighbor. ");
INSERT INTO engoke_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If thou shalt afflict my daughters, or if thou shalt take wives over my daughters, no man is with us; see, the Word of the Lord is witness between me and thee. ");
INSERT INTO engoke_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","And Laban said to Jakob, Behold this mound and this pillar, which thou bast erected between me and thee. ");
INSERT INTO engoke_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","And Laban said, This mound testifieth between me and thee today. And Laban said, This mound testifieth between me and thee today. This mound and pillar are a witness, that I will not pass over this mound to thee; and that thou shalt not pass over this mound and this pillar, to do me evil. ");
INSERT INTO engoke_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","The God of Abraham and the God of Nachor shall judge between us, the God of their fathers. And Jakob sware by Him whom Izhak his father feared. ");
INSERT INTO engoke_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","And Jakob sacrificed victims in the mountain, and called his brethren to eat bread; and they ate bread, and tabernacled in the mountain. ");
INSERT INTO engoke_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","And Laban arose in the morning, and kissed his sons and his daughters, and blessed them, and went; and Laban returned to his place. ");
INSERT INTO engoke_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","And Jakob went on his way, and the angels of the Lord met him. ");
INSERT INTO engoke_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","And when Jakob saw them, he said, This is a host from before the Lord; and he called the name of the place Mahanaim. ");
INSERT INTO engoke_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","And Jakob sent messengers before him to Esau his brother to the land of Seir, in the region of Edom; ");
INSERT INTO engoke_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","And he instructed them, saying, So shall you tell to my lord, to Esau: Thus saith thy servant Jakob, With Laban I have dwelt, and have tarried, until now. ");
INSERT INTO engoke_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","And I have oxen, and asses, sheep, and servants, and handmaids, and have sent to show my lord, to find grace in thine eyes. ");
INSERT INTO engoke_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","And the messengers returned to Jakob, saying, We came to thy brother, to Esau; and he cometh also to meet thee, and four hundred men with him. ");
INSERT INTO engoke_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","And Jakob feared greatly, and it distressed him. And he divided the people that were with him, and the sheep, and oxen, and camels, into two hosts, ");
INSERT INTO engoke_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","And said, If Esau come to the one host and smite it, the host that is left may escape. ");
INSERT INTO engoke_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","And Jakob said, God of my father Abraham, and God of my father Izhak, the Lord, who didst say to me, Return to thy country and to thy native place, and I will do thee good; ");
INSERT INTO engoke_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","less are my righteousnesses than all the mercies and all the benefits which Thou hast performed unto Thy servant: for alone I passed this Yardena, and now I have become two bands. ");
INSERT INTO engoke_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Deliver me now from the hand of my brother, from the band of Esau; for I am afraid of him, lest he come and smite me, and the mother with the children. ");
INSERT INTO engoke_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","And Thou hast said, In doing good I will do good with thee, and will make thy sons many as the sand of the sea which cannot be numbered for number. ");
INSERT INTO engoke_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","And he housed there that night, and took of that which came to his hand, an offering for Esau his brother; ");
INSERT INTO engoke_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Goats two hundred, rams twenty, ewes two hundred, and rams twenty, ");
INSERT INTO engoke_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Camels giving milk and their young ones thirty, cows forty, and bulls ten, she-asses twenty, and colts ten. ");
INSERT INTO engoke_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","And he gave them into the hand of his servants, herd by herd separately, and said to his servants, Pass over before me, and put a space between herd and herd. ");
INSERT INTO engoke_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","And he commanded the foremost, saying, If Esau my brother meet thee, and ask thee, saying, Whose art thou? And, Whither goest thou? And, Whose are these that are before thee? ");
INSERT INTO engoke_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Thou shalt say, They are an offering of thy servant Jakob, which he hath sent to my lord, to Esau; and, behold, he also cometh after us. ");
INSERT INTO engoke_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","And he instructed also the second and the third, and all of them who followed the herds, saying, According to this word you shall speak with Esau, when you find him; ");
INSERT INTO engoke_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","And say also, Behold, thy servant Jakob cometh after. For he said, I will quiet his anger by the offering that goeth before me, and afterward I will see his face; perhaps he will accept me. ");
INSERT INTO engoke_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","And the offering went over before his face, and he himself lodged that night in the camp. ");
INSERT INTO engoke_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","And he arose in the night, and took his two wives, and his two concubines, and his eleven sons, and passed over the ford Jubeka; ");
INSERT INTO engoke_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","And he took them and made them pass over the torrent, and made what was his to pass over. ");
INSERT INTO engoke_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","And Jakob remained alone; and a Man wrestled with him till the morning ascended. ");
INSERT INTO engoke_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","And he saw that he prevailed not with him, and he touched the hollow of his thigh, and the hollow of Jacob’s thigh was dislocated in wrestling with him. ");
INSERT INTO engoke_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","And he said, Let me go; for the morning ascendeth And he said, I will not let Thee go, unless Thou bless me. ");
INSERT INTO engoke_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","And He said to him, What is thy name? And he said, Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","And He said, Thy name shall be no longer Jakob, but Israel; for a prince art thou before the Lord, and with men, and thou hast prevailed. ");
INSERT INTO engoke_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","And Jakob asked Him, and said, Show me now Thy Name! And He said, Why dost thou ask My Name? And He blessed him there. ");
INSERT INTO engoke_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","And Jakob called the name of the place Peniel: because I have seen the Angel of the Lord face to face, and my soul hath been saved! ");
INSERT INTO engoke_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","And the sun arose upon him as he passed over Penuel, and he went lame upon his thigh. ");
INSERT INTO engoke_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Therefore the sons of Israel do not eat the sinew which shrank, which is upon the hollow of the thigh, unto this day, because He touched the hollow of Jakob’s thigh in the sinew that shrank. ");
INSERT INTO engoke_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","And Jakob lifted up his eyes, and saw, and, behold, Esau came, and with him four hundred men; and he divided the children with Leah, and with Rahel, and with the two concubines. ");
INSERT INTO engoke_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","And he set the concubines and their children first, and Leah and her children after, and Rahel and Joseph after them. ");
INSERT INTO engoke_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","And he passed over before them, and bowed to the earth seven times, until he came nigh to his brother. ");
INSERT INTO engoke_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","And Esau ran to meet him, and embraced him, and fell upon his neck, and kissed him; and they wept. ");
INSERT INTO engoke_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","And he lifted up his eyes, and saw the women and the children, and said, What are these to thee? And he said, The children whom the Lord hath given to thy servant. ");
INSERT INTO engoke_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","And the concubines approached, they and their children, and bowed. ");
INSERT INTO engoke_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","And Leah also approached and her children, and bowed; and afterward Joseph and Rahel approached, and bowed. ");
INSERT INTO engoke_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","And he said, What to thee is all this troop which I have met? And he said, To find mercy in the eyes of my lord. ");
INSERT INTO engoke_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","And Esau said, I have much, my brother; let what is thine own profit thee. ");
INSERT INTO engoke_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","And Jakob said, I pray thee, if I have now found mercy in thine eyes, that thou wouldst accept the present from my hand, because I have now seen thy face as the vision of the face of the Great, and thou art pleased with me. ");
INSERT INTO engoke_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Receive, I pray, my offering which is brought to thee, because the Lord hath been merciful to me, and because I have all. ");
INSERT INTO engoke_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","And he was urgent on him, and he took it. And he said, Let us journey and go, and I will go along with thee. ");
INSERT INTO engoke_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","And he said, My lord knoweth that the little ones are tender, and the sheep and kine giving milk are with me; and if they overdrive them one day, all the flock may die. ");
INSERT INTO engoke_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Let my lord pass on before his servant, and I will lead on quietly, according to the foot of the little ones, according to the foot of the work that is before me, and according to the foot of the sucklings, until I come to my lord at Seir. ");
INSERT INTO engoke_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","And Esau said, Let me leave with thee of the people who are with me. And he said, Why should this be? Let me find grace in the eyes of my lord. ");
INSERT INTO engoke_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","And Esau returned that day on his way to Seir. ");
INSERT INTO engoke_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","And Jakob journeyed to Succoth, and builded him an house, and made tabernacles for his cattle; therefore he called the name of the place Succoth. ");
INSERT INTO engoke_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","And Jakob came in peace to the city of Shekem, which is in the land of Kenaan, in his coming from Padan Aram, and he abode near the face of the city. ");
INSERT INTO engoke_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","And he bought the possession of the field where he had spread his tent, of the hand of the sons of Hamor, the father of Shekem, for a hundred lambs. ");
INSERT INTO engoke_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","And he raised there an altar, and offered service upon it before God, the God of Israel. ");
INSERT INTO engoke_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","And Dinah, the daughter of Leah, whom she bare to Jakob, went forth to see the daughters of the land. ");
INSERT INTO engoke_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","And Shekem bar Hamor the Hivite, the prince of the land, saw her, and took her, and lay with her, and humbled her. ");
INSERT INTO engoke_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","And his soul took pleasure in Dinah the daughter of Jakob, and he loved the damsel, and spake to the heart of the damsel. ");
INSERT INTO engoke_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","And Shekem spake to Hamor his father, saying, Take to me this damsel for a wife. ");
INSERT INTO engoke_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","And Jakob heard that he had polluted Dinah his daughter. And his sons were with his flocks in the field; and Jakob was silent until they were come. ");
INSERT INTO engoke_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","And Hamor the father of Shekem came forth to Jakob to speak with him. ");
INSERT INTO engoke_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","And the sons of Jakob came up from the field when they heard. And the men were indignant and very angry, because shame had been wrought in Israel by his lying with the daughter of Jacob; for so it should not have been done. ");
INSERT INTO engoke_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor spake with them, saying, The soul of Shekem my son hath pleasure in your daughter; give her now to him to wife. ");
INSERT INTO engoke_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","And marry with us, and take our daughters to you; ");
INSERT INTO engoke_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","And the land shall be before you; inhabit and do business in it, and possess it. ");
INSERT INTO engoke_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","And Shekem said to her father and to her brethren, Let me find favour in your eyes, and what you shall tell me I will give. ");
INSERT INTO engoke_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Multiply upon me dowry and present, and I will give as you may tell me; but give me the damsel to wife. ");
INSERT INTO engoke_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","And the sons of Jakob answered Shekem and Hamor his father, and with subtlety they spake, because he had defiled Dinah their sister. ");
INSERT INTO engoke_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","And they said to them, We cannot do this thing, to give our sister to a man uncircumcised; for that (would be) a reproach to us. ");
INSERT INTO engoke_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nevertheless in this we will agree with you, if you will be as we are, by circumcising every male among you, ");
INSERT INTO engoke_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","and we will give our daughters to you, and your daughters will we take to us, and will dwell with you and be one people. ");
INSERT INTO engoke_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not consent to us to be circumcised, we will take our daughter and go. ");
INSERT INTO engoke_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","And their words were pleasing in the eyes of Hamor, and in the eyes of Shekem the son of Hamor. ");
INSERT INTO engoke_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","And the young man delayed not to do the thing, because he delighted in the daughter of Jakob, and he was more honourable than all his father’s house. ");
INSERT INTO engoke_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","And Hamor came, and Shekem his son, to the gate of the city, and spake to the men of the city, saying, ");
INSERT INTO engoke_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","These men are friendly with us, and they may dwell in the land, and do business in it, and the land, behold, it is wide (on both) hands before them; their daughters we will take to us for wives, and our daughters we will give to them. ");
INSERT INTO engoke_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Only in this will the men agree with us to dwell with us, to be one people, in every male of us being circumcised, as they are circumcised. ");
INSERT INTO engoke_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Their flocks, and their possessions, and all their cattle, will they not be ours? Only let us consent to them, and they will dwell with us. ");
INSERT INTO engoke_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","And everyone who went out of the gate of his city received of Hamor and of Shekem his son, and they were circumcised, every male, everyone who went out of the gate of his city. ");
INSERT INTO engoke_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","And it was on the third day, when their pains were strong upon them, that the two sons of Jakob, Shemeon and Levi, the brothers of Dinah, took each man his sword, and came upon the city, which dwelt in security, and slew every male, ");
INSERT INTO engoke_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","and Hamor and Shekem his son they killed with the edge of the sword. And they brought Dinah out of the house of Shekem, and went. ");
INSERT INTO engoke_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","And the sons of Jakob came up to the spoil of the slain, and sacked the town, because they had defiled their sister. ");
INSERT INTO engoke_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Their sheep, and their oxen, and their asses, and all that was in the city and the field, they took. ");
INSERT INTO engoke_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","And all their substance, and all their little ones, and their wives, they captured and spoiled, and all which was in the house. ");
INSERT INTO engoke_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","And Jakob said to Shemeon and Levi, You have troubled me, in putting strife between me and the inhabitants of the land, the Kenaanites and the Perrezites, and I a people (few) for number; and they will gather against me, and smite me, and I shall perish, I and the men of my house. ");
INSERT INTO engoke_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","And they said, As with an outcast should he deal with our sister? ");
INSERT INTO engoke_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","And the Lord said to Jakob, Arise, go up to Bethel, and dwell there, and make there an altar unto Eloha, who appeared to thee when in thy flight from before Esau thy brother. ");
INSERT INTO engoke_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","And Jakob said to the men of his house, and to all who were with him, Put away the gentile idols that are among you, and purify; and change your raiment; ");
INSERT INTO engoke_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","And we will arise and go up to Bethel, and I will make there an altar unto Eloha, who heard my prayer in the day of my distress, and whose Word was my helper in the way that I went. ");
INSERT INTO engoke_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","And they gave Jakob all the gentile idols that were in their hands, and the jewels that were in their ears, and Jakob hid them under the terebinth which was near Shekem. ");
INSERT INTO engoke_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","And they journeyed; and fear from before the Lord was upon the peoples in the cities surrounding them; and they followed not after the sons of Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","And Jakob came to Luz, which is in the land of Kenaan, which is Bethel, he and all the people who were with him. ");
INSERT INTO engoke_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","And he builded there an altar, and called the place El Bethel, because the Angel of the Lord had appeared to him there when he fled from before his brother. ");
INSERT INTO engoke_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","And Deborah, the nurse of Revekah, died, and was buried below Bethel, in the declivity of the vale; and he called the name of it, The vale of weeping. ");
INSERT INTO engoke_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","And the Lord appeared unto Jakob again when he had come from Padan Aram, and blessed him. ");
INSERT INTO engoke_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","And the Lord said to Jakob, Thy name shall be no more Jakob, but Israel shall be thy name; and he called his name Israel. ");
INSERT INTO engoke_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And the Lord said to him, I am El Shadai; increase and multiply; a people and an assemblage of tribes shall be from thee, and kings who shall reign over the peoples shall come forth from thee. ");
INSERT INTO engoke_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","And the land that I gave to Abraham and to Izhak I will give unto thee, and to thy sons after thee, will I give the land. ");
INSERT INTO engoke_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","And the glory of the Lord ascended above him, in the place where He had spoken with him. ");
INSERT INTO engoke_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","And Jakob erected a pillar in the place where He had spoken with him, a pillar of stone, and outpoured libations upon it, and poured oil thereon. ");
INSERT INTO engoke_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","And Jakob called the name of the place where the Lord bad spoken with him Bethel. ");
INSERT INTO engoke_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","And they journeyed from Bethel, and there was yet a space of land to come unto Ephrath; and Rahel travailed, and had hard (pain) in her birth-labour. ");
INSERT INTO engoke_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","And as she travailed in her labour, the midwife said to her, Fear not, for also this to thee is a son. ");
INSERT INTO engoke_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","And it was in the going forth of her soul, for she died, that she called his name The son of my woe; but his father called him Benjamin. ");
INSERT INTO engoke_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","And Rahel died, and was buried in the way of Ephrath, which is Beth-Lechem. ");
INSERT INTO engoke_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","And Jakob erected a pillar upon her grave: that is the pillar of the tomb of Rahel unto this day. ");
INSERT INTO engoke_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","And Israel proceeded and spread his tabernacle beyond the tower of Adar. ");
INSERT INTO engoke_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","And it was while Israel dwelt in that land, that Reuben went and lay with Bilhah, the concubine of his father. And Israel heard it. And the sons of Jakob were twelve. ");
INSERT INTO engoke_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah, the firstborn of Jakob, Reuben, and Shemeon, and Levi, and Jehudah, and Issakar, and Zebulon. ");
INSERT INTO engoke_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rahel, Joseph and Benjamin. ");
INSERT INTO engoke_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Bilhah, the handmaid of Rahel, Dan and Naphtali; ");
INSERT INTO engoke_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","and the sons of Zilpha, the handmaid of Leah, Gad and Asher. These are the sons of Jakob, who were born to him in Padan Aram. ");
INSERT INTO engoke_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","And Jakob came unto Izhak his father, unto Mamre, the city of Arba, which is Hebron; for Abraham and Izhak had dwelt there. ");
INSERT INTO engoke_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","And the days of Izhak were an hundred and eighty years. ");
INSERT INTO engoke_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","And Izhak expired and died, and was gathered unto his people, old and content with days; and Esau and Jakob his sons buried him. ");
INSERT INTO engoke_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","And these are the generations of Esau, who is Edom. ");
INSERT INTO engoke_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau took his wives from the daughters of Kenaan: Ada, daughter of Helon the Hittite, and Ahalivama, the daughter of Ana, the daughter of Sibeon the Hivite, ");
INSERT INTO engoke_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Basemath, the daughter of Ishmael, the sister of Nebaioth. ");
INSERT INTO engoke_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","And Ada bare to Esau Eliphaz; and Basemath bare Reuel; ");
INSERT INTO engoke_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","and Ahalivama bare Jehus, and Jaalam, and Korach. These are the sons of Esau who were born to him in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","And Esau took his wives, and his sons, and his daughters, and all the souls of his house, and his flocks, and all his cattle, and all his substance which he had gotten in the land of Kenaan, and went into another land from before Jakob his brother; ");
INSERT INTO engoke_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Because their substance was too great for them to dwell together, and the land of their habitation could not sustain them with regard to their cattle. ");
INSERT INTO engoke_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","And Esau dwelt in the mountain of Seir. Esau is Edom. ");
INSERT INTO engoke_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","And these are the generations of Esau, the father of the Edomai, in the mountain of Seir, ");
INSERT INTO engoke_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","these are the names of the sons of Esau: Eliphaz, the son of Ada, the wife of Esau; Reuel, son of Basemath, the wife of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","And the sons of Eliphaz were Theman, Omar, Zepho, and Gaetam, and Kenaz. ");
INSERT INTO engoke_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","And Thimna was the concubine of Eliphaz bar Esau, and she bare to Eliphaz Amalek. These are the sons of Ada, the wife of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","And these are the sons of Reuel, Nahath and Zara, Shamma and Meza. These are the sons of Basemath, the wife of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","And these are the sons of Ahalivama, the daughter of Ana, the daughter of Zebeon, the wife of Esau; and she bare unto Esau Jehus, and Jaalam, and Korach. ");
INSERT INTO engoke_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These are the chiefs of the sons of Esau. Of the sons of Eliphaz the firstborn of Esau, Rabba Theman, Rabba Omar, Rabba Zepho, Rabba Kenaz, ");
INSERT INTO engoke_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","rabba Korach, Rabba Gaetam, Rabba Amalek These are the chiefs of Eliphaz in the land of Edom; these are the sons of Ada. ");
INSERT INTO engoke_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","And these are the sons of Reuel bar Esau: Rabba Nachath, Rabba Zarach, Rabba Shamma, Rabba Meza. These are the chiefs of Reuel in the land of Edom; these are the sons of Basemath, the wife of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","And these are the sons of Ahalivama, the wife of Esau: Rabba Jehus, Rabba Jaalam, Rabba Korach. These are the chiefs of Ahalivama, the daughter of Ana the wife of Esau. ");
INSERT INTO engoke_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These are the sons of Esau, and these are their chieftains. He is Edom. ");
INSERT INTO engoke_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are the sons of Seir, the Chorites, the inhabitants of the land, Lothan, and Shobal, and Zibeon, and Ana, ");
INSERT INTO engoke_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","and Dishon, and Etser, and Dishan. These are the chieftains of the Choraai, the sons of Seir, in the land of Edom. ");
INSERT INTO engoke_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","And the sons of Loti were Hori and Hemaim, and the sister of Lotan was Timna. ");
INSERT INTO engoke_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","And these are the Beni Shobal, Alvan, and Manahath, and Ebal, Shephi, and Onam. ");
INSERT INTO engoke_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","And these are the sons of Zebeon, Aya and Ana; he is Ana who found the giants in the desert while he tended the asses of his father Zibeon. ");
INSERT INTO engoke_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","And these are the children of Ana, Dishon, and Ahalivania the daughter of Ana. ");
INSERT INTO engoke_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","And these are the sons of Dishan: Hemdan, and Eshban, and Jethran, and Keran. ");
INSERT INTO engoke_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These are the sons of Etser: Bilan, and Zaavan, and Akan. ");
INSERT INTO engoke_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These are the sons of Dishan: Huts and Aran. ");
INSERT INTO engoke_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the chieftains of the Choraai: Rabba Lotan, Rabba Shobal, Rabba Zebeon, Rabba Ana, ");
INSERT INTO engoke_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Rabba Dishon, Rabba Etser, Rabba Dishan. These are the chieftains of the Choraai, according to their principalities in the land of Seir. ");
INSERT INTO engoke_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","And these are the kings who reigned in the land of Edom, before that kings reigned among the sons of Israel: ");
INSERT INTO engoke_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela the son of Beor reigned in Edom, and the name of his city was Dinhava. ");
INSERT INTO engoke_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","And Bela died, and instead of him reigned Yobab the son of Zerah of Botsra. ");
INSERT INTO engoke_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","And Yobab died, and instead of him reigned Husham, of the land of the south. ");
INSERT INTO engoke_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","And Husham, died, and instead of him reigned Hadad, the son of Bedad, who slew the Medianae in the fields of Moab; and the name of his city was Avith. ");
INSERT INTO engoke_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","And Hadad died, and in his stead reigned Simlah of Masereka. ");
INSERT INTO engoke_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","And Simlah died, and in his stead reigned Shaul of Rechovoth, which is on the Ph’rat. ");
INSERT INTO engoke_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","And Shaul died, and in his stead reigned Baal-Chanan bar Akbor. ");
INSERT INTO engoke_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","And Baal-Chanan bar Akbor died, and in his stead reigned Hadar, and the name of his city was, Pau; and the name of his wife Mehetavel, the daughter of Matered, the daughter of a changer of gold. ");
INSERT INTO engoke_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","And these are the names of the chieftains of Esau, after their kindreds, by their places, with their names: Rabba Timna, Rabba Alvah, Rabba Jetheth, ");
INSERT INTO engoke_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Rabba Ahalivama, Rabba Elah, Rabba Phinon, ");
INSERT INTO engoke_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Rabba Kenez, Rabba Teman, Rabba Mabzar, ");
INSERT INTO engoke_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Rabba Magdiel, Rabba Iram: these are the chieftains of Edom, after their habitations in the land of their possessions. He is Esau, the father of the Edomites. ");
INSERT INTO engoke_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","And Jakob dwelt in the land of the habitation of his father, in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","These are the generations of Jakob. Joseph was a son of seventeen years; he kept the flock with his brothers; and he had been brought up with the sons of Bilhah, and with the sons of Zilpha, the wives of his father; and Joseph brought their evil report to his father. ");
INSERT INTO engoke_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","But Israel loved Joseph more than all his sons, because he had in him a wise son, and he made him a variegated robe. ");
INSERT INTO engoke_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","And his brothers saw that their father loved him better than all his brethren, and they hated him, and were not willing to speak with him peaceably. ");
INSERT INTO engoke_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","And Joseph dreamed a dream, and showed it to his brothers, and they hated him the more. ");
INSERT INTO engoke_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","And he said to them, Hear now this dream which I have dreamed: ");
INSERT INTO engoke_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Behold, we were binding sheaves in the midst of the field, and lo! My sheaf arose and became upright, and, behold, your sheaves stood around and worshipped my sheaf. ");
INSERT INTO engoke_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","And his brothers said to him, Is it thy fancy reigning to reign over us? Or a shultan, dost thou think to govern us? And they added yet to hate him for his dreams and for his words. ");
INSERT INTO engoke_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","And he dreamed yet another dream, and described it to his brothers, saying, Behold, I have dreamed a dream again; and lo, the sun, and the moon, and eleven stars worshipped me. ");
INSERT INTO engoke_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","And he described it to his father and to his brethren; and his father rebuked him and said to him, What dream is this that thou hast dreamed? Am I and thy mother and thy brothers to come and worship thee on the earth? ");
INSERT INTO engoke_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","And his brothers envied him; but his father kept the word. ");
INSERT INTO engoke_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","And his brothers went to tend the flock of their father in Shekem. ");
INSERT INTO engoke_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","And Israel said to Joseph, Do not thy brothers tend the flock in Shekem? Come, I will send thee to them. And he said. Behold me. ");
INSERT INTO engoke_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","And he said to him, Go now, and see the welfare of your brothers and the welfare of the flock, and return me word. And he sent him from the vale of Hebron, and he came to Shekem. ");
INSERT INTO engoke_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","And a man found him, and, behold, he wandered in the field. And the man inquired of him, saying, Whom seekest thou? ");
INSERT INTO engoke_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","And he said, I look for my brothers: show me, I beseech thee, where they feed. ");
INSERT INTO engoke_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","And the man said, They have gone hence; for I heard them say, We will go to Dothan. And Joseph went after his brethren, and found them in Dothan. ");
INSERT INTO engoke_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","And they saw him from afar; and before he came nigh, they devised against him to kill him. ");
INSERT INTO engoke_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","And they said, a man to his brother, Behold, this master of dreams cometh. ");
INSERT INTO engoke_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","And now, come, we will kill him, and cast him into one of the pits; and will say an evil beast hath devoured him, and we shall see what will be the end of his dreams. ");
INSERT INTO engoke_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","And Reuben heard, and delivered him out of their hands, and said, Let us not slay his life. ");
INSERT INTO engoke_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","And Reuben said, Do not shed blood; cast him into this pit in the wilderness, but stretch not forth a hand against him, that he might deliver him from their hands to bring him back to his father. ");
INSERT INTO engoke_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","And it was when Joseph had come to his brethren that they took off his robe, the variegated robe which was upon him, ");
INSERT INTO engoke_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","And they took him and cast him into the pit; but the pit was empty, no water was in it. ");
INSERT INTO engoke_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","And they reclined to eat bread. And they lifted up their eyes and looked, and, behold, a band of Arabaee were coming from Gilead, with their camels bearing spices, and resin, and myrrh, to go down to Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","And Jehuda said to his brethren, What gain should we have by killing our brother and covering his blood? ");
INSERT INTO engoke_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, and we will sell him to the Arabaee, and our hand shall not be upon him; for he is our brother, our flesh. And his brethren hearkened to him. ");
INSERT INTO engoke_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","And there passed by Midianite men, (gabree Mid-ya-naee,) merchants, and they drew and lifted up Joseph from the pit, and sold Joseph to the Arabaee for twenty of silver; and they brought Joseph into Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","And Reuben returned to the pit, and, behold, Joseph was not in the pit. And he rent his clothes, ");
INSERT INTO engoke_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","And returned to his brethren, and said, The youth is not; and I, whither shall I go? ");
INSERT INTO engoke_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","But they took Joseph’s robe, and killed a kid of the goats, and dabbled the robe in the blood. ");
INSERT INTO engoke_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","And they sent the variegated robe, and they brought to their father, and said, This have we found; know now whether it is the robe of thy son, or not. ");
INSERT INTO engoke_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","And he knew it, and said, It is my son’s robe; an evil beast hath devoured him: slain, slain is Joseph! ");
INSERT INTO engoke_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","And Jakob rent his clothes, and wrapped sackcloth upon his loins, and mourned for his son many days. ");
INSERT INTO engoke_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","And all his sons, and all his house, arose to comfort him; but he refused to take comfort, and said, For I will go down unto my son, mourning into Sheol. And his father wept for him. ");
INSERT INTO engoke_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","And the Midianites sold him in Mizraim to Potiphar, a prince of Pharoh, chief of the killers. ");
INSERT INTO engoke_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","And it was at that time that Jehuda went down from his brethren, and turned aside to an Adulamite man whose name was Hira. ");
INSERT INTO engoke_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","And Jehuda saw there the daughter of a merchant man whose name was Shuva, and he took her and went in with her; ");
INSERT INTO engoke_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","And she conceived and bare a son, and he called his name Her; ");
INSERT INTO engoke_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","And she conceived again, and bare a son, and called his name Onan. ");
INSERT INTO engoke_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","And she added again, and bare a son, and called his name Shelah; and he was in Kezib when she bare him. ");
INSERT INTO engoke_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","And Jehuda took a wife for Her his firstborn, and her name was Tamar. ");
INSERT INTO engoke_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","And Her the firstborn of Jehuda was evil before the Lord, and the Lord caused him to die. ");
INSERT INTO engoke_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","And Jehuda said to Onan, Go in with the wife of thy brother, and associate with her, and raise up seed to thy brother. ");
INSERT INTO engoke_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","And Onan knew that after his name the seed would not be called; and it was that when he went in with the wife of his brother, he corrupted his way upon the earth that he might not raise up seed unto his brother; ");
INSERT INTO engoke_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","And what he did was evil before the Lord, and he caused him also to die. ");
INSERT INTO engoke_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","And Jehuda said to Tamar his daughter-in-law, Remain a widow in thy father’s house until Shelah my son be grown up. For he said, Lest he also die like his brothers: and Tamar went and dwelt in her father’s house. ");
INSERT INTO engoke_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","And after many days the daughter of Shuva, Jehuda’s wife, died: and Jehuda was comforted; and he went up to the shearers of his sheep, he and Hira the Adulamite his friend unto Timnath. ");
INSERT INTO engoke_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","And it was shown to Tamar, saying, Behold, thy father-in-law cometh to Timnath to shear his sheep. ");
INSERT INTO engoke_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","And she laid aside the dress of her widowhood, and covered herself with a mantle (or a large veil), and adorned herself, and sat in the dividing of Aynin which is in the way to Timnath. For she saw that Shelah had grown up, and she had not been given to him for a wife. ");
INSERT INTO engoke_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","And Jehuda saw her, and thought that she was an outcast, because she had covered her face. ");
INSERT INTO engoke_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","And he declined to her by the way, and said, Give me now to go in unto thee; for he did not know that she was his daughter-in-law. And she said, What wilt thou give me, that thou mayest come to me? ");
INSERT INTO engoke_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","And he said, I will send thee a kid of the goats from the flock. And she said, If thou wilt give me a pledge until thou send. ");
INSERT INTO engoke_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","And he said, What is the pledge that I shall give thee? And she said, Thy seal-ring, and thy scarf, and thy staff that is in thy hand. And he gave to her, and went in to her, and she conceived by him. ");
INSERT INTO engoke_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","And she arose, and went, and put off the veil from her, and dressed herself in the dress of her widowhood. ");
INSERT INTO engoke_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","And Jehuda sent the kid of the goats, by the hand of his friend the Adulamite, to receive the pledge from the hand of the woman; but he could not find her. ");
INSERT INTO engoke_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","And he inquired of the men of the place, saying, Where is the harlot who was in Aynin upon the way? And they said to him, There is no harlot here. ");
INSERT INTO engoke_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","And he returned to Jehuda, and said, I could not find her; the men of the place also said there is no harlot there. ");
INSERT INTO engoke_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","And Jehuda said, Let her take it to her, lest we be in contempt: behold, I sent this kid, and thou hast not found her. ");
INSERT INTO engoke_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","And it was three months, and it was showed to Jehuda, saying, Tamar thy daughter-in-law hath committed fornication, and, behold, she is with child by fornication. And Jehuda said, Bring her out, and let her be burned. ");
INSERT INTO engoke_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","And she was brought out. And she sent to her father-in-law, saying, By the man to whom these belong I am with child. And she said, Acknowledge now, whose are these, the seal, the scarf, and the staff? ");
INSERT INTO engoke_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","And Jehuda acknowledged and said, She is justified in having conceived from me, because I have not given her Shelah my son. And he added not again to know her. ");
INSERT INTO engoke_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","And it was the time of her giving birth, and, behold, twins were in her womb. ");
INSERT INTO engoke_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","And it was in giving birth that one of them put forth a hand; and the midwife took and tied scarlet upon his hand, saying, This came the first. ");
INSERT INTO engoke_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","And it was when he had drawn back his hand that his brother came forth: and she said, How much greater strength is with thee, that thou hast prevailed! And she called his name Pharets. ");
INSERT INTO engoke_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","And afterwards came forth his brother who had the crimson on his hand, and she called his name Zarah. ");
INSERT INTO engoke_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","But Joseph was brought down into Mizraim, and Potiphar, a chief of Pharoh, a chief of the killers, a Mizraite man, bought him from the hand of the Arabaee who had brought him down thither. ");
INSERT INTO engoke_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","And the Word of the Lord was the helper of Joseph, and he became a prosperous man, and was in the house of his Mizraite master. ");
INSERT INTO engoke_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","And his master saw that the Word of the Lord was his helper, and that all that he did the Lord prospered in his hand. ");
INSERT INTO engoke_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","And Joseph found favour in his eyes, and he served him. And he appointed him over his house, and all that he had he delivered into his hand. ");
INSERT INTO engoke_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","And it was from the time that he appointed him over his house, and over all that he had, that the Lord blessed the house of the Mizraite for Joseph’s sake, and the blessing of the Lord was upon all that he had, in the house and in the field. ");
INSERT INTO engoke_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","And he left all that belonged to him in the hand of Joseph; and he knew of nothing that was with him, except the bread which he ate. Now Joseph was of goodly appearance, beautiful in aspect. ");
INSERT INTO engoke_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","And it was after these things that the wife of his master lifted up her eyes to Joseph, and said, Lie with me. ");
INSERT INTO engoke_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But be refused, and said to his master’s wife, Behold, my master knoweth not what is with me in the house, and all that he hath he hath delivered unto my hand; ");
INSERT INTO engoke_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","There is no one in this housegreater than I, and be hath not prohibited anything from me but thyself, because thou art his wife: and how can I do this great wickedness and become guilty before the Lord? ");
INSERT INTO engoke_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","And it was when she spake with Joseph daily that he would not hearken to her to lie with her, or be with her. ");
INSERT INTO engoke_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","And it was about this day that he came into the house to examine the writings of his affairs, and no man of the men of the house was there in the house. ");
INSERT INTO engoke_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","And she laid hold of his garments, saying, Lie with me. But he left his garment in her hand, and fled, and went forth into the street. ");
INSERT INTO engoke_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","no translation ");
INSERT INTO engoke_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","And she called to the men of her house, and spake to them, saying, See, he brought us a Hebrew man to mock at us. He came in to me to lie with me; and I cried with a high voice. ");
INSERT INTO engoke_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","And it was when he heard that I lifted up my voice and cried, he left his robe with me, and fled and went forth into the street. ");
INSERT INTO engoke_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","And she let his robe remain with her until his master came into his house. ");
INSERT INTO engoke_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","And she spake with him these words, saying, The Hebrew servant whom thou broughtest us came in to me to mock at me. ");
INSERT INTO engoke_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","And it was when I lifted up my voice and cried, he left his robe with me and fled into the street. ");
INSERT INTO engoke_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","And when his master heard the words of his wife which she spake with him, saying, According to these things hath thy servant done to me, his anger waxed strong, ");
INSERT INTO engoke_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","And his master took Joseph, and delivered him to the house of the bound, where the prisoners of the king were bound; and he was there in the house of the bound. ");
INSERT INTO engoke_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But the Word of the Lord was the helper of Joseph, and showed him mercy, and gave him favour in the eyes of the captain of the prison. ");
INSERT INTO engoke_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","And the captain of the prison gave into the hand of Joseph all the prisoners who were in the house of the bound, and all that they did there was done according to his word. ");
INSERT INTO engoke_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The captain of the prison saw no fault in his hand, because the Word of the Lord was his helper, and that which he did the Lord made to prosper. ");
INSERT INTO engoke_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","And after these things the cupbearer and the baker of the king of Mizraim offended their master, the king of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","And Pharoh was angry with two of his chiefs, with the chief of the cupbearers and with the chief of the bakers. ");
INSERT INTO engoke_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","And he gave them into ward in the house of the captain of the executioners (killers) in the house of the prison, the place where Joseph was confined. ");
INSERT INTO engoke_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","And the captain of the executioners appointed Joseph with them, and he ministered to them, and they were certain days inward. ");
INSERT INTO engoke_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","And they dreamed a dream, both of them, each man his dream in one night, each man according to the interpretation of his dream, the cupbearer and the baker of the king of Mizraim, who were confined in the house of the bound. ");
INSERT INTO engoke_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","And Joseph came to them in the morning, and saw them, and, behold, they were melancholy. ");
INSERT INTO engoke_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","And he asked the chiefs of Pharoh who were with him inward, in his master’s house, saying, Why are your faces evil today? ");
INSERT INTO engoke_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","And they said to him, We have dreamed a dream, and there is no interpreter of it. And Joseph said to them, Are not interpretations from before the Lord? Relate it now to me. ");
INSERT INTO engoke_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","And the chief of the cupbearers related his dream to Joseph, and said to him, In my dream, behold, a vine was before me, ");
INSERT INTO engoke_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","and in the vine were three branches: and it was, as it sprouted, it produced buds, and, having flowered, ripened clusters of grapes. ");
INSERT INTO engoke_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","And the cup of Pharoh was in my hand; and I took grapes and expressed them into Pharohs cup, and gave the cup into Pharoh’s hand. ");
INSERT INTO engoke_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","And Joseph said to him, This is the interpretation: the three branches are three days. ");
INSERT INTO engoke_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","At the end of three days, Pharoh will remember thee and restore thee to thy service, and thou wilt give the cup into Pharoh’s hand, according to thy former custom when thou wast cupbearer to him. ");
INSERT INTO engoke_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But let remembrance of me be with thee when it shall be well with thee, and do me favour, I beseech thee, and remember me before Pharoh, and deliver me from this prison. ");
INSERT INTO engoke_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For I was verily taken by fraud from the land of the Hivraee, and here have I done nothing evil that I should be imprisoned. ");
INSERT INTO engoke_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","And when the master of the bakers saw that he had interpreted pleasantly, he said to Joseph, I also (was) in my dream, and, behold, three baskets of confectionery were upon my head, ");
INSERT INTO engoke_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","and in the upper basket were all (sorts of) food for Pharoh, the work of the baker; and the birds ate them from the basket that was on my head. ");
INSERT INTO engoke_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","And Joseph answered and said, This is the interpretation of it: The three baskets are three days; ");
INSERT INTO engoke_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","At the end of three days will Pharoh remove thy head from off thee, and will hang thee upon a gibbet, and the birds will eat thy flesh from off thee. ");
INSERT INTO engoke_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","And it was on the third day, the day of the nativity of Pharoh, that he made a feast for all his servants and he took the, head of the chief cupbearer and the head of the chief of the bakers in the midst of his servants. ");
INSERT INTO engoke_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","And he restored the cupbearer to his office, and he gave the cup into Pharoh’s hand. ");
INSERT INTO engoke_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","And the chief of the bakers he hanged, as Joseph had interpreted to them. ");
INSERT INTO engoke_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yet the chief cupbearer did not remember Joseph, but forgat him. ");
INSERT INTO engoke_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","And it was at the end of two years that Pharoh dreamed, and, behold, he stood by the River. ");
INSERT INTO engoke_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","And, behold, there came up from the River seven oxen, goodly in appearance, and fat-fleshed; and they grazed in the meadow. ");
INSERT INTO engoke_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","And, behold, seven other oxen came up from the river after them, evil in appearance, and leanfleshed; and they stood beside them by the bank of the river. ");
INSERT INTO engoke_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","And the evil-looking and lean-fleshed oxen ate up the seven well-looking and fat ones: and Pharoh awoke. ");
INSERT INTO engoke_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","And he slept, and dreamed a second (time); and, behold, seven ears rose up from one stalk, large and good, ");
INSERT INTO engoke_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","and, behold, seven ears, thin, and blighted (with the) east (wind), sprang up after them. ");
INSERT INTO engoke_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","And the seven wasted ears devoured the seven large and full ears. And Pharoh awoke, and, behold, a dream. ");
INSERT INTO engoke_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","And when it was morning his spirit was troubled, and he sent and called all the magicians of Mizraim, and all the wise men; and Pharoh related the dreams to them, but they could not interpret them to Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","And the chief of the cupbearers spake to Pharoh, saying, My faults I do remember this day. ");
INSERT INTO engoke_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharoh was displeased with his servants, and gave me into custody at the house of the chief executioner, and the chief baker with me. ");
INSERT INTO engoke_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","And we dreamed a dream in one night, I and he, each man according to the interpretation of his dream, we dreamed. ");
INSERT INTO engoke_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","And with us there was a Hebrew youth, a servant of the chief executioner; and we recounted to him, and he explained to us our dreams, to each man according to his dream be explained; ");
INSERT INTO engoke_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And according as he had explained to us, so it was: me he restored to my service, and him he hanged. ");
INSERT INTO engoke_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","And Pharoh sent, and called Joseph, and made him hasten from the prison; and he dressed his hair, and changed his garments, and came unto Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","And Pharoh said to Joseph, I have dreamed a dream, and there is no one to interpret it. And I have heard of thee, saying, that thou hearest a dream, and dost interpret it. ");
INSERT INTO engoke_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","And Joseph answered Pharoh, saying, Not from my wisdom, but from before the Lord, will there be an answer of peace unto Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","And Pharoh spake with Joseph, saying, In my dream, behold, I stood upon the bank of the River; ");
INSERT INTO engoke_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","and, behold, from the River rose up seven oxen, fat-fleshed and goodly in appearance, and they grazed in the meadow. ");
INSERT INTO engoke_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","And, behold, seven other oxen came up after them, lean and most evil in appearance, so wanting in flesh, that their like I have not seen in all the land of Mizraim for badness. ");
INSERT INTO engoke_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","And the lean oxen and evil ones ate up the seven first fat oxen. ");
INSERT INTO engoke_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","And they entered into their stomachs; but it could not be known that they had entered into their stomachs, for their appearance was bad as before; and I awoke. ");
INSERT INTO engoke_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I saw in my dream, and, behold, seven ears of corn arose on one stalk, full and good. ");
INSERT INTO engoke_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","And, behold, seven (other) ears, hard, thin, and blasted (with the) east (wind), sprang up after them. ");
INSERT INTO engoke_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","And the thin ears devoured the seven good ears. And I told it to the magicians, but there was no one who could show it to me. ");
INSERT INTO engoke_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","And Joseph answered Pharoh, The dream of Pharoh is one. That which the Lord is about to do He hath showed to Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good oxen are seven years; and the seven good ears of corn are seven years; the dream is one. ");
INSERT INTO engoke_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","And the seven lean and evil oxen which came up after them are seven years; and the seven ears, thin, and blasted with the east wind, are seven years of famine. ");
INSERT INTO engoke_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","This is the word which I have spoken to Pharoh. What the Lord is about to do, He hath showed to Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Behold, there come seven years of great plenty in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","And after them will arise seven years of famine, and all the plenty in the land of Mizraim will be forgotten, and the famine will consume the people of the land. ");
INSERT INTO engoke_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","And plenty will not be known in the land for that famine which will be afterward; for it will be very mighty. ");
INSERT INTO engoke_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","And forasmuch as the dream was repeated to Pharoh twice, it is a confirmed thing before the Lord, and the Lord will hasten to do it. ");
INSERT INTO engoke_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","And now let Pharoh look out a prudent and wise man, and appoint him over the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharoh do this, and appoint officers (faithful men) over the land, and let them sow the land of Mizraim in the seven years of plenty, ");
INSERT INTO engoke_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","And collect all the produce of those good years that come, and lay up provision under the hand of Pharoh’s officers, and preserve it in the cities: ");
INSERT INTO engoke_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","And it will be provision for the people of the land in the seven years of famine that are coming in the land of Mizraim, that the people of the land may not be consumed by the famine. ");
INSERT INTO engoke_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","And the thing was good in the eyes of Pharoh, and in the eyes of all his servants. ");
INSERT INTO engoke_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","And Pharoh said to his servants, Can we find a man like this, in whom is the spirit of prophecy from the Lord? ");
INSERT INTO engoke_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","And Pharoh said to Joseph, Since the Lord hath made all this known to thee, there is none more prudent or wise than thou; ");
INSERT INTO engoke_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Thou shalt be appointed over my house, and by thy word shall all my people be governed; only in the throne of this kingdom will I be more honorable than thou. ");
INSERT INTO engoke_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","And Pharoh said to Joseph, See, I have appointed thee over all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","And Pharoh took off his ring from his hand, and set it upon Joseph’s hand, and clothed him in a robe of lawn, and put a chain of gold upon his neck. ");
INSERT INTO engoke_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","And he made him ride in his own second chariot, and they proclaimed before him, This is the father of the king; and he appointed him over all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","And Pharoh said to Joseph, I am Pharoh; and without thy word shall no man lift up his hand to hold a weapon, nor his foot to mount a horse, in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","And Pharoh called the name of Joseph, The man to whom mysteries are revealed. And he gave him Asenath, the daughter of Potiphera, prince of On, to be his wife; and Joseph went forth ruling over the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","And Joseph was a son of thirty years when he stood before Pharoh, king of Mizraim. And Joseph went out from before Pharoh, and passed through all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","And the inhabitants of the land collected in the seven years of plenty the provision into granaries. ");
INSERT INTO engoke_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","And he collected all the provision of the seven years which was in the land of Mizraim, and laid up the provision in cities, in the midst of each city the provision of the land surrounding it. ");
INSERT INTO engoke_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","And Joseph gathered provision as the sand of the sea, exceeding much, until he ceased to number, for it was without number. ");
INSERT INTO engoke_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","And unto Joseph were born two sons, (before the year of famine came,) which Asenath, daughter of Potiphera, prince of On, bare to him. ");
INSERT INTO engoke_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","And Joseph called the name of the firstborn Menasheh; because the Lord hath made me to forget all my labour and all my father’s house. ");
INSERT INTO engoke_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","And the name of the second he called Ephraim; because the Lord hath made me to increase in the land of my servitude. ");
INSERT INTO engoke_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","And the seven years of plenty which were in the land of Mizraim were completed. ");
INSERT INTO engoke_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","And the seven years of famine began to come, as Joseph had said; and the famine was in all the lands, but in all the land of Mizraim there was bread. ");
INSERT INTO engoke_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Yet all the land of Mizraim was famished, and the people cried before Pharoh for bread: and Pharoh said to all the Mizraee, Go unto Joseph, and what he shall say to you, do. ");
INSERT INTO engoke_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","And the famine was over all the face of the land; and Joseph opened all the granaries in which was the corn, and sold to the Mizraee, and the famine became mighty in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And all the inhabitants of the earth came into Mizraim to buy corn of Joseph, because the famine was mighty in all the earth. ");
INSERT INTO engoke_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","And Jakob saw that corn was sold in Mizraim, and Jakob said to his sons, Why look you (on each other)? ");
INSERT INTO engoke_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","And he said, Behold, I have heard that corn is sold in Mizraim: go down thither, and buy us from thence, and we shall live, and not die. ");
INSERT INTO engoke_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","And the ten brothers of Joseph went down to buy corn from Mizraim; ");
INSERT INTO engoke_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Benjamin, the brother of Joseph, Jakob sent not with his brethren; for he said, Lest death should befall him. ");
INSERT INTO engoke_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","And the sons of Israel came to buy corn among them who came; for the famine was in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","And Joseph, who was ruler over the land, was he who sold the corn to all the people of the earth. And the brothers of Joseph came, and bowed before him with their faces upon the ground. ");
INSERT INTO engoke_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","And Joseph saw his brothers, and knew them, and considered what he should say to them. And he spake with them severely, and said to them, Whence come you? And they said, From the land of Kenaan, to buy corn. ");
INSERT INTO engoke_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","And Joseph knew his brothers, but they did not know him. ");
INSERT INTO engoke_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","And Joseph remembered the dreams which he had dreamed of them; and he said to them, You are spies; to see the ruin of the land are you come. ");
INSERT INTO engoke_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","And they said, No, my lord, (ribboni,) thy servants are come to buy corn. ");
INSERT INTO engoke_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all the sons of one man. Right are we; thy servants are not spies. ");
INSERT INTO engoke_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","But he said to them, No, but you are come to see the ruin of the land. ");
INSERT INTO engoke_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","And they said, Thy servants are twelve brothers, the sons of one man, in the land of Kenaan; and, behold, the youngest is with our father today, and one is not! ");
INSERT INTO engoke_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","And Joseph said to them, That is what I have told you, saying, You are spies; ");
INSERT INTO engoke_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","By this you shall be proved: by the life of Pharoh you shall not go hence, until your youngest brother be come hither. ");
INSERT INTO engoke_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of you, and bring your brother; but you shall be bound, and your words shall be proved, whether you have spoken the truth; if not, by the life of Pharoh, you are spies. ");
INSERT INTO engoke_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","And he put them in the house of custody three days. ");
INSERT INTO engoke_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","And Joseph said to them the third day, This do, and live; for I fear before the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you be true, let one of your brethren be bound in the prison; and go you, carry the provision which is needed in your house, ");
INSERT INTO engoke_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","and bring your youngest brother to me, and your words will be verified, and you shall not die. And they did so. ");
INSERT INTO engoke_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","And they said, a man to his brother, We are verily guilty concerning our brother; that we saw the anguish of his soul, when he implored us, and we would not hearken to him: therefore is this distress come upon us. ");
INSERT INTO engoke_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","And Reuben answered them, saying, Did not I tell you, saying, Do not sin against the youth? But you, would not hearken. Thus, behold, his blood is required. ");
INSERT INTO engoke_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","But they knew not that Joseph heard; for there was an interpreter between them. ");
INSERT INTO engoke_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","And he turned himself away from them, and wept. And he returned and spake to them, and took Shemeon from them, and bound him before their eyes. ");
INSERT INTO engoke_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","And Joseph commanded to fill their vessels with corn, and return their money (that of each) man in his sack, and give them food in the way. And he did so by them. ");
INSERT INTO engoke_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","And they laid their corn upon their asses, and went thence. ");
INSERT INTO engoke_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","And one opened his sack to give provender to his ass at the house of lodging, and saw his money, and, behold, it was in the mouth of his package; ");
INSERT INTO engoke_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","And he said to his brothers, My money is returned, and, behold, it is in my package. And the knowledge of their hearts failed, and they were each of them confounded, saying, What is this which the Lord hath done to us? ");
INSERT INTO engoke_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","And they came to Jakob their father in the land of Kenaan, and showed him all that had happened to them, saying, ");
INSERT INTO engoke_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","The man, the lord of the country, spoke hardly with us, and dealt with us as spies of the land. ");
INSERT INTO engoke_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","And we told him, We are true men, not spies: ");
INSERT INTO engoke_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, sons of one father: one is not, and the youngest is today with our father in the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","And the man, the lord of the country, said to us, By this I shall know that you are true men. Leave one of your brethren with me, and take the corn which is needed in your house, and go, ");
INSERT INTO engoke_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","And bring your youngest brother to me, and I shall know that you are not spies: and when you (will be proved to) be true men, I will give up your brother to you, and you shall trade in the land. ");
INSERT INTO engoke_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","And it was, as they emptied their sacks, behold, each man’s money was bound up in his sack; and when they and their father saw the envelopes of their money, they were afraid. ");
INSERT INTO engoke_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","And Jakob their father said to them, Me have you made desolate; Joseph is not, and Shemeon is not (here), and Benjamin you would take away; upon me are all these! ");
INSERT INTO engoke_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","And Reuben spake with his father, saying, Thou shalt put my two children to death if I do not bring him back to thee. Deliver him into my hand, and I will return him to thee. ");
INSERT INTO engoke_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But he said, My son shall not go down with you; for his brother is dead, and he alone remains; and if death should befall him in the way in which you will go, you will bring down my grey hairs with mourning unto Sheol. ");
INSERT INTO engoke_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","But the famine prevailed in the land. ");
INSERT INTO engoke_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","And it was when they had ended to eat the corn which they had brought from Mizraim, that their father said to them, Return, and buy for us a little corn. ");
INSERT INTO engoke_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","And Jehuda spake to him, saying, The man attesting attested to us, saying, You shall not see my face unless your brother be with you. ");
INSERT INTO engoke_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If thou wilt send our brother with us, we will go down and buy thee corn; ");
INSERT INTO engoke_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if thou wilt not send, we will not go down: for the man told us, You shall not see my face unless your brother be with you. ");
INSERT INTO engoke_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","And Israel said, Why did you do me this evil, in showing the man that you have a brother? ");
INSERT INTO engoke_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","And they said, The man asking asked us concerning our family, saying, Is your father yet alive? Have you a brother? And we showed him according to the word of these things: knowing could we know that be would say, Bring your brother to me? ");
INSERT INTO engoke_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","And Jehuda said to Israel his father, Send the youth with me, and let us arise and go, that we may live and not die, we, and thou, and our little ones. ");
INSERT INTO engoke_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I will be the pledge for him; of my hand shalt thou require him; if I do not bring him back to thee, and set him before thee, let mine be the sin with thee all the days. ");
INSERT INTO engoke_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","For except we had delayed in this, we might now have returned twice. ");
INSERT INTO engoke_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","And Israel their father said to them, If then it is to be, do this: take of what is praiseworthy in the land in your vessels, and carry down to the man an offering; a little gum, and a little honey, storax and ladanum, nuts and almonds; and silver, ");
INSERT INTO engoke_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","two for one take in your hands, even the silver which was returned in the mouth of your bags take back in your hands; perhaps it was an oversight. ");
INSERT INTO engoke_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","And take your brother, and arise, return to the man; ");
INSERT INTO engoke_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","And God the Almighty give you favour before the man, that he may release to you your other brother and Benjamin. And I, when desolated, shall be desolate! ");
INSERT INTO engoke_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","And the men took that offering, and the money two for one took they in their hands; and they took Benjamin, and arose, and went down into Mizraim, and stood before Joseph. ");
INSERT INTO engoke_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","And Joseph saw Benjamin with them; and he said to him who was appointed over his house, Bring the men into the house, and kill a killing and prepare; for the men shall eat with me at dinner. ");
INSERT INTO engoke_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","And the man did as Joseph had said; and the man brought the men into Joseph’s house. ");
INSERT INTO engoke_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","And the men were afraid because they were brought into the, house of Joseph; and said, It is on account of the money that was returned in our baggage at first, that we are brought in, that he might domineer over us, and find occasion against us, and take possession of us as slaves, and seize upon our asses. ");
INSERT INTO engoke_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","And they drew near the man who was set over Joseph’s house, ");
INSERT INTO engoke_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","and spake with him at the gate of the house, and said, We entreat my lord (to hear us). Descending we came down at first to buy corn. ");
INSERT INTO engoke_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","And it was while we were at the resting-place, we opened our baggage, and, behold, a man’s silver was in the mouth of the bag; the silver in its weight. But we have returned it in our hand. ");
INSERT INTO engoke_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","And other silver have we brought in our hand to buy corn. We knew not who put the silver in our baggage. ");
INSERT INTO engoke_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","And he said, Peace be to you: fear not; your God, and the God of your father, gave you treasure in, your bags; your money came to me. And he brought out Shemeon to them. ");
INSERT INTO engoke_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","And the man brought the men into Joseph’s house, and gave water, and they washed their feet, and he gave provender for their asses. ");
INSERT INTO engoke_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","And they made ready the offering against the entrance of Joseph to dinner: for they had heard that there they were to eat bread. ");
INSERT INTO engoke_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","And Joseph entered the house, and they brought to him the offering which was in their hands into the house; and they bowed to him upon the ground. ");
INSERT INTO engoke_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","And he saluted them, and said, Is your father well, the old man you spake of? Is he yet alive? ");
INSERT INTO engoke_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","And they said, It is well with thy servant our father, he is yet alive; and they bowed and worshipped. ");
INSERT INTO engoke_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","And he lifted up his eyes, and saw Benjamin his brother, the son of his mother; and he said, Is this your youngest brother of whom you spake to me? And he said, Mercy from the Lord be upon thee, my son ");
INSERT INTO engoke_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","And Joseph made haste, for his bowels were commoved over his brother, and he sought (where) to weep; and he entered into the chamber, the place of sleeping, and wept there. ");
INSERT INTO engoke_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","And he washed his face, and came out, and was comforted, and said, Put on bread; ");
INSERT INTO engoke_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","And they set for him alone, and for them alone, and for the Mizraee who ate with him, alone. For the Mizraee might not eat bread with the Hivraee, because the animals that the Mizraee worshipped the Hivraee did eat. ");
INSERT INTO engoke_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","And they reclined before him, the chief according to his chiefship, and the less according to his minority; and the men wondered, each man at his companion. ");
INSERT INTO engoke_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","And portions were brought from him, and set before them, and greater was Benjamin’s portion than the portions of them all five portions. And they drank and were merry with him. ");
INSERT INTO engoke_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","And Joseph commanded the steward of his house, saying, Fill the men’s bags with corn as much as they can carry, and put each man’s money in the mouth of his baggage. ");
INSERT INTO engoke_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","And put my cup, the silver cup, in the mouth of the youngest one’s baggage, and his purchase-money. And he did according to Joseph’s word which he spake. ");
INSERT INTO engoke_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","The morning lightened, and the men were sent away, they and their asses. ");
INSERT INTO engoke_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","They had not gone far from the city, when Joseph said to him who was set over his house, Arise, follow after the men, and overtake them, and say to them, Why have you rendered evil for good? ");
INSERT INTO engoke_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is it not this from which my lord drinketh, and, behold, by which inquiring he inquireth? You have done the thing that is evil. ");
INSERT INTO engoke_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","And he overtook them, and spake with them these words. ");
INSERT INTO engoke_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","And they said, Why does my lord speak these words? Be it far from thy servants to do according to this thing! ");
INSERT INTO engoke_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Behold, the money which we found in the mouth of our baggages we brought to thee again from the land of Kenaan; how then should we steal from the house of thy lord vessels of silver, or vessels of gold? ");
INSERT INTO engoke_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","With whomsoever of thy servants it is found, let him die; and we also will be servants to my lord. ");
INSERT INTO engoke_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","And he said, According to your words, so let it be. With whomsoever it is found, he shall be my servant, but you will be acquitted. ");
INSERT INTO engoke_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","And they made haste, and brought down every man his baggage to the ground; and every man opened his baggage. ");
INSERT INTO engoke_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","And he searched, beginning with the greatest and finishing with the least; and the chalice was found in the baggage of Benjamin. ");
INSERT INTO engoke_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","And they rent their clothes, and laded every man his ass, and returned to the city. ");
INSERT INTO engoke_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","And Jehuda entered and his brothers into Joseph’s house, for he was still there; and they fell before him on the ground. ");
INSERT INTO engoke_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","And Joseph said to them, What work is this which you have done? Did you not know that a man like me divining can divine? ");
INSERT INTO engoke_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","And Jehuda said to him, What shall we say to my lord? What shall we speak? How shall we be justified? Before the lord there is sin found in thy servants. Behold, we are the servants of my lord; we also and he in whose hand the chalice hath been found. ");
INSERT INTO engoke_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But he said, Far be it from me to do so: the man in whose hand the chalice has been found shall be my servant; but go you up in peace to your father. ");
INSERT INTO engoke_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","And Jehuda came near to him and said, We beseech my lord, let thy servant speak a word before my lord, and let not thine anger be great with thy servant; for as Pharoh so art thou. ");
INSERT INTO engoke_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord asked his servants, saying, Have you a father or a brother? ");
INSERT INTO engoke_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","And we told my lord, We have an aged father, and the youngest (son) is the son of his old age; his brother is dead; and he only remains of his mother, and his father loves him. ");
INSERT INTO engoke_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","And thou saidst to thy servants, Bring him down to me, and let me set mine eyes upon him. ");
INSERT INTO engoke_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","And we told my lord, His father cannot part with the youth; for if our father should part with him, he would die. ");
INSERT INTO engoke_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","And thou saidst to thy servants, If your youngest brother come not down with you, you shall not see my face again. ");
INSERT INTO engoke_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","And it was when we had gone up to our father, we told him these words of my lord. ");
INSERT INTO engoke_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","And our father said to us, Return, and buy us a little corn. ");
INSERT INTO engoke_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","And we said, We cannot go down: if our youngest brother go down with us, we will go down; for we shall not be able to see the man’s face unless our youngest brother go down with us. ");
INSERT INTO engoke_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","And thy servant our father said to us, You know that my wife bare me two (sons). ");
INSERT INTO engoke_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One went forth from me, and I have said, Dying he is dead; and I have not beheld him since. ");
INSERT INTO engoke_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","And if you take this one also from me, and death happen to him, you will bring down my age with evil unto sheol. ");
INSERT INTO engoke_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","And now, when I come to thy servant my father, and the youth be not with us, and his soul loveth him as his (own) soul; ");
INSERT INTO engoke_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","When he seeth that the youth is not with us, he will die; and thy servant will have brought down the age of thy servant our father with mourning unto Sheol. ");
INSERT INTO engoke_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","For thy servant was surety for the youth with our father, saying, If I bring him not to thee, let my father hold me guilty all the days. ");
INSERT INTO engoke_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","And now let thy servant remain instead of the youth, as the servant of my lord, and let the youth go up with his brothers. ");
INSERT INTO engoke_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how can I go up to my father, and the youth be not with me? Lest I should see the evil that will come upon my father! ");
INSERT INTO engoke_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","And Joseph was not able to sustain all that was being upon him; and he cried, Let every man go out from me; and no man stood with him, while Joseph made himself known to his brethren. ");
INSERT INTO engoke_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","And he gave forth his voice with weeping; and the Mizraee heard, and a man of Pharoh’s house heard. ");
INSERT INTO engoke_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","And Joseph said to his brothers, I am Joseph! Is my father yet living? And his brethren were not able to answer him a word, for they were confounded before him. ");
INSERT INTO engoke_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","And Joseph said to his brothers, Come near now to me. And they came near. And he said, I am Joseph your brother, whom you sold into Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","And now do not be troubled, and let it not be afflictive in your eyes that you sold me hither; for to sustain life did the Lord send me before you. ");
INSERT INTO engoke_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these two years hath famine been in the land, and there are yet five years in which there will be neither seed nor harvest. ");
INSERT INTO engoke_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","And the Lord sent me before you to set a remnant in the earth, and to keep you alive by a great deliverance. ");
INSERT INTO engoke_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","And now, it was not you who sent me hither, but (it was) from before the Lord, who hath set me to be a father unto Pharoh, and to rule all the men of his house, holding power over all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hasten, (then,) and go up to my father, and say to him, Thus saith thy son Joseph, The Lord hath set me ruler over the Mizraim: come down to me, delay not, ");
INSERT INTO engoke_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","And thou shalt dwell in the land of Goshen, and be near me, thou, and thy sons, and thy sons’ children, and thy sheep and thy oxen, and all that thou hast. ");
INSERT INTO engoke_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","And I will nourish thee there; for there are yet five years of famine, lest thou, and the men of thy house, and all that thou hast, be wasted away. ");
INSERT INTO engoke_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","And, behold, your eyes see, and the eyes of my brother Benjamin, that in your language I speak with you. ");
INSERT INTO engoke_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","And you will show my father all my glory in Mizraim, and all that you see; and make haste, and bring down my father hither. ");
INSERT INTO engoke_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","And he fell upon the neck of Benjamin his brother, and wept; and Benjamin wept upon his neck. ");
INSERT INTO engoke_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","And he kissed all his brothers, and wept over them; and afterward his brothers discoursed with him. ");
INSERT INTO engoke_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","And a voice was heard in the house of Pharoh, saying, The brothers of Joseph are come. And it was pleasing in the eyes of Pharoh, and in the eyes of his servants. ");
INSERT INTO engoke_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","And Pharoh said to Joseph, Tell my brethren, Do this; lade your beasts and go; carry into the land of Kenaan; ");
INSERT INTO engoke_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","and take your father and the men of your house and come to me, and I will give you the good of the land of Mizraim, and you shall eat the good of the land. ");
INSERT INTO engoke_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","And (now) thou art commanded, this do. Take to you out of the land of Mizraim waggons for your children, and your wives; and bring your father, and come. ");
INSERT INTO engoke_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","And let not your eye look wistfully upon your furniture; for the good of all the land of Mizraim is your own. ");
INSERT INTO engoke_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","And the sons of Israel did so; and Joseph gave them waggons, according to the word of Pharoh, and he gave them provisions for the way. ");
INSERT INTO engoke_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","And he gave to everyone of them vestments for wearing; and to Benjamin gave he three hundred shekels of silver, and five vestments for wearing. ");
INSERT INTO engoke_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","And to his father he sent ten asses laden with the good things of Mizraim, and ten she-asses laden with corn, and bread and provisions for the way. ");
INSERT INTO engoke_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","And he dismissed his brethren, and they went, and he said to them, Do not contend by the way. ");
INSERT INTO engoke_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","And they went up from Mizraim and came into the land of Kenaan, unto Jakob their father. ");
INSERT INTO engoke_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","And they showed him, saying, Joseph is yet alive, and he ruleth over all the land of Mizraim! And these words were uncertain upon his heart, because he did not believe them. ");
INSERT INTO engoke_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","And they told him all the words of Joseph which he had spoken with them; and he saw the waggons that Joseph had sent to fetch him; and the Holy Spirit rested upon Jakob their father. ");
INSERT INTO engoke_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","And Israel said, Great to me is the joy! Joseph my son is yet alive; I will go, and behold him before I die. ");
INSERT INTO engoke_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","And Israel journeyed, and all that he had, and came to Beer Shava; and he offered sacrifices to the God of his father Izhak. ");
INSERT INTO engoke_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","And the Lord spake to Israel in a vision of the night, and said, Jakob, Jakob. And he said, Behold, I am. ");
INSERT INTO engoke_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","And He said, I am God, the God of thy father: fear not to go down into Mizraim; for a great people will I make thee there. ");
INSERT INTO engoke_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with thee into Mizraim, and will surely bring thee up; but Joseph shall lay his hand upon thine eyes. ");
INSERT INTO engoke_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","And Jakob arose from Beer Shava. And the sons of Israel carried Jakob their father, and their children, and their wives, in the waggons which Pharoh had sent to fetch them. ");
INSERT INTO engoke_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","And they took their flocks and their substance which they had gotten in the land of Kenaan, and came to Mizraim, Jakob and all his sons with him. ");
INSERT INTO engoke_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","His sons, and his son’s sons with him, his daughters, and the daughters of his sons, and all his seed, he brought with him into Mizraim. ");
INSERT INTO engoke_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","And these are the names of the sons of Israel which came into Mizraim, Jakob and his sons. The firstborn of Jakob, Reuben. ");
INSERT INTO engoke_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","And the sons of Reuben. Hanuk and Phallu, Hesron and Karmi. ");
INSERT INTO engoke_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","And the sons of Sheemon, Jemuel, and Janin, and Ahad, and Jakin, and Zochar, and Shaul, the son of a Kenaanitha. ");
INSERT INTO engoke_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","And the sons of Levi, Gershon, Kehath, and Merari. ");
INSERT INTO engoke_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","And the sons of Jehuda, Er, and Onan, and Shelah, and Pharets, and Zarach. But Er and Onan had died in the land of Kenaan And the sons of Pharets, Heshron and Chamul. ");
INSERT INTO engoke_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","And the sons of Issakar, Tola, and Pheua, and Job, and Semeron. ");
INSERT INTO engoke_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","And the sons of Zabulon, Sered, and Elon, and Jahleel. ");
INSERT INTO engoke_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are the sons of Leah, which she bare to Jakob in Padan Aram, and Dinah his daughter; all the souls, his sons and his daughters, thirty and three. ");
INSERT INTO engoke_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","And the children of Gad, Sephyon and Haggi, Shuni and Ezbon, Eri, and Arodi, and Areli. ");
INSERT INTO engoke_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","And the sons of Asher, Jemna, and Jesva, and Jesvi, and Beriah, and Serach, their sister. And the sons of Beriah, Heber and Malchiel. ");
INSERT INTO engoke_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the sons of Zilpha, whom Laban gave to Leah his daughter; and she bare these unto Jakob, sixteen souls. ");
INSERT INTO engoke_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Rahel, the wife of Jakob, Joseph and Benjamin. ");
INSERT INTO engoke_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","And to Joseph were born in the land of Mizraim Menashe and Ephraim, whom Asenath, daughter of Potiphera, prince of On, bare unto him. ");
INSERT INTO engoke_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","And the sons of Benjamin, Bela, and Bekor, and Ashbel, Gera, and Naaman, Achi, and Rosh, Muppim, and Huphim, and Arede. ");
INSERT INTO engoke_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are the sons of Rahel which were born to Jakob; all the souls fourteen. ");
INSERT INTO engoke_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","And the sons of Dan, Hushim: ");
INSERT INTO engoke_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","And the sons of Naphtali, Jahziel, and Guni, and Jezer, and Shilem. ");
INSERT INTO engoke_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are the children of Billah, whom Laban gave to Rahel his daughter, and she bare them to Jakob; all the souls seven. ");
INSERT INTO engoke_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All the souls which went with Jakob into Mizraim, which came forth from his loins, besides the wives of Jakob’s sons, all the souls, sixty and six. ");
INSERT INTO engoke_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","And the sons of Joseph, which were born to him in Mizraim, two souls. All the souls of the house of Jakob which went into Mizraim were seventy. ");
INSERT INTO engoke_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","And he sent Jehuda before him to Joseph, to make the way clear before him at Goshen, and he came to the land of Goshen. ");
INSERT INTO engoke_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","And Joseph arrayed his chariot, and went up to meet Israel his father in Goshen. And he saw him, and fell upon his neck, and wept. And he wept still upon his neck! ");
INSERT INTO engoke_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","And Israel said to Joseph, I could-die at this time! I have consolation now that I have seen thy face; for thou art yet alive. ");
INSERT INTO engoke_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","And Joseph said to his brothers, and to the house of his father, I will go up and show Pharoh, and will tell him, My brethren and the house of my father, who were in the land of Kenaan, have come to me. ");
INSERT INTO engoke_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","But the men are shepherds of sheep: for the men are masters of flocks, and their sheep and oxen and all that they have they have brought. ");
INSERT INTO engoke_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","And it shall be when Pharoh calleth you, and shall ask you, What is your employment? ");
INSERT INTO engoke_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","You will say, Thy servants have been men, the masters of flocks from our youth until now; both we and our fathers: that you may dwell in the land of Goshen; because the Mizraee keep at a distance all shepherds of flocks. ");
INSERT INTO engoke_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","And Joseph came and showed Pharoh, and said, My father and my brethren, and their sheep and their oxen, and all that they have, are come from the land of Kenaan, and, behold, they are in the land of Goshen. ");
INSERT INTO engoke_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","And of the extreme of his brethren he took five men, and made them stand before Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","And Pharoh said to his brethren, What are your employments? And they said to Pharoh, thy servants are shepherds; both we and our fathers. ");
INSERT INTO engoke_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","And they said to Pharoh, To dwell in the land are we come for there is no pasture for thy servants’ flocks; for the famine prevails in the land of Kenaan, and we pray thee let thy servants dwell in the land of Goshen. ");
INSERT INTO engoke_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","And Pharoh spake to Joseph, saying, Thy father and thy brethren are come to thee; ");
INSERT INTO engoke_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","The land of Mizraim is before thee in the best of it let thy father and thy brethren dwell, (even) in the land of Goshen: and if thou know any of them to be men of ability, appoint them to be chiefs over my flocks. ");
INSERT INTO engoke_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","And Joseph brought Jakob his father, and presented him before Pharoh: and Jakob blessed Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","And Pharoh said to Jakob, How many are the days of the years of thy life? ");
INSERT INTO engoke_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","And Jakob said to Pharoh, The days of the years of my pilgrimage are a hundred and thirty years. Few and evil have been the days of the years of my life, and I have not attained to the days of the years of the life of my fathers, in the days of their pilgrimage. ");
INSERT INTO engoke_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","And Jakob blessed Pharoh, and went out from before Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","And Joseph made his father and his brethren to dwell, and gave them a possession in the land of Mizraim, in the best of the land, in the land of Ramesis, as Pharoh had commanded. ");
INSERT INTO engoke_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","And Joseph sustained his father and his brethren, and all the house of his father, with bread, according to the mouth of the family (of each). ");
INSERT INTO engoke_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","And there was no bread in all the land; for the famine prevailed greatly, and the people of the land of Mizraim and the people of the land of Kenaan failed before the famine. ");
INSERT INTO engoke_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","And Joseph collected all the money which was found in the land of Mizraim and in the land of Kenaan, for the corn which they bought. And Joseph brought the money into the house of Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","And the money was finished from the land of Mizraim and from the land of Kenaan; and all the Mizraee came to Joseph, saying, Give us bread: for why should we die before thee? For the money is finished. ");
INSERT INTO engoke_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","And Joseph said, Bring your cattle, and I will give you provision, if your money is finished. ");
INSERT INTO engoke_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","And they brought their cattle to Joseph, and Joseph gave them bread for their horses, and for their flocks of sheep, and for their herds of oxen, and for their asses, and for all their cattle; he fed them with bread for that year. ");
INSERT INTO engoke_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","And that year was completed; and they came to him in the second year, and said to him, We will not conceal it from our lord, but the money is ended, and (we have delivered up) our cattle to our lord, and there is nothing left before our lord but our bodies and our land. ");
INSERT INTO engoke_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why should we perish before thee, both we and our land? Buy us and our land for bread, and we and our land will be servants to Pharoh, and give us seed corn, that we may live and not die, and the land may not be desolate. ");
INSERT INTO engoke_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","And Joseph acquired all the land of Mizraim for Pharoh; for the Mizraee sold every man his portion, because the famine prevailed over them, and the land became Pharoh’s. ");
INSERT INTO engoke_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","And the people he made him to pass from city to city, from one end of the limit of Mizraim to the other. ");
INSERT INTO engoke_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Only the land of the priests he did not buy; for a portion (was given) by Pharoh to the priests: and they ate their portion which Pharoh gave them; therefore they sold not their land. ");
INSERT INTO engoke_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","And Joseph said to the people, Behold, I have bought you this day and your land for Pharoh. Behold, (I give) you seed corn, that you may sow the land. ");
INSERT INTO engoke_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","And it shall be, when it bringeth forth produce, that you shall give one in five to Pharoh, and four parts shall be yours, of the corn of the field, that you and the men of your house may eat, and your little ones have food. ");
INSERT INTO engoke_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","And they said, Thou hast preserved us; may we find grace in the eyes of my lord, and we will be the servants of Pharoh. ");
INSERT INTO engoke_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","And Joseph made it a statute unto this day over the land of Mizraim, that one of five should be given to Pharoh; only the land of the priests alone was not Pharoh’s. ");
INSERT INTO engoke_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","And Israel dwelt in the land of Mizraim in the land of Goshen, and possessed it: and they increased and multiplied greatly. ");
INSERT INTO engoke_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","And Jakob lived in the land of Mizraim seventeen years. And the days of the years of the life of Jakob were a hundred and forty and seven years. ");
INSERT INTO engoke_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","And the days of Israel drew near to die. And he called to his son, to Joseph, and said to him, If now I have found favour in thine eyes, put, I beseech thee, thine hand under my thigh, and deal with me in goodness and truth; nor bury me, I beseech thee, in Mizraim; ");
INSERT INTO engoke_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","But I will sleep with my fathers; and thou shalt carry me from Mizraim, and bury me in their sepulchre. And he said, I will do according to thy word. ");
INSERT INTO engoke_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","And he said, Swear to me; and he sware to him. And Israel worshipped upon the pillow of the bed. ");
INSERT INTO engoke_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","And it was after these words that it was said to Joseph, Behold, thy father is ill. And he took his two sons with him, Menashe and Ephraim. ");
INSERT INTO engoke_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","And it was shown to Jakob, and told (him,) Behold, thy son Joseph cometh to thee. And Israel was strengthened, and he sat upon the bed. ");
INSERT INTO engoke_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","And Jakob said to Joseph, El Shadai revealed Himself to me in Luz, in the land of Kenaan, and blessed me; ");
INSERT INTO engoke_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","And He said to me, Behold, I will multiply thee, and make thee great, and will set thee for an assembly of tribes, and will give this land to thy sons after thee for an everlasting inheritance. ");
INSERT INTO engoke_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","And now thy two sons which were born to thee in the land of Mizraim, before my coming to thee into Mizraim, are mine; Ephraim and Menashe shall be as Reuben and Shimeon before me. ");
INSERT INTO engoke_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","And the children whom thou mayest beget after them, who shall be thine, after the name of their brethren they shall be called in their inheritance. ");
INSERT INTO engoke_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","And I, in my coming from Padan, Rahel died by me in the land of Kenaan, in the way, while as yet there was a space of ground to come unto Ephrath. And I buried her there, by the way to Ephrath, which is Bethlehem. ");
INSERT INTO engoke_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","And Israel saw the sons of Joseph, and said, Who are these? ");
INSERT INTO engoke_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","And Joseph said to his father, They are my sons whom the Lord hath given me here. And he said, Bring them now near to me, that I may bless them. ");
INSERT INTO engoke_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","But the eyes of Israel were heavy from age, and he could not discern. And he brought them near to him, and he kissed them, and embraced them. ");
INSERT INTO engoke_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","And Israel said to Joseph, I had not hoped to see thy face, and, behold, the Lord hath showed me thy sons also. ");
INSERT INTO engoke_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","And Joseph led them from before him, and worshipped with his face on the earth. ");
INSERT INTO engoke_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","And Joseph took both of them, Ephraim in his right hand, on the left of Israel, and Menashe in his left hand, on the right of Israel, and brought them to him. ");
INSERT INTO engoke_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","And Israel stretched out his right hand, and laid it on the head of Ephraim, who was the younger; and his left hand on the head of Menashe, using his hands designingly; (or, instructing his hands;) for Menashe was the first-born. ");
INSERT INTO engoke_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","And he blessed Joseph, and said, The Lord, before whom my fathers Abraham and Izhak did serve; the Lord, who fed me from my coming unto this day; ");
INSERT INTO engoke_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","The Angel who redeemed me from all evil, bless the youths; and let my name be called upon them, and the name of my fathers Abraham and Izhak; and as the fish of the sea may they multiply among the children of men upon the earth! ");
INSERT INTO engoke_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","And Joseph saw that his father laid his right hand upon the head of Ephraim; and it was evil in his eyes. And he uplifted his father’s hand, to remove it from Ephraim’s head, that it might rest on the head of Menashe. ");
INSERT INTO engoke_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","And Joseph said to his father, Not so, my father; for this is the first-born: lay thy right hand on his head. ");
INSERT INTO engoke_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father willed not, and said, I know, my son, I know: he also shall be for a people, and he also shall be great; yet his younger brother will be greater than he, and his sons shall have dominion among the nations. ");
INSERT INTO engoke_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","And he blessed them in that day, saying, By thee shall Israel bless, saying, The Lord set thee as Ephraim and as Menashe. And he set Ephraim before Menashe. ");
INSERT INTO engoke_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","And Israel said to Joseph, Behold, I die; but the Word of the Lord will be your Helper, and restore you to the land of your fathers. ");
INSERT INTO engoke_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","And I will give thee one portion more than thy brethren, which I took from the band of the Amoraah by my prayer and by my deprecation. ");
INSERT INTO engoke_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","And Jacob called his sons, and said, Gather together, and I will show you what will befall you in the end of the days; ");
INSERT INTO engoke_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Assemble, and hearken, O sons of Jakob, and receive instruction from Israel your father. ");
INSERT INTO engoke_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, thou art my first-born, my strength, and the beginning of my power. Thine should it have been taking to take the three portions, the birthright, the priesthood, and the kingdom: but because thou hast proceeded perversely, ");
INSERT INTO engoke_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Behold, as water outpoured thou wilt not prosper, neither wilt thou receive the excellent portion; because thou wentest up to thy father’s place of sleep: then, my son, didst thou become profane, when thou wentest up to my bed. ");
INSERT INTO engoke_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shimeon and Levi are brothers; mighty men in the land of their sojourning, they did mightily. ");
INSERT INTO engoke_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","My soul was not in their secret; into their company to come I would not have descended from mine honour. For in their anger they slew a slaughter, and in their wilfulness they razed the wall of their enemy. ");
INSERT INTO engoke_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Accursed was their anger, for it was strong, and their wrath, for it was relentless. I will divide them in Jakob, and I will scatter them in Israel. ");
INSERT INTO engoke_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jehuda, thou art praise and not shame; thy brethren shall praise thee; thy hand shall prevail against thine adversaries, thine enemies shall be dispersed; they will be turned backward before thee, and the sons of thy father will come before thee with salutations. The dominion shall be (thine) in the beginning, and in the end the kingdom shall be increased from the house of Jehuda, because from the judgment of death, my son, hast thou withdrawn. ");
INSERT INTO engoke_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","He shall repose, and abide in strength as a lion, and as a lioness, there shall be no king that may cut him off. ");
INSERT INTO engoke_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","He who exerciseth dominion shall not pass away from the house of Jehuda, nor the saphra from his children’s children forever, until the Meshiha come, whose is the kingdom, and unto whom shall be the obedience of the nations (or, whom the peoples shall obey). ");
INSERT INTO engoke_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Israel shall pass round about in his cities; the people shall build his temple, they will be righteous round about him, and be doers of the law through his doctrine. Of goodly purple will be his raiment, and his vesture of crimson wool with colours. ");
INSERT INTO engoke_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His mountains shall be red with his vineyards, and his hills be dropping with wine; his valleys shall be white with corn, and with flocks of sheep. ");
INSERT INTO engoke_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon will dwell nigh the haven of the sea; he will subdue provinces with ships, and will eat the good of the sea, and his boundary shall come unto Sidon. ");
INSERT INTO engoke_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakar, rich in substance, will have his heritage between the boundaries; ");
INSERT INTO engoke_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","And he, seeing his portion that it is good, and the land that it is fruit-bearing, will subdue the provinces of the people, and disperse their inhabitants, and they who remain of them will become servants to him and bringers of tribute. ");
INSERT INTO engoke_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","From the house of Dan will be chosen and will arise a man in whose days his people shall be delivered, and in whose years the tribes of Israel have rest together. ");
INSERT INTO engoke_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","A chosen man will arise from the house of Dan, the terror of whom shall fall upon the peoples; (a man) who will smite the Philistines with strength, as the serpent, the deadly serpent, lurking by the way, be will slay the mighty of the Philistines host, the horsemen with the foot; he will weaken (loosen) the horses and chariots, and throw their riders backward. ");
INSERT INTO engoke_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","For thy salvation have I waited, O Lord! ");
INSERT INTO engoke_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","From the house of Gad will armed hosts go over the Jardena before their brethren to the battle; and with much substance will they return unto their land. ");
INSERT INTO engoke_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","The land of Asher will be good; and he shall be nourished with the dainties of kings. ");
INSERT INTO engoke_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","In a good land will the lot of Naphtali be cast, and his inheritance be fruitful; over them will they give praise and benediction. ");
INSERT INTO engoke_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is my son who shall increase, my son who shall be blessed, as a vine planted by a fountain of waters. Two tribes will come forth from his sons, and they shall receive a portion and inheritance. ");
INSERT INTO engoke_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The mighty men, the men of division, were bitter against him; they afflicted him and sorely grieved him ");
INSERT INTO engoke_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","And his prophecy shall be fulfilled in them, because he was faithful to the law in secret, and set his confidence firmly. Therefore was gold laid upon his arm, and the kingdom was strengthened and confirmed. This was to him from the mighty God of Jacob, who by His Word pastureth the fathers and the children of the seed of Israel. ");
INSERT INTO engoke_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","The Word of the God of thy father shall be thy Helper, and the All-Sufficient shall bless thee, with the blessings of the dew that descends from the heavens above, with the blessings that spring from the depths of the earth beneath, with the blessings of thy father and of thy mother. ");
INSERT INTO engoke_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessing of thy father shall be added upon the blessing with which my fathers blessed me; which the princes who are of the world have desired: all of them shall be upon the head of Joseph, and upon the man who was separated from his brethren. ");
INSERT INTO engoke_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin: in his land will dwell the Shekina, and in his possession will the sanctuary be builded. In the morning and evening will the priests offer the oblation, and at eventime divide the remaining portions of the residue of the sacred things. ");
INSERT INTO engoke_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","All these the tribes of Israel are twelve; and this it is which their father spake to them, and blessed them; according to the blessing of each man, blessed he them. ");
INSERT INTO engoke_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","And he commanded them, and said to them, I am to be gathered unto my people; bury me with my fathers in the cavern which is in the field of Ephron the Hitaah; ");
INSERT INTO engoke_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","In the cavern which is in the double field over against Mamre, in the land of Kenaan, which field Abraham bought of Ephron the Hitaah for an inheritancesepulchre. ");
INSERT INTO engoke_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There buried they Abraham and Sarah his wife; there buried they Izhak and Revekah his wife; and there buried I Leah. ");
INSERT INTO engoke_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The field, and the cavern that is in it, purchased of the sons of Hitaah. ");
INSERT INTO engoke_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","And Jakob ceased to instruct his sons, and drew his feet together in the bed, and died, and was gathered unto his people. ");
INSERT INTO engoke_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","And Joseph fell upon his father’s face, and wept over him, and kissed him. ");
INSERT INTO engoke_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","And Joseph commanded his servants, the physicians, to embalm his father; and the physicians embalmed Israel. ");
INSERT INTO engoke_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","And forty days were completed to him; for so are completed the days of the embalmed; and the Mizraee mourned for him seventy days. ");
INSERT INTO engoke_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","And the days of his mourning passed: and Joseph spake with the house of Pharoh, saying, If now I have found favour in your eyes, speak, I pray, before Pharoh, saying ");
INSERT INTO engoke_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","My father adjured me, saying, Behold, I die; in my sepulchre which I have prepared for me in the land of Kenaan, there shalt thou bury me. And now let me go up, I pray, and I will bury my father and return. ");
INSERT INTO engoke_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","And Pharoh said, Go up and bury thy father, as he adjured thee. ");
INSERT INTO engoke_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","And Joseph went up to bury his father; and all the servants of Pharoh, the elders of his house, and all the elders of the land of Mizraim, ");
INSERT INTO engoke_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Went up with him; and all the house of Joseph, and his brethren, and the house of his father: only the children, and the flocks, and the cattle, they left in the land of Goshen. ");
INSERT INTO engoke_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","And with him went up, also, chariots and horsemen; and there was a very great host. ");
INSERT INTO engoke_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","And they came to the threshing-floor of Atad, which is beyond Jardena, and lamented there with lamentations great and very strong. And he made a mourning for his father seven days. ");
INSERT INTO engoke_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","And the inhabitants of the land of Kenaan saw the mourning at the threshing-floor of Atad, and said, This is a mighty mourning of the Mizraee; therefore its name is called Abel Mizraim; which is beyond Jardena. ");
INSERT INTO engoke_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","And his sons did as he had commanded them. ");
INSERT INTO engoke_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","And his sons carried him into the land of Kenaan, and buried him in the cavern of the Double Field, which Abraham bought for an inheritancesepulchre of Ephron the Hitaah, before Mamre. ");
INSERT INTO engoke_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","And Joseph returned into Mizraim, he and his brethren, and all who went up with him to bury his father, after he had buried his father. ");
INSERT INTO engoke_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","And the brethren of Joseph saw that their father was dead; and they said, Perhaps Joseph will retain enmity against us, and requiting will requite us all the evil which we did him. ");
INSERT INTO engoke_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","And they made visitation to Joseph, saying, Thy father commanded before his death, saying, ");
INSERT INTO engoke_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Thus shall you speak to Joseph, I pray you to forgive the guilt of thy brethren and their sin wherewith they did evil against thee. And now forgive, I beseech thee, the guilt of the servants of the God of thy father. And Joseph wept when they spake with him. ");
INSERT INTO engoke_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","And his brethren came and fell before him, and said, Behold, we are thy servants. ");
INSERT INTO engoke_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","And Joseph said to them, Fear not, for I fear the Lord. ");
INSERT INTO engoke_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","When you thought evil against me, before the Lord it was intended for good, to be done, as at this day, for the preservation of much people. ");
INSERT INTO engoke_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","And now do not fear; I will sustain you and your children. And he consoled them, and spake consolation to their heart. ");
INSERT INTO engoke_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","And Joseph dwelt in Mizraim, he and his father’s house. And Joseph lived an hundred and ten years. ");
INSERT INTO engoke_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","And Joseph saw of Ephraim three sons; also the sons of Makir, the son of Menashe, were born, whom Joseph brought up. ");
INSERT INTO engoke_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","And Joseph said to his brethren, I die; but the Lord remembering will remember you, and bring you up from, this land to the land of which He sware to Abraham, to Izhak, and to Jakob. ");
INSERT INTO engoke_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","And Joseph adjured the sons of Israel, saying, The Lord remembering will remember you, and you shall carry my bones up from hence. ");
INSERT INTO engoke_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","And Joseph died, the son of a hundred and ten years, and they embalmed him, and laid him in an ark in Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","And these are the names of the sons of Israel who came into Mizraim with Jakob; (each) man with the men of his house they came in: ");
INSERT INTO engoke_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Shimeon, Levi and Jehudah, ");
INSERT INTO engoke_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakar, Zebulon and Benyamin, ");
INSERT INTO engoke_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali, Gad and Asher. ");
INSERT INTO engoke_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","And all the souls that came forth from the thigh of Jakob were seventy souls, with Joseph who was in Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","And Joseph died, and all his brethren, and all that generation; ");
INSERT INTO engoke_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","But the sons of Israel increased and propagated, and became great and very mighty, and the land was filled with them. ");
INSERT INTO engoke_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","But a new king arose over Mizraim who did not hold valid (or confirm) the decree of Joseph. ");
INSERT INTO engoke_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","And he said to his people, Behold, the people of the sons of Israel are more numerous and stronger than we: ");
INSERT INTO engoke_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let us deal wisely by them, lest they multiply, and it be that should war happen to us they join themselves with our enemies, and break forth in the war against us, and go up from the land. ");
INSERT INTO engoke_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","And they appointed over them evildoing governors (shiltonin) to afflict them in their labours. And they builded cities of treasure houses for Pharoh, Pithom, and Raamsas. ");
INSERT INTO engoke_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But by as much as they afflicted them, so they increased and waxed strong, and the Mizraee had vexation on account of the sons of Israel; ");
INSERT INTO engoke_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","And the Mizraee made the sons of Israel serve with rigour, ");
INSERT INTO engoke_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","and embittered their lives with hard labour, in clay and in brick, and in all labour of the field, all the work which they wrought, they made them do with hardship. ");
INSERT INTO engoke_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","And the king of Mizraim spake to the midwives of Jewesses, (Yehuditha,) of whom the name of the one was Shiphra, and the name of the second Puvah; ");
INSERT INTO engoke_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","And he said, When you do the office of the midwife among the Jewish women, and you look upon the childbirth, if it be a son, you shall kill him; but if a daughter, let her live. ");
INSERT INTO engoke_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the midwives feared before the Lord, and did not act as the king of Mizraim had bidden them, but preserved the sons alive. ");
INSERT INTO engoke_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","And the king of Mizraim called ");
INSERT INTO engoke_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The midwives said to Pharoh, It is because the Jewesses are unlike the Mizraite women; they are cunning, and give birth before the midwives come to them. ");
INSERT INTO engoke_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","And the Lord did good to the midwives; and the people multiplied and became strong. ");
INSERT INTO engoke_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","And because the midwives feared before the Lord He made for them houses. ");
INSERT INTO engoke_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","But Pharoh commanded all his people, saying, Every son who is born to the Jews you shall throw into the river, and every daughter you shall keep alive. ");
INSERT INTO engoke_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","And a man of the house of Levi went and took a daughter of Levi (to wife). ");
INSERT INTO engoke_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","And the woman conceived, and bare a son; and she saw that he was good, and concealed him three months. ");
INSERT INTO engoke_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","But not being able to hide him longer, she took an ark of reed, and covered it with bitumen and pitch, and laid the child within it, and set it in the river upon the brink of the stream. ");
INSERT INTO engoke_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","And his sister stationed herself at a distance, to know what would be done to him. ");
INSERT INTO engoke_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","And the daughter of Pharoh came down to wash at the river, and her damsels walked on the river’s bank; and she saw the ark in the flood, and reached out her arm and took it. ");
INSERT INTO engoke_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","And opening, she saw the child; and, behold, the infant wept. And she had compassion on him and said, This is one of the children of the Jehudaee. ");
INSERT INTO engoke_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then spake his sister to the daughter of Pharoh, Shall I go and call a nurse-woman of the Jehudaee who will suckle the child for thee? ");
INSERT INTO engoke_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","And the daughter of Pharoh said to her, Go; and the maiden went, and called the child’s mother. ");
INSERT INTO engoke_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","And Pharoh’s daughter said to her, Take this child and nurse it for me, and I will give thee they recompense. And the woman took the child and suckled him. ");
INSERT INTO engoke_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","And the child grew, and she brought him to Pharoh’s daughter, and he became to her a son, and she called his name Mosheh, saying, Because I drew him out from the water. ");
INSERT INTO engoke_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","And it was in those days when Mosheh had grown that he went out to his brethren and beheld their servitude. And he saw a Mizraite man smite a man, a Jehudai, (one) of his brethren. ");
INSERT INTO engoke_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","And he turned this way and that, and saw that there was no man; and smote the Mizraite, and buried him in the sand. ");
INSERT INTO engoke_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","And he went out the second day, and, behold, two men, Jehudaeen contended. And he said to the guilty one, Why did you strike your companion? ");
INSERT INTO engoke_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","But he said, Who set you a chief man and judge over us? Will you who speak so kill me, as you killed the Mizraya? And Mosheh was afraid, and said, Surely the thing is known. ");
INSERT INTO engoke_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","And Pharoh heard that thing, and sought to kill Mosheh; and Mosheh fled from before Pharoh, and dwelt in the land of Midian. And he sat by a well; ");
INSERT INTO engoke_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","And the prince (rabba) of Midian had seven daughters; and they came and drew and filled the troughs to water their father’s flock. ");
INSERT INTO engoke_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","But the shepherds came and drave them away; and Mosheh arose and rescued them, and watered the flock. ");
INSERT INTO engoke_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","And they came to Reuel their father; and he said, What is this, that ye have come so quickly today? ");
INSERT INTO engoke_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","And they said, A man, a Mizraya, delivered us from the hand of the shepherds, and also drew for us and watered the flock. ");
INSERT INTO engoke_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","And he said to his daughters, And where is he? Wherefore have you left the man? Call him, that he may eat bread. ");
INSERT INTO engoke_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","And Mosheh was willing to dwell with the man; and he gave Zipporah his daughter unto Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","And she bare a son; and he called his name Gershom; for, said he, I am a stranger in a foreign land. ");
INSERT INTO engoke_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","And it was in many of those days: and the king of Mizraim died. And the sons of Israel groaned with the hard service which was upon them; and the cry rose up before the presence of the Lord, form their labour. ");
INSERT INTO engoke_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","And their appeal was heard before the Lord; and the Lord remembered His covenant with Abraham, with Izhak, and with Jakob. ");
INSERT INTO engoke_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","And the servitude of the sons of Israel was know before the Lord, and the Lord said in His Word, that He would deliver them. ");
INSERT INTO engoke_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","And Mosheh tended the flock of Jethro his father-in-law, the rabba of Midian, and he led the flock to the place of the best pastures of the wilderness, and came to the mountain on which was revealed the glory of the Lord, unto Horeb. ");
INSERT INTO engoke_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","And the Angel of the Lord appeared to him in a flame of fire in the midst of a bush. And he gazed, and, behold, the bush burned with fire, but the bush was not consumed. ");
INSERT INTO engoke_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","And Mosheh said, I will now turn and see this great sight, why the bush is not burned up. ");
INSERT INTO engoke_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","And the Lord saw that he turned to see, and the Lord called to him from the midst of the bush, and said, Mosheh, Mosheh! And he said, Behold me. ");
INSERT INTO engoke_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","And He said, Approach not hither; loose the sandal from thy foot, for the place where thou standest is holy. ");
INSERT INTO engoke_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","And He said, I am the God of thy fathers; the God of Abraham, the God of Izhak, and the God of Jakob. And Mosheh bowed with his face; for he was afraid to look up to the glory of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","And the Lord said, The bondage of My people who is in Mizraim is verily disclosed before Me, and before Me is heard their cry on account of their toils; for their afflictions are disclosed before me; ");
INSERT INTO engoke_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","And I have appeared to deliver them from the hand of the Mizraee, and to bring them up from that land, unto a land good and large, a land producing milk and honey, unto the place of the Kenaanaee, an the Hittaee, and the Amoraee, and the Perizaee, and the Hivaee, and the Yevusaee. ");
INSERT INTO engoke_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","And now, behold, the cry of the sons of Israel ascendeth before Me, and the affliction is also revealed before Me wherewith the Mizraee afflict them. ");
INSERT INTO engoke_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","And now, come, I will send thee to Pharoh, and will bring forth the sons of Israel form Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","And Mosheh said before the Lord, Who am I, that I should go unto Pharoh to bring forth the sons of Israel from Mizraim? ");
INSERT INTO engoke_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","And He said, Because My Word shall be thy helper: and this shall be the sign that I have sent thee: In thy leading forth of the people from Mizraim you shall do service before the Lord upon this mountain. ");
INSERT INTO engoke_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","And Mosheh said before the Lord, Behold, when I am come to the sons of Israel, and say to them, The God of your fathers hath sent me to you, and they say to me, What is His name? What shall I say to them? ");
INSERT INTO engoke_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","And the Lord said unto Mosheh, EHEYEH ASHER EHEYEH. And he said, Thus shalt thou speak to the sons of Israel, EHEYEH hath sent me unto you. ");
INSERT INTO engoke_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","The Lord said moreover to Mosheh, Thus shalt thou speak to the sons of Israel, The Lord, the God of your fathers, the God of Abraham, the God of Izhak, and the God of Jakob, hath sent me unto you. This is My Name forever, and this is My Memorial in every generation and generation. ");
INSERT INTO engoke_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go and assemble the elders of Israel and say to them, The Lord, the God of your fathers, hath revealed Himself to me, the God of Abraham, Izhak, and Jakob, saying, Remembering I have remembered you, and that which hath been done to you in Mizraim; ");
INSERT INTO engoke_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","And I have said that I would bring you up from the bondage of Mizraim to the land of the Kenaanaee, and Hittaee, and Emoraee, and the Pherizaee, and Hivaee, and Jebusaee, to a land producing milk and honey. ");
INSERT INTO engoke_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","And they will be obedient to thee, and thou shalt go, thou and the elders of Israel, to the king of Mizraim, and say to him, The Lord, the God of the Jehudaee, hath called us; and now let us go, as (for) a journey of three days into the desert, that we may sacrifice before the Lord our God. ");
INSERT INTO engoke_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But it is manifest before Me that the king of Mizraim will not release you, that you may go, not even on account of Him whose power is mighty. ");
INSERT INTO engoke_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","But I will send forth the stroke of My power, and will smite the Mizraee with all My miracles which I will perform among them, and afterward they will send you away. ");
INSERT INTO engoke_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","And I will give this people to become favourites in the eyes of the Mizraee, and it shall be that when you go you shall not go empty. ");
INSERT INTO engoke_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","But you shall demand, a woman of her neighbour and the inmates of her house, articles of silver and of gold and vestments, and put them upon you sons and upon your daughters, and shall make the Mizraee empty. ");
INSERT INTO engoke_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","And Mosheh answered and said, But, behold, they will not believe me nor hearken to me: for they will say, The Lord hath no been revealed to thee. ");
INSERT INTO engoke_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","And the Lord said to him, What is that which is in thy hand? And he said, A rod. ");
INSERT INTO engoke_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","And He said, Cast it to the ground; and he cast it upon the ground, and it became a serpent, and Mosheh fled from before it. ");
INSERT INTO engoke_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","And the Lord said to Mosheh, Stretch forth thy hand and seize it by its tail; and he put forth his hand and grasped it, and it became a rod in his hand. ");
INSERT INTO engoke_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","That they may believe that the Lord god of their fathers hath been revealed to thee, that God of Abraham, the God of Izhak, and the God of Jakob. ");
INSERT INTO engoke_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","And the Lord said yet to him, Put now thy hand into thy bosom. And he put his hand into his bosom, and drew it out; and, behold, his hand was white as snow. ");
INSERT INTO engoke_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","And He said, Return thy hand into thy bosom. And he returned his hand into his bosom, and drew it out form his bosom, and, behold, it had turned to be as his own flesh. ");
INSERT INTO engoke_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","And it shall be, if they will not believe thee nor receive the voice of the first sign, that they shall believe the voice of the latter sign. ");
INSERT INTO engoke_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","But if they will not believe either of these two signs, nor receive from thee, take of the water that is in the river, and pour it upon the ground; and the water which thou takest form the river shall become blood upon the ground. ");
INSERT INTO engoke_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","And Mosheh said before the Lord, In entreating, I am not a man who is (well) spoken, neither yesterday nor the day before, and from the time that thou spakest with Thy servant: for I am heavy of speech and of a deep tongue. ");
INSERT INTO engoke_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","But the Lord said to him, Who hath appointed the mouth of man, and who hath appointed the mute, or the deaf, or the open-sighted, or the blind? Have not I, the Lord? ");
INSERT INTO engoke_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","And now go, and My Word shall be with thy mouth, and I will teach thee what to say. ");
INSERT INTO engoke_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","And he said, I beseech the Lord to send by the hand of one who is fit to be sent. ");
INSERT INTO engoke_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","And the displeasure of the Lord was kindled against Mosheh; and He said, Is not Aharon the Levite, thy brother, known before Me as one who speaking can speak? And also, behold, he cometh forth to anticipate thee, and will see thee, and rejoice in his heart. ");
INSERT INTO engoke_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","And thou shalt speak with him, and put the words in his mouth; and My Word will be with thy mouth and with his mouth, and I will teach you what to do. ");
INSERT INTO engoke_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","And he shall speak for thee with the people, and shall be thy interpreter, and thou shalt be to him a rab; ");
INSERT INTO engoke_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","And this staff thou shalt take in thy hand wherewith to work the signs. ");
INSERT INTO engoke_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","And Mosheh went, and returned to Jether his father-in-law, and said to him, I will now go and return to my brethren who are in Mizraim, and see if they still live. And Jether said to Mosheh, Go in peace. ");
INSERT INTO engoke_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","And the Lord said to Mosheh in Midian, Go, return to Mizraim; for all the men who sought to kill thee are dead. ");
INSERT INTO engoke_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","And Mosheh took his wife and his sons, and made them ride upon the ass, and returned to the land of Mizraim. And Mosheh took the staff with which the miracles had been done before the Lord in his hand. ");
INSERT INTO engoke_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","And the Lord said to Mosheh, In thy going to return to Mizraim look to all the wonders that I have appointed by thy hand, and do them before the Pharoh. But I will obdurate his heart, and he will not send the people away. ");
INSERT INTO engoke_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","And thou shalt say unto Pharoh, Thus said the Lord; Israel is My son, My firstborn. ");
INSERT INTO engoke_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","And I say unto thee, Let My son go, that he may serve before Me; and if thou refuse to send him away, behold, I will kill thy son, thy firstborn. ");
INSERT INTO engoke_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","And it was in the way, at the place of lodging, that the Angel of the Lord met him, and sought to kill him. ");
INSERT INTO engoke_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","And Zipporah took a stone, and circumcised the foreskin of her son, and approached before him, and said, On account of the blood of this circumcision let my husband be given (back) to me. ");
INSERT INTO engoke_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","And when he had desisted from him, she said, But for the blood of this circumcision my husband would have been condemned to die. ");
INSERT INTO engoke_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","And the Lord said to Aharon, Go thou to meet Mosheh in the desert. And he went, and met him at the mountain on which was revealed the glory of the Lord, and he kissed him. ");
INSERT INTO engoke_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","And Mosheh showed Aharon all the words with which the Lord had sent him, and all the signs which he had commanded. ");
INSERT INTO engoke_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","And Mosheh and Aharon went and assembled all the elders of the sons of Israel; ");
INSERT INTO engoke_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","And Aharon told all the words which the Lord had spoken with Mosheh, and did the signs in the eyes of the people. ");
INSERT INTO engoke_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","And the people believed, and understood (heard) that the Lord had remembered the sons of Israel, and that heir slavery was manifest before him; and they bowed, and adored. ");
INSERT INTO engoke_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","And afterward Mosheh and Aharon went in, and said to Pharoh: Thus saith the Lord, the God of Israel, Let My people go, to solemnize a feast (yechagun) before Me in the desert. ");
INSERT INTO engoke_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","And Pharoh said, The name of the Lord is not know to me, that I should hearken to His word to send Israel away. The name of the Lord is not revealed to me, and Israel I shall not release. ");
INSERT INTO engoke_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","And they said, The God of the Jehudaee hath revealed Himself to us; let us now go three days’ journey into the desert to sacrifice before the Lord our God, lest He come upon us with death or with slaughter. ");
INSERT INTO engoke_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","And the king of Mizraim said to them, Why, Mosheh and Aharon, do you hinder the people from their works? Go to your employment. ");
INSERT INTO engoke_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","And Pharoh said, Behold now, the people of the land are many, and you make them relax from their employment. ");
INSERT INTO engoke_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","And Pharoh that day commanded the masters of the people and the overseers, saying, ");
INSERT INTO engoke_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","You shall not continue (add) to give straw to the people to cast bricks, as heretofore; let them go and collect straw for themselves; ");
INSERT INTO engoke_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Yet the number of bricks which they have made heretofore you shall still lay upon them and not diminish; for they are idle, and therefore cry, saying, We will go and sacrifice before our God. ");
INSERT INTO engoke_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Make labour heavy upon the men: let them be occupied with it, and not with vain words. ");
INSERT INTO engoke_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","And the masters of the people and the overseers went forth and spake to the people, saying, Thus saith Pharoh, I will not give you straw; ");
INSERT INTO engoke_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","You shall go and gather up straw for yourselves wheresoever you can find it; though from you work there shall be mother diminished. ");
INSERT INTO engoke_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","And the people were scattered abroad over all the country of Mizraim to gather stubble for straw. ");
INSERT INTO engoke_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","And the masters were urgent, saying, Fulfil your work, the matter of a day in a day, as you did when straw was given to you. ");
INSERT INTO engoke_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","And the masters whom Pharoh set over the sons of Israel smote them, saying, Why do you not fulfil your requirement to cast bricks as heretofore, as yesterday, so also today? ");
INSERT INTO engoke_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","And the overseers of the sons of Israel came and complained before Pharoh, saying, Why hast thou done thus with thy servants? ");
INSERT INTO engoke_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Thou hast not given thy servants straw, yet they say to us, Make bricks; and, behold, thy servants are beaten, and thy people sin against us. ");
INSERT INTO engoke_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But he said, You are idle: therefore you say, We will go and sacrifice before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","And now go, work: but straw I will not give you; yet the number of bricks you shall render. ");
INSERT INTO engoke_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","And the overseers of the sons of Israel perceived that they were in evil: for they said to them, You shall not diminish form your bricks the matter of a day, in a day. ");
INSERT INTO engoke_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","And they met Mosheh and Aharon standing before them in their coming out from being with Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","And they said to them, May the Lord manifest Himself to you and adjudge; because you have made our savour evil in the eyes of Pharoh, and in the eyes of his servants, and have put a sword into their hands to kill us! ");
INSERT INTO engoke_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","And Mosheh returned before the Lord and said, O Lord, why hast Thou done evil unto this people, and wherefore didst Thou send me? ");
INSERT INTO engoke_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","And from the time that I went in to Pharoh to speak in Thy name he hath done evil to this people, but liberating Thou hast not liberated Thy people. ");
INSERT INTO engoke_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","But the Lord said to Mosheh, Now shalt thou see what I will do to Pharoh: for with a strong hand shall he send them away, and with a strong hand drive them from his land. ");
INSERT INTO engoke_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","And the Lord spake to Mosheh and said to him, I am the Lord; ");
INSERT INTO engoke_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","And I appeared unto Abraham and to Izhak and to Jakob by (the name) EI-Shaddai, but by My name Jehovah I was not known to them. ");
INSERT INTO engoke_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","And also I have confirmed My covenant with them to give them the land of Kenaan, the land of their sojournings in which they sojourned. ");
INSERT INTO engoke_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","And before Me hath been heard the cry of the sons of Israel whom the Mizraee make to labour for them; and I have remembered My covenant. ");
INSERT INTO engoke_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore, say thou to the sons of Israel, I am the Lord, and I will bring you out from the midst of the sore labour for the Mizraee, and will deliver you from their servitude, and redeem you with a lofty arm and with great judgments. ");
INSERT INTO engoke_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","And I will bring you nigh before Me to be a people, and I will be unto you a God; and you shall know that I am the Lord your God who bringeth you out from the sore Mizrean bondage. ");
INSERT INTO engoke_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","And I will lead you into the land which I have sworn in My Word to give to Abraham, to Izhak, and to Jakob; and to you will I give it for an inheritance; I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","And Mosheh so spake with the sons of Israel: but they received not from Mosheh through anguish of spirit, and from the labour which was hard upon them. ");
INSERT INTO engoke_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","And the Lord spake to Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Go in, speak with Pharoh king of Mizraim, that he send away the sons of Israel from his land. ");
INSERT INTO engoke_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","And Mosheh spake before the Lord, saying, Behold, the sons of Israel have not received from me, and how then will Pharoh receive, and I (so) heavy of speech? ");
INSERT INTO engoke_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","And the Lord spake to Mosheh and Aharon, and gave them commandment to the sons of Israel and unto Pharoh king of Mizraim for the going forth of the sons of Israel from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the heads of the house of their fathers. The sons of Reuben the firstborn of Israel, Hanuk and Phalli, Hetsron and Karmi; these are the progeny of Reuben. ");
INSERT INTO engoke_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","And the sons of Shimeon, Yemuel and Yamin and Achad and Yakin and Zochar and Shaul the son of a Kenaanitha; these are the progeny of Shimeon. ");
INSERT INTO engoke_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","And these are the names of the sons of Levi, according to their generations: Gershon and Kehath and Merari. And the years of the life of Levi were a hundred and thirty and seven years. ");
INSERT INTO engoke_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gerson, Libni and Shimei, after their progenies. ");
INSERT INTO engoke_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","And the sons of Kehath. Amram and Izhar and Hebron and Uzziel. And the years of the life of Kehath, a hundred and thirty and three years. ");
INSERT INTO engoke_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","And the sons of Merari, Maheli and Mushi. These are the progenies of Levi, after their generations. ");
INSERT INTO engoke_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","And Amram took Yokebed the sister of his father unto him to wife, and she bare him Aharon and Mosheh. And the years of the life of Amram were an hundred and thirty and seven years. ");
INSERT INTO engoke_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","And the sons of Izhar, Korah and Nepheg and Zikri. ");
INSERT INTO engoke_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","And the sons of Uzziel, Mishael and Elzaphan and Sithri. ");
INSERT INTO engoke_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","And Aharon took Elisheba the daughter of Aminadab the sister of Nachshon to him to wife; and she bare him Nadab and Abihu, Elazar and Ithamar. ");
INSERT INTO engoke_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","And the sons of Korah, Asir and Elkanah and Abiasaph: these are the progeny of Korah. ");
INSERT INTO engoke_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","And Elazar the son of Aharon took (one) of the daughters of Phutiel to himself to wife, and she bare him Pinhas. These are the chiefs of the fathers of the Levaee, according to their generations. ");
INSERT INTO engoke_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","It is Aharon and Mosheh, to whom the Lord had said, Bring forth the sons of Israel from the land of Mizraim by their armies. ");
INSERT INTO engoke_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","These are they who spake with Pharoh king of Mizraim to let the sons of Israel go forth from Mizraim: it is Mosheh and Aharon. ");
INSERT INTO engoke_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","And it was in the day when the Lord spake with Mosheh in the land of Mizraim, ");
INSERT INTO engoke_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","That the Lord spake unto Mosheh, saying, I am the Lord: Speak with Pharoh king of Mizraim all that I have said to thee. ");
INSERT INTO engoke_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Mosheh said before the Lord, Behold, I am heavy of speech, and how will Pharoh receive from me? ");
INSERT INTO engoke_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","But the Lord said to Mosheh, See, I have appointed thee a Master (rab) with Pharoh, and Aharon shall be thy interpreter (methurgeman). ");
INSERT INTO engoke_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Thou shalt speak all that I have commanded thee, and Aharon thy brother shall speak with Pharoh to send away the sons of Israel from his land. ");
INSERT INTO engoke_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","And I will harden the heart of Pharoh, and will multiply My signs and wonders in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But Pharoh will not receive from you; and I will give forth the stroke of My power upon Mizraim, and will bring out My host, My people, the sons of Israel, from the land of Mizraim by great judgments. ");
INSERT INTO engoke_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","And the Mizraee shall know that I am the Lord when I uplift the stroke of My power upon Mizraim, and bring forth the sons of Israel from among them. ");
INSERT INTO engoke_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","And Mosheh and Aharon did as the Lord commanded them, so did they. ");
INSERT INTO engoke_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","And Mosheh was the son of eighty years, and Aharon the son of eighty and three years, in their speaking with Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","And the Lord spake to Mosheh and Aharon, saying, ");
INSERT INTO engoke_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","When Pharoh shall speak to you, saying, Produce a sign, thou shalt say to Aharon, Take thy rod, and throw it down before Pharoh. And it shall become a serpent (tanina, Heb tanin, a long creature, whether serpent or crocodile). ");
INSERT INTO engoke_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","And Mosheh and Aharon went in unto Pharoh, and did as the Lord had commanded them. Aharon threw down his rod before Pharoh and before his servants, and it became a serpent. ");
INSERT INTO engoke_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","And Pharoh called for the wise men and the magicians; and they also, the Mizraite magicians, did so by their enchantments. ");
INSERT INTO engoke_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","They cast down every man his rod, and they became serpents; but the rod of Aharon swallowed up their rods. ");
INSERT INTO engoke_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","And Pharoh’s heart was hardened, and be would not hearken to them, as the Lord had said. ");
INSERT INTO engoke_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","And the Lord said to Mosheh, The heart of Pharoh is obdurate (heavy): he is unwilling to send the people away. ");
INSERT INTO engoke_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go unto Pharoh in the morning; behold, he goeth forth to the waters, and stand to meet him on the bank of the river, and the rod that was turned to a serpent (hevja, Heb, nachash) take in thy hand; ");
INSERT INTO engoke_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","And say to him, The Lord God of the Jehudaee hath sent me to thee, saying, Release My people, that they may serve before Me in the desert; and, behold, thou hast not yet acceded. ");
INSERT INTO engoke_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Thus saith the Lord, By this thou shalt know that I am the Lord: Behold, with the rod that is in my hand I smite the water of the river, and it shall be turned to blood: ");
INSERT INTO engoke_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","And the fish which are in the river shall die, and the river become putrid, and the Mizraee try in vain to drink the water from the river. ");
INSERT INTO engoke_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","And the Lord spake to Mosheh, Say to Aharon, Take thy rod, and lift up thy hand over the waters of the Mizraee, upon their rivers, upon their canals, and upon their lakes, and upon all their reservoirs of water, that they may become blood; and there shall be blood in all the land of Mizraim, and in vessels of wood and in vessels of stone. ");
INSERT INTO engoke_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","And Mosheh and Aharon did so, as the Lord commanded; and he lifted the rod, and struck the waters of the river, in the sight of Pharoh, and in the eyes of his servants, and all the waters of the river were turned into blood. ");
INSERT INTO engoke_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","And the fish of the river died, and the river became putrid; and the Mizraee could not drink of the water of the river, and there was blood in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","And the magicians did so with their enchantments; and Pharoh’s heart was hardened, and he would not hearken to them, as the Lord had said. ");
INSERT INTO engoke_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","And Pharoh turned and entered into his house; neither did he set his heart also unto this. ");
INSERT INTO engoke_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","And all the Mizraee digged by the bending of the river for water to drink; for the water which was in the river they could not drink. ");
INSERT INTO engoke_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","And seven days were fulfilled after that the Lord had struck the river; ");
INSERT INTO engoke_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","And the Lord said to Mosheh, Go in unto Pharoh and say to him, Thus saith the Lord: Send away My people, that they may serve before me. ");
INSERT INTO engoke_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","But if thou refuse to send them away, behold, I will smite all thy borders with frogs, ");
INSERT INTO engoke_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","And the river shall multiply frogs; and they shall come up and enter into thy house, and into thy chamber the place of sleep, and upon thy bed, and into the house of thy servants, and among thy people, and into thy ovens and thy kneading pans; ");
INSERT INTO engoke_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","And upon thee and upon thy people and upon all thy servants shall the frogs come up. ");
INSERT INTO engoke_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","And the Lord said to Mosheh, Say to Aharon, Uplift thy hand with thy staff upon the streams, upon the rivulets, and upon the lakes; and the frogs shall come up on the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","And Aharon lifted up his hand over the waters of the Mizraee, and the frogs came up and covered the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","And the magicians did so with their enchantments, and made frogs to come up on the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","And Pharoh called Mosheh and Aharon, and said, Pray before the Lord that the frogs may be removed from me and from my people; and I will release the people, that they may sacrifice before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","And Mosheh said to Pharoh, Demand for thyself a miracle, and appoint me a time when I shall pray for thee, and for thy servants and thy people, that the frogs may be finished from thee and from thy house, and remain only in the river. ");
INSERT INTO engoke_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","And he said, Tomorrow. And he said, According to thy word; that thou mayest know that there is none as the Lord our God. ");
INSERT INTO engoke_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","And the frogs shall be removed from thee and from thy house and thy servants and thy people; in the river only shall they remain. ");
INSERT INTO engoke_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","And Mosheh and Aharon went out from Pharoh; and Mosheh prayed before the Lord concerning the frogs which he had appointed unto Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","And the Lord did according to the words of Mosheh; and the frogs died from the houses, and from the courts, and from the fields. ");
INSERT INTO engoke_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","And they gathered them in heaps (upon) heaps, and they corrupted upon the ground. ");
INSERT INTO engoke_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","And Pharoh saw that there was relief; and hardened his heart, and would not hearken to them, as the Lord had said. ");
INSERT INTO engoke_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","And the Lord spake to Mosheh, Say unto Aharon, Lift up thy rod and smite the dust of the earth, and it shall become, insects, in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And they did so. And Aharon lifted up his hand with the rod and smote the dust of the earth, and it became insects on man and on cattle; all the dust of the earth became insects in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","And the magicians wrought so with their enchantments to produce the insects, but were not able; and there were insects on man and on beast. ");
INSERT INTO engoke_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","And the magicians said to Pharoh, This is a plague from before the Lord. Yet Pharoh’s heart was hardened, and he would not hearken to them, as the Lord had said. ");
INSERT INTO engoke_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","And the Lord said to Mosheh, Arise in the morning and stand before Pharoh; behold, he goeth out to the waters; and say to him, Thus saith the Lord, Send My people away, that they may serve before Me. ");
INSERT INTO engoke_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","For if thou wilt not send My people away, behold, I will send on thee, and on thy servants, and on thy people, and upon thy houses, the aroba; I and they shall fill the houses of the Mizraee with the aroba; and also the ground on which they are. ");
INSERT INTO engoke_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","But I will make a distinction in that day with the land of Goshen where My people dwell, that the aroba shall not be there; so that thou mayest know that I the Lord do rule in the midst of the earth. ");
INSERT INTO engoke_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","And I will ordain redemption to My people, but upon thy people shall be the plague. Tomorrow shall this sign be. ");
INSERT INTO engoke_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","And the Lord did so; and the aroba came with strength into the house of Pharoh, and into the house of his servants, and into all the land of Mizraim; and the land was destroyed before the aroba. ");
INSERT INTO engoke_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","And Pharoh called for Mosheh and Aharon, and said, Go, sacrifice before your God in the land. ");
INSERT INTO engoke_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But Mosheh said, It will not be fitting to do so; because the animals which the Mizraee worship we shall take to sacrifice before the Lord our God. Behold, should we immolate the animal which the Mizraee worship, would they not stone us when they saw it? ");
INSERT INTO engoke_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","A journey of three days will we go into the desert, and sacrifice before the Lord our God, as He hath told us. ");
INSERT INTO engoke_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","And Pharoh said, I will send you away, that you may sacrifice before the Lord your God in the desert; only you shall not go farther and farther: pray also for me. ");
INSERT INTO engoke_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","And Mosheh said, Behold I will go out from being with thee, and will pray before the Lord, and He will remove the aroba from Pharoh, and from his servants, and his people, tomorrow; only let Pharoh no more be false in not sending away the people to sacrifice unto the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","And Mosheh went out from before Pharoh, and prayed before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","And the Lord did according to the word of Mosheh, and removed the aroba from. Pharoh and his servants, and his people; not one remained. ");
INSERT INTO engoke_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","But Pharoh hardened his heart this time also, and would not dismiss the people. ");
INSERT INTO engoke_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","And the Lord said to Mosheh, Go in unto Pharoh and say to him: Thus saith the Lord, the God of the Jehudaee; Send My people away, that they may serve before Me: ");
INSERT INTO engoke_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","For if thou refuse to send them away, and thou hast kept them until now, ");
INSERT INTO engoke_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","behold, a plague from before the Lord shall be upon thy cattle which are in the field; upon the horses, upon the asses, upon the camels, upon the oxen, and upon the sheep, a very great death. ");
INSERT INTO engoke_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But the Lord will make distinction between the cattle of Israel and the cattle of the Mizraee; and of all that the children of Israel possess not one shall die. ");
INSERT INTO engoke_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","And the Lord set a time, saying, Tomorrow will the Lord do this thing in the land. ");
INSERT INTO engoke_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And the Lord did that thing on the following day, and all the cattle of the Mizraee died; but of the cattle of the sons of Israel died not one. ");
INSERT INTO engoke_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","And Pharoh sent, and, behold, not one of the cattle of the sons of Israel had died. And Pharoh’s heart was hardened, and he would not send the people away. ");
INSERT INTO engoke_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","And the Lord said to Mosheh and Aharon, Take you handfuls of dust of the furnace, and let Mosheh scatter it towards the heavens in the presence of Pharoh; ");
INSERT INTO engoke_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","And it will be like fine powder upon all the land of Mizraim, and it shall be upon man and beast an inflammation growing into ulcers in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","And they took the dust of the furnace and stood before Pharoh; and Mosheh scattered it towards the heavens, and it became an inflammation of ulcers multiplying on man and beast. ");
INSERT INTO engoke_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","And the magicians could not stand before Mosheh, on account of the disease; for the disease was upon the magicians and upon all the Mizraee. ");
INSERT INTO engoke_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","And the Lord obdurated the heart of Pharoh, and he would not hearken to them, as the Lord had said to Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","And the Lord said to Mosheh, Rise up in the morn-ing and stand before Pharoh, and say to him, Thus saith the Lord, the God of the Jehudaee Send My people away, that they may serve before Me: ");
INSERT INTO engoke_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For at this time I will send all My plagues upon thy heart, and upon thy servants and thy people, that thou mayest know that there is no one like Me, the Ruler in all the earth. ");
INSERT INTO engoke_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For now it is nigh before Me to send indeed My strong plagues, and smite thee and thy people with death, and cut thee off from the earth. ");
INSERT INTO engoke_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","For therefore have I raised thee up, that I may show thee My power, and that they may acknowledge the might of My name in all the earth. ");
INSERT INTO engoke_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Until now hast thou kept My people down, that thou mayest not release them. ");
INSERT INTO engoke_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Behold, I will cause to come down, as at this time tomorrow, hail most mighty, the like of which hath never been in Mizraim from the day that it was founded until now. ");
INSERT INTO engoke_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","And now, send, gather in thy cattle and all that thou hast in the field; for upon every man and beast that may be found in the field not gathered into the house the hail will fall, and they shall die. ");
INSERT INTO engoke_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Who feared the word of the Lord among the servants of Pharoh collected his servants and his cattle unto the houses; ");
INSERT INTO engoke_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","But he who did not set his heart upon the word of the Lord, left his servants and his cattle in the field. ");
INSERT INTO engoke_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","And the Lord said to Mosheh, Uplift thy hand towards the heavens, and there shall be hail in all the land of Mizraim upon man, and beast, and every herb of the field throughout the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","And Mosheh lifted up the rod towards the heavens, and the Lord sent thunders, (voices,) and hail, and fire going upon the ground: and the Lord rained hail upon the land of Mizraim, ");
INSERT INTO engoke_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","And there was hail, and fire flaming among the hail, very mighty, such as the like of had not been in all the land of Mizraim since the time it had been for a people. ");
INSERT INTO engoke_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","And the hail smote in all the land of Mizraim all that was in the field from man to cattle, and every herb of the field the hail struck, and every tree of the field it brake. ");
INSERT INTO engoke_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen, where the sons of Israel were, there was no hail. ");
INSERT INTO engoke_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","And Pharoh sent and called for Mosheh and Aharon, and said to them, I have sinned this time; the Lord is righteous, and I and my people are guilty. ");
INSERT INTO engoke_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray before the Lord that relief may be multiplied before Him, so that there may be upon us no more thunders of malediction like these before the Lord, nor hail; and I will send you away, and will not continue to detain you. ");
INSERT INTO engoke_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","And Mosheh said to him, When I shall have gone out of the city, I will spread forth my hands in prayer before the Lord, and the thunders shall cease, and there shall be no more hail, that you may know that the earth is the Lord’s. ");
INSERT INTO engoke_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But (as for) thee and thy servants, I know that as yet ye are not humbled before the Lord God. ");
INSERT INTO engoke_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","And the flax and the barley were smitten, because the barley was earing and the flax was in flower: ");
INSERT INTO engoke_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the wheat and the spelt were not smitten, for they were later. ");
INSERT INTO engoke_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","And Mosheh went out of the city from Pharoh, and spread forth his hands in prayer before the Lord, and the thunders ceased, and the hail and the rain which had descended came not (more) upon the earth. ");
INSERT INTO engoke_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","And Pharoh saw that the rain had ceased, and the hail and the thunders, and he added yet to sin, and hardened his heart, he and his servants. ");
INSERT INTO engoke_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","And the heart of Pharoh was hardened, and he would not send away the sons of Israel, as the Lord had spoken by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","And the Lord said to Mosheh, Go in unto Pharoh; for I have hardened his heart. And the heart of his servants, to set these My signs among them; ");
INSERT INTO engoke_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and that thou mayest relate before thy son and the son of thy son the miracles which I wrought in Mizraim and the signs that I did set among them, that ye may know that I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","And Mosheh and Aharon entered unto Pharoh, and said to him, Thus saith the Lord the God of the Jehudaee, Until now thou hast obstinately refused to humble thyself before Me; send My people away, that they may serve Me. ");
INSERT INTO engoke_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","For if thou refuse to release My people, behold, tomorrow I will bring the locust into thy borders, ");
INSERT INTO engoke_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","And he shall cover the eye of the sun of the earth, (or, shall hide the sun (which is) the eye of the earth,) so that it will not be possible to see the ground; and he will devour the residue which hath been spared (saved) and that hath been reserved to you from the hail, and will devour every tree which groweth up for you from the field; ");
INSERT INTO engoke_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","and they shall fill thy house, and the houses of thy servants, and the houses of all the Mizraee, which thy fathers have not seen, nor the fathers of thy fathers, from the day they were upon the earth until this day. And he turned and went out from Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","And the servants of Pharoh said to him, How long shall this man be an injury (stumbling-block) to us? Send the men away, that they may serve before the Lord their God. Knowest thou not yet that Mizraim hath perished? ");
INSERT INTO engoke_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","And Mosheh and Aharon were made to return unto Pharoh; and he said to them; Go, serve before the Lord your God: (but) who and who shall go? ");
INSERT INTO engoke_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","And Mosheh said, With our young ones and with our old men will we go; with our sons and with our daughters, with our sheep and with our oxen, will we go; for we have a feast before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","And he said to them, So be the Word of the Lord in your help when I send you away and your little ones: beware, for the evil that you are thinking to do will be turned against your faces. ");
INSERT INTO engoke_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Not so: but let the men go and serve before the Lord; for it was that which you demanded. And they were driven from before Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","And the Lord said to Mosheh, Lift up thy hand over the land of Mizraim, that the locusts may come, and go up on the land of Mizraim, and devour every herb of the earth, even all which the hail hath left. ");
INSERT INTO engoke_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","And Mosheh stretched forth his rod upon the land of Mizraim, and the Lord led an east wind upon the land all that day and all the night; at morn the east wind bare the locust. ");
INSERT INTO engoke_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","And the locust came up on all the land of Mizraim, and abode in all the boundary of Mizraim exceedingly strong. Before him the locust had never been like him nor afterward will he be so; ");
INSERT INTO engoke_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","And he covered the eye of the sun of all the earth, and the earth was darkened; and he devoured every herb of the ground, and all the fruit of the trees which the hail had left; and there did not remain any green on the trees nor herbage of the field in all the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","And Pharoh made haste to call Mosheh and Aharon, and said, I have sinned before the Lord your God, and you. ");
INSERT INTO engoke_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","And now, forgive my sin only this time, and intercede before the Lord your God, that He may remove from me only this death. ");
INSERT INTO engoke_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","And they went out from Pharoh, and prayed before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","And the Lord turned a west wind exceedingly strong, and it carried the locust and drave him into the sea of Suph, nor did one locust remain in all the border of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yet the heart of Pharoh was hardened, and he would not send the sons of Israel away. ");
INSERT INTO engoke_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","And the Lord said to Mosheh, Uplift thy hand towards heaven, and there shall be darkness upon the land of Mizraim after the darkness of the night hath passed away. ");
INSERT INTO engoke_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","And Mosheh lifted up his hand towards heaven, and there was darkness of darkness in all the land of Mizraim three days: ");
INSERT INTO engoke_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","A man saw not his brother, nor did any man rise up from his place, three days. Yet, all the sons of Israel had light in their dwellings. ");
INSERT INTO engoke_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","And Pharoh called Mosheh and said, Go, serve before the Lord; only leave your sheep and your oxen, your little ones also may go with you. ");
INSERT INTO engoke_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Mosheh said, Thou must give into our hands also the holy victims and holocausts, that we may serve before the Lord our God. ");
INSERT INTO engoke_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our cattle too shall go with us, and there shall not remain any thereof; for of it we must take to serve the Lord our God, and we know not with what we have to do service before Him until we come thither. ");
INSERT INTO engoke_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the Lord hardened Pharoh’s heart, and he was not willing to send them away. ");
INSERT INTO engoke_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","And Pharoh said to him, Go from me. Beware for thyself. See my face no more; for in the day that thou seest my face thou shalt die. ");
INSERT INTO engoke_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","And Mosheh said, Thou hast spoken well. I will see thy face no more. ");
INSERT INTO engoke_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","But the Lord said to Mosheh, Yet one plague will I bring upon Pharoh and upon Mizraim; after which he will send you hence. When sending away he thoroughly driving will drive you from hence. ");
INSERT INTO engoke_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Speak now before the people of Israel that a man shall require of his companion, and a woman of her companion, vessels of silver and vessels of gold. ");
INSERT INTO engoke_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","And the Lord gave the people favour in the eyes of the Mizraee; also the man Mosheh was very great in the land of Mizraim, in the eyes of the servants of Pharoh and in the eyes of the people. ");
INSERT INTO engoke_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","And Mosheh said, Thus saith the Lord, At the dividing of the night I will be revealed in the midst of Mizraim, ");
INSERT INTO engoke_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","And all the firstborn in the land of Mizraim shall die; from the firstborn of Pharoh who would sit upon the throne of his kingdom, unto the firstborn of the womanservant who is behind the mills, and all the firstborn of cattle. ");
INSERT INTO engoke_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","And there shall be a great cry in all the land of Mizraim, the like of which hath not been, nor will be the like of it again. ");
INSERT INTO engoke_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But anyone of the sons of Israel no dog will hurt even with his tongue by barking, from man and to beast, so that you shall know that the Lord hath distinguished between the Mizraee and Israel. ");
INSERT INTO engoke_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","And all these thy servants shall come down to me, and beseech of me, saying, Go forth, thou and all thy people who are with thee: and after that I will go forth. And he went out from Pharoh with vehement anger. ");
INSERT INTO engoke_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","And the Lord said to Mosheh, Pharoh will not hearken to you; therefore will I multiply My wonders in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","And Mosheh and Aharon wrought all these wonders before Pharoh; but the Lord hardened Pharoh’s heart, that he would not send the children of Israel from his land. ");
INSERT INTO engoke_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","And the Lord spake to Mosheh and Aharon in the land of Mizraim, saying, ");
INSERT INTO engoke_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","This month shall be to you the beginning of the months; the first, it shall be to you, of the months of the year. ");
INSERT INTO engoke_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Speak with all the congregation of Israel, saying, In the tenth of this month they shall take to them every man a lamb for the house of a father, a lamb for the house. ");
INSERT INTO engoke_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","And if the house be smaller than the numbering (required) for the lamb, let him take himself, and his neighbour who is nearest to his house, according to the number of the souls, every man according to the mouth of his eating shall you count over the lamb. ");
INSERT INTO engoke_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","The lamb shall be perfect, a male, the son of a year; it shall be to you; from the sheep or from the goats you may take it. ");
INSERT INTO engoke_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","And you shall have it in keeping till the fourteenth day of this month, and the whole church (kehala) of the congregation of Israel shall kill him between the suns. ");
INSERT INTO engoke_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","And they shall take of the blood, and apply it upon the two posts and upon the lintel of the houses in which they eat him. ");
INSERT INTO engoke_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","And they shall eat the flesh in that night roasted with fire, and (with) unleavened cake with bitters you shall eat him. ");
INSERT INTO engoke_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","You shall not eat of it while living, neither boiled with boiling in water, but roasted with fire; his head with his feet and his inwards. ");
INSERT INTO engoke_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","And you shall not leave of it till the morning; and that which remains of it till morning you shall burn in the fire. ");
INSERT INTO engoke_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","And thus shall you eat it; with your loins girded, with your sandals on your feet, and your staves in your hands, and you shall eat it in haste; it is the Pascha before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","And I will appear in the land of Mizraim in that night, and will kill every firstborn in the land from man unto beast, and on all the idols of Mizraim I will execute judgment: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","And the blood shall be for you a sign upon the houses where you are; and I will see the blood, and will have mercy upon you, and there shall not be among you the destruction of death when I slay in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","And this day shall be to you for a memorial, and you shall solemnize it a festival before the Lord in your generations; an everlasting ordinance (covenant) shall you solemnize it. ");
INSERT INTO engoke_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","no translation ");
INSERT INTO engoke_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","And on the first day there shall be an holy congregation, and on the seventh day an holy congregation shall there be to you. Every kind of work may not be done in them; save what pertains to the eating of every soul, that only may be done by you. ");
INSERT INTO engoke_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","And you shall keep the (feast of the) Unleavened; for on this very day shall I have brought your hosts out of the land of Mizraim, and you shall keep this day to all your generations forever. ");
INSERT INTO engoke_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In Nisan, on the fourteenth day of the month in the evening you shall eat unleavened, until the twenty and first of the mouth in the evening. ");
INSERT INTO engoke_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Seven days leaven shall not be found in your houses; for whosoever will eat of that which is leavened, that man shall perish from the congregation of Israel, of the stranger, or of the native of the land. ");
INSERT INTO engoke_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You shall eat no leavened (food), in all your dwellings you shall eat unleavened. ");
INSERT INTO engoke_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","And Mosheh called for all the elders of Israel, and said to them, Draw out, and take to you from the sons of the flock for your families, and kill the pascha. ");
INSERT INTO engoke_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","And you shall take a bundle of hyssop and dip it in the blood that is in the basin, and sprinkle upon the lintel and the two posts from the blood which is in the basin; and you shall not go forth from the door of your house until the morning. ");
INSERT INTO engoke_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For the Lord will be revealed to smite the Mizraee; and seeing the blood upon the lintel and upon the two posts, the Lord will be merciful upon the door, and will not suffer the Destroyer (or destruction) to enter your houses to smite. ");
INSERT INTO engoke_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","And you shall observe the thing for an ordinance to thee and to thy sons forever. ");
INSERT INTO engoke_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","And it shall be, when you have entered into the land which the Lord will give you as He hath said, that you shall (still) keep this service. ");
INSERT INTO engoke_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","And it shall be, when your children say to you, What is this service to you? ");
INSERT INTO engoke_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","You shall say, It is a sacrifice for compassion before the Lord, because He had compassion on the house of the sons of Israel in Mizraim, when He smote the Mizraee, but spared our houses. And the people bowed and worshipped. ");
INSERT INTO engoke_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","And the sons of Israel went and did as the Lord had commanded Mosheh and Aharon, so did they. ");
INSERT INTO engoke_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","And it came to pass at the dividing of the night that the Lord slew all the firstborn in the land of Mizraim; from the firstborn of Pharoh who should sit on the throne of his kingdom unto the firstborn of the captive in the house of the chained, and all the firstborn of cattle. ");
INSERT INTO engoke_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","And Pharoh rose up in that night, and all his servants and all the Mizraee; and there was a great cry in Mizraim, because there was no house in which there was not the dead. ");
INSERT INTO engoke_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","And he cried to Mosheh and to Aharon by night, and said, Arise, go out from among my people, you and the sons of Israel, and go and serve before the Lord, as you have said. ");
INSERT INTO engoke_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Your flocks and your herds take also, as you have spoken, and go, and pray also for me. ");
INSERT INTO engoke_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","And the Mizraee were forcible on the people to hasten to send them away; for they said, All of us are dead. ");
INSERT INTO engoke_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","And the people took their dough while not leavened, remaining in the kneading pans, bound with their clothes upon their shoulders. ");
INSERT INTO engoke_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","And the children of Israel did according to the word of Mosheh, and demanded of the Mizraee vessels of silver, and vessels of gold, and raiment. ");
INSERT INTO engoke_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","And the Lord gave the people favour in the eyes of the Mizraee, and they demanded of them, and left the Mizraee empty. ");
INSERT INTO engoke_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","And the children of Israel journeyed from Ramases to Succoth; about six hundred thousand men on foot, besides children (or families); ");
INSERT INTO engoke_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","And a multitude of strangers also went up with them, and flocks and herds and very much cattle. ");
INSERT INTO engoke_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","And they baked the dough which they had brought out from Mizraim (into) unleavened cakes; for it had not been leavened, because they had been driven out from Mizraim and could not stay, and they had not made provision. ");
INSERT INTO engoke_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","And the dwelling of the sons of Israel in their abode in Mizraim (was) four hundred and thirty years. ");
INSERT INTO engoke_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","And it was at the end of four hundred and thirty years, in that same day, that all the hosts of the Lord went forth from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It is a night to be kept before the Lord for bringing them forth from the land of Mizraim: this is that night before the Lord kept by all the children of Israel in their generations. ");
INSERT INTO engoke_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","And the Lord said to Mosheh and to Aharon, This is the rite of the Pascha. Every son of Israel who apostatizes shall not eat of it; ");
INSERT INTO engoke_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But every male servant bought with silver, and thou hast circumcised him, may eat thereof. ");
INSERT INTO engoke_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A sojourner and a hireling shall not eat thereof. ");
INSERT INTO engoke_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In one company it shall be eaten. You shall not carry any of the flesh from the house without, and a bone shall not be broken in him. ");
INSERT INTO engoke_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All the congregation of Israel shall do this. ");
INSERT INTO engoke_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","And when the sojourner who sojourneth with thee will perform the pascha before the Lord, every male of his shall be circumcised, and he may then approach and perform it; he shall be as one born in the land, but none uncircumcised shall eat of it. ");
INSERT INTO engoke_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","One law shall there be for the native and for the proselyte who sojourneth among you. ");
INSERT INTO engoke_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","And all the children of Israel did as the Lord commanded Mosheh and Aharon, so did they. ");
INSERT INTO engoke_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And it was on the same day that the Lord led forth the sons of Israel from the land of Mizraim by their armies. ");
INSERT INTO engoke_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Sanctify unto Me all the firstborn. Everyone which openeth the womb among the children of Israel, of man and of beast, that is Mine. ");
INSERT INTO engoke_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","And Mosheh said to the people, Remember this day, in which you went forth from Mizraim from the house of servitude; for with a mighty hand hath the Lord brought you forth from thence; and you shall not eat what is leavened. ");
INSERT INTO engoke_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","This day have you come out, in the month of Abiba. ");
INSERT INTO engoke_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","And it shall be when the Lord hath led thee into the land of the Kenaanaee and Hittaee and Emoraee and Hivaee and Jebusaee, which He covenanted to thy fathers to give thee, a land producing milk and honey, that thou shalt perform this service in this month. ");
INSERT INTO engoke_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Seven days thou shalt eat the (phatira) unleavened cake, and in the seventh day solemnize a feast before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","The unleavened cake thou shalt eat seven days; that which is leavened shall not be seen with thee; the leavened thing shall not be seen with thee in all thy limits. ");
INSERT INTO engoke_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","And thou shalt teach thy son on that day, saying, (It is) on account of that which the Lord did for me in bringing me out of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","And it shall be a sign to thee on thy hand, and for a memorial between thine eyes, that the Law of the Lord may be in thy mouth, for that with a mighty hand did the Lord bring thee forth from Mizraim: ");
INSERT INTO engoke_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","And thou shalt keep this ordinance in its season from time to time. ");
INSERT INTO engoke_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","And it shall be, when the Lord hath brought thee into the land of the Kenaanaee, as He sware to thee and to thy fathers, and hath given it to thee, ");
INSERT INTO engoke_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","that thou shalt make over whatsoever openeth the womb before the Lord; among the cattle which thou hast the male shall be consecrate before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","And every firstling of an ass thou shalt ransom with a lamb; but if thou wilt not ransom it, thou shalt destroy it; and every firstborn of man among thy children thou shalt ransom. ");
INSERT INTO engoke_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","And it shall be, when thy son shall ask thee tomorrow, saying, Why is this? Thou shalt say to him, By a mighty hand the Lord brought us out of Mizraim from the house of servitude. ");
INSERT INTO engoke_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","And it was when Pharoh was obdurate about letting us go away that the Lord slew all the firstborn in the land of Mizraim, from the firstborn of man to the firstborn of cattle: therefore I sacrifice before the Lord of all that openeth the womb, the males, and all the firstborn of my children I ransom. ");
INSERT INTO engoke_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","And it shall be for a sign upon thy hand and for Tephillin between thine eyes, because with a mighty hand hath the Lord brought thee out of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","And it was when Pharoh had sent the people away, that the Lord led them not by the way of the land of the Philistaee because it was the nearest: for the Lord said, Lest the people be terrified at the seeing of war, and return to Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","But the Lord led the people round by the way of the desert to the sea of Suph; and harnessed (or girded) went the sons of Israel up out of the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","And Mosheh brought up the bones of Joseph with him; for he had adjured the sons of Israel with an oath, saying, Remembering, the Lord will remember you, and you shall carry up my bones from hence. ");
INSERT INTO engoke_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","And they journeyed from Sukkoth, and encamped in Etham, which is beside the desert. ");
INSERT INTO engoke_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","And the Lord went before them by day in the column of the cloud to lead them in the way, and by night in the column of fire to enlighten them, that they might go in the day and in the night. ");
INSERT INTO engoke_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","The column of the cloud by day, nor the column of the fire by night, departed not before the people. ");
INSERT INTO engoke_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","And the Lord spake to Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Speak with the sons of Israel that they return and encamp before Pum-Hiratha, between Migdol and the sea, before Beel Zephon: you shall encamp before it by the sea. ");
INSERT INTO engoke_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","And Pharoh will say of the children of Israel, They are bewildered in the land, the desert hath got hold of them: ");
INSERT INTO engoke_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","And I will harden Pharoh’s heart, and he will pursue them; and I will be glorified in Pharoh and in all his host; and the Mizraee shall know that I am the Lord. And they did so. ");
INSERT INTO engoke_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","And it was seen by the king of Mizraim that the people had gone. And the heart of Pharoh and of his servants was turned to the people; and they said, What is this that we have done, that we have sent Israel away from serving us? ");
INSERT INTO engoke_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","And he set his chariot in order, and took his people with him. ");
INSERT INTO engoke_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took also six hundred select chariots, and all the chariots of the Mizraee, and appointed strong men over them. ");
INSERT INTO engoke_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","And the Lord hardened the heart of Pharoh king of Mizraim, and he pursued after the children of Israel. But the children of Israel went forth with uncovered head. ");
INSERT INTO engoke_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","And the Mizraee followed after them, and overtook them while encamping by the sea; all the chariot horses of Pharoh, and his horsemen, and his army, by Pum-Hiratha which is before Beel Zephon. ");
INSERT INTO engoke_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","And Pharoh drew nigh, and the sons of Israel lifted up their eyes, and, behold, the Mizraee were coming after them: and they were greatly afraid, and the children of Israel cried before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","But to Mosheh they said, Was it because there were no graves in Mizraim that thou hast taken us to die in the wilderness? What is this that thou hast done to bring us out of Mizraim? ");
INSERT INTO engoke_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Was not this the word which we spake with thee in Mizraim, saying, Let us alone, and we will serve the Mizraee? For better would it have been for us to serve the Mizraee, than to die in the wilderness. ");
INSERT INTO engoke_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","And Mosheh said to the people, Fear not, stand still (or, be ready) and see the Lord’s deliverance which He will work for you this day; for as you have seen the Mizraee this day, you will see them no more forever: ");
INSERT INTO engoke_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The Lord will fight for you the fight, and you shall be quiet. ");
INSERT INTO engoke_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","And the Lord said to Mosheh, I have heard thy prayer. Speak to the children of Israel that they go onward: ");
INSERT INTO engoke_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","And thou, take thy rod and stretch forth thy hand over the sea, and divide it, and the children of Israel shall go in the midst of the sea on dry ground. ");
INSERT INTO engoke_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","And I, behold, I will harden the hearts of the Mizraee, and they will go in after them; and I will be glorified by Pharoh and by all his army, by his chariots and his horsemen; ");
INSERT INTO engoke_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","And the Mizraee shall know that I am the Lord, when I have been glorified by Pharoh and his chariots and his horsemen. ");
INSERT INTO engoke_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","And the angel of the Lord who went before the camp of Israel passed by and came behind them; and the column of the cloud passed from before them and abode behind them. ");
INSERT INTO engoke_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","And it entered between the camp of the Mizraee and the camp of Israel; and was a cloud and darkness to the Mizraee, but unto Israel a light all the night: and that came not near to this all the night. ");
INSERT INTO engoke_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","And Mosheh stretched forth his hand over the sea; and the Lord drave the sea by a mighty east wind all the night, and caused the sea to be dry, and the waters were disparted; ");
INSERT INTO engoke_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","And the children of Israel went into the midst of the sea upon dry ground; and the waters were to them a wall on their right hand and on their left. ");
INSERT INTO engoke_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","And the Mizraee followed and entered in after them, all the horses of Pharoh, and his chariots and horsemen, into the midst of the sea. ");
INSERT INTO engoke_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","And it was in the morning watch that the Lord looked upon the host of the Mizraee from the column of fire and cloud, and perturbed the host of the Mizraee. ");
INSERT INTO engoke_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","And he removed the wheels of the chariots, so that they drave them by strength; and the Mizraee said, Let us flee from before Israel; for this is the power of the Lord which hath done battle for them against Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","And the Lord said to Mosheh, Stretch forth thy hand over the sea, and the waters shall return upon the Mizraee, upon their chariots and their horsemen. ");
INSERT INTO engoke_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","And Mosheh stretched out his hand over the sea, and the sea returned, at the time of the morning, unto its strength; and the Mizraee fled before it; and the Lord drowned the Mizraee in the midst of the sea. ");
INSERT INTO engoke_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","And the waters returned and covered the chariots and horsemen and all the host of Pharoh who had gone after them into the sea, and there remained of them not one. ");
INSERT INTO engoke_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the children of Israel walked on dry land in the midst of the sea; and the waters were a wall to them on their right hand and on their left. ");
INSERT INTO engoke_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","And the Lord delivered Israel that day from the Mizraee, and Israel saw the Mizraee dead upon the shore of the sea. ");
INSERT INTO engoke_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","And Israel saw the Power of the Great Hand which the Lord had made (to appear) in Mizraim; and the people feared before the Lord, and believed in the Word of the Lord, and in the prophetic (work) of Mosheh His servant. ");
INSERT INTO engoke_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then sang Mosheh and the children of Israel this hymn before the Lord; and they spake, saying, We will sing and give thanks before the Lord, because He is magnified upon the mighty, and the power is His own; the horse and his rider hath He cast into the sea. ");
INSERT INTO engoke_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","My strength and my song is the terrible Lord; He hath said by His Word that He will be mine to redeem This is my God, and I will build Him a sanctuary; the God of my fathers, and I will worship before Him. ");
INSERT INTO engoke_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The Lord is the Lord of Victory in battles, the Lord is His Name. ");
INSERT INTO engoke_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","The chariots of Pharoh and his horses He hath cast into the sea, his chosen warriors are drowned in the sea of Suph. ");
INSERT INTO engoke_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The depths covered them over, they went down to the bottom as a stone. ");
INSERT INTO engoke_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Thy right hand, O Lord, is illustrious in power; Thy right hand, O Lord, shattereth the adversary; ");
INSERT INTO engoke_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","And in the greatness of Thy might Thou hast broken down them who arose against Thy people. Thou didst send forth Thy wrath, and it consumed them as stubble in the flame, ");
INSERT INTO engoke_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","and by the word of Thy mouth the waters, (as if) wise, stood up like a wall; the depths were congealed in the heart of the sea. ");
INSERT INTO engoke_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The adversary said, I will pursue, I will overtake, I will divide the spoil; my soul shall be satisfied upon them; I will draw my sword, and my hand shall destroy them. ");
INSERT INTO engoke_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Thou didst speak by Thy Word, the sea covered them over, they sank like lead in the mighty waters. ");
INSERT INTO engoke_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","There is none beside Thee, 0 God, (who art) glorious in holiness, fearful in praises, doing wonders. ");
INSERT INTO engoke_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Thou didst uplift Thy right hand, the earth swallowed them up. ");
INSERT INTO engoke_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Thou hast led forth in goodness Thy people whom Thou hast redeemed; Thou wilt bring them by Thy strength to the dwelling of Thy holiness. ");
INSERT INTO engoke_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The nations will hear it, and be moved; terror will seize on the inhabiters of Pelasheth; ");
INSERT INTO engoke_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then will the princes of Edom be alarmed, the strong ones of Moab will be seized with trembling and they who dwell in Kenaan will be broken down. ");
INSERT INTO engoke_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Fear and dread will fall upon them, by the greatness of Thy power they will be silent as a stone, until Thy people, O Lord, pass over Arnona, until Thy people whom Thou hast redeemed pass over Jardena. ");
INSERT INTO engoke_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Thou wilt bring them in, and cause them to dwell in the mountain of Thine inheritance, in the place which Thou hast ordained for the house of Thy Shekina, the sanctuary which Thy hands, O Lord, have prepared. ");
INSERT INTO engoke_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The kingdom of the Lord endureth forever, and forever, evermore! ");
INSERT INTO engoke_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Because, when the horses of Pharoh with his chariots and his horsemen had entered into the sea, the Lord caused the waters of the sea to return upon them, and the children of Israel walked upon dry land in the midst of the sea. ");
INSERT INTO engoke_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","And Miriam the prophetess, the sister of Aharon, took the timbrel in her hand, and all the women went out after her with timbrels and choruses. ");
INSERT INTO engoke_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","And Miriam answered them: Sing and give thanks before the Lord, for He hath magnified Himself upon the proud: and the majesty belongeth (only) unto Him; the horse and his rider hath He cast into the sea. ");
INSERT INTO engoke_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","And Mosheh caused Israel to remove from the sea of Suph, and they went forth into the desert of Chagra, and went three days in the desert, but found no water. ");
INSERT INTO engoke_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","And they came to Marah, and could not drink the waters of Marah because they were bitter; therefore he called the name of it Marah. ");
INSERT INTO engoke_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","And the people were fretful against Mosheh, saying, What shall we drink? ");
INSERT INTO engoke_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","And he prayed before the Lord; and the Lord instructed him (in the properties of) a tree, and he cast it into the waters, and the waters became sweet. There decreed He a statute, and a judgment, and there He tried him. ");
INSERT INTO engoke_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","And He said, If hearkening thou wilt hearken unto the Word of the Lord thy God, and wilt do what is right in His eyes, and wilt listen to His precepts and keep all His statutes, none of the maladies which I have set upon Mizraim will I put upon thee; for I am the Lord thy Healer. ");
INSERT INTO engoke_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","And they came to Elim, and there were twelve wells of water and seventy palm trees; and they encamped there before the waters. ");
INSERT INTO engoke_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","And they journeyed from Elim, and came, the whole assembly of the sons of Israel, to the desert of Sir, which is between Elim and Sinai, on the fifteenth day of the second month from their outgoing from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","And all the congregation of the children of Israel were troublous against Mosheh and against Aharon in the desert; ");
INSERT INTO engoke_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","And the children of Israel said to them, ");
INSERT INTO engoke_vpl VALUES ("EX16_0","003_16_0","EXO","16","0","0","that we had died before the Lord in the land of Mizraim, when we sat by the caldrons of flesh, and could eat bread and be satisfied! Why have you brought us out into this wilderness to kill this whole assembly with famine? ");
INSERT INTO engoke_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","And the Lord said to Mosheh, Behold, I will cause bread to come down to you from heaven; and the people shall go out and collect the matter of the day for the day; that I may prove them whether they will walk in My law, or not. ");
INSERT INTO engoke_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","And in the sixth day, when they prepare that which they bring in, it shall be two for one upon what they collect from day to day. ");
INSERT INTO engoke_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","And Mosheh and Aharon said to all the children of Israel, In the evening you shall know that the Lord brought you out of the land of Mizraim, ");
INSERT INTO engoke_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","And in the morning shall you see the Glory of the Lord; for your tumults are heard before the Lord: and we what, that you are restive against us? ");
INSERT INTO engoke_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","And Mosheh said, When the Lord will give you at evening flesh to eat, and bread in the morning to satisfy, while are heard before the Lord your tumults against Him! For what are we? Your tumults are not against us, but against the Word of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","And Mosheh said to Aharon, Bid all the congregation of the sons of Israel to come together before the Lord; for your tumult is heard before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","And it was, while Aharon was speaking with all the congregation of the sons of Israel, that they turned towards the desert, and, behold, the glory of the Lord was revealed in the cloud. ");
INSERT INTO engoke_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","The tumult of the children of Israel is heard before Me. Speak with them to say, Between the evenings you shall eat flesh, and in the morning be satisfied with bread, and you shall know that I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","And it was in the evening that the quails came up and covered the camp; and in the morning a dew descended round about the camp; ");
INSERT INTO engoke_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","And when the dew which had fallen had gone up, behold, upon the face of the desert, a small (substance) without covering, small like hoar frost, heaped on the earth. ");
INSERT INTO engoke_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","And the sons of Israel saw, and said, a man to his brother, Mana-hu! For they knew not what it was. And Mosheh said to them, This is the bread which the Lord will give you to eat. ");
INSERT INTO engoke_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is the word that the Lord hath commanded: Let every man gather of it according to his eating an omera for every head according to the number of your souls, a man for those of his tent shall you take. ");
INSERT INTO engoke_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","And the sons of Israel did so, and gathered, some more, (others) less; ");
INSERT INTO engoke_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","And they measured with an omera, and he who had (gathered) much had not more, and he who had (gathered) little had not less; every man according to his eating they gathered. ");
INSERT INTO engoke_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","And Mosheh said to them, No man must leave of it for the morning. ");
INSERT INTO engoke_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But they hearkened not to Mosheh, but some left for the morning, and it swarmed worms and corrupted. And Mosheh was angry with them. ");
INSERT INTO engoke_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","And they gathered it from morning to morning a man according to his eating; and when the sun grew hot on that which remained upon the face of the field, it melted. ");
INSERT INTO engoke_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","And it was that on the sixth day they gathered a double (quantity) of bread, two omers for one: and all the chiefs of the congregation came and showed Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","And be said to them, Tomorrow is the rest of the holy Shabbath before the Lord. That which you prepare by baking, bake, and that which you prepare by boiling, boil, and all the remainder lay up to you, a store for the morning. ");
INSERT INTO engoke_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","And they laid it up till the morning, as Mosheh had instructed; and it did not corrupt, neither were there worms in it. ");
INSERT INTO engoke_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","And Mosheh said, Eat that today, for this day is Shabbath before the Lord; this day you would not find it in the field. ");
INSERT INTO engoke_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Six days you shall collect it; but on the seventh day, the Shabbath, there will be none. ");
INSERT INTO engoke_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","And it was on the seventh day that some of the people went out to gather, but they found it not. ");
INSERT INTO engoke_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","And the Lord said to Mosheh, How long will you be unwilling to keep My commandments and My laws? ");
INSERT INTO engoke_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","See, because the Lord hath given you the Shabbath He hath therefore given you on the sixth day the bread for two days; let every man dwell in his resting, and not go out from his place on the seventh day. ");
INSERT INTO engoke_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","And the people reposed on the seventh day. ");
INSERT INTO engoke_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","And the house of Israel called the name of it Manna; and it was as the seed of Gida white, and its taste was like cake broiled with honey. ");
INSERT INTO engoke_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","And Mosheh said, This is the word which the Lord hath commanded. Fill an omera of it to be kept for your generations, that they may see the bread which I made you eat in the desert when I brought you forth from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","And Mosheh said to Aharon, Take one vase, and put therein an omera full of manna, and lay it up before the Lord to be preserved for your generations. ");
INSERT INTO engoke_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","As the Lord commanded, so did Mosheh; and Aharon laid it up before the Testimony, to keep. ");
INSERT INTO engoke_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","And the children of Israel ate the manna forty years, until they came to the land inhabited; they did eat the manna till they came to the confines of the land of Kenaan. ");
INSERT INTO engoke_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","And one omera is the tenth of three seahs. ");
INSERT INTO engoke_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","And all the congregation of the children of Israel journeyed from the desert of Sin, according to their itinerations by the Word of the Lord; and they encamped in Rephidim: but the people had no water to drink; ");
INSERT INTO engoke_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","and the people were contentious with Mosheh, and said, Give us water that we may drink. And Mosheh said, Why do you contend with me? Why do you tempt before the Lord? ");
INSERT INTO engoke_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people thirsted there for water, and the people were turbulent against Mosheh, and said, Why is this, to have brought us from Mizraim, to kill me and my children and my cattle with thirst? ");
INSERT INTO engoke_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","And Mosheh prayed before the Lord, saying, What shall I do with this people? Yet a little, and they will stone me! ");
INSERT INTO engoke_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","And the Lord said to Mosheh, Pass over before the people, and take with thee of the elders of Israel, and thy rod wherewith thou didst smite the river take in thy hand, and go. ");
INSERT INTO engoke_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Behold, I will stand before thee there, upon the rock in Horeb, and thou shalt smite the rock, and water shall come out of it, that the people may drink. And Mosheh did so in the eyes of the elders of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","And he called the name of the place, Temptation and Strife, because of the striving of the sons of Israel, and because they tempted before the Lord, saying, Is the Majesty of the Lord among us, or not? ");
INSERT INTO engoke_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","And Amaleq came, and warred battle with Israel in Rephidim. ");
INSERT INTO engoke_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","And Mosheh said to Jehoshua, Choose for us men, and go forth and do battle with Amaleq. Tomorrow I will stand on the top of the hill, and the rod with which the miracles are wrought from before the Lord shall be in my hand. ");
INSERT INTO engoke_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","And Jehoshua did as Mosheh had said to him, and he did battle with Amaleq. And Mosheh, Aharon, and Hur ascended to the top of the hill. ");
INSERT INTO engoke_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","And it was that when Mosheh lifted up his hand, the house of Israel prevailed; and when he let down his hand, the house of Amaleq prevailed. ");
INSERT INTO engoke_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","But the hands of Mosheh became heavy, and they took a stone and placed it under him, and he sat upon it, and Aharon and Hur held up his hands, here one, and there one; and thus were his hands stretched out in prayer until the going of the sun. ");
INSERT INTO engoke_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","And Jehoshua shattered Amaleq and his people with the edge of the sword. ");
INSERT INTO engoke_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","And the Lord said to Mosheh: Write this memorial in the Book, and set it before Jehoshua, That blotting, I will blot out the memorial of Amaleq from under the heavens. ");
INSERT INTO engoke_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","And Mosheh builded an altar, and ministered upon it before the Lord who had wrought (such) miracles for him. ");
INSERT INTO engoke_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","And he said, With an oath hath this been declared from before the Fearful One whose Shekinah is upon His glorious throne; that war shall be waged with the house of Amaleq, to destroy it from the generations of the world. ");
INSERT INTO engoke_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","And Jethro, the rabba of Midian, the father-in-law of Mosheh, had heard of all that the Lord had done for Mosheh and for Israel His people, and that the Lord had brought Israel out of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","And Jethro, Mosheh’s father-in-law, took Zipporah the wife of Mosheh, after he had let her go, ");
INSERT INTO engoke_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","And his two sons, the name of the one Gershom; For, he said, I have been a sojourner in a strange land; ");
INSERT INTO engoke_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","And the name of the other Eliezer; For (said he) the God of my fathers hath been my helper, and hath delivered me from the sword of Pharoh. ");
INSERT INTO engoke_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","And Jethro the father-in-law of Mosheh came, and his sons, and his wife, to Mosheh in the desert where he had encamped at the mountain upon which was revealed the glory of the lord. ");
INSERT INTO engoke_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","And he had told Mosheh, I, thy father-in-law Jethro, come to thee with thy wife, and her two sons with her. ");
INSERT INTO engoke_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","And Mosheh went forth to meet his father-in-law, and bowed, and kissed him, and each saluted the other with peace; and they entered the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","And Mosheh recounted to his father-in-law all that the Lord had done to Pharoh and to Mizraim for Israel’s sake; and all the tribulation that they had found upon the way, and how the Lord had delivered them. ");
INSERT INTO engoke_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","And Jethro was glad over all the good which the Lord, who had saved him from the hand of Mizraim, had wrought for Israel. ");
INSERT INTO engoke_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","And Jethro said, Blessed be the Lord, who hath delivered you out of the hand of the Mizraee, and out of the hand of Pharoh, and hath delivered the people from under the domination of the Mizraee. ");
INSERT INTO engoke_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now know I that the Lord is great, and that there is no God but He for by the thing by which the Mizraee had thought to punish (judge) Israel, they themselves are punished. ");
INSERT INTO engoke_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","And Jethro the father-in-law of Mosheh offered a burnt offering and sacrificed holy things before the Lord. And Aharon came, with all the elders of Israel, to eat bread with the father-in-law of Mosheh before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","And on the day after, Mosheh sat to judge the people, and the people stood about Mosheh from morn till evening; ");
INSERT INTO engoke_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","And the father-in-law of Mosheh observed all that he did to the people. And he said, What thing is this that thou art doing to the people? Why dost thou sit alone, with all the people standing about thee from morn till evening? ");
INSERT INTO engoke_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","And Mosheh said to his father-in-law, Because the people come to me to ask instruction from before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have (a matter) for judgment they come to me, and I adjudicate between a man and his neighbour, and make them to know the statutes of the Lord, and His laws. ");
INSERT INTO engoke_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","But the father-in-law of Mosheh said to him, The thing thou art doing is not right; ");
INSERT INTO engoke_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","With weariness thou wilt be weary, thou and also this people who are with thee; for the thing is too weighty for thee, thou art not able to do it by thyself. ");
INSERT INTO engoke_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Now hearken to me, I will give thee counsel, and the Word of the Lord shall be thy helper. Be thou for the people the seeker of instruction from the presence of the Lord, to bring the matters before the Lord: ");
INSERT INTO engoke_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","And thou shalt admonish them in the statutes and the laws, and make them know the way in which to walk, and the work that must be done. ");
INSERT INTO engoke_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","And thou, look out from the whole people men of ability who fear the Lord, men of truth who abhor to take mammon; and superappoint them chiefs of thousands, and chiefs of hundreds, and chiefs of fifties, and chiefs of tens. ");
INSERT INTO engoke_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","And they shall judge the people at any time, and every great matter they shall bring to thee, but every small thing they shall judge; and they will lighten it from thee, and bear it with thee. ");
INSERT INTO engoke_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If thou wilt do this, and the Lord teach thee, thou wilt be able to endure, and (of) all this people everyone will go to his place in peace. ");
INSERT INTO engoke_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","And Mosheh hearkened to his father-in-law, and did all that he had said. ");
INSERT INTO engoke_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","And Mosheh chose men of ability from all Israel, and appointed them heads over the people; chiefs of thousands, chiefs of hundreds, chiefs of fifties, and chiefs of tens; ");
INSERT INTO engoke_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","And they judged the people at all times; a weighty thing they brought to Mosheh, and every minor thing they judged themselves. ");
INSERT INTO engoke_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","And Mosheh sent his father-in-law away, and he went unto his land. ");
INSERT INTO engoke_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month of the outgoing of the sons of Israel from the land of Mizraim, on that day came they to the desert of Sinai. ");
INSERT INTO engoke_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","And they journeyed from Rephidim, and came to the desert of Sinai, and dwelt there by the side of the mountain. ");
INSERT INTO engoke_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","And Mosheh ascended before the Lord. And the Lord called to him from the mount, saying, As thus thou shalt speak to the house of Jakob, and show to the sons of Israel: ");
INSERT INTO engoke_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","You have seen what I did to the Mizraee, and how I bare you as on eagles’ wings, and brought you nigh to serve Me: ");
INSERT INTO engoke_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","And now, if hearkening you will hearken to My Word, and will keep My covenant, you, before Me, shall be more beloved than all peoples; for all the earth is Mine. ");
INSERT INTO engoke_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","And you, before Me, shall be kings (and) priests, a holy people. These are the words which thou shalt speak with the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","And Mosheh came, and called the elders of the people, and set all these words in order before them, as the Lord had instructed him. ");
INSERT INTO engoke_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","And all the people responded together, and said, All that the Lord hath spoken we will do. And Mosheh brought back the words of the people before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","And the Lord said to Mosheh, Behold, I will be revealed to thee in the darkness of the cloud, that the people may hear, in My speaking with thee, and also that they may confide in thee forever. And Mosheh showed the words of the people before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","And the Lord said to Mosheh, Go unto the people and prepare them, today and tomorrow, and let them purify their clothing; ");
INSERT INTO engoke_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","And be ready for the third day; for on the third day the Lord will be revealed in the eyes of all the people upon mount Sinai. ");
INSERT INTO engoke_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","And thou shalt set a limit for the people round about, saying, Beware you of going up on the mountain, or of approaching the border of it. Whoever approaches the mountain, slain he shall be slain. ");
INSERT INTO engoke_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No hand shall touch him; for stoned he shall be stoned, or pierced he shall be pierced; whether beast or man, he shall not live. When the trumpet is prolonged they shall be allowed to go forward to the mount. ");
INSERT INTO engoke_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","And Mosheh came down from the mountain unto the people, and prepared the people, and they made white their clothes. ");
INSERT INTO engoke_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","And he said to the people, Be ready on the third day, approach not to a woman. ");
INSERT INTO engoke_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","And it was the third day at morning; and there were voices, and lightnings, and mighty clouds upon the mountain, and the voice of the trumpet exceedingly strong; and all the people trembled who were in the camp. ");
INSERT INTO engoke_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","And Mosheh led forth the people out of the camp to meet the Word of the Lord; and they stood at the lower parts of the mount. ");
INSERT INTO engoke_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","And the mountain of Sinai was altogether fuming from before the revelation of the Lord upon it in fire; and the smoke went up as the smoke of a furnace, and the whole mount trembled greatly. ");
INSERT INTO engoke_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","But when the voice of the trumpet went forth and became exceedingly strong, Mosheh spake, and from the presence of the Lord he was answered by a voice. ");
INSERT INTO engoke_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","And the Lord was revealed upon mount Sinai, on the head of the mountain; and the Lord called Mosheh unto the head of the mount; and Mosheh went up. ");
INSERT INTO engoke_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","And the Lord said to Mosheh, Go down, warn the people lest they break through before the Lord to see, and many of them fall. ");
INSERT INTO engoke_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","And let the priests also, who are to minister before the Lord, sanctify themselves, lest the Lord slay them. ");
INSERT INTO engoke_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","And Mosheh spake before the Lord, The people are not able to come up to mount Sinai; for Thou hast warned us, saying, Set a boundary to the mountain, and sanctify it. ");
INSERT INTO engoke_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","But the Lord said to him, Go, descend, and come up, thou and Aharon with thee; but let not the priests nor the people break through to come up before the Lord, lest He slay them. ");
INSERT INTO engoke_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","And Mosheh went down to the people, and spake with them. ");
INSERT INTO engoke_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","And the Lord spake all these words, saying, ");
INSERT INTO engoke_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","I am the Lord thy God, who have brought thee out of the land of Mizraim, out of the house of servitude. ");
INSERT INTO engoke_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Thou shalt have no other God beside Me. ");
INSERT INTO engoke_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Thou shalt not make to thee image nor likeness of anything that is in the heavens above, nor in the earth beneath, nor in the waters under the earth: ");
INSERT INTO engoke_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Thou shalt not worship them nor serve them; for I the Lord thy God am a jealous God; visiting the sins of the fathers upon the rebellious children, unto the third generation and to the fourth generation of those who hate Me; while the children continue (or complete) to sin after their fathers; ");
INSERT INTO engoke_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","But doing good to thousands of generations of those who love Me and keep My commandments. ");
INSERT INTO engoke_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Thou shalt not swear in the name of the Lord thy God vainly; for the Lord will not acquit him who sweareth in His Name with falsity. ");
INSERT INTO engoke_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Remember the day of Shabbatha to sanctify it. ");
INSERT INTO engoke_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Six days shalt thou do service and do all thy work; ");
INSERT INTO engoke_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is Shabbath before the Lord thy God. Thou shalt not do every work; thou, nor thy son, nor thy daughter, thy servant nor thy handmaid, nor thy cattle, nor thy sojourner who is in thy city. ");
INSERT INTO engoke_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in six days the Lord made the heavens and the earth, the seas and all that is in them, and rested on the seventh day; wherefore the Lord blessed the day of Shabbath, and sanctified it. ");
INSERT INTO engoke_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honour thy father and thy mother, that thy days may be prolonged upon the land which the Lord thy God giveth to thee. ");
INSERT INTO engoke_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Thou shalt not kill life. 14 Thou shalt not commit adultery. 15 Thou shalt not steal. 16 Thou shalt not testify against thy neighbour a testimony of falsehood. ");
INSERT INTO engoke_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","17 Thou shalt not covet thy neighbour’s house; thou shalt not covet thy neighbour’s wife, nor his servant, nor his handmaid, nor his ox, nor his ass, nor anything that is thy neighbour’s. ");
INSERT INTO engoke_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","18 And all the people saw the thunders, and the flames, and the voice of the trumpet, and the mountain smoking; and the people saw, and trembled, and stood afar off. ");
INSERT INTO engoke_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","19 And they said to Mosheh, Speak thou with us, and we will hearken; but let it not be spoken to us from before the Lord, lest we die. ");
INSERT INTO engoke_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","20 And Mosheh said to the people, Fear not; for that He may prove you He hath revealed to you the glory of the Lord, and that His fear may be before your face, that you may not sin. ");
INSERT INTO engoke_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","21 And the people stood afar off, but Mosheh drew nigh to the darkness where was the glory of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","22 And the Lord said to Mosheh, Thus shalt thou speak to the children of Israel; You have seen that I have spoken to you from the heavens. ");
INSERT INTO engoke_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","23 You shall not make before Me idols of silver, neither idols of gold shall you make to you. ");
INSERT INTO engoke_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","24 An altar of earth shalt thou make before Me, and shalt sacrifice upon it thy burnt offerings and thy sanctified victims, thy sheep and thy oxen. In every place where I may cause My Shekinah to dwell, thither will I send My blessing, and will bless thee. ");
INSERT INTO engoke_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","25 And if thou wilt make Me an altar of stone before Me, thou shalt not build it with hewn stones lest thou lift up thy cutting-tool (lit. thy sword) upon it and profane it. ");
INSERT INTO engoke_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","26 And thou shalt not ascend by steps to My altar, that thy nakedness may not be discerned upon it. ");
INSERT INTO engoke_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","And these are the judgments which thou shalt set In order before them. ");
INSERT INTO engoke_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","When thou dost purchase a servant, a son of Israel, six years he shall serve, and in the seventh go forth free, for nothing. ");
INSERT INTO engoke_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he came in alone, he shall go out alone; if the husband of a wife, his wife shall go out with him. ");
INSERT INTO engoke_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master have given him a wife, and she have borne him sons or daughters, the wife and the children are the master’s, and he shall go out alone. ");
INSERT INTO engoke_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant saying shall say, I love my master, my wife and my children, I will not go out free; ");
INSERT INTO engoke_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","His master shall bring him before the judges, and shall take him to the door, even to the post, and his master shall bore his ear with an awl; and he shall be to him a working servant forever. ");
INSERT INTO engoke_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","And when a man selleth his daughter to be a handmaid, she shall not go out as at the outgoing of the men servants. ");
INSERT INTO engoke_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she be evil in the eyes of the master who had covenanted with her to be his, then shall he make her free; to another man he shall not have ability to sell her to domineer over her. ");
INSERT INTO engoke_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","And if he hath covenanted her to his son, after the custom of the daughters of Israel shall he act towards her. ");
INSERT INTO engoke_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","And if he take another to him, her food, her raiment, and her marriage due he shall not restrain. ");
INSERT INTO engoke_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","And if these three he doth not perform to her, he shall release her freely without money. ");
INSERT INTO engoke_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Whosoever striketh a man and killeth him, being killed he shall be killed. ");
INSERT INTO engoke_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","But if it was not (done) covertly to him, but he was delivered into his hand from before the Lord, then I will appoint thee a place whither he may flee. ");
INSERT INTO engoke_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But when a wicked man acts toward his neighbour with deceitfulness to kill him, even from Mine altar thou shalt bring him away to put him to death. ");
INSERT INTO engoke_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Whosoever striketh his father or his mother shall be surely put to death. ");
INSERT INTO engoke_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","And whosoever stealeth a soul of the house of Israel and selleth him, or if he be found in his hand, shall be surely put to death. ");
INSERT INTO engoke_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","And he who curseth his father or his mother shall surely be put to death. ");
INSERT INTO engoke_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","And when men contend, and a man smiteth his neighbour with a stone or with his fist, and he die not, but fall upon his bed; ");
INSERT INTO engoke_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","If he rise (again) and walk about upon his staff, he who smote him shall be acquitted; only he shall make good his loss of labour, and defray the charge of the physician. ");
INSERT INTO engoke_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","And when a man smiteth his servant or his handmaid with a staff, and he die under his hand, condemned he shall be condemned. ");
INSERT INTO engoke_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","But if he survive one day, or two, he shall not be condemned, because he was his money. ");
INSERT INTO engoke_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men contending strike a woman with child and she miscarry, but die not, fined he shall be fined, as the husband of the woman may set upon him, and he shall give according to the sentence of judgment. ");
INSERT INTO engoke_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if death take place, thou shalt give life for life, ");
INSERT INTO engoke_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engoke_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burning for burning, wound for wound, bruise for bruise. ");
INSERT INTO engoke_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","And if a man smite the eye of his servant or his handmaid and destroy it, he shall let him go free, for the sake of his eye. ");
INSERT INTO engoke_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Or if he beat out (cause to fall) a tooth of his servant or a tooth of his handmaid, he shall let him go free for the sake of his tooth. ");
INSERT INTO engoke_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox gore a man or woman unto death, the ox being stoned shall be stoned, and his flesh must not be eaten; but the master of the ox shall be acquitted. ");
INSERT INTO engoke_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox had gored in time before (yesterday and the day before), and it had been attested to his master, and he not keeping him he hath killed man or woman, the ox shall be stoned and the owner be put to death. ");
INSERT INTO engoke_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If a fine of money (if mammon) be laid upon him, he may give redemption for his life according to all that is laid upon him. ");
INSERT INTO engoke_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the ox gore a son or daughter of Israel, after this judgment shall it be done to him. ");
INSERT INTO engoke_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If an ox gore a man-servant or a maidservant, (the owner) shall give to his master thirty sileen of silver, and the ox shall be stoned. ");
INSERT INTO engoke_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","And if a man open a pit, or dig a pit, and doth not cover it, and an ox or an ass fall therein, ");
INSERT INTO engoke_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","The master of the pit shall pay: he shall give silver to his owner, and the carcass shall be his own. ");
INSERT INTO engoke_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","And if the ox of one man hurt a neighbour’s ox that it die, they shall sell the living ox and divide the money; and that which is dead they shall also divide. ");
INSERT INTO engoke_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if it be known that the ox gored in time past and his owner did not keep him in, paying he shall pay ox for ox, and the dead one shall be his. ");
INSERT INTO engoke_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","If a man steal an ox or a lamb, and kill or sell it, he shall repay five oxen for the ox, and four sheep for the lamb. ");
INSERT INTO engoke_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","If a thief be found breaking through, and he be smitten and die, there shall be no blood due to him. ");
INSERT INTO engoke_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If the eyes of witnesses fall upon him, blood shall be due to him, paying he shall pay. If he have nothing, he shall be sold for his robbery. ");
INSERT INTO engoke_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","If the thing stolen, from an ox to an ass, be found in his possession, they being alive, he shall restore two for one. ");
INSERT INTO engoke_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If a man make waste a field or vineyard, or send his cattle to consume another’s field, the best of his field and the best of his vineyard he shall restore. ");
INSERT INTO engoke_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If fire breaks out, and it find thorns, so that sheaves or standing corn or the field be consumed, he who kindled the fire paying shall pay. ");
INSERT INTO engoke_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","When a man giveth his neighbour silver or vessels to keep, and they be stolen from the man’s house; if the thief be found, he shall repay double. ");
INSERT INTO engoke_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If the thief be not found, the master of the house shall be brought before the judges (to make oath) that he hath not put forth his hand upon that which his neighbour had delivered to him. ");
INSERT INTO engoke_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Upon every matter of guiltiness about ox or ass or lamb, or raiment, or anything destroyed of which it may be said, This is it, the cause of both shall be brought before the judges, and he whom the judges shall condemn shall pay double to his neighbour. ");
INSERT INTO engoke_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","If a man deliver to his neighbour an ass or an ox or a lamb or any cattle to keep, and it die, or be injured, or be carried away, no one seeing; ");
INSERT INTO engoke_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","An oath of the Lord shall be between them that he bath not put forth his hand against that which his neighbour had delivered, and the owner shall accept the oath, and he shall not repay. ");
INSERT INTO engoke_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","But if it be stolen from him, he shall repay its owner; ");
INSERT INTO engoke_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","And if it be torn, and he bring witnesses that it was torn, he shall not repay. ");
INSERT INTO engoke_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","And if a man borrow of his neighbour and it be injured or die, the owner of it not being with it, repaying he shall repay. ");
INSERT INTO engoke_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","But if the owner be with it, he shall not repay. If it were hired, let it be (considered) for its hire. ");
INSERT INTO engoke_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","And if a man seduce a virgin who is not betrothed and lie with her, he shall surely establish her to be his wife. ");
INSERT INTO engoke_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If her father be unwilling to give her to him, he shall weigh down silver according to the dowry of virgins. ");
INSERT INTO engoke_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","An enchantress shall not live. ");
INSERT INTO engoke_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Whosoever lieth with a beast shall be surely put to death. ");
INSERT INTO engoke_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Whosoever sacrificeth to the idols of the Gentiles shall be put to death: but to the Name of the Lord alone. ");
INSERT INTO engoke_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","And a stranger thou shalt not trouble nor oppress; for you were sojourners in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Afflict not the widow or the orphan: ");
INSERT INTO engoke_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","If you indeed afflict them, and they cry before Me, I will surely hearken to their cry; ");
INSERT INTO engoke_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","And My displeasure shall be strong, and will kill you with the sword; and your wives shall be widows and your children fatherless. ");
INSERT INTO engoke_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","If thou lend money to My people, to the poor who is with thee, thou shalt not be to him as an usurer, neither shalt thou inflict an injury upon him. ");
INSERT INTO engoke_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If, (as) a pledge, thou take thy neighbour’s garment, at the going away of the sun thou shalt return it unto him. ");
INSERT INTO engoke_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","For it may be his only covering; for (then) it is the clothing for his skin: wherein shall he sleep? And it shall be that when he crieth before Me I will hearken; for I am merciful. ");
INSERT INTO engoke_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Thou shalt not revile the judges, nor curse the ruler of My people. ");
INSERT INTO engoke_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Thy firstfruits and thy tithes thou shalt not delay (to offer:) the firstborn of thy children thou shalt separate before Me; ");
INSERT INTO engoke_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","so shalt thou do with thy oxen and with thy sheep. Seven days shall (the firstling) be with its mother; on the eighth day thou shalt separate it before Me. ");
INSERT INTO engoke_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","And ye shall be holy men before Me; and the flesh torn from a living animal you may not eat; you shall cast it to the dogs. ");
INSERT INTO engoke_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Thou shalt not take up a false report, nor set thine hand with the wicked to be a false witness for him. ");
INSERT INTO engoke_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Thou shalt not follow the many to wickedness, neither shalt thou fail to teach that which in thine eyes is judgment; after the many (majority?) thou shalt fulfil judgment. ");
INSERT INTO engoke_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","And upon the poor thou shalt not be pitiful in judging him. ");
INSERT INTO engoke_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If thou meet the ox of thy enemy, or his ass, wandering away, thou shalt surely bring it back to him. ");
INSERT INTO engoke_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","When thou seest thine enemy’s ass prostrate beneath his burden, thou shalt forbear from forsaking him; thou shalt surely abandon what is in thy heart against him, and shalt deliver it unto him. ");
INSERT INTO engoke_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Thou shalt not warp the judgment of the poor man in his cause. ");
INSERT INTO engoke_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","From a false matter keep distant; and him who has been acquitted and has come forth from judgment uncondemned thou shalt not kill; for I will not justify the guilty. ");
INSERT INTO engoke_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","And thou art not to receive a bribe; for a bribe blinds the eyes of the wise, and perverts the words of the just. ");
INSERT INTO engoke_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","And thou shalt not distress the sojourner; for you know the mind of a sojourner; for you were dwellers in the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Six years thou shalt sow the land and gather in its produce, ");
INSERT INTO engoke_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","but the seventh year thou shalt let it alone and suffer it to rest, that the poor of thy people may eat, and what they leave the beast of the field may eat. So also shalt thou do with thy vineyard and with thy olive ground. ");
INSERT INTO engoke_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Six days shalt thou do thy work, and in the seventh day have rest, that thy ox and thy ass may rest, and the son of thine handmaid and thy sojourner may be quiet. ");
INSERT INTO engoke_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","And of all that I have spoken to you be mindful, and the name of the idols of the Gentiles remember not; let it not be heard upon thy lips. ");
INSERT INTO engoke_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Three times thou shalt solemnize festival before Me in the year. ");
INSERT INTO engoke_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Thou shalt keep the festival of unleavened bread. Seven days shalt thou eat unleavened cake, as I have commanded thee, in the time of the moon of Abiba, for therein you went forth from Mizraim; and you shall not appear before Me empty. ");
INSERT INTO engoke_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","And the festival of harvest, the firstfruits of thy labours which thou hast sowed in thy fields; and the festival of gathering, at the end of the year when thou gatherest in thy labours from the field. ");
INSERT INTO engoke_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Three times in the year shall all thy males appear before the Lord, the Ruler of the world. ");
INSERT INTO engoke_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Thou shalt not offer with unleavened bread the blood of My pascha, neither shall the fat of the sacrifice of the feast remain without on the altar until morning. ");
INSERT INTO engoke_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","The beginning of the firstfruits of thy land thou shalt bring into the sanctuary of the Lord thy God. Thou shalt not eat flesh with milk. ");
INSERT INTO engoke_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Behold, I send My Angel before thee, to protect thee in the way, and to bring thee into the place which I have prepared. ");
INSERT INTO engoke_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Take heed before Him, and hearken to His words; rebel not against Him, for He will not forgive your sins; for in My Name are His words. ");
INSERT INTO engoke_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","For if thou wilt truly hearken to His words, and do all that I shall speak, I will be a foe to thy enemies, and will afflict them that afflict thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For My Angel shall go before thee, and bring thee in, to the Amoraee and Hittaee, and Perizaee and Kenaanaee, Hivaee and Jebusaee; and I will destroy them. ");
INSERT INTO engoke_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Thou shalt not worship their idols, nor serve them, nor do according to their doings, but shalt utterly demolish them, and break their images. ");
INSERT INTO engoke_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","And you shall serve before the Lord your God, and He will bless thy food and thy drink, and will take away grievous evils from among thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","There shall be none abortive or barren in thy land; the number of thy days will I complete. ");
INSERT INTO engoke_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send My terror before thee, and will perturb all the people among whom thou shalt come to fight against them, and I will make all thy adversaries turn their back before thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send the hornet before thee, and it shall drive out the Hivaee and Kenaanaee and the Hittaee from before thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not expel them before thee in one year, lest the land be made desolate, and the beasts of the field multiply against thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","By little and little I will drive them out before thee, until thou shalt be increased and inherit the land. ");
INSERT INTO engoke_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","And I will appoint thy boundary from the sea of Suph unto the sea of the Philistaee, and from the desert to the river; for I will deliver the inhabitants of the land into your hands, and thou shalt drive them out before thee. ");
INSERT INTO engoke_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Thou shalt strike no covenant with them nor with their idols. ");
INSERT INTO engoke_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They shall not dwell in thy land, lest they cause thee to commit sin before Me; for if thou serve their idols, it will be a stumbling-block to thee. ");
INSERT INTO engoke_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","And He said to Mosheh, Come up before the Lord, thou and Aharon, Nadab and Abihu, and seventy of the elders of Israel; and they shall worship at a distance. ");
INSERT INTO engoke_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","And Mosheh shall draw nigh alone before the Lord, but they shall not draw nigh, nor shall the people ascend with them. ");
INSERT INTO engoke_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","And Mosheh came and recited to the people all the words of the Lord and all the judgments; and all the people answered with one voice and said, All the words that the Lord hath spoken will we do. ");
INSERT INTO engoke_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","And Mosheh wrote all the words of the Lord. And he arose in the morning, and builded an altar at the lower part of the mountain, and twelve pillars, according to the twelve tribes of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","And he sent the firstborn sons of Israel, and they offered holocausts, and sacrificed oxen (as) consecrated victims before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","And Mosheh took half of the blood and set it in basins, and half the blood he sprinkled upon the altar. ");
INSERT INTO engoke_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","And he took the Book of the Covenant, and read before the people; and they said, All that the Lord hath spoken we will do and obey. ");
INSERT INTO engoke_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","And Mosheh took the blood and sprinkled it upon the altar to propitiate for the people, and said, Behold the Blood of the Covenant which the Lord hath ratified with you upon all these words. ");
INSERT INTO engoke_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","And Mosheh and Aharon, Nadab and Abihu, and seventy of the elders of Israel went up. ");
INSERT INTO engoke_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","And they saw the Glory of the God of Israel, and under the throne of His glory as the work of a precious stone, and as the face of heaven for its clearness. ");
INSERT INTO engoke_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yet the princes of the sons of Israel were not hurt; and they saw the Glory of the Lord, and rejoiced in their sacrifices which were accepted with favour, as though they had eaten and drunk. ");
INSERT INTO engoke_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","And the Lord said to Mosheh, Come up into My Presence in the mountain, and be there, and I will give thee the tablets of stone, and the law and the precepts, as I have written (them), that thou mayest teach them. ");
INSERT INTO engoke_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","And Mosheh arose and Jehoshua his minister, and Mosheh ascended the mountain on which was revealed the Glory of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","But to the elders he said, Wait for us here until we return to you: and, behold, Aharon and Hur are with you: whosoever hath a (matter for) judgment, let him bring it before them. ");
INSERT INTO engoke_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","And Mosheh ascended the mountain, and the cloud covered the mountain; ");
INSERT INTO engoke_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","And the glory of the Lord dwelt upon Mount Sinai, and the cloud enveloped it six days. And He called to Mosheh on the seventh day out of the midst of the cloud. ");
INSERT INTO engoke_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","And the appearance of the Glory of the Lord was as the appearance of devouring fire on the summit of the mountain in the eyes of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","And Mosheh entered into the midst of the cloud, and ascended the mount; and Mosheh was in the mount forty day and forty nights. ");
INSERT INTO engoke_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Speak with the sons of Israel that they set apart before Me a separated portion: from every man who is willing in his heart thou shalt receive that which is set apart. ");
INSERT INTO engoke_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","And this is the separation that thou shalt take of them: gold, and silver and brass; ");
INSERT INTO engoke_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","And hyacinth, and purple and vermilion, (bright colour,) and fine linen, (butz,) and hair of goats, ");
INSERT INTO engoke_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","And skins of rams made red, and skins of purple, and sittin woods; ");
INSERT INTO engoke_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Oil for the illuminators, aromatics for the anointing oil, and aromatics for the incense; ");
INSERT INTO engoke_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Burilla stones, and stones that may complete the insetting of the ephod and the breastplate. ");
INSERT INTO engoke_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","And they shall make before me A SANCTUARY in which I will dwell among them. ");
INSERT INTO engoke_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Altogether as I show thee the pattern of the sanctuary, and the pattern of all its vessels, even so shalt thou make them. ");
INSERT INTO engoke_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","And they shall make an ARK of sitta wood; two cubits and a half its length, and a cubit and a half its breadth, and a cubit and a half its height. ");
INSERT INTO engoke_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","And thou shalt cover it with pure gold within and without, and thou shalt make a crown of gold upon it round about. ");
INSERT INTO engoke_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","And thou shalt cast for it four rings of gold, and set them upon its four corners, two rings upon one side of it, and two rings upon its other side. ");
INSERT INTO engoke_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","And thou shalt make staves of sittin woods, and cover them with gold, ");
INSERT INTO engoke_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","and shalt insert the staves in the rings upon the sides of the ark, that the ark may be carried upon them. ");
INSERT INTO engoke_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","In the rings of the ark shall be the staves, they shall not be removed therefrom. ");
INSERT INTO engoke_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","And thou shalt place in the ark the Testimony that I will give thee. ");
INSERT INTO engoke_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","And thou shalt make A PROPITIATORY Of pure gold; two cubits and a half its length, and a cubit and a half its breadth. ");
INSERT INTO engoke_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","And thou shalt make two KERUBIN of gold, beaten (ductile) shalt thou make them, on the two sides of the propitiatory. ");
INSERT INTO engoke_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","And thou shalt make one keruba on this side and one keruba on that side of the propitiatory; thou shalt make the kerubin on its two sides. ");
INSERT INTO engoke_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","And the kerubin shall have their wings outspreading above, overshadowing the propitiatory with their wings; and their faces shall be opposite one to another, towards the propitiatory shall be the faces of the kerubin. ");
INSERT INTO engoke_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","And thou shalt set the propitiatory upon the Ark over above, and within the ark shalt thou put the Testimony that I will give thee. ");
INSERT INTO engoke_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","And I will appoint My Word (Memra) with thee there; and I will speak with thee from above the Propitiatory, from between the two kerubin that are upon the Ark of the Testimony, all that I may command thee for the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","And thou shalt Make A TABLE of sittin woods, two cubits the length of it, and a cubit its breadth, and a cubit and a half its height. ");
INSERT INTO engoke_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","And thou shalt overlay it with pure gold, and make for it a crown of gold round about. ");
INSERT INTO engoke_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","And thou shalt make to it a border, a handbreadth high round about, and make a crown of gold to the border of it round about. ");
INSERT INTO engoke_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","And thou shalt make for it four golden rings, and put the rings upon the four corners of its four feet. ");
INSERT INTO engoke_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Opposite to the border shall be the rings for the place of the staves for carrying the table. ");
INSERT INTO engoke_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","And thou shalt make the staves of sittin woods, and cover them with gold, that they may carry the table upon them. ");
INSERT INTO engoke_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","And thou shalt make its dishes and its vases, its vials and its chalices with which the libations are outpoured, of pure gold shalt thou make them. ");
INSERT INTO engoke_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","And thou shalt set upon the table the PRESENCE BREAD continually before Me. ");
INSERT INTO engoke_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","And thou shalt make A CANDELABRUM; of pure ductile gold shalt thou make the candelabrum; its base and its shaft, its cups, apples, and lilies, of the same shall they be. ");
INSERT INTO engoke_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","And six branches shall come out from its sides, three branches of the candelabrum from one side, and three branches of the candelabrum on the second side. ");
INSERT INTO engoke_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Three cups (calyxes) figured on one branch with apple and lily, and three cups figured on one branch with apple and lily, so for the six branches that come out from the candelabrum. ");
INSERT INTO engoke_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","And upon the candelabrum shall be four cups, figurated with apples and lilies; ");
INSERT INTO engoke_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","An apple under the two branches of this, and an apple under the two branches of that, according to the six branches that come forth from the candelabrum. ");
INSERT INTO engoke_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Their apples and their branches shall be of it, all beaten of pure gold. ");
INSERT INTO engoke_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","And thou shalt make its seven lights, and kindle its lights that they may shine towards its face. ");
INSERT INTO engoke_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","And its snuffers and shovels (shall be made) of pure gold. ");
INSERT INTO engoke_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Of a talent of pure gold shall he make it and all these vessels. ");
INSERT INTO engoke_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","And look thou, and make, according to their resemblance which was displayed in the mount. ");
INSERT INTO engoke_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","And thou shalt make THE TABERNACLE (of) ten curtains of fine linen twined, and hyacinth, and purple, and vermilion, (and) figures of kerubin, the work of the artificer shalt thou make them. ");
INSERT INTO engoke_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","The length of one curtain twenty and eight cubits, and the breadth of one curtain four cubits; the measure of all the curtains shall be one. ");
INSERT INTO engoke_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five curtains shall be conjoined one with another, and five curtains conjoined one with another. ");
INSERT INTO engoke_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","And thou shalt make loops of hyacinth upon the edge of one curtain in the side on which it is joined, and so shalt thou do on the border of the second curtain in the side on which it is joined. ");
INSERT INTO engoke_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fifty loops shalt thou make in the one curtain, and fifty loops shalt thou make in the side of the curtain which is in the place of the second coupling, that the loops, may answer one with another. ");
INSERT INTO engoke_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","And thou shalt make fifty taches of gold, and loop the curtains one with another with the taches, that it may be one Tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","And thou shalt make curtains of goat’s (hair) to stretch over the tabernacle; eleven curtains thou shalt make them. ");
INSERT INTO engoke_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","The length of one curtain shall be thirty cubits, and the breadth of one curtain four cubits; of one measure shall be the eleven curtains. ");
INSERT INTO engoke_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","And thou shalt loop five curtains together, and six curtains together, and fold the sixth curtain against the front of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","And thou shalt make fifty loops on the edge of the one curtain where it is conjoined, and fifty loops on the edge of the curtain at the place of the second conjoinment. ");
INSERT INTO engoke_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","And thou shalt make fifty taches of brass, and introduce the taches into the loops, and conjoin the tabernacle that it may be one. ");
INSERT INTO engoke_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","And the overplus which remaineth of the tabernacle curtains, the half curtain, (namely,) thou shalt stretch over the hinder side of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","And the cubit on this and the cubit on that (side) which remain in the length of the curtains of the tabernacle shall be spread over the sides of the tabernacle, here and there, to cover it. ");
INSERT INTO engoke_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","And thou shalt make a covering for the tabernacle of rams’ skins dyed red, and a covering of purple skins above. ");
INSERT INTO engoke_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","And thou shalt make the standing-boards of the tabernacle of sittin woods. ");
INSERT INTO engoke_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ten cubits the length of one board, and a cubit and a half its breadth. ");
INSERT INTO engoke_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Two tenons (shall there be) to each board, fastened over against one another; so shalt thou make all the boards of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","And thou shalt make the boards for the tabernacle, twenty boards on the southern side. ");
INSERT INTO engoke_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","And forty bases of silver shalt thou make under the twenty boards; two bases under one board for its two tenons, and two bases under one board for its two tenons. ");
INSERT INTO engoke_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","And for the second side of the tabernacle, on the northern side, twenty boards ");
INSERT INTO engoke_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","And their forty sockets of silver; two sockets under one board, and two sockets under another. ");
INSERT INTO engoke_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","And for the side of the tabernacle westward thou shalt make six boards. ");
INSERT INTO engoke_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","And two boards thou shalt make at the corners of the tabernacle at their extremities; ");
INSERT INTO engoke_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","And they shall be united below and likewise united at head with one ring; so shall it be with both of them for the two corners. ");
INSERT INTO engoke_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","And they shall be eight boards, and their silver bases, sixteen bases; two bases under one board, and two bases under the other board. ");
INSERT INTO engoke_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","And thou shalt make bars of sittin woods, five for the boards of one side of the tabernacle, ");
INSERT INTO engoke_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","and five bars for the boards of the second side of the tabernacle, and five bars for the end side of the tabernacle toward the west. ");
INSERT INTO engoke_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","And the middle bar in the midst of the boards shall pass from end to end. ");
INSERT INTO engoke_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","And the boards thou shalt overlay with gold, and the rings make thou of gold, the place for the bars, and cover the bars with gold. ");
INSERT INTO engoke_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","And thou shalt erect the tabernacle after the manner of it which hath been showed thee on the mount. ");
INSERT INTO engoke_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","And thou shalt make A VEIL, of hyacinth, and purple, and vermilion, and fine linen twined with the work of the artificer, it shall be made, figured with kerubin. ");
INSERT INTO engoke_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","And thou shalt set it upon four pillars of sittin covered with gold, and their hooks shall be of gold upon four bases of silver. ");
INSERT INTO engoke_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","And thou shalt put the veil under the taches, and shalt bring in thither within the veil the Ark of the Testament; and the veil shall separate to you between the Holy and the Holy of Holies. ");
INSERT INTO engoke_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","And thou shalt set the Mercy Seat upon the ark of the Testament in the Holy of Holies. ");
INSERT INTO engoke_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","And place thou the table without the veil, and the candelabrum over against the table at the south side of the tabernacle, and the table place thou at the north side. ");
INSERT INTO engoke_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","And thou shalt make a curtain for the door of the tabernacle of hyacinth, and purple, and vermilion, and fine linen twined, the work of the embroiderer; ");
INSERT INTO engoke_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","And make for the curtain five pillars of sittin, and overlay them with gold, and their hooks shall be of gold; and shalt set them upon five bases of brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","And thou shalt make THE ALTAR of sittin woods; five cubits the length and five cubits the breadth; square shall be the altar, and three cubits its height. ");
INSERT INTO engoke_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","And thou shalt make its horns upon its four corners; of the same shall be its horns, and overlay it with brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","And make its pots, to collect the ashes, and its fireshovels, and its basins, and its flesh-hooks, and its thuribles, all its vessels make thou of brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","And make for it a grate, a work of netting of brass, and make upon the network four rings of brass upon its four sides, ");
INSERT INTO engoke_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","And place it under the surrounding of the altar beneath, that the net may extend to the middle of the altar. ");
INSERT INTO engoke_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","And make thou staves for the altar, staves of sittin wood, and overlay them with brass; ");
INSERT INTO engoke_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","And he shall put the staves into the rings, and the staves shall be at the two sides of the altar to carry it. ");
INSERT INTO engoke_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hollow (with) boards make thou it, according to what was showed thee in the mount, so do thou. ");
INSERT INTO engoke_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","And thou shalt make THE COURT of the tabernacle on the side toward the south: curtains (shall there be) for the court of fine twined linen a hundred cubits in length on one side. ");
INSERT INTO engoke_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","And its pillars twenty and their bases twenty of brass, the hooks of the pillars and their rods of silver. ");
INSERT INTO engoke_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","And so for the north side in length (there shall be) curtains of a hundred cubits long, and their columns twenty and their bases twenty of brass; the hooks of the pillars and their rods shall be of silver. ");
INSERT INTO engoke_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","And on the side of the court toward the west curtains of fifty cubits, their columns ten and their bases ten. ");
INSERT INTO engoke_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","And the breadth of the court toward the east side eastward, fifty cubits, ");
INSERT INTO engoke_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","And fifteen cubits the curtains on a side, their columns three and their bases three. ");
INSERT INTO engoke_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","And on the second side fifteen curtains, their pillars three, and their bases three. ");
INSERT INTO engoke_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","And for the door of the court shall be an hanging of twenty cubits, of hyacinth, and purple, and vermilion, and fine linen twined, the work of the embroiderer; their pillars four and their bases four. ");
INSERT INTO engoke_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the pillars round about the court shall be (united) with rods of silver, their hooks shall be of silver and their bases of brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The length of the court, one hundred cubits, and the breadth fifty, and the height five cubits, of fine linen twined, and their bases of brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the vessels of the tabernacle, and all its service, and all its utensils, and all the pins of the court shall be of brass. ");
INSERT INTO engoke_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","And thou shalt instruct the sons of Israel to bring to thee the pure oil of olives, beaten, to illuminate, that the lamps may burn continually. ");
INSERT INTO engoke_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the tabernacle of ordinance, without the veil that is before the testimony, Aharon and his sons shall set it in order from evening to morning before the Lord; a perpetual statute for the generations of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","And thou, bring to thee Aharon thy brother and his sons with him from among the sons of Israel, that they may minister before Me; Aharou, Nadab and Abihu, Elazar and Ithamar, sons of Aharon. ");
INSERT INTO engoke_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","And thou shalt make the holy vestments for Aharon thy brother for glory and for praise. ");
INSERT INTO engoke_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","And speak thou with all the wise of heart whom I have filled with the Spirit of wisdom, that they make the vestments of Aharon to consecrate him to minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","And these are the vestments which they shall make; the breastplate, and the ephoda, and the robe, and the inwrought tunic, and the mitre, and the girdle; and they shall make holy vestments for Aharon thy brother and for his sons to minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","And they shall take the gold, and the hyacinth, and the vermilion, and the fine linen. ");
INSERT INTO engoke_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","And shall make the EPHODA of gold, hyacinth, and vermilion, and fine linen twined, the work of the artificer. ");
INSERT INTO engoke_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Two shoulder-pieces doubled (or, conjoined) shall it have at the two sides conjoined. ");
INSERT INTO engoke_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","And the adorned girdle thereof which is upon it shall be of the same work, and be of gold, hyacinth, vermilion, and fine linen twined. ");
INSERT INTO engoke_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","And thou shalt take two stones of onyx (burilla); and engrave upon them the names of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six of their names upon the one stone, and the six names which remain upon the second stone, according to their nativity. ");
INSERT INTO engoke_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","By the work of the artificer in precious stone the writing shall be distinct; as the engraving of a ring, so shalt thou engrave the two stones with the names of the sons of Israel; inwrought in sockets of gold shalt thou make them. ");
INSERT INTO engoke_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","And thou shalt put the two stones upon the shoulders of the ephod, stones of the memorial of the sons of Israel; and Aharon shall bear their names before the Lord upon his two shoulders for a memorial. ");
INSERT INTO engoke_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","And thou shalt make sockets of gold; ");
INSERT INTO engoke_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","And two chains of pure gold enwreathed shalt thou make of twisted work, and shalt set the twisted chains in the sockets. ");
INSERT INTO engoke_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","And thou shalt make THE BREASTPLATE OF JUDGMENT with the work of the artificer, like the work of the ephod shalt thou make it, of gold, hyacinth, vermilion, and fine linen twined shalt thou make it. ");
INSERT INTO engoke_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Square shall it be; doubled; a span its length and a span its breadth; ");
INSERT INTO engoke_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","And thou shalt fulfil in it the complement of stones: four rows of precious stones; the first row, the carnelian, topaz and smaragd, the first row; ");
INSERT INTO engoke_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","The second row, the carbuncle, sapphire, and onyx; ");
INSERT INTO engoke_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","And the third row, the jacinth, agate, and amethyst; ");
INSERT INTO engoke_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","And the fourth row, the chrysolite, and beryl, and jasper: they shall be inset in gold in their completeness. ");
INSERT INTO engoke_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","And the stones shall be according to the names of the sons of Israel, twelve according to their names; the writing distinct as the engraving of a ring; a man according to his name shall they be, after the twelve tribes. ");
INSERT INTO engoke_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","And thou shalt make on the breastplate wreathed chains of twisted work of pure gold, ");
INSERT INTO engoke_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","and upon the breastplate two golden rings, and shalt set the two rings upon the two sides of the breastplate. ");
INSERT INTO engoke_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","And thou shalt put the two wreaths of gold into the two rings on the sides of the breastplate; ");
INSERT INTO engoke_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","And the two wreaths which are upon its two sides thou shalt set in the two sockets, and put them upon the shoulders of the ephod over against its front. ");
INSERT INTO engoke_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","And thou shalt make two rings of gold, and set them on the two sides of the breastplate at its edges on the side of the ephod within. ");
INSERT INTO engoke_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","And thou shalt make two (other) rings of gold, and put them upon the two shoulders of the ephod beneath, over against its conjoinment above the girdle of the ephod. ");
INSERT INTO engoke_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","And they shall unite the breastplate with its rings to the rings of the ephod with ribbon of hyacinth to be above the girdle of the ephod, that the breastplate be not separated from (being) upon the ephod. ");
INSERT INTO engoke_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","And Aharon shall bear the names of the sons of Israel on the breastplate of judgment upon his heart in his going into the sanctuary, for a perpetual memorial before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","And thou shalt put in (or upon) the breastplate of judgment THE URAIA and THE THUMMAIA; and they shall be upon Aharon’s heart when he entereth before the Lord; and Aharon shall carry the judgment of the sons of Israel upon his heart before the Lord continually. ");
INSERT INTO engoke_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","And thou shalt make the ROBE of the ephod of hyacinth altogether. ");
INSERT INTO engoke_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","And the orifice thereof for the head shall be doubled inwardly; its opening shall be binded round about with the work of the sewer, as the opening of a coat of mail it shall be, that it be not torn. ");
INSERT INTO engoke_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","And thou shalt make on the lower part of it pomegranates of hyacinth, and purple, and vermilion upon its lower part round about, with bells of gold between them round about. ");
INSERT INTO engoke_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","A golden bell and a pomegranate; a golden bell and a pomegranate upon the lower part of the robe round about. ");
INSERT INTO engoke_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","And it shall be upon Aharon to minister, and its voice shall be heard in his entering into this sanctuary before the Lord, and in his coming out, that he shall not have died. ");
INSERT INTO engoke_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","And thou shalt make a DIADEM (or plate) of pure gold, and engrave upon it (in) distinct writing HOLINESS UNTO THE LORD; ");
INSERT INTO engoke_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","And thou shalt set it upon a ribbon of hyacinth, that it may be upon the tiara; over the front of the tiara shall it be. ");
INSERT INTO engoke_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","And it shall be upon Aharon’s forehead, that Aharon may bear the iniquity of the things which the sons of Israel may consecrate of all their consecrated gifts; and it shall be upon his fore-head continually for their acceptableness before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","And thou shalt weave the vesture of fine linen, and make the tiara of fine linen, and a girdle shalt thou make, the work of the embroiderer. ");
INSERT INTO engoke_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","And for the sons of Aharon thou shalt make vestures, and make for them girdles, and mitres shalt thou make for them for honour and for praise. ");
INSERT INTO engoke_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","And thou shalt dress them, Aharon thy brother and his sons with him, and shalt anoint them and offer oblations and consecrate them, that they may minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","And thou shalt make them coverings of fine linen to cover the flesh of their shame; from the loins to the thighs shall they be. ");
INSERT INTO engoke_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","And they shall be upon Aharon and upon his sons in their entering into the tabernacle of ordinance, or in approaching to the altar to minister in the sanctuary, that they contract not guilt and die. (This shall be) an everlasting statute for him and for his sons after him. ");
INSERT INTO engoke_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","And this is the thing which thou shalt do to them, to consecrate them to minister before Me: Take one bullock, the young of a bullock, and two rams unblemished; ");
INSERT INTO engoke_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","And unleavened bread, and unleavened cakes mingled with oil, and wafers unleavened which are anointed with oil; of wheaten flour shalt thou make them. ");
INSERT INTO engoke_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","And thou shalt put them on one basket, and bring them in the basket, and the bullock and the two rams, ");
INSERT INTO engoke_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","And Aharon and his sons thou shalt bring to the door of the tabernacle of ordinance, and wash them with water. ");
INSERT INTO engoke_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","And thou shalt take the vestments, and dress Aharon with the tunic and the robe of the ephod, and the ephod and the breastplate, and shalt ordain him with the girdle of the ephod. ");
INSERT INTO engoke_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","And thou shalt set the tiara on his head, and put the diadem of Holiness upon the tiara. ");
INSERT INTO engoke_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","And thou shalt take the oil of anointing, and pour upon his head to anoint him. ");
INSERT INTO engoke_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","And thou shalt bring his sons near, and dress them in the tunics ");
INSERT INTO engoke_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","And gird them with the girdles, Aharon and his sons; and thou shalt set on them the mitres, and it shall be to them a priesthood, by a perpetual statute. And thou shalt offer the oblation for Aharon and the oblation for his sons. ");
INSERT INTO engoke_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","And the bullock shalt thou offer before the tabernacle of ordinance. And Aharon and his sons shall lay their hands upon the head of the bullock; ");
INSERT INTO engoke_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","And thou shalt slay the bullock before the Lord at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","And thou shalt take of the blood of the bullock, and put it upon the horns of the altar with thy finger, and all the blood (that remains) thou shalt pour out at the base of the altar. ");
INSERT INTO engoke_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","And thou shalt take all the fat which covereth the inwards, and the caul that is upon the liver, and the two kidneys and the fat that is upon them, and sacrifice them upon the altar. ");
INSERT INTO engoke_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","And the flesh of the bullock, his skin, and his dung, burn thou with fire without the camp; it is a sin offering. ");
INSERT INTO engoke_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","And thou shalt take the one ram, and Aharon and his sons shall lay their hands upon the head of the ram; ");
INSERT INTO engoke_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","And thou shalt kill the ram, and take his blood, and sprinkle upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","And the ram thou shalt divide by his members, and shalt cleanse his inwards, and his legs, and put them upon his members, and upon his head, ");
INSERT INTO engoke_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","and thou shalt sacrifice the ram at the altar; it is a holocaust before the Lord, to be accepted with favour, an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","And thou shalt take the second ram, and Aharon and his sons shall lay their hands upon the head of the ram. ");
INSERT INTO engoke_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","And thou shalt kill the ram, and take of his blood, and put it on the tip of Aharon’s ear, and upon the tip of the right ear of his sons, and upon the thumb of their right hand, and upon the toe of their right foot; and thou shalt sprinkle the blood upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","And thou shalt take of the blood which is upon the altar, and of the oil of anointing, and drop it on Aharon and on his vestments, and on his sons, and on the vestments of his sons with him, and he shall be consecrated, he and his vestments, and his sons, and the vestments of his sons with him. ");
INSERT INTO engoke_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","And thou shalt take of the ram, the fat, and the tall, and the fat which covereth the inwards, and the caul which is on the liver, and the two kidneys, and the fat which is on them, and the right shoulder, for it is a ram for oblation; ");
INSERT INTO engoke_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","And one loaf of bread, and one cake of bread (with) oil, and one wafer from the basket of the unleavened ones which is before the Lord: ");
INSERT INTO engoke_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","And put thou all upon the hands of Aharon and upon the hands of his sons, and uplift them for an elevation before the Lord; ");
INSERT INTO engoke_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","And take them from their hands, and offer them at the altar upon the burnt offering, that they may be received with acceptance before the Lord; it is an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","And thou shalt take the breast of the ram of Aharon’s oblations, and uplift it, an elevation before the Lord; and it shall be thy portion. ");
INSERT INTO engoke_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","And thou shalt consecrate the breast of the elevation and the shoulder of separation which is uplifted and which is separated of the oblation-ram of Aharon and that of his sons; ");
INSERT INTO engoke_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","And it shall be for Aharon and for his sons by a perpetual statute for the sons of Israel, because it is a thing separated. And a separation shall be (taken) from the sons of Israel of their consecrated sacrifices, (even) their separation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","And the sacred garments of Aharon shall be his sons’ after him, to be anointed in them, (and) in them to offer their oblations. ");
INSERT INTO engoke_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Seven days shall the priest wear them, who of his sons (is to be anointed) instead of him, and who shall enter into the tabernacle of ordinance to minister in the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","And the ram of the oblations thou shalt take, and boil his flesh in the holy place. ");
INSERT INTO engoke_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","And Aharon and his sons shall eat the flesh of the ram and the bread that is on the basket at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","And they may eat those things by which propitiation is made in offering them as oblations to consecrate them; but an alien may not eat, because they are sacred. ");
INSERT INTO engoke_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","And if any (part) of the flesh of the oblations or of the bread remain until the morning, the remainder shall be burned with fire; it shall not be eaten, it is sacred. ");
INSERT INTO engoke_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","And thou shalt do (thus) to Aharon and to his sons, according to all that I have prescribed to thee: seven days shalt thou offer their oblations. ");
INSERT INTO engoke_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","A bullock that is a sin offering thou shalt perform daily for expiation, and thou shalt make purification upon the altar in making expiation upon it, and shalt anoint it, to sanctify it. ");
INSERT INTO engoke_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Seven days must thou make expiation on the altar to sanctify it, and the altar shall be most holy; whosoever shall touch the altar let him be sanctified. ");
INSERT INTO engoke_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","And this is what thou shalt perform upon the altar: Two lambs, the offspring of the year, for the day continually. ");
INSERT INTO engoke_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","The one lamb thou shalt perform in the morning, and the second lamb thou shalt perform between the evenings. ");
INSERT INTO engoke_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","And a tenth of flour, sprinkled with the fourth of a hina of beaten oil, and a libation of the fourth of a hina of wine, to one lamb. ");
INSERT INTO engoke_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","And the second lamb thou shalt perform between the evenings, as the oblation of the morning, and as its libation thou shalt perform it to be received with acceptance, an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","A perpetual holocaust unto your generations at the door of the tabernacle of ordinance before the Lord, where I have appointed My Word with you, to speak with you there. ");
INSERT INTO engoke_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","And I will appoint My Word there unto the sons of Israel, and (with) My glory will I sanctify (it). ");
INSERT INTO engoke_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","And I will sanctify the tabernacle of ordinance, and the altar, and Aharon, and his sons will I sanctify to minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","And I will cause My Shekinah to dwell in the midst of the sons of Israel, and I will be their God. ");
INSERT INTO engoke_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","And they shall know that I am the Lord their God who brought them out from the land of Mizraim, that I may make My Shekinah to dwell among them. I am the Lord their God. ");
INSERT INTO engoke_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","And thou shalt make an altar upon which to burn fragrant incense, of woods of sittin shalt thou make it. ");
INSERT INTO engoke_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A cubit its length, and a cubit its breadth, four-square shall it be, and two cubits its height. The horns of it shall be of the same. ");
INSERT INTO engoke_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","And thou shalt cover it with fine gold, its top and its sides round about, and its horns. And thou shalt make to it a crown of gold round about, ");
INSERT INTO engoke_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","And two rings of gold shalt thou make to it under its crown, upon its top corners, at its two sides and it shall be for the places of the staves by which to carry it. ");
INSERT INTO engoke_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","And thou shalt make the staves of sittin woods, and cover them with gold. ");
INSERT INTO engoke_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","And thou shalt place it before the veil which is over the ark of the testimony before the mercy seat which is over the testimony, where I will appoint My Word to be with thee. ");
INSERT INTO engoke_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","And Aharon shall burn thereon fragrant incense from morning to morning, when he setteth the lamps in order he shall burn it. ");
INSERT INTO engoke_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","And when Aharon kindleth the lamps between the evenings, he shall burn fragrant incense continually before the Lord in your generations. ");
INSERT INTO engoke_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","You shall not offer upon it incense of strange perfumes, nor holocaust, nor mincha, nor pour any libation upon it. ");
INSERT INTO engoke_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","And Aharon shall atone upon its horns once in the year with the blood of the sin offering of the atonement, once in the year shall he atone upon it, unto your generations. It is holy of holiness before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","When thou takest the account of the sons of Israel according to their number, they shall give every man a ransom for his soul before the Lord, when thou numberest them, that there may not be death among them when thou numberest them. ");
INSERT INTO engoke_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","This they shall give: everyone who cometh over to the adnumberment, a half shekel, of the shekel of the sanctuary, of twenty mayin the shekel, half a shekel shall be set apart before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone who cometh over to the adnumberment, from a son of twenty years and above, shall give the separation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","He who is rich shall not increase (it), and he who is poor shall not diminish from the half shekel in presenting the separation before the Lord to propitiate for your souls. ");
INSERT INTO engoke_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","And thou shalt take the silver of the propitiation from the sons of Israel, and appoint it for the service of the tabernacle of ordinance and it shall be to the sons of Israel for a memorial before the Lord to propitiate for your souls. ");
INSERT INTO engoke_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Thou shalt make a LAVER of brass, and its foundation of brass for purifying; and set it between the tabernacle of ordinance and the altar, and put water therein. ");
INSERT INTO engoke_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","And Aharon and his sons shall purify at it their hands and their feet. ");
INSERT INTO engoke_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","In their entering into the tabernacle of ordinance they shall cleanse themselves with water, that they die not; or when they approach the altar to minister, to offer an oblation before the Lord; ");
INSERT INTO engoke_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","And (thus) they shall purify their hands and their feet, that they may not die. And it shall be to them an everlasting statute, to him and to his sons unto their generations. ");
INSERT INTO engoke_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Take thou also to thee choice (first or principal) aromatics: pure myrrh, five hundred (shekels’ weight); and sweet cinnamon, one half (as much), two hundred and fifty (shekels) weight; of sweet calamus, two hundred and fifty (shekels’) weight; ");
INSERT INTO engoke_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","And cassia, five hundred (shekels) weight, of the shekels of the sanctuary; and olive oil, a hina full; ");
INSERT INTO engoke_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","And make it a holy anointing oil, most fragrant, the work of the perfumer; it shall be the holy oil for anointing. ");
INSERT INTO engoke_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","And thou shalt anoint therewith the tabernacle of ordinance and the ark of the testimony, ");
INSERT INTO engoke_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","and the table and all its vessels, and the candelabrum and its vessels, and the altar of sweet incense, ");
INSERT INTO engoke_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","and the altar of burnt offering and all its vessels, and the laver and its foundation, ");
INSERT INTO engoke_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","And consecrate them. They shall be most holy; whoever approacheth them shall be sanctified. ");
INSERT INTO engoke_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","And Aharon and his sons thou shalt anoint, and consecrate them to minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And thou shalt speak to the sons of Israel, saying, A holy anointing oil shall thus be unto Me for your generations. ");
INSERT INTO engoke_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Upon the flesh of man it shall not be poured, nor the like to it be made; sacred is it, and sacred shall it be to you. ");
INSERT INTO engoke_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","The man who compoundeth the like to it, or who putteth it upon an alien, shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","And the Lord said to Mosheh, Take thee spices, stachte and onycha, and galbanum spices, and pure frankincense, weight for weight shall they be; ");
INSERT INTO engoke_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","And thou shalt make it a sweet incense, fragrant, the work of the, perfumer, mixed, pure, for consecration. ");
INSERT INTO engoke_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","And thou shalt beat some of it and make it fine, and put thereof before the testimony in the tabernacle of ordinance, where I will appoint My Word to be with thee; to you it shall be most holy. ");
INSERT INTO engoke_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","And of the sweet incense which thou shalt make you must not make the like for yourselves; it shall be sacred to thee before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","The man who maketh the like of it, to smell thereto, shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Behold, I have named by name Bezalel bar Uri bar Hur, of the tribe of Jehudah, ");
INSERT INTO engoke_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","And have fulfilled him with the spirit of prophecy from before the Lord, with wisdom and with intelligence, and with knowledge, and in all work (to excel), ");
INSERT INTO engoke_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","To Instruct artificers to work in gold, and in silver, and in brass, ");
INSERT INTO engoke_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","And in artisanship of precious stone, to fill in, and in carving of wood, to accomplish all the work. ");
INSERT INTO engoke_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","And I, behold, have given with him Ahaliab bar Achisamak, of the tribe of Dan; and in the heart of all the wise of heart have I ingiven wisdom, that they may make all that I have commanded thee: ");
INSERT INTO engoke_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","The tabernacle of ordinance, and the ark of the testimony, and the propitiatory that is upon it, and all the vessels of the tabernacle; ");
INSERT INTO engoke_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","And the table and its vessels, and the pure candelabrum and all its vessels, and the altar of sweet incense, ");
INSERT INTO engoke_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","and the altar of burnt offering and all its vessels, and the laver and its foundation. ");
INSERT INTO engoke_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","And the vestments of ministration, and the holy vestments of Aharon the priest, and the vestments of his sons for ministry; ");
INSERT INTO engoke_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","And the oil of anointing and the sweet incense for the sanctuary, according to all that I have commanded thee, they shall make. ");
INSERT INTO engoke_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Speak thou also with the sons of Israel, saying, The days of My Sabbaths ye shall indeed keep; for it is a sign between My Word and you, unto your generations, that ye may know that I am the Lord who sanctifieth you. ");
INSERT INTO engoke_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","And you shall keep the Sabbath, for it is holy unto you; whosoever profaneth it, dying, he shall die; for whosoever doeth work therein, that man shall be destroyed from among his people. ");
INSERT INTO engoke_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Six days shalt thou do work, and the seventh day is Sabbath, the Holy Sabbath before the Lord: whosoever doeth work on the day of the Sabbath, dying, he shall die. ");
INSERT INTO engoke_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","And the sons of Israel shall keep the Sabbath to fulfil (perform) the Sabbath unto their generations, a statute forever. ");
INSERT INTO engoke_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Between My Word and the sons of Israel it is a sign forever for in six days the Lord made the heavens and the earth; and in the seventh day rested and was refreshed. ");
INSERT INTO engoke_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","And He gave to Mosheh, when He had finished to speak with him on Mount Sinai, two tablets of the testimony, tablets of stone inscribed with the finger of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","But the people saw that Mosheh delayed to come down from the Mount; and the people gathered together unto Aharon, and said to him, Arise, make us gods (dachalan, pl. objects to be venerated) that may proceed before us; for this Mosheh, the man who brought us up from the land of Mizraim, we know not what hath been to him. ");
INSERT INTO engoke_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","And Aharon said to them, Take off the golden ear-rings which are in the ears of your wives, your sons, and your daughters, and bring them to me. ");
INSERT INTO engoke_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","And all the people took off the golden rings which were in their ears and brought them unto Aharon. ");
INSERT INTO engoke_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","And he took them from their hands, and formed it with a graver, and made it a molten calf. And they said, These are thy gods, Israel, which brought thee up from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","And Aharon saw, and builded an altar before it; and Aharon proclaimed and said, A feast shall be held before the Lord tomorrow. ");
INSERT INTO engoke_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","And they arose next day, and sacrificed burnt offerings and offered oblations; and the people sat around to eat and drink, and rose up to disport. ");
INSERT INTO engoke_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","And the Lord spake with Mosheh, Go, descend, for thy people whom thou broughtest up from the land of Mizraim have corrupted themselves; ");
INSERT INTO engoke_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have quickly warped from the way which I had taught them; they have made a molten calf, and have worshipped it, and sacrificed unto it and have said, These are thy gods, Israel, which have brought thee up from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","And the Lord said to Mosheh, It is seen before Me that this people are hard-necked. ");
INSERT INTO engoke_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","And now refrain from thy prayer before Me, and My anger shall prevail against them, and I will destroy them, and will make thee to a great people. ");
INSERT INTO engoke_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Mosheh prayed before the Lord his God, and said, Why, Lord, is Thy anger strong against Thy people, whom Thou didst bring up from the land of Mizraim with great power and with might hand? ");
INSERT INTO engoke_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Wherefore should the Mizraee speak to say, With evil (purpose) He led them out to kill them among the mountains, and to consume them from the face of the earth? Turn from the strength of Thine anger, and revert from the evil which Thou hast threatened to do unto Thy people. ");
INSERT INTO engoke_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Abraham, Izhak, and Israel, Thy servants to whom Thou hast sworn by Thy Word, and to whom Thou hast said, I will multiply your sons as the stars of the heavens, and all this land of which I have spoken I will give unto your sons, and they shall own it forever. ");
INSERT INTO engoke_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","And the Lord did turn from the evil which He had threatened to do unto the people. ");
INSERT INTO engoke_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","And Mosheh returned and went down from the Mount, and the two tablets of testimony were in his hand: the tablets were inscribed on their two sides, here and there were they inscribed. ");
INSERT INTO engoke_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","And the tablets were the work of the Lord, and the writing was the writing of the Lord set forth distinctly upon the tablets. ");
INSERT INTO engoke_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","And Jehoshua heard the voice of the people as they made outcry, and he said to Mosheh, The voice of war is in the camp. ");
INSERT INTO engoke_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","But he said, It is not the voice of men who are victorious, nor is it the voice of the weak who are beaten, but it is the voice of revelers that I hear. ");
INSERT INTO engoke_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","And it was that as he drew nigh the camp, and saw the calf and the dancing, that the anger of Mosheh grew strong, and he cast from his hands the tablets, and brake them at the declivity of the mountain. ");
INSERT INTO engoke_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","And he took the calf which they had made, and burned it in fire, and ground it until it was powder, and spread it on the face of the water, and made the sons of Israel drink it. ");
INSERT INTO engoke_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","And Mosheh said to Aharon, What did this people to thee, that thou hast brought upon them so great a sin? ");
INSERT INTO engoke_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","And Aharon said, Let not my lord’s anger be violent: thou knowest the people, that it is prone to evil. ");
INSERT INTO engoke_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","And they said to me, Make us gods that shall go before us: for this Mosheh, the man who brought us up form the land of Mizraim, we know not what hath been done to him. ");
INSERT INTO engoke_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","And I said to them, Whoever hath gold let him deliver, and give it to me; and I cast it into the fire, and this calf came forth. ");
INSERT INTO engoke_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","And Mosheh saw that the people were undone (or, made empty); for Aharon had undone them, to defile them with an evil name in their generations; ");
INSERT INTO engoke_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","And Mosheh stood at the gate of the camp, and said, Let those who fear the Lord come to me. And all the sons of Levi gathered together to him. ");
INSERT INTO engoke_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","And he said to them. Thus saith the Lord the God of Israel, Let every man put his sword upon his thigh, pass through, and return, from gate to gate in the camp, and slay, a man his brother, and a man his companion, and a man his neighbour. ");
INSERT INTO engoke_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","And the sons of Levi did according to the word for Mosheh, and there fell of the people in that day as three thousand men. ");
INSERT INTO engoke_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","And Mosheh said, Present your hands this day an offering before the Lord, every man with (or, on account of) his son and his brother, that you may bring blessings upon you this day. ");
INSERT INTO engoke_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","And it was on the day following that Mosheh said to the people, You have sinned a great sin; but now I will go up before the Lord, if haply I may propitiate for your sin. ");
INSERT INTO engoke_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","And Mosheh returned before the Lord, and said in his prayer, This people have sinned a great sin, for they have made to them gods of gold. ");
INSERT INTO engoke_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now, if Thou wilt forgive their sin! But if not, blot me now out of the Book, which Thou hast written. ");
INSERT INTO engoke_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","And the Lord said to Mosheh, Him who hath sinned before Me, will I blot from My book. ");
INSERT INTO engoke_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","But now, go, lead the people to the place that I have told thee of: behold, My Angel shall proceed before thee; and in the day that I visit, I will visit upon them their sin. ");
INSERT INTO engoke_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And the Lord smote the people because they had worshipped (or served) the calf which Aharon had made. ");
INSERT INTO engoke_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","And the Lord said to Mosheh, Go, descend from hence, thou and the people thou hast brought up from the land of Mizraim, unto the land which I have covenanted unto Abraham, to Izhak, and to Jakob, saying, To thy sons will I give it. ");
INSERT INTO engoke_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Arid I will send My Angel before thee, and will drive oat the Kenaanaee, the Amoraee, and Hittaee, and the Pherizaee, the Hivaee, and the Jebusaee; ");
INSERT INTO engoke_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","to the land producing milk and honey: for My Shekinah shall not go up among you, because thou art a hard-necked people, lest I destroy thee in the way. ");
INSERT INTO engoke_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","And the people heard these words of evil, and lamented, and no man put on his usual ornaments. ");
INSERT INTO engoke_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","And the Lord said to Mosheh, Say to the children of Israel, Ye are a hard-necked people; if one hour My Shekinah go up among thee, I should destroy thee. And now take off thy garnishing from thee, and it will appear before me what I shall do with thee. ");
INSERT INTO engoke_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Arid the children of Israel removed their usual ornaments (on their return) from the mount of Horeb. ");
INSERT INTO engoke_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Arid Mosheh took a tabernacle, and spread it for himself without the camp, at a distance from the camp, and called it the Tabernacle of the House of Instruction: and it was that everyone who sought instruction from before the Lord, went forth to the tabernacle of the house of instruction without the camp. ");
INSERT INTO engoke_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","And it came to pass that when Mosheh went forth to the tabernacle, all the people rose up, and stood, every man at the door of his tent, and looked after Mosheh until he had entered into the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","And it was when Mosheh had entered the tabernacle, the column of the Cloud descended and stood at the door of the tabernacle, and (He) spake with Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","And all the people saw the column of the Cloud standing at the door of the tabernacle, and all the people arose and worshipped, every man at the door of his tent. ");
INSERT INTO engoke_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","And the Lord spake with Mosheh word with word, as a man speaketh with his companion. And he returned to the camp; but his minister, Jehoshua bar Nun, a young man, did not remove from the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","And Mosheh said before the Lord, See, Thou hast said to me, Take this people up; but Thou hast not let me know whom Thou wilt send with me; yet Thou hast said, I have ordained thee by name, and thou hast found mercy before Me. ");
INSERT INTO engoke_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","And if now I have found mercy before Thee, show me, I pray, Thy good way, that I may know Thy loving-kindness, and may find mercy before Thee, and make it manifest before Thee that this people is Thy people. ");
INSERT INTO engoke_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","And He said, My Shekinah shall go, and I will give thee rest. ");
INSERT INTO engoke_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","And he said before Him, If Thy Shekinah goeth not among us, let us not ascend from hence. ");
INSERT INTO engoke_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","And in what shall it be known that I and Thy people have found mercy before Thee, if Thy Shekinah go not up with us, to make for us the distinction, and to distinguish me and Thy people from every people that is upon the face of the earth? ");
INSERT INTO engoke_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","And the Lord said to Mosheh, This thing that thou hast spoken will I do, because thou hast found mercy before Me, and I have ordained thee by name. ");
INSERT INTO engoke_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","And he said, Show me, I pray, Thy Glory! ");
INSERT INTO engoke_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","And He said, I will make all My Goodness pass before thy face, and I will proclaim the Name of the Lord before thee, and I will be gracious to whom I will be gracious, and have mercy on whom I will have mercy. ");
INSERT INTO engoke_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","And He said, Thou canst not see the Face of My Shekinah; for no man can see Me and abide alive. ");
INSERT INTO engoke_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","And the Lord said, Behold, there is a place prepared before Me, and thou shalt stand upon the rock, ");
INSERT INTO engoke_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","and it shall be, when My Glory passeth, I will put thee in a cavern of the rock, and My Word shall overshadow thee until I have passed; ");
INSERT INTO engoke_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","And I will take away the Word (dibberath) of My Glory, and thou shalt see that which is after Me, but My Aspect shall not be seen. ");
INSERT INTO engoke_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","And the Lord said to Mosheh, Hew thee two tablets of stone as the first ones, and I will write upon the tablets the words that were upon the former tablets which thou hast broken. ");
INSERT INTO engoke_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","And be ready in the morning, and go up at morn to Mount Sinai, and stand there before Me on the summit of the mountain. ");
INSERT INTO engoke_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Let no man ascend with thee; let no man be seen upon all the mountain, nor sheep nor oxen be grazing upon the mountain. ");
INSERT INTO engoke_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","And hew two tablets of stone like the former ones. And Mosheh arose in the morning, and ascended Mount Sinai, as the Lord had commanded him, and took in his hand two tablets of stone. ");
INSERT INTO engoke_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","And the Lord was revealed in the Cloud, and He stood with him there, and He proclaimed the Name of the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","And the Lord made His Shekinah pass before his face; and he proclaimed, The Lord, the Lord God, Merciful and Gracious, slow to anger, and making goodness and truth to abound; ");
INSERT INTO engoke_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Keeping goodness for thousands of generations; Forgiving iniquity and rebellion and guilt; Pardoning them who convert unto His law, but acquitting not them who convert not; Visiting the guilt of fathers upon the children and upon the children’s children of the rebellious, upon the third and upon the fourth generation. ");
INSERT INTO engoke_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","And Mosheh made haste, and bowed upon the ground and worshipped. ");
INSERT INTO engoke_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","And he said, If now I have found mercy before Thee, O Lord, let, I pray, the Shekinah of the Lord go among us; for it is a hard-necked people; but forgive Thou our guilty and our sin, and take possession of us. ");
INSERT INTO engoke_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","And He said, Behold, I make a covenant before all thy people that I will do wonders which were never created upon all the earth, nor among any of the people; and all peoples among whom thou art shall see the work of the Lord; for terrible shall that be which I will do with thee. ");
INSERT INTO engoke_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observe thou that which I command thee this day. Behold, I will drive out from before thee the Amoraee, and Kenaanaee, and Hittaee, and Pherizaee, and Hivaee, and Jebusaee. ");
INSERT INTO engoke_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Beware lest thou make a covenant with the inhabitants of the land upon which thou shalt enter, lest it become a stumbling-block in the midst of thee: ");
INSERT INTO engoke_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","But their altars thou shalt destroy, and their statues break, and their groves cut down; ");
INSERT INTO engoke_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For thou shalt not worship the idols of the peoples; for the Lord, Zealous is His Name, a zealous God is He. ");
INSERT INTO engoke_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Lest thou strike a covenant with the inhabitants of the land, and go erring after their idols, and to their idols offer sacrifices, and they invite thee, and thou eat of their sacrifices, ");
INSERT INTO engoke_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","And thou take of their daughters for thy sons, and they make thy daughters go erring after their idols, and thy sons to go erring after their idols. ");
INSERT INTO engoke_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Molten gods thou shalt not make to thee. ");
INSERT INTO engoke_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","The feast of the unleavened thou shalt keep. Seven days thou shalt eat unleavened (bread) as I have commanded thee, in the time of the month of Abiva; for in the month of Abiva thou didst come out of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","All that openeth the womb is Mine; all males of cattle thou shalt sanctify, the first-born of oxen and of sheep. ");
INSERT INTO engoke_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","But the firstling of an ass thou mayest redeem with a lamb; but if thou redeem him not, thou shalt cut him off. All the first-born of thy sons thou shalt redeem. And let none appear before Me empty. ");
INSERT INTO engoke_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Six days thou shalt labour, and on the seventh day rest; in sowing (time) and in reaping thou shalt rest. ");
INSERT INTO engoke_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","And the feast of Weeks thou shalt make to thee, of the firsts of the wheat harvest, and the feast of ingathering in the cycle of the year. ");
INSERT INTO engoke_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times in the year shall all your males appear before the Master of the World, the Lord God of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out the nations before thee, and enlarge thy borders, and no man shall covet thy land when thou goest up to appear before the Lord thy God three times in the year. ");
INSERT INTO engoke_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Thou shalt not sacrifice the blood of My Pascha with leaven, nor shall the fat of the sacrifices of the Paschal feast be left without the altar till the morning. ");
INSERT INTO engoke_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","The chief of the firstfruits of thy land thou shalt bring to the sanctuary of the Lord thy God. Thou shalt not eat flesh with milk. ");
INSERT INTO engoke_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","And the Lord said to Mosheh, Write for thee these words; for upon the expression of these words I make covenant with thee and with Israel. ");
INSERT INTO engoke_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","And he was there before the Lord forty days and forty nights; bread he ate not, nor water did he drink; and he wrote upon the tablets the words of the covenant, the Ten Words. ");
INSERT INTO engoke_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","And it was when Mosheh descended from the mountain of Sinai with the two tablets of the testimony in the hand of Mosheh, in his descending from the mount, that Mosheh knew not how great was the splendour of the glory of his countenance through His speaking with him. ");
INSERT INTO engoke_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","And Aharon and all the sons of Israel saw Mosheh, and, behold, great was the splendour of the glory of his countenance, and they were afraid to approach him. ");
INSERT INTO engoke_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Mosheh called to them, and Aharon and all the chiefs of the congregation returned to him, and Mosheh conversed with them. ");
INSERT INTO engoke_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","And afterward all the sons of Israel drew near, and he taught them all that the Lord had said to him on Mount Sinai. ");
INSERT INTO engoke_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","And when Mosheh had completed to speak with them, he put a veil upon his face. ");
INSERT INTO engoke_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But when Mosheh went in before the Lord to speak with Him, he removed the veil until he came out. And he went forth and spake with the sons of Israel of that which was commanded. ");
INSERT INTO engoke_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","And the children of Israel saw the face of Mosheh, that the splendour of the glory of Mosheh’s face was great; and Mosheh put the veil again upon his face until he went in to speak with Him. ");
INSERT INTO engoke_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","And Mosheli assembled all the congregation of the sons of Israel, and said to them, These are the things which the Lord hath commanded you to do. ");
INSERT INTO engoke_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Six days thou shalt do work, but the seventh day (is) a holy rest, the Sabbath before the Lord: everyone who doeth work thereon shall be put to death. ");
INSERT INTO engoke_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","You may not kindle a fire in all your dwellings on the day of the Sabbath. ");
INSERT INTO engoke_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","And Mosheh spake to all the congregation of the sons of Israel, saying, ");
INSERT INTO engoke_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take from you a separation (aphrashutha) before the Lord of everyone whose heart may be willing; let him bring the separation before the Lord: gold, and silver, and brass, ");
INSERT INTO engoke_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","And hyacinth, and crimson, and scarlet, and fine linen, and goat’s hair, ");
INSERT INTO engoke_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","and ram’s skin dyed red, and purple skins, and sittin woods; ");
INSERT INTO engoke_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","And oil for the illuminator, and aromatics for the anointing oil, and for the sweet perfumes; ");
INSERT INTO engoke_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","And onyx stones and complete stones for insetting in the ephod and in the breastplate. ");
INSERT INTO engoke_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","And all the wise-hearted among you shall come and make all that the Lord hath commanded: ");
INSERT INTO engoke_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","The tabernacle, its tent and its coverings, its hasps, its boards, its bars, its pillars, and its bases. ");
INSERT INTO engoke_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","The ark, and its staves, the mercy seat, and the veil that shall be spread; ");
INSERT INTO engoke_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","The table, and its staves, and all its vessels; and the bread of the Presence, ");
INSERT INTO engoke_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","and the candelabrum for light, and its vessels, and its lamps, and the oil for illumination. ");
INSERT INTO engoke_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","And the altar of sweet incense, and its staves, and the oil of anointing, and the incense of perfumes, and the curtain of the door of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","The altar of burnt offering, and its brasen grate, its staves, and all its vessels; the laver and its base. ");
INSERT INTO engoke_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","The curtains of the court, and its pillars, and its bases, and the hanging of the gate of the court. ");
INSERT INTO engoke_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","The nails of the tabernacle, and the nails of the court and their cordings. ");
INSERT INTO engoke_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","The vestments of ministration for ministering in the sanctuary, the holy vestments of Aharon the priest, and the vestments of his sons for ministration. ");
INSERT INTO engoke_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","And all the congregation of the sons of Israel went forth from before Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","And they came, every man who was led by his heart, and everyone whose spirit was ample, and brought their separation before the Lord, for the work of the tabernacle of ordinance, and for all its service, and for the holy vestments. ");
INSERT INTO engoke_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","And they came, the men with the women, everyone who was willing of heart, and brought chains, and bracelets, and rings, and bands, all of gold. ");
INSERT INTO engoke_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","And every man who uplifted an offering of gold before the Lord, and every man with whom was found hyacinth, or purple, or crimson, or fine linen, or goats’ skins, or rams’ skins dyed red, or purpled skins, brought. ");
INSERT INTO engoke_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone who would offer silver or brass, brought the separation before the Lord; and everyone with whom was found woods of sittin for any work of the service, brought. ");
INSERT INTO engoke_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","And every woman wise in heart spun with her hands, and brought what was spun, the hyacinth, the purple, the crimson, and the fine linen. ");
INSERT INTO engoke_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And all the women with whom was willingness of heart with wisdom spun goat’s hair. ");
INSERT INTO engoke_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","And the princes brought onyx stones and complete stones for the insetting of the ephod and the breastplate; ");
INSERT INTO engoke_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","And the perfume, and oil for the light and for the oil of anointing, and incense of perfumes. ");
INSERT INTO engoke_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Every man and woman whose heart led them to bring for all the work which the Lord had commanded to make by Mosheh, did the children of Israel bring willingly before the Lord. ");
INSERT INTO engoke_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","And Mosheh said to the sons of Israel, See, the Lord hath ordained by mane Bezalel bar Uri bar Hur, of the tribe of Jehudah, ");
INSERT INTO engoke_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","And hath filled him with the spirit of prophecy from before the Lord, with wisdom, with intelligence, and with knowledge, for all handicraft, ");
INSERT INTO engoke_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","And to teach the arts of working in gold, and in silver, and in brass, ");
INSERT INTO engoke_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","And the skilful work of precious stones for enchasing, and the workmanship of wood to work in all the work of the artificer. ");
INSERT INTO engoke_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","And be hath ingiven in his heart to teach also Ahaliab bar Achisamak, of the tribe of Dan, ");
INSERT INTO engoke_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","And hath filled them with wisdom of heart to make all the work of the carpenter, and artificer, and embroiderer, in hyacinth, and in purple, and in scarlet, and in fine linen, and the weaver, of (such as) do any work, and who teach the arts. ");
INSERT INTO engoke_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","And Bezalel and Ahaliab, with every man wise in heart, to whom the Lord had given wisdom and intelligence to know how to make each work for the service of the sanctuary, wrought (according) to all that the Lord had commanded. ");
INSERT INTO engoke_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","And Mosheh called Bezalel and Ahaliab, and every man wise in heart, to whose heart the Lord had given wisdom, everyone whose heart was led to draw near and do the work itself. ");
INSERT INTO engoke_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","And they took from Mosheh all the separation which the children of Israel had brought for the work of the service of the sanctuary to make it. And they still brought to him votive offerings from morning to morning. ");
INSERT INTO engoke_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","And all the wise men who wrought all the work of the sanctuary came, each man from his work which they had wrought. ");
INSERT INTO engoke_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","And they spake with Mosheh, saying, The people abound in bringing more than is needed for the work which the Lord hath commanded to make. ");
INSERT INTO engoke_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","And Mosheh ordered, and they made publication in the camp, saying, Let no man or woman make any more work of the separation for the sanctuary: and the people ceased to bring. ");
INSERT INTO engoke_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","For what had been done was sufficient for all the work to be wrought, and more than enough. ");
INSERT INTO engoke_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","And all the wise-hearted of them who did the work of the tabernacle made ten curtains of fine linen, and hyacinth, and purple, and crimson, (with) forms of kerubin the work of the embroiderer he made them. ");
INSERT INTO engoke_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of one curtain twenty and eight cubits, and the breadth of the curtain four cubits; there was one measure for all the curtains. ");
INSERT INTO engoke_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","And he conjoined five curtains one with another, and five curtains conjoined he one with another. ");
INSERT INTO engoke_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","And he made loopings of hyacinth upon the border of one curtain at the edge of the place of conjunction; so made he upon the border of the other curtain at the edge of the second place of conjunction. ");
INSERT INTO engoke_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fifty loopings he made on one curtain, and fifty loopings he made on the border of the second curtain at the place of conjunction: the loopings were arranged the one to correspond with the other. ");
INSERT INTO engoke_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","And he made fifty taches of gold, and conjoined the curtains one with another by the taches, and the tabernacle became one. ");
INSERT INTO engoke_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","And he made curtains of goat’s hair to spread over the tabernacle: eleven curtains made he them. ");
INSERT INTO engoke_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","The length of one curtain thirty cubits, and four cubits the breadth of one curtain; one measure had the eleven curtains. ");
INSERT INTO engoke_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","And he conjoined five curtains together, and six curtains together. ");
INSERT INTO engoke_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","And he made fifty loops upon the border of the curtain on the side of the conjunction, and fifty loops made be upon the side of the second curtain at the place of conjuncture. ");
INSERT INTO engoke_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Arid he made fifty taches of brass to conjoin the tabernacle, that it might be one. ");
INSERT INTO engoke_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","And be made the covering of the tabernacle of rams’ skins reddened, and a covering of purple skins above. ");
INSERT INTO engoke_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","And he made the boards of the tabernacle of sittin wood, standing. ");
INSERT INTO engoke_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ten cubits the length of a board, and a cubit and a half the breadth of one board. ");
INSERT INTO engoke_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Two tenons for one board corresponding one with the other; so made he for all the boards of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","And be made the boards of the tabernacle twenty boards on the side towards the south. ");
INSERT INTO engoke_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","And forty sockets of silver made he under the twenty boards, two sockets under one board for its two tenons, and two sockets under one board for its two tenons. ");
INSERT INTO engoke_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","And for the second side of the tabernacle toward the north he made twenty boards, ");
INSERT INTO engoke_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","And their forty sockets of silver; two sockets under one board, and two sockets under one board. ");
INSERT INTO engoke_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","And for the side of the tabernacle westward he made six boards; ");
INSERT INTO engoke_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","And two boards made he at the corners of the tabernacle at their extremities. ");
INSERT INTO engoke_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","And they were compacted in the lower part together, and compacted in their upper part by one ring; thus did he at both of the two corners. ");
INSERT INTO engoke_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","And there were eight boards, and their sockets of silver, sixteen sockets, two and two, under each board. ");
INSERT INTO engoke_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","And he made bars of sittin wood; five for the boards of one side of the tabernacle, ");
INSERT INTO engoke_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","and five bars for the boards of the second side of the tabernacle, and five bars for the extremity of the tabernacle, westward. ");
INSERT INTO engoke_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","And he made a middle bar to pass through, in the midst of the boards from end to end. ");
INSERT INTO engoke_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","And the boards he overlaid with gold, and their rings made he of gold (to be) places for the bars, and be covered the bars with gold. ");
INSERT INTO engoke_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","And he made the VEIL of hyacinth, and purple, and crimson, and fine linen; of the work of the embroiderer he made it, with forms of kerubin. ");
INSERT INTO engoke_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","And he made for it four pillars of sittin, and covered (them) with gold, and their books of gold, and cast for them four sockets of silver. ");
INSERT INTO engoke_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","And he made a curtain for the door of the tabernacle, of hyacinth, and purple, and crimson, and fine linen, the work of the embroiderer. ");
INSERT INTO engoke_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","And its five pillars and their hooks; and he overlaid their capitals, and covered them and their joining rods with gold, and their five bases (made he) of brass. ");
INSERT INTO engoke_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","And Bezalel made the ARK of sittin woods; two cubits and a half its length, and a cubit and a half its breadth, and a cubit and a half its height. ");
INSERT INTO engoke_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","And he covered it with pure gold within and without, and made for it a wreath of gold round about. ");
INSERT INTO engoke_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","And he cast for it four rings of gold upon its four corners, two rings on one of it, and two rings on the second side. ");
INSERT INTO engoke_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","And he made staves of sittin wood, and covered them with gold. ");
INSERT INTO engoke_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","And he introduced the staves into the rings on the sides of the ark, for carrying the ark. ");
INSERT INTO engoke_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","And he made the MERCY SEAT of pure gold; two cubits and a half its length, and a cubit and a half its breadth. ");
INSERT INTO engoke_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","And he made two kerubim, of beaten gold he made them, at the two sides of the mercy seat. ");
INSERT INTO engoke_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","One keruba on this side, and one keruba on that side of the mercy seat; he made the kerubaia from its two sides. ");
INSERT INTO engoke_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","And the kerubaia spread out their wings above, overshadowing the mercy seat with their wings; and their faces were one towards the other, over against the mercy seat were the faces of the kerubaia. ");
INSERT INTO engoke_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","And he made the TABLE of sittin woods; two cubits its length, and a cubit its breadth, and a cubit and a half its height. ");
INSERT INTO engoke_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","And he covered it with pure gold, and made for it a golden crown round about, ");
INSERT INTO engoke_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","And made for it a rim its height a span, round about; and he made a crown of gold for its rim round about. ");
INSERT INTO engoke_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","And he cast for it four golden rings, and set the rings upon the four corners of its four feet. ");
INSERT INTO engoke_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Over against the rim were the rings to be the place of the staves for carrying the table. ");
INSERT INTO engoke_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","no translation ");
INSERT INTO engoke_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","And he made the vessels which were to be upon the table; its dishes, and its vases, and its measures, and the cups with which (the libations) are outpoured, of pure gold. ");
INSERT INTO engoke_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","And he made the CANDELABRUM of pure gold, beaten made he the candelabrum, its rest, its shaft, its cups, its apples, and its lilies were of the same. ");
INSERT INTO engoke_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","And six branchlets proceeded from its sides; three branchlets of the candelabrum on one side, and three branchlets of the candelabrum on the second side. ");
INSERT INTO engoke_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Three cups figurated on one branchlet, an apple, and a lily: so the six branchlets which proceeded from the candelabrum. ");
INSERT INTO engoke_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","And on the candelabrum four cups figurated, its apples and its lilies. ");
INSERT INTO engoke_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","An apple under two branchlets of the same, and an apple under two branchlets of the same, and an apple under two branchlets of the same, for the six branchlets that proceeded from it. ");
INSERT INTO engoke_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Their apples and their branches were of the same, all of one beaten work of pure gold. ");
INSERT INTO engoke_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","And he made its seven lamps, and its snuffers, and its receivers of pure gold; ");
INSERT INTO engoke_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","of a talent of pure gold made he, it, and all its vessels. ");
INSERT INTO engoke_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","And he made the ALTAR OF SWEET INCENSE of sittin wood; its length a cubit, and a cubit its breadth, foursquare. And two cubits the height of it; of the same were its horns. ");
INSERT INTO engoke_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","And he overlaid it with pure gold, its top and its sides round about, and its horns: and he made for it a golden crown round about. ");
INSERT INTO engoke_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","And two rings of gold made he for it under its crown, upon its two sides, the place for the staves by which to carry it. ");
INSERT INTO engoke_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","And he made the staves of sittin wood, and overlaid them with gold. ");
INSERT INTO engoke_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","And he made the oil for holy anointment, and the pure sweet incense, the work of the perfumer. ");
INSERT INTO engoke_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","And be made the ALTAR OF BURNT OFFERING of sittin wood; five cubits its length, and five cubits its breadth, four-square, and three cubits its height. ");
INSERT INTO engoke_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","And he made its horns upon its four corners, of the same were its horns, and he coated it with brass. ");
INSERT INTO engoke_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","And he made all the vessels of the altar, the caldrons, and the cleaners, and the basins, and the fleshhooks, and the receivers; all its vessels made he of brass. ");
INSERT INTO engoke_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","And he made for the altar a brasen grate of network, under its border beneath, (reaching) unto its middle. ");
INSERT INTO engoke_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","And he cast four rings for the four corners of the brasen grate, the place for the staves. ");
INSERT INTO engoke_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","And he made the staves of sittin wood, and overlaid them with brass. ");
INSERT INTO engoke_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","And he put the staves into the rings upon the sides of the altar by which to carry it; hollow with boards he made it. ");
INSERT INTO engoke_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","And be made the LAVER of brass, and its base of brass, of the mirrors of the women who come to pray at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","And he made the court, the southern side of which was of hangings for the court, of fine linen twined, of a hundred cubits; ");
INSERT INTO engoke_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Their pillars twenty, and their sockets twenty, of brass; the hooks, pillars, and their uniting rods of silver. ");
INSERT INTO engoke_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","And for the northern side (hangings) of a hundred cubits, their pillars twenty, and their sockets twenty, of brass; the hooks of the pillars and their uniting rods of silver. ");
INSERT INTO engoke_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","And for the western side, curtains, fifty cubits; their pillars ten, and their sockets ten; the hooks of the pillars and their uniting rods of silver. ");
INSERT INTO engoke_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","And on the eastern side, eastward, fifty cubits. ");
INSERT INTO engoke_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The hangings fifteen cubits on (one) side (of the gate), their pillars three, and their bases three. ");
INSERT INTO engoke_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","And on the second side of the gate of the court, here and there, hangings, fifteen cubits; their pillars three, and their bases three. ");
INSERT INTO engoke_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings of the court round about were of fine linen twined. ");
INSERT INTO engoke_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","And the bases of the pillars were of brass, the hooks, pillars, and their uniting rods of silver, and the overlaying of their heads was of silver, and there were uniting rods of silver for all the pillars of the court. ");
INSERT INTO engoke_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","And the veil for the gate of the court was the work of the embroiderer, hyacinth, and purple, and crimson, and fine linen; and twenty cubits was its length, and the height, in the breadth five cubits, according (to the height of) the curtains of the court. ");
INSERT INTO engoke_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","And their pillars four, and their bases four, of brass, and their hooks silver, and the overlaying of their head and their uniting rods, silver. ");
INSERT INTO engoke_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","And all the pins of the tabernacle, and of the court round about, were of brass. ");
INSERT INTO engoke_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","These are the admeasurements of the Tabernacle, the Tabernacle of the Testimony, as they were numbered upon the word of Mosheh: the service of the Levites by the hand of Ithamar bar Aharon the priest. ");
INSERT INTO engoke_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","And Bezalel bar Uri bar Hur of the tribe of Jehudah made all that the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","And with him Ahaliab bar Achisamak, of the tribe of Dan, a woodworker, and artificer, and embroiderer in hyacinth, and in purple, and in crimson, and in fine linen. ");
INSERT INTO engoke_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","And all the gold which was used in making all the work of the sanctuary, and which had been a separation (thereunto), was twenty and nine talents, and seven hundred and thirty shekels, of the shekels of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","And the silver of the numbered ones of the congregation was a hundred talents, and a thousand and seven hundred and seventy and five shekels, in the shekels of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","The weight was (appointed) by capitation; a half shekel, in the shekel of the sanctuary, for everyone who passed to the adnumberments from twenty years (old) and upward, for six hundred and three thousand and five hundred and fifty men. ");
INSERT INTO engoke_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","And the hundred talents of silver were for casting the bases of the sanctuary, and the bases of the veil (or tent), a hundred bases with a hundred talents, a talent for a base. ");
INSERT INTO engoke_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","And with the thousand and seven hundred and seventy and five (shekels) he made the hooks for the pillars, and covered their capitals, and made their uniting rods. ");
INSERT INTO engoke_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","And the brass of the oblation was seventy talents, and two thousand and four hundred shekels. ");
INSERT INTO engoke_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","And with it he made the bases of the door of the Tabernacle of Ordinance, and the altar of brass, and the brasen grate which pertained to it, and all the vessels of the altar; ");
INSERT INTO engoke_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","And the bases of the court round about, and the bases of the door of the court, and all the pins of the tabernacle, and all the pins of the court round about. ");
INSERT INTO engoke_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","And of the hyacinth, and purple, and crimson, they made the vestments of ministration to minister in the sanctuary, and they made the holy vestments of Aharon, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","And he made the ephoda of gold, hyacinth, and purple, and crimson, and fine linen twined. ");
INSERT INTO engoke_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","And they beat out the plates of gold, and cut (them) into threads, to insert into the hyacinth, and the purple, and the crimson, and the fine linen, the work of the artificer. ");
INSERT INTO engoke_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Shoulder-pieces made they for it, conjoined; at the two sides were they conjoined. ");
INSERT INTO engoke_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","And the band of its fastening which is upon it was of the same according to its work, of gold, hyacinth, and purple, and crimson, and fine linen twined, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","And they wrought the onyx stones, inset in sockets of gold, engraven in distinct writing, with the names of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","And he set them upon the shoulders of the ephoda, stones of memorial of the sons of Israel, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","And he made the BREASTPLATE (chushena), the work of the artificer, according to the work of the ephoda, of gold, hyacinth, and purple, and crimson, and fine linen twined. ");
INSERT INTO engoke_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Foursquare was it, doubled made they the breastplate; a span its length, and a span its breadth, doubled. ");
INSERT INTO engoke_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","And they filled it with four rows of precious stones: the first row carnelian, topaz, and carbuncle, row one; ");
INSERT INTO engoke_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","The second row, smaragud, sapphire, and emerald; ");
INSERT INTO engoke_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","And the third row, jacinth, agate, and amethyst; ");
INSERT INTO engoke_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","And the fourth row, chrysolite, beryl, and jasper: they were set in sockets of gold, in their infillings. ");
INSERT INTO engoke_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","And the stones were according to the names of the sons of Israel, twelve, according to their names, written distinctly, as the engraving of a ring, each according to his name for the twelve tribes. ");
INSERT INTO engoke_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","And they made upon the breastplate chains enwreathed, a work of braiding, of pure gold. ");
INSERT INTO engoke_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","And they made two sockets of gold, and two golden rings, and put the two rings upon the two sides of the breastplate. ");
INSERT INTO engoke_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","And they put the two golden wreaths upon the two rings upon the sides of the breastplate, ");
INSERT INTO engoke_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","and the two wreaths which were upon the two sides they put upon the two sockets, and set them upon the shoulders of the ephoda towards its face. ");
INSERT INTO engoke_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","And they made two rings of gold, and set them on the two sides of the breastplate, upon its edge which was on the side of the ephoda inward. ");
INSERT INTO engoke_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","And they made two golden rings, and set them on the two shoulders of the ephoda underneath towards its front, toward the place of its conjoinment, above the band of the ephoda. ");
INSERT INTO engoke_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","And they adunited the breastplate by its rings to the rings of the ephoda, by a ribbon of hyacinth, to be upon the band of the ephoda, that the breastplate might not be loosened from the ephoda, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","And he made the ROBE of the ephoda, the work of the embroiderer, altogether of hyacinth. ");
INSERT INTO engoke_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","And the opening (mouth) of the robe in the middle of it like the opening of a corslet, with a binding going about its border, that it might not be torn. ");
INSERT INTO engoke_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","And they made upon the hem of the robe pomegranates of hyacinth and purple and crimson inwoven. ");
INSERT INTO engoke_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","And they made bells of pure gold, and set the bells among the pomegranates upon the hem of the robe round about among the pomegranates. ");
INSERT INTO engoke_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","A bell and a pomegranate, a bell and a pomegranate, upon the hem of the robe round about, to minister, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","And they made the tunics of fine linen, the work of the weaver, for Aharon and for his sons. ");
INSERT INTO engoke_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","And the tiara of fine linen, and the mitres of beauty of fine linen; and the drawers of linen, of fine linen twined. ");
INSERT INTO engoke_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","And the girdle of fine linen twined, and hyacinth and purple and crimson, the work of the embroiderer, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","And they made the plate of the diadem of holiness of pure gold, and wrote upon it as the engraving of a ring in distinct writing, HOLINESS UNTO THE LORD. ");
INSERT INTO engoke_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","And they put upon it a ribbon of hyacinth, that it might be upon the tiara above, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Arid completed was all the work of the tabernacle, the tabernacle of ordinance; and the sons of Israel did according to all that the Lord had commanded Mosheh, so did they. ");
INSERT INTO engoke_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","And they brought the tabernacle to Mosheh, the tabernacle and all its vessels, its taches, its boards, its bars, and its pillars, and its bases. ");
INSERT INTO engoke_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","And the covering of rams’ skins reddened, and the covering of purple skins, and the veil for the hanging; ");
INSERT INTO engoke_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","And the ark of the testimony and its staves, and the mercy seat; ");
INSERT INTO engoke_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","The table and all its vessels, and the bread of the Presence; ");
INSERT INTO engoke_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","The pure candelabrum and its lamps, the lamps of order, and all its vessels; and the oil for the light ");
INSERT INTO engoke_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","And the golden altar, and the oil of consecration, and the sweet incense; and the hanging for the door of the tabernacle; ");
INSERT INTO engoke_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","And the brasen altar and the brasen grate for it; its staves and all its vessels; and the laver and its base, ");
INSERT INTO engoke_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the hangings of the court, its pillars, and its sockets, and the veil for the gate of the court, its cords, and its pins, and all the vessels of the service of the tabernacle, for the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","The vestments of ministration to minister in the sanctuary, and the holy vestments of Aharon the priest, and the vestments of his sons to minister: ");
INSERT INTO engoke_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","According to all that the Lord commanded Mosheh, so made the sons of Israel all the service. ");
INSERT INTO engoke_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","And Mosheh surveyed all the work, and, behold, they had done it as the Lord had commanded, so had they done; and Mosheh blessed them. ");
INSERT INTO engoke_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","In the day of the first month, in the first of the month, thou shalt uprear the tabernacle, the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","And thou shalt set there the ark of the testimony, and outspread the veil before the ark; ");
INSERT INTO engoke_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","And thou shalt bring in the table, and arrange the order thereof. And thou shalt bring in the candelabrum, and kindle its lamps. ");
INSERT INTO engoke_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","And thou shalt put the golden altar of sweet incense before the ark of the testimony, and set the veil of the door of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","And thou shalt put the altar of burnt offering before the door of the tabernacle, the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","And thou shalt place the laver between the tabernacle of ordinance and the altar, and put water therein. ");
INSERT INTO engoke_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","And thou shalt set the court round about, and put the hanging at the gate of the court. ");
INSERT INTO engoke_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","And thou shalt take the oil of consecration, and anoint the tabernacle and all that is therein, and sanctify it, and all its vessels, and it shall be holy. ");
INSERT INTO engoke_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","And thou shalt anoint the altar of burnt offering, and all its vessels, and sanctify the altar; and it shall be an altar most holy. ");
INSERT INTO engoke_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","And thou shalt anoint the laver and its base, and sanctify it. ");
INSERT INTO engoke_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","And thou shalt bring Aharon and his sons to the door of the tabernacle of ordinance, and lave them with water, ");
INSERT INTO engoke_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","and shalt clothe Aharon with the holy vestments, and anoint him, and consecrate him, that he may minister before Me. ");
INSERT INTO engoke_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","And thou shalt bring his sons and clothe them with the tunics, ");
INSERT INTO engoke_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","And consecrate them, as thou didst consecrate their father, that they may minister before Me, and that it may be to them the consecration of a perpetual priesthood in their generations. ");
INSERT INTO engoke_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","And Mosheh did according to all which the Lord commanded, so did he. ");
INSERT INTO engoke_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","And it was in the first month, in the second year, on the first of the month, that the tabernacle was reared. ");
INSERT INTO engoke_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","And Mosheh reared the tabernacle, and placed its bases, and set its boards, and fixed its bars, and reared its pillars; ");
INSERT INTO engoke_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Arid he spread the tent upon the tabernacle, and set the covering of the tabernacle over it, above, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","And he took and placed the testimony in the ark, and set the staves upon the ark, and placed the mercy seat upon the ark above. ");
INSERT INTO engoke_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","And he brought the ark into the tabernacle, and placed the veil which was spread to overshadow the ark of the testimony, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","And he placed the table in the tabernacle of ordinance upon the side of the tabernacle northward without the veil. ");
INSERT INTO engoke_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","And he set in order upon it the rows of bread before the Lord, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","And he set the candelabrum in the tabernacle of ordinance over against the table on the side of the tabernacle southward. ");
INSERT INTO engoke_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","And he kindled the lamps before the Lord, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","And he set the golden altar in the tabernacle of ordinance before the veil, ");
INSERT INTO engoke_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and burned thereon sweet incense, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","And he set the hanging of the door of the tabernacle, ");
INSERT INTO engoke_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","and the altar of burnt offering set he at the door of the tabernacle of ordinance, and offered upon it the burnt offering, and the oblation, (mincha,) as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","And he set the laver between the tabernacle of ordinance and the altar, and put water therein for purifying. ");
INSERT INTO engoke_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","And Mosheh and Aharon and his sons purified with it their hands and their feet. ");
INSERT INTO engoke_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","In their going into the tabernacle of ordinance and in their approachment to the altar, they purified (themselves), as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And he set up the court, round about the tabernacle and the altar, and set the hanging of the gate of the court: and Mosheh completed the work. ");
INSERT INTO engoke_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","And the Cloud covered the tabernacle of ordinance, and the Glory of the Lord filled the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","And Mosheh was not able to enter into the tabernacle of ordinance, because the Cloud abode upon it, and the Glory of the Lord filled the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","And when the Cloud ascended above the tabernacle, the sons of Israel went forward in all their journeys. ");
INSERT INTO engoke_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","And if the Cloud did not ascend, they did not proceed, until the day of its uprising. ");
INSERT INTO engoke_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the Cloud of the Glory of the Lord was upon the tabernacle by day, and the vision of fire was in it by night, in the eyes of all the house of Israel in all their journeys. ");
INSERT INTO engoke_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","And the Lord called unto Mosheh, and the Lord spake with him from the tabernacle of ordinance, saying: ");
INSERT INTO engoke_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Speak with the sons of Israel, and say to them: When one of you will bring an offering before the Lord of the cattle, of oxen or of sheep, you shall offer your oblations. ");
INSERT INTO engoke_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If his oblation be a burnt offering of the oxen, (it shall be) a male, unblemished; he shall offer him at the door of the tabernacle of ordinance; he shall offer him for acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","And he shall lay his hand upon the head of the burnt offering, that it may be acceptable for him to propitiate on his behalf. ");
INSERT INTO engoke_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","And he shall sacrifice the young bullock before the Lord; and the sons of Aharon the priest shall bring the blood, and sprinkle the blood round about upon the altar which is at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","And he shall take away (the skin) of the burnt offering, and divide it, by its members. ");
INSERT INTO engoke_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","And the sons of Aharon the priest shall put fire upon the altar, and lay the wood in order upon the fire. ");
INSERT INTO engoke_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","And the priests, the sons of Aharon, shall arrange the limbs and the head and the fat on the wood upon the fire which is on the altar. ");
INSERT INTO engoke_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","But his inwards and his legs he shall wash with water; and the priest shall burn the whole upon the altar an entire burnt offering, an oblation to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","And if his oblation be from the flock, of the sheep or the young of the goats for a burnt offering, he shall bring a perfect male. ");
INSERT INTO engoke_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","And he shall sacrifice him at the north side of the altar before the Lord; and the priests the sons of Aharon shall sprinkle his blood round about upon the altar. ");
INSERT INTO engoke_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","And he shall divide him by his members, and his head and his feet; and the priest shall lay them upon the wood which is on the fire upon the altar. ");
INSERT INTO engoke_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","But the inwards and the legs he shall wash with water, and the priest shall bring the whole and burn (it) upon the altar: it is a whole burnt offering, an oblation to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","But if the burnt offering of his oblation before the Lord be from fowl, he shall bring his oblation from the turtles or the young of a pigeon. ");
INSERT INTO engoke_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","And the priest shall offer it upon the altar, and pour its blood by the side of the altar: ");
INSERT INTO engoke_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","And he shall remove its crop with its food, and throw it on the east side of the altar, at the place where they empty the ashes. ");
INSERT INTO engoke_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","And he shall cleave it through its wings, (but) divide (it) not; and the priest shall burn it at the altar upon the wood that is on the fire: it is a burnt offering, an oblation that shall be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","But if a man bring an oblation of a mincha before the Lord, his oblation shall be of meal, and he shall pour oil upon it, and put frankincense thereon, ");
INSERT INTO engoke_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","And bring it to the priests the sons of Aharon; and the priest shall take from it his handful of the meal with its oil, and all its frankincense, and burn the memorial of it at the altar; an oblation to be received with favour before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","And that which remaineth of the mincha shall be Aharon’s and his sons’; it is most holy among the oblations of the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","And when thou bringest the oblation of a minch baked in the oven, it shall be of meal cake unleavened, mingled with oil, with unleavened wafers anointed with oil. ");
INSERT INTO engoke_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","And if the mincha be (prepared) in a pan, thy oblation shall be of meal mingled with oil; unleavened shall it be. ");
INSERT INTO engoke_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","And thou shalt break it in pieces, and pour oil thereon; it is a mincha. ");
INSERT INTO engoke_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","But if thy oblation be a mincha from the gridiron, thou shalt make it of meal with oil. ");
INSERT INTO engoke_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","And the mincha which is made of these thou shalt bring before the Lord, and present it to the priest, and he will offer it at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","And the priest shall separate its memorial from the mincha, and burn upon the altar an oblation to be received with favour before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","And that which remaineth of the mincha shall be Aharon’s and his sons’: it is most holy among the oblations of the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No mincha which you offer before the Lord may be made with leaven; for no leaven or honey shall you burn with any oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","In the oblation of firstfruits you may offer them before the Lord, but not burn them at the altar, that they may be accepted with favour. ");
INSERT INTO engoke_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","And every offering of thy mincha thou shalt salt with salt; and thou mayest not withhold the slat of the covenant of thy God from upon thy mincha; upon every oblation thou shalt offer salt. ");
INSERT INTO engoke_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","And when thou offerest the mincha of firstfruits before the Lord, green ears dried with fire, broken and soft, shalt thou offer as the mincha of thy firstfruits. ");
INSERT INTO engoke_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","And thou shalt put oil on it, and lay frankincense thereon: it is a mincha; ");
INSERT INTO engoke_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","And the priest shall burn its memorial of its broken grain and of its oil with all frankincense, an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","And if his oblation be a victim of the sanctified things; if from oxen, whether male or female, he shall offer it perfect before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","And he shall lay his hand upon the head of his oblation at the door of the tabernacle of ordinance; and the priests the sons of Aharon shall sprinkle the blood round about upon the altar. ");
INSERT INTO engoke_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","And the oblation of the sacred victim the fat that covereth the inwards, even all the fat that is upon the inwards, ");
INSERT INTO engoke_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","And the two kidneys and the fat which is upon them on the sides, and the caul that is upon the liver with the kidneys, he shall remove. ");
INSERT INTO engoke_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","And the sons of Aharon shall burn it at the altar, with the burnt offering which is on the wood upon the fire, an oblation to be received with grace before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","But if his oblation of a consecrated victim before the Lord be from the flock, whether male or female, he shall offer it perfect. ");
INSERT INTO engoke_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If his oblation be a lamb, he shall present it before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","and lay his hand upon the head of his oblation, and slay it before the tabernacle of ordinance; and the sons of Aharon shall sprinkle its blood upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","And of his oblation of the consecrated victim before the Lord, its fat, the entire tail close by the backbone, he shall remove; the fat which covereth the inwards, even all the fat which is upon the inwards, and the two kidneys and the fat which is upon the inwards, ");
INSERT INTO engoke_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","And the two kidneys and the fat which is upon them upon the sides, and the caul that is over the liver, with the kidneys, he shall take away; ");
INSERT INTO engoke_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","And the priest shall burn it at the altar; it is the meat (lechem, bread) of an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","But if his oblation be from the young goats, he shall present it before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","and lay his hand upon its head, and slay it before the tabernacle of ordinance; and the sons of Aharon shall sprinkle its blood upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","And of his oblation he shall offer as an oblation before the Lord the fat which covereth the inwards, and all the fat which is upon the inwards, ");
INSERT INTO engoke_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","And the two kidneys, and the fat which is upon them on the sides; but the caul that is over the liver with the kidneys he shall take away. ");
INSERT INTO engoke_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","And the priest shall burn them at the altar: it is the meat of an oblation to be received with acceptance; all the fat (shall be offered) before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","It is an everlasting statute unto your generations, and in all your dwellings, that neither the fat nor the blood shall be eaten. ");
INSERT INTO engoke_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Speak with the sons of Israel, saying: When a man sinneth through ignorance of any of the precepts of the Lord, as to that which should not be done, and acteth contrary to one of them: ");
INSERT INTO engoke_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If the high priest sin after the manner of the people’s sin, let him bring before the Lord for the sin that he hath sinned a young bullock without blemish for his sin. ");
INSERT INTO engoke_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","And he shall bring the bullock to the door of the tabernacle of ordinance before the Lord, and lay his hand upon the bullock’s head, and slay the bullock before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","And the high priest shall take of the blood of the bullock and carry it into the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","And the priest shall dip his finger in the blood, and sprinkle (some) of the blood seven times in the presence of the Lord before the veil of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","And the priest shall put some of the blood upon the horns of the altar of sweet incense before the Lord in the tabernacle of ordinance, and all the (remaining) blood of the bullock he shall pour out at the foundation of the altar of burnt sacrifice which is at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","And all the fat of the bullock of the sin offering he shall separate from it; the fat which covereth the inwards, and all the fat which is upon the inwards, ");
INSERT INTO engoke_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","And the two kidneys, and the fat which is upon them that is by the flanks; and the caul that is upon the liver, together with the kidneys, he shall remove, ");
INSERT INTO engoke_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","as it was separated from the bullock of the consecrated victims, and the priest shall offer it upon the altar of burnt sacrifice. ");
INSERT INTO engoke_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","But the skin of the bullock and all his flesh, with his head, and with his legs, and his inwards, and his food, ");
INSERT INTO engoke_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","he shall carry forth, even the whole bullock, without the camp unto a clean place, to a place for the pouring out of ashes, and burn him upon wood in the fire; at the place for the pouring out of ashes shall he be burned. ");
INSERT INTO engoke_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","And if the whole congregation (kenishta) of Israel shall mistake, and the thing be hid form the eyes of the assembly, (kehala), and they shall have done (somewhat against) one of all the commandments of the Lord which it is not right to do, and have become guilty; ");
INSERT INTO engoke_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When the sin that they have sinned is known, the assembly shall offer a young bullock for a sin offering, and bring him before the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","And the elders of the congregation shall lay their hands upon the head of the bullock in the presence of the Lord, and kill the bullock before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","And the high priest shall bring of the blood of the bullock into the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","And the priest shall dip his finger in the blood, and sprinkle seven times in the presence of the Lord before the veil. ");
INSERT INTO engoke_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","And some of the blood he shall put upon the horns of the altar that is before the Lord in the tabernacle of ordinance, and all (the rest of the) blood he shall pour out at the foundation of the altar of burnt sacrifice which is at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","And all the fat he shall separate from him, and sacrifice at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","And he shall do with the bullock as he did with the bullock of the sin offering, so shall he do with him; and the priest shall atone for them, and it shall be forgiven them. ");
INSERT INTO engoke_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","And he shall carry forth the bullock without the camp, and burn him as he burned the former bullock: it is a sin offering for the congregation. ");
INSERT INTO engoke_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Should a ruler sin and do (contrary to) any of the commandments of the Lord his God what is not right to do, through ignorance, and be guilty; ");
INSERT INTO engoke_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","When his sin becomes known to him in what he hath transgressed, he shall bring his oblation, a kid of the goats, a male, unblemished; ");
INSERT INTO engoke_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","And he shall lay his hand upon the head of the goat, and kill him at the place where the burnt sacrifice is slain before the Lord; it is a sin offering. ");
INSERT INTO engoke_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","And the priest shall take of the blood of the sin offering with his finger, and put it upon the horns of the altar of burnt sacrifice, and pour out the blood at the foundation of the altar of burnt sacrifice. ");
INSERT INTO engoke_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","And he shall burn all the fat at the altar, as the fat of the sanctified oblation (is burned); and the priest shall atone on his behalf for his sin, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","And if one of the people of the land inadvertently sin in doing contrary to any of the commandments of the Lord what is not right to do, and become guilty; ");
INSERT INTO engoke_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","When his sin is known to him, in what he hath sinned, he shall bring his oblation, a female kid of the goats, unblemished, for the sin that he hath sinned. ");
INSERT INTO engoke_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","And he shall lay his hand on the lead of the sin offering, and kill the sin offering at the place of burnt sacrifice; ");
INSERT INTO engoke_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","And the priest shall take of the blood with his finger, and put it upon the horns of the altar of burnt offering, and pour out all the blood at the foundation of the altar. ");
INSERT INTO engoke_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","And he shall remove all the fat, as he took away the fat from the consecrated offerings, and the priest shall burn it at the altar, to be received with acceptance before the Lord; and the priest shall atone for him, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","But if he present a lamb for his sin offering, he shall bring a female unblemished, ");
INSERT INTO engoke_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","and lay his hand upon the head of the sin offering, and kill the sin offering at the place where the burnt sacrifice is killed. ");
INSERT INTO engoke_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","And the priest shall take of the blood of the sin offering with his finger, and put it upon the horns of the altar of burnt sacrifice, and pour out all the blood at the foundation of the altar. ");
INSERT INTO engoke_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","And he shall remove all the fat, as he removed the fat of the lamb of the sanctified oblations, and the priest shall burn it at the altar with the oblations of the Lord; and the priest shall atone for him, for the sin that he hath sinned, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","And if a man sin, and (one) hear the voice (which demands) swearing that he is a witness, or that he hath seen or known, if he will not show it, he shall bear his sin. ");
INSERT INTO engoke_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Or if a man shall have touched anything unclean, whether the carcase of an unclean beast, or the carcase of unclean cattle, or the carcase of an unclean reptile, and it be hidden from him, he shall be defiled and guilty. ");
INSERT INTO engoke_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Or if he shall touch the uncleanness of a man, any uncleanness which defileth him, and it be hidden from him; but (afterwards) becometh aware of it and is guilty; ");
INSERT INTO engoke_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Or if a man swear, declaring with his lips, for evil or for good, according to whatever the man shall declare by oath, and (the truth) be hidden from him, and he (afterwards) have knowledge thereof, he is guilty of one of these. ");
INSERT INTO engoke_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","And it shall be that when (he knoweth that) he is guilty in one of these (things) he shall confess that he hath sinned thereby; ");
INSERT INTO engoke_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","And shall bring his sin offering before the Lord for the sin that he hath sinned; a she-lamb from the flock, or a kid of the goats, for a sin offering; and the priest shall atone for him and for his sin. ");
INSERT INTO engoke_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","But if his hands be not sufficient to offer a lamb, let him bring for the sin that he hath sinned two turtle doves, or two young pigeons before the Lord, one for the sin offering, and one for the burnt sacrifice. ");
INSERT INTO engoke_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","And he shall bring them to the priest, and he shall offer the sin offering first, and wring off its head near to the spine, but he shall not divide (the bird). ");
INSERT INTO engoke_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","And he shall sprinkle the blood of the sin offering upon the side (wall) of the altar, and pour out the remainder of the blood at the base of the altar; it is a sin offering. ");
INSERT INTO engoke_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","And the second he shall make a burnt sacrifice, according to the proper (rite); and the priest shall make atonement for the sin that he hath sinned, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","But if (neither) two turtle doves nor a pair of young pigeons pertain to him, he shall bring, as his oblation for the sin that he hath sinned, the tenth of three sein of flour for a sin offering; he shall not put oil upon it, nor put frankincense upon it, for it is a sin offering. ");
INSERT INTO engoke_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","And he shall bring it to the priest, and the priest shall take a handful of it as the memorial thereof, and burn it at the altar with the oblations of the Lord: it is a sin offering. ");
INSERT INTO engoke_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","And the priest shall make atonement for him, for the sin that he hath sinned in anyone of these (things), and it shall be forgiven him: and to the priest it shall be, as the mincha. ");
INSERT INTO engoke_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","When a man hath indeed falsified, but hath sinned inadvertently concerning things consecrated to the Lord, he shall bring for his trespass offering before the Lord a ram without blemish from the flock by its value in silver shekels, in the shekel of the sanctuary, for a trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","And that which he had defaulted of the holy thing he shall make good, and add a fifth thereupon, and give it to the priest; and the priest shall make atonement for him with the ram of the trespass offering, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","And if a man sin and do against any of the commandments of the Lord that which is not right to do, and know not, and sin, he shall bear his sin. ");
INSERT INTO engoke_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","But he shall bring a lamb unblemished form the flock according to the estimation for a trespass offering (or according to the estimation of the trespass) unto the priest; and the priest shall atone for his error which he hath committed unwittingly, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a trepass offering for the sin that he hath sinned; he shall offer the trespass offering before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","If a man sin and falsify with falsehood before the Lord, and deal falsely with his neighbour in a thing deposited, or in fellowship of hands, or by rapine or violence against his neighbour; ");
INSERT INTO engoke_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","Or if he have found that which had been lost and deny it, and swear falsely, by anyone of all these which a man doeth and sinneth therein; ");
INSERT INTO engoke_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","It shall be that when he hath (so) transgressed and become guilty, he shall return what he hath robbed by robbery, or taken away by violence, or the deposit which was deposited with him, or the lost thing that he had found: ");
INSERT INTO engoke_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Or all that about which he had sworn falsely, he shall make it good in the capital, and add one fifth thereon; unto him to whom it belongeth shall he give it on the day of his (offering for) guilt. ");
INSERT INTO engoke_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","And the trespass offering that he shall bring before the Lord (must be) a ram unblemished form the flock according to the estimation of the trespass, unto the priest. ");
INSERT INTO engoke_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","And the priest shall make atonement for him before the Lord, and it shall be forgiven him for anyone of all (these) in which he may have acted to be guilty thereby. ");
INSERT INTO engoke_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Instruct Aharon and his sons, saying: This is the law of the Burnt Offering. It is burnt offering, because burned upon the altar all night until morning, and the fire of the altar shall be burning in it. ");
INSERT INTO engoke_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","And the priest shall dress himself with the vestments of linen, and wear drawers of linen upon his flesh; and he shall separate the ashes which the fire hath consumed with the burnt offering upon the altar, and set them beside the altar. ");
INSERT INTO engoke_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","And he shall take off his vestments, and dress himself with other garments, and carry forth the ashes without the camp unto a clean place. ");
INSERT INTO engoke_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","But the fire upon the altar shall be burning on it, and never be extinguished; and the priest shall burn wood on it from morning to morning, and lay the burnt offering in order upon it, and burn upon it the fat of the sanctified oblations. ");
INSERT INTO engoke_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","The fire shall be ever burning on the altar, it shall not be extinguished. ");
INSERT INTO engoke_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","And this is the law of the Mincha which the sons of Aharon shall offer in the presence of the Lord before the altar. ");
INSERT INTO engoke_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","And he shall separate therefrom his handful lof the flour of the mincha and of its oil, and all the frankincense that is upon the mincha, and burn it at the altar as its memorial to be accepted with favour before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","And the remainder of it may Aharon and his sons eat, unleavened shall it be eaten in the holy place, in the court of the tabernacle of ordinance shall they eat it. ");
INSERT INTO engoke_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","It shall not be baked with leaven. I have given it as their portion of my oblations; it is most sacred, as the sin offering and as the trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","All the males of the children of Aharon may eat it. (This) is an everlasting statute for your generations concerning the oblations of the Lord: everyone who toucheth them shall be holy. ");
INSERT INTO engoke_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","This is the oblation of Aharon and his sons which they shall present before the Lord on the day when they anoint him. The tenth of three seahs of flour for a mincha perpetually, a half in the morning, and a half at eventide. ");
INSERT INTO engoke_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","It shall be made in a pan with oil; while soft it shall be brought a baken mincha offered in pieces to be accepted with favour before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","And of his sons, the priest who shall be anointed in his stead shall perform it. (This is) an everlasting statute before the Lord: ");
INSERT INTO engoke_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","It shall be burned entirely, and every mincha of the priest shall be entirely (burned); it is not to be eaten. ");
INSERT INTO engoke_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Speak with Aharon and with his sons, saying, This is the law of the sin offering: In the place where the burnt offering is killed, there shall the sin offering be killed before the Lord; it is most sacred. ");
INSERT INTO engoke_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","The priest who maketh atonement with its blood shall eat it; in the holy place it shall be eaten, in the court of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Everyone who toucheth the flesh thereof must be holy. And if he drop some of its blood upon a vestment, that which is bedropped shall be purified in the holy place. ");
INSERT INTO engoke_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","But the earthen vessel in which it was sodden shall be broken; and if it be sodden in a vessel of brass, (that) shall be scoured and washed in water. ");
INSERT INTO engoke_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Any man of the priests may eat thereof: it is most sacred. ");
INSERT INTO engoke_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","But no sin offering whose blood is brought into the tabernacle of ordinance to make atonement in the sanctuary may be eaten, but shall be burned with fire. ");
INSERT INTO engoke_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","And this is the law of the Trespass Offering; it is most holy. ");
INSERT INTO engoke_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","In the place where they kill the burnt offering, there shall they kill the trespass offering and sprinkle its blood round about; ");
INSERT INTO engoke_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","And all the fat of it shall be offered, with the tail and the fat which covereth the inwards. ");
INSERT INTO engoke_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","And the two kidneys and the fat which is upon them, upon the inwards, and the caul that is upon the liver, with the kidneys, he shall take away. ");
INSERT INTO engoke_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","And the priest shall burn them at the altar, an oblation before the Lord; it is a trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every man of the priests may eat thereof in the holy place; it is most sacred. ");
INSERT INTO engoke_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","As the sin offering, so the trespass offering; they have one law; to the priest who maketh atonement therewith shall it be. ");
INSERT INTO engoke_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","And when the priest offereth a man’s burnt sacrifice, the skin of the sacrifice that he priest offereth shall be his. ");
INSERT INTO engoke_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","And every mincha that is baken in the oven, or made in the pan, or upon the baking pan, to the priest who offereth it shall it belong. ");
INSERT INTO engoke_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","And every mincha sprinkled with oil, and that which is not sprinkled, shall belong to all the sons of Aharon, to the one man as to his brother. ");
INSERT INTO engoke_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","And this is the law of the Sanctified Oblations which he shall offer before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If he present it as a thanksgiving, he shall offer as the sacrifice of the thanksgiving unleavened cakes sprinkled with oil, and unleavened wafers anointed with oil, and baken biscuits of flour sprinkled with oil. ");
INSERT INTO engoke_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","With the cakes he may offer his oblation of leavened bread for his sanctified oblation of thanksgiving. ");
INSERT INTO engoke_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","And of it he shall offer one of all the separated oblatons before the Lord: (the remainder) shall belong to the priest who sprinkleth the blood of the sanctified oblations. ");
INSERT INTO engoke_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","And the flesh of his consecrated thank-offering shall be eaten on the day that it is offered, none of it shall be covered over till the morning. ");
INSERT INTO engoke_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","But if the offering of his oblation be a vow, or a voluntary gift, it may be eaten (partly) on the day that his sacrifice is offered, and that which remaineth of it may be eaten on the day after it, ");
INSERT INTO engoke_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","But what remaineth of the flesh of the sacrifice on the third day shall be burned with fire. ");
INSERT INTO engoke_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If the flesh of his consecrated sacrifice be indeed eaten on the third day, it shall not be accepted form him who offered it, neither shall it be reckoned to him; it is an abomination, and the man who ate of it shall bear his sin. ");
INSERT INTO engoke_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","And if flesh that is consecrated touch anything unclean, it shall not be eaten, but he burned with fire. Everyone who is clean by sanctification to eat the consecrated flesh may eat the flesh that is consecrated. ");
INSERT INTO engoke_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But the man who eateth of the flesh of sacrifices consecrated before the Lord with his uncleanness upon him, that man shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","And the man who toucheth anything unclean, whether the uncleanness of man or the uncleanness of beast, or of any unclean reptile, and eateth of the flesh of sacrifices consecrated before the Lord, that man shall perish form his people. ");
INSERT INTO engoke_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Speak with the sons of Israel, saying: You may not eat the fat of the ox or sheep or goat. ");
INSERT INTO engoke_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","But the fat of a dead carcase and the fat of an animal torn by a wild beast may be used in any manner of work, but of it you shall not eat. ");
INSERT INTO engoke_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","For whosoever eateth the fat of an animal that they offer as an oblation before the Lord, the man who eateth shall perish from his people. ");
INSERT INTO engoke_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Nor in any of your habitations may you eat the blood of fowl or of beast: ");
INSERT INTO engoke_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Every man who eateth any kind of blood, that man shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Speak with the sons of Israel, saying: Whosoever offereth his sanctified victim before the Lord, let him bring the oblation of his sanctified victim (himself) before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","his own hands shall bring the oblations of the Lord: let him bring the fat with the breast, that the breast may be lifted up an uplifting before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","And the priest shall burn the fat at the altar; but the breast shall be for Aharon and his sons. ");
INSERT INTO engoke_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","And the right shoulder (also) of your sanctified victims you shall give for a separation unto the priest. ");
INSERT INTO engoke_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","He of Aharon’s sons who offereth the blood and the fat of the sanctified victims shall have the right shoulder for a portion. ");
INSERT INTO engoke_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","For the uplifted breast and the shoulder of separation of the sacrifices of the Beni Israel I have given to Aharon the priest and to his sons by and everlasting statue form the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the anointing of Aharon, and the anointing of his sons and of the Lord’s oblations, in the day that they that they present them to minister before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","which the Lord commanded to give them in the day that they consecrate them from the sons of Israel, an everlasting statute unto your generations. ");
INSERT INTO engoke_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law of the burnt offering, of the mincha, nad of the sin offering, and of the trespass offering, and of the oblation of the sanctified victims ");
INSERT INTO engoke_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Which the Lord commanded the sons of Israel to offer their oblations before the Lord in the wilderness of Sinai. ");
INSERT INTO engoke_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Bring Aharon near, and his sons with him, with the vestments, and the oil of consecration, and the bullock for the sin offering, and the two rams, and the basket of unleavened (cakes); ");
INSERT INTO engoke_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","And let all the congregation gather together at the gate of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","And Mosheh did as the Lord commanded him, and the congregation was gathered together at the gate of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","And Mosheh said to the congregation, This is the thing which the Lord hath commanded to be done. ");
INSERT INTO engoke_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","And Mosheh brought Aharon and his sons near, and washed them with water; ");
INSERT INTO engoke_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","And he put upon him the vestment, and girded him with the girdle, and dressed him with the robe, and set upon him the ephod, and bound him with the band of the ephod, and ordained him therewith; ");
INSERT INTO engoke_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","And set upon him the breastplate, and put in the breastplate the uraia an the thummaia. ");
INSERT INTO engoke_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","And he set the mitre upon his head, and place on the mitre, on the forehead of his face, the plate of gold, the diadem of Holiness, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","And Mosheh took the consecrating oil, and anointed the tabernacle and all that was in it, and sanctified them. ");
INSERT INTO engoke_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","And he sprinkled of it upon the altar seven times, and anointed the altar and all its vessels, and the laver and its base, to sanctify them. ");
INSERT INTO engoke_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","And he poured the oil of consecration upon Aharon’s head, and anointed him to consecrate him. ");
INSERT INTO engoke_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","And Mosheh brought the sons of Aharon near, and dressed them in vestments, and girded them with girdles, and appointed them with mitres, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","And he brought the bullock near for the sin offering, and Aharon and his sons laid their hands upon the head of the bullock which was the sin offering. ");
INSERT INTO engoke_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","And Mosheh took the blood, and put it upon the horns of the altar round about, with his finger, and purified the altar, and the blood he poured out at the base of the altar, and consecrated it to make atonement upon it. ");
INSERT INTO engoke_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","And he took all the fat which was upon the inwards, and the caul of the liver, and the two kidneys with their fat; and Mosheh burned them at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the bullock, with his skin, and his flesh, and his food, he burned with fire without the camp, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","And he brought the ram for the burnt offering, and Aharon and his sons laid their hands upon the head of the ram, ");
INSERT INTO engoke_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","And he killed it, and Mosheh sprinkled the blood upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","And the ram he divided by his members; and Mosheh burned the head and the members with the fat. ");
INSERT INTO engoke_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","And the inwards and the legs he washed with water: and Mosheh burned all the ram at the altar: it was a whole burnt offering before the Lord, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","And he brought the second ram of the oblations; and Aharon and his sons laid their hands on the head of the ram, ");
INSERT INTO engoke_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","And he killed it; and Mosheh took of its blood, and put it upon the tip of Aharon’s right ear, and upon the thumb of his right hand, and upon the toe of his right foot; ");
INSERT INTO engoke_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","and Mosheh sprinkled the blood upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","And he took the fat and the tail, and all the fat which is upon the inwards, and the caul of the liver, and the two kidneys and their fat, and the right shoulder: ");
INSERT INTO engoke_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","And from the basket of unleavened cakes that was before the Lord he took one unleavened cake, and one cake of bread (anointed with) oil, and one wafer, and set them upon the fat and upon the right shoulder, ");
INSERT INTO engoke_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","and put the whole upon Aharon’s hands and upon the hands of his sons, and uplifted them, an elevation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","And Mosheh took them form off their hands, and burned (them) at the altar upon the burnt offering: they were offerings to be received with acceptance, an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","And Mosheh took the breast, and uplifted it, an elevation before the Lord: of the ram of the oblations it was the portion of Mosheh, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","And Mosheh took of the oil of consecration, and of the blood that was upon the altar, and sprinkled upon Aharon, upon his vestments, and upon his sons, and upon his sons’ vestments with him, and sanctified Aharon and his garments, and his sons and his sons’ garments with him. ");
INSERT INTO engoke_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","And Mosheh spake to Aharon and to his sons: Boil the flesh at the gate of the tabernacle of ordinance, and eat it there with the bread which is in the basket of oblations, as I was commanded, saying, Aharon and his sons shall eat it. ");
INSERT INTO engoke_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","And that which remaineth of the flesh and of the bread, you shall burn in the fire. ");
INSERT INTO engoke_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","And form the door of the tabernacle of ordinance ye shall not go forth (for) seven days, until the day that the days of your oblation be completed; for seven days shall your oblations be offered, ");
INSERT INTO engoke_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","as hath been done this day, (as) the Lord commanded to be done to make atonement for you. ");
INSERT INTO engoke_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","And at the door of the tabernacle of ordinance ye shall dwell seven days and nights, and watch the watches of the Word of the Lord, that you die not; for so am I commanded. ");
INSERT INTO engoke_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","And Aharon and his sons did all the things which the Lord had commanded by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","And on the eighth day Mosheh called Aharon and his sons and the elders of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","And he said unto Aharon, Take to thee a calf, a young bullock from the herd, for a sin offering, and a ram for a burnt offering unblemished, and offer before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","And with the sons of Israel he spake, saying, Take a kid of the goats for a sin offering, and a calf, and a lamb of the year, unblemished, for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","To sacrifice before the Lord; and a mincha of flour sprinkled with oil: for this day will the glory of the Lord be revealed to you. ");
INSERT INTO engoke_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","And what Mosheh had commanded they brought before the tabernacle of ordinance, and all the congregation approached and stood before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","And Mosheh said, This is the thing that the Lord hath commanded to be done, and the glory of the Lord shall be revealed to you. ");
INSERT INTO engoke_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","And Mosheh said to Aharon, Approach the altar, and make thy sin offering and thy burnt sacrifice, and make atonement for thyself and for the people, and perform the oblation of the people, and make atonement for them, as the Lord commanded. ");
INSERT INTO engoke_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","And Aharon drew near to the altar, and slew the calf for the sin offering for himself. ");
INSERT INTO engoke_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","And the sons of Aharon brought the blood to him, and he dipped his finger in the blood, and put it upon the horns of the altar, and poured out the blood at the base of the altar. ");
INSERT INTO engoke_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","But the fat, and the kidneys, and the caul of the liver of the sin offering he burned at the altar, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","And the flesh and the skin he burned in the fire without the camp. ");
INSERT INTO engoke_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","And he killed the whole burnt offering; and the sons of Aharon brought the blood to him, and he sprinkled it upon the altar round about. ");
INSERT INTO engoke_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","And they brought to him the whole burnt offering by its members with the head, and he burned upon the altar. ");
INSERT INTO engoke_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","And he washed the inwards and the legs, and burned with the offering at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","And he brought the oblation of the people, and took the kid for the sin offering of the people, and killed it, and made atonement with its blood, as before. ");
INSERT INTO engoke_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","And he brought the whole burnt offering, and performed in the manner proper. ");
INSERT INTO engoke_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","And he took the mincha, and filled his hand with it, and burned it upon the altar beside the morning sacrifice. ");
INSERT INTO engoke_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","And he slew the bullock and the ram for the hallowed oblations of the people; and the sons of Aharon brought the blood to him, and he sprinkled the blood round about. ");
INSERT INTO engoke_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Also the fats of the bullock and of the ram, the tail, and the covering of the inwards, with the kidneys, and the caul of the liver; ");
INSERT INTO engoke_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","And they placed the fats upon the breast, and burned the fats at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","And the breast with the right shoulder Aharon uplifted, an elevation before the Lord, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","And Aharon lifted up his hands over (to) the people and blessed them, and cane down from performing the sin offering, and the burnt sacrifice, and the hallowed oblations. ");
INSERT INTO engoke_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","And Mosheh and Aharon entered the tabernacle of ordinance, and came forth and blessed the people; and the glory of the Lord was revealed unto all the people: ");
INSERT INTO engoke_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","And fire came forth from before the Lord, and consumed upon the altar the burnt sacrifice and the fats: and all the people saw, and gave praise, and fell upon their faces. ");
INSERT INTO engoke_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","But the sons of Aharon, Nadab and Abihu, took each man his censer and put fire in them, and put sweet incense upon it, and offered (or brought) before the Lord strange fire which He had not commanded them. ");
INSERT INTO engoke_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","And fire came out from before the Lord and consumed them, and they died before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","And Mosheh said unto Aharon, This is that which the Lord spake, saying, In them who approacheth Me I will be sanctified, and in the face of all the people will I be glorified. And Aharon was silent. ");
INSERT INTO engoke_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","And Mosheh called to Mishael and to Elzaphan, the sons of Uzziel the uncle of Aharon, and said to them, Come nigh, and carry your brethren from before the sanctuary without the camp. ");
INSERT INTO engoke_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","And they came nigh, and carried them in their vestments out of the camp, as Mosheh had spoken. ");
INSERT INTO engoke_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","And Mosheh said to Aharon and to Elazar and to Ithamar his sons, Make not bare your heads, nor rend your garments, lest you die, and wrath be upon all the congregation; but let your brethren and all the house of Israel bewail the burning which the Lord hath kindled; ");
INSERT INTO engoke_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","And go not forth from the door of the tabernacle of ordinance, lest you die; for the anointing oil of the Lord is upon you. And they did according to the word of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","And the Lord spake unto Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Drink not wine nor strong drink, neither thou nor thy sons with thee, when you enter into the tabernacle of ordinance, that you die not. It is an everlasting statute unto your generations, ");
INSERT INTO engoke_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","For the distinguishment between the holy and the common, and between the unclean and the clean; ");
INSERT INTO engoke_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","And that you may teach the sons of Israel all the statutes which the Lord hath spoken to them through Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","And Mosheh spake with Aharon and with Elazar and with Ithamar his sons who were left: Take the mincha which remaineth of the oblations of the Lord, and eat it unleavened at the side of the altar, because it is most holy. ");
INSERT INTO engoke_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","It shall be eaten in the holy place; for it is thy portion, and the portion of thy sons of the oblations of the Lord; for so have I been commanded. ");
INSERT INTO engoke_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","But the breast of the uplifting and the shoulder of the separation you may eat on (any) clean place, and thy sons and thy daughters with thee; for it is thy portion, and the portion of thy sons, which hath been given of the hallowed sacrifices of the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The shoulder of the separation and the breast of the uplifting they will bring with the oblation of the fat things to uplift, an elevation before the Lord: and they shall be thine and thy sons’ with thee by an everlasting statute, as the Lord hath commanded. ");
INSERT INTO engoke_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","But Mosheh made inquiry for the goat of the sin offering; and, behold, it had been burned; and he was angry with Elazar and Ithamar the sons of Aharon who were left, saying: ");
INSERT INTO engoke_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Why have you not eaten of the sin offering in the holy place, because it is most holy; and He hath delivered it unto you for pardoning mercy upon the sin of the congregation to make atonement for them before the Lord? ");
INSERT INTO engoke_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Behold, the blood of it was not brought in within the sanctuary: eating you should have eaten it within the holy (precinct), as I had commanded. ");
INSERT INTO engoke_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","And Aharon said to Mosheh, Behold, this day they have brought their sin offering and their burnt offering before the Lord; but such griefs as these having come upon me, if I had eaten of the sin offering today, would it have been right before the Lord? ");
INSERT INTO engoke_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","And Mosheh heard, and it was pleasing in his eyes. ");
INSERT INTO engoke_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","And the Lord spake with Mosheh and to Aharon, saying to them: ");
INSERT INTO engoke_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Speak with the children of Israel, saying: These are the animals which you may eat of all the beasts which are upon the earth. ");
INSERT INTO engoke_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Everyone that parteth the sole and divideth the paw (or hoof) and that bringeth up the cud among the cattle, that you may eat. ");
INSERT INTO engoke_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","But these you shall not eat, of them that bring up the cud or of them that divide the hoof: the camel, because he bringeth up the cud, but divideth not his hoof, he is unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","And the coney, because he bringeth up the cud, but doth not divide the hoof, is unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","And the hare, because he bringeth up the cud, but the hoof divideth not, shall be unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","And the swine, because he parteth the sole, and divideth the hoof, but cheweth not the cud, he shall be unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You shall neither eat their flesh nor touch their carcases; they are unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","And these you may eat of all that are in the waters; everyone that hath fins and scales in the waters, in the seas, and in the rivers, of them you may eat. ");
INSERT INTO engoke_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But anyone that hath not (both) fins and scales in the seas and in the rivers; every (such) reptile of the waters, and every living animal in the waters, shall they be to you; ");
INSERT INTO engoke_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","of their flesh you shall not eat, and their carcases you shall abhor; ");
INSERT INTO engoke_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Whatsoever hat not (both) fins and scales in the waters is to be an abomination to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","And these shall you hold in abomination among the birds; you shall not eat them, they are an abomination: the eagle, and the sea eagle, and the osprey, ");
INSERT INTO engoke_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","And the kite, and the vulture, after his kind; ");
INSERT INTO engoke_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","And every raven after his kind; ");
INSERT INTO engoke_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","And the ostrich, and the nightbird, and the gull, and the hawk, after his kind; ");
INSERT INTO engoke_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","And the owl, and the diver for fish, and the ibis, ");
INSERT INTO engoke_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","and the swan, and the green bird, ");
INSERT INTO engoke_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","and the stork, and the pica, after his kind, and the moorcock, and the bat. ");
INSERT INTO engoke_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Every winged thing that creepeth, (or) walketh upon four, is an abomination to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yet these you may eat, of every creeping thing that flieth, that walketh upon four which hath joints above its feet wherewith to leap upon the ground. ");
INSERT INTO engoke_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Of such as these you may eat, the locust after his kind, and the bald locust, and the serpent-killer after his kind, and the grasshopper after his kind; ");
INSERT INTO engoke_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But every other creeping thing that flieth having four feet is to be an abomination to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","And by these you will be unclean; everyone who toucheth their carcases shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","And whosoever carrieth a carcase of them, shall was his clothes and be unclean until the evening; ");
INSERT INTO engoke_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","every beast that divideth the hoof, but is not cloven-footed, and that bringeth not up the cud, is to be unclean to you; whosoever toucheth them shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","And every (animal) that goeth upon its paws, of all beast that go upon four, shall be unclean to you; whoever toucheth their carcases shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","And whoever carrieth their carcase shall wash his clothes and be unclean until the evening; to you they are unclean. ");
INSERT INTO engoke_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","And these shall be to you unclean among the reptiles which creep upon the ground; the weasel, and the mouse, and the crocodile after his kind, ");
INSERT INTO engoke_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","and the field mouse (or ferret,) and the chameleon, and the newt, and the lizards, and the mole. ");
INSERT INTO engoke_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These are unclean to you of all that creep; everyone who toucheth them in their dead state shall be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","And upon whatever any of them may fall in their dead state it shall be unclean; whether a vessel of wood, or raiment, or skin, or sack, everything whatever in which work is done, must be put into water, and it shall be unclean until the evening, and must be purified. ");
INSERT INTO engoke_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","And whatever earthen vessel into which any of them may fall, all that is within (it) is polluted, and you shall break it. ");
INSERT INTO engoke_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Any food for eating, upon which water (from such a vessel) is poured, shall be unclean, and all liquor which was for drinking in any (such) vessel shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","And anything upon which a part of their dead bodies may have fallen shall be unclean; oven or cooking pan, they shall be broken, they are unclean and shall be unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nevertheless, a fountain or a pit, the place of a collection of waters, (into which they may have fallen,) shall be clean; but he who toucheth their dead bodies shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","And if a part of their carcase fall upon any seeding seed which is to be sown, it is clean; ");
INSERT INTO engoke_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if water be put upon the seed, and a part of their carcase fall their fall thereupon, it is unclean to you. ");
INSERT INTO engoke_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","And if anyone of the cattle of which you eat die, whosoever toucheth its carcase shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","And he who eateth of its carcase shall wash his clothes, and be unclean until the evening. And he who may carry its carcase shall wash his clothes, and be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","And every reptile that creepeth upon the ground is abominable, it shall not be eaten. ");
INSERT INTO engoke_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Whatsoever goeth upon its belly, and whatever goeth upon four, anything that hath many feet, and every reptile that creepeth, you shall not eat, for they are an abomination. ");
INSERT INTO engoke_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ye shall not make yourselves abominable with your animals by any reptile that creepeth, nor make yourselves unclean, nor be polluted by them, lest by them you be made unclean. ");
INSERT INTO engoke_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am the Lord your God; sanctify yourselves and be holy, for I am Holy; that you may not contaminate your souls with any reptile which creepeth upon the ground; ");
INSERT INTO engoke_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am the Lord who brought you up from the land of Mizraim to be unto you a God; and you shall be holy, for I am Holy. ");
INSERT INTO engoke_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the law of the cattle, and of the fowl, and of every living animal that moveth in the waters, and of every living thing that moveth on the ground, ");
INSERT INTO engoke_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","for making a distinction between the unclean and the clean, between the animal that may be eaten, and the animal that may not be eaten. ");
INSERT INTO engoke_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","And the Lord spake with Mosheh saying: ");
INSERT INTO engoke_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Speak with the children of Israel, saying: A woman, when she hath conceived and borne a male child, shall be unclean seven days; according to the days for the removal of her uncleanness, (or, her seclusion from her uncleanness,) she shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","And on the eighth day he shall be circumcised in the flesh of his foreskin; ");
INSERT INTO engoke_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","And she shall continue thirty and three days in the purification of blood; no sacred thing may she touch, nor may she come into the sanctuary, until the days of her purification be completed. ");
INSERT INTO engoke_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she bear a female child, she shall be unclean fourteen days, according to (the law of) her separation; and sixty and six days she will remain for the purification of the blood. ");
INSERT INTO engoke_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","And when the days of her purification are complete, for the son or for the daughter, let her bring a lamb of its year for a burnt offering, and a young pigeon or a turtle dove for a sin offering, unto the door of the tabernacle of ordinance, unto the priest, ");
INSERT INTO engoke_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Who shall offer it before the Lord, and make atonement for her, and she shall be cleansed from the uncleanness of her blood. This is the law for her who beareth male or female. ");
INSERT INTO engoke_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","But if she find not her hand sufficient for (the providing of) a lamb, let her take two turtle doves, or two young pigeons; one for the burnt offering, and the other for the sin offering, and the priest shall make atonement for her, and she shall be clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","And the Lord spake with Mosheh and with Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","A man, in the skin of whose flesh there may be an abscess, or pustule, or brightness, and it be in the skin of his flesh like a stroke of the leprosy, shall be brought unto Aharon the priest, or to one of his sons the priests. ");
INSERT INTO engoke_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","And the priest shall see the plague in the skin of the flesh, and if the hair in the affected spot be turned white, and the appearance of the plague be deeper than the skin of his flesh, it is the plague of leprosy; and the priest shall inspect him and make (pronounce) him to be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","But if a bright spot be in the skin of his flesh, and the appearance be not deeper than the skin, and the hair be not turned white, the priest shall shut up the stricken (man) seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","And on the seventh day the priest shall inspect him, and if the plague stands as it did, if the plague hath not increases in the skin, let the priest shut him up a second seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","And the priest shall look upon him on the second seventh day; and, behold, if the plague hath become obscure, and the plague hath not spread in the skin, the priest shall make him to be clean; it is a sore, and he shall wash his clothes and be clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the diseased spot increase again in the skin after having been seen by the priest for his cleansing, he shall be brought a second time to the priest. ");
INSERT INTO engoke_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","And the priest inspecting, and, behold, the soreness hath increased in the skin, the priest shall make him to be unclean; it is the leprosy. ");
INSERT INTO engoke_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When the plague of leprosy is in a man, let him be brought to the priest. ");
INSERT INTO engoke_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","And the priest shall inspect him, and, behold, if the abscess is white in the skin, and it hath turned the hair white, and the sign of quick flesh be in the abscess, ");
INSERT INTO engoke_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","It is an old leprosy in the skin of the flesh, and the priest shall make him unclean, but shall not shut him up (to ascertain his uncleanness), for he is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","And if the leprosy increasing shall increase in the skin, and the leprosy cover the whole skin of the plague (struck man) from his head unto his feet, wherever the eyes of the priest may look, ");
INSERT INTO engoke_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","the priest shall observe, and, behold, (if) the leprosy covereth all his flesh, the plagued shall be (considered) clean; the whole of him is turned white, he is clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But in the day that quick flesh appeareth in him he shall be unclean; ");
INSERT INTO engoke_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","And the priest shall observe the quick flesh, and make him to be unclean. The quick flesh is unclean, it is the leprosy. ");
INSERT INTO engoke_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","But if the quick flesh turn to be white, he shall come to the priest; ");
INSERT INTO engoke_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","And the priest shall observe, and, behold, if the plague is turned white, the priest shall make the plagued to be clean; he is clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","And if a man have in him, in his skin, an ulcer, and it hath healed, ");
INSERT INTO engoke_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","but in the place of the ulcer there come a white abscess, or a bright spot, reddish-white, let him show it to the priest, ");
INSERT INTO engoke_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","And the priest shall inspect, and, behold, if the appearance of it be deeper than the skin, and the hair be turned white, the priest shall make him to be unclean; it is the plague of leprosy increasing in the ulcer. ");
INSERT INTO engoke_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if the priest look on it, and, behold, the hair is not white, nor (the depth) lower than the skin, and it hath become obscure, the priest shall seclude him seven days; ");
INSERT INTO engoke_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","And if increasing it increaseth in the skin, the priest shall make him to be unclean; it is the plague. ");
INSERT INTO engoke_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the spot abideth in its place, and increaseth not, it is a description of an ulcer, and the priest shall make him clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Or, if a man hath in his skin a burning wound, and there be the sign of a glowing wound whitish-red or (altogether) white, ");
INSERT INTO engoke_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","the priest shall look upon it, and, behold, if the hair be white in the bright spot, and the appearance be deeper than the skin, it is leprosy increasing in the wound, and the priest shall make him unclean; it is the plague of leprosy. ");
INSERT INTO engoke_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the priest see it, and, behold, the hair is not white in the spot, and it is not deeper than the skin, and is becoming obscure, the priest shall seclude him seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","And the priest shall look upon him on the seventh day; if, increasing, it increaseth in the skin, the priest shall make him to be unclean; it is the plague of leprosy. ");
INSERT INTO engoke_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","But if the spot abideth in its place, and doth not increase in the skin, but hath become obscure, it is (only) a burning sore, and the priest shall make him to be clean, for it is the sign of an inflammation. ");
INSERT INTO engoke_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","And if a man or a woman have a plague on the head, or in the beard, ");
INSERT INTO engoke_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","the priest shall inspect the plague, and, behold, if the appearance is deeper than the skin, and there is in it a thin reddish hair, the priest shall make him unclean; it is a scar (or scurvy), it is leprosy in the head or the beard. ");
INSERT INTO engoke_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","And if the priest observe the plague of the scurvy, and, behold, its appearance is not deeper than the skin, and the hair in it is not black, the priest shall seclude him who hath the plague of the scurvy seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","And the priest shall inspect the plague on the seventh day; and, behold, if the scurf hath not increased, and there is no reddish hair in it, and the appearance of the scurf be not deeper than the skin, ");
INSERT INTO engoke_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","He must shave around the scurfed spot; but the spot itself he must not shave; and the priest shall shut him up (who hath) the scurf a second seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","And the priest shall look upon the scurf on the seventh day, and, behold, if the scurf is not increased in the skin, and its appearance is not deeper than the skin, the priest shall make him clean; and he shall wash his clothes and be clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the scurf increase in the skin after that he hath been (pronounced) clean, ");
INSERT INTO engoke_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","The priest shall inspect him, and, behold, if the scurf be increased in the skin, the priest need not seek for the reddish hair; he is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if the scurf abide as it was, and black hair have sprung up in it, the scurf hath healed, he is clean, and the priest shall make him to be clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","And if a man or a woman have in the skin of their flesh bright white spots, ");
INSERT INTO engoke_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Then the priest shall look, and, behold, if the spots in the skin of their flesh be dim white, it is a freckle growing in the skin; he is clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","And if a man’s hair fall off from his head, he is bald, but he is clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","And if the hair of his head fall off toward his face, he is partly bald, but is clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if in the baldness or partial baldness there be a whitish-red scar, it is leprosy growing in the baldness or partial baldness. ");
INSERT INTO engoke_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Then the priest shall look, and, behold, if the plague spot be whitish-red in the baldness or the partial baldness, as the appearance of leprosy in the skin of the flesh, ");
INSERT INTO engoke_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","The man is a leper, he is unclean; and the priest shall verily make him to be unclean; his plague is in his head. ");
INSERT INTO engoke_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","And the leper in whom is the plague, his clothes shall be rent, and his head bared; and, like the mourner, he shall be covered unto his lip, and shall cry: Be not made unclean! Be not made unclean! ");
INSERT INTO engoke_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","All the days that the plague is upon him shall he be unclean; he is unclean; he shall dwell apart, his habitation shall be without the camp. ");
INSERT INTO engoke_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","The garment which hath the plague of leprosy in it, whether it be in a garment of woollen or of linen, ");
INSERT INTO engoke_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Whether in the warp or in the woof of linen or of woolen, or in leather, or anything made of skin: ");
INSERT INTO engoke_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","If the plague be green or red in the garment or in the skin, whether in the warp, or in the woof, or in anything of skin, it is a plague of leprosy, and must be showed to the priest. ");
INSERT INTO engoke_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","And the priest shall look at the plague, and shut it up seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","And he shall look at the plague on the seventh day; if the plague hath increased in the garment, whether in the warp or in the woof, or in a skin, or anything made of skin for work, it is a plague of consuming leprosy, it is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","And he shall burn the garment, whether it be in warp or woof, of wool, or of linen, or anything (made) of skin, which hath the plague in it; for it is a consuming leprosy; he shall burn it in fire. ");
INSERT INTO engoke_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","But if the priest look, and, behold, the plague hath not increased in the garment, whether in warp or woof, or in anything of skin; ");
INSERT INTO engoke_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Then the priest shall direct, and they shall wash that wherein is the plague, and he shall shut it up a second seven days. ");
INSERT INTO engoke_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","And the priest shall look after that they have washed the plague, and, behold, if (the state of) the plague hath not increased, it is (nevertheless) unclean; thou shalt burn it with fire, it is a fretting leprosy, whether in its smoothness or its roughness (i.e., its right or wrong side). ");
INSERT INTO engoke_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","And if the priest look, and, behold, the plague hath become obscure after they have washed it, he shall tear it out of the garment, or out of the skin, or out of the warp, or of the woof. ");
INSERT INTO engoke_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","And if it reappear in the garment, in warp or woof, or increase in any vessel of skin, thou shalt burn in fire that which hath the plague in it. ");
INSERT INTO engoke_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","And the garment, or warp, or woof, or anything of skin which hath been washed, and the plague hath gone form it, shall be dipped the second time, and shall be clean. ");
INSERT INTO engoke_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law for the plague of leprosy in a garment of woolen or linen, in the warp or the woof, or anything of skin, to make it to be clean or unclean. ");
INSERT INTO engoke_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","This shall be the law for the leper on the day of his purification: He shall be brought to the priest; ");
INSERT INTO engoke_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","And the priest shall go forth out of the camp, and the priest shall look, and, behold, if the leper be healed of his leprosy, ");
INSERT INTO engoke_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Then the priest shall direct that there be brought for him who is to be cleansed two birds, alive, clean, and wood of cedar and scarlet (wood) and hyssop. ");
INSERT INTO engoke_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","And the priest shall direct that one of the birds be killed in an earthen vessel with spring water. ");
INSERT INTO engoke_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","And he shall take the living bird with the cedar wood, and the scarlet, and the hyssop, and dip them and the living bird in the blood of the bird that had been killed over the spring water. ");
INSERT INTO engoke_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","And he shall sprinkle it on him who is to be cleansed form leprosy seven times, and he shall be clean: and the living bird he shall send forth upon the face of the field. ");
INSERT INTO engoke_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","And he who is cleansed shall wash his clothes, and shave off all his hair, and wash himself clean with water, and afterward he may come into the camp; but he shall dwell without his tent seven days. ");
INSERT INTO engoke_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","And on the seventh day he shall (again) shave off all the hair of his head, and his beard and his eyebrows, the whole of his hair shall he shave off, and wash his clothes, and wash his flesh with water, and he shall be clean. ");
INSERT INTO engoke_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","And on the eighth day let him take two (he) lambs unblemished, and one ewe lamb of the year unblemished, and three tenths of flour sprinkled with oil for a mincha, and one loga of oil. ");
INSERT INTO engoke_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","And the priest who maketh him clean shall make the man who is cleansed to stand with them before the Lord at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","And the priest shall take one lamb and offer him for a trespass offering, and the loga of oil, and shall uplift them an elevation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","And he shall slay the lamb on the place where the sin offering is killed, and the burnt offering, (namely,) in the holy place; for as the sin, so the trespass, offering is the priest’s: it is most sacred. ");
INSERT INTO engoke_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","And the priest shall take some of the blood of the trespass offering, and the priest shall put it upon the tip of the right ear of him who is cleansed, and upon the thumb of his right hand, and upon the tow of his right foot. ");
INSERT INTO engoke_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","And the priest shall take of the log of oil and pour it on the priest’s left hand. ");
INSERT INTO engoke_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","And the priest shall dip the finger of his right hand in the oil which is upon his left hand, and shall sprinkle of the oil with his finger seven times before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","And of the rest of the oil which is upon his hand the priest shall put upon the tip of the right ear of him who is cleansed, and upon the thumb of his right hand, and upon the tow of his right foot, upon the blood of the trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","And the remainder of the oil which is upon the priest’s hand he shall put upon the head of him who is cleansed, and the priest shall make atonement for him before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","And the priest shall perform the sin offering, and make atonement for him who is cleansed from his defilement, and afterwards shall he kill the burnt offering. ");
INSERT INTO engoke_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","And the priest shall sacrifice the burnt offering with the mincha at the altar, and the priest shall make atonement for him, and he shall be clean. ");
INSERT INTO engoke_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","But should he be a poor man, and his hand have not (so much) pertaining (to him), let him take one lamb for the trespass offering for the elevation to atone for him, and one-tenth of flour sprinkled with oil for the mincha, and a loga of oil ");
INSERT INTO engoke_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","And two turtle doves or two young pigeons which his hand may possess; and one shall be the sin offering, and one the burnt offering. ");
INSERT INTO engoke_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","And he shall bring them on the eighth day of his purification unto the priest, at the door of the tabernacle of ordinance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","And the priest shall take the lamb of the trespass offering, and the log of oil, and the priest shall uplift them, an elevation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","And he shall kill the lamb of the trespass offering, and the priest shall take of the blood of the trespass offering, and put it upon the tip of the right ear of him who is cleansed, and on the finger of his right hand, and on the tow of his right foot. ");
INSERT INTO engoke_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","And of the oil the priest shall pour (some) upon the priest’s left hand; ");
INSERT INTO engoke_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and the priest shall sprinkle with his finger of the oil that is in his left hand seven times before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","And the priest shall put of the oil which is in his hand upon the tip of the right ear of him who is cleansed, and on the finger of his right hand, and on the tow of his right foot, upon the spot of the blood of the trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","And the remainder of the oil which is in the priest’s hand he shall put upon the head of him who is cleansed, to propitiate for him before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","And he shall offer (perform) one of the turtle doves, or of the young pigeons, ");
INSERT INTO engoke_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Which his hand may possess, the one for a sin offering, and one for a burnt offering, with the mincha; and the priest shall make atonement for him who is cleansed, before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law for him in whom hath been the plague of leprosy, whose hand hath not had sufficiency for (the sacrifices of) his purification. ");
INSERT INTO engoke_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","And the Lord spake with Mosheh and to Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","When you have entered the land of Kenaan, which I will give unto you for a possession; and I have put the plague of leprosy upon a house in the land of your possession; ");
INSERT INTO engoke_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","And he who owns the house shall come and show to the priest, saying, There is a plague, as it appeareth to me, in the house: ");
INSERT INTO engoke_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","The priest shall direct that they turn out (all that is in) the house before the priest goeth in to inspect the plague; that all that is in the house be not (condemned as) unclean; and afterward the priest shall enter to survey the house. ");
INSERT INTO engoke_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Then he shall look at the plague; and, behold, if the plague be in the walls of the house in seams, green or red, and they appear to be deeper than the (surface of the) wall, ");
INSERT INTO engoke_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","then the priest shall go out from the house to the door of the house, and shut up the house seven days. ");
INSERT INTO engoke_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","And the priest shall return on the seventh day, and look, and, behold, if the plague hath increased in the walls of the house, ");
INSERT INTO engoke_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","then the priest shall order that they take down the stones of the house in which the plague is, and cast them without the town into an unclean place. ");
INSERT INTO engoke_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","And they shall scrape the house within round about, and throw the plaster (dust) which they have scraped off without the town, into an unclean place. ");
INSERT INTO engoke_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","And they shall take other stones, and insert them in the place of the former stones, and shall take other plaster and cover the house. ");
INSERT INTO engoke_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","And if the plague return and increase in the house after that the stones have been taken down, nad after they have scraped the house, and after it hath been plastered (anew); ");
INSERT INTO engoke_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Then the priest shall enter, and, behold, if the plague hath increased in the house, it is a corroding leprosy in the house, it is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","And they shall break down the house, the stones of it, the timber, and all the mortar of the house; and he shall carry them (have them carried) without the town unto an unclean place. ");
INSERT INTO engoke_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","And whoso goeth into the house all the days that it is shut up, shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","And he who may sleep in the house shall wash his clothes, and he who eateth in the house shall wash his clothes. ");
INSERT INTO engoke_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","But if the priest, having entered, shall look, and, behold, the plague hath not increased in the house after the house hath been plastered, the priest shall make (pronounce) the house to be clean, for the plague hath been cured. ");
INSERT INTO engoke_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","And he shall take, to purify the house, two birds, and cedar wood, and scarlet, and hyssop. ");
INSERT INTO engoke_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","And he shall kill the one bird in a vessel of pottery with spring water, ");
INSERT INTO engoke_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","and take the cedar wood, and the hyssop, and the scarlet, and the living bird; and dip them in the blood of the bird which had been killed and in the spring water, and sprinkle the house seven times. ");
INSERT INTO engoke_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","And he shall purify the house with the blood of the bird, and with the spring water, and with the living bird, and with the cedar wood, and with the hyssop, and with the scarlet. ");
INSERT INTO engoke_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","But he shall send forth the living bird out of town, upon the face of the field, and make atonement for the house, and it shall be clean. ");
INSERT INTO engoke_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the law for every plague of leprosy and of scorbutics, ");
INSERT INTO engoke_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","And for leprosy in clothing, and in a house: ");
INSERT INTO engoke_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","And for abscess, and scar, and inflamed spot: ");
INSERT INTO engoke_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","To teach on what day it is unclean, and on what day it is purified. This is the law for the leprosy. ");
INSERT INTO engoke_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","And the Lord spake with Mosheh and to Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Speak with the sons of Israel, and say to them: When any man hath a defluxion by the running of his flesh, he is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","And this shall be his uncleanness by his defluxion, when his defluxion floweth form his flesh, or his flesh hath ceased from its flowing, it is (the cause) of his uncleanness. ");
INSERT INTO engoke_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Every bed whereon he lieth who hath the defluxion shall be unclean; and anything whereon he sitteth shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","And whoever toucheth his bed shall wash his clothes, bathe himself in water, and be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","And he who sitteth on a thing whereon he who hath the issue hath sat shall wash his clothes, and bathe in water, and be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","And he who toucheth the flesh of him who hath the issue shall wash his clothes, and bathe in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","And if he who hath the issue spit upon one who is clean, he shall wash his clothes, and bathe in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","And any saddle (or carriage) that he who hath the issue may ride upon shall be unclean; ");
INSERT INTO engoke_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","And whoever toucheth any things that have been under him shall be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","And whomsoever he who hath the issue toucheth, and hath not rinsed his hands in water, shall wash his clothes, and bathe in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","And every vessel of earthenware which he who hath the issue may have touched shall be broken, and every vessel of wood shall be rinsed in water. ");
INSERT INTO engoke_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","And when he who hath had a defluxion shall be cleansed of his issue, he shall number to himself seven days for his purification, and wash his clothes, and bathe his flesh in spring water, and be clean. ");
INSERT INTO engoke_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","And on the eighth day let him take two turtle doves, or two young pigeons, and bring before the Lord at the door of the tabernacle of ordinance, and give them to the priest. ");
INSERT INTO engoke_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","And the priest shall perform (the offering of) them; one for the sin, and one for the burnt, offering; and the priest shall make atonement for him before the Lord, for his issue. ");
INSERT INTO engoke_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","And if seed of copulation go out from a man, he shall wash all his flesh with water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","And any garment or any skin on which may be seed of copulation, shall be washed in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","The woman with whom a man shall lie with seed of copulation, they shall bathe themselves with water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","If a woman have a defluxion of blood in her flesh, seven days shall be for her separation, and whoso toucheth her shall be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","And everything on which she lieth in her separation shall be unclean, and anything that she sitteth upon shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","And anyone who toucheth her bed shall wash his clothes, and bathe in water, and be unclean until evening; ");
INSERT INTO engoke_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","And anyone who toucheth a thing upon which she hath sat shall was his clothes, and bathe in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","And if it be on her bed, or anything on which she hath sat, when he hath touched it, he shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","And if a man lie with her, and her separation be upon him, he shall be unclean seven days, and any bed whereon he lieth shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","And if a woman hath a defluxion of blood many days beyond the time of her separation, if it run beyond (the time) of her separation, all the days of the issue of her uncleanness shall be as the days of her separation; she shall be unclean. ");
INSERT INTO engoke_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Any bed on which she lieth all the days of her defluxion shall be as the bed of her separation, and everything on which she sitteth shall be unclean as the uncleanness of her separation. ");
INSERT INTO engoke_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","And whoso toucheth them shall be unclean, and shall wash his clothes, and bathe in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","But if she be cleansed form her defluxion, then let her number to herself seven days, and afterward she is clean. ");
INSERT INTO engoke_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","And on the eighth day let her take or herself two turtle doves, or two young pigeons, and bring them to the priest at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","And the priest shall make the one a sin offering, and one burnt offering, and the priest shall atone before the Lord for the issue of her uncleanness. ");
INSERT INTO engoke_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","And (thus) shall you separate the children of Israel from their uncleanness, that they die not, by defiling My Tabernacle which is among them. ");
INSERT INTO engoke_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the law for him who hath an issue, or whose seed goeth from him, and who is defiled therewith; ");
INSERT INTO engoke_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","And of her who hath an issue of separation; and of him who hath a flowing issue, of the male and of the female, and of him who lieth with her who is unclean. ");
INSERT INTO engoke_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","And the Lord spake with Mosheh after the two sons of Aharon were dead, who offered the strange fire before the Lord, and died; ");
INSERT INTO engoke_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","And the Lord said unto Mosheh, Speak with Aharon thy brother, that he may not enter at any time into the Holy Place within the veil before the mercy seat which is upon the ark, that he die not; for in the cloud will I reveal Myself over the mercy seat. ");
INSERT INTO engoke_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","With this shall Aharon enter the holy place: With a young bullock for a sin offering, and a ram for a burnt offering. ");
INSERT INTO engoke_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","With the holy linen vesture shall he be clothed, and linen drawers shall be upon his flesh, and with the linen girdle shall he be bound, and the linen mitre shall be upon his head: these are holy garments; and he shall wash his flesh in water, and then put them on. ");
INSERT INTO engoke_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","And of the congregation of the sons of Israel let him take two kids of the goats for a sin offering, and one ram for a burnt offering. ");
INSERT INTO engoke_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","And Aharon shall offer the bullock of the sin offering for himself, and make atonement for himself and for the men of his house. ");
INSERT INTO engoke_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","And he shall take the two goats, and make them to stand before the Lord, at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","And Aharon shall put lots upon the two goats; one lot for the Name of the Lord, and one lot for Azazel. ");
INSERT INTO engoke_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","And Aharon shall offer the goat whose lot came up for the Name of the Lord, and make him a sin offering; ");
INSERT INTO engoke_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","And the goat whose lot came up for Azazel he shall make to stand alive before the Lord, to make an atonement upon him, and to send him away to Azazel, to the desert. ");
INSERT INTO engoke_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","And Aharon shall offer the bullock for his own sin, and make atonement for himself and for the men of his house and he shall kill the bullock for the sin offering which is for himself. ");
INSERT INTO engoke_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","And he shall take a censer full of coals of fire from off the altar before the Lord, and his handful of sweet incense beaten small, and carry (them) within the veil. ");
INSERT INTO engoke_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","And he shall put the sweet incense upon the fire before the Lord, and the cloud of incense will envelope the mercy seat which is over the testimony, that he may not die. ");
INSERT INTO engoke_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","And he shall take of the blood of the bullock, and sprinkle it with his finger upon the face of the mercy seat eastward, and before the mercy seat he shall sprinkle seven times of the blood with his finger. ");
INSERT INTO engoke_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","And be shall kill the goat for the sin offering of the people, and enter, with its blood, within the veil, and do with his blood as he had done with the blood of the bullock, and sprinkle it upon the mercy seat and before the mercy seat. ");
INSERT INTO engoke_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","And he shall (thus) make atonement for the holy place on account of the uncleanness of the children of Israel, and the rebellion of all their sin. And so shall he do for the tabernacle of ordinance which remaineth with them in the midst of their uncleanness. ");
INSERT INTO engoke_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","But no man shall be in the tabernacle of ordinance (at the time of) his entering to make atonement in the holy place until his coming out: and he shall atone for himself, and for the men of his house, and for all the congregation of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","And he shall go forth to the altar which is before the Lord, and make atonement for it; and take of the blood of the bullock and of the goat’s blood, and put upon the horns of the altar round about; ");
INSERT INTO engoke_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","And of the blood he shall sprinkle upon it with his finger seven times, and cleanse it and sanctify it from the uncleanness of the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","And when he hath completed to atone for the holy place, and for the tabernacle of ordinance, and for the altar, then shall he bring the living goat. ");
INSERT INTO engoke_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","And Aharon shall lay his two hands upon the head of the live goat, and confess over him all the iniquities of the children of Israel, and all their rebellions, and all their sins, and put them upon the head of the goat, and send him away, by the hand of an appointed man, to go into the desert. ");
INSERT INTO engoke_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","And the goat shall bear upon him all their iniquities into a land not inhabited; and he shall send the goat away into the desert. ");
INSERT INTO engoke_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","And Aharon shall go into the tabernacle of ordinance, and put off the linen robes which he wore on going into the Holy Place, and shall lay them there aside. ");
INSERT INTO engoke_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","And he shall wash his flesh with water in the Holy Place, and put on his garments, and come forth to offer his burnt sacrifice, and the burnt sacrifice of the people, and make atonement for himself and for the people. ");
INSERT INTO engoke_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","And the fat of the sin offering he shall burn at the altar. ");
INSERT INTO engoke_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","But he who led away the goat unto Azazel shall wash his clothes, and bathe his flesh in water, and afterwards go into the camp. ");
INSERT INTO engoke_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","And the bullock of the sin offering whose blood was carried in to make atonement in the Holy Place, he shall take forth out of the camp, and they shall burn their skins and their flesh and their food with fire. ");
INSERT INTO engoke_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","And he who burned them must wash his clothes, and bathe his flesh with water, and may then enter into the camp. ");
INSERT INTO engoke_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","And this shall be to you for an everlasting statute: in the seventh month, on the tenth day of the month, you shall afflict (humble) your souls, and do no work, whether the native-born or the stranger that dwelleth among you. ");
INSERT INTO engoke_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","For on that day he shall make atonement for you, to cleanse you from all your sins, that you may be cleansed from all your sins before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A Sabbath it shall be to you, and you shall humble your souls. It is an everlasting statute. ");
INSERT INTO engoke_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","And the priest whom he shall anoint, and who shall offer his oblation, to minister instead of his father, shall make the atonement, and dress himself with the vestments of fine linen, even the consecrated vestments. ");
INSERT INTO engoke_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","And he shall make atonement for the Holy of Holies, and for the tabernacle of ordinance and for the altar he shall atone, and for all the people of the congregation shall he atone. ");
INSERT INTO engoke_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","And this shall be to you an everlasting statute for the expiation of all the children of Israel from all their sins once in the year. And he did as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Speak with Aharon, and with his sons, and with all the sons of Israel, and say to them: This is the word which the Lord hath commanded, saying: ");
INSERT INTO engoke_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Any man of the house of Israel who shall kill bullock or lamb or goat in the camp, or who shall kill (such as sacrifices) without the camp, ");
INSERT INTO engoke_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","and bring it not to the door of the tabernacle of ordinance, that it may be offered an oblation in the presence of the Lord before the tabernacle of the Lord, blood shall be reckoned to that man; he hath shed blood, and that man shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","In order that the sons of Israel may bring their victims which they (formerly) sacrificed upon the face of the field, before the Lord at the door of the tabernacle of ordinance, unto the priest, and offer them as consecrated oblations in the presence of the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","And the priest shall sprinkle the blood upon the altar of the Lord at the door of the tabernacle of ordinance, and burn the fat to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","And they shall no more sacrifice their victims unto demons after which they have wandered: this shall be an everlasting statute to you unto your generations. ");
INSERT INTO engoke_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","And say thou to them, Whatever man of the house of Israel, or the stranger who sojourneth among you, who sacrificeth a burnt offering or a consecrated victim, ");
INSERT INTO engoke_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","And bringeth it not to the door of the tabernacle of ordinance, that it may be performed before the Lord, that man shall be destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","And what man soever of the house of Israel or of the strangers who sojourn among you, who shall eat any blood, I will set my anger upon the man who shall have eaten blood, and will destroy him from among his people. ");
INSERT INTO engoke_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Because the life of flesh is in the blood, and I have given it to you upon the altar to make atonement for your souls; for it IS THE BLOOD THAT ATONETH FOR THE SOUL. ");
INSERT INTO engoke_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore have I said to the children of Israel, Let no man of you eat blood, nor let the strangers who sojourn among you eat blood; ");
INSERT INTO engoke_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","And whatever man of the sons of Israel, or of the strangers who sojourn among you, that hunteth venison of beast or bird which may be eaten, let him pour out its blood and cover it in the earth (or in the dust). ");
INSERT INTO engoke_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For the life of all flesh is its blood; it is for its life; and I have said to the children of Israel, You shall not eat the blood of any flesh, for the life of all flesh is its blood; everyone who eateth of it shall be destroyed. ");
INSERT INTO engoke_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","And everyone who eateth of a carcase (that hath died of itself) or hath been torn, whether he be native-born or of the strangers, let him wash his clothes, and bathe in water, and be unclean until the evening, and (then) shall he be clean. ");
INSERT INTO engoke_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he wash not, nor bathe his flesh, he shall bear his transgression. ");
INSERT INTO engoke_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Speak with the sons of Israel, and say unto them: I am the Lord your God: ");
INSERT INTO engoke_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You shall not do according to the people of the land of Mizraim in which you dwelt, nor after the works of the people of the land of Kenaan, whither I am bringing you, shall you do, neither shall you walk in their laws. ");
INSERT INTO engoke_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","My judgments shall you perform and keep My statutes to walk in them; I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","And you shall keep My statutes and My judgments, which if a man do he shall live by them an everlasting life. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","No man shall come nigh to any of his own flesh to uncover the nakedness; I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","The nakedness of thy father, or the nakedness of thy mother, thou shalt not uncover. She is thy mother; thou shalt not uncover her nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","The nakedness of thy father’s wife thou shalt not uncover, it is thy father’s nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","The nakedness of thy sister, the daughter of thy father, or the daughter of thy mother, who hath been begotten of thy father by another wife, or of thy mother by another husband, their nakedness thou shalt not uncover. ");
INSERT INTO engoke_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","The nakedness of thy son’s daughter, or the daughhter of thy daughter, thou shalt not uncover; for they are thy nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","The nakedness of the daughter of thy father’s wife who hath been begotten of thy father, who is thy sister, thou shalt not uncover. ");
INSERT INTO engoke_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","The nakedness of thy father’s sister thou shalt not uncover; she is of kin to thy father. ");
INSERT INTO engoke_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","The nakedness of thy mother’s sister thou shalt not uncover; for she is of kin to thy mother. ");
INSERT INTO engoke_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","The nakedness of thy father’s brother thou shalt not uncover; unto his wife thou shalt not come near; she is the wife of thy father’s brother. ");
INSERT INTO engoke_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","The nakedness of thy daughter-in-law thou shalt not uncover; she is thy son’s wife, thou shalt not uncover her nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","The nakedness of thy brother’s wife thou shalt not uncover; it is thy brother’s nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","The nakedness of a woman and of her daughter thou shalt not uncover; thou shalt not take the daughter of her son nor the daughter of her daughter to uncover her nakedness; they are near of kin, it is a device of wickedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","And a wife with her sister thou shalt not take to cause her tribulation by uncovering her nakedness over her in her life (time). ");
INSERT INTO engoke_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","And unto a woman in the separation of her uncleanness shalt thou not come near to uncover her nakedness. ");
INSERT INTO engoke_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nor with the wife of thy neighbour shalt thou carnally lie to defile her. ");
INSERT INTO engoke_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","And of thy children thou shalt give none to transfer them to Molek, (or, to make them pass through to Molek,) neither shalt thou profane the Name of the Lord thy God: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","And with the male thou shalt not lie as with the woman; it is an abhorrent thing. ");
INSERT INTO engoke_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Nor with any beast shall be thy lying down to defile thyself with it; neither shall a woman stand before a beast to permit him to prevail with her; it is confusion. ");
INSERT INTO engoke_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ye shall not pollute yourselves with any of these; for with all these have the peoples defiled themselves whom I am about to drive away from before you. ");
INSERT INTO engoke_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","And the land (itself) is contaminated; and I will visit the guilt that is upon it, and the land shall vomit forth the inhabitants. ");
INSERT INTO engoke_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","But you shall keep My statutes and My judgments, and commit none of these abominations, neither the native-born nor the sojourners who sojourn among you; ");
INSERT INTO engoke_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","For all these abominations have been done by the men of the land who have been before you, and the land hath been polluted; ");
INSERT INTO engoke_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","That the land vomit you not out when ye defile it; as it will have cast out the people who were before you. ");
INSERT INTO engoke_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","For whoso committeth any of these abominations, the souls that do them shall be destroyed from among their people. ");
INSERT INTO engoke_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","And you shall observe the keeping of My word, that you do not (according to) the abominable usages which have been done before You, nor be corrupted by them. I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Speak with all the congregation of the sons of Israel and say to them, You shall be holy; for I, the Lord your God, am holy. ");
INSERT INTO engoke_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","A man shall reverence his mother and his father, and you shall keep the day of My Sabbath: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Turn not after idols, nor make molten things (for worship): I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","And when you offer the sacrifice of consecrated things before the Lord, make the sacrifice thereof with your own free-will. ");
INSERT INTO engoke_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","On the day that it is sacrificed it may be eaten, and on the following day; but that which remaineth on the third day shall be burned with fire. ");
INSERT INTO engoke_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If indeed it be eaten on the third day, it (the oblation) is rejected, and shall not be accepted. ");
INSERT INTO engoke_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","And whoever eateth it shall bear his guilt; for he hath profaned that which was consecrated, and that man shall destroyed from his people. ");
INSERT INTO engoke_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","And when you reap the harvest of your land, thou shalt not wholly reap the corners of thy field, and the gleanings of thy harvest thou shalt not gather. ");
INSERT INTO engoke_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Neither in thy vineyard shalt thou (entirely) ingather, nor collect the remainder of thy vineyard; thou shalt leave them for the poor, and for the stranger: I am the Lord thy God. ");
INSERT INTO engoke_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","You shall not steal, nor prevaricate, nor be false, a man with his neighbour. ");
INSERT INTO engoke_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Neither swear by My Name unto falsehood, nor profane the Name of thy God: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Thou shalt not overbear thy neighbour, nor be coercive: the hire of the hireling shall not abide with thee till the morning. ");
INSERT INTO engoke_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Thou shalt not curse him who cannot hear, nor put a stumblingblock before him who cannot see, but shalt fear thy God: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","You shall not deal falsely in judgment, nor accept the face of the poor, nor honour the face of the great; in truthfulness shalt thou judge thy neighbour. ");
INSERT INTO engoke_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Thou shalt not make false accusations against thy people, neither stand against thy neighbour’s blood: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Thou shalt not hate thy brother in thy heart: reproving, reprove thou thy neighbour, and contract not sin his account. ");
INSERT INTO engoke_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Thou shalt not be revengeful, nor keep enmity against the children of thy people, but love thy neighbour as thyself. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","You shall observe My statutes. Thy cattle thou shalt not make to gender with various kinds, nor sow thy field with various kinds, nor let a garment of a mixture of woollen and linen come upon thee. ");
INSERT INTO engoke_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","And if a man lie carnally with a woman, and she be a handmaid betrothed unto (another) man, and with redemption of money not redeemed, nor having freedom given to her by an instrument of writing, the stripe shall be upon her; they shall not be put to death, for she was not free. ");
INSERT INTO engoke_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","But he shall bring his trespass offering before the Lord, at the door of the tabernacle of ordinance, a ram for a trespass offering. ");
INSERT INTO engoke_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","And the priest shall make atonement with the ram of the trespass offering before the Lord for the sin that he hath sinned, that the sin he hath sinned may be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","And when you have entered upon the land, and have planted any (kind) of tree for eating, the fruit of it shall be put away (from you); three years shall it be set aside to be destroyed; it shall not be eaten. ");
INSERT INTO engoke_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","But in the fourth year all the fruit shall be consecrated for thanksgiving before the Lord; ");
INSERT INTO engoke_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","And in the fifth year you shall eat the fruit of it, that the fruit may be added (increased) to you. I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","You shall not eat anything with the blood. You shall not use enchantments, nor augury by the clouds. ");
INSERT INTO engoke_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","You shall not shave the hair on your head in a circle, nor destroy the hair of thy beard, ");
INSERT INTO engoke_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","nor make a cutting for the dead in thy flesh; nor imprint signatures upon you: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Thou shalt not profane thy daughter to make her to become a fornicatress, lest the land become whorish, and the land be filled with the ways of wickedness. ");
INSERT INTO engoke_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","The days of Sabbaths, which are Mine, observe ye, and hold in reverence the house of My sanctuary. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Turn not after deceivers, nor inquire by diviners to pollute yourselves with them: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Thou shalt rise up before one who is a teacher in the law, and pay honour to the presence of the aged, and fear thy God. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","And if a stranger sojourn with you in the land, you shall not oppress him. ");
INSERT INTO engoke_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","As one born among you shall be the stranger who sojourneth among you, and thou shalt love him as thyself, because you were sojourners in the land of Mizraim: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","You shall commit no falsity in judgment, in rule, (or line,) in weight, or in measure. ");
INSERT INTO engoke_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Balances of truth, weights of truth, a measure in truth, and hins of truth you shall have. ");
INSERT INTO engoke_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","I am the Lord your God, who have brought you out from the land of Mizraim; and you shall keep all My statutes, and all My judgments, and do them: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Speak unto the sons of Israel: Whatever man of the sons of Israel, or of the strangers who sojourn in Israel, giveth his offspring unto Molek, with killing shall he be killed; the people of the house of Israel shall stone him with stones. ");
INSERT INTO engoke_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","And I will show My displeasure against that man, and will destroy from among his people, because he hath given his offspring unto Molek, to defile My sanctuary and to profane My holy Name. ");
INSERT INTO engoke_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","And if the people of the house of Israel turn away (or hide) their eyes from that man when he giveth his offspring to Molek, that they may not have to put him to death, ");
INSERT INTO engoke_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","I will give forth My anger against that man, and against his abettors, and will destroy him, and all who go after him, to wander after Molek, from among their people. ");
INSERT INTO engoke_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","And the man who turneth away after impostors and diviners to wander after them, I will set My displeasure upon that man, and will cut him off from among his people. ");
INSERT INTO engoke_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","But you shall be sanctified, and be holy; for I am your God. ");
INSERT INTO engoke_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","And you shall observe My statutes, and do them: I am the Lord who sanctify you. ");
INSERT INTO engoke_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","For the man who curseth his father or his mother shall be surely put to death; he hath cursed his father, he is guilty of death. ");
INSERT INTO engoke_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","And the man who committeth adultery with his neighbour’s wife shall be surely put to death; the adulterer and the adulteress. ");
INSERT INTO engoke_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","And the man who lieth with his father’s wife, uncovering his father’s nakedness, shall be surely put to death; both of them are guilty of death. ");
INSERT INTO engoke_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","And a man who lieth with his daughter-in-law, both of them shall be slain: they have wrought confusion, they are guilty of death. ");
INSERT INTO engoke_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","And a man who lieth with a man as with a woman, both of them have wrought abomination: they are to be surely put to death, of death they are guilty. ");
INSERT INTO engoke_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","And when a man taketh a wife along with her mother, it is wickedness; both he and they shall be burned with fire; such wickedness shall not be among you. ");
INSERT INTO engoke_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","And if a man lie with a beast, be shall be surely put to death, and you shall kill the beast. ");
INSERT INTO engoke_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","And if a woman approach to a beast to submit to it, the woman shall be put to death, and the beast; they shall verily be killed; of death they are guilty. ");
INSERT INTO engoke_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","And a man who shall take his sister, the daughter of his father, or the daughter of his mother, and see her nakedness, and she see his nakedness, it is an ignominy and they shall be destroyed before the eyes of the children of their people: he hath uncovered the nakedness of his sister, he shall receive (the punishment of) his guilt. ");
INSERT INTO engoke_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","And a man who lieth with a woman who is unclean, and uncovereth her nakedness, he hath uncovered her shame, and she hath uncovered the uncleanness of her blood: both of them shall be cut off from among their people. ");
INSERT INTO engoke_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Neither shalt thou uncover the nakedness of thy mother’s sister, nor of thy father’s sister; for he will have uncovered that of his near kin; they shall receive for their sin. ");
INSERT INTO engoke_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","And if a man lie with the wife of his father’s brother he hath uncovered the nakedness of his father’s brother; they shall receive for their guilt without children shall they die. ");
INSERT INTO engoke_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","And if man take his brother’s wife, a thing to be kept aloof from, (merachaka,) he bath uncovered the nakedness of his brother, they shall be childless. ");
INSERT INTO engoke_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","But keep you all My statutes and all My judgments, and do them, that the land into which I bring you to dwell may not cast you out. ");
INSERT INTO engoke_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","You shall not walk in the laws of the peoples whom I drive away from before you; for they have committed all these thin, and My Word hath abhorred them. ");
INSERT INTO engoke_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have said to you, Ye shall inherit this land, and I will give it to you to possess it, a land producing milk and honey. I am the Lord your God who have separated you from the peoples. ");
INSERT INTO engoke_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","And you shall make distinction between animals clean and unclean, and between fowls unclean and clean, and not make your souls abominable by beast, or by fowl, or by anything that creepeth on the ground which I have separated (as to be) unto you unclean. ");
INSERT INTO engoke_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","And you shall be holy before Me; for I the Lord am holy, and I have separated you from the nations to be worshippers before Me. ");
INSERT INTO engoke_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","A man or a woman with whom are impostures or divinations shall be verily put to death; with stones they shall be stoned, they are guilty of death. ");
INSERT INTO engoke_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","And the Lord spake with Mosheh, saying: Speak unto the priests, the sons of Aharon, and say to them: Let no one be defiled among his people on account of the dead: ");
INSERT INTO engoke_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Yet for his kin, who is nigh to him, for his mother, and for his father, and for his son, and for his daughter, and for his brother, ");
INSERT INTO engoke_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","and for his sister, a virgin who is near to him, who hath no husband, for her he may be defiled. ");
INSERT INTO engoke_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","But a chief among his people (the high priest) shall not defile himself, to make himself profane. ");
INSERT INTO engoke_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","They shall not make baldness on their heads, nor cut away the hair of their beards, nor scarify their flesh with marks. ");
INSERT INTO engoke_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They shall be holy before their God, and shall not profane the Name of their God; for they offer the oblations of the Lord their God, and they shall be holy. ");
INSERT INTO engoke_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","They shall not take to wife a woman who is a harlot, or one who is corrupted, nor may they take a woman who hath been put away from her husband; for (the priest is to be) holy before his God. ");
INSERT INTO engoke_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Thou shalt consecrate him, for he is to offer the oblation of thy God: he shall be sacred to thee; for I the Lord, who sanctify you, am Holy. ");
INSERT INTO engoke_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","And if the daughter of a man who is a priest profane herself by becoming an harlot, she hath profaned the sanctity of her father; she shall be burned with fire. ");
INSERT INTO engoke_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","And the (high) priest who hath been consecrated from his brethren, upon whose head hath been poured the oil of consecration, and who, at the offering of his oblation, is arrayed with the (holy) robes, shall not make bare his head, nor rend his garments. ");
INSERT INTO engoke_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Nor shall he enter unto any dead body, nor defile himself for his father or his mother. ");
INSERT INTO engoke_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","And he shall not go out from the sanctuary nor defile the sanctuary of his God; for the crown of the anointing oil of his God is upon him. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","And he shall take a wife in her virginity; ");
INSERT INTO engoke_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","A widow, or a divorced person, or a corrupt harlot, these he shall not take; but a virgin from his people shall he take for a wife. ");
INSERT INTO engoke_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","And his offspring he shall not profane among his people; for I the Lord do sanctify him. ");
INSERT INTO engoke_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Speak with Aharon, saying: A man of the generations of thy sons who hath any blemish on him shall not approach to offer the oblation of his God. ");
INSERT INTO engoke_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","For no man in whom is a blemish may come nigh; a blind man, or lame, or flat nosed, or disproportioned; ");
INSERT INTO engoke_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Or a man who hath a broken foot, or a broken hand, ");
INSERT INTO engoke_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","or who is crookbacked, or dwarfish, or who hath a white spot in his eye, or the scurvy, or ringworm, or who hath ruptured testicles. ");
INSERT INTO engoke_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No man of the offspring of Aharon the priest who hath a blemish may approach to offer the oblations of the Lord; having a blemish in him he shall not draw near to present the oblation of his God: ");
INSERT INTO engoke_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Yet of the sanctified oblations of his God, even of the most holy, he may eat: ");
INSERT INTO engoke_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Only he shall not enter within the veil, nor approach the altar, because he hath a blemish; that he profane not My sanctuary; for I am the Lord who sanctify them. ");
INSERT INTO engoke_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","And Mosheh spake with Aharon, and with his sons, and with all the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Speak with Aharon and with his sons, and let them keep separate from the consecrated things of the children of Israel, that they profane not the Name of My Holiness which they (are to) sanctify before Me: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Say to them, Any man of all the sons of your generations who shall touch the hallowed things which the children of Israel consecrate before the Lord, having his uncleanness upon him, that man shall perish before Me: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Any man of Aharon’s offspring who hath leprosy or an unclean effusion shall not eat of the consecrated things until he be clean; and whosoever toucheth any unclean animal, or a man whose seed goeth from him, ");
INSERT INTO engoke_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Or a man who toucheth any reptile that maketh him unclean, or a man who maketh him unclean by any of his uncleanness, ");
INSERT INTO engoke_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","The man who toucheth him shall be unclean until the evening, and may not eat of things consecrated unless he wash his flesh with water. ");
INSERT INTO engoke_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","But when the sun hath gone down, and he shall have purified himself, he may afterward eat of the hallowed things, for it is his food. ");
INSERT INTO engoke_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","A carcase which hath been torn he may not eat, to defile himself therewith: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","But let them keep the keeping of My word, lest they bring guilt upon themselves, and die for it, because they have profaned it, I am the Lord who sanctify them. ");
INSERT INTO engoke_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","No stranger shall eat of that which is consecrated, neither a sojourner with a priest, or a hireling, may eat of the consecrated thing. ");
INSERT INTO engoke_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if the priest buy a person with a purchase of his money, he may eat of it, and he who hath been born in his house, they may eat of his bread. ");
INSERT INTO engoke_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","And the daughter of a priest, if she be married to a stranger, may not eat of things set apart and hallowed. ");
INSERT INTO engoke_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if the priest’s daughter be a widow, or divorced, and, having, no child, hath returned to her father’s house, as in her youth, she may eat of her father’s meat; but no stranger shall eat thereof. ");
INSERT INTO engoke_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","And if a man eat some consecrated thing through ignorance, he shall add a fifth unto it, and give the consecrated thing unto the priest. ");
INSERT INTO engoke_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","And let them not profane the hallowed things of the children of Israel which are set apart before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","nor bring upon themselves iniquities and sins, when they eat in uncleanness the things that are holy. I am the Lord, who sanctify them. ");
INSERT INTO engoke_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Speak with Aharon, and with his sons, and with all the children of Israel, and say to them: When any man of the sons of Israel, or of the sojourners in Israel, will offer the oblation of any of their vows or any of their free-will oblations which they may offer before the Lord for a burnt sacrifice; ");
INSERT INTO engoke_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","That it may be acceptable from you, (let it be) a male without blemish, of the bullocks, or of the lambs, or of the goats. ");
INSERT INTO engoke_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","But whatever hath a blemish in it you shall not offer, for it will not be acceptable for you. ");
INSERT INTO engoke_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","And if a man present a consecrated victim before the Lord, as a vow set apart, or a free-will offering of the herd or of the flock, it must be perfect, to be acceptable; there shall be no blemish in it. ");
INSERT INTO engoke_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Blind, or broken, or mutilated, or having imposthumes, or ulcers, or blotches, these you shall not offer before the Lord, nor of them present an oblation upon the altar before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","But a bullock or a lamb that hath anything superfluous or deficient you may make a free-will offering, but for a vow it will not be acceptable. ");
INSERT INTO engoke_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","And that which is crushed, or rent, or worn out, or emasculated, you shall not offer before the Lord, nor do it in your land. ");
INSERT INTO engoke_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nor from (the hand of) a son of the Gentiles may you offer an oblation to your God of any of these, because their corruption is in them, a blemish is in them; they will not be acceptable for you. ");
INSERT INTO engoke_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","When a bullock, or lamb, or goat, is brought forth, it shall be seven days with its dam, and on the eighth day and thenceforward it will be acceptable to be offered as an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Whether it be a cow or ewe, ye shall not immolate (both) her and her offspring on one day. ");
INSERT INTO engoke_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","And when you present a thank-offering before the Lord, offer it so as to be acceptable for you. ");
INSERT INTO engoke_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","It is to be eaten on that day, nothing shall remain of it till the morning. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","And you shall observe My commandments, and do them. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Nor shall you profane My holy Name, for I will be hallowed among the sons of Israel. I am the Lord who sanctify you, ");
INSERT INTO engoke_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","who have led you forth from the land of Mizraim to be unto you Eloha: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Speak with the sons of Israel, and say to them: The FESTIVALS of the Lord which you shall convoke as holy convocations, these are My festivals. ");
INSERT INTO engoke_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Six days thou shalt do work, but on the seventh day is the rest of the Sabbath; a holy convocation, (in it) you shall do no work. It is a Sabbath before the Lord in all your dwellings. ");
INSERT INTO engoke_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the festivals of the Lord, holy convocations which you shall convoke in their seasons. ");
INSERT INTO engoke_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the first month, on the fourteenth of the month, between the suns, is the Pascha before the Lord, ");
INSERT INTO engoke_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","and on the fifteenth day of this month is the feast (chagga) of unleavened cakes before the Lord; seven days you shall eat unleavened bread. ");
INSERT INTO engoke_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","In the first day you shall have a holy convocation; no laborious work shall you do; ");
INSERT INTO engoke_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","But you shall offer an oblation before the Lord seven days; in the seventh day there shall be a holy convocation; no laborious work may you do. ");
INSERT INTO engoke_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","And the Lord spake with Mosheb, saving: ");
INSERT INTO engoke_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Speak with the sons of Israel, and say to them: When you have entered into the land that I will give unto you, and you reap its harvest, you shall bring an omera of the first of your harvest unto the priest, ");
INSERT INTO engoke_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","And he shall uplift the omera before the Lord to be accepted for you: after the day of the festivity (yoma taba) shall the priest uplift it. ");
INSERT INTO engoke_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","And you shall perform on the day of your elevation of the omera (the sacrifice of) an unblemished lamb of the year, as a burnt offering before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","And the mincha thereof shall be two-tenths of flour mingled with oil, an oblation to be accepted before the Lord; and its libation, wine, the fourth of a hin. ");
INSERT INTO engoke_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Neither bread, nor parched corn, nor green ears shall you eat until this day when you bring the oblation of your God; an everlasting statute unto your generations in all your dwellings. ");
INSERT INTO engoke_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","And count to you, after the festival day, from the day that you brought the omera of the elevation, seven weeks, complete shall they be. ");
INSERT INTO engoke_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Until the (day) after the seventh week number fifty days, and (then) offer a new mincha before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bring from your dwellings two loaves for an elevation, two cakes, of two-tenths of flour shall they be, baked with leaven, as firstfruits before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","And with the bread you shall offer seven unblemished lambs of the year, one young bullock, and two rams; they shall be a burnt offering before the Lord, with their mincha and their libation, to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","And you shall make one of the goats (a sacrifice) for a sin offering, and two lambs of the year for consecrated offerings. ");
INSERT INTO engoke_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","And the priest shall uplift them with the bread of the firstfruits an elevation before the Lord; with the two lambs they (the loaves) shall be consecrated before the Lord for the priest. ");
INSERT INTO engoke_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","And on this same day you shall proclaim (that) it shall be a holy convocation to you. Ye shall do no work of labour. (This is) an everlasting statute in all your dwellings unto your generations. ");
INSERT INTO engoke_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","And when you reap the harvest of your land, thou shalt not entirely finish the corner of thy field in thy reaping, nor shalt thou gather up the gleanings of thy harvest; for the poor and for the stranger thou shalt leave them: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Speak with the sons of Israel, saying: In the seventh month you shall have a (season of) Rest; a memorial of the Trumpet, a holy convocation; ");
INSERT INTO engoke_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","No work of labour shall you do, but offer an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","But on the tenth day of this seventh month shall be the Day of Atonement (Yoma de Kippuraia, the Day of Expiations); a holy convocation you shall have, and afflict (or humble) your souls and offer the oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","And NO WORK may you do on that same day, for it is the Day of Atonement, to make an atonement for you before the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","For every man who will not humble himself on that same day, shall be cut off from his people. ");
INSERT INTO engoke_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","And any man who doeth any work oil that same day, I will destroy that man from among his people. ");
INSERT INTO engoke_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","No work shall you do: an everlasting statute unto your generations, in all your dwellings. ");
INSERT INTO engoke_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","A Sabbath of rest shall it be to you, and ye shall humble your souls, on the ninth of the month at evening: from evening to evening you shall rest your rest. ");
INSERT INTO engoke_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Speak with the sons of Israel saying: On the fifteenth day of this seventh month (shall be) the Feast of Bowers, seven days before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day a holy convocation; no work of labour may you do. ");
INSERT INTO engoke_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Seven days you shall offer oblations before the Lord; on the eighth day you shall have a holy convocation, and offer an oblation before the Lord. You shall be gathered together; no work of labour may you do. ");
INSERT INTO engoke_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the Festivals of the Lord which you shall proclaim to be holy convocations, to offer an oblation before the Lord, a burnt sacrifice, and a mincha, and a consecrated offering and libations (according to) the directory of the day, on its day. ");
INSERT INTO engoke_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Beside (or except) the Sabbaths of the Lord, and beside your gifts, and beside all your vows, and beside all your free-will offerings which you present before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Also on the fifteenth day of the seventh month, when you have gathered in the produce of the ground, you shall solemnize a feast of the Lord seven days. On the first day there shall be rest, and on the eighth day rest. ");
INSERT INTO engoke_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","And you shall take to you on the first day the fruit of the orange (or citron) tree, and branches of palms, and myrtles, and willows of the brook, and rejoice before the Lord your God seven days. ");
INSERT INTO engoke_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","And solemnize it, a feast before the Lord, seven days in the year; it is an everlasting statute unto your generations; in the seventh month shall you solemnize it. ");
INSERT INTO engoke_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","In bowers shall you dwell seven days; everyone who is native-born in Israel shall dwell (or sit) in the bowers: ");
INSERT INTO engoke_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","That your generations may know that I made the children of Israel to dwell under the shadow of clouds when I brought them foorth from the land of Mizraim: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","And Mosheh declared the order of the Festivals of the Lord, and taught them to the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Instruct the sons of Israel to bring to thee oil of olives, pure (and) beaten, to give light, to make the lamps burn continually. ");
INSERT INTO engoke_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside of the veil of the testimony in the tabernacle of ordinance, shall Aharon order it from evening till morning before the Lord continually; an everlasting statute unto your generations. ");
INSERT INTO engoke_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Upon the pure candelabrum shall be order the lamps before the Lord continually. ");
INSERT INTO engoke_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","And thou shalt take flour, and prepare twelve cakes; two-tenths shall be for one cake. ");
INSERT INTO engoke_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","And thou shalt place them in two rows (orders), six in an order, upon the pure table before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","And thou shalt put pure frankincense upon (each) order, and it shall be for Bread of Memorial, (Lechem leadkara,) an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","From Sabbath day to Sabbath day he shall order it before the Lord continually, from the offerings of the children of Israel, an everlasting statute. ");
INSERT INTO engoke_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","And it shall be for Aharon and for his sons, that they may eat it in the holy place; for it is most sacred to him of the oblations of the Lord by an everlasting statute. ");
INSERT INTO engoke_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","And the son of a woman, a daughter of Israel, but he was the son of a Mizraite man went out among the children of Israel; and the son of the Israelite woman, and a man, a son of Israel, had contention in the camp. ");
INSERT INTO engoke_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","And the son of the woman the daughter of Israel gave expression to the Name, and execrated. And they brought him unto Mosheh. And the name of his mother was Shelomith, the daughter of Dibree, of the tribe of Dan. ");
INSERT INTO engoke_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","And they bound him in the house of confinement, until it should be explained to them by the decree of the Word of the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Bring forth him who hath imprecated without the camp, and let all who heard lay their hands upon his head, and let all the congregation stone him. ");
INSERT INTO engoke_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","And speak thou with the sons of Israel, saying: Whatever man imprecateth before his God shall bear his guilt, ");
INSERT INTO engoke_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","And be who (so) expresseth the Name of the Lord, dying shall die, and all the congregation shall stone him, as well the stranger as the native-born; when he hath made (blasphemous) expression of the Name, he shall be put to death. ");
INSERT INTO engoke_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","And the man who killeth any soul of man shall die, being put to death. ");
INSERT INTO engoke_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","And he who killeth the life of a beast shall make it good, life for life. ");
INSERT INTO engoke_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","And if a man inflict a blemish on his neighbour, as he hath done, so it shall be done to him: ");
INSERT INTO engoke_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Bruise for bruise, eye for eye, tooth for tooth as he hath inflicted a blemish upon a man, it shall be done to him. ");
INSERT INTO engoke_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","And he who killeth a beast shall make it good; but he who killeth a man shall be pat to death. ");
INSERT INTO engoke_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","One judgment shall you have, for the stranger as for the native-born shall it be; for I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","And Mosheh spake with the sons of Israel, and they brought out the blasphemer without the camp, and stoned him with stones; and the sons of Israel did as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","And the Lord spake with Mosheh in the mountain of Sinai, saying: ");
INSERT INTO engoke_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Speak with the children of Israel, and say to them: When you have entered into the land that I will give you, the land shall have rest by an intermission (shemet shemittha) before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Six years thou shalt sow thy field, and six years prune thy vineyard, and gather in its fruit; ");
INSERT INTO engoke_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But in the seventh year the land shall have a respite of rest (neach shemittha), a respite before the Lord; thou shalt not sow thy field nor prune thy vineyard. ");
INSERT INTO engoke_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","The after crop of thy harvest thou shalt not reap, neither make vintage of the grapes which thou mayest have left, it shall be a year of remission to the land. ");
INSERT INTO engoke_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Yet the remission of the land shall be to thee for food, to thee, and to thy servant, and to thy handmaid, and to thy hireling, and to the sojourner who dwelleth with thee. ");
INSERT INTO engoke_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","And for thy cattle, and for the beasts that are in thy land, shall all the produce of it be for meat. ");
INSERT INTO engoke_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","And number to thee seven (such) years of Release, beast shall make it good And number to thee seven (such) years of Release, which are seven times seven years; and the days of the seven years of release shall be to thee (in all) forty and nine years. ");
INSERT INTO engoke_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","And thou shalt make the sound of the trumpet to pass forth, in the seventh month on the tenth of the month, on the day of the expiations shall you make (the sound of) the trumpet to pass through all your land. ");
INSERT INTO engoke_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","And you shall sanctify the year of the fifty years, and proclaim liberty in all the land to all its inhabitants; it is and it shall be a jubilee to you; and each man shall return to his inheritance, and each to his family shall return. ");
INSERT INTO engoke_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","A jubilee shall that year of fifty years be to you. Ye shall not sow nor reap the after crop, nor make vintage of the remainder, ");
INSERT INTO engoke_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","for it is a jubilee; it shall be sacred to you; of the growth of the field you may eat. ");
INSERT INTO engoke_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In the year of this jubilee a man shall return to his inheritance. ");
INSERT INTO engoke_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","And when thou sellest a sale to thy neighbour, or buyest of thy neighbour’s hand, you shall not impose, a man upon his brother. ");
INSERT INTO engoke_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","For the number of the years after the (last) jubilee thou shalt buy of thy neighbour; for the number of the years of the produce he shall sell to thee: ");
INSERT INTO engoke_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","According to the multitude of the years thou shalt increase the price, and according to the fewness of the years thou shalt diminish the price; for he selleth thee the amount of the fruits. ");
INSERT INTO engoke_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","And you shall not impose, a man upon his neighbour; but thou shalt fear thy God, for I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","And you shall perform My statutes, and keep My judgments, and do them, and dwell in the land in security. ");
INSERT INTO engoke_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","And the land shall yield her fruitage, and you shall eat unto the full, and dwell upon it in security. ");
INSERT INTO engoke_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","And if you say, What shall we eat in the seventh year; behold, we are not to sow, nor to gather in our fruit? ");
INSERT INTO engoke_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I will command My benediction upon you in the sixth year, and it shall produce for three years. ");
INSERT INTO engoke_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","And you shall sow in the eighth year, and eat of the old produce unto the ninth year: until the fruit come in, you shall eat of the old. ");
INSERT INTO engoke_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","But you may not sell the ground absolutely: for the land is Mine, for you are guests and sojourners before Me; ");
INSERT INTO engoke_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","And in all the land of your inheritance you shall let the ground have redemption. ");
INSERT INTO engoke_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","When thy brother hath become poor, and shall have sold his possession, his redeemer who is of kin to him may come and release that which his kinsman has sold. ");
INSERT INTO engoke_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","And if he have no one to release it, and it pertaineth to his hand to find sufficient means for its redemption; ");
INSERT INTO engoke_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Then let him reckon the years of its sale, and restore the full amount to the man who bought it, that he may return to his possession. ");
INSERT INTO engoke_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if his hand find not sufficiency to give him, the (property) sold shall be in the hand of the buyer until the year of Jubilee, and shall go out in the Jubilee, and return to his possession. ");
INSERT INTO engoke_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","And if a man sell a dwelling house in a town surrounded with a wall, he may redeem it within the full year of the sale of it; within that time shall be its redemption. ");
INSERT INTO engoke_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","But if it be not repurchased when the whole year is completed, the house that is in the walled town shall belong absolutely to him who bought it for his generations; it shall not go out at the Jubilee. ");
INSERT INTO engoke_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But the houses of the villages which have no wall round about them shall be accounted as the field of the land; they may be redeemed, or shall go out at the Jubilee. ");
INSERT INTO engoke_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","And the cities of the Levites, the houses of the cities of their inheritance, may be always redeemed by the Levites (or, be a perpetual redemption for the Levites). ");
INSERT INTO engoke_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","And (so of him) who purchaseth of the Levites, the purchased house in the city of their possession shall go out at the Jubilee; for the houses of the cities of the Levites are their inheritance among the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But a field in the suburbs of their cities may not be sold; for it is an everlasting possession for them. ");
INSERT INTO engoke_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","And if thy brother hath become poor, and his band waver with thee, then thou shalt strengthen him, and he shall be a guest and a sojourner with thee. ");
INSERT INTO engoke_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Thou shalt not take from him any usuries, nor interest (increase), but shalt fear thy God, and let thy brother live with thee. ");
INSERT INTO engoke_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Thou shalt not give him thy money for usury, nor thy food for increase. ");
INSERT INTO engoke_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the Lord your God, who brought you out from the land of Mizraim, to give you the land of Kenaan, and to be your God. ");
INSERT INTO engoke_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","And if thy brother hath become poor with thee, and hath sold himself to thee, thou shalt not make him do the works of slaves, ");
INSERT INTO engoke_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","But as a hired man and an inmate shall he be with thee; until the year of Jubilee shall he serve with thee: ");
INSERT INTO engoke_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then shall he go out from being with thee, he and his children with him, and return to his family and to the inheritance of his fathers. ");
INSERT INTO engoke_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","For they are My servants, whom I brought out from the land of Mizraim; they shall not be sold as the selling of bondmen. ");
INSERT INTO engoke_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Thou shalt not make him serve with rigour, but shalt fear thy God. ");
INSERT INTO engoke_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Thy bondmen and thy handmaids thou shalt have from the Gentiles who are about thee; from them thou mayest obtain bondmen and handmaids. ");
INSERT INTO engoke_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","And also from the sons of the uncircumcised strangers who sojourn with you, of them and of their children who are with you which are born in the land, you may obtain a possession, ");
INSERT INTO engoke_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","And may make them an inheritance for your children after you to inherit them for a possession to serve them perpetually; but among your brethren the sons of Israel no man shall make his brother labour with hardness. ");
INSERT INTO engoke_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","And if the hand of an uncircumcised sojourner with thee wax strong, and thy brother with thee become poor and sell himself to the uncircumcised sojourner with thee, or to an Aramite of the race of the stranger, ");
INSERT INTO engoke_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","after that he is sold he may have redemption; one of his brethren may redeem him. ");
INSERT INTO engoke_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Either his father’s brother, or the son of his father’s brother, may redeem him; or anyone of kin to the flesh of his family may redeem him; or if his hand be able, he may redeem himself. ");
INSERT INTO engoke_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","And he shall reckon with his purchaser from the year that he sold himself, unto the year of Jubilee, and the money of his payment shall be according to the number of the years, according to the days of an hireling shall it be with him. ");
INSERT INTO engoke_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If the years be yet many, according to them shall he give the price of his redemption; ");
INSERT INTO engoke_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Or if but few years remain unto the year of Jubilee, he shall compute with him, and according to the years shall give for his redemption. ");
INSERT INTO engoke_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","As a hireling year by year shall he be with him; he shall not work him with rigour before thine eyes. ");
INSERT INTO engoke_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","But if he be not redeemed within those years, he shall go out at the year of Jubilee, he and his children with him. ");
INSERT INTO engoke_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For the sons of Israel are My servants; they are servants whom I brought out of the land of Mizraim: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","You shall make to you no idols, nor image, nor set up for you a statue; nor a stone for worship shall you make on your land to worship upon it, for I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","The days of my Sabbaths you shall keep, and reverence the house of my sanctuary: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If you walk in My statutes, and observe My commandments and perform them, ");
INSERT INTO engoke_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Then will I give you rains in their season, and your land shall yield her produce, and the tree of the field its fruit. ");
INSERT INTO engoke_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","And for you the threshing shall reach unto the vintage, and the vintage shall reach unto the shooting forth of the seed; and you shall eat your bread with sufficiency, and dwell safely in your land. ");
INSERT INTO engoke_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","And I will give peace in the land, and you shall inhabit, and no one (be among you) who disturbeth. And I will make the evil beast to cease from the land, neither shall they who destroy with the sword pass through on your land. ");
INSERT INTO engoke_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","And you shall chase your adversaries, and they shall fall before you by the sword. ");
INSERT INTO engoke_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","And five of you shall chase a hundred, and a hundred of you put a myriad to flight, and your adversaries shall fall before you by the sword. ");
INSERT INTO engoke_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","For I will have regard to you in my Word, to do you good, and will add to you, and multiply you, and establish My covenant with you. ");
INSERT INTO engoke_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","And you shall eat the old of the old, and shall turn out the old before the new. ");
INSERT INTO engoke_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","And I will set My Tabernacle among you, and My Word shall not reject you. ");
INSERT INTO engoke_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","And I will make My Shekinah to dwell among you, and I will be to you Eloha, and you shall be a people before Me. ");
INSERT INTO engoke_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the Lord your God who brought you out from the land of Mizraim, that you should not be bondmen to them; and I brake off the yoke of the Gentiles from you, and brought you into liberty. ");
INSERT INTO engoke_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","But if you will not be obedient to My Word, nor perform all these commandments; ");
INSERT INTO engoke_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","And if you despise My statutes, and your soul abhor My judgments, so as not to do all My commandments, by your making My covenant of no effect, (or, by your changing My covenant,) ");
INSERT INTO engoke_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I also will do this unto you: I will visit you with trouble, wasting and burning with darkness of eyes, and exhaustion of soul; and ye shall sow your seed in vain for your enemies shall eat it. ");
INSERT INTO engoke_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","And I will reveal My anger against you, and you shall be broken before your enemies; they that hate you shall reign over you, and ye shall flee when no one pursueth you. ");
INSERT INTO engoke_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","And if yet with these ye will not obey My Word, I will add sevenfold chastisement upon your sins. ");
INSERT INTO engoke_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","And I will break the glory of your power, and will make the heavens above you obdurate as iron, to give no rain, and the ground beneath you hard as brass in yielding no fruit; ");
INSERT INTO engoke_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","And your strength shall be put forth in vain, for your ground will not yield its produce, nor the tree of the earth its fruit. ");
INSERT INTO engoke_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","And if you will walk on forwardly before Me, and will not turn again to obey My Word, I will add to bring upon you a stroke sevenfold (heavier) according to your sins. ");
INSERT INTO engoke_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","And I will send the beast of the wilderness against you, and it shall devour you, and consume your cattle, and diminish you, and make your ways desolate. ");
INSERT INTO engoke_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","And if through these (calamities) ye will not be corrected by My Word, but will walk before Me with hardness (of heart), ");
INSERT INTO engoke_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","I also will proceed with you in hardness, and will smite you, even I, sevenfold for your sins. ");
INSERT INTO engoke_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","And I will bring upon you those who kill with the sword, who shall take vengeance upon you in punishment for your transgressions against the words of the law. And you will congregate in your cities; but I will send forth the pestilence among you, and you shall be delivered into the hands of your enemies. ");
INSERT INTO engoke_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I shall have broken for you the support of food, ten women will prepare your bread in one oven, and return your bread by weight, and you will eat, but will not be satisfied. ");
INSERT INTO engoke_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","And if with this you will not be obedient to My Word, but will walk before me with obstinacy, ");
INSERT INTO engoke_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","I will proceed with you with strengthened anger, and will chastise you, even I, sevenfold for your sins. ");
INSERT INTO engoke_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","And ye shall eat the flesh of your sons, and the flesh of your daughters will you eat. ");
INSERT INTO engoke_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","And I will destroy your high places, and cut down your images, and will throw your carcases upon the carcases of your idols, and My Word shall abhor you. ");
INSERT INTO engoke_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","And I will make your cities a waste, and lay waste your sanctuary, and accept no more the offering of your congregation. ");
INSERT INTO engoke_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","And I will make your country a wilderness, and your enemies who will dwell in it shall spread desolation upon it. ");
INSERT INTO engoke_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","And I will disperse you among the nations, and draw out after you them who kill with the sword, and your country shall be a desert and your cities a waste. ");
INSERT INTO engoke_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then shall the land enjoy her repose all the days in which it shall be a desert, and you be in the land of your enemies: so shall the land repose, and enjoy her remission: ");
INSERT INTO engoke_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","All the days of its desolateness it shall rest; because it did not rest in your times of intermission, when you were inhabitants upon it. ");
INSERT INTO engoke_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","And to the heart of those of you who are left in the land of their enemies will I send brokenness, and they shall flee at the sound of a falling leaf; they shall flee as flying from before those who kill with the sword, and fall, while no man pursueth. ");
INSERT INTO engoke_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","They shall thrust, one man against his brother, as (fugitives) from before them who destroy with the sword, while no one is pursuing and ye shall have no power against your adversaries; ");
INSERT INTO engoke_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","And ye shall perish among the nations, and the land of your enemies shall consume you. ");
INSERT INTO engoke_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","And they who are left of shall pine away in your sins, in their adversaries’ land, and for their sins, also, the evil deeds of their fathers which their own hands hold fast, shall they pine away. ");
INSERT INTO engoke_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","But, if they will confess their sins, and the sins of their fathers, and their falseness with which they have acted falsely before My Word, and that they have walked before me in obduracy, ");
INSERT INTO engoke_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","(while) I also have dealt against them with sharpness, and brought them into the land of their enemies; when then their stout heart shall be broken, and they concur with (the punishment of) their sins, ");
INSERT INTO engoke_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","I will remember my covenant with Jacob, and my covenant with Izhak, and also my covenant with Abraham will I remember, and I will remember the land. ");
INSERT INTO engoke_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","But the land shall be left by them, and shall enjoy her repose while made desolate for them, and they shall receive (the punishment of) their sins; curses instead of blessings will I have brought upon them who had cast away My judgments, and whose soul had abhorred My statutes. ");
INSERT INTO engoke_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Yet, even in the land of their enemies I will not strike them down, nor cast them away to consume them utterly, and to make My covenant with them to change; for I am the Lord their God. ");
INSERT INTO engoke_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","But I will remember the former covenant with them whom I brought out of the land of Mizraim in the eyes of the nations, that I might be their God. I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the statutes and judgments and laws which the Lord appointed between His Word and the sons of Israel, in the mountain of Sinai, by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Speak with the sons of Israel, and say to them: When a man setteth apart a votive offering, (it shall be) by estimation of the life before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","If it be the valuation for a male from twenty years to sixty years old, the valuation shall be fifty shekels of silver, in the shekel of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","And if a female, the valuation shall be thirty shekels. ");
INSERT INTO engoke_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","And if the age be from five years to twenty years, the valuation for a male shall be twenty shekels, and for a female ten shekels. ");
INSERT INTO engoke_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","And if the age be from a month unto five years, the valuation for a male shall be twenty shekels, and for a female ten shekels. And if the age be from a month unto five years, the valuation for a male shall be five shekels of silver, and for a female three shekels of silver shall be the valuation. ");
INSERT INTO engoke_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","But if (the age) be sixty years and upwards, for a male the valuation shall be fifteen shekels, and for a female ten shekels. ");
INSERT INTO engoke_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if he be too poor (for the sum of) his valuation, then he shall stand before the priest, and the priest shall make valuation for him upon the word of that which the hand of him who maketh the vow may possess; so shall the priest make his estimate. ");
INSERT INTO engoke_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","And if it be an animal of which (some portion) will be offered an oblation before the Lord, all that he giveth of it before the Lord shall be sacred; ");
INSERT INTO engoke_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He shall not alter it or change it, good for bad, or bad for good; and if he will indeed change animal for animal, both it and that for which it is changed shall be sacred. ");
INSERT INTO engoke_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","And if it be any unclean animal, of which none may be offered an oblation before the Lord, he shall present the animal before the priest, ");
INSERT INTO engoke_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","And the priest shall value it, whether good or bad; according to the estimate of the priest so shall it be. ");
INSERT INTO engoke_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Arid if he will redeem it, then he shall add the fifth upon its value. ");
INSERT INTO engoke_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","And when a man shall sanctify his house, to be consecrated before the Lord, the priest shall value it, whether good or bad; as the priest shall value it, so shall it stand. ");
INSERT INTO engoke_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","And if he who had consecrated it will redeem his house, then let him add the fifth of the price of its value upon it, and it shall be his. ");
INSERT INTO engoke_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","And if a man consecrate a field of his possession before the Lord, its valuation shall be according to (the quantity of) its seed; if sown with barley, a measure shall be (valued at) fifty shekels of silver. ");
INSERT INTO engoke_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he consecrate his field from the year of Jubilee, it shall stand according to its value. ");
INSERT INTO engoke_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he consecrate his field after the year of Jubilee, the priest shall reckon the money with him according to the years which remain until the (next) year of Jubilee, and it shall be abated from the valuation. ");
INSERT INTO engoke_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","But if he will redeem the field that he had consecrated, let him add to it a fifth of its valuated price, and it shall be confirmed to him. ");
INSERT INTO engoke_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","But if he will not redeem the field, or if he have sold the field to another man, it shall not be redeemed any more: ");
INSERT INTO engoke_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","But the field, when it would have gone out at the Jubilee, shall be consecrated before the Lord as a field devoted (hekel cherema); the possession of it shall be to the priest. ");
INSERT INTO engoke_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","And if a man will consecrate before the Lord a field which he hath bought, and which is not of the fields of his inheritance, ");
INSERT INTO engoke_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then the priest shall reckon the sum (receipt) of its value until the year of Jubilee, and he shall give the price of it in that day, a holy thing before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the year of Jubilee the field shall return unto him who sold it, to whom the possession of the land had belonged. ");
INSERT INTO engoke_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","And every valuation shall be in the shekel of the sanctuary, twenty maheen before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Moreover, the first-born among cattle which is to be a firstling, before the Lord, no man may consecrate, whether ox or sheep; it is the Lord’s already. ");
INSERT INTO engoke_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","And if it be an unclean animal, then he shall redeem it according to its valuation, and add one fifth thereto: or if it be not redeemed, then it shall be sold according to its valuation. ");
INSERT INTO engoke_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nevertheless, no devoted thing which a man shall have devoted before the Lord of all that he hath of man or of beast and of the field of his possession may be sold or redeemed; every devoted thing is most sacred before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","No devoted one who is devoted (or accursed) of men, (as the criminal doomed to death,) shall be redeemed; being slain, he shall be killed. ");
INSERT INTO engoke_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","And all the tithe of the land, whether of the seed of the land or of the fruit of the tree, is the Lord’s; it is sacred before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","But if a man will redeem any of his tithe, a fifth shall be add upon it. ");
INSERT INTO engoke_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","And every tithing of oxen or sheep, whatever passeth under the tithing rod, shall be sacred before the Lord. ");
INSERT INTO engoke_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","He shall not choose between the good and bad, neither shall he change it. But if he will commute it, both it and that for which it was exchanged shall be consecrate, and not be redeemed. ");
INSERT INTO engoke_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commandments which the Lord commanded Mosheh for the children of Israel, in the mountain of Sinai. ");
INSERT INTO engoke_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","And the Lord spake with Mosheh in the wilderness of Sinai, in the tabernacle of ordinance, on the first of the second month, in the second year of their coming out from the land of Mizraim, saying: ");
INSERT INTO engoke_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Take the sum of all the congregation of the children of Israel after their kindreds, and after the house of their fathers, with the number of their names, every male by their capitations: ");
INSERT INTO engoke_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","From a son of twenty years and upwards, everyone who can go forth to war in Israel, thou and Aharon number them by their hosts. ");
INSERT INTO engoke_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","And with you let there be a man of each tribe, a man who is chief of the house of his fathers. ");
INSERT INTO engoke_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","And these are the names of the men who shall stand with you. Of Reuben, Elizur bar Shedeur; ");
INSERT INTO engoke_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","of Shemeon, Shelumiel bar Zuri-Shaddai; ");
INSERT INTO engoke_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Of Jehudah, Nachshon bar Aminadab; ");
INSERT INTO engoke_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Of Issakar, Nethanel bar Zuar; ");
INSERT INTO engoke_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Of Zebulon, Eliab bar Chelon; ");
INSERT INTO engoke_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Of the Beni-Joseph, of Ephraim, Elishama bar Amihud; of Menasheh, Gamliel bar Pheda-Zur; ");
INSERT INTO engoke_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Of Benyamin, Abidan bar Gideoni; ");
INSERT INTO engoke_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Of Dan, Achiezer bar Amishaddai; ");
INSERT INTO engoke_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Of Asher, Phagiel bar Akran; ");
INSERT INTO engoke_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Of Gad, Eljasaph bar Dehuel; ");
INSERT INTO engoke_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Of Naphtali, Achira bar Enan. ");
INSERT INTO engoke_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These were the called ones of the congregation, princes of the tribes of their fathers, chiefs of the thousands of Israel were they. ");
INSERT INTO engoke_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","And Mosheh and Aharon took these men who were expressed by their names; ");
INSERT INTO engoke_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","And they assembled all the congregation on the first of the second month, and they declared their pedigrees according to the house of their fathers, with the number of their names from twenty years old and upwards, by their polling. ");
INSERT INTO engoke_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","As the Lord commanded Mosheh, he numbered them in the wilderness of Sinai. ");
INSERT INTO engoke_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","And the sons of Reuben the firstborn of Israel, by their generations and their families, according to the house of their fathers, with the number of their names, by their polls; every male from twenty years old and upward, all going forth in the host: ");
INSERT INTO engoke_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Of the tribe of Reuben were numbered forty and six thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Of the sons of Shemeon, by their generations and their families and the house of their fathers, were numbered, by the number of their names, according to their polls, every male from twenty years old and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Of the tribe of Shemeon, were numbered fifty and nine thousand and three hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Of the sons of Gad, the generations of the families of the house of their fathers, according to the number of their names from twenty years old and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Of the tribe of Gad, were numbered forty and five thousand and six hundred and fifty. ");
INSERT INTO engoke_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Of the sons of Jehudah, the generations of the families of the house of their fathers, by the number of their names, from twenty years old and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Of the tribe of Jehudah, were numbered seventy and four thousand and six hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Of the sons of Issakar, the generations of the families of the house of their fathers, by the number of their names, from twenty years old and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Of the tribe of Issakar, were numbered fifty and four thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Of the tribe of Zebulon, the generations of the families of the house of their fathers, by the number of their names, from a son of twenty years and upward, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Of the tribe of Zebulon, were numbered fifty and seven thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Of the sons of Joseph, the generations of the Beni-Ephraim by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Of the tribe of Ephraim, forty thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","The generations of the Beni Menasheh by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Of the tribe of Menasheh, were numbered thirty and two thousand and two hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","The generations of the sons of Benyamin, by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upward, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Of the tribe of Benyamin, were numbered thirty and five thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","The generations of the Beni Dan, by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upward, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Of the tribe of Dan, were numbered sixty and two thousand and seven hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Of the generations or the Beni Asher, by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upward, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Of the tribe of Asher, were numbered forty and one thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","The generations of the sons of Naphtali, by the kindreds of the house of their fathers, in the number of their names, from a son of twenty years and upwards, everyone going forth in the host; ");
INSERT INTO engoke_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Of the tribe Naphtali, were numbered fifty and three thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These were the numbered ones whom Mosheh and Aharon, and the twelve men, the princes of Israel, did number, severally, according to the house of their fathers. ");
INSERT INTO engoke_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","And all those who were numbered of the Beni Israel according to the house of their fathers, from a son of twenty years and upward, everyone going forth in the host of Israel; ");
INSERT INTO engoke_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","All the numbered ones were six hundred and three thousand and five hundred and fifty. ");
INSERT INTO engoke_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the Levites, by the tribe of their fathers, were not numbered among them. ");
INSERT INTO engoke_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","And the Lord had spoken with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Only the tribe of Levi thou shalt not number, nor take the account of them among the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","But thou shalt appoint the Levites over the tabernacle of the testimony, and over all its vessels, and over all that belongeth to it: and they shall carry the tabernacle and all its vessels, and serve it; and they shall encamp round about the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","And when the tabernacle is to go forward, the Levites shall take it apart; and when the tabernacle is to be stationary, the Levites shall set it up; but the stranger who cometh nigh shall be put to death. ");
INSERT INTO engoke_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","And the sons of Israel shall encamp every man upon his own dwelling-place, and every man by his standard, according to their hosts. ");
INSERT INTO engoke_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levites shall dwell round about the tabernacle of the testimony, that there may not be wrath upon the congregation of the sons of Israel; and the Levites shall watch the watching of the tabernacle of testimony. ");
INSERT INTO engoke_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","And the sons of Israel did according to all that the Lord commanded Mosheh, so did they. ");
INSERT INTO engoke_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","And the Lord spake with Mosheh and with Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Every man (shall encamp) by his standard, by the ensign of the house of their fathers shall the sons of Israel encamp. ");
INSERT INTO engoke_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Over against the tabernacle of ordinance shall they encamp round about. The standard of the camp of Jehudah shall they pitch, according to their hosts, eastward toward the sunrise: and the chief of the sons of Jehudah is Nachshon bar Aminadab. ");
INSERT INTO engoke_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","And his host, and the number of them, seventy and four thousand and six hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","And they who pitch next by him shall be the tribe of Issakar; and the chief of the sons of Issakar, Nethanel bar Zuar; ");
INSERT INTO engoke_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","And his host, and the numbered of it, fifty and four thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","The tribe of Zebulon, and the chief of the sons of Zebulon, Eliab bar Chelon. ");
INSERT INTO engoke_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","And his host, and the numbered of them, fifty and seven thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","All that were numbered of the camp of Jehudah, a hundred and eighty and six thousand and four hundred, by their hosts: they shall go forward in front. ");
INSERT INTO engoke_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","The standard of the camp of Reuben (shall be) to the south, by their hosts: and the chief of the Beni Reuben, Elizur bar Shedeur. ");
INSERT INTO engoke_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","And his host, and the numbered of it, forty and six thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","And they who pitch by him shall be the tribe of Shemeon; and the chief of the Beni Shemeon, Shelumiel bar Zuri-Shaddai; ");
INSERT INTO engoke_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","And his host, and the numbered of them, fifty and nine thousand and three hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","And the tribe of Gad, and the chief of the Beni Gad, Eljasaph bar Rehuel; ");
INSERT INTO engoke_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","And his host, and the numbered of them, forty and five thousand six hundred and fifty. ");
INSERT INTO engoke_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","All who were numbered of the camp of Reuben, a hundred and fifty and one thousand four hundred and fifty, by their hosts: they shall go forward secondly. ");
INSERT INTO engoke_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","But the tabernacle of ordinance shall be taken forward with the camp of the Levites, in the midst of the camp: as they encamp, so shall they go onward, every man in his place, by their standard. ");
INSERT INTO engoke_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","The standard of the camp of Ephraim, by their hosts, shall be to the west: and the chief of the Beni-Ephraim, Elishama bar Ammihud. ");
INSERT INTO engoke_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","And his host and their numbered ones, forty thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","And they who shall be next by him shall be the tribe of Menasheh: and the chief of the Beni Menasheh, Gamliel bar Phedazur. ");
INSERT INTO engoke_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","And his host, and the numbered thereof, thirty and two thousand and two hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","And the tribe of Benyamin, and the chieftain of the sons of Benyamin, Abidan bar Gideoni: ");
INSERT INTO engoke_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","And his host, and the numbered thereof, thirty and five thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","All the numbered of the camp of Ephraim were a hundred and eight thousand and one hundred, by their hosts: and they went forward thirdly. ");
INSERT INTO engoke_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","The standard of the camp of Dan (shall be) to the north, by their hosts; and the chieftain of the Beni Dan, Achiezer bar Ammi-Shaddai. ");
INSERT INTO engoke_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","And his host, and the numbered thereof, sixty and two thousand and seven hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","And those who encamp by him shall be the tribe of Asher; and the chieftain of the Beni Asher, Phagiel bar Akran. ");
INSERT INTO engoke_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","And his host, and the numbered of it, forty and one thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","And the tribe of Naphtali, and the chief of the Beni Naphtali, Achira bar Enan: ");
INSERT INTO engoke_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","And his host, and the numbered thereof, fifty and three thousand and four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","All who were numbered of the camp of Dan, a hundred and fifty and seven thousand and six hundred: they shall go hindmost by their standards. ");
INSERT INTO engoke_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are they who were numbered of the sons of Israel, by the house of their fathers; all who were numbered in the camps by their hosts, six hundred and three thousand five hundred and fifty. ");
INSERT INTO engoke_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levites were not numbered among the sons of Israel, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","And the sons of Israel did according to all which the Lord commanded Mosheh: so did they encamp by their standards, and so went they forward every man by his family, and by the house of his fathers. ");
INSERT INTO engoke_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","And these are the generations of Aharon and Mosheh in the day that the Lord spake with Mosheh in the mountain of Sinai. ");
INSERT INTO engoke_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","And these; are the names of the sons of Aharon. His firstborn, Nadab; and Abihu, Elazar, and Ithamar. ");
INSERT INTO engoke_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the names of the sons of Aharon, the priests, who were consecrated that their oblations might be offered, (and that they might) minister. ");
INSERT INTO engoke_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","But Nadab and Abihu died before the Lord; in their offering the strange fire before the Lord in the wilderness of Sinai: and they had no children. And Elazar and Ithamar ministered before Aharon their father. ");
INSERT INTO engoke_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Bring the tribe of Levi near, and appoint them before Aharon the priest, that they may minister with him. ");
INSERT INTO engoke_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","And they shall keep the watch and the charge of all the congregation by the tabernacle of ordinance to perform the service of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","And they shall keep all the vessels of the tabernacle of ordinance, and the charge of the sons of Israel to perform the service of the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","And thou shalt give the Levites unto Aharon, and to his sons; they are delivered and given to him from the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","And thou shalt appoint Aharon and his sons, that they may keep their priesthood; but the stranger who cometh near shall be put to death. ");
INSERT INTO engoke_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","And I, behold, I have brought near the Levites from among the sons of Israel instead of every firstborn that openeth the womb of the sons of Israel; and the Levites shall minister before Me. ");
INSERT INTO engoke_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","For every firstborn is Mine; on the day that I slew every firstborn in the land of Mizraim, I sanctified before Me every firstborn in Israel from man to animal; they are Mine: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","And the Lord spake with Mosheh in the wilderness of Sinai, saying: ");
INSERT INTO engoke_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Number the sons of Levi, after the house of their fathers, by their families; every male from a month old and upward shalt thou number them. ");
INSERT INTO engoke_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","And Mosheh numbered them according to the word of the Lord, as he had been commanded. ");
INSERT INTO engoke_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","And these were the sons of Levi by their names: Gershon and Kehath and Merari. ");
INSERT INTO engoke_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","And these are the names of the Beni-Gershon after their families: Lebni and Shemei. ");
INSERT INTO engoke_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","And the Beni Kehath after their families: Amram and Izhar, Hebron and Uzziel. ");
INSERT INTO engoke_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","And the Beni-Merari by their families, Mahali and Mushi; these are the families of the Levites after the house of their fathers. ");
INSERT INTO engoke_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Of Gershon were the family of Libni and the family of Shemei; these are the families of Gershon. ");
INSERT INTO engoke_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Those that were numbered of them, every male from the son of a month and upward, the number of them was seven thousand and five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The families of Gershon shall encamp behind the tabernacle, westward: ");
INSERT INTO engoke_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","And the Rab of the house of the fathers of Gershon, Eljasaph bar Lael. ");
INSERT INTO engoke_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","And the charge of the Beni-Gershon in the tabernacle of ordinance (shall be) the tent and its covering, and the hanging of the door of the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","And the curtains of the court, and the hanging of the gate of the court which is by the tabernacle, and by the altar round about, and the cords of it, for all its service. ");
INSERT INTO engoke_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","And of Kehath was the family of Amram, and the family of Izhar, and the family or Hebron, and the family of Uzziel: these are the families of Kehath. ");
INSERT INTO engoke_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","According to the number of all the males, from the son of a month and upward, eight thousand and six hundred, keeping the charge of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The families of the Beni Kehath shall encamp by the side of the tabernacle, southward. ");
INSERT INTO engoke_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","And the Rab of the house of the fathers of the Kehath families (shall be) Elizaphan bar Uzziel. ");
INSERT INTO engoke_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","And their charge shall be the ark, and the table, and the candelabrum, and the altar, and the vessels of the sanctuary with which they minister, and the tent, (or hanging, Sam. Vers., “covering,”) and all (that pertaineth to) the service thereof. ");
INSERT INTO engoke_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","And the chief (armarkella) who is appointed over the chiefs (rabbins) of the Levites is Elazar bar Aharon the priest: under his hand shall they be appointed who have the charge of the keeping of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Of Merari, the families of Mahli and the families of Mushi. ");
INSERT INTO engoke_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","And the numbers of them, according to the numbers of all the males, from the son of a month and upwards, six thousand and two hundred. ");
INSERT INTO engoke_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","And the Rab of the house of the fathers of the Merari families, Zuriel bar Abichael; and they shall encamp on the side of the tabernacle northward. ");
INSERT INTO engoke_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","And the charge for the custody of the sons of Merari shall be the boards of the tabernacle, and its bars, and its pillars, and its sockets, and all its vessels, and whatever (pertaineth) to its service; ");
INSERT INTO engoke_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","And the pillars of the court round about, and their sockets, their pins, and their cords. ");
INSERT INTO engoke_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","But they who encamp before the tabernacle eastward, even before the tabernacle of ordinance toward the sunrise, shall be Mosheh, and Aharon and his sons, keeping charge of the sanctuary, to watch over the children of Israel; and the stranger who cometh near shall be put to death. ");
INSERT INTO engoke_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All who were numbered of the Levites whom Mosheh and Aharon numbered by the word of the Lord, by their families, every male, from the son of a month and upward, twenty and two thousand. ");
INSERT INTO engoke_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","And the Lord spake unto Mosheh, Number all the firstborn males of the children of Israel, from the son of a month upward, and the number of their names. ");
INSERT INTO engoke_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","And thou shalt take the Levites before me, I am the Lord, instead of all the firstborn of the sons of Israel; and the cattle of the Levites instead of all the firstlings of the cattle of the Beni Israel. ");
INSERT INTO engoke_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","And Mosheh numbered, as the Lord commanded him, all the firstborn of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","And all the firstborn males, by the number of their names, from the son of a month and upward by their numbers, were twenty and two thousand two hundred and seventy and three. ");
INSERT INTO engoke_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Take the Levites instead of all the firstborn of the Beni Israel, and the cattle of the Levites instead of their cattle; and the Levites shall minister before Me: I am the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","And of the redeemed ones of the two hundred and seventy and three of the sons of Israel who are more than the Levites, ");
INSERT INTO engoke_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Thou shalt take of each five shekels, by poll, in the shekel of the sanctuary shalt thou take; twenty mahin are a shekel. ");
INSERT INTO engoke_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","And thou shalt give the silver of the redeemed who exceed them to Aharon and his sons. ");
INSERT INTO engoke_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","And Mosheh took the silver of the redeemed who were more than the redeemed by the Levites. ");
INSERT INTO engoke_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Of the firstborn of the Beni Israel he took the silver, a thousand and three hundred and sixty-five shekels, in the shekel of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","And Mosheh gave the silver of the redeemed ones to Aharon and to his sons, by the Word of the Lord, as the Lord had commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","And the Lord spake with Mosheh and with Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Take the reckoning of the Beni Kehath from among the sons of Levi by the house of their fathers, ");
INSERT INTO engoke_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","From thirty years and upward, unto fifty years; all that come to the host, to do the work of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","And this (shall be) the service of the Beni Kehath in the tabernacle of ordinance, the Holy of Holies. ");
INSERT INTO engoke_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","And Aharon and his sons shall enter in, what time the camp is to proceed; and they shall unloose the veil that is hung, and cover therewith the ark of the testimony, ");
INSERT INTO engoke_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","And put over it a covering of hyacinthine skins, and overspread it with a wrapper, wholly purple, having inset its staves. ");
INSERT INTO engoke_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","And upon the table of the presence bread they shall spread a wrapper of purple, and on it put the bowls and mortars, and the measures and cups for libations, and the bread that is ever on it; ");
INSERT INTO engoke_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","And overspread it with a wrapper of scarlet, and cover it with a covering of hyacinth skins, having inset its staves. ");
INSERT INTO engoke_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","And they shall take a purple wrapper, and cover the candelabrum of the light, and its lamps, and its tongs, and its snuff dishes, and all the vessels of the service by which they serve it; ");
INSERT INTO engoke_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","And put it and all its vessels into a covering of hyacinthine skins, and set it upon a bar. ");
INSERT INTO engoke_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","And upon the golden altar they shall spread a purple wrapper, and cover it with a covering of hyacinth skins, and fix its staves. ");
INSERT INTO engoke_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","And they shall take all the vessels of the ministry with which they minister in the sanctuary, and put them in a cloth of purple, and cover them with a covering of hyacinth skins, and set them upon bars. ");
INSERT INTO engoke_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","And they shall collect the cinders from the altar, and spread upon it a wrapper of crimson, ");
INSERT INTO engoke_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","And put thereon all its vessels by which they minister upon it; censers, fleshhooks, shovels, and basins; all the vessels of the altar; and spread over it a covering of hyacinthine skins, and inset its staves. ");
INSERT INTO engoke_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","And when Aharon and his sons have completed to cover up the sanctuary, and all the vessels of the sanctuary in the moving of the camp, the sons of Kehath shall go in to carry (them), but they shall not touch the holy things (themselves), lest they die; but these are the burden of the sons of Kehath in the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","And that delivered unto Elazar bar Aharon the priest (shall be) the oil for the light, and the aromatic incense, and the continual mincha, and the anointing oil, (with) the charge of all the tabernacle, and whatever belongeth to the sanctuary and its vessels. ");
INSERT INTO engoke_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","And the Lord spake with Mosheh and with Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Cut not off the tribe of the family of Kehath from among the Levites; ");
INSERT INTO engoke_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","But do this to them, that they may live and not die, in their approach to the Holy of Holies: Let Aharon and his sons go in, and appoint each man his service and his burden. ");
INSERT INTO engoke_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But they shall not go in to see, when the vessels of the sanctuary are covered, lest they die. ");
INSERT INTO engoke_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Take the account of the sons of Gershon also, after the house of their fathers, by their families; ");
INSERT INTO engoke_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","From thirty years and upwards to fifty years shalt thou number them, of all who come by companies to perform service in the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is the service or the family of Gershon, to serve and to carry. ");
INSERT INTO engoke_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","And they shall carry the curtains of the tabernacle, and the tent of the tabernacle of ordinance, its covering, and the covering of hyacinth which is over it above, and the hanging for the door of the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","And the curtains of the court, and the hanging that is at the entrance of the court, which is by the tabernacle and by the altar round about, and their cords, and all the instruments of their service; and with all that is delivered to them they shall perform their service. ");
INSERT INTO engoke_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","By the word of Aharon and his sons shall be all the service of the Beni-Gershon, with all their burdens, and all their employment; and you shall appoint them in charge with all their burdens. ");
INSERT INTO engoke_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the family of the Beni-Gershon in the tabernacle of ordinance, and their charge shall be under the hand of Ithamar bar Aharon the priest. ");
INSERT INTO engoke_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","The sons of Merari number thou after the families of their father’s house; ");
INSERT INTO engoke_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","From a son of thirty years and upward unto fifty years, shalt thou number them, of all who come by companies to perform the service of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","And this is the charge of their burthen of all the service in the tabernacle of ordinance; the boards of the tabernacle, and its bars, and its pillars, and their bases; ");
INSERT INTO engoke_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","And the columns of the court round about, their bases, pins, and cords of all the instruments of all their service; and by their names you shall number the instruments of the charge of their burthen. ");
INSERT INTO engoke_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the ministry of the family of the Beni-Merari, after all their service in the tabernacle of ordinance under the hand of Ithamar bar Aharon the priest. ");
INSERT INTO engoke_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","And Mosheh and Aharon and the chiefs of the congregation numbered the sons of Kehath, by their families, and by the house of their fathers; ");
INSERT INTO engoke_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","From a son of thirty years and upward to fifty years; everyone who came with the band to the service in the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","And they who were numbered of them by their families, were two thousand seven hundred and fifty. ");
INSERT INTO engoke_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These are the numbered of the family of Kehath, everyone serving in the tabernacle of ordinance, whom Mosheh and Aharon numbered upon the Word of the Lord, by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","And the numbered of the sons of Gershon after the families of their father’s house, ");
INSERT INTO engoke_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","from thirty years and upwards to fifty years, everyone who cometh with the band to the service of the tabernacle of ordinance, ");
INSERT INTO engoke_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","even those who were numbered of them by their families of their father’s house, were two thousand six hundred and thirty. ");
INSERT INTO engoke_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These are the numbered of the Beni-Gershon, everyone who did service in the tabernacle of ordinance, whom Mosheh and Aharon numbered by the mouth of the Word of the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","And the numbered of the Beni-Merari, by the families of their father’s house, ");
INSERT INTO engoke_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","from thirty years and upward to fifty years, all who come by bands to serve in the tabernacle of ordinance, ");
INSERT INTO engoke_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","even they who were numbered by their families, were three thousand and two hundred. ");
INSERT INTO engoke_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These are they who were numbered in the families of the Beni-Merari, whom Mosheh and Aharon numbered by the mouth of the Word of the Lord, by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","All the numbered ones of the Levites whom Mosheh and Aharon and the chiefs of Israel numbered, by their families, and by the house of their fathers, ");
INSERT INTO engoke_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","From thirty years and upward to fifty years, all who came to minister the ministry of the service, and the work of carrying in the tabernacle of ordinance, ");
INSERT INTO engoke_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","even the numbered of them were eight thousand five hundred and eighty. ");
INSERT INTO engoke_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Upon the Word of the Lord they were numbered by the hand of Mosheh; every man according to his service and his burthen they were numbered, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Command the sons of Israel to send away from the camp everyone who is leprous, and everyone who hath an issue, and everyone who is defiled with the pollution of the life of man: ");
INSERT INTO engoke_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","From male to female you, shall send them away, that they defile not their camps; for My Shekinah dwelleth among you. ");
INSERT INTO engoke_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","And the sons of Israel did so; as the Lord spake with Mosheh, so did the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","When a man or a woman hath committed any of the sins of mankind to prevaricate prevarication before the Lord, and that man hath become guilty; ");
INSERT INTO engoke_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","They shall make confession of the sin which they have committed, and restore the principal of (the property of) the trespass, and add a fifth part thereto, and give to him against whom the sin was committed; ");
INSERT INTO engoke_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the man (hath deceased, or) hath no kinsman unto whom the trespass should be returned, let the trespass be restored before the Lord unto the priest, besides the ram of atonement which shall be offered to atone for him. ");
INSERT INTO engoke_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","And all separated things of all the consecrations of the sons of Israel which are offered by the priest are his. ");
INSERT INTO engoke_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","And the consecrated tenths of every man shall be his, and whatsoever a man giveth unto the priest shall be his. ");
INSERT INTO engoke_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Speak with the sons of Israel, and say to them: If a man’s wife go astray and prevaricate against him prevarication, ");
INSERT INTO engoke_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","And a man lie with her, and it be hidden from her husband’s eyes, and she be contaminated, and there be no witness against her, and she be not convicted (or apprehended); ");
INSERT INTO engoke_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","But the spirit of jealousy come upon him, and he be jealous of his wife that she hath been defiled; or the spirit of jealousy come upon him, and he become jealous of his wife, though she be not defiled; ");
INSERT INTO engoke_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Then shall the man bring his wife to the priest, and bring her offering for her, a tenth part of three seins of barley flour; he shall pour no oil thereon, nor put frankincense upon it, because it is a mincha of jealousy, a mincha of remembrance, bringing sins to remembrance. ");
INSERT INTO engoke_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","And the priest shall bring her near, and make her stand before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","And the priest shall take water from the laver in an earthen vessel. And the priest shall take from the dust which is on the floor of the tabernacle, and put it into the water. ");
INSERT INTO engoke_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","And the priest shall make the woman stand before the Lord, and shall uncover the woman’s head, and put the mincha of remembrance, the mincha of jealousy, upon her hands; and in the priest’s hand shall be the bitter waters of cursing. ");
INSERT INTO engoke_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","And the priest shall adjure her, and say to the woman: If no man hath lain with thee, and if thou bast not gone astray to uncleanness (with another) instead of thy husband, be thou unhurt (zakaah, innocent, clean) from these bitter waters of cursing. ");
INSERT INTO engoke_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if thou hast gone astray (to another) instead of thy husband, and art defiled; and another man hath lain with thee, besides thy husband, ");
INSERT INTO engoke_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","the priest shall adjure the woman by the oath of the curse; and the priest shall say to the woman: The Lord set thee for a curse and an execration in the midst of thy people, by the Lord making thy thigh to be corrupt, and thy bowels to swell. ");
INSERT INTO engoke_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","And these waters of cursing shall enter thy inside, to make thy bowels to swell, and thy thigh to become corrupt. And the woman shall say, Amen, Amen! ");
INSERT INTO engoke_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","And the priest shall write these maledictions upon a book, and shall wash them out with the bitter waters. ");
INSERT INTO engoke_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","And he shall make the woman to drink the bitter waters of cursing; and the waters of the curse shall enter into her unto bitterness. ");
INSERT INTO engoke_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","And the priest shall take from the woman’s hand the mincha of jealousy; and wave the mincha before the Lord, and offer it upon the altar. ");
INSERT INTO engoke_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","And the priest shall take with a full hand from the mincha the memorial of it, and burn it upon the altar; and afterward the woman shall drink the water. ");
INSERT INTO engoke_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","And when he hath made her drink the water, it shall be that if she hath been defiled and hath wrought perverseness with her husband, the waters of the execration will enter into her with bitterness, and her bowels will swell, and her thigh become corrupt: and the woman shall be for an execration among her people. ");
INSERT INTO engoke_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman hath not been defiled, but is innocent, they shall enter harmlessly, and she shall conceive with conception. ");
INSERT INTO engoke_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the law of jealousy, when a woman hath gone astray from her husband, ");
INSERT INTO engoke_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when the spirit of jealousy passeth upon a man, and he become jealous of his wife. He shall make the wife stand before the Lord; and the priest shall do for him (according to) all this law. ");
INSERT INTO engoke_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","And the man shall be innocent from guilt, but the woman shall bear her sin. ");
INSERT INTO engoke_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Speak with the children of Israel, and say to them: When a man or a woman would be separated by a vow of the Nazira, to be devoted before the Lord; ");
INSERT INTO engoke_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","He shall abstain from wine, (whether) new or old; vinegar of new wine or vinegar of old wine he may not drink; neither of anything expressed from grapes may he drink; nor of grapes, either fresh or dried, may he eat. ");
INSERT INTO engoke_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","All the days of his nazirate he may not eat of aught that is produced by the vine (wine tree), from its kernels to its expressed juice. ");
INSERT INTO engoke_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","All the days of his nazir vow a razor shall not pass upon his head; until the days be fulfilled which he should devote before the Lord, he shall be consecrate; he shall let the hair of his head grow. ");
INSERT INTO engoke_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","All the days of his vow before the Lord; he shall come near no dead person: ");
INSERT INTO engoke_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","For his father or his mother, for his brother or his sister, should they die, he shall not make himself unclean; because the consecration of Eloha is upon his head: ");
INSERT INTO engoke_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","All the days of his nazirhood shall he be consecrate before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","And if anyone with him die suddenly (to him) unawares, and he defile the head of his vow, let him shave his head on the day of his purification, on the seventh day let him shave it: ");
INSERT INTO engoke_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","And on the eighth day let him bring two turtle doves or two young pigeons unto the priest, to the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","And let the priest make one a sin offering, and one a burnt offering, to atone for him; for that he had sinned by the dead; and let him consecrate his head (anew) on that day. ");
INSERT INTO engoke_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","And he shall devote before the Lord the days of his nazirhood, and bring a lamb of the year for a trespass offering: but the former days have been in vain, because he hath defiled his vow. ");
INSERT INTO engoke_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","And this is the law of the Nazirite on the day that the days of his vow are fulfilled. He shall be brought to the door of the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","And shall present his oblation before the Lord, a lamb of the year, one unblemished, for a burnt offering, and one ewe lamb of the year, unblemished, for a sin offering; and one ram unblemished for a consecrated oblation; ");
INSERT INTO engoke_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","and a basket of unleavened bread, cakes of flour mingled with oil, and unleavened wafers anointed with oil, their minchas and their libations. ");
INSERT INTO engoke_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","And the priest shall present them before the Lord; and make the sin offering and the burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","And the ram he shall make a consecrated oblation before the Lord with the basket of unleavened cakes; and the priest shall make the mincha, and the libation therewith. ");
INSERT INTO engoke_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","And let the Nazirite, at the door of the tabernacle of ordinance, shave his consecrated head; and take the hair of his consecrated head and lay it upon the fire which is under the cauldron, for the peace offerings. ");
INSERT INTO engoke_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","And the priest shall take the boiled shoulder of the ram, and one of the unleavened cakes from the basket, and one unleavened wafer, and put (them) upon the hands of the Nazirite after the shaving of his consecration. ");
INSERT INTO engoke_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","And the priest shall uplift them, an elevation before the Lord. It shall be dedicated to the priest, with the breast of the elevation, and the shoulder of the separation; and after that the Nazirite may drink wine. ");
INSERT INTO engoke_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","This is the law of the Nazirite, who hath vowed his oblation before the Lord, for his consecration, besides those which may come to his hand; according to the vow which he hath vowed, so shall he do according to the law of his consecration. ");
INSERT INTO engoke_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Speak with Aharon and with his sons, saying: Thus shall you bless the children of Israel, and shall say unto them: ");
INSERT INTO engoke_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","The Lord bless thee and keep thee. ");
INSERT INTO engoke_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","The Lord make His Shekinah to shine upon thee, and be merciful to thee. ");
INSERT INTO engoke_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","The Lord turn away His displeasure from thee, and bestow upon thee peace. ");
INSERT INTO engoke_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","And they shall bestow the benediction of My Name upon the sons of Israel, and I will bless them. ");
INSERT INTO engoke_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","And it was on the day when Mosheh had completed to set up the tabernacle, and to anoint it, and to consecrate it, and all its vessels, and had anointed and sanctified them, ");
INSERT INTO engoke_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","That the princes of Israel, heads of the house of their fathers, the chiefs of the tribes, who had been appointed over them who were numbered, ");
INSERT INTO engoke_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","came near, and brought their oblations before the Lord. Six covered wagons and twelve oxen; a wagon for two of the princes, and an ox for each one: and they brought them before the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","And the Lord spake to Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Take (the waggons) from them, that they may be for the work of the service of the tabernacle of ordinance; and thou shalt give them to the Levites, to each man according to the need of his work. ");
INSERT INTO engoke_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","And Mosheh took the waggons and the oxen, and gave them to the Levites. ");
INSERT INTO engoke_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Two waggons and four oxen gave he to the sons of Gershon, according to the need of their work; ");
INSERT INTO engoke_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","And four waggons and eight oxen he gave to the sons of Merari, according to the need of their work, by the hand of Ithamar bar Aharon the priest. ");
INSERT INTO engoke_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But to the sons of Kehath he gave not, because they had the work of the sanctuary, and carried upon their shoulders. ");
INSERT INTO engoke_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","And the princes offered at the dedication (chanucha) of the altar on the day that they anointed it, and the princes presented their oblations before the altar. ");
INSERT INTO engoke_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","And the Lord said to Mosheh, One prince shall offer, on each day of the dedication of the altar. ");
INSERT INTO engoke_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","And he who offered his oblation on the first day was Nachshon bar Aminadab, of the tribe of Jehudah: ");
INSERT INTO engoke_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","And his offering was, one bowl of silver, a hundred and thirty shekels was its weight; one silver vase, seventy shekels in weight, in shekels of the sanctuary; both of them filled with flour, mingled with oil, for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","One pan (censer) weighing ten shekels; it was of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","One young bullock, one ram, one lamb of the year for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","And for consecrated oblations, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Nachshon bar Aminadab. ");
INSERT INTO engoke_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day offered Nethanel bar Zuar, prince of the tribe of Issakar. ");
INSERT INTO engoke_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He offered his oblation, one silver bowl, a hundred and thirty shekels was its weight; one silver vase, its weight seventy shekels, in the shekels of the sanctuary; both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","One pan weighing ten shekels; it was of gold, full of fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","One young bullock, one ram, one lamb of the year for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","And for a sacrifice of consecrated things, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Nethanel bar Zuar. ");
INSERT INTO engoke_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day, the prince of the Beni Zebulon, Eliab bar Chelon. ");
INSERT INTO engoke_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His offering, one silver bowl, its weight one hundred and thirty shekels; one silver vase, its weight seventy shekels in the shekels of the sanctuary; both of them filled with flour mingled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","One pan weighing ten shekels; it was of gold, and filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","One young bullock, one lamb of the year for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","And for consecrated offerings, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Eliab bar Chelon. ");
INSERT INTO engoke_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day the prince of the sons of Reuben, Elizur bar Shedeur. ");
INSERT INTO engoke_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His offering, one silver bowl, one hundred and thirty shekels its weight, one silver vase, weighing seventy shekels in the shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","One pan weighing ten shekels; it was of gold, and filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","One young bullock, one ram, one lamb of the year for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","And for the consecrated oblation, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Elizur bar Shedeur. ");
INSERT INTO engoke_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day the prince of the Beni Shemeon, Shelumiel bar Zurishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His offering, one silver bowl, one hundred and thirty, shekels was its weight, one silver vase, weighing seventy shekels in the shekels of the sanctuary, both of them filled with flour mingled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","One pan weighing ten shekels; it was of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","One young bullock, one ram, one lamb of the year for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","And for consecrated oblations two oxen, five rams, five goats, five lambs of the year. This was the oblation of Shelumiel bar Zurishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day the prince of the sons of Gad, Eljasaph bar Dehuel. ");
INSERT INTO engoke_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His offering, one silver bowl, its weight one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","One pan weighing ten shekels of gold, full of fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","One young bullock, one ram, one lamb of the year for a burnt offering, ");
INSERT INTO engoke_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","And for consecrated oblations, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Eljasaph bar Dehuel. ");
INSERT INTO engoke_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day the prince of the sons of Ephraim, Elishama bar Ammihud. ");
INSERT INTO engoke_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His offering, one silver bowl weighing one hundred and thirty shekels, one silver vase weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","One pan weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","One young bullock, one ram, one Iamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","And for consecrated oblations, two oxen, five rams, five goats, five Iambs of the year. This was the oblation of Elishama bar Ammihud. ");
INSERT INTO engoke_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day the prince of the Beni Menashe, Gamliel bar Phedazur. ");
INSERT INTO engoke_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His offering, one silver bowl, weighing one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","One pan weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","One young bullock, one ram, one lamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","And for consecrated oblations, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Gamliel bar Phedazur. ");
INSERT INTO engoke_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day the prince of the sons of Benyamin, Abidan bar Gideoni. ");
INSERT INTO engoke_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His oblation, one silver bowl, weighing one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","One pall weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","One young bullock, one ram, one lamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","And for consecrated oblations, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Abidan bar Gideoni. ");
INSERT INTO engoke_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day the prince of the sons of Dan, Achiezer bar Amishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His oblation, one silver bowl, weighing one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","One pan weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","One young bullock, one ram, one lamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","And for consecrated oblations, two oxen, five rams, five goats, five lambs of the year. This was the oblation of Achiezer bar Amishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day the prince of the Beni Asher, Phagiel bar Akran. ");
INSERT INTO engoke_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His oblation, one silver bowl, weighing one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","one pan weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","One young bullock, one ram, one lamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","And for consecrated oblations two oxen, five rams, five goats, five lambs of the year. This was the oblation of Phagiel bar Akran. ");
INSERT INTO engoke_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day, the prince of the Beni Naphtali, Achira bar Enan. ");
INSERT INTO engoke_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His oblation, one silver bowl, weighing one hundred and thirty shekels, one silver vase, weighing seventy shekels in shekels of the sanctuary, both of them filled with flour sprinkled with oil for a mincha; ");
INSERT INTO engoke_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","One pan weighing ten shekels of gold, filled with fragrant incense; ");
INSERT INTO engoke_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","One young bullock, one ram, one lamb of the year, for a burnt offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","One kid of the goats for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","And for consecrated oblations two oxen, five rams, five goats, five lambs of the year. This was the oblation of Achira bar Enan. ");
INSERT INTO engoke_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","This was the dedication of the altar, on the day that they anointed it. By the princes of Israel (were offered) twelve silver bowls, twelve silver vases, twelve golden censers; ");
INSERT INTO engoke_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","One hundred and thirty shekels was the weight of one silver bowl, and seventy that of one silver vase: all the silver vessels weighed two thousand four hundred shekels in shekels of the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The golden censers were twelve, full of fragrant incense, weighing each ten shekels; the weight of the censers was, in shekels of the sanctuary, all the gold of the censers one hundred and twenty (shekels). ");
INSERT INTO engoke_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","All the bullocks for the burnt offering were twelve bullocks, rams twelve, lambs of the year twelve, and their minchas. And for the sin offering twelve kids of the goats. ");
INSERT INTO engoke_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","And all the oxen for consecrated victims were twenty-four oxen, rams sixty, goats sixty, lambs of the year sixty. This was the Dedication of the Altar after they had anointed it. ");
INSERT INTO engoke_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","And when Mosheh had gone into the tabernacle of ordinance to speak with Him, then heard he the Voice of Him who spake with him from above the Mercy Seat over the Ark of the Testimony, between the two Kerubaia; and He spake unto him. ");
INSERT INTO engoke_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Speak with Aharon, and say to him: When thou dost kindle the lamps upon the face of the candelabrum, the seven lamps shall be burning (together). ");
INSERT INTO engoke_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aharon did so: on the face of the candelabrum he made the lamps burn, as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","And this work of the candelabrum was of beaten gold, from its shaft to its lilies, beaten (gold) according to the pattern which the Lord had showed to Mosheh, so had he made the candelabrum. ");
INSERT INTO engoke_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Bring near the Levites from among the sons of Israel, and purify them. ");
INSERT INTO engoke_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","And thus shalt thou do to them to purify them. Sprinkle upon them the water of purification, and make the razor to pass over all their flesh, and let them wash their vestments, and they shall be clean. ");
INSERT INTO engoke_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","And let them take a young bullock, and his mincha of flour, sprinkled with oil; and a second bullock, a young bullock shalt thou take, for the sin offering. ");
INSERT INTO engoke_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","And bring the Levites before the tabernacle of ordinance, and assemble all the congregation of the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","And thou shalt bring the Levites before the Lord; and the sons of Israel shall lay their hands upon the Levites; ");
INSERT INTO engoke_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","And Aharon shall offer the Levites as an elevation before the Lord from the sons of Israel, that they may perform the service of the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","And the Levites shall lay their hands upon the head of the bullocks, and make the one for a sin offering, and the other for a burnt offering, before the Lord, to make an atonement for the Levites. ");
INSERT INTO engoke_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","And thou shalt set the Levites before Aharon, and before his sons, and offer them up (as) an elevation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","And thou shalt thus separate the Levites from among the sons of Israel, that the Levites may minister before Me. ");
INSERT INTO engoke_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","And afterward shall the Levites enter, to minister (in) the tabernacle of ordinance; for thou wilt have purified them, and offered them up as an elevation. ");
INSERT INTO engoke_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For by a separation are they separated unto Me from among the sons of Israel, instead of every firstborn who openeth the womb of all the children of Israel have I taken them (to be) before Me. ");
INSERT INTO engoke_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For Mine are all the firstborn of the children of Israel, of man and of beast: in the day that I slew all the firstborn in the land of Mizraim did I sanctify them before Me. ");
INSERT INTO engoke_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","And I have taken the Levites instead of all the firstborn of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","And the Levites I have given as a gift unto Aharon and to his sons, from among the sons of Israel, to minister the service for the children of Israel in the tabernacle of ordinance, and to make atonement for the children of Israel, that death may not be among the children of Israel when the children of Israel come nigh to the sanctuary. ");
INSERT INTO engoke_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","And Mosheh and Aharon, and all the congregation of the sons of Israel, did unto the Levites according to all that the Lord commanded Mosheh for the Levites; so did the sons of Israel to them. ");
INSERT INTO engoke_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","And the Levites were purified, and they cleansed their raiment, and Aharon offered them (as) an elevation before the Lord; and Aharon made an atonement for them to purify them. ");
INSERT INTO engoke_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","And afterwards the Levites went in to perform their service in the tabernacle of ordinance before Aharon and before his sons; as the Lord had commanded Mosheh concerning the Levites, so did they unto them. ");
INSERT INTO engoke_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","This is (the law) of the Levites: from a son of five-and-twenty years and upward he shall come with the bands in their service (in the) tabernacle of ordinance, ");
INSERT INTO engoke_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","and from fifty years old he shall return from the company of the ministers, and work no longer; ");
INSERT INTO engoke_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","But minister with his brethren at the tabernacle of ordinance in keeping the custody; yet the service he shall not perform: so shalt thou do with the Levites in their charge. ");
INSERT INTO engoke_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","And the Lord spake with Mosheh, in the wilderness of Sinai, in the second year of their going forth from the land of Mizraim, in the first month, saying: ");
INSERT INTO engoke_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Let the children of Israel perform the Pascha in its time. ");
INSERT INTO engoke_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","On the fourteenth day of this month, between the suns, they shall perform it in its time according to all the rites of it, and according to all the form of it shall they do it. ");
INSERT INTO engoke_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","And Mosheh spake with the sons of Israel to perform the Pascha. ");
INSERT INTO engoke_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","And they performed the Pascha in Nisan, on the fourteenth day of the month, between the suns, in the wilderness of Sinai; according to all that the Lord had commanded Mosheh, so did the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","But there were men who were unclean by defilement, (having touched) the body of a (dead) man, and they could not make the Pascha on that day; and they came before Mosheh and before Aharon that day, ");
INSERT INTO engoke_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","And the men said to him: We are unclean, by the defilement of the life of a man, and are, therefore, restrained from offering the oblation of the Lord in its time among the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","And Mosheh said to them, Wait, till I shall have heard what will be commanded from before the Lord about your case. ");
INSERT INTO engoke_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Speak with the sons of Israel, saying: If any man be unclean by the defilement of the life of a man, or be in the way, afar off’ from you or from your dwellings, he shall perform the Pascha before the Lord ");
INSERT INTO engoke_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","in the second month, on the fourteenth day, between the suns, they shall perform it; with unleavened (bread) and with bitter (herbs) shall they eat it: ");
INSERT INTO engoke_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They shall not leave of it till the morning, and a bone of it shall not be broken; according to all the rites of the Pascha shall they perform it. ");
INSERT INTO engoke_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But the man who is clean, and is not upon a journey, and forbeareth to perform the Pascha, that man shall be cut off from his people: because he hath not offered the Lord’s oblation in its time, that man shall bear his guilt. ");
INSERT INTO engoke_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","And if a stranger sojourn with you, and will perform the Pascha before the Lord, according to the rites of the Pascha, and according to the forms thereof, so shall he do: one statute shall you have, for the stranger, and for the native of the land. ");
INSERT INTO engoke_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","And on the day that the Tabernacle was erected the Cloud covered the Tabernacle of the Testimony; and at evening there was upon the Tabernacle as the vision of Fire, until the morning. ");
INSERT INTO engoke_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So was it continually; the Cloud covered it (by day), and the appearance of the Fire in the night. ");
INSERT INTO engoke_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","And according as the Cloud was uplifted above the Tabernacle, the sons of Israel afterward went on; and at the place where the Cloud rested, there did the sons of Israel encamp. ");
INSERT INTO engoke_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","By the Word of the Lord the sons of Israel journeyed, and by the Word of the Lord they encamped; all the days that the Cloud rested, they remained. ");
INSERT INTO engoke_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","However long the time the Cloud was upon the Tabernacle, (however) many the days, the sons of Israel kept the watch of the Word of the Lord, and journeyed not. ");
INSERT INTO engoke_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","And if the Cloud was over the tabernacle a number of days, according to the Word of the Lord they remained, and by the Word of the Lord they went forward. ");
INSERT INTO engoke_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Or if the Cloud was (over the Tabernacle only) from the evening till the morn, and the Cloud was uplifted in the morning, they went forward; whether (in the) days or nights the Cloud was uplifted, they went forward; ");
INSERT INTO engoke_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether it was two days, or a month, or a longer season, (time by time,) the Cloud was in staying upon the Tabernacle to remain thereon, the children of Israel remained, and went not forward; but at the lifting up of it they proceeded. ");
INSERT INTO engoke_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","By the Word of the Lord they abode, and by the Word of the Lord they proceeded; they observed the watch of the Word of the Lord, upon the Word of the Lord through Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Make thee two trumpets of silver, beaten shalt thou make them, and they shall be for thee to convoke the assembly, and to move forward the host. ");
INSERT INTO engoke_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","And they shall blow with them, and bring all the congregation together unto thee, at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","And if they blow with but one, the chiefs, the heads of thousands of Israel, shall gather together to thee. ");
INSERT INTO engoke_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you blow with a full note, (or alarm,) the host that encampeth eastward shall go forward, ");
INSERT INTO engoke_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","and when you blow with the second alarm, the hosts that encamp southward shall go on; an alarm shall they blow for their journeys. ");
INSERT INTO engoke_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But when the congregation is to be gathered together, you shall blow, but not with the alarm. ");
INSERT INTO engoke_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","And the sons of Aharon, the priests, are to blow with the trumpets; and this shall be to you a perpetual statute for your generations. ");
INSERT INTO engoke_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","And when you enter upon the battle fight for your country, with the oppressors who oppress you, ye shall blow the alarm with the trumpets, that your remembrance may come for good before the Lord your God, (and) that you may be delivered from them who hate you. ");
INSERT INTO engoke_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","And on the day of your rejoicing, and on your solemnities, and at the beginning of your months, ye shall blow with the trumpets over your burnt offerings, and over your consecrated victims; and they shall be for a memorial before your God: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","And it was in the second year, in the second month, on the twentieth day of the month, that the Cloud was uplifted from above the Tabernacle of the Testimony, ");
INSERT INTO engoke_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","And the children of Israel went forward upon their journeys from the wilderness of Sinai; and the Cloud rested in the wilderness of Pharan. ");
INSERT INTO engoke_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","And they went forward at the first by the Word of the Lord through Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","In the first place the standard of the camp of the Beni Jehudah went forward by their hosts; and over the host was Nachshon bar Aminadab. ");
INSERT INTO engoke_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","And over the host of the tribe of the Beni Issakar, Nethanel bar Zuar. ");
INSERT INTO engoke_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","And over the host of the tribe of the Beni Zebulun, Eliab bar Chelon. ");
INSERT INTO engoke_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","And the tabernacle was taken down, and the sons of Gershon went forward, and the sons of Merari, carrying the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","And the standard (or order) of the camp of Reuben went forward by their hosts, and over its host was Elizur bar Shedeur: ");
INSERT INTO engoke_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","And over the host of the tribe of the Beni Shemeun was Shelumiel bar Zurishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","And over the host of the Beni Gad was Eljasaph bar Dehuel. ");
INSERT INTO engoke_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","And the sons of Kehath went forward, carrying the sanctuary, and (the Gershonites and sons of Merari) set up the tabernacle against they came. ");
INSERT INTO engoke_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","And the standard of the camps of the Beni-Ephraim went forward by their hosts, and over his host was Elishama bar Amihud. ");
INSERT INTO engoke_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","And over the host of the tribe of the Beni Menasheh was Gamliel bar Phedazur. ");
INSERT INTO engoke_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","And over the host of the tribe of the Beni Benyamin, Abidan bar Gideoni. ");
INSERT INTO engoke_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","And the standard of the camps of the Beni Dan went forward collecting each camp according to their hosts; and over his host was Achiezer bar Amishaddai. ");
INSERT INTO engoke_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","And over the host of the tribe of the Beni Asher, Phagiel bar Akran; ");
INSERT INTO engoke_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","And over the host of the tribe of the Beni Naphtali, Achira bar Enan. ");
INSERT INTO engoke_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","These are the journeys of the sons of Israel, and according to their hosts they went forward. ");
INSERT INTO engoke_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","And Mosheh said unto Hobab bar Reuel, the Midianite, the father-in-law of Mosheh, We are journeying to the place of which the Lord hath said, I will give it unto you: come thou with us, and we will do thee good; for the Lord hath spoken, to bring good upon Israel. ");
INSERT INTO engoke_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But he said to him, I will not go (with you), but to my country and to my kindred will I go. ");
INSERT INTO engoke_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","And he said, Leave us not, I beseech thee; for thou knowest how we should encamp in the wilderness; and the great things that will be done for us thou wilt see with thine eyes. ");
INSERT INTO engoke_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","And it shall be that if thou wilt go with us, with the good by which the Lord shall do us good, will we do good to thee. ");
INSERT INTO engoke_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","And from the mountain on which the glory of the Lord had been revealed they went forward, journeying three days; and the ark of the Lord’s covenant went before them, three days’ journey, to provide for them a place of encampment. ");
INSERT INTO engoke_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","And the Cloud of Glory of the Lord overspread them by day as they went forth from their encampments. ");
INSERT INTO engoke_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","And when the ark went forward, Mosheh said: Reveal thyself, O Lord, that Thine enemies may be scattered, and Thy adversaries may flee before thee. ");
INSERT INTO engoke_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when it rested, he said: Return, O Lord, and dwell in Thy glory among the multitudes of the thousands of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","But the people were discontented (or, were fomenting evil) before the Lord; and it was heard before the Lord, and His anger was strongly moved, and a fire was kindled against them from before the Lord, and it consumed the outskirts of the camp. ");
INSERT INTO engoke_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","And the people cried unto Mosheh, and Mosheh prayed before the Lord, and the fire was subdued. ");
INSERT INTO engoke_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","And Mosheh called the name of that place Enkindlement; because the fire had been kindled against them from before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","And the mixed multitude who were among them demanded with demand; and the children of Israel also turned, and wept, and said: Who will feed us with flesh? ");
INSERT INTO engoke_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish which we ate in Mizraim freely, the cucumbers and melons, the cresses and onions and garlick. ");
INSERT INTO engoke_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now our soul longeth, yet there is nothing before our eyes but manna. ");
INSERT INTO engoke_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Now the manna was like the seed of coriander, and its appearance as the appearance of bedilcha. ");
INSERT INTO engoke_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","And the people went about and gathered; and he who would ground it in mills, or he who would beat it in the mortar, and they dressed it in the pan, and made cakes of it, and its taste was like the taste of a confection of oil. ");
INSERT INTO engoke_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","And when the dew came down upon the camp at night, the manna descended upon it. ");
INSERT INTO engoke_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","And Mosheh heard the people lamenting with their families, a man at the door of his tent. And the displeasure of the Lord grew very strong, as in the eyes of Mosheh it was evil. ");
INSERT INTO engoke_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","And Mosheh said before the Lord, Wherefore hast Thou done painfully to Thy servant, and why have I not found mercy before Thee, that Thou hast put the burden of all this people upon me? ");
INSERT INTO engoke_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Am I father to all this people, or are they my children, that Thou hast said to me, Carry them in thy strength, as the nurse carrieth the suckling, unto the land which Thou hast covenanted to their fathers? ");
INSERT INTO engoke_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Whence shall I have flesh to give to all this people? For they lament to me, saying: Give us flesh to eat. ");
INSERT INTO engoke_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able to bear all this people alone, because it is too heavy for me. ");
INSERT INTO engoke_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","And if Thou do thus with me, kill me, I pray, if I have found mercy before Thee, that I may not see my wretchedness. ");
INSERT INTO engoke_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","And the Lord said to Mosheh, Gather unto Me seventy men of the elders of Israel, whom thou knowest to be elders of the people, and the overseers thereof, and bring them to the tabernacle of ordinance, and let them stand there with thee; ");
INSERT INTO engoke_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","And I will reveal Myself, and will speak with thee there; and I will make enlargement of the Spirit that is upon thee, and put it upon them, that they may bear with thee the burden of the people, and thou mayest not sustain it by thyself alone. ");
INSERT INTO engoke_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","And say thou to the people, Prepare yourselves for the morrow, and you shall eat flesh; for that you have lamented before the Lord, saying: Who will give us flesh, that we may eat? For it was better with us in Mizraim; and I will give you flesh, and you shall eat. ");
INSERT INTO engoke_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Not one day shall you eat (it), nor two days, nor five days, nor ten days, nor twenty days; ");
INSERT INTO engoke_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","But for a month of days, until you loathe it, and it be an offence to you; because you have felt, dislike to the Word of the Lord, whose Shekinah dwelleth among you; and before whom you have wept, saying: Why came we out of Mizraim? ");
INSERT INTO engoke_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","But Mosheh said, The people among whom I am are six hundred thousand footmen; and Thou hast said, I will give them flesh to eat for a month of days. ");
INSERT INTO engoke_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Shall the oxen and sheep be slaughtered for them, to satisfy them, or all the fish of the sea be gathered that they may be satisfied? ");
INSERT INTO engoke_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","And the Lord said to Mosheh: Is the Word of the Lord restrained? Now shalt thou see whether My saying come to pass with thee or not. ");
INSERT INTO engoke_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","And Mosheh went forth, and told the people the words of the Lord, and gathered together seventy men of the elders of the people, and set them round about the tabernacle. ");
INSERT INTO engoke_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","And the Lord was revealed in the Cloud, and spake with him, and he made enlargement of the Spirit that was upon him, and imparted to the seventy men, the elders; and it came to pass that when the Spirit of prophecy rested upon them they prophesied, and ceased not. ");
INSERT INTO engoke_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","But two men remained in the camp, the name of the one Eldad, and the name of the second Medad; and the Spirit of prophecy rested upon them; and, though they were in the writings, they had not come out of the camp; but they prophesied in the camp. ");
INSERT INTO engoke_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","And a young man ran, and showed to Mosheh, and said: Eldad and Medad do prophesy in the camp. ");
INSERT INTO engoke_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","And Jehoshua bar Nun, the minister of Mosheh from his youth, answered and said, Ribboni Mosheh, put them in bond. ");
INSERT INTO engoke_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","But Mosheh said, Art thou jealous for my sake? I would that all the people of the Lord did prophesy, and that the Lord would confer the Spirit of prophecy upon them. ");
INSERT INTO engoke_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","And Mosheh returned to the camp, he and the elders of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","And the wind proceeded from before the Lord, and the quails flew abroad from the sea, and it bare them upon the camp as (the breadth of) a day’s journey here, and a day’s journey there, round about the camp, and as at a height of two cubits over the face of the ground. ");
INSERT INTO engoke_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","And the people were up all that day, and all the night, and all the day after it, and collected the quails; he who collected least (gathered together) ten heaps; and they spread them abroad, round about the camp. ");
INSERT INTO engoke_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","While yet the flesh was between their teeth, and they had not yet finished, the displeasure of the Lord was manifested strongly against the people, and the Lord inflicted death among the people with a very great mortality. ");
INSERT INTO engoke_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","And he called the name of that place, The Graves of the Demanders; because there they buried the people who demanded. ");
INSERT INTO engoke_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From the Graves of the Demanders the people journeyed to Hatseroth, and they were in Hatseroth. ");
INSERT INTO engoke_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","And Miriam and Aharon spake against Mosheh, because of the fair woman whom he had taken, because the fair woman who had been sent away he had taken. ");
INSERT INTO engoke_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","And they said, Hath the Lord spoken only with Mosheh? Hath He not spoken with us also? And it was heard before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(But the man Mosheh was very humble, more than all the men who were upon the face of the earth.) ");
INSERT INTO engoke_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","And the Lord spake suddenly with Mosheh, and to Aharon and to Miriam: Come forth, you three, to the tabernacle of ordinance; and those three went forth. ");
INSERT INTO engoke_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","And the Lord was revealed in the pillar of the Cloud, and stood at the door of the tabernacle: and He called Aharon and Miriam, and they two came forth. ");
INSERT INTO engoke_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","And He said, Hear now My words. If there be prophets with you, I the Lord will reveal Myself (to them) in visions, in dreams will I speak with them. ");
INSERT INTO engoke_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","But not so (with) My servant Mosheh; over all My house faithful is he. ");
INSERT INTO engoke_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Speaker with speaker will I speak with him; in apparition, and not in similitudes; and he shall behold the likeness of the glory of the Lord. And how is this, that you have not been afraid to speak against My servant, against Mosheh? ");
INSERT INTO engoke_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","And the displeasure of the Lord was strong against them, and He went up. ");
INSERT INTO engoke_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","And the Cloud went up from over the tabernacle. And, behold, Miriam was white as snow; and Aharon looked upon Miriam, and, behold, she was leprous. ");
INSERT INTO engoke_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","And Aharon said to Mosheh, My lord, I entreat that thou wouldst not lay this sin upon us, in that we have acted foolishly, and have transgressed. ");
INSERT INTO engoke_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Let not this one, I entreat, be separated from among us, for she is our sister. Pray, now, over this dead flesh which is in her, that she may be healed. ");
INSERT INTO engoke_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","And Mosheh prayed before the Lord, saying: O God, I beseech Thee, heal her now. ");
INSERT INTO engoke_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","But the Lord said to Mosheh, If her father, correcting, had corrected her, ought she not to have been ashamed seven days? Let her be shut up seven days without the camp, and afterward be admitted. ");
INSERT INTO engoke_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","And Miriam was shut up without the camp seven days; and the people journeyed not until Miriam was brought in. ");
INSERT INTO engoke_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","And afterward the people journeyed from Hatseroth, and encamped in the wilderness of Pharan. ");
INSERT INTO engoke_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Send thou men, that they may explore the land of Kenaan, which I will give to the children of Israel: one man for each tribe of their fathers shall you send, each one a ruler among them. ");
INSERT INTO engoke_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","And Mosheh sent them from the wilderness of Pharan, according to the Word of the Lord. All those men were heads of the children of Israel; ");
INSERT INTO engoke_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","And these are their names: For the tribe of Reuben, Shamua bar Zakur; ");
INSERT INTO engoke_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","For the tribe of Shemeon, Shaphat bar Hori; ");
INSERT INTO engoke_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","For the tribe of Jehudah, Kaleb bar Jephuneh; ");
INSERT INTO engoke_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","For the tribe of Issakar, Igal bar Joseph; ");
INSERT INTO engoke_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","For the tribe of Ephraim, Hoshea bar Nun; ");
INSERT INTO engoke_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","For the tribe of Benyamin, Phalti bar Raphu; ");
INSERT INTO engoke_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","for the tribe of Zebulon, Gediel bar Sodi; ");
INSERT INTO engoke_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","For the tribe of Joseph, the tribe of Menasheh, Gaddi bar Susi; ");
INSERT INTO engoke_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","For the tribe of Dan, Ammiel bar GemaIi; ");
INSERT INTO engoke_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","For the tribe of Asher, Sethor bar Mikael; ");
INSERT INTO engoke_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","For the tribe of Naphtali, Nachbi bar Vapsi; ");
INSERT INTO engoke_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","For the tribe of Gad, Geuel bar Machi: ");
INSERT INTO engoke_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men whom Mosheh sent to explore the land. And Mosheh called Hoshea bar Nun Jehoshua. ");
INSERT INTO engoke_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","And Mosheh sent them away to explore the land of Kenaan. And he said to them, Go up hither by the south, and ascend to the mountain, ");
INSERT INTO engoke_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","And see the country what it is, and the people who dwell upon it, whether they be strong or weak, few or many; ");
INSERT INTO engoke_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","And what the land is in which they dwell, whether good or bad; and what the cities they inhabit, whether open, or walled in; ");
INSERT INTO engoke_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","And whether the land is rich or poor; whether it hath trees or not: and you, be of good courage, and bring of the fruits of the land. And the days were the days of the first grapes. ");
INSERT INTO engoke_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","And they went up, and explored the country, from the wilderness of Zin unto Rechob, to come unto Hamath. ");
INSERT INTO engoke_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","And they went up by the south, and came to Hebron; and there were Achiman, Sheshai, and Talmai, sons of the giants; (and Hebron was built seven years before Tanis of Mizraim.) ");
INSERT INTO engoke_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","And they came to the Stream of Grapes, and cut down there a branch, with one cluster of grapes, and carried it on a staff between two; and (they took also) of the pomegranates, and of the figs. ");
INSERT INTO engoke_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place was called the Stream of Grapes, on account of the grapes (athkela) which the sons of Israel cut down from thence. ");
INSERT INTO engoke_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","And they returned from the exploration of the country at the end of forty days. ");
INSERT INTO engoke_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","And they went and came to Mosheh, and to Aharon, and to all the congregation of the children of Israel at the wilderness of Pharan, at Rekam, and returned the word to them, and to all the congregation, and showed them the fruit of the land. ");
INSERT INTO engoke_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","And they recounted to him, and said: We came to the land whither thou didst send us, and truly it doth produce milk and honey, and this is the fruit of it. ");
INSERT INTO engoke_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But very mighty are the people who inhabit the land, and the cities are fortified and very great; and we saw, also, the sons of the giants there. ");
INSERT INTO engoke_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalkaah dwell in the land of the south, and the Hittaah and Jebusaah and Amoraah dwell in the mountain, and the Kenaanaah dwell by the sea, and upon the bank of the Jordan. ");
INSERT INTO engoke_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","And Kaleb quieted the people for Mosheh, and said: Going, let us go up and possess it, for we are able to (do) it: ");
INSERT INTO engoke_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone up with him said, We are not able to go up against the people, for they are stronger than we. ");
INSERT INTO engoke_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","And they gave forth an evil report (name) about the land which they had explored to the children of Israel, saying: The country which we have passed through to search it, is a land that killeth its inhabitants; ");
INSERT INTO engoke_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","And all the people whom we saw in it are men of stature; and there we saw the giants, the sons of Anak, which are of the giants; and we looked, in our own sight, as locusts, and so were we in their eyes. ");
INSERT INTO engoke_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","And all the congregation lifted up and gave (forth) their voice; and all the people wept that night. ");
INSERT INTO engoke_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","And all the children of Israel murmured against Mosheh and Aharon; and the whole congregation said to them, O that we had died in the land of Mizraim, or that we had died in this wilderness! ");
INSERT INTO engoke_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","And why is the Lord bringing us to this land, that we may fall by the sword, and our wives and our children become a prey? Would it not be better for us to return into Mizraim? ");
INSERT INTO engoke_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","And they said, a man to his brother, Let us appoint a chieftain, and go back into Mizraim. ");
INSERT INTO engoke_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","And Mosheh and Aharon fell upon their faces before all the assembly of the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","And Jehoshua bar Nun, and Kaleb bar Jephuneh, who were of the explorers of the land, rent their clothes. ");
INSERT INTO engoke_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","And they spake to all the congregation of the sons of Israel, saying: The land, which we passed through to explore it, is a good land, most exceedingly. ");
INSERT INTO engoke_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If the Lord hath pleasure in us, even He will bring us into this land, and give us the land which produceth milk and honey. ");
INSERT INTO engoke_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only be not rebellious against the Word of the Lord, nor be afraid of the people of the land, for they are delivered into our hand; their strength is departed from them, and the Word of the Lord is our helper: fear them not. ");
INSERT INTO engoke_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","But all the congregation said that they would stone them with stones. And the Glory of the Lord was revealed at the tabernacle of ordinance, unto all the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","And the Lord said to Mosheh, How long will this people provoke Me, and how long will they disbelieve in My Word, for all the signs which I have wrought among them? ");
INSERT INTO engoke_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will smite them with the pestilence and consume them; and will make of thee a people greater and stronger than they. ");
INSERT INTO engoke_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","But Mosheh said before the Lord, And the Mizraee will hear of it; for Thou didst bring up by Thy power this people from among them, ");
INSERT INTO engoke_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","And they will tell unto the inhabitants of this land; for they have heard that Thou, O Lord, dost dwell in Thy Shekinah among this people, whose eyes behold the glorious Shekinah of the Lord, and that Thy Cloud overshadoweth them, and that in the pillar of the Cloud Thou conductest them in the day, and in the pillar of Fire by night. ");
INSERT INTO engoke_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Now if Thou shalt kill this people as one man, the nations who have heard the fame of Thy power will speak, saying: ");
INSERT INTO engoke_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Because there was not strength (enough) before the Lord to bring this people into the land which He covenanted to them, He hath killed them in the desert. ");
INSERT INTO engoke_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","And now I beseech, let power be magnified from before the Lord, as Thou hast thus spoken, saying: ");
INSERT INTO engoke_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","The Lord is far from anger, and great in performing goodness and truth: forgiving iniquity and rebellion and sins, pardoning them who return unto His law: but acquitting not them who will not, turn, (but) visiting the sins of the fathers upon the rebellious children unto the third and unto the fourth generation. ");
INSERT INTO engoke_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardon, I beseech, the sins of this people according to the amplitude of Thy goodness, and as Thou hast forgiven this people from Mizraim until now. ");
INSERT INTO engoke_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","And the Lord said, I have pardoned according to thy word. ");
INSERT INTO engoke_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Yet, as I live, with the glory of the Lord shall all the earth be filled. ");
INSERT INTO engoke_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Because all these men who have seen My glory, and the signs I wrought in Mizraim and in the desert, but have tempted before Me these ten times, and have not been obedient to My Word, ");
INSERT INTO engoke_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","if they shall see the land which I covenanted to their fathers, nor shall any see it who have provoked before Me. ");
INSERT INTO engoke_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But My servant Kaleb, for that there was in him another spirit, and that he hath wholly followed (in) My fear, him will I bring into the land whither he went, and his children shall possess it. ");
INSERT INTO engoke_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Now the Amalkaah and the Kenaanaah dwelt in the valley. Tomorrow, turn you and get you to the wilderness by the way of the Sea of Suph. ");
INSERT INTO engoke_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","And the Lord spake with Mosheh and unto Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","How long shall this evil congregation be murmuring against Me? The murmuring of the sons of Israel which they murmur against Me is heard before Me. ");
INSERT INTO engoke_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Say to them, As I live, saith the Lord, even as ye have spoken before Me, so will I do to you. ");
INSERT INTO engoke_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","In this wilderness shall your carcases fall, and all who are numbered of you, of all your numbers, from one of twenty years and upward who have murmured against me. ");
INSERT INTO engoke_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","If you shall come into the land in which I covenanted in My Word to cause you to dwell, except Kaleb bar Jephuneh, and Jehoshua bar Nun. ");
INSERT INTO engoke_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But your children, of whom you said they were for a prey, will I bring in, and they shall know the land which you have abhorred. ");
INSERT INTO engoke_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But your carcases shall fall in this wilderness; ");
INSERT INTO engoke_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","And your children shall go about in the wilderness forty years, and shall bear your iniquities until your carcases be laid in the wilderness. ");
INSERT INTO engoke_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","According to the number of the days in which you explored the land, forty days, a day for a year, a day for a year, you shall receive for your sins, even forty years, and you shall know (the consequence of) your murmuring against me. ");
INSERT INTO engoke_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, the Lord, have made the decree in My Word, if I will not do unto all this evil congregation who have gathered together against Me; in this wilderness shall they find their end, and here shall they die. ");
INSERT INTO engoke_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","And the men whom Mosheh sent to search the land, and who returned to make all the congregation murmur against him, by bringing forth an evil name upon the land; ");
INSERT INTO engoke_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Those men who brought out the evil name upon the land died by the plague before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Jehoshua bar Nun and Kaleb bar Jephuneh lived, of those men who went to explore the land. ");
INSERT INTO engoke_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","And Mosheh told these words to all the children of Israel, and the people bewailed greatly. ");
INSERT INTO engoke_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","And they arose in the morning to go up to the top of the mountain, saying: Behold, we will go up to the place of which the Lord hath spoken; for we have sinned. ");
INSERT INTO engoke_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Mosheh said, Wherefore do you transgress against the decree of the Word of the Lord? But it will not prosper. ");
INSERT INTO engoke_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Go not up, for the Shekinah of the Lord is not among you, and be not broken before your enemies. ");
INSERT INTO engoke_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For the Amalkaah and the Kenaanaah are there before you, and you will fall by the sword; for, because you have turned away from the service of the Lord, the Word of the Lord will not be your helper. ");
INSERT INTO engoke_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Yet they would commit the wickedness of going up to the summit of the mountain, though the ark of the Lord’s covenant, and Mosheh, removed not from the midst of the camp. ");
INSERT INTO engoke_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","And the Amalkaah and the Kenaanaah who dwelt in the mountain came down and smote them, and pursued them unto Hormah. ");
INSERT INTO engoke_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Speak with the children of Israel, and say to them: When you shall (at last) have come into the land which I will give you, ");
INSERT INTO engoke_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","and you will make an oblation before the Lord, a burnt offering, or a consecrated sacrifice for the release of a vow, or in a free-will offering, or in your solemnities to render an acceptable service before the Lord, from the herd or from the flock; ");
INSERT INTO engoke_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","let him who offereth his oblation before the Lord bring for a mincha a tenth of flour sprinkled with the fourth of a hina of oil. ");
INSERT INTO engoke_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","And wine for a libation the fourth of a hina shall he make upon the burnt offering, or hallowed sacrifice, for one lamb: ");
INSERT INTO engoke_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Or for a ram he shall make a mincha of two-tenths of flour sprinkled with the third of a hina of oil; ");
INSERT INTO engoke_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","And wine for the libation thou shalt bring the third of a hina, to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","And when thou makest a bullock a burnt offering, or a hallowed sacrifice for the release of a vow, or hallowed sacrifices before the Lord, ");
INSERT INTO engoke_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","let him bring with the bullock a mincha of three tenths of flour sprinkled with a half hina of oil; ");
INSERT INTO engoke_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","And wine shalt thou bring for the libation the half of a hina, an oblation to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","So shalt thou do for one bullock, or one ram, or one lamb from the lambs, or from the kids. ");
INSERT INTO engoke_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","According to the number that you perform so shall you do with each, according to their number. ");
INSERT INTO engoke_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","All native-born (Hebrews) shall do these things to offer an oblation to be received with favour before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","And if a sojourner who sojourneth with you, or whoever among you in your generations will make an oblation to be received with favour before the Lord, as you do, so shall he do. ");
INSERT INTO engoke_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","One congregation and one rite shall be for you and for the sojourners who sojourn; it is an everlasting statute; as you are, so shall the sojourner be before the Lord: ");
INSERT INTO engoke_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","One law and one judgment shall be for you and for the sojourners who dwell with you. ");
INSERT INTO engoke_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Speak with the sons of Israel, and say to them, When you have come into the land into which I will bring you, ");
INSERT INTO engoke_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","and when you eat of the bread of the land, you shall set apart a separation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Of the first of your food you shall set apart a cake for a separation; as the separation of the threshing-floor, so shall you set it apart; ");
INSERT INTO engoke_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Of the first of your bread (dough) you shall give the separation before the Lord in your generations. ");
INSERT INTO engoke_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","And should you be in ignorance, and not do all these commandments of which the Lord hath spoken with Mosheh, ");
INSERT INTO engoke_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Even all which the Lord commanded you by the hand of Mosheh from the day that the Lord commanded and thenceforward in your generations, ");
INSERT INTO engoke_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","It shall be that if anything be hid from the eyes of the congregation and you do ignorantly, then all the congregation shall make a burnt offering of one young bullock, to be received with acceptance before the Lord, with his mincha and his libation, according to the proper manner, and one kid of the goats for a sin offering: ");
INSERT INTO engoke_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","And the priest shall make atonement for all the congregation of the sons of Israel, and it shall be forgiven them, for it was ignorance; but they shall bring their oblation before the Lord on account of their ignorance. ");
INSERT INTO engoke_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","And it shall be forgiven to all the congregation of the children of Israel, and to the sojourners who sojourn among them; for all the people (were) in ignorance. ");
INSERT INTO engoke_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","And if one sin ignorantly, he shall bring a female kid of the year for a sin offering; ");
INSERT INTO engoke_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","And the priest shall make atonement for the man who hath erred in his sin through ignorance before the Lord, to atone for him, and it shall be forgiven him. ");
INSERT INTO engoke_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","For the native-born of the sons of Israel, and for the sojourner who sojourneth among you, one law shall there be for you, for him who acteth in ignorance. ");
INSERT INTO engoke_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the man who doeth presumptuously, whether of the native-born, or of the sojourners, he provoketh the Lord to anger, and that man shall perish from among his people: ");
INSERT INTO engoke_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he hath despised the word of the Lord, and hath made His commandment vain, that man shall be utterly destroyed, his sin is upon him. ");
INSERT INTO engoke_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","And while the children of Israel were in the wilderness, they found a man stealing wood on the day of the Sabbath; ");
INSERT INTO engoke_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","And they who had found him stealing wood brought him to Mosheh and Aharon, and to all the congregation. ");
INSERT INTO engoke_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","And they bound him in the house of custody; for it had not been explained to them what they should do to him. ");
INSERT INTO engoke_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","And the Lord said unto Mosheh, The man shall be surely put to death; all the congregation shall stone him with stones without the camp. ");
INSERT INTO engoke_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","And all the congregation brought him forth without the camp, and stoned him with stones, and he died; as the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","And the Lord spake to Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Speak with the children of Israel, and bid them that they make them fringes upon the borders of their garments throughout their generations, and that upon the fringes on the borders they put a ribbon of hyacinth. ");
INSERT INTO engoke_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","And they shall be to you for fringes, that you may look upon it, and remember all the commandments of the Lord, and do them, and not wander after the imagination of your heart, or after the sight of your eyes, after which you have gone astray. ");
INSERT INTO engoke_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","That you may remember and do all My precepts, and be saints before your God. ");
INSERT INTO engoke_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the Lord your God who brought you forth from the land of Mizraim to be to you Eloha: I am the Lord your God. ");
INSERT INTO engoke_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","But Korack bar zhar bar Kahath bar Levi, and Dathan and Abiram the sons of Eliab, and On bar Pelath of the Beni Reuben, made a division. ");
INSERT INTO engoke_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","And they rose up in the presence of Mosheh with (other) men of the sons of Israel, two hundred and fifty, chiefs of the congregation, who at the time of the convocation had been men of name. ");
INSERT INTO engoke_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","And they gathered together against Mosheh, and against Aharon, and said to them, You are too great; for the whole of the congregation are all of them holy, and the Lord’s Shekinah dwelleth among them: wherefore then are you lifted up above the church (congregation) of the Lord? ");
INSERT INTO engoke_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","And Mosheh heard, and fell upon his face. ");
INSERT INTO engoke_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","And he spake with Korach, and with all the congregation, saying: In the morning the Lord will make blown who it is who pertaineth to Him, and who bath been consecrated to approach to His presence; and whosoever He shall appoint shall go near unto His service. ");
INSERT INTO engoke_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","This do: Take you censers, Korach and all his congregation; ");
INSERT INTO engoke_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","And put fire in them, and put sweet incense upon it before the Lord tomorrow: and the man whom the Lord will choose, he shall be holy. You have too much, sons of Levi. ");
INSERT INTO engoke_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","And Mosheh said to Korach, Hear now, sons of Levi: ");
INSERT INTO engoke_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is it a little thing with you that the God of Israel hath separated you from the congregation of Israel to bring you near before Him to perform the service of the Lord’s tabernacle, and to stand before the congregation to minister to them? ");
INSERT INTO engoke_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","But He hath brought thee nigh, and all thy brethren the sons of Levi with thee: and seek you now the High Priesthood also? ");
INSERT INTO engoke_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Therefore thou and all thy company have gathered together against the Lord. And Aharon, what is he, that you murmur against him? ");
INSERT INTO engoke_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","And Mosheh, sent to call Dathan and Abiram, the sons of Eliab; but they said, We will not come up. ");
INSERT INTO engoke_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it a trifle that thou hast brought us from a land making milk and honey to kill us in the desert, that thou mayest domineer and rule over us? ");
INSERT INTO engoke_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Neither hast thou brought us into the land that maketh milk and honey, to give us an inheritance of fields and vineyards: wilt thou blind the eyes of these men? We will not come up. ");
INSERT INTO engoke_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","And Mosheh was greatly angered, and said before the Lord, Receive not Thou their offering: I have not taken one ass from them, neither have I injured one of them. ");
INSERT INTO engoke_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","And Mosheh said to Korach, Be thou and all thy company prepared before the Lord, thou and they and Aharon tomorrow. ");
INSERT INTO engoke_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","And take every man his censer, and put sweet incense upon them, each man to offer before the Lord (with) his censer. ");
INSERT INTO engoke_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","And they took every man his censer, and set fire in it, and put sweet incense thereon, and stood at the door of the tabernacle of ordinance, with Mosheh and Aharon. ");
INSERT INTO engoke_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","And Korach assembled with him all the company at the door of the tabernacle of ordinance. And the glory of the Lord was revealed to all the congregation. ");
INSERT INTO engoke_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","And the Lord spake with Mosheh and to Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Separate yourselves from among this company, and I will consume them at once. ");
INSERT INTO engoke_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","But they fell upon their faces, and said, O God, the God of the spirits of all flesh, shall one man sin, and thou be wroth with all the congregation? ");
INSERT INTO engoke_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Speak with the congregation, saying: Get you up from among the tents of Korach, Dathan, and Abiram. ");
INSERT INTO engoke_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","And Mosheh arose and went unto Dathan and Abiram, and the elders of Israel followed him. ");
INSERT INTO engoke_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","And he spake with the congregation, saying: Remove now from the tents of these guilty men, and touch not anything that is theirs, lest you be stricken with all their sins. ");
INSERT INTO engoke_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","And they gat up from the tents of Korach, Dathan, and Abiram round about; and Dathan and Abiram came out, and stood at the door of their tents, with their wives, and their sons, and their families. ");
INSERT INTO engoke_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","And Mosheh said: By this shall you know that the Lord hath sent me to do all these works, because (I do them) not of my own will: ");
INSERT INTO engoke_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die the death of all men, and the visitation of all men be visited upon them, the Lord hath not sent me. ");
INSERT INTO engoke_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the Lord create a creation, and the earth open her mouth, and swallow them up, and all that is theirs, and they go down alive into Sheul, then you will know that these men have caused anger before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","And it was, when he had finished to speak all these words, that the ground under them clave asunder, ");
INSERT INTO engoke_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","and the earth opened her mouth, and swallowed them up, and the men of their houses; and all the men of Korach, and all their substance, ");
INSERT INTO engoke_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","they, and all who were theirs, went down alive into Sheul; and the earth closed upon them, and they perished from among the congregation. ");
INSERT INTO engoke_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","And all Israel who stood round about them fled from their cry; for they said, Lest the earth swallow us. ");
INSERT INTO engoke_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","And fire came out from before the Lord, and consumed the two hundred and fifty men who had offered the sweet incense. ");
INSERT INTO engoke_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Speak to Elazar bar Aharon the priest, that he take out the censers from among the burnings, and throwaway the fire, for they are consecrated. ");
INSERT INTO engoke_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","The censers of those guilty men who sinned against their souls, let him make of them beaten plates, to cover the altar; for they had offered them before the Lord, and they are consecrated; and they shall be for a sign unto the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","And Elazar the priest took the golden censers, with which they who were burned had offered, and beat them abroad, for a covering for the altar, ");
INSERT INTO engoke_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","to be a memorial to the sons of Israel, that no strange man who is not of the seed of Aharon shall approach to burn sweet incense before the Lord, and that he be not as Korach and his company, as the Lord had said to him by the hand of Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","But on the day which followed, all the congregation of the sons of Israel murmured against Mosheh and against Aharon, saying: You have caused the death of the Lord’s people. ");
INSERT INTO engoke_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","And it was, while the congregation gathered against Mosheh and against Aharon, that they looked toward the tabernacle of ordinance; and, behold, the cloud covered it, and the glory of the Lord was revealed. ");
INSERT INTO engoke_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","And Mosheh and Aharon went up before the tabernacle of ordinance; ");
INSERT INTO engoke_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","separate yourselves from the midst of this congregation, that I may now consume them. But they fell upon their faces. ");
INSERT INTO engoke_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","And Mosheh said to Aharon: Take the censer, and put fire upon it from the altar, and lay on sweet incense, and go quickly to the congregation, and make atonement for them; for anger hath gone forth from before the Lord, the plague hath begun. ");
INSERT INTO engoke_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","And Aharon took, as Mosheh had said, and ran into the midst of the congregation, and, behold, the plague had begun among the people; and he put on sweet incense and made atonement for the people. ");
INSERT INTO engoke_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","And he stood between the dead and the living, and the plague ceased. ");
INSERT INTO engoke_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","But they who died of the plague were fourteen thousand and seven hundred, beside those who died on account of the matter of Korach. ");
INSERT INTO engoke_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","And Aharon returned to Mosheh, unto the door of the tabernacle of ordinance, and the plague ceased. ");
INSERT INTO engoke_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Speak with the sons of Israel, and take from them severally a rod, according the house of their fathers, twelve rods, and write thou the name of each man upon his rod. ");
INSERT INTO engoke_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","And upon the rod of Levi thou shalt write the name of Aharon; for one rod (only) there shall be for each chief of their father’s house. ");
INSERT INTO engoke_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","And thou shalt lay them up in the tabernacle of ordinance before the testimony, where I will appoint My Word to be with thee. ");
INSERT INTO engoke_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","And it shall be that the rod of the man whom I will choose shall bud; and I will make to cease from before Me the murmuring; of the sons of Israel, with which they have murmured against you. ");
INSERT INTO engoke_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","And Mosheh spake with the sons of Israel; and all their chiefs gave to him, every chief one rod, according to the house of their fathers, twelve rods. And Aharon’s rod was among their rods. ");
INSERT INTO engoke_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","And Mosheh laid up the rods before the Lord in the tabernacle of the testimony. ");
INSERT INTO engoke_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","And it came to pass on the following day, that Mosheh went into the tabernacle of the testimony; and, behold, the rod of Aharon of the house of Levi had germinated, and produced branches, and had blossomed, and ripened almonds. ");
INSERT INTO engoke_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","And Mosheh brought out all the rods from before the Lord unto all the sons of Israel, and they recognized and took every man his rod. ");
INSERT INTO engoke_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","And the Lord said to Mosheh: Take back Aharon’s rod before the testimony, to be kept for a sign unto the rebellious people, that their murmurings before Me may come to an end, and they die not. ");
INSERT INTO engoke_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","And Mosheh did as the Lord commanded, so did he. ");
INSERT INTO engoke_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","And the children of Israel spake to Mosheh, saying: Behold, some of us are slain with the sword; and, behold, some are swallowed up by the earth; and, behold, some perish with the plague. ");
INSERT INTO engoke_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Whoever, approaching, approacheth the tabernacle of the Lord dieth; behold, we are consumed with death. ");
INSERT INTO engoke_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","And the Lord said to Aharon: Thou and thy sons, and the house of thy fathers with thee, shall make reconciliation on account of transgressions (against) the sanctuary; and thou and thy sons with thee shall make atonement for the sins of your priesthood. ");
INSERT INTO engoke_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","And thy brethren also of the tribe of Levi, the tribe of thy father, bring with thee, and let them be added with thee, to serve thee; but thou and, thy sons with thee (shall minister) before the tabernacle of the testimony. ");
INSERT INTO engoke_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","And they shall keep thy charge, and the charge of all the tabernacle; but to the vessels of the sanctuary and of the altar they (the Levites) shall not approach, that neither they nor you may die. ");
INSERT INTO engoke_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","And they shall be joined, with thee, and keep charge of the tabernacle of ordinance for all the service of the tabernacle, and a stranger shall not come near you. ");
INSERT INTO engoke_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","And they shall keep charge of the sanctuary and of the altar, that there may be no more wrath upon the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","And, behold, I have taken your brethren, the Levites, from among the sons of Israel; as a gift are they given to you before the Lord, to perform the service of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But thou, and thy sons with thee, take charge of your priesthood, for everything about the altar and within the veil you shall fulfil the service; the ministry of the priesthood I have given you as a gift, and the stranger who cometh near shall die. ");
INSERT INTO engoke_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","And the Lord said to Aharon: Behold, I have given to thee the charge of My separated things; of all that are consecrated by the sons of Israel unto thee have I given them, and to thy sons, on account of the anointing, by an everlasting statute. ");
INSERT INTO engoke_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This shall be thine of the most holy things which remain from the fire, of all their oblations, and of all their minchas, and of all their sin offerings, and of all their trespass offerings which they render before Me; they are most sacred to thee and to thy sons. ");
INSERT INTO engoke_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","In the sanctuary thou mayest eat thereof, every male may eat it, to thee it shall be consecrated. ");
INSERT INTO engoke_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","And this is thine: the separated things of their minchas, of all the elevations of the sons of Israel, to thee have I given them, and to thy sons, and to thy daughters with thee, by an everlasting statute: everyone who is clean in thy house may eat thereof. ");
INSERT INTO engoke_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","All the best of the oil, and all the best of the wine, and the wheat, the firstfruits of them which they present before the Lord, unto thee I have given them. ");
INSERT INTO engoke_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The firstfruits of all that is on their land which they present before the Lord shall be thine; everyone in thy house who is clean may eat thereof. ");
INSERT INTO engoke_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Everything devoted in Israel shall be thine. ");
INSERT INTO engoke_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Whatever openeth the womb of all flesh which they offer before the Lord, of man, or of beast, shall be for thee; but thou shalt surely redeem the firstborn of man, and the firstling of an unclean animal thou shalt redeem; ");
INSERT INTO engoke_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","And his redemption shall be at the age of one month; thou shalt redeem with the price of five shekes, in the shekel of the sanctuary it is ten meahs: ");
INSERT INTO engoke_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But the firstling of an ox, or of a sheep, or of a goat, thou mayest not redeem, they are consecrated; thou shalt sprinkle their blood upon the altar, and burn their fat, an oblation to be accepted before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","But their flesh shall be for thee, as the breast of the elevation, and the right shoulder, they shall be thine. ");
INSERT INTO engoke_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the consecrated separations which the sons of Israel set apart before the Lord, I have given to thee and to thy children with thee by an everlasting covenant; an everlasting covenant of salt it is before the Lord, with thee, and thy children with thee. ");
INSERT INTO engoke_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","And the Lord said to Aharon: In their land thou wilt not have possession, nor will thine be a portion among them; the gifts that I have given thee, they are thy portion and thy inheritance among the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","And to the sons of Levi, behold, I have given all the tenths in Israel for a possession, on account of the service with which they serve in the ministry of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","But the children of Israel must no more come nigh to the tabernacle of ordinance, to contract guilt and to die. ");
INSERT INTO engoke_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","But the Levites shall perform the service of the tabernacle of ordinance, and shall bear their iniquity; a statute forever unto your generations. And among the sons of Israel they shall not possess an inheritance; ");
INSERT INTO engoke_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","For the tenths of the children of Israel which they set apart before the Lord for a separation, I have given to the Levites for a possession; therefore have I said to them, Among the sons of Israel you shall not possess an inheritance. ");
INSERT INTO engoke_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Speak also to the Levites, and say to them, When you take from the sons of Israel the tenths which I have given you of theirs, you shall set apart from them a separation before the Lord, a tenth of the tenth. ");
INSERT INTO engoke_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","And your separation shall be reckoned to you as the corn from the threshing-floor, and as the wine of the wine-press; ");
INSERT INTO engoke_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","So shall you set apart the separation before the Lord of all your tenths that you receive from the sons of Israel, and give thereof a separation before the Lord unto Aharon the priest. ");
INSERT INTO engoke_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Of all that is given to you ye shall set apart every separation for the Lord, of all the best of it, to be the hallowed portion thereof. ");
INSERT INTO engoke_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","And say thou to them, When you have set apart the finest of it, it shall be reckoned to the Levites as the produce of the threshing-floor, and as the fruitage for the wine-press; ");
INSERT INTO engoke_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","And you may eat it in every place, you and the men of your house; for it is a remuneration to you on account of your service in the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","And you shall not contract guilt by it in your setting apart the finest of it, nor profane the consecrated things of the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","And the Lord spake with Mosheh and to Aharon, saying: ");
INSERT INTO engoke_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","This is the decree of the law which the Lord hath commanded, saying: Speak to the sons of Israel that they bring to thee a red heifer, unblemished, with no spot in her, and upon which no yoke hath been put. ");
INSERT INTO engoke_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","And you shall give her unto Elazar the priest, that he may bring her without the camp, and (one) shall slaughter her before him. ");
INSERT INTO engoke_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","And Elazar, the priest, shall take (some) of her blood with his finger, and sprinkle of her blood against the face of the tabernacle of ordinance seven times. ");
INSERT INTO engoke_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","And (one) shall burn the heifer before his eyes; her skin, and her flesh, and her blood, with her food shall he burn. ");
INSERT INTO engoke_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","And the priest shall take cedar wood, and hyssop, and scarlet, and cast it into the midst of the burning of the heifer. ");
INSERT INTO engoke_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","And the priest shall wash his clothes, and bathe his flesh in water, and afterwards come into the camp: but the priest shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","And he who burneth her shall wash his clothes with water, and bathe his flesh in water, and be unclean until evening. ");
INSERT INTO engoke_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","And a man who is clean shall gather up the ashes of the heifer, and lay them up without the camp in a clean place, and it shall be for the congregation of the children of Israel to keep, for the sprinkling with water; it is (a purification) for sin. ");
INSERT INTO engoke_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","And he who gathereth up the ashes of the heifer shall wash his raiment, and be unclean until the evening; and it shall be for the children of Israel, and for the strangers who dwell among you, a statute forever. ");
INSERT INTO engoke_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Whosoever toucheth the dead of any of mankind shall be unclean seven days. ");
INSERT INTO engoke_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He shall sprinkle with it on the third day, and on the seventh day shall be clean; but if he sprinkle it not on the third day, on the seventh day he shall not be clean. ");
INSERT INTO engoke_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Whoever toucheth the dead body of a man who hath died, and sprinkleth not with it, defileth the tabernacle of the Lord; and that man shall be cut off from Israel: because the water of sprinkling is not sprinkled upon him, he shall be unclean, (for) his uncleanness is yet upon him. ");
INSERT INTO engoke_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","This is the law when a man dieth in a tent: everyone who entereth the tent, and everyone who is in the tent, shall be unclean seven days. ");
INSERT INTO engoke_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","And every open earthen vessel which hath not a covering fastened upon it round about is unclean. ");
INSERT INTO engoke_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","And whoever toucheth one who is slain with the sword upon the face of the field, or a dead body, or the bone of a man, or a grave, shall be unclean seven days. ");
INSERT INTO engoke_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","And for the unclean person they shall take of the ashes of the burnt sin offering, and put spring water upon it in a vessel. ");
INSERT INTO engoke_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","And a man who is clean shall take hyssop, and dip it in the water, and sprinkle upon the tent, and upon every vessel, and upon the persons who are there, and upon him who had touched the bone, or the slain, or the dead body, or the grave. ");
INSERT INTO engoke_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","And the clean person shall sprinkle the unclean on the third day, and on the seventh day; and on the seventh day he shall be clean; and shall sprinkle his raiment, and wash with water, and at the evening he shall be clean. ");
INSERT INTO engoke_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But the man who is unclean, and it bath not been sprinkled upon him, shall be cut off from the congregation, because he would defile the sanctuary of the Lord. The water of sprinkling was not sprinkled upon him; he is unclean. ");
INSERT INTO engoke_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","And it shall be to them for an everlasting statute, that he who applieth the water of sprinkling shall wash his clothes, and whoever toucheth the water of sprinkling shall be unclean until the evening; ");
INSERT INTO engoke_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","And whatever may be touched by the unclean person shall be unclean, and the man who toucheth it shall be unclean until the evening. ");
INSERT INTO engoke_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","And the children of Israel, the whole congregation, came to the wilderness of Zin in the first month, and the people abode in Rekem; and Miriam died there, and was buried there. ");
INSERT INTO engoke_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","And there was no water for the congregation; and they gathered against Mosheh and against Aharon; ");
INSERT INTO engoke_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","And the people were contentious with Mosheh, and spake, saying, Would that we had died when our brethren died before the Lord! ");
INSERT INTO engoke_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","And why have you brought the congregation of the Lord into this wilderness, that we and our cattle may die here? ");
INSERT INTO engoke_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","And wherefore have you made us come up from Mizraim, to bring us into this evil place? This is not a place for sowing; here are neither fig trees, nor vines, nor pomegranates, neither is there water to drink. ");
INSERT INTO engoke_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","And Mosheh and Aharon went up from before the congregation unto the door of the tabernacle of ordinance, and fell upon their faces; and the glory of the Lord was revealed to them. ");
INSERT INTO engoke_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","And the Lord spake with Mosheh, saying, ");
INSERT INTO engoke_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Take the rod, and gather the congregation together, thou and Aharon thy brother, and speak to the Rock, before their eyes, and it shall give its waters; and thou shalt bring forth water for them from the rock, and give drink to the congregation and their cattle. ");
INSERT INTO engoke_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","And Mosheh took the rod from before the Lord, as He had commanded him. ");
INSERT INTO engoke_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","And Mosheh and Aharon assembled the congregation before the rock; and he said to them: Hear now, rebels! Are we to draw forth water for you from this rock? ");
INSERT INTO engoke_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","And Mosheh lifted up his hand, and smote the rock with the rod two times; and the waters came forth greatly, and the congregation drank and their cattle. ");
INSERT INTO engoke_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","But the Lord spake unto Mosheh and Aharon: Because you have not believed in My Word to sanctify Me in the eyes of the sons of Israel, therefore you shall not bring this congregation into the land that I have given them. ");
INSERT INTO engoke_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These are the Waters of Strife, because the sons of Israel strove before the Lord, and He was sanctified in them. ");
INSERT INTO engoke_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","And Mosheh sent ambassadors from Rekem to the king of Edom: Thus saith thy brother Israel, Thou knowest all the trouble we have found; ");
INSERT INTO engoke_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","That our fathers went down into Mizraim, and we dwelt in Mizraim many days, and the Mizraee badly treated us and our fathers. ");
INSERT INTO engoke_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","And we prayed before the Lord, and He accepted our prayers, and sent an Angel, and brought us out from Mizraim; and, behold, we are in Rekem, a city which is on the side of thy border. ");
INSERT INTO engoke_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Let us now pass through thy country: we will not go through a field or through a vineyard, nor will we drink up the water of the cistern: on the king’s highway will we travel; we will not turn to the right hand or to the left until we have passed through thy border ");
INSERT INTO engoke_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But Edomea said to him, Thou shalt not pass through my border, lest I come out against thee with the slaughtering sword. ");
INSERT INTO engoke_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","And the sons of Israel said to him, We would go up by the trodden way; and if we drink of thy water, I and my cattle, we will give thee the price of it; we will do nothing evil; upon my feet I will pass through. ");
INSERT INTO engoke_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But he said, Thou shalt not pass through. And Edomea came out to meet him with great force and with a strong hand. ");
INSERT INTO engoke_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","So Edomea refused to permit Israel to go through his border; and Israel turned away from him. ");
INSERT INTO engoke_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","And they went forward from Rekem, and all the congregation of the children of Israel came to Mount Hor. ");
INSERT INTO engoke_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","And the Lord spake to Mosheh and to Aharon at Mount Hor, by the coast of the land of Edom, saying: ");
INSERT INTO engoke_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aharon shall be gathered unto his people; for he shall not enter into the land which I have given to the children of Israel, because you rebelled against My Word at the waters of strife. ");
INSERT INTO engoke_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aharon and Elazar his son, and bring them up to Mount Hor; ");
INSERT INTO engoke_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","And strip Aharon of his vestments, and put them upon Elazar his son; and Aharon shall be gathered (to his people), and shall die there. ");
INSERT INTO engoke_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","And Mosheh did as the Lord commanded, and they went up to Mount Hor before the eyes of all the congregation. ");
INSERT INTO engoke_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","And Mosheh took off his garments from Aharon, and put them upon Elazar his son. And Aharon died there, on the summit of the mount. And Mosheh and Elazar came down from the mount. ");
INSERT INTO engoke_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","And all the congregation saw that Aharon was dead; and all the house of Israel bewailed Aharon thirty days. ");
INSERT INTO engoke_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","And when the Kenaanah, king Arad, who dwelt in the south, heard that Israel was coming by the way of the explorers, he set battle in array against Israel, and took some of them captives. ");
INSERT INTO engoke_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","And Israel vowed a vow before the Lord, and said: If Thou wilt surely deliver this people into my hand, then I will destroy their cities. ");
INSERT INTO engoke_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","And the Lord accepted Israel’s prayer, and gave up the Kenaanaah; and he destroyed them and their cities, and he called the name of the place Charma. ");
INSERT INTO engoke_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","And they journeyed from Mount Hor by the way of the Sea of Suph, to go round from the land of Edom: and the soul of the people was wearied in the way. ");
INSERT INTO engoke_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","And the people murmured (or, growled) against the Word of the Lord, and contended with Mosheh, (saying) Why have you brought us up out of Mizraim to die in the desert? For there is neither bread nor water, and our soul is weary of manna, this light food. ");
INSERT INTO engoke_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","And the Lord sent forth burning serpents among the people, and much people of Israel died. ");
INSERT INTO engoke_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","And the people came to Mosheh, and said: We have sinned, for we have murmured before the Lord, and have contended with thee. Intercede before the Lord, that He may remove the serpents from among us. And Mosheh prayed for the people. ");
INSERT INTO engoke_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","And the Lord said to Mosheh: Make thee a burning (serpent), and uplift it on an ensign; and everyone who hath been bitten, and beholdeth it, shall live (or, be saved). ");
INSERT INTO engoke_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","And Mosheh made a serpent of brass, and set it upon an ensign; and when a serpent had bitten a man, if he looked up to the serpent of brass, he lived (or, was saved). ");
INSERT INTO engoke_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","And the children of Israel journeyed and encamped in Oboth. ");
INSERT INTO engoke_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","And they journeyed from Oboth, and encamped at the Ford of the Passengers, which is in the wilderness over against Moab, toward the sunrise. ");
INSERT INTO engoke_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","And they removed from thence, and encamped by the brook Zared. ");
INSERT INTO engoke_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Thence they journeyed, and pitched on the other side of Arnon, that is in the wilderness that stretcheth out from the coasts of the Amoraah; for Arnon is the border of Moab, between Moab and the Amoraah. ");
INSERT INTO engoke_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Wherefore it is said in the Book of the Wars, That which the Lord did by the Sea of Suph, and the great deeds which (He wrought) by the torrents of Arnon, ");
INSERT INTO engoke_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","And at the flowing of the streams which lead towards Lechayath, and are joined at the confine of Moab. ");
INSERT INTO engoke_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","And from thence was given to them the well, which is the well whereof the Lord spake to Mosheh, Gather the people together, and I will give them water. ");
INSERT INTO engoke_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Therefore sang Israel this song: Spring up, O well; sing ye unto it. ");
INSERT INTO engoke_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The well which the princes digged, the chiefs of the people cut it, the scribes with their staves; it was given to them in the wilderness. ");
INSERT INTO engoke_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","And from (the time) that it was given to them it descended with them to the rivers, and from the rivers it went up with them to the height, ");
INSERT INTO engoke_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","And from the height to the vale which is in the fields of Moab, at the head of Ramatha, which looketh towards Beth Jeshimon. ");
INSERT INTO engoke_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","And Israel sent messengers to Sihon, king of the Amoraah, saying: ");
INSERT INTO engoke_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","I would pass through thy country: I will not turn aside into field or vineyard; we will not drink of the waters of the cistern; by the king’s highway will we go until we have crossed thy border. ");
INSERT INTO engoke_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But Sihon would not permit Israel to pass through his coast; and Sihon gathered all his people, and came out to prevent Israel in the wilderness, and came to Jahaz, and arrayed battle against Israel. ");
INSERT INTO engoke_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","And Israel smote him with the edge of the sword, and took possession of his land from Arnon unto Jabbok, unto the Beni Ammon; for the border of the Beni Ammon was strong. ");
INSERT INTO engoke_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","And Israel subdued all those cities, and Israel dwelt in all the cities of the Amoraah, in Heshbon, and in all the villages thereof. ");
INSERT INTO engoke_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","For Heshbon was the city of Sihon, king of the Amoraah; he had made war with the former king of Moab, and had taken all his territory from his hand unto Arnon. ");
INSERT INTO engoke_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Therefore, say the proverbs: Come to Heshbon; let the city of Sihon be builded and finished: ");
INSERT INTO engoke_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For an east wind strong as fire hath gone out from Heshbon, and the servants of war (as) with a flame from the city of Sihon: they have slain the people who inhabited Lechayath of Moab, the priests who ministered in the idol-temple in the height of Arnona. ");
INSERT INTO engoke_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to you, Moabaee, you are undone, ye people who have worshipped Kemosh; he hath delivered up his besieged sons and his daughters into captivity, unto Sihon, king of the Amoraah. ");
INSERT INTO engoke_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","And the kingdom hath ceased from Heshbon, the dominion hath passed away from Dibon, they have laid waste unto Nophak which joineth Medeba. ");
INSERT INTO engoke_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","And Israel dwelt in the land of the Amoraah. ");
INSERT INTO engoke_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","And Mosheh sent to explore Jaazer; and they subdued the towns, and drave out the Amoraah who were therein. ");
INSERT INTO engoke_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","And they turned and went up by the way of Mathnan; and Og, king of Mathnan, came out to meet them, he and all his people, to give battle at Edrei. ");
INSERT INTO engoke_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","But the Lord said to Mosheh, Fear him not: for I have delivered him into thy hand with all his people and his country; and thou shalt do to him as thou hast done to Sihon, the king of the Amoraah who dwelt in Heshbon. ");
INSERT INTO engoke_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","And they smote him, and his sons, and all his people, until none remained of him who were spared; and they took possession of his land. ");
INSERT INTO engoke_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","And the sons of Israel moved onward, and encamped in the plain of Moab (at some space) from the ford of the Jordan (towards) Jericho. ");
INSERT INTO engoke_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","And Balak bar Zippor saw all that Israel had done to the Amoraah. ");
INSERT INTO engoke_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","And the Moabaah feared before the people greatly, because they were many; yea, the Moabaee were in distress before the sons of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","And Moab said to the elders of Midian, Now will this host consume all that are round about us, as the ox licketh up the herbage of the field. And Balak bar Zippor was the king of Moab at that time. ");
INSERT INTO engoke_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","And he sent messengers to Bileam bar Beor unto Pethor Aram which is upon the Phrat, the land of the sons of his people, to call him, saying: Behold, a people hath come out of Mizraim; lo, they cover the sunshine from the earth, and they are dwelling over against me. ");
INSERT INTO engoke_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Come now, I entreat, curse this people for me, for they are stronger than I: if perhaps I may become able to fight with him, and drive him from the land: for I know that he whom thou blessest is blessed, and he whom thou dost curse is accursed. ");
INSERT INTO engoke_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","And the elders of Moab and of Midian went, with the (price of) divinations in their hands, and came to Bileam, and told him the words of Balak. ");
INSERT INTO engoke_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","And he said to them, Lodge here for the night, and I will return you word, according as the Lord speaketh with me. And the princes of Moab tarried with Bileam. ");
INSERT INTO engoke_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","And a word from before the Lord came unto Bileam, and said, Who are these men who are with thee? ");
INSERT INTO engoke_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","And Bileam said before the Lord, Balak bar Zippor, king of Moab, hath sent to me. ");
INSERT INTO engoke_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Behold, a people are come out of Mizraim, and hide the glance of the sun from the earth. Now come, curse him for me, that I may be able to fight him, and drive him away. ");
INSERT INTO engoke_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","And the Lord said to Bileam, Thou shalt not go with them: thou shalt not curse the people, for he is blessed. ");
INSERT INTO engoke_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","And Bileam arose in the morning, and said to the princes of Balak, Go back to your country; for it is not pleasing before the Lord to permit me to go with you. ");
INSERT INTO engoke_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","And the princes of Moab arose and came to Balak, and said, Bileam refuseth to come with us. ");
INSERT INTO engoke_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","But Balak added to send princes more (in number) and nobler than those. ");
INSERT INTO engoke_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","And they came to Bileam, and said to him: Thus saith Balak bar Zippor: Be not, I beseech thee, hindered from coming to me; ");
INSERT INTO engoke_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","For I will greatly honour thee with honour, and will do all that thou shalt bid me. Come, then, curse me this people. ");
INSERT INTO engoke_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bileam responded, and said to the servants of Balak: If Balak would give me his house full of silver and gold, I have no power to transgress the decree of the Word of the Lord my God, to do either little or great. ");
INSERT INTO engoke_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","But now I beg you tarry here this night, that I may know what yet the Lord will speak unto me. ");
INSERT INTO engoke_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","And word came from before the Lord unto Bileam by night, and said to him: If the men come to call thee, arise and go with them; nevertheless the word that I speak with thee, that thou shalt do. ");
INSERT INTO engoke_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","And Bileam rose up in the morning, and saddled his ass, and went with the princes of Moab. ");
INSERT INTO engoke_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","But the displeasure of the Lord was provoked because he (so) went; and the angel of the Lord stood in the road to withstand him: and he was riding upon his ass, and his two young men with him. ");
INSERT INTO engoke_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","And the ass discerned the angel of the Lord standing in the way with his sword drawn in his hand; and the ass started aside from the road, and went into the field. And Bileam struck the ass to make her to return into the road. ");
INSERT INTO engoke_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","And the angel of the Lord (again) stood in the way of the vineyards in a place where there was a fence here and a fence there. ");
INSERT INTO engoke_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","And the ass discerned the angel of the Lord, and thrust herself to the wall, and drave Bileam’s foot against the wall; and he smote her again. ");
INSERT INTO engoke_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","And the angel of the Lord yet passed on, and stood in a narrow place where there was no way to turn to the right or to the left. ");
INSERT INTO engoke_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","And the ass discerned the angel of the Lord, and fell down under Bileam; and Bileam’s wrath was provoked, and he smote the ass with his staff. ");
INSERT INTO engoke_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","And the Lord opened the mouth of the ass; and she spake to Bileam, What have I done to thee that thou bast smitten me these three times? ");
INSERT INTO engoke_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","And Bileam said to the ass, Because thou hast mocked me: would that there was a sword in my hand! For now would I kill thee. ");
INSERT INTO engoke_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","And the ass said to Bileam, Am I not thy ass, upon whom thou hast ridden from (the time that) I have been thine unto this day? Have I ever been used to do thus to thee? And he said, No. ");
INSERT INTO engoke_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","And the Lord unveiled Bileam’s eyes, and he saw the angel of the Lord standing in the road with his sword unsheathed in his hand: and he bowed, and worshipped upon his face. ");
INSERT INTO engoke_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","And the angel of the Lord said to him, Wherefore hast thou smitten thine ass these three times? Behold, I have come out to withstand thee, because it is seen before me that thou art willing to go in a way contrary to me. ");
INSERT INTO engoke_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","But the ass discerned me, and turned from before me these three times: unless she had turned from before me, now should I have slain thee, and her would I have spared. ");
INSERT INTO engoke_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","And Bileam said to the angel of the Lord, I knew not that thou wast standing before me in the way. And now, if it be evil in thine eyes, I will return. ");
INSERT INTO engoke_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","But the angel of the Lord said to Bileam, Go with the men; only the word that I shall speak with thee, that thou shalt say. And Bileam went with the princes of Balak. ");
INSERT INTO engoke_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","And Balak heard that Bileam was coming, and went forth to meet him, at a city of Moab which is upon the border of Arnon, on the side of the frontier. ");
INSERT INTO engoke_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","And Balak said to Bileam, Did not I sending send for thee to call thee? Why didst thou not come to me? Hast thou not indeed said that I am not able to do thee honour? ");
INSERT INTO engoke_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","And Bileam said to Balak, Behold, I have come to thee: but even now, have’ I really any power to speak anything? The word which the Lord putteth into my mouth I will speak. ");
INSERT INTO engoke_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","And Bileam went with Balak, and they came to a city of his territory. ");
INSERT INTO engoke_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","And Balak slaughtered oxen and sheep, and sent to Bileam and to the princes who were with him. ");
INSERT INTO engoke_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","And when it was morning, Balak took Bileam, and brought him up to the high places of his idol; and he saw from thence the extreme of the people. ");
INSERT INTO engoke_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","And Bileam said to Balak, Build me here seven altars, and prepare me here seven bullocks and seven rams. ");
INSERT INTO engoke_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","And Balak did as Bileam had spoken, and Balak and Bileam offered up a bullock and a ram upon every altar. ");
INSERT INTO engoke_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","And Bileam said to Balak, Remain by thy burnt offering; and I will go, if perhaps the Word may meet me from before the Lord; and the word that He showeth me I will disclose unto thee. And he went solitary. ");
INSERT INTO engoke_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","And the Word from before the Lord met Bileam; and he said to Him; The seven altars have I set in order, and have offered a bullock and a ram upon every altar. ");
INSERT INTO engoke_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","And the Lord put a word upon Bileam’s mouth, and said to him: Return unto Balak, and thus shalt thou speak. ");
INSERT INTO engoke_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","And he returned to him, and, behold, he was standing by his burnt sacrifice, he and all the nobles of Moab. ");
INSERT INTO engoke_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","And he took up his parable, and said: Balak, king of Moab, hath brought me from Aram, From the mountains of the east: Come, curse me, Jakob, Come, hunt down Israel for me. ");
INSERT INTO engoke_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How shall I curse whom God hath not cursed? How shall I persecute whom God hath not? ");
INSERT INTO engoke_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of the mountain I discern him, And look upon him from the heights; Lo, the people by themselves are to possess the world, And among the nations they shall not be judged with consumption. ");
INSERT INTO engoke_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can number the dust of the house of Jakob, Of whom it is said, They shall increase as the dust of the earth, Or of one of the four camps of Israel? Let mine be the death of his truthful ones, And let my end be as theirs! ");
INSERT INTO engoke_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","And Balak said to Bileam, What hast thou done to me? I brought thee to curse my enemies, and, behold, blessing hast thou blessed them. ");
INSERT INTO engoke_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","But he said, That which the Lord hath put in my mouth must I not observe to speak? ");
INSERT INTO engoke_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","And Balak said to him, Come now with me to another place, from whence thou mayest see him, where thou canst see only the outer side, but not the whole, and curse him for me from thence. ");
INSERT INTO engoke_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","And he brought him to the field of the watch-tower on the top of the hill; and builded seven altars, and offered a bullock and a ram on every altar. ");
INSERT INTO engoke_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","And he said to Balak, Stand here by thy burnt offering, and I will go yonder. ");
INSERT INTO engoke_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","And the Word from before the Lord met Bileam, and put a word in his mouth, and said, Return to Balak, and thus speak. ");
INSERT INTO engoke_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","And he came to him, and he was standing by his burnt offering, and the nobles of Moab with him. And Balak said to him, What hath the Lord spoken? ");
INSERT INTO engoke_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","And he took up his parable, and said: Arise, Balak, and hear, Listen to my words, Bar Zippor: ");
INSERT INTO engoke_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","The word of Eloha is not as the words of men; The sons of men speak, but lie; Nor is it as the works of the children of flesh, Who decree to do, but repent, and change their counsels. What He hath said He will perform, And His every word is steadfast. ");
INSERT INTO engoke_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Behold, I have received benedictions to bless Israel, And I may not turn my blessing from him. ");
INSERT INTO engoke_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","I have seen that in the house of Jakob The worshippers of idols are not, Nor in Israel the workers of the work of lies. The Word of the Lord their God is their helper, And the Shekinah of their King is among them. ");
INSERT INTO engoke_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God, who brought them out from Mizraim, Becomes his strength and exaltation. ");
INSERT INTO engoke_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","For no divinations can prosper against the house of Jakob, Nor enchantments against the myriads of Israel. According to the time it shall be said of Jakob and of Israel, What hath Eloah wrought! ");
INSERT INTO engoke_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Behold, the people shall dwell as a lioness, And as a lion shall he lift himself up; Until he hath slain with slaughter, He will not rest in his land, And inherit the treasures of the nations. ");
INSERT INTO engoke_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","And Balak said to Bileam, Neither cursing curse them, nor blessing bless them. ");
INSERT INTO engoke_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Bileam answered and said to Balak, Did I not tell thee, saying, All that the Lord speaketh, that I must do? ");
INSERT INTO engoke_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","And Balak said to Bileam, Come now, I will take thee to another place; perhaps it may be pleasing before the Lord, that thou mayest curse them for me from thence. ");
INSERT INTO engoke_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","And Balak conducted Bileam to the top of the high place that looketh toward the face of Beth Jeshimon. ");
INSERT INTO engoke_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","And Bileam said to Balak, Build me here seven altars, and prepare me here seven bullocks and seven rams. ");
INSERT INTO engoke_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","And Balak did as Bileam had said, and offered a bullock and a ram on every altar. ");
INSERT INTO engoke_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","And Bileam saw that it was appointed before the Lord to bless Israel; and he went not as at those former times to inquire by divinations, but set his face towards the calf that the sons of Israel had made in the wilderness. ");
INSERT INTO engoke_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","And Bileam lifted up his eyes, and beheld Israel dwelling by his tribes; and the Spirit of prophecy rested upon him from before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","And he took up his parable, and said: Bileam, the son of Beor, hath said, The man who saw the Beautiful hath said, ");
INSERT INTO engoke_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","he hath said who heard the Word from before God, Who saw the vision of the Almighty, prostrate when he saw: ");
INSERT INTO engoke_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How goodly is thy land, O Jakob, And the house of thy habitation, O Israel! ");
INSERT INTO engoke_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","As rivers flowing onward; as the watered garden by Euphrates, As aromatics planted by the Lord; as cedars planted by the waters. ");
INSERT INTO engoke_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","The king anointed from his sons shall increase, And have dominion over many nations; His king shall be mightier than Agag, and his kingdom be exalted. ");
INSERT INTO engoke_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God, who brought them from Mizraim, is mighty and high, and by Him Shall Israel use the wealth of the nations their foes, Enjoy the spoils of their kings, and inherit their lands. ");
INSERT INTO engoke_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He reposed in his strength, as the lion and the lioness, And no kingdom may commove him. They who bless thee shall be blessed, And they who curse thee be accursed. ");
INSERT INTO engoke_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","And the anger of Balak was roused against Bileam, and he smote his hands together. And Balak said to Bileam, I called thee to curse my enemies, and, behold, blessing hast thou blessed them these three times! ");
INSERT INTO engoke_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","And now go to thy place. I said, Honouring I would honour thee; but, behold, the Lord hath kept thee back from honour. ");
INSERT INTO engoke_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","But Bileam said to Balak, Did I not also tell the messengers whom thou sentest to me, saying, ");
INSERT INTO engoke_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","If Balak would give me his house full of silver and gold, I have no power to transgress the decree of the Word of the Lord, to do good or evil of my own will; whatsoever the Lord shall sat that will I speak? ");
INSERT INTO engoke_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","And now, behold, I go unto my people. Come, I will give thee counsel what thou shouldst do; and will show thee what this people will do unto thy people at the end of the days. ");
INSERT INTO engoke_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","And he took up his parable, and said: Bileam, the son of Beor, speaketh, The man who saw the Beautiful speaketh, ");
INSERT INTO engoke_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","He speaks who heard the Word from before God, And who knoweth knowledge from the Most High, Who saw the vision of the Almighty, prostrate when he saw. ");
INSERT INTO engoke_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but not now; I behold him, but not nigh. When a king shall arise out of Jakob, And the Meshiha be anointed from Israel, He will slay the princes of Moab, and reign over all the children of men; ");
INSERT INTO engoke_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","And Edom shall be an inheritance, And Seir a possession of his adversaries; But Israel shall prosper in riches. ");
INSERT INTO engoke_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","One will descend from the house of Jakob, Who will destroy him that escapeth from the city of the peoples. ");
INSERT INTO engoke_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","And he looked on the Amalkaah, and took up his parable, and said: Amalek was the beginning of the wars of Israel, But in his end he shall perish forever. ");
INSERT INTO engoke_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","And he beheld the Shalmaah, and took up his parable, and said: Strong is the house of thy dwelling, And in a strong fortress thou hast set thy abode; ");
INSERT INTO engoke_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","But yet Shalmaah shall be destroyed, For Athuria will make thee captive. ");
INSERT INTO engoke_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","And he took up his parable, and said: Woe to the wicked who may live when God doeth this! ");
INSERT INTO engoke_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","And ships will come from the Kittaee, And afflict Athur, and subdue beyond the Phrat; But they also shall perish forever. ");
INSERT INTO engoke_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","And Bileam arose, and went and returned to his place; and Balak also went upon his way. ");
INSERT INTO engoke_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","But Israel abode in Shittin; and the people began to commit whoredom with the daughters of Moab; ");
INSERT INTO engoke_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","And they invited the people to the sacrifices of their idols, and the people did eat and bowed down to their idols. ");
INSERT INTO engoke_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","And Israel was joined unto Baala Pheor, and the anger of the Lord was kindled against Israel. ");
INSERT INTO engoke_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","And the Lord said unto Mosheh: Take all the chiefs of the people, and judge, and slay him who is guilty of death before the Lord, over against the sun, that the fierce anger of the Lord may be turned away from Israel. ");
INSERT INTO engoke_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","And Mosheh said to the judges of Israel: Slay every man his men who have joined themselves to Baala Pheor. ");
INSERT INTO engoke_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","And, behold, a man of the sons of Israel came and brought to his brethren a Midianitha, in the eyes of Mosheh, and in the eyes of all the congregation of the children of Israel, who were weeping at the door of the tabernacle of ordinance. ");
INSERT INTO engoke_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","And Phinehas bar Elazar bar Aharon the priest saw, and arose from the midst of the congregation, and took a lance in his hand; ");
INSERT INTO engoke_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","And he went in after the man, the son of Israel, into the tent, and thrust both of them through, the man, the son of Israel, and the woman, through her belly; and the pestilence was stayed from the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","But they who had died by the pestilence were twenty and four thousand. ");
INSERT INTO engoke_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Phinehas the son of Elazar, the son of Aharon, the priest, hath turned away My anger from the children of Israel, in that he was zealous with My zeal among them; and I have not consumed the children of Israel in My jealousy. ");
INSERT INTO engoke_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Say therefore to him (that), behold, I decree unto him My covenant of peace; ");
INSERT INTO engoke_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","And he shall have it and his sons after him; a covenant of priesthood forever, because he hath been zealous before his God, and hath propitiated for the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","And the name of the man of Israel who was slain with the Midianitess was Zimri bar Salu, a chief of the house of his fathers of the house of Shemeon; ");
INSERT INTO engoke_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","And the name of the woman, the Midianitess, was Kosbe, the daughter of Zur, who was chief of the people of his father’s house in Midian. ");
INSERT INTO engoke_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Punish the Midianites and slay them, ");
INSERT INTO engoke_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","For they afflict you with their snares, with which they ensnare you; as by the occasion of Pheor, and by that of Kosbe, daughter of a prince of Midian, their sister, who was slain on the day of the pestilence in the matter of Pheor. ");
INSERT INTO engoke_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","And it came to pass after the plague, ");
INSERT INTO engoke_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","that the Lord spake to Mosheh and to Elazar bar Aharon the priest, saying: ");
INSERT INTO engoke_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Take the account of all the congregation of the sons of Israel, from a son of twenty years and upwards by the house of their fathers, everyone that goeth out with the host in Israel. ");
INSERT INTO engoke_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","And Mosheh and Elazar the priest spake with them, and directed to number them in the plains of Moab, by the Jordan (over against) Jericho, saying: ");
INSERT INTO engoke_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","From a son of twenty years and upward, as the Lord commanded Mosheh, and the sons of Israel who went forth from the land of Mizraim. ");
INSERT INTO engoke_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben, the first-born of Israel: the sons of Reuben, Hanok, the family of Hanok; Phallu, and the family of Phallu; ");
INSERT INTO engoke_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","of Hezron, the family of Hezron; of Karmi, the family of Karmi. ");
INSERT INTO engoke_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These are the families of Reuben, and they who were numbered of them were forty-three thousand seven hundred and thirty. ");
INSERT INTO engoke_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","And of the sons of Phallu, Eliab; ");
INSERT INTO engoke_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","And the sons of Eliab, Nemuel, and Dathan, and Abiram: these are Dathan and Abiram who called the congregation that gathered against Mosheh and Aharon in the congregation of Korach, in their gathering against the Lord, ");
INSERT INTO engoke_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","when the earth opened her mouth and swallowed them with Korach, and the congregation died, being devoured by the fire, two hundred and fifty men; and they became a sign; ");
INSERT INTO engoke_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","but the sons of Korach died not. ");
INSERT INTO engoke_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The sons of Shimeon by their families: of Nemuel, the family of Nemuel; of Jamin, the family of Jamin; ");
INSERT INTO engoke_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","of Zerach, the family of Zerach; of Shaul, the family of Shaul. ");
INSERT INTO engoke_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These are the families of Shemeon, twenty-two thousand two hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The sons of Gad after their families; of Zephon, the family of Zephon; of Haggi, the family of Haggi; of Shumi, the family of Shumi; of Aggi, the family of Aggi; ");
INSERT INTO engoke_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Of Ozni, the family of Ozni; of Heri, the family of Heri; ");
INSERT INTO engoke_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","of Arod, the family of the Arodi of Areli, the family of Areli. ");
INSERT INTO engoke_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These are the families of the Beni Gad, the number of whom was forty thousand five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Of the sons of Jehudah, Her and Onan: but Her and Onan died in the land of Kenaan; ");
INSERT INTO engoke_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Of the sons of Jehudah after their families: of Shelah, the family of Shelah; of Pherez, the family of Pherez; of Zerach, the family of Zerach. ");
INSERT INTO engoke_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Of the sons of Pherez: of Hezron, the family of Hezron; of Hamul, the family of Hamul. ");
INSERT INTO engoke_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These are the families of Jehudah; the number of them seventy-six thousand five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The sons of Issakar by their families: Tola, the family of Tola; of Phua, the family of the Phuni; ");
INSERT INTO engoke_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Of Jasub, the family of Jasub; of Shimron, the family of Shimron. ");
INSERT INTO engoke_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These are the families of Issakar; their number sixty-four thousand three hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The sons of Zebulon by their families: of Sared, the family of Sared; of Elon, the family of Elon; of Jahleel, the family of Jahleel. ");
INSERT INTO engoke_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These are the families of Zebulon, by their number sixty thousand five hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The sons of Joseph by their families, Menasheh and Ephraim, ");
INSERT INTO engoke_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The sons of Menasheh: of Makir, the family of Makir; and Makir begat Gilead; of Gilead, the family of Gilead. ");
INSERT INTO engoke_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These are the children of Gilead: of Jezar, the family of Jezar; of Helek, the family of Helek; ");
INSERT INTO engoke_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","And of Asriel, the family of Asrieli; and of Shekem, the family of Shekem; ");
INSERT INTO engoke_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","And of Shemida, the family of Shemida; and of Hepher, the family of Hepher. ");
INSERT INTO engoke_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","And Zelophechad bar Hepher had no sons, but daughters; and the names of the daughters of Zelophechad were Mahali, and Nohah, Hegelah, Milchah, and Thirzah. ");
INSERT INTO engoke_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are the families of Menasheh, and their number fifty-two thousand seven hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are the sons of Ephraim by their families: of Shuthelah, the family of Shuthelah; of Bekir, the family of Bekir; of Tachan, the family of Tachan. ");
INSERT INTO engoke_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","And these are the sons of Shuthelah: of Heran, the family of Heran. ");
INSERT INTO engoke_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These are the families of the Beni-Ephraim, the number of whom was thirty-two thousand five hundred. These are the sons of Joseph by their families. ");
INSERT INTO engoke_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The sons of Benjamin by their families: of Bela, the family of Bela; of Ashbal, the family of Ashbal; of Ahiram, the family of Ahiram; ");
INSERT INTO engoke_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Of Shefuphim, the family of Shefuphim; of Hupham, the family of Hupham. ");
INSERT INTO engoke_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","And the sons of Bela, Arede and Naaman; the family of the Aredi; and of Naaman, the family of Naaman. ");
INSERT INTO engoke_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are the sons of Benjamin after their families, and their number forty-five thousand six hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are the children of Dan, after their families: of Shuham, the families of Shuham. These are the families of Dan after their families, ");
INSERT INTO engoke_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","And the number of the families of Shuham sixty-four thousand four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The sons of Asher, after their families: of Jimna, the families of Jimna; of Jeshvi, the families of Jeshvi; of Beriah, the family of Beriah. ");
INSERT INTO engoke_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Of the sons of Beriah: of Heber, the family of Heber; of Malkiel, the family of Malkiel. ");
INSERT INTO engoke_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","But the name of the daughter of Asher was Sarach. ");
INSERT INTO engoke_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are the families of the Beni Asher, by their number fifty-three thousand four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The sons of Naphtali, after their families: of Jahziel, the families of Jahziel; of Gunni, the families of Gunni; ");
INSERT INTO engoke_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","of Jezer, the family of Jezer; of Shelem, the family of Shelem. ");
INSERT INTO engoke_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These are the families of Naphtali by their families, and their number forty-five thousand four hundred. ");
INSERT INTO engoke_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These were the numbered of the sons of Israel, six hundred and one thousand seven hundred and thirty. ");
INSERT INTO engoke_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Unto these thou shalt divide the land for a possession, according to the number of their names. ");
INSERT INTO engoke_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To the many thou shalt make large their possession, and to the few thou shalt make their possession small; to each according to his number shalt thou give his inheritance. ");
INSERT INTO engoke_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Nevertheless the land shall be divided by lot, according to the names of the tribes of their fathers they shall inherit. ");
INSERT INTO engoke_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","By the lot shall their inheritance be divided among the many and the few. ");
INSERT INTO engoke_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","And these are the sons of Levi, after their families: of Gershon, the families of Gershon; of Kehath, the family of Kehath; of Merari, the families of Merari. ");
INSERT INTO engoke_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are the families of Levi: the family of Libni, the family of Hebron, the family of Machli, the family off Mushi, the family of Korach And Kehath begat Amram. ");
INSERT INTO engoke_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","And the name of Amram’s wife was Jokebed, a daughter of Levi, who was born to Levi, in Mizraim; and she bare unto Amram Aharon, and Mosheh, and Miriam their sister. ");
INSERT INTO engoke_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","And unto Aharon were born Nadab and Abihu, Elazar and Ithamar. ");
INSERT INTO engoke_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","But Nadab and Abihu died in their offering strange fire before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","And the numbered of them were twenty-three thousand of all the males from a month old and upwards: for they were not numbered among the children of Israel, because no possession was given to them among the children of Israel. ");
INSERT INTO engoke_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These (are they whom) Mosheh and Elazar the priest numbered of the sons of Israel, in the plains of Moab, by Jordan, (over against) Jericho. ");
INSERT INTO engoke_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But among these there was not a man of them whom Mosheh and Aharon the priest numbered when they counted the children of Israel in the wilderness of Sinai. ");
INSERT INTO engoke_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For the Lord had said to them that dying they should die in the wilderness; and not a man of them remained, except Kaleb bar Jephuneh and Jehoshua bar Nun. ");
INSERT INTO engoke_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","And the daughters of Zelophechad bar Hepher, bar Gilead, bar Makir, bar Menasheh, of the families of Menasheh, bar Joseph, and these are the names of his daughters, Mahelah, Nohah, and Hegelah, and Milchah, and Thirzah, ");
INSERT INTO engoke_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Came and stood before Mosheh and Elazar the priest, and before the princes, and all the congregation, at the door of the tabernacle of ordinance, saying: ");
INSERT INTO engoke_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Our father died in the wilderness; but he was not among the company which gathered against the Lord in the congregation of Korach, but died through his (own) sin; and he had no sons. ");
INSERT INTO engoke_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should the name of our father be taken away from among his kindred, because he had no son? Give us an inheritance among the brethren of our father. ");
INSERT INTO engoke_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","And Mosheh brought their cause before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","The daughters of Zelophechad have spoken properly. Give thou to them the possession of an inheritance among the brethren of their father, and transfer to them their father’s inheritance. ");
INSERT INTO engoke_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","And speak with the children of Israel, saying: If a man die, having no son, you shall make over his inheritance to his daughter; ");
INSERT INTO engoke_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","And if he have no daughter, you shall give his inheritance to his brethren; ");
INSERT INTO engoke_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","But if he have no brothers, you shall give his inheritance to the brethren of his father; ");
INSERT INTO engoke_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","And if his father have no brothers, then shall you give his inheritance to his relative who is next (of kin) to him of his family, and he shall inherit it. And this shall be to the children of Israel for a decree of judgment, as the Lord hath commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","And the Lord said unto Mosheh, Go up to this mountain of the Abaraee, and see the land which I have given to the children of Israel; ");
INSERT INTO engoke_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","And thou shalt see it, and be gathered to thy people, thou also, as Aharon thy brother was gathered. ");
INSERT INTO engoke_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","As ye rebelled against My Word in the desert of Zin, in the strife of the congregation, to sanctify Me at the waters before their eyes; these are the waters of strife, at Rekem, in the desert of Zin. ");
INSERT INTO engoke_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","And Mosheh spake before the Lord, saying; ");
INSERT INTO engoke_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Let the Lord, the God of the spirits of all flesh, appoint a man over the congregation ");
INSERT INTO engoke_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who may go out and go in before them, and may lead them out and bring them in; that this congregation may not be as a flock which hath no shepherd. ");
INSERT INTO engoke_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","And the Lord said to Mosheh, Take to thee Jehoshua bar Nun, a man in whom is the spirit of prophecy, and lay thy hand upon him. ");
INSERT INTO engoke_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","And make him stand before Elazar the priest, and before all the congregation, and give him charge in their sight. ");
INSERT INTO engoke_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","And thou shalt confer some of thy honour upon him, that all the congregation of the children of Israel may obey him. ");
INSERT INTO engoke_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","And he shall stand before Elazar the priest, that he may ask (counsel) for him by the judgment of Uraia before the Lord: upon his word shall they go out, and upon his word shall they come in, he and all the sons of Israel with him, even all the congregation. ");
INSERT INTO engoke_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","And Mosheh did as the Lord commanded him, and took Jehoshua, and made him to stand before Elazar the priest, and all the congregation; ");
INSERT INTO engoke_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","And he laid his hands upon him, and gave him charge, as the Lord spake by Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","instruct the children of Israel, and say to them: My oblation, the ordained bread for My oblations to be received with acceptance, shall you observe to offer in its time. ");
INSERT INTO engoke_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","And thou shalt say to them: This is the oblation which you shall offer before the Lord; two lambs of the year unblemished daily, for a perpetual burnt offering. ");
INSERT INTO engoke_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","The one lamb shalt thou perform in the morning, and the second lamb between the suns. ");
INSERT INTO engoke_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","And with one-tenth of three seahs of flour for the mincha sprinkled with the fourth of a hin of beaten oil. ");
INSERT INTO engoke_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","It is a perpetual burnt offering, which was made in the mountain of Sinai, to be received with acceptance (as) an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","And its libation shall be the fourth of a hin for each lamb; in the sanctuary shall the libation of old wine be poured out before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","And the second lamb shalt thou perform between the suns, as the morning offering; and thou shalt make its libation (in like manner) an oblation to be received with acceptance before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","But on the Sabbath day two lambs of the year unblemished, and two-tenths of flour for the mincha sprinkled with oil, and its libation. ");
INSERT INTO engoke_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","It is the Sabbath burnt offering which shall be performed on the Sabbath, together with the perpetual burnt offering and its libation. ");
INSERT INTO engoke_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","And in the beginnings of your months you shall offer a burnt offering before the Lord; two young bullocks, and one ram, lambs of the year, seven, unblemished. ");
INSERT INTO engoke_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","And three tenths of flour sprinkled with oil for each bullock, and two-tenths of flour for a mincha sprinkled with oil for the one ram, ");
INSERT INTO engoke_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","And a tenth of flour for a mincha sprinkled with oil for each lamb: it is a burnt offering to be received with acceptance as an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","And their libations a half hina of wine shall be for the bullock, and the third of a hina for the ram, and a quarter of a hina for a lamb: this is the burnt offering for the beginning of the month, at its renewal; so shall it be for all the beginnings of the months of the year. ");
INSERT INTO engoke_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","And one kid of the goats for a sin offering before the Lord, beside the perpetual burnt offering, shalt thou make with its libation. ");
INSERT INTO engoke_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","And in the first month, on the fourteenth day of the month, is the Pascha before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","And on the fifteenth day of this month is the feast: seven days you shall eat unleavened (bread). ");
INSERT INTO engoke_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","On the first day shall be a holy convocation; you shall not do any servile work; ");
INSERT INTO engoke_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","But offer the oblation of a burnt offering before the Lord; two young bullocks and one ram, and seven lambs of the year without blemish shall you have; ");
INSERT INTO engoke_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","And their mincha of flour mingled with oil, three tenths for the bullock and two-tenths for the ram you shall make; ");
INSERT INTO engoke_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","a tenth shall you make for one lamb, so for the seven lambs. ");
INSERT INTO engoke_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","And one goat for a sin offering to make atonement for you; ");
INSERT INTO engoke_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Besides the burnt sacrifice of the morning which is the perpetual burnt sacrifice, you shall make these. ");
INSERT INTO engoke_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","After the manner of these you shall do by the day for seven days; it is the bread of the oblation to be received with acceptance before the Lord; (with) the perpetual burnt offering and its libation shall it be made. ");
INSERT INTO engoke_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","And on the seventh day there shall be a holy convocation, (when) you may do no servile work. ");
INSERT INTO engoke_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","But on the day of the Firstfruits, when you bring the new thank-offering before the Lord in your expletion, there shall be a holy convocation; no servile work shall you do, ");
INSERT INTO engoke_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","But offer a burnt offering to be received with favour before the Lord; two young bullocks, one ram, seven lambs of the year; ");
INSERT INTO engoke_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","And their mincha of flour mingled with oil, three tenths for one bullock, ");
INSERT INTO engoke_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","two-tenths for the ram, a tenth for each lamb of the seven lambs; ");
INSERT INTO engoke_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","One kid of the goats to make an atonement for you; ");
INSERT INTO engoke_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Beside the perpetual burnt sacrifice and its mincha you shall (make) them unblemished, and their libations. ");
INSERT INTO engoke_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","And in the seventh month, on the first of the month, you shall have a holy convocation, and do no servile work; it shall be a day of the sounding of the trumpet to you. ");
INSERT INTO engoke_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","And you shall make a burnt sacrifice to be received with favour before the Lord: one young bullock, one ram, lambs of the year seven, unblemished, ");
INSERT INTO engoke_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","and their mincha of flour mingled with oil, three tenths for the bullock, two-tenths for the ram, ");
INSERT INTO engoke_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","And one-tenth for each of the seven lambs; ");
INSERT INTO engoke_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","And one kid of the goats for a sin offering to make an atonement for you; ");
INSERT INTO engoke_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Beside the offering of the month, and its mincha, and the perpetual sacrifice and its mincha, and their libations, as proper for them, to be received with favour, an oblation before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","And on the tenth of this seventh month you shall have a holy convocation, and afflict your souls; you shall do no labour, ");
INSERT INTO engoke_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","but offer a burnt offering before the Lord to be received with favour: one young bullock, one ram, lambs of the year seven, unblemished shall you have; ");
INSERT INTO engoke_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","And their mincha of flour mingled with oil; three tenths for the bullock, two-tenths for the ram, ");
INSERT INTO engoke_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","And a single tenth for each of the seven lambs; ");
INSERT INTO engoke_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","One kid of the goats for a sin offering, beside the sin offering of the expiations, and the perpetual sacrifice, its mincha and their libations. ");
INSERT INTO engoke_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","And on the fifteenth day of the seventh month you shall have a holy convocation; no servile labour shall you do, but celebrate a festival before the Lord seven days; ");
INSERT INTO engoke_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","And offer a burnt sacrifice, an oblation to be received with favour before the Lord; thirteen young bullocks, two rams, lambs of the year fourteen, unblemished shall they be; ");
INSERT INTO engoke_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","And their mincha of flour mingled with oil, three tenths to one bullock for the thirteen bullocks, two-tenths for each ram, ");
INSERT INTO engoke_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","And one-tenth for each of the fourteen lambs, ");
INSERT INTO engoke_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","And one kid of the goats for a sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","And on the second day you shall offer twelve young bullocks, two rams, fourteen unblemished lambs of the year, ");
INSERT INTO engoke_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","and the minchas and libations for the bullocks, for the rams and the lambs, as is proper for their number; ");
INSERT INTO engoke_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","And one kid of the goats, a sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","And on the third day eleven bullocks, two rams, fourteen unblemished lambs of the year; ");
INSERT INTO engoke_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","And their minchas and libations for the bullocks, the rams, and the lambs, as befitteth their number; ");
INSERT INTO engoke_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","And one kid for a sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","On the fourth day ten bullocks, two rams, lambs of the year unblemished fourteen; ");
INSERT INTO engoke_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Their minchas and libations for the bullocks, rams, and lambs by their number, as it is proper; ");
INSERT INTO engoke_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","And one kid of the goats for a sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","And on the fifth day nine bullocks, two rams, lambs of the year unblemished fourteen; ");
INSERT INTO engoke_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","The minchas and libations for the bullocks, rams, and lambs after their number, as it is proper; ");
INSERT INTO engoke_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","And one kid for a sin offering, beside the perpetual sacrifice and its libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","And on the sixth day eight bullocks, two rams, lambs of the year unblemished fourteen; ");
INSERT INTO engoke_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","The minchas and libations for the bullocks, rams, and lambs by their number, as is proper; ");
INSERT INTO engoke_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","And one kid for the sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","And on the seventh day seven bullocks, two rams, fourteen lambs of the year unblemished; ");
INSERT INTO engoke_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","The minchas and libations for the bullocks, rams, and lambs by their number, as is proper; ");
INSERT INTO engoke_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","And one kid for the sin offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","On the eighth day you shall have all assembly; no servile work shall you do, ");
INSERT INTO engoke_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","But offer a sacrifice, all oblation to be received with favour before the Lord; one bullock, one ram, seven Iambs of the year unblemished; ");
INSERT INTO engoke_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","The minchas and libations for the bullock, the ram, and the lambs, as proper, according to their number; ");
INSERT INTO engoke_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","And one kid for a sill offering, beside the perpetual sacrifice, its mincha and libation. ");
INSERT INTO engoke_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","These shall you offer before the Lord in your solemnities, beside your vows and your free-will offerings with your burnt sacrifices, their minchas and their libations, and with your sanctified victims. ");
INSERT INTO engoke_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","And Mosheh spake to the sons of Israel according to all that the Lord commanded Mosheh. ");
INSERT INTO engoke_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","And Mosheh spake with the heads of the tribes of the Beni Israel, saying: This is the word which the Lord hath commanded: ");
INSERT INTO engoke_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","When a man shall make a vow before the Lord, or swear an oath to bind a bond upon his soul, he shall not make void his word; according to all that hath come out of his mouth he shall perform. ");
INSERT INTO engoke_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","And if a woman make a vow before the Lord, and bind (herself) with a bond in her father’s house, (being) in her youth, ");
INSERT INTO engoke_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","And her father shall hear her vow, and the obligation she hath bound upon her soul, and her father be silent to her, then all her vows shall stand, and every bond that she hath bound upon her soul shall be confirmed. ");
INSERT INTO engoke_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","But if her father prohibit (or undo) them on the day that he heareth, all the vows and the bonds that she hath bound upon her soul shall not stand, and she shall be forgiven before the Lord, because her father undid them. ");
INSERT INTO engoke_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","And if she hath a husband, and taketh a vow upon her, or if her lips pronounce that which becometh binding upon her soul, ");
INSERT INTO engoke_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","and her husband heard and was silent to her on the day that he heard, her vows shall stand, and the obligation she hath bound upon her soul be confirmed: ");
INSERT INTO engoke_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","But if her husband on the day that he heareth shall prohibit them, the vows which are on her and the utterance of her lips which became binding on her soul shall be void, and be forgiven her before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","But every vow of the widow, or of one divorced, which she hath bound upon her soul, shall be confirmed upon her. ");
INSERT INTO engoke_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","And if (while in her husband’s house) she had vowed, or had bound aught upon her soul with an oath, ");
INSERT INTO engoke_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","And her husband heard and was silent to her, and did not prohibit them, all her vows shall be confirmed, every bond with which she hath bound her soul shall be confirmed. ");
INSERT INTO engoke_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","But if indeed her husband shall make them void in the day that he heard, that which her lips expressed in her vow and in the binding of her soul shall not be confirmed; her husband hath made them void, and she shall be absolved before the Lord. ");
INSERT INTO engoke_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Every vow and every covenant (oath) to chastise the soul, her husband may confirm it, or her husband may make it void. ");
INSERT INTO engoke_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if her husband was entirely silent to her from day to day, then he hath confirmed all her vows, or whatever bonds (she taketh) upon her, he confirmeth them, because he was silent to her on the day that he heard. ");
INSERT INTO engoke_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","But if he shall indeed make them void after (the day that) he had heard, then he shall bear her sin. ");
INSERT INTO engoke_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","These are the statutes which the Lord commanded Mosheh between a man and his wife, (and) between a father and his daughter, in her youth in her father’s house. ");
INSERT INTO engoke_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","And the Lord spake with Mosheh, saying: ");
INSERT INTO engoke_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Avenge the children of Israel of the Midianites; afterward thou shalt be gathered to thy people. ");
INSERT INTO engoke_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","And Mosheh spake with the people, saying: Arm, of you, men for the host against Midian, to avenge this people of the Lord upon Midian: ");
INSERT INTO engoke_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","A thousand of a tribe, a thousand of a tribe, of all the tribes or Israel, shall you send to the host. ");
INSERT INTO engoke_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","And from the thousands of Israel there were chosen a thousand of a tribe, twelve thousand armed for the host. ");
INSERT INTO engoke_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","And Mosheh sent them one thousand of a tribe to array them, and Phinehas bar Elazar the priest, with the host, and the holy vessels, and the Jubela trumpets in his hand. ");
INSERT INTO engoke_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","And the host gathered against Midian, as tile Lord had commanded Mosheh; and they slaughtered every male. ");
INSERT INTO engoke_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","But the kings of Midian they killed with their slain, Evi, and Rekem, and Zur, and Chur, and Reba, five kings of Midian, and Bileam bar Beor, they killed with the sword. ");
INSERT INTO engoke_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","And the sons of Israel took the women of Midian captives, with their children and all their cattle, and all their flocks and all their goods they despoiled. ");
INSERT INTO engoke_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","And all their cities where they dwelt, and their houses of worship, they burned with fire. ");
INSERT INTO engoke_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","And they took all the spoil, and all the prey of man and of cattle, ");
INSERT INTO engoke_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","and brought the captives, and the prey, and the spoil, to Mosheh, and to Elazar the priest, and to all the congregation of the Beni Israel, to the camp in the fields of Moab, by the Jordan, over against Jericho. ");
INSERT INTO engoke_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","And Mosheh and Elazar the priest and all the princes of the congregation went out to meet them, without the camp. ");
INSERT INTO engoke_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","But Mosheh was angry with those who had been appointed over the host, the captains of thousands and the captains of hundreds, who came from the battle. ");
INSE