﻿USE sofia;
DROP TABLE IF EXISTS sofia.engojb_vpl;
CREATE TABLE engojb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engojb_vpl WRITE;
INSERT INTO engojb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning Elohim bara hashomayim (the heavens) and haaretz (the earth). ");
INSERT INTO engojb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","And the earth was tohu vavohu (without form, and void); and darkness was upon the face of the deep. And the Ruach Elohim was hovering upon the face of the waters. ");
INSERT INTO engojb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","And Elohim said, Let there be light: and there was light. ");
INSERT INTO engojb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","And Elohim saw the light, that it was tov (good); and Elohim divided the ohr (light) from the choshech (darkness). ");
INSERT INTO engojb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","And Elohim called the light Yom (Day), and the darkness He called Lailah (Night). And the erev (evening) and the boker (morning) were Yom Echad(Day One, the First Day). ");
INSERT INTO engojb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","And Elohim said, Let there be a raki'a (expanse, dome, firmament) in the midst of the mayim (waters), and let it divide the mayim from the mayim. ");
INSERT INTO engojb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","And Elohim made the raki'a, and divided the waters under the raki'a from the waters which were above the raki'a; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","And Elohim called the raki'a Shomayim (Heaven). And the erev and the boker were Yom Sheni (Day Two, the Second Day). ");
INSERT INTO engojb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","And Elohim said, Let the waters under the heaven be gathered together unto one place, and let the yabashah (dry land) appear; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","And Elohim called the yabashah Eretz (Earth); and the mikveh (gathering together of the waters) called He Seas; and Elohim saw that it was tov. ");
INSERT INTO engojb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","And Elohim said, Let the earth bring forth vegetation, the herb yielding zera (seed), and the fruit tree yielding pri (fruit) after its kind, whose seed is in itself, upon the earth; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","And the earth brought forth vegetation, and herb yielding zera (seed) after its kind, and the tree yielding fruit, whose seed was in itself, after its kind; and Elohim saw that it was tov (good). ");
INSERT INTO engojb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","And the erev and the boker were Yom Shlishi (Day Three, the Third Day). ");
INSERT INTO engojb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","And Elohim said, Let there be lights in the raki'a of the heaven to divide the day from the night; and let them be for otot (signs), and for mo'adim (seasons), and for yamim (days), and shanim (years); ");
INSERT INTO engojb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","And let them be for lights in the raki'a of the heaven to give light upon the earth; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","And Elohim made two great lights; the greater light to rule the day, and the lesser light to rule the night; He made the kokhavim (stars) also. ");
INSERT INTO engojb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","And Elohim set them in the raki'a of the heaven to give light upon the earth, ");
INSERT INTO engojb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","And to rule over the day and over the night, and to divide the light from the darkness; and Elohim saw that it was tov. ");
INSERT INTO engojb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","And the erev and the boker were Yom Revi'i (Day Four, the Fourth Day). ");
INSERT INTO engojb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","And Elohim said, Let the waters bring forth an abundance of living creatures, and fowl that may fly above the earth in the open raki'a of heaven. ");
INSERT INTO engojb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","And Elohim created great sea creatures, and every living creature that moveth, which the waters brought forth in abundance, after their kind, and every winged fowl after its kind; and Elohim saw that it was tov. ");
INSERT INTO engojb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","And Elohim blessed them, saying, Be fruitful, and multiply, and fill the waters in the seas, and let fowl multiply in the earth. ");
INSERT INTO engojb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","And the erev and the boker were Yom Chamishi (Day Five, the Fifth Day). ");
INSERT INTO engojb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","And G-d said, Let the earth bring forth the living creature after its kind, cattle, and creeping thing, and beast of the earth after its kind; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","And G-d made the beast of the earth after its kind, and cattle after their kind, and every thing that creepeth upon the earth after its kind; and G-d saw that it was tov. ");
INSERT INTO engojb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","And G-d said, Let Us make man in Our tzelem, after Our demut: and let them have dominion over the fish of the sea, and over the fowl of the air, and over the cattle, and over all the earth, and over every creeping thing that creepeth upon ha'aretz (the earth). ");
INSERT INTO engojb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So G-d created humankind in His own tzelem, in the tzelem Elohim (image of G-d) created He him; zachar (male) and nekevah (female) created He them. ");
INSERT INTO engojb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","And G-d blessed them, and G-d said unto them, Be fruitful, and multiply, and fill the earth, and subdue it: and have dominion over the fish of the sea, and over the fowl of the air, and over every living thing that moveth upon the earth. ");
INSERT INTO engojb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","And G-d said, Hinei, I have given you every herb bearing seed, which is upon the face of kol ha'aretz (all the earth), and every etz (tree), in the which is the fruit of a tree yielding seed; to you it shall be for food. ");
INSERT INTO engojb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And to every beast of the earth, and to every fowl of the air, and to every thing that creepeth upon the earth, wherein there is life, I have given every green herb for food; and it was so. ");
INSERT INTO engojb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","And G-d saw every thing that He had made, and, behold, it was tov me'od (very good). And the erev and the boker were Yom Shishi (Day Six, the Sixth Day). ");
INSERT INTO engojb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Thus HaShomayim and Ha'Aretz were finished, and all the tza'va of them. ");
INSERT INTO engojb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","And on Yom HaShevi'i Elohim finished His work which He had made; and He rested on the Yom HaShevi'i from all His work which He had made. ");
INSERT INTO engojb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Vayevarech Elohim et Yom HaShevi'i, and set it apart as kodesh: because that in it shavat (He had rested) from all His work which bara Elohim (G-d created) and made. ");
INSERT INTO engojb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","These are the toledot of HaShomayim and of Ha'Aretz when they were created, in the Yom that Hashem Elohim made Eretz v'Shomayim, ");
INSERT INTO engojb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","And every plant of the sadeh was not yet in ha'aretz, and every herb of the sadeh had not yet yitzmach (sprung up); for Hashem Elohim had not caused it to rain upon ha'aretz, and there was not an adam (man) la'avod (to till, to work) haadamah (the ground). ");
INSERT INTO engojb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","But there went up a mist from ha'aretz, and watered the whole face of the adamah. ");
INSERT INTO engojb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","And Hashem Elohim formed the adam of the aphar min haadamah, and breathed into his nostrils the nishmat chayyim; and the adam became a nefesh chayyah. ");
INSERT INTO engojb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","And Hashem Elohim planted a gan (garden) eastward in Eden; and there He put the adam whom He had formed. ");
INSERT INTO engojb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","And out of the adamah made Hashem Elohim to spring up kol etz (every tree) that is pleasing to the sight, and tov for food; the Etz HaChayyim (Tree of Life) also in the midst of the gan (garden), and the Etz HaDa'as Tov v'Rah. ");
INSERT INTO engojb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","And a nahar (river) flowed out of Eden to water the gan (garden); and from there it divided, and became four headwaters. ");
INSERT INTO engojb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The shem of the first is Pishon; that is it which winds through the kol eretz Chavilah, where there is zahav; ");
INSERT INTO engojb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","And the zahav of that land is tov; there is the gemstone bedolach and the even (gemstone) hashoham. ");
INSERT INTO engojb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","And the shem of the second nahar is Gichon; the same is it that winds through kol eretz Kush. ");
INSERT INTO engojb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","And the shem of the third nahar is Chiddekel (Tigris): that is it which goeth toward the east of Assyria. And the fourth nahar is Euphrates. ");
INSERT INTO engojb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","And Hashem Elohim took the adam and put him in the Gan Eden la'avod (to till, to work) it and to be shomer over it. ");
INSERT INTO engojb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And Hashem Elohim commanded the adam, saying, Of every etz of the gan thou mayest freely eat; ");
INSERT INTO engojb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","But of the Etz HaDa'as Tov v'Rah, thou shalt not eat of it; for in the yom that thou eatest thereof thou shalt surely die. ");
INSERT INTO engojb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","And Hashem Elohim said, It is not tov that the adam should be alone; I will make him an ezer (a helper) suitable for him. ");
INSERT INTO engojb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And out of the adamah Hashem Elohim formed every beast of the sadeh, and every oph HaShomayim; and brought them unto the adam to see what he would name them; and whatsoever the adam named kol nefesh chayyah, that was shmo. ");
INSERT INTO engojb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","And the adam gave shemot to all behemah, and to the oph HaShomayim, and to every beast of the sadeh; but for Adam there was not found an ezer for him. ");
INSERT INTO engojb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","And Hashem Elohim caused a tardemah (deep sleep) to fall upon the adam, and he slept; and He took from one of his tzalelot (sides, ribs), and closed up the basar in the place thereof; ");
INSERT INTO engojb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","And the tzela (rib), which Hashem Elohim had taken from the adam, made He an isha, and brought her unto the adam. ");
INSERT INTO engojb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","And the adam said, This is now etzem of my etzem, and basar of my basar; she shall be called Isha, because she was taken out of Ish. ");
INSERT INTO engojb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Therefore shall an ish leave his av and his em, and shall cleave unto his isha: and they shall be basar echad. ");
INSERT INTO engojb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","And they were both arummim (naked ones), the adam and his isha, and were not ashamed. ");
INSERT INTO engojb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the Nachash was more arum (cunning, crafty, wiley) than any beast of the sadeh which Hashem Elohim had made. And he said unto the isha, Really? Hath Elohim said, Ye shall not eat of kol etz hagan? ");
INSERT INTO engojb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","And the isha said unto the Nachash, We may eat of the p'ri etz hagan; ");
INSERT INTO engojb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","But of the p'ri haEtz which is in the middle of the gan (garden), Elohim hath said, Ye shall not eat of it, neither shall ye touch it, lest ye die. ");
INSERT INTO engojb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","And the Nachash said unto the isha, Ye shall not surely die; ");
INSERT INTO engojb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","For Elohim doth know that in the yom ye eat thereof, then your eyes shall be opened, and ye shall be like Elohim, knowing tov and rah. ");
INSERT INTO engojb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","And when the isha saw that HaEtz was tov for food, and that it was delight to the eyes, and HaEtz to be coveted to make one have seichel, she took of the p'ri thereof, and did eat, and gave also unto her ish with her; and he did eat. ");
INSERT INTO engojb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","And the eyes of them both were opened, and they knew that they were eirummim (naked ones); and they sewed aleh te'enah (fig leaves) together, and made themselves khagorot (loin covering girdles). ");
INSERT INTO engojb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","And they heard the kol of Hashem Elohim walking in the gan in the cool of the day; and HaAdam and his isha hid from the presence of Hashem Elohim amongst the etz hagan. ");
INSERT INTO engojb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","And Hashem Elohim called unto HaAdam, and said unto him, Where art thou? ");
INSERT INTO engojb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","And he said, I heard Thy voice in the gan (garden), and I was afraid, because I was eirom (naked); and so I hid. ");
INSERT INTO engojb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","And He said, Who told thee that thou wast eirom (naked)? Hast thou eaten of HaEtz, which I commanded thee that thou not eat thereof? ");
INSERT INTO engojb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","And HaAdam said, The isha whom Thou gavest to be with me, she gave me of HaEtz, and I did eat. ");
INSERT INTO engojb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","And Hashem Elohim said unto the isha, What is this that thou hast done? And the isha said, The Nachash beguiled me, and I did eat. ");
INSERT INTO engojb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","And Hashem Elohim said unto the Nachash, Because thou hast done this, thou art arur (cursed) above kol habehemah, and above every beast of the sadeh; upon thy gakhon (belly) shalt thou go, and aphar shalt thou eat all the days of thy life; ");
INSERT INTO engojb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And I will put eivah between thee and HaIsha, and between thy zera and her Zera; He shall crush thy rosh, and thou shalt strike His akev (heel). ");
INSERT INTO engojb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Unto HaIsha He said, I will greatly multiply thy itzavon (labor pain) and thy childbearing; in pain thou shalt bring forth banim; and thy teshukah (longing, desire) shall be to thy husband, and he shall rule over thee. ");
INSERT INTO engojb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","And unto Adam He said, Because thou paid heed unto the voice of thy isha, and hast eaten of HaEtz, of which I commanded thee, saying, Thou shalt not eat of it, arurah (cursed) is haadamah because of thee; in itzavon(pain, suffering) shalt thou eat of it all the days of thy life; ");
INSERT INTO engojb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kotz also and dardar shall it bring forth to thee; and thou shalt eat the esev of the sadeh; ");
INSERT INTO engojb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","In the sweat of thy brow shalt thou eat lechem, till thou return unto haadamah; for out of it wast thou taken; for aphar thou art, and unto aphar shalt thou return. ");
INSERT INTO engojb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","And HaAdam called the shem of his isha Chavah (Eve); because she was the Em kol chai. ");
INSERT INTO engojb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Unto Adam also and to his isha did Hashem Elohim make kesonos ohr, and clothed them. ");
INSERT INTO engojb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","And Hashem Elohim said, See, HaAdam is become like one of Us, knowing tov v'rah; and now, lest he put forth his yad, and take also of HaEtz HaChayyim, and eat, and chai l'olam (live forever); ");
INSERT INTO engojb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Therefore Hashem Elohim sent him forth from the Gan Eden, to work haadamah from which place he was taken. ");
INSERT INTO engojb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","So He drove out HaAdam; and He placed miKedem (at the east) of the Gan Eden HaKeruvim, and a flaming cherev which was ever-turning, to be shomer over the Derech Etz HaChayyim. ");
INSERT INTO engojb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","And HaAdam knew Chavah (Eve) his isha; and she conceived, and bore Kayin (Cain), and said, Kaniti (I have acquired) ish with Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","And again she bore his ach Hevel (Abel). And Hevel was a ro'eh tzon, but Kayin was an oved adamah (tiller of soil). ");
INSERT INTO engojb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","And in ketz yamim it came to pass, that Kayin brought of the p'ri haadamah a minchah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","And Hevel, he also brought of the bechorot of his tzon and of the chelev thereof. And Hashem regarded with favor, respect unto Hevel and to his minchah: ");
INSERT INTO engojb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","But unto Kayin and to his minchah He had not regard. And Kayin was very angry, and his countenance fell. ");
INSERT INTO engojb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","And Hashem said unto Kayin, Why art thou angry? And why is thy countenance fallen? ");
INSERT INTO engojb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If thou doest right, shalt thou not be accepted? And if thou doest not right, chattat is lurking at the petach. And unto thee shall be its teshukah (desire), and thou must rule over it. ");
INSERT INTO engojb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","And Kayin talked with Hevel his brother; and it came to pass, when they were in the sadeh, that Kayin rose up against Hevel his brother, and killed him. ");
INSERT INTO engojb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","And Hashem said unto Kayin, Where is Hevel thy brother? And he said, I know not; am I shomer achi (my brotherʼs keeper)? ");
INSERT INTO engojb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","And He said, What hast thou done? The voice of thy brotherʼs dahm crieth unto Me from haadamah. ");
INSERT INTO engojb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","And now art thou arur (cursed) from haadamah, which hath opened her mouth to receive thy brotherʼs dahm from thy hand; ");
INSERT INTO engojb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When thou tillest haadamah, it shall not henceforth yield unto thee her ko'ach (strength); na (restless fugitive) vanad (and a wanderer, nomad) shalt thou be in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","And Kayin said unto Hashem, My avon (iniquity, punishment for guilt) is greater than I can bear. ");
INSERT INTO engojb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","See, Thou hast driven me out this day from the face of the adamah; and from Thy face shall I be hidden and I shall be a na (restless fugitive) vanad (and a wanderer, nomad) in ha'aretz; and it shall come to pass, that whoever findeth me shall kill me. ");
INSERT INTO engojb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","And Hashem said unto him, Therefore whoever killeth Kayin, vengeance shall be taken on him sevenfold. And Hashem placed an ot (mark) upon Kayin, so that none finding him should kill him. ");
INSERT INTO engojb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","And Kayin went out from the presence of Hashem, and dwelt in Eretz Nod, east of Eden. ");
INSERT INTO engojb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","And Kayin knew his isha; and she conceived, and bore Chanokh (Enoch); and he built an ir (city), and called the shem of the ir, after the shem beno, Chanokh (Enoch). ");
INSERT INTO engojb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","And unto Chanokh (Enoch) was born Irad; and Irad fathered Mechuyael; and Mechuyael fathered Metushael; and Metushael fathered Lamech. ");
INSERT INTO engojb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","And Lamech took unto him two nashim; the shem of the one was Adah, and the shem of the second Tzilah. ");
INSERT INTO engojb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","And Adah bore Yaval; he was the av of such as dwell in ohel, and have mikneh. ");
INSERT INTO engojb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","And his brotherʼs shem was Yuval; he was the av of all such as play kinnor (harp) and ugav (flute). ");
INSERT INTO engojb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","And Tzilah, she also bore Tuval-Kayin, a forger of every cutting tool of nechoshet and barzel; and the achot of Tuval-Kayin was Na'amah. ");
INSERT INTO engojb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","And Lamech said unto his wives, Adah and Tzilah, Hear my voice; ye wives of Lamech, give heed to my speech; for I have slain an ish for my wounding, and a yeled for my chabburah. ");
INSERT INTO engojb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If Kayin (Cain) shall be avenged sevenfold, truly Lamech seventy and seven times over. ");
INSERT INTO engojb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam knew his isha again; and she bore a ben, and called shmo Shet; for Elohim, said she, hath appointed me another zera in place of Hevel, whom Kayin killed. ");
INSERT INTO engojb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And to Shet, to him also there was born a ben; and he called shmo Enosh; then began men to call upon the Shem of Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the Sefer Toldot Adam. In the yom that barah Elohim Adam, in the demut Elohim He made him; ");
INSERT INTO engojb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Zachar and nekevah He created them; and blessed them, and called the shem of them “Adam,” in the yom when they were created. ");
INSERT INTO engojb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","And Adam lived a hundred and thirty shanah and fathered in his own demut and after his tzelem (image) and called shmo Shet: ");
INSERT INTO engojb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","And the days of Adam after he had fathered Shet were shemoneh me'ot shanah; and he fathered banim and banot: ");
INSERT INTO engojb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","And all the days that Adam lived were nine hundred and thirty shanah: and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","And Shet lived a hundred and five shanah, and fathered Enosh; ");
INSERT INTO engojb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","And Shet lived after he fathered Enosh eight hundred and seven shanah, and fathered banim and banot: ");
INSERT INTO engojb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","And all the days of Shet were nine hundred and twelve shanah; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","And Enosh lived ninety shanah, and fathered Kenan; ");
INSERT INTO engojb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","And Enosh lived after he fathered Kenan eight hundred and fifteen shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","And all the days of Enosh were nine hundred and five shanim; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","And Kenan lived seventy shanah and fathered Mahalal'el; ");
INSERT INTO engojb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","And Kenan lived after he fathered Mahalal'el eight hundred and forty shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","And all the days of Kenan were nine hundred and ten shanim; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","And Mahalal'el lived sixty and five shanah, and fathered Yered; ");
INSERT INTO engojb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","And Mahalal'el lived after he fathered Yered eight hundred and thirty shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","And all the days of Mahalal'el were eight hundred ninety and five shanah; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","And Yered lived a hundred sixty and two shanah, and he fathered Chanokh (Enoch): ");
INSERT INTO engojb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","And Yered lived after he fathered Chanokh (Enoch) eight hundred shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","And all the days of Yered were nine hundred sixty and two shanah; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","And Chanokh lived sixty and five shanah, and fathered Metushelach; ");
INSERT INTO engojb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","And Chanokh walked with HaElohim after he fathered Metushelach three hundred shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","And all the days of Chanokh were three hundred sixty and five shanah; ");
INSERT INTO engojb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","And Chanokh walked with HaElohim; and he was not; for Elohim took him. ");
INSERT INTO engojb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","And Metushelach lived a hundred eighty and seven shanah, and fathered Lamech. ");
INSERT INTO engojb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","And Metushelach lived after he fathered Lamech seven hundred eighty and two shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","And all the days of Metushelach were nine hundred sixty and nine shanah; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","And Lamech lived a hundred eighty and two shanah and fathered ben; ");
INSERT INTO engojb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","And he called shmo Noach, saying, Zeh yenachamenu (this shall comfort us) in our work and toil of our hands, because of the adamah which Hashem hath cursed. ");
INSERT INTO engojb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","And Lamech lived after he fathered Noach five hundred ninety and five shanah, and fathered banim and banot; ");
INSERT INTO engojb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","And all the days of Lamech were seven hundred seventy and seven shanah; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","And Noach was five hundred years old; and Noach fathered Shem, Cham, and Yephet. ");
INSERT INTO engojb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","And it came to pass, when HaAdam began to multiply on the face of ha'adamah, and banot were born unto them, ");
INSERT INTO engojb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","That the bnei HaElohim saw the banot HaAdam that they were tovot; and they took them nashim of all which they chose. ");
INSERT INTO engojb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","And Hashem said, My Ruach Hakodesh shall not always strive with Adam, for that he also is basar: yet his yamim shall be a hundred and twenty shanah. ");
INSERT INTO engojb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","HaNefilim were on ha'aretz in those yamim; and also after that, when the bnei HaElohim came in unto the banot HaAdam, and they bore children to them, the same became gibborim which were of old, men of renown. ");
INSERT INTO engojb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","And Hashem saw that the wickedness of HaAdam was great in ha'aretz and that every yetzer (inclination) of the machshevot (thoughts) of his lev was only rah (evil) continually. ");
INSERT INTO engojb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","And Hashem relented that He had made HaAdam on ha'aretz, and He was grieved in His lev. ");
INSERT INTO engojb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","And Hashem said, I will wipe out HaAdam whom I have created from the face of ha'adamah; both Adam, and Behemah, and the Remes and the Oph HaShomayim; for I relent that I have made them. ");
INSERT INTO engojb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noach found chen (grace, unmerited favor) in the eyes of Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","These are the toldot of Noach; Noach was an ish tzaddik and tamim among those of his time, and Noachʼs halachah was with HaElohim. ");
INSERT INTO engojb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","And Noach fathered three banim: Shem, Cham, and Yephet. ");
INSERT INTO engojb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ha'aretz also was corrupt before HaElohim, and ha'aretz was filled with chamas. ");
INSERT INTO engojb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","And Elohim looked upon ha'aretz, and, hinei, it was corrupt; for kol basar had corrupted his derech upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","And Elohim said unto Noach, The ketz (end) of kol basar is come before Me; for ha'aretz is filled with chamas because of them; and, hineni, I will destroy them with ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make thee a tevah (ark) of gopher wood; rooms shalt thou make in the tevah (ark), and shalt coat it within and without with tar. ");
INSERT INTO engojb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","And this is how thou shalt build it: the length of the tevah (ark) shall be three hundred cubits, the width of it fifty cubits, and the height of it thirty cubits. ");
INSERT INTO engojb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","A roof shalt thou make to the tevah (ark), and thou shalt finish it to a cubit from the top; and the petach of the tevah (ark) shalt thou set in the side thereof; with lower, second, and third decks shalt thou make it. ");
INSERT INTO engojb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","And, hineni, I, even I, do bring a mabbul of waters upon ha'aretz, to destroy kol basar, wherein is the ruach chayyim, from under Shomayim; and everything that is in ha'aretz shall perish. ");
INSERT INTO engojb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","And then with thee will I establish My brit (covenant); and thou shalt come into the tevah (ark), thou, and thy banim, and thy isha, and the nashim of thy banim with thee. ");
INSERT INTO engojb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And of every living thing of kol basar, two of every kind shalt thou bring into the tevah (ark), to keep them alive with thee; they shall be zachar and nekevah. ");
INSERT INTO engojb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of birds after their kind, and of behemah after their kind, of every remes of ha'adamah after its kind, two of every kind shall come unto thee, to keep them alive. ");
INSERT INTO engojb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And take thou unto thee of all food that is eaten, and thou shalt gather it to thee; and it shall be for ochel for thee, and for them. ");
INSERT INTO engojb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Thus did Noach; according to all that Elohim commanded him, so did he. ");
INSERT INTO engojb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","And Hashem said unto Noach, Come thou and all thy bais into the tevah (ark); for thee have I found tzaddik before Me in dor hazeh. ");
INSERT INTO engojb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Of every behemah hatehorah thou shalt take to thee by sevens; the male and his mate; and of behemah that are not tehorah by two, the male and his mate. ");
INSERT INTO engojb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Of also Oph HaShomayim by sevens, the zachar and the nekevah; to keep zera alive upon the face of kol ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","For shivah yamim from now, and I will cause it to rain upon ha'aretz arba'im yom and arba'im lailah; and every living creature that I have made will I wipe out from off the p'nei ha'adamah. ");
INSERT INTO engojb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noach did according unto all that Hashem commanded him. ");
INSERT INTO engojb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","And Noach was shesh me'ot shanah when the mabbul waters were upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","And Noach entered in, and his banim, and his isha, and nashim of his banim with him, into the tevah (ark), because of the waters of the mabbul. ");
INSERT INTO engojb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Of behemah hatehorah, and of behemah that are not tehorah, and of haoph, and of every thing that creepeth upon ha'adamah, ");
INSERT INTO engojb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","There went in shnayim shnayim unto Noach into the tevah (ark), the zachar and the nekevah, as Elohim had commanded Noach. ");
INSERT INTO engojb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And it came to pass after shivat hayamim, that the waters of the mabbul were upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noachʼs life, in the second month, the seventeenth day of the month, the same day were all the fountains of the great deep burst open, and the floodgates of Shomayim were opened. ");
INSERT INTO engojb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","And the geshem was upon ha'aretz arba'im yom and arba'im lailah. ");
INSERT INTO engojb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On that very yom entered Noach, and Shem, and Cham, and Yephet, the bnei Noach, and Noachʼs isha, and the three nashim of his banim with them, into the tevah (ark); ");
INSERT INTO engojb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They, and every beast after its kind, and kol habehemah after their kind, and every remes that crawls upon ha'aretz after its kind, and kol haoph after its kind, every bird of every sort. ");
INSERT INTO engojb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","And they went in unto Noach into the tevah (ark), shnayim shnayim of kol habasar, wherein is the ruach chayyim. ");
INSERT INTO engojb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","And they that went in, went in zachar and nekevah of kol basar, as Elohim had commanded him; then Hashem shut him in. ");
INSERT INTO engojb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","And the mabbul was arba'im yom upon ha'aretz; and the waters increased, and lifted up the tevah (ark), and it rose above ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","And the waters rose, and were increased greatly upon ha'aretz; and the tevah (ark) floated upon the face of the waters. ");
INSERT INTO engojb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","And the waters rose exceedingly upon ha'aretz; and all the high hills, that were under kol HaShomayim, were covered. ");
INSERT INTO engojb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Fifteen cubits upward did the waters rise; and the harim were covered. ");
INSERT INTO engojb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","And kol basar perished that moved upon ha'aretz, both of Oph, and of Behemah, and of Beast, and of every Swarming Thing that swarms upon ha'aretz, and kol haadam; ");
INSERT INTO engojb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","All in whose nostrils was the ruach chayyim, of all that was in the dry land, perished. ");
INSERT INTO engojb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","And every living creature was wiped out which was upon the p'nei haadamah, both Adam, and Behemah, and the Remes, and the Oph HaShomayim; and they were wiped out from ha'aretz: and Noach only remained alive, and they that were with him in the tevah (ark). ");
INSERT INTO engojb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","And the waters flooded upon ha'aretz a hundred and fifty days. ");
INSERT INTO engojb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","And Elohim remembered Noach, and every living thing, and all the behemah that was with him in the tevah (ark); and Elohim made a ruach to pass over ha'aretz, and the waters subsided; ");
INSERT INTO engojb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The ma'ayanot (springs) also of the tehom and the floodgates of Shomayim were stopped, and the geshem from Shomayim was restrained; ");
INSERT INTO engojb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","And the waters receded from on ha'aretz continually; and after the end of the hundred and fifty days the waters were abated. ");
INSERT INTO engojb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","And the tevah (ark) rested in the seventh month, on the seventeenth day of the month, upon the mountains of Ararat. ");
INSERT INTO engojb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","And the waters decreased continually until the tenth month; in the tenth month, on the first day of the month, were the rashei heharim seen. ");
INSERT INTO engojb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","And it came to pass at the end of arba'im yom, that Noach opened the chalon (window) of the tevah (ark) which he had made; ");
INSERT INTO engojb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","And he sent forth the orev (raven), which went forth to and fro, until the waters were dried up from off ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Also he sent forth a yonah (dove) from him, to see if the waters were abated from off the face of the adamah; ");
INSERT INTO engojb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the yonah found no manoach (place of rest) for the sole of her foot, and she returned unto him into the tevah, for the waters were on the p'nei kol ha'aretz; then he reached forth his yad, and took her, and pulled her in unto him into the tevah (ark). ");
INSERT INTO engojb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","And he waited yet another shivat yamim; and again he sent forth the yonah out of the tevah (ark); ");
INSERT INTO engojb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","And the yonah returned to him in the erev; and, hinei, in her beak was a zayit (olive) leaf freshly plucked; so Noach had da'as that the mayim were abated from off ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","And he waited yet another shivat yamim; and sent forth the yonah; which returned not unto him again. ");
INSERT INTO engojb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","And it came to pass in the six hundredth and first year, in the first month, the first day of the month, the mayim were dried up from off ha'aretz; and Noach removed the mikhseh (covering) of the tevah (ark), and looked, and, hinei, the surface of the adamah was dry. ");
INSERT INTO engojb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","And in the second month, on the seven and twentieth day of the month, was ha'aretz dry. ");
INSERT INTO engojb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","And Elohim spoke unto Noach, saying, ");
INSERT INTO engojb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Go forth of the tevah (ark), thou, and thy isha, and thy banim, and the nashim of thy banim with thee. ");
INSERT INTO engojb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring forth with thee every living thing that is with thee, of kol basar, both of bird, and of behemah, and of every creeping thing that creepeth upon ha'aretz; that they may multiply abundantly on ha'aretz, and be fruitful, and increase upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","And Noach went forth, and his banim, and his isha, and the nashim of his banim with him; ");
INSERT INTO engojb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every animal, every remes, and every bird, and whatsoever creepeth upon ha'aretz, after their kinds, went forth out of the tevah (ark). ");
INSERT INTO engojb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","And Noach built a Mizbe'ach unto Hashem; and took of every behemah hatehorah, and of kol haoph hatahor, and offered olot (burnt offerings) on the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","And Hashem smelled a re'ach hannichoach; and Hashem said in His lev, I will not again curse the adamah any more ba'avur (because of) haAdam; for the yetzer of the lev haAdam is rah from his ne'urim (youth, childhood); neither will I again strike any more every thing living, as I have done. ");
INSERT INTO engojb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","While ha'aretz remaineth, zera (seedtime) and katzir (harvest), and kor (cold) and chom (heat), and kayitz (summer) and choref (winter), and yom and lailah, shall not cease. ");
INSERT INTO engojb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Vayevarech Elohim et Noach and his banim, and said unto them, Be fruitful, and multiply, and replenish ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","And the fear of you and the dread of you shall be upon every beast of ha'aretz, and upon every bird of the air, upon all that moveth upon ha'adamah, and upon all the dagim of the yam; into your yad are they delivered. ");
INSERT INTO engojb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every remes that liveth shall be food for you; even as the yarok esev (green plant) have I given you all. ");
INSERT INTO engojb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But basar with the nefesh thereof, which is the dahm thereof, shall ye not eat. ");
INSERT INTO engojb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","And surely your dahm of your nefeshot will I require; at the hand of every beast will I require it, and at the yad haAdam; at the hand of every manʼs brother will I require the nefesh haAdam. ");
INSERT INTO engojb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Shofech dahm (one who sheddeth manʼs blood), by man shall his dahm be shed; for in the tzelem Elohim made He man. ");
INSERT INTO engojb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","And you, be ye fruitful, and multiply; bring forth abundantly on ha'aretz, and multiply therein. ");
INSERT INTO engojb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","And Elohim spoke unto Noach, and to his banim with him, saying, ");
INSERT INTO engojb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","And I, hineni, I establish My brit (covenant) with you, and with your zera after you; ");
INSERT INTO engojb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","And with kol nefesh that is with you, of the bird, of the behemah, and of every animal of ha'aretz with you; from kol yotzei hatevah (all that go out of the ark), to every creature of ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","And I will establish My brit (covenant) with you, neither shall kol basar yikaret (be cut off, violently killed) any more by the waters of the mabbul; neither shall there be any more mabbul l'shacheit (to destroy) ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And Elohim said, This is the ot (sign) of the brit (covenant) which I make between Me and you and every nefesh chayyah (living creature) that is with you, for dorot olam (perpetual generations); ");
INSERT INTO engojb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I do set My keshet (bow) in the anan (cloud), and it shall be for an ot brit between Me and ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","And it shall come to pass, when I bring an anan over ha'aretz, that the keshet be'anan (rainbow) shall be seen; ");
INSERT INTO engojb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","And I will remember My brit, which is between Me and you and kol nefesh chayyah of kol basar; and the waters shall no more become a mabbul (flood) l'shacheit (to destroy) kol basar. ");
INSERT INTO engojb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","And the keshet shall be in the anan; and I will look upon it, that I may remember the brit olam between Elohim and kol nefesh chayyah of kol basar that is upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","And Elohim said unto Noach, This is the ot habrit, which I have established between Me and kol basar that is upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","And the bnei Noach, that went forth of the tevah, were Shem, and Cham, and Yephet; and Cham is the av of Kena'an (Canaan). ");
INSERT INTO engojb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Shloshah (Three) are the bnei Noach; and of them was the kol ha'aretz populated. ");
INSERT INTO engojb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","And Noach began to be an ish ha'adamah (a man of the soil), and he planted a kerem (vineyard); ");
INSERT INTO engojb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","And he drank of the yayin, and became shikker (intoxicated); and he lay uncovered inside his ohel. ");
INSERT INTO engojb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","And Cham, the av of Kena'an, saw the erom (nakedness) of his av, and told his two achim on the outside. ");
INSERT INTO engojb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","And Shem and Yephet took a garment, and laid it upon both their shoulders, and walked backward, and covered the erom of their av; and their faces were turned the other way, and they saw not the erom of their av. ");
INSERT INTO engojb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","And Noach awoke from his yayin, and had da'as of what his ben katan had done unto him. ");
INSERT INTO engojb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","And he said, Arur (cursed) be Kena'an; an eved of avadim shall he be unto his achim. ");
INSERT INTO engojb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","And he said, Baruch Hashem Elohei Shem; and Kena'an shall be his eved. ");
INSERT INTO engojb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Elohim shall enlarge Yephet, and he shall dwell in the tents of Shem; and Kena'an shall be his eved. ");
INSERT INTO engojb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","And Noach lived after the mabbul three hundred and fifty years. ");
INSERT INTO engojb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","And all the days of Noach were nine hundred and fifty years; and he died. ");
INSERT INTO engojb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Now these are the toldot of the Bnei Noach: Shem, Cham, and Yephet; and unto them were banim born after the mabbul (flood). ");
INSERT INTO engojb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The Bnei Yephet: Gomer, and Magog, and Madai, and Yavan, and Tuval, and Meshech, and Tiras. ");
INSERT INTO engojb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","And the Bnei Gomer: Ashkenaz, and Riphat, and Togarmah. ");
INSERT INTO engojb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","And the Bnei Yavan: Elishah, and Tarshish, Kittim, and Dodanim. ");
INSERT INTO engojb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","By these were the coastlands of the Goyim divided in their lands; every one after his leshon, after their mishpechot, in their Goyim. ");
INSERT INTO engojb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","And the Bnei Cham: Cush, and Mitzrayim, and Put, and Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","And the Bnei Cush: Seva, and Chavilah, and Savtah, and Ra'amah, and Savtecha; and the Bnei Raamah: Sheva, and Dedan. ");
INSERT INTO engojb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","And Cush fathered Nimrod; he began to be a gibbor in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a gibbor, a hunter before Hashem; therefore it is said, like Nimrod the gibbor, the hunter before Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","And the beginning of his kingdom was Bavel, and Erech, and Akkad, and Calneh, in Eretz Shinar. ");
INSERT INTO engojb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Out of that land he went forth to Ashur, and built Nineveh, and Rechovot-Ir, and Kelach, ");
INSERT INTO engojb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","And Resen between Nineveh and Kelach; the same is haIr Hagedolah. ");
INSERT INTO engojb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","And Mitzrayim fathered Ludim, and Anamim, and Lehavim, and Naphtuchim, ");
INSERT INTO engojb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","And Patrusim, and Casluchim, out of whom came Pelishtim (Philistines), and Caphtorim. ");
INSERT INTO engojb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","And Kena'an fathered Tzidon his bechor, and Chet, ");
INSERT INTO engojb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","And the Yevusi, and the Emori, and the Girgashi, ");
INSERT INTO engojb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","And the Chivi, and the Arki, and the Sini, ");
INSERT INTO engojb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","And the Arvadi, and the Tzemari, and the Chamati; and afterward were the mishpechot haKena'ani spread abroad. ");
INSERT INTO engojb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","And the boundary of the Kena'ani was from Tzidon, as thou comest to Gerar, unto Azah (Gaza); as thou goest, unto Sodom, and Amora (Gomorrah), and Admah, and Tzevoyim, even unto Lesha. ");
INSERT INTO engojb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are the Bnei Cham, after their mishpechot, after their leshonot, in their territories, and in their Goyim. ");
INSERT INTO engojb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Also unto Shem avi kol Bnei Ever, and the older brother of Yephet, even to him were offspring born. ");
INSERT INTO engojb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The Bnei Shem: Eilam, and Ashur, and Arpachshad, and Lud, and Aram. ");
INSERT INTO engojb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","And Bnei Aram: Utz, and Chul, and Geter, and Mash. ");
INSERT INTO engojb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","And Arpachshad fathered Shelach; and Shelach fathered Ever. ");
INSERT INTO engojb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","And unto Ever were born two banim: the shem of one was Peleg; for in his days was ha'aretz divided; and his brotherʼs shem was Yoktan. ");
INSERT INTO engojb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","And Yoktan fathered Almodad, and Sheleph, and Chatzarmavet, and Yerach, ");
INSERT INTO engojb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","And Hadoram, and Uzal, and Diklah, ");
INSERT INTO engojb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","And Oval, and Avimael, and Sheva, ");
INSERT INTO engojb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","And Ophir, and Chavilah, and Yovav; all these were the Bnei Yoktan. ");
INSERT INTO engojb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","And their moshav (dwelling) was from Mesha, as thou goest unto Sephar har hakedem. ");
INSERT INTO engojb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the Bnei Shem, after their mishpechot, according to their leshonot, in their territories, after their Goyim. ");
INSERT INTO engojb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are the mishpechot of the Bnei Noach, after their toldot, in their Goyim; and by these were the Goyim divided/separated in ha'aretz after the mabbul. ");
INSERT INTO engojb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","And the kol HaAretz was of one language and of devarim achadim (common words). ");
INSERT INTO engojb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","And it came to pass, as they migrated from the east, that they found a plain in Eretz Shinar; and they dwelt there. ");
INSERT INTO engojb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","And they said one to another, Come, let us make brick, and bake them thoroughly. And they had brick for even (stone), and bitumen had they for mortar. ");
INSERT INTO engojb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","And they said, Come, let us build us an Ir and a Migdal, whose rosh (top) may reach unto Shomayim; and let us make us a shem, otherwise we shall be scattered abroad upon the face of kol HaAretz. ");
INSERT INTO engojb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","And Hashem came down to see the Ir and the Migdal, which Bnei HaAdam built. ");
INSERT INTO engojb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","And Hashem said, See, the Am is echad and they have all one language; and this they begin to do; and now nothing will be impossible for them, which they have proposed to do. ");
INSERT INTO engojb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let Us go down, and there confuse their sefat, that they may not understand one anotherʼs language. ");
INSERT INTO engojb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So Hashem scattered them abroad from there upon the face of kol Ha'Aretz; and they left off building the Ir. ");
INSERT INTO engojb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Therefore is the shem of it called Bavel; because Hashem did there confuse the language of kol Ha'Aretz; and from there did Hashem scatter them abroad upon the face of kol Ha'Aretz. ");
INSERT INTO engojb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","These are the toldot of Shem: Shem was a hundred years old, and fathered Arpachshad two years after the mabbul; ");
INSERT INTO engojb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And Shem lived after he fathered Arpachshad five hundred shanah, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","And Arpachshad lived five and thirty shanah, and fathered Shelach; ");
INSERT INTO engojb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And Arpachshad lived after he fathered Shelach four hundred and three shanim, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","And Shelach lived thirty shanah, and fathered Ever; ");
INSERT INTO engojb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And Shelach lived after he fathered Ever four hundred and three shanah, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","And Ever lived four and thirty shanah, and fathered Peleg; ");
INSERT INTO engojb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And Ever lived after he fathered Peleg four hundred and thirty shanah, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","And Peleg lived thirty shanah, and fathered Reu; ");
INSERT INTO engojb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And Peleg lived after he fathered Reu two hundred and nine shanim, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","And Reu lived two and thirty shanah, and fathered Serug; ");
INSERT INTO engojb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And Reu lived after he fathered Serug two hundred and seven shanim, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","And Serug lived thirty shanah, and fathered Nachor; ");
INSERT INTO engojb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And Serug lived after he fathered Nachor two hundred shanah, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","And Nachor lived nine and twenty shanah, and fathered Terach; ");
INSERT INTO engojb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And Nachor lived after he fathered Terach a hundred and nineteen shanah, and fathered banim and banot. ");
INSERT INTO engojb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","And Terach lived seventy shanah, and fathered Avram, Nachor, and Haran. ");
INSERT INTO engojb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Now these are the toldot Terach: Terach fathered Avram, Nachor, and Haran; and Haran fathered Lot. ");
INSERT INTO engojb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","And Haran died before his av Terach in the land of his birth, in Ur Kasdim. ");
INSERT INTO engojb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Avram and Nachor took them nashim: the shem eshet Avram was Sarai; and the shem eshet Nachor was Milcah, the bat Haran Avi Milcah, and Avi Yiskah. ");
INSERT INTO engojb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","But Sarai was barren; she had no child. ");
INSERT INTO engojb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","And Terach took Avram bno, and ben bno Lot ben Haran, and Sarai his shnur, eshet Avram bno; and they went forth with them from Ur Kasdim, to go into Eretz Kena'an; and they came unto Charan (Haran), and dwelt there. ");
INSERT INTO engojb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","And the days of Terach were two hundred and five shanim; and Terach died in Charan (Haran). ");
INSERT INTO engojb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now Hashem had said unto Avram, Get thee out of thy country, and from thy kindred, and from the bais avicha, unto ha'aretz that I will show thee; ");
INSERT INTO engojb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","So that I will make of thee a goy gadol (great nation), so that I will bless thee, and make thy shem great; and so thou shalt be a brocha (blessing); ");
INSERT INTO engojb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","And I will bless the one blessing you, and curse him that curses you; and kol mishpochot haadamah shall be blessed through you. ");
INSERT INTO engojb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Avram departed as Hashem had told him; and Lot went with him; and Avram was seventy and five years old when he departed out of Charan. ");
INSERT INTO engojb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Avram took Sarai his isha, and Lot his brotherʼs son, and all their possessions that they had amassed, and the nefesh that they had gotten in Charan; and they went forth to go into the land of Kena'an; and they arrived in the land of Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","And Avram passed through the land unto the makom Shechem, unto Elon Moreh. And the Kena'ani was then in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","And Hashem appeared unto Avram, and said, Unto thy zera will I give ha'aretz hazot: and there built he a mizbe'ach unto Hashem, Who appeared unto him. ");
INSERT INTO engojb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","And he removed from there unto the harah mikedem Beit-El, and pitched his tent, having Beit-El on the west, and Ai on the east; and there he built a Mizbe'ach unto Hashem, and called upon the Shem of Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","And Avram journeyed, going on still toward the Negev. ");
INSERT INTO engojb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","And there was a ra'av in the land; and Avram went down into Mitzrayim to sojourn there; for the ra'av was severe in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","And it came to pass, when he was about to enter into Mitzrayim, that he said unto Sarai his isha, Hinei now, I know that thou art an isha yafeh to look upon; ");
INSERT INTO engojb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Therefore it shall come to pass, when the Egyptians shall see thee, that they shall say, This is his isha; and they will kill me, but they will save thee alive. ");
INSERT INTO engojb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Say, now, thou art my achot; that it may be well with me for thy sake; and my nefesh shall live on account of thee. ");
INSERT INTO engojb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","And it came to pass, that, when Avram was come into Mitzrayim, the Egyptians beheld the isha that she was yafeh me'od. ");
INSERT INTO engojb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","The sarim of Pharaoh also saw her, and commended her before Pharaoh; and the isha was taken into Bais Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","And he treated Avram well for her sake: and he acquired sheep and oxen, and male donkeys, and avadim, and shfachot, and female donkeys, and camels. ");
INSERT INTO engojb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","And Hashem plagued Pharaoh and his Bais with nega'im gedolim because of Sarai eshet Avram. ");
INSERT INTO engojb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","And Pharaoh summoned Avram and said, What is this that thou hast done unto me? Why didst thou not tell me that she was thy isha? ");
INSERT INTO engojb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why saidst thou, She is my achot? So I might have taken her to me to wife; now therefore, hinei, thy wife, take her, and go! ");
INSERT INTO engojb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","And Pharaoh commanded his anashim concerning him; and they sent him away, and his isha, and all that he had. ");
INSERT INTO engojb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","And Avram went up out of Mitzrayim, he, and his isha, and all that he had, and Lot with him, into the Negev. ");
INSERT INTO engojb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","And Avram was very rich in cattle, in kesef, and in zahav. ");
INSERT INTO engojb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","And he went on his journeys from the Negev even to Beit-El, unto the makom where his ohel had been at the beginning, between Beit-El and Ai; ");
INSERT INTO engojb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Unto the makom of the Mizbe'ach, which he had built there at the first; and there Avram called on the Shem of Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","And Lot also, which walked with Avram, had tzon, and herds, and ohalim. ");
INSERT INTO engojb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","And ha'aretz was not able to bear them, that they might dwell together; for their rechush was rav, so that they could not dwell together. ");
INSERT INTO engojb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","And there was a riv between the ro'im of the herd of Avram and the ro'im of the herd of Lot; and the Kena'ani and the Perizzi dwelt then in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","And Avram said unto Lot, Let there be no merivah now between me and thee, and between my ro'im and thy ro'im; for we are achim. ");
INSERT INTO engojb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not the kol ha'aretz before thee? Separate thyself, now, from me; if thou wilt take the left hand, then I will go to the right; or if thou depart to the right hand, then I will go to the left. ");
INSERT INTO engojb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","And Lot lifted up his eyes, and beheld all the plain of Yarden, that it was well watered everywhere, before Hashem destroyed Sodom and Amora, even as the Gan Hashem, like Eretz Mitzrayim, as you go to Tzoar. ");
INSERT INTO engojb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Then Lot chose for him all the plain of Yarden; and Lot journeyed mikedem (east); and they separated themselves the one from his brother. ");
INSERT INTO engojb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram dwelled in Eretz Kena'an, and Lot dwelled in the cities of the plain, and pitched his ohel toward Sodom. ");
INSERT INTO engojb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","But the men of Sodom were ra'im and chatta'im before Hashem exceedingly. ");
INSERT INTO engojb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","And Hashem said unto Avram, after that Lot was separated from him, Lift up now thine eyes, and look from the makom where thou art northward, and southward and eastward, and westward: ");
INSERT INTO engojb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","For kol ha'aretz which thou seest, to thee will I give it, and to thy zera ad olam (forever). ");
INSERT INTO engojb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","And I will make thy zera as the dust of ha'aretz; so that if a man can number the aphar of ha'aretz, then shall thy zera also be numbered. ");
INSERT INTO engojb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Arise, walk through ha'aretz in the length of it and in the breadth of it; for I will give it unto thee. ");
INSERT INTO engojb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Then Avram moved his ohel, and came and dwelt in Elonei Mamre, which is in Chevron, and built there a Mizbe'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","And it came to pass in the yamim of Amraphel Melech Shinar, Aryoch Melech Ellasar, Kedorlaomer Melech Eilam, and Tidal Melech Goyim; ");
INSERT INTO engojb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","That these made milchamah with Bera Melech Sodom, and with Birsha Melech Amora (Gomorrah), Shinav Melech Admah, and Shemever Melech Tzevoyim, and the Melech of Bela, which is Tzoar. ");
INSERT INTO engojb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these were joined together in the Valley of Siddim which is the Yam HaMelach. ");
INSERT INTO engojb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Twelve shanah they served Kedorlaomer, and in the thirteenth year they rebelled. ");
INSERT INTO engojb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","And in the fourteenth year came Kedorlaomer, and the melachim that were with him, and they defeated the Repha'im in Ashterot Karnayim, and the Zuzim in Ham, and the Emim in Shaveh-Kiryatayim, ");
INSERT INTO engojb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","And the Chori in their Mt Se'ir, as far as Eil-Paran, which is near the midbar. ");
INSERT INTO engojb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","And they turned, and came to Ein Mishpat, which is Kadesh, and conquered all the country of the Amaleki, and also the Emori, that dwelt in Chatzetzon-Tamar. ");
INSERT INTO engojb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","And there went out the Melech Sodom, and the Melech Amora (Gomorrah), and the Melech Admah, and the Melech Tzevoyim, and the Melech Bela (that is, Tzoar); and they joined in milchamah with them in the Valley of Siddim; ");
INSERT INTO engojb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","With Kedorlaomer Melech Eilam, and with Tidal Melech Goyim, and Amraphel Melech Shinar, and Aryoch Melech Ellasar; four melachim against five. ");
INSERT INTO engojb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","And the Valley of Siddim was full of tar pits; and the Melech Sodom and Amora (Gomorrah) they fled, and fell there; and they that remained fled to the mountain. ");
INSERT INTO engojb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","And they took all the possessions of Sodom and Amora (Gomorrah), and all their ochel, and went their way. ");
INSERT INTO engojb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","And they took Lot, Avramʼs brotherʼs son, who dwelt in Sodom, and his possessions, and departed. ");
INSERT INTO engojb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","And there came one that had escaped, and told Avram HaIvri; for he dwelt in Elonei Mamre the Emori, brother of Eshcol, and brother of Aner; and these were Ba'alei Brit Avram. ");
INSERT INTO engojb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","And when Avram heard that his brother was taken captive, he armed his trained men, born in his own bais, three hundred and eighteen, and pursued them as far as Dan. ");
INSERT INTO engojb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","And he divided himself against them, he and his avadim, by lailah, and routed them, and pursued them as far as Chovah, which is on the left hand (north) of Damascus. ");
INSERT INTO engojb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","And he recovered all the possessions, and also brought again his brother Lot, and his possessions, and the nashim also, and the people. ");
INSERT INTO engojb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","And the Melech Sodom went out to meet him after his return from the defeat of Kedorlaomer, and of the melachim that were with him, at the Valley of Shaveh, which is the Valley of the King. ");
INSERT INTO engojb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","And Malki-Tzedek Melech Shalem brought forth lechem and yayin and he was the kohen of El Elyon. ");
INSERT INTO engojb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","And he blessed him, and said, Baruch Avram by El Elyon, Possessor of Shomayim va'Aretz; ");
INSERT INTO engojb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","And baruch El Elyon, Who hath delivered thine enemies into thy hand. And he gave him ma'aser (tithe) of all. ");
INSERT INTO engojb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","And the Melech Sodom said unto Avram, Give me the nefesh and keep the possessions for thyself. ");
INSERT INTO engojb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","And Avram said to the Melech Sodom, I have lifted up mine hand unto Hashem, El Elyon Possessor of Shomayim va'Aretz, ");
INSERT INTO engojb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","That I will not take from a thread even to the thong of a sandal, and that I will not take any thing that is thine, lest thou shouldest say, I have made Avram rich; ");
INSERT INTO engojb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Save only that which the young men have eaten, and the chelek of the anashim which went with me, Aner, Eshcol, and Mamre; let them take their chelek. ");
INSERT INTO engojb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things the Devar Hashem came unto Avram in a makhazeh, saying, Fear not, Avram; I am thy mogen, and thy exceeding great sachar (reward). ");
INSERT INTO engojb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","And Avram said, Adonoi Hashem, what wilt Thou give me, since I go childless, and the Ben Meshek of my Bais is this Eli'ezer of Damesek (Damascus)? ");
INSERT INTO engojb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","And Avram said, See, to me Thou hast given no zera; and, hinei, one born in my bais is my yoresh (heir). ");
INSERT INTO engojb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","And, hinei, the Devar Hashem came unto him saying, This shall not be thy yoresh; but he that shall come forth out of thine own body shall be thy yoresh. ");
INSERT INTO engojb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","And He brought him forth outside, and said, Look now toward Shomayim, and count the kokhavim, if thou be able to number them; and He said unto him, So shall thy zera be. ");
INSERT INTO engojb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","And he believed in Hashem; and He credited emunah (faith) to him as tzedakah (righteousness). ");
INSERT INTO engojb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","And He said unto him, I am Hashem Who brought thee out of Ur Kasdim, to give thee ha'aretz hazot to be the yoresh of it. ");
INSERT INTO engojb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","And he said, Adonoi Hashem, how can I have da'as that I will be its yoresh? ");
INSERT INTO engojb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","And He said unto him, Bring Me a heifer meshuleshet, and a she goat meshuleshet, and a ram meshulash, and a dove, and a pigeon. ");
INSERT INTO engojb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","And he brought unto Him all these, and divided them in two, and laid each half one opposite another; but the birds divided he not. ");
INSERT INTO engojb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","And when the birds of prey came down upon the carcasses, Avram drove them away. ");
INSERT INTO engojb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","And when the shemesh was going down, a tardemah fell upon Avram; and, hinei, a horror of great darkness fell upon him. ");
INSERT INTO engojb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","And Hashem said unto Avram, Know of a surety that thy zera shall be a ger in a land not their own, and will serve them; and they will mistreat them arba me'ot shanah; ");
INSERT INTO engojb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","And also that nation, whom they shall serve, will I judge; and afterward shall they come out with rechush gadol (great substance). ");
INSERT INTO engojb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","And thou shalt go to thy avot in shalom; thou shalt be buried at a good old age. ");
INSERT INTO engojb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","But in the fourth generation they shall come back here again; for the avon (iniquity) of the Emori (Amorite) is not yet full. ");
INSERT INTO engojb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","And it came to pass, that, when the shemesh went down, and it was dark, hinei a smoking fire-pot, and a blazing torch passed between those pieces. ");
INSERT INTO engojb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","On that day Hashem cut a brit (covenant) with Avram, saying, Unto thy zera have I given ha'aretz hazot, from the Wadi of Mitzrayim unto the great river, the river Euphrates: ");
INSERT INTO engojb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","the land of the Keni, and the Kenizzi, and the Kadmoni, ");
INSERT INTO engojb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","And the Chitti, and the Perizzi, and the Repha'im, ");
INSERT INTO engojb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","And the Emori, and the Kena'ani, and the Girgashi, and the Yevusi. ");
INSERT INTO engojb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Sarai Avramʼs isha bore him no children; and she had a shifchah, an Egyptian, whose shem was Hagar. ");
INSERT INTO engojb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","And Sarai said unto Avram, Hinei now, Hashem hath restrained me from bearing; go now in unto my shifchah; it may be that I may build family by her. And Avram paid heed to the voice of Sarai. ");
INSERT INTO engojb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","And Sarai Avramʼs isha took Hagar her shifchah the Egyptian, after Avram had dwelt ten years in Eretz Kena'an, and gave her to her husband Avram to be his isha. ");
INSERT INTO engojb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","And he went in unto Hagar, and she conceived; and when she saw that she had conceived, her gevirah was despised in her eyes. ");
INSERT INTO engojb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","And Sarai said unto Avram, My wrong be upon thee; I have given my shifchah unto thy kheyk; and when she saw that she had conceived, I was despised in her eyes; Hashem judge between me and thee. ");
INSERT INTO engojb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","But Avram said unto Sarai, Hinei, thy shifchah is in thy hand; do to her as it pleaseth thee. And when Sarai dealt harshly with her, she fled from her face. ");
INSERT INTO engojb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","And the Malach Hashem found her by a spring of mayim in the midbar, near the spring on the road to Shur. ");
INSERT INTO engojb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","And he said, Hagar, Saraiʼs shifchah, from where camest thou? And where wilt thou go? And she said, I flee from the face of my gevirah Sarai. ");
INSERT INTO engojb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","And the Malach Hashem said unto her, Return to thy gevirah, and submit thyself under her hands. ");
INSERT INTO engojb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","And the Malach Hashem said unto her, I will multiply thy zera exceedingly, that it shall not be numbered for multitude. ");
INSERT INTO engojb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","And the Malach Hashem said unto her, See, thou art with child and shalt bear ben, and shalt call shmo Yishmael; because Hashem shema thy oni (misery). ");
INSERT INTO engojb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","And he will be a pere adam; his yad will be against kol, and kol yad against him; and he shall dwell in the presence of all his brethren. ");
INSERT INTO engojb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","And she called the Shem of Hashem Who spoke unto her, El Roi (G-d Who Sees); for she said, Have I also here seen after Him that seeth me? ");
INSERT INTO engojb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Therefore the well was called Be'er Lachai Roi; hinei, it is between Kadesh and Bered. ");
INSERT INTO engojb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","And Hagar bore Avram ben; and Avram called shem bno, which Hagar bore, Yishmael (Ishmael). ");
INSERT INTO engojb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","And Avram was fourscore and six shanah when Hagar bore Yishmael to Avram. ");
INSERT INTO engojb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","And when Avram was ninety and nine shanah, Hashem appeared to Avram, and said unto him, I am El Shaddai; walk before Me, and be thou tamim (blameless). ");
INSERT INTO engojb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","And I will confirm My brit (covenant) between Me and thee, and will multiply thee exceedingly. ");
INSERT INTO engojb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","And Avram fell on his face; and Elohim talked with him, saying, ");
INSERT INTO engojb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","As for Me, hinei, My brit (covenant) is with thee, and thou shalt be an Av of many Goyim. ");
INSERT INTO engojb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Neither shall thy shem any more be called Avram, but thy shem shall be Avraham; for Av hamon Goyim (Father of a multitude of Goyim) have I made thee. ");
INSERT INTO engojb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","And I will make thee exceeding fruitful, and I will make Goyim of thee, and Melechim shall come out of thee. ");
INSERT INTO engojb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","And I will establish My Brit (covenant) between Me and thee and thy zera after thee in their dorot for a Brit Olam, to be Elohim unto thee, and to thy zera after thee. ");
INSERT INTO engojb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","And I will give unto thee, and to thy zera after thee, the Eretz wherein thou art now a ger, kol Eretz Kena'an, for an Achuzzah (Possession) Olam (Everlasting); and I will be their Elohim. ");
INSERT INTO engojb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","And Elohim said unto Avraham, Thou shalt be shomer over My Brit therefore, thou, and thy zera after thee in the dorot. ");
INSERT INTO engojb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is My Brit (covenant), which ye shall be shomer over, between Me and you and thy zera after thee; every zachar among you shall be circumcised. ");
INSERT INTO engojb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","And ye shall circumcise the basar of your arelah; and it shall be an ot brit (sign of the covenant) between Me and you. ");
INSERT INTO engojb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","And he that is eight days old shall be circumcised among you, every zachar in your dorot, he that is born in the bais, or bought with kesef of any foreigner, which is not of thy zera. ");
INSERT INTO engojb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","He that is born in thy bais, and he that is bought with thy kesef, must be circumcised; and My Brit shall be in your basar for a Brit Olam. ");
INSERT INTO engojb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","And the arel (uncircumcised) zachar whose basar of his arelah (foreskin) is not circumcised, that nefesh shall be cut off from his people; My Brit hefer (he broke). ");
INSERT INTO engojb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","And Elohim said unto Avraham, As for Sarai thy isha, thou shalt not call her shem Sarai, but Sarah (Princess) shall her shem be. ");
INSERT INTO engojb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","And I will bless her, and give thee ben also of her; yes, will bless her, and she shall give rise to Goyim; melechim of peoples shall be from her. ");
INSERT INTO engojb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Then Avraham fell upon his face, and yitzchak (laughed), and said in his lev, Shall a child be born unto him that is a hundred shanah? And shall Sarah, that is ninety shanah, bear? ");
INSERT INTO engojb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","And Avraham said unto HaElohim, O that Yishmael might live before Thee! ");
INSERT INTO engojb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","And Elohim said, Sarah thy isha shall bear thee ben indeed; and thou shalt call shmo Yitzchak; and I will establish My Brit (covenant) with him for a Brit Olam, and with his zera after him. ");
INSERT INTO engojb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","And as for Yishmael, I have heard thee; hinei, I have blessed him, and will make him fruitful, and will multiply him exceedingly; twelve nasi'im (princes, rulers) shall he father, and I will make him a goy gadol (great nation). ");
INSERT INTO engojb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But My Brit (covenant) will I establish with Yitzchak, which Sarah shall bear unto thee at mo'ed hazeh (this set time) next year. ");
INSERT INTO engojb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","And He left off speaking with him, and Elohim went up from Avraham. ");
INSERT INTO engojb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","And Avraham took Yishmael bno, and all that were born in his bais, and all that were bought with his kesef, every zachar among the men of Avrahamʼs bais; and circumcised the basar of their arelah in the very same day, as Elohim had said unto him. ");
INSERT INTO engojb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","And Avraham was ninety shanah and nine, when he was circumcised in the basar of his arelah. ");
INSERT INTO engojb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","And Yishmael bno was thirteen shanah, when he was circumcised in the basar of his arelah (foreskin). ");
INSERT INTO engojb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","In the very same day was Avraham circumcised, and Yishmael bno. ");
INSERT INTO engojb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","And all the men of his bais, born in the bais, and bought with kesef of the foreigner, were circumcised with him. ");
INSERT INTO engojb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","And Hashem appeared unto him in the terebinth trees of Mamre; and he sat in the entrance of the ohel (tent) in the heat of the day; ");
INSERT INTO engojb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","And he lifted up his eyes and looked, and, hinei, Shloshah Anashim (Three Men) stood by him; and when he saw them, he ran to meet them from the entrance of the ohel, and prostrated himself on the ground, ");
INSERT INTO engojb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","And said, Adonoi, if now I have found chen (favor) in Thy sight, pass not on by, please, from Thy servant; ");
INSERT INTO engojb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let a little water, please, be brought, and wash Thy feet, and rest under haetz (the tree); ");
INSERT INTO engojb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","And I will bring a morsel of bread, and refresh Ye Your hearts; after that Ye shall pass on; because for this purpose are Ye come to Your servant. And they said, So do, as thou hast said. ");
INSERT INTO engojb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","And Avraham hastened into the ohel unto Sarah, and said, Make ready quickly shlosh measures of fine meal, knead it, and make cakes. ");
INSERT INTO engojb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","And Avraham ran unto the herd, and brought a calf tender and tov, and gave it unto a servant; and he hasted to prepare it. ");
INSERT INTO engojb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","And he took curds, and cholov (milk), and the calf which he had prepared, and set it before them; and he stood by them under haetz, and they did eat. ");
INSERT INTO engojb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","And they said unto him, Where is Sarah thy wife? And he said, Hinei, in the ohel. ");
INSERT INTO engojb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","And He said, I will certainly return unto thee at this time next year; and, hinei, Sarah thy wife shall have ben (son). And Sarah heard it in the entrance of the ohel, which was behind him. ");
INSERT INTO engojb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Now Avraham and Sarah were zekenim (old ones) and well stricken in age; and in childbearing it ceased to be with Sarah after the manner of women. ");
INSERT INTO engojb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Therefore Sarah laughed titzchak, sounds like Yitzchak within herself, saying, After I am grown old shall I have pleasure, adoni being old also? ");
INSERT INTO engojb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","And Hashem said unto Avraham, Why did Sarah laugh, saying, Shall I which am old of a surety bear a child? ");
INSERT INTO engojb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is any thing too hard for Hashem? At the time appointed I will return unto thee, in due season, and Sarah shall have ben (son). ");
INSERT INTO engojb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah denied, saying, I laughed not; for she was afraid. And He said, Oh yes but thou didst laugh. ");
INSERT INTO engojb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","And the Anashim rose up from thence, and peered toward Sodom; and Avraham went with them to send them on the way. ");
INSERT INTO engojb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","And Hashem said, Shall I hide from Avraham that thing which I do; ");
INSERT INTO engojb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Seeing that Avraham shall surely become a great and mighty nation, and kol goyei ha'aretz (all the nations of the earth) shall be blessed in him? ");
INSERT INTO engojb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","For I know him, that he will command his children and his household after him, and they shall be shomer over the Derech Hashem, to do tzedakah and mishpat; that Hashem may bring upon Avraham that which He hath spoken promised of him. ");
INSERT INTO engojb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","And Hashem said, Because the outcry of Sodom and Amora is great, and because their sin is very grievous; ");
INSERT INTO engojb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go down now, and see whether they have done altogether according to the crying out for punishment of it, which is come unto Me; and if not, I will have da'as. ");
INSERT INTO engojb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","And the Men turned their faces from thence, and went toward Sodom; but Avraham stood yet before Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","And Avraham drew near, and said, Wilt Thou also destroy the tzaddik with the rasha? ");
INSERT INTO engojb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Suppose there be fifty tzaddikim within the city; wilt Thou also destroy and not nasa (spare) the place lema'an (for the sake of) the fifty tzaddikim that are therein? ");
INSERT INTO engojb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","That be far from Thee to do after this manner, to slay the tzaddik with the rasha; and that the tzaddik should be as the rasha, that be far from Thee: Shall not HaShofet Kol Ha'Aretz (the Judge of All the Earth) do mishpat (right)? ");
INSERT INTO engojb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","And Hashem said, If I find in Sodom fifty tzaddikim within the city, then I will spare all the place for their sakes. ");
INSERT INTO engojb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","And Avraham answered and said, Hinei now, I, which am but aphar and ashes, have taken upon me to speak unto Hashem; ");
INSERT INTO engojb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Suppose there shall lack five of the fifty tzaddikim; wilt Thou destroy all the city for lack of five? And He said, If I find there forty and five, I will not destroy it. ");
INSERT INTO engojb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","And he spoke unto Him yet again, and said, Suppose there shall be forty found there. And He said, I will not do it for fortyʼs sake. ");
INSERT INTO engojb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","And he said unto Him, Oh let not Hashem be angry, and I will speak; suppose there shall thirty be found there. And He said, I will not do it, if I find thirty there. ");
INSERT INTO engojb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","And he said, Hinei now, I have taken upon me to speak unto Hashem: suppose there shall be twenty found there. And He said, I will not destroy it for twentyʼs sake. ");
INSERT INTO engojb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","And he said, Oh let not Hashem be angry, and I will speak yet but this once: suppose asarah (ten, i.e., a minyan) shall be found there. And He said, I will not destroy it for the sake of haasarah (the ten). ");
INSERT INTO engojb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","And Hashem went His way, as soon as He had left communing with Avraham; and Avraham returned unto his makom. ");
INSERT INTO engojb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","And there came two malachim to Sodom at erev; and Lot sat in the sha'ar Sodom; and Lot seeing them rose up to meet them; and he bowed himself with his face toward the ground; ");
INSERT INTO engojb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","And he said, Hinei, adonai (my masters), turn in, now, into the bais avdechem, and tarry all night, and wash your feet, and ye shall rise up early, and go on your ways. And they said, Lo; but we will abide the night in the rekhov. ");
INSERT INTO engojb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","And he pressed upon them greatly; and they turned in unto him, and entered into his bais; and he made them a mishteh (meal, feast), and did bake matzot, and they did eat. ");
INSERT INTO engojb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","But before they lay down, the men of the Ir, even the anshei Sodom, surrounded the bais, from na'ar to zeken, all the people from every quarter of the city; ");
INSERT INTO engojb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","And they called unto Lot, and said unto him, Where are the anashim which came in to thee halailah (this night)? Bring them out unto us, that we may know them carnally. ");
INSERT INTO engojb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","And Lot went outside unto them, and shut the delet after him, ");
INSERT INTO engojb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","And said, Now, achai (my brethren), do not so wickedly. ");
INSERT INTO engojb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Hinei now, I have two banot which have not known man; now let me bring them out unto you, and do ye to them as is good in your eyes; only unto these anashim do nothing; for therefore came they under the tzel (shadow) of my korah (beam, roof). ");
INSERT INTO engojb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","And they said, Stand back. And they said again, This one fellow came in to sojourn as a ger (alien), and he will now play the shofet; now will we deal worse with thee, than with them. And they pressed strongly upon the man, even Lot, and came near to break down the delet. ");
INSERT INTO engojb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the anashim put forth their yad, and pulled Lot into the bais to them, and shut the delet. ");
INSERT INTO engojb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","And they struck the men that were at the petach of the bais with blindness, both katan and gadol; so that they wearied themselves to find the petach. ");
INSERT INTO engojb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","And the anashim said unto Lot, Hast thou here any one else? Choson (Son-in-law), and thy banim, and thy banot, and whatsoever thou hast in the Ir, bring them out of this makom (place); ");
INSERT INTO engojb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","For we are the mashchitim (ones destroying) this makom (place), because the cry of them is so gedolah before the face of Hashem; and Hashem hath sent us to destroy it. ");
INSERT INTO engojb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","And Lot went out, and spoke unto his chosonim, which were pledged to marry his banot, and said, Up, get you out of makom hazeh; for Hashem is mashchit (destroying) the Ir (City). But he seemed as one that metzachek (joked) unto his chosonim. ");
INSERT INTO engojb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","And when the shachar came, then the malachim urged Lot, saying, Arise, take thy isha, and thy two banot, which are here or thou be swept away in the avon haIr. ");
INSERT INTO engojb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","And while he lingered hesitating, the anashim laid hold upon his yad, and upon the yad of his isha, and upon the yad of his two banot; Hashem being merciful unto him; and they brought him out and set him outside the Ir. ");
INSERT INTO engojb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","And it came to pass, when they had brought them forth outside, that he said, Flee and escape for thy nefesh; look not back behind thee, neither stop thou anywhere in all the plain; flee and escape to the mountain, lest thou be swept away. ");
INSERT INTO engojb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","And Lot said unto them, Oh, not so, Adonoi (My L-rd): ");
INSERT INTO engojb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Hinei now, thy eved hath found chen in Thy sight, and Thou hast magnified Thy chesed, which Thou hast showed unto me in sparing my nefesh; and I cannot flee to escape to the mountain, lest some ra'ah overtake me, and I die; ");
INSERT INTO engojb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hinei now, this Ir is near to run unto, and it is a little one; Oh, let me flee to escape there, (is it not mitzar small?), and my nefesh shall live. ");
INSERT INTO engojb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","And He said unto him, Hinei, I have accepted thee concerning this thing also, that I will not overthrow the Ir, for the which thou hast spoken. ");
INSERT INTO engojb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haste thee, flee to escape there; for I cannot do anything till thou arrive there. Therefore the shem of the Ir was called Tzoar. ");
INSERT INTO engojb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The shemesh rose over ha'aretz when Lot entered Tzoar. ");
INSERT INTO engojb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then Hashem rained upon Sodom and upon Amora gofrit and eish from Hashem out of Shomayim; ");
INSERT INTO engojb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","And He overthrew those cities, and all the plain, and all the inhabitants of the cities, and tzemach (what grew) upon haadamah. ");
INSERT INTO engojb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But his isha, from behind him, looked back, and she became a netziv melach (pillar of salt). ");
INSERT INTO engojb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","And Avraham got up early in the boker to the makom where he stood there before Hashem; ");
INSERT INTO engojb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","And he looked down toward Sodom and Amora, and toward all the eretz of the plain, and hinei, he saw kitor (smoke, steam) of the eretz go up like kitor of a furnace. ");
INSERT INTO engojb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","And it came to pass, when Elohim destroyed the cities of the plain, that zikron Avraham came to Elohim, and He sent Lot out of the midst of the hafekhah (upheaval, destruction, overthrow), when He overthrew the cities in the which Lot dwelt. ");
INSERT INTO engojb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","And Lot left Tzoar, and dwelt in the har, and his two banot with him; for he feared to dwell in Tzoar: and he dwelt in a cave, he and his two banot. ");
INSERT INTO engojb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","And the bechirah said unto the younger, Avinu is old, and there is not an ish in ha'aretz to come in unto us after the derech of kol ha'aretz: ");
INSERT INTO engojb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let us make avinu drink yayin, and we will lie with him, that we may preserve zera by avinu. ");
INSERT INTO engojb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","And they made their av drink yayin balailah: and the bechirah went in, and lay with her av; and he had da'as not when she lay down, nor when she arose. ");
INSERT INTO engojb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","And it came to pass on the next day, that the bechirah said unto the younger, Hinei, I lay yesternight with avi. Let us make him drink yayin halailah also; and go thou in, and lie with him, that we may preserve zera by avinu. ");
INSERT INTO engojb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","And they made their av drink yayin balailah also; and the younger arose, and lay with him; and he had da'as not when she lay down, nor when she arose. ");
INSERT INTO engojb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Thus were both the banot of Lot with child by their av. ");
INSERT INTO engojb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","And the bechirah bore ben, and called shmo Moav; the same is the Avi Moav unto this day. ");
INSERT INTO engojb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","And the younger, she also bore ben, and called shmo Ben-Ammi; the same is the Avi Bnei Ammon unto this day. ");
INSERT INTO engojb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","And Avraham journeyed from there toward the Negev region, and dwelled between Kadesh and Shur, and sojourned in Gerar. ");
INSERT INTO engojb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","And Avraham said of Sarah his isha, She is my achot; and Avimelech Melech Gerar sent, and took Sarah. ");
INSERT INTO engojb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But Elohim came to Avimelech in a chalom halailah, and said to him, See, thou art met (dead), for the isha which thou hast taken; for she is be'ulat ba'al (married of a husband). ");
INSERT INTO engojb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","But Avimelech had not come near her; and he said, Adonoi, wilt Thou slay also a goy tzaddik? ");
INSERT INTO engojb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Said he not unto me, She is my achot? and she, even she herself said, He is achi: in the tohm (integrity, guilelessness) of my lev and with clean hands of my innocency have I done this. ");
INSERT INTO engojb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","And HaElohim said unto him in a chalom, Yea, I have da'as that thou didst this in the tohm (integrity, guilelessness) of thy lev; for I also withheld thee from sinning against Me; therefore allowed I thee not to touch her. ");
INSERT INTO engojb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Now therefore restore the ish his isha; for he is a navi, and he shall pray for thee, and thou shalt live; and if thou restore her not, know thou that thou shalt surely die, thou, and all that are thine. ");
INSERT INTO engojb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Therefore Avimelech rose early in the boker, and called all his avadim, and told all these things in their ears; and the anashim were very afraid. ");
INSERT INTO engojb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Avimelech called Avraham, and said unto him, What hast thou done unto us? and how have I offended thee, that thou hast brought on me and on my mamlechah (kingdom) a chata'ah gedolah (great sin)? thou hast done deeds unto me that ought not to be done. ");
INSERT INTO engojb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","And Avimelech said unto Avraham, What sawest thou, that thou hast done this thing? ");
INSERT INTO engojb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","And Avraham said, Because I thought, Surely the yirat Elohim is not in this place; and they will slay me on account of my isha. ");
INSERT INTO engojb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","And yet indeed she is my achot; she is the bat avi, but not the bat immi; and she became my isha. ");
INSERT INTO engojb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","And it came to pass, when Elohim caused me to wander from my bais avi, that I said unto her, This is thy chesed which thou shalt show unto me; at every place where we shall come, say of me, He is achi. ");
INSERT INTO engojb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","And Avimelech took tzon, and oxen, and avadim, and shfachot, and gave them unto Avraham, and restored to him Sarah his isha. ");
INSERT INTO engojb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Avimelech said, Hinei, my land is before thee; dwell where it pleaseth thee. ");
INSERT INTO engojb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","And unto Sarah he said, Hinei, I have given thy brother a thousand pieces of kesef; hinei, it is to thee a kesut einayim (covering of the eyes, exoneration), unto all that are with thee, and with all other; thus she was vindicated. ");
INSERT INTO engojb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","So Avraham davened unto Elohim: and Elohim healed Avimelech, and his isha, and his maidservants so that they bore children. ");
INSERT INTO engojb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For Hashem had fast closed up kol rechem (every womb) of the bais Avimelech, on account of Sarah Avrahamʼs isha. ");
INSERT INTO engojb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","And Hashem visited Sarah as He had said, and Hashem did unto Sarah just as He had spoken. ");
INSERT INTO engojb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","For Sarah conceived, and bore Avraham ben in his old age, at the mo'ed (set time) of which Elohim had given promise unto him. ");
INSERT INTO engojb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","And Avraham called the shem of bno that was born unto him, whom Sarah bore to him, Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","And Avraham circumcised bno Yitzchak at age shemonat yamim, as Elohim had commanded him. ");
INSERT INTO engojb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","And Avraham was a hundred years old, when bno Yitzchak was born unto him. ");
INSERT INTO engojb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","And she said, Elohim hath brought me tzechok (laughter), so that all that hear yitzchak (will laugh) with me. ");
INSERT INTO engojb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","And she said, Who would have said unto Avraham, that Sarah should nurse banim? for I have borne him ben in his old age. ");
INSERT INTO engojb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","And the yeled grew, and was weaned; and Avraham made a mishteh gadol the same day that Yitzchak was weaned. ");
INSERT INTO engojb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","And Sarah saw the ben of Hagar the Egyptian, which she had borne unto Avraham, metzachek (mocking, scoffing). ");
INSERT INTO engojb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Therefore she said unto Avraham, Cast out this bondwoman and her ben: for the ben of this bondwoman shall not be heir with beni (my son), even with Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","And the thing was very grievous in the eyes of Avraham because of bno. ");
INSERT INTO engojb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","And Elohim said unto Avraham, Let it not be grievous in thy sight because of the na'ar, and because of thy bondwoman; in all that Sarah hath said unto thee, shema (pay heed) unto her voice; for in Yitzchak shall thy zera be called. ");
INSERT INTO engojb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","And also of the ben haamah will I make a nation, because he is thy zera. ");
INSERT INTO engojb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","And Avraham rose up early in the boker, and took lechem, and a skin of mayim, and gave it unto Hagar, putting it on her shoulder, and the yeled, and sent her away; and she departed, and wandered in the midbar of Be'er-Sheva. ");
INSERT INTO engojb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","And the mayim in the skin was done, and she cast the yeled under one of the bushes. ");
INSERT INTO engojb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","And she went off, and sat down about a bowshot away: for she thought, Let me not see the mot hayeled. And she sat there nearby, and lifted up her voice, and wept. ");
INSERT INTO engojb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","And Elohim heard the voice of the na'ar; and the Malach Elohim called to Hagar out of Shomayim, and said unto her, Mah lach, Hagar? fear not; for Elohim hath heard the voice of the na'ar where he is. ");
INSERT INTO engojb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Arise, lift up the na'ar, and hold him in thine yad; for I will make him a goy gadol. ");
INSERT INTO engojb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","And Elohim opened her eyes, and she saw a be'er of mayim; and she went, and filled the skin with mayim, and gave the na'ar drink. ");
INSERT INTO engojb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","And Elohim was with the na'ar; and he grew, and dwelt in the midbar, and became a roveh keshet (an archer). ");
INSERT INTO engojb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","And he dwelt in the midbar of Paran: and his em got him an isha out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","And it came to pass at that time, that Avimelech and Phichol the sar tz'va of his spoke unto Avraham, saying, Elohim is with thee in all that thou doest: ");
INSERT INTO engojb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now therefore swear unto me here before Elohim that thou wilt not deal falsely with me, nor with my child, nor with my descendant: but according to the chesed that I have showed thee, thou shalt do unto me, and to the eretz wherein thou hast sojourned. ");
INSERT INTO engojb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Avraham said, I will swear. ");
INSERT INTO engojb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","And Avraham reproved Avimelech because of a be'er hamayim, which Avimelechʼs avadim had violently seized. ");
INSERT INTO engojb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","And Avimelech said, I know not who hath done this thing; neither didst thou tell me, neither yet heard I of it, but today. ");
INSERT INTO engojb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","And Avraham took tzon and oxen, and gave them unto Avimelech; and both of them made a brit. ");
INSERT INTO engojb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","And Avraham set apart seven ewe lambs of the tzon by themselves. ");
INSERT INTO engojb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","And Avimelech said unto Avraham, What mean these seven ewe lambs which thou hast set apart by themselves? ");
INSERT INTO engojb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","And he said, For these sheva ewe lambs shalt thou accept of my hand, that they may be a witness unto me, that I have dug this well. ");
INSERT INTO engojb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Therefore he called that place Be'er-Sheva; because there they swore an oath both of them. ");
INSERT INTO engojb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Thus they made a brit at Be'er-Sheva: then Avimelech rose up, and Phichol the sar tzeva of his, and they returned into eretz Pelishtim. ");
INSERT INTO engojb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","And Avraham planted an eshel (tamarisk tree) in Be'er-Sheva, and called there on the Shem of Hashem El Olam. ");
INSERT INTO engojb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","And Avraham sojourned in eretz Pelishtim yamim rabbim. ");
INSERT INTO engojb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","And it came to pass after these things, that G-d did test Avraham, and said unto him, Avraham: and he said, Hineini (Behold, here I am). ");
INSERT INTO engojb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","And He said, Take now thy son, thine ben yachid (only son) Yitzchak, whom thou lovest, and get thee into eretz Moriyah; and offer him there for a burnt offering upon one of the mountains which I will tell thee of. ");
INSERT INTO engojb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","And Avraham rose up early in the morning, and saddled his donkey, and took two of his servants with him, and Yitzchak his son, and cut the wood for the burnt offering, and rose up, and went unto the place of which G-d had told him. ");
INSERT INTO engojb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Then on Yom HaShlishi Avraham lifted up his eyes, and saw the place afar off. ");
INSERT INTO engojb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","And Avraham said unto his servants, Abide ye here with the donkey; and I and the young man will go over there and nishtachaveh (we will worship) and we will come back again to you. ");
INSERT INTO engojb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","And Avraham took atzei haolah (the wood of the burnt offering), and laid it upon Yitzchak his son; and he took the eish (fire) in his hand, and a knife; and they went both of them together. ");
INSERT INTO engojb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","And Yitzchak spoke unto Avraham his father, and said, Avi (My father): and he said, Hineini, beni (Here am I, my son). And he said, Hinei, the eish (fire) and the wood: but where is the seh (lamb) for a burnt offering? ");
INSERT INTO engojb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","And Avraham said, My son, G-d will provide Himself a seh (lamb) for a burnt offering: so they went both of them together. ");
INSERT INTO engojb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","And they came to the place which G-d had told him of; and Avraham built a mizbe'ach there, and laid the wood in order, and made the akedah (binding) of Yitzchak his son, and laid him on the mizbe'ach upon the wood. ");
INSERT INTO engojb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","And Avraham stretched forth his hand, and took the knife to slay his son. ");
INSERT INTO engojb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","And the Malach Hashem called unto him out of Shomayim, and said, Avraham, Avraham: and he said, Hineini. ");
INSERT INTO engojb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","And he said, Lay not thine hand upon the young man, neither do thou any thing unto him: for now I know that thou fearest G-d, seeing thou hast not withheld thy son, thine ben yachid from Me. ");
INSERT INTO engojb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","And Avraham lifted up his eyes, and looked, and hinei behind him a ram caught in a thicket by his horns: and Avraham went and took the ram, and offered him up for a burnt offering TAKHAT (instead of)  his son. ");
INSERT INTO engojb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Avraham called the name of that place Hashem Yireh: as it is said to this day, In the mount of Hashem it shall be provided. ");
INSERT INTO engojb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","And the Malach Hashem called unto Avraham out of Shomayim the second time, ");
INSERT INTO engojb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","And said, By Myself have I sworn, saith Hashem, for because thou hast done this thing, and hast not withheld thy son, thine ben yachid: ");
INSERT INTO engojb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","That in blessing I will bless thee, and in multiplying I will multiply thy zera as the stars of the skies, and as the sand which is upon the sea shore; and thy zera shall possess the gate of his enemies; ");
INSERT INTO engojb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","And in thy zera shall kol goyei ha'aretz be blessed; because thou hast obeyed My voice. ");
INSERT INTO engojb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","So Avraham returned unto his servants, and they rose up and went together to Be'er-Sheva; and Avraham dwelt at Be'er-Sheva. ");
INSERT INTO engojb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","And it came to pass after these things, that it was told Avraham, saying, Hinei, Milcah, she hath also born children unto thy brother Nachor; ");
INSERT INTO engojb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Utz his bechor (firstborn), and Buz his brother, and Kemuel the father of Aram, ");
INSERT INTO engojb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","And Kesed, and Chazo, and Pildash, and Yidlaph, and Betuel. ");
INSERT INTO engojb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","And Betuel fathered Rivkah: these eight Milcah did bear to Nachor, Avrahamʼs brother. ");
INSERT INTO engojb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","And his pilegesh, whose name was Reumah, she bare also Tevach, and Gacham, and Tachash, and Maachah. ");
INSERT INTO engojb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","And Sarah was an hundred and seven and twenty shanah old: these were the shnei chayyai Sarah. ");
INSERT INTO engojb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","And Sarah died in Kiryat-Arba; the same is Chevron in eretz Kena'an: and Avraham came to mourn for Sarah, and to weep for her. ");
INSERT INTO engojb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","And Avraham stood up from before his dead, and spoke unto the bnei Chet, saying, ");
INSERT INTO engojb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","I am a ger and a sojourner with you: give me an achuzzah (possession) of a kever with you, that I may bury my dead out of my sight. ");
INSERT INTO engojb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","And the bnei Chet answered Avraham, saying unto him, ");
INSERT INTO engojb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Hear us, adoni: thou art a nasi Elohim among us; in the choice of kevareinu bury thy dead; none of us shall withhold from thee his kever, that thou mayest bury thy dead. ");
INSERT INTO engojb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","And Avraham stood up, and bowed himself to the am ha'aretz, even to the bnei Chet. ");
INSERT INTO engojb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","And he spoke to them, saying, If it be your nefesh (will) that I should bury my dead out of my sight; hear me, and intercede for me to Ephron ben Tzochar, ");
INSERT INTO engojb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","That he may give me the cave of Machpelah, which he hath, which is in the end of his sadeh; for the kesef maleh (full price) he shall give it me for an achuzzah (possession) of a kever amongst you. ");
INSERT INTO engojb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","And Ephron dwelt among the bnei Chet: and Ephron the Chitti answered Avraham in the hearing of the bnei Chet, even of all that went in at the sha'ar of his city, saying, ");
INSERT INTO engojb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Lo, adoni, hear me; the sadeh give I thee, and the cave that is therein, I give it thee; in the presence of the bnei ammi give I it thee; bury thy dead. ");
INSERT INTO engojb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","And Avraham bowed down himself before the am ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","And he spoke unto Ephron in the hearing of the am ha'aretz, saying, But if thou wilt give it, now, hear me; I will give thee kesef for the sadeh; accept it from me, and I will bury my dead there. ");
INSERT INTO engojb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","And Ephron answered Avraham, saying unto him, ");
INSERT INTO engojb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Pay heed, adoni, unto me; the land is worth four hundred shekels of kesef; what is that between me and thee? bury therefore thy dead. ");
INSERT INTO engojb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","And Avraham paid heed unto Ephron; and Avraham weighed to Ephron the kesef, which he had named in the hearing of the bnei Chet four hundred shekels of kesef, according to current merchant value. ");
INSERT INTO engojb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","And the sadeh of Ephron which was in Machpelah, which was near Mamre, the sadeh, and the cave which was therein, and all the trees that were in the sadeh, that were in all the borders round about, were deeded ");
INSERT INTO engojb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Unto Avraham for a property in the presence of the bnei Chet, before all that went in at the sha'ar of his city. ");
INSERT INTO engojb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","And after this, Avraham buried Sarah his isha in the cave of the sadeh of Machpelah near Mamre; the same is Chevron in the eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","And the sadeh, and the cave that is therein, were deeded unto Avraham for an achuzzah of a kever by the bnei Chet. ");
INSERT INTO engojb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","And Avraham was zaken (old), and well stricken in age; and Hashem berach (had blessed) Avraham in all things. ");
INSERT INTO engojb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","And Avraham said unto his eved zekan of his bais, hamoshel (that ruled) over all that he had, Put, now, thy yad under my thigh; ");
INSERT INTO engojb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","And I will make thee swear by Hashem Elohei HaShomayim and Elohei Ha'Aretz, that thou shalt not take an isha unto beni of the Banot HaKena'ani, among whom I dwell: ");
INSERT INTO engojb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","But thou shalt go unto my eretz, and to my moledet, and take an isha unto beni Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","And the eved said unto him, What if the isha will not be willing to follow me unto HaAretz Hazot: must I needs bring binecha back unto ha'aretz from where thou camest? ");
INSERT INTO engojb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","And Avraham said unto him, Beware thou that thou bring not beni to there! ");
INSERT INTO engojb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hashem Elohei HaShomayim, which took me from bais avi, and from the eretz of my moledet, and which spoke unto me, and that swore unto me, saying, Unto thy zera will I give HaAretz Hazot; He shall send His Malach before thee, and thou shalt take an isha unto beni from there. ");
INSERT INTO engojb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","But if the isha will not be willing to follow thee, then thou shalt be released from this my shevu'ah (oath): only do not bring back beni there. ");
INSERT INTO engojb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","And the eved put his yad under yerech Avraham adonav, and swore to him concerning this matter. ");
INSERT INTO engojb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","And the eved took asarah gemalim of the gemalei adonav, and departed; for all the goods of adonav were in his yad: and he arose, and went to Aram Naharayim (Mesopotamia), unto the Ir Nachor. ");
INSERT INTO engojb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","And he made his gemalim to kneel down outside the Ir near a be'er hamayim at the time of erev, at the time that women go out to draw mayim. ");
INSERT INTO engojb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","And he said Hashem Elohei adoni Avraham, now, send me success this yom, and show chesed unto adoni Avraham. ");
INSERT INTO engojb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Hinei, I stand here by the ayin hamayim; and the banot anshei haIr come out to draw mayim; ");
INSERT INTO engojb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","And let it come to pass, that the na'arah to whom I shall say, Let down thy jug, now, that I may drink; and she shall say, Drink, and I will give thy gemalim drink also; let the same be she that Thou hast appointed for Thy eved Yitzchak; and thereby shall I know that Thou hast showed chesed unto adoni. ");
INSERT INTO engojb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","And it came to pass, before he had done speaking, that, hinei, Rivkah came out, who was born to Betuel Ben Milcah, eshet Nachor, achi Avraham, with her jug upon her shoulder. ");
INSERT INTO engojb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","And the na'arah was tovat mareh me'od, a betulah, neither had any ish known her: and she went down to haayenah (the spring), and filled her jug, and came up. ");
INSERT INTO engojb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","And the eved hurried to meet her, and said, Let me, now, drink a little mayim of thy jug. ");
INSERT INTO engojb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","And she said, Drink, adoni: and she hasted, and let down her jug upon her yad, and gave him drink. ");
INSERT INTO engojb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","And when she had done giving him drink, she said, I will draw for thy gemalim also, until they have done drinking. ");
INSERT INTO engojb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","And she hasted, and emptied her jug into the trough, and ran back unto the be'er to draw, and drew for all his gemalim. ");
INSERT INTO engojb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","And the ish gazed at her and held his peace, so as to have da'as whether Hashem had made his derech prosperous or not. ");
INSERT INTO engojb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And it came to pass, just as the gemalim had done drinking, that the ish took a nezem zahav (gold ring) by weight a beka, and two tzemidim (bracelets) by weight ten shekels of gold for her wrists; ");
INSERT INTO engojb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","And said, Whose bat art thou? Tell me, now: is there makom in the bais of thy av for us to spend the night? ");
INSERT INTO engojb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","And she said unto him, I am Bat Betuel Ben Milcah, the ben which she bore unto Nachor. ");
INSERT INTO engojb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","She said moreover unto him, We have both teven (straw) and mispo (fodder) enough, and makom (room) to spend the night. ");
INSERT INTO engojb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","And the ish bowed his head, worshiped Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","And he said, Baruch Hashem Elohei adoni Avraham, who hath not left destitute of His chesed and His emes; I being on the derech, Hashem led me to the bais achei adoni. ");
INSERT INTO engojb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","And the na'arah ran, and told them of her bais em these things. ");
INSERT INTO engojb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","And Rivkah had an ach, shmo Lavan; Lavan ran out unto the ish, unto the ayin. ");
INSERT INTO engojb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","And it came to pass, when he saw the nezem and tzemidim upon the wrists of his achot, and when he heard the words of Rivkah his achot, saying, Thus spoke the ish unto me; that he came unto the ish; and, hinei, he stood by the gemalim at the ayin. ");
INSERT INTO engojb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","And he said, Come in, Gebentshter fun Hashem; why standest thou outside? for I have prepared the bais, and makom for the gemalim. ");
INSERT INTO engojb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","And the ish came into the bais; and he unloaded his gemalim, and gave teven (straw) and mispo (fodder) for the camels, and mayim to wash his raglayim, and the raglei haanashim that were with him. ");
INSERT INTO engojb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","And there was set ochel before him to eat; but he said, I will not eat, until I have stated my business. And he said, Speak on. ");
INSERT INTO engojb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","And he said, I am eved Avraham. ");
INSERT INTO engojb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","And Hashem hath blessed adoni me'od; and he is become prospered: and He hath given him tzon, and bakar, and kesef, and zahav, and avadim, and shefachot, and gemalim, and chamorim. ");
INSERT INTO engojb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","And Sarah eshet adoni bore ben to adoni when she was old: and unto him hath he given all that he hath. ");
INSERT INTO engojb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","And adoni made me swear, saying, Thou shalt not take an isha for beni of the Banot HaKena'ani, in whose land I dwell; ");
INSERT INTO engojb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","But thou shalt go unto bais avi, to my mishpokhot, and take an isha unto beni. ");
INSERT INTO engojb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","And I said unto adoni, What if the isha will not follow me. ");
INSERT INTO engojb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","And he said unto me, Hashem, before Whom I walk, will send His Malach with thee, and prosper thy derech; and thou shalt take an isha for beni of my mishpokhot, and of my bais avi; ");
INSERT INTO engojb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Then shalt thou be released from this my oath, when thou comest to my mishpokhot; and if they give not thee one, thou shalt be released from my oath. ");
INSERT INTO engojb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","And I came this day unto the ayin, and said, Hashem Elohei adoni Avraham, if now Thou do prosper my derech which I go; ");
INSERT INTO engojb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hinei, I stand by the ayin hamayim; and it shall come to pass, that when haAlmah cometh forth to draw mayim, and I say to her, Give me, now, a little mayim of thy jar to drink; ");
INSERT INTO engojb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","And she say to me, Both drink thou, and I will also draw for thy gemalim; let the same be the isha whom Hashem hath appointed for ben adoni. ");
INSERT INTO engojb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","And before I had done davening in mine lev, hinei, Rivkah came forth with her jar on her shoulder; and she went down unto ha'ayenah, and drew: and I said unto her, Let me drink, now. ");
INSERT INTO engojb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","And she made haste, and let down her jar from her shoulder, and said, Drink, and I will give thy gemalim drink also: so I drank, and she made the gemalim drink also. ");
INSERT INTO engojb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","And I asked her, and said, Whose bat art thou? And she said, Bat Betuel Ben Nachor, the ben whom Milcah bore unto him: and I put the nezem upon her face, and the tzemidim upon her wrists. ");
INSERT INTO engojb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","And I bowed down my head, and worshiped Hashem, and I said a brocha to Hashem Elohei adoni Avraham, which had led me on the derech emes to take bat achi adoni for bno. ");
INSERT INTO engojb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","And now if ye will do chesed and emes to adoni, tell me; and if not, tell me; that I may turn to yamin, or to smol. ");
INSERT INTO engojb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Lavan and Betuel answered and said, The thing proceedeth from Hashem; we cannot speak unto thee rah or tov. ");
INSERT INTO engojb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Hinei, Rivkah is before thee, take her, and go, and let her be isha for ben adoneicha, just as Hashem hath spoken. ");
INSERT INTO engojb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","And it came to pass, that, when eved Avraham heard their words, he worshiped Hashem, bowing himself to the ground. ");
INSERT INTO engojb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","And the eved brought forth kelei kesef, and kelei zahav, and begadim, and gave them to Rivkah; he gave also to her ach and to her em migdanot (costly gifts). ");
INSERT INTO engojb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","And they did eat and drink, he and the anashim that were with him, and tarried all night; and they rose up in the boker, and he said, Send me away unto adoni. ");
INSERT INTO engojb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","And her ach and her em said, Let the na'arah abide with us ten days or so; after that she shall go. ");
INSERT INTO engojb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","And he said unto them, Hinder me not, seeing Hashem hath prospered my derech; send me away that I may go to adoni. ");
INSERT INTO engojb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","And they said, We will call the na'arah, and inquire at her mouth. ");
INSERT INTO engojb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","And they called Rivkah, and said unto her, Wilt thou go with this ish? And she said, I will go. ");
INSERT INTO engojb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","And they sent away Rivkah their achot, and her nurse, and eved Avraham, and his anashim. ");
INSERT INTO engojb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","And they said a brocha over Rivkah, and said unto her, Thou art achoteinu, may thou be increased to thousands upon thousands and may thy zera possess the sha'ar of those which hate them. ");
INSERT INTO engojb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","And Rivkah arose, and her na'arot, and they rode upon the gemalim, and followed the ish: and the eved took Rivkah, and went his way. ");
INSERT INTO engojb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","And Yitzchak had come from Be'er Lachai Roi; for he dwelt in the eretz hanegev. ");
INSERT INTO engojb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","And Yitzchak went out to meditate in the sadeh at erev: and he lifted up his eyes, and saw, and, hinei, the gemalim (camels) were coming. ");
INSERT INTO engojb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","And Rivkah lifted up her eyes, and when she saw Yitzchak, she got down from the gamal. ");
INSERT INTO engojb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","For she had said unto the eved, Who is that ish that walketh in the sadeh to meet us? And the eved had said, He is adoni: therefore she took a veil, and covered herself. ");
INSERT INTO engojb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","And the eved told Yitzchak all things that he had done. ");
INSERT INTO engojb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","And Yitzchak brought her into the ohel of Sarah immo, and took Rivkah, and she became his isha; and he loved her: and Yitzchak was comforted after the mot immo. ");
INSERT INTO engojb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Then again Avraham took an isha, and her shem was Keturah. ");
INSERT INTO engojb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","And she bore him Zimran, and Yokshan, and Medan, and Midyan, and Yishbak, and Shuach. ");
INSERT INTO engojb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","And Yokshan fathered Sheva, and Dedan. And the bnei Dedan were Ashurim, and Letushim, and Leummim. ");
INSERT INTO engojb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","And the bnei Midyan; Ephah, and Epher, and Chanokh, and Avida, and Eldaah. All these were the bnei Keturah. ");
INSERT INTO engojb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","And Avraham gave all that he had unto Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But unto the bnei hapilageshim (sons of the concubines), which Avraham had, Avraham gave mattanot, and sent them away from Yitzchak bno, while he yet lived, eastward, unto eretz kedem. ");
INSERT INTO engojb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","And these are the days of the years of Avrahamʼs life which he lived, a hundred threescore and fifteen shanim. ");
INSERT INTO engojb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Then Avraham breathed his last, and died in a good old age, a zaken, full of years; and was gathered to his people. ");
INSERT INTO engojb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","And his banim Yitzchak and Yishmael buried him in the cave of Machpelah, in the sadeh of Ephron ben Tzochar the Chitti, which is near Mamre; ");
INSERT INTO engojb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","The sadeh which Avraham purchased of the bnei Chet, there was Avraham buried, and Sarah his wife. ");
INSERT INTO engojb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","And it came to pass after the mot Avraham, that Elohim blessed Yitzchak bno; and Yitzchak dwelt near Be'er Lachai Roi. ");
INSERT INTO engojb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Now these are the toldot Yishmael ben Avraham, whom Hagar the Egyptian, shifchat Sarah, bore unto Avraham: ");
INSERT INTO engojb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","And these are the shemot bnei Yishmael, by their shemot, according to their toldot: the bechor of Yishmael, Nevayot; and Kedar, and Adbe'el, and Mivsam, ");
INSERT INTO engojb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","And Mishma, and Dumah, and Massa, ");
INSERT INTO engojb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Chadad, and Tema, Yetur, Naphish, and Kedmah: ");
INSERT INTO engojb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These are the bnei Yishmael, and these are their shemot, by their settlement, and by their camps; twelve nasiim (princes, rulers) according to their tribes. ");
INSERT INTO engojb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","And these are the years of the life of Yishmael, an hundred and thirty and seven shanah; and he breathed his last and died; and was gathered unto his people. ");
INSERT INTO engojb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","And they dwelt from Chavilah unto Shur, that is near Mitzrayim, as thou goest toward Assyria; they took their place east of their brethren. ");
INSERT INTO engojb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","And these are the toldot of Yitzchak ben Avraham: Avraham fathered Yitzchak; ");
INSERT INTO engojb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","And Yitzchak was arba'im shanah when he took Rivkah as his wife, the bat Betuel HaArami of Paddan-Aram, the achot Lavan HaArami. ");
INSERT INTO engojb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","And Yitzchak davened to Hashem on behalf of his isha, because she was barren; and Hashem was entreated of him, and Rivkah his isha conceived. ");
INSERT INTO engojb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","And the banim struggled jostling within her; and she said, If it be well, why am I thus? And she went to inquire of Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","And Hashem said unto her, Two goyim (nations) are in thy womb, and two peoples shall be separated from within thee; and the one people shall be stronger than the other people; and the older shall serve the younger. ");
INSERT INTO engojb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","And when her days were fulfilled to be delivered, hinei, there were twins in her womb. ");
INSERT INTO engojb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","And the first came out admoni (red) all over like a hairy garment; and they called shmo Esav. ");
INSERT INTO engojb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","And after that came out his brother, and his yad was grasping on akev Esav; and shmo was called Ya'akov; and Yitzchak was threescore shanah when she bore them. ");
INSERT INTO engojb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","And the nearim grew: and Esav was a skilled hunter, an ish sadeh; and Ya'akov was an ish tam (quiet man), dwelling in ohalim. ");
INSERT INTO engojb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","And Yitzchak loved Esav, because he did eat of his wild game; but Rivkah loved Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","And Ya'akov cooked stew: and Esav came from the sadeh, and he was famished. ");
INSERT INTO engojb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","And Esav said to Ya'akov, Let me eat now some of the adom (red stew); for I am famished; therefore was shmo called Edom. ");
INSERT INTO engojb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","And Ya'akov said, First sell me today thy bechorah (birthright, right of the firstborn). ");
INSERT INTO engojb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","And Esav said, Hinei, I am at the point of death; and what profit shall this bechorah do to me? ");
INSERT INTO engojb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","And Ya'akov said, Swear to me this day; and he swore unto him; and he sold his bechorah unto Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Ya'akov gave Esav lechem and adashim (lentils) stew; and he did eat and drink, and rose up, and went his way; thus Esav despised his bechorah. ");
INSERT INTO engojb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","And there was a ra'av (famine) in ha'aretz, besides the ra'av harishon that was in the days of Avraham. And Yitzchak went unto Avimelech Melech Pelishtim (Philistines) unto Gerar. ");
INSERT INTO engojb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","And Hashem appeared unto him, and said, Go not down into Mitzrayim; dwell in ha'aretz which I shall tell thee of; ");
INSERT INTO engojb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Sojourn in ha'aretz hazot, and I will be with thee, and will bless thee; for unto thee, and unto thy zera, I will give all these lands, and I will perform the shevu'ah (oath) which I swore unto Avraham avichah; ");
INSERT INTO engojb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","And I will make thy zera to multiply as the kokhavim of Shomayim, and will give unto thy zera all these lands; and in thy zera shall kol Goyei Ha'Aretz be blessed; ");
INSERT INTO engojb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Because Avraham obeyed My voice, and was shomer over My mishmeret (charge), My mitzvot, My chukkot, and My torot. ");
INSERT INTO engojb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","And Yitzchak dwelt in Gerar; ");
INSERT INTO engojb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","And the anshei hamakom asked him about his isha; and he said, She is my achot; for he feared to say, She is my isha; lest, said he, the anshei hamakom should kill me for Rivkah; because she was beautiful to look upon. ");
INSERT INTO engojb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","And it came to pass, when he had been there a long time, that Avimelech Melech Pelishtim (Philistines) looked out at a chalon, and saw, and, hinei, Yitzchak metzachek (was caressing) Rivkah his isha. ");
INSERT INTO engojb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","And Avimelech called Yitzchak, and said, Hinei, of a surety she is thy isha; and why saidst thou, She is my achot? And Yitzchak said unto him, Because I said, Lest I die because of her. ");
INSERT INTO engojb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","And Avimelech said, What is this thou hast done unto us? one of the people might lightly have slept with thy isha, and thou shouldest have brought asham (guilt) upon us. ");
INSERT INTO engojb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","And Avimelech charged all his people, saying, He that toucheth this man or his isha shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Then Yitzchak sowed in that land, and reaped in the same year a hundredfold; and Hashem blessed him. ");
INSERT INTO engojb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","And the man became very prosperous, and went forward, and grew until he became gadol me'od: ");
INSERT INTO engojb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","For he had possession of tzon, and possession of cattle, and many avadim; and the Pelishtim envied him. ");
INSERT INTO engojb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","For all the wells which avdei aviv had dug in the days of Avraham aviv, the Pelishtim had stopped them up, and filled them with dirt. ");
INSERT INTO engojb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","And Avimelech said unto Yitzchak, Go from us; for thou art much mightier than we. ");
INSERT INTO engojb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","And Yitzchak departed from there, and encamped in the valley of Gerar, and dwelt there. ");
INSERT INTO engojb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","And Yitzchak dug again the be'erot hamayim (wells of water), which they had dug in the days of Avraham aviv; for the Pelishtim had stopped them up after the mot Avraham; and he called their shemot after the shemot by which his av had called them. ");
INSERT INTO engojb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","And avdei Yitzchak dug in the valley, and found there a well of mayim chayyim. ");
INSERT INTO engojb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","And the herdmen of Gerar did quarrel with Yitzchakʼs herdmen, saying, The mayim is ours; and he called the shem of the well Esek (Contention); because they disputed with him. ");
INSERT INTO engojb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","And they dug another be'er, and feuded over that also; and he called the shem of it Sitnah (Enmity). ");
INSERT INTO engojb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","And he moved away from there, and dug another well; and for that they strove not: and he called the shem of it Rechovot (Broad Places); and he said, For now Hashem hath made rachav (room) for us, and we shall be fruitful in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","And he went up from there to Be'er-Sheva. ");
INSERT INTO engojb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","And Hashem appeared unto him balailah hahu, and said, I am Elohei Avraham avichah; fear not, for I am with thee, and will bless thee, and multiply thy zera for the sake of Avdi Avraham (My Servant Abraham). ");
INSERT INTO engojb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","And he built a Mizbe'ach there, and called upon the Shem of Hashem, and pitched his ohel there: and there avdei Yitzchak dug a well. ");
INSERT INTO engojb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Then Avimelech went to him from Gerar, and Achuzzat his adviser, and Phichol the sar tz'va of his. ");
INSERT INTO engojb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","And Yitzchak said unto them, Why come ye to me, seeing ye hate me, and have sent me away from you? ");
INSERT INTO engojb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","And they said, We saw certainly that Hashem was with thee; and we said, Let there be now an oath between us, even between us and thee, and let us cut a brit (covenant) with thee; ");
INSERT INTO engojb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","That thou wilt do us no ra'ah, just as we have not touched thee, and just as we have done unto thee nothing but tov, and have sent thee away in shalom; thou art now the Gebentshter fun Hashem(the blessed of Hashem). ");
INSERT INTO engojb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","And he made them a mishteh (feast), and they did eat and drink. ");
INSERT INTO engojb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","And they rose up early in the boker, and swore one to another: and Yitzchak sent them away, and they departed from him in shalom. ");
INSERT INTO engojb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","And it came to pass the same day, that the avdei Yitzchak came, and told him concerning the be'er which they had dug, and said unto him, We have found mayim. ");
INSERT INTO engojb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","And he called it Shevah (Seven, Oath): therefore the shem of the Ir is Be'er-Sheva unto this day. ");
INSERT INTO engojb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","And Esav was arba'im shanah when he took to wife Yehudit the bat Be'eri the Chitti, and Basmat the bat Elon the Chitti: ");
INSERT INTO engojb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","and they were a morat ruach (grief of mind) unto Yitzchak and Rivkah. ");
INSERT INTO engojb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","And it came to pass, that when Yitzchak was zaken (old),and his eyes were dim, so that he could not see, he called Esav bno hagadol and said unto him, Beni: and he said unto him, Hineni. ");
INSERT INTO engojb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","And he said, Hinei now, I am old, I know not my yom mot: ");
INSERT INTO engojb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Therefore take, now, thy kelim (weapons), thy quiver and thy keshet (bow), and go out to the sadeh, and hunt me some wild game; ");
INSERT INTO engojb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","And make me matamim (savory meat, tasty food), such as I love, and bring it to me, that I may eat; that my nefesh may make a brocha upon thee before I die. ");
INSERT INTO engojb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","And Rivkah heard when Yitzchak spoke to Esav bno. And Esav went to the sadeh to hunt for wild game, and to bring it. ");
INSERT INTO engojb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","And Rivkah spoke unto Ya'akov her ben, saying, Hinei, I heard avicha speak unto Esav achicha, saying, ");
INSERT INTO engojb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bring me wild game, and make me matamim, that I may eat, and make a brocha upon thee before Hashem before my mot. ");
INSERT INTO engojb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now therefore, beni (my son), obey my kol (voice) according to that which I command thee. ");
INSERT INTO engojb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go now to the tzon, and bring me from there two gedayei izzim tovim (good kids of goats); and I will make them matamim for avicha, such as he loveth: ");
INSERT INTO engojb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","And thou shalt bring it to avicha, that he may eat, and that he may make a brocha upon thee before his mot. ");
INSERT INTO engojb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","And Ya'akov said to Rivkah immo, Look, Esav achi is an ish sa'ir (hairy man), and I am an ish chalak (smooth man). ");
INSERT INTO engojb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","What if avi will touch me, and I shall seem to him as a meta'te'a (mocker); and I shall bring a kelalah upon me, and not a brocha. ");
INSERT INTO engojb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","And immo said unto him, Upon me be thy kelalah, beni; only obey my kol (voice), and go bring me them. ");
INSERT INTO engojb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","And he went, and got, and brought them to immo: and immo made matamim, such as aviv loved. ");
INSERT INTO engojb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","And Rivkah took begadim of Esav her ben hagadol, the chamudot (best ones) which were with her in the bais, and dressed Ya'akov her ben hakatan; ");
INSERT INTO engojb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","And with orot gedayei haizzim (skins of the kids of the goats) she dressed and covered his hands, and also upon the smooth of his tzavar (neck); ");
INSERT INTO engojb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","And she gave the matamim and the lechem, which she had prepared, into the yad Ya'akov her ben. ");
INSERT INTO engojb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","And he came unto aviv, and said, Avi; and he said, Hineni; who art thou, beni? ");
INSERT INTO engojb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","And Ya'akov said unto aviv, I am Esav thy bechor; I have done according as thou told me; arise, now, sit up and eat of my wild game, that thy nefesh may make a brocha upon me. ");
INSERT INTO engojb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","And Yitzchak said unto bno, How is it that thou hast found it so quickly, beni? And he said, Hashem Eloheicha worked it out for me. ");
INSERT INTO engojb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","And Yitzchak said unto Ya'akov, Come near, now, that I may touch thee, beni, indeed, whether thou be beni Esav or not. ");
INSERT INTO engojb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","And Ya'akov went near unto Yitzchak aviv; and he touched him, and said, The kol is kol Ya'akov, but the yadayim are the yedei Esav. ");
INSERT INTO engojb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","And he discerned him not, for his hands were se'irot, as yedei Esav achiv; so he made a brocha upon him. ");
INSERT INTO engojb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","And he said, Art thou indeed beni Esav? And he said, I am. ");
INSERT INTO engojb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","And he said, Bring it near to me, and I will eat of the wild game of beni, that my nefesh may make a brocha upon thee. And he brought it near to him, and he did eat; and he brought him yayin and he drank. ");
INSERT INTO engojb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","And aviv Yitzchak said unto him, Come near now, and kiss me beni. ");
INSERT INTO engojb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","And he came near, and kissed him: and he smelled the reiach (smell) of his begadim, and made a brocha upon him, and said, See, the reiach of beni is as the reiach of a sadeh upon which Hashem hath made a brocha; ");
INSERT INTO engojb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Therefore HaElohim give thee of the tal haShomayim, and the fatness of ha'aretz, and plenty of dagan and tirosh; ");
INSERT INTO engojb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Let people serve thee, and amim bow down to thee: be gevir over thy achim, and let bnei immecha bow down to thee: arur be every one that curseth thee, and baruch be he that blesseth thee. ");
INSERT INTO engojb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","And as soon as Yitzchak had completed making on Ya'akov a brocha, and Ya'akov had hardly gone out from the presence of Yitzchak aviv, that Esav achiv came in from his hunt. ");
INSERT INTO engojb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","And he also had prepared matamim, and brought it unto aviv and said unto aviv, Let avi arise, and eat of the wild game of bno, that thy nefesh may make a brocha upon me. ");
INSERT INTO engojb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","And Yitzchak aviv said unto him, Mi atah? (Who art thou?) And he said, I am binecha, thy bechor Esav. ");
INSERT INTO engojb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","And Yitzchak trembled with charadah gedolah ad me'od (exceedingly great trembling), and said, Who? Where is he that hath hunted wild game, and brought it me, and I have eaten of all of it before thou camest, and have made a brocha upon him? And indeed he shall be baruch (blessed)! ");
INSERT INTO engojb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","And when Esav heard the words of aviv, he cried with tzeakah gedolah umarah ad me'od (a great and exceeding bitter cry), and said unto aviv, Make a brocha on me, even me also, O avi. ");
INSERT INTO engojb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","And he said, Achicha came with mirmah (deceit), and hath taken away thy brocha. ");
INSERT INTO engojb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","And he said, Is not he rightly called shmo Ya'akov? for vaya'keveni (now he deceived/outwitted me) these two times he took away my bechorah (birthright); and, hinei, now he hath taken away my brocha (blessing). And he asked, Hast thou not reserved a brocha for me? ");
INSERT INTO engojb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","And Yitzchak answered and said unto Esav, See, I have made him gevir over you, and all his achim have I given to him for avadim; and with dagan and tirosh have I sustained him; and what shall I do now unto thee, beni? ");
INSERT INTO engojb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","And Esav said unto aviv, Hast thou but one brocha, avi? Make a brocha on me, even me also, O avi. And Esav lifted up his kol (voice), and wept. ");
INSERT INTO engojb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","And Yitzchak aviv answered and said unto him, Hinei, thy moshav (dwelling) shall be the fatness of ha'aretz, and of the tal HaShomayim from above; ");
INSERT INTO engojb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","And by thy cherev shalt thou live, and shalt serve achicha; and it shall come to pass when thou shalt become restless, that thou shalt break his ol (yoke) from off thy tzavar (neck). ");
INSERT INTO engojb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","And Esav hated Ya'akov because of the brocha wherewith aviv made a brocha upon him: and Esav said in his lev, The yemei evel (days of mourning) for avi are at hand; then will I slay Ya'akov achi. ");
INSERT INTO engojb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","And these words of Esav her ben hagadol were told to Rivkah; and she sent and called Ya'akov her ben hakatan, and said unto him, Hinei, Esav achicha, as touching thee, doth console himself, purposing to kill thee. ");
INSERT INTO engojb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Now therefore, beni, shema bekoli (listen to my voice)! Arise, flee thou to Lavan achi to Charan; ");
INSERT INTO engojb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","And tarry with him a few days, until chamat achicha subsides; ");
INSERT INTO engojb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","And when af achicha subsides from thee, and he forget that which thou hast done to him; then I will send, and get thee from there. Why should I be bereaved also of you both in yom echad (one day, the same day)? ");
INSERT INTO engojb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","And Rivkah said to Yitzchak, I am weary of my life because of the Banot Chet: if Ya'akov take an isha of the Banot Chet (Hittite women) such as these which are of the banot ha'aretz, what will chayyim to me be? ");
INSERT INTO engojb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","And Yitzchak called for Ya'akov, and blessed him, and charged him, and said unto him, Thou shalt not take an isha of the Banot Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Arise, go to Paddanah-Aram, to the bais Betuel avi immecha; and take thee an isha from there of the banot Lavan achi immecha. ");
INSERT INTO engojb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","And El Shaddai bless thee, and make thee fruitful, and multiply thee, that thou mayest be a kahal amim; ");
INSERT INTO engojb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","And give thee the birkat Avraham, to thee, and to thy zera with thee; that thou mayest inherit the eretz wherein thou art a ger, which Elohim gave unto Avraham. ");
INSERT INTO engojb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","And Yitzchak sent away Ya'akov; and he went to Paddanah-Aram unto Lavan ben Betuel HaArami, achi Rivkah, em Ya'akov and Esav. ");
INSERT INTO engojb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","When Esav saw that Yitzchak had blessed Ya'akov, and sent him away to Paddanah-Aram, to take an isha for him from there; and that when he blessed him he gave him a charge, saying, Thou shalt not take an isha of the Banot Kena'an; ");
INSERT INTO engojb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","And that Ya'akov obeyed his av and his em, and went to Paddanah-Aram; ");
INSERT INTO engojb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","And Esav seeing that the Banot Kena'an pleased not Yitzchak his av; ");
INSERT INTO engojb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Then went Esav unto Yishmael, and took unto the nashim which he had Machalat bat Yishmael ben Avraham, the achot of Nevayot, to be his wife. ");
INSERT INTO engojb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","And Ya'akov went out from Be'er-Sheva, and went toward Charan. ");
INSERT INTO engojb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","And he reached a certain place, and tarried there, because the shemesh was set; and he took of the avanim of that place, and put them for his pillow, and lay down in that place to sleep. ");
INSERT INTO engojb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","And he had a chalom, and hinei a sullam (ladder, stairway) set up on the ground, and the top of it reached to Shomayim: and hinei the malachim of Elohim ascending and descending on it. ");
INSERT INTO engojb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","And, hinei, Hashem stood above it, and said, I am Hashem Elohei Avraham thy av, and Elohei Yitzchak; ha'aretz whereon thou liest, to thee will I give it, and to thy zera; ");
INSERT INTO engojb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","And thy zera shall be as the dust of ha'aretz, and thou shalt spread abroad to the west, and to the east, and to the north, and to the south; and in thee and in thy zera shall kol hamishpochot haadamah be blessed. ");
INSERT INTO engojb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","And, hinei, I am with thee, and will be shomer over thee in all places where thou goest, and will bring thee back into haadamah hazot; for I will not leave thee, until I have done that which I have promised thee. ");
INSERT INTO engojb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","And Ya'akov awoke out of his sleep, and he said, Surely Hashem is in this place! And I had no da'as of it. ");
INSERT INTO engojb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","And he was afraid, and said, How nora (awesome) is this place! This is none other than the Beis Elohim, and this is the Sha'ar HaShomayim. ");
INSERT INTO engojb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","And Ya'akov rose up early in the boker, and took haeven (the stone) that he had put for his pillow, and set it up for a matzevah (pillar), and poured shemen upon the top of it. ");
INSERT INTO engojb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","And he called the shem of that place Beit-El; but the shem of that ir was called Luz at the first. ");
INSERT INTO engojb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","And Ya'akov vowed a neder (vow), saying, If Elohim will be with me, and will be shomer over me in this derech (way, journey) that I go, and will give me lechem to eat, and beged (clothes) to put on, ");
INSERT INTO engojb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","So that I return to bais avi in shalom; then shall Hashem be for me Elohim (my G-d). ");
INSERT INTO engojb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","And this even (stone), which I have set for a matzevah (pillar), shall be Beis Elohim: and of all that Thou shalt give me I will surely give the aser (tenth) unto Thee. ");
INSERT INTO engojb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Ya'akov went on his journey, and came into the eretz of the bnei kedem. ");
INSERT INTO engojb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","And he looked, and hinei a be'er in the sadeh, and, hinei, there were shloshah edrei tzon lying by it; for out of that be'er they watered the edarim: and a great even (stone) was upon the mouth of the be'er. ");
INSERT INTO engojb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","And to there were all the edarim gathered: and they rolled the even (stone) from the mouth of the be'er, and watered the tzon, and put the even (stone) again upon the mouth of the be'er in its place. ");
INSERT INTO engojb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","And Ya'akov said unto them, My brethren, where are you from? And they said, Of Charan are we. ");
INSERT INTO engojb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","And he said unto them, Know ye Lavan ben Nachor? And they said, We know him. ");
INSERT INTO engojb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","And he said unto them, Is the shalom with him? And they said, Shalom; and, hinei, Rachel his bat cometh with the tzon. ");
INSERT INTO engojb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","And he said, Look, the sun is still high, neither is it time that the flock should be gathered together; water ye the tzon, and go and feed them. ");
INSERT INTO engojb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","And they said, We cannot, until all the edarim be gathered together, and till they roll the even (stone) from the mouth of the be'er; then we water the tzon. ");
INSERT INTO engojb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","And while he yet spoke with them, Rachel came with the tzon of her av; for she was a ro'ah (shepherdess). ");
INSERT INTO engojb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","And it came to pass, when Ya'akov saw Rachel bat Lavan achi immo, and the tzon of Lavan achi immo, that Ya'akov went near, and rolled the even (stone) from the mouth of the be'er, and watered the tzon of Lavan achi immo. ");
INSERT INTO engojb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","And Ya'akov kissed Rachel, and lifted up his voice, and wept. ");
INSERT INTO engojb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","And Ya'akov told Rachel that he was the relative of her av, and that he was ben Rivkah; and she ran and told her av. ");
INSERT INTO engojb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","And it came to pass, when Lavan heard the news of Ya'akov ben achoto, that he ran to meet him, and embraced him, and kissed him, and brought him to his bais. And he told Lavan all these things. ");
INSERT INTO engojb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","And Lavan said to him, Surely thou art my etzem (bone) and my basar. And he abode with him the space of a chodesh (month). ");
INSERT INTO engojb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","And Lavan said unto Ya'akov, Because thou art my relative, shouldest thou therefore serve me for nothing? Tell me, what shall thy maskoret (wages) be? ");
INSERT INTO engojb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","And Lavan had two banot: the shem of the elder was Leah, and the shem of the younger was Rachel. ");
INSERT INTO engojb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah had weak eyes; but Rachel was yafeh and lovely in form. ");
INSERT INTO engojb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","And Ya'akov loved Rachel; and said, I will serve thee sheva shanim for Rachel thy bat haketannah (younger daughter). ");
INSERT INTO engojb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","And Lavan said, It is better that I give her to thee, than that I should give her to another ish; abide with me. ");
INSERT INTO engojb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","And Ya'akov served sheva shanim for Rachel; and they seemed unto him but a few yamim, because of the ahavah he had for her. ");
INSERT INTO engojb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","And Ya'akov said unto Lavan, Give me my isha, for my yamim are completed, that I may go in unto her. ");
INSERT INTO engojb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","And Lavan gathered together all the anshei hamakom, and made a mishteh (feast). ");
INSERT INTO engojb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","And it came to pass in the erev, that he took Leah his bat, and brought her to him; and he went in unto her. ");
INSERT INTO engojb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","And Lavan gave unto his daughter Leah Zilpah shifchato (his maid) for a shifchah. ");
INSERT INTO engojb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","And it came to pass, that in the boker, hinei, it was Leah! And he said to Lavan, What is this thou hast done unto me? Did not I serve with thee for Rachel? So why then hast thou deceived me? ");
INSERT INTO engojb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","And Lavan said, It must not be so done in our land, to give the younger before the bechirah. ");
INSERT INTO engojb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Finish her shvu'a (week), and we will give thee this also for the avodah (service, work) which thou shalt do for me yet sheva shanim acherot. ");
INSERT INTO engojb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","And Ya'akov did so, and fulfilled her shvu'a; and he gave him Rachel his bat to be his isha also. ");
INSERT INTO engojb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","And Lavan gave to his bat Rachel Bilhah his shifchah to be her shifchah. ");
INSERT INTO engojb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","And he went in also unto Rachel, and he loved also Rachel more than Leah, and served him yet sheva shanim acherot. ");
INSERT INTO engojb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","And when Hashem saw that Leah was hated, He opened her womb but Rachel was barren. ");
INSERT INTO engojb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","And Leah conceived, and bore a ben, and she called shmo Reuven: for she said, Surely Hashem hath looked upon my misery; now therefore my ish will love me. ");
INSERT INTO engojb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","And she conceived again, and bore ben; and said, Because Hashem hath heard I was hated, He hath therefore given me this also; and she called shmo Shim'on. ");
INSERT INTO engojb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","And she conceived again, and bore ben; and said, Now this time will my ish yillaveh (become attached) unto me, because I have born him shloshah banim: therefore was shmo called Levi. ");
INSERT INTO engojb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","And she conceived again, and bore ben; and she said, Now will odeh (I praise)Hashem; therefore she called shmo Yehudah; and stopped giving birth. ");
INSERT INTO engojb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","And when Rachel saw that she did not bear banim to Ya'akov, Rachel had kina toward her achot; and said unto Ya'akov, Give me banim, or else I die. ");
INSERT INTO engojb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","And af Ya'akov was kindled against Rachel; and he said, Am I in place of Elohim, Who hath withheld from thee p'ri beten? ");
INSERT INTO engojb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","And she said, Hinei my amah (maidservant) Bilhah, go in unto her; and she shall bear upon my birkayim, that I may also build up through her. ");
INSERT INTO engojb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","And she gave him Bilhah her shifchah (slave woman, maidservant) as isha; and Ya'akov went in unto her. ");
INSERT INTO engojb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","And Bilhah conceived, and bore Ya'akov ben. ");
INSERT INTO engojb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","And Rachel said, Elohim danani (G-d hath judged me), and hath also heard my voice, and hath given to me ben: therefore called she shmo Dan. ");
INSERT INTO engojb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","And Bilhah shifchat Rachel conceived again, and bore Ya'akov ben sheni. ");
INSERT INTO engojb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","And Rachel said, With naftulei Elohim niftalti (with wrestlings of G-d have I wrestled) with my achot, and I have prevailed: and she called shmo Naphtali. ");
INSERT INTO engojb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah saw that she had stopped bearing, she took Zilpah her shifchah, and gave her to Ya'akov as isha. ");
INSERT INTO engojb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","And Zilpah shifchat Leah bore Ya'akov ben. ");
INSERT INTO engojb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","And Leah said, BaGad (What Good Fortune!) And she called shmo Gad. ");
INSERT INTO engojb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","And Zilpah shifchat Leah bore Ya'akov ben sheni. ");
INSERT INTO engojb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","And Leah said, B'Ashri (Happy am I), for the banot will call me asher (blessed): so she called shmo Asher. ");
INSERT INTO engojb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","And Reuven went in the yemei ketzir chittim, and found duda'im (mandrakes) in the sadeh, and brought them unto Leah immo. Then Rachel said to Leah, Give me, now, of the duda'im of thy ben. ");
INSERT INTO engojb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","And she said unto her, Is it a small matter that thou hast taken my ish? And wouldest thou take away the duda'im of beni also? And Rachel said, Therefore he shall lie with thee halailah (tonight) for the duda'im of thy ben. ");
INSERT INTO engojb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","And Ya'akov came in from the sadeh ba'erev, and Leah went out to meet him, and said, Thou must come in unto me; for surely I have hired thee with duda'im of beni. And he lay with her that night. ");
INSERT INTO engojb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","And Elohim paid heed unto Leah, and she conceived, and bore Ya'akov ben chamishi. ");
INSERT INTO engojb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","And Leah said, Elohim hath given me my hire, because I have given my shifchah to my ish; and she called shmo Yissakhar. ");
INSERT INTO engojb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","And Leah conceived again, and bore Ya'akov ben shishi. ");
INSERT INTO engojb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","And Leah said, Elohim hath endued me with a zeved tov (good endowment); now will my ish zabal (honor) me, because I have born him shisha banim; and she called shmo Zevulun. ");
INSERT INTO engojb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","And afterwards she bore a bat, and called her shem Dinah. ");
INSERT INTO engojb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","And Elohim remembered Rachel, and Elohim paid heed to her, and opened her rekhem (womb). ");
INSERT INTO engojb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","And she conceived, and bore ben; and said, Elohim hath taken away my cherpah (shame, disgrace, reproach); ");
INSERT INTO engojb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","And she called shmo Yosef; and said, yosef (may He add), may Hashem add me ben acher (another son). ");
INSERT INTO engojb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","And it came to pass, when Rachel had born Yosef, that Ya'akov said unto Lavan, Send me away, that I may go unto mine own makom (place, home) and to my eretz. ");
INSERT INTO engojb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my nashim and my yeladim, for whom I have served thee, and let me go: for thou knowest my avodah which I have done thee. ");
INSERT INTO engojb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","And Lavan said unto him, Now, if I have found chen (favor, grace) in thine eyes, tarry; for I have learned by nachash (divination) that Hashem hath made a brocha upon me for thy sake. ");
INSERT INTO engojb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","And he said, Specify thy sachar (wages, reward), and I will pay it. ");
INSERT INTO engojb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","And he said unto him, Thou knowest how I have served thee, and how thy mikneh fared with me. ");
INSERT INTO engojb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","For it was me'at (little) which thou hadst before I came, and it is now increased unto a multitude; and Hashem hath made a brocha upon thee since my coming; and now when shall I do for mine own bais also? ");
INSERT INTO engojb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","And he said, What shall I give thee? And Ya'akov said, Thou shalt not give me any thing; if thou wilt do this thing for me, I will again tend and be shomer over thy tzon. ");
INSERT INTO engojb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","I will pass through all thy tzon today, removing from there speckled and spotted seh, and every dark seh among the kesavim, and the spotted and speckled among the izzim; and of such shall be my sachar. ");
INSERT INTO engojb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","So shall my tzedakah answer for me in time to come, when it shall come for my sachar before thy face; every one that is not speckled and spotted among the izzim, and dark among the kesavim, that shall be counted a ganavʼs with me. ");
INSERT INTO engojb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","And Lavan said, Agreed, I would it might be according to thy davar. ");
INSERT INTO engojb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","And he removed that day the male goats that were streaked and spotted, and all the izzim that were speckled and spotted, and every one that had some lavan in it, and all the dark among the kesavim, and gave them into the yad of his banim. ");
INSERT INTO engojb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","And he set a derech shloshet yamim between himself and Ya'akov; and Ya'akov tended the rest of the tzon Lavan. ");
INSERT INTO engojb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","And Ya'akov took him fresh cut makal (rod, branch) of poplar and of almond and plane tree; and peeled strips of bark in them, and made the lavan (white) appear which was in the maklot (rods, branches). ");
INSERT INTO engojb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","And he set the maklot which he had peeled before the flocks in the small channels of the shikatot mayim (watering troughs) when the tzon came to drink. And since they bred when they came to drink, ");
INSERT INTO engojb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","And the flocks bred before the maklot, and brought forth tzon streaked, speckled, and spotted. ");
INSERT INTO engojb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","And Ya'akov did separate the kesavim, and set the faces of the tzon toward the streaked, and all the dark in the tzon Lavan; and he put his own adarim (flocks) by themselves, and put them not unto the tzon Lavan. ");
INSERT INTO engojb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","And it came to pass, whensoever tzon hamekusharot (the stronger flock) did breed, that Ya'akov set the maklot before the eyes of the tzon in the trough channels, that they might breed among the maklot. ");
INSERT INTO engojb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when the tzon were feeble, he put them not in: so the feebler would belong to Lavan, and the stronger to Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","And the ish increased exceedingly, and had much tzon, and shefachot, and avadim, and gemalim, and chamorim. ");
INSERT INTO engojb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","And he heard the divrei Bnei Lavan, saying, Ya'akov hath taken away all that belonged to avinu; and of that which belonged to avinu hath he gotten all this kavod. ");
INSERT INTO engojb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","And Ya'akov beheld the countenance of Lavan, and, hinei, it was not toward him as before. ");
INSERT INTO engojb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","And Hashem said unto Ya'akov, Shuv el Eretz Avoteicha! And to thy moledet; and I will be with thee. ");
INSERT INTO engojb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","And Ya'akov sent and called Rachel and Leah to the sadeh unto his tzon, ");
INSERT INTO engojb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","And said unto them, I see penei avichen, that it is not toward me as before; but Elohei Avi is with me. ");
INSERT INTO engojb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","And ye know that with all my koach I have served avichen. ");
INSERT INTO engojb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","And avichen hath deceived me, and changed my sachar aseret monim but Elohim allowed him not to harm me. ");
INSERT INTO engojb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said thus, The speckled shall be thy sachar; then all the tzon bore speckled; and if he said thus, The streaked shall be thy sachar; then bore all the tzon streaked. ");
INSERT INTO engojb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Thus Elohim hath taken away the mikneh of your av, and given them to me. ");
INSERT INTO engojb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","And it came to pass at the time that the tzon breed, that I lifted up mine eyes, and saw in a chalom, and, hinei, the male goats mounting the tzon were streaked, speckled, and spotted. ");
INSERT INTO engojb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","And the Malach HaElohim spoke unto me in a chalom saying, Ya'akov: And I said, Hineni. ");
INSERT INTO engojb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","And he said, Lift up now thine eyes, and see, all the male goats leaping upon the tzon are streaked, speckled, and spotted; for I have seen all that Lavan doeth unto thee. ");
INSERT INTO engojb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am HaEl Beit-El, where thou anointedst a matzevah (pillar), and where thou vowedst a neder (vow) unto Me: now arise, get thee out from HaAretz Hazot, and return unto thy eretz moledet. ");
INSERT INTO engojb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","And Rachel and Leah answered and said unto him, Is there yet any chelek or nachalah for us in bais avinu? ");
INSERT INTO engojb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Are we not regarded by him nokhriyyot (foreigners, strangers)? For he hath sold us, and hath quite devoured also our kesef. ");
INSERT INTO engojb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","For all the oisher Elohim hath taken from avinu, that belongs to us and baneinu; so then, whatsoever Elohim hath said unto thee, do. ");
INSERT INTO engojb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Ya'akov rose up, and set his banim and his nashim upon the gemalim; ");
INSERT INTO engojb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","And he drove all his mikneh, and all his goods which he had gotten, the mikneh of his getting, which he had gotten in Paddan-Aram, for to go to Yitzchak aviv in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","And Lavan went to shear his tzon; and Rachel had stolen the terafim that belong to her av. ");
INSERT INTO engojb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Unawares to Lavan HaArami, Ya'akov stole away, in that he told him not that he was fleeing. ");
INSERT INTO engojb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So he fled with all that he had; and he rose up, and passed over the Nahar i.e. the Euphrates, and set his face toward Har Gil'ad. ");
INSERT INTO engojb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","And it was told Lavan on Yom HaShlishi that Ya'akov was fled. ");
INSERT INTO engojb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","And he took his achim with him, and pursued after him derech shivat yamim; and they overtook him at Har Gil'ad. ");
INSERT INTO engojb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","And Elohim came to Lavan HaArami in a chalom halailah, and said unto him, Take heed that thou speak not to Ya'akov either tov or rah. ");
INSERT INTO engojb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Then Lavan overtook Ya'akov. Now Ya'akov had pitched his ohel on the har; and Lavan with his achim encamped in Har Gil'ad. ");
INSERT INTO engojb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","And Lavan said to Ya'akov, What hast thou done, that thou hast stolen away unawares to me, and carried away my banot, like shevuyot (captives) taken with the cherev? ");
INSERT INTO engojb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why didst thou flee away secretly, and steal away from me; and didst not tell me, that I might have sent thee away with simchah, and with shirim (songs), with tof (timbrel, tambourine) and with kinnor (harp)? ");
INSERT INTO engojb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","And hast not allowed me to kiss my banim (grandchildren) and my banot? Thou hast now done foolishly in so doing. ");
INSERT INTO engojb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","It is in the power of my yad to do you rah; but Elohei Avichem spoke unto me emesh (last night), saying, Take thou heed that thou speak not to Ya'akov either tov or rah. ");
INSERT INTO engojb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","And now, though thou had to go, because thou greatly longedst after bais avicha, yet why hast thou stolen elohai? ");
INSERT INTO engojb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","And Ya'akov answered and said to Lavan, Because I was afraid; for I said, Thou wouldest take by force thy banot from me. ");
INSERT INTO engojb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","With whomsoever thou findest eloheicha, let him not live; before acheinu discern thou what is thine with me, and take it to thee. For Ya'akov knew not that Rachel had played the ganav with them. ");
INSERT INTO engojb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","And Lavan went into the ohel Ya'akov, and into the ohel Leah and into the ohel shtei ha'amahot; but he found them not. Then went he out of the ohel Leah, and entered into the ohel Rachel. ");
INSERT INTO engojb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel had taken the terafim, and put them in the saddle of the gamal, and sat upon them. And Lavan searched all the ohel, but found them not. ");
INSERT INTO engojb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","And she said to her av, Let it not displease adoni that I cannot rise up in thy presence; for the derech nashim is upon me. And he searched but found not the terafim. ");
INSERT INTO engojb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","And Ya'akov was in wrath, and upbraided Lavan: and Ya'akov answered and said to Lavan, What is my peysha? What is my chattat, that thou hast so hotly pursued after me? ");
INSERT INTO engojb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Whereas thou hast searched through all that I own, what hast thou found of all thy kelei bais? Set it here before my achim and thy achim, that they may judge between us both. ");
INSERT INTO engojb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","These esrim shanah have I been with thee; recheleicha (thy ewes) and thy female goats have not miscarried, and the rams of thy tzon have I not eaten. ");
INSERT INTO engojb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","That which was treifah (torn of beasts) I brought not unto thee; I bore the loss of it; of my yad didst thou require it, whether stolen by yom, or stolen by lailah. ");
INSERT INTO engojb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Thus I was; in the yom the chorev (heat) consumed me, and the kerach (cold) by lailah; and my sheynah (sleep) departed from mine eyes. ");
INSERT INTO engojb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Thus have I been esrim shanah in thy bais; I served thee arba-esreh shanah for thy two banot, and shesh shanim for thy tzon: and thou hast changed my sachar aseret monim. ");
INSERT INTO engojb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Except Elohei Avi, Elohei Avraham, and the Pachad of Yitzchak had been with me, surely thou hadst sent me away now empty handed. Elohim hath seen mine oni and the toil of my palms, and rebuked thee emesh (last night). ");
INSERT INTO engojb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","And Lavan answered and said unto Ya'akov, These banot are my banot, and these banim are my banim, and this tzon is my tzon, and all that thou seest is mine; yet what can I do today about these my banot, or about their banim which they have born? ");
INSERT INTO engojb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Now therefore come thou, let us cut a brit, I and thou; and let it be for an ed between me and thee. ");
INSERT INTO engojb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","And Ya'akov took an even, and set it up for a matzevah (pillar). ");
INSERT INTO engojb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","And Ya'akov said unto his achim, Gather avanim; and they took avanim, and made a gal (heap, mound); and they did eat there upon the gal. ");
INSERT INTO engojb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","And Lavan called it Yegar Sahaduta; but Ya'akov called it Gale'ed (“Heap of Witness”). ");
INSERT INTO engojb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","And Lavan said, This gal (heap, mound) is an ed (witness) between me and thee this day. Therefore was shmo called Gale'ed; ");
INSERT INTO engojb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","And Mitzpah (Watch); for he said, Hashem watch between me and thee, when we are absent one from another. ");
INSERT INTO engojb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If thou shalt afflict my banot, or if thou shalt take nashim besides my banot, no man is with us; see, Elohim ed beini uveinecha (Elohim is witness between me and you). ");
INSERT INTO engojb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","And Lavan said to Ya'akov, Hinei this gal (heap, mound), and hinei the matzevah (pillar), which I have cast between me and thee; ");
INSERT INTO engojb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","This gal (heap, mound) be ed (witness), and this matzevah (pillar) be edah (witness), that for ra'ah I will not pass over this gal to thee, and that thou shalt not pass over this gal and this matzevah unto me. ");
INSERT INTO engojb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","The Elohei Avraham, and Elohei Nachor, Elohei Avihem judge between us. And Ya'akov swore by the Pachad Aviv Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then Ya'akov offered zavach upon the har, and called his achim to eat lechem; and they did eat lechem, and tarried all night on the har. ");
INSERT INTO engojb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","And early in the boker (morning) Lavan rose up, and kissed his banim and his banot, and made on them a brocha; and Lavan departed, and returned unto his makom. ");
INSERT INTO engojb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","And Ya'akov went on his derech, and the malachim of Elohim met him. ");
INSERT INTO engojb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","And when Ya'akov saw them, he said, This is Mahaneh Elohim; and he called the shem of that makom (place) Machanayim. ");
INSERT INTO engojb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","And Ya'akov sent malachim before him to Esav achiv unto Eretz Se'ir, the country of Edom. ");
INSERT INTO engojb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","And he commanded them, saying, Thus shall ye speak unto adoni Esav; Thy eved Ya'akov saith thus, I have sojourned with Lavan, and stayed there until now; ");
INSERT INTO engojb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","And I have shor (oxen), and chamor, tzon, and eved, and shifchah; and I have sent to tell adoni, that I may find chen (grace) in thy sight. ");
INSERT INTO engojb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","And the malachim returned to Ya'akov, saying, We came to Esav achicha, and also he cometh to meet thee, and arba me'ot ish with him. ");
INSERT INTO engojb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Then Ya'akov was greatly afraid and distressed; and he divided HaAm that was with him, and the tzon, and bakar, and the gemalim, into two machanot; ");
INSERT INTO engojb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","And said, If Esav come to the one machaneh, and attack it, then the other machaneh which is left shall escape. ");
INSERT INTO engojb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","And Ya'akov said, O Elohei Avi Avraham, and Elohei Avi Yitzchak, Hashem which saidst unto me, Shuv l'aretzecha and to thy moledet (kindred), and I will deal well with thee; ");
INSERT INTO engojb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","I am not worthy of the least of all the chasadim, and of all the emes, which Thou hast showed unto Thy eved; for with my makal (rod, staff) I passed over this Yarden; and now I am become two machanot. ");
INSERT INTO engojb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Save me, now, from the yad achi, from the yad Esav; for I fear him, lest he will come and attack me, em with banim. ");
INSERT INTO engojb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","But Thou saidst, I will surely do thee good, and make thy zera as the chol of the yam, which cannot be numbered for multitude. ");
INSERT INTO engojb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","And he spent there that same night; and took of that which came to his yad a minchah for Esav achiv; ");
INSERT INTO engojb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Two hundred female goats, and twenty male goats, two hundred rechelim (ewes), and twenty eilim (rams), ");
INSERT INTO engojb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Thirty nursing gemalim with their colts, forty parot (cows), and ten parim (bulls), twenty female donkeys, and ten male donkeys. ");
INSERT INTO engojb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","And he delivered them into the yad of his avadim, every herd by itself; and said unto his avadim, Pass over before me, and keep a space between herd and herd. ");
INSERT INTO engojb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","And he commanded the rishon, saying, When Esav achi meeteth thee, and asketh thee, saying, Whose art thou? And to where goest thou? And whose are these animals before thee? ");
INSERT INTO engojb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Then thou shalt say, They are of thy eved Ya'akov; it is a minchah sent unto adoni Esav; and, hinei, also he is behind us. ");
INSERT INTO engojb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","And so commanded he the second, and the third, and all that followed the adarim (herds), saying, On this manner shall ye speak unto Esav, when ye find him. ");
INSERT INTO engojb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","And say ye moreover, Hinei, thy eved Ya'akov is behind us. For he said, Akhapperah (I will appease, cover) his face with the minchah that goeth ahead of me, and afterward I will see his face; perhaps he will accept me. ");
INSERT INTO engojb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","So went the minchah (present) over ahead of him; but he himself stayed balailah in the machaneh. ");
INSERT INTO engojb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","And he rose up that night, and took his two nashim and his two shifchot, and his eleven yeladim, and passed over the ma'avar (ford) Yabbok. ");
INSERT INTO engojb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","And he took them, and sent them over the stream, and sent over all that he had. ");
INSERT INTO engojb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","And Ya'akov was left by himself; and there wrestled an ish with him until the shachar (dawn, sunup). ");
INSERT INTO engojb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","And when he saw that he prevailed not against him, he struck his hip socket; so Ya'akovʼs hip socket dislocated while he wrestled with him. ");
INSERT INTO engojb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","And he said, Let me go, for shachar breaketh. And he said, I will not let thee go, unless thou make a berakhah upon me. ");
INSERT INTO engojb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","And he said unto him, What is shemecha? And he said, Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","And he said, Shimcha shall be called no more Ya'akov, but Yisroel: for sarita im Elohim (yisrah=to prevail + El=G-d = Yisroel ye have striven with Elohim) and with anashim, and hast overcome. ");
INSERT INTO engojb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","And Ya'akov asked him, and said, Tell me, now, shemecha. And he said, Why is it that thou dost ask after shmi? And he made a brocha upon him there. ");
INSERT INTO engojb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","And Ya'akov called the shem of the makom (place) Peniel (Face of G-d): for I have seen Elohim panim el panim, and my nefesh is saved. ");
INSERT INTO engojb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","And as he passed over Penuel the shemesh rose upon him, and he limped upon his hip. ");
INSERT INTO engojb_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Therefore the Bnei Yisroel eat not of the sinew of the thigh vein (gid hanasheh, sciatic nerve) which is upon the hip socket, unto this day; because he touched the hip socket of Ya'akov in the sinew of the thigh vein. ");
INSERT INTO engojb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","And Ya'akov lifted up his eyes, and looked, and, hinei, Esav came, and with him arba me'ot ish (four hundred men). And he divided the yeladim unto Leah, and unto Rachel, and unto the two shefachot. ");
INSERT INTO engojb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","And he put the shefachot and their yeladim rishonah, and Leah and her yeladim acharonim, and Rachel and Yosef acharonim. ");
INSERT INTO engojb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","And he passed over before them, and bowed himself to the ground sheva pe'amim, until he came near to achiv (his brother). ");
INSERT INTO engojb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","And Esav ran to meet him, and embraced him, and fell on his tzavar (neck), and kissed him; and they wept. ");
INSERT INTO engojb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","And he lifted up his eyes, and saw the nashim and the yeladim; and said, Who are those with thee? And he said, The yeladim which Elohim hath graciously given thy eved. ");
INSERT INTO engojb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the shefachot came near, they and their yeladim, and they bowed themselves. ");
INSERT INTO engojb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","And Leah also with her yeladim came near, and bowed themselves; and after came Yosef near and Rachel, and they bowed themselves. ");
INSERT INTO engojb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","And he said, What meanest thou by all this machaneh which I met? And he said, These are to find chen (grace) in the eyes of adoni. ");
INSERT INTO engojb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","And Esav said, I have enough, achi (my brother); keep that thou hast unto thyself. ");
INSERT INTO engojb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","And Ya'akov said, No, now, if I have found chen (grace) in thy sight, then receive my minchah at my yad inasmuch as I have seen thy face, as though I had seen the p'nei Elohim (the face of G-d) vatirtzeini (and thou wast pleased to accept me, thou wast appeased by me). ");
INSERT INTO engojb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Accept, now, my brocha that is brought to thee; because Elohim hath dealt graciously with me, and because yesh li khol (there is to me all, my needs are met). And he urged him, and he accepted. ");
INSERT INTO engojb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","And he said, Nise'ah (let us take our journey), and let us go, I will go next to thee. ");
INSERT INTO engojb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","And he said unto him, Adoni knoweth that the yeladim are tender and the nursing tzon and bakar are upon me; and if men should overdrive them yom echad, all the tzon will die. ");
INSERT INTO engojb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Let now adoni, pass over before his eved; and I will lead on slowly, according to the pace of the drove that goeth before me and the pace the yeladim are able to endure, until I come unto adoni at Se'ir. ");
INSERT INTO engojb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","And Esav said, Let me now leave with thee some of HaAm that are with me. And he said, What needeth it? Let me find chen in the sight of adoni. ");
INSERT INTO engojb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So Esav returned that day on his derech unto Se'ir. ");
INSERT INTO engojb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","And Ya'akov journeyed to Sukkot, and built him a bais, and made sukkot for his mikneh; therefore the shem of the makom is called Sukkot. ");
INSERT INTO engojb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","And Ya'akov came shalem to Ir Shechem, which is in eretz Kena'an, when he came from Paddan-Aram; and encamped before the Ir. ");
INSERT INTO engojb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","And he bought a chelkat hasadeh (piece of land), where he had pitched there his ohel, from the yad Bnei Chamor Avi Shechem, for a hundred pieces of kesitah (money). ");
INSERT INTO engojb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","And he erected there a Mizbe'ach, and called it El Elohei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","And Dinah Bat Leah, which she bore unto Ya'akov, went out to see the Banot HaAretz. ");
INSERT INTO engojb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","And when Shechem Ben Chamor the Chivi (Hivite), Nasi HaAretz, saw her, he took her, and lay with her, and violated her. ");
INSERT INTO engojb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","And his nefesh had deveykus unto Dinah Bat Ya'akov, and he loved the na'arah, and spoke to the lev hanaarah. ");
INSERT INTO engojb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","And Shechem spoke unto Chamor aviv, saying, Get me this yaldah as isha. ");
INSERT INTO engojb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","And Ya'akov heard that he had made his bat Dinah tameh; now his banim were with his mikneh in the sadeh; and Ya'akov held his peace until they were come. ");
INSERT INTO engojb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","And Chamor avi Shechem went out unto Ya'akov to speak with him. ");
INSERT INTO engojb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","And the Bnei Ya'akov came from the sadeh when they heard it; and the anashim were grieved, and they were in wrath greatly, because he had wrought nevalah (folly, disgrace, outrage) against Yisroel in lying with Bat Ya'akov; which thing ought not to be done. ");
INSERT INTO engojb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","And Chamor spoke with them, saying, The nefesh of beni (my son) Shechem longeth for your bat; now give her him as isha. ");
INSERT INTO engojb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","So intermarry with us, and give your banot unto us, and take benoteinu (our banot) unto you. ");
INSERT INTO engojb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","And ye shall dwell with us; and HaAretz shall be before you; dwell and trade therein, and get you possessions therein. ");
INSERT INTO engojb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","And Shechem said unto her av and unto her achim, Let me find chen (grace) in your eyes, and what ye shall say unto me I will give. ");
INSERT INTO engojb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ask me never so much mohar (bride price, dowry) and mattan (gift), and I will pay according as ye shall say unto me; but give me the na'arah as isha. ");
INSERT INTO engojb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","And the Bnei Ya'akov answered Shechem and Chamor aviv in mirmar (deceit) and spoke because he had made Dinah their achot tameh; ");
INSERT INTO engojb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","And they said unto them, We cannot do this thing, to give achoteinu (our sister) to ish that is arelah (uncircumcised); for that would be a cherpah (reproach, disgrace) unto us; ");
INSERT INTO engojb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","But in this will we consent unto you: If ye will become like us, that every zachar of you be circumcised; ");
INSERT INTO engojb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then will we give benoteinu unto you, and we will take your banot to us, and we will dwell among you, and we will become as Am Echad. ");
INSERT INTO engojb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if ye will not pay heed unto us, to become circumcised; then will we take biteinu (our daughter), and we will go. ");
INSERT INTO engojb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","And their words pleased Chamor, and Shechem Ben Chamor. ");
INSERT INTO engojb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","And the na'ar deferred not to do the thing, because he had delight in Bat Ya'akov; and he was more respected than kol Bais Aviv. ");
INSERT INTO engojb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","And Chamor and Shechem bno came unto the Sha'ar of their city, and they spoke with the anashim of their city, saying, ");
INSERT INTO engojb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","These anashim are shlemim (peaceable) with us; therefore let them settle in HaAretz, and let them trade therein for HaAretz, hinei, it is plenty of room for them; let us take their banot to us as nashim, and let us give them benoteinu. ");
INSERT INTO engojb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Only herein will the anashim consent unto us for to dwell with us, to be Am Echad, if every zachar among us be circumcised, just as they are nimolim (ones being circumcised). ");
INSERT INTO engojb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Shall not their mikneh and their property and every behemah of theirs be ours? Only let us consent unto them, and they will settle among us. ");
INSERT INTO engojb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","And unto Chamor and unto Shechem bno paid heed all that went out of the Sha'ar of his city; and every zachar was circumcised, all that went out of the Sha'ar of his city. ");
INSERT INTO engojb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","And it came to pass on the Yom HaShlishi, when they were in pain, that two of the Bnei Ya'akov, Shim'on and Levi, achei Dinah, took each ish his cherev, and came upon the Ir betach (boldly, confidently), and they slaughtered kol zachar. ");
INSERT INTO engojb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","And they slaughtered Chamor and Shechem bno with the edge of the cherev, and took Dinah from the Bais Shechem and left. ");
INSERT INTO engojb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","The Bnei Ya'akov came upon the chalalim (dead ones, slain ones), and plundered the Ir, because they had made their achot tameh. ");
INSERT INTO engojb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They seized their tzon, and their bakar, and their chamorim, and that which was in the Ir, and that which was in the sadeh, ");
INSERT INTO engojb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","And all their wealth, and all their little ones, and their nashim they carried off and plundered even all that was in the bais. ");
INSERT INTO engojb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","And Ya'akov said to Shim'on and Levi, Ye have brought trouble on me to make me a stench among the inhabitants of HaAretz, among the Kena'ani and the Perizzi; and I being few in mispar, they shall gather themselves together against me, and attack me; and I shall be destroyed, I and my bais. ");
INSERT INTO engojb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","And they said, Should he deal with achoteinu like with zonah? ");
INSERT INTO engojb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","And Elohim said unto Ya'akov, Arise, go up to Beit-El, and settle there; and make there a Mizbe'ach unto El (G-d) that appeared unto thee when thou didst flee from the face of Esav achicha. ");
INSERT INTO engojb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Then Ya'akov said unto his Bais, and to all that were with him, Put away the elohei hanekhar that are among you, and be tahor, and change your simlah (garments); ");
INSERT INTO engojb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","And let us arise, and go up to Beit-El; and I will build there a Mizbe'ach unto El (G-d) Who answered me in my yom tzoros, and was with me in the derech in which I went. ");
INSERT INTO engojb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","And they gave unto Ya'akov kol elohei hanekhar which were in their yad, and all their nezamim which were in their oznayim; and Ya'akov buried them under the elah (terebinth) which was at Shechem. ");
INSERT INTO engojb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","And they journeyed; and the chittat Elohim (terror of G-d) was upon the cities that were around them, and they did not pursue after the Bnei Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","So Ya'akov came to Luz, which is in Eretz Kena'an, that is, Beit-El, he and kol haAm that were with him. ");
INSERT INTO engojb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","And he built there a Mizbe'ach, and called the makom (place) El Beit-El; because there HaElohim appeared unto him, when he fled from the face of achiv. ");
INSERT INTO engojb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","But Devorah meineket Rivkah died, and she was buried under an alon (oak) below Beit-El; and shmo was called Alon Bachut. ");
INSERT INTO engojb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","And Elohim appeared unto Ya'akov again, when he returned from Paddan-Aram, and made a brocha upon him. ");
INSERT INTO engojb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","And Elohim said unto him, Shimcha is Ya'akov; shimcha shall not be called any more Ya'akov, but Yisroel shall be shemecha; and He called shmo Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And Elohim said unto him, I am El Shaddai; be fruitful and multiply; a Goy (nation) and a Kehal Goyim shall be from thee, and Melechim shall come out of thy loins; ");
INSERT INTO engojb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","And HaAretz which I gave Avraham and Yitzchak, to thee I will give it, and to thy zera after thee will I give HaAretz. ");
INSERT INTO engojb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","And Elohim went up from him in the makom where He talked with him. ");
INSERT INTO engojb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","And Ya'akov set up a matzevah (pillar, monument) in the makom where He talked with him, even a matzevat even (pillar of stone); and he poured a nesech (drink offering) thereon, and he poured shemen (oil) thereon. ");
INSERT INTO engojb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","And Ya'akov called the shem of the makom where Elohim spoke with him, Beit-El. ");
INSERT INTO engojb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","And they journeyed from Beit-El; and there was still a space of ha'aretz to get to Ephratah; and Rachel travailed, and she had hard labor. ");
INSERT INTO engojb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","And it came to pass, when she was in hard labor, that the meyaledet (midwife) said unto her, Fear not; thou shalt have this ben also. ");
INSERT INTO engojb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","And it came to pass, as her nefesh was in departing, (for she died) that she called shmo Ben-Oni (Son of Affliction); but aviv called him Binyamin. ");
INSERT INTO engojb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","And Rachel died, and was buried on the derech to Ephratah, which is Beit-Lechem. ");
INSERT INTO engojb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","And Ya'akov set up a matzevah upon her kever; that is matzevet kevurat Rachel to this day. ");
INSERT INTO engojb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","And Yisroel journeyed, and pitched his ohel beyond Migdal-Eder. ");
INSERT INTO engojb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","And it came to pass, when Yisroel dwelt in that land, that Reuven went and lay with Bilhah pilegesh aviv and Yisroel heard it. Now the Bnei Ya'akov were Sheneym Asar (Twelve); ");
INSERT INTO engojb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The Bnei Leah: Reuven bechor Ya'akov, and Shim'on, and Levi, and Yehudah, and Yissakhar, and Zevulun; ");
INSERT INTO engojb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The Bnei Rachel: Yosef, and Binyamin; ");
INSERT INTO engojb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","And the Bnei Bilhah shifchat Rachel: Dan, and Naphtali; ");
INSERT INTO engojb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","And the Bnei Zilpah shifchat Leah: Gad, and Asher; these are the Bnei Ya'akov, which were born to him in Paddan-Aram. ");
INSERT INTO engojb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","And Ya'akov came unto Yitzchak Aviv unto Mamre, unto Kiriat-HaArba, which is Chevron, where Avraham and Yitzchak sojourned. ");
INSERT INTO engojb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","And the days of Yitzchak were me'at shanah u'shemonim shanah. ");
INSERT INTO engojb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","And Yitzchak expired, and died, and was gathered unto his people, being zaken (old) and full of yamim; and his banim Esav and Ya'akov buried him. ");
INSERT INTO engojb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Now these are the toldot Esav, who is Edom. ");
INSERT INTO engojb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esav took his nashim of the Banot Kena'an: Adah Bat Elon the Chitti, and Oholivamah Bat Anah Bat Tziveon the Chivi; ");
INSERT INTO engojb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","And Basmat Bat Yishmael, achot Nevayot. ");
INSERT INTO engojb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","And Adah bore to Esav Eliphaz; and Basmat bore Reuel; ");
INSERT INTO engojb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","And Oholivamah bore Ye'ush, and Ya'alam, and Korach; these are the Bnei Esav, which were born unto him in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","And Esav took his nashim, and his banim, and his banot, and kol nafshot of his bais, and his mikneh, and all his behemah, and all his possessions, which he had acquired in Eretz Kena'an; and went into the eretz from the face of Ya'akov achiv. ");
INSERT INTO engojb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","For their wealth was more than that they might dwell together; and the eretz of their sojourns could not support them because of their mikneh. ");
INSERT INTO engojb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Thus dwelt Esav in har Se'ir; Esav is Edom. ");
INSERT INTO engojb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","And these are the toldot Esav avi Edom in har Se'ir: ");
INSERT INTO engojb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These are the shemot Bnei Esav; Eliphaz Ben Adah eshet Esav, Reuel Ben Basmat eshet Esav. ");
INSERT INTO engojb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","And the Bnei Eliphaz were Teman, Omar, Tzepho, and Gatam, and Kenaz. ");
INSERT INTO engojb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","And Timna was pilegesh (concubine) to Eliphaz Ben Esav; and she bore to Eliphaz Amalek; these were the Bnei Adah eshet Esav. ");
INSERT INTO engojb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","And these are the Bnei Reuel: Nachat, and Zerach, Shammah, and Mizzah; these were the Bnei Basmat eshet Esav. ");
INSERT INTO engojb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","And these were the Bnei Oholivamah Bat Anah Bat Tziveon, eshet Esav: and she bore to Esav Ye'ush, and Ya'alam, and Korach. ");
INSERT INTO engojb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These were alufei (chiefs) of the Bnei Esav: the Bnei Eliphaz the bechor Esav; aluf (chief) Teman, aluf Omar, aluf Tzepho, aluf Kenaz, ");
INSERT INTO engojb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Aluf (chief) Korach, aluf (chief) Gatam, and aluf (chief) Amalek; these are the alufei Eliphaz in Eretz Edom; these were the Bnei Adah. ");
INSERT INTO engojb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","And these are the Bnei Reuel Ben Esav: aluf (chief) Nachat, aluf Zerach, aluf Shammah, aluf Mizzah; these are the alufei Reuel in Eretz Edom; these are the Bnei Basmat eshet Esav. ");
INSERT INTO engojb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","And these are the Bnei Oholivamah eshet Esav: aluf (chief) Ye'ush, aluf Ya'alam, aluf Korach; these were the alufei Oholivamah Bat Anah eshet Esav. ");
INSERT INTO engojb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These are the Bnei Esav, who is Edom, and these are their alufim (chiefs). ");
INSERT INTO engojb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are the Bnei Se'ir the Chori, who inhabited HaAretz: Lotan, and Shoval, and Tziveon, and Anah, ");
INSERT INTO engojb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","And Dishon, and Etzer, and Dishan; these are the alufei HaChori, the Bnei Se'ir in Eretz Edom. ");
INSERT INTO engojb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","And the Bnei Lotan were Chori and Hemam; and achot Lotan was Timna. ");
INSERT INTO engojb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","And the Bnei Shoval were these: Alvan, and Manachat, and Eival, Shepho, and Onam. ");
INSERT INTO engojb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","And these are the Bnei Tziveon: both Ayah, and Anah; this was that Anah that found the hot springs in the midbar, as he pastured the chamorim of Tziveon aviv. ");
INSERT INTO engojb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","And the Bnei Anah were these: Dishon, and Oholivamah Bat Anah. ");
INSERT INTO engojb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","And these are the Bnei Dishon: Chemdan, and Eshban, and Yitran, and Keran. ");
INSERT INTO engojb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","The Bnei Etzer are these: Bilhan, and Za'avan, and Akan. ");
INSERT INTO engojb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","The Bnei Dishan are these: Utz, and Aran. ");
INSERT INTO engojb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the alufei (chiefs) haChori: aluf (chief) Lotan, aluf Shoval, aluf Tziveon, aluf Anah, ");
INSERT INTO engojb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Aluf Dishon, aluf Etzer, aluf (chief) Dishan; these are the alufei haChori by their alufim (chiefs) in Eretz Se'ir. ");
INSERT INTO engojb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","And these are the melechim that reigned in Eretz Edom, before there reigned any melech over the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","And Bela Ben Be'or reigned in Edom; and the shem of his city was Dinhavah. ");
INSERT INTO engojb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","And Bela died, and Yovav Ben Zerach of Botzrah reigned in his place. ");
INSERT INTO engojb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","And Yovav died, and Chusham of Eretz Temani reigned in his place. ");
INSERT INTO engojb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","And Chusham died, and Hadad Ben Bedad, who defeated Midyan in the sadeh of Moav, reigned in his place; and the shem of his city was Avit. ");
INSERT INTO engojb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","And Hadad died, and Samlah of Masrekah reigned in his place. ");
INSERT INTO engojb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","And Samlah died, and Sha'ul of Rechovot-nahar reigned in his place. ");
INSERT INTO engojb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","And Sha'ul died, and Ba'al-Chanan Ben Achbor reigned in his place. ");
INSERT INTO engojb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","And Ba'al-Chanan Ben Achbor died, and Hadar reigned in his place; and the shem of his city was Pau; and the shem of his isha was Mehetavel Bat Matred Bat Mei-Zahav. ");
INSERT INTO engojb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","And these are the shemot of the alufei Esav, according to their mishpechot, after their mekomot, by their shemot: aluf (chief) Timna, aluf (chief) Alvah, aluf (chief) Yetet, ");
INSERT INTO engojb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aluf Oholivamah, aluf (chief) Elah, aluf (chief) Pinon, ");
INSERT INTO engojb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Aluf (chief) Kenaz, aluf (chief) Teman, aluf (chief) Mivtzar, ");
INSERT INTO engojb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Aluf (chief) Magdiel, aluf (chief) Iram; these are the alufei Edom, according to their moshavot in the eretz of their achuzzah; this is Esav Avi Edom. ");
INSERT INTO engojb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","And Ya'akov dwelt in the eretz megurei Aviv (in the land wherein his father was a ger) in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","These are the toldot Ya'akov. Yosef, being seventeen years old, was ro'eh with his achim to the tzon; now the na'ar was with the bnei Bilhah, and with the bnei Zilpah, the ne'shei Aviv (the wives of his father); and Yosef brought unto Avihem (their father) dibbatam ra'ah (a bad, evil report of them). ");
INSERT INTO engojb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now Yisroel loved Yosef more than all his children, because he was the ben zekunim (the son of his old age); and he made him a kesones passim (ketonet tunic reaching to palms and soles). ");
INSERT INTO engojb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","And when his achim saw that Avihem loved him more than all his achim, they hated him, and could not speak with shalom unto him. ");
INSERT INTO engojb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","And Yosef dreamed a chalom (dream), and he told it to his achim; and they hated him yet the more. ");
INSERT INTO engojb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","And he said unto them, Hear, now, this chalom which I have dreamed: ");
INSERT INTO engojb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","For, hinei, we were binding alummim (sheaves of wheat) out in the sadeh, and, hinei, my sheaf arose, and also stood upright; and, hinei, your alummot (sheaves of wheat) gathered around it, and bowed down to my sheaf. ");
INSERT INTO engojb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","And his achim said to him, Shalt thou indeed reign over us? Or shalt thou indeed have dominion over us? And they hated him yet the more for his chalomot (dreams), and for his devarim. ");
INSERT INTO engojb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","And he dreamed yet another chalom, and told it his achim, and said, Hinei, I have dreamed a chalom more; and, hinei, the shemesh and the yarei'ach and the eleven kokhavim bowed down to me. ");
INSERT INTO engojb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","And he told it to Aviv, and to his achim: and Aviv rebuked him, and said unto him, What is this chalom that thou hast dreamed? Shall I and Immecha and Achecha indeed come to bow down ourselves to the ground before thee? ");
INSERT INTO engojb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","And his achim had kina (jealousy, envy) toward him; but Aviv was shomer over the saying. ");
INSERT INTO engojb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","And his achim went for the purpose to be ro'eh tzon Avihem in the vicinity of Shechem. ");
INSERT INTO engojb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","And Yisroel said unto Yosef, Do not thy achim ro'im in Shechem? Come and I will send thee unto them. And he said to him, Hineni. ");
INSERT INTO engojb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","And he said to him, Go, now, see about the shalom achecha, and the shalom hatzon; and bring me devar. So he sent him out of the Emek Chevron, and he went to Shechem. ");
INSERT INTO engojb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","And a certain ish found him, and, hinei, he was wandering in the sadeh; and the ish asked him, saying, What seekest thou? ");
INSERT INTO engojb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","And he said, I seek my achim; tell me, now, where they ro'im (feed their flocks). ");
INSERT INTO engojb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","And the ish said, They are departed from here; for I heard them say, Let us go to Dotan. And Yosef went after his achim, and found them in Dotan. ");
INSERT INTO engojb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","And when they saw him merachok (afar off, in the distance), even before he came near unto them, they conspired against him to kill him. ");
INSERT INTO engojb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","And they said one to another, Hinei, this ba'al hachalomot cometh. ");
INSERT INTO engojb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Come now therefore, and let us kill him, and throw him into one of the borot (pits), and we will say, Some chayyah ra'ah (evil wild beast) hath devoured him; and we shall see what will become of his chalomot. ");
INSERT INTO engojb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","And Reuven heard it, and he saved him out of their yadayim; and said, Let us not take his nefesh. ");
INSERT INTO engojb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","And Reuven said unto them, Do no shefach dahm (shedding of blood), but throw him into this bor that is in the midbar, and lay no yad upon him; that he might rescue him out of their yadayim, to take him back to Aviv. ");
INSERT INTO engojb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","And it came to pass, when Yosef was come unto his achim, that they stripped Yosef of his kesones, his kesones hapassim that was on him; ");
INSERT INTO engojb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","And they took him, and threw him into the borah (pit); and the bor was empty, there was no mayim in it. ");
INSERT INTO engojb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","And they sat down to eat lechem; and they lifted up their eyes and looked, and, hinei, a caravan of Yishm'elim was coming from Gil'ad with their gemalim bearing spices and balm and myrrh, going to carry it down to Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","And Yehudah said unto his achim, What betza (profit, gain) is it if we kill achinu (our brother), and conceal his dahm? ");
INSERT INTO engojb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, and let us sell him to the Yishm'elim, and let not yadeinu (our hands) be upon him; for he is achinu (our brother) and besareinu (our flesh). And his achim agreed. ");
INSERT INTO engojb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Then there passed by anashim Midyanim socharim (men of Midyan, traders); and they drew and lifted up Yosef out of the bor, and sold Yosef to the Yishm'elim for esrim kesef; and they took Yosef to Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","And Reuven returned unto the bor; and, hinei, Yosef was not in the bor; and he made the keriah of his clothes. ");
INSERT INTO engojb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","And he returned unto his achim, and said, The yeled is not; and I, where shall I turn? ");
INSERT INTO engojb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","And they took the kesones Yosef, and did shachat the se'ir izzim (slaughtered the kid of the goats), and dipped the kesones in the dahm; ");
INSERT INTO engojb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","And they sent the kesones hapassim, and they brought it to Avihem; and said, This have we found; examine for identification purposes now whether it be the kesones Binecha or no. ");
INSERT INTO engojb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","And he recognized it, and said, It is the kesones beni; a chayyah ra'ah hath devoured him; Yosef is without doubt torn in pieces. ");
INSERT INTO engojb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","And Ya'akov made the keriah of his clothes, and put sackcloth on his loins, and mourned for beno yamim rabbim. ");
INSERT INTO engojb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","And all his banim and all his banot rose up to comfort him; but he refused to be comforted; and he said, For I will go down to beni mourning to Sheol. Thus Aviv wept for him. ");
INSERT INTO engojb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","And the Midyanim sold him into Mitzrayim unto Potiphar, a seris Pharaoh (courtier of Pharaoh), a sar hatabbachim (a captain of the slaughterers, executioners, i.e., captain of the guard). ");
INSERT INTO engojb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","And it came to pass at that time, that Yehudah went down from his achim, and turned in to an ish Adullami shmo Chirah. ");
INSERT INTO engojb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","And Yehudah saw there a bat ish Kena'ani shmo Shua; and he took her, and went in unto her. ");
INSERT INTO engojb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","She conceived, and bore ben; and he called shmo Er. ");
INSERT INTO engojb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","And she conceived again, and bore ben; and she called shmo Onan. ");
INSERT INTO engojb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","And she yet again conceived, and bore ben; and called shmo Shelah; at Keziv, when she bore him. ");
INSERT INTO engojb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","And Yehudah took a wife for Er his bechor, whose shem was Tamar. ");
INSERT INTO engojb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","And Er, bechor Yehudah, was rah in the eyes of Hashem; and Hashem slaughtered him. ");
INSERT INTO engojb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","And Yehudah said unto Onan, Go in unto eshet achicha, and enter into levirate marriage with her, and raise up zera to achicha. ");
INSERT INTO engojb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","And Onan knew that the zera should not be his; and it came to pass, when he went in unto eshet achiv, that he spilled it on the ground, lest he should give zera to achiv. ");
INSERT INTO engojb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","And the thing which he did was rah in the eyes of Hashem; therefore He slaughtered him also. ");
INSERT INTO engojb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then said Yehudah to Tamar his shnur, Remain an almanah at thy bais avi, till Shelah beni is grown; for he said, Lest he die also, as his achim did. And Tamar went and dwelt in her bais avi. ");
INSERT INTO engojb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","And in process of time the bat Shua, eshet Yehudah, died; and Yehudah was consoled, and went up unto his sheepshearers to Timnah, he and his re'a Chirah the Adullami. ");
INSERT INTO engojb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","And it was told Tamar, saying, Hinei, thy shver (father-in-law) goeth up to Timnah to shear his tzon. ");
INSERT INTO engojb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","And she put off her widowʼs garments from her, and covered her with a tze'if (veil, shleier), and disguised herself, and sat at the entrance of Einayim which is on the derech to Timnah; for she saw that Shelah was grown, and she was not given unto him as isha. ");
INSERT INTO engojb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Yehudah saw her, he thought her to be a zonah; because she had covered her face. ");
INSERT INTO engojb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","And he turned unto her by the derech, and said, Come now, let me come in unto thee; (for he knew not that she was his shnur daughter-in-law). And she said, What wilt thou give me, that thou mayest come in unto me? ");
INSERT INTO engojb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","And he said, I will send thee a gedi izzim (kid of the goats). And she said, Wilt thou give me an eravon (pledge, mashkn), till thou send it? ");
INSERT INTO engojb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","And he said, What eravon shall I give thee? And she said, Thy chotam (signet), and thy signet neck cord, and thy staff that is in thine yad. And he gave it her, and came in unto her, and she conceived by him. ");
INSERT INTO engojb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","And she arose, and went away, and took off her tze'if (veil, shleier) from her, and put on the garments of her widowhood. ");
INSERT INTO engojb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","And Yehudah sent the gedi izzim by the yad of his friend the Adullami, to get back his eravon (pledge, mashkn) from the yad haisha; but he found her not. ");
INSERT INTO engojb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Then he asked the men of that place, saying, Where is the kedesha (cult prostitute) that was on the crossroads by the derech? And they said, There was no kedesha in this place. ");
INSERT INTO engojb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","And he returned to Yehudah, and said, I cannot find her; and also the men of the place said that there was no kedesha in this place. ");
INSERT INTO engojb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","And Yehudah said, Let her take for herself, lest we become buz (laughingstock, shpot); hinei, I sent this gedi, and thou hast not found her. ");
INSERT INTO engojb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","And it came to pass about shlosh chadashim (three months) later, that it was told Yehudah saying, Tamar thy shnur hath played the zonah; and also, hinei, she is with child by zenunim (whoredom). And Yehudah said, Bring her forth, and let her be burned. ");
INSERT INTO engojb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","When she was brought forth, she sent to her shver (father-in-law), saying, By the man, whose these are, am I with child; and she said, Discern, now, whose are these, the chotam (signet), and the signet neck cord, and the staff. ");
INSERT INTO engojb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","And Yehudah acknowledged them, and said, She hath been more tzadekah than I; because that I gave her not to Shelah beni. And he knew her again no more. ");
INSERT INTO engojb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","And it came to pass in the time of her travail, that, hinei te'omim (twin boys) were in her beten. ");
INSERT INTO engojb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","And it came to pass, when she travailed in labor, that the one put out his yad; and the midwife took and bound upon his yad a scarlet thread, saying, This came out rishonah (first). ");
INSERT INTO engojb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","And it came to pass, as he drew back his yad, that, hinei, his brother came out; and she said, How hast paratzta (thou broken out)? This paretz (breach, breaking) be upon thee; therefore shmo was called Peretz Breaking out. ");
INSERT INTO engojb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","And afterward came out his brother, that had the scarlet thread upon his yad; and shmo was called Zerach. ");
INSERT INTO engojb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","And Yosef was brought down to Mitzrayim; and Potiphar, a saris Pharaoh, Sar Hatabachim (captain of the bodyguard), a Mitzri, bought him of the hands of the Yishm'elim, which had brought him down to there. ");
INSERT INTO engojb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","And Hashem was with Yosef, and he was an ish matzliach (a man G-d makes prosper); and he was in the bais adonav haMitzri. ");
INSERT INTO engojb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","And adonav saw that Hashem was with him, and that Hashem caused all that he did matzliach in his yad. ");
INSERT INTO engojb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","And Yosef found chen in his eyes, and he ministered to him; and he made him mefake'ach (overseer) over his bais, and all that he had he entrusted into his yad. ");
INSERT INTO engojb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","And it came to pass from the time that he had made him mefake'ach (overseer) in his bais, and over all that he had, that Hashem put a brocha on the bais haMitzri on account of Yosef; and the birkat Hashem was upon all that he had in the bais, and in the sadeh. ");
INSERT INTO engojb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","And he left all that he had in the yad Yosef; and he knew not ought he had, save the lechem which he did eat. And Yosef was yafeh to'ar (well built) and yafeh mareh (good looking). ");
INSERT INTO engojb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","And it came to pass after these things, that eshet adonav cast her eyes upon Yosef; and she said, Lie with me. ");
INSERT INTO engojb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused, and said unto eshet adonav, Look, with me here, adoni knows not what is in the bais, and he hath entrusted all that he hath to my yad; ");
INSERT INTO engojb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","There is none gadol in this bais than I; neither hath he kept back any thing from me except thee only, because thou art his isha; how then can I do hara'ah hagedolah hazot, and commit chattat against Elohim? ");
INSERT INTO engojb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","And it came to pass, as she spoke to Yosef yom yom, that he unto her lo shama (did not pay heed), to lie with her, or to be with her. ");
INSERT INTO engojb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","And it came to pass about this time, that Yosef went into the bais to do his melachah (work); and there was none of the anshei habayit there within. ");
INSERT INTO engojb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","And she caught him by his beged, saying, Lie with me; and he left his beged in her yad, and fled, and ran outside. ");
INSERT INTO engojb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","And it came to pass, when she saw that he had left his beged in her yad, and had fled outside, ");
INSERT INTO engojb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","That she called unto her anshei habayit, and spoke unto them, saying, Look, he hath brought in unto us an ish Ivri to show disrespect and mock us. He came in unto me to lie with me, and I screamed with a kol gadol (loud voice); ");
INSERT INTO engojb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","And it came to pass, when he heard that I lifted up my voice and screamed, that he left his beged with me, and fled, and ran outside. ");
INSERT INTO engojb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","And she laid up his beged by her, until adonav came to his bais. ");
INSERT INTO engojb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","And she spoke unto him according to these words, saying, The eved HaIvri, which thou hast brought unto us, came in unto me to show disrespect and mock me; ");
INSERT INTO engojb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","And it came to pass, as I lifted up my voice and screamed, that he left his beged with me, and fled outside. ");
INSERT INTO engojb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","And it came to pass, when adonav heard the words of his isha, which she spoke unto him, saying, After this manner did thy eved to me; that his wrath was kindled. ");
INSERT INTO engojb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","And adonei Yosef took him, and put him into the bais hasohar, a place where the asirei HaMelech were prisoners; and he was there in the bais hasohar. ");
INSERT INTO engojb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But Hashem was with Yosef, and showed him chesed, and gave him chen in the eyes of the sar bais hasohar. ");
INSERT INTO engojb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","And the sar bais hasohar entrusted to the yad Yosef all the asirim (prisoners) that were in the bais hasohar; and whatsoever they did there, he was the accomplisher of it. ");
INSERT INTO engojb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The sar bais hasohar looked not to anything that was under his Yosefʼs yad; because Hashem was with him, and that which he did, Hashem made it to prosper. ");
INSERT INTO engojb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","And it came to pass after these things, that the mashkeh (cupbearer) Melech Mitzrayim and his ofeh (baker) had offended adoneihem Melech Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","And Pharaoh was in wrath against two of his sarisim, against the sar hamashkim, and against the sar ha'ofim. ");
INSERT INTO engojb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","And he put them b'mishmar (under watch, in custody) in the bais sar hatabachim (house of the captain of the bodyguards), in the bais hasohar, in the makom (place) where Yosef was incarcerated. ");
INSERT INTO engojb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","And the sar hatabachim charged Yosef with them, and he ministered to them; and they continued a season b'mishmar (in custody, under watch). ");
INSERT INTO engojb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","And they dreamed a chalom both of them, each man his chalom in lailah echad (in one night, the same night), and each chalom with its own pitron (meaning, interpretation), the mashkeh and the ofeh of Melech Mitzrayim, which were prisoners in the bais hasohar. ");
INSERT INTO engojb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","And Yosef came in unto them in the boker, and looked upon them, and, hinei, they were zo'afim (troubled ones, sad ones). ");
INSERT INTO engojb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","And he asked the sarisim of Pharaoh that were with him b'mishmar (in the custody ward) of bais adonav, saying, Why look ye so ra'im (bad, downcast ones) hayom (today)? ");
INSERT INTO engojb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","And they said unto him, We have dreamed a chalom, and there is no poter (interpreter) of it. And Yosef said unto them, Do not pitronim (interpretations) belong to Elohim? Tell now to me. ");
INSERT INTO engojb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","And the sar hamashkim told his chalom to Yosef, and said to him, In my chalom, hinei, a gefen was before me; ");
INSERT INTO engojb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","And in the gefen were shloshah sarigim (three branches); and it was as soon as it budded, its blossom shot forth; and the clusters thereof brought forth anavim (ripe grapes); ");
INSERT INTO engojb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","And the kos Pharaoh was in my yad; and I took the anavim (grapes), and pressed them into kos Pharaoh, and I put the kos into the palm of Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","And Yosef said unto him, This is the pitron (interpretation) of it; The shloshet hasarigim are shloshet yamim. ");
INSERT INTO engojb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Within shloshet yamim shall Pharaoh lift up thine rosh, and restore thee unto thy ken (place, post); and thou shalt deliver kos Pharaoh into his yad, after the mishpat harishon (former practice) when thou wast his mashkeh. ");
INSERT INTO engojb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But remember me when it shall be well with thee, and show chesed now unto me, and make mention of me unto Pharaoh, and bring me out of this bais; ");
INSERT INTO engojb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For indeed I was stolen away out of the Eretz HaIvrim; and here also have I done nothing that they should put me into the bor (dungeon). ");
INSERT INTO engojb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the sar ha'ofim saw that he had done the pitron well, he said unto Yosef, I also was in my chalom, and, hinei, I had shloshah salei chori (three baskets of cakes) on my rosh; ");
INSERT INTO engojb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","And in the sal haelyon (uppermost basket) there was all manner of food for Pharaoh; and ha'oph (the birds) did eat them out of the sal (basket) upon my rosh. ");
INSERT INTO engojb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","And Yosef answered and said, This is the pitron (interpretation, meaning) thereof: The shloshet hasalim (three baskets) are shloshet yamim. ");
INSERT INTO engojb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Yet within shloshet yamim shall Pharaoh lift off thy rosh from on thee, and shall hang thee on an etz; and ha'oph (the birds) shall eat thy basar from off thee. ");
INSERT INTO engojb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","And it came to pass on Yom HaShlishi, which was the yom huledet of Pharaoh, that he made a mishteh (feast) unto all his avadim; and he lifted up the rosh sar hamashkim and the rosh sar ha'ofim (head of the chief baker) in the midst of his avadim (officials). ");
INSERT INTO engojb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He restored the sar hamashkim unto his mashkeh; and he gave the kos into the palm of Pharaoh; ");
INSERT INTO engojb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But he hanged the sar ha'ofim: just as Yosef had made the pitron to them. ");
INSERT INTO engojb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yet did not the sar hamashkim remember Yosef but forgot him. ");
INSERT INTO engojb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","And it came to pass at the end of two full years, that Pharaoh dreamed a chalom: and, hinei, he stood by haye'or (the River, i.e., the Nile). ");
INSERT INTO engojb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","And, hinei, there came up out of haye'or (the River, i.e., the Nile) seven cows, fine in appearance and fat in basar; and they grazed on the riverbank. ");
INSERT INTO engojb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","And, hinei, seven other cows came up after them out of the Nile, ra'ot mareh (ugly in appearance) and dakot basar (gaunt ones in flesh, lean-fleshed); and stood by the other cows upon the bank of the Nile. ");
INSERT INTO engojb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","And the cows that were ra'ot hamareh and that were dakot habasar did devour the seven cows that were fine in appearance and fat. Then Pharaoh awoke. ");
INSERT INTO engojb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","And he slept and dreamed a chalom the second time; and, hinei, sheva heads of grain came up upon one stalk, beri'ot (fat ones) and tovot. ");
INSERT INTO engojb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","And, hinei, seven thin heads of grain scorched by the east wind tzomechot (sprung up) after them. ");
INSERT INTO engojb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","And the seven thin heads of grain devoured the seven fat and mele'ot (full) heads of grain. And Pharaoh awoke; and, hinei, it was a chalom! ");
INSERT INTO engojb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","And it came to pass in the boker that his ruach was troubled; and he sent and called for all the chartummei Mitzrayim (magicians of Egypt), and all the chachamim thereof; and Pharaoh told them his chalom; but there was no poter (interpreter) for Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the sar hamashkim spoke unto Pharaoh, saying, I do remember my faults this day. ");
INSERT INTO engojb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh was in wrath with his avadim, and put me b'mishmar (in custody) in the bais sar hatabbachim, both me and the sar ha'ofim; ");
INSERT INTO engojb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","And we dreamed a chalom in the same lailah, I and he; and each chalom we dreamed had its own pitron (interpretation). ");
INSERT INTO engojb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","And there was there with us a na'ar Ivri, eved to the sar hatabbachim; and we told him, and he interpreted to us chalomoteinu (our dreams); to each according to his chalom he did interpret. ");
INSERT INTO engojb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And it was, just as he interpreted to us, so it came to pass; me he restored unto mine ken (post), and him he hanged. ");
INSERT INTO engojb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh sent and summoned Yosef, and they brought him hastily out of the bor (dungeon); and he shaved, and changed his clothes, and came in unto Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","And Pharaoh said unto Yosef, I have dreamed a chalom, and there is no poter (interpreter) for it; and I have heard it said of thee, that thou canst understand a chalom to interpret it. ");
INSERT INTO engojb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","And Yosef answered Pharaoh, saying, It is not in me; Elohim shall give Pharaoh an answer of shalom. ");
INSERT INTO engojb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","And Pharaoh said unto Yosef, In my chalom, hineni, I stood upon the bank of the Nile; ");
INSERT INTO engojb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","And, hinei, there came up out of the Nile seven cows beri'ot basar (fat in body) and sleek of form; and they grazed by the riverbank. ");
INSERT INTO engojb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","And, hinei, seven other cows came up after them, dalot (poor, scrawny, thin) and ra'ot to'ar me'od (very ugly in appearance) and lean-fleshed, such as I never saw in kol Eretz Mitzrayim, unacceptably bad; ");
INSERT INTO engojb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","And the lean and the ra'ot cows did eat up the first seven fat cows; ");
INSERT INTO engojb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","And when they had eaten them up, it could not be known that they had eaten them; but they were still rah in appearance, as at the beginning. So I awoke. ");
INSERT INTO engojb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","And I saw in my chalom, and, hinei, seven heads of grain came up on one stalk, mele'ot (full) and tovot (good); ");
INSERT INTO engojb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","And, hinei, seven heads of grain, withered, thin, and scorched with the east wind, tzomechot (sprung up) after them; ");
INSERT INTO engojb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","And the thin heads of grain devoured the seven tov heads of grain; and I told this unto the chartummim (magicians); but there was none that could explain it to me. ");
INSERT INTO engojb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","And Yosef said unto Pharaoh, The chalom of Pharaoh is echad: HaElohim hath revealed to Pharaoh what He is about to do. ");
INSERT INTO engojb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows are seven shanim; and the seven good heads of grain are seven shanim. The chalom is echad. ");
INSERT INTO engojb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","And the seven lean and ugly cows that came up after them are sheva shanim; and the seven empty heads of grain scorched by the east wind are sheva shnei ra'av (seven years of famine). ");
INSERT INTO engojb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","This is the thing which I have spoken unto Pharaoh; What HaElohim is about to do He showeth unto Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hinei, there come sheva shanim of sava gadol (great fullness, plenty, abundance) throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","And there shall arise after them sheva shnei ra'av (seven years of famine) and kol hasava (all abundance) shall be forgotten in Eretz Mitzrayim; and the ra'av (famine) shall consume the land; ");
INSERT INTO engojb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","And the sava shall not be known in the land by reason of that ra'av (famine) following; for it shall be kaved me'od (very grievous). ");
INSERT INTO engojb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","And for that the chalom was doubled unto Pharaoh; it is because the thing is decidedly established by HaElohim, and HaElohim will shortly bring it to pass. ");
INSERT INTO engojb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Now therefore let Pharaoh select an ish navon and chochom (a man discerning and wise) and set him over Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharaoh do this, and let him appoint pekidim (officers, overseers, commissioners) over the land, and take up the fifth part of the harvest of Eretz Mitzrayim in the sheva shnei hasava. ");
INSERT INTO engojb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","And let them gather kol ochel of those shanim hatovot that come, and store up grain under the yad Pharaoh, and let them be shomer over ochel in the cities. ");
INSERT INTO engojb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","And that ochel shall be for reserves for the land against the sheva shnei hara'av, which shall be in Eretz Mitzrayim; that the land perish not through the ra'av. ");
INSERT INTO engojb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","And the thing was good in the eyes of Pharaoh, and in the eyes of all his avadim. ");
INSERT INTO engojb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","And Pharaoh said unto his avadim, Can we find such an ish as this is, an ish in whom is the Ruach Elohim? ");
INSERT INTO engojb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","And Pharaoh said unto Yosef, Forasmuch as Elohim hath showed thee all this, there is none so navon (discerning) and chochom (wise) as thou art; ");
INSERT INTO engojb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Thou shalt be over my bais (palace), and according unto thy mouth shall all my people order themselves; only with respect to the kisse will I be greater than thou. ");
INSERT INTO engojb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","And Pharaoh said unto Yosef, See, I have set thee over kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","And Pharaoh took off his taba'at (signet ring) from his yad, and put it upon yad Yosef, and arrayed him in garments of fine linen, and put a chain of zahav around his neck; ");
INSERT INTO engojb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","And he made him to ride in the second merkavah which he had; and they cried before him, Avrech! And he put him over kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","And Pharaoh said unto Yosef, I am Pharaoh, and without thee shall no man lift up his yad or regel in kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","And Pharaoh called shem Yosef Tzaphnat Pa'neach; and he gave him as isha Asenat Bat Poti Phera kohen of On. And Yosef went out over all Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","And Yosef was thirty years old when he stood before Pharaoh Melech Mitzrayim. And Yosef went out from the presence of Pharaoh, and went throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","And in the sheva shnei hasava the land brought forth by handfuls. ");
INSERT INTO engojb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","And he gathered up kol ochel of the sheva shanim, which were in Eretz Mitzrayim, and laid up the ochel in the cities; the ochel of the sadeh, which surrounded every city, laid he up in the same. ");
INSERT INTO engojb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","And Yosef gathered grain as the chol (sand) of the yam, very much, until he stopped counting; for it was without mispar (number). ");
INSERT INTO engojb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","And unto Yosef were born two banim before the shnat ra'av came, which Asenat Bat Poti Phera kohen of On bore unto him. ");
INSERT INTO engojb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","And Yosef called the shem of the bechor Menasheh: For Elohim, said he nashani, (hath made me forget) all my amal, and kol bais Avi. ");
INSERT INTO engojb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","And the shem of the second called he Ephrayim: For Elohim hifrani (hath caused me to be fruitful) in the eretz of my oni (suffering). ");
INSERT INTO engojb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","And the sheva shnei hasava that was in Eretz Mitzrayim were ended. ");
INSERT INTO engojb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","And the sheva shnei hara'av began to come, just as Yosef had said; and the ra'av was in all lands; but in kol Eretz Mitzrayim there was lechem. ");
INSERT INTO engojb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","And when kol Eretz Mitzrayim was famished, the people cried to Pharaoh for lechem; and Pharaoh said unto kol Mitzrayim, Go unto Yosef; what he saith to you, do. ");
INSERT INTO engojb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","And the ra'av (famine) was over kol pnei ha'aretz; and Yosef opened all that was in them, and sold unto the Mitzrayim; and the ra'av (famine) became severe in Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And kol HaAretz (all the world) came into Mitzrayim to Yosef to buy grain; because that the ra'av (famine) was so chazak in kol HaAretz. ");
INSERT INTO engojb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Now when Ya'akov saw that there was shever (grain) in Mitzrayim, Ya'akov said unto his banim, Why do ye look one upon another? ");
INSERT INTO engojb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","And he said, Hinei, I have heard that there is shever (grain) in Mitzrayim; get you down to there, and buy for us from there; that we may live, and not die. ");
INSERT INTO engojb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Achei Yosef asarah (Yosefʼs ten brothers) then went down to buy grain in Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Binyamin, achi Yosef, Ya'akov sent not with his achim; for he said, Lest ason (evil, harm) befall him. ");
INSERT INTO engojb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","And the Bnei Yisroel came to make purchase among those that were coming; for the ra'av (famine) was in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","And Yosef was the Shalit Al HaAretz, and he it was that sold to kol Am HaAretz: and Achei Yosef came, and prostrated themselves before him with their faces to the ground. ");
INSERT INTO engojb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","And Yosef saw his achim, and he recognized them, but made himself a stranger unto them, and spoke roughly unto them; and he said unto them, From where come ye? And they said, From Eretz Kena'an to buy ochel. ");
INSERT INTO engojb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","And Yosef recognized his achim, but they recognized not him. ");
INSERT INTO engojb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","And Yosef remembered the chalomot which he dreamed about them, and said unto them, Ye are meragelim (spies); to see the ervat ha'aretz (nakedness of the land) ye came. ");
INSERT INTO engojb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","And they said unto him, Lo, adoni, but to buy okhel are thy avadim come. ");
INSERT INTO engojb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all bnei ish echad; we are truthful ones, thy avadim are no meragelim. ");
INSERT INTO engojb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","And he said unto them, Lo, but to see the ervat ha'aretz ye came. ");
INSERT INTO engojb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","And they said, Thy avadim are Shneym Asar Achim, the bnei ish echad in Eretz Kena'an; and, hinei, the katon is today with Avinu, and one is not. ");
INSERT INTO engojb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","And Yosef said unto them, That is it just as I spoke unto you, Ye are meragelim; ");
INSERT INTO engojb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hereby ye shall be tested: by the life of Pharaoh ye shall not go forth from here, except achichem hakaton (your youngest brother) come here. ");
INSERT INTO engojb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of you, and let him bring back achichem, and ye shall be kept prisoner, that your words may be tested, whether there be any emes in you; or else by the life of Pharaoh surely ye are meragelim (spies). ");
INSERT INTO engojb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","And he put them all together el-mishmar (in custody) shloshet yamim. ");
INSERT INTO engojb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","And Yosef said unto them on the Yom HaShlishi, This do, and live; for I fear HaElohim: ");
INSERT INTO engojb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If ye be truthful ones, let one of your achim be bound in your bais mishmar; go ye, carry grain for the ra'avon (famine of) bateichem (your house); ");
INSERT INTO engojb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","But bring achichem hakaton unto me; so shall your words be verified, and ye shall not die. And they did so. ");
INSERT INTO engojb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","And they said one to another, Surely we are ashemim (guilty ones) because of achinu (our brother), in that we saw the tzoros of his nefesh, when he besought us, and we would not hear; therefore is this tzoros come upon us. ");
INSERT INTO engojb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","And Reuven answered them, saying, Spoke I not unto you, saying, Do not sin against the yeled; and ye would not hear? Therefore, hinei, the accounting for his dahm is required of us. ");
INSERT INTO engojb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","And they had no da'as that Yosef understood them; for he spoke unto them by the melitz (go-between, interpreter). ");
INSERT INTO engojb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","And he turned himself away from them, and wept; and returned to them again, and spoke with them, and took from them Shim'on, and bound him before their eyes. ");
INSERT INTO engojb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Yosef commanded to fill their kelim with grain, and to restore every manʼs kesef into his sack, and to give them provision for the derech; and thus did he unto them. ");
INSERT INTO engojb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","And they loaded their chamorim with the grain, and departed from there. ");
INSERT INTO engojb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","And as one of them opened his sack to get feed for his chamor in the malon (inn), he saw his kesef; for, hinei, it was in the mouth of his sack. ");
INSERT INTO engojb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","And he said unto his achim, My kesef is restored; and, hinei, it is even in my sack; and their lev failed them, and they shook with fear, saying one to another, What is this that Elohim hath done unto us? ");
INSERT INTO engojb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","And they came unto Ya'akov Avihem in Eretz Kena'an, and told him all that befell unto them; saying, ");
INSERT INTO engojb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","The ish, who is adonei HaAretz, spoke roughly to us, and took us for meragelim HaAretz. ");
INSERT INTO engojb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","And we said unto him, We are truthful ones; we are no meragelim; ");
INSERT INTO engojb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are Shneym Asar Achim, Bnei Avinu; one is not, and the katon is today with Avinu in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","And the ish, adonei HaAretz, said unto us, Hereby shall I know that ye are truthful ones; leave one of your achim here with me, and that which is needful for the ra'avon bateichem (famine of your houses), take and be gone; ");
INSERT INTO engojb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","And bring achichem hakaton unto me; then shall I know that ye are not meragelim, but that ye are truthful ones: so will I restore you achichem, and ye shall freely trade in the land. ");
INSERT INTO engojb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","And it came to pass as they emptied their sacks, that, hinei, every manʼs pouch of kesef was in his sack; and when both they and Avihem saw the pouches of kesef, they were afraid. ");
INSERT INTO engojb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","And Ya'akov Avihem said unto them, Me have ye bereaved of my children; Yosef is not, and Shim'on is not, and ye will take Binyamin away; all these things are against me. ");
INSERT INTO engojb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","And Reuven spoke unto Aviv, saying, Slay my two banim, if I bring him not to thee; entrust him into my yad, and I will bring him to thee again. ");
INSERT INTO engojb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","And he said, Beni (my son) shall not go down with you; for achiv is dead, and he is left alone; if ason (harm, evil) befall him on the derech in which ye go, then shall ye bring down my gray hair in yagon (sorrow) to Sheol. ");
INSERT INTO engojb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","And the ra'av (famine) was kaved (heavy, severe) in the land. ");
INSERT INTO engojb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","And it came to pass, when they had eaten up the shever (grain) which they had brought out of Mitzrayim, then Avihem said unto them, Shuvu (return)! Buy for us a little ochel. ");
INSERT INTO engojb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","And Yehudah spoke unto him, saying, The ish did solemnly warn us, saying, Ye shall not see my face, unless achichem be with you. ");
INSERT INTO engojb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If thou wilt send achinu (our brother) with us, we will go down and buy thee ochel; ");
INSERT INTO engojb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if thou wilt not send him, we will not go down; for the ish said unto us, Ye shall not see my face, unless achichem be with you. ");
INSERT INTO engojb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","And Yisroel said, Why dealt ye so ill with me, as to tell the ish whether ye had yet another ach (brother)? ");
INSERT INTO engojb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","And they said, The ish asked in detail about us and about our moledet (kindred), saying, Is Avichem yet alive? Have ye another ach? And we declared to him according to these words of his inquiry; could we certainly know that he would say, Bring down achichem? ");
INSERT INTO engojb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","And Yehudah said unto Yisroel Aviv, Send na'ar with me, and we will arise and go; that we may live, and not die, both we, and thou, and also our little ones. ");
INSERT INTO engojb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I will be surety for him; of my yad shalt thou require an accounting for him; if I bring him not back unto thee, and set him before thee, then let me bear the blame kol hayamim; ");
INSERT INTO engojb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","For if we had not delayed, surely now we had returned zeh pa'amayim (this second time). ");
INSERT INTO engojb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","And Yisroel Avihem said unto them, If it must be so now, do this; take of mizimerat HaAretz (the best fruits of the land) in your kelim (vessels), and carry down to the ish a minchah (present), a little balm, and a little devash (honey), nekhot (spices), loht (myrrh), batenim (pistachio nuts), and shekedim (almonds): ");
INSERT INTO engojb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","And take kesef mishneh (double money) in your yad; and the kesef that was returned in the mouth of your sacks, carry it back in your yad; perhaps it was mishgeh (mistake); ");
INSERT INTO engojb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take also achichem, and arise, shuvu (return) unto the ish; ");
INSERT INTO engojb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","And El Shaddai give you rachamim before the ish, that he may send away achichem acher (your other brother), and Binyamin. If I be bereaved of my children, I am bereaved. ");
INSERT INTO engojb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","And the anashim took that minchah, and they took mishneh kesef (double money) in their yad and Binyamin; and rose up, and went down to Mitzrayim, and stood before Yosef. ");
INSERT INTO engojb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","And when Yosef saw Binyamin with them, he said to the ish over Bais Yosef, Bring these anashim home, and slaughter the tevach, and make ready; for these anashim shall dine with me at tzahorayim (noon). ");
INSERT INTO engojb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","And the ish did as Yosef said; and the ish brought the anashim to the house of Yosef. ");
INSERT INTO engojb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","And the anashim were afraid, because they were brought into Bais Yosef; and they said, Because of the kesef that was returned in our sacks at the first time are we brought in; that he may seek occasion against us, and fall upon us, and seize us for avadim, and chamoreinu (our donkeys). ");
INSERT INTO engojb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","And they came near to the ish over Bais Yosef, and they spoke with him at the petach habayit, ");
INSERT INTO engojb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","And said, O adoni, we came indeed down at the first time to buy ochel: ");
INSERT INTO engojb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","And it came to pass, when we came to the malon, that we opened our sacks, and, hinei, kesef ish (every manʼs money) was in the mouth of his sack, our kesef in full weight; and we have brought it back again in our yad. ");
INSERT INTO engojb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","And kesef acher (other money) have we brought down in our hands to buy ochel; we cannot tell who put our kesef in our sacks. ");
INSERT INTO engojb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","And he said, Shalom lachem, fear not; Eloheichem, and Elohei Avichem, hath given you matmon (treasure) in your sacks; I had your kesef. And he brought Shim'on out unto them. ");
INSERT INTO engojb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","And the ish brought the anashim into the house of Yosef, and gave them mayim, and they washed their raglayim; and he gave their chamorim mispo (fodder). ");
INSERT INTO engojb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","And they made ready the minchah for bo Yosef (coming of Yosef) at tzahorayim; for they heard that they would eat lechem there. ");
INSERT INTO engojb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","And when Yosef came home, they presented him the minchah which was in their yad in the house, and prostrated themselves to the ground before him. ");
INSERT INTO engojb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","And he asked them l'shalom (about their welfare), and said, Is there shalom with avichem, the zaken of whom ye spoke? Is he still alive? ");
INSERT INTO engojb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","And they answered, There is shalom with thy eved avinu; he is still alive. And they bowed their heads, and prostrated themselves. ");
INSERT INTO engojb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","And he lifted up his eyes, and saw achiv Binyamin, ben immo, and said, Is this achichem hakaton (your younger brother), of whom ye spoke unto me? And he said, Elohim be gracious unto thee, beni. ");
INSERT INTO engojb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","And Yosef made haste; for his compassion was stirred upon achiv (his brother); and he sought where to weep; and he entered into his cheder, and wept there. ");
INSERT INTO engojb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","And he washed his face, and went out, and controlled himself, and said, Serve lechem. ");
INSERT INTO engojb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","And they served him by himself, and them by themselves, and the Mitzrim (Egyptians), which did eat with him, by themselves; because Mitzrim could not eat lechem with the Ivrim; for that is a to'evah (abomination) unto the Mitzrim. ");
INSERT INTO engojb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","And they sat before him, the bechor according to his bechorah (birthright), and the youngest according to his youth; and the anashim marvelled one with another. ");
INSERT INTO engojb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","And he took and sent masot (portions) unto them from before him; but masat Binyamin was five times as much as any of theirs. And they drank, and feasted with him. ");
INSERT INTO engojb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","And he commanded the ish over Bais Yosef, saying, Fill the sacks of the anashim with ochel, as much as they can carry, and put kesef ish in the mouth of his sack. ");
INSERT INTO engojb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","And put my cup, gevi'a hakesef (cup of silver), in the mouth of the sack of the katon, and his kesef for shever (grain). And he did according to the davar Yosef had spoken. ");
INSERT INTO engojb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","As soon as the boker ohr, the anashim were sent away, they and their chamorim. ");
INSERT INTO engojb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","And when they were gone out of the ir, and not yet far off, Yosef said unto the ish over Bais Yosef, Up, follow after the anashim; and when thou dost overtake them, say unto them, Wherefore have ye rewarded ra'ah for tovah? ");
INSERT INTO engojb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is not this it in which adoni drinketh, and whereby indeed he divineth? Ye have done ra'ah in so doing. ");
INSERT INTO engojb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","And he overtook them, and he spoke unto them these same devarim. ");
INSERT INTO engojb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","And they said unto him, Wherefore saith adoni these words? Chalilah (far be it) that thy avadim should do according to this thing; ");
INSERT INTO engojb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Hinei, the kesef, which we found in the mouth of our sacks, we brought back unto thee out of Eretz Kena'an; how then should we be ganavim stealing kesef or zahav out of the bais adoneicha? ");
INSERT INTO engojb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","With whomsoever of thy avadim it be found, both let him die, and we also will be avadim of adoni. ");
INSERT INTO engojb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","And he said, Now also let it be according unto your devarim; he with whom it is found shall be to me eved; and ye shall be nekiyim (blameless). ");
INSERT INTO engojb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Then they speedily took down every ish his sack to the ground, and opened every ish his sack. ");
INSERT INTO engojb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","And he searched, and began at the gadol (eldest), and ended at the katon (youngest); and the gevi'a (cup, goblet) was found in the sack of Binyamin. ");
INSERT INTO engojb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then they tore their garments, and loaded every ish his chamor, and returned to the ir. ");
INSERT INTO engojb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","And Yehudah and his achim came to Bais Yosef; for he was yet there; and they fell before him on the ground. ");
INSERT INTO engojb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","And Yosef said unto them, What ma'aseh (deed) is this that ye have done? Know ye not that an ish like me can find things out as a menachesh (diviner)? ");
INSERT INTO engojb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","And Yehudah said, What shall we say unto adoni? What shall we speak? Or how shall we clear ourselves? HaElohim hath found out the avon (iniquity) of thy avadim; look at us, we are now avadim la'adoni, both we, and he also with whom the gevi'a (cup) is found. ");
INSERT INTO engojb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","And he Yosef said, Chalilah that I should do so; but the ish in whose yad the gevi'a is found, he shall be to me eved; and as for you, go back in shalom unto avichem. ");
INSERT INTO engojb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Yehudah came near unto him, and said, Oh, adoni, let thy eved speak now a davar in oznei adoni, and let not thine anger burn against thy eved; for thou art even like Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Adoni asked his avadim, saying, Have ye an av, or an ach? ");
INSERT INTO engojb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","And we said unto adoni, We have an av, a zaken, and a yeled zekunim katan (child of his old age, a little one); and achiv is dead, and he alone is left of immo, and aviv loveth him. ");
INSERT INTO engojb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","And thou saidst unto thy avadim, Bring him down unto me, that I may set mine eyes upon him. ");
INSERT INTO engojb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","And we said unto adoni, The na'ar cannot leave aviv; for if he should leave aviv, aviv would die. ");
INSERT INTO engojb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","And thou saidst unto thy avadim, Except achichem hakaton (your youngest brother) come down with you, ye shall see my face no more. ");
INSERT INTO engojb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","And it came to pass when we came up unto thy eved Avi we told him the divrei adoni. ");
INSERT INTO engojb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","And avinu said, Shuvu, (go back, return) and buy us a little ochel. ");
INSERT INTO engojb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","And we said, We cannot go down; if achinu hakaton (our youngest brother) be with us, then will we go down; for we may not see the face of HaIsh, except achinu hakaton be with us. ");
INSERT INTO engojb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","And thy eved Avi said unto us, Ye know that my wife bore me two banim; ");
INSERT INTO engojb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","And the one went out from me, and I said, Surely he is torn to pieces; and I saw him not ad-hennah (until now); ");
INSERT INTO engojb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","And if ye take this also from me, and ason (evil, harm) befall him, ye shall bring down my gray hair in ra'ah (misery) to Sheol. ");
INSERT INTO engojb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Now therefore when I come to thy eved Avi, and the na'ar be not with us; seeing that his nefesh is bound up in the nefesh of the na'ar; ");
INSERT INTO engojb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","It shall come to pass, when he seeth that the na'ar is not with us, that he will die; and thy avadim shall bring down the gray hair of thy eved avinu with yagon (sorrow) to Sheol, ");
INSERT INTO engojb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","For thy eved became surety for the na'ar unto Avi, saying, If I bring him not unto thee, then I shall bear the blame before Avi kol hayamim. ");
INSERT INTO engojb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Therefore, let thy eved, now, abide instead of the na'ar, an eved to adoni; and let the na'ar go up with his achim. ");
INSERT INTO engojb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how shall I go up to Avi, and the na'ar be not with me? Lest I see the rah that would overtake Avi. ");
INSERT INTO engojb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Then Yosef could not control himself before all them that stood by him; and he cried, Cause kol ish to go out from me. And there stood no ish with him, while Yosef made himself known unto his achim. ");
INSERT INTO engojb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","And he wept aloud; and the Mitzrayim and the Bais Pharaoh heard. ");
INSERT INTO engojb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","And Yosef said unto his achim (brethren), I am Yosef; doth Avi yet live? And his achim could not answer him; for they were shocked with dismay at his presence. ");
INSERT INTO engojb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","And Yosef said unto his achim, Come near to me, now. And they came near. And he said, I am Yosef achichem (your brother), whom ye sold into Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Now therefore be not grieved, nor angry with yourselves, that ye sold me here; for Elohim did send me before you to save life. ");
INSERT INTO engojb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these two years hath the ra'av (famine) been in the land; and yet there are chamesh shanim (five years), in the which there shall neither be plowing nor harvest. ");
INSERT INTO engojb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","And Elohim sent me before you to save you a she'erit (remnant) in the earth, and to save life for you by a peletah gedolah (great deliverance, escape). ");
INSERT INTO engojb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So now it was not you that sent me here, but HaElohim; and He hath made me as an Av to Pharaoh, and adon of all his Bais, and Moshel throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Haste ye, and go up to Avi, and say unto him, Thus saith thy ben, Yosef, Elohim hath made me as adon kol Mitzrayim; come down unto me, tarry not; ");
INSERT INTO engojb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","And thou shalt dwell in Eretz Goshen, and thou shalt be karov (near) unto me, thou, and thy banim, and thy bnei banecha, and thy tzon, and thy bakar, and all that thou hast: ");
INSERT INTO engojb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","And there will I nourish thee; for yet there are chamesh shanim of ra'av (famine); lest thou, and thy bais, and all that thou hast, come to destitution. ");
INSERT INTO engojb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","And, hinei, your eyes see, and the eyes of achi Binyamin, that it is my mouth that speaketh unto you. ");
INSERT INTO engojb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","And ye shall tell Avi of kol my kavod b'Mitzrayim, and of all that ye have seen; and ye shall haste and bring down Avi here. ");
INSERT INTO engojb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","And he fell upon the neck of Binyamin achiv, and wept; and Binyamin wept upon his neck. ");
INSERT INTO engojb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Moreover he kissed all his achim, and wept upon them; and after that his achim talked with him. ");
INSERT INTO engojb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","And the news thereof was heard in Bais Pharaoh saying, Achei Yosef are come; and it pleased Pharaoh well, and his avadim. ");
INSERT INTO engojb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","And Pharaoh said unto Yosef, Say unto thy achim, This do ye; load your beasts, and go, get you unto Eretz Kena'an; ");
INSERT INTO engojb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","And take Avichem and your households, and come unto me; and I will give you the best of Eretz Mitzrayim, ye shall eat the chelev haaretz. ");
INSERT INTO engojb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Now thou art commanded, this do ye; take you agalot (wagons) out of Eretz Mitzrayim for your little ones, and for your nashim, and bring Avichem, and come. ");
INSERT INTO engojb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Also regard not your kelim; for the best of kol Eretz Mitzrayim is yours. ");
INSERT INTO engojb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","And the Bnei Yisroel did so; and Yosef gave them agalot, according to the commandment of Pharaoh, and gave them provision for the derech. ");
INSERT INTO engojb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","To all of them he gave each man chalifot semalot; but to Binyamin he gave three hundred pieces of kesef, and chamesh chalifot semalot. ");
INSERT INTO engojb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","And to Aviv he sent after this manner; ten chamorim loaded with the best of Mitzrayim, and ten female donkeys loaded with grain and lechem and provision for Aviv for the derech. ");
INSERT INTO engojb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","So he sent his achim away, and they departed; and he said unto them, See that ye not quarrel by the derech. ");
INSERT INTO engojb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","And they went up out of Mitzrayim, and came into Eretz Kena'an unto Ya'akov avihem, ");
INSERT INTO engojb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","And told him, saying, Yosef chai! Yosef is yet alive, and he is Moshel kol Eretz Mitzrayim. And Ya'akovʼs lev fainted, for he believed them not. ");
INSERT INTO engojb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","And they told him kol divrei Yosef, which he had said unto them; and when he saw the agalot which Yosef had sent to carry him, the ruach Ya'akov avihem revived; ");
INSERT INTO engojb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","And Yisroel said, It is enough; Yosef Beni chai! Yosef Beni is yet alive; I will go and see him before I die. ");
INSERT INTO engojb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","And Yisroel took his journey with all that he had, and came to Be'er-Sheva, and offered zevakhim unto Elohei Aviv Yitzchak. ");
INSERT INTO engojb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","And Elohim spoke unto Yisroel in the marot halailah, and said, Ya'akov, Ya'akov. And he said, Hineni. ");
INSERT INTO engojb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","And He said, I am El Elohei Avicha; fear not to go down to Mitzrayim; for there I will make thee a Goy Gadol; ");
INSERT INTO engojb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with thee to Mitzrayim; and I will also surely bring thee up again; and Yosef shall put his yad upon thine eyes. ");
INSERT INTO engojb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","And Ya'akov rose up from Be'er-Sheva; and the Bnei Yisroel carried Ya'akov Avihem, and their little ones, and their nashim, in the agalot which Pharaoh had sent to carry him. ");
INSERT INTO engojb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","And they took their mikneh, and their possessions, which they had acquired in Eretz Kena'an, and came to Mitzrayim, Ya'akov, and all his zera with him; ");
INSERT INTO engojb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","His banim, and his bnei banim with him, his banot, and his banot banim, and all his zera brought he with him to Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","And these are the shemot Bnei Yisroel, which came to Mitzrayim: Ya'akov and his banim: Reuven, bechor Ya'akov; ");
INSERT INTO engojb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","And the Bnei Reuven: Chanokh, and Pallu, and Chetzron, and Carmi. ");
INSERT INTO engojb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","And the Bnei Shim'on: Yemuel, and Yamin, and Ohad, and Yachin, and Tzochar, and Sha'ul Ben HaKena'ani. ");
INSERT INTO engojb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","And the Bnei Levi: Gershon, Kohat, and Merari. ");
INSERT INTO engojb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","And the Bnei Yehudah: Er, and Onan, and Shelah, and Peretz, and Zerach; but Er and Onan died in Eretz Kena'an. And the Bnei Peretz were Chetzron and Chamul. ");
INSERT INTO engojb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","And the Bnei Yissakhar: Tola, and Puvah, and Yov, and Shimron. ");
INSERT INTO engojb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","And the Bnei Zevulun: Sered, Elon, and Yachle'el. ");
INSERT INTO engojb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are the Bnei Leah, which she bore unto Ya'akov in Paddan-Aram, with his bat Dinah; kol nefesh of his banim and his banot were thirty and three. ");
INSERT INTO engojb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","And the Bnei Gad: Tziphyon, Chaggi, Shuni, Etzbon, Eri, Arodi, and Areli. ");
INSERT INTO engojb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","And the Bnei Asher: Yimnah, and Yishvah, and Yishvi, and Beri'ah, and Serach their achot; and the Bnei Beri'ah: Chever, and Malki'el. ");
INSERT INTO engojb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the Bnei Zilpah, whom Lavan gave to Leah his bat, and these she bore unto Ya'akov, even sixteen nefesh. ");
INSERT INTO engojb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The Bnei Rachel eshet Ya'akov: Yosef, and Binyamin. ");
INSERT INTO engojb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","And unto Yosef in Eretz Mitzrayim were born Menasheh and Ephrayim, which Asenat Bat Poti Phera kohen of On bore unto him. ");
INSERT INTO engojb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","And the Bnei Binyamin were Bela, and Becher, and Ashbel, Gera, and Na'aman, Echi, and Rosh, Muppim, and Chuppim, and Ard. ");
INSERT INTO engojb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are the Bnei Rachel, which were born to Ya'akov; kol nefesh were fourteen. ");
INSERT INTO engojb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","And the Bnei Dan: Chushim. ");
INSERT INTO engojb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","And the Bnei Naphtali: Yachtze'el, and Guni, and Yetzer, and Shillem. ");
INSERT INTO engojb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are the Bnei Bilhah, which Lavan gave unto Rachel his bat, and she bore these unto Ya'akov; kol nefesh were shivah. ");
INSERT INTO engojb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Kol hanefesh that came with Ya'akov to Mitzrayim, which came out of his loins, apart from the nashim of the Bnei Ya'akov, kol nefesh were threescore and six; ");
INSERT INTO engojb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","And the Bnei Yosef, which were born to him in Mitzrayim, were two nefesh; kol hanefesh of Bais Ya'akov, which came into Mitzrayim, were shivim (seventy). ");
INSERT INTO engojb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","And he sent Yehudah before him unto Yosef, to direct his face unto Goshen; and they came into Eretz Goshen. ");
INSERT INTO engojb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","And Yosef made ready his merkavah, and went up to meet Yisroel Aviv, to Goshen, and presented himself unto him; and he fell on his neck, and wept on his neck a long time. ");
INSERT INTO engojb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","And Yisroel said unto Yosef, Now let me die, since I have seen thy face, because thou art yet alive. ");
INSERT INTO engojb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","And Yosef said unto his achim, and unto Bais Aviv, I will go up, and speak to Pharaoh, and say unto him, My achim and Bais Avi, which were in Eretz Kena'an, are come unto me; ");
INSERT INTO engojb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","And the anashim are roei tzon (shepherds), keepers of livestock; and they have brought their tzon, and their bakar, and all that they have. ");
INSERT INTO engojb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","And it shall come to pass, when Pharaoh shall call you, and shall say, What is ma'aseichem (your occupation)? ");
INSERT INTO engojb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","That ye shall say, Thy avadim hath been keepers of livestock from our youth even until now, both we, and also Avoteinu; that ye may dwell in Eretz Goshen; for every ro'eh tzon is a toevat Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Then Yosef came and told Pharaoh, and said, Avi and my achim, and their tzon, and their bakar, and all that they have, are come out of Eretz Kena'an; and they are now in Eretz Goshen. ");
INSERT INTO engojb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","And he took some of his achim, even five anashim, and presented them unto Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","And Pharaoh said unto his achim, What is your occupation? And they said unto Pharaoh, Thy avadim are roeh tzon, both we, and also Avoteinu. ");
INSERT INTO engojb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","They said moreover unto Pharaoh, For to sojourn in the land are we come; for thy avadim have no mireh (pasture) for their tzon; for the ra'av (famine) is heavy in Eretz Kena'an; now therefore, let now thy avadim dwell in Eretz Goshen. ");
INSERT INTO engojb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","And Pharaoh spoke unto Yosef, saying, Avicha and acheicha are come unto thee; ");
INSERT INTO engojb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Eretz Mitzrayim is before thee; in the best of the land make avicha and acheicha to dwell; in Eretz Goshen let them dwell; and if thou knowest any anshei chayil among them, then make them sarei mikneh (royal overseers of livestock) of mine. ");
INSERT INTO engojb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","And Yosef brought in Ya'akov aviv, and set him before Pharaoh; and Ya'akov made on Pharaoh a brocha. ");
INSERT INTO engojb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","And Pharaoh said unto Ya'akov, How old art thou? ");
INSERT INTO engojb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","And Ya'akov said unto Pharaoh, The days of the shanim of my pilgrimage are a hundred and thirty shanah; few and bad have the days of the years of my life been, and have not attained unto the days of the years of the life of my avot in the days of their pilgrimage. ");
INSERT INTO engojb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","And Ya'akov made a brocha on Pharaoh, and went out from the presence of Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","And Yosef settled aviv and his achim, and gave them an achuzzah (possession) in Eretz Mitzrayim, in the best of the land, in Eretz Ra'meses, just as Pharaoh had commanded. ");
INSERT INTO engojb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","And Yosef provided for aviv, and his achim, and kol bais aviv, with lechem, according to the children. ");
INSERT INTO engojb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","And there was no lechem in kol ha'aretz; for the ra'av was very heavy, so that Eretz Mitzrayim and kol Eretz Kena'an fainted by reason of the ra'av (famine). ");
INSERT INTO engojb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","And Yosef gathered up all the kesef that was found in the Eretz Mitzrayim, and in Eretz Kena'an, for the shever (grain) which they bought; and Yosef brought the kesef into Bais Pharaoh (Pharaohʼs palace). ");
INSERT INTO engojb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","And when kesef failed in Eretz Mitzrayim, and in Eretz Kena'an, kol Mitzrayim came unto Yosef, and said, Give us lechem; for why should we die in thy presence? For the kesef is gone. ");
INSERT INTO engojb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","And Yosef said, Give your mikneh; and I will give you for your mikneh, if kesef is gone. ");
INSERT INTO engojb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","And they brought their mikneh unto Yosef; and Yosef gave them lechem in exchange for susim, and for the tzon, and for the mikneh of the bakar, and for the chamorim; and he fed them lechem for all their mikneh for that year. ");
INSERT INTO engojb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","When that year was ended, they came unto him the shanah hashenit, and said unto him, We will not hide it from adoni, how that our kesef is spent; adoni also hath our mikneh of behemah; there is not ought left in the sight of adoni, but geviyyatenu (our bodies), and adematenu (our lands); ");
INSERT INTO engojb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why shall we die before thine eyes, both we and adematenu? Buy us and adematenu for lechem, and we and adematenu will be avadim unto Pharaoh; and give us zera, that we may live, and not die, that the adamah be not desolate. ");
INSERT INTO engojb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","And Yosef bought kol Admat Mitzrayim for Pharaoh; for the Mitzrayim sold every ish his sadeh, because the ra'av (famine) was chazak over them; so the land became Pharaohʼs. ");
INSERT INTO engojb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","And as for the people, he removed them to cities from one end of the borders of Mitzrayim even to the other end thereof. ");
INSERT INTO engojb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Only the admat hakohanim bought he not; for the kohanim had a chok assigned them of Pharaoh, and did eat their chok which Pharaoh gave them; therefore they sold not their lands. ");
INSERT INTO engojb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Yosef said unto the people, See, I have bought you this day and your land for Pharaoh: lo, here is zera for you, and ye shall sow the adamah. ");
INSERT INTO engojb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","And it shall come to pass in the tevu'ot, that ye shall give the fifth part unto Pharaoh, and four parts shall be your own, for zera of the sadeh, and for your ochel, and for them of your batim, and for food for your children. ");
INSERT INTO engojb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","And they said, Thou hast saved our lives; let us find chen (grace, favor) in the sight of adoni, and we will be avadim to Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","And Yosef made it a chok over Eretz Mitzrayim unto this day, that Pharaoh should have the fifth part, except the admat hakohanim only, which became not Pharaohʼs. ");
INSERT INTO engojb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","And Yisroel settled in Eretz Mitzrayim, in Eretz Goshen; and they acquired property therein, and grew, and multiplied exceedingly. ");
INSERT INTO engojb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","And Ya'akov lived in Eretz Mitzrayim seventeen shanah; so the whole age of Ya'akov was a hundred forty and seven shanah. ");
INSERT INTO engojb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","And the time drew near that Yisroel must die; and he called bno Yosef, and said unto him, If now I have found chen in thy sight, put, now, thy yad under my thigh, and do chesed and emes with me; bury me not, now, in Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","But I will lie with my avot, and thou shalt carry me out of Mitzrayim, and bury me in their kever. And he said, I will do as thou hast said. ");
INSERT INTO engojb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","And he said, Swear unto me. And he swore unto him. And Yisroel prostrated toward the rosh hamittah. ");
INSERT INTO engojb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","And it came to pass after these things, that one told Yosef, Hinei, Avicha is choleh (ill); and he took with him his two banim, Menasheh and Ephrayim. ");
INSERT INTO engojb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","And one told Ya'akov, and said, Hinei, the ben of thee Yosef cometh unto thee; and Yisroel strengthened himself, and sat up upon the mittah (bed). ");
INSERT INTO engojb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","And Ya'akov said unto Yosef, El Shaddai appeared unto me at Luz in Eretz Kena'an, and made on me a brocha, ");
INSERT INTO engojb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","And said unto me, Hineni, I will make thee fruitful, and multiply thee, and I will make of thee a kehal of ammim; and will give HaAretz Hazot to thy zera after thee for an achuzzat olam (everlasting possession). ");
INSERT INTO engojb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","And now thy two banim, Ephrayim and Menasheh, which were born unto thee in Eretz Mitzrayim before I came unto thee into Mitzrayim, are mine; like Reuven and Shim'on, they shall be mine. ");
INSERT INTO engojb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","And thy moledet, which are born to thee after them, shall be thine, and shall be called after the shem of their achim in their nachalah. ");
INSERT INTO engojb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","And as for me, when I came from Paddan, Rachel died by me in Eretz Kena'an in the way, when there was yet but a space of land to go unto Ephratah; and I buried her there by the derech Ephrat; the same is Beit-Lechem. ");
INSERT INTO engojb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","And Yisroel beheld Bnei Yosef, and said, Who are these? ");
INSERT INTO engojb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","And Yosef said unto aviv, They are my banim, whom Elohim hath given me in this place. And he said, Bring them, now, unto me, and I will make upon them a brocha. ");
INSERT INTO engojb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now the eyes of Yisroel were dim from age, so that he could not see. And he brought them near unto him; and he kissed them, and embraced them. ");
INSERT INTO engojb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","And Yisroel said unto Yosef, I never expected to see thy face; and, hinei, Elohim hath showed me also thy zera. ");
INSERT INTO engojb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","And Yosef brought them out from between his knees, and he bowed himself with his face to the ground. ");
INSERT INTO engojb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","And Yosef took them both, Ephrayim in his yamin toward smol Yisroel, and Menasheh on his smol toward yamin Yisroel, and brought them near unto him. ");
INSERT INTO engojb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","And Yisroel stretched out his yamin, and laid it upon rosh Ephrayim, who was the younger, and his smol upon rosh Menasheh, guiding his hands intentionally; for Menasheh was the bechor. ");
INSERT INTO engojb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","And he made on Yosef a brocha, and said, HaElohim, before whom my Avot Avraham and Yitzchak did walk, HaElohim Who was Roeh to me all my life long unto this day, ");
INSERT INTO engojb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","The Malach which redeemed me from kol rah, may he make a brocha on the ne'arim, and let my shem be named on them, and the shem of my Avot Avraham and Yitzchak; and let them grow into a multitude in the midst of ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","And when Yosef saw that aviv laid his yamin upon the rosh Ephrayim, it displeased him; and he took hold of yad aviv, to remove it from rosh Ephrayim unto rosh Menasheh. ");
INSERT INTO engojb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","And Yosef said unto aviv, Not so, Avi; for this is the bechor; put thy yamin upon his rosh. ");
INSERT INTO engojb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","And aviv refused, and said, I know it, beni (my son), I know it; he also shall become a people, and he also shall be great; but truly achiv hakaton shall be greater than he, and his zera shall become a multitude of Goyim. ");
INSERT INTO engojb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","And he made a brocha on them that day, saying, In thee shall Yisroel bless, saying, Elohim make thee like Ephrayim and like Menasheh; and he set Ephrayim before Menasheh. ");
INSERT INTO engojb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","And Yisroel said unto Yosef, Hinei I die; but Elohim shall be with you, and bring you back unto the Eretz Avoteichem. ");
INSERT INTO engojb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Moreover, I have given to thee one portion above thy achim, which I took out of the yad HaEmori with my cherev and with my keshet. ");
INSERT INTO engojb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","And Ya'akov called unto his banim, and said, Gather yourselves together, that I may tell you that which shall befall you in the acharit hayamim (last days). ");
INSERT INTO engojb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Gather yourselves together, and hear, ye Bnei Ya'akov; and pay heed unto Yisroel Avichem. ");
INSERT INTO engojb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuven, thou art my bechor, my koach, and the reshit of my strength, the excellency of honor, and excellency of oz (power): ");
INSERT INTO engojb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Unstable as mayim, thou shalt not excel; because thou wentest up to mishkevei avicha (thy fatherʼs bed, i.e. incest); then defiledst thou it; he went up to my couch. ");
INSERT INTO engojb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shim'on and Levi are achim; kelei chamas (instruments of violence) are in their swords. ");
INSERT INTO engojb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O my nefesh, enter not thou into their sod (secret, council); unto their kehal, mine kavod, be not thou united; for in their anger they slaughtered ish, and in their ratzon (self-will) they lamed shor (ox). ");
INSERT INTO engojb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Arur (cursed) be their anger, for it was fierce; and their wrath, for it was cruel; I will dispense them in Ya'akov, and scatter them in Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehudah, thou art he whom thy achim yoducha (they will praise you); thy yad shall be in the oref (neck) of thine enemies; Bnei Avicha shall bow down before thee. ");
INSERT INTO engojb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehudah is the cub of an aryeh (lion); from the prey, beni (my son), thou hast gone up; he stooped down, he couched like an aryeh, and like a lioness; who shall rouse him? ");
INSERT INTO engojb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The shevet (sceptre) shall not depart from Yehudah, nor a Mekhokek (Lawgiver) from between his raglayim, until Shiloh come; and unto him shall be the obedience of the amim (peoples, nations). ");
INSERT INTO engojb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He ties his foal unto the gefen (vine), and his donkeyʼs colt unto the choice vine; he will wash his levush (garments) in yayin, and his robe in the dahm anavim (blood of grapes); ");
INSERT INTO engojb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes shall be darker with yayin, and his shinayim (teeth) whiter than cholov (milk). ");
INSERT INTO engojb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zevulun shall dwell at the seashore; and he shall be a haven for oniyyot (ships); and his border shall be unto Tzidon. ");
INSERT INTO engojb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Yissakhar is a strong chamor (donkey) lying down between two saddlebags; ");
INSERT INTO engojb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","And he saw that a menuchah (resting place) was tov, and haaretz that it was pleasant; and bowed his shoulder to bear, and became oved (submitting, enslaved) at forced labor. ");
INSERT INTO engojb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan yadin (shall judge) his people, as one of the Shivtei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan shall be a nachash beside the derech, a viper along the orach (path) that biteth the ikkvei sus (the horse heels), so that its rider shall fall backward. ");
INSERT INTO engojb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I have waited for Thy Yeshu'ah (Salvation), Hashem. ");
INSERT INTO engojb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, gedud (raider) shall raid him; but he shall raid akev (at the heel). ");
INSERT INTO engojb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Out of Asher his lechem shall be rich, and he shall yield royal dainties. ");
INSERT INTO engojb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a doe let loose; he giveth goodly sayings. ");
INSERT INTO engojb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosef is a ben of a fruit-tree, even ben of a fruit-tree near an ayin (spring, well); its daughters (i.e., branches) run over the wall; ");
INSERT INTO engojb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The ba'alei khitzim (archers) provoke him, and shoot at him, and hate him; ");
INSERT INTO engojb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But his keshet (bow) remained steady, and the arms of his hands remain strong, from the hands of the Avir Ya'akov, from there, from the Ro'eh, Even Yisroel; ");
INSERT INTO engojb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","And from El Avicha, who shall help thee; and Shaddai, who shall make brocha over thee with Birkat Shomayim above, Birkat Tehom that lieth beneath, Birkat Shadayim and of Rekhem. ");
INSERT INTO engojb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Birkat Avicha surpass the Birkat of my progenitors unto the utmost border of the giveot olam (everlasting hills); they shall come on the rosh Yosef, and on the brow of the Prince among his achim. ");
INSERT INTO engojb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Binyamin — a ze'ev (wolf) which tears in pieces; in the boker he shall devour the prey, and at erev he shall divide the plunder. ");
INSERT INTO engojb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","All these are the Shivtei Yisroel; and this is it that Avichem spoke unto them, and made a brocha on them; every one according to his berakhah he blessed them. ");
INSERT INTO engojb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","And he charged them, and said unto them, I am to be gathered unto my people; bury me with Avotai in the me'arah (cave) that is in the sadeh of Ephron the Chitti, ");
INSERT INTO engojb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","In the me'arah that is in the sadeh of Machpelah, which is near Mamre, in Eretz Kena'an, which Avraham bought with the sadeh of Ephron the Chitti for an achuzzat kever (burial estate). ");
INSERT INTO engojb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There they buried Avraham and Sarah his isha; there they buried Yitzchak and Rivkah his isha; and there I buried Leah. ");
INSERT INTO engojb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The purchase of the sadeh and of the me'arah (cave) that is therein was from the Bnei Chet (Heth). ");
INSERT INTO engojb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","And when Ya'akov had made an end of commanding his banim, he gathered up his raglayim into the mittah, and expired, and was gathered unto his people. ");
INSERT INTO engojb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","And Yosef fell upon the face of Aviv, and wept over him, and kissed him. ");
INSERT INTO engojb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","And Yosef commanded his avadim the rofe'im (physicians) to embalm Aviv; and the rofe'im embalmed Yisroel. ");
INSERT INTO engojb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","And arba'im yom were fulfilled for him; for so are fulfilled the days of those which are embalmed; and the Mitzrayim mourned for him shivim yom (seventy days). ");
INSERT INTO engojb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","And when the days of his mourning were past, Yosef spoke unto the Bais Pharaoh, saying, If now I have found chen in your eyes, speak, now, in the oznayim of Pharaoh, saying, ");
INSERT INTO engojb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Avi made me swear, saying, Hinei, I die; in my kever which I dug for myself in Eretz Kena'an, there shalt thou bury me. Therefore let me go up, now, and bury Avi, and I will return. ");
INSERT INTO engojb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","And Pharaoh said, Go up, and bury Avicha, according as he made thee swear. ");
INSERT INTO engojb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","And Yosef went up to bury Aviv; and with him went up all the avadim of Pharaoh, the zekenim of his Bais, and all the zekenim of Eretz Mitzrayim, ");
INSERT INTO engojb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","And kol Bais Yosef, and his achim, and Bais Aviv; only their little ones, and their tzon, and their bakar (cattle), they left in Eretz Goshen. ");
INSERT INTO engojb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","And there went up with him both merkavot and parashim; and it was a very great machaneh. ");
INSERT INTO engojb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","And they came to the goren (threshing floor) of Atad, which is beyond the Yarden, and there they mourned with a gadol and very bitter lamentation; and he made evel (mourning) for Aviv shivat yamim. ");
INSERT INTO engojb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","And when the inhabitants of HaAretz, the Kena'ani, saw the evel (mourning) in the goren Atad, they said, This is a grievous evel to the Mitzrayim; therefore the shem of it was called Avel-Mitzrayim. It is beyond the Yarden. ");
INSERT INTO engojb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","And his Ya'akovʼs banim did unto him according as he commanded them; ");
INSERT INTO engojb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","For his banim carried him into Eretz Kena'an, and buried him in the me'arah (cave) of the sadeh of Machpelah, near Mamre, the sadeh which Avraham had bought for an achuzzat kever (burial estate) and made the purchase from Ephron the Chitti. ");
INSERT INTO engojb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","And, after burying Aviv, Yosef returned into Mitzrayim, he, and his achim, and all that went up with him to bury Aviv. ");
INSERT INTO engojb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","And when the Achei Yosef (the brothers of Yosef) saw that Avihem was dead, they said, What if Yosef will hate us, and will certainly requite us all the ra'ah which we did unto him. ");
INSERT INTO engojb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","And they sent word unto Yosef, saying, Avicha did command before he died, saying, ");
INSERT INTO engojb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","So shall ye say unto Yosef, Forgive, now, the peysha of thy achim, and their chattat; for they did unto thee ra'ah; and now, forgive the peysha of the Avdei Elohei Avicha. And Yosef wept when they spoke unto him. ");
INSERT INTO engojb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","And his achim also went and fell down before him; and they said, Behold us, we are thy avadim. ");
INSERT INTO engojb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","And Yosef said unto them, Fear not; for am I in the place of Elohim? ");
INSERT INTO engojb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","But as for you, ye intended ra'ah against me; but Elohim intended it for tovah, to bring to pass, as it is this day, to save Am Rav (much people) alive. ");
INSERT INTO engojb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Now therefore fear ye not; I will provide for you, and your little ones. And he comforted them, and spoke kindly unto their hearts. ");
INSERT INTO engojb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","And Yosef dwelt in Mitzrayim, he, and Bais Aviv; and Yosef lived one hundred and ten shanim. ");
INSERT INTO engojb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","And Yosef saw Ephrayimʼs bnei shileshim (children to the third generation); also the Bnei Machir Ben Menasheh were brought up upon the birkei Yosef (knees of Yosef). ");
INSERT INTO engojb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","And Yosef said unto his achim, I die; and Elohim will surely visit you, and bring you out of this land unto HaAretz which He promised by oath to Avraham, to Yitzchak, and to Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","And Yosef made the Bnei Yisroel take an oath, saying, Elohim will surely visit you, and ye shall carry up my atzmot from hence. ");
INSERT INTO engojb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Yosef died, being in age one hundred and ten shanim; and they embalmed him, and he was placed in an aron in Mitzrayim.");
INSERT INTO engojb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Now these are the Shemot Bnei Yisroel, which came into Mitzrayim; every ish and his bais came with Ya'akov: ");
INSERT INTO engojb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuven, Shim'on, Levi, and Yehudah, ");
INSERT INTO engojb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yissakhar, Zevulun, and Binyamin, ");
INSERT INTO engojb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, and Naphtali, Gad, and Asher. ");
INSERT INTO engojb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","And all the nefesh that came out of the loins of Ya'akov were seventy nefesh; for Yosef was in Mitzrayim already. ");
INSERT INTO engojb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","And Yosef died, and all his achim, and all that generation. ");
INSERT INTO engojb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","And the Bnei Yisroel were fruitful, and increased abundantly, and multiplied, and became exceeding strong; and the land was filled with them. ");
INSERT INTO engojb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Now there arose a melech chadash over Mitzrayim, which had no da'as of Yosef. ");
INSERT INTO engojb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","And he said unto his people, Hinei, the Am Bnei Yisroel are more and stronger than we. ");
INSERT INTO engojb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let us outsmart them; lest they multiply, and it come to pass, that, when there falleth out any milchamah, they join also unto our enemies, and fight against us, and so get them up out of the land. ");
INSERT INTO engojb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Therefore they did set over them sarei missim (taskmasters) to afflict them with their burdens. And they built for Pharaoh supply cities, Pitom and Ra'meses. ");
INSERT INTO engojb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more they afflicted them, the more they multiplied and spread out. And they were in dread because of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","And the Egyptians made the Bnei Yisroel to serve with rigor; ");
INSERT INTO engojb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","And they made their lives bitter with avodah kashah (hard bondage), in mortar, and in brick, and in all manner of avodah in the sadeh; all their service, wherein they made them serve, was with rigor. ");
INSERT INTO engojb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","And Melech Mitzrayim spoke to the meyalledot HaIvriyyot (Hebrew midwives), of which the shem of the one was Shiphrah, and of the other Puah; ");
INSERT INTO engojb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","And he said, When ye do the office of a midwife to HaIvriyyot (the Hebrew women) and see them upon the delivery stool; if it be a ben, then ye shall kill him; but if it be a bat, then she shall live. ");
INSERT INTO engojb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the meyalledot feared HaElohim, and did not as Melech Mitzrayim commanded them, but saved the yeladim alive. ");
INSERT INTO engojb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","So Melech Mitzrayim called for the meyalledot, and said unto them, Why have ye done this thing, and have saved the yeladim alive? ");
INSERT INTO engojb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","And the meyalledot said unto Pharaoh, Because HaIvriyyot are not as the Egyptian women; for they are vigorous, and are delivered before the meyalledot come in unto them. ");
INSERT INTO engojb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Therefore Elohim dealt well with the meyalledot; and the people multiplied, and grew very strong. ");
INSERT INTO engojb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","And it came to pass, because the meyalledot feared HaElohim, that He established them batim. ");
INSERT INTO engojb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","And Pharaoh charged all his people, saying, Every ben that is born ye shall cast into the Nile, and every bat ye shall save alive. ");
INSERT INTO engojb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","And there went an ish of the Bais Levi, and took to wife a bat Levi. ");
INSERT INTO engojb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","And the isha conceived, and bore a ben; and when she saw him that he was tov, she hid him three months. ");
INSERT INTO engojb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","And when she could no longer hide him, she took for him a tevah (ark) of papyrus, and daubed it with tar and with pitch, and put the yeled therein; and she set it in the reeds by the bank of the Nile. ");
INSERT INTO engojb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","And his achot stood afar off, to see what would be done to him. ");
INSERT INTO engojb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","And the Bat Pharaoh came down to bathe herself at the Nile; and her na'arot walked along by the Nileʼs bank; and when she saw the tevah (ark) among the reeds, she sent her amah (maid servant) to fetch it. ");
INSERT INTO engojb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","And when she had opened it, she saw the yeled; and, hinei, the na'ar was crying. And she had compassion on him, and said, This one is of the yaldei HaIvrim (Hebrew children). ");
INSERT INTO engojb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then said his achot to Bat Pharaoh, Shall I go and call to thee a nurse of HaIvriyyot, that she may nurse the yeled for thee? ");
INSERT INTO engojb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","And Bat Pharaoh said to her, Go. And haalmah went and called the em hayeled. ");
INSERT INTO engojb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","And Bat Pharaoh said unto her, Take this yeled away, and nurse it for me, and I will give thee thy wages. And the isha took the yeled, and nursed it. ");
INSERT INTO engojb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","And the yeled grew, and she brought him unto Bat Pharaoh, and he became her ben. And she called shmo Moshe: and she said, Because meshitihu (I drew him) out of the mayim. ");
INSERT INTO engojb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","And it came to pass in those days, when Moshe was grown, that he went out unto his achim, and looked on their sevalot: and he spied an Egyptian striking an ish Ivri, one of his achim. ");
INSERT INTO engojb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","And he looked this way and that way, and when he saw that there was no ish, he killed the Egyptian, and hid him in the chol (sand). ");
INSERT INTO engojb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","And when he went out the second day, hinei, two anashim Ivrim were fighting; he said to him in the wrong, Why strike thou thy re'a? ");
INSERT INTO engojb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","And he said, Who made thee a sar and a shofet over us? Intendest thou to kill me, as thou killedst the Egyptian? And Moshe feared, and thought, Surely this thing is known. ");
INSERT INTO engojb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Now when Pharaoh heard this thing, he sought to slay Moshe. But Moshe fled from the face of Pharaoh, and dwelt in Eretz Midyan; and he sat down by a well. ");
INSERT INTO engojb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now the kohen of Midyan had sheva banot; and they came and drew mayim, and filled the troughs to water the tzon of their av. ");
INSERT INTO engojb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","And the ro'im (shepherds) came and drove them away; but Moshe stood up and rescued them, and watered their tzon. ");
INSERT INTO engojb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","And when they came to Reuel their av, he said, How is it that ye are come so soon today? ");
INSERT INTO engojb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","And they said, An Egyptian delivered us out of the yad of the ro'im (shepherds), and also drew enough for us, and watered the tzon. ");
INSERT INTO engojb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","And he said unto his banot, And where is he? Why is it that ye have left the ish? Call him, that he may eat lechem. ");
INSERT INTO engojb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","And Moshe was content to dwell with the ish; and he gave Moshe Tzipporah his bat. ");
INSERT INTO engojb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","And she bore him a ben, and he called shmo Gershom; for he said, I have been a ger in a foreign land. ");
INSERT INTO engojb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","And it came to pass in process of time, that Melech Mitzrayim died; and the Bnei Yisroel groaned by reason of haAvodah (the Bondage), and they cried out, and their cry came up unto HaElohim by reason of haAvodah. ");
INSERT INTO engojb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","And Elohim heard their groaning, and Elohim remembered His brit (covenant) with Avraham, with Yitzchak, and with Ya'akov. ");
INSERT INTO engojb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","And Elohim looked upon the Bnei Yisroel, and Elohim had da'as of them. ");
INSERT INTO engojb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Now Moshe was ro'eh (shepherding) the tzon of Yitro his khoten (father-in-law), the kohen Midyan; and he led the tzon to the backside of the midbar, and came to the Har HaElohim, even to Chorev. ");
INSERT INTO engojb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","And the Malach Hashem appeared unto him in a flame of eish out of the midst of a bush; and he looked, and, hinei, the bush burned with eish, and the bush was not consumed. ");
INSERT INTO engojb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","And Moshe thought, I will now turn aside, and see this mareh hagadol, why the bush is not burned up. ");
INSERT INTO engojb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","And when Hashem saw that he turned aside to see, Elohim called out unto him out of the midst of the bush, and said, Moshe, Moshe. And he said, Hineni. ");
INSERT INTO engojb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","And He said, Draw not nearer here; put off thy na'alayim (sandals) from off thy raglayim, for hamakom whereon thou standest is admat kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Moreover He said, I am Elohei Avicha, Elohei Avraham, Elohei Yitzchak, and Elohei Ya'akov. And Moshe hid his face; for he was afraid to look upon HaElohim. ");
INSERT INTO engojb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","And Hashem said, I have surely seen the oni ami (affliction of My people) which are in Mitzrayim, and have heard their cry by reason of their nogesim (taskmasters); for I know their makhovim (sufferings); ");
INSERT INTO engojb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","And I am come down to deliver them out of the yad Mitzrayim, and to bring them up out of that land unto an eretz tovah, a spacious eretz zavat cholov udevash; unto the place of the Kena'ani, and the Chitti, and the Emori, and the Perizzi, and the Chivi, and the Yevusi. ");
INSERT INTO engojb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Now therefore, hinei, the cry of the Bnei Yisroel is come unto Me; and I have also seen the oppression wherewith the Egyptians oppress them. ");
INSERT INTO engojb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Come now therefore, and I will send thee unto Pharaoh, that thou mayest bring forth My people the Bnei Yisroel out of Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","And Moshe said unto HaElohim, Who am I, that I should go unto Pharaoh, and that I should bring forth the Bnei Yisroel out of Mitzrayim? ");
INSERT INTO engojb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","And He said, Certainly Eh-heh-yeh (I will be)  with thee; and this shall be haOt (the Sign) unto thee, that I have sent thee: when thou hast brought forth HaAm out of Mitzrayim, ye shall serve HaElohim upon this Har. ");
INSERT INTO engojb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","And Moshe said unto HaElohim, Hinei, when I come unto the Bnei Yisroel, and shall say unto them, Elohei Avoteichem hath sent me unto you; and they shall say to me, What is Shmo? what shall I say unto them? ");
INSERT INTO engojb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","And Elohim said unto Moshe, Eh-heh-yeh ashair Eh-heh-yeh (I AM WHO I AM); and He said, Thus shalt thou say unto the Bnei Yisroel, EH-HEH-YEH (I AM) hath sent me unto you. ");
INSERT INTO engojb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","And Elohim said moreover unto Moshe, Thus shalt thou say unto Bnei Yisroel: Hashem, Elohei Avoteichem, Elohei Avraham, Elohei Yitzchak, and Elohei Ya'akov, hath sent me unto you: this is Shemi l'olam, and this is My remembrance unto all generations. ");
INSERT INTO engojb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go, and gather the Ziknei Yisroel together, and say unto them, Hashem Elohei Avoteichem, Elohei Avraham, Yitzchak, and Ya'akov, appeared unto me, saying, I have surely visited/inspected you, and seen that which is done to you in Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","And I have said, I will bring you up out of the Oni Mitzrayim unto the eretz Kena'ani, and the Chitti, and the Emori, and the Perizzi, and the Chivi, and the Yevusi unto eretz zavat cholov udevash. ");
INSERT INTO engojb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","And they shall pay heed to thy voice; and thou shalt go, thou and the Ziknei Yisroel, unto Melech Mitzrayim, and ye shall say unto him, Hashem Elohei HaIvriyim hath met with us; and let us go, now, derech shloshet yamim into the midbar, that we may sacrifice to Hashem Eloheinu. ");
INSERT INTO engojb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","And I have da'as that Melech Mitzrayim will not let you go, no, except by a yad chazakah. ");
INSERT INTO engojb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","And I will stretch out My yad, and strike Mitzrayim with all My nifle'ot which I will do in the midst thereof; and after that he will let you go. ");
INSERT INTO engojb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","And I will give this people chen in the sight of the Egyptians; and it shall come to pass, that, when ye go, ye shall not go empty-handed. ");
INSERT INTO engojb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","But every isha shall borrow of her neighbor, and of her that sojourneth in her bais, jewels of kesef, and jewels of zahav, and clothing; and ye shall put them upon your banim, and upon your banot; so ye shall plunder the Egyptians. ");
INSERT INTO engojb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","And Moshe answered and said, But, what if they will not believe me, nor pay heed unto my voice but will say, Hashem hath not appeared unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","And Hashem said unto him, What is that in thine yad? And he said, A matteh (a rod, staff). ");
INSERT INTO engojb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","And He said, Cast it on the ground. And he cast it on the ground, and it became a nachash; and Moshe fled from before it. ");
INSERT INTO engojb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","And Hashem said unto Moshe, Put forth thine yad, and take it by the tail. And he put forth his yad, and caught it, and it became a matteh in his yad; ");
INSERT INTO engojb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","That they may believe that Hashem Elohei Avotam, Elohei Avraham, Elohei Yitzchak, and Elohei Ya'akov, hath appeared unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","And Hashem said furthermore unto him, Put now thine yad into thy kheyk. And he put his yad into his kheyk; and when he took it out, hinei, his yad was leprous as snow. ");
INSERT INTO engojb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","And He said, Put thine yad into thy kheyk again. And he put his yad into his kheyk again; and plucked it out of his kheyk, and, hinei, it was turned again as his other basar. ");
INSERT INTO engojb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","And it shall come to pass, if they will not believe thee, neither pay heed to the voice of haOt Harishon, that they will believe the voice of haOt haAcharon. ");
INSERT INTO engojb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","And it shall come to pass, if they will not believe also these two otot, neither pay heed unto thy voice, that thou shalt take of the mayim of the Nile, and pour it upon the yabashah (dry land); and the mayim which thou takest out of the Nile shall become dahm upon the yabashah. ");
INSERT INTO engojb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","And Moshe said unto Hashem, O Adonoi, I am not an ish devarim, neither heretofore, nor since Thou hast spoken unto Thy eved; but I am slow of speech, and of a slow lashon. ");
INSERT INTO engojb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","And Hashem said unto him, Who hath made manʼs peh (mouth)? Or who maketh dumb, or deaf, or seeing, or blind? Is it not I, Hashem? ");
INSERT INTO engojb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Now therefore go, and Eh-heh-yeh (I will be) with thy mouth, and teach thee what thou shalt say. ");
INSERT INTO engojb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","And he said, O Adonoi, send, now, by the yad of him whom Thou wilt send. ");
INSERT INTO engojb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","And the Af Hashem was kindled against Moshe, and He said, Is there not Aharon thy ach the Levi? I know that he can speak well. And also, hinei, he cometh forth to meet thee; and when he seeth thee, he will be glad in his lev. ");
INSERT INTO engojb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","And thou shalt speak unto him, and put words in his mouth; and Eh-heh-yeh (I will be) with thy mouth, and with his mouth, and will teach you what ye shall do. ");
INSERT INTO engojb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","And he shall be thy spokesman unto the people; and he shall be, even he shall be to thee instead of a mouth, and thou shalt be to him instead of Elohim. ");
INSERT INTO engojb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","And thou shalt take this matteh in thine yad, wherewith thou shalt do haOtot. ");
INSERT INTO engojb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","And Moshe went and returned to Yitro his khoten (father-in-law), and said unto him, Let me go, now, and return unto my achim which are in Mitzrayim, and see whether they be yet alive. And Yitro said to Moshe, Lech l'shalom (go in peace). ");
INSERT INTO engojb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","And Hashem said unto Moshe in Midyan, Go, shuv (return) into Mitzrayim; for all the anashim are dead which sought thy life. ");
INSERT INTO engojb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","And Moshe took his isha and his banim, and set them upon a donkey, and he returned to Eretz Mitzrayim; and matteh HaElohim in his yad. ");
INSERT INTO engojb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","And Hashem said unto Moshe, When thou goest to return into Mitzrayim, see that thou do all those mofetim before Pharaoh, which I have put in thine yad: but I will harden his lev, that he shall not let HaAm go. ");
INSERT INTO engojb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","And thou shalt say unto Pharaoh, Thus saith Hashem, Yisroel is beni (My son), even My bechor (first-born): ");
INSERT INTO engojb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","And I say unto thee, Let beni (My son) go, that he may serve Me: and if thou refuse to let him go, hinei, I will slay thy ben, even thy bechor. ");
INSERT INTO engojb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","And it came to pass on the derech at the malon, that Hashem met him, and sought to kill him. ");
INSERT INTO engojb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Then Tzipporah took a sharp stone, and cut off the orlat ben (foreskin of son) of her, and cast it at his feet, and said, Surely a choson damim (a bridegroom of blood) art thou to me. ");
INSERT INTO engojb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So He let him go; then she said, A choson damim thou art, because of the circumcision. ");
INSERT INTO engojb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","And Hashem said to Aharon, Go into the midbar to meet Moshe. And he went, and met him in the Har HaElohim, and kissed him. ");
INSERT INTO engojb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","And Moshe told Aharon kol divrei Hashem who had sent him, and all haOtot He had commanded him. ");
INSERT INTO engojb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","And Moshe and Aharon went and assembled together kol Ziknei Bnei Yisroel; ");
INSERT INTO engojb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","And Aharon spoke all hadevarim which Hashem had spoken unto Moshe; and he did haOtot before the eyes of HaAm. ");
INSERT INTO engojb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","And HaAm believed; and when they heard that Hashem had visited the Bnei Yisroel, and that He had looked upon their oni, then they bowed their heads and worshiped. ");
INSERT INTO engojb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","And afterward Moshe and Aharon went in, and told Pharaoh, Thus saith Hashem Elohei Yisroel, Let My people go, that they may hold a chag (feast) unto Me in the midbar. ");
INSERT INTO engojb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","And Pharaoh said, Who is Hashem, that I should obey His voice to let Yisroel go? I know not Hashem, neither will I let Yisroel go. ");
INSERT INTO engojb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","And they said, Elohei HaIvrim hath met with us; let us go, now, derech shloshet yamim into the midbar, and sacrifice unto Hashem Eloheinu; lest He fall upon us with dever (cattle disease), or with the cherev. ");
INSERT INTO engojb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","And Melech Mitzrayim said unto them, Why do ye, Moshe and Aharon, disturb the people from their works? Get you back unto your own sevalot (burdens). ");
INSERT INTO engojb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","And Pharaoh said, Hinei, the Am HaAretz now are many, and ye make them rest from their sevalot. ");
INSERT INTO engojb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","And Pharaoh commanded the same day the nogesim of the people, and their foremen, saying, ");
INSERT INTO engojb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Ye shall no more give HaAm straw to make brick, as heretofore; let them go and gather straw for themselves. ");
INSERT INTO engojb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","And the matkonet (quota) of the bricks, which they did make heretofore, ye shall lay upon them; ye shall not diminish ought thereof; for they are idle; therefore they cry out, saying, Let us go and sacrifice to Eloheinu. ");
INSERT INTO engojb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Let there more avodah be laid upon the anashim, that they may labor therein; and let them not regard divrei sheker. ");
INSERT INTO engojb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","And the nogesim of HaAm went out, and their foremen; they spoke to HaAm, saying, Thus saith Pharaoh, I will not give you straw. ");
INSERT INTO engojb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go ye, get you straw where ye can find it; yet not ought of your avodah shall be diminished. ");
INSERT INTO engojb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So HaAm were scattered abroad throughout kol Eretz Mitzrayim to gather stubble instead of straw. ");
INSERT INTO engojb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","And the nogesim pressed them, saying, Fulfil your ma'asim, your daily tasks, as when there was straw. ");
INSERT INTO engojb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","And the foremen of the Bnei Yisroel, which Pharaohʼs nogesim had set over them, were beaten, and were asked, Why have ye not fulfilled your task in making brick both yesterday and today, as heretofore? ");
INSERT INTO engojb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Then the foremen of the Bnei Yisroel came and cried unto Pharaoh, saying, Why dealest thou thus with thy avadim? ");
INSERT INTO engojb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","There is no straw given unto thy avadim, and they say to us, Make brick. And, hinei, thy avadim are beaten; but the fault is in thine own people. ");
INSERT INTO engojb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But he said, Ye are idle, ye are idle: therefore ye say, Let us go and do sacrifice to Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Go therefore now, and work; for there shall no straw be given you, yet shall ye deliver the tokhen (full measure) of bricks. ");
INSERT INTO engojb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","And the foremen of the Bnei Yisroel did see that they were in rah (trouble), after it was said, Ye shall not reduce ought from your bricks of your daily task. ");
INSERT INTO engojb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","And they went to meet Moshe and Aharon, who stood waiting to meet them, as they came forth from Pharaoh: ");
INSERT INTO engojb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","And they said unto them, Hashem look upon you, and judge; because ye have made us stench to be abhorred in the eyes of Pharaoh, and in the eyes of his avadim, to put a cherev in their yad to slay us. ");
INSERT INTO engojb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","And Moshe returned unto Hashem, and said, Adonoi, why hast Thou brought evil upon this people? why is it that Thou hast sent me? ");
INSERT INTO engojb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","For since I came to Pharaoh to speak in Thy Shem, he hath done evil to this people; neither hast Thou delivered Thy people at all. ");
INSERT INTO engojb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Then Hashem said unto Moshe, Now shalt thou see what I will do to Pharaoh; for through a yad chazakah shall he let them go, and with a yad chazakah shall he drive them out of his land. ");
INSERT INTO engojb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","And Elohim spoke unto Moshe, and said unto him, I am Hashem; ");
INSERT INTO engojb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","And I appeared unto Avraham, unto Yitzchak, and unto Ya'akov, as El Shaddai, but by My Shem Hashem I did not make Myself known to them. ");
INSERT INTO engojb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","And I have also established My brit (covenant) with them, to give them Eretz Kena'an, the land of their sojourning, wherein they sojourned. ");
INSERT INTO engojb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","And I have also heard the groaning of the Bnei Yisroel, whom the Egyptians keep in bondage; and I have remembered My brit (covenant). ");
INSERT INTO engojb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore say unto the Bnei Yisroel, I am Hashem, and I will bring you out from under the sivlot Mitzrayim, and I will free you out of their bondage, and I will redeem you with a stretched out zero'a, and with mishpatim gedolim: ");
INSERT INTO engojb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","And I will take you to Me for a people, and I will be to you Elohim; and ye shall know that I am Hashem Eloheichem, which bringeth you out from under the sivlot Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","And I will bring you in unto HaAretz, concerning the which I did lift up My hand to swear to give it to Avraham, to Yitzchak, and to Ya'akov; and I will give it to you for a morashah (heritage); I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","And Moshe spoke so unto the Bnei Yisroel; but they did not listen unto Moshe because of their kotzer ruach (shortness of spirit, broken spirit), and for avodah kesheh (cruel bondage). ");
INSERT INTO engojb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Go in, speak unto Pharaoh Melech Mitzrayim, that he let the Bnei Yisroel go out of his land. ");
INSERT INTO engojb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","And Moshe spoke before Hashem, saying, See, the Bnei Yisroel have not paid heed unto me; how then shall Pharaoh hear me, who am of oral sefatayim (uncircumcised lips, stumbling speech, sealed lips)? ");
INSERT INTO engojb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","And Hashem spoke unto Moshe and unto Aharon, and gave them a charge unto the Bnei Yisroel, and unto Pharaoh Melech Mitzrayim, to bring the Bnei Yisroel out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the Rashei Bais Avotam: The Bnei Reuven the bechor Yisroel; Chanokh, and Pallu, Chetzron, and Carmi: these are the mishpokhot of Reuven. ");
INSERT INTO engojb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","And the Bnei Shim'on; Yemuel, and Yamin, and Ohad, and Yachin, and Tzochar, and Sha'ul ben of HaKena'anit: these are the mishpokhot of Shim'on. ");
INSERT INTO engojb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","And these are the shemot Bnei Levi according to their toldot; Gershon, and Kohat, and Merari: and the years of the life of Levi were a hundred thirty and seven shanah. ");
INSERT INTO engojb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The Bnei Gershon; Livni, and Shime'i, according to their mishpokhot. ");
INSERT INTO engojb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","And the Bnei Kohat; Amram, and Yitzhar, and Chevron, and Uzziel: and the years of the life of Kehat were a hundred thirty and three shanah. ");
INSERT INTO engojb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","And the Bnei Merari; Machli and Mushi: these are the mishpokhot of Levi according to their toledot. ");
INSERT INTO engojb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","And Amram took him Yocheved his fatherʼs sister to wife; and she bore him Aharon and Moshe: and the years of the life of Amram were a hundred and thirty and seven shanah. ");
INSERT INTO engojb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","And the Bnei Yitzhar; Korach, Nepheg, and Zichri. ");
INSERT INTO engojb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","And the Bnei Uzziel; Mishael, Eltzaphan, and Sitri. ");
INSERT INTO engojb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","And Aharon took him Elisheva, bat Amminadav, achot Nachshon, to wife; and she bore him Nadav, and Avihu, El'azar and Itamar. ");
INSERT INTO engojb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","And the Bnei Korach; Assir, and Elkanah, and Aviasaph: these are the mishpokhot of the Korchi. ");
INSERT INTO engojb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","And El'azar ben Aharon took him one of the banot Putiel to wife; and she bore him Pinchas: these are the Rashei Avot HaLevi'im according to their mishpokhot. ");
INSERT INTO engojb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","These are that Aharon and Moshe, to whom Hashem said, Bring out the Bnei Yisroel from Eretz Mitzrayim according to their tzve'os. ");
INSERT INTO engojb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","These are they which spoke to Pharaoh Melech Mitzrayim, to bring out the Bnei Yisroel from Mitzrayim: these are that Moshe and Aharon. ");
INSERT INTO engojb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","And it came to pass on the day when Hashem spoke unto Moshe in Eretz Mitzrayim, ");
INSERT INTO engojb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","That Hashem spoke unto Moshe, saying, I am Hashem: speak thou unto Pharaoh Melech Mitzrayim all that I say unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","And Moshe said before Hashem, See, I am of oral sefatayim, and why should Pharaoh pay heed unto me. ");
INSERT INTO engojb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","And Hashem said unto Moshe, See, I have made thee as Elohim to Pharaoh: and Aharon thy brother shall be thy navi. ");
INSERT INTO engojb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Thou shalt speak all that I command thee: and Aharon thy brother shall speak unto Pharaoh, that he send the Bnei Yisroel out of his land. ");
INSERT INTO engojb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","And I will harden the lev Pharaoh, and multiply My Otot and My Mofetim in Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But Pharaoh shall not pay heed unto you, that I may lay My yad upon Mitzrayim, and bring forth Mine tzve'os, and My people the Bnei Yisroel, out of Eretz Mitzrayim by shefatim gedolim (great judgments). ");
INSERT INTO engojb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","And the Egyptians shall know that I am Hashem, when I stretch forth My yad upon Mitzrayim, bringing out Bnei Yisroel from among them. ");
INSERT INTO engojb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","And Moshe and Aharon did as Hashem commanded them, so did they. ");
INSERT INTO engojb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","And Moshe was fourscore years old, and Aharon fourscore three years, when they spoke unto Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","And Hashem spoke unto Moshe and Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","When Pharaoh shall speak unto you, saying, Show a mofet (miracle) for you: then thou shalt say unto Aharon, Take thy matteh, and cast it before Pharaoh, and it shall become a serpent. ");
INSERT INTO engojb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","And Moshe and Aharon went in unto Pharaoh, and they did so as Hashem had commanded: and Aharon cast down his matteh before Pharaoh, and his avadim, and it became a serpent. ");
INSERT INTO engojb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then Pharaoh also called the chachamim and the mechashefim: now the charetumei Mitzrayim, they also did in like manner with their secret lore. ");
INSERT INTO engojb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","For they cast down every man his matteh, and they became serpents: but the matteh Aharon swallowed up their mattot. ");
INSERT INTO engojb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","And He hardened lev Pharaoh, that he paid heed not unto them; as Hashem had said. ");
INSERT INTO engojb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","And Hashem said unto Moshe, the lev Pharaoh is hardened, he refuseth to let the people go. ");
INSERT INTO engojb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Get thee unto Pharaoh in the boker; hinei, he goeth out unto the mayim; and thou shalt stand by the bank of the Nile to meet him; and the matteh which was turned to a nachash shalt thou take in thine yad. ");
INSERT INTO engojb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","And thou shalt say unto him, Hashem Elohei HaIvrim hath sent me unto thee, saying, Let My people go, that they may serve Me in the midbar: and, hinei, hitherto thou wouldest not hear. ");
INSERT INTO engojb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Thus saith Hashem, In this thou shalt know that I am Hashem: hinei, I will strike with the matteh that is in Mine yad upon the mayim which are in the Nile, and they shall be turned to dahm. ");
INSERT INTO engojb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","And the dag (fish) that is in the Nile shall die, and the Nile shall stink; and the Egyptians shall loathe to drink of the mayim of the Nile. ");
INSERT INTO engojb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","And Hashem spoke unto Moshe, Say unto Aharon, Take thy matteh, and stretch out thine yad upon the mayim of Mitzrayim, upon their streams, upon their rivers, and upon their ponds, and upon all their mikveh of mayim, that they may become dahm; and that there may be dahm throughout kol Eretz Mitzrayim, both in vessels of wood, and in vessels of stone. ");
INSERT INTO engojb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","And Moshe and Aharon did so, as Hashem commanded; and he lifted up the matteh, and smote the waters that were in the Nile, in the sight of Pharaoh, and in the sight of his avadim; and all the mayim that were in the Nile were turned to dahm. ");
INSERT INTO engojb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","And the dag (fish) that was in the Nile died; and the Nile stank, and the Egyptians could not drink of the mayim of the Nile; and there was dahm throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","And the charetumei Mitzrayim did so with their secret lore: and lev Pharaoh was hardened, neither did he pay heed unto them; as Hashem had said. ");
INSERT INTO engojb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","And Pharaoh turned and went into his bais, neither did he set his mind to this also. ");
INSERT INTO engojb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","And all the Egyptians dug around the Nile for mayim to drink; they could not drink of the mayim of the Nile. ");
INSERT INTO engojb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","And seven days came and went, after Hashem had struck the Nile. ");
INSERT INTO engojb_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","And Hashem spoke unto Moshe, Go unto Pharaoh, and say unto him, Thus saith Hashem, Let My people go, that they may serve Me. ");
INSERT INTO engojb_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","And if thou refuse to let them go, hinei, I will strike all thy borders with tzefardaya: ");
INSERT INTO engojb_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","And the river shall bring forth tzefardaya abundantly, which shall go up and come into thine bais, and into thy cheder mishkav, and upon thy bed, and into the bais of thy avadim, and upon thy people, and into thine ovens, and into thy kneading bowls: ");
INSERT INTO engojb_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","And the tzefardaya shall come up both on thee, and upon thy people, and upon all thy avadim. ");
INSERT INTO engojb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","And Hashem spoke unto Moshe, Say unto Aharon, Stretch forth thine yad with thy matteh over the streams, over the rivers, and ponds, and cause tzefardaya to come up upon Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","And Aharon stretched out his yad over the waters of Mitzrayim; and the tzefardaya came up, and covered Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","And the chartumim did so with their secret lore, and brought up tzefardaya upon Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Then Pharaoh called for Moshe and Aharon, and said, Entreat Hashem, that He may take away the tzefardaya from me, and from My people; and I will let HaAm go, that they may do sacrifice unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","And Moshe said unto Pharaoh, Please thyself over me: when shall I entreat for thee, and for thy avadim, and for thy people, to destroy the tzefardaya from thee and thy batim (houses), that they may remain in the Nile only? ");
INSERT INTO engojb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","And he said, Tomorrow. And he said, Be it according to thy word: that thou mayest know that there is none like unto Hashem Eloheinu. ");
INSERT INTO engojb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","And the tzefardaya shall depart from thee, from thy batim, from thy avadim, and from thy people; they shall remain in the Nile only. ");
INSERT INTO engojb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","And Moshe and Aharon went out from Pharaoh: and Moshe cried unto Hashem because of the tzefardaya which He had brought against Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","And Hashem did according to the word of Moshe; and the tzefardaya died out of the batim (houses), out of the khatzerot, and out of the sadot. ");
INSERT INTO engojb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","And they gathered them together upon heaps; and the land stank. ");
INSERT INTO engojb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","But when Pharaoh saw that there was respite, he hardened his lev, and paid heed not unto them; as Hashem had said. ");
INSERT INTO engojb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","And Hashem said unto Moshe, Say unto Aharon, Stretch out thy matteh, and smite the aphar ha'aretz, that it may become kinim throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And they did so; for Aharon stretched out his yad with his matteh, and smote the aphar ha'aretz, and it became kinim in adam, and in behemah; all the aphar ha'aretz became kinim throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","And the chartumim did so with their secret lore to bring forth kinim, but they could not: so there were kinim upon adam, and upon behemah. ");
INSERT INTO engojb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Then the chartumim said unto Pharaoh, This is the Etzba Elohim (Finger of G-d): and the lev Pharaoh was hardened, and he paid heed not unto them; as Hashem had said. ");
INSERT INTO engojb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","And Hashem said unto Moshe, Rise up early in the boker, and stand before Pharaoh; hinei, he cometh forth to the mayim; and say unto him, Thus saith Hashem, Let My people go, that they may serve Me. ");
INSERT INTO engojb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Else, if thou wilt not let My people go, hineni, I will send swarms of arov upon thee, and upon thy avadim, and upon thy people, and into thy batim (houses); and the batim (houses) of the Egyptians shall be full of swarms of arov, and also the ground whereon they are. ");
INSERT INTO engojb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","And I will deal differently in that day with Eretz Goshen, in which My people dwell, that no swarms of arov shall be there; to the end thou mayest know that I am Hashem in the midst of the earth. ");
INSERT INTO engojb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","And I will put a distinction between My people and thy people; tomorrow shall this Ot be. ");
INSERT INTO engojb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","And Hashem did so; there came a grievous swarm of arov into the bais Pharaoh, into batim of his avadim, into kol Eretz Mitzrayim; the land was corrupted from the swarm of arov. ");
INSERT INTO engojb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","And Pharaoh called for Moshe, for Aharon, and said, Go ye, sacrifice to Eloheichem in the land. ");
INSERT INTO engojb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","And Moshe said, It is not meet so to do; for we shall sacrifice the to'avot Egyptians to Hashem Eloheinu; lo, shall we sacrifice the to'avot Egyptians before their eyes, and will they not stone us? ");
INSERT INTO engojb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","We will go derech shloshet yamim into the midbar, and sacrifice to Hashem Eloheinu, as He shall command us. ");
INSERT INTO engojb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","And Pharaoh said, I will let you go, that ye may sacrifice to Hashem Eloheichem in the midbar; only ye shall not go very far away; entreat for me. ");
INSERT INTO engojb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","And Moshe said, Hinei, I go out from thee, and I will entreat Hashem that the swarms of arov may depart from Pharaoh, from his avadim, and from his people, tomorrow; but let not Pharaoh deal deceitfully anymore in not letting the people go to sacrifice to Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","And Moshe went out from Pharaoh, and entreated Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","And Hashem did according to the devar Moshe; and He removed the swarms of arov from Pharaoh, from his avadim, from his people; there remained not one. ");
INSERT INTO engojb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","And Pharaoh hardened his lev at this time also, neither would he let the people go. ");
INSERT INTO engojb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then Hashem said unto Moshe, Go in unto Pharaoh, tell him, Thus saith Hashem Elohei HaIvrim, Let My people go, that they may serve Me. ");
INSERT INTO engojb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","For if thou refuse to let them go, and wilt hold them still, ");
INSERT INTO engojb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Hinei, the Yad Hashem is upon thy mikneh (livestock) which is in the sadeh, upon the susim, upon the donkeys, upon the camels, upon the herd, and upon the tzon; there shall be a very grievous dever. ");
INSERT INTO engojb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","And Hashem shall separate between the mikneh Yisroel and the mikneh Mitzrayim; and there shall nothing die of all that belongs to the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","And Hashem appointed a mo'ed, saying, Tomorrow Hashem shall do this thing in the land. ");
INSERT INTO engojb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And Hashem did that thing on the next day, and all the mikneh of Mitzrayim died; but of the mikneh of the Bnei Yisroel died not one. ");
INSERT INTO engojb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","And Pharaoh sent, and, hinei, there was not one of the mikneh Yisroel dead. And the lev Pharaoh was hardened, and he did not let HaAm go. ");
INSERT INTO engojb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","And Hashem said unto Moshe and unto Aharon, Take to you handfuls of piach of the furnace, and let Moshe sprinkle it toward Shomayim in the sight of Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","And it shall become fine dust in kol Eretz Mitzrayim, and shall be a sh'khin (boil) breaking forth with festers upon adam, and upon behemah, throughout kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","And they took piach of the furnace, and stood before Pharaoh; and Moshe sprinkled it up toward Shomayim; and it became a sh'khin breaking forth with festers upon adam, and upon behemah. ");
INSERT INTO engojb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","And the charetumim could not stand before Moshe because of the sh'khin; for the sh'khin was upon the charetumim, and upon kol Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","And Hashem hardened the lev Pharaoh, and he paid heed not unto them; as Hashem had spoken unto Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","And Hashem said unto Moshe, Rise up early in the boker, and stand before Pharaoh, and say unto him, Thus saith Hashem Elohei HaIvrim, Let My people go, that they may serve Me. ");
INSERT INTO engojb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For I will at this time send all My maggefot upon thine lev, and upon thy avadim, and upon thy people; that thou mayest have da'as that there is none like Me in kol ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For now I will stretch out My Yad, that I may strike thee and thy people with dever; and thou shalt be cut off from ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","In fact for this cause have I raised thee up, for to show in thee My ko'ach; and that My Shem may be declared throughout kol ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Thou still are exalting thyself against My people, that thou wilt not let them go. ");
INSERT INTO engojb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Hinei, tomorrow about this time I will cause it to rain very grievous barad (hail), such as hath not been in Mitzrayim since the foundation thereof even until now. ");
INSERT INTO engojb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Send therefore now, and gather thy mikneh, and all that thou hast in the sadeh; for upon every adam (man) and behemah (beast) which shall be found in the sadeh, and shall not be brought into shelter, the barad shall come down upon them, and they shall die. ");
INSERT INTO engojb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","He that feared the Devar Hashem among the avadim of Pharaoh made his avadim and his mikneh flee into the shelters; ");
INSERT INTO engojb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","And he that took not to heart the Devar Hashem left his avadim and his mikneh in the sadeh. ");
INSERT INTO engojb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","And Hashem said unto Moshe, Stretch forth thine yad toward Shomayim, that there may be barad in kol Eretz Mitzrayim, upon adam, and upon behemah, and upon kol esev hasadeh, throughout Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","And Moshe stretched forth his matteh toward Shomayim; and Hashem sent thunder and barad, and the eish flashed down upon the ground; and Hashem rained barad upon Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","So there was barad, and eish mingled with the barad, very grievous, such as there was none like it in kol Eretz Mitzrayim since it became a nation. ");
INSERT INTO engojb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","And the barad struck throughout kol Eretz Mitzrayim all that was in the sadeh, both adam and behemah; the barad struck kol esev hasadeh, and beat down kol etz of the sadeh. ");
INSERT INTO engojb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in Eretz Goshen, where the Bnei Yisroel were, was there no barad. ");
INSERT INTO engojb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","And Pharaoh sent, and called for Moshe and Aharon, and said unto them, chatati (I have sinned) this time: Hashem HaTzaddik (is righteous), and I and my people are haresha'im (wicked, guilty, wrong). ");
INSERT INTO engojb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Entreat Hashem for it is enough, that there be no more Elohim thunderings and barad; and I will let you go, and ye shall stay no longer. ");
INSERT INTO engojb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","And Moshe said unto him, As soon as I am gone out of the Ir, I will spread out my palms unto Hashem; and the thunder shall cease, neither shall there be any more barad; that thou mayest have da'as that ha'aretz is Hashemʼs. ");
INSERT INTO engojb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for thee and thy avadim, I know that ye will not yet fear Hashem Elohim. ");
INSERT INTO engojb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","And the flax and the barley was struck; for the barley was ripe, and the flax was in bud. ");
INSERT INTO engojb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the wheat and the spelt were not struck; for they were not yet come up. ");
INSERT INTO engojb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","And Moshe went out of the Ir from Pharaoh, and spread out his palms unto Hashem; and the thunders and barad ceased, and the rain was not poured upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","And when Pharaoh saw that the rain and the barad and the thunders were ceased, he sinned yet more, and hardened his lev, he and his avadim. ");
INSERT INTO engojb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","And the lev Pharaoh was hardened, neither would he let the Bnei Yisroel go; as Hashem had spoken by Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","And Hashem said unto Moshe, Go in unto Pharaoh; for I have hardened his lev, and the lev of his avadim, that I might show these My otot before him; ");
INSERT INTO engojb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","And that thou mayest tell in the ears of thy ben, and of thy benʼs ben, what things I have wrought in Mitzrayim, and My otot which I have done among them; that ye may have da'as that I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","And Moshe and Aharon came in unto Pharaoh, and said unto him, Thus saith Hashem Elohei HaIvrim, How long wilt thou refuse to humble thyself before Me? Let My people go, that they may serve Me. ");
INSERT INTO engojb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Else, if thou refuse to let My people go, hineni, tomorrow will I bring the arbeh into thy border; ");
INSERT INTO engojb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","And they shall cover the face of ha'aretz, that one cannot be able to see ha'aretz; and they shall devour the remnant of that which is escaped, which remaineth unto you from the barad, and shall eat kol haetz which groweth for you out of the sadeh; ");
INSERT INTO engojb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","And they shall fill thy batim (houses), and the batim (houses) of all thy avadim, and the batim (houses) of kol Mitzrayim; which neither thy avot, nor the avot of thy avot have seen, since the day that they were upon ha'aretz unto this day. And he turned himself, and went out from Pharaoh. ");
INSERT INTO engojb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","And Pharaohʼs avadim said unto him, How long shall this man be a mokesh (snare) unto us? Let the anashim go, that they may serve Hashem Eloheihem; knowest thou not yet that Mitzrayim is destroyed? ");
INSERT INTO engojb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","And Moshe and Aharon were brought again unto Pharaoh; and he said unto them, Go, serve Hashem Eloheichem; but who are they that shall go? ");
INSERT INTO engojb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","And Moshe said, We will go with ne'areinu and with zekeineinu, with baneinu and with benoteinu, with tzoneinu and with bekareinu (our herds) will we go; for Chag Hashem lanu. ");
INSERT INTO engojb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","And he said unto them, Hashem will indeed be with you, if ever I let you go, and your little ones; look to it, evil intent is before you. ");
INSERT INTO engojb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Not so; go now ye that are gevarim, and serve Hashem; for that ye did request. And they were driven out from Pharaohʼs presence. ");
INSERT INTO engojb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","And Hashem said unto Moshe, Stretch out thine yad over Eretz Mitzrayim for the arbeh, that they may come up upon Eretz Mitzrayim, and devour kol esev ha'aretz, even all that the barad hath left as remnant. ");
INSERT INTO engojb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","And Moshe stretched forth his matteh over Eretz Mitzrayim, and Hashem brought a ruach kadim upon the land all that yom, and all that lailah; and when it was boker, the ruach hakadim brought the arbeh. ");
INSERT INTO engojb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","And the arbeh went up over kol Eretz Mitzrayim, and rested on the entire border of Mitzrayim: very grievous were they; before them there were no such arbeh as they, neither after them shall be such. ");
INSERT INTO engojb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","For they covered the kol ha'aretz, so that the land was darkened; and they did eat kol esev ha'aretz, and kol p'ri haetz which the barad had left as remnant; and there remained not any yerek baetz, or in the esev hasadeh, through kol Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Then Pharaoh called for Moshe and Aharon in haste; and he said, chatati (I have sinned) against Hashem Eloheichem, and against you. ");
INSERT INTO engojb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Therefore forgive, now, my sin only this once, and entreat Hashem Eloheichem, that He would only take away from me this mavet. ");
INSERT INTO engojb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","And he went out from Pharaoh, and entreated Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","And Hashem turned a west ruach chazak me'od, which took away the arbeh, and cast them into the Yam Suf; there remained not one arbeh in all the borders of Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But Hashem hardened lev Pharaoh, so that he would not let the Bnei Yisroel go. ");
INSERT INTO engojb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","And Hashem said unto Moshe, Stretch out thine yad toward Shomayim, that there may be choshech over Eretz Mitzrayim, even choshech which he can feel. ");
INSERT INTO engojb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","And Moshe stretched forth his yad toward Shomayim; and there was a thick choshech in kol Eretz Mitzrayim shloshet yamim; ");
INSERT INTO engojb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","They saw not one another, neither rose any from his place for shloshet yamim; but kol Bnei Yisroel had Ohr in their dwellings. ");
INSERT INTO engojb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","And Pharaoh called unto Moshe, and said, Go ye, serve Hashem; only let your tzon and your herds remain behind; let your little ones also go with you. ");
INSERT INTO engojb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","And Moshe said, Thou must give us also zevakhim and olot, that we may sacrifice unto Hashem Eloheinu. ");
INSERT INTO engojb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Also mikneinu shall go with us; there shall not a hoof be left behind; for thereof must we take to serve Hashem Eloheinu; and we know not with what we must serve Hashem, until we come to there. ");
INSERT INTO engojb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But Hashem hardened lev Pharaoh, and he would not let them go. ");
INSERT INTO engojb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","And Pharaoh said unto him, Get thee from me, take heed to thyself, see my face no more; for in that day thou seest my face thou shalt die. ");
INSERT INTO engojb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","And Moshe said, Thou hast spoken well, I will see thy face again no more. ");
INSERT INTO engojb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","And Hashem said unto Moshe, Yet will I bring one nega (plague; see Isa 53:8 regarding Moshiach) more upon Pharaoh, and upon Mitzrayim; afterwards he will let you go hence: when he shall let you go, he shall surely drive you out hence altogether. ");
INSERT INTO engojb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Speak now in the ears of HaAm, let every ish request of his neighbor, every isha of her neighbor, articles of kesef and articles of zahav. ");
INSERT INTO engojb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","And Hashem gave the people chen in the sight of the Egyptians. Moreover the ish Moshe was gadol me'od in Eretz Mitzrayim, in the sight of Pharaohʼs avadim, and in the sight of the people. ");
INSERT INTO engojb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","And Moshe said, Thus saith Hashem, About khatzot halailah (midnight) will I go out into the midst of Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","And all the bechor in Eretz Mitzrayim shall die, from the bechor Pharaoh that sitteth upon his kisse, even unto the bechor hashifchah that is behind the millstone; and all the bechor behemah. ");
INSERT INTO engojb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","And there shall be a great cry throughout kol Eretz Mitzrayim, such as there was none like it, nor shall be like it any more. ");
INSERT INTO engojb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But against any of the Bnei Yisroel shall not a kelev move his leshon, against ish or behemah; that ye may have da'as that Hashem doth differentiate between Mitzrayim and Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","And all these thy avadim shall come down unto me, and bow down themselves unto me, saying, Get thee out, and kol HaAm that follow thee; and after that I will go out. And he went out from Pharaoh in a great anger. ");
INSERT INTO engojb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","And Hashem said unto Moshe, Pharaoh shall not pay heed unto you; that My mofetim may be multiplied in Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","And Moshe and Aharon did all these mofetim before Pharaoh; and Hashem hardened lev Pharaoh, so that he would not let the Bnei Yisroel go out of his land. ");
INSERT INTO engojb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","And Hashem spoke unto Moshe and Aharon in Eretz Mitzrayim saying, ");
INSERT INTO engojb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Hachodesh hazeh (this month) shall be unto you the beginning of months; it shall be the first month of the year to you. ");
INSERT INTO engojb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Speak ye unto kol Adat Yisroel, saying, In the tenth day of this month they shall take to them every man a seh (lamb), according to the bais avot, a seh for each bais; ");
INSERT INTO engojb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","And if the household be too small for the seh (lamb), let him and his neighbor next unto his bais take according to the number of the nefashot; every ish according to what he eats shall make up your count for the seh. ");
INSERT INTO engojb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your seh (lamb)  shall be tamim (without blemish), a zachar (male) within its first year; ye shall take it out from the sheep, or from the goats; ");
INSERT INTO engojb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","And it will be with you for mishmeret (examination, checking for blemishes) up until the fourteenth day of the same month; and kol Kehal Adat Yisroel shall slaughter (shachat) it in the afternoon before dark. ");
INSERT INTO engojb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","And they shall take of the dahm, and strike it upon the two mezuzot (doorposts) and on the mashkof (lintel) of the batim (houses), wherein they shall eat it. ");
INSERT INTO engojb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","And they shall eat the basar in that night, roasted over eish, and matzot; and with maror they shall eat it. ");
INSERT INTO engojb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Eat not of it raw, nor soaked or boiled in mayim, but roasted over eish; this includes its rosh with its legs, and with the inner parts thereof. ");
INSERT INTO engojb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","And ye shall let nothing of it remain until the boker; and that which remaineth of it until the boker ye shall burn with eish. ");
INSERT INTO engojb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","And thus shall ye eat it; with your robe girded up, your sandals on your feet, and your walking staff in your yad; and ye shall eat it with urgent haste; it is Hashemʼs Pesach. ");
INSERT INTO engojb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","For I will pass through Eretz Mitzrayim balailah hazeh, and will strike fatally kol bechor Eretz Mitzrayim, both adam and behemah; and against all the elohei Mitzrayim I will execute judgment; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","And the dahm shall be for you, an ot (sign) upon the batim (houses) where ye are; and when I see the dahm, oofasachti (then I will pass over, skip, spare) you plural, and the negef (plague, blow, striking, i.e., death of firstborn) shall not be upon you to destroy you, when I strike fatally with a blow against Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","And hayom hazeh shall be unto you for zikaron (remembrance, remembering); and ye shall keep it a Chag (Feast) to Hashem throughout your generations; ye shall keep it a Chag (Feast) by a chukkat olam. ");
INSERT INTO engojb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Shivat yamim shall ye eat matzot; but the first day ye shall put away se'or (yeast, leaven) out of your batim (houses); for whosoever eateth chametz from the first day until the seventh day, that nefesh shall be cut off from Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","And in the yom harishon there shall be a mikra kodesh, and in the yom hashevi'i there shall be a mikra kodesh to you; no manner of melachah shall be done in them, except that which every nefesh must eat, that only may be done of you. ");
INSERT INTO engojb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","And ye shall be shomer to safeguard the matzot; for on this very day I brought your tzva'os out of Eretz Mitzrayim; therefore shall ye be shomer over this day in your generations by a chukkat olam. ");
INSERT INTO engojb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month, on the fourteenth day of the month at erev, ye shall eat matzot, until the one and twentieth day of the month at erev. ");
INSERT INTO engojb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Shivat yamim shall there be no se'or (yeast, leaven) found in your batim (houses); whosoever eateth that which is leavened, even that nefesh shall be cut off from Adat Yisroel, whether he be a ger, or native born in ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ye shall eat nothing leavened; in all your dwelling-places shall ye eat matzot. ");
INSERT INTO engojb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moshe called for all the Ziknei Yisroel, and said unto them, Draw out as separate and take for yourselves a lamb according to your mishpokhot, and slaughter (shachat) the Pesach. ");
INSERT INTO engojb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","And ye shall take a bunch of hyssop, and dip it in the dahm that is in the basin, and strike the mashkof (lintel) and the two mezuzot (door sideposts) with the dahm that is in the basin; and none of you shall go out the door of his bais until boker. ");
INSERT INTO engojb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For Hashem will pass through to strike the Mitzrayim; and when He seeth the dahm upon the mashkof, and on the two mezuzot, Hashem will pasach (pass over, spare, skip) the entrance, and will not permit the Mashkhit (Destroyer), to enter unto your batim to strike. ");
INSERT INTO engojb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","And ye shall be shomer over this word as a chok (ordinance) to thee and your children ad olam (forever). ");
INSERT INTO engojb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","And it shall come to pass, when ye come to ha'aretz which Hashem will give to you, according as He hath promised, that ye shall be shomer over this avodah. ");
INSERT INTO engojb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","And it shall come to pass, when your banim shall say unto you, Mah haavodah hazot lachem (What is this avodah to you)? ");
INSERT INTO engojb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","That ye shall say, It is the zevach of Hashemʼs Pesach, who pasach (passed over, skipped, spared) the batim (households) of the Bnei Yisroel in Mitzrayim, when He struck down the Egyptians, and spared bateinu (our houses). And the people bowed down and worshiped. ");
INSERT INTO engojb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","And the Bnei Yisroel went away, and did as Hashem had commanded Moshe and Aharon, so did they. ");
INSERT INTO engojb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","And it came to pass, that at midnight Hashem struck down kol bechor in Eretz Mitzrayim, from the bechor of Pharaoh sitting on his throne unto the bechor of the captive that was in the dungeon; and all the bechor behemah. ");
INSERT INTO engojb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","And Pharaoh rose up in the lailah, he, and all his avadim, and kol Mitzrayim; and there was a tze'akah gedolah (great wail) in Mitzrayim; for there was not a bais where there was not one dead. ");
INSERT INTO engojb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","And he called for Moshe and Aharon by night, and said, Rise up, and get you forth, leave from among my people, both ye and the Bnei Yisroel; and go, serve Hashem, as ye have said. ");
INSERT INTO engojb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Also take your tzon and your herds, as ye have said, and be gone; and bless me also. ");
INSERT INTO engojb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","And the Egyptians were urgent upon the people, that they might send them out of ha'aretz in haste; for they said, Kullanu mesim (We are all dead ones). ");
INSERT INTO engojb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","And the people took their batzek (deaf dough, having no indication of fermentation)  before it was leavened, their kneading pans being wrapped up in their clothes and carried upon their shoulders. ");
INSERT INTO engojb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","And the Bnei Yisroel did according to the devar Moshe; they requested of the Egyptians k'lei kesef, and k'lei zahav, and garments; ");
INSERT INTO engojb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","And Hashem gave the people favor in the sight of the Mitzrayim, so that they granted their request. So they plundered the Egyptians. ");
INSERT INTO engojb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","And the Bnei Yisroel journeyed from Ra'meses towards Sukkot, about 600,000 gevarim on foot, not counting women and children. ");
INSERT INTO engojb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","And an erev rav (mixed multitude, a mixed company that was large) went along also with them; and tzon, and herds, even very many domestic animals. ");
INSERT INTO engojb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","And they baked the batzek (deaf dough) which they brought forth out of Mitzrayim, into round flat cakes of matzot; ki lo chametz, because they were thrust out of Mitzrayim, and could not tarry (linger), neither had they prepared for tzeidah (supply of food, provision). ");
INSERT INTO engojb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Now the moshav (time period of residence) of the Bnei Yisroel dwelling in Mitzrayim was four hundred and thirty shanah. ");
INSERT INTO engojb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","And it came to pass at the ketz (end) of the four hundred and thirty shanah, even the exact day it came to pass, that kol Tzivos Hashem went out from Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It is a night of shimmurim (keepings, watchings, vigils) for Hashem to keep watch to bring them out from Eretz Mitzrayim; this is halailah hazeh unto Hashem; shimmurim (watchings, vigils) for kol Bnei Yisroel in their dorot. ");
INSERT INTO engojb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","And Hashem said unto Moshe and Aharon, This is the Chukkat HaPesach: there shall no ben nekhar eat thereof; ");
INSERT INTO engojb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But every manʼs eved that is bought for kesef, when thou hast given him bris milah, then shall he eat thereof. ");
INSERT INTO engojb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A toshav and a sachir shall not eat thereof. ");
INSERT INTO engojb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","In bais echad shall it be eaten; thou shalt not carry forth any of the basar outside the bais; neither shall ye break a bone thereof. ");
INSERT INTO engojb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Kol Adat Yisroel shall celebrate it. ");
INSERT INTO engojb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","And when a ger shall sojourn with thee, and will keep the Pesach unto Hashem, let all his zachar receive bris milah, and then let him come near and keep it; and he shall be as one that is native born in ha'aretz; for no arel (uncircumcised person) shall eat thereof. ");
INSERT INTO engojb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Torah echad shall be to him that is native-born, and unto the ger that sojourneth among you. ");
INSERT INTO engojb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Thus did kol Bnei Yisroel; as Hashem commanded Moshe and Aharon, so did they. ");
INSERT INTO engojb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And it came to pass the very same day, that Hashem did bring the Bnei Yisroel out of Eretz Mitzrayim by their tzvaos. ");
INSERT INTO engojb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Set apart as kodesh unto Me kol bechor, whatsoever openeth the rechem (womb) among the Bnei Yisroel, both of adam and of behemah; it is Mine. ");
INSERT INTO engojb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","And Moshe said unto HaAm, Remember this day, in which ye came out from Mitzrayim, out of the bais avadim; for by chozek yad Hashem brought you out from this place; there shall no chametz be eaten. ");
INSERT INTO engojb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","This day came ye out in the month Aviv. ");
INSERT INTO engojb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","And it shall be when Hashem shall bring thee into the land of the Kena'ani, and the Chitti, and the Emori, and the Chivi, and the Yevusi, which He swore unto thy Avot to give thee, an eretz flowing with cholov and devash, that thou shalt observe this avodah (service) in this month. ");
INSERT INTO engojb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Shivat yamim thou shalt eat matzot, and in the seventh day shall be a Chag (Feast) to Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Matzot shall be eaten shivat hayamim; and there shall no chametz be seen with thee, neither shall there be se'or seen with thee within all thy borders. ");
INSERT INTO engojb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","And thou shalt show thy ben in that day, saying, This is because of what Hashem did for me when I came forth out of Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","And it shall be for an ot (sign) unto thee upon thine yad, and for a zikaron (reminder) between thine eyes, in order that the torat Hashem may be in thy mouth; because with a yad chazakah hath Hashem brought thee out of Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Thou shalt therefore be shomer over this chukkah in its mo'ed (season, fixed time) perpetually. ");
INSERT INTO engojb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","And it shall be when Hashem shall bring thee into the land of the Kena'ani, as He swore unto thee and to thy avot, and shall give it thee, ");
INSERT INTO engojb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","That thou shalt set apart unto Hashem all that openeth the rechem (womb), and every firstling that is born of a behemah which thou hast; hazecharim (the males) shall be Hashemʼs. ");
INSERT INTO engojb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","And every firstling of a he-donkey thou shalt redeem with a seh; and if thou wilt not redeem it, then thou shalt break its neck; and kol bechor adam among thy banim shalt thou redeem. ");
INSERT INTO engojb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","And it shall be when thy ben asketh thee in time to come, saying, Mah zot? (What is this?) that thou shalt say unto him, By chozek yad Hashem brought us out from Mitzrayim, from the bais avadim; ");
INSERT INTO engojb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","And it came to pass, when Pharaoh stubbornly refused to let us go, that Hashem killed kol bechor of Eretz Mitzrayim, both the bechor adam, and the bechor behemah; therefore Ani zovei'ach laHashem(I sacrifice to Hashem) kol that openeth the rechem (womb), being hazecharim (the males); but kol bechor of my banim I redeem. ");
INSERT INTO engojb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","And it shall be for an ot (sign) upon thine hand, and for totafos (ornaments, frontlets, bands, phylactery) between thine eyes; for by chozek yad Hashem brought us forth out of Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","And it came to pass, when Pharaoh had let the people go, that Elohim led them not through the derech of the eretz of the Pelishtim (Philistines), although that was near; for Elohim said, Lest perhaps the people change their mind when they see milchamah, and they return to Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So Elohim led HaAm about, through the derech of the midbar of the Yam Suf; and the Bnei Yisroel went up out of Eretz Mitzrayim ready for battle. ");
INSERT INTO engojb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","And Moshe took the atzmot Yosef with him; for Yosef had made the Bnei Yisroel swear unconditionally, saying, Elohim will surely visit you; and ye shall carry up my atzmot away from here with you. ");
INSERT INTO engojb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","And they took their journey from Sukkot, and encamped in Etam, at the edge of the midbar. ");
INSERT INTO engojb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","And Hashem went before them by day in an ammud anan, to guide them haderech; and by lailah in an ammud eish, to give them ohr; so they could travel yomam valailah (day or night); ");
INSERT INTO engojb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","He took not away the ammud heanan by day, nor the ammud haeish by night, from before HaAm. ");
INSERT INTO engojb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Then Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Speak unto the Bnei Yisroel, that they turn back and encamp before Pi-Hachirot, between Migdol and the yam, in front of Ba'al-Tzephon; opposite it shall ye encamp by the yam. ");
INSERT INTO engojb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","For Pharaoh will think of the Bnei Yisroel, They are entangled in the land, the midbar hath shut them in. ");
INSERT INTO engojb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","And I will harden lev Pharaoh, that he shall pursue after them; and I will be glorified over Pharaoh, and upon all his army; so that the Egyptians may have da'as that I am Hashem. And they did accordingly. ");
INSERT INTO engojb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","And it was told the melech Mitzrayim that HaAm had fled; and the lev Pharaoh and of his avadim was turned against HaAm, and they said, Why have we done this, that we have let Yisroel go from slaving for us? ");
INSERT INTO engojb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","And he made ready his merkavah, and took his army with him; ");
INSERT INTO engojb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","And he took six hundred select chariots, and all the chariots of Mitzrayim, and commanders over every one of them. ");
INSERT INTO engojb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","And Hashem hardened the lev Pharaoh Melech Mitzrayim, so that he pursued after the Bnei Yisroel; and the Bnei Yisroel went out with a high hand. ");
INSERT INTO engojb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","But the Mitzrayim pursued after them, all the susim and chariots of Pharaoh, and his parash, and his army, and overtook them encamping by the yam, by Pi-Hachirot, in front of Ba'al-Tzephon. ");
INSERT INTO engojb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","And when Pharaoh drew near, the Bnei Yisroel lifted up their eyes, and, hinei, the Egyptians marched after them; and they were very terrified; and the Bnei Yisroel cried out unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","And they said unto Moshe, Because there were no kevarim in Mitzrayim, hast thou taken us away to die in the midbar? What hast thou done to us, in bringing us forth out of Mitzrayim? ");
INSERT INTO engojb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Is not this the very thing that we did tell thee in Mitzrayim, saying, Let us alone, that we may slave for the Egyptians? For it had been better for us to slave for the Egyptians, than that we should die in the midbar. ");
INSERT INTO engojb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","And Moshe said unto HaAm, Fear ye not, stand still, and see the Yeshu'at Hashem, which He will bring to you today; for the Egyptians whom ye have seen today, ye shall see them again no more ad olam. ");
INSERT INTO engojb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hashem shall fight for you, and ye shall keep still. ");
INSERT INTO engojb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","And Hashem said unto Moshe, Why criest thou unto Me? Speak unto the Bnei Yisroel, so that they move on; ");
INSERT INTO engojb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","But lift thou up thy staff, and stretch out thine yad over the yam, and divide it; and the Bnei Yisroel shall go on yabashah (dry land)  through the midst of the yam. ");
INSERT INTO engojb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","And I, hineni, I will harden the lev Mitzrayim, and they shall go after them; and I will get Me glory over Pharaoh, and over all his army, over his chariots, and upon his parash (horsemen). ");
INSERT INTO engojb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","And the Egyptians shall know that I am Hashem, when I have gotten Me glory over Pharaoh, over his chariots, and over his parash. ");
INSERT INTO engojb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","And the Malach HaElohim, which goes in front of the Machaneh Yisroel, moved and went behind them; and the pillar of cloud moved from before their face, and stood behind them; ");
INSERT INTO engojb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","And it came between the machaneh Mitzrayim and the Machaneh Yisroel; there was the anan bringing choshech to the Egyptians, but bringing light by night to Yisroel; so that none came near the other, kol halailah. ");
INSERT INTO engojb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Then Moshe stretched out his yad over the yam; and Hashem caused the yam to go back by a strong east wind all that night, so that the yam was made dry land, and the mayim were divided. ");
INSERT INTO engojb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","And the Bnei Yisroel then went into the middle of the yam upon the yabashah (dry land); and the mayim were a chomah (wall) unto them on their right, and on their left. ");
INSERT INTO engojb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","And the Egyptians pursued, and went in after them into the middle of the yam, even kol sus Pharaoh, his chariots, and his parash. ");
INSERT INTO engojb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","So it came to pass, that when came the watch of the boker, Hashem looked down on the machaneh Mitzrayim through the ammud eish (pillar of fire) and of the anan, and caused confusion over the machaneh Mitzrayim, ");
INSERT INTO engojb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","And turned awry their chariot wheels, that they drove them with difficulty; so that the Egyptians said, Let us flee from the presence of Yisroel; because Hashem fighteth for them against the Egyptians. ");
INSERT INTO engojb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","And Hashem said unto Moshe, Stretch out thine yad over the yam, that the mayim may come again upon the Egyptians, upon their chariots, and upon their parash. ");
INSERT INTO engojb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","And Moshe stretched forth his yad over the yam, and the yam rushed back to its place as dawn of the boker appeared; and the Egyptians tried to flee away from meeting it; but Hashem swept the Egyptians into the middle of the yam. ");
INSERT INTO engojb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","And the mayim rushed back, and covered the chariots, and the parashim, and all the army of Pharaoh that came into the yam after them; there remained as survivors not so much as one of them. ");
INSERT INTO engojb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the Bnei Yisroel walked upon yabashah through the yam; and the mayim were a chomah unto them on their right, and on their left. ");
INSERT INTO engojb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Thus Hashem saved Yisroel yom hahu out of the hand of Mitzrayim; and Yisroel saw the Egyptians dead upon the seashore. ");
INSERT INTO engojb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","And Yisroel saw the yad hagedolah which Hashem did upon the Egyptians; and HaAm feared Hashem, and put their trust in Hashem, and in His eved Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then sang Moshe and the Bnei Yisroel this shirah (song) to Hashem, and spoke, saying, I will sing unto Hashem, for He hath triumphed gloriously: the sus and its rider hath He cast into the yam. ");
INSERT INTO engojb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hashem is my oz and zimrah (song of praise), and He is become to me Yeshu'ah (salvation); He is Eli (my G-d), and I will praise Him; Elohei Avi, and I will exalt Him. ");
INSERT INTO engojb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hashem is an Ish Milchamah; Hashem shmo. ");
INSERT INTO engojb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Markevot Pharaoh and his army hath He cast into the yam; his select commanders also are drowned in Yam Suf. ");
INSERT INTO engojb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The tehomot (depths) have covered them; they sank into the bottom like an even (stone). ");
INSERT INTO engojb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Thy right hand, Hashem, is become glorious in ko'ach; Thy right hand, Hashem, hath dashed into pieces the oyev. ");
INSERT INTO engojb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","And in the greatness of Thine majesty Thou hast overthrown them that rose up against Thee; Thou sentest forth Thy charon (wrath), which consumed them as stubble. ");
INSERT INTO engojb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","And with the blast of Thy nostrils the mayim were gathered together, the floods stood upright like a stack, and the tehomot were congealed in the lev yam (heart of the sea). ");
INSERT INTO engojb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The oyev said, I will pursue, I will overtake, I will share the plunder; my battle-lust shall be satisfied upon them; I will draw my cherev, my yad shall take possession of ");
INSERT INTO engojb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Thou didst blow with Thy ruach, the yam covered them; they sank like lead in the mighty waters. ");
INSERT INTO engojb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Mi chamochah ba'elim, Adonoi (Who is like unto Thee, Hashem, among the elim)? Who is like Thee, glorious in kodesh (holiness), awesome in praiseworthy acts, doing wonders? ");
INSERT INTO engojb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Thou didst stretch out Thy right hand, eretz swallowed them. ");
INSERT INTO engojb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Thou in Thy chesed hast led forth the people which Thou hast redeemed (acquired back); Thou hast guided them in Thy oz unto Thy neveh kodesh (holy habitation). ");
INSERT INTO engojb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The nations shall hear, and be afraid; anguish shall take hold on the inhabitants of Peleshet (Philistia). ");
INSERT INTO engojb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then the chief men of Edom shall be amazed; the mighty men of Moav, trembling shall take hold upon them; all the inhabitants of Kena'an shall melt away with weakness. ");
INSERT INTO engojb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Terror and pachad shall fall upon them; by the greatness of Thine zero'a they shall be struck dumb as an even (stone); till Thy people pass by, Hashem, till the people pass by, which Thou hast purchased. ");
INSERT INTO engojb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Thou shalt bring them in, and plant them in the har of Thine nachalah, in the place, Hashem, which Thou hast made for Thee to dwell in, in the Mikdash, Adonoi, which Thy hands have established. ");
INSERT INTO engojb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hashem shall reign l'olam va'ed. ");
INSERT INTO engojb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For the sus Pharaoh went in with his chariots and with his parash into the yam, and Hashem brought again the waters of the yam upon them; but the Bnei Yisroel went on yabashah (dry land) in the middle of the yam. ");
INSERT INTO engojb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","And Miryam the neviah, the achot Aharon, took the tof (hand drum) in her yad; and all the nashim went out after her with hand-drums and with dancing. ");
INSERT INTO engojb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","And Miryam sang to them, Sing ye to Hashem, for He hath triumphed gloriously; the sus and its rider hath He thrown into the yam. ");
INSERT INTO engojb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","So Moshe brought Yisroel from the Yam Suf, and they went out into the midbar of Shur; and they went shloshet yamim in the midbar, and found no mayim. ");
INSERT INTO engojb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","And when they came to Marah (Bitter Place), they could not drink of the mayim from Marah, for they were marim; therefore the shem of it was called Marah. ");
INSERT INTO engojb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","So the people murmured against Moshe, saying, Mah nishteh (what shall we drink)? ");
INSERT INTO engojb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","And he cried unto Hashem; and Hashem showed him an etz (tree) which when he had cast into the mayim, the waters were made sweet; at that place He made for them a chok (statute, requirement, obligation) and a mishpat (divine judgment), and there He tested them, ");
INSERT INTO engojb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","And said, If thou wilt diligently pay heed to the voice of Hashem Eloheicha, and will do that which is yashar in His sight, and will give ear to do His mitzvot, and be shomer over all His chok, I will put none of these machalah (diseases) upon thee, which I put upon the Egyptians; for Ani Adonoi rofecha (I am Hashem that healeth thee). ");
INSERT INTO engojb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","And they came to Elim (Great Trees). There were twelve springs of mayim, and threescore and ten date-palm trees; and they encamped there by the mayim. ");
INSERT INTO engojb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","And they took their journey from Elim, and kol Adat Bnei Yisroel came unto the midbar of Sin (pronounced “Seen”), which is between Elim and Sinai, on the fifteenth day of the second month after their departing out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","And kol Adat Bnei Yisroel murmured against Moshe and Aharon in the midbar; ");
INSERT INTO engojb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","And the Bnei Yisroel said unto them, If only G-d would have made us die by the yad Hashem in Eretz Mitzrayim, when we sat by the sir habasar (pot of meat), and when we did eat lechem to the full; for ye have brought us forth into this midbar, to kill this kol hakahal with ra'av (hunger). ");
INSERT INTO engojb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then said Hashem unto Moshe, Hineni, I will rain lechem from Shomayim upon you; and HaAm shall go out and gather a certain daily provision, that I may test them, whether they will walk in My torah, or no. ");
INSERT INTO engojb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","And it shall come to pass, that on the yom hashishi (sixth day) they shall prepare that which they bring in; and it shall be twice as much as they gather daily. ");
INSERT INTO engojb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","And Moshe and Aharon said unto kol Bnei Yisroel, At erev, then ye shall know that Hashem hath brought you out from Eretz Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","And in the boker, then ye shall see the kevod Hashem; because He heareth your telunnot (murmurings, grumblings) against Hashem; and who are we, that ye murmur against us? ");
INSERT INTO engojb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","And Moshe said, This shall be, when Hashem shall give you basar in the erev to eat, and in the boker lechem to the full; because Hashem heareth your telunnot which ye murmur against Him; and who are we? Your telunnot are not against us, but against Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","And Moshe spoke unto Aharon, Say unto kol Adat Bnei Yisroel, Come near before Hashem; for He hath heard your telunnot. ");
INSERT INTO engojb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","And it came to pass, as Aharon spoke unto kol Adat Bnei Yisroel, that they looked toward the midbar, and, hinei, the kevod Hashem appeared in the anan. ");
INSERT INTO engojb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","I have heard the telunnot Bnei Yisroel; speak unto them, saying, At twilight ye shall eat basar, and in the boker ye shall be glutted with lechem; and ye shall know that I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","And it came to pass, that at erev the quails came up, and covered the machaneh; and in the boker there was a layer of tal (dew) about the machaneh. ");
INSERT INTO engojb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","And when the layer of tal evaporated, hinei, upon the surface of the midbar there lay thin flakes, as thin as a layer of kfor (frost) upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","And when the Bnei Yisroel saw it, they said one to another, Mahn hu (What is it?) For they knew not mah hu (what is this). And Moshe said unto them, This is the lechem which Hashem hath given you to eat. ");
INSERT INTO engojb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is the thing which Hashem hath commanded, Gather of it every man according to his eating need, an omer per person, according to the number of your nefashot; take ye every man for them which are in his ohel. ");
INSERT INTO engojb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","And the Bnei Yisroel did so, and gathered, some more, some less. ");
INSERT INTO engojb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","And when they did measure it by the omer, he that gathered much had nothing extra, and he that gathered little had no lack; they gathered every man according to his eating need. ");
INSERT INTO engojb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","And Moshe said, Let no ish leave of it until boker. ");
INSERT INTO engojb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Notwithstanding, they paid heed not unto Moshe; but some left part of it until boker, and the leftovers bred tola'im (worms), and stank; and Moshe was angry with them. ");
INSERT INTO engojb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","And they gathered it every boker, every man according to his eating need; and when the shemesh grew hot, it melted. ");
INSERT INTO engojb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","And it came to pass, that on yom hashishi they gathered twice as much lechem, two omers for one man; and all the nesi'im of the Edah came and told Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","And he said unto them, This is that which Hashem hath said, Tomorrow is a Shabbaton (day of rest), Shabbos Kodesh unto Hashem; bake that which ye will bake today, and boil that ye will boil; and that which remaineth over lay up for you for mishmeret (for keeping) until boker. ");
INSERT INTO engojb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","And they laid it up, saving it until boker, as Moshe commanded; and it did not stink, neither was there any infestation therein. ");
INSERT INTO engojb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","And Moshe said, Eat that today; for today is a Shabbos unto Hashem; today ye shall not find it in the sadeh. ");
INSERT INTO engojb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sheshet yamim ye shall gather it; but on the yom hashevi'i, which is Shabbos, in it there shall be none. ");
INSERT INTO engojb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","And it came to pass, that there went out some from HaAm on the yom hashevi'i to gather, and they found none. ");
INSERT INTO engojb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","And Hashem said unto Moshe, How long refuse ye to be shomer over My mitzvot and My torot? ");
INSERT INTO engojb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","See, that Hashem hath given you the Shabbos, therefore He giveth you on yom hashishi lechem for two days; abide ye every man in his place, let no man go out from his place on yom hashevi'i. ");
INSERT INTO engojb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So HaAm rested on yom hashevi'i. ");
INSERT INTO engojb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","And Bais Yisroel called the shem thereof Manna; and it was like coriander seed, lavan (white); and the taste of it was like flat cakes fried in devash. ");
INSERT INTO engojb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","And Moshe said, This is the thing which Hashem commandeth, Fill an omer of it to be mishmeret (kept) for your dorot; that they may see the lechem wherewith I have fed you in the midbar, when I brought you forth from Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","And Moshe said unto Aharon, Take a jar, and put an omer full of manna therein, and lay it up before Hashem, to be kept for your dorot. ");
INSERT INTO engojb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","As Hashem commanded Moshe, so Aharon laid it up before the Edut (the Ark of the Testimony), for mishmeret (to be kept). ");
INSERT INTO engojb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","And the Bnei Yisroel did eat manna arba'im shanah, until they came to an eretz noshavet (an inhabited land); they did eat manna, until they came unto the borders of Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Now an omer is the tenth part of an ephah. ");
INSERT INTO engojb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","And kol Adat Bnei Yisroel journeyed from the midbar of Sin, setting out, according to the commandment of Hashem, and encamped in Rephidim; and there was no mayim for HaAm to drink. ");
INSERT INTO engojb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Wherefore the people did chide (quarrel, become dissatisfied with) Moshe, and said, Give us mayim that we may drink. And Moshe said unto them, Why chide ye with me? Why do ye put Hashem to the test? ");
INSERT INTO engojb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","And HaAm thirsted there for mayim; and the people murmured against Moshe, and said, Why is this that thou hast brought us up out of Mitzrayim, to kill me and my banim and my livestock with tzama (thirst)? ");
INSERT INTO engojb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","And Moshe cried unto Hashem, saying, What shall I do with this people? They are almost ready to stone me. ");
INSERT INTO engojb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","And Hashem said unto Moshe, Go on ahead of HaAm, and take with thee Ziknei Yisroel; and thy matteh (staff) wherewith thou struck the Nile, take in thine yad, and go. ");
INSERT INTO engojb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Hineni, I will stand before thee there upon the tzur in Chorev; thou shalt strike the tzur, and there shall come mayim out of it, that HaAm may drink. Moshe did so in the sight of the Ziknei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","And he called the shem of the place Massah (Testing), and Merivah (Dissatisfaction), because of the riv (chiding, quarreling) of the Bnei Yisroel, and because they put Hashem to the test, saying, Is Hashem among us, or not? ");
INSERT INTO engojb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then came Amalek, and did battle against Yisroel in Rephidim. ");
INSERT INTO engojb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","And Moshe said unto Yehoshua, Choose for us anashim, and go out, do battle with Amalek; tomorrow I will station myself on the top of the hill with the matteh HaElohim in mine yad. ");
INSERT INTO engojb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Yehoshua did as Moshe had said to him, and did battle with Amalek; and Moshe, Aharon, and Chur went up to the top of the hill. ");
INSERT INTO engojb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","And it came to pass, as long as Moshe held up his yad, that Yisroel prevailed; and when he let down his yad, Amalek prevailed. ");
INSERT INTO engojb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","When the hands of Moshe grew heavy, they took an even (stone), and put it under him, and he sat thereon; and Aharon and Chur supported his hands, the one on the one side, and the other on the other side; and his hands held emunah (steady) until bo hashemesh (sunset). ");
INSERT INTO engojb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","And Yehoshua disabled Amalek and his army with the edge of the cherev. ");
INSERT INTO engojb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","And Hashem said unto Moshe, Write this for a zikaron (memorial, remembering) in a sefer, and rehearse it in the ears of Yehoshua; for I will utterly efface the memory of Amalek from under Shomayim. ");
INSERT INTO engojb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","And Moshe built a Mizbe'ach, and called the shem of it Hashem Nissi (Hashem is my Standard); ");
INSERT INTO engojb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","For he said, Because a yad has been against the kes Hashem(throne of Hashem), Hashem hath milchamah against Amalek from dor to dor. ");
INSERT INTO engojb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","When Yitro, the kohen of Midyan, Mosheʼs khoten (father-in-law), heard of all that Elohim had done for Moshe, and for Yisroel His people, and that Hashem had brought Yisroel out of Mitzrayim; ");
INSERT INTO engojb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Then Yitro, Mosheʼs khoten, received Tzipporah, Mosheʼs wife, after Moshe had sent her away, ");
INSERT INTO engojb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","And her two banim; of which the shem of the one was Gershom; for he said, I have been a ger in a foreign land; ");
INSERT INTO engojb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","And the shem of the other was Eli'ezer; for the Elohei Avi, said he, was ezri (my help), and delivered me from the cherev of Pharaoh; ");
INSERT INTO engojb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","And Yitro, Mosheʼs khoten, came with his banim and his isha unto Moshe into the midbar, where he encamped at the Har HaElohim; ");
INSERT INTO engojb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","And he said unto Moshe, I thy khoten (father-in-law) Yitro am come unto thee, and thy isha, and her two banim with her. ");
INSERT INTO engojb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","And Moshe went out to meet his khoten, bowed low, and kissed him; and they asked each other of their shalom (welfare); and they came into the ohel. ");
INSERT INTO engojb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","And Moshe told his khoten all that Hashem had done unto Pharaoh and to the Egyptians for the sake of Yisroel, and all the travail that had befallen them along the derech, and how Hashem saved and delivered them. ");
INSERT INTO engojb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","And Yitro rejoiced for all the tovah which Hashem had done for Yisroel, whom He had delivered out of the hand of the Egyptians. ");
INSERT INTO engojb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","And Yitro said, Baruch Hashem, Who hath rescued you out of the hand of the Egyptians, and out of the hand of Pharaoh, and Who hath delivered HaAm from under the hand of the Egyptians. ");
INSERT INTO engojb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I have da'as that Hashem is gadol than kol haelohim; for in the thing wherein they dealt proudly He was above them. ");
INSERT INTO engojb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","And Yitro, Mosheʼs khoten, brought an olah and zevakhim for Elohim; and Aharon came, and kol Ziknei Yisroel, to eat lechem with Mosheʼs khoten before HaElohim. ");
INSERT INTO engojb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","And it came to pass on next day, that Moshe sat to judge HaAm; and HaAm stood around Moshe from the boker unto erev. ");
INSERT INTO engojb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","And when Mosheʼs khoten saw all that he was doing for HaAm, he said, What is this thing that thou doest to the people? Why sittest thou thyself alone, and kol HaAm stand around thee from boker unto erev? ");
INSERT INTO engojb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","And Moshe said unto his khoten, Because HaAm come unto me to inquire of Elohim; ");
INSERT INTO engojb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have a matter, they come unto me; and I judge between one and another, and I do make them know the chukkei HaElohim, and His torot. ");
INSERT INTO engojb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","And Mosheʼs khoten said unto him, The thing that thou doest is not tov. ");
INSERT INTO engojb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Thou wilt surely wear out, both thou, and HaAm hazeh that is with thee; for this thing is too heavy for thee; thou art not able to perform it thyself alone. ");
INSERT INTO engojb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Shema (pay heed) now unto my voice, I will give thee counsel, and may Elohim be with thee; be thou for HaAm before HaElohim, that thou mayest bring the disputes unto HaElohim; ");
INSERT INTO engojb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","And thou shalt teach them chukkim and torot, and shalt show them the derech wherein they must walk, and the ma'aseh that they must do. ");
INSERT INTO engojb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Moreover thou shalt provide out of kol HaAm anshei chayil (able men), yirei Elohim, anshei emes, hating bribes; and place such over them, to be over thousands, and over hundreds, over fifties, and over tens; ");
INSERT INTO engojb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","And let them judge HaAm at all times; and it shall be, that every davar hagadol they shall bring unto thee, but every davar hakaton they shall judge; so shall it be eased for thyself, and they shall bear the burden with thee. ");
INSERT INTO engojb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If thou shalt do this thing, and Elohim command thee so, then thou shalt be able to endure, and kol HaAm hazeh shall also go to their place in shalom. ");
INSERT INTO engojb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","So Moshe paid heed to the voice of his khoten, and did all that he had said. ");
INSERT INTO engojb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","And Moshe chose anshei chayil out of kol Yisroel, and made them rashim over HaAm, over thousands, hundreds, fifties, and tens. ");
INSERT INTO engojb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","And they judged HaAm at all times; the davar hakasheh (difficult case) they brought unto Moshe, but every devar hakaton they judged themselves. ");
INSERT INTO engojb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","And Moshe let his khoten depart; and he went his way into his own land. ");
INSERT INTO engojb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the chodesh hashelishi (third new moon), after the Bnei Yisroel had their exodus from Eretz Mitzrayim, on that very day they came into the Midbar Sinai. ");
INSERT INTO engojb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","For they were departed from Rephidim, and were come to Midbar Sinai, and had encamped in the midbar; and there Yisroel camped before HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","And Moshe went up to HaElohim, and Hashem called out unto him from HaHar, saying, Thus shalt thou say to the Bais Ya'akov, and declare unto the Bnei Yisroel; ");
INSERT INTO engojb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","You yourselves have seen what I did unto the Mitzrayim, and how I carried you on eaglesʼ wings, and brought you unto Myself. ");
INSERT INTO engojb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Now therefore, if ye will obey My voice very carefully, and be shomer over My brit, then ye shall be a segullah (treasured possession) unto Me above all people; for kol ha'aretz is Mine; ");
INSERT INTO engojb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","And ye shall be unto Me a mamlechet kohanim, and a goy kadosh. These are the words which thou shalt recount unto the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","And Moshe came and summoned the Ziknei HaAm, and set authoritatively before their faces all these words just as Hashem commanded him. ");
INSERT INTO engojb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","And kol HaAm answered together, and said, All that Hashem hath spoken we will do. And Moshe brought back the words of HaAm unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","And Hashem said unto Moshe, Hinei, I am coming unto thee in a thick cloud, that HaAm may hear when I speak with thee, and believe thee l'olam. Then Moshe told the words of HaAm unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","So Hashem said unto Moshe, Go unto HaAm, and set them apart as kodesh today and tomorrow, and let them wash their clothing, ");
INSERT INTO engojb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","And be ready by Yom HaShelishi; for Yom HaShelishi Hashem will come down in the sight of kol HaAm upon Mt. Sinai. ");
INSERT INTO engojb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","And thou shalt set boundaries unto HaAm all around, saying, Take heed to yourselves, that ye go not up into HaHar, or touch the edge of it; whosoever toucheth HaHar shall be surely put to death; ");
INSERT INTO engojb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","There shall no yad touch him, but he shall surely be stoned, or surely mortally shot; whether it be behemah or ish, it shall not live; when the yovel soundeth long, they shall come up to HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","So Moshe came down from HaHar unto HaAm, and set apart as kodesh HaAm; and they washed their clothes. ");
INSERT INTO engojb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Then he said to HaAm, Be ready by Sheloshet Yamim; come not into your isha. ");
INSERT INTO engojb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","And it came to pass on the Yom HaShelishi when the boker was breaking, that there were thunderings and lightnings, and a heavy cloud upon HaHar, and the blast of the shofar exceeding loud; so that kol HaAm that was in the machaneh trembled with terror. ");
INSERT INTO engojb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","And Moshe led HaAm forth out of the machaneh to encounter HaElohim; and they stood at the foot of HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","And Mt. Sinai was altogether smoking, because Hashem descended upon it in eish; and the smoke thereof ascended as the smoke of the furnace, and kol HaHar shook violently. ");
INSERT INTO engojb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","And when the sound of the shofar was moving closer, and grew louder and louder, Moshe spoke, and HaElohim answered him in thunder. ");
INSERT INTO engojb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","And Hashem came down upon Mt. Sinai, onto the top of HaHar; and Hashem summoned Moshe up to the top of HaHar; and Moshe went up. ");
INSERT INTO engojb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","And Hashem said unto Moshe, Go down, warn HaAm, lest they push through toward Hashem to gaze, and many of them fall perishing. ");
INSERT INTO engojb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","And let the kohanim also, which come near to Hashem, set themselves apart as kodesh, lest Hashem break forth upon them. ");
INSERT INTO engojb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","And Moshe said unto Hashem, HaAm cannot come up to Mt. Sinai; for You Yourself charged us, saying, Establish boundaries for HaHar, and set it apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","And Hashem said unto him, Away, get thee down, and thou shalt come up, thou, and Aharon with thee; but let not the kohanim and HaAm push through to come up unto Hashem, lest He break forth upon them. ");
INSERT INTO engojb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moshe went down unto HaAm and told them. ");
INSERT INTO engojb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Then Elohim spoke all these words, saying, ");
INSERT INTO engojb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","I am Hashem Eloheicha, Who brought thee out of Eretz Mitzrayim, out of the bais avadim (house of slaves). ");
INSERT INTO engojb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Thou shalt have no elohim acherim in My presence. ");
INSERT INTO engojb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Thou shalt not make unto thee any pesel, or any temunah of any thing that is in Shomayim above, or that is in ha'aretz beneath, or that is in the mayim under ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Thou shalt not tishtacheveh to them, nor serve them; for I Hashem Eloheicha am an El kanna, visiting the avon Avot upon the Banim unto the third and fourth generation of them that hate Me; ");
INSERT INTO engojb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","But showing chesed unto thousands of them that love Me, and are shomer over My mitzvot. ");
INSERT INTO engojb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Thou shalt not take the Shem Hashem Eloheicha in vain; for Hashem will not hold him guiltless that taketh Shmo in vain. ");
INSERT INTO engojb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Remember Yom HaShabbos, to keep it kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sheshet yamim shalt thou labor, and do all thy work: ");
INSERT INTO engojb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","But the Yom HaShevi'i is the Shabbos of Hashem Eloheicha; in it thou shalt not do any melachah, thou, nor thy ben, nor thy bat, thy eved, nor thy maidservant, nor thy cattle, nor thy ger that is within thy gates; ");
INSERT INTO engojb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in sheshet yamim Hashem made Shomayim and Ha'Aretz, the yam, and all that in them is, and rested Yom HaShevi'i; for this reason Hashem blessed Yom HaShabbos, and set it apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honor thy av and thy em; that thy yamim may be long upon ha'adamah which Hashem Eloheicha giveth thee. ");
INSERT INTO engojb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Thou shalt not murder. 14Thou shalt not commit adultery. 15Thou shalt not steal. 16Thou shalt not bear ed sheker against thy neighbor. ");
INSERT INTO engojb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Thou shalt not covet thy neighborʼs bais, thou shalt not covet thy neighborʼs isha, nor his eved, nor his maidservant, nor his ox, nor his donkey, nor anything that is thy neighborʼs. ");
INSERT INTO engojb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","And kol HaAm saw the thunderings, and the lightnings, and the sound of the shofar, and HaHar smoking; and when HaAm saw it, they drew back, and stood afar off. ");
INSERT INTO engojb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","And they said unto Moshe, Thou speak with us, and we will hear; but let not Elohim speak with us, lest we die. ");
INSERT INTO engojb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","And Moshe said unto HaAm, Fear not: for HaElohim is come to test you, and that His fear may be upon your faces, that ye sin not. ");
INSERT INTO engojb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","And HaAm stood afar off, while Moshe drew near unto the thick cloud where HaElohim was. ");
INSERT INTO engojb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","And Hashem said unto Moshe, Thus thou shalt say unto the Bnei Yisroel, You yourselves have seen that from Shomayim I have spoken with you. ");
INSERT INTO engojb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ye shall not make beside Me elohei kesef, neither shall ye make for yourselves elohei zahav. ");
INSERT INTO engojb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mizbe'ach adamah thou shalt make unto Me, and shalt sacrifice thereon thy olot, and thy shelamim, thy tzon, and thine oxen; in all places where I cause My Shem to be remembered, I will come unto thee, and I will bless thee. ");
INSERT INTO engojb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","And if thou wilt make Me a Mizbe'ach avanim, thou shalt not build it of cut stone; for if thou lift up thy tool upon it, thou hast rendered it polluted. ");
INSERT INTO engojb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Neither shalt thou go up by stairs unto Mine Mizbe'ach, that thy nakedness be not discovered thereon. ");
INSERT INTO engojb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Now these are the mishpatim which thou shalt set before them. ");
INSERT INTO engojb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","If thou acquire an eved Ivri, shesh shanim he shall serve; and in the seventh he shall go out lachafeshi (to the freedom) for no charge. ");
INSERT INTO engojb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he came in by himself, he shall go out by himself; if he were a ba'al isha, then his isha shall go out with him. ");
INSERT INTO engojb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his adon have given him an isha, and to him she gives birth to banim or banot; the isha and her yeledim shall be her adonʼs, and he shall go out free by himself. ");
INSERT INTO engojb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","And if the eved shall plainly say, I love adoni, my isha, and my banim; I will not go out lachafeshi (to the freedom); ");
INSERT INTO engojb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Then his adon shall bring him unto HaElohim; he shall also bring him to the delet (door), or unto the mezuzah; and his adon shall pierce through his ozen (ear) with a piercing-tool; then he shall serve him l'olam. ");
INSERT INTO engojb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","And if an ish sell his bat to be an amah (maidservant), she shall not go out as the avadim go free. ");
INSERT INTO engojb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she please not her adon, who hath betrothed her to himself, then shall he let her be redeemed go free; to sell her unto an am nochri (foreign people) he shall have no power, seeing he hath dealt deceitfully with her. ");
INSERT INTO engojb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","And if he have betrothed her unto his ben, he shall deal with her according to the mishpat habanot (rights of free daughters). ");
INSERT INTO engojb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he take him another, her food, her covering of clothing, and her onah (conjugal rights) shall he not deprive. ");
INSERT INTO engojb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","And if he does not perform these three unto her, then shall she go out free without kesef. ");
INSERT INTO engojb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","He that strikes down an ish, so that the ish die, shall be surely put to death. ");
INSERT INTO engojb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","And if he lie not in ambush, but HaElohim deliver him into his yad, then I will appoint thee a makom where he shall flee there. ");
INSERT INTO engojb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if an ish come premeditatedly upon his re'a, to murder him by guile; thou shalt take him from Mine Mizbe'ach for capital punishment. ");
INSERT INTO engojb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","And he that striketh down his av, or his em, shall be surely put to death. ");
INSERT INTO engojb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","And he that kidnaps an ish, and selleth him, or if he be found in his power, the kidnapper shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","And he that curseth his av, or his em, shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","And if anashim quarrel, and one strike another with an even (stone), or with his egrof (fist), and he die not, but is bedfast; ");
INSERT INTO engojb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","If he rise again, and walk around outside upon his staff, then shall he that struck down him be absolved; only shivto yiten (he shall give for his lost time), and shall provide for him to be thoroughly healed. ");
INSERT INTO engojb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","And if an ish strikes his eved, or his amah, with a shevet (rod), and he die under his yad; he shall be surely avenged. ");
INSERT INTO engojb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Notwithstanding, if he continue a yom or two, he shall not be avenged; for he is his kesef. ");
INSERT INTO engojb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men fight, and hurt an isha harah (pregnant woman), so that she gives birth prematurely but not with any injury; he shall be surely punished, according as the ba'al haisha will assess a fine upon him; and he shall pay as the judges determine. ");
INSERT INTO engojb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","And if any ason (harm, fatality) follow, then thou shalt take nefesh for nefesh, ");
INSERT INTO engojb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ayin for ayin, shen for shen, yad for yad, regel for regel, ");
INSERT INTO engojb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Burn for burn, wound for wound, chaburah (stripe laceration) for chaburah. ");
INSERT INTO engojb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","And if an ish strike the ayin of his eved, or the ayin of his amah, that it perish; he shall let him go free for his ayinʼs sake. ");
INSERT INTO engojb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","And if he strike his evedʼs shen (tooth), or his amahʼs shen; he shall let him go free for his shenʼs sake. ");
INSERT INTO engojb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox gore an ish or an isha, that they die; then the ox shall be surely stoned, and his basar shall not be eaten; but the ba'al hashor (owner of the ox) shall be exempt from punishment. ");
INSERT INTO engojb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the shor habitually from mitmol (yesterday) gored, and its ba'al has been warned, and he hath not kept it in the bull pen, and it hath killed an ish or an isha; the shor shall be stoned, and his ba'al also shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If there be laid on him a kofer (atonement payment, ransom), then he shall give for the redemption of his nefesh whatsoever is assessed upon him. ");
INSERT INTO engojb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Whether he have gored a ben, or have gored a bat, according to this mishpat shall it be done unto him. ");
INSERT INTO engojb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the ox shall gore an eved or an amah; he shall give unto their adon sheloshim shekalim kesef, and the ox shall be stoned. ");
INSERT INTO engojb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","And if an ish shall open a bor (pit), or if an ish shall dig a bor and not cover it, and an ox or a donkey fall therein; ");
INSERT INTO engojb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","The ba'al habor shall make restitution, and give kesef unto their ba'alim; and the carcass shall be his. ");
INSERT INTO engojb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","And if the shor ish (ox of a man) hurt the ox of a neighbor, that it die; then they shall sell the shor hachai (live ox), and divide the kesef of it; and the carcass also they shall divide. ");
INSERT INTO engojb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Or if it be known that the shor hath habitually from mitmol (yesterday) gored, and his ba'al hath not kept it in the bull pen; he shall surely pay ox for ox; and the carcass shall belong to him. ");
INSERT INTO engojb_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","If a ganav takes a shor, or a seh, and slaughter it, or sell it; he shall restore five cattle for an ox, and the seh. ");
INSERT INTO engojb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","If a ganav be caught breaking in, and be struck down so that he die, there shall be no guilt of bloodshed for him. ");
INSERT INTO engojb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If the shemesh be risen upon him, there shall be guilt of bloodshed; the ganav should make full restitution; if he have nothing, then the ganav shall be sold to make restitution for his theft. ");
INSERT INTO engojb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","If the theft be certainly found in his yad chayyim, whether it be ox, or donkey, or seh; he shall pay back double. ");
INSERT INTO engojb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If a man shall allow livestock to graze over a sadeh or kerem (vineyard), or he lets it loose and it graze over the sadeh of another, then from the best of his own sadeh, and of the best of his own kerem (vineyard), shall he make restitution. ");
INSERT INTO engojb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If eish break out, and spreads in kotzim (thorns), so that the stacks of grain, or the standing grain, or the sadeh, be consumed therewith; he that kindled the eish shall surely make restitution. ");
INSERT INTO engojb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","If an ish shall give unto his re'a kesef or vessels to be shomer over, and it be stolen out of the bais haish; if the ganav be found, let him pay back double. ");
INSERT INTO engojb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If the ganav be not found, then the ba'al habais shall be brought before HaElohim, to see whether he has put his yad on the property of his neighbor. ");
INSERT INTO engojb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","For all manner of pesha (trespass, liability), whether it be for ox, for donkey, for seh, for clothing, or for any manner of avedah (lost property, missing thing) which another says, This is it, the case of both shall come before HaElohim; and whom Elohim shall condemn, he shall pay back double unto his re'a. ");
INSERT INTO engojb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","If an ish deliver unto his re'a a donkey, or an ox, or a seh, or any behemah, to be shomer over; and it die, or be injured, or carried away, with no eye witness; ");
INSERT INTO engojb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Then shall a shevuat Hashem be between them both, that he hath not laid his yad on the property of his re'a; and the propertyʼs ba'al shall accept thereof, and he shall not make restitution. ");
INSERT INTO engojb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","And if it be certainly stolen from him, he shall make restitution unto the ba'al thereof. ");
INSERT INTO engojb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","If it be indeed tarof (torn by a wild animal, predator), then let him bring it for ed (witness), and he shall not make restitution for the terefah (torn animal). ");
INSERT INTO engojb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","And if an ish asks to borrow of his re'a, and the animal borrowed be injured, or die, the ba'al thereof being not with it, he shall surely make restitution. ");
INSERT INTO engojb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","But if the ba'al thereof be with it, he shall not make restitution; if it be sakhir (rented, hired), it came for its hire. ");
INSERT INTO engojb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","And if an ish entice a betulah that is not orasah (betrothed, pledged), and lie with her, he shall surely endow her with a marriage contract as his isha. ");
INSERT INTO engojb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If her av utterly refuse to give her unto him, he shall pay kesef according to the mohar habetulot (marriage contract, dowry of the virgins). ");
INSERT INTO engojb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Thou shalt not allow a mekhashefah (witch, sorceress) to live. ");
INSERT INTO engojb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Kol shochev (every one having sexual relations) with a behemah shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","He that sacrificeth unto elohim (the g-ds), other than unto Hashem only, he shall be destroyed. ");
INSERT INTO engojb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Thou shalt neither mistreat a ger, nor oppress him; for ye were gerim in Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ye shall not cause pain to any almanah, or yatom. ");
INSERT INTO engojb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","If thou cause them pain in any way, and they cry at all unto Me, I will surely hear their cry; ");
INSERT INTO engojb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","And My wrath shall be kindled, and I will kill you with the cherev; and your nashim shall be almanot, and your banim shall be yetomim. ");
INSERT INTO engojb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","If thou lend kesef to any of My people that is poor among thee, thou shalt not be to him as a nosheh (a usurer), neither shalt thou lay upon him neshekh (usury, interest). ");
INSERT INTO engojb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If thou at all take the cloak of thy re'a as security, thou shalt return it unto him by bo hashemesh (sunset); ");
INSERT INTO engojb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","For that is his covering only, it is his cloak for his skin; wherein shall he sleep? And it shall come to pass, when he crieth unto Me, that I will hear; for I am channun (compassionate). ");
INSERT INTO engojb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Thou shalt not revile Elohim, nor curse the nasi of thy people. ");
INSERT INTO engojb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Thou shalt not delay to offer thy fullness offering or thy kohenʼs heave offering; the bechor of thy banim shalt thou present unto Me. ");
INSERT INTO engojb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Likewise shalt thou do with thine oxen, and with thy tzon; shivat yamim it shall be with its em; on the yom hashemi'ni thou shalt give it Me. ");
INSERT INTO engojb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","And ye shall be anshei kodesh unto Me; neither shall ye eat any basar that is terefah (torn of beasts) in the sadeh; ye shall cast it to the kelev (dog). ");
INSERT INTO engojb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Thou shalt not spread a false report; put not thine hand with the rashah to be an ed chamas (malicious witness). ");
INSERT INTO engojb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Thou shalt not follow a multitude to do evil; neither shalt thou speak in a riv (cause, lawsuit) to turn aside after many to pervert justice; ");
INSERT INTO engojb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Neither shalt thou favor a poor man in his riv (cause, lawsuit). ");
INSERT INTO engojb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If thou meet thine enemyʼs shor (ox) or his chamor (donkey) going astray, thou shalt surely bring it back to him again. ");
INSERT INTO engojb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If thou see the chamor of him that hateth thee lying under his massa, and wouldest refrain from helping him, thou shalt surely help with him. ");
INSERT INTO engojb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Thou shalt not pervert the mishpat of thy poor in his riv (cause, lawsuit). ");
INSERT INTO engojb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Keep thee far from a devar sheker (false matter); and the naki (innocent) and tzaddik slay thou not; for I will not acquit the rashah. ");
INSERT INTO engojb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","And thou shalt take no shochad (bribe, gift); for the shochad blindeth the seeing, and perverteth the words of the tzaddikim. ");
INSERT INTO engojb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Also thou shalt not oppress a ger; for ye know the nefesh of a ger, seeing ye were gerim in Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","And shesh shanim thou shalt sow thy land, and shalt gather in the crops thereof; ");
INSERT INTO engojb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But the shevi'it thou shalt leave it shamat (unplowed) and let it lie fallow; that the evyon (poor) of thy people may eat; and what they leave the beasts of the sadeh shall eat. In like manner thou shalt deal with thy kerem (vineyard), and with thy zayit (olive) grove. ");
INSERT INTO engojb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Sheshet yamim thou shalt do thy work, and on the yom hashevi'i thou shalt rest; that thine shor (ox) and thine chamor (donkey) may rest, and the ben of thy amah (handmaid), and the ger, may be refreshed. ");
INSERT INTO engojb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","And in all things that I have said unto you be circumspect; and make no mention of the shem elohim acherim, neither let it be heard out of thy mouth. ");
INSERT INTO engojb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Three times thou shalt keep a Chag unto Me in the shanah. ");
INSERT INTO engojb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Thou shalt be shomer to keep the Chag HaMatzot; thou shalt eat matzot shivah yamim, as I commanded thee, in the time appointed of the month Aviv; for in it thou camest out from Mitzrayim; and none shall appear before Me empty-handed; ");
INSERT INTO engojb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","And the Chag HaKatzir, Bikkurim (Firstfruits)  of thy labors, which thou hast sown in the sadeh; and the Chag HaAsif (Feast of Ingathering), which is in the end of the shanah, when thou hast gathered in thy labors out of the sadeh. ");
INSERT INTO engojb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Shalosh pe'amim in the shanah all thy zachar shall appear before HaAdon Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Thou shalt not offer the dahm of My zevach with chametz; neither shall the chelev of My sacrifice remain until the boker. ");
INSERT INTO engojb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","The reshit bikkurim of thy land thou shalt bring into the Bais Hashem Eloheicha. Thou shalt not cook a kid in his motherʼs cholov. ");
INSERT INTO engojb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Hinei, I send Malach before thee, to be shomer over thee in the derech, and to bring thee into the place which I have prepared. ");
INSERT INTO engojb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pay heed to him, and obey his voice, provoke him not; for he will not pardon your peysha'im; for My Shem is in him. ");
INSERT INTO engojb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if thou shalt indeed obey his bat kol, and do all that I speak; then I will be an enemy unto thine enemies, and an adversary unto thine adversaries. ");
INSERT INTO engojb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For My Malach shall go before thee, and bring thee in unto the Emori, and the Chitti, and the Perizzi, and the Kena'ani, the Chivi, and the Yevusi; I will cut them off. ");
INSERT INTO engojb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Thou shalt not bow down to their elohim, nor serve them, nor follow after their works; but thou shalt utterly overthrow them, and completely break down their matztzvot (memorial columns dedicated to idols). ");
INSERT INTO engojb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","And ye shall serve Hashem Eloheichem, and He shall bless thy lechem, and thy mayim; and I will take machalah (sickness) away from the midst of thee. ");
INSERT INTO engojb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","There shall nothing miscarry their young, nor be barren, in thy land; the mispar (number) of thy yamim I will fulfill. ");
INSERT INTO engojb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send My ehmah (terror) ahead of thee, and will throw into confusion all the people to whom thou shalt come, and I will make all thine enemies turn their backs unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","And I will send the tzirah (hornet) ahead of thee, which shall drive out the Chivi, the Kena'ani, and the Chitti, from before thee. ");
INSERT INTO engojb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out from before thee in shanah echat; lest ha'aretz become desolate, and the beast of the sadeh multiply against thee. ");
INSERT INTO engojb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Me'at me'at (little by little) I will drive them out from before thee, until thou be increased, and inherit ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","And I will establish thy borders from the Yam Suf even unto the Yam Pelishtim, and from the Midbar unto the Euphrates River: for I will deliver the inhabitants of ha'aretz into your hand; and thou shalt drive them out before thee. ");
INSERT INTO engojb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Thou shalt make no brit (covenant) with them, nor with their elohim. ");
INSERT INTO engojb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They shall not dwell in thy land, lest they make thee sin against Me; for if thou serve their elohim, it will surely be a mokesh (snare) unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","And He said unto Moshe, Come up unto Hashem, thou, and Aharon, Nadav, and Avihu, and shive'im (seventy) of the Ziknei Yisroel; and worship ye afar off. ");
INSERT INTO engojb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","And Moshe alone shall come near Hashem; but they shall not come near; neither shall HaAm go up with him. ");
INSERT INTO engojb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","And Moshe came and told HaAm kol divrei Hashem, and all the mishpatim; and kol HaAm answered with one voice, and said, All the words which Hashem hath said will we do. ");
INSERT INTO engojb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","And Moshe wrote kol divrei Hashem, and rose up early in the boker, and built a Mizbe'ach at the base of HaHar, and twelve matzevah (stone pillars), according to the twelve Shivtei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","And he sent out na'arei Bnei Yisroel, which offered olot (burnt offerings), and sacrificed shelamim (peace offerings) of bulls unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","And Moshe took half of the dahm, and put it in bowls; and the other half of the dahm he sprinkled upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Then he took the Sefer HaBrit, and read it aloud in the ears of HaAm, and they responded, All that Hashem hath said we will do, and be obedient. ");
INSERT INTO engojb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","And Moshe took the remaining dahm, and sprinkled it on HaAm, and said, Hinei dahm habrit, which Hashem hath cut with you concerning all these words. ");
INSERT INTO engojb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then went up Moshe, and Aharon, Nadav, and Avihu, and shive'im Ziknei Yisroel; ");
INSERT INTO engojb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","And they saw the Elohei Yisroel; and there was under His feet the likeness of sapphire stone pavement, and like the very Shomayim in its clearness. ");
INSERT INTO engojb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","And against the leaders of the Bnei Yisroel He laid not His yad; also they saw HaElohim, and did eat and drink. ");
INSERT INTO engojb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","And Hashem said unto Moshe, Come up to Me into HaHar, and remain there; and I will give thee the Luchot HaEven, and the torah, and the mitzvot which I have written to teach them. ");
INSERT INTO engojb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","And Moshe rose up, and Yehoshua meshareto (the one aiding him, the one ministering to him); and Moshe went up into the Har HaElohim. ");
INSERT INTO engojb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","And he said unto the Zekenim, Tarry ye here for us, until we come again unto you; and, hinei, Aharon and Chur are with you; if any man have a grievance, let him come unto them. ");
INSERT INTO engojb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","And Moshe went up into HaHar, and an anan concealed HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","And the Kevod Hashem abode upon Mt. Sinai, and the anan concealed it sheshet yamim; and the yom hashevi'i He called unto Moshe out of the midst of the anan. ");
INSERT INTO engojb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","And the sight of the Kevod Hashem was like eish ochelet (devouring fire) on the top of HaHar in the eyes of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","And Moshe went into the midst of the anan, going up into HaHar; and Moshe was in HaHar arba'im yom v'arba'im lailah. ");
INSERT INTO engojb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Speak unto the Bnei Yisroel, that they bring Me a terumah (offering); of every man that giveth it willingly with his lev ye shall receive My terumah (offering). ");
INSERT INTO engojb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","And this is the terumah (offering) which ye shall receive of them; zahav, and kesef, and nechoshet, ");
INSERT INTO engojb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","And turquoise, and purple, and scarlet wool, and linen, and goat hair, ");
INSERT INTO engojb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","And ram skins dyed red, and tachash skins, and acacia wood, ");
INSERT INTO engojb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Shemen for the light, spices for shemen hamishchah (anointing oil) and aromatic ketoret (incense), ");
INSERT INTO engojb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Shoham stone, and stones to be set in the Ephod, and in the Choshen (Breastplate). ");
INSERT INTO engojb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","And let them make Me a Mikdash; that I may dwell among them. ");
INSERT INTO engojb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","According to all that I show thee, after the tavnit HaMishkan (pattern of the Tabernacle), and the tavnit of all the vessels thereof, even so shall ye make it. ");
INSERT INTO engojb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","And they shall make an Aron (Ark) of acacia wood; two cubits and a half shall be the length thereof, and a cubit and a half the width thereof, and a cubit and a half the height thereof. ");
INSERT INTO engojb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","And thou shalt overlay it with zahav tahor, within and without shalt thou overlay it, and shalt make upon it a gold crown all around. ");
INSERT INTO engojb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","And thou shalt cast four rings of zahav for it, and put them in the four corners thereof; and two rings shall be in the one side of it, and two rings in the other side of it. ");
INSERT INTO engojb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","And thou shalt make poles of acacia wood, and overlay them with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","And thou shalt put the poles into the rings by the sides of the Aron, that the Aron may be carried with them. ");
INSERT INTO engojb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles shall be in the rings of the Aron; they shall not be removed from it. ");
INSERT INTO engojb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","And thou shalt put into the Aron the Edut (Testimony)  of Tablets which I shall give thee. ");
INSERT INTO engojb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","And thou shalt make a kapporet of zahav tahor; two cubits and a half shall be the length thereof, and a cubit and a half the width thereof. ");
INSERT INTO engojb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","And thou shalt make two keruvim of zahav, of beaten work shalt thou make them, in the two ends of the kapporet. ");
INSERT INTO engojb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","And make one keruv on the one end, and the other keruv on the other end, with the kapporet (atonement cover) shall ye make the keruvim on the two ends thereof. ");
INSERT INTO engojb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","And the keruvim shall stretch forth their wings upward, covering the kapporet with their wings, and their faces shall look one to another; toward the kapporet shall the faces of the keruvim be. ");
INSERT INTO engojb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","And thou shalt place the kapporet on the Aron from above; and into the Aron thou shalt place the Edut that I shall give thee. ");
INSERT INTO engojb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","And there I will meet with thee, and I will commune with thee from above the kapporet, from between the two keruvim which are upon the Aron HaEdut, of all things which I will give thee in commandment unto the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Thou shalt also make a Shulchan of acacia wood; two cubits shall be the length thereof, and a cubit the width thereof, and a cubit and a half the height thereof. ");
INSERT INTO engojb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","And thou shalt overlay it with zahav tahor, and make thereto a crown of zahav around. ");
INSERT INTO engojb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","And thou shalt make unto it a border of a handbreadth round about, and thou shalt make a golden crown on the rim thereof round about. ");
INSERT INTO engojb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","And thou shalt make for it four rings of zahav, and place the rings in the four corners that are on the four legs thereof. ");
INSERT INTO engojb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Over against the rim shall the rings be for holders of the poles to carry the Shulchan. ");
INSERT INTO engojb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","And thou shalt make the poles of acacia wood, and overlay them with zahav, that the Shulchan may be carried with them. ");
INSERT INTO engojb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","And thou shalt make the dishes thereof, and spoons thereof, and shelving-tubes thereof, and bowls thereof, with which it shall be used to pour libations; of zahav tahor shalt thou make them. ");
INSERT INTO engojb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","And thou shalt set upon the Shulchan the Lechem Panim before Me always. ");
INSERT INTO engojb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","And thou shalt make a Menorah of zahav tahor; hammered out shall the Menorah be made; its base, its shaft, and its cups, its knobs, and its blossoms, shall be of the same. ");
INSERT INTO engojb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","And six branches shall come out of the sides of it; three branches of the menorah out of the one side, and three branches of the menorah out of the other side; ");
INSERT INTO engojb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Three cups engraved with almonds on the one branch, a knob and a flower; and three cups made like almonds in the other branch, with a knob and a flower; so for the six branches that come out of the Menorah. ");
INSERT INTO engojb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","And on the Menorah shall be four cups engraved like almonds, its knobs and its flowers. ");
INSERT INTO engojb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","And there shall be a knob under two branches of the same, and a knob under two branches of the same, and a knob under two branches of the same, according to the six branches that proceed out of the Menorah. ");
INSERT INTO engojb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Their knobs and their branches shall be of the same; all of it shall be one hammered out work of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","And thou shalt make the nerot shivah thereof; and they shall kindle the nerot thereof, that they may give light toward its face. ");
INSERT INTO engojb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","And the tongs thereof, and the spoons thereof, shall be of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Of a talent of zahav tahor shall he make it, with all these vessels. ");
INSERT INTO engojb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","And see that thou make them after their tavnit, which was shown thee in HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Moreover thou shalt make the Mishkan (Tabernacle) with ten curtains of twisted linen with turquoise, purple, and scarlet wool; with keruvim of artistic needle work shalt thou make them. ");
INSERT INTO engojb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","The length of one curtain shall be eight and twenty cubits, and the width of one curtain four cubits; and every one of the curtains shall have middah achat (one size). ");
INSERT INTO engojb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","The five curtains shall be choverot (joined together) one to another; and the other five curtains shall be choverot one to another. ");
INSERT INTO engojb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","And thou shalt make loops of turquoise wool upon the edge of the outermost curtain of the set; and likewise shalt thou make loops upon the edge of the outermost curtain, in the second set. ");
INSERT INTO engojb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Fifty loops shalt thou make in the first curtain, and fifty loops shalt thou make on the edge of the outermost curtain that is in the second set; that the loops may be opposite one another. ");
INSERT INTO engojb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","And thou shalt make fifty hooks of zahav, and join the curtains together with the hooks: so that the Mishkan shall become echad. ");
INSERT INTO engojb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","And thou shalt make curtains of goat hair to be an Ohel over the Mishkan: eleven curtains shalt thou make. ");
INSERT INTO engojb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","The length of one curtain shall be thirty cubits, the width of one curtain four cubits: and the eleven curtains shall be all of the middah achat (same size). ");
INSERT INTO engojb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","And thou shalt join into one five curtains by themselves, and six curtains by themselves, and shalt fold the sixth curtain over the front of the Ohel. ");
INSERT INTO engojb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","And thou shalt make fifty loops along the edge of the first curtain at the end of one choveret (set), and fifty loops on the edge of the curtain of the second choveret (set). ");
INSERT INTO engojb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","And thou shalt make fifty hooks of nechoshet, and put the hooks into the loops, and attach the Ohel, so that it may become echad (one). ");
INSERT INTO engojb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","And the remnant of the overhang of the curtains of the Ohel, half of the curtain that remaineth, shall hang over the back of the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","And a cubit on the one side, and a cubit on the other side of that which remaineth in the length of the curtains of the Ohel, shall hang over the sides of the Mishkan on this side and the other, to cover it. ");
INSERT INTO engojb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","And thou shalt make a Mikhseh for the Ohel of ram skins dyed red, and a Mikhseh of tachash skins above. ");
INSERT INTO engojb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","And thou shalt make the kerashim (planks) of the Mishkan of acacia wood, standing erect. ");
INSERT INTO engojb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ten cubits shall be the length of each keresh (plank), and a cubit and a half shall be the width of each keresh (plank). ");
INSERT INTO engojb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Two yadot (tenons, projections) shall there be in each keresh (plank), set in order one against another: thus shalt thou make for all the kerashim (planks) of the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","And thou shalt make the kerashim (planks) for the Mishkan, twenty kerashim (planks) on the south side southward. ");
INSERT INTO engojb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","And thou shalt make arba'im sockets of kesef under the twenty kerashim (planks); two sockets under one keresh (plank) for its two yadot (tenons, projections), and two sockets under the next keresh (plank) for its two yadot. ");
INSERT INTO engojb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","And for the second wall of the Mishkan on the tzafon (north) side there shall be twenty kerashim (planks): ");
INSERT INTO engojb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","And their arba'im sockets of kesef; two sockets under one keresh (plank), and two sockets under the next keresh (plank). ");
INSERT INTO engojb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","And for the back of the Mishkan on the west, thou shalt make six kerashim (planks). ");
INSERT INTO engojb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","And two kerashim (planks) shalt thou make for the corners of the Mishkan in the rear. ");
INSERT INTO engojb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","And they (the planks) shall be even at the bottom, and they shall be joined together (even) at the top, for a single ring thus shall it be for them both; they shall be for the two corners. ");
INSERT INTO engojb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","And they shall be shemoneh kerashim (eight planks), and their sockets of kesef, sixteen sockets; two sockets under one keresh, two sockets under the next keresh. ");
INSERT INTO engojb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","And thou shalt make crossbars of acacia wood; five for the kerashim (planks) of the one side of the Mishkan, ");
INSERT INTO engojb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","And five crossbars for the kerashim (planks) of the second wall of the Mishkan, and five crossbars for the kerashim (planks) of the wall of the Mishkan at the back, westward. ");
INSERT INTO engojb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","And the middle crossbar inside the kerashim (planks) shall extend from end to end. ");
INSERT INTO engojb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","And thou shalt overlay the kerashim (planks) with zahav, and make their rings of zahav as housing for the crossbars: and thou shalt overlay the crossbars with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","And thou shalt erect the Mishkan according to the mishpat (plan, specifications) thereof which was showed thee in HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","And thou shalt make a Parochet of turquoise, purple, and scarlet wool, and twisted linen of ma'aseh choshev (artistic craftwork) with keruvim shall it be made: ");
INSERT INTO engojb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","And thou shalt hang it upon four ammudim of acacia wood overlaid with zahav: their hooks shall be of zahav, upon the four sockets of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","And thou shalt hang up the Parochet under the hooks, that thou mayest bring in there behind the Parochet, the Aron HaEdut: and the Parochet shall separate unto you between HaKodesh and the Kodesh HaKodashim. ");
INSERT INTO engojb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","And thou shalt put the Kapporet upon the Aron HaEdut in the Kodesh HaKodashim. ");
INSERT INTO engojb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","And thou shalt place the Shulchan michutz (outside) the Parochet, and the Menorah opposite the Shulchan on the south side of the Mishkan: and thou shalt place the Shulchan on the north side. ");
INSERT INTO engojb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","And thou shalt make a Masach (Screen, Curtain) for the petach (entrance) of the Ohel, of turquoise, purple, and scarlet wool, and twisted linen, wrought with ma'aseh rokem (embroidering craft). ");
INSERT INTO engojb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","And thou shalt make for the Masach five ammudim of acacia wood, and overlay them with zahav, and their hooks shall be of zahav; and thou shalt cast five sockets of nechoshet for them. ");
INSERT INTO engojb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","And thou shalt build the Mizbe'ach of acacia wood, five cubits long, and five cubits wide; the Mizbe'ach shall be foursquare; and the height thereof shall be shalosh cubits. ");
INSERT INTO engojb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","And thou shalt make the karnot of it upon the four corners thereof; its karnot shall be of one piece with it; and thou shalt overlay it with nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","And thou shalt make its pots to receive its ashes, and its shovels, and its basins, and its meat forks, and its firepans; all the vessels thereof thou shalt make of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","And thou shalt build for it a mikhbar (grate), a strainer reshet (mesh, netting) of nechoshet; and upon the meshwork shalt thou make four taba'ot (rings) of nechoshet in the four corners thereof. ");
INSERT INTO engojb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","And thou shalt put it under the karkov (surrounding border, ledge) of the Mizbe'ach from below, that the meshwork may be half the height of the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","And thou shalt make badim (carrying poles) designed for the Mizbe'ach, poles of acacia wood, and overlay them with nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","And the badim shall be put into the taba'ot, and the badim shall be upon the two sides of the Mizbe'ach, to carry it. ");
INSERT INTO engojb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hollow, with luchot (planks, boards, panels), shalt thou make as it was showed thee on HaHar, so shall they make it. ");
INSERT INTO engojb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","And thou shalt make the Khatzer (Courtyard) of the Mishkan; for the south side southward there shall be kela'im (curtains, hangings) for the Khatzer (Courtyard) of twisted linen of a hundred cubits long for one side; ");
INSERT INTO engojb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","And the twenty ammudim thereof and their twenty sockets shall be of nechoshet; the hooks of the ammudim and their bands shall be of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","And likewise for the north side in length there shall be kela'im (curtains, hangings) of a hundred cubits long, and its twenty ammudim and their twenty sockets of nechoshet; the hooks of the ammudim and their bands of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","And for the width of the Khatzer (Courtyard) on the west side shall be kela'im (curtains, hangings) of fifty cubits; their ammudim ten, and their sockets ten. ");
INSERT INTO engojb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","And the width of the Khatzer (Courtyard) on the east side mizrachah (eastward, toward sunrise) shall be fifty cubits. ");
INSERT INTO engojb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","The kela'im (curtains, hangings) of one shoulder of the entrance shall be fifteen cubits; their ammudim shloshah, and their sockets shloshah. ");
INSERT INTO engojb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","And on the other shoulder of the entrance shall be hangings fifteen cubits; their ammudim shloshah, and their sockets shloshah. ");
INSERT INTO engojb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","And for the sha'ar (gate) of the Khatzer (Courtyard) shall be a Masach (Screen) of twenty cubits, of turquoise, and purple, and scarlet, and twisted linen, wrought with ma'aseh rokem (craft or work of embroidering); and their ammudim shall be four, and their sockets four. ");
INSERT INTO engojb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the ammudim around the Khatzer (Courtyard) shall be banded with kesef; their hooks shall be of kesef, and their sockets of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The length of the Khatzer (Courtyard) shall be a hundred cubits, and the width fifty by fifty, and the height five cubits of twisted linen, and their sockets of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the vessels of the Mishkan in all the avodah (service) thereof, and all the pegs thereof, and all the pegs of the Khatzer (Courtyard), shall be of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","And thou shalt command the Bnei Yisroel, that they bring thee pure pressed shemen zayit (olive oil) for the ohr, to kindle the Ner Tamid (Perpetual Lamp). ");
INSERT INTO engojb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the Ohel Moed outside the Parochet, which is before the Edut, Aharon and his banim shall arrange it from erev to boker before Hashem; it shall be a chukkat olam unto their dorot from the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","And bring thou near unto thee Aharon thy brother, and his banim with him, from the midst of the Bnei Yisroel, that he may minister unto Me in the kohenʼs office, even Aharon, Nadav and Avihu, El'azar and Itamar, Bnei Aharon. ");
INSERT INTO engojb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","And thou shalt make Bigdei Kodesh for Aharon thy brother for kavod and tiferet. ");
INSERT INTO engojb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","And thou shalt speak unto all that are of chochmei lev, whom I have filled with the Ruach Chochmah, that they may make Bigdei Aharon to set him apart as kodesh, that he may minister unto Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","And these are HaBegadim which they shall make: a Choshen, and an Ephod, and a Me'il, and a Kesones of a box-like knitting work, a Mitznefet, and an Avnet; and they shall make Bigdei Kodesh for Aharon thy brother, and his Banim, that he may minister unto Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","And they shall take zahav, and turquoise, and purple, and scarlet wool, and linen. ");
INSERT INTO engojb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","And they shall make the Ephod of zahav, of turquoise, and of purple, of scarlet wool, and twisted linen, with ma'aseh choshev (artistic embroidery). ");
INSERT INTO engojb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It shall have the two ketefot (shoulder straps) thereof joined at the two sides thereof; and so it shall be joined together. ");
INSERT INTO engojb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","And the Cheishev of his Ephod, which is upon it, shall be of the same, according to the work thereof; even of zahav, of turquoise, and purple, and scarlet wool, and twisted linen. ");
INSERT INTO engojb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","And thou shalt take two avnei shoham (onyx stones), and engrave on them the Shemot of the Bnei Yisroel: ");
INSERT INTO engojb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Shisha of their Shemot on one even (stone), and the other Shemot of the shisha remaining on the other even (stone), according to toledot (in the order in which they were born). ");
INSERT INTO engojb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","With the work of a charash even (engraver in gemstones), like the engravings of a chotam (signet ring), shalt thou engrave the two avanim with the Shemot Bnei Yisroel; thou shalt make them to be set in mishbetzot zahav (filigrees of gold). ");
INSERT INTO engojb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","And thou shalt fasten the two avanim upon the Kitfot HaEphod for avnei zikaron (memorial stones) unto the Bnei Yisroel; and Aharon shall bear their Shemot before Hashem upon his two ketefayim for a zikaron. ");
INSERT INTO engojb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","And thou shalt make mishbetzot zahav (filigrees of gold); ");
INSERT INTO engojb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","And two sharsherot zahav tahor (chains of pure gold) at the edges; of braided artistic work shalt thou make them, and fasten the braided sharsherot (chains) to the mishbetzot (filigrees). ");
INSERT INTO engojb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","And thou shalt make the Choshen Mishpat with artistic work; like the work of the Ephod thou shalt make it; of zahav, of turquoise, and of purple, and of scarlet wool, and of twisted linen, shalt thou make it. ");
INSERT INTO engojb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ravu'a (foursquare, square) it shall be folded; a span shall be the length thereof, and a span shall be the width thereof. ");
INSERT INTO engojb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","And thou shalt set in it settings of even (stone), four rows of gemstones: the first row shall be an odem, a pitdah, and bareket: this shall be the first row. ");
INSERT INTO engojb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","And the second row shall be nofech, sapphire, and yahalom. ");
INSERT INTO engojb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","And the third row a leshem, shevo, and achlamah. ");
INSERT INTO engojb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","And the fourth row tarshish, shoham, and yashfeh; they shall be set in zahav in their settings. ");
INSERT INTO engojb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","And the avanim (gemstones) shall be for the Shemot Bnei Yisroel, Shteym Esreh (Twelve), according to their Shemot, like the engravings of a chotam (signet ring); every one with shmo shall they be according to the Shnei Asar Shevet (Twelve Tribes). ");
INSERT INTO engojb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","And thou shalt make for the Choshen at the edges of braided artistic work of zahav tahor (pure gold). ");
INSERT INTO engojb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","And thou shalt make upon the Choshen two rings of zahav, and shalt fasten the two rings on the two ends of the Choshen. ");
INSERT INTO engojb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","And thou shalt fasten the two ropes of zahav on the two rings which are on the ends of the Choshen. ");
INSERT INTO engojb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","And the other two ends of the two ropes thou shalt fasten in the two mishbetzot (filigrees), and attach them to the Ketefot HaEphod (Shoulder Straps of the Ephod) toward its front. ");
INSERT INTO engojb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","And thou shalt make two rings of zahav, and thou shalt put them upon the two ends of the Choshen on the lower border thereof, on the inside toward the Ephod. ");
INSERT INTO engojb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","And two other rings of zahav thou shalt make, and shalt put them on at the bottom of the Kitfot HaEphod toward the front thereof, opposite the seam thereof, above the Cheishev HaEphod (Belt of the Ephod). ");
INSERT INTO engojb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","And they shall bind the Choshen by the rings thereof unto the rings of the Ephod with a turquoise woolen cord, that it may be above the Cheishev HaEphod, and that the Choshen be not loosed from the Ephod. ");
INSERT INTO engojb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","And Aharon shall bear the Shemot Bnei Yisroel in the Choshen HaMishpat upon his lev, when he goeth in unto HaKodesh, for a zikaron (memorial) before Hashem tamid. ");
INSERT INTO engojb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","And thou shalt put in the Choshen HaMishpat the Urim and the Tummim; and they shall be upon the lev Aharon, when he goeth in before Hashem; and Aharon shall nasa (bear)  the Mishpat Bnei Yisroel upon his lev before Hashem tamid. ");
INSERT INTO engojb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","And thou shalt make the Me'il HaEphod all of turquoise wool. ");
INSERT INTO engojb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","And there shall be a head opening in the top of it, in the middle thereof; it shall have a border of artistic embroidery around the head opening of it, like the head opening of a coat of mail; that it be not torn. ");
INSERT INTO engojb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","And beneath upon the hem of it thou shalt make pomegranates of turquoise, and of purple, and of scarlet, around the hem thereof; and bells of zahav between them round about: ");
INSERT INTO engojb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","A bell of zahav and a pomegranate, a bell of zahav and a pomegranate, upon the hem of the Me'il round about. ");
INSERT INTO engojb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","And it shall be upon Aharon lesharet (to minister); and his sound shall be heard when he goeth in unto HaKodesh before Hashem, and when he cometh out, that he die not. ");
INSERT INTO engojb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","And thou shalt make a Tzitz zahav tahor (head plate of pure gold), and engrave upon it, like the engravings of a chotam (signet ring), KODESH LAHASHEM. ");
INSERT INTO engojb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","And thou shalt put it on a turquoise cord, that it may be upon the Mitznefet; upon the forefront of the Mitznefet it shall be. ");
INSERT INTO engojb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","And it shall be upon metzach Aharon (forehead of Aharon), that Aharon may nasa (bear)  the avon of the kodashim (holy things), which the Bnei Yisroel shall set apart as kodesh in all their mattanot kadoshot (holy gifts); and it shall be always upon his metzach (forehead), that they may be leratzon (accepted, acceptable) before Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","And thou shalt embroider the Kesones of fine linen, and thou shalt make the Mitznefet of fine linen, and thou shalt make the Avnet of artistic embroidery. ");
INSERT INTO engojb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","And for Bnei Aharon thou shalt make Kuttanot (Tunics), and thou shalt make for them Avnetim, and Migba'ot shalt thou make for them, for kavod and for tiferet. ");
INSERT INTO engojb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","And thou shalt put them upon Aharon thy brother, and his banim with him; and shalt anoint them, and ordain them, and set them apart as kodesh, that they may minister unto Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","And thou shalt make them mikhnesei bahd (linen undergarments) to cover their nakedness; from the loins even unto the thighs they shall reach; ");
INSERT INTO engojb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","And they shall be upon Aharon, and upon his banim, when they come in unto the Ohel Mo'ed, or when they come near unto the Mizbe'ach lesharet (to minister) in HaKodesh; that they incur not avon, and die; it shall be a chukkat olahm unto him and his zera after him. ");
INSERT INTO engojb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","And this is the thing that thou shalt do unto them to set them apart as kodesh, to minister unto Me in the kohenʼs office: Take one bull calf, and two rams temimim (without blemish), ");
INSERT INTO engojb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","And lechem matzot, and challot matzot mixed with shemen, and wafers matzot smeared with shemen; of fine wheat flour shalt thou make them. ");
INSERT INTO engojb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Thou shalt put them into sal echad (one basket); bring them near in the sal, with the bull and the two rams. ");
INSERT INTO engojb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","And Aharon and his banim thou shalt bring unto the petach of the Ohel Mo'ed, and shalt immerse them with mayim. ");
INSERT INTO engojb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","And thou shalt take the begadim, and put upon Aharon the kesones, and the Me'il HaEphod, and the Ephod, and the Choshen, and gird him with the Cheishev HaEphod; ");
INSERT INTO engojb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","And thou shalt put the Mitznefet upon his head, and put the Nezer HaKodesh upon the Mitznefet. ");
INSERT INTO engojb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then shalt thou take the Shemen HaMishchah, and pour it upon his head, and anoint him. ");
INSERT INTO engojb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","And thou shalt bring near his banim, and put kuttanot upon them. ");
INSERT INTO engojb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","And thou shalt gird them with Avnet, Aharon and his banim, and put the migba'ot on them; and the Kehunnah shall be theirs for a chukkat olam; and thou shalt ordain Aharon and his banim. ");
INSERT INTO engojb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","And thou shalt cause a bull to be brought before the Ohel Mo'ed; Aharon and his banim shall put their hands upon the head of the bull. ");
INSERT INTO engojb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","And thou shalt slaughter (shachat) the bull before Hashem, by the petach of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","And thou shalt take of the dahm of the bull, and put it upon the karnot of the Mizbe'ach with thy finger, and pour all the dahm on the yesod (base) of the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","And thou shalt take all the chelev that covereth the innards, and the diaphragm with the liver, and the two kidneys, and the chelev that is upon them, and burn them upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But the basar of the bull, and his hide, and his dung, shalt thou burn with eish outside the machaneh; it is a chattat. ");
INSERT INTO engojb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Thou shalt also take one ram; and Aharon and his banim shall put their hands upon the head of the ram. ");
INSERT INTO engojb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","And thou shalt slaughter the ram, and thou shalt take his dahm, and sprinkle it around upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","And thou shalt cut the ayil (ram) into pieces, and wash the innards of him, and his legs, and put them with his pieces, and his head. ");
INSERT INTO engojb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","And thou shalt burn the whole ram upon the Mizbe'ach: it is an olah unto Hashem: it is a re'ach hannichoach, an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","And thou shalt take the other ayil; and Aharon and his banim shall lay their hands upon the head of the ayil. ");
INSERT INTO engojb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Then shalt thou slaughter (shachat) the ayil, and take of his dahm, and put it upon the lobe of the right ear of Aharon, and upon the lobe of the right ear of his banim, and upon the thumb of their right yad, and upon the bohen of their right foot, and sprinkle the dahm upon the Mizbe'ach, all around. ");
INSERT INTO engojb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","And thou shalt take of the dahm that is upon the Mizbe'ach, and of the shemen hamishchah, and sprinkle it upon Aharon, upon his garments, upon his banim, upon the garments of his banim with him; he shall be set apart as kodesh, and his garments, his banim, his banimʼs garments with him. ");
INSERT INTO engojb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Also thou shalt take of the ram the chelev and the tail, and the fat that covereth the innards, and the diaphragm with the liver, and the two kidneys, and the chelev that is on them, and the right thigh; for it is an ayil millu'im (ram of ordination); ");
INSERT INTO engojb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","And one kekar lechem (loaf of bread), and one challah of lechem shemen (oily loaf of bread), and one wafer out of the basket of the matzot that is before Hashem; ");
INSERT INTO engojb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","And thou shalt put all in the hands of Aharon, and in the hands of his banim; and shalt wave them for a tenufah before Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","And thou shalt take them from their hands, and burn them upon the Mizbe'ach for an olah, for a re'ach hannichoach before Hashem: it is an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","And thou shalt take the breast of the ayil hamillu'im (ram of ordination) for Aharon, and wave it for a tenufah before Hashem; and it shall be thy portion. ");
INSERT INTO engojb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","And thou shalt set apart as kodesh the breast of the tenufah, and the thigh of the terumah, which is waved, and which is raised up, of the ayil hamillu'im, even of that which is for Aharon, and of that which is for his banim; ");
INSERT INTO engojb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","And it shall be Aharonʼs and his banimʼs by a chok olam from the Bnei Yisroel; for it is a terumah; and it shall be a terumah from the Bnei Yisroel of the zivkhei shelemim of them, even their terumah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","And the Bigdei Hakodesh of Aharon shall be his banimʼs after him, to be anointed therein, and to be ordained in them. ");
INSERT INTO engojb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","And that ben that is kohen in his succession shall put them on shivat yamim, when he cometh into the Ohel Mo'ed to minister in HaKodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","And thou shalt take the ayil hamillu'im, and cook his basar in the Makom Kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","And Aharon and his banim shall eat the basar of the ayil, and the lechem that is in the sal petach Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","And they shall eat those things wherewith the kapporah was made, to ordain and to set them apart as kodesh; but a zar shall not eat thereof, because they are kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","And if anything remains of the basar of the millu'im, or of the lechem, unto the boker, then thou shalt burn the remainder with eish; it shall not be eaten, because it is kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","And thus shalt thou do unto Aharon, and to his banim, according to all things which I have commanded thee; shivat yamim shalt thou ordain them. ");
INSERT INTO engojb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","And thou shalt offer every day the bull of the chattat for kippurim (blood atonements); and thou shalt purify the Mizbe'ach, when thou hast made a kapporah for it, and thou shalt anoint it, to set it apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Shivat yamim thou shalt make a kapporah for the Mizbe'ach, and set it apart as kodesh; and it shall be a Mizbe'ach kodesh kodashim; whatsoever toucheth the Mizbe'ach shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Now this is that which thou shalt offer upon the Mizbe'ach: two kevasim (lambs) of the first year each day tamid (continually). ");
INSERT INTO engojb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","The one lamb thou shalt offer in the boker; and the other lamb thou shalt offer in the afternoon; ");
INSERT INTO engojb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","And with the one lamb a tenth ephah of fine flour mixed with the fourth part of a hin of pressed shemen; and the fourth part of a hin of yayin for a nesekh (drink offering). ");
INSERT INTO engojb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","And the other lamb thou shalt offer in the afternoon, and shalt do thereto according to the minchah of the boker, and according to the nesekh thereof, for a re'ach hannichoach, an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","This shall be an olat tamid throughout your dorot at the petach of the Ohel Mo'ed before Hashem; where I will meet you, to speak there unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","And there I will meet by appointment with the Bnei Yisroel, and it shall be set apart as kodesh by My Kavod. ");
INSERT INTO engojb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","And I will set apart as kodesh the Ohel Mo'ed, and the Mizbe'ach; and I will set apart as kodesh also both Aharon and his banim, to minister to Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","And I will dwell among the Bnei Yisroel, and will be their Elohim. ");
INSERT INTO engojb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","And they shall have da'as that I am Hashem Eloheihem, Who brought them forth out of Eretz Mitzrayim, to rest My dwelling among them; I am Hashem Eloheihem. ");
INSERT INTO engojb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","And thou shalt make a Mizbe'ach to burn ketonet (incense) upon; of acacia wood shalt thou make it. ");
INSERT INTO engojb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","A cubit shall be the length thereof, and a cubit the width thereof; ravu'a (foursquare, square) shall it be; and two cubits shall be the height thereof; the karnenot thereof shall be of the same. ");
INSERT INTO engojb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","And thou shalt overlay it with zahav tahor, the top thereof, and the sides thereof all around, and the karnenot thereof; and thou shalt make unto it a crown of zahav all around. ");
INSERT INTO engojb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","And two tabe'ot zahav (golden rings) shalt thou make to it under the crown of it, by the two corners thereof, upon the two sides of it shalt thou make it; and they shall be for places for the carrying poles to bear it withal. ");
INSERT INTO engojb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","And thou shalt make the carrying poles of acacia wood, and overlay them with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","And thou shalt put it in front of the Parochet that is before the Aron HaEdut, before the Kapporet that is over HaEdut, where I will set My meetings with thee. ");
INSERT INTO engojb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","And Aharon shall burn thereon spice ketoret every boker; when he cleaneth the nerot (lamps), he shall burn it. ");
INSERT INTO engojb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","And when Aharon lighteth the nerot (lamps) in the afternoon, he shall burn ketoret upon it, ketoret tamid before Hashem throughout your dorot. ");
INSERT INTO engojb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ye shall offer no ketoret zarah thereon, nor olah, nor minchah; neither shall ye pour nesekh thereon. ");
INSERT INTO engojb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","And Aharon shall make kapporah upon the karenot of it once in a year with the dahm of the chattat hakippurim; once in the year shall he make kapporah upon it throughout your dorot; it is kodesh kodashim unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","When thou takest the census of the Bnei Yisroel after their number, then shall they give every man a kofer nafsho (life price, atoning payment for his nefesh or soul) unto Hashem, when thou numberest them; that there be no negef (plague) among them, when thou numberest them. ");
INSERT INTO engojb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","This they shall give, every one that passeth among them that are pekudim (numbered, counted), half a shekel after the shekel of HaKodesh. (A shekel is twenty gerahs.) A half shekel shall be the terumah (offering) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Every one that passeth among them that are numbered, from twenty years old and above, shall give a terumah (offering) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","The oisher (rich man) shall not give more, and the poor shall not give less than half a shekel, when they give a terumah (offering) unto Hashem, to make kapporah for your nefashot. ");
INSERT INTO engojb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","And thou shalt take the kesef hakippurim of the Bnei Yisroel, and shalt appoint it for the Avodat Ohel Mo'ed (Work, Service of the Tent of Appointed Meeting); that it may be a zikaron unto the Bnei Yisroel before Hashem, to make kapporah for your nefashot. ");
INSERT INTO engojb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Thou shalt also make a Kiyor of nechoshet, and its Stand also of nechoshet, to wash withal; and thou shalt place it between the Ohel Mo'ed and the Mizbe'ach, and thou shalt put mayim therein. ");
INSERT INTO engojb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","For Aharon and his banim shall wash their hands and their feet thereat; ");
INSERT INTO engojb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","When they go into the Ohel Mo'ed, they shall wash with mayim, that they die not; or when they come near to the Mizbe'ach to minister, to present offering made by eish unto Hashem; ");
INSERT INTO engojb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","So they shall wash their hands and their feet, that they die not; and it shall be a chok olam to them, even to him and to his zera throughout their dorot. ");
INSERT INTO engojb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Moreover Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Take thou also unto thee choice spices, of pure myrrh five hundred shekel-weights, and of fragrant cinnamon half so much, even two hundred and fifty, and of fragrant cane spice two hundred and fifty, ");
INSERT INTO engojb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","And of cassia five hundred shekel-weights, after the shekel of HaKodesh, and of shemen zayit (oil olive) a hin: ");
INSERT INTO engojb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","And thou shalt make it a shemen mishchat kodesh, an ointment of blended compound, the art of the perfumer; it shall be a shemen mishchat kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","And thou shalt anoint the Ohel Mo'ed therewith, and the Aron HaEdut, ");
INSERT INTO engojb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","And the Shulchan and all its utensils, the Menorah and its utensils, and the Mizbe'ach HaKetoret, ");
INSERT INTO engojb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","And the Mizbe'ach HaOlah with all its utensils, and the Kiyor and its Stand. ");
INSERT INTO engojb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","And thou shalt set them apart as kodesh, that they may be kodesh kodashim; whatsoever toucheth them shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","And thou shalt anoint Aharon and his banim, and set them apart as kodesh, that they may minister unto Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And thou shalt speak unto the Bnei Yisroel, saying, This shall be a shemen mishchat kodesh unto Me throughout your dorot. ");
INSERT INTO engojb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Upon the basar adam shall it not be poured, neither shall ye make any other like it, after the formulation of it; it is kodesh, and it shall be kodesh unto you. ");
INSERT INTO engojb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whosoever compoundeth any like it, or whosoever putteth any of it upon a zar, shall even be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","And Hashem said unto Moshe, Take unto thee spices, stacte, and onycha, and galbanum; these spices with pure frankincense; of each shall there be an equal weight; ");
INSERT INTO engojb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","And thou shalt make it a compound of spice, the art of a perfumer, mixed thoroughly together, tahor and kodesh; ");
INSERT INTO engojb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","And thou shalt beat some of it very small, and place it in front of HaEdut in the Ohel Mo'ed, where I will set a meeting with thee; it shall be unto you kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","And as for the ketoret which thou shalt make, ye shall not make to yourselves according to the formulation thereof; it shall be unto thee kodesh for Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Whosoever shall make its like, to smell it, shall even be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","See, I have called by shem Betzalel ben Uri, ben Chur, of the tribe of Yehudah; ");
INSERT INTO engojb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","And I have filled him with the Ruach Elohim, in chochmah, and in tevunah, and in da'as, and in kol melachah (all workmanship), ");
INSERT INTO engojb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","To devise machashavot (artistic designs), to work in zahav, and in kesef, and in nechoshet, ");
INSERT INTO engojb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","And in engraving gemstones, to set them, and in wood-carving, to work in kol melachah (all manner of workmanship). ");
INSERT INTO engojb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","And I, hinei, I have given with him Oholiav ben Achisamach, of the tribe of Dan; and in the hearts of all chacham lev I have put chochmah, that they may make all that I have commanded thee: ");
INSERT INTO engojb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","The Ohel Mo'ed, and the Aron HaEdut, and the Kapporet that is thereupon, and all the utensils of the Ohel, ");
INSERT INTO engojb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","And the Shulchan and its utensils, and the Menorah Hatehorah with all its utensils, and the Mizbe'ach HaKetoret, ");
INSERT INTO engojb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","And the Mizbe'ach HaOlah with all its utensils, and the Kiyor and its Stand, ");
INSERT INTO engojb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","And the Bigdei Haserad (Knit Garments), and the Bigdei HaKodesh for Aharon the kohen, and the garments of his banim, to minister in the kohenʼs office, ");
INSERT INTO engojb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","And the Shemen Hamishchah, and Ketoret spices for HaKodesh; according to all that I have commanded thee shall they do. ");
INSERT INTO engojb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Speak thou also unto the Bnei Yisroel, saying, Verily My Shabbatot ye shall be shomer over; for it is an ot (sign) between Me and you throughout your dorot; that ye may have da'as that I am Hashem Who doth set thee apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ye shall be shomer Shabbos therefore; for it is kodesh unto you; every one that is chillul Shabbos (desecrates Shabbos) shall surely be put to death; for whosoever doeth any work therein, that nefesh shall be cut off from among his people. ");
INSERT INTO engojb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sheshet yamim may work be done; but in the Yom HaShevi'i is Shabbos HaShabbaton, kodesh to Hashem; whosoever doeth any work in the Yom HaShabbos, he shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Wherefore the Bnei Yisroel shall be shomer Shabbos, to observe Shabbos throughout their dorot, for a brit olam. ");
INSERT INTO engojb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It is an ot between Me and the Bnei Yisroel l'olam; for in sheshet yamim Hashem made Shomayim and HaAretz, and on Yom HaShevi'i He rested (shavat, ceased working), and was refreshed. ");
INSERT INTO engojb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","And He gave unto Moshe, when He had made an end of speaking with him upon Mt. Sinai, two Luchot HaEdut (Tablets of the Testimony), Luchot Even (Tablets of Stone), written with the Etzba Elohim (Finger of G-d). ");
INSERT INTO engojb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","And when HaAm saw that Moshe delayed to come down from HaHar, HaAm gathered themselves together unto Aharon, and said unto him, Up, make us elohim (g-ds), which shall go before us; for as for this Moshe, the ish that brought us up out of Eretz Mitzrayim, we know not what is become of him. ");
INSERT INTO engojb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","And Aharon said unto them, Take off the rings of zahav in the ears of your nashim, of your banim, and of your banot, and bring them unto me. ");
INSERT INTO engojb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","And kol HaAm removed the rings of zahav which were in their ears, and brought them unto Aharon. ");
INSERT INTO engojb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","And he received them at their yad, and fashioned it with a cheret, after he had made it an Egel Masekhah (Molten Calf); and they said, These be thy elohim, O Yisroel, which brought thee up out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","And when Aharon saw it, he built a Mizbe'ach before it; and Aharon made proclamation, and said, Tomorrow is a chag (feast) to Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","And they rose up early the next day, and offered olot, and brought shelamim; and HaAm sat down to eat and to drink, and rose up letzachek (to revel). ");
INSERT INTO engojb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","And Hashem said unto Moshe, Go, get thee down; for thy people, which thou broughtest out of Eretz Mitzrayim, have corrupted themselves; ");
INSERT INTO engojb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have turned aside quickly from HaDerech which I commanded them; they have made them an Egel Masekhah, and have bowed down to it, and have sacrificed thereunto, and said, These be thy elohim, O Yisroel, which have brought thee up out of the Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","And Hashem said unto Moshe, I have seen this people, and, hinei, it is an Am Kesheh Oref (stiffnecked, obstinate people); ");
INSERT INTO engojb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now therefore let Me alone, that My wrath may burn hot against them, and that I may consume them; I will make of thee a Goy Gadol. ");
INSERT INTO engojb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","And Moshe besought Hashem Elohav, and said, Hashem, why doth Thy wrath burn hot against Thy people, which Thou hast brought forth out of Eretz Mitzrayim with ko'ach gadol, and with a yad chazakah? ");
INSERT INTO engojb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians speak, and say, For ra'ah (evil intent) did He bring them out, to slay them in the mountains, and to consume them from the face of ha'adamah? Turn from Thy fierce wrath, and relent of the ra'ah against Thy people. ");
INSERT INTO engojb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Avraham, Yitzchak, and Yisroel, Thy avadim, to whom Thou swore by Thine own Self, and saidst unto them, I will multiply your zera as the kokhavim of Shomayim, and kol haaretz hazot that I have spoken of will I give unto your zera, and they shall inherit it l'olam. ");
INSERT INTO engojb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","And Hashem relented of the ra'ah which He thought to do unto His people. ");
INSERT INTO engojb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","And Moshe turned, and went down from HaHar, and the two Luchot HaEdut were in his yad; the Luchot were written on both their sides; on the one side and on the other were they written. ");
INSERT INTO engojb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","And the Luchot were the ma'aseh Elohim, the writing was the Mikhtav Elohim, engraved upon the Luchot. ");
INSERT INTO engojb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","And when Yehoshua heard the kol HaAm as they shouted, he said unto Moshe, There is a noise of milchamah in the machaneh. ");
INSERT INTO engojb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","And Moses said, It is not the voice of them that shout for gevurah, neither is it the voice of them that cry of chalushah; but the noise of them that sing that I hear. ");
INSERT INTO engojb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","And it came to pass, as soon as he came nigh unto the machaneh, that he saw the Egel, and the mecholot (dancing); and the anger of Moshe burned hot, and he threw the Luchot out of his hands, and broke them at the foot of HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","And he took the Egel which they had made, and burned it in the eish, and ground it to powder, and scattered it upon the mayim, and made the Bnei Yisroel drink of it. ");
INSERT INTO engojb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","And Moshe said unto Aharon, What did this people unto thee, that thou hast brought so chata'ah gedolah upon them? ");
INSERT INTO engojb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","And Aharon said, Let not the anger of adoni burn hot; thou knowest HaAm, that they are prone to rah (evil). ");
INSERT INTO engojb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","For they said unto me, Make for us elohim, which shall go before us; for as for this Moshe, the ish that brought us up out of Eretz Mitzrayim, we know not what is become of him. ");
INSERT INTO engojb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","And I said unto them, Whosoever hath any zahav, let them remove it. So they gave it me; then I cast it into the eish, and there came out this Egel. ");
INSERT INTO engojb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","And when Moshe saw that HaAm were exposed; (for Aharon had exposed them to derision among their enemies;) ");
INSERT INTO engojb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Then Moshe stood in the sha'ar of the machaneh, and said, Who is on Hashemʼs side? Let him rally unto me. And all the Bnei Levi gathered themselves together unto him. ");
INSERT INTO engojb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","And he said unto them, Thus saith Hashem Elohei Yisroel, Put every man his cherev by his side, and go in and out from sha'ar to sha'ar throughout the machaneh, and slay every man his brother, and every man his companion, and every man his neighbor. ");
INSERT INTO engojb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","And the Bnei Levi did according to the word of Moshe; and there fell of HaAm that day about three thousand men. ");
INSERT INTO engojb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","For Moshe had said, Consecrate yourselves today to Hashem, even every man against his ben, and against his brother; that He may bestow upon you a brocha this day. ");
INSERT INTO engojb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","And it came to pass on the next day, that Moshe said unto HaAm, Ye have sinned a chata'ah gedolah; and now I will go up unto Hashem; perhaps I can make kapporah for your chattat. ");
INSERT INTO engojb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","And Moshe returned unto Hashem, and said, Oh, this people have sinned a chata'ah gedolah, and have made for themselves elohei zahav. ");
INSERT INTO engojb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Yet now, if Thou wilt forgive their chattat but if not, blot me, now, out of Thy Sefer which Thou hast written. ");
INSERT INTO engojb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","And Hashem said unto Moshe, Whosoever hath sinned against Me, him will I blot out of My Sefer. ");
INSERT INTO engojb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Therefore now go, lead HaAm unto the place of which I have spoken unto thee; hinei, Malachi shall go before thee; nevertheless in the yom when I visit I will visit their sin upon them. ");
INSERT INTO engojb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And Hashem plagued HaAm, because they made the Egel, which Aharon made. ");
INSERT INTO engojb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","And Hashem said unto Moshe, Depart, and go from here, thou and HaAm which thou hast brought up out of Eretz Mitzrayim, unto HaAretz which I swore unto Avraham, to Yitzchak, and to Ya'akov, saying, Unto thy zera will I give it; ");
INSERT INTO engojb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","And I will send a Malach before thee; and I will drive out the Kena'ani, the Emori, the Chitti, the Perizzi, the Chivi, and the Yevusi; ");
INSERT INTO engojb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Unto an Eretz zavat cholov and devash; for I will not go up in the midst of thee; for thou art an Am Kesheh Oref (stiffnecked, obstinate people); lest I consume thee in HaDerech. ");
INSERT INTO engojb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","And when HaAm heard these evil tidings, they mourned; and no ish did put on him his ornamental attire. ");
INSERT INTO engojb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","For Hashem had said unto Moshe, Say unto the Bnei Yisroel, Ye are an Am Kesheh Oref; I will come up into the midst of thee in a moment, and consume thee; therefore now put off thy ornamental attire from thee, that I may decide what to do unto thee. ");
INSERT INTO engojb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","And the Bnei Yisroel stripped themselves of their ornamental attire by Mt. Chorev. ");
INSERT INTO engojb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","And Moshe would take the Ohel, and pitch it outside the machaneh, afar off from the machaneh, and called it the Ohel Mo'ed. And it came to pass, that every one which sought Hashem went out unto the Ohel Mo'ed, which was outside the machaneh. ");
INSERT INTO engojb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","And it came to pass, when Moshe went out unto the Ohel, that kol HaAm rose up, and stood every man at his petach ohel, and watched after Moshe, until he was gone into the Ohel. ");
INSERT INTO engojb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","And it came to pass, as Moshe entered into the Ohel, the Ammud of the Anan descended, and stood at the petach Ohel, and Hashem would speak with Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","And kol HaAm saw the Ammud of the Anan stand at the petach Ohel; and kol HaAm rose up and worshiped, every man in his petach ohel. ");
INSERT INTO engojb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","And Hashem spoke unto Moshe face to face, as an ish speaketh unto his re'a. And he returned into the machaneh; but his mesharet Yehoshua ben Nun, a na'ar, departed not out of the Ohel. ");
INSERT INTO engojb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","And Moshe said unto Hashem, See, Thou sayest unto me, Bring this people onward; and Thou hast not let me know whom Thou wilt send with me. Yet Thou hast said, I know thee by shem, and thou hast also found chen (grace, unmerited favor) in My sight. ");
INSERT INTO engojb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Therefore, now, if I have found chen in Thy sight, show me now Thy Derech, that I may have da'as of Thee, that I may find chen in Thy sight; and consider that this nation is Thy people. ");
INSERT INTO engojb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","And He said, My Presence shall go with thee, and I will give thee rest. ");
INSERT INTO engojb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","And he said unto Him, If Thy Presence go not with me, bring us not up from here. ");
INSERT INTO engojb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For how then shall it be known that I and Thy people have found chen in Thy sight? Is it not in that Thou goest with us? So shall we be made distinct as separate, I and Thy people, from all the people that are upon the face of ha'adamah. ");
INSERT INTO engojb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","And Hashem said unto Moshe, I will do this thing also that thou hast spoken; for thou hast found chen in My sight, and I know thee by shem. ");
INSERT INTO engojb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","And he said, show me now Thy kavod. ");
INSERT INTO engojb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","And He said, I will make kol tuvi (all My goodness) pass in front of thee, and I will call out with the Shem of Hashem before thee; and will be gracious to whom I will be gracious, and will show rachamim on whom I will show rachamim. ");
INSERT INTO engojb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","And He said, Thou canst not see My face; for there shall no adam see Me, and live. ");
INSERT INTO engojb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","And Hashem said, Hinei, there is a place near Me, and thou shalt stand upon the tzur; ");
INSERT INTO engojb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","And it shall come to pass, while My kavod passeth by, that I will put thee in a cleft of the tzur, and will cover thee with My yad until I pass by; ");
INSERT INTO engojb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","And I will take away Mine yad, and thou shalt see My back; but My face shall not be seen. ");
INSERT INTO engojb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","And Hashem said unto Moshe, Chisel thee two Luchot Avanim like the first ones; and I will write upon these Luchot the devarim that were on the Luchot HaRishonim, which thou broke. ");
INSERT INTO engojb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","And be ready in the boker, and come up in the boker unto Mt.Sinai, and present thyself there to Me on the rosh HaHar. ");
INSERT INTO engojb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","And no ish shall come up with thee, neither let any ish be seen throughout kol HaHar; neither let the tzon nor herd graze in front of that Har. ");
INSERT INTO engojb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","And he chiseled two Luchot Avanim like the first ones; and Moshe rose up early in the boker, and went up unto Mt.Sinai, as Hashem had commanded him, and took in his yad the two Luchot Avanim. ");
INSERT INTO engojb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","And Hashem descended in the anan, and stood with him there, and called out the Shem of Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","And Hashem passed by before him, and proclaimed, Hashem, Hashem El Rachum v'Channun, slow to anger, and abundant in chesed and emes, ");
INSERT INTO engojb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Preserving chesed for thousands, forgiving avon and pesha and chatta'ah, and by no means leaving the guilty unpunished; visiting the avon of the avot upon the banim, and upon the bnei banim, unto the third and to the fourth generation. ");
INSERT INTO engojb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","And Moshe made haste, and bowed his head toward the ground, and worshiped. ");
INSERT INTO engojb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","And he said, If now I have found chen in Thy sight, Adonoi, let Adonoi, now, go among us; although it is an Am Kesheh Oref; and forgive avoneinu and chattateinu, and take us for Thine nachalah. ");
INSERT INTO engojb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","And He said, Hinei, I cut a brit; before all thy people I will do nifla'ot, such as have not been done in kol ha'aretz, nor in kol HaGoyim; and kol HaAm among which thou art shall see the ma'aseh Hashem; for it is a norah that I will do with thee. ");
INSERT INTO engojb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Be thou shomer over that which I command thee this day; hinei, I drive out before thee the Emori, and the Kena'ani, and the Chitti, and the Perizzi, and the Chivi, and the Yevusi. ");
INSERT INTO engojb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be shomer over thyself, lest thou make a brit with the inhabitants of HaAretz whither thou goest, lest it be for a mokesh (snare) in the midst of thee; ");
INSERT INTO engojb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","But ye shall destroy their mizbechot, break their matzebot, and cut down their asherah (sacred trees, poles); ");
INSERT INTO engojb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For thou shalt worship no el acher; for Hashem, Whose Shem is Jealous, is El Kanah; ");
INSERT INTO engojb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Lest thou make a brit with the inhabitants of HaAretz, and they go a-whoring after eloheihem, and do sacrifice unto eloheihem, and one invite thee, and thou eat of his zevach (sacrifice, i.e., participate in his pagan worship); ");
INSERT INTO engojb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","And thou take of their banot unto thy banim, and their banot go a-whoring after their elohim, and make thy banim go a-whoring after their elohim. ");
INSERT INTO engojb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Thou shalt make thee no elohei massekhah. ");
INSERT INTO engojb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","The Chag Hamatzot shalt thou be shomer over. Shivat yamim thou shalt eat matzot, as I commanded thee, in the mo'ed of the month Aviv; for in the month Aviv thou camest out from Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","All that openeth the rechem (womb) is Mine; and every firstling among thy cattle, whether ox or seh, that is zachar. ");
INSERT INTO engojb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","But the firstling of a donkey thou shalt redeem with a seh; and if thou redeem him not, then shalt thou break his neck. Kol bechor of thy banim thou shalt redeem. And none shall appear before Me empty. ");
INSERT INTO engojb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Sheshet yamim thou shalt work, but on the yom hashevi'i thou shalt rest; in plowing and in harvest thou shalt rest. ");
INSERT INTO engojb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","And thou shalt observe Chag Shavu'os, with the firstfruits the ketzir chittim (wheat harvest), and the Chag HaAsif (Festival of Ingathering, Harvesttime) shall be at the tekufat hashanah (changing, turning of the year). ");
INSERT INTO engojb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Shalosh in the year shall all your men children appear before HaAdon Hashem Elohei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out the Goyim before thee, and enlarge thy borders; neither shall any man covet thy land, when thou shalt go up to appear before Hashem Eloheicha shalosh in the shanah. ");
INSERT INTO engojb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Thou shalt not offer the dahm of My zevach with chametz; neither shall the zevach of the Chag HaPesach be left overnight unto the boker. ");
INSERT INTO engojb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","The reshit bikkurim of thy land thou shalt bring unto the Beis Hashem Eloheicha. Thou shalt not cook a kid in cholov immo. ");
INSERT INTO engojb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","And Hashem said unto Moshe, Write thou these devarim; for according to these devarim I have cut a brit with thee and with Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","And he was there with Hashem arba'im yom and arba'im lailah; he did neither eat lechem, nor drink mayim. And he wrote upon the Luchot the Divrei HaBrit (Words of the Covenant), the Aseres Hadevarim (Ten Commandments). ");
INSERT INTO engojb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","And it came to pass, when Moshe came down from Mt. Sinai with the two Luchot HaEdut in the yad Moshe, when he came down from HaHar, that Moshe had no da'as that the ohr (skin) of his face had become radiant when he had spoken with Him. ");
INSERT INTO engojb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","And when Aharon and kol Bnei Yisroel saw Moshe, hinei, the ohr (skin) of his face was radiant; and they were afraid to come near him. ");
INSERT INTO engojb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","And Moshe called unto them; and Aharon and kol HaNesi'im of the Edah returned unto him; and Moshe spoke with them. ");
INSERT INTO engojb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","And afterward kol Bnei Yisroel came near; and he gave them in commandment all that Hashem had spoken with him in Mt Sinai. ");
INSERT INTO engojb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moshe had finished speaking with them, he put a masveh (veil, mask) on his face. ");
INSERT INTO engojb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But when Moshe went in before Hashem to speak with Him, he took the masveh off, until he came out. And he came out, and spoke unto the Bnei Yisroel that which he was commanded. ");
INSERT INTO engojb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","And the Bnei Yisroel saw the face of Moshe, that the ohr of the face of Moshe was radiant; and Moshe put the masveh upon his face again, until he went in to speak with Him. ");
INSERT INTO engojb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","And Moshe assembled kol Adat Bnei Yisroel, and said unto them, These are the Devarim which Hashem hath commanded, that ye should do them. ");
INSERT INTO engojb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sheshet yamim shall work be done, but on the Yom HaShevi'i shall be to you plural Kodesh Shabbos Shabbaton to Hashem; whosoever doeth work therein shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ye shall kindle no eish throughout your habitations upon Yom HaShabbos. ");
INSERT INTO engojb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","And Moshe spoke unto kol Adat Bnei Yisroel, saying, This is the thing which Hashem commanded, saying, ");
INSERT INTO engojb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take ye from among you a terumah (offering) unto Hashem; all of nediv lev of him, let him bring it, a terumat Hashem, zahav, and kesef, and nechoshet, ");
INSERT INTO engojb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","And turquoise, and purple, and scarlet wool, and fine linen, and goat hair, ");
INSERT INTO engojb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","And red-dyed ram skins, and tachash skins, and acacia wood, ");
INSERT INTO engojb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","And shemen for the light, and spices for shemen hamishchah, and for the aromatic ketoret, ");
INSERT INTO engojb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","And shoham stones, and gemstones to be set for the Ephod, and for the Choshen. ");
INSERT INTO engojb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","And kol chacham lev among you shall come, and make all that Hashem hath commanded: ");
INSERT INTO engojb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","The Mishkan, its Ohel, and its Mikhseh, its hooks, and its kerashim (planks), its crossbars, its ammudim, and its sockets, ");
INSERT INTO engojb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","The Aron, and the carrying poles thereof, with the Kapporet, and the Parochet HaMasach, ");
INSERT INTO engojb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","The Shulchan, and its carrying poles, and all its utensils, and the Lechem HaPanim, ");
INSERT INTO engojb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","The Menorat HaMaohr, and its utensils, and its nerot (lamps), with the Shemen HaMaohr, ");
INSERT INTO engojb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","And the Mizbe'ach HaKetoret, and its carrying poles, and the Shemen HaMishchah, and the ketoret spices, and the masach hapetach at the petach of the Mishkan, ");
INSERT INTO engojb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","The Mizbe'ach HaOlah, with its mikhbar hanechoshet, its carrying poles, and all its utensils, the Kiyor, and its Stand, ");
INSERT INTO engojb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","The curtains of the khatzer, its ammudim, and its sockets, and the masach Sha'ar HaKhatzer, ");
INSERT INTO engojb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","The tent pegs of the Mishkan, and the tent pegs of the khatzer, and their cords, ");
INSERT INTO engojb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","The Bigdei HaSerad leSharet baKodesh (to do service in HaKodesh), the Bigdei HaKodesh for Aharon the kohen, and the garments of his banim, to minister in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","And all the Adat Bnei Yisroel departed from the presence of Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","And they came, every one whose lev moved him, and every one of nedevah ruach of him, and they brought terumat Hashem to the work of the Ohel Mo'ed, and for kol avodat of it, and for the Bigdei HaKodesh. ");
INSERT INTO engojb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","And they came, both anashim and nashim, as many as were nediv lev, and brought bracelets, and face-adornment rings, and rings, and body ornaments, all jewelry of zahav; and every ish that offered offered a tenufat zahav unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","And kol ish, with whom was found turquoise, and purple, and scarlet wool, and fine linen, and goat hair, and dyed red rams skin, and tachash skins, brought them. ");
INSERT INTO engojb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Every one that did offer a terumat kesef and nechoshet brought the terumat Hashem; and found acacia wood for any melachet haAvodah, brought it. ");
INSERT INTO engojb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","And every isha that was chachmat lev spun with her hands, and brought the spun yarn, both of turquoise, and of purple, and of scarlet, and of fine linen. ");
INSERT INTO engojb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And all the nashim whose lev stirred them up in chochmah spun goat hair. ");
INSERT INTO engojb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","And the nesi'im brought shoham stones, and gemstones to be set, for the Ephod, and for the Choshen; ");
INSERT INTO engojb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","And spice, and shemen for the light, and for the shemen hamishchah, and for the ketoret spices. ");
INSERT INTO engojb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","The Bnei Yisroel brought a nedavah unto Hashem, kol ish and isha, with nadav lev of them brought for kol hamelachah, which Hashem had commanded to be done through Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","And Moshe said unto the Bnei Yisroel, See, Hashem hath called by shem Betzalel ben Uri, ben Chur, of the tribe of Yehudah; ");
INSERT INTO engojb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","And He hath filled him with the Ruach Elohim, in chochmah, in understanding, and in da'as, and in all manner of workmanship; ");
INSERT INTO engojb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","And to make machashavot (artistic works), to work in zahav, and in kesef, and in nechoshet, ");
INSERT INTO engojb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","And in the cutting of gems, to set them, and in wood carving, to make every melechet machshevet (work of art). ");
INSERT INTO engojb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","And He hath given him the ability to teach, both he, and Oholiav ben Achisamach, of the tribe of Dan. ");
INSERT INTO engojb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Them hath He filled with chochmat lev, to do all manner of artistic work, of the carver, and of the weaver of artistic design work, and of the embroiderer, in turquoise, and in purple, in scarlet wool, and in fine linen, and of the weaver, even of them that do artistic work, and of those that make artistic designs. ");
INSERT INTO engojb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Then Betzalel and Oholiav, and kol ish chacham lev, in whom Hashem gave chochmah and tevunah to have da'as to do all manner of work for the Avodas HaKodesh, are to do the work according to all that Hashem had commanded. ");
INSERT INTO engojb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","And Moshe called Betzalel and Oholiav, and kol ish chacham lev, in whose lev Hashem had given chochmah, even every one whose lev stirred him up to come unto the work to do it; ");
INSERT INTO engojb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","And they received of Moshe kol haterumah, which the Bnei Yisroel had brought for the work of the Avodas HaKodesh, to make it withal. And they brought yet unto him nedavah every boker. ");
INSERT INTO engojb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","And all the chachamim, that wrought all the work of HaKodesh, came every man from his work which they were doing; ");
INSERT INTO engojb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","And they spoke unto Moshe, saying, HaAm bring much more than enough for the Avodah of the work, which Hashem commanded to do. ");
INSERT INTO engojb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","And Moshe gave commandment, and they caused it to be proclaimed throughout the machaneh, saying, Let neither ish nor isha make any more work for the terumat HaKodesh. So HaAm were restrained from bringing. ");
INSERT INTO engojb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","For the work had been sufficient for all the work to do it v'hoter. ");
INSERT INTO engojb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","And kol chacham lev among them that wrought the work of the Mishkan made ten curtains of fine linen, twisted with turquoise, and purple, and scarlet wool; with keruvim in a woven artistic design made he them. ");
INSERT INTO engojb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of each curtain was twenty and eight cubits, and the width of each curtain four cubits; the curtains were all of the one size. ");
INSERT INTO engojb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","And he joined five curtains one unto another; and the other five curtains he joined one unto another. ");
INSERT INTO engojb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","And he made loops of turquoise wool on the edge of one curtain at the end of the first set; likewise he made them along the edge of the end curtains of the second set. ");
INSERT INTO engojb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Fifty loops made he in one curtain, and fifty loops made he in the end curtain in the second set; the loops were to be opposite one another. ");
INSERT INTO engojb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","And he made fifty hooks of zahav, and joined the curtains one unto another with the hooks; so it became Mishkan Echad. ");
INSERT INTO engojb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","And he made curtains of goat hair for the Ohel over the Mishkan; eleven curtains he made them. ");
INSERT INTO engojb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","The length of one curtain was thirty cubits, and four cubits was the width of one curtain; the eleven curtains were of the one size. ");
INSERT INTO engojb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","And he joined five curtains into a set, and six curtains into a set. ");
INSERT INTO engojb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","And he made fifty loops upon the uttermost edge of the curtain at the end of the set, and fifty loops made he upon the edge of the curtain of the other set. ");
INSERT INTO engojb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","And he made fifty hooks of nechoshet to attach the Ohel together, that it might be echad (one). ");
INSERT INTO engojb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","And he made a Mikhseh (Cover) for the Ohel of dyed red ram skin, and a tachash hide Mikhseh above that. ");
INSERT INTO engojb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","And he made kerashim (planks) for the Mishkan of acacia wood, standing erect. ");
INSERT INTO engojb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","The length of a keresh (plank) was ten cubits, and the width of a keresh one cubit and a half. ");
INSERT INTO engojb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","One keresh had two yadot (projections, tenons), equally distant one from another; thus did he make for all the kerashim of the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","And he made kerashim (frames) for the Mishkan; twenty kerashim for the negev (south) side southward; ");
INSERT INTO engojb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","And arba'im sockets of kesef he made under the twenty kerashim; two sockets under one keresh for its two tenons, and two sockets under another keresh for its two tenons. ");
INSERT INTO engojb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","And for the other side of the Mishkan, which is toward the north, he made twenty kerashim, ");
INSERT INTO engojb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","And their arba'im sockets of kesef; two sockets under one keresh, and two sockets under another keresh. ");
INSERT INTO engojb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","And for the sides of the Mishkan westward he made six kerashim. ");
INSERT INTO engojb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","And two kerashim made he for the corners of the Mishkan in the back. ");
INSERT INTO engojb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","And they were doubled at the bottom, and joined together; at the top thereof, there was one ring; thus he did to both of them in both the corners. ");
INSERT INTO engojb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","And there were eight kerashim; and their sockets were sixteen sockets of kesef, under every keresh two sockets. ");
INSERT INTO engojb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","And he made crossbars of acacia wood; five for the kerashim of the one side of the Mishkan, ");
INSERT INTO engojb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","And five crossbars for the kerashim of the other side of the Mishkan, and five crossbars for the kerashim of the Mishkan for the sides westward. ");
INSERT INTO engojb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","And he made the middle crossbar to extend within the kerashim from the one end to the other. ");
INSERT INTO engojb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","And he overlaid the kerashim with zahav, and made their rings of zahav to be housing for the crossbars, and overlaid the crossbars with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","And he made a Parochet of turquoise, and purple, and scarlet wool, and twisted fine linen; with keruvim made he it of artistic embroidery. ");
INSERT INTO engojb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","And he made thereunto four ammudim of acacia wood, and overlaid them with zahav; their hooks were of zahav; and he cast for them four sockets of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","And he made a Masach for the petach of the Ohel of turquoise, and purple, and scarlet wool, and twisted fine linen, the work of artistic embroidery; ");
INSERT INTO engojb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","And the five ammudim of it with their hooks; and he overlaid their tops and their bands with zahav; but their five sockets were of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","And Betzalel made the Aron of acacia wood; two cubits and a half was the length of it, and a cubit and a half the width of it, and a cubit and a half the height of it; ");
INSERT INTO engojb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","And he overlaid it with zahav tahor within and without, and made a crown of zahav all around. ");
INSERT INTO engojb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","And he cast for it four rings of zahav, to be set by the four corners of it; even two rings upon the one side of it, and two rings upon the other side of it. ");
INSERT INTO engojb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","And he made carrying poles of acacia wood, and overlaid them with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","And he put the carrying poles into the rings on the sides of the Aron, to bear the Aron. ");
INSERT INTO engojb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","And he made the Kapporet of zahav tahor; two cubits and a half was the length thereof, and one cubit and a half the width thereof. ");
INSERT INTO engojb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","And he made two keruvim of zahav, hammered out of one piece made he them, on the two ends of the Kapporet; ");
INSERT INTO engojb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","One keruv on the end on this side, and another keruv on the other end on that side; from the Kapporet made he the keruvim on the two ends thereof. ");
INSERT INTO engojb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","And the keruvim spread out their wings on high, and covered with their wings over the Kapporet, with their faces one to another; even toward the Kapporet were the faces of the keruvim. ");
INSERT INTO engojb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","And he made the Shulchan of acacia wood: two cubits was the length thereof, and a cubit the width thereof, and a cubit and a half the height thereof; ");
INSERT INTO engojb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","And he overlaid it with zahav tahor, and made thereunto a crown of zahav all around. ");
INSERT INTO engojb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Also he made thereunto a misgeret (moulding, rim) of a handbreadth all around; and made a crown of zahav for the misgeret thereof all around. ");
INSERT INTO engojb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","And he cast for it four rings of zahav, and put the rings upon the four corners of its four legs thereof. ");
INSERT INTO engojb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Over against the misgeret were the rings, the housing for the carrying poles to bear the Shulchan. ");
INSERT INTO engojb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","And he made the carrying poles of acacia wood, and overlaid them with zahav, to bear the Shulchan. ");
INSERT INTO engojb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","And he made the utensils which were upon the Shulchan, its dishes, and its pans, and its bowls, and its pitchers for pouring nesekh, of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","And he made the Menorah of zahav tahor; of hammered-out work made he the Menorah; its base and its shaft, and its cups, its knobs, its flowers, were of the same; ");
INSERT INTO engojb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","And six branches going out of the sides thereof; three branches of the Menorah out of the one side thereof, and three branches of the Menorah out of the other side thereof; ");
INSERT INTO engojb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Shloshah cups made like almonds in one branch, a knob and a flower; and three cups made like almonds in another branch, a knob and a flower; so throughout the six branches going out of the Menorah. ");
INSERT INTO engojb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","And in the Menorah were four cups made like almonds, its knobs, and its flowers; ");
INSERT INTO engojb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","And a knob under two branches of the same, and a knob under two branches of the same, and a knob under two branches of the same, according to the six branches going out of it. ");
INSERT INTO engojb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Their knobs and their branches were of the same: all of it was one hammered-out work of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","And he made its seven nerot (lamps), and its tongs, and its spoons, of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Of a talent of zahav tahor made he it, and all the utensils thereof. ");
INSERT INTO engojb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","And he made the Mizbe'ach HaKetoret of acacia wood; the length of it was a cubit, and the width of it a cubit; it was ravu'a (square, foursquare); and two cubits was the height of it; from it were its karenot. ");
INSERT INTO engojb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","And he overlaid it with zahav tahor, both the top of it, and the sides thereof all around, and the karenot of it; also he made unto it a crown of zahav all around. ");
INSERT INTO engojb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","And he made two rings of zahav for it under the crown thereof, by the two corners of it, upon the two sides thereof, to be housing for the carrying poles to bear it withal. ");
INSERT INTO engojb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","And he made the carrying poles of acacia wood, and overlaid them with zahav. ");
INSERT INTO engojb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","And he made the Shemen HaMishchah Kodesh, and the ketoret spices, tahor, according to the artistic work of a perfumer. ");
INSERT INTO engojb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","And he made the Mizbe'ach HaOlah of acacia wood; five cubits was the length thereof, and five cubits the width thereof; it was ravu'a (square, foursquare); and three cubits the height thereof. ");
INSERT INTO engojb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","And he made the karenot thereof on the four corners of it; the karenot thereof were from it; and he overlaid it with nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","And he made all the Klei HaMizbe'ach, the pots, and the shovels, and the sprinkling basins, and the meat hooks, and the firepans; all the utensils thereof made he of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","And he made for the Mizbe'ach a mikhbar (grate, netting), a meshwork of nechoshet under the encompassing border thereof downward unto the middle of it. ");
INSERT INTO engojb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","And he cast four rings for the four ends of the mikhbar of nechoshet, to be housing for the carrying poles. ");
INSERT INTO engojb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","And he made the carrying poles of acacia wood, and overlaid them with nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","And he put the carrying poles into the rings on the sides of the Mizbe'ach, to bear it withal; he made the Mizbe'ach hollow with luchot. ");
INSERT INTO engojb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","And he made the Kiyor of nechoshet, and the stand of it of nechoshet, of the mirrors of the tzve'ot, who assembled at the petach Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","And he made the khatzer; on the south side southward the hangings of the khatzer were of twisted fine linen, a hundred cubits; ");
INSERT INTO engojb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Their ammudim were twenty, and their sockets of nechoshet twenty; the hooks of the ammudim and their bands were of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","And for the north side the hangings were a hundred cubits, their ammudim were twenty, and their sockets of nechoshet twenty; the hooks of the ammudim and their bands of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","And for the west side were hangings of fifty cubits, their ammudim ten, and their sockets ten; the hooks of the ammudim and their bands of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","And for the east side eastward fifty cubits. ");
INSERT INTO engojb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The hangings of the one side of the entrance were fifteen cubits; their ammudim shloshah, and their sockets shloshah. ");
INSERT INTO engojb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","And for the other side. On each side of the khatzer, were hangings of fifteen cubits; their ammudim shloshah, and their sockets shloshah. ");
INSERT INTO engojb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings of the khatzer all around were of twisted fine linen. ");
INSERT INTO engojb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","And the sockets for the ammudim were of nechoshet; the hooks of the ammudim and their bands of kesef; and the overlaying of their tops of kesef; and all the ammudim of the khatzer were banded with kesef. ");
INSERT INTO engojb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","And the masach for the sha'ar of the khatzer was the artistic work of an embroiderer, of turquoise, and purple, and scarlet wool, and twisted fine linen; and twenty cubits was the length, and the height in width was five cubits, corresponding to the hangings of the khatzer. ");
INSERT INTO engojb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","And their ammudim were four, and their sockets of nechoshet four; their hooks of kesef, and the overlaying of their tops and their bands of kesef. ");
INSERT INTO engojb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","And all the tent pegs of the Mishkan, and of the khatzer all around, were of nechoshet. ");
INSERT INTO engojb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","These are the pekudei Mishkan, even of the Mishkan HaEdut, as it was recorded, according to the command of Moshe, for the Avodat HaLevi'im, by the yad of Itamar ben Aharon the kohen. ");
INSERT INTO engojb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","And Betzalel ben Uri ben Chur, of the tribe of Yehudah, made all that Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","And with him was Oholiav ben Achisamach, of the tribe of Dan, an artistic carver, weaver, and an embroiderer in turquoise, and in purple, and in scarlet wool, and fine linen. ");
INSERT INTO engojb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the zahav that was occupied for the work in all the work of HaKodesh, even the zahav of the tenufah, was twenty and nine talents, and seven hundred and thirty shekels, after the shekel of HaKodesh. ");
INSERT INTO engojb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","And the kesef of them that were numbered of HaEdah was a hundred talents, and a thousand seven hundred and threescore and fifteen shekels, after the shekel of HaKodesh: ");
INSERT INTO engojb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","A bekah for every man, that is, half a shekel, after the shekel of HaKodesh, for every one that went to be numbered, from twenty years old and upward, for six hundred thousand and three thousand and five hundred and fifty men. ");
INSERT INTO engojb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","And of the hundred talents of kesef were cast the sockets of HaKadosh, and the sockets of the Parochet; a hundred sockets of the hundred talents, a talent for a socket. ");
INSERT INTO engojb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","And of the thousand seven hundred seventy and five shekels he made hooks for the ammudim, and overlaid their tops, and made bands for them. ");
INSERT INTO engojb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","And the nechoshet of the tenufah was seventy talents, and two thousand and four hundred shekels. ");
INSERT INTO engojb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","And therewith he made the sockets to the petach Ohel Mo'ed, and the Mizbe'ach HaNechoshet, and the mikhbar hanechoshet for it, and all the Klei HaMizbe'ach, ");
INSERT INTO engojb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","And the sockets of the khatzer all around, and the sockets of the khatzer sha'ar, and all the tent pegs of the Mishkan, and all the tent pegs of the khatzer all around. ");
INSERT INTO engojb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","And from the turquoise, and purple, and scarlet wool, they made bigdei serad (elaborately woven garments) for service in HaKodesh, and made Bigdei Hakodesh for Aharon; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","And he made the Ephod of zahav, turquoise, and purple, and scarlet wool, and twisted fine linen. ");
INSERT INTO engojb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","And they did hammer the zahav into thin sheets, and cut threads, to work into the turquoise, and into the purple, and into the fine linen, the artistic weaverʼs work. ");
INSERT INTO engojb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made attaching ketefot (shoulder straps) for it, which were attached to its two upper ends. ");
INSERT INTO engojb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","And the Cheishev (Belt) of his Ephod, which is upon it, was of the same according to the work thereof; of zahav, turquoise, and purple, and scarlet wool, and twisted linen; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","And they made the avnei shoham (onyx stones), set in settings of zahav, engraved, like chotam (signet ring) is engraved, according to the Shemot Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","And he fastened them upon the Kitfot HaEphod, that they should be Avnei Zikaron (Memorial Stones) unto the Bnei Yisroel; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","And he made the Choshen of artistic weaverʼs work, like the workmanship of the Ephod; of zahav, turquoise, and purple, and scarlet wool, and fine twisted linen. ");
INSERT INTO engojb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was ravu'a (square); they made the Choshen folded double; a span was the length thereof, and a span the width thereof, being doubled. ");
INSERT INTO engojb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","And they set in it four rows of gemstones; the first row was an odem, a pitdah, and barekes; this was the first row. ");
INSERT INTO engojb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","And the second row, a nofech, sapphire, and yahalom. ");
INSERT INTO engojb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","And the third row, a leshem, shevo, and achlamah. ");
INSERT INTO engojb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","And the fourth row, a tarshish, shoham, and yashfeh; they were set in zahav in their settings. ");
INSERT INTO engojb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","And the gemstones were according to the Shemot Bnei Yisroel, Shteym Esreh (Twelve), according to their Shemot, like the engravings of a chotam (signet ring), every one with shmo, according to the Shneym Asar Shevet. ");
INSERT INTO engojb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","And they made upon the Choshen sharsherot (chains) at the ends braided artistic work of zahav tahor. ");
INSERT INTO engojb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","And they made two mishbetzot (filigrees) of zahav, and two rings of zahav; and put the two rings in the two ends of the Choshen. ");
INSERT INTO engojb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","And they fastened the two ropes of zahav into the two rings on the ends of the Choshen. ");
INSERT INTO engojb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","And the other two ends of the two ropes they fastened in the two filigree settings, and put them on the ketefot HaEphod toward its front. ");
INSERT INTO engojb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","And they made two rings of zahav, and put them on the two ends of the Choshen, upon the lower border therof, on the inside toward the Ephod. ");
INSERT INTO engojb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","And they made two other rings of zahav, and put them on the two kitfot HaEphod on the bottom, toward the front thereof, opposite the seam thereof, above the Cheishev HaEphod. ");
INSERT INTO engojb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","And they did bind the Choshen by its rings unto the rings of the Ephod with a turquoise woolen cord, that it might be above the Cheishev HaEphod, and that the Choshen might not be loosed from the Ephod; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","And he made the Me'il HaEphod of artistic weaverʼs work, all of turquoise wool. ");
INSERT INTO engojb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","And there was a head opening in the top of the Me'il, in its center, like the opening of a coat of mail, with a border all around about the head opening, that it should not be torn. ");
INSERT INTO engojb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","And they made upon the hems of the Me'il pomegranates of turquoise, and purple, and scarlet wool, and twisted linen. ");
INSERT INTO engojb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","And they made bells of zahav tahor, and put the bells between the pomegranates upon the hem of the Me'il, all around between the pomegranates; ");
INSERT INTO engojb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","A bell and a pomegranate, a bell and a pomegranate, all around the hem of the Me'il to minister in; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","And they made the kuttanot (tunics) of fine linen of artistic weaverʼs work for Aharon, and for his banim, ");
INSERT INTO engojb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","And a Mitznefet of fine linen, Pa'arei HaMigba'ot of fine linen, mikhnesei bahd, ");
INSERT INTO engojb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","And an Avnet of fine linen, and turquoise, and purple, and scarlet wool, of artistic embroidery; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","And they made the Tzitz Nezer HaKodesh of zahav tahor, and engraved upon it an inscription, like to the engravings of a chotam, KODESH LAHASHEM. ");
INSERT INTO engojb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","And they tied unto it a turquoise cord, to fasten it on the Mitznefet above; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Thus was all the work of the Mishkan of the Ohel Mo'ed finished; and the Bnei Yisroel did according to all that Hashem commanded Moshe, so did they. ");
INSERT INTO engojb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","And they brought the Mishkan unto Moshe, the Ohel, and all its utensils, its hooks, its kerashim, its crossbars, and its ammudim, and its sockets, ");
INSERT INTO engojb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","And the Mikhseh of red-dyed ram skins, and the Mikhseh of tachash skins, and the Parochet HaMasach, ");
INSERT INTO engojb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","The Aron HaEdut, and the carrying poles thereof, and the Kapporet, ");
INSERT INTO engojb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","The Shulchan, and all the utensils thereof, and the Lechem HaPanim, ");
INSERT INTO engojb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","The Menorah Hatehorah, with the nerot (lamps) thereof, even with the nerot (lamps) of the order prescribed, and all the utensils thereof, and the Shemen HaMaohr, ");
INSERT INTO engojb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","And the Mizbe'ach Hazahav, and the Shemen HaMishchah, and the aromatic ketoret, and the Masach petach HaOhel, ");
INSERT INTO engojb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","The Mizbe'ach Hanechoshet, and its mikhbar hanechoshet (grate, netting of copper), its carrying poles, and all its utensils, the Kiyor and its Stand, ");
INSERT INTO engojb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","The curtains of the khatzer (courtyard), its ammudim, and its sockets, and the masach Sha'ar HaKhatzer, its cords, and its tent pegs, and all the utensils of the Avodas HaMishkan, for the Ohel Mo'ed, ");
INSERT INTO engojb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","The bigdei serad for service in HaKodesh, and the Bigdei Hakodesh for Aharon the kohen, and the garments of his banim, to minister in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","According to all that Hashem commanded Moshe, so the Bnei Yisroel did kol haAvodah. ");
INSERT INTO engojb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","And Moshe did inspect all the work, and, hinei, they had done it as Hashem had commanded, even so had they done it; vayevarech otam Moshe (and Moshe blessed them). ");
INSERT INTO engojb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","On the first day of the first month shalt thou set up the Mishkan Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","And thou shalt place therein the Aron HaEdut, and thou shalt cover so as to screen the Aron with the Parochet. ");
INSERT INTO engojb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","And thou shalt bring in the Shulchan, and set in order the things that are to be set in order upon it; and thou shalt bring in the Menorah, and kindle the Nerot thereof. ");
INSERT INTO engojb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","And thou shalt place the Mizbe'ach Hazahav L'Ketoret before the Aron HaEdut, and set up the Masach HaPetach LaMishkan. ");
INSERT INTO engojb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","And thou shalt set the Mizbe'ach HaOlah before the Petach Mishkan Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","And thou shalt set the Kiyor between the Ohel Mo'ed and the Mizbe'ach, and shalt place mayim therein. ");
INSERT INTO engojb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","And thou shalt set up the khatzer (court) all around, and hang up the Masach Sha'ar Hakhatzer. ");
INSERT INTO engojb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","And thou shalt take the Shemen HaMishchah, and anoint the Mishkan, and all that is therein, and shalt set it apart as kodesh, and all the utensils thereof; and it shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","And thou shalt anoint the Mizbe'ach HaOlah, and all its utensils, and set apart as kodesh the Mizbe'ach: and it shall be Mizbe'ach kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","And thou shalt anoint the Kiyor and its Stand, and set it apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","And thou shalt bring near Aharon and his banim unto the Petach Ohel Mo'ed, and immerse them with mayim. ");
INSERT INTO engojb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","And thou shalt dress Aharon with the Bigdei Hakodesh, and anoint him, and set him apart as kodesh; that he may minister unto Me in the kohenʼs office. ");
INSERT INTO engojb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","And thou shalt bring near his banim, and dress them with kuttanot: ");
INSERT INTO engojb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","And thou shalt anoint them, as thou didst anoint their av, that they may minister unto Me in the kohenʼs office: for their anointing shall surely be for them a kehunat olam throughout their dorot. ");
INSERT INTO engojb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Thus did Moshe; according to all that Hashem commanded him, so did he. ");
INSERT INTO engojb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","And it came to pass in the first month in the second year, on the first day of the month, that the Mishkan was erected. ");
INSERT INTO engojb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","And Moshe erected the Mishkan, and fastened its sockets, and set up the kerashim thereof, and put in the crossbars thereof, and set up its ammudim. ");
INSERT INTO engojb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","And he spread the Ohel over the Mishkan, and put the Mikhseh of the Ohel on it from above; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","And he took and placed HaEdut (The Testimony), into HaAron, and set the carrying poles on the Aron, and put the Kapporet upon the Aron from above; ");
INSERT INTO engojb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","And he brought the Aron into the Mishkan, and set up the Parochet HaMasach, and shielded with a covering over the Aron HaEdut; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","And he put the Shulchan in the Ohel Mo'ed, upon the north side of the Mishkan, outside the Parochet. ");
INSERT INTO engojb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","And he set the Lechem in order upon it before Hashem; as Hashem had commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","And he put the Menorah in the Ohel Mo'ed, opposite the Shulchan, on the south side of the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","And he set up the nerot (lamps) before Hashem; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","And he put the Mizbe'ach Hazahav in the Ohel Mo'ed before the Parochet; ");
INSERT INTO engojb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","And he burned ketoret spices thereon; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","And he set up the Masach HaPetach LaMishkan (Curtain of the Entrance of the Tabernacle). ");
INSERT INTO engojb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","And he put the Mizbe'ach HaOlah at the Petach Mishkan Ohel Mo'ed, and offered upon it the olah (burnt offering) and the minchah; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","And he set the Kiyor between the Ohel Mo'ed and the Mizbe'ach, and put mayim there, to wash withal. ");
INSERT INTO engojb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","And Moshe and Aharon and his banim washed their hands and their feet thereat; ");
INSERT INTO engojb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","When they went into the Ohel Mo'ed, and when they came near unto the Mizbe'ach, they washed; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And he erected the khatzer (courtyard) all around the Mishkan and the Mizbe'ach, and set up the Masach Sha'ar HaKhatzer. So Moshe finished the work. ");
INSERT INTO engojb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the Anan covered the Ohel Mo'ed, and the Kavod Hashem filled the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","And Moshe was not able to enter into the Ohel Mo'ed, because the Shekinah cloud abode thereon, and the Kavod Hashem filled the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","And when the Anan was taken up from over the Mishkan, the Bnei Yisroel went onward in all their journeys; ");
INSERT INTO engojb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","But if the Anan were not taken up, then they journeyed not till the day that it was taken up. ");
INSERT INTO engojb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the Anan Hashem was upon the Mishkan by day, and Eish was on it by night, in the sight of all the Bais Yisroel, throughout all their journeys.");
INSERT INTO engojb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","And Hashem spoke unto Moshe, and spoke unto him out of the Ohel Mo'ed (Tent of Meeting) saying, ");
INSERT INTO engojb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Speak unto the Bnei Yisroel, and say unto them, If any man of you bring a korban unto Hashem, ye shall bring your korban of the cattle, even of the herd, and of the flock. ");
INSERT INTO engojb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If his korban be an olah (burnt sacrifice) of the herd, let him offer a zachar tamim (male without blemish); he shall offer it that he may be accepted at the entrance of the Ohel Mo'ed before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","And he shall lay his hand upon the head of the olah (burnt offering); and it shall be accepted for him to make kapporah for him. ");
INSERT INTO engojb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","And he shall slaughter (shachat) the young bull before Hashem; and the kohanim, Aharonʼs banim, shall bring the dahm, and sprinkle the dahm around upon the Mizbe'ach that is by the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","And he shall skin the olah, and cut it into pieces. ");
INSERT INTO engojb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","And the Bnei Aharon the kohen shall put eish upon the Mizbe'ach, and lay the wood in order upon the eish; ");
INSERT INTO engojb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","And the kohanim, Aharonʼs banim, shall lay the parts, the head, and the fat, in order upon the wood that is on the eish which is upon the Mizbe'ach: ");
INSERT INTO engojb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","But his innards and his legs shall he wash in mayim; and the kohen shall burn the whole on the Mizbe'ach, to be an olah, an offering made by eish, of a re'ach nicho'ach (sweet savour) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","And if his korban be of the flocks, namely, of the sheep, or of the goats, for an olah (burnt offering); he shall bring it a zachar tamim (male without blemish). ");
INSERT INTO engojb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","And he shall slaughter (shachat) it on the side of the Mizbe'ach northward before Hashem: and the kohanim, Aharonʼs banim, shall sprinkle his dahm around upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","And he shall cut it into pieces, with his head and his fat; and the kohen shall lay them in order on the wood that is on the eish which is upon the Mizbe'ach: ");
INSERT INTO engojb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","But he shall wash the innards and the legs with mayim; and the kohen shall bring the whole, and burn it upon the Mizbe'ach: it is an olah, an offering made by eish, of a re'ach nicho'ach (sweet savour) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","And if the olah for his korban to Hashem be of fowls, then he shall bring his korban of turtledoves, or of young pigeons. ");
INSERT INTO engojb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","And the kohen shall bring it unto the Mizbe'ach, and wring off his head, and burn it on the Mizbe'ach; and the dahm thereof shall be pressed out at the side of the Mizbe'ach: ");
INSERT INTO engojb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","And he shall pluck away his crop with his feathers, and cast it beside the Mizbe'ach on the east side, by the place of the ashes: ");
INSERT INTO engojb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","And he shall tear it open with the wings thereof, but shall not tear it in half; and the kohen shall burn it upon the Mizbe'ach, upon the wood that is upon the eish; it is an olah, an offering made by eish, of a re'ach nicho'ach (sweet savour) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","And when a nefesh will offer a korban minchah unto Hashem, his korban shall be of fine flour; and he shall pour shemen upon it, and put incense thereon; ");
INSERT INTO engojb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","And he shall bring it to the Bnei Aharon the kohanim; and he shall take thereout his handful of the flour thereof, and of the shemen thereof, with all the incense thereof; and the kohen shall burn the memorial portion of it upon the Mizbe'ach, to be an offering made by eish, of a re'ach nicho'ach unto Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","And the remnant of the minchah shall belong to Aharon and his Banim; it is a kodesh kodashim of the offerings of Hashem made by eish. ");
INSERT INTO engojb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","And if thou bring a korban minchah baked in an oven, it shall be matzot cakes of fine flour mixed with shemen, or matzot wafers anointed with shemen. ");
INSERT INTO engojb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","And if thy korban minchah be on a pan, it shall be of fine flour matzot, mixed with shemen. ");
INSERT INTO engojb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Thou shalt break it in pieces, and pour shemen thereon; it is a minchah. ");
INSERT INTO engojb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","And if thy korban minchah be in a deep pan, it shall be made of fine flour with shemen. ");
INSERT INTO engojb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","And thou shalt bring the minchah that is made of these things unto Hashem; and when it is presented unto the kohen, he shall bring it unto the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","And the kohen shall take from the minchah a memorial portion thereof, and shall burn it upon the Mizbe'ach; it is an offering made by eish, of a re'ach nicho'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","And that which is left of the minchah shall belong to Aharon and his Banim; it is a kodesh kodashim of the offerings of Hashem made by eish. ");
INSERT INTO engojb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No minchah, which ye shall bring unto Hashem, shall be made with chametz; for ye shall burn no se'or, nor any devash, in any offering of Hashem made by eish. ");
INSERT INTO engojb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","As for the korban reshit (firstfruit offering), ye shall offer them unto Hashem; but they shall not be burned on the Mizbe'ach for a re'ach nicho'ach. ");
INSERT INTO engojb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","And every korban of thy minchah shalt thou season with melach; neither shalt thou suffer the melach Brit Eloheicha to be lacking from thy minchah; with every minchah of thine thou shalt offer melach. ");
INSERT INTO engojb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","And if thou offer a minchah of thy bikkurim unto Hashem, thou shalt offer for the minchah of thy bikkurim ripe ears of grain roasted by the eish, even meal ground from new grain. ");
INSERT INTO engojb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","And thou shalt put shemen upon it, and lay incense thereon; it is a minchah. ");
INSERT INTO engojb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","And the kohen shall burn the memorial portion of it, part of the ground grain thereof, and part of the shemen thereof, with all the incense thereof; it is an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","And if his korban be a zevach of shelamim, if he offer it of the herd; whether it be a zachar or nekevah, he shall offer it tamim (without blemish) before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","And he shall lay his hand upon the head of his korban, and slaughter (shachat) it at the entrance of the Ohel Mo'ed; and Aharonʼs Banim the kohanim shall sprinkle the dahm upon the Mizbe'ach around. ");
INSERT INTO engojb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","And he shall offer of the zevach of the shelamim an offering made by eish unto Hashem; the chelev (fat) that covereth the innards, and all the chelev (fat) that is upon the innards, ");
INSERT INTO engojb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","And the two kidneys, and the chelev (fat) that is around them, which is by the loins, and the diaphragm with the liver, with the kidneys, it shall he remove. ");
INSERT INTO engojb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","And Aharonʼs Banim shall burn it on the Mizbe'ach upon the olah which is upon the wood that is on the eish; it is an offering made by eish, of a re'ach nicho'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","And if his korban for a zevach shelamim unto Hashem be of the flock; zachar or nekevah, he shall offer it tamim (without blemish). ");
INSERT INTO engojb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If he offer a keves (lamb) for his korban, then shall he offer it before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","And he shall lay his hand upon the head of his korban, and slaughter (shachat) it before the Ohel Mo'ed; and Aharonʼs Banim shall sprinkle the dahm thereof around upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","And he shall offer of the zevach hashelamim an offering made by eish unto Hashem; the chelev thereof, and the whole fat tail, it shall he remove by the backbone; and the chelev that covereth the innards, and all the chelev that is upon the innards, ");
INSERT INTO engojb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","And the two kidneys, and the chelev (fat) that is upon them, which is by the loins, and the diaphragm with the liver, with the kidneys, it shall he remove. ");
INSERT INTO engojb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","And the kohen shall burn it upon the Mizbe'ach; it is the lechem of the offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","And if his korban be a goat, then he shall offer it before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","And he shall lay his hand upon the head of it, and slaughter (shachat) it before the Ohel Mo'ed; and the Bnei Aharon shall sprinkle the dahm thereof upon the Mizbe'ach round about. ");
INSERT INTO engojb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","And he shall offer thereof his korban, even an offering made by eish unto Hashem; the chelev (fat) that covereth the innards, and all the chelev (fat) that is upon the innards, ");
INSERT INTO engojb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","And the two kidneys, and the chelev (fat) that is upon them, which is by the loins, and the diaphragm above the liver, with the kidneys, it shall he remove. ");
INSERT INTO engojb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","And the kohen shall burn them upon the Mizbe'ach; it is the lechem of the offering made by eish for a re'ach nicho'ach; all the chelev (fat) is Hashemʼs. ");
INSERT INTO engojb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","It shall be a chukkat olam for your generations throughout all your dwellings, that ye eat neither chelev (fat) nor dahm (blood). ");
INSERT INTO engojb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Speak unto the Bnei Yisroel, saying, If a nefesh shall sin through ignorance (unintentionally) against any of the mitzvot of Hashem concerning things which ought not to be done, and shall do against any of them; ");
INSERT INTO engojb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If the Kohen HaMoshiach do sin, bringing guilt upon the people; then let him bring for his chattat (sin), which he hath sinned, a young bull tamim (without blemish) unto Hashem for a chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","And he shall bring the young bull unto the entrance of the Ohel Mo'ed before Hashem; and shall lay his hand upon the young bullʼs head, and slaughter (shachat) the young bull before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","And the Kohen HaMoshiach shall take of the young bullʼs dahm, and bring it to the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","And the kohen shall dip his forefinger in the dahm, and sprinkle of the dahm seven times before Hashem, before the Parochet (curtain) of the Kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","And the kohen shall put some of the dahm upon the horns of the Mizbe'ach Ketoret HaSammim (Altar of Fragrant Incense) before Hashem, which is in the Ohel Mo'ed; and shall pour the rest of the dahm of the young bull at the base of the Mizbe'ach HaOlah which is at the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","And he shall take off from it all the chelev (fat) of the young bull for the chattat (sin offering); the chelev (fat) that covereth the innards, and all the chelev (fat) that is upon the innards, ");
INSERT INTO engojb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","And the two kidneys, and the chelev (fat) that is upon them, which is by the loins, and the diaphragm above the liver, with the kidneys, it shall he remove, ");
INSERT INTO engojb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Just as it was removed from the ox of the zevach hashelamim; and the kohen shall burn them upon the Mizbe'ach HaOlah. ");
INSERT INTO engojb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","And the hide of the young bull, and all his basar, with his head, and with his legs, and his innards, and his dung, ");
INSERT INTO engojb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Even the rest of the young bull shall he carry forth outside the machaneh unto a makom tahor, where the ashes are poured out, and burn him on the wood with eish; where the ashes are poured out shall he be burned. ");
INSERT INTO engojb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","And if the kol Adat Yisroel sin through ignorance (unintentionally), and the thing be hid from the eyes of the Kahal (Assembly), and they have done any one thing against any of the mitzvot of Hashem concerning things which should not be done, and are guilty; ");
INSERT INTO engojb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When the chattat (sin), which they have sinned against it, is known, then the Kahal (Assembly) shall offer a young bull for the chattat (sin), and bring him before the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","And the Ziknei HaEdah shall lay their hands upon the head of the young bull before Hashem; and the young bull shall be slaughtered (shachat) before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","And the Kohen HaMoshiach shall bring of the young bullʼs dahm to the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","And the kohen shall dip his forefinger in some of the dahm, and sprinkle it seven times before Hashem, even before the Parochet (curtain). ");
INSERT INTO engojb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","And he shall put some of the dahm upon the horns of the Mizbe'ach which is before Hashem, that is in the Ohel Mo'ed, and shall pour out the rest of the dahm at the base of the Mizbe'ach HaOlah, which is at the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","And he shall remove all his chelev (fat) from him, and burn it upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","And he shall do with the young bull as he did with the young bull for a chattat (sin offering), so shall he do with this; and the kohen shall make kapporah for them, and it shall be forgiven them. ");
INSERT INTO engojb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","And he shall carry forth the young bull outside the machaneh, and burn him as he burned the first young bull; it is a chattat (sin offering) for the Kahal. ");
INSERT INTO engojb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","When a nasi hath sinned, and done something through ignorance against any of the mitzvot of Hashem Elohav concerning things which should not be done, and is guilty; ");
INSERT INTO engojb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Or if his chattat (sin), wherein he hath sinned, come to his knowledge; he shall bring his korban, a male goat tamim (without blemish); ");
INSERT INTO engojb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","And he shall lay his hand upon the head of the goat, and slaughter (shachat) it in the place where they slaughter the olah (burnt offering) before Hashem; it is a chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","And the kohen shall take of the dahm of the chattat (sin offering) with his forefinger, and put it upon the horns of the Mizbe'ach HaOlah, and shall pour out his dahm at the base of the Mizbe'ach HaOlah. ");
INSERT INTO engojb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","And he shall burn all his chelev (fat) upon the Mizbe'ach, as the chelev (fat) of the zevach hashelamim; and the kohen shall make kapporah for him as concerning his chattat (sin), and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","And if a nefesh of the am ha'aretz sin through ignorance (unintentionally), while he doeth any thing against any of the mitzvot of Hashem concerning things which ought not to be done, and be guilty; ");
INSERT INTO engojb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Or if his chattat (sin), which he hath sinned, come to his knowledge; then he shall bring his korban, a female goat, a temimah nekevah (a female without blemish), for his chattat (sin) which he hath sinned. ");
INSERT INTO engojb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","And he shall lay his hand upon the head of the chattat (sin offering), and slaughter (shachat) the chattat (sin offering) in the place of the olah (burnt offering). ");
INSERT INTO engojb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","And the kohen shall take of the dahm thereof with his forefinger, and put it upon the horns of the Mizbe'ach HaOlah, and shall pour out the rest of the dahm thereof at the base of the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","And he shall remove all the chelev (fat) thereof, as the chelev (fat) is removed from off the zevach hashelamim; and the kohen shall burn it upon the Mizbe'ach for a re'ach nicho'ach unto Hashem; and the kohen shall make kapporah for him, and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","And if he bring a keves (lamb) for a chattat (sin offering), he shall bring it a nekevah temimah (female without blemish). ");
INSERT INTO engojb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","And he shall lay his hand upon the head of the chattat (sin offering), and slaughter (shachat) it for a chattat (sin offering) in the place where they slaughter the olah (burnt offering). ");
INSERT INTO engojb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","And the kohen shall take of the dahm of the chattat (sin offering) with his forefinger, and put it upon the horns of the Mizbe'ach HaOlah (Altar of Burnt Offering), and shall pour out the rest of the dahm thereof at the base of the Mizbe'ach; ");
INSERT INTO engojb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","And he shall remove all the chelev (fat) thereof, just as the chelev (fat) of the keves (lamb) is taken away from the zevach hashelamim (sacrifice of the peace offerings); and the kohen shall burn them upon the Mizbe'ach, according to the offerings made by eish unto Hashem; and the kohen shall make kapporah for his chattat (sin) that he hath sinned, and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","And if a nefesh sin, after he hears a public adjuration to give testimony, and he is an ed (witness), whether he hath seen or known of it; if he does not utter it, then he shall bear his avon (iniquity). ");
INSERT INTO engojb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Or if a nefesh touch anything tamei (unclean), whether it be a nivlat chayyah teme'ah (carcass of an unclean beast), or a nivlat behemah teme'ah (carcass of unclean livestock), or the nivlat sheretz tamei (carcass of unclean creeping things), and if it be hidden from him; he also shall be tamei, and guilty. ");
INSERT INTO engojb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Or if he touch the tum'at adam (uncleanness of man), whatsoever tumah it be that a man shall be made unclean therewith, and it be hid from him; when he knoweth of it, then he shall be guilty. ");
INSERT INTO engojb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Or if a nefesh swear, rashly pronouncing with his lips to do harah, or to do hatov, whatsoever it be that a man shall pronounce with a shevuah (oath), and it be hid from him; when he knoweth of it, then he shall be guilty in one of these. ");
INSERT INTO engojb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","And it shall be, when he shall be guilty in one of these things, that v'hitvaddah (he shall confess) that he hath sinned in that thing; ");
INSERT INTO engojb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","And he shall bring his asham (penalty, trespass offering) unto Hashem for his chattat (sin) which he hath sinned, a nekevah from the flock, a lamb or a female goat, for a chattat (sin offering); and the kohen shall make kapporah for him concerning his chattat. ");
INSERT INTO engojb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","And if he be not able to afford a seh (lamb), then he shall bring for his asham (guilt offering), which he hath sinned, two turtledoves, or two young pigeons, unto Hashem; one for a chattat (sin offering), and the other for an olah (burnt offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","And he shall bring them unto the kohen, who shall offer that which is for the chattat (sin offering) first, and wring off his head from his neck, but shall not separate it; ");
INSERT INTO engojb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","And he shall sprinkle of the dahm of the chattat (sin offering) upon the side of the Mizbe'ach; and the rest of the dahm shall be pressed out at the base of the Mizbe'ach; it is a chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","And he shall offer the second for an olah (burnt offering), according to the mishpat (prescribed manner); and the kohen shall make kapporah for him for his chattat (sin) which he hath sinned, and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","But if he be not able to afford two turtledoves, or two young pigeons, then he that sinned shall bring for his korban the tenth part of an ephah of fine flour for a chattat (sin offering); he shall put no shemen upon it, neither shall he put any incense thereon; for it is a chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Then shall he bring it to the kohen, and the kohen shall take his handful of it, even a memorial portion thereof, and burn it on the Mizbe'ach, according to the offerings made by eish unto Hashem; it is a chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","And the kohen shall make kapporah for him as touching his chattat (sin) that he hath sinned in one of these, and it shall be forgiven him; and the remnant shall be the kohenʼs, like the minchah. ");
INSERT INTO engojb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","If a nefesh commit a ma'al (trespass), and sin through ignorance (unintentionally), in the holy things of Hashem; then he shall bring for his asham unto Hashem a ram tamim out of the flocks, with thy estimation by shekels of kesef, after the Shekel HaKodesh (the Shekel of the Sanctuary), for an asham (trespass or guilt offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","And he shall make restitution in regard to the holy thing in which he was remiss, and shall add the fifth part thereto, and give it unto the kohen; and the kohen shall make kapporah for him with the ram of the asham (trespass offering), and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","And if a nefesh sin, and commit any of these things which are forbidden to be done by the mitzvot Hashem; though he know it not, yet he is guilty, and shall bear his avon (iniquity). ");
INSERT INTO engojb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","And he shall bring a ram tamim out of the flock, with thy estimation, for an asham (trespass offering) unto the kohen; and the kohen shall make kapporah for him concerning his ignorance wherein he erred and knew it not and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is an asham (trespass offering); he hath certainly trespassed against Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","If a nefesh sin, and commit a ma'al (trespass) against Hashem, and deceives his neighbor in that which was delivered him to keep, or entrusted to his care, or in a thing stolen, or hath cheated his neighbor; ");
INSERT INTO engojb_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","Or have found that which was lost, and lieth concerning it, and sweareth with sheker (falsely); in any of all these that a man doeth, sinning therein; ");
INSERT INTO engojb_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","Then it shall be, because he hath sinned, and is ashem (guilty), that he shall return that which he had stolen, or the thing which he hath extorted, or that which was delivered unto his trust, or the lost thing which he found, ");
INSERT INTO engojb_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Or all that about which he hath sworn lasheker (falsely); he shall even restore it in the principal, and shall add the fifth part more thereto, and give it unto him to whom it appertaineth, in the day of his asham (trespass offering). ");
INSERT INTO engojb_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","And he shall bring his asham (trespass offering) unto Hashem, a ram tamim (without blemish) out of the flock, with thy estimation, for an asham (trespass offering), unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","And the kohen shall make kapporah for him before Hashem; and it shall be forgiven him for anything of all that he hath done that made him guilty. ");
INSERT INTO engojb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Command Aharon and his Banim, saying, This is the Torat HaOlah: It is the olah (burnt offering) that is to stay on the flame upon the Mizbe'ach kol halailah unto the boker, and the eish of the Mizbe'ach must be burning on it. ");
INSERT INTO engojb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","And the kohen shall put on his linen tunic, and his linen breeches shall he put upon his basar, and remove the ashes which the eish hath consumed with the olah (burnt offering) on the Mizbe'ach, and he shall put them beside the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","And he shall take off his garments, and put on begadim acherim (other garments), and carry forth the ashes outside the machaneh unto a makom tahor. ");
INSERT INTO engojb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","And the eish upon the Mizbe'ach shall be burning in it; it must not go out; and the kohen shall burn wood on it every boker, and arrange the olah (burnt offering) upon it; and he must burn thereon the chelvei HaShelamim (fat of the peace offerings). ");
INSERT INTO engojb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","The eish must ever be burning upon the Mizbe'ach; it shall never go out. ");
INSERT INTO engojb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","And this is the Torat HaMinchah: the Bnei Aharon shall offer it before Hashem, before the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","And he shall take of it his handful, of the flour of the minchah, and of the shemen thereof, and all the incense which is upon the minchah, and shall burn it upon the Mizbe'ach for a re'ach nicho'ach, even the memorial portion of it, unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","And the remainder thereof shall Aharon and his Banim eat: with matzot shall it be eaten in the makom kadosh; in the khatzer (courtyard) of the Ohel Mo'ed they shall eat it. ");
INSERT INTO engojb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","It shall not be baked with chametz. I have given it unto them for their chelek (allotted share, portion) of My offerings made by eish; it is kodesh kodashim, like the chattat (sin offering), and like the asham (trespass offering). ");
INSERT INTO engojb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Any of the zachar among the Bnei Aharon shall eat of it. It shall be a chok olam in your dorot concerning the offerings of Hashem made by eish; every one that toucheth them shall be kadosh. ");
INSERT INTO engojb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","This is the korban of Aharon and of his Banim, which they shall offer unto Hashem in the Yom Himmashach (Day he is anointed, i.e., assumes office, seven-day ordination); the tenth part of an ephah of fine flour for a continual minchah, half of it in the boker, and half thereof at erev. ");
INSERT INTO engojb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","In a pan it shall be made with shemen; and when it is scalded, thou shalt bring it in; and the repeatedly baked minchah, broken in pieces, shalt thou offer for a re'ach nicho'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","And the kohen of his Banim that is hamoshiach (the anointed) to succeed him shall offer it; it is a chok olam unto Hashem; it shall be completely burned. ");
INSERT INTO engojb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","For every minchah for the kohen shall be completely burned; it shall not be eaten. ");
INSERT INTO engojb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Speak unto Aharon and to his Banim, saying, This is the Torat HaChattat: In the place where the olah (burnt offering) is slaughtered (shachat) shall the chattat (sin offering) be slaughtered before Hashem; it is kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","The kohen that offereth it for sin shall eat it; in the makom kadosh shall it be eaten, in the khatzer (courtyard) of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Everything that touches the basar thereof shall be kadosh; and when there is sprinkled of the dahm thereof upon any garment, thou shalt wash that whereon it was sprinkled in the makom kadosh. ");
INSERT INTO engojb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","But the clay keli (vessel) wherein it is boiled must be broken; and if it be boiled in a keli nechoshet (copper vessel), it shall be both scoured, and rinsed in mayim. ");
INSERT INTO engojb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Any of the zachar among the kohanim shall eat thereof; it is kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","And no chattat (sin offering), whereof any of the dahm is brought into the Ohel Mo'ed to make kapporah therewith in the Kodesh (holy place), shall be eaten; it shall be burned in the eish. ");
INSERT INTO engojb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Likewise this is the Torat HaAsham: it is kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","In the place where they slaughter (shachat) the olah (burnt offering) shall they slaughter the asham (trespass offering); and the dahm thereof shall he sprinkle around upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","And he shall offer of it all the chelev thereof; the tail, and the chelev that covereth the innards, ");
INSERT INTO engojb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","And the two kidneys, and the chelev that is on them, which is on the flanks, and the diaphragm that is above the liver, with the kidneys, it shall he remove; ");
INSERT INTO engojb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","And the kohen shall burn them upon the Mizbe'ach for an offering made by eish unto Hashem; it is an asham (trespass offering). ");
INSERT INTO engojb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every zachar among the kohanim shall eat thereof; it shall be eaten in the makom kadosh; it is kodesh kodashim. ");
INSERT INTO engojb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","As the chattat (sin offering) is, so is the asham (trespass offering); there is one torah for them both; the kohen that maketh kapporah therewith shall have it. ");
INSERT INTO engojb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","And the kohen that offereth any manʼs olah the kohen shall have for himself the hide of the olah which he hath offered. ");
INSERT INTO engojb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","And all the minchah that is baked in the oven, and all that is prepared in the deep pan, and in the shallow pan, shall be the kohenʼs that offereth it. ");
INSERT INTO engojb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","And every minchah, mixed with shemen, or dry, shall all the Bnei Aharon have, each equal with achiv (his brother). ");
INSERT INTO engojb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","And this is the Torat Zevach HaShelamim, which he shall offer unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If he offer it for a todah, then he shall offer with the zevach hatodah challos matzot mixed with shemen, and matzot wafers anointed with shemen, and challos mixed with scalded fine flour mixed with shemen. ");
INSERT INTO engojb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Besides the challos, he shall offer for his korban lechem chametz with the zevach todah of his shelamim. ");
INSERT INTO engojb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","And of it he shall offer one cake from each korban for a terumah (contribution) unto Hashem, and it shall be the kohenʼs that sprinkleth the dahm of the shelamim (peace offerings). ");
INSERT INTO engojb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","And the basar of the zevach todat shelamim of him shall be eaten the same day that it is offered; he shall not leave any of it until the boker. ");
INSERT INTO engojb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","But if the zevach of his korban be a neder, or a nedavah, it shall be eaten the same day that he offereth his zevach; and on the following day also the remainder of it shall be eaten; ");
INSERT INTO engojb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","But the remainder of the basar of the zevach on the yom hashelishi shall be burned with eish. ");
INSERT INTO engojb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","And if any of the basar of the zevach of his shelamim be eaten at all on the yom hashelishi, it shall not be accepted, neither shall it be imputed (credited) unto him that offereth it; it shall be piggul, and the nefesh that eateth of it shall have his avon to bear. ");
INSERT INTO engojb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","And the basar that toucheth any thing tamei shall not be eaten; it shall be burned with eish; and as for the basar, all that be tahor shall eat thereof. ");
INSERT INTO engojb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But the nefesh that eateth of the basar of the zevach hashelamim, that pertain unto Hashem, having his tumah upon him, even that nefesh shall be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Moreover the nefesh that shall touch any thing tamei, as the tumat adam (uncleanness of man, human contamination), or any behemah temeiah (contaminated animal carcass)  or sheketz tamei (unclean abomination), and eat of the basar of the zevach hashelamim which pertain unto Hashem, even that nefesh shall be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Speak unto the Bnei Yisroel, saying, Ye shall eat no manner of chelev, of ox, or of sheep, or of goat. ");
INSERT INTO engojb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","And the chelev of the nevelah, the beast that dieth of itself, and the chelev of the terefah, may be used in any other use; but ye shall in no wise eat of it. ");
INSERT INTO engojb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","For whosoever eateth the chelev of the behemah, of which men offer an offering made by eish unto Hashem, even the nefesh that eateth it shall be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Moreover ye shall eat no manner of dahm, whether it be of fowl or of beast, in any of your moshevot (dwellings). ");
INSERT INTO engojb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Whatsoever nefesh it be that eateth any manner of dahm, even that nefesh shall be cut off from his people. ");
INSERT INTO engojb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Speak unto the Bnei Yisroel, saying, He that offereth the zevach shelamim of him unto Hashem shall bring his korban unto Hashem of the zevach shelamim of him. ");
INSERT INTO engojb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","His own hands shall bring the offerings of Hashem made by eish, the chelev with the breast, it shall he bring, that the breast may be waved for a tenufah before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","And the kohen shall burn the chelev upon the Mizbe'ach; but the breast shall belong to Aharon and his Banim. ");
INSERT INTO engojb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","And the right thigh shall ye give unto the kohen for a terumah (raised up offering) of the zevakhim of your shelamim. ");
INSERT INTO engojb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","He among the Bnei Aharon, that offereth the dahm hashelamim and the chelev (fat), shall have the right thigh for his part. ");
INSERT INTO engojb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","For the breast of the waving (tenufah) and the thigh of the terumah (raising) I have taken of the Bnei Yisroel from the zevakhim of their shelemim, and have given them unto Aharon the kohen and unto his Banim by a chok olam from among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the anointed portion of Aharon, and the anointed portion of his Banim, out of the offerings of Hashem made by eish, in the day when he presented them to minister unto Hashem in the kohenʼs office; ");
INSERT INTO engojb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Which Hashem commanded to be given them of the Bnei Yisroel, in the day that He anointed them, by a chukkat olam throughout their dorot. ");
INSERT INTO engojb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the torah of the olah (burnt offering), of the minchah (grain offering), and of the chattat (sin offering), and of the asham (trespass offering), and of the ordination offerings, and of the zevach hashelamim (sacrifice of the peace offerings); ");
INSERT INTO engojb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Which Hashem commanded Moshe on Mt. Sinai, in the day that He commanded the Bnei Yisroel to offer their korbanot unto Hashem, in the Sinai Desert. ");
INSERT INTO engojb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Take Aharon and his Banim with him, and the garments, and the shemen hamishchah (anointing oil), and a bull for the chattat (sin offering), and two rams, and a basket of matzot; ");
INSERT INTO engojb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","And gather thou Kol HaEdah together unto the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","And Moshe did as Hashem commanded him; and HaEdah (the Assembly) was gathered together unto the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","And Moshe said unto HaEdah, This is the thing which Hashem commanded to be done. ");
INSERT INTO engojb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","And Moshe brought Aharon and his Banim, and immersed them with mayim. ");
INSERT INTO engojb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","And he put upon him the Kesones, and girded him with the Avnet (Sash), and clothed him with the Me'il (Robe), and put the Ephod upon him, and he girded him with the Cheishev (Belt) of the Ephod, and fastened it unto him therewith. ");
INSERT INTO engojb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","And he put the Choshen (Breastplate) upon him; also he put in the Choshen the Urim and the Tummim. ");
INSERT INTO engojb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","And he put the Mitznefet (Turban) upon his head; also upon the Mitznefet (Turban) toward his face did he put the Tzitz HaZahav, the Nezer Hakodesh (Holy Diadem); as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","And Moshe took the Shemen HaMishchah, and anointed the Mishkan (Tabernacle) and all that was therein and he set them apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","And he sprinkled thereof upon the Mizbe'ach seven times, and anointed the Mizbe'ach and all its utensils, both the Kiyor (Laver) and its stand, to set them apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","And he poured of the Shemen HaMishchah upon Aharonʼs head, and anointed him, to set him apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","And Moshe brought the Bnei Aharon, and put Kuttonot upon them, and girded them with Sashes, and put Migba'ot (headbands) upon them; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","And he brought the bull for the chattat (sin offering); and Aharon and his Banim laid their hands upon the head of the bull for the chattat (sin offering). ");
INSERT INTO engojb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","And he slaughtered (shachat) it; and Moshe took the dahm, and put it upon the horns of the Mizbe'ach around with his forefinger, and purified the Mizbe'ach, and poured the dahm at the base of the Mizbe'ach, and set it apart as kodesh, to make kapporah for it. ");
INSERT INTO engojb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","And he took all the chelev (fat) that was upon the innards, and the diaphragm above the liver, and the two kidneys, and their chelev (fat), and Moshe burned it upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the bull, and its hide, its basar, and its dung, he burned with eish outside the machaneh; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","And he brought the ram for the olah (burnt offering); and Aharon and his Banim laid their hands upon the head of the ram. ");
INSERT INTO engojb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","And he slaughtered (shachat) it; and Moshe sprinkled the dahm upon the Mizbe'ach around. ");
INSERT INTO engojb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","And he cut the ram into pieces; and Moshe burned the head, and the pieces, and the chelev (fat). ");
INSERT INTO engojb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","And he washed the innards and the legs in mayim; and Moshe burned the whole ram upon the Mizbe'ach; it was an olah for a re'ach nicho'ach, and an offering made by eish unto Hashem; just as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","And he brought the other ram, the ram of ordination; and Aharon and his Banim laid their hands upon the head of the ram. ");
INSERT INTO engojb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","And he slaughtered (shachat) it; and Moshe took of the dahm of it, and put it upon the lobe of Aharonʼs right ear, and upon the thumb of his right hand, and upon the bohen of his right foot. ");
INSERT INTO engojb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","And he brought Aharonʼs Banim, and Moshe put of the dahm upon the lobe of their right ear, and upon the thumbs of their right hands, and upon the bohen of their right feet: and Moshe sprinkled the dahm upon the Mizbe'ach around. ");
INSERT INTO engojb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","And he took the chelev (fat), and the tail, and all the chelev (fat) that was upon the innards, and the diaphragm above the liver, and the two kidneys, and their chelev (fat), and the right thigh: ");
INSERT INTO engojb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","And out of the basket of matzot, that was before Hashem, he took one challat matzot, and a loaf of oiled lechem, and one wafer, and put them on the chalavim, and upon the right thigh: ");
INSERT INTO engojb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","And he put all upon Aharonʼs hands, and upon the hands of his Banim, and waved them for a tenufah (wave offering) before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","And Moshe took them from off their hands, and burned them on the Mizbe'ach upon the olah (burnt offering); they were ordination offerings for a re'ach nicho'ach; it is an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","And Moshe took the breast, and waved it for a tenufah before Hashem: it was Mosheʼs share of the ram of ordination; just as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","And Moshe took of the shemen hamishchah, and of the dahm which was upon the Mizbe'ach, and sprinkled it upon Aharon, and upon his garments, and upon his Banim, and upon the garments of his Banim with him; and he set apart as kodesh Aharon, and his garments, and his Banim, and the garments of his Banim with him. ");
INSERT INTO engojb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","And Moshe said unto Aharon and to his Banim, Cook the basar at the entrance of the Ohel Mo'ed: and there eat it with the lechem that is in the basket of ordination offerings, as I commanded, saying, Aharon and his Banim shall eat it. ");
INSERT INTO engojb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","And that which remaineth of the basar and of the lechem shall ye burn with eish. ");
INSERT INTO engojb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","And ye shall not go out of the entrance of the Ohel Mo'ed in seven days, until the days of your ordination be at an end: for seven days shall he fill your hand. ");
INSERT INTO engojb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","As he hath done this day, so Hashem hath commanded to do, to make kapporah for you. ");
INSERT INTO engojb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Therefore shall ye abide at the entrance of the Ohel Mo'ed yomam valailah seven days and be shomer over the mishmeret (charge) of Hashem, that ye die not: for so I have been commanded. ");
INSERT INTO engojb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aharon and his Banim did all things which Hashem commanded by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","And it come to pass on yom hashemini, that Moshe called to Aharon and his Banim, and the Ziknei Yisroel; ");
INSERT INTO engojb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","And he said unto Aharon, Take thee a young calf for a chattat (sin offering), and a ram for an olah (burnt offering), temimim (without blemish), and offer them before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","And unto the Bnei Yisroel thou shalt speak, saying, Take ye a sa'ir izzim (male goat) for a chattat (sin offering); and a calf and a keves (lamb), both of the first year, temimim (without blemish), for an olah; ");
INSERT INTO engojb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Also a bull and a ram for shelamim (peace offerings), to sacrifice before Hashem; and a minchah mixed with shemen; for today Hashem will appear unto you. ");
INSERT INTO engojb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","And they brought that which Moshe commanded before the Ohel Mo'ed; and kol HaEdah drew near and stood before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","And Moshe said, This is the thing which Hashem commanded that ye should do; and the kavod Hashem shall appear unto you. ");
INSERT INTO engojb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","And Moshe said unto Aharon, Go unto the Mizbe'ach, and offer thy chattat (sin offering), and thy olah (burnt offering), and make kapporah for thyself, and for the people; and offer the korban of the people, and make kapporah for them; just as Hashem commanded. ");
INSERT INTO engojb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aharon therefore went unto the Mizbe'ach, and slaughtered (shachat) the calf of the chattat (sin offering), which was for himself. ");
INSERT INTO engojb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","And the Bnei Aharon brought the dahm unto him; and he dipped his forefinger in the dahm, and put it upon the horns of the Mizbe'ach, and poured out the dahm at the foundation of the Mizbe'ach; ");
INSERT INTO engojb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","But the chelev (fat), and the kidneys, and the diaphragm with the liver of the chattat (sin offering), he burned upon the Mizbe'ach; just as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","And the basar and the hide he burned with eish outside the machaneh. ");
INSERT INTO engojb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","And he slaughtered (shachat) the olah (burnt offering); and the Bnei Aharon presented unto him the dahm, which he sprinkled around upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","And they presented the olah (burnt offering) unto him, with the pieces thereof, and the head; and he burned them upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","And he did wash the innards and the legs, and burned them upon the olah (burnt offering) on the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","And he brought the korban HaAm (the offering of the people), and took the goat of the chattat (sin offering) for the people, and slaughtered (shachat) it, and offered it for sin, as before. ");
INSERT INTO engojb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","And he brought the olah (burnt offering), and offered it in the prescribed way. ");
INSERT INTO engojb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","And he brought the minchah, and took a handful thereof, and burned it upon the Mizbe'ach, in addition to the olah of the boker. ");
INSERT INTO engojb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","He slaughtered (shachat) also the bull and the ram for a zevach which was for the people; and the Bnei Aharon presented unto him the dahm, which he sprinkled upon the Mizbe'ach around, ");
INSERT INTO engojb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","And the chalavim (fat portions) of the bull and of the ram, the tail, and that which covereth the innards, and the kidneys, and the diaphragm above the liver; ");
INSERT INTO engojb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","And they put the chalavim (fat) upon the breasts, and he burned the chalavim upon the Mizbe'ach; ");
INSERT INTO engojb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","And the breasts and the right thigh Aharon waved for a tenufah (wave offering) before Hashem; just as Moshe commanded. ");
INSERT INTO engojb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","And Aharon lifted up his hand toward the people, and pronounced a bracha upon them, and came down from offering of the chattat (sin offering), and the olah (burnt offering), and shelamim (peace offerings). ");
INSERT INTO engojb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","And Moshe and Aharon went into the Ohel Mo'ed, and came out, and pronounced a bracha over the people; and the kavod Hashem appeared unto kol HaAm. ");
INSERT INTO engojb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","And there came an eish out from before Hashem, and consumed upon the Mizbe'ach the olah (burnt offering) and the chalavim (fat portions); which when all the people saw, they shouted, and fell on their faces. ");
INSERT INTO engojb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","And Nadav and Avihu, the bnei Aharon, each took his censer, and put eish therein, and put ketoret (incense) thereon, and offered eish zarah (strange, unauthorized fire) before Hashem, which He commanded them not. ");
INSERT INTO engojb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","And there went out eish (fire) from the presence of Hashem, and devoured them, and they died before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moshe said unto Aharon, This is it that Hashem spoke, saying, I will show Myself kadosh among them that come near Me, and before kol HaAm (all the People) I will be honored. And Aharon was silent. ");
INSERT INTO engojb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","And Moshe called Mishael and Eltzaphan, the bnei Uzziel the dod (uncle) of Aharon, and said unto them, Come near, carry your brethren from before the Kodesh to the outside of the machaneh. ");
INSERT INTO engojb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they went near, and carried them in the kuttanot of them out of the machaneh; as Moshe had said. ");
INSERT INTO engojb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","And Moshe said unto Aharon, and unto El'azar and unto Itamar, his banim, Don't uncover your head, neither rend your clothes; lest ye die, and lest wrath come upon kol HaEdah; but let your brethren, the kol Bais Yisroel, bewail the burning which Hashem hath kindled. ");
INSERT INTO engojb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","And ye shall not go out from the entrance of the Ohel Mo'ed, lest ye die; for the shemen mishchat (anointing oil) of Hashem is upon you. And they did according to the word of Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","And Hashem spoke unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Do not drink yayin nor strong drink, thou, nor thy banim with thee, when ye go into the Ohel Mo'ed, lest ye die; it shall be chukkat olam throughout your generations; ");
INSERT INTO engojb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","And that ye may put difference between kodesh and chol (common, profane), and between tameh (unclean) and tahor (clean); ");
INSERT INTO engojb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","And that ye may teach the Bnei Yisroel all the chukkim which Hashem hath spoken unto them by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","And Moshe spoke unto Aharon, and unto El'azar and unto Itamar, his banim that were left, Take the minchah that remaineth of the offerings of Hashem made by eish, and eat it unleavened etzel Mishlei 8:30 beside the Mizbe'ach; for it is kodesh kodashim; ");
INSERT INTO engojb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","And ye shall eat it in the makom kadosh, because it is the chok (share, portion) of thee and thy banim, of the sacrifices of Hashem made by eish; for so I am commanded. ");
INSERT INTO engojb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","And the breast of the waving and raised up thigh shall ye eat in a makom tahor; thou, and thy banim, and thy banot with thee; for they are thy chok, and the chok of thy banim, which are given out of the zevakhim of shelamim (peace offerings) of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The raised-up thigh and the breast of the waving shall they bring with the offerings made by eish of the chalavim (fat portions), to wave it for a wave offering before Hashem; and it shall be thine, and unto thy banim with thee, by a chok olam (portion forever); as Hashem hath commanded. ");
INSERT INTO engojb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","And Moshe diligently inquired about the se'ir of the chattat, and, hinei, it was burned up; and he was angry with El'azar and Itamar, the bnei Aharon which were left alive, saying, ");
INSERT INTO engojb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Why have ye not eaten the chattat in the makom hakodesh, seeing it is kodesh kodashim, and G-d hath given it you to bear away the avon HaEdah, to make kapporah for them before Hashem? ");
INSERT INTO engojb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Since the dahm of it was not brought in within HaKodesh, ye should indeed have eaten it in the Kodesh, as I commanded. ");
INSERT INTO engojb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","And Aharon said unto Moshe, See, today have they offered their chattat (sin offering) and their olah (burnt offering) before Hashem; and such things have befallen me; and if I had eaten the chattat today, should it have been accepted in the sight of Hashem? ");
INSERT INTO engojb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","And when Moshe heard that, he was satisfied. ");
INSERT INTO engojb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","And Hashem spoke unto Moshe and to Aharon, saying unto them, ");
INSERT INTO engojb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Speak unto the Bnei Yisroel, saying, These are the beasts which ye shall eat among all the beasts that are on ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Whatsoever spliteth the hoof, and separateth into double hooves, and cheweth the cud, among the behemah (animals), that shall ye eat. ");
INSERT INTO engojb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Nevertheless these shall ye not eat of them that chew the cud, or of them that separateth the hoof; as the gamal (camel), because he cheweth the cud, but separateth not the hoof; he is tamei unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","And the rock badger: he cheweth the cud, but separateth not the hoof; he is tamei unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","And the arnevet, because he cheweth the cud, but separateth not the hoof; he is temeiah (unclean) unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","And the chazir (swine), though he separate the hoof, and be separated into double hooves, yet he cheweth not the cud; he is tamei to you. ");
INSERT INTO engojb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Of their basar shall ye not eat, and their nevelah shall ye not touch; they are temei'im (unclean ones) to you. ");
INSERT INTO engojb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","These shall ye eat of all that are in the mayim; whatsoever hath fins and scales in the mayim, in the seas, and in the rivers, them shall ye eat. ");
INSERT INTO engojb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","And all that have not fins and scales in the seas, and in the rivers, of all that swarm in the mayim, and of any nefesh hachayyah which is in the mayim, they shall be sheketz (abomination, detestable) unto you; ");
INSERT INTO engojb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","They shall be even sheketz unto you; ye shall not eat of their basar, but ye shall have their nevelah in sheketz. ");
INSERT INTO engojb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Whatsoever hath no fins nor scales in the mayim, that shall be sheketz unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","And these are they which ye shall have in sheketz among the fowls; they shall not be eaten, they are sheketz: the nesher (eagle), and the vulture, and the white-tailed eagle, ");
INSERT INTO engojb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","And the da'ah (kite), and the black kite after its kind; ");
INSERT INTO engojb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Every orev (raven) after its kind; ");
INSERT INTO engojb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","And the ostrich, and the screech owl, and the seagull, and the hawk after its kind, ");
INSERT INTO engojb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","And the little owl, and the cormorant, and the great owl, ");
INSERT INTO engojb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","And the white owl, and the pelican, and the osprey, ");
INSERT INTO engojb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","And the stork, the heron after its kind, and the hoopoe, and the bat. ");
INSERT INTO engojb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","All flying insects that creep, going upon all fours, shall be sheketz unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yet these may ye eat of every winged insect that goeth upon all fours, which have jumping legs above their feet, to hop withal upon ha'aretz; ");
INSERT INTO engojb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Even these of them ye may eat: the arbeh (locust) after its kind, and the katydid after its kind, and the cricket after its kind, and the grasshopper after its kind. ");
INSERT INTO engojb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But all other winged insects, which have four feet, shall be sheketz unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","And for these ye shall be temei'im; whosoever toucheth the nevelah of them shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","And whosoever pick up any of the nevelah of them shall wash his clothes, and be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Every beast which spliteth the hooves, and is not completely split, nor cheweth the cud, are temei'im unto you; every one that toucheth them shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","And whatsoever goeth upon its paws, among all manner of beasts that go on all fours, those are temei'im unto you; whosoever toucheth their nevelah shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","And he that beareth the nevelah of them shall wash his clothes, and be tamei until erev; they are temei'im unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","These also shall be tamei unto you among the creeping things that creep upon ha'aretz: the weasel, and the rat, and the great lizard after its kind, ");
INSERT INTO engojb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","And the gecko, and the land crocodile, and the skink, and the lizard, and the chameleon. ");
INSERT INTO engojb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These are temei'im to you among all that creep; whosoever doth touch them, when they be dead, shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","And whatsoever of them, when they are dead, doth fall on something, it shall be tamei; whether it be any vessel of wood, or cloth, or hide, or sackcloth, whatsoever vessel it be, wherein any melachah (work) is done, it must be put into mayim, and it shall be tamei until erev; then it shall be tahor (clean). ");
INSERT INTO engojb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","And every clay vessel, whereinto any of them falleth, whatsoever is in it shall be tamei; and ye shall break it. ");
INSERT INTO engojb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Of all okhel which may be eaten, that on which such mayim cometh shall be tamei; and all mashkeh that may be drunk in every such vessel shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","And everything whereupon any part of their nevelah falleth shall be tamei; whether it be oven, or stove, they shall be broken; for they are temei'im and shall be temei'im unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nevertheless a spring or cistern, wherein there is a mikveh mayim (collection of water) shall be tahor; but that which toucheth their nevelah shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","And if any part of their nevelah fall upon any zera for sowing which is to be sown, it shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if any mayim be put upon the zera, and any part of their nevelah fall thereon, it shall be tamei unto you. ");
INSERT INTO engojb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","And if any behemah, of which ye may eat, die, he that toucheth the nevelah thereof shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","And he that eateth of the nevelah of it shall wash his clothes, and be tamei until erev; he also that picketh up the nevelah of it shall wash his clothes, and be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","And every creeping thing that creepeth upon ha'aretz shall be sheketz; it shall not be eaten. ");
INSERT INTO engojb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Whatsoever goeth upon the belly, and whatsoever goeth upon all fours, or whatsoever hath marbeh raglayim (many feet) among all creeping things that creep upon ha'aretz, them ye shall not eat; for they are sheketz. ");
INSERT INTO engojb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ye shall not make your nefashot sheketz with any creeping thing that creepeth, neither shall ye make yourselves tamei with them, that ye should be made tamei thereby. ");
INSERT INTO engojb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am Hashem Eloheichem; ye shall therefore set yourselves apart as kadosh, and ye shall be kedoshim; for I am kadosh; neither shall ye make your nefashot tamei with any manner of creeping thing that creepeth upon ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am Hashem that bringeth you up out of Eretz Mitzrayim, to be for you as Elohim: ye shall therefore be kedoshim, for I am kadosh. ");
INSERT INTO engojb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the torah concerning the beasts, and of the fowl, and of every living creature that moveth in the mayim, and of every creature that creepeth upon ha'aretz; ");
INSERT INTO engojb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","To make a divide between the tamei and the tahor, and between the beast that may be and the beast that may not be eaten. ");
INSERT INTO engojb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Speak unto the Bnei Yisroel, saying, If an isha have conceived, and born a zachar, then she shall be temeiah shivat yamim; according to the yamim of the niddah (menstruation separation) for her infirmity shall she be temeiah (unclean). ");
INSERT INTO engojb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","And in the yom hashemini the basar of his arel (uncircumcision, foreskin) shall be circumcised. ");
INSERT INTO engojb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","And shloshim yom ushloshet she shall then remain in demei tohorah (blood of her purifying, i.e., period in which she would be unclean); she shall touch no kodesh, nor enter the Mikdash, until the yamei of her tohorah be fulfilled. ");
INSERT INTO engojb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she bear a nekevah, then she shall be temeiah two weeks, as in her niddah (separation); and she shall remain in the blood of her tohorah sixty-six days. ");
INSERT INTO engojb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","And when the yemei tohorah are fulfilled, for a ben, or for a bat, she shall bring a keves of the first year for an olah, and a young pigeon, or a turtledove, for a chattat (sin offering), unto the entrance of the Ohel Mo'ed unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Who shall offer it before Hashem, and make kapporah for her; and she shall be cleansed from the issue of her dahm. This is the torah for her that hath born a zachar or a nekevah. ");
INSERT INTO engojb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","And if she be not able to afford to bring a seh, then she shall bring two turtledoves, or two young pigeons; the one for an olah, and the other for a chattat; and the kohen shall make kapporah for her, and she shall be teherah (clean). ");
INSERT INTO engojb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","And Hashem spoke unto Moshe and Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","When a man shall have in the skin of his basar a swelling, a scab, or bright spot, and it be in the skin of his basar like the nega tzara'at; then he shall be brought unto Aharon the kohen, or unto one of his Banim the kohanim; ");
INSERT INTO engojb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","And the kohen shall examine the nega in the skin of the basar; and when hair in the nega is turned white, and the nega in appearance be deeper than the skin of his basar, it is a nega tzara'at; and the kohen shall examine him, and pronounce him tamei. ");
INSERT INTO engojb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","If the bright spot be white in the skin of his basar, and in appearance be not deeper than the skin, and the hair thereof be not turned white, then the kohen shall quarantine him that hath the nega shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","And the kohen shall examine him on the yom hashevi'i; and, hinei, if the nega in his sight be unchanged, and the nega spread not in the skin; then the kohen shall quarantine him another shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","And the kohen shall examine him again on the yom hashevi'i; and, hinei, if the nega be somewhat faded, and the nega spread not in the skin, the kohen shall pronounce him tahor; it is but a scab; and he shall wash his clothes, and be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the scab spread much abroad in the skin, after that he hath shown himself to the kohen for his tohorah, he shall appear before the kohen again. ");
INSERT INTO engojb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","And if the kohen see that, hinei, the scab spreadeth in the skin, then the kohen shall pronounce him tamei; it is a tzara'at. ");
INSERT INTO engojb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When the nega tzara'at is in a man, then he shall be brought unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","And the kohen shall examine him; and, hinei, if the swelling be white in the skin, and it have turned the hair white, and there be raw basar in the swelling; ");
INSERT INTO engojb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","It is an old tzara'at in the skin of his basar, and the kohen shall pronounce him tamei, and shall not quarantine him; for he is tamei. ");
INSERT INTO engojb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","And if a tzara'at break out abroad in the skin, and the tzara'at cover all the skin of him that hath the nega from his head even to his foot, wheresoever the kohen looketh, ");
INSERT INTO engojb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Then the kohen shall consider; and, hinei, if the tzara'at have covered all his basar, he shall pronounce him tahor that hath the nega; it is all turned white; he is tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But on the day when raw basar appeareth in him, he shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","And the kohen shall see the raw basar, and pronounce him to be tamei; for the raw basar is tamei; it is a tzara'at. ");
INSERT INTO engojb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Or if the raw basar turn again, and be changed unto white, he shall come unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","And the kohen shall see him; and, hinei, if the nega be turned into white, then the kohen shall pronounce him tahor that hath the nega; he is tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","The basar also, in which, even in the skin thereof, was a boil, and is healed, ");
INSERT INTO engojb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","And in the place of the boil there be a white swelling, or a bright spot, white, and somewhat reddish, and it be shown to the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","And if, when the kohen examine it, hinei, it be in appearance deeper than the skin, and the hair thereof be turned white; the kohen shall pronounce him tamei; it is a nega tzara'at broken out of the boil. ");
INSERT INTO engojb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if the kohen examine it, and, hinei, there be no white hair therein, and if it be not deeper than the skin, but be somewhat faded, then the kohen shall quarantine him shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","And if it spread much abroad in the skin, then the kohen shall pronounce him tamei; it is a nega. ");
INSERT INTO engojb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright spot stay in its place, and spread not, it is a burning boil; and the kohen shall pronounce him tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Or if there be any basar, in the skin whereof there is a hot burning, and the raw basar that burneth have a white bright spot, somewhat reddish, or white, ");
INSERT INTO engojb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Then the kohen shall examine it; and, hinei, if the hair in the bright spot be turned white, and it be in appearance deeper than the skin, it is a tzara'at broken out of the burning; therefore the kohen shall pronounce him tamei; it is the nega tzara'at. ");
INSERT INTO engojb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the kohen examine it, and, hinei, there be no white hair in the bright spot, and it be no deeper than the other skin, but be dim, then the kohen shall quarantine him shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","And the kohen shall examine him on the yom hashevi'i; and if it be spread much abroad in the skin, then the kohen shall pronounce him tamei; it is the nega tzara'at. ");
INSERT INTO engojb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","And if the bright spot stay in its place, and spread not in the skin, but it be dim, it is a swelling of the burn, and the kohen shall pronounce him tahor; for it is an inflammation of the burning. ");
INSERT INTO engojb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","If an ish or isha have a nega upon the head or the chin, ");
INSERT INTO engojb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Then the kohen shall examine the nega, and, hinei, if it be in appearance deeper than the skin, and there be in it a yellow thin hair, then the kohen shall pronounce him tamei; it is a scale, even a tzara'at upon the head or chin. ");
INSERT INTO engojb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","And if the kohen examine the nega of the scale, and, hinei, it be not in appearance deeper than the skin, and that there is no black hair in it, then the kohen shall quarantine him that hath the nega of the scale shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","And in the yom hashevi'i the kohen shall examine the nega; and, hinei, if the scale spread not, and there be in it no yellow hair, and the scale be not in appearance deeper than the skin, ");
INSERT INTO engojb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","He shall be shaven, but the scale shall he not shave; and the kohen shall quarantine him that hath the scale another shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","And in the yom hashevi'i the kohen shall examine the scale; and, hinei, if the scale be not spread in the skin, nor be in appearance deeper than the skin, then the kohen shall pronounce him tahor; and he shall wash his clothes, and be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the scale spread much in the skin after his tohorah, ");
INSERT INTO engojb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Then the kohen shall examine him; and, hinei, if the scale be spread in the skin, the kohen need not seek for yellow hair; he is tamei. ");
INSERT INTO engojb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if the scale be in his sight unchanged, and that there is black hair grown up therein; the scale is healed, he is tahor; and the kohen shall pronounce him tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","If an ish also or an isha have in the skin of their basar bright spots, even white bright spots, ");
INSERT INTO engojb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Then the kohen shall examine; and, hinei, if the bright spots in the skin of their basar be faint white, it is a bohak spot that groweth in the skin; he is tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","And the man whose hair is fallen off his head, he is bald; yet is he tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","And he that hath his hair fallen off from the front of his scalp, he is bald at the forehead; yet is he tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","And if there be in the bald head, or bald forehead, a white reddish nega, it is a tzara'at breaking out in his bald head, or his bald forehead. ");
INSERT INTO engojb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Then the kohen shall examine it; and, hinei, if the swelling of the nega be white reddish in his bald head, or in his bald forehead, as the tzara'at appeareth in the skin of the basar, ");
INSERT INTO engojb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","He is an ish tzaru'a, he is tamei; the kohen shall pronounce him utterly tamei; his nega is in his head. ");
INSERT INTO engojb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","And the tzaru'a in whom the nega is, his clothes shall be torn, and his head bare, and he shall put a covering upon his lower face, and shall cry, Tamei! Tamei! ");
INSERT INTO engojb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","All the days wherein the nega shall be in him he shall be tamei; he is tamei; he shall live alone; outside the machaneh shall his moshav be. ");
INSERT INTO engojb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","When a garment has the nega tzara'at in it, whether it be a wool garment, or a linen garment; ");
INSERT INTO engojb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Whether it be in the warp, or woof; of linen, or of wool; whether in a leather, or in anything made of leather; ");
INSERT INTO engojb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","And if the nega be greenish or reddish in the garment, or in the leather, either in the warp, or in the woof, or in any thing of leather, it is a nega tzara'at, and shall be shown unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","And the kohen shall examine the nega, and quarantine it that hath the nega shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","And he shall examine the nega on the yom hashevi'i; if the nega be spread in the garment, either in the warp, or in the woof, or in a leather, or in any work that is made of leather, the nega is a malignant tzara'at; it is tamei. ");
INSERT INTO engojb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He shall therefore burn that garment, whether warp or woof, in wool or in linen, or any thing of leather, wherein the nega is; for it is a malignant tzara'at; it shall be burned in the eish. ");
INSERT INTO engojb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","And if the kohen shall examine, and, hinei, the nega be not spread in the garment, either in the warp, or in the woof, or in anything of leather, ");
INSERT INTO engojb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Then the kohen shall command that they wash the thing wherein the nega is, and he shall quarantine it another shivat yamim; ");
INSERT INTO engojb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","And the kohen shall examine the nega, after that it is washed; and, hinei, if the nega has not changed its appearance, and the nega be not spread, it is tamei; thou shalt burn it in the eish; whether the eating away hath brought bareness in the front or back. ");
INSERT INTO engojb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","And if the kohen examine, and, hinei, the nega be somewhat faded after the washing of it, then he shall tear it out of the garment, or out of the leather, or out of the warp, or out of the woof; ");
INSERT INTO engojb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","And if it appear still in the garment, either in the warp, or in the woof, or in any thing of leather, it is a spreading nega; thou shalt burn that wherein the nega is with eish. ");
INSERT INTO engojb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","And the garment, either warp, or woof, or whatsoever thing of leather it be, which thou shalt wash, if the nega be departed from them, then it shall be washed the second time, and shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the torah of the nega tzara'at in a garment of wool or linen, either in the warp, or woof, or any thing of leather, to pronounce it tahor, or to pronounce it tamei. ");
INSERT INTO engojb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","This shall be the torat hametzora in the yom of his tohorah: he shall be brought unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","And the kohen shall go forth outside the machaneh; and the kohen shall examine, and, hinei, if the nega tzara'at be healed in the afflicted person, ");
INSERT INTO engojb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Then shall the kohen command to take for him that is to be cleansed two birds alive and tehorot (clean ones), and cedar wood, and scarlet thread, and hyssop; ");
INSERT INTO engojb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","And the kohen shall command that one of the birds be shachat in a clay vessel over mayim chayyim (running water); ");
INSERT INTO engojb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","As for the living bird, he shall take it, and the cedar wood, and the scarlet thread, and the hyssop, and shall dip them and the living bird in the dahm of the bird that was killed (shachat) over the mayim chayyim (running water); ");
INSERT INTO engojb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","And he shall sprinkle upon him that is to be made tahor from the tzara'at seven times, and shall pronounce him tahor, and shall release the living bird into the open field. ");
INSERT INTO engojb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","And he that is to be made tahor shall wash his clothes, and shave off all his hair, and wash himself in mayim, that he may be tahor; and after that he shall come into the machaneh, and shall wait outside of his ohel seven days. ");
INSERT INTO engojb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","But it shall be on the yom hashevi'i, that he shall shave all his hair off his head and his beard and his eyebrows, even all his hair he shall shave off; and he shall wash his clothes, also he shall wash his basar in mayim, and he shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","And on the yom hashemini he shall take two kevasim temimim and one ewe lamb of the first year temimah, and three tenths of an ephah of fine flour for a minchah, mixed with shemen, and one log of shemen. ");
INSERT INTO engojb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","And the kohen who purifies shall present the ish that is to be made tahor, and those things, before Hashem, at the entrance of the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","And the kohen shall take one keves (lamb), and sacrifice him for an asham (trespass offering), and the log of shemen, and wave them for a tenufah (wave offering) before Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","And he shall slaughter (shachat) the keves in the place where he shall slaughter (shachat) the chattat (sin offering) and the olah (burnt offering), in the mekom hakodesh; for as the chattat (sin offering) belongs to the kohen, so does the asham (trespass offering); it is kodesh kodashim; ");
INSERT INTO engojb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","And the kohen shall take some of the dahm of the asham (trespass offering), and the kohen shall put it upon the lobe of the right ear of him that is to be made tahor, and upon the thumb of his right hand, and upon the bohen of his right foot; ");
INSERT INTO engojb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","And the kohen shall take some of the log of shemen, and pour it into the palm of his own left hand; ");
INSERT INTO engojb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","And the kohen shall dip his right forefinger in the shemen that is in his left hand, and shall sprinkle of the shemen with his forefinger seven times before Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","And of the rest of the shemen that is in his hand shall the kohen put upon the lobe of the right ear of him that is to be made tahor, and upon the thumb of his right hand, and upon the bohen of his right foot, upon the dahm of the asham (trespass offering); ");
INSERT INTO engojb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","And the remnant of the shemen that is in the kohenʼs hand he shall pour upon the head of him that is to be made tahor; and the kohen shall make kapporah for him before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","And the kohen shall offer the chattat (sin offering), and make kapporah for him that is to be made tahor from his tumah (uncleanness); and afterward he shall slaughter (shachat) the olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","And the kohen shall offer the olah (burnt offering) and the minchah upon the Mizbe'ach; and the kohen shall make kapporah for him, and he shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","And if he be poor, and cannot afford otherwise, then he shall take one keves for an asham (trespass offering) to be waved, to make kapporah for him, and one tenth of an ephah of fine flour mixed with shemen for a minchah, and a log of shemen; ");
INSERT INTO engojb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","And two turtledoves, or two young pigeons, such as he is able to afford; and the one shall be a chattat (sin offering), and the other an olah (burnt offering). ");
INSERT INTO engojb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","And he shall bring them on the yom hashemini for his tohorah unto the kohen, unto the entrance of the Ohel Mo'ed before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","And the kohen shall take the keves (lamb) of the asham (trespass offering), and the log of shemen, and the kohen shall wave them for a tenufah (wave offering) before Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","And he shall slaughter (shachat) the keves of the asham (trespass offering), and the kohen shall take some of the dahm of the asham (trespass offering), and put it upon the lobe of the right ear of him that is to be made tahor, and upon the thumb of his right hand, and upon the bohen of his right foot; ");
INSERT INTO engojb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","And the kohen shall pour of the shemen into the palm of his own left hand; ");
INSERT INTO engojb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","And the kohen shall sprinkle with his right forefinger some of the shemen that is in his left hand seven times before Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","And the kohen shall put of the shemen that is in his hand upon the lobe of the right ear of him that is to made tahor, and upon the thumb of his right hand, and upon the bohen of his right foot, upon the mekom (place) of the dahm of the asham (trespass offering); ");
INSERT INTO engojb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","And the rest of the shemen that is in the kohenʼs hand he shall put upon the head of him that is to be made tahor, to make kapporah for him before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","And he shall sacrifice the one of the torim (turtledoves), or of the young pigeons, such as he can afford; ");
INSERT INTO engojb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Even such as he is able to afford, the one for a chattat (sin offering), and the other for an olah, with the minchah; and the kohen shall make kapporah for him that is to be made tahor before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the torah of him in whom is the nega tzara'at, who cannot afford that which pertaineth to his tohorah (cleansing). ");
INSERT INTO engojb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","When ye be come into Eretz Kena'an, which I give to you for a possession, and I put the nega tzara'at in a bais of the eretz of your possession; ");
INSERT INTO engojb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","And he that owneth the bais shall come and tell the kohen, saying, It seemeth to me there is as it were a nega (plague) in the bais; ");
INSERT INTO engojb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Then the kohen shall command that they empty the bais, before the kohen go into it to examine the nega, that all that is in the bais be not made tamei; and afterward the kohen shall go in to examine the bais, ");
INSERT INTO engojb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","And he shall examine the nega, and, hinei, if the nega be in the walls of the bais with depressions, greenish or reddish, which in appearance are deeper than the surface of the wall, ");
INSERT INTO engojb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Then the kohen shall go out of the bais to the entrance of the bais, and quarantine the bais seven days; ");
INSERT INTO engojb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","And the kohen shall come again the yom hashevi'i, and shall inspect; and, hinei, if the nega be spread in the walls of the bais, ");
INSERT INTO engojb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Then the kohen shall command that they tear down the stones in which the nega is, and they shall throw them into a makom tamei outside the town; ");
INSERT INTO engojb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","And he shall cause the bais to be scraped within around, and they shall pour out the afar (dust) that they scrape off outside the town into a makom tamei; ");
INSERT INTO engojb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","And they shall take other stones, and make them replace those stones; and he shall take other mortar, and shall plaster the bais. ");
INSERT INTO engojb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","And if the nega come again, and break out in the bais, after that he hath taken away the stones, and after he hath scraped the bais, and after it is plastered, ");
INSERT INTO engojb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Then the kohen shall come and inspect, and, hinei, if the nega be spread in the bais, it is a malignant tzara'at in the bais; it is tamei. ");
INSERT INTO engojb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","And he shall tear down the bais, the stones of it, and the timber thereof, and all the mortar of the bais; and he shall carry them forth out of the town into a makom tamei. ");
INSERT INTO engojb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Moreover he that goeth into the bais all the while that it is quarantined shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","And he that reclineth in the bais shall wash his clothes; and he that eateth in the bais shall wash his clothes. ");
INSERT INTO engojb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","And if the kohen shall come in, and examine it, and, hinei, the nega hath not spread in the bais, after the bais was plastered, then the kohen shall pronounce the bais tahor (clean), because the nega is healed. ");
INSERT INTO engojb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","And he shall take to purify the bais two birds, and cedar wood, and scarlet thread, and hyssop; ");
INSERT INTO engojb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","And he shall kill (shachat) the one of the birds in a clay vessel over mayim chayyim (running water); ");
INSERT INTO engojb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","And he shall take the cedar wood, and the hyssop, and the scarlet thread, and the living bird, and dip them in the dahm of the slain bird, and in the mayim chayyim (running water), and sprinkle the bais seven times; ");
INSERT INTO engojb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","And he shall cleanse the bais with the dahm of the bird, and with the mayim hachayyim (running water), and with the living bird, and with the cedar wood, and with the hyssop, and with the scarlet thread; ");
INSERT INTO engojb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","But he shall release the living bird outside the town into the open field, and make kapporah for the bais; and it shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the torah for all manner of nega tzara'at, and nesek (scale, netek), ");
INSERT INTO engojb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","And for the tzara'at of a garment, and of a bais, ");
INSERT INTO engojb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","And for a swelling, and for a scab, and for a bright spot, ");
INSERT INTO engojb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","To teach when it is tamei, and when it is tahor: this is the torat tzara'at. ");
INSERT INTO engojb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","And Hashem spoke unto Moshe and to Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Speak unto the Bnei Yisroel, and say unto them, When any ish hath a discharge from his basar, because of his discharge he is tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","And this shall be his tumah (uncleanness) in his discharge: whether his basar run with his discharge, or his basar has stopped from his discharge, it is his tumah (uncleanness). ");
INSERT INTO engojb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Every bed, whereon he lieth that hath the discharge, is tamei; and everything, whereon he sitteth, shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","And whosoever toucheth his bed shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","And he that sitteth on any thing whereon he sat that hath the discharge shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","And he that toucheth the basar of him that hath the discharge shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","And if he that hath the discharge spit upon him that is tahor, then he shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","And whatsoever riding seat he rideth upon that hath the discharge shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","And whosoever toucheth anything that was under him shall be tamei until the erev; and he that picks up any of those things shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","And whomsoever he toucheth that hath the discharge, and hath not rinsed his hands in mayim, he shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","And the clay pottery, that he toucheth which hath the discharge, shall be broken; and every wooden vessel shall be rinsed in mayim. ");
INSERT INTO engojb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","And when he that hath a discharge is made tahor of his discharge; then he shall number to himself seven days for his tohorah (cleansing), and immerse his garments, and immerse his basar in running mayim, and shall be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","And on the yom shemini he shall take to him two turtledoves, or two young pigeons, and come before Hashem unto the entrance of the Ohel Mo'ed, and give them unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","And the kohen shall sacrifice them, the one for a chattat, and the other for an olah (burnt offering); and the kohen shall make kapporah for him before Hashem for his discharge. ");
INSERT INTO engojb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","And if any ish, if his shikhvat zera (emission of semen) go out from him, then he shall immerse his entire body in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","And every garment, and every skin, whereon is the shikhvat zera, shall be immersed with mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","The isha also with whom ish shall lie with shikhvat zera, they shall both immerse themselves in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","And if an isha have a discharge, and her discharge in her body be dahm, she shall be in her state of niddah (state of menstrual separation) seven days; and whosoever toucheth her shall be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","And everything that she lieth upon in her niddah shall be tamei; everything also that she sitteth upon shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","And whosoever toucheth her bed shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","And whosoever toucheth anything that she sat upon shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","And if it be on her bed, or on any thing whereon she sitteth, when he toucheth it, he shall be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","And if any ish lie with her at all, and her niddah (menstrual flow) be upon him, he shall be tamei seven days; and all the bed whereon he lieth shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","And if an isha have a discharge of her dahm many days out of the time of her niddah, or if it run beyond the time of her niddah, all the days of the discharge of her tumah shall be as the days of her niddah; she shall be tamei. ");
INSERT INTO engojb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Every bed whereon she lieth all the days of her discharge shall be unto her as the bed of her niddah; and whatsoever she sitteth upon shall be tamei, as the tumah of her niddah. ");
INSERT INTO engojb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","And whosoever toucheth those things shall be tamei, and shall immerse his garments, and immerse himself in mayim, and be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","But if she be tohorah of her discharge, then she shall count to herself seven days, and after that she shall be tohorah. ");
INSERT INTO engojb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","And on the yom shemini she shall take unto her two turtle doves, or two young pigeons, and bring them unto the kohen, to the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","And the kohen shall sacrifice the one for a chattat, and the other for an olah (burnt offering); and the kohen shall make kapporah for her before Hashem for the discharge of her tumah. ");
INSERT INTO engojb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Thus shall ye separate the Bnei Yisroel from their tumah; that they die not in their tumah, when they defile My Mishkan that is among them. ");
INSERT INTO engojb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the torah of him that hath a discharge, and of him whose shikhvat zera goeth from him, and is made tamei therewith; ");
INSERT INTO engojb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","And of her that suffers through her niddah, and of him that hath a discharge, of the zachar, and of the nekevah, and of him that lieth with her that is tameiah. ");
INSERT INTO engojb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","And Hashem spoke unto Moshe after the mot of the two Bnei Aharon, when they approached before Hashem, and died; ");
INSERT INTO engojb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","And Hashem said unto Moshe, Speak unto Aharon thy brother, that he come not at any time into HaKodesh within the Parochet (curtain) before the Kapporet, which is upon the Aron; that he die not; for I will appear in the Anan upon the Kapporet. ");
INSERT INTO engojb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Thus shall Aharon come into HaKodesh: with a young bull for a chattat, and a ram for an olah (burnt offering). ");
INSERT INTO engojb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He shall put on the Kesones Bahd Kodesh (holy linen tunic), and he shall have the Mikhnesei Bahd (linen breeches) upon his basar, and shall be girded with a Avnet Bahd (linen sash), and with the Mitznefet Bahd (linen turban) shall he be attired; these are Bigdei Kodesh; therefore shall he immerse his basar in mayim, and so put them on. ");
INSERT INTO engojb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","And he shall take of the Adat Bnei Yisroel two male goats of the goats for a chattat, and one ram for an olah. ");
INSERT INTO engojb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","And Aharon shall offer his bull of the chattat, which is for himself, and make kapporah for himself, and for his bais. ");
INSERT INTO engojb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","And he shall take the two goats, and present them before Hashem at the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","And Aharon shall cast lots upon the two goats; one lot for Hashem, and the other lot for Azazel. ");
INSERT INTO engojb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","And Aharon shall bring the goat upon which Hashemʼs lot fell, and offer him for a chattat. ");
INSERT INTO engojb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat, on which the lot fell for Azazel shall be presented chai (alive) before Hashem, to make kapporah through it, and to let him go for Azazel into the midbar. ");
INSERT INTO engojb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","And Aharon shall bring the bull of the chattat, which is for himself, and shall make kapporah for himself, and for his bais, and shall slaughter (shachat) the bull of the chattat which is for himself; ");
INSERT INTO engojb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","And he shall take a machtah (censer) full of burning coals of eish from off the Mizbe'ach before Hashem, and his hands full of ketoret, ground and fragrant, and bring it within the Parochet (Curtain); ");
INSERT INTO engojb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","And he shall put the ketoret upon the eish before Hashem, that the anan of the ketoret may cover the Kapporet that is upon the Edut, that he die not; ");
INSERT INTO engojb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","And he shall take of the dahm of the bull, and sprinkle it with his forefinger upon the eastern front of the Kapporet; and before the Kapporet yazzeh (he shall sprinkle)  of the dahm with his forefinger seven times. ");
INSERT INTO engojb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Then shall he slaughter (shachat) the goat of the chattat, that is for the Am, and bring his dahm within the Parochet, and do with that dahm as he did with the dahm of the bull, and sprinkle it upon the Kapporet, and before the Kapporet; ");
INSERT INTO engojb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","And he shall make kapporah for HaKodesh, because of the tuma of the Bnei Yisroel, and because of their peysha'im in all their chattot; and so shall he do for the Ohel Mo'ed, that remaineth among them in the midst of their tumah. ");
INSERT INTO engojb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","And there shall be no adam in the Ohel Mo'ed when he goeth in to make kapporah in HaKodesh, until he come out, and have made kapporah for himself, and for his bais, and for kol Kehal Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","And he shall go out unto the Mizbe'ach that is before Hashem, and make kapporah on it; and shall take of the dahm of the bull, and of the dahm of the goat, and put it upon the Karnot of the Mizbe'ach around about. ");
INSERT INTO engojb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","And he shall sprinkle of the dahm upon it with his forefinger seven times, and make it tahor, and set it apart as kodesh from the tumah of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","And when he hath finished making kapporah for HaKodesh, and the Ohel Mo'ed, and the Mizbe'ach, he shall bring the live goat; ");
INSERT INTO engojb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","And Aharon shall lay both his hands upon the rosh (head) of the live goat, v'hitvaddah (and confess) over him kol avonot Bnei Yisroel, and all their peysha'im in all their chattot, putting them upon the rosh of the goat, and shall send him away by the hand of a designated man into the midbar; ");
INSERT INTO engojb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","And the goat nasah(shall carry) upon him all their avonot unto an eretz gezerah (uninhabited, solitary place); and he shall release the goat in the midbar. ");
INSERT INTO engojb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","And Aharon shall come into the Ohel Mo'ed, and shall put off the linen garments, which he put on when he went into HaKodesh, and shall leave them there; ");
INSERT INTO engojb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","And he shall wash his basar with mayim in the Makom Kadosh, and put on his garments, come out, and offer his olah and the olah of HaAm, and make kapporah for himself, and for HaAm. ");
INSERT INTO engojb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","And the chelev of the chattat shall he burn upon the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","And he that released the goat for Azazel shall immerse his garments and immerse his basar in mayim, and afterward come into the machaneh. ");
INSERT INTO engojb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","And the bull for the chattat, and the goat for the chattat whose dahm was brought in to make kapporah in HaKodesh, shall one carry forth outside the machaneh; and they shall burn in the eish their hides, and their basar, and their dung. ");
INSERT INTO engojb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","And he that burneth them shall immerse his garments, and immerse his basar in mayim, and afterward he shall come into the machaneh. ");
INSERT INTO engojb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","And this shall be a chukkat olam (eternal decree) unto you: that in the Chodesh HaShevi'i, on the tenth day of the chodesh, ye shall afflict your nefashot, and do no melachah at all, whether it be ezrach (native) or the ger that sojourneth among you: ");
INSERT INTO engojb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","For on that day shall the kohen make kapporah for you, to make you tahor, that ye may be tahor from all your chattot before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It shall be a Shabbat Shabbaton unto you, and ye shall afflict your nefashot, by a chukkat olam. ");
INSERT INTO engojb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","And the kohen, who has been anointed or who has been given authority to minister as a kohen in place of his father, shall make kapporah, and shall put on the linen garments, even the Bigdei Hakodesh; ");
INSERT INTO engojb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","And he shall make kapporah for the Mikdash HaKodesh, and he shall make kapporah for the Ohel Mo'ed, and for the Mizbe'ach, and he shall make kapporah for the kohanim, and for kol Am HaKahal. ");
INSERT INTO engojb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","And this shall be a chukkat olam unto you, to make kapporah for the Bnei Yisroel for all their chattat once a year. And he did as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Speak unto Aharon, and unto his banim, and unto all the Bnei Yisroel, and say unto them: This is the thing which Hashem hath commanded, saying, ");
INSERT INTO engojb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","What man soever there be of Bais Yisroel, that sacrificeth an ox, or lamb, or goat, in the machaneh, or that sacrificeth it outside of the machaneh, ");
INSERT INTO engojb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","And bringeth it not unto the petach (entrance) of the Ohel Mo'ed, to offer a korban unto Hashem before the Mishkan of Hashem, shefach dahm (shedding of blood) shall be imputed unto that man; he hath committed shefach dahm; and that man shall be cut off from among his people; ");
INSERT INTO engojb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","To the end that the Bnei Yisroel may bring their zevakhim, which they offer in the open sadeh, even that they may bring them unto Hashem, unto the petach of the Ohel Mo'ed, unto the kohen, and offer them for zivkhei shelamim unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","And the kohen shall sprinkle the dahm upon the Mizbe'ach of Hashem at the petach of the Ohel Mo'ed, and burn the fat for a re'ach nichoach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","And they shall no more offer their zevakhim unto goat demons, after whom they have gone a-whoring. This shall be a chukkat olam unto them throughout their dorot (generations). ");
INSERT INTO engojb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","And thou shalt say unto them, Whatsoever man there be of the Bais Yisroel, or of the ger which sojourn among them, that offereth an olah (burnt offering) or zevakh, ");
INSERT INTO engojb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","And bringeth it not unto the petach of the Ohel Mo'ed, to offer it unto Hashem; even that man shall be cut off from among his people. ");
INSERT INTO engojb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","And whatsoever man there be of Bais Yisroel, or of the ger that sojourn among you, that eateth any manner of dahm; I will even set My face against that nefesh that eateth dahm, and will cut it off from among its people. ");
INSERT INTO engojb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","For the nefesh of the basar is in the dahm: and I have given it to you upon the Mizbe'ach to make kapporah for your nefashot: for it is the dahm that maketh kapporah for the nefesh. ");
INSERT INTO engojb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore I said unto the Bnei Yisroel, No nefesh of you shall eat dahm, neither shall any ger that sojourneth among you eat dahm. ");
INSERT INTO engojb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","And whatsoever ish there be of the Bnei Yisroel, or of the ger that sojourn among you, which hunteth down any beast or fowl that may be eaten, he shall even drain out the dahm thereof, and cover it with dust. ");
INSERT INTO engojb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For as for the nefesh of all basar, the dahm of it is its nefesh; therefore I said unto the Bnei Yisroel, Ye shall eat the dahm of no manner of basar: for the nefesh of all basar is the dahm thereof; whosoever eateth it shall be cut off. ");
INSERT INTO engojb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","And every nefesh that eateth nevelah (carcass), or terefah (that which was torn with beasts), whether native born or a ger, he shall both wash his clothes, and bathe himself in mayim, and be tamei until erev; then shall he be tahor. ");
INSERT INTO engojb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he wash them not, nor bathe his basar; then he shall bear his avon (iniquity). ");
INSERT INTO engojb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Speak unto the Bnei Yisroel, and say unto them, I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","After what is done in Eretz Mitzrayim, wherein ye dwelt, shall ye not do; and after what is done in Eretz Kena'an, whither I bring you, shall ye not do; neither shall ye walk in their chukkot. ");
INSERT INTO engojb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ye shall do My mishpatim, and be shomer over My chukkot, to walk therein: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ye shall therefore be shomer over My chukkot, and My mishpatim; which if an ish do, he shall live by them: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","None of you shall approach to any that is near of kin to legallot ervah (to uncover nakedness, i.e., incestuously dishonor); I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","The nakedness of thy av, or the nakedness of thy em, shalt thou not uncover: she is thy em; thou shalt not uncover her nakedness. ");
INSERT INTO engojb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","The nakedness of the wife of thy av shalt thou not uncover; it is the nakedness of thy av. ");
INSERT INTO engojb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","The nakedness of thy achot (sister), the bat of thy av, or bat of thy em, whether she be moledet bais (born at home), or moledet chutz (born outside), even their nakedness thou shalt not uncover. ");
INSERT INTO engojb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","The nakedness of the bat of thy ben, or the bat of thy bat, even their nakedness thou shalt not uncover; for theirs is thine own nakedness. ");
INSERT INTO engojb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","The nakedness of the bat of the wife of thy av, begotten of thy av, she is thy achot (sister), thou shalt not uncover her nakedness. ");
INSERT INTO engojb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Thou shalt not uncover the nakedness of the achot of thy av; she is thy fatherʼs near kinswoman. ");
INSERT INTO engojb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Thou shalt not uncover the nakedness of the achot (sister) of thy em: for she is thy motherʼs near kinswoman. ");
INSERT INTO engojb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Thou shalt not uncover the nakedness of the achi avicha (the brother of thy father), thou shalt not approach to his wife; she is thine dodah. ");
INSERT INTO engojb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Thou shalt not uncover the nakedness of thy kallah (daughter-in-law); she is the wife of thy ben; thou shalt not uncover her nakedness. ");
INSERT INTO engojb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Thou shalt not uncover the ervah (nakedness) of thy brotherʼs wife; it is thy brotherʼs nakedness. ");
INSERT INTO engojb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Thou shalt not uncover the nakedness of an isha and her bat, neither shalt thou take the bat of her ben, or the bat of her bat, to uncover her nakedness; for they are her near kinswomen: it is zimmah (wickedness). ");
INSERT INTO engojb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Neither shalt thou take your wifeʼs achot (sister), to be a rival wife, to uncover her nakedness, beside the other in her lifetime. ");
INSERT INTO engojb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Also thou shalt not approach unto an isha to uncover her nakedness, as long as she has her tumah from her period of niddah. ");
INSERT INTO engojb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Moreover thou shalt not lie carnally with thy neighborʼs wife. You shall not give your shikhvat zera to make tamei with her. ");
INSERT INTO engojb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","And thou shalt not let any of thy zera pass through the eish to Molech, neither shalt thou profane the Shem Eloheicha; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Thou shalt not lie with zachar, as with isha: it is to'evah (abomination, detestable). ");
INSERT INTO engojb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Neither shalt thou lie with any behemah. You shall not give your shikhvat to make tamei with it; neither shall any isha present herself to a behemah to have relations with it: it is tevel (perversion). ");
INSERT INTO engojb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Make not yourselves tamei in any of these things; for in all these the Goyim which I cast out before you became tamei; ");
INSERT INTO engojb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","And HaAretz became tamei; therefore I do visit the iniquity thereof upon it, and HaAretz itself vomiteth out her inhabitants. ");
INSERT INTO engojb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ye shall therefore be shomer over My chukkot and My mishpatim, and shall not commit any of these to'evot; no, neither any of your ezrach, nor any ger that sojourneth among you; ");
INSERT INTO engojb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(For all these to'evot have the anshei HaAretz done, which were before you, and HaAretz is tamei;) ");
INSERT INTO engojb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","That HaAretz vomit not you out also, when ye defile it, as it vomited out the Goyim that were before you. ");
INSERT INTO engojb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","For whosoever shall commit any of these to'evot, even the nefashot that commit them shall be cut off from among their people. ");
INSERT INTO engojb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Therefore shall ye be shomer over My charge, that ye commit not any one of these chukkot hato'evot, which were committed before you, and that ye make not yourselves tamei therein: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Speak unto kol Adat Bnei Yisroel, and say unto them, Ye shall be kedoshim (holy ones): for I Hashem Eloheichem am kadosh. ");
INSERT INTO engojb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ye shall fear every man his em, and his av, and be shomer over My Shabbatot: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Turn ye not unto elilim, nor make to yourselves elohei massekhah (cast metal g-ds); I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","And if ye offer a zevach shelamim unto Hashem, ye shall offer it for your acceptance. ");
INSERT INTO engojb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It shall be eaten the same day ye offer it, and on the next day; and what remains until the yom hashelishi, it shall be burned in the eish. ");
INSERT INTO engojb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","And if it be eaten at all on the yom hashelishi, it is piggul (unclean sacrificial flesh); it shall not be accepted. ");
INSERT INTO engojb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Therefore every one that eateth it shall bear his avon, because he hath desecrated as chillul the set-apart-as-kodesh thing of Hashem: and that nefesh shall be cut off from among his people. ");
INSERT INTO engojb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","And when ye reap the katzir of your land, thou shalt not wholly reap the corners of thy sadeh, neither shalt thou gather the gleanings of thy katzir. ");
INSERT INTO engojb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","And thou shalt not glean thy kerem (vineyard), neither shalt thou gather every grape of thy kerem; thou shalt leave them for the oni (poor) and ger (stranger); I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ye shall not steal, neither deal falsely, neither speak sheker (falsehood, deception, lie) to another. ");
INSERT INTO engojb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","And ye shall not swear by My Shem lasheker (falsely), neither shalt thou commit Chillul ha-shem Eloheicha; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Thou shalt not defraud thy re'a (neighbor), neither rob him; the wages of him that is a sakhir (hired man) shall not abide with thee ad boker (until morning). ");
INSERT INTO engojb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Thou shalt not curse the cheresh (deaf), nor put a michshol (stumbling block) before the ivver (blind), but shalt fear Eloheicha: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ye shall do no avel bamishpat (perversion of justice); thou shalt not respect the person of the poor, nor favor the person of the gadol; but in tzedek shalt thou judge thy neighbor. ");
INSERT INTO engojb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Thou shalt not go up and down as a rakhil (talebearer, slanderer) among thy people; neither shalt thou stand aside while thy neighborʼs dahm is shed; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Thou shalt not hate thy brother in thine lev; thou shalt in any wise rebuke thy neighbor, and not bear chet because of him. ");
INSERT INTO engojb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Thou shalt not avenge, nor bear any grudge against the bnei ammecha (children of thy people), v'ahavta l'reacha kamocha (but thou shalt love thy neighbor as thyself): I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Ye shall be shomer over My chukkot. Thou shalt not mate different kinds of animals; thou shalt not sow thy sadeh with mingled zera; neither shall a garment with shaatnez (mixed fibers) come upon thee. ");
INSERT INTO engojb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","And whosoever lieth carnally with an isha, that is a shifcha betrothed to a husband, and not at all redeemed, nor chufshah (freedom) given her; she shall be scourged; they shall not be put to death, because she has not been chuppashah (freed). ");
INSERT INTO engojb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","And he shall bring his asham (trespass offering, guilt offering) unto Hashem, unto the entrance of the Ohel Mo'ed, even a ram of asham. ");
INSERT INTO engojb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","And the kohen shall make kapporah for him with the ram of the asham before Hashem for his chattat which he hath sinned; and the chattat which he hath sinned shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","And when ye shall come into ha'aretz, and shall have planted all manner of food trees, then ye shall treat the fruit thereof as forbidden; shalosh shanim shall it be as forbidden unto you; it shall not be eaten of. ");
INSERT INTO engojb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","But in the shanah harev'i'it all the fruit thereof shall be kodesh to praise Hashem withal. ");
INSERT INTO engojb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","And in the shanah hachamishit shall ye eat of the fruit thereof, that it may yield unto you the increase thereof: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ye shall not eat any thing with the dahm; neither shall ye practice divination, nor practice sorcery. ");
INSERT INTO engojb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Ye shall not cut the edge of your scalp, neither shalt thou mar the corners of thy beard. ");
INSERT INTO engojb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ye shall not make any cuttings in your basar for the dead, nor tattoo any marks upon you: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Do not prostitute thy bat, to cause her to be a harlot; lest ha'aretz fall to whoredom, and ha'aretz become full of depravity. ");
INSERT INTO engojb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ye shall be shomer over My Shabbatot, and reverence My Mikdash; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Regard not them that have familiar spirits, neither seek after Ovos (Mediums) and Yidonim (Spiritists), to be defiled by them: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Thou shalt rise up before the old, and honor the face of the zaken, and fear Eloheicha: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","And if a ger sojourn with thee in your land, ye shall not mistreat him. ");
INSERT INTO engojb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","But the ger that dwelleth with you shall be unto you as one born among you, and thou shalt love him as thyself; for ye were gerim in Eretz Mitzrayim: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Ye shall do no unrighteousness in scales, in weights, and dry measures. ");
INSERT INTO engojb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Tzedek scales, tzedek weights, a tzedek ephah, and a tzedek hin, shall ye have: I am Hashem Eloheichem, which brought you out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Therefore shall ye be shomer (on guard to keep) over all My chukkot (statutes), and all My mishpatim (judgments), and do them: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Again, thou shalt say to the Bnei Yisroel, Whosoever he be of the Bnei Yisroel, or of the ger that sojourn in Yisroel, that giveth any of his zera unto Molech; he shall surely be put to death; the Am HaAretz shall stone him with stones. ");
INSERT INTO engojb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","And I will set My face against that ish, and will cut him off from among his people; because he hath given of his zera unto Molech, to make tamei My Mikdash, and to commit chillul Hashem against Shem Kodshi (My Holy Name). ");
INSERT INTO engojb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","And if the Am HaAretz close their eyes when that man giveth of his zera unto Molech, and kill him not, ");
INSERT INTO engojb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Then I will set My face against that ish, and against his mishpochah, and will cut him off, and all that go a-whoring after him, to commit whoredom with Molech, from among their people. ");
INSERT INTO engojb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","And the nefesh that turneth to Ovos (Mediums) and Yidonim (Spiritists), to go a-whoring after them, I will even set My face against that nefesh, and will cut him off from among his people. ");
INSERT INTO engojb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Consecrate yourselves as kodesh, therefore, and be ye kedoshim: for I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","And ye shall be shomer over My chukkot, and do them: I am Hashem who sets you apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","For every one that curseth his av or his em shall be surely put to death; he hath cursed his av or his em; his dahm shall be upon him. ");
INSERT INTO engojb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","And the ish that committeth adultery with the wife of another ish, even he that committeth adultery with his neighborʼs wife, the no'ef (adulterer) and the no'efet (adulteress) shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","And the ish that lieth with the wife of his av hath uncovered his fatherʼs nakedness; both of them shall surely be put to death; their dahm shall be upon them. ");
INSERT INTO engojb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","And if an ish lie with his kallah (daughter-in-law), both of them shall surely be put to death; they have committed tevel (perversion); their dahm shall be upon them. ");
INSERT INTO engojb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","If an ish also lie with zachar, as he lieth with an isha, both of them have committed to'evah; they shall surely be put to death; their dahm shall be upon them. ");
INSERT INTO engojb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","And if an ish take a wife and her em, it is zimmah; they shall be burned with eish, both he and they; that there be no zimmah among you. ");
INSERT INTO engojb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","And if an ish give his shikhvat to a behemah, he shall surely be put to death: and ye shall slay the behemah. ");
INSERT INTO engojb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","And if an isha approach unto any behemah, and lie down thereto, thou shalt kill the isha, and the beast; they shall surely be put to death; their dahm shall be upon them. ");
INSERT INTO engojb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","And if an ish shall take his achot, the bat of his av (father), or the bat of his em (mother), and see her nakedness, and she see his nakedness; it is a disgrace; and they shall be cut off in the sight of their Bnei Am; he hath uncovered the nakedness of his achot (sister); he shall bear his iniquity. ");
INSERT INTO engojb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","And if an ish shall lie with an isha during her davah (menstruous unwellness), and shall uncover her nakedness, he hath made bare her mekor (source), and she hath uncovered the source of her dahm; and both of them shall be cut off from among their people. ");
INSERT INTO engojb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","And thou shalt not uncover the nakedness of thy motherʼs achot (sister), nor of thy fatherʼs achot (sister); for he uncovereth his near kin; they shall bear their iniquity. ");
INSERT INTO engojb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","And if an ish shall lie with the wife of his dod, he hath uncovered his uncleʼs nakedness; they shall bear their chet; they shall die childless. ");
INSERT INTO engojb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","And if an ish shall take his brotherʼs wife, it is niddah; he hath uncovered his brotherʼs nakedness; they shall be childless. ");
INSERT INTO engojb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Ye shall therefore be shomer over all My chukkot, and all My mishpatim, and do them; that HaAretz, whither I bring you to dwell therein, vomit you not out. ");
INSERT INTO engojb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","And ye shall not walk in the chukkot of HaGoy, which I cast out before you; for they committed all these things; therefore I abhorred them. ");
INSERT INTO engojb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have said unto you, Ye shall inherit their land, and I will give it unto you to inherit it, an Eretz zavat cholov udevash: I am Hashem Eloheichem, which have separated you from the peoples. ");
INSERT INTO engojb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ye shall therefore distinguish habehemah hatehorah from teme'ah, and between fowls tamei and tahor: and ye shall not make your nefashot sheketz (abomination) by beast, or by fowl, or by any manner of living thing that creepeth on the ground, which I have separated from you as tamei. ");
INSERT INTO engojb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","And ye shall be kedoshim unto Me: for I Hashem am kadosh, and have separated you from the nations, that ye should be Mine. ");
INSERT INTO engojb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","An ish also or isha who is an Ov (Medium) or a Yidoni (Spiritist), shall surely be put to death; they shall stone them with stones; their dahm shall be upon them. ");
INSERT INTO engojb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","And Hashem said unto Moshe, Speak unto the kohanim the Bnei Aharon, and say unto them, There shall none be made tamei for the dead among his people; ");
INSERT INTO engojb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","But for his close kin, that is near unto him, that is, for his em, and for his av, and for his ben, and for his bat, and for his ach. ");
INSERT INTO engojb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","And for his betulah achot (virgin sister), that is close unto him, which hath had no ish (husband); for her may he be made tamei. ");
INSERT INTO engojb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","But he shall not make himself tamei, being a ba'al (leader, chief man) among his people, to profane himself. ");
INSERT INTO engojb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","They shall not shave their head bald, neither shall they shave off the corner of their beard, nor make any cuttings in their basar. ");
INSERT INTO engojb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They shall be kedoshim unto Eloheihem, and not commit Chillul ha-shem against the Shem of Eloheihem; for the offerings of Hashem made by eish and the lechem of Eloheihem they do offer; therefore they shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","They shall not take an isha that is a zonah, or chalalah (desecrated woman) neither shall they take an isha gerusha (divorced woman) from her ish; for he is kadosh unto Elohav. ");
INSERT INTO engojb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Thou shalt set him apart as kodesh therefore; for he offereth the lechem of Eloheicha; he shall be makriv kadosh (holy offering) unto thee: for I, Hashem, the One setting you apart as kodesh, am kadosh. ");
INSERT INTO engojb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","And the bat of any kohen, if she profane herself by playing the zonah, she profaneth her av; she shall be burned with eish. ");
INSERT INTO engojb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","And he that is the Kohen HaGadol among his brethren, upon whose head the Shemen Hamishchah (Anointing Oil) was poured, and that is ordained to put on the garments, shall not in mourning uncover his head, nor rend his garments; ");
INSERT INTO engojb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Neither shall he go in to any dead body, nor make himself tamei for his av, or for his em; ");
INSERT INTO engojb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Neither shall he go out of the Mikdash, nor profane the Mikdash Elohav; for the nezer shemen mishchat Elohav (consecration of the anointing oil of his G-d) is upon him: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","And he shall take an isha in her virginity. ");
INSERT INTO engojb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","An almanah, or a gerusha, or chalalah, or a zonah, these shall he not take; but he shall take a betulah of his own people to wife. ");
INSERT INTO engojb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Neither shall he profane his zera among his people; for I Hashem do set him apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Speak unto Aharon, saying, Whosoever he be of thy zera in their dorot that hath any defect, let him not approach to offer the lechem of Elohav. ");
INSERT INTO engojb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","For whatsoever ish he be that hath a mum, he shall not approach; an ish ivver, or a pise'ach (lame), or he who is disfigured or malformed, ");
INSERT INTO engojb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Or an ish that has a crippled regel or a crippled yad, ");
INSERT INTO engojb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Or hunchback, or a dwarf, or that hath a defect in his eye, or festering, or running sores, or damaged of testicle; ");
INSERT INTO engojb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No ish that hath a mum of the zera Aharon HaKohen shall come near to offer the offerings of Hashem made by eish; he hath a mum; he shall not come near to offer the lechem Elohav. ");
INSERT INTO engojb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He shall eat the lechem Elohav, both of the kodshei hakodashim, and of hakodashim. ");
INSERT INTO engojb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Only he shall not go near unto the Parochet (curtain), nor come near unto the Mizbe'ach, because he hath a mum on him; that he profane not My Mikdash; for I Hashem do set them apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","And Moshe told it unto Aharon, and to his Banim, and unto all the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Speak unto Aharon and to his Banim, that they separate themselves from the kodashim of the Bnei Yisroel which they set apart as kodesh unto Me, so that they will not commit Chillul ha-shem of Shem Kodshi: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Say unto them, Whosoever he be of all your zera among your dorot, that goeth unto the kodashim, which the Bnei Yisroel treat as kodesh unto Hashem, having his tumah upon him, that nefesh shall be cut off from My presence: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Whatsoever man of the zera Aharon is a metzora, or hath a discharge; he shall not eat of the kodashim, until he be tahor. And whosoever toucheth any thing that is tamei by the dead, or a man whose shikhvat zera goeth from him; ");
INSERT INTO engojb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Or whosoever toucheth any creeping thing, whereby he may be made tamei, or a man who makes him tamei, whatsoever tumah he hath; ");
INSERT INTO engojb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","The nefesh which hath touched any such shall be tamei until erev, and shall not eat of the kodashim, unless he immerse his basar with mayim. ");
INSERT INTO engojb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","And when the shemesh is down, he shall be tahor, and shall afterward eat of the kodashim; because it is his lechem. ");
INSERT INTO engojb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Nevelah (that which dieth of itself), or tereifah (what is torn by beasts), he shall not eat to make himself tamei therewith; I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","They shall therefore be shomer over My charge, lest they bear chet for it, and die therefore, if they profane it: I Hashem do set them apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","There shall no zar eat of the kodesh: a toshav (guest) of the kohen, or a sakhir (hired servant), shall not eat of the kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if the kohen buy any nefesh with his kesef, he shall eat of it, or he that is born in his bais; they shall eat of his lechem. ");
INSERT INTO engojb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If the bat kohen also be married unto a man who is a zar, she may not eat of a terumah (offering) of the kodashim. ");
INSERT INTO engojb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if the bat kohen becomes an almanah, or gerusha, and have no zera, and is returned unto bais aviha (house of her father), as in her youth, she shall eat of the lechem aviha; but there shall be no zar eat thereof. ");
INSERT INTO engojb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","And if an ish eat of the kodesh bishgagah (unintentionally), then he shall add as restitution the fifth part thereof unto it, and shall give it unto the kohen with the kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","And they shall not profane the kodshei Bnei Yisroel, which they offer unto Hashem; ");
INSERT INTO engojb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","And they will cause themselves to bear the avon of guilt when they eat their kodashim; for I Hashem do set them apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Speak unto Aharon, and to his Banim, and unto kol Bnei Yisroel, and say unto them, Whatsoever he be of the Bais Yisroel, or of the Ger B'Yisroel, that will offer his korban for any of his nederim, and for all his nedavot, which they will offer unto Hashem for an olah, ");
INSERT INTO engojb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","That it may be accepted on your behalf, ye shall offer a zachar tamim (male without defect), of the cattle and of the sheep, or of the goats. ");
INSERT INTO engojb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","But whatsoever hath a mum, that shall ye not offer, for it shall not be for you leratzon (acceptable). ");
INSERT INTO engojb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","And whosoever offereth a zevach shelamim unto Hashem to fulfill his neder, or as a nedavah in cattle or sheep, it shall be tamim (perfect, without defect) to be accepted; there shall be no mum therein. ");
INSERT INTO engojb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Avveret (blind), or injured, or charutz (maimed), or having an abnormal growth, or dry skin eruption, or running sore, ye shall not offer these unto Hashem, nor make an offering by eish of them upon the Mizbe'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Either a bull or a seh that hath a limb too long or too short thou mayest offer for a nedavah; but for a neder it shall not be accepted. ");
INSERT INTO engojb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ye shall not offer unto Hashem that which is bruised, or crushed, or torn, or cut; neither shall ye make any offering thereof in your eretz. ");
INSERT INTO engojb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Neither from the hand of a ben nakhar shall ye offer the lechem Eloheichem of any of these; because their corruption is in them, and mum be in them: they shall not be accepted for you. ");
INSERT INTO engojb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","When a bull, or a sheep, or a goat, is brought forth, then it shall be seven days with its mother; and from the yom hashemini and thenceforth it shall be accepted for a korban isheh (offering made by eish) unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","And whether it be an ox or seh, ye shall not slaughter (shachat) it and her young both in yom echad. ");
INSERT INTO engojb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","And when ye will offer a zevach todah unto Hashem, offer it liretzonechem (for your acceptance). ");
INSERT INTO engojb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","On the same day it shall be eaten; ye shall leave none of it until the boker: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Therefore shall ye be shomer mitzvot over My commands, and do them: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Neither shall ye profane Shem Kodshi; but I will be treated as kodesh among the Bnei Yisroel: I am Hashem, the One making you Kedoshim, ");
INSERT INTO engojb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","That brought you out of Eretz Mitzrayim, to be for you Elohim (your G-d): I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Speak unto the Bnei Yisroel, and say unto them, Concerning the Mo'adim of Hashem, which ye shall proclaim to be mikra'ei kodesh, even these are My Mo'adim. ");
INSERT INTO engojb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Sheshet yamim shall work be done; but the yom hashevi'i is the Shabbos of Shabbaton, a mikra kodesh; ye shall do no work therein: it is the Shabbos to Hashem in all your dwellings. ");
INSERT INTO engojb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the Moa'dim of Hashem, even mikra'ei kodesh, which ye shall proclaim in their mo'adim. ");
INSERT INTO engojb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the fourteenth day of the first month at twilight is Hashemʼs Pesach. ");
INSERT INTO engojb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","And on the fifteenth day of the same month is the Chag HaMatzot unto Hashem; shivat yamim ye must eat matzot. ");
INSERT INTO engojb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","In the Yom HaRishon ye shall have a mikra kodesh; ye shall do no melekhet avodah therein. ");
INSERT INTO engojb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","But ye shall offer an offering made by eish unto Hashem shivat yamim; in the seventh day is a mikra kodesh; ye shall do no melekhet avodah therein. ");
INSERT INTO engojb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Speak unto the Bnei Yisroel, and say unto them, When ye be come into HaAretz which I am giving unto you, and shall reap the harvest thereof, then ye shall bring an omer (sheaf of barley)  of the reshit of your harvest unto the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","And he shall wave the omer before Hashem, for your acceptance; on the day after the Shabbos the kohen shall wave it. ");
INSERT INTO engojb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","And ye shall offer that day when ye wave the omer a keves tamim of the first year for an olah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","And the minchah thereof shall be two tenths-ephah of fine flour mingled with shemen, an offering made by eish unto Hashem for a re'ach nicho'ach; and the nesekh thereof shall be of yayin, the fourth part of a hin. ");
INSERT INTO engojb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","And ye shall eat neither lechem, nor roasted grain, nor plump kernels until the same day that ye have brought a korban unto Eloheichem; it shall be a chukkat olam throughout your dorot in all your dwellings. ");
INSERT INTO engojb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","And ye shall count unto you from the day after the Shabbos, from the day that ye brought the omer of the wave offering; shevah shabbatot shall be complete, ");
INSERT INTO engojb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Even unto the day after the seventh Shabbos shall ye count fifty days; and ye shall offer a minchah chadashah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ye shall bring out of your dwellings two lechem wave-offerings of two tenth ephah; they shall be of fine flour; they shall be baked with chametz; they are the bikkurim unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","And ye shall offer with the lechem shivat kevasim temimim of the first year, and one young bull, and two rams; they shall be for an olah unto Hashem, with their minchot, and their nesakhim, even an offering made by eish, of re'ach nicho'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Then ye shall sacrifice one kid of the goats for a chattat and two kevasim of the first year for a zevach of shelamim. ");
INSERT INTO engojb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","And the kohen shall wave them with the lechem of the bikkurim for a wave offering before Hashem, with the two kevasim; they shall be kodesh to Hashem for the kohen. ");
INSERT INTO engojb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","And ye shall proclaim on the same day, that it may be a mikra kodesh unto you; ye shall do no melekhet avodah therein; it shall be a chukkat olam in all your dwellings throughout your dorot. ");
INSERT INTO engojb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","And when ye reap the harvest of your land, thou shalt not reap to the edges of thy sadeh when thou reapest, neither shalt thou gather the gleanings of thy harvest; thou shalt leave them unto the oni (poor), and to the ger: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Speak unto the Bnei Yisroel, saying, In the seventh month, in the first day of the month, shall ye have a Shabbaton, a zikhron teru'ah mikra kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ye shall do no melekhet avodah therein; but ye shall offer an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Also on the tenth day of this seventh month there shall be Yom Kippurim; it shall be a mikra kodesh unto you; and ye shall afflict your nefashot, and offer an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","And ye shall do no work in that same day; for it is Yom Kippurim, to make kapporah for you before Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","For whatsoever nefesh it be that shall not be afflicted in that same day, he shall be cut off from among his people. ");
INSERT INTO engojb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","And whatsoever nefesh it be that doeth any work in that same day, that nefesh will I destroy from among his people. ");
INSERT INTO engojb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ye shall do no manner of work; it shall be a chukkat olam throughout your dorot in all your dwellings. ");
INSERT INTO engojb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It shall be unto you a Shabbos Shabbaton, and ye shall afflict your nefashot; in the ninth day of the month at erev, from erev unto erev, shall ye observe your Shabbos. ");
INSERT INTO engojb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Speak unto the Bnei Yisroel, saying, The fifteenth day of this seventh month shall be the Chag HaSukkot for shivat yamim unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the Yom HaRishon shall be a mikra kodesh; ye shall do no melekhet avodah (laborious work) therein. ");
INSERT INTO engojb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Shivat yamim ye shall offer an offering made by eish unto Hashem; on the eighth day shall be a mikra kodesh unto you; and ye shall offer an offering made by eish unto Hashem; it is an atzeret (assembly); and ye shall do no melekhet avodah therein. ");
INSERT INTO engojb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the Mo'adim of Hashem, which ye shall proclaim to be mikra'ei kodesh, to offer an offering made by eish unto Hashem — an olah (burnt offering), and a minchah, a zevach, and nesakhim, every required thing upon its day, ");
INSERT INTO engojb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Beside the Shabbatot of Hashem, and beside your mattenot, and beside all your nederim, and beside all your nedavot (freewill offerings), which ye give unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Also in the fifteenth day of the seventh month, when ye have gathered in the crop of HaAretz, ye shall keep a Chag (Feast) unto Hashem shivat yamim; on the first day shall be a Shabbaton, and on the eighth day shall be a Shabbaton. ");
INSERT INTO engojb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","And ye shall take you on the Yom HaRishon the fruit of the citron tree, branches of temarim (date palms), and twigs of plaited trees, and willows of the brook; and ye shall rejoice before Hashem Eloheichem shivat yamim. ");
INSERT INTO engojb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","And ye shall keep it a Chag (Feast) unto Hashem shivat yamim in the shanah. It shall be a chukkat olam in your dorot; ye shall celebrate it in the seventh month. ");
INSERT INTO engojb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ye shall dwell in sukkot shivat yamim; all that are the Ezrach Yisroel shall dwell in sukkot, ");
INSERT INTO engojb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","That your dorot may know that I made the Bnei Yisroel to dwell in sukkot, when I brought them out of Eretz Mitzrayim: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","And Moshe declared unto the Bnei Yisroel the Mo'adim of Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Command the Bnei Yisroel, that they bring unto thee pure shemen zayit beaten for the light, to kindle the Ner Tamid (Perpetual Lamp). ");
INSERT INTO engojb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the Parochet (Curtain) of the Edut, in the Ohel Mo'ed shall Aharon set it in order from erev unto boker before Hashem tamid (continually); it shall be a chukkat olam in your dorot. ");
INSERT INTO engojb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","He shall set in order the nerot (lamps) upon the Menorah Hatehorah before Hashem tamid (continually). ");
INSERT INTO engojb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","And thou shalt take fine flour, and bake Sheteym Esreh Challot thereof; two tenths of an ephah shall be in Challah Echat. ");
INSERT INTO engojb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","And thou shalt set them in two rows, six on a row, upon the Shulchan HaTahor before Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","And thou shalt put levonah zakkah (pure incense) upon each row, that it may be on the lechem for a memorial portion, even an offering made by eish unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Shabbos after Shabbos he shall set it in order before Hashem tamid, from the Bnei Yisroel as a Brit Olam. ");
INSERT INTO engojb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","And it shall be for Aharon and for his Banim; and they shall eat it in the Makom Kadosh; for it is kodesh kodashim unto him of the offerings of Hashem made by eish, a chok olam. ");
INSERT INTO engojb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","And the ben isha Yisroelit, whose father was an Egyptian, went out among the Bnei Yisroel; and this ben isha Yisroeli and a man of Yisroel fought together in the machaneh; ");
INSERT INTO engojb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","And the ben haisha Yisroelit pronounced HaShem and blasphemed in a curse. And they brought him unto Moshe; (and shem immo was Shelomit bat Divri, of the tribe of Dan;) ");
INSERT INTO engojb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","And they put him in custody, that the mind of Hashem might be showed them. ");
INSERT INTO engojb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Bring forth him that hath blasphemed outside the machaneh; and let all that heard him lay their hands upon his head, and let kol HaEdah stone him. ");
INSERT INTO engojb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","And thou shalt speak unto the Bnei Yisroel, saying, Whosoever curseth Elohav shall bear his chet. ");
INSERT INTO engojb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","And he that blasphemeth the Shem of Hashem, he shall surely be put to death, and kol HaEdah shall certainly stone him; as well the ger, as the ezrach, when he blasphemeth the Shem of Hashem, shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","And he that taketh the nefesh of any man shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","And he that taketh the nefesh of a beast shall make it good; nefesh takhat nefesh. ");
INSERT INTO engojb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","And if a man cause a mum in his neighbor; as he hath done, so shall it be done to him; ");
INSERT INTO engojb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Fracture for fracture, eye for eye, tooth for tooth; as he hath caused a mum in an adam, so shall it be done to him. ");
INSERT INTO engojb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","And he that killeth a beast, he shall restitute it; and he that killeth a man, he shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ye shall have mishpat echad, as well for the ger, as for the ezrach: for I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","And Moshe spoke to the Bnei Yisroel, that they should bring forth him that had blasphemed out of the machaneh, and stone him with stones. And the Bnei Yisroel did as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","And Hashem spoke unto Moshe in Mt. Sinai, saying, ");
INSERT INTO engojb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Speak unto the Bnei Yisroel, and say unto them, When ye come into HaAretz which I give you, then shall HaAretz observe a Shabbos rest unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Six years thou shalt sow thy sadeh, and six years thou shalt prune thy kerem, and gather in the fruit thereof; ");
INSERT INTO engojb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But in the Shanah HaShevi'it shall be a Shabbos Shabbaton unto HaAretz, a Shabbos unto Hashem; thou shalt neither sow thy sadeh, nor prune thy kerem (vineyard). ");
INSERT INTO engojb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","That which groweth of its own accord of thy harvest thou shalt not reap, neither gather the grapes of thy untended vine; for it is Shnat Shabbaton unto HaAretz. ");
INSERT INTO engojb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","And the Shabbos of HaAretz shall be food for you; for thee, and for thy eved, and for thy maid, and for thy hired servant, and for thy toshav (guest) that sojourneth with thee. ");
INSERT INTO engojb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","And for thy cattle, and for the wild animals that are in thy land, shall all the tevuah (increase) thereof be to eat. ");
INSERT INTO engojb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","And thou shalt count seven Shabbatot of shanim unto thee, seven times seven shanim; and the period of the sheva Shabbatot of shanim shall be unto thee forty and nine shanim. ");
INSERT INTO engojb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then shalt thou cause the shofar to sound a broken blast on the tenth day of the seventh month, in the Yom HaKippurim shall ye make the shofar sound throughout all your land. ");
INSERT INTO engojb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","And ye shall treat as kodesh the fiftieth year, and proclaim deror (freedom) throughout all the land unto all the inhabitants thereof; it shall be a Yovel (Jubilee) unto you; and ye shall return every man unto the ancestral heritage of his possession, and ye shall return every man unto his mishpochah. ");
INSERT INTO engojb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","A Yovel shall that fiftieth year be unto you; ye shall not sow, neither reap that which groweth of itself in it, nor gather the grapes in it of thy untended vine, ");
INSERT INTO engojb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","For it is the Yovel; it shall be kodesh unto you; ye shall eat the tevuah (increase) thereof out of the sadeh. ");
INSERT INTO engojb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In this Shnat Yovel ye shall return every man unto his possession. ");
INSERT INTO engojb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","And if thou sell ought unto thy neighbor, or buyest ought of thy neighborʼs hand, ye shall not take advantage of one another. ");
INSERT INTO engojb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","According to the number of shanim after the Yovel thou shalt buy of thy neighbor, and according unto the number of shanim of the tevuot (harvests, increases) he shall sell unto thee. ");
INSERT INTO engojb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","According to the multitude of shanim thou shalt increase the price thereof, and according to the fewness of shanim thou shalt diminish the price of it; for according to the number of the shanim of the tevuot doth he sell unto thee. ");
INSERT INTO engojb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ye shall not therefore take advantage of one another; but thou shalt fear Eloheicha: for I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Wherefore ye shall do My chukkot, and be shomer over My mishpatim, and do them; and ye shall dwell in HaAretz in safety. ");
INSERT INTO engojb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","And HaAretz shall yield her pri, and ye shall eat your fill, and dwell therein in safety. ");
INSERT INTO engojb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","And if ye shall say, What shall we eat in the shanah hashevi'it? Behold, we shall not sow, nor gather in our tevuah; ");
INSERT INTO engojb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Then I will command Birkhati (My Blessing) upon you in the sixth year, and it shall bring forth the tevuah for shalosh hashanim. ");
INSERT INTO engojb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","And ye shall sow the shanah hasheminit, and eat yet of tevuah yashan (old increase) until the ninth year; until her harvest come in, ye shall eat of the yashan (old). ");
INSERT INTO engojb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","HaAretz shall not be sold permanently: for HaAretz is Mine, for ye are gerim and toshavim with Me. ");
INSERT INTO engojb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","And in all the eretz of your possession ye shall grant a Geulah for HaAretz. ");
INSERT INTO engojb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If thy brother become poor, and hath sold away some of his possession, and his Go'el HaKarov (Near Kinsman Redeemer) come to redeem it, then shall he redeem that which his brother sold. ");
INSERT INTO engojb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","And if the man does not have for him a Go'el, and himself be able to effect the Geulah, ");
INSERT INTO engojb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Then let him count the shanim from the sale thereof, and refund the balance unto the man to whom he sold it; that he may return unto his possession. ");
INSERT INTO engojb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if he be not able to restore it to him, then that which is sold shall remain in the hand of him that hath bought it until the Shnat HaYovel; and in the Yovel it shall be returned, and he shall return unto his possession. ");
INSERT INTO engojb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","And if a man sell a bais moshav in a walled city, then he retains the right of Geulah a full year after its sale; within a full year may he redeem it. ");
INSERT INTO engojb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","And if it be not redeemed within the space of a full year, then the bais that is in the walled city shall be established forever to him that bought it throughout his dorot; it shall not return in the Yovel. ");
INSERT INTO engojb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But the batim (houses) of the villages which have no chomah (wall) round about them shall be considered as the fields of the country; Geulah shall be for it, and in the Yovel it must return. ");
INSERT INTO engojb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Notwithstanding, the towns of the Levi'im, and the batim (houses) of the towns of their possession, there is a Geulat Olam for the Levi'im. ");
INSERT INTO engojb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","And what one will buy from the Levi'im, the bais that was sold, and the town of his possession, shall be released in the year of Yovel; for the batim of the towns of the Levi'im are their possession among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the sadeh of the open land of their towns may not be sold; for it is their achuzzat olam (perpetual heritage). ");
INSERT INTO engojb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","And if thy brother become poor, and his hand fails with thee; then thou shalt strengthen him; yea, though he be a ger, or a toshav; that he may live among thee. ");
INSERT INTO engojb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Take thou no neshekh of him, or increase; but fear Eloheicha; that thy brother may live among thee. ");
INSERT INTO engojb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Thou shalt not lend him thy kesef at neshekh, nor give him thy food for increase. ");
INSERT INTO engojb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am Hashem Eloheichem, which brought you forth out of Eretz Mitzrayim, to give you Eretz Kena'an, and to be Elohim unto you. ");
INSERT INTO engojb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","And if thy brother that dwelleth by thee become poor, and be sold unto thee, thou shalt not compel him to do avodat eved; ");
INSERT INTO engojb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","But as a sakhir, and as a toshav, he shall be among thee, and shall serve thee unto the Shnat HaYovel. ");
INSERT INTO engojb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","And then shall he depart from thee, both he and his banim with him, and shall return unto his own mishpochah, and unto the Achuzzat of his Avot shall he return. ");
INSERT INTO engojb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","For they are My Eved, which I brought forth out of Eretz Mitzrayim; they shall not be sold in the manner of an eved. ");
INSERT INTO engojb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Thou shalt not rule over him with rigor; but shalt fear Eloheicha. ");
INSERT INTO engojb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Both thy bondmen, and thy bondmaids, which thou shalt have, shall be of the Goyim that are round about you; of them shall ye buy eved and amah. ");
INSERT INTO engojb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Moreover of the bnei hatoshavim that do sojourn among you, of them shall ye buy, and of their mishpachot that are among you, which they fathered in your land; and they shall be your possession. ");
INSERT INTO engojb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","And ye shall take them as an inheritance for your banim after you, to inherit them for a possession; they shall be your bondmen forever; but over your brethren, the Bnei Yisroel, ye shall not rule one over another with rigor. ");
INSERT INTO engojb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","And if a ger or toshav grow rich by thee, and thy brother that dwelleth by him grow poor, and sell himself unto the foreigner among thee, or to the eker (member) mishpachat of the ger; ");
INSERT INTO engojb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","After that he is sold, his Geulah remains; one of his brethren may redeem him, ");
INSERT INTO engojb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Either his dod, or ben dod of him, may redeem him, or any that is near of kin unto him of his mishpachat may redeem him; or if he be able, he may redeem himself. ");
INSERT INTO engojb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","And he shall reckon with him that bought him from the year that he was sold to him unto the Shnat HaYovel; and the price of his release shall be based on the number of shanim, according to the value of a sakhirʼs pay shall it be with him. ");
INSERT INTO engojb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there be yet many shanim remaining, according unto them he shall give for his Geulah the kesef that he was bought for. ");
INSERT INTO engojb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","And if there remain but few shanim unto the Shnat HaYovel, then he shall count that, and according unto his shanim shall he pay the price of his Geulah. ");
INSERT INTO engojb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","And as a sakhir hired shanah b'shanah shall he be with him; and the other shall not rule with rigor over him in thy sight. ");
INSERT INTO engojb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","And if he be not redeemed in these shanim, then he shall be released in the Shnat HaYovel, both he, and his banim with him. ");
INSERT INTO engojb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For unto Me the Bnei Yisroel are avadim; they are My avadim whom I brought forth out of Eretz Mitzrayim: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ye shall not make for you elilim or pesel or set up matzevah, neither shall ye set up even maskit (carved stone) in your land, lehishtachavot (to bow down) unto it: for I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ye shall be shomer over My Shabbatot, and reverence My Mikdash: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If ye walk in My chukkot, and be shomer over My mitzvot, and do them; ");
INSERT INTO engojb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Then I will give you geshem in due season, and HaAretz shall yield her increase, and the etz hasadeh shall yield his pri. ");
INSERT INTO engojb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","And your threshing shall reach unto the vintage, and the vintage shall reach unto the sowing time: and ye shall eat your lechem to the full, and dwell in your land safely. ");
INSERT INTO engojb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","And I will give shalom in HaAretz, and ye shall lie down, and none shall make you afraid: and I will rid the savage beast out of HaAretz, neither shall the cherev pass through your land. ");
INSERT INTO engojb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","And ye shall chase your enemies, and they shall fall before you by the cherev. ");
INSERT INTO engojb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","And five of you shall chase a hundred, and a hundred of you shall put ten thousand to flight: and your enemies shall fall before you by the cherev. ");
INSERT INTO engojb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","For I will look upon you, and make you fruitful, and multiply you, and confirm My Brit (Covenant) with you. ");
INSERT INTO engojb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","And ye shall be eating the old harvest when you move out the yashan because of the chadash. ");
INSERT INTO engojb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","And I set My Mishkan among you: and My Nefesh shall not abhor you. ");
INSERT INTO engojb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","And I will walk among you, and will be Elohim to you, and ye shall be My people. ");
INSERT INTO engojb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am Hashem Eloheichem, which brought you forth out of Eretz Mitzrayim, that ye should not be their avadim; and I have broken the bars of your yoke, and made you walk head held high. ");
INSERT INTO engojb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","But if ye will not pay heed unto Me, and will not do all these mitzvot, ");
INSERT INTO engojb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","And if ye shall despise My chukkot, or if your nefesh abhor My mishpatim, so that ye will not do all My mitzvot, but that ye violate My Brit (Covenant), ");
INSERT INTO engojb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I also will do this unto you: I will even visit upon you terror, wasting disease, and the burning fever, that shall consume the eyes, and drain the nefesh: and ye shall sow your zera in vain, for your enemies shall eat it. ");
INSERT INTO engojb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","And I will set My Face against you, and ye shall be struck down before your enemies. They that hate you shall reign over you; and ye shall flee when none rodef (pursue, persecute) you. ");
INSERT INTO engojb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","And if ye will not yet for all this pay heed unto Me, then I will punish you seven times more for your chattot. ");
INSERT INTO engojb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","And I will break the ga'on (pride) of your stubbornness; and I will make your skies as barzel, and your soil as bronze; ");
INSERT INTO engojb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","And your ko'ach shall be spent in vain; for your land shall not yield her increase, neither shall the etz HaAretz yield their pri. ");
INSERT INTO engojb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","And if ye remain walking contrary unto Me, and will not pay heed unto Me, I will bring seven times more makkah (plagues) upon you according to your chattot (sins). ");
INSERT INTO engojb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will also send wild beasts among you, which shall rob you of your children, and destroy your cattle, and make you few in number; and darkheichem (your roads, ways) shall be deserted. ");
INSERT INTO engojb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","And if ye will not be corrected by Me, but will walk keri (contrary, hostile) unto Me, ");
INSERT INTO engojb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Then will I also walk b'keri (contrary, hostile) unto you, and will punish you yet seven times for your chattot. ");
INSERT INTO engojb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","And I will bring a cherev upon you, that shall avenge Nekam Brit (Vengeance of My Covenant); and when ye are gathered together within your towns, I will send the dever (pestilence) among you; and ye shall be delivered into the hand of the enemy. ");
INSERT INTO engojb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","And when I have broken the matteh (staff, supply) of your lechem, eser nashim shall bake your lechem in one oven, and they shall dole out your lechem by weight; and ye shall eat, and not be satisfied. ");
INSERT INTO engojb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","And if ye will not for all this pay heed unto Me, but walk b'keri (contrary, hostile) unto Me, ");
INSERT INTO engojb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Then I will walk keri unto you also in chamat (fury); and I, even I, will chastise you seven times for your chattot. ");
INSERT INTO engojb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","And ye shall eat the basar of your banim, and the basar of your banot shall ye eat. ");
INSERT INTO engojb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","And I will destroy your high places, and cut down chammaneichem (your pillars for worshiping the sun), and cast your carcasses upon the carcasses of your idols, and My Nefesh shall abhor you. ");
INSERT INTO engojb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","And I will turn your cities into ruins, and bring mikdesheichem (your sanctuaries) unto desolation, and I will not take delight in your re'ach nicho'ach. ");
INSERT INTO engojb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","And I will bring HaAretz into desolation; and your enemies which dwell therein shall be astonished at her. ");
INSERT INTO engojb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","And I will scatter you among the Goyim, and will draw out a cherev after you; and your land shall be desolate, and your cities ruin. ");
INSERT INTO engojb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then shall HaAretz enjoy her Shabbatot, as long as she lieth desolate, and ye be in your enemiesʼ land; even then shall HaAretz rest, and enjoy her Shabbatot. ");
INSERT INTO engojb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","As long as she lieth desolate she shall rest, because she did not rest in your Shabbatot, when ye dwelt upon her. ");
INSERT INTO engojb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","And upon them that are left alive of you I will send a fearful faintness into their hearts in the lands of their enemies; and the sound of a shaken leaf shall chase them; and they shall flee, as fleeing from a cherev; and they shall fall v'ein rodef (when none pursueth, persecutes). ");
INSERT INTO engojb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","And they shall fall one upon another, as it were before a cherev, when none pursueth; and ye shall have no standing place before your enemies. ");
INSERT INTO engojb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","And ye shall perish among the Goyim, and the eretz of your enemies shall eat you up. ");
INSERT INTO engojb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","And they that are left of you shall waste away in their avon in your enemiesʼ lands; and also in the iniquities of their avot shall they waste away with them. ");
INSERT INTO engojb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","V'hitvadu (if they shall confess) their avon, and the avon of their avot, with their treachery in which they were treacherous against Me, and that also they have walked b'keri (contrary, hostile) unto Me; ");
INSERT INTO engojb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","And that I also have walked b'keri unto them, and have brought them into the eretz of their enemies; if then their levav he'arel (uncircumcised hearts) be humbled, and they then accept their avon guilt, ");
INSERT INTO engojb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Then will I remember My Brit (covenant) with Ya'akov, and also My Brit (covenant) with Yitzchak, and also My Brit (covenant) with Avraham will I remember; and I will remember HaAretz. ");
INSERT INTO engojb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","HaAretz also shall be deserted by them, and shall enjoy her Shabbatot, while she lieth desolate without them; and they shall accept their avon: because, even because they despised My mishpatim, and because their nefesh abhorred My chukkot. ");
INSERT INTO engojb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","And yet for all that, when they be in the eretz of their enemies, I will not cast them away, neither will I abhor them, to destroy them utterly, and to break My Brit (covenant) with them: for I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","But I will for their sakes remember the Brit Rishonim (covenant of their ancestors) whom I brought forth out of Eretz Mitzrayim in the sight of the Goyim, that I might be Elohim to them: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the chukkim and mishpatim and torot, which Hashem made between Him and the Bnei Yisroel in Mt. Sinai by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Speak unto the Bnei Yisroel, and say unto them, When a man shall articulate a neder, the nefashot shall be for Hashem by thy evaluation. ");
INSERT INTO engojb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","And thy evaluation shall be of the zachar from esrim shanim even unto shishim shanah, even thy evaluation shall be fifty shekels kesef, after the shekel HaKodesh. ");
INSERT INTO engojb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","And if it be a nekevah, then thy evaluation shall be shloshim shekel. ");
INSERT INTO engojb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","And if it be from chamesh shanim even unto esrim shanah, then thy evaluation shall be of the zachar esrim shekel, and for the nekevah aseret shekalim. ");
INSERT INTO engojb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","And if it be from a month old even unto chamesh shanim, then thy evaluation shall be of the zachar chamishah shekalim kesef, and for the nekevah thy evaluation shall be shloshet shekalim kesef. ");
INSERT INTO engojb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","And if it be from shishim shanah and above, if it be a zachar, then thy evaluation shall be chamishah asar shekel, and for the nekevah asarah shekalim. ");
INSERT INTO engojb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if he be poorer than thy evaluation, then he shall present himself before the kohen, and the kohen shall value him; according to the ability of the one who vowed the neder shall the kohen value him. ");
INSERT INTO engojb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","And if it be a behemah, whereof men bring a korban unto Hashem, all that any man giveth of such unto Hashem shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He shall not exchange it, nor substitute it, a tov for a rah, or rah for tov: and if he shall at all substitute behemah for behemah, then it and its temurah (substitute) shall be kodesh. ");
INSERT INTO engojb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","And if it be any behemah temeiah, of which they do not offer a korban unto Hashem, then he shall present the behemah before the kohen; ");
INSERT INTO engojb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","And the kohen shall value it, whether it be tov or rah; as thou valuest it, who art the kohen, so shall it be. ");
INSERT INTO engojb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","But if he will at all redeem it, then he shall add chamishito (a fifth part thereof) unto thy evaluation. ");
INSERT INTO engojb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","And when a man shall set apart as kodesh his bais to be kodesh unto Hashem, then the kohen shall evaluate it, whether it be tov or rah; as the kohen shall set the value of it, so shall it remain. ");
INSERT INTO engojb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","And if he that set it apart as kodesh will redeem his bais, then he shall add the fifth part of the kesef of thy evaluation unto it, and it shall be his. ");
INSERT INTO engojb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","And if a man shall set apart as kodesh unto Hashem some part of a sadeh of his possession, then thy evaluation shall be according to its seeding; an area seeded by a homer of barley shall be valued at chamishim shekel kesef. ");
INSERT INTO engojb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he set apart as kodesh his sadeh from the Shnat HaYovel, according to thy evaluation it shall remain. ");
INSERT INTO engojb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he set apart as kodesh his sadeh after the Yovel, then the kohen shall reckon unto him the kesef according to the shanim that remain, even unto the Shnat HaYovel, and it shall be deducted from thy evaluation. ");
INSERT INTO engojb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","And if he that set apart as kodesh the sadeh will in any wise redeem it, then he shall add the fifth part of the kesef of thy evaluation unto it, and it shall be his. ");
INSERT INTO engojb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","And if he will not redeem the sadeh, or if he have sold the sadeh to ish acher (another man), it shall not be redeemed any more. ");
INSERT INTO engojb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","But the sadeh, when it is released in the Yovel, shall be kodesh unto Hashem, as a sadeh hacherem (devoted); the possession thereof shall be the kohenʼs. ");
INSERT INTO engojb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","And if a man set apart as kodesh unto Hashem a sadeh which he hath bought, which is not of the fields of his possession, ");
INSERT INTO engojb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Then the kohen shall reckon unto him the worth of thy evaluation, even unto the Shnat HaYovel: and he shall give thine evaluation in that day, as kodesh unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the Shnat HaYovel the sadeh shall return and revert unto him of whom it was bought, even to him to whom the Achuzzat HaAretz (Ancestral Heritage of the Land) did belong. ");
INSERT INTO engojb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","And all thy evaluations shall be according to the shekel HaKodesh; twenty gerah shall be the shekel. ");
INSERT INTO engojb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Only the bechor of the behemah, which should be Hashemʼs Bechor, no man shall set it apart as kodesh; whether it be shor (ox), or seh (sheep): it is Hashemʼs. ");
INSERT INTO engojb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","And if it be of a behemah hatemeiah, then he shall redeem it according to thine evaluation, and shall add a fifth part of it thereto; or if it be not redeemed, then it shall be sold according to thy evaluation. ");
INSERT INTO engojb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nevertheless, no cherem (devoted thing), that a man shall devote unto Hashem of all that he hath, both of adam and behemah, and of the sadeh of his possession, shall be sold or redeemed; every cherem is kodesh kodashim unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","No cherem, which shall be devoted of men, shall be redeemed; but shall surely be put to death. ");
INSERT INTO engojb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","And all the ma'aser HaAretz (tithe of the Land), whether of the zera HaAretz, or of the pri HaEtz, is Hashemʼs; it is kodesh unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","And if a man will at all redeem ought of his ma'aserot (tithes), he shall add thereto the fifth part thereof. ");
INSERT INTO engojb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","And concerning the ma'aser of the herd, or of the flock, even of whatsoever passeth under the rod, the tenth shall be kodesh unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","He shall not search whether it be tov or rah, neither shall he change it; and if he substitute it at all, then both it and the temurah (exchange, substitute) shall be kodesh; it shall not be redeemed. (Isaiah 53: Moshiach our temurah!) ");
INSERT INTO engojb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the mitzvot, which Hashem commanded Moshe for the Bnei Yisroel in Mt. Sinai.");
INSERT INTO engojb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","And Hashem spoke unto Moshe in the midbar of Sinai, in the Ohel Mo'ed, on the first day of the second month, in the second year after they were come out of Eretz Mitzrayim, saying, ");
INSERT INTO engojb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Take ye the rosh (top amount, census) of kol Adat Bnei Yisroel after their mishpekhot, by the bais of their avot, with the number of their shmot, every zachar by their head count; ");
INSERT INTO engojb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","From twenty years old and upward, all that are able-bodied to serve in tzava b'Yisroel (army in Yisroel); thou and Aharon shall number them by their tzva'ot (legions). ");
INSERT INTO engojb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","And with you there shall be a man of every tribe; every one Rosh of the bais of his Avot. ");
INSERT INTO engojb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","And these are the shemot haanashim that shall stand with you: of the tribe of Reuven, Elitzur ben Shede'ur; ");
INSERT INTO engojb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Of Shim'on, Shelumiel ben Tzurishaddai; ");
INSERT INTO engojb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Of Yehudah, Nachshon ben Amminadav; ");
INSERT INTO engojb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Of Yissakhar, Netanel ben Tzuar; ");
INSERT INTO engojb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Of Zevulun, Eliav ben Chelon; ");
INSERT INTO engojb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Of the bnei Yosef: of Ephrayim, Elishama ben Ammihud; of Menasheh, Gamli'el ben Pedahtzur; ");
INSERT INTO engojb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Of Binyamin, Avidan ben Gideoni; ");
INSERT INTO engojb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Of Dan, Achi'ezer ben Ammishaddai; ");
INSERT INTO engojb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Of Asher, Pagiel ben Okhran; ");
INSERT INTO engojb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Of Gad, Elyasaph ben De'uel; ");
INSERT INTO engojb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Of Naphtali, Achira ben Enan. ");
INSERT INTO engojb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These were the called men of the Edah, nasiim of the tribes of their avot, rashei alfei Yisroel (head-men of the clans of Yisroel). ");
INSERT INTO engojb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","And Moshe and Aharon took these men which had been designated by their names; ");
INSERT INTO engojb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","And they assembled kol HaEdah together on the first yom of the second month, and they declared their family after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, one by one. ");
INSERT INTO engojb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","As Hashem commanded Moshe, so he counted them in the midbar of Sinai. ");
INSERT INTO engojb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","And the bnei Reuven, Yisroelʼs bechor, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, one by one, every zachar from twenty years old and upward, all that are able-bodied to serve in tzava; ");
INSERT INTO engojb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Those that were numbered of them, even of the tribe of Reuven, were forty and six thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Of the bnei Shim'on, by their toldot, after their mishpekhot, by the bais of their avot, those that were numbered of them, according to the number of the shmot, one by one, every male from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Those that were numbered of them, even of the tribe of Shim'on, were fifty and nine thousand and three hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Of the bnei Gad, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava; ");
INSERT INTO engojb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Those that were numbered of them, even of the tribe of Gad, were forty and five thousand six hundred and fifty. ");
INSERT INTO engojb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Of the bnei Yehudah, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Those that were numbered of them, even of the tribe of Yehudah, were threescore and fourteen thousand and six hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Of the bnei Yissakhar, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Those that were numbered of them, even of the tribe of Yissakhar, were fifty and four thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Of the bnei Zevulun, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Those that were numbered of them, even of the tribe of Zevulun, were fifty and seven thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Of the bnei Yosef, namely, of the bnei Ephrayim, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Those that were numbered of them, even of the tribe of Ephrayim, were forty thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Of the bnei Menasheh, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Those that were numbered of them, even of the tribe of Menasheh, were thirty and two thousand and two hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Of the bnei Binyamin, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Those that were numbered of them, even of the tribe of Binyamin, were thirty and five thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Of the bnei Dan, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Those that were numbered of them, even of the tribe of Dan, were threescore and two thousand and seven hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Of the bnei Asher, by their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Those that were numbered of them, even of the tribe of Asher, were forty and one thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Of the bnei Naphtali, throughout their toldot, after their mishpekhot, by the bais of their avot, according to the number of the shmot, from twenty years old and upward, all that were able-bodied to serve in tzava (army); ");
INSERT INTO engojb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Those that were numbered of them, even of the tribe of Naphtali, were fifty and three thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These are those that were numbered, which Moshe and Aharon numbered, and the nasiim (princes, rulers, exalted) of Yisroel, being shneym asar (twelve) men, each one representing the bais of his avot. ");
INSERT INTO engojb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","So were all those that were numbered of the Bnei Yisroel, by the bais of their avot, from twenty years old and upward, all that were able-bodied to serve in tzava b'Yisroel (army in Yisroel); ");
INSERT INTO engojb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Even all they that were numbered were six hundred thousand and three thousand and five hundred and fifty. ");
INSERT INTO engojb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the Levi'im after the tribe of their avot were not numbered among them. ");
INSERT INTO engojb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","For Hashem had spoken unto Moshe saying, ");
INSERT INTO engojb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Only thou shalt not number the tribe of Levi, neither take the sum of them among the Bnei Yisroel; ");
INSERT INTO engojb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","But thou shalt appoint the Levi'im over the Mishkan HaEdut and over all the vessels thereof, and over all things that belong to it; they shall bear the Mishkan, and all the vessels thereof; and they shall take care of it, and shall encamp round about the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","And when the Mishkan setteth forward, the Levi'im shall take it down; and when the Mishkan is to be pitched, the Levi'im shall set it up; and the zar (stranger, outsider, unauthorized party) that cometh nigh shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","And the Bnei Yisroel shall pitch their tents, every man by his own machaneh (camp), and every man by his own degel (standard, banner), throughout their tzva'ot (hosts). ");
INSERT INTO engojb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levi'im shall encamp around the Mishkan HaEdut, that there be no ketzef (wrath) fall upon the Adat Bnei Yisroel; and the Levi'im shall be shomer mishmeret (watch the watch, attend to, keep the charge, the reverence) of the Mishkan HaEdut. ");
INSERT INTO engojb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","And the Bnei Yisroel did according to all that Hashem commanded Moshe, so did they. ");
INSERT INTO engojb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","The Bnei Yisroel shall encamp, each man under his own degel (standard, banner), with the otot (ensigns) of the bais of their avot; some distance from it, around the Ohel Mo'ed must they encamp. ");
INSERT INTO engojb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","And on the east side toward the rising of the sun shall they of the degel (standard, banner) of the machaneh of Yehudah encamp by their tzvaos: and Nachshon ben Amminadav shall be Nasi of the Bnei Yehudah. ");
INSERT INTO engojb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","And his tz'va (host), and those that were numbered of them, were threescore and fourteen thousand and six hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","And those that do encamp next unto him shall be the tribe of Yissakhar; and Netanel ben Tzuar shall be Nasi of the Bnei Yissakhar. ");
INSERT INTO engojb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","And his tz'va (host), and those that were numbered thereof, were fifty and four thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Then the tribe of Zevulun; and Eliav ben Chelon shall be Nasi of the Bnei Zevulun. ");
INSERT INTO engojb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","And his tz'va (host), and those that were numbered thereof, were fifty and seven thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","All that were numbered in the machaneh of Yehudah were an hundred thousand and fourscore thousand and six thousand and four hundred, by their tzvaos. These shall set forth first. ");
INSERT INTO engojb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","On the south side shall be the degel (standard, banner) of the machaneh of Reuven according to their tzvaos: and the Nasi of the Bnei Reuven shall be Elitzur ben Shede'ur. ");
INSERT INTO engojb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","And his tz'va (host), and those that were numbered thereof, were forty and six thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","And those which encamp by him shall be the tribe of Shim'on; and the Nasi of the Bnei Shim'on shall be Shelumiel ben Tzurishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","And his tz'va (host), and those that were numbered of them, were fifty and nine thousand and three hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Then the tribe of Gad; and the Nasi of the Bnei Gad shall be Elyasaph ben Re'uel. ");
INSERT INTO engojb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","And his tz'va (host), and those that were numbered of them, were forty and five thousand and six hundred and fifty. ");
INSERT INTO engojb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","All that were numbered in the machaneh of Reuven were an hundred thousand and fifty and one thousand and four hundred and fifty, by their tzvaos. And they shall set forth in the second rank. ");
INSERT INTO engojb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Then the Ohel Mo'ed shall set forward with the machaneh of the Levi'im in the midst of the machaneh; as they encamp, so shall they set forward, every man in his place by their degel. ");
INSERT INTO engojb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","On the west side shall be the degel of the machaneh of Ephrayim according to their tzvaos; and the Nasi of the Bnei Ephrayim shall be Elishama ben Ammihud. ");
INSERT INTO engojb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","And his tz'va (host), and those that were numbered of them, were forty thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","And by him shall be the tribe of Menasheh; and the Nasi of the Bnei Menasheh shall be Gamli'el ben Pedahtzur. ");
INSERT INTO engojb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","And his tz'va (host), and those that were numbered of them, were thirty and two thousand and two hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Then the tribe of Binyamin; and the Nasi of the Bnei Binyamin shall be Avidan ben Gideoni. ");
INSERT INTO engojb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","And his tz'va (host), and those that were numbered of them, were thirty and five thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","All that were numbered of the machaneh of Ephrayim were an hundred thousand and eight thousand and an hundred, by their tzvaos. And they shall go forward in the third rank. ");
INSERT INTO engojb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","The degel (standard, banner) of the machaneh of Dan shall be on the north side by their tzvaos; and the Nasi of the Bnei Dan shall be Achi'ezer ben Ammishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","And his tz'va (host), and those that were numbered of them, were threescore and two thousand and seven hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","And those that encamp by him shall be the tribe of Asher; and the Nasi of the Bnei Asher shall be Pagiel ben Okhran. ");
INSERT INTO engojb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","And his tz'va (host), and those that were numbered of them, were forty and one thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Then the tribe of Naphtali; and the Nasi of the Bnei Naphtali shall be Achira ben Enan. ");
INSERT INTO engojb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","And his tz'va (host), and those that were numbered of them, were fifty and three thousand and four hundred. ");
INSERT INTO engojb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","All they that were numbered in the machaneh of Dan were an hundred thousand and fifty and seven thousand and six hundred. They shall break camp last with their degel (standard, banner). ");
INSERT INTO engojb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are those which were numbered of the Bnei Yisroel by the bais of their avot; all those that were numbered of the machanot by their hosts were six hundred thousand and three thousand and five hundred and fifty. ");
INSERT INTO engojb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levi'im were not counted with the Bnei Yisroel; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","And the Bnei Yisroel did according to all that Hashem commanded Moshe; so they encamped by the degelim (standards, banners) of them, and so they set forward, every one after their mishpekhot, according to the bais of their avot. ");
INSERT INTO engojb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","These also are the toldot of Aharon and Moshe in the yom that Hashem spoke with Moshe in Mt. Sinai. ");
INSERT INTO engojb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","And these are the shmot of the Bnei Aharon: Nadav the bechor, and Avihu, El'azar, and Itamar. ");
INSERT INTO engojb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the shmot of the Bnei Aharon, the kohanim hameshuchim whose hand he filled to be kohen. ");
INSERT INTO engojb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","And Nadav and Avihu died before Hashem, when they offered eish zarah (unauthorized fire) before Hashem, in the midbar of Sinai, and they had no children; and El'azar and Itamar ministered in the kohenʼs office in the sight of Aharon their av. ");
INSERT INTO engojb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Bring the tribe of Levi near, and present them before Aharon HaKohen, that they may minister unto him. ");
INSERT INTO engojb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","And they shall be shomer mishmeret (watch the watch, keep the guard duty) for him and for the mishmeret kol HaEdah (duty of the whole Congregation) before the Ohel Mo'ed, to do avodat HaMishkan (the work, service of the Mishkan). ");
INSERT INTO engojb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","And they shall be shomer mishmeret over kol klei Ohel Mo'ed (all the vessels, furnishings of the Ohel Mo'ed) for the Bnei Yisroel, doing the avodat HaMishkan (work of the Mishkan). ");
INSERT INTO engojb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","And thou shalt give the Levi'im unto Aharon and to his banim; they are wholly given unto him from among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","And thou shalt appoint Aharon and his banim; they shall be shomer to watch over their kehunah; the zar that encroach shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","And I, hinei, I have taken the Levi'im from among the Bnei Yisroel instead of all the bechor that openeth the womb among the Bnei Yisroel; therefore the Levi'im shall be Mine; ");
INSERT INTO engojb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Because all the bechor are Mine; for on the yom that I struck down all the bechor in Eretz Mitzrayim I set apart as kodesh unto Me all the bechor in Yisroel, both man and beast: Mine shall they be: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","And Hashem spoke unto Moshe in the midbar of Sinai, saying, ");
INSERT INTO engojb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Count the Bnei Levi by the bais of their avot, by their mishpekhot; every zachar from a month old and upward shalt thou number them. ");
INSERT INTO engojb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","And Moshe numbered them according to the command of Hashem, as he had been commanded. ");
INSERT INTO engojb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","And these were the Bnei Levi by their shmot: Gershon, Kehat, and Merari. ");
INSERT INTO engojb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","And these are the shmot of the Bnei Gershon by their mishpekhot: Livni, and Shime'i. ");
INSERT INTO engojb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","And the Bnei Kehat by their mishpekhot: Amram, Yitzhar, Chevron, and Uzziel. ");
INSERT INTO engojb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","And the Bnei Merari by their mishpekhot: Machli and Mushi. These are the mishpekhot of the Levi'im according to the bais of their avot. ");
INSERT INTO engojb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","To Gershon belonged the mishpakhat of the Livni and the mishpakhat of the Shime'i: these are the mishpekhot of the Gershoni. ");
INSERT INTO engojb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Those that were numbered of them, according to the number of kol zachar (all the males), from a month old and upward, even those that were numbered of them were seven thousand and five hundred. ");
INSERT INTO engojb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The mishpekhot of the Gershoni shall encamp behind the Mishkan westward. ");
INSERT INTO engojb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","And the Nasi of the bais av of the Gershoni shall be Elyasaph ben Lael. ");
INSERT INTO engojb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","And the mishmeret of the Bnei Gershon in the Ohel Mo'ed is as follows: the Mishkan, and the Ohel, the covering thereof, and the curtain at the entrance of the Ohel Mo'ed, ");
INSERT INTO engojb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","And the curtains of the khatzer, and the curtain for the entrance of the khatzer, which is around the Mishkan, and around the mizbe'ach; and the cords of it for kol avodah thereof. ");
INSERT INTO engojb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","And to Kehat belonged the mishpakhat of the Amrami, and the mishpakhat of the Yitzhari, and the mishpakhat of the Chevroni, and the mishpakhat of the Uzzieli: these are the mishpekhot of the Kehati. ");
INSERT INTO engojb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","In the number of all the zachar, from a month old and upward, were eight thousand and six hundred, shomrei mishmeret haKodesh. ");
INSERT INTO engojb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The mishpekhot of the Bnei Kehat shall encamp on the southward side of the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","And the Nasi bais av of the mishpekhot of the Kehati shall be Elitzaphan ben Uzziel. ");
INSERT INTO engojb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","And their guard duty shall be: the Aron and the Shulchan, and the Menorah, and the Mizbechot, and the vessels of HaKodesh (the Holy Place) wherewith they minister, and the curtain, and all the avodah thereof. ");
INSERT INTO engojb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","And El'azar ben Aharon HaKohen shall be Nasi over the Nasi'ei HaLevi'im, and have the oversight of them that do guard duty over HaKodesh (the Holy Place). ");
INSERT INTO engojb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","To Merari belonged the mishpakhat of the Machli, and the mishpakhat of the Mushi: these are the mishpekhot of Merari. ");
INSERT INTO engojb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","And those that were counted of them, according to the number of all the zachar, from a month old and upward, were six thousand and two hundred. ");
INSERT INTO engojb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","And the Nasi bais av of the mishpekhot of Merari was Tzuriel ben Avichayil; these shall encamp on the side of the Mishkan northward. ");
INSERT INTO engojb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","And under the guard duty charge of the Bnei Merari shall be: the frames of the Mishkan, and the crossbars thereof, and the pillars thereof, and the bases thereof, and all the vessels thereof, and all that serveth thereto, ");
INSERT INTO engojb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","And the pillars of the khatzer round about, and their bases, and their pegs, and their cords. ");
INSERT INTO engojb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","And those that encamp in front of the Mishkan toward the east, even in front of the Ohel Mo'ed eastward, shall be Moshe, and Aharon and his banim, shomrim mishmeret HaMikdash (standing guard duty over the holy area) on behalf of the Bnei Yisroel; and the zar that shall encroach shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All that were counted of the Levi'im, which Moshe and Aharon numbered at the command of Hashem, by their mishpekhot, all the zachar from a month old and upward, were twenty and two thousand. ");
INSERT INTO engojb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","And Hashem said unto Moshe, Count all the bechor of the zachar of the Bnei Yisroel from a month old and upward, and calculate the total by their shmot. ");
INSERT INTO engojb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","And thou shalt take the Levi'im for Me — I am Hashem — instead of all the bechor among the Bnei Yisroel; and the cattle of the Levi'im instead of all the firstlings among the cattle of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","And Moshe counted, as Hashem commanded him, all the bechor among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","And it came about that all the bechor zachar by the number of shmot, from a month old and upward, of those that were numbered of them, were twenty and two thousand two hundred and threescore and thirteen. ");
INSERT INTO engojb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Take the Levi'im instead of all the bechor among the Bnei Yisroel, and the cattle of the Levi'im instead of their cattle; and the Levi'im shall be Mine: I am Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","And for those that are to be redeemed of the two hundred and threescore and thirteen of the bechor of the Bnei Yisroel, which are more than the Levi'im; ");
INSERT INTO engojb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Thou shalt even take five shekels for each one individually, after the shekel of HaKodesh shalt thou take them (the shekel is twenty gerahs); ");
INSERT INTO engojb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","And thou shalt give the kesef, wherewith those over and above them is to be redeemed, unto Aharon and to his banim. ");
INSERT INTO engojb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","And Moshe took the kesef hapeduyim of them that were over and above them that were redeemed by the Levi'im; ");
INSERT INTO engojb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Of the bechor of the Bnei Yisroel collected he the kesef; a thousand three hundred and threescore and five shekels, after the shekel of HaKodesh; ");
INSERT INTO engojb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","And Moshe gave the kesef hapeduyim unto Aharon and to his banim, according to the command of Hashem, as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Take the census of the Bnei Kehat from among the Bnei Levi, after their mishpekhot, by the bais of their avot, ");
INSERT INTO engojb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","From shloshim shanah (thirty years old) and upward even until chamishim shanah (fifty years old), all that enter into the tz'va (holy militia of Hashem) to do the melachah (work) in the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","This shall be the Avodat Bnei Kehat in the Ohel Mo'ed: kodesh hakodashim (the most holy things); ");
INSERT INTO engojb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","And when the machaneh (camp) setteth forward, Aharon shall come, and his banim, and they shall take down the Parochet (veil) of the screen, and cover the Aron HaEdut (Ark of the Testimony) with it; ");
INSERT INTO engojb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","And shall put thereon the tachash hide covering, and shall spread over it a cloth wholly sky-blue violet, and shall put in the carrying poles thereof. ");
INSERT INTO engojb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","And upon the Shulchan HaPanim they shall spread a cloth of sky-blue, and put thereon the dishes, and the incense spoons, and the offering bowls, and kesot hanesekh (pitchers of the drink offering); and Lechem HaTamid (Perpetual Bread) shall be thereon; ");
INSERT INTO engojb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","And they shall spread upon them a cloth of scarlet, and cover the same with a tachash hide covering, and shall put in the poles thereof. ");
INSERT INTO engojb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","And they shall take a cloth of sky-blue, and cover the Menorat HaMa'ohr (Menorah of Illumination), and its nerot (lamps), and its tongs, and its trays, and all the klei shemen (oil vessels) thereof, wherewith they prepare it for holy service; ");
INSERT INTO engojb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","And they shall put it and all the vessels thereof within a tachash hide covering, and shall put it upon the carrying frame. ");
INSERT INTO engojb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","And upon the Mizbach HaZahav they shall spread a cloth of sky-blue, and cover it a tachash hide covering, and shall put in place the poles thereof; ");
INSERT INTO engojb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","And they shall take all the Klei HaSharet (Utensils of Ministry), wherewith they minister in HaKodesh, and put them in a cloth of sky-blue, and cover them with a tachash hide covering, and shall put them on the carrying frame; ");
INSERT INTO engojb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","And they shall take away the ashes from the Mizbe'ach, and spread a purple cloth thereon: ");
INSERT INTO engojb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","And they shall put upon it all the utensils thereof, wherewith they minister upon it, even the fire pans, the meathooks, and the shovels, and the basins, all the Klei HaMizbe'ach; and they shall spread upon it a tachash hide covering, and put in place its poles. ");
INSERT INTO engojb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","And when Aharon and his banim have made an end of covering HaKodesh, and all the Klei HaKodesh, as the machaneh (camp) is to set forward, after that, the Bnei Kehat shall come to bear it; but they shall not touch any kodesh, lest they die. These things are the massa (burden) of the Bnei Kehat in the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","And to the pekuddat (oversight, office) of El'azar ben Aharon HaKohen pertaineth the Shemen HaMa'ohr (Oil of Illumination), and the incense spices, and the Minchat HaTamid (Continual Grain Offering), and the Shemen HaMishchah (Anointing Oil), and the Pekuddat Kol HaMishkan, and of all that therein is, in HaKodesh, and in the vessels thereof. ");
INSERT INTO engojb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","And Hashem spoke unto Moshe and unto Aharon saying, ");
INSERT INTO engojb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Cut ye not off the shevet (tribe) of the mishpekhot of the Kehati from among the Levi'im; ");
INSERT INTO engojb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","But this do unto them, that they may live, and not die, when they approach unto kodesh hakodashim (the most holy things): Aharon and his banim shall go in, and appoint them every one to his avodah (service, ministry) and to his massa (burden); ");
INSERT INTO engojb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But they shall not go in to look for a single instant at hakodesh, lest they die. ");
INSERT INTO engojb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Take also the census of the Bnei Gershon, throughout the bais avot of them, by their mishpekhot; ");
INSERT INTO engojb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","From shloshim shanah (thirty years old) and upward until chamishim shanah (fifty years old) shalt thou number them; all that enter to serve the tz'va (holy militia service of Hashem), to labor in the Avodah in the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is the Avodat Mishpekhot HaGershoni, as relates to service and massa (burden): ");
INSERT INTO engojb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","And they shall bear the curtains of the Mishkan, and the Ohel Mo'ed, its covering, and the tachash hide covering that is over the top of it, and the screen for the entrance of the Ohel Mo'ed, ");
INSERT INTO engojb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","And the hangings of the khatzer (court), and the hanging for the entrance of the sha'ar (gate) of the khatzer (court), which is around the Mishkan and around the Mizbe'ach, and their cords, and all the Klei Avodah (Utensils of Service, Ministry) of them, and all that is done for them; so shall they serve. ");
INSERT INTO engojb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","At the appointment of Aharon and his banim shall be all the Avodat Bnei HaGershoni, in all their massa (burdens), and in all their avodah (service); and ye shall appoint unto them in mishmeret (guard duty responsibility) for all their massa (burdens). ");
INSERT INTO engojb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the Avodat Mishpekhot Bnei HaGershoni in the Ohel Mo'ed; and mishmeret (guard duty responsibility) shall be under the direction of Itamar ben Aharon HaKohen. ");
INSERT INTO engojb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","As for the Bnei Merari, thou shalt number them after their mishpekhot, by the bais of their avot; ");
INSERT INTO engojb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","From shloshim shanah (thirty years old) and upward even until chamishim shanah (fifty years old) shalt thou number them, every one that entereth into the tz'va (holy militia service of Hashem), to do the work of the Avodat Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","And this is their mishmeret (guard) massa (burden), according to all their Avodah (Service, Ministry) in the Ohel Mo'ed; the frames of the Mishkan, and the cross-bars thereof, and the posts thereof, and bases thereof, ");
INSERT INTO engojb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","And the posts surrounding the khatzer, and their bases, and their tent pegs, and their cords, with all their implements, and with all their service; and by shmot (names) ye shall assign the klei mishmeret (vessels of duty) massa (burdens). ");
INSERT INTO engojb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the Avodat Mishpekhot Bnei Merari, according to all their service, in the Ohel Mo'ed under the direction of Itamar ben Aharon HaKohen. ");
INSERT INTO engojb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","And Moshe and Aharon and the Nasi'ei HaEdah (Leaders of the Congregation) counted the Bnei HaKehati after their mishpekhot, and after the bais of their avot, ");
INSERT INTO engojb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","From shloshim shanah (thirty years old) and upward even until chamishim shanah (fifty years old) shalt thou number them, every one that entereth into the tz'va (holy militia service of Hashem), to do the work of the Avodah in the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","And those that were numbered of them by their mishpekhot were two thousand seven hundred and fifty. ");
INSERT INTO engojb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These were they that were numbered of the mishpekhot HaKehati, all that might do service in the Ohel Mo'ed which Moshe and Aharon did number according to the command of Hashem by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","And those that were numbered of the Bnei Gershon, throughout their mishpekhot, and by the bais of their avot, ");
INSERT INTO engojb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","From shloshim shanah and upward even until chamishim shanah shalt thou number them, every one that entereth into the tz'va (holy militia service of Hashem), to do the work of the Avodah in the Ohel Mo'ed, ");
INSERT INTO engojb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Even those that were numbered of them, throughout their mishpekhot, by the bais of their avot, were two thousand and six hundred and thirty. ");
INSERT INTO engojb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These are they that were numbered of the Mishpekhot Bnei Gershon, of all that might do service in the Ohel Mo'ed whom Moshe and Aharon did number according to the command of Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","And those that were numbered of the Mishpekhot Bnei Merari, throughout their mishpekhot, by the bais of their avot, ");
INSERT INTO engojb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","From shloshim shanah and upward even until chamishim shanah shalt thou number them, every one that entereth into the tz'va, to do the work of the Avodah in the Ohel Mo'ed, ");
INSERT INTO engojb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Even those that were numbered of them by their mishpekhot, were three thousand and two hundred. ");
INSERT INTO engojb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These be those that were numbered of the Mishpekhot Bnei Merari, whom Moshe and Aharon numbered according to the command of Hashem by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","All those that were numbered of the Levi'im, whom Moshe and Aharon and the Nasi'ei Yisroel numbered, by their mishpekhot, and by the bais of their avot, ");
INSERT INTO engojb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","From shloshim shanah and upward even until chamishim shanah shalt thou number them, every one that entereth to do the Avodat Avodah (the Work of the Service, Ministry) and the Avodat Massa (Service, Ministry of the Burden) in the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Even those that were numbered of them, were shmonat alafim vachamesh me'ot ushmonim (eight thousand and five hundred and fourscore), ");
INSERT INTO engojb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","According to the command of Hashem they were numbered by the hand of Moshe, every one according to his Avodah (Service), and according to his Massa (Burden); thus were they counted of him, as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Command the Bnei Yisroel, that they put out of the machaneh every tzaru'a, and every one that hath a discharge, and whosoever is tameh lanefesh (unclean, defiled by reason of contact with a corpse), ");
INSERT INTO engojb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Both zachar and nekevah shall ye put out, without the machaneh shall ye put them; that they defile not their machanot, in the midst whereof I dwell. ");
INSERT INTO engojb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","And the Bnei Yisroel did so, and put them outside the machaneh; just as Hashem spoke unto Moshe, so did the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Speak unto the Bnei Yisroel, When a man or woman shall commit any chattot that men commit, l'me'ol ma'al baHashem(thereby trespassing against Hashem), and feels guilty; ");
INSERT INTO engojb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Then they shall make vidduy (confession of sin) of their chattot which they have committed; and shall make reparation in full, and add unto it the fifth part thereof, and give it unto him against whom they hath incurred liability. ");
INSERT INTO engojb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the man have no go'el unto whom reparation for the asham can be made, let the asham be recompensed unto Hashem, even to the kohen, besides the ram of the kippurim, whereby a kapporah shall be made on his behalf. ");
INSERT INTO engojb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","And every terumah of all the holy things of the Bnei Yisroel, which they bring unto the kohen, shall be his. ");
INSERT INTO engojb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","And every manʼs things set apart as kodesh shall be his; whatsoever any man giveth the kohen, it shall be his. ");
INSERT INTO engojb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Speak unto the Bnei Yisroel, and say unto them, If any manʼs isha go aside, and commit a trespass against him, ");
INSERT INTO engojb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","And a man lie with her carnally, and it be hid from the eyes of her ish, and she become tameh secretly, and there be no ed (witness) against her, neither she be caught; ");
INSERT INTO engojb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","And a ruach kina (spirit of jealousy) come upon him, and he be jealous of his isha, and she be tameh; or if a ruach kina come upon him, and he be jealous of his isha, and she be not tameh; ");
INSERT INTO engojb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Then shall the ish bring his isha unto the kohen, and he shall bring her korban for her, the tenth part of an ephah of barley meal; he shall pour no shemen upon it, nor put incense thereon; for it is a minchat kenaot (grain offering of jealousies), a minchat zikaron (grain offering of memorial), bringing avon to remembrance. ");
INSERT INTO engojb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","And the kohen shall bring her near, and set her before Hashem; ");
INSERT INTO engojb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","And the kohen shall take mayim kedoshim in an earthen vessel; and of the dust that is in the floor of the Mishkan the kohen shall take, and put it into the mayim; ");
INSERT INTO engojb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","And the kohen shall set the isha before Hashem, and unbind the hair of the isha, and put the minchat hazikaron in her hands, which is the minchat kena'ot; and the kohen shall have in his hand the mei hamarim hame'ararim (waters of bitterness that causeth the curse); ");
INSERT INTO engojb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","And the kohen shall put her under oath, and say unto the isha, If no man have lain with thee, and if thou hast not turned astray to tum'a (uncleanness, impurity) with another instead of thy husband, be thou free from these mei hamarim hame'ararim; ");
INSERT INTO engojb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if thou hast turned astray to another instead of thy ish, and if thou be defiled, and some man have lain with thee other than thine ish; ");
INSERT INTO engojb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Then the kohen shall put the isha under oath with the oath of the curse, and the kohen shall say unto the isha, Hashem make thee an alah (curse) and a shevu'ah (oath) among thy people, when Hashem doth make thy thigh to waste away, and thy belly to swell; ");
INSERT INTO engojb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","And this mayim that causeth the curse shall go into thy inner parts, to make thy belly to swell, and thy thigh to waste away; And the isha shall say, Omen, Omen. ");
INSERT INTO engojb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","And the kohen shall write these alot (curses) on a sefer, and he shall wash them into the mei hamarim; ");
INSERT INTO engojb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","And he shall cause the isha to drink the mei hamarim hame'ararim; and the mayim hame'ararim shall enter into her, and become bitter. ");
INSERT INTO engojb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Then the kohen shall take the minchat hakena'ot out of the yad haisha, and shall wave the minchah before Hashem, and offer it upon the Mizbe'ach: ");
INSERT INTO engojb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","And the kohen shall take a handful of the minchah, even the memorial thereof, and burn it upon the Mizbe'ach, and afterward shall cause the isha to drink the mayim. ");
INSERT INTO engojb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","And when he hath made her to drink the mayim, then it shall come to pass, that, if she be defiled, and have done trespass against her ish, that the mayim hame'ararim shall enter into her, and become bitter, and her belly shall swell, and her thigh shall waste away; and the isha shall become a curse among her people. ");
INSERT INTO engojb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","And if the isha be not defiled, but be tehorah (clean); then she shall be free, and shall conceive zera. ");
INSERT INTO engojb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the torat hakena'ot (law of jealousy), when an isha goeth astray to another instead of her ish, and is defiled; ");
INSERT INTO engojb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Or when the ruach kinah cometh upon him, and he be jealous over his isha, and shall set the isha before Hashem, and the kohen shall execute upon her all this torah. ");
INSERT INTO engojb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Then shall the ish be free from guilt from avon, and this isha shall bear her avon. ");
INSERT INTO engojb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Speak unto the Bnei Yisroel, and say unto them, When either ish or isha shall separate themselves to vow a neder of a Nazir, to separate themselves unto Hashem; ");
INSERT INTO engojb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","He shall separate himself from yayin and shechar (fermented drink), and shall drink no chometz (vinegar) of yayin, or chometz of shechar, neither shall he drink any grape juice, nor eat moist grapes, or dried. ");
INSERT INTO engojb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Kol hayamim of his nazir (vow as a nazir) shall he eat nothing that is made of the gefen hayayin, from the seeds even to the grape-skins. ");
INSERT INTO engojb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Kol hayamim of the neder of his nazir there shall no razor come upon his head; until hayamim be fulfilled, in the which he separateth himself unto Hashem, he shall be kadosh, and shall let the locks of the hair of his head grow. ");
INSERT INTO engojb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Kol yemei of his nezer (abstinence) unto Hashem he shall go not near nefesh met (dead body). ");
INSERT INTO engojb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","He shall not make himself tameh for his av, or for his em, for his ach, or for his achot, when they die; because the Nezer Elohav (Consecration of his G-d) is upon his head. ");
INSERT INTO engojb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kol yemei of his nazir (separation) he is kadosh unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","And if any man die very suddenly by him, and he hath made tameh the head of his nezer (abstinence); then he shall shave his head in the yom of his tohorah, on the yom hashevi'i shall he shave it. ");
INSERT INTO engojb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","And on the yom hashemi'ni he shall bring two doves, or two young pigeons, to the kohen, to the entrance of the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","And the kohen shall offer the one for a chattat (sin offering), and the other for an olah (burnt offering), and make kapporah for him, because he sinned by the nefesh (dead body), and shall make kadosh his head that same day. ");
INSERT INTO engojb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","And he shall consecrate unto Hashem the yemei of his nazir, and shall bring a lamb of the first year for an asham (trespass offering); but the yamim harishonim shall not be counted, because his nazir was tameh. ");
INSERT INTO engojb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","And this is the Torat HaNazir, when the yamim of his nazir are fulfilled: he shall be brought unto the entrance of the Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","And he shall offer his korban unto Hashem, one he-lamb of the first year tamim (without blemish) for an olah (burnt offering), and one ewe lamb of the first year temimah (without blemish) for a chattat, and one ram tamim (without blemish) for shelamim (peace offerings), ");
INSERT INTO engojb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","And a basket of matzot, cakes of fine flour mingled with shemen, and wafers of matzot meshuchim (anointed) with oil, and their minchot (grain offerings), and their nesakhim (drink offerings). ");
INSERT INTO engojb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","And the kohen shall bring them before Hashem, and shall offer his chattat, and his olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","And he shall offer the ram for a zevach shelamim (sacrifice of peace offerings) unto Hashem, with the basket of matzot; the kohen shall offer also his minchah (grain offering), and his nesekh (drink offering). ");
INSERT INTO engojb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","And the Nazir shall shave the head of his nezer at the entrance of the Ohel Mo'ed, and shall take the hair of the head of his nezer, and put it in the eish (fire) which is under the zevach hashelamim (sacrifice of peace offerings). ");
INSERT INTO engojb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","And the kohen shall take the boiled shoulder of the ram, and one challat matzah (loaf of matzah) out of the basket, and one unleavened wafer, and shall put them upon the hands of the Nazir, after the hair of his nezer (abstinence) is shaven; ");
INSERT INTO engojb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","And the kohen shall wave them for a wave offering before Hashem; this is kodesh for the kohen, with the breast of the wave offering and thigh of the terumah (raised-up presentation); and after that the Nazir may drink yayin. ");
INSERT INTO engojb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","This is the Torat HaNazir who hath vowed, and of his korban unto Hashem for his nezer (abstinence), in addition to whatever else his hand shall afford, according to the neder (vow) which he vowed, so he must do after the torah of his Nazir. ");
INSERT INTO engojb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Speak unto Aharon and unto his Banim, saying, On this wise ye shall bless the Bnei Yisroel, saying unto them, ");
INSERT INTO engojb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Y'varekhekha Adonai v'yishmerekha (Hashem bless thee, and keep thee); ");
INSERT INTO engojb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ya'er Adonai panav eleikha vichunekha (Hashem make His face shine upon thee, and be gracious unto thee); ");
INSERT INTO engojb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yissa Adonai panav eleikha v'yasem l'kha shalom (Hashem lift up His countenance upon thee, and give thee shalom). ");
INSERT INTO engojb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","And they shall put My Shem upon the Bnei Yisroel, and I will bless them. ");
INSERT INTO engojb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","And it came to pass on the day that Moshe had fully set up the Mishkan, and had anointed it, and set it apart as kodesh, and all the instruments thereof, both the Mizbe'ach and all the vessels thereof, and had anointed them, and set them apart as kodesh, ");
INSERT INTO engojb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","That the Nasiim (Rulers) of Yisroel, heads of the Bais of their Avot, who were the Nasiim of the tribes, and were over them that were numbered, offered; ");
INSERT INTO engojb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","And they brought their korban before Hashem, six covered carts, and twelve oxen; a cart for two of the Nasiim, and for each one an ox; and they brought them before the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Take it of them, that they may be for the service of the Ohel Mo'ed; and thou shalt give them unto the Levi'im, to every man according to his service. ");
INSERT INTO engojb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","And Moshe took the carts and the oxen, and gave them unto the Levi'im. ");
INSERT INTO engojb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Two carts and four oxen he gave unto the Bnei Gershon, according to their service; ");
INSERT INTO engojb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","And four carts and eight oxen he gave unto the Bnei Merari, according unto their service, under the hand of Itamar ben Aharon HaKohen. ");
INSERT INTO engojb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But unto the Bnei Kehat he gave none, because the service of HaKodesh belonging unto them was that they should bear upon their shoulders. ");
INSERT INTO engojb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","And the Nasiim offered for dedicating of the Mizbe'ach in the day that it was anointed, even the Nasiim (Rulers) offered their korban before the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","And Hashem said unto Moshe, They shall offer their korban, each Nasi on his day, for the dedicating of the Mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","And he that offered his korban the first day was Nachshon Ben Amminadav, of the tribe of Yehudah; ");
INSERT INTO engojb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","And his korban was one silver bowl, the weight thereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to the shekel HaKodesh; both of them were full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","One ladle of ten shekels of zahav, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Nachshon ben Amminadav. ");
INSERT INTO engojb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day Netanel ben Tzuar, prince of Yissakhar, did offer: ");
INSERT INTO engojb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He offered for his korban one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","One ladle of zahav of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Netanel ben Tzuar. ");
INSERT INTO engojb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day Eliav ben Chelon, Nasi of the Bnei Zevulun, did offer: ");
INSERT INTO engojb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Eliav ben Chelon. ");
INSERT INTO engojb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day Elitzur ben Shede'ur, Nasi of the Bnei Reuven, did offer: ");
INSERT INTO engojb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His korban was one silver bowl of the weight of an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Elitzur ben Shede'ur. ");
INSERT INTO engojb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day Shelumiel ben Tzurishaddai, Nasi of the Bnei Shim'on, did offer: ");
INSERT INTO engojb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Shelumiel ben Tzurishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day Elyasaph ben De'uel, Nasi of the Bnei Gad, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His korban was one silver bowl of the weight of an hundred and thirty shekels, a silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Elyasaph ben De'uel. ");
INSERT INTO engojb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day Elishama ben Ammihud, Nasi of the Bnei Ephrayim, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Elishama ben Ammihud. ");
INSERT INTO engojb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day Gamli'el ben Pedahtzur, Nasi of the Bnei Menasheh offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His korban was one silver bowl of the weight of an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","One young bull, one ram, one lamb of the first year, for an olah (burnt offering); ");
INSERT INTO engojb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Gamli'el ben Pedahtzur. ");
INSERT INTO engojb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day Avidan ben Gideoni, Nasi of the Bnei Binyamin, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Avidan ben Gideoni. ");
INSERT INTO engojb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day Achi'ezer ben Ammishaddai, Nasi of the Bnei Dan, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Achi'ezer ben Ammishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day Pagiel ben Okhran, Nasi of the Bnei Asher, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Pagiel ben Okhran. ");
INSERT INTO engojb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day Achira ben Enan, Nasi of the Bnei Naphtali, offered: ");
INSERT INTO engojb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His korban was one silver bowl, the weight whereof was an hundred and thirty shekels, one silver basin of seventy shekels, according to shekel HaKodesh; both of them full of fine flour mixed with oil for a minchah; ");
INSERT INTO engojb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","One golden ladle of ten shekels, full of ketoret; ");
INSERT INTO engojb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","One young bull, one ram, one lamb of the first year, for an olah; ");
INSERT INTO engojb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","One kid of the goats for a chattat; ");
INSERT INTO engojb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","And for a zevach of shelamim, two oxen, five rams, five he-goats, five lambs of the first year; this was the korban of Achira ben Enan. ");
INSERT INTO engojb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","This was the dedication of the Mizbe'ach, in the day when it was anointed, by the Nasiim of Yisroel: twelve bowls of kesef, twelve silver basins, twelve spoons of zahav: ");
INSERT INTO engojb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each bowl of silver weighing an hundred and thirty shekels, each basin seventy; all the silver vessels weighed two thousand and four hundred shekels, according to the shekel HaKodesh; ");
INSERT INTO engojb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The golden spoons were twelve, full of ketoret, weighing ten shekels apiece, according to the shekel HaKodesh; all the zahav of the spoons was an hundred and twenty shekels. ");
INSERT INTO engojb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","All the oxen for the olah (burnt offering) were twelve bulls, the rams twelve, the lambs of the first year twelve, with their minchah; and the kids of the goats for chattat twelve. ");
INSERT INTO engojb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","And all the oxen for the zevach of the shelamim were twenty and four bulls, the rams sixty, the he-goats sixty, the lambs of the first year sixty. This was the dedication of the Mizbe'ach, after that it was anointed. ");
INSERT INTO engojb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","And when Moshe was gone into the Ohel Mo'ed to speak with Him, then he heard the voice of One speaking unto him from over the kapporet that was upon the Aron HaEdut, from between the two keruvim; so He spoke unto him. ");
INSERT INTO engojb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Speak unto Aharon and say unto him, When thou set up the Nerot (lamps), the seven Nerot (lamps) shall cast light in front of the Menorah. ");
INSERT INTO engojb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aharon did so; he set up the Nerot (lamps) thereof to give light in front of the Menorah, as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","And the Menorah was made thus of hammered zahav, from its base unto its flower was it hammered out; according unto the mar'eh (pattern) which Hashem had shown Moshe, so he made the Menorah. ");
INSERT INTO engojb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Take the Levi'im from among the Bnei Yisroel, and make them tahor. ");
INSERT INTO engojb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","And thus shalt thou do unto them, to make them tahor: Sprinkle water of purification upon them, and let them cause a razor to pass over their basar, and let them wash their clothes, and so make themselves tahor. ");
INSERT INTO engojb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then let them take a young bull with its minchah, even fine flour mixed with shemen, and another young bull shalt thou take for a chattat. ");
INSERT INTO engojb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","And thou shalt bring the Levi'im before the Ohel Mo'ed: and thou shalt gather Kol Adat Bnei Yisroel together; ");
INSERT INTO engojb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","And thou shalt bring the Levi'im before Hashem; and the Bnei Yisroel shall lay their hands upon the Levi'im; ");
INSERT INTO engojb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","And Aharon shall offer the Levi'im before Hashem for a tenufah from the Bnei Yisroel, that they may perform the Avodat Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","And the Levi'im shall lay their hands upon the rosh of the bulls; and thou shalt offer the one for a chattat, and the other for an olah, unto Hashem, to make kapporah for the Levi'im. ");
INSERT INTO engojb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","And thou shalt set the Levi'im before Aharon, and before his Banim, and offer them for a tenufah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Thus shalt thou set apart as separate the Levi'im from among the Bnei Yisroel; and the Levi'im shall be Mine. ");
INSERT INTO engojb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","And after that shall the Levi'im go in to do the service of the Ohel Mo'ed; and thou shalt make them tahor and offer them for a tenufah. ");
INSERT INTO engojb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For they are wholly given unto Me from among the Bnei Yisroel; instead of such as open every womb, even instead of the Bechor Kol Bnei Yisroel, have I taken them unto Me. ");
INSERT INTO engojb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For Kol Bechor Bnei Yisroel are Mine, both adam and behemah; on the day that I struck down kol bechor in Eretz Mitzrayim I set them apart as kodesh for Myself. ");
INSERT INTO engojb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","And I have taken the Levi'im takhat (instead of) Kol Bechor Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","And I have given the Levi'im as a gift to Aharon and to his Banim from among the Bnei Yisroel, to do the Avodat Bnei Yisroel in the Ohel Mo'ed, and to make kapporah for the Bnei Yisroel; so that there be no plague among the Bnei Yisroel, when the Bnei Yisroel come near unto HaKodesh. ");
INSERT INTO engojb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","And Moshe, and Aharon, and Kol Adat Bnei Yisroel, did with the Levi'im according unto all that Hashem commanded Moshe concerning the Levi'im, so did the Bnei Yisroel unto them. ");
INSERT INTO engojb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","And the Levi'im purified themselves, and they immersed their clothes; and Aharon offered them as a tenufah before Hashem; and Aharon made kapporah for them to make them tahor. ");
INSERT INTO engojb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","And after that went the Levi'im in to do their Avodah in the Ohel Mo'ed before Aharon, and before his Banim; just as Hashem had commanded Moshe concerning the Levi'im, so did they with them. ");
INSERT INTO engojb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","This is it that belongeth unto the Levi'im: from twenty and five years old and upward they shall enter to perform service in the Avodat Ohel Mo'ed; ");
INSERT INTO engojb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","And from the age of fifty years they shall retire from the service of the Avodah and shall serve no more; ");
INSERT INTO engojb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","But shall assist with their brethren in the Ohel Mo'ed, in performing their duties, and shall do no Avodah. Thus shalt thou do with the Levi'im regarding their duties. ");
INSERT INTO engojb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","And Hashem spoke unto Moshe in the Midbar Sinai, in the first month of the second year after they were come out of Eretz Mitzrayim, saying, ");
INSERT INTO engojb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Let the Bnei Yisroel also observe the Pesach at its appointed season. ");
INSERT INTO engojb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","In the fourteenth day of this month, at twilight, ye shall observe it in its appointed season; according to kol chukkot of it, according to all the mishpatim thereof, shall ye observe it. ");
INSERT INTO engojb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","And Moshe spoke unto the Bnei Yisroel, that they should observe the Pesach. ");
INSERT INTO engojb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","And they observed the Pesach on the fourteenth day of the first month at twilight in the Midbar Sinai; according to all that Hashem commanded Moshe, so did the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","And there were certain men, who were teme'im by the nefesh (dead body) of an adam, that they could not observe the Pesach on that day; and they came before Moshe and before Aharon on that day; ");
INSERT INTO engojb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","And those men said unto him, We are teme'im (unclean) by the nefesh of a man; but why should we be kept back, that we may not offer a korban Hashem in its appointed season among the Bnei Yisroel? ");
INSERT INTO engojb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","And Moshe said unto them, Stand still, and I will hear what Hashem will command concerning you. ");
INSERT INTO engojb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Speak unto the Bnei Yisroel, saying, If any man of you or of your descendants shall be tamei by reason of a dead body, or be in a journey afar off, yet he shall observe the Pesach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","The fourteenth day of the second month at twilight they shall observe it, and eat it with matzot and merorim (bitter herbs). ");
INSERT INTO engojb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They shall leave none of it unto boker, nor break any bone of it; according to all the chukkat of the Pesach they shall observe it. ");
INSERT INTO engojb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But the man that is tahor, and is not in a journey, and faileth to observe the Pesach, even the same nefesh shall be cut off from among his people; because he brought not the korban Hashem at its appointed time, that man shall bear his sin. ");
INSERT INTO engojb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","And if a ger shall stay for a while among you, and will observe the Pesach unto Hashem; according to the chukkat of the Pesach, and according to the mishpat thereof, so shall he do; ye shall have one chukkat, both for the ger, and for him that was born in the land. ");
INSERT INTO engojb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","And on the day that the Mishkan was set up the Anan covered the Mishkan, namely, the Ohel HaEdut; and at erev there was upon the Mishkan as it were the appearance of eish, until boker. ");
INSERT INTO engojb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","So it was tamid: the Anan covered it by day, and the appearance of eish by lailah. ");
INSERT INTO engojb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","And when the Anan was lifted up from the Ohel, then after that the Bnei Yisroel set out; and in the place where the Anan abode, there the Bnei Yisroel encamped. ");
INSERT INTO engojb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At the mouth of Hashem the Bnei Yisroel set out, and at the mouth of Hashem they encamped; as long as the Anan abode upon the Mishkan they encamped. ");
INSERT INTO engojb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","And when the Anan tarried long upon the Mishkan many days, then the Bnei Yisroel obeyed the order of Hashem, and did not set out. ");
INSERT INTO engojb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","And so it was, when the Anan was a few days upon the Mishkan; according to the mouth of Hashem they encamped; according to the mouth of Hashem they set out. ");
INSERT INTO engojb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","And so it was, when the Anan abode from erev unto boker, and that the Anan was lifted up in the boker, then they set out; whether it was by yomam valailah that the Anan was lifted up, they set out. ");
INSERT INTO engojb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Or whether it were two days, or a month, or longer, that the Anan tarried over the Mishkan remaining thereon, the Bnei Yisroel abode in their tents, and did not set out; but when it was lifted up, they set out. ");
INSERT INTO engojb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","At the mouth of Hashem they encamped, and at the mouth of Hashem they set out; they obeyed the order of Hashem, at the mouth of Hashem by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Make thee two khatzotzerot (trumpets) of silver; of a whole piece shalt thou make them; that thou mayest use them for the calling of the Edah, and for the setting out of the machanot. ");
INSERT INTO engojb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","And when they shall sound them, Kol HaEdah shall assemble themselves to thee at the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","And if they sound but with one, then the Nasi'im, which are heads of Yisroelʼs thousands, shall gather themselves unto thee. ");
INSERT INTO engojb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When ye sound a teruah, then the machanot that camp on the east shall go forward. ");
INSERT INTO engojb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When ye sound a teruah the second time, then the machanot that camp on the south shall set out; they shall sound a teruah for their settings out. ");
INSERT INTO engojb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But when the Kahal is to be gathered together, ye shall sound it, but ye shall not sound a teruah. ");
INSERT INTO engojb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","And the Bnei Aharon, the kohanim, shall sound the khatzotzerot; and they shall be to you for a chukkat olam throughout your dorot. ");
INSERT INTO engojb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","And if ye go into milchamah (battle) in your land against the enemy that oppresseth you, then ye shall sound a blast on the khatzotzerot; and ye shall be remembered before Hashem Eloheichem, and ye shall be saved from your enemies. ");
INSERT INTO engojb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Also in the day of your simcha, and in your moadim, and in the Rosh-Chodesh, ye shall sound a blast on the khatzotzerot over your olot, and over the zevakhim of your shelamim; that they may be to you for a memorial reminder before Eloheichem: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","And it came to pass on the twentieth day of the second month, in the second year, that the Anan was lifted up from off the Mishkan HaEdut. ");
INSERT INTO engojb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","And the Bnei Yisroel set out in their travels from the Midbar Sinai; and the Anan rested in the Midbar Paran. ");
INSERT INTO engojb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","And they first set out according to the mouth of Hashem by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","First in place went the degel of the machaneh of the Bnei Yehudah according to their tzivos; and over his division was Nachshon ben Amminadav. ");
INSERT INTO engojb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","And over the division of the tribe of the Bnei Yissakhar was Netanel ben Tzuar. ");
INSERT INTO engojb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","And over the division of the tribe of the Bnei Zevulun was Eliav ben Chelon. ");
INSERT INTO engojb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","And the Mishkan was taken down; and the Bnei Gershon and the Bnei Merari set out, bearing the Mishkan. ");
INSERT INTO engojb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","And the degel of the machaneh of Reuven set out according to their tzivos (armies); and over his division was Elitzur ben Shede'ur. ");
INSERT INTO engojb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","And over the division of the tribe of the Bnei Shim'on was Shelumiel ben Tzurishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","And over the division of the tribe of the Bnei Gad was Elyasaph ben De'uel. ");
INSERT INTO engojb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","And the descendants of Kehat set out, bearing the Mikdash; and they would erect the Mishkan before their arrival. ");
INSERT INTO engojb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","And the degel of the machaneh of the Bnei Ephrayim set out according to their tzivos (armies); and over his division was Elishama ben Ammihud. ");
INSERT INTO engojb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","And over the division of the tribe of the Bnei Menasheh was Gamli'el ben Pedahtzur. ");
INSERT INTO engojb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","And over the division of the tribe of the Bnei Binyamin was Avidan ben Gideoni. ");
INSERT INTO engojb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","And the degel of the machaneh of the Bnei Dan set out, which formed the rear guard of all the machanot throughout their tzivos; and over his division was Achi'ezer ben Ammishaddai. ");
INSERT INTO engojb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","And over the division of the tribe of the Bnei Asher was Pagiel ben Okhran. ");
INSERT INTO engojb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","And over the division of the tribe of the Bnei Naphtali was Achira ben Enan. ");
INSERT INTO engojb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Thus was the order of march of the Bnei Yisroel according to their tzivos (armies), when they set out. ");
INSERT INTO engojb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","And Moshe said unto Chovav ben Reuel the Midyani, Mosheʼs khoten (father-in-law), We are traveling unto the place of which Hashem said, I will give it you: Come thou with us, and we will do thee good; for Hashem hath promised tov concerning Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","And he said unto him, I will not go; but I will depart to mine own land, and to my moledet. ");
INSERT INTO engojb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","And he said, Leave us not, please; forasmuch as thou hast da'as how we are to encamp in the midbar, and thou mayest be to us as eyes. ");
INSERT INTO engojb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","And it shall be, if thou go with us, yea, it shall be, that what tov Hashem shall do unto us, the same will we share with thee. ");
INSERT INTO engojb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","And they departed from the Mountain of Hashem three daysʼ journey; the Aron Brit Hashem went before them in the three daysʼ derech, to search out a menuchah for them. ");
INSERT INTO engojb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","And the Anan of Hashem was upon them by day, when they set out from the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","And it came to pass, when the Aron set out, that Moshe said, Rise up, Hashem, and let Thine enemies be scattered; and let them that hate Thee flee before Thee. ");
INSERT INTO engojb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when it rested, he said, Return, Hashem, unto the countless thousands of Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","And when the people complained, it displeased Hashem; Hashem heard it; His anger was kindled; and the Eish Hashem burned among them, and consumed them that were at the edge of the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","And the people cried unto Moshe; and when Moshe davened unto Hashem, the eish was quenched. ");
INSERT INTO engojb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","He called shem hamakom Taverah because the Eish Hashem burned among them. ");
INSERT INTO engojb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","And the rabble that was among them fell a-lusting; and the Bnei Yisroel also wept again, and said, If only we had basar to eat! ");
INSERT INTO engojb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish, which we did eat in Mitzrayim at no cost; the cucumbers, and the melons, and the leeks, and the onions, and the garlic; ");
INSERT INTO engojb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now our nefesh is dried up; there is nothing at all, besides this manna, before our eyes. ");
INSERT INTO engojb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","And the manna was like coriander seed, and the color thereof like the color of white gum resin. ");
INSERT INTO engojb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","And the people went about and gathered it, and ground it in handmills, or crushed it in the mortar, and baked it in pans, and made cakes of it; and the taste of it was like the taste of cakes prepared of shemen. ");
INSERT INTO engojb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","And when the dew fell upon the machaneh in the lailah, the manna fell with it. ");
INSERT INTO engojb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Then Moshe heard the people wailing throughout their mishpekhot, every man in the entrance of his ohel; and the anger of Hashem was kindled greatly; Moshe also was displeased. ");
INSERT INTO engojb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","And Moshe said unto Hashem, Why hast Thou afflicted Thy eved? And why have I not found chen (favor) in Thy sight, that Thou layest the massa (burden) of all this people upon me? ");
INSERT INTO engojb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Have I conceived all this people? Have I fathered them, that Thou shouldest say unto me, Carry them in thy bosom, as the one nursing beareth the nursing infant, unto the land which Thou didst swear unto their avot? ");
INSERT INTO engojb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where should I get basar to give unto all this people? For they wail unto me, saying, Give us basar, that we may eat. ");
INSERT INTO engojb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able to carry all this people alone, because it is too heavy for me. ");
INSERT INTO engojb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","And if Thou deal thus with me, kill me, please, at once, if I have found chen in Thy sight; and let me not see my wretchedness. ");
INSERT INTO engojb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","And Hashem said unto Moshe, Gather unto Me seventy men of the Zekenim of Yisroel, whom thou knowest to be the Ziknei HaAm, and officers over them; and bring them unto the Ohel Mo'ed, that they may stand there with thee. ");
INSERT INTO engojb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","And I will come down and speak with thee there; and I will take of the Ruach that is upon thee, and will put upon them; and they shall bear the massa HaAm (burden of the People) with thee, that thou bear it not thyself alone. ");
INSERT INTO engojb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","And say thou unto the people, Set yourselves apart as kodesh against tomorrow, and ye shall eat basar; for ye have wept in the ears of Hashem, saying, Who shall give us basar to eat? For it was well with us in Mitzrayim; therefore Hashem will give you basar, and ye shall eat. ");
INSERT INTO engojb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Lo (not) ye shall eat one day, nor two days, nor five days, neither ten days, nor twenty days; ");
INSERT INTO engojb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","But even a whole month, until it come out at your nostrils, and it be loathsome unto you; because that meastem (ye have rejected)Hashem Who is among you, and have wept before Him, saying, Why came we forth out of Mitzrayim? ");
INSERT INTO engojb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","And Moshe said, The people, among whom I am, are 600,000 men on foot; and Thou hast said, I will give them basar, that they may eat a whole month. ");
INSERT INTO engojb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Shall the flocks and the herds be slain for them, to suffice them? Or shall all the dag (fish) of the yam be gathered together for them, to suffice them? ");
INSERT INTO engojb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","And Hashem said unto Moshe, Is the Yad Hashem cut short? Thou shalt see now whether My Devar shall come to pass unto thee or not. ");
INSERT INTO engojb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","And Moshe went out, and told HaAm the divrei Hashem, and gathered the seventy men of the Ziknei HaAm, and set them round about the Ohel Moed. ");
INSERT INTO engojb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","And Hashem came down in an Anan, and spoke unto him, and took of the Ruach that was upon him, and gave unto the seventy Zekenim; and it came to pass, that, when the Ruach rested upon them, they prophesied, but did not continue. ");
INSERT INTO engojb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","But there remained two of the anashim in the machaneh, the shem of the one was Eldad, and the shem of the other Medad: and the Ruach rested upon them; and they were of them that were listed, but went not out unto the Ohel Moed; and they prophesied in the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","And there ran a young man, and told Moshe, and said, Eldad and Medad do prophesy in the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","And Yehoshua Ben Nun, the mesharet Moshe, one of his chosen young men, answered and said, Moshe adoni, forbid them. ");
INSERT INTO engojb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","And Moshe said unto him, Are you jealous for my sake? If only kol Am Hashem were neviim, and that Hashem would put His Ruach upon them! ");
INSERT INTO engojb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","And Moshe went back to the machaneh, he and the Ziknei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","And there went forth a wind from Hashem, it drove in quail from the yam, brought them down over the machaneh at a height of two cubits from the ground for the distance of a dayʼs journey all around the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","And the people stood up all that yom, and kol halailah, and all the next day, and they gathered in the quail; he that gathered least gathered ten chomers; and they spread them all out for themselves round about the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","And while the basar was yet between their teeth, before it was chewed, the wrath of Hashem was kindled against the people, and Hashem struck down the people with a makkah rabbah me'od (a very great plague). ");
INSERT INTO engojb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","And the shem of that place was called Kivrot-Hata'avah (graves of greed) because there they buried the people that lusted. ");
INSERT INTO engojb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","And the people set out from Kivrot-Hata'avah unto Chatzerot; and abode at Chatzerot. ");
INSERT INTO engojb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","And Miryam and Aharon spoke against Moshe because of the Cushite woman whom he had married; for he had married a Kushite woman. ");
INSERT INTO engojb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","And they said, Hath Hashem indeed spoken only by Moshe? Hath He not spoken also by us? And Hashem heard it. ");
INSERT INTO engojb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Now the man Moshe was anav me'od, above all the men which were upon the face of ha'adamah.) ");
INSERT INTO engojb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","And Hashem spoke suddenly unto Moshe, and unto Aharon, and unto Miryam, Come out ye three unto the Ohel Mo'ed. And they three came out. ");
INSERT INTO engojb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","And Hashem came down in an Ammud Anan, and stood in the entrance of the Ohel, and He called Aharon and Miryam; and they both came forth. ");
INSERT INTO engojb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","And He said, Hear now My words: If there be a navi among you, I Hashem will reveal Myself unto him in a mar'ah (vision), and will speak unto him in a chalom. ");
INSERT INTO engojb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Avdi Moshe is not so, who is ne'eman (faithful) in all Mine Bais. ");
INSERT INTO engojb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","With him will I speak peh el peh, plainly, and not in dark sayings; and the temuna (form) of Hashem shall he behold; why then were ye not afraid to speak against Avdi Moshe? ");
INSERT INTO engojb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","And the anger of Hashem was kindled against them; and He departed. ");
INSERT INTO engojb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","And the Anan departed from off the Ohel Moed; and, hinei, Miryam became metzora'at (leprous), white as snow: and Aharon looked upon Miryam, and, hinei, she was metzora'at. ");
INSERT INTO engojb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","And Aharon said unto Moshe, Alas, adoni, I beseech thee, hold not the chattat (sin) against us, wherein we have done foolishly, and wherein we have sinned. ");
INSERT INTO engojb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Let her not be as one dead, of whom the basar is half consumed when he cometh out of his motherʼs womb. ");
INSERT INTO engojb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","And Moshe cried unto Hashem, saying, El (G-d), refah (heal) her now, I beseech thee. ");
INSERT INTO engojb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","And Hashem said unto Moshe, If her av had but spit in her face, should she not be in disgrace seven days? Let her be exiled from the machaneh seven days, and after that let her be received in again. ");
INSERT INTO engojb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","And Miryam was exiled from the machaneh seven days; and HaAm did not set out till Miryam was received in again. ");
INSERT INTO engojb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","And afterward HaAm removed from Chatzerot, and encamped in the Midbar Paran. ");
INSERT INTO engojb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Send thou anashim, that they may spy out Eretz Kena'an, which I give unto the Bnei Yisroel: of every tribe of their avot shall ye send a man, every one a nasi among them. ");
INSERT INTO engojb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","And Moshe by the mouth of Hashem sent them from the Midbar Paran; all those men were Roshei Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","And these were their shmot: of the tribe of Reuven, Shammua ben Zakur. ");
INSERT INTO engojb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Of the tribe of Shim'on, Shaphat ben Chori. ");
INSERT INTO engojb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Of the tribe of Yehudah, Kalev ben Yephunneh. ");
INSERT INTO engojb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Of the tribe of Yissakhar, Yigal ben Yosef. ");
INSERT INTO engojb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Of the tribe of Ephrayim, Hoshea ben Nun. ");
INSERT INTO engojb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Of the tribe of Binyamin, Palti ben Raphu. ");
INSERT INTO engojb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Of the tribe of Zevulun, Gaddiel ben Sodi. ");
INSERT INTO engojb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Of the tribe of Yosef, namely, of the tribe of Menasheh, Gaddi ben Susi. ");
INSERT INTO engojb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Of the tribe of Dan, Ammi'el ben Gemalli. ");
INSERT INTO engojb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Of the tribe of Asher, Setur ben Micha'el. ");
INSERT INTO engojb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Of the tribe of Naphtali, Nachbi ben Vophsi. ");
INSERT INTO engojb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Of the tribe of Gad, Geuel ben Machi. ");
INSERT INTO engojb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the shmot of the men which Moshe sent to spy out the land. And Moshe called Hoshea ben Nun Yehoshua. ");
INSERT INTO engojb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","And Moshe sent them to spy out Eretz Kena'an, and said unto them, Get you up to the Negev, and go up into the mountain; ");
INSERT INTO engojb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","And see the land, what it is like, and the people that dwelleth therein, whether they be strong or weak, few or many; ");
INSERT INTO engojb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","And what the land is that they dwell in, whether it be good or bad; and what cities they be that they dwell in, whether in tents, or in strongholds; ");
INSERT INTO engojb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","And what the land is, whether it be fertile or barren, whether there be wood therein, or not. And be ye of good courage, and bring of the fruit of the land. Now the time was the time of the first ripe grapes. ");
INSERT INTO engojb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went up, and searched the land from the midbar of Tzin unto Rechov, as men come to Chamat. ");
INSERT INTO engojb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","And they ascended by the south, and came unto Chevron; where Achiman, Sheshai, and Talmai, the Anak, were. (Now Chevron was built seven shanim before Tzoan in Mitzrayim.) ");
INSERT INTO engojb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","And they came unto the Wadi Eshcol, and cut down from thence a branch with cluster of anavim echad, and they bore it between two upon a staff; and they brought of the pomegranates, and of the figs. ");
INSERT INTO engojb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","The place was called the Wadi Eshcol, because of the cluster of grapes which the Bnei Yisroel cut down from thence. ");
INSERT INTO engojb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","And they returned from searching of the land after arba'im days. ");
INSERT INTO engojb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","And they went and came to Moshe, and to Aharon, and to all the congregation of the Bnei Yisroel, unto the Midbar Paran, to Kadesh; and brought back word unto them, and unto Kol HaEdah, and showed them the pri ha'aretz. ");
INSERT INTO engojb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","And they told him, and said, We came unto ha'aretz where thou didst send us, and truly it floweth with cholov and devash; and this is the fruit of it. ");
INSERT INTO engojb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nevertheless the people are strong that dwell in the land, and the cities are walled, and gedolot me'od; and moreover we saw the Anak there. ");
INSERT INTO engojb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalek dwell in the eretz of the Negev; and the Chitti, and the Yevusi, and the Emori, dwell in the hills; and the Kena'ani dwell by the yam, and by the bank of the Yarden. ");
INSERT INTO engojb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","And Kalev silenced HaAm before Moshe, and said, Let us go up at once, and take possession of it; for we are well able to overcome it. ");
INSERT INTO engojb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the anashim that went up with him said, We are not able to go up against the people; for they are chazak (stronger) than we. ");
INSERT INTO engojb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","And they spread an evil report of HaAretz which they had explored unto the Bnei Yisroel, saying, HaAretz, through which we have gone to explore it, is a land that eateth up the inhabitants thereof; and all the people that we saw in it are men of a great stature. ");
INSERT INTO engojb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","And there we saw the Nephilim, the Bnei Anak, which come of the Nephilim; and we were in our own sight as grasshoppers, and so we were in their sight. ");
INSERT INTO engojb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","And Kol HaEdah lifted up their voice, and cried; and HaAm wept that night. ");
INSERT INTO engojb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","And Kol Bnei Yisroel murmured against Moshe and against Aharon: and the Kol HaEdah said unto them, If only we had died in Eretz Mitzrayim! Or if only we had died in this midbar! ");
INSERT INTO engojb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","And why hath Hashem brought us unto this land, to fall by the cherev, that nasheinu (our wives) and our children should be as plunder? Were it not better for us to go back unto Mitzrayim? ");
INSERT INTO engojb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","And they said one to another, Let us make a Rosh (Leader), and let us go back unto Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moshe and Aharon fell on their faces before Kol Kehal Adat Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","And Yehoshua ben Nun, and Kalev ben Yephunneh, which were of them that explored HaAretz, tore their clothes: ");
INSERT INTO engojb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","And they spoke unto Kol Adat Bnei Yisroel, saying, HaAretz, which we passed through to explore it, is a tovah haaretz me'od me'od. ");
INSERT INTO engojb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If Hashem delight in us, then He will bring us into this land, and give it us; a land zavat cholov udevash. ");
INSERT INTO engojb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only rebel not ye against Hashem, neither fear ye the Am HaAretz; for they are lachmeinu (our bread): their protection is departed from them, and Hashem is with us: fear them not. ");
INSERT INTO engojb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","But Kol HaEdah talked of stoning them with avanim. And the Kavod Hashem appeared in the Ohel Mo'ed before Kol Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","And Hashem said unto Moshe, How long will this people treat Me with contempt? And how long will it be until they believe in Me, for all the otot which I have performed among them? ");
INSERT INTO engojb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will strike them down with dever (pestilence), and disinherit them, and will make of thee a greater nation and mightier than they. ");
INSERT INTO engojb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","And Moshe said unto Hashem, Then the Egyptians shall hear it, (for Thou broughtest up this people in Thy ko'ach might from among them;) ");
INSERT INTO engojb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","And they will tell it to the inhabitants of this land; for they have heard that Thou Hashem art among this people, that Thou Hashem art seen eye to eye, and that Thy Anan standeth over them, and that Thou goest before them, by day in an Ammud Anan, and in an Ammud Eish by night. ");
INSERT INTO engojb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Now if Thou shalt kill all this people as one man, then the Goyim which have heard the fame of Thee will speak, saying, ");
INSERT INTO engojb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Because Hashem was not able to bring this people into HaAretz which He promised them by oath, therefore He hath slaughtered (shachat) them in the midbar. ");
INSERT INTO engojb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","And now, I beseech thee, let the Ko'ach Adonoi be great, according as Thou hast spoken, saying, ");
INSERT INTO engojb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Hashem is slow of anger, and of rav chesed, forgiving avon and peysha, and by no means exonerating the guilty, visiting the avon of the avot upon the banim unto the third and fourth generation. ");
INSERT INTO engojb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Selach (forgive!), I beseech thee, the avon of this people according unto the greatness of Thy chesed, just as Thou hast forgiven this people, from Mitzrayim even until now. ");
INSERT INTO engojb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","And Hashem said, I have pardoned according to thy word: ");
INSERT INTO engojb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","But as surely as I live, Kol HaAretz (all the Earth) shall be filled with the Kavod Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Because all those men which have seen My kavod, and My otot (miraculous signs), which I performed in Mitzrayim and in the midbar, and have tested Me now these ten times, and have not paid heed to My voice; ");
INSERT INTO engojb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Surely they shall not see HaAretz which I swore unto their avot, neither shall any of them that treated Me with contempt see it: ");
INSERT INTO engojb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But Avdi Kalev, because he hath a ruach acheret in him, and hath followed after Me fully, him will I bring into HaAretz whereinto he went; and his zera shall inherit it. ");
INSERT INTO engojb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Now the Amaleki and the Kena'ani dwelt in the valley.) Tomorrow turn and get you into the midbar by the way of the Yam Suf. ");
INSERT INTO engojb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","How long shall I bear with this Edah Hara'ah, which murmur against Me? I have heard the murmurings of the Bnei Yisroel, which they murmur against Me. ");
INSERT INTO engojb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Say unto them, As truly as I live, saith Hashem, as ye have spoken in Mine ears, so will I do to you: ");
INSERT INTO engojb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your corpses shall fall in this midbar; and all that were numbered of you, according to your entire mispar (number, census), from twenty years old and upward which have murmured against Me. ");
INSERT INTO engojb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Not one of you shall come into HaAretz, concerning which I swore to make you dwell therein, except for Kalev ben Yephunneh, and Yehoshua ben Nun. ");
INSERT INTO engojb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But your little ones, which ye said would be plunder, them will I bring in, and they shall know HaAretz which ye have rejected. ");
INSERT INTO engojb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But as for you, your corpses, they shall fall in this midbar. ");
INSERT INTO engojb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","And your banim shall wander in the midbar arba'im shanah, and bear your whoredoms, until the last of your corpses lies in the midbar. ");
INSERT INTO engojb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","After the number of the days in which ye explored HaAretz, even arba'im, each day for a year, shall ye bear your iniquities, even arba'im shanah, and ye shall know My Tenu'a (Opposition). ");
INSERT INTO engojb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, Hashem, have spoken, I will surely do it unto this Kol HaEdah, that are gathered together against Me: in this midbar they shall come to an end, and there they shall die. ");
INSERT INTO engojb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","And the anashim, which Moshe sent to spy out the land, who returned, and made Kol HaEdah to murmur against him, the ones spreading a dibbah (bad report, slander) about HaAretz, ");
INSERT INTO engojb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Even those anashim that did bring up the evil report of HaAretz, died by the maggefah before Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Yehoshua ben Nun, and Kalev ben Yephunneh survived of the anashim that went to explore HaAretz. ");
INSERT INTO engojb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","And Moshe told these sayings unto Kol Bnei Yisroel: and HaAm mourned greatly. ");
INSERT INTO engojb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","And they rose up early in the boker, and went up into the height of the hill country, saying, Behold, we are here, and will go up unto the place which Hashem hath promised: for we have sinned. ");
INSERT INTO engojb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","And Moshe said, Why now do ye transgress the utterance of Hashem? This will not succeed. ");
INSERT INTO engojb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Go not up, for Hashem is not among you; that ye be not struck down before your enemies. ");
INSERT INTO engojb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For the Amaleki and the Kena'ani are there before you, and ye shall fall by the cherev: because ye are turned away from Hashem, therefore Hashem will not be with you. ");
INSERT INTO engojb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they presumed to go up unto the ridge of the mountain: nevertheless the Aron Brit Hashem, and Moshe, departed not out of the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the Amaleki came down, and the Kena'ani which dwelt in that hill country, and struck them down, and put them to rout, even unto Chormah. ");
INSERT INTO engojb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Speak unto the Bnei Yisroel, and say unto them, When ye be enter into Eretz Moshevoteichem (Land of your Homes), which I give unto you, ");
INSERT INTO engojb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","And will make an offering by eish unto Hashem, an olah or a zevach in performing a neder, or in a nedavah or in your mo'adim, to make a re'ach nichoach unto Hashem, of the herd or of the flock; ");
INSERT INTO engojb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Then shall he that offereth his korban unto Hashem bring a minchah of a tenth ephah of flour mixed with the fourth part of a hin of shemen. ");
INSERT INTO engojb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","And the fourth part of a hin of yayin for a nesekh shalt thou prepare with the olah (burnt offering) or zevach, for one keves (lamb). ");
INSERT INTO engojb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Or for a ram, thou shalt prepare for a minchah two-tenths ephah of flour mixed with the third part of a hin of shemen. ");
INSERT INTO engojb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","And for a nesekh thou shalt offer the third part of an hin of yayin, for a re'ach nichoach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","And when thou preparest a bull for an olah (burnt offering), or for a zevach in fulfilling a vow, or shelamim unto Hashem: ");
INSERT INTO engojb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Then shall he bring with a bull a minchah of three-tenths ephah of flour mixed with half a hin of shemen. ");
INSERT INTO engojb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","And thou shalt bring for a nesekh half a hin of yayin, for an offering made by eish, a re'ach nichoach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Thus shall it be done for one bull, or for one ram, or for a seh from the lambs, or from the goats. ");
INSERT INTO engojb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","According to the number that ye shall prepare, so shall ye do to every one according to their mispar. ");
INSERT INTO engojb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","All that are native-born shall do these things after this manner, in offering an offering made by eish, of a re'ach nichoach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","And if a ger stays temporarily with you, or whosoever be among you in your dorot, and will offer an offering made by eish, of a re'ach nichoach unto Hashem; as ye do, so he shall do. ");
INSERT INTO engojb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","One chukkah shall be both for you of the Kahal, and also for the ger that sojourneth with you, a chukkat olam in your dorot; as ye are, so shall the ger be before Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","One torah and one mishpat shall be for you, and for the ger that sojourneth with you. ");
INSERT INTO engojb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Speak unto the Bnei Yisroel, and say unto them, When ye come into HaAretz whither I bring you, ");
INSERT INTO engojb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Then it shall be, that, when ye eat of the lechem HaAretz, ye shall offer up a terumah unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ye shall offer up a challah (loaf, cake) of the first of your kneading for a terumah; as ye do the terumat goren (gift of the threshing floor), so shall ye set it aside. ");
INSERT INTO engojb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Of the first of your kneading ye shall give unto Hashem a terumah in your dorot. ");
INSERT INTO engojb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","And if ye have sinned unintentionally, and not observed all these mitzvot, which Hashem hath spoken unto Moshe, ");
INSERT INTO engojb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Even all that Hashem hath commanded you by the hand of Moshe, from the day that Hashem commanded Moshe, and henceforward among your dorot; ");
INSERT INTO engojb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Then it shall be, if it be committed by ignorance without the knowledge of HaEdah, that Kol HaEdah shall offer one young bull for an olah, for a re'ach nichoach unto Hashem, with its minchah, and its nesekh, according to the mishpat, and one kid of the goats for a chattat. ");
INSERT INTO engojb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","And the kohen shall make kapporah for Kol Adat Bnei Yisroel and it shall be forgiven them; for it is shegagah (inadvertence); and they shall bring their korban, a sacrifice made by eish unto Hashem, and their chattat before Hashem, for their shegagah; ");
INSERT INTO engojb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","And it shall be forgiven Kol Adat Bnei Yisroel, and the ger that sojourneth among them; seeing Kol HaAm were in shegagah. ");
INSERT INTO engojb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","And if any nefesh sin through shegagah, then he shall bring a she-goat of the first year for a chattat. ");
INSERT INTO engojb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","And the kohen shall make kapporah for the nefesh that was inadvertant, since he sinneth by shegagah before Hashem, to make kapporah for him; and it shall be forgiven him. ");
INSERT INTO engojb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ye shall have one torah for him that sinneth through ignorance, both for him that is born among the Bnei Yisroel, and for the ger that sojourneth among them. ");
INSERT INTO engojb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the nefesh that sinneth with a yad ramah (high hand, defiantly), whether he be born in the land, or a ger, the same blasphemes Hashem; and that nefesh shall be cut off from among his people. ");
INSERT INTO engojb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he hath despised the Devar Hashem, and hath broken His mitzvah, that nefesh shall utterly be cut off; his avon shall be upon him. ");
INSERT INTO engojb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","And while the Bnei Yisroel were in the midbar, they found a man that gathered sticks on Shabbos. ");
INSERT INTO engojb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","And they that found him gathering sticks brought him unto Moshe and Aharon, and unto Kol HaEdah. ");
INSERT INTO engojb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","And they put him under custody, because it was not declared what should be done to him. ");
INSERT INTO engojb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","And Hashem said unto Moshe, The man shall be surely put to death; Kol HaEdah shall stone him with avanim outside the machaneh. ");
INSERT INTO engojb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","And Kol HaEdah brought him outside the machaneh, and stoned him with avanim, and he died; as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Speak unto the Bnei Yisroel, and bid them that they make them tzitzis on the corners of their garments throughout their dorot, and that they put upon the tzitzis of the corners a thread of turquoise wool; ");
INSERT INTO engojb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","And it shall be unto you for a tzitzit, that ye may look upon it, and remember all the mitzvot Hashem, and do them; and that ye follow not after your own lev and your own eyes, after which ye used to go a-whoring: ");
INSERT INTO engojb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","That ye may remember, and do all My mitzvot, and be kedoshim unto Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am Hashem Eloheichem, Who brought you out of Eretz Mitzrayim, to be for you Elohim: I am Hashem Eloheichem. ");
INSERT INTO engojb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korach ben Yitzhar ben Kehat ben Levi, and Datan and Aviram, the Bnei Eliav, and On ben Pelet, Bnei Reuven, became insolent; ");
INSERT INTO engojb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","And they rose up before Moshe, with certain of the Bnei Yisroel, two hundred and fifty Nasi'ei Edah, chosen from the assembly, men of renown; ");
INSERT INTO engojb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","And they gathered themselves together against Moshe and against Aharon, and said unto them, Ye take too much upon you, seeing Kol HaEdah are Kedoshim, every one of them, and Hashem is among them; why then lift ye up yourselves above the Kehal Hashem? ");
INSERT INTO engojb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","And when Moshe heard it, he fell upon his face; ");
INSERT INTO engojb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","And he spoke unto Korach and unto all his edah, saying, In the boker Hashem will show who are His, and who is the kadosh; and will cause him to come near unto Him: even him whom He hath chosen will He cause to come near unto Him. ");
INSERT INTO engojb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","This do: take you fire pans, Korach, and all his edah; ");
INSERT INTO engojb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","And put eish therein, put ketoret in them before Hashem tomorrow; it shall be that the man whom Hashem doth choose, he shall be haKadosh; ye take too much upon you, ye Bnei Levi. ");
INSERT INTO engojb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","And Moshe said unto Korach, Hear, now, ye Bnei Levi: ");
INSERT INTO engojb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Seemeth it but a small thing unto you, that Elohei Yisroel hath separated you from the Adat Yisroel, to bring you near to Himself to do the Avodat Mishkan Hashem, and to stand before the Edah to minister unto them? ");
INSERT INTO engojb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","And He hath brought thee near to Him, and all thy brethren the Bnei Levi with thee; and seek ye the Kehunah also? ");
INSERT INTO engojb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","For which cause both thou and all thy edah are gathered together against Hashem; and what is Aharon, that ye murmur against him? ");
INSERT INTO engojb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","And Moshe sent to call Datan and Aviram, the Bnei Eliav, which said, We will not come up. ");
INSERT INTO engojb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it a small thing that thou hast brought us up out of an Eretz zavat cholov udevash, to kill us in the midbar, yet thou also keep trying to dominate us? ");
INSERT INTO engojb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Moreover thou hast not brought us into an Eretz zavat cholov udevash, or given us nachalah of sadeh and kerem; wilt thou gouge out the eyes of these men? We will not come up. ");
INSERT INTO engojb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","And Moshe was very angry, and said unto Hashem, Respect not thou their minchah; I have not taken one donkey from them, neither have I wronged one of them. ");
INSERT INTO engojb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","And Moshe said unto Korach, Be thou and all thy edah before Hashem, thou, they, and Aharon, tomorrow; ");
INSERT INTO engojb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","And take every man his fire pan, put ketoret in them, and bring ye before Hashem every man his fire pan, 250 fire pans; thou also, and Aharon, each of you his fire pan. ");
INSERT INTO engojb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","And they took every man his fire pan and put eish in them and laid ketoret thereon, and stood in the entrance of the Ohel Mo'ed with Moshe and Aharon. ");
INSERT INTO engojb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","And Korach gathered kol haedah against them unto the entrance of the Ohel Mo'ed; and the Kavod Hashem appeared unto Kol HaEdah. ");
INSERT INTO engojb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Separate yourselves from among this edah, that I may consume them in a moment. ");
INSERT INTO engojb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","And they fell upon their faces, and said, El Elohei HaRuchot L'Chol Basar, shall one man sin, and wilt Thou be angry with Kol HaEdah? ");
INSERT INTO engojb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Speak unto HaEdah, saying, Get you up away from the mishkan (dwelling place) of Korach, Datan, and Aviram. ");
INSERT INTO engojb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","And Moshe rose up and went unto Datan and Aviram; and the Ziknei Yisroel followed him. ");
INSERT INTO engojb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","And he spoke unto HaEdah, saying, Move back, now, from the tents of these anashim resha'im, and touch nothing of theirs, lest ye be consumed in all their chattot. ");
INSERT INTO engojb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So they moved back from the mishkan Korach, Datan, and Aviram, on every side; Datan and Aviram came out, and stood in the entrance of their tents, their wives, their banim, and their little ones. ");
INSERT INTO engojb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","And Moshe said, Hereby ye shall know that Hashem hath sent me to do all these ma'asim; for I have not done them of mine own will. ");
INSERT INTO engojb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die the common death of kol haAdam, or if they be visited after the visitation of kol haAdam, then Hashem hath not sent me. ");
INSERT INTO engojb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if Hashem creates a new thing, and haadamah open her mouth, and swallow them up, with all that appertain unto them, and they go down chayyim into Sheol; then ye shall have da'as that these men have spurned Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","And it came to pass, as he had made an end of speaking all these devarim, that haadamah split asunder that was under them: ");
INSERT INTO engojb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","And ha'aretz opened her mouth, and swallowed them up, their batim (houses), all the men that were of Korach, and all their possessions. ");
INSERT INTO engojb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They, and all that were of them, went down chayyim into Sheol, and ha'aretz closed over them; and they perished from the midst of the Kahal. ");
INSERT INTO engojb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","And Kol Yisroel that were round about them fled at the cry of them, for they said, Lest ha'aretz swallow us up also. ");
INSERT INTO engojb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","And there came out from Hashem an eish, and consumed the 250 men that offered ketoret. ");
INSERT INTO engojb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","And Hashem spoke unto Moshe saying, ");
INSERT INTO engojb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Speak unto El'azar ben Aharon HaKohen that he take up the fire pans out of the burning, and scatter thou the eish yonder; for they are set apart as kodesh. ");
INSERT INTO engojb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","The fire pans of these chatta'im against their own nefashot, let them make them hammered-out sheets for a covering of the Mizbe'ach: for they offered them before Hashem, therefore they became kadosh; and they shall be an ot unto the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","And El'azar HaKohen took the bronze fire pans, wherewith they that were burned had offered; and they made hammered-out sheets for an overlay of the Mizbe'ach: ");
INSERT INTO engojb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","To be a memorial reminder unto the Bnei Yisroel, that no zar, which is not of the zera Aharon, encroach to offer ketoret before Hashem; that he be not as Korach, and as his edah, as Hashem said to him by the hand of Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","But the next day Kol Adat Bnei Yisroel murmured against Moshe and against Aharon, saying, Ye have killed the Am Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","And it came to pass, when HaEdah was gathered against Moshe and against Aharon, that they looked toward the Ohel Mo'ed; and, hinei, the Anan covered it, and the Kavod Hashem appeared. ");
INSERT INTO engojb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","And Moshe and Aharon came before the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","And Hashem spoke unto Moshe saying, ");
INSERT INTO engojb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Get you away from among this edah, that I may consume them as in a moment. And they fell upon their faces. ");
INSERT INTO engojb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","And Moshe said unto Aharon, Take a fire pan, and put eish therein from off the Mizbe'ach, and put ketoret, and go quickly unto HaEdah, and make kapporah for them; for there is Ketzef (Wrath) gone out from Hashem; the plague is begun. ");
INSERT INTO engojb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","And Aharon took as Moshe commanded, and ran into the midst of the Kahal; and, hinei, the plague was begun among HaAm: and he offered ketoret, and made kapporah for HaAm. ");
INSERT INTO engojb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","And he stood between the mesim and the chayyim; and the plague was stopped. ");
INSERT INTO engojb_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Now they that were the mesim in the maggefah (plague) were fourteen thousand and seven hundred, in addition to those who were mesim by reason of Korach. ");
INSERT INTO engojb_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","And Aharon returned unto Moshe unto the entrance of the Ohel Mo'ed; and the plague was stayed. ");
INSERT INTO engojb_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Speak unto the Bnei Yisroel, and take of every one of them a rod according to the Bais Av, of all their Nasiim according to the Bais of their Avot twelve rods; write thou every manʼs shem upon his matteh (rod, staff). ");
INSERT INTO engojb_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","And thou shalt write shem Aharon upon the rod of Levi; for one rod shall be for the Rosh of the Bais of their Avot. ");
INSERT INTO engojb_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","And thou shalt lay them up in the Ohel Mo'ed before HaEdut, where I will meet with you there. ");
INSERT INTO engojb_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","And it shall come to pass, that the manʼs rod, whom I shall choose, shall sprout; and I will rid Myself of the murmurings of the Bnei Yisroel, whereby they murmur against you. ");
INSERT INTO engojb_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","And Moshe spoke unto the Bnei Yisroel, and every one of their Nasiim gave him a rod apiece, for each nasi one, according to their Bais Avot, even twelve rods; and the rod of Aharon was among their rods. ");
INSERT INTO engojb_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","And Moshe laid up the rods before Hashem in the Ohel HaEdut. ");
INSERT INTO engojb_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","And it came to pass, that the next day Moshe entered into the Ohel HaEdut; and, hinei, the rod of Aharon for the Bais Levi was budded, and brought forth buds, and bloomed blossoms, and yielded almonds. ");
INSERT INTO engojb_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","And Moshe brought out all the rods from before Hashem unto Kol Bnei Yisroel; and they looked, and took every man his rod. ");
INSERT INTO engojb_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","And Hashem said unto Moshe, Bring Aharonʼs rod again before HaEdut, to be kept for an ot (sign) against the rebels; and thou shalt quite put an end to their murmurings against Me, that they die not. ");
INSERT INTO engojb_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","And Moshe did so; as Hashem commanded him, so did he. ");
INSERT INTO engojb_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","And the Bnei Yisroel spoke unto Moshe, saying, See, we die, we perish, we will all perish. ");
INSERT INTO engojb_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Whoever even encroaches upon the Mishkan Hashem shall die. Shall we be consumed with dying? ");
INSERT INTO engojb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","And Hashem said unto Aharon, Thou and thy Banim and thy Bais Av with thee shall bear the avon (guilt) of the Mikdash; and thou and thy Banim with thee shall bear the avon of the kehunah of you. ");
INSERT INTO engojb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","And thy brethren also of the tribe of Levi, the Shevet Avicha, bring thou with thee, that they may be joined unto thee, and minister unto thee; while thou and thy Banim with thee are before the Ohel HaEdut. ");
INSERT INTO engojb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","And they shall stand your guard duty, and the duty of Kol HaOhel; only they shall not come near the Klei HaKodesh and the Mizbe'ach, that neither they, nor ye also, die. ");
INSERT INTO engojb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","And they shall be joined unto thee, and stand guard duty of the Ohel Mo'ed, for kol Avodat HaOhel; and a zar shall not encroach unto you. ");
INSERT INTO engojb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","And ye shall stand guard of HaKodesh, and stand guard of the Mizbe'ach; that there be no Ketzef (Wrath) any more upon the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","And I, hinei, I Myself have taken your brethren the Levi'im from among the Bnei Yisroel; to you they are given as a mattanah (gift) to Hashem, to do the Avodat Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Therefore thou and thy Banim with thee shall be shomer over your Kehunah with everything of the Mizbe'ach, and within the Parochet; and ye shall do the Avodas service: I have given your Kehunah unto you as an Avodas Mattanah; and the zar (unauthorized one) that shall encroach shall be put to death. ");
INSERT INTO engojb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","And Hashem spoke unto Aharon, Hinei, I also have given thee the charge of Mine terumot of kol Kodoshei Bnei Yisroel; unto thee have I given them by reason of the moshchah (kohenʼs allotted portion), and to thy Banim, as a chok olam. ");
INSERT INTO engojb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","This shall be thine of the kodesh hakodashim, reserved from the eish; every korban of theirs, every minchah of theirs, and every chattat of theirs, and every asham of theirs which they shall render unto Me, shall be kodesh kodashim for thee and for thy Banim. ");
INSERT INTO engojb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","As the kodesh hakodashim shalt thou eat it; every zachar shall eat it; it shall be kodesh unto thee. ");
INSERT INTO engojb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","And this is thine; the terumah of their gift, with all the tenufot Bnei Yisroel; I have given them unto thee, and to thy banim and to thy banot with thee, by a chok olam; every one that is tahor in thy Bais shall eat of it. ");
INSERT INTO engojb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","All the best of the oil, and all the best of the wine, and of the grain, the reshit (firstfruit) of them which they shall offer unto Hashem, them have I given thee. ");
INSERT INTO engojb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","And whatsoever is Bikkurim in the land, which they shall bring unto Hashem, shall be thine; every one that is tahor in thine Bais shall eat of it. ");
INSERT INTO engojb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Every cherem in Yisroel shall be thine. ");
INSERT INTO engojb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Every thing that openeth the womb in all basar, which they bring unto Hashem, whether it be of adam or behemah, shall be thine; nevertheless the bechor haadam shalt thou surely redeem, and the bechor habehemah hateme'ah shalt thou redeem. ");
INSERT INTO engojb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","And those that are to be redeemed from a month old shalt thou redeem, according to thine evaluation, for the five silver shekelim, according to the shekel HaKodesh, which is twenty gerah. ");
INSERT INTO engojb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But the bechor of a cow, or the bechor of a sheep, or the bechor of a goat, thou shalt not redeem; they are kodesh; thou shalt sprinkle their dahm upon the Mizbe'ach, and shalt burn their fat for an offering made by eish, for a re'ach nichoach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","And the basar of them shall be thine, like the breast of the tenufah and like the right thigh are thine. ");
INSERT INTO engojb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the terumot hakodashim, which the Bnei Yisroel offer unto Hashem, have I given thee, and thy banim and thy banot with thee, by a chok olam; it is a brit melach olam before Hashem unto thee and to thy zera with thee. ");
INSERT INTO engojb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","And Hashem spoke unto Aharon, Thou shalt have no nachalah in their land, neither shalt thou have any chelek among them; I am thy chelek and thine nachalah among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","And, hinei, I have given the Bnei Levi all the ma'aser (tithe) in Yisroel for a nachalah, for their Avodah which they serve, even the Avodat Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Neither must the Bnei Yisroel henceforth come near the Ohel Mo'ed, lest they bear chet, and die. ");
INSERT INTO engojb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","But the Levi'im shall perform the Avodat Ohel Mo'ed, lest they shall nasa (bear) their avon; it shall be a chukkat olam throughout your dorot, that among the Bnei Yisroel they have no nachalah. ");
INSERT INTO engojb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","But the ma'aser of the Bnei Yisroel, which they offer as a terumah unto Hashem, I have given to the Levi'im as a nachalah; therefore, I have said unto them, Among the Bnei Yisroel they shall have no nachalah. ");
INSERT INTO engojb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Thus speak unto the Levi'im, and say unto them, When ye take of the Bnei Yisroel the ma'aser which I have given you from them for your nachalah, then ye shall raise up a terumah of it for Hashem, even a ma'aser of the ma'aser. ");
INSERT INTO engojb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","And this your terumah shall be reckoned unto you, as though it were the grain of the threshing floor, and as the fulness of the winepress. ");
INSERT INTO engojb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Thus ye also shall offer a terumat Hashem of all your ma'aserot, which ye receive of the Bnei Yisroel; and ye shall give thereof terumat Hashem to Aharon HaKohen. ");
INSERT INTO engojb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Out of all your mattenot ye shall offer every terumat Hashem, of all the best thereof, even the set apart as kodesh part thereof out of it. ");
INSERT INTO engojb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Therefore, thou shalt say unto them, When ye have raised up the best thereof from it, then it shall be counted unto the Levi'im as the increase of the threshing floor, and as the increase of the winepress. ");
INSERT INTO engojb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","And ye shall eat it in every place, ye and your Bais: for it is your sachar for your Avodah in the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","And ye shall bear no chet by reason of it, when ye have raised up from it the best of it; neither shall ye desecrate the Kodshei Bnei Yisroel, lest ye die. ");
INSERT INTO engojb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","And Hashem spoke unto Moshe and unto Aharon, saying, ");
INSERT INTO engojb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","This is the chukkat hatorah which Hashem hath commanded, saying, Speak unto the Bnei Yisroel, that they bring thee a completely red female cow, wherein is no blemish, and upon which never came ol (yoke): ");
INSERT INTO engojb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","And ye shall give her unto El'azar HaKohen, that he may bring her forth outside the machaneh, and one shall slaughter (shachat) her before his face; ");
INSERT INTO engojb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","And El'azar HaKohen shall take of her dahm with his finger, and sprinkle of her dahm directly before the Ohel Mo'ed seven times; ");
INSERT INTO engojb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","And one shall burn the heifer in his sight; her hide, and her basar, and her dahm, with her dung, shall he burn; ");
INSERT INTO engojb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","And the kohen shall take cedar wood, and hyssop, and crimson thread, and cast it into the midst of the burning heifer. ");
INSERT INTO engojb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the kohen shall wash his clothes, and he shall immerse his basar in mayim, and afterward he shall come into the machaneh, and the kohen shall be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","And he that burneth her shall wash his clothes in mayim, and immerse his basar in mayim, and shall be tamei until the erev. ");
INSERT INTO engojb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","And a man that is tahor shall gather up the ashes of the cow, and lay them up outside the machaneh in a makom tahor, and it shall be in safekeeping for HaEdah Bnei Yisroel for water of sprinkling; it is for sin-purification. ");
INSERT INTO engojb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","And he that gathereth the ashes of the heifer shall wash his clothes, and be tamei until the erev; and it shall be unto the Bnei Yisroel, and unto the ger that sojourneth among them, for a chukkat olam. ");
INSERT INTO engojb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","He that toucheth the dead body of any man shall be tamei shivat yamim. ");
INSERT INTO engojb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He shall make himself tahor with it on the Yom HaShelishi, and on the seventh day he shall be tahor; but if he does not make himself tahor on the Yom HaShelishi, then the seventh day he shall not be tahor. ");
INSERT INTO engojb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Whosoever toucheth the body of any man that is dead, and maketh not himself tahor, makes tamei the Mishkan Hashem; and that nefesh shall be cut off from Yisroel; because the water of sprinkling was not sprinkled upon him, he shall be tamei; his tumah is yet upon him. ");
INSERT INTO engojb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","This is the torah, when a man dieth in an ohel, all that come into the ohel, and all that is in the ohel, shall be tamei seven days. ");
INSERT INTO engojb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","And every open vessel, which hath no covering bound upon it, is tamei. ");
INSERT INTO engojb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","And whosoever toucheth one that is slain with a cherev in the open fields, or a dead body, or a bone of a man, or a kever, shall be tamei seven days. ");
INSERT INTO engojb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","And for one who is tamei they shall take of the ashes of the burning of the purification, and running mayim shall be put thereto in a vessel; ");
INSERT INTO engojb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","And an ish tahor shall take hyssop, and dip it in the mayim, and sprinkle it upon the ohel, and upon all the vessels, and upon the nefashot that were there, and upon him that touched a bone, or one slain, or one dead, or a kever; ");
INSERT INTO engojb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","And the tahor (clean person) shall sprinkle upon the tamei on the Yom HaShelishi, and on the seventh day; and on the seventh day he shall make himself tahor, and wash his clothes, and immerse himself in mayim, and shall be tahor at erev. ");
INSERT INTO engojb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But the man that shall be tamei, and shall not purify himself, that nefesh shall be cut off from among the Kahal, because he hath contaminated the Mikdash Hashem; the water of sprinkling hath not been sprinkled upon him; he is tamei. ");
INSERT INTO engojb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","And it shall be a chukkat olam unto them, that he that sprinkleth the water of sprinkling shall immerse his clothes; and he that toucheth the water of sprinkling shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","And whatsoever the tamei person toucheth shall be tamei; and the nefesh that toucheth it shall be tamei until erev. ");
INSERT INTO engojb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Then came the Bnei Yisroel, even the kol HaEdah into the Midbar of Tzin in the first month; and the people abode in Kadesh; and Miryam died there, and was buried there. ");
INSERT INTO engojb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","And there was no mayim for the Edah; and they gathered themselves together against Moshe and against Aharon. ");
INSERT INTO engojb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","And the people contended with Moshe, and spoke, saying, If only we had died when our brethren died before Hashem! ");
INSERT INTO engojb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","And why have ye brought up the Kahal Hashem into this midbar, that we and our livestock should die here? ");
INSERT INTO engojb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","And why have ye made us to come up out of Mitzrayim, to bring us in unto this evil place? It is no place of zera (grain), or of te'enah (fig), or of gefen (grapevine), or of pomegranates; neither is there any mayim to drink. ");
INSERT INTO engojb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","And Moshe and Aharon went from the presence of the Kahal unto the entrance of the Ohel Mo'ed, and they fell upon their faces; and the kavod Hashem appeared unto them. ");
INSERT INTO engojb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Take the rod and gather thou the Edah together, thou and Aharon thy brother, and speak ye unto the rock before their eyes; and it shall give forth its mayim, and thou shalt bring forth to them mayim out of the rock; so thou shalt give the Edah and their beasts drink. ");
INSERT INTO engojb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","And Moshe took the rod from before Hashem, just as He commanded him. ");
INSERT INTO engojb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","And Moshe and Aharon gathered the Kahal together before the rock, and he said unto them, Hear now, ye morim (rebels, contentious ones); must we fetch you mayim out of this rock? ");
INSERT INTO engojb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","And Moshe lifted up his hand, and with his rod he struck the rock twice; and the mayim came out abundantly, and the Edah drank, and their beasts also. ");
INSERT INTO engojb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","And Hashem spoke unto Moshe and Aharon, Because ye believed Me not, to honor Me as kadosh in the eyes of the Bnei Yisroel, therefore ye shall not bring this Kahal into HaAretz which I have given them. ");
INSERT INTO engojb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These were the Waters of Merivah (Quarreling); because the Bnei Yisroel quarreled with Hashem, and He showed Himself kadosh among them. ");
INSERT INTO engojb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","And Moshe sent messengers from Kadesh unto the melech of Edom, Thus saith thy brother Yisroel, Thou knowest all the hardship that hath befallen us: ");
INSERT INTO engojb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","How Avoteinu went down into Mitzrayim, and we have dwelt in Mitzrayim a long time; and the Egyptians did evil to us, and Avoteinu; ");
INSERT INTO engojb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","And when we cried unto Hashem, He heard our voice, and sent a malach, and hath brought us forth out of Mitzrayim; and, hinei, we are in Kadesh, a town in the edge of thy border; ");
INSERT INTO engojb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Let us pass, please, through thy country; we will not pass through the fields, or through the kerem (vineyards), neither will we drink of the mayim of the wells; we will go by the Derech HaMelech; we will not turn to the right hand nor to the left until we have passed through thy territory. ");
INSERT INTO engojb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","And Edom said unto him, Thou shalt not pass through me, lest I come out against thee with the cherev. ");
INSERT INTO engojb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","And the Bnei Yisroel said unto him, We will go by the main road; and if I and my livestock drink of thy mayim, then I will pay for it; I will only, without doing anything else, pass through on my feet. ");
INSERT INTO engojb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","And he said, Thou shalt not go through. And Edom came out against him with a large army, and with a yad chazakah. ");
INSERT INTO engojb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Thus Edom refused to give Yisroel passage through his border; wherefore Yisroel turned away from him. ");
INSERT INTO engojb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","And the Bnei Yisroel, even Kol HaEdah, journeyed from Kadesh, and came unto Mt Hor. ");
INSERT INTO engojb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","And Hashem spoke unto Moshe and Aharon in Mt Hor, by the border of Eretz Edom, saying, ");
INSERT INTO engojb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aharon shall be gathered unto his people; for he shall not enter into HaAretz which I have given unto the Bnei Yisroel, because ye rebelled against My word at the Waters of Merivah. ");
INSERT INTO engojb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aharon and El'azar bno, and bring them up unto Mt Hor; ");
INSERT INTO engojb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","And strip Aharon of his garments, and put them upon El'azar bno; and Aharon shall be gathered unto his people, and shall die there. ");
INSERT INTO engojb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","And Moshe did as Hashem commanded; and they went up into Mt Hor in the sight of Kol HaEdah. ");
INSERT INTO engojb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","And Moshe stripped Aharon of his garments, and put them upon El'azar bno; and Aharon died there on the top of the mount; and Moshe and El'azar came down from the mount. ");
INSERT INTO engojb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","And when Kol HaEdah saw that Aharon was dead, they mourned for Aharon shloshim yom, even Kol Bais Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","And when melech of Arad the Kena'ani, which dwelt in the Negev, heard that Yisroel came by the Derech HaAtarim; then he fought against Yisroel, and took some of them prisoners. ");
INSERT INTO engojb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","And Yisroel vowed a neder unto Hashem, and said, If Thou wilt indeed deliver this people into my hand, then I will utterly destroy their cities. ");
INSERT INTO engojb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","And Hashem paid heed to the kol Yisroel, and delivered up the Kena'ani; and they utterly destroyed them and their cities; and the place was named Chormah (Utter Destruction). ");
INSERT INTO engojb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","And they journeyed from Mt Hor by the way of the Yam Suf, to go around Eretz Edom; and the nefesh haAm was much impatient because of the way. ");
INSERT INTO engojb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","And the people spoke against Elohim, and against Moshe, Why have ye brought us up out of Mitzrayim to die in the midbar? For there is no lechem, neither is there any mayim; and our nefesh loatheth this wretched lechem. ");
INSERT INTO engojb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","And Hashem sent fiery nechashim among the people, and they bit the people; and Am rav miYisroel died. ");
INSERT INTO engojb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Therefore HaAm came to Moshe, and said, We have sinned, for we have spoken against Hashem, and against thee; pray unto Hashem that He take away the Nachash from us. And Moshe davened for the people. ");
INSERT INTO engojb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","And Hashem said unto Moshe, Make thee a fiery serpent, set it upon a pole; and it shall come to pass, that every one that is bitten, when he looketh upon it, shall live. ");
INSERT INTO engojb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","And Moshe made a nachash of nechoshet, put it upon a pole, and it came to pass, that if a nachash had bitten any man, when he beheld the nachash hanechoshet, then he lived. ");
INSERT INTO engojb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","And the Bnei Yisroel set out, and encamped in Ovot. ");
INSERT INTO engojb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","And they journeyed from Ovot, and encamped at Iyei-HaAvarim, in the midbar which is before Moav, toward the mizrach hashemesh. ");
INSERT INTO engojb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From thence they removed, and encamped in the Wadi Zered. ");
INSERT INTO engojb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From thence they removed, and encamped on the other side of Arnon, which is in the midbar encroaching the Emori; for Arnon is the border of Moav, between Moav and the Emori. ");
INSERT INTO engojb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Wherefore it is said in the Sefer Milchamot Hashem, Vahev b'Sufah and in the Vadis Arnon, ");
INSERT INTO engojb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","And at the stream of the brooks that goeth down to the site of Ar, and lieth upon the border of Moav. ");
INSERT INTO engojb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","And from thence they went to Be'er; that is the Well whereof Hashem spoke unto Moshe, Gather the people together, and I will give them mayim. ");
INSERT INTO engojb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Yisroel sang this shirah (song), Spring up, O well; sing ye unto it. ");
INSERT INTO engojb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The sarim (princes) dug the well, the nobles of the people dug it, by the direction of the Mekhokek (Lawgiver), with their rods. And from the midbar they went to Mattanah; ");
INSERT INTO engojb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","And from Mattanah to Nachaliel; and from Nachaliel to Bamot; ");
INSERT INTO engojb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","And from Bamot in the valley, that is in the country of Moav, to the top of Pisgah, overlooking the surface of the wasteland. ");
INSERT INTO engojb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","And Yisroel sent messengers unto Sichon Melech HaEmori, saying, ");
INSERT INTO engojb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Let me pass through thy land; we will not turn into the fields, or into the kerem (vineyards); we will not drink of the waters of the well, but we will go along by the Derech HaMelech until we be past thy borders. ");
INSERT INTO engojb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","And Sichon would not suffer Yisroel to pass through his border; but Sichon gathered all his army together, and went out against Yisroel into the midbar; and he came to Yahatz and fought against Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","And Yisroel struck down him with the edge of the cherev, and possessed his land from Arnon unto Yabbok, even unto the Bnei Ammon; for the border of the Bnei Ammon was fortified. ");
INSERT INTO engojb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","And Yisroel took all these cities; Yisroel dwelt in all the cities of the Emori, in Cheshbon, and in all the villages thereof. ");
INSERT INTO engojb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","For Cheshbon was the city of Sichon Melech HaEmori, who had fought against the former king of Moav, and taken all his land out of his hand, even unto Arnon. ");
INSERT INTO engojb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Wherefore they that speak in proverbs say, Come into Cheshbon, let the city of Sichon be built and prepared; ");
INSERT INTO engojb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For there is a fire gone out of Cheshbon, a flame from the city of Sichon; it hath consumed Ar of Moav, and citizens of the heights of Arnon. ");
INSERT INTO engojb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to thee, Moav! Thou art undone, O people of Kemosh; he hath given his banim as fugitives, and his banot, captives unto Sichon Melech Emori. ");
INSERT INTO engojb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Down we have cast them; Cheshbon is perished even unto Divon, and we have laid them waste even unto Nophach, which reacheth unto Medeva. ");
INSERT INTO engojb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Thus Yisroel dwelt in Eretz HaEmori. ");
INSERT INTO engojb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","And Moshe sent to spy out Yazer, and they took the villages thereof, and drove out HaEmori that were there. ");
INSERT INTO engojb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","And they turned and went up by the way of Bashan; and Og Melech HaBashan went out against them, he, and all his army, to the battle at Edre'i. ");
INSERT INTO engojb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","And Hashem said unto Moshe, Fear him not: for I have delivered him into thy hand, all his army, his land; thou shalt do to him as thou didst unto Sichon Melech HaEmori, which dwelt at Cheshbon. ");
INSERT INTO engojb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they struck him down, and his banim, and all his army, until there was none alive left to him: and they possessed his land. ");
INSERT INTO engojb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","And the Bnei Yisroel set forward, and encamped in the plains of Moav on the bank of the Yarden by Yericho. ");
INSERT INTO engojb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","And Balak ben Tzippor saw all that Yisroel had done to the Emori. ");
INSERT INTO engojb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","And Moav was exceedingly afraid of the people, because they were many; and Moav was filled with dread because of the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","And Moav said unto the Ziknei Midyan, Now shall this kahal lick up all that are round about us, as the ox licketh up the grass of the sadeh. And Balak ben Tzippor was Melech of Moav at that time. ");
INSERT INTO engojb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","He sent malachim (messengers) therefore unto Balaam ben Be'or to Petor, which is by the River in his native land, to summon him, saying, Hinei, there is a people come out from Mitzrayim; hinei, they cover the face of ha'aretz, and they are settling next to me; ");
INSERT INTO engojb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Come now, therefore, please, curse for me this people; for they are too mighty for me; perhaps I shall prevail, that we may strike them, and that I may drive them out of ha'aretz; for I know that he whom thou blessest is m'vorach (blessed), and he whom thou cursest is cursed. ");
INSERT INTO engojb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","And the Ziknei Moav and the Ziknei Midyan departed with the divination remuneration in their hand; and they came unto Balaam, and spoke unto him the words of Balak. ");
INSERT INTO engojb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","And he said unto them, Lodge here this night, and I will bring you word again, as Hashem shall speak unto me; and the sarim of Moav abode with Balaam. ");
INSERT INTO engojb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","And Elohim came unto Balaam, and said, What men are these with thee? ");
INSERT INTO engojb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","And Balaam said unto HaElohim, Balak ben Tzippor, Melech Moav, hath sent unto me, saying, ");
INSERT INTO engojb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Hinei, there is a people come out of Mitzrayim, which covereth the face of ha'aretz; come now, curse for me them; perhaps I shall be able to overcome them, and drive them out. ");
INSERT INTO engojb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","And Elohim said unto Balaam, Thou shalt not go with them; thou shalt not curse the people; for baruch hu (it the people is blessed). ");
INSERT INTO engojb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","And Balaam rose up in the boker, and said unto the sarim of Balak, Go back to your land; for Hashem refuseth to give me permission to go with you. ");
INSERT INTO engojb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","And the sarim of Moav rose up, and they went unto Balak, and said, Balaam refuseth to come with us. ");
INSERT INTO engojb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","And Balak sent yet again sarim, more, and more distinguished than they. ");
INSERT INTO engojb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","And they came to Balaam, and said to him, Thus saith Balak ben Tzippor, Let nothing, please, hinder thee from coming unto me; ");
INSERT INTO engojb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","For I will exceedingly reward thee, and I will do whatsoever thou sayest unto me; come, therefore, please, curse for me this people. ");
INSERT INTO engojb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","And Balaam answered and said unto the avadei Balak, If Balak would give me his palace full of kesef and zahav, I cannot go beyond the Devar Hashem Elohai, to do ketanah or gedolah. ");
INSERT INTO engojb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Now, therefore, please, tarry ye also here this night, that I may have da'as of what more Hashem will say unto me. ");
INSERT INTO engojb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","And it was lailah when Elohim came unto Balaam, and said unto him, Since the men come to summon thee, rise up and go with them; but only the word which I shall say unto thee, that shalt thou do. ");
INSERT INTO engojb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","And Balaam rose up in the boker, and saddled his donkey, and went with the sarim (princes) of Moav. ");
INSERT INTO engojb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","But the Af Elohim (G-dʼs anger) was kindled as he was going; and the Malach Hashem stood in the derech (road) l'satan (for an adversary, opposer) against him. Now he was riding upon his donkey, and his two servants were with him. ");
INSERT INTO engojb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","And the donkey saw the Malach Hashem standing in the derech, and his cherev drawn in his hand; and the donkey turned off the derech, and went into the sadeh; and Balaam beat the donkey, to turn her back onto the derech. ");
INSERT INTO engojb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","But the Malach Hashem stood in the closed-in path among the kramim (vineyards), a wall being on this side, a wall on that side. ");
INSERT INTO engojb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","And when the donkey saw the Malach Hashem, she thrust herself unto the wall, and crushed Balaamʼs regel against the wall; and he beat her again. ");
INSERT INTO engojb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","And the Malach Hashem went further, and stood in a narrow place, where was no derech to turn either to the right or to the left. ");
INSERT INTO engojb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","And when the donkey saw the Malach Hashem, she lay down under Balaam; and af Balaam was kindled, and he beat the donkey with his staff. ");
INSERT INTO engojb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","And Hashem opened the mouth of the donkey, and she said unto Balaam, What have I done unto thee, that thou hast beaten me these shalosh regalim (three times)? ");
INSERT INTO engojb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","And Balaam answered the donkey, Because thou hast mocked me; If only there were a cherev in mine hand, would I have killed thee. ");
INSERT INTO engojb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","And the donkey said unto Balaam, Am not I thine donkey, upon which thou hast ridden ever since I was thine unto this day? Was I ever accustomed to do so unto thee? And he said, Loh. ");
INSERT INTO engojb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then Hashem opened the eyes of Balaam, and he saw the Malach Hashem standing in the derech, and his cherev drawn in his hand; and he bowed down his head, and fell facedown. ");
INSERT INTO engojb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","And the Malach Hashem said unto him, Why hast thou beaten thine donkey these shalosh regalim? Hinei, I came l'satan (as adversary, opposer) to thee, because thy derech is perverse before me; ");
INSERT INTO engojb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","And the donkey saw me, and turned from me these shalosh regalim; had she not turned from me, surely now also I would have slain thee, and saved her alive. ");
INSERT INTO engojb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","And Balaam said unto the Malach Hashem, Chatati (I have sinned); for I was without da'as that thou stoodest in the derech against me; now, therefore, if it displease thee, I will return home. ");
INSERT INTO engojb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","And the Malach Hashem said unto Balaam, Go with the anashim; but only the devar (message) that I shall speak unto thee, that thou shalt speak. So Balaam went with the sarim (princes) of Balak. ");
INSERT INTO engojb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","And when Balak heard that Balaam was come, he went out to meet him unto the city of Moav at the Arnon border, which is in the farthest point of the boundary. ");
INSERT INTO engojb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","And Balak said unto Balaam, Did I not earnestly send unto thee to summon thee? Why camest thou not unto me? Am I not able indeed to honor thee? ");
INSERT INTO engojb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","And Balaam said unto Balak, Hinei, I am come unto thee; have I now any power at all to say anything? The devar (word, message) which Elohim putteth in my mouth, that shall I speak. ");
INSERT INTO engojb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","And Balaam went with Balak, and they came unto Kiryat Chutzot. ");
INSERT INTO engojb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","And Balak sacrificed oxen and sheep, and sent to Balaam, and to the sarim that were with him. ");
INSERT INTO engojb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","And it came to pass on the next day, that Balak took Balaam, and brought him up on the high places of Ba'al, that thence he might see a portion of HaAm. ");
INSERT INTO engojb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","And Balaam said unto Balak, Build me here shivah mizbechot, and prepare for me here shivah bulls and shivah rams. ");
INSERT INTO engojb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","And Balak did as Balaam had spoken; and Balak and Balaam offered on each mizbe'ach a bull and a ram. ");
INSERT INTO engojb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","And Balaam said unto Balak, Stand by thy olah, and I will go; perhaps Hashem will come to meet me; and whatsoever He showeth me I will tell thee. And he went to a barren height. ");
INSERT INTO engojb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","And Elohim met Balaam, and he said unto Him, I have prepared shivah hamizbechot, and I have offered upon each mizbe'ach a bull and a ram. ");
INSERT INTO engojb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","And Hashem put a word in Balaamʼs mouth, and said, Return unto Balak, and thus thou shalt speak. ");
INSERT INTO engojb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","And he returned unto him, and, hinei, he stood by his olah, he, and all the sarim of Moav. ");
INSERT INTO engojb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","And he took up his mashal, and said, Balak Melech Moav hath brought me from Aram (Syria), out of the mountains of the east, saying, Come, curse for me Ya'akov, and come, denounce Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How shall I curse, whom El hath not cursed? Or how shall I denounce, whom Hashem hath not denounced? ");
INSERT INTO engojb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of the rocks I see him, and from the heights I behold him; see, the people shall live apart, and shall not be reckoned among the Goyim. ");
INSERT INTO engojb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count the dust of Ya'akov, and the number of the fourth part of Yisroel? Let my nefesh die the death of the yesharim (righteous ones), and let my latter end be like his! ");
INSERT INTO engojb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","And Balak said unto Balaam, What hast thou done unto me? I brought thee to curse mine enemies, and, hinei, thou hast altogether put a brocha on them. ");
INSERT INTO engojb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","And he answered and said, Must I not take heed to speak that which Hashem hath put in my mouth? ");
INSERT INTO engojb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","And Balak said unto him, Come with me unto another place, from where thou mayest see them; thou shalt see part but not all of them, and curse them for me from there. ");
INSERT INTO engojb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","And he brought him into the sadeh of Tzophim, to the top of Pisgah, and built shivah mizbechot, and offered a bull and a ram on each mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","And he said unto Balak, Stand here by thy olah, while I meet Hashem over there. ");
INSERT INTO engojb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","And Hashem met Balaam, and put a word in his mouth, and said, Go again unto Balak, and say thus. ");
INSERT INTO engojb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","And when he came to him, hinei, he stood by his olah, and the sarim of Moav with him. And Balak said unto him, What hath Hashem spoken? ");
INSERT INTO engojb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","And he took up his mashal, and said, Rise up, Balak, and hear; pay heed unto me, thou son of Tzippor. ");
INSERT INTO engojb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","El is not an ish, that He should lie; neither a ben adam, that He should change His mind; hath He said, and shall He not do it? Or hath He spoken, and shall He not carry it out? ");
INSERT INTO engojb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Hinei, I have received commandment to make brocha; and He hath blessed; and I cannot reverse it. ");
INSERT INTO engojb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He hath not beheld aven in Ya'akov, neither hath He seen amal (trouble) in Yisroel. Hashem Elohav is with him, and the jubilant shout of a melech is about him. ");
INSERT INTO engojb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","El brought them out of Mitzrayim; He is for them like the strength of a wild ox. ");
INSERT INTO engojb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Surely there is no nachash (augury) in Ya'akov; neither is there any kesem (divination) in Yisroel; at the time it is spoken to Ya'akov and to Yisroel what El doeth! ");
INSERT INTO engojb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","See, the people shall rise up as a lioness, and lift up himself as an ari; he shall not lie down until he devours the prey, and drinks the dahm of the slain. ");
INSERT INTO engojb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","And Balak said unto Balaam, Neither curse them at all, nor at all make a brocha on them. ");
INSERT INTO engojb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam answered and said unto Balak, Did I not tell thee, saying, All that Hashem speaketh, that I must do? ");
INSERT INTO engojb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","And Balak said unto Balaam, Come now, I will bring thee unto another place; perhaps it will please HaElohim that thou mayest curse them for me from there. ");
INSERT INTO engojb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","And Balak brought Balaam unto the top of Pe'or, that overlooks Yeshimon. ");
INSERT INTO engojb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","And Balaam said unto Balak, Build me here shivah mizbechot, and prepare here shivah bulls and shivah rams for me. ");
INSERT INTO engojb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","And Balak did as Balaam had said, and offered a bull and a ram on each mizbe'ach. ");
INSERT INTO engojb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","And when Balaam saw that it was tov in the eyes of Hashem to bless Yisroel, he went not, as at other times, to use nechashim (sorceries, divination, looking for omens) but he set his face toward hamidbar. ");
INSERT INTO engojb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","And Balaam lifted up his eyes, and he saw Yisroel encamped according to their Shevatim; and the Ruach Elohim came upon him. ");
INSERT INTO engojb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","And he took up his mashal, and said, Balaam ben Be'or hath said, the man whose eyes are open hath said, ");
INSERT INTO engojb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","He hath said which heard the words of El, which saw the machazeh Shaddai (vision of Shaddai), which falling prostrate, but having his eyes open: ");
INSERT INTO engojb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Mah tovu ohalecha (How goodly, beautiful, are thy tents), O Ya'akov, and mishkenotecha (thy dwellings, tabernacles), O Yisroel! ");
INSERT INTO engojb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","As the valleys are they spread forth, as ganot (gardens) by the riverside, like aloes which Hashem hath planted, and as cedar trees beside the mayim. ");
INSERT INTO engojb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","He shall pour the mayim out of his buckets, and his zera shall have mayim rabbim, and his Melech shall be more exalted than Agag, and Malchuso (His Kingdom) shall be upraised. ");
INSERT INTO engojb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","El brought him forth out of Mitzrayim. He hath the strength of a wild bull. He shall devour the Goyim his enemies and break their atzmot, and pierce them through with his khitzim. ");
INSERT INTO engojb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He crouched, he lay down as an ari, and as the lioness; who shall stir him up? Mevarakhecha is he that makes a barucha on thee, and cursed is he that curseth thee. ");
INSERT INTO engojb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","And af Balak (anger of Balak) was kindled against Balaam, and he struck his hands together; and Balak said unto Balaam, I summoned thee to curse mine enemies, and, hinei, thou hast altogether blessed them these shalosh pe'amim. ");
INSERT INTO engojb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Therefore now flee thou to thy mekom; I thought to kibed (honor, reward) thee honorably; but, hinei, Hashem hath kept thee back from kavod (honor, reward). ");
INSERT INTO engojb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","And Balaam said unto Balak, Spoke I not also to thy malachim which thou didst send unto me, saying, ");
INSERT INTO engojb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","If Balak would give me his bais full of kesef and zahav, I cannot go beyond the commandment of Hashem, to do either tovah or ra'ah of mine own lev; but what Hashem saith, that will I say! ");
INSERT INTO engojb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","And now, hinei, I go back unto my people; come therefore, and I will warn thee what HaAm HaZeh shall do to thy people in the Acharit HaYamim. ");
INSERT INTO engojb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","And he took up his mashal, and said, Balaam ben Be'or hath said, the man whose eyes are open hath said, ");
INSERT INTO engojb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","He hath said, which heard the words of El, and knew the Da'as Elyon, which saw the Machazeh Shaddai, falling prostrate, but having his eyes open: ");
INSERT INTO engojb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but not now; I behold him, but not karov (near); there shall come a Kokhav (Star, i.e. Moshiach, see Targums) out of Ya'akov, and a Shevet (Sceptre) shall rise out of Yisroel, and shall strike through the temples of Moav, and destroy all the Bnei Shet. ");
INSERT INTO engojb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","And Edom shall be a possession; Se'ir also shall be a possession for his enemies; but Yisroel shall do valiantly. ");
INSERT INTO engojb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Out of Ya'akov shall come he that shall have dominion, and shall destroy him that remaineth of the Ir. ");
INSERT INTO engojb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","And when he looked on Amalek, he took up his mashal, and said, Amalek was the reshit of the Goyim; but his acharit (latter end) shall be that unto destruction. ");
INSERT INTO engojb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","And he looked on the Keni (Kenites), and took up his mashal, and said, Strong is thy moshav (dwelling place), and thou puttest thy ken (nest) in a rock. ");
INSERT INTO engojb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nevertheless Kayin shall be for burning, while Ashur (Assyria) shall carry thee away captive. ");
INSERT INTO engojb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","And he took up his mashal, and said, Oy, who shall live when El doeth this? ");
INSERT INTO engojb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","And ships shall come from the coast of Kittim (Cyprus), and shall afflict Ashur (Assyria), and shall afflict Ever, and he also shall be unto destruction. ");
INSERT INTO engojb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","And Balaam rose up, and went and returned to his makom (place, home); and Balak also went his way. ");
INSERT INTO engojb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","And Yisroel was staying in Sheetim, and HaAm began to commit whoredom with the Banot Moav. ");
INSERT INTO engojb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","And they invited the people unto the zevakhim of their g-ds; and the people did eat and bowed down to their g-ds. ");
INSERT INTO engojb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","And Yisroel joined himself unto Ba'al-Pe'or; and the Af Hashem was kindled against Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","And Hashem said unto Moshe, Take Kol Rashei HaAm, and kill them, hanging them before Hashem against the shemesh, that the fierce Af Hashem(Anger of Hashem) may be turned away from Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","And Moshe said unto the shofetim of Yisroel, Slay ye every one his men that were joined unto Ba'al-Pe'or. ");
INSERT INTO engojb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","And, hinei, one of the Bnei Yisroel came and brought unto his brethren a woman from Midyan before the eyes of Moshe, and before the eyes of Kol Adat Bnei Yisroel, who were weeping before the entrance of the Ohel Mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","And when Pinchas ben El'azar ben Aharon HaKohen saw it, he rose up from among HaEdah, and took a romach (spear) in his yad; ");
INSERT INTO engojb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","And he went after the ish Yisroel into the inner tent, and thrust through both of them, the ish Yisroel, and the isha through her belly. So the maggefah (plague) was stopped from the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","And those that were the mesim (dead ones) in the maggefah (plague) were twenty and four thousand. ");
INSERT INTO engojb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Pinchas ben El'azar ben Aharon HaKohen, hath turned My wrath away from the Bnei Yisroel, when he had kanous (zealousness) with My kanous among them, that I consumed not the Bnei Yisroel in My kina (jealousy, zeal, vengeance). ");
INSERT INTO engojb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Therefore say, Hineni, I am making unto him My Brit (Covenant) of Shalom; ");
INSERT INTO engojb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","And he shall have it, and his zera after him, even the Brit Kehunat Olam; because he had kanous for Elohav, and made kapporah for the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now the shem of the ish Yisroel that was slain, even that was slain with the woman from Midyan, was Zimri ben Salu, a nasi of one of the beit avot from the tribe of Shim'on. ");
INSERT INTO engojb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","And the shem of the isha from Midyan that was slain was Kozbi bat Tzur; he was rosh over the people in one of the clans of Midyan. ");
INSERT INTO engojb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Be hostile toward the Midyanim, and strike them; ");
INSERT INTO engojb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","For they are hostile toward you with their wiles, wherewith they have beguiled you in the matter of Pe'or, and in the matter of Kozbi bat Nasi Midyan, their achot, which was slain in the yom of the maggefah that resulted from Pe'or. ");
INSERT INTO engojb_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","And it came to pass after the maggefah (plague), ");
INSERT INTO engojb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","that Hashem spoke unto Moshe and unto El'azar Ben Aharon HaKohen, saying, ");
INSERT INTO engojb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Take the rosh (census) of kol Adat Bnei Yisroel from twenty years old and upward, throughout their bais avot, all that are yotzei tzava (able to go to war) in Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","And Moshe and El'azar HaKohen spoke with them in the arevot Moav (plains of Moav) by Yarden near Yericho, saying, ");
INSERT INTO engojb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Take the census of the people, from twenty years old and upward, just as Hashem commanded Moshe and the Bnei Yisroel, which went forth out of Eretz Mitzrayim. ");
INSERT INTO engojb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuven, the Bechor Yisroel: the Bnei Reuven; Chanokh, of whom cometh the Mishpakhat HaChanokhi; of Pallu, the Mishpakhat HaPallu'i; ");
INSERT INTO engojb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Of Chetzron, Mishpakhat HaChetzroni; of Carmi, the Mishpakhat HaCaremi. ");
INSERT INTO engojb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These are the Mishpekhot HaReuveni; and they that were numbered of them were 43,730. ");
INSERT INTO engojb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","And the Bnei Pallu; Eliav. ");
INSERT INTO engojb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","And the Bnei Eliav; Nemuel, and Datan, and Aviram. This is that Datan and Aviram, which were summoned by the edah, who made a contention against Moshe and against Aharon in the adat Korach, when they contended in opposition to Hashem: ");
INSERT INTO engojb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","And ha'aretz opened her mouth, and swallowed them up together with Korach, when that edah died, when the eish devoured 250; and they became as a nes (warning). ");
INSERT INTO engojb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Notwithstanding, the Bnei Korach died not. ");
INSERT INTO engojb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The Bnei Shim'on after their mishpekhot: of Nemuel, the Mishpakhat HaNemueli; of Yamin, the Mishpakhat HaYamini; of Yachin, the Mishpakhat HaYachini; ");
INSERT INTO engojb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Of Zerach, the Mishpakhat HaZarchi; of Sha'ul, the Mishpakhat HaSha'uli. ");
INSERT INTO engojb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These are the Mishpekhot HaShim'oni, 22,200. ");
INSERT INTO engojb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The Bnei Gad after their Mishpekhot; of Tzephon, the Mishpakhat HaTzephoni; of Chaggi, the Mishpakhat HaChaggi; of Shuni, the Mishpakhat HaShuni; ");
INSERT INTO engojb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Of Ozni, the Mishpakhat HaOzni; of Eri, the Mishpakhat HaEri; ");
INSERT INTO engojb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Of Arod, the Mishpakhat HaArodi; of Areli, the Mishpakhat HaAreli. ");
INSERT INTO engojb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These are the Mishpekhot Bnei Gad according to those that were numbered of them, 40,500. ");
INSERT INTO engojb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The Bnei Yehudah were Er and Onan; and Er and Onan died in Eretz Kena'an. ");
INSERT INTO engojb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","And the Bnei Yehudah after their Mishpekhot were: of Shelah, the Mishpakhat HaShelani; of Peretz, the Mishpakhat HaPartzi; of Zerach, the Mishpakhat HaZarchi. ");
INSERT INTO engojb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","And the Bnei Peretz were: of Chetzron, the Mishpakhat HaChetzroni; of Chamul, the Mishpakhat HeChamuli. ");
INSERT INTO engojb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These are the Mishpekhot Yehudah according to those that were numbered of them, 76,500. ");
INSERT INTO engojb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Of the Bnei Yissakhar after their Mishpekhot: of Tola, the Mishpakhat HaTola'i; of Puvah, the Mishpakhat HaPuni; ");
INSERT INTO engojb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Of Yashuv, the Mishpakhat HaYashuvi; of Shimron, the Mishpakhat HaShimroni. ");
INSERT INTO engojb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These are the Mishpekhot of Yissakhar according to those that were numbered of them, 64,300. ");
INSERT INTO engojb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Of the Bnei Zevulun after their Mishpekhot: of Sered, the Mishpakhat HaSaredi; of Elon, the Mishpakhat HaEloni; of Yachle'el, the Mishpakhat HaYachle'eli. ");
INSERT INTO engojb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These are the Mishpekhot of the Zevuloni according to those that were numbered of them, 60,500. ");
INSERT INTO engojb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The Bnei Yosef after their Mishpekhot were Menasheh and Ephrayim. ");
INSERT INTO engojb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Of the Bnei Menasheh: of Machir, the Mishpakhat HaMachiri; and Machir fathered Gil'ad; of Gil'ad come the Mishpakhat HaGile'adi. ");
INSERT INTO engojb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These are the Bnei Gil'ad: of I'ezer, the Mishpakhat HaI'ezeri; of Chelek, the Mishpakhat HaCheleki; ");
INSERT INTO engojb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","And of Asriel, the Mishpakhat HaAsri'eli; and of Shechem, the Mishpakhat HaShichmi. ");
INSERT INTO engojb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","And of Shemida, the Mishpakhat HaShemida'i; and of Chepher, the Mishpakhat Chepheri. ");
INSERT INTO engojb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","And Tzelophechad Ben Chepher had no banim, but banot; and the shem banot Tzelophechad were Machlah, No'ah, Choglah, Milcah, and Tirtzah. ");
INSERT INTO engojb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are the Mishpekhot of Menasheh, and those that were numbered of them, 52,700. ");
INSERT INTO engojb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are the Bnei Ephrayim after their Mishpekhot: of Shutelach, the Mishpakhat HaShutalechi; of Bekher, the Mishpakhat HaBakhri; of Tachan, the Mishpakhat HaTachani. ");
INSERT INTO engojb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","And these are the Bnei Shutelach: of Eran, the Mishpakhat HaErani. ");
INSERT INTO engojb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These are the Mishpekhot Bnei Ephrayim according to those that were numbered of them, 32,500. These are the Bnei Yosef after their Mishpekhot. ");
INSERT INTO engojb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The Bnei Binyamin after their Mishpekhot: of Bela, the Mishpakhat HaBale'i; of Ashbel, the Mishpakhat HaAshbeli; of Achiram, the Mishpakhat HaAchirami; ");
INSERT INTO engojb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Of Shefufam, the Mishpakhat HaShufami; of Chupham, the Mishpakhat HaChuphami. ");
INSERT INTO engojb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","And the Bnei Bela were Ard and Na'aman; of Ard, the Mishpakhat HaAredi; and of Na'aman, the Mishpakhat HaNa'ami. ");
INSERT INTO engojb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are the Bnei Binyamin after their Mishpekhot; and they were numbered of them 45,600. ");
INSERT INTO engojb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are the Bnei Dan after their Mishpekhot: of Shucham, the Mishpakhat HaShuchami. These are the Mishpekhot of Dan after their Mishpekhot. ");
INSERT INTO engojb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All the Mishpekhot HaShuchami, according to those that were numbered of them, were 64,400. ");
INSERT INTO engojb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Of the Bnei Asher after their Mishpekhot: of Yimna, the Mishpakhat HaYimnah; of Yishvi, the Mishpakhat HaYishvi; of Beri'ah, the Mishpakhat HaBeri'i. ");
INSERT INTO engojb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Of the Bnei Beri'ah: of Chever, the Mishpakhat HaChevri; of Malki'el, the Mishpakhat HaMalki'eli. ");
INSERT INTO engojb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","And the shem Bat Asher was Serach. ");
INSERT INTO engojb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are the Mishpekhot Bnei Asher according to those that were numbered of them; who were 53,400. ");
INSERT INTO engojb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Of the Bnei Naphtali after their Mishpekhot: of Yachtze'el, the Mishpakhat HaYachtze'eli; of Guni, the Mishpakhat HaGuni; ");
INSERT INTO engojb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Of Yetzer, the mishpakhat of the HaYitzri; of Shillem, the Mishpakhat HaShillemi. ");
INSERT INTO engojb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These are the Mishpekhot Naphtali according to their Mishpekhot: and they that were numbered of them 45, 400. ");
INSERT INTO engojb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These were the numbered of the Bnei Yisroel, 601,730. ");
INSERT INTO engojb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Unto these the land shall be allotted for a nachalah according to the mispar (number) of shmot (names). ");
INSERT INTO engojb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To those large of number thou shalt give the larger nachalah, and to few thou shalt give the smaller nachalah: to every one shall his nachalah be given according to those that were numbered of him. ");
INSERT INTO engojb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Notwithstanding, HaAretz shall be distributed by goral; according to the Shmot Mattot of their Avot they shall inherit. ");
INSERT INTO engojb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","According to the goral shall nachalah thereof be distributed between many and few. ");
INSERT INTO engojb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","And these are they that were numbered of the Levi'im after their Mishpekhot: of Gershon, the Mishpakhat HaGershuni; of Kehat, the Mishpakhat HaKehati; of Merari, the Mishpakhat HaMerari. ");
INSERT INTO engojb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are the Mishpekhot Levi: the Mishpakhat HaLivni, the Mishpakhat HaChevroni, the Mishpakhat HaMachli, the Mishpakhat HaMushi, the Mishpakhat HaKorchi. And Kehat fathered Amram. ");
INSERT INTO engojb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","And the shem eshet Amram was Yocheved Bat Levi, who was born to Levi in Mitzrayim: and she bore unto Amram Aharon and Moshe, and Miryam their achot. ");
INSERT INTO engojb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","And unto Aharon was born Nadav, and Avihu, El'azar, and Itamar. ");
INSERT INTO engojb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","And Nadav and Avihu died, when they offered eish zarah before Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","And those that were numbered of them were 23,000, kol zachar from a month old and upward: for they were not numbered among the Bnei Yisroel, because there was no nachalah given them among the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These are they that were numbered by Moshe and El'azar HaKohen, who numbered the Bnei Yisroel in the arevot Moav (plains of Moav) by Yarden near Yericho. ");
INSERT INTO engojb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But among these there was not an ish of them whom Moshe and Aharon HaKohen numbered, when they numbered the Bnei Yisroel in the Midbar Sinai. ");
INSERT INTO engojb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For Hashem had said of them, They shall surely die in the Midbar. And there was not left an ish from them, except Kalev Ben Yephunneh, and Yehoshua Ben Nun. ");
INSERT INTO engojb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Then came the Banot Tzelophechad Ben Chepher Ben Gil'ad Ben Machir Ben Menasheh, of the Mishpekhot Menasheh Ben Yosef: and these are the shmot of his banot: Machlah, No'ah, and Choglah, and Milcah, and Tirtzah. ");
INSERT INTO engojb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","And they stood before Moshe, and before El'azar HaKohen, and before the Nasiim and kol HaEdah, by the petach Ohel Mo'ed, saying, ");
INSERT INTO engojb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Avinu died in the midbar, and he was not in the edah hano'adim (assembly of ones banding together) against Hashem in the Adat Korach; but died in his own chet, and had no banim. ");
INSERT INTO engojb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should the shem avinu be withdrawn from among his Mishpakhat, because he hath no ben? Give unto us therefore achuzzah among the achei avinu. ");
INSERT INTO engojb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","And Moshe brought their mishpat before Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","The Banot Tzelophechad speak right; thou shalt surely give them achuzzat nachalah among achei avihem; and thou shalt cause the nachalat avihen to pass over unto them. ");
INSERT INTO engojb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","And thou shalt speak unto the Bnei Yisroel, saying, If an ish die, and have no ben, then ye shall cause his nachalah to pass over unto his bat. ");
INSERT INTO engojb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","And if he have no bat, then ye shall give his nachalah unto his achim. ");
INSERT INTO engojb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","And if he have no achim, then ye shall give his nachalah unto achei aviv. ");
INSERT INTO engojb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","And if his av have no achim, then ye shall give his nachalah unto his closest relative of his Mishpakhat, and he shall possess it; and it shall be unto the Bnei Yisroel a chukkat mishpat, as Hashem commanded Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","And Hashem said unto Moshe, Get thee up on this har haAvarim, and see HaAretz which I have given unto the Bnei Yisroel. ");
INSERT INTO engojb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","And when thou hast seen it, thou also shalt be gathered unto thy people, as Aharon achicha was gathered. ");
INSERT INTO engojb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","For ye rebelled against My command in the Midbar Tzin, in the merivat HaEdah (strife of the Assembly) to honor Me as Kodesh before their eyes at the mayim: that is, the mayim of Merivah in Kadesh in the Midbar Tzin. ");
INSERT INTO engojb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","And Moshe spoke unto Hashem, saying, ");
INSERT INTO engojb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Let Hashem Elohei HaRuchot L'khol Basar appoint an Ish over HaEdah, ");
INSERT INTO engojb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Which will go out before them, and which will come in before them, and which will lead them out, and which will bring them in; that the Adat Hashem be not like tzon which have no ro'eh. ");
INSERT INTO engojb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","And Hashem said unto Moshe, Take thee Yehoshua Ben Nun, an ish in whom is the Ruach, and lay thine yad upon him; ");
INSERT INTO engojb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","And stand him before El'azar HaKohen, and before kol HaEdah and give him a charge before their eyes. ");
INSERT INTO engojb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","And thou shalt lay of thine hod (dignity, authority, majesty) upon him, so that kol Adat Bnei Yisroel will obey. ");
INSERT INTO engojb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","And he shall stand before El'azar HaKohen, who shall ask counsel for him after the mishpat HaUrim before Hashem: at his word shall they go out, and at his word they shall come in, both he, and kol Bnei Yisroel with him, even kol HaEdah. ");
INSERT INTO engojb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","And Moshe did just as Hashem commanded him; and he took Yehoshua, and stood him before El'azar HaKohen, and before kol HaEdah: ");
INSERT INTO engojb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","And he laid his yadayim upon him, and gave him a charge, just as Hashem commanded by yad Moshe. ");
INSERT INTO engojb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","And Hashem spoke unto Moshe, saying, ");
INSERT INTO engojb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Command the Bnei Yisroel, and say unto them, My korban, and My lechem by My fires, My re'ach hannichoach, shall ye be shomer to offer unto Me in its mo'ed. ");
INSERT INTO engojb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","And thou shalt say unto them, This is the fire-offering which ye shall offer unto Hashem; two kevasim (male lambs) of the first year temimim, two a day, for an olah tamid. ");
INSERT INTO engojb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","The one keves shalt thou offer in the boker, and the other keves shalt thou offer towards erev; ");
INSERT INTO engojb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","And a tenth-ephah of fine flour for a minchah, mixed with the fourth-hin of pressed shemen. ");
INSERT INTO engojb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","It is an olat tamid (continual burnt offering) which was ordained in Mt Sinai for a re'ach hannichoach, a fire-offering unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","And the nesekh (libation offering) thereof shall be the fourth-hin for the one keves: baKodesh shalt thou cause the nesekh shechar to be poured out unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","And the other keves (male lamb) shalt thou offer at erev: like the minchah of the boker, and like the nesekh thereof, thou shalt offer it, a fire-offering of re'ach hannicho'ach unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","And on Yom HaShabbos two kevasim of the first year temimim (unblemished ones) and two tenths-ephah of fine flour for a minchah, mixed with shemen, and the nesekh thereof; ");
INSERT INTO engojb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is the olah (burnt offering) of every Shabbos, in addition to the continual olah, and its nesekh. ");
INSERT INTO engojb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","And at each Rosh-Chodesh of yours, ye shall offer an olah unto Hashem; two young bulls, and one ram, shivah kevasim (male lambs) of the first year temimim (unblemished ones); ");
INSERT INTO engojb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","And three tenths-ephah of fine flour for a minchah, mixed with shemen, for each bull; and two tenths-ephah of fine flour for a minchah, mixed with shemen for the one ram; ");
INSERT INTO engojb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","And a tenth-ephah of fine flour mixed with shemen for a minchah for each keves; for an olah (burnt offering) of a re'ach hannichoach, a fire-offering unto Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","And their nesakhim shall be a half-hin for each bull, and the third-hin for the ram, and a quarter-hin for each keves: this is the olah (burnt offering) for every Rosh Chodesh throughout the months of the shanah (year). ");
INSERT INTO engojb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","And one young male goat for a chattat unto Hashem shall be offered. It shall be in addition to the continual olah (burnt offering), and its nesekh. ");
INSERT INTO engojb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","And in the fourteenth day of the chodesh harishon (first month i.e., Nisan) is the Pesach to Hashem. ");
INSERT INTO engojb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","And in the fifteenth day of this month is a Chag: shivat yamim shall matzot be eaten. ");
INSERT INTO engojb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","In the yom harishon shall be a mikra kodesh (holy convocation); ye shall do no manner of melekhet avodah therein; ");
INSERT INTO engojb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","But ye shall offer a fire-offering for an olah unto Hashem; two young bulls, and one ram, and shivah kevasim of the first year; they shall be unto you temimim (unblemished ones). ");
INSERT INTO engojb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","And their minchah shall be of fine flour mixed with shemen: three tenths-ephah shall ye offer for each bull, and two tenths-ephah for the ram; ");
INSERT INTO engojb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","One tenth-ephah shalt thou offer for each keves, of the shivat hakevasim. ");
INSERT INTO engojb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","And one goat for a chattat, to make kapporah for you. ");
INSERT INTO engojb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Ye shall offer these in addition to the olah (burnt offering) of the boker, which is for the olat hatamid (continual burnt offering). ");
INSERT INTO engojb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","After this manner ye shall offer daily, throughout the shivat yamim (seven days): lechem, a fire-offering, reiach hannichoach unto Hashem: it shall be offered in addition to the olat hatamid (the continual burnt offering), and its nesekh. ");
INSERT INTO engojb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","And on the yom hashevi'i ye shall have a mikra kodesh; ye shall do no melekhet avodah. ");
INSERT INTO engojb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Also in the Yom HaBikkurim, when ye bring a minchah chadashah unto Hashem, on your Shavu'os, ye shall have a mikra kodesh; ye shall do no melekhet avodah: ");
INSERT INTO engojb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","But ye shall offer the olah (burnt offering) for a reach hannichoach unto Hashem; two young bulls, one ram, shivah kevasim of the first year; ");
INSERT INTO engojb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","And their minchah of fine flour mixed with shemen, three tenths-ephah for each bull, two tenths-ephah for the ayil haechad (one ram). ");
INSERT INTO engojb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","One tenth-ephah unto one keves for each of the shivat hakevasim; ");
INSERT INTO engojb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","And one male goat, to make kapporah for you. ");
INSERT INTO engojb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Ye shall offer them in addition to the olat hatamid and its minchah, (they shall be unto you tamimim, unblemished ones) and their nesakhim. ");
INSERT INTO engojb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","And in the Chodesh Hashevi'i on the first day of the month, ye shall have a mikra kodesh; ye shall do no melekhet avodah; it is a Yom Teruah (Day of the sounding of the Shofar, i.e., Rosh Hashanah) unto you. ");
INSERT INTO engojb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","And ye shall offer an olah (burnt offering) for a reach hannichoach unto Hashem; one young bull, one ram, and shivah kevasim (male lambs) of the first year temimim. ");
INSERT INTO engojb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","And their minchah shall be of fine flour mixed with shemen, three tenths-ephah for the bull, and two tenths-ephah for the ram, ");
INSERT INTO engojb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","And one tenth-ephah for each keves of the shivat hakevasim; ");
INSERT INTO engojb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","And one male of the goats for a chattat to make kapporah for you; ");
INSERT INTO engojb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","In addition to the olat hachodesh and its minchah, and the olat hatamid and its minchah, and their nesakhim, according to the mishpatim, for a reach hannichoach, a fire-offering unto Hashem. ");
INSERT INTO engojb_vp