﻿USE sofia;
DROP TABLE IF EXISTS sofia.engnoy_vpl;
CREATE TABLE engnoy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engnoy_vpl WRITE;
INSERT INTO engnoy_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","In the land of Uz lived a man whose name was Job. He was an upright and good man, fearing God and departing from evil. ");
INSERT INTO engnoy_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","He had seven sons and three daughters. ");
INSERT INTO engnoy_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","His substance was seven thousand sheep, three thousand camels, five hundred yoke of oxen, five hundred she-asses, and a great number of servants; so that he was the greatest of all the inhabitants of the East. ");
INSERT INTO engnoy_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Now it was the custom of his sons to make a feast in their houses, each on his day, and to send and invite their three sisters to eat and to drink with them. ");
INSERT INTO engnoy_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","And when the days of their feasting had gone round, Job used to send for them and sanctify them, and to rise up early in the morning and offer burnt-offerings according to the number of them all; for Job said, It may be that my sons have sinned, and have renounced God in their hearts. Thus did Job continually. ");
INSERT INTO engnoy_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Now on a certain day the sons of God came to present themselves before Jehovah, and Satan also came among them. ");
INSERT INTO engnoy_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","And Jehovah said to Satan, Whence comest thou? Then Satan answered Jehovah, and said, From wandering over the earth, and walking up and down in it. ");
INSERT INTO engnoy_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","And Jehovah said to Satan, Hast thou observed my servant Job, that there is none like him in the earth, an upright and good man, fearing God and departing from evil? ");
INSERT INTO engnoy_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Then Satan answered Jehovah, Is it for nought that Job feareth God? ");
INSERT INTO engnoy_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Hast thou not placed a hedge around him, and around his house, and around all his possessions? Thou hast prospered the work of his hands, and his herds are greatly increased in the land. ");
INSERT INTO engnoy_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","But only put forth thy hand, and touch whatever he possesseth, and to thy face will he renounce thee. ");
INSERT INTO engnoy_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","And Jehovah said to Satan, Behold, all that he hath is in thy power; but upon him lay not thy hand. So Satan went forth from the presence of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Now on a certain day the sons and daughters of Job were eating and drinking wine in their eldest brother's house, ");
INSERT INTO engnoy_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","when a messenger came to Job, and said, The oxen were ploughing, and the asses feeding beside them, ");
INSERT INTO engnoy_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","and the Sabaeans fell upon them, and took them away; the servants also they slew with the edge of the sword; and I only am escaped alone to tell thee. ");
INSERT INTO engnoy_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","While he was yet speaking, there came also another, and said, The fire of God hath fallen from heaven, and hath burned up the sheep and the servants, and consumed them; and I only am escaped alone to tell thee. ");
INSERT INTO engnoy_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","While he was yet speaking, there came also another, and said, The Chaldaeans made out three bands, and fell upon the camels, and carried them away; the servants also they slew with the edge of the sword; and I only am escaped alone to tell thee. ");
INSERT INTO engnoy_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","While he was yet speaking, there came also another, and said, Thy sons and thy daughters were eating and drinking wine in their eldest brother's house; ");
INSERT INTO engnoy_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","and, lo! there came a great wind from the desert, and smote the four corners of the house, and it fell upon the young men, and they are dead; and I only am escaped alone to tell thee. ");
INSERT INTO engnoy_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Then Job arose, and rent his mantle, and shaved his head, and fell down upon the ground, and worshipped; ");
INSERT INTO engnoy_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","and said, Naked came I forth from my mother's womb, and naked shall I return thither. Jehovah gave, and Jehovah hath taken away; blessed be the name of Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","In all this Job sinned not, nor uttered vain words against God. ");
INSERT INTO engnoy_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Again there was a day when the sons of God came to present themselves before Jehovah; and Satan came also among them to present himself before Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","And Jehovah said to Satan, Whence comest thou? And Satan answered Jehovah, and said, From wandering over the earth, and walking up and down in it. ");
INSERT INTO engnoy_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Then said Jehovah to Satan, Hast thou observed my servant Job, that there is none like him upon the earth, an upright and good man, fearing God and departing from evil? And still he holdeth fast his integrity, although thou didst excite me against him to destroy him without a cause. ");
INSERT INTO engnoy_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","And Satan answered Jehovah, and said, Skin for skin, yea, all that a man hath will he give for his life. ");
INSERT INTO engnoy_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","But put forth now thy hand, and touch his bone and his flesh, and to thy face will he renounce thee. ");
INSERT INTO engnoy_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","And Jehovah said to Satan, Behold, he is in thy hand; but spare his life. ");
INSERT INTO engnoy_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Then Satan went forth from the presence of Jehovah, and smote Job with sore boils from the sole of his foot to his crown. ");
INSERT INTO engnoy_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","And he took a potsherd to scrape himself withal, and sat down among the ashes. ");
INSERT INTO engnoy_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Then said his wife to him, Dost thou still retain thine integrity? Renounce God, and die. ");
INSERT INTO engnoy_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","But he said to her, Thou talkest like one of the foolish women. What! shall we receive good at the hand of God, and shall we not receive evil? In all this, Job sinned not with his lips. ");
INSERT INTO engnoy_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Now three friends of Job heard of all this evil that had come upon him, and came each one from his home; Eliphaz the Temanite, and Bildad the Shuhite, and Zophar the Naamathite; for they had agreed to come to mourn with him, and to comfort him. ");
INSERT INTO engnoy_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","And they lifted up their eyes at a distance, and knew him not; then they raised their voices and wept, and rent each one his mantle, and sprinkled dust upon their heads toward heaven. ");
INSERT INTO engnoy_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","And they sat down with him upon the ground seven days and seven nights, and none spake a word to him; for they saw that his grief was very great. ");
INSERT INTO engnoy_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","At length Job opened his mouth, and cursed the day of his birth. ");
INSERT INTO engnoy_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","And Job spake and said: ");
INSERT INTO engnoy_vpl VALUES ("JB3_3","019_3_3","JOB","3","3","3","Perish the day in which I was born, and the night which said, “A man-child is conceived!” ");
INSERT INTO engnoy_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Let that day be darkness; Let not God seek it from above; Yea, let not the light shine upon it! ");
INSERT INTO engnoy_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Let darkness and the shadow of death redeem it; Let a cloud dwell upon it; Let whatever darkeneth the day terrify it! ");
INSERT INTO engnoy_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","As for that night, let darkness seize upon it; Let it not rejoice among the days of the year; Let it not come into the number of the months! ");
INSERT INTO engnoy_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","O let that night be unfruitful! Let there be in it no voice of joy; ");
INSERT INTO engnoy_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Let them that curse the day curse it, Who are skilful to stir up the leviathan! ");
INSERT INTO engnoy_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Let the stars of its twilight be darkened; Let it long for light, and have none; Neither let it see the eyelashes of the morning! ");
INSERT INTO engnoy_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","Because it shut not up the doors of my mother's womb, And hid not trouble from mine eyes. ");
INSERT INTO engnoy_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Why died I not at my birth? Why did I not expire when I came forth from the womb? ");
INSERT INTO engnoy_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","Why did the knees receive me, And why the breasts, that I might suck? ");
INSERT INTO engnoy_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","For now should I lie down and be quiet; I should sleep; then should I be at rest, ");
INSERT INTO engnoy_vpl VALUES ("JB3_14","019_3_14","JOB","3","14","14","With kings and counsellors of the earth, Who built up for themselves—ruins! ");
INSERT INTO engnoy_vpl VALUES ("JB3_15","019_3_15","JOB","3","15","15","Or with princes that had gold, And filled their houses with silver; ");
INSERT INTO engnoy_vpl VALUES ("JB3_16","019_3_16","JOB","3","16","16","Or, as a hidden untimely birth, I had perished; As infants which never saw the light. ");
INSERT INTO engnoy_vpl VALUES ("JB3_17","019_3_17","JOB","3","17","17","There the wicked cease from troubling; There the weary are at rest. ");
INSERT INTO engnoy_vpl VALUES ("JB3_18","019_3_18","JOB","3","18","18","There the prisoners rest together; They hear not the voice of the oppressor. ");
INSERT INTO engnoy_vpl VALUES ("JB3_19","019_3_19","JOB","3","19","19","The small and the great are there, And the servant is free from his master. ");
INSERT INTO engnoy_vpl VALUES ("JB3_20","019_3_20","JOB","3","20","20","Why giveth He light to him that is in misery, And life to the bitter in soul, ");
INSERT INTO engnoy_vpl VALUES ("JB3_21","019_3_21","JOB","3","21","21","Who long for death, and it cometh not, And dig for it more than for hid treasures; ");
INSERT INTO engnoy_vpl VALUES ("JB3_22","019_3_22","JOB","3","22","22","Who rejoice exceedingly, Yea, exult, when they can find a grave? ");
INSERT INTO engnoy_vpl VALUES ("JB3_23","019_3_23","JOB","3","23","23","Why is light given to a man from whom the way is hid, And whom God hath hedged in? ");
INSERT INTO engnoy_vpl VALUES ("JB3_24","019_3_24","JOB","3","24","24","For my sighing cometh before I eat, And my groans are poured out like water. ");
INSERT INTO engnoy_vpl VALUES ("JB3_25","019_3_25","JOB","3","25","25","For that which I dread overtaketh me; That at which I shudder cometh upon me. ");
INSERT INTO engnoy_vpl VALUES ("JB3_26","019_3_26","JOB","3","26","26","I have no peace, nor quiet, nor respite: Misery cometh upon me continually. ");
INSERT INTO engnoy_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Then spake Eliphaz the Temanite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","If one attempt a word with thee, wilt thou be offended? But who can refrain from speaking? ");
INSERT INTO engnoy_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Behold, thou hast admonished many; Thou hast strengthened feeble hands; ");
INSERT INTO engnoy_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Thy words have upheld him that was falling, And thou hast given strength to feeble knees. ");
INSERT INTO engnoy_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","But now it is come upon thee, and thou faintest; It toucheth thee, and thou art confounded! ");
INSERT INTO engnoy_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Is not thy fear of God thy hope, And the uprightness of thy ways thy confidence? ");
INSERT INTO engnoy_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Remember, I pray thee, who ever perished being innocent? Or where have the righteous been cut off? ");
INSERT INTO engnoy_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","According to what I have seen, they who plough iniquity, And sow mischief, reap the same. ");
INSERT INTO engnoy_vpl VALUES ("JB4_9","019_4_9","JOB","4","9","9","By the blast of God they perish, And by the breath of his nostrils they are consumed. ");
INSERT INTO engnoy_vpl VALUES ("JB4_10","019_4_10","JOB","4","10","10","The roaring of the lion, and the voice of the fierce lion, And the teeth of the young lions are broken. ");
INSERT INTO engnoy_vpl VALUES ("JB4_11","019_4_11","JOB","4","11","11","The fierce lion perisheth for lack of prey, And the whelps of the lioness are scattered abroad. ");
INSERT INTO engnoy_vpl VALUES ("JB4_12","019_4_12","JOB","4","12","12","A word was once secretly brought to me, And mine ear caught a whisper thereof. ");
INSERT INTO engnoy_vpl VALUES ("JB4_13","019_4_13","JOB","4","13","13","Amid thoughts from visions of the night, When deep sleep falleth upon men, ");
INSERT INTO engnoy_vpl VALUES ("JB4_14","019_4_14","JOB","4","14","14","A fear and a horror came upon me, Which made all my bones to shake. ");
INSERT INTO engnoy_vpl VALUES ("JB4_15","019_4_15","JOB","4","15","15","Then a spirit passed before my face, The hair of my flesh rose on end; ");
INSERT INTO engnoy_vpl VALUES ("JB4_16","019_4_16","JOB","4","16","16","It stood still, but its form I could not discern; An image was before mine eyes; There was silence, and I heard a voice: ");
INSERT INTO engnoy_vpl VALUES ("JB4_17","019_4_17","JOB","4","17","17","“Shall mortal man be more just than God? Shall man be more pure than his Maker? ");
INSERT INTO engnoy_vpl VALUES ("JB4_18","019_4_18","JOB","4","18","18","Behold, he putteth no trust in his ministering spirits, And his angels he chargeth with frailty. ");
INSERT INTO engnoy_vpl VALUES ("JB4_19","019_4_19","JOB","4","19","19","What then are they who dwell in houses of clay, Whose foundation is in the dust, Who crumble to pieces, as if moth-eaten! ");
INSERT INTO engnoy_vpl VALUES ("JB4_20","019_4_20","JOB","4","20","20","Between morning and evening are they destroyed; They perish for ever, and none regardeth it. ");
INSERT INTO engnoy_vpl VALUES ("JB4_21","019_4_21","JOB","4","21","21","The excellency that is in them is torn away; They die before they have become wise.” ");
INSERT INTO engnoy_vpl VALUES ("JB5_1","019_5_1","JOB","5","1","1","Call now, see if any will answer thee! And to which of the holy ones wilt thou look? ");
INSERT INTO engnoy_vpl VALUES ("JB5_2","019_5_2","JOB","5","2","2","Verily grief destroyeth the fool, And wrath consumeth the weak man. ");
INSERT INTO engnoy_vpl VALUES ("JB5_3","019_5_3","JOB","5","3","3","I have seen an impious man taking root, But soon I cursed his habitation. ");
INSERT INTO engnoy_vpl VALUES ("JB5_4","019_5_4","JOB","5","4","4","His children are far from safety; They are oppressed at the gate, and there is none to deliver them. ");
INSERT INTO engnoy_vpl VALUES ("JB5_5","019_5_5","JOB","5","5","5","His harvest the hungry devour, Carrying it even through the thorns; And a snare gapeth after his substance. ");
INSERT INTO engnoy_vpl VALUES ("JB5_6","019_5_6","JOB","5","6","6","For affliction cometh not from the dust, Nor doth trouble spring up from the ground; ");
INSERT INTO engnoy_vpl VALUES ("JB5_7","019_5_7","JOB","5","7","7","Behold, man is born to trouble, As the sparks fly upward. ");
INSERT INTO engnoy_vpl VALUES ("JB5_8","019_5_8","JOB","5","8","8","I would look to God, And to God would I commit my cause, ");
INSERT INTO engnoy_vpl VALUES ("JB5_9","019_5_9","JOB","5","9","9","Who doeth great things and unsearchable; Yea, marvellous things without number; ");
INSERT INTO engnoy_vpl VALUES ("JB5_10","019_5_10","JOB","5","10","10","Who giveth rain upon the earth, And sendeth water upon the fields; ");
INSERT INTO engnoy_vpl VALUES ("JB5_11","019_5_11","JOB","5","11","11","Who placeth the lowly in high places, And restoreth the afflicted to prosperity; ");
INSERT INTO engnoy_vpl VALUES ("JB5_12","019_5_12","JOB","5","12","12","Who disappointeth the devices of the crafty, So that their hands cannot perform their enterprises; ");
INSERT INTO engnoy_vpl VALUES ("JB5_13","019_5_13","JOB","5","13","13","Who taketh the wise in their own craftiness, And bringeth to nought the counsel of the artful. ");
INSERT INTO engnoy_vpl VALUES ("JB5_14","019_5_14","JOB","5","14","14","They meet with darkness in the daytime; They grope at noon as if it were night. ");
INSERT INTO engnoy_vpl VALUES ("JB5_15","019_5_15","JOB","5","15","15","So he saveth the persecuted from their mouth; The oppressed from the hand of the mighty. ");
INSERT INTO engnoy_vpl VALUES ("JB5_16","019_5_16","JOB","5","16","16","So the poor hath hope, And iniquity stoppeth her mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB5_17","019_5_17","JOB","5","17","17","Behold, happy is the man whom God correcteth; Therefore despise not thou the chastening of the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("JB5_18","019_5_18","JOB","5","18","18","For he bruiseth, and bindeth up; He woundeth, and his hands make whole. ");
INSERT INTO engnoy_vpl VALUES ("JB5_19","019_5_19","JOB","5","19","19","In six troubles will he deliver thee; Yea, in seven shall no evil touch thee. ");
INSERT INTO engnoy_vpl VALUES ("JB5_20","019_5_20","JOB","5","20","20","In famine he will redeem thee from death, And in war from the power of the sword. ");
INSERT INTO engnoy_vpl VALUES ("JB5_21","019_5_21","JOB","5","21","21","Thou shalt be safe from the scourge of the tongue, And shalt not be afraid of destruction, when it cometh. ");
INSERT INTO engnoy_vpl VALUES ("JB5_22","019_5_22","JOB","5","22","22","At destruction and famine thou shalt laugh, And of the wild beasts of the land shalt thou not be afraid. ");
INSERT INTO engnoy_vpl VALUES ("JB5_23","019_5_23","JOB","5","23","23","For thou shalt be in league with the stones of the field; Yea, the beasts of the forest shall be at peace with thee. ");
INSERT INTO engnoy_vpl VALUES ("JB5_24","019_5_24","JOB","5","24","24","Thou shalt find that thy tent is in peace; Thou shalt visit thy dwelling, and not be disappointed. ");
INSERT INTO engnoy_vpl VALUES ("JB5_25","019_5_25","JOB","5","25","25","Thou shalt see thy descendants numerous, And thine offspring as the grass of the earth. ");
INSERT INTO engnoy_vpl VALUES ("JB5_26","019_5_26","JOB","5","26","26","Thou shalt come to thy grave in full age, As a shock of corn gathered in its season. ");
INSERT INTO engnoy_vpl VALUES ("JB5_27","019_5_27","JOB","5","27","27","Lo! this we have searched out; so it is: Hear it, and lay it up in thy mind! ");
INSERT INTO engnoy_vpl VALUES ("JB6_1","019_6_1","JOB","6","1","1","Then Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB6_2","019_6_2","JOB","6","2","2","O that my grief were weighed thoroughly! That my calamities were put together in the balance! ");
INSERT INTO engnoy_vpl VALUES ("JB6_3","019_6_3","JOB","6","3","3","Surely they would be heavier than the sand of the sea; On this account were my words rash. ");
INSERT INTO engnoy_vpl VALUES ("JB6_4","019_6_4","JOB","6","4","4","For the arrows of the Almighty have pierced me; Their poison drinketh up my spirit; The terrors of God set themselves in array against me. ");
INSERT INTO engnoy_vpl VALUES ("JB6_5","019_6_5","JOB","6","5","5","Doth the wild ass bray in the midst of grass? Or loweth the ox over his fodder? ");
INSERT INTO engnoy_vpl VALUES ("JB6_6","019_6_6","JOB","6","6","6","Can that which is unsavory be eaten without salt? Is there any taste in the white of an egg? ");
INSERT INTO engnoy_vpl VALUES ("JB6_7","019_6_7","JOB","6","7","7","That which my soul abhorreth to touch Hath become my loathsome food. ");
INSERT INTO engnoy_vpl VALUES ("JB6_8","019_6_8","JOB","6","8","8","O that I might have my request, And that God would grant me that which I long for! ");
INSERT INTO engnoy_vpl VALUES ("JB6_9","019_6_9","JOB","6","9","9","That it would please God to destroy me; That he would let loose his hand, and make an end of me! ");
INSERT INTO engnoy_vpl VALUES ("JB6_10","019_6_10","JOB","6","10","10","Yet it should still be my consolation, Yea, in unsparing anguish I would exult, That I have not denied the commands of the Holy One. ");
INSERT INTO engnoy_vpl VALUES ("JB6_11","019_6_11","JOB","6","11","11","What is my strength, that I should hope? And what mine end, that I should be patient? ");
INSERT INTO engnoy_vpl VALUES ("JB6_12","019_6_12","JOB","6","12","12","Is my strength the strength of stones? Or is my flesh brass? ");
INSERT INTO engnoy_vpl VALUES ("JB6_13","019_6_13","JOB","6","13","13","Alas, there is no help within me! Deliverance is driven from me! ");
INSERT INTO engnoy_vpl VALUES ("JB6_14","019_6_14","JOB","6","14","14","To the afflicted, kindness should be shown by a friend; Else he casteth off the fear of the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("JB6_15","019_6_15","JOB","6","15","15","But my brethren are faithless like a brook; Like streams of the valley that pass away; ");
INSERT INTO engnoy_vpl VALUES ("JB6_16","019_6_16","JOB","6","16","16","Which are turbid by reason of the ice, And the snow, which hideth itself in them. ");
INSERT INTO engnoy_vpl VALUES ("JB6_17","019_6_17","JOB","6","17","17","As soon as they flow forth, they vanish; When the heat cometh, they are dried up from their place. ");
INSERT INTO engnoy_vpl VALUES ("JB6_18","019_6_18","JOB","6","18","18","The caravans turn aside to them on their way; They go up into the desert, and perish. ");
INSERT INTO engnoy_vpl VALUES ("JB6_19","019_6_19","JOB","6","19","19","The caravans of Tema look for them; The companies of Sheba expect to see them; ");
INSERT INTO engnoy_vpl VALUES ("JB6_20","019_6_20","JOB","6","20","20","They are ashamed that they have relied on them; They come to their place, and are confounded. ");
INSERT INTO engnoy_vpl VALUES ("JB6_21","019_6_21","JOB","6","21","21","So ye also are nothing; Ye see a terror, and shrink back. ");
INSERT INTO engnoy_vpl VALUES ("JB6_22","019_6_22","JOB","6","22","22","Have I said, Bring me gifts? Or, Give a present for me out of your substance? ");
INSERT INTO engnoy_vpl VALUES ("JB6_23","019_6_23","JOB","6","23","23","Or, Deliver me from the enemy's hand? Or, Rescue me from the hand of the violent? ");
INSERT INTO engnoy_vpl VALUES ("JB6_24","019_6_24","JOB","6","24","24","Convince me, and I will hold my peace; Cause me to understand wherein I have erred. ");
INSERT INTO engnoy_vpl VALUES ("JB6_25","019_6_25","JOB","6","25","25","How powerful are the words of truth! But what do your reproaches prove? ");
INSERT INTO engnoy_vpl VALUES ("JB6_26","019_6_26","JOB","6","26","26","Do ye mean to censure words? The words of a man in despair are but wind. ");
INSERT INTO engnoy_vpl VALUES ("JB6_27","019_6_27","JOB","6","27","27","Truly ye spread a net for the fatherless; Ye dig a pit for your friend. ");
INSERT INTO engnoy_vpl VALUES ("JB6_28","019_6_28","JOB","6","28","28","Look now upon me, I pray you; For to your very face can I speak falsehood? ");
INSERT INTO engnoy_vpl VALUES ("JB6_29","019_6_29","JOB","6","29","29","Return, I pray, and let there be no unfairness; Yea, return;—still is my cause righteous. ");
INSERT INTO engnoy_vpl VALUES ("JB6_30","019_6_30","JOB","6","30","30","Is there iniquity on my tongue? Cannot my taste discern what is sinful? ");
INSERT INTO engnoy_vpl VALUES ("JB7_1","019_7_1","JOB","7","1","1","Is there not a war-service for man on the earth? Are not his days as the days of a hireling? ");
INSERT INTO engnoy_vpl VALUES ("JB7_2","019_7_2","JOB","7","2","2","As a servant panteth for the shade, And as a hireling looketh for his wages, ");
INSERT INTO engnoy_vpl VALUES ("JB7_3","019_7_3","JOB","7","3","3","So am I made to possess months of affliction, And wearisome nights are appointed for me. ");
INSERT INTO engnoy_vpl VALUES ("JB7_4","019_7_4","JOB","7","4","4","If I lie down, I say, When shall I arise, and the night be gone? And I am full of restlessness until the dawning of the day. ");
INSERT INTO engnoy_vpl VALUES ("JB7_5","019_7_5","JOB","7","5","5","My flesh is clothed with worms, and clods of dust; My skin is broken and become loathsome. ");
INSERT INTO engnoy_vpl VALUES ("JB7_6","019_7_6","JOB","7","6","6","My days are swifter than a weaver's shuttle; They pass away without hope. ");
INSERT INTO engnoy_vpl VALUES ("JB7_7","019_7_7","JOB","7","7","7","O remember that my life is a breath; That mine eye shall no more see good! ");
INSERT INTO engnoy_vpl VALUES ("JB7_8","019_7_8","JOB","7","8","8","The eye of him that hath seen me shall see me no more; Thine eyes shall look for me, but I shall not be. ");
INSERT INTO engnoy_vpl VALUES ("JB7_9","019_7_9","JOB","7","9","9","As the cloud dissolveth and wasteth away, So he that goeth down to the grave shall arise no more; ");
INSERT INTO engnoy_vpl VALUES ("JB7_10","019_7_10","JOB","7","10","10","No more shall he return to his house, And his dwelling-place shall know him no more. ");
INSERT INTO engnoy_vpl VALUES ("JB7_11","019_7_11","JOB","7","11","11","Therefore I will not restrain my mouth; I will speak in the anguish of my spirit; I will complain in the bitterness of my soul. ");
INSERT INTO engnoy_vpl VALUES ("JB7_12","019_7_12","JOB","7","12","12","Am I a sea, or a sea-monster, That thou settest a watch over me? ");
INSERT INTO engnoy_vpl VALUES ("JB7_13","019_7_13","JOB","7","13","13","When I say, My bed shall relieve me, My couch shall ease my complaint, ");
INSERT INTO engnoy_vpl VALUES ("JB7_14","019_7_14","JOB","7","14","14","Then thou scarest me with dreams, And terrifiest me with visions; ");
INSERT INTO engnoy_vpl VALUES ("JB7_15","019_7_15","JOB","7","15","15","So that my soul chooseth strangling, Yea, death, rather than these my bones. ");
INSERT INTO engnoy_vpl VALUES ("JB7_16","019_7_16","JOB","7","16","16","I am wasting away; I shall not live alway: Let me alone, for my days are a vapor! ");
INSERT INTO engnoy_vpl VALUES ("JB7_17","019_7_17","JOB","7","17","17","What is man, that thou shouldst make great account him, And fix thy mind upon him?— ");
INSERT INTO engnoy_vpl VALUES ("JB7_18","019_7_18","JOB","7","18","18","That thou shouldst visit him every morning, And prove him every moment? ");
INSERT INTO engnoy_vpl VALUES ("JB7_19","019_7_19","JOB","7","19","19","How long ere thou wilt look away from me, And let me alone, till I have time to breathe? ");
INSERT INTO engnoy_vpl VALUES ("JB7_20","019_7_20","JOB","7","20","20","If I have sinned, what have I done to thee, O thou watcher of men! Why hast thou set me up as thy mark, So that I have become a burden to myself? ");
INSERT INTO engnoy_vpl VALUES ("JB7_21","019_7_21","JOB","7","21","21","And why dost thou not pardon my transgression, And take away mine iniquity? ((7:22)) For soon shall I sleep in the dust; And, though thou seek me diligently, I shall not be. ");
INSERT INTO engnoy_vpl VALUES ("JB8_1","019_8_1","JOB","8","1","1","Then answered Bildad the Shuhite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB8_2","019_8_2","JOB","8","2","2","How long wilt thou speak such things? How long shall the words of thy mouth be like a strong wind? ");
INSERT INTO engnoy_vpl VALUES ("JB8_3","019_8_3","JOB","8","3","3","Will God pervert judgment? Or will the Almighty pervert justice? ");
INSERT INTO engnoy_vpl VALUES ("JB8_4","019_8_4","JOB","8","4","4","As thy children sinned against him, He hath given them up to their transgression. ");
INSERT INTO engnoy_vpl VALUES ("JB8_5","019_8_5","JOB","8","5","5","But if thou wilt seek early to God, And make thy supplication to the Almighty,— ");
INSERT INTO engnoy_vpl VALUES ("JB8_6","019_8_6","JOB","8","6","6","If thou wilt be pure and upright, Surely he will yet arise for thee, And prosper thy righteous habitation; ");
INSERT INTO engnoy_vpl VALUES ("JB8_7","019_8_7","JOB","8","7","7","So that thy beginning shall be small, And thy latter end very great. ");
INSERT INTO engnoy_vpl VALUES ("JB8_8","019_8_8","JOB","8","8","8","For inquire, I pray thee, of the former age, And mark what hath been searched out by their fathers; ");
INSERT INTO engnoy_vpl VALUES ("JB8_9","019_8_9","JOB","8","9","9","(For we are of yesterday and know nothing, Since our days upon the earth are but a shadow;) ");
INSERT INTO engnoy_vpl VALUES ("JB8_10","019_8_10","JOB","8","10","10","Will not they instruct thee, and tell thee, And utter words from their understanding? ");
INSERT INTO engnoy_vpl VALUES ("JB8_11","019_8_11","JOB","8","11","11","“Can the paper-reed grow up without mire? Can the bulrush grow without water? ");
INSERT INTO engnoy_vpl VALUES ("JB8_12","019_8_12","JOB","8","12","12","While it is yet in its greenness, and is not cut down, It withereth before any other herb. ");
INSERT INTO engnoy_vpl VALUES ("JB8_13","019_8_13","JOB","8","13","13","Such is the fate of all who forget God; So perisheth the hope of the ungodly. ");
INSERT INTO engnoy_vpl VALUES ("JB8_14","019_8_14","JOB","8","14","14","His confidence shall come to nought, And his trust shall prove a spider's web. ");
INSERT INTO engnoy_vpl VALUES ("JB8_15","019_8_15","JOB","8","15","15","He shall lean upon his house, and it shall not stand; He shall lay fast hold on it, but it shall not endure. ");
INSERT INTO engnoy_vpl VALUES ("JB8_16","019_8_16","JOB","8","16","16","He is in full green before the sun, And his branches shoot forth over his garden; ");
INSERT INTO engnoy_vpl VALUES ("JB8_17","019_8_17","JOB","8","17","17","His roots are entwined about the heap, And he seeth the place of stones; ");
INSERT INTO engnoy_vpl VALUES ("JB8_18","019_8_18","JOB","8","18","18","When he shall be destroyed from his place, It shall deny him, saying, 'I never saw thee.' ");
INSERT INTO engnoy_vpl VALUES ("JB8_19","019_8_19","JOB","8","19","19","Lo! such is the joy of his course! And others shall spring up from his place” ");
INSERT INTO engnoy_vpl VALUES ("JB8_20","019_8_20","JOB","8","20","20","Behold, God will not cast away an upright man; Nor will he help the evil-doers. ");
INSERT INTO engnoy_vpl VALUES ("JB8_21","019_8_21","JOB","8","21","21","While he filleth thy mouth with laughter, And thy lips with gladness, ");
INSERT INTO engnoy_vpl VALUES ("JB8_22","019_8_22","JOB","8","22","22","They that hate thee shall be clothed with shame, And the dwelling-place of the wicked shall come to nought. ");
INSERT INTO engnoy_vpl VALUES ("JB9_1","019_9_1","JOB","9","1","1","Then Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB9_2","019_9_2","JOB","9","2","2","Of a truth, I know that it is so: For how can man be just before God? ");
INSERT INTO engnoy_vpl VALUES ("JB9_3","019_9_3","JOB","9","3","3","If he choose to contend with him, He cannot answer him to one charge of a thousand. ");
INSERT INTO engnoy_vpl VALUES ("JB9_4","019_9_4","JOB","9","4","4","He is excellent in wisdom, mighty in strength: Who hath hardened himself against him, and prospered? ");
INSERT INTO engnoy_vpl VALUES ("JB9_5","019_9_5","JOB","9","5","5","He removeth the mountains, and they know it not; He overturneth them in his anger. ");
INSERT INTO engnoy_vpl VALUES ("JB9_6","019_9_6","JOB","9","6","6","He shaketh the earth out of her place, And the pillars thereof tremble. ");
INSERT INTO engnoy_vpl VALUES ("JB9_7","019_9_7","JOB","9","7","7","He commandeth the sun, and it riseth not, And he sealeth up the stars. ");
INSERT INTO engnoy_vpl VALUES ("JB9_8","019_9_8","JOB","9","8","8","He alone spreadeth out the heavens, And walketh upon the high waves of the sea. ");
INSERT INTO engnoy_vpl VALUES ("JB9_9","019_9_9","JOB","9","9","9","He made the Bear, Orion, and the Pleiades, And the secret chambers of the South. ");
INSERT INTO engnoy_vpl VALUES ("JB9_10","019_9_10","JOB","9","10","10","He doeth great things past finding out, Yea, wonderful things without number. ");
INSERT INTO engnoy_vpl VALUES ("JB9_11","019_9_11","JOB","9","11","11","Lo! he goeth by me, but I see him not; He passeth along, but I do not perceive him. ");
INSERT INTO engnoy_vpl VALUES ("JB9_12","019_9_12","JOB","9","12","12","Lo! he seizeth, and who can hinder him? Who will say to him, What doest thou? ");
INSERT INTO engnoy_vpl VALUES ("JB9_13","019_9_13","JOB","9","13","13","God will not turn away his anger; The proud helpers are brought low before him. ");
INSERT INTO engnoy_vpl VALUES ("JB9_14","019_9_14","JOB","9","14","14","How much less shall I answer him, And choose out words to contend with him? ");
INSERT INTO engnoy_vpl VALUES ("JB9_15","019_9_15","JOB","9","15","15","Though I were innocent, I would not answer him; I would cast myself on the mercy of my judge. ");
INSERT INTO engnoy_vpl VALUES ("JB9_16","019_9_16","JOB","9","16","16","Should I call, and he make answer to me, I could not believe that he listened to my voice,— ");
INSERT INTO engnoy_vpl VALUES ("JB9_17","019_9_17","JOB","9","17","17","He who falleth upon me with a tempest, And multiplieth my wounds without cause! ");
INSERT INTO engnoy_vpl VALUES ("JB9_18","019_9_18","JOB","9","18","18","Who will not suffer me to take my breath, But filleth me with bitterness! ");
INSERT INTO engnoy_vpl VALUES ("JB9_19","019_9_19","JOB","9","19","19","If I look to strength, “Lo! here am I!” saith he, If to justice, “Who shall summon me to trial?” ");
INSERT INTO engnoy_vpl VALUES ("JB9_20","019_9_20","JOB","9","20","20","Though I were upright, yet must my own mouth condemn me; Though I were innocent, He would prove me perverse. ");
INSERT INTO engnoy_vpl VALUES ("JB9_21","019_9_21","JOB","9","21","21","Though I were innocent, I would not care for myself; I would despise my life. ");
INSERT INTO engnoy_vpl VALUES ("JB9_22","019_9_22","JOB","9","22","22","It is all one; therefore I will affirm, He destroyeth the righteous and the wicked alike. ");
INSERT INTO engnoy_vpl VALUES ("JB9_23","019_9_23","JOB","9","23","23","When the scourge bringeth sudden destruction, He laugheth at the sufferings of the innocent. ");
INSERT INTO engnoy_vpl VALUES ("JB9_24","019_9_24","JOB","9","24","24","The earth is given into the hands of the wicked; He covereth the face of the judges thereof; If it be not He, who is it? ");
INSERT INTO engnoy_vpl VALUES ("JB9_25","019_9_25","JOB","9","25","25","My days have been swifter than a courier; They have fled away; they have seen no good. ");
INSERT INTO engnoy_vpl VALUES ("JB9_26","019_9_26","JOB","9","26","26","They have gone by like the reed-skiffs; Like the eagle, darting upon his prey. ");
INSERT INTO engnoy_vpl VALUES ("JB9_27","019_9_27","JOB","9","27","27","If I say, I will forget my lamentation, I will change my countenance, and take courage, ");
INSERT INTO engnoy_vpl VALUES ("JB9_28","019_9_28","JOB","9","28","28","Still am I in dread of the multitude of my sorrows; For I know that thou wilt not hold me innocent. ");
INSERT INTO engnoy_vpl VALUES ("JB9_29","019_9_29","JOB","9","29","29","I shall be found guilty; Why then should I labor in vain? ");
INSERT INTO engnoy_vpl VALUES ("JB9_30","019_9_30","JOB","9","30","30","If I wash myself in snow, And cleanse my hands with lye, ");
INSERT INTO engnoy_vpl VALUES ("JB9_31","019_9_31","JOB","9","31","31","Still wilt thou plunge me into the pit, So that my own clothes will abhor me. ");
INSERT INTO engnoy_vpl VALUES ("JB9_32","019_9_32","JOB","9","32","32","For He is not a man, as I am, that I may contend with him, And that we may go together into judgment; ");
INSERT INTO engnoy_vpl VALUES ("JB9_33","019_9_33","JOB","9","33","33","There is no umpire between us, Who may lay his hand upon us both. ");
INSERT INTO engnoy_vpl VALUES ("JB9_34","019_9_34","JOB","9","34","34","Let him take from me his rod, And not dismay me with his terrors, ");
INSERT INTO engnoy_vpl VALUES ("JB9_35","019_9_35","JOB","9","35","35","Then I will speak, and not be afraid of him: For I am not so at heart. ");
INSERT INTO engnoy_vpl VALUES ("JB10_1","019_10_1","JOB","10","1","1","I am weary of my life; I will let loose within me my complaint; I will speak in the bitterness of my soul. ");
INSERT INTO engnoy_vpl VALUES ("JB10_2","019_10_2","JOB","10","2","2","I will say unto God, Do not condemn me! Show me wherefore thou contendest with me! ");
INSERT INTO engnoy_vpl VALUES ("JB10_3","019_10_3","JOB","10","3","3","Is it a pleasure to thee to oppress, And to despise the work of thy hands, And to shine upon the plans of the wicked? ");
INSERT INTO engnoy_vpl VALUES ("JB10_4","019_10_4","JOB","10","4","4","Hast thou eyes of flesh, Or seest thou as man seeth? ");
INSERT INTO engnoy_vpl VALUES ("JB10_5","019_10_5","JOB","10","5","5","Are thy days as the days of a man, Are thy years as the days of a mortal, ");
INSERT INTO engnoy_vpl VALUES ("JB10_6","019_10_6","JOB","10","6","6","That thou seekest after my iniquity, And searchest after my sin, ");
INSERT INTO engnoy_vpl VALUES ("JB10_7","019_10_7","JOB","10","7","7","Though thou knowest that I am not guilty, And that none can deliver from thy hand? ");
INSERT INTO engnoy_vpl VALUES ("JB10_8","019_10_8","JOB","10","8","8","Have thy hands completely fashioned and made me In every part, that thou mightst destroy me? ");
INSERT INTO engnoy_vpl VALUES ("JB10_9","019_10_9","JOB","10","9","9","O remember that thou hast moulded me as clay! And wilt thou bring me again to dust? ");
INSERT INTO engnoy_vpl VALUES ("JB10_10","019_10_10","JOB","10","10","10","Thou didst pour me out as milk, And curdle me as cheese; ");
INSERT INTO engnoy_vpl VALUES ("JB10_11","019_10_11","JOB","10","11","11","With skin and flesh didst thou clothe me, And strengthen me with bones and sinews; ");
INSERT INTO engnoy_vpl VALUES ("JB10_12","019_10_12","JOB","10","12","12","Thou didst grant me life and favor, And thy protection preserved my breath: ");
INSERT INTO engnoy_vpl VALUES ("JB10_13","019_10_13","JOB","10","13","13","Yet these things thou didst lay up in thy heart! I know that this was in thy mind. ");
INSERT INTO engnoy_vpl VALUES ("JB10_14","019_10_14","JOB","10","14","14","If I sin, then thou markest me, And wilt not acquit me of mine iniquity. ");
INSERT INTO engnoy_vpl VALUES ("JB10_15","019_10_15","JOB","10","15","15","If I am wicked,—then woe unto me! Yet if righteous, I dare not lift up my head; I am full of confusion, beholding my affliction. ");
INSERT INTO engnoy_vpl VALUES ("JB10_16","019_10_16","JOB","10","16","16","If I lift it up, like a lion thou huntest me, And again showest thyself terrible unto me. ");
INSERT INTO engnoy_vpl VALUES ("JB10_17","019_10_17","JOB","10","17","17","Thou renewest thy witnesses against me, And increasest thine anger toward me; New hosts continually rise up against me. ");
INSERT INTO engnoy_vpl VALUES ("JB10_18","019_10_18","JOB","10","18","18","Why then didst thou bring me forth from the womb? I should have perished, and no eye had seen me; ");
INSERT INTO engnoy_vpl VALUES ("JB10_19","019_10_19","JOB","10","19","19","I should be as though I had not been; I should have been borne from the womb to the grave. ");
INSERT INTO engnoy_vpl VALUES ("JB10_20","019_10_20","JOB","10","20","20","Are not my days few? O spare then, And let me alone, that I may be at ease a little while, ");
INSERT INTO engnoy_vpl VALUES ("JB10_21","019_10_21","JOB","10","21","21","Before I go— whence I shall not return—To the land of darkness and death-shade, ");
INSERT INTO engnoy_vpl VALUES ("JB10_22","019_10_22","JOB","10","22","22","The land of darkness like the blackness of death-shade, Where is no order, and where the light is as darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB11_1","019_11_1","JOB","11","1","1","Then answered Zophar the Naamathite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB11_2","019_11_2","JOB","11","2","2","Shall not the multitude of words receive an answer? Shall the man of words be justified? ");
INSERT INTO engnoy_vpl VALUES ("JB11_3","019_11_3","JOB","11","3","3","Shall thy boastings make men hold their peace? Shalt thou mock, and none put thee to shame? ");
INSERT INTO engnoy_vpl VALUES ("JB11_4","019_11_4","JOB","11","4","4","Thou sayest, My speech is pure; I am clean in thine eyes, O God! ");
INSERT INTO engnoy_vpl VALUES ("JB11_5","019_11_5","JOB","11","5","5","But O that God would speak, And open his lips against thee; ");
INSERT INTO engnoy_vpl VALUES ("JB11_6","019_11_6","JOB","11","6","6","That he would show thee the secrets of his wisdom,—His wisdom, which is unsearchable! Then shouldst thou know that God forgiveth thee many of thine iniquities. ");
INSERT INTO engnoy_vpl VALUES ("JB11_7","019_11_7","JOB","11","7","7","Canst thou search out the deep things of God? Canst thou find out the Almighty to perfection? ");
INSERT INTO engnoy_vpl VALUES ("JB11_8","019_11_8","JOB","11","8","8","'Tis high as heaven, what canst thou do? Deeper than hell, what canst thou know? ");
INSERT INTO engnoy_vpl VALUES ("JB11_9","019_11_9","JOB","11","9","9","The measure thereof is longer than the earth, And broader than the sea. ");
INSERT INTO engnoy_vpl VALUES ("JB11_10","019_11_10","JOB","11","10","10","If he apprehend, and bind, and bring to trial, Who shall oppose him? ");
INSERT INTO engnoy_vpl VALUES ("JB11_11","019_11_11","JOB","11","11","11","For he knoweth the unrighteous; He seeth iniquity, when they do not observe it. ");
INSERT INTO engnoy_vpl VALUES ("JB11_12","019_11_12","JOB","11","12","12","But vain man is without understanding; Yea, man is born a wild ass's colt. ");
INSERT INTO engnoy_vpl VALUES ("JB11_13","019_11_13","JOB","11","13","13","If thou direct thy heart, And stretch out thy hands, toward him; ");
INSERT INTO engnoy_vpl VALUES ("JB11_14","019_11_14","JOB","11","14","14","If thou put away iniquity from thy hand, And let not wickedness dwell in thy habitation,— ");
INSERT INTO engnoy_vpl VALUES ("JB11_15","019_11_15","JOB","11","15","15","Then shalt thou lift up thy face without spot; Yea, thou shalt be steadfast, and have no fear. ");
INSERT INTO engnoy_vpl VALUES ("JB11_16","019_11_16","JOB","11","16","16","For thou shalt forget thy misery, Or remember it as waters that have passed away. ");
INSERT INTO engnoy_vpl VALUES ("JB11_17","019_11_17","JOB","11","17","17","Thy life shall be brighter than the noon-day; Now thou art in darkness, thou shalt then be as morning. ");
INSERT INTO engnoy_vpl VALUES ("JB11_18","019_11_18","JOB","11","18","18","Thou shalt be secure, because there is hope; Now thou art disappointed, thou shalt then rest in safety. ");
INSERT INTO engnoy_vpl VALUES ("JB11_19","019_11_19","JOB","11","19","19","Thou shalt lie down, and none shall make thee afraid; And many shall make suit unto thee. ");
INSERT INTO engnoy_vpl VALUES ("JB11_20","019_11_20","JOB","11","20","20","But the eyes of the wicked shall be wearied out; They shall find no refuge; Their hope is—the breathing forth of life. ");
INSERT INTO engnoy_vpl VALUES ("JB12_1","019_12_1","JOB","12","1","1","Then Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB12_2","019_12_2","JOB","12","2","2","No doubt ye are the whole people! And wisdom will die with you! ");
INSERT INTO engnoy_vpl VALUES ("JB12_3","019_12_3","JOB","12","3","3","But I have understanding as well as you; I am not inferior to you: Yea, who knoweth not such things as these? ");
INSERT INTO engnoy_vpl VALUES ("JB12_4","019_12_4","JOB","12","4","4","I am become a laughing-stock to my friend,—I who call upon God, that he would answer me! The innocent and upright man is held in derision. ");
INSERT INTO engnoy_vpl VALUES ("JB12_5","019_12_5","JOB","12","5","5","To calamity belongeth contempt in the mind of one at ease; It is ready for them that slip with the feet. ");
INSERT INTO engnoy_vpl VALUES ("JB12_6","019_12_6","JOB","12","6","6","The tents of robbers are in prosperity, And they who provoke God are secure, Who carry their God in their hand. ");
INSERT INTO engnoy_vpl VALUES ("JB12_7","019_12_7","JOB","12","7","7","For ask now the beasts, and they will teach thee; Or the fowls of the air, and they will tell thee; ");
INSERT INTO engnoy_vpl VALUES ("JB12_8","019_12_8","JOB","12","8","8","Or speak to the earth, and it will instruct thee; And the fishes of the sea will declare unto thee. ");
INSERT INTO engnoy_vpl VALUES ("JB12_9","019_12_9","JOB","12","9","9","Who among all these doth not know That the hand of Jehovah doeth these things? ");
INSERT INTO engnoy_vpl VALUES ("JB12_10","019_12_10","JOB","12","10","10","In whose hand is the soul of every living thing, And the breath of all mankind. ");
INSERT INTO engnoy_vpl VALUES ("JB12_11","019_12_11","JOB","12","11","11","Doth not the ear prove words, As the mouth tasteth meat? ");
INSERT INTO engnoy_vpl VALUES ("JB12_12","019_12_12","JOB","12","12","12","With the aged is wisdom, And with length of days is understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB12_13","019_12_13","JOB","12","13","13","With Him are wisdom and strength; With Him counsel and understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB12_14","019_12_14","JOB","12","14","14","Lo! he pulleth down, and it shall not be rebuilt; He bindeth a man, and he shall not be set loose. ");
INSERT INTO engnoy_vpl VALUES ("JB12_15","019_12_15","JOB","12","15","15","Lo! he withholdeth the waters, and they are dried up; He sendeth them forth, and they lay waste the earth. ");
INSERT INTO engnoy_vpl VALUES ("JB12_16","019_12_16","JOB","12","16","16","With him are strength and wisdom; The deceived and the deceiver are his. ");
INSERT INTO engnoy_vpl VALUES ("JB12_17","019_12_17","JOB","12","17","17","He leadeth counsellors away captive, And judges he maketh fools. ");
INSERT INTO engnoy_vpl VALUES ("JB12_18","019_12_18","JOB","12","18","18","He looseth the authority of kings, And bindeth their loins with a cord. ");
INSERT INTO engnoy_vpl VALUES ("JB12_19","019_12_19","JOB","12","19","19","He leadeth priests away captive, And overthroweth the mighty. ");
INSERT INTO engnoy_vpl VALUES ("JB12_20","019_12_20","JOB","12","20","20","He removeth speech from the trusty, And taketh away judgment from the elders. ");
INSERT INTO engnoy_vpl VALUES ("JB12_21","019_12_21","JOB","12","21","21","He poureth contempt upon princes, And looseth the girdle of the mighty. ");
INSERT INTO engnoy_vpl VALUES ("JB12_22","019_12_22","JOB","12","22","22","He revealeth deep things out of darkness, And bringeth the shadow of death to light. ");
INSERT INTO engnoy_vpl VALUES ("JB12_23","019_12_23","JOB","12","23","23","He exalteth nations, and destroyeth them; He enlargeth nations, and leadeth them captive. ");
INSERT INTO engnoy_vpl VALUES ("JB12_24","019_12_24","JOB","12","24","24","He taketh away the understanding of the great men of the land, And causeth them to wander in a wilderness, where is no path; ");
INSERT INTO engnoy_vpl VALUES ("JB12_25","019_12_25","JOB","12","25","25","They grope in the dark without light; He maketh them stagger like a drunken man. ");
INSERT INTO engnoy_vpl VALUES ("JB13_1","019_13_1","JOB","13","1","1","Lo! all this mine eye hath seen; Mine ear hath heard and understood it. ");
INSERT INTO engnoy_vpl VALUES ("JB13_2","019_13_2","JOB","13","2","2","What ye know, I know also; I am not inferior to you. ");
INSERT INTO engnoy_vpl VALUES ("JB13_3","019_13_3","JOB","13","3","3","But O that I might speak with the Almighty! O that I might reason with God! ");
INSERT INTO engnoy_vpl VALUES ("JB13_4","019_13_4","JOB","13","4","4","For ye are forgers of lies; Physicians of no value, all of you! ");
INSERT INTO engnoy_vpl VALUES ("JB13_5","019_13_5","JOB","13","5","5","O that ye would altogether hold your peace! This, truly, would be wisdom in you. ");
INSERT INTO engnoy_vpl VALUES ("JB13_6","019_13_6","JOB","13","6","6","Hear, I pray you, my arguments; Attend to the pleadings of my lips! ");
INSERT INTO engnoy_vpl VALUES ("JB13_7","019_13_7","JOB","13","7","7","Will ye speak falsehood for God? Will ye utter deceit for him? ");
INSERT INTO engnoy_vpl VALUES ("JB13_8","019_13_8","JOB","13","8","8","Will ye be partial to his person? Will ye contend earnestly for God? ");
INSERT INTO engnoy_vpl VALUES ("JB13_9","019_13_9","JOB","13","9","9","Will it be well for you, if he search you thoroughly? Can ye deceive him, as one may deceive a man? ");
INSERT INTO engnoy_vpl VALUES ("JB13_10","019_13_10","JOB","13","10","10","Surely he will rebuke you, If ye secretly have respect to persons. ");
INSERT INTO engnoy_vpl VALUES ("JB13_11","019_13_11","JOB","13","11","11","Doth not his majesty make you afraid, And his dread fall upon you? ");
INSERT INTO engnoy_vpl VALUES ("JB13_12","019_13_12","JOB","13","12","12","Your maxims are words of dust; Your fortresses are fortresses of clay. ");
INSERT INTO engnoy_vpl VALUES ("JB13_13","019_13_13","JOB","13","13","13","Hold your peace, and let me speak: And then come upon me what will! ");
INSERT INTO engnoy_vpl VALUES ("JB13_14","019_13_14","JOB","13","14","14","Why do I take my flesh in my teeth, And put my life in my hand? ");
INSERT INTO engnoy_vpl VALUES ("JB13_15","019_13_15","JOB","13","15","15","Lo! he slayeth me, and I have no hope! Yet will I justify my ways before him. ");
INSERT INTO engnoy_vpl VALUES ("JB13_16","019_13_16","JOB","13","16","16","This also shall be my deliverance; For no unrighteous man will come before him. ");
INSERT INTO engnoy_vpl VALUES ("JB13_17","019_13_17","JOB","13","17","17","Hear attentively my words, And give ear to my declaration! ");
INSERT INTO engnoy_vpl VALUES ("JB13_18","019_13_18","JOB","13","18","18","Behold, I have now set in order my cause; I know that I am innocent. ");
INSERT INTO engnoy_vpl VALUES ("JB13_19","019_13_19","JOB","13","19","19","Who is he that can contend with me? For then would I hold my peace, and die! ");
INSERT INTO engnoy_vpl VALUES ("JB13_20","019_13_20","JOB","13","20","20","Only do not unto me two things, Then will I not hide myself from thy presence; ");
INSERT INTO engnoy_vpl VALUES ("JB13_21","019_13_21","JOB","13","21","21","Let not thy hand be heavy upon me, And let not thy terrors make me afraid: ");
INSERT INTO engnoy_vpl VALUES ("JB13_22","019_13_22","JOB","13","22","22","Then call upon me, and I will answer; Or I will speak, and answer thou me. ");
INSERT INTO engnoy_vpl VALUES ("JB13_23","019_13_23","JOB","13","23","23","How many are my iniquities and sins? Make me to know my faults and transgressions. ");
INSERT INTO engnoy_vpl VALUES ("JB13_24","019_13_24","JOB","13","24","24","Wherefore dost thou hide thy face, And account me as thine enemy? ");
INSERT INTO engnoy_vpl VALUES ("JB13_25","019_13_25","JOB","13","25","25","Wilt thou put in fear the driven leaf? Wilt thou pursue the dry stubble? ");
INSERT INTO engnoy_vpl VALUES ("JB13_26","019_13_26","JOB","13","26","26","For thou writest bitter things against me, And makest me inherit the sins of my youth. ");
INSERT INTO engnoy_vpl VALUES ("JB13_27","019_13_27","JOB","13","27","27","Yea, thou puttest my feet in the stocks, And waterest all my paths; Thou hemmest in the soles of my feet. ");
INSERT INTO engnoy_vpl VALUES ("JB13_28","019_13_28","JOB","13","28","28","And I, like an abandoned thing, shall waste away; Like a garment which is moth-eaten. ");
INSERT INTO engnoy_vpl VALUES ("JB14_1","019_14_1","JOB","14","1","1","Man, that is born of woman, Is of few days, and full of trouble. ");
INSERT INTO engnoy_vpl VALUES ("JB14_2","019_14_2","JOB","14","2","2","He cometh forth as a flower, and is cut down; He fleeth also as a shadow, and continueth not. ");
INSERT INTO engnoy_vpl VALUES ("JB14_3","019_14_3","JOB","14","3","3","And dost thou fix thine eyes upon such a one? And dost thou bring me into judgment with thee? ");
INSERT INTO engnoy_vpl VALUES ("JB14_4","019_14_4","JOB","14","4","4","Who can produce a clean thing from an unclean? Not one. ");
INSERT INTO engnoy_vpl VALUES ("JB14_5","019_14_5","JOB","14","5","5","Seeing that his days are determined, And the number of his months, with thee, And that thou hast appointed him bounds which he cannot pass, ");
INSERT INTO engnoy_vpl VALUES ("JB14_6","019_14_6","JOB","14","6","6","O turn thine eyes from him, and let him rest, That he may enjoy, as a hireling, his day! ");
INSERT INTO engnoy_vpl VALUES ("JB14_7","019_14_7","JOB","14","7","7","For there is hope for a tree, If it be cut down, that it will sprout again, And that its tender branches will not fail; ");
INSERT INTO engnoy_vpl VALUES ("JB14_8","019_14_8","JOB","14","8","8","Though its root may have grown old in the earth, And though its trunk be dead upon the ground, ");
INSERT INTO engnoy_vpl VALUES ("JB14_9","019_14_9","JOB","14","9","9","Through the scent of water it will bud, And put forth boughs, like a young plant. ");
INSERT INTO engnoy_vpl VALUES ("JB14_10","019_14_10","JOB","14","10","10","But man dieth, and he is gone! Man expireth, and where is he? ");
INSERT INTO engnoy_vpl VALUES ("JB14_11","019_14_11","JOB","14","11","11","The waters fail from the lake; And the stream wasteth and drieth up; ");
INSERT INTO engnoy_vpl VALUES ("JB14_12","019_14_12","JOB","14","12","12","So man lieth down, and riseth not; Till the heavens be no more, he shall not awake, Nor be roused from his sleep. ");
INSERT INTO engnoy_vpl VALUES ("JB14_13","019_14_13","JOB","14","13","13","O that thou wouldst hide me in the under-world! That thou wouldst conceal me till thy wrath be past! That thou wouldst appoint me a time, and then remember me! ");
INSERT INTO engnoy_vpl VALUES ("JB14_14","019_14_14","JOB","14","14","14","If a man die, can he live again? All the days of my war-service would I wait, Till my change should come. ");
INSERT INTO engnoy_vpl VALUES ("JB14_15","019_14_15","JOB","14","15","15","Thou wilt call, and I will answer thee; Thou wilt have compassion upon the work of thy hands! ");
INSERT INTO engnoy_vpl VALUES ("JB14_16","019_14_16","JOB","14","16","16","But now thou numberest my steps; Thou watchest over my sins. ");
INSERT INTO engnoy_vpl VALUES ("JB14_17","019_14_17","JOB","14","17","17","My transgression is sealed up in a bag; Yea, thou addest unto my iniquity. ");
INSERT INTO engnoy_vpl VALUES ("JB14_18","019_14_18","JOB","14","18","18","As the mountain falling cometh to nought, And the rock is removed from its place; ");
INSERT INTO engnoy_vpl VALUES ("JB14_19","019_14_19","JOB","14","19","19","As the waters wear away the stones, And the floods wash away the dust of the earth, So thou destroyest the hope of man. ");
INSERT INTO engnoy_vpl VALUES ("JB14_20","019_14_20","JOB","14","20","20","Thou prevailest against him continually, and he perisheth; Thou changest his countenance, and sendest him away. ");
INSERT INTO engnoy_vpl VALUES ("JB14_21","019_14_21","JOB","14","21","21","His sons come to honor, but he knoweth it not; Or they are brought low, but he perceiveth it not. ");
INSERT INTO engnoy_vpl VALUES ("JB14_22","019_14_22","JOB","14","22","22","But his flesh shall have pain for itself alone; For itself alone shall his soul mourn. ");
INSERT INTO engnoy_vpl VALUES ("JB15_1","019_15_1","JOB","15","1","1","Then answered Eliphaz the Temanite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB15_2","019_15_2","JOB","15","2","2","Should a wise man answer with arguments of wind, Or fill his bosom with the east wind? ");
INSERT INTO engnoy_vpl VALUES ("JB15_3","019_15_3","JOB","15","3","3","Should he argue with speech that helpeth him not, And with words which do not profit him? ");
INSERT INTO engnoy_vpl VALUES ("JB15_4","019_15_4","JOB","15","4","4","Behold, thou makest the fear of God a vain thing, And discouragest prayer before him. ");
INSERT INTO engnoy_vpl VALUES ("JB15_5","019_15_5","JOB","15","5","5","Yea, thy own mouth proclaimeth thy iniquity, Though thou choosest the tongue of the crafty. ");
INSERT INTO engnoy_vpl VALUES ("JB15_6","019_15_6","JOB","15","6","6","Thy own mouth condemneth thee, and not I; Thy own lips testify against thee. ");
INSERT INTO engnoy_vpl VALUES ("JB15_7","019_15_7","JOB","15","7","7","Art thou the first man that was born? Wast thou formed before the hills? ");
INSERT INTO engnoy_vpl VALUES ("JB15_8","019_15_8","JOB","15","8","8","Hast thou listened in the council of God, And drawn all wisdom to thyself? ");
INSERT INTO engnoy_vpl VALUES ("JB15_9","019_15_9","JOB","15","9","9","What dost thou know, that we know not also? What dost thou understand, that is a secret to us? ");
INSERT INTO engnoy_vpl VALUES ("JB15_10","019_15_10","JOB","15","10","10","With us are the aged and hoary-headed; Much older than thy father. ");
INSERT INTO engnoy_vpl VALUES ("JB15_11","019_15_11","JOB","15","11","11","Dost thou despise the consolations of God, And words so full of kindness to thee? ");
INSERT INTO engnoy_vpl VALUES ("JB15_12","019_15_12","JOB","15","12","12","Why hath thy passion taken possession of thee? And why this winking of thine eyes? ");
INSERT INTO engnoy_vpl VALUES ("JB15_13","019_15_13","JOB","15","13","13","For against God hast thou turned thy spirit, And uttered such words from thy mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB15_14","019_15_14","JOB","15","14","14","What is man, that he should be pure, And he that is born of woman, that he should be innocent? ");
INSERT INTO engnoy_vpl VALUES ("JB15_15","019_15_15","JOB","15","15","15","Behold, He putteth no trust in his ministering spirits, And the heavens are not pure in his sight; ");
INSERT INTO engnoy_vpl VALUES ("JB15_16","019_15_16","JOB","15","16","16","Much less, abominable and polluted man, Who drinketh iniquity as water. ");
INSERT INTO engnoy_vpl VALUES ("JB15_17","019_15_17","JOB","15","17","17","Hear me, and I will show thee, And that which I have seen will I declare; ");
INSERT INTO engnoy_vpl VALUES ("JB15_18","019_15_18","JOB","15","18","18","Which the wise men have told, And not kept concealed, as received from their fathers; ");
INSERT INTO engnoy_vpl VALUES ("JB15_19","019_15_19","JOB","15","19","19","To whom alone the land was given, And among whom not a stranger wandered. ");
INSERT INTO engnoy_vpl VALUES ("JB15_20","019_15_20","JOB","15","20","20","“All his days the wicked man is in pain; Yea, all the years, that are laid up for the oppressor. ");
INSERT INTO engnoy_vpl VALUES ("JB15_21","019_15_21","JOB","15","21","21","A fearful sound is in his ears; In peace the destroyer cometh upon him. ");
INSERT INTO engnoy_vpl VALUES ("JB15_22","019_15_22","JOB","15","22","22","He hath no hope that he shall escape from darkness; He is set apart for the sword. ");
INSERT INTO engnoy_vpl VALUES ("JB15_23","019_15_23","JOB","15","23","23","He wandereth about, seeking bread; He knoweth that a day of darkness is at hand. ");
INSERT INTO engnoy_vpl VALUES ("JB15_24","019_15_24","JOB","15","24","24","Distress and anguish fill him with dread; They prevail against him like a king ready for the battle. ");
INSERT INTO engnoy_vpl VALUES ("JB15_25","019_15_25","JOB","15","25","25","Because he stretched forth his hand against God, And bade defiance to the Almighty, ");
INSERT INTO engnoy_vpl VALUES ("JB15_26","019_15_26","JOB","15","26","26","And ran against him with outstretched neck, With the thick bosses of his bucklers; ");
INSERT INTO engnoy_vpl VALUES ("JB15_27","019_15_27","JOB","15","27","27","Because he covered his face with fatness, And gathered fat upon his loins, ");
INSERT INTO engnoy_vpl VALUES ("JB15_28","019_15_28","JOB","15","28","28","And dwelt in desolated cities, In houses which no man inhabiteth, That are ready to become heaps. ");
INSERT INTO engnoy_vpl VALUES ("JB15_29","019_15_29","JOB","15","29","29","He shall not be rich; his substance shall not endure, And his possessions shall not be extended upon the earth. ");
INSERT INTO engnoy_vpl VALUES ("JB15_30","019_15_30","JOB","15","30","30","He shall not escape from darkness, And the flame shall dry up his branches; Yea, by the breath of His mouth shall he be taken away. ");
INSERT INTO engnoy_vpl VALUES ("JB15_31","019_15_31","JOB","15","31","31","“Let not man trust in vanity! he will be deceived; For vanity shall be his recompense. ");
INSERT INTO engnoy_vpl VALUES ("JB15_32","019_15_32","JOB","15","32","32","He shall come to his end before his time, And his branch shall not be green. ");
INSERT INTO engnoy_vpl VALUES ("JB15_33","019_15_33","JOB","15","33","33","He shall shake off his unripe fruit like the vine, And shed his blossoms like the olive-tree. ");
INSERT INTO engnoy_vpl VALUES ("JB15_34","019_15_34","JOB","15","34","34","The house of the unrighteous shall be famished, And fire shall consume the tents of bribery. ");
INSERT INTO engnoy_vpl VALUES ("JB15_35","019_15_35","JOB","15","35","35","They conceive mischief, and bring forth misery, And their breast deviseth deceit.” ");
INSERT INTO engnoy_vpl VALUES ("JB16_1","019_16_1","JOB","16","1","1","But Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB16_2","019_16_2","JOB","16","2","2","Of such things as these I have heard enough! Miserable comforters are ye all! ");
INSERT INTO engnoy_vpl VALUES ("JB16_3","019_16_3","JOB","16","3","3","Will there ever be an end to words of wind? What stirreth thee up, that thou answerest? ");
INSERT INTO engnoy_vpl VALUES ("JB16_4","019_16_4","JOB","16","4","4","I also might speak like you, If ye were now in my place; I might string together words against you, And shake my head at you. ");
INSERT INTO engnoy_vpl VALUES ("JB16_5","019_16_5","JOB","16","5","5","I would strengthen you with my mouth, And the consolation of my lips should sustain you. ");
INSERT INTO engnoy_vpl VALUES ("JB16_6","019_16_6","JOB","16","6","6","If I speak, my grief is not assuaged; And if I forbear, it doth not leave me. ");
INSERT INTO engnoy_vpl VALUES ("JB16_7","019_16_7","JOB","16","7","7","For now He hath quite exhausted me; Thou hast desolated all my house! ");
INSERT INTO engnoy_vpl VALUES ("JB16_8","019_16_8","JOB","16","8","8","Thou hast seized hold of me, and this is a witness against me; My leanness riseth up and testifieth against me to my face. ");
INSERT INTO engnoy_vpl VALUES ("JB16_9","019_16_9","JOB","16","9","9","His anger teareth my flesh, and pursueth me; He gnasheth upon me with his teeth; My adversary sharpeneth his eyes upon me. ");
INSERT INTO engnoy_vpl VALUES ("JB16_10","019_16_10","JOB","16","10","10","They gape for me with their mouths; In scorn they smite me on the cheek; With one consent they assemble against me. ");
INSERT INTO engnoy_vpl VALUES ("JB16_11","019_16_11","JOB","16","11","11","God hath given me a prey to the unrighteous, And delivered me into the hands of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("JB16_12","019_16_12","JOB","16","12","12","I was at ease, but he hath crushed me; He hath seized me by the neck, and dashed me in pieces; He hath set me up for his mark. ");
INSERT INTO engnoy_vpl VALUES ("JB16_13","019_16_13","JOB","16","13","13","His archers encompass me around; He pierceth my reins, and doth not spare; He poureth out my gall upon the ground. ");
INSERT INTO engnoy_vpl VALUES ("JB16_14","019_16_14","JOB","16","14","14","He breaketh me with breach upon breach; He rusheth upon me like a warrior. ");
INSERT INTO engnoy_vpl VALUES ("JB16_15","019_16_15","JOB","16","15","15","I have sewed sackcloth upon my skin, And thrust my horn into the dust. ");
INSERT INTO engnoy_vpl VALUES ("JB16_16","019_16_16","JOB","16","16","16","My face is red with weeping, And upon my eyelids is deathlike darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB16_17","019_16_17","JOB","16","17","17","Yet is there no injustice in my bands. And my prayer hath been pure. ");
INSERT INTO engnoy_vpl VALUES ("JB16_18","019_16_18","JOB","16","18","18","O earth! cover not thou my blood, And let there be no hiding-place for my cry! ");
INSERT INTO engnoy_vpl VALUES ("JB16_19","019_16_19","JOB","16","19","19","Yet even now, behold, my witness is in heaven, And he who knoweth me is on high. ");
INSERT INTO engnoy_vpl VALUES ("JB16_20","019_16_20","JOB","16","20","20","My friends have me in derision, But my eye poureth out tears unto God. ");
INSERT INTO engnoy_vpl VALUES ("JB16_21","019_16_21","JOB","16","21","21","O that one might contend for a man with God, As a man contendeth with his neighbor! ");
INSERT INTO engnoy_vpl VALUES ("JB16_22","019_16_22","JOB","16","22","22","For when a few years shall have passed, I shall go the way whence I shall not return. ");
INSERT INTO engnoy_vpl VALUES ("JB17_1","019_17_1","JOB","17","1","1","My breath is exhausted; My days are at an end; The grave is ready for me. ");
INSERT INTO engnoy_vpl VALUES ("JB17_2","019_17_2","JOB","17","2","2","Are not revilers before me? And doth not my eye dwell upon their provocations? ");
INSERT INTO engnoy_vpl VALUES ("JB17_3","019_17_3","JOB","17","3","3","Give a pledge, I pray thee; be thou a surety for me with thee; Who is he that will strike hands with me? ");
INSERT INTO engnoy_vpl VALUES ("JB17_4","019_17_4","JOB","17","4","4","Behold, thou hast blinded their understanding; Therefore thou wilt not suffer them to prevail. ");
INSERT INTO engnoy_vpl VALUES ("JB17_5","019_17_5","JOB","17","5","5","He who delivereth up his friends as a prey,—The eyes of his children shall fail. ");
INSERT INTO engnoy_vpl VALUES ("JB17_6","019_17_6","JOB","17","6","6","He made me the by-word of the people; Yea, I have become their abhorrence. ");
INSERT INTO engnoy_vpl VALUES ("JB17_7","019_17_7","JOB","17","7","7","My eye therefore is dim with sorrow, And all my limbs are as a shadow. ");
INSERT INTO engnoy_vpl VALUES ("JB17_8","019_17_8","JOB","17","8","8","Upright men will be astonished at this, And the innocent will rouse themselves against the wicked. ");
INSERT INTO engnoy_vpl VALUES ("JB17_9","019_17_9","JOB","17","9","9","The righteous will also hold on his way, And he that hath clean hands will gather strength. ");
INSERT INTO engnoy_vpl VALUES ("JB17_10","019_17_10","JOB","17","10","10","But as for you all, return, I pray! I find not yet among you one wise man. ");
INSERT INTO engnoy_vpl VALUES ("JB17_11","019_17_11","JOB","17","11","11","My days are at an end; My plans are broken off; Even the treasures of my heart. ");
INSERT INTO engnoy_vpl VALUES ("JB17_12","019_17_12","JOB","17","12","12","Night hath become day to me; The light bordereth on darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB17_13","019_17_13","JOB","17","13","13","Yea, I look to the grave as my home; I have made my bed in darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB17_14","019_17_14","JOB","17","14","14","I say to the pit, Thou art my father! And to the worm, My mother! and, My sister! ");
INSERT INTO engnoy_vpl VALUES ("JB17_15","019_17_15","JOB","17","15","15","Where then is my hope? Yea, my hope, who shall see it? ");
INSERT INTO engnoy_vpl VALUES ("JB17_16","019_17_16","JOB","17","16","16","It must go down to the bars of the under-world, As soon as there is rest for me in the dust. ");
INSERT INTO engnoy_vpl VALUES ("JB18_1","019_18_1","JOB","18","1","1","Bildad the Shuhite answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB18_2","019_18_2","JOB","18","2","2","How long ere ye make an end of words? Understand, and then we will speak! ");
INSERT INTO engnoy_vpl VALUES ("JB18_3","019_18_3","JOB","18","3","3","Why are we accounted as brutes, And reputed vile in your sight? ");
INSERT INTO engnoy_vpl VALUES ("JB18_4","019_18_4","JOB","18","4","4","Thou that tearest thyself in thine anger! Must the earth be deserted for thee, And the rock removed from its place? ");
INSERT INTO engnoy_vpl VALUES ("JB18_5","019_18_5","JOB","18","5","5","Behold, the light of the wicked shall be put out, And the flame of his fire shall not shine. ");
INSERT INTO engnoy_vpl VALUES ("JB18_6","019_18_6","JOB","18","6","6","Light shall become darkness in his tent, And his lamp over him shall go out. ");
INSERT INTO engnoy_vpl VALUES ("JB18_7","019_18_7","JOB","18","7","7","His strong steps shall be straitened, And his own plans shall cast him down. ");
INSERT INTO engnoy_vpl VALUES ("JB18_8","019_18_8","JOB","18","8","8","He is brought into the net by his own feet, And he walketh upon snares. ");
INSERT INTO engnoy_vpl VALUES ("JB18_9","019_18_9","JOB","18","9","9","The trap layeth hold of him by the heel, And the snare holdeth him fast. ");
INSERT INTO engnoy_vpl VALUES ("JB18_10","019_18_10","JOB","18","10","10","A net is secretly laid for him on the ground, And a trap for him in the pathway. ");
INSERT INTO engnoy_vpl VALUES ("JB18_11","019_18_11","JOB","18","11","11","Terrors affright him on every side, And harass him at his heels. ");
INSERT INTO engnoy_vpl VALUES ("JB18_12","019_18_12","JOB","18","12","12","His strength is wasted by hunger, And destruction is ready at his side. ");
INSERT INTO engnoy_vpl VALUES ("JB18_13","019_18_13","JOB","18","13","13","His limbs are consumed, Yea, his limbs are devoured by the first-born of death. ");
INSERT INTO engnoy_vpl VALUES ("JB18_14","019_18_14","JOB","18","14","14","He is torn from his tent, which was his confidence, And is borne away to the king of terrors. ");
INSERT INTO engnoy_vpl VALUES ("JB18_15","019_18_15","JOB","18","15","15","They who are none of his shall dwell in his tent; Brimstone shall be scattered upon his habitation. ");
INSERT INTO engnoy_vpl VALUES ("JB18_16","019_18_16","JOB","18","16","16","His roots below shall be dried up, And his branches above shall be withered. ");
INSERT INTO engnoy_vpl VALUES ("JB18_17","019_18_17","JOB","18","17","17","His memory perisheth from the earth, And no name hath he in the land. ");
INSERT INTO engnoy_vpl VALUES ("JB18_18","019_18_18","JOB","18","18","18","He shall be thrust from light into darkness, And driven out of the world. ");
INSERT INTO engnoy_vpl VALUES ("JB18_19","019_18_19","JOB","18","19","19","He hath no son, nor kinsman among his people, Nor any survivor in his dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("JB18_20","019_18_20","JOB","18","20","20","They that come after him shall be amazed at his fate, As they that were before them were struck with horror. ");
INSERT INTO engnoy_vpl VALUES ("JB18_21","019_18_21","JOB","18","21","21","Yea, such is the dwelling of the unrighteous man; Such is the place of him who knoweth not God! ");
INSERT INTO engnoy_vpl VALUES ("JB19_1","019_19_1","JOB","19","1","1","But Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB19_2","019_19_2","JOB","19","2","2","How long will ye vex my soul, And break me in pieces with words? ");
INSERT INTO engnoy_vpl VALUES ("JB19_3","019_19_3","JOB","19","3","3","These ten times have ye reviled me; Without shame do ye stun me! ");
INSERT INTO engnoy_vpl VALUES ("JB19_4","019_19_4","JOB","19","4","4","And be it, indeed, that I have erred, My error abideth with myself. ");
INSERT INTO engnoy_vpl VALUES ("JB19_5","019_19_5","JOB","19","5","5","Since, indeed, ye magnify yourselves against me, And plead against me my reproach, ");
INSERT INTO engnoy_vpl VALUES ("JB19_6","019_19_6","JOB","19","6","6","Know then that it is God who hath brought me low; He hath encompassed me with his net. ");
INSERT INTO engnoy_vpl VALUES ("JB19_7","019_19_7","JOB","19","7","7","Behold, I complain of wrong, but receive no answer; I cry aloud, but obtain no justice. ");
INSERT INTO engnoy_vpl VALUES ("JB19_8","019_19_8","JOB","19","8","8","He hath fenced up my way, so that I cannot pass, And hath set darkness in my paths. ");
INSERT INTO engnoy_vpl VALUES ("JB19_9","019_19_9","JOB","19","9","9","He hath stripped me of my glory, And taken the crown from my head. ");
INSERT INTO engnoy_vpl VALUES ("JB19_10","019_19_10","JOB","19","10","10","He hath destroyed me on every side, and I am gone! He hath torn up my hope like a tree. ");
INSERT INTO engnoy_vpl VALUES ("JB19_11","019_19_11","JOB","19","11","11","He kindleth his anger against me, And counteth me as his enemy. ");
INSERT INTO engnoy_vpl VALUES ("JB19_12","019_19_12","JOB","19","12","12","His troops advance together against me; They throw up for themselves a way to me, And encamp around my dwelling. ");
INSERT INTO engnoy_vpl VALUES ("JB19_13","019_19_13","JOB","19","13","13","My brethren he hath put far from me, And my acquaintance are wholly estranged from me. ");
INSERT INTO engnoy_vpl VALUES ("JB19_14","019_19_14","JOB","19","14","14","My kinsfolk have forsaken me, And my bosom friends have forgotten me. ");
INSERT INTO engnoy_vpl VALUES ("JB19_15","019_19_15","JOB","19","15","15","The foreigners of my house, yea, my own maid-servants, regard me as a stranger; I am an alien in their eyes. ");
INSERT INTO engnoy_vpl VALUES ("JB19_16","019_19_16","JOB","19","16","16","I call my servant, and he maketh no answer; With my own mouth do I entreat him. ");
INSERT INTO engnoy_vpl VALUES ("JB19_17","019_19_17","JOB","19","17","17","My breath is become strange to my wife, And my prayers also to my own mother's sons. ");
INSERT INTO engnoy_vpl VALUES ("JB19_18","019_19_18","JOB","19","18","18","Even young children despise me; When I rise up, they speak against me. ");
INSERT INTO engnoy_vpl VALUES ("JB19_19","019_19_19","JOB","19","19","19","All my bosom friends abhor me, And they whom I loved are turned against me. ");
INSERT INTO engnoy_vpl VALUES ("JB19_20","019_19_20","JOB","19","20","20","My bones cleave to my flesh and my skin, And I have scarcely escaped with the skin of my teeth. ");
INSERT INTO engnoy_vpl VALUES ("JB19_21","019_19_21","JOB","19","21","21","Have pity upon me, O ye my friends! have pity upon me; For the hand of God hath smitten me! ");
INSERT INTO engnoy_vpl VALUES ("JB19_22","019_19_22","JOB","19","22","22","Why do ye persecute me like God, And are not satisfied with my flesh? ");
INSERT INTO engnoy_vpl VALUES ("JB19_23","019_19_23","JOB","19","23","23","O that my words were now written! O that they were marked down in a scroll! ");
INSERT INTO engnoy_vpl VALUES ("JB19_24","019_19_24","JOB","19","24","24","That with an iron pen, and with lead, They were engraven upon the rock for ever! ");
INSERT INTO engnoy_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","25","Yet I know that my Vindicator liveth, And will hereafter stand up on the earth; ");
INSERT INTO engnoy_vpl VALUES ("JB19_26","019_19_26","JOB","19","26","26","And though with my skin this body be wasted away, Yet without my flesh shall I see God. ");
INSERT INTO engnoy_vpl VALUES ("JB19_27","019_19_27","JOB","19","27","27","Yea, I shall see him my friend; My eyes shall behold him, and not another: For this, my soul panteth within me. ");
INSERT INTO engnoy_vpl VALUES ("JB19_28","019_19_28","JOB","19","28","28","Since ye say, “How may we persecute him, And find grounds of accusation against him?” ");
INSERT INTO engnoy_vpl VALUES ("JB19_29","019_19_29","JOB","19","29","29","Be ye afraid of the sword! For malice is a crime for the sword; That ye may know that judgment cometh. ");
INSERT INTO engnoy_vpl VALUES ("JB20_1","019_20_1","JOB","20","1","1","Then answered Zophar the Naamathite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB20_2","019_20_2","JOB","20","2","2","For this do my thoughts lead me to reply, And for this is my ardor within me. ");
INSERT INTO engnoy_vpl VALUES ("JB20_3","019_20_3","JOB","20","3","3","I have heard my shameful rebuke; And the spirit, from my understanding, answereth for me. ");
INSERT INTO engnoy_vpl VALUES ("JB20_4","019_20_4","JOB","20","4","4","Knowest thou not, that from the days of old, From the time when man was placed upon the earth, ");
INSERT INTO engnoy_vpl VALUES ("JB20_5","019_20_5","JOB","20","5","5","The triumphing of the wicked hath been short, And the joy of the impious but for a moment? ");
INSERT INTO engnoy_vpl VALUES ("JB20_6","019_20_6","JOB","20","6","6","Though his greatness mount up to the heavens, And his head reach to the clouds, ");
INSERT INTO engnoy_vpl VALUES ("JB20_7","019_20_7","JOB","20","7","7","Yet shall he perish for ever, and be mingled with dust; They who saw him shall say, Where is he? ");
INSERT INTO engnoy_vpl VALUES ("JB20_8","019_20_8","JOB","20","8","8","He shall flee away like a dream, and shall not be found; Yea, he shall disappear like a vision of the nigh. ");
INSERT INTO engnoy_vpl VALUES ("JB20_9","019_20_9","JOB","20","9","9","The eye also which saw him shall see him no more, And his dwelling-place shall never more behold him. ");
INSERT INTO engnoy_vpl VALUES ("JB20_10","019_20_10","JOB","20","10","10","His sons shall seek the favor of the poor, And their hands shall give back his wealth. ");
INSERT INTO engnoy_vpl VALUES ("JB20_11","019_20_11","JOB","20","11","11","His bones are full of his youth, But they shall lie down with him in the dust. ");
INSERT INTO engnoy_vpl VALUES ("JB20_12","019_20_12","JOB","20","12","12","Though wickedness be sweet in his mouth, Though he hide it under his tongue, ");
INSERT INTO engnoy_vpl VALUES ("JB20_13","019_20_13","JOB","20","13","13","Though he cherish it, and will not part with it, And keep it fast in his mouth, ");
INSERT INTO engnoy_vpl VALUES ("JB20_14","019_20_14","JOB","20","14","14","Yet his meat shall be changed within him, And become to him the poison of asps. ");
INSERT INTO engnoy_vpl VALUES ("JB20_15","019_20_15","JOB","20","15","15","He hath glutted himself with riches, And he shall throw them up again; Yea, God shall cast them out of his body. ");
INSERT INTO engnoy_vpl VALUES ("JB20_16","019_20_16","JOB","20","16","16","He shall suck the poison of asps; The tongue of the viper shall destroy him. ");
INSERT INTO engnoy_vpl VALUES ("JB20_17","019_20_17","JOB","20","17","17","He shall never see the flowing streams, And the rivers of honey and milk. ");
INSERT INTO engnoy_vpl VALUES ("JB20_18","019_20_18","JOB","20","18","18","The fruits of his toil he shall give back, and shall not enjoy them: It is substance to be restored, and he shall not rejoice therein. ");
INSERT INTO engnoy_vpl VALUES ("JB20_19","019_20_19","JOB","20","19","19","Because he hath oppressed and abandoned the poor, And seized upon the house which he did not build; ");
INSERT INTO engnoy_vpl VALUES ("JB20_20","019_20_20","JOB","20","20","20","Because he knew no rest in his bosom, He shall not save that in which he delighteth. ");
INSERT INTO engnoy_vpl VALUES ("JB20_21","019_20_21","JOB","20","21","21","Because nothing escaped his greediness, His prosperity shall not endure. ");
INSERT INTO engnoy_vpl VALUES ("JB20_22","019_20_22","JOB","20","22","22","In the fulness of his abundance he shall be brought low; Every hand of the wretched shall come upon him. ");
INSERT INTO engnoy_vpl VALUES ("JB20_23","019_20_23","JOB","20","23","23","He shall, indeed, have wherewith to fill himself: God shall send upon him the fury of his anger, And rain it down upon him for his food. ");
INSERT INTO engnoy_vpl VALUES ("JB20_24","019_20_24","JOB","20","24","24","If he fleeth from the iron weapon, The bow of brass shall pierce him through. ");
INSERT INTO engnoy_vpl VALUES ("JB20_25","019_20_25","JOB","20","25","25","He draweth the arrow, and it cometh forth from his body; Yea, the glittering steel cometh out of his gall. Terrors are upon him; ");
INSERT INTO engnoy_vpl VALUES ("JB20_26","019_20_26","JOB","20","26","26","Calamity of every kind is treasured up for him. A fire not blown shall consume him; It shall consume whatever is left in his tent. ");
INSERT INTO engnoy_vpl VALUES ("JB20_27","019_20_27","JOB","20","27","27","The heavens shall reveal his iniquity, And the earth shall rise up against him. ");
INSERT INTO engnoy_vpl VALUES ("JB20_28","019_20_28","JOB","20","28","28","The substance of his house shall disappear; It shall flow away in the day of His wrath. ");
INSERT INTO engnoy_vpl VALUES ("JB20_29","019_20_29","JOB","20","29","29","Such is the portion of the wicked man from God, And the inheritance appointed for him by the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("JB21_1","019_21_1","JOB","21","1","1","But Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB21_2","019_21_2","JOB","21","2","2","Hear attentively my words, And let this be your consolation. ");
INSERT INTO engnoy_vpl VALUES ("JB21_3","019_21_3","JOB","21","3","3","Bear with me, that I may speak; And after I have spoken, mock on! ");
INSERT INTO engnoy_vpl VALUES ("JB21_4","019_21_4","JOB","21","4","4","Is my complaint concerning man? Why then should I not be angry? ");
INSERT INTO engnoy_vpl VALUES ("JB21_5","019_21_5","JOB","21","5","5","Look upon me, and be astonished, And lay your hand upon your mouth! ");
INSERT INTO engnoy_vpl VALUES ("JB21_6","019_21_6","JOB","21","6","6","When I think of it, I am confounded; Trembling taketh hold of my flesh. ");
INSERT INTO engnoy_vpl VALUES ("JB21_7","019_21_7","JOB","21","7","7","Why is it that the wicked live, Grow old, yea, become mighty in substance? ");
INSERT INTO engnoy_vpl VALUES ("JB21_8","019_21_8","JOB","21","8","8","Their children are established in their sight with them, And their offspring before their eyes. ");
INSERT INTO engnoy_vpl VALUES ("JB21_9","019_21_9","JOB","21","9","9","Their houses are in peace, without fear, And the rod of God cometh not upon them. ");
INSERT INTO engnoy_vpl VALUES ("JB21_10","019_21_10","JOB","21","10","10","Their bull gendereth, and faileth not; Their cow calveth, and casteth not her calf. ");
INSERT INTO engnoy_vpl VALUES ("JB21_11","019_21_11","JOB","21","11","11","They send forth their little ones like a flock, And their children dance. ");
INSERT INTO engnoy_vpl VALUES ("JB21_12","019_21_12","JOB","21","12","12","They sing to the timbrel and harp, And rejoice at the sound of the pipe. ");
INSERT INTO engnoy_vpl VALUES ("JB21_13","019_21_13","JOB","21","13","13","They spend their days in prosperity, And in a moment go down to the under-world. ");
INSERT INTO engnoy_vpl VALUES ("JB21_14","019_21_14","JOB","21","14","14","And yet they say unto God, “Depart from us! We desire not the knowledge of thy ways! ");
INSERT INTO engnoy_vpl VALUES ("JB21_15","019_21_15","JOB","21","15","15","Who is the Almighty, that we should serve him? And what will it profit us, if we pray to him?” ");
INSERT INTO engnoy_vpl VALUES ("JB21_16","019_21_16","JOB","21","16","16","Ye say, “Lo! their prosperity is not secure in their hands! Far from me be the conduct of the wicked!” ");
INSERT INTO engnoy_vpl VALUES ("JB21_17","019_21_17","JOB","21","17","17","How often is it, that the lamp of the wicked is put out? And that destruction cometh upon them, And that He dispenseth to them tribulations in his anger? ");
INSERT INTO engnoy_vpl VALUES ("JB21_18","019_21_18","JOB","21","18","18","How often are they as stubble before the wind, Or as chaff, which the whirlwind carrieth away? ");
INSERT INTO engnoy_vpl VALUES ("JB21_19","019_21_19","JOB","21","19","19","“But” say ye “God layeth up his iniquity for his children.” Let him requite the offender, and let him feel it! ");
INSERT INTO engnoy_vpl VALUES ("JB21_20","019_21_20","JOB","21","20","20","Let his own eyes see his destruction, And let him drink of the wrath of the Almighty! ");
INSERT INTO engnoy_vpl VALUES ("JB21_21","019_21_21","JOB","21","21","21","For what concern hath he for his household after him, When the number of his own months is completed? ");
INSERT INTO engnoy_vpl VALUES ("JB21_22","019_21_22","JOB","21","22","22","Who then shall impart knowledge to God,—To him that judgeth the highest? ");
INSERT INTO engnoy_vpl VALUES ("JB21_23","019_21_23","JOB","21","23","23","One dieth in the fulness of his prosperity, Being wholly at ease and quiet; ");
INSERT INTO engnoy_vpl VALUES ("JB21_24","019_21_24","JOB","21","24","24","His sides are full of fat, And his bones moist with marrow. ");
INSERT INTO engnoy_vpl VALUES ("JB21_25","019_21_25","JOB","21","25","25","Another dieth in bitterness of soul, And hath not tasted pleasure. ");
INSERT INTO engnoy_vpl VALUES ("JB21_26","019_21_26","JOB","21","26","26","Alike they lie down in the dust, And the worms cover them. ");
INSERT INTO engnoy_vpl VALUES ("JB21_27","019_21_27","JOB","21","27","27","Behold, I know your thoughts, And the devices by which ye wrong me. ");
INSERT INTO engnoy_vpl VALUES ("JB21_28","019_21_28","JOB","21","28","28","For ye say, “Where is the house of the oppressor, And where the dwelling-places of the wicked?” ");
INSERT INTO engnoy_vpl VALUES ("JB21_29","019_21_29","JOB","21","29","29","Have ye never inquired of travellers, And do ye not know their tokens, ");
INSERT INTO engnoy_vpl VALUES ("JB21_30","019_21_30","JOB","21","30","30","That the wicked is spared in the day of destruction, And that he is borne to his grave in the day of wrath? ");
INSERT INTO engnoy_vpl VALUES ("JB21_31","019_21_31","JOB","21","31","31","Who will charge him with his conduct to his face, And who will requite him for the evil he hath done? ");
INSERT INTO engnoy_vpl VALUES ("JB21_32","019_21_32","JOB","21","32","32","Even this man is borne with honor to the grave; Yea, he watcheth over his tomb. ");
INSERT INTO engnoy_vpl VALUES ("JB21_33","019_21_33","JOB","21","33","33","Sweet to him are the sods of the valley: And all men move after him, As multitudes without number before him. ");
INSERT INTO engnoy_vpl VALUES ("JB21_34","019_21_34","JOB","21","34","34","Why then do ye offer your vain consolations? Your answers continue false. ");
INSERT INTO engnoy_vpl VALUES ("JB22_1","019_22_1","JOB","22","1","1","Then Eliphaz the Temanite answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB22_2","019_22_2","JOB","22","2","2","Can a man, then, profit God? Behold, the wise man profiteth himself. ");
INSERT INTO engnoy_vpl VALUES ("JB22_3","019_22_3","JOB","22","3","3","Is it a pleasure to the Almighty, that thou art righteous; Or a gain to him, that thou walkest uprightly? ");
INSERT INTO engnoy_vpl VALUES ("JB22_4","019_22_4","JOB","22","4","4","Will he contend with thee because he feareth thee? Will he enter with thee into judgment? ");
INSERT INTO engnoy_vpl VALUES ("JB22_5","019_22_5","JOB","22","5","5","Hath not thy wickedness been great? Have not thine iniquities been numberless? ");
INSERT INTO engnoy_vpl VALUES ("JB22_6","019_22_6","JOB","22","6","6","For thou hast taken a pledge from thy brother unjustly, And stripped the poor of their clothing. ");
INSERT INTO engnoy_vpl VALUES ("JB22_7","019_22_7","JOB","22","7","7","Thou hast given the weary no water to drink, And withholden bread from the hungry. ");
INSERT INTO engnoy_vpl VALUES ("JB22_8","019_22_8","JOB","22","8","8","But the man of power, his was the land, And the honorable man dwelt in it. ");
INSERT INTO engnoy_vpl VALUES ("JB22_9","019_22_9","JOB","22","9","9","Thou hast sent widows away empty, And broken the arms of the fatherless. ");
INSERT INTO engnoy_vpl VALUES ("JB22_10","019_22_10","JOB","22","10","10","Therefore snares are round about thee, And sudden fear confoundeth thee; ");
INSERT INTO engnoy_vpl VALUES ("JB22_11","019_22_11","JOB","22","11","11","Or darkness, through which thou canst not see, And floods of water cover thee. ");
INSERT INTO engnoy_vpl VALUES ("JB22_12","019_22_12","JOB","22","12","12","Is not God in the height of heaven? And behold the stars, how high they are! ");
INSERT INTO engnoy_vpl VALUES ("JB22_13","019_22_13","JOB","22","13","13","Hence thou sayest, “What doth God know? Can he govern behind the thick darkness? ");
INSERT INTO engnoy_vpl VALUES ("JB22_14","019_22_14","JOB","22","14","14","Dark clouds are a veil to him, and he cannot see; And he walketh upon the arch of heaven.” ");
INSERT INTO engnoy_vpl VALUES ("JB22_15","019_22_15","JOB","22","15","15","Wilt thou take the old way Which wicked men have trodden, ");
INSERT INTO engnoy_vpl VALUES ("JB22_16","019_22_16","JOB","22","16","16","Who were cut down before their time, And whose foundations were swept away by a flood? ");
INSERT INTO engnoy_vpl VALUES ("JB22_17","019_22_17","JOB","22","17","17","Who said unto God, “Depart from us!” And, “What can the Almighty do to us?” ");
INSERT INTO engnoy_vpl VALUES ("JB22_18","019_22_18","JOB","22","18","18","And yet he filled their houses with good things!—Far from me be the counsel of the wicked! ");
INSERT INTO engnoy_vpl VALUES ("JB22_19","019_22_19","JOB","22","19","19","The righteous see their fate, and rejoice; And the innocent hold them in derision. ");
INSERT INTO engnoy_vpl VALUES ("JB22_20","019_22_20","JOB","22","20","20","“Truly our adversary is destroyed, And fire hath consumed his abundance!” ");
INSERT INTO engnoy_vpl VALUES ("JB22_21","019_22_21","JOB","22","21","21","Acquaint now thyself with him, and be at peace: Thus shall prosperity return to thee. ");
INSERT INTO engnoy_vpl VALUES ("JB22_22","019_22_22","JOB","22","22","22","Receive, I pray thee, instruction from his mouth, And lay up his words in thy heart. ");
INSERT INTO engnoy_vpl VALUES ("JB22_23","019_22_23","JOB","22","23","23","If thou return to the Almighty, thou shalt be built up; If thou put away iniquity from thy tent. ");
INSERT INTO engnoy_vpl VALUES ("JB22_24","019_22_24","JOB","22","24","24","Cast to the dust thy gold, And the gold of Ophir to the stones of the brook: ");
INSERT INTO engnoy_vpl VALUES ("JB22_25","019_22_25","JOB","22","25","25","Then shall the Almighty be thy gold, Yea, treasures of silver unto thee; ");
INSERT INTO engnoy_vpl VALUES ("JB22_26","019_22_26","JOB","22","26","26","For then shalt thou have delight in the Almighty, And shalt lift up thy face unto God. ");
INSERT INTO engnoy_vpl VALUES ("JB22_27","019_22_27","JOB","22","27","27","Thou shalt pray to him, and he shall hear thee, And thou shalt perform thy vows. ");
INSERT INTO engnoy_vpl VALUES ("JB22_28","019_22_28","JOB","22","28","28","The purpose which thou formest shall prosper with thee, And light shall shine upon thy ways. ");
INSERT INTO engnoy_vpl VALUES ("JB22_29","019_22_29","JOB","22","29","29","When men are cast down, thou shalt say, “There lifting up!” And the humble person he will save. ");
INSERT INTO engnoy_vpl VALUES ("JB22_30","019_22_30","JOB","22","30","30","He will deliver even him that is not innocent. The purity of thy hands shall save him. ");
INSERT INTO engnoy_vpl VALUES ("JB23_1","019_23_1","JOB","23","1","1","Then Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB23_2","019_23_2","JOB","23","2","2","Still is my complaint bitter; But my wound is deeper than my groaning. ");
INSERT INTO engnoy_vpl VALUES ("JB23_3","019_23_3","JOB","23","3","3","O that I knew where I might find him! That I might go before his throne! ");
INSERT INTO engnoy_vpl VALUES ("JB23_4","019_23_4","JOB","23","4","4","I would order my cause before him, And fill my mouth with arguments; ");
INSERT INTO engnoy_vpl VALUES ("JB23_5","019_23_5","JOB","23","5","5","I should know what he would answer me, And understand what he would say to me. ");
INSERT INTO engnoy_vpl VALUES ("JB23_6","019_23_6","JOB","23","6","6","Would he contend with me with his mighty power? No! he would have regard to me. ");
INSERT INTO engnoy_vpl VALUES ("JB23_7","019_23_7","JOB","23","7","7","Then would an upright man contend with him, And I should be fully acquitted by my judge. ");
INSERT INTO engnoy_vpl VALUES ("JB23_8","019_23_8","JOB","23","8","8","But, behold, I go eastward, and he is not there; And westward, but I cannot perceive him; ");
INSERT INTO engnoy_vpl VALUES ("JB23_9","019_23_9","JOB","23","9","9","To the north, where he worketh, but I cannot behold him; He hideth himself on the south, and I cannot see him. ");
INSERT INTO engnoy_vpl VALUES ("JB23_10","019_23_10","JOB","23","10","10","But he knoweth the way which is in my heart; When he trieth me, I shall come forth as gold. ");
INSERT INTO engnoy_vpl VALUES ("JB23_11","019_23_11","JOB","23","11","11","My feet have trodden in his steps; His way I have kept, and have not turned aside from it. ");
INSERT INTO engnoy_vpl VALUES ("JB23_12","019_23_12","JOB","23","12","12","I have not neglected the precepts of his lips; Above my own law have I esteemed the words of his mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB23_13","019_23_13","JOB","23","13","13","But he is of one mind, and who can turn him? And what he desireth, that he doeth. ");
INSERT INTO engnoy_vpl VALUES ("JB23_14","019_23_14","JOB","23","14","14","He performeth that which is appointed for me; And many such things are in his mind! ");
INSERT INTO engnoy_vpl VALUES ("JB23_15","019_23_15","JOB","23","15","15","Therefore I am in terror on account of him; When I consider, I am afraid of him. ");
INSERT INTO engnoy_vpl VALUES ("JB23_16","019_23_16","JOB","23","16","16","For God maketh my heart faint; Yea, the Almighty terrifieth me; ");
INSERT INTO engnoy_vpl VALUES ("JB23_17","019_23_17","JOB","23","17","17","Because I was not taken away before darkness came, And he hath not hidden darkness from mine eyes. ");
INSERT INTO engnoy_vpl VALUES ("JB24_1","019_24_1","JOB","24","1","1","Why are not times treasured up by the Almighty? And why do not they who know him see his days? ");
INSERT INTO engnoy_vpl VALUES ("JB24_2","019_24_2","JOB","24","2","2","They remove landmarks; They take away flocks by violence, and pasture them. ");
INSERT INTO engnoy_vpl VALUES ("JB24_3","019_24_3","JOB","24","3","3","They drive away the ass of the fatherless, And take the widow's ox for a pledge. ");
INSERT INTO engnoy_vpl VALUES ("JB24_4","019_24_4","JOB","24","4","4","They push the needy from the way; All the poor of the land are forced to hide themselves. ");
INSERT INTO engnoy_vpl VALUES ("JB24_5","019_24_5","JOB","24","5","5","Behold, like wild asses of the desert, they go forth to their work; They search for prey; The wilderness supplieth them food for their children. ");
INSERT INTO engnoy_vpl VALUES ("JB24_6","019_24_6","JOB","24","6","6","In the fields they reap the harvest, And gather the vintage of the oppressor. ");
INSERT INTO engnoy_vpl VALUES ("JB24_7","019_24_7","JOB","24","7","7","They lodge naked, without clothing, And without covering from the cold. ");
INSERT INTO engnoy_vpl VALUES ("JB24_8","019_24_8","JOB","24","8","8","They are drenched with the mountain showers, And embrace the rock for want of shelter. ");
INSERT INTO engnoy_vpl VALUES ("JB24_9","019_24_9","JOB","24","9","9","The fatherless are torn from the breast, And the garment of the needy is taken for a pledge. ");
INSERT INTO engnoy_vpl VALUES ("JB24_10","019_24_10","JOB","24","10","10","They go naked, without clothing, And carry the sheaf hungry. ");
INSERT INTO engnoy_vpl VALUES ("JB24_11","019_24_11","JOB","24","11","11","They make oil within their walls, And tread the wine-vat, yet suffer thirst. ");
INSERT INTO engnoy_vpl VALUES ("JB24_12","019_24_12","JOB","24","12","12","From anguish the dying groan, And the wounded cry aloud; And God regardeth not their prayer! ");
INSERT INTO engnoy_vpl VALUES ("JB24_13","019_24_13","JOB","24","13","13","Others hate the light; They know not its ways, And abide not in its paths. ");
INSERT INTO engnoy_vpl VALUES ("JB24_14","019_24_14","JOB","24","14","14","With the light ariseth the murderer; He killeth the poor and needy; In the night he is as a thief. ");
INSERT INTO engnoy_vpl VALUES ("JB24_15","019_24_15","JOB","24","15","15","The eye of the adulterer watcheth for the twilight; He saith, “No eye will see me,” And putteth a mask upon his face. ");
INSERT INTO engnoy_vpl VALUES ("JB24_16","019_24_16","JOB","24","16","16","In the dark they break into houses; In the daytime they shut themselves up; They are strangers to the light. ");
INSERT INTO engnoy_vpl VALUES ("JB24_17","019_24_17","JOB","24","17","17","The morning is to them the very shadow of death; They are familiar with the terrors of the shadow of death. ");
INSERT INTO engnoy_vpl VALUES ("JB24_18","019_24_18","JOB","24","18","18","Light are they on the face of the waters; They have an accursed portion in the earth; They come not near the vineyards. ");
INSERT INTO engnoy_vpl VALUES ("JB24_19","019_24_19","JOB","24","19","19","As drought and heat consume the snow waters, So doth the grave the wicked. ");
INSERT INTO engnoy_vpl VALUES ("JB24_20","019_24_20","JOB","24","20","20","His own mother forgetteth him; The worm feedeth sweetly on him; He is no more remembered, And iniquity is broken like a tree. ");
INSERT INTO engnoy_vpl VALUES ("JB24_21","019_24_21","JOB","24","21","21","He oppresseth the barren, that hath not borne, And doeth not good to the widow. ");
INSERT INTO engnoy_vpl VALUES ("JB24_22","019_24_22","JOB","24","22","22","He taketh away the mighty by his power; He riseth up, and no one is sure of life. ");
INSERT INTO engnoy_vpl VALUES ("JB24_23","019_24_23","JOB","24","23","23","God giveth them security, so that they are confident; His eyes are upon their ways. ");
INSERT INTO engnoy_vpl VALUES ("JB24_24","019_24_24","JOB","24","24","24","They are exalted;—in a little while they are gone! They are brought low, and die, like all others; And like the topmost ears of corn are they cut off. ");
INSERT INTO engnoy_vpl VALUES ("JB24_25","019_24_25","JOB","24","25","25","If it be not so, who will confute me, And show my discourse to be worthless? ");
INSERT INTO engnoy_vpl VALUES ("JB25_1","019_25_1","JOB","25","1","1","Then answered Bildad the Shuhite, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB25_2","019_25_2","JOB","25","2","2","Dominion and fear are with Him; He maintaineth peace in his high places. ");
INSERT INTO engnoy_vpl VALUES ("JB25_3","019_25_3","JOB","25","3","3","Is there any numbering of his hosts? And upon whom doth not his light arise? ");
INSERT INTO engnoy_vpl VALUES ("JB25_4","019_25_4","JOB","25","4","4","How then can man be righteous before? Or how can he be pure that is born of woman? ");
INSERT INTO engnoy_vpl VALUES ("JB25_5","019_25_5","JOB","25","5","5","Behold, even the moon, it shineth not; And the stars are not pure in his sight, ");
INSERT INTO engnoy_vpl VALUES ("JB25_6","019_25_6","JOB","25","6","6","How much less, man, a worm; And the son of man, a reptile! ");
INSERT INTO engnoy_vpl VALUES ("JB26_1","019_26_1","JOB","26","1","1","Then Job answered and said: ");
INSERT INTO engnoy_vpl VALUES ("JB26_2","019_26_2","JOB","26","2","2","How hast thou helped the weak, And strengthened the feeble arm! ");
INSERT INTO engnoy_vpl VALUES ("JB26_3","019_26_3","JOB","26","3","3","How hast thou counselled the ignorant, And revealed wisdom in fulness! ");
INSERT INTO engnoy_vpl VALUES ("JB26_4","019_26_4","JOB","26","4","4","For whom hast thou uttered these words? And whose spirit spake through thee? ");
INSERT INTO engnoy_vpl VALUES ("JB26_5","019_26_5","JOB","26","5","5","Before Him the shades tremble Beneath the waters and their inhabitants. ");
INSERT INTO engnoy_vpl VALUES ("JB26_6","019_26_6","JOB","26","6","6","The under-world is naked before him, And destruction is without covering. ");
INSERT INTO engnoy_vpl VALUES ("JB26_7","019_26_7","JOB","26","7","7","He stretcheth out the north over empty space, And hangeth the earth upon nothing. ");
INSERT INTO engnoy_vpl VALUES ("JB26_8","019_26_8","JOB","26","8","8","He bindeth up the waters in his thick clouds, And the cloud is not rent under them. ");
INSERT INTO engnoy_vpl VALUES ("JB26_9","019_26_9","JOB","26","9","9","He covereth the face of his throne, And spreadeth his clouds upon it. ");
INSERT INTO engnoy_vpl VALUES ("JB26_10","019_26_10","JOB","26","10","10","He hath drawn a circular bound upon the waters, To the confines of light and darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB26_11","019_26_11","JOB","26","11","11","The pillars of heaven tremble And are confounded at his rebuke. ");
INSERT INTO engnoy_vpl VALUES ("JB26_12","019_26_12","JOB","26","12","12","By his power he stilleth the sea, Yea, by his wisdom he smiteth its pride. ");
INSERT INTO engnoy_vpl VALUES ("JB26_13","019_26_13","JOB","26","13","13","By his spirit he hath garnished the heavens; His hand hath formed the fleeing Serpent. ");
INSERT INTO engnoy_vpl VALUES ("JB26_14","019_26_14","JOB","26","14","14","Lo! these are but the borders of his works; How faint the whisper we have heard of him! But the thunder of his power who can understand? ");
INSERT INTO engnoy_vpl VALUES ("JB27_1","019_27_1","JOB","27","1","1","Moreover Job continued his discourse, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB27_2","019_27_2","JOB","27","2","2","As God liveth, who hath rejected my cause, And the Almighty, who hath afflicted my soul; ");
INSERT INTO engnoy_vpl VALUES ("JB27_3","019_27_3","JOB","27","3","3","As long as my breath is in me, And the spirit of God is in my nostrils, ");
INSERT INTO engnoy_vpl VALUES ("JB27_4","019_27_4","JOB","27","4","4","Never shall my lips speak falsehood, Nor my tongue utter deceit. ");
INSERT INTO engnoy_vpl VALUES ("JB27_5","019_27_5","JOB","27","5","5","God forbid that I should acknowledge you to be just: To my last breath will I assert my integrity. ");
INSERT INTO engnoy_vpl VALUES ("JB27_6","019_27_6","JOB","27","6","6","I will hold fast my innocence, and not let it go; My heart reproacheth me for no part of my life. ");
INSERT INTO engnoy_vpl VALUES ("JB27_7","019_27_7","JOB","27","7","7","May mine enemy be as the wicked, And he that riseth up against me as the unrighteous! ");
INSERT INTO engnoy_vpl VALUES ("JB27_8","019_27_8","JOB","27","8","8","For what is the hope of the wicked, when God cutteth off his web, And taketh away his life? ");
INSERT INTO engnoy_vpl VALUES ("JB27_9","019_27_9","JOB","27","9","9","Will he listen to his cry, When trouble cometh upon him? ");
INSERT INTO engnoy_vpl VALUES ("JB27_10","019_27_10","JOB","27","10","10","Can he delight himself in the Almighty, And call at all times upon God? ");
INSERT INTO engnoy_vpl VALUES ("JB27_11","019_27_11","JOB","27","11","11","I will teach you concerning the hand of God; That which is with the Almighty I will not conceal. ");
INSERT INTO engnoy_vpl VALUES ("JB27_12","019_27_12","JOB","27","12","12","Behold, ye yourselves have all seen it; Why then do ye cherish such vain thoughts? ");
INSERT INTO engnoy_vpl VALUES ("JB27_13","019_27_13","JOB","27","13","13","This is the portion of the wicked man from God,—The inheritance which oppressors receive from the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("JB27_14","019_27_14","JOB","27","14","14","If his children be multiplied, it is for the sword; And his offspring shall not be satisfied with bread. ");
INSERT INTO engnoy_vpl VALUES ("JB27_15","019_27_15","JOB","27","15","15","Those of them that escape shall be buried by Death, And their widows shall not bewail them. ");
INSERT INTO engnoy_vpl VALUES ("JB27_16","019_27_16","JOB","27","16","16","Though he heap up silver as dust, And procure raiment as clay,— ");
INSERT INTO engnoy_vpl VALUES ("JB27_17","019_27_17","JOB","27","17","17","He may procure, but the righteous shall wear it, And the innocent shall share the silver. ");
INSERT INTO engnoy_vpl VALUES ("JB27_18","019_27_18","JOB","27","18","18","He buildeth his house like the moth, Or like the shed which the watchman maketh. ");
INSERT INTO engnoy_vpl VALUES ("JB27_19","019_27_19","JOB","27","19","19","The rich man lieth down, and is not buried; In the twinkling of an eye he is no more. ");
INSERT INTO engnoy_vpl VALUES ("JB27_20","019_27_20","JOB","27","20","20","Terrors pursue him like a flood; A tempest stealeth him away in the night. ");
INSERT INTO engnoy_vpl VALUES ("JB27_21","019_27_21","JOB","27","21","21","The east wind carrieth him away, and he perisheth; Yea, it sweepeth him away from his place. ");
INSERT INTO engnoy_vpl VALUES ("JB27_22","019_27_22","JOB","27","22","22","God sendeth his arrows at him, and doth not spare; He would fain escape from His hand. ");
INSERT INTO engnoy_vpl VALUES ("JB27_23","019_27_23","JOB","27","23","23","Men clap their hands at him, And hiss him away from his place. ");
INSERT INTO engnoy_vpl VALUES ("JB28_1","019_28_1","JOB","28","1","1","Truly there is a vein for silver, And a place for gold, which men refine. ");
INSERT INTO engnoy_vpl VALUES ("JB28_2","019_28_2","JOB","28","2","2","Iron is obtained from earth, And stone is melted into copper. ");
INSERT INTO engnoy_vpl VALUES ("JB28_3","019_28_3","JOB","28","3","3","Man putteth an end to darkness; He searcheth to the lowest depths For the stone of darkness and the shadow of death. ");
INSERT INTO engnoy_vpl VALUES ("JB28_4","019_28_4","JOB","28","4","4","From the place where they dwell they open a shaft; Forgotten by the feet, They hang down, they swing away from men. ");
INSERT INTO engnoy_vpl VALUES ("JB28_5","019_28_5","JOB","28","5","5","The earth, out of which cometh bread, Is torn up underneath, as it were by fire. ");
INSERT INTO engnoy_vpl VALUES ("JB28_6","019_28_6","JOB","28","6","6","Her stones are the place of sapphires, And she hath clods of gold for man. ");
INSERT INTO engnoy_vpl VALUES ("JB28_7","019_28_7","JOB","28","7","7","The path thereto no bird knoweth, And the vulture's eye hath not seen it; ");
INSERT INTO engnoy_vpl VALUES ("JB28_8","019_28_8","JOB","28","8","8","The fierce wild beast hath not trodden it; The lion hath not passed over it. ");
INSERT INTO engnoy_vpl VALUES ("JB28_9","019_28_9","JOB","28","9","9","Man layeth his hand upon the rock; He upturneth mountains from their roots; ");
INSERT INTO engnoy_vpl VALUES ("JB28_10","019_28_10","JOB","28","10","10","He cleaveth out streams in the rocks, And his eye seeth every precious thing; ");
INSERT INTO engnoy_vpl VALUES ("JB28_11","019_28_11","JOB","28","11","11","He bindeth up the streams, that they trickle not, And bringeth hidden things to light. ");
INSERT INTO engnoy_vpl VALUES ("JB28_12","019_28_12","JOB","28","12","12","But where shall wisdom be found? And where is the place of understanding? ");
INSERT INTO engnoy_vpl VALUES ("JB28_13","019_28_13","JOB","28","13","13","Man knoweth not the price thereof, Nor can it be found in the land of the living. ");
INSERT INTO engnoy_vpl VALUES ("JB28_14","019_28_14","JOB","28","14","14","The deep saith, It is not in me; And the sea saith, It is not with me. ");
INSERT INTO engnoy_vpl VALUES ("JB28_15","019_28_15","JOB","28","15","15","It cannot be gotten for gold, Nor shall silver be weighed out as the price thereof. ");
INSERT INTO engnoy_vpl VALUES ("JB28_16","019_28_16","JOB","28","16","16","It cannot be bought with the gold of Ophir, With the precious onyx or the sapphire. ");
INSERT INTO engnoy_vpl VALUES ("JB28_17","019_28_17","JOB","28","17","17","Gold and crystal are not to be compared with it; Nor can it be purchased with jewels of fine gold. ");
INSERT INTO engnoy_vpl VALUES ("JB28_18","019_28_18","JOB","28","18","18","No mention shall be made of coral or of crystal; For wisdom is more precious than pearls. ");
INSERT INTO engnoy_vpl VALUES ("JB28_19","019_28_19","JOB","28","19","19","The topaz of Ethiopia cannot equal it, Nor can it be purchased with pure gold. ");
INSERT INTO engnoy_vpl VALUES ("JB28_20","019_28_20","JOB","28","20","20","Whence then cometh wisdom? And where is the place of understanding? ");
INSERT INTO engnoy_vpl VALUES ("JB28_21","019_28_21","JOB","28","21","21","Since it is hidden from the eyes of all living, And kept close from the fowls of the air. ");
INSERT INTO engnoy_vpl VALUES ("JB28_22","019_28_22","JOB","28","22","22","Destruction and Death say, We have heard a rumor of it with our ears. ");
INSERT INTO engnoy_vpl VALUES ("JB28_23","019_28_23","JOB","28","23","23","God knoweth the way to it; He knoweth its dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("JB28_24","019_28_24","JOB","28","24","24","For he seeth to the ends of the earth, And surveyeth all things under the whole heaven. ");
INSERT INTO engnoy_vpl VALUES ("JB28_25","019_28_25","JOB","28","25","25","When he gave the winds their weight, And meted out the waters by measure; ");
INSERT INTO engnoy_vpl VALUES ("JB28_26","019_28_26","JOB","28","26","26","When he prescribed a law to the rain, And a path to the thunder-flash,— ");
INSERT INTO engnoy_vpl VALUES ("JB28_27","019_28_27","JOB","28","27","27","Then did he see it, and make it known; He established it, and searched it out. ");
INSERT INTO engnoy_vpl VALUES ("JB28_28","019_28_28","JOB","28","28","28","But he said unto man, Behold, the fear of the Lord, that is wisdom, And to depart from evil is understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB29_1","019_29_1","JOB","29","1","1","Moreover Job continued his discourse, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB29_2","019_29_2","JOB","29","2","2","O that I were as in months past, In the days when God was my guardian; ");
INSERT INTO engnoy_vpl VALUES ("JB29_3","019_29_3","JOB","29","3","3","When his lamp shined over my head, And when by his light I walked through darkness! ");
INSERT INTO engnoy_vpl VALUES ("JB29_4","019_29_4","JOB","29","4","4","As I was in the autumn of my days, When the friendship of God was over my tent; ");
INSERT INTO engnoy_vpl VALUES ("JB29_5","019_29_5","JOB","29","5","5","When the Almighty was yet with me, And my children were around me; ");
INSERT INTO engnoy_vpl VALUES ("JB29_6","019_29_6","JOB","29","6","6","When I bathed my steps in milk, And the rock poured me out rivers of oil! ");
INSERT INTO engnoy_vpl VALUES ("JB29_7","019_29_7","JOB","29","7","7","When I went forth to the gate by the city, And took my seat in the market-place, ");
INSERT INTO engnoy_vpl VALUES ("JB29_8","019_29_8","JOB","29","8","8","The young men saw me and hid themselves, And the aged arose and stood. ");
INSERT INTO engnoy_vpl VALUES ("JB29_9","019_29_9","JOB","29","9","9","The princes refrained from speaking, And laid their hand upon their mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB29_10","019_29_10","JOB","29","10","10","The nobles held their peace, And their tongue cleaved to the roof of their mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB29_11","019_29_11","JOB","29","11","11","When the ear heard me, then it blessed me; And when the eye saw me, it gave witness to me. ");
INSERT INTO engnoy_vpl VALUES ("JB29_12","019_29_12","JOB","29","12","12","For I delivered the poor, when they cried; And the fatherless, who had none to help him. ");
INSERT INTO engnoy_vpl VALUES ("JB29_13","019_29_13","JOB","29","13","13","The blessing of him that was ready to perish came upon me, And I caused the heart of the widow to sing for joy. ");
INSERT INTO engnoy_vpl VALUES ("JB29_14","019_29_14","JOB","29","14","14","I clothed myself with righteousness, and it clothed itself with me; And justice was my robe and diadem. ");
INSERT INTO engnoy_vpl VALUES ("JB29_15","019_29_15","JOB","29","15","15","I was eyes to the blind, And feet was I to the lame; ");
INSERT INTO engnoy_vpl VALUES ("JB29_16","019_29_16","JOB","29","16","16","I was a father to the poor, And the cause of him I knew not I searched out; ");
INSERT INTO engnoy_vpl VALUES ("JB29_17","019_29_17","JOB","29","17","17","And I broke the teeth of the wicked, And plucked the spoil from his jaws. ");
INSERT INTO engnoy_vpl VALUES ("JB29_18","019_29_18","JOB","29","18","18","Then said I, “I shall die in my nest; I shall multiply my days as the sand. ");
INSERT INTO engnoy_vpl VALUES ("JB29_19","019_29_19","JOB","29","19","19","My root is spread abroad to the waters, And the dew abideth on my branches. ");
INSERT INTO engnoy_vpl VALUES ("JB29_20","019_29_20","JOB","29","20","20","My glory is fresh with me, And my bow gathereth strength in my hand.” ");
INSERT INTO engnoy_vpl VALUES ("JB29_21","019_29_21","JOB","29","21","21","To me men gave ear, and waited, And kept silence for my counsel. ");
INSERT INTO engnoy_vpl VALUES ("JB29_22","019_29_22","JOB","29","22","22","To my words they made no reply, When my speech dropped down upon them. ");
INSERT INTO engnoy_vpl VALUES ("JB29_23","019_29_23","JOB","29","23","23","Yea, they waited for me as for the rain; They opened their mouths wide as for the latter rain. ");
INSERT INTO engnoy_vpl VALUES ("JB29_24","019_29_24","JOB","29","24","24","If I smiled upon them, they believed it not; Nor did they cause the light of my countenance to fall. ");
INSERT INTO engnoy_vpl VALUES ("JB29_25","019_29_25","JOB","29","25","25","When I came among them, I sat as chief; I dwelt as a king in the midst of an army, As a comforter among mourners. ");
INSERT INTO engnoy_vpl VALUES ("JB30_1","019_30_1","JOB","30","1","1","But now they that are younger than I hold me in derision, Whose fathers I would have disdained to set with the dogs of my flock. ");
INSERT INTO engnoy_vpl VALUES ("JB30_2","019_30_2","JOB","30","2","2","Of what use to me would be even the strength of their hands, To whom old age is lost? ");
INSERT INTO engnoy_vpl VALUES ("JB30_3","019_30_3","JOB","30","3","3","By want and hunger they are famished; They gnaw the dry desert, The darkness of desolate wastes. ");
INSERT INTO engnoy_vpl VALUES ("JB30_4","019_30_4","JOB","30","4","4","They gather purslain among the bushes, And the root of the broom is their bread. ");
INSERT INTO engnoy_vpl VALUES ("JB30_5","019_30_5","JOB","30","5","5","They are driven from the society of men; There is a cry after them as after a thief. ");
INSERT INTO engnoy_vpl VALUES ("JB30_6","019_30_6","JOB","30","6","6","They dwell in gloomy valleys, In caves of the earth and in rocks. ");
INSERT INTO engnoy_vpl VALUES ("JB30_7","019_30_7","JOB","30","7","7","They bray among the bushes; Under the brambles are they stretched out. ");
INSERT INTO engnoy_vpl VALUES ("JB30_8","019_30_8","JOB","30","8","8","An impious and low-born race, They are beaten out of the land. ");
INSERT INTO engnoy_vpl VALUES ("JB30_9","019_30_9","JOB","30","9","9","And now I am become their song; Yea, I am their by-word! ");
INSERT INTO engnoy_vpl VALUES ("JB30_10","019_30_10","JOB","30","10","10","They abhor me, they stand aloof from me; They forbear not to spit before my face. ");
INSERT INTO engnoy_vpl VALUES ("JB30_11","019_30_11","JOB","30","11","11","Yea, they let loose the reins, and humble me; They cast off the bridle before me. ");
INSERT INTO engnoy_vpl VALUES ("JB30_12","019_30_12","JOB","30","12","12","On my right hand riseth up the brood; They thrust away my feet; They cast up against me their destructive ways. ");
INSERT INTO engnoy_vpl VALUES ("JB30_13","019_30_13","JOB","30","13","13","They break up my path; They hasten my fall,—They who have no helper! ");
INSERT INTO engnoy_vpl VALUES ("JB30_14","019_30_14","JOB","30","14","14","They come upon me as through a wide breach; Through the ruins they rush in upon me. ");
INSERT INTO engnoy_vpl VALUES ("JB30_15","019_30_15","JOB","30","15","15","Terrors are turned against me; They pursue my prosperity like the wind, And my welfare passeth away like a cloud. ");
INSERT INTO engnoy_vpl VALUES ("JB30_16","019_30_16","JOB","30","16","16","And now my soul poureth itself out upon me; Days of affliction have taken hold of me. ");
INSERT INTO engnoy_vpl VALUES ("JB30_17","019_30_17","JOB","30","17","17","By night my bones are pierced; they are torn from me, And my gnawers take no rest. ");
INSERT INTO engnoy_vpl VALUES ("JB30_18","019_30_18","JOB","30","18","18","Through the violence of my disease is my garment changed; It bindeth me about like the collar of my tunic. ");
INSERT INTO engnoy_vpl VALUES ("JB30_19","019_30_19","JOB","30","19","19","He hath cast me into the mire, And I am become like dust and ashes. ");
INSERT INTO engnoy_vpl VALUES ("JB30_20","019_30_20","JOB","30","20","20","I call upon Thee, but thou dost not hear me; I stand up before thee, but thou regardest me not. ");
INSERT INTO engnoy_vpl VALUES ("JB30_21","019_30_21","JOB","30","21","21","Thou art become cruel to me; With thy strong hand dost thou lie in wait for me. ");
INSERT INTO engnoy_vpl VALUES ("JB30_22","019_30_22","JOB","30","22","22","Thou liftest me up, and causest me to ride upon the wind; Thou meltest me away in the storm. ");
INSERT INTO engnoy_vpl VALUES ("JB30_23","019_30_23","JOB","30","23","23","I know that thou wilt bring me to death, To the place of assembly for all the living. ");
INSERT INTO engnoy_vpl VALUES ("JB30_24","019_30_24","JOB","30","24","24","When He stretcheth out his hand, prayer availeth nothing; When He bringeth destruction, vain is the cry for help. ");
INSERT INTO engnoy_vpl VALUES ("JB30_25","019_30_25","JOB","30","25","25","Did not I weep for him that was in trouble? Was not my soul grieved for the poor? ");
INSERT INTO engnoy_vpl VALUES ("JB30_26","019_30_26","JOB","30","26","26","But when I looked for good, then evil came; When I looked for light, then came darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB30_27","019_30_27","JOB","30","27","27","My bowels boil, and have no rest; Days of anguish have come upon me. ");
INSERT INTO engnoy_vpl VALUES ("JB30_28","019_30_28","JOB","30","28","28","I am black, but not by the sun; I stand up, and utter my cries in the congregation. ");
INSERT INTO engnoy_vpl VALUES ("JB30_29","019_30_29","JOB","30","29","29","I am become a brother to jackals, And a companion to ostriches. ");
INSERT INTO engnoy_vpl VALUES ("JB30_30","019_30_30","JOB","30","30","30","My skin is black, and falleth from me, And my bones burn with heat. ");
INSERT INTO engnoy_vpl VALUES ("JB30_31","019_30_31","JOB","30","31","31","My harp also is turned to mourning, And my pipe to notes of grief. ");
INSERT INTO engnoy_vpl VALUES ("JB31_1","019_31_1","JOB","31","1","1","I made a covenant with mine eyes; How then could I gaze upon a maid? ");
INSERT INTO engnoy_vpl VALUES ("JB31_2","019_31_2","JOB","31","2","2","For what is the portion appointed by God from above, And the inheritance allotted by the Almighty from on high? ");
INSERT INTO engnoy_vpl VALUES ("JB31_3","019_31_3","JOB","31","3","3","Is not destruction for the wicked, And ruin for the workers of iniquity? ");
INSERT INTO engnoy_vpl VALUES ("JB31_4","019_31_4","JOB","31","4","4","Doth He not see my ways, And number all my steps? ");
INSERT INTO engnoy_vpl VALUES ("JB31_5","019_31_5","JOB","31","5","5","If I have walked with falsehood, And if my foot hath hasted to deceit, ");
INSERT INTO engnoy_vpl VALUES ("JB31_6","019_31_6","JOB","31","6","6","Let him weigh me in an even balance; Yea, let God know my integrity! ");
INSERT INTO engnoy_vpl VALUES ("JB31_7","019_31_7","JOB","31","7","7","If my steps have turned aside from the way, And my heart gone after mine eyes, Or if any stain hath cleaved to my hand, ");
INSERT INTO engnoy_vpl VALUES ("JB31_8","019_31_8","JOB","31","8","8","Then I may sow, and another eat; And what I plant, may it be rooted up! ");
INSERT INTO engnoy_vpl VALUES ("JB31_9","019_31_9","JOB","31","9","9","If my heart hath been enticed by a woman, Or if I have watched at my neighbor's door, ");
INSERT INTO engnoy_vpl VALUES ("JB31_10","019_31_10","JOB","31","10","10","Then let my wife grind for another, And let other men lie with her! ");
INSERT INTO engnoy_vpl VALUES ("JB31_11","019_31_11","JOB","31","11","11","For this were a heinous crime, Even a transgression to be punished by the judges; ");
INSERT INTO engnoy_vpl VALUES ("JB31_12","019_31_12","JOB","31","12","12","Yea, it were a fire that would consume to destruction, And root out all my increase. ");
INSERT INTO engnoy_vpl VALUES ("JB31_13","019_31_13","JOB","31","13","13","If I have refused justice to my man-servant or maid-servant, When they had a controversy with me, ");
INSERT INTO engnoy_vpl VALUES ("JB31_14","019_31_14","JOB","31","14","14","Then what shall I do when God riseth up? And when he visiteth, what shall I answer him? ");
INSERT INTO engnoy_vpl VALUES ("JB31_15","019_31_15","JOB","31","15","15","Did not He that made me in the womb make him? Did not one fashion us in the womb? ");
INSERT INTO engnoy_vpl VALUES ("JB31_16","019_31_16","JOB","31","16","16","If I have refused the poor their desire, And caused the eyes of the widow to fail; ");
INSERT INTO engnoy_vpl VALUES ("JB31_17","019_31_17","JOB","31","17","17","If I have eaten my morsel alone, And the fatherless hath not partaken of it; ");
INSERT INTO engnoy_vpl VALUES ("JB31_18","019_31_18","JOB","31","18","18","(Nay, from my youth he grew up with me as with a father, And I have helped the widow from my mother's womb;) ");
INSERT INTO engnoy_vpl VALUES ("JB31_19","019_31_19","JOB","31","19","19","If I have seen any one perishing for want of clothing, Or any poor man without covering; ");
INSERT INTO engnoy_vpl VALUES ("JB31_20","019_31_20","JOB","31","20","20","If his loins have not blessed me, And he hath not been warmed with the fleece of my sheep; ");
INSERT INTO engnoy_vpl VALUES ("JB31_21","019_31_21","JOB","31","21","21","If I have shaken my hand against the fatherless, Because I saw my help in the gate,— ");
INSERT INTO engnoy_vpl VALUES ("JB31_22","019_31_22","JOB","31","22","22","Then may my shoulder fill from its blade, And my fore-arm be broken from its bone! ");
INSERT INTO engnoy_vpl VALUES ("JB31_23","019_31_23","JOB","31","23","23","For destruction from God was a terror to me, And before his majesty I could do nothing. ");
INSERT INTO engnoy_vpl VALUES ("JB31_24","019_31_24","JOB","31","24","24","If I have made gold my trust, Or said to the fine gold, Thou art my confidence; ");
INSERT INTO engnoy_vpl VALUES ("JB31_25","019_31_25","JOB","31","25","25","If I have rejoiced, because my wealth was great, And my hand had found abundance; ");
INSERT INTO engnoy_vpl VALUES ("JB31_26","019_31_26","JOB","31","26","26","If I have beheld the sun in his splendor, Or the moon advancing in brightness, ");
INSERT INTO engnoy_vpl VALUES ("JB31_27","019_31_27","JOB","31","27","27","And my heart hath been secretly enticed, And my mouth hath kissed my hand, ");
INSERT INTO engnoy_vpl VALUES ("JB31_28","019_31_28","JOB","31","28","28","This also were a crime to be punished by the judge; For I should have denied the God who is above. ");
INSERT INTO engnoy_vpl VALUES ("JB31_29","019_31_29","JOB","31","29","29","If I have rejoiced at the destruction of him that hated me, And exulted when evil came upon him; ");
INSERT INTO engnoy_vpl VALUES ("JB31_30","019_31_30","JOB","31","30","30","(Nay, I have not suffered my mouth to sin, By asking with curses his life;) ");
INSERT INTO engnoy_vpl VALUES ("JB31_31","019_31_31","JOB","31","31","31","If the men of my tent have not exclaimed, “Who is there that hath not been satisfied with his meat?” ");
INSERT INTO engnoy_vpl VALUES ("JB31_32","019_31_32","JOB","31","32","32","The stranger did not lodge in the street; I opened my doors to the traveller. ");
INSERT INTO engnoy_vpl VALUES ("JB31_33","019_31_33","JOB","31","33","33","Have I, after the manner of men, hidden my transgression, Concealing my iniquity in my bosom, ");
INSERT INTO engnoy_vpl VALUES ("JB31_34","019_31_34","JOB","31","34","34","Then let me be confounded before the great multitude! Let the contempt of families cover me with shame! Yea, let me keep silence! let me never appear abroad! ");
INSERT INTO engnoy_vpl VALUES ("JB31_35","019_31_35","JOB","31","35","35","O that there were one who would hear me! Behold my signature! let the Almighty answer me. And let mine adversary write down his charge! ");
INSERT INTO engnoy_vpl VALUES ("JB31_36","019_31_36","JOB","31","36","36","Truly I would wear it upon my shoulder; I would bind it upon me as a crown. ");
INSERT INTO engnoy_vpl VALUES ("JB31_37","019_31_37","JOB","31","37","37","I would disclose to him all my steps; I would approach him like a prince. ");
INSERT INTO engnoy_vpl VALUES ("JB31_38","019_31_38","JOB","31","38","38","If my land cry out against me, And its furrows bewail together; ");
INSERT INTO engnoy_vpl VALUES ("JB31_39","019_31_39","JOB","31","39","39","If I have eaten of its fruits without payment, And wrung out the life of its owners, ");
INSERT INTO engnoy_vpl VALUES ("JB31_40","019_31_40","JOB","31","40","40","Let thorns grow up instead of wheat, And noxious weeds instead of barley. The words of Job are ended. ");
INSERT INTO engnoy_vpl VALUES ("JB32_1","019_32_1","JOB","32","1","1","So these three men ceased to answer Job, because he was righteous in his own eyes. ");
INSERT INTO engnoy_vpl VALUES ("JB32_2","019_32_2","JOB","32","2","2","Then was kindled the wrath of Elihu, the son of Barachel, the Buzite, of the family of Ram; against Job was his wrath kindled, because he accounted himself righteous rather than God. ");
INSERT INTO engnoy_vpl VALUES ("JB32_3","019_32_3","JOB","32","3","3","Against his three friends also was his wrath kindled, because they had not found an answer, and yet had condemned Job. ");
INSERT INTO engnoy_vpl VALUES ("JB32_4","019_32_4","JOB","32","4","4","Now Elihu had delayed to reply to Job, because they were older than himself. ");
INSERT INTO engnoy_vpl VALUES ("JB32_5","019_32_5","JOB","32","5","5","But when Elihu saw that there was no answer in the mouth of these three men, his wrath was kindled. ");
INSERT INTO engnoy_vpl VALUES ("JB32_6","019_32_6","JOB","32","6","6","Then spake Elihu, the son of Barachel, the Buzite, and said: I am young, and ye are very old; Therefore I was afraid, And durst not make known to you my opinion. ");
INSERT INTO engnoy_vpl VALUES ("JB32_7","019_32_7","JOB","32","7","7","I said, “Days should speak, And the multitude of years should teach wisdom.” ");
INSERT INTO engnoy_vpl VALUES ("JB32_8","019_32_8","JOB","32","8","8","But it is the spirit in man, Even the inspiration of the Almighty, that giveth him understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB32_9","019_32_9","JOB","32","9","9","Great men are not always wise, Nor do the aged always understand what is right. ");
INSERT INTO engnoy_vpl VALUES ("JB32_10","019_32_10","JOB","32","10","10","Therefore, I pray, listen to me: I also will declare my opinion. ");
INSERT INTO engnoy_vpl VALUES ("JB32_11","019_32_11","JOB","32","11","11","Behold, I have waited for your words, I have listened to your arguments, Whilst ye searched out what to say; ");
INSERT INTO engnoy_vpl VALUES ("JB32_12","019_32_12","JOB","32","12","12","Yea, I have attended to you; And behold, none of you hath refuted Job, Nor answered his words. ");
INSERT INTO engnoy_vpl VALUES ("JB32_13","019_32_13","JOB","32","13","13","Say not, then, “We have found out wisdom; God must conquer him, not man.” ");
INSERT INTO engnoy_vpl VALUES ("JB32_14","019_32_14","JOB","32","14","14","He hath not directed his discourse against me, And with speeches like yours will I not answer him. ");
INSERT INTO engnoy_vpl VALUES ("JB32_15","019_32_15","JOB","32","15","15","They were confounded! they answered no more! They could say nothing! ");
INSERT INTO engnoy_vpl VALUES ("JB32_16","019_32_16","JOB","32","16","16","I waited, but they spake not; They stood still; they answered no more! ");
INSERT INTO engnoy_vpl VALUES ("JB32_17","019_32_17","JOB","32","17","17","Therefore will I answer, on my part; I also will show my opinion. ");
INSERT INTO engnoy_vpl VALUES ("JB32_18","019_32_18","JOB","32","18","18","For I am full of matter; The spirit within me constraineth me. ");
INSERT INTO engnoy_vpl VALUES ("JB32_19","019_32_19","JOB","32","19","19","Behold, my bosom is as wine that hath no vent; Like bottles of new wine, which are bursting. ");
INSERT INTO engnoy_vpl VALUES ("JB32_20","019_32_20","JOB","32","20","20","I will speak, that I may be relieved; I will open my lips and answer. ");
INSERT INTO engnoy_vpl VALUES ("JB32_21","019_32_21","JOB","32","21","21","I will not be partial to any man's person, Nor will I flatter any man. ");
INSERT INTO engnoy_vpl VALUES ("JB32_22","019_32_22","JOB","32","22","22","For I know not how to flatter; Soon would my Maker take me away. ");
INSERT INTO engnoy_vpl VALUES ("JB33_1","019_33_1","JOB","33","1","1","Hear, therefore, my discourse, I pray thee, O Job! And attend unto all my words! ");
INSERT INTO engnoy_vpl VALUES ("JB33_2","019_33_2","JOB","33","2","2","Behold, I am opening my mouth; My tongue is now speaking in my palate. ");
INSERT INTO engnoy_vpl VALUES ("JB33_3","019_33_3","JOB","33","3","3","My words shall be in the uprightness of my heart; My lips shall utter knowledge purely. ");
INSERT INTO engnoy_vpl VALUES ("JB33_4","019_33_4","JOB","33","4","4","The spirit of God made me, And the breath of the Almighty gave me life. ");
INSERT INTO engnoy_vpl VALUES ("JB33_5","019_33_5","JOB","33","5","5","If thou art able, answer me; Set thyself in array against me; stand up! ");
INSERT INTO engnoy_vpl VALUES ("JB33_6","019_33_6","JOB","33","6","6","Behold, I, like thee, am a creature of God; I also was formed of clay. ");
INSERT INTO engnoy_vpl VALUES ("JB33_7","019_33_7","JOB","33","7","7","Behold, my terror cannot dismay thee, Nor can my greatness be heavy upon thee. ");
INSERT INTO engnoy_vpl VALUES ("JB33_8","019_33_8","JOB","33","8","8","Surely thou hast said in my hearing, I have heard the sound of thy words: ");
INSERT INTO engnoy_vpl VALUES ("JB33_9","019_33_9","JOB","33","9","9","“I am pure, and without transgression; I am clean, and there is no iniquity in me. ");
INSERT INTO engnoy_vpl VALUES ("JB33_10","019_33_10","JOB","33","10","10","Behold, He seeketh causes of hostility against me; He regardeth me as his enemy. ");
INSERT INTO engnoy_vpl VALUES ("JB33_11","019_33_11","JOB","33","11","11","He putteth my feet in the stocks; He watcheth all my paths.” ");
INSERT INTO engnoy_vpl VALUES ("JB33_12","019_33_12","JOB","33","12","12","Behold, in this thou art not right; I will answer thee; For God is greater than man. ");
INSERT INTO engnoy_vpl VALUES ("JB33_13","019_33_13","JOB","33","13","13","Why dost thou contend with Him? For he giveth no account of any of his doings. ");
INSERT INTO engnoy_vpl VALUES ("JB33_14","019_33_14","JOB","33","14","14","For God speaketh once, Yea, twice, when man regardeth it not. ");
INSERT INTO engnoy_vpl VALUES ("JB33_15","019_33_15","JOB","33","15","15","In a dream, in a vision of the night, When deep sleep falleth upon men, In slumber upon the bed; ");
INSERT INTO engnoy_vpl VALUES ("JB33_16","019_33_16","JOB","33","16","16","Then openeth he the ears of men, And sealeth up for them admonition; ");
INSERT INTO engnoy_vpl VALUES ("JB33_17","019_33_17","JOB","33","17","17","That he may turn man from his purpose, And hide pride from man. ");
INSERT INTO engnoy_vpl VALUES ("JB33_18","019_33_18","JOB","33","18","18","Thus he saveth him from the pit, Yea, his life from perishing by the sword. ");
INSERT INTO engnoy_vpl VALUES ("JB33_19","019_33_19","JOB","33","19","19","He is chastened also with pain upon his bed, And with a continual agitation of his bones, ");
INSERT INTO engnoy_vpl VALUES ("JB33_20","019_33_20","JOB","33","20","20","So that his mouth abhorreth bread, And his taste the choicest food; ");
INSERT INTO engnoy_vpl VALUES ("JB33_21","019_33_21","JOB","33","21","21","His flesh is consumed, that it cannot be seen, And his bones, that were invisible, are naked; ");
INSERT INTO engnoy_vpl VALUES ("JB33_22","019_33_22","JOB","33","22","22","Yea, his soul draweth near to the pit, And his life to the destroyers. ");
INSERT INTO engnoy_vpl VALUES ("JB33_23","019_33_23","JOB","33","23","23","But if there be with him a messenger, An interpreter, one of a thousand, Who may show unto man his duty, ");
INSERT INTO engnoy_vpl VALUES ("JB33_24","019_33_24","JOB","33","24","24","Then will God be gracious to him, and say, “Save him from going down to the pit: I have found a ransom.” ");
INSERT INTO engnoy_vpl VALUES ("JB33_25","019_33_25","JOB","33","25","25","His flesh shall became fresher than a child's; He shall return to the days of his youth. ");
INSERT INTO engnoy_vpl VALUES ("JB33_26","019_33_26","JOB","33","26","26","He shall pray to God, and he will be favorable to him, And permit him to see his face with joy, And restore unto man his righteousness. ");
INSERT INTO engnoy_vpl VALUES ("JB33_27","019_33_27","JOB","33","27","27","He shall sing among men, and say, “I sinned; I acted perversely; Yet hath he not requited me for it: ");
INSERT INTO engnoy_vpl VALUES ("JB33_28","019_33_28","JOB","33","28","28","He hath delivered me from going down to the pit, And my life beholdeth the light.” ");
INSERT INTO engnoy_vpl VALUES ("JB33_29","019_33_29","JOB","33","29","29","Lo! all these things doeth God Time after time with man, ");
INSERT INTO engnoy_vpl VALUES ("JB33_30","019_33_30","JOB","33","30","30","That he may bring him back from the pit, That he may enjoy the light of the living. ");
INSERT INTO engnoy_vpl VALUES ("JB33_31","019_33_31","JOB","33","31","31","Mark well, O Job! hearken to me! Keep silence, and I will speak. ");
INSERT INTO engnoy_vpl VALUES ("JB33_32","019_33_32","JOB","33","32","32","Yet if thou hast any thing to say, answer me! Speak! for I desire to pronounce thee innocent. ");
INSERT INTO engnoy_vpl VALUES ("JB33_33","019_33_33","JOB","33","33","33","But if not, do thou listen to me! Keep silence, and I will teach thee wisdom! ");
INSERT INTO engnoy_vpl VALUES ("JB34_1","019_34_1","JOB","34","1","1","And Elihu proceeded, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB34_2","019_34_2","JOB","34","2","2","Hear my words, ye wise men! Give ear to me, ye that have knowledge! ");
INSERT INTO engnoy_vpl VALUES ("JB34_3","019_34_3","JOB","34","3","3","For the ear trieth words, As the mouth tasteth meat. ");
INSERT INTO engnoy_vpl VALUES ("JB34_4","019_34_4","JOB","34","4","4","Let us examine for ourselves what is right; Let us know among ourselves what is true. ");
INSERT INTO engnoy_vpl VALUES ("JB34_5","019_34_5","JOB","34","5","5","Job hath said, “I am righteous, And God refuseth me justice. ");
INSERT INTO engnoy_vpl VALUES ("JB34_6","019_34_6","JOB","34","6","6","Though I am innocent, I am made a liar; My wound is incurable, though I am free from transgression.” ");
INSERT INTO engnoy_vpl VALUES ("JB34_7","019_34_7","JOB","34","7","7","Where is the man like Job, Who drinketh impiety like water; ");
INSERT INTO engnoy_vpl VALUES ("JB34_8","019_34_8","JOB","34","8","8","Who goeth in company with evil-doers, And walketh with wicked men? ");
INSERT INTO engnoy_vpl VALUES ("JB34_9","019_34_9","JOB","34","9","9","For he hath said, “A man hath no advantage, When he delighteth himself in God.” ");
INSERT INTO engnoy_vpl VALUES ("JB34_10","019_34_10","JOB","34","10","10","Wherefore hearken to me, ye men of understanding! Far be iniquity from God; Yea, far be injustice from the Almighty! ");
INSERT INTO engnoy_vpl VALUES ("JB34_11","019_34_11","JOB","34","11","11","For what a man hath done he will requite him, And render to every one according to his deeds. ");
INSERT INTO engnoy_vpl VALUES ("JB34_12","019_34_12","JOB","34","12","12","Surely God will not do iniquity, Nor will the Almighty pervert justice. ");
INSERT INTO engnoy_vpl VALUES ("JB34_13","019_34_13","JOB","34","13","13","Who hath given him the charge of the earth? Or who hath created the whole world? ");
INSERT INTO engnoy_vpl VALUES ("JB34_14","019_34_14","JOB","34","14","14","Should he set his heart against man, Should he take back his spirit and his breath, ");
INSERT INTO engnoy_vpl VALUES ("JB34_15","019_34_15","JOB","34","15","15","Then would all flesh expire together; Yea, man would return to the dust. ");
INSERT INTO engnoy_vpl VALUES ("JB34_16","019_34_16","JOB","34","16","16","If thou hast understanding, hear this! Give ear to the voice of my words! ");
INSERT INTO engnoy_vpl VALUES ("JB34_17","019_34_17","JOB","34","17","17","Shall he, that hateth justice, govern? Wilt thou then condemn the just and mighty One? ");
INSERT INTO engnoy_vpl VALUES ("JB34_18","019_34_18","JOB","34","18","18","Is it fit to say to a king, Thou art wicked; Or to princes, Ye are unrighteous? ");
INSERT INTO engnoy_vpl VALUES ("JB34_19","019_34_19","JOB","34","19","19","How much less to him that is not partial to princes, Nor regardeth the rich more than the poor? For they are all the work of his hands. ");
INSERT INTO engnoy_vpl VALUES ("JB34_20","019_34_20","JOB","34","20","20","In a moment they die; yea, at midnight Do the people stagger and pass away, And the mighty are destroyed without hand. ");
INSERT INTO engnoy_vpl VALUES ("JB34_21","019_34_21","JOB","34","21","21","For his eyes are upon the ways of man; He seeth all his steps. ");
INSERT INTO engnoy_vpl VALUES ("JB34_22","019_34_22","JOB","34","22","22","There is no darkness, nor shadow of death, Where evil-doers may hide themselves. ");
INSERT INTO engnoy_vpl VALUES ("JB34_23","019_34_23","JOB","34","23","23","He needeth not attend long to a man, That he may go into judgment before God; ");
INSERT INTO engnoy_vpl VALUES ("JB34_24","019_34_24","JOB","34","24","24","He dasheth in pieces the mighty without inquiry, And setteth up others in their stead. ");
INSERT INTO engnoy_vpl VALUES ("JB34_25","019_34_25","JOB","34","25","25","Therefore he knoweth their works, And in a night he overthroweth them, so that they are destroyed. ");
INSERT INTO engnoy_vpl VALUES ("JB34_26","019_34_26","JOB","34","26","26","On account of their wickedness he smiteth them, In the presence of many beholders; ");
INSERT INTO engnoy_vpl VALUES ("JB34_27","019_34_27","JOB","34","27","27","Because they turned away from him, And had no regard to his ways, ");
INSERT INTO engnoy_vpl VALUES ("JB34_28","019_34_28","JOB","34","28","28","And caused the cry of the poor to come before him; For he heareth the cry of the oppressed. ");
INSERT INTO engnoy_vpl VALUES ("JB34_29","019_34_29","JOB","34","29","29","When he giveth rest, who can cause trouble? And when he hideth his face, Who can behold him? ");
INSERT INTO engnoy_vpl VALUES ("JB34_30","019_34_30","JOB","34","30","30","So is it with nations and individuals alike! That the wicked may no more rule, And may not be snares to the people. ");
INSERT INTO engnoy_vpl VALUES ("JB34_31","019_34_31","JOB","34","31","31","Surely thou shouldst say unto God, “I have received chastisement; I will no more offend; ");
INSERT INTO engnoy_vpl VALUES ("JB34_32","019_34_32","JOB","34","32","32","What I see not, teach thou me! If I have done iniquity, I will do it no more.” ");
INSERT INTO engnoy_vpl VALUES ("JB34_33","019_34_33","JOB","34","33","33","Shall he recompense according to thy mind, Because thou refusest, or because thou choosest, and not he? Speak, if thou hast knowledge! ");
INSERT INTO engnoy_vpl VALUES ("JB34_34","019_34_34","JOB","34","34","34","Men of understanding, Wise men, who hear me, will say, ");
INSERT INTO engnoy_vpl VALUES ("JB34_35","019_34_35","JOB","34","35","35","“Job hath spoken without knowledge, And his words are without wisdom.” ");
INSERT INTO engnoy_vpl VALUES ("JB34_36","019_34_36","JOB","34","36","36","I desire that Job may be tried to the last, For answering like wicked men. ");
INSERT INTO engnoy_vpl VALUES ("JB34_37","019_34_37","JOB","34","37","37","For he addeth impiety to his sin; He clappeth his hands among us, And multiplieth words against God. ");
INSERT INTO engnoy_vpl VALUES ("JB35_1","019_35_1","JOB","35","1","1","Moreover Elihu proceeded, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB35_2","019_35_2","JOB","35","2","2","Dost thou then think this to be right? Thou hast said, “I am more righteous than God.” ");
INSERT INTO engnoy_vpl VALUES ("JB35_3","019_35_3","JOB","35","3","3","For thou askest, “What advantage have I? What have I gained, more than if I had sinned?” ");
INSERT INTO engnoy_vpl VALUES ("JB35_4","019_35_4","JOB","35","4","4","I will answer thee, And thy companions with thee. ");
INSERT INTO engnoy_vpl VALUES ("JB35_5","019_35_5","JOB","35","5","5","Look up to the heavens, and see! And behold the clouds, which are high above thee! ");
INSERT INTO engnoy_vpl VALUES ("JB35_6","019_35_6","JOB","35","6","6","If thou sinnest, what doest thou against Him? If thy transgressions be multiplied, what doest thou to him? ");
INSERT INTO engnoy_vpl VALUES ("JB35_7","019_35_7","JOB","35","7","7","If thou art righteous, what dost thou give him? Or what receiveth he at thy hand? ");
INSERT INTO engnoy_vpl VALUES ("JB35_8","019_35_8","JOB","35","8","8","Thy wickedness injureth only a man like thyself, And thy righteousness profiteth only a son of man. ");
INSERT INTO engnoy_vpl VALUES ("JB35_9","019_35_9","JOB","35","9","9","The oppressed cry out on account of the multitude of wrongs; They cry aloud on account of the arm of the mighty. ");
INSERT INTO engnoy_vpl VALUES ("JB35_10","019_35_10","JOB","35","10","10","But none saith, “Where is God, my Maker, Who giveth songs in the night; ");
INSERT INTO engnoy_vpl VALUES ("JB35_11","019_35_11","JOB","35","11","11","Who teacheth us more than the beasts of the earth, And maketh us wiser than the birds of heaven?” ");
INSERT INTO engnoy_vpl VALUES ("JB35_12","019_35_12","JOB","35","12","12","There they cry aloud on account of the pride of the wicked; But he giveth no answer. ");
INSERT INTO engnoy_vpl VALUES ("JB35_13","019_35_13","JOB","35","13","13","For God will not hear the vain supplication, Nor will the Almighty regard it; ");
INSERT INTO engnoy_vpl VALUES ("JB35_14","019_35_14","JOB","35","14","14","Much less when thou sayest thou canst not see him: Justice is with him,—only wait thou for him! ");
INSERT INTO engnoy_vpl VALUES ("JB35_15","019_35_15","JOB","35","15","15","But now, because he hath not visited in his anger, Nor taken strict note of transgression, ");
INSERT INTO engnoy_vpl VALUES ("JB35_16","019_35_16","JOB","35","16","16","Therefore hath Job opened his mouth rashly, And multiplied words without knowledge. ");
INSERT INTO engnoy_vpl VALUES ("JB36_1","019_36_1","JOB","36","1","1","Elihu also proceeded, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB36_2","019_36_2","JOB","36","2","2","Bear with me a little while, that I may show thee! For I have yet words in behalf of God. ");
INSERT INTO engnoy_vpl VALUES ("JB36_3","019_36_3","JOB","36","3","3","I will bring my knowledge from afar, And assert the justice of my Maker. ");
INSERT INTO engnoy_vpl VALUES ("JB36_4","019_36_4","JOB","36","4","4","Truly my words shall not be false: A man of sound knowledge is before thee. ");
INSERT INTO engnoy_vpl VALUES ("JB36_5","019_36_5","JOB","36","5","5","Behold, God is great, but despiseth not any; Great is he in strength of understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB36_6","019_36_6","JOB","36","6","6","He suffereth not the wicked to prosper, But rendereth justice to the oppressed. ");
INSERT INTO engnoy_vpl VALUES ("JB36_7","019_36_7","JOB","36","7","7","He withdraweth not his eyes from the righteous; But establisheth them for ever with kings on the throne, That they may be exalted. ");
INSERT INTO engnoy_vpl VALUES ("JB36_8","019_36_8","JOB","36","8","8","And if they be bound in fetters, And holden in the cords of affliction, ");
INSERT INTO engnoy_vpl VALUES ("JB36_9","019_36_9","JOB","36","9","9","Then showeth he them their deeds, And how they have set him at defiance by their transgressions; ");
INSERT INTO engnoy_vpl VALUES ("JB36_10","019_36_10","JOB","36","10","10","He also openeth their ears to admonition, And commandeth them to return from iniquity. ");
INSERT INTO engnoy_vpl VALUES ("JB36_11","019_36_11","JOB","36","11","11","If they obey and serve him, They spend their days in prosperity, And their years in pleasures. ");
INSERT INTO engnoy_vpl VALUES ("JB36_12","019_36_12","JOB","36","12","12","But if they obey not, they perish by the sword; They die in their own folly. ");
INSERT INTO engnoy_vpl VALUES ("JB36_13","019_36_13","JOB","36","13","13","The corrupt in heart treasure up wrath; They cry not to God, when he bindeth them. ");
INSERT INTO engnoy_vpl VALUES ("JB36_14","019_36_14","JOB","36","14","14","They die in their youth; They close their lives with the unclean. ");
INSERT INTO engnoy_vpl VALUES ("JB36_15","019_36_15","JOB","36","15","15","But he delivereth the poor in their distress; He openeth their ears in affliction. ");
INSERT INTO engnoy_vpl VALUES ("JB36_16","019_36_16","JOB","36","16","16","He will bring thee also from the jaws of distress To a broad place, where is no straitness; And the provision of thy table shall be full of fatness. ");
INSERT INTO engnoy_vpl VALUES ("JB36_17","019_36_17","JOB","36","17","17","But if thou art full of the judgment of the wicked, Judgment and justice shall take hold of thee. ");
INSERT INTO engnoy_vpl VALUES ("JB36_18","019_36_18","JOB","36","18","18","For if wrath be with him, beware lest he take thee away by his stroke, So that a great ransom shall not save thee! ");
INSERT INTO engnoy_vpl VALUES ("JB36_19","019_36_19","JOB","36","19","19","Will he esteem thy riches? No! neither thy gold, nor all the abundance of thy wealth. ");
INSERT INTO engnoy_vpl VALUES ("JB36_20","019_36_20","JOB","36","20","20","Long not thou for that night To which nations are taken away from their place. ");
INSERT INTO engnoy_vpl VALUES ("JB36_21","019_36_21","JOB","36","21","21","Take heed, turn not thine eyes to iniquity! For this hast thou chosen rather than affliction. ");
INSERT INTO engnoy_vpl VALUES ("JB36_22","019_36_22","JOB","36","22","22","Behold, God is exalted in his power: Who is a teacher like him? ");
INSERT INTO engnoy_vpl VALUES ("JB36_23","019_36_23","JOB","36","23","23","Who hath prescribed to him his way? Or who can say to him, “Thou hast done wrong”? ");
INSERT INTO engnoy_vpl VALUES ("JB36_24","019_36_24","JOB","36","24","24","Forget not to magnify his work, Which men celebrate with songs. ");
INSERT INTO engnoy_vpl VALUES ("JB36_25","019_36_25","JOB","36","25","25","All mankind gaze upon it; Mortals behold it from afar. ");
INSERT INTO engnoy_vpl VALUES ("JB36_26","019_36_26","JOB","36","26","26","Behold, God is great; we cannot know him, Nor search out the number of his years. ");
INSERT INTO engnoy_vpl VALUES ("JB36_27","019_36_27","JOB","36","27","27","Lo! he draweth up the drops of water, Which distil rain from his vapor; ");
INSERT INTO engnoy_vpl VALUES ("JB36_28","019_36_28","JOB","36","28","28","The clouds pour it down, And drop it upon man in abundance. ");
INSERT INTO engnoy_vpl VALUES ("JB36_29","019_36_29","JOB","36","29","29","Who can understand the spreading of his clouds, And the rattling of his pavilion? ");
INSERT INTO engnoy_vpl VALUES ("JB36_30","019_36_30","JOB","36","30","30","Behold, he spreadeth around himself his light, And he clotheth himself with the depths of the sea. ");
INSERT INTO engnoy_vpl VALUES ("JB36_31","019_36_31","JOB","36","31","31","By these he punisheth nations, And by these he giveth food in abundance. ");
INSERT INTO engnoy_vpl VALUES ("JB36_32","019_36_32","JOB","36","32","32","His hands he covereth with lightning; He giveth it commandment against an enemy. ");
INSERT INTO engnoy_vpl VALUES ("JB36_33","019_36_33","JOB","36","33","33","His thunder maketh him known; Yea, to the herds, as he ascendeth on high. ");
INSERT INTO engnoy_vpl VALUES ("JB37_1","019_37_1","JOB","37","1","1","At this my heart trembleth, And leapeth out of its place. ");
INSERT INTO engnoy_vpl VALUES ("JB37_2","019_37_2","JOB","37","2","2","Hear, O hear, the thunder of his voice, And the noise which goeth forth from his mouth! ");
INSERT INTO engnoy_vpl VALUES ("JB37_3","019_37_3","JOB","37","3","3","He directeth it under the whole heaven, And his lightning to the ends of the earth. ");
INSERT INTO engnoy_vpl VALUES ("JB37_4","019_37_4","JOB","37","4","4","After it the thunder roareth; He thundereth with his voice of majesty, And restraineth it not, when his voice is heard. ");
INSERT INTO engnoy_vpl VALUES ("JB37_5","019_37_5","JOB","37","5","5","God thundereth with his voice marvellously; Great things doeth he, which we cannot comprehend. ");
INSERT INTO engnoy_vpl VALUES ("JB37_6","019_37_6","JOB","37","6","6","For he saith to the snow, “Be thou on the earth!” To the shower also, even the showers of his might. ");
INSERT INTO engnoy_vpl VALUES ("JB37_7","019_37_7","JOB","37","7","7","He sealeth up the hand of every man, That all men whom he hath made may acknowledge him. ");
INSERT INTO engnoy_vpl VALUES ("JB37_8","019_37_8","JOB","37","8","8","Then the beasts go into dens, And abide in their caverns. ");
INSERT INTO engnoy_vpl VALUES ("JB37_9","019_37_9","JOB","37","9","9","Out of the south cometh the whirlwind, And cold out of the north. ");
INSERT INTO engnoy_vpl VALUES ("JB37_10","019_37_10","JOB","37","10","10","By the breath of God ice is formed, And the broad waters become narrow, ");
INSERT INTO engnoy_vpl VALUES ("JB37_11","019_37_11","JOB","37","11","11","Yea, with moisture he burdeneth the clouds; He spreadeth abroad his lightning-clouds. ");
INSERT INTO engnoy_vpl VALUES ("JB37_12","019_37_12","JOB","37","12","12","They move about by his direction, To execute all his commands throughout the world; ");
INSERT INTO engnoy_vpl VALUES ("JB37_13","019_37_13","JOB","37","13","13","Whether he cause them to come for punishment, Or for the land, or for mercy. ");
INSERT INTO engnoy_vpl VALUES ("JB37_14","019_37_14","JOB","37","14","14","Give ear to this, O Job! Stand still, and consider the wondrous works of God! ");
INSERT INTO engnoy_vpl VALUES ("JB37_15","019_37_15","JOB","37","15","15","Dost thou know when God gave commandment to them, And caused the lightning of his cloud to flash? ");
INSERT INTO engnoy_vpl VALUES ("JB37_16","019_37_16","JOB","37","16","16","Dost thou understand the balancing of the clouds, The wondrous works of Him that is perfect in knowledge? ");
INSERT INTO engnoy_vpl VALUES ("JB37_17","019_37_17","JOB","37","17","17","How thy garments become warm, When he maketh the earth still by the south wind? ");
INSERT INTO engnoy_vpl VALUES ("JB37_18","019_37_18","JOB","37","18","18","Canst thou like him spread out the sky, Which is firm like a molten mirror? ");
INSERT INTO engnoy_vpl VALUES ("JB37_19","019_37_19","JOB","37","19","19","Teach us what we shall say to him! For we cannot set in order our words by reason of darkness. ");
INSERT INTO engnoy_vpl VALUES ("JB37_20","019_37_20","JOB","37","20","20","Shall it be told him that I would speak? Shall a man speak, that he may be consumed? ");
INSERT INTO engnoy_vpl VALUES ("JB37_21","019_37_21","JOB","37","21","21","For now men do not look upon the light, When it is bright in the skies, When the wind hath passed over them, and made them clear. ");
INSERT INTO engnoy_vpl VALUES ("JB37_22","019_37_22","JOB","37","22","22","From the north cometh gold; But with God is terrible majesty! ");
INSERT INTO engnoy_vpl VALUES ("JB37_23","019_37_23","JOB","37","23","23","The Almighty, we cannot find him out; Great is he in power and justice, Abundant in righteousness; he doth not oppress. ");
INSERT INTO engnoy_vpl VALUES ("JB37_24","019_37_24","JOB","37","24","24","Therefore let men fear him! Upon none of the wise in heart will he look. ");
INSERT INTO engnoy_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Then spake Jehovah to Job out of the whirlwind, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","Who is this that darkeneth counsel by words without knowledge? ");
INSERT INTO engnoy_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","Gird up thy loins like a man! I will ask thee, and answer thou me! ");
INSERT INTO engnoy_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","Where wast thou when I laid the foundations of the earth? Declare, if thou hast understanding! ");
INSERT INTO engnoy_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","Who fixed its dimensions, that thou shouldst know it! Or who stretched out the line upon it? ");
INSERT INTO engnoy_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","Upon what were its foundations fixed? And who laid its corner-stone, ");
INSERT INTO engnoy_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","When the morning stars sang together, And all the sons of God shouted for joy? ");
INSERT INTO engnoy_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","And who shut up the sea with doors, When it burst forth as from the womb? ");
INSERT INTO engnoy_vpl VALUES ("JB38_9","019_38_9","JOB","38","9","9","When I made the clouds its mantle, And thick darkness its swaddling-band; ");
INSERT INTO engnoy_vpl VALUES ("JB38_10","019_38_10","JOB","38","10","10","When I appointed for it my bound, And fixed for it bars and doors; ");
INSERT INTO engnoy_vpl VALUES ("JB38_11","019_38_11","JOB","38","11","11","And said, Thus far shalt thou come, and no farther, And here shall thy proud waves be stayed! ");
INSERT INTO engnoy_vpl VALUES ("JB38_12","019_38_12","JOB","38","12","12","Hast thou, in thy life, given charge to the morning, Or caused the day-spring to know its place, ");
INSERT INTO engnoy_vpl VALUES ("JB38_13","019_38_13","JOB","38","13","13","That it should lay hold of the ends of the earth, And shake the wicked out of it? ");
INSERT INTO engnoy_vpl VALUES ("JB38_14","019_38_14","JOB","38","14","14","It is changed as clay by the seal; And all things stand forth as in rich apparel. ");
INSERT INTO engnoy_vpl VALUES ("JB38_15","019_38_15","JOB","38","15","15","But from the wicked their light is withheld, And the high-raised arm is broken. ");
INSERT INTO engnoy_vpl VALUES ("JB38_16","019_38_16","JOB","38","16","16","Hast thou visited the springs of the sea, And walked through the recesses of the deep? ");
INSERT INTO engnoy_vpl VALUES ("JB38_17","019_38_17","JOB","38","17","17","Have the gates of death been disclosed to thee, And hast thou seen the gates of the shadow of death? ");
INSERT INTO engnoy_vpl VALUES ("JB38_18","019_38_18","JOB","38","18","18","Hast thou surveyed the breadth of the earth? Declare, if thou knowest it all! ");
INSERT INTO engnoy_vpl VALUES ("JB38_19","019_38_19","JOB","38","19","19","Where is the way to the abode of light? And darkness—where is its dwelling-place? ");
INSERT INTO engnoy_vpl VALUES ("JB38_20","019_38_20","JOB","38","20","20","That thou shouldst lead it to its boundary, And that thou shouldst know the paths to its mansion! ");
INSERT INTO engnoy_vpl VALUES ("JB38_21","019_38_21","JOB","38","21","21","Surely thou knowest; for thou wast then born! And the number of thy years is great! ");
INSERT INTO engnoy_vpl VALUES ("JB38_22","019_38_22","JOB","38","22","22","Hast thou visited the storehouses of the snow, Or seen the treasuries of the hail, ");
INSERT INTO engnoy_vpl VALUES ("JB38_23","019_38_23","JOB","38","23","23","Which I have reserved against the time of trouble,—Against the day of battle and war? ");
INSERT INTO engnoy_vpl VALUES ("JB38_24","019_38_24","JOB","38","24","24","What is the way to where light is distributed, And the east wind spread abroad upon the earth? ");
INSERT INTO engnoy_vpl VALUES ("JB38_25","019_38_25","JOB","38","25","25","Who hath prepared channels for the rain, And a path for the thunder-flash, ");
INSERT INTO engnoy_vpl VALUES ("JB38_26","019_38_26","JOB","38","26","26","To give rain to the land without an inhabitant, To the wilderness wherein is no man; ");
INSERT INTO engnoy_vpl VALUES ("JB38_27","019_38_27","JOB","38","27","27","To satisfy the desolate and waste ground, And cause the tender herb to spring forth? ");
INSERT INTO engnoy_vpl VALUES ("JB38_28","019_38_28","JOB","38","28","28","Hath the rain a father? Or who hath begotten the drops of the dew? ");
INSERT INTO engnoy_vpl VALUES ("JB38_29","019_38_29","JOB","38","29","29","Out of whose womb came the ice? And who hath gendered the hoar-frost of heaven? ");
INSERT INTO engnoy_vpl VALUES ("JB38_30","019_38_30","JOB","38","30","30","The waters are hid as under stone, And the face of the deep becometh solid. ");
INSERT INTO engnoy_vpl VALUES ("JB38_31","019_38_31","JOB","38","31","31","Canst thou fasten the bands of the Pleiades, Or loosen the chains of Orion? ");
INSERT INTO engnoy_vpl VALUES ("JB38_32","019_38_32","JOB","38","32","32","Canst thou lead forth the Signs in their season, Or guide the Bear with her sons? ");
INSERT INTO engnoy_vpl VALUES ("JB38_33","019_38_33","JOB","38","33","33","Knowest thou the ordinances of the heavens? Hast thou appointed their dominion over the earth? ");
INSERT INTO engnoy_vpl VALUES ("JB38_34","019_38_34","JOB","38","34","34","Canst thou lift up thy voice to the clouds, So that abundance of waters will cover thee? ");
INSERT INTO engnoy_vpl VALUES ("JB38_35","019_38_35","JOB","38","35","35","Canst thou send forth lightnings, so that they will go, And say to thee, “Here we are”? ");
INSERT INTO engnoy_vpl VALUES ("JB38_36","019_38_36","JOB","38","36","36","Who hath put understanding in the reins, And given intelligence to the mind? ");
INSERT INTO engnoy_vpl VALUES ("JB38_37","019_38_37","JOB","38","37","37","Who numbereth the clouds in wisdom? And who poureth out the bottles of heaven, ");
INSERT INTO engnoy_vpl VALUES ("JB38_38","019_38_38","JOB","38","38","38","When the dust floweth into a molten mass, And the clods cleave fast together? ");
INSERT INTO engnoy_vpl VALUES ("JB38_39","019_38_39","JOB","38","39","39","Canst thou hunt prey for the lioness, Or satisfy the hunger of the young lions, ");
INSERT INTO engnoy_vpl VALUES ("JB38_40","019_38_40","JOB","38","40","40","When they couch in their dens, And lie in wait in the thicket? ");
INSERT INTO engnoy_vpl VALUES ("JB38_41","019_38_41","JOB","38","41","41","Who provideth for the raven his food, When his young ones cry unto God, While they wander about without food? ");
INSERT INTO engnoy_vpl VALUES ("JB39_1","019_39_1","JOB","39","1","1","Knowest thou the time when the wild goats of the rock bring forth? Or canst thou observe when the hinds are in labor? ");
INSERT INTO engnoy_vpl VALUES ("JB39_2","019_39_2","JOB","39","2","2","Canst thou number the months they fulfill, And know the season when they bring forth? ");
INSERT INTO engnoy_vpl VALUES ("JB39_3","019_39_3","JOB","39","3","3","They bow themselves; they bring forth their young; They cast forth their pains. ");
INSERT INTO engnoy_vpl VALUES ("JB39_4","019_39_4","JOB","39","4","4","Their young ones are strong; they grow up in the fields; They go away, and return not to them. ");
INSERT INTO engnoy_vpl VALUES ("JB39_5","019_39_5","JOB","39","5","5","Who hath sent forth the wild ass free? Who hath loosed the bands of the wild ass, ");
INSERT INTO engnoy_vpl VALUES ("JB39_6","019_39_6","JOB","39","6","6","To whom I have given the wilderness for his house, And the barren land for his dwelling-place? ");
INSERT INTO engnoy_vpl VALUES ("JB39_7","019_39_7","JOB","39","7","7","He scorneth the tumult of the city, And heedeth not the shouting of the driver; ");
INSERT INTO engnoy_vpl VALUES ("JB39_8","019_39_8","JOB","39","8","8","The range of the mountains is his pasture; He seeketh after every green thing, ");
INSERT INTO engnoy_vpl VALUES ("JB39_9","019_39_9","JOB","39","9","9","Will the wild-ox consent to serve thee? Will he pass the night at thy crib? ");
INSERT INTO engnoy_vpl VALUES ("JB39_10","019_39_10","JOB","39","10","10","Canst thou bind the wild-ox with the harness to the furrow? Or will he harrow the valleys after thee? ");
INSERT INTO engnoy_vpl VALUES ("JB39_11","019_39_11","JOB","39","11","11","Wilt thou rely upon him because his strength is great, And commit to him thy labor? ");
INSERT INTO engnoy_vpl VALUES ("JB39_12","019_39_12","JOB","39","12","12","Wilt thou trust him to bring home thy grain, And gather in thy harvest? ");
INSERT INTO engnoy_vpl VALUES ("JB39_13","019_39_13","JOB","39","13","13","The wing of the ostrich moveth joyfully; But is it with loving pinion and feathers? ");
INSERT INTO engnoy_vpl VALUES ("JB39_14","019_39_14","JOB","39","14","14","Nay, she layeth her eggs on the ground; She warmeth them in the dust, ");
INSERT INTO engnoy_vpl VALUES ("JB39_15","019_39_15","JOB","39","15","15","And forgetteth that the foot may crush them, And that the wild beast may break them. ");
INSERT INTO engnoy_vpl VALUES ("JB39_16","019_39_16","JOB","39","16","16","She is cruel to her young, as if they were not hers; Her labor is in vain, yet she feareth not; ");
INSERT INTO engnoy_vpl VALUES ("JB39_17","019_39_17","JOB","39","17","17","Because God hath denied her wisdom, And hath not given her understanding. ");
INSERT INTO engnoy_vpl VALUES ("JB39_18","019_39_18","JOB","39","18","18","Yet when she lasheth herself up on high, She laugheth at the horse and his rider. ");
INSERT INTO engnoy_vpl VALUES ("JB39_19","019_39_19","JOB","39","19","19","Hast thou given the horse strength? Hast thou clothed his neck with his trembling mane? ");
INSERT INTO engnoy_vpl VALUES ("JB39_20","019_39_20","JOB","39","20","20","Hast thou taught him to bound like the locust? How majestic his snorting! how terrible! ");
INSERT INTO engnoy_vpl VALUES ("JB39_21","019_39_21","JOB","39","21","21","He paweth in the valley; he exulteth in his strength, And rusheth into the midst of arms. ");
INSERT INTO engnoy_vpl VALUES ("JB39_22","019_39_22","JOB","39","22","22","He laugheth at fear; he trembleth not, And turneth not back from the sword. ");
INSERT INTO engnoy_vpl VALUES ("JB39_23","019_39_23","JOB","39","23","23","Against him rattle the quiver, The flaming spear, and the lance. ");
INSERT INTO engnoy_vpl VALUES ("JB39_24","019_39_24","JOB","39","24","24","With rage and fury he devoureth the ground; He will not believe that the trumpet soundeth. ");
INSERT INTO engnoy_vpl VALUES ("JB39_25","019_39_25","JOB","39","25","25","At every blast of the trumpet, he saith, Aha! And snuffeth the battle afar off,—The thunder of the captains, and the war-shout. ");
INSERT INTO engnoy_vpl VALUES ("JB39_26","019_39_26","JOB","39","26","26","Is it by thy wisdom that the hawk flieth, And spreadeth his wings toward the south? ");
INSERT INTO engnoy_vpl VALUES ("JB39_27","019_39_27","JOB","39","27","27","Doth the eagle soar at thy command, And build his nest on high? ");
INSERT INTO engnoy_vpl VALUES ("JB39_28","019_39_28","JOB","39","28","28","He dwelleth and lodgeth upon the rock, Upon the peak of the rock, and the stronghold. ");
INSERT INTO engnoy_vpl VALUES ("JB39_29","019_39_29","JOB","39","29","29","From thence he spieth out prey; His eyes discern it from afar. ");
INSERT INTO engnoy_vpl VALUES ("JB39_30","019_39_30","JOB","39","30","30","His young ones suck up blood; And where the slain are, there is he. ");
INSERT INTO engnoy_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Moreover Jehovah spake to Job, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","Will the censurer of the Almighty contend with him? Will the reprover of God answer? ");
INSERT INTO engnoy_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Then Job answered Jehovah, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","Behold, I am vile! what can I answer thee? I will lay my hand upon my mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Once have I spoken, but I will not speak again; Yea, twice, but I will say no more. ");
INSERT INTO engnoy_vpl VALUES ("JB40_6","019_40_6","JOB","40","6","6","Then spake Jehovah to Job out of the whirlwind, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB40_7","019_40_7","JOB","40","7","7","Gird up now thy loins like a man! I will ask thee, and do thou instruct me! ");
INSERT INTO engnoy_vpl VALUES ("JB40_8","019_40_8","JOB","40","8","8","Wilt thou even disannul my right? Wilt thou condemn me, that thou mayst be righteous? ");
INSERT INTO engnoy_vpl VALUES ("JB40_9","019_40_9","JOB","40","9","9","Hast thou an arm like God's? Or canst thou thunder with thy voice like him? ");
INSERT INTO engnoy_vpl VALUES ("JB40_10","019_40_10","JOB","40","10","10","Deck thyself with grandeur and majesty, And array thyself in splendor and glory! ");
INSERT INTO engnoy_vpl VALUES ("JB40_11","019_40_11","JOB","40","11","11","Send forth the fury of thy wrath! Look upon every proud one, and abase him! ");
INSERT INTO engnoy_vpl VALUES ("JB40_12","019_40_12","JOB","40","12","12","Look upon every proud one, and bring him low; Yea, tread down the wicked in their place! ");
INSERT INTO engnoy_vpl VALUES ("JB40_13","019_40_13","JOB","40","13","13","Hide them in the dust together; Shut up their faces in darkness! ");
INSERT INTO engnoy_vpl VALUES ("JB40_14","019_40_14","JOB","40","14","14","Then, indeed, will I give thee the praise, That thine own right hand can save thee. ");
INSERT INTO engnoy_vpl VALUES ("JB40_15","019_40_15","JOB","40","15","15","Behold the river-horse, which I have made as well as thyself; He feedeth on grass like the ox. ");
INSERT INTO engnoy_vpl VALUES ("JB40_16","019_40_16","JOB","40","16","16","Behold, what strength is in his loins! And what force in the muscles of his belly! ");
INSERT INTO engnoy_vpl VALUES ("JB40_17","019_40_17","JOB","40","17","17","He bendeth his tail, like the cedar, And the sinews of his thighs are twisted together. ");
INSERT INTO engnoy_vpl VALUES ("JB40_18","019_40_18","JOB","40","18","18","His bones are pipes of brass, And his limbs are bars of iron. ");
INSERT INTO engnoy_vpl VALUES ("JB40_19","019_40_19","JOB","40","19","19","He is chief among the works of God; He that made him gave him his sword. ");
INSERT INTO engnoy_vpl VALUES ("JB40_20","019_40_20","JOB","40","20","20","For the mountains supply him with food, Where all the beasts of the field play. ");
INSERT INTO engnoy_vpl VALUES ("JB40_21","019_40_21","JOB","40","21","21","He lieth down under the lote-plants, In the covert of reeds, and in the fens. ");
INSERT INTO engnoy_vpl VALUES ("JB40_22","019_40_22","JOB","40","22","22","The lote-plants cover him with their shadow, And the willows of the brook compass him about. ");
INSERT INTO engnoy_vpl VALUES ("JB40_23","019_40_23","JOB","40","23","23","Lo! the stream overfloweth, but he starteth not; He is unmoved though Jordan rush forth even to his mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB40_24","019_40_24","JOB","40","24","24","Can one take him before his eyes, Or pierce his nose with hooks? ");
INSERT INTO engnoy_vpl VALUES ("JB41_1","019_41_1","JOB","41","1","1","Canst thou draw forth the crocodile with a hook, Or press down his tongue with a cord? ");
INSERT INTO engnoy_vpl VALUES ("JB41_2","019_41_2","JOB","41","2","2","Canst thou put a rope into his nose, Or pierce his cheek with a hook? ");
INSERT INTO engnoy_vpl VALUES ("JB41_3","019_41_3","JOB","41","3","3","Will he make many entreaties to thee? Will he speak soft words to thee? ");
INSERT INTO engnoy_vpl VALUES ("JB41_4","019_41_4","JOB","41","4","4","Will he make a covenant with thee? Canst thou take him for a servant for ever? ");
INSERT INTO engnoy_vpl VALUES ("JB41_5","019_41_5","JOB","41","5","5","Canst thou play with him, as with a bird? Or canst thou bind him for thy maidens? ");
INSERT INTO engnoy_vpl VALUES ("JB41_6","019_41_6","JOB","41","6","6","Do men in company lay snares for him? Do they divide him among the merchants? ");
INSERT INTO engnoy_vpl VALUES ("JB41_7","019_41_7","JOB","41","7","7","Canst thou fill his skirt with barbed irons, Or his head with fish-spears? ");
INSERT INTO engnoy_vpl VALUES ("JB41_8","019_41_8","JOB","41","8","8","Do but lay thy hand upon him,—Thou wilt no more think of battle! ");
INSERT INTO engnoy_vpl VALUES ("JB41_9","019_41_9","JOB","41","9","9","Behold, his hope is vain! Is he not cast down at the very sight of him? ");
INSERT INTO engnoy_vpl VALUES ("JB41_10","019_41_10","JOB","41","10","10","None is so fierce that he dare stir him up; Who then is he that can stand before me? ");
INSERT INTO engnoy_vpl VALUES ("JB41_11","019_41_11","JOB","41","11","11","Who hath done me a favor, that I must repay him? Whatever is under the whole heaven is mine. ");
INSERT INTO engnoy_vpl VALUES ("JB41_12","019_41_12","JOB","41","12","12","I will not be silent concerning his limbs, And his strength, and the beauty of his armor. ");
INSERT INTO engnoy_vpl VALUES ("JB41_13","019_41_13","JOB","41","13","13","Who can uncover the surface of his garment? Who will approach his jaws? ");
INSERT INTO engnoy_vpl VALUES ("JB41_14","019_41_14","JOB","41","14","14","Who will open the doors of his face? The rows of his teeth are terrible! ");
INSERT INTO engnoy_vpl VALUES ("JB41_15","019_41_15","JOB","41","15","15","His glory is his strong shields, United with each other, as with a close seal. ");
INSERT INTO engnoy_vpl VALUES ("JB41_16","019_41_16","JOB","41","16","16","They are joined one to another, So that no air can come between them. ");
INSERT INTO engnoy_vpl VALUES ("JB41_17","019_41_17","JOB","41","17","17","They cleave fast to each other, They hold together, and cannot be separated. ");
INSERT INTO engnoy_vpl VALUES ("JB41_18","019_41_18","JOB","41","18","18","His sneezing sendeth forth light, And his eyes are like the eyelashes of the morning. ");
INSERT INTO engnoy_vpl VALUES ("JB41_19","019_41_19","JOB","41","19","19","Out of his mouth go flames, And sparks of fire leap forth. ");
INSERT INTO engnoy_vpl VALUES ("JB41_20","019_41_20","JOB","41","20","20","From his nostrils issueth smoke, as from a heated pot, or caldron. ");
INSERT INTO engnoy_vpl VALUES ("JB41_21","019_41_21","JOB","41","21","21","His breath kindleth coals, And flames issue from his mouth. ");
INSERT INTO engnoy_vpl VALUES ("JB41_22","019_41_22","JOB","41","22","22","In his neck dwelleth strength, And terror danceth before him. ");
INSERT INTO engnoy_vpl VALUES ("JB41_23","019_41_23","JOB","41","23","23","The flakes of his flesh cleave fast together; They are firm upon him, and cannot be moved. ");
INSERT INTO engnoy_vpl VALUES ("JB41_24","019_41_24","JOB","41","24","24","His heart is solid like a stone; Yea, solid like the nether millstone. ");
INSERT INTO engnoy_vpl VALUES ("JB41_25","019_41_25","JOB","41","25","25","When he riseth up, the mighty are afraid; Yea, they lose themselves for terror. ");
INSERT INTO engnoy_vpl VALUES ("JB41_26","019_41_26","JOB","41","26","26","The sword of him that assaileth him doth not stand, The spear, the dart, nor the habergeon. ");
INSERT INTO engnoy_vpl VALUES ("JB41_27","019_41_27","JOB","41","27","27","He regardeth iron as straw, And brass as rotten wood. ");
INSERT INTO engnoy_vpl VALUES ("JB41_28","019_41_28","JOB","41","28","28","The arrow cannot make him flee; Sling-stones to him become stubble; ");
INSERT INTO engnoy_vpl VALUES ("JB41_29","019_41_29","JOB","41","29","29","Clubs are accounted by him as straw; He laugheth at the shaking of the spear. ");
INSERT INTO engnoy_vpl VALUES ("JB41_30","019_41_30","JOB","41","30","30","Under him are sharp potsherds; He spreadeth out a thrashing-sledge upon the mire. ");
INSERT INTO engnoy_vpl VALUES ("JB41_31","019_41_31","JOB","41","31","31","He maketh the deep to boil like a caldron; He maketh the sea like a pot of ointment. ");
INSERT INTO engnoy_vpl VALUES ("JB41_32","019_41_32","JOB","41","32","32","Behind him he leaveth a shining path; One would think the deep to be hoary. ");
INSERT INTO engnoy_vpl VALUES ("JB41_33","019_41_33","JOB","41","33","33","Upon the earth there is not his master; He is made without fear. ");
INSERT INTO engnoy_vpl VALUES ("JB41_34","019_41_34","JOB","41","34","34","He looketh down upon all that is high; He is king over all the sons of pride. ");
INSERT INTO engnoy_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Then Job answered Jehovah, and said: ");
INSERT INTO engnoy_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","I know that thou canst do every thing, And that no purpose of thine can be hindered. ");
INSERT INTO engnoy_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","Who is he that darkeneth counsel by words without knowledge? Thus have I uttered what I understood not; Things too wonderful for me, which I knew not: ");
INSERT INTO engnoy_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Hear thou, then, I beseech thee, and I will speak! I will ask thee, and do thou instruct me! ");
INSERT INTO engnoy_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","I have heard of thee by the hearing of the ear; But now hath mine eye seen thee. ");
INSERT INTO engnoy_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Wherefore I abhor myself, And repent in dust and ashes. ");
INSERT INTO engnoy_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","And when Jehovah had spoken these words unto Job, he said to Eliphaz the Temanite: “My wrath is kindled against thee, and against thy two friends; for ye have not spoken concerning me that which is right, as hath my servant Job. ");
INSERT INTO engnoy_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Take ye, therefore, seven bullocks and seven rams, and go to my servant Job, and offer for yourselves a burnt-offering, and my servant Job shall pray for you; for to him alone will I have regard; that I deal not with you according to your folly. For ye have not spoken concerning me that which is right, as hath my servant Job.” ");
INSERT INTO engnoy_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","So Eliphaz the Temanite, and Bildad the Shuhite, and Zophar the Naamathite, went and did as Jehovah commanded them; and Jehovah had regard to Job. ");
INSERT INTO engnoy_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","And Jehovah turned the captivity of Job, when he prayed for his friends, and Jehovah gave him twice as much as he had before. ");
INSERT INTO engnoy_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Then came to him all his brethren, and all his sisters, and all his former acquaintances, and ate bread with him in his house; and condoled with him, and comforted him over all the evil which Jehovah had brought upon him; and every one gave him a piece of money a kesita, and every one a ring of gold. ");
INSERT INTO engnoy_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Thus Jehovah blessed the latter end of Job more than the beginning; for he had fourteen thousand sheep, six thousand camels, a thousand yoke of oxen, and a thousand she-asses. ");
INSERT INTO engnoy_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","He had also seven sons, and three daughters. ");
INSERT INTO engnoy_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","And he called the name of the first Jemima, of the second Kezia, and of the third Kerenhappuch. ");
INSERT INTO engnoy_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","And in all the land were no women found so fair as the daughters of Job; and their father gave them an inheritance among their brethren. ");
INSERT INTO engnoy_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","And Job lived after this a hundred and forty years, and saw his sons, and his sons' sons, even four generations. ");
INSERT INTO engnoy_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Then Job died, being old and satisfied with days. ");
INSERT INTO engnoy_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","“BOOK I” Happy the man who walketh not in the counsel of the unrighteous, Nor standeth in the way of sinners, Nor sitteth in the seat of scoffers; ");
INSERT INTO engnoy_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","But whose delight is in the law of the LORD, And who meditateth on his precepts day and night. ");
INSERT INTO engnoy_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","He is like a tree planted by streams of water, That bringeth forth its fruit in its season, Whose leaves also do not wither: All that he doeth shall prosper. ");
INSERT INTO engnoy_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Not so the unrighteous; They are like chaff, which the wind driveth away. ");
INSERT INTO engnoy_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Therefore the wicked shall not stand in judgment, Nor sinners in the assembly of the just. ");
INSERT INTO engnoy_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","For the LORD knoweth the way of the righteous, But the way of the wicked leadeth to ruin. ");
INSERT INTO engnoy_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Why do the heathen rage, And the nations meditate a vain thing? ");
INSERT INTO engnoy_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Why do the kings of the earth rise up, And the princes combine together, Against Jehovah, and against his anointed king? ");
INSERT INTO engnoy_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Let us break their bonds asunder; Let us cast away from us their fetters!” ");
INSERT INTO engnoy_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","He that sitteth in heaven will laugh; The Lord will have them in derision. ");
INSERT INTO engnoy_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Then shall he speak to them in his wrath, And confound them in his hot displeasure. ");
INSERT INTO engnoy_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“I myself have anointed my king, Upon Zion, my holy hill!” ");
INSERT INTO engnoy_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","I will declare the decree of Jehovah: He hath said to me, “Thou art my son; This day I have begotten thee. ");
INSERT INTO engnoy_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ask of me, and I will give thee the nations for thine inheritance, And the ends of the earth for thy possession. ");
INSERT INTO engnoy_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Thou shalt break them with a rod of iron; Thou shalt dash them in pieces like a potter's vessel.” ");
INSERT INTO engnoy_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Be wise, therefore, O ye kings! Be admonished, ye rulers of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Be subject to Jehovah with awe, And fear with trembling! ");
INSERT INTO engnoy_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Kiss the son, lest He be angry, and ye perish in your way; For soon shall his wrath be kindled. Happy are all they who seek refuge in him. ");
INSERT INTO engnoy_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","“A Psalm of David, when he fled from his son Absalom.” How many, O LORD, are mine enemies! How many are they who rise up against me! ");
INSERT INTO engnoy_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","How many are they who say of me, “There is no help for him with God”! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","But thou, O LORD! art my shield, My glory, and the lifter-up of my head. ");
INSERT INTO engnoy_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","I call upon the LORD with my voice, And he heareth me from his holy hill. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","I lay me down and sleep; I awake, for the LORD sustaineth me. ");
INSERT INTO engnoy_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","I will not fear the ten thousands of people Who on every side set themselves against me. ");
INSERT INTO engnoy_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Arise, O LORD! Save me, O my God! For thou smitest the cheek of all my enemies; Thou breakest the teeth of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Deliverance cometh from the LORD: May thy blessing be with thy people! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","“For the leader of the music; to be accompanied with stringed instruments. A psalm of David.” Hear me, when I call, O God of my righteousness! Thou hast helped me, when I was in trouble,—Have pity upon me, and hear my prayer! ");
INSERT INTO engnoy_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","How long, O men! will ye dishonor my dignity? How long will ye love vanity, and seek disappointment? Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Know ye that the LORD hath exalted one that is devoted to him; The LORD will hear, when I call upon him. ");
INSERT INTO engnoy_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Stand in awe, and sin no more; Commune with your hearts upon your beds, and desist! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Offer sacrifices of righteousness, And put your trust in the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","There are many who say, Who will show us any good? LORD, lift thou up the light of thy countenance upon us! ");
INSERT INTO engnoy_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Thou puttest gladness into my heart, Greater than theirs, when their corn and wine are abundant. ");
INSERT INTO engnoy_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","I will lay me down in peace, and sleep: For thou alone, O LORD! makest me dwell in safety. ");
INSERT INTO engnoy_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","“For the leader of the music; to be accompanied with wind instruments. A psalm of David.” Give ear to my words, O LORD; Have regard to my cry! ");
INSERT INTO engnoy_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Listen to the voice of my supplication, my King and my God! For to thee do I address my prayer. ");
INSERT INTO engnoy_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","In the morning shalt thou hear my voice, O LORD! In the morning will I address my prayer to thee, and look for help. ");
INSERT INTO engnoy_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","For thou art not a God that hath pleasure in wickedness; The unrighteous man dwelleth not with thee. ");
INSERT INTO engnoy_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","The haughty shall not stand in thy sight; Thou hatest all that do iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Thou destroyest them that speak falsehood; The man of blood and deceit the LORD abhorreth. ");
INSERT INTO engnoy_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","But I, through thy great goodness, will come to thy house; In thy fear will I worship at thy holy temple. ");
INSERT INTO engnoy_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Lead me, O LORD! in thy righteousness, because of mine enemies; Make thy path straight before my face! ");
INSERT INTO engnoy_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","For in their mouth there is no truth; Their heart is malignity; Their throat is an open sepulchre; They flatter with their tongue. ");
INSERT INTO engnoy_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Requite them, O God! Let them be confounded in their devices; Cast them out for the multitude of their transgressions; For against thee have they rebelled! ");
INSERT INTO engnoy_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","But let all, that put their trust in thee, rejoice; Let them ever shout for joy, because thou defendest them; Let them, that love thy name, be joyful in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","For thou, O LORD! dost bless the righteous; With favor dost thou encompass him, as with a shield. ");
INSERT INTO engnoy_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","“For the leader of the music; to be accompanied with stringed instruments; to the octave. A psalm of David.” O LORD! rebuke me not in thine anger; Chasten me not in thy hot displeasure! ");
INSERT INTO engnoy_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Have pity upon me, O LORD! for I am weak; Heal me, O LORD! for my bones tremble! ");
INSERT INTO engnoy_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","My soul, also, is sore troubled; And thou, O LORD! how long—? ");
INSERT INTO engnoy_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Return, O LORD! and deliver me; Oh, save me according to thy mercy! ");
INSERT INTO engnoy_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","For in death no praise is given to thee; In the underworld who can give thee thanks? ");
INSERT INTO engnoy_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","I am weary with my groaning; All the night I make my bed to swim, And drench my couch with my tears. ");
INSERT INTO engnoy_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Mine eye is wasted with grief; It hath become old because of all my enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Depart from me, all ye that do iniquity; For the LORD heareth the voice of my weeping. ");
INSERT INTO engnoy_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","The LORD heareth my supplication; The LORD accepteth my prayer. ");
INSERT INTO engnoy_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","All my enemies shall be ashamed and utterly confounded; They shall be turned back, and put to shame suddenly. ");
INSERT INTO engnoy_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","“A psalm of David, which he sang to Jehovah, on account of the reproaches of Cush the Benjamite.” O Jehovah, my God! to thee do I look for help; Save me from them that persecute me, and deliver me! ");
INSERT INTO engnoy_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Lest mine enemy tear me like a lion; Lest he rend me in pieces, while there is none to help. ");
INSERT INTO engnoy_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","O Jehovah, my God! if I have done this,—If there be iniquity upon my hands, ");
INSERT INTO engnoy_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","If I have rendered evil to my friend, Or have despoiled him that without cause is mine enemy,— ");
INSERT INTO engnoy_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Let my adversary pursue and take me; Let him trample me to the ground, And lay me prostrate in the dust! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Arise, O LORD! in thine anger; Lift thyself up against the rage of mine enemies; Awake for me, ordain judgment! ");
INSERT INTO engnoy_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Let the assembly of the nations compass thee about, And on their account return to the height! ");
INSERT INTO engnoy_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","The LORD judgeth the nations; Judge me, O LORD! according to my righteousness, And requite me according to my integrity! ");
INSERT INTO engnoy_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Oh, let the wickedness of the wicked be at an end; But establish the righteous! For the righteous God trieth the heart and the reins. ");
INSERT INTO engnoy_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","My shield is with God, Who saveth the upright in heart. ");
INSERT INTO engnoy_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","God is a righteous judge, And a God who is angry every day. ");
INSERT INTO engnoy_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","If he do not desist, He sharpeneth his sword; He bendeth his bow, and maketh it ready; ");
INSERT INTO engnoy_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","He prepareth for him the instruments of death; He shooteth his burning arrows. ");
INSERT INTO engnoy_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Behold, he travailed with iniquity, And conceived mischief, But hath brought forth disappointment! ");
INSERT INTO engnoy_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","He made a pit and digged it. And is fallen into the ditch which he made. ");
INSERT INTO engnoy_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","His mischief returneth upon his own head, And his violence cometh down upon his own skull. ");
INSERT INTO engnoy_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","I will praise the LORD according to his righteousness; I will sing praise to the name of the LORD most high. ");
INSERT INTO engnoy_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","“For the leader of the music; to be accompanied with the gittith. A psalm of David.” O Jehovah, our Lord! How excellent is thy name in all the earth! Thou hast set thy glory above the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Out of the mouths of babes and sucklings hast thou ordained praise, To put thine adversaries to shame, And to silence the enemy and avenger. ");
INSERT INTO engnoy_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","When I consider thy heavens, the work of thy fingers, The moon and the stars which thou hast ordained: ");
INSERT INTO engnoy_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","What is man, that thou art mindful of him, And the son of man, that thou carest for him? ");
INSERT INTO engnoy_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Yet thou hast made him little lower than God; Thou hast crowned him with glory and honor. ");
INSERT INTO engnoy_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Thou hast given him dominion over the works of thy hands; Thou hast put all things under his feet,— ");
INSERT INTO engnoy_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","All sheep and oxen, Yea, and the beasts of the forest; ");
INSERT INTO engnoy_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","The birds of the air, and the fishes of the sea, And whatever passeth through the paths of the deep. ");
INSERT INTO engnoy_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Jehovah, our Lord, How excellent is thy name in all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","“For the leader of the music; to be sung in the manner or with the voice of maidens. To the Benites, or to Ben. A psalm of David.” I will praise thee, O LORD! with my whole heart; I will show forth all thy marvellous works. ");
INSERT INTO engnoy_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","I will be glad and rejoice in thee: I will sing praise to thy name, O thou Most High! ");
INSERT INTO engnoy_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","All my enemies are turned back; They fall and perish at thy presence. ");
INSERT INTO engnoy_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","For thou dost defend my right and my cause; Thou sittest upon the throne, a righteous judge. ");
INSERT INTO engnoy_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Thou rebukest the nations; Thou destroyest the wicked; Thou blottest out their name for evermore! ");
INSERT INTO engnoy_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","The enemy is fallen,—a desolation for ever! Thou, O LORD! hast destroyed their cities; Their memory itself hath perished! ");
INSERT INTO engnoy_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","The LORD reigneth for ever; He hath prepared his throne for judgment. ");
INSERT INTO engnoy_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","He judgeth the world in righteousness; He administereth judgment to the nations with uprightness. ");
INSERT INTO engnoy_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yea, the LORD is a refuge for the oppressed; A refuge in times of trouble. ");
INSERT INTO engnoy_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","They who know thy name put their trust in thee; For thou, O LORD! forsakest not them that seek thee! ");
INSERT INTO engnoy_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Sing praises to the LORD, who reigneth in Zion; Declare his doings among the people! ");
INSERT INTO engnoy_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","As the avenger of blood, he remembereth the distressed; He forgetteth not their complaint. ");
INSERT INTO engnoy_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","“Have pity upon me, said I, O LORD! Look upon my affliction through them that hate me; Lift me up from the gates of death: ");
INSERT INTO engnoy_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","That I may show forth all thy praise in the gates of the daughter of Zion; That I may rejoice in salvation by thee.” ");
INSERT INTO engnoy_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","The nations have sunk into the pit which they made; In the net, which they hid, is their own foot taken. ");
INSERT INTO engnoy_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Thus it is known that the LORD executeth judgment; The wicked are ensnared in the work of their own hands. Stringed instruments. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","The wicked shall be driven into the underworld; Yea, all the nations that forger God. ");
INSERT INTO engnoy_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","For the poor shall not always be forgotten; The hopes of the afflicted shall not perish for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Arise, O LORD! Let not man prevail; Let the nations be judged by thee! ");
INSERT INTO engnoy_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Strike terror into them, O LORD! Let the nations know that they are but men! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Why standest thou afar off, O LORD? Why hidest thou thyself in times of trouble? ");
INSERT INTO engnoy_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Through the haughtiness of the wicked the poor are in distress; They are caught in the wiles which are contrived for them. ");
INSERT INTO engnoy_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","The wicked boasteth of his heart's desire; The rapacious renounceth and contemneth Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","The wicked saith in his haughtiness, “He careth not!” All his thoughts are, “There is no God.” ");
INSERT INTO engnoy_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","His course is always prosperous; Far in the heights are thy judgments from him; As for all his enemies, he puffeth at them. ");
INSERT INTO engnoy_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","He saith in his heart, “I shall never fall; I shall never be in adversity.” ");
INSERT INTO engnoy_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","His mouth is full of perjury, deceit, and oppression; Mischief and injustice are upon his tongue. ");
INSERT INTO engnoy_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","He sitteth in the lurking-places of the villages; In secret places doth he murder the innocent; His eyes are secretly fixed upon the poor. ");
INSERT INTO engnoy_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","He secretly lieth in wait, like a lion in a thicket; He lieth in wait to seize upon the helpless; He catcheth the poor, drawing him into his net. ");
INSERT INTO engnoy_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","He croucheth, and lowereth himself, And the wretched fall into his paws. ");
INSERT INTO engnoy_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","He saith in his heart, “God doth forget; He hideth his face; he doth never see it.” ");
INSERT INTO engnoy_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Arise, O LORD! O God, lift up thine hand: Forget not the distressed! ");
INSERT INTO engnoy_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Wherefore doth the wicked contemn God, And say in his heart, “He careth not for it”? ");
INSERT INTO engnoy_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Thou dost see it; yea, thou beholdest malice and oppression, And markest it upon thy hand! The poor committeth himself to thee; Thou art the helper of the fatherless. ");
INSERT INTO engnoy_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Break thou the arm of the unjust and wicked man; Seek out his wickedness, till thou canst find none! ");
INSERT INTO engnoy_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Jehovah is king for ever and ever; The gentiles shall perish out of his land. ");
INSERT INTO engnoy_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Thou, O LORD! wilt hear the desires of the distressed; Thou wilt strengthen their hearts; Thou wilt lend a listening ear! ");
INSERT INTO engnoy_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Thou wilt maintain the cause of the fatherless and the oppressed, That henceforth none may be driven from the land. ");
INSERT INTO engnoy_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","“For the leader of the music. A psalm of David.” In the LORD do I put my trust. Why say ye to me, “Flee, like a bird, to your mountain? ");
INSERT INTO engnoy_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","For, lo! the wicked bend their bow; They make ready their arrows on the string, To shoot in secret at the upright in heart. ");
INSERT INTO engnoy_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","If the pillars be broken down, What can the righteous do?” ");
INSERT INTO engnoy_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","The LORD is in his holy palace; The LORD'S throne is in heaven; His eyes behold, his eyelids prove the children of men. ");
INSERT INTO engnoy_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","The LORD trieth the righteous; But the wicked, and the lover of violence, his soul hateth. ");
INSERT INTO engnoy_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Upon the wicked he will rain lightning; Fire and brimstone and a burning wind shall be the portion of their cup. ");
INSERT INTO engnoy_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","For the LORD is righteous; he loveth righteousness; The upright shall see his face. ");
INSERT INTO engnoy_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","“For the leader of the music; to the octave. A psalm of David.” Help, LORD; for the godly man ceaseth; The faithful are failing among men. ");
INSERT INTO engnoy_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","They speak falsehood one to another; With flattering lips, with a double heart, do they speak. ");
INSERT INTO engnoy_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","May the LORD destroy all flattering lips, And the tongue which speaketh proud things! ");
INSERT INTO engnoy_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Who say, “With our tongues will we prevail; Our lips are our reliance; Who is lord over us?” ");
INSERT INTO engnoy_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","For the oppression of the poor and the sighing of the wretched, Now will I stand up, saith the LORD; I will set in safety him whom they puff at. ");
INSERT INTO engnoy_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","The words of the LORD are pure; Like silver purified in a furnace on the earth, Seven times refined. ");
INSERT INTO engnoy_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Thou, O LORD! will watch over them; Thou wilt preserve them from this generation for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","The wicked walk on every side, When the vilest of men are exalted. ");
INSERT INTO engnoy_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","“For the leader of the music. A psalm of David.” How long, O LORD! wilt thou forget me for ever? How long wilt thou hide thy face from me? ");
INSERT INTO engnoy_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","How long shall I have anxiety in my soul for ever, And sorrow in my heart all the day? How long shall my enemy be exalted over me? ");
INSERT INTO engnoy_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Look down and hear me, O LORD, my God! Enlighten my eyes, lest I sleep the sleep of death; ");
INSERT INTO engnoy_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Lest my enemy say, “I have prevailed against him!” Lest my adversaries rejoice, when I am fallen. ");
INSERT INTO engnoy_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Yet will I trust in thy goodness; My heart shall rejoice in thy salvation; ");
INSERT INTO engnoy_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","I will sing to the LORD, that he hath dealt kindly with me. ");
INSERT INTO engnoy_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","“For the leader of the music. A psalm of David.” The fool saith in his heart, “There is no God.” They are corrupt; abominable are their doings; There is none that doeth good. ");
INSERT INTO engnoy_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Jehovah looketh down from heaven upon the children of men, To see if there are any that have understanding, That have regard to God. ");
INSERT INTO engnoy_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","They are all gone out of the way; together are they corrupt; There is none that doeth good—no, not one. ");
INSERT INTO engnoy_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Shall not the evil-doers be requited, Who devour my people like bread, And call not upon Jehovah? ");
INSERT INTO engnoy_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Yea, then shall they be in great fear; For Jehovah is with the race of the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ye would put to shame the counsel of the poor; But Jehovah is their refuge. ");
INSERT INTO engnoy_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Oh that salvation for Israel would come out of Zion! When Jehovah bringeth back the captives of his people, Then shall Jacob rejoice, and Israel be glad. ");
INSERT INTO engnoy_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","“A psalm of David.” LORD, who shall abide at thy tabernacle? Who shall dwell upon thy holy hill? ");
INSERT INTO engnoy_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","He that walketh uprightly, and doeth righteousness, And speaketh the truth from his heart; ");
INSERT INTO engnoy_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","He that slandereth not with his tongue, That doeth no injury to his neighbor, And uttereth no reproach against his neighbor; ");
INSERT INTO engnoy_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","In whose eyes a vile person is contemned; But who honoreth them that fear the LORD; Who sweareth to his own hurt, and changeth not; ");
INSERT INTO engnoy_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","He that lendeth not his money for interest, And taketh not a bribe against the innocent: He that doeth these things shall never be moved. ");
INSERT INTO engnoy_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","“A psalm off David.” Preserve me, O God! for to thee do I look for help. ");
INSERT INTO engnoy_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","I have said to Jehovah, Thou art my Lord; I have no happiness beyond thee! ");
INSERT INTO engnoy_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","The holy that are in the land, and the excellent,—in them is all my delight. ");
INSERT INTO engnoy_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","They who hasten after other gods shall have multiplied sorrows; Their drink-offerings of blood I will not offer, Nor will I take their names upon my lips. ");
INSERT INTO engnoy_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Jehovah is my portion and my cup; Thou wilt maintain my lot! ");
INSERT INTO engnoy_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","My portion hath fallen to me in pleasant places; Yea, I have a goodly inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","I will bless the LORD, who careth for me; Yea, in the night my heart admonisheth me. ");
INSERT INTO engnoy_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","I set the LORD before me at all times; Since he is at my right hand, I shall not fall. ");
INSERT INTO engnoy_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Therefore my heart is glad, and my spirit rejoiceth; Yea, my flesh dwelleth in security. ");
INSERT INTO engnoy_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","For thou wilt not give me up to the underworld; Nor wilt thou suffer thy holy one to see the pit. ");
INSERT INTO engnoy_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Thou wilt show me the path of life; In thy presence is fulness of joy; At thy right hand are pleasures for evermore. ");
INSERT INTO engnoy_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","“A psalm of David.” Hear the righteous cause, O LORD! Attend to my cry; Give ear to my prayer from lips without deceit! ");
INSERT INTO engnoy_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","May my sentence come forth from thy presence; May thine eyes behold uprightness! ");
INSERT INTO engnoy_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Provest thou my heart, visitest thou me in the night, Triest thou me like gold, thou shalt find nothing! ");
INSERT INTO engnoy_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","My thoughts do not vary from my lips. As to the deeds of men, Through the word of thy lips I have kept me from the paths of the destroyer. ");
INSERT INTO engnoy_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Support my steps in thy paths, That my feet may not slip! ");
INSERT INTO engnoy_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","I call upon thee, O God! for thou wilt hear me; Incline thine ear to me, and listen to my prayer! ");
INSERT INTO engnoy_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Show forth thy loving-kindness, O thou that savest by thy right hand Them that seek refuge in thee from their adversaries! ");
INSERT INTO engnoy_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Guard me as the apple of the eye; Hide me under the shadow of thy wings ");
INSERT INTO engnoy_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","From the wicked who assault me, From my deadly enemies who compass me about! ");
INSERT INTO engnoy_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","They shut up their hard heart; With their mouth they speak haughtily. ");
INSERT INTO engnoy_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","They encompass us in all our steps; They fix their eyes upon us, that they may cast us on the ground. ");
INSERT INTO engnoy_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","They are like a lion, eager for his prey; Like a young lion, lurking in secret places. ");
INSERT INTO engnoy_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Arise, O LORD! disappoint them, cast them down! Deliver me from the wicked by thy sword, ");
INSERT INTO engnoy_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","From men, by thy hand, O LORD! from men of the world, Whose portion is in life; whom thou loadest with thy treasure; Whose children have enough, and leave their superfluity to their children. ");
INSERT INTO engnoy_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","But I through righteousness shall see thy face; I shall be satisfied with the revival of thy countenance. ");
INSERT INTO engnoy_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","I love thee, O LORD, my strength! ");
INSERT INTO engnoy_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Jehovah is my rock, my fortress, and my deliverer; My God, my strength, in whom I trust; My shield, my strong defence, and my high tower. ");
INSERT INTO engnoy_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","I called upon the LORD, who is worthy to be praised, And was delivered from my enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","The snares of death encompassed me; The floods of destruction filled me with dismay; ");
INSERT INTO engnoy_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","The snares of the underworld surrounded me, And the nets of death seized upon me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","In my distress I called upon the LORD, And cried unto my God; He heard my voice from his palace, And my cry came before him into his ears. ");
INSERT INTO engnoy_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Then the earth quaked and trembled; The foundations of the mountains rocked and were shaken, Because his wrath was kindled. ");
INSERT INTO engnoy_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","A smoke went up from his nostrils, And fire from his mouth devoured; Burning coals shot forth from him. ");
INSERT INTO engnoy_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","He bowed the heavens, and came down; And darkness was under his feet; ");
INSERT INTO engnoy_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","And he rode upon a cherub, and did fly; Yea, he did fly upon the wings of the wind. ");
INSERT INTO engnoy_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","And he made darkness his covering; His pavilion round about him was dark waters and thick clouds of the skies. ");
INSERT INTO engnoy_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","At the brightness before him, his thick clouds passed away; Then came hailstones and coals of fire. ");
INSERT INTO engnoy_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","The LORD also thundered from heaven, And the Most High uttered his voice, Amid hailstones and coals of fire. ");
INSERT INTO engnoy_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","He sent forth his arrows, and scattered them; Continual lightnings, and discomfited them. ");
INSERT INTO engnoy_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Then the channels of the deep were seen, And the foundations of the earth were laid bare At thy rebuke, O LORD! At the blast of the breath of thy nostrils. ");
INSERT INTO engnoy_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","He stretched forth his hand from above; he took me, And drew me out of deep waters. ");
INSERT INTO engnoy_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","He delivered me from my strong enemy; From my adversaries, who were too powerful for me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","They fell upon me in the day of my calamity; But the LORD was my stay. ");
INSERT INTO engnoy_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","He brought me forth into a large place; He delivered me, because he delighted in me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","The LORD hath rewarded me according to my righteous; According to the cleanness of my hands hath he recompensed me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","For I have kept the ways of the LORD, And have not wickedly departed from my God. ");
INSERT INTO engnoy_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","For all his laws were in my sight; I did not put away his statutes from me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","I was upright before him, And kept myself from iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Therefore hath the LORD rewarded me according to my righteousness, According to the cleanness of my hands before his eyes. ");
INSERT INTO engnoy_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","To the merciful thou showest thyself merciful; To the upright thou showest thyself upright; ");
INSERT INTO engnoy_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","To the pure thou showest thyself pure, And to the perverse thou showest thyself perverse. ");
INSERT INTO engnoy_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","For thou savest the afflicted people, But the haughty countenance thou bringest down. ");
INSERT INTO engnoy_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Thou causest my lamp to shine; Jehovah, my God, enlighteneth my darkness. ");
INSERT INTO engnoy_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","For through thee I have broken through troops; Through my God I have leaped over walls. ");
INSERT INTO engnoy_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","The ways of God are just and true; His word is pure, tried in the fire; He is a shield to all who put their trust in him. ");
INSERT INTO engnoy_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Who, then, is God, save Jehovah? And who is a rock, save our God? ");
INSERT INTO engnoy_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","It is God that girded me with strength, And made my way plain. ");
INSERT INTO engnoy_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","He made my feet like the hind's, And set me in my high places; ");
INSERT INTO engnoy_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","He taught my hands to war, So that my arm bent the bow of brass. ");
INSERT INTO engnoy_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Thou gavest me the shield of thy protection; Thy right hand held me up, And thy goodness made me great. ");
INSERT INTO engnoy_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Thou didst make a wide path for my steps, So that my feet did not stumble. ");
INSERT INTO engnoy_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","I pursued my enemies and overtook them, And turned not back till I had destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","I smote them, so that they could not rise; They fell under my feet. ");
INSERT INTO engnoy_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Thou didst gird me with strength for the battle; Thou didst cast down my adversaries under me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Thou didst cause my enemies to turn their backs, So that I destroyed them that hated me. ");
INSERT INTO engnoy_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","They cried, but there was none to help; To Jehovah, but he answered them not. ");
INSERT INTO engnoy_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","I beat them small, like dust before the wind; I cast them out as the dirt of the streets. ");
INSERT INTO engnoy_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Thou hast delivered me from the assaults of the nations; Thou hast made me the head of the kingdoms. Nations whom I knew not serve me; ");
INSERT INTO engnoy_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","They who have only heard of me obey me; Yea, men of a strange land submit themselves to me; ");
INSERT INTO engnoy_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Men of a strange land fade away, like a leaf, And come trembling from their strongholds. ");
INSERT INTO engnoy_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Jehovah is the living God; blessed be my rock; Exalted be the God of my salvation! ");
INSERT INTO engnoy_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","It is God who hath given me vengeance, And subdued the nations under me; ");
INSERT INTO engnoy_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","He delivered me from my enemies; Yea, thou hast lifted me up above my adversaries; Thou hast saved me from the violent man! ");
INSERT INTO engnoy_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Therefore I will give thanks to thee, O LORD! among the nations, And sing praises to thy name. ");
INSERT INTO engnoy_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Great deliverance giveth he to his king, And showeth mercy to his anointed,—To David and to his posterity for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","“For the leader of the music. A psalm of David.” The heavens declare the glory of God; The firmament showeth forth the work of his hands. ");
INSERT INTO engnoy_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Day uttereth instruction unto day, And night showeth knowledge unto night. ");
INSERT INTO engnoy_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","They have no speech nor language, And their voice is not heard; ");
INSERT INTO engnoy_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Yet their sound goeth forth to all the earth, And their words to the ends of the world. In them hath he set a tabernacle for the sun, ");
INSERT INTO engnoy_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Which cometh forth like a bridegroom from his chamber, And rejoiceth, like a strong man, to run his course. ");
INSERT INTO engnoy_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","He goeth forth from the extremity of heaven, And maketh his circuit to the end of it; And nothing is hid from his heat. ");
INSERT INTO engnoy_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","The law of the LORD is perfect, reviving the soul; The precepts of the LORD are sure, making wise the simple; ");
INSERT INTO engnoy_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","The statutes of the LORD are right, rejoicing the heart; The commandments of the LORD are pure, enlightening the eyes; ");
INSERT INTO engnoy_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","The fear of the LORD is clean, enduring for ever; The judgments of the LORD are true and righteous altogether. ");
INSERT INTO engnoy_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","More precious are they than gold; yea, than much fine gold; Sweeter than honey and the honeycomb. ");
INSERT INTO engnoy_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","By them also is thy servant warned, And in keeping of them there is great reward. ");
INSERT INTO engnoy_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Who knoweth his own offences? Oh, cleanse thou me from secret faults! ");
INSERT INTO engnoy_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Keep back also thy servant from presumptuous sins; Let them not have dominion over me! Then shall I be upright; I shall not be polluted with gross transgression. ");
INSERT INTO engnoy_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","May the words of my mouth and the meditation of my heart Be acceptable in thy sight, O LORD, my strength and my redeemer! ");
INSERT INTO engnoy_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","“For the leader of the music. A psalm of David.” May Jehovah hear thee in the day of trouble; May the name of the God of Jacob defend thee! ");
INSERT INTO engnoy_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","May he send thee help from his sanctuary, And strengthen thee out of Zion! ");
INSERT INTO engnoy_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","May he have regard to all thine offerings, And accept thy burnt sacrifice! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","May he grant thee thy heart's desire, And fulfill all thy purposes! ");
INSERT INTO engnoy_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","We will rejoice in thy protection, And in the name of our God will we set up our banners, When Jehovah hath fulfilled all thy petitions. ");
INSERT INTO engnoy_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Now I know that Jehovah helpeth his anointed; That he heareth him from his holy heaven, And aideth him with the saving strength of his right hand. ");
INSERT INTO engnoy_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Some glory in chariots, and some in horses, But we in the name of Jehovah our God. ");
INSERT INTO engnoy_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","They stumble and fall, But we stand and are erect. ");
INSERT INTO engnoy_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","The LORD save the king! May he hear us when we call! ");
INSERT INTO engnoy_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","“For the leader of the music. A psalm of David.” The king rejoiceth in thy strength, O LORD! Yea, he doth greatly exult in thy protection. ");
INSERT INTO engnoy_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Thou hast given him his heart's desire, And hast not denied him the request of his lips. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Yea, thou hast met him with rich blessings, Thou hast placed a crown of pure gold upon his head. ");
INSERT INTO engnoy_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","He asked life of thee; thou gavest it him; Even long life, enduring for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Great is his glory through thine aid; Honor and majesty hast thou laid upon him. ");
INSERT INTO engnoy_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Thou hast made him blessed for evermore; Thou hast made him glad with the joy of thy countenance. ");
INSERT INTO engnoy_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","For the king trusteth in the LORD; And through the goodness of the Most High he shall never fall. ");
INSERT INTO engnoy_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Thy hand shall overtake all thine enemies; Thy right hand shall overtake them that hate thee. ");
INSERT INTO engnoy_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Thou wilt make them like a burning oven in the time of thine anger; Jehovah shall swallow them up in his wrath, And the fire shall devour them. ");
INSERT INTO engnoy_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Their offspring shalt thou destroy from the earth, And their posterity from the sons of men. ");
INSERT INTO engnoy_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","For they spread a net of mischief against thee; They devised plots against thee, but they did not prevail. ");
INSERT INTO engnoy_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Therefore thou wilt cause them to turn their backs; Thou wilt make ready thine arrows upon the strings against them. ");
INSERT INTO engnoy_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Exalt thyself, O LORD! by thy strength! So will we sing, and praise thy mighty deeds. ");
INSERT INTO engnoy_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","“For the leader of the music. To the tune of “The hind of the morning.” A psalm of David.” My God, my God! why hast thou forsaken me? Why so far from mine aid, and from the words of my cry? ");
INSERT INTO engnoy_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","O my God! I cry during the day, but thou hearest not; In the night also, but I have no rest. ");
INSERT INTO engnoy_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","And yet thou art holy, Dwelling amid the praises of Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Our fathers trusted in thee; They trusted, and thou didst save them. ");
INSERT INTO engnoy_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","They called upon thee, and were delivered; They trusted in thee, and were not put to shame. ");
INSERT INTO engnoy_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","But I am a worm, and not a man; The reproach of men, and the scorn of the people. ");
INSERT INTO engnoy_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","All who see me scoff at me; They open wide the lips; they shake the head. ");
INSERT INTO engnoy_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“He trusted in the LORD, let him help him; Let him deliver him, since he delighted in him!” ");
INSERT INTO engnoy_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Surely thou art he that didst bring me into the world; Thou didst make me lie secure upon my mother's breast! ");
INSERT INTO engnoy_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Upon thee have I cast myself from my birth; Thou hast been my God from my earliest breath! ");
INSERT INTO engnoy_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Oh, be not far from me, for trouble is near; For there is none to help! ");
INSERT INTO engnoy_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Many bulls surround me; Strong bulls of Bashan close me in on every side. ");
INSERT INTO engnoy_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","They open their mouths wide against me, Like a ravening and roaring lion. ");
INSERT INTO engnoy_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","I am poured out like water, And all my bones are out of joint; My heart is become like wax; It melteth in my bosom. ");
INSERT INTO engnoy_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","My strength is dried up like an earthen vessel, And my tongue cleaveth to my jaws; Thou hast brought me to the dust of death! ");
INSERT INTO engnoy_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","For dogs have surrounded me; Bands of evil-doers have encompassed me,—Like lions my hands and my feet. ");
INSERT INTO engnoy_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","I can count all my bones; They gaze, and feast their eyes upon me. ");
INSERT INTO engnoy_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","They divide my garments among them, And for my vesture they cast lots. ");
INSERT INTO engnoy_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","But be not thou far from me, O LORD! O my strength! make haste to mine aid! ");
INSERT INTO engnoy_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Deliver my life from the sword; My blood from the power of the dog; ");
INSERT INTO engnoy_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Save me from the lion's mouth; Shield me from the horns of the buffaloes! ");
INSERT INTO engnoy_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","I will proclaim thy name to my brethren; In the midst of the congregation will I praise thee. ");
INSERT INTO engnoy_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Praise him, ye worshippers of Jehovah! Extol him, all ye race of Jacob. And fear him, all ye race of Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","For he hath not despised nor abhorred the misery of the afflicted. Nor hath he hid his face from him; But when he cried unto him, he heard. ");
INSERT INTO engnoy_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","My praise shall be of thee in the great congregation; I will pay my vows before them that fear him! ");
INSERT INTO engnoy_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","The afflicted shall eat, and be satisfied; They that seek the LORD shall praise him; Your hearts shall be glad for ever and ever! ");
INSERT INTO engnoy_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","All the ends of the earth shall remember, and turn to Jehovah; All the families of the nations shall worship before thee! ");
INSERT INTO engnoy_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","For the kingdom is Jehovah's; He is the governor of the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","All the rich of the earth shall eat and worship; Before him shall they also bow, who are going down to the dust, Who cannot keep themselves alive. ");
INSERT INTO engnoy_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","The future generation shall serve him; The race which is to come shall hear of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","They shall come, and declare his righteousness; His mighty deeds to the people that shall be born. ");
INSERT INTO engnoy_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","“A psalm of David.” The LORD is my shepherd: I shall not want. ");
INSERT INTO engnoy_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","He maketh me to lie down in green pastures; He leadeth me beside the still waters. ");
INSERT INTO engnoy_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","He reviveth my soul; He leadeth me in paths of safety, For his name's sake. ");
INSERT INTO engnoy_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","When I walk through a valley of deathlike shade, I fear no evil; for thou art with me; Thy crook and thy staff, they comfort me. ");
INSERT INTO engnoy_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Thou preparest a table before me In the presence of mine enemies. Thou anointest my head with oil; My cup runneth over. ");
INSERT INTO engnoy_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Surely goodness and mercy shall follow me all the days of my life, And I shall dwell in the house of the LORD for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","“A psalm of David.” The earth is the LORD'S, and all that is therein; The world, and they who inhabit it. ");
INSERT INTO engnoy_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","For he hath founded it upon the seas, And established it upon the floods. ");
INSERT INTO engnoy_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Who shall ascend the hill of the LORD? And who shall stand in his holy place? ");
INSERT INTO engnoy_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","He that hath clean hands and a pure heart; Who hath not inclined his soul to falsehood, Nor sworn deceitfully. ");
INSERT INTO engnoy_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","He shall receive a blessing from the LORD, And favor from the God of his salvation. ");
INSERT INTO engnoy_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","This is the race of them that seek him; They that seek thy face are Jacob. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Lift up your heads, O ye gates! Lift yourselves up, ye everlasting doors, That the king of glory may come in! ");
INSERT INTO engnoy_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","“Who is this king of glory?” Jehovah, strong and mighty; Jehovah, mighty in battle. ");
INSERT INTO engnoy_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Lift up your heads, O ye gates! Lift yourselves up, ye everlasting doors, That the king of glory may enter in! ");
INSERT INTO engnoy_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","“Who is this king of glory?” Jehovah, God of hosts, he is the king of glory. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","“A psalm of David.” To thee, O LORD! do I lift up my soul. ");
INSERT INTO engnoy_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O my God! I trust in thee; let me not be put to shame! Let not my enemies triumph over me! ");
INSERT INTO engnoy_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Yea, none that hope in thee shall be put to shame: They shall be put to shame who wickedly forsake thee. ");
INSERT INTO engnoy_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Cause me to know thy ways, O LORD! Teach me thy paths! ");
INSERT INTO engnoy_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Lead me in thy truth, and teach me! For thou art the God from whom cometh my help; In thee do I trust at all times! ");
INSERT INTO engnoy_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Remember thy loving-kindness, O LORD! and thy tender mercy, Which thou hast exercised of old! ");
INSERT INTO engnoy_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Remember not the faults and transgressions of my youth! According to thy mercy remember thou me, For thy goodness' sake, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Good and righteous is the LORD; Therefore showeth he to sinners the way. ");
INSERT INTO engnoy_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","The humble he guideth in his statutes, And the humble he teacheth his way. ");
INSERT INTO engnoy_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","All the doings of the LORD are mercy and truth To those who keep his covenant and his precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","For thy name's sake, O LORD, Pardon my iniquity; for it is great! ");
INSERT INTO engnoy_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Who is the man that feareth the LORD? Him doth he show the way which he should choose. ");
INSERT INTO engnoy_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","He shall himself dwell in prosperity, And his offspring shall inherit the land. ");
INSERT INTO engnoy_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","The friendship of the LORD is with them that fear him, And he will teach them his covenant. ");
INSERT INTO engnoy_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mine eyes are ever directed to the LORD, For he will pluck my feet from the net. ");
INSERT INTO engnoy_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Look upon me, and pity me; For I am desolate and afflicted! ");
INSERT INTO engnoy_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Lighten the sorrows of my heart, And deliver me from my troubles! ");
INSERT INTO engnoy_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Look upon my affliction and distress, And forgive all my sins! ");
INSERT INTO engnoy_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Consider how many are my enemies, And with what violence they hate me! ");
INSERT INTO engnoy_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Guard thou my life, and deliver me! Let me not be put to shame, for I have trusted in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Let integrity and uprightness preserve me, For on thee do I rest my hope! ");
INSERT INTO engnoy_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Redeem Israel, O God! from all his troubles! ");
INSERT INTO engnoy_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","“A psalm of David.” Be thou my judge, O LORD! for I have walked in uprightness. I have put my trust in the LORD, therefore shall I not fall. ");
INSERT INTO engnoy_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Examine me, O LORD! and prove me; Try my reins and my heart! ");
INSERT INTO engnoy_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","For thy kindness is ever before my eyes, And I walk in thy truth. ");
INSERT INTO engnoy_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","I sit not with men of falsehood. And go not in company with dissemblers. ");
INSERT INTO engnoy_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","I hate the assembly of evil-doers, And do not sit with the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","I wash my hands in innocence. And go around thine altar. O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","To utter the voice of thanksgiving, And tell of all thy wondrous works. ");
INSERT INTO engnoy_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","O LORD! I love the habitation of thy house, The place where thine honor dwelleth! ");
INSERT INTO engnoy_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Gather not my breath with sinners, Nor my life with men of blood, ");
INSERT INTO engnoy_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","In whose hands is mischief, And whose right hands are full of bribes! ");
INSERT INTO engnoy_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","But as for me, I walk in my integrity; Oh, redeem me, and be merciful to me! ");
INSERT INTO engnoy_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","My feet tread in a straight path; In the congregation will I bless the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","“A psalm of David.” The LORD is my light and my salvation; Whom shall I fear? The LORD is the shield of my life; Of whom shall I be afraid? ");
INSERT INTO engnoy_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","When the wicked came upon me to devour me, Even my persecutors and enemies, they stumbled and fell. ");
INSERT INTO engnoy_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Though a host should encamp against me, my heart shall not fear; Though war should rise against me, yet will I be confident. ");
INSERT INTO engnoy_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","One thing have I desired of the LORD; that do I yet seek; That I may dwell in the house of the LORD all the days of my life, To behold the grace of the LORD, And to gaze upon his temple. ");
INSERT INTO engnoy_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","For in the day of trouble he will hide me in his pavilion; Yea, in the secret place of his tabernacle will he shelter me; He will set me upon a rock. ");
INSERT INTO engnoy_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Yea, already doth he lift my head above my enemies, who are around me; Therefore in his tabernacle will I offer sacrifices with the sound of trumpets; I will sing, yea, with instruments of music I will give praise to the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Hear my voice, O LORD! when I cry unto thee; Have pity upon me, and answer me! ");
INSERT INTO engnoy_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","When I think of thy precept, “Seek ye my face!” Thy face, LORD, do I seek. ");
INSERT INTO engnoy_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","O hide not thou thy face from me; Cast not thy servant away in displeasure! Thou hast been my help, do not leave me; Do not forsake me, O God, my helper! ");
INSERT INTO engnoy_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","For my father and my mother have forsaken me; But the LORD will take me up. ");
INSERT INTO engnoy_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Teach me thy way, O LORD! And lead me in the right path, because of my enemies! ");
INSERT INTO engnoy_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Give me not up to the will of my adversaries! For false witnesses have risen up against me, And such as breathe out injustice. ");
INSERT INTO engnoy_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","I trust that I shall see the goodness of the LORD In the land of the living. Hope thou in the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Be of good courage; let thy heart be strong; Hope thou in the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","“A psalm of David.” To thee do I cry, O LORD! O my rock! be not silent to me, Lest, if thou answer me not, I become like those who go down to the pit! ");
INSERT INTO engnoy_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Hear the voice of my supplication, when I cry unto thee, When I lift up my hands to thy most holy sanctuary! ");
INSERT INTO engnoy_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Draw me not away with the impious, and with evil-doers, Who speak peace to their neighbors, while mischief is in their hearts! ");
INSERT INTO engnoy_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Give them according to their deeds, and the wickedness of their doings; Give them according to the work of their hands; Render to them their desert! ");
INSERT INTO engnoy_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","For they regard not the doings of the LORD, nor the work of his hands; Therefore will he destroy them, and not again build them up. ");
INSERT INTO engnoy_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Praised be the LORD, for he hath heard the voice of my supplications! ");
INSERT INTO engnoy_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","The LORD is my strength and my shield; My heart trusteth in him, and he helpeth me; Therefore doth my heart exult, And in my song I will praise him. ");
INSERT INTO engnoy_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Jehovah is the strength of his people; He is the protecting shield of his anointed. ");
INSERT INTO engnoy_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Save thy people, and bless thine inheritance; Feed them also, and build them up for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","“A psalm of David.” Give to Jehovah, O ye sons of God! Give to Jehovah glory and praise! ");
INSERT INTO engnoy_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Give to Jehovah the glory due to his name; Worship Jehovah in holy attire! ");
INSERT INTO engnoy_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","The voice of Jehovah is heard above the waters; The God of glory thundereth,-Jehovah above the great waters. ");
INSERT INTO engnoy_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","The voice of Jehovah is powerful; The voice of Jehovah is full of majesty; ");
INSERT INTO engnoy_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","The voice of Jehovah breaketh the cedars; Yea, Jehovah breaketh the cedars of Lebanon; ");
INSERT INTO engnoy_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yea, he maketh them to leap like a calf,—Lebanon and Sirion like a young buffalo. ");
INSERT INTO engnoy_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","The voice of Jehovah divideth the flames of fire. ");
INSERT INTO engnoy_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","The voice of Jehovah maketh the wilderness tremble; Yea, Jehovah maketh the wilderness of Kadesh tremble. ");
INSERT INTO engnoy_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","The voice of Jehovah maketh the hinds bring forth, And layeth bare the forests; While, in his palace, every one declareth his glory. ");
INSERT INTO engnoy_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Jehovah sitteth above the flood; Yea, Jehovah sitteth king for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Jehovah will give strength to his people; Jehovah will bless his people with peace. ");
INSERT INTO engnoy_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","“A psalm of David. To the air of songs for the dedication of a house.” I will extol thee, O LORD! for thou hast lifted me up, And hast not suffered my enemies to rejoice over me. ");
INSERT INTO engnoy_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Jehovah, my God! I called upon thee, and thou hast healed me! ");
INSERT INTO engnoy_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","O LORD! thou hast raised me up from the underworld; Thou hast kept me alive, that I should not go down to the pit. ");
INSERT INTO engnoy_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Sing unto the LORD, O ye his servants! And praise his holy name! ");
INSERT INTO engnoy_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","For his anger endureth but a moment, But his favor through life; In the evening sorrow may be a guest, But joy cometh in the morning. ");
INSERT INTO engnoy_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","I said in my prosperity, “I shall never be moved!” ");
INSERT INTO engnoy_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Thou, O LORD! by thy favor, hast made my mountain to stand strong; Thou didst hide thy face, and I was troubled! ");
INSERT INTO engnoy_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","I cried unto thee, O LORD! To the LORD I made supplication: ");
INSERT INTO engnoy_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“What will my blood profit thee, that I should go down to the pit? Can dust praise thee? Can it declare thy faithfulness? ");
INSERT INTO engnoy_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Hear, O LORD! and have pity upon me! Be thou, LORD! my helper!” ");
INSERT INTO engnoy_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Thou didst turn my mourning into dancing; Thou didst loose my sackcloth, and gird me with gladness. ");
INSERT INTO engnoy_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Therefore I will sing praise to thee, and not be silent. O Jehovah, my God! I will give thanks to thee for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","“For the leader of the music. A psalm of David.” In thee, O LORD! do I trust; let me never be put to shame; According to thy goodness deliver me! ");
INSERT INTO engnoy_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Bow down thine ear to me; help me speedily! Be to me a strong rock, a high fortress, for my deliverance! ");
INSERT INTO engnoy_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","For thou art my rock and my high fortress; Be thou also my guide, and lead me, for thy name's sake! ");
INSERT INTO engnoy_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Draw me out of the net which they have secretly laid for me, For thou art my strength! ");
INSERT INTO engnoy_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Into thy hand I commit my life; Thou wilt deliver me, O LORD, thou God of truth! ");
INSERT INTO engnoy_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","I hate those who regard lying vanities, And put my trust in the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","I will be glad and rejoice in thy mercy, That thou hast looked upon my trouble, And hast had regard to my distress; ");
INSERT INTO engnoy_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","That thou hast not given me up to the hands of my enemies, But hast set my feet in a wide place. ");
INSERT INTO engnoy_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Have mercy upon me, O LORD! for I am in trouble! My face is consumed with grief; Yea, my spirit and my body. ");
INSERT INTO engnoy_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","For my life is wasted with sorrow, And my years with sighing; My strength faileth by reason of my affliction, And my bones are consumed on account of all my enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","I have become the scorn of my neighbors, And the terror of my acquaintance; They who see me abroad flee from me. ");
INSERT INTO engnoy_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","I am forgotten like a dead man out of mind; I am like a broken vessel. ");
INSERT INTO engnoy_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","I hear the slander of many; fear is on every side; For they take counsel together against me; They devise to take away my life. ");
INSERT INTO engnoy_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","But I trust in thee, O Jehovah! I say, “Thou art my God!” ");
INSERT INTO engnoy_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","My destiny is in thy hand; Deliver me from the power of my enemies and persecutors! ");
INSERT INTO engnoy_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Let thy face shine upon thy servant, And save me through thy mercy! ");
INSERT INTO engnoy_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Let me not be put to shame, O LORD! for I have called upon thee; Let the wicked be put to shame; Let them be silenced in the grave! ");
INSERT INTO engnoy_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Let lying lips be put to silence, Which speak proud things against the righteous, With haughtiness and contempt! ");
INSERT INTO engnoy_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","O how great is thy goodness, which thou treasurest up for them that fear thee; Which thou showest to them that trust in thee, before the sons of men! ");
INSERT INTO engnoy_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Thou hidest them in the secret place of thy presence from the machinations of men; Thou shelterest them in thy pavilion from the violence of tongues. ");
INSERT INTO engnoy_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Praised be the LORD; for he hath shown me his wonderful kindness, As in a fortified city! ");
INSERT INTO engnoy_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","I said in my distress, “I am cut off from before thine eyes;” But thou didst hear the voice of my supplication, When I cried unto thee. ");
INSERT INTO engnoy_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","O love the LORD, all ye his servants; For the LORD preserveth the faithful, And requiteth the proud in full measure! ");
INSERT INTO engnoy_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Be of good courage; let your hearts be strong, All ye who trust in the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","“A psalm of David.” Happy is he whose transgression is forgiven, whose sin is pardoned! ");
INSERT INTO engnoy_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Happy the man to whom the LORD imputeth not iniquity, And in whose spirit there is no guile! ");
INSERT INTO engnoy_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","While I kept silence, my bones were wasted, By reason of my groaning all the day long. ");
INSERT INTO engnoy_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","For day and night thy hand was heavy upon me; My moisture dried up, as in summer's drought. ");
INSERT INTO engnoy_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","At length I acknowledged to thee my sin, And did not hide my iniquity. I said, “I will confess my transgression to the LORD;” And thou forgavest the iniquity of my sin! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Therefore shall every pious man pray to thee, while thou mayst be found; Surely the floods of great waters shall not come near him. ");
INSERT INTO engnoy_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Thou art my hiding-place; thou preservest me from trouble; Thou compassest me about with songs of deliverance. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","I will instruct thee, and show thee the way thou shouldst go; I will give thee counsel, and keep mine eye upon thee. ");
INSERT INTO engnoy_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Be ye not like the horse and the mule, which have no understanding, Whose mouths must be pressed with the bridle and curb, Because they will not come near thee! ");
INSERT INTO engnoy_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","The wicked hath many sorrows; But he that trusteth in the LORD is encompassed with mercies. ");
INSERT INTO engnoy_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Rejoice in the LORD, and be glad, ye righteous; Shout for joy, all ye that are upright in heart! ");
INSERT INTO engnoy_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Rejoice, O ye righteous, in the LORD! For praise becometh the upright. ");
INSERT INTO engnoy_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Praise the LORD with the harp; Sing to him with the ten-stringed psaltery! ");
INSERT INTO engnoy_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Sing to him a new song; Play skilfully amid the sound of trumpets! ");
INSERT INTO engnoy_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","For the word of the LORD is right, And all his acts are faithful. ");
INSERT INTO engnoy_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","He loveth justice and equity; The earth is full of the goodness of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","By the word of the LORD were the heavens made, And all the hosts of them by the breath of his mouth. ");
INSERT INTO engnoy_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","He gathereth the waters of the sea, as a heap; He layeth up the deep in storehouses. ");
INSERT INTO engnoy_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Let all the earth fear the LORD; Let all the inhabitants of the world stand in awe of him! ");
INSERT INTO engnoy_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","For he spake, and it was done; He commanded, and it stood fast. ");
INSERT INTO engnoy_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","The LORD bringeth the devices of the nations to nothing; He frustrateth the designs of kingdoms. ");
INSERT INTO engnoy_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","The purposes of the LORD stand for ever; The designs of his heart, to all generations. ");
INSERT INTO engnoy_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Happy the nation whose God is Jehovah; The people whom he hath chosen for his inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","The LORD looketh down from heaven; He beholdeth all the children of men; ");
INSERT INTO engnoy_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","From his dwelling-place he beholdeth all the inhabitants of the earth,— ");
INSERT INTO engnoy_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","He that formed the hearts of all, And observeth all their works. ");
INSERT INTO engnoy_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","A king is not saved by the number of his forces, Nor a hero by the greatness of his strength. ");
INSERT INTO engnoy_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","The horse is a vain thing for safety, Nor can he deliver his master by his great strength. ");
INSERT INTO engnoy_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Behold, the eye of the LORD is upon them that fear him,—Upon them that trust in his goodness; ");
INSERT INTO engnoy_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","To save them from the power of death, And keep them alive in famine. ");
INSERT INTO engnoy_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","The hope of our souls is in the LORD; He is our help and our shield. ");
INSERT INTO engnoy_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Yea, in him doth our heart rejoice; In his holy name we have confidence. ");
INSERT INTO engnoy_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","May thy goodness be upon us, O LORD! According as we trust in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","“A psalm of David, when he feigned himself mad before Abimelech, who drove him away, and he departed.” I will bless the LORD at all times; His praise shall continually be in my mouth. ");
INSERT INTO engnoy_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","In the LORD doth my soul boast; Let the afflicted hear, and rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","O magnify the LORD with me, And let us exalt his name together! ");
INSERT INTO engnoy_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","I sought the LORD, and he heard me, And delivered me from all my fears. ");
INSERT INTO engnoy_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Look up to him, and ye shall have light; Your faces shall never be ashamed. ");
INSERT INTO engnoy_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","This afflicted man cried, and the LORD heard, And saved him from all his troubles. ");
INSERT INTO engnoy_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","The angels of the LORD encamp around those who fear him, And deliver them. ");
INSERT INTO engnoy_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","O taste, and see how good is the LORD! Happy the man who trusteth in him! ");
INSERT INTO engnoy_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","O fear the LORD, ye his servants! For to those who fear him there shall be no want. ");
INSERT INTO engnoy_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Young lions want, and suffer hunger; But they who fear the LORD want no good thing. ");
INSERT INTO engnoy_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Come, ye children, hearken to me! I will teach you the fear of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Who is he that loveth life, And desireth many days, in which he may see good? ");
INSERT INTO engnoy_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Guard well thy tongue from evil, And thy lips from speaking guile! ");
INSERT INTO engnoy_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Depart from evil, and do good; Seek peace, and pursue it! ");
INSERT INTO engnoy_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","The eyes of the LORD are upon the righteous, And his ears are open to their cry. ");
INSERT INTO engnoy_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","But the face of the LORD is against evil-doers, To cut off their remembrance from the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","The righteous cry, and the LORD heareth, And delivereth them from all their troubles. ");
INSERT INTO engnoy_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","The LORD is near to them that are of a broken heart, And saveth such as are of a contrite spirit. ");
INSERT INTO engnoy_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Many are the afflictions of the righteous; But the LORD delivereth him from them all. ");
INSERT INTO engnoy_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","He guardeth all his bones; Not one of them shall be broken. ");
INSERT INTO engnoy_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Calamity destroyeth the wicked, And they who hate the righteous suffer for it. ");
INSERT INTO engnoy_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","The LORD redeemeth the life of his servants, And none that put their trust in him will suffer for it. ");
INSERT INTO engnoy_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","“A psalm of David.” Contend, O LORD! with them that contend with me! Fight against them that fight against me! ");
INSERT INTO engnoy_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Take hold of shield and buckler, And stand up for my help! ");
INSERT INTO engnoy_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Draw forth the spear and the axe against my persecutors; Say to me, “I am thy salvation.” ");
INSERT INTO engnoy_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","May they be confounded and put to shame, who seek my life; May they be turned back with disgrace, who devise my hurt! ");
INSERT INTO engnoy_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","May they be like dust before the wind; May the angel of the LORD drive them! ");
INSERT INTO engnoy_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","May their way be dark and slippery, And may the angel of the LORD pursue them! ");
INSERT INTO engnoy_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","For without cause they have laid for me a snare; Without cause they have digged for me a pit. ");
INSERT INTO engnoy_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","May unforeseen destruction come upon them! May the snare which they have laid lay hold on themselves, And may they fall into destruction! ");
INSERT INTO engnoy_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Then shall my soul rejoice in the LORD; It shall exult in his protection. ");
INSERT INTO engnoy_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","All my bones shall say, Who, O LORD! is like thee, Who dost rescue the afflicted from the oppressor, The afflicted and destitute from the spoiler? ");
INSERT INTO engnoy_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","False witnesses have risen up; They charge me with that which has not entered my mind. ");
INSERT INTO engnoy_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","They repay me evil for good; They cause bereavement to my soul. ");
INSERT INTO engnoy_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","And yet I, during their sickness, clothed myself with sackcloth, And afflicted myself with fasting; And my prayer was turned to my bosom. ");
INSERT INTO engnoy_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","I behaved myself as if he had been my friend or brother; I bowed down in sadness, as one mourning for his mother. ");
INSERT INTO engnoy_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","But at my fall they rejoice, and gather themselves together; Revilers whom I know not assemble themselves against me; They tear me without ceasing. ");
INSERT INTO engnoy_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","With base men who mock for their bread, They gnash at me with their teeth. ");
INSERT INTO engnoy_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","How long, O LORD! wilt thou look on? O rescue my life from the destruction they plot for me; My precious life from these young lions! ");
INSERT INTO engnoy_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","I will thank thee in the great assembly! Before a numerous people I will praise thee. ");
INSERT INTO engnoy_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Let not them that are my enemies wrongfully triumph over me; Let them not wink with the eye, who hate me without cause! ");
INSERT INTO engnoy_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","For they speak not peace; They devise deceit against them that are quiet in the land. ");
INSERT INTO engnoy_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Yea, they open their mouths wide against me; They say, “Aha, aha! our eyes seeth it.” ");
INSERT INTO engnoy_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Thou seest it, O LORD! be not silent! O LORD! be not far from me! ");
INSERT INTO engnoy_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Arouse thyself; awake for my defence! My God and my Lord, awake to my cause! ");
INSERT INTO engnoy_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Judge me according to thy righteousness, O Jehovah, my God! Let them not triumph over me! ");
INSERT INTO engnoy_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Let them not say in their hearts, “Aha! we have our wish!” Let them not say, “We have swallowed him up!” ");
INSERT INTO engnoy_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","May they all be confounded and brought to shame, Who rejoice at my calamity! May they be clothed with ignominy and disgrace, Who exalt themselves against me! ");
INSERT INTO engnoy_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Let them shout for joy, and be glad, Who favor my righteous cause; Let them ever say, “The LORD be praised, Who delighteth in the prosperity of his servant!” ");
INSERT INTO engnoy_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","So shall my tongue speak of thy righteousness, And daily repeat thy praise. ");
INSERT INTO engnoy_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","“For the leader of the music. A psalm of David, the servant of the Lord.” To speak of the ungodliness of the wicked is in my heart. He hath no fear of God before his eyes. ");
INSERT INTO engnoy_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","For he flattereth himself in his own eyes, Till his iniquity is found out and hated. ");
INSERT INTO engnoy_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","The words of his mouth are iniquity and deceit; He neglecteth to be wise and to do good. ");
INSERT INTO engnoy_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","He deviseth mischief upon his bed; He persevereth in an evil way; He abhorreth not sin. ");
INSERT INTO engnoy_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Thy goodness, O LORD! reacheth to the heavens, And thy faithfulness to the clouds; ");
INSERT INTO engnoy_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Thy righteousness is like the high mountains; Thy judgments are a great deep; Thou, O LORD! preservest man and beast! ");
INSERT INTO engnoy_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","How precious is thy loving-kindness, O God! Yea, the sons of men seek refuge under the shadow of thy wings. ");
INSERT INTO engnoy_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","They are satisfied with the abundance of thy house, And thou causest them to drink of the full stream of thy pleasures. ");
INSERT INTO engnoy_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","For with thee is the fountain of life; Through thy light we see light. ");
INSERT INTO engnoy_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","O continue thy loving-kindness to them that know thee, And thy favor to the upright in heart! ");
INSERT INTO engnoy_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Let not the foot of the proud come upon me, Nor the hand of the wicked remove me! ");
INSERT INTO engnoy_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Lo! already are the workers of iniquity fallen; They are cast down; they are unable to rise! ");
INSERT INTO engnoy_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","“A psalm of David.” Be not thou angry on account of the wicked, Nor be envious of those who do iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","For soon shall they be cut down like grass, And wither like the green herb. ");
INSERT INTO engnoy_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Trust in the LORD, and do good; Abide in the land, and delight in faithfulness. ");
INSERT INTO engnoy_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Place thy delight in the LORD. And he will give thee thy heart's desires. ");
INSERT INTO engnoy_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Commit thy way to the LORD; Trust in him, and he will give thee success! ");
INSERT INTO engnoy_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","He will cause thy justice to shine forth like the light, And thy righteousness like the noonday's brightness. ");
INSERT INTO engnoy_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Hope thou patiently on the LORD, And in him place thy trust! Be not angry on account of the prosperous,—On account of him that deviseth deceit! ");
INSERT INTO engnoy_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Cease from anger; give not way to wrath; Be not provoked, so as to do evil! ");
INSERT INTO engnoy_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","For evil-doers shall be rooted out; But they who trust in the LORD, they shall inherit the land. ");
INSERT INTO engnoy_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Yet a little while, and the wicked shall be no more; Thou mayst look for his place, and he will not be found. ");
INSERT INTO engnoy_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","But the meek shall inherit the land, And delight themselves in the fulness of prosperity. ");
INSERT INTO engnoy_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","The wicked man plotteth against the just, And gnasheth at him with his teeth. ");
INSERT INTO engnoy_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","The Lord laugheth at him; For he seeth that his day is coming. ");
INSERT INTO engnoy_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","The wicked draw the sword, And bend their bow, To cast down the afflicted and the needy, And to slay the upright. ");
INSERT INTO engnoy_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Their swords shall enter their own hearts, And their bows shall be broken in pieces. ");
INSERT INTO engnoy_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Better is the little of the righteous man Than the great abundance of the wicked; ");
INSERT INTO engnoy_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","For the arms of the wicked shall be broken, But the LORD will uphold the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","The LORD careth for the life of the upright, And their inheritance shall endure for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","They shall not be ashamed in the evil time, And in the days of famine they shall have enough. ");
INSERT INTO engnoy_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","But the wicked shall perish; Yea, the enemies of the LORD shall be consumed, like the glory of the fields; They shall be consumed into smoke. ");
INSERT INTO engnoy_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","The wicked borroweth, and repayeth not; But the righteous is merciful and bountiful. ");
INSERT INTO engnoy_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","For they who are blessed by God shall inherit the land, And they who are cursed by him shall be rooted out. ");
INSERT INTO engnoy_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","The steps of the good man are directed by the LORD; He delighteth himself in his way. ");
INSERT INTO engnoy_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Though he fall, he shall not be utterly cast down, For the LORD holdeth him by the hand. ");
INSERT INTO engnoy_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","I have been young, and now am old; Yet have I not seen the righteous forsaken, Nor his offspring begging bread. ");
INSERT INTO engnoy_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","He is ever merciful and lendeth, And his offspring shall be blessed. ");
INSERT INTO engnoy_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Depart from evil, and do good; So thou shalt dwell in the land for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","For the LORD loveth righteousness, And forsaketh not his servants; They are preserved for ever; But the posterity of the wicked shall be rooted out. ");
INSERT INTO engnoy_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","The righteous shall inherit the land, And shall dwell therein for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","The mouth of the righteous uttereth wisdom, And his tongue speaketh what is right. ");
INSERT INTO engnoy_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","The law of his God is in his heart; His footsteps shall not slip. ");
INSERT INTO engnoy_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","The wicked watcheth the righteous, And seeketh to slay him; ");
INSERT INTO engnoy_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","The Lord will not leave him in his hand, Nor suffer him to be condemned, when he is judged. ");
INSERT INTO engnoy_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Trust in the LORD, and keep his way, And he will exalt thee to the possession of the land, Whilst thou shalt see the destruction of the wicked! ");
INSERT INTO engnoy_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","I have seen a wicked man in great power, And spreading himself like a green cedar; ");
INSERT INTO engnoy_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","But he passed away, and, lo! he was no more; Yea, I sought him, but he was not found. ");
INSERT INTO engnoy_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Mark the righteous man, and behold the upright, That posterity is to the man of peace! ");
INSERT INTO engnoy_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","But transgressors will all be destroyed; The posterity of the wicked shall be rooted out. ");
INSERT INTO engnoy_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","The salvation of the just is from the LORD. He is their strength in the time of trouble. ");
INSERT INTO engnoy_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","The LORD will help and deliver them; He will deliver them from their enemies, and save them, Because they trust in him. ");
INSERT INTO engnoy_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","“A psalm of David. To bring to remembrance.” O LORD! rebuke me not in thy wrath, Nor chasten me in thy hot displeasure! ");
INSERT INTO engnoy_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","For thine arrows have deeply pierced me, And thy hand hath been heavy upon me. ");
INSERT INTO engnoy_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","There is no soundness in my flesh, because of thine anger; Nor rest in my bones, because of my sin. ");
INSERT INTO engnoy_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","For my iniquities have gone over my head; Like a heavy burden, they are more than I can bear. ");
INSERT INTO engnoy_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","My wounds putrefy and are loathsome on account of my folly. ");
INSERT INTO engnoy_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","I am bent; I am bowed down greatly; I go mourning all the day long. ");
INSERT INTO engnoy_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","For my loins are full of burning heat, And there is no soundness in my flesh. ");
INSERT INTO engnoy_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","I am weakened and bruised exceedingly; I roar by reason of the disquietude of my heart. ");
INSERT INTO engnoy_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O Lord! thou knowest all my desire, And my groaning is not hidden from thee! ");
INSERT INTO engnoy_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","My heart panteth; my strength faileth me; The very light of my eyes is gone from me. ");
INSERT INTO engnoy_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","My friends and acquaintance keep aloof from my woe, And my kinsmen stand afar off: ");
INSERT INTO engnoy_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","While they who seek my life lay snares for me; They who seek my hurt threaten destruction, And meditate deceit all the day long. ");
INSERT INTO engnoy_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","But I, like a deaf man, hear not; And, like a dumb man, open not my mouth. ");
INSERT INTO engnoy_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","I am like one who heareth nothing, And in whose mouth is no reply. ");
INSERT INTO engnoy_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","For in thee, O LORD! do I put my trust; Thou wilt hear, O Lord, my God! ");
INSERT INTO engnoy_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","For I have prayed, “Let them not rejoice over me; Let them not exult at the slipping of my feet!” ");
INSERT INTO engnoy_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","For I am ready to fall, And my pain doth never leave me; ");
INSERT INTO engnoy_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","For I confess my iniquity, And am troubled on account of my sin. ");
INSERT INTO engnoy_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","But my enemies flourish and are strong; They who hate me without cause are multiplied. ");
INSERT INTO engnoy_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","They who repay good with evil are my enemies, Because I follow that which is good. ");
INSERT INTO engnoy_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Forsake me not, O LORD! O my God! be not far from me! ");
INSERT INTO engnoy_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Make hast to mine aid, O Lord, my salvation! ");
INSERT INTO engnoy_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","“A psalm of David. For the leader of the music of the Jeduthunites.” I said, I will take heed to my ways, That I may not sin with my tongue; I will keep my mouth with a bridle, While the wicked is before me. ");
INSERT INTO engnoy_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","I was dumb with silence; I spake not even what was good; But my pain was increased. ");
INSERT INTO engnoy_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","My heart was hot within me; In my anguish the fire burst forth, And I spake with my tongue: ");
INSERT INTO engnoy_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","LORD, make me to know mine end, And the number of my days, That I may know how frail I am! ");
INSERT INTO engnoy_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Behold, thou hast made my days as a hand-breadth, And my life is as nothing before thee; Yea, every man in his firmest state is altogether vanity. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Surely every man walketh in a vain show; Surely he disquieteth himself in vain; He heapeth up riches, and knoweth not who shall gather them. ");
INSERT INTO engnoy_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","What, then, O Lord! is my hope? My hope is in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Deliver me from all my transgressions; Let me not be the reproach of scoffers! ");
INSERT INTO engnoy_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Yet I am dumb; I open not my mouth; For thou hast done it! ");
INSERT INTO engnoy_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","But remove from me thine infliction; For I am perishing by the blow of thine hand. ");
INSERT INTO engnoy_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","When thou with rebukes dost chasten man for iniquity, Thou causest his glory to waste away like a moth! Surely every man is vanity. ");
INSERT INTO engnoy_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Hear my prayer, O LORD! Give ear to my cry; Be not silent at my tears! For I am but a stranger with thee, A sojourner, as all my fathers were. ");
INSERT INTO engnoy_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","O spare me, that I may recover strength, Before I go away, and be no more! ");
INSERT INTO engnoy_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","“For the leader of the music. A psalm of David.” I trusted steadfastly in the LORD, And he listened, and heard my cry. ");
INSERT INTO engnoy_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","He drew me out of a horrible pit, Out of the miry clay; He set my feet upon a rock, And made my steps firm. ");
INSERT INTO engnoy_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","He hath put into my mouth a new song, A song of praise to our God. Many shall see, and fear, And put their trust in the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Happy the man who maketh the LORD his trust, And resorteth not to men of pride and falsehood! ");
INSERT INTO engnoy_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Many, O LORD, my God! are the wonderful works which thou hast done; Many have been thy gracious purposes towards us; None can be compared to thee! Would I declare and rehearse them, they are more than can be numbered. ");
INSERT INTO engnoy_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","In sacrifice and oblation thou hast no pleasure; Mine ears thou hast opened; Burnt-offering and sin-offering thou requirest not. ");
INSERT INTO engnoy_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Therefore I said, “Lo, I come; In the scroll of the book it is prescribed to me; ");
INSERT INTO engnoy_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","O my God! to do thy will is my delight, And thy law dwelleth in my heart!” ");
INSERT INTO engnoy_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","I have proclaimed thy righteousness in the great assembly; Lo, I have not restrained my lips, O LORD! thou knowest! ");
INSERT INTO engnoy_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","I hide not thy justice in my heart; I declare thy faithfulness and thy salvation; I conceal not thy mercy and truth from the great assembly. ");
INSERT INTO engnoy_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Withdraw not from me thy tender mercies, O LORD! May thy loving-kindness and thy truth continually preserve me! ");
INSERT INTO engnoy_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","For evils without number have encompassed me; My iniquities have overtaken me; I cannot see the end of them; They are more than the hairs of my head, And my heart dieth within me. ");
INSERT INTO engnoy_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","May it please thee, O LORD! to deliver me! O LORD! make haste to mine aid! ");
INSERT INTO engnoy_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","May they all be confounded and covered with shame Who seek to take away my life! Let them be driven back with disgrace Who desire to do me injury! ");
INSERT INTO engnoy_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Let them be overwhelmed with confusion Who cry out to me, Aha! aha! ");
INSERT INTO engnoy_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","But let all who seek thee Be glad and rejoice in thee! Let those who love thy protection Ever say, “Great is Jehovah!” ");
INSERT INTO engnoy_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","I am poor and afflicted, yet the Lord thinketh upon me; Thou art my help and my deliverer; My God! make no delay! ");
INSERT INTO engnoy_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","“For the leader of the music. A psalm of David.” Happy is he who hath regard to the poor! The LORD will deliver him in time of trouble. ");
INSERT INTO engnoy_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","The LORD will preserve him, and keep him alive; He shall be happy on the earth; Thou wilt not give him up to the will of his enemies! ");
INSERT INTO engnoy_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","The LORD will strengthen him upon the bed of disease; All his bed thou wilt change in his sickness. ");
INSERT INTO engnoy_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","I said, O LORD! be merciful to me! Heal me, for I have sinned against thee! ");
INSERT INTO engnoy_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","My enemies speak evil of me: “When will he die, and his name perish?” ");
INSERT INTO engnoy_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","If one come to see me, he speaketh falsehood; His heart gathereth malice; When he goeth abroad, he uttereth it. ");
INSERT INTO engnoy_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","All that hate me whisper together against me; Against me do they devise mischief: ");
INSERT INTO engnoy_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“A deadly disease cleaveth fast unto him; He lieth down, and he shall never arise!” ");
INSERT INTO engnoy_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Yea, my familiar friend in whom I trusted, who did eat of my bread,—He hath lifted up his heel against me. ");
INSERT INTO engnoy_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","But do thou, O LORD! have pity upon me; Raise me up, that I may requite them! ");
INSERT INTO engnoy_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","By this I know that thou favorest me, Because my enemy doth not triumph over me. ");
INSERT INTO engnoy_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","As for me, thou wilt uphold me in my integrity; Thou wilt set me before thy face for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Praised be Jehovah, the God of Israel, From everlasting to everlasting. Amen! Amen! ");
INSERT INTO engnoy_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","“BOOK II. For the leader of the music. A song of the sons of Korah.” As the hart panteth for the water-brooks, So panteth my soul for thee, O God! ");
INSERT INTO engnoy_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","My soul thirsteth for God, the living God: When shall I come, and appear before God? ");
INSERT INTO engnoy_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","My tears have been my food day and night, While they say to me continually, “Where is thy God?” ");
INSERT INTO engnoy_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","When I think of it, I pour out my soul in grief; How I once walked with the multitude, Walked slowly with them to the house of God, Amid sounds of joy and praise with the festive multitude! ");
INSERT INTO engnoy_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Why art thou cast down, O my soul? And why art thou disquieted within me? Hope thou in God; for I shall yet praise him, Him, my deliverer and my God! ");
INSERT INTO engnoy_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","My soul is cast down within me, While I remember thee from the land of Jordan and Hermon, From the mountain Mizar. ");
INSERT INTO engnoy_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Deep calleth for deep at the noise of thy waterfalls; All thy waves and billows have gone over me! ");
INSERT INTO engnoy_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Once the LORD commanded his kindness by day, And by night his praise was with me,-Thanksgiving to the God of my life. ");
INSERT INTO engnoy_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Now I say to God, my rock, Why hast thou forgotten me? Why go I mourning on account of the oppression of the enemy? ");
INSERT INTO engnoy_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Like the crushing of my bones are the reproaches of the enemy, While they say to me continually, “Where is thy God?” ");
INSERT INTO engnoy_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Why art thou cast down, O my soul? And why art thou disquieted within me? Hope thou in God; for I shall yet praise him, Him, my deliverer and my God! ");
INSERT INTO engnoy_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Judge me, O God! and defend my cause against a merciless nation! Deliver me from unjust and deceitful men! ");
INSERT INTO engnoy_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Thou art the God of my refuge: why dost thou cast me off? Why go I mourning on account of the oppression of the enemy? ");
INSERT INTO engnoy_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","O send forth thy light and thy truth; let them guide me; Let them lead me to thy holy mountain, and to thy dwelling-place! ");
INSERT INTO engnoy_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Then will I go to the altar of God, To the God of my joy and exultation; Yea, upon the harp will I praise thee, O God, my God! ");
INSERT INTO engnoy_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Why art thou cast down, O my soul? And why art thou disquieted within me? Hope thou in God; for I shall yet praise him, Him, my deliverer and my God! ");
INSERT INTO engnoy_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","“For the leader of the music. A psalm of the sons of Korah.” O God! we have heard with our ears, Our fathers have told us, What deeds thou didst in their days, In the days of old. ");
INSERT INTO engnoy_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","With thine own hand didst thou drive out the nations, And plant our fathers; Thou didst destroy the nations, And cause our fathers to flourish. ");
INSERT INTO engnoy_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","For not by their own swords did they gain possession of the land, Nor did their own arms give them victory; But thy right hand, and thine arm, and the light of thy countenance; For thou didst favor them! ");
INSERT INTO engnoy_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Thou art my king, O God! O send deliverance to Jacob! ");
INSERT INTO engnoy_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Through thee we may cast down our enemies; Through thy name we may trample upon our adversaries! ");
INSERT INTO engnoy_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","I trust not in my bow, Nor can my sword save me. ");
INSERT INTO engnoy_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","But it is thou only who savest us from our enemies, And puttest to shame those who hate us! ");
INSERT INTO engnoy_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","In God will we glory continually; Yea, we will praise thy name for ever! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Yet now thou hast cast us off, and put us to shame; Thou goest not forth with our armies. ");
INSERT INTO engnoy_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Thou makest us turn back from the enemy, And they who hate us make our goods their prey. ");
INSERT INTO engnoy_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Thou makest us like sheep destined for food, And scatterest us among the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Thou sellest thy people for nought, And increasest not thy wealth by their price. ");
INSERT INTO engnoy_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Thou makest us a reproach to our neighbors, A scorn and a derision to those who are around us. ");
INSERT INTO engnoy_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Thou makest us a byword among the nations, And causest the people to shake their heads at us. ");
INSERT INTO engnoy_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","My ignominy is continually before me, And shame covereth my face, ");
INSERT INTO engnoy_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","On account of the voice of the scoffer and the reviler, And on account of the enemy and the avenger. ");
INSERT INTO engnoy_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","All this hath come upon us; Yet have we not forgotten thee, Nor have we been false to thy covenant. ");
INSERT INTO engnoy_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Our hearts, have not wandered from thee, Nor have our feet gone out of thy path; ");
INSERT INTO engnoy_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Though thou hast crushed us in a land of jackals, And covered us with thick darkness. ");
INSERT INTO engnoy_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","If we had forgotten the name of our God, Or stretched forth our hands to a strange God, ");
INSERT INTO engnoy_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Surely God would search it out; For he knoweth the secrets of the heart. ");
INSERT INTO engnoy_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","But for thy sake we are killed all the day; We are counted as sheep for the slaughter. ");
INSERT INTO engnoy_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Awake! why sleepest thou, O Lord? Arise! cast us not off for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Wherefore dost thou hide thy face, And forget our affliction and oppression? ");
INSERT INTO engnoy_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Our soul is bowed down to the dust; Our body cleaveth to the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Arise, O thou, our strength! And deliver us, for thy mercy's sake! ");
INSERT INTO engnoy_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","“For the leader of the music. To be accompanied with the Shoshannim. A song of loveliness by the sons of Korah.” My heart is overflowing with a good matter; I will address my work to the king: May my tongue be like the pen of a ready writer! ");
INSERT INTO engnoy_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Thou art the fairest of the sons of men; Grace is poured upon thy lips; For God hath blessed thee for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Gird thy sword to thy thigh, thou hero!-Thy glory and ornament! ");
INSERT INTO engnoy_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","In thy glorious array ride forth victoriously, On account of truth and mildness and justice; And thy right hand shall teach thee terrible things! ");
INSERT INTO engnoy_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Thine arrows are sharp; Nations shall fall before thee; They shall pierce the hearts of the king's enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Thy throne is God's for ever and ever; The sceptre of thy kingdom is a sceptre of equity! ");
INSERT INTO engnoy_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Thou lovest righteousness, and hatest iniquity; Therefore hath God, thy God, anointed thee With the oil of gladness above thy fellows! ");
INSERT INTO engnoy_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","All thy garments are myrrh, aloes, and cassia; From ivory palaces stringed instruments delight thee. ");
INSERT INTO engnoy_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Daughters of kings are among thy chosen women; On the right hand stands the queen In gold of Ophir. ");
INSERT INTO engnoy_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Listen, O daughter! consider, and incline thine ear; Forget thy people and thy father's house! ");
INSERT INTO engnoy_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","For the king is captivated with thy beauty; He is now thy lord; honor thou him! ");
INSERT INTO engnoy_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","So shall the daughter of Tyre seek thy favor with gifts, The rich among the people. ");
INSERT INTO engnoy_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","All glorious is the king's daughter in her apartment; Her robe is embroidered with gold. ");
INSERT INTO engnoy_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","In variegated garments shall she be led to the king; The virgin companions that follow her shall be brought unto thee. ");
INSERT INTO engnoy_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","With gladness and rejoicing shall they be brought; They shall enter the king's palace. ");
INSERT INTO engnoy_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Instead of thy fathers shall be thy children, Whom thou shalt make princes through all the land. ");
INSERT INTO engnoy_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","I will make thy name memorable throughout all generations; So shall the nations praise thee for ever and ever! ");
INSERT INTO engnoy_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","“For the leader of the music. Of, or for, the sons of Korah. To be sung in the manner, or with the voice, of virgins.” God is our refuge and strength; An ever present help in trouble. ");
INSERT INTO engnoy_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Therefore will we not fear, though the earth be changed; Though the mountains tremble in the heart of the sea; ");
INSERT INTO engnoy_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Though its waters roar and be troubled, And the mountains shake with the swelling thereof. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","A river with its streams shall make glad the city of God, The holy dwelling-place of the Most High. ");
INSERT INTO engnoy_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","God is the midst of her; she shall not be moved; God will help her, and that full early. ");
INSERT INTO engnoy_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","The nations raged; kingdoms were moved; He uttered his voice, the earth melted. ");
INSERT INTO engnoy_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","The LORD of hosts is with us; The God of Jacob is our refuge. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Come, behold the doings of the LORD; What desolations he hath made in the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","He causeth wars to cease to the end of the earth; He hath broken the bow, and snapped the spear asunder, And burned the chariots in fire. ");
INSERT INTO engnoy_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“Desist, and know that I am God; I will be exalted among the nations, I will be exalted throughout the earth!” ");
INSERT INTO engnoy_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","The LORD of hosts is with us; The God of Jacob is our refuge. ");
INSERT INTO engnoy_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","“For the leader of the music. A psalm of the sons of Korah.” O clap your hands, all ye nations! Shout unto God with the voice of triumph! ");
INSERT INTO engnoy_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","For terrible is Jehovah, the Most High, The great king over all the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","He hath subdued nations under us, And kingdoms under our feet; ");
INSERT INTO engnoy_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","He hath chosen for us an inheritance, The glory of Jacob, whom he loved. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","God goeth up with a shout; Jehovah with the sound of the trumpet. ");
INSERT INTO engnoy_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Sing praises to God, sing praises! Sing praises to our king, sing praises! ");
INSERT INTO engnoy_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","For God is king of all the earth; Sing to him hymns of praise! ");
INSERT INTO engnoy_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","God reigneth over the nations; God sitteth upon his holy throne. ");
INSERT INTO engnoy_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","The princes of the nations gather themselves together To the people of the God of Abraham; For the mighty of the earth belong to God; He is supremely exalted. ");
INSERT INTO engnoy_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","“A psalm of the sons of Korah.” Great is Jehovah, and greatly to be praised In the city of our God, upon his holy mountain. ");
INSERT INTO engnoy_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Beautiful in its elevation is Mount Zion, The joy of the whole earth; The joy of the farthest North is the city of the great king; ");
INSERT INTO engnoy_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","In her palaces God is known as a refuge. ");
INSERT INTO engnoy_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","For, lo! kings were assembled against it; They passed away together. ");
INSERT INTO engnoy_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","As soon as they saw, they were astonished; They were confounded, and hasted away. ");
INSERT INTO engnoy_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","There terror seized upon them,—Pain, as of a woman in travail; ");
INSERT INTO engnoy_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","As when the east wind breaketh in pieces The ships of Tarshish. ");
INSERT INTO engnoy_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","As we have heard, so have we seen In the city of the LORD of hosts, in the city of our God; God will establish it for ever. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","We think of thy loving-kindness, O God! In the midst of thy temple! ");
INSERT INTO engnoy_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","As thy name, O God! so thy praise, extendeth to the ends of the earth; Thy right hand is full of righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Mount Zion rejoiceth, The daughters of Judah exult, On account of thy righteous judgments. ");
INSERT INTO engnoy_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Go round about Zion; number her towers; ");
INSERT INTO engnoy_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Mark well her bulwarks; count her palaces; That ye may tell it to the next generation! ");
INSERT INTO engnoy_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","For this God is our God for ever and ever; He will be our guide unto death. ");
INSERT INTO engnoy_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","“For the leader of the music. A psalm of the sons of Korah.” Hear this, all ye nations; Give ear, all ye inhabitants of the world; ");
INSERT INTO engnoy_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Both high and low, rich and poor alike! ");
INSERT INTO engnoy_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","My mouth shall speak wisdom, And the meditation of my mind shall be understanding. ");
INSERT INTO engnoy_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","I will incline mine ear to a poem; I will utter my song upon the harp. ");
INSERT INTO engnoy_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Why should I fear in the days of adversity, When the iniquity of my adversaries encompasseth me; ");
INSERT INTO engnoy_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","They who trust in their riches, And glory in the greatness of their wealth? ");
INSERT INTO engnoy_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","No one can redeem his brother from death, Nor give a ransom for him to God, ");
INSERT INTO engnoy_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","That he should live to eternity, And not see the pit. ");
INSERT INTO engnoy_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Too costly is the redemption of his life, And he giveth it up for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","For he seeth that wise men die, As well as the foolish and the ignorant; They perish alike, And leave their wealth to others. ");
INSERT INTO engnoy_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","They imagine that their houses will endure for ever, And their dwelling-places from generation to generation: Men celebrate their names on the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Yet man, who is in honor, abideth not; He is like the beasts that perish. ");
INSERT INTO engnoy_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Such is the way which is their confidence! And they who come after them approve their maxims. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Like sheep they are cast into the underworld; Death shall feed upon them; And the upright shall soon trample upon them. Their form shall be consumed in the underworld, And they shall no more have a dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","But God will redeem my life from the underworld; Yea, he will take me under his care. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Be not thou afraid, when one becometh rich; When the glory of his house is increased! ");
INSERT INTO engnoy_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","For, when he dieth, he will carry nothing away; His glory will not descend after him. ");
INSERT INTO engnoy_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Though in his life he thought himself happy,—Though men praised thee, while thou wast in prosperity,— ");
INSERT INTO engnoy_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Yet shalt thou go to the dwelling-place of thy fathers, Who never more shall see the light! ");
INSERT INTO engnoy_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","The man who is in honor, but without understanding, Is like the beasts that perish. ");
INSERT INTO engnoy_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","“A psalm of Asaph.” The mighty God, Jehovah, speaketh, and calleth the earth, From the rising of the sun to its going down. ");
INSERT INTO engnoy_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Out of Zion, the perfection of beauty, God shineth forth. ");
INSERT INTO engnoy_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Our God cometh, and will not be silent; Before him is a devouring fire, And around him a raging tempest. ");
INSERT INTO engnoy_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","He calleth to the heavens on high, And to the earth, while he judgeth his people: ");
INSERT INTO engnoy_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Gather together before me my godly ones, Who have made a covenant with me by sacrifice!” ");
INSERT INTO engnoy_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","(And the heavens shall declare his righteousness, For it is God himself that is judge.) Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Hear, O my people, and I will speak! O Israel, and I will testify against thee! For I am God, thine own God. ");
INSERT INTO engnoy_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","I reprove thee not on account of thy sacrifices; For thy burnt-offerings are ever before me. ");
INSERT INTO engnoy_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","I will take no bullock from thy house, Nor he-goat from thy folds; ");
INSERT INTO engnoy_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","For all the beasts of the forest are mine, And the cattle on a thousand hills. ");
INSERT INTO engnoy_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","I know all the birds of the mountains, And the wild beasts of the field are before me. ");
INSERT INTO engnoy_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","If I were hungry, I would not tell thee; For the world is mine, and all that is therein. ");
INSERT INTO engnoy_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Do I eat the flesh of bulls, Or drink the blood of goats? ");
INSERT INTO engnoy_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Offer to God thanksgiving, And pay thy vows to the Most High! ");
INSERT INTO engnoy_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Then call upon me in the day of trouble: I will deliver thee, and thou shalt glorify me!” ");
INSERT INTO engnoy_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","And to the wicked God saith, “To what purpose dost thou talk of my statutes? And why hast thou my laws upon thy lips?— ");
INSERT INTO engnoy_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Thou, who hatest instruction And castest my words behind thee! ");
INSERT INTO engnoy_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","When thou seest a thief, thou art in friendship with him, And hast fellowship with adulterers. ");
INSERT INTO engnoy_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Thou lettest loose thy mouth to evil, And thy tongue frameth deceit; ");
INSERT INTO engnoy_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Thou sittest and speakest against thy brother; Thou slanderest thine own mother's son. ");
INSERT INTO engnoy_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","These things hast thou done, and I kept silence; Hence thou thoughtest that I was altogether like thyself: But I will reprove thee, and set it in order before thine eyes. ");
INSERT INTO engnoy_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Mark this, ye that forget God, Lest I tear you in pieces, and none deliver you! ");
INSERT INTO engnoy_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Whoso offereth praise honoreth me; And to him who hath regard to his ways Will I show salvation from God.” ");
INSERT INTO engnoy_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","“For the leader of the music. A psalm of David, when Nathan the prophet came unto him, after his intercourse with Bathsheba.” Be gracious unto me, O God! according to thy loving kindness; According to the greatness of thy mercy, blot out my transgressions! ");
INSERT INTO engnoy_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Wash me thoroughly from my iniquity, And cleanse me from my sin! ");
INSERT INTO engnoy_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","For I acknowledge my transgressions, And my sin is ever before me. ");
INSERT INTO engnoy_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Against thee, thee only, have I sinned, And in thy sight have I done evil; So that thou art just in thy sentence, And righteous in thy judgment. ");
INSERT INTO engnoy_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Behold! I was born in iniquity, And in sin did my mother conceive me. ");
INSERT INTO engnoy_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Behold! thou desirest truth in the heart; So teach me wisdom in my inmost soul! ");
INSERT INTO engnoy_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Purge me with hyssop, until I be clean; Wash me, until I be whiter than snow! ");
INSERT INTO engnoy_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Make me to hear joy and gladness, So that the bones which thou hast broken may rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Hide thy face from my sins, And blot out all my iniquities! ");
INSERT INTO engnoy_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Create within me a clean heart, O God! Renew within me a steadfast spirit! ");
INSERT INTO engnoy_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Cast me not away from thy presence, And take not thy holy spirit from me! ");
INSERT INTO engnoy_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Restore to me the joy of thy protection, And strengthen me with a willing spirit! ");
INSERT INTO engnoy_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Then will I teach thy ways to transgressors, And sinners shall be converted to thee. ");
INSERT INTO engnoy_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Deliver me from the guilt of blood, O God, the God of my salvation! That my tongue may sing aloud of thy goodness! ");
INSERT INTO engnoy_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","O Lord! open thou my lips, That my mouth may show forth thy praise! ");
INSERT INTO engnoy_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","For thou desirest not sacrifice, else would I give it; Thou delightest not in burnt-offerings. ");
INSERT INTO engnoy_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","The sacrifice which God loveth is a broken spirit; A broken and contrite heart, O God! thou wilt not despise! ");
INSERT INTO engnoy_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Do good to Zion according to thy mercy; Build up the walls of Jerusalem! ");
INSERT INTO engnoy_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Then shalt thou be pleased with sacrifices of righteousness, With burnt-offerings and complete offerings; Then shall bullocks be offered upon thine altar. ");
INSERT INTO engnoy_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","“For the leader of the music. A psalm of David, when Doeg, the Edomite, came and told Saul, and said to him, David is come to the house of Abimelech.” Why gloriest thou in mischief, thou man of violence? The goodness of God yet continueth daily. ");
INSERT INTO engnoy_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Thy tongue deviseth mischief, Like a sharp razor, thou contriver of deceit! ");
INSERT INTO engnoy_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Thou lovest evil more than good, And to lie more than to speak truth. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Thou lovest all devouring words, O thou deceitful tongue! ");
INSERT INTO engnoy_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Thee also shall God utterly destroy! o He shall seize thee, and tear thee from thy dwelling-place, And uproot thee from the land of the living. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","The righteous shall see and fear, And shall laugh at him. ");
INSERT INTO engnoy_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Behold the man that made not God his strength, But trusted in the abundance of his riches, And placed his strength in his wickedness!” ");
INSERT INTO engnoy_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","But I shall be like a green olive-tree in the house of God; I will trust in the goodness of God for ever and ever. ");
INSERT INTO engnoy_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","I will praise thee for ever for what thou hast done; I will trust in thy name, because it is good, Before the eyes of thy godly ones! ");
INSERT INTO engnoy_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","“For the leader of the music. To be sung on wind instruments. A psalm of David.” The fool saith in his heart, “There is no God!” They are corrupt; their doings are abominable; There is none that doeth good. ");
INSERT INTO engnoy_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","God looketh down from heaven upon the children of men, To see if there are any that have understanding, That have regard to God. ");
INSERT INTO engnoy_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","They are all gone astray; together are they corrupt; There is none that doeth good, no, not one. ");
INSERT INTO engnoy_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Shall not the evil-doers be requited, Who eat up my people like bread, And call not upon God? ");
INSERT INTO engnoy_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Yea! fear shall come upon them, Where no fear is; For God will scatter the bones of him that encampeth against thee; Thou shalt put them to shame, for God despiseth them! ");
INSERT INTO engnoy_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","O that salvation for Israel would come out of Zion! When God bringeth back the captives of his people, Jacob shall rejoice, and Israel be glad. ");
INSERT INTO engnoy_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","“For the leader of the music. To be sung on stringed instruments A psalm of David, when the Ziphites came and said to Saul, Doth not David hide himself with us?” Save me, O God! by thy name, And by thy strength defend my cause! ");
INSERT INTO engnoy_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O God! hear my prayer, Give ear to the words of my mouth! ");
INSERT INTO engnoy_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","For enemies have risen up against me, And oppressors seek my life; They have not set God before their eyes. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Behold! God is my helper; The Lord is the support of my life. ");
INSERT INTO engnoy_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","He will repay evil to my enemies; For thy truth's sake, O God! cut them off! ");
INSERT INTO engnoy_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","With a willing heart will I sacrifice to thee; I will praise thy name, O LORD! for it is good; ");
INSERT INTO engnoy_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","For thou hast delivered me from all trouble, So that my eye hath looked with joy upon my enemies! ");
INSERT INTO engnoy_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","“For the leader of the music. To be sung on stringed instruments. A psalm of David.” Give ear to my prayer, O God! Hide not thyself from my supplication! ");
INSERT INTO engnoy_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Attend unto me, and hear me! I wander about mourning and wailing, ");
INSERT INTO engnoy_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","On account of the clamors of the enemy, On account of the violence of the wicked. For they bring evil upon me, And in wrath set themselves against me. ");
INSERT INTO engnoy_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","My heart trembleth in my bosom, And the terrors of death have fallen upon me. ");
INSERT INTO engnoy_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Fear and trembling have seized me, And horror hath overwhelmed me. ");
INSERT INTO engnoy_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Then I say, O that I had wings like a dove! For then would I fly away, and be at rest. ");
INSERT INTO engnoy_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Behold, I would wander far away, And take up my abode in a wilderness. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","I would hasten away to a shelter From the rushing wind and tempest. ");
INSERT INTO engnoy_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Confound, O Lord! divide their counsels! For I behold violence and strife in the city. ");
INSERT INTO engnoy_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Day and night do these go about its walls; In the midst of it are iniquity and mischief. ");
INSERT INTO engnoy_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Wickedness is in the midst of it; Oppression and fraud depart not from its streets. ");
INSERT INTO engnoy_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","It was not an enemy that reviled me, Then I could have borne it; Nor one that hated me, who rose up against me; From him I could have hid myself. ");
INSERT INTO engnoy_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","But it was thou, a man my equal, My friend, and my acquaintance. ");
INSERT INTO engnoy_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","We held sweet converse together, And walked to the house of God in company. ");
INSERT INTO engnoy_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","May sudden death seize upon them! May they go down to the underworld alive! For wickedness is in their dwellings, in the midst of them. ");
INSERT INTO engnoy_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","As for me, I will call upon God, And Jehovah will save me. ");
INSERT INTO engnoy_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","At evening, at morn, and at noon I mourn and sigh, And he will hear my voice. ");
INSERT INTO engnoy_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","He will deliver me in peace from my conflict; For many have risen up against me. ");
INSERT INTO engnoy_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","God will hear me, and bring them down,—He that hath been judge of old. Pause. Because they have no changes, Therefore they fear not God. ");
INSERT INTO engnoy_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","They lift up their hands against their friend, And break their covenant with him. ");
INSERT INTO engnoy_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Their speech was softer than butter, But war was in their heart; Their words were smoother than oil, Yet were they drawn swords. ");
INSERT INTO engnoy_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","“Cast thy burden upon the LORD, and he will sustain thee; He will never suffer the righteous to fall!” ");
INSERT INTO engnoy_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Yea, thou, O God! wilt bring them down into the lowest pit! Bloody and deceitful men shall not live out half their days. But I will trust in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","“For the leader of the music. To be sung to the tune of “The dumb dove among strangers.” A psalm of David, when the Philistines took him in Gath.” Have pity upon me, O God! for man panteth for my life; My adversary daily oppresseth me! ");
INSERT INTO engnoy_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Mine enemies daily pant for my life, And many are they who war proudly against me. ");
INSERT INTO engnoy_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","When I am in fear, I will put my trust in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Through God shall I praise his word; In God do I put my trust; I will not fear; What can flesh do to me? ");
INSERT INTO engnoy_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Every day they wrest my words; All their thoughts are against me for evil. ");
INSERT INTO engnoy_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","They gather themselves together, they hide themselves, they watch my steps, Lying in wait for my life. ");
INSERT INTO engnoy_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Shall they escape by their iniquity? In thine anger cast down the people, O God! ");
INSERT INTO engnoy_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Count thou my wanderings; Put my tears into thy bottle! Are they not recorded in thy book? ");
INSERT INTO engnoy_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","When I cry to thee, my enemies shall turn back; This I know, that God is for me. ");
INSERT INTO engnoy_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Through God shall I praise his word; I shall glory in the promise of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","In God do I put my trust; I will not fear: What can man do to me? ");
INSERT INTO engnoy_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Thy vows are upon me, O God! I will render praises to thee! ");
INSERT INTO engnoy_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","For thou hast delivered me from death, Yea, my feet from falling, That I may walk before God in the light of the living. ");
INSERT INTO engnoy_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","“For the leader of the music. To be sung to the tune of “Do not destroy.” A psalm of David, when he fled from Saul in the cave.” Have pity upon me, O God! have pity upon me, For in thee doth my soul seek refuge! Yea, in the shadow of thy wings do I take shelter, Until these calamities be overpast! ");
INSERT INTO engnoy_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","I call upon God the Most High, Upon God, who performeth all things for me; ");
INSERT INTO engnoy_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","He will send from heaven, and save me; He will put to shame him that panteth for my life; Pause. God will send forth his mercy and his truth. ");
INSERT INTO engnoy_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","My life is in the midst of lions; I dwell among them that breathe out fire; Among men whose teeth are spears and arrows, And whose tongue is a sharp sword. ");
INSERT INTO engnoy_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Exalt thyself, O God! above the heavens, And thy glory above all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","They have prepared a net for my steps; My soul is bowed down; They have digged a pit before me, But into it they have themselves fallen. ");
INSERT INTO engnoy_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","My heart is strengthened, O God! my heart is strengthened! I will sing, and give thanks. ");
INSERT INTO engnoy_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Awake, my soul! awake, psaltery and harp! I will wake with the early dawn. ");
INSERT INTO engnoy_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","I will praise thee, O Lord! among the nations; I will sing to thee among the kingdoms! ");
INSERT INTO engnoy_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","For thy mercy reacheth to the heavens, And thy truth to the clouds! ");
INSERT INTO engnoy_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Exalt thyself, O God! above the heavens, And thy glory above all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","“For the leader of the music. To the tune of “Do not destroy.” A psalm of David.” Do ye, indeed, administer justice faithfully, ye mighty ones? Do ye judge with uprightness, ye sons of men? ");
INSERT INTO engnoy_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Nay, in your hearts ye contrive iniquity; Your hands weigh out violence in the land! ");
INSERT INTO engnoy_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","The wicked are estranged, from their very birth; The liars go astray as soon as they are born. ");
INSERT INTO engnoy_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","They have poison, like the poison of a serpent; Like the deaf adder's, which stoppeth her ear; ");
INSERT INTO engnoy_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Which listeneth not to the voice of the charmer, And of the sorcerer, skilful in incantations. ");
INSERT INTO engnoy_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Break their teeth, O God! in their mouths! Break out the great teeth of the lions, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","May they melt like waters, which flow away; May their arrows, when they aim them, be as if cut in pieces! ");
INSERT INTO engnoy_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","May they be like the snail, which melteth away as it goeth; Like the abortion of a woman, that seeth not the sun! ");
INSERT INTO engnoy_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Before your pots feel the heat of the thorns, Whether fresh, or burning, may they be blown away! ");
INSERT INTO engnoy_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","The righteous shall rejoice, when he seeth such vengeance; He shall bathe his feet in the blood of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Then shall men say, “Truly there is a reward for the righteous! Truly there is a God who is judge upon the earth!” ");
INSERT INTO engnoy_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","“For the leader of the music. To the tune of “Do not destroy.” A psalm of David, when Saul sent, and they watched the house to kill him.” Deliver me from my enemies, O my God! Defend me from them that rise up against me! ");
INSERT INTO engnoy_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Deliver me from the doers of iniquity, And save me from men of blood! ");
INSERT INTO engnoy_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","For, lo! they lie in wait for my life; The mighty are gathered against me, Without any offence or fault of mine, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Without any offence of mine, they run and prepare themselves; Awake to help me, and behold! ");
INSERT INTO engnoy_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Do thou, O Jehovah, God of hosts, God of Israel, Awake to punish all the nations! Show no mercy to any wicked transgressors! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Let them return at evening, Let them howl like dogs, And go round about the city! ");
INSERT INTO engnoy_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Behold! with their mouths they belch out malice; Swords are upon their lips; “For who,” say they, “will hear?” ");
INSERT INTO engnoy_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Yet thou, O LORD! wilt laugh at them; Thou wilt hold all the nations in derision! ");
INSERT INTO engnoy_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O my Strength! to thee will I look! For God is my defence; ");
INSERT INTO engnoy_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","My God will come to meet me with his mercy; God will cause me to look with joy upon my enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Slay them not, lest my people forget; Scatter them by thy power, and cast them down, O Lord, our shield! ");
INSERT INTO engnoy_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","The word of their lips is the sin of their mouth; Let them be overtaken in their pride, For the curses and the falsehood which they utter! ");
INSERT INTO engnoy_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Consume them in thy wrath; consume them that they be no more, That they may know that God ruleth in Jacob, Even to the ends of the earth! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Let them return at evening, Let them howl like dogs, And go round about the city! ");
INSERT INTO engnoy_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Let them wander about for food, When they have passed the night unsatisfied! ");
INSERT INTO engnoy_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","But I will sing of thy power; Yea, in the morning will I sing aloud of thy mercy; For thou hast been my defence, My refuge in the day of my distress. ");
INSERT INTO engnoy_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","To thee, O my Strength! will I sing! For God is my defence; a God of mercy to me. ");
INSERT INTO engnoy_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","“For the leader of the music; upon the Shushan-Eduth; a psalm of David for instruction; when he was at strife with the Syrians of Mesopotamia, and the Syrians of Zoba; when Joab returned, and smote twelve thousand Edomites in the valley of Salt.” O God! thou hast forsaken us; thou hast broken us in pieces; Thou hast been angry! O revive us again! ");
INSERT INTO engnoy_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Thou hast made the land tremble; thou hast rent it; O heal its breaches, for it tottereth! ");
INSERT INTO engnoy_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Thou hast caused thy people to see hard things; Thou hast made us drink the wine of reeling. ");
INSERT INTO engnoy_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Lift up a banner for them that fear thee, For the sake of thy faithfulness, that they may escape! ");
INSERT INTO engnoy_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","That thy beloved may be delivered, Save with thy right hand, and answer me! ");
INSERT INTO engnoy_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","God promiseth in his holiness; I will rejoice; I shall yet divide Shechem, And measure out the valley of Succoth. ");
INSERT INTO engnoy_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gilead shall be mine, and mine Manasseh; Ephraim shall be my helmet, And Judah my sceptre; ");
INSERT INTO engnoy_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moab shall be my wash-bowl; Upon Edom shall I cast my shoe; I shall triumph over Philistia! ");
INSERT INTO engnoy_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Who will bring me to the strong city? Who will lead me into Edom? ");
INSERT INTO engnoy_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Wilt not thou, O God! who didst forsake us, And didst not go forth with our armies? ");
INSERT INTO engnoy_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Give us thine aid in our distress, For vain is the help of man! ");
INSERT INTO engnoy_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Through God we shall do valiantly; For he will tread down our enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","“For the leader of the music. To be sung upon stringed instruments. A psalm of David.” Hear my cry, O God! Attend to my prayer! ");
INSERT INTO engnoy_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","From the extremity of the land I cry unto thee in deep sorrow of heart; Lead me to the rock that is high above me! ");
INSERT INTO engnoy_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","For thou art my refuge, My strong tower against the enemy. ");
INSERT INTO engnoy_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","I shall dwell in thy tabernacle for ever; I will seek refuge under the covert of thy wings. ");
INSERT INTO engnoy_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","For thou, O God! wilt hear my vows, And give me the inheritance of those who fear thy name. ");
INSERT INTO engnoy_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","O prolong the life of the king! May his years extend through many generations! ");
INSERT INTO engnoy_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","May he reign for ever before God! Grant that mercy and truth may preserve him! ");
INSERT INTO engnoy_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","So will I sing praise to thy name for ever; I will daily perform my vows. ");
INSERT INTO engnoy_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","“For the leader of the music of the Jeduthunites, A psalm of David.” Truly my soul resteth on God alone; From him cometh my deliverance! ");
INSERT INTO engnoy_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","He alone is my rock and my salvation; He is my safeguard, I shall not wholly fall! ");
INSERT INTO engnoy_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","How long will ye continue to assault a single man? How long will ye all seek to destroy me, Like a bending wall, or a tottering fence? ");
INSERT INTO engnoy_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","They study how to cast me down from my eminence; They delight in falsehood; They bless with their mouths, but in their hearts they curse. ");
INSERT INTO engnoy_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","My soul, rest thou on God alone, For from him cometh my hope! ");
INSERT INTO engnoy_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","He alone is my rock and my salvation; He is my safeguard, —I shall not fall. ");
INSERT INTO engnoy_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","From God cometh my help and my glory: My strong rock, my refuge, is God. ");
INSERT INTO engnoy_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Trust in him at all times, ye people! Pour out your hearts before him! God is our refuge! ");
INSERT INTO engnoy_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Truly men of low degree are vanity, And men of high degree are a lie; Placed in the balance, They are all lighter than vanity. ");
INSERT INTO engnoy_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Trust not in extortion; Place no vain hopes in rapine! If riches increase, set not your heart upon them! ");
INSERT INTO engnoy_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Once hath God promised, twice have I heard it, That power belongeth unto God. ");
INSERT INTO engnoy_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","To thee also, O Lord! belongeth mercy; For thou dost render to every man according to his work! ");
INSERT INTO engnoy_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","“A psalm of David, when he was in the wilderness of Judah.” O God! thou art my God! earnestly do I seek thee! My soul thirsteth, my flesh longeth for thee, In a dry, thirsty land. where is no water! ");
INSERT INTO engnoy_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Thus I look toward thee in thy sanctuary, To behold thy power and thy glory! ");
INSERT INTO engnoy_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","For thy loving-kindness is better than life; Therefore my lips shall praise thee! ");
INSERT INTO engnoy_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Thus will I bless thee, while I live; In thy name will I lift up my hands! ");
INSERT INTO engnoy_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","My soul shall be satisfied as with marrow and fatness, And with joyful lips my mouth shall praise thee, ");
INSERT INTO engnoy_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","When I think of thee upon my bed, And meditate on thee in the night-watches. ");
INSERT INTO engnoy_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","For thou art my help, And in the shadow of thy wings I rejoice. ");
INSERT INTO engnoy_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","My soul cleaveth to thee; Thy right hand holdeth me up. ");
INSERT INTO engnoy_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","While they who seek to destroy my life Shall themselves go down into the depths of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","They shall be given up to the sword, And be a portion for jackals. ");
INSERT INTO engnoy_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","But the king shall rejoice in God; All that swear by him shall be honored; But the mouth of liars shall be stopped. ");
INSERT INTO engnoy_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","“For the leader of the music. A psalm of David.” Hear my voice, O God! when I pray! Preserve my life from the terrors of the enemy! ");
INSERT INTO engnoy_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Hide me from the assembly of the wicked, From the brawling crowd of evil-doers! ");
INSERT INTO engnoy_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","For like a sword they sharpen their tongues, Like arrows they aim their poisoned words, ");
INSERT INTO engnoy_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","To shoot in secret at the upright; Suddenly do they shoot at him without fear. ");
INSERT INTO engnoy_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","They prepare themselves for an evil deed; They commune of laying secret snares: “Who,” say they, “will see them?” ");
INSERT INTO engnoy_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","They meditate crimes: “We have finished,” say they, “our plans!” The heart and bosom of every one of them are deep. ");
INSERT INTO engnoy_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","But God will shoot an arrow at them; Suddenly shall they be wounded. ");
INSERT INTO engnoy_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Thus their own tongues shall bring them down; All who see them will flee away. ");
INSERT INTO engnoy_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Then will all men stand in awe, And declare what God hath done, And attentively consider his work. ");
INSERT INTO engnoy_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","The righteous shall rejoice, and trust in the LORD; All the upright in heart shall glory. ");
INSERT INTO engnoy_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","“For the leader of the music. A psalm of David.” To thee belongeth trust, to thee praise, O God in Zion! And to thee shall the vow be performed! ");
INSERT INTO engnoy_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","O Thou that hearest prayer! To thee shall all flesh come! ");
INSERT INTO engnoy_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","My iniquities are heavy upon me; But thou wilt forgive our transgressions! ");
INSERT INTO engnoy_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Happy is he whom thou choosest, And bringest near thee to dwell in thy courts! May we be satisfied with the blessings of thy house, Thy holy temple! ");
INSERT INTO engnoy_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","By wonderful deeds dost thou answer us in thy goodness, O God, our salvation! Who art the confidence of all the ends of the earth, And of the most distant seas! ");
INSERT INTO engnoy_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Thou makest fast the mountains by thy power, Being girded with strength! ");
INSERT INTO engnoy_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Thou stillest the roar of the sea, The roar of its waves, And the tumult of the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","They who dwell in the ends of the earth are awed by thy signs; Thou makest the outgoings of the morning and of the evening to rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Thou visitest the earth and waterest it; Thou enrichest it exceedingly; The river of God is full of water. Thou suppliest the earth with corn, When thou hast thus prepared it. ");
INSERT INTO engnoy_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Thou waterest its furrows, And breakest down its ridges; Thou makest it soft with showers, And blessest its increase. ");
INSERT INTO engnoy_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Thou crownest the year with thy goodness; Thy footsteps drop fruitfulness; ");
INSERT INTO engnoy_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","They drop it upon the pastures of the wilderness, And the hills are girded with gladness. ");
INSERT INTO engnoy_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","The pastures are clothed with flocks, And the valleys are covered with corn; They shout, yea, they sing for joy. ");
INSERT INTO engnoy_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","“For the leader of the music. A psalm.” Shout joyfully unto God. all ye lands! ");
INSERT INTO engnoy_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Sing ye the honor of his name; Make his praise glorious! ");
INSERT INTO engnoy_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Say unto God, How terrible are thy doings! Through the greatness of thy power thine enemies are suppliants to thee! ");
INSERT INTO engnoy_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Let all the earth worship thee; Let it sing praise to thee, let it sing praise to thy name! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Come, behold the works of God! How terrible his doings among the sons of men! ");
INSERT INTO engnoy_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","He turned the sea into dry land; They went through the deep on foot; Then we rejoiced in him. ");
INSERT INTO engnoy_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","By his power he ruleth for ever; His eyes are fixed upon the nations; Let not the rebellious exalt themselves! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","O bless our God, ye nations. And make the voice of his praise to be heard! ");
INSERT INTO engnoy_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","It is he who preserveth our lives, And suffereth not our feet to stumble. ");
INSERT INTO engnoy_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Thou hast, indeed, proved us, O God! Thou hast tried us as silver is tried. ");
INSERT INTO engnoy_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Thou broughtest us into a snare, And didst lay a heavy burden upon our backs; ");
INSERT INTO engnoy_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Thou didst cause men to ride upon our heads, And we have gone through fire and water: But thou hast brought us to a place of abundance. ");
INSERT INTO engnoy_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","I will go into thy house with burnt-offerings! I will pay thee my vows,— ");
INSERT INTO engnoy_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","The vows which my lips uttered. Which my mouth promised in my trouble. ");
INSERT INTO engnoy_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Burnt sacrifices of fatlings will I offer to thee with the fat of rams; Bullocks, with he-goats, will I sacrifice to thee. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Come and hear, all ye who fear God, And I will relate what he hath done for me! ");
INSERT INTO engnoy_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","I called upon him with my mouth, And praise is now upon my tongue. ");
INSERT INTO engnoy_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","If I had meditated wickedness in my heart, The Lord would not have heard me: ");
INSERT INTO engnoy_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","But surely God hath heard me; He hath had regard to the voice of my supplication. ");
INSERT INTO engnoy_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Blessed be God, who did not reject my prayer, Nor withhold his mercy from me! ");
INSERT INTO engnoy_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","“For the leader of the music. To be sung on stringed instruments. A psalm.” O God! be merciful to us, and bless us, And cause thy face to shine upon us! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","That thy doings may be known on earth, And thy saving power to all the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Let the nations praise thee, O God! Yea, let all the nations praise thee! ");
INSERT INTO engnoy_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Let all the nations be glad, and shout for joy! For justly dost thou judge the people, And govern the nations on the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Let the nations praise thee, O God! Yea, let all the nations praise thee! ");
INSERT INTO engnoy_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","For the earth hath yielded her increase, And God, our God, hath blessed us. ");
INSERT INTO engnoy_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","May God continue to bless us, And may all the ends of the earth fear him! ");
INSERT INTO engnoy_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","“For the leader of the music. A psalm of David.” Let God arise, and his enemies are scattered, And they who hate him flee before him! ");
INSERT INTO engnoy_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","As smoke is dispersed, so thou dispersest them; As wax melteth before the fire, So perish the wicked before the face of God. ");
INSERT INTO engnoy_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","But the righteous are glad and rejoice in his presence, Yea, they exult exceedingly. ");
INSERT INTO engnoy_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Sing unto God; sing praises to his name! Prepare a way for him who rideth through the desert! Jehovah is his name; be joyful in his presence! ");
INSERT INTO engnoy_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","The father of the fatherless, and the protector of the widow, Is God in his holy habitation. ");
INSERT INTO engnoy_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","God causeth the forsaken to dwell in houses; He leadeth forth to prosperity them that are bound; But the rebellious shall dwell in a barren land. ");
INSERT INTO engnoy_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O God! when thou didst go before thy people, When thou didst march through the wilderness. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","The earth quaked, and the heavens dropped at the presence of God; This Sinai trembled at the presence of God, the God of Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Thou, O God! didst send a plentiful rain; Thou didst strengthen thy wearied inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Thy people established themselves in the land; Thou, O God! in thy goodness, didst prepare it for the needy! ");
INSERT INTO engnoy_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","The Lord gave the song of victory Of the maidens publishing glad tidings to the mighty host. ");
INSERT INTO engnoy_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“The kings with their armies have fled, —have fled! And the matron at home divideth the spoil. ");
INSERT INTO engnoy_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Truly ye may repose yourselves in the stalls, Like the wings of a dove covered with silver, And her feathers with shining gold.” ");
INSERT INTO engnoy_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","When the Most High destroyed the kings in the land, It was white with their bones like Salmon. ");
INSERT INTO engnoy_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Ye lofty hills, ye hills of Bashan, Ye many-topped hills, ye hills of Bashan, ");
INSERT INTO engnoy_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Why frown ye, ye many-topped hills, At the hill in which God is pleased to dwell, In which Jehovah will dwell for ever? ");
INSERT INTO engnoy_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","The chariots of God are myriads, yea, thousands of thousands; The Lord is in the midst of them, as upon Sinai, in the sanctuary. ");
INSERT INTO engnoy_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Thou hast ascended on high, Thou hast led captive the vanquished, Thou hast received gifts among men, Even the rebellious, that here thou mightst dwell, O LORD God! ");
INSERT INTO engnoy_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Praised be the Lord daily! When we are heavy-laden, the Mighty One is our help. ");
INSERT INTO engnoy_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Our God is a God of salvation; From the Lord Jehovah cometh deliverance from death. ");
INSERT INTO engnoy_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","But God smiteth the head of his enemies, Even the hairy crowns of those who go on in their iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","“I will bring them back,” saith the Lord, “from Bashan; I will bring them back from the deep sea; ");
INSERT INTO engnoy_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","That thy foot may be dipped in their blood, That thy dogs may drink the blood of thine enemies.” ");
INSERT INTO engnoy_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","We have seen thy procession, O God! The procession of my God, my king, to his sanctuary! ");
INSERT INTO engnoy_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","The singers go before, the minstrels follow, Amidst damsels playing on timbrels. ");
INSERT INTO engnoy_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Praise ye God in your assemblies; Praise the Lord, all ye from the fountain of Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Here is Benjamin, the youngest, and his leaders; The chiefs of Judah, and their band; The chiefs of Zebulon, and the chiefs of Naphtali. ");
INSERT INTO engnoy_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Thy God has ordained thy strength, O Israel! Show forth thy might, O God! thou who hast wrought for us! ");
INSERT INTO engnoy_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Because of thy temple in Jerusalem Shall kings bring presents to thee. ");
INSERT INTO engnoy_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Rebuke the wild beast of the reeds, The multitude of bulls with the calves of the nations, So that they shall cast themselves down with masses of silver; Scatter thou the nations that delight in war! ");
INSERT INTO engnoy_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Princes shall come out of Egypt; Ethiopia shall haste with outstretched hands to God. ");
INSERT INTO engnoy_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Ye kingdoms of the earth, sing unto God; Sing praises to Jehovah; ");
INSERT INTO engnoy_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","To him who rideth upon the ancient heaven of heavens! Behold, he uttereth his voice, his mighty voice! ");
INSERT INTO engnoy_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Give glory to God, Whose majesty is in Israel, and whose might is in the clouds! ");
INSERT INTO engnoy_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Terrible art thou, O God! from thy sanctuary! The God of Israel giveth strength and power to his people. Praised be God! ");
INSERT INTO engnoy_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","“For the leader of the music. Upon the Shoshannim. A psalm of David.” Save me, O God! For the waters press in to my very life! ");
INSERT INTO engnoy_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","I sink in deep mire, where is no standing; I have come into deep waters, and the waves flow over me. ");
INSERT INTO engnoy_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","I am weary with crying; my throat is parched; Mine eyes are wasted, while I wait for my God. ");
INSERT INTO engnoy_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","More numerous than the hairs of my head are they who hate me without reason; Mighty are they who seek to destroy me, being my enemies without cause: I must restore what I took not away. ");
INSERT INTO engnoy_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O God! thou knowest my offences, And my sins are not hidden from thee! ");
INSERT INTO engnoy_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Let not them that trust in thee through me be put to shame, O Lord Jehovah, God of hosts! Let not them that seek thee through me be confounded, O God of Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","For on account of thee do I suffer reproach, And shame covereth my face! ");
INSERT INTO engnoy_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","I am become a stranger to my brothers; Yea, an alien to my mother's sons. ");
INSERT INTO engnoy_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","For zeal for thy house consumeth me, And the reproaches of them that reproach thee fall upon me. ");
INSERT INTO engnoy_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","When I weep and fast, That is made my reproach; ");
INSERT INTO engnoy_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","When I clothe myself in sackcloth, Then I become their by-word. ");
INSERT INTO engnoy_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","They who sit in the gate speak against me, And I am become the song of drunkards. ");
INSERT INTO engnoy_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Yet will I address my prayer to thee, O LORD! May it be in an acceptable time according to thy great goodness! Hear, O God! and afford me thy sure help! ");
INSERT INTO engnoy_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Save me from the mire, and let me not sink; May I be delivered from my enemies,—from the deep waters! ");
INSERT INTO engnoy_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Let not the water-flood overflow me; Let not the deep swallow me up, And let not the pit close her mouth upon me! ");
INSERT INTO engnoy_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Hear me, O LORD! since great is thy loving-kindness; According to the abundance of thy tender mercies look upon me! ");
INSERT INTO engnoy_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Hide not thy face from thy servant; I am greatly distressed, O make haste to mine aid! ");
INSERT INTO engnoy_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Draw near to me, and redeem my life; Deliver me because of my enemies! ");
INSERT INTO engnoy_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Thou knowest my reproach, and dishonor, and shame; All my adversaries are in thy view! ");
INSERT INTO engnoy_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Reproach hath broken my heart, and I am full of heaviness; I look for pity, but there is none; For comforters, but find none. ");
INSERT INTO engnoy_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","For my food they give me gall, And in my thirst they give me vinegar to drink. ");
INSERT INTO engnoy_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","May their table be to them a snare; May it be a trap to them, while they are at ease! ");
INSERT INTO engnoy_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","May their eyes be darkened, that they may not see; And cause their loins continually to shake! ");
INSERT INTO engnoy_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Pour out upon them thine indignation, And may the heat of thine anger overtake them! ");
INSERT INTO engnoy_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Let their habitation be desolate, And let none dwell in their tents! ");
INSERT INTO engnoy_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","For they persecute those whom thou hast smitten, And talk of the pain of those whom thou hast wounded. ");
INSERT INTO engnoy_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Add iniquity to their iniquity, And let them never come into thy favor! ");
INSERT INTO engnoy_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Let them be blotted out of the book of the living; Let not their names be written with the righteous! ");
INSERT INTO engnoy_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","But I am poor, and sorrowful: May thine aid, O God! set me on high! ");
INSERT INTO engnoy_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Then I will praise the name of God in a song; I will give glory to him with thanksgiving. ");
INSERT INTO engnoy_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","More pleasing shall this be to the LORD Than a full-horned and full-hoofed bullock. ");
INSERT INTO engnoy_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","The afflicted shall see, and rejoice; The hearts of them that fear God shall be revived. ");
INSERT INTO engnoy_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","For the LORD heareth the poor, And despiseth not his people in their bonds. ");
INSERT INTO engnoy_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Let the heaven and the earth praise him; The sea, and all that move therein! ");
INSERT INTO engnoy_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","For God will save Zion, and will build the cities of Judah, That they may dwell therein, and possess it. ");
INSERT INTO engnoy_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Yea, the posterity of his servants shall possess it, And they that love him shall dwell therein. ");
INSERT INTO engnoy_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","“For the leader of the music. A psalm of David, for remembrance.” Make haste, O God! to deliver me, O LORD! come speedily to mine aid! ");
INSERT INTO engnoy_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","May they all be confounded, and covered with shame, Who seek to take my life! May they be driven back with disgrace Who desire to do me injury! ");
INSERT INTO engnoy_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","May they be turned back with shame Who cry out to me, “Aha! aha!” ");
INSERT INTO engnoy_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","But let all who seek thee be glad and rejoice in thee! Let them that love thy protection ever say, “May God be praised!” ");
INSERT INTO engnoy_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","But I am poor and needy; O God! hasten to mine aid! Thou art my help and my deliverer, O LORD! make no delay! ");
INSERT INTO engnoy_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","In thee, O LORD! do I put my trust! Let me never be put to shame! ");
INSERT INTO engnoy_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","In thy goodness deliver and rescue me; Incline thine ear to me, and save me! ");
INSERT INTO engnoy_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Be thou the rock of my abode, where I may continually resort! Thou hast granted me deliverance; For thou art my rock and my fortress! ");
INSERT INTO engnoy_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Save me, O my God! from the hand of the wicked,-From the hand of the unjust and cruel! ");
INSERT INTO engnoy_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","For thou art my hope, O Lord Jehovah! Thou hast been my trust from my youth! ");
INSERT INTO engnoy_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Upon thee have I leaned from my birth; From my earliest breath thou hast been my support; My song hath been continually of thee! ");
INSERT INTO engnoy_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","I am a wonder to many, But thou art my strong refuge. ");
INSERT INTO engnoy_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Let my mouth be filled with thy praise; Yea, all the day long, with thy glory. ");
INSERT INTO engnoy_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Cast me not off in mine old age; Forsake me not, When my strength faileth! ");
INSERT INTO engnoy_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","For my enemies speak against me, And they who lay wait for my life consult together: ");
INSERT INTO engnoy_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","“God,” say they, “hath forsaken him; Pursue and seize him; for he hath none to deliver him!” ");
INSERT INTO engnoy_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O God! be not far from me! Come speedily to mine aid, O my God! ");
INSERT INTO engnoy_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Let them perish with shame who are my enemies; Let them be covered with contempt and dishonor who seek my hurt! ");
INSERT INTO engnoy_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","But I will hope continually; I shall yet praise thee more and more. ");
INSERT INTO engnoy_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","My mouth shall speak of thy goodness,—Of thy sure protection all the day long; For thy mercies are more than I can number. ");
INSERT INTO engnoy_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","I will celebrate thy mighty deeds, O Lord Jehovah! I will make mention of thy goodness, of thine only! ");
INSERT INTO engnoy_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","O God! thou hast taught me from my youth, And thus far have I declared thy wondrous deeds; ");
INSERT INTO engnoy_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","And now, when I am old and gray-headed, O God! forsake me not, Until I make known thine arm to the next generation,-Thy mighty power to all that are to come! ");
INSERT INTO engnoy_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","For thy goodness, O God! reacheth to the heavens; Wonderful things doest thou! O God! who is like unto thee? ");
INSERT INTO engnoy_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Thou hast suffered us to see great and grievous troubles; Thou wilt again give us life, And wilt bring us back from the depths of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Thou wilt increase my greatness; Thou wilt again comfort me! ");
INSERT INTO engnoy_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Then will I praise thee with the psaltery; Even thy faithfulness, O my God! To thee will I sing with the harp, O Holy One of Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","My lips shall rejoice, when I sing to thee; And my soul, which thou hast redeemed from death; ");
INSERT INTO engnoy_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","My tongue also shall continually speak of thy righteousness: For all who seek my hurt are brought to shame and confounded. ");
INSERT INTO engnoy_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","“For Solomon.” To the king, O God! give thy justice, And to the son of a king thy righteousness! ");
INSERT INTO engnoy_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Yea! he shall judge thy people with equity, And thine oppressed ones with justice. ");
INSERT INTO engnoy_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","For the mountains shall bring forth peace to the people, And the hills, through righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","He shall defend the oppressed of the people; He shall save the needy, And break in pieces the oppressor. ");
INSERT INTO engnoy_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","They shall fear thee as long as the sun and moon shall endure, From generation to generation. ");
INSERT INTO engnoy_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","He shall be like rain descending on the mown field,—Like showers which water the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","In his days shall the righteous flourish, And great shall be their prosperity, as long as the moon shall endure. ");
INSERT INTO engnoy_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","He shall have dominion from sea to sea, And from the river to the ends of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","They that dwell in the desert shall bow before him, And his enemies shall lick the dust. ");
INSERT INTO engnoy_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","The kings of Tarshish and of the isles shall bring presents; The kings of Sheba and Seba shall offer gifts; ");
INSERT INTO engnoy_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Yea, all kings shall fall down before him; All nations shall serve him. ");
INSERT INTO engnoy_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","For he shall deliver the poor who crieth for aid, And the oppressed who hath no helper. ");
INSERT INTO engnoy_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","He shall spare the weak and needy, And save the lives of the poor. ");
INSERT INTO engnoy_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","He shall redeem them from deceit and violence, And their blood shall be precious in his sight. ");
INSERT INTO engnoy_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","He shall prosper, and to him shall be given of the gold of Sheba; Prayer also shall be made for him continually, And daily shall he be praised. ");
INSERT INTO engnoy_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","There shall be an abundance of corn in the land; Its fruit shall shake like Lebanon, even on the tops of the mountains; And they of the cities shall flourish as the grass of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","His name shall endure for ever; His name shall be continued as long as the sun. By him shall men bless themselves; All nations shall call him blessed. ");
INSERT INTO engnoy_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Praised be God, Jehovah, the God of Israel, Who alone doeth wonderful things! ");
INSERT INTO engnoy_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Praised be his glorious name for ever! May his glory fill the whole earth! Amen, Amen! ");
INSERT INTO engnoy_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Here end the Psalms of David, the son of Jesse. ");
INSERT INTO engnoy_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","“BOOK III. A psalm of Asaph.” Truly God is good to Israel,—To those who are pure in heart. ");
INSERT INTO engnoy_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Yet my feet almost gave way; My steps had well nigh slipped: ");
INSERT INTO engnoy_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","For I was envious of the proud, When I saw the prosperity of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","For they have no pains even to their death; Their bodies are in full health. ");
INSERT INTO engnoy_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","They have not the woes of other men, Neither are they smitten like other men. ");
INSERT INTO engnoy_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Therefore pride encircleth their neck as a collar; Violence covereth them as a garment. ");
INSERT INTO engnoy_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","From their bosom issueth their iniquity; The designs of their hearts burst forth. ");
INSERT INTO engnoy_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","They mock, and speak of malicious oppression; Their words are haughty; ");
INSERT INTO engnoy_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","They stretch forth their mouth to the heavens, And their tongue goeth through the earth; ");
INSERT INTO engnoy_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Therefore his people walk in their ways, And there drink from full fountains. ");
INSERT INTO engnoy_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","And they say, “How doth God know? How can there be knowledge with the Most High?” ");
INSERT INTO engnoy_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Behold these are the ungodly! Yet they are ever prosperous; they heap up riches. ");
INSERT INTO engnoy_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Verily I have cleansed my heart in vain; In vain have I washed my hands in innocence. ");
INSERT INTO engnoy_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","For every day have I been smitten; Every morn have I been chastened. ");
INSERT INTO engnoy_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","If I should resolve to speak like them, Surely I should be treacherous to the family of thy children. ");
INSERT INTO engnoy_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","So, when I studied to know this, It was painful to my eyes; ");
INSERT INTO engnoy_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Until I went into the sanctuaries of God, And considered what was their end. ");
INSERT INTO engnoy_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Behold! thou hast set them on slippery places; Thou castest them down into unseen pits. ");
INSERT INTO engnoy_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","How are they brought to desolation in a moment, And utterly consumed with sudden destruction! ");
INSERT INTO engnoy_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","As a dream when one awaketh, Thou, O Lord! when thou awakest, wilt make their vain show a derision. ");
INSERT INTO engnoy_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","When my heart was vexed And I was pierced in my reins, ");
INSERT INTO engnoy_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Then was I stupid and without understanding; I was like one of the brutes before thee. ");
INSERT INTO engnoy_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Yet am I ever under thy care; By my right hand thou dost hold me up. ");
INSERT INTO engnoy_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Thou wilt guide me with thy counsel, And at last receive me in glory. ");
INSERT INTO engnoy_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Whom have I in heaven but thee, And whom on earth do I love in comparison with thee? ");
INSERT INTO engnoy_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Though my flesh and my heart fail, God is the strength of my heart, and my portion for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","For, lo! they who are far from thee perish; Thou destroyest all who estrange themselves from thee. ");
INSERT INTO engnoy_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","But it is good for me to draw near to God; I put my trust in the Lord Jehovah, That I may declare all thy works. ");
INSERT INTO engnoy_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","“A psalm of Asaph.” O God! why hast thou cast us off for ever? Why doth thine anger smoke against the flock of thy pasture? ");
INSERT INTO engnoy_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Remember the people which thou didst purchase of old; Thine own inheritance, which thou didst redeem; That Mount Zion, where thou once didst dwell! ");
INSERT INTO engnoy_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Hasten thy steps to those utter desolations! Every thing in the sanctuary hath the enemy abused! ");
INSERT INTO engnoy_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Thine enemies roar in the place of thine assemblies; Their own symbols have they set up for signs. ");
INSERT INTO engnoy_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","They appear like those who raise the axe against a thicket; ");
INSERT INTO engnoy_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","They have broken down the carved work of thy temple with axes and hammers; ");
INSERT INTO engnoy_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","They have cast fire into thy sanctuary; They have profaned, and cast to the ground, the dwelling-place of thy name. ");
INSERT INTO engnoy_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","They said in their hearts, “Let us destroy them all together!” They have burned all God's places of assembly in the land. ");
INSERT INTO engnoy_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","We no longer see our signs; There is no prophet among us, Nor any one that knoweth how long this desolation shall endure. ");
INSERT INTO engnoy_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","How long, O God! shall the adversary revile? Shall the enemy blaspheme thy name for ever? ");
INSERT INTO engnoy_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Why withdrawest thou thy hand, even thy right hand? Take it from thy bosom, and destroy! ");
INSERT INTO engnoy_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Yet God was our king of old, Working salvation in the midst of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Thou didst divide the sea by thy power; Thou didst crush the heads of the sea-monsters in the waters. ");
INSERT INTO engnoy_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Thou didst break in pieces the head of the crocodile; Thou gavest him for food to the inhabitants of the desert. ");
INSERT INTO engnoy_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Thou didst cleave forth the fountain and the stream; Thou didst dry up perennial rivers. ");
INSERT INTO engnoy_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Thine is the day, and thine the night; Thou didst prepare the light and the sun. ");
INSERT INTO engnoy_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Thou didst establish all the boundaries of the earth; Thou didst make summer and winter. ");
INSERT INTO engnoy_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","O remember that the enemy hath reviled Jehovah; That an impious people hath blasphemed thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Give not up the life of thy turtle-dove to the wild beast; Forget not for ever thine afflicted people! ");
INSERT INTO engnoy_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Have regard to thy covenant! For all the dark places of the land are full of the abodes of cruelty. ");
INSERT INTO engnoy_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","O let not the afflicted go away ashamed! Let the poor and needy praise thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Arise, O God! maintain thy cause! Remember how the impious revileth thee daily! ");
INSERT INTO engnoy_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Forget not the clamor of thine adversaries,—The noise of thine enemies, which continually increaseth! ");
INSERT INTO engnoy_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","“For the leader of the music. To the tune of “Do not destroy.” A psalm of Asaph.” We give thanks to thee, O God! we give thanks to thee, and near is thy name; Men shall declare thy wondrous deeds! ");
INSERT INTO engnoy_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","“When I see my time, Then will I judge with equity. ");
INSERT INTO engnoy_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","The earth trembleth, and all her inhabitants; But I uphold her pillars.” ");
INSERT INTO engnoy_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","I say to the proud, Behave not proudly! To the wicked, Lift not up your horn! ");
INSERT INTO engnoy_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Lift not up your horn on high, And speak not with a stiff neck! ");
INSERT INTO engnoy_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","For promotion cometh neither from the east, nor from the west, nor from the south; ");
INSERT INTO engnoy_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","But it is God that judgeth; He putteth down one, and setteth up another. ");
INSERT INTO engnoy_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","For in the hand of the LORD there is a cup; The wine is foaming and full of spices, And of it he poureth out; Even to the dregs shall all the wicked of the earth drink it. ");
INSERT INTO engnoy_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Therefore I will extol him for ever; I will sing praise to the God of Jacob. ");
INSERT INTO engnoy_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","“I will bring down all the power of the wicked; But the righteous shall lift up their heads.” ");
INSERT INTO engnoy_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","“For the leader of the music. Upon stringed instruments. A Psalm of Asaph.” In Judah is God known; Great is his name in Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","In Jerusalem is his tabernacle, And in Zion his dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","There brake he the lightning of the bow, The shield, the sword, and all the weapons of battle. ");
INSERT INTO engnoy_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","More glorious and excellent art thou Than those mountains of robbers! ");
INSERT INTO engnoy_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Spoiled are the stout-hearted; They sank into their sleep; The hands of the mighty were powerless. ");
INSERT INTO engnoy_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Before thy rebuke, O God of Jacob! Fell chariot and horseman into a deep sleep! ");
INSERT INTO engnoy_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Thou, thou, O God! art terrible! Who can stand before thee in thine anger? ");
INSERT INTO engnoy_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Thou didst cause judgment to be heard from heaven; The earth trembled and was still, ");
INSERT INTO engnoy_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","When God arose to judgment, To save all the oppressed of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","The wrath of man shall praise thee, When thou girdest on the whole of thy wrath! ");
INSERT INTO engnoy_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Make and perform vows to Jehovah, your God! Let all that dwell around him bring gifts to the terrible One, ");
INSERT INTO engnoy_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Who casteth down the pride of princes, Who is terrible to the kings of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","“For the leader of the music of the Jeduthunites. A psalm of Asaph.” I call upon God; I cry aloud for help; I call upon God, that he would hear me! ");
INSERT INTO engnoy_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","In the day of my trouble I seek the Lord; In the night is my hand stretched forth continually; My soul refuseth to be comforted. ");
INSERT INTO engnoy_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","I remember God, and am disquieted; I think of him, and my spirit is overwhelmed. ");
INSERT INTO engnoy_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Thou keepest mine eyelids from closing; I am distressed, so that I cannot speak! ");
INSERT INTO engnoy_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","I think of the days of old,—The years of ancient times. ");
INSERT INTO engnoy_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","I call to remembrance my songs in the night; I meditate in my heart, And my spirit inquireth: ");
INSERT INTO engnoy_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Will the Lord be angry for ever? Will he be favorable no more? ");
INSERT INTO engnoy_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Is his mercy utterly withdrawn for ever? Doth his promise fail from generation to generation? ");
INSERT INTO engnoy_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Hath God forgotten to be gracious? Hath he in anger shut up his compassion? ");
INSERT INTO engnoy_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Then I say, “This is mine affliction, A change in the right hand of the Most High.” ");
INSERT INTO engnoy_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","I remember the deeds of Jehovah; I think of thy wonders of old. ");
INSERT INTO engnoy_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","I meditate on all thy works, And talk of thy doings. ");
INSERT INTO engnoy_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Thy ways, O God! are holy! Who so great a god as our God? ");
INSERT INTO engnoy_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Thou art a God who doest wonders; Thou hast manifested thy power among the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","With thy strong arm thou didst redeem thy people,—The sons of Jacob and Joseph. ");
INSERT INTO engnoy_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","The waters saw thee, O God! The waters saw thee, and feared, And the deep trembled. ");
INSERT INTO engnoy_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","The clouds poured out water, The skies sent forth thunder, And thine arrows flew. ");
INSERT INTO engnoy_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Thy thunder roared in the whirlwind; Thy lightning illumined the world; The earth trembled and shook. ");
INSERT INTO engnoy_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Thy way was through the sea, And thy path through great waters; And thy footsteps could not be found. ");
INSERT INTO engnoy_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Thou didst lead thy people like a flock, By the hands of Moses and Aaron. ");
INSERT INTO engnoy_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","“A psalm of Asaph.” Give ear, O my people, to my instruction! Incline your ears to the words of my mouth! ");
INSERT INTO engnoy_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","I will open my mouth in a psalm; I will utter sayings of ancient times. ");
INSERT INTO engnoy_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","What we have heard and learned, And our fathers have told us, ");
INSERT INTO engnoy_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","We will not hide from their children; Showing to the generation to come the praises of Jehovah, His might, and the wonders he hath wrought. ");
INSERT INTO engnoy_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","For he appointed statutes in Jacob, And established a law in Israel, Which he commanded our fathers To make known to their children; ");
INSERT INTO engnoy_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","So that the generation to come might know them; The children, which should be born, and rise up, Who should declare them to their children; ");
INSERT INTO engnoy_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","That they might put their trust in God, And not forget his deeds, But keep his commandments; ");
INSERT INTO engnoy_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","And might not be, like their forefathers, A stubborn and rebellious generation,—A generation whose heart was not fixed upon God, And whose spirit was not steadfast toward the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","The children of Ephraim were like armed bowmen, Who turn their backs in the day of battle. ");
INSERT INTO engnoy_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","They kept not the covenant of God, And refused to walk in his law; ");
INSERT INTO engnoy_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","And forgot his mighty deeds, And the wonders he had shown them. ");
INSERT INTO engnoy_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Marvellous things did he in the sight of their fathers, In the land of Egypt, in the field of Zoan. ");
INSERT INTO engnoy_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","He divided the sea, and caused them to pass through; Yea, he made the waters to stand as a heap. ");
INSERT INTO engnoy_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","By day he led them by a cloud, And all the night by a light of fire. ");
INSERT INTO engnoy_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","He clave the rocks in the wilderness, And gave them drink, as from the great deep. ");
INSERT INTO engnoy_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","From the rock he brought flowing streams, And made water to run down like rivers. ");
INSERT INTO engnoy_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Yet still they sinned against him, And provoked the Most High in the desert. ");
INSERT INTO engnoy_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","They tempted God in their hearts, By asking food for their delight. ");
INSERT INTO engnoy_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Yea, they spake against God, and said, “Can God spread a table in the wilderness? ");
INSERT INTO engnoy_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Behold! he smote the rock, and the water flowed, And streams gushed forth: Is he also able to give bread? Can he provide flesh for his people?” ");
INSERT INTO engnoy_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","When, therefore, the LORD heard this, he was wroth: So a fire was kindled against Jacob, And anger arose against Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Because they believed not in God, And trusted not in his aid. ");
INSERT INTO engnoy_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Yet he had commanded the clouds above, And had opened the doors of heaven; ");
INSERT INTO engnoy_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","And had rained down upon them manna for food, And had given them the corn of heaven. ");
INSERT INTO engnoy_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Every one ate the food of princes; He sent them bread to the full. ");
INSERT INTO engnoy_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Then he caused a strong wind to blow in the heavens, And by his power he brought a south wind; ");
INSERT INTO engnoy_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","He rained down flesh upon them as dust, And feathered fowls as the sand of the sea. ");
INSERT INTO engnoy_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","He caused them to fall in the midst of their camp, Round about their habitations. ");
INSERT INTO engnoy_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","So they did eat, and were filled; For he gave them their own desire. ");
INSERT INTO engnoy_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Their desire was not yet satisfied, And their meat was yet in their mouths, ");
INSERT INTO engnoy_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","When the wrath of God came upon them, And slew their strong men, And smote down the chosen men of Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","For all this they sinned still, And put no trust in his wondrous works. ");
INSERT INTO engnoy_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Therefore he consumed their days in vanity, And their years in sudden destruction. ");
INSERT INTO engnoy_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","When he slew them, they sought him; They returned, and sought earnestly for God; ");
INSERT INTO engnoy_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","And remembered that God was their rock, And the Most High their redeemer. ");
INSERT INTO engnoy_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","But they only flattered him with their mouths, And spake falsely to him with their tongues. ");
INSERT INTO engnoy_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","For their hearts were not true to him, Nor were they steadfast in his covenant. ");
INSERT INTO engnoy_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Yet, being full of compassion, he forgave their iniquity, And would not utterly destroy them; Often he restrained his indignation, And stirred not up all his anger. ");
INSERT INTO engnoy_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","He remembered that they were but flesh,—A breath, that passeth and cometh not back. ");
INSERT INTO engnoy_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","How often did they provoke him in the wilderness! How often did they anger him in the desert! ");
INSERT INTO engnoy_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Again and again they tempted God, And offended the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","They remembered not his hand, Nor the day when he delivered them from the enemy; ");
INSERT INTO engnoy_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","What signs he had wrought in Egypt, And what wonders in the fields of Zoan. ");
INSERT INTO engnoy_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","He turned their rivers into blood, So that they could not drink of their streams. ");
INSERT INTO engnoy_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","He sent amongst them flies, which devoured them, And frogs, which destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","He gave also their fruits to the caterpillar, And their labor to the locust. ");
INSERT INTO engnoy_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","He destroyed their vines with hail, And their sycamore-trees with frost. ");
INSERT INTO engnoy_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","He also gave up their cattle to hail, And their flocks to hot thunderbolts. ");
INSERT INTO engnoy_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","He sent against them the fierceness of his anger, Wrath, indignation, and woe,—A host of angels of evil. ");
INSERT INTO engnoy_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","He made a way for his anger, He spared them not from death, But gave up their lives to the pestilence. ");
INSERT INTO engnoy_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","He smote all the firstborn in Egypt; The first-fruits of their strength in the tents of Ham. ");
INSERT INTO engnoy_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","But he led forth his own people like sheep, And guided them like a flock in the wilderness. ");
INSERT INTO engnoy_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","He led them on safely, so that they feared not, While the sea overwhelmed their enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","He brought them to his own sacred border, Even to this mountain which his right hand had gained. ");
INSERT INTO engnoy_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","He cast out the nations before them, And divided their land by a measuring-line, as an inheritance, And caused the tribes of Israel to dwell in their tents. ");
INSERT INTO engnoy_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Yet they tempted and provoked God, the Most High, And kept not his statutes; ");
INSERT INTO engnoy_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Like their fathers they were faithless, and turned back; They turned aside, like a deceitful bow. ");
INSERT INTO engnoy_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","They provoked his anger by their high places, And stirred up his jealousy by their graven images. ");
INSERT INTO engnoy_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","God saw this, and was wroth, And greatly abhorred Israel; ");
INSERT INTO engnoy_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","So that he forsook the habitation at Shiloh, The tabernacle where he dwelt among men, ");
INSERT INTO engnoy_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","And delivered his strength into captivity, And his glory into the hand of the enemy. ");
INSERT INTO engnoy_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","His own people he gave up to the sword, And was wroth with his own inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Fire consumed their young men, And their maidens did not bewail them. ");
INSERT INTO engnoy_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Their priests fell by the sword, And their widows made no lamentation. ");
INSERT INTO engnoy_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","But at length the Lord awaked as from sleep, As a hero who had been overpowered by wine; ");
INSERT INTO engnoy_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","He smote his enemies, and drove them back, And covered them with everlasting disgrace. ");
INSERT INTO engnoy_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Yet he rejected the tents of Joseph, And chose not the tribe of Ephraim; ");
INSERT INTO engnoy_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","But chose the tribe of Judah, The Mount Zion which he loved; ");
INSERT INTO engnoy_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Where he built, like the heavens, his sanctuary; Like the earth, which he hath established for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","And he chose David, his servant, And took him from the sheepfolds; ");
INSERT INTO engnoy_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","From tending the suckling ewes he brought him To feed Jacob his people, And Israel his inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","He fed them with an upright heart, And guided them with skilful hands. ");
INSERT INTO engnoy_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","“A psalm of Asaph.” O God! the nations have come into thine inheritance; They have polluted thy holy temple; They have made Jerusalem a heap of ruins! ");
INSERT INTO engnoy_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","They have given the dead bodies of thy servants to be food for the birds of heaven, The flesh of thy holy ones to the wild beasts of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Their blood have they shed like water around Jerusalem, And there was none to bury them! ");
INSERT INTO engnoy_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","We have become the reproach of our neighbors,—The scorn and derision of those around us. ");
INSERT INTO engnoy_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","How long, O LORD! wilt thou be angry for ever? How long shall thy jealousy burn like fire? ");
INSERT INTO engnoy_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Pour out thy wrath on the nations which acknowledge thee not. And on the kingdoms which call not upon thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","For they have devoured Jacob, And laid waste his dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","O remember not against us former iniquities; Let thy tender mercy speedily succor us, ");
INSERT INTO engnoy_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","For we are brought very low! Help us, O God of our salvation! for the honor of thy name; F or thy name's sake save us, and forgive our iniquities! ");
INSERT INTO engnoy_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Why should the nations say, “Where is their God?” May the revenging of the blood of thy servants, which hath been shed, Be manifested among the nations before our eyes! ");
INSERT INTO engnoy_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Let the cry of the prisoner come before thee! According to the greatness of thy power preserve those that are appointed to die! ");
INSERT INTO engnoy_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","And return sevenfold into our neighbors' bosoms The reproach with which they have reproached thee, O Lord! ");
INSERT INTO engnoy_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","So shall we, thy people, and the flock of thy pasture, Give thanks to thee for ever. And show forth thy praise to all generations. ");
INSERT INTO engnoy_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","“For the leader of the music. Upon the Shushan-Eduth. A psalm of Asaph.” Give ear, O Shepherd of Israel! Thou who leadest Joseph like a flock, Thou who sittest between the cherubs, shine forth! ");
INSERT INTO engnoy_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Before Ephraim and Benjamin and Manasseh, stir up thy strength, And come and save us! ");
INSERT INTO engnoy_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Bring us back, O God! And cause thy face to shine, that we may be saved! ");
INSERT INTO engnoy_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","O LORD, God of hosts! How long wilt thou be angry against the prayer of thy people? ");
INSERT INTO engnoy_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","For thou causest them to eat the bread of tears, And givest them tears to drink, in full measure. ");
INSERT INTO engnoy_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Thou hast made us the object of strife to our neighbors, And our enemies hold us in derision. ");
INSERT INTO engnoy_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Bring us back, O God of hosts! And cause thy face to shine that we may be saved! ");
INSERT INTO engnoy_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Thou didst bring a vine out of Egypt; Thou didst expel the nations, and plant it. ");
INSERT INTO engnoy_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Thou didst prepare a place for it; It spread its roots, and filled the land. ");
INSERT INTO engnoy_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","The mountains were covered with its shade, And its branches were like the cedars of God. ");
INSERT INTO engnoy_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","It sent out its boughs to the sea, And its branches to the river. ");
INSERT INTO engnoy_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Why hast thou now broken down its hedges, So that all who pass by do pluck from it? ");
INSERT INTO engnoy_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","The boar from the wood doth waste it, And the wild beast of the forest doth devour it. ");
INSERT INTO engnoy_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","O God of hosts! return, we beseech thee, Look down from heaven, and behold, And have regard to this vine! ");
INSERT INTO engnoy_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Protect what thy right hand planted; The branch which thou madest strong for thyself! ");
INSERT INTO engnoy_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","It is burnt with fire; it is cut down; Under thy rebuke they perish. ");
INSERT INTO engnoy_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","May thy hand be over the man of thy right hand, The man whom thou madest strong for thyself! ");
INSERT INTO engnoy_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","So will we no more turn back from thee: Revive us, and upon thy name alone will we call! ");
INSERT INTO engnoy_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Bring us back, O LORD, God of hosts! And cause thy face to shine, that we may he saved! ");
INSERT INTO engnoy_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","“For the leader of the music. On the Gittith. A psalm of Asaph.” Sing joyfully to God, our strength! Shout with gladness to the God of Jacob! ");
INSERT INTO engnoy_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Raise a song, and strike the timbrel, The sweet-sounding harp, and the psaltery! ");
INSERT INTO engnoy_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Blow the trumpet at the new moon; At the full moon, also, on our festal day! ");
INSERT INTO engnoy_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","For this is a statute for Israel, A law of the God of Jacob; ");
INSERT INTO engnoy_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","He appointed it as a memorial in Joseph, When he went out of the land of Egypt, Where he heard a language which he knew not. ");
INSERT INTO engnoy_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“I relieved said he thy shoulders from their burden; Thy hands were removed from the hod. ");
INSERT INTO engnoy_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Thou didst call in trouble, and I delivered thee; In the secret place of thunder I answered thee; I proved thee at the waters of Meribah. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Hear, O my people! and I will admonish thee! O Israel! that thou wouldst hearken to me! ");
INSERT INTO engnoy_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Let there be no strange god within thee, Nor worship thou any foreign god! ");
INSERT INTO engnoy_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","I Jehovah am thy God, Who brought thee out of the land of Egypt: Open wide thy mouth, and I will fill it! ");
INSERT INTO engnoy_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","But my people would not listen to my voice, And Israel would not hearken to me. ");
INSERT INTO engnoy_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","So I gave them up to the obstinacy of their hearts, And they walked according to their own devices. ");
INSERT INTO engnoy_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","“O that my people had hearkened to me! That Israel had walked in my ways! ");
INSERT INTO engnoy_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Soon would I have brought low their enemies, And turned my hand against their adversaries. ");
INSERT INTO engnoy_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","The haters of Jehovah should have become suppliants to them, And their prosperity should have endured for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","With the finest of the wheat I would have fed them, And with honey out of the rock would I have satisfied them.” ");
INSERT INTO engnoy_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","“A psalm of Asaph.” God standeth in God's assembly, He judgeth in the midst of the gods. ");
INSERT INTO engnoy_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“How long will ye judge unjustly, And favor the cause of the wicked? Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Defend the poor and the fatherless; Do justice to the wretched and the needy! ");
INSERT INTO engnoy_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Deliver the poor and the destitute; Save them from the hand of the wicked! ");
INSERT INTO engnoy_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","They are without knowledge and without understanding; They walk in darkness: Therefore all the foundations of the land are shaken. ");
INSERT INTO engnoy_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","I have said, Ye are gods, And all of you children of the Most High; ");
INSERT INTO engnoy_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","But ye shall die like men, And fall like the rest of the princes.” ");
INSERT INTO engnoy_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Arise, O God! judge the earth! For all the nations are thy possession. ");
INSERT INTO engnoy_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","“A psalm of Asaph.” O God! keep not silence! Hold not thy peace, and be not still, O God! ");
INSERT INTO engnoy_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","For, lo! thine enemies roar, And they who hate thee lift up their heads. ");
INSERT INTO engnoy_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","For they form secret plots against thy people, And consult together against thy chosen ones. ");
INSERT INTO engnoy_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","“Come,” say they, “let us blot them out from the number of the nations, That the name of Israel may no more be remembered!” ");
INSERT INTO engnoy_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","With one consent they consult together, Against thee do they form a league,— ");
INSERT INTO engnoy_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","The tents of Edom and the Ishmaelites, Of Moab and the Hagarenes, ");
INSERT INTO engnoy_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gebal and Ammon and Amalek, The Philistines, with the inhabitants of Tyre. ");
INSERT INTO engnoy_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","The Assyrians also are joined with them; They lend their strength to the children of Lot. ");
INSERT INTO engnoy_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Do to them as to the Midianites, As to Sisera, as to Jabin at the brook Kison, ");
INSERT INTO engnoy_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Who perished at Endor, And were trampled like dung to the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Make their chiefs like Oreb and Zeeb; Yea, all their princes as Zeba and Zalmunna! ");
INSERT INTO engnoy_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Who say, “Let us seize on God's habitations!” ");
INSERT INTO engnoy_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Make them, O my God! like whirling chaff; Like stubble before the wind! ");
INSERT INTO engnoy_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","As fire consumeth the forest, And as flame setteth the mountains in a blaze, ");
INSERT INTO engnoy_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","So pursue them with thy tempest, And terrify them with thy storm! ");
INSERT INTO engnoy_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Cover their faces with shame, That they may seek thy name, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Let them be confounded! Yea, let them be put to shame, and perish! ");
INSERT INTO engnoy_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","That they may know that thy name alone is Jehovah; That thou art the Most High over all the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","“For the leader of the music. On the Gittith. A psalm of the sons of Korah.” How lovely are thy tabernacles, O LORD of hosts! ");
INSERT INTO engnoy_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","My soul longeth, yea, fainteth, for the courts of the LORD; My heart and my flesh cry aloud for the living God. ");
INSERT INTO engnoy_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","The very sparrow findeth an abode, And the swallow a nest, where they may lay their young, By thine altars, O LORD of hosts, My king and my God! ");
INSERT INTO engnoy_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Happy they who dwell in thy house, Who are continually praising thee! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Happy the man whose glory is in thee, In whose heart are the ways to Jerusalem! ");
INSERT INTO engnoy_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Passing through the valley of Baca, they make it a fountain; and the early rain covereth it with blessings. ");
INSERT INTO engnoy_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","They go on from strength to strength; Every one of them appeareth before God in Zion. ");
INSERT INTO engnoy_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Hear my prayer, O LORD, God of hosts! Give ear, O God of Jacob! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Look down, O God! our shield, And behold the face of thine anointed! ");
INSERT INTO engnoy_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","For a day spent in thy courts is better than a thousand: I would rather stand on the threshold of the house of my God, Than dwell in the tents of wickedness. ");
INSERT INTO engnoy_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","For the LORD God is a sun and a shield; The LORD giveth grace and glory; No good thing doth he withhold From them that walk uprightly. ");
INSERT INTO engnoy_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","O LORD of hosts! Happy the man who trusteth in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","“For the leader of the music. A psalm of the sons of Korah.” O LORD! thou hast been favorable to thy land; Thou hast brought back the captives of Jacob; ");
INSERT INTO engnoy_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Thou didst forgive the iniquity of thy people, And cover all their sins! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Thou didst take away all thy displeasure, And abate the fierceness of thy wrath. ");
INSERT INTO engnoy_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Restore us, O God of our salvation! And let thine anger towards us cease! ");
INSERT INTO engnoy_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Wilt thou be angry with us for ever? Wilt thou continue thy wrath from generation to generation? ");
INSERT INTO engnoy_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Wilt thou not revive us again, That thy people may rejoice in thee? ");
INSERT INTO engnoy_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Show us thy compassion, O LORD! And grant us thy salvation! ");
INSERT INTO engnoy_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","I will hear what God the LORD will speak: Truly he will speak peace to his people, and to his servants; Only let them not turn again to folly! ");
INSERT INTO engnoy_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Yea, his salvation is near to those who fear him, That glory may dwell in our land. ");
INSERT INTO engnoy_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Mercy and truth shall meet together, Righteousness and peace shall kiss each other; ");
INSERT INTO engnoy_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Truth shall spring out of the earth; Righteousness shall look down from heaven. ");
INSERT INTO engnoy_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yea, Jehovah will give prosperity, And our land shall yield her increase. ");
INSERT INTO engnoy_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Righteousness shall go before him, And set us in the way of his steps. ");
INSERT INTO engnoy_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","“A prayer of David.” Incline thine ear, O LORD! and hear me, For I am poor and distressed! ");
INSERT INTO engnoy_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Preserve my life, for I am devoted to thee! Save, O thou my God! thy servant who trusteth in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Have pity upon me, O Lord! For to thee do I cry daily! ");
INSERT INTO engnoy_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Revive the soul of thy servant, For to thee, O Lord! do I lift up my soul! ");
INSERT INTO engnoy_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","For thou, Lord, art good, and ready to forgive; Yea, rich in mercy to all that call upon thee! ");
INSERT INTO engnoy_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Give ear, O LORD! to my prayer, And attend to the voice of my supplication! ");
INSERT INTO engnoy_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","In the day of my trouble I call upon thee, For thou dost answer me! ");
INSERT INTO engnoy_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Among the gods there is none like thee, O Lord! And there are no works like thy works! ");
INSERT INTO engnoy_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","All the nations which thou hast made must come and worship before thee, O Lord! And glorify thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","For great art thou, and wondrous are thy works; Thou alone art God! ");
INSERT INTO engnoy_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Teach me, O LORD! thy way, That I may walk in thy truth; Unite all my heart to fear thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","I will praise thee, O Lord, my God! with my whole heart; I will give glory to thy name for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","For thy kindness to me hath been great; Thou hast delivered me from the depths of the underworld! ");
INSERT INTO engnoy_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O God! the proud have risen against me; Bands of cruel men seek my life, And set not thee before their eyes. ");
INSERT INTO engnoy_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","But thou, O Lord! art a God full of compassion and kindness, Long-suffering, rich in mercy and truth! ");
INSERT INTO engnoy_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Look upon me, and have compassion upon me! Give thy strength to thy servant, And save the son of thy handmaid! ");
INSERT INTO engnoy_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Show me a token for good, That my enemies may see it and be confounded; Because thou, O LORD! helpest and comfortest me! ");
INSERT INTO engnoy_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","“A psalm of the sons of Korah.” His foundation is in the holy mountains; ");
INSERT INTO engnoy_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Jehovah loveth the gates of Zion More than all the dwellings of Jacob. ");
INSERT INTO engnoy_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Glorious things are said of thee, O city of God! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“I name Egypt and Babylon among them that know me; Behold! Philistia, Tyre, and Ethiopia,—They also were born there.” ");
INSERT INTO engnoy_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","And of Zion it shall be said, “Men of every nation were born there, And the Most High hath established her.” ");
INSERT INTO engnoy_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Jehovah, when he numbereth the nations, shall write, “These were born there!” Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Singers as well as dancers,—All my springs are in thee! ");
INSERT INTO engnoy_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","“A psalm of the sons of Korah. For the leader of the music. Upon wind instruments. A psalm of Heman, the Ezrahite.” O LORD, God of my salvation! To thee do I cry by day, And by night is my prayer before thee! ");
INSERT INTO engnoy_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Let my supplication come before thee; Incline thine ear to my cry! ");
INSERT INTO engnoy_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","For my soul is full of misery, And my life draweth near to the underworld. ");
INSERT INTO engnoy_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","I am counted with those who are going down to the pit; I am like one who hath no strength. ");
INSERT INTO engnoy_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","I am left to myself among the dead, Like the slain who lie in the grave, Whom thou no more rememberest, And who are cut off from thy protecting hand. ");
INSERT INTO engnoy_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Thou hast placed me in a deep pit, In a dark and deep abyss. ");
INSERT INTO engnoy_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Thy wrath presseth hard upon me, And thou afflictest me with all thy waves! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Thou hast put mine acquaintances far from me, Yea, thou hast made me their abhorrence: I am shut up, and cannot go forth. ");
INSERT INTO engnoy_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Mine eyes languish by reason of my affliction. I call upon thee daily, O LORD! To thee do I stretch out my hands! ");
INSERT INTO engnoy_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Canst thou show wonders to the dead? Shall the dead arise, and praise thee? Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Shall thy goodness be declared in the grave, Or thy faithfulness in the place of corruption? ");
INSERT INTO engnoy_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Shall thy wonders be known in the dark, And thy justice in the land of forgetfulness? ");
INSERT INTO engnoy_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","To thee do I cry, O LORD! In the morning doth my cry come before thee. ");
INSERT INTO engnoy_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Why, O LORD! dost thou cast me off? Why hidest thou thy face from me? ");
INSERT INTO engnoy_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","I have been afflicted and languishing from my youth; I suffer thy terrors, and am distracted. ");
INSERT INTO engnoy_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Thy fierce wrath overwhelmeth me; Thy terrors utterly destroy me. ");
INSERT INTO engnoy_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","They surround me daily like water; They compass me about together. ");
INSERT INTO engnoy_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Lover and friend hast thou put far from me; My acquaintances are withdrawn from my sight. ");
INSERT INTO engnoy_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","“A psalm of Ethan, the Ezrahite.” I will sing of the mercies of the LORD for ever; With my mouth will I make known thy faithfulness to all generations! ");
INSERT INTO engnoy_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","For I know that thy mercy endureth for ever; Thou hast established thy truth like the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","“I have made a covenant with my chosen; I have sworn to David, my servant: ");
INSERT INTO engnoy_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Thy family I will establish for ever, And build up thy throne to all generations.” Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","The heavens shall praise thy wonders, O LORD! And the assembly of the holy ones thy truth! ");
INSERT INTO engnoy_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Who in the heavens can be compared to Jehovah? Who is like Jehovah among the sons of God? ");
INSERT INTO engnoy_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","A God greatly to be feared in the assembly of the holy ones, And to be had in reverence above all who are around him? ");
INSERT INTO engnoy_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","O Jehovah, God of hosts! Who is mighty like thee, O Jehovah? And thy faithfulness is round about thee. ");
INSERT INTO engnoy_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Thou rulest the raging of the sea; When the waves thereof rise, thou stillest them! ");
INSERT INTO engnoy_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Thou didst break Rahab in pieces, as one that is slain; Thou didst scatter thine enemies with thy mighty arm. ");
INSERT INTO engnoy_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","The heavens are thine; thine also is the earth; The world and all that is therein, thou didst found them. ");
INSERT INTO engnoy_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","The North and the South were created by thee; Tabor and Hermon rejoice in thy name. ");
INSERT INTO engnoy_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Thine is a mighty arm; Strong is thy hand, and high thy right hand. ");
INSERT INTO engnoy_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Justice and equity are the foundation of thy throne; Mercy and truth go before thy face. ");
INSERT INTO engnoy_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Happy the people that know the trumpet's sound! They walk, O LORD! in the light of thy countenance; ");
INSERT INTO engnoy_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","In thy name they daily rejoice, And in thy righteousness they glory! ");
INSERT INTO engnoy_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","For thou art the glory of their strength; Yea, through thy favor our horn exalteth itself! ");
INSERT INTO engnoy_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","For from Jehovah is our shield, And from the Holy One of Israel is our king. ");
INSERT INTO engnoy_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Once thou spakest in a vision to thy holy one, And saidst,—”I have laid help on one that is mighty; I have exalted one chosen from the people; ");
INSERT INTO engnoy_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","I have found David, my servant; With my holy oil have I anointed him. ");
INSERT INTO engnoy_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","With him shall my hand be established, And my arm shall strengthen him. ");
INSERT INTO engnoy_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","The enemy shall not have power over him, Nor shall the unrighteous man oppress him. ");
INSERT INTO engnoy_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","For I will beat down his foes before him, And overthrow them that hate him. ");
INSERT INTO engnoy_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","My faithfulness and mercy shall be with him, And through my name shall his horn be exalted. ");
INSERT INTO engnoy_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","I will extend his hand to the sea, And his right hand to the rivers. ");
INSERT INTO engnoy_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","He shall say to me, 'Thou art my father, My God, and the rock of my salvation!' ");
INSERT INTO engnoy_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","I will also make him my first-born, Highest of the kings of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","My mercy I will continue to him for ever; My covenant with him shall be steadfast. ");
INSERT INTO engnoy_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","I will make his family to endure for ever; And his throne shall be as lasting as the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Should his children forsake my law, And walk not in my statutes, ");
INSERT INTO engnoy_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Should they break my commandments, And observe not my precepts, ");
INSERT INTO engnoy_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","I will punish their transgressions with a rod, And their iniquity with stripes. ");
INSERT INTO engnoy_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","But my kindness will I not withdraw from him, Nor suffer my faithfulness to fail. ");
INSERT INTO engnoy_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","I will not break my covenant, Nor alter what hath gone from my lips. ");
INSERT INTO engnoy_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Once have I sworn in my holiness, That I will not be false unto David. ");
INSERT INTO engnoy_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","His family shall endure for ever, And his throne as the sun before me. ");
INSERT INTO engnoy_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","It shall be established for ever like the moon; Like the faithful witness in the sky.” ");
INSERT INTO engnoy_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","But now thou forsakest and abhorrest, And art angry with, thine anointed. ");
INSERT INTO engnoy_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Thou hast made void the covenant with thy servant; Thou hast cast his crown to the ground. ");
INSERT INTO engnoy_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Thou hast broken down all his hedges; Thou hast brought his strongholds to ruin. ");
INSERT INTO engnoy_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","All who pass by plunder him; He is a reproach to his neighbors. ");
INSERT INTO engnoy_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Thou hast lifted up the right hand of his enemies; Thou hast made all his adversaries to rejoice. ");
INSERT INTO engnoy_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Yea, thou hast turned the edge of his sword, And made him unable to stand in battle. ");
INSERT INTO engnoy_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Thou hast brought his glory to an end, And hast cast down his throne to the ground. ");
INSERT INTO engnoy_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Thou hast shortened the days of his youth; Thou hast covered him with shame. ");
INSERT INTO engnoy_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","How long, O LORD! wilt thou hide thyself for ever? How long shall thine anger burn like fire? ");
INSERT INTO engnoy_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Remember how short is my life, To what frailty thou hast created all men! ");
INSERT INTO engnoy_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","What man liveth, and seeth not death? Who can deliver himself from the underworld? ");
INSERT INTO engnoy_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Where, Lord, is thy former loving-kindness Which thou didst swear to David in thy truth? ");
INSERT INTO engnoy_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Remember, O Lord! the reproach of thy servants, How I bear in my bosom the taunts of all the many nations, ");
INSERT INTO engnoy_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","With which thine enemies have reproached me, O LORD! With which they have reproached the footsteps of thine anointed! ");
INSERT INTO engnoy_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Praised be Jehovah for ever! Amen, yea, amen! ");
INSERT INTO engnoy_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","“BOOK IV. A prayer of Moses, the man of God.” LORD! thou hast been our dwelling-place In all generations! ");
INSERT INTO engnoy_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Before the mountains were brought forth, Or ever thou hadst formed the earth and the world, Even from everlasting to everlasting thou art God! ");
INSERT INTO engnoy_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","But man thou turnest again to dust, And sayst, “Return, ye children of men!” ");
INSERT INTO engnoy_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","For a thousand years are, in thy sight, As yesterday when it is past, And as a watch in the night. ");
INSERT INTO engnoy_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Thou carriest him away as with a flood; He is a dream; In the morning he springeth up like grass, ");
INSERT INTO engnoy_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Which flourisheth and shooteth up in the morning, And in the evening is cut down, and withered. ");
INSERT INTO engnoy_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","For we are consumed by thine anger, And by thy wrath are we destroyed. ");
INSERT INTO engnoy_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Thou settest our iniquities before thee, Our secret sins in the light of thy countenance. ");
INSERT INTO engnoy_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","By reason of thine anger all our days vanish away; We spend our years like a thought. ");
INSERT INTO engnoy_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","The days of our life are threescore years and ten, And, by reason of strength, may be fourscore years: Yet is the pride of them weariness and sorrow; For it vanisheth swiftly, and we fly away. ");
INSERT INTO engnoy_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Yet who attendeth to the power of thine anger? Who with due reverence regardeth thine indignation? ");
INSERT INTO engnoy_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Teach us so to number our days, That we may apply our hearts to wisdom! ");
INSERT INTO engnoy_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Desist, O LORD! How long—? Have compassion upon thy servants! ");
INSERT INTO engnoy_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Satisfy us speedily with thy mercy, That we may rejoice and be glad all our days! ");
INSERT INTO engnoy_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Make us glad according to the time in which thou hast afflicted us; According to the years in which we have seen adversity! ");
INSERT INTO engnoy_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Let thy deeds be known to thy servants, And thy glory to their children! ");
INSERT INTO engnoy_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Let the favor of the LORD our God be upon us, And establish for us the work of our hands; Yea, the work of our hands, establish thou it! ");
INSERT INTO engnoy_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","He who sitteth under the shelter of the Most High Maketh his abode in the shadow of the Almighty. ");
INSERT INTO engnoy_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","I say to the LORD, Thou art my refuge and my fortress; My God, in whom I trust. ");
INSERT INTO engnoy_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Surely he will deliver thee from the snare of the fowler, And from the wasting pestilence; ");
INSERT INTO engnoy_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","He will cover thee with his feathers, And under his wings shalt thou find refuge; His faithfulness shall be thy shield and buckler. ");
INSERT INTO engnoy_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Thou shalt not be afraid of the terror of the night, Nor of the arrow that flieth by day; ");
INSERT INTO engnoy_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Nor of the pestilence that walketh in darkness, Nor of the plague that destroyeth at noonday. ");
INSERT INTO engnoy_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","A thousand shall fall by thy side, And ten thousand at thy right hand; But thee it shall not touch. ");
INSERT INTO engnoy_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Thou shalt only behold with thine eyes, And see the recompense of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Because thou hast made the LORD thy refuge, And the Most High thy habitation, ");
INSERT INTO engnoy_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","No evil shall befall thee, Nor any plague come near thy dwelling. ");
INSERT INTO engnoy_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","For he will give his angels charge over thee, To guard thee in all thy ways. ");
INSERT INTO engnoy_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","They shall bear thee up in their hands, Lest thou dash thy foot against a stone. ");
INSERT INTO engnoy_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Thou shalt tread upon the lion and the adder; The young lion and the dragon shalt thou trample under foot. ");
INSERT INTO engnoy_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","“Because he loveth me, I will deliver him; I will set him on high, because he knoweth my name. ");
INSERT INTO engnoy_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","When he calleth upon me, I will answer him; I will be with him in trouble; I will deliver him, and bring him to honor. ");
INSERT INTO engnoy_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","With long life will I satisfy him, And show him my salvation.” ");
INSERT INTO engnoy_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","“A psalm for the Sabbath-day.” It is a good thing to give thanks to the LORD, And to sing praises to thy name, O Most High! ");
INSERT INTO engnoy_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","To show forth thy loving-kindness in the morning, And thy faithfulness every night, ");
INSERT INTO engnoy_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Upon the ten-stringed instrument and the lute, Upon the harp with a solemn sound. ");
INSERT INTO engnoy_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","For thou, LORD, hast made me glad by thy doings; In the works of thy hands I greatly rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","How great are thy works, O LORD! How deep thy purposes! ");
INSERT INTO engnoy_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","But the unwise man knoweth not this, And the fool understandeth it not. ");
INSERT INTO engnoy_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","When the wicked spring up like grass, And all who practise iniquity flourish, It is but to be destroyed for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Thou, O LORD! art for ever exalted! ");
INSERT INTO engnoy_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","For, lo! thine enemies, O LORD! For, lo! thine enemies perish, And dispersed are all who do iniquity! ");
INSERT INTO engnoy_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","But my horn thou exaltest like the buffalo's; I am anointed with fresh oil. ");
INSERT INTO engnoy_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Mine eye hath gazed with joy upon mine enemies; Mine ears have heard with joy of my wicked adversaries. ");
INSERT INTO engnoy_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","The righteous shall flourish like the palm-tree; They shall grow up like the cedars of Lebanon; ");
INSERT INTO engnoy_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Planted in the house of the LORD, They shall flourish in the courts of our God. ");
INSERT INTO engnoy_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Even in old age they bring forth fruit; They are green, and full of sap; ");
INSERT INTO engnoy_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","To show that the LORD, my rock, is upright, That there is no unrighteousness in him. ");
INSERT INTO engnoy_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Jehovah reigneth; he is clothed with majesty; Jehovah is clothed with majesty, and girded with strength; Therefore the earth standeth firm, and cannot be moved. ");
INSERT INTO engnoy_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Thy throne was established of old; Thou art from everlasting! ");
INSERT INTO engnoy_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","The floods, O LORD! lift up, The floods lift up their voice; The floods lift up their roaring! ");
INSERT INTO engnoy_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Mightier than the voice of many waters, Yea, than the mighty waves of the sea, Is the LORD in his lofty habitation. ");
INSERT INTO engnoy_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Thy promises are most sure; Holiness becometh thy house, O LORD! for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","O LORD! thou God of vengeance! O thou God of vengeance! shine forth! ");
INSERT INTO engnoy_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Rouse thyself, thou judge of the earth! Render a recompense to the proud! ");
INSERT INTO engnoy_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","How long, O LORD! shall the wicked, How long shall the wicked triumph? ");
INSERT INTO engnoy_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","How long shall their lips pour forth insolence? How long shall all the evil-doers boast? ");
INSERT INTO engnoy_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","O LORD! they trample upon thy people, And oppress thine inheritance! ");
INSERT INTO engnoy_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","They slay the widow, and the stranger, And murder the fatherless; ");
INSERT INTO engnoy_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","And they say, “The LORD doth not see, The God of Jacob doth not regard!” ");
INSERT INTO engnoy_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Be instructed, ye most stupid of mankind! O when, ye fools, will ye be wise? ");
INSERT INTO engnoy_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","He that planted the ear, shall he not hear? He that formed the eye, shall he not see? ");
INSERT INTO engnoy_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","He that chastiseth nations, shall not he punish? He that teacheth man knowledge, shall not he know? ");
INSERT INTO engnoy_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","The LORD knoweth the thoughts of men, That they are vanity. ");
INSERT INTO engnoy_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Happy the man, O LORD! whom thou correctest, Whom by thy teaching thou makest wise; ");
INSERT INTO engnoy_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","To give him peace in the days of adversity, Until a pit be digged for the wicked! ");
INSERT INTO engnoy_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","For the LORD will not forsake his people, Nor abandon his own inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","For judgment shall return to justice, And all the upright in heart shall follow it. ");
INSERT INTO engnoy_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Who will rise up for me against the wicked? Who will stand up for me against the evil-doers? ");
INSERT INTO engnoy_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","If the LORD had not been my help, I had well nigh dwelt in the land of silence. ");
INSERT INTO engnoy_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","When I think that my foot is slipping, Thy goodness, O LORD! holdeth me up. ");
INSERT INTO engnoy_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","In the multitude of anxieties within me, Thy consolations revive my soul. ");
INSERT INTO engnoy_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Shall with thee be allied the throne of iniquity, Which deviseth mischief against law? ");
INSERT INTO engnoy_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","They band together against the life of the righteous, And condemn innocent blood. ");
INSERT INTO engnoy_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","But the LORD is my fortress, And my God the rock of my refuge. ");
INSERT INTO engnoy_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","He will bring upon them their own iniquity; Yea, through their own wickedness he will cut them off; Yea, the LORD, our God, will cut them off. ");
INSERT INTO engnoy_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","O come, let us sing to the LORD; Let us raise a voice of joy to the rock of our salvation! ");
INSERT INTO engnoy_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Let us come into his presence with thanksgiving, And sing joyfully to him with psalms! ");
INSERT INTO engnoy_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","For Jehovah is a great God; Yea, a great king over all gods. ");
INSERT INTO engnoy_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","In his hands are the depths of the earth; His also are the heights of the mountains. ");
INSERT INTO engnoy_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","The sea is his, and he made it; The dry land also his hands formed. ");
INSERT INTO engnoy_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","O come, let us worship and bow down! Let us kneel before the LORD, our maker! ");
INSERT INTO engnoy_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","For he is our God, And we are the people of his pasture and the flock of his hand. O that ye would now hear his voice! ");
INSERT INTO engnoy_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Harden not your hearts as at Meribah the strife, As in the day of temptation Massah in the wilderness, ");
INSERT INTO engnoy_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Where your fathers tempted me And tried me, although they had seen my works. ");
INSERT INTO engnoy_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Forty years was I offended with that generation: And I said, 'They are a people of a perverse heart, And who have no regard to my ways.' ");
INSERT INTO engnoy_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Therefore I sware, in my wrath, That they should not enter into my rest.” ");
INSERT INTO engnoy_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","O sing to Jehovah a new song; Sing to Jehovah, all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Sing to Jehovah; praise his name, Show forth his salvation from day to day! ");
INSERT INTO engnoy_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Proclaim his glory among the nations, His wonders among all people! ");
INSERT INTO engnoy_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","For Jehovah is great, and greatly to be praised; He is to be feared above all gods. ");
INSERT INTO engnoy_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","For all the gods of the nations are idols; But Jehovah made the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Honor and majesty are before him; Glory and beauty are in his holy abode. ");
INSERT INTO engnoy_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Give to Jehovah, ye tribes of the people, Give to Jehovah glory and praise! ");
INSERT INTO engnoy_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Give to Jehovah the glory due to his name; Bring an offering, and come into his courts! ");
INSERT INTO engnoy_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","O worship Jehovah in holy attire! Tremble before him, all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Say among the nations, Jehovah is king; The world shall stand firm; it shall not be moved; He will judge the nations in righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Let the heavens be glad, and the earth rejoice; Let the sea roar, and the fulness thereof; ");
INSERT INTO engnoy_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Let the fields be joyful, with all that is therein; Let all the trees of the forest rejoice ");
INSERT INTO engnoy_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Before Jehovah! for he cometh, He cometh to judge the earth! He will judge the world with justice, And the nations with faithfulness. ");
INSERT INTO engnoy_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","The LORD reigneth, let the earth rejoice! Let the multitude of isles be glad! ");
INSERT INTO engnoy_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Clouds and darkness are round about him; Justice and equity are the foundation of his throne. ");
INSERT INTO engnoy_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Before him goeth a fire, Which burneth up his enemies around. ");
INSERT INTO engnoy_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","His lightnings illumine the world; The earth beholdeth and trembleth. ");
INSERT INTO engnoy_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","The mountains melt like wax at the presence of the LORD, At the presence of the Lord of the whole earth. ");
INSERT INTO engnoy_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","The heavens declare his righteousness, And all nations behold his glory. ");
INSERT INTO engnoy_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Confounded be they who worship graven images, Who glory in idols! To him, all ye gods, bow down! ");
INSERT INTO engnoy_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Zion hath heard, and is glad, And the daughters of Judah exult On account of thy judgments, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","For thou, O LORD! art most high above all the earth; Thou art far exalted above all gods! ");
INSERT INTO engnoy_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Ye that love the LORD, hate evil! He preserveth the lives of his servants, And delivereth them from the hand of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Light is sown for the righteous, And joy for the upright in heart. ");
INSERT INTO engnoy_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Rejoice, O ye righteous, in the LORD, And praise his holy name! ");
INSERT INTO engnoy_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","“A psalm.” Sing to the LORD a new song; For he hath done marvellous things; His own right hand and his holy arm have gotten him the victory! ");
INSERT INTO engnoy_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","The LORD hath made known his salvation; His righteousness hath he manifested in the sight of the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","He hath remembered his mercy and truth toward the house of Israel, And all the ends of the earth have seen the salvation of our God. ");
INSERT INTO engnoy_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Shout unto the LORD, all the earth! Break forth into joy, and exult, and sing! ");
INSERT INTO engnoy_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Sing to the LORD with the harp, With the harp, and the voice of song! ");
INSERT INTO engnoy_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","With clarions, and the sound of trumpets, Make a joyful noise before the LORD the King! ");
INSERT INTO engnoy_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Let the sea roar, and the fulness thereof; The world, and they that dwell therein; ");
INSERT INTO engnoy_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Let the rivers clap their hands, And the mountains rejoice together ");
INSERT INTO engnoy_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Before the LORD! for he cometh to judge the earth! With righteousness will he judge the world, And the nations with equity. ");
INSERT INTO engnoy_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","The LORD reigneth, let the nations tremble! He sitteth between the cherubs, let the earth quake! ");
INSERT INTO engnoy_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Great is the LORD upon Zion; He is exalted over all the nations. ");
INSERT INTO engnoy_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Let men praise thy great and terrible name! It is holy. ");
INSERT INTO engnoy_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Let them declare the glory of the King who loveth justice! Thou hast established equity; Thou dost execute justice in Jacob! ");
INSERT INTO engnoy_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Exalt ye Jehovah, our God, And bow yourselves down at his footstool! He is holy. ");
INSERT INTO engnoy_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses and Aaron, with his priests, And Samuel, who called upon his name,—They called upon the LORD, and he answered them. ");
INSERT INTO engnoy_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","He spake to them in the cloudy pillar; They kept his commandments, And the ordinances which he gave them. ");
INSERT INTO engnoy_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Thou, O LORD, our God! didst answer them; Thou wast to them a forgiving God, Though thou didst punish their transgressions! ");
INSERT INTO engnoy_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Exalt the LORD, our God. And worship at his holy mountain! For the LORD, our God, is holy. ");
INSERT INTO engnoy_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","“A psalm of praise.” Raise a voice of joy unto the LORD, all ye lands! ");
INSERT INTO engnoy_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Serve the LORD with gladness; Come before his presence with rejoicing! ");
INSERT INTO engnoy_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Know ye that Jehovah is God! It is he that made us, and we are his, His people, and the flock of his pasture. ");
INSERT INTO engnoy_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Enter into his gates with thanksgiving, And his courts with praise; Be thankful to him, and bless his name! ");
INSERT INTO engnoy_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","For the LORD is good; his mercy is everlasting; And his truth endureth to all generations. ");
INSERT INTO engnoy_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","“A psalm of David.” I will sing of mercy and justice; To thee, O LORD! will I sing! ");
INSERT INTO engnoy_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","I will have regard to the way of uprightness: When thou shalt come to me, I will walk within my house with an upright heart. ");
INSERT INTO engnoy_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","I will set no wicked thing before mine eyes; I hate the work of evil-doers; It shall not cleave to me. ");
INSERT INTO engnoy_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","The perverse in heart shall be far from me; I will not know a wicked person. ");
INSERT INTO engnoy_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Whoso slandereth his neighbor in secret, him will I cut off; Him that hath a haughty look and a proud heart I will not endure. ");
INSERT INTO engnoy_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Mine eyes shall be upon the faithful of the land, that they may dwell with me; He that walketh in the way of uprightness shall serve me. ");
INSERT INTO engnoy_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","He who practiseth deceit shall not dwell in my house; He who telleth lies shall not remain in my sight. ");
INSERT INTO engnoy_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Every morning will I destroy the wicked of the land, That I may cut off all evil-doers from the city of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","“A prayer of the afflicted, when in deep distress he poureth out his complaint before the Lord.” Hear my prayer, O LORD! And let my cry come unto thee! ");
INSERT INTO engnoy_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Hide not thy face from me in the day of my trouble; Incline thine ear to me when I call! Answer me speedily! ");
INSERT INTO engnoy_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","For my life is consumed like smoke, And my bones burn like a brand. ");
INSERT INTO engnoy_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","My heart is smitten and withered like grass; Yea, I forget to eat my bread. ");
INSERT INTO engnoy_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","By reason of my sighing, my bones cleave to my skin; ");
INSERT INTO engnoy_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","I am like the pelican of the wilderness; I am like an owl amid ruins. ");
INSERT INTO engnoy_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","I am sleepless; I am like a solitary bird upon the house-top. ");
INSERT INTO engnoy_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","All the day long my enemies reproach me; They who rage against me curse by me. ");
INSERT INTO engnoy_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","For I eat ashes like bread, And mingle my drink with tears. ");
INSERT INTO engnoy_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","On account of thine indignation and thy wrath; For thou hast lifted me up and cast me down! ");
INSERT INTO engnoy_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","My life is like a declining shadow, And I wither like grass. ");
INSERT INTO engnoy_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","But thou, O LORD! endurest for ever, And thy name from generation to generation! ");
INSERT INTO engnoy_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Thou wilt arise and have pity upon Zion, For the time to favor her, yea, the set time, is come. ");
INSERT INTO engnoy_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","For thy servants take pleasure in her stones; Yea, they have a regard for her dust. ");
INSERT INTO engnoy_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Then shall the nations fear the name of Jehovah, And all the kings of the earth thy glory. ");
INSERT INTO engnoy_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","For Jehovah will build up Zion; He will appear in his glory. ");
INSERT INTO engnoy_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","He will regard the prayer of the destitute, And not despise their supplication. ");
INSERT INTO engnoy_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","This shall be written for the generation to come, That the people to be born may praise Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","For he looketh down from his holy height, From heaven doth he cast his eye upon the earth, ");
INSERT INTO engnoy_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","To listen to the sighs of the prisoner. To release those that are doomed to death; ");
INSERT INTO engnoy_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","That they may declare the name of Jehovah in Zion, And his praise in Jerusalem, ");
INSERT INTO engnoy_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","When the nations are assembled together, And the kingdoms to serve Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","He hath weakened my strength on the way, He hath shortened my days. ");
INSERT INTO engnoy_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","I say, O my God! take me not away in the midst of my days! Thy years endure through all generations. ");
INSERT INTO engnoy_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Of old hast thou laid the foundations of the earth, And the heavens are the work of thy hands; ");
INSERT INTO engnoy_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","They shall perish, but thou shalt endure; Yea, all of them shall wax old like a garment; As a vesture shalt thou change them, And they shall be changed; ");
INSERT INTO engnoy_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","But thou art the same, And thy years have no end. ");
INSERT INTO engnoy_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","The children of thy servants shall dwell securely, And their posterity shall be established before thee. ");
INSERT INTO engnoy_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","“A psalm of David.” Bless the LORD, O my soul! And all that is within me, bless his holy name! ");
INSERT INTO engnoy_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Bless the LORD, O my soul! And forget not all his benefits! ");
INSERT INTO engnoy_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Who forgiveth all thine iniquities; Who healeth all thy diseases; ");
INSERT INTO engnoy_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Who redeemeth thy life from the grave; Who crowneth thee with loving-kindness and tender mercies; ");
INSERT INTO engnoy_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Who satisfieth thine old age with good, So that thy youth is renewed like the eagle's. ");
INSERT INTO engnoy_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","The LORD executeth justice And equity for all the oppressed. ");
INSERT INTO engnoy_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","He made known his ways to Moses, His doings to the children of Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","The LORD is merciful and kind, Slow to anger and rich in mercy. ");
INSERT INTO engnoy_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","He doth not always chide, Nor doth he keep his anger for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","He hath not dealt with us according to our sins, Nor requited us according to our iniquities. ");
INSERT INTO engnoy_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","As high as are the heavens above the earth, So great is his mercy to them that fear him. ");
INSERT INTO engnoy_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","As far as the east is from the west, So far hath he removed our transgressions from us. ");
INSERT INTO engnoy_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Even as a father pitieth his children, So the LORD pitieth them that fear him. ");
INSERT INTO engnoy_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","For he knoweth our frame, He remembereth that we are dust. ");
INSERT INTO engnoy_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","As for man, his days are as grass; As a flower of the field, so he flourisheth. ");
INSERT INTO engnoy_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","The wind passeth over it, and it is gone; And its place shall know it no more. ");
INSERT INTO engnoy_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","But the mercy of the LORD is from everlasting to everlasting to them that fear him, And his righteousness to children's children, ");
INSERT INTO engnoy_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","To such as keep his covenant, And remember his commandments to do them. ");
INSERT INTO engnoy_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","The LORD hath established his throne in the heavens, And his kingdom ruleth over all. ");
INSERT INTO engnoy_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Bless the LORD, ye his angels, Ye mighty ones who do his commands, Hearkening to the voice of his word! ");
INSERT INTO engnoy_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Bless the LORD, all ye his hosts; Ye, his ministers, who do his pleasure! ");
INSERT INTO engnoy_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Bless the LORD, all his works, In all places of his dominion! Bless the LORD, O my soul! ");
INSERT INTO engnoy_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Bless the LORD, O my soul! O LORD, my God! thou art very great! Thou art clothed with glory and majesty! ");
INSERT INTO engnoy_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","He covereth himself with light as with a garment; He spreadeth out the heavens like a curtain; ");
INSERT INTO engnoy_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","He layeth the beams of his chambers in the waters; He maketh the clouds his chariot; He rideth upon the wings of the wind. ");
INSERT INTO engnoy_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","He maketh the winds his messengers, The flaming lightnings his ministers. ");
INSERT INTO engnoy_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","He established the earth on its foundations; It shall not be removed for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Thou didst cover it with the deep as with a garment; The waters stood above the mountains! ");
INSERT INTO engnoy_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","At thy rebuke they fled; At the voice of thy thunder they hasted away. ");
INSERT INTO engnoy_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","The mountains rose, the valleys sank, In the place which thou didst appoint for them. ");
INSERT INTO engnoy_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Thou hast established a bound which the waters may not pass, That they may not return, and cover the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","He sendeth forth the springs in brooks; They run among the mountains; ");
INSERT INTO engnoy_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","They give drink to all the beasts of the forest; In them the wild asses quench their thirst. ");
INSERT INTO engnoy_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","About them the birds of heaven have their habitation; They sing among the branches. ");
INSERT INTO engnoy_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","He watereth the hills from his chambers; The earth is satisfied with the fruit of thy works! ");
INSERT INTO engnoy_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","He causeth grass to spring up for cattle, And herbage for the service of man, To bring forth food out of the earth, ");
INSERT INTO engnoy_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","And wine that gladdeneth the heart of man, Making his face to shine more than oil, And bread that strengtheneth man's heart. ");
INSERT INTO engnoy_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","The trees of the LORD are full of sap, The cedars of Lebanon, which he hath planted; ");
INSERT INTO engnoy_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","There the birds build their nests; In the cypresses the stork hath her abode. ");
INSERT INTO engnoy_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","The high hills are a refuge for the wild goats, And the rocks for the conies. ");
INSERT INTO engnoy_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","He appointed the moon to mark seasons; The sun knoweth when to go down. ");
INSERT INTO engnoy_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Thou makest darkness, and it is night, When all the beasts of the forest go forth! ");
INSERT INTO engnoy_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","The young lions roar for prey, And seek their food from God. ");
INSERT INTO engnoy_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","When the sun ariseth, they withdraw themselves, And lie down in their dens. ");
INSERT INTO engnoy_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Man goeth forth to his work, And to his labor, until the evening. ");
INSERT INTO engnoy_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O LORD! how manifold are thy works! In wisdom hast thou made them all! The earth is full of thy riches! ");
INSERT INTO engnoy_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Lo! this great and wide sea! In it are moving creatures without number, Animals small and great. ");
INSERT INTO engnoy_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","There go the ships; There is the leviathan, which thou hast made to play therein. ");
INSERT INTO engnoy_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","All these wait on thee To give them their food in due season. ");
INSERT INTO engnoy_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Thou givest it to them, they gather it; Thou openest thine hand, they are satisfied with good. ");
INSERT INTO engnoy_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Thou hidest thy face, they are confounded; Thou takest away their breath, they die, And return to the dust. ");
INSERT INTO engnoy_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Thou sendest forth thy spirit, they are created, And thou renewest the face of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","The glory of the LORD shall endure for ever; The LORD shall rejoice in his works; ");
INSERT INTO engnoy_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","He looketh on the earth, and it trembleth; He toucheth the hills, and they smoke. ");
INSERT INTO engnoy_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","I will sing to the LORD as long as I live, I will sing praise to my God while I have my being. ");
INSERT INTO engnoy_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","May my meditation be acceptable to him! I will rejoice in the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","May sinners perish from the earth, And the wicked be no more! Bless the LORD, O my soul! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","O give thanks unto the LORD; Call upon his name; Make known his deeds among the people! ");
INSERT INTO engnoy_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Sing unto him; sing psalms unto him; Tell ye of all his wondrous works! ");
INSERT INTO engnoy_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Glory ye in his holy name; Let the hearts of them that seek the LORD rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Seek the LORD, and his majesty; Seek his face continually! ");
INSERT INTO engnoy_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Remember the wonders he hath wrought, His miracles and the judgments of his mouth, ");
INSERT INTO engnoy_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","Ye offspring of Abraham his servant, Ye children of Jacob his chosen! ");
INSERT INTO engnoy_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Jehovah, he is our God, His judgments are over all the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","He remembereth his covenant for ever, And the promise to a thousand generations; ");
INSERT INTO engnoy_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","The covenant which he made with Abraham, And the oath which he gave to Isaac; ");
INSERT INTO engnoy_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Which he confirmed to Jacob for a decree, And to Israel for an everlasting covenant. ");
INSERT INTO engnoy_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“To thee,” said he, “will I give the land of Canaan For the lot of your inheritance.” ");
INSERT INTO engnoy_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","When they were yet few in number, Very few, and strangers in the land; ");
INSERT INTO engnoy_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","When they went from nation to nation, From one kingdom to another people, ");
INSERT INTO engnoy_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","He suffered no man to oppress them; Yea, he rebuked kings for their sakes. ");
INSERT INTO engnoy_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Touch not,” said he, “mine anointed, And do my prophets no harm!” ");
INSERT INTO engnoy_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Again, when he commanded a famine in the land, And broke the whole staff of bread, ");
INSERT INTO engnoy_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","He sent a man before them; Joseph was sold as a slave. ");
INSERT INTO engnoy_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","His feet they hurt with fetters; He was bound in chains of iron; ");
INSERT INTO engnoy_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Until his prediction came to pass, And the word of the LORD proved him. ");
INSERT INTO engnoy_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Then the king sent, and loosed him; The ruler of nations, and set him free; ");
INSERT INTO engnoy_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","He made him governor of his house, And lord of all his possessions; ");
INSERT INTO engnoy_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","To bind his princes at his pleasure, And teach his counsellors wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Israel also came into Egypt, And Jacob sojourned in the land of Ham; ");
INSERT INTO engnoy_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Where God increased his people greatly, And made them stronger than their enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","He turned their hearts to hate his people, And form devices against his servants. ");
INSERT INTO engnoy_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Then sent he Moses his servant, And Aaron, whom he had chosen. ");
INSERT INTO engnoy_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","They showed his signs among them, And his wonders in the land of Ham. ");
INSERT INTO engnoy_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","He sent darkness upon them, and made it dark; And they did not disobey his word. ");
INSERT INTO engnoy_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","He turned their waters into blood, And caused their fish to die. ");
INSERT INTO engnoy_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Their land brought forth frogs in abundance, Even in the chambers of their kings. ");
INSERT INTO engnoy_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","He spake, and there came flies, And lice in all their coasts. ");
INSERT INTO engnoy_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Instead of rain he gave them hail, And flaming fire in their land. ");
INSERT INTO engnoy_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","He smote also their vines and fig-trees, And broke the trees of their coasts. ");
INSERT INTO engnoy_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","He spake, and the locusts came. Destructive locusts without number, ");
INSERT INTO engnoy_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Which ate up all the herbage in their land, And devoured the fruits of their fields. ");
INSERT INTO engnoy_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Then he smote all the first-born in their land, The first-fruits of all their strength. ");
INSERT INTO engnoy_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","He led forth his people with silver and gold; Nor was there one feeble person in all their tribes. ");
INSERT INTO engnoy_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Egypt was glad when they departed, For their terror had fallen upon them. ");
INSERT INTO engnoy_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","He spread out a cloud for a covering, And fire to give light by night. ");
INSERT INTO engnoy_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","They asked, and he brought quails, And satisfied them with the bread of heaven. ");
INSERT INTO engnoy_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","He opened the rock, and the waters gushed forth, And ran in the dry places like a river. ");
INSERT INTO engnoy_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","For he remembered his holy promise, Which he had made to Abraham his servant; ");
INSERT INTO engnoy_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","And he led forth his people with joy, And his chosen with gladness. ");
INSERT INTO engnoy_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","He gave to them the lands of the nations, And they inherited the labor of the peoples; ");
INSERT INTO engnoy_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","That they might observe his statutes, And obey his laws. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Praise ye the LORD! O give thanks to the LORD, for he is good; For his mercy endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Who can utter the mighty deeds of the LORD? Who can show forth all his praise? ");
INSERT INTO engnoy_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Happy are they who have regard to justice, Who practise righteousness at all times! ");
INSERT INTO engnoy_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Remember me, O LORD! with the favor promised to thy people; O visit me with thy salvation! ");
INSERT INTO engnoy_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","That I may see the prosperity of thy chosen, That I may rejoice in the joy of thy people, That I may glory with thine inheritance! ");
INSERT INTO engnoy_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","We have sinned with our fathers; We have committed iniquity; we have done wickedly. ");
INSERT INTO engnoy_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Our fathers in Egypt did not regard thy wonders; They remembered not the multitude of thy mercies; But rebelled at the sea, the Red sea. ");
INSERT INTO engnoy_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Yet he saved them for his own name's sake. That he might make his mighty power to be known. ");
INSERT INTO engnoy_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","He rebuked the Red sea, and it was dried up, And he led them through the deep as through a desert. ");
INSERT INTO engnoy_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","He saved them from the hand of him that hated them, And redeemed them from the hand of the enemy. ");
INSERT INTO engnoy_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","The waters covered their enemies; There was not one of them left. ");
INSERT INTO engnoy_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Then believed they his words, And sang his praise. ");
INSERT INTO engnoy_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","But they soon forgot his deeds, And waited not for his counsel. ");
INSERT INTO engnoy_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","They gave way to appetite in the wilderness, And tempted God in the desert; ");
INSERT INTO engnoy_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","And he gave them their request, But sent upon them leanness. ");
INSERT INTO engnoy_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","They also envied Moses in the camp, And Aaron, the holy one of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Then the earth opened, and swallowed up Dathan, And covered the company of Abiram, ");
INSERT INTO engnoy_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","And a fire was kindled in their company; The flames burned up the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","They made a calf in Horeb, And worshipped a molten image; ");
INSERT INTO engnoy_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","They changed their God of glory Into the image of a grass-eating ox. ");
INSERT INTO engnoy_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","They forgot God, their saviour, Who had done such great things in Egypt, ");
INSERT INTO engnoy_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Such wonders in the land of Ham. Such terrible things at the Red sea. ");
INSERT INTO engnoy_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Then he said that he would destroy them; Had not Moses, his chosen, stood before him in the breach, To turn away his wrath, that he might not destroy them. ");
INSERT INTO engnoy_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","They also despised the pleasant land, And believed not his word; ");
INSERT INTO engnoy_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","But murmured in their tents, And would not hearken to the voice of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Then he lifted up his hand against them, And swore that he would make them fall in the wilderness; ");
INSERT INTO engnoy_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","That he would overthrow their descendants among the nations, And scatter them in the lands. ");
INSERT INTO engnoy_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","They also gave themselves to the worship of Baal-peor, And ate sacrifices offered to lifeless idols. ");
INSERT INTO engnoy_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Thus they provoked his anger by their practices, And a plague broke in upon them. ");
INSERT INTO engnoy_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Then stood up Phinehas, and executed judgment, And the plague was stayed. ");
INSERT INTO engnoy_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","And this was counted to him for righteousness, To all generations for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","They provoked him also at the waters of Meribah strife, And evil befell Moses on their account. ");
INSERT INTO engnoy_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","For they provoked his spirit, So that he spake inconsiderately with his lips. ");
INSERT INTO engnoy_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","They did not destroy the nations, As Jehovah had commanded them. ");
INSERT INTO engnoy_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","They mingled themselves with the peoples, And learned their practices. ");
INSERT INTO engnoy_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","They even worshipped their idols, Which became to them a snare. ");
INSERT INTO engnoy_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Their sons and their daughters they sacrificed to demons, ");
INSERT INTO engnoy_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","And shed innocent blood, The blood of their own sons and daughters, Whom they sacrificed to the idols of Canaan; And the land was polluted with blood. ");
INSERT INTO engnoy_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Thus they defiled themselves with their works, And played the harlot with their practices. ");
INSERT INTO engnoy_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Then burned the anger of the LORD against his people, So that he abhorred his own inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","And he gave them into the hand of the nations, And they who hated them ruled over them. ");
INSERT INTO engnoy_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Their enemies oppressed them, And they were bowed down under their hand. ");
INSERT INTO engnoy_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Many times did he deliver them; But they provoked him by their devices, And they were brought low for their iniquities. ");
INSERT INTO engnoy_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Yet, when he heard their cries, He had regard to their affliction; ");
INSERT INTO engnoy_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","He remembered his covenant with them, And repented according to the greatness of his mercy, ");
INSERT INTO engnoy_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","And caused them to find pity Among all that carried them captive. ");
INSERT INTO engnoy_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Save us, O Jehovah, our God! and gather us from among the nations, That we may give thanks to thy holy name, And glory in thy praise! ");
INSERT INTO engnoy_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Blessed be Jehovah, the God of Israel, From everlasting to everlasting! And let all the people say, Amen! Praise ye Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","“BOOK V.” O give thanks to the LORD, for he is good; For his mercy endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Let the redeemed of the LORD say it, Whom he hath redeemed from the hand of the enemy; ");
INSERT INTO engnoy_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Whom he hath gathered from the lands, From the east, the west, the north, and the south. ");
INSERT INTO engnoy_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","They were wandering in the wilderness, in a desert, They found no way to a city to dwell in. ");
INSERT INTO engnoy_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","They were hungry and thirsty, And their souls fainted within them. ");
INSERT INTO engnoy_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Then they cried to the LORD in their trouble, And he delivered them out of their distress. ");
INSERT INTO engnoy_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","He led them in a straight way, Till they came to a city where they might dwell. ");
INSERT INTO engnoy_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","O let them praise the LORD for his goodness, For his wonderful works to the children of men! ");
INSERT INTO engnoy_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","For he satisfieth the thirsty, And the hungry he filleth with good. ");
INSERT INTO engnoy_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","They dwelt in darkness and the shadow of death, Being bound in affliction and iron; ");
INSERT INTO engnoy_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Because they disobeyed the commands of God, And contemned the will of the Most High; ");
INSERT INTO engnoy_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Their hearts he brought down by hardship; They fell down, and there was none to help. ");
INSERT INTO engnoy_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","But they cried to the LORD in their trouble, And he saved them out of their distresses; ");
INSERT INTO engnoy_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","He brought them out of darkness and the shadow of death, And brake their bands asunder. ");
INSERT INTO engnoy_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","O let them praise the LORD for his goodness, For his wonderful works to the children of men! ");
INSERT INTO engnoy_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","For he hath broken the gates of brass, And cut the bars of iron asunder. ");
INSERT INTO engnoy_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","The foolish, because of their transgressions, And because of their iniquities, were afflicted; ");
INSERT INTO engnoy_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","They abhorred all kinds of food; They were near to the gates of death. ");
INSERT INTO engnoy_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Then they cried to the LORD in their trouble, And he delivered them out of their distresses; ");
INSERT INTO engnoy_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","He sent his word, and healed them, And saved them from their destruction. ");
INSERT INTO engnoy_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","O let them praise the LORD for his goodness, For his wonderful works to the children of men! ");
INSERT INTO engnoy_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Let them offer the sacrifices of thanksgiving, And declare his works with joy! ");
INSERT INTO engnoy_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","They who go down to the sea in ships, And do business in great waters, ");
INSERT INTO engnoy_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","These see the works of the LORD, And his wonders in the deep. ");
INSERT INTO engnoy_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","He commandeth, and raiseth the stormy wind, Which lifteth high the waves. ");
INSERT INTO engnoy_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","They mount up to the heavens, They sink down to the depths, Their soul melteth with distress; ");
INSERT INTO engnoy_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","They reel and stagger like a drunken man, And all their skill is vain. ");
INSERT INTO engnoy_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Then they cry to the LORD in their trouble, And he saveth them out of their distresses; ");
INSERT INTO engnoy_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","He turneth the storm into a calm, And the waves are hushed; ");
INSERT INTO engnoy_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Then they rejoice that they are still, And he bringeth them to their desired haven. ");
INSERT INTO engnoy_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","O let them praise the LORD for his goodness. For his wonderful works to the children of men! ");
INSERT INTO engnoy_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Let them extol him in the congregation of the people, And praise him in the assembly of the elders! ");
INSERT INTO engnoy_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","He turneth rivers into a desert, And springs of water into dry ground; ");
INSERT INTO engnoy_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","A fruitful land into barrenness, For the wickedness of them that dwell therein. ");
INSERT INTO engnoy_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","He turneth the desert into a lake of water, And dry ground into springs of water; ");
INSERT INTO engnoy_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","And there he causeth the hungry to dwell, And they build a city for a dwelling-place, ");
INSERT INTO engnoy_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","And sow fields and plant vineyards, Which yield a fruitful increase. ");
INSERT INTO engnoy_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","He blesseth them, so that they multiply greatly, And suffereth not their cattle to decrease. ");
INSERT INTO engnoy_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","When they are diminished and brought low By oppression, affliction, and sorrow, ");
INSERT INTO engnoy_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","He poureth contempt upon princes, And causeth them to wander in a pathless wilderness; ");
INSERT INTO engnoy_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","But he raiseth the poor from their affliction, And increaseth their families like a flock. ");
INSERT INTO engnoy_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","The righteous see it and rejoice, And all iniquity shutteth her mouth. ");
INSERT INTO engnoy_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Whoso is wise, let him observe this, And have regard to the loving-kindness of the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","“A psalm of David.” O God! my heart is strengthened! I will sing and give thanks. ");
INSERT INTO engnoy_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Awake, my soul! awake, my psaltery and harp! I will wake with the early dawn. ");
INSERT INTO engnoy_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","I will praise thee, O LORD! among the nations; I will sing to thee among the peoples! ");
INSERT INTO engnoy_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","For thy mercy reacheth to the heavens, And thy truth above the clouds. ");
INSERT INTO engnoy_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Exalt thyself, O God! above the heavens, And thy glory above all the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","That thy beloved ones may be delivered, Save with thy right hand, and answer me! ");
INSERT INTO engnoy_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","God promiseth in his holiness; I will rejoice; I shall yet divide Shechem, And measure out the valley of Succoth; ");
INSERT INTO engnoy_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gilead shall be mine, and mine Manasseh; Ephraim shall be my helmet, And Judah my sceptre. ");
INSERT INTO engnoy_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moab shall be my washbowl; Upon Edom shall I cast my shoe; I shall triumph over Philistia. ");
INSERT INTO engnoy_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Who will bring me to the strong city? Who will lead me into Edom? ");
INSERT INTO engnoy_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Wilt not thou, O God! who didst forsake us, Who didst not go forth with our armies? ");
INSERT INTO engnoy_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Give us thine aid in our distress, For vain is the help of man! ");
INSERT INTO engnoy_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Through God we shall do valiantly; For he will tread down our enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","“For the leader of the music. A psalm of David.” O God of my praise! be not silent! ");
INSERT INTO engnoy_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","For the mouths of the wicked and the deceitful are opened against me; They speak against me with a lying tongue. ");
INSERT INTO engnoy_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","They assault me on every side with words of hatred; They fight against me without a cause. ");
INSERT INTO engnoy_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","For my love they are my adversaries: But I give myself unto prayer. ");
INSERT INTO engnoy_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","They repay me evil for good, And hatred for love. ");
INSERT INTO engnoy_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Set thou a wicked man over him, And let an adversary stand at his right hand! ");
INSERT INTO engnoy_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","When he is judged, may he be condemned, And may his prayer be a crime! ");
INSERT INTO engnoy_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","May his days be few, And another take his office! ");
INSERT INTO engnoy_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","May his children be fatherless, And his wife a widow! ");
INSERT INTO engnoy_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","May his children be vagabonds and beggars, And from their ruined dwellings seek their bread! ");
INSERT INTO engnoy_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","May a creditor seize on all that he hath, And a stranger plunder his substance! ");
INSERT INTO engnoy_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","May there be none to show him compassion, And none to pity his fatherless children! ");
INSERT INTO engnoy_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","May his posterity be cut off; In the next generation may his name be blotted out! ");
INSERT INTO engnoy_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","May the iniquity of his fathers be remembered by the LORD, And may the sin of his mother never be blotted out! ");
INSERT INTO engnoy_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","May they be before the LORD continually; And may he cut off their memory from the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Because he remembered not to show pity, But persecuted the afflicted and the poor man, And sought the death of the broken-hearted. ");
INSERT INTO engnoy_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","As he loved cursing, let it come upon him; As he delighted not in blessing, let it be far from him! ");
INSERT INTO engnoy_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","May he be clothed with cursing as with a garment; May it enter like water into his bowels, And like oil into his bones! ");
INSERT INTO engnoy_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","May it be to him like the robe that covereth him, Like the girdle with which he is constantly girded! ");
INSERT INTO engnoy_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","May this be the wages of mine adversaries from the LORD, And of them that speak evil against me! ");
INSERT INTO engnoy_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","But do thou, O LORD, my God! take part with me, For thine own name's sake! Because great is thy mercy, O deliver me! ");
INSERT INTO engnoy_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","For I am afflicted and needy, And my heart is wounded within me. ");
INSERT INTO engnoy_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","I am going like a shadow; I am driven away as the locust. ");
INSERT INTO engnoy_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","My knees totter from fasting, And my flesh faileth of fatness. ");
INSERT INTO engnoy_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","I am a reproach to my enemies; They gaze at me; they shake their heads. ");
INSERT INTO engnoy_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Help me, O LORD, my God! O save me, according to thy mercy! ");
INSERT INTO engnoy_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","That they may know that this is thy hand; That thou, O Lord! hast done it! ");
INSERT INTO engnoy_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Let them curse, but do thou bless! When they arise, let them be put to shame; But let thy servant rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","May my enemies be clothed with ignominy; May they be covered with their shame, as with a mantle! ");
INSERT INTO engnoy_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","I will earnestly praise the LORD with my lips; In the midst of the multitude I will praise him. ");
INSERT INTO engnoy_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","For he standeth at the right hand of the poor, To save him from those who would condemn him. ");
INSERT INTO engnoy_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","“A psalm of David.” Jehovah said to my lord, “Sit thou at my right hand, Until I make thy foes thy footstool.” ");
INSERT INTO engnoy_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Jehovah will extend the sceptre of thy power from Zion: Rule thou in the midst of thine enemies! ");
INSERT INTO engnoy_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Thy people shall be ready, when thou musterest thy forces, in holy splendor; Thy youth shall come forth like dew from the womb of the morning. ");
INSERT INTO engnoy_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Jehovah hath sworn, and he will not repent: “Thou art a priest for ever, After the order of Melchisedeck!” ");
INSERT INTO engnoy_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","The Lord is at thy right hand, He shall crush kings in the day of his wrath. ");
INSERT INTO engnoy_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","He shall execute justice among the nations; He shall fill them with dead bodies, He shall crush the heads of his enemies over many lands. ");
INSERT INTO engnoy_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","He shall drink of the brook in the way; Therefore shall he lift up his head. ");
INSERT INTO engnoy_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Praise ye the LORD! I will praise the LORD with my whole heart, In the assembly of the righteous, and in the congregation. ");
INSERT INTO engnoy_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","The works of the LORD are great, Sought out by all who have pleasure in them. ");
INSERT INTO engnoy_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","His deeds are honorable and glorious, And his righteousness endureth for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","He hath established a memorial of his wonders; The LORD is gracious and full of compassion. ");
INSERT INTO engnoy_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","He giveth meat to them that fear him; He is ever mindful of his covenant. ");
INSERT INTO engnoy_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","He showed his people the greatness of his works, When he gave them the inheritance of the heathen. ");
INSERT INTO engnoy_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","The deeds of his hands are truth and justice; All his commandments are sure; ");
INSERT INTO engnoy_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","They stand firm for ever and ever, Being founded in truth and justice. ");
INSERT INTO engnoy_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","He sent redemption to his people; He established his covenant for ever; Holy, and to be had in reverence, is his name. ");
INSERT INTO engnoy_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","The fear of the LORD is the beginning of wisdom; A good understanding have all they who keep his commandments; His praise endureth for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Praise ye the LORD! Happy the man who feareth the LORD, Who taketh delight in his commandments! ");
INSERT INTO engnoy_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","His posterity shall be mighty on the earth; The race of the righteous shall be blessed. ");
INSERT INTO engnoy_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Wealth and riches shall be in his house; His righteousness shall endure for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","To the righteous shall arise light out of darkness; He is gracious and full of compassion and righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Happy the man who hath pity and lendeth! He shall sustain his cause in judgment; ");
INSERT INTO engnoy_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Yea, he shall never be moved: The righteous shall be in everlasting remembrance. ");
INSERT INTO engnoy_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","He is not afraid of evil tidings; His heart is firm, trusting in the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","His heart is firm; he hath no fear, Till he see his desire upon his enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","He hath scattered blessings; he hath given to the poor; His righteousness shall endure for ever; His horn shall be exalted with honor. ");
INSERT INTO engnoy_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","The wicked shall see, and be grieved; He shall gnash his teeth, and melt away; The desire of the wicked shall perish. ");
INSERT INTO engnoy_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Praise ye the LORD! Praise, O ye servants of the LORD! Praise the name of the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Blessed be the name of the LORD From this time forth, even for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","From the rising of the sun to its going down, May the LORD'S name be praised! ");
INSERT INTO engnoy_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","The LORD is high above all nations; His glory is above the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Who is like the LORD, our God, That dwelleth on high, ");
INSERT INTO engnoy_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","That looketh down low Upon the heavens and the earth? ");
INSERT INTO engnoy_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","He raiseth the poor from the dust, And exalteth the needy from the dunghill, ");
INSERT INTO engnoy_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","To set him among princes, Even among the princes of his people. ");
INSERT INTO engnoy_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","He causeth the barren woman to dwell in a house, A joyful mother of children. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","When Israel came forth from Egypt, The house of Jacob from a people of strange language, ");
INSERT INTO engnoy_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Judah was his sanctuary, And Israel his dominion. ");
INSERT INTO engnoy_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","The sea beheld, and fled; The Jordan turned back. ");
INSERT INTO engnoy_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","The mountains skipped like rams, And the hills like lambs. ");
INSERT INTO engnoy_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","What aileth thee, O thou sea! that thou fleest? Thou, Jordan, that thou runnest back? ");
INSERT INTO engnoy_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ye mountains, that ye skip like rams, And ye hills like lambs? ");
INSERT INTO engnoy_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Tremble, O earth! at the presence of the Lord, At the presence of the God of Jacob; ");
INSERT INTO engnoy_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Who turned the rock into a standing lake, And the flint into a fountain of water! ");
INSERT INTO engnoy_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Not unto us, O LORD! not unto us, But unto thy name, give glory, For thy mercy and thy truth's sake! ");
INSERT INTO engnoy_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Why should the nations say, “Where is now their God?” ");
INSERT INTO engnoy_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Our God is in the heavens; He doeth whatever he pleaseth. ");
INSERT INTO engnoy_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Their idols are silver and gold, The work of men's hands: ");
INSERT INTO engnoy_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","They have mouths, but they speak not; Eyes have they, but they see not; ");
INSERT INTO engnoy_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","They have ears, but they hear not; Noses have they, but they smell not; ");
INSERT INTO engnoy_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","They have hands, but they handle not; They have feet, but they walk not; Nor do they speak with their throats. ");
INSERT INTO engnoy_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","They who make them are like unto them; And so is every one that trusteth in them. ");
INSERT INTO engnoy_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","O Israel! trust thou in the LORD! He is their help and their shield. ");
INSERT INTO engnoy_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","O house of Aaron! trust ye in the LORD! He is their help and their shield. ");
INSERT INTO engnoy_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Ye that fear the LORD trust in the LORD! He is their help and their shield. ");
INSERT INTO engnoy_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","The LORD hath been mindful of us; he will bless us; He will bless the house of Israel; He will bless the house of Aaron. ");
INSERT INTO engnoy_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","He will bless them that fear the LORD, both small and great. ");
INSERT INTO engnoy_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","The LORD will increase you more and more, You and your children. ");
INSERT INTO engnoy_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Blessed are ye of the LORD, Who made heaven and earth. ");
INSERT INTO engnoy_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","The heaven is the LORD'S heaven; But the earth he hath given to the sons of men. ");
INSERT INTO engnoy_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","The dead praise not the LORD,—No one who goeth down into silence. ");
INSERT INTO engnoy_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","But we will bless the LORD, From this time forth even for ever! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","I rejoice that the LORD hath heard the voice of my supplication, ");
INSERT INTO engnoy_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","That he hath inclined his ear to me and heard me; I will call upon him as long as I live. ");
INSERT INTO engnoy_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","The snares of death encompassed me, And the pains of the underworld seized upon me; I found distress and sorrow. ");
INSERT INTO engnoy_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Then called I upon the LORD: O LORD! deliver me! ");
INSERT INTO engnoy_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Gracious is the LORD, and righteous; Yea, our God is merciful. ");
INSERT INTO engnoy_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","The LORD preserveth the simple; I was brought low, and he helped me. ");
INSERT INTO engnoy_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Return, O my soul! to thy rest! For the LORD hath dealt kindly with thee. ");
INSERT INTO engnoy_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","For thou hast preserved me from death; Thou hast kept mine eyes from tears, And my feet from falling! ");
INSERT INTO engnoy_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","I shall walk before the LORD, In the land of the living. ");
INSERT INTO engnoy_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","I had trust, although I said, “I am grievously afflicted!” ");
INSERT INTO engnoy_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","I said in my distress, “All men are liars.” ");
INSERT INTO engnoy_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","What shall I render to the LORD For all his benefits to me? ");
INSERT INTO engnoy_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","I will take the cup of salvation, And call upon the name of the LORD; ");
INSERT INTO engnoy_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","I will pay my vows to the LORD, In the presence of all his people. ");
INSERT INTO engnoy_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Precious in the eyes of the LORD Is the death of his holy ones. ");
INSERT INTO engnoy_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Hear, O LORD! for I am thy servant; I am thy servant, the son of thy handmaid! Thou hast loosed my bonds. ");
INSERT INTO engnoy_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","I will offer to thee the sacrifice of thanksgiving, And will call upon the name of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","I will pay my vows to the LORD In the presence of all his people, ");
INSERT INTO engnoy_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","In the courts of the house of the LORD, In the midst of thee, O Jerusalem! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Praise the LORD, all ye nations! Praise him, all ye people! ");
INSERT INTO engnoy_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","For great toward us hath been his kindness, And the faithfulness of the LORD endureth for ever. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","O give thanks to the LORD, for he is good; For his kindness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Let Israel now say, His kindness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Let the house of Aaron now say, His goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Let all who fear the LORD say, His kindness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","I called upon the LORD in distress; He heard, and set me in a wide place. ");
INSERT INTO engnoy_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","The LORD is on my side, I will not fear: What can man do to me? ");
INSERT INTO engnoy_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","The LORD is my helper; I shall see my desire upon my enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","It is better to trust in the LORD Than to put confidence in man; ");
INSERT INTO engnoy_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","It is better to trust in the LORD Than to put confidence in princes. ");
INSERT INTO engnoy_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","All the nations beset me around, But in the name of the LORD I destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","They beset me on every side; But in the name of the LORD I destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","They beset me around like bees; They were quenched like the fire of thorns, For in the name of the LORD I destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Thou didst assail me with violence to bring me down! But the LORD was my support. ");
INSERT INTO engnoy_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","The LORD is my glory and my song; For to him I owe my salvation. ");
INSERT INTO engnoy_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","The voice of joy and salvation is in the habitations of the righteous: “The right hand of the LORD doeth valiantly; ");
INSERT INTO engnoy_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","The right hand of the LORD is exalted; The right hand of the LORD doeth valiantly.” ");
INSERT INTO engnoy_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","I shall not die, but live, And declare the deeds of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","The LORD hath sorely chastened me, But he hath not given me over to death. ");
INSERT INTO engnoy_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Open to me the gates of righteousness, That I may go in, and praise the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","This is the gate of the LORD, Through which the righteous enter. ");
INSERT INTO engnoy_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","I praise thee that thou hast heard me, And hast been my salvation. ");
INSERT INTO engnoy_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","“The stone which the builders rejected Hath become the chief corner-stone. ");
INSERT INTO engnoy_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","This is the LORD'S doing; It is marvellous in our eyes! ");
INSERT INTO engnoy_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","This is the day which the LORD hath made; Let us rejoice and be glad in it! ");
INSERT INTO engnoy_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Hear, O LORD! and bless us! Hear, O LORD! and send us prosperity!” ");
INSERT INTO engnoy_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","“Blessed be he that cometh in the name of the LORD! We bless you from the house of the LORD.” ");
INSERT INTO engnoy_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","“Jehovah is God, he hath shone upon us: Bind the sacrifice with cords to the horns of the altar!” ");
INSERT INTO engnoy_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Thou art my God, and I will praise thee; Thou art my God, and I will exalt thee! ");
INSERT INTO engnoy_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","O give thanks to the LORD, for he is good; For his kindness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Happy are they who are upright in their way, Who walk in the law of the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Happy are they who observe his ordinances, And seek him with their whole heart; ");
INSERT INTO engnoy_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Who also do no iniquity, But walk in his ways! ");
INSERT INTO engnoy_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Thou hast commanded us to keep thy precepts diligently. ");
INSERT INTO engnoy_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","O that my ways were directed to keep thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Then shall I not be put to shame, When I have respect to all thy commandments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","I will praise thee in uprightness of heart, When I shall have learned thy righteous laws. ");
INSERT INTO engnoy_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","I will keep thy statutes; Do not utterly forsake me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","How shall a young man keep his way pure? By taking heed to it according to thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","With my whole heart have I sought thee; O let me not wander from thy commandments! ");
INSERT INTO engnoy_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Thy word have I hid in my heart, That I might not sin against thee. ");
INSERT INTO engnoy_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Blessed be thou, O LORD! O teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","With my lips do I declare All the precepts of thy mouth. ");
INSERT INTO engnoy_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","In the way of thine ordinances I rejoice As much as in all riches. ");
INSERT INTO engnoy_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","I meditate on thy precepts, And have respect unto thy ways. ");
INSERT INTO engnoy_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","I delight myself in thy statutes; I do not forget thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Deal kindly with thy servant, that I may live, And have regard to thy word! ");
INSERT INTO engnoy_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Open thou mine eyes, That I may behold wondrous things out of thy law! ");
INSERT INTO engnoy_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","I am a stranger in the earth; O hide not thy precepts from me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","My soul breaketh within me, On account of longing for thy judgments at all times. ");
INSERT INTO engnoy_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Thou rebukest the proud, the accursed, Who wander from thy commandments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Remove from me reproach and contempt, For I have kept thine ordinances! ");
INSERT INTO engnoy_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Princes sit and speak against me, But thy servant meditateth on thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Thine ordinances are my delight; Yea, they are my counsellors. ");
INSERT INTO engnoy_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","My soul cleaveth to the dust; O revive me, according to thy word! ");
INSERT INTO engnoy_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","I have declared my ways, and thou hast heard me; Teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Make me to understand the way of thy precepts! So will I meditate upon thy wonders. ");
INSERT INTO engnoy_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","My soul weepeth for trouble; O lift me up according to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Remove from me the way of falsehood, And graciously grant me thy law! ");
INSERT INTO engnoy_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","I have chosen the way of truth, And set thy statutes before me. ");
INSERT INTO engnoy_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","I cleave to thine ordinances; O LORD! let me not be put to shame! ");
INSERT INTO engnoy_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","I will run in the way of thy commandments, When thou shalt enlarge my heart. ");
INSERT INTO engnoy_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Teach me, O LORD! the way of thy statutes, That I may keep it to the end! ");
INSERT INTO engnoy_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Give me understanding, that I may keep thy law; That I may observe it with my whole heart! ");
INSERT INTO engnoy_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Cause me to tread in the path of thy commandments, For in it I have my delight. ");
INSERT INTO engnoy_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Incline my heart to thine ordinances, And not to the love of gain! ");
INSERT INTO engnoy_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Turn away mine eyes from beholding vanity, And quicken me in thy law! ");
INSERT INTO engnoy_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Fulfill to thy servant thy promise, Which thou hast made to him who feareth thee! ");
INSERT INTO engnoy_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Turn away the reproach which I fear; For thy judgments are good. ");
INSERT INTO engnoy_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Behold, I have longed for thy precepts; O quicken thou me in thy righteousness! ");
INSERT INTO engnoy_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Let thy mercies come to me, O LORD! And thy help according to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","So shall I be able to answer him that reproacheth me; For I trust in thy promise. ");
INSERT INTO engnoy_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","O take not the word of truth utterly out of my mouth! For I trust in thy judgments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","So shall I keep thy law continually, For ever and ever. ");
INSERT INTO engnoy_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","I shall walk in a wide path; For I seek thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","I will speak of thine ordinances before kings, And will not be ashamed. ");
INSERT INTO engnoy_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","I will delight myself in thy commandments, which I love; ");
INSERT INTO engnoy_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","I will lift up my hands to thy precepts, which I love; I will meditate on thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Remember thy promise to thy servant, Because thou hast caused me to hope! ");
INSERT INTO engnoy_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","This is my comfort in my affliction; For thy promise reviveth me. ");
INSERT INTO engnoy_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","The proud have had me greatly in derision; Yet have I not swerved from thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","I remember thy judgments of old, O LORD! And I comfort myself. ");
INSERT INTO engnoy_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Indignation burneth within me, On account of the wicked who forsake thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Thy statutes have been my song In the house of my pilgrimage. ");
INSERT INTO engnoy_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","In the night, O LORD! I think of thy name, And keep thy law! ");
INSERT INTO engnoy_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","This have I as my own, That I keep thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Thou art my portion, O LORD! I have resolved that I will keep thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","I have sought thy favor with my whole heart; Be gracious unto me according to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","I think on my ways, And turn my feet to thy statutes; ");
INSERT INTO engnoy_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","I make haste, and delay not, To keep thy commandments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","The snares of the wicked surround me; Yet do I not forget thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","At midnight I rise to give thanks to thee On account of thy righteous judgments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","I am the companion of all who fear thee, And who obey thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","The earth, O LORD! is full of thy goodness; O teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Thou dost bless thy servant, O LORD! According to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Teach me sound judgment and knowledge! For I have faith in thy commandments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Before I was afflicted, I went astray; But now I keep thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Thou art good and doest good; O teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","The proud forge lies against me, But I keep thy precepts with my whole heart. ");
INSERT INTO engnoy_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Their heart is senseless like fat; But I delight in thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","It is good for me that I have been afflicted, That I might learn thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","The law of thy mouth is better to me Than thousands of gold and silver. ");
INSERT INTO engnoy_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Thy hands have made and fashioned me; Give me understanding, that I may learn thy commandments! ");
INSERT INTO engnoy_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","They who fear thee shall see me and rejoice, Because I trust in thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","I know, O LORD! that thy judgments are right, And that in faithfulness thou hast afflicted me. ");
INSERT INTO engnoy_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","O let thy loving-kindness be my comfort, According to thy promise to thy servant! ");
INSERT INTO engnoy_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Let thy tender mercies come to me, that I may live! For thy law is my delight. ");
INSERT INTO engnoy_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","May the proud be put to shame, who wrong me without cause! But I will meditate on thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Let those who fear thee turn unto me, And they that know thine ordinances! ");
INSERT INTO engnoy_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","May my heart be perfect in thy statutes, That I may not be put to shame! ");
INSERT INTO engnoy_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","My soul fainteth for thy salvation; In thy promise do I trust. ");
INSERT INTO engnoy_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Mine eyes fail with looking for thy promise; When. say I, wilt thou comfort me? ");
INSERT INTO engnoy_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Yea, I am become like a bottle in the smoke; Yet do I not forget thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","How many are the days of thy servant? When wilt thou execute judgment upon my persecutors? ");
INSERT INTO engnoy_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","The proud have digged pits for me; They who do not regard thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","All thy commandments are faithful; They persecute me without cause; help thou me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","They had almost consumed me from the earth; But I forsook not thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Quicken me according to thy loving-kindness, That I may keep the law of thy mouth! ");
INSERT INTO engnoy_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Thy word, O LORD! abideth for ever, Being established like the heavens; ");
INSERT INTO engnoy_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Thy faithfulness endureth to all generations. Thou hast established the earth, and it abideth. ");
INSERT INTO engnoy_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","They continue to this day according to their ordinances; For they are all subject to thee. ");
INSERT INTO engnoy_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Had not thy law been my delight, I should have perished in my affliction. ");
INSERT INTO engnoy_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","I will never forget thy precepts; For by them thou revivest me. ");
INSERT INTO engnoy_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","I am thine, help me! For I seek thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","The wicked lie in wait to destroy me; But I will have regard to thine ordinances. ");
INSERT INTO engnoy_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","I have seen an end of all perfection; But thy law is exceeding broad. ");
INSERT INTO engnoy_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","O how I love thy law! It is my daily meditation. ");
INSERT INTO engnoy_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Thou hast made me wiser than my enemies by thy precepts; For they are ever before me. ");
INSERT INTO engnoy_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","I have more understanding than all my teachers; For thine ordinances are my meditation. ");
INSERT INTO engnoy_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","I have more wisdom than the ancients, Because I keep thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","I have restrained my feet from every evil way, That I might keep thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","I depart not from thy statutes, For thou teachest me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","How sweet are thy words to my taste; Yea, sweeter than honey to my mouth! ");
INSERT INTO engnoy_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","From thy precepts I learn wisdom; Therefore do I hate every false way. ");
INSERT INTO engnoy_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Thy word is a lamp to my feet, And a light to my path. ");
INSERT INTO engnoy_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","I have sworn, and I will perform it, That I will keep thy righteous statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","I am exceedingly afflicted; Revive me, O LORD! according to thy word! ");
INSERT INTO engnoy_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Accept, O LORD! the free-will offering of my mouth, And teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","My life is continually in my hand; Yet do I not forget thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","The wicked lay snares for me, Yet do I not go astray from thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","I have made thine ordinances my possession for ever; For they are the joy of my heart. ");
INSERT INTO engnoy_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","I have inclined my heart to perform thy statutes, Always,—even to the end. ");
INSERT INTO engnoy_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","I hate impious men, And thy law I do love. ");
INSERT INTO engnoy_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Thou art my hiding-place and my shield; In thy word I put my trust! ");
INSERT INTO engnoy_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Depart from me, ye evil-doers! For I will keep the commandments of my God. ");
INSERT INTO engnoy_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Uphold me according to thy promise, that I may live; And let me not be ashamed of my hope! ");
INSERT INTO engnoy_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Do thou hold me up, and I shall be safe, And I will have respect to thy statutes continually! ");
INSERT INTO engnoy_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Thou castest off all who depart from thy laws; For their deceit is vain. ");
INSERT INTO engnoy_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Thou throwest away all the wicked of the earth, like dross; Therefore I love thine ordinances. ");
INSERT INTO engnoy_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","My flesh trembleth through fear of thee, And I am afraid of thy judgments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","I have done justice and equity; O leave me not to mine oppressors. ");
INSERT INTO engnoy_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Be surety for thy servant for good; Let not the proud oppress me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Mine eyes fail with looking for thy help, And for thy righteous promise. ");
INSERT INTO engnoy_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Deal with thy servant according to thy mercy, And teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","I am thy servant; give me understanding, That I may know thine ordinances! ");
INSERT INTO engnoy_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","It is time for thee, O LORD! to act; For men have made void thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Therefore I love thy commandments above gold; Yea, above fine gold. ");
INSERT INTO engnoy_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Therefore I esteem all thy precepts concerning all things to be right; I hate every false way. ");
INSERT INTO engnoy_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Wonderful are thine ordinances; Therefore do I observe them. ");
INSERT INTO engnoy_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","The communication of thy precepts giveth light; It giveth understanding to the simple. ");
INSERT INTO engnoy_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","I open my mouth and pant: For I long for thy commandments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Look thou upon me, and be gracious to me, As is just to those who love thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Establish my footsteps in thy word, And let no iniquity have dominion over me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Redeem me from the oppression of men, So will I keep thy precepts! ");
INSERT INTO engnoy_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Let thy face shine on thy servant, And teach me thy statutes! ");
INSERT INTO engnoy_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Rivers of water run down mine eyes, Because men keep not thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Righteous art thou, O LORD! And just are thy judgments! ");
INSERT INTO engnoy_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Just are the ordinances which thou hast ordained, And altogether righteous. ");
INSERT INTO engnoy_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","My zeal consumeth me, Because my enemies forget thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Thy word is very pure, Therefore thy servant loveth it. ");
INSERT INTO engnoy_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Of mean condition am I, and despised; Yet do I not forget thy precepts. ");
INSERT INTO engnoy_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Thy righteousness is everlasting righteousness, And thy law is truth. ");
INSERT INTO engnoy_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Trouble and anguish have taken hold of me, But thy laws are my delight. ");
INSERT INTO engnoy_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","The justice of thine ordinances is everlasting; Give me understanding, and I shall live! ");
INSERT INTO engnoy_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","I cry to thee with my whole heart; Hear me, O LORD! that I may keep thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","I cry unto thee; save me, And I will observe thine ordinances. ");
INSERT INTO engnoy_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","I come before the dawn with my prayer; I trust in thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","My eyes anticipate the night-watches, That I may meditate upon thy promise. ");
INSERT INTO engnoy_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Hear my voice according to thy loving-kindness; O LORD! revive me according to thy mercy! ");
INSERT INTO engnoy_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Near are they whose aim is mischief; They are far from thy law; ");
INSERT INTO engnoy_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Yet thou art near, O LORD! And all thy commandments are truth! ");
INSERT INTO engnoy_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Long have I known concerning thine ordinances, That thou hast founded them for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Look upon my affliction, and deliver me! For I do not forget thy law. ");
INSERT INTO engnoy_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Maintain my cause, and redeem me; Revive me according to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Salvation is far from the wicked, Because they seek not thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Great is thy compassion, O LORD! Revive thou me according to thine equity! ");
INSERT INTO engnoy_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Many are my persecutors and my enemies, Yet do I not depart from thine ordinances. ");
INSERT INTO engnoy_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","I behold the transgressors, and am grieved Because they regard not thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Behold, how I love thy precepts! O LORD! revive me according to thy loving-kindness! ");
INSERT INTO engnoy_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","The whole of thy word is truth, And all thy righteous judgments endure for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Princes have persecuted me without cause; But my heart standeth in awe of thy word. ");
INSERT INTO engnoy_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","I rejoice in thy word, As one that hath found great spoil. ");
INSERT INTO engnoy_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","I hate and abhor lying, And thy law do I love. ");
INSERT INTO engnoy_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Seven times a day do I praise thee On account of thy righteous judgments. ");
INSERT INTO engnoy_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Great peace have they who love thy law, And no evil shall befall them. ");
INSERT INTO engnoy_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","O LORD! I wait for thy salvation, And keep thy commandments! ");
INSERT INTO engnoy_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","My soul observeth thine ordinances, And loveth them exceedingly. ");
INSERT INTO engnoy_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","I keep thy precepts and thine ordinances; For all my ways are before thee. ");
INSERT INTO engnoy_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Let my prayer come near before thee, O LORD! According to thy promise, give me understanding! ");
INSERT INTO engnoy_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Let my supplication come before thee; O deliver me according to thy promise! ");
INSERT INTO engnoy_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","My lips shall pour forth praise; For thou teachest me thy statutes. ");
INSERT INTO engnoy_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","My tongue shall sing of thy word; For all thy commandments are right. ");
INSERT INTO engnoy_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Let thy hand be my help; For I have chosen thy precepts! ");
INSERT INTO engnoy_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","I long for thy salvation, O LORD! And thy law is my delight! ");
INSERT INTO engnoy_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Let me live, and I will praise thee; Let thy judgments help me! ");
INSERT INTO engnoy_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","I wander like a lost sheep; seek thy servant, For I do not forget thy commandments! ");
INSERT INTO engnoy_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","“A psalm of steps.” In my distress I called upon the LORD, And he answered me. ");
INSERT INTO engnoy_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","O LORD! deliver me from lying lips, From the deceitful tongue! ");
INSERT INTO engnoy_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","What profit to thee, Or what advantage to thee, is the false tongue? ");
INSERT INTO engnoy_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","It is like the sharp arrows of the mighty man; Like coals of the juniper. ");
INSERT INTO engnoy_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Alas for me, that I sojourn in Mesech, That I dwell in the tents of Kedar! ");
INSERT INTO engnoy_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Too long have I dwelt With them that hate peace! ");
INSERT INTO engnoy_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","I am for peace; yet, when I speak for it, They are for war. ");
INSERT INTO engnoy_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","“A psalm of the steps, or the goings up.” I lift up mine eyes to the hills: Whence cometh my help? ");
INSERT INTO engnoy_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","My help cometh from the LORD, Who made heaven and earth. ");
INSERT INTO engnoy_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","He will not suffer thy foot to stumble; Thy guardian doth not slumber. ");
INSERT INTO engnoy_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Behold, the guardian of Israel Doth neither slumber nor sleep. ");
INSERT INTO engnoy_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","The LORD is thy guardian; The LORD is thy shade at thy right hand. ");
INSERT INTO engnoy_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","The sun shall not smite thee by day, Nor the moon by night. ");
INSERT INTO engnoy_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","The LORD will preserve thee from all evil; He will preserve thy life. ");
INSERT INTO engnoy_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","The LORD will preserve thee, when thou goest out and when thou comest in, From this time forth for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","“A psalm of the steps, or the goings up. By David.” I was glad when they said to me, Let us go up to the house of the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Our feet are standing Within thy gates, O Jerusalem! ");
INSERT INTO engnoy_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem, the rebuilt city! The city that is joined together! ");
INSERT INTO engnoy_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Thither the tribes go up, The tribes of the LORD, according to the law of Israel, To praise the name of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","There stand the thrones of judgment, The thrones of the house of David. ");
INSERT INTO engnoy_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Pray for the peace of Jerusalem! May they prosper who love thee! ");
INSERT INTO engnoy_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Peace be within thy walls, And prosperity within thy palaces! ");
INSERT INTO engnoy_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","For my brethren and companions' sake will I say, Peace be within thee! ");
INSERT INTO engnoy_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","For the sake of the house of the LORD, our God, Will I seek thy good! ");
INSERT INTO engnoy_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","“A song of the steps, or the goings up.” To thee do I lift up mine eyes, O Thou who dwellest in the heavens! ");
INSERT INTO engnoy_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Behold, as the eyes of servants look to the hand of their masters, And as the eyes of a maiden to the hand of her mistress, So do our eyes look to the LORD, our God, Until he have pity upon us. ");
INSERT INTO engnoy_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Have mercy upon us, O LORD! have mercy upon us, For we are overwhelmed with contempt! ");
INSERT INTO engnoy_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Our soul is filled to the full with the scorn of those who are at ease, And with the contempt of the proud. ");
INSERT INTO engnoy_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","“A psalm of the steps, or the goings up. By David.” If the LORD had not been for us, Now may Israel say, ");
INSERT INTO engnoy_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","If the LORD had not been for us, When men rose up against us, ");
INSERT INTO engnoy_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","Then had they swallowed us up alive, When their wrath burned against us; ");
INSERT INTO engnoy_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Then the waters had overwhelmed us; The stream had gone over our soul; ");
INSERT INTO engnoy_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","The proud waters had gone over our soul. ");
INSERT INTO engnoy_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Blessed be the LORD, Who hath not given us a prey to their teeth! ");
INSERT INTO engnoy_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","We have escaped like a bird from the snare of the fowler; The snare is broken, and we have escaped. ");
INSERT INTO engnoy_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Our help is in the name of the LORD, Who made heaven and earth. ");
INSERT INTO engnoy_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","“A psalm of the steps, or the goings up.” They who trust in the LORD shall be as Mount Zion, Which cannot be moved, which standeth for ever. ");
INSERT INTO engnoy_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","As the mountains are round about Jerusalem, So the LORD is round about his people, Henceforth even for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","For the sceptre of the wicked shall not remain upon the portion of the righteous, Lest the righteous put forth their hands to iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Do good, O LORD! to the good, To them that are upright in heart! ");
INSERT INTO engnoy_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","But such as turn aside to their crooked ways,-May the LORD destroy them with the evil-doers! Peace be to Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","“A psalm of the steps, or the goings up.” When the LORD brought back the captivity of Zion, We were like them that dream. ");
INSERT INTO engnoy_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Then was our mouth filled with laughter, And our tongue with singing. Then said they among the nations, “The LORD hath done great things for them!” ");
INSERT INTO engnoy_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Yea, the LORD hath done great things for us, For which we are glad. ");
INSERT INTO engnoy_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Bring back, O LORD! our captivity, Like streams in the South! ");
INSERT INTO engnoy_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","They who sow in tears Shall reap in joy. ");
INSERT INTO engnoy_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Yea, he goeth forth weeping, bearing his seed; He shall surely come back rejoicing, bearing his sheaves. ");
INSERT INTO engnoy_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","“A psalm of the steps, or the goings up. By Solomon.” Except the LORD build the house, The builders labor in vain; Except the LORD guard the city, The watchman waketh in vain. ");
INSERT INTO engnoy_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","In vain ye rise up early, and go to rest late, And eat the bread of care! The same giveth he his beloved one in sleep. ");
INSERT INTO engnoy_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Behold! sons are an inheritance from the LORD, And the fruit of the womb is his gift. ");
INSERT INTO engnoy_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","As arrows in the hand of the warrior, So are the sons of young men: ");
INSERT INTO engnoy_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Happy the man that hath his quiver full of them! They shall not be put to shame, When they speak with adversaries in the gate. ");
INSERT INTO engnoy_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","“A psalm of the steps, or the goings up.” Happy is he who feareth the LORD, Who walketh in his ways! ");
INSERT INTO engnoy_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Thou shalt eat the labor of thy hands; Happy shalt thou be, and it shall be well with thee! ");
INSERT INTO engnoy_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Thy wife shall be like a fruitful vine within thy house; Thy children like olive-branches round about thy table. ");
INSERT INTO engnoy_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Behold! thus happy is the man who feareth the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Jehovah shall bless thee out of Zion, And thou shalt see the prosperity of Jerusalem all the days of thy life; ");
INSERT INTO engnoy_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Yea, thou shalt see thy children's children. Peace be to Israel! ");
INSERT INTO engnoy_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","“A psalm of the steps, or the goings up.” Much have they afflicted me from my youth, May Israel now say; ");
INSERT INTO engnoy_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Much have they afflicted me from my youth, Yet have they not prevailed against me. ");
INSERT INTO engnoy_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","The ploughers ploughed up my back; They made long their furrows; ");
INSERT INTO engnoy_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","But the LORD was righteous; He cut asunder the cords of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Let all be driven back with shame Who hate Zion! ");
INSERT INTO engnoy_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Let them be as grass upon the house-tops, Which withereth before one pulleth it up; ");
INSERT INTO engnoy_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","With which the reaper filleth not his hand, Nor he that bindeth sheaves his bosom! ");
INSERT INTO engnoy_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","And they who pass by do not say, “The blessing of the LORD be upon you! We bless you in the name of the LORD!” ");
INSERT INTO engnoy_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","“A psalm of the steps, or the goings up.” Out of the depths do I cry to thee, O LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","O Lord! listen to my voice, Let thine ears be attentive to my supplication! ");
INSERT INTO engnoy_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","If thou, LORD, shouldst treasure up transgressions, Lord, who could stand? ");
INSERT INTO engnoy_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","But with thee is forgiveness, That thou mayst be feared. ");
INSERT INTO engnoy_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","I trust in the LORD; my soul doth trust, And in his promise do I confide. ");
INSERT INTO engnoy_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","My soul waiteth for the LORD More than they who watch for the morning; Yea, more than they who watch for the morning! ");
INSERT INTO engnoy_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","O Israel! trust in the LORD! For with the LORD is mercy, And with him is plenteous redemption. ");
INSERT INTO engnoy_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","He will redeem Israel From all his iniquities. ");
INSERT INTO engnoy_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","“A psalm of the steps, or the goings up. Of David.” O LORD! my heart is not haughty, nor my eyes lofty; I employ not myself on great things, or things too wonderful for me! ");
INSERT INTO engnoy_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Yea, I have stilled and quieted my soul As a weaned child upon his mother; My soul within me is like a weaned child. ");
INSERT INTO engnoy_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","O Israel! trust in the LORD, Henceforth even for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","“A psalm of the steps, or the goings up.” O LORD! remember David, And all his affliction! ");
INSERT INTO engnoy_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","How he sware to Jehovah, And vowed to the Mighty One of Jacob: ");
INSERT INTO engnoy_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“I will not go into my house, Nor lie down on my bed, ");
INSERT INTO engnoy_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","I will not give sleep to my eyes, Nor slumber to my eyelids, ");
INSERT INTO engnoy_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Until I find a place for Jehovah, A habitation for the Mighty One of Jacob.” ");
INSERT INTO engnoy_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Behold, we heard of it at Ephratah; We found it in the fields of the forest. ");
INSERT INTO engnoy_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Let us go into his habitation; Let us worship at his footstool! ");
INSERT INTO engnoy_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Arise, O LORD! into thy rest, Thou, and the ark of thy strength! ");
INSERT INTO engnoy_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Let thy priests be clothed with righteousness, And thy holy ones shout for joy! ");
INSERT INTO engnoy_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","For the sake of thy servant David, Reject not the prayer of thine anointed! ");
INSERT INTO engnoy_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Jehovah hath sworn in truth unto David, And he will not depart from it: “Of the fruit of thy body will I place upon the throne for thee. ");
INSERT INTO engnoy_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","If thy children keep my covenant, And my statutes, which I teach them, Their children also throughout all ages Shall sit upon thy throne.” ");
INSERT INTO engnoy_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","For Jehovah hath chosen Zion; He hath desired it as his dwelling-place. ");
INSERT INTO engnoy_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“This is my resting-place for ever; Here will I dwell, for I have chosen it. ");
INSERT INTO engnoy_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","I will abundantly bless her provision; I will satisfy her poor with bread. ");
INSERT INTO engnoy_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","I will also clothe her priests with salvation, And her holy ones shall shout aloud for joy. ");
INSERT INTO engnoy_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","There will I cause to spring forth a horn for David; I have prepared a light for mine anointed. ");
INSERT INTO engnoy_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","His enemies will I clothe with shame, And the crown shall glitter upon his head.” ");
INSERT INTO engnoy_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","“A psalm of the steps, or the goings up. By David.” Behold, how good and pleasant it is For brethren to dwell together in unity! ");
INSERT INTO engnoy_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","It is like precious perfume upon the head, Which ran down upon the beard, The beard of Aaron; Which went down to the very border of his garments; ");
INSERT INTO engnoy_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Like the dew of Hermon, Like that which descendeth upon the mountains of Zion. For there the LORD commandeth a blessing, Even life for evermore. ");
INSERT INTO engnoy_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","“A psalm of the steps, or the goings up.” Praise the LORD, all ye servants of the LORD, Who stand in the house of the LORD by night! ");
INSERT INTO engnoy_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Lift up your hands to the sanctuary, And praise the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","May the LORD, who made heaven and earth, Bless thee out of Zion! ");
INSERT INTO engnoy_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Praise ye the LORD! Praise ye the name of the LORD! Praise him, O ye servants of the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Ye who stand in the house of the LORD, In the courts of the house of our God! ");
INSERT INTO engnoy_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Praise ye the LORD, for the LORD is good; Praise his name, for he is kind! ");
INSERT INTO engnoy_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","For the LORD chose Jacob for himself, And Israel for his own possession. ");
INSERT INTO engnoy_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","I know that the LORD is great; That our Lord is above all gods. ");
INSERT INTO engnoy_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","All that the LORD pleaseth, that he doeth, In heaven and upon earth, In the sea, and in all deeps. ");
INSERT INTO engnoy_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","He causeth the clouds to ascend from the ends of the earth; He maketh lightnings for the rain; He bringeth the wind from his store-houses. ");
INSERT INTO engnoy_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","He smote the first-born of Egypt, Both of man and beast. ");
INSERT INTO engnoy_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","He sent signs and wonders into the midst of thee, O Egypt! Against Pharaoh and all his servants! ");
INSERT INTO engnoy_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","He smote many nations, And slew mighty kings; ");
INSERT INTO engnoy_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Sihon, the king of the Amorites, And Og, the king of Bashan, And all the kings of Canaan; ");
INSERT INTO engnoy_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","And gave their land for an inheritance, For an inheritance to Israel, his people. ");
INSERT INTO engnoy_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Thy name, O LORD! endureth for ever; Thy memorial, O LORD! to all generations! ");
INSERT INTO engnoy_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","For the LORD judgeth his people, And hath compassion on his servants. ");
INSERT INTO engnoy_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","The idols of the nations are silver and gold, The work of men's hands. ");
INSERT INTO engnoy_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","They have mouths, but they speak not; Eyes have they, but they see not. ");
INSERT INTO engnoy_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","They have ears, but they hear not; And there is no breath in their mouths. ");
INSERT INTO engnoy_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","They that make them are like them; So is every one that trusteth in them. ");
INSERT INTO engnoy_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Praise the LORD, O house of Israel! Praise the LORD, O house of Aaron! ");
INSERT INTO engnoy_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Praise the LORD, O house of Levi! Ye that fear the LORD, bless the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Praised be the LORD out of Zion, He that dwelleth in Jerusalem! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","O give thanks to the LORD! for he is kind; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","O give thanks to the God of gods; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","O give thanks to the Lord of lords; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","To him that alone doeth great wonders; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","To him that made the heavens with wisdom; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","To him that spread out the earth upon the waters; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","To him that made the great lights; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","The sun to rule the day; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","The moon and stars to rule the night; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","To him that smote in Egypt their first-born; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","And brought Israel from the midst of them; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","With a strong hand and an outstretched arm; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","To him who divided the Red sea into parts; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","And made Israel to pass through the midst of it; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","And overthrew Pharaoh and his host in the Red sea; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","To him who led his people through the wilderness; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","To him who smote great kings; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","And slew mighty kings; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Sihon, the king of the Amorites; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","And Og, the king of Bashan; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","And gave their land for an inheritance; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","For an inheritance to Israel his servant; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Who remembered us in our low estate; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","And redeemed us from our enemies; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Who giveth food unto all; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","O give thanks to the God of heaven; For his goodness endureth for ever! ");
INSERT INTO engnoy_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","By the rivers of Babylon, there we sat down, yea, we wept, When we remembered Zion. ");
INSERT INTO engnoy_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","We hung our harps on the willows in the midst thereof. ");
INSERT INTO engnoy_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","For there they who carried us away captive required of us a song; They who wasted us required of us mirth: “Sing us one of the songs of Zion!” ");
INSERT INTO engnoy_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","How shall we sing the LORD'S song In a strange land? ");
INSERT INTO engnoy_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","If I forget thee, O Jerusalem, Let my right hand forget her cunning! ");
INSERT INTO engnoy_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","If I do not remember thee, Let my tongue cleave to the roof of my mouth; If I prefer not Jerusalem above my chief joy! ");
INSERT INTO engnoy_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Remember, O LORD! against the children of Edom The day of the calamity of Jerusalem! Who said, “Raze it, Raze it to its foundations!” ");
INSERT INTO engnoy_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","O daughter of Babylon, thou destroyer! Happy be he who requiteth thee As thou hast dealt with us! ");
INSERT INTO engnoy_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Happy be he who seizeth thy little ones And dasheth them against the stones! ");
INSERT INTO engnoy_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","“A psalm of David.” I will praise thee with my whole heart; Before the gods will I sing praise to thee; ");
INSERT INTO engnoy_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","I will worship toward thy holy temple, And praise thy name for thy goodness and thy truth; For thy promise thou hast magnified above all thy name! ");
INSERT INTO engnoy_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","In the day when I called, thou didst hear me; Thou didst strengthen me, and encourage my soul. ");
INSERT INTO engnoy_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","All the kings of the earth shall praise thee, O LORD! When they hear the promises of thy mouth! ");
INSERT INTO engnoy_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Yea, they shall sing of the ways of the LORD; For great is the glory of the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","The LORD is high, yet he looketh upon the humble, And the proud doth he know from afar. ");
INSERT INTO engnoy_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Though I walk through the midst of trouble, thou wilt revive me; Thou wilt stretch forth thy hand against the wrath of my enemies; Thou wilt save me by thy right hand! ");
INSERT INTO engnoy_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","The LORD will perform all things for me; Thy goodness, O LORD! endureth ever: Forsake not the works of thine hands! ");
INSERT INTO engnoy_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","“For the leader of the music. A psalm of David.” O LORD! thou hast searched me and known me! ");
INSERT INTO engnoy_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Thou knowest my sitting-down and my rising-up; Thou understandest my thoughts from afar! ");
INSERT INTO engnoy_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Thou seest my path and my lying-down, And art acquainted with all my ways! ");
INSERT INTO engnoy_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","For before the word is upon my tongue, Behold, O LORD! thou knowest it altogether! ");
INSERT INTO engnoy_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Thou besettest me behind and before, And layest thine hand upon me! ");
INSERT INTO engnoy_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Such knowledge is too wonderful for me; It is high, I cannot attain to it! ");
INSERT INTO engnoy_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Whither shall I go from thy spirit, And whither shall I flee from thy presence? ");
INSERT INTO engnoy_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","If I ascend into heaven, thou art there! If I make my bed in the underworld, behold, thou art there! ");
INSERT INTO engnoy_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","If I take the wings of the morning, And dwell in the remotest parts of the sea, ");
INSERT INTO engnoy_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","Even there shall thy hand lead me, And thy right hand shall hold me! ");
INSERT INTO engnoy_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","If I say, “Surely the darkness shall cover me;” Even the night shall be light about me. ");
INSERT INTO engnoy_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Yea, the darkness hideth not from thee, But the night shineth as the day; The darkness and the light are both alike to thee! ");
INSERT INTO engnoy_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","For thou didst form my reins; Thou didst weave me in my mother's womb. ");
INSERT INTO engnoy_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","I will praise thee; for I am fearfully and wonderfully made; Marvellous are thy works, And this my soul knoweth full well! ");
INSERT INTO engnoy_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","My frame was not hidden from thee, When I was made in secret. When I was curiously wrought in the lower parts of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Thine eyes did see my substance, while yet unformed, And in thy book was every thing written; My days were appointed before one of them existed. ");
INSERT INTO engnoy_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","How precious to me are thy thoughts, O God! How great is the sum of them! ");
INSERT INTO engnoy_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","If I should count them, they would outnumber the sand: When I awake, I am still with thee! ");
INSERT INTO engnoy_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O that thou wouldst slay the wicked, O God! Ye men of blood, depart from me! ");
INSERT INTO engnoy_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","For they speak against thee wickedly; Thine enemies utter thy name for falsehood. ");
INSERT INTO engnoy_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Do I not hate them that hate thee, O LORD? Do I not abhor them that rise up against thee? ");
INSERT INTO engnoy_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Yea, I hate them with perfect hatred; I count them mine enemies. ");
INSERT INTO engnoy_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Search me, O God! and know my heart; Try me, and know my thoughts; ");
INSERT INTO engnoy_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","And see if the way of trouble be within me, And lead me in the way everlasting! ");
INSERT INTO engnoy_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","“For the leader of the music. A psalm of David.” Deliver me, O LORD! from the evil man, Save me from the man of violence, ");
INSERT INTO engnoy_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Who meditate mischief in their heart, And daily stir up war! ");
INSERT INTO engnoy_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","They sharpen their tongues like a serpent; The poison of the adder is under their lips. Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Defend me, O LORD! from the hands of the wicked, Preserve me from the man of violence, Who have purposed to cause my fall! Pause. ");
INSERT INTO engnoy_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","The proud have hidden snares and cords for me; They have spread a net by the way-side; They have set traps for me. ");
INSERT INTO engnoy_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","I say to Jehovah, Thou art my God; Hear, O Jehovah! the voice of my supplication! ");
INSERT INTO engnoy_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","The Lord Jehovah is my saving strength: Thou shelterest my head in the day of battle! ");
INSERT INTO engnoy_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Grant not, O LORD! the desires of the wicked; Let not their devices prosper; Let them not exalt themselves! ");
INSERT INTO engnoy_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","As for the heads of those who encompass me, Let the mischief of their own lips cover them! ");
INSERT INTO engnoy_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Let burning coals fall upon them; May they be cast into the fire, And into deep waters from which they shall not arise! ");
INSERT INTO engnoy_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","The slanderer shall not be established upon the earth; Evil shall pursue the violent man to destruction. ");
INSERT INTO engnoy_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","I know that the LORD will maintain the cause of the afflicted, And the right of the poor. ");
INSERT INTO engnoy_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Yea, the righteous shall praise thy name; The upright shall dwell in thy presence! ");
INSERT INTO engnoy_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","“For the leader of the music. A psalm of David.” I cry to thee, O LORD! make haste unto me! Give ear to my voice, when I cry unto thee! ");
INSERT INTO engnoy_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Let my prayer come before thee as incense, And the lifting-up of my hands, as the evening sacrifice! ");
INSERT INTO engnoy_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Set a watch, O LORD! before my mouth; Guard the door of my lips! ");
INSERT INTO engnoy_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Let not my heart incline to any evil thing; Let me not practise wickedness with the doers of iniquity, And let me not eat of their delicacies! ");
INSERT INTO engnoy_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Let the righteous smite me,—it shall be a kindness; Let him reprove me, and it shall be oil for my head; Let him do it again, and my head shall not refuse it; But now I pray against their wickedness! ");
INSERT INTO engnoy_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","When their judges are hurled over the side of the rock, They shall hear how pleasant are my words. ");
INSERT INTO engnoy_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","So are our bones scattered at the mouth of the underworld, As when one furroweth and ploweth up the land. ");
INSERT INTO engnoy_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","But to thee do my eyes look, O Lord Jehovah! In thee is my trust; Let not my life be poured out! ");
INSERT INTO engnoy_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Preserve me from the snares which they have laid for me, And from the nets of evil-doers! ");
INSERT INTO engnoy_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Let the wicked fall together into their own traps, Whilst I make my escape! ");
INSERT INTO engnoy_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","“A psalm of David; a prayer, when he was in the cave” I cry unto the LORD with my voice; With my voice to the LORD do I make my supplication. ");
INSERT INTO engnoy_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","I pour out my complaint before him; I declare before him my distress. ");
INSERT INTO engnoy_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","When my spirit is overwhelmed within me, Thou knowest my path! In the way which I walk, they have hid a snare for me. ");
INSERT INTO engnoy_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","I look on my right hand, and behold, But no man knoweth me; Refuge faileth me; No one careth for me. ");
INSERT INTO engnoy_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","I cry unto thee, O LORD! I say, Thou art my refuge, My portion in the land of the living. ");
INSERT INTO engnoy_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Attend to my cry, for I am brought very low; Deliver me from my persecutors, For they prevail against me! ");
INSERT INTO engnoy_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Bring me out of prison, That I may praise thy name! The righteous shall gather around me, When thou shalt show me thy favor. ");
INSERT INTO engnoy_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","“A psalm of David.” Hear my prayer, O LORD! give ear to my supplications! In thy faithfulness, and in thy righteousness, answer me! ");
INSERT INTO engnoy_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Enter not into judgment with thy servant; For before thee no man living is righteous. ");
INSERT INTO engnoy_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","For the enemy pursueth my life; He hath smitten me to the ground; He hath made me dwell in darkness, As those that have been dead of old. ");
INSERT INTO engnoy_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","My spirit is overwhelmed within me; My heart within me is desolate. ");
INSERT INTO engnoy_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","I remember the days of old; I meditate on all thy works; I muse on the deeds of thy hands. ");
INSERT INTO engnoy_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","I stretch forth my hands unto thee; My soul thirsteth for thee, like a parched land. ");
INSERT INTO engnoy_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Hear me speedily, O LORD! My spirit faileth; Hide not thy face from me. Lest I become like those who go down to the pit! ");
INSERT INTO engnoy_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Cause me so see thy loving-kindness speedily; For in thee do I trust! Make known to me the way which I should take; For to thee do I lift up my soul! ");
INSERT INTO engnoy_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Deliver me, O LORD! from mine enemies; For in thee do I seek refuge! ");
INSERT INTO engnoy_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Teach me to do thy will; For thou art my God! Let thy good spirit lead me in a plain path! ");
INSERT INTO engnoy_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Revive me, O LORD! for thy name's sake! In thy righteousness, bring me out of my distress! ");
INSERT INTO engnoy_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","And, in thy compassion, cut off mine enemies, And destroy all that distress me! For I am thy servant. ");
INSERT INTO engnoy_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Blessed be the LORD, my rock, Who teacheth my hands to war, And my fingers to fight! ");
INSERT INTO engnoy_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","He who is my loving-kindness and my fortress; My high tower and my deliverer, My shield, and he in whom I trust; Who subdueth peoples under me. ");
INSERT INTO engnoy_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","LORD, what is man, that thou art mindful of him, Or the son of man, that thou makest account of him? ");
INSERT INTO engnoy_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Man is like a vapor; His day is like a shadow that passeth away. ");
INSERT INTO engnoy_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Bow thy heavens, O LORD! and come down; Touch the mountains, so that they shall smoke! ");
INSERT INTO engnoy_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Cast forth lightnings, and scatter them; Shoot forth thine arrows, and destroy them! ");
INSERT INTO engnoy_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Send forth thine hand from above; Rescue and save me from deep waters; From the hands of aliens, ");
INSERT INTO engnoy_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Whose mouth uttereth deceit, And whose right hand is a right hand of falsehood! ");
INSERT INTO engnoy_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","I will sing to thee a new song, O God! Upon a ten-stringed psaltery will I sing praise to thee; ");
INSERT INTO engnoy_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","To thee, who givest salvation to kings, Who deliverest David, thy servant, from the destructive sword! ");
INSERT INTO engnoy_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Rescue and deliver me from the hands of aliens, Whose mouth uttereth deceit, And whose right hand is a right hand of falsehood! ");
INSERT INTO engnoy_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","That our sons may be as plants, Grown up in their youth; Our daughters as corner-pillars, Hewn like those of a palace! ");
INSERT INTO engnoy_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","That our garners may be full, Affording all kinds of store; That our sheep may bring forth thousands And ten thousands in our streets. ");
INSERT INTO engnoy_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","That our cattle may be fruitful; That there be no breaking in, or going out; And no outcry in our streets. ");
INSERT INTO engnoy_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Happy the people that is in such a state! Yea, happy the people whose God is Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","“A song of praise. By David.” I will extol thee, my God, the King! I will praise thy name for ever and ever! ");
INSERT INTO engnoy_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Every day will I bless thee, And praise thy name for ever and ever! ");
INSERT INTO engnoy_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Great is the LORD, and greatly to be praised; Yea, his greatness is unsearchable. ");
INSERT INTO engnoy_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","One generation shall praise thy works to another, And shall declare thy mighty deeds. ");
INSERT INTO engnoy_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","I will speak of the glorious honor of thy majesty, And of thy wonderful works. ");
INSERT INTO engnoy_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Men shall speak of the might of thy terrible deeds, And I will declare thy greatness; ");
INSERT INTO engnoy_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","They shall pour forth the praise of thy great good And sing of thy righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","The LORD is gracious, and full of compassion, Slow to anger, and rich in mercy. ");
INSERT INTO engnoy_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","The LORD is good to all. And his tender mercies are over all his works. ");
INSERT INTO engnoy_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","All thy works praise thee, O LORD! And thy holy ones bless thee! ");
INSERT INTO engnoy_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","They speak of the glory of thy kingdom, And talk of thy power; ");
INSERT INTO engnoy_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","To make known to the sons of men his mighty deeds, And the glorious majesty of his kingdom. ");
INSERT INTO engnoy_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Thy kingdom is an everlasting kingdom, And thy dominion endureth throughout all generations. ");
INSERT INTO engnoy_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","The LORD upholdeth all that fall, And raiseth up all that are bowed down. ");
INSERT INTO engnoy_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","The eyes of all wait upon thee, And thou givest them their food in due season; ");
INSERT INTO engnoy_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Thou openest thine hand, And satisfiest the desire of every living thing. ");
INSERT INTO engnoy_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","The LORD is righteous in all his ways, And merciful in all his works. ");
INSERT INTO engnoy_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","The LORD is nigh to all that call upon him, To all that call upon him in truth. ");
INSERT INTO engnoy_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","He fulfilleth the desire of them that fear him; He heareth their cry, and saveth them. ");
INSERT INTO engnoy_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","The LORD preserveth all that love him; But all the wicked he will destroy. ");
INSERT INTO engnoy_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","My mouth shall speak the praise of the LORD; And let all flesh bless his holy name for ever and ever! ");
INSERT INTO engnoy_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Praise ye the LORD! Praise the LORD, O my soul! ");
INSERT INTO engnoy_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","I will praise the LORD, as long as I live; I will sing praises to my God, while I have my being. ");
INSERT INTO engnoy_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Put not your trust in princes, In the son of man, in whom is no help! ");
INSERT INTO engnoy_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","His breath goeth forth; he returneth to the dust; In that very day his plans perish. ");
INSERT INTO engnoy_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Happy is he that hath the God of Jacob for his help; Whose hope is in the LORD, his God; ");
INSERT INTO engnoy_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Who made heaven and earth, The sea, and all that is therein; Who keepeth truth for ever; ");
INSERT INTO engnoy_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Who executeth judgment for the oppressed; Who giveth food to the hungry. The LORD setteth free the prisoners; ");
INSERT INTO engnoy_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","The LORD openeth the eyes of the blind; The LORD raiseth up them that are bowed down; The LORD loveth the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","The LORD preserveth the strangers; He relieveth the fatherless and the widow; But the way of the wicked he maketh crooked. ");
INSERT INTO engnoy_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","The LORD shall reign for ever; Thy God, O Zion! to all generations! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Praise ye the LORD! For it is good to sing praise to our God; For it is pleasant, and praise is becoming. ");
INSERT INTO engnoy_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","The LORD buildeth up Jerusalem; He gathereth together the dispersed of Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","He healeth the broken in heart, And bindeth up their wounds. ");
INSERT INTO engnoy_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","He counteth the number of the stars; He calleth them all by their names. ");
INSERT INTO engnoy_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Great is our Lord, and mighty in power; His understanding is infinite. ");
INSERT INTO engnoy_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","The LORD lifteth up the lowly; He casteth the wicked down to the ground. ");
INSERT INTO engnoy_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Sing to the LORD with thanksgiving; Sing praises upon the harp to our God! ");
INSERT INTO engnoy_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Who covereth the heavens with clouds, Who prepareth rain for the earth, Who causeth grass to grow upon the mountains. ");
INSERT INTO engnoy_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","He giveth to the cattle their food. And to the young ravens, when they cry. ");
INSERT INTO engnoy_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","He delighteth not in the strength of the horse, He taketh not pleasure in the legs of a man. ");
INSERT INTO engnoy_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","The LORD taketh pleasure in those who fear him, In those who trust in his mercy. ");
INSERT INTO engnoy_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Praise the LORD. O Jerusalem! Praise thy God, O Zion! ");
INSERT INTO engnoy_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","For he hath strengthened the bars of thy gates; He hath blessed thy children within thee. ");
INSERT INTO engnoy_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","He maketh peace in thy borders, And satisfieth thee with the finest of the wheat. ");
INSERT INTO engnoy_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","He sendeth forth his command to the earth; His word runneth very swiftly. ");
INSERT INTO engnoy_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","He giveth snow like wool, And scattereth the hoar-frost like ashes. ");
INSERT INTO engnoy_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","He casteth forth his ice like morsels; Who can stand before his cold? ");
INSERT INTO engnoy_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","He sendeth forth his word, and melteth them; He causeth his wind to blow, and the waters flow. ");
INSERT INTO engnoy_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","He publisheth his word to Jacob, His statutes and laws to Israel. ");
INSERT INTO engnoy_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","He hath dealt in this manner with no other nation; And, as for his ordinances, they have not known them. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Praise ye the LORD! Praise the LORD from the heavens! Praise him in the heights! ");
INSERT INTO engnoy_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Praise him, all ye his angels! Praise him, all ye his hosts! ");
INSERT INTO engnoy_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Praise ye him, sun and moon! Praise him, all ye stars of light! ");
INSERT INTO engnoy_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Praise him, ye heavens of heavens! Ye waters, that are above the heavens! ");
INSERT INTO engnoy_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Let them praise the name of the LORD; For he commanded, and they were created. ");
INSERT INTO engnoy_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","He hath also established them for ever; He hath given them a law, and they transgress it not. ");
INSERT INTO engnoy_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Praise the LORD from the earth, Ye sea-monsters, and all deeps! ");
INSERT INTO engnoy_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Fire and hail, snow and vapor; Thou tempest, that fulfillest his word! ");
INSERT INTO engnoy_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Ye mountains, and all hills! Fruit-trees, and all cedars! ");
INSERT INTO engnoy_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Ye wild beasts, and all cattle! Ye creeping things, and winged birds! ");
INSERT INTO engnoy_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Ye kings, and all peoples, Princes, and all judges of the earth! ");
INSERT INTO engnoy_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Young men and maidens, Old men and children! ");
INSERT INTO engnoy_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Let them praise the name of the LORD! For his name alone is exalted; His glory is above the earth and the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","He exalteth the horn of his people, The glory of all his godly ones, Of the children of Israel, a people near to him. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Praise ye the LORD! Sing unto the LORD a new song; His praise in the assembly of the godly! ");
INSERT INTO engnoy_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Let Israel rejoice in him that made him; Let the sons of Zion be joyful in their king! ");
INSERT INTO engnoy_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Let them praise his name in the dance; Let them praise him with the timbrel and harp! ");
INSERT INTO engnoy_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","For the LORD taketh pleasure in his people; He will beautify the distressed with salvation. ");
INSERT INTO engnoy_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Let the godly-rejoice in their glory; Let them shout for joy upon their beds! ");
INSERT INTO engnoy_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Let the praises of God be in their mouth, And a two-edged sword in their hand, ");
INSERT INTO engnoy_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","To execute vengeance upon the nations, And punishment upon the peoples! ");
INSERT INTO engnoy_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","To bind their kings with chains. And their nobles with fetters of iron; ");
INSERT INTO engnoy_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","To execute upon them the sentence which is written: This honor have all his godly ones. Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Praise ye the LORD! Praise God in his sanctuary! Praise him in his glorious firmament! ");
INSERT INTO engnoy_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Praise him for his mighty deeds! Praise him according to his excellent greatness! ");
INSERT INTO engnoy_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Praise him with the sound of trumpets! Praise him with the psaltery and harp! ");
INSERT INTO engnoy_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Praise him with the timbrel and dance! Praise him with stringed instruments and pipes! ");
INSERT INTO engnoy_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Praise him with the clear-sounding cymbals! Praise him with the high-sounding cymbals! ");
INSERT INTO engnoy_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Let every thing that hath breath praise the LORD! Praise ye the LORD! ");
INSERT INTO engnoy_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","The proverbs of Solomon, the son of David, king of Israel: ");
INSERT INTO engnoy_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","That one may learn wisdom and instruction, And receive words of understanding; ");
INSERT INTO engnoy_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","That one may gain the instruction of prudence, Justice, equity, and uprightness; ");
INSERT INTO engnoy_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Which will give caution to the simple, To the young man wisdom and discretion; ");
INSERT INTO engnoy_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Let the wise man hear, and he will increase his knowledge, And the man of understanding will gain wise counsels; ");
INSERT INTO engnoy_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","So as to understand a proverb and a deep maxim, The words of the wise and their dark sayings. ");
INSERT INTO engnoy_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","The fear of the LORD is the beginning of knowledge; Fools despise wisdom and instruction. ");
INSERT INTO engnoy_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Hear, O my son! the instruction of thy father, And neglect not the teaching of thy mother! ");
INSERT INTO engnoy_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","For they shall be a graceful wreath for thy head, And a chain around thy neck. ");
INSERT INTO engnoy_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","My son, if sinners entice thee, Consent thou not! ");
INSERT INTO engnoy_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","If they say, “Come with us, Let us lie in wait for blood, Let us lurk secretly for him who is innocent in vain; ");
INSERT INTO engnoy_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","Let us swallow them up alive, like the underworld, Yea, in full health, as those that go down into the pit; ");
INSERT INTO engnoy_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","We shall find all kinds of precious substance, We shall fill our houses with spoil; ");
INSERT INTO engnoy_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Thou shalt cast thy lot among us; We will all have one purse;”— ");
INSERT INTO engnoy_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","My son, walk thou not in their way, Refrain thy foot from their path! ");
INSERT INTO engnoy_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","For their feet run to evil, And make haste to shed blood. ");
INSERT INTO engnoy_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","For as the net is spread in vain Before the eyes of any bird, ");
INSERT INTO engnoy_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","So they lie in wait for their own blood; They lurk secretly for their own lives. ");
INSERT INTO engnoy_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Such are the ways of every one greedy of unjust gain; It taketh away the life of the possessor thereof. ");
INSERT INTO engnoy_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Wisdom crieth out in the highway; In the market-place she uttereth her voice; ");
INSERT INTO engnoy_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","At the head of the noisy streets she crieth aloud; At the entrances of the gates, throughout the city, she proclaimeth her words saying: ");
INSERT INTO engnoy_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","How long, ye simple ones, will ye love simplicity? How long will scoffers delight themselves in scoffing, And fools hate knowledge? ");
INSERT INTO engnoy_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Turn ye at my reproof! Behold, I will pour out my spirit to you; I will make known my words to you! ");
INSERT INTO engnoy_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","“Because I have called, and ye have refused,—Because I have stretched out my hand, and no one hath regarded. ");
INSERT INTO engnoy_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Because ye have rejected all my counsel, And have slighted my rebuke,— ");
INSERT INTO engnoy_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","I also will laugh at your calamity, I will mock when your fear cometh; ");
INSERT INTO engnoy_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","When your fear cometh upon you like a storm. And destruction overtaketh you like a whirlwind, When distress and anguish come upon you. ");
INSERT INTO engnoy_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","Then will they call upon me, but I will not answer! They will seek me early, But they shall not find me! ");
INSERT INTO engnoy_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","Because they have hated knowledge, And have not chosen the fear of the LORD,— ");
INSERT INTO engnoy_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Because they would not attend to my counsel, And have despised all my reproof,— ");
INSERT INTO engnoy_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","Therefore shall they eat of the fruit of their own way, And be filled to the full with their own devices; ");
INSERT INTO engnoy_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Yea, the turning away of the simple shall slay them, And the carelessness of fools shall destroy them. ");
INSERT INTO engnoy_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","But whoso hearkeneth to me shall dwell securely, And shall not be disquieted with the fear of evil.” ");
INSERT INTO engnoy_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Oh, my son, that thou wouldst receive my words, And treasure up my precepts within thee; ");
INSERT INTO engnoy_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","That thou wouldst apply thine ear to wisdom, And incline thy heart to understanding! ");
INSERT INTO engnoy_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","For if thou wilt call aloud to knowledge, And lift up thy voice to understanding,— ");
INSERT INTO engnoy_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","If thou wilt seek her as silver, And search for her as for hidden treasures, ");
INSERT INTO engnoy_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","Then shalt thou understand the fear of the LORD, And find the knowledge of God. ");
INSERT INTO engnoy_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","For the LORD giveth wisdom; From his mouth proceed knowledge and understanding: ");
INSERT INTO engnoy_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","He layeth up safety for the righteous; He is a shield to them that walk uprightly: ");
INSERT INTO engnoy_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","He guardeth the paths of equity, And defendeth the way of his servants. ");
INSERT INTO engnoy_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Then shalt thou understand righteousness and equity And uprightness, yea, every good path. ");
INSERT INTO engnoy_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","When wisdom entereth into thy heart, And knowledge is pleasant to thy soul, ");
INSERT INTO engnoy_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Discretion will guard thee, Understanding will preserve thee. ");
INSERT INTO engnoy_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","It will deliver thee from the way of the wicked, From the men who speak perverse things; ");
INSERT INTO engnoy_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Who forsake the paths of uprightness, To walk in the ways of darkness; ");
INSERT INTO engnoy_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Who rejoice in doing evil, And delight in the perverseness of the wicked; ");
INSERT INTO engnoy_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Whose paths are crooked, And who are froward in their ways. ");
INSERT INTO engnoy_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","It will deliver thee from the wife of another, From the stranger, who useth smooth words; ");
INSERT INTO engnoy_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Who forsaketh the friend of her youth, And forgetteth the covenant of her God. ");
INSERT INTO engnoy_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","For her house sinketh down to Death, And her paths to the shades of the dead: ");
INSERT INTO engnoy_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","None that go to her return again; They will not attain the paths of life. ");
INSERT INTO engnoy_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Therefore walk thou in the way of good men, And keep the paths of the righteous: ");
INSERT INTO engnoy_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","For the upright shall dwell in the land, And the righteous shall remain in it; ");
INSERT INTO engnoy_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","But the wicked shall be cut off from the land, And transgressors shall be rooted out of it. ");
INSERT INTO engnoy_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","My son, forget not my teaching, And let thy heart observe my precepts! ");
INSERT INTO engnoy_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","For length of days, and years of life, And peace shall they multiply to thee. ");
INSERT INTO engnoy_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Let not kindness and truth forsake thee; Bind them around thy neck, Write them upon the tablet of thy heart: ");
INSERT INTO engnoy_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Then shalt thou find favor and good success In the sight of God and man. ");
INSERT INTO engnoy_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Trust in the LORD with all thy heart, And lean not on thine own understanding; ");
INSERT INTO engnoy_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","In all thy ways acknowledge him, And he will make thy paths plain. ");
INSERT INTO engnoy_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Be not wise in thine own eyes; Fear the LORD, and depart from evil. ");
INSERT INTO engnoy_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","It shall be health to thy muscles, And moisture to thy bones. ");
INSERT INTO engnoy_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Honor the LORD with thy substance, And with the first-fruits of all thy increase; ");
INSERT INTO engnoy_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","So shall thy barns be filled with plenty, And thy vats overflow with new wine. ");
INSERT INTO engnoy_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","My son, despise not the correction of the LORD, Nor be impatient under his chastisement! ");
INSERT INTO engnoy_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","For whom the LORD loveth he chasteneth, Even as a father the son in whom he delighteth. ");
INSERT INTO engnoy_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Happy the man who findeth wisdom; Yea, the man who getteth understanding! ");
INSERT INTO engnoy_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","For the profit thereof is greater than that of silver, And the gain thereof than that of fine gold. ");
INSERT INTO engnoy_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","More precious is she than pearls, And none of thy jewels is to be compared with her. ");
INSERT INTO engnoy_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Length of days is in her right hand; In her left hand are riches and honor. ");
INSERT INTO engnoy_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Her ways are ways of pleasantness, And all her paths are peace. ");
INSERT INTO engnoy_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","She is a tree of life to them that lay hold of her, And happy is every one who hath her in his grasp. ");
INSERT INTO engnoy_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","The LORD by wisdom founded the earth; By understanding he framed the heavens. ");
INSERT INTO engnoy_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","By his knowledge the deep waters were cleft, And the clouds drop down the dew. ");
INSERT INTO engnoy_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","My son, let them not depart from thine eyes; Keep sound wisdom and discretion! ");
INSERT INTO engnoy_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","For they shall be life to thy soul, And grace to thy neck. ");
INSERT INTO engnoy_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Then shalt thou go on thy way securely, And thy foot shall not stumble; ");
INSERT INTO engnoy_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","When thou liest down, thou shalt not be afraid, Yea, thou shalt lie down, and thy sleep shall be sweet. ");
INSERT INTO engnoy_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Be not thou afraid of sudden alarm, Nor of the storm that is for the wicked, when it cometh; ");
INSERT INTO engnoy_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","For the LORD shall be thy confidence; Yea, he will keep thy foot from being taken. ");
INSERT INTO engnoy_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Withhold not kindness from those who need it, When it is in the power of thy hand to do it. ");
INSERT INTO engnoy_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Say not to thy neighbor, “Go, and come again, And to-morrow I will give to thee,” when thou hast it by thee. ");
INSERT INTO engnoy_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Devise not evil against thy neighbor, While he dwelleth securely by thee. ");
INSERT INTO engnoy_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Contend not with a man without cause, When he hath done thee no harm. ");
INSERT INTO engnoy_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Envy not the oppressor, And choose none of his ways. ");
INSERT INTO engnoy_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","For the perverse man is the abomination of the LORD, But he is in friendship with the upright. ");
INSERT INTO engnoy_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","The curse of the LORD is upon the house of the wicked, But he blesseth the dwelling of the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Surely the scorners he treadeth scornfully, But giveth favor to the lowly. ");
INSERT INTO engnoy_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","The wise shall obtain honor, But fools shall bear off shame. ");
INSERT INTO engnoy_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Hear, ye children, the instruction of a father, And attend, that ye may learn understanding! ");
INSERT INTO engnoy_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","For I give you good instruction; Forsake ye not my commandments. ");
INSERT INTO engnoy_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","For I was my father's son, A tender and only child in the sight of my mother. ");
INSERT INTO engnoy_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","He taught me, and said to me, Let thy heart hold fast my words; Keep my commandments, and live. ");
INSERT INTO engnoy_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Get wisdom, get understanding; Forget not, and depart not from, the words of my mouth. ");
INSERT INTO engnoy_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Forsake her not, and she will guard thee: Love her, and she will preserve thee. ");
INSERT INTO engnoy_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Wisdom is the principal thing; therefore gain wisdom, And with all thy gain, gain understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Exalt her, and she will promote thee; She will bring thee to honor, when thou dost embrace her; ");
INSERT INTO engnoy_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","She will give to thy head a graceful wreath, A beautiful crown will she bestow upon thee. ");
INSERT INTO engnoy_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Hear, O my son! and receive my sayings! So shall the years of thy life be many. ");
INSERT INTO engnoy_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","I have taught thee the way of wisdom, I have guided thee in the right path. ");
INSERT INTO engnoy_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","When thou goest, thy steps shall not be confined; And, when thou runnest, thou shalt not stumble. ");
INSERT INTO engnoy_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Take fast hold of instruction; let her not go; Keep her, for she is thy life. ");
INSERT INTO engnoy_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Enter not into the path of the wicked, And go not in the way of evil men; ");
INSERT INTO engnoy_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Avoid it, pass not upon it, Turn from it, and go away. ");
INSERT INTO engnoy_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","For they sleep not, unless they have done mischief; Yea, their sleep is taken away, unless they have caused some to fall. ");
INSERT INTO engnoy_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","For they eat the bread of wickedness, And drink the wine of violence. ");
INSERT INTO engnoy_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","But the path of the righteous is as the light of dawn, Which groweth brighter and brighter unto the perfect day. ");
INSERT INTO engnoy_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","The way of the wicked is as thick darkness; They know not at what they stumble. ");
INSERT INTO engnoy_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","My son, attend to my words; Incline thine ear to my sayings; ");
INSERT INTO engnoy_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Let them not depart from thine eyes; Keep them in the midst of thy heart! ");
INSERT INTO engnoy_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","For they are life to those who find them, And health to all their flesh. ");
INSERT INTO engnoy_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","More than any thing which thou watchest, watch thy heart; For from it goeth forth life. ");
INSERT INTO engnoy_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Put away from thee a deceitful mouth, And remove far from thee perverse lips. ");
INSERT INTO engnoy_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Let thine eyes look straight forward, And thine eyelids be directed before thee. ");
INSERT INTO engnoy_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Give heed to the path of thy foot, And let all thy ways be steadfast. ");
INSERT INTO engnoy_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Turn not to the right hand or to the left; Remove thy foot from evil. ");
INSERT INTO engnoy_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","My son, attend to my wisdom. And bow thine ear to my understanding; ");
INSERT INTO engnoy_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","That thou mayest keep discretion, And that thy lips may preserve knowledge! ");
INSERT INTO engnoy_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Truly, the lips of a strange woman drop honey, And her mouth is smoother than oil; ");
INSERT INTO engnoy_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","But her end is bitter as wormwood, Sharp as a two-edged sword. ");
INSERT INTO engnoy_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Her feet go down to death; Her steps lay hold of the under-world. ");
INSERT INTO engnoy_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","That she may not ponder the way of life, Her paths waver when she heedeth it not. ");
INSERT INTO engnoy_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Hear me now, therefore, O children! And turn not away from the words of my mouth! ");
INSERT INTO engnoy_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Remove thy way far from her. And come not nigh the door of her house: ");
INSERT INTO engnoy_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Lest thou give thy bloom to others, And thy years to a cruel one; ");
INSERT INTO engnoy_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Lest strangers be filled with thy wealth, And thine earnings be in the house of an alien; ");
INSERT INTO engnoy_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","And lest thou mourn in thy latter end. When thy flesh and thy body are consumed, ");
INSERT INTO engnoy_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","And say, “How have I hated instruction! And how hath my heart despised reproof! ");
INSERT INTO engnoy_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","I have not obeyed the voice of my teachers, Nor inclined mine ear to my instructors; ");
INSERT INTO engnoy_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","I have well-nigh fallen into utter misery; In the midst of the congregation and the assembly.” ");
INSERT INTO engnoy_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Drink water out of thine own cistern. And running water out of thine own well: ");
INSERT INTO engnoy_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","So shall thy fountains overflow in the streets, In the wide streets, as streams of water; ");
INSERT INTO engnoy_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","They shall belong to thee alone, And not to strangers with thee; ");
INSERT INTO engnoy_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","And thy fountain shall be blessed, Yea, thou shalt have joy in the wife of thy youth. ");
INSERT INTO engnoy_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","A lovely hind, a graceful doe, Her breasts shall satisfy thee at all times, And thou shalt be always ravished with her love. ");
INSERT INTO engnoy_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Why, then, my son, wilt thou be ravished with a wanton, And embrace the bosom of a stranger? ");
INSERT INTO engnoy_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","For the ways of man are before the eyes of the LORD, And he weigheth well all his paths. ");
INSERT INTO engnoy_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","His own iniquities shall ensnare the wicked; Yea, he shall be held fast by the cords of his own sins. ");
INSERT INTO engnoy_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","He shall die for want of instruction; Yea, through the greatness of his folly he shall stagger. ");
INSERT INTO engnoy_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","My son, if thou hast become surety for another, If thou hast stricken hands for another, ");
INSERT INTO engnoy_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","If thou hast become ensnared by the words of thy mouth, If thou hast been caught by the words of thy mouth, ");
INSERT INTO engnoy_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Do this now, my son, and rescue thyself,—Since thou hast fallen into the hands of thy neighbor,—Go, prostrate thyself, and be urgent with thy neighbor! ");
INSERT INTO engnoy_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Give not sleep to thine eyes, nor slumber to thine eyelids; ");
INSERT INTO engnoy_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Rescue thyself, as a roe from the hand, And as a bird from the hand of the fowler. ");
INSERT INTO engnoy_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Go to the ant, O sluggard! Consider her ways, and be wise! ");
INSERT INTO engnoy_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","She hath no governor, Nor overseer, nor ruler; ");
INSERT INTO engnoy_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","Yet she prepareth in the summer her food, She gathereth in the harvest her meat. ");
INSERT INTO engnoy_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","How long wilt thou lie in bed, O sluggard? When wilt thou arise from thy sleep? ");
INSERT INTO engnoy_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","“A little sleep,—a little slumber,—A little folding of the hands to rest:” ");
INSERT INTO engnoy_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","So shall thy poverty come upon thee like a robber, Yea, thy want, as an armed man! ");
INSERT INTO engnoy_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","A worthless wretch is the unrighteous man, Who walketh with a deceitful mouth; ");
INSERT INTO engnoy_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Who winketh with his eyes, Speaketh with his feet, And teacheth with his fingers. ");
INSERT INTO engnoy_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Fraud is in his heart; He deviseth mischief continually; He scattereth contentions. ");
INSERT INTO engnoy_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Therefore shall calamity come upon him suddenly; In a moment shall he be destroyed, and that without remedy; ");
INSERT INTO engnoy_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","These six things doth the LORD hate; Yea, seven are an abomination to him: ");
INSERT INTO engnoy_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","Lofty eyes, a false tongue, And hands which shed innocent blood; ");
INSERT INTO engnoy_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","A heart that contriveth wicked devices; Feet that are swift in running to mischief, ");
INSERT INTO engnoy_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","A false witness, that uttereth lies, And him that soweth discord among brethren. ");
INSERT INTO engnoy_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Keep, O my son! the commandment of thy father, And forsake not the precepts of thy mother! ");
INSERT INTO engnoy_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Bind them continually to thy heart, Tie them around thy neck! ");
INSERT INTO engnoy_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","When thou goest forth, they shall guide thee; When thou sleepest, they shall watch over thee; And, when thou awakest, they shall talk with thee. ");
INSERT INTO engnoy_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","For the commandment is a lamp, and instruction a light; Yea, the rebukes of correction lead to life. ");
INSERT INTO engnoy_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","They shall guard thee from the evil woman, From the smooth tongue of the unchaste woman. ");
INSERT INTO engnoy_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Desire not her beauty in thy heart, Nor let her catch thee with her eyelids; ");
INSERT INTO engnoy_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","For by a harlot a man is brought to a morsel of bread, And the adulteress layeth snares for the precious life. ");
INSERT INTO engnoy_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Can a man take fire into his bosom, And his clothes not be burned? ");
INSERT INTO engnoy_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Can one walk upon burning coals, And his feet not be scorched? ");
INSERT INTO engnoy_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","So is it with him who goeth in to his neighbor's wife; Whoever toucheth her shall not go unpunished. ");
INSERT INTO engnoy_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Men do not overlook a thief, Though he steal to satisfy his appetite, when he is hungry; ");
INSERT INTO engnoy_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","If found, he must repay sevenfold, And give up all the substance of his house. ");
INSERT INTO engnoy_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Whoso committeth adultery with a woman lacketh understanding; He that doeth it destroyeth himself; ");
INSERT INTO engnoy_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Blows and dishonor shall he get, And his reproach shall not be wiped away. ");
INSERT INTO engnoy_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","For jealousy is the fury of a man; He will not spare in the day of vengeance; ");
INSERT INTO engnoy_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","And he will not pay regard to any ransom, Nor be content, though thou offer many gifts. ");
INSERT INTO engnoy_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","My son, keep my words, And treasure up my commandments with thee! ");
INSERT INTO engnoy_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Keep my commandments and live! Yea, my teaching, as the apple of thine eye! ");
INSERT INTO engnoy_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Bind them upon thy fingers, Write them upon the tablet of thy heart! ");
INSERT INTO engnoy_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Say unto wisdom, “Thou art my sister!” And call understanding thy near acquaintance; ");
INSERT INTO engnoy_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","That they may keep thee from the wife of another, From the stranger, that useth smooth words. ");
INSERT INTO engnoy_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","For through the window of my house, Through the lattice I was looking forth, ");
INSERT INTO engnoy_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","And I saw among the simple ones, I discerned among the youths, A young man void of understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","He was passing through the street near her corner, And was going the way to her house, ");
INSERT INTO engnoy_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","At twilight, in the evening, At midnight, yea, in the thick darkness. ");
INSERT INTO engnoy_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","And, behold, a woman met him, In the attire of a harlot, and subtle of heart,— ");
INSERT INTO engnoy_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","One noisy and unruly, Whose feet abide not in her house; ");
INSERT INTO engnoy_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Who is now in the streets, now in the broad places, And lurketh near every corner. ");
INSERT INTO engnoy_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","She caught hold of him and kissed him, And with a shameless face said to him, ");
INSERT INTO engnoy_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Thank-offerings have been upon me, And this day have I performed my vows; ");
INSERT INTO engnoy_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Therefore came I forth to meet thee,—Diligently to seek thy face, and I have found thee! ");
INSERT INTO engnoy_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","I have spread my bed with coverlets, With tapestry of the thread of Egypt. ");
INSERT INTO engnoy_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","I have sprinkled my bed With myrrh, aloes, and cinnamon. ");
INSERT INTO engnoy_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Come, let us take our fill of love until the morning; Let us solace ourselves with caresses. ");
INSERT INTO engnoy_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","For the good-man is not at home; He is gone a long journey; ");
INSERT INTO engnoy_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","He hath taken a purse of money with him; At the day of the full moon he will return.” ");
INSERT INTO engnoy_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","By her much fair speech she seduced him; By the smoothness of her lips she drew him away. ");
INSERT INTO engnoy_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","He goeth after her straightway, As an ox goeth to the slaughter, Or as one in fetters to the chastisement of the fool, ");
INSERT INTO engnoy_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","Till an arrow strike through his liver;—As a bird hasteneth into the snare, And knoweth not that it is laid for its life. ");
INSERT INTO engnoy_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Now, therefore, ye children, hearken to me, And attend to the words of my mouth! ");
INSERT INTO engnoy_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Let not thy heart turn aside to her ways; Go not astray in her paths! ");
INSERT INTO engnoy_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","For many are the wounded which she hath cast down; Yea, countless is the number of those slain by her. ");
INSERT INTO engnoy_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Her house is the way to the under-world, Leading down to the chambers of death. ");
INSERT INTO engnoy_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Doth not wisdom cry aloud, And understanding put forth her voice? ");
INSERT INTO engnoy_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Upon the top of the high places, By the wayside, In the cross-ways, She taketh her station. ");
INSERT INTO engnoy_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","By the side of the gates, In the entrance of the city, In the approaches to the doors, she crieth aloud. ");
INSERT INTO engnoy_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“To you, O men! do I call, And my voice is to the sons of men! ");
INSERT INTO engnoy_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","O ye simple ones! learn wisdom, And ye fools, be ye of an understanding heart! ");
INSERT INTO engnoy_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Hear, for I speak excellent things, And my lips utter that which is right. ");
INSERT INTO engnoy_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","For my mouth speaketh truth, And wickedness is an abomination to my lips. ");
INSERT INTO engnoy_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","All the words of my mouth are in uprightness; There is nothing crooked or deceitful in them; ");
INSERT INTO engnoy_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","They are all plain to the man of understanding, And right to those who find knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Receive my instruction, and not silver. And knowledge rather than choice gold! ");
INSERT INTO engnoy_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","For wisdom is better than pearls, And no precious things are to be compared with her. ");
INSERT INTO engnoy_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","“I, wisdom, dwell with prudence, And find out the knowledge of sagacious counsels. ");
INSERT INTO engnoy_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","The fear of the LORD is to hate evil; Pride, and arrogance, and the evil way, And the deceitful mouth, do I hate. ");
INSERT INTO engnoy_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Counsel is mine, and sound reason; I am understanding; I have strength. ");
INSERT INTO engnoy_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","By me kings reign, And princes decree justice. ");
INSERT INTO engnoy_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","By me princes rule, And nobles, even all the judges of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","I love them that love me, And they who seek me early shall find me. ");
INSERT INTO engnoy_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Riches and honor are with me; Yea, durable riches and prosperity. ");
INSERT INTO engnoy_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","My fruit is better than gold, yea, than fine gold. And my revenue than choice silver. ");
INSERT INTO engnoy_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","I walk in the way of righteousness, In the midst of the paths of equity. ");
INSERT INTO engnoy_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","I cause those who love me to possess substance; Yea, I fill their treasuries. ");
INSERT INTO engnoy_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“The LORD created me, the firstling of his course, Before his works, of old; ");
INSERT INTO engnoy_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","I was anointed from everlasting, From the beginning, even before the earth was made. ");
INSERT INTO engnoy_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","When as yet there were no deeps, I was brought forth. When there were no springs, abounding with water. ");
INSERT INTO engnoy_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Before the mountains were settled, Yea, before the hills, I was brought forth; ");
INSERT INTO engnoy_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Ere yet he had made the land and the wastes, And the first of the clods of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","When he framed the heavens, I was there; When he drew a circle upon the face of the deep; ");
INSERT INTO engnoy_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","When he made firm the sky above, And the fountains of the deep rushed forth; ");
INSERT INTO engnoy_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","When he gave to the sea its bounds, that the waters should not pass their border; When he marked out the foundations of the earth,— ");
INSERT INTO engnoy_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Then was I by him as a master-builder; I was his delight day by day, Exulting before him at all times; ");
INSERT INTO engnoy_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Exulting in the habitable part of his earth, And my delight was with the sons of men. ");
INSERT INTO engnoy_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“Now, therefore, ye children, hearken to me! For happy are they who keep my ways! ");
INSERT INTO engnoy_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Hear instruction, and be wise! Yea, reject it not! ");
INSERT INTO engnoy_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Happy the man who hearkeneth to me, Who watcheth day by day at my gates, Who waiteth at the posts of my doors; ");
INSERT INTO engnoy_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","For he that findeth me findeth life, And obtaineth favor from the LORD; ");
INSERT INTO engnoy_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","But he who misseth me doeth violence to himself; All they who hate me love death.” ");
INSERT INTO engnoy_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Wisdom hath builded her house; She hath hewn out her seven pillars. ");
INSERT INTO engnoy_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","She hath killed her fatlings; She hath mingled her wine; Yea, she hath furnished her table. ");
INSERT INTO engnoy_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","She hath sent forth her maidens; She crieth aloud upon the highest places of the city: ");
INSERT INTO engnoy_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Whoever is simple, let him turn in hither!” To him that is void of understanding she saith, ");
INSERT INTO engnoy_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“Come, eat of my bread, And drink of the wine which I have mingled! ");
INSERT INTO engnoy_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Forsake folly, and live! And go forward in the way of understanding! ");
INSERT INTO engnoy_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","“He who correcteth a scoffer Bringeth shame upon himself; And he who rebuketh the wicked Bringeth upon himself a stain. ");
INSERT INTO engnoy_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Rebuke not a scoffer, lest he hate thee; Rebuke a wise man, and he will love thee. ");
INSERT INTO engnoy_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Give instruction to a wise man, and he will be yet wiser; Teach a righteous man, and he will increase his learning. ");
INSERT INTO engnoy_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","The fear of the LORD is the beginning of wisdom, And the knowledge of the Most Holy is understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Yea, through me thy days shall be multiplied, And the years of thy life shall be increased. ");
INSERT INTO engnoy_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","If thou art wise, thou art wise for thyself; And if thou art a scoffer, thou alone must bear it.” ");
INSERT INTO engnoy_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","The foolish woman is clamorous; She is very simple, and careth for nothing. ");
INSERT INTO engnoy_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","She sitteth at the door of her house, Upon a seat in the high places of the city, ");
INSERT INTO engnoy_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","To call aloud to those that pass by, Who go straight forward in their ways, ");
INSERT INTO engnoy_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Whoever is simple, let him turn in hither!” And to him that is void of understanding she saith, ");
INSERT INTO engnoy_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Stolen water is sweet, And bread eaten in secret is pleasant.” ");
INSERT INTO engnoy_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","But he considereth not that the dead are there, That in the vales of the under-world are her guests. ");
INSERT INTO engnoy_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","The Proverbs of Solomon. A wise son maketh a glad father, But a foolish son is the grief of his mother. ");
INSERT INTO engnoy_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Treasures of wickedness do not profit; But righteousness delivereth from death. ");
INSERT INTO engnoy_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","The LORD will not suffer the righteous to famish; But he disappointeth the craving of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","He that worketh with a slack hand becometh poor; But the hand of the diligent maketh rich. ");
INSERT INTO engnoy_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","He that gathereth in summer is a wise son; But he that sleepeth in harvest is a son causing shame. ");
INSERT INTO engnoy_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Blessings are upon the head of the just; But the mouth of the wicked concealeth violence. ");
INSERT INTO engnoy_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","The memory of the righteous man shall be blessed; But the name of the wicked shall rot. ");
INSERT INTO engnoy_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","He who is wise in heart receiveth precepts; But the foolish talker falleth headlong. ");
INSERT INTO engnoy_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","He that walketh uprightly walketh securely; But he that perverteth his ways shall be punished. ");
INSERT INTO engnoy_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","He that winketh with the eye causeth sorrow; And a foolish talker falleth headlong. ");
INSERT INTO engnoy_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","The mouth of the righteous is a fountain of life; But the mouth of the wicked concealeth violence. ");
INSERT INTO engnoy_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Hatred stirreth up strife; But love covereth all offences. ");
INSERT INTO engnoy_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Upon the lips of a man of understanding wisdom is found; But a rod is for the back of him that lacketh understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Wise men treasure up knowledge; But the mouth of the foolish is destruction close at hand. ");
INSERT INTO engnoy_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","The rich man's wealth is his strong city; The destruction of the poor is their poverty. ");
INSERT INTO engnoy_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","The earnings of the righteous minister to life; The revenues of the wicked, to sin. ");
INSERT INTO engnoy_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","He that keepeth instruction is in the path of life; But he that refuseth reproof goeth astray. ");
INSERT INTO engnoy_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","He that hideth hatred hath lying lips; And he that uttereth slander is a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","In the multitude of words there wanteth not offence; But he who restraineth his lips is wise. ");
INSERT INTO engnoy_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","The tongue of the righteous is as choice silver; The understanding of the wicked is of little worth. ");
INSERT INTO engnoy_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","The lips of the righteous feed many; But fools die through want of wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","It is the blessing of the LORD that maketh rich, And he addeth no sorrow with it. ");
INSERT INTO engnoy_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","It is as sport to a fool to do mischief; But a man of understanding hath wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","The fear of the wicked shall come upon him; But the desire of the righteous shall be granted. ");
INSERT INTO engnoy_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","When the whirlwind passeth by, the wicked is no more; But the righteous is an everlasting foundation. ");
INSERT INTO engnoy_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","As vinegar to the teeth, and as smoke to the eyes, So is the sluggard to them that send him. ");
INSERT INTO engnoy_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","The fear of the LORD prolongeth life; But the years of the wicked shall be shortened. ");
INSERT INTO engnoy_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","The hope of the righteous shall be gladness: But the expectation of the wicked shall come to nothing. ");
INSERT INTO engnoy_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","The way of the LORD is a stronghold for the upright, But destruction for those who do iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","The righteous shall never be moved; But the wicked shall not dwell in the land. ");
INSERT INTO engnoy_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","The mouth of the righteous man yieldeth wisdom; But the perverse tongue shall be cut off. ");
INSERT INTO engnoy_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","The lips of the righteous know what is acceptable; But the mouth of the wicked what is perverse. ");
INSERT INTO engnoy_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","False scales are an abomination to the LORD; But a perfect weight is his delight. ");
INSERT INTO engnoy_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","When pride cometh, then cometh disgrace; But with the humble is wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","The integrity of the upright shall guide them; But the perverseness of transgressors shall destroy them. ");
INSERT INTO engnoy_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Riches do not profit in the day of wrath; But righteousness delivereth from death. ");
INSERT INTO engnoy_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","The righteousness of the good man maketh his way plain; But the wicked falleth through his wickedness. ");
INSERT INTO engnoy_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","The righteousness of the upright delivereth them; But transgressors are ensnared in their own mischief. ");
INSERT INTO engnoy_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","When the wicked man dieth, his hope cometh to an end; Yea, the expectation of the unjust cometh to an end. ");
INSERT INTO engnoy_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","The righteous man is delivered from trouble, And the wicked cometh into it in his stead. ");
INSERT INTO engnoy_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","By his mouth the vile man destroyeth his neighbor; But by the knowledge of the righteous are men delivered. ");
INSERT INTO engnoy_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","When it goeth well with the righteous, the city rejoiceth; And when the wicked perish, there is shouting. ");
INSERT INTO engnoy_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","By the blessing of the upright the city is exalted; But it is overthrown by the mouth of the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","He who despiseth his neighbor is void of understanding; A man of discernment holdeth his peace. ");
INSERT INTO engnoy_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","He who goeth about as a tale-bearer revealeth secrets; But he who is of a faithful spirit concealeth a matter. ");
INSERT INTO engnoy_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Where there is no counsel, the people fall; But in a multitude of counsellors there is safety. ");
INSERT INTO engnoy_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","He that is surety for another shall smart for it; But he that hateth suretyship is sure. ");
INSERT INTO engnoy_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","A graceful woman obtaineth honor, Even as strong men obtain riches. ");
INSERT INTO engnoy_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","He that doeth good to himself is a man of kindness; But he that tormenteth his own flesh is cruel. ");
INSERT INTO engnoy_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","The wicked toileth for deceitful wages; But he who soweth righteousness shall have a sure reward. ");
INSERT INTO engnoy_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","As righteousness tendeth to life, So he who pursueth evil pursueth it to his death. ");
INSERT INTO engnoy_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","The perverse in heart are the abomination of the LORD; But the upright in their way are his delight. ");
INSERT INTO engnoy_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","From generation to generation the wicked shall not go unpunished; But the posterity of the righteous shall be delivered. ");
INSERT INTO engnoy_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","As a jewel of gold in a swine's snout, So is a beautiful woman who is without discretion. ");
INSERT INTO engnoy_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","The desire of the righteous is only good; But the expectation of the wicked is wrath. ");
INSERT INTO engnoy_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","There is that scattereth, and yet increaseth; And there is that withholdeth more than is right, yet he cometh to want. ");
INSERT INTO engnoy_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","The bountiful man shall be enriched, And he that watereth shall himself be watered. ");
INSERT INTO engnoy_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Him that keepeth back corn the people curse; But blessing shall be upon the head of him that selleth it. ");
INSERT INTO engnoy_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","He, who earnestly seeketh good, seeketh favor; But he that seeketh mischief, it shall come upon him. ");
INSERT INTO engnoy_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","He who trusteth in his riches shall fall; But the righteous shall flourish as a leaf. ");
INSERT INTO engnoy_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","He that harasseth his household shall inherit wind; And the fool shall be the servant of the wise. ");
INSERT INTO engnoy_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","The fruit of a righteous man is a tree of life; And the wise man winneth souls. ");
INSERT INTO engnoy_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Behold, the righteous man is requited on the earth; Much more the wicked man and the sinner! ");
INSERT INTO engnoy_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","He who loveth correction loveth knowledge; But he who hateth rebuke remaineth stupid. ");
INSERT INTO engnoy_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","The good man obtaineth favor from the LORD; But the man of wicked devices he condemneth. ");
INSERT INTO engnoy_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","A man shall not be established by wickedness; But the root of the righteous shall not be moved. ");
INSERT INTO engnoy_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","A virtuous woman is a crown to her husband; But she who causeth shame is as rottenness in his bones. ");
INSERT INTO engnoy_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","The purposes of the righteous are just; The designs of the wicked are deceitful. ");
INSERT INTO engnoy_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","The words of the wicked lie in wait for men's blood; But the mouth of the upright delivereth them. ");
INSERT INTO engnoy_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","The wicked are overthrown, and are no more; But the house of the righteous shall stand. ");
INSERT INTO engnoy_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","A man will be commended according to his wisdom; But he that is of a perverse heart shall be despised. ");
INSERT INTO engnoy_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Better is he that demeaneth himself, and hath a servant, Than he that exalteth himself, and hath no bread. ");
INSERT INTO engnoy_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","The righteous man careth for the life of his beast; But the tender mercies of the wicked are cruel. ");
INSERT INTO engnoy_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","He who tilleth his own land shall be satisfied with bread; But he who followeth worthless persons is void of understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","The wicked man longeth after the prey of evil-doers; But the root of the righteous yieldeth fruit. ");
INSERT INTO engnoy_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","In the transgression of the lips is a dangerous snare; But the righteous man shall escape from trouble. ");
INSERT INTO engnoy_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","By the fruit of a man's mouth he shall be filled with good, And the recompense of a man's hands shall be rendered unto him. ");
INSERT INTO engnoy_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","The way of a fool is right in his own eyes; But he that hearkeneth to counsel is wise. ");
INSERT INTO engnoy_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","A fool's wrath is instantly known; But he that hideth insult is wise. ");
INSERT INTO engnoy_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","He that speaketh truth testifieth what is right; But a false witness, deceit. ");
INSERT INTO engnoy_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","There is who babbleth like the piercing of a sword; But the tongue of the wise is health. ");
INSERT INTO engnoy_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","The lip of truth shall be established for ever; But the tongue of falsehood, but for a moment. ");
INSERT INTO engnoy_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Deceit is in the heart of those who contrive evil; But to the counsellors of peace shall be joy. ");
INSERT INTO engnoy_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","No evil shall happen to the righteous; But the wicked shall be filled with calamity. ");
INSERT INTO engnoy_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","False lips are the abomination of the LORD; But they who deal truly are his delight. ");
INSERT INTO engnoy_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","A prudent man concealeth his knowledge; Bur the heart of fools proclaimeth their foolishness. ");
INSERT INTO engnoy_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","The hand of the diligent shall bear rule; But the slothful shall be under tribute. ");
INSERT INTO engnoy_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Anxiety in the heart of a man boweth it down; But a kind word maketh it glad. ");
INSERT INTO engnoy_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","The righteous showeth the way to his neighbor; But the way of the wicked leadeth them astray. ");
INSERT INTO engnoy_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","The slothful man shall not roast his game; But a precious treasure to any man is he that is diligent. ");
INSERT INTO engnoy_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","In the path of righteousness is life, And in her pathway there is no death. ");
INSERT INTO engnoy_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","A wise son listeneth to the instruction of his father; But a scoffer listeneth not to rebuke. ");
INSERT INTO engnoy_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","By the fruit of a man's mouth he shall eat good; But the appetite of transgressors shall be sated with violence. ");
INSERT INTO engnoy_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","He who keepeth his mouth keepeth his life; But destruction shall be to him who openeth wide his lips. ");
INSERT INTO engnoy_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","The appetite of the sluggard longeth, and hath nothing; But the appetite of the diligent is fully satisfied. ");
INSERT INTO engnoy_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","A righteous man hateth words of falsehood; But a wicked man causeth disgrace and shame. ");
INSERT INTO engnoy_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Righteousness preserveth him who is upright in his way; But wickedness overthroweth the sinner. ");
INSERT INTO engnoy_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","There is who maketh himself rich, yet hath nothing, Who maketh himself poor, yet hath great riches. ");
INSERT INTO engnoy_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","A man's wealth is the ransom of his life; But the poor man heareth no threatenings. ");
INSERT INTO engnoy_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","The light of the righteous shall rejoice; But the lamp of the wicked shall be put out. ");
INSERT INTO engnoy_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","By pride cometh only contention; But with the well-advised is wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Wealth gotten by vanity will become small; But he who gathereth it into the hand increaseth it. ");
INSERT INTO engnoy_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Hope deferred maketh the heart sick; But the desire accomplished is a tree of life. ");
INSERT INTO engnoy_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","He that despiseth the word shall be destroyed; But he who revereth the commandment shall be rewarded. ");
INSERT INTO engnoy_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","The instruction of the wise is a fountain of life; By it men escape from the snares of death. ");
INSERT INTO engnoy_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","A good understanding winneth favor; But the way of transgressors is hard. ");
INSERT INTO engnoy_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Every prudent man acteth with knowledge; But a fool spreadeth abroad his folly. ");
INSERT INTO engnoy_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","A wicked messenger falleth into trouble; But a faithful ambassador is health. ");
INSERT INTO engnoy_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Poverty and shame are for him who rejecteth instruction; But he that regardeth reproof shall come to honor. ");
INSERT INTO engnoy_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","The desire accomplished is sweet to the soul; But it is an abomination to fools to depart from evil. ");
INSERT INTO engnoy_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","He who walketh with wise men shall be wise; But the companion of fools shall be destroyed. ");
INSERT INTO engnoy_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Calamity pursueth the wicked; But the righteous is rewarded with good. ");
INSERT INTO engnoy_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","The good man leaveth his substance to his children's children; But the wealth of the sinner is laid up for the just. ");
INSERT INTO engnoy_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","There is much food from the fallow-ground of the poor; But there is who is brought low for want of uprightness. ");
INSERT INTO engnoy_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","He that spareth the rod hateth his son; But he who loveth him chasteneth him early. ");
INSERT INTO engnoy_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","The righteous man eateth to the satisfying of his desire; But the stomach of the wicked suffereth want. ");
INSERT INTO engnoy_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","The wise woman buildeth her house; But the foolish teareth it down with her hands. ");
INSERT INTO engnoy_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","He who walketh in uprightness feareth the LORD; But he who is perverse in his ways despiseth him. ");
INSERT INTO engnoy_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","In the mouth of the foolish pride is a scourge; But the lips of the wise preserve them. ");
INSERT INTO engnoy_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Where there are no oxen, the crib is clean; But there is great increase by the strength of the ox. ");
INSERT INTO engnoy_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","A faithful witness doth not lie; But a false witness poureth forth lies. ");
INSERT INTO engnoy_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","The scoffer seeketh wisdom, and findeth it not; But knowledge is easy to the man of understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Go from the presence of a foolish man; For thou hast not perceived in him the lips of knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","The wisdom of the prudent is in giving heed to his way; But the folly of fools is deceit. ");
INSERT INTO engnoy_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Fools make a mock at sin; But with the upright is favor. ");
INSERT INTO engnoy_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","The heart knoweth its own bitterness. And a stranger cannot intermeddle with its joy. ");
INSERT INTO engnoy_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","The house of the wicked shall be destroyed; But the tent of the upright shall flourish. ");
INSERT INTO engnoy_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","There is a way which seemeth right to a man, But its end is the way to death. ");
INSERT INTO engnoy_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Even in laughter the heart is sorrowful, And the end of joy is grief. ");
INSERT INTO engnoy_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","The perverse in heart shall be filled with his own ways; And from himself shall the good man be satisfied. ");
INSERT INTO engnoy_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","The simple man believeth every word; But the prudent looketh well to his steps. ");
INSERT INTO engnoy_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","The wise man feareth, and departeth from evil; But the fool is haughty and confident. ");
INSERT INTO engnoy_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","He who is hasty in his anger will commit folly; And the man of wicked devices will be hated. ");
INSERT INTO engnoy_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","The simple inherit folly; But the prudent are crowned with knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","The evil bow before the good; Yea, the wicked at the gates of the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","The poor is hated even by his own neighbor; But the rich hath many friends. ");
INSERT INTO engnoy_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","He who despiseth his neighbor sinneth; But happy is he who hath mercy on the poor. ");
INSERT INTO engnoy_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Do not they who devise evil fail of their end? But they who devise good meet with kindness and truth. ");
INSERT INTO engnoy_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","In all labor there is profit; But the talk of the lips tendeth only to penury. ");
INSERT INTO engnoy_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Riches are a crown to the wise; But the promotion of fools is folly. ");
INSERT INTO engnoy_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","A true witness saveth lives; But a deceitful witness poureth forth lies. ");
INSERT INTO engnoy_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","In the fear of the LORD is strong confidence; Yea, to his children he will be a refuge. ");
INSERT INTO engnoy_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","The fear of the LORD is a fountain of life; By it men escape from the snares of death. ");
INSERT INTO engnoy_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","In a numerous people is the glory of a king; But the want of people is the destruction of a prince. ");
INSERT INTO engnoy_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","He who is slow to anger is of great understanding. But he who is of a hasty spirit setteth folly on high. ");
INSERT INTO engnoy_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","A quiet heart is the life of the flesh; But the ferment of passion is rottenness to the bones. ");
INSERT INTO engnoy_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","He who oppresseth the poor reproacheth his Maker; But he who hath mercy on the poor honoreth him. ");
INSERT INTO engnoy_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","By his wickedness the wicked is thrust down; But the righteous hath hope even in death. ");
INSERT INTO engnoy_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Wisdom resteth quietly in the heart of the wise; But in the breast of fools it will be made known. ");
INSERT INTO engnoy_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Righteousness exalteth a people; But the reproach of nations is sin. ");
INSERT INTO engnoy_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","The king's favor is toward a wise servant; But his wrath is against him that causeth shame. ");
INSERT INTO engnoy_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","A soft answer turneth away wrath; But harsh words stir up anger. ");
INSERT INTO engnoy_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","The tongue of the wise maketh knowledge pleasing; But the mouth of fools poureth forth folly. ");
INSERT INTO engnoy_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","The eyes of the LORD are in every place; They behold the evil and the good. ");
INSERT INTO engnoy_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","A mild tongue is a tree of life; But perverseness therein is a wound in the spirit. ");
INSERT INTO engnoy_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","The fool despiseth the correction of his father; But he that regardeth reproof is prudent. ");
INSERT INTO engnoy_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","In the house of the righteous is much wealth; But in the revenues of the wicked there is trouble. ");
INSERT INTO engnoy_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","The lips of the wise spread abroad knowledge; But the heart of the foolish is not sound. ");
INSERT INTO engnoy_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","The sacrifice of the wicked is an abomination to the LORD; But the prayer of the righteous is his delight. ");
INSERT INTO engnoy_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","The way of the wicked is an abomination to the LORD; But him who followeth after righteousness he loveth. ");
INSERT INTO engnoy_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Sore chastisement shall be to him that forsaketh the way; He that hateth reproof shall die. ");
INSERT INTO engnoy_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","The underworld, yea, the region of death, is before the LORD; How much more the hearts of the sons of men! ");
INSERT INTO engnoy_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","The scoffer loveth not his reprover; He will not resort to the wise. ");
INSERT INTO engnoy_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","A joyous heart maketh a bright countenance; But by sorrow of the heart the spirit is broken. ");
INSERT INTO engnoy_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","The heart of the man of understanding seeketh knowledge; But the mouth of fools feedeth on folly. ");
INSERT INTO engnoy_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","The days of the afflicted are all evil; But he that hath a cheerful heart hath a continual feast. ");
INSERT INTO engnoy_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Better is a little, with the fear of the LORD, Than much treasure, and trouble therewith. ");
INSERT INTO engnoy_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Better is a dinner of herbs, where there is love, Than a fatted ox, and hatred therewith. ");
INSERT INTO engnoy_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","The passionate man stirreth up strife; But he who is slow to anger appeaseth strife. ");
INSERT INTO engnoy_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","The way of the slothful is as a hedge of thorns; But the way of the righteous is a highway. ");
INSERT INTO engnoy_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","A wise son maketh a glad father; But a foolish man despiseth his mother. ");
INSERT INTO engnoy_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Folly is joy to him who lacketh wisdom; But the man of understanding walketh uprightly. ");
INSERT INTO engnoy_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Without counsel, plans come to nought; But with a multitude of counsellors they are established. ");
INSERT INTO engnoy_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","A man hath joy by the answer of his mouth; And a word in due season, how good it is! ");
INSERT INTO engnoy_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","The path of life is upward for the wise, So that he turneth away from the underworld beneath. ");
INSERT INTO engnoy_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","The LORD destroyeth the house of the proud; But he will establish the border of the widow. ");
INSERT INTO engnoy_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Evil devices are an abomination to the LORD; But pleasant words are pure. ");
INSERT INTO engnoy_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","He who is greedy of gain troubleth his own house; But he who hateth bribes shall live. ");
INSERT INTO engnoy_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","The heart of the righteous meditateth on his answer; But the mouth of the wicked poureth out evil things. ");
INSERT INTO engnoy_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","The LORD is far from the wicked: But he heareth the prayer of the righteous. ");
INSERT INTO engnoy_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","The light of the eyes rejoiceth the heart, And good tidings make the bones fat. ");
INSERT INTO engnoy_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","The ear that hearkeneth to the reproof of life Shall dwell among the wise. ");
INSERT INTO engnoy_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","He that refuseth instruction despiseth his own life; But he that hearkeneth to rebuke getteth understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","The fear of the LORD guideth to wisdom, And before honor is humility. ");
INSERT INTO engnoy_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","To man belongeth the preparation of the heart; But the answer of the tongue is from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","All the ways of a man are pure in his own eyes; But the LORD weigheth the spirit. ");
INSERT INTO engnoy_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Commit thy doings to the LORD, And thy purposes shall be established. ");
INSERT INTO engnoy_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","The LORD hath ordained every thing for its end; Yea, even the wicked for the day of evil. ");
INSERT INTO engnoy_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Every one that is proud in heart is an abomination to the LORD; From generation to generation he shall not be unpunished. ");
INSERT INTO engnoy_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Through kindness and truth, iniquity is expiated; And, through the fear of the LORD, men depart from evil. ");
INSERT INTO engnoy_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","When a man's ways please the LORD, He maketh even his enemies to be at peace with him. ");
INSERT INTO engnoy_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Better is a little with righteousness, Than great revenues without right. ");
INSERT INTO engnoy_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","The heart of man deviseth his way, But the LORD establisheth his steps. ");
INSERT INTO engnoy_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","A divine sentence is upon the lips of a king; His mouth transgresseth not in judgment. ");
INSERT INTO engnoy_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","A just balance and scales are the appointment of the LORD; All the weights of the bag are his work. ");
INSERT INTO engnoy_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","The doing of wickedness is an abomination to kings; For by righteousness is the throne established. ");
INSERT INTO engnoy_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Righteous lips are the delight of kings, And they love him who speaketh right things. ");
INSERT INTO engnoy_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","The wrath of a king is messengers of death; But a wise man will pacify it. ");
INSERT INTO engnoy_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","In the light of the king's countenance is life, And his favor is a like a cloud bringing the latter rain. ");
INSERT INTO engnoy_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","How much better is it to get wisdom than gold! Yea, to get understanding is rather to be chosen than silver. ");
INSERT INTO engnoy_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","It is the highway of the upright to depart from evil; He that taketh heed to his way preserveth his life. ");
INSERT INTO engnoy_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Pride goeth before destruction, And a haughty spirit before a fall. ");
INSERT INTO engnoy_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Better is it to be of a humble spirit with the lowly, Than to share the spoil with the proud. ");
INSERT INTO engnoy_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","He who giveth heed to the word shall find good; And he who trusteth in the LORD, happy is he! ");
INSERT INTO engnoy_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","The wise in heart shall be called intelligent, And sweetness of the lips increaseth learning. ");
INSERT INTO engnoy_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Understanding is a wellspring of life to him that hath it. And the chastisement of fools is their folly. ");
INSERT INTO engnoy_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","The heart of the wise man instructeth his mouth, And addeth learning to his lips. ");
INSERT INTO engnoy_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Pleasant words are like a honeycomb, Sweet to the taste, and health to the bones. ");
INSERT INTO engnoy_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","There is a way that seemeth right to a man, But the end thereof is the way to death. ");
INSERT INTO engnoy_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","The hunger of the laborer laboreth for him; For his mouth urgeth him on. ");
INSERT INTO engnoy_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","A worthless man diggeth mischief, And on his lips there is, as it were, a burning fire. ");
INSERT INTO engnoy_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","A deceitful man stirreth up strife, And a whisperer separateth friends. ");
INSERT INTO engnoy_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","A man of violence enticeth his neighbor, And leadeth him into a way which is not good. ");
INSERT INTO engnoy_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","He who shutteth his eyes to devise fraud, He who compresseth his lips, hath accomplished mischief! ");
INSERT INTO engnoy_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","The hoary head is a crown of glory, If it be found in the way of righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","He who is slow to anger is better than the mighty; And he who ruleth his spirit, than he that taketh a city. ");
INSERT INTO engnoy_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","The lot is cast into the lap; But the whole decision thereof is from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Better is a dry morsel, and quietness therewith, Than a house full of flesh-banquets with strife. ");
INSERT INTO engnoy_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","A prudent servant shall rule over a son who causeth shame; Yea, with brothers he shall share the inheritance. ");
INSERT INTO engnoy_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","The refining-pot is for silver, and the furnace for gold; But the LORD trieth hearts. ");
INSERT INTO engnoy_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","An evil-doer listeneth to mischievous lips; And a liar giveth ear to a destructive tongue. ");
INSERT INTO engnoy_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Whoso mocketh the poor reproacheth his Maker; He that is glad at calamities shall not go unpunished. ");
INSERT INTO engnoy_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Children's children are the crown of the aged, And their fathers the glory of sons. ");
INSERT INTO engnoy_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Excellent speech becometh not the base; How much less lying lips the noble! ");
INSERT INTO engnoy_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","A gift is a precious stone in the eyes of him who taketh it; Whithersoever it turneth it hath success. ");
INSERT INTO engnoy_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","He who covereth an offence seeketh love; But he who recurreth to a matter removeth a friend. ");
INSERT INTO engnoy_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","A reproof will penetrate deeper into a wise man Than a hundred stripes into a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","An evil man seeketh only rebellion; Therefore shall a cruel messenger be sent against him. ");
INSERT INTO engnoy_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Let a man meet a bear robbed of her whelps, Rather than a fool in his folly. ");
INSERT INTO engnoy_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Whoso returneth evil for good, Evil shall not depart from his house. ");
INSERT INTO engnoy_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","The beginning of strife is as when one letteth out water; Therefore leave off contention before it rolleth onward. ");
INSERT INTO engnoy_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","He that justifieth the wicked, And he that condemneth the just, Both alike are an abomination to the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Why should a price be in the hand of a fool To get wisdom, seeing he hath no sense? ");
INSERT INTO engnoy_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","A friend loveth at all times; But in adversity he is born a brother. ");
INSERT INTO engnoy_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","A man who lacketh understanding striketh hands, And becometh surety in the presence of his friend. ");
INSERT INTO engnoy_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","He who loveth strife loveth transgression; He who raiseth high his gate seeketh ruin. ");
INSERT INTO engnoy_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","He that is of a deceitful heart shall find no good; And he that turneth about with his tongue shall fall into mischief. ");
INSERT INTO engnoy_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Whoso begetteth a fool doeth it to his sorrow; Yea, the father of the fool hath no joy. ");
INSERT INTO engnoy_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","A merry heart doeth good to the body; But a broken spirit drieth up the bones. ");
INSERT INTO engnoy_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","The wicked man taketh a gift out of the bosom, To pervert the ways of judgment. ");
INSERT INTO engnoy_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Wisdom is before the face of him that hath understanding; But the eyes of a fool are in the ends of the earth. ");
INSERT INTO engnoy_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","A foolish son is a grief to his father, And bitterness to her that bore him. ");
INSERT INTO engnoy_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Moreover, to punish the righteous is not good, Nor to smite the noble for their equity. ");
INSERT INTO engnoy_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","He that spareth his words is imbued with knowledge; And he that is of a cool spirit is a man of understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Even a fool, when he is silent, is accounted wise; He that shutteth his lips is a man of understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","He who separateth himself seeketh his own desire; Against all sound discretion he rusheth on. ");
INSERT INTO engnoy_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","The fool hath no delight in understanding, But rather in revealing his own mind. ");
INSERT INTO engnoy_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","When the wicked cometh, then cometh also contempt; And with baseness, shame. ");
INSERT INTO engnoy_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","The words of a man's mouth are deep waters, And the wellspring of wisdom is an overflowing brook. ");
INSERT INTO engnoy_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","It is not good to be partial to the wicked, So as to overthrow the righteous in judgment. ");
INSERT INTO engnoy_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","The lips of a fool enter into strife, And his mouth calleth for blows. ");
INSERT INTO engnoy_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","A fool's mouth is his destruction, And his lips are a snare for his life. ");
INSERT INTO engnoy_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","The words of a talebearer are like sweet morsels; For they go down to the innermost parts of the body. ");
INSERT INTO engnoy_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Moreover, he that is slothful in his work Is brother to him that is a great waster. ");
INSERT INTO engnoy_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","The name of the LORD is a strong tower; The righteous runneth to it, and is safe. ");
INSERT INTO engnoy_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","The rich man's wealth is his strong city, And as a high wall, in his own conceit. ");
INSERT INTO engnoy_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Before destruction the heart of a man is haughty, And before honor is humility. ");
INSERT INTO engnoy_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","He who answereth a matter before he hath heard it, It is folly and shame to him. ");
INSERT INTO engnoy_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","The spirit of a man will sustain his infirmity; But a wounded spirit who can bear? ");
INSERT INTO engnoy_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","The heart of the intelligent will acquire knowledge, And the ear of the wise will seek knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","A gift maketh room for a man, And bringeth him into the presence of the great. ");
INSERT INTO engnoy_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","He that first pleadeth his cause appeareth just; But his opponent cometh, and searcheth him through. ");
INSERT INTO engnoy_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","The lot causeth contentions to cease, And parteth asunder the mighty. ");
INSERT INTO engnoy_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","A brother offended is harder to be won than a strong city; Yea, their contentions are like the bars of a castle. ");
INSERT INTO engnoy_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","With the fruit of a man's mouth shall his stomach be filled; He shall be filled with the produce of his lips. ");
INSERT INTO engnoy_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Death and life are in the power of the tongue; They that love it shall eat its fruit. ");
INSERT INTO engnoy_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","He that findeth a wife findeth a blessing, And obtaineth favor from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","The poor useth entreaties; But the rich answereth roughly. ");
INSERT INTO engnoy_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","A man of many friends will show himself false; Yet there is a friend who sticketh closer than a brother. ");
INSERT INTO engnoy_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Better is the poor man who walketh in his integrity, Than he who is of false lips and a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Moreover, that the soul be without knowledge is not good, And he that hasteth with is feet stumbleth. ");
INSERT INTO engnoy_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","The folly of man destroyeth his way, And then his heart fretteth against the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Wealth maketh many friends; But the poor is separated from his neighbor. ");
INSERT INTO engnoy_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","A false witness shall not be unpunished, And he that speaketh lies shall not escape. ");
INSERT INTO engnoy_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Many are they who caress the noble, And every one is the friend of him who giveth gifts. ");
INSERT INTO engnoy_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","All the brethren of the poor man hate him; How much more do his friends go far from him! He runneth after their words,—they are gone! ");
INSERT INTO engnoy_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","He that getteth wisdom loveth himself; He that keepeth understanding shall find good. ");
INSERT INTO engnoy_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","A false witness shall not be unpunished, And he that speaketh lies shall perish. ");
INSERT INTO engnoy_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Luxury is not seemly for a fool; Much less should a servant have rule over princes. ");
INSERT INTO engnoy_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","A man of understanding is slow to anger; Yea, it is his glory to pass over an offence. ");
INSERT INTO engnoy_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","The wrath of a king is like the roaring of a lion; But his favor, like dew upon the grass. ");
INSERT INTO engnoy_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","A foolish son is a calamity to his father, And the contentions of a wife are a continual dropping. ");
INSERT INTO engnoy_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Houses and riches are an inheritance from fathers; But a prudent wife is from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Slothfulness casteth into a deep sleep, And the idle person shall suffer hunger. ");
INSERT INTO engnoy_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","He that keepeth the commandment keepeth his life; But he that neglecteth his ways shall die. ");
INSERT INTO engnoy_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","He who hath pity on the poor lendeth to the LORD, And that which he giveth will he repay him. ");
INSERT INTO engnoy_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Chasten thy son because there is hope, But let not thy soul desire to slay him. ");
INSERT INTO engnoy_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","A man of great wrath will suffer punishment; For if thou deliver him, yet must thou do it again. ");
INSERT INTO engnoy_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Listen to counsel and receive instruction, That thou mayst be wise in thy latter years. ");
INSERT INTO engnoy_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Many are the devices in the heart of a man; But the purpose of the LORD, that shall stand. ");
INSERT INTO engnoy_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","The charm of a man is his kindness; And better is a poor man than a liar. ");
INSERT INTO engnoy_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","The fear of the LORD tendeth to life, And he that hath it shall abide satisfied; He shall not be visited with evil. ");
INSERT INTO engnoy_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","The slothful man dippeth his hand into the dish: He doth not bring it back even to his mouth. ");
INSERT INTO engnoy_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Strike the scoffer, and the simple will become prudent; Reprove a man of understanding, and he will discern knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","The son that causeth shame and disgrace doeth violence to his father, And chaseth away his mother. ");
INSERT INTO engnoy_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Cease, my son, to listen to the instruction That causeth thee to wander from the words of knowledge! ");
INSERT INTO engnoy_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","A worthless witness scoffeth at justice, And the mouth of the wicked swalloweth down iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Punishments are prepared for scoffers, And stripes for the back of fools. ");
INSERT INTO engnoy_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Wine is a mocker, strong drink a brawler, And he that reeleth with it is not wise. ");
INSERT INTO engnoy_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","The terror of a king is like the roaring of a lion; He who provoketh him sinneth against himself. ");
INSERT INTO engnoy_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","It is an honor to a man to cease from strife; Bur every fool rusheth into it. ");
INSERT INTO engnoy_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","The sluggard will not plough by reason of the cold; Therefore shall he beg in harvest, and have nothing. ");
INSERT INTO engnoy_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","A design in the heart of a man is like deep waters; But a man of understanding draweth it out. ");
INSERT INTO engnoy_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Many will proclaim their own kindness; But a faithful man who can find? ");
INSERT INTO engnoy_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","He who walketh in his integrity is a righteous man; Happy will be his children after him! ");
INSERT INTO engnoy_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","The king, sitting upon the throne of judgment, Scattereth with his eyes all the wicked like chaff. ");
INSERT INTO engnoy_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Who can say, “I have kept my heart clean; I am free from my sin?” ");
INSERT INTO engnoy_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Divers weights and divers measures,—Both of them are an abomination to the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Even in childhood one maketh himself known by his doings, Whether his actions will be pure and right. ");
INSERT INTO engnoy_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","The ear that heareth, and the eye that seeth,—The LORD made them both. ");
INSERT INTO engnoy_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Love not sleep, lest thou come to poverty; Open thine eyes, and thou shalt be satisfied with bread. ");
INSERT INTO engnoy_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","“Bad! bad!” saith the buyer; But when he hath gone his way, then he boasteth. ");
INSERT INTO engnoy_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","There is gold and abundance of pearls; But the lips of knowledge are a precious vase. ");
INSERT INTO engnoy_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Take his garment who is surety for another; Yea, take a pledge of him who is bound for a stranger. ");
INSERT INTO engnoy_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","The bread of falsehood is sweet to a man; But afterwards his mouth is filled with gravel. ");
INSERT INTO engnoy_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Purposes are established by counsel; Therefore with good advice make war. ");
INSERT INTO engnoy_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","He who goeth about as a tale-bearer revealeth secrets; Therefore associate not with him who keepeth open his lips. ");
INSERT INTO engnoy_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Whoso curseth his father or his mother, His lamp shall be put out in midnight darkness. ");
INSERT INTO engnoy_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","A possession may be gotten hastily in the beginning, But in the end it will not be blessed. ");
INSERT INTO engnoy_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Say not thou, “I will repay evil;” Wait on the LORD, and he will help thee. ");
INSERT INTO engnoy_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Divers weights are an abomination to the LORD, And a false balance is not good. ");
INSERT INTO engnoy_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","A man's steps are from the LORD; How, then, can a man understand his way? ");
INSERT INTO engnoy_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","It is a snare to a man to utter a vow rashly, And after vows to consider. ");
INSERT INTO engnoy_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","A wise king scattereth the wicked like chaff, And bringeth over them the wheel. ");
INSERT INTO engnoy_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","The spirit of a man is the lamp of the LORD, Which searcheth all the inner chambers of his body. ");
INSERT INTO engnoy_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Mercy and truth preserve the king; Yea, his throne is upholden by mercy. ");
INSERT INTO engnoy_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","The glory of young men is their strength, And the beauty of old men is the gray head. ");
INSERT INTO engnoy_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Wounding stripes are the remedy for a bad man; Yea, stripes which reach to the inner chambers of the body. ");
INSERT INTO engnoy_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","As streams of water, So is the heart of the king in the hand of the LORD; He turneth it whithersoever he will. ");
INSERT INTO engnoy_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","All the ways of a man are right in his own eyes; But the LORD weigheth the heart. ");
INSERT INTO engnoy_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","To do justice and equity Is more acceptable to the LORD than sacrifice. ");
INSERT INTO engnoy_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","The lofty look, the proud heart, The lamp of the wicked, is ruin. ");
INSERT INTO engnoy_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","The plans of the diligent tend only to plenty; But the hasty hasteneth only to want. ");
INSERT INTO engnoy_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","The getting of treasures by a false tongue Is the fleeting breath of them that seek death. ");
INSERT INTO engnoy_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","The rapine of the wicked shall snatch them away, Because they refuse to do justice. ");
INSERT INTO engnoy_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","The way of the guilty man is crooked; But he that is pure, his doings are right. ");
INSERT INTO engnoy_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Better is it to dwell in a corner of the housetop Than with a brawling woman in a large house. ");
INSERT INTO engnoy_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","The soul of the wicked longeth to do evil; His neighbor findeth no compassion in his eyes. ");
INSERT INTO engnoy_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","When the scoffer is punished, the simple is made wise; When the wise man is taught, he receiveth knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","The righteous man hath regard to the house of the wicked; He casteth the wicked headlong into ruin. ");
INSERT INTO engnoy_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Whoso stoppeth his ears at the cry of the poor, He also shall cry aloud, but shall not be heard. ");
INSERT INTO engnoy_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","A gift in secret pacifieth anger; And a present in the bosom, strong wrath. ");
INSERT INTO engnoy_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","To do justice shall be joy to the righteous; But destruction is for them that do iniquity. ");
INSERT INTO engnoy_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","A man who wandereth from the way of discretion Shall rest in the assembly of the dead. ");
INSERT INTO engnoy_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","He that loveth pleasure will be a poor man; He that loveth wine and oil will not be rich. ");
INSERT INTO engnoy_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","The wicked shall be a ransom for the righteous! And in the room of the upright shall be the transgressor. ");
INSERT INTO engnoy_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","It is better to dwell in a desert land Than with a contentious and fretful woman. ");
INSERT INTO engnoy_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Precious treasure and oil are in the dwelling of the wise; But the foolish man swalloweth them up. ");
INSERT INTO engnoy_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","He who followeth after righteousness and mercy Shall find life, prosperity, and honor. ");
INSERT INTO engnoy_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","A wise man scaleth the city of the mighty, And bringeth down the strength in which it trusted. ");
INSERT INTO engnoy_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Whoso keepeth his mouth and his tongue Keepeth his soul from trouble. ");
INSERT INTO engnoy_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","The proud and haughty,—scoffer is his name; He acteth with haughty arrogance. ");
INSERT INTO engnoy_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","The desire of the sluggard will destroy him; For his hands refuse to labor. ");
INSERT INTO engnoy_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","The covetous man coveteth all the day long; But the righteous man giveth, and doth not withhold. ");
INSERT INTO engnoy_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","The sacrifice of the wicked is an abomination; How much more when he bringeth it with an evil design! ");
INSERT INTO engnoy_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","A false witness shall perish; But a man that hearkeneth shall speak forever. ");
INSERT INTO engnoy_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","The wicked man hardeneth his face; But the upright directeth his way. ");
INSERT INTO engnoy_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Wisdom is nothing, and understanding is nothing, And devices are nothing, against the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","The horse is prepared for the day of battle; But victory is from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","A good name is rather to be chosen than great riches; And better is good-will than silver and gold. ");
INSERT INTO engnoy_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","The rich and the poor meet together; The LORD is the Maker of them all. ");
INSERT INTO engnoy_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","The prudent man seeth the evil, and hideth himself; But the simple rush on, and are punished. ");
INSERT INTO engnoy_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","By humility and the fear of the LORD Are riches and honor and life. ");
INSERT INTO engnoy_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Thorns and snares are in the way of the deceitful; He that will preserve his life will be far from them. ");
INSERT INTO engnoy_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Train up a child in accordance with his way, And when he is old he will not depart from it. ");
INSERT INTO engnoy_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","The rich ruleth over the poor, And the borrower is servant to the lender. ");
INSERT INTO engnoy_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","He who soweth iniquity shall reap calamity, And the rod of his punishment is prepared. ");
INSERT INTO engnoy_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","He who hath a bountiful eye shall be blessed, Because he giveth of his bread to the poor. ");
INSERT INTO engnoy_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Cast out the scoffer, and contention will go out; Yea, strife and reproach will cease. ");
INSERT INTO engnoy_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","He who loveth purity of heart, Grace is upon his lips, and the king will be his friend. ");
INSERT INTO engnoy_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","The eyes of the LORD watch over knowledge; But he overthroweth the words of the treacherous. ");
INSERT INTO engnoy_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","The slothful man saith, “There is a lion without; I shall be slain in the streets.” ");
INSERT INTO engnoy_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","The mouth of strange women is a deep pit; He with whom the LORD is angry shall fall therein. ");
INSERT INTO engnoy_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Folly is bound to the heart of a child; But the rod of correction will drive it far from him. ");
INSERT INTO engnoy_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","He that oppresseth the poor to increase his wealth, And he that giveth to the rich, shall surely come to want. ");
INSERT INTO engnoy_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Incline thine ear, and hear the words of the wise, And give heed to my instruction! ");
INSERT INTO engnoy_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","For it will be a pleasant thing, if thou keep them in thy bosom, When they are altogether established upon thy lips. ");
INSERT INTO engnoy_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","That thy trust may be in the LORD, I have this day given to thee instruction, yea, to thee. ");
INSERT INTO engnoy_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Behold, I have written to thee excellent things Concerning counsel and knowledge; ");
INSERT INTO engnoy_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","That I may make thee know rectitude, and words of truth; That thou mayst bring back words of truth to them that send thee. ");
INSERT INTO engnoy_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Rob not the poor man, because he is poor, Nor crush thou the destitute at the gate; ");
INSERT INTO engnoy_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","For the LORD will maintain their cause, And despoil their spoilers of life. ");
INSERT INTO engnoy_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Make no friendship with a passionate man, Nor be the companion of a man prone to wrath; ");
INSERT INTO engnoy_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","Lest thou learn his ways, And take to thyself a snare. ");
INSERT INTO engnoy_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Be not thou one of those who strike hands, Of those who are sureties for debts. ");
INSERT INTO engnoy_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","When thou hast nothing to pay, Why should thy bed be taken from under thee? ");
INSERT INTO engnoy_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Remove not the ancient landmark, Which thy fathers have made. ");
INSERT INTO engnoy_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Seest thou a man diligent in his business? He shall be the minister of kings; He shall not serve obscure men. ");
INSERT INTO engnoy_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","When thou sittest to eat with a ruler, Consider well what is before thee; ");
INSERT INTO engnoy_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","For thou wilt put a knife to thy throat, If thou art a man given to appetite! ");
INSERT INTO engnoy_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Long not for his dainties. For they are deceitful meat. ");
INSERT INTO engnoy_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Toil not to become rich; Cease from this, thy wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Wilt thou let thine eyes fly toward them? They are gone! For riches truly make to themselves wings; They fly away like the eagle toward heaven. ");
INSERT INTO engnoy_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Eat not the bread of him that hath an evil eye, And long not for his dainties; ");
INSERT INTO engnoy_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","For as he thinketh in his heart, so is he. “Eat and drink!” saith he to thee; But his heart is not with thee. ");
INSERT INTO engnoy_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","The morsel, which thou hast eaten, thou shalt vomit up; And thou wilt have thrown away thy sweet words. ");
INSERT INTO engnoy_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Speak not in the ears of a fool; For he will despise the wisdom of thy words. ");
INSERT INTO engnoy_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Remove not the ancient landmark, And enter not into the fields of the fatherless! ");
INSERT INTO engnoy_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","For their avenger is mighty; He will maintain their cause against thee. ");
INSERT INTO engnoy_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Apply thy heart to instruction, And thine ears to the words of knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Withhold not correction from a child; If thou beat him with the rod, he will not die. ");
INSERT INTO engnoy_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Beat him thyself with the rod, And thou shalt rescue him from the underworld. ");
INSERT INTO engnoy_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","My son, if thy heart be wise, My heart shall rejoice, even mine; ");
INSERT INTO engnoy_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Yea, my reins shall exult, When thy lips speak right things. ");
INSERT INTO engnoy_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Let not thy heart envy sinners, But continue thou in the fear of the LORD all the day long; ");
INSERT INTO engnoy_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","For surely there shall be a reward, And thine expectation shall not be cut off. ");
INSERT INTO engnoy_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Hear thou, my son, and be wise; And let thy heart go forward in the way! ");
INSERT INTO engnoy_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Be not thou among winebibbers, And riotous eaters of flesh; ");
INSERT INTO engnoy_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","For the drunkard and the glutton shall come to poverty, And drowsiness will clothe a man with rags. ");
INSERT INTO engnoy_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Hearken to thy father, who begat thee, And despise not thy mother when she is old. ");
INSERT INTO engnoy_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Buy the truth, and sell it not; Buy wisdom and instruction and understanding. ");
INSERT INTO engnoy_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","The father of a righteous man shall greatly rejoice; Yea, he who begetteth a wise child shall have joy in him. ");
INSERT INTO engnoy_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Let thy father and thy mother have joy; Yea, let her that bore thee rejoice! ");
INSERT INTO engnoy_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","My son, give me thy heart, And let thine eyes observe my ways! ");
INSERT INTO engnoy_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","For a harlot is a deep ditch; Yea, a strange woman is a narrow pit. ");
INSERT INTO engnoy_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Like a robber she lieth in wait, And increaseth the treacherous among men. ");
INSERT INTO engnoy_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Who hath woe? Who hath sorrow? Who contentions? Who anxiety? Who wounds without cause? Who dimness of eyes? ");
INSERT INTO engnoy_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","They that tarry long at the wine; They that go in to seek mixed wine. ");
INSERT INTO engnoy_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Look not thou upon the wine when it is red, When it sparkleth in the cup, When it goeth down smoothly. ");
INSERT INTO engnoy_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","At the last it biteth like a serpent, And stingeth like an adder. ");
INSERT INTO engnoy_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Thine eyes will look upon strange women, And thy heart will utter perverse things. ");
INSERT INTO engnoy_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Yea, thou shalt be as one that lieth down in the midst of the sea, And as one that lieth down upon the top of a mast. ");
INSERT INTO engnoy_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","They have stricken me shalt thou say,—I suffered no pain! They have beaten me,—I felt it not! When shall I awake? I will seek it yet again. ");
INSERT INTO engnoy_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Be not thou envious of wicked men, And desire not to be with them! ");
INSERT INTO engnoy_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","For their heart studieth destruction, And their lips speak mischief. ");
INSERT INTO engnoy_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Through wisdom is a house builded, And by understanding is it established; ");
INSERT INTO engnoy_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Yea, by knowledge are the chambers filled With all precious and goodly substance. ");
INSERT INTO engnoy_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","The wise man is strong; Yea, the man of understanding establisheth his strength. ");
INSERT INTO engnoy_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","For by wise counsel shalt thou make war, And by the multitude of counsellors cometh success. ");
INSERT INTO engnoy_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Wisdom is too high for the fool; He openeth not his mouth at the gate. ");
INSERT INTO engnoy_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","He that deviseth to do evil Shall be called mischief-master. ");
INSERT INTO engnoy_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","The purpose of folly is sin; And a scoffer is an abomination to men. ");
INSERT INTO engnoy_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","If thy spirit faint in the day of adversity, Faint will be thy strength. ");
INSERT INTO engnoy_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Deliver thou those who are dragged to death, And those who totter to the slaughter,—O keep them back! ");
INSERT INTO engnoy_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","If thou sayst, “Behold, we knew it not!” Doth not he that weigheth the heart observe it? Yea, he that keepeth thy soul knoweth it. And he will render to every man according to his works. ");
INSERT INTO engnoy_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Eat honey, my son, for it is good, And the honeycomb, which is sweet to thy taste; ");
INSERT INTO engnoy_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","So learn thou wisdom for thy soul! When thou hast found it, there shall be a reward, And thy expectation shall not be cut off. ");
INSERT INTO engnoy_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Plot not, O wicked man! against the habitation of the righteous; Spoil not his resting-place! ");
INSERT INTO engnoy_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","For though the righteous fall seven times, yet shall he rise up again; But the wicked shall fall into mischief. ");
INSERT INTO engnoy_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Rejoice not when thine enemy falleth, And let not thy heart be glad when he stumbleth; ");
INSERT INTO engnoy_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Lest the LORD see, and it displease him, And he turn away his anger from him. ");
INSERT INTO engnoy_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Fret not thyself on account of evil men, Neither be thou envious of the wicked; ");
INSERT INTO engnoy_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","For there shall be no posterity to the evil man; The lamp of the wicked shall be put out. ");
INSERT INTO engnoy_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","My son, fear thou the LORD and the king; And mingle not with them that are given to change! ");
INSERT INTO engnoy_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","For their calamity shall rise up suddenly, And their ruin, coming from them both, in a moment. ");
INSERT INTO engnoy_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","These also are words of the wise. It is not good to have respect of persons in judgment. ");
INSERT INTO engnoy_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","He that saith to the wicked, “Thou art righteous,” Him shall the people curse; Nations shall abhor him. ");
INSERT INTO engnoy_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","But it shall be well with them that punish him, And the blessing of prosperity shall come upon them. ");
INSERT INTO engnoy_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","He that giveth a right answer Kisseth the lips. ");
INSERT INTO engnoy_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Arrange thy work without, And prepare it in thy field: Afterwards thou mayst build thy house. ");
INSERT INTO engnoy_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Be not a witness without cause against thy neighbor, And deceive not with thy lips. ");
INSERT INTO engnoy_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Say not, “As he hath done to me, So will I do to him; I will render to the man according to his doings.” ");
INSERT INTO engnoy_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","I passed by the field of the slothful, And by the vineyard of the man void of understanding, ");
INSERT INTO engnoy_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","And, lo! it was all overgrown with thorns, And the face thereof was covered with nettles, And the stone wall thereof was broken down. ");
INSERT INTO engnoy_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Then I saw, and considered it well; I looked upon it. and received instruction. ");
INSERT INTO engnoy_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","“A little sleep, a little slumber! A little folding of the hands to rest!” ");
INSERT INTO engnoy_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","So shall poverty come upon thee like a highwayman; Yea, want like an armed man. ");
INSERT INTO engnoy_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","These also are proverbs of Solomon, which the men of Hezekiah, king of Judah, collected. ");
INSERT INTO engnoy_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","It is the glory of God to conceal a thing; But it is the glory of kings to search out a matter. ");
INSERT INTO engnoy_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","As the heavens for their height, And as the earth for its depth, So is the heart of kings unsearchable! ");
INSERT INTO engnoy_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Take away the dross from the silver, And there will come forth a vessel for the founder; ");
INSERT INTO engnoy_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Take away the wicked man from the presence of the king, And his throne will be established by righteousness. ");
INSERT INTO engnoy_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Put not thyself forth in the presence of the king, Nor set thyself in the place of the great; ");
INSERT INTO engnoy_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","For better is it that one should say to thee, “Come up hither!” Than that he should put thee in a lower place, In the presence of the prince whom thine eyes behold. ");
INSERT INTO engnoy_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Go not forth hastily to engage in a suit, Lest thou know not what to do in the end of it, When thine adversary hath put thee to shame. ");
INSERT INTO engnoy_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Maintain thy cause with thine adversary, But reveal not another's secret; ");
INSERT INTO engnoy_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Lest he that heareth it put thee to shame, And thy infamy depart not from thee. ");
INSERT INTO engnoy_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","A word spoken in season Is like apples of gold in figured-work of silver. ");
INSERT INTO engnoy_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","As a ring of gold, and an ornament of fine gold, So is a wise reprover to an attentive ear. ");
INSERT INTO engnoy_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","As the cold of snow in the time of harvest, So is a faithful messenger to them that send him; For he refresheth the spirit of his masters. ");
INSERT INTO engnoy_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","As clouds and wind without rain, So is the man that boasteth falsely of giving. ");
INSERT INTO engnoy_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","By long forbearing is a prince appeased; And a soft tongue breaketh bones. ");
INSERT INTO engnoy_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Hast thou found honey? eat what is sufficient for thee, Lest thou be surfeited with it, and vomit it up. ");
INSERT INTO engnoy_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Let thy foot be seldom in the house of thy friend, Lest he be surfeited with thee and hate thee. ");
INSERT INTO engnoy_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","A battle-hammer, and a sword, and a sharp arrow, Is the man who beareth false witness against his neighbor. ");
INSERT INTO engnoy_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","As a broken tooth, and a wavering foot, So is trust in an unfaithful man in time of trouble. ");
INSERT INTO engnoy_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","As he that taketh off a garment on a cold day, As vinegar upon nitre, So is he that singeth songs to a heavy heart. ");
INSERT INTO engnoy_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","If thine enemy be hungry, give him bread to eat; And if he be thirsty, give him water to drink; ");
INSERT INTO engnoy_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","For thou wilt heap coals of fire upon his head, And the LORD will reward thee. ");
INSERT INTO engnoy_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","As the north wind bringeth forth rain, So a backbiting tongue maketh an angry countenance. ");
INSERT INTO engnoy_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Better is it to dwell in a corner of the housetop, Than with a quarrelsome woman in a large house. ");
INSERT INTO engnoy_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","As cold water to the thirsty, So is good news from a far country. ");
INSERT INTO engnoy_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","As a troubled fountain, and as a corrupted spring, So is a righteous man falling before the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","To eat much honey is not good; So the search of high things is weariness. ");
INSERT INTO engnoy_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","As a city broken through and without a wall, So is he that hath no rule over his spirit. ");
INSERT INTO engnoy_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","As snow in summer, and as rain in harvest, So honor is not becoming to a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","As the sparrow wandereth, and the swallow flieth away, So the curse without cause shall not come. ");
INSERT INTO engnoy_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","A whip for the horse, a bridle for the ass, And a rod for the back of the fool. ");
INSERT INTO engnoy_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Answer not a fool according to his folly, Lest thou also become like to him. ");
INSERT INTO engnoy_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Answer a fool according to his folly, Lest he be wise in his own conceit. ");
INSERT INTO engnoy_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","He cutteth off the feet, and drinketh damage, Who sendeth a message by the hand of a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","The legs of a lame man hang loose; So is it with a proverb in the mouth of fools. ");
INSERT INTO engnoy_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","As he who bindeth a stone in a sling, So is he that giveth honor to a fool. ");
INSERT INTO engnoy_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","As a thorn lifted up by the hand of a drunkard, So is a proverb in the mouth of fools. ");
INSERT INTO engnoy_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","As an archer who woundeth every one, So is he who hireth fools and hireth wayfarers. ");
INSERT INTO engnoy_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","As a dog returneth to that which he hath vomited, So a fool repeateth his folly. ");
INSERT INTO engnoy_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Seest thou a man wise in his own conceit? There is more hope of a fool than of him. ");
INSERT INTO engnoy_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","The slothful man saith, “There is a lion in the way; There is a lion in the streets.” ");
INSERT INTO engnoy_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","As a door turneth upon its hinges, So doth the sluggard upon his bed. ");
INSERT INTO engnoy_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","The sluggard dippeth his hand into the dish; It grieveth him to bring it again to his mouth. ");
INSERT INTO engnoy_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","The sluggard is wiser in his own conceit Than seven men who can render a reason. ");
INSERT INTO engnoy_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","As one that taketh a dog by the ears, So is he who, passing by, is enraged on account of the quarrel of another. ");
INSERT INTO engnoy_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","As a madman That casteth about darts, arrows, and death, ");
INSERT INTO engnoy_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","So is the man who deceiveth his neighbor, And saith, “Was I not in sport?” ");
INSERT INTO engnoy_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Where there is no wood, the fire goeth out; So, where there is no talebearer, contention ceaseth. ");
INSERT INTO engnoy_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","As coal is for heat, and as wood for fire, So is a contentious man for kindling strife. ");
INSERT INTO engnoy_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","The words of a talebearer are like dainties; For they go down to the innermost parts of the body. ");
INSERT INTO engnoy_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","As drossy silver spread over an earthen vessel, So are warm lips and an evil heart. ");
INSERT INTO engnoy_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","The hater dissembleth with his lips, And layeth up deceit within him. ");
INSERT INTO engnoy_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","When he speaketh fair, believe him not! For there are seven abominations in his heart. ");
INSERT INTO engnoy_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","His hatred is covered by deceit; His wickedness shall be revealed in the great assembly. ");
INSERT INTO engnoy_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","He that diggeth a pit shall fall therein; And he that rolleth a stone, it shall return upon him. ");
INSERT INTO engnoy_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","A lying tongue hateth those whom it woundeth, And a flattering mouth worketh ruin. ");
INSERT INTO engnoy_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Boast not thyself of to-morrow; For thou knowest not what a day may bring forth! ");
INSERT INTO engnoy_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Let another man praise thee, and not thine own mouth; A stranger, and not thine own lips. ");
INSERT INTO engnoy_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","A stone is heavy and sand is weighty; But a fool's wrath is heavier than both. ");
INSERT INTO engnoy_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Wrath is cruel, and anger overwhelming; But who is able to stand before jealousy? ");
INSERT INTO engnoy_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Better is open rebuke Than love kept concealed. ");
INSERT INTO engnoy_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Faithful are the wounds of a friend; But the kisses of an enemy are deceitful. ");
INSERT INTO engnoy_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","He who is fed to the full loatheth the honeycomb; But to the hungry any bitter thing is sweet. ");
INSERT INTO engnoy_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","As a bird that wandereth from its nest, So is a man who wandereth from his place. ");
INSERT INTO engnoy_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Oil and perfume gladden the heart; Sweet also is one's friend by hearty counsel. ");
INSERT INTO engnoy_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Thine own friend and thy father's friend forsake not; And go not into thy brother's house in the day of thy calamity. Better is a neighbor that is near, than a brother far off. ");
INSERT INTO engnoy_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Be wise, my son, and make my heart glad, That I may give an answer to him that reproacheth me. ");
INSERT INTO engnoy_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","A prudent man foreseeth the evil, and hideth himself; The simple pass on, and are punished. ");
INSERT INTO engnoy_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Take his garment who is surety for another; Yea, take a pledge of him who is bound for a stranger. ");
INSERT INTO engnoy_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","He who blesseth his neighbor with a loud voice, rising early for it, It shall be accounted to him as a curse. ");
INSERT INTO engnoy_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","A continual dropping in a very rainy day And a quarrelsome wife are alike. ");
INSERT INTO engnoy_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","He who restraineth her restraineth the wind; And his right hand layeth hold of oil. ");
INSERT INTO engnoy_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Iron sharpeneth iron; So one man sharpeneth the face of another. ");
INSERT INTO engnoy_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","He that watcheth the fig-tree shall eat its fruit; So he that is careful for his master shall come to honor. ");
INSERT INTO engnoy_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","As in water face answereth to face, So doth the heart of man to man. ");
INSERT INTO engnoy_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","The realms of the dead are never full; So the eyes of man are never satisfied. ");
INSERT INTO engnoy_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","The refining-pot is for silver, and the furnace for gold; So let a man be to the mouth that giveth him praise. ");
INSERT INTO engnoy_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Though thou shouldst beat a fool in a mortar, Among bruised wheat, with a pestle, Yet will not his folly depart from him. ");
INSERT INTO engnoy_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Be thou diligent to know the state of thy flocks, And look well to thy herds! ");
INSERT INTO engnoy_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","For riches last not for ever; Not even a crown endureth from generation to generation. ");
INSERT INTO engnoy_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","The hay disappeareth, and the tender grass showeth itself, And the herbage of the mountains is gathered in. ");
INSERT INTO engnoy_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","The lambs are thy clothing, And the goats the price of thy field. ");
INSERT INTO engnoy_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","There is goat's milk enough for thy food, For the food of thy household, And for the sustenance of thy maidens. ");
INSERT INTO engnoy_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","The wicked flee when no one pursueth; But the righteous is as bold as a lion. ");
INSERT INTO engnoy_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Through the transgression of a land many are its rulers; But through men of prudence and understanding the prince shall live long. ");
INSERT INTO engnoy_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","A poor man who oppresseth the needy Is a sweeping rain which leaveth no food. ");
INSERT INTO engnoy_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","They who forsake the law praise the wicked; But they who keep the law contend with them. ");
INSERT INTO engnoy_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Wicked men understand not equity; But they who seek the LORD understand all things. ");
INSERT INTO engnoy_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Better is a poor man who walketh in uprightness, Than he who is perverse in his ways, though he be rich. ");
INSERT INTO engnoy_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","He that keepeth the law is a wise son; But he that is the companion of prodigals bringeth shame on his father. ");
INSERT INTO engnoy_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","He that increaseth his substance by usurious gain Gathereth it for him who will pity the poor. ");
INSERT INTO engnoy_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","He that turneth away his ear from hearing the law, Even his prayer shall be an abomination. ");
INSERT INTO engnoy_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","He that causeth the righteous to go astray in an evil way Shall himself fall into his own pit; But the upright shall have good things in possession. ");
INSERT INTO engnoy_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","The rich man is wise in his own conceit; But the poor man, who hath understanding, will search him through. ");
INSERT INTO engnoy_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","When the righteous rejoice, there is great glorying; But, when the wicked are exalted, men hide themselves. ");
INSERT INTO engnoy_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","He that covereth his sins shall not prosper; But he that confesseth and forsaketh them shall have mercy. ");
INSERT INTO engnoy_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Happy the man who feareth always! But he who hardeneth his heart shall fall into mischief. ");
INSERT INTO engnoy_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","As a roaring lion and a hungry bear, So is a wicked ruler over a needy people. ");
INSERT INTO engnoy_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","The prince who is weak in understanding is great in oppression; But he who hateth unjust gain shall prolong his days. ");
INSERT INTO engnoy_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","A man who is burdened with life-blood—Let him flee to the pit! let no man stay him! ");
INSERT INTO engnoy_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","He who walketh uprightly shall be safe; But he who is perverse in his ways shall fall at once. ");
INSERT INTO engnoy_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","He who tilleth his land shall have bread enough; And he that followeth after worthless persons shall have poverty enough. ");
INSERT INTO engnoy_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","A faithful man shall abound with blessings; But he that maketh haste to be rich shall not go unpunished. ");
INSERT INTO engnoy_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","To have respect to persons is not good; Since for a piece of bread that man will transgress. ");
INSERT INTO engnoy_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","He who hath an evil eye hasteth after wealth, And considereth not that poverty will come upon him. ");
INSERT INTO engnoy_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","He who rebuketh a man shall afterwards find favor More than he who flattereth with his tongue. ");
INSERT INTO engnoy_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Whoso stealeth from his father or his mother, And saith, “It is no transgression,” The same is the companion of a robber. ");
INSERT INTO engnoy_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","He who is of a proud heart stirreth up strife; But he that trusteth in the LORD shall be rich. ");
INSERT INTO engnoy_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","He who trusteth in his own understanding is a fool; But he who walketh wisely shall be delivered. ");
INSERT INTO engnoy_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","He who giveth to the poor shall not want; But he that hideth his eyes shall have many a curse. ");
INSERT INTO engnoy_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","When the wicked are exalted, men hide themselves; But, when they perish, the righteous increase. ");
INSERT INTO engnoy_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","He who, being often reproved, hardeneth his neck, Shall suddenly be destroyed, and that without remedy. ");
INSERT INTO engnoy_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","When the righteous are powerful, the people rejoice; But when the wicked beareth rule, the people mourn. ");
INSERT INTO engnoy_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","He who loveth wisdom rejoiceth his father; But he who is a companion of harlots destroyeth his substance. ");
INSERT INTO engnoy_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","A king by equity establisheth a land; But he who receiveth gifts overthroweth it. ");
INSERT INTO engnoy_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","A man who flattereth his neighbor Spreadeth a net for his feet. ");
INSERT INTO engnoy_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","In the transgression of a wicked man there is a snare; But the righteous shall sing and rejoice. ");
INSERT INTO engnoy_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","A righteous man careth for the cause of the poor; A wicked man discerneth not knowledge. ");
INSERT INTO engnoy_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Scoffers kindle a city into a flame; But wise men pacify wrath. ");
INSERT INTO engnoy_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","If a wise man contend in a cause with a fool, Whether he rage or laugh, there will be no rest. ");
INSERT INTO engnoy_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","The bloodthirsty man hateth the upright; But the righteous seek to preserve his life. ");
INSERT INTO engnoy_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","A fool letteth all his anger come out; But a wise man keepeth it back. ");
INSERT INTO engnoy_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","If a ruler listen to words of falsehood, All his servants become wicked. ");
INSERT INTO engnoy_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","The poor man and the oppressor meet together: The LORD giveth light to the eyes of them both. ");
INSERT INTO engnoy_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","The king that judgeth the poor with uprightness, His throne shall be established for ever. ");
INSERT INTO engnoy_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","The rod and reproof give wisdom; But a child left to himself bringeth shame to his mother. ");
INSERT INTO engnoy_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","When the wicked are powerful, transgression increaseth; But the righteous shall see their fall. ");
INSERT INTO engnoy_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Chastise thy son, and he will give thee rest; Yea, he will give delight to thy soul. ");
INSERT INTO engnoy_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Where there is no vision, the people become unruly; But he that keepeth the law, happy is he. ");
INSERT INTO engnoy_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","A servant will not be corrected by words; For, though he understand, he will not obey. ");
INSERT INTO engnoy_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Seest thou a man hasty in his words? There is more hope of a fool than of him. ");
INSERT INTO engnoy_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","He that bringeth up his servant delicately from childhood Shall have him become a son at the last. ");
INSERT INTO engnoy_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","An angry man stirreth up strife, And a passionate man aboundeth in transgression. ");
INSERT INTO engnoy_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","A man's pride will bring him low; But he that is of a humble spirit shall obtain honor. ");
INSERT INTO engnoy_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","He who shareth with a thief hateth himself: He heareth the curse, but maketh no discovery. ");
INSERT INTO engnoy_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","The fear of man bringeth a snare; But whoso putteth his trust in the LORD shall be safe. ");
INSERT INTO engnoy_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Many are they who seek the ruler's favor; But every man's judgment cometh from the LORD. ");
INSERT INTO engnoy_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","As the unjust man is an abomination to the righteous, So the upright in his way is an abomination to the wicked. ");
INSERT INTO engnoy_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","The words of Agur, the son of Jakeh, even his prophecy; the inspired utterance of the man to Ithiel, even to Ithiel and Ucal. ");
INSERT INTO engnoy_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Truly I am more stupid than any man; There is not in me the understanding of a man. ");
INSERT INTO engnoy_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","I have not learned wisdom, Nor have I gained the knowledge of the Most Holy. ");
INSERT INTO engnoy_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Who hath gone up into heaven and come down? Who hath gathered the wind in his fists? Who hath bound up the waters in a garment? Who hath established all the ends of the earth? What is his name, and what his son's name, if thou knowest? ");
INSERT INTO engnoy_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Every word of God is pure; A shield is he to them that put their trust in him. ");
INSERT INTO engnoy_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Add not to his words, Lest he rebuke thee, and thou be found a liar. ");
INSERT INTO engnoy_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Two things do I ask of thee; Withhold them not from me, before I die! ");
INSERT INTO engnoy_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Remove far from me falsehood and lies; Give me neither poverty nor riches; Feed me with the food which is needful for me; ");
INSERT INTO engnoy_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Lest I be full, and deny thee, And say, “Who is the LORD?” Or lest I be poor, and steal, And violate the name of my God. ");
INSERT INTO engnoy_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Talk not against a servant to his master, Lest he curse thee, and thou suffer for it. ");
INSERT INTO engnoy_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","There is a class of men that curse their fathers, And do not bless their mothers. ");
INSERT INTO engnoy_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","There is a class who are pure in their own eyes, And yet are not washed from their filthiness. ");
INSERT INTO engnoy_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","There is a class,—O how lofty are their eyes, And how are their eyelids lifted up! ");
INSERT INTO engnoy_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","There is a class, whose teeth are swords, And their jaw-teeth knives, To devour the poor from off the earth, And the needy from among men. ");
INSERT INTO engnoy_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","The vampire hath two daughters; “Give! give!” is their cry. There are three things which are never satisfied; Yea, four which say not, “Enough!” ");
INSERT INTO engnoy_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","The underworld, and the barren womb; The earth, which is not satiated with water, And fire, which never saith, “It is enough!” ");
INSERT INTO engnoy_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","The eye that mocketh at a father, And scorneth to obey a mother, The ravens of the valley shall pick it out, And the young eagles shall eat it. ");
INSERT INTO engnoy_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","These three things are too wonderful for me; Yea, there are four which I understand not: ");
INSERT INTO engnoy_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","The track of an eagle in the air, The track of a serpent upon a rock, The track of a ship in the midst of the sea, And the track of a man with a maid. ");
INSERT INTO engnoy_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Such is the way of an adulterous woman; She eateth, and wipeth her mouth, And saith, “I have done nothing wrong.” ");
INSERT INTO engnoy_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Under three things is the earth disquieted; Yea, under four it cannot bear up: ");
INSERT INTO engnoy_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Under a servant when he becometh a king, And a fool when he is filled with bread; ");
INSERT INTO engnoy_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","Under an odious woman when she becometh a wife, And a handmaid when she becometh heir to her mistress. ");
INSERT INTO engnoy_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","There are four things which are small upon the earth, Yet are they wise, instructed in wisdom. ");
INSERT INTO engnoy_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","The ants are a people not strong, Yet they prepare in the summer their food. ");
INSERT INTO engnoy_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","The conies are a feeble people, Yet do they make their houses in the rocks. ");
INSERT INTO engnoy_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","The locusts have no king, Yet do they all go forth in bands. ");
INSERT INTO engnoy_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","The lizard seizeth with its hands, And is in king's palaces. ");
INSERT INTO engnoy_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","These three have a graceful step; Yea, four are graceful in their walk: ");
INSERT INTO engnoy_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","The lion, the hero among beasts, Which turneth not back for any; ");
INSERT INTO engnoy_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","The loin-girded war-horse, the he-goat, And a king who cannot be withstood. ");
INSERT INTO engnoy_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","If thou hast been foolish in lifting thyself up, And hast meditated evil, Put thy hand on thy mouth! ");
INSERT INTO engnoy_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","For, as the pressing of milk bringeth forth cheese, And as the pressing of the nose bringeth forth blood, So the pressing of anger bringeth forth strife. ");
INSERT INTO engnoy_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","The words given to King Lemuel; the prophecy which his mother taught him. ");
INSERT INTO engnoy_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","What, O my son! and what, O son of my womb! Yea, what, O son of my vows! shall I say to thee? ");
INSERT INTO engnoy_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Give not thy strength to women, Nor thy ways to that which destroyeth kings! ");
INSERT INTO engnoy_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","It is not for kings, O Lemuel! It is not for kings to drink wine, Nor for princes to desire strong drink; ");
INSERT INTO engnoy_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Lest they drink, and forget the law, And pervert the rights of any of the afflicted. ");
INSERT INTO engnoy_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Give strong drink to him who is ready to perish, And wine to him that hath a heavy heart; ");
INSERT INTO engnoy_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Let him drink and forget his poverty, And remember his misery no more! ");
INSERT INTO engnoy_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Open thy mouth for the dumb, In the cause of every orphan! ");
INSERT INTO engnoy_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Open thy mouth, judge righteously, And maintain the cause of the poor and needy! ");
INSERT INTO engnoy_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Who can find a capable woman? Her worth is far above pearls. ");
INSERT INTO engnoy_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","The heart of her husband trusteth in her, And he is in no want of gain. ");
INSERT INTO engnoy_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","She doeth him good, and not evil, All the days of her life. ");
INSERT INTO engnoy_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","She seeketh wool and flax, And worketh willingly with her hands. ");
INSERT INTO engnoy_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","She is like the merchants' ships; She bringeth her food from afar. ");
INSERT INTO engnoy_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","She riseth while it is yet night, And giveth food to her family, And a task to her maidens. ");
INSERT INTO engnoy_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","She layeth a plan for a field, and buyeth it; With the fruit of her hands she planteth a vineyard. ");
INSERT INTO engnoy_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","She girdeth her loins with strength, And maketh strong her arms. ");
INSERT INTO engnoy_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","She perceiveth how pleasant is her gain, And her lamp is not extinguished in the night. ");
INSERT INTO engnoy_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","She putteth forth her hands to the distaff, And her hands take hold of the spindle. ");
INSERT INTO engnoy_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","She spreadeth out her hand to the poor, Yea, she reacheth forth her hands to the needy. ");
INSERT INTO engnoy_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","She hath no fear for her household on account of the snow, For all her household are clothed with crimson. ");
INSERT INTO engnoy_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","She maketh for herself coverlets; Her clothing is of fine linen and purple. ");
INSERT INTO engnoy_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Her husband is known in the gates, When he sitteth with the elders of the land. ");
INSERT INTO engnoy_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","She maketh linen garments and selleth them, And delivereth girdles to the merchant. ");
INSERT INTO engnoy_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Strength and honor are her clothing; And she laugheth at the days to come. ");
INSERT INTO engnoy_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","She openeth her mouth with wisdom, And kind instruction is upon her tongue. ");
INSERT INTO engnoy_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","She looketh well to the ways of her household, And eateth not the bread of idleness. ");
INSERT INTO engnoy_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Her children rise up, and extol her; Her husband, and praiseth her, saving, ");
INSERT INTO engnoy_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","“Many daughters have done, virtuously, But thou excellest them all.” ");
INSERT INTO engnoy_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Grace is deceitful, and beauty vain; But the woman that feareth the LORD, she shall be praised. ");
INSERT INTO engnoy_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Give ye her of the fruit of her hands, And let her works praise her in the gates. ");
INSERT INTO engnoy_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","The words of the Preacher, the son of David, king in Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Vanity of vanities, saith the Preacher, vanity of vanities, all is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","What profit hath a man by all his labor with which he wearieth himself under the sun? ");
INSERT INTO engnoy_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","One generation passeth away, and another generation cometh; while the earth abideth for ever. ");
INSERT INTO engnoy_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","The sun riseth, and the sun goeth down, and hasteneth to the place whence it arose. ");
INSERT INTO engnoy_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","The wind goeth toward the south, and turneth about to the north; round and round goeth the wind, and returneth to its circuits. ");
INSERT INTO engnoy_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","All the rivers run into the sea, yet the sea is not full; to the place whence the rivers come, thither they return. ");
INSERT INTO engnoy_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","All words become weary; man cannot express it; the eye is not satisfied with seeing, nor the ear filled with hearing. ");
INSERT INTO engnoy_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","The thing that hath been is that which shall be, and that which hath been done is that which shall be done; and there is no new thing under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","Is there any thing of which one may say, “Behold, this is new”? It was long ago, in the times which were before us. ");
INSERT INTO engnoy_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","There is no remembrance of former things, and of things that are to come there shall be no remembrance to those who live afterwards. ");
INSERT INTO engnoy_vpl VALUES ("EC1_12","022_1_12","ECC","1","12","12","I, the Preacher, was king over Israel at Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("EC1_13","022_1_13","ECC","1","13","13","And I gave my mind to seek and to search out with wisdom concerning all things which are done under heaven; an evil business, which God hath given to the sons of men, in which to employ themselves. ");
INSERT INTO engnoy_vpl VALUES ("EC1_14","022_1_14","ECC","1","14","14","I saw all the things which are done under the sun; and, behold, it was all vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC1_15","022_1_15","ECC","1","15","15","That which is crooked cannot be made straight, and that which is wanting cannot be numbered. ");
INSERT INTO engnoy_vpl VALUES ("EC1_16","022_1_16","ECC","1","16","16","I communed with my heart, saying, “Behold, I have gained more and greater wisdom than all who have been before me at Jerusalem; yea, my mind hath seen much wisdom and knowledge.” ");
INSERT INTO engnoy_vpl VALUES ("EC1_17","022_1_17","ECC","1","17","17","And I gave my mind to know wisdom, and to know senselessness and folly; I perceived that this also is striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC1_18","022_1_18","ECC","1","18","18","For in much wisdom is much vexation, and he that increaseth knowledge increaseth sorrow. ");
INSERT INTO engnoy_vpl VALUES ("EC2_1","022_2_1","ECC","2","1","1","I said in my heart, “Come, now, I will try thee with mirth; therefore enjoy pleasure!” But, lo! this also was vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC2_2","022_2_2","ECC","2","2","2","I said of laughter, “It is mad;” and of mirth, “What availeth it?” ");
INSERT INTO engnoy_vpl VALUES ("EC2_3","022_2_3","ECC","2","3","3","I thought in my heart to strengthen my body with wine, and, while my heart cleaved to wisdom, to lay hold on folly, till I should see what was good for the sons of men, which they should do under heaven all the days of their life. ");
INSERT INTO engnoy_vpl VALUES ("EC2_4","022_2_4","ECC","2","4","4","I made me great works. I builded me houses; I planted me vineyards. ");
INSERT INTO engnoy_vpl VALUES ("EC2_5","022_2_5","ECC","2","5","5","I made me gardens and parks, and planted in them fruit-trees of every kind. ");
INSERT INTO engnoy_vpl VALUES ("EC2_6","022_2_6","ECC","2","6","6","I made me pools of water, with which to water the grove shooting up trees. ");
INSERT INTO engnoy_vpl VALUES ("EC2_7","022_2_7","ECC","2","7","7","I got me men-servants and maid-servants, and had servants born in my house. I had also great possessions of herds and flocks, more than all who were in Jerusalem before me. ");
INSERT INTO engnoy_vpl VALUES ("EC2_8","022_2_8","ECC","2","8","8","I heaped me up also silver and gold, and the wealth of kings and of provinces. I got me men-singers and women-singers, and the delight of the sons of men, a chosen woman and chosen women. ");
INSERT INTO engnoy_vpl VALUES ("EC2_9","022_2_9","ECC","2","9","9","So I became greater than all that were before me in Jerusalem. My wisdom also remained with me. ");
INSERT INTO engnoy_vpl VALUES ("EC2_10","022_2_10","ECC","2","10","10","And whatever mine eyes desired I kept not from them; I withheld not my heart from any joy. For my heart rejoiced by means of all my labor, and this was my portion from all my labor. ");
INSERT INTO engnoy_vpl VALUES ("EC2_11","022_2_11","ECC","2","11","11","Then I looked upon all the works which my hands had wrought, and upon all the labor which I had toiled in performing; and, behold, it was all vanity, and striving after wind, and there was no profit under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC2_12","022_2_12","ECC","2","12","12","Then I turned myself to behold wisdom and senselessness and folly. For what can the man do that cometh after the king? even that which hath been already done. ");
INSERT INTO engnoy_vpl VALUES ("EC2_13","022_2_13","ECC","2","13","13","I saw, indeed, that wisdom excelleth folly, as far as light excelleth darkness. ");
INSERT INTO engnoy_vpl VALUES ("EC2_14","022_2_14","ECC","2","14","14","The wise man's eyes are in his head, but the fool walketh in darkness; yet I perceived also that one event happeneth to them all. ");
INSERT INTO engnoy_vpl VALUES ("EC2_15","022_2_15","ECC","2","15","15","Then I said in my heart, “As it happeneth to the fool, so it happeneth to me. Why, then, became I wiser than others?” Then I said in my heart, “This also is vanity.” ");
INSERT INTO engnoy_vpl VALUES ("EC2_16","022_2_16","ECC","2","16","16","For there is no remembrance of the wise man more than of the fool for ever; for in the days to come shall all have long been forgotten; and, alas! the wise man dieth, as well as the fool. ");
INSERT INTO engnoy_vpl VALUES ("EC2_17","022_2_17","ECC","2","17","17","Therefore I hated life, because what is done under the sun appeared evil to me. For all is vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC2_18","022_2_18","ECC","2","18","18","Yea, I hated all my labor which I had performed under the sun, because I must leave it to the man that shall be after me. ");
INSERT INTO engnoy_vpl VALUES ("EC2_19","022_2_19","ECC","2","19","19","And who knoweth whether he shall be a wise man or a fool? Yet shall he be lord of all the labor with which I have wearied myself, and in which I have shown myself wise under the sun. This also is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC2_20","022_2_20","ECC","2","20","20","Therefore I turned to give up my heart to despair in regard to all the labor with which I had wearied myself under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC2_21","022_2_21","ECC","2","21","21","For there is a man whose labor has been with wisdom and knowledge and skill; yet to a man who hath not labored for it must he leave it as his portion. This also is vanity and a great evil. ");
INSERT INTO engnoy_vpl VALUES ("EC2_22","022_2_22","ECC","2","22","22","For what hath man of all his labor, and the striving of his spirit, with which he wearieth himself under the sun? ");
INSERT INTO engnoy_vpl VALUES ("EC2_23","022_2_23","ECC","2","23","23","For all his days are grief, and his occupation trouble; even in the night his heart taketh no rest. This also is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC2_24","022_2_24","ECC","2","24","24","There is nothing better for a man than to eat and drink, and let his soul enjoy good in his labor. But this, as I have seen, cometh from the hand of God. ");
INSERT INTO engnoy_vpl VALUES ("EC2_25","022_2_25","ECC","2","25","25","For who can eat, or hasten thereunto more than I? ");
INSERT INTO engnoy_vpl VALUES ("EC2_26","022_2_26","ECC","2","26","26","For to a man who is good in his sight God giveth wisdom and knowledge and joy; but to the sinner he giveth the wearisome business of gathering and heaping up, to give it to him who is good before God. This also is vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","For every thing there is a fixed period, and an appointed time to every thing under heaven:— ");
INSERT INTO engnoy_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","A time to be born, and a time to die. A time to plant, and a time to pluck up what is planted. ");
INSERT INTO engnoy_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","A time to kill, and a time to heal. A time to breaking down, and a time to build up. ");
INSERT INTO engnoy_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","A time to weep, and a time to laugh. A time to mourn, and a time to dance. ");
INSERT INTO engnoy_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","A time to cast stones asunder, and a time to gather stones together. A time to embrace, and a time to refrain from embracing. ");
INSERT INTO engnoy_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","A time to seek, and a time to lose. A time to keep, and a time to cast away. ");
INSERT INTO engnoy_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","A time to rend, and a time to sew. A time to keep silence, and a time to speak. ");
INSERT INTO engnoy_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","A time to love, and a time to hate. A time of war, and a time of peace.— ");
INSERT INTO engnoy_vpl VALUES ("EC3_9","022_3_9","ECC","3","9","9","What profit hath he who laboreth from that with which he wearieth himself? ");
INSERT INTO engnoy_vpl VALUES ("EC3_10","022_3_10","ECC","3","10","10","I have seen the business which God hath given to the sons of men to exercise themselves therewith. ");
INSERT INTO engnoy_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","God maketh every thing good in its time; but he hath put the world into the heart of man, so that he understandeth not the work which God doeth, from the beginning to the end. ");
INSERT INTO engnoy_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","I know that there is nothing better for a man than that he should rejoice and enjoy good his life long. ");
INSERT INTO engnoy_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","But when a man eateth and drinketh, and enjoyeth good through all his labor, this is the gift of God. ");
INSERT INTO engnoy_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","I know that whatever God doeth, that shall be for ever. Nothing can be added to it, and nothing taken from it; and God doeth it that men may fear before him. ");
INSERT INTO engnoy_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","That which is, was long ago; and that which is to be, hath already been; and God recalleth that which is past. ");
INSERT INTO engnoy_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","Moreover, I saw under the sun that in the place of justice there was iniquity; and in the place of righteousness, iniquity. ");
INSERT INTO engnoy_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","Then said I in my heart, “God will judge the righteous and the wicked.” For there shall be a time for every matter and for every work. ");
INSERT INTO engnoy_vpl VALUES ("EC3_18","022_3_18","ECC","3","18","18","I said in my heart concerning the sons of men, that God will prove them, in order that they may see that they are like the beasts. ");
INSERT INTO engnoy_vpl VALUES ("EC3_19","022_3_19","ECC","3","19","19","For that which befalleth the sons of men befalleth beasts: one lot befalleth both. As the one dieth, so dieth the other. Yea, there is one spirit in them, and a man hath no pre-eminence above a beast; for all is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC3_20","022_3_20","ECC","3","20","20","All go to one place; all are from the dust, and all turn to dust again. ");
INSERT INTO engnoy_vpl VALUES ("EC3_21","022_3_21","ECC","3","21","21","Who knoweth the spirit of man, whether it goeth upward, and the spirit of a beast, whether it goeth downward to the earth? ");
INSERT INTO engnoy_vpl VALUES ("EC3_22","022_3_22","ECC","3","22","22","And so I saw that there is nothing better than that a man should rejoice in his labors; for that is his portion. For who shall bring him to see what shall be after him? ");
INSERT INTO engnoy_vpl VALUES ("EC4_1","022_4_1","ECC","4","1","1","Then I turned and saw all the oppressions which take place under the sun; and, behold, there were the tears of the oppressed, and they had no comforter; and from the hand of their oppressors there was violence, and they had no comforter. ");
INSERT INTO engnoy_vpl VALUES ("EC4_2","022_4_2","ECC","4","2","2","Therefore I praised the dead, who have been long ago dead, more than the living, who are yet alive. ");
INSERT INTO engnoy_vpl VALUES ("EC4_3","022_4_3","ECC","4","3","3","Yea, better than both of them is he who hath not yet been, who hath not seen the evil work which is done under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC4_4","022_4_4","ECC","4","4","4","And I saw all labor, and all success in work, that for this a man is envied by his neighbor. This also is vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC4_5","022_4_5","ECC","4","5","5","The fool foldeth his hands together and eateth his own flesh. ");
INSERT INTO engnoy_vpl VALUES ("EC4_6","022_4_6","ECC","4","6","6","Better is a hand full of quietness, than both hands full of weariness and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC4_7","022_4_7","ECC","4","7","7","Then I turned and saw other vanity under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC4_8","022_4_8","ECC","4","8","8","There is one who is alone, and no one with him; yea, he hath neither son nor brother; yet is there no end to all his labor, and his eye is not satisfied with riches. “For whom, then saith he, do I labor and deprive myself of good?” This also is vanity; yea, it is an evil thing! ");
INSERT INTO engnoy_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Two are better than one, because they have a good reward for their labor. ");
INSERT INTO engnoy_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","For if they fall, the one will lift his fellow up; but woe to him who is alone when he falleth, and hath not another to help him up! ");
INSERT INTO engnoy_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Again, if two lie together, then they have heat; but how can one be warm alone? ");
INSERT INTO engnoy_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","And if an enemy prevail against one, two shall withstand him; and a threefold cord is not quickly broken. ");
INSERT INTO engnoy_vpl VALUES ("EC4_13","022_4_13","ECC","4","13","13","Better is a child poor but wise, than a king old and foolish, who will no more be admonished. ");
INSERT INTO engnoy_vpl VALUES ("EC4_14","022_4_14","ECC","4","14","14","For out of prison cometh forth such a one to reign; for in his own kingdom he was born a poor man. ");
INSERT INTO engnoy_vpl VALUES ("EC4_15","022_4_15","ECC","4","15","15","I saw that all the living, who walk under the sun, were with the child who stood up in his stead. ");
INSERT INTO engnoy_vpl VALUES ("EC4_16","022_4_16","ECC","4","16","16","There was no end to all the people before whom he went forth; yet they that come afterwards shall not rejoice in him. This also is vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC5_1","022_5_1","ECC","5","1","1","Look well to thy feet, when thou goest to the house of God, and draw nigh to hear, rather than to offer sacrifice as fools. For they consider not that they do evil. ");
INSERT INTO engnoy_vpl VALUES ("EC5_2","022_5_2","ECC","5","2","2","Be not hasty with thy mouth, and let not thy heart be swift to utter any thing before God. For God is in heaven, and thou upon earth. Therefore let thy words be few. ");
INSERT INTO engnoy_vpl VALUES ("EC5_3","022_5_3","ECC","5","3","3","For a dream cometh with much bustle, and a fool's voice with a multitude of words. ");
INSERT INTO engnoy_vpl VALUES ("EC5_4","022_5_4","ECC","5","4","4","When thou vowest a vow to God, delay not to pay it; for he hath no pleasure in fools. Pay that which thou hast vowed. ");
INSERT INTO engnoy_vpl VALUES ("EC5_5","022_5_5","ECC","5","5","5","Better is it that thou shouldst not vow than that thou shouldst vow and not pay. ");
INSERT INTO engnoy_vpl VALUES ("EC5_6","022_5_6","ECC","5","6","6","Suffer not thy mouth to bring punishment on thy flesh, and say not before the angel, “It was a mistake.” Wherefore should God be angry on account of thy voice, and destroy the work of thy hands? ");
INSERT INTO engnoy_vpl VALUES ("EC5_7","022_5_7","ECC","5","7","7","For in a multitude of dreams is a multitude of vanities; so also in a multitude of words; but fear thou God! ");
INSERT INTO engnoy_vpl VALUES ("EC5_8","022_5_8","ECC","5","8","8","If thou seest oppression of the poor, and justice and equity perverted in a province, be not alarmed at the matter. For over the high there is a higher, who watcheth, and there is one higher than they all. ");
INSERT INTO engnoy_vpl VALUES ("EC5_9","022_5_9","ECC","5","9","9","An advantage to a land in all respects is a king over cultivated ground. ");
INSERT INTO engnoy_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","He that loveth silver shall not be satisfied with silver; and he that loveth riches shall have no profit from them. This also is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","When goods increase, they are increased that eat them; and what advantage hath the owner thereof, save the beholding of them with his eyes? ");
INSERT INTO engnoy_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Sweet is the sleep of a laboring man, whether he have eaten little or much; but the repletion of the rich will not suffer him to sleep. ");
INSERT INTO engnoy_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","There is a sore evil which I have seen under the sun, — riches kept by the owner thereof to his hurt. ");
INSERT INTO engnoy_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","For those riches perish by some calamity, and, if he have a son, there is nothing in his hand. ");
INSERT INTO engnoy_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","As he came forth from his mother's womb naked, so shall he go away again, as he came, and shall take away nothing of his labor which he may carry in his hand. ");
INSERT INTO engnoy_vpl VALUES ("EC5_16","022_5_16","ECC","5","16","16","This is also a sore evil, that, in all points as he came, so shall he go. And what profit is there to him who toileth for wind? ");
INSERT INTO engnoy_vpl VALUES ("EC5_17","022_5_17","ECC","5","17","17","Also all his days he ate in darkness, and had much grief and anxiety and vexation. ");
INSERT INTO engnoy_vpl VALUES ("EC5_18","022_5_18","ECC","5","18","18","Behold, what I have seen is, that it is good and proper for one to eat and drink, and to enjoy the good of all his labor which he taketh under the sun all the days of his life, which God giveth him; for it is his portion. ");
INSERT INTO engnoy_vpl VALUES ("EC5_19","022_5_19","ECC","5","19","19","To whatever man also God hath given riches and wealth, and hath given him to enjoy them, and to take his portion, and to rejoice in his labor; this is the gift of God. ");
INSERT INTO engnoy_vpl VALUES ("EC5_20","022_5_20","ECC","5","20","20","For he will not much remember the days of his life; for God answereth him with the joy of his heart. ");
INSERT INTO engnoy_vpl VALUES ("EC6_1","022_6_1","ECC","6","1","1","There is an evil which I have seen under the sun, and it lieth heavy upon men; ");
INSERT INTO engnoy_vpl VALUES ("EC6_2","022_6_2","ECC","6","2","2","a man to whom God hath given riches, wealth, and honor, and nothing is wanting to him of all which he desireth, yet God giveth him not to taste thereof; but a stranger enjoyeth it. This is vanity, yea, a grievous evil. ");
INSERT INTO engnoy_vpl VALUES ("EC6_3","022_6_3","ECC","6","3","3","Though a man have a hundred children, and live many years, and though the days of his years be many, if his soul be not satisfied with good, and he have no burial, I say that an untimely birth is better than he. ");
INSERT INTO engnoy_vpl VALUES ("EC6_4","022_6_4","ECC","6","4","4","This, indeed, cometh in nothingness, and goeth down into darkness, and its name is covered with darkness; ");
INSERT INTO engnoy_vpl VALUES ("EC6_5","022_6_5","ECC","6","5","5","it hath not seen the sun, nor known it; yet hath it rest rather than the other. ");
INSERT INTO engnoy_vpl VALUES ("EC6_6","022_6_6","ECC","6","6","6","Yea, though he live a thousand years twice told, and see no good, — do not all go to one place? ");
INSERT INTO engnoy_vpl VALUES ("EC6_7","022_6_7","ECC","6","7","7","All the labor of man is for his mouth, and yet his desires are not satisfied. ");
INSERT INTO engnoy_vpl VALUES ("EC6_8","022_6_8","ECC","6","8","8","For what advantage hath the wise man over the fool? What advantage hath the poor, who knoweth how to walk before the living? ");
INSERT INTO engnoy_vpl VALUES ("EC6_9","022_6_9","ECC","6","9","9","Better is the sight of the eyes than the wandering of the desire. This also is vanity, and striving after wind. ");
INSERT INTO engnoy_vpl VALUES ("EC6_10","022_6_10","ECC","6","10","10","That which is was long ago called by name; and it was known that he is a man, and that he cannot contend with Him who is mightier than he. ");
INSERT INTO engnoy_vpl VALUES ("EC6_11","022_6_11","ECC","6","11","11","Seeing there are many things which increase vanity, what advantage hath man from them? ");
INSERT INTO engnoy_vpl VALUES ("EC6_12","022_6_12","ECC","6","12","12","For who knoweth what is good for man in life, in all the days of his vain life, which he spendeth as a shadow? For who can tell a man what shall be after him under the sun? ");
INSERT INTO engnoy_vpl VALUES ("EC7_1","022_7_1","ECC","7","1","1","A good name is better than precious perfume, and the day of one's death than the day of his birth. ");
INSERT INTO engnoy_vpl VALUES ("EC7_2","022_7_2","ECC","7","2","2","It is better to go to the house of mourning than to go to the house of feasting; for that is the end of all men; and the living will lay it to heart. ");
INSERT INTO engnoy_vpl VALUES ("EC7_3","022_7_3","ECC","7","3","3","Sorrow is better than laughter; for by the sadness of the countenance the heart is made better. ");
INSERT INTO engnoy_vpl VALUES ("EC7_4","022_7_4","ECC","7","4","4","The heart of the wise is in the house of mourning; but the heart of fools is in the house of mirth. ");
INSERT INTO engnoy_vpl VALUES ("EC7_5","022_7_5","ECC","7","5","5","It is better for a man to hear the rebuke of the wise than to hear the song of fools. ");
INSERT INTO engnoy_vpl VALUES ("EC7_6","022_7_6","ECC","7","6","6","For as the crackling of thorns under a pot, so is the laughter of a fool. This also is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC7_7","022_7_7","ECC","7","7","7","Surely the gain of oppression maketh a wise man foolish, and a gift corrupteth the understanding. ");
INSERT INTO engnoy_vpl VALUES ("EC7_8","022_7_8","ECC","7","8","8","Better is the end of a thing than its beginning. Better is the patient in spirit than the proud in spirit. ");
INSERT INTO engnoy_vpl VALUES ("EC7_9","022_7_9","ECC","7","9","9","Be not hasty in thy spirit to be angry; for anger resteth in the bosom of fools. ");
INSERT INTO engnoy_vpl VALUES ("EC7_10","022_7_10","ECC","7","10","10","Say not, “What is the cause that the former days were better than these?” For thou dost not inquire wisely concerning this. ");
INSERT INTO engnoy_vpl VALUES ("EC7_11","022_7_11","ECC","7","11","11","Wisdom is as good as an estate? yea, it hath an advantage over it for them that see the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC7_12","022_7_12","ECC","7","12","12","For wisdom is a defence, and money is a defence. But knowledge hath the advantage. For wisdom giveth life to them that have it. ");
INSERT INTO engnoy_vpl VALUES ("EC7_13","022_7_13","ECC","7","13","13","Consider the work of God! Who can make straight that which he hath made crooked? ");
INSERT INTO engnoy_vpl VALUES ("EC7_14","022_7_14","ECC","7","14","14","In the day of prosperity be joyful; but look for a day of adversity! for this also, as well as the other, hath God appointed, to the end that a man should not find out any thing which shall be after him. ");
INSERT INTO engnoy_vpl VALUES ("EC7_15","022_7_15","ECC","7","15","15","All this have I seen in my days of vanity. There are righteous men who perish in their righteousness, and there are wicked men who live long in their wickedness. ");
INSERT INTO engnoy_vpl VALUES ("EC7_16","022_7_16","ECC","7","16","16","Be not righteous overmuch; neither make thyself over-wise! Why shouldest thou destroy thyself? ");
INSERT INTO engnoy_vpl VALUES ("EC7_17","022_7_17","ECC","7","17","17","Be not overmuch wicked; neither be thou a fool! Why shouldst thou die before thy time? ");
INSERT INTO engnoy_vpl VALUES ("EC7_18","022_7_18","ECC","7","18","18","It is good that thou shouldst take hold of this; yea, also, from that withdraw not thy hand. For he that feareth God shall escape all those things. ");
INSERT INTO engnoy_vpl VALUES ("EC7_19","022_7_19","ECC","7","19","19","Wisdom strengtheneth the wise more than ten mighty men who are in the city. ");
INSERT INTO engnoy_vpl VALUES ("EC7_20","022_7_20","ECC","7","20","20","Truly there is not a righteous man upon the earth who doeth good and sinneth not. ");
INSERT INTO engnoy_vpl VALUES ("EC7_21","022_7_21","ECC","7","21","21","Give no heed to all the words which are spoken, lest thou hear thy servant curse thee! ");
INSERT INTO engnoy_vpl VALUES ("EC7_22","022_7_22","ECC","7","22","22","For many times thine own heart knoweth also that even thou thyself hast cursed others. ");
INSERT INTO engnoy_vpl VALUES ("EC7_23","022_7_23","ECC","7","23","23","All this have I tried by wisdom. I said, “I will be wise;” but it was far from me. ");
INSERT INTO engnoy_vpl VALUES ("EC7_24","022_7_24","ECC","7","24","24","That which is far off and exceeding deep, who can find it out? ");
INSERT INTO engnoy_vpl VALUES ("EC7_25","022_7_25","ECC","7","25","25","I applied my mind earnestly to know, and to search, and to seek out wisdom and intelligence, and to know wickedness and folly, yea, foolishness and madness. ");
INSERT INTO engnoy_vpl VALUES ("EC7_26","022_7_26","ECC","7","26","26","And I found more bitter than death the woman whose heart is snares and nets, and her hands bands. He that pleaseth God shall escape from her; but the sinner shall be caught by her. ");
INSERT INTO engnoy_vpl VALUES ("EC7_27","022_7_27","ECC","7","27","27","Behold, this have I found, saith the Preacher, putting one thing to another to find knowledge. ");
INSERT INTO engnoy_vpl VALUES ("EC7_28","022_7_28","ECC","7","28","28","That which my soul hath hitherto sought, and I have not found, is this: a man among a thousand I have found, but a woman among a thousand have I not found. ");
INSERT INTO engnoy_vpl VALUES ("EC7_29","022_7_29","ECC","7","29","29","Lo, this only have I found, that God made man upright, but they have sought out many devices. ");
INSERT INTO engnoy_vpl VALUES ("EC8_1","022_8_1","ECC","8","1","1","Who is like the wise man, and who knoweth the explanation of a thing? A man's wisdom brighteneth his countenance, and the harshness of his face is changed. ");
INSERT INTO engnoy_vpl VALUES ("EC8_2","022_8_2","ECC","8","2","2","I counsel thee to keep the king's commandment, and that on account of the oath of God. ");
INSERT INTO engnoy_vpl VALUES ("EC8_3","022_8_3","ECC","8","3","3","Be not in haste to depart from his presence; persist not in an evil thing; for whatever pleaseth him, that he doeth. ");
INSERT INTO engnoy_vpl VALUES ("EC8_4","022_8_4","ECC","8","4","4","For the word of the king is powerful; and who can say to him, “What doest thou?” ");
INSERT INTO engnoy_vpl VALUES ("EC8_5","022_8_5","ECC","8","5","5","He that keepeth the commandment shall experience no evil; and the heart of the wise man hath regard to time and judgment. ");
INSERT INTO engnoy_vpl VALUES ("EC8_6","022_8_6","ECC","8","6","6","For to every thing there is a time and judgment. For the misery of man is great upon him. ");
INSERT INTO engnoy_vpl VALUES ("EC8_7","022_8_7","ECC","8","7","7","For no one knoweth what shall be; for who can tell him how it shall be? ");
INSERT INTO engnoy_vpl VALUES ("EC8_8","022_8_8","ECC","8","8","8","No man hath power over the spirit to retain the spirit, and no man hath power over the day of death; and there is no discharge in that war; and wickedness shall not deliver those that are guilty of it. ");
INSERT INTO engnoy_vpl VALUES ("EC8_9","022_8_9","ECC","8","9","9","All this have I seen, and I have given heed to all things that are done under the sun. There is a time when man ruleth over man to his hurt. ");
INSERT INTO engnoy_vpl VALUES ("EC8_10","022_8_10","ECC","8","10","10","And so I saw the wicked buried, while the righteous came and went from the holy place, and were forgotten in the city. This also is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC8_11","022_8_11","ECC","8","11","11","Because sentence against an evil work is not executed speedily, therefore doth the heart of the sons of men become bold within them to do evil. ");
INSERT INTO engnoy_vpl VALUES ("EC8_12","022_8_12","ECC","8","12","12","But though a sinner do evil a hundred times, and have his days prolonged, yet surely I know that it shall be well with them that fear God, that fear before him. ");
INSERT INTO engnoy_vpl VALUES ("EC8_13","022_8_13","ECC","8","13","13","But it shall not be well with the wicked: he shall be like a shadow, and shall not prolong his days, because he feareth not before God. ");
INSERT INTO engnoy_vpl VALUES ("EC8_14","022_8_14","ECC","8","14","14","There is a vanity which taketh place upon the earth, that there are righteous men to whom it happeneth according to the work of the wicked, and that there are wicked men to whom it happeneth according to the work of the righteous. I said, “This also is vanity!” ");
INSERT INTO engnoy_vpl VALUES ("EC8_15","022_8_15","ECC","8","15","15","Then I commended joy; because nothing is good for a man under the sun, except to eat and to drink and to be joyful; for it is this that abideth with him for his labor during the days of his life which God giveth him under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC8_16","022_8_16","ECC","8","16","16","When I applied my mind to know wisdom, and to see the business which is done upon the earth,—that one seeth no sleep with his eyes by day or by night,— ");
INSERT INTO engnoy_vpl VALUES ("EC8_17","022_8_17","ECC","8","17","17","then I saw the whole work of God, that a man cannot comprehend that which is done under the sun; how much soever he labor to search it out, yet shall he not comprehend it; yea, though a wise man resolve to know it, yet shall he not be able to comprehend it. ");
INSERT INTO engnoy_vpl VALUES ("EC9_1","022_9_1","ECC","9","1","1","For I gave my mind to all this, even to search out all this, that the righteous and the wise and their works are in the hand of God, and yet neither his love nor hatred doth any man know. All is before them. ");
INSERT INTO engnoy_vpl VALUES ("EC9_2","022_9_2","ECC","9","2","2","All cometh to them as to all. There is one event to the righteous and to the wicked; to the good, to the clean, and to the unclean; to him that sacrificeth, and to him that sacrificeth not; as is the good, so is the sinner; he that sweareth, as he that feareth an oath. ");
INSERT INTO engnoy_vpl VALUES ("EC9_3","022_9_3","ECC","9","3","3","This is an evil among all things which take place under the sun, that there is one event to all; therefore also the heart of the sons of men is full of evil, and madness is in their heart while they live, and afterward they go down to the dead. ");
INSERT INTO engnoy_vpl VALUES ("EC9_4","022_9_4","ECC","9","4","4","For who is there that is excepted? With all the living there is hope; for a living dog is better than a dead lion. ");
INSERT INTO engnoy_vpl VALUES ("EC9_5","022_9_5","ECC","9","5","5","For the living know that they shall die; but the dead know not any thing, and there is no more to them any advantage, for their memory is forgotten. ");
INSERT INTO engnoy_vpl VALUES ("EC9_6","022_9_6","ECC","9","6","6","Their love also, and their hatred, and their envy, is now perished; neither have they a portion any more for ever in any thing which taketh place under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC9_7","022_9_7","ECC","9","7","7","Go thy way, eat thy bread with joy, and drink thy wine with a cheerful heart; for long since hath God been pleased with thy works. ");
INSERT INTO engnoy_vpl VALUES ("EC9_8","022_9_8","ECC","9","8","8","Let thy garments be always white, and let not fragrant oil be wanting upon thy head. ");
INSERT INTO engnoy_vpl VALUES ("EC9_9","022_9_9","ECC","9","9","9","Enjoy life with the wife whom thou lovest, all the days of thy vain life which he hath given thee under the sun, all thy vain days. For this is thy portion in life, and in thy labor with which thou weariest thyself under the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC9_10","022_9_10","ECC","9","10","10","Whatever thy hand findeth to do, do it with thy might! For there is no work nor device nor knowledge nor wisdom in the under-world, whither thou goest. ");
INSERT INTO engnoy_vpl VALUES ("EC9_11","022_9_11","ECC","9","11","11","I turned and saw under the sun, that the race is not to the swift, nor the battle to the strong, nor yet bread to the wise, nor riches to men of understanding, nor favor to men of knowledge; but time and chance happen to them all. ");
INSERT INTO engnoy_vpl VALUES ("EC9_12","022_9_12","ECC","9","12","12","For man knoweth not his time. As fishes that are taken in a destructive net, and as birds that are caught in a snare, so are the sons of men snared in a time of distress, when it falleth suddenly upon them. ");
INSERT INTO engnoy_vpl VALUES ("EC9_13","022_9_13","ECC","9","13","13","This also have I seen; even wisdom under the sun, and it seemed great to me. ");
INSERT INTO engnoy_vpl VALUES ("EC9_14","022_9_14","ECC","9","14","14","There was a little city, and few men within it; and a great king came against it, and besieged it, and built great bulwarks against it. ");
INSERT INTO engnoy_vpl VALUES ("EC9_15","022_9_15","ECC","9","15","15","Now there was found within it a wise poor man; and he, by his wisdom, delivered the city; yet no man remembered that same poor man. ");
INSERT INTO engnoy_vpl VALUES ("EC9_16","022_9_16","ECC","9","16","16","Then said I, “Wisdom is better than strength;” and yet the poor man's wisdom is despised, and his words are not heard. ");
INSERT INTO engnoy_vpl VALUES ("EC9_17","022_9_17","ECC","9","17","17","The quiet words of the wise are sooner heard than the shouting of a foolish ruler. ");
INSERT INTO engnoy_vpl VALUES ("EC9_18","022_9_18","ECC","9","18","18","Wisdom is better than weapons of war. But one offender destroyeth much good. ");
INSERT INTO engnoy_vpl VALUES ("EC10_1","022_10_1","ECC","10","1","1","Dead flies make the oil of the perfumer loathsome and corrupt; thus doth a little folly weigh down wisdom and honor. ");
INSERT INTO engnoy_vpl VALUES ("EC10_2","022_10_2","ECC","10","2","2","A wise man's mind is at his right hand; but a fool's mind is at his left. ");
INSERT INTO engnoy_vpl VALUES ("EC10_3","022_10_3","ECC","10","3","3","Yea, even when the fool walketh in the way, his understanding faileth him, and he saith to every one that he is a fool. ");
INSERT INTO engnoy_vpl VALUES ("EC10_4","022_10_4","ECC","10","4","4","If the anger of a ruler rise up against thee, leave not thy place! for gentleness pacifieth great offences. ");
INSERT INTO engnoy_vpl VALUES ("EC10_5","022_10_5","ECC","10","5","5","There is an evil which I have seen under the sun; an error which proceedeth from a ruler. ");
INSERT INTO engnoy_vpl VALUES ("EC10_6","022_10_6","ECC","10","6","6","Folly is set in many high stations, and the noble sit in a low place. ");
INSERT INTO engnoy_vpl VALUES ("EC10_7","022_10_7","ECC","10","7","7","I have seen servants upon horses, and princes walking as servants on foot. ");
INSERT INTO engnoy_vpl VALUES ("EC10_8","022_10_8","ECC","10","8","8","He that diggeth a pit shall fall into it; and whoso breaketh down a wall, a serpent shall bite him. ");
INSERT INTO engnoy_vpl VALUES ("EC10_9","022_10_9","ECC","10","9","9","Whoso removeth stones shall be hurt therewith, and he that cleaveth wood shall be endangered thereby. ");
INSERT INTO engnoy_vpl VALUES ("EC10_10","022_10_10","ECC","10","10","10","If the iron be blunt, and one do not whet the edge, then must he put forth more strength; but an advantage for giving success hath wisdom. ");
INSERT INTO engnoy_vpl VALUES ("EC10_11","022_10_11","ECC","10","11","11","If a serpent bite before he is charmed, then there is no advantage to the charmer. ");
INSERT INTO engnoy_vpl VALUES ("EC10_12","022_10_12","ECC","10","12","12","The words of a wise man's mouth are gracious; but the lips of a fool are his destruction. ");
INSERT INTO engnoy_vpl VALUES ("EC10_13","022_10_13","ECC","10","13","13","The beginning of the words of his mouth is folly, and the end of his talk is mischievous madness. ");
INSERT INTO engnoy_vpl VALUES ("EC10_14","022_10_14","ECC","10","14","14","A fool also multiplieth words, though no man knoweth what shall be; and who can tell him what shall be after him? ");
INSERT INTO engnoy_vpl VALUES ("EC10_15","022_10_15","ECC","10","15","15","The labor of the foolish man wearieth him, because he knoweth not how to go to the city. ");
INSERT INTO engnoy_vpl VALUES ("EC10_16","022_10_16","ECC","10","16","16","Woe to thee, O land, when thy king is a child, and thy princes feast in the morning! ");
INSERT INTO engnoy_vpl VALUES ("EC10_17","022_10_17","ECC","10","17","17","Happy thou, O land, when thy king is a noble, and thy princes eat in due season, for strength, and not for drunkenness! ");
INSERT INTO engnoy_vpl VALUES ("EC10_18","022_10_18","ECC","10","18","18","By much slothfulness the building decayeth; and by the slackness of the hands the house leaketh. ");
INSERT INTO engnoy_vpl VALUES ("EC10_19","022_10_19","ECC","10","19","19","A feast is made for laughter, and wine makes merry; but money answereth all things. ");
INSERT INTO engnoy_vpl VALUES ("EC10_20","022_10_20","ECC","10","20","20","Curse not the king; no, not in thy thought; and curse not the rich in thy bed-chamber! for a bird of the air shall carry the voice; and that which hath wings shall tell the matter. ");
INSERT INTO engnoy_vpl VALUES ("EC11_1","022_11_1","ECC","11","1","1","Cast thy bread upon the waters; for after many days thou shalt find it. ");
INSERT INTO engnoy_vpl VALUES ("EC11_2","022_11_2","ECC","11","2","2","Give a portion to seven, yea, to eight; for thou knowest not what evil shall be upon the earth. ");
INSERT INTO engnoy_vpl VALUES ("EC11_3","022_11_3","ECC","11","3","3","When the clouds are full of rain, they empty upon the earth; and when a tree falleth to the south or the north, in the place where the tree falleth, there it shall be. ");
INSERT INTO engnoy_vpl VALUES ("EC11_4","022_11_4","ECC","11","4","4","He that watcheth the wind will not sow, and he that gazeth upon the clouds will not reap. ");
INSERT INTO engnoy_vpl VALUES ("EC11_5","022_11_5","ECC","11","5","5","As thou knowest not the way of the wind, nor how the bones are formed in the womb of her that is with child, so thou canst not know the work of God, who doeth all things. ");
INSERT INTO engnoy_vpl VALUES ("EC11_6","022_11_6","ECC","11","6","6","In the morning sow thy seed, and in the evening withhold not thy hand! For thou knowest not whether this shall prosper, or that, or whether both of them shall be alike good. ");
INSERT INTO engnoy_vpl VALUES ("EC11_7","022_11_7","ECC","11","7","7","Truly the light is sweet, and a pleasant thing it is for the eyes to behold the sun. ");
INSERT INTO engnoy_vpl VALUES ("EC11_8","022_11_8","ECC","11","8","8","Yea, though a man live many years, let him rejoice in them all, and let him think of the days of darkness; for they shall be many. All that cometh is vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Rejoice, O young man, in thy youth, and let thy heart cheer thee in the days of thy youth, and walk in the ways of thy heart, and in the sight of thine eyes! but know thou, that for all these things God will bring thee into judgment. ");
INSERT INTO engnoy_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Therefore remove sorrow from thy heart, and put away evil from thy body! for childhood and youth are vanity. ");
INSERT INTO engnoy_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Remember, also, thy Creator in the days of thy youth, before the evil days come, and the years draw nigh, of which thou shalt say, “I have no pleasure in them;” ");
INSERT INTO engnoy_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","before the sun, and the light, and the moon, and the stars become dark, and the clouds return after the rain; ");
INSERT INTO engnoy_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","at the time when the keepers of the house tremble, and the strong men bow themselves, and the grinders cease because they are few, and those that look out of the windows are darkened; ");
INSERT INTO engnoy_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","when the doors are shut in the streets, while the sound of the mill is low; when they rise up at the voice of the bird, and all the daughters of music are brought low; ");
INSERT INTO engnoy_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","when also they are afraid of that which is high, and terrors are in the way, and the almond is despised, and the locust is a burden, and the caper-berry is powerless; since man goeth to his eternal home, and the mourners go about the streets;— ");
INSERT INTO engnoy_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","before the silver cord be snapped asunder, and the golden bowl be crushed, or the bucket broken at the fountain, or the wheel shattered at the well, ");
INSERT INTO engnoy_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","and the dust return to the earth as it was, and the spirit return to God who gave it. ");
INSERT INTO engnoy_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Vanity of vanities, saith the Preacher; all is vanity! ");
INSERT INTO engnoy_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Moreover, because the Preacher was wise, he still taught the people knowledge; yea, he considered, and sought out, and set in order, many proverbs. ");
INSERT INTO engnoy_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","The Preacher sought to find out acceptable words, and to write correctly words of truth. ");
INSERT INTO engnoy_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","The words of the wise are as goads; yea, as nails driven in are the words of members of assemblies, given by one shepherd. ");
INSERT INTO engnoy_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","And, moreover, by these, my son, be warned! To the multiplying of books there is no end, and much study wearieth the flesh. ");
INSERT INTO engnoy_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Let us hear the end of the whole discourse! Fear God and keep his commandments! For this is the duty of every man. ");
INSERT INTO engnoy_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","For God will bring every work into the judgment which there is upon every secret thing, whether it be good, or whether it be evil. ");
INSERT INTO engnoy_vpl VALUES ("SS1_1","023_1_1","SNG","1","1","1","The Song of Songs, which is by Solomon. ");
INSERT INTO engnoy_vpl VALUES ("SS1_2","023_1_2","SNG","1","2","2","M. O that he would kiss me with one of the kisses of his mouth! For thy love is better than wine. ");
INSERT INTO engnoy_vpl VALUES ("SS1_3","023_1_3","SNG","1","3","3","Because of the savor of thy precious perfumes, (Thy name is like fragrant oil poured forth,) Therefore do the virgins love thee. ");
INSERT INTO engnoy_vpl VALUES ("SS1_4","023_1_4","SNG","1","4","4","Draw me after thee; let us run! The king hath led me to his chambers! We will be glad and rejoice in thee; We will praise thy love more than wine. Justly do they love thee! ");
INSERT INTO engnoy_vpl VALUES ("SS1_5","023_1_5","SNG","1","5","5","I am black, but comely, O ye daughters of Jerusalem, As the tents of Kedar, as the curtains of Solomon. ");
INSERT INTO engnoy_vpl VALUES ("SS1_6","023_1_6","SNG","1","6","6","Gaze not upon me because I am black, Because the sun hath looked upon me! My mother's sons were angry with me; They made me keeper of the vineyards; My vineyard, my own, have I not kept. ");
INSERT INTO engnoy_vpl VALUES ("SS1_7","023_1_7","SNG","1","7","7","Tell me, thou whom my soul loveth, where thou feedest thy flock, Where thou leadest it to rest at noon; For why should I be like a veiled one by the flocks of thy companions? ");
INSERT INTO engnoy_vpl VALUES ("SS1_8","023_1_8","SNG","1","8","8","Lad. If thou know not, O thou fairest among women, Trace thou thy way by the tracks of the flock, And feed thy kids beside the shepherds' tents! ");
INSERT INTO engnoy_vpl VALUES ("SS1_9","023_1_9","SNG","1","9","9","Lov. To the horses in the chariots of Pharaoh Do I compare thee, my love! ");
INSERT INTO engnoy_vpl VALUES ("SS1_10","023_1_10","SNG","1","10","10","Comely are thy cheeks with rows of jewels, Thy neck with strings of pearls. ");
INSERT INTO engnoy_vpl VALUES ("SS1_11","023_1_11","SNG","1","11","11","Golden chains will we make for thee, With studs of silver. ");
INSERT INTO engnoy_vpl VALUES ("SS1_12","023_1_12","SNG","1","12","12","M. While the king reclineth at his table, My spikenard sendeth forth its fragrance. ");
INSERT INTO engnoy_vpl VALUES ("SS1_13","023_1_13","SNG","1","13","13","A bunch of myrrh is my beloved to me; He shall abide between my breasts. ");
INSERT INTO engnoy_vpl VALUES ("SS1_14","023_1_14","SNG","1","14","14","My beloved is to me a cluster of henna-flowers From the gardens of Engedi. ");
INSERT INTO engnoy_vpl VALUES ("SS1_15","023_1_15","SNG","1","15","15","Lov. Behold, thou art fair, my love; behold, thou art fair! Thine eyes are doves. ");
INSERT INTO engnoy_vpl VALUES ("SS1_16","023_1_16","SNG","1","16","16","M. Behold, thou art fair, my beloved, yea, lovely; And green is our bed. ");
INSERT INTO engnoy_vpl VALUES ("SS1_17","023_1_17","SNG","1","17","17","The cedars are the beams of our house, And its roof the cypresses. ");
INSERT INTO engnoy_vpl VALUES ("SS2_1","023_2_1","SNG","2","1","1","I am a rose of Sharon, A lily of the valleys. ");
INSERT INTO engnoy_vpl VALUES ("SS2_2","023_2_2","SNG","2","2","2","Lov. As the lily among thorns, So is my love among the daughters. ");
INSERT INTO engnoy_vpl VALUES ("SS2_3","023_2_3","SNG","2","3","3","M. As the apple-tree among the trees of the forest, So is my beloved among the sons. In his shadow I love to sit down, And his fruit is sweet to my taste. ");
INSERT INTO engnoy_vpl VALUES ("SS2_4","023_2_4","SNG","2","4","4","He hath brought me to his banqueting-house, And his banner over me is love. Strengthen me with raisins, ");
INSERT INTO engnoy_vpl VALUES ("SS2_5","023_2_5","SNG","2","5","5","Refresh me with apples! For I am sick with love. ");
INSERT INTO engnoy_vpl VALUES ("SS2_6","023_2_6","SNG","2","6","6","His left hand is under my head, And his right hand embraceth me! ");
INSERT INTO engnoy_vpl VALUES ("SS2_7","023_2_7","SNG","2","7","7","Lov. I charge you, O ye daughters of Jerusalem, By the gazelles, and by the hinds of the field, That ye stir not up, nor awake my love, till she please! ");
INSERT INTO engnoy_vpl VALUES ("SS2_8","023_2_8","SNG","2","8","8","M. The voice of my beloved! Behold, he cometh, Leaping upon the mountains, Bounding upon the hills. ");
INSERT INTO engnoy_vpl VALUES ("SS2_9","023_2_9","SNG","2","9","9","Like a gazelle is my beloved, Or a young hind. Behold, he standeth behind our wall; He is looking through the windows; He glanceth through the lattice. ");
INSERT INTO engnoy_vpl VALUES ("SS2_10","023_2_10","SNG","2","10","10","My beloved speaketh, and saith to me, “Rise up, my love, my fair one, and come away! ");
INSERT INTO engnoy_vpl VALUES ("SS2_11","023_2_11","SNG","2","11","11","For, lo, the winter is past, The rain is over and gone; ");
INSERT INTO engnoy_vpl VALUES ("SS2_12","023_2_12","SNG","2","12","12","The flowers appear on the earth; The time of the singing of birds is come, And the voice of the turtle is heard in our land; ");
INSERT INTO engnoy_vpl VALUES ("SS2_13","023_2_13","SNG","2","13","13","The fig-tree is spicing its green fruit; The vines in blossom give forth fragrance. Arise, my love, my fair one, and come away! ");
INSERT INTO engnoy_vpl VALUES ("SS2_14","023_2_14","SNG","2","14","14","O my dove, that art in the recesses of the rock, In the hiding-places of the steep craggy mountain, Let me see thy face, Let me hear thy voice! For sweet is thy voice, And thy face lovely.” ");
INSERT INTO engnoy_vpl VALUES ("SS2_15","023_2_15","SNG","2","15","15","Take ye for us the foxes, The little foxes that spoil the vines; For our vines are now in blossom. ");
INSERT INTO engnoy_vpl VALUES ("SS2_16","023_2_16","SNG","2","16","16","My beloved is mine, and I am his; He feedeth among the lilies. ");
INSERT INTO engnoy_vpl VALUES ("SS2_17","023_2_17","SNG","2","17","17","When the day breathes, and the shadows flee away, Come again, my beloved, like a gazelle, or a young hind, Upon the craggy mountains. ");
INSERT INTO engnoy_vpl VALUES ("SS3_1","023_3_1","SNG","3","1","1","M. Upon my bed, in the night, I sought him whom my soul loveth; I sought him, but found him not. ");
INSERT INTO engnoy_vpl VALUES ("SS3_2","023_3_2","SNG","3","2","2","I will arise now said I, and go about the city; In the streets and the broad ways will I seek him whom my soul loveth; I sought him, but found him not. ");
INSERT INTO engnoy_vpl VALUES ("SS3_3","023_3_3","SNG","3","3","3","The watchmen who go about the city found me; “Have you seen said I him whom my soul loveth?” ");
INSERT INTO engnoy_vpl VALUES ("SS3_4","023_3_4","SNG","3","4","4","I had but just passed them, When I found him whom my soul loveth; I held him, and would not let him go, Till I had brought him into my mother's house, Into the apartment of her that bore me. ");
INSERT INTO engnoy_vpl VALUES ("SS3_5","023_3_5","SNG","3","5","5","Lov. I charge you, O ye daughters of Jerusalem! By the gazelles, and by the hinds of the field, That ye stir not up, nor awake my love, till she please. ");
INSERT INTO engnoy_vpl VALUES ("SS3_6","023_3_6","SNG","3","6","6","Who is this that cometh up from the wilderness, Like pillars of smoke, Perfumed with myrrh and frankincense, With all the powders of the merchant? ");
INSERT INTO engnoy_vpl VALUES ("SS3_7","023_3_7","SNG","3","7","7","Behold, the carriage of Solomon! Threescore valiant men are around it, Of the valiant men of Israel. ");
INSERT INTO engnoy_vpl VALUES ("SS3_8","023_3_8","SNG","3","8","8","They all wear swords, Being skilled in war. Every one hath his sword girt upon his thigh, On account of danger in the night. ");
INSERT INTO engnoy_vpl VALUES ("SS3_9","023_3_9","SNG","3","9","9","King Solomon made for himself a carriage Of the wood of Lebanon. ");
INSERT INTO engnoy_vpl VALUES ("SS3_10","023_3_10","SNG","3","10","10","The pillars thereof he made of silver, The railing of gold, The seat of purple, Its interior curiously wrought by a lovely one of the daughters of Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("SS3_11","023_3_11","SNG","3","11","11","Go forth, O ye daughters of Zion! And behold King Solomon In the crown with which his mother crowned him, In the day of his espousals, In the day of the gladness of his heart. ");
INSERT INTO engnoy_vpl VALUES ("SS4_1","023_4_1","SNG","4","1","1","Lov. Behold, thou art fair, my love! behold, thou art fair! Thine eyes are doves behind thy veil; Thy locks are like a flock of goats Which lie down on mount Gilead; ");
INSERT INTO engnoy_vpl VALUES ("SS4_2","023_4_2","SNG","4","2","2","Thy teeth are like a flock of shorn sheep, Which come up from the washing-place, Of which every one beareth twins, And none is barren among them; ");
INSERT INTO engnoy_vpl VALUES ("SS4_3","023_4_3","SNG","4","3","3","Thy lips are like a thread of scarlet, And thy mouth comely; Thy cheeks are like a divided pomegranate behind thy veil; ");
INSERT INTO engnoy_vpl VALUES ("SS4_4","023_4_4","SNG","4","4","4","Thy neck is like the tower of David, Built for an armory, In which there hang a thousand bucklers, All shields of mighty men; ");
INSERT INTO engnoy_vpl VALUES ("SS4_5","023_4_5","SNG","4","5","5","Thy two breasts are like two young twin gazelles, That feed among the lilies. ");
INSERT INTO engnoy_vpl VALUES ("SS4_6","023_4_6","SNG","4","6","6","When the day breathes, and the shadows flee away, I will betake me to the mountain of myrrh And the hill of frankincense. ");
INSERT INTO engnoy_vpl VALUES ("SS4_7","023_4_7","SNG","4","7","7","Thou art all fair, my love; There is no spot in thee! ");
INSERT INTO engnoy_vpl VALUES ("SS4_8","023_4_8","SNG","4","8","8","Come with me from Lebanon, my spouse, With me from Lebanon! Look from the top of Amana, From the top of Senir and Hermon, From the dens of the lions, From the mountains of the leopards. ");
INSERT INTO engnoy_vpl VALUES ("SS4_9","023_4_9","SNG","4","9","9","Thou hast taken captive my heart, my sister, my spouse; Thou hast taken captive my heart with one of thine eyes, With one chain of thy neck. ");
INSERT INTO engnoy_vpl VALUES ("SS4_10","023_4_10","SNG","4","10","10","How sweet is thy love, my sister, my spouse! How much more precious thy caresses than wine, And the fragrance of thy perfumes than all spices! ");
INSERT INTO engnoy_vpl VALUES ("SS4_11","023_4_11","SNG","4","11","11","Thy lips, O my spouse! drop the honeycomb; Honey and milk are under thy tongue, And the fragrance of thy garments is as the fragrance of Lebanon. ");
INSERT INTO engnoy_vpl VALUES ("SS4_12","023_4_12","SNG","4","12","12","A garden inclosed is my sister, my spouse; A spring shut up, a fountain sealed; ");
INSERT INTO engnoy_vpl VALUES ("SS4_13","023_4_13","SNG","4","13","13","Thy plants are an orchard of pomegranates, with choicest fruits, Henna and spikenard, ");
INSERT INTO engnoy_vpl VALUES ("SS4_14","023_4_14","SNG","4","14","14","Spikenard and saffron, Sweet cane and cinnamon, With all trees of frankincense; Myrrh and aloes, With all the chief spices; ");
INSERT INTO engnoy_vpl VALUES ("SS4_15","023_4_15","SNG","4","15","15","A fountain of the gardens, A well of living water, A stream that floweth from Lebanon! ");
INSERT INTO engnoy_vpl VALUES ("SS4_16","023_4_16","SNG","4","16","16","M. Awake, O north wind, and come, thou south! Blow upon my garden, That its spices may flow out! May my beloved come to his garden, And eat his pleasant fruits. ");
INSERT INTO engnoy_vpl VALUES ("SS5_1","023_5_1","SNG","5","1","1","Lov. I am come to my garden, my sister, my spouse! I gather my myrrh with my balsam, I eat my honeycomb with my honey, I drink my wine with my milk. Eat, O friends! Drink, yea, drink abundantly, my loved companions! ");
INSERT INTO engnoy_vpl VALUES ("SS5_2","023_5_2","SNG","5","2","2","M. I slept, but my heart was awake; It was the voice of my beloved, who was knocking: “Open to me, my sister, my love, My dove, my perfect one! For my head is filled with dew, And my locks with the drops of the night.” ");
INSERT INTO engnoy_vpl VALUES ("SS5_3","023_5_3","SNG","5","3","3","“I have taken off my vest said I; How shall I put it on? I have washed my feet; How shall I soil them?” ");
INSERT INTO engnoy_vpl VALUES ("SS5_4","023_5_4","SNG","5","4","4","My beloved put in his hand by the hole of the door, And my heart was moved for him. ");
INSERT INTO engnoy_vpl VALUES ("SS5_5","023_5_5","SNG","5","5","5","I rose up to open to my beloved, And my hands dropped with myrrh, And my fingers with self-flowing myrrh, upon the handles of the bolt. ");
INSERT INTO engnoy_vpl VALUES ("SS5_6","023_5_6","SNG","5","6","6","I opened to my beloved; But my beloved had withdrawn himself, and was gone. I was not in my senses while he spake with me! I sought him, but could not find him; I called him, but he gave me no answer. ");
INSERT INTO engnoy_vpl VALUES ("SS5_7","023_5_7","SNG","5","7","7","The watchmen that go about the city found me; They smote me, they wounded me; The keepers of the walls took away from me my veil. ");
INSERT INTO engnoy_vpl VALUES ("SS5_8","023_5_8","SNG","5","8","8","I charge you, O ye daughters of Jerusalem! If ye should find my beloved,—What will ye tell him? That I am sick with love. ");
INSERT INTO engnoy_vpl VALUES ("SS5_9","023_5_9","SNG","5","9","9","Lad. What is thy beloved more than another beloved, O thou fairest among women! What is thy beloved more than another beloved, That thus thou dost charge us? ");
INSERT INTO engnoy_vpl VALUES ("SS5_10","023_5_10","SNG","5","10","10","M. My beloved is white and ruddy, The chief among ten thousand. ");
INSERT INTO engnoy_vpl VALUES ("SS5_11","023_5_11","SNG","5","11","11","His head is as the most fine gold; His locks waving palm-branches, Black as a raven; ");
INSERT INTO engnoy_vpl VALUES ("SS5_12","023_5_12","SNG","5","12","12","His eyes are doves by streams of water, Washed with milk, dwelling in fulness; ");
INSERT INTO engnoy_vpl VALUES ("SS5_13","023_5_13","SNG","5","13","13","His cheeks are like a bed of balsam, Like beds of spices; His lips are lilies Dropping self-flowing myrrh; ");
INSERT INTO engnoy_vpl VALUES ("SS5_14","023_5_14","SNG","5","14","14","His hands are gold rings set with chrysolite; His body is wrought-work of ivory, overlaid with sapphires; ");
INSERT INTO engnoy_vpl VALUES ("SS5_15","023_5_15","SNG","5","15","15","His legs are marble pillars, resting on pedestals of fine gold; His aspect is like Lebanon, Majestic like the cedars; ");
INSERT INTO engnoy_vpl VALUES ("SS5_16","023_5_16","SNG","5","16","16","His mouth is sweetness; His whole being, loveliness. This is my beloved, This my friend, O ye daughters of Jerusalem! ");
INSERT INTO engnoy_vpl VALUES ("SS6_1","023_6_1","SNG","6","1","1","Lad. Whither is thy beloved gone, thou fairest among women? Whither hath thy beloved betaken himself? That we may seek him with thee. ");
INSERT INTO engnoy_vpl VALUES ("SS6_2","023_6_2","SNG","6","2","2","M. My beloved is gone down to his garden, To the beds of balsam, To feed in the gardens, And to gather lilies. ");
INSERT INTO engnoy_vpl VALUES ("SS6_3","023_6_3","SNG","6","3","3","I am my beloved's, and my beloved is mine; He feedeth among the lilies. ");
INSERT INTO engnoy_vpl VALUES ("SS6_4","023_6_4","SNG","6","4","4","Beautiful art thou, my love, as Tirzah, Lovely as Jerusalem; But terrible as an army with banners. ");
INSERT INTO engnoy_vpl VALUES ("SS6_5","023_6_5","SNG","6","5","5","Turn away thine eyes from me! They overpower me! Thy locks are like a flock of goats, Which lie down upon Gilead. ");
INSERT INTO engnoy_vpl VALUES ("SS6_6","023_6_6","SNG","6","6","6","Thy teeth are like a flock of sheep, Which come up from the washing-place, Of which every one hath twins, And none is barren among them. ");
INSERT INTO engnoy_vpl VALUES ("SS6_7","023_6_7","SNG","6","7","7","As a divided pomegranate Are thy cheeks behind thy veil. ");
INSERT INTO engnoy_vpl VALUES ("SS6_8","023_6_8","SNG","6","8","8","Threescore are the queens, and fourscore the concubines, And the maidens without number. ");
INSERT INTO engnoy_vpl VALUES ("SS6_9","023_6_9","SNG","6","9","9","But my dove, my undefiled, is the one; She is the incomparable one of her mother, The darling of her that bore her. The daughters saw her, and blessed her; The queens and concubines, and they praised her. ");
INSERT INTO engnoy_vpl VALUES ("SS6_10","023_6_10","SNG","6","10","10","Lov. Who is this that looketh forth like the morning, Fair as the moon, bright as the sun, And terrible as an army with banners? ");
INSERT INTO engnoy_vpl VALUES ("SS6_11","023_6_11","SNG","6","11","11","M. I went down into the garden of nuts, To see the green plants of the valley, To see whether the vine blossomed, And the pomegranates budded. ");
INSERT INTO engnoy_vpl VALUES ("SS6_12","023_6_12","SNG","6","12","12","Or ever I was aware, My soul had made me like the chariots of the prince's train. ");
INSERT INTO engnoy_vpl VALUES ("SS6_13","023_6_13","SNG","6","13","13","Lad. Return, return, O Shulamite! Return, return, that we may look upon thee! M. Why should ye look upon the Shulamite, As upon a dance of the hosts? ");
INSERT INTO engnoy_vpl VALUES ("SS7_1","023_7_1","SNG","7","1","1","Lov. How beautiful are thy feet in sandals, O prince's daughter! The roundings of thy hips are like neck ornaments, The work of the hands of the artificer; ");
INSERT INTO engnoy_vpl VALUES ("SS7_2","023_7_2","SNG","7","2","2","Thy navel is like a round goblet, that wanteth not the spiced wine; Thy belly like a heap of wheat, inclosed with lilies; ");
INSERT INTO engnoy_vpl VALUES ("SS7_3","023_7_3","SNG","7","3","3","Thy two breasts are like two young twin gazelles; ");
INSERT INTO engnoy_vpl VALUES ("SS7_4","023_7_4","SNG","7","4","4","Thy neck is as a tower of ivory; Thine eyes are like the pools at Heshbon, by the gate of Bath-rabbim; Thy nose is as the tower of Lebanon, which looketh toward Damascus; ");
INSERT INTO engnoy_vpl VALUES ("SS7_5","023_7_5","SNG","7","5","5","Thy head upon thee is like Carmel, And the hair of thy head like purple; The king is captivated by thy locks. ");
INSERT INTO engnoy_vpl VALUES ("SS7_6","023_7_6","SNG","7","6","6","How fair, how pleasant art thou, love, in delights! ");
INSERT INTO engnoy_vpl VALUES ("SS7_7","023_7_7","SNG","7","7","7","This thy stature is like the palm-tree, And thy breasts like clusters of dates. ");
INSERT INTO engnoy_vpl VALUES ("SS7_8","023_7_8","SNG","7","8","8","I will go up, say I to myself, upon the palm-tree; I will take hold of its boughs, And thy breasts shall be as clusters of the vine, And the fragrance of thy nose like apples, ");
INSERT INTO engnoy_vpl VALUES ("SS7_9","023_7_9","SNG","7","9","9","And thy mouth like the best wine— M. — that goeth down smoothly for my beloved, Flowing over the lips of them that sleep. ");
INSERT INTO engnoy_vpl VALUES ("SS7_10","023_7_10","SNG","7","10","10","I am my beloved's, And his desire is toward me. ");
INSERT INTO engnoy_vpl VALUES ("SS7_11","023_7_11","SNG","7","11","11","Come, my beloved, let us go forth into the country; Let us lodge in the villages! ");
INSERT INTO engnoy_vpl VALUES ("SS7_12","023_7_12","SNG","7","12","12","Then will we go early to the vineyards, To see whether the vine putteth forth, Whether its blossom openeth, And the pomegranates bud forth; There will I give thee my love! ");
INSERT INTO engnoy_vpl VALUES ("SS7_13","023_7_13","SNG","7","13","13","The love-apples give forth fragrance; And at our doors are all kinds of precious fruits, new and old: I have kept them for thee, my beloved! ");
INSERT INTO engnoy_vpl VALUES ("SS8_1","023_8_1","SNG","8","1","1","O that thou wert as my brother, That sucked the breast of my mother! When I found thee abroad, I might kiss thee; And for it no one would deride me. ");
INSERT INTO engnoy_vpl VALUES ("SS8_2","023_8_2","SNG","8","2","2","I will lead thee, and bring thee into my mother's house, that thou mayst teach me; I will give thee spiced wine to drink, and the juice of my pomegranates. ");
INSERT INTO engnoy_vpl VALUES ("SS8_3","023_8_3","SNG","8","3","3","His left hand is under my head, And his right hand embraceth me. ");
INSERT INTO engnoy_vpl VALUES ("SS8_4","023_8_4","SNG","8","4","4","Lov. I charge you, O ye daughters of Jerusalem! That ye stir not up, nor awake my love, Till she please! ");
INSERT INTO engnoy_vpl VALUES ("SS8_5","023_8_5","SNG","8","5","5","Lad. Who is this that cometh up from the wilderness, Leaning upon her beloved? M. Under the apple-tree I awakened thee; There thy mother brought thee forth; There she that bore thee brought thee forth! ");
INSERT INTO engnoy_vpl VALUES ("SS8_6","023_8_6","SNG","8","6","6","O set me as a seal upon thy heart, As a seal upon thine arm! For love is strong as death; True love is firm as the grave: Its flames are flames of fire, The fire of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("SS8_7","023_8_7","SNG","8","7","7","Many waters cannot quench love, Nor can floods drown it. Would a man give all the wealth of his house for love, It would be utterly contemned. ");
INSERT INTO engnoy_vpl VALUES ("SS8_8","023_8_8","SNG","8","8","8","Br. We have a sister who is yet young; She is yet without breasts. What shall we do with our sister, When she shall be spoken for? ");
INSERT INTO engnoy_vpl VALUES ("SS8_9","023_8_9","SNG","8","9","9","If she be a wall, We will build upon it a silver tower; If she be an open gate, We will inclose her with planks of cedar. ");
INSERT INTO engnoy_vpl VALUES ("SS8_10","023_8_10","SNG","8","10","10","Sis. I am a wall, and my breasts like towers; Therefore am I become in his eyes as one that findeth peace. ");
INSERT INTO engnoy_vpl VALUES ("SS8_11","023_8_11","SNG","8","11","11","Solomon had a vineyard at Baal-hamon; He let out the vineyard to keepers; Every one was to bring a thousand shekels of silver for its fruit. ");
INSERT INTO engnoy_vpl VALUES ("SS8_12","023_8_12","SNG","8","12","12","My vineyard is before my eyes. Be thine the thousand, O Solomon! And two hundred to the keepers of its fruit! ");
INSERT INTO engnoy_vpl VALUES ("SS8_13","023_8_13","SNG","8","13","13","Lov. Thou that dwellest in the gardens! Friends listen to thy voice; Let me hear thee! ");
INSERT INTO engnoy_vpl VALUES ("SS8_14","023_8_14","SNG","8","14","14","Fly, my beloved! like a gazelle, or a young hind, Upon the mountains of spices. ");
INSERT INTO engnoy_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","1","The visions of Isaiah, the son of Amoz, which he saw concerning Judah and Jerusalem, in the days of Uzziah, Jotham, Ahaz, and Hezekiah, kings of Judah. ");
INSERT INTO engnoy_vpl VALUES ("IS1_2","024_1_2","ISA","1","2","2","Hear, O heavens, and give ear, O earth! For Jehovah speaketh: “I have nourished and brought up children, And they have rebelled against me. ");
INSERT INTO engnoy_vpl VALUES ("IS1_3","024_1_3","ISA","1","3","3","The ox knoweth his owner, And the ass his master's crib; But Israel doth not know; My people do not consider.” ");
INSERT INTO engnoy_vpl VALUES ("IS1_4","024_1_4","ISA","1","4","4","Ah, sinful nation! a people laden with iniquity! A race of evil-doers! degenerate children! They have forsaken Jehovah; they have despised the Holy One of Israel; They have gone backward. ");
INSERT INTO engnoy_vpl VALUES ("IS1_5","024_1_5","ISA","1","5","5","Where can ye be smitten again, Since ye renew your rebellion? The whole head is sick, and the whole heart faint; ");
INSERT INTO engnoy_vpl VALUES ("IS1_6","024_1_6","ISA","1","6","6","From the sole of the foot even to the head, there is no soundness in it; It is all bruises, and stripes, and flesh wounds, Neither pressed, nor bound up, nor softened with ointment. ");
INSERT INTO engnoy_vpl VALUES ("IS1_7","024_1_7","ISA","1","7","7","Your country is desolate; Your cities are burnt with fire; Your ground, strangers devour it before your eyes; It is become desolate, destroyed by an enemy. ");
INSERT INTO engnoy_vpl VALUES ("IS1_8","024_1_8","ISA","1","8","8","And the daughter of Zion is left as a shed in a vineyard, As a hut in a garden of cucumbers, As a besieged city. ");
INSERT INTO engnoy_vpl VALUES ("IS1_9","024_1_9","ISA","1","9","9","Had not Jehovah of hosts left us a small remnant, We had soon become as Sodom; We had been like to Gomorrah. ");
INSERT INTO engnoy_vpl VALUES ("IS1_10","024_1_10","ISA","1","10","10","Hear ye the word of Jehovah, ye princes of Sodom! Give ear to the instruction of our God, ye people of Gomorrah! ");
INSERT INTO engnoy_vpl VALUES ("IS1_11","024_1_11","ISA","1","11","11","What to me is the multitude of your sacrifices? saith Jehovah; I am satiated with burnt-offerings of rams, and the fat of fed beasts; In the blood of bullocks and of lambs and of goats I have no delight. ");
INSERT INTO engnoy_vpl VALUES ("IS1_12","024_1_12","ISA","1","12","12","When ye come to appear before me, Who hath required this of you, to tread my courts? ");
INSERT INTO engnoy_vpl VALUES ("IS1_13","024_1_13","ISA","1","13","13","Bring no more false oblations! Incense is an abomination to me, The new moon also, and the sabbath, and the calling of the assembly; Iniquity and festivals I cannot endure. ");
INSERT INTO engnoy_vpl VALUES ("IS1_14","024_1_14","ISA","1","14","14","Your new moons and your feasts my soul hateth; They are a burden to me; I am weary of bearing them. ");
INSERT INTO engnoy_vpl VALUES ("IS1_15","024_1_15","ISA","1","15","15","When ye spread forth your hands, I will hide mine eyes from you; Yea, when ye multiply prayers, I will not hear: Your hands are full of blood! ");
INSERT INTO engnoy_vpl VALUES ("IS1_16","024_1_16","ISA","1","16","16","Wash you; make you clean; Put away your evil doings from before mine eyes; ");
INSERT INTO engnoy_vpl VALUES ("IS1_17","024_1_17","ISA","1","17","17","Cease to do evil; Learn to do well; Seek justice; relieve the oppressed; Defend the fatherless; plead for the widow! ");
INSERT INTO engnoy_vpl VALUES ("IS1_18","024_1_18","ISA","1","18","18","Come, now, and let us argue together, saith Jehovah. Though your sins be as scarlet, they shall be as white as snow; Though they be red as crimson, they shall be like wool. ");
INSERT INTO engnoy_vpl VALUES ("IS1_19","024_1_19","ISA","1","19","19","If ye be willing and obedient, Ye shall consume the good of the land. ");
INSERT INTO engnoy_vpl VALUES ("IS1_20","024_1_20","ISA","1","20","20","But if ye refuse, and be rebellious, The sword shall consume you; For the mouth of Jehovah hath said it. ");
INSERT INTO engnoy_vpl VALUES ("IS1_21","024_1_21","ISA","1","21","21","How is the faithful city become a harlot, She that was full of equity! Once justice dwelt in her, but now murderers! ");
INSERT INTO engnoy_vpl VALUES ("IS1_22","024_1_22","ISA","1","22","22","Thy silver is become dross; Thy wine is adulterated with water. ");
INSERT INTO engnoy_vpl VALUES ("IS1_23","024_1_23","ISA","1","23","23","Thy princes are faithless, companions of thieves; Every one of them loveth gifts, and seeketh rewards; They render not justice to the fatherless, And the cause of the widow cometh not before them. ");
INSERT INTO engnoy_vpl VALUES ("IS1_24","024_1_24","ISA","1","24","24","Wherefore, thus saith the Lord, Jehovah of hosts, the Mighty One of Israel: Ha! I will ease me of mine adversaries, And avenge me of mine enemies. ");
INSERT INTO engnoy_vpl VALUES ("IS1_25","024_1_25","ISA","1","25","25","And I will again turn my hand toward thee, And wholly purge away thy dross, And take away all thy alloy. ");
INSERT INTO engnoy_vpl VALUES ("IS1_26","024_1_26","ISA","1","26","26","And I will restore thee judges, as at the first, And counsellors, as at the beginning. Then shalt thou be called the city of righteousness, the faithful city. ");
INSERT INTO engnoy_vpl VALUES ("IS1_27","024_1_27","ISA","1","27","27","Through justice shall Zion be delivered, And her reformed sons through righteousness. ");
INSERT INTO engnoy_vpl VALUES ("IS1_28","024_1_28","ISA","1","28","28","But destruction shall fall at once on the rebels and sinners; Yea, they that forsake Jehovah shall be consumed. ");
INSERT INTO engnoy_vpl VALUES ("IS1_29","024_1_29","ISA","1","29","29","For ye shall be ashamed of the terebinths in which ye delighted; Ye shall blush for the gardens which ye loved; ");
INSERT INTO engnoy_vpl VALUES ("IS1_30","024_1_30","ISA","1","30","30","And ye shall be as a terebinth-tree whose leaves are withered, And as a garden in which is no water. ");
INSERT INTO engnoy_vpl VALUES ("IS1_31","024_1_31","ISA","1","31","31","The strong shall become tow, And his work a spark of fire; Both shall burn together, And none shall quench them. ");
INSERT INTO engnoy_vpl VALUES ("IS2_1","024_2_1","ISA","2","1","1","The word, which was revealed to Isaiah, the son of Amoz, concerning Judah and Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS2_2","024_2_2","ISA","2","2","2","It shall come to pass in the last days, That the mountain of the house of Jehovah shall be established at the head of the mountains, And exalted above the hills; And all nations shall flow unto it. ");
INSERT INTO engnoy_vpl VALUES ("IS2_3","024_2_3","ISA","2","3","3","And many kingdoms shall go, and shall say, “Come, let us go to the mountain of Jehovah, To the house of the God of Jacob, That he may teach us his ways, And that we may walk in his paths!” For from Zion shall go forth a law, And the word of Jehovah from Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS2_4","024_2_4","ISA","2","4","4","He shall be a judge of the nations, And an umpire of many kingdoms; And they shall beat their swords into ploughshares, And their spears into pruning-hooks; Nation shall not lift up the sword against nation, Neither shall they learn war any more. ");
INSERT INTO engnoy_vpl VALUES ("IS2_5","024_2_5","ISA","2","5","5","O house of Jacob, come ye, And let us walk in the light of Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("IS2_6","024_2_6","ISA","2","6","6","For thou hast forsaken thy people, the house of Jacob, Because they are full of the East, And are sorcerers, like the Philistines, And strike hands with a foreign race! ");
INSERT INTO engnoy_vpl VALUES ("IS2_7","024_2_7","ISA","2","7","7","Their land is full of silver and gold, And there is no end to their treasures; Their land is full of horses, And there is no end to their chariots; ");
INSERT INTO engnoy_vpl VALUES ("IS2_8","024_2_8","ISA","2","8","8","Their land is full of idols; They bow down to the work of their own hands, To that which their own fingers have made. ");
INSERT INTO engnoy_vpl VALUES ("IS2_9","024_2_9","ISA","2","9","9","Therefore shall the mean man be bowed down, And the great man be brought low; And thou wilt not forgive them! ");
INSERT INTO engnoy_vpl VALUES ("IS2_10","024_2_10","ISA","2","10","10","Go into the rock, hide yourselves in the dust, From the terror of Jehovah, and the glory of his majesty! ");
INSERT INTO engnoy_vpl VALUES ("IS2_11","024_2_11","ISA","2","11","11","The proud looks of man shall be humbled, And the loftiness of mortals shall be brought low; Jehovah alone shall be exalted in that day. ");
INSERT INTO engnoy_vpl VALUES ("IS2_12","024_2_12","ISA","2","12","12","For Jehovah of hosts holdeth a day of judgment Against all that is proud and lofty; Against all that is exalted, and it shall be brought low; ");
INSERT INTO engnoy_vpl VALUES ("IS2_13","024_2_13","ISA","2","13","13","Against all the cedars of Lebanon, the high and the exalted, And against all the oaks of Bashan; ");
INSERT INTO engnoy_vpl VALUES ("IS2_14","024_2_14","ISA","2","14","14","Against all the lofty mountains, And against all the high hills; ");
INSERT INTO engnoy_vpl VALUES ("IS2_15","024_2_15","ISA","2","15","15","Against every lofty tower, And against every high wall; ");
INSERT INTO engnoy_vpl VALUES ("IS2_16","024_2_16","ISA","2","16","16","Against all the ships of Tarshish, And against all their beautiful flags. ");
INSERT INTO engnoy_vpl VALUES ("IS2_17","024_2_17","ISA","2","17","17","The pride of man shall be humbled; The loftiness of mortals shall be brought low; Jehovah alone shall be exalted in that day. ");
INSERT INTO engnoy_vpl VALUES ("IS2_18","024_2_18","ISA","2","18","18","The idols shall wholly pass away; ");
INSERT INTO engnoy_vpl VALUES ("IS2_19","024_2_19","ISA","2","19","19","And men shall go into clefts of the rocks, and caves of the earth, From the terror of Jehovah, and the glory of his majesty, When he ariseth to make the earth tremble. ");
INSERT INTO engnoy_vpl VALUES ("IS2_20","024_2_20","ISA","2","20","20","At that time shall men cast away their idols of silver and their idols of gold, Which they have made to worship, To the moles and the bats; ");
INSERT INTO engnoy_vpl VALUES ("IS2_21","024_2_21","ISA","2","21","21","Fleeing into caves of the rocks, and clefts of the craggy rocks, From the terror of Jehovah, and the glory of his majesty, When he ariseth to make the earth tremble. ");
INSERT INTO engnoy_vpl VALUES ("IS2_22","024_2_22","ISA","2","22","22","Trust, then, no more in man, Whose breath is in his nostrils! For what account is to be made of him! ");
INSERT INTO engnoy_vpl VALUES ("IS3_1","024_3_1","ISA","3","1","1","For behold, the Lord, Jehovah of hosts, Taketh away from Jerusalem and from Judah every stay and support; The whole stay of bread, and the whole stay of water; ");
INSERT INTO engnoy_vpl VALUES ("IS3_2","024_3_2","ISA","3","2","2","The mighty man, and the warrior, The judge, the prophet, the diviner, and the sage, ");
INSERT INTO engnoy_vpl VALUES ("IS3_3","024_3_3","ISA","3","3","3","The captain of fifty, and the honorable man, The counsellor, the expert in arts, and the skilful in charms. ");
INSERT INTO engnoy_vpl VALUES ("IS3_4","024_3_4","ISA","3","4","4","And I will make boys their princes, And children shall rule over them. ");
INSERT INTO engnoy_vpl VALUES ("IS3_5","024_3_5","ISA","3","5","5","And the people shall oppress one another, Man striving against man, and neighbor against neighbor; The boy shall behave himself insolently toward the aged, And the base toward the honorable. ");
INSERT INTO engnoy_vpl VALUES ("IS3_6","024_3_6","ISA","3","6","6","Then shall a man take hold of his brother in his father's house, and say, Thou hast yet clothing, Be thou our ruler, And take this ruin into thy hands! ");
INSERT INTO engnoy_vpl VALUES ("IS3_7","024_3_7","ISA","3","7","7","But in that day shall he lift up his hand, and say: I am no healer; In my house is neither bread nor raiment; Make not me ruler of the people! ");
INSERT INTO engnoy_vpl VALUES ("IS3_8","024_3_8","ISA","3","8","8","For Jerusalem tottereth, and Judah falleth, Because their tongues and their deeds are against Jehovah, To provoke his holy eyes. ");
INSERT INTO engnoy_vpl VALUES ("IS3_9","024_3_9","ISA","3","9","9","Their very countenance witnesseth against them; They publish their sin like Sodom; they hide it not; Woe to them, for they bring evil upon themselves! ");
INSERT INTO engnoy_vpl VALUES ("IS3_10","024_3_10","ISA","3","10","10","Say ye of the righteous that it shall be well with him, For he shall eat the fruit of his doings. ");
INSERT INTO engnoy_vpl VALUES ("IS3_11","024_3_11","ISA","3","11","11","Woe to the wicked, it shall be ill with him, For the work of his hands shall be repaid him! ");
INSERT INTO engnoy_vpl VALUES ("IS3_12","024_3_12","ISA","3","12","12","As for my people, children are their oppressors, And women rule over them. O my people, thy leaders cause thee to err, And destroy the way in which thou walkest! ");
INSERT INTO engnoy_vpl VALUES ("IS3_13","024_3_13","ISA","3","13","13","Jehovah standeth up to maintain his cause; He standeth up to judge his people. ");
INSERT INTO engnoy_vpl VALUES ("IS3_14","024_3_14","ISA","3","14","14","Jehovah entereth into judgment with the elders of his people, and their princes: “So then ye have consumed the vineyard; The plunder of the poor is in your houses! ");
INSERT INTO engnoy_vpl VALUES ("IS3_15","024_3_15","ISA","3","15","15","What mean ye, that ye crush my people, And grind the faces of the poor?” Saith Jehovah, the Lord of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS3_16","024_3_16","ISA","3","16","16","Thus, also, saith Jehovah: Because the daughters of Zion are haughty, And walk with outstretched necks, And glance their eyes wantonly, Mincing their steps as they go, And tinkling with their foot-clasps, ");
INSERT INTO engnoy_vpl VALUES ("IS3_17","024_3_17","ISA","3","17","17","Therefore will the Lord make their heads bald, And Jehovah will expose their nakedness. ");
INSERT INTO engnoy_vpl VALUES ("IS3_18","024_3_18","ISA","3","18","18","In that day shall the Lord take from them The ornaments of the foot-clasps, and the net-works, and the crescents; ");
INSERT INTO engnoy_vpl VALUES ("IS3_19","024_3_19","ISA","3","19","19","The ear-rings, and the bracelets, and the veils; ");
INSERT INTO engnoy_vpl VALUES ("IS3_20","024_3_20","ISA","3","20","20","The turbans, and the ankle-chains, and the belts; The perfume-boxes, and the amulets; ");
INSERT INTO engnoy_vpl VALUES ("IS3_21","024_3_21","ISA","3","21","21","The finger-rings, and the nose-jewels; ");
INSERT INTO engnoy_vpl VALUES ("IS3_22","024_3_22","ISA","3","22","22","The embroidered robes, and the tunics, and the cloaks, and the purses; ");
INSERT INTO engnoy_vpl VALUES ("IS3_23","024_3_23","ISA","3","23","23","The mirrors, and the linen shifts, and the head-bands, and the large veils. ");
INSERT INTO engnoy_vpl VALUES ("IS3_24","024_3_24","ISA","3","24","24","And instead of perfume there shall be corruption; Instead of a belt, a rope; Instead of curled locks, baldness; Instead of a wide mantle, a covering of sackcloth; Fire-scars instead of beauty. ");
INSERT INTO engnoy_vpl VALUES ("IS3_25","024_3_25","ISA","3","25","25","Thy men shall fall by the sword, Yea, thy mighty men in battle; ");
INSERT INTO engnoy_vpl VALUES ("IS3_26","024_3_26","ISA","3","26","26","Her gates shall lament and mourn, And she, being desolate, shall sit upon the ground. ");
INSERT INTO engnoy_vpl VALUES ("IS4_1","024_4_1","ISA","4","1","1","In that day shall seven women lay hold of one man saying: We will eat our own bread, And wear our own garments, Only let us be called by thy name, And take away our reproach! ");
INSERT INTO engnoy_vpl VALUES ("IS4_2","024_4_2","ISA","4","2","2","In that day shall the increase of Jehovah be glorious and honorable, And the fruit of the land excellent and beautiful, For them that have escaped of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS4_3","024_4_3","ISA","4","3","3","All that remain in Zion, And all that are left in Jerusalem, Shall be called holy; Every one that is written down for life in Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS4_4","024_4_4","ISA","4","4","4","When the Lord shall have washed away the filth of the daughters of Zion, And have removed the blood of Jerusalem from the midst of her, By a spirit of judgment and a spirit of destruction, ");
INSERT INTO engnoy_vpl VALUES ("IS4_5","024_4_5","ISA","4","5","5","Then shall Jehovah create upon the whole extent of mount Zion, and upon her places of assembly, A cloud and smoke by day, And the brightness of a flaming fire by night; Yea, for all that is glorious there shall be a shelter; ");
INSERT INTO engnoy_vpl VALUES ("IS4_6","024_4_6","ISA","4","6","6","There shall be a tent by day for a shadow from the heat, And for a refuge and shelter from the storm and rain. ");
INSERT INTO engnoy_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","1","Let me sing now a song respecting my friend, A song respecting my friend touching his vineyard. My friend had a vineyard On a very fruitful hill; ");
INSERT INTO engnoy_vpl VALUES ("IS5_2","024_5_2","ISA","5","2","2","He digged it, and cleared it of stones, And planted it with the choicest vine, And built a tower in the midst of it, And hewed out a wine-press therein; Then he looked that it should bring forth its grapes, But it brought forth sour grapes. ");
INSERT INTO engnoy_vpl VALUES ("IS5_3","024_5_3","ISA","5","3","3","And now, O inhabitants of Jerusalem, and men of Judah, Judge ye between me and my vineyard! ");
INSERT INTO engnoy_vpl VALUES ("IS5_4","024_5_4","ISA","5","4","4","What could have been done for my vineyard That I have not done for it? Why, then, when I looked that it should bring forth its grapes, Brought it forth sour grapes? ");
INSERT INTO engnoy_vpl VALUES ("IS5_5","024_5_5","ISA","5","5","5","But come now, and I will tell you What I mean to do with my vineyard. I will take away its hedge, and it shall be eaten up; I will break down its wall, and it shall be trodden down! ");
INSERT INTO engnoy_vpl VALUES ("IS5_6","024_5_6","ISA","5","6","6","And I will make it a waste; It shall not be pruned, nor digged, But shall grow up into thorns and briers; I will also command the clouds That they shed no rain upon it. ");
INSERT INTO engnoy_vpl VALUES ("IS5_7","024_5_7","ISA","5","7","7","The vineyard of Jehovah of hosts is the house of Israel, And the men of Judah the plant of his delight. He looked for justice, and behold, bloodshed! For righteousness, and behold, outcry! ");
INSERT INTO engnoy_vpl VALUES ("IS5_8","024_5_8","ISA","5","8","8","Woe to them that join house to house, That add field to field, Till there is no place left, And they dwell alone in the land. ");
INSERT INTO engnoy_vpl VALUES ("IS5_9","024_5_9","ISA","5","9","9","To mine ear hath Jehovah of hosts revealed it: Surely many houses shall become a desolation, The great and the fair ones, without an inhabitant. ");
INSERT INTO engnoy_vpl VALUES ("IS5_10","024_5_10","ISA","5","10","10","Yea, ten acres of vineyard shall yield a single bath of wine, And a homer of seed shall produce but an ephah. ");
INSERT INTO engnoy_vpl VALUES ("IS5_11","024_5_11","ISA","5","11","11","Woe to them that rise early in the morning to follow strong drink,—Who sit late in the night that wine may inflame them! ");
INSERT INTO engnoy_vpl VALUES ("IS5_12","024_5_12","ISA","5","12","12","And the lyre and the harp, the tabret and the pipe, and wine, are at their feasts, But they regard not the work of Jehovah, Nor attend to the operation of his hands. ");
INSERT INTO engnoy_vpl VALUES ("IS5_13","024_5_13","ISA","5","13","13","Therefore shall my people be led captive, when they think not of it; Their honorable men shall be famished with hunger, And their rich men parched with thirst. ");
INSERT INTO engnoy_vpl VALUES ("IS5_14","024_5_14","ISA","5","14","14","Therefore doth the under-world enlarge its greedy throat, And stretch open its mouth without measure, And down go her nobility and her wealth, Her busy throng, and all that was joyful within her. ");
INSERT INTO engnoy_vpl VALUES ("IS5_15","024_5_15","ISA","5","15","15","The mean man shall be bowed down, And the great man shall be brought low, And the eyes of the haughty shall be humbled; ");
INSERT INTO engnoy_vpl VALUES ("IS5_16","024_5_16","ISA","5","16","16","Jehovah of hosts shall be exalted through judgment; Yea, God, the Holy One, shall be sanctified through righteousness. ");
INSERT INTO engnoy_vpl VALUES ("IS5_17","024_5_17","ISA","5","17","17","Then shall the lambs feed, as in their own pasture, And the deserted fields of the rich shall strangers consume. ");
INSERT INTO engnoy_vpl VALUES ("IS5_18","024_5_18","ISA","5","18","18","Woe to them that draw calamity with cords of wickedness, And punishment as with wagon-traces,— ");
INSERT INTO engnoy_vpl VALUES ("IS5_19","024_5_19","ISA","5","19","19","Who say, Let him make speed, let him hasten his work that we may see it! Let the purpose of the Holy One of Israel draw near and be fulfilled, that we may know it! ");
INSERT INTO engnoy_vpl VALUES ("IS5_20","024_5_20","ISA","5","20","20","Woe to them that call evil good, and good evil, That put darkness for light, and light for darkness, That put bitter for sweet, and sweet for bitter! ");
INSERT INTO engnoy_vpl VALUES ("IS5_21","024_5_21","ISA","5","21","21","Woe to them that are wise in their own eyes, And prudent in their own conceit! ");
INSERT INTO engnoy_vpl VALUES ("IS5_22","024_5_22","ISA","5","22","22","Woe to them that are valiant to drink wine, And men of might to mingle strong drink! ");
INSERT INTO engnoy_vpl VALUES ("IS5_23","024_5_23","ISA","5","23","23","That clear the guilty for a reward, And take away from the righteous his right! ");
INSERT INTO engnoy_vpl VALUES ("IS5_24","024_5_24","ISA","5","24","24","Therefore, as fire devours stubble, And as the withered grass sinks into the flame, So their root shall become rottenness, And their blossom shall fly up like dust. For they have despised the law of Jehovah of hosts, And contemned the word of the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS5_25","024_5_25","ISA","5","25","25","Therefore is the anger of Jehovah kindled against his people; He stretcheth forth his hand against them, and smiteth them, so that the mountains tremble, And their carcasses are as dung in the midst of the streets; For all this his anger is not turned away, But his hand is stretched out still. ");
INSERT INTO engnoy_vpl VALUES ("IS5_26","024_5_26","ISA","5","26","26","He lifteth up a banner for the nations afar off, He whistleth for them from the ends of the earth, And behold, they haste, and come swiftly. ");
INSERT INTO engnoy_vpl VALUES ("IS5_27","024_5_27","ISA","5","27","27","None among them is weary, and none stumbleth; None slumbereth nor sleepeth; The girdle of their loins is not loosed, Nor the latchet of their shoes broken. ");
INSERT INTO engnoy_vpl VALUES ("IS5_28","024_5_28","ISA","5","28","28","Their arrows are sharp, And all their bows bent; The hoofs of their horses are like flint, And their wheels like a whirlwind. ");
INSERT INTO engnoy_vpl VALUES ("IS5_29","024_5_29","ISA","5","29","29","Their roaring is like the roaring of the lion; They roar like young lions; They roar, and seize the prey; They bear it away, and none can rescue it. ");
INSERT INTO engnoy_vpl VALUES ("IS5_30","024_5_30","ISA","5","30","30","Yea, in that day shall they roar against them like the roaring of the sea; And if one look to the land, behold darkness and sorrow, And the light is darkened by its clouds. ");
INSERT INTO engnoy_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","In the year in which King Uzziah died, I saw the Lord sitting on a throne high and lifted up, and the train of his robe filled the temple. ");
INSERT INTO engnoy_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","Around him stood seraphs; each one of them had six wings; with two he covered his face, with two he covered his feet, and with two he did fly. ");
INSERT INTO engnoy_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","And one called to another, and said: Holy, holy, holy is Jehovah of hosts; The whole earth is full of his glory. ");
INSERT INTO engnoy_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","And the foundations of the thresholds were shaken with the voice of their cry. And the temple was filled with smoke. ");
INSERT INTO engnoy_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Then I said, Alas for me! I am undone! For I am a man of unclean lips, and dwell among a people of unclean lips, and mine eyes have seen the King, Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Then flew one of the seraphs to me, having in his hands a glowing stone, which he had taken with the tongs from the altar. ");
INSERT INTO engnoy_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","And he touched my mouth, and said, Behold, this toucheth thy lips, and thine iniquity is taken away, and thy sin is expiated. ");
INSERT INTO engnoy_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","And I heard the voice of the Lord, saying, Whom shall I send, and who will go for us? And I said: Behold, here am I; send me! ");
INSERT INTO engnoy_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","And he said: Go, and say thou to this people, Hear ye, indeed, but understand not; See ye, indeed, but perceive not! ");
INSERT INTO engnoy_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Make the heart of this people gross; Make their ears dull, and blind their eyes; That they may not see with their eyes, nor hear with their ears, Nor perceive with their hearts, and turn, and be healed. ");
INSERT INTO engnoy_vpl VALUES ("IS6_11","024_6_11","ISA","6","11","11","Then said I, How long, Lord? He said: Until the cities be laid waste, so that there be no inhabitant, And the houses, so that there be no man, And the land be left utterly desolate; ");
INSERT INTO engnoy_vpl VALUES ("IS6_12","024_6_12","ISA","6","12","12","Until Jehovah have removed the men far away, And there be great desolation in the land. ");
INSERT INTO engnoy_vpl VALUES ("IS6_13","024_6_13","ISA","6","13","13","And though there be a tenth part remaining in it, Even this shall again be destroyed; Yet as when the terebinth and the oak are cut down, Their stem remaineth alive, So shall a holy race be the stem of the nation. ");
INSERT INTO engnoy_vpl VALUES ("IS7_1","024_7_1","ISA","7","1","1","In the time of Ahaz, the son of Jotham, the son of Uzziah, king of Judah, Rezin, king of Syria, and Pekah, the son of Remaliah, king of Israel, came up against Jerusalem to besiege it; but he could not prevail against it. ");
INSERT INTO engnoy_vpl VALUES ("IS7_2","024_7_2","ISA","7","2","2","And when it was told the house of David, that the Syrians had encamped in Ephraim, his heart was moved, and the hearts of his people, as the trees of the forest are moved with the wind. ");
INSERT INTO engnoy_vpl VALUES ("IS7_3","024_7_3","ISA","7","3","3","Then said Jehovah to Isaiah, Go forth to meet Ahaz, thou and Shear-Jashub thy son, at the end of the aqueduct of the upper pool, in the way to the fuller's field; ");
INSERT INTO engnoy_vpl VALUES ("IS7_4","024_7_4","ISA","7","4","4","and say to him: Take heed, and be quiet! Fear not, neither let thy heart he faint On account of the two tails of these smoking firebrands, On account of the fierce wrath of Rezin with the Syrians, and of the son of Remaliah, ");
INSERT INTO engnoy_vpl VALUES ("IS7_5","024_7_5","ISA","7","5","5","Because Syria deviseth evil against thee, Ephraim and the son of Remaliah, saying, ");
INSERT INTO engnoy_vpl VALUES ("IS7_6","024_7_6","ISA","7","6","6","“Let us go up against Judah, and besiege the city, And take it, And set a king in the midst of it, Even the son of Tabeal.” ");
INSERT INTO engnoy_vpl VALUES ("IS7_7","024_7_7","ISA","7","7","7","Thus saith the Lord Jehovah: “It shall not stand, neither shall it be; ");
INSERT INTO engnoy_vpl VALUES ("IS7_8","024_7_8","ISA","7","8","8","But the head of Syria shall still be Damascus, And the head of Damascus, Rezin; And within threescore and five years shall Ephraim be broken, that he be no more a people. ");
INSERT INTO engnoy_vpl VALUES ("IS7_9","024_7_9","ISA","7","9","9","And the head of Ephraim shall still be Samaria, And the head of Samaria, the son of Remaliah. If ye will not believe, neither shall ye thrive.” ");
INSERT INTO engnoy_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Jehovah spake also again to Ahaz: ");
INSERT INTO engnoy_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Ask thee a sign of Jehovah, thy God; Ask it from below, or in the height above!” ");
INSERT INTO engnoy_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","And Ahaz said, I will not ask; I will not tempt Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Then he said, Hear ye now, O house of David! Is it too small a thing for you to weary men, That ye should weary my God also? ");
INSERT INTO engnoy_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Therefore shall Jehovah himself give you a sign: Behold, the damsel shall conceive, and bear a son, And she shall call his name Immanuel. ");
INSERT INTO engnoy_vpl VALUES ("IS7_15","024_7_15","ISA","7","15","15","Milk and honey shall he eat, Until he learn to refuse the evil, and choose the good; ");
INSERT INTO engnoy_vpl VALUES ("IS7_16","024_7_16","ISA","7","16","16","For before this child shall have learned to refuse the evil and choose the good, The land shall become desolate, On account of whose two kings thou art in terror. ");
INSERT INTO engnoy_vpl VALUES ("IS7_17","024_7_17","ISA","7","17","17","Yet Jehovah shall bring upon thee, and upon thy people, and upon thy father's house, Days such as have not been Since Ephraim revolted from Judah. Even the king of Assyria. ");
INSERT INTO engnoy_vpl VALUES ("IS7_18","024_7_18","ISA","7","18","18","And it shall come to pass in that day That Jehovah shall whistle for the fly that is at the end of the streams of Egypt, And the bee that is in the land of Assyria, ");
INSERT INTO engnoy_vpl VALUES ("IS7_19","024_7_19","ISA","7","19","19","And they shall come, and light all of them In the desolate valleys, and fissures of the rocks, And upon all hedges, and upon all pastures. ");
INSERT INTO engnoy_vpl VALUES ("IS7_20","024_7_20","ISA","7","20","20","In that day shall Jehovah shave, with a razor hired beyond the river, with the king of Assyria, The head, and the hair of the feet; Yea, even the beard shall he take away. ");
INSERT INTO engnoy_vpl VALUES ("IS7_21","024_7_21","ISA","7","21","21","And it shall come to pass in that day, That a man shall keep a young cow, and two sheep; ");
INSERT INTO engnoy_vpl VALUES ("IS7_22","024_7_22","ISA","7","22","22","And for the abundance of milk which they produce, shall he eat cheese; For milk and honey shall all eat Who are left in the land, ");
INSERT INTO engnoy_vpl VALUES ("IS7_23","024_7_23","ISA","7","23","23","And it shall come to pass in that day, That every place where stood a thousand vines, worth a thousand shekels of silver, Shall be covered with briers and thorns. ");
INSERT INTO engnoy_vpl VALUES ("IS7_24","024_7_24","ISA","7","24","24","With arrows and with bows shall men go thither; For all the land shall become briers and thorns. ");
INSERT INTO engnoy_vpl VALUES ("IS7_25","024_7_25","ISA","7","25","25","All the hills that were digged with the mattock Shall no one approach through fear of briers and thorns; They shall be for the pasturage of oxen, And the trampling of sheep. ");
INSERT INTO engnoy_vpl VALUES ("IS8_1","024_8_1","ISA","8","1","1","And Jehovah said to me, Take thee a great tablet, and with a man's writing-instrument write on it, Hasteth-the-prey, Speedeth-the-spoil. ");
INSERT INTO engnoy_vpl VALUES ("IS8_2","024_8_2","ISA","8","2","2","And I took with me faithful witnesses, Uriah the priest, and Zechariah, the son of Berechiah. ");
INSERT INTO engnoy_vpl VALUES ("IS8_3","024_8_3","ISA","8","3","3","I went in to the prophetess, and she conceived and bore a son. Then said Jehovah to me, Call his name, Hasteth-the-prey, Speedeth-the-spoil. ");
INSERT INTO engnoy_vpl VALUES ("IS8_4","024_8_4","ISA","8","4","4","For before the child shall learn to say, My father, and My mother, the riches of Damascus and the spoil of Samaria shall be borne away before the king of Assyria. ");
INSERT INTO engnoy_vpl VALUES ("IS8_5","024_8_5","ISA","8","5","5","Moreover, Jehovah spake to me again, saying: ");
INSERT INTO engnoy_vpl VALUES ("IS8_6","024_8_6","ISA","8","6","6","Because this people despiseth The soft-flowing waters of Siloah, And rejoiceth in Rezin, and the son of Remaliah, ");
INSERT INTO engnoy_vpl VALUES ("IS8_7","024_8_7","ISA","8","7","7","Therefore, behold, the Lord bringeth upon them the strong and mighty waters of the river; The king of Assyria and all his glory. He shall rise above all his channels, And go over all his banks. ");
INSERT INTO engnoy_vpl VALUES ("IS8_8","024_8_8","ISA","8","8","8","And he shall pass through Judah, overflowing and spreading; Even to the neck shall he reach, And his stretched-out wings shall fill the whole breadth of thy land, O Immanuel! ");
INSERT INTO engnoy_vpl VALUES ("IS8_9","024_8_9","ISA","8","9","9","Rage, ye nations, and despair! Give ear, all ye distant parts of the earth! Gird yourselves, and despair! Gird yourselves, and despair! ");
INSERT INTO engnoy_vpl VALUES ("IS8_10","024_8_10","ISA","8","10","10","Form your plan, and it shall come to naught; Give the command, and it shall not stand; For God is with us. ");
INSERT INTO engnoy_vpl VALUES ("IS8_11","024_8_11","ISA","8","11","11","For thus spake Jehovah to me with a strong hand, Instructing me not to walk in the way of this people: ");
INSERT INTO engnoy_vpl VALUES ("IS8_12","024_8_12","ISA","8","12","12","Call not everything a confederacy which this people calleth a confederacy; Fear ye not what they fear, Neither be afraid! ");
INSERT INTO engnoy_vpl VALUES ("IS8_13","024_8_13","ISA","8","13","13","Jehovah of hosts, sanctify ye him; Let him be your fear, and let him be your dread! ");
INSERT INTO engnoy_vpl VALUES ("IS8_14","024_8_14","ISA","8","14","14","And he shall be to you a sanctuary; But a stone of stumbling, and a rock to strike against, To the two houses of Israel, A trap and a snare to the inhabitants of Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS8_15","024_8_15","ISA","8","15","15","And many among them shall stumble; They shall fall, and be broken; They shall be ensnared and taken. ");
INSERT INTO engnoy_vpl VALUES ("IS8_16","024_8_16","ISA","8","16","16","Bind up the revelation, Seal the word, with my disciples! ");
INSERT INTO engnoy_vpl VALUES ("IS8_17","024_8_17","ISA","8","17","17","I will, therefore, wait for Jehovah, Who now hideth his face from the house of Jacob; Yet will I look for him. ");
INSERT INTO engnoy_vpl VALUES ("IS8_18","024_8_18","ISA","8","18","18","Behold, I, and the children which Jehovah hath given me, Are signs and tokens in Israel From Jehovah of hosts, who dwelleth upon mount Zion. ");
INSERT INTO engnoy_vpl VALUES ("IS8_19","024_8_19","ISA","8","19","19","And when they shall say to you, “Inquire of the necromancers and the wizards, That chirp, and that murmur,” Then say ye, “Should not a people inquire of their God? Should they inquire of the dead for the living?” ");
INSERT INTO engnoy_vpl VALUES ("IS8_20","024_8_20","ISA","8","20","20","To the word, to the revelation! If they speak not according to this, For them no bright morning shall arise. ");
INSERT INTO engnoy_vpl VALUES ("IS8_21","024_8_21","ISA","8","21","21","They shall pass through the land distressed and famished; And when they are famished, they shall be enraged, and curse their king and their God, And look upward. ");
INSERT INTO engnoy_vpl VALUES ("IS8_22","024_8_22","ISA","8","22","22","And if they look to the earth, Behold distress and darkness, fearful darkness! And into darkness shall they be driven. ");
INSERT INTO engnoy_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","But the darkness shall not remain where now is distress; Of old he brought the land of Zebulon and the land of Naphtali into contempt; In future times shall he bring the land of the sea beyond Jordan, the circle of the gentiles, into honor. ");
INSERT INTO engnoy_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","The people that walk in darkness behold a great light; They who dwell in the land of death-like shade, Upon them a light shineth. ");
INSERT INTO engnoy_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Thou enlargest the nation; Thou increasest their joy; They rejoice before thee with the joy of harvest, With the joy of those who divide the spoil. ");
INSERT INTO engnoy_vpl VALUES ("IS9_4","024_9_4","ISA","9","4","4","For thou breakest their heavy yoke, And the rod that smote their backs, And the scourge of the taskmaster, As in the day of Midian. ");
INSERT INTO engnoy_vpl VALUES ("IS9_5","024_9_5","ISA","9","5","5","For every greave of the warrior in battle, And the war-garment rolled in blood, Shall be burned; yea, it shall be food for the fire. ");
INSERT INTO engnoy_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","For to us a child is born, To us a son is given, And the government shall be upon his shoulder, And he shall be called Wonderful, counsellor, mighty potentate, Everlasting father, prince of peace; ");
INSERT INTO engnoy_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","His dominion shall be great, And peace without end shall be upon the throne of David and his kingdom, To fix and establish it Through justice and equity, Henceforth and forever. The zeal of Jehovah of hosts will do this. ");
INSERT INTO engnoy_vpl VALUES ("IS9_8","024_9_8","ISA","9","8","8","The Lord sendeth a word against Jacob; It cometh down to Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS9_9","024_9_9","ISA","9","9","9","His whole people shall feel it, Ephraim, and the inhabitants of Samaria, Who say in pride and arrogance of heart, ");
INSERT INTO engnoy_vpl VALUES ("IS9_10","024_9_10","ISA","9","10","10","“The bricks are fallen down, but we will build with hewn stones; The sycamores are cut down, but we will replace them with cedars.” ");
INSERT INTO engnoy_vpl VALUES ("IS9_11","024_9_11","ISA","9","11","11","Jehovah will raise up the enemies of Rezin against them, And will arm their adversaries; ");
INSERT INTO engnoy_vpl VALUES ("IS9_12","024_9_12","ISA","9","12","12","The Syrians before, the Philistines behind, Who shall devour Israel with wide jaws. For all this his anger is not turned away, But his hand is stretched out still. ");
INSERT INTO engnoy_vpl VALUES ("IS9_13","024_9_13","ISA","9","13","13","The people turn not to him that smiteth them; Neither do they seek Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS9_14","024_9_14","ISA","9","14","14","Therefore shall Jehovah cut off from Israel the head and the tail, The palm-branch and the rush, in one day. ");
INSERT INTO engnoy_vpl VALUES ("IS9_15","024_9_15","ISA","9","15","15","The aged and the honorable are the head, And the prophet that speaketh falsehood is the tail. ");
INSERT INTO engnoy_vpl VALUES ("IS9_16","024_9_16","ISA","9","16","16","For the leaders of this people lead them astray, And they that are led by them go to destruction. ");
INSERT INTO engnoy_vpl VALUES ("IS9_17","024_9_17","ISA","9","17","17","Therefore shall the Lord have no joy in their young men, And on their orphans and widows he shall have no compassion; For they are all profane, and evil-doers; Every mouth speaketh folly. For all this his anger is not turned away, But his hand is stretched out still. ");
INSERT INTO engnoy_vpl VALUES ("IS9_18","024_9_18","ISA","9","18","18","For wickedness burneth like a fire, It consumeth the briers and thorns, And it kindleth the thicket of the forest, So that it goeth up in columns of smoke. ");
INSERT INTO engnoy_vpl VALUES ("IS9_19","024_9_19","ISA","9","19","19","Through the wrath of Jehovah of hosts is the land burned, And the people are food for the fire; No one spareth another. ");
INSERT INTO engnoy_vpl VALUES ("IS9_20","024_9_20","ISA","9","20","20","They consume on the right hand, and yet are hungry; They devour on the left, and are not satisfied; Every one devoureth the flesh of his arm. ");
INSERT INTO engnoy_vpl VALUES ("IS9_21","024_9_21","ISA","9","21","21","Manasseh is against Ephraim, and Ephraim against Manasseh, And both together against Judah. For all this his anger is not turned away, But his hand is stretched out still. ");
INSERT INTO engnoy_vpl VALUES ("IS10_1","024_10_1","ISA","10","1","1","Woe to them that make unrighteous decrees, That write oppressive decisions, ");
INSERT INTO engnoy_vpl VALUES ("IS10_2","024_10_2","ISA","10","2","2","To turn away the needy from judgment, And rob the poor of my people of their right; That the widows may become their prey, And that they may plunder the orphans. ");
INSERT INTO engnoy_vpl VALUES ("IS10_3","024_10_3","ISA","10","3","3","What will ye do in the day of visitation, And in the desolation which cometh from afar? To whom will ye flee for help, And where will ye leave your glory? ");
INSERT INTO engnoy_vpl VALUES ("IS10_4","024_10_4","ISA","10","4","4","Forsaken by me, they shall sink down among the prisoners, And fall among the slain. For all this his anger is not turned away, But his hand is stretched out still. ");
INSERT INTO engnoy_vpl VALUES ("IS10_5","024_10_5","ISA","10","5","5","Woe to the Assyrian, the rod of mine anger, The staff in whose hands is the instrument of my indignation! ");
INSERT INTO engnoy_vpl VALUES ("IS10_6","024_10_6","ISA","10","6","6","Against an impious nation I will send him, And against a people under my wrath I will give him a charge To gather the spoil, and seize the prey, And to trample them under foot like the mire of the streets. ");
INSERT INTO engnoy_vpl VALUES ("IS10_7","024_10_7","ISA","10","7","7","But he doth not so purpose, And his heart doth not so intend; But to destroy is in his heart, And to cut off a multitude of nations. ");
INSERT INTO engnoy_vpl VALUES ("IS10_8","024_10_8","ISA","10","8","8","For he saith, “Are not my princes altogether kings? ");
INSERT INTO engnoy_vpl VALUES ("IS10_9","024_10_9","ISA","10","9","9","Is not Calno as Carchemish? Is not Hamath as Arpad? Is not Samaria as Damascus? ");
INSERT INTO engnoy_vpl VALUES ("IS10_10","024_10_10","ISA","10","10","10","As my hand hath seized the kingdoms of the idols, Whose graven images were more numerous than those of Jerusalem and Samaria, ");
INSERT INTO engnoy_vpl VALUES ("IS10_11","024_10_11","ISA","10","11","11","Behold! as I have done to Samaria and her idols, So will I do to Jerusalem and her images.” ");
INSERT INTO engnoy_vpl VALUES ("IS10_12","024_10_12","ISA","10","12","12","But when the Lord hath accomplished his whole work upon Mount Zion and Jerusalem, Then will he punish the fruit of the proud heart of the king of Assyria, And the arrogance of his lofty eyes. ");
INSERT INTO engnoy_vpl VALUES ("IS10_13","024_10_13","ISA","10","13","13","For he hath said: “By the strength of my hand I have done it, And by my wisdom; for I am wise; I have removed the bounds of nations, I have plundered their treasures; As a hero have I brought down them that sat upon thrones. ");
INSERT INTO engnoy_vpl VALUES ("IS10_14","024_10_14","ISA","10","14","14","The riches of the nations hath my hand seized, as a nest; As one gathereth eggs that have been left, So have I gathered the whole world. And there was none that moved the wing, Or that opened the beak, or that chirped.” ");
INSERT INTO engnoy_vpl VALUES ("IS10_15","024_10_15","ISA","10","15","15","Shall the axe boast itself against him that heweth with it? Or shall the saw magnify itself against him that moveth it? As if the rod should wield him that lifteth it! As if the staff should lift up him that is not wood! ");
INSERT INTO engnoy_vpl VALUES ("IS10_16","024_10_16","ISA","10","16","16","Wherefore the Lord, the Lord of hosts, shall send upon his fat ones leanness, And under his glory shall he kindle a burning, like the burning of a fire. ");
INSERT INTO engnoy_vpl VALUES ("IS10_17","024_10_17","ISA","10","17","17","The light of Israel shall be a fire, And his Holy One a flame, Which shall burn and devour his thorns and briers in one day. ");
INSERT INTO engnoy_vpl VALUES ("IS10_18","024_10_18","ISA","10","18","18","The glory of his forest and of his fruitful field From the spirit even to the flesh shall he consume; It shall be with them as when a sick man fainteth. ");
INSERT INTO engnoy_vpl VALUES ("IS10_19","024_10_19","ISA","10","19","19","The remaining trees of the forest shall be few, So that a child may write them down. ");
INSERT INTO engnoy_vpl VALUES ("IS10_20","024_10_20","ISA","10","20","20","In that day shall the remnant of Israel, and they that have escaped of the house of Jacob, no more lean upon him that smote them; They shall lean upon Jehovah, the Holy One of Israel, in truth. ");
INSERT INTO engnoy_vpl VALUES ("IS10_21","024_10_21","ISA","10","21","21","The remnant shall return, the remnant of Jacob, to the mighty Potentate; ");
INSERT INTO engnoy_vpl VALUES ("IS10_22","024_10_22","ISA","10","22","22","For though thy people, O Israel, be as the sand of the sea, Only a remnant of them shall return. The devastation is decreed; It shall overflow with righteousness. ");
INSERT INTO engnoy_vpl VALUES ("IS10_23","024_10_23","ISA","10","23","23","For devastation and punishment doth the Lord, Jehovah of hosts, execute in the midst of the whole land, ");
INSERT INTO engnoy_vpl VALUES ("IS10_24","024_10_24","ISA","10","24","24","Yet thus saith the Lord, Jehovah of hosts: Fear not, O my people, that dwellest in Zion, because of the Assyrian! With his rod indeed shall he smite thee, And lift up his staff against thee in the manner of Egypt; ");
INSERT INTO engnoy_vpl VALUES ("IS10_25","024_10_25","ISA","10","25","25","But yet a very little while, and my indignation shall have past, And my anger shall destroy them. ");
INSERT INTO engnoy_vpl VALUES ("IS10_26","024_10_26","ISA","10","26","26","Jehovah of hosts shall raise up against him a scourge, As he smote Midian at the rock of Horeb, And as he lifted up the rod against the sea; Yea, he shall lift it up, as in Egypt. ");
INSERT INTO engnoy_vpl VALUES ("IS10_27","024_10_27","ISA","10","27","27","In that day shall his burden be removed from thy shoulder, And his yoke from thy neck; Yea, thy yoke shall be broken, as that of a fat steer. ");
INSERT INTO engnoy_vpl VALUES ("IS10_28","024_10_28","ISA","10","28","28","He is come to Aiath; he passeth through Migron; In Michmash he leaveth his baggage; ");
INSERT INTO engnoy_vpl VALUES ("IS10_29","024_10_29","ISA","10","29","29","They pass the strait; At Geba they make their night-quarters; Ramah trembleth; Gibeah of Saul fleeth. ");
INSERT INTO engnoy_vpl VALUES ("IS10_30","024_10_30","ISA","10","30","30","Cry aloud, O daughter of Gallim! Hear, O Laish! Alas, poor Anathoth! ");
INSERT INTO engnoy_vpl VALUES ("IS10_31","024_10_31","ISA","10","31","31","Madmenah hasteth away; The inhabitants of Gebim take to flight. ");
INSERT INTO engnoy_vpl VALUES ("IS10_32","024_10_32","ISA","10","32","32","Yet one day shall he rest at Nob, Then shall he shake his hand against the mount of the daughter of Zion, The hill of Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS10_33","024_10_33","ISA","10","33","33","But behold! the Lord, Jehovah of hosts, shall lop the branches with fearful force, And the high of stature shall be cut down, And the lofty shall be brought low. ");
INSERT INTO engnoy_vpl VALUES ("IS10_34","024_10_34","ISA","10","34","34","He shall hew the thickets of the forest with iron, And Lebanon shall fall by a mighty hand. ");
INSERT INTO engnoy_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Then shall spring forth a shoot from the stem of Jesse, And a sprout grow up from his roots. ");
INSERT INTO engnoy_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","The spirit of Jehovah shall rest upon him, The spirit of wisdom and understanding, The spirit of counsel and might, The spirit of the knowledge and of the fear of Jehovah, ");
INSERT INTO engnoy_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","He shall take delight in the fear of Jehovah; He shall not judge by the sight of his eyes, Nor decide by the hearing of his ears. ");
INSERT INTO engnoy_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","But with righteousness shall he judge the poor, And decide with equity for the afflicted of the land; He shall smite the earth with the rod of his mouth; With the breath of his lips shall he slay the wicked. ");
INSERT INTO engnoy_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Righteousness shall be the girdle of his loins, And faithfulness the girdle of his reins. ");
INSERT INTO engnoy_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","Then shall the wolf dwell with the lamb, And the leopard shall lie down with the kid; The calf, and the young lion, and the fatling shall be together, And a little child shall lead them. ");
INSERT INTO engnoy_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","The cow and the bear shall feed together, Together shall their young lie down, And the lion shall eat straw like the ox. ");
INSERT INTO engnoy_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","The suckling shall play upon the hole of the asp, And the near-weaned child lay his hand on the hiding-place of the basilisk. ");
INSERT INTO engnoy_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","They shall not hurt nor destroy in all my holy mountain; For the land shall be full of the knowledge of Jehovah, As the waters cover the depths of the sea. ");
INSERT INTO engnoy_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","In that day shall the shoot of Jesse stand as a banner to the nations, And to him shall the gentiles repair, And his dwelling-place shall be glorious. ");
INSERT INTO engnoy_vpl VALUES ("IS11_11","024_11_11","ISA","11","11","11","In that day shall Jehovah the second time stretch forth his hand To recover the remnant of his people, That remaineth, from Assyria, and from Egypt, And from Pathros, and from Ethiopia, and from Elam, And from Shinar, and from Hamath, And from the islands of the sea. ");
INSERT INTO engnoy_vpl VALUES ("IS11_12","024_11_12","ISA","11","12","12","He shall set up a banner to the nations, And gather the outcasts of Israel, And bring together the dispersed of Judah, From the four extremities of the earth. ");
INSERT INTO engnoy_vpl VALUES ("IS11_13","024_11_13","ISA","11","13","13","Then shall the jealousy of Ephraim depart, And the enmity in Judah be at an end; Ephraim shall not be jealous of Judah, And Judah shall not contend with Ephraim. ");
INSERT INTO engnoy_vpl VALUES ("IS11_14","024_11_14","ISA","11","14","14","But they shall fly upon the shoulders of the Philistines at the sea; Together shall they plunder the children of the East; On Edom and Moab shall they lay their hand, And the sons of Ammon shall be subject to them. ");
INSERT INTO engnoy_vpl VALUES ("IS11_15","024_11_15","ISA","11","15","15","Then will Jehovah utterly destroy the tongue of the Egyptian sea, And shake his hand over the river with a mighty wind, And smite it into seven streams, So that men may go over it dry-shod. ");
INSERT INTO engnoy_vpl VALUES ("IS11_16","024_11_16","ISA","11","16","16","And it shall be a highway for the remnant of the people, Which shall remain, from Assyria, As there was to Israel, When he came up from the land of Egypt. ");
INSERT INTO engnoy_vpl VALUES ("IS12_1","024_12_1","ISA","12","1","1","In that day shalt thou say, “I will praise thee, O Jehovah, for, though thou hast been angry with me, Thine anger is turned away, and thou comfortest me. ");
INSERT INTO engnoy_vpl VALUES ("IS12_2","024_12_2","ISA","12","2","2","Behold, God is my salvation; I will trust, and will not be afraid; For Jehovah is my glory, and my song; It is he who was my salvation.” ");
INSERT INTO engnoy_vpl VALUES ("IS12_3","024_12_3","ISA","12","3","3","Ye shall draw waters with joy from the fountains of salvation; ");
INSERT INTO engnoy_vpl VALUES ("IS12_4","024_12_4","ISA","12","4","4","And in that day ye shall say, “Give thanks to Jehovah; call upon his name; Make known his deeds among the people; Give praises, for his name is exalted! ");
INSERT INTO engnoy_vpl VALUES ("IS12_5","024_12_5","ISA","12","5","5","Sing to Jehovah, for he hath done glorious things; Be this known in all the earth! ");
INSERT INTO engnoy_vpl VALUES ("IS12_6","024_12_6","ISA","12","6","6","Cry aloud, shout for joy, O inhabitant of Zion, For great is the Holy One of Israel in the midst of thee!” ");
INSERT INTO engnoy_vpl VALUES ("IS13_1","024_13_1","ISA","13","1","1","A prophecy concerning Babylon, which Isaiah, the son of Amoz, saw. ");
INSERT INTO engnoy_vpl VALUES ("IS13_2","024_13_2","ISA","13","2","2","Upon the bare mountain lift up a banner; Cry aloud to them, wave the hand, That they may enter the gates of the tyrants! ");
INSERT INTO engnoy_vpl VALUES ("IS13_3","024_13_3","ISA","13","3","3","I have given orders to my consecrated ones, Yea, I have called upon my mighty ones to execute mine anger, My proud exulters! ");
INSERT INTO engnoy_vpl VALUES ("IS13_4","024_13_4","ISA","13","4","4","The noise of a multitude upon the mountains, like that of a great people! The tumultuous noise of kingdoms, of nations gathered together! Jehovah of hosts mustereth his army for battle. ");
INSERT INTO engnoy_vpl VALUES ("IS13_5","024_13_5","ISA","13","5","5","They come from a distant country, From the end of Heaven, Jehovah and the instruments of his indignation. To lay waste the whole land. ");
INSERT INTO engnoy_vpl VALUES ("IS13_6","024_13_6","ISA","13","6","6","Howl ye, for the day of Jehovah is at hand! Like a destruction from the Almighty, it cometh; ");
INSERT INTO engnoy_vpl VALUES ("IS13_7","024_13_7","ISA","13","7","7","Therefore shall all hands hang down, And every heart of man shall melt. ");
INSERT INTO engnoy_vpl VALUES ("IS13_8","024_13_8","ISA","13","8","8","They shall be in consternation; Distress and anguish shall lay hold of them; As a woman in travail shall they writhe; They shall look upon one another with amazement: Their faces shall glow like flames. ");
INSERT INTO engnoy_vpl VALUES ("IS13_9","024_13_9","ISA","13","9","9","Behold! the day of Jehovah cometh, Terrible, full of wrath and burning indignation, To make the land a waste, And to destroy the sinners out of it. ");
INSERT INTO engnoy_vpl VALUES ("IS13_10","024_13_10","ISA","13","10","10","For the stars of heaven, and the constellations thereof, Shall not give their light; The sun shall be darkened at his going forth, And the moon shall withhold her light. ");
INSERT INTO engnoy_vpl VALUES ("IS13_11","024_13_11","ISA","13","11","11","For I will punish the world for its guilt, And the wicked for their iniquity. I will put an end to the arrogance of the proud, And I will bring down the haughtiness of the tyrants. ");
INSERT INTO engnoy_vpl VALUES ("IS13_12","024_13_12","ISA","13","12","12","I will make men scarcer than gold; Yea, men than the gold of Ophir. ");
INSERT INTO engnoy_vpl VALUES ("IS13_13","024_13_13","ISA","13","13","13","Therefore I will make the heavens tremble, And the earth shall be shaken out of her place, In the anger of Jehovah of hosts, In the day of his burning indignation. ");
INSERT INTO engnoy_vpl VALUES ("IS13_14","024_13_14","ISA","13","14","14","Then shall they be like a chased doe; Like a flock, which no one gathereth together; Every one shall turn to his own people, And every one flee to his own land. ");
INSERT INTO engnoy_vpl VALUES ("IS13_15","024_13_15","ISA","13","15","15","Every one that is overtaken shall be thrust through, And every one that is caught shall fall by the sword. ");
INSERT INTO engnoy_vpl VALUES ("IS13_16","024_13_16","ISA","13","16","16","Their children shall be dashed to pieces before their eyes; Their houses shall be plundered, and their wives ravished. ");
INSERT INTO engnoy_vpl VALUES ("IS13_17","024_13_17","ISA","13","17","17","Behold, I stir up against them the Medes, Who make no account of silver, And as to gold, they do not regard it. ");
INSERT INTO engnoy_vpl VALUES ("IS13_18","024_13_18","ISA","13","18","18","Their bows shall strike down the young men, And on the fruit of the womb they shall have no compassion; Their eye shall not pity the children. ");
INSERT INTO engnoy_vpl VALUES ("IS13_19","024_13_19","ISA","13","19","19","So shall Babylon, the glory of kingdoms, The proud ornament of the Chaldeans, Be like Sodom and Gomorrah, which God overthrew, ");
INSERT INTO engnoy_vpl VALUES ("IS13_20","024_13_20","ISA","13","20","20","It shall never more be inhabited; Nor shall it be dwelt in through all generations. Nor shall the Arabian pitch his tent there, Nor shall shepherds make their folds there. ");
INSERT INTO engnoy_vpl VALUES ("IS13_21","024_13_21","ISA","13","21","21","But there shall the wild beasts of the desert lodge, And owls shall fill their houses; And ostriches shall dwell there, And satyrs shall dance there. ");
INSERT INTO engnoy_vpl VALUES ("IS13_22","024_13_22","ISA","13","22","22","Wolves shall howl in their palaces, And jackals in their pleasant edifices. Her time is near, And her days shall not be prolonged. ");
INSERT INTO engnoy_vpl VALUES ("IS14_1","024_14_1","ISA","14","1","1","For Jehovah will have compassion upon Jacob, And will again set his love upon Israel, And cause them to rest in his own land. And strangers shall join themselves to them, And cleave to the house of Jacob. ");
INSERT INTO engnoy_vpl VALUES ("IS14_2","024_14_2","ISA","14","2","2","The nations shall take them and bring them to their own place; And the house of Israel shall possess them, in the land of Jehovah, As servants and as handmaids; They shall take captive their captors, And they shall rule over their oppressors. ");
INSERT INTO engnoy_vpl VALUES ("IS14_3","024_14_3","ISA","14","3","3","So when Jehovah shall have given thee rest From thy sorrow and thy distress, And from the hard bondage Which was laid upon thee, ");
INSERT INTO engnoy_vpl VALUES ("IS14_4","024_14_4","ISA","14","4","4","Then shall thou utter this song over the king of Babylon, and say, “How hath the tyrant fallen, The oppression ceased! ");
INSERT INTO engnoy_vpl VALUES ("IS14_5","024_14_5","ISA","14","5","5","Jehovah hath broken the staff of the wicked, The rod of the tyrants, ");
INSERT INTO engnoy_vpl VALUES ("IS14_6","024_14_6","ISA","14","6","6","That smote the people in anger, With a continual stroke, That lorded it over the nations in wrath With unremitted oppression. ");
INSERT INTO engnoy_vpl VALUES ("IS14_7","024_14_7","ISA","14","7","7","The whole earth is at rest, is quiet; They break forth into singing. ");
INSERT INTO engnoy_vpl VALUES ("IS14_8","024_14_8","ISA","14","8","8","Even the cypress-trees exult over thee, And the cedars of Lebanon: 'Since thou art fallen, No feller cometh up against us.' ");
INSERT INTO engnoy_vpl VALUES ("IS14_9","024_14_9","ISA","14","9","9","The under-world is in commotion on account of thee, To meet thee at thy coming; It stirreth up before thee the shades, all the mighty of the earth; It arouseth from their thrones all the kings of the nations; ");
INSERT INTO engnoy_vpl VALUES ("IS14_10","024_14_10","ISA","14","10","10","They all accost thee, and say, 'Art thou, too, become weak as we? Art thou become like us?' ");
INSERT INTO engnoy_vpl VALUES ("IS14_11","024_14_11","ISA","14","11","11","Thy pomp is brought down to the grave, And the sound of thy harps. Vermin have become thy couch, And worms thy covering. ");
INSERT INTO engnoy_vpl VALUES ("IS14_12","024_14_12","ISA","14","12","12","How art thou fallen from heaven, O Lucifer, son of the morning! How art thou cast down to the ground, Thou that didst trample upon the nations! ");
INSERT INTO engnoy_vpl VALUES ("IS14_13","024_14_13","ISA","14","13","13","Thou saidst in thy heart, 'I will ascend to heaven, Above the stars of God will I exalt my throne; I will sit upon the mount of assembly in the recesses of the north. ");
INSERT INTO engnoy_vpl VALUES ("IS14_14","024_14_14","ISA","14","14","14","I will ascend above the height of the clouds; I will be like the Most High.' ");
INSERT INTO engnoy_vpl VALUES ("IS14_15","024_14_15","ISA","14","15","15","But thou art brought down to the grave, To the depths of the pit. ");
INSERT INTO engnoy_vpl VALUES ("IS14_16","024_14_16","ISA","14","16","16","They that see thee gaze upon thee, and view thee attentively, (and say,) 'Is this the man that made the earth tremble, That shook kingdoms, ");
INSERT INTO engnoy_vpl VALUES ("IS14_17","024_14_17","ISA","14","17","17","That made the world a wilderness, And laid waste its cities, And sent not his captives to their homes?' ");
INSERT INTO engnoy_vpl VALUES ("IS14_18","024_14_18","ISA","14","18","18","All the kings of the nations, yea, all of them, Lie down in glory, each in his own sepulchre; ");
INSERT INTO engnoy_vpl VALUES ("IS14_19","024_14_19","ISA","14","19","19","But thou art cast forth without a grave, Like a worthless branch; Covered with the slain, who are pierced by the sword, Who go down to the stones of the pit, Like a carcass trampled under foot. ");
INSERT INTO engnoy_vpl VALUES ("IS14_20","024_14_20","ISA","14","20","20","Thou shalt not be joined with them in the grave, Because thou hast destroyed thy country, And slain thy people; The race of evil-doers shall nevermore be named. ");
INSERT INTO engnoy_vpl VALUES ("IS14_21","024_14_21","ISA","14","21","21","Prepare ye slaughter for his children, For the iniquity of their fathers, That they may no more arise, and possess the earth, And fill the world with enemies!” ");
INSERT INTO engnoy_vpl VALUES ("IS14_22","024_14_22","ISA","14","22","22","For I will arise against them, saith Jehovah of hosts, And I will cut off from Babylon the name and remnant, Posterity and offspring, saith Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS14_23","024_14_23","ISA","14","23","23","I will make her the possession of the porcupine, and pools of water; Yea, I will sweep her away with the besom of destruction, saith Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS14_24","024_14_24","ISA","14","24","24","Jehovah of hosts hath sworn, saying, Surely, as I have devised, so shall it come to pass, The purpose which I have formed, that shall stand, ");
INSERT INTO engnoy_vpl VALUES ("IS14_25","024_14_25","ISA","14","25","25","To crush the Assyrian in my land, And to trample him on my mountains. Then shall his yoke depart from them, And his burden be removed from their shoulders. ");
INSERT INTO engnoy_vpl VALUES ("IS14_26","024_14_26","ISA","14","26","26","This is the purpose which is formed concerning all the earth, And this the hand which is stretched out over all the nations. ");
INSERT INTO engnoy_vpl VALUES ("IS14_27","024_14_27","ISA","14","27","27","For Jehovah of hosts hath decreed, and who shall disannul it? And his hand is stretched out, and who shall turn it back? ");
INSERT INTO engnoy_vpl VALUES ("IS14_28","024_14_28","ISA","14","28","28","In the year in which Ahaz the king died came this prophecy. ");
INSERT INTO engnoy_vpl VALUES ("IS14_29","024_14_29","ISA","14","29","29","Rejoice not, all Philistia, Because the rod that smote thee is broken, For from the root of a serpent shall come forth a basilisk, And his fruit shall be a flying, fiery serpent. ");
INSERT INTO engnoy_vpl VALUES ("IS14_30","024_14_30","ISA","14","30","30","Then shall the most wretched of the poor feed quietly, And the needy shall lie down in security; For I will kill thy root with famine, And thy remnant shall be slain. ");
INSERT INTO engnoy_vpl VALUES ("IS14_31","024_14_31","ISA","14","31","31","Howl, O gate! cry aloud, O city! O Philistia, thou meltest away in terror! For from the north cometh a smoke, And there is no straggler in their hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS14_32","024_14_32","ISA","14","32","32","What answer shall be given to the messengers of the nations? That Jehovah hath founded Zion, And in her shall the poor of his people find refuge. ");
INSERT INTO engnoy_vpl VALUES ("IS15_1","024_15_1","ISA","15","1","1","The prophecy concerning Moab. Yea! in the night of assault was Ar of Moab a ruin! In the night of assault was Kir of Moab a ruin! ");
INSERT INTO engnoy_vpl VALUES ("IS15_2","024_15_2","ISA","15","2","2","They go up to the temple, and to Dibon, to weep upon the high places; Upon Nebo and upon Medeba doth Moab howl; On every head is baldness, And every beard is shorn. ");
INSERT INTO engnoy_vpl VALUES ("IS15_3","024_15_3","ISA","15","3","3","In their streets they gird themselves with sackcloth; On the tops of their houses and in their public walks every one howleth, And melteth away with weeping. ");
INSERT INTO engnoy_vpl VALUES ("IS15_4","024_15_4","ISA","15","4","4","Heshbon and Elealah utter a cry; Even to Jahaz is their voice heard; Therefore the warriors of Moab shriek aloud; Their hearts tremble within them. ");
INSERT INTO engnoy_vpl VALUES ("IS15_5","024_15_5","ISA","15","5","5","My heart crieth out for Moab, Whose fugitives wander to Zoar, to Eglath-shelishijah; For they ascend the heights of Luhith weeping, And in the way of Horonaim they raise the cry of destruction. ");
INSERT INTO engnoy_vpl VALUES ("IS15_6","024_15_6","ISA","15","6","6","For the waters of Nimrim are desolate; The grass is withered; the tender plant faileth; There is no green thing left. ");
INSERT INTO engnoy_vpl VALUES ("IS15_7","024_15_7","ISA","15","7","7","Wherefore the remnant of their substance and their wealth They shall carry to the brook of willows. ");
INSERT INTO engnoy_vpl VALUES ("IS15_8","024_15_8","ISA","15","8","8","For the cry encompasseth the borders of Moab; Even to Eglaim reacheth her wailing, To Beer-Elim her howling. ");
INSERT INTO engnoy_vpl VALUES ("IS15_9","024_15_9","ISA","15","9","9","For the waters of Dimon are full of blood; For I bring new evils upon Dimon; Upon him that escapeth of Moab will I send a lion, Even upon him that remaineth in the land. ");
INSERT INTO engnoy_vpl VALUES ("IS16_1","024_16_1","ISA","16","1","1","Send ye the lambs to the ruler of the land, From Selah through the wilderness To the mount of the daughter of Zion! ");
INSERT INTO engnoy_vpl VALUES ("IS16_2","024_16_2","ISA","16","2","2","For as a wandering bird, As a forthdriven nest, So shall be the daughters of Moab At the fords of Arnon; saying, ");
INSERT INTO engnoy_vpl VALUES ("IS16_3","024_16_3","ISA","16","3","3","“Offer counsel; give decision, Make thy shadow at noonday like the darkness of night. Hide the outcasts; Betray not the fugitives. ");
INSERT INTO engnoy_vpl VALUES ("IS16_4","024_16_4","ISA","16","4","4","Let my outcasts dwell with thee, O Zion! Be thou to them a covert from the spoiler! For the extortion is at an end, The spoiling ceaseth. The oppressors are consumed from the land. ");
INSERT INTO engnoy_vpl VALUES ("IS16_5","024_16_5","ISA","16","5","5","Then shall your throne be established through mercy, And upon it shall sit in the house of David A judge searching for justice, and prompt in equity.” ");
INSERT INTO engnoy_vpl VALUES ("IS16_6","024_16_6","ISA","16","6","6","“We have beard of the pride of Moab; he is very proud; His haughtiness, and his pride, and his insolence, His vain boastings.” ");
INSERT INTO engnoy_vpl VALUES ("IS16_7","024_16_7","ISA","16","7","7","Therefore shall Moab howl for Moab; Every one shall howl; For the ruins of Kir-hares shall ye mourn, In deep affliction. ");
INSERT INTO engnoy_vpl VALUES ("IS16_8","024_16_8","ISA","16","8","8","For the fields of Heshbon languish, The lords of the nations break down the choicest shoots of the vine of Sibmah, They reached even to Jazer; they wandered into the desert; Her branches were spread out; they crossed the sea. ");
INSERT INTO engnoy_vpl VALUES ("IS16_9","024_16_9","ISA","16","9","9","Therefore I will weep, like Jazer, for the vine of Sibmah; I will water thee with my tears, O Heshbon and Elealah, For upon thy summer fruits, and thy harvest, the war-shout is fallen. ");
INSERT INTO engnoy_vpl VALUES ("IS16_10","024_16_10","ISA","16","10","10","Gladness and joy are driven from the fruitful field, And in the vineyards is no singing nor shouting; The treaders tread out no wine in their vats; I have made the vintage-shouting to cease. ");
INSERT INTO engnoy_vpl VALUES ("IS16_11","024_16_11","ISA","16","11","11","Therefore shall my bowels sound like a harp for Moab, And my inward parts for Kir-hares. ");
INSERT INTO engnoy_vpl VALUES ("IS16_12","024_16_12","ISA","16","12","12","And it shall come to pass that though Moab present himself, Though he weary himself upon his high places, And go up to his sanctuary to pray, Yet shall he not prevail. ");
INSERT INTO engnoy_vpl VALUES ("IS16_13","024_16_13","ISA","16","13","13","This is the word which Jehovah spake concerning Moab of old. ");
INSERT INTO engnoy_vpl VALUES ("IS16_14","024_16_14","ISA","16","14","14","But now saith Jehovah: Within three years, like the years of a hireling, The glory of Moab shall be put to shame, With all his great multitude; And the remnant shall be very small, and without strength. ");
INSERT INTO engnoy_vpl VALUES ("IS17_1","024_17_1","ISA","17","1","1","The prophecy concerning Damascus. Behold, Damascus shall be no more a city; It shall become a heap of ruins. ");
INSERT INTO engnoy_vpl VALUES ("IS17_2","024_17_2","ISA","17","2","2","The cities of Aroer shall be forsaken; They shall be pastures for flocks, Which shall lie down, and none shall make them afraid. ");
INSERT INTO engnoy_vpl VALUES ("IS17_3","024_17_3","ISA","17","3","3","The fortress shall cease from Ephraim, And the kingdom from Damascus, and the rest of Syria; It shall be with them as with the glory of the children of Israel, Saith Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS17_4","024_17_4","ISA","17","4","4","In that day shall the glory of Jacob sink away, And the fatness of his flesh become leanness. ");
INSERT INTO engnoy_vpl VALUES ("IS17_5","024_17_5","ISA","17","5","5","And it shall be as when the harvest-man gathereth the corn, And reapeth the ears with his arm; Yea, as when one gleaneth ears in the valley of Rephaim. ");
INSERT INTO engnoy_vpl VALUES ("IS17_6","024_17_6","ISA","17","6","6","There shall be left in it only a gleaning, as in the olive-harvest, Two or three berries on the top of the highest bough, Four or five on the fruitful branches, Saith Jehovah, the God of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS17_7","024_17_7","ISA","17","7","7","In that day shall a man have regard to his Maker, And his eyes shall look to the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS17_8","024_17_8","ISA","17","8","8","He shall not look to the altars, the work of his hands, Nor have respect to that which his fingers have made, The images of Astarte and the Sun-pillars. ");
INSERT INTO engnoy_vpl VALUES ("IS17_9","024_17_9","ISA","17","9","9","In that day shall his fortified cities be like ruins in the forests, or on the mountain tops, Which the enemy left, in flight from the children of Israel; And the land shall be a desolation. ");
INSERT INTO engnoy_vpl VALUES ("IS17_10","024_17_10","ISA","17","10","10","For thou hast forgotten the God of thy salvation, And hast not been mindful of the rock of thy strength; Therefore though thou plant beautiful plants, And set shoots from a foreign soil, ");
INSERT INTO engnoy_vpl VALUES ("IS17_11","024_17_11","ISA","17","11","11","When thou hast planted them, though thou hedge them in, And in the morning bring thy plants to the blossom, Yet shall the harvest flee away, In the day of pain and desperate sorrow. ");
INSERT INTO engnoy_vpl VALUES ("IS17_12","024_17_12","ISA","17","12","12","Alas! a tumult of many nations! They rage with the raging of the sea. Alas! a roaring of kingdoms! They roar with the roaring of mighty waters. ");
INSERT INTO engnoy_vpl VALUES ("IS17_13","024_17_13","ISA","17","13","13","Like the roaring of mighty waters do the nations roar; He rebuketh them, and they flee away, Driven like the chaff of the mountains before the wind, Like stubble before the whirlwind. ");
INSERT INTO engnoy_vpl VALUES ("IS17_14","024_17_14","ISA","17","14","14","At the time of evening, behold, terror! Before morning, behold, they are no more! This is the portion of them that spoil us, And the lot of them that plunder us. ");
INSERT INTO engnoy_vpl VALUES ("IS18_1","024_18_1","ISA","18","1","1","Ho! thou land of rustling wings, Beyond the rivers of Ethiopia! ");
INSERT INTO engnoy_vpl VALUES ("IS18_2","024_18_2","ISA","18","2","2","That sendest thy messengers upon the sea, In reed-boats upon the face of the waters: Go, ye swift messengers, to a nation tall and fair, To a people terrible from the first and onward, To a mighty, victorious people, Whose land is divided by rivers! ");
INSERT INTO engnoy_vpl VALUES ("IS18_3","024_18_3","ISA","18","3","3","All ye inhabitants of the world, ye that dwell on the earth, When the standard is lifted up on the mountains, behold! When the trumpet is sounded, hear! ");
INSERT INTO engnoy_vpl VALUES ("IS18_4","024_18_4","ISA","18","4","4","For thus hath Jehovah said to me: “I will sit still, and look on from my dwelling-place, Like a serene heat when the sun shineth, Like a dewy cloud in the heat of harvest.” ");
INSERT INTO engnoy_vpl VALUES ("IS18_5","024_18_5","ISA","18","5","5","But before the vintage, when the bud is gone, And the blossom is ripening into a swelling grape, He shall cut off the shoots with pruning-hooks, And the branches he shall take away and cut down. ");
INSERT INTO engnoy_vpl VALUES ("IS18_6","024_18_6","ISA","18","6","6","They shall be left together to the ravenous birds of the mountains, And to the wild beasts of the earth. The ravenous birds shall summer upon it, And every wild beast of the earth shall winter upon it. ");
INSERT INTO engnoy_vpl VALUES ("IS18_7","024_18_7","ISA","18","7","7","At that time shall gifts be brought to Jehovah of hosts From a nation tall and fair, From a people terrible from the first and onward, A mighty, victorious people, Whose land is divided by rivers, To the dwelling-place of Jehovah of hosts, to mount Zion. ");
INSERT INTO engnoy_vpl VALUES ("IS19_1","024_19_1","ISA","19","1","1","The prophecy concerning Egypt. Behold, Jehovah rideth upon a swift cloud, And cometh to Egypt; The gods of Egypt tremble at his presence, And the heart of Egypt melteth within her. ");
INSERT INTO engnoy_vpl VALUES ("IS19_2","024_19_2","ISA","19","2","2","“I will set the Egyptians against the Egyptians; Brother shall fight against brother, And neighbor against neighbor; City against city, And kingdom against kingdom. ");
INSERT INTO engnoy_vpl VALUES ("IS19_3","024_19_3","ISA","19","3","3","The spirit of Egypt shall fail within her, And her devices I will bring to naught. Then shall they consult the idols, and the sorcerers, And the necromancers, and the wizards. ");
INSERT INTO engnoy_vpl VALUES ("IS19_4","024_19_4","ISA","19","4","4","But I will give up the Egyptians to the hands of a cruel lord, And a fierce king shall rule over them,” Saith the Lord, Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS19_5","024_19_5","ISA","19","5","5","Then shall the waters fail from the river, Yea, the river shall be wasted and dried up. ");
INSERT INTO engnoy_vpl VALUES ("IS19_6","024_19_6","ISA","19","6","6","The streams shall become putrid; The canals of Egypt shall be emptied and dried up; The reed and the rush shall wither. ");
INSERT INTO engnoy_vpl VALUES ("IS19_7","024_19_7","ISA","19","7","7","The meadows by the river, by the borders of the river, And all that groweth by the river, Shall wither, be blasted, and be no more. ");
INSERT INTO engnoy_vpl VALUES ("IS19_8","024_19_8","ISA","19","8","8","Then shall the fishermen mourn; All they that cast the hook into the river shall lament, And they that spread nets upon the face of the waters shall languish. ");
INSERT INTO engnoy_vpl VALUES ("IS19_9","024_19_9","ISA","19","9","9","They, also, that work in flax, And they that weave white linen, shall be confounded. ");
INSERT INTO engnoy_vpl VALUES ("IS19_10","024_19_10","ISA","19","10","10","Her pillars are broken down, And all who labor for hire are grieved in heart. ");
INSERT INTO engnoy_vpl VALUES ("IS19_11","024_19_11","ISA","19","11","11","Surely the princes of Zoan are fools; The wise counsellors of Pharaoh have been stupid in their counsels. How, then, can ye say to Pharaoh, “I am the son of the wise, The son of ancient kings”? ");
INSERT INTO engnoy_vpl VALUES ("IS19_12","024_19_12","ISA","19","12","12","Where are they now, thy wise men? Let them tell thee now, so that men may know it, What Jehovah of hosts hath determined concerning Egypt! ");
INSERT INTO engnoy_vpl VALUES ("IS19_13","024_19_13","ISA","19","13","13","The princes of Zoan are become fools; The princes of Noph are deceived, Even the chiefs of her tribes have caused Egypt to err. ");
INSERT INTO engnoy_vpl VALUES ("IS19_14","024_19_14","ISA","19","14","14","Jehovah hath mingled within her a spirit of perverseness, And they have caused Egypt to err in all her works, As a drunkard staggereth in his vomit. ");
INSERT INTO engnoy_vpl VALUES ("IS19_15","024_19_15","ISA","19","15","15","There shall be nothing which can be done by Egypt, By the head, or the tail, the palm-branch, or the rush. ");
INSERT INTO engnoy_vpl VALUES ("IS19_16","024_19_16","ISA","19","16","16","In that day shall the Egyptians be like women; They shall tremble and fear On account of the shaking of the hand of Jehovah of hosts, Which he shall shake against them. ");
INSERT INTO engnoy_vpl VALUES ("IS19_17","024_19_17","ISA","19","17","17","The land of Judah shall be a terror to Egypt; Every one to whom it is mentioned shall tremble On account of the purpose of Jehovah of hosts, Which he hath determined against them. ");
INSERT INTO engnoy_vpl VALUES ("IS19_18","024_19_18","ISA","19","18","18","In that day there shall be five cities in the land of Egypt Speaking the language of Canaan, And swearing by Jehovah of hosts; One of them shall be called the City of the Sun. ");
INSERT INTO engnoy_vpl VALUES ("IS19_19","024_19_19","ISA","19","19","19","In that day there shall be an altar to Jehovah in the midst of the land of Egypt, And in the border of it a pillar to Jehovah, ");
INSERT INTO engnoy_vpl VALUES ("IS19_20","024_19_20","ISA","19","20","20","Which shall be a sign and a witness For Jehovah of hosts in the land of Egypt, That they cried to Jehovah on account of their oppressors, And he sent them a saviour, and a defender, who delivered them. ");
INSERT INTO engnoy_vpl VALUES ("IS19_21","024_19_21","ISA","19","21","21","Thus shall Jehovah be made known to Egypt, And the Egyptians shall know Jehovah in that day, And shall offer him sacrifices and oblations; They shall make vows to Jehovah, and perform them. ");
INSERT INTO engnoy_vpl VALUES ("IS19_22","024_19_22","ISA","19","22","22","Thus Jehovah will smite Egypt; he will smite and heal her; They shall return to Jehovah; Therefore will he hear and heal them. ");
INSERT INTO engnoy_vpl VALUES ("IS19_23","024_19_23","ISA","19","23","23","In that day shall there he a highway from Egypt to Assyria, And the Assyrian shall come into Egypt, And the Egyptian into Assyria, And the Egyptians shall worship with the Assyrians. ");
INSERT INTO engnoy_vpl VALUES ("IS19_24","024_19_24","ISA","19","24","24","In that day shall Israel be the third In connection with Egypt and Assyria, A blessing in the midst of the earth. ");
INSERT INTO engnoy_vpl VALUES ("IS19_25","024_19_25","ISA","19","25","25","Jehovah of hosts shall bless them, and say, Blessed be Egypt, my people, And Assyria, the work of my hands, And Israel, my inheritance! ");
INSERT INTO engnoy_vpl VALUES ("IS20_1","024_20_1","ISA","20","1","1","In the year in which Tartan, being sent by Sargon, the king of Assyria, came to Ashdod, and fought against Ashdod, and took it, ");
INSERT INTO engnoy_vpl VALUES ("IS20_2","024_20_2","ISA","20","2","2","at that time spake Jehovah through Isaiah the son of Amoz in this manner: Go, and loose the sackcloth from thy loins, and put off thy shoes from thy feet. And he did so, walking naked and barefoot. ");
INSERT INTO engnoy_vpl VALUES ("IS20_3","024_20_3","ISA","20","3","3","And Jehovah said: As my servant Isaiah hath walked naked and barefoot three years, a sign and a token for Egypt and Ethiopia, ");
INSERT INTO engnoy_vpl VALUES ("IS20_4","024_20_4","ISA","20","4","4","so shall the king of Assyria lead the captives of Egypt, and prisoners of Ethiopia, young and old, naked and barefoot, with their hind parts uncovered, to the shame of the Egyptians. ");
INSERT INTO engnoy_vpl VALUES ("IS20_5","024_20_5","ISA","20","5","5","Then shall they be afraid and ashamed on account of Ethiopia their trust, and of Egypt their glory. ");
INSERT INTO engnoy_vpl VALUES ("IS20_6","024_20_6","ISA","20","6","6","The inhabitant of this coast shall say in that day, “Behold, so is it with them in whom we trusted, and to whom we fled for help, that we might be delivered from the king of Assyria. How then shall we escape?” ");
INSERT INTO engnoy_vpl VALUES ("IS21_1","024_21_1","ISA","21","1","1","The prophecy concerning the desert of the sea. As storms which rush along through the south, So it cometh from the desert, From the terrible land. ");
INSERT INTO engnoy_vpl VALUES ("IS21_2","024_21_2","ISA","21","2","2","A grievous vision was revealed to me; The plunderer plundereth, and the destroyer destroyeth. “Go up, O Elam! Besiege, O Media! All sighing do I make to cease.” ");
INSERT INTO engnoy_vpl VALUES ("IS21_3","024_21_3","ISA","21","3","3","Therefore are my loins full of pain; Pangs have seized me, as the pangs of a woman in travail; For convulsions I cannot hear; For anguish I cannot see. ");
INSERT INTO engnoy_vpl VALUES ("IS21_4","024_21_4","ISA","21","4","4","My heart panteth, Terror hath seized upon me; The evening of my desire is changed into horror. ");
INSERT INTO engnoy_vpl VALUES ("IS21_5","024_21_5","ISA","21","5","5","The table is prepared; the watch is set; They eat; they drink; “Arise, ye princes! Anoint the shield!” ");
INSERT INTO engnoy_vpl VALUES ("IS21_6","024_21_6","ISA","21","6","6","For thus said the Lord unto me: “Go, set a watchman, Who shall declare what he seeth.” ");
INSERT INTO engnoy_vpl VALUES ("IS21_7","024_21_7","ISA","21","7","7","And he saw a troop, horsemen in pairs, Riders on asses, and riders on camels, And he watched with the utmost heed. ");
INSERT INTO engnoy_vpl VALUES ("IS21_8","024_21_8","ISA","21","8","8","Then he cried like a lion: “My Lord, I stand continually upon the watch-tower in the daytime, And keep my post all the night; ");
INSERT INTO engnoy_vpl VALUES ("IS21_9","024_21_9","ISA","21","9","9","And behold, there cometh a troop, Horsemen in pairs.” Again also he lifted up his voice, and said: “Fallen, fallen is Babylon, And all the graven images of her gods are cast broken to the ground.” ");
INSERT INTO engnoy_vpl VALUES ("IS21_10","024_21_10","ISA","21","10","10","O my threshing, and the corn of my floor! What I have heard from Jehovah of hosts, the God of Israel, That have I declared to you. ");
INSERT INTO engnoy_vpl VALUES ("IS21_11","024_21_11","ISA","21","11","11","The prophecy concerning Dumah. A voice came to me from Seir: “Watchman, what of the night? Watchman, what of the night?” ");
INSERT INTO engnoy_vpl VALUES ("IS21_12","024_21_12","ISA","21","12","12","The watchman saith: “Morning cometh, and also night. If ye will inquire, inquire! Return, come!” ");
INSERT INTO engnoy_vpl VALUES ("IS21_13","024_21_13","ISA","21","13","13","The prophecy against the Arabians. In the thickets of Arabia shall ye lodge, O ye caravans of Dedan! ");
INSERT INTO engnoy_vpl VALUES ("IS21_14","024_21_14","ISA","21","14","14","The inhabitants of the land of Tema Bring water to the thirsty; They come to meet the fugitive with bread. ");
INSERT INTO engnoy_vpl VALUES ("IS21_15","024_21_15","ISA","21","15","15","For they flee from swords, From the drawn sword, And from the bent bow, And from the fury of war. ");
INSERT INTO engnoy_vpl VALUES ("IS21_16","024_21_16","ISA","21","16","16","For thus saith the Lord to me: Within one year, according to the years of a hireling, Shall all the glory of Kedar be consumed. ");
INSERT INTO engnoy_vpl VALUES ("IS21_17","024_21_17","ISA","21","17","17","The remainder of the mighty bowmen of the sons of Kedar shall be diminished; For Jehovah, the God of Israel, hath said it. ");
INSERT INTO engnoy_vpl VALUES ("IS22_1","024_22_1","ISA","22","1","1","The prophecy concerning the valley of vision. What aileth thee now, That all thine inhabitants are gone up to the house-tops? ");
INSERT INTO engnoy_vpl VALUES ("IS22_2","024_22_2","ISA","22","2","2","Thou that wast full of noise, A tumultuous city, a joyous city! Thy slain fall not by the sword; They are not slain in battle. ");
INSERT INTO engnoy_vpl VALUES ("IS22_3","024_22_3","ISA","22","3","3","All thy leaders flee together, By the bowmen are they bound; All found within thee are made captive together, Even they who have fled from afar. ");
INSERT INTO engnoy_vpl VALUES ("IS22_4","024_22_4","ISA","22","4","4","Therefore, say I, look away from me, that I may weep bitterly; Strive not to comfort me for the desolation of the daughter of my people! ");
INSERT INTO engnoy_vpl VALUES ("IS22_5","024_22_5","ISA","22","5","5","For a day of trouble, of desolation, and of perplexity cometh From the Lord, Jehovah of hosts, in the valley of vision. They break down the walls; The cry reacheth to the mountains. ");
INSERT INTO engnoy_vpl VALUES ("IS22_6","024_22_6","ISA","22","6","6","Elam beareth the quiver, With chariots full of men, and with horsemen; Kir uncovereth the shield. ");
INSERT INTO engnoy_vpl VALUES ("IS22_7","024_22_7","ISA","22","7","7","Thy fairest valleys, O Jerusalem, are full of chariots; The horsemen set themselves in array against the gate; ");
INSERT INTO engnoy_vpl VALUES ("IS22_8","024_22_8","ISA","22","8","8","The veil of Judah is torn from her. But in such a day ye look to the armor of the house of the forest; ");
INSERT INTO engnoy_vpl VALUES ("IS22_9","024_22_9","ISA","22","9","9","Ye mark how many are the breaches of the city of David, And collect the waters of the lower pool; ");
INSERT INTO engnoy_vpl VALUES ("IS22_10","024_22_10","ISA","22","10","10","Ye number the houses of Jerusalem, And ye break down the houses to prepare the wall; ");
INSERT INTO engnoy_vpl VALUES ("IS22_11","024_22_11","ISA","22","11","11","Ye make a reservoir between the two walls for the waters of the old pool; But ye look not to Him who hath done this; Ye regard not Him that hath prepared this from afar. ");
INSERT INTO engnoy_vpl VALUES ("IS22_12","024_22_12","ISA","22","12","12","The Lord, Jehovah of hosts, calleth you this day To weeping and to lamentation, To baldness and to girding with sackcloth. ");
INSERT INTO engnoy_vpl VALUES ("IS22_13","024_22_13","ISA","22","13","13","But, behold, joy and gladness, Slaying oxen and killing sheep, Eating flesh and drinking wine! “Let us eat and drink, For to-morrow we die!” ");
INSERT INTO engnoy_vpl VALUES ("IS22_14","024_22_14","ISA","22","14","14","Therefore it hath been revealed in my ears by Jehovah of hosts; “This iniquity shall not be forgiven you, till ye die,” Saith the Lord, Jehovah of hosts. ");
INSERT INTO engnoy_vpl VALUES ("IS22_15","024_22_15","ISA","22","15","15","Thus saith the Lord, Jehovah of hosts: Go in to this steward, To Shebna, who is over the household, and say, ");
INSERT INTO engnoy_vpl VALUES ("IS22_16","024_22_16","ISA","22","16","16","What hast thou here, and whom hast thou here, That thou here hewest thee out a sepulchre,—That thou hewest out thy sepulchre on high, And gravest out a habitation for thyself in the rock? ");
INSERT INTO engnoy_vpl VALUES ("IS22_17","024_22_17","ISA","22","17","17","Behold, Jehovah will cast thee headlong with a mighty thrust; ");
INSERT INTO engnoy_vpl VALUES ("IS22_18","024_22_18","ISA","22","18","18","He will violently roll thee together like a ball; Like a ball will he hurl thee into a wide country. There shalt thou die; And there shall be thy splendid chariots, Thou disgrace of the house of thy lord! ");
INSERT INTO engnoy_vpl VALUES ("IS22_19","024_22_19","ISA","22","19","19","I will drive thee from thy post, And from thy station I will pull thee down. ");
INSERT INTO engnoy_vpl VALUES ("IS22_20","024_22_20","ISA","22","20","20","In that day I will call my servant, Even Eliakim, the son of Hilkiah; ");
INSERT INTO engnoy_vpl VALUES ("IS22_21","024_22_21","ISA","22","21","21","I will clothe him with thy robe, And bind thy girdle around him; Thy government will I commit to his hand, And he shall be a father to the inhabitants of Jerusalem, And to the house of Judah. ");
INSERT INTO engnoy_vpl VALUES ("IS22_22","024_22_22","ISA","22","22","22","I will lay the key of the house of David upon his shoulder; He shall open, and none shall shut, And he shall shut, and none shall open. ");
INSERT INTO engnoy_vpl VALUES ("IS22_23","024_22_23","ISA","22","23","23","I will fasten him as a peg in a sure place, And he shall be a glorious seat for his father's house. ");
INSERT INTO engnoy_vpl VALUES ("IS22_24","024_22_24","ISA","22","24","24","Upon him shall hang all the glory of his father's house, The offspring and the offshoots; Every small vessel, from the goblet even to all the pitchers. ");
INSERT INTO engnoy_vpl VALUES ("IS22_25","024_22_25","ISA","22","25","25","In that day, saith Jehovah of hosts, The peg that was once fastened in a sure place shall be moved; It shall be cut down, and fall, And the burden which was upon it shall come to the ground. For Jehovah hath said it. ");
INSERT INTO engnoy_vpl VALUES ("IS23_1","024_23_1","ISA","23","1","1","The prophecy concerning Tyre. Howl, ye ships of Tarshish! For it is laid waste; No house, no entrance is left! From the land of the Chittaeans were the tidings brought to them. ");
INSERT INTO engnoy_vpl VALUES ("IS23_2","024_23_2","ISA","23","2","2","Be amazed, ye inhabitants of the sea-coast, Which the merchants of Sidon, that pass over the sea, did crowd! ");
INSERT INTO engnoy_vpl VALUES ("IS23_3","024_23_3","ISA","23","3","3","Upon the wide waters, the corn of the Nile, The harvest of the river, was her revenue; She was the mart of the nations. ");
INSERT INTO engnoy_vpl VALUES ("IS23_4","024_23_4","ISA","23","4","4","Be thou ashamed, O Sidon, for the sea hath spoken, The fortress of the sea hath spoken thus: “I have not travailed, nor brought forth children; I have not nourished youths, nor brought up virgins.” ");
INSERT INTO engnoy_vpl VALUES ("IS23_5","024_23_5","ISA","23","5","5","When the tidings shall reach Egypt, They shall be filled with anguish at the tidings concerning Tyre. ");
INSERT INTO engnoy_vpl VALUES ("IS23_6","024_23_6","ISA","23","6","6","Pass ye over to Tarshish; Howl, ye inhabitants of the sea-coast! ");
INSERT INTO engnoy_vpl VALUES ("IS23_7","024_23_7","ISA","23","7","7","Is this your joyous city, Whose antiquity is of ancient days? Now her own feet bear her To sojourn far away. ");
INSERT INTO engnoy_vpl VALUES ("IS23_8","024_23_8","ISA","23","8","8","Who hath purposed this against Tyre, The dispenser of crowns, Whose merchants are princes, Whose traders the nobles of the earth? ");
INSERT INTO engnoy_vpl VALUES ("IS23_9","024_23_9","ISA","23","9","9","Jehovah of hosts hath purposed it, To bring down the pride of all glory, To humble the nobles of the earth. ");
INSERT INTO engnoy_vpl VALUES ("IS23_10","024_23_10","ISA","23","10","10","Go over thy land like the Nile, O daughter of Tarshish! Now thy bonds are broken. ");
INSERT INTO engnoy_vpl VALUES ("IS23_11","024_23_11","ISA","23","11","11","He hath stretched out his hand over the sea, He hath made the kingdoms tremble; Jehovah hath given commandment concerning Canaan To destroy her strong holds. ");
INSERT INTO engnoy_vpl VALUES ("IS23_12","024_23_12","ISA","23","12","12","He hath said, Thou shalt no more rejoice, Thou ravished virgin, daughter of Sidon! Arise, pass over to the Chittaeans; Yet even there shalt thou have no rest. ");
INSERT INTO engnoy_vpl VALUES ("IS23_13","024_23_13","ISA","23","13","13","Behold the land of the Chaldaeans, Who, not long ago, were not a people,—The Assyrian assigned it to the inhabitants of the wilderness,—They raise their watch-towers; They destroy her palaces; They make her a heap of ruins. ");
INSERT INTO engnoy_vpl VALUES ("IS23_14","024_23_14","ISA","23","14","14","Howl, ye ships of Tarshish! For your stronghold is destroyed. ");
INSERT INTO engnoy_vpl VALUES ("IS23_15","024_23_15","ISA","23","15","15","And it shall come to pass in that day, That Tyre shall be forgotten seventy years, According to the days of one king; But at the end of seventy years It shall be with Tyre as in the song of the harlot: ");
INSERT INTO engnoy_vpl VALUES ("IS23_16","024_23_16","ISA","23","16","16","“Take thy lyre, go about the city, O harlot, long forgotten; Make sweet melody; sing many songs, That thou mayst again be remembered!” ");
INSERT INTO engnoy_vpl VALUES ("IS23_17","024_23_17","ISA","23","17","17","At the end of seventy years shall Jehovah show regard to Tyre, And she shall return to her hire, And play the harlot with all the kingdoms of the world, That are upon the face of the earth. ");
INSERT INTO engnoy_vpl VALUES ("IS23_18","024_23_18","ISA","23","18","18","But her gain and her hire shall be holy to Jehovah; It shall not be treasured, nor laid up in store; But it shall be for them that dwell before Jehovah, For abundant food, and for splendid clothing. ");
INSERT INTO engnoy_vpl VALUES ("IS24_1","024_24_1","ISA","24","1","1","Behold, Jehovah emptieth and draineth the land; Yea, he turneth it upside down, and scattereth its inhabitants. ");
INSERT INTO engnoy_vpl VALUES ("IS24_2","024_24_2","ISA","24","2","2","As with the people, so is it with the priest; As with the servant, so with the master; As with the maid, so with the mistress; As with the buyer, so with the seller; As with the borrower, so with the lender; As with the usurer, so with the giver of usury. ");
INSERT INTO engnoy_vpl VALUES ("IS24_3","024_24_3","ISA","24","3","3","The land is utterly emptied and utterly plundered; For Jehovah hath spoken this word. ");
INSERT INTO engnoy_vpl VALUES ("IS24_4","024_24_4","ISA","24","4","4","The land mourneth, and withereth; The world languisheth, and withereth; The nobles of the people of the land do languish. ");
INSERT INTO engnoy_vpl VALUES ("IS24_5","024_24_5","ISA","24","5","5","The land was polluted under its inhabitants, Because they transgressed the law, they violated the statutes, They broke the everlasting covenant. ");
INSERT INTO engnoy_vpl VALUES ("IS24_6","024_24_6","ISA","24","6","6","Therefore a curse devoured the land; Its inhabitants suffered for their guilt; Therefore are the inhabitants of the land consumed with heat, And few of the men are left. ");
INSERT INTO engnoy_vpl VALUES ("IS24_7","024_24_7","ISA","24","7","7","The new wine mourneth; The vine languisheth; All that were of a joyful heart do sigh; ");
INSERT INTO engnoy_vpl VALUES ("IS24_8","024_24_8","ISA","24","8","8","The mirth of tabrets ceaseth; The noise of them that rejoice is at an end; The joy of the harp ceaseth. ");
INSERT INTO engnoy_vpl VALUES ("IS24_9","024_24_9","ISA","24","9","9","No more do they drink wine with the song; Strong drink is bitter to them that use it. ");
INSERT INTO engnoy_vpl VALUES ("IS24_10","024_24_10","ISA","24","10","10","The city of desolation is broken down; Every house is closed, so that none can enter. ");
INSERT INTO engnoy_vpl VALUES ("IS24_11","024_24_11","ISA","24","11","11","There is a cry for wine in the streets; All gladness is departed; The mirth of the land is gone; ");
INSERT INTO engnoy_vpl VALUES ("IS24_12","024_24_12","ISA","24","12","12","Desolation is left in the city, And the gate is smitten into ruins. ");
INSERT INTO engnoy_vpl VALUES ("IS24_13","024_24_13","ISA","24","13","13","Yea, thus shall it be in the land, in the midst of the people, As when the olive-tree has been shaken; As the gleaning, when the vintage is ended. ");
INSERT INTO engnoy_vpl VALUES ("IS24_14","024_24_14","ISA","24","14","14","These shall lift up their voice, and sing; Yea, for the majesty of Jehovah they shall shout from the sea. ");
INSERT INTO engnoy_vpl VALUES ("IS24_15","024_24_15","ISA","24","15","15","Wherefore praise ye Jehovah in the East, The name of Jehovah, the God of Israel, in the isles of the sea! ");
INSERT INTO engnoy_vpl VALUES ("IS24_16","024_24_16","ISA","24","16","16","From the end of the earth we hear songs: “Glory to the righteous!” But I cry, Alas, my wretchedness, my wretchedness! woe is me! The plunderers plunder; the plunderers seize the spoil. ");
INSERT INTO engnoy_vpl VALUES ("IS24_17","024_24_17","ISA","24","17","17","The terror, the pit, and the snare Are upon thee, O inhabitant of the land! ");
INSERT INTO engnoy_vpl VALUES ("IS24_18","024_24_18","ISA","24","18","18","Whoso fleeth from the terror shall fall into the pit, And whoso escapeth from the pit, He shall be taken in the snare; For the floodgates of heaven are opened, And the foundations of the earth tremble. ");
INSERT INTO engnoy_vpl VALUES ("IS24_19","024_24_19","ISA","24","19","19","The earth is utterly broken down; The earth is shattered in pieces; The earth is violently moved from her place. ");
INSERT INTO engnoy_vpl VALUES ("IS24_20","024_24_20","ISA","24","20","20","The earth reeleth like a drunkard, It moveth to and fro like a hammock; For her iniquity lieth heavy upon her, And she shall fall and rise no more. ");
INSERT INTO engnoy_vpl VALUES ("IS24_21","024_24_21","ISA","24","21","21","In that day will Jehovah punish the host of the high ones that are on high, And the kings of the earth upon the earth. ");
INSERT INTO engnoy_vpl VALUES ("IS24_22","024_24_22","ISA","24","22","22","They shall be thrown together bound into the pit, And shall be shut up in the prison, But after many days shall they be visited. ");
INSERT INTO engnoy_vpl VALUES ("IS24_23","024_24_23","ISA","24","23","23","The moon shall be confounded and the sun ashamed, When Jehovah of hosts shall reign in mount Zion and Jerusalem, And his glory shall be before his ancients. ");
INSERT INTO engnoy_vpl VALUES ("IS25_1","024_25_1","ISA","25","1","1","O Jehovah, thou art my God; I will exalt thee; I will praise thy name, For thou hast done wonderful things; Thine ancient purposes are faithfulness and truth. ");
INSERT INTO engnoy_vpl VALUES ("IS25_2","024_25_2","ISA","25","2","2","Thou hast made the city a heap; The fortified city a ruin. The palace of the barbarians is to be no more a city! It shall never be built again. ");
INSERT INTO engnoy_vpl VALUES ("IS25_3","024_25_3","ISA","25","3","3","Therefore shall mighty kingdoms praise thee; The cities of the terrible nations shall honor thee; ");
INSERT INTO engnoy_vpl VALUES ("IS25_4","024_25_4","ISA","25","4","4","For thou hast been a defence to the poor; A defence to the needy in his distress; A refuge from the storm, a shadow from the heat, When the rage of tyrants was like a storm against a wall. ");
INSERT INTO engnoy_vpl VALUES ("IS25_5","024_25_5","ISA","25","5","5","As heat in a dry land is made to vanish, So thou puttest down the tumult of the barbarians; As heat is allayed by a thick cloud, So the triumph of the tyrants is brought low. ");
INSERT INTO engnoy_vpl VALUES ("IS25_6","024_25_6","ISA","25","6","6","Then in this mountain shall Jehovah of hosts prepare for all nations A feast of fat things, and wines kept on the lees; Of fat things full of marrow, of wines kept on the lees well refined. ");
INSERT INTO engnoy_vpl VALUES ("IS25_7","024_25_7","ISA","25","7","7","He will destroy in this mountain the covering that was cast over all people, And the veil that was spread over all nations. ");
INSERT INTO engnoy_vpl VALUES ("IS25_8","024_25_8","ISA","25","8","8","He will destroy death forever; The Lord Jehovah will wipe away the tears from all faces, And the reproach of his people will he take away from the whole earth; For Jehovah hath said it. ");
INSERT INTO engnoy_vpl VALUES ("IS25_9","024_25_9","ISA","25","9","9","In that day shall men say, “Behold, this is our God; We waited for him, and he hath saved us; This is Jehovah, for whom we waited; Let us rejoice and exult in his salvation.” ");
INSERT INTO engnoy_vpl VALUES ("IS25_10","024_25_10","ISA","25","10","10","For the hand of Jehovah shall rest upon this mountain, And Moab shall be trodden down in his place, As straw is trodden down in a dung-pool. ");
INSERT INTO engnoy_vpl VALUES ("IS25_11","024_25_11","ISA","25","11","11","And he shall stretch out his hands in the midst of it, As the swimmer stretcheth out his hands to swim, But God shall put down his pride, Together with the devices of his hands. ");
INSERT INTO engnoy_vpl VALUES ("IS25_12","024_25_12","ISA","25","12","12","And the high bulwarks of thy walls will he lay low; He will bring them down to the ground; he will lay them in the dust. ");
INSERT INTO engnoy_vpl VALUES ("IS26_1","024_26_1","ISA","26","1","1","In that day shall this song be sung in the land of Judah: “We have a strong city; His aid doth God appoint for walls and bulwarks. ");
INSERT INTO engnoy_vpl VALUES ("IS26_2","024_26_2","ISA","26","2","2","Open ye the gates, That the righteous nation may enter in, The nation that keepeth the truth. ");
INSERT INTO engnoy_vpl VALUES ("IS26_3","024_26_3","ISA","26","3","3","Him that is of a steadfast mind Thou wilt keep in continual peace, Because he trusteth in thee. ");
INSERT INTO engnoy_vpl VALUES ("IS26_4","024_26_4","ISA","26","4","4","Trust ye in Jehovah forever, For the Lord Jehovah is an everlasting rock. ");
INSERT INTO engnoy_vpl VALUES ("IS26_5","024_26_5","ISA","26","5","5","For he hath brought down the inhabitants of the fortress; The lofty city he hath laid low; He hath laid her low even to the ground; He hath levelled her with the dust. ");
INSERT INTO engnoy_vpl VALUES ("IS26_6","024_26_6","ISA","26","6","6","The foot trampleth upon her, The feet of the poor, the steps of the needy. ");
INSERT INTO engnoy_vpl VALUES ("IS26_7","024_26_7","ISA","26","7","7","The way of the upright is a smooth way; Thou, O most righteous, doth level the path of the upright! ");
INSERT INTO engnoy_vpl VALUES ("IS26_8","024_26_8","ISA","26","8","8","In the way of thy judgments, O Jehovah, we have waited for thee; The desire of our souls is to thy name, and to the remembrance of thee. ");
INSERT INTO engnoy_vpl VALUES ("IS26_9","024_26_9","ISA","26","9","9","My soul longeth for thee in the night, And my spirit within me seeketh thee in the morning; For when thy judgments are in the earth, The inhabitants of the world learn righteousness. ");
INSERT INTO engnoy_vpl VALUES ("IS26_10","024_26_10","ISA","26","10","10","Though favor be shown to the wicked, He will not learn righteousness; In the land of uprightness will he deal unjustly, And have no regard to the majesty of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS26_11","024_26_11","ISA","26","11","11","Thy hand, O Jehovah, is lifted up, yet do they not see; But they shall see with shame thy zeal for thy people; Yea, fire shall devour thine adversaries. ");
INSERT INTO engnoy_vpl VALUES ("IS26_12","024_26_12","ISA","26","12","12","Thou, O Jehovah, wilt give us peace; For all our works thou doest for us. ");
INSERT INTO engnoy_vpl VALUES ("IS26_13","024_26_13","ISA","26","13","13","O Jehovah, our God, other lords have had dominion over us besides thee; Only through thee do we call upon thy name. ");
INSERT INTO engnoy_vpl VALUES ("IS26_14","024_26_14","ISA","26","14","14","They are dead, they shall not live; They are shades, they shall not rise. For thou hast visited and destroyed them, And caused all the memory of them to perish. ");
INSERT INTO engnoy_vpl VALUES ("IS26_15","024_26_15","ISA","26","15","15","“Thou wilt enlarge the nation, O Jehovah! Thou wilt enlarge the nation; thou wilt glorify thyself; Thou wilt widely extend all the borders of the land. ");
INSERT INTO engnoy_vpl VALUES ("IS26_16","024_26_16","ISA","26","16","16","O Jehovah, in affliction they sought thee; They poured out their prayer, when thy chastisement was upon them. ");
INSERT INTO engnoy_vpl VALUES ("IS26_17","024_26_17","ISA","26","17","17","As a woman with child, when her delivery is near, Is in anguish, and crieth aloud in her pangs, So have we been, far from thy presence, O Jehovah! ");
INSERT INTO engnoy_vpl VALUES ("IS26_18","024_26_18","ISA","26","18","18","We have been with child; we have been in anguish, Yet have, as it were, brought forth wind. To the land we bring no deliverance; Nor are the inhabitants of the land born. ");
INSERT INTO engnoy_vpl VALUES ("IS26_19","024_26_19","ISA","26","19","19","O might thy dead live again, Might the dead bodies of my people arise! Awake, and sing, ye that dwell in the dust! For thy dew is like the dew upon plants, And the earth shall bring forth her dead.” ");
INSERT INTO engnoy_vpl VALUES ("IS26_20","024_26_20","ISA","26","20","20","Come, my people, enter into thy chambers, And shut thy doors behind thee; Hide thyself for a little moment, Until the indignation be overpast! ");
INSERT INTO engnoy_vpl VALUES ("IS26_21","024_26_21","ISA","26","21","21","For behold, Jehovah cometh forth from his place, To punish the inhabitants of the earth for their iniquity; And the earth shall disclose her blood, And shall no longer cover her slain. ");
INSERT INTO engnoy_vpl VALUES ("IS27_1","024_27_1","ISA","27","1","1","In that day will Jehovah punish with his sword, His hard, and great, and strong sword, The leviathan, that fleet serpent, Even the leviathan, that winding serpent; Yea, he will slay the monster, that is in the sea. ");
INSERT INTO engnoy_vpl VALUES ("IS27_2","024_27_2","ISA","27","2","2","In that day, sing ye thus concerning the vineyard: ");
INSERT INTO engnoy_vpl VALUES ("IS27_3","024_27_3","ISA","27","3","3","“I, Jehovah, am its guardian; I will water it every moment; That no one may assault it, I will watch it day and night. ");
INSERT INTO engnoy_vpl VALUES ("IS27_4","024_27_4","ISA","27","4","4","There is no fury in me; But let me find the thorns and thistles in battle. I will go against them, And burn them up together, ");
INSERT INTO engnoy_vpl VALUES ("IS27_5","024_27_5","ISA","27","5","5","Unless they take hold of my protection, And with me make peace, And make peace with me.” ");
INSERT INTO engnoy_vpl VALUES ("IS27_6","024_27_6","ISA","27","6","6","In coming days shall Jacob take root, And Israel flourish and bud forth, And fill the world with fruit. ");
INSERT INTO engnoy_vpl VALUES ("IS27_7","024_27_7","ISA","27","7","7","Did he smite Israel, as he smote those that smote him? Was he slain as those that slew him? ");
INSERT INTO engnoy_vpl VALUES ("IS27_8","024_27_8","ISA","27","8","8","In measure, by sending her away, didst thou punish her, Taking her away in the rough tempest, in the day of the east wind. ");
INSERT INTO engnoy_vpl VALUES ("IS27_9","024_27_9","ISA","27","9","9","By this, therefore, is the iniquity of Jacob expiated, And this is wholly the fruit of the removal of his sin, That He has made the stones of the altar like limestones broken in pieces, And that the images of Astarte and the sun-pillars no more stand. ");
INSERT INTO engnoy_vpl VALUES ("IS27_10","024_27_10","ISA","27","10","10","For the fortified city is desolate, A habitation forsaken, deserted like a wilderness; There doth the calf feed, and there doth he lie down, And consume her branches. ");
INSERT INTO engnoy_vpl VALUES ("IS27_11","024_27_11","ISA","27","11","11","When her boughs are withered, they are broken off; Women come, and burn them; For it was a people of no understanding; Therefore he that made him had not mercy on him, And he that formed him showed him no favor. ");
INSERT INTO engnoy_vpl VALUES ("IS27_12","024_27_12","ISA","27","12","12","But it shall come to pass in that day, That Jehovah shall gather fruit From the stream of the Euphrates to the river of Egypt, And ye shall be gathered, one by one, ye children of Israel! ");
INSERT INTO engnoy_vpl VALUES ("IS27_13","024_27_13","ISA","27","13","13","In that day shall a great trumpet be sounded, And they shall come who are lost in the land of Assyria, And are outcasts in the land of Egypt, And shall worship Jehovah upon the holy mountain in Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS28_1","024_28_1","ISA","28","1","1","Woe to the proud crown of the drunkards of Ephraim, To the fading flower, his glorious beauty, At the head of the rich valley of a people stupefied with wine. ");
INSERT INTO engnoy_vpl VALUES ("IS28_2","024_28_2","ISA","28","2","2","Behold a strong, a mighty one from the Lord Like a storm of hail, like a destructive tempest, Like a flood of mighty, overflowing waters, With violence shall dash it to the ground. ");
INSERT INTO engnoy_vpl VALUES ("IS28_3","024_28_3","ISA","28","3","3","It shall be trodden under foot, The proud crown of the drunkards of Ephraim. ");
INSERT INTO engnoy_vpl VALUES ("IS28_4","024_28_4","ISA","28","4","4","And the fading flower, their glorious beauty, At the head of the rich valley, Shall be as the early fig before the time of harvest, Which whoso seeth plucketh immediately, And swalloweth as soon as it is in his hand. ");
INSERT INTO engnoy_vpl VALUES ("IS28_5","024_28_5","ISA","28","5","5","In that day shall Jehovah of hosts Be a glorious crown, and a beautiful diadem to the residue of his people; ");
INSERT INTO engnoy_vpl VALUES ("IS28_6","024_28_6","ISA","28","6","6","A spirit of judgment to him that sitteth in judgment, And of strength to them that drive back the enemy to their gates. ");
INSERT INTO engnoy_vpl VALUES ("IS28_7","024_28_7","ISA","28","7","7","But even these stagger through wine, And reel through strong drink; The priest and the prophet stagger through strong drink; They are overpowered with wine; They stumble through strong drink; They reel in vision, They stagger in judgment. ");
INSERT INTO engnoy_vpl VALUES ("IS28_8","024_28_8","ISA","28","8","8","For all their tables are full of filthy vomit, So that there is no place clean. ");
INSERT INTO engnoy_vpl VALUES ("IS28_9","024_28_9","ISA","28","9","9","“Whom,” say they, “will he teach knowledge, And to whom will he impart instruction? To the weaned from the milk? To those just taken from the breast? ");
INSERT INTO engnoy_vpl VALUES ("IS28_10","024_28_10","ISA","28","10","10","For it is precept upon precept, precept upon precept, Command upon command, command upon command, A little here, and a little there.” ");
INSERT INTO engnoy_vpl VALUES ("IS28_11","024_28_11","ISA","28","11","11","Yea, with stammering lips and a strange tongue He shall indeed speak to this people; ");
INSERT INTO engnoy_vpl VALUES ("IS28_12","024_28_12","ISA","28","12","12","He that said to them, “This is the way of rest, give rest to the weary; This is the way of safety”; But they would not hear. ");
INSERT INTO engnoy_vpl VALUES ("IS28_13","024_28_13","ISA","28","13","13","Then shall the word of Jehovah be indeed to them “Precept upon precept, precept upon precept, Command upon command, command upon command, A little here, and a little there,” So that they shall go on, and fall backwards, and be broken, And be snared and caught. ");
INSERT INTO engnoy_vpl VALUES ("IS28_14","024_28_14","ISA","28","14","14","Wherefore hear ye the word of Jehovah, Ye scoffers, who rule this people in Jerusalem! ");
INSERT INTO engnoy_vpl VALUES ("IS28_15","024_28_15","ISA","28","15","15","Since ye say, “We have entered into a covenant with death, And with the under-world have we made an agreement, The overflowing scourge, when it passeth through, shall not reach us; For we have made falsehood our refuge, And in deceit we have hidden ourselves.” ");
INSERT INTO engnoy_vpl VALUES ("IS28_16","024_28_16","ISA","28","16","16","Therefore thus saith the Lord Jehovah: Behold, I have laid in Zion as a foundation a stone, A tried stone, a precious corner-stone, a sure foundation; He that trusteth shall not flee away. ");
INSERT INTO engnoy_vpl VALUES ("IS28_17","024_28_17","ISA","28","17","17","I will make justice a line, And righteousness a plummet, And the hail shall sweep away the refuge of falsehood, And the waters shall overwhelm its hiding-place; ");
INSERT INTO engnoy_vpl VALUES ("IS28_18","024_28_18","ISA","28","18","18","And your covenant with death shall be broken, And your agreement with the under-world shall not stand; When the overflowing scourge shall pass through, By it shall ye be beaten down. ");
INSERT INTO engnoy_vpl VALUES ("IS28_19","024_28_19","ISA","28","19","19","As often as it passeth through, it shall bear you away; For every morning shall it pass through, By day and by night; Even to hear the rumor of it shall be terrible. ");
INSERT INTO engnoy_vpl VALUES ("IS28_20","024_28_20","ISA","28","20","20","Yea, the bed is too short for one to stretch himself on it, And the covering too narrow for one to wrap himself in it. ");
INSERT INTO engnoy_vpl VALUES ("IS28_21","024_28_21","ISA","28","21","21","For Jehovah will rise up, as in mount Perazim; He will be moved with anger, as in the valley of Gibeon, To perform his act, his strange act, And to execute his work, his strange work. ");
INSERT INTO engnoy_vpl VALUES ("IS28_22","024_28_22","ISA","28","22","22","Now, therefore, be ye no longer scoffers, Lest your bands become stronger; For destruction and punishment have been revealed to me From Jehovah of hosts concerning the whole land! ");
INSERT INTO engnoy_vpl VALUES ("IS28_23","024_28_23","ISA","28","23","23","Give ear, and listen to my voice, Attend, and hearken to my words! ");
INSERT INTO engnoy_vpl VALUES ("IS28_24","024_28_24","ISA","28","24","24","Is the ploughman always ploughing in order to sow? Is he always opening and harrowing his field? ");
INSERT INTO engnoy_vpl VALUES ("IS28_25","024_28_25","ISA","28","25","25","When he hath made the face thereof even, Doth he not then scatter the dill, and cast abroad the cumin, And sow the wheat in rows, And the barley in its appointed place, And the spelt in his border? ");
INSERT INTO engnoy_vpl VALUES ("IS28_26","024_28_26","ISA","28","26","26","Thus his God rightly instructeth him, And giveth him knowledge. ");
INSERT INTO engnoy_vpl VALUES ("IS28_27","024_28_27","ISA","28","27","27","The dill is not beaten out with the thrashing-sledge, Nor is the wheel of the wain rolled over the cumin; But the dill is beaten out with a staff, And the cumin with a rod. ");
INSERT INTO engnoy_vpl VALUES ("IS28_28","024_28_28","ISA","28","28","28","Bread-corn is beaten out, Yet doth not the husbandman thrash it without limit. He driveth over it the wheels of the wain, And the horses, yet doth he not utterly crush it. ");
INSERT INTO engnoy_vpl VALUES ("IS28_29","024_28_29","ISA","28","29","29","This also proceedeth from Jehovah of hosts; He is wonderful in counsel, Excellent in wisdom. ");
INSERT INTO engnoy_vpl VALUES ("IS29_1","024_29_1","ISA","29","1","1","Woe to Ariel, to Ariel, The city where David dwelt! Add year to year, Let the festivals go round, ");
INSERT INTO engnoy_vpl VALUES ("IS29_2","024_29_2","ISA","29","2","2","Then will I distress Ariel; Mourning and sorrow shall be there; Yet shall she be to me as Ariel the lion of God. ");
INSERT INTO engnoy_vpl VALUES ("IS29_3","024_29_3","ISA","29","3","3","I will encamp against thee round about, And I will lay siege against thee with a mound, And I will raise towers against thee. ");
INSERT INTO engnoy_vpl VALUES ("IS29_4","024_29_4","ISA","29","4","4","Thou shalt be brought down, and speak from the ground, And thy speech shall be low from the dust; Thy voice shall be like that of a spirit under ground, And thy speech shall chirp as from the dust. ");
INSERT INTO engnoy_vpl VALUES ("IS29_5","024_29_5","ISA","29","5","5","Yet shall the multitude of thine enemies be like fine dust; The multitude of the terrible like flying chaff; It shall take place suddenly, in a moment. ");
INSERT INTO engnoy_vpl VALUES ("IS29_6","024_29_6","ISA","29","6","6","From Jehovah of hosts cometh the visitation With thunder, and earthquake, and great noise, With storm and tempest, And flames of devouring fire. ");
INSERT INTO engnoy_vpl VALUES ("IS29_7","024_29_7","ISA","29","7","7","As a dream, a vision of the night, Shall be the multitude of all the nations That fight against Ariel, That fight against her and her fortress, And distress her. ");
INSERT INTO engnoy_vpl VALUES ("IS29_8","024_29_8","ISA","29","8","8","As a hungry man dreameth, and lo! he eateth, But awaketh and is still hungry; And as a thirsty man dreameth, and lo! he drinketh, But awaketh, and lo! he is faint and thirsty; So shall it be with the multitude of all the nations That fight against mount Zion. ");
INSERT INTO engnoy_vpl VALUES ("IS29_9","024_29_9","ISA","29","9","9","Be in amazement and be amazed! Be blinded and be blind! They are drunk, but not with wine; They stagger, but not with strong drink! ");
INSERT INTO engnoy_vpl VALUES ("IS29_10","024_29_10","ISA","29","10","10","For Jehovah hath poured upon you a spirit of slumber; He hath closed your eyes, the prophets, And covered your heads, the seers; ");
INSERT INTO engnoy_vpl VALUES ("IS29_11","024_29_11","ISA","29","11","11","And so every vision is to you as the words of a sealed book, Which is given to a man that is skilled in writing, Saying, “Read this, I pray thee”; But he answereth, “I cannot, for it is sealed.” ");
INSERT INTO engnoy_vpl VALUES ("IS29_12","024_29_12","ISA","29","12","12","Or, if he give it to one that is not skilled in writing, Saying, “Read this, I pray thee,” He answereth, “I am not skilled in writing.” ");
INSERT INTO engnoy_vpl VALUES ("IS29_13","024_29_13","ISA","29","13","13","Therefore saith the Lord, Since this people draweth near to me with their mouth, And honoreth me with their lips, While their heart is far from me, And their worship of me is according to the commandments of men, ");
INSERT INTO engnoy_vpl VALUES ("IS29_14","024_29_14","ISA","29","14","14","Therefore, behold, I will proceed to deal marvellously with this people; Marvellously and wonderfully, For the wisdom of their wise men shall perish, And the prudence of the prudent shall be hid. ");
INSERT INTO engnoy_vpl VALUES ("IS29_15","024_29_15","ISA","29","15","15","Woe to them that hide deep their purposes from Jehovah, Whose work is in darkness; That say, Who seeth us? Who knoweth us? ");
INSERT INTO engnoy_vpl VALUES ("IS29_16","024_29_16","ISA","29","16","16","Alas, your perverseness! Is the potter to be esteemed as the clay, That the work should say of its maker, He made me not? And the thing formed say of him that formed it, He hath no understanding? ");
INSERT INTO engnoy_vpl VALUES ("IS29_17","024_29_17","ISA","29","17","17","Is it not yet a very little while, And Lebanon shall be changed to a fruitful field, And the fruitful field be esteemed a forest. ");
INSERT INTO engnoy_vpl VALUES ("IS29_18","024_29_18","ISA","29","18","18","And in that day shall the deaf hear the words of the book, And out of mist and darkness shall the eyes of the blind see. ");
INSERT INTO engnoy_vpl VALUES ("IS29_19","024_29_19","ISA","29","19","19","The afflicted shall exceedingly rejoice in Jehovah, And the poor shall exult in the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS29_20","024_29_20","ISA","29","20","20","For the oppressor hath come to naught; the scoffer is destroyed; And all that watched for iniquity are cut off; ");
INSERT INTO engnoy_vpl VALUES ("IS29_21","024_29_21","ISA","29","21","21","Who condemned a man in his cause, And laid snares for him who defended himself in the gate, And with falsehood caused the righteous to fail. ");
INSERT INTO engnoy_vpl VALUES ("IS29_22","024_29_22","ISA","29","22","22","Therefore concerning the house of Jacob thus saith Jehovah, He that redeemed Abraham: No more shall Jacob be ashamed, And no more shall his face grow pale. ");
INSERT INTO engnoy_vpl VALUES ("IS29_23","024_29_23","ISA","29","23","23","For when his children behold the work of my hands in the midst of them, They shall honor my name. They shall honor the Holy One of Jacob, And reverence the God of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS29_24","024_29_24","ISA","29","24","24","They that erred in spirit shall come to understanding, And the obstinate shall receive instruction. ");
INSERT INTO engnoy_vpl VALUES ("IS30_1","024_30_1","ISA","30","1","1","Woe to the rebellious children, saith Jehovah, Who form plans, and not from me, And make covenants without my spirit, That they may add sin to sin! ");
INSERT INTO engnoy_vpl VALUES ("IS30_2","024_30_2","ISA","30","2","2","Who go down into Egypt, Without inquiring at my mouth, To seek refuge in Pharaoh's protection, And to trust in the shadow of Egypt! ");
INSERT INTO engnoy_vpl VALUES ("IS30_3","024_30_3","ISA","30","3","3","The protection of Pharaoh shall be your shame; Your trust in the shadow of Egypt your confusion. ");
INSERT INTO engnoy_vpl VALUES ("IS30_4","024_30_4","ISA","30","4","4","For their princes are at Zoan, Their ambassadors have arrived at Hanes. ");
INSERT INTO engnoy_vpl VALUES ("IS30_5","024_30_5","ISA","30","5","5","But they are all ashamed of a people that do not profit them; That are no help and no profit, But only a shame and a reproach. ");
INSERT INTO engnoy_vpl VALUES ("IS30_6","024_30_6","ISA","30","6","6","The loaded beasts go southward. Through a land of anguish and distress, Whence come forth the lioness, and the fierce lion, The viper, and the flying fiery serpent; On the shoulders of young asses they carry their wealth, And on the bunches of camels their treasures, To a people that will not profit them! ");
INSERT INTO engnoy_vpl VALUES ("IS30_7","024_30_7","ISA","30","7","7","Vain and empty is the help of Egypt; Wherefore I call her, The Blusterer that sitteth still. ");
INSERT INTO engnoy_vpl VALUES ("IS30_8","024_30_8","ISA","30","8","8","Go now, write this on a tablet before them; Note it down upon a book, That it may remain for future times, A testimony forever! ");
INSERT INTO engnoy_vpl VALUES ("IS30_9","024_30_9","ISA","30","9","9","For this is a rebellious people, false children; Children who will not hear the law of Jehovah; ");
INSERT INTO engnoy_vpl VALUES ("IS30_10","024_30_10","ISA","30","10","10","Who say to the seers, “See not!” And to the prophets, “Prophesy not right things; Speak to us smooth things, Prophesy falsehood! ");
INSERT INTO engnoy_vpl VALUES ("IS30_11","024_30_11","ISA","30","11","11","Turn aside from the way, Depart from the path, Remove from our sight the Holy One of Israel!” ");
INSERT INTO engnoy_vpl VALUES ("IS30_12","024_30_12","ISA","30","12","12","Wherefore thus saith the Holy One of Israel: Since ye despise this word, And trust in oppression and perverseness, And lean thereon, ");
INSERT INTO engnoy_vpl VALUES ("IS30_13","024_30_13","ISA","30","13","13","Therefore shall this iniquity be to you Like a breach ready to give way, That swelleth out in a high wall, Whose fall cometh suddenly, in an instant. ");
INSERT INTO engnoy_vpl VALUES ("IS30_14","024_30_14","ISA","30","14","14","It is broken like a potter's vessel, Which is dashed in pieces and not spared, So that among its fragments not a sherd is found to take up fire from the hearth, Or to dip water from the cistern. ");
INSERT INTO engnoy_vpl VALUES ("IS30_15","024_30_15","ISA","30","15","15","For thus said the Lord Jehovah, the Holy One of Israel: By a return and by rest shall ye be saved; In quietness and confidence is your strength; ");
INSERT INTO engnoy_vpl VALUES ("IS30_16","024_30_16","ISA","30","16","16","But ye would not. Ye said, “No! we will bound along upon horses”; Truly ye shall bound along in flight. “We will ride upon swift coursers”; But they shall be swift that pursue you. ");
INSERT INTO engnoy_vpl VALUES ("IS30_17","024_30_17","ISA","30","17","17","A thousand shall flee at the rebuke of one, And ten thousand at the rebuke of five, Till what remains of you shall be as a beacon on the top of a mountain, As a banner upon a hill. ");
INSERT INTO engnoy_vpl VALUES ("IS30_18","024_30_18","ISA","30","18","18","And yet will Jehovah wait to be gracious to you, And yet will he arise to have mercy upon you; For Jehovah is a righteous God; Happy are all they who wait for him! ");
INSERT INTO engnoy_vpl VALUES ("IS30_19","024_30_19","ISA","30","19","19","For, O people of Zion, that dwellest in Jerusalem, Thou shalt not always weep! He will be very gracious to thee at the voice of thy cry; No sooner shall he hear it, than he will answer thee. ");
INSERT INTO engnoy_vpl VALUES ("IS30_20","024_30_20","ISA","30","20","20","Though Jehovah hath given thee the bread of distress, and the water of affliction, Yet shall thy teachers be hidden from thee no more; But thine eyes shall see thy teachers. ");
INSERT INTO engnoy_vpl VALUES ("IS30_21","024_30_21","ISA","30","21","21","And thine ears shall hear a voice behind thee, Saying, “This is the way, walk ye in it!” When ye turn aside to the right hand, or to the left. ");
INSERT INTO engnoy_vpl VALUES ("IS30_22","024_30_22","ISA","30","22","22","Ye shall treat as defiled the silver coverings of your graven images, And the golden clothing of your molten images, Ye shall cast them away as an unclean thing; Away! shall ye say to them. ");
INSERT INTO engnoy_vpl VALUES ("IS30_23","024_30_23","ISA","30","23","23","Then will he give rain for thy seed, With which thou shalt sow the ground, And the bread-corn, the produce of the land, shall be rich and nourishing; Then shall thy cattle feed in large pastures. ");
INSERT INTO engnoy_vpl VALUES ("IS30_24","024_30_24","ISA","30","24","24","The oxen also, and the young asses, that till the ground, Shall eat well-seasoned provender, Which hath been winnowed with the shovel and the fan. ");
INSERT INTO engnoy_vpl VALUES ("IS30_25","024_30_25","ISA","30","25","25","And on every lofty mountain, And on every high hill, Shall be brooks and streams of water, In the day of the great slaughter, When the towers fall. ");
INSERT INTO engnoy_vpl VALUES ("IS30_26","024_30_26","ISA","30","26","26","Then shall the light of the moon be as the light of the sun, And the light of the sun shall be sevenfold, As the light of seven days, When Jehovah bindeth up the bruises of his people, And healeth the wound which they have received. ");
INSERT INTO engnoy_vpl VALUES ("IS30_27","024_30_27","ISA","30","27","27","Behold, the name of Jehovah cometh from afar, His anger burneth, and violent is the flame, His lips are full of indignation, And his tongue like a devouring fire. ");
INSERT INTO engnoy_vpl VALUES ("IS30_28","024_30_28","ISA","30","28","28","His breath is like an overflowing torrent, That reacheth even to the neck; He will toss the nation with the winnowing-fan of destruction; He will put a bridle upon the jaws of the people, that shall lead them astray. ");
INSERT INTO engnoy_vpl VALUES ("IS30_29","024_30_29","ISA","30","29","29","But ye shall then sing as in the night of a solemn festival; Your heart shall be glad, like his who marcheth with the sound of the pipe To the mountain of Jehovah, to the rock of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS30_30","024_30_30","ISA","30","30","30","Jehovah will cause his glorious voice to be heard, And the blow of his arm to be seen, With furious anger, and flames of devouring fire; With flood, and storm, and hailstones. ");
INSERT INTO engnoy_vpl VALUES ("IS30_31","024_30_31","ISA","30","31","31","For by the voice of Jehovah shall the Assyrian be beaten down; He will smite him with the rod. ");
INSERT INTO engnoy_vpl VALUES ("IS30_32","024_30_32","ISA","30","32","32","And as often as the appointed rod shall strike, Which Jehovah shall lay heavily upon him, It shall be accompanied with tabrets and harps; And with fierce battles will he fight against him. ");
INSERT INTO engnoy_vpl VALUES ("IS30_33","024_30_33","ISA","30","33","33","For long hath the burning place been prepared; Yea, for the king hath it been made ready; The pile is made deep and broad; There is fire and wood in abundance; The breath of Jehovah, like a stream of brimstone, kindle it. ");
INSERT INTO engnoy_vpl VALUES ("IS31_1","024_31_1","ISA","31","1","1","Woe to them that go down to Egypt for help, And put their trust in horses, And confide in chariots, because they are many, And in horsemen, because their number is great, But look not to the Holy One of Israel, And resort not to Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS31_2","024_31_2","ISA","31","2","2","Yet he, too, is wise; He will bring evil, and not take back his words; He will arise against the house of the evil-doers, And against the help of them that do iniquity. ");
INSERT INTO engnoy_vpl VALUES ("IS31_3","024_31_3","ISA","31","3","3","The Egyptians are men, and not God, And their horses are flesh, and not spirit. When Jehovah shall stretch forth his hand, Then shall the helper fall, and the helped be overthrown; And they shall all perish together. ");
INSERT INTO engnoy_vpl VALUES ("IS31_4","024_31_4","ISA","31","4","4","For thus hath Jehovah said to me: As when the lion and the young lion growl over their prey, And a multitude of shepherds is called forth against him, By their noise he is not terrified, Nor by their tumult disheartened; So shall Jehovah of hosts come down to fight for mount Zion, and her hill. ");
INSERT INTO engnoy_vpl VALUES ("IS31_5","024_31_5","ISA","31","5","5","As birds hover over their young, So shall Jehovah of hosts defend Jerusalem; He will defend and deliver, spare and save. ");
INSERT INTO engnoy_vpl VALUES ("IS31_6","024_31_6","ISA","31","6","6","Turn, O ye children of Israel, To him from whom ye have so deeply revolted! For in that day shall every one cast away his idols of ");
INSERT INTO engnoy_vpl VALUES ("IS31_7","024_31_7","ISA","31","7","7","silver and his idols of gold, Which your hands have made for sin. ");
INSERT INTO engnoy_vpl VALUES ("IS31_8","024_31_8","ISA","31","8","8","The Assyrian shall fall by a sword not of man, Yea, a sword not of mortal shall devour him; He shall flee before the sword, And his young warriors shall be slaves. ");
INSERT INTO engnoy_vpl VALUES ("IS31_9","024_31_9","ISA","31","9","9","Through fear shall he pass beyond his stronghold, And his princes shall be afraid of the standard. Thus saith Jehovah, who hath his fire in Zion, And his furnace in Jerusalem. ");
INSERT INTO engnoy_vpl VALUES ("IS32_1","024_32_1","ISA","32","1","1","Behold! a king shall reign in righteousness, And princes shall rule with equity. ");
INSERT INTO engnoy_vpl VALUES ("IS32_2","024_32_2","ISA","32","2","2","Every one of them shall be a hiding-place from the wind, And a shelter from the tempest; As streams of water in a dry place, As the shadow of a great rock in a weary land. ");
INSERT INTO engnoy_vpl VALUES ("IS32_3","024_32_3","ISA","32","3","3","The eyes of them that see shall no more be blind, And the ears of them that hear shall hearken. ");
INSERT INTO engnoy_vpl VALUES ("IS32_4","024_32_4","ISA","32","4","4","The heart of the rash shall gain wisdom, And the tongue of the stammerer learn to speak plainly. ");
INSERT INTO engnoy_vpl VALUES ("IS32_5","024_32_5","ISA","32","5","5","The vile shall no more be called liberal, Nor the niggard said to be bountiful; ");
INSERT INTO engnoy_vpl VALUES ("IS32_6","024_32_6","ISA","32","6","6","For the vile will still utter villany, And his heart will devise iniquity; He will practise deception, and speak impiety against God; He will take away the food of the hungry, And deprive the thirsty of drink. ");
INSERT INTO engnoy_vpl VALUES ("IS32_7","024_32_7","ISA","32","7","7","The instruments also of the niggard are evil; He plotteth mischievous devices, To destroy the poor with lying words, Even when the cause of the needy is just. ");
INSERT INTO engnoy_vpl VALUES ("IS32_8","024_32_8","ISA","32","8","8","But the liberal deviseth liberal things, And in liberal things will he persevere. ");
INSERT INTO engnoy_vpl VALUES ("IS32_9","024_32_9","ISA","32","9","9","Arise, hear my voice, ye women that are at ease! Give ear to my speech, ye careless daughters! ");
INSERT INTO engnoy_vpl VALUES ("IS32_10","024_32_10","ISA","32","10","10","One year more, and ye shall tremble, ye careless women! For the vintage shall fail; the harvest shall not come. ");
INSERT INTO engnoy_vpl VALUES ("IS32_11","024_32_11","ISA","32","11","11","Tremble, O ye that are at ease! Be in dismay, ye careless ones! Strip you, make you bare, gird ye sackcloth upon your loins! ");
INSERT INTO engnoy_vpl VALUES ("IS32_12","024_32_12","ISA","32","12","12","They shall smite themselves on their breasts, On account of the pleasant fields, On account of the fruitful vine. ");
INSERT INTO engnoy_vpl VALUES ("IS32_13","024_32_13","ISA","32","13","13","Upon the land of my people shall come up thorns and briers; Yea, upon all the houses of joy in the joyous city. ");
INSERT INTO engnoy_vpl VALUES ("IS32_14","024_32_14","ISA","32","14","14","For the palace shall be forsaken; The tumult of the city shall be solitary; The fortified hill and the tower shall be dens forever; The joy of wild-asses, the pasture of flocks; ");
INSERT INTO engnoy_vpl VALUES ("IS32_15","024_32_15","ISA","32","15","15","Until the spirit from on high be poured upon us, And the wilderness become a fruitful field, And the fruitful field be esteemed a forest. ");
INSERT INTO engnoy_vpl VALUES ("IS32_16","024_32_16","ISA","32","16","16","Then shall justice dwell in the wilderness, And righteousness in the fruitful field. ");
INSERT INTO engnoy_vpl VALUES ("IS32_17","024_32_17","ISA","32","17","17","And the effect of righteousness shall be peace, And the fruit of righteousness quiet and security forever. ");
INSERT INTO engnoy_vpl VALUES ("IS32_18","024_32_18","ISA","32","18","18","Then shall my people dwell in peaceful habitations, In secure dwellings, in quiet resting-places. ");
INSERT INTO engnoy_vpl VALUES ("IS32_19","024_32_19","ISA","32","19","19","But the hail shall descend, and the forest shall fall; And the city shall be brought very low. ");
INSERT INTO engnoy_vpl VALUES ("IS32_20","024_32_20","ISA","32","20","20","Happy ye who sow beside all waters; Who send forth thither the feet of the ox and the ass! ");
INSERT INTO engnoy_vpl VALUES ("IS33_1","024_33_1","ISA","33","1","1","Woe to thee, thou spoiler, who hast not been spoiled! Thou plunderer, who hast not been plundered! When thou hast ceased to spoil, thou shalt be spoiled; When thou hast finished plundering, they shall plunder thee. ");
INSERT INTO engnoy_vpl VALUES ("IS33_2","024_33_2","ISA","33","2","2","O Jehovah, have mercy upon us! in thee do we trust; Be thou our strength every morning, Our salvation in the time of trouble. ");
INSERT INTO engnoy_vpl VALUES ("IS33_3","024_33_3","ISA","33","3","3","At the voice of thy thunder the people flee; When thou dost arise, the nations are scattered. ");
INSERT INTO engnoy_vpl VALUES ("IS33_4","024_33_4","ISA","33","4","4","Your spoil shall be gathered, as the locust gathereth; As the locust runneth, so shall they run upon it. ");
INSERT INTO engnoy_vpl VALUES ("IS33_5","024_33_5","ISA","33","5","5","Jehovah is exalted; Yea, he dwelleth on high; He filleth Zion with justice and righteousness. ");
INSERT INTO engnoy_vpl VALUES ("IS33_6","024_33_6","ISA","33","6","6","There shall be security in thy times; Wisdom and knowledge shall be thy store of prosperity, And the fear of Jehovah, this shall be thy treasure! ");
INSERT INTO engnoy_vpl VALUES ("IS33_7","024_33_7","ISA","33","7","7","Behold, the mighty men cry without: The ambassadors of peace weep bitterly. ");
INSERT INTO engnoy_vpl VALUES ("IS33_8","024_33_8","ISA","33","8","8","The highways are desolate; The traveller ceaseth; He breaketh the covenant; he despiseth the cities; Of men he maketh no account. ");
INSERT INTO engnoy_vpl VALUES ("IS33_9","024_33_9","ISA","33","9","9","The land mourneth and languisheth; Lebanon is put to shame, and withered away; Sharon is like a desert, And Bashan and Carmel are stripped of their leaves. ");
INSERT INTO engnoy_vpl VALUES ("IS33_10","024_33_10","ISA","33","10","10","Now will I arise, saith Jehovah, Now will I exalt myself, Now will I lift myself up. ");
INSERT INTO engnoy_vpl VALUES ("IS33_11","024_33_11","ISA","33","11","11","Ye shall conceive chaff, and bring forth stubble; Your own wrath is the fire which shall devour you. ");
INSERT INTO engnoy_vpl VALUES ("IS33_12","024_33_12","ISA","33","12","12","The nations shall be burnt into lime; Like thorns cut down, they shall be consumed with fire. ");
INSERT INTO engnoy_vpl VALUES ("IS33_13","024_33_13","ISA","33","13","13","Hear, ye that are far off, what I have done; Mark, ye that are near, my power! ");
INSERT INTO engnoy_vpl VALUES ("IS33_14","024_33_14","ISA","33","14","14","The sinners in Zion are struck with dread; Terror hath seized upon the unrighteous: “Who among us can dwell in devouring fire? Who among us can dwell in everlasting flames?” ");
INSERT INTO engnoy_vpl VALUES ("IS33_15","024_33_15","ISA","33","15","15","He that walketh in righteousness, And speaketh that which is right, That despiseth the gain of oppression, And shaketh his hands from bribery, That stoppeth his ears, so as not to hear of blood, And shutteth his eyes, so as not to behold iniquity. ");
INSERT INTO engnoy_vpl VALUES ("IS33_16","024_33_16","ISA","33","16","16","He shall dwell on high; The strongholds of rocks shall be his defence; His bread shall be given him; His water shall not fail. ");
INSERT INTO engnoy_vpl VALUES ("IS33_17","024_33_17","ISA","33","17","17","Thine eyes shall see the king in his glory They shall survey a wide-extended land. ");
INSERT INTO engnoy_vpl VALUES ("IS33_18","024_33_18","ISA","33","18","18","Thy heart shall meditate on the past terror: “Where now is the scribe? Where the weigher of tribute? Where he that numbered the towers?” ");
INSERT INTO engnoy_vpl VALUES ("IS33_19","024_33_19","ISA","33","19","19","Thou shalt see no more a fierce people, A people of a dark language, which thou couldst not hear, And of a barbarous tongue, which thou couldst not understand; ");
INSERT INTO engnoy_vpl VALUES ("IS33_20","024_33_20","ISA","33","20","20","Thou shalt see Zion, the city of our solemn feasts; Thine eyes shall behold Jerusalem, as a quiet habitation. A tent that shall never be moved, Whose stakes shall never be taken away, And whose cords shall never be broken. ");
INSERT INTO engnoy_vpl VALUES ("IS33_21","024_33_21","ISA","33","21","21","For there the glorious Jehovah will be to us Instead of rivers and broad streams, Which no oared galley shall pass, And no gallant ship go through. ");
INSERT INTO engnoy_vpl VALUES ("IS33_22","024_33_22","ISA","33","22","22","For Jehovah is our judge; Jehovah is our lawgiver; Jehovah is our king; it is he that will save us. ");
INSERT INTO engnoy_vpl VALUES ("IS33_23","024_33_23","ISA","33","23","23","Thy ropes hang loose; They cannot hold the mast-socket, Nor can they spread the sail. Then shall a great spoil be divided; Even the lame shall take the prey. ");
INSERT INTO engnoy_vpl VALUES ("IS33_24","024_33_24","ISA","33","24","24","No inhabitant shall say, I am sick; The people that dwell therein shall be forgiven their iniquity. ");
INSERT INTO engnoy_vpl VALUES ("IS34_1","024_34_1","ISA","34","1","1","Draw near, O ye nations, and hear! Attend, O ye people! Let the earth hear, and all that is therein; The world, and all that springs from it! ");
INSERT INTO engnoy_vpl VALUES ("IS34_2","024_34_2","ISA","34","2","2","For the wrath of Jehovah is kindled against all the nations, And his fury against all their armies; He hath devoted them to destruction; He hath given them up to slaughter. ");
INSERT INTO engnoy_vpl VALUES ("IS34_3","024_34_3","ISA","34","3","3","Their slain shall be cast out; From their carcasses their stench shall ascend, And the mountains shall flow down with their blood. ");
INSERT INTO engnoy_vpl VALUES ("IS34_4","024_34_4","ISA","34","4","4","And all the hosts of heaven shall melt away; And the heavens shall be rolled up like a scroll, And all their host shall fall down, As the withered leaf faileth from the vine, As the blighted fruit from the fig-tree. ");
INSERT INTO engnoy_vpl VALUES ("IS34_5","024_34_5","ISA","34","5","5","For my sword hath become drunk in heaven; Behold, upon Edom shall it descend, Upon the people under my curse, for vengeance. ");
INSERT INTO engnoy_vpl VALUES ("IS34_6","024_34_6","ISA","34","6","6","The sword of Jehovah is full of blood; It is covered with fat, With the blood of lambs and goats, With the fat of the kidneys of rams; For Jehovah holdeth a sacrifice in Bozrah, And a great slaughter in the land of Edom. ");
INSERT INTO engnoy_vpl VALUES ("IS34_7","024_34_7","ISA","34","7","7","The wild buffaloes shall fall down with them. And the bullocks with the bulls; The hind shall be drunk with blood, And the ground enriched with fat. ");
INSERT INTO engnoy_vpl VALUES ("IS34_8","024_34_8","ISA","34","8","8","For Jehovah holdeth a day of vengeance, A year of recompense in the cause of Zion. ");
INSERT INTO engnoy_vpl VALUES ("IS34_9","024_34_9","ISA","34","9","9","Her streams shall be turned into pitch, And her dust into brimstone, And her whole land shall become burning pitch. ");
INSERT INTO engnoy_vpl VALUES ("IS34_10","024_34_10","ISA","34","10","10","Day and night it shall not be quenched; Its smoke shall ascend forever; From generation to generation it shall lie waste; None shall pass through it for ever and ever. ");
INSERT INTO engnoy_vpl VALUES ("IS34_11","024_34_11","ISA","34","11","11","The pelican and the hedgehog shall possess it; The heron and the raven shall dwell in it; Over it will he draw the measuring-line of destruction. And the plummet of desolation. ");
INSERT INTO engnoy_vpl VALUES ("IS34_12","024_34_12","ISA","34","12","12","Her nobles — none are there, who may proclaim a kingdom, And all her princes have come to naught. ");
INSERT INTO engnoy_vpl VALUES ("IS34_13","024_34_13","ISA","34","13","13","Thorns shall spring up in her palaces; Nettles and thistles in her strongholds. She shall become a habitation for jackals, A court for ostriches. ");
INSERT INTO engnoy_vpl VALUES ("IS34_14","024_34_14","ISA","34","14","14","The wild-cats shall fall upon the wolves, And the satyr shall call to his fellow; There also shall the night-spectre light, And find a place of rest. ");
INSERT INTO engnoy_vpl VALUES ("IS34_15","024_34_15","ISA","34","15","15","There also shall the arrow-snake make her nest, and lay her eggs; She shall hatch them, and gather her young under her shadow: There also shall the vultures be gathered together, Every one with her mate. ");
INSERT INTO engnoy_vpl VALUES ("IS34_16","024_34_16","ISA","34","16","16","Search ye the book of Jehovah, and read! Not one of these shall fail; Not one shall want her mate; For His mouth, it shall command, And His spirit, it shall gather them. ");
INSERT INTO engnoy_vpl VALUES ("IS34_17","024_34_17","ISA","34","17","17","He shall cast the lot for them; His hand shall divide it for them with a line; They shall possess it forever; From generation to generation shall they dwell therein. ");
INSERT INTO engnoy_vpl VALUES ("IS35_1","024_35_1","ISA","35","1","1","The wilderness and the parched land shall be glad, And the desert rejoice and blossom as the rose; ");
INSERT INTO engnoy_vpl VALUES ("IS35_2","024_35_2","ISA","35","2","2","It shall blossom abundantly, and exult with joy and singing; The glory of Lebanon shall be given to it; The beauty of Carmel and Sharon; They shall behold the glory of Jehovah, The majesty of our God; ");
INSERT INTO engnoy_vpl VALUES ("IS35_3","024_35_3","ISA","35","3","3","Strengthen ye the weak hands, And confirm the tottering knees! ");
INSERT INTO engnoy_vpl VALUES ("IS35_4","024_35_4","ISA","35","4","4","Say ye to the faint-hearted, “Be ye strong; fear ye not; Behold your God! Vengeance cometh, the retribution of God; He will come and save you!” ");
INSERT INTO engnoy_vpl VALUES ("IS35_5","024_35_5","ISA","35","5","5","Then shall the eyes of the blind be opened, And the ears of the deaf be unstopped. ");
INSERT INTO engnoy_vpl VALUES ("IS35_6","024_35_6","ISA","35","6","6","Then shall the lame leap like the hart, And the tongue of the dumb shall sing; For in the wilderness shall waters break forth, And streams in the desert. ");
INSERT INTO engnoy_vpl VALUES ("IS35_7","024_35_7","ISA","35","7","7","The glowing sands shall become a pool, And the thirsty ground springs of water; In the habitation of jackals, where they lie, Shall be a place for reeds and rushes. ");
INSERT INTO engnoy_vpl VALUES ("IS35_8","024_35_8","ISA","35","8","8","And a path shall be there, and a highway, And it shall be called the holy way; No unclean person shall pass over it; it shall be for them alone; He that therein goeth in this way, though a fool, shall not err therein. ");
INSERT INTO engnoy_vpl VALUES ("IS35_9","024_35_9","ISA","35","9","9","No lion shall be there, Nor shall any ravenous beast go up thereon; It shall not be found there; But the redeemed shall walk there. ");
INSERT INTO engnoy_vpl VALUES ("IS35_10","024_35_10","ISA","35","10","10","Yea, the ransomed of Jehovah shall return; They shall come to Zion with songs: Everlasting joy shall be upon their heads; They shall obtain joy and gladness, And sorrow and sighing shall flee away. ");
INSERT INTO engnoy_vpl VALUES ("IS36_1","024_36_1","ISA","36","1","1","In the fourteenth year of King Hezekiah, Sennacherib, king of Assyria, came up against all the fortified cities of Judah, and took them. ");
INSERT INTO engnoy_vpl VALUES ("IS36_2","024_36_2","ISA","36","2","2","And the king of Assyria sent Rabshakeh from Lachish to Jerusalem, with a great army, against King Hezekiah, and he halted at the aqueduct of the upper pool, in the highway to the fuller's field. ");
INSERT INTO engnoy_vpl VALUES ("IS36_3","024_36_3","ISA","36","3","3","Then came forth to him Eliakim, the son of Hilkiah, who was over the palace, and Shebna the scribe, and Josh, the son of Asaph, the annalist. ");
INSERT INTO engnoy_vpl VALUES ("IS36_4","024_36_4","ISA","36","4","4","And Rabshakeh said to them, Say ye to Hezekiah, Thus saith the great king, the king of Assyria: What a confidence is this which thou cherishest! ");
INSERT INTO engnoy_vpl VALUES ("IS36_5","024_36_5","ISA","36","5","5","Thou sayest, (but it is vain talk,) “I have counsel and strength for war.” In whom, then, dost thou trust, that thou rebellest against me? ");
INSERT INTO engnoy_vpl VALUES ("IS36_6","024_36_6","ISA","36","6","6","Behold, thou trustest in that broken reed-staff, Egypt, on which if a man lean, it will pierce his hand, and go through it. Such is Pharaoh, king of Egypt, to all that trust in him. ");
INSERT INTO engnoy_vpl VALUES ("IS36_7","024_36_7","ISA","36","7","7","But if ye say to me, “We trust in Jehovah, our God,”—is it not he whose high places and whose altars Hezekiah hath taken away, and commanded Judah and Jerusalem to worship before this altar? ");
INSERT INTO engnoy_vpl VALUES ("IS36_8","024_36_8","ISA","36","8","8","Engage, now, with my master, the king of Assyria! and I will give thee two thousand horses, when thou art able to provide for thyself riders for them. ");
INSERT INTO engnoy_vpl VALUES ("IS36_9","024_36_9","ISA","36","9","9","How, then, canst thou resist a single captain, one of the least of the servants of my master? Yet thou trustest in Egypt, on account of her chariots and her horsemen. ");
INSERT INTO engnoy_vpl VALUES ("IS36_10","024_36_10","ISA","36","10","10","And am I now come up without Jehovah against this land to destroy it? Jehovah hath said to me, “Go up against this land and destroy it!” ");
INSERT INTO engnoy_vpl VALUES ("IS36_11","024_36_11","ISA","36","11","11","Then said Eliakim and Shebna and Josh to Rabshakeh: Speak, we beseech thee, to thy servants in the Aramaic language, for we understand it; and speak not to us in the Jewish language, in the hearing of the people that are upon the wall. ");
INSERT INTO engnoy_vpl VALUES ("IS36_12","024_36_12","ISA","36","12","12","But Rabshakeh said, Hath my master sent me to speak these words to thy master and to thee only, and not to the people who sit upon the wall, to eat their own dung, and to drink their own urine with you? ");
INSERT INTO engnoy_vpl VALUES ("IS36_13","024_36_13","ISA","36","13","13","Then Rabshakeh stood and cried with a loud voice in the Jewish language, and said, Hear ye the words of the great king, the king of Assyria. ");
INSERT INTO engnoy_vpl VALUES ("IS36_14","024_36_14","ISA","36","14","14","Thus saith the king: Let not Hezekiah deceive you, for he will not be able to deliver you. ");
INSERT INTO engnoy_vpl VALUES ("IS36_15","024_36_15","ISA","36","15","15","And let not Hezekiah persuade you to trust in Jehovah, saying, “Jehovah will certainly deliver us. This city shall not be delivered into the hands of the king of Assyria.” ");
INSERT INTO engnoy_vpl VALUES ("IS36_16","024_36_16","ISA","36","16","16","Hearken not to Hezekiah; for thus saith the king of Assyria: Make peace with me, and come out to me; and ye shall every one eat of his own vine, and every one of his own fig-tree, and ye shall every one drink the waters of his own cistern, ");
INSERT INTO engnoy_vpl VALUES ("IS36_17","024_36_17","ISA","36","17","17","until I come, and take you to a land like your own land; a land of corn, and of new wine, a land of bread and of vineyards. ");
INSERT INTO engnoy_vpl VALUES ("IS36_18","024_36_18","ISA","36","18","18","Be not persuaded by Hezekiah, when he saith, “Jehovah will deliver us.” Have the gods of the nations delivered every one his own land from the hand of the king of Assyria? Where are the gods of Hamath and of Arphad? ");
INSERT INTO engnoy_vpl VALUES ("IS36_19","024_36_19","ISA","36","19","19","Where are the gods of Sepharvaim? And did the gods deliver Samaria from my hand? ");
INSERT INTO engnoy_vpl VALUES ("IS36_20","024_36_20","ISA","36","20","20","Who is there among all the gods of these lands, that hath delivered his land out of my hand, that Jehovah should deliver Jerusalem out of my hand? ");
INSERT INTO engnoy_vpl VALUES ("IS36_21","024_36_21","ISA","36","21","21","But the people held their peace, and answered him not a word; for the king's command was, “Answer him not.” ");
INSERT INTO engnoy_vpl VALUES ("IS36_22","024_36_22","ISA","36","22","22","Then came Eliakim, the son of Hilkiah, that was over the palace, and Shebna the scribe, and Joah, the son of Asaph, the annalist, to Hezekiah, with their clothes rent, and told him the words of Rabshakeh. ");
INSERT INTO engnoy_vpl VALUES ("IS37_1","024_37_1","ISA","37","1","1","And when the king, Hezekiah, heard it, he rent his clothes, and covered himself with sackcloth, and went into the house of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS37_2","024_37_2","ISA","37","2","2","And he sent Eliakim, who was over the palace, and Shebna the scribe, and the elders of the priests, covered with sackcloth, to Isaiah the prophet, the son of Amoz. ");
INSERT INTO engnoy_vpl VALUES ("IS37_3","024_37_3","ISA","37","3","3","And they said to him, Thus saith Hezekiah: This day is a day of distress, of rebuke, and of contempt; for the children have come to the birth, and there is not strength to bring forth. ");
INSERT INTO engnoy_vpl VALUES ("IS37_4","024_37_4","ISA","37","4","4","It may be that Jehovah, thy God, will hear the words of Rabshakeh, whom the king of Assyria, his master, hath sent to reproach the living God, and to revile him with the words which Jehovah, thy God, hath heard. Do thou, therefore, lift up thy prayer for the remnant of the people, that is yet left. ");
INSERT INTO engnoy_vpl VALUES ("IS37_5","024_37_5","ISA","37","5","5","And the servants of King Hezekiah came to Isaiah. ");
INSERT INTO engnoy_vpl VALUES ("IS37_6","024_37_6","ISA","37","6","6","And Isaiah said to them, Thus shall ye say to your master: Thus saith Jehovah: Be not afraid on account of the words which thou hast heard, with which the servants of the king of Assyria have blasphemed me. ");
INSERT INTO engnoy_vpl VALUES ("IS37_7","024_37_7","ISA","37","7","7","Behold, I will put a spirit within him, so that he shall hear a rumor, and return to his own land; and I will cause him to fall by the sword in his own land. ");
INSERT INTO engnoy_vpl VALUES ("IS37_8","024_37_8","ISA","37","8","8","Then Rabshakeh returned, and found the king of Assyria warring against Libnah, for he had heard that he had departed from Lachish. ");
INSERT INTO engnoy_vpl VALUES ("IS37_9","024_37_9","ISA","37","9","9","Then he heard concerning Tirhakah, king of Ethiopia, that it was said, “He is come forth to war against thee.” And when he heard it, he sent messengers to Hezekiah and said, ");
INSERT INTO engnoy_vpl VALUES ("IS37_10","024_37_10","ISA","37","10","10","Thus shall ye say to Hezekiah, the king of Judah: Let not thy God, in whom thou trustest, deceive thee, saying, Jerusalem shall not be given into the hand of the king of Assyria. ");
INSERT INTO engnoy_vpl VALUES ("IS37_11","024_37_11","ISA","37","11","11","Behold, thou hast heard what the kings of Assyria have done to all the lands; how they have utterly destroyed them. And shalt thou be delivered? ");
INSERT INTO engnoy_vpl VALUES ("IS37_12","024_37_12","ISA","37","12","12","Did the gods of the nations which my father destroyed, deliver them? Gozan, and Haran, and Rezeph, and the children of Eden in Telassar? ");
INSERT INTO engnoy_vpl VALUES ("IS37_13","024_37_13","ISA","37","13","13","Where is the king of Hamath, and the king of Arphad, and the king of the city of Sepharvaim, of Henah, and of Ivah? ");
INSERT INTO engnoy_vpl VALUES ("IS37_14","024_37_14","ISA","37","14","14","And Hezekiah received the letter from the hand of the messengers, and read it. Then he went up to the house of Jehovah, and spread it before Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS37_15","024_37_15","ISA","37","15","15","And Hezekiah prayed before Jehovah, saying, ");
INSERT INTO engnoy_vpl VALUES ("IS37_16","024_37_16","ISA","37","16","16","O Jehovah of hosts, God of Israel, who sittest between the cherubs, thou alone art the God of all the kingdoms of the earth; thou hast made heaven and earth. ");
INSERT INTO engnoy_vpl VALUES ("IS37_17","024_37_17","ISA","37","17","17","Incline thine ear, O Jehovah, and hear; open thine eyes, O Jehovah, and see; and hear all the words of Sennacherib, which he hath sent to reproach the living God. ");
INSERT INTO engnoy_vpl VALUES ("IS37_18","024_37_18","ISA","37","18","18","In truth, O Jehovah, the kings of Assyria have destroyed all the nations, and their lands, ");
INSERT INTO engnoy_vpl VALUES ("IS37_19","024_37_19","ISA","37","19","19","and have cast their gods into the fire; for they were not gods, but the work of men's hands, wood and stone; and they have destroyed them. ");
INSERT INTO engnoy_vpl VALUES ("IS37_20","024_37_20","ISA","37","20","20","But do thou, O Jehovah, our God, save us from his hand, that all the kingdoms of the earth may know that thou alone art Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS37_21","024_37_21","ISA","37","21","21","Then Isaiah, the son of Amoz, sent to Hezekiah, saying, Thus saith Jehovah, the God of Israel: Whereas thou hast prayed to me on account of Sennacherib, the king of Assyria, ");
INSERT INTO engnoy_vpl VALUES ("IS37_22","024_37_22","ISA","37","22","22","This is the word which Jehovah hath spoken against him. The virgin, the daughter of Zion, despiseth thee; she laugheth thee to scorn; The daughter of Jerusalem shaketh her head after thee. ");
INSERT INTO engnoy_vpl VALUES ("IS37_23","024_37_23","ISA","37","23","23","Whom hast thou reproached, and reviled, And against whom hast thou exalted thy voice, And lifted up thine eyes on high? Against the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS37_24","024_37_24","ISA","37","24","24","By thy servants hast thou reproached the Lord, and said: “With the multitude of my chariots have I ascended the heights of the mountains, the extremities of Lebanon; I have cut down its tall cedars, and its choice cypress-trees; I have come to its utmost height, to its garden forest. ");
INSERT INTO engnoy_vpl VALUES ("IS37_25","024_37_25","ISA","37","25","25","I have digged and drunk water, And with the sole of my feet will I dry up all the rivers of Egypt.” ");
INSERT INTO engnoy_vpl VALUES ("IS37_26","024_37_26","ISA","37","26","26","Hast thou not heard, that of old I ordained it, And from ancient times purposed it? Now have I brought it to pass, That thou shouldst convert fortified cities into ruinous heaps. ");
INSERT INTO engnoy_vpl VALUES ("IS37_27","024_37_27","ISA","37","27","27","Therefore were their inhabitants of little strength; They were dismayed and confounded; They were as the grass of the field, and the green herb; As grass upon the house-top, and as corn blasted, before it is grown up. ");
INSERT INTO engnoy_vpl VALUES ("IS37_28","024_37_28","ISA","37","28","28","I know thy sitting down, thy going out, and thy coming in, And thy rage against me. ");
INSERT INTO engnoy_vpl VALUES ("IS37_29","024_37_29","ISA","37","29","29","Because thy rage against me, and thy insolence, is come up into my ears, I will put my ring into thy nose, And my bridle into thy lips, And turn thee back by the way in which thou camest. ");
INSERT INTO engnoy_vpl VALUES ("IS37_30","024_37_30","ISA","37","30","30","And this shall be the sign to thee; Eat this year that which groweth of itself, And in the second year that which groweth of itself, And in the third year ye shall sow and reap, And plant vineyards, and eat the fruit thereof. ");
INSERT INTO engnoy_vpl VALUES ("IS37_31","024_37_31","ISA","37","31","31","And the remnant of the house of Judah, that have escaped, Shall again strike root downward, And bear fruit upward. ");
INSERT INTO engnoy_vpl VALUES ("IS37_32","024_37_32","ISA","37","32","32","For from Jerusalem shall go forth a remnant, And they that have escaped from mount Zion. The zeal of Jehovah of hosts will perform this. ");
INSERT INTO engnoy_vpl VALUES ("IS37_33","024_37_33","ISA","37","33","33","Therefore thus saith Jehovah of hosts concerning the king of Assyria; He shall not come into this city, Nor shoot an arrow into it; He shall not present a shield before it, Nor cast up a mound against it. ");
INSERT INTO engnoy_vpl VALUES ("IS37_34","024_37_34","ISA","37","34","34","By the way in which he came, by the same shall he return, And into this city shall he not come, saith Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS37_35","024_37_35","ISA","37","35","35","For I will defend this city, and deliver it, For mine own sake, and for my servant David's sake. ");
INSERT INTO engnoy_vpl VALUES ("IS37_36","024_37_36","ISA","37","36","36","Then an angel of Jehovah went forth, and smote in the camp of the Assyrians a hundred and eighty-five thousand men; and when the people arose early in the morning, behold they were all dead corpses. ");
INSERT INTO engnoy_vpl VALUES ("IS37_37","024_37_37","ISA","37","37","37","Then Sennacherib, king of Assyria, decamped, and went away, and returned, and dwelt at Nineveh. ");
INSERT INTO engnoy_vpl VALUES ("IS37_38","024_37_38","ISA","37","38","38","And as he was worshipping in the temple of Nisroch, his god, he was slain with the sword by his sons Adrammelech and Sharezer, who escaped into the land of Ararat. And Esarhaddon, his son, reigned in his stead. ");
INSERT INTO engnoy_vpl VALUES ("IS38_1","024_38_1","ISA","38","1","1","In those days was Hezekiah sick unto death; and Isaiah the prophet, the son of Amoz, came to him, and said to him, Set thy house in order, for thou shalt die, and not live. ");
INSERT INTO engnoy_vpl VALUES ("IS38_2","024_38_2","ISA","38","2","2","Then Hezekiah turned his face toward the wall, and made his supplication to Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS38_3","024_38_3","ISA","38","3","3","And he said, I beseech thee, O Jehovah, remember now how I have walked before thee in truth, and with a perfect heart, and have done that which is good in thine eyes! And Hezekiah wept bitterly. ");
INSERT INTO engnoy_vpl VALUES ("IS38_4","024_38_4","ISA","38","4","4","Then came the word of Jehovah to Isaiah, ");
INSERT INTO engnoy_vpl VALUES ("IS38_5","024_38_5","ISA","38","5","5","Go in and say to Hezekiah, Thus saith Jehovah, the God of David thy father: I have heard thy prayer; I have seen thy tears. Behold, I will add to thy life fifteen years. ");
INSERT INTO engnoy_vpl VALUES ("IS38_6","024_38_6","ISA","38","6","6","And I will deliver thee and this city from the hand of the king of Assyria, and I will defend this city. ");
INSERT INTO engnoy_vpl VALUES ("IS38_7","024_38_7","ISA","38","7","7","And this shall be the sign to thee from Jehovah, that Jehovah will do that which he hath spoken. ");
INSERT INTO engnoy_vpl VALUES ("IS38_8","024_38_8","ISA","38","8","8","Behold, I will cause the shadow upon the dial, which hath gone down upon the dial of Ahaz with the sun, to go back ten degrees. So the sun went back ten degrees, which degrees it had gone down. ");
INSERT INTO engnoy_vpl VALUES ("IS38_9","024_38_9","ISA","38","9","9","The writing of Hezekiah, king of Judah, when he had been sick, and had recovered from his sickness. ");
INSERT INTO engnoy_vpl VALUES ("IS38_10","024_38_10","ISA","38","10","10","I said: “Now, in the quiet of my days, shall I go down to the gates of the under-world; I am deprived of the residue of my years.” ");
INSERT INTO engnoy_vpl VALUES ("IS38_11","024_38_11","ISA","38","11","11","I said: “No more shall I see Jehovah, Jehovah in the land of the living. I shall behold man no more Among the inhabitants of stillness. ");
INSERT INTO engnoy_vpl VALUES ("IS38_12","024_38_12","ISA","38","12","12","My habitation is torn away and removed from me, Like a shepherd's tent; My life is rolled up as by the weaver; He cutteth me off from the thrum; Between morning and night wilt thou make an end of me!” ");
INSERT INTO engnoy_vpl VALUES ("IS38_13","024_38_13","ISA","38","13","13","I waited till morning, and like a lion Did he crush all my bones; “Between morning and night wilt thou make an end of me!” ");
INSERT INTO engnoy_vpl VALUES ("IS38_14","024_38_14","ISA","38","14","14","Like a swallow or a crane, so did I twitter; I did mourn as a dove; Mine eyes failed with looking upward; “O Lord, I am in distress; O, deliver me!” ");
INSERT INTO engnoy_vpl VALUES ("IS38_15","024_38_15","ISA","38","15","15","What shall I say? He promised it, and he hath done it; I will walk humbly all my life On account of the bitterness of my soul. ");
INSERT INTO engnoy_vpl VALUES ("IS38_16","024_38_16","ISA","38","16","16","Lord, it is thus that men live; From thee alone cometh the life of my spirit; Thou hast restored me, and caused me to live. ");
INSERT INTO engnoy_vpl VALUES ("IS38_17","024_38_17","ISA","38","17","17","Behold, my anguish is changed into ease; In love thou hast delivered me from the pit of destruction; Thou hast cast all my sins behind thy back. ");
INSERT INTO engnoy_vpl VALUES ("IS38_18","024_38_18","ISA","38","18","18","For the under-world cannot praise thee; The realms of death cannot celebrate thee; They that go down to the pit cannot wait for thy faithfulness. ");
INSERT INTO engnoy_vpl VALUES ("IS38_19","024_38_19","ISA","38","19","19","The living, the living praise thee, as I do this day; The father to the children shall make known thy faithfulness. ");
INSERT INTO engnoy_vpl VALUES ("IS38_20","024_38_20","ISA","38","20","20","Jehovah hath saved me; Therefore will we sing our songs with stringed instruments, All the days of our life, In the house of Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS38_21","024_38_21","ISA","38","21","21","Now Isaiah had said, let them take a lump of figs, and bruise them, and lay them upon the ulcer, and he shall recover. ");
INSERT INTO engnoy_vpl VALUES ("IS38_22","024_38_22","ISA","38","22","22","Hezekiah also had said, What is the sign that I shall go up to the house of Jehovah? ");
INSERT INTO engnoy_vpl VALUES ("IS39_1","024_39_1","ISA","39","1","1","At that time Merodach Baladan, the son of Baladan, king of Babylon, sent a letter and a present to Hezekiah, for he had heard that he had been sick and was recovered. ");
INSERT INTO engnoy_vpl VALUES ("IS39_2","024_39_2","ISA","39","2","2","And Hezekiah was delighted with them, and showed the embassy his treasure-house, the silver, and the gold, and the spices, and the precious oil, and his whole armory, and all that was found in his treasures. There was nothing in his house, nor in all his dominion, which Hezekiah did not show them. ");
INSERT INTO engnoy_vpl VALUES ("IS39_3","024_39_3","ISA","39","3","3","Then came Isaiah the prophet to King Hezekiah, and said to him, What did these men say, and whence did they come to thee? And Hezekiah said, They came to me from a distant country, from Babylon. ");
INSERT INTO engnoy_vpl VALUES ("IS39_4","024_39_4","ISA","39","4","4","Then said he, What have they seen in thy house? And Hezekiah answered: All that is in my house have they seen. There is nothing in my treasures which I have not shown them. ");
INSERT INTO engnoy_vpl VALUES ("IS39_5","024_39_5","ISA","39","5","5","Then said Isaiah to Hezekiah, hear the word of Jehovah of hosts, ");
INSERT INTO engnoy_vpl VALUES ("IS39_6","024_39_6","ISA","39","6","6","Behold, the days shall come, when all that is in thy house, and that thy fathers have treasured up to this day, shall be carried away to Babylon. Nothing shall be left, saith Jehovah. ");
INSERT INTO engnoy_vpl VALUES ("IS39_7","024_39_7","ISA","39","7","7","And of thy sons, which shall issue from thee, which thou shalt beget, shall they take away, and they shall he eunuchs in the palace of the king of Babylon. ");
INSERT INTO engnoy_vpl VALUES ("IS39_8","024_39_8","ISA","39","8","8","(39:7) Then said Hezekiah to Isaiah, Good is the word of Jehovah, which thou hast spoken. For, said he, there shall be peace and security in my days. ");
INSERT INTO engnoy_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Comfort ye, comfort ye, my people, Saith your God. ");
INSERT INTO engnoy_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Speak ye encouragement to Jerusalem, and declare to her, That her hard service is ended; That her iniquity is expiated; That she hath received from the hand of Jehovah Double for all her sins. ");
INSERT INTO engnoy_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","A voice crieth: “Prepare ye in the wilderness the way of Jehovah; Make straight in the desert a highway for our God! ");
INSERT INTO engnoy_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Every valley shall be exalted, And every mountain and hill be made low; The crooked shall become straight, And the rough places plain. ");
INSERT INTO engnoy_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","For the glory of Jehovah shall be revealed, And all flesh shall see it together; For the mouth of Jehovah hath spoken it!” ");
INSERT INTO engnoy_vpl VALUES ("IS40_6","024_40_6","ISA","40","6","6","A voice said, Proclaim! And I said, What shall I proclaim? All flesh is grass, And all its comeliness as the flower of the field. ");
INSERT INTO engnoy_vpl VALUES ("IS40_7","024_40_7","ISA","40","7","7","The grass withereth, the flower fadeth, When the breath of Jehovah bloweth upon it. Truly the people is grass. ");
INSERT INTO engnoy_vpl VALUES ("IS40_8","024_40_8","ISA","40","8","8","The grass withereth, the flower fadeth, But the word of our God shall stand forever. ");
INSERT INTO engnoy_vpl VALUES ("IS40_9","024_40_9","ISA","40","9","9","Get thee up on the high mountain, O thou that bringest glad tidings to Zion; Lift up thy voice with strength, thou that bringest glad tidings to Jerusalem; Lift it up; be not afraid; Say to the cities of Judah, Behold your God! ");
INSERT INTO engnoy_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","Behold, the Lord Jehovah shall come with might, And his arm shall rule for him; Behold, his reward is with him, And his recompense before him. ");
INSERT INTO engnoy_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","He shall feed his flock like a shepherd; He shall gather up the lambs in his arms, And carry them in his bosom, And gently lead the nursing ewes. ");
INSERT INTO engnoy_vpl VALUES ("IS40_12","024_40_12","ISA","40","12","12","Who hath measured the waters in the hollow of his hand, And meted out the heavens with his span, And gathered the dust of the earth into a measure, And weighed the mountains in scales, And the hills in a balance? ");
INSERT INTO engnoy_vpl VALUES ("IS40_13","024_40_13","ISA","40","13","13","Who hath searched out the spirit of Jehovah, Or, being his counsellor, hath taught him? ");
INSERT INTO engnoy_vpl VALUES ("IS40_14","024_40_14","ISA","40","14","14","With whom took he counsel, and who instructed him, And taught him the path of justice, And taught him knowledge, And showed him the way of understanding? ");
INSERT INTO engnoy_vpl VALUES ("IS40_15","024_40_15","ISA","40","15","15","Behold, the nations are as a drop from a bucket, And are accounted as the small dust of the balance; Behold, he taketh up the isles as a very little thing, ");
INSERT INTO engnoy_vpl VALUES ("IS40_16","024_40_16","ISA","40","16","16","And Lebanon is not sufficient for fire, Nor its beasts for a burnt-offering. ");
INSERT INTO engnoy_vpl VALUES ("IS40_17","024_40_17","ISA","40","17","17","All the nations are as nothing before him; They are accounted by him as less than nothing, and vanity. ");
INSERT INTO engnoy_vpl VALUES ("IS40_18","024_40_18","ISA","40","18","18","To whom then will ye liken God, And what likeness will ye compare unto him? ");
INSERT INTO engnoy_vpl VALUES ("IS40_19","024_40_19","ISA","40","19","19","The workman casteth an image, And the smith overlayeth it with gold, And casteth for it silver chains. ");
INSERT INTO engnoy_vpl VALUES ("IS40_20","024_40_20","ISA","40","20","20","He that is too poor to make an oblation Chooseth a piece of wood that will not rot; He seeketh for himself a skilful artificer, To prepare an image that shall not be moved. ");
INSERT INTO engnoy_vpl VALUES ("IS40_21","024_40_21","ISA","40","21","21","Do ye not know? Have ye not heard? Hath it not been declared to you from the beginning? Have ye not considered the foundations of the earth? ");
INSERT INTO engnoy_vpl VALUES ("IS40_22","024_40_22","ISA","40","22","22","It is He that sitteth above the circle of the earth, And the inhabitants are to him as grasshoppers; That stretcheth out the heavens as a canopy, And spreadeth them out as a tent to dwell in; ");
INSERT INTO engnoy_vpl VALUES ("IS40_23","024_40_23","ISA","40","23","23","That bringeth princes to nothing, And reduceth the rulers of the earth to vanity. ");
INSERT INTO engnoy_vpl VALUES ("IS40_24","024_40_24","ISA","40","24","24","Yea, scarcely are they planted, scarcely are they sown, Scarcely hath their stem taken root in the ground, When He bloweth upon them and they wither, And the whirlwind beareth them away like stubble. ");
INSERT INTO engnoy_vpl VALUES ("IS40_25","024_40_25","ISA","40","25","25","To whom then will ye liken me, And to whom shall I be compared? Saith the Holy One. ");
INSERT INTO engnoy_vpl VALUES ("IS40_26","024_40_26","ISA","40","26","26","Lift up your eyes to the heavens, and behold! Who hath created these? He draweth forth their host by number, He calleth them all by name; Through the greatness of his strength and the mightiness of his power, Not one of them faileth to appear. ");
INSERT INTO engnoy_vpl VALUES ("IS40_27","024_40_27","ISA","40","27","27","Why sayest thou, O Jacob, and speakest, O Israel, “My way is hidden from Jehovah, My cause passeth by before my God”? ");
INSERT INTO engnoy_vpl VALUES ("IS40_28","024_40_28","ISA","40","28","28","Do ye not know? Have ye not heard? Jehovah is an everlasting God, The creator of the ends of the earth; He fainteth not, nor is he weary; His understanding is unsearchable. ");
INSERT INTO engnoy_vpl VALUES ("IS40_29","024_40_29","ISA","40","29","29","He giveth power to the faint; To the feeble abundant strength. ");
INSERT INTO engnoy_vpl VALUES ("IS40_30","024_40_30","ISA","40","30","30","The youths shall faint and be weary, And the young warriors shall utterly fall. ");
INSERT INTO engnoy_vpl VALUES ("IS40_31","024_40_31","ISA","40","31","31","But they that trust in Jehovah shall renew their strength; They shall mount up with wings like eagles; They shall run and not be weary; They shall walk and not faint. ");
INSERT INTO engnoy_vpl VALUES ("IS41_1","024_41_1","ISA","41","1","1","Keep silence, and hear me, ye distant lands. Ye nations, gather your strength! Let them come near; then let them speak; Let us go together into judgment. ");
INSERT INTO engnoy_vpl VALUES ("IS41_2","024_41_2","ISA","41","2","2","Who hath raised up from the region of the East Him whom victory meeteth in his march? Who hath subdued nations before him, And given him dominion over kings? Who made their swords like dust, And their bows like driven stubble? ");
INSERT INTO engnoy_vpl VALUES ("IS41_3","024_41_3","ISA","41","3","3","He pursued them, and passed in safety, By a path which his foot had never trodden. ");
INSERT INTO engnoy_vpl VALUES ("IS41_4","024_41_4","ISA","41","4","4","Who hath wrought and done it? I, who have called the generations from the beginning, I, Jehovah, the first; And with the last also am I. ");
INSERT INTO engnoy_vpl VALUES ("IS41_5","024_41_5","ISA","41","5","5","Distant nations saw it, and were afraid; The ends of the earth, and trembled; They drew near, and came together. ");
INSERT INTO engnoy_vpl VALUES ("IS41_6","024_41_6","ISA","41","6","6","One helped another, And said to him, “Be of good courage!” ");
INSERT INTO engnoy_vpl VALUES ("IS41_7","024_41_7","ISA","41","7","7","The carpenter encouraged the smith, He that smoothed with the hammer him that smote on the anvil, And said, “The soldering is good,” And he fastened it with nails that it might not fall. ");
INSERT INTO engnoy_vpl VALUES ("IS41_8","024_41_8","ISA","41","8","8","But thou, O Israel, my servant, Thou, Jacob, whom I have chosen, Offspring of Abraham, my friend! ");
INSERT INTO engnoy_vpl VALUES ("IS41_9","024_41_9","ISA","41","9","9","Thou, whom I have led by the hand from the ends of the earth, And called from the extremities thereof, And said to thee, “Thou art my servant, I have chosen thee, and not cast thee away!” ");
INSERT INTO engnoy_vpl VALUES ("IS41_10","024_41_10","ISA","41","10","10","Fear not, for I am with thee; Faint not, for I, thy God, will strengthen thee; I will help thee, and sustain thee, with my right hand of salvation! ");
INSERT INTO engnoy_vpl VALUES ("IS41_11","024_41_11","ISA","41","11","11","Behold, all who are enraged against thee Shall be ashamed and confounded; All that contend with thee Shall come to nothing and perish. ");
INSERT INTO engnoy_vpl VALUES ("IS41_12","024_41_12","ISA","41","12","12","Thou shalt seek and not find Them that contend with thee; They shall come to nothing, and be no more, Who make war against thee. ");
INSERT INTO engnoy_vpl VALUES ("IS41_13","024_41_13","ISA","41","13","13","For I, Jehovah, am thy God, that holdeth thee by the right hand, That saith to thee, “Fear not, I am thy helper!” ");
INSERT INTO engnoy_vpl VALUES ("IS41_14","024_41_14","ISA","41","14","14","Fear not, thou worm Jacob, thou feeble people of Israel! I am thy helper, saith Jehovah; Thy redeemer is the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS41_15","024_41_15","ISA","41","15","15","Behold, I will make thee a thrashing-wain, sharp and new, With double edges; Thou shalt thrash the mountains, and beat them small, And make the hills as chaff. ");
INSERT INTO engnoy_vpl VALUES ("IS41_16","024_41_16","ISA","41","16","16","Thou shalt winnow them, and the wind shall carry them away, And the whirlwind shall scatter them. But thou shalt rejoice in Jehovah, And glory in the Holy One of Israel. ");
INSERT INTO engnoy_vpl VALUES ("IS41_17","024_41_17","ISA","41","17","17","When the poor and needy seek water, and there is none, And their tongue is parched with thirst, I, Jehovah, will hear them; I, the God of Israel, will not forsake them. ");
INSERT INTO engnoy_vpl VALUES ("IS41_18","024_41_18","ISA","41","18","18","I will open rivers upon the bare hills, And fountains in the midst of the valleys; I will make the wilderness a pool of water, And the dry land springs of water. ");
INSERT INTO engnoy_vpl VALUES ("IS41_19","024_41_19","ISA","41","19","19","I will plant in the wilderness the cedar and the acacia, The myrtle and the olive-tree; I will place in the desert the cypress, The plane-tree and the larch together. ");
INSERT INTO engnoy_vpl VALUES ("IS41_20","024_41_20","ISA","41","20","20","That they may see, and know, And consider, and understand together, That the hand of Jehovah hath done this, And that the Holy One of Israel hath created it. ");
INSERT INTO engnoy_vpl VALUES ("IS41_21","024_41_21","ISA","41","21","21","Bring forward your cause, saith Jehovah; Produce your strong reasons, saith the king of Jacob. ");
INSERT INTO engnoy_vpl VALUES ("IS41_22","024_41_22","ISA","41","22","22","Let them produce them, and show us what shall happen! Tell us what ye have predicted in times past, That we may consider, and know its fulfilment! Or declare to us things that are to come! ");
INSERT INTO engnoy_vpl VALUES ("IS41_23","024_41_23","ISA","41","23","23","Let us hear what shall happen in future times, That we may know whether ye are gods; Do something, be it good or evil, That we may be astonished, and see it together! ");
INSERT INTO engnoy_vpl VALUES ("IS41_24","024_41_24","ISA","41","24","24","Behold, ye are less than nothing, And your work is less than naught; An abomination is he that chooseth you! ");
INSERT INTO engnoy_vpl VALUES ("IS41_25","024_41_25","ISA","41","25","25","I have raised up one from the north, and he cometh; From the rising of the sun he calleth upon my name; He trampleth upon princes as upon mortar; As the potter treadeth down the clay. ");
INSERT INTO engnoy_vpl VALUES ("IS41_26","024_41_26","ISA","41","26","26","Who hath declared this from the beginning, that we might know it, And long ago, that we might say, It is true? There was not one that foretold it, not one that declared it, Not one that heard your words. ");
INSERT INTO engnoy_vpl VALUES ("IS41_27","024_41_27","ISA","41","27","27","I first said to Zion, Behold! behold them! And I gave to Jerusalem a messenger of glad tidings. ");
INSERT INTO engnoy_vpl VALUES ("IS41_28","024_41_28","ISA","41","28","28","I looked, but there was no man; Even among them, but there was none that gave counsel; I inquired of them that they might give an answer; ");
INSERT INTO engnoy_vpl VALUES ("IS41_29","024_41_29","ISA","41","29","29","But behold, they are all vanity; Their works are nothing; Wind and emptiness are their molten images. ");
INSERT INTO engnoy_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Behold my servant, whom I uphold, My chosen, in whom my soul delighteth, I have put my spirit upon him; He shall cause law to go forth to the nations. ");
INSERT INTO engnoy_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","He shall not cry aloud, nor lift up his voice, Nor cause it to be heard in the street. ");
INSERT INTO engnoy_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","The bruised reed shall he not break, And the glimmering flax shall he not quench; He shall send forth law according to truth. ");
INSERT INTO engnoy_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","He shall not fail, nor become weary, Until he shall have established justice in the earth. And distant nations shall wait for his law. ");
INSERT INTO engnoy_vpl VALUES ("IS42_5","024_42_5","ISA","42","5","5","Thus saith God Jehovah, Who created the heavens and stretched them out, Who spread forth the earth, and that which springeth forth from it, Who gave breath to the people upon it, And spirit to them that walk thereon: ");
INSERT INTO engnoy_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","I, Jehovah, have called thee for salvation; I will hold thee by the hand; I will defend thee, and make thee a covenant to the people, A light to the nations; ");
INSERT INTO engnoy_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","To open the blind eyes, To bring out the prisoners from the prison, And them that sit in darkness out of the prison-house. ");
INSERT INTO engnoy_vpl VALUES ("IS42_8","024_42_8","ISA","42","8","8","I am Jehovah, that is my name; And my glory will I not give to another, Nor my praise to graven images. ");
INSERT INTO engnoy_vpl VALUES ("IS42_9","024_42_9","ISA","42","9","9","The former things, behold! they are come to pass, And new things do I now declare; Before they spring forth, I make them known to you. ");
INSERT INTO engnoy_vpl VALUES ("IS42_10","024_42_10","ISA","42","10","10","Sing to Jehovah a new song; His praise to the ends of the earth; Ye that go down upon the sea, and all that fill it; Ye distant coasts, and ye that dwell therein! ");
INSERT INTO engnoy_vpl VALUES ("IS42_11","024_42_11","ISA","42","11","11","Let the desert cry aloud, and the cities thereof; The villages, that Kedar inhabiteth; Let the inhabitants of the rock sing; Let them shout from the top of the mountains! ");
INSERT INTO engnoy_vpl VALUES ("IS42_12","024_42_12","ISA","42","12","12","Let them give glory to Jehovah, And proclaim his praise in distant lands! ");
INSERT INTO engnoy_vpl VALUES ("IS42_13","024_42_13","ISA","42","13","13","Jehovah shall march forth like a hero; Like a mighty warrior shall he rouse his indignation, He shall cry aloud; he shall shout the war-cry, And show himself mighty against his enemies. ");
INSERT INTO engnoy_vpl VALUES ("IS42_14","024_42_14","ISA","42","14","14","“I have long held my peace; I have been still and refrained myself; But now will I cry like a woman in travail; I will destroy and swallow up at once. ");
INSERT INTO engnoy_vpl VALUES ("IS42_15","024_42_15","ISA","42","15","15","I will lay waste mountains and hills, And dry up all their herbs. I will make the river solid land, And dry up the pools of water. ");
INSERT INTO engnoy_vpl VALUES ("IS42_16","024_42_16","ISA","42","16","16","Then will I lead the blind in a way which they know not, And in unknown paths will I guide them; I will make darkness light before them, And crooked paths straight; These things will I do for them, and not forsake them.” ");
INSERT INTO engnoy_vpl VALUES ("IS42_17","024_42_17","ISA","42","17","17","Then shall they be turned back, and be put to shame, Who trust in graven images; Who say to molten images, “Ye are our gods!” ");
INSERT INTO engnoy_vpl VALUES ("IS42_18","024_42_18","ISA","42","18","18","Hear, O ye deaf! And look, ye blind, and see! ");
INSERT INTO engnoy_vpl VALUES ("IS42_19","024_42_19","ISA","42","19","19","Who is blind, if not my servant? And who so deaf as my messenger, whom I send? Who so blind as the friend of God, So blind as the servant of Jehovah? ");
INSERT INTO engnoy_vpl VALUES ("IS42_20","024_42_20","ISA","42","20","20","Thou seest many things, but regardest them not; Thou hast thine ears open, but hearest not! ");
INSERT INTO engnoy_vpl VALUES ("IS42_21","024_42_21","ISA","42","21","21","It pleased Jehovah for his goodness' sake To give him a law, great and glorious; ");
INSERT INTO engnoy_vpl VALUES ("IS42_22","024_42_22","ISA","42","22","22","And yet it is a robbed and plundered people; They are all of them bound in prisons, And hid in dungeons; They have become a spoil, and none delivereth; A prey, and none saith, “Restore!” ");
INSERT INTO engnoy_vpl VALUES ("IS42_23","024_42_23","ISA","42","23","23","Who is there among you that will give ear to this, That will listen and attend for the time to come? ");
INSERT INTO engnoy_vpl VALUES ("IS42_24","024_42_24","ISA","42","24","24","Who gave Jacob to be a spoil, And Israel to plunderers? Was it not Jehovah, against whom we sinned, In whose ways we would not walk, And whose laws we would not obey? ");
INSERT INTO engnoy_vpl VALUES ("IS42_25","024_42_25","ISA","42","25","25","Therefore hath he poured out upon Israel the fury of his wrath, and the violence of war; It kindled a flame around about him, yet he did not regard it; It set him on fire, yet he laid it not to heart. ");
INSERT INTO engnoy_vpl VALUES ("IS43_1","024_43_1","ISA","43","1","1","But now thus saith Jehovah, that created thee, O Jacob, That formed thee, O Israel: Fear not, for I have redeemed thee; I have called thee by name; thou art mine! ");
INSERT INTO engnoy_vpl VALUES ("IS43_2","024_43_2","ISA","43","2","2","When thou passest through waters, I will be with thee; And through rivers, they shall not overflow thee; When thou walkest through fire, thou shalt not be burned, And the flame shall not consume thee. ");
INSERT INTO engnoy_vpl VALUES ("IS43_3","024_43_3","ISA","43","3","3","For I am Jehovah, thy God, The Holy One of Israel, thy saviour. I will give Egypt for thy ransom, Ethiopia and Seba for thee; ");
INSERT INTO engnoy_vpl VALUES ("IS43_4","024_43_4","ISA","43","4","4","Because thou art precious in my sight, Because thou art honored, and I love thee, Therefore will I give men for thee, And nations for thy life. ");
INSERT INTO engnoy_vpl VALUES ("IS43_5","024_43_5","ISA","43","5","5","Fear not, for I am with thee! I will bring thy children from the East, And gather thee from the West. ");
INSERT INTO engnoy_vpl VALUES ("IS43_6","024_43_6","ISA","43","6","6","I will say to the North, “Give them up!” And to the South, “Withhold them not! Bring my sons from afar, And my daughters from the ends of the earth; ");
INSERT INTO engnoy_vpl VALUES ("IS43_7","024_43_7","ISA","43","7","7","Every one that is called by my name, That I have created for my glory, That I have formed and made!” ");
INSERT INTO engnoy_vpl VALUES ("IS43_8","024_43_8","ISA","43","8","8","Bring forth the blind people, having eyes, And the deaf, having ears. ");
INSERT INTO engnoy_vpl VALUES ("IS43_9","024_43_9","ISA","43","9","9","Let all the nations be gathered together, And the kingdoms be assembled! Who among them hath declared this, And can show us former predictions? Let them produce their witnesses that they are right; That men may hear, and say, It is true! ");
INSERT INTO engnoy_vpl VALUES ("IS43_10","024_43_10","ISA","43","10","10","Ye are my witnesses, saith Jehovah, And my servant whom I have chosen, That ye may know and believe me, And understand that I am He. Before me was no god formed, And after me there shall be none. ");
INSERT INTO engnoy_vpl VALUES ("IS43_11","024_43_11","ISA","43","11","11","I, I am Jehovah, And besides me there is no saviour. ");
INSERT INTO engnoy_vpl VALUES ("IS43_12","024_43_12","ISA","43","12","12","I have declared and have saved; I made it known, when there was no strange god among you; Ye are my witnesses, saith Jehovah, That I am God. ");
INSERT INTO engnoy_vpl VALUES ("IS43_13","024_43_13","ISA","43","13","13","Even from the beginning of time I have been He, And none can rescue from my hand; I undertake, and who can hinder? ");
INSERT INTO engnoy_vpl VALUES ("IS43_14","024_43_14","ISA","43","14","14","Thus saith Jehovah, Your redeemer, the Holy One of Israel; For your sakes have I sent to Babylon, And caused all her fugitives, And the Chaldeans, to descend to the ships of their delight. ");
INSERT INTO engnoy_vpl VALUES ("IS43_15","024_43_15","ISA","43","15","15","I, Jehovah, am your Holy One, The creator of Israel, your king. ");
INSERT INTO engnoy_vpl VALUES ("IS43_16","024_43_16","ISA","43","16","16","Thus saith Jehovah,—He that made a way in the sea, And a path in the mighty waters, ");
INSERT INTO engnoy_vpl VALUES ("IS43_17","024_43_17","ISA","43","17","17","That caused the chariot and the horse, the army and the forces, to march forth; There they lay down together; they rose no more; They were extinguished; they were quenched like a torch;— ");
INSERT INTO engnoy_vpl VALUES ("IS43_18","024_43_18","ISA","43","18","18","Remember not the former things; The things of old regard no more! ");
INSERT INTO engnoy_vpl VALUES ("IS43_19","024_43_19","ISA","43","19","19","Behold, I do a new thing; Now shall it spring forth; yea, ye shall see it. Behold, I make a way in the wilderness, And streams in the desert; ");
INSERT INTO engnoy_vpl VALUES ("IS43_20","024_43_20","ISA","43","20","20","The beasts of the forest shall honor me, The jackals and the ostriches; For I make rivers in th