﻿USE sofia;
DROP TABLE IF EXISTS sofia.engnna_vpl;
CREATE TABLE engnna_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engnna_vpl WRITE;
INSERT INTO engnna_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","At the first, long ago God made the sky and the ground. ");
INSERT INTO engnna_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","That ground was just staying purposeless. Water was obscuring everything, water was covering everything. In every direction it was dark. His spirit was going above the water. ");
INSERT INTO engnna_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “Become light!” After that it became light at his word. ");
INSERT INTO engnna_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","When he saw it he said, “Good”. He separated the light and the darkness. ");
INSERT INTO engnna_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","He named the darkness, 'night-that', the light he named, 'day-that'. After that it became night, after that it became dawn. Another day appeared/arrived. ");
INSERT INTO engnna_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Then he said, “Sky become, in order to separate the water and the clouds!” ");
INSERT INTO engnna_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","That happened. The clouds went upwards, they left the water underneath. ");
INSERT INTO engnna_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","That sky he named, 'sky-that'. After that it became night, after that it became dawn. Another day appeared. ");
INSERT INTO engnna_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Then he said, “Water go down, become in one place, dry ground appear, become visible!” That happened. The water went down, it left the ground visible. ");
INSERT INTO engnna_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","That dry ground he named, 'country-that'. That big water he named, 'sea-that'. When he saw it he said “Good”. ");
INSERT INTO engnna_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","After that he said, “Different kinds of trees appear and different kinds of green plants, with separate foods!” That happened. ");
INSERT INTO engnna_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","From the ground different kinds of trees appeared, some with foods, some without, and different kinds of green plants appeared also, some with foods, some without. When he saw it he said “Good.” ");
INSERT INTO engnna_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","After that it became night, after that it became dawn. Another day appeared. ");
INSERT INTO engnna_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Then he said, “Lights become above in the sky, in order to light the countryside. They should give light in the night and in the day. They should keep winter and summer straight.” That happened. ");
INSERT INTO engnna_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","He made two big ones, the sun and the moon. The big one should make it light truly from dawn right up to evening. The small one should make it light truly in the night. He made the stars also. ");
INSERT INTO engnna_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","He put them in the sky to light the countryside and also to separate the darkness and the day. When he saw it he said “Good.” ");
INSERT INTO engnna_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","After that it became night, after that it became dawn. Another day appeared. ");
INSERT INTO engnna_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Then he said, “Many different kinds of water dwellers become in the water-holes and in the sea. Birds become to go above. Birds: lit. 'winged things' — includes insects ");
INSERT INTO engnna_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Then he made very big animals in the sea. He also made big and little fish of different kinds. In the rivers and water-holes he made different kinds of fish. And he made all the other water dwellers in the water-holes and seas. He made different kinds of winged creatures also. When he saw it he said “Good.” ");
INSERT INTO engnna_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","He spoke well to them. He spoke to them all, “I will take care of you. You will truly become many, and many children you will have/care for truly.” ");
INSERT INTO engnna_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","After that it became night, after that it became dawn. Another day appeared. ");
INSERT INTO engnna_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Then he said, “Different kinds of animals become on the ground, to live in the countryside, to go about on the ground, plains-dwelling animals and hills-dwellers, big ones and small ones!” That happened. ");
INSERT INTO engnna_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","He made them all. When he looked at it he said “Good.” ");
INSERT INTO engnna_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","After that he said, “We will make people like us. They will be boss for all the animals, and for all the fish and for all the winged creatures and for the ones that go on the ground.” ");
INSERT INTO engnna_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God made a man like him. He made a man and a woman. ");
INSERT INTO engnna_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","He spoke well to these two, “You will control/have/take care of many children truly. Truly people will be everywhere, you (pl.) will be boss for all the animals. You will be boss for the fish and winged creatures and all animals and for all those that go on the ground. ");
INSERT INTO engnna_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","I made different foods for you (all), all the foods from trees and green plants I am giving you. ");
INSERT INTO engnna_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","For the animals and winged creatures and all the ones that go on the ground I made green plants with food. I left it for them.” ");
INSERT INTO engnna_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Truly he made the whole lot. When he had finished making them God looked at them all. He said, “Very good.” Like that God made everything. He made everything in six days. After that it became night, after that it became dawn. Another day appeared. ");
INSERT INTO engnna_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","3","This next day he did not make another thing. He said about that day, “Already I have finished making everything. I was working, now I have left off working. This day truly I did not make another thing. Because of that this day is different, without work. I have left off work for today.” Avoiding word for 'rest', which also means 'sleep'. ");
INSERT INTO engnna_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Like this God made a/the person. He got dust from the ground. He made a man from that dust. Then he breathed in the nose of the man, then wind/breath from God entered the man. For that reason the man became alive. The name of that man was Adam. ");
INSERT INTO engnna_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","After that in the country, in Eden, there God put a big water-hole/permanent camp, a truly good one. He put the man he had made at that water-hole. ");
INSERT INTO engnna_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","At that water-hole he put different kinds of good trees. There were different kinds having very good food there. In the middle of the trees God put one tree. He named that tree, 'One That Keeps People Alive'. After a person eats from that tree he will live for ever, he will stay without death. He put another tree in the middle of the others, that was a thing associated with making knowledgeable. He named that tree, 'One That Teaches People About Good And Bad'. ");
INSERT INTO engnna_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","At the water-hole in Eden he put that (previously-referred to) person to dig the ground and to care for the water-hole. ");
INSERT INTO engnna_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","He said to him, “You can eat food from all the trees at the water-hole. ");
INSERT INTO engnna_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","(Fruit) from one tree leave, do not eat it, from the tree which makes knowledgeable. I named it, 'One That Teaches People About Good And Bad'. From that tree don't eat. If you eat from that tree truly you will die.” ");
INSERT INTO engnna_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Then he said, “The man should not be alone. I will make a companion for him, he will be one with a companion.” ");
INSERT INTO engnna_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Already God had made all the animals and winged creatures from the ground. He brought them to the man to give them names. That man gave names to the animals and winged creatures and other creatures. They kept the names in accord with the man's word. Among them all there was not one like the man, a companion for him. ");
INSERT INTO engnna_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Then God put the man to sleep, he got a bone from the man's side, then he covered the hole with flesh. ");
INSERT INTO engnna_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","From the bone he made a woman, he took her to the man. ");
INSERT INTO engnna_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Then the man said, “At last! This one is like me! He made her from my body. Her name is 'Woman'.” ");
INSERT INTO engnna_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Because of that God left us this track/pattern of behaviour. A/the man will leave mother and father and they will become one, he and his own wife. Truly those two will be one. ");
INSERT INTO engnna_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","At the water-hole Eden that couple, Adam and his wife, were staying naked, they stayed well, naked, those two, without shame. ");
INSERT INTO engnna_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Among the other animals the snake was really clever. The snake asked the woman, “What did God say to you? 'You should not eat food from all the trees at the water-hole'? Like that did God say to you?” ");
INSERT INTO engnna_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman said to him, “We (two) can eat from some/the rest of the trees from the water-hole/camp. ");
INSERT INTO engnna_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","God said to us, 'From one tree only, in the middle of the camp in the thick trees, from that do not eat food, and do not touch that tree for fear of dying'.” ");
INSERT INTO engnna_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The snake said to her, he lied, “You will not die. ");
INSERT INTO engnna_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","If you eat (after eating) from that tree, you will become like God, knowing about good and about bad. God doesn't like that. To avoid that he said to you, 'Don't eat from that tree'.” With deceit the snake said to her, “Don't listen to God.” ");
INSERT INTO engnna_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","The woman was looking at the food, looking with interest, it was good. She was thinking, “That food will make me knowledgeable.” The woman wanted to become knowledgeable, like God. Then she went to that tree, broke off food, ate it. She gave some to her husband. He also ate it. ");
INSERT INTO engnna_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","They understood, they saw themselves that they were naked. Then they became ashamed. Because of that they made for themselves pubic covers from big leaves. ");
INSERT INTO engnna_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","In the evening they heard the footsteps of God while he was walking at the water-hole. With fear they hid themselves among the trees on account of God. ");
INSERT INTO engnna_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","God called to the man, “Where are you(sg)?” ");
INSERT INTO engnna_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","He replied, “Yes, I heard you walking at the water-hole. I was naked. Because of that I was afraid, I hid from you. ");
INSERT INTO engnna_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God asked him, “How did you learn you were naked? From that tree, the One that Teaches People About Good and Bad, did you eat food from that?” ");
INSERT INTO engnna_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said to him, “You gave me this woman. She emphasised gave me (food) from that tree. I ate the food.” ");
INSERT INTO engnna_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","God asked the woman, “What did you do?” She said to him, “The snake deceived me. I ate because of his word.” ");
INSERT INTO engnna_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","15","God said to the snake, “You did very badly. In response I will truly do evil to you, not to the rest of the animals, only to you. On your stomach emphasised you will go. You will eat dust always. I will make you dislike the woman. I will make the woman dislike you. Your children and those of the woman will look at each other in anger. The/A child of the woman will truly bruise your head. You truly will bruise his heel.” ");
INSERT INTO engnna_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman he said, “I will give you a lot of pain when you have a child. Knowing about pain when you have a child, continually you will long for a/the man. He will be a boss for you truly.” ");
INSERT INTO engnna_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Then God said to the man, “I told you not to eat that food. You didn't listen to me. Because of your wife's word you ate food from that tree. In response I will make the country bad. Spinifex and prickles and those sorts of things will appear. You will search for food always. You will dig hard for food, Every day you will be exhausted, you will sweat hard getting food to eat. (Lit., “Every day you will break, truly sweat will eat you.”) After dying you will become dust. I made you from the ground. From the dust I made you. After dying you will become dust again. ");
INSERT INTO engnna_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","That man gave his wife the name Eve. She is the mother for us all. ");
INSERT INTO engnna_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Then God made clothes from animal skins for them, for Adam and his wife, God put them on them. ");
INSERT INTO engnna_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Then he said, “The man didn't listen to me, he already ate from the tree that makes knowledgeable. He is now like us, he knows/understands about good and bad. He might eat from that other tree, from the one that keeps alive. After that he will live always, he will stay without death. I will prevent him lest he eat.” ");
INSERT INTO engnna_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","God sent those two from that water-hole in Eden. He sent them away to dig the ground, to put foods in the ground, to cause their foods to come up. ");
INSERT INTO engnna_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","After that God put an angel English word phonemicised east of that water-hole, and a big cutting thing, like a big knife. The point of that big cutting thing was going in every direction, and it was flashing. God told that angel, “You are to stop the man/people from entering close to that tree, to that tree that keeps alive.” ");
INSERT INTO engnna_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam and Eve went from that place Eden. After that Eve had a son. She said, “God has given me a son.” His name was Cain. ");
INSERT INTO engnna_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","After that she had another son. His name was Abel. The two became big. They became men. Abel used to care for sheep. Cain used to dig the ground. He used to put foods in the ground, they used to come up, he used to gather them. ");
INSERT INTO engnna_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Once Cain took food, he gave it to God. ");
INSERT INTO engnna_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","His younger brother took a sheep, he killed it, he gave good parts to God. Abel pleased God. ");
INSERT INTO engnna_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Cain did not please him. Because of that Cain was (habitually) angry. His face changed (became different). ");
INSERT INTO engnna_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","God said to him, “Why are you angry with me? Why did your face change towards me? You should not be sullen. ");
INSERT INTO engnna_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you did right you would have been happy. You were doing badly. You should straighten yourself up to do good. If you do that you will make me happy. If you don't you will keep doing evil.” Missed concept of need to resist temptation. ");
INSERT INTO engnna_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain didn't listen to God. He kept on being sullen. Because of that he said to his younger brother, “Let's go somewhere a long way off.” They went off. Then Cain killed his younger brother. ");
INSERT INTO engnna_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Because of that God asked him, “Where is your younger brother?” The eldest one lied, “I don't know. I don't take care of him.” ");
INSERT INTO engnna_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","God said to him, “You lied. You killed him. His blood is on the ground. You truly did badly. ");
INSERT INTO engnna_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","In response I will do evil to you because of him/it. The ground will stay bad for you. ");
INSERT INTO engnna_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","And foods will not come up for you. I will send you far off. With fear you will keep going to other places.” ");
INSERT INTO engnna_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain said to him, “You have made it extremely hard for me. ");
INSERT INTO engnna_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","I will go about to other places. Perhaps someone will kill me.” ");
INSERT INTO engnna_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","God said to him, “Whoever hits/kills you I will hit/kill him truly because of you.” ");
INSERT INTO engnna_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Because of that Cain went far off. He stayed eastwards a long way from Eden. They call that far country, 'He just keeps wandering around'. ");
INSERT INTO engnna_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","His wife had a child named Enoch. Cain built a town. He named that town for his child, he named that town Enoch also. 4:18-24 omitted. ");
INSERT INTO engnna_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","After Abel died Eve had another child. She said, “Cain killed Abel. God in response has given me another child.” She named him Seth. ");
INSERT INTO engnna_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","7","After a long time there were many people. They scattered, they were everywhere. They all became really bad. They didn't listen to God. They kept on ignoring him. They kept talking to each other about how to do evil. Because of that God said, “The people are all doing bad things. They are always thinking about how to do evil. When I made them they were good, now they have become very bad. Because of that I am broken-hearted (lit: 'my stomach is broken'). I will kill the evil doers, and the animals and birds also.” ");
INSERT INTO engnna_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","10","Just one man pleased God. His name was Noah, he used to listen to God. He used to do good. He didn't do evil. He had three children, three males, their names were Shem, Ham, Japheth. ");
INSERT INTO engnna_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","13","God said to Noah, “All the other people are living really badly. They ignore me, they don't listen to me. They are talking to each other all the time to do evil and they are hitting/killing each other. Because of that reason I will kill them all. ");
INSERT INTO engnna_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","I will make a big flood for them. The big water will swallow them. You I will keep alive. ");
INSERT INTO engnna_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","16","You make a really big boat for fear of the flood. The flood will carry it on top. Make it very big and long and wide. You will make it from wood. ");
INSERT INTO engnna_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","You will enter it with your wife and your children and their wives. Gather animals and birds, cause them to enter the big boat. Collect them, animals, married-pair by married-pair, you will get different kinds pair by pair to make them enter the big boat. You will keep them alive from the flood. ");
INSERT INTO engnna_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And gather for them different foods. For yourselves also heap up food in the boat.” ");
INSERT INTO engnna_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah believed God. He made a very big boat, with wood he made it, long and wide. And he collected a large amount of different foods and put them in (the boat). Truly Noah did all in accordance with God's word. ");
INSERT INTO engnna_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","After that God said to him, “Soon that big rain will fall. Hurry, get in the boat, you and yours. You (sg) alone are characterised by goodness, you alone have been listening to me. For that reason I will keep you and yours alive. ");
INSERT INTO engnna_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Take inside those (previously referred to) animals and birds. Put them in accordance with my word. Take birds, 7 pairs of one kind, 7 pairs of another kind, different kinds. And take tame animals the same way, 7 pairs. And of the remaining animals take pair by pair, different kinds. ");
INSERT INTO engnna_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","I will send rain. It will really pour down, day after day. For 40 days truly. The big flood will kill those outside the boat.” ");
INSERT INTO engnna_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah entered the boat because of God's word. And he took his wife and children and their wives and the animals and birds. They all entered. ");
INSERT INTO engnna_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Then God shut the door. ");
INSERT INTO engnna_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","After that a big rain fell. ");
INSERT INTO engnna_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","And from under the ground a flood came bubbling up also. ");
INSERT INTO engnna_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Rain fell for 40 days. It was falling hard, it really poured, it kept on falling. ");
INSERT INTO engnna_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","There was a really big flood. The water lifted the boat like flotsam, it stayed on top of the water. The flood completely covered the hills and trees. ");
INSERT INTO engnna_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","The father and sons and their wives and the animals stayed alive in the boat. The flood killed the remaining animals and all the people, everything outside. 7:24—8:3 God was caring for those who were in the boat. He sent a wind. After that the flood abated. It was going down slowly for 4 months. They were staying in the boat a long time, they were waiting for the flood to go down. ");
INSERT INTO engnna_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","After that the flood left the boat on top of the hills. It came to rest (lit: 'sat down') on top of the hills. The name of that hilly place was Ararat. ");
INSERT INTO engnna_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The flood was continuing to go down. After that, after 3 months, the heads of the hills appeared after being hidden by the water. The water kept going down. ");
INSERT INTO engnna_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","After that, after one month, Noah sent out a crow. The crow was searching for dry ground and trees. He went away for good, he didn't return. ");
INSERT INTO engnna_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","9","After that, after 7 days, Noah sent another creature, a dove. It was searching in vain for dry ground. Soon it returned to the boat. Noah stretched out his arm, the dove landed on his arm, Noah put him inside the boat. ");
INSERT INTO engnna_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah waited seven days. After that again he sent out the dove. ");
INSERT INTO engnna_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","In the late afternoon it returned to the boat, it carried a leaf in its mouth. Noah said, “The water is really going down.” ");
INSERT INTO engnna_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","After that, in seven days, Noah again tried out the dove. It went away for good, it did not return. It saw ground. ");
INSERT INTO engnna_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah waited one month. After that he looked around. ");
INSERT INTO engnna_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Truly the ground was getting dry, the ground was hard. ");
INSERT INTO engnna_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","17","Then God said to Noah, “You (pl) get down and make the animals and birds get down. They've got to scatter. They have to become many everywhere.” ");
INSERT INTO engnna_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Then they got down from the boat, Noah and his wife and children and daughters-in-law and the different kinds of animals and birds. ");
INSERT INTO engnna_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah heaped up stones. He got a few tame animals and tame birds to give to God. He killed them, on top of the stones he burned/cooked them, bones and all, completely dry, to ashes. They used to do that in the beginning, in order to please God. ");
INSERT INTO engnna_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","In return God said to Noah, “Previously I made it bad for the whole earth because of the evil that people did. I won't do like that again. I know about people. From childhood they are thinking only about how to do really bad (things). I will not again kill people and all creatures truly because of the evil that people have done. I did it once. I won't do it again. ");
INSERT INTO engnna_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Now summer and winter will follow each other. Heat and cold will follow each other. Day and night will follow each other. Just like that they will be.” ");
INSERT INTO engnna_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God spoke kindly to Noah and his children. “You will have many children. They will be everywhere. ");
INSERT INTO engnna_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","You will be boss for all the animals. They will be afraid of you. ");
INSERT INTO engnna_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Now I am giving them all to you to eat, the fish and animals and birds. Previously you only used to eat vegetable food. Now you can also eat meat. ");
INSERT INTO engnna_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","You must not eat blood. When you eat meat, leave the blood without eating it. ");
INSERT INTO engnna_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","7","You should not hit/kill a person. Be good to people. I made people like me. Because of that don't kill a person. If anyone hits/kills a person you(pl) will kill him in return.” ");
INSERT INTO engnna_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","10","God spoke another word to Noah and his children, “I am giving you (pl) this word, for you and yours, and for all the animals and for everything on the ground. ");
INSERT INTO engnna_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Because of this word of mine I will not again hit/kill people and animals and other things by means of a flood. ");
INSERT INTO engnna_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","It will stay like this from now on. I am giving you this word now. ");
INSERT INTO engnna_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I am putting that rainbow of mine in the clouds. ");
INSERT INTO engnna_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Whenever I send you clouds that have rain, I will put my rainbow in the clouds. Truly I will see that. When I see it, truly I will remember this word I am putting down for you today. That rainbow is a reminder for this word. This firm word of mine is for you (pl) and the animals, for everything on the ground. I will not kill everything with a flood. It will stay (the same) from now on.” ");
INSERT INTO engnna_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Those children of Noah, Shem, Ham and Japheth had children. From them all of us came. NOTE: Chapter 10 has been omitted at this stage, because it would merely confuse and distract struggling readers. ");
INSERT INTO engnna_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","After the big flood Noah lived a long time, 350 years. ");
INSERT INTO engnna_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","He became 950 years old. After that he died. ");
INSERT INTO engnna_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","After that for a long time people were talking just that one language. ");
INSERT INTO engnna_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","They were going eastwards a bit at a time. They came to a big plain in the east. The name of that country was Shinar. ");
INSERT INTO engnna_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","They ignored God's word. They said to one another, “Let's not spread out/scatter in all directions. Let's stay united. Let's stay right here, without roaming. Let's make a big camp, let's make a big hill-like (thing) also, extremely big upwards, right up to the sky. Everyone else will talk about us. They will say, 'Those people in Shinar are clever, they are truly smart'.” They got mud, they made bricks, they baked them in the fire to make them hard, they made very many. Joining them they glued them with bitumen. They built, they built. (i.e., they kept building for a long time.) ");
INSERT INTO engnna_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","6","God knew about them. He said, “I told them to spread out. They did not listen to me. They stayed united to do evil. They are staying in one group, they talk one language. They will do more and more evil. ");
INSERT INTO engnna_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lest they do that I will confuse their language. They will talk different languages. Then they will not understand each other.” ");
INSERT INTO engnna_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","God did that. He confused their talk. He made them spread out in every direction. They did not again make their big camp, and the really big hill-like (thing). They left it still unfinished. They left it forever. ");
INSERT INTO engnna_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","The name of that camp was Babel. That word Babel says, 'They were forgetting the same language for each other.' They were puzzling about each other's talk. 11:10-26 omitted. 11:27-32 are in next file (tho' title of that indicates only “12-24”). ");
INSERT INTO engnna_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","28","A long time after that big flood a man appeared, his name was Abram. He was an inhabitant of that country Chaldea. He lived in the town named Ur. His father's name was Terah, his younger brothers were Nahor and Haran. (That Haran had children, a son named Lot, and two daughters named Milcah and Iscah.) While Terah was still alive Haran died in his country, in that town Ur. ");
INSERT INTO engnna_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Nahor and Haran's daughter Milcah got married. Abram and Sarai got married, those two. ");
INSERT INTO engnna_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai could not have a child, she was staying without children. ");
INSERT INTO engnna_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","After that Terah left that town. He took his son Abram, his daughter-in-law Sarai, his grandson Lot, just them. They were going westwards towards another country, Canaan. Partway they arrived at a town named Haran. They settled there for a long time. ");
INSERT INTO engnna_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","While he was there Terah died in Haran. He was really old, he had many years, 205. ");
INSERT INTO engnna_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","While Abram's father was alive God spoke to Abram, “You(sg) will 'you are to'; this future form is often used as a mild imperative, which the hearer has the option of disobeying leave your country, you will leave your father's camp, you will leave the others. You will go to another country, later I will show you, after you arrive there I will tell you, 'This is that very country.' ");
INSERT INTO engnna_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will give you very many grandchildren's grandchildren and those who come after them. I will make you a big boss, I truly will do good to you. ");
INSERT INTO engnna_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Some will do good to you, I will do good to them. Others will do bad to you, I will do bad to them. As a result of your mob I will do good to all people, in other countries everywhere.” ");
INSERT INTO engnna_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","After that Abram went in accordance with God's word. At that time he was old, he had 75 years. He took his wife Sarai, his younger brother's son Lot also, he took his animals and belongings. He took his men also, all his workers, he got them in that town Haran. They all went from Haran, they were going southwards, towards the country Canaan they were going. They were going for many days lit. 'camps, camps they were going'. They arrived there, in Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","They were going. Partway still in Canaan they rested near a big tree, they made a camp site at what's-its-name, near that tree named Moreh. That tree was near the town Shechem. (At that time Canaan's mob were still living in that country too.) ");
INSERT INTO engnna_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","After that God appeared to Abram, he said to him, “This very country I will give to your grandchildren's grandchildren and those who come after them.” Because of that Abram gathered stones there, he made a heap. There he worshipped God lit. 'from the stomach he praised him'. ");
INSERT INTO engnna_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","After that they went southwards to the hilly country east of what's-that-place, Bethel. They made a camp east of Bethel and west of what's-that-place, Ai, there they put their tents. Again he gathered stones, he made a heap, there he worshipped God. ");
INSERT INTO engnna_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","After that they were going southwards, camp after camp, they were going towards the desert. ");
INSERT INTO engnna_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","After that the country became dry, without water, without food. Abram and his animals were staying in a bad way. After that Abram and his mob left that country, they went westwards to that country, to Egypt, to make camp there. ");
INSERT INTO engnna_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As they were going Abram said to his wife, “Your face is beautiful. ");
INSERT INTO engnna_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Those men in Egypt will see you, they will desire you. Perhaps they will say to each other, 'That is his wife. We might kill the man, we will keep the woman alive.' ");
INSERT INTO engnna_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","To avoid that you tell them, 'This is my older brother.' You will do that, they will not kill me, they will do good to me.” ");
INSERT INTO engnna_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","They arrived in the country, in Egypt. The inhabitants of the land saw Sarai. They were thinking, “That woman's face is beautiful.” ");
INSERT INTO engnna_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Some important ones were looking at her, they liked her, they told their big boss, “Wow! That woman, Abram's younger sister, has a really beautiful face.” The boss said to them, “Bring that woman to me.” They took Sarai to him. ");
INSERT INTO engnna_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","In return the boss gave Abram many sheep and cows and donkeys and camels and working people, men and women. ");
INSERT INTO engnna_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Sarai was stopping in the camp of the big boss. After that God made the boss and his mob sick. A very big sickness came on them. ");
INSERT INTO engnna_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","After that the boss sent a message to Abram, “Come here.” He growled at him, “You did the wrong thing to me. You lied to me about your wife. ");
INSERT INTO engnna_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, 'She is a younger sister to me'? Because of your word I took her for a wife. She is your wife. Take her! You two go for good!” ");
INSERT INTO engnna_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","He told his men to send Abram right away. ");
INSERT INTO engnna_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","After that Abram left Egypt. He took his wife and his own younger brother's son Lot, he took all his belongings. Going they all returned to the dry country of Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Camp by camp they were going, they came back to that camp close to Bethel. ");
INSERT INTO engnna_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Right there earlier Abram gathered stones, he was talking to God. After returning he again really worshipped God. ");
INSERT INTO engnna_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","At that time Abram had very many animals, sheep, goats, cattle, donkeys, camels, gold and money, anything. ");
INSERT INTO engnna_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot also was staying there, he had lots of animals and workers. ");
INSERT INTO engnna_vpl VALUES ("GN13_7b","002_13_7b","GEN","13","7b","7b","(There were also some inhabitants of that land there, Canaan's mob and Periz's mob.) ");
INSERT INTO engnna_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","There were no end of animals on that country. Abram's workers and Lot's workers were seaching in vain for grass for the animals. ");
INSERT INTO engnna_vpl VALUES ("GN13_7a","002_13_7a","GEN","13","7a","7a","Because of that the workers of those two were looking at each other with anger. ");
INSERT INTO engnna_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram said to Lot, “We two are relatives. We two should stay without anger. My men and yours should stay without anger. ");
INSERT INTO engnna_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","This country is big. You choose your country. You will go to that country, I will go in another direction.” ");
INSERT INTO engnna_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked around the country eastward, he saw a plain near the river, the name of that river was Jordan. That was good country, with plenty of water, in good condition all the way to Zoar, like the country Egypt. Two towns were in that plain, Sodom and Gomorrah. ");
INSERT INTO engnna_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot chose that very country. He went east. In that way Abram and Lot separated. ");
INSERT INTO engnna_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram stayed in Canaan country, Lot made camp on the plain, near the two towns, close to Sodom he made camp. ");
INSERT INTO engnna_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Those people in Sodom were disobeyers/ignorers of God. They were really bad. ");
INSERT INTO engnna_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After that God said to Abram, “From here look in every direction, northwards, southwards, eastwards and westwards. ");
INSERT INTO engnna_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","All this country I will give you, for you and for your grandchildren's grandchildren and for those who come after them, forever. ");
INSERT INTO engnna_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will look after them, they will become very many. (People) won't be able to name them. ");
INSERT INTO engnna_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","I will give you all this country. You will go through this country, you will look at it.” Like that he told Abram. ");
INSERT INTO engnna_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","After that Abram left that camp, he went to another camp, he was staying at the trees in Mamre, near the town Hebron. Again he heaped up stones, he worshipped God. ");
INSERT INTO engnna_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Lot was staying in his camp on the plain, inside Sodom. After that people from the east, foreigners, gathered together, they came to hit the inhabitants near Sodom. One man from the east, named Kedorlaomer, was boss for his town, for Elam. That very one had earlier made himself boss for the people near Sodom. He forced them by fighting to give money. Those people near Sodom were giving him money for a long time, 12 years. At last they said to each other, “From now we won't give money to Kedorlaomer, we will withhold it. We will not listen to him.” ");
INSERT INTO engnna_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","7","For that reason Kedorlaomer, that Elam boss from the east, and other bosses gathered together, from a few towns they gathered eastwards. They gathered their fighting men together. After that they all went to fight against the inhabitants near Sodom. They were going southwards, they avoided Sodom, that was west of them. They were going southwards, after that westwards, after that northwards, while going through the countries they were killing all the people. At last they came right to Sodom. ");
INSERT INTO engnna_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","The bosses from those towns, from what's-their-names, Sodom, Gomorrah, Admah, Zeboiim and Bela, those bosses gathered together their fighters, with weapons. They went to meet the ones from the east. In that valley, what's-its-name, Siddim, the people from around Sodom and the ones from the east were fighting. ");
INSERT INTO engnna_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","In that valley there were many holes in the ground, with what's-its-name, with bitmumen. Those fighters from Sodom and Gomorrah ran away for fear of the fight. Some entered the holes, others ran to the hilly country. ");
INSERT INTO engnna_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","After that those easterners took for themselves all the food and belongings from Sodom and Gomorrah. ");
INSERT INTO engnna_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They took Lot also, Abram's younger brother's son. They took Lot's belongings. They also took all the other people. They left to go to their own country. ");
INSERT INTO engnna_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","At that time Abram was near Mamre's tree/s. Mamre and his two younger brothers, Eschol and Aner, were friends of Abram. One man ran from the fight, he came to Abram, he said to him, “Those fighters from the east took your brother's son, they took Lot with them.” ");
INSERT INTO engnna_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram when he heard that word gathered his fighting men. Those 318 went with Abram. They followed those (people) from the east. Mamre and Eschol and Aner also went. From behind they were following the easterners, they went a long way northwards, all the way to that country, to Dan. ");
INSERT INTO engnna_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","In the night Abram split up his men, he spread them out. At that very time they hit the easterners hard, they caused them to run away for good, they chased them northwards to another country, towards Homah beyond what's-that-place, beyond Damascus. ");
INSERT INTO engnna_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","After that Abram's men got back all the possessions of the inhabitants of Sodom and Gomorrah, Lot and his possessions, the women and all the other prisoners. After that they all returned southwards. ");
INSERT INTO engnna_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","As Abram was returning to the camp that Sodom boss went to meet him in the valley, named Shaveh valley. ");
INSERT INTO engnna_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Another man, named Melchizedek, also came to him there, he brought bread and wine for Abram. That Melchizedek was boss for that town Salem. From earlier he was also a ceremonial leader for God, for that Boss who is above. ");
INSERT INTO engnna_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","This ceremonial leader Melchizedek said to Abram, “You know God. He is boss above. He is the one who made the sky and the ground and the sea and everything also. I am asking God that he will do good to you. Let us all praise God, the Boss above. He rescued you, for you he hit the fighters from the east completely.” After that Abram from the belongings he brought back gave (some) to him. From 10 cattle he gave one, from 10 sheep he gave one, from everything in that way he gave animals and belongings to Melchizedek. ");
INSERT INTO engnna_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","That Sodom boss said to Abram, “The belongings which have been brought back you will keep for yourself. I only want my people.” ");
INSERT INTO engnna_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Abram replied, “I will not keep your belongings, not any. God is Boss for all, he is the one who made everything, the sky and the ground and the sea also. I have already told God I will not keep your belongings, not even a little cloth. You might say, 'I truly gave Abram all his belongings.' ");
INSERT INTO engnna_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","You might say like that. To avoid that I will not keep your belongings. Just food I will keep for my young men. These others I also took with me, Aner and Eschol and Mamre. Give belongings to those men.” ");
INSERT INTO engnna_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After that God appeared to Abram in a dream. He said to him, “Abram, don't be afraid. I am the one who will look after you for ever. Truly I will give you great possessions.” ");
INSERT INTO engnna_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram answered him, “You are boss for everything. Why will you give me lots of possessions? Still I have no child. After I am dead my worker, that Eliezer, he is the one who will get my possessions. ");
INSERT INTO engnna_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","You have not given me a child. My worker will get all my possessions.” ");
INSERT INTO engnna_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","In reply God said to him, “Not your worker, not Eliezer, he will not get your possessions. Your own child, he is the one who will get your possessions.” ");
INSERT INTO engnna_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","After that God took Abram outside, he said to him, “Look up, look at those stars. They are very many. You cannot count them lit. 'cannot put names on them', they are many. Your own grandchildren's grandchildren and those who come after them also will become very many. You will not be able put names on them, they will be very many.” Like that God spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram listened, truly he believed God. Because of that God became happy with him. ");
INSERT INTO engnna_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Again God spoke to him. “I am the one who earlier told you in the country Chaldea to leave your camp. You came here in accord with my word. This very land I will give you, it will be yours forever.” ");
INSERT INTO engnna_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram said to him, “God, you are the boss for everything. How will I know about that word, it is true?” ");
INSERT INTO engnna_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","God replied, “Bring me animals, one bullock, one goat, one ram. Also bring me one dove and one pigeon.” ");
INSERT INTO engnna_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram brought those animals in accord with God's word. He killed them all. After that the bullock and goat and ram he split down the middle, he separated them. He did not split the birds down the middle. ");
INSERT INTO engnna_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Eagles came, they landed on the meat. Abram frightened them, they went away. ");
INSERT INTO engnna_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","When the sun was setting Abram became deeply asleep. In a dream when he was asleep fear truly came on him. ");
INSERT INTO engnna_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","God said to him, “Listen. You will become old, you will die in this country, they will put you in the ground in this country. ");
INSERT INTO engnna_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Later your grandchildren will go to another country. Not to their country, they will go to the country of foreigners. They will be right there for a long time, for 400 years. The inhabitants of that country will make them work hard, for no money, just for food. Truly they will keep your people for a long time in a very bad way. ");
INSERT INTO engnna_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","After that in return I will hit those inhabitants. After that I will bring your people right back here, they will bring great possessions from that country. ");
INSERT INTO engnna_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","They will stay in that country for 400 years, after that they will come back here. Not now I will give them this country. It is for later. Right now those people what's-their-name, Amu's mob, they are here. This is their country. Later they will become evil-doers, very bad. Right after that I will hit them, truly this country I will give to your people.” Like that God spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","After the sun set, when it had become dark, Abram saw two somethings, a smoking fire thing and something with a light, they were going in the middle of the pieces of meat. ");
INSERT INTO engnna_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","At that time God spoke to him seriously, “Truly I will give this country to your people. The country from here in every direction I will give them, westwards all the way to the river in Egypt, eastwards all the way to the river, to the Euphrates river. ");
INSERT INTO engnna_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","At present the land belongs to many others. I will take it away from them, I will give it to your grandchildren's grandchildren and those who come after them.” The list of the people groups has been summarised by 'many others'. ");
INSERT INTO engnna_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram was staying in that country, in Canaan, 10 years. He was still childless. That wife of his, Sarai, had not had a child. Sarai was keeping another woman from another country, from Egypt, a working woman for Sarai, her name was Hagar. ");
INSERT INTO engnna_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","At that time Sarai said to Abram, “Husband, I am childless. God has withheld children from me. Take my working woman, take her for a wife, you two sleep together. Maybe she will have a child for me.” He replied, “Yes.” ");
INSERT INTO engnna_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","After that Sarai gave that woman Hagar to Abram for a wife. ");
INSERT INTO engnna_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","They slept together, Hagar and Abram. After that Hagar became pregnant. Because of that she became proud towards her boss, Sarai. “She is just nobody”, said Hagar. ");
INSERT INTO engnna_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","After that Sarai became angry with Abram. “I gave you my working woman to keep in the camp. Now after becoming pregnant she has beome proud towards me. You are to blame. God will tell you, I am right.” ");
INSERT INTO engnna_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram said to her, “She is your worker, you are boss for her. Whatever you want with her, do that to her.” After that Sarai was keeping Hagar in a bad way. Because of that Hagar ran away towards the desert. ");
INSERT INTO engnna_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","In that desert in dry country Hagar sat down near a spring. God appeared to her like an angel. ");
INSERT INTO engnna_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","There he said to her, “Hagar, you are Sarai's working woman. Where have you come from? Where are you going?” Hagar replied, “I am running from my boss afraid.” ");
INSERT INTO engnna_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","He said to her, “Return to your mistress, obey her. ");
INSERT INTO engnna_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","I will give you very many grandchildren's grandchildren and those who come after them, you won't be able to count lit 'name' them, they will be very many. ");
INSERT INTO engnna_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","You are pregnant, you will have a child, a boy. Yes, I heard you crying, for that reason you will name your son Ishmael. ");
INSERT INTO engnna_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","When he grows up he will be a fighter against all people, they all will be fighters against him. He will be a solitary dweller.” ");
INSERT INTO engnna_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","After that Hagar thought, “Truly it was God I saw, I am really alive, he did not kill me.” She named God, 'The One Who Habitually Sees Me'. ");
INSERT INTO engnna_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Because of that she named that well, “The Living One Sees Me”. ");
INSERT INTO engnna_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","After that Hagar returned to Sarai. After that she had a child for Abram, a boy. ");
INSERT INTO engnna_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram had 86 years. At that same time Hagar had the child. Abram named him Ishmael. ");
INSERT INTO engnna_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram became old, having 99 years. After that God again appeared to him. He said to him, “I am the greatest lit. 'I truly am another', very strong. All others are weak alongside me. Listen to me, do the right thing always. ");
INSERT INTO engnna_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I will give you many grandchildren's grandchildren and those who come after them. That really true word I give you.” ");
INSERT INTO engnna_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram knelt down with his forehead on the ground. God said to him, ");
INSERT INTO engnna_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“I am putting this my word down for you, truly you will be grandfather for many people. Your grandchildren's grand-children and those who come after them will spread out in many countries. ");
INSERT INTO engnna_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Therefore now I am giving you another name. From now your name will be Abraham. That name says, 'Father For Many'. ");
INSERT INTO engnna_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Yes, I will give you many grandchildren's grandchildren and those who come after them. They will spread out to many countries far and near. From them there will be some important bosses. ");
INSERT INTO engnna_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","This word is for you and for the children who will come after you, it will be forever. I will be a father for all of you. ");
INSERT INTO engnna_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yes, this country, they name it Canaan country, I will give to your grandchildren's grandchildren and those who come after them. Now you are staying in this country like a stranger. Later all this country will belong to your mob forever, I will be a father for them. ");
INSERT INTO engnna_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","11","You and your mob who will come after you must believe my word forever. From now on you must cut euphemism for 'circumcise' all your (pl) males. When you do like that all people will know about you, you are my people. ");
INSERT INTO engnna_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","When the little ones have 8 days you (pl) must cut them all. Your workers also you must cut. Perhaps a working person's male children will be born in your camp. You must cut them. Perhaps you will get with money workers from foreign countries. Those also you must cut. Like that you must do. ");
INSERT INTO engnna_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","You must believe this word of mine. Those who don't believe me will not be my people. They ignore my word. Therefore I will not be a father for them. ");
INSERT INTO engnna_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","This other word I am telling you (sg). Your wife, Sarai, she will have another name. From now you will not name her Sarai. You will name her Sarah. ");
INSERT INTO engnna_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will do good to her, I will give you two a child, Sarah will give birth to a child. Sarah's descendents will become many. They will spread out in every direction, they will settle in different countries. Some from among them will become important bosses.” ");
INSERT INTO engnna_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham knelt down, his forehead down on the ground. He laughed to himself, he said to himself, “I am very old, I have 100 years. How will I now become a father for my child? Sarah is old also, she has 90 years. How now will she give birth to a child?” ");
INSERT INTO engnna_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","After that Abraham said to him, “God, perhaps you will do good to my child, Ishmael, to his descendants also you will do good.” ");
INSERT INTO engnna_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","In reply God said to him, “Truly your wife Sarah, she will give birth to a child. You will name him Isaac. I will look after him, in accord with my word, him and his descendants. They will be my people forever. ");
INSERT INTO engnna_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","You asked me to do good to Ishmael. Yes, I heard you. I will do good to him also, I will give him many people. He will have 12 sons. They will become important bosses. Their descendants will become many. ");
INSERT INTO engnna_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","That Isaac, he is the one who will be mine forever. I will be Father to him. Sarah will give birth to him about this time in one year.” In that way God spoke to Abraham. ");
INSERT INTO engnna_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","After he finished talking to Abraham God went away. ");
INSERT INTO engnna_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","There were very many working men in Abraham's camp. Some he had earlier got with money, others earlier had grown up from infancy in his camp. On that very day Abraham gathered all the men in his camp, old ones and children. On that very day in accord with God's word Abraham cut all the men. Another person cut him also. At that time Abraham was an old man, he had 99 years. His son, Ishmael, had 13 years. Truly on that one day those two were cut, Abraham and his son, Ishmael. ");
INSERT INTO engnna_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Fairly soon after that God again appeared to Abraham. Abraham was staying near the big trees at Mamre. The sun was above. In the heat he was staying in his tent, at the doorway. ");
INSERT INTO engnna_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","He looked, he saw three men standing nearby. Abraham stood up, he ran to them, he knelt down in front of them. ");
INSERT INTO engnna_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","He said to them, “Do not go straight on. ");
INSERT INTO engnna_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Sit down here a while in the shade of the trees. I will get water for you, you can wash your feet. ");
INSERT INTO engnna_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Food also I will bring for you. After eating you will go.” They said to him, “Yes. Good.” ");
INSERT INTO engnna_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham ran to the tent, he told Sarah, “Be quick! Get flour, cook damper for them.” ");
INSERT INTO engnna_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","After that he went outside, he got a bullock, a young one, in good condition. He said to a worker, “Be quick! Kill this animal, cook it.” ");
INSERT INTO engnna_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","After that was done Abraham took meat and milk and other things like that no word for 'cheese', he gave it to them. While the men were eating, Abraham was standing near the trees. ");
INSERT INTO engnna_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","One of those men was really God. He spoke to Abraham, “Where is your wife, Sarah?” “She is in the tent.” ");
INSERT INTO engnna_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","God said to him, “Truly after a year I will return, Sarah will give birth to a child, she will have a boy.” Nearby, inside the tent, Sarah was listening. ");
INSERT INTO engnna_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","She laughed to herself, she said to herself, “I am old, my husband also is old. I am very old, I cannot have a child.” ");
INSERT INTO engnna_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","God said to Abraham, “Why did Sarah laugh? Why did she say to herself, 'I am very old, I cannot have a child.'? ");
INSERT INTO engnna_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","It is not a puzzle for me. Truly I will do in that way. I will return after a year, truly Sarah will give birth to a child.” In that way God spoke to Abraham. ");
INSERT INTO engnna_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","With fear Sarah lied to him, “I did not laugh.” He replied, “Truly you laughed.” ");
INSERT INTO engnna_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","After that those three (previously mentioned) stood up, they went, they were looking towards Sodom. Abraham was going along with them. ");
INSERT INTO engnna_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","As he was going God was thinking to himself, “Those men in those two towns, the inhabitants of Sodom and Gomorrah, they are really bad. I might kill them dead forever. What shall I do, shall I tell Abraham I might do that? Yes I will tell him. ");
INSERT INTO engnna_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","19","I chose Abraham, because of him I will do good to all people, in all countries. I will give him many grandchildren's grandchildren and those who come after them, his mob will become very many, they will become important bosses. Because of that Abraham will tell his mob to listen to me for ever, they will do the proper thing for ever. After they do like that I will do good to them in accordance with my word.” ");
INSERT INTO engnna_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","After that he said to Abraham, “You know about those people in Sodom and Gomorrah. I have heard about them, they have continually been doing evil. ");
INSERT INTO engnna_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","As a result of that word I will go, I will see. Perhaps that word I heard is true.” ");
INSERT INTO engnna_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","After that those other two continued on towards Sodom. God and Abraham stood there. ");
INSERT INTO engnna_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham said to him, “Perhaps some in Sodom do good, they might go in the straight way. How will you act? Will you kill those also. ");
INSERT INTO engnna_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Perhaps 50 inhabitants of Sodom are good. Will you kill all the inhabitants of Sodom? ");
INSERT INTO engnna_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","You should not kill the good ones, only the bad ones you should kill. You should do only good.” ");
INSERT INTO engnna_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","God replied, “For 50 who habitually do good I will not hit that town. I will just leave them all.” ");
INSERT INTO engnna_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham said to him, “I'm nothing, I should not ask. ");
INSERT INTO engnna_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Perhaps there are only 45 habitually good ones in that town. How will you act? Will you kill everyone in the town?” “For 45 habitually good people I will not hit that town.” ");
INSERT INTO engnna_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Again Abraham said to him, “Perhaps there are 40 good ones there.” “For 40 good ones I will not hit that town.” ");
INSERT INTO engnna_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","After that Abraham said to him, “Again I will ask you, please don't look at me with anger, perhaps there are only 30 good ones there.” “For 30 good ones I will not hit that town.” ");
INSERT INTO engnna_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Again Abraham was bold. “Perhaps there are only 20 good ones there.” “For 20 good ones I will not hit that town.” ");
INSERT INTO engnna_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","After that Abraham said to him, “I will ask only once again. Please don't be angry with me. Perhaps there are 10 good ones there.” God replied, “Truly for 10 I will not hit that town.” ");
INSERT INTO engnna_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","After that, after talking to Abraham, God went, Abraham returned to the camp. ");
INSERT INTO engnna_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","The other two continued on towards Sodom. God sent them, those two were angels. They arrived at the town at sundown. At that time Lot, Abraham's younger brother's son, was sitting at the gate of the town. He saw those two, he went to meet them. He bowed to them with his face downwards. ");
INSERT INTO engnna_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","He said to them, “Please come to my camp. You will wash your feet, you will stay in my house. In the morning you can go wherever you want to go.” They replied, “Don't worry. We will stay right here on the level area for the night.” ");
INSERT INTO engnna_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Lot continued to ask them to stay in his house. Therefore they went to his camp. He brought to them flat damper and various good foods. Those two were eating. ");
INSERT INTO engnna_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","While those two were sitting there, Sodom men came to the house. There were young men and old, all the Sodom men, they were standing outside. ");
INSERT INTO engnna_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They called out to Lot, “Where are those two men who came to your house? Bring them to us!” Those Sodom men were truly sex-mad, they wanted those two. ");
INSERT INTO engnna_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went outside, he shut the door behind him. ");
INSERT INTO engnna_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said to them, “Don't do that sort of thing. It is very bad. ");
INSERT INTO engnna_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Listen. I have two daughters, young girls. They have not slept with a man. Let me bring those two daughters to you. Do to them whatever you want. Those two men are strangers, leave them. They came to my camp. Truly I should look after them.” ");
INSERT INTO engnna_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","After hearing that word they became angry. “Go away! Go away! You came here from a long way off, now you will make yourself a boss for us. We will truly do bad to you.” They pushed Lot in another direction, they tried in vain to break his door. ");
INSERT INTO engnna_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","After that those two angels pulled Lot inside the house, they shut the door. ");
INSERT INTO engnna_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","After that they made those Sodom men blind, they could not see. In vain they were searching for the door. ");
INSERT INTO engnna_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","The two said to Lot, “Who from your family are in this town? Children? Sons-in-law? Tell them they must leave this town. ");
INSERT INTO engnna_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Soon we two will truly burn all this town. God knows about the people here, they are very bad. He sent us here to burn everything completely.” ");
INSERT INTO engnna_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot went to his two sons-in-law, the ones his daughters were promised to, he said to them, “Soon God will burn this town completely. Run quickly from here lest you die!” They ignored him, they were thinking it was like a game, that he was only tricking them. ");
INSERT INTO engnna_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","When it became first light the angels said to Lot, “Take your wife and two daughters, all of you run outside this town lest you die!” ");
INSERT INTO engnna_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot was ignoring them, he did not hurry. After that those two angels took him by the hand, they went quickly outside the town. (God had pity on Lot, therefore they did that.) ");
INSERT INTO engnna_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","After that those two said to them, “Run, run! Do not look behind! Do not settle down partway on the plain. Run straight on to the hills lest you die!” ");
INSERT INTO engnna_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Lot replied, “You two with pity have been kind to me, you saved me. Listen to me. The hills are really far away. I can't run as far as there. I might die partway. ");
INSERT INTO engnna_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Do you see that town, that little town over there? I will run as far as there. I will be safe there.” ");
INSERT INTO engnna_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","One said to him, “Yes. You (pl) go there. I will not burn that small town. ");
INSERT INTO engnna_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","23","I will wait a little while for you. As soon as you arrive there I will burn the remaining country. Therefore run!” When the sun had just risen Lot and his two daughters arrived at that town. The name of that small town is Zoar. ");
INSERT INTO engnna_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","25","After that God sent from the sky things like stones with fire, like that they hit those two towns, Sodom and Gomorrah. All the inhabitants died. God also hit the plain, the country became bad, without grass, without trees. ");
INSERT INTO engnna_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot's wife ignored the word from the two angels. She looked behind her towards Sodom, salt covered her. That woman died, salt covered her, it made her like a termite mound. ");
INSERT INTO engnna_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","In the morning Abraham returned to that (previously mentioned) place, to the place where he was talking to God. ");
INSERT INTO engnna_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","From the hills he looked toward the plain, towards Sodom and Gomorrah. Smoke was going up in that direction. ");
INSERT INTO engnna_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","In that way God burned completely the plain and the two towns. Only Lot and his two daughters he sent away from Sodom lest they be killed. God listened to Abraham, he saved Lot. ");
INSERT INTO engnna_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot was afraid to stay in that small town, Zoar. He left there, he went to the hills. He and his daughters were staying in a cave. ");
INSERT INTO engnna_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","One day the oldest one said to her younger sister, “Our father is old, we are without men. In this country there is truly not one man. ");
INSERT INTO engnna_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Let us give father wine to drink. After that, when he is drunk we will sleep with him. In that way we will have a child from our father.” ");
INSERT INTO engnna_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","In the night they gave him wine. After he was drunk the eldest one went to him, she slept with him. Lot did not know that she had come and she had gone away. ");
INSERT INTO engnna_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","On the next day the eldest one said to her young sister, “Last night I slept with father. Tonight we will again give him wine. After that you will sleep with him, you will have a child from him. ");
INSERT INTO engnna_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","That night they again gave wine to their father. After that the youngest one slept with him. Lot did not know she had come and she hadgone away. ");
INSERT INTO engnna_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","In that way Lot's two daughters became pregnant by their own father. ");
INSERT INTO engnna_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The oldest one gave birth to a child, a boy, she named him Moab. They called the ones who came after him Moab's mob. ");
INSERT INTO engnna_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The youngest one also gave birth to a child, a boy. She named him Ben-Ammi. They called the ones who came after him Amu's mob. ");
INSERT INTO engnna_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","After that God's word for Sarah came true for her. Earlier he said to Abraham, “Your wife Sarah will give birth to a child.” In accordance with God's word she had a child, a boy. ");
INSERT INTO engnna_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham named his child Isaac. That name says, 'He Laughs'. ");
INSERT INTO engnna_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","After 8 days Abraham cut him in accordance with God's word. ");
INSERT INTO engnna_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","At that time he was very old, he had 100 years. ");
INSERT INTO engnna_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah was very happy, she laughed, “God made me happy. Others when they hear will be happy, they also will laugh. ");
INSERT INTO engnna_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Everyone was saying I would remain forever without a child for Abraham. Now I have given birth to a child for him after he is old.” ");
INSERT INTO engnna_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The child became big, he left the breast. After that Abraham told his workers to cook a lot of food for many people. After that they all came to Abraham's camp, they were eating that food, they were happy. ");
INSERT INTO engnna_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ishmael, Hagar's son, in play was mocking Isaac. Sarah saw those two, she became upset. ");
INSERT INTO engnna_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","She said to Abraham, “After you die my son, Isaac, he only will get your belongings. That other child, the working woman's child, he will not get your belongings. Send that working woman and her child right away.” ");
INSERT INTO engnna_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sarah's word made Abraham upset. He did not want to send away his own child. ");
INSERT INTO engnna_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","God spoke to him, “Don't be upset about Ishmael and his mother. Listen to Sarah, do in accordance with her word. Earlier I said to you that I will give you many grandchildren's grandchildren and those who come after them. From Isaac they will come. ");
INSERT INTO engnna_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ishmael's grandchildren's grandchildren and those who come after them will be very many. He also is your child. Therefore I will do good to him also.” ");
INSERT INTO engnna_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","In the morning at daybreak Abraham gave Hagar food and water. He put a water container on Hagar's shoulder. After that he sent the two of them away. They were going about in the desert near what's-that-place, near Beersheba. ");
INSERT INTO engnna_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Their water ran out. After that Hagar left her son near a tree. ");
INSERT INTO engnna_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","She went a little way off, she sat down. She said to herself, “Truly my son will soon die. I don't want to see that.” She was really crying for the child. ");
INSERT INTO engnna_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","The lad was crying, God heard him. From the sky he called Hagar, “Hagar, do not be upset, do not be afraid. I heard the lad cry. ");
INSERT INTO engnna_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","I will look after him. I will give him many grandchildren's grandchildren and those who come after them. Now go to him, take him by the hand, make him stand up.” Like that God spoke to her. ");
INSERT INTO engnna_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","After that Hagar looked, God showed her water. She went there, she filled the water container, she took it to the lad, she gave him water. ");
INSERT INTO engnna_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ishmael became big, God was caring for him. He became a hunter. ");
INSERT INTO engnna_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He was staying in the desert, in the country named Paran. His mother got a wife for him from Egypt. 21:22-34 omitted at this stage. ");
INSERT INTO engnna_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","After a long time God tested Abraham. He said to him, “Abraham!” “Yes?” ");
INSERT INTO engnna_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","He said to him, “Your own child, that Isaac, truly you love him. Take him, you two go to a far-off place, to the country Moriah. In the hills I will show you one hill/rock. Right there kill you own child, put his body on the fire, burn it to ashes. Do like that for me.” ");
INSERT INTO engnna_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","At daybreak Abraham got up from sleep. He got firewood, he put it on a donkey. After that Abraham and two workers and Isaac went to that country, to Moriah they were going. ");
INSERT INTO engnna_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","After two camps he saw that hill from far away. ");
INSERT INTO engnna_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","He said to his two workers, “Stay right here, the donkey also. We two, the child and I, will go there, we will give an animal/meat to God. After that we will return to you two.” ");
INSERT INTO engnna_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham put the firewood on Isaac's shoulder. Abraham carried the knife and the firestick. Then they went. ");
INSERT INTO engnna_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac said to his father, “Father!” “Yes?” “We are taking firewood and a knife. Where is that sheep we will kill for God?” ");
INSERT INTO engnna_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham said to him, “God himself will give us a sheep to burn.” After that they were going. ");
INSERT INTO engnna_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","They arrived there, earlier God told Abraham about that place. Abraham gathered stones, he put the firewood on top, he did not light it. He tied up his son, he put him on top of the wood. ");
INSERT INTO engnna_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","After that he picked up the knife to kill the child. ");
INSERT INTO engnna_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","From the sky God called to him, “Abraham! Abraham!” “Yes?” ");
INSERT INTO engnna_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Stop! Do not kill your son! I was just testing you. Earlier I told you, you will kill your son, you will give him to me. You did not withhold him from me. From that I know about you, you continually do what I tell you.” In that way God spoke to Abraham. ");
INSERT INTO engnna_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham looked, he saw a ram close by, its horns were stuck in a tree, it could not pull itself out. He got that animal, he killed it for God. He did not kill his own child, he kept him alive in accordance with God's word. ");
INSERT INTO engnna_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","After that Abraham named that hill “God Is A Giver”. Therefore right up till now they say, “On God's hill God will give to us.” ");
INSERT INTO engnna_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Again God called to Abraham from the sky. ");
INSERT INTO engnna_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","18","“You listened to me, you did not withhold your own child from me. Therefore I will truly do good to you, I will give you many grandchildren's grandchildren and those who come after them. You know about the stars in the sky, they are very many. I am telling you now, I will also make your grandchildren's grandchilden and those who come after them very many. Some might dislike your mob, I will place your mob as bosses for those who dislike them. I will make it very good for your mob. All other people everywhere will say to me, 'God, you truly did good to Abraham's mob. Like that please do good to us also.' You trusted me. Therefore like that I will do good to you. I am putting down my word for you, that word will truly be for you forever.” In that way God spoke to Abraham. ");
INSERT INTO engnna_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","After that Abraham and Isaac returned to the two workers. After that they went to Beersheba. Abraham was staying there. 22:20-24 omitted. ");
INSERT INTO engnna_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","After that Abraham's wife, that Sarah, died. She was very old, having 127 years. She passed away there, at Hebron, in the country Canaan. Abraham cried for her. ");
INSERT INTO engnna_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","After crying for her he went to the bosses of the town. (Those men were Hittites lit. 'Yiti's-plural'.) Abraham talked to those people. ");
INSERT INTO engnna_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“You know me. I came from far away. This is not my country. I am like a stranger/foreigner. My wife has died. Please give me land, there I will put the dead one.” ");
INSERT INTO engnna_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","“Yes, you choose a cave. You are an important boss. Choose a good cave, there you will put your wife. We will not withhold land from you.” ");
INSERT INTO engnna_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham bowed down to them. ");
INSERT INTO engnna_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","He said to them, “Please speak to the man, Zohar's son, Ephron. ");
INSERT INTO engnna_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","You might ask him to give me a cave in what's-that-place, in Machpelah. That cave is on his land. I will give whatever money he wants for that. I will give the money here, you all will see. After that that cave will become mine.” ");
INSERT INTO engnna_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","11","That man Ephron was sitting there among them. He told Abraham, while other men were listening, “Old man, I will give you that cave, that land close to the cave also. You will put your wife there. All the men here heard what I said.” ");
INSERT INTO engnna_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Again Abraham bowed down to the men of the land. ");
INSERT INTO engnna_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","He said to Ephron, “No. I will give you money for that land. Take this money from me. After that that land will be mine, I will put the dead one there.” ");
INSERT INTO engnna_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","That Ephron said to him, “Old man, please listen to me. I might ask you to give me 400 (pieces of) money, but no. I will give the land to you, just take it for no money. You should put your dead one in the cave.” ");
INSERT INTO engnna_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","“No, I will truly give you the money.” Right then Abraham gave Ephron 400 (pieces of) money, in accordance with Ephron's word. ");
INSERT INTO engnna_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Therefore that cave in Machpelah became Abraham's, that land near the cave and all the trees on that land also. Those important bosses were watching. They all knew, Abraham got that land with money. ");
INSERT INTO engnna_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After that Abraham put his dead wife in that cave, in the cave at Machpelah, east of Mamre, in the country Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","In that way that cave and land near the cave became Abraham's forever, for a grave. ");
INSERT INTO engnna_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","At that time Abraham was very old. God was looking after him well, he gave him animals and belongings in abundance, truly he did good to him. ");
INSERT INTO engnna_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","One day Abraham called a man, an important worker of his. He was boss for all Abraham's other workers. He said to him, “You will go to bring a wife for my son. Truly do not bring a woman who is an inhabitant of this country. Certainly not. Go to my own country. Bring a wife for him from my family. Put your hand between my thighs, give me your true word, you will do like that in accordance with my word. You know about God, he is the one who made the sky and the ground. He will hear your word. If you ignore me, he will know about you.” ");
INSERT INTO engnna_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","That worker replied. “That woman might not follow me. She might tell me 'Certainly not'. After that what shall I do? Should I take your son to your country?” ");
INSERT INTO engnna_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham said to him, “Certainly not. You must not take my son there. ");
INSERT INTO engnna_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","God, he is above, earlier he truly told me to leave my country. He gave me his true word, 'Truly I will give this country to your grandchildren's grandchildren and those who come after them.' He will send his angel ahead of you; he will show you a wife for my son. ");
INSERT INTO engnna_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","That girl might say to you, 'I will not follow you, I will stay in my own country.' If she says that just leave her, return without her. Truly you must not take my son to that country to get a wife for him.” ");
INSERT INTO engnna_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","After that that worker put his hand between Abraham's thighs, he gave him his true word, he said to him, “Truly I will do like that.” ");
INSERT INTO engnna_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","After that that worker gathered possessions and gold and various things from Abraham's (belongings). If he should get a young girl, he would give (them) to that girl and her father and mother. After that he got 10 of Abraham's camels, he went towards that country, towards Mesopotamia. He was going camp by camp right to that town, to what's-that-place, Abraham's younger brother, Nahor, used to live there. ");
INSERT INTO engnna_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","One day, at evening, he arrived near a well, outside a town. Water used to spring up there. He made the camels kneel near the well. The women from the town were coming there in the evening to get water. ");
INSERT INTO engnna_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","He talked to God. “God, all the time my master Abraham obeys you. Truly you look after him, Please do good to him now. Show me a young woman for his son. ");
INSERT INTO engnna_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","I am here near the water. Right now young women are coming here from the town for water. ");
INSERT INTO engnna_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","I will ask one to give me a little water. She might tell me, 'Yes, here is water for you. I will bring water for your camels also.' The woman who says she should give water for the camels, she is the one who will be a wife for Isaac. Like that will you show me that young girl. If you do that, I will know about you, you are taking care of Abraham.” ");
INSERT INTO engnna_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Just as he was talking to God, Rebekah came, she was carrying a water container on her shoulder. That young girl had a beautiful face. She had not slept with a man. She did not have a promised one. (Her father's name was Bethuel. Bethuel's mother's name was Milcah, his father's name was Nahor. That Nahor was Abraham's younger brother.) Rebekah came down to the well, she filled the water container, she climbed back up. ");
INSERT INTO engnna_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","The old man went quickly to meet her, he said to her, “Please give me a little water from the container.” ");
INSERT INTO engnna_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Yes, old man, here is water for you.” Straight away she put the water container from her shoulder on to her hand, she poured water for him. He drank it. ");
INSERT INTO engnna_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","After that the young girl said to him, “I will get water for the camels also, they will drink until they are satisfied.” ");
INSERT INTO engnna_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Straight away she poured water into the animals' drinking container. After that she hurried back to the well, she went down, again she scooped up water, she was bringing water for all the camels. ");
INSERT INTO engnna_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Quietly that old man was watching her, He was thinking to himself, “This young girl might be a wife for Isaac.” ");
INSERT INTO engnna_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","The camels drank till satisfied. After that the old man gave the young girl a gold nose-thing, he put on her arms two gold arm-things also. ");
INSERT INTO engnna_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","He said to her, “Who is your father? Perhaps I and my workers can sleep one night in your father's camp?” ");
INSERT INTO engnna_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She replied, “My father is Bethuel. He is Nahor's son, his mother is Milcah. ");
INSERT INTO engnna_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","You can all stay in our camp. Our camp is wide. We have grass for your camels.” ");
INSERT INTO engnna_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The old man bowed face down to God, he worshipped him, he said to him, ");
INSERT INTO engnna_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“God, you are good. Thank you, you helped us. You gave your word to my master Abraham. Truly you kept that word. You brought me straight here, to my master's mob, to his own family.” ");
INSERT INTO engnna_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","After that that young woman hurried to her mother's camp, she reported to them the old man's talk. ");
INSERT INTO engnna_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Rebekah's older brother, Laban by name, was there. He saw those two arm-things and the nose-thing. He heard his younger sister's talk. Then he hurried to the old man. He was standing near the well, close to the camels. ");
INSERT INTO engnna_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban said to him, “God is pleased with you. Do not stay here. Come, you will come to our camp. We have made ready for you and your workers. Your camels will rest there also.” ");
INSERT INTO engnna_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","They all went to Laban's house. There Laban loosed the riding gear from the camels, he gave them grass. After that he brought water for the old man and the workers for them to wash their feet. ");
INSERT INTO engnna_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","After that he brought food to the old man. The old man said to him, “Let me tell you why I came. After that I will eat.” “Yes, you will tell us why you came.” ");
INSERT INTO engnna_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","The old man said to Laban and his father, “I am a worker of Abraham's. ");
INSERT INTO engnna_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","God has truly done good to my master. He made him an important boss. He gave him many animals, sheep and goats and cattle and camels and donkeys. He gave him gold money, working men and women also. ");
INSERT INTO engnna_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Yes, when he was old his wife, Sarah, gave birth to a boy child for him. My master gave all his money and animals and belongings to that very son. ");
INSERT INTO engnna_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","He said to me seriously, 'You will bring a wife for my son. Do not choose a young woman who is an inhabitant of this country, an inhabitant of Canaan. You will go to my father's country, you will go to my family's camp. From there you will get a wife for my son.' Like that my master told me. ");
INSERT INTO engnna_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I said to him, 'Perhaps that young woman will not follow me.' ");
INSERT INTO engnna_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","He replied, 'God will send his angel ahead of you. That angel will show you a girl from my father's family. ");
INSERT INTO engnna_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","They might say to you, “Certainly not. We will not give her as a wife for Abraham's son.” If they speak in that way just leave her, return without the young woman.' In that way Abraham spoke to me. ");
INSERT INTO engnna_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Today I arrived at the well near your town. I said to God, 'God, my master Abraham obeys you, he is in your mob. Now please do good to me. Show me that wife for Isaac. ");
INSERT INTO engnna_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","I am here near the well. After the young women come for water I will ask one, “Give me a little water from your water container.” ");
INSERT INTO engnna_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Perhaps she will reply, “Yes, here is water for you. I will bring water for your camels also.” If she talks in that way she will be the wife for Isaac. Show me that very same young woman.' ");
INSERT INTO engnna_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","While I was still talking to God, Rebekah came, she was carrying a water container on her shoulder. She got water. Then I asked her, 'Please give me water to drink.' ");
INSERT INTO engnna_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Quickly she lowered the water container, she said to me, 'Yes, here is water for you. I will bring water for your camels also.' After that I drank, she gave water to the camels also. ");
INSERT INTO engnna_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","After that I asked her, 'Who is your father?' She said to me, 'My father is Bethuel. He is Nahor's son, his mother is Milcah.' After that I put the nose-thing on the young woman, I put two arm-things on her arms. ");
INSERT INTO engnna_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","God showed me the wife for Isaac from my master's own relatives. Therefore I bowed face downwards, I worshipped God, I said to him, 'Thank you. You have helped me.' ");
INSERT INTO engnna_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Yes, what will you say? Will you tell my master, 'Yes'? Will you give this young woman fo his son? If you don't I will do something different.” ");
INSERT INTO engnna_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban and Bethuel replied, “God has done this. This young woman will go. We won't prevent her going. ");
INSERT INTO engnna_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","You will take Rebekah, you will all go. She will become the wife of your master's son in accordance with God's word.” ");
INSERT INTO engnna_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When he heard their word that old man, Abraham's working man, knelt down, he said to God, “Thank you. You have helped me.” ");
INSERT INTO engnna_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","After that he gave Rebekah gold and good belongings. He gave Rebekah's brother and mother other good belongings also. ");
INSERT INTO engnna_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","After that the old man and his workers ate food, they drank wine. They slept right there. In the morning after getting up from sleep the old man said to them, “Today I will return to my master, I will take the young woman also.” ");
INSERT INTO engnna_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebekah's brother and mother replied, “Please wait a while! That young woman should stay here a little while, maybe for 10 days she will stay. After that we two will send you all away, the young woman also.” ");
INSERT INTO engnna_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","He said to them, “God has done good to me. Now I should go soon to my master. Please don't prevent me.” ");
INSERT INTO engnna_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Please wait. We will ask the girl what she will say.” ");
INSERT INTO engnna_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","They called her. When she came they asked her, “Will you go with these people?” Rebekah answered, “Yes.” ");
INSERT INTO engnna_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","After that they sent Rebekah to go with the old man and his workers. There was an old woman there, she earlier looked after Rebekah and raised her. They sent her also. ");
INSERT INTO engnna_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","They spoke kindly to Rebekah. “Truly we want God to do good to you. We want your grandchildren's grandchildren and those who come after them to become very many. Some people might hate them, we want your mob to become bosses for those others who hate them.” ");
INSERT INTO engnna_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","After that Rebekah and her working women climbed on camels, they followed the old man. In that way the old man transported Rebekah, he was returning to his master. ");
INSERT INTO engnna_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","At that time Isaac was in the south of Canaan country, in the area of the water-hole, what's-its-name, Lahai-Roi. ");
INSERT INTO engnna_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","One evening he was just walking around, away from his camp, he saw the camels coming. ");
INSERT INTO engnna_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","From a long way off Rebekah saw Isaac, she got down from the camel. ");
INSERT INTO engnna_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","She asked the old man, “Who is that man coming towards us?” “He is my master, Isaac.” Rebekah got a cloth for her face, she covered her face. ");
INSERT INTO engnna_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Then the old man reported everything to Isaac. ");
INSERT INTO engnna_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","After that Isaac took Rebekah to a tent. That tent earlier was his mother's. He was sad after his mother died. Now Rebekah became his wife. Isaac truly loved her. Right after that he became happy, he was not sad for his mother. ");
INSERT INTO engnna_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham earlier took another wife. Her name was Keturah. Earlier: Implied. Abraham was 137 when Sarah died. His fathering of children by Keturah must have been before 17:17, when Abraham was 99, and probably before Hagar and Abraham produced Ishmael, when Abraham was 85. ");
INSERT INTO engnna_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","6","Those two had 6 sons, their children. In that place they grew up. Their father gave them belongings. After that he sent them to another country, eastwards. He sent them away from Isaac. After that he gave all the rest to Isaac, whatever belongings he had. ");
INSERT INTO engnna_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham was very old, having 175 years. After that he died. ");
INSERT INTO engnna_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","His two sons Isaac and Ishmael put their father in a cave at Machpelah. Earlier that same cave used to belong to another. Abraham got it with money, a lot of money he gave Ephron for that cave and land. When his wife Sarah died Abraham put her in that cave. In that same cave now his two sons also put him. ");
INSERT INTO engnna_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After that God took care of Isaac. Isaac made his camp at the water-hole, what's that place, Lahoi-Roi. 25:12-20 omitted. ");
INSERT INTO engnna_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac and his wife were staying there a long time without children. Isaac asked God, “Will you give my wife a child.” God listened to him, afterwards his wife became pregnant. ");
INSERT INTO engnna_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","She had two children in her womb. They were wrestling. Rebekah was upset. She asked God, “Why?” ");
INSERT INTO engnna_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","God told her, “You will give birth to two males. The descendants of those two will argue with each other, they will separate from each other. The descendants of the youngest one will be strong, they will be bosses for the others.” ");
INSERT INTO engnna_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","After that Rebekah gave birth to two children, males. ");
INSERT INTO engnna_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The oldest one appeared red and hairy. Therefore they named him Esau. ");
INSERT INTO engnna_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","After that the younger one appeared. He was holding his older brother's heel. Therefore they named him Jacob. At that time Isaac was old, having 60 years. ");
INSERT INTO engnna_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Those two Esau and Jacob became big, they became men. Esau was a hunter, he used to go out for meat. Jacob used to stay in the camp, he used to work for his father. ");
INSERT INTO engnna_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esau used to bring meat for his father to eat. That is why Isaac used to like his eldest one. The mother used to like the youngest one. ");
INSERT INTO engnna_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day Jacob was cooking food, red food, the name for that is lentil. Esau returned after having gone hunting. He was hungry. ");
INSERT INTO engnna_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","He said to his younger brother, “I am hungry. Give me some of that red food.” (Because of that they gave him another name, Edom.) ");
INSERT INTO engnna_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob replied, “Wait a bit! Tell me your true word. You are the eldest one. Later our father will die. After that you will be boss for us two. You will get the big lot of the belongings. I will get the small lot. Tell me I will be like the older brother. Tell me like that, after that I will give you food.” ");
INSERT INTO engnna_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau replied, “Without the food I might die. After that I will not get the belongings, I will not be older brother for you. That is just true. Give me some of that food!” ");
INSERT INTO engnna_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob replied, “Give me a straight word. After that I will give you food.” Esau thought to himself he should just stay not being boss for him, he was wanting to be without caring. He gave the word to him, “Yes, you can be like the older brother.” ");
INSERT INTO engnna_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Therefore Jacob gave him damper and red food. After that Esau ate, he drank, he went away without caring. ");
INSERT INTO engnna_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau was 40 years old, he got two wives. Those two women were local inhabitants, from Hiti's mob. ");
INSERT INTO engnna_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaac and Rebekah were unhappy because of their daughters-in-law. The daughters-in-law made them really upset. ");
INSERT INTO engnna_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac became old he became blind. One day he called for his oldest one, Esau, “Oldest one, come here!” “Yes, what?” ");
INSERT INTO engnna_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","The father said to him, “Listen! I have become old. I might die anytime now. ");
INSERT INTO engnna_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","While I am alive I will tell you a word, God will do this good thing for you. Listen to me, take your weapons for going hunting. Having killed, cook for me really tasty meat. When I have eaten it I will tell you the word in preparation for my death.” ");
INSERT INTO engnna_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","While he was talking to Esau, Rebekah was listening to him. Esau went from the camp to go hunting. ");
INSERT INTO engnna_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","After that Rebekah said to the youngest one, “I heard your father telling your older brother, ");
INSERT INTO engnna_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","'Go hunting, having killed and returned, cook for me really tasty meat. When I have eaten I will tell you my good word, in preparation for my death.' That is how he spoke to your older brother. ");
INSERT INTO engnna_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","You listen to me, youngest one. ");
INSERT INTO engnna_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go, choose two small goats. When you have killed them bring them to me. On your behalf I will cook really tasty meat for your father, his favourite. ");
INSERT INTO engnna_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","You will take that meat to your father. Then it will be to you he will tell the good word in preparation for his dying.” ");
INSERT INTO engnna_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob said to her, “Listen to me. My older brother is hairy, I am smooth, without hair. ");
INSERT INTO engnna_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Father might touch me. After touching me he might realise I am the youngest one, he might realise I lied. I might make trouble for myself!” ");
INSERT INTO engnna_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","His mother said to him, “Don't be afraid! Let the trouble come to me instead of you. Do what I say. Bring me two goats.” ");
INSERT INTO engnna_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob listened to his mother. He killed two goats, he took them to his mother. She cooked really tasty meat for his father. ");
INSERT INTO engnna_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Then Rebekah got good clothes belonging to the eldest one, Esau's (clothes), she gave those garments to the youngest one. “Put these clothes on yourself.” ");
INSERT INTO engnna_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","After that she got a few bits of skin from the goats, she put them on his hands and neck. ");
INSERT INTO engnna_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","She gave Jacob the cooked meat and damper. “Take this food to your father.” ");
INSERT INTO engnna_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Then he took the food to his father, he said to him, “Father!” “Yes, who are you?” ");
INSERT INTO engnna_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob lied, he said to him, “I am the eldest one, Esau. Having gone I have returned to you with meat, as you told me. Sit up now, eat this really tasty meat. After you have eaten tell me the word of how God will do good to me.” ");
INSERT INTO engnna_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac said to him, “Wow! You got the meat quickly.” Jacob lying said to him, “Your boss, God, showed me the meat quickly.” ");
INSERT INTO engnna_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac said to him, “You talk like someone else. Come here! After touching you I will know if you are telling the truth.” ");
INSERT INTO engnna_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","23","After that he came close to him. His father touched him. The goat skin deceived Isaac. “You talk like Jacob, your hand is like Esau's.” ");
INSERT INTO engnna_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wanting to be sure, his father asked him, “Are you really Esau?” “Yes, I am Esau.” ");
INSERT INTO engnna_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Pass me that meat. After eating it I will tell you my word.” Jacob took the meat to him, he gave him something to drink also, red wine. ");
INSERT INTO engnna_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then after eating Isaac said to him, “Come here to me, hug me.” ");
INSERT INTO engnna_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","He came to him, he hugged him. Isaac smelled Esau's clothes. He said to Jacob, “My son, you smell like grass, you smell like grassy country, very pleasant. God has been looking after that country. ");
INSERT INTO engnna_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God will send rain for your country. Many foods will come up in all directions from the vegetation on your country. He will give you a lot of food and water to drink. ");
INSERT INTO engnna_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","People from far away, from other countries will work for you, they will obey you. You will be boss for your younger brothers, your mother's children will kneel down at your feet. Some will hate you, they will ask God to do evil to you. In response God will do evil to them. Some will do good to you. In response God will do good to them.” In that way Isaac spoke to Jacob. Like that he said God would do good to him. ");
INSERT INTO engnna_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","After that Jacob went, he left his father there. Soon Esau returned from hunting. ");
INSERT INTO engnna_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He cooked tasty meat. After cooking it he took it to his father. “Father, sit up. Eat this meat from me. When you have eaten it you will tell me God's good word, God will do good for me.” ");
INSERT INTO engnna_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac asked him, “Who are you?” “I am your eldest one, Esau.” ");
INSERT INTO engnna_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","As soon as he heard Esau's word he trembled with fear. “Who, after killing meat, gave it to me? I finished eating the meat, all the meat. I gave my good word for him. Yes, God will do good to him in accordance with my word.” ");
INSERT INTO engnna_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","As soon as Esau heard that word he became upset. Truly he cried loudly there. He begged his father, “Give your good word to me also!” ");
INSERT INTO engnna_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","He said to him, “No, truly! I gave him my good word. Your younger brother deceived me for that word. I gave him my good word. I truly cannot give you that word.” ");
INSERT INTO engnna_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau said to him, “My younger brother is a deceiver of people. Jacob is a good name for him. Twice my younger brother has deceived me. He tricked me into saying he is like an older brother for me. He tricked you about God's word, you gave it to him, you did not give it to me. Will you give me also your good word. In that way God will do good to me also.” ");
INSERT INTO engnna_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac said to him, “With what word can I talk to you, my son? I put your younger brother boss for you. His relatives will all obey him. I told him he will get much food and drink.” ");
INSERT INTO engnna_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “Give me a small good word! Tell me one good word!” He cried loudly. ");
INSERT INTO engnna_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","His father said to him, “You will stay in poor country. Insufficient rain will fall on your country. ");
INSERT INTO engnna_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will stay as a fighter there. Your younger brother will stay a boss for you. And later you will separate from him. After that he will not force you to work. That is the word I am giving you, son.” ");
INSERT INTO engnna_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","After that Esau was thinking about his father's good word from God, his father gave it to Jacob. Therefore Esau did not like his younger brother. He was thinking, “Later my father will die. We will cry for him. After that I will kill my younger brother.” ");
INSERT INTO engnna_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Someone learned about that word of Esau's and told their mother. Rebekah called to the younger one, she said to him, “Your older brother will kill you dead. In response they will kill him also. I will be without children. ");
INSERT INTO engnna_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Listen to me, lest you die. Go from here. Go to another country, to what's-its-name, to Haran, to my older brother Laban. ");
INSERT INTO engnna_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay there with him for a while. ");
INSERT INTO engnna_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Later your older brother will forget about that lie of yours. After that he will feel good towards you without anger. Then I will send a message for you. I want you both to stay alive, not dying.” In that way Rebekah talked. ");
INSERT INTO engnna_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","After that Rebekah said to her husband, “I do not like those two wives of Esau's. Maybe Jacob will choose a wife from this country, from Hiti's mob. If he does that I will not want to stay alive, I will die.” ");
INSERT INTO engnna_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac called for Jacob, he talked kindly to him, “You choose a wife not from here, not from Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Go from here a long way to another country, to what's-the-place, to Mesopotamia. Go to the camp of what's-his-name, of Bethuel, your mother's father. Get for yourself a wife from right there, from your uncle Laban's family. ");
INSERT INTO engnna_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","God will do good to you, he will give you many children, you (pl) will become very many. ");
INSERT INTO engnna_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","God earlier made a promise to your grandfather Abraham, he told him, 'This country will be for your family for ever.' In accordance with that word he will give you this country. Now you are staying here like a stranger. Later God will give you this country forever.” ");
INSERT INTO engnna_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","After talking like that Isaac sent Jacob far away. After that Jacob was going towards Mesopotamia, he was searching for his uncle Laban, in what's-that-place, in the country Aram. That Laban was the son of Bethuel. He was the older brother of Rebekah, the mother of Esau and Jacob. 28:6-9 has been omitted. ");
INSERT INTO engnna_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob left that country Beersheba, he was going towards that town Haran. ");
INSERT INTO engnna_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","After the sun went down he made his camp partway. He was sleeping with his head on a stone. ");
INSERT INTO engnna_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","There in sleep he dreamed. He saw a what's-its-name, a thing for climbing. One end was on the ground, the other was in the sky. Some of God's angels were climbing, some were coming down. ");
INSERT INTO engnna_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","There in the dream he saw God also, he was standing near the top of the thing for climbing. He said to Jacob, “I am God. I am the one who was looking after Abraham and Isaac, your grandfather and father. Those two also belong to me. This country where you are now sleeping I will give you, for you and your children. ");
INSERT INTO engnna_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","You will get many grandchildren's grandchildren and those who come after them, very many indeed. They will spread out in all directions, west and east, north and south. As a result of your mob I will do good to all people in all countries. ");
INSERT INTO engnna_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I will be with you wherever you go. Later I will cause you to return to this country. I will not leave you, I will be with you. I will do for you what I said to you.” In that way God spoke to Jacob. ");
INSERT INTO engnna_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","After that Jacob woke up from sleep. He was afraid. “Wow! God is here, I did not know, I was just sleeping. This camp makes me afraid. Wow! Truly this is God's camp, the gate that leads to his camp in the sky is right here!” ");
INSERT INTO engnna_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","At daybreak Jacob got up from sleep. Then he got that stone, the one his head had been lying on, he stood that up, he poured oil on that stone. He did that to remind him God talked to him there. ");
INSERT INTO engnna_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He named that camp Bethel. That name says, 'God's House'. (Close to that camp there was a town, earlier they named it Luz.) ");
INSERT INTO engnna_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","After that he said to God, “You told me you will be with me, you will care for me, you will give me belongings and food, ");
INSERT INTO engnna_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","you will look after me, I will return to my father's camp. If you do like that for me, in exchange I will obey you whatever you tell me. ");
INSERT INTO engnna_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","I will talk to you at this rock I stood up. If you give me 10 possessions, I will give you one in return.” Like that he talked to God. ");
INSERT INTO engnna_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","After that he went from Bethel on foot. At last he came to them in another country, in the east. ");
INSERT INTO engnna_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","After that he was looking around, truly he saw a well, a big stone covered it. There he saw a few groups of sheep, they were lying close to the water, they were waiting for water. ");
INSERT INTO engnna_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","In the distance other people also were bringing their sheep, they were bringing them to the well. As soon as all had arrived at the water the people in charge of the sheep used to move that stone back. After giving water to the sheep they used to put that stone back to cover the well. ");
INSERT INTO engnna_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob said to the people in charge (of the sheep), “Where is your camp?” They answered him, “We are from the town, from what's-its-name, from Haran.” ");
INSERT INTO engnna_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","He said to them, “Do you know Laban, Nahor's grandson?” “Yes, we know him.” ");
INSERT INTO engnna_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Is he well?” “Yes, he is well. Look, that is his daughter, she is coming now with sheep.” ");
INSERT INTO engnna_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","He said to them, “Listen. The sun is still above. Why are you bringing the sheep when the sun is above? Quickly give them water, then quickly take them to the grass.” ");
INSERT INTO engnna_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","They replied, “We shouldn't give water yet, we will wait for the rest of the sheep. Truly after that we will move back this stone, when we have done that we will give them water.” ");
INSERT INTO engnna_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While they were still talking, Rachel arrived with her father's sheep. She was the one who used to look after them. ");
INSERT INTO engnna_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","As soon as he saw Rachel and his uncle's sheep Jacob went to the well, he moved back that big stone from on top, he gave water to his uncle's sheep. ");
INSERT INTO engnna_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then he hugged Rachel. ");
INSERT INTO engnna_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","He said to her, “Your father is older brother for my mother. My mother is Rebekah.” Rachel ran to tell that word to her father. ");
INSERT INTO engnna_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","After hearing that word Laban went quickly to his nephew. He hugged him, he took him to his camp. Jacob told him how he came from far away, from another country, his own. ");
INSERT INTO engnna_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban said to him, “You are my own nephew. Stay here with me.” Jacob stayed there, he worked for his uncle for one month. ");
INSERT INTO engnna_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","After that Laban said to him, “You are my own nephew. You were just working for me. Now after working what shall I give you?” ");
INSERT INTO engnna_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban had two daughters. One was Leah, the other Rachel. ");
INSERT INTO engnna_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah's eyes were a bit bad. Rachel was very attractive. ");
INSERT INTO engnna_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob was liking Rachel, he was wanting her for his wife. Therefore he said to Laban, “I will work for you for 7 years. After that you will give me Rachel as a wife.” ");
INSERT INTO engnna_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban said to him, “Yes. I will give this Rachel to you, not to others. Truly you will stay right here with me.” ");
INSERT INTO engnna_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","After that he was working for his uncle for a long time, for 7 years. Truly he liked that girl. Therefore he was working, he was waiting 7 years, he was thinking it was like a few days he was working for that girl. ");
INSERT INTO engnna_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","After that he said to his uncle, “I worked for you for 7 years. Quickly give me my promised one.” ");
INSERT INTO engnna_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban sent word to the people nearby to come to his camp. “We will all eat food for these two when they are joined, they will be man and wife.” Then his workers cooked a lot of food for them to eat. ");
INSERT INTO engnna_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","25","After it became dark Laban brought Leah, Rachel's older sister, to Jacob, he said to him, “This one now is your promised one.” (Laban gave one working woman to Leah, her name was Zilpah.) That night Jacob slept with Leah. As soon as he woke up, he saw it was another, Leah. Then he became angry, he said to his uncle, “Why did you deceive me? I worked for you for another woman, for Rachel. Why did you give me Leah?” ");
INSERT INTO engnna_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban said to him, “This little one I will keep for you. The big one will be first. That is the way we do it. ");
INSERT INTO engnna_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Wait for just a little while. Let us complete 7 days for this one, after that I will give you her younger sister for a wife. After that you will work for me for 7 years for that little one.” ");
INSERT INTO engnna_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob listened to Laban. “Yes, I will again work for you.” Then he was staying with Leah for 7 days, after that Laban gave him another wife, Rachel. ");
INSERT INTO engnna_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban gave one working woman to Rachel, her name was Bilhah.) ");
INSERT INTO engnna_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob slept with Rachel also. He loved Rachel a lot, he didn't care about Leah. For that wife Rachel he was again working for his uncle for 7 years. ");
INSERT INTO engnna_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","God knew about Jacob, he did not love Leah. God was sorry for Leah, he gave her children. Her younger sister was staying without children. ");
INSERT INTO engnna_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah became pregnant. Truly she got a male child. She thought about God, “God felt sorry for me. He gave me this boy. Truly my husband will love me, I got this child for him.” So she named that eldest child Reuben. ");
INSERT INTO engnna_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","After that she got another child, a male. “God knows about my husband, he does not love me, therefore God gave me another child.” So she named that child Simeon. ");
INSERT INTO engnna_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","After that she got another child, a male. Then she said, “I gave my husband three male children. Now truly he will love me.” So she named that one Levi. ");
INSERT INTO engnna_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","After that she got another child, a male. She said to God, “Thank you, God. I will praise you.” So she named that child Judah. After that she did not have any more children for a long time. ");
INSERT INTO engnna_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel was staying without children. She was jealous of her older sister. She said to her husband, “Don't withhold children from me. Let us two get a child. If not I will die.” ");
INSERT INTO engnna_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob after that became angry with his wife. “Don't look at me. Truly I am not like God. God is the one who has prevented you from having a child.” ");
INSERT INTO engnna_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel said to Jacob, “That woman now, my worker, Bilhah. You two sleep together. She will get a child for me. That child will be mine.” Like that Rachel spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","After that Jacob slept with that working woman. ");
INSERT INTO engnna_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah became pregnant, she got a male child. ");
INSERT INTO engnna_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel said, “I asked God if he would give a child for me. He listened to me, he gave me a male child.” So she named that child Dan. ");
INSERT INTO engnna_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Again that working woman became pregnant, then she got another child, a male. ");
INSERT INTO engnna_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel said, “My sister and I have been struggling with each other because of children, I truly got this child, my sister did not prevent me.” So she named that child Naphtali. ");
INSERT INTO engnna_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah was thinking, “For a long time I did not give birth to a child. I will give my working woman to my husband. She will get a child for me.” ");
INSERT INTO engnna_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Therefore Zilpah gave birth to a male child for Jacob. ");
INSERT INTO engnna_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “Very good.” So she named that child Gad. ");
INSERT INTO engnna_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","After that Zilpah got another child, a male. ");
INSERT INTO engnna_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “I am happy. Women will call me 'Happy One'.” So she named that child Asher. ");
INSERT INTO engnna_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","It became summer for them. People were getting that food, what's-its-name, wheat. At that time Reuben, Leah's eldest one, went from the camp a long way. He saw that medicine from the desert, what's-its-name, mandrakes. He got some, he took them to his mother. Rachel asked her older sister, “Give me some of those mandrakes belonging to your child.” ");
INSERT INTO engnna_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Then Leah became angry with her. “You took my husband, now you are begging for what my child got, that medicine to make (a woman) pregnant.” Rachel replied, “Give me some of the mandrakes. In exchange you will sleep with our husband tonight.” ");
INSERT INTO engnna_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","In the evening Jacob returned to the camp from far away after work. Leah met him. The she said to him, “Tonight we two will sleep together. I gave my sister some mandrakes my child got. Therefore she told me we will sleep together.” That night truly those two slept together. ");
INSERT INTO engnna_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God listened to Leah, after that she became pregnant. After that she got another child, a male. ");
INSERT INTO engnna_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah said, “I gave my working woman to sleep with my husband. After doing like that God gave me another male child.” So she named that child Issachar. ");
INSERT INTO engnna_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","After that Leah got another child, a male. ");
INSERT INTO engnna_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","She said, “God has done good to me. I have had 6 sons for my husband. Because I have done that he will say I am a real woman.” So she named that child Zebulun. ");
INSERT INTO engnna_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Later on she got another child, a female. She named that one Dinah. ");
INSERT INTO engnna_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","For years and years Rachel had been begging God to give her children. At last he listened to her. ");
INSERT INTO engnna_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Truly she became pregnant, she got a child, a male. She said, “For years and years I was ashamed from being without children. Truly God gave me a child. They will not make me ashamed any more.” ");
INSERT INTO engnna_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She said, “Perhaps God will give me another son.” So she named that child Joseph. ");
INSERT INTO engnna_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","As soon as Joseph was born Jacob said to his uncle, “I will return to my own country. ");
INSERT INTO engnna_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Truly I worked for you for my wives (dual) and children. You know that. Now I will take them. Do not make me stay. I will go.” ");
INSERT INTO engnna_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban said to him, “Listen to me. I want you to stay here. As soon as you came from over there earlier God did good to me, he gave me many tame animals. I know about that by magic from above. Resulting from that I want you just to stay with me. ");
INSERT INTO engnna_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Name for yourself whatever you want, I will give you whatever, after that you will stay with me.” ");
INSERT INTO engnna_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob said to him, “I have worked comepletely for you. I took good care of your animals. You know that. ");
INSERT INTO engnna_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","You had a small number of animals. As soon as I came here they became many. I worked for you. Therefore God gave you lots of belongings. From now on I must take good care of my children.” ");
INSERT INTO engnna_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Laban asked him, “What shall I give you? Tell me.” Jacob replied, “Do not give me money. Wait, I will tell you. Today I will look at your animals, I will separate them. I will take the black sheep and the spotted and striped goats. Those particular ones. They will be mine, all the others will be yours. If you say yes, I will stay with you, I will take care of your animals for you. ");
INSERT INTO engnna_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Later you will see I do the right thing to you, I am not a deceiver for you. You will see those animals. Some will be black sheep, some will be spotted and striped goats. If you see other kinds you will know I stole them from you.” ");
INSERT INTO engnna_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban replied, “Yes, good. You will do like that.” ");
INSERT INTO engnna_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Laban deceived Jacob. That very day he took all the spotted and striped goats and all the black sheep, he told his sons, “Take all these goats and sheep over there far away, take care of them over there.” As a result of that word they took them 3 days' journey. Then Jacob was taking care of all the rest of Laban's animals. ");
INSERT INTO engnna_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","He broke different kinds of green trees/sticks. He trimmed those various small sticks finely to peel (them) down to the white parts. ");
INSERT INTO engnna_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","He put those whittled sticks near the water. As soon as those animals came to the water they saw those sticks. When they came close to the water they used to mate. ");
INSERT INTO engnna_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","When they mated they looked at those sticks. Then the sheep gave birth to black young, the goats gave birth to spotted and striped young. ");
INSERT INTO engnna_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","After that he separated those young ones. He kept them for himself, he did not put them with Laban's animals. He put the oldish = mature, matable animals facing towards Laban's animals. Laban's animals: The plain ones in Jacob's care, not the non-plain ones that Laban's sons had taken far away. 'Facing' here is taken to be a euphemism for 'mating them with'. ");
INSERT INTO engnna_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Whenever the strong animals were mating Jacob put the sticks in front of them. ");
INSERT INTO engnna_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Whenever the weakish animals were mating Jacob did not put those sticks there. The young ones from the weak animals became Laban's. The young ones from the strong animals became Jacob's. ");
INSERT INTO engnna_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Because of doing that Jacob got for himself many sheep and goats. He was owning many camels and donkeys, and working men and women. ");
INSERT INTO engnna_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","After that Laban's sons were criticising Jacob. They said, “Jacob took all our father's animals. As a result of doing that he has many animals. They should be our father's.” Jacob heard about their critical words which they said. ");
INSERT INTO engnna_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Laban didn't like him. Jacob knew that. ");
INSERT INTO engnna_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","After that God said to Jacob, “Go back to your father's country, to your own people, I will take care of you.” In that way God spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","At that time Jacob was staying a long way away from his camp with his animals. After that Jacob sent a word to his two wives, Rachel and Leah, to come to him. ");
INSERT INTO engnna_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","As soon as they came he said to them, “Your father used to be good to me, now he is not. I know he does not like me. God has been taking care of me. He is the one who used to take care of my father, he has been taking care of me also. ");
INSERT INTO engnna_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You two know about me, I worked for your father a long time. ");
INSERT INTO engnna_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","He lied to me many times about everything. God was preventing him from harming me. ");
INSERT INTO engnna_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Your father said to me, 'You will keep the black sheep in response to that work you've done.' After that those sheep gave birth to black offspring. Your father told me, 'You will keep the goats with spots and stripes in response to the work done.' After that those goats gave birth to young with spots and stripes. ");
INSERT INTO engnna_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","God is the one who has been taking animals from your father, he has been giving them to me. ");
INSERT INTO engnna_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","At the time the animals mated I had a dream. In that dream I saw that the male goats with spots and stripes were mating with the females, the other males did not mate. ");
INSERT INTO engnna_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","In that dream God spoke to me, 'Jacob!' 'Yes, what?' ");
INSERT INTO engnna_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","13","'I am God. Earlier I appeared to you at Bethel. There you stood up that rock for a reminder, and you poured oil on it for me, you told me, “I will listen to you.” I have been watching you. I know about Laban, he has been deceiving you. Look at those animals. The male goats with spots and stripes are mating, the other males are not mating. Now listen to me. Leave this country, go back to your own country.' In that way God spoke to me.” ");
INSERT INTO engnna_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel and Leah listened to Jacob's word. They replied, “Our father will not give us anything from his. ");
INSERT INTO engnna_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","He regards us as strangers. Earlier he gave us to you in exchange for work. As a result of that he got lots of belongings. From that now he has not kept anything. ");
INSERT INTO engnna_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","God took the belongings from him, he has given them to you. Therefore those things whatever they are now belong to us two and our children. You listen to God. Do what he says to you.” ");
INSERT INTO engnna_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","20","After that Jacob got his belongings in preparation for leaving. He did not tell Laban. Laban had earlier gone from his camp to cut the wool from his sheep. While Laban was far away Rachel stole her father's carved ones like Dreamtime-Beings. After that Jacob got camels to carry his wives and children. He sent his animals ahead, sheep and goats and cattle and donkeys. Jacob and his wives (pl) and children left that camp of Laban's secretly. In this way he deceived his uncle. He went with fear straight towards the country Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","He crossed the big river, what's-its name, Euphrates. He kept on going towards the hilly country, towards what's-its-name, in Gilead. ");
INSERT INTO engnna_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","After three days Laban heard Jacob had already gone. ");
INSERT INTO engnna_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laban got some men, after that they followed Jacob. They followed him for 7 days towards the hilly country, in what's-its-name, in Gilead. ");
INSERT INTO engnna_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Partway along God spoke in a dream to Laban, “You just go to Jacob without fighting.” ");
INSERT INTO engnna_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob and his children and wives had already camped in the hilly country. Then Laban and his men arrived near to Jacob, they made camp nearby. ");
INSERT INTO engnna_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban rebuked Jacob. “You deceived me. You took my two daughters, truly like two prisoners. Why did you do it like that? ");
INSERT INTO engnna_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you go secretly? You should have told me in preparation for your going. We could have eaten food, we could have danced and sung, we could have been happy. I could have sent you away happily. ");
INSERT INTO engnna_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","I could have hugged my daughters and grandchildren. Why did you prevent me, why did you take them without a word? Truly you did that deceptively. ");
INSERT INTO engnna_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Since that is the way you behave I truly might do harm to you. But no. Your father used to listen to God. That same God spoke to me in the night, he told me, 'You just go to Jacob without fighting.' Because he spoke like that to me I will just let you off. ");
INSERT INTO engnna_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","You want to see your father. That's alright. Why did you steal my Dreamtime-Being-like things? That is very bad indeed!” ");
INSERT INTO engnna_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob replied, “I was thinking about you, you could have taken these two from me. I was afraid. Because of that I went secretly. ");
INSERT INTO engnna_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","I did not take your Dreamtime-Being-like things. Whoever of my mob took them, that person you should kill. Look at my possessions. Whatever you see of yours, point it out to us, to your men and mine. After that keep those for yourself.” Jacob did not know that Rachel in readiness to leave for Canaan secretly took her father's carved Dreamtime-Being-like-things. Because of that Jacob spoke in that way. ");
INSERT INTO engnna_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","After that Laban entered Jacob's tent. He was searching for those Dreamtime-Being-like things. He didn't see those things there. After that he was searching in Leah's tent, he didn't see them there either. After that he went into the tent of those two working women. Nothing, there also unsuccessfully he was searching for them. After that he went to Rachel's tent. ");
INSERT INTO engnna_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel had already hidden those Dreamtime-Being-like-things in a camel's saddle. After that she sat on that saddle. Her father was feeling around in Rachel's possessions, absolutely nothing, he did not see them. ");
INSERT INTO engnna_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel spoke to her father, “I cannot stand up, (I am) in our women's way. Please don't be angry with me, that I am sitting here.” In that way Laban was unsuccessfully searching for his Dreamtime-Being-like-things. ");
INSERT INTO engnna_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Therefore Jacob then became angry with Laban, he rebuked his uncle. “I didn't do anything bad to you. Why did you pester me like that? What bad did I truly do to you? ");
INSERT INTO engnna_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","You thoroughly shifted and looked through all my belongings. What possessions did you see that were yours? If you saw them put them here. These men, yours and mine, will see them. They will say whose those things are. ");
INSERT INTO engnna_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I stayed with you 20 whole years. I was taking care of your animals. In that time your sheep and goats stayed safe. They had many offspring. I did not eat your rams. ");
INSERT INTO engnna_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","When wild dogs would bite dead your goats and sheep I did not take those dead ones to show you. No. I put in my sheep and goats in replacement of those dead ones of yours. When other people secretly took yours in the day or night you used to ask me to put (mine) for those. ");
INSERT INTO engnna_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Day after day I worked for you in the heat, many nights I truly stayed in the cold. Many times I stayed without sleep while I was caring for your animals. ");
INSERT INTO engnna_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I stayed with you 20 years. I worked for you 14 years for those two women, your two daughters. After that I worked for you for 6 years to get animals for myself. In those 20 years you deceived me many times. ");
INSERT INTO engnna_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","You did not want to give me anything. God was taking care of me. He knows about me, I worked well for you, he knows about you, you made it hard for me. Therefore he rebuked you at night in a dream.” In that way Jacob spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","After that Laban answered him, “These two are my children, those children of theirs are my grandchildren. Those animals and other things you kept are mine too. You look! These are mine only. Perhaps I might keep my daughters and their children. No, I am just letting them go with you. ");
INSERT INTO engnna_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yes. We two will talk to each other. Without hitting we will just stay, without hitting. We will heap up these stones in order to remind us.” In that way Laban spoke to him. ");
INSERT INTO engnna_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Therefore Jacob got a big stone, he stood it up. ");
INSERT INTO engnna_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Then he told his men, “You also get stones.” Truly they got them, they gathered them together near the big rock. After that they all ate food near that heap of rocks. ");
INSERT INTO engnna_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban named that heap in his language, 'A heap for reminding'. Jacob also named it 'A heap for reminding' in his language. ");
INSERT INTO engnna_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said to Jacob, “This heap will remind us two of our word to each other. ");
INSERT INTO engnna_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","After we separate you will go to your country, I will return to mine. After that God will watch us two.” That is why they also named that place Mizpah. That name says, 'Watching-place'. ");
INSERT INTO engnna_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban kept talking to him, “You might take other wives, you might leave these two daughters, you might hit them over there. I might not know. Listen to me. God is watching you. ");
INSERT INTO engnna_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","You see this big rock I stood up and this heap I made. ");
INSERT INTO engnna_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Those stones will stay to remind us two about this promise we made. I will not go beyond this pile to fight you. You also will not come to fight me because of/for fear of this pile. ");
INSERT INTO engnna_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","One of us two might ignore this word, God will know about him. Our two paternal grandfathers, Abraham and Nahor, used to obey him. Perhaps I might ignore that word. In that case truly that same one, God, he will hit me. Perhaps you might ignore that word. In that case truly that same one, God, he will hit you.” Like that Laban spoke to Jacob. Jacob listened to Laban's word. He said to Laban, “That same God is the one my father Isaac used to obey, that God knows about me. I am keeping that word for you.” ");
INSERT INTO engnna_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","After that Jacob got one of his animals and killed it to give to God. He asked his men and Laban's to eat food with him. After eating they slept at that stone for the night. ");
INSERT INTO engnna_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early in the morning Laban got up from sleep. He hugged his grandchildren and his two daughters. After that he returned to his country. ");
INSERT INTO engnna_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","As Jacob was going on towards his father's country, some of God's angels came to him. ");
INSERT INTO engnna_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When Jacob saw them he said to himself, “This is God's camp.” He named that country Mahanaim. ");
INSERT INTO engnna_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","After that Jacob sent some men ahead to his older brother, to Esau, he was in that country Edom. ");
INSERT INTO engnna_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He told them, “Take this word to him, say to Esau, my boss, 'Your working man, Jacob, sent us to you. He was staying with Laban. He was there a long time. ");
INSERT INTO engnna_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Now he has cattle and donkeys and sheep and goats and workers, men and women. He sent you this word. Perhaps you will feel good towards him. Perhaps you will do something good to him.'#” He told his men, “You will talk like that to Esau.” ");
INSERT INTO engnna_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The men went to Esau in accordance with Jacob's word. After returning they said to Jacob, “We went to your older brother, we told him your word. He is coming, he will meet you. He is coming with 400 men.” ");
INSERT INTO engnna_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","After hearing that word Jacob became very frightened. He separated his people into two groups. He separated his animals too. ");
INSERT INTO engnna_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He said to himself, “As soon as Esau comes to one mob he might kill them all, the other group will run away for safety.” ");
INSERT INTO engnna_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","After that he talked to God, “You truly are God, you are the one who took care of my grandfather Abraham and my father Isaac. You said to me, 'Go back to your own country, to your own people. I will take care of you, I will keep you safe.' Like that you spoke to me. ");
INSERT INTO engnna_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Truly you have been doing good things for me. I am quite unimportant, just rubbish. Earlier when I left my country I crossed to the far side of this river, this Jordan river, I was just going with only a walking stick. Now I have returned with many animals and people. ");
INSERT INTO engnna_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","12","I am afraid of my older brother Esau. He might kill us all, the children and their mothers. You told me, 'I will take care of you, I will give you many children and theirs will come after them.' Like that you spoke to me. God, now will you take care of us. Prevent Esau, he might kill us all dead.” In that way he spoke to God. ");
INSERT INTO engnna_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob slept there one night. After that he chose some animals to give to his older brother. ");
INSERT INTO engnna_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","He chose 200 female and 20 male goats, 200 female and 20 male sheep, 30 female camels and their young, 40 female and 10 male cattle, 20 female and 10 male donkeys. He separated those into different mobs to give to his older brother. ");
INSERT INTO engnna_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He said to his working men, “You go ahead of me, take these mobs of animals to Esau. Go one behind the other, fairly far apart, fairly far apart (from each other) you will travel.” ");
INSERT INTO engnna_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He said to the leading man, “As soon as my brother meets you he will ask you, 'Who is your master? Where are you going? Whose are those animals you are caring for?' ");
INSERT INTO engnna_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","You will reply to him, 'These animals are Jacob's, your working man. He is sending them to his boss, to Esau. He is coming behind now.'#” That is what he told that man. ");
INSERT INTO engnna_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He told the others, “You (pl) also will say that to him, as soon as Esau meets you. ");
INSERT INTO engnna_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You tell him, 'Your working man Jacob is coming behind us.'#” Jacob was saying to himself, “Perhaps these animals will make Esau's feelings good towards me. Later he will see me, perhaps he will feel good towards me.” ");
INSERT INTO engnna_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","When his men went with the animals Jacob stayed there. ");
INSERT INTO engnna_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","In the night he took his belongings and his wives and children, they crossed the river Jabbok. He left them all on the far side. After that he went back. ");
INSERT INTO engnna_vpl VALUES ("GN32_24a","002_32_24a","GEN","32","24a","24a","He stayed there alone. ");
INSERT INTO engnna_vpl VALUES ("GN32_24b","002_32_24b","GEN","32","24b","24b","A man, a stranger, came to him. Those two wrestled each other (lit. 'tried to put each other on the ground'), unsuccessfully they were doing that right up to daybreak. ");
INSERT INTO engnna_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Jacob didn't give up, he kept holding the stranger. Therefore that one hit him on the hip and put it out of joint. ");
INSERT INTO engnna_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","After that he said to Jacob, “It is becoming first light. Don't hold me. Leave me!” Jacob said to him, “You tell me whatever good you will do for me. If you don't I will keep holding you.” ");
INSERT INTO engnna_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","That stranger asked him, “Who are you?” “My name is Jacob.” ");
INSERT INTO engnna_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","That stranger said to him, “From now they will not name you Jacob. You have argued with God and with people, they have left you, you are still standing up. Therefore from now on your name will be Israel.” ");
INSERT INTO engnna_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","After that Jacob asked him, “And who are you?” He said to him, “Don't ask, you can't talk in that way to me. Now I will do good to you.” Like that he spoke to Jacob. Then he left Jacob there, he went away. ");
INSERT INTO engnna_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob said to himself, “I saw God's face. Wow! He didn't kill me.” Because of that Jacob named that camp Peniel. That name says, 'God's Face'. ");
INSERT INTO engnna_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Right at that time the sun was coming up. Jacob left that country, he was going along limping after being hit on the hip. ");
INSERT INTO engnna_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Because of that story Israel's mob after they kill an animal do not eat the muscle from the hip. They remember that long ago God hit Jacob right on the hip. ");
INSERT INTO engnna_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","After that Jacob looked, Esau was coming to him with 400 men. He put his children with their own mothers. ");
INSERT INTO engnna_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the two working women and their children in the lead. Near those two he put Leah and her children, behind he put Rachel and her child Joseph. ");
INSERT INTO engnna_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","He went ahead, he met his brother. As he was going towards Esau he was bowing his head down 7 times. ");
INSERT INTO engnna_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Then Esau in response ran to him, there those two hugged each other. They were crying with each other, they saw each other with happiness. ");
INSERT INTO engnna_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","After that Esau was looking around, truly he saw the women and children. “Who are these you are bringing?” “Those are the children God gave me.” ");
INSERT INTO engnna_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the two working women and their children came close, they bowed their heads down in front of Esau. ");
INSERT INTO engnna_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","After that Leah and her children came close, they also bowed their heads down in front of Esau. Then Rachel and her child Joseph also came close, they also bowed their heads down in front of Esau. ");
INSERT INTO engnna_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Then Esau asked, “Those animals I saw, why did you send them?” Jacob said to him, “Those are for you. As a result of my giving them you might feel good towards me.” ");
INSERT INTO engnna_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","“No, I have enough, younger brother. Keep them for yourself.” ");
INSERT INTO engnna_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob said to him, “Truly you were being good to me. You did not stay angry with me. Therefore I am very happy to see you. Please take those animals for yourself. ");
INSERT INTO engnna_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","God was doing good to me, he gave me many things. Take those animals for yourself.” Like that Jacob said to him. Esau replied, “Truly I will take them.” ");
INSERT INTO engnna_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","After that Esau said to him, “Let's we two go together, I will go ahead.” ");
INSERT INTO engnna_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob said to him, “My children are only weak, they should go not fast. My animals, the sheep and goats and cattle, have their little ones, I musttake care of them. After going a long way in one day they might die. ");
INSERT INTO engnna_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","You go ahead of me. I will come slowly behind with this lot. Later I will come to your camp in Edom.” ");
INSERT INTO engnna_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau said to him, “Yes, I will leave these men with you, you will come behind.” Jacob replied, “Take your men. I just want you to feel good towards me.” ");
INSERT INTO engnna_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","After that Esau left his younger brother, he went back south to his country, to Edom. ");
INSERT INTO engnna_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob did not continue on towards Edom. He stopped partway, at what's-its-name, at Succoth. There he made a house for himself, he made bough shades for the animals also. Therefore now they name that camp Succoth. That name says, 'Bough Shades'. ");
INSERT INTO engnna_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","After that Jacob and his mob left that Succoth, they went west. They arrived at a town, at Shechem, in the country, in what's-its-name, in Canaan. He made his camp near the town. ");
INSERT INTO engnna_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Earlier that country where he made his camp used to be Hamor's, Shechem's father. Jacob gave Hamor a lot of money for that country. ");
INSERT INTO engnna_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","There he heaped up stones. There he used to talk to God. He named that heap of stones El Elohe Israel. That name says, 'God is the One who cares for Israel'. Chapter 34 has been omitted at this stage. ");
INSERT INTO engnna_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","After that God said to Jacob, “Leave this country, go to Bethel, stay there. That is where I appeared to you earlier, when you were running away afraid because of your brother Esau. As soon you come to Bethel you will pile up stones, there you will talk to me.” In that way God talked to Jacob. ");
INSERT INTO engnna_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Then Jacob spoke to his wives (pl) and his workers. He said to them, “Leave your what's-their-names, those carved things like Dreamtime-Beings, from another country. Then wash yourselves, put on other clothes. ");
INSERT INTO engnna_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","After that we will leave this camp, we will go to Bethel. Earlier I ran away afraid because of Esau. That is where I called to God, he listened to me. He is the one who took care of me wherever I was going. At Bethel I will pile up stones, I will talk to God there.” ");
INSERT INTO engnna_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","At Jacob's word they gave him all their Dreamtime-Being-like things, their earrings also they gave him. He dug a hole near a tree, there in the hole which had been dug he covered them. ");
INSERT INTO engnna_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","After that Jacob and his mob were going towards Bethel. God made the inhabitants of the area afraid, they did not chase Jacob. ");
INSERT INTO engnna_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob's mob arrived at Bethel in the country, in what's-its-name, in Canaan. ");
INSERT INTO engnna_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","There Jacob piled up stones, he talked to God. Earlier when Jacob was running away from his brother God appeared to him there. It was at that time Jacob had named that country El-Bethel. That name says, 'God is at Bethel'. Verse 8 omitted. ");
INSERT INTO engnna_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","When Jacob returned from his uncle's country, God again appeared to Jacob, he spoke very kindly to him. ");
INSERT INTO engnna_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","He gave Jacob another name, that name Israel. He said to Jacob, “Your name used to be Jacob. Now they will not call you Jacob, they will name you Israel. ");
INSERT INTO engnna_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","I am truly God, the boss for you all. I will give you many grandchildren. They will be very many. They will go far away, to other countries. Some will be big bosses, they will be kings. ");
INSERT INTO engnna_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Earlier I gave this country to your grandfather and your father, to Abraham and Isaac. Now I will give it to you and your grandchildren, and those who come after them.” In that way he talked to Jacob. ");
INSERT INTO engnna_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","After that God left him. ");
INSERT INTO engnna_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Right there Jacob stood up a big stone, he stood it upright. He poured wine and oil on the stone to give them to God. ");
INSERT INTO engnna_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","That place where God came to him he named Bethel. ");
INSERT INTO engnna_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","After that Jacob's mob left Bethel, they went towards what's-its-name, towards Ephrath. At that time his wife Rachel was pregnant. Partway she gave birth to the child, there she was very sick. ");
INSERT INTO engnna_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Another woman was waiting for the child to appear. “Don't be afraid, don't worry, you will have a male child.” ");
INSERT INTO engnna_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachel was very sick, slowly she was dying. In preparation for dying she named that child Benoni. Later Jacob gave him another name, Benjamin. ");
INSERT INTO engnna_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","They put Rachel in a hole in the ground near the road, that road was going to Ephrath. (Nowadays they name that town Bethlehem.) ");
INSERT INTO engnna_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob stood up a big stone, he stood it upright, on top of where they put Rachel in the ground. That stone is still there now. ");
INSERT INTO engnna_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","After that Jacob's mob kept going. They made camp on the far side of what's-that-place, of Eder. 35:22-26 omitted. ");
INSERT INTO engnna_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","After that Jacob returned to his father's camp at what's-its-name, at Mamre. (Another name for that town is Hebron.) Earlier Jacob's grandfather and father, Abraham and Isaac, made their camps there. ");
INSERT INTO engnna_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaac was very old, having 180 years. After that he died. His two sons Esau and Jacob buried him. ");
INSERT INTO engnna_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Then God said to him, “Again put your hand into your shirt.” Again he put his hand in there, then he withdrew it, it was good, it was like his other hand, without sickness. ");
INSERT INTO engnna_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","God said, “You will show them the stick, they will see, it will become a snake. After seeing that they might not believe your words. Then you will show them your hand, it will become white from sickness, then it will become well again. After that perhaps they will believe I have sent you. ");
INSERT INTO engnna_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","If they still do not believe you, you shall take some water from the river, from the Nile river. You will pour it on the dry ground, that water will become blood.” ");
INSERT INTO engnna_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moses said to him, “I can't go to them, I am a poor speaker. Previously I did not speak well, and still I speak slowly and hesitantly.” ");
INSERT INTO engnna_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","God said to him, “Who gives people their mouths? I am the one. Who makes some people unable to speak? Who makes some people deaf? I am the one. Who makes some able to see? Who makes some blind? I am the one, Yawayi. ");
INSERT INTO engnna_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","You will go to Egypt. I will tell you what to say, and I will help you to say it.” ");
INSERT INTO engnna_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moses answered, “Not me, please send another.” ");
INSERT INTO engnna_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","With this word God became angry with him. He said to Moses, “Your own older brother, Aaron, have you thought about him? I know about him, he is a good speaker. Truly, he is coming now to meet you. When he sees you he will be glad. ");
INSERT INTO engnna_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","You will speak to him, you will tell him what to say. I will help you two to speak, and I will tell you two what to do. ");
INSERT INTO engnna_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will speak to the people for you. You will tell him my words and he will speak for you. ");
INSERT INTO engnna_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Take your stick with you, with it you will do wonderful (things).” ");
INSERT INTO engnna_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Then Moses returned to his father-in-law, to Jethro. He said to him, “Please let me go back to Egypt to see my relatives. Perhaps they are still alive.” Jethro said to him, “Yes, you will go well.” ");
INSERT INTO engnna_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","While Moses was still in Midian, God said to him, “Long ago those in Egypt wanted to kill you. Now they are all dead. Now you will go back to Egypt.” ");
INSERT INTO engnna_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Because of that Moses got his wife and his 2 sons, he put them on a donkey. After that he was going towards Egypt. He was carrying that (previously mentioned) walking stick, God had told him to take that one. ");
INSERT INTO engnna_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Again God said to him, “Now you are going back to Egypt. I have showed you the wonderful (things) that you must do. Truly you must do them all, he will see them all, that Egyptian king. But I will make him stubborn, he will not let your people go. ");
INSERT INTO engnna_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Then you must tell the king this word of mine: 'I am Yawayi. The Israeli mob are for me like a son, like a first-born male. ");
INSERT INTO engnna_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Let my people go free, so that they can pray to me and give gifts to me. Listen to me. If not I will kill your first-born son.' Like that you will speak to the king.” ");
INSERT INTO engnna_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","6","Others told me about you long ago. I thought I knew you. Now it is different, I have seen you with my own eyes. Therefore I am really ashamed of my words, I won't talk like that again. ");
INSERT INTO engnna_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Happy are those people who won't listen to the words of bad people, they don't want to do like the bad people do and they don't join the ones who are rude to God. ");
INSERT INTO engnna_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","They are really happy when they think about God's word, and they always pay attention to it. ");
INSERT INTO engnna_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","You all know about a tree near a pool, it is always good, it has good fruit and its leaves don't dry up. Good people are like that tree. They do things the right way, it comes out well for them. ");
INSERT INTO engnna_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","The bad people are not at all like this; they are like what's-its-called, like the rubbish after yandying, the wind blows it away. ");
INSERT INTO engnna_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","God will hit them hard. He will separate them out, they won't stay with his mob. ");
INSERT INTO engnna_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","God looks after his mob on the right road. It is very different for bad people, they are going to a really bad place. ");
INSERT INTO engnna_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","All bad people will die, they are all rejecters of God. ");
INSERT INTO engnna_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","God looks after me; I have everything to stay alive. ");
INSERT INTO engnna_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Some people have done badly, but they told God they were sorry, and he let them off. Now they are very happy. ");
INSERT INTO engnna_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Some people have done badly, but they told God they were sorry, they did not try to deceive him, and he did not growl at them. Now they are very happy. ");
INSERT INTO engnna_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Previously I did badly and I did not tell God about it. Because of that I kept on crying all day long, I was exhausted by the crying. ");
INSERT INTO engnna_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Day by day, night by night, you made it hard for me, Lord. I was weakened completely. In the summer the sun pierces the water and dries it up. In that same way you growled at me, Lord, and I became very weak and thin, I nearly died. ");
INSERT INTO engnna_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Then I told you true, like that I had done badly. I did not try to hide from you, I decided I would tell you the whole story, I told you I was ashamed of myself. Because of that you let me off completely. ");
INSERT INTO engnna_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Therefore all your people, the ones who believe in you, should tell you about their problems. They should ask you, “God, what should I do about this?” With doing that they will go well. When really big trouble comes for them, like a big flood rushing along in a creek, you will care for them, that trouble will not get high enough to carry them away. ");
INSERT INTO engnna_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","I am safe when I am with you, You will keep me well when trouble might hurt me. You take my part. Therefore I sing loudly, “Ngarrka has saved me!” ");
INSERT INTO engnna_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","9","The Boss says, “Listen to me! Don't be stupid like a horse or donkey. You must put a bridle on them. If you don't, they won't go where you want them to go. Don't be stupid like them. Should I have to put a bridle on you? No indeed! With my words I will teach you the way you should go. I will tell you what I want you to do. You should keep on paying attention to me. ");
INSERT INTO engnna_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Wicked people will make a lot of trouble for themselves, but the Lord continually loves those who trust in Him, he takes good care of them. ");
INSERT INTO engnna_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","All you people who do rightly, look at what the Boss did! Be glad! Rejoice! All you people who obey the Boss, shout for joy! ");
INSERT INTO engnna_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","While a person is going east at dawn, the light becomes brighter for him. Just like that the ones that do the right thing learn more and more about God. ");
INSERT INTO engnna_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Good people take care of their tame animals. Bad people keep theirs badly. ");
INSERT INTO engnna_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","...bad things always happens for a bad person. ");
INSERT INTO engnna_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Some people think they are doing things rightly. Truly they are making a mistake, it will kill them. ");
INSERT INTO engnna_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","After drinking a lot of grog you talk loudly and you get silly. It is very stupid to get drunk. ");
INSERT INTO engnna_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Teach a child how he should stay, he will think about it always. ");
INSERT INTO engnna_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","21","Listen, son! Think properly and live in the proper way. Don't join with others who are drinkers of lots of wine and those who are greedy for food. People like that are making themselves poor. ");
INSERT INTO engnna_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","35","Who is really upset? Who is unhappy? Who is always fighting? Who is always growling? Who has sores after falling accidentally? Who has red eyes? Those who are always drinking, testing different kinds of wine. That wine is good to look at, and really sweet to taste. Don't ever trust it. When a poisonous snake bites you, you get really sick, it is very painful when a death adder bites you, in that same way after drinking wine you will get really sick. You will see frightening things that aren't there and you will talk in a stupid way. You all know about the sailing ships in the sea, the post that holds the sail is really tall. That post moves in the wind in every direction. In that same way that drunk person walks in a staggering way. And he will say, “They hit me but I didn't feel it. I didn't know ");
INSERT INTO engnna_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","While you are a child think about God, he made you. ");
INSERT INTO engnna_vpl VALUES ("IS5_11","024_5_11","ISA","5","11","12","You get up early in the morning to drink wine, then you keep on drinking during the night...You should be thinking about God, but you're not! You are ignorant of what he is doing. He says to you, “I will hit you hard, it's impossible for you to run away and hide.” ");
INSERT INTO engnna_vpl VALUES ("IS38_17","024_38_17","ISA","38","17","17","You left me alone from my wrongdoing. ");
INSERT INTO engnna_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","6","We are healed by the punishment he suffered, made whole by the blows he received. All of us were like sheep that were lost, each of us going his own way. But the Lord made the punishment fall on him, the punishment all of us deserved. For our wrongdoing God hit him. God whipped him, as a result of that he healed us. We all self-centredly did whatever we wanted to do. He did not hit us, he hit him for our badness. ");
INSERT INTO engnna_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","Our self-centred spirit is really deceitful. It is a really hard problem to make it good. ");
INSERT INTO engnna_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","This story I will tell, Jesus Christ became a person (OR man). His mother Mary they gave (as) a promised one to Joseph. Joseph was waiting to take her to his camp. After that she became pregant. God's Spirit put the child in her womb. After that they were telling a word to Joseph, “Mary is pregnant.” ");
INSERT INTO engnna_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph thought, “Mary has been sleeping with a man. I will not take her as my wife.” Joseph was a good type. He did not want to make Mary ashamed in front of people. He thought he wanted to send her away without a growling. ");
INSERT INTO engnna_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","He was thinking hard. After that he had a dream. In the dream he saw an angel, God sent it to him. The angel said to him, “Joseph! you are from David's mob! Listen! Don't be upset about the woman Mary. God's Spirit gave her the child. Therefore you can (OR will OR should) take her as your wife. ");
INSERT INTO engnna_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","She will have a male child. You will name him Jesus. People are habitual ignorers/disobeyers of God. Because they are like that God might send them away from him forever. Jesus will be a stand-in for them.” Like that the angel spoke to Joseph. ");
INSERT INTO engnna_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","A long time ago a man spoke a word from God. “A woman, she has never slept with a man, will become pregnant. She will have a male child. They will name him Immanuel.” In the Jews' language that name means God is with us (all). After that when Jesus was born, they knew about that word, it was Jesus (himself). ");
INSERT INTO engnna_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph got up from sleep, he did what the angel said (lit 'at the angel's word'). He took Mary to his camp. They made those two husband and wife. ");
INSERT INTO engnna_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","After that those two did not sleep together. They were waiting for the child to be born. Joseph named that child Jesus. ");
INSERT INTO engnna_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","At that time King Herod was boss for the people in that country, in Judea. Those people used to call themselves Jews. At that time Mary gave birth to Jesus in the town Bethlehem, in the country Judea. When Jesus was born some foreign (OR strangers) men came from another country, from the east, to look for him. These men were knowledgeable about the stars. Truly they saw a new star in the sky. That particular (star) made them understand that an important boss had appeared for the Jews. They arrived in Jerusalem. They were asking them, ");
INSERT INTO engnna_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Where is the male child, that boss, he will become king for you Jews? We saw his star in the east. When we saw it we knew an important boss has appeared, he has become a really small child. We have come to see (him), to give him gifts. ");
INSERT INTO engnna_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","As soon as (?) King Herod heard their talk, truly he became upset ('his stomach became bad'). All the people in Jerusalem also became upset. ");
INSERT INTO engnna_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod gathered together the leaders and the teachers of the Jews. “That important boss, God will send him, where will he be born (OR appear/become visible)? ");
INSERT INTO engnna_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","They replied to him, “Here he will be born, in the country Judea, in the town Bethlehem. A long time ago one of God's spokesmen wrote a word in a book, ");
INSERT INTO engnna_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'People in Bethlehem, your camp is truly small (OR unimportant). God will send a truly important boss, he will be born in your camp. He will become boss for God's people. After that everyone will know about your camp.' In just that way he wrote the word from God.” ");
INSERT INTO engnna_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod was wanting to learn when Jesus was born. After that he sent a word secretly for the strangers from the east to come. He asked them with deceit also, “When did that star appear?” ");
INSERT INTO engnna_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Then he sent them to Bethlehem. “Go to Bethlehem, search carefully for that child. After that return here, tell me where he is. After that I will go to him, I truly will see him, I will give him gifts also.” Truly indeed he lied to them, he wanted to kill the child Jesus. ");
INSERT INTO engnna_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","After that they kept going to Bethlehem. They saw that one particular star, it was going ahead of them. There it stood still right above the house which had the child. ");
INSERT INTO engnna_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","When they saw the star they were happy. ");
INSERT INTO engnna_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","They entered the house. Then they saw the child, his mother Mary was holding him. They knelt down to the child. They gave him gold and two (kinds of ?) gum also, those two smelled very good. ");
INSERT INTO engnna_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","After that God spoke to them in a dream. He told them not to return to Herod. After that they returned to their own country a different way. ");
INSERT INTO engnna_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","In the night Joseph dreamed. An angel from God came to him. He said to him, “Herod will look for the child to kill him. Get up right now. Take the child and his mother, run away to another country, to Egypt. You (pl) remain there. Later I will tell you to return here.” In that way the angel spoke to him. ");
INSERT INTO engnna_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph got up from sleep. He took the child, and his mother, they went in the night. They went right to Egypt. ");
INSERT INTO engnna_vpl VALUES ("MT2_15a","070_2_15a","MAT","2","15a","15a","They were staying in that country while Herod was living. ");
INSERT INTO engnna_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod was waiting in vain for the men from the east. They did not return to him, they did not send a word to him about that camp in Bethlehem where Jesus was (lit. 'Jesus-having'). Then he became very angry. Previously he had asked the strangers from the east, “When did that star appear?” Now he is thinking to himself, “That star appeared maybe one year ago. I will kill all the children in Bethlehem under two years (lit. 'without two winters'), the ones having two years (winters) also, truly I will kill them all.” Therefore he called his soldiers. “Listen! Go to Bethlehem. There kill all the boys under two years, kill all the ones having two years also. You will not leave one alive.” Those soldiers did that, in accordance with Herod's word. ");
INSERT INTO engnna_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","After that the people in Bethlehem were really crying for their children. A very long time ago one of God's spokesmen, who-was-it, Jeremiah, spoke a word, “In that country, where-is-it, in Ramah, there someone is crying very loudly. That woman of long ago, Rachel, she is crying, she is really crying for her children. Others took them. She is crying for them continually.” That Jeremiah wrote those words about Rachel in a book. Now in that same way truly those people in Bethlehem were crying hard for their children, like that. ");
INSERT INTO engnna_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","After that Herod died. In Egypt Joseph saw an angel in a dream, God sent him. He said to him, “That man was wanting to kill Jesus, that one is dead. ");
INSERT INTO engnna_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Get up. Take the child, his mother also, you (pl) return to your own country, to Israel.” ");
INSERT INTO engnna_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseph got up from sleep, returning he took the two of them to their own country, to Israel. ");
INSERT INTO engnna_vpl VALUES ("MT2_15b","070_2_15b","MAT","2","15b","15b","A very long time ago another of God's spokesmen said, “God took his son from Egypt”. Later, after Jesus returned to his own country, people knew about that word from long ago, Jesus was the one that word talked about. ");
INSERT INTO engnna_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","When he arrived in Israel Joseph heard a word, a son of Herod, what's-his-name, Archelaus, was boss of the people there, in the country Judea. Because of that Joseph was afraid to stay in that country. God spoke to him in a dream, in accordance with that word he continued northwards, to the country Galilee. ");
INSERT INTO engnna_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","He became a local inhabitant in the town Nazareth. A long time ago God's spokesmen said about Jesus, “They will say about him, he is an inhabitant of lowly (a derogatory term) Nazareth.” ");
INSERT INTO engnna_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","The gate to God's country is very narrow. Go through that one. The other gate is wide, and that one is to the big fire, and the road to that place is without problems. Many people go on that road. The gate that leads to God's country is narrow, and the road to that place is difficult. Only a few people find it. ");
INSERT INTO engnna_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","31","People might kill your body. Don't be afraid of them. They can't kill your spirit. Fear only God. He can burn your spirit and body to ashes in the big fire. People cannot do that. Because of that do not be afraid of them. Your Father above knows of everything. He knows when a zebra finch falls to the ground. Truly he knows of you also. He knows the hair on your head. One by one, all of it. Because of that, stay without fear. God just thinks a bit about the zebra finch, he really thinks about you always. ");
INSERT INTO engnna_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","You who have big problems, come to me, I will make your problems small. Join me, we two will make it right...learn from me, for I am caring and humble... ");
INSERT INTO engnna_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus said to them, “I want the kids to come to me, do not stop them. They really love God, they really take notice of him. God's people should do exactly like that.” ");
INSERT INTO engnna_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","This word is good, I am teaching you about Jesus. He is God's own child. ");
INSERT INTO engnna_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Long ago God spoke to a man, his name was Isaiah. God told him, “I will send a boss to people. I will send another one ahead of that boss with a word for them. That first man will be in the desert. He will tell them, 'Our boss will come. Fix up a straight road for him.'” In that way God spoke to Isaiah. That man Isaiah wrote that word for them on paper. ");
INSERT INTO engnna_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","After a very long time that man now came. His name was John. ");
INSERT INTO engnna_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","His poor sort of clothes were made from camel hair. He tied his waist with a leather belt. He used to eat food from the desert, grasshoppers and honey. Very many people were coming to John to listen to him. They were coming to him from the country Judea, and from the big town Jerusalem also. He was telling them, “You have been ignoring God. Be ashamed. You have been doing bad things. Stop it! Come close, come to God! Then God will not look at you with anger, he will become pleased with you. After that I will baptise you.” In that sort of way John was talking to them. After hearing John's words one by one they were saying to God, “Truly I have been ignoring you. I am ashamed of myself. I want to return to you.” In that sort of way they were talking to God. After that John baptised them in the river, in Jordan. ");
INSERT INTO engnna_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John was saying to them, “About now another man will come. He is a really big boss. Not like me, I am really unimportant, a scrap. This other one is an important boss. I truly should not touch his shoes. ");
INSERT INTO engnna_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I only baptised you in water. This other one will send to you God's Spirit.” In that way John was talking to them. ");
INSERT INTO engnna_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","After that Jesus came to John from the town of Nazareth, in the country of Galilee. At that time John baptised Jesus in that river Jordan. ");
INSERT INTO engnna_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","As Jesus was coming up from the water he looked up. While he was looking God split the sky. God's spirit came down to Jesus like a dove, he sat on him. ");
INSERT INTO engnna_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","God spoke to Jesus from above, “You are truly my own child. I love you. I am pleased with you.” ");
INSERT INTO engnna_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","After that God's Spirit sent Jesus to the desert, to country that was truly without people. ");
INSERT INTO engnna_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","He was there 40 days and nights. While he was there truly the big evil spirit was trying in vain to persuade him to ignore God's word. Nothing. Jesus was without evil all the time. Wild and biting animals were there. God sent angels from above to take care of him. ");
INSERT INTO engnna_vpl VALUES ("MK1_14a","071_1_14a","MRK","1","14a","14a","The big boss for the Jews, King Herod became angry with John. He told soldiers, “Tie John up and put him in gaol.” ");
INSERT INTO engnna_vpl VALUES ("MK1_14b","071_1_14b","MRK","1","14b","14b","After that Jesus left that country, Judea, he went north to the country of Galilee. There he was telling many people God's word. ");
INSERT INTO engnna_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","He was saying to them, “Listen! I am telling you a good word from God. You have been ignoring God, you did not listen to him. Be ashamed! You have been doing bad things. Stop it! Believe his good word. In return he will be happy with you. He will make you his people. For this very word our old people who died long ago truly were waiting a long time. For this same word you also have been waiting.” In that sort of way Jesus was talking to them. ");
INSERT INTO engnna_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","He was going along the edge of the water, the water-hole Galilee. That is a large amount of water. He saw two people who habitually got fish, Simon and his younger brother Andrew. They used to get fish with nets. ");
INSERT INTO engnna_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus said to them, “Follow me. I will teach you about God. Then you will tell others about God. They will believe in God as a result of your word, they will become God's people. Before you used to bring fish to the land with nets. From now with a word you will bring people to God.” ");
INSERT INTO engnna_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Right then in response to his word they left the nets, they followed him. ");
INSERT INTO engnna_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Very soon after that Jesus went a little way, he saw two others, James and his younger brother John. The father of those two was named Zebedee. Those two were sitting in a dinghy with their father and his workers. They were fixing a torn net. ");
INSERT INTO engnna_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Right then Jesus called James and John. Right then in response to his word they left their father in the dinghy and they left the workers, they followed Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","After that they went with Jesus towards that town, towards Capernaum. They arrived there. Saturday came. On Saturday the Jewish people did not work. That was their law. Saturday was for them to think about God's word. In the towns they used to gather in a meeting house to listen to God's word and to talk to God. There in Capernaum Saturday came for them, Jesus entered their meeting house. He was teaching them about God. The people were listening to him. ");
INSERT INTO engnna_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","They were puzzling about his word. “Truly it is different. This man truly talks correctly. Not like our teachers. They are just talkers of other peoples' words. This Jesus teaches us with a correct word. Truly God told him to talk like that.” ");
INSERT INTO engnna_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Right then a man entered the meeting house. An evil spirit was making him crazy. ");
INSERT INTO engnna_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","He was afraid, he called out loudly, “Jesus from Nazareth! What do you want for us spirits? Having come will you hit us to kill us? I know you. God sent you. You are God's one who is truly without evil.” ");
INSERT INTO engnna_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus rebuked the evil spirit, “Be quiet! Leave the man! Go elsewhere!” ");
INSERT INTO engnna_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","The spirit really made that man thrash around, then it called out loudly, it left, it went away for good. ");
INSERT INTO engnna_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","All the people were puzzling about Jesus. They said to each other, “Who is this? This is a different kind of word. He talks correctly. He might say a word, and in response to his word whatever it is the evil spirits also do it.” ");
INSERT INTO engnna_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","At that time they kept telling each other Jesus' words everywhere in the country of Galilee. ");
INSERT INTO engnna_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","After leaving that meeting house Jesus went to the camp of Simon and Andrew. Two also went, those other two, James and John. ");
INSERT INTO engnna_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon's mother-in-law was sick. She was lying down in the house with a fever. As soon as Jesus came they told him that. ");
INSERT INTO engnna_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesus went to her, he held her hand, the woman stood up. Right then the sickness left her, she walked around well, she brought food for them. ");
INSERT INTO engnna_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Soon after the sunset, after twilight, they were bringing many people to Jesus, some of them sick, others crazy from evil spirits. ");
INSERT INTO engnna_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","The people gathered there, they all came to him at the door of the house. ");
INSERT INTO engnna_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus made many with various sickness well, and from many he sent away evil spirits. They knew him. Because of that Jesus stopped the spirits from talking. ");
INSERT INTO engnna_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","In the morning, before sunrise, Jesus got up from sleep, he left the house. After that he left the town, he went outside the town to the desert alone. There he talked to God. ");
INSERT INTO engnna_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon and others were searching for Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","When they saw him they said to him, “Everyone has been looking for you.” ");
INSERT INTO engnna_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","He said to them, “We will not return to Capernaum now. We will go to other towns, I will tell them about God. God sent me to do that.” ");
INSERT INTO engnna_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","He was going around to them in Galilee, in the meeting places he was teaching many about God and was sending away evil spirits. ");
INSERT INTO engnna_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","One day a man came to Jesus. He was sick, his skin was very bad. According to the law of the Jews all with that sickness should stay far away, truly alone. They should not enter a camp. That man when he came kneeled down to him, he begged Jesus, “Please make me well, make my skin good. What do you wish?” ");
INSERT INTO engnna_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus was sorry for him. After stretching out his hand he touched the sick one. “Yes, I want to make you well. I will make you really smooth.” ");
INSERT INTO engnna_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Straightaway that sickness disappeared (lit. 'it became nothing for him'), that man's skin became smooth. ");
INSERT INTO engnna_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus told him sternly, “Listen! ");
INSERT INTO engnna_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Do not tell them I made you well. Go straight to the ceremonial leader. He will look at your body all over, your skin is smooth. You know that law about your sickness. A long time ago God told Moses to write it in a book. In accordance with his word take a live sheep to the ceremonial leader. That leader will cook it till it is dry, right to ashes. Because of that when other people see that they will know about you, you are smooth, without sickness. After that you can again enter the camp.” In that way Jesus talked to him. Then he sent him to the ceremonial leader. ");
INSERT INTO engnna_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","That man did not stay quiet. He ignored Jesus. As he was going about he was continually telling people everywhere, “Jesus made my skin well.” Because of that talk Jesus did not go to the towns, he did not enter (them) so as to avoid many people. He was staying out in the country. Still people were coming to him from everywhere. ");
INSERT INTO engnna_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","After that Jesus returned to the town of Capernaum. There they were saying to each other, “Jesus has returned.” ");
INSERT INTO engnna_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Many people came to his house to listen to him. He was teaching them about God. Very many people were inside that house, many others were standing around outside, they were listening to him. ");
INSERT INTO engnna_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","At that time four men came. They were carrying a sick man on a blanket, he was very weak, he could not walk. They brought him to Jesus to heal him. ");
INSERT INTO engnna_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","They tried in vain to enter the house, many people were there. Very many were standing close to Jesus. After that they climbed on top of the house. They made a hole on top close to Jesus, they lowered the sick man on the blanket in front of Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus said to himself, “They believe I will heal this sick person.” Then he spoke kindly to the sick one, “You have earlier been ignoring God. In response I will not hit you, I will not look on you with anger, I will be good to you.” ");
INSERT INTO engnna_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","There were a few of the Jews' teachers sitting in that house. They became upset at Jesus' words. They were thinking to themselves, ");
INSERT INTO engnna_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“He should not talk like that. He said to him, 'You have earlier been ignoring God. In response I will not hit you, I will be good to you.' That is what he said. He spoke very badly. Only God can talk like that. People can't talk in that way. That Jesus is making himself like God.” ");
INSERT INTO engnna_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Jesus knew about them, that they were thinking in that way, that they were criticising him in that sort of way. He asked them, “Why are you criticising me in that way? I said to this man, 'You have earlier been ignoring God. In response I will not hit you, I will be good to you.' You say I should not talk in this way. How shall I talk to this sick person? Perhaps I will say to him, Stand up, pick up your blanket, go on foot'. How about it? Should I talk to him in that way? Will he become well at my word? Will he be without sickness? ");
INSERT INTO engnna_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yes! Right now I will heal this sick one. Because of that you will know about me, God is the one who truly told me to make him well. You will know about me God truly told me to just leave bad people, to be good to them. After that Jesus told the sick one, ");
INSERT INTO engnna_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Stand up, pick up your blanket, go to your camp.” ");
INSERT INTO engnna_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Right then that man stood up, he picked up his blanket, he went straight outside. They were all watching him as he kept going. They were saying, “He did a good thing. This is new! We have not seen this.” They were praising God, they were saying to him, “Thank you! Truly you are good.” ");
INSERT INTO engnna_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Again Jesus was going along the edge of the big water, the waterhole Galilee. Many people gathered with him. He was teaching them about God. ");
INSERT INTO engnna_vpl VALUES ("MK2_15b","071_2_15b","MRK","2","15b","15b","Many who disregarded the laws of the Jews were following Jesus. Some of them were tax collectors (lit.'money removers'). They used to work from the Roman government, they would take money from people in accordance with the Government's word. They were thieves. They would take a lot of money from them, they would give some to the Government boss, the rest they would keep for themselves. Day after day many like them who were also disregarders of the law of the Jews were following Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","One day Jesus was going along the waterhole Galilee. He saw a man, a tax collector, his name was Levi. This Levi was sitting in his working house. When Jesus saw him he said to him, “Follow me.” Right then he left his work, he kept following Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK2_15a","071_2_15a","MRK","2","15a","15a","After that Jesus went to Levi's house to eat food. Some other tax collectors also, and others who were disregarders of the law of the Jews came to eat food there. ");
INSERT INTO engnna_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Others who were Jewish teachers stood nearby. They called themselves Pharisees. They saw Jesus eating with those who were disregarders of the Jews' law. They said to Jesus' men. “Jesus should not eat with tax collectors and those who are disregarders of the law. He is doing a bad thing.” Like that the Pharisees were talking. ");
INSERT INTO engnna_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesus heard them. In response he said to them, “The doctor will not come to heal those who are healthy, he will come only to those who sick. I do like that. I did not come to call those who are habitually good to God. I came to call to God those who are disregarders of God, in accordance with his word. Therefore I am eating with those people.” ");
INSERT INTO engnna_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","After that Jesus again entered the meeting house. That day was Saturday. In that house there was a man with a bad hand, it was shrivelled, he could not move the hand. ");
INSERT INTO engnna_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","There were a few Pharisees there also. They did not like Jesus. They were watching him. They were saying to each other, “Today is Saturday. He might heal the sick person. According to our law that is bad. He should not heal a sick one on Saturday. If he does that we will really criticise him.” In that way those Pharisees were talking to each other. ");
INSERT INTO engnna_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus said to that man with the bad hand, “Come here.” ");
INSERT INTO engnna_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","5","Then he said to the Pharisees, “Listen! You know about Saturday, our day for not working. That is according to God's word. Yes, according to our law what shall we do to people on Saturday? Shall we do good to them? Shall we do bad to them? Shall we heal them? Shall we hit/kill them? What? You say.” They did not answer him. They were quiet in his presence. They were without pity and were stubborn. Therefore Jesus looked at them with anger. He was also sorry for them. After that he said to the man with the bad hand, “Stretch out your hand.” He stretched it out, it became well. ");
INSERT INTO engnna_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Then those Pharisees became angry with him. They went away to talk with some others, what's their name, Herod's people. They joined together, they were discussing among themselves, “How shall we kill Jesus?” ");
INSERT INTO engnna_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","After that Jesus and his men went to the big water, the waterhole Galilee. Many people followed him. They were coming from that big town, Jerusalem, and from the countries of Judea and Idumea and from the other side of the Jordan river. They heard, “Jesus healed those who were sick.” After that many were coming. ");
INSERT INTO engnna_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","He healed many who were sick. They were coming very close to touch him. After that Jesus told his men, They might squash me. Get a dinghy for me. I will sit in it to avoid being squashed.” ");
INSERT INTO engnna_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","12","Some people were bringing other people to Jesus, they were crazy. Evil spirits were controlling them. As soon as they saw Jesus the evil spirits were throwing the people on the ground in front of Jesus. They were calling out with fear, “Jesus! You are God's child!” He was telling the spirits sternly, “Be quiet!” He was preventing them from naming him, “God's Child”. ");
INSERT INTO engnna_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","At sunset Jesus said to his men “We will go eastwards to the other side of the water.” ");
INSERT INTO engnna_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Therefore they left the rest of the people on the land, they took Jesus on the water in a dinghy. Other dinghys also followed them. ");
INSERT INTO engnna_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","As they were going Jesus was aleep at the back, on a blanket, on a pillow, he was sound asleep. After that partway along a really big wind came up, the water became waves, it was entering the dinghy, the water was filling it. Jesus' men became very afraid. They woke him up. They said to him, “Teacher! Truly the water will drown us all. Soon we will die. Save us! Why did you forget us? ");
INSERT INTO engnna_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus got up from sleep, he said told them, “Wind abate! Water go down!” At his word the wind abated right then, the water went down in the same way, it became calm. ");
INSERT INTO engnna_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus asked his men, “Why were you afraid? Why didn't you believe in me?” ");
INSERT INTO engnna_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","They were really wondering about him. They said to each other, “The wind and the water listened to him! At his word the wind abated and the water really went down. Truly he is boss for the water and wind! What is this Jesus like? Who is he?” They were wondering in that way. After that they were afraid of him. ");
INSERT INTO engnna_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","He was going about naked, he used to make his camp inside the caves, close to dead ones. The spirit used to make him very angry. Before this people used to try in vain to tie his hands and feet with chains. The spirit would make him extra strong, that man would break the chains. ");
INSERT INTO engnna_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","He was going around in caves and hills in the day and in the night. In his madness he was calling out and cutting himself with stones. ");
INSERT INTO engnna_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","This poor man as soon as he saw Jesus from a long way off ran to meet him, he knelt in front of him. ");
INSERT INTO engnna_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesus said to the spirit, “Leave the man! Go away!” ");
INSERT INTO engnna_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","The man called to him loudly, “Leave me, Jesus! I know you. Your father is above, he is truly Boss for above and for everywhere. You are his own child. What do you want, will you kill me? I beg you, do not send me to the big fire to burn! In that way the spirit talked to Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus asked the man, “What is your name?” He said to him, “My name is 'Many'. We are many spirits.” ");
INSERT INTO engnna_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","They were asking him, “Do not send us from this country.” ");
INSERT INTO engnna_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","On that rise there were pigs, many of them, 2,000, they were eating green grass. ");
INSERT INTO engnna_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","The spirits begged Jesus, “Send us to the pigs. How about it? Can we go into them?” ");
INSERT INTO engnna_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","He said to them, “Yes, you can go to the pigs.” Right then they left that man, they all went to the pigs, the spirits went into them. Right then all the pigs ran down from the hill, they went straight into the water, they died in the water. ");
INSERT INTO engnna_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","The people who looked after the pigs scattered, they ran away afraid. They told many from the town and country. After that many came to see. ");
INSERT INTO engnna_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","When they came to Jesus they saw that man who used to be crazy there. He was sitting near Jesus, he had clothes on, he was without evil spirits, not crazy, he was well. After seeing him they became afraid. ");
INSERT INTO engnna_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","There were others who were standing there. Earlier they saw the pigs go into the water. They told those as soon as they came, “This Jesus sent the spirits from the man to the pigs. After that they ran down from the hill, they went into the waterhole, the water drowned all the pigs, they are completely dead.” ");
INSERT INTO engnna_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","After that the local inhabitants told Jesus, “Go. Leave our country.” ");
INSERT INTO engnna_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Then Jesus climbed in the dinghy. The man who had become well asked Jesus, “Can I come with you?” ");
INSERT INTO engnna_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","He replied, “No. Return to your people. Tell them God was sorry for you, he truly made you well.” ");
INSERT INTO engnna_vpl VALUES ("MK5_21a","071_5_21a","MRK","5","21a","21a","Then Jesus returned westwards to the other side of the waterhole. ");
INSERT INTO engnna_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","In response to his word that man after he returned was going around in that country, in the east, in the 10 towns. He went to all people. He was telling them, “God made it very good for me. Jesus sent the spirits from me. He healed me.” They all were pleased, they were wondering about Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK5_21b","071_5_21b","MRK","5","21b","21b","Many people gathered with Jesus at the edge of the waterhole. ");
INSERT INTO engnna_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","A man came, his name was Jairus. He was boss for the meeting house in his town. As soon as he saw Jesus he kneeled down in front of him. ");
INSERT INTO engnna_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","He begged him, “My young daughter is very sick, she might die. Come to my camp, touch her with your hand. After that she will not die, she will truly stay alive.” ");
INSERT INTO engnna_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesus went with him, many were following those two. The people were squashing each other. ");
INSERT INTO engnna_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","This woman also followed him. That woman had been sick a long time, 12 years. She truly kept losing blood (lit. 'blood kept crawling for her'), it was a big sickness. ");
INSERT INTO engnna_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","She used to go to various doctors. They did not heal her. Hers was a big sickness. After that she had no money, still she was staying sick. ");
INSERT INTO engnna_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","She heard, “Jesus heals sick people.” After she heard she said to herself, “I will touch just his clothes. After I touch him I will truly become well, I will be without sickness.” She did that. Partway along she came close to him, from behind she touched his clothes. ");
INSERT INTO engnna_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Right then her blood stopped flowing, that woman knew she was well, she was happy. ");
INSERT INTO engnna_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Right then Jesus knew about that, he said to himself, “Someone touched me, that person has become healthy.” He stopped, he turned round. He asked them, “Who touched my clothes.” ");
INSERT INTO engnna_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","His men said to him, Why did you say that? Many people have been squashing you. Why did you ask, 'Who touched me.'?” ");
INSERT INTO engnna_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","He was ignoring them, still he was looking around. ");
INSERT INTO engnna_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","That woman knew about herself, she was truly healthy, without sickness. She was trembling with fear, she came to Jesus. She kneeled down in front of his feet, she truly told him a straight word. ");
INSERT INTO engnna_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus talked kindly to her, “You believed in me for good. Therefore now you are well. Go without fear, you will stay well. From now on you will not again get this sickness. ");
INSERT INTO engnna_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","While he was talking to the woman some others came from Jairus's house. They said to Jairus, “Your daughter is dead. Leave the teacher alone. Don't annoy him. ");
INSERT INTO engnna_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus heard their words. He said to Jairus, “Don't be afraid, don't get upset. Still believe in me.” ");
INSERT INTO engnna_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Many people were following Jairus and Jesus. Jesus told them, “Stay here.” Then Jesus picked just three of his men, Peter and James and James's younger brother, John. They went, Jesus and Jairus also, to the camp of Jairus. ");
INSERT INTO engnna_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","They went to the front of the house, they stopped. There at the house they saw many people. They were all crying with one another for the young girl. ");
INSERT INTO engnna_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","When Jesus entered he told them, “Don't cry. That young girl is only sleeping. She is not dead.” ");
INSERT INTO engnna_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","They mocked him. They did not believe his word. After that he told them, “Go outside.” Then he told just the mother and father of the child and Peter and James and John, “Let us go to the child.” They went to that dead child. ");
INSERT INTO engnna_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","He held her hand, he said to her, Child, stand up!” ");
INSERT INTO engnna_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Right then in response to Jesus's word her spirit returned to her. The child stood up, she walked around, she took a few steps. (She was just about an adolescent girl, twelve years old.) When they saw it they were pleased, they were saying to each other, “Yes we have never seen a thing like this. He made her alive from death.” ");
INSERT INTO engnna_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","He told the girl's father and mother sternly, “Do not tell them I made this child alive.” Then he said to them, “Give the child some food.” ");
INSERT INTO engnna_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","After that Jesus went to his own country, his men followed him. ");
INSERT INTO engnna_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus was going to towns, he was teaching them about God's word. ");
INSERT INTO engnna_vpl VALUES ("MK6_7a","071_6_7a","MRK","6","7a","7a","After that he called his men, ");
INSERT INTO engnna_vpl VALUES ("MK6_7c","071_6_7c","MRK","6","7c","8","he told them, I will send you to people, you will tell them about God. I told you this word. From now on you send evil spirits from people. You go, do not take money or food. ");
INSERT INTO engnna_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Put on shoes, take only one set of clothes. Leave other clothes behind. ");
INSERT INTO engnna_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Perhaps in some towns a person will say to you, 'Come here, stay a little while with us.' At that time you will stay in his camp in that town. ");
INSERT INTO engnna_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Perhaps you will come to other towns, they will ignore you, they will not ask you to stay in their town, they will not listen to God's word. If they do that do not stay in that town. Brush the dust from your shoes. When you do that you will show them God will be angry with them after ignoring his word. Then leave that town. ");
INSERT INTO engnna_vpl VALUES ("MK6_12a","071_6_12a","MRK","6","12a","12a","Yes, that is all. Go by twos.” ");
INSERT INTO engnna_vpl VALUES ("MK6_12b","071_6_12b","MRK","6","12b","12b","After that they went. As they were going they were telling people, “You have been ignoring God. Leave doing wrong and believe in God!” ");
INSERT INTO engnna_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","They were sending away many evil spirits, they put medicine on many sick people, they were asking God, “Will you make this person well.” After that the sick person became well. God made them well. ");
INSERT INTO engnna_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Later Jesus' mob who had been sent out returned to him. They told him they were making people well, they were sending out evil spirits, they were teaching people about God, in that way, in response to Jesus' word. ");
INSERT INTO engnna_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","At that time very many people came to Jesus. They were crowding him from all sides. They did not let Jesus and his men eat. After that Jesus said to his men, “Just we will go to countryside where there are no people. We will rest for a while.” ");
INSERT INTO engnna_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","They climbed into a dinghy, they went to where there were no people. ");
INSERT INTO engnna_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Many were watching them, they knew about them, and they knew where Jesus was going. They went quickly around the end of the waterhole to the far side on foot, they were ready waiting for him. ");
INSERT INTO engnna_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","When Jesus disembarked he saw many ready waiting for him. When he saw them he felt sorry for them. He said to himself, “These people are truly in a bad way, without a boss. They are lost, like sheep without a carer.” For a long he was teaching them about God. ");
INSERT INTO engnna_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","It became late afternoon. They were still listening to his word. His men said to him, “It is late afternoon. The towns are far away. ");
INSERT INTO engnna_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Send these people to the towns so they can get food for themselves.” ");
INSERT INTO engnna_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus replied, “You give them food.” His men said to him, “We cannot give them food. We could only get food for those many people with a lot of money. We have only a little money.” ");
INSERT INTO engnna_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","In reply he said to them, “How much damper do you have? Look.” After looking they said to him, “Five dampers and two small fish.” ");
INSERT INTO engnna_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","He told his men, “Tell the people to sit down.” They told them to sit down on the grass in groups. ");
INSERT INTO engnna_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","They sat down at his word, here 50 were in a group, over there 100 were in a group. All the others were like that, they were in groups everywhere. ");
INSERT INTO engnna_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus picked up their dampers, he looked upwards, he said to God, “You are the one who gave us this food. Thank you! You have helped us! You are good.” When he had said that, he broke the dampers into pieces, he gave them to his men, he said to them, “Give them to these people.” He did the same sort of thing with the two fish also. ");
INSERT INTO engnna_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Many people ate. Five thousand men ate that food. ");
INSERT INTO engnna_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","They all ate till they were full. ");
INSERT INTO engnna_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","After that his men picked up the leftovers, they put them in carrying dishes, they filled 12 big carrying dishes. ");
INSERT INTO engnna_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","After that Jesus told his men, “Get in the dinghy, go to the other side, to Bethsaida. Later I will come to you.” They went ahead in the dinghy. Then Jesus sent all the others to their camps. ");
INSERT INTO engnna_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","After that Jesus climbed up a hill to talk to God. ");
INSERT INTO engnna_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","It became dark. He was staying there alone. His men were in the dinghy in the middle of the water, they were in a bad way. A big wind was blowing for them. ");
INSERT INTO engnna_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","They were still trying in vain to make the dinghy go, in vain they were trying to make it go with oars (lit. 'with wood') because of the big wind. Jesus saw them from a long way off. He came to them before it was day. He was going on top of the water. He kept coming close to them. ");
INSERT INTO engnna_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","His men saw him, he was following them from behind on top of the water. They did not recognise him, they were thinking something like an evil spirit was coming. They were afraid of him, they really called out with fear. ");
INSERT INTO engnna_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jesus told them, “Don't be afraid. It is me coming. Quieten down, stay well.” ");
INSERT INTO engnna_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","He climbed in the dinghy with them. Right then the wind abated. His men wondered at him. They were saying to each other, “Yes, look! He was walking on top of the water. As soon as he came right then the wind abated.” ");
INSERT INTO engnna_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","They did not understand. Earlier they saw him give food to 5,000 men from a little fish and damper. They didn't keep it in their minds. They were still thinking to themselves, “He is just a person like us.” ");
INSERT INTO engnna_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","After that they arrived in that country Gennesaret. They tied the dinghy with a rope at the edge of the waterhole. ");
INSERT INTO engnna_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesus got out of the dinghy, those inhabitants of the place saw him, straight away they knew him. ");
INSERT INTO engnna_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","They ran everywhere in that country, they were saying to them, “Jesus has come.” After that they were bringing sick ones on blankets. ");
INSERT INTO engnna_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","That is what they were doing in town after town, in camp after camp. They were bringing sick people to him. In the middle of the towns on flat places some people used to sell food and all sorts of things. There on the flat places they were putting the sick ones on blankets on the ground. They were saying to Jesus, “These sick people want to touch your clothes. They will touch your clothes, they will become well.” Truly those who touched him all became well. ");
INSERT INTO engnna_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","After that Jesus left his country. He went northwards, he went to another country belonging to foreigners, to the country named Syro-Phoenicia. He was staying close to a town, its name was Tyre. He entered a house to be alone. He said to himself, “The local people don't know me. They will not recognise me.” No. In vain he tried to avoid them. ");
INSERT INTO engnna_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Soon a woman of the area heard about Jesus. She was a different woman, not a Jew, from the country of Syro-Phoenicia. That woman had a daughter. An evil spirit was controlling her child. That woman left her child in the camp, she came to Jesus, she knelt in front of him, she begged him, “Send away an evil spirit from my little child.” ");
INSERT INTO engnna_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus replied kindly to her, “Children should eat food, then you will give food to the little dogs. Don't take the children's food to throw to the little dogs.” With that word Jesus told the woman, “I will do good for the Jewish people, not now will I do good for people from other countries. That is for later.” ");
INSERT INTO engnna_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","The woman replied, “Yes, boss! That word is a true. The children should eat the food. After that the little dogs will eat. Truly the child eat food, The little dogs eat the left-overs that have fallen from the hands of the children.” ");
INSERT INTO engnna_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus said to her, “You spoke well. For that word I will make your child well. You can go. Already the spirit has left your child.” ");
INSERT INTO engnna_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","At his word the woman went, she went to her camp, she saw her child. She was sleeping on her blanket well. The spirit had already gone from her. ");
INSERT INTO engnna_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","After that Jesus again went northwards to Sidon. He went eastwwards, southwards to the 10 Towns, after that he return to the waterhole Galilee. ");
INSERT INTO engnna_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","They brought to him a deaf man, his tongue was weak, he had difficulty talking. They said to Jesus, “Touch this man with your hand, make him well.” ");
INSERT INTO engnna_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus took the man away so they wouldn't be seen. He put his two hands on the man's ears. After that he spat on his own hand, he put it on the tongue of the man. ");
INSERT INTO engnna_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Then Jesus looked up, he took a very big breath. Then he said to the man, “Ears open!” ");
INSERT INTO engnna_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","At his word right then the man's two ears opened, his tongue became good. Then that spoke well. ");
INSERT INTO engnna_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus told the people of the area, “Don't tell others I healed the ears and tongue of that man.” They ignored Jesus' word. They continued telling everybody Jesus had done like that for that man. ");
INSERT INTO engnna_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Everyone heard, they were really pleased about him, they were puzzling about him. They were telling people, “Truly Jesus has been doing the right thing. Some who have been without speech become talkers, some who have been deaf become hearers. He has been doing good to them also. It is not hard (lit. 'a puzzle') for him.” ");
INSERT INTO engnna_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Again one day many people gathered together in the desert. They were listening to Jesus. After that their food ran out (lit. 'became nothing for them'). Jesus called his men, he said to them, ");
INSERT INTO engnna_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“These people have been with me a long time, three days. Now their food has run out. I feel sorry for them. ");
INSERT INTO engnna_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","I will not send them away to their countries hungry. When they go they would fall down with hunger. They have come from a long way.” ");
INSERT INTO engnna_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","His men said to him, “This countryside has no food. Who will search here and get food for all those people? They are truly very many.” ");
INSERT INTO engnna_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus asked them, “How many dampers do you have?” They replied, “7 small dampers.” ");
INSERT INTO engnna_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","7","They also had a few small fish. Jesus said to them, “Tell them to sit on the ground.” After that he picked up the dampers, the fish also, he said to God, “You are the one who gave us this food. Thank you! You have helped us! You are good!” Then he broke the dampers into pieces, he gave them to his men, he gave them the fish also, the said to them, “Give this food and meat to them.” That's what they did. ");
INSERT INTO engnna_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","At that time very many people ate, 4,000 men ate till they were full. Then Jesus told them, “Yes, off you go to your own countries.” After that Jesus' men picked up the leftovers, they filled 7 big carrying dishes with leftovers. ");
INSERT INTO engnna_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","After that Jesus got into the dinghy, his men also, they went to that country Dalmanutha. ");
INSERT INTO engnna_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus went to that town Bethsaida. Some people brought to him a man on a lead, he was truly blind, he could not see. They begged Jesus, “Touch him to make him well.” ");
INSERT INTO engnna_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus took the blind man by the hand to outside the town. He spat on his own hand, he touched the spit, he put it on the man's eyes, he asked him, “Do you see?” ");
INSERT INTO engnna_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","The man looked around a bit, he said to him, “I see people blurrily. I think they look like trees. My eyes deceive me. They are not trees. They have been walking around.” ");
INSERT INTO engnna_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Again Jesus put his hands on the man's eyes. The man was looking carefully, he saw well. ");
INSERT INTO engnna_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus sent him to his camp. He told him, “Do not go to that town, do not tell them I did this for you.” ");
INSERT INTO engnna_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","After three days Jesus picked out Peter and James and John, he took them to a big hill. They climbed up that hill. Only they went. There those three were seeing Jesus shining. ");
INSERT INTO engnna_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","His clothes became white, they became bright for him. Truly a person can not make them really white like that. ");
INSERT INTO engnna_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","After that those three saw two wise old leaders, they were God's two speakers from long ago, the name of one was Elijah, the other was Moses. Those two and Jesus were conversing. ");
INSERT INTO engnna_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter butting in spoke to Jesus, “Teacher, we are right here. That is good. We will make bough shelters for all of you, one for you, another for Moses, another for Elijah. ");
INSERT INTO engnna_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","He and James and John were afraid, they were ignorant about right words. ");
INSERT INTO engnna_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","At that time a cloud came and covered them. God said to them, from the cloud, “This is my own child, I love him, Listen to him.” ");
INSERT INTO engnna_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","They quickly looked around, they did not see the two leaders from long ago. They saw only Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","As they were descending (from the hill) Jesus told them sternly, “You have seen me, I was in the brightness, you saw Moses and Elijah, God spoke to you from the cloud. Do not tell the others. Later after I die I will get up alive. After that you can tell them.” ");
INSERT INTO engnna_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","In response to his word they did not talk to the others. Only they discussed it secretly with each other. “Why did he tell us that word, 'After I die I will get up alive'?” They were puzzling. ");
INSERT INTO engnna_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","After they returned they came to Jesus' other men. They saw them in the middle of a crowd. A few of the Jews' teachers were there arguing with Jesus' men. ");
INSERT INTO engnna_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","When the crowd looked they saw Jesus close, they were pleased, they ran to meet him. “We are happy! You have come!” ");
INSERT INTO engnna_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus asked his men, “Why were you arguing with them?” ");
INSERT INTO engnna_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","One man said to him, “Teacher, my child is controlled by an evil spirit, he can't talk. ");
INSERT INTO engnna_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","The spirit grabs him, it throws him on the ground. Saliva froths from his mouth, he grinds his teeth, his body becomes very stiff. Therefore I brought him to you so you can make him well. I asked your men to send the demon right away. Nothing. They tried in vain to send it away.” ");
INSERT INTO engnna_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Then Jesus said to his men, “You truly have not believed in God. How is it? You are still unbelievers. How long shall I be with you? Shall I teach you for a long time? After that will you believe in God? Bring the child to me.” ");
INSERT INTO engnna_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","They brought him to him. As soon as he saw Jesus the spirit grabbed that child, it made him thrash around. At that time the child fell on the ground, trembling he was rolling from side to side. Saliva was coming from his mouth. ");
INSERT INTO engnna_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus asked his father, “When did he become like this?” He said to him, “When he was a child. ");
INSERT INTO engnna_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Many times the spirit has thrown him in the fire or in the water, it has been trying to kill him. Have pity on us. Perhaps you will make him well.” ");
INSERT INTO engnna_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","24","Jesus replied, “Yes, I know how to heal him. Why did you say that word to me, 'Perhaps you will make him well.'? You must believe in God. Then you can ask God for anything. For that particular thing he knows how to do it. It is not a puzzle for God.” Right then the man called out loudly, “I believe in God. Teach me to believe properly!” ");
INSERT INTO engnna_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus saw many people gathering together. Therefore he said sternly to the evil spirit, “You bad spirit, you made this child deaf, you made him unable to speak. Leave. Go away. Do not again control him.” ");
INSERT INTO engnna_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","The spirit called out, it was making the child thrash around, it was very bad. Then it left, it went away permanently. That child was like a corpse. Many were saying, “He is truly dead.” ");
INSERT INTO engnna_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesus raised him up by the hand. After that the child stood up. He was well. ");
INSERT INTO engnna_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","After Jesus entered the house his men asked him, “Why couldn't we expel that spirit?” In vain we tried to send it away.” ");
INSERT INTO engnna_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus replied, “Only after praying to God will you expel a demon like that.” ");
INSERT INTO engnna_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jesus and his men left that place, they were going around the country of Galilee. He wanted the people of the area not to recognise him. He was wanting to teach his men about himself, others would kill him. He was telling them, “You know about me, God sent me to people. Some people have been saying God did not send me. They want to kill me. Truly they will grab me, they will take me to other people. Those others will truly kill me. After that, after two nights, truly I will become alive again.” In that way Jesus talked to his men. ");
INSERT INTO engnna_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","His men were very ignorant about that talk. They did not want to ask him in response, they were shy. ");
INSERT INTO engnna_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","They went to that town Capernaum. After his men had entered the house Jesus asked them, “As we were coming why were you arguing with each other?” ");
INSERT INTO engnna_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","They stayed silent. They didn't answer him. As they were going along they were arguing with each other. In this way they were saying to each other, “Who among us will be boss for us all?” ");
INSERT INTO engnna_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","After sitting down Jesus called them to him. He said to them, “Maybe you want to be boss, make yourself small, do good to everyone.” ");
INSERT INTO engnna_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","After that he called a child, after leading him he stood him in front of them. After hugging him he said to them, ");
INSERT INTO engnna_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Maybe you will do good to someone like this child to please me. That good thing you did for the child, that same good thing you also did to me. God sent me. Because of that when you do good to me you will make me happy, you will make God happy also.” ");
INSERT INTO engnna_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John told Jesus, “Teacher, we saw a man, he was expelling demons from people in your name. That man does not belong to our mob. After that we told him not to do like that.” ");
INSERT INTO engnna_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus replied, “Don't prevent him. Truly those who have done a good big thing in my name will not on another day say something bad about me to others. ");
INSERT INTO engnna_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Those who are not criticisers of us, they are (our) defenders. ");
INSERT INTO engnna_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","I tell you this word truly, others who learn about you that you belong to me, and because of that will do a small good thing to you, truly in response God will do good to them.” ");
INSERT INTO engnna_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mothers and fathers were taking their children to Jesus, they were asking him, “Teacher, ask God to do good to our children.” Jesus' men rebuked the mothers and fathers. ");
INSERT INTO engnna_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","When Jesus saw them he became upset, he said to them, “I want the children to come to me. Do not prevent them. They gladly believe in God, they obey his word. ");
INSERT INTO engnna_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I am telling you this word truly, all of you must be like them, you must believe in God like they do. If you don't do that you will not belong to God.” ");
INSERT INTO engnna_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","After that he put those children one by one on his lap, he hugged him, he put his hand on the child's head, he asked God, “Do good to this child.” In that way he was asking God for them. ");
INSERT INTO engnna_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","After that as soon as Jesus was going along a man ran to him, he knelt down in front of him, he said to him, “Teacher, you are good. After I die I want to stay alive with God forever. How can I do it?” ");
INSERT INTO engnna_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","In reply Jesus asked him, “Why did talk about me with that word 'good'? Only one is good, that is God. ");
INSERT INTO engnna_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","You know his word. It says to us, 'Do not kill a person. Hold only your own wife, do not take another's wife. Do not take another person's possessions. Do not accuse another person falsely. Do not cheat another person of a fair share. Listen to/obey your mother and father.'” ");
INSERT INTO engnna_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","He replied, “Teacher, since I was a child I have been obeying God's word. ");
INSERT INTO engnna_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus looked at him, he really loved this man. He said to him, “You should do this other thing also. Sell all your possessions. Then give all your money to those who are poor and hungry. After that follow me. If you do that you will truly stay in a good way above with God. ");
INSERT INTO engnna_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","That man had possessions and money, he truly had a lot of those. He did not want to leave them. Therefore he did not like Jesus' word. He was sorry for himself, that man's face was downcast, he just went away. ");
INSERT INTO engnna_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus said to his men, “My men, listen to this word. Those with many possessions will try with difficulty to become God's people. Perhaps a few will become his.” ");
INSERT INTO engnna_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","His men were shocked at his word. Again Jesus said to them, “My men, truly they can hardly become God's. ");
INSERT INTO engnna_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","You know the hole in the end of a needle. That is small. How about it? Will a camel enter that hole. Certainly not. It will not begin to try. That is truly a puzzle. In that sort of way those with many big possessions will hardly try to become God's. For them it is truly a puzzle. Maybe only a few with large possessions will become God's. ");
INSERT INTO engnna_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","His men were completely puzzled at that word. They were saying to each other (?), “So then who truly will stay alive with God forever?” ");
INSERT INTO engnna_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus replied seriously, “Truly a person cannot put himself into God's people. Only God can place a person with him above alive forever. Yes. Truly what God wants to do, he will do that. It is not a puzzle for God.” ");
INSERT INTO engnna_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","At that time Peter said to him, “Please listen, we have left our camps and all our possessions to follow you.” ");
INSERT INTO engnna_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus replied, “This is a true word I am telling you, all who want to follow me to tell God's word might leave houses and older brothers and older sisters and younger siblings and mothers and fathers and children and food-producing land. They might do that to please me. ");
INSERT INTO engnna_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","If they do that God will give them now many houses and older brothers and older sisters and younger siblings and mothers and children and lands. This also I am telling you. Other people will keep hitting them, they will mock them, they will put them in prison. That is what they will do to them. Yes. After they are dead truly God will make them alive, they will stay with God forever. ");
INSERT INTO engnna_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Truly some people are important now, later after they have died God will make them unimportant. Some people are unimportant now, later after they have died God will make them important.” ");
INSERT INTO engnna_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","They were going to Jerusalem. Jesus was going ahead. His men were puzzled and upset. Many were also following behind, they were afraid. Again Jesus took his men away alone, he talked to them about how others would treat him in Jerusalem. ");
INSERT INTO engnna_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Listen. We are going to Jerusalem. You know the Jewish lawmen want to kill me. There someone will give me to them. They will gather together to criticise me. They will make a word about me. Then they will say to me, 'You should die.' After that they will give me to foreign bosses from the Roman Government. ");
INSERT INTO engnna_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Those foreigners truly will mock me, they will spit on me, they will hit me with a whipping thing, then they will kill me. After that, after two nights, I will get up alive. ");
INSERT INTO engnna_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","James and John, Zebedee's children, came to him, they said to Jesus, “Teacher, will you do one thing for us?” ");
INSERT INTO engnna_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“What shall I do for you two?” ");
INSERT INTO engnna_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“One day God will put you as a really big boss. Only you will be the big boss for all people everywhere. When that happens will you make us two bosses?” We want to sit close to you on your right and on your left.” ");
INSERT INTO engnna_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","He replied, “You do not understand what you have asked for. They will hit me really hard. How do you like to be like me? They might also hit you hard. What? Are you unafraid of that? ");
INSERT INTO engnna_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","They replied, “We are unafraid.” Jesus said to them, Yes, they will hit you really hard. They will put you in a very bad way. ");
INSERT INTO engnna_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","I cannot make you bosses. I cannot choose two to become bosses, so they will sit close to me. God is the only one who will choose them.” ");
INSERT INTO engnna_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","His other men when they heard became angry with James and John. ");
INSERT INTO engnna_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesus called them, he said to them, “Listen. You know about foreigners in other countries. Their bosses keep them in a bad way, they become masters for their people. ");
INSERT INTO engnna_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","You truly can't do that sort of thing. Perhaps one of you will want to be boss, he should work for other people. ");
INSERT INTO engnna_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Perhaps someone among you will want to be important, he should make himself small like nothing. ");
INSERT INTO engnna_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","That is how I am. God sent me to people. I came not to become a boss. I will not do like that. I came to people to do good to them. I will die for them to make them alive. After I have died I will make many people alive everywhere. Therefore many will sit down with God, they will stay alive forever.” ");
INSERT INTO engnna_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus and his men and many other people came to that town Jericho. They went right through there. On the other side they went close to a man, his name was Bartimaeus, he was the son of Timaeus. He was blind, unable to see. He was sitting near the road, he was asking people for money and food as they were going back and forth past him. ");
INSERT INTO engnna_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","At that time people were saying to each other, “That man going straight on is Jesus from Nazareth. The blind man when he heard was calling out, “Jesus, God sent you in accordance with his word from long ago. Please be sorry for me.” ");
INSERT INTO engnna_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Some people were rebuking him, they were saying to him, “Be quiet!” No. He was truly calling loudly, “Jesus. Please be sorry for me.” ");
INSERT INTO engnna_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus stopped, he said, “Call him.” In response to his word they called that blind one. “Be happy. He is calling you.” ");
INSERT INTO engnna_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Right then he abandoned the blanket he had on his shoulders, he quickly stood up, he came to Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus asked him, “What shall I do for you?” “Teacher, Make my eyes good.” ");
INSERT INTO engnna_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Yes, you can go. You believed in me. Therefore I am making you well.” Right then his eyes became good. Straight after that that man was following Jesus on the road. ");
INSERT INTO engnna_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","They came close to Jerusalem, they climbed a big hill, its name was the Hill Having Olives. On this hill were two towns, the name of one was Bethphage, the name of the other was Bethany. Then Jesus sent two of his men to go ahead. ");
INSERT INTO engnna_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","He said to them, “Go ahead to that town. As soon as you arrive you will see a donkey, a young one, tied up there. They haven't trained it yet. Remove the rope from the stick, bring the donkey this way. ");
INSERT INTO engnna_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maybe someone will ask you, 'Why are you doing that?'. Say to him, 'The boss wants him.' Then he will send the donkey here.” In that way Jesus spoke to them. ");
INSERT INTO engnna_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","After that they went, they saw the young donkey in the town, near a house, tied up at the doorway. They removed the rope from the stick. ");
INSERT INTO engnna_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Some people standing there asked them, “Why did you remove that rope?” ");
INSERT INTO engnna_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","They replied with Jesus' words. So they left those two alone. ");
INSERT INTO engnna_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","They brought it to Jesus. A few people put their blankets on the donkey. Jesus climbed on. ");
INSERT INTO engnna_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Many people put their blankets spread out in front of him. Some people cut leaves close to the road, they put the leaves also on the road. They wanted to make Jesus a big boss, that boss they call King. That is why they did that. ");
INSERT INTO engnna_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Jesus was riding the donkey, some people were going on foot behind and ahead close to him. They were calling out, “God is very good! In accordance with his word from long ago he sent this man to us. This man will be a good king for us, like that boss from long ago, King David. He will look after us well forever. God is very good!” In that sort of way they were talking loudly. ");
INSERT INTO engnna_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus entered Jerusalem. At that place for a long time there was a really big house, from long ago they built it to pray to God there. That house they used to name the Temple. Jesus went to that Temple belonging to God. After entering he looked around carefully. The sun had already set. After that they went out of Jerusalem, they returned to the small town Bethany, his men also went. ");
INSERT INTO engnna_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","In the morning Jesus was going from Bethany to Jerusalem, he was hungry. ");
INSERT INTO engnna_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Far off he saw a tree, it was a fruit tree, with many leaves. When those trees have leaves people will get fruit. Omit previous sentence - it contradicts Mark's statement that it was wrong time for figs. Jesus went to that tree, he was looking for fruit. When he came close there was nothing, no fruit, only leaves. That tree deceived him. ");
INSERT INTO engnna_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","He spoke to that tree, “From today you will forever have no fruit. They will not eat from you again.” His men heard him say that. ");
INSERT INTO engnna_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","They came into Jerusalem, they went to God's Temple. Many people were inside the Temple. In there some had sheep, others had doves. Some were buying those animals to kill and to give to God. They could not give their own money for those sheep and doves. Only another kind of money, Temple money only, only that they could give. Some people were taking their money from them, in response they were giving them Temple money. By cheating they were taking a lot of money from them, they were giving them a small amount of Temple money. After Jesus entered he threw their tables upside down, he also threw down the chairs of those who worked with doves. He chased outside the givers of money and the takers of money. ");
INSERT INTO engnna_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Some people were going straight through the Temple, they were carrying belongings. Jesus stopped them. ");
INSERT INTO engnna_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","He said to everyone, “In God's book someone from long ago wrote this word: 'God's house is for all people everywhere. Here they will pray to God.' No way! You have truly been stopping them. You have made God's house a place for thieves. ");
INSERT INTO engnna_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Those Jewish lawmen were listening to his words. They were afraid of him. Secretly they were talking to each other, “How shall we kill Jesus?” All the other people liked Jesus. When he taught them he was truly making them happy. ");
INSERT INTO engnna_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","When it became evening Jesus and his men left Jerusalem. ");
INSERT INTO engnna_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Early in the morning they were going along the road towards Jerusalem, they saw that deceiving tree, it was dry. It was completely dead. ");
INSERT INTO engnna_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter remembered that word of Jesus. He said to him, “Teacher, look! That tree without fruit, the other day you spoke sternly to it, now it is truly dead.” ");
INSERT INTO engnna_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus replied, “You all should believe in God. ");
INSERT INTO engnna_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","This word I am telling you is true. Maybe you will tell that big hill to move, 'Throw yourself into the sea!' If you believe and do not doubt, at your word it will happen in that very way for you. ");
INSERT INTO engnna_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","This word I am telling you, when you talk to God, whatever you ask, believe God for that. Then that very thing he will do for you. ");
INSERT INTO engnna_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","When you talk to God, remember, 'Who has done wrong to me?' Then when you have remembered do not look on him with anger, just let him alone. In return your Father Above will not look at you with anger, he will just leave you alone after you have done wrong.” ");
INSERT INTO engnna_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Again they came to Jerusalem. Jesus entered God's Temple. All those Jewish lawmen came to him. ");
INSERT INTO engnna_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Sternly they asked him, “Those people you chased out of the Temple the other day, who told you to do that? Who made you a boss?” ");
INSERT INTO engnna_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus replied, “I will ask you a word. You give me a straight word. Then I will tell you who told me to do like that. ");
INSERT INTO engnna_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","You tell me about that man John, he was telling them to leave evil, and he was baptising them. Who told John to do that? Did God tell him? Did some person tell him? You tell me your word.” ");
INSERT INTO engnna_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Secretly they were talking to each other. “What shall we say? We might say to him in this way, 'God told him.' He will reply, 'Why didn't you believe him?' ");
INSERT INTO engnna_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","We might say a different word to him. We might say, “It was just a person who told him'. No. We cannot say that!” In that way they were secretly talking to each other. They were very afraid of people. All the people were thinking truly God sent John to them to teach them God's word. ");
INSERT INTO engnna_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Therefore the lawmen with fear said to him, “We don't know about that.” Jesus in response said to them, “You did not give me a straight word. In response I will not tell you who told me to send those people away.” ");
INSERT INTO engnna_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","One day Jesus was sitting in the big house, God's house, the Temple. A big money box was there. People were bringing money for God, they were putting it in that box. Jesus was sitting near that money box. They were putting in money, he was watching them. Some people with a lot of money put in a big lot of money. ");
INSERT INTO engnna_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","After that a poor bereaved woman came. Her husband had earlier died. She put in two little coins for God. That was valuable. After giving those two that woman had no more money. ");
INSERT INTO engnna_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Jesus said to his men, “Do you see that poor woman? She has very little money. She put in all of it for God. Now she has no money for food or anything. This word I am telling you is true, those others have a lot of money. From a lot they gave just some for God. They put in a little for God. That poor bereaved woman put in much. She gave everything to God. ");
INSERT INTO engnna_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","In that country when it became springtime Jews from all directions were gathering together in Jerusalem. At that time they used to kill little sheep, one for one house, one for another house, like that. At night, when the moon had become big, they would eat it. At that time day after day, for eight days, they would eat flat bread, without rising (lit. 'something to make it light'). They used to do that at God's word, they would remember that earlier they were staying in the country of Egypt, they were in a bad way. After that God saved them, he took them from the country of Egypt. Spring came for them. About this time they were gathering together in Jerusalem to remember that time long before. In two days they would kill the sheep. Those Jewish lawmen wanted to grab Jesus secretly to kill him. ");
INSERT INTO engnna_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","They were saying to each other, “How shall we do it?” Let's not grab him in the middle of the remembering ceremony. Many people say God sent Jesus to be king for us, to be our boss forever. In this way people are talking. Let's take care of ourselves because of them, let's do it secretly so we won't be seen. They might make it bad for us.” Like that those lawmen were talking to each other. ");
INSERT INTO engnna_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus came to that town Bethany, he entered the house belonging to Simon the Leper. While they were eating a woman came to them with a little bottle. It was full, the scent was sweet, very good, with very much money she got it. The woman broke the top from that bottle, she poured that good sweet-smelling stuff on the head of Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Some people there became angry, they were saying to each other, “Why did she do that? She truly did badly. ");
INSERT INTO engnna_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","She should have given that sweet perfume for big money. She could have got big money. Then she could have given that money to poor people.” In that way they were talking. Truly they rebuked that woman. ");
INSERT INTO engnna_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","In response Jesus said to them, “Leave her alone. Why do you rebuke her? She did a good thing for me. ");
INSERT INTO engnna_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Poor people will always be here with you. Day after day you can give them money. I will not be with you a long time. I will stay a little while, after that I will die. ");
INSERT INTO engnna_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Truly she did a good thing for me. Today she poured this good sweet perfume on my body in order to do good for my burial (?) later. ");
INSERT INTO engnna_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","This word I tell you is a true, everywhere they will tell all people about me, they will tell them also this woman did this for me. They will remember this woman.” ");
INSERT INTO engnna_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","After that one man went to those leaders of the Jews. His name was Judas Iscariot. He was one of Jesus' men. He told the leaders, “I will take you to Jesus. You can grab the one that is pointed out.” ");
INSERT INTO engnna_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","After hearing his word they were happy, they said to him, “If you do that we will truly give you money.” After that Judas was waiting, he was thinking, “When can I take them to grab Jesus?” ");
INSERT INTO engnna_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","That day arrived when the Jews should kill a little sheep. On that day his men asked Jesus, “Where shall we go where we will get ready for us all to eat the sheep and flat damper?” ");
INSERT INTO engnna_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","He chose two of his men, he said to them, “You go, enter Jerusalem. A man with a water container will meet and join you. Follow him. ");
INSERT INTO engnna_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","He will enter a big house. You go in too. Inside you will see that person who lives there. Say to him, 'Our teacher says to you, “Where is the room you will make ready, in there I and my men will eat food, that sheep and flat damper?”' ");
INSERT INTO engnna_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","He will show you a large room. There you will get ready for us all.” ");
INSERT INTO engnna_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Those two went. They entered Jerusalem, truly it happened for them in the way Jesus said. There they prepared. ");
INSERT INTO engnna_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","In the evening Jesus and the rest of his men came. ");
INSERT INTO engnna_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","While they were eating food Jesus said to them, “This is a true word I am telling you, one of you without shame will take a word to the leaders, they will grab me. This one is now eating with us here.” ");
INSERT INTO engnna_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","They were sorry, his men became upset, One by one they were asking, “How? Is it me?” ");
INSERT INTO engnna_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus replied, “One of you will do that, he will dip his damper, that one is among us here. ");
INSERT INTO engnna_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I should die at God's word, in God's word they wrote about me like that long ago. For that man who does that, for that very person it will be very bad from now for ever. ");
INSERT INTO engnna_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","While they were eating Jesus picked up the damper, he said to God, “You are the one who gave us this damper. Thank you! You have helped us!” Then when he had broken it he gave them pieces, he said to them, “Take it, eat this food. This damper will remind you about my body. Soon others will truly kill my body. From now on whenever you eat damper remember my body, they killed me.” ");
INSERT INTO engnna_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","After that he picked up wine in a cup, he said to God, “You are the one who gave us this wine. Thank you! You have helped us!” He gave it to them, one by one they drank. ");
INSERT INTO engnna_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","He said to them, “This wine will remind you of my body. My blood will run in my death for many people. Truly God sent me to give a straight word to people. When I die I will truly leave for them this straight word from God. Whenever you drink this wine you will remember my blood, I am dying for many people. ");
INSERT INTO engnna_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","This is a true word I am telling you, I will not drink wine again in this country. Later God, my Father, will place me as boss for everyone. After that I will again drink with my people.” ");
INSERT INTO engnna_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","After that they sang a song for God, they went to that Hill with Olives. ");
INSERT INTO engnna_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","As they were going Jesus said to them, “Very truly you will leave me. You will run away scattered in different directions.” Jesus knew this from God's word. In that way long ago someone wrote in God's book, “God will kill the boss for the sheep, the sheep will all run away scattered.” Jesus knew that word was about him. God named Jesus the boss for the sheep, he named his working blokes like sheep. God spoke in this way, he would kill Jesus, all his men would run away. ");
INSERT INTO engnna_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Then Jesus told them, “After I die I will become alive again. I will truly go to Galilee, I will go ahead of you.” ");
INSERT INTO engnna_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter said to him, “The others might leave you, I will not leave you.” ");
INSERT INTO engnna_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus replied, “This is a true word I am telling you, this very night you will tell them three times, you will lie to them, 'I do not know him.' Like that you will speak to them. After that the rooster will call out twice. ");
INSERT INTO engnna_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter replied, I truly will not tell them that. They might kill me, in death I truly will not say that.” All Jesus' other men said that same word to Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","They came to that place Gethsemene. He said to his men, “You sit here. I will pray to God.” ");
INSERT INTO engnna_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","He took Peter and James and John, they went a little way ahead. Jesus became very upset. ");
INSERT INTO engnna_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Then he said to them, “My heart (lit 'stomach') is completely broken. I might die from being sorrowful. You stay here, stay awake, keep me company.” ");
INSERT INTO engnna_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","After that Jesus went a little way off from them, with sorrow he threw himself on the ground, then he was talking very intensely to God. He said to him, “Father, my own father, whatever you want that I will do. Truly some people want to kill me. I don't want death. You can prevent them. That is what I wish. I will just leave that. If you want others to kill me they will just kill me. I will not stop them.” ");
INSERT INTO engnna_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","After Jesus returned he saw those three sleeping. He said to Peter, “Simon Peter, why are you sleeping? Shouldn't you have stayed awake a little while?” ");
INSERT INTO engnna_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","He said to them, “Stay awake, pray to God. An evil spirit might lead you, you might do wrong. You still want to trust in God, truly you are weak. Therefore ask God to keep you safe.” ");
INSERT INTO engnna_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Then Jesus again went, again he was praying to God with the same words. ");
INSERT INTO engnna_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Again he returned to those three. Again they were asleep. They were sleepy. They were ashamed of themselves. ");
INSERT INTO engnna_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Again Jesus went, he prayed to God, again returning he said to them, “Are you still sleeping? That is enough! Wake up! That same person who used to follow me is pointing me out to evil people tonight. They will grab me. Look! Right now he is coming. Stand up! We will meet them.” ");
INSERT INTO engnna_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","While Jesus was talking to them, Judas came close. He was one of Jesus' men. Many people came with him, with weapons, knives and clubs. The Jewish lawment sent them. ");
INSERT INTO engnna_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas had earlier told the arresters this word: “I will hug one person. Grab him, take him carefully!” ");
INSERT INTO engnna_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","As soon as Judas arrived he went to Jesus, he called out “Teacher”, he hugged him. ");
INSERT INTO engnna_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","At that time they grabbed Jesus hard. ");
INSERT INTO engnna_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","One of Jesus' men who was standing there almost chopped a person with a knife. He cut only his ear. That man was a worker for the Big Leader. ");
INSERT INTO engnna_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Then Jesus asked them, “Why did you come with clubs and knives to grab me, to arrest me? I am not a fighter, not a thief. ");
INSERT INTO engnna_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Day after day I was teaching people in God's temple. You were right there. Why didn't you arrest me then? Earlier someone wrote about me in God's book, they would do that. Do that. I will not stop you.” ");
INSERT INTO engnna_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","After that his men left Jesus completely, they all truly ran away. ");
INSERT INTO engnna_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Another person, a young man was following Jesus. He covered his body with only one cloth. The others tried unsuccessfully to grab him in order to arrest him. ");
INSERT INTO engnna_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","He left his cloth, he ran away naked. ");
INSERT INTO engnna_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","The leaders and teachers and the elderly men were gathering together in a huge house. That house belonged to the Big Leader. Those who arrested Jesus took him to that house. ");
INSERT INTO engnna_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter was following them from a long way off, he also went in the gate of the Big Leader's house. That house was really big, rooms everywhere, with a yard in the middle. Peter entered that yard. There in the middle workers were sitting, they were men belonging to the Big Leader. They were warming themselves at a fire. Peter sat down with them to get warm. ");
INSERT INTO engnna_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Those leaders and bosses, the whole Big Committee, did not like Jesus. They were looking for people to talk, to lie, “I saw Jesus disregarding God's law.” ");
INSERT INTO engnna_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Many people with lies were bringing words about Jesus. Their stories were different, their words did not agree. ");
INSERT INTO engnna_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Some stood up, with this lie they brought a word against Jesus, ");
INSERT INTO engnna_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“He said, we heard him, 'God's Temple, men made it, truly I will break it, and in three days I will make another temple, people can not make one in that way.'” Like that they were lying. ");
INSERT INTO engnna_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","They also told differing stories. ");
INSERT INTO engnna_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","After that the Big Leader stood up, he stood in front of them. He said to Jesus, “They have been criticising you. You should respond to them. What will you say to them?” ");
INSERT INTO engnna_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus remained silent, he did not speak. Again the Big Leader said to him, “God will send to us his own child, to be a big boss for us. What about it? What do you say for yourself. Are you this one belonging to God?” ");
INSERT INTO engnna_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus replied, “Yes, I am that one. You will all see me, I will sit down near God, at his right side. After that you will see me, I will return from above in the clouds.” ");
INSERT INTO engnna_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","After that word the Big Leader tore his clothes. (The Jews when they were angry used to do that long ago.) He said to them, “You heard his bad word. Because of his word you know without a report. What will you say?” In response they all said to him, “Truly we should kill him.” ");
INSERT INTO engnna_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Some were spitting on Jesus. At that time they tied up his face with a cloth, with their hands they were hitting him. They were mocking him, “Who hit you?” At that time the Big Leader's men took him, With their hands they were hitting him meaning of one word - parlju - not understood. ");
INSERT INTO engnna_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","While this was happening to Jesus Peter was still inside, in the yard. A working woman came to him. She belonged to the Big Leader. ");
INSERT INTO engnna_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","She saw Peter near the fire, he was getting warm. After looking straight at him, she said to him, “That Jesus from Nazareth, truly you are from his mob.” ");
INSERT INTO engnna_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter lied, “I don't know him. I don't understand your word!” At that time as Peter was going to the doorway, to the gate, a rooster called out there. ");
INSERT INTO engnna_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","A woman near the doorway told the people standing there, “This man is one from Jesus mob.” ");
INSERT INTO engnna_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Again Peter denied (lit. 'blocked') it, “No!” Later those who were standing there said to him, “Truly you belong to Jesus. You are from Galilee.” ");
INSERT INTO engnna_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Then Peter told them, “I am speaking truly. God knows me. If I speak a lie God might hit me. This man you tell me about, truly I do not know him!” ");
INSERT INTO engnna_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","After that a rooster called out. When Peter heard it he truly remembered Jesus' word, “Three times you will tell them, you will lie, 'I do not know him'. Right after that a rooster will call out twice.” Jesus had already told Peter that. After Peter realised it he thought about it, he had done just that. His heart broke with shame, he was crying. ");
INSERT INTO engnna_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","After it became light the leaders and teachers and old men and the rest of the bosses gathered together in the Big Committee. They were talking among themselves. “Let us take Jesus to the Roman boss.” After that they tied up Jesus, they took him to the big Roman boss, his name was Pilate. He was from the country of the Romans, the Roman King made Pilate boss for the Jews. ");
INSERT INTO engnna_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate asked Jesus, “How about it? Are you the Jews' king?” Jesus replied, “You said that.” ");
INSERT INTO engnna_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","The leaders were falsely accusing Jesus, “He has been disregarding our law.” ");
INSERT INTO engnna_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Then Pilate again said to him, “Hear them, they have been accusing you. Will you reply?” ");
INSERT INTO engnna_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus was remaining silent, he did not answer him. Pilate was puzzled about him. ");
INSERT INTO engnna_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Before at Springtime after Springtime when the Jews were eating sheep and flat bread, Pilate would release a prisoner for them, he used to send out one for them. Whoever the Jews were wanting they would ask him for that one. That is the one Pilate would send out for them. ");
INSERT INTO engnna_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","After that many Jews now gathered to ask Pilate, “Release one prisoner for us.” ");
INSERT INTO engnna_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilate knew about them, the leaders looked at Jesus with jealousy, that is why they brought him to him. After that Pilate asked them, “Shall I send out for you Jesus, the King of the Jews?” ");
INSERT INTO engnna_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","The leaders were already talking to the Jewish people, they persuaded them to ask Pilate, “Release for us that other man named Barabbas.” ");
INSERT INTO engnna_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","That Barabbas was in prison, and some others like him also. Earlier they fought the Roman soldiers, they killed a few Romans. ");
INSERT INTO engnna_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","For this Barabbas they were asking, in reply Jesus asked them, “I might release that Barabbas, then what will I do to this other one, the man you name 'King of the Jews'?” ");
INSERT INTO engnna_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","They replied by calling out, “Nail him on a tree. By doing that kill him.” ");
INSERT INTO engnna_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Again Pilate asked them, “Why? What did he do wrong?” They were calling out very loudly, “Nail him on a tree.” ");
INSERT INTO engnna_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate wanted to please the Jews. After that he released Barabbas for them, he gave Jesus to the soldiers, he told them to hit him with a whip and to nail him to a tree. ");
INSERT INTO engnna_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","The soldiers took Jesus to their camp, they entered a very big house, they took him into the middle of the yard. They called the other soldiers, “Come here.” Then they removed his clothes, at Pilate's word they whipped Jesus with a whip. After that they were really mocking him. ");
INSERT INTO engnna_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","They got a red blanket, a really good one, they put it on him. From a tree they got thorny parts, they made a what's-it, like a head-ring, they put it on Jesus' head. ");
INSERT INTO engnna_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","After that they were mocking him, they were saying to him, “You are truly the King for the Jews.” ");
INSERT INTO engnna_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","With a stick they were hitting his head, they were spitting on him, after kneeling at his feet they were bowing down to him. They were doing that sort of thing to mock him, as if he was important for them. ");
INSERT INTO engnna_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","After they finished mocking him they removed the good blanket from him, they put on his own clothes on him. After that they put a big piece of wood on his shoulder for him to carry, they made him walk out to Golgotha, to nail him on the wood to kill him there. ");
INSERT INTO engnna_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","After going partway the soldiers grabbed a man, a stranger. He was from the country Cyrene, his name was Simon. He was the father of Alexander and Rufus. He was coming towards Jerusalem. The Roman soldiers grabbed him, they roughly forced him to carry that big piece of wood, that wood for Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","They arrived at Golgotha. (That name Golgotha in the Jews' language they call Skull.) ");
INSERT INTO engnna_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","There they tried in vain to give Jesus wine with medicine to drink. That medicine was for avoiding pain. Jesus did not drink it. ");
INSERT INTO engnna_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","26","The soldiers nailed him on the wood, they nailed his hands, his feet also. On a paper they wrote this word, “This is the King of the Jews”, they put it at the top of the wood near him. In the morning the sun was going upwards, early, they nailed Jesus on the wood. Then they played for his clothes, who would get them. ");
INSERT INTO engnna_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","They nailed two thieves on two other pieces of wood near him, on the right side and on the left. ");
INSERT INTO engnna_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","People as they were going backwards and forwards were watching close by, they were mocking him. They were saying thus to him, “You said you would break God's Temple, in three days you would fix it. ");
INSERT INTO engnna_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Come down from the wood, after releasing yourself save yourself. ");
INSERT INTO engnna_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In that way those lawmen also were talking, they were mocking Jesus. They were saying to each other, “He saved other people, He cannot save himself. ");
INSERT INTO engnna_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Before he was saying, 'God sent me. I am the King of the Jews.' When he comes down from the wood, right then we will believe in him.” The two thieves that were on the wood also were mocking Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Partway through the day the sky became dark. It was dark like that right up to late afternoon. After that Jesus spoke loudly, with words from long ago he asked God, “Eloi, Eloi, lama, sabachthani?” That word says, “God, you are my own father, why did you abandon me?” ");
INSERT INTO engnna_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Some who were standing there when they heard that word said, “Listen, he is calling that man from long ago, God's speaker, Elijah.” ");
INSERT INTO engnna_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","One came running, he soaked a cloth in wine, he put it on the end of a stick, he lifted it to Jesus' mouth, he put it to his lips (?) for Jesus to suck. He said to them, “Wait! Let us look! Perhaps Elijah will come to take him down from the wood.” ");
INSERT INTO engnna_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","After that Jesus really called out, he breathed once, he died. ");
INSERT INTO engnna_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Inside God's Temple in Jerusalem at the end that was God's only. Only the Big Leader from time to time will enter there, not other people. In front of that place of God's a big blanket was hanging. That used to block people from entering. As soon as Jesus died that blanket really tore without stopping, from above right down to the ground. ");
INSERT INTO engnna_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","At Golgotha that Roman boss soldier was standing near Jesus in front of him, he was watching him. After that having seen Jesus die in this way he said, “Truly this man was child of the One Above. ");
INSERT INTO engnna_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Many women were standing there, they were watching from far off. Earlier when Jesus was going around Galilee those women were following him, They used to cook food for him and things like that. Now they were watching from a long way off. Among them was Mary Magdalene and Salome and another Mary. (She was the mother of those two, James the Younger and Judas.) ");
INSERT INTO engnna_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","In that area was a man named Joseph. He was from the town Arimathea. He was a boss, an old man, a Big Committee man. Everyone used to speak well about him. For a long time he was waiting, he used say, “Soon God will send an important man, after he comes he will look after us well forever.” That same Joseph went bravely to that boss Pilate, he asked him, “Can I take the body of Jesus, can I put him in the grave?” It was already evening. Soon the sun would set. Then it would be Saturday, the Jews' day for God. According to their law they should not work. To avoid that they wanted to put the dead body of Jesus in the grave that evening. ");
INSERT INTO engnna_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wondering Pilate asked him, “Has he died already?” He called the boss soldier, he asked him, “Has Jesus been dead for a long time?” ");
INSERT INTO engnna_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","That boss soldier told him, “Yes, he is already dead. Then Pilate told Joseph, “Yes, you can take his dead body.” ");
INSERT INTO engnna_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph went to the store, he bought a long white cloth, a very good one. He took down the body of Jesus from the wood, with the cloth he tied it up, he covered the whole body. Then he took it to a cave. They had already cut that cave in soft rock for a grave. Inside there he put the body of Jesus. Then he pushed a big stone to the cave, truly he completely covered the doorway. ");
INSERT INTO engnna_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Two women were watching, those two, Mary Magdalene and the other Mary. They were watching Joseph take and put Jesus in the cave, they saw him there. ");
INSERT INTO engnna_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","On Saturday after sunset the Jews will work again. At that time when the sun was set Mary Magdalene and Salome and the other Mary went to the store. They bought good ointments, very good smelling things, to rub on the body of Jesus. ");
INSERT INTO engnna_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","On Sunday they went at first light to that cave. Just as the sun was rising they arrived at that cave. ");
INSERT INTO engnna_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","As they were going they were talking to each other, “That covering stone at the door of the cave, we can't move it, it is a really big stone. Who will move that stone for us?” As soon as they arrived they looked, they saw someone had already moved that stone. ");
INSERT INTO engnna_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","After that they entered the cave, they saw a young man, he had white clothes, he was sitting on the right side. The women were afraid. ");
INSERT INTO engnna_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","He said to them, “Don't be afraid! Truly you are looking for the body of Jesus from Nazareth, that one they earlier nailed to the wood. After he died God truly made him alive. He is not here now. Look! This is where they put him. He went from here. ");
INSERT INTO engnna_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","You go, tell this word to Peter and the rest of Jesus' men, 'He will go ahead of you to Galilee. That is where you will see him in accordance with his word truly.'” ");
INSERT INTO engnna_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Those women went outside, they ran from the cave. They were very frightened, they were trembling and they were really puzzled. With fear they did not talk to others. (Another person wrote this word, Jesus after dying is alive, he appeared to his people.) ");
INSERT INTO engnna_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","On Sunday morning, before it was light, Jesus again became alive, he rose up. He appeared to Mary Magdalene. Earlier Jesus sent out 7 evil spirits from her. ");
INSERT INTO engnna_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Now after she saw Jesus Mary went to his people. They were mourning together. She said to them, “Jesus, our Boss, did not stay dead. After dying he became alive, I saw him.” They did not believe Mary. They ignored her word. ");
INSERT INTO engnna_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","In the afternoon two others went away from Jerusalem. Already they were believing in Jesus. Now Jesus appeared to them. Those two thought he was someone else, they did not recognise him. ");
INSERT INTO engnna_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","After that, after learning about him, they returned to Jerusalem, they told the rest of his people, “Jesus is truly alive. We saw him.” They just heard those two, they did not believe them. ");
INSERT INTO engnna_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","After that, while they were eating, Jesus appeared to his 11 men. Truly he rebuked them. Other people after seeing Jesus alive had told them, still they were behaving stubbornly, those 11 men did not believe them. That is why Jesus rebuked them. ");
INSERT INTO engnna_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","After that he said to them, “When you go around in all countries tell all people God's good word. ");
INSERT INTO engnna_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Many people will believe in me. Someone should baptise them. After they die God will keep them alive forever. Some will not believe in me. After they die, God will send them right away forever. ");
INSERT INTO engnna_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Those who believe in me will drive out spirits from people in my name. They will speak other languages. ");
INSERT INTO engnna_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","They might accidentally pick up a snake, truly that snake will not kill them. They might accidentally drink something poisonous (lit. 'a killing thing'), truly that bad thing will not harm them. They will put their hands on sick people, they will ask God to heal them, truly God will make the sick ones well. That is what believers will do. After that people will learn from them I work continually with believers.” In that way Boss Jesus talked to them. ");
INSERT INTO engnna_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","After that God took him upwards, he placed him at his right side very close to him. At that time he made Jesus a very big boss for all people everywhere. ");
INSERT INTO engnna_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","As Jesus' people were going they were telling people everywhere God's good word. Boss Jesus was continually working with his people, to show people their word was truly right. ");
INSERT INTO engnna_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesus was telling the people about God. Many were there listening to him. Bad people also were coming to him to listen. ");
INSERT INTO engnna_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","In the crowd in the many' some teachers of the Jews' law were there among them. Others also were there, they called themselves Pharisees. All those Pharisees and teachers were watching Jesus. They were saying to each other, “This Jesus is talking with the bad people, and he's eating food in their camps. That's bad.” ");
INSERT INTO engnna_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesus knew about them what they were saying to each other. Therefore he told them this story to teach them. ");
INSERT INTO engnna_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Listen to this! Maybe one of you may have 100 sheep way out in the bush. Then perhaps one sheep may wander off and get lost. What will you do? You will leave the other 99 sheep in the bush. Then you will search carefully for the one sheep that ran away. ");
INSERT INTO engnna_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","When you find the one that got lost, you will become very happy. You will pick up that one sheep that ran away. Then you will carry it on your shoulders, you will return to your camp. ");
INSERT INTO engnna_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Then you will call out to all your people, “Come here! This sheep of mine ran away into the bush. Truly I have found it. Now I am very happy. Let us all be happy.” ");
INSERT INTO engnna_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Then Jesus said to them, “Yes! You are very happy after picking up your sheep. Like this God up above and his angels will be happy after one person after doing bad (things) returns to God. They are happy about the 99 good people who follow God. Truly they will be very happy about one person who after doing bad turns around in his tracks and returns to follow God.” ");
INSERT INTO engnna_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Then Jesus told them this other story. “Maybe a woman might have 10 coins. Then perhaps she will lose one. What will she do? She will light the lamp, she will sweep the house, she will search carefully in every direction. ");
INSERT INTO engnna_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","When she finds (the coin), she will call to the other people, “Come here! That money that I lost, truly I have found it! Now I am very happy. Let's all be happy!” ");
INSERT INTO engnna_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Then Jesus said to them, “Yes! Like this God and his angels will be happy about one man returning from his bad ways.” ");
INSERT INTO engnna_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Then he told them this other story. “Yes. Previously there lived a man who had two sons. ");
INSERT INTO engnna_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","One day the youngest one asked their father, “Father, when you die we (du.ex) will get your country. Share this country with us now, give me my share now.” Then truly the father divided it for those two. ");
INSERT INTO engnna_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Then the youngest one gave his country to others for money sold it, left home, and went far off to another country. In that country he was making mistakes with all that money. He was drinking, he was gambling playing, truly he messed up his life for himself with all his money. ");
INSERT INTO engnna_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Then he was puzzling hard, with no money. Then at that time in that country there was no rain, the trees and the grass were dying. The people in that country were staying without food. That youngest one was hungry. ");
INSERT INTO engnna_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Then he was thinking, “How will I get anything to eat? I will ask them for a job. Then truly they will give me food (in exchange) for work.” He was working for a local person of that country. That local person told him, “Look after my pigs here, and give them food.” ");
INSERT INTO engnna_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Then he was looking after the pigs. His boss didn't give him anything to eat. He was very hungry for the pigs’ rubbishy food. ");
INSERT INTO engnna_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","At last he realized. “My father’s work men are eating good food till they're full, and I here am starving, from starvation I might die. ");
INSERT INTO engnna_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","I will go, I will return to my father, I will tell him, ‘Father, I have done wrong. I have disobeyed God and I have disobeyed you. ");
INSERT INTO engnna_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Don't call me your son, just tell me I will be your worker, I will work for you.’#” ");
INSERT INTO engnna_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A short time later went, he returned to his father's place. His father saw him from a distance. He felt sorry for him, he ran to meet his son. He hugged him, and they cried for each other. ");
INSERT INTO engnna_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","The son told him, “Father, I have done wrong (things). I have disobeyed God and I have disobeyed you. Don't call me your son.” ");
INSERT INTO engnna_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","In response the father didn't listen to his son. He told his workers, “Quick! Get some nice clothes for him, put them on him, and put shoes on his feet. Then put a ring on his finger. ");
INSERT INTO engnna_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Then get the bullock, the fat one, kill it, and after you've killed it, cook it. Then we will all eat for my son. We'll truly be happy! ");
INSERT INTO engnna_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","I thought my son was as good as dead for ever. He’s not! He’s alive! He went far away. It was as if he had left me for ever. Not so! He has returned to me still alive!’ Then they were happily singing and dancing. ");
INSERT INTO engnna_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","The eldest was working somewhere far away. Then after work he was returning home. As he was getting close (to the camp) he heard them singing and dancing in the camp. ");
INSERT INTO engnna_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Then he called out to a man, one of his father's working men. (He asked him,) “Why are they happily singing and dancing?” ");
INSERT INTO engnna_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","In reply that man told him, ‘Your younger brother returned today. Your father told us, “This my son returned to me. Kill the bullock, the fat one.”#’ ");
INSERT INTO engnna_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","The eldest son got sulky and didn't go to the house to meet his brother, he stayed outside a fair way off. Then his father went out to him, he begged him, ‘Come inside the house.’ ");
INSERT INTO engnna_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","The eldest one answered his father sulkily, “I have truly stayed with you always, I have worked for you through the winter and the summer. I have always obeyed you listened for your word. In return you didn't give me a little goat. I and my fellows could have (but didn't) eat an animal with happiness. No indeed! You didn't give me an animal to kill and to eat. ");
INSERT INTO engnna_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I am not like this youngest one of yours, (that) you gave your country to. He got money for that country, he messed up made a mistake with all his money on women. Now when he returns home you kill the fat bullock for him. ");
INSERT INTO engnna_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","His father told him, “Son, you have been with me, I your father am looking after you. Everything here is yours. I am holding it all for you. Truly when I die all of these things will be yours. ");
INSERT INTO engnna_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I thought this younger brother of yours was as good as dead for ever. He's not! He’s alive! He went far away. It was as if he had left me for ever. Not so! He has returned to me, still alive! For that reason it is right that we should all be happy.” ");
INSERT INTO engnna_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Abraham said to him...there is a very big gap between us and you. For those of us who might want to go to you fellows, there is no way, truly it's impossible to do that. Also for those of you who might want to come to us, there is no way, truly it's impossible to do that. ");
INSERT INTO engnna_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","32","“Simon, Simon, Satan asked God about you men, so that he can test you hard. I have begged God for you, Simon, that you should believe God continually. When you have changed direction to return to me in order to follow me, teach those others also they should follow me properly.” ");
INSERT INTO engnna_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A person's body is from his mother and father. His spirit is from God's Spirit. ");
INSERT INTO engnna_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Human beings are very much in God's feelings. Because of that he gave his very own male child for them, so that the ones who habitually believe in him should not become worthless dregs, but should live for ever in his camp. ");
INSERT INTO engnna_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","He did not send his son here for what's-it, to banish them from his presence for ever. He sent him for us, to rescue everybody! ");
INSERT INTO engnna_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Whoever believes in God's Son, he will not send him away. Everyone who does not believe in that sort of way stays in a really bad way forever, because they reject God's very own son. ");
INSERT INTO engnna_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","This is how it works: The Light of God has come to us, BUT / in contrast, opposite of what one would expect but men love darkness, they want to do evil. ");
INSERT INTO engnna_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Evil-doers hate the Light of God, they do not come to the Light of God, because of shame about the bad things they have done. ");
INSERT INTO engnna_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Everyone who habitually does good will come to the light of God, and others will see how God is working in and through them. ");
INSERT INTO engnna_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus said to his men, “Don't be upset! Believe in God, my Father above. Believe in me too. ");
INSERT INTO engnna_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","My Father has many camps in his country. I truly told you. ");
INSERT INTO engnna_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","I will go ahead of you to the Father's place. There I will prepare a camp for you. Then I will come back and take you all to that place, to my Father's country, so that you can stay with me forever. We will all gather together in my Father's country. ");
INSERT INTO engnna_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I am going to that place. You know the road to that place.” In that way Jesus spoke to them. ");
INSERT INTO engnna_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","One of them was what's-his-name, Thomas, and he didn't know what Jesus was talking about. He said to Jesus, “Hey boss, where are you going? We don't know about that place, and we don't know the road to that place. How can we follow you to that place?” ");
INSERT INTO engnna_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus said to them, “I myself will take people one by one by the hand to the Father. I myself will teach them the true word about the Father. I myself will make them really alive forever. My words are true: no person will go to the Father without me. We two will go to the Father together.” ");
INSERT INTO engnna_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","8","...Jesus said to his men, you cannot do anything without me. Perhaps someone might leave me by going in a different way, he will become like a dry branch. Branches like those, people gather in a heap to burn. Stay joined to me and do according to my word carefully, as a result of doing that you can ask God for anything, whatever it is, he will do that very thing. My people are good, they continually do good. When people see it truly they will praise my Father. ");
INSERT INTO engnna_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","...we all hear them, they are speaking in our own words. ");
INSERT INTO engnna_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","From now on truly you must all think and do with a different feeling, get right with God; as a result of doing that he will clean you from the bad things. ");
INSERT INTO engnna_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","When Jesus christ died, it's like we also died; when they put him in the grave, it's like we also went into the grave. When he was raised to life by the Father, we also came to life joined with Jesus Christ. (Truly the Father is the expert for everything, nobody can stop him.) It became like that for us when someone baptised us. That's the way God did it for us, so that we can become different and stay in a really good way. ");
INSERT INTO engnna_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","People always do bad things, in exchange they will die. The people who are joined with Lord Jesus Christ our boss in exchange will stay in a good place. God will keep them alive forever. ");
INSERT INTO engnna_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","8","When a man pays attention to his own self-centred spirit, he becomes an enemy of God. He does not pay attention to God's word, it is too hard for him! Those ones who listen to their own self-centred spirit cannot please God. ");
INSERT INTO engnna_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Let us live the proper way, so that all can see clearly that we are without fault. Don't do anything shameful, don't get drunk, don't over-eat, don't sleep with others' spouses, don't have sex with others, don't fight, don't be jealous with others. ");
INSERT INTO engnna_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","PTE: You might eat some meat or drink some wine or things like that, you know it is alright, it is not wrong for you to do like that. Another person might see you do like that, he might think it is wrong to do like that, he might want to do like that, he might do like that just because he saw you do it. While ever he thinks it is wrong to do that, it is indeed wrong for him. God would punish him for doing it. Lest that happen to him, you should always do the right thing, you should leave doing things that make trouble for other people. Perhaps they are good things, that other person thinks they are bad. You should leave them. Then that other person will not do what he thinks is a bad thing, he will not get into trouble because of you. ");
INSERT INTO engnna_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","...Some people call themselves Christians, but they are still doing wrong. Maybe they are always looking for illegal sex, maybe greedy, maybe they worship carved representations of spirit beings, maybe they are false criticisers, maybe drunken fellows, maybe thieves. Don't join with people that do those sorts of things, truly don't eat with them. ");
INSERT INTO engnna_vpl VALUES ("C16_9","076_6_9","1CO","6","9","11","Truly you know evil-doers will not get into God's country. Don't trick yourselves. Some people are always looking for illegal sex, some worship carved representations of spirit beings, some sleep with other people's spouses, some men have sex with each other, some are thieves, some are greedy, some are drunks, some are false criticisers, some steal with violence. The ones who do those sorts of things will not get into God's country. Some of you used to be like that, now you're different. The Lord Jesus Christ and God's Spirit have separated you from evil, they have chosen you for God, they have joined you in a good way with God. ");
INSERT INTO engnna_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","I will talk to you, you Christians. Some will say to you, “Truly you will listen to Moses' words, long ago he put it down for the Jews. You must do according to his word. If you don't, you don't belong to Jesus Christ.” They will talk like that to you. Their word is a lie. Jesus came from God to rescue us. You believed in him. That (emphatic) is how you became his people. You didn't become Jesus' people by the hearing of Moses' word. Look after yourselves for fear of deception! Don't say to yourselves, “We belong to Jesus Christ, he forgave us. We won't pay attention to Moses word. Now we can boldly do whatever we want to do!” Do not talk like that! From talking like that, you might become really greedy for food, for grog, for women, for men, for other things of that sort, you might hit each other, you might steal, you might do other bad things. Do not give yourselves to do bad things. You should really never do like that! You belong to Christ. Because of that from now on truly you should not do anything bad, you will always do in accordance with Christ's word, you will really love him, from doing that you will really look after each other. ");
INSERT INTO engnna_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","God put down different kinds of laws for us. He gave us these laws so that we will all stay in the right way, we will look after others, we won't do wrong for them. He put one really big law for us all: This one law holds all the other laws from God: “You really look after yourself. Like that you should look after everybody as well, like how you look after yourself.” ");
INSERT INTO engnna_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","I've thought about you all that you might go a wrong way. What then? Are you fighting each other over words? Are you being rude to each other? Look after yourselves! From doing those bad things you will make each other sheer left-over rubbish. ");
INSERT INTO engnna_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","This is a really important word I tell you: You should listen to God's Spirit. Keep paying attention to him, keep on doing according to his word. From doing that you won't do bad things. Keep on saying to yourselves, “Truly I won't please myself, I will please God (emphatic).” ");
INSERT INTO engnna_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","You all knowabout people, we have a self-centred spirit, we still want to please ourselves. We want one thing, a bad thing, God's spirit wants a different thing, a good thing. He wants good things, appropriate things. All who listen to God's Spirit he will lead them in the right way, for appropriate things, he will prompt their feelings lest they do bad things. ");
INSERT INTO engnna_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Pay attention to God's Spirit. From doing that, you won't have to think about Moses law. ");
INSERT INTO engnna_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","Many people will not pay attention to God's spirit. Truly they are ignorers. You know what people are like, as soon as we are born all our spirits are continually self-centred, we always want to do bad things, we do bad things all the time. Because of that some want to have illegal sex with others, some men have sex with men, some women have sex with women, some don't restrain themselves in the right way. ");
INSERT INTO engnna_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","Some carve false things like spirit beings, they praise those things from their hearts, they do bad things to others with magic, they hate each other, they quarrel with each other, they become jealous of each other, they get angry quickly, they get overly proud, they separate from each other, they continually stay with their own mob, ");
INSERT INTO engnna_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","they want other people'sbelongings, they get drunk, when they are drunk in a mob they get silly, they do bad things, they do all sorts of things like that. They continually do things like that with their self-centred spirit. Those ones that do those things will not live with God in his country. That's a true word. I have already told you seriously, now I am reminding you again: The ones who do those sorts of things won't stay with God. ");
INSERT INTO engnna_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Some people will still continually pay attention to God's Spirit. He will make them think another way, a good way. He prompts people to love each other, he makes them happy, he makes them calm, he makes them patient, he makes them good people, he makes them reliable, ");
INSERT INTO engnna_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","he makes them gentle with people, they will restrain their own self-centred spirits. What do you think? What person will say, “To do things like that is bad. Do not do things like that!” There is no way that that person will talk like that! ");
INSERT INTO engnna_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Those ones that belong to Christ Jesus will continually say to themselves, “My self-centred spirit wants to do bad things. No way! I will leave bad things. I won't be a self-centred person. I will only pay attention to God's Spirit!” ");
INSERT INTO engnna_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Yes! The Holy Spirit made us alive. Therefore we should say to him he will be our boss. ");
INSERT INTO engnna_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","We should not become proud, we should not annoy each other, we should not become jealous of each other. ");
INSERT INTO engnna_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Fellow Christians, you know what God wants. Maybe one of the Christians will do something bad. You must pay attention to the Holy Spirit, after that you will show that Christian the good way, gently. You will do it thoughtfully – you will not do like that one did. ");
INSERT INTO engnna_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","You should have pity on those who have problems. When you do that you will do according to Christ's word. ");
INSERT INTO engnna_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","You should not become self-opinionated. Perhaps some small/unimportant people will say to themselves, “I am big/important.” When they say that they are deceiving themselves. Truly they are only small/unimportant. ");
INSERT INTO engnna_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","You should continually say to yourself, “How was it? Did I do that in accordance with God's word?” Perhaps it was good. Then you will be contented. Do not say to yourself, “Those others were doing badly, I'm doing fairly well.” ");
INSERT INTO engnna_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","You should do your own (work) properly. That's what God wants. Don't look at others in order to criticise. ");
INSERT INTO engnna_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Perhaps a person will teach you about God's word. In response you should give food and money and clothes and those sorts of things to your teacher. ");
INSERT INTO engnna_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Listen! A person might try to trick God. He might say, “God doesn't know about me.” He is only deceiving himself! He is making a big mistake. God continually watches him, he will make it hard for the ignorer. ");
INSERT INTO engnna_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Perhaps a person will do bad. In response God will do bad for him. Perhaps a person will do good. In response God will do good for him. Perhaps a person will keep on doing things with his self-centred spirit. In response when he dies God will send him right away forever. Perhaps a person will continually pay attention to the Holy Spirit. In response when he dies God will put him close, he will stay there with God forever. ");
INSERT INTO engnna_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Therefore without getting sick-and-tired of it we should continually do good. After doing like that at last God will do really good for us. ");
INSERT INTO engnna_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Therefore we should do good to all people, we should do really good for believers. ");
INSERT INTO engnna_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","Don't get drunk with wine, it will make you silly, you will do bad things without thinking. Better, give yourselves to the Holy Spirit, so that he can steer you in a proper way. ");
INSERT INTO engnna_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Men truly look after their bodies. Truly in that way they should look after their wives. Whoever looks after his wife is looking after himself. ");
INSERT INTO engnna_vpl VALUES ("H11_1a","082_1_1a","1TH","1","1a","1a","This word is from me Paul, and from what's-his-name, from Silas and from Timothy also. We are writing to you believers in that (distant) town, in Thessalonica. You all belong to God and to Jesus. That God is our Father and that Jesus Christ is our Boss. You all belong to those two. This word is for all of you. ");
INSERT INTO engnna_vpl VALUES ("H11_1b","082_1_1b","1TH","1","1b","1b","We ask God our Father and Jesus Christ our Boss also, that those two will take good care of you and make your feelings peaceful. ");
INSERT INTO engnna_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","We keep on asking God he will do good to you all. We remember that you believe in the Boss Jesus Christ, because of that you always do things in the right way. You love God, because of that whatever you do you continually do it the right way for God. You believe the Boss Jesus will come from above, then he will take you to God's country. Because of that you continually follow him. Others made it bad for you, (but) you did not back away. We remember what you are like. Because of that we continually say to the Father Above, “Thankyou!” ");
INSERT INTO engnna_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Yes, we know about you, God loves you and he chose you to become his (people). ");
INSERT INTO engnna_vpl VALUES ("H11_5a","082_1_5a","1TH","1","5a","5a","We came to you, we told you, “God sent Jesus to help you/take your part.” You believed not just as a result of our word. No! God’s Good Spirit came to you, he told you, “That is a true word!” You believed that word. Because of that we know about you that God chose you to become his people. ");
INSERT INTO engnna_vpl VALUES ("H11_5b","082_1_5b","1TH","1","5b","5b","At that (time) when we were with you, you know about us, we did whatever we did so you will do in that same way like us. ");
INSERT INTO engnna_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","As soon as you heard us, you also did like we did and like our Boss Jesus did, whatever you did you did properly. Others keep you in a bad way, unsuccessfully they prevent you from believing in him. You keep on believing in him gladly. The Good Spirit keeps you happy. ");
INSERT INTO engnna_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Because of that other believers in those two countries, in Macedonia and in Achaia, they understood that they should become like you. ");
INSERT INTO engnna_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","That word about the Boss Jesus spread out from you to all the people in Macedonia and Achaia. They weren't the only ones that heard that word, others also in countries everywhere heard that word, they all know about you, you believe in God. We did not tell them about you, they already knew about you. ");
INSERT INTO engnna_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","People in countries everywhere talk about you. They know about you, you listened to our word, because of that you abandoned your deceptive dreamtime-being-like ones and you wanted very much to become God's people. God is the one who truly lives forever. ");
INSERT INTO engnna_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Yes, you believe in that one who lives forever, you are waiting for his son Jesus. He made Jesus alive after death. Now you are waiting for Jesus to return from the sky. He is the one who took the place of/helped us believers. Because of that God will not look at us with anger. ");
INSERT INTO engnna_vpl VALUES ("H12_1","082_2_1","1TH","2","1","2","Yes, you know about that time we came to you, we did not tell you God’s really good word in vain. Truly you believed it. Previously in Philippi some people looked at us with anger, they beat us and were keeping us in a bad way. You know about that. Then we left Philippi, we came to you in Thessalonica. At that time we told you God's word. Some people did not listen to us. They tried in vain to stop us speaking. We were not afraid of them, God made us firm to speak. ");
INSERT INTO engnna_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","We were telling you that true word, we did not just lie to you so you would give us money or whatever thing. No. We always kept on doing the right thing. ");
INSERT INTO engnna_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","God continually watches us, he knows whatever we are thinking about. He himself chose us to take this true word of his to you. Because of that God is the one we want to please, not people. ");
INSERT INTO engnna_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","We did not praise you so that you in response might speak well about us. We were not greedy for money and whatever other things. ");
INSERT INTO engnna_vpl VALUES ("H12_6a","082_2_6a","1TH","2","6a","6a","We did not ask you, or others either, to praise us. God knows about me that I am speaking the truth. ");
INSERT INTO engnna_vpl VALUES ("H12_6b","082_2_6b","1TH","2","6b","7","We are the ones who told you that word about Jesus Christ. He himself sent us to you. Because of that we could have asked you (but did not) to look after us well, and to give us money. No! We did not want to do like that. We (emphatic) looked after you well. You know how a mother cares for her little child, in that sort of way we became for you. ");
INSERT INTO engnna_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","We truly love you, we continually think about you. For that reason we did not just give you that good word from God. We also made you like our very own relatives. ");
INSERT INTO engnna_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Yes, while we were telling you the word from God, we were also working for money for food. We did not ask you for food. We did not eat your food. We worked hard in the day and in the night also to get our money. You know we used to do just like that. ");
INSERT INTO engnna_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","At that time when we were living with you, we continually did things properly and without badness in order to please God. You know about that, God knows also, that's a really true word. ");
INSERT INTO engnna_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","You know how a father persuades his child to do things the proper way, we became sort of like that for you. We continually told you, you should live in a proper way to please God. He himself chose you. Later he will take you to his truly good country. Because of that you should do everything properly in order to please him. ");
INSERT INTO engnna_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","As soon as we told you that really good word you happily heard/obeyed it. You thought, “This is God's (emphatic) word, not just Paul's.” It really is God's word. You believed that word, from doing wrong you turned to a different way, now you are going in the right way. Because of that we continually say 'Thankyou!' to God. ");
INSERT INTO engnna_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","As soon as you believed God's word your fellow countrymen became angry with you. You became like others, those believers in what's-its-name, in Judea, their own countrymen became angry with them, they tried in vain to prevent them following Jesus Christ. In the same sort of way your own countrymen tried in vain to prevent you following him. ");
INSERT INTO engnna_vpl VALUES ("H12_15","082_2_15","1TH","2","15","16","Many Jewish people rejected God's word. Long ago from time to time some of them killed the messengers who brought them God's word. A long time after that some killed Jesus our Boss. Now in these days others banished us from your town. They always try in vain to stop us telling the true words about the Boss Jesus to you or to anyone else. They call themselves “Jews”, they call everyone else “Gentiles”. We (emphatic) want all those who-are-they, those Gentiles, to know about the Boss Jesus and to believe in him. God will save all the ones who do that. These Jews are opponents for everybody else. They don't want other Jews or Gentiles to hear the words about the Boss Jesus. They are evil-doers. Therefore God is angry with them. At last he will hit them very hard. ");
INSERT INTO engnna_vpl VALUES ("H12_17","082_2_17","1TH","2","17","18","Yes, those Jews sent us right away from your town. After that we continually thought of you, truly we love you. We were wanting to return to you, we were lonely for you. I, Paul, several times tried to return to you, (but) Satan was blocking me. ");
INSERT INTO engnna_vpl VALUES ("H12_19","082_2_19","1TH","2","19","20","Yes, we were wanting very much to return and see you. Previously when we told you about the Boss Jesus you believed in him, you left off doing badly, you became those characterised by good. Because of that you made us joyful/really happy. Later Jesus our Boss will return from the sky. Then we and you will be standing together in one group, we will be very close, he will see us together. We will know about you that we did not tell you God’s really good word in vain. Because of that we will be very happy. ");
INSERT INTO engnna_vpl VALUES ("H13_1","082_3_1","1TH","3","1","2","I did not forget you, I was feeling worried about you. I kept wanting to go to see you. At last I sent Timothy to you. Timothy is one of us, he is God's messenger, he takes Jesus Christ’s message to people. I told him, “I will stay here in Athens. You go back to see the Christians in what's-its-name, in Thessalonica.” I sent him to you to persuade you strongly, so that you will believe in the Boss Jesus with firm/steady hearts and without fear all the time. ");
INSERT INTO engnna_vpl VALUES ("H13_3","082_3_3","1TH","3","3","4","Others will put you in a bad way and they might frighten you, they might make you go in a different direction from following the Boss Jesus. When we were staying with you we told you they would do like that to you. Now you know we told you a true word. ");
INSERT INTO engnna_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Yes, I was thinking about you with worry. I was thinking, “Perhaps Satan has tempted them, as a result of that maybe they stopped following the Boss Jesus. Maybe we told them God's word for nothing.” That is what I was thinking. I wanted to know about you. That is why I sent Timothy to you to look and see. ");
INSERT INTO engnna_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Now Timothy has returned to me. He told me you are still trusting God and you are caring for each other well. You remember us kindly and you want to see us. Like that we also want to see you. ");
INSERT INTO engnna_vpl VALUES ("H13_7","082_3_7","1TH","3","7","8","Yes, Timothy told me the message, he made me very happy. Here others were putting me in a bad way/making it hard for me. They made me upset. Now I know about you, you are still following the Boss Jesus. Because of that I am happy for you. ");
INSERT INTO engnna_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","We talk to God about you constantly, we tell him we want to see you again, we will teach you (more) about God. In that way you will really know about him. ");
INSERT INTO engnna_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","For that very reason we ask God our Father and Jesus our Boss, “Perhaps you might take us safely to return to the people in Thessalonica.” ");
INSERT INTO engnna_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","We ask the Boss Jesus for you, you will really take good care of one another with love. We really love you, in the same sort of way you should with intensity love and take care of each other and other people also. ");
INSERT INTO engnna_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","We want you to stay strong in your spirits, and to really stay without evil. In that way we ask the Boss Jesus to make you strong. When he returns from the sky with his angels you will be without badness in the presence of God our Father. ");
INSERT INTO engnna_vpl VALUES ("H14_1","082_4_1","1TH","4","1","2","Yes, you know those words we told you. Those words came from Jesus our Boss. We taught you what you should be like in order to please God. You listened to us. Now we are telling you from the Lord Jesus: Keep on doing the right thing according to our words. ");
INSERT INTO engnna_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","God wants you to be like this. You should become like him, without evil. You all should stay only with your own spouses only, don’t desire the spouse of another. No indeed! ");
INSERT INTO engnna_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Some people are very ignorant of God, they are always wanting other people’s women. Don't be like those unbelievers. No! Amongst your people you (pl.) should stay (each) only with your own spouse. You should look after him/her without anger/fighting and be kind to him/her. ");
INSERT INTO engnna_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Maybe one of you might steal the wife of another man. God will be angry with that thief. God is the one who will punish those who do like that. We already seriously told you these words. ");
INSERT INTO engnna_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","God told us Christians to stay without badness like him, we should not be like others who are sexually promiscuous. ");
INSERT INTO engnna_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Some disregard/ignore this word. Those disregarders are ignoring us, they are ignoring God himself also. God is the one who gave you his Good Spirit, because of that (emphatic) you should not ignore him. ");
INSERT INTO engnna_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Yes, God has already told you to care for each other well/with kindness. We won't write in this letter about that, you already understand about that. ");
INSERT INTO engnna_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Yes, you are taking care of the Christians well in your country Macedonia. Now we tell you, keep on doing like that. ");
INSERT INTO engnna_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Don't go to the camps of others to criticise, a troubler of other people. As a result of that sort of thing they might get upset and angry. Always work hard. That's exactly what we have already told you before. ");
INSERT INTO engnna_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","You should work for your own food money. If you do that you won't go begging to other people for theirs. People will say about you that you live in a good and appropriate way. ?? Should we at some stage standardise on the English words “Christians” or “Believers”, or is it better to retain the “yijalmarta jinakatarrangu”. ");
INSERT INTO engnna_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Yes, listen to this word about believers who have already died. We want you to know about them. Then you will not be continually sad for them. Some people are ignorant of God, because of that they stay sad continually. Do not be sad like them. Those ones do not trust in the Boss Jesus, and they are very sad about those who have died. ");
INSERT INTO engnna_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Jesus died. After that God made him alive again. We all believe that word. Therefore we believe this other word also: later God will send Jesus from the sky to get the believers that have already died. The Boss Jesus will take them, the believers, to the Father. ");
INSERT INTO engnna_vpl VALUES ("H14_15","082_4_15","1TH","4","15","16","We tell you this word from Jesus our(incl) Boss. He will return from the sky to get all the believers, he will take us to the Father's country. He will take the ones who are still alive and the ones who have died also. Those ones who are still alive will not go up ahead to the sky first. No! It will be like this: Our Boss himself will come down from the sky and he will call out loudly to the believers who have already died. A big angel will also blow through a big thing, thay call it a trumpet. With that thing he will blow hard. Those who are dead will hear that trumpet and the Boss Jesus when he calls. As a result of that those dead ones will become alive. ");
INSERT INTO engnna_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","After that those other believers who are still alive he will cause to go upwards. He will gather us all together up in the clouds, the ones who have already died and the others also. In that very way we will all be with Jesus our Boss for ever. ");
INSERT INTO engnna_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Therefore you should continually make each other brave and happy with this word. ");
INSERT INTO engnna_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Maybe some people are thinking, “When will the Boss Jesus return to get us? When will he hit those who habitually do evil?” Our Boss will come very suddenly/quickly. You already know for sure about that word. I won't teach you about that with this letter. When will he come? About that we are all ignorant. ");
INSERT INTO engnna_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","We already told you that about him, he will come suddenly/quickly indeed. ————————————————- Many people will not be expecting him. Yes. A thief might go to another person's camp in the night. Those others are ignorant about when he will arrive in their camp. They will not wait alertly for that thief. In that same sort of way the Boss Jesus will suddenly come very close for us, many people will not be expecting him. ");
INSERT INTO engnna_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","At that time they will say, “Everything is good. Others will not hit us with anger.” They will be talking in that sort of way, at that very time the Boss Jesus will appear. He will hit them really quickly, he will hit them really hard, they will not be able to hide from him. You know about pregnant women giving birth, it is very painful, they cannot stop the babies from being born. It will be like that for people, the ones who are distracted/not paying attention, when the Boss Jesus comes they will not be watching for him. They will try in vain to hide from him. ");
INSERT INTO engnna_vpl VALUES ("H15_4","082_5_4","1TH","5","4","5","Yes, you are not like others, the ones who are not God's. They live in what is like darkness, Satan's darkness. They are not expecting the Boss Jesus to come. When he comes they will get a shock/be startled. You are not like those ones. You belong to God, you live in his light. You are waiting for Jesus. When he comes you will not get a shock, you will be happy. ");
INSERT INTO engnna_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","We are not living in darkness. We should not be sleeping all the time like others. We should be alert waiting expectantly for the Boss Jesus to come. We should not be like those who are habitual drunkards, those are drinking all the time. ");
INSERT INTO engnna_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","It's in the night that people sleep, those who are habitual drinkers get drunk in the night also. ");
INSERT INTO engnna_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","We should not be like them, they live in the darkness. We belong to God, we live in his light. Therefore we should live in an appropriate way, not like the drunkards. We should always trust God and take care of one another well. We should remember, Boss Jesus himself will take us to his Father's country. When we act in that way God will keep us safe from Satan. ");
INSERT INTO engnna_vpl VALUES ("H15_9","082_5_9","1TH","5","9","10","God chose us, he made us his own people. He did that not to look on us with anger and to hit us. He chose us in order to take care of us, he will take us to his own country. That is the very reason he sent Jesus our Boss to us. He died for us to rescue us. Later he will return to get us all, the living ones and the dead ones. He will take us all to be with him for ever. ");
INSERT INTO engnna_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Therefore remind each other with this word, then you will not be sad / worried. You have already been telling each other this word. You should keep on doing like that in order to believe strongly/firmly. ");
INSERT INTO engnna_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Yes, we ask you to think well of your leaders. God himself chose those leaders for you. Truly they really take care of you and they teach you believers how to live in the proper way. ");
INSERT INTO engnna_vpl VALUES ("H15_13a","082_5_13a","1TH","5","13a","13a","In that sort of way they work for you. Therefore truly think well of them and love them. ");
INSERT INTO engnna_vpl VALUES ("H15_13b","082_5_13b","1TH","5","13b","13b","Don't argue with each other. ");
INSERT INTO engnna_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","We want you to do this sort of thing: Some among you are habitually not workers, tell them they must work. Some among you are fearful. Say to them, “Trust God! He will take care of you. Don't be afraid!” Some among you are habitually slack, tell them, “In a true way follow the Boss Jesus!” Behave gently with everyone. ");
INSERT INTO engnna_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Some people might do wrong to you, don't you do wrong to them in response. Take care of each other really well, others also, take care of them, the ones who don't know the Boss Jesus. ");
INSERT INTO engnna_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Always be really happy. ");
INSERT INTO engnna_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Keep on talking to God. ");
INSERT INTO engnna_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Continually say “Thankyou!” to God. Say like that to him when you are in a good way and when you are in a bad way also. Christians should do like that. God wants that sort of thing. ");
INSERT INTO engnna_vpl VALUES ("H15_19","082_5_19","1TH","5","19","20","Perhaps the Holy Spirit will talk to you, do not be inattentive. Perhaps another person will tell you that he is speaking a word from God. Don't ignore that word. ");
INSERT INTO engnna_vpl VALUES ("H15_21","082_5_21","1TH","5","21","22","Listen carefully to that word. You should ask yourselves, “Is that word true? Is it from God?” Perhaps it is indeed really true, then act according to that word. Perhaps it is really false, not from God, it is bad. Don't do according to a bad word. ");
INSERT INTO engnna_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","God is with you, he himself looks after you well. Therefore your feelings are at peace. I ask God for you that he will keep you safe, without badness. I ask for you that he will take care of your spirit and mind and body well. In this very way you will stay without badness forever. One day Jesus Christ our Boss will return from the sky, he will say you are truly good, without evil. ");
INSERT INTO engnna_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","God himself picked you to become his own people. He is dependable, he will make you really good and keep you safe. ");
INSERT INTO engnna_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Yes, you should ask God for us that he will take care of us also. ");
INSERT INTO engnna_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","You all belong to the Boss Jesus. When you are together in a group give each other a hug with happiness. ");
INSERT INTO engnna_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","I, Paul, tell you, God wants you to listen/pay attention to this word. You should read this letter for everyone to hear. ");
INSERT INTO engnna_vpl VALUES ("T13_2","084_3_2","1TI","3","2","3","A Christian leader must stay without fault. He must be a really dependable person, he must be a boss for himself...not a drunkard...not a fighter... ");
INSERT INTO engnna_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Properly we have believed in God. Then God gave us his good Spirit, truly he is without fault. That Spirit from God will stay in us forever. He does not make us fearful. He does not make us ashamed. He prompts us to do the right in accordance with God's word. He prompts us to put God, and all people also, in our feelings. He prompts us to do good and to leave evil also. ");
INSERT INTO engnna_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Remember that I have told you, people will be in a truly bad way. People will be selfish, greedy for money, show-offs, boastful, slanderers, ignorers of their parents, won't give back in return, will not be afraid of God; won't feel sorry, they will be violent, they will tell lies about other people, they won't listen when someone tells them to stop, they will be fighters, they will be dislikers of good, deceitfully they will secretly do bad things to people, boldly they will do bad things without thinking what might happen as a result, they will think they are big; they will only please themselves, they won't love God, they will be like Christians but liars, they won't know about the Good Spirit that he makes Christians of good character and makes them avoid evil. Never join with people like those bad ones. ");
INSERT INTO engnna_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","A Christian leader...truly he must not be an arrogant person, not quick-tempered, not a drunkard, not a fighter, not greedy for money. ");
INSERT INTO engnna_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Christians should learn how to think wisely and to work well all the time. They should not sit around aimlessly. ");
INSERT INTO engnna_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","2","Lots of people from long ago are watching us. Therefore let us throw away everything that slows us down from doing good, the bad things also that hold onto us tightly. Let us follow Jesus continually, let us think about him always. He causes us to truly believe in God from beginning to end. To die nailed up on the tree is a shameful thing. Jesus knew about this, he did not back off, he was thinking that later God would make him very happy, he ignored that shame. Now he is sitting really close to God. ");
INSERT INTO engnna_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","15","Remember, whoever wants to do evil, very truly he should not say, “God is tempting me to do evil.” No-one can tempt God to do evil, and God himself will not tempt a person to do evil. We ourselves want to do evil continually, and thinking about it tempts us to do that evil. If we continually do evil in that sort of way we will die. ");
INSERT INTO engnna_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","8","Say to God, “Whatever you want me to do, I will do that for you.” You should block the big devil, he will run away from you. Get close to God and he will get close to you. ");
INSERT INTO engnna_vpl VALUES ("P11_18","090_1_18","1PE","1","18","19","Your ancestors used to do bad things, like that their descendants copied them. In that same way you also were staying. You fellows know that one, Jesus Christ, people killed him. When they did that to him, he became like what-was-it, he became like a little sheep, that really healthy one, without sickness or sores, long ago after people did something bad, they used to kill a sheep, they used to say to God, “I did a bad thing. Because of that I have killed this sheep, in exchange don't hit me for that bad thing, just let me off.” Jesus Christ became like that sheep for us. He did a really big thing for us, our boss died for us! Satan cannot hold us, from now on Satan is not our boss! Jesus took our part, he did it once for everybody forever. Because of that you must think about him very seriously and with fear. ");
INSERT INTO engnna_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","Be alert! Look around! That devil is an enemy to you. That big animal, what's-its-name, the one they call a lion, the one that roars, it goes around looking for meat to eat. Like that the big devil goes around looking for people to get hold of, to turn them into rubbish. ");
INSERT INTO engnna_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","Be determined, always believe in God. Keep blocking the devil! You know about the others, ");
INSERT INTO engnna_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","This is the word that his Son told us, and now we are telling you: God is truly without fault, truly he is good always. ");
INSERT INTO engnna_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","We might talk as if we are alright with God, but we are also sinning. By doing that we are lying, what we are doing is not in accordance with God's word. ");
INSERT INTO engnna_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","When we are without badness just like he is without badness, we will all become happy together, and as a result of that the blood of Jesus his Son washes us from all the bad things we have done. ");
INSERT INTO engnna_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Perhaps we might say to ourselves we are without badness, truly we are deceiving ourselves, truly we should tell it the proper way but we are not. ");
INSERT INTO engnna_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","When we tell God we have done wrong, he is true, he will do according to his word, he will do what is proper: he will leave us untouched for doing that bad thing, he will wash us from all the bad things we did. ");
INSERT INTO engnna_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","There will be no darkness there, God will make everything bright, without sun and without lamp. Those believers will be like big bosses forever. ");
ALTER TABLE engnna_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
