﻿USE sofia;
DROP TABLE IF EXISTS sofia.engnet_vpl;
CREATE TABLE engnet_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engnet_vpl WRITE;
INSERT INTO engnet_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," In the beginning God created the heavens and the earth. ");
INSERT INTO engnet_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Now the earth was without shape and empty, and darkness was over the surface of the watery deep, but the Spirit of God was moving over the surface of the water. ");
INSERT INTO engnet_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “Let there be light.” And there was light! ");
INSERT INTO engnet_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God saw that the light was good, so God separated the light from the darkness. ");
INSERT INTO engnet_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God called the light “day” and the darkness “night.” There was evening, and there was morning, marking the first day. ");
INSERT INTO engnet_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God said, “Let there be an expanse in the midst of the waters and let it separate water from water. ");
INSERT INTO engnet_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","So God made the expanse and separated the water under the expanse from the water above it. It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God called the expanse “sky.” There was evening, and there was morning, a second day. ");
INSERT INTO engnet_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God said, “Let the water under the sky be gathered to one place and let dry ground appear.” It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the dry ground “land” and the gathered waters he called “seas.” God saw that it was good. ");
INSERT INTO engnet_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God said, “Let the land produce vegetation: plants yielding seeds according to their kinds, and trees bearing fruit with seed in it according to their kinds.” It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The land produced vegetation – plants yielding seeds according to their kinds, and trees bearing fruit with seed in it according to their kinds. God saw that it was good. ");
INSERT INTO engnet_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","There was evening, and there was morning, a third day. ");
INSERT INTO engnet_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God said, “Let there be lights in the expanse of the sky to separate the day from the night, and let them be signs to indicate seasons and days and years, ");
INSERT INTO engnet_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","and let them serve as lights in the expanse of the sky to give light on the earth.” It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God made two great lights – the greater light to rule over the day and the lesser light to rule over the night. He made the stars also. ");
INSERT INTO engnet_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God placed the lights in the expanse of the sky to shine on the earth, ");
INSERT INTO engnet_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to preside over the day and the night, and to separate the light from the darkness. God saw that it was good. ");
INSERT INTO engnet_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","There was evening, and there was morning, a fourth day. ");
INSERT INTO engnet_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God said, “Let the water swarm with swarms of living creatures and let birds fly above the earth across the expanse of the sky.” ");
INSERT INTO engnet_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","God created the great sea creatures and every living and moving thing with which the water swarmed, according to their kinds, and every winged bird according to its kind. God saw that it was good. ");
INSERT INTO engnet_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed them and said, “Be fruitful and multiply and fill the water in the seas, and let the birds multiply on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","There was evening, and there was morning, a fifth day. ");
INSERT INTO engnet_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God said, “Let the land produce living creatures according to their kinds: cattle, creeping things, and wild animals, each according to its kind.” It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made the wild animals according to their kinds, the cattle according to their kinds, and all the creatures that creep along the ground according to their kinds. God saw that it was good. ");
INSERT INTO engnet_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Then God said, “Let us make humankind in our image, after our likeness, so they may rule over the fish of the sea and the birds of the air, over the cattle, and over all the earth, and over all the creatures that move on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God created humankind in his own image, in the image of God he created them, male and female he created them. ");
INSERT INTO engnet_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them and said to them, “Be fruitful and multiply! Fill the earth and subdue it! Rule over the fish of the sea and the birds of the air and every creature that moves on the ground.” ");
INSERT INTO engnet_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Then God said, “I now give you every seed-bearing plant on the face of the entire earth and every tree that has fruit with seed in it. They will be yours for food. ");
INSERT INTO engnet_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And to all the animals of the earth, and to every bird of the air, and to all the creatures that move on the ground – everything that has the breath of life in it – I give every green plant for food.” It was so. ");
INSERT INTO engnet_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God saw all that he had made – and it was very good! There was evening, and there was morning, the sixth day. ");
INSERT INTO engnet_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","The heavens and the earth were completed with everything that was in them. ");
INSERT INTO engnet_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","By the seventh day God finished the work that he had been doing, and he ceased on the seventh day all the work that he had been doing. ");
INSERT INTO engnet_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed the seventh day and made it holy because on it he ceased all the work that he had been doing in creation. ");
INSERT INTO engnet_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This is the account of the heavens and the earth when they were created – when the Lord God made the earth and heavens. ");
INSERT INTO engnet_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Now no shrub of the field had yet grown on the earth, and no plant of the field had yet sprouted, for the Lord God had not caused it to rain on the earth, and there was no man to cultivate the ground. ");
INSERT INTO engnet_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Springs would well up from the earth and water the whole surface of the ground. ");
INSERT INTO engnet_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","The Lord God formed the man from the soil of the ground and breathed into his nostrils the breath of life, and the man became a living being. ");
INSERT INTO engnet_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","The Lord God planted an orchard in the east, in Eden; and there he placed the man he had formed. ");
INSERT INTO engnet_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","The Lord God made all kinds of trees grow from the soil, every tree that was pleasing to look at and good for food. (Now the tree of life and the tree of the knowledge of good and evil were in the middle of the orchard.) ");
INSERT INTO engnet_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Now a river flows from Eden to water the orchard, and from there it divides into four headstreams. ");
INSERT INTO engnet_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first is Pishon; it runs through the entire land of Havilah, where there is gold. ");
INSERT INTO engnet_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(The gold of that land is pure; pearls and lapis lazuli are also there). ");
INSERT INTO engnet_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river is Gihon; it runs through the entire land of Cush. ");
INSERT INTO engnet_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river is Tigris; it runs along the east side of Assyria. The fourth river is the Euphrates. ");
INSERT INTO engnet_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","The Lord God took the man and placed him in the orchard in Eden to care for it and to maintain it. ");
INSERT INTO engnet_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Then the Lord God commanded the man, “You may freely eat fruit from every tree of the orchard, ");
INSERT INTO engnet_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","but you must not eat from the tree of the knowledge of good and evil, for when you eat from it you will surely die.” ");
INSERT INTO engnet_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","The Lord God said, “It is not good for the man to be alone. I will make a companion for him who corresponds to him.” ");
INSERT INTO engnet_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","The Lord God formed out of the ground every living animal of the field and every bird of the air. He brought them to the man to see what he would name them, and whatever the man called each living creature, that was its name. ");
INSERT INTO engnet_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","So the man named all the animals, the birds of the air, and the living creatures of the field, but for Adam no companion who corresponded to him was found. ");
INSERT INTO engnet_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So the Lord God caused the man to fall into a deep sleep, and while he was asleep, he took part of the man’s side and closed up the place with flesh. ");
INSERT INTO engnet_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Then the Lord God made a woman from the part he had taken out of the man, and he brought her to the man. ");
INSERT INTO engnet_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Then the man said, “This one at last is bone of my bones and flesh of my flesh; this one will be called ‘woman,’ for she was taken out of man.” ");
INSERT INTO engnet_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","That is why a man leaves his father and mother and unites with his wife, and they become a new family. ");
INSERT INTO engnet_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","The man and his wife were both naked, but they were not ashamed. ");
INSERT INTO engnet_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the serpent was more shrewd than any of the wild animals that the Lord God had made. He said to the woman, “Is it really true that God said, ‘You must not eat from any tree of the orchard’?” ");
INSERT INTO engnet_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman said to the serpent, “We may eat of the fruit from the trees of the orchard; ");
INSERT INTO engnet_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","but concerning the fruit of the tree that is in the middle of the orchard God said, ‘You must not eat from it, and you must not touch it, or else you will die.’” ");
INSERT INTO engnet_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","The serpent said to the woman, “Surely you will not die, ");
INSERT INTO engnet_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","for God knows that when you eat from it your eyes will open and you will be like divine beings who know good and evil.” ");
INSERT INTO engnet_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","When the woman saw that the tree produced fruit that was good for food, was attractive to the eye, and was desirable for making one wise, she took some of its fruit and ate it. She also gave some of it to her husband who was with her, and he ate it. ");
INSERT INTO engnet_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Then the eyes of both of them opened, and they knew they were naked; so they sewed fig leaves together and made coverings for themselves. ");
INSERT INTO engnet_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Then the man and his wife heard the sound of the Lord God moving about in the orchard at the breezy time of the day, and they hid from the Lord God among the trees of the orchard. ");
INSERT INTO engnet_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","But the Lord God called to the man and said to him, “Where are you?” ");
INSERT INTO engnet_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man replied, “I heard you moving about in the orchard, and I was afraid because I was naked, so I hid.” ");
INSERT INTO engnet_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","And the Lord God said, “Who told you that you were naked? Did you eat from the tree that I commanded you not to eat from?” ");
INSERT INTO engnet_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “The woman whom you gave me, she gave me some fruit from the tree and I ate it.” ");
INSERT INTO engnet_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","So the Lord God said to the woman, “What is this you have done?” And the woman replied, “The serpent tricked me, and I ate.” ");
INSERT INTO engnet_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","The Lord God said to the serpent, “Because you have done this, cursed are you above all the wild beasts and all the living creatures of the field! On your belly you will crawl and dust you will eat all the days of your life. ");
INSERT INTO engnet_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And I will put hostility between you and the woman and between your offspring and her offspring; her offspring will attack your head, and you will attack her offspring’s heel.” ");
INSERT INTO engnet_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman he said, “I will greatly increase your labor pains; with pain you will give birth to children. You will want to control your husband, but he will dominate you.” ");
INSERT INTO engnet_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","But to Adam he said, “Because you obeyed your wife and ate from the tree about which I commanded you, ‘You must not eat from it,’ cursed is the ground thanks to you; in painful toil you will eat of it all the days of your life. ");
INSERT INTO engnet_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","It will produce thorns and thistles for you, but you will eat the grain of the field. ");
INSERT INTO engnet_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","By the sweat of your brow you will eat food until you return to the ground, for out of it you were taken; for you are dust, and to dust you will return.” ");
INSERT INTO engnet_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","The man named his wife Eve, because she was the mother of all the living. ");
INSERT INTO engnet_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","The Lord God made garments from skin for Adam and his wife, and clothed them. ");
INSERT INTO engnet_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","And the Lord God said, “Now that the man has become like one of us, knowing good and evil, he must not be allowed to stretch out his hand and take also from the tree of life and eat, and live forever.” ");
INSERT INTO engnet_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So the Lord God expelled him from the orchard in Eden to cultivate the ground from which he had been taken. ");
INSERT INTO engnet_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","When he drove the man out, he placed on the eastern side of the orchard in Eden angelic sentries who used the flame of a whirling sword to guard the way to the tree of life. ");
INSERT INTO engnet_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Now the man had marital relations with his wife Eve, and she became pregnant and gave birth to Cain. Then she said, “I have created a man just as the Lord did!” ");
INSERT INTO engnet_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Then she gave birth to his brother Abel. Abel took care of the flocks, while Cain cultivated the ground. ");
INSERT INTO engnet_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","At the designated time Cain brought some of the fruit of the ground for an offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","But Abel brought some of the firstborn of his flock – even the fattest of them. And the Lord was pleased with Abel and his offering, ");
INSERT INTO engnet_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but with Cain and his offering he was not pleased. So Cain became very angry, and his expression was downcast. ");
INSERT INTO engnet_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Then the Lord said to Cain, “Why are you angry, and why is your expression downcast? ");
INSERT INTO engnet_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Is it not true that if you do what is right, you will be fine? But if you do not do what is right, sin is crouching at the door. It desires to dominate you, but you must subdue it.” ");
INSERT INTO engnet_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain said to his brother Abel, “Let’s go out to the field.” While they were in the field, Cain attacked his brother Abel and killed him. ");
INSERT INTO engnet_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Then the Lord said to Cain, “Where is your brother Abel?” And he replied, “I don’t know! Am I my brother’s guardian?” ");
INSERT INTO engnet_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","But the Lord said, “What have you done? The voice of your brother’s blood is crying out to me from the ground! ");
INSERT INTO engnet_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","So now, you are banished from the ground, which has opened its mouth to receive your brother’s blood from your hand. ");
INSERT INTO engnet_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When you try to cultivate the ground it will no longer yield its best for you. You will be a homeless wanderer on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Then Cain said to the Lord, “My punishment is too great to endure! ");
INSERT INTO engnet_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Look! You are driving me off the land today, and I must hide from your presence. I will be a homeless wanderer on the earth; whoever finds me will kill me.” ");
INSERT INTO engnet_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","But the Lord said to him, “All right then, if anyone kills Cain, Cain will be avenged seven times as much.” Then the Lord put a special mark on Cain so that no one who found him would strike him down. ");
INSERT INTO engnet_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","So Cain went out from the presence of the Lord and lived in the land of Nod, east of Eden. ");
INSERT INTO engnet_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain had marital relations with his wife, and she became pregnant and gave birth to Enoch. Cain was building a city, and he named the city after his son Enoch. ");
INSERT INTO engnet_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","To Enoch was born Irad, and Irad was the father of Mehujael. Mehujael was the father of Methushael, and Methushael was the father of Lamech. ");
INSERT INTO engnet_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech took two wives for himself; the name of the first was Adah, and the name of the second was Zillah. ");
INSERT INTO engnet_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to Jabal; he was the first of those who live in tents and keep livestock. ");
INSERT INTO engnet_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","The name of his brother was Jubal; he was the first of all who play the harp and the flute. ");
INSERT INTO engnet_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Now Zillah also gave birth to Tubal-Cain, who heated metal and shaped all kinds of tools made of bronze and iron. The sister of Tubal-Cain was Naamah. ");
INSERT INTO engnet_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech said to his wives, “Adah and Zillah! Listen to me! You wives of Lamech, hear my words! I have killed a man for wounding me, a young man for hurting me. ");
INSERT INTO engnet_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If Cain is to be avenged seven times as much, then Lamech seventy-seven times!” ");
INSERT INTO engnet_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam had marital relations with his wife again, and she gave birth to a son. She named him Seth, saying, “God has given me another child in place of Abel because Cain killed him.” ");
INSERT INTO engnet_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And a son was also born to Seth, whom he named Enosh. At that time people began to worship the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the record of the family line of Adam. When God created humankind, he made them in the likeness of God. ");
INSERT INTO engnet_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He created them male and female; when they were created, he blessed them and named them “humankind.” ");
INSERT INTO engnet_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","When Adam had lived 130 years he fathered a son in his own likeness, according to his image, and he named him Seth. ");
INSERT INTO engnet_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","The length of time Adam lived after he became the father of Seth was 800 years; during this time he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","The entire lifetime of Adam was 930 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","When Seth had lived 105 years, he became the father of Enosh. ");
INSERT INTO engnet_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth lived 807 years after he became the father of Enosh, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","The entire lifetime of Seth was 912 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","When Enosh had lived 90 years, he became the father of Kenan. ");
INSERT INTO engnet_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh lived 815 years after he became the father of Kenan, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","The entire lifetime of Enosh was 905 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","When Kenan had lived 70 years, he became the father of Mahalalel. ");
INSERT INTO engnet_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan lived 840 years after he became the father of Mahalalel, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","The entire lifetime of Kenan was 910 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel had lived 65 years, he became the father of Jared. ");
INSERT INTO engnet_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalalel lived 830 years after he became the father of Jared, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","The entire lifetime of Mahalalel was 895 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","When Jared had lived 162 years, he became the father of Enoch. ");
INSERT INTO engnet_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jared lived 800 years after he became the father of Enoch, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","The entire lifetime of Jared was 962 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","When Enoch had lived 65 years, he became the father of Methuselah. ");
INSERT INTO engnet_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","After he became the father of Methuselah, Enoch walked with God for 300 years, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","The entire lifetime of Enoch was 365 years. ");
INSERT INTO engnet_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch walked with God, and then he disappeared because God took him away. ");
INSERT INTO engnet_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","When Methuselah had lived 187 years, he became the father of Lamech. ");
INSERT INTO engnet_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Methuselah lived 782 years after he became the father of Lamech, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","The entire lifetime of Methuselah was 969 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech had lived 182 years, he had a son. ");
INSERT INTO engnet_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","He named him Noah, saying, “This one will bring us comfort from our labor and from the painful toil of our hands because of the ground that the Lord has cursed.” ");
INSERT INTO engnet_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamech lived 595 years after he became the father of Noah, and he had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","The entire lifetime of Lamech was 777 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","After Noah was 500 years old, he became the father of Shem, Ham, and Japheth. ");
INSERT INTO engnet_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","When humankind began to multiply on the face of the earth, and daughters were born to them, ");
INSERT INTO engnet_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","the sons of God saw that the daughters of humankind were beautiful. Thus they took wives for themselves from any they chose. ");
INSERT INTO engnet_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","So the Lord said, “My spirit will not remain in humankind indefinitely, since they are mortal. They will remain for 120 more years.” ");
INSERT INTO engnet_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","The Nephilim were on the earth in those days (and also after this) when the sons of God were having sexual relations with the daughters of humankind, who gave birth to their children. They were the mighty heroes of old, the famous men. ");
INSERT INTO engnet_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","But the Lord saw that the wickedness of humankind had become great on the earth. Every inclination of the thoughts of their minds was only evil all the time. ");
INSERT INTO engnet_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","The Lord regretted that he had made humankind on the earth, and he was highly offended. ");
INSERT INTO engnet_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So the Lord said, “I will wipe humankind, whom I have created, from the face of the earth – everything from humankind to animals, including creatures that move on the ground and birds of the air, for I regret that I have made them.” ");
INSERT INTO engnet_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noah found favor in the sight of the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the account of Noah. Noah was a godly man; he was blameless among his contemporaries. He walked with God. ");
INSERT INTO engnet_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah had three sons: Shem, Ham, and Japheth. ");
INSERT INTO engnet_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","The earth was ruined in the sight of God; the earth was filled with violence. ");
INSERT INTO engnet_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God saw the earth, and indeed it was ruined, for all living creatures on the earth were sinful. ");
INSERT INTO engnet_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","So God said to Noah, “I have decided that all living creatures must die, for the earth is filled with violence because of them. Now I am about to destroy them and the earth. ");
INSERT INTO engnet_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make for yourself an ark of cypress wood. Make rooms in the ark, and cover it with pitch inside and out. ");
INSERT INTO engnet_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","This is how you should make it: The ark is to be 450 feet long, 75 feet wide, and 45 feet high. ");
INSERT INTO engnet_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Make a roof for the ark and finish it, leaving 18 inches from the top. Put a door in the side of the ark, and make lower, middle, and upper decks. ");
INSERT INTO engnet_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","I am about to bring floodwaters on the earth to destroy from under the sky all the living creatures that have the breath of life in them. Everything that is on the earth will die, ");
INSERT INTO engnet_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","but I will confirm my covenant with you. You will enter the ark – you, your sons, your wife, and your sons’ wives with you. ");
INSERT INTO engnet_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","You must bring into the ark two of every kind of living creature from all flesh, male and female, to keep them alive with you. ");
INSERT INTO engnet_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Of the birds after their kinds, and of the cattle after their kinds, and of every creeping thing of the ground after its kind, two of every kind will come to you so you can keep them alive. ");
INSERT INTO engnet_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","And you must take for yourself every kind of food that is eaten, and gather it together. It will be food for you and for them. ");
INSERT INTO engnet_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","And Noah did all that God commanded him – he did indeed. ");
INSERT INTO engnet_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","The Lord said to Noah, “Come into the ark, you and all your household, for I consider you godly among this generation. ");
INSERT INTO engnet_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","You must take with you seven of every kind of clean animal, the male and its mate, two of every kind of unclean animal, the male and its mate, ");
INSERT INTO engnet_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","and also seven of every kind of bird in the sky, male and female, to preserve their offspring on the face of the earth. ");
INSERT INTO engnet_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","For in seven days I will cause it to rain on the earth for forty days and forty nights, and I will wipe from the face of the ground every living thing that I have made.” ");
INSERT INTO engnet_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noah did all that the Lord commanded him. ");
INSERT INTO engnet_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was 600 years old when the floodwaters engulfed the earth. ");
INSERT INTO engnet_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noah entered the ark along with his sons, his wife, and his sons’ wives because of the floodwaters. ");
INSERT INTO engnet_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Pairs of clean animals, of unclean animals, of birds, and of everything that creeps along the ground, ");
INSERT INTO engnet_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","male and female, came into the ark to Noah, just as God had commanded him. ");
INSERT INTO engnet_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And after seven days the floodwaters engulfed the earth. ");
INSERT INTO engnet_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noah’s life, in the second month, on the seventeenth day of the month – on that day all the fountains of the great deep burst open and the floodgates of the heavens were opened. ");
INSERT INTO engnet_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","And the rain fell on the earth forty days and forty nights. ");
INSERT INTO engnet_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On that very day Noah entered the ark, accompanied by his sons Shem, Ham, and Japheth, along with his wife and his sons’ three wives. ");
INSERT INTO engnet_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They entered, along with every living creature after its kind, every animal after its kind, every creeping thing that creeps on the earth after its kind, and every bird after its kind, everything with wings. ");
INSERT INTO engnet_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pairs of all creatures that have the breath of life came into the ark to Noah. ");
INSERT INTO engnet_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Those that entered were male and female, just as God commanded him. Then the Lord shut him in. ");
INSERT INTO engnet_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","The flood engulfed the earth for forty days. As the waters increased, they lifted the ark and raised it above the earth. ");
INSERT INTO engnet_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The waters completely overwhelmed the earth, and the ark floated on the surface of the waters. ");
INSERT INTO engnet_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The waters completely inundated the earth so that even all the high mountains under the entire sky were covered. ");
INSERT INTO engnet_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The waters rose more than twenty feet above the mountains. ");
INSERT INTO engnet_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","And all living things that moved on the earth died, including the birds, domestic animals, wild animals, all the creatures that swarm over the earth, and all humankind. ");
INSERT INTO engnet_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Everything on dry land that had the breath of life in its nostrils died. ");
INSERT INTO engnet_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","So the Lord destroyed every living thing that was on the surface of the ground, including people, animals, creatures that creep along the ground, and birds of the sky. They were wiped off the earth. Only Noah and those who were with him in the ark survived. ");
INSERT INTO engnet_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The waters prevailed over the earth for 150 days. ");
INSERT INTO engnet_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","But God remembered Noah and all the wild animals and domestic animals that were with him in the ark. God caused a wind to blow over the earth and the waters receded. ");
INSERT INTO engnet_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The fountains of the deep and the floodgates of heaven were closed, and the rain stopped falling from the sky. ");
INSERT INTO engnet_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The waters kept receding steadily from the earth, so that they had gone down by the end of the 150 days. ");
INSERT INTO engnet_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","On the seventeenth day of the seventh month, the ark came to rest on one of the mountains of Ararat. ");
INSERT INTO engnet_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The waters kept on receding until the tenth month. On the first day of the tenth month, the tops of the mountains became visible. ");
INSERT INTO engnet_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","At the end of forty days, Noah opened the window he had made in the ark ");
INSERT INTO engnet_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","and sent out a raven; it kept flying back and forth until the waters had dried up on the earth. ");
INSERT INTO engnet_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Then Noah sent out a dove to see if the waters had receded from the surface of the ground. ");
INSERT INTO engnet_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","The dove could not find a resting place for its feet because water still covered the surface of the entire earth, and so it returned to Noah in the ark. He stretched out his hand, took the dove, and brought it back into the ark. ");
INSERT INTO engnet_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","He waited seven more days and then sent out the dove again from the ark. ");
INSERT INTO engnet_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","When the dove returned to him in the evening, there was a freshly plucked olive leaf in its beak! Noah knew that the waters had receded from the earth. ");
INSERT INTO engnet_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","He waited another seven days and sent the dove out again, but it did not return to him this time. ");
INSERT INTO engnet_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","In Noah’s six hundred and first year, in the first day of the first month, the waters had dried up from the earth, and Noah removed the covering from the ark and saw that the surface of the ground was dry. ");
INSERT INTO engnet_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","And by the twenty-seventh day of the second month the earth was dry. ");
INSERT INTO engnet_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God spoke to Noah and said, ");
INSERT INTO engnet_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Come out of the ark, you, your wife, your sons, and your sons’ wives with you. ");
INSERT INTO engnet_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring out with you all the living creatures that are with you. Bring out every living thing, including the birds, animals, and every creeping thing that creeps on the earth. Let them increase and be fruitful and multiply on the earth!” ");
INSERT INTO engnet_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noah went out along with his sons, his wife, and his sons’ wives. ");
INSERT INTO engnet_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every living creature, every creeping thing, every bird, and everything that moves on the earth went out of the ark in their groups. ");
INSERT INTO engnet_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah built an altar to the Lord. He then took some of every kind of clean animal and clean bird and offered burnt offerings on the altar. ");
INSERT INTO engnet_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","And the Lord smelled the soothing aroma and said to himself, “I will never again curse the ground because of humankind, even though the inclination of their minds is evil from childhood on. I will never again destroy everything that lives, as I have just done. ");
INSERT INTO engnet_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“While the earth continues to exist, planting time and harvest, cold and heat, summer and winter, and day and night will not cease.” ");
INSERT INTO engnet_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Then God blessed Noah and his sons and said to them, “Be fruitful and multiply and fill the earth. ");
INSERT INTO engnet_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Every living creature of the earth and every bird of the sky will be terrified of you. Everything that creeps on the ground and all the fish of the sea are under your authority. ");
INSERT INTO engnet_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","You may eat any moving thing that lives. As I gave you the green plants, I now give you everything. ");
INSERT INTO engnet_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But you must not eat meat with its life (that is, its blood) in it. ");
INSERT INTO engnet_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","For your lifeblood I will surely exact punishment, from every living creature I will exact punishment. From each person I will exact punishment for the life of the individual since the man was his relative. ");
INSERT INTO engnet_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Whoever sheds human blood, by other humans must his blood be shed; for in God’s image God has made humankind.” ");
INSERT INTO engnet_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","But as for you, be fruitful and multiply; increase abundantly on the earth and multiply on it.” ");
INSERT INTO engnet_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","God said to Noah and his sons, ");
INSERT INTO engnet_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Look! I now confirm my covenant with you and your descendants after you ");
INSERT INTO engnet_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living creature that is with you, including the birds, the domestic animals, and every living creature of the earth with you, all those that came out of the ark with you – every living creature of the earth. ");
INSERT INTO engnet_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","I confirm my covenant with you: Never again will all living things be wiped out by the waters of a flood; never again will a flood destroy the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God said, “This is the guarantee of the covenant I am making with you and every living creature with you, a covenant for all subsequent generations: ");
INSERT INTO engnet_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I will place my rainbow in the clouds, and it will become a guarantee of the covenant between me and the earth. ");
INSERT INTO engnet_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Whenever I bring clouds over the earth and the rainbow appears in the clouds, ");
INSERT INTO engnet_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","then I will remember my covenant with you and with all living creatures of all kinds. Never again will the waters become a flood and destroy all living things. ");
INSERT INTO engnet_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","When the rainbow is in the clouds, I will notice it and remember the perpetual covenant between God and all living creatures of all kinds that are on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","So God said to Noah, “This is the guarantee of the covenant that I am confirming between me and all living things that are on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","The sons of Noah who came out of the ark were Shem, Ham, and Japheth. (Now Ham was the father of Canaan.) ");
INSERT INTO engnet_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These were the sons of Noah, and from them the whole earth was populated. ");
INSERT INTO engnet_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah, a man of the soil, began to plant a vineyard. ");
INSERT INTO engnet_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","When he drank some of the wine, he got drunk and uncovered himself inside his tent. ");
INSERT INTO engnet_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, the father of Canaan, saw his father’s nakedness and told his two brothers who were outside. ");
INSERT INTO engnet_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem and Japheth took the garment and placed it on their shoulders. Then they walked in backwards and covered up their father’s nakedness. Their faces were turned the other way so they did not see their father’s nakedness. ");
INSERT INTO engnet_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","When Noah awoke from his drunken stupor he learned what his youngest son had done to him. ");
INSERT INTO engnet_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","So he said, “Cursed be Canaan! The lowest of slaves he will be to his brothers.” ");
INSERT INTO engnet_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","He also said, “Worthy of praise is the Lord, the God of Shem! May Canaan be the slave of Shem! ");
INSERT INTO engnet_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God enlarge Japheth’s territory and numbers! May he live in the tents of Shem and may Canaan be his slave!” ");
INSERT INTO engnet_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","After the flood Noah lived 350 years. ");
INSERT INTO engnet_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","The entire lifetime of Noah was 950 years, and then he died. ");
INSERT INTO engnet_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","This is the account of Noah’s sons Shem, Ham, and Japheth. Sons were born to them after the flood. ");
INSERT INTO engnet_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth were Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engnet_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer were Askenaz, Riphath, and Togarmah. ");
INSERT INTO engnet_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","The sons of Javan were Elishah, Tarshish, the Kittim, and the Dodanim. ");
INSERT INTO engnet_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","From these the coastlands of the nations were separated into their lands, every one according to its language, according to their families, by their nations. ");
INSERT INTO engnet_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The sons of Ham were Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The sons of Cush were Seba, Havilah, Sabtah, Raamah, and Sabteca. The sons of Raamah were Sheba and Dedan. ");
INSERT INTO engnet_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush was the father of Nimrod; he began to be a valiant warrior on the earth. ");
INSERT INTO engnet_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a mighty hunter before the Lord. (That is why it is said, “Like Nimrod, a mighty hunter before the Lord.”) ");
INSERT INTO engnet_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","The primary regions of his kingdom were Babel, Erech, Akkad, and Calneh in the land of Shinar. ");
INSERT INTO engnet_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From that land he went to Assyria, where he built Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO engnet_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, which is between Nineveh and the great city Calah. ");
INSERT INTO engnet_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim was the father of the Ludites, Anamites, Lehabites, Naphtuhites, ");
INSERT INTO engnet_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusites, Casluhites (from whom the Philistines came), and Caphtorites. ");
INSERT INTO engnet_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan was the father of Sidon his firstborn, Heth, ");
INSERT INTO engnet_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","the Jebusites, Amorites, Girgashites, ");
INSERT INTO engnet_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivites, Arkites, Sinites, ");
INSERT INTO engnet_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadites, Zemarites, and Hamathites. Eventually the families of the Canaanites were scattered ");
INSERT INTO engnet_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","and the borders of Canaan extended from Sidon all the way to Gerar as far as Gaza, and all the way to Sodom, Gomorrah, Admah, and Zeboiim, as far as Lasha. ");
INSERT INTO engnet_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are the sons of Ham, according to their families, according to their languages, by their lands, and by their nations. ");
INSERT INTO engnet_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","And sons were also born to Shem (the older brother of Japheth), the father of all the sons of Eber. ");
INSERT INTO engnet_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem were Elam, Asshur, Arphaxad, Lud, and Aram. ");
INSERT INTO engnet_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram were Uz, Hul, Gether, and Mash. ");
INSERT INTO engnet_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad was the father of Shelah, and Shelah was the father of Eber. ");
INSERT INTO engnet_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Two sons were born to Eber: One was named Peleg because in his days the earth was divided, and his brother’s name was Joktan. ");
INSERT INTO engnet_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan was the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engnet_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engnet_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engnet_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All these were sons of Joktan. ");
INSERT INTO engnet_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Their dwelling place was from Mesha all the way to Sephar in the eastern hills. ");
INSERT INTO engnet_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the sons of Shem according to their families, according to their languages, by their lands, and according to their nations. ");
INSERT INTO engnet_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These are the families of the sons of Noah, according to their genealogies, by their nations, and from these the nations spread over the earth after the flood. ");
INSERT INTO engnet_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","The whole earth had a common language and a common vocabulary. ");
INSERT INTO engnet_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","When the people moved eastward, they found a plain in Shinar and settled there. ");
INSERT INTO engnet_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Then they said to one another, “Come, let’s make bricks and bake them thoroughly.” (They had brick instead of stone and tar instead of mortar.) ");
INSERT INTO engnet_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Then they said, “Come, let’s build ourselves a city and a tower with its top in the heavens so that we may make a name for ourselves. Otherwise we will be scattered across the face of the entire earth.” ");
INSERT INTO engnet_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","But the Lord came down to see the city and the tower that the people had started building. ");
INSERT INTO engnet_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","And the Lord said, “If as one people all sharing a common language they have begun to do this, then nothing they plan to do will be beyond them. ");
INSERT INTO engnet_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let’s go down and confuse their language so they won’t be able to understand each other.” ");
INSERT INTO engnet_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So the Lord scattered them from there across the face of the entire earth, and they stopped building the city. ");
INSERT INTO engnet_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","That is why its name was called Babel – because there the Lord confused the language of the entire world, and from there the Lord scattered them across the face of the entire earth. ");
INSERT INTO engnet_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","This is the account of Shem. Shem was 100 old when he became the father of Arphaxad, two years after the flood. ");
INSERT INTO engnet_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And after becoming the father of Arphaxad, Shem lived 500 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphaxad had lived 35 years, he became the father of Shelah. ");
INSERT INTO engnet_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And after he became the father of Shelah, Arphaxad lived 403 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","When Shelah had lived 30 years, he became the father of Eber. ");
INSERT INTO engnet_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And after he became the father of Eber, Shelah lived 403 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","When Eber had lived 34 years, he became the father of Peleg. ");
INSERT INTO engnet_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And after he became the father of Peleg, Eber lived 430 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","When Peleg had lived 30 years, he became the father of Reu. ");
INSERT INTO engnet_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And after he became the father of Reu, Peleg lived 209 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","When Reu had lived 32 years, he became the father of Serug. ");
INSERT INTO engnet_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And after he became the father of Serug, Reu lived 207 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","When Serug had lived 30 years, he became the father of Nahor. ");
INSERT INTO engnet_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And after he became the father of Nahor, Serug lived 200 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","When Nahor had lived 29 years, he became the father of Terah. ");
INSERT INTO engnet_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And after he became the father of Terah, Nahor lived 119 years and had other sons and daughters. ");
INSERT INTO engnet_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","When Terah had lived 70 years, he became the father of Abram, Nahor, and Haran. ");
INSERT INTO engnet_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","This is the account of Terah. Terah became the father of Abram, Nahor, and Haran. And Haran became the father of Lot. ");
INSERT INTO engnet_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran died in the land of his birth, in Ur of the Chaldeans, while his father Terah was still alive. ");
INSERT INTO engnet_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Abram and Nahor took wives for themselves. The name of Abram’s wife was Sarai, and the name of Nahor’s wife was Milcah; she was the daughter of Haran, the father of both Milcah and Iscah. ");
INSERT INTO engnet_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","But Sarai was barren; she had no children. ");
INSERT INTO engnet_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah took his son Abram, his grandson Lot (the son of Haran), and his daughter-in-law Sarai, his son Abram’s wife, and with them he set out from Ur of the Chaldeans to go to Canaan. When they came to Haran, they settled there. ");
INSERT INTO engnet_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","The lifetime of Terah was 205 years, and he died in Haran. ");
INSERT INTO engnet_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Now the Lord said to Abram, “Go out from your country, your relatives, and your father’s household to the land that I will show you. ");
INSERT INTO engnet_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Then I will make you into a great nation, and I will bless you, and I will make your name great, so that you will exemplify divine blessing. ");
INSERT INTO engnet_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you, but the one who treats you lightly I must curse, and all the families of the earth will bless one another by your name.” ");
INSERT INTO engnet_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram left, just as the Lord had told him to do, and Lot went with him. (Now Abram was 75 years old when he departed from Haran.) ");
INSERT INTO engnet_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Abram took his wife Sarai, his nephew Lot, and all the possessions they had accumulated and the people they had acquired in Haran, and they left for the land of Canaan. They entered the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traveled through the land as far as the oak tree of Moreh at Shechem. (At that time the Canaanites were in the land.) ");
INSERT INTO engnet_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","The Lord appeared to Abram and said, “To your descendants I will give this land.” So Abram built an altar there to the Lord, who had appeared to him. ");
INSERT INTO engnet_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Then he moved from there to the hill country east of Bethel and pitched his tent, with Bethel on the west and Ai on the east. There he built an altar to the Lord and worshiped the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram continually journeyed by stages down to the Negev. ");
INSERT INTO engnet_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","There was a famine in the land, so Abram went down to Egypt to stay for a while because the famine was severe. ");
INSERT INTO engnet_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As he approached Egypt, he said to his wife Sarai, “Look, I know that you are a beautiful woman. ");
INSERT INTO engnet_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","When the Egyptians see you they will say, ‘This is his wife.’ Then they will kill me but will keep you alive. ");
INSERT INTO engnet_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So tell them you are my sister so that it may go well for me because of you and my life will be spared on account of you.” ");
INSERT INTO engnet_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","When Abram entered Egypt, the Egyptians saw that the woman was very beautiful. ");
INSERT INTO engnet_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","When Pharaoh’s officials saw her, they praised her to Pharaoh. So Abram’s wife was taken into the household of Pharaoh, ");
INSERT INTO engnet_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","and he did treat Abram well on account of her. Abram received sheep and cattle, male donkeys, male servants, female servants, female donkeys, and camels. ");
INSERT INTO engnet_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","But the Lord struck Pharaoh and his household with severe diseases because of Sarai, Abram’s wife. ");
INSERT INTO engnet_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","So Pharaoh summoned Abram and said, “What is this you have done to me? Why didn’t you tell me that she was your wife? ");
INSERT INTO engnet_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, ‘She is my sister,’ so that I took her to be my wife? Here is your wife! Take her and go!” ");
INSERT INTO engnet_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaoh gave his men orders about Abram, and so they expelled him, along with his wife and all his possessions. ");
INSERT INTO engnet_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram went up from Egypt into the Negev. He took his wife and all his possessions with him, as well as Lot. ");
INSERT INTO engnet_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","(Now Abram was very wealthy in livestock, silver, and gold.) ");
INSERT INTO engnet_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","And he journeyed from place to place from the Negev as far as Bethel. He returned to the place where he had pitched his tent at the beginning, between Bethel and Ai. ");
INSERT INTO engnet_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","This was the place where he had first built the altar, and there Abram worshiped the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Now Lot, who was traveling with Abram, also had flocks, herds, and tents. ");
INSERT INTO engnet_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","But the land could not support them while they were living side by side. Because their possessions were so great, they were not able to live alongside one another. ");
INSERT INTO engnet_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","So there were quarrels between Abram’s herdsmen and Lot’s herdsmen. (Now the Canaanites and the Perizzites were living in the land at that time.) ");
INSERT INTO engnet_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram said to Lot, “Let there be no quarreling between me and you, and between my herdsmen and your herdsmen, for we are close relatives. ");
INSERT INTO engnet_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not the whole land before you? Separate yourself now from me. If you go to the left, then I’ll go to the right, but if you go to the right, then I’ll go to the left.” ");
INSERT INTO engnet_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked up and saw the whole region of the Jordan. He noticed that all of it was well-watered (before the Lord obliterated Sodom and Gomorrah) like the garden of the Lord, like the land of Egypt, all the way to Zoar. ");
INSERT INTO engnet_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot chose for himself the whole region of the Jordan and traveled toward the east. So the relatives separated from each other. ");
INSERT INTO engnet_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram settled in the land of Canaan, but Lot settled among the cities of the Jordan plain and pitched his tents next to Sodom. ");
INSERT INTO engnet_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","(Now the people of Sodom were extremely wicked rebels against the Lord.) ");
INSERT INTO engnet_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After Lot had departed, the Lord said to Abram, “Look from the place where you stand to the north, south, east, and west. ");
INSERT INTO engnet_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I will give all the land that you see to you and your descendants forever. ");
INSERT INTO engnet_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","And I will make your descendants like the dust of the earth, so that if anyone is able to count the dust of the earth, then your descendants also can be counted. ");
INSERT INTO engnet_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Get up and walk throughout the land, for I will give it to you.” ");
INSERT INTO engnet_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram moved his tents and went to live by the oaks of Mamre in Hebron, and he built an altar to the Lord there. ");
INSERT INTO engnet_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","At that time Amraphel king of Shinar, Arioch king of Ellasar, Kedorlaomer king of Elam, and Tidal king of nations ");
INSERT INTO engnet_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","went to war against Bera king of Sodom, Birsha king of Gomorrah, Shinab king of Admah, Shemeber king of Zeboiim, and the king of Bela (that is, Zoar). ");
INSERT INTO engnet_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","These last five kings joined forces in the Valley of Siddim (that is, the Salt Sea). ");
INSERT INTO engnet_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","For twelve years they had served Kedorlaomer, but in the thirteenth year they rebelled. ");
INSERT INTO engnet_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In the fourteenth year, Kedorlaomer and the kings who were his allies came and defeated the Rephaites in Ashteroth Karnaim, the Zuzites in Ham, the Emites in Shaveh Kiriathaim, ");
INSERT INTO engnet_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in their hill country of Seir, as far as El Paran, which is near the desert. ");
INSERT INTO engnet_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they attacked En Mishpat (that is, Kadesh) again, and they conquered all the territory of the Amalekites, as well as the Amorites who were living in Hazazon Tamar. ");
INSERT INTO engnet_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Then the king of Sodom, the king of Gomorrah, the king of Admah, the king of Zeboiim, and the king of Bela (that is, Zoar) went out and prepared for battle. In the Valley of Siddim they met ");
INSERT INTO engnet_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedorlaomer king of Elam, Tidal king of nations, Amraphel king of Shinar, and Arioch king of Ellasar. Four kings fought against five. ");
INSERT INTO engnet_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Now the Valley of Siddim was full of tar pits. When the kings of Sodom and Gomorrah fled, they fell into them, but some survivors fled to the hills. ");
INSERT INTO engnet_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","The four victorious kings took all the possessions and food of Sodom and Gomorrah and left. ");
INSERT INTO engnet_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They also took Abram’s nephew Lot and his possessions when they left, for Lot was living in Sodom. ");
INSERT INTO engnet_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A fugitive came and told Abram the Hebrew. Now Abram was living by the oaks of Mamre the Amorite, the brother of Eshcol and Aner. (All these were allied by treaty with Abram.) ");
INSERT INTO engnet_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","When Abram heard that his nephew had been taken captive, he mobilized his 318 trained men who had been born in his household, and he pursued the invaders as far as Dan. ");
INSERT INTO engnet_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Then, during the night, Abram divided his forces against them and defeated them. He chased them as far as Hobah, which is north of Damascus. ");
INSERT INTO engnet_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","He retrieved all the stolen property. He also brought back his nephew Lot and his possessions, as well as the women and the rest of the people. ");
INSERT INTO engnet_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","After Abram returned from defeating Kedorlaomer and the kings who were with him, the king of Sodom went out to meet Abram in the Valley of Shaveh (known as the King’s Valley). ");
INSERT INTO engnet_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchizedek king of Salem brought out bread and wine. (Now he was the priest of the Most High God.) ");
INSERT INTO engnet_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","He blessed Abram, saying, “Blessed be Abram by the Most High God, Creator of heaven and earth. ");
INSERT INTO engnet_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Worthy of praise is the Most High God, who delivered your enemies into your hand.” Abram gave Melchizedek a tenth of everything. ");
INSERT INTO engnet_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Then the king of Sodom said to Abram, “Give me the people and take the possessions for yourself.” ");
INSERT INTO engnet_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram replied to the king of Sodom, “I raise my hand to the Lord, the Most High God, Creator of heaven and earth, and vow ");
INSERT INTO engnet_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I will take nothing belonging to you, not even a thread or the strap of a sandal. That way you can never say, ‘It is I who made Abram rich.’ ");
INSERT INTO engnet_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","I will take nothing except compensation for what the young men have eaten. As for the share of the men who went with me – Aner, Eshcol, and Mamre – let them take their share.” ");
INSERT INTO engnet_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these things the word of the Lord came to Abram in a vision: “Fear not, Abram! I am your shield and the one who will reward you in great abundance.” ");
INSERT INTO engnet_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","But Abram said, “O sovereign Lord, what will you give me since I continue to be childless, and my heir is Eliezer of Damascus?” ");
INSERT INTO engnet_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram added, “Since you have not given me a descendant, then look, one born in my house will be my heir!” ");
INSERT INTO engnet_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","But look, the word of the Lord came to him: “This man will not be your heir, but instead a son who comes from your own body will be your heir.” ");
INSERT INTO engnet_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","The Lord took him outside and said, “Gaze into the sky and count the stars – if you are able to count them!” Then he said to him, “So will your descendants be.” ");
INSERT INTO engnet_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram believed the Lord, and the Lord considered his response of faith as proof of genuine loyalty. ");
INSERT INTO engnet_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","The Lord said to him, “I am the Lord who brought you out from Ur of the Chaldeans to give you this land to possess.” ");
INSERT INTO engnet_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","But Abram said, “O sovereign Lord, by what can I know that I am to possess it?” ");
INSERT INTO engnet_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","The Lord said to him, “Take for me a heifer, a goat, and a ram, each three years old, along with a dove and a young pigeon.” ");
INSERT INTO engnet_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","So Abram took all these for him and then cut them in two and placed each half opposite the other, but he did not cut the birds in half. ");
INSERT INTO engnet_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","When birds of prey came down on the carcasses, Abram drove them away. ");
INSERT INTO engnet_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","When the sun went down, Abram fell sound asleep, and great terror overwhelmed him. ");
INSERT INTO engnet_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Then the Lord said to Abram, “Know for certain that your descendants will be strangers in a foreign country. They will be enslaved and oppressed for four hundred years. ");
INSERT INTO engnet_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","But I will execute judgment on the nation that they will serve. Afterward they will come out with many possessions. ");
INSERT INTO engnet_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","But as for you, you will go to your ancestors in peace and be buried at a good old age. ");
INSERT INTO engnet_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","In the fourth generation your descendants will return here, for the sin of the Amorites has not yet reached its limit.” ");
INSERT INTO engnet_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","When the sun had gone down and it was dark, a smoking firepot with a flaming torch passed between the animal parts. ");
INSERT INTO engnet_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","That day the Lord made a covenant with Abram: “To your descendants I give this land, from the river of Egypt to the great river, the Euphrates River – ");
INSERT INTO engnet_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","the land of the Kenites, Kenizzites, Kadmonites, ");
INSERT INTO engnet_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittites, Perizzites, Rephaites, ");
INSERT INTO engnet_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorites, Canaanites, Girgashites, and Jebusites.” ");
INSERT INTO engnet_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Sarai, Abram’s wife, had not given birth to any children, but she had an Egyptian servant named Hagar. ");
INSERT INTO engnet_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","So Sarai said to Abram, “Since the Lord has prevented me from having children, have sexual relations with my servant. Perhaps I can have a family by her.” Abram did what Sarai told him. ");
INSERT INTO engnet_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So after Abram had lived in Canaan for ten years, Sarai, Abram’s wife, gave Hagar, her Egyptian servant, to her husband to be his wife. ");
INSERT INTO engnet_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","He had sexual relations with Hagar, and she became pregnant. Once Hagar realized she was pregnant, she despised Sarai. ");
INSERT INTO engnet_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai said to Abram, “You have brought this wrong on me! I allowed my servant to have sexual relations with you, but when she realized that she was pregnant, she despised me. May the Lord judge between you and me!” ");
INSERT INTO engnet_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram said to Sarai, “Since your servant is under your authority, do to her whatever you think best.” Then Sarai treated Hagar harshly, so she ran away from Sarai. ");
INSERT INTO engnet_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","The Lord’s angel found Hagar near a spring of water in the desert – the spring that is along the road to Shur. ");
INSERT INTO engnet_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He said, “Hagar, servant of Sarai, where have you come from, and where are you going?” She replied, “I’m running away from my mistress, Sarai.” ");
INSERT INTO engnet_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Then the Lord’s angel said to her, “Return to your mistress and submit to her authority. ");
INSERT INTO engnet_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","I will greatly multiply your descendants,” the Lord’s angel added, “so that they will be too numerous to count.” ");
INSERT INTO engnet_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Then the Lord’s angel said to her, “You are now pregnant and are about to give birth to a son. You are to name him Ishmael, for the Lord has heard your painful groans. ");
INSERT INTO engnet_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He will be a wild donkey of a man. He will be hostile to everyone, and everyone will be hostile to him. He will live away from his brothers.” ");
INSERT INTO engnet_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","So Hagar named the Lord who spoke to her, “You are the God who sees me,” for she said, “Here I have seen one who sees me!” ");
INSERT INTO engnet_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","That is why the well was called Beer Lahai Roi. (It is located between Kadesh and Bered.) ");
INSERT INTO engnet_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","So Hagar gave birth to Abram’s son, whom Abram named Ishmael. ");
INSERT INTO engnet_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","(Now Abram was 86 years old when Hagar gave birth to Ishmael.) ");
INSERT INTO engnet_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was 99 years old, the Lord appeared to him and said, “I am the sovereign God. Walk before me and be blameless. ");
INSERT INTO engnet_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Then I will confirm my covenant between me and you, and I will give you a multitude of descendants.” ");
INSERT INTO engnet_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram bowed down with his face to the ground, and God said to him, ");
INSERT INTO engnet_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“As for me, this is my covenant with you: You will be the father of a multitude of nations. ");
INSERT INTO engnet_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","No longer will your name be Abram. Instead, your name will be Abraham because I will make you the father of a multitude of nations. ");
INSERT INTO engnet_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make you extremely fruitful. I will make nations of you, and kings will descend from you. ");
INSERT INTO engnet_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I will confirm my covenant as a perpetual covenant between me and you. It will extend to your descendants after you throughout their generations. I will be your God and the God of your descendants after you. ");
INSERT INTO engnet_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I will give the whole land of Canaan – the land where you are now residing – to you and your descendants after you as a permanent possession. I will be their God.” ");
INSERT INTO engnet_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God said to Abraham, “As for you, you must keep the covenantal requirement I am imposing on you and your descendants after you throughout their generations. ");
INSERT INTO engnet_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is my requirement that you and your descendants after you must keep: Every male among you must be circumcised. ");
INSERT INTO engnet_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You must circumcise the flesh of your foreskins. This will be a reminder of the covenant between me and you. ");
INSERT INTO engnet_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Throughout your generations every male among you who is eight days old must be circumcised, whether born in your house or bought with money from any foreigner who is not one of your descendants. ");
INSERT INTO engnet_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","They must indeed be circumcised, whether born in your house or bought with money. The sign of my covenant will be visible in your flesh as a permanent reminder. ");
INSERT INTO engnet_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Any uncircumcised male who has not been circumcised in the flesh of his foreskin will be cut off from his people – he has failed to carry out my requirement.” ");
INSERT INTO engnet_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Then God said to Abraham, “As for your wife, you must no longer call her Sarai; Sarah will be her name. ");
INSERT INTO engnet_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her and will give you a son through her. I will bless her and she will become a mother of nations. Kings of countries will come from her!” ");
INSERT INTO engnet_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Then Abraham bowed down with his face to the ground and laughed as he said to himself, “Can a son be born to a man who is a hundred years old? Can Sarah bear a child at the age of ninety?” ");
INSERT INTO engnet_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham said to God, “O that Ishmael might live before you!” ");
INSERT INTO engnet_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God said, “No, Sarah your wife is going to bear you a son, and you will name him Isaac. I will confirm my covenant with him as a perpetual covenant for his descendants after him. ");
INSERT INTO engnet_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have heard you. I will indeed bless him, make him fruitful, and give him a multitude of descendants. He will become the father of twelve princes; I will make him into a great nation. ");
INSERT INTO engnet_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But I will establish my covenant with Isaac, whom Sarah will bear to you at this set time next year.” ");
INSERT INTO engnet_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When he finished speaking with Abraham, God went up from him. ");
INSERT INTO engnet_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham took his son Ishmael and every male in his household (whether born in his house or bought with money) and circumcised them on that very same day, just as God had told him to do. ");
INSERT INTO engnet_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Now Abraham was 99 years old when he was circumcised; ");
INSERT INTO engnet_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","his son Ishmael was thirteen years old when he was circumcised. ");
INSERT INTO engnet_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham and his son Ishmael were circumcised on the very same day. ");
INSERT INTO engnet_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","All the men of his household, whether born in his household or bought with money from a foreigner, were circumcised with him. ");
INSERT INTO engnet_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","The Lord appeared to Abraham by the oaks of Mamre while he was sitting at the entrance to his tent during the hottest time of the day. ");
INSERT INTO engnet_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham looked up and saw three men standing across from him. When he saw them he ran from the entrance of the tent to meet them and bowed low to the ground. ");
INSERT INTO engnet_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","He said, “My lord, if I have found favor in your sight, do not pass by and leave your servant. ");
INSERT INTO engnet_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let a little water be brought so that you may all wash your feet and rest under the tree. ");
INSERT INTO engnet_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","And let me get a bit of food so that you may refresh yourselves since you have passed by your servant’s home. After that you may be on your way.” “All right,” they replied, “you may do as you say.” ");
INSERT INTO engnet_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","So Abraham hurried into the tent and said to Sarah, “Quick! Take three measures of fine flour, knead it, and make bread.” ");
INSERT INTO engnet_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then Abraham ran to the herd and chose a fine, tender calf, and gave it to a servant, who quickly prepared it. ");
INSERT INTO engnet_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abraham then took some curds and milk, along with the calf that had been prepared, and placed the food before them. They ate while he was standing near them under a tree. ");
INSERT INTO engnet_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Then they asked him, “Where is Sarah your wife?” He replied, “There, in the tent.” ");
INSERT INTO engnet_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","One of them said, “I will surely return to you when the season comes round again, and your wife Sarah will have a son!” (Now Sarah was listening at the entrance to the tent, not far behind him. ");
INSERT INTO engnet_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham and Sarah were old and advancing in years; Sarah had long since passed menopause.) ");
INSERT INTO engnet_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","So Sarah laughed to herself, thinking, “After I am worn out will I have pleasure, especially when my husband is old too?” ");
INSERT INTO engnet_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","The Lord said to Abraham, “Why did Sarah laugh and say, ‘Will I really have a child when I am old?’ ");
INSERT INTO engnet_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is anything impossible for the Lord? I will return to you when the season comes round again and Sarah will have a son.” ");
INSERT INTO engnet_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Then Sarah lied, saying, “I did not laugh,” because she was afraid. But the Lord said, “No! You did laugh.” ");
INSERT INTO engnet_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","When the men got up to leave, they looked out over Sodom. (Now Abraham was walking with them to see them on their way.) ");
INSERT INTO engnet_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Then the Lord said, “Should I hide from Abraham what I am about to do? ");
INSERT INTO engnet_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","After all, Abraham will surely become a great and powerful nation, and all the nations on the earth will pronounce blessings on one another using his name. ");
INSERT INTO engnet_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I have chosen him so that he may command his children and his household after him to keep the way of the Lord by doing what is right and just. Then the Lord will give to Abraham what he promised him.” ");
INSERT INTO engnet_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","So the Lord said, “The outcry against Sodom and Gomorrah is so great and their sin so blatant ");
INSERT INTO engnet_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","that I must go down and see if they are as wicked as the outcry suggests. If not, I want to know.” ");
INSERT INTO engnet_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","The two men turned and headed toward Sodom, but Abraham was still standing before the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham approached and said, “Will you sweep away the godly along with the wicked? ");
INSERT INTO engnet_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What if there are fifty godly people in the city? Will you really wipe it out and not spare the place for the sake of the fifty godly people who are in it? ");
INSERT INTO engnet_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Far be it from you to do such a thing – to kill the godly with the wicked, treating the godly and the wicked alike! Far be it from you! Will not the judge of the whole earth do what is right?” ");
INSERT INTO engnet_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","So the Lord replied, “If I find in the city of Sodom fifty godly people, I will spare the whole place for their sake.” ");
INSERT INTO engnet_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Then Abraham asked, “Since I have undertaken to speak to the Lord (although I am but dust and ashes), ");
INSERT INTO engnet_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","what if there are five less than the fifty godly people? Will you destroy the whole city because five are lacking?” He replied, “I will not destroy it if I find forty-five there.” ");
INSERT INTO engnet_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham spoke to him again, “What if forty are found there?” He replied, “I will not do it for the sake of the forty.” ");
INSERT INTO engnet_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Then Abraham said, “May the Lord not be angry so that I may speak! What if thirty are found there?” He replied, “I will not do it if I find thirty there.” ");
INSERT INTO engnet_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham said, “Since I have undertaken to speak to the Lord, what if only twenty are found there?” He replied, “I will not destroy it for the sake of the twenty.” ");
INSERT INTO engnet_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Finally Abraham said, “May the Lord not be angry so that I may speak just once more. What if ten are found there?” He replied, “I will not destroy it for the sake of the ten.” ");
INSERT INTO engnet_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","The Lord went on his way when he had finished speaking to Abraham. Then Abraham returned home. ");
INSERT INTO engnet_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","The two angels came to Sodom in the evening while Lot was sitting in the city’s gateway. When Lot saw them, he got up to meet them and bowed down with his face toward the ground. ");
INSERT INTO engnet_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","He said, “Here, my lords, please turn aside to your servant’s house. Stay the night and wash your feet. Then you can be on your way early in the morning.” “No,” they replied, “we’ll spend the night in the town square.” ");
INSERT INTO engnet_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But he urged them persistently, so they turned aside with him and entered his house. He prepared a feast for them, including bread baked without yeast, and they ate. ");
INSERT INTO engnet_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Before they could lie down to sleep, all the men – both young and old, from every part of the city of Sodom – surrounded the house. ");
INSERT INTO engnet_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They shouted to Lot, “Where are the men who came to you tonight? Bring them out to us so we can have sex with them!” ");
INSERT INTO engnet_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went outside to them, shutting the door behind him. ");
INSERT INTO engnet_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said, “No, my brothers! Don’t act so wickedly! ");
INSERT INTO engnet_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Look, I have two daughters who have never had sexual relations with a man. Let me bring them out to you, and you can do to them whatever you please. Only don’t do anything to these men, for they have come under the protection of my roof.” ");
INSERT INTO engnet_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Out of our way!” they cried, and “This man came to live here as a foreigner, and now he dares to judge us! We’ll do more harm to you than to them!” They kept pressing in on Lot until they were close enough to break down the door. ");
INSERT INTO engnet_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","So the men inside reached out and pulled Lot back into the house as they shut the door. ");
INSERT INTO engnet_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then they struck the men who were at the door of the house, from the youngest to the oldest, with blindness. The men outside wore themselves out trying to find the door. ");
INSERT INTO engnet_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Then the two visitors said to Lot, “Who else do you have here? Do you have any sons-in-law, sons, daughters, or other relatives in the city? Get them out of this place ");
INSERT INTO engnet_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","because we are about to destroy it. The outcry against this place is so great before the Lord that he has sent us to destroy it.” ");
INSERT INTO engnet_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Then Lot went out and spoke to his sons-in-law who were going to marry his daughters. He said, “Quick, get out of this place because the Lord is about to destroy the city!” But his sons-in-law thought he was ridiculing them. ");
INSERT INTO engnet_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","At dawn the angels hurried Lot along, saying, “Get going! Take your wife and your two daughters who are here, or else you will be destroyed when the city is judged!” ");
INSERT INTO engnet_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","When Lot hesitated, the men grabbed his hand and the hands of his wife and two daughters because the Lord had compassion on them. They led them away and placed them outside the city. ");
INSERT INTO engnet_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","When they had brought them outside, they said, “Run for your lives! Don’t look behind you or stop anywhere in the valley! Escape to the mountains or you will be destroyed!” ");
INSERT INTO engnet_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","But Lot said to them, “No, please, Lord! ");
INSERT INTO engnet_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Your servant has found favor with you, and you have shown me great kindness by sparing my life. But I am not able to escape to the mountains because this disaster will overtake me and I’ll die. ");
INSERT INTO engnet_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, this town over here is close enough to escape to, and it’s just a little one. Let me go there. It’s just a little place, isn’t it? Then I’ll survive.” ");
INSERT INTO engnet_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Very well,” he replied, “I will grant this request too and will not overthrow the town you mentioned. ");
INSERT INTO engnet_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Run there quickly, for I cannot do anything until you arrive there.” (This incident explains why the town was called Zoar.) ");
INSERT INTO engnet_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun had just risen over the land as Lot reached Zoar. ");
INSERT INTO engnet_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then the Lord rained down sulfur and fire on Sodom and Gomorrah. It was sent down from the sky by the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","So he overthrew those cities and all that region, including all the inhabitants of the cities and the vegetation that grew from the ground. ");
INSERT INTO engnet_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot’s wife looked back longingly and was turned into a pillar of salt. ");
INSERT INTO engnet_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham got up early in the morning and went to the place where he had stood before the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked out toward Sodom and Gomorrah and all the land of that region. As he did so, he saw the smoke rising up from the land like smoke from a furnace. ");
INSERT INTO engnet_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","So when God destroyed the cities of the region, God honored Abraham’s request. He removed Lot from the midst of the destruction when he destroyed the cities Lot had lived in. ");
INSERT INTO engnet_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot went up from Zoar with his two daughters and settled in the mountains because he was afraid to live in Zoar. So he lived in a cave with his two daughters. ");
INSERT INTO engnet_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Later the older daughter said to the younger, “Our father is old, and there is no man anywhere nearby to have sexual relations with us, according to the way of all the world. ");
INSERT INTO engnet_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let’s make our father drunk with wine so we can have sexual relations with him and preserve our family line through our father.” ");
INSERT INTO engnet_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So that night they made their father drunk with wine, and the older daughter came and had sexual relations with her father. But he was not aware that she had sexual relations with him and then got up. ");
INSERT INTO engnet_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","So in the morning the older daughter said to the younger, “Since I had sexual relations with my father last night, let’s make him drunk again tonight. Then you go and have sexual relations with him so we can preserve our family line through our father.” ");
INSERT INTO engnet_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So they made their father drunk that night as well, and the younger one came and had sexual relations with him. But he was not aware that she had sexual relations with him and then got up. ");
INSERT INTO engnet_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","In this way both of Lot’s daughters became pregnant by their father. ");
INSERT INTO engnet_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The older daughter gave birth to a son and named him Moab. He is the ancestor of the Moabites of today. ");
INSERT INTO engnet_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger daughter also gave birth to a son and named him Ben-Ammi. He is the ancestor of the Ammonites of today. ");
INSERT INTO engnet_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham journeyed from there to the Negev region and settled between Kadesh and Shur. While he lived as a temporary resident in Gerar, ");
INSERT INTO engnet_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham said about his wife Sarah, “She is my sister.” So Abimelech, king of Gerar, sent for Sarah and took her. ");
INSERT INTO engnet_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God appeared to Abimelech in a dream at night and said to him, “You are as good as dead because of the woman you have taken, for she is someone else’s wife.” ");
INSERT INTO engnet_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Now Abimelech had not gone near her. He said, “Lord, would you really slaughter an innocent nation? ");
INSERT INTO engnet_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Did Abraham not say to me, ‘She is my sister’? And she herself said, ‘He is my brother.’ I have done this with a clear conscience and with innocent hands!” ");
INSERT INTO engnet_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Then in the dream God replied to him, “Yes, I know that you have done this with a clear conscience. That is why I have kept you from sinning against me and why I did not allow you to touch her. ");
INSERT INTO engnet_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","But now give back the man’s wife. Indeed he is a prophet and he will pray for you; thus you will live. But if you don’t give her back, know that you will surely die along with all who belong to you.” ");
INSERT INTO engnet_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Early in the morning Abimelech summoned all his servants. When he told them about all these things, they were terrified. ");
INSERT INTO engnet_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelech summoned Abraham and said to him, “What have you done to us? What sin did I commit against you that would cause you to bring such great guilt on me and my kingdom? You have done things to me that should not be done!” ");
INSERT INTO engnet_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Then Abimelech asked Abraham, “What prompted you to do this thing?” ");
INSERT INTO engnet_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham replied, “Because I thought, ‘Surely no one fears God in this place. They will kill me because of my wife.’ ");
INSERT INTO engnet_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","What’s more, she is indeed my sister, my father’s daughter, but not my mother’s daughter. She became my wife. ");
INSERT INTO engnet_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","When God made me wander from my father’s house, I told her, ‘This is what you can do to show your loyalty to me: Every place we go, say about me, “He is my brother.”’” ");
INSERT INTO engnet_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","So Abimelech gave sheep, cattle, and male and female servants to Abraham. He also gave his wife Sarah back to him. ");
INSERT INTO engnet_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Then Abimelech said, “Look, my land is before you; live wherever you please.” ");
INSERT INTO engnet_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","To Sarah he said, “Look, I have given a thousand pieces of silver to your ‘brother.’ This is compensation for you so that you will stand vindicated before all who are with you.” ");
INSERT INTO engnet_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham prayed to God, and God healed Abimelech, as well as his wife and female slaves so that they were able to have children. ");
INSERT INTO engnet_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For the Lord had caused infertility to strike every woman in the household of Abimelech because he took Sarah, Abraham’s wife. ");
INSERT INTO engnet_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","The Lord visited Sarah just as he had said he would and did for Sarah what he had promised. ");
INSERT INTO engnet_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","So Sarah became pregnant and bore Abraham a son in his old age at the appointed time that God had told him. ");
INSERT INTO engnet_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham named his son – whom Sarah bore to him – Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","When his son Isaac was eight days old, Abraham circumcised him just as God had commanded him to do. ");
INSERT INTO engnet_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","(Now Abraham was a hundred years old when his son Isaac was born to him.) ");
INSERT INTO engnet_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah said, “God has made me laugh. Everyone who hears about this will laugh with me.” ");
INSERT INTO engnet_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She went on to say, “Who would have said to Abraham that Sarah would nurse children? Yet I have given birth to a son for him in his old age!” ");
INSERT INTO engnet_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The child grew and was weaned. Abraham prepared a great feast on the day that Isaac was weaned. ");
INSERT INTO engnet_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","But Sarah noticed the son of Hagar the Egyptian – the son whom Hagar had borne to Abraham – mocking. ");
INSERT INTO engnet_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","So she said to Abraham, “Banish that slave woman and her son, for the son of that slave woman will not be an heir along with my son Isaac!” ");
INSERT INTO engnet_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sarah’s demand displeased Abraham greatly because Ishmael was his son. ");
INSERT INTO engnet_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Do not be upset about the boy or your slave wife. Do all that Sarah is telling you because through Isaac your descendants will be counted. ");
INSERT INTO engnet_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","But I will also make the son of the slave wife into a great nation, for he is your descendant too.” ");
INSERT INTO engnet_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Early in the morning Abraham took some food and a skin of water and gave them to Hagar. He put them on her shoulders, gave her the child, and sent her away. So she went wandering aimlessly through the wilderness of Beer Sheba. ");
INSERT INTO engnet_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","When the water in the skin was gone, she shoved the child under one of the shrubs. ");
INSERT INTO engnet_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Then she went and sat down by herself across from him at quite a distance, about a bowshot away; for she thought, “I refuse to watch the child die.” So she sat across from him and wept uncontrollably. ");
INSERT INTO engnet_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","But God heard the boy’s voice. The angel of God called to Hagar from heaven and asked her, “What is the matter, Hagar? Don’t be afraid, for God has heard the boy’s voice right where he is crying. ");
INSERT INTO engnet_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Get up! Help the boy up and hold him by the hand, for I will make him into a great nation.” ");
INSERT INTO engnet_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God enabled Hagar to see a well of water. She went over and filled the skin with water, and then gave the boy a drink. ");
INSERT INTO engnet_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God was with the boy as he grew. He lived in the wilderness and became an archer. ");
INSERT INTO engnet_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He lived in the wilderness of Paran. His mother found a wife for him from the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","At that time Abimelech and Phicol, the commander of his army, said to Abraham, “God is with you in all that you do. ");
INSERT INTO engnet_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now swear to me right here in God’s name that you will not deceive me, my children, or my descendants. Show me, and the land where you are staying, the same loyalty that I have shown you.” ");
INSERT INTO engnet_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham said, “I swear to do this.” ");
INSERT INTO engnet_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","But Abraham lodged a complaint against Abimelech concerning a well that Abimelech’s servants had seized. ");
INSERT INTO engnet_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","“I do not know who has done this thing,” Abimelech replied. “Moreover, you did not tell me. I did not hear about it until today.” ");
INSERT INTO engnet_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham took some sheep and cattle and gave them to Abimelech. The two of them made a treaty. ");
INSERT INTO engnet_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Then Abraham set seven ewe lambs apart from the flock by themselves. ");
INSERT INTO engnet_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech asked Abraham, “What is the meaning of these seven ewe lambs that you have set apart?” ");
INSERT INTO engnet_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","He replied, “You must take these seven ewe lambs from my hand as legal proof that I dug this well.” ");
INSERT INTO engnet_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","That is why he named that place Beer Sheba, because the two of them swore an oath there. ");
INSERT INTO engnet_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So they made a treaty at Beer Sheba. Then Abimelech and Phicol, the commander of his army, returned to the land of the Philistines. ");
INSERT INTO engnet_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a tamarisk tree in Beer Sheba. There he worshiped the Lord, the eternal God. ");
INSERT INTO engnet_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","So Abraham stayed in the land of the Philistines for quite some time. ");
INSERT INTO engnet_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Some time after these things God tested Abraham. He said to him, “Abraham!” “Here I am!” Abraham replied. ");
INSERT INTO engnet_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","God said, “Take your son – your only son, whom you love, Isaac – and go to the land of Moriah! Offer him up there as a burnt offering on one of the mountains which I will indicate to you.” ");
INSERT INTO engnet_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Early in the morning Abraham got up and saddled his donkey. He took two of his young servants with him, along with his son Isaac. When he had cut the wood for the burnt offering, he started out for the place God had spoken to him about. ");
INSERT INTO engnet_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day Abraham caught sight of the place in the distance. ");
INSERT INTO engnet_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","So he said to his servants, “You two stay here with the donkey while the boy and I go up there. We will worship and then return to you.” ");
INSERT INTO engnet_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham took the wood for the burnt offering and put it on his son Isaac. Then he took the fire and the knife in his hand, and the two of them walked on together. ");
INSERT INTO engnet_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac said to his father Abraham, “My father?” “What is it, my son?” he replied. “Here is the fire and the wood,” Isaac said, “but where is the lamb for the burnt offering?” ");
INSERT INTO engnet_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“God will provide for himself the lamb for the burnt offering, my son,” Abraham replied. The two of them continued on together. ");
INSERT INTO engnet_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","When they came to the place God had told him about, Abraham built the altar there and arranged the wood on it. Next he tied up his son Isaac and placed him on the altar on top of the wood. ");
INSERT INTO engnet_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Then Abraham reached out his hand, took the knife, and prepared to slaughter his son. ");
INSERT INTO engnet_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","But the Lord’s angel called to him from heaven, “Abraham! Abraham!” “Here I am!” he answered. ");
INSERT INTO engnet_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Do not harm the boy!” the angel said. “Do not do anything to him, for now I know that you fear God because you did not withhold your son, your only son, from me.” ");
INSERT INTO engnet_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham looked up and saw behind him a ram caught in the bushes by its horns. So he went over and got the ram and offered it up as a burnt offering instead of his son. ");
INSERT INTO engnet_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Abraham called the name of that place “The Lord provides.” It is said to this day, “In the mountain of the Lord provision will be made.” ");
INSERT INTO engnet_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The Lord’s angel called to Abraham a second time from heaven ");
INSERT INTO engnet_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","and said, “‘I solemnly swear by my own name,’ decrees the Lord, ‘that because you have done this and have not withheld your son, your only son, ");
INSERT INTO engnet_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I will indeed bless you, and I will greatly multiply your descendants so that they will be as countless as the stars in the sky or the grains of sand on the seashore. Your descendants will take possession of the strongholds of their enemies. ");
INSERT INTO engnet_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Because you have obeyed me, all the nations of the earth will pronounce blessings on one another using the name of your descendants.’” ");
INSERT INTO engnet_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham returned to his servants, and they set out together for Beer Sheba where Abraham stayed. ");
INSERT INTO engnet_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","After these things Abraham was told, “Milcah also has borne children to your brother Nahor – ");
INSERT INTO engnet_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz the firstborn, his brother Buz, Kemuel (the father of Aram), ");
INSERT INTO engnet_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazo, Pildash, Jidlaph, and Bethuel.” ");
INSERT INTO engnet_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Now Bethuel became the father of Rebekah.) These were the eight sons Milcah bore to Abraham’s brother Nahor. ");
INSERT INTO engnet_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","His concubine, whose name was Reumah, also bore him children – Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engnet_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived 127 years. ");
INSERT INTO engnet_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Then she died in Kiriath Arba (that is, Hebron) in the land of Canaan. Abraham went to mourn for Sarah and to weep for her. ");
INSERT INTO engnet_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Then Abraham got up from mourning his dead wife and said to the sons of Heth, ");
INSERT INTO engnet_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a temporary settler among you. Grant me ownership of a burial site among you so that I may bury my dead.” ");
INSERT INTO engnet_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The sons of Heth answered Abraham, ");
INSERT INTO engnet_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Listen, sir, you are a mighty prince among us! You may bury your dead in the choicest of our tombs. None of us will refuse you his tomb to prevent you from burying your dead.” ");
INSERT INTO engnet_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham got up and bowed down to the local people, the sons of Heth. ");
INSERT INTO engnet_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Then he said to them, “If you agree that I may bury my dead, then hear me out. Ask Ephron the son of Zohar ");
INSERT INTO engnet_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","if he will sell me the cave of Machpelah that belongs to him; it is at the end of his field. Let him sell it to me publicly for the full price, so that I may own it as a burial site.” ");
INSERT INTO engnet_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","(Now Ephron was sitting among the sons of Heth.) Ephron the Hethite replied to Abraham in the hearing of the sons of Heth – before all who entered the gate of his city – ");
INSERT INTO engnet_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, my lord! Hear me out. I sell you both the field and the cave that is in it. In the presence of my people I sell it to you. Bury your dead.” ");
INSERT INTO engnet_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham bowed before the local people ");
INSERT INTO engnet_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","and said to Ephron in their hearing, “Hear me, if you will. I pay to you the price of the field. Take it from me so that I may bury my dead there.” ");
INSERT INTO engnet_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, saying to him, ");
INSERT INTO engnet_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Hear me, my lord. The land is worth 400 pieces of silver, but what is that between me and you? So bury your dead.” ");
INSERT INTO engnet_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","So Abraham agreed to Ephron’s price and weighed out for him the price that Ephron had quoted in the hearing of the sons of Heth – 400 pieces of silver, according to the standard measurement at the time. ");
INSERT INTO engnet_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So Abraham secured Ephron’s field in Machpelah, next to Mamre, including the field, the cave that was in it, and all the trees that were in the field and all around its border, ");
INSERT INTO engnet_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","as his property in the presence of the sons of Heth before all who entered the gate of Ephron’s city. ");
INSERT INTO engnet_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After this Abraham buried his wife Sarah in the cave in the field of Machpelah next to Mamre (that is, Hebron) in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So Abraham secured the field and the cave that was in it as a burial site from the sons of Heth. ");
INSERT INTO engnet_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Now Abraham was old, well advanced in years, and the Lord had blessed him in everything. ");
INSERT INTO engnet_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham said to his servant, the senior one in his household who was in charge of everything he had, “Put your hand under my thigh ");
INSERT INTO engnet_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","so that I may make you solemnly promise by the Lord, the God of heaven and the God of the earth: You must not acquire a wife for my son from the daughters of the Canaanites, among whom I am living. ");
INSERT INTO engnet_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","You must go instead to my country and to my relatives to find a wife for my son Isaac.” ");
INSERT INTO engnet_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant asked him, “What if the woman is not willing to come back with me to this land? Must I then take your son back to the land from which you came?” ");
INSERT INTO engnet_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“Be careful never to take my son back there!” Abraham told him. ");
INSERT INTO engnet_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“The Lord, the God of heaven, who took me from my father’s house and the land of my relatives, promised me with a solemn oath, ‘To your descendants I will give this land.’ He will send his angel before you so that you may find a wife for my son from there. ");
INSERT INTO engnet_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","But if the woman is not willing to come back with you, you will be free from this oath of mine. But you must not take my son back there!” ");
INSERT INTO engnet_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So the servant placed his hand under the thigh of his master Abraham and gave his solemn promise he would carry out his wishes. ");
INSERT INTO engnet_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Then the servant took ten of his master’s camels and departed with all kinds of gifts from his master at his disposal. He journeyed to the region of Aram Naharaim and the city of Nahor. ");
INSERT INTO engnet_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","He made the camels kneel down by the well outside the city. It was evening, the time when the women would go out to draw water. ");
INSERT INTO engnet_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","He prayed, “O Lord, God of my master Abraham, guide me today. Be faithful to my master Abraham. ");
INSERT INTO engnet_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Here I am, standing by the spring, and the daughters of the people who live in the town are coming out to draw water. ");
INSERT INTO engnet_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","I will say to a young woman, ‘Please lower your jar so I may drink.’ May the one you have chosen for your servant Isaac reply, ‘Drink, and I’ll give your camels water too.’ In this way I will know that you have been faithful to my master.” ");
INSERT INTO engnet_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Before he had finished praying, there came Rebekah with her water jug on her shoulder. She was the daughter of Bethuel son of Milcah (Milcah was the wife of Abraham’s brother Nahor). ");
INSERT INTO engnet_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Now the young woman was very beautiful. She was a virgin; no man had ever had sexual relations with her. She went down to the spring, filled her jug, and came back up. ");
INSERT INTO engnet_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham’s servant ran to meet her and said, “Please give me a sip of water from your jug.” ");
INSERT INTO engnet_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Drink, my lord,” she replied, and quickly lowering her jug to her hands, she gave him a drink. ");
INSERT INTO engnet_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","When she had done so, she said, “I’ll draw water for your camels too, until they have drunk as much as they want.” ");
INSERT INTO engnet_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","She quickly emptied her jug into the watering trough and ran back to the well to draw more water until she had drawn enough for all his camels. ");
INSERT INTO engnet_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Silently the man watched her with interest to determine if the Lord had made his journey successful or not. ");
INSERT INTO engnet_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","After the camels had finished drinking, the man took out a gold nose ring weighing a beka and two gold bracelets weighing ten shekels and gave them to her. ");
INSERT INTO engnet_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“Whose daughter are you?” he asked. “Tell me, is there room in your father’s house for us to spend the night?” ");
INSERT INTO engnet_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She said to him, “I am the daughter of Bethuel the son of Milcah, whom Milcah bore to Nahor. ");
INSERT INTO engnet_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","We have plenty of straw and feed,” she added, “and room for you to spend the night.” ");
INSERT INTO engnet_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The man bowed his head and worshiped the Lord, ");
INSERT INTO engnet_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","saying “Praised be the Lord, the God of my master Abraham, who has not abandoned his faithful love for my master! The Lord has led me to the house of my master’s relatives!” ");
INSERT INTO engnet_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","The young woman ran and told her mother’s household all about these things. ");
INSERT INTO engnet_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","(Now Rebekah had a brother named Laban.) Laban rushed out to meet the man at the spring. ");
INSERT INTO engnet_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","When he saw the bracelets on his sister’s wrists and the nose ring and heard his sister Rebekah say, “This is what the man said to me,” he went out to meet the man. There he was, standing by the camels near the spring. ");
INSERT INTO engnet_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban said to him, “Come, you who are blessed by the Lord! Why are you standing out here when I have prepared the house and a place for the camels?” ");
INSERT INTO engnet_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So Abraham’s servant went to the house and unloaded the camels. Straw and feed were given to the camels, and water was provided so that he and the men who were with him could wash their feet. ");
INSERT INTO engnet_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","When food was served, he said, “I will not eat until I have said what I want to say.” “Tell us,” Laban said. ");
INSERT INTO engnet_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“I am the servant of Abraham,” he began. ");
INSERT INTO engnet_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“The Lord has richly blessed my master and he has become very wealthy. The Lord has given him sheep and cattle, silver and gold, male and female servants, and camels and donkeys. ");
INSERT INTO engnet_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","My master’s wife Sarah bore a son to him when she was old, and my master has given him everything he owns. ");
INSERT INTO engnet_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me swear an oath. He said, ‘You must not acquire a wife for my son from the daughters of the Canaanites, among whom I am living, ");
INSERT INTO engnet_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","but you must go to the family of my father and to my relatives to find a wife for my son.’ ");
INSERT INTO engnet_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","But I said to my master, ‘What if the woman does not want to go with me?’ ");
INSERT INTO engnet_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","He answered, ‘The Lord, before whom I have walked, will send his angel with you. He will make your journey a success and you will find a wife for my son from among my relatives, from my father’s family. ");
INSERT INTO engnet_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","You will be free from your oath if you go to my relatives and they will not give her to you. Then you will be free from your oath.’ ");
INSERT INTO engnet_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","When I came to the spring today, I prayed, ‘O Lord, God of my master Abraham, if you have decided to make my journey successful, may events unfold as follows: ");
INSERT INTO engnet_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Here I am, standing by the spring. When the young woman goes out to draw water, I’ll say, “Give me a little water to drink from your jug.” ");
INSERT INTO engnet_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Then she will reply to me, “Drink, and I’ll draw water for your camels too.” May that woman be the one whom the Lord has chosen for my master’s son.’ ");
INSERT INTO engnet_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Before I finished praying in my heart, along came Rebekah with her water jug on her shoulder! She went down to the spring and drew water. So I said to her, ‘Please give me a drink.’ ");
INSERT INTO engnet_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lowered her jug from her shoulder and said, ‘Drink, and I’ll give your camels water too.’ So I drank, and she also gave the camels water. ");
INSERT INTO engnet_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Then I asked her, ‘Whose daughter are you?’ She replied, ‘The daughter of Bethuel the son of Nahor, whom Milcah bore to Nahor.’ I put the ring in her nose and the bracelets on her wrists. ");
INSERT INTO engnet_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I bowed down and worshiped the Lord. I praised the Lord, the God of my master Abraham, who had led me on the right path to find the granddaughter of my master’s brother for his son. ");
INSERT INTO engnet_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now, if you will show faithful love to my master, tell me. But if not, tell me as well, so that I may go on my way.” ");
INSERT INTO engnet_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Laban and Bethuel replied, “This is the Lord’s doing. Our wishes are of no concern. ");
INSERT INTO engnet_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah stands here before you. Take her and go so that she may become the wife of your master’s son, just as the Lord has decided.” ");
INSERT INTO engnet_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham’s servant heard their words, he bowed down to the ground before the Lord. ");
INSERT INTO engnet_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then he brought out gold, silver jewelry, and clothing and gave them to Rebekah. He also gave valuable gifts to her brother and to her mother. ");
INSERT INTO engnet_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","After this, he and the men who were with him ate a meal and stayed there overnight. When they got up in the morning, he said, “Let me leave now so I can return to my master.” ");
INSERT INTO engnet_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But Rebekah’s brother and her mother replied, “Let the girl stay with us a few more days, perhaps ten. Then she can go.” ");
INSERT INTO engnet_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","But he said to them, “Don’t detain me – the Lord has granted me success on my journey. Let me leave now so I may return to my master.” ");
INSERT INTO engnet_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Then they said, “We’ll call the girl and find out what she wants to do.” ");
INSERT INTO engnet_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","So they called Rebekah and asked her, “Do you want to go with this man?” She replied, “I want to go.” ");
INSERT INTO engnet_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they sent their sister Rebekah on her way, accompanied by her female attendant, with Abraham’s servant and his men. ");
INSERT INTO engnet_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","They blessed Rebekah with these words: “Our sister, may you become the mother of thousands of ten thousands! May your descendants possess the strongholds of their enemies.” ");
INSERT INTO engnet_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her female servants mounted the camels and rode away with the man. So Abraham’s servant took Rebekah and left. ");
INSERT INTO engnet_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Now Isaac came from Beer Lahai Roi, for he was living in the Negev. ");
INSERT INTO engnet_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","He went out to relax in the field in the early evening. Then he looked up and saw that there were camels approaching. ");
INSERT INTO engnet_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah looked up and saw Isaac. She got down from her camel ");
INSERT INTO engnet_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","and asked Abraham’s servant, “Who is that man walking in the field toward us?” “That is my master,” the servant replied. So she took her veil and covered herself. ");
INSERT INTO engnet_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant told Isaac everything that had happened. ");
INSERT INTO engnet_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Then Isaac brought Rebekah into his mother Sarah’s tent. He took her as his wife and loved her. So Isaac was comforted after his mother’s death. ");
INSERT INTO engnet_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham had taken another wife, named Keturah. ");
INSERT INTO engnet_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She bore him Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engnet_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan became the father of Sheba and Dedan. The descendants of Dedan were the Asshurites, Letushites, and Leummites. ");
INSERT INTO engnet_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. All these were descendants of Keturah. ");
INSERT INTO engnet_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Everything he owned Abraham left to his son Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But while he was still alive, Abraham gave gifts to the sons of his concubines and sent them off to the east, away from his son Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham lived a total of 175 years. ");
INSERT INTO engnet_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Then Abraham breathed his last and died at a good old age, an old man who had lived a full life. He joined his ancestors. ");
INSERT INTO engnet_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","His sons Isaac and Ishmael buried him in the cave of Machpelah near Mamre, in the field of Ephron the son of Zohar, the Hethite. ");
INSERT INTO engnet_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","This was the field Abraham had purchased from the sons of Heth. There Abraham was buried with his wife Sarah. ");
INSERT INTO engnet_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After Abraham’s death, God blessed his son Isaac. Isaac lived near Beer Lahai Roi. ");
INSERT INTO engnet_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","This is the account of Abraham’s son Ishmael, whom Hagar the Egyptian, Sarah’s servant, bore to Abraham. ");
INSERT INTO engnet_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are the names of Ishmael’s sons, by their names according to their records: Nebaioth (Ishmael’s firstborn), Kedar, Adbeel, Mibsam, ");
INSERT INTO engnet_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engnet_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engnet_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These are the sons of Ishmael, and these are their names by their settlements and their camps – twelve princes according to their clans. ");
INSERT INTO engnet_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived a total of 137 years. He breathed his last and died; then he joined his ancestors. ");
INSERT INTO engnet_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","His descendants settled from Havilah to Shur, which runs next to Egypt all the way to Asshur. They settled away from all their relatives. ");
INSERT INTO engnet_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","This is the account of Isaac, the son of Abraham. Abraham became the father of Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","When Isaac was forty years old, he married Rebekah, the daughter of Bethuel the Aramean from Paddan Aram and sister of Laban the Aramean. ");
INSERT INTO engnet_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac prayed to the Lord on behalf of his wife because she was childless. The Lord answered his prayer, and his wife Rebekah became pregnant. ");
INSERT INTO engnet_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","But the children struggled inside her, and she said, “If it is going to be like this, I’m not so sure I want to be pregnant!” So she asked the Lord, ");
INSERT INTO engnet_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","and the Lord said to her, “Two nations are in your womb, and two peoples will be separated from within you. One people will be stronger than the other, and the older will serve the younger.” ");
INSERT INTO engnet_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When the time came for Rebekah to give birth, there were twins in her womb. ");
INSERT INTO engnet_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first came out reddish all over, like a hairy garment, so they named him Esau. ");
INSERT INTO engnet_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","When his brother came out with his hand clutching Esau’s heel, they named him Jacob. Isaac was sixty years old when they were born. ");
INSERT INTO engnet_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","When the boys grew up, Esau became a skilled hunter, a man of the open fields, but Jacob was an even-tempered man, living in tents. ");
INSERT INTO engnet_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac loved Esau because he had a taste for fresh game, but Rebekah loved Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Now Jacob cooked some stew, and when Esau came in from the open fields, he was famished. ");
INSERT INTO engnet_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","So Esau said to Jacob, “Feed me some of the red stuff – yes, this red stuff – because I’m starving!” (That is why he was also called Edom.) ");
INSERT INTO engnet_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","But Jacob replied, “First sell me your birthright.” ");
INSERT INTO engnet_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Look,” said Esau, “I’m about to die! What use is the birthright to me?” ");
INSERT INTO engnet_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","But Jacob said, “Swear an oath to me now.” So Esau swore an oath to him and sold his birthright to Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave Esau some bread and lentil stew; Esau ate and drank, then got up and went out. So Esau despised his birthright. ");
INSERT INTO engnet_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","There was a famine in the land, subsequent to the earlier famine that occurred in the days of Abraham. Isaac went to Abimelech king of the Philistines at Gerar. ");
INSERT INTO engnet_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","The Lord appeared to Isaac and said, “Do not go down to Egypt; settle down in the land that I will point out to you. ");
INSERT INTO engnet_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay in this land. Then I will be with you and will bless you, for I will give all these lands to you and to your descendants, and I will fulfill the solemn promise I made to your father Abraham. ");
INSERT INTO engnet_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will multiply your descendants so they will be as numerous as the stars in the sky, and I will give them all these lands. All the nations of the earth will pronounce blessings on one another using the name of your descendants. ");
INSERT INTO engnet_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","All this will come to pass because Abraham obeyed me and kept my charge, my commandments, my statutes, and my laws.” ");
INSERT INTO engnet_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac settled in Gerar. ");
INSERT INTO engnet_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","When the men of that place asked him about his wife, he replied, “She is my sister.” He was afraid to say, “She is my wife,” for he thought to himself, “The men of this place will kill me to get Rebekah because she is very beautiful.” ");
INSERT INTO engnet_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","After Isaac had been there a long time, Abimelech king of the Philistines happened to look out a window and observed Isaac caressing his wife Rebekah. ");
INSERT INTO engnet_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","So Abimelech summoned Isaac and said, “She is really your wife! Why did you say, ‘She is my sister’?” Isaac replied, “Because I thought someone might kill me to get her.” ");
INSERT INTO engnet_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Then Abimelech exclaimed, “What in the world have you done to us? One of the men might easily have had sexual relations with your wife, and you would have brought guilt on us!” ");
INSERT INTO engnet_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","So Abimelech commanded all the people, “Whoever touches this man or his wife will surely be put to death.” ");
INSERT INTO engnet_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","When Isaac planted in that land, he reaped in the same year a hundred times what he had sown, because the Lord blessed him. ");
INSERT INTO engnet_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","The man became wealthy. His influence continued to grow until he became very prominent. ");
INSERT INTO engnet_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had so many sheep and cattle and such a great household of servants that the Philistines became jealous of him. ");
INSERT INTO engnet_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So the Philistines took dirt and filled up all the wells that his father’s servants had dug back in the days of his father Abraham. ");
INSERT INTO engnet_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Then Abimelech said to Isaac, “Leave us and go elsewhere, for you have become much more powerful than we are.” ");
INSERT INTO engnet_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac left there and settled in the Gerar Valley. ");
INSERT INTO engnet_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac reopened the wells that had been dug back in the days of his father Abraham, for the Philistines had stopped them up after Abraham died. Isaac gave these wells the same names his father had given them. ");
INSERT INTO engnet_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","When Isaac’s servants dug in the valley and discovered a well with fresh flowing water there, ");
INSERT INTO engnet_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","the herdsmen of Gerar quarreled with Isaac’s herdsmen, saying, “The water belongs to us!” So Isaac named the well Esek because they argued with him about it. ");
INSERT INTO engnet_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","His servants dug another well, but they quarreled over it too, so Isaac named it Sitnah. ");
INSERT INTO engnet_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Then he moved away from there and dug another well. They did not quarrel over it, so Isaac named it Rehoboth, saying, “For now the Lord has made room for us, and we will prosper in the land.” ");
INSERT INTO engnet_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","From there Isaac went up to Beer Sheba. ");
INSERT INTO engnet_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","The Lord appeared to him that night and said, “I am the God of your father Abraham. Do not be afraid, for I am with you. I will bless you and multiply your descendants for the sake of my servant Abraham.” ");
INSERT INTO engnet_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Then Isaac built an altar there and worshiped the Lord. He pitched his tent there, and his servants dug a well. ");
INSERT INTO engnet_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Now Abimelech had come to him from Gerar along with Ahuzzah his friend and Phicol the commander of his army. ");
INSERT INTO engnet_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac asked them, “Why have you come to me? You hate me and sent me away from you.” ");
INSERT INTO engnet_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","They replied, “We could plainly see that the Lord is with you. So we decided there should be a pact between us – between us and you. Allow us to make a treaty with you ");
INSERT INTO engnet_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","so that you will not do us any harm, just as we have not harmed you, but have always treated you well before sending you away in peace. Now you are blessed by the Lord.” ");
INSERT INTO engnet_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac held a feast for them and they celebrated. ");
INSERT INTO engnet_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Early in the morning the men made a treaty with each other. Isaac sent them off; they separated on good terms. ");
INSERT INTO engnet_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","That day Isaac’s servants came and told him about the well they had dug. “We’ve found water,” they reported. ");
INSERT INTO engnet_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","So he named it Shibah; that is why the name of the city has been Beer Sheba to this day. ");
INSERT INTO engnet_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was forty years old, he married Judith the daughter of Beeri the Hittite, as well as Basemath the daughter of Elon the Hittite. ");
INSERT INTO engnet_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","They caused Isaac and Rebekah great anxiety. ");
INSERT INTO engnet_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac was old and his eyes were so weak that he was almost blind, he called his older son Esau and said to him, “My son!” “Here I am!” Esau replied. ");
INSERT INTO engnet_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac said, “Since I am so old, I could die at any time. ");
INSERT INTO engnet_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Therefore, take your weapons – your quiver and your bow – and go out into the open fields and hunt down some wild game for me. ");
INSERT INTO engnet_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Then prepare for me some tasty food, the kind I love, and bring it to me. Then I will eat it so that I may bless you before I die.” ");
INSERT INTO engnet_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Now Rebekah had been listening while Isaac spoke to his son Esau. When Esau went out to the open fields to hunt down some wild game and bring it back, ");
INSERT INTO engnet_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah said to her son Jacob, “Look, I overheard your father tell your brother Esau, ");
INSERT INTO engnet_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bring me some wild game and prepare for me some tasty food. Then I will eat it and bless you in the presence of the Lord before I die.’ ");
INSERT INTO engnet_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now then, my son, do exactly what I tell you! ");
INSERT INTO engnet_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go to the flock and get me two of the best young goats. I’ll prepare them in a tasty way for your father, just the way he loves them. ");
INSERT INTO engnet_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then you will take it to your father. Thus he will eat it and bless you before he dies.” ");
INSERT INTO engnet_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","“But Esau my brother is a hairy man,” Jacob protested to his mother Rebekah, “and I have smooth skin! ");
INSERT INTO engnet_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","My father may touch me! Then he’ll think I’m mocking him and I’ll bring a curse on myself instead of a blessing.” ");
INSERT INTO engnet_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","So his mother told him, “Any curse against you will fall on me, my son! Just obey me! Go and get them for me!” ");
INSERT INTO engnet_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So he went and got the goats and brought them to his mother. She prepared some tasty food, just the way his father loved it. ");
INSERT INTO engnet_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Then Rebekah took her older son Esau’s best clothes, which she had with her in the house, and put them on her younger son Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She put the skins of the young goats on his hands and the smooth part of his neck. ");
INSERT INTO engnet_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then she handed the tasty food and the bread she had made to her son Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","He went to his father and said, “My father!” Isaac replied, “Here I am. Which are you, my son?” ");
INSERT INTO engnet_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau, your firstborn. I’ve done as you told me. Now sit up and eat some of my wild game so that you can bless me.” ");
INSERT INTO engnet_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","But Isaac asked his son, “How in the world did you find it so quickly, my son?” “Because the Lord your God brought it to me,” he replied. ");
INSERT INTO engnet_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Then Isaac said to Jacob, “Come closer so I can touch you, my son, and know for certain if you really are my son Esau.” ");
INSERT INTO engnet_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","So Jacob went over to his father Isaac, who felt him and said, “The voice is Jacob’s, but the hands are Esau’s.” ");
INSERT INTO engnet_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","He did not recognize him because his hands were hairy, like his brother Esau’s hands. So Isaac blessed Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Then he asked, “Are you really my son Esau?” “I am,” Jacob replied. ");
INSERT INTO engnet_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaac said, “Bring some of the wild game for me to eat, my son. Then I will bless you.” So Jacob brought it to him, and he ate it. He also brought him wine, and Isaac drank. ");
INSERT INTO engnet_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then his father Isaac said to him, “Come here and kiss me, my son.” ");
INSERT INTO engnet_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So Jacob went over and kissed him. When Isaac caught the scent of his clothing, he blessed him, saying, “Yes, my son smells like the scent of an open field which the Lord has blessed. ");
INSERT INTO engnet_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","May God give you the dew of the sky and the richness of the earth, and plenty of grain and new wine. ");
INSERT INTO engnet_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","May peoples serve you and nations bow down to you. You will be lord over your brothers, and the sons of your mother will bow down to you. May those who curse you be cursed, and those who bless you be blessed.” ");
INSERT INTO engnet_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac had just finished blessing Jacob, and Jacob had scarcely left his father’s presence, when his brother Esau returned from the hunt. ");
INSERT INTO engnet_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He also prepared some tasty food and brought it to his father. Esau said to him, “My father, get up and eat some of your son’s wild game. Then you can bless me.” ");
INSERT INTO engnet_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","His father Isaac asked, “Who are you?” “I am your firstborn son,” he replied, “Esau!” ");
INSERT INTO engnet_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac began to shake violently and asked, “Then who else hunted game and brought it to me? I ate all of it just before you arrived, and I blessed him. He will indeed be blessed!” ");
INSERT INTO engnet_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard his father’s words, he wailed loudly and bitterly. He said to his father, “Bless me too, my father!” ");
INSERT INTO engnet_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","But Isaac replied, “Your brother came in here deceitfully and took away your blessing.” ");
INSERT INTO engnet_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau exclaimed, “‘Jacob’ is the right name for him! He has tripped me up two times! He took away my birthright, and now, look, he has taken away my blessing!” Then he asked, “Have you not kept back a blessing for me?” ");
INSERT INTO engnet_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac replied to Esau, “Look! I have made him lord over you. I have made all his relatives his servants and provided him with grain and new wine. What is left that I can do for you, my son?” ");
INSERT INTO engnet_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “Do you have only that one blessing, my father? Bless me too!” Then Esau wept loudly. ");
INSERT INTO engnet_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","So his father Isaac said to him, “Indeed, your home will be away from the richness of the earth, and away from the dew of the sky above. ");
INSERT INTO engnet_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will live by your sword but you will serve your brother. When you grow restless, you will tear off his yoke from your neck.” ");
INSERT INTO engnet_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","So Esau hated Jacob because of the blessing his father had given to his brother. Esau said privately, “The time of mourning for my father is near; then I will kill my brother Jacob!” ");
INSERT INTO engnet_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","When Rebekah heard what her older son Esau had said, she quickly summoned her younger son Jacob and told him, “Look, your brother Esau is planning to get revenge by killing you. ");
INSERT INTO engnet_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Now then, my son, do what I say. Run away immediately to my brother Laban in Haran. ");
INSERT INTO engnet_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Live with him for a little while until your brother’s rage subsides. ");
INSERT INTO engnet_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Stay there until your brother’s anger against you subsides and he forgets what you did to him. Then I’ll send someone to bring you back from there. Why should I lose both of you in one day?” ");
INSERT INTO engnet_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah said to Isaac, “I am deeply depressed because of these daughters of Heth. If Jacob were to marry one of these daughters of Heth who live in this land, I would want to die!” ");
INSERT INTO engnet_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","So Isaac called for Jacob and blessed him. Then he commanded him, “You must not marry a Canaanite woman! ");
INSERT INTO engnet_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Leave immediately for Paddan Aram! Go to the house of Bethuel, your mother’s father, and find yourself a wife there, among the daughters of Laban, your mother’s brother. ");
INSERT INTO engnet_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","May the sovereign God bless you! May he make you fruitful and give you a multitude of descendants! Then you will become a large nation. ");
INSERT INTO engnet_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","May he give you and your descendants the blessing he gave to Abraham so that you may possess the land God gave to Abraham, the land where you have been living as a temporary resident.” ");
INSERT INTO engnet_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob on his way, and he went to Paddan Aram, to Laban son of Bethuel the Aramean and brother of Rebekah, the mother of Jacob and Esau. ");
INSERT INTO engnet_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau saw that Isaac had blessed Jacob and sent him off to Paddan Aram to find a wife there. As he blessed him, Isaac commanded him, “You must not marry a Canaanite woman.” ");
INSERT INTO engnet_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jacob obeyed his father and mother and left for Paddan Aram. ");
INSERT INTO engnet_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Then Esau realized that the Canaanite women were displeasing to his father Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So Esau went to Ishmael and married Mahalath, the sister of Nebaioth and daughter of Abraham’s son Ishmael, along with the wives he already had. ");
INSERT INTO engnet_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Meanwhile Jacob left Beer Sheba and set out for Haran. ");
INSERT INTO engnet_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","He reached a certain place where he decided to camp because the sun had gone down. He took one of the stones and placed it near his head. Then he fell asleep in that place ");
INSERT INTO engnet_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","and had a dream. He saw a stairway erected on the earth with its top reaching to the heavens. The angels of God were going up and coming down it ");
INSERT INTO engnet_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","and the Lord stood at its top. He said, “I am the Lord, the God of your grandfather Abraham and the God of your father Isaac. I will give you and your descendants the ground you are lying on. ");
INSERT INTO engnet_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your descendants will be like the dust of the earth, and you will spread out to the west, east, north, and south. All the families of the earth will pronounce blessings on one another using your name and that of your descendants. ");
INSERT INTO engnet_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","I am with you! I will protect you wherever you go and will bring you back to this land. I will not leave you until I have done what I promised you!” ");
INSERT INTO engnet_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Then Jacob woke up and thought, “Surely the Lord is in this place, but I did not realize it!” ");
INSERT INTO engnet_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","He was afraid and said, “What an awesome place this is! This is nothing else than the house of God! This is the gate of heaven!” ");
INSERT INTO engnet_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Early in the morning Jacob took the stone he had placed near his head and set it up as a sacred stone. Then he poured oil on top of it. ");
INSERT INTO engnet_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He called that place Bethel, although the former name of the town was Luz. ");
INSERT INTO engnet_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Then Jacob made a vow, saying, “If God is with me and protects me on this journey I am taking and gives me food to eat and clothing to wear, ");
INSERT INTO engnet_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","and I return safely to my father’s home, then the Lord will become my God. ");
INSERT INTO engnet_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Then this stone that I have set up as a sacred stone will be the house of God, and I will surely give you back a tenth of everything you give me.” ");
INSERT INTO engnet_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","So Jacob moved on and came to the land of the eastern people. ");
INSERT INTO engnet_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","He saw in the field a well with three flocks of sheep lying beside it, because the flocks were watered from that well. Now a large stone covered the mouth of the well. ");
INSERT INTO engnet_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","When all the flocks were gathered there, the shepherds would roll the stone off the mouth of the well and water the sheep. Then they would put the stone back in its place over the well’s mouth. ");
INSERT INTO engnet_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob asked them, “My brothers, where are you from?” They replied, “We’re from Haran.” ");
INSERT INTO engnet_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","So he said to them, “Do you know Laban, the grandson of Nahor?” “We know him,” they said. ");
INSERT INTO engnet_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Is he well?” Jacob asked. They replied, “He is well. Now look, here comes his daughter Rachel with the sheep.” ");
INSERT INTO engnet_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Then Jacob said, “Since it is still the middle of the day, it is not time for the flocks to be gathered. You should water the sheep and then go and let them graze some more.” ");
INSERT INTO engnet_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“We can’t,” they said, “until all the flocks are gathered and the stone is rolled off the mouth of the well. Then we water the sheep.” ");
INSERT INTO engnet_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was still speaking with them, Rachel arrived with her father’s sheep, for she was tending them. ");
INSERT INTO engnet_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","When Jacob saw Rachel, the daughter of his uncle Laban, and the sheep of his uncle Laban, he went over and rolled the stone off the mouth of the well and watered the sheep of his uncle Laban. ");
INSERT INTO engnet_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then Jacob kissed Rachel and began to weep loudly. ");
INSERT INTO engnet_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","When Jacob explained to Rachel that he was a relative of her father and the son of Rebekah, she ran and told her father. ");
INSERT INTO engnet_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","When Laban heard this news about Jacob, his sister’s son, he rushed out to meet him. He embraced him and kissed him and brought him to his house. Jacob told Laban how he was related to him. ");
INSERT INTO engnet_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Then Laban said to him, “You are indeed my own flesh and blood.” So Jacob stayed with him for a month. ");
INSERT INTO engnet_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Then Laban said to Jacob, “Should you work for me for nothing because you are my relative? Tell me what your wages should be.” ");
INSERT INTO engnet_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","(Now Laban had two daughters; the older one was named Leah, and the younger one Rachel. ");
INSERT INTO engnet_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah’s eyes were tender, but Rachel had a lovely figure and beautiful appearance.) ");
INSERT INTO engnet_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Since Jacob had fallen in love with Rachel, he said, “I’ll serve you seven years in exchange for your younger daughter Rachel.” ");
INSERT INTO engnet_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban replied, “I’d rather give her to you than to another man. Stay with me.” ");
INSERT INTO engnet_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob worked for seven years to acquire Rachel. But they seemed like only a few days to him because his love for her was so great. ");
INSERT INTO engnet_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Finally Jacob said to Laban, “Give me my wife, for my time of service is up. I want to have marital relations with her.” ");
INSERT INTO engnet_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban invited all the people of that place and prepared a feast. ");
INSERT INTO engnet_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","In the evening he brought his daughter Leah to Jacob, and Jacob had marital relations with her. ");
INSERT INTO engnet_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban gave his female servant Zilpah to his daughter Leah to be her servant.) ");
INSERT INTO engnet_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","In the morning Jacob discovered it was Leah! So Jacob said to Laban, “What in the world have you done to me! Didn’t I work for you in exchange for Rachel? Why have you tricked me?” ");
INSERT INTO engnet_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","“It is not our custom here,” Laban replied, “to give the younger daughter in marriage before the firstborn. ");
INSERT INTO engnet_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Complete my older daughter’s bridal week. Then we will give you the younger one too, in exchange for seven more years of work.” ");
INSERT INTO engnet_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob did as Laban said. When Jacob completed Leah’s bridal week, Laban gave him his daughter Rachel to be his wife. ");
INSERT INTO engnet_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban gave his female servant Bilhah to his daughter Rachel to be her servant.) ");
INSERT INTO engnet_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob had marital relations with Rachel as well. He loved Rachel more than Leah, so he worked for Laban for seven more years. ");
INSERT INTO engnet_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","When the Lord saw that Leah was unloved, he enabled her to become pregnant while Rachel remained childless. ");
INSERT INTO engnet_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","So Leah became pregnant and gave birth to a son. She named him Reuben, for she said, “The Lord has looked with pity on my oppressed condition. Surely my husband will love me now.” ");
INSERT INTO engnet_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","She became pregnant again and had another son. She said, “Because the Lord heard that I was unloved, he gave me this one too.” So she named him Simeon. ");
INSERT INTO engnet_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","She became pregnant again and had another son. She said, “Now this time my husband will show me affection, because I have given birth to three sons for him.” That is why he was named Levi. ");
INSERT INTO engnet_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","She became pregnant again and had another son. She said, “This time I will praise the Lord.” That is why she named him Judah. Then she stopped having children. ");
INSERT INTO engnet_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","When Rachel saw that she could not give Jacob children, she became jealous of her sister. She said to Jacob, “Give me children or I’ll die!” ");
INSERT INTO engnet_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob became furious with Rachel and exclaimed, “Am I in the place of God, who has kept you from having children?” ");
INSERT INTO engnet_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","She replied, “Here is my servant Bilhah! Have sexual relations with her so that she can bear children for me and I can have a family through her.” ");
INSERT INTO engnet_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So Rachel gave him her servant Bilhah as a wife, and Jacob had marital relations with her. ");
INSERT INTO engnet_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah became pregnant and gave Jacob a son. ");
INSERT INTO engnet_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Then Rachel said, “God has vindicated me. He has responded to my prayer and given me a son.” That is why she named him Dan. ");
INSERT INTO engnet_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah, Rachel’s servant, became pregnant again and gave Jacob another son. ");
INSERT INTO engnet_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Then Rachel said, “I have fought a desperate struggle with my sister, but I have won.” So she named him Naphtali. ");
INSERT INTO engnet_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah saw that she had stopped having children, she gave her servant Zilpah to Jacob as a wife. ");
INSERT INTO engnet_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Soon Leah’s servant Zilpah gave Jacob a son. ");
INSERT INTO engnet_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “How fortunate!” So she named him Gad. ");
INSERT INTO engnet_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Then Leah’s servant Zilpah gave Jacob another son. ");
INSERT INTO engnet_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “How happy I am, for women will call me happy!” So she named him Asher. ");
INSERT INTO engnet_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","At the time of the wheat harvest Reuben went out and found some mandrake plants in a field and brought them to his mother Leah. Rachel said to Leah, “Give me some of your son’s mandrakes.” ");
INSERT INTO engnet_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","But Leah replied, “Wasn’t it enough that you’ve taken away my husband? Would you take away my son’s mandrakes too?” “All right,” Rachel said, “he may sleep with you tonight in exchange for your son’s mandrakes.” ");
INSERT INTO engnet_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","When Jacob came in from the fields that evening, Leah went out to meet him and said, “You must sleep with me because I have paid for your services with my son’s mandrakes.” So he had marital relations with her that night. ");
INSERT INTO engnet_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God paid attention to Leah; she became pregnant and gave Jacob a son for the fifth time. ");
INSERT INTO engnet_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Then Leah said, “God has granted me a reward because I gave my servant to my husband as a wife.” So she named him Issachar. ");
INSERT INTO engnet_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah became pregnant again and gave Jacob a son for the sixth time. ");
INSERT INTO engnet_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Then Leah said, “God has given me a good gift. Now my husband will honor me because I have given him six sons.” So she named him Zebulun. ");
INSERT INTO engnet_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","After that she gave birth to a daughter and named her Dinah. ");
INSERT INTO engnet_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God took note of Rachel. He paid attention to her and enabled her to become pregnant. ");
INSERT INTO engnet_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She became pregnant and gave birth to a son. Then she said, “God has taken away my shame.” ");
INSERT INTO engnet_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She named him Joseph, saying, “May the Lord give me yet another son.” ");
INSERT INTO engnet_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","After Rachel had given birth to Joseph, Jacob said to Laban, “Send me on my way so that I can go home to my own country. ");
INSERT INTO engnet_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Let me take my wives and my children whom I have acquired by working for you. Then I’ll depart, because you know how hard I’ve worked for you.” ");
INSERT INTO engnet_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","But Laban said to him, “If I have found favor in your sight, please stay here, for I have learned by divination that the Lord has blessed me on account of you.” ");
INSERT INTO engnet_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","He added, “Just name your wages – I’ll pay whatever you want.” ");
INSERT INTO engnet_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","“You know how I have worked for you,” Jacob replied, “and how well your livestock have fared under my care. ");
INSERT INTO engnet_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Indeed, you had little before I arrived, but now your possessions have increased many times over. The Lord has blessed you wherever I worked. But now, how long must it be before I do something for my own family too?” ");
INSERT INTO engnet_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","So Laban asked, “What should I give you?” “You don’t need to give me a thing,” Jacob replied, “but if you agree to this one condition, I will continue to care for your flocks and protect them: ");
INSERT INTO engnet_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Let me walk among all your flocks today and remove from them every speckled or spotted sheep, every dark-colored lamb, and the spotted or speckled goats. These animals will be my wages. ");
INSERT INTO engnet_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","My integrity will testify for me later on. When you come to verify that I’ve taken only the wages we agreed on, if I have in my possession any goat that is not speckled or spotted or any sheep that is not dark-colored, it will be considered stolen.” ");
INSERT INTO engnet_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Agreed!” said Laban, “It will be as you say.” ");
INSERT INTO engnet_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","So that day Laban removed the male goats that were streaked or spotted, all the female goats that were speckled or spotted (all that had any white on them), and all the dark-colored lambs, and put them in the care of his sons. ");
INSERT INTO engnet_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Then he separated them from Jacob by a three-day journey, while Jacob was taking care of the rest of Laban’s flocks. ");
INSERT INTO engnet_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","But Jacob took fresh-cut branches from poplar, almond, and plane trees. He made white streaks by peeling them, making the white inner wood in the branches visible. ");
INSERT INTO engnet_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Then he set up the peeled branches in all the watering troughs where the flocks came to drink. He set up the branches in front of the flocks when they were in heat and came to drink. ");
INSERT INTO engnet_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","When the sheep mated in front of the branches, they gave birth to young that were streaked or speckled or spotted. ");
INSERT INTO engnet_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob removed these lambs, but he made the rest of the flock face the streaked and completely dark-colored animals in Laban’s flock. So he made separate flocks for himself and did not mix them with Laban’s flocks. ");
INSERT INTO engnet_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","When the stronger females were in heat, Jacob would set up the branches in the troughs in front of the flock, so they would mate near the branches. ");
INSERT INTO engnet_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But if the animals were weaker, he did not set the branches there. So the weaker animals ended up belonging to Laban and the stronger animals to Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","In this way Jacob became extremely prosperous. He owned large flocks, male and female servants, camels, and donkeys. ");
INSERT INTO engnet_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob heard that Laban’s sons were complaining, “Jacob has taken everything that belonged to our father! He has gotten rich at our father’s expense!” ");
INSERT INTO engnet_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","When Jacob saw the look on Laban’s face, he could tell his attitude toward him had changed. ");
INSERT INTO engnet_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","The Lord said to Jacob, “Return to the land of your fathers and to your relatives. I will be with you.” ");
INSERT INTO engnet_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","So Jacob sent a message for Rachel and Leah to come to the field where his flocks were. ");
INSERT INTO engnet_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","There he said to them, “I can tell that your father’s attitude toward me has changed, but the God of my father has been with me. ");
INSERT INTO engnet_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You know that I’ve worked for your father as hard as I could, ");
INSERT INTO engnet_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","but your father has humiliated me and changed my wages ten times. But God has not permitted him to do me any harm. ");
INSERT INTO engnet_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, ‘The speckled animals will be your wage,’ then the entire flock gave birth to speckled offspring. But if he said, ‘The streaked animals will be your wage,’ then the entire flock gave birth to streaked offspring. ");
INSERT INTO engnet_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","In this way God has snatched away your father’s livestock and given them to me. ");
INSERT INTO engnet_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Once during breeding season I saw in a dream that the male goats mating with the flock were streaked, speckled, and spotted. ");
INSERT INTO engnet_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","In the dream the angel of God said to me, ‘Jacob!’ ‘Here I am!’ I replied. ");
INSERT INTO engnet_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Then he said, ‘Observe that all the male goats mating with the flock are streaked, speckled, or spotted, for I have observed all that Laban has done to you. ");
INSERT INTO engnet_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel, where you anointed the sacred stone and made a vow to me. Now leave this land immediately and return to your native land.’” ");
INSERT INTO engnet_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Then Rachel and Leah replied to him, “Do we still have any portion or inheritance in our father’s house? ");
INSERT INTO engnet_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hasn’t he treated us like foreigners? He not only sold us, but completely wasted the money paid for us! ");
INSERT INTO engnet_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Surely all the wealth that God snatched away from our father belongs to us and to our children. So now do everything God has told you.” ");
INSERT INTO engnet_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","So Jacob immediately put his children and his wives on the camels. ");
INSERT INTO engnet_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","He took away all the livestock he had acquired in Paddan Aram and all his moveable property that he had accumulated. Then he set out toward the land of Canaan to return to his father Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","While Laban had gone to shear his sheep, Rachel stole the household idols that belonged to her father. ");
INSERT INTO engnet_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob also deceived Laban the Aramean by not telling him that he was leaving. ");
INSERT INTO engnet_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","He left with all he owned. He quickly crossed the Euphrates River and headed for the hill country of Gilead. ");
INSERT INTO engnet_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Three days later Laban discovered Jacob had left. ");
INSERT INTO engnet_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","So he took his relatives with him and pursued Jacob for seven days. He caught up with him in the hill country of Gilead. ");
INSERT INTO engnet_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","But God came to Laban the Aramean in a dream at night and warned him, “Be careful that you neither bless nor curse Jacob.” ");
INSERT INTO engnet_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban overtook Jacob, and when Jacob pitched his tent in the hill country of Gilead, Laban and his relatives set up camp there too. ");
INSERT INTO engnet_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","“What have you done?” Laban demanded of Jacob. “You’ve deceived me and carried away my daughters as if they were captives of war! ");
INSERT INTO engnet_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you run away secretly and deceive me? Why didn’t you tell me so I could send you off with a celebration complete with singing, tambourines, and harps? ");
INSERT INTO engnet_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","You didn’t even allow me to kiss my daughters and my grandchildren good-bye. You have acted foolishly! ");
INSERT INTO engnet_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I have the power to do you harm, but the God of your father told me last night, ‘Be careful that you neither bless nor curse Jacob.’ ");
INSERT INTO engnet_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Now I understand that you have gone away because you longed desperately for your father’s house. Yet why did you steal my gods?” ");
INSERT INTO engnet_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","“I left secretly because I was afraid!” Jacob replied to Laban. “I thought you might take your daughters away from me by force. ");
INSERT INTO engnet_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Whoever has taken your gods will be put to death! In the presence of our relatives identify whatever is yours and take it.” (Now Jacob did not know that Rachel had stolen them.) ");
INSERT INTO engnet_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","So Laban entered Jacob’s tent, and Leah’s tent, and the tent of the two female servants, but he did not find the idols. Then he left Leah’s tent and entered Rachel’s. ");
INSERT INTO engnet_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","(Now Rachel had taken the idols and put them inside her camel’s saddle and sat on them.) Laban searched the whole tent, but did not find them. ");
INSERT INTO engnet_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel said to her father, “Don’t be angry, my lord. I cannot stand up in your presence because I am having my period.” So he searched thoroughly, but did not find the idols. ");
INSERT INTO engnet_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob became angry and argued with Laban. “What did I do wrong?” he demanded of Laban. “What sin of mine prompted you to chase after me in hot pursuit? ");
INSERT INTO engnet_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","When you searched through all my goods, did you find anything that belonged to you? Set it here before my relatives and yours, and let them settle the dispute between the two of us! ");
INSERT INTO engnet_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“I have been with you for the past twenty years. Your ewes and female goats have not miscarried, nor have I eaten rams from your flocks. ");
INSERT INTO engnet_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Animals torn by wild beasts I never brought to you; I always absorbed the loss myself. You always made me pay for every missing animal, whether it was taken by day or at night. ");
INSERT INTO engnet_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","I was consumed by scorching heat during the day and by piercing cold at night, and I went without sleep. ");
INSERT INTO engnet_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","This was my lot for twenty years in your house: I worked like a slave for you – fourteen years for your two daughters and six years for your flocks, but you changed my wages ten times! ");
INSERT INTO engnet_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","If the God of my father – the God of Abraham, the one whom Isaac fears – had not been with me, you would certainly have sent me away empty-handed! But God saw how I was oppressed and how hard I worked, and he rebuked you last night.” ");
INSERT INTO engnet_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban replied to Jacob, “These women are my daughters, these children are my grandchildren, and these flocks are my flocks. All that you see belongs to me. But how can I harm these daughters of mine today or the children to whom they have given birth? ");
INSERT INTO engnet_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So now, come, let’s make a formal agreement, you and I, and it will be proof that we have made peace.” ");
INSERT INTO engnet_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob took a stone and set it up as a memorial pillar. ");
INSERT INTO engnet_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Then he said to his relatives, “Gather stones.” So they brought stones and put them in a pile. They ate there by the pile of stones. ");
INSERT INTO engnet_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban called it Jegar Sahadutha, but Jacob called it Galeed. ");
INSERT INTO engnet_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said, “This pile of stones is a witness of our agreement today.” That is why it was called Galeed. ");
INSERT INTO engnet_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","It was also called Mizpah because he said, “May the Lord watch between us when we are out of sight of one another. ");
INSERT INTO engnet_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you mistreat my daughters or if you take wives besides my daughters, although no one else is with us, realize that God is witness to your actions.” ");
INSERT INTO engnet_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","“Here is this pile of stones and this pillar I have set up between me and you,” Laban said to Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","“This pile of stones and the pillar are reminders that I will not pass beyond this pile to come to harm you and that you will not pass beyond this pile and this pillar to come to harm me. ");
INSERT INTO engnet_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham and the god of Nahor, the gods of their father, judge between us.” Jacob took an oath by the God whom his father Isaac feared. ");
INSERT INTO engnet_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then Jacob offered a sacrifice on the mountain and invited his relatives to eat the meal. They ate the meal and spent the night on the mountain. ");
INSERT INTO engnet_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early in the morning Laban kissed his grandchildren and his daughters goodbye and blessed them. Then Laban left and returned home. ");
INSERT INTO engnet_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","So Jacob went on his way and the angels of God met him. ");
INSERT INTO engnet_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When Jacob saw them, he exclaimed, “This is the camp of God!” So he named that place Mahanaim. ");
INSERT INTO engnet_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob sent messengers on ahead to his brother Esau in the land of Seir, the region of Edom. ");
INSERT INTO engnet_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He commanded them, “This is what you must say to my lord Esau: ‘This is what your servant Jacob says: I have been staying with Laban until now. ");
INSERT INTO engnet_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have oxen, donkeys, sheep, and male and female servants. I have sent this message to inform my lord, so that I may find favor in your sight.’” ");
INSERT INTO engnet_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers returned to Jacob and said, “We went to your brother Esau. He is coming to meet you and has four hundred men with him.” ");
INSERT INTO engnet_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob was very afraid and upset. So he divided the people who were with him into two camps, as well as the flocks, herds, and camels. ");
INSERT INTO engnet_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“If Esau attacks one camp,” he thought, “then the other camp will be able to escape.” ");
INSERT INTO engnet_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob prayed, “O God of my father Abraham, God of my father Isaac, O Lord, you said to me, ‘Return to your land and to your relatives and I will make you prosper.’ ");
INSERT INTO engnet_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am not worthy of all the faithful love you have shown your servant. With only my walking stick I crossed the Jordan, but now I have become two camps. ");
INSERT INTO engnet_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Rescue me, I pray, from the hand of my brother Esau, for I am afraid he will come and attack me, as well as the mothers with their children. ");
INSERT INTO engnet_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","But you said, ‘I will certainly make you prosper and will make your descendants like the sand on the seashore, too numerous to count.’” ");
INSERT INTO engnet_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob stayed there that night. Then he sent as a gift to his brother Esau ");
INSERT INTO engnet_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","two hundred female goats and twenty male goats, two hundred ewes and twenty rams, ");
INSERT INTO engnet_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","thirty female camels with their young, forty cows and ten bulls, and twenty female donkeys and ten male donkeys. ");
INSERT INTO engnet_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He entrusted them to his servants, who divided them into herds. He told his servants, “Pass over before me, and keep some distance between one herd and the next.” ");
INSERT INTO engnet_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He instructed the servant leading the first herd, “When my brother Esau meets you and asks, ‘To whom do you belong? Where are you going? Whose herds are you driving?’ ");
INSERT INTO engnet_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","then you must say, ‘They belong to your servant Jacob. They have been sent as a gift to my lord Esau. In fact Jacob himself is behind us.’” ");
INSERT INTO engnet_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He also gave these instructions to the second and third servants, as well as all those who were following the herds, saying, “You must say the same thing to Esau when you meet him. ");
INSERT INTO engnet_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You must also say, ‘In fact your servant Jacob is behind us.’” Jacob thought, “I will first appease him by sending a gift ahead of me. After that I will meet him. Perhaps he will accept me.” ");
INSERT INTO engnet_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the gifts were sent on ahead of him while he spent that night in the camp. ");
INSERT INTO engnet_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","During the night Jacob quickly took his two wives, his two female servants, and his eleven sons and crossed the ford of the Jabbok. ");
INSERT INTO engnet_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","He took them and sent them across the stream along with all his possessions. ");
INSERT INTO engnet_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","So Jacob was left alone. Then a man wrestled with him until daybreak. ");
INSERT INTO engnet_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man saw that he could not defeat Jacob, he struck the socket of his hip so the socket of Jacob’s hip was dislocated while he wrestled with him. ");
INSERT INTO engnet_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then the man said, “Let me go, for the dawn is breaking.” “I will not let you go,” Jacob replied, “unless you bless me.” ");
INSERT INTO engnet_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","The man asked him, “What is your name?” He answered, “Jacob.” ");
INSERT INTO engnet_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“No longer will your name be Jacob,” the man told him, “but Israel, because you have fought with God and with men and have prevailed.” ");
INSERT INTO engnet_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Then Jacob asked, “Please tell me your name.” “Why do you ask my name?” the man replied. Then he blessed Jacob there. ");
INSERT INTO engnet_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","So Jacob named the place Peniel, explaining, “Certainly I have seen God face to face and have survived.” ");
INSERT INTO engnet_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun rose over him as he crossed over Penuel, but he was limping because of his hip. ");
INSERT INTO engnet_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","That is why to this day the Israelites do not eat the sinew which is attached to the socket of the hip, because he struck the socket of Jacob’s hip near the attached sinew. ");
INSERT INTO engnet_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob looked up and saw that Esau was coming along with four hundred men. So he divided the children among Leah, Rachel, and the two female servants. ");
INSERT INTO engnet_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the servants and their children in front, with Leah and her children behind them, and Rachel and Joseph behind them. ");
INSERT INTO engnet_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","But Jacob himself went on ahead of them, and he bowed toward the ground seven times as he approached his brother. ");
INSERT INTO engnet_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","But Esau ran to meet him, embraced him, hugged his neck, and kissed him. Then they both wept. ");
INSERT INTO engnet_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","When Esau looked up and saw the women and the children, he asked, “Who are these people with you?” Jacob replied, “The children whom God has graciously given your servant.” ");
INSERT INTO engnet_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","The female servants came forward with their children and bowed down. ");
INSERT INTO engnet_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Then Leah came forward with her children and they bowed down. Finally Joseph and Rachel came forward and bowed down. ");
INSERT INTO engnet_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau then asked, “What did you intend by sending all these herds to meet me?” Jacob replied, “To find favor in your sight, my lord.” ");
INSERT INTO engnet_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","But Esau said, “I have plenty, my brother. Keep what belongs to you.” ");
INSERT INTO engnet_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“No, please take them,” Jacob said. “If I have found favor in your sight, accept my gift from my hand. Now that I have seen your face and you have accepted me, it is as if I have seen the face of God. ");
INSERT INTO engnet_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please take my present that was brought to you, for God has been generous to me and I have all I need.” When Jacob urged him, he took it. ");
INSERT INTO engnet_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Let’s be on our way! I will go in front of you.” ");
INSERT INTO engnet_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","But Jacob said to him, “My lord knows that the children are young, and that I have to look after the sheep and cattle that are nursing their young. If they are driven too hard for even a single day, all the animals will die. ");
INSERT INTO engnet_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Let my lord go on ahead of his servant. I will travel more slowly, at the pace of the herds and the children, until I come to my lord at Seir.” ");
INSERT INTO engnet_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","So Esau said, “Let me leave some of my men with you.” “Why do that?” Jacob replied. “My lord has already been kind enough to me.” ");
INSERT INTO engnet_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So that same day Esau made his way back to Seir. ");
INSERT INTO engnet_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","But Jacob traveled to Succoth where he built himself a house and made shelters for his livestock. That is why the place was called Succoth. ");
INSERT INTO engnet_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","After he left Paddan Aram, Jacob came safely to the city of Shechem in the land of Canaan, and he camped near the city. ");
INSERT INTO engnet_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Then he purchased the portion of the field where he had pitched his tent; he bought it from the sons of Hamor, Shechem’s father, for a hundred pieces of money. ");
INSERT INTO engnet_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","There he set up an altar and called it “The God of Israel is God.” ");
INSERT INTO engnet_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Now Dinah, Leah’s daughter whom she bore to Jacob, went to meet the young women of the land. ");
INSERT INTO engnet_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","When Shechem son of Hamor the Hivite, who ruled that area, saw her, he grabbed her, forced himself on her, and sexually assaulted her. ");
INSERT INTO engnet_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Then he became very attached to Dinah, Jacob’s daughter. He fell in love with the young woman and spoke romantically to her. ");
INSERT INTO engnet_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shechem said to his father Hamor, “Acquire this young girl as my wife.” ");
INSERT INTO engnet_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","When Jacob heard that Shechem had violated his daughter Dinah, his sons were with the livestock in the field. So Jacob remained silent until they came in. ");
INSERT INTO engnet_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Then Shechem’s father Hamor went to speak with Jacob about Dinah. ");
INSERT INTO engnet_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Now Jacob’s sons had come in from the field when they heard the news. They were offended and very angry because Shechem had disgraced Israel by sexually assaulting Jacob’s daughter, a crime that should not be committed. ");
INSERT INTO engnet_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","But Hamor made this appeal to them: “My son Shechem is in love with your daughter. Please give her to him as his wife. ");
INSERT INTO engnet_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Intermarry with us. Let us marry your daughters, and take our daughters as wives for yourselves. ");
INSERT INTO engnet_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You may live among us, and the land will be open to you. Live in it, travel freely in it, and acquire property in it.” ");
INSERT INTO engnet_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Then Shechem said to Dinah’s father and brothers, “Let me find favor in your sight, and whatever you require of me I’ll give. ");
INSERT INTO engnet_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","You can make the bride price and the gift I must bring very expensive, and I’ll give whatever you ask of me. Just give me the young woman as my wife!” ");
INSERT INTO engnet_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jacob’s sons answered Shechem and his father Hamor deceitfully when they spoke because Shechem had violated their sister Dinah. ");
INSERT INTO engnet_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","They said to them, “We cannot give our sister to a man who is not circumcised, for it would be a disgrace to us. ");
INSERT INTO engnet_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","We will give you our consent on this one condition: You must become like us by circumcising all your males. ");
INSERT INTO engnet_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then we will give you our daughters to marry, and we will take your daughters as wives for ourselves, and we will live among you and become one people. ");
INSERT INTO engnet_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you do not agree to our terms by being circumcised, then we will take our sister and depart.” ");
INSERT INTO engnet_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Their offer pleased Hamor and his son Shechem. ");
INSERT INTO engnet_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","The young man did not delay in doing what they asked because he wanted Jacob’s daughter Dinah badly. (Now he was more important than anyone in his father’s household.) ");
INSERT INTO engnet_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","So Hamor and his son Shechem went to the gate of their city and spoke to the men of their city, ");
INSERT INTO engnet_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are at peace with us. So let them live in the land and travel freely in it, for the land is wide enough for them. We will take their daughters for wives, and we will give them our daughters to marry. ");
INSERT INTO engnet_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Only on this one condition will these men consent to live with us and become one people: They demand that every male among us be circumcised just as they are circumcised. ");
INSERT INTO engnet_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","If we do so, won’t their livestock, their property, and all their animals become ours? So let’s consent to their demand, so they will live among us.” ");
INSERT INTO engnet_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","All the men who assembled at the city gate agreed with Hamor and his son Shechem. Every male who assembled at the city gate was circumcised. ");
INSERT INTO engnet_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","In three days, when they were still in pain, two of Jacob’s sons, Simeon and Levi, Dinah’s brothers, each took his sword and went to the unsuspecting city and slaughtered every male. ");
INSERT INTO engnet_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They killed Hamor and his son Shechem with the sword, took Dinah from Shechem’s house, and left. ");
INSERT INTO engnet_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob’s sons killed them and looted the city because their sister had been violated. ");
INSERT INTO engnet_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their flocks, herds, and donkeys, as well as everything in the city and in the surrounding fields. ");
INSERT INTO engnet_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","They captured as plunder all their wealth, all their little ones, and their wives, including everything in the houses. ");
INSERT INTO engnet_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Then Jacob said to Simeon and Levi, “You have brought ruin on me by making me a foul odor among the inhabitants of the land – among the Canaanites and the Perizzites. I am few in number; they will join forces against me and attack me, and both I and my family will be destroyed!” ");
INSERT INTO engnet_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But Simeon and Levi replied, “Should he treat our sister like a common prostitute?” ");
INSERT INTO engnet_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Then God said to Jacob, “Go up at once to Bethel and live there. Make an altar there to God, who appeared to you when you fled from your brother Esau.” ");
INSERT INTO engnet_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Jacob told his household and all who were with him, “Get rid of the foreign gods you have among you. Purify yourselves and change your clothes. ");
INSERT INTO engnet_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Let us go up at once to Bethel. Then I will make an altar there to God, who responded to me in my time of distress and has been with me wherever I went.” ");
INSERT INTO engnet_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So they gave Jacob all the foreign gods that were in their possession and the rings that were in their ears. Jacob buried them under the oak near Shechem ");
INSERT INTO engnet_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","and they started on their journey. The surrounding cities were afraid of God, and they did not pursue the sons of Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob and all those who were with him arrived at Luz (that is, Bethel) in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","He built an altar there and named the place El Bethel because there God had revealed himself to him when he was fleeing from his brother. ");
INSERT INTO engnet_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","(Deborah, Rebekah’s nurse, died and was buried under the oak below Bethel; thus it was named Oak of Weeping.) ");
INSERT INTO engnet_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","God appeared to Jacob again after he returned from Paddan Aram and blessed him. ");
INSERT INTO engnet_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God said to him, “Your name is Jacob, but your name will no longer be called Jacob; Israel will be your name.” So God named him Israel. ");
INSERT INTO engnet_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Then God said to him, “I am the sovereign God. Be fruitful and multiply! A nation – even a company of nations – will descend from you; kings will be among your descendants! ");
INSERT INTO engnet_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","The land I gave to Abraham and Isaac I will give to you. To your descendants I will also give this land.” ");
INSERT INTO engnet_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Then God went up from the place where he spoke with him. ");
INSERT INTO engnet_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","So Jacob set up a sacred stone pillar in the place where God spoke with him. He poured out a drink offering on it, and then he poured oil on it. ");
INSERT INTO engnet_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob named the place where God spoke with him Bethel. ");
INSERT INTO engnet_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","They traveled on from Bethel, and when Ephrath was still some distance away, Rachel went into labor – and her labor was hard. ");
INSERT INTO engnet_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","When her labor was at its hardest, the midwife said to her, “Don’t be afraid, for you are having another son.” ");
INSERT INTO engnet_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","With her dying breath, she named him Ben-Oni. But his father called him Benjamin instead. ");
INSERT INTO engnet_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","So Rachel died and was buried on the way to Ephrath (that is, Bethlehem). ");
INSERT INTO engnet_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a marker over her grave; it is the Marker of Rachel’s Grave to this day. ");
INSERT INTO engnet_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Then Israel traveled on and pitched his tent beyond Migdal Eder. ");
INSERT INTO engnet_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While Israel was living in that land, Reuben had sexual relations with Bilhah, his father’s concubine, and Israel heard about it. Jacob had twelve sons: ");
INSERT INTO engnet_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah were Reuben, Jacob’s firstborn, as well as Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engnet_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel were Joseph and Benjamin. ");
INSERT INTO engnet_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Bilhah, Rachel’s servant, were Dan and Naphtali. ");
INSERT INTO engnet_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Zilpah, Leah’s servant, were Gad and Asher. These were the sons of Jacob who were born to him in Paddan Aram. ");
INSERT INTO engnet_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","So Jacob came back to his father Isaac in Mamre, to Kiriath Arba (that is, Hebron), where Abraham and Isaac had stayed. ");
INSERT INTO engnet_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived to be 180 years old. ");
INSERT INTO engnet_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Then Isaac breathed his last and joined his ancestors. He died an old man who had lived a full life. His sons Esau and Jacob buried him. ");
INSERT INTO engnet_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","What follows is the account of Esau (also known as Edom). ");
INSERT INTO engnet_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau took his wives from the Canaanites: Adah the daughter of Elon the Hittite, and Oholibamah the daughter of Anah and granddaughter of Zibeon the Hivite, ");
INSERT INTO engnet_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","in addition to Basemath the daughter of Ishmael and sister of Nebaioth. ");
INSERT INTO engnet_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah bore Eliphaz to Esau, Basemath bore Reuel, ");
INSERT INTO engnet_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","and Oholibamah bore Jeush, Jalam, and Korah. These were the sons of Esau who were born to him in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau took his wives, his sons, his daughters, all the people in his household, his livestock, his animals, and all his possessions which he had acquired in the land of Canaan and went to a land some distance away from Jacob his brother ");
INSERT INTO engnet_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","because they had too many possessions to be able to stay together and the land where they had settled was not able to support them because of their livestock. ");
INSERT INTO engnet_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","So Esau (also known as Edom) lived in the hill country of Seir. ");
INSERT INTO engnet_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","This is the account of Esau, the father of the Edomites, in the hill country of Seir. ");
INSERT INTO engnet_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These were the names of Esau’s sons: Eliphaz, the son of Esau’s wife Adah, and Reuel, the son of Esau’s wife Basemath. ");
INSERT INTO engnet_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were: Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engnet_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, a concubine of Esau’s son Eliphaz, bore Amalek to Eliphaz. These were the sons of Esau’s wife Adah. ");
INSERT INTO engnet_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","These were the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah. These were the sons of Esau’s wife Basemath. ");
INSERT INTO engnet_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","These were the sons of Esau’s wife Oholibamah the daughter of Anah and granddaughter of Zibeon: She bore Jeush, Jalam, and Korah to Esau. ");
INSERT INTO engnet_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These were the chiefs among the descendants of Esau, the sons of Eliphaz, Esau’s firstborn: chief Teman, chief Omar, chief Zepho, chief Kenaz, ");
INSERT INTO engnet_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","chief Korah, chief Gatam, chief Amalek. These were the chiefs descended from Eliphaz in the land of Edom; these were the sons of Adah. ");
INSERT INTO engnet_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These were the sons of Esau’s son Reuel: chief Nahath, chief Zerah, chief Shammah, chief Mizzah. These were the chiefs descended from Reuel in the land of Edom; these were the sons of Esau’s wife Basemath. ");
INSERT INTO engnet_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These were the sons of Esau’s wife Oholibamah: chief Jeush, chief Jalam, chief Korah. These were the chiefs descended from Esau’s wife Oholibamah, the daughter of Anah. ");
INSERT INTO engnet_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","These were the sons of Esau (also known as Edom), and these were their chiefs. ");
INSERT INTO engnet_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These were the sons of Seir the Horite, who were living in the land: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engnet_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. These were the chiefs of the Horites, the descendants of Seir in the land of Edom. ");
INSERT INTO engnet_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The sons of Lotan were Hori and Homam; Lotan’s sister was Timna. ");
INSERT INTO engnet_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","These were the sons of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engnet_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","These were the sons of Zibeon: Aiah and Anah (who discovered the hot springs in the wilderness as he pastured the donkeys of his father Zibeon). ");
INSERT INTO engnet_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","These were the children of Anah: Dishon and Oholibamah, the daughter of Anah. ");
INSERT INTO engnet_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These were the sons of Dishon: Hemdan, Eshban, Ithran, and Keran. ");
INSERT INTO engnet_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These were the sons of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engnet_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These were the sons of Dishan: Uz and Aran. ");
INSERT INTO engnet_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These were the chiefs of the Horites: chief Lotan, chief Shobal, chief Zibeon, chief Anah, ");
INSERT INTO engnet_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","chief Dishon, chief Ezer, chief Dishan. These were the chiefs of the Horites, according to their chief lists in the land of Seir. ");
INSERT INTO engnet_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These were the kings who reigned in the land of Edom before any king ruled over the Israelites: ");
INSERT INTO engnet_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela the son of Beor reigned in Edom; the name of his city was Dinhabah. ");
INSERT INTO engnet_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, Jobab the son of Zerah from Bozrah reigned in his place. ");
INSERT INTO engnet_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham from the land of the Temanites reigned in his place. ");
INSERT INTO engnet_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Hadad the son of Bedad, who defeated the Midianites in the land of Moab, reigned in his place; the name of his city was Avith. ");
INSERT INTO engnet_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, Samlah from Masrekah reigned in his place. ");
INSERT INTO engnet_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, Shaul from Rehoboth by the River reigned in his place. ");
INSERT INTO engnet_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, Baal-Hanan the son of Achbor reigned in his place. ");
INSERT INTO engnet_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Baal-Hanan the son of Achbor died, Hadad reigned in his place; the name of his city was Pau. His wife’s name was Mehetabel, the daughter of Matred, the daughter of Me-Zahab. ");
INSERT INTO engnet_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These were the names of the chiefs of Esau, according to their families, according to their places, by their names: chief Timna, chief Alvah, chief Jetheth, ");
INSERT INTO engnet_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","chief Oholibamah, chief Elah, chief Pinon, ");
INSERT INTO engnet_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","chief Kenaz, chief Teman, chief Mibzar, ");
INSERT INTO engnet_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","chief Magdiel, chief Iram. These were the chiefs of Edom, according to their settlements in the land they possessed. This was Esau, the father of the Edomites. ");
INSERT INTO engnet_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","But Jacob lived in the land where his father had stayed, in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the account of Jacob. Joseph, his seventeen-year-old son, was taking care of the flocks with his brothers. Now he was a youngster working with the sons of Bilhah and Zilpah, his father’s wives. Joseph brought back a bad report about them to their father. ");
INSERT INTO engnet_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now Israel loved Joseph more than all his sons because he was a son born to him late in life, and he made a special tunic for him. ");
INSERT INTO engnet_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","When Joseph’s brothers saw that their father loved him more than any of them, they hated Joseph and were not able to speak to him kindly. ");
INSERT INTO engnet_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph had a dream, and when he told his brothers about it, they hated him even more. ");
INSERT INTO engnet_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He said to them, “Listen to this dream I had: ");
INSERT INTO engnet_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","There we were, binding sheaves of grain in the middle of the field. Suddenly my sheaf rose up and stood upright and your sheaves surrounded my sheaf and bowed down to it!” ");
INSERT INTO engnet_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Then his brothers asked him, “Do you really think you will rule over us or have dominion over us?” They hated him even more because of his dream and because of what he said. ");
INSERT INTO engnet_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Then he had another dream, and told it to his brothers. “Look,” he said. “I had another dream. The sun, the moon, and eleven stars were bowing down to me.” ");
INSERT INTO engnet_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","When he told his father and his brothers, his father rebuked him, saying, “What is this dream that you had? Will I, your mother, and your brothers really come and bow down to you?” ");
INSERT INTO engnet_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","His brothers were jealous of him, but his father kept in mind what Joseph said. ");
INSERT INTO engnet_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","When his brothers had gone to graze their father’s flocks near Shechem, ");
INSERT INTO engnet_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel said to Joseph, “Your brothers are grazing the flocks near Shechem. Come, I will send you to them.” “I’m ready,” Joseph replied. ");
INSERT INTO engnet_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","So Jacob said to him, “Go now and check on the welfare of your brothers and of the flocks, and bring me word.” So Jacob sent him from the valley of Hebron. ");
INSERT INTO engnet_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","When Joseph reached Shechem, a man found him wandering in the field, so the man asked him, “What are you looking for?” ");
INSERT INTO engnet_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","He replied, “I’m looking for my brothers. Please tell me where they are grazing their flocks.” ");
INSERT INTO engnet_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man said, “They left this area, for I heard them say, ‘Let’s go to Dothan.’” So Joseph went after his brothers and found them at Dothan. ");
INSERT INTO engnet_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Now Joseph’s brothers saw him from a distance, and before he reached them, they plotted to kill him. ");
INSERT INTO engnet_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","They said to one another, “Here comes this master of dreams! ");
INSERT INTO engnet_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Come now, let’s kill him, throw him into one of the cisterns, and then say that a wild animal ate him. Then we’ll see how his dreams turn out!” ");
INSERT INTO engnet_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","When Reuben heard this, he rescued Joseph from their hands, saying, “Let’s not take his life!” ");
INSERT INTO engnet_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben continued, “Don’t shed blood! Throw him into this cistern that is here in the wilderness, but don’t lay a hand on him.” (Reuben said this so he could rescue Joseph from them and take him back to his father.) ");
INSERT INTO engnet_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","When Joseph reached his brothers, they stripped him of his tunic, the special tunic that he wore. ");
INSERT INTO engnet_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Then they took him and threw him into the cistern. (Now the cistern was empty; there was no water in it.) ");
INSERT INTO engnet_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","When they sat down to eat their food, they looked up and saw a caravan of Ishmaelites coming from Gilead. Their camels were carrying spices, balm, and myrrh down to Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Then Judah said to his brothers, “What profit is there if we kill our brother and cover up his blood? ");
INSERT INTO engnet_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, let’s sell him to the Ishmaelites, but let’s not lay a hand on him, for after all, he is our brother, our own flesh.” His brothers agreed. ");
INSERT INTO engnet_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","So when the Midianite merchants passed by, Joseph’s brothers pulled him out of the cistern and sold him to the Ishmaelites for twenty pieces of silver. The Ishmaelites then took Joseph to Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Later Reuben returned to the cistern to find that Joseph was not in it! He tore his clothes, ");
INSERT INTO engnet_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","returned to his brothers, and said, “The boy isn’t there! And I, where can I go?” ");
INSERT INTO engnet_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","So they took Joseph’s tunic, killed a young goat, and dipped the tunic in the blood. ");
INSERT INTO engnet_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Then they brought the special tunic to their father and said, “We found this. Determine now whether it is your son’s tunic or not.” ");
INSERT INTO engnet_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","He recognized it and exclaimed, “It is my son’s tunic! A wild animal has eaten him! Joseph has surely been torn to pieces!” ");
INSERT INTO engnet_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Then Jacob tore his clothes, put on sackcloth, and mourned for his son many days. ");
INSERT INTO engnet_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All his sons and daughters stood by him to console him, but he refused to be consoled. “No,” he said, “I will go to the grave mourning my son.” So Joseph’s father wept for him. ");
INSERT INTO engnet_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Now in Egypt the Midianites sold Joseph to Potiphar, one of Pharaoh’s officials, the captain of the guard. ");
INSERT INTO engnet_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","At that time Judah left his brothers and stayed with an Adullamite man named Hirah. ");
INSERT INTO engnet_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","There Judah saw the daughter of a Canaanite man named Shua. Judah acquired her as a wife and had marital relations with her. ");
INSERT INTO engnet_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","She became pregnant and had a son. Judah named him Er. ");
INSERT INTO engnet_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","She became pregnant again and had another son, whom she named Onan. ");
INSERT INTO engnet_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Then she had yet another son, whom she named Shelah. She gave birth to him in Kezib. ");
INSERT INTO engnet_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah acquired a wife for Er his firstborn; her name was Tamar. ");
INSERT INTO engnet_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Er, Judah’s firstborn, was evil in the Lord’s sight, so the Lord killed him. ");
INSERT INTO engnet_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah said to Onan, “Have sexual relations with your brother’s wife and fulfill the duty of a brother-in-law to her so that you may raise up a descendant for your brother.” ");
INSERT INTO engnet_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","But Onan knew that the child would not be considered his. So whenever he had sexual relations with his brother’s wife, he withdrew prematurely so as not to give his brother a descendant. ");
INSERT INTO engnet_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","What he did was evil in the Lord’s sight, so the Lord killed him too. ");
INSERT INTO engnet_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to his daughter-in-law Tamar, “Live as a widow in your father’s house until Shelah my son grows up.” For he thought, “I don’t want him to die like his brothers.” So Tamar went and lived in her father’s house. ");
INSERT INTO engnet_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","After some time Judah’s wife, the daughter of Shua, died. After Judah was consoled, he left for Timnah to visit his sheepshearers, along with his friend Hirah the Adullamite. ");
INSERT INTO engnet_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar was told, “Look, your father-in-law is going up to Timnah to shear his sheep.” ");
INSERT INTO engnet_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","So she removed her widow’s clothes and covered herself with a veil. She wrapped herself and sat at the entrance to Enaim which is on the way to Timnah. (She did this because she saw that she had not been given to Shelah as a wife, even though he had now grown up.) ");
INSERT INTO engnet_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah saw her, he thought she was a prostitute because she had covered her face. ");
INSERT INTO engnet_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","He turned aside to her along the road and said, “Come on! I want to have sex with you.” (He did not realize it was his daughter-in-law.) She asked, “What will you give me in exchange for having sex with you?” ");
INSERT INTO engnet_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","He replied, “I’ll send you a young goat from the flock.” She asked, “Will you give me a pledge until you send it?” ");
INSERT INTO engnet_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","He said, “What pledge should I give you?” She replied, “Your seal, your cord, and the staff that’s in your hand.” So he gave them to her and had sex with her. She became pregnant by him. ");
INSERT INTO engnet_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","She left immediately, removed her veil, and put on her widow’s clothes. ");
INSERT INTO engnet_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Then Judah had his friend Hirah the Adullamite take a young goat to get back from the woman the items he had given in pledge, but Hirah could not find her. ");
INSERT INTO engnet_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","He asked the men who were there, “Where is the cult prostitute who was at Enaim by the road?” But they replied, “There has been no cult prostitute here.” ");
INSERT INTO engnet_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So he returned to Judah and said, “I couldn’t find her. Moreover, the men of the place said, ‘There has been no cult prostitute here.’” ");
INSERT INTO engnet_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah said, “Let her keep the things for herself. Otherwise we will appear to be dishonest. I did indeed send this young goat, but you couldn’t find her.” ");
INSERT INTO engnet_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","After three months Judah was told, “Your daughter-in-law Tamar has turned to prostitution, and as a result she has become pregnant.” Judah said, “Bring her out and let her be burned!” ");
INSERT INTO engnet_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","While they were bringing her out, she sent word to her father-in-law: “I am pregnant by the man to whom these belong.” Then she said, “Identify the one to whom the seal, cord, and staff belong.” ");
INSERT INTO engnet_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah recognized them and said, “She is more upright than I am, because I wouldn’t give her to Shelah my son.” He did not have sexual relations with her again. ");
INSERT INTO engnet_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","When it was time for her to give birth, there were twins in her womb. ");
INSERT INTO engnet_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","While she was giving birth, one child put out his hand, and the midwife took a scarlet thread and tied it on his hand, saying, “This one came out first.” ");
INSERT INTO engnet_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But then he drew back his hand, and his brother came out before him. She said, “How you have broken out of the womb!” So he was named Perez. ");
INSERT INTO engnet_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Afterward his brother came out – the one who had the scarlet thread on his hand – and he was named Zerah. ");
INSERT INTO engnet_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Now Joseph had been brought down to Egypt. An Egyptian named Potiphar, an official of Pharaoh and the captain of the guard, purchased him from the Ishmaelites who had brought him there. ");
INSERT INTO engnet_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","The Lord was with Joseph. He was successful and lived in the household of his Egyptian master. ");
INSERT INTO engnet_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","His master observed that the Lord was with him and that the Lord made everything he was doing successful. ");
INSERT INTO engnet_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","So Joseph found favor in his sight and became his personal attendant. Potiphar appointed Joseph overseer of his household and put him in charge of everything he owned. ");
INSERT INTO engnet_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","From the time Potiphar appointed him over his household and over all that he owned, the Lord blessed the Egyptian’s household for Joseph’s sake. The blessing of the Lord was on everything that he had, both in his house and in his fields. ");
INSERT INTO engnet_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","So Potiphar left everything he had in Joseph’s care; he gave no thought to anything except the food he ate. Now Joseph was well built and good-looking. ");
INSERT INTO engnet_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Soon after these things, his master’s wife took notice of Joseph and said, “Have sex with me.” ");
INSERT INTO engnet_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused, saying to his master’s wife, “Look, my master does not give any thought to his household with me here, and everything that he owns he has put into my care. ");
INSERT INTO engnet_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","There is no one greater in this household than I am. He has withheld nothing from me except you because you are his wife. So how could I do such a great evil and sin against God?” ");
INSERT INTO engnet_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Even though she continued to speak to Joseph day after day, he did not respond to her invitation to have sex with her. ");
INSERT INTO engnet_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","One day he went into the house to do his work when none of the household servants were there in the house. ");
INSERT INTO engnet_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","She grabbed him by his outer garment, saying, “Have sex with me!” But he left his outer garment in her hand and ran outside. ");
INSERT INTO engnet_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","When she saw that he had left his outer garment in her hand and had run outside, ");
INSERT INTO engnet_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","she called for her household servants and said to them, “See, my husband brought in a Hebrew man to us to humiliate us. He tried to have sex with me, but I screamed loudly. ");
INSERT INTO engnet_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","When he heard me raise my voice and scream, he left his outer garment beside me and ran outside.” ");
INSERT INTO engnet_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","So she laid his outer garment beside her until his master came home. ");
INSERT INTO engnet_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","This is what she said to him: “That Hebrew slave you brought to us tried to humiliate me, ");
INSERT INTO engnet_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","but when I raised my voice and screamed, he left his outer garment and ran outside.” ");
INSERT INTO engnet_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","When his master heard his wife say, “This is the way your slave treated me,” he became furious. ");
INSERT INTO engnet_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Joseph’s master took him and threw him into the prison, the place where the king’s prisoners were confined. So he was there in the prison. ");
INSERT INTO engnet_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But the Lord was with Joseph and showed him kindness. He granted him favor in the sight of the prison warden. ");
INSERT INTO engnet_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","The warden put all the prisoners under Joseph’s care. He was in charge of whatever they were doing. ");
INSERT INTO engnet_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The warden did not concern himself with anything that was in Joseph’s care because the Lord was with him and whatever he was doing the Lord was making successful. ");
INSERT INTO engnet_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","After these things happened, the cupbearer to the king of Egypt and the royal baker offended their master, the king of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh was enraged with his two officials, the cupbearer and the baker, ");
INSERT INTO engnet_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","so he imprisoned them in the house of the captain of the guard in the same facility where Joseph was confined. ");
INSERT INTO engnet_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The captain of the guard appointed Joseph to be their attendant, and he served them. They spent some time in custody. ");
INSERT INTO engnet_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Both of them, the cupbearer and the baker of the king of Egypt, who were confined in the prison, had a dream the same night. Each man’s dream had its own meaning. ");
INSERT INTO engnet_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","When Joseph came to them in the morning, he saw that they were looking depressed. ");
INSERT INTO engnet_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","So he asked Pharaoh’s officials, who were with him in custody in his master’s house, “Why do you look so sad today?” ");
INSERT INTO engnet_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","They told him, “We both had dreams, but there is no one to interpret them.” Joseph responded, “Don’t interpretations belong to God? Tell them to me.” ");
INSERT INTO engnet_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the chief cupbearer told his dream to Joseph: “In my dream, there was a vine in front of me. ");
INSERT INTO engnet_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","On the vine there were three branches. As it budded, its blossoms opened and its clusters ripened into grapes. ");
INSERT INTO engnet_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Now Pharaoh’s cup was in my hand, so I took the grapes, squeezed them into his cup, and put the cup in Pharaoh’s hand.” ");
INSERT INTO engnet_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“This is its meaning,” Joseph said to him. “The three branches represent three days. ");
INSERT INTO engnet_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","In three more days Pharaoh will reinstate you and restore you to your office. You will put Pharaoh’s cup in his hand, just as you did before when you were cupbearer. ");
INSERT INTO engnet_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But remember me when it goes well for you, and show me kindness. Make mention of me to Pharaoh and bring me out of this prison, ");
INSERT INTO engnet_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","for I really was kidnapped from the land of the Hebrews and I have done nothing wrong here for which they should put me in a dungeon.” ");
INSERT INTO engnet_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief baker saw that the interpretation of the first dream was favorable, he said to Joseph, “I also appeared in my dream and there were three baskets of white bread on my head. ");
INSERT INTO engnet_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket there were baked goods of every kind for Pharaoh, but the birds were eating them from the basket that was on my head.” ");
INSERT INTO engnet_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph replied, “This is its meaning: The three baskets represent three days. ");
INSERT INTO engnet_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","In three more days Pharaoh will decapitate you and impale you on a pole. Then the birds will eat your flesh from you.” ");
INSERT INTO engnet_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","On the third day it was Pharaoh’s birthday, so he gave a feast for all his servants. He “lifted up” the head of the chief cupbearer and the head of the chief baker in the midst of his servants. ");
INSERT INTO engnet_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He restored the chief cupbearer to his former position so that he placed the cup in Pharaoh’s hand, ");
INSERT INTO engnet_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","but the chief baker he impaled, just as Joseph had predicted. ");
INSERT INTO engnet_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But the chief cupbearer did not remember Joseph – he forgot him. ");
INSERT INTO engnet_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","At the end of two full years Pharaoh had a dream. As he was standing by the Nile, ");
INSERT INTO engnet_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","seven fine-looking, fat cows were coming up out of the Nile, and they grazed in the reeds. ");
INSERT INTO engnet_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Then seven bad-looking, thin cows were coming up after them from the Nile, and they stood beside the other cows at the edge of the river. ");
INSERT INTO engnet_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","The bad-looking, thin cows ate the seven fine-looking, fat cows. Then Pharaoh woke up. ");
INSERT INTO engnet_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Then he fell asleep again and had a second dream: There were seven heads of grain growing on one stalk, healthy and good. ");
INSERT INTO engnet_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Then seven heads of grain, thin and burned by the east wind, were sprouting up after them. ");
INSERT INTO engnet_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","The thin heads swallowed up the seven healthy and full heads. Then Pharaoh woke up and realized it was a dream. ");
INSERT INTO engnet_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","In the morning he was troubled, so he called for all the diviner-priests of Egypt and all its wise men. Pharaoh told them his dreams, but no one could interpret them for him. ");
INSERT INTO engnet_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief cupbearer said to Pharaoh, “Today I recall my failures. ");
INSERT INTO engnet_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh was enraged with his servants, and he put me in prison in the house of the captain of the guards – me and the chief baker. ");
INSERT INTO engnet_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","We each had a dream one night; each of us had a dream with its own meaning. ");
INSERT INTO engnet_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Now a young man, a Hebrew, a servant of the captain of the guards, was with us there. We told him our dreams, and he interpreted the meaning of each of our respective dreams for us. ");
INSERT INTO engnet_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","It happened just as he had said to us – Pharaoh restored me to my office, but he impaled the baker.” ");
INSERT INTO engnet_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Then Pharaoh summoned Joseph. So they brought him quickly out of the dungeon; he shaved himself, changed his clothes, and came before Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, and there is no one who can interpret it. But I have heard about you, that you can interpret dreams.” ");
INSERT INTO engnet_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph replied to Pharaoh, “It is not within my power, but God will speak concerning the welfare of Pharaoh.” ");
INSERT INTO engnet_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Then Pharaoh said to Joseph, “In my dream I was standing by the edge of the Nile. ");
INSERT INTO engnet_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Then seven fat and fine-looking cows were coming up out of the Nile, and they grazed in the reeds. ");
INSERT INTO engnet_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Then seven other cows came up after them; they were scrawny, very bad-looking, and lean. I had never seen such bad-looking cows as these in all the land of Egypt! ");
INSERT INTO engnet_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","The lean, bad-looking cows ate up the seven fat cows. ");
INSERT INTO engnet_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","When they had eaten them, no one would have known that they had done so, for they were just as bad-looking as before. Then I woke up. ");
INSERT INTO engnet_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","I also saw in my dream seven heads of grain growing on one stalk, full and good. ");
INSERT INTO engnet_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Then seven heads of grain, withered and thin and burned with the east wind, were sprouting up after them. ");
INSERT INTO engnet_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","The thin heads of grain swallowed up the seven good heads of grain. So I told all this to the diviner-priests, but no one could tell me its meaning.” ");
INSERT INTO engnet_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Then Joseph said to Pharaoh, “Both dreams of Pharaoh have the same meaning. God has revealed to Pharaoh what he is about to do. ");
INSERT INTO engnet_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows represent seven years, and the seven good heads of grain represent seven years. Both dreams have the same meaning. ");
INSERT INTO engnet_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven lean, bad-looking cows that came up after them represent seven years, as do the seven empty heads of grain burned with the east wind. They represent seven years of famine. ");
INSERT INTO engnet_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","This is just what I told Pharaoh: God has shown Pharaoh what he is about to do. ");
INSERT INTO engnet_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Seven years of great abundance are coming throughout the whole land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","But seven years of famine will occur after them, and all the abundance will be forgotten in the land of Egypt. The famine will devastate the land. ");
INSERT INTO engnet_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","The previous abundance of the land will not be remembered because of the famine that follows, for the famine will be very severe. ");
INSERT INTO engnet_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","The dream was repeated to Pharaoh because the matter has been decreed by God, and God will make it happen soon. ");
INSERT INTO engnet_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“So now Pharaoh should look for a wise and discerning man and give him authority over all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pharaoh should do this – he should appoint officials throughout the land to collect one-fifth of the produce of the land of Egypt during the seven years of abundance. ");
INSERT INTO engnet_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","They should gather all the excess food during these good years that are coming. By Pharaoh’s authority they should store up grain so the cities will have food, and they should preserve it. ");
INSERT INTO engnet_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","This food should be held in storage for the land in preparation for the seven years of famine that will occur throughout the land of Egypt. In this way the land will survive the famine.” ");
INSERT INTO engnet_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","This advice made sense to Pharaoh and all his officials. ");
INSERT INTO engnet_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","So Pharaoh asked his officials, “Can we find a man like Joseph, one in whom the Spirit of God is present?” ");
INSERT INTO engnet_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","So Pharaoh said to Joseph, “Because God has enabled you to know all this, there is no one as wise and discerning as you are! ");
INSERT INTO engnet_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","You will oversee my household, and all my people will submit to your commands. Only I, the king, will be greater than you. ");
INSERT INTO engnet_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","“See here,” Pharaoh said to Joseph, “I place you in authority over all the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Then Pharaoh took his signet ring from his own hand and put it on Joseph’s. He clothed him with fine linen clothes and put a gold chain around his neck. ");
INSERT INTO engnet_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pharaoh had him ride in the chariot used by his second-in-command, and they cried out before him, “Kneel down!” So he placed him over all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaoh also said to Joseph, “I am Pharaoh, but without your permission no one will move his hand or his foot in all the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaoh gave Joseph the name Zaphenath-Paneah. He also gave him Asenath daughter of Potiphera, priest of On, to be his wife. So Joseph took charge of all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Now Joseph was 30 years old when he began serving Pharaoh king of Egypt. Joseph was commissioned by Pharaoh and was in charge of all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","During the seven years of abundance the land produced large, bountiful harvests. ");
INSERT INTO engnet_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph collected all the excess food in the land of Egypt during the seven years and stored it in the cities. In every city he put the food gathered from the fields around it. ");
INSERT INTO engnet_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph stored up a vast amount of grain, like the sand of the sea, until he stopped measuring it because it was impossible to measure. ");
INSERT INTO engnet_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Two sons were born to Joseph before the famine came. Asenath daughter of Potiphera, priest of On, was their mother. ");
INSERT INTO engnet_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named the firstborn Manasseh, saying, “Certainly God has made me forget all my trouble and all my father’s house.” ");
INSERT INTO engnet_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","He named the second child Ephraim, saying, “Certainly God has made me fruitful in the land of my suffering.” ");
INSERT INTO engnet_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","The seven years of abundance in the land of Egypt came to an end. ");
INSERT INTO engnet_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Then the seven years of famine began, just as Joseph had predicted. There was famine in all the other lands, but throughout the land of Egypt there was food. ");
INSERT INTO engnet_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When all the land of Egypt experienced the famine, the people cried out to Pharaoh for food. Pharaoh said to all the people of Egypt, “Go to Joseph and do whatever he tells you.” ");
INSERT INTO engnet_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","While the famine was over all the earth, Joseph opened the storehouses and sold grain to the Egyptians. The famine was severe throughout the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","People from every country came to Joseph in Egypt to buy grain because the famine was severe throughout the earth. ");
INSERT INTO engnet_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","When Jacob heard there was grain in Egypt, he said to his sons, “Why are you looking at each other?” ");
INSERT INTO engnet_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","He then said, “Look, I hear that there is grain in Egypt. Go down there and buy grain for us so that we may live and not die.” ");
INSERT INTO engnet_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So ten of Joseph’s brothers went down to buy grain from Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob did not send Joseph’s brother Benjamin with his brothers, for he said, “What if some accident happens to him?” ");
INSERT INTO engnet_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So Israel’s sons came to buy grain among the other travelers, for the famine was severe in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Now Joseph was the ruler of the country, the one who sold grain to all the people of the country. Joseph’s brothers came and bowed down before him with their faces to the ground. ");
INSERT INTO engnet_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","When Joseph saw his brothers, he recognized them, but he pretended to be a stranger to them and spoke to them harshly. He asked, “Where do you come from?” They answered, “From the land of Canaan, to buy grain for food.” ");
INSERT INTO engnet_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph recognized his brothers, but they did not recognize him. ");
INSERT INTO engnet_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Then Joseph remembered the dreams he had dreamed about them, and he said to them, “You are spies; you have come to see if our land is vulnerable!” ");
INSERT INTO engnet_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","But they exclaimed, “No, my lord! Your servants have come to buy grain for food! ");
INSERT INTO engnet_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all the sons of one man; we are honest men! Your servants are not spies.” ");
INSERT INTO engnet_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“No,” he insisted, “but you have come to see if our land is vulnerable.” ");
INSERT INTO engnet_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","They replied, “Your servants are from a family of twelve brothers. We are the sons of one man in the land of Canaan. The youngest is with our father at this time, and one is no longer alive.” ");
INSERT INTO engnet_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","But Joseph told them, “It is just as I said to you: You are spies! ");
INSERT INTO engnet_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","You will be tested in this way: As surely as Pharaoh lives, you will not depart from this place unless your youngest brother comes here. ");
INSERT INTO engnet_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","One of you must go and get your brother, while the rest of you remain in prison. In this way your words may be tested to see if you are telling the truth. If not, then, as surely as Pharaoh lives, you are spies!” ");
INSERT INTO engnet_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","He imprisoned them all for three days. ");
INSERT INTO engnet_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","On the third day Joseph said to them, “Do as I say and you will live, for I fear God. ");
INSERT INTO engnet_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest men, leave one of your brothers confined here in prison while the rest of you go and take grain back for your hungry families. ");
INSERT INTO engnet_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","But you must bring your youngest brother to me. Then your words will be verified and you will not die.” They did as he said. ");
INSERT INTO engnet_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","They said to one other, “Surely we’re being punished because of our brother, because we saw how distressed he was when he cried to us for mercy, but we refused to listen. That is why this distress has come on us!” ");
INSERT INTO engnet_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben said to them, “Didn’t I say to you, ‘Don’t sin against the boy,’ but you wouldn’t listen? So now we must pay for shedding his blood!” ");
INSERT INTO engnet_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","(Now they did not know that Joseph could understand them, for he was speaking through an interpreter.) ");
INSERT INTO engnet_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","He turned away from them and wept. When he turned around and spoke to them again, he had Simeon taken from them and tied up before their eyes. ");
INSERT INTO engnet_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph gave orders to fill their bags with grain, to return each man’s money to his sack, and to give them provisions for the journey. His orders were carried out. ");
INSERT INTO engnet_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","So they loaded their grain on their donkeys and left. ");
INSERT INTO engnet_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","When one of them opened his sack to get feed for his donkey at their resting place, he saw his money in the mouth of his sack. ");
INSERT INTO engnet_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He said to his brothers, “My money was returned! Here it is in my sack!” They were dismayed; they turned trembling one to another and said, “What in the world has God done to us?” ");
INSERT INTO engnet_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","They returned to their father Jacob in the land of Canaan and told him all the things that had happened to them, saying, ");
INSERT INTO engnet_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man, the lord of the land, spoke harshly to us and treated us as if we were spying on the land. ");
INSERT INTO engnet_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","But we said to him, ‘We are honest men; we are not spies! ");
INSERT INTO engnet_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are from a family of twelve brothers; we are the sons of one father. One is no longer alive, and the youngest is with our father at this time in the land of Canaan.’ ");
INSERT INTO engnet_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Then the man, the lord of the land, said to us, ‘This is how I will find out if you are honest men. Leave one of your brothers with me, and take grain for your hungry households and go. ");
INSERT INTO engnet_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","But bring your youngest brother back to me so I will know that you are honest men and not spies. Then I will give your brother back to you and you may move about freely in the land.’” ");
INSERT INTO engnet_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","When they were emptying their sacks, there was each man’s bag of money in his sack! When they and their father saw the bags of money, they were afraid. ");
INSERT INTO engnet_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Their father Jacob said to them, “You are making me childless! Joseph is gone. Simeon is gone. And now you want to take Benjamin! Everything is against me.” ");
INSERT INTO engnet_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Then Reuben said to his father, “You may put my two sons to death if I do not bring him back to you. Put him in my care and I will bring him back to you.” ");
INSERT INTO engnet_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But Jacob replied, “My son will not go down there with you, for his brother is dead and he alone is left. If an accident happens to him on the journey you have to make, then you will bring down my gray hair in sorrow to the grave.” ");
INSERT INTO engnet_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Now the famine was severe in the land. ");
INSERT INTO engnet_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","When they finished eating the grain they had brought from Egypt, their father said to them, “Return, buy us a little more food.” ");
INSERT INTO engnet_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Judah said to him, “The man solemnly warned us, ‘You will not see my face unless your brother is with you.’ ");
INSERT INTO engnet_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you send our brother with us, we’ll go down and buy food for you. ");
INSERT INTO engnet_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you will not send him, we won’t go down there because the man said to us, ‘You will not see my face unless your brother is with you.’” ");
INSERT INTO engnet_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel said, “Why did you bring this trouble on me by telling the man you had one more brother?” ");
INSERT INTO engnet_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","They replied, “The man questioned us thoroughly about ourselves and our family, saying, ‘Is your father still alive? Do you have another brother?’ So we answered him in this way. How could we possibly know that he would say, ‘Bring your brother down’?” ");
INSERT INTO engnet_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Then Judah said to his father Israel, “Send the boy with me and we will go immediately. Then we will live and not die – we and you and our little ones. ");
INSERT INTO engnet_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I myself pledge security for him; you may hold me liable. If I do not bring him back to you and place him here before you, I will bear the blame before you all my life. ");
INSERT INTO engnet_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","But if we had not delayed, we could have traveled there and back twice by now!” ");
INSERT INTO engnet_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Israel said to them, “If it must be so, then do this: Take some of the best products of the land in your bags, and take a gift down to the man – a little balm and a little honey, spices and myrrh, pistachios and almonds. ");
INSERT INTO engnet_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take double the money with you; you must take back the money that was returned in the mouths of your sacks – perhaps it was an oversight. ");
INSERT INTO engnet_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take your brother too, and go right away to the man. ");
INSERT INTO engnet_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","May the sovereign God grant you mercy before the man so that he may release your other brother and Benjamin! As for me, if I lose my children I lose them.” ");
INSERT INTO engnet_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So the men took these gifts, and they took double the money with them, along with Benjamin. Then they hurried down to Egypt and stood before Joseph. ");
INSERT INTO engnet_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with them, he said to the servant who was over his household, “Bring the men to the house. Slaughter an animal and prepare it, for the men will eat with me at noon.” ");
INSERT INTO engnet_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The man did just as Joseph said; he brought the men into Joseph’s house. ");
INSERT INTO engnet_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","But the men were afraid when they were brought to Joseph’s house. They said, “We are being brought in because of the money that was returned in our sacks last time. He wants to capture us, make us slaves, and take our donkeys!” ");
INSERT INTO engnet_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So they approached the man who was in charge of Joseph’s household and spoke to him at the entrance to the house. ");
INSERT INTO engnet_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","They said, “My lord, we did indeed come down the first time to buy food. ");
INSERT INTO engnet_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","But when we came to the place where we spent the night, we opened our sacks and each of us found his money – the full amount – in the mouth of his sack. So we have returned it. ");
INSERT INTO engnet_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We have brought additional money with us to buy food. We do not know who put the money in our sacks!” ");
INSERT INTO engnet_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“Everything is fine,” the man in charge of Joseph’s household told them. “Don’t be afraid. Your God and the God of your father has given you treasure in your sacks. I had your money.” Then he brought Simeon out to them. ");
INSERT INTO engnet_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","The servant in charge brought the men into Joseph’s house. He gave them water, and they washed their feet. Then he gave food to their donkeys. ");
INSERT INTO engnet_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","They got their gifts ready for Joseph’s arrival at noon, for they had heard that they were to have a meal there. ");
INSERT INTO engnet_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, they presented him with the gifts they had brought inside, and they bowed down to the ground before him. ");
INSERT INTO engnet_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked them how they were doing. Then he said, “Is your aging father well, the one you spoke about? Is he still alive?” ");
INSERT INTO engnet_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Your servant our father is well,” they replied. “He is still alive.” They bowed down in humility. ");
INSERT INTO engnet_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","When Joseph looked up and saw his brother Benjamin, his mother’s son, he said, “Is this your youngest brother, whom you told me about?” Then he said, “May God be gracious to you, my son.” ");
INSERT INTO engnet_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph hurried out, for he was overcome by affection for his brother and was at the point of tears. So he went to his room and wept there. ");
INSERT INTO engnet_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then he washed his face and came out. With composure he said, “Set out the food.” ");
INSERT INTO engnet_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","They set a place for him, a separate place for his brothers, and another for the Egyptians who were eating with him. (The Egyptians are not able to eat with Hebrews, for the Egyptians think it is disgusting to do so.) ");
INSERT INTO engnet_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","They sat before him, arranged by order of birth, beginning with the firstborn and ending with the youngest. The men looked at each other in astonishment. ");
INSERT INTO engnet_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","He gave them portions of the food set before him, but the portion for Benjamin was five times greater than the portions for any of the others. They drank with Joseph until they all became drunk. ");
INSERT INTO engnet_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","He instructed the servant who was over his household, “Fill the sacks of the men with as much food as they can carry and put each man’s money in the mouth of his sack. ");
INSERT INTO engnet_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Then put my cup – the silver cup – in the mouth of the youngest one’s sack, along with the money for his grain.” He did as Joseph instructed. ");
INSERT INTO engnet_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","When morning came, the men and their donkeys were sent off. ");
INSERT INTO engnet_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","They had not gone very far from the city when Joseph said to the servant who was over his household, “Pursue the men at once! When you overtake them, say to them, ‘Why have you repaid good with evil? ");
INSERT INTO engnet_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Doesn’t my master drink from this cup and use it for divination? You have done wrong!’” ");
INSERT INTO engnet_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","When the man overtook them, he spoke these words to them. ");
INSERT INTO engnet_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","They answered him, “Why does my lord say such things? Far be it from your servants to do such a thing! ");
INSERT INTO engnet_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Look, the money that we found in the mouths of our sacks we brought back to you from the land of Canaan. Why then would we steal silver or gold from your master’s house? ");
INSERT INTO engnet_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If one of us has it, he will die, and the rest of us will become my lord’s slaves!” ");
INSERT INTO engnet_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","He replied, “You have suggested your own punishment! The one who has it will become my slave, but the rest of you will go free.” ");
INSERT INTO engnet_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","So each man quickly lowered his sack to the ground and opened it. ");
INSERT INTO engnet_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Then the man searched. He began with the oldest and finished with the youngest. The cup was found in Benjamin’s sack! ");
INSERT INTO engnet_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","They all tore their clothes! Then each man loaded his donkey, and they returned to the city. ");
INSERT INTO engnet_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","So Judah and his brothers came back to Joseph’s house. He was still there, and they threw themselves to the ground before him. ");
INSERT INTO engnet_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph said to them, “What did you think you were doing? Don’t you know that a man like me can find out things like this by divination?” ");
INSERT INTO engnet_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah replied, “What can we say to my lord? What can we speak? How can we clear ourselves? God has exposed the sin of your servants! We are now my lord’s slaves, we and the one in whose possession the cup was found.” ");
INSERT INTO engnet_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But Joseph said, “Far be it from me to do this! The man in whose hand the cup was found will become my slave, but the rest of you may go back to your father in peace.” ");
INSERT INTO engnet_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah approached him and said, “My lord, please allow your servant to speak a word with you. Please do not get angry with your servant, for you are just like Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord asked his servants, ‘Do you have a father or a brother?’ ");
INSERT INTO engnet_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We said to my lord, ‘We have an aged father, and there is a young boy who was born when our father was old. The boy’s brother is dead. He is the only one of his mother’s sons left, and his father loves him.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Then you told your servants, ‘Bring him down to me so I can see him.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","We said to my lord, ‘The boy cannot leave his father. If he leaves his father, his father will die.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you said to your servants, ‘If your youngest brother does not come down with you, you will not see my face again.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","When we returned to your servant my father, we told him the words of my lord. ");
INSERT INTO engnet_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Then our father said, ‘Go back and buy us a little food.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","But we replied, ‘We cannot go down there. If our youngest brother is with us, then we will go, for we won’t be permitted to see the man’s face if our youngest brother is not with us.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Then your servant my father said to us, ‘You know that my wife gave me two sons. ");
INSERT INTO engnet_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","The first disappeared and I said, “He has surely been torn to pieces.” I have not seen him since. ");
INSERT INTO engnet_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If you take this one from me too and an accident happens to him, then you will bring down my gray hair in tragedy to the grave.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“So now, when I return to your servant my father, and the boy is not with us – his very life is bound up in his son’s life. ");
INSERT INTO engnet_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","When he sees the boy is not with us, he will die, and your servants will bring down the gray hair of your servant our father in sorrow to the grave. ");
INSERT INTO engnet_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Indeed, your servant pledged security for the boy with my father, saying, ‘If I do not bring him back to you, then I will bear the blame before my father all my life.’ ");
INSERT INTO engnet_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“So now, please let your servant remain as my lord’s slave instead of the boy. As for the boy, let him go back with his brothers. ");
INSERT INTO engnet_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how can I go back to my father if the boy is not with me? I couldn’t bear to see my father’s pain.” ");
INSERT INTO engnet_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph was no longer able to control himself before all his attendants, so he cried out, “Make everyone go out from my presence!” No one remained with Joseph when he made himself known to his brothers. ");
INSERT INTO engnet_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","He wept loudly; the Egyptians heard it and Pharaoh’s household heard about it. ");
INSERT INTO engnet_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph said to his brothers, “I am Joseph! Is my father still alive?” His brothers could not answer him because they were dumbfounded before him. ");
INSERT INTO engnet_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph said to his brothers, “Come closer to me,” so they came near. Then he said, “I am Joseph your brother, whom you sold into Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Now, do not be upset and do not be angry with yourselves because you sold me here, for God sent me ahead of you to preserve life! ");
INSERT INTO engnet_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For these past two years there has been famine in the land and for five more years there will be neither plowing nor harvesting. ");
INSERT INTO engnet_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me ahead of you to preserve you on the earth and to save your lives by a great deliverance. ");
INSERT INTO engnet_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So now, it is not you who sent me here, but God. He has made me an adviser to Pharaoh, lord over all his household, and ruler over all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Now go up to my father quickly and tell him, ‘This is what your son Joseph says: “God has made me lord of all Egypt. Come down to me; do not delay! ");
INSERT INTO engnet_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You will live in the land of Goshen, and you will be near me – you, your children, your grandchildren, your flocks, your herds, and everything you have. ");
INSERT INTO engnet_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I will provide you with food there because there will be five more years of famine. Otherwise you would become poor – you, your household, and everyone who belongs to you.”’ ");
INSERT INTO engnet_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","You and my brother Benjamin can certainly see with your own eyes that I really am the one who speaks to you. ");
INSERT INTO engnet_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","So tell my father about all my honor in Egypt and about everything you have seen. But bring my father down here quickly!” ");
INSERT INTO engnet_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then he threw himself on the neck of his brother Benjamin and wept, and Benjamin wept on his neck. ");
INSERT INTO engnet_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","He kissed all his brothers and wept over them. After this his brothers talked with him. ");
INSERT INTO engnet_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Now it was reported in the household of Pharaoh, “Joseph’s brothers have arrived.” It pleased Pharaoh and his servants. ");
INSERT INTO engnet_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh said to Joseph, “Say to your brothers, ‘Do this: Load your animals and go to the land of Canaan! ");
INSERT INTO engnet_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Get your father and your households and come to me! Then I will give you the best land in Egypt and you will eat the best of the land.’ ");
INSERT INTO engnet_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","You are also commanded to say, ‘Do this: Take for yourselves wagons from the land of Egypt for your little ones and for your wives. Bring your father and come. ");
INSERT INTO engnet_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Don’t worry about your belongings, for the best of all the land of Egypt will be yours.’” ");
INSERT INTO engnet_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","So the sons of Israel did as he said. Joseph gave them wagons as Pharaoh had instructed, and he gave them provisions for the journey. ");
INSERT INTO engnet_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","He gave sets of clothes to each one of them, but to Benjamin he gave three hundred pieces of silver and five sets of clothes. ");
INSERT INTO engnet_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","To his father he sent the following: ten donkeys loaded with the best products of Egypt and ten female donkeys loaded with grain, food, and provisions for his father’s journey. ");
INSERT INTO engnet_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Then he sent his brothers on their way and they left. He said to them, “As you travel don’t be overcome with fear.” ");
INSERT INTO engnet_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So they went up from Egypt and came to their father Jacob in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","They told him, “Joseph is still alive and he is ruler over all the land of Egypt!” Jacob was stunned, for he did not believe them. ");
INSERT INTO engnet_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","But when they related to him everything Joseph had said to them, and when he saw the wagons that Joseph had sent to transport him, their father Jacob’s spirit revived. ");
INSERT INTO engnet_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Then Israel said, “Enough! My son Joseph is still alive! I will go and see him before I die.” ");
INSERT INTO engnet_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Israel began his journey, taking with him all that he had. When he came to Beer Sheba he offered sacrifices to the God of his father Isaac. ");
INSERT INTO engnet_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","God spoke to Israel in a vision during the night and said, “Jacob, Jacob!” He replied, “Here I am!” ");
INSERT INTO engnet_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","He said, “I am God, the God of your father. Do not be afraid to go down to Egypt, for I will make you into a great nation there. ");
INSERT INTO engnet_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with you to Egypt and I myself will certainly bring you back from there. Joseph will close your eyes.” ");
INSERT INTO engnet_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob started out from Beer Sheba, and the sons of Israel carried their father Jacob, their little children, and their wives in the wagons that Pharaoh had sent along to transport him. ");
INSERT INTO engnet_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacob and all his descendants took their livestock and the possessions they had acquired in the land of Canaan, and they went to Egypt. ");
INSERT INTO engnet_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","He brought with him to Egypt his sons and grandsons, his daughters and granddaughters – all his descendants. ");
INSERT INTO engnet_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","These are the names of the sons of Israel who went to Egypt – Jacob and his sons: Reuben, the firstborn of Jacob. ");
INSERT INTO engnet_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","The sons of Reuben: Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engnet_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","The sons of Simeon: Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul (the son of a Canaanite woman). ");
INSERT INTO engnet_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","The sons of Levi: Gershon, Kohath, and Merari. ");
INSERT INTO engnet_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","The sons of Judah: Er, Onan, Shelah, Perez, and Zerah (but Er and Onan died in the land of Canaan). The sons of Perez were Hezron and Hamul. ");
INSERT INTO engnet_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","The sons of Issachar: Tola, Puah, Jashub, and Shimron. ");
INSERT INTO engnet_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","The sons of Zebulun: Sered, Elon, and Jahleel. ");
INSERT INTO engnet_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These were the sons of Leah, whom she bore to Jacob in Paddan Aram, along with Dinah his daughter. His sons and daughters numbered thirty-three in all. ");
INSERT INTO engnet_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","The sons of Gad: Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engnet_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","The sons of Asher: Imnah, Ishvah, Ishvi, Beriah, and Serah their sister. The sons of Beriah were Heber and Malkiel. ");
INSERT INTO engnet_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These were the sons of Zilpah, whom Laban gave to Leah his daughter. She bore these to Jacob, sixteen in all. ");
INSERT INTO engnet_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Rachel the wife of Jacob: Joseph and Benjamin. ");
INSERT INTO engnet_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Manasseh and Ephraim were born to Joseph in the land of Egypt. Asenath daughter of Potiphera, priest of On, bore them to him. ");
INSERT INTO engnet_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","The sons of Benjamin: Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim and Ard. ");
INSERT INTO engnet_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These were the sons of Rachel who were born to Jacob, fourteen in all. ");
INSERT INTO engnet_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","The son of Dan: Hushim. ");
INSERT INTO engnet_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","The sons of Naphtali: Jahziel, Guni, Jezer, and Shillem. ");
INSERT INTO engnet_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These were the sons of Bilhah, whom Laban gave to Rachel his daughter. She bore these to Jacob, seven in all. ");
INSERT INTO engnet_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All the direct descendants of Jacob who went to Egypt with him were sixty-six in number. (This number does not include the wives of Jacob’s sons.) ");
INSERT INTO engnet_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Counting the two sons of Joseph who were born to him in Egypt, all the people of the household of Jacob who were in Egypt numbered seventy. ");
INSERT INTO engnet_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah before him to Joseph to accompany him to Goshen. So they came to the land of Goshen. ");
INSERT INTO engnet_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph harnessed his chariot and went up to meet his father Israel in Goshen. When he met him, he hugged his neck and wept on his neck for quite some time. ");
INSERT INTO engnet_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel said to Joseph, “Now let me die since I have seen your face and know that you are still alive.” ");
INSERT INTO engnet_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Then Joseph said to his brothers and his father’s household, “I will go up and tell Pharaoh, ‘My brothers and my father’s household who were in the land of Canaan have come to me. ");
INSERT INTO engnet_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","The men are shepherds; they take care of livestock. They have brought their flocks and their herds and all that they have.’ ");
INSERT INTO engnet_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Pharaoh will summon you and say, ‘What is your occupation?’ ");
INSERT INTO engnet_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Tell him, ‘Your servants have taken care of cattle from our youth until now, both we and our fathers,’ so that you may live in the land of Goshen, for everyone who takes care of sheep is disgusting to the Egyptians.” ");
INSERT INTO engnet_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph went and told Pharaoh, “My father, my brothers, their flocks and herds, and all that they own have arrived from the land of Canaan. They are now in the land of Goshen.” ");
INSERT INTO engnet_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","He took five of his brothers and introduced them to Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh said to Joseph’s brothers, “What is your occupation?” They said to Pharaoh, “Your servants take care of flocks, just as our ancestors did.” ");
INSERT INTO engnet_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Then they said to Pharaoh, “We have come to live as temporary residents in the land. There is no pasture for your servants’ flocks because the famine is severe in the land of Canaan. So now, please let your servants live in the land of Goshen.” ");
INSERT INTO engnet_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaoh said to Joseph, “Your father and your brothers have come to you. ");
INSERT INTO engnet_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","The land of Egypt is before you; settle your father and your brothers in the best region of the land. They may live in the land of Goshen. If you know of any highly capable men among them, put them in charge of my livestock.” ");
INSERT INTO engnet_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph brought in his father Jacob and presented him before Pharaoh. Jacob blessed Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh said to Jacob, “How long have you lived?” ");
INSERT INTO engnet_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob said to Pharaoh, “All the years of my travels are 130. All the years of my life have been few and painful; the years of my travels are not as long as those of my ancestors.” ");
INSERT INTO engnet_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob blessed Pharaoh and went out from his presence. ");
INSERT INTO engnet_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","So Joseph settled his father and his brothers. He gave them territory in the land of Egypt, in the best region of the land, the land of Rameses, just as Pharaoh had commanded. ");
INSERT INTO engnet_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph also provided food for his father, his brothers, and all his father’s household, according to the number of their little children. ");
INSERT INTO engnet_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","But there was no food in all the land because the famine was very severe; the land of Egypt and the land of Canaan wasted away because of the famine. ");
INSERT INTO engnet_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph collected all the money that could be found in the land of Egypt and in the land of Canaan as payment for the grain they were buying. Then Joseph brought the money into Pharaoh’s palace. ");
INSERT INTO engnet_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","When the money from the lands of Egypt and Canaan was used up, all the Egyptians came to Joseph and said, “Give us food! Why should we die before your very eyes because our money has run out?” ");
INSERT INTO engnet_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Then Joseph said, “If your money is gone, bring your livestock, and I will give you food in exchange for your livestock.” ");
INSERT INTO engnet_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they brought their livestock to Joseph, and Joseph gave them food in exchange for their horses, the livestock of their flocks and herds, and their donkeys. He got them through that year by giving them food in exchange for livestock. ");
INSERT INTO engnet_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","When that year was over, they came to him the next year and said to him, “We cannot hide from our lord that the money is used up and the livestock and the animals belong to our lord. Nothing remains before our lord except our bodies and our land. ");
INSERT INTO engnet_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why should we die before your very eyes, both we and our land? Buy us and our land in exchange for food, and we, with our land, will become Pharaoh’s slaves. Give us seed that we may live and not die. Then the land will not become desolate.” ");
INSERT INTO engnet_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the land of Egypt for Pharaoh. Each of the Egyptians sold his field, for the famine was severe. So the land became Pharaoh’s. ");
INSERT INTO engnet_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Joseph made all the people slaves from one end of Egypt’s border to the other end of it. ");
INSERT INTO engnet_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","But he did not purchase the land of the priests because the priests had an allotment from Pharaoh and they ate from their allotment that Pharaoh gave them. That is why they did not sell their land. ");
INSERT INTO engnet_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph said to the people, “Since I have bought you and your land today for Pharaoh, here is seed for you. Cultivate the land. ");
INSERT INTO engnet_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","When you gather in the crop, give one-fifth of it to Pharaoh, and the rest will be yours for seed for the fields and for you to eat, including those in your households and your little children.” ");
INSERT INTO engnet_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","They replied, “You have saved our lives! You are showing us favor, and we will be Pharaoh’s slaves.” ");
INSERT INTO engnet_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph made it a statute, which is in effect to this day throughout the land of Egypt: One-fifth belongs to Pharaoh. Only the land of the priests did not become Pharaoh’s. ");
INSERT INTO engnet_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel settled in the land of Egypt, in the land of Goshen, and they owned land there. They were fruitful and increased rapidly in number. ");
INSERT INTO engnet_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in the land of Egypt seventeen years; the years of Jacob’s life were 147 in all. ");
INSERT INTO engnet_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","The time for Israel to die approached, so he called for his son Joseph and said to him, “If now I have found favor in your sight, put your hand under my thigh and show me kindness and faithfulness. Do not bury me in Egypt, ");
INSERT INTO engnet_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","but when I rest with my fathers, carry me out of Egypt and bury me in their burial place.” Joseph said, “I will do as you say.” ");
INSERT INTO engnet_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacob said, “Swear to me that you will do so.” So Joseph gave him his word. Then Israel bowed down at the head of his bed. ");
INSERT INTO engnet_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","After these things Joseph was told, “Your father is weakening.” So he took his two sons Manasseh and Ephraim with him. ");
INSERT INTO engnet_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When Jacob was told, “Your son Joseph has just come to you,” Israel regained strength and sat up on his bed. ");
INSERT INTO engnet_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob said to Joseph, “The sovereign God appeared to me at Luz in the land of Canaan and blessed me. ");
INSERT INTO engnet_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","He said to me, ‘I am going to make you fruitful and will multiply you. I will make you into a group of nations, and I will give this land to your descendants as an everlasting possession.’ ");
INSERT INTO engnet_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Now, as for your two sons, who were born to you in the land of Egypt before I came to you in Egypt, they will be mine. Ephraim and Manasseh will be mine just as Reuben and Simeon are. ");
INSERT INTO engnet_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Any children that you father after them will be yours; they will be listed under the names of their brothers in their inheritance. ");
INSERT INTO engnet_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","But as for me, when I was returning from Paddan, Rachel died – to my sorrow – in the land of Canaan. It happened along the way, some distance from Ephrath. So I buried her there on the way to Ephrath” (that is, Bethlehem). ");
INSERT INTO engnet_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","When Israel saw Joseph’s sons, he asked, “Who are these?” ");
INSERT INTO engnet_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph said to his father, “They are the sons God has given me in this place.” His father said, “Bring them to me so I may bless them.” ");
INSERT INTO engnet_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now Israel’s eyes were failing because of his age; he was not able to see well. So Joseph brought his sons near to him, and his father kissed them and embraced them. ");
INSERT INTO engnet_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel said to Joseph, “I never expected to see you again, but now God has allowed me to see your children too.” ");
INSERT INTO engnet_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","So Joseph moved them from Israel’s knees and bowed down with his face to the ground. ");
INSERT INTO engnet_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph positioned them; he put Ephraim on his right hand across from Israel’s left hand, and Manasseh on his left hand across from Israel’s right hand. Then Joseph brought them closer to his father. ");
INSERT INTO engnet_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel stretched out his right hand and placed it on Ephraim’s head, although he was the younger. Crossing his hands, he put his left hand on Manasseh’s head, for Manasseh was the firstborn. ");
INSERT INTO engnet_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Then he blessed Joseph and said, “May the God before whom my fathers Abraham and Isaac walked – the God who has been my shepherd all my life long to this day, ");
INSERT INTO engnet_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the Angel who has protected me from all harm – bless these boys. May my name be named in them, and the name of my fathers Abraham and Isaac. May they grow into a multitude on the earth.” ");
INSERT INTO engnet_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","When Joseph saw that his father placed his right hand on Ephraim’s head, it displeased him. So he took his father’s hand to move it from Ephraim’s head to Manasseh’s head. ");
INSERT INTO engnet_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph said to his father, “Not so, my father, for this is the firstborn. Put your right hand on his head.” ");
INSERT INTO engnet_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father refused and said, “I know, my son, I know. He too will become a nation and he too will become great. In spite of this, his younger brother will be even greater and his descendants will become a multitude of nations.” ");
INSERT INTO engnet_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So he blessed them that day, saying, “By you will Israel bless, saying, ‘May God make you like Ephraim and Manasseh.’” So he put Ephraim before Manasseh. ");
INSERT INTO engnet_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Israel said to Joseph, “I am about to die, but God will be with you and will bring you back to the land of your fathers. ");
INSERT INTO engnet_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","As one who is above your brothers, I give to you the mountain slope, which I took from the Amorites with my sword and my bow.” ");
INSERT INTO engnet_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob called for his sons and said, “Gather together so I can tell you what will happen to you in the future. ");
INSERT INTO engnet_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Assemble and listen, you sons of Jacob; listen to Israel, your father. ");
INSERT INTO engnet_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my firstborn, my might and the beginning of my strength, outstanding in dignity, outstanding in power. ");
INSERT INTO engnet_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","You are destructive like water and will not excel, for you got on your father’s bed, then you defiled it – he got on my couch! ");
INSERT INTO engnet_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are brothers, weapons of violence are their knives! ");
INSERT INTO engnet_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O my soul, do not come into their council, do not be united to their assembly, my heart, for in their anger they have killed men, and for pleasure they have hamstrung oxen. ");
INSERT INTO engnet_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cursed be their anger, for it was fierce, and their fury, for it was cruel. I will divide them in Jacob, and scatter them in Israel! ");
INSERT INTO engnet_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, your brothers will praise you. Your hand will be on the neck of your enemies, your father’s sons will bow down before you. ");
INSERT INTO engnet_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","You are a lion’s cub, Judah, from the prey, my son, you have gone up. He crouches and lies down like a lion; like a lioness – who will rouse him? ");
INSERT INTO engnet_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The scepter will not depart from Judah, nor the ruler’s staff from between his feet, until he comes to whom it belongs; the nations will obey him. ");
INSERT INTO engnet_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Binding his foal to the vine, and his colt to the choicest vine, he will wash his garments in wine, his robes in the blood of grapes. ");
INSERT INTO engnet_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes will be dark from wine, and his teeth white from milk. ");
INSERT INTO engnet_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun will live by the haven of the sea and become a haven for ships; his border will extend to Sidon. ");
INSERT INTO engnet_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar is a strong-boned donkey lying down between two saddlebags. ");
INSERT INTO engnet_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","When he sees a good resting place, and the pleasant land, he will bend his shoulder to the burden and become a slave laborer. ");
INSERT INTO engnet_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan will judge his people as one of the tribes of Israel. ");
INSERT INTO engnet_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","May Dan be a snake beside the road, a viper by the path, that bites the heels of the horse so that its rider falls backward. ");
INSERT INTO engnet_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I wait for your deliverance, O Lord. ");
INSERT INTO engnet_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad will be raided by marauding bands, but he will attack them at their heels. ");
INSERT INTO engnet_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher’s food will be rich, and he will provide delicacies to royalty. ");
INSERT INTO engnet_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a free running doe, he speaks delightful words. ");
INSERT INTO engnet_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a fruitful bough, a fruitful bough near a spring whose branches climb over the wall. ");
INSERT INTO engnet_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The archers will attack him, they will shoot at him and oppose him. ");
INSERT INTO engnet_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But his bow will remain steady, and his hands will be skillful; because of the hands of the Mighty One of Jacob, because of the Shepherd, the Rock of Israel, ");
INSERT INTO engnet_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","because of the God of your father, who will help you, because of the sovereign God, who will bless you with blessings from the sky above, blessings from the deep that lies below, and blessings of the breasts and womb. ");
INSERT INTO engnet_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings of your father are greater than the blessings of the eternal mountains or the desirable things of the age-old hills. They will be on the head of Joseph and on the brow of the prince of his brothers. ");
INSERT INTO engnet_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is a ravenous wolf; in the morning devouring the prey, and in the evening dividing the plunder.” ");
INSERT INTO engnet_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are the twelve tribes of Israel. This is what their father said to them when he blessed them. He gave each of them an appropriate blessing. ");
INSERT INTO engnet_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then he instructed them, “I am about to go to my people. Bury me with my fathers in the cave in the field of Ephron the Hittite. ");
INSERT INTO engnet_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","It is the cave in the field of Machpelah, near Mamre in the land of Canaan, which Abraham bought for a burial plot from Ephron the Hittite. ");
INSERT INTO engnet_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There they buried Abraham and his wife Sarah; there they buried Isaac and his wife Rebekah; and there I buried Leah. ");
INSERT INTO engnet_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The field and the cave in it were acquired from the sons of Heth.” ");
INSERT INTO engnet_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob finished giving these instructions to his sons, he pulled his feet up onto the bed, breathed his last breath, and went to his people. ");
INSERT INTO engnet_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Then Joseph hugged his father’s face. He wept over him and kissed him. ");
INSERT INTO engnet_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph instructed the physicians in his service to embalm his father, so the physicians embalmed Israel. ");
INSERT INTO engnet_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","They took forty days, for that is the full time needed for embalming. The Egyptians mourned for him seventy days. ");
INSERT INTO engnet_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","When the days of mourning had passed, Joseph said to Pharaoh’s royal court, “If I have found favor in your sight, please say to Pharaoh, ");
INSERT INTO engnet_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘My father made me swear an oath. He said, “I am about to die. Bury me in my tomb that I dug for myself there in the land of Canaan.” Now let me go and bury my father; then I will return.’” ");
INSERT INTO engnet_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","So Pharaoh said, “Go and bury your father, just as he made you swear to do.” ");
INSERT INTO engnet_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So Joseph went up to bury his father; all Pharaoh’s officials went with him – the senior courtiers of his household, all the senior officials of the land of Egypt, ");
INSERT INTO engnet_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","all Joseph’s household, his brothers, and his father’s household. But they left their little children and their flocks and herds in the land of Goshen. ");
INSERT INTO engnet_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Chariots and horsemen also went up with him, so it was a very large entourage. ");
INSERT INTO engnet_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","When they came to the threshing floor of Atad on the other side of the Jordan, they mourned there with very great and bitter sorrow. There Joseph observed a seven day period of mourning for his father. ");
INSERT INTO engnet_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the Canaanites who lived in the land saw them mourning at the threshing floor of Atad, they said, “This is a very sad occasion for the Egyptians.” That is why its name was called Abel Mizraim, which is beyond the Jordan. ");
INSERT INTO engnet_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","So the sons of Jacob did for him just as he had instructed them. ");
INSERT INTO engnet_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","His sons carried him to the land of Canaan and buried him in the cave of the field of Machpelah, near Mamre. This is the field Abraham purchased as a burial plot from Ephron the Hittite. ");
INSERT INTO engnet_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After he buried his father, Joseph returned to Egypt, along with his brothers and all who had accompanied him to bury his father. ");
INSERT INTO engnet_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","When Joseph’s brothers saw that their father was dead, they said, “What if Joseph bears a grudge and wants to repay us in full for all the harm we did to him?” ");
INSERT INTO engnet_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they sent word to Joseph, saying, “Your father gave these instructions before he died: ");
INSERT INTO engnet_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Tell Joseph this: Please forgive the sin of your brothers and the wrong they did when they treated you so badly.’ Now please forgive the sin of the servants of the God of your father.” When this message was reported to him, Joseph wept. ");
INSERT INTO engnet_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Then his brothers also came and threw themselves down before him; they said, “Here we are; we are your slaves.” ");
INSERT INTO engnet_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","But Joseph answered them, “Don’t be afraid. Am I in the place of God? ");
INSERT INTO engnet_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, you meant to harm me, but God intended it for a good purpose, so he could preserve the lives of many people, as you can see this day. ");
INSERT INTO engnet_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So now, don’t be afraid. I will provide for you and your little children.” Then he consoled them and spoke kindly to them. ");
INSERT INTO engnet_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph lived in Egypt, along with his father’s family. Joseph lived 110 years. ");
INSERT INTO engnet_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph saw the descendants of Ephraim to the third generation. He also saw the children of Makir the son of Manasseh; they were given special inheritance rights by Joseph. ");
INSERT INTO engnet_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Then Joseph said to his brothers, “I am about to die. But God will surely come to you and lead you up from this land to the land he swore on oath to give to Abraham, Isaac, and Jacob.” ");
INSERT INTO engnet_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph made the sons of Israel swear an oath. He said, “God will surely come to you. Then you must carry my bones up from this place.” ");
INSERT INTO engnet_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph died at the age of 110. After they embalmed him, his body was placed in a coffin in Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","These are the names of the sons of Israel who entered Egypt – each man with his household entered with Jacob: ");
INSERT INTO engnet_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah, ");
INSERT INTO engnet_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin, ");
INSERT INTO engnet_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali, Gad and Asher. ");
INSERT INTO engnet_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","All the people who were directly descended from Jacob numbered seventy. But Joseph was already in Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","and in time Joseph and his brothers and all that generation died. ");
INSERT INTO engnet_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","The Israelites, however, were fruitful, increased greatly, multiplied, and became extremely strong, so that the land was filled with them. ");
INSERT INTO engnet_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Then a new king, who did not know about Joseph, came to power over Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He said to his people, “Look at the Israelite people, more numerous and stronger than we are! ");
INSERT INTO engnet_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let’s deal wisely with them. Otherwise they will continue to multiply, and if a war breaks out, they will ally themselves with our enemies and fight against us and leave the country.” ");
INSERT INTO engnet_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So they put foremen over the Israelites to oppress them with hard labor. As a result they built Pithom and Rameses as store cities for Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more the Egyptians oppressed them, the more they multiplied and spread. As a result the Egyptians loathed the Israelites, ");
INSERT INTO engnet_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","and they made the Israelites serve rigorously. ");
INSERT INTO engnet_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","They made their lives bitter by hard service with mortar and bricks and by all kinds of service in the fields. Every kind of service the Israelites were required to give was rigorous. ");
INSERT INTO engnet_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","The king of Egypt said to the Hebrew midwives, one of whom was named Shiphrah and the other Puah, ");
INSERT INTO engnet_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“When you assist the Hebrew women in childbirth, observe at the delivery: If it is a son, kill him, but if it is a daughter, she may live.” ");
INSERT INTO engnet_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the midwives feared God and did not do what the king of Egypt had told them; they let the boys live. ");
INSERT INTO engnet_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Then the king of Egypt summoned the midwives and said to them, “Why have you done this and let the boys live?” ");
INSERT INTO engnet_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The midwives said to Pharaoh, “Because the Hebrew women are not like the Egyptian women – for the Hebrew women are vigorous; they give birth before the midwife gets to them!” ");
INSERT INTO engnet_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","So God treated the midwives well, and the people multiplied and became very strong. ");
INSERT INTO engnet_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","And because the midwives feared God, he made households for them. ");
INSERT INTO engnet_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Then Pharaoh commanded all his people, “All sons that are born you must throw into the river, but all daughters you may let live.” ");
INSERT INTO engnet_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","A man from the household of Levi married a woman who was a descendant of Levi. ");
INSERT INTO engnet_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","The woman became pregnant and gave birth to a son. When she saw that he was a healthy child, she hid him for three months. ");
INSERT INTO engnet_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","But when she was no longer able to hide him, she took a papyrus basket for him and sealed it with bitumen and pitch. She put the child in it and set it among the reeds along the edge of the Nile. ");
INSERT INTO engnet_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","His sister stationed herself at a distance to find out what would happen to him. ");
INSERT INTO engnet_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Then the daughter of Pharaoh came down to wash herself by the Nile, while her attendants were walking alongside the river, and she saw the basket among the reeds. She sent one of her attendants, took it, ");
INSERT INTO engnet_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","opened it, and saw the child – a boy, crying! – and she felt compassion for him and said, “This is one of the Hebrews’ children.” ");
INSERT INTO engnet_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then his sister said to Pharaoh’s daughter, “Shall I go and get a nursing woman for you from the Hebrews, so that she may nurse the child for you?” ");
INSERT INTO engnet_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pharaoh’s daughter said to her, “Yes, do so.” So the young girl went and got the child’s mother. ");
INSERT INTO engnet_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pharaoh’s daughter said to her, “Take this child and nurse him for me, and I will pay your wages.” So the woman took the child and nursed him. ");
INSERT INTO engnet_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","When the child grew older she brought him to Pharaoh’s daughter, and he became her son. She named him Moses, saying, “Because I drew him from the water.” ");
INSERT INTO engnet_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","In those days, when Moses had grown up, he went out to his people and observed their hard labor, and he saw an Egyptian man attacking a Hebrew man, one of his own people. ");
INSERT INTO engnet_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","He looked this way and that and saw that no one was there, and then he attacked the Egyptian and concealed the body in the sand. ");
INSERT INTO engnet_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","When he went out the next day, there were two Hebrew men fighting. So he said to the one who was in the wrong, “Why are you attacking your fellow Hebrew?” ");
INSERT INTO engnet_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","The man replied, “Who made you a ruler and a judge over us? Are you planning to kill me like you killed that Egyptian?” Then Moses was afraid, thinking, “Surely what I did has become known.” ");
INSERT INTO engnet_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","When Pharaoh heard about this event, he sought to kill Moses. So Moses fled from Pharaoh and settled in the land of Midian, and he settled by a certain well. ");
INSERT INTO engnet_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now a priest of Midian had seven daughters, and they came and began to draw water and fill the troughs in order to water their father’s flock. ");
INSERT INTO engnet_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","When some shepherds came and drove them away, Moses came up and defended them and then watered their flock. ");
INSERT INTO engnet_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","So when they came home to their father Reuel, he asked, “Why have you come home so early today?” ");
INSERT INTO engnet_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","They said, “An Egyptian man rescued us from the shepherds, and he actually drew water for us and watered the flock!” ");
INSERT INTO engnet_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","He said to his daughters, “So where is he? Why in the world did you leave the man? Call him, so that he may eat a meal with us.” ");
INSERT INTO engnet_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses agreed to stay with the man, and he gave his daughter Zipporah to Moses in marriage. ");
INSERT INTO engnet_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","When she bore a son, Moses named him Gershom, for he said, “I have become a resident foreigner in a foreign land.” ");
INSERT INTO engnet_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","During that long period of time the king of Egypt died, and the Israelites groaned because of the slave labor. They cried out, and their desperate cry because of their slave labor went up to God. ");
INSERT INTO engnet_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","God heard their groaning, God remembered his covenant with Abraham, with Isaac, and with Jacob, ");
INSERT INTO engnet_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw the Israelites, and God understood…. ");
INSERT INTO engnet_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Now Moses was shepherding the flock of his father-in-law Jethro, the priest of Midian, and he led the flock to the far side of the desert and came to the mountain of God, to Horeb. ");
INSERT INTO engnet_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","The angel of the Lord appeared to him in a flame of fire from within a bush. He looked – and the bush was ablaze with fire, but it was not being consumed! ");
INSERT INTO engnet_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","So Moses thought, “I will turn aside to see this amazing sight. Why does the bush not burn up?” ");
INSERT INTO engnet_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When the Lord saw that he had turned aside to look, God called to him from within the bush and said, “Moses, Moses!” And Moses said, “Here I am.” ");
INSERT INTO engnet_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","God said, “Do not approach any closer! Take your sandals off your feet, for the place where you are standing is holy ground.” ");
INSERT INTO engnet_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","He added, “I am the God of your father, the God of Abraham, the God of Isaac, and the God of Jacob.” Then Moses hid his face, because he was afraid to look at God. ");
INSERT INTO engnet_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","The Lord said, “I have surely seen the affliction of my people who are in Egypt. I have heard their cry because of their taskmasters, for I know their sorrows. ");
INSERT INTO engnet_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I have come down to deliver them from the hand of the Egyptians and to bring them up from that land to a land that is both good and spacious, to a land flowing with milk and honey, to the region of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engnet_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","And now indeed the cry of the Israelites has come to me, and I have also seen how severely the Egyptians oppress them. ");
INSERT INTO engnet_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","So now go, and I will send you to Pharaoh to bring my people, the Israelites, out of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moses said to God, “Who am I, that I should go to Pharaoh, or that I should bring the Israelites out of Egypt?” ");
INSERT INTO engnet_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","He replied, “Surely I will be with you, and this will be the sign to you that I have sent you: When you bring the people out of Egypt, you and they will serve God on this mountain.” ");
INSERT INTO engnet_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moses said to God, “If I go to the Israelites and tell them, ‘The God of your fathers has sent me to you,’ and they ask me, ‘What is his name?’ – what should I say to them?” ");
INSERT INTO engnet_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God said to Moses, “I am that I am.” And he said, “You must say this to the Israelites, ‘I am has sent me to you.’” ");
INSERT INTO engnet_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","God also said to Moses, “You must say this to the Israelites, ‘The Lord – the God of your fathers, the God of Abraham, the God of Isaac, and the God of Jacob – has sent me to you. This is my name forever, and this is my memorial from generation to generation.’ ");
INSERT INTO engnet_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Go and bring together the elders of Israel and tell them, ‘The Lord, the God of your fathers, appeared to me – the God of Abraham, Isaac, and Jacob – saying, “I have attended carefully to you and to what has been done to you in Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","and I have promised that I will bring you up out of the affliction of Egypt to the land of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites, to a land flowing with milk and honey.”’ ");
INSERT INTO engnet_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“The elders will listen to you, and then you and the elders of Israel must go to the king of Egypt and tell him, ‘The Lord, the God of the Hebrews, has met with us. So now, let us go three days’ journey into the wilderness, so that we may sacrifice to the Lord our God.’ ");
INSERT INTO engnet_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But I know that the king of Egypt will not let you go, not even under force. ");
INSERT INTO engnet_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","So I will extend my hand and strike Egypt with all my wonders that I will do among them, and after that he will release you. ");
INSERT INTO engnet_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“I will grant this people favor with the Egyptians, so that when you depart you will not leave empty-handed. ");
INSERT INTO engnet_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Every woman will ask her neighbor and the one who happens to be staying in her house for items of silver and gold and for clothing. You will put these articles on your sons and daughters – thus you will plunder Egypt!” ");
INSERT INTO engnet_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moses answered again, “And if they do not believe me or pay attention to me, but say, ‘The Lord has not appeared to you’?” ");
INSERT INTO engnet_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","The Lord said to him, “What is that in your hand?” He said, “A staff.” ");
INSERT INTO engnet_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","The Lord said, “Throw it to the ground.” So he threw it to the ground, and it became a snake, and Moses ran from it. ");
INSERT INTO engnet_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","But the Lord said to Moses, “Put out your hand and grab it by the tail” – so he put out his hand and caught it, and it became a staff in his hand – ");
INSERT INTO engnet_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“that they may believe that the Lord, the God of their fathers, the God of Abraham, the God of Isaac, and the God of Jacob, has appeared to you.” ");
INSERT INTO engnet_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","The Lord also said to him, “Put your hand into your robe.” So he put his hand into his robe, and when he brought it out – there was his hand, leprous like snow! ");
INSERT INTO engnet_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","He said, “Put your hand back into your robe.” So he put his hand back into his robe, and when he brought it out from his robe – there it was, restored like the rest of his skin! ");
INSERT INTO engnet_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“If they do not believe you or pay attention to the former sign, then they may believe the latter sign. ");
INSERT INTO engnet_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","And if they do not believe even these two signs or listen to you, then take some water from the Nile and pour it out on the dry ground. The water you take out of the Nile will become blood on the dry ground.” ");
INSERT INTO engnet_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Then Moses said to the Lord, “O my Lord, I am not an eloquent man, neither in the past nor since you have spoken to your servant, for I am slow of speech and slow of tongue.” ");
INSERT INTO engnet_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","The Lord said to him, “Who gave a mouth to man, or who makes a person mute or deaf or seeing or blind? Is it not I, the Lord? ");
INSERT INTO engnet_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So now go, and I will be with your mouth and will teach you what you must say.” ");
INSERT INTO engnet_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","But Moses said, “O my Lord, please send anyone else whom you wish to send!” ");
INSERT INTO engnet_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Then the Lord became angry with Moses, and he said, “What about your brother Aaron the Levite? I know that he can speak very well. Moreover, he is coming to meet you, and when he sees you he will be glad in his heart. ");
INSERT INTO engnet_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","“So you are to speak to him and put the words in his mouth. And as for me, I will be with your mouth and with his mouth, and I will teach you both what you must do. ");
INSERT INTO engnet_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will speak for you to the people, and it will be as if he were your mouth and as if you were his God. ");
INSERT INTO engnet_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","You will also take in your hand this staff, with which you will do the signs.” ");
INSERT INTO engnet_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","So Moses went back to his father-in-law Jethro and said to him, “Let me go, so that I may return to my relatives in Egypt and see if they are still alive.” Jethro said to Moses, “Go in peace.” ");
INSERT INTO engnet_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","The Lord said to Moses in Midian, “Go back to Egypt, because all the men who were seeking your life are dead.” ");
INSERT INTO engnet_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Then Moses took his wife and sons and put them on a donkey and headed back to the land of Egypt, and Moses took the staff of God in his hand. ");
INSERT INTO engnet_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","The Lord said to Moses, “When you go back to Egypt, see that you do before Pharaoh all the wonders I have put under your control. But I will harden his heart and he will not let the people go. ");
INSERT INTO engnet_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","You must say to Pharaoh, ‘Thus says the Lord, “Israel is my son, my firstborn, ");
INSERT INTO engnet_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","and I said to you, ‘Let my son go that he may serve me,’ but since you have refused to let him go, I will surely kill your son, your firstborn!”’” ");
INSERT INTO engnet_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Now on the way, at a place where they stopped for the night, the Lord met Moses and sought to kill him. ");
INSERT INTO engnet_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","But Zipporah took a flint knife, cut off the foreskin of her son and touched it to Moses’ feet, and said, “Surely you are a bridegroom of blood to me.” ");
INSERT INTO engnet_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So the Lord let him alone. (At that time she said, “A bridegroom of blood,” referring to the circumcision.) ");
INSERT INTO engnet_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","The Lord said to Aaron, “Go to the wilderness to meet Moses. So he went and met him at the mountain of God and greeted him with a kiss. ");
INSERT INTO engnet_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses told Aaron all the words of the Lord who had sent him and all the signs that he had commanded him. ");
INSERT INTO engnet_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Then Moses and Aaron went and brought together all the Israelite elders. ");
INSERT INTO engnet_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron spoke all the words that the Lord had spoken to Moses and did the signs in the sight of the people, ");
INSERT INTO engnet_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","and the people believed. When they heard that the Lord had attended to the Israelites and that he had seen their affliction, they bowed down close to the ground. ");
INSERT INTO engnet_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Afterward Moses and Aaron went to Pharaoh and said, “Thus says the Lord, the God of Israel, ‘Release my people so that they may hold a pilgrim feast to me in the desert.’” ");
INSERT INTO engnet_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","But Pharaoh said, “Who is the Lord that I should obey him by releasing Israel? I do not know the Lord, and I will not release Israel!” ");
INSERT INTO engnet_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","And they said, “The God of the Hebrews has met with us. Let us go a three-day journey into the desert so that we may sacrifice to the Lord our God, so that he does not strike us with plague or the sword.” ");
INSERT INTO engnet_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","The king of Egypt said to them, “Moses and Aaron, why do you cause the people to refrain from their work? Return to your labor!” ");
INSERT INTO engnet_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaoh was thinking, “The people of the land are now many, and you are giving them rest from their labor.” ");
INSERT INTO engnet_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","That same day Pharaoh commanded the slave masters and foremen who were over the people: ");
INSERT INTO engnet_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“You must no longer give straw to the people for making bricks as before. Let them go and collect straw for themselves. ");
INSERT INTO engnet_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But you must require of them the same quota of bricks that they were making before. Do not reduce it, for they are slackers. That is why they are crying, ‘Let us go sacrifice to our God.’ ");
INSERT INTO engnet_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Make the work harder for the men so they will keep at it and pay no attention to lying words!” ");
INSERT INTO engnet_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the slave masters of the people and their foremen went to the Israelites and said, “Thus says Pharaoh: ‘I am not giving you straw. ");
INSERT INTO engnet_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","You go get straw for yourselves wherever you can find it, because there will be no reduction at all in your workload.’” ");
INSERT INTO engnet_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people spread out through all the land of Egypt to collect stubble for straw. ");
INSERT INTO engnet_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The slave masters were pressuring them, saying, “Complete your work for each day, just like when there was straw!” ");
INSERT INTO engnet_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","The Israelite foremen whom Pharaoh’s slave masters had set over them were beaten and were asked, “Why did you not complete your requirement for brickmaking as in the past – both yesterday and today?” ");
INSERT INTO engnet_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","The Israelite foremen went and cried out to Pharaoh, “Why are you treating your servants this way? ");
INSERT INTO engnet_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No straw is given to your servants, but we are told, ‘Make bricks!’ Your servants are even being beaten, but the fault is with your people.” ");
INSERT INTO engnet_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","But Pharaoh replied, “You are slackers! Slackers! That is why you are saying, ‘Let us go sacrifice to the Lord.’ ");
INSERT INTO engnet_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","So now, get back to work! You will not be given straw, but you must still produce your quota of bricks!” ");
INSERT INTO engnet_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Israelite foremen saw that they were in trouble when they were told, “You must not reduce the daily quota of your bricks.” ");
INSERT INTO engnet_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","When they went out from Pharaoh, they encountered Moses and Aaron standing there to meet them, ");
INSERT INTO engnet_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","and they said to them, “May the Lord look on you and judge, because you have made us stink in the opinion of Pharaoh and his servants, so that you have given them an excuse to kill us!” ");
INSERT INTO engnet_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses returned to the Lord, and said, “Lord, why have you caused trouble for this people? Why did you ever send me? ");
INSERT INTO engnet_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","From the time I went to speak to Pharaoh in your name, he has caused trouble for this people, and you have certainly not rescued them!” ");
INSERT INTO engnet_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Then the Lord said to Moses, “Now you will see what I will do to Pharaoh, for compelled by my strong hand he will release them, and by my strong hand he will drive them out of his land.” ");
INSERT INTO engnet_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God spoke to Moses and said to him, “I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I appeared to Abraham, to Isaac, and to Jacob as God Almighty, but by my name ‘the Lord’ I was not known to them. ");
INSERT INTO engnet_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I also established my covenant with them to give them the land of Canaan, where they were living as resident foreigners. ");
INSERT INTO engnet_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","I have also heard the groaning of the Israelites, whom the Egyptians are enslaving, and I have remembered my covenant. ");
INSERT INTO engnet_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore, tell the Israelites, ‘I am the Lord. I will bring you out from your enslavement to the Egyptians, I will rescue you from the hard labor they impose, and I will redeem you with an outstretched arm and with great judgments. ");
INSERT INTO engnet_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will take you to myself for a people, and I will be your God. Then you will know that I am the Lord your God, who brought you out from your enslavement to the Egyptians. ");
INSERT INTO engnet_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I will bring you to the land I swore to give to Abraham, to Isaac, and to Jacob – and I will give it to you as a possession. I am the Lord!’” ");
INSERT INTO engnet_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses told this to the Israelites, but they did not listen to him because of their discouragement and hard labor. ");
INSERT INTO engnet_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Then the Lord said to Moses, ");
INSERT INTO engnet_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go, tell Pharaoh king of Egypt that he must release the Israelites from his land.” ");
INSERT INTO engnet_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","But Moses replied to the Lord, “If the Israelites did not listen to me, then how will Pharaoh listen to me, since I speak with difficulty?” ");
INSERT INTO engnet_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","The Lord spoke to Moses and Aaron and gave them a charge for the Israelites and Pharaoh king of Egypt to bring the Israelites out of the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the heads of their fathers’ households: The sons of Reuben, the firstborn son of Israel, were Hanoch and Pallu, Hezron and Carmi. These were the clans of Reuben. ");
INSERT INTO engnet_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon were Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul, the son of a Canaanite woman. These were the clans of Simeon. ");
INSERT INTO engnet_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Now these are the names of the sons of Levi, according to their records: Gershon, Kohath, and Merari. (The length of Levi’s life was 137 years.) ");
INSERT INTO engnet_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon, by their families, were Libni and Shimei. ");
INSERT INTO engnet_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath were Amram, Izhar, Hebron, and Uzziel. (The length of Kohath’s life was 133 years.) ");
INSERT INTO engnet_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari were Mahli and Mushi. These were the clans of Levi, according to their records. ");
INSERT INTO engnet_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram married his father’s sister Jochebed, and she bore him Aaron and Moses. (The length of Amram’s life was 137 years.) ");
INSERT INTO engnet_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar were Korah, Nepheg, and Zikri. ");
INSERT INTO engnet_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel were Mishael, Elzaphan, and Sithri. ");
INSERT INTO engnet_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron married Elisheba, the daughter of Amminadab and sister of Nahshon, and she bore him Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engnet_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah were Assir, Elkanah, and Abiasaph. These were the Korahite clans. ");
INSERT INTO engnet_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Now Eleazar son of Aaron married one of the daughters of Putiel and she bore him Phinehas. These are the heads of the fathers’ households of Levi according to their clans. ");
INSERT INTO engnet_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","It was the same Aaron and Moses to whom the Lord said, “Bring the Israelites out of the land of Egypt by their regiments.” ");
INSERT INTO engnet_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","They were the men who were speaking to Pharaoh king of Egypt, in order to bring the Israelites out of Egypt. It was the same Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","When the Lord spoke to Moses in the land of Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","he said to him, “I am the Lord. Tell Pharaoh king of Egypt all that I am telling you.” ");
INSERT INTO engnet_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Moses said before the Lord, “Since I speak with difficulty, why should Pharaoh listen to me?” ");
INSERT INTO engnet_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","So the Lord said to Moses, “See, I have made you like God to Pharaoh, and your brother Aaron will be your prophet. ");
INSERT INTO engnet_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You are to speak everything I command you, and your brother Aaron is to tell Pharaoh that he must release the Israelites from his land. ");
INSERT INTO engnet_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will harden Pharaoh’s heart, and although I will multiply my signs and my wonders in the land of Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pharaoh will not listen to you. I will reach into Egypt and bring out my regiments, my people the Israelites, from the land of Egypt with great acts of judgment. ");
INSERT INTO engnet_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Then the Egyptians will know that I am the Lord, when I extend my hand over Egypt and bring the Israelites out from among them. ");
INSERT INTO engnet_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","And Moses and Aaron did so; they did just as the Lord commanded them. ");
INSERT INTO engnet_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Now Moses was eighty years old and Aaron was eighty-three years old when they spoke to Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","The Lord said to Moses and Aaron, ");
INSERT INTO engnet_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“When Pharaoh says to you, ‘Do a miracle,’ and you say to Aaron, ‘Take your staff and throw it down before Pharaoh,’ it will become a snake.” ");
INSERT INTO engnet_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","When Moses and Aaron went to Pharaoh, they did so, just as the Lord had commanded them – Aaron threw down his staff before Pharaoh and his servants and it became a snake. ");
INSERT INTO engnet_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Then Pharaoh also summoned wise men and sorcerers, and the magicians of Egypt by their secret arts did the same thing. ");
INSERT INTO engnet_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Each man threw down his staff, and the staffs became snakes. But Aaron’s staff swallowed up their staffs. ");
INSERT INTO engnet_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Yet Pharaoh’s heart became hard, and he did not listen to them, just as the Lord had predicted. ");
INSERT INTO engnet_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","The Lord said to Moses, “Pharaoh’s heart is hard; he refuses to release the people. ");
INSERT INTO engnet_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go to Pharaoh in the morning when he goes out to the water. Position yourself to meet him by the edge of the Nile, and take in your hand the staff that was turned into a snake. ");
INSERT INTO engnet_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tell him, ‘The Lord, the God of the Hebrews, has sent me to you to say, “Release my people, that they may serve me in the desert!” But until now you have not listened. ");
INSERT INTO engnet_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Thus says the Lord: “By this you will know that I am the Lord: I am going to strike the water of the Nile with the staff that is in my hand, and it will be turned into blood. ");
INSERT INTO engnet_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Fish in the Nile will die, the Nile will stink, and the Egyptians will be unable to drink water from the Nile.”’” ");
INSERT INTO engnet_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Then the Lord said to Moses, “Tell Aaron, ‘Take your staff and stretch out your hand over Egypt’s waters – over their rivers, over their canals, over their ponds, and over all their reservoirs – so that it becomes blood.’ There will be blood everywhere in the land of Egypt, even in wooden and stone containers.” ");
INSERT INTO engnet_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses and Aaron did so, just as the Lord had commanded. Moses raised the staff and struck the water that was in the Nile right before the eyes of Pharaoh and his servants, and all the water that was in the Nile was turned to blood. ");
INSERT INTO engnet_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","When the fish that were in the Nile died, the Nile began to stink, so that the Egyptians could not drink water from the Nile. There was blood everywhere in the land of Egypt! ");
INSERT INTO engnet_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","But the magicians of Egypt did the same by their secret arts, and so Pharaoh’s heart remained hard, and he refused to listen to Moses and Aaron – just as the Lord had predicted. ");
INSERT INTO engnet_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","And Pharaoh turned and went into his house. He did not pay any attention to this. ");
INSERT INTO engnet_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","All the Egyptians dug around the Nile for water to drink, because they could not drink the water of the Nile. ");
INSERT INTO engnet_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Seven full days passed after the Lord struck the Nile. ");
INSERT INTO engnet_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then the Lord said to Moses, “Go to Pharaoh and tell him, ‘Thus says the Lord: “Release my people in order that they may serve me! ");
INSERT INTO engnet_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","But if you refuse to release them, then I am going to plague all your territory with frogs. ");
INSERT INTO engnet_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The Nile will swarm with frogs, and they will come up and go into your house, in your bedroom, and on your bed, and into the houses of your servants and your people, and into your ovens and your kneading troughs. ");
INSERT INTO engnet_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Frogs will come up against you, your people, and all your servants.”’” ");
INSERT INTO engnet_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","The Lord spoke to Moses, “Tell Aaron, ‘Extend your hand with your staff over the rivers, over the canals, and over the ponds, and bring the frogs up over the land of Egypt.’” ");
INSERT INTO engnet_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","So Aaron extended his hand over the waters of Egypt, and frogs came up and covered the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","The magicians did the same with their secret arts and brought up frogs on the land of Egypt too. ");
INSERT INTO engnet_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Then Pharaoh summoned Moses and Aaron and said, “Pray to the Lord that he may take the frogs away from me and my people, and I will release the people that they may sacrifice to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses said to Pharaoh, “You may have the honor over me – when shall I pray for you, your servants, and your people, for the frogs to be removed from you and your houses, so that they will be left only in the Nile?” ");
INSERT INTO engnet_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","He said, “Tomorrow.” And Moses said, “It will be as you say, so that you may know that there is no one like the Lord our God. ");
INSERT INTO engnet_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will depart from you, your houses, your servants, and your people; they will be left only in the Nile.” ");
INSERT INTO engnet_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Then Moses and Aaron went out from Pharaoh, and Moses cried to the Lord because of the frogs that he had brought on Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","The Lord did as Moses asked – the frogs died out of the houses, the villages, and the fields. ");
INSERT INTO engnet_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","The Egyptians piled them in countless heaps, and the land stank. ");
INSERT INTO engnet_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh saw that there was relief, he hardened his heart and did not listen to them, just as the Lord had predicted. ");
INSERT INTO engnet_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","The Lord said to Moses, “Tell Aaron, ‘Extend your staff and strike the dust of the ground, and it will become gnats throughout all the land of Egypt.’” ");
INSERT INTO engnet_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","They did so; Aaron extended his hand with his staff, he struck the dust of the ground, and it became gnats on people and on animals. All the dust of the ground became gnats throughout all the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","When the magicians attempted to bring forth gnats by their secret arts, they could not. So there were gnats on people and on animals. ");
INSERT INTO engnet_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","The magicians said to Pharaoh, “It is the finger of God!” But Pharaoh’s heart remained hard, and he did not listen to them, just as the Lord had predicted. ");
INSERT INTO engnet_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","The Lord said to Moses, “Get up early in the morning and position yourself before Pharaoh as he goes out to the water, and tell him, ‘Thus says the Lord, “Release my people that they may serve me! ");
INSERT INTO engnet_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","If you do not release my people, then I am going to send swarms of flies on you and on your servants and on your people and in your houses. The houses of the Egyptians will be full of flies, and even the ground they stand on. ");
INSERT INTO engnet_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But on that day I will mark off the land of Goshen, where my people are staying, so that no swarms of flies will be there, that you may know that I am the Lord in the midst of this land. ");
INSERT INTO engnet_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will put a division between my people and your people. This sign will take place tomorrow.”’” ");
INSERT INTO engnet_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","The Lord did so; a thick swarm of flies came into Pharaoh’s house and into the houses of his servants, and throughout the whole land of Egypt the land was ruined because of the swarms of flies. ");
INSERT INTO engnet_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Then Pharaoh summoned Moses and Aaron and said, “Go, sacrifice to your God within the land.” ");
INSERT INTO engnet_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","But Moses said, “That would not be the right thing to do, for the sacrifices we make to the Lord our God would be an abomination to the Egyptians. If we make sacrifices that are an abomination to the Egyptians right before their eyes, will they not stone us? ");
INSERT INTO engnet_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","We must go on a three-day journey into the desert and sacrifice to the Lord our God, just as he is telling us.” ");
INSERT INTO engnet_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh said, “I will release you so that you may sacrifice to the Lord your God in the desert. Only you must not go very far. Do pray for me.” ");
INSERT INTO engnet_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses said, “I am going to go out from you and pray to the Lord, and the swarms of flies will go away from Pharaoh, from his servants, and from his people tomorrow. Only do not let Pharaoh deal falsely again by not releasing the people to sacrifice to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","So Moses went out from Pharaoh and prayed to the Lord, ");
INSERT INTO engnet_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","and the Lord did as Moses asked – he removed the swarms of flies from Pharaoh, from his servants, and from his people. Not one remained! ");
INSERT INTO engnet_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But Pharaoh hardened his heart this time also and did not release the people. ");
INSERT INTO engnet_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then the Lord said to Moses, “Go to Pharaoh and tell him, ‘Thus says the Lord, the God of the Hebrews, “Release my people that they may serve me! ");
INSERT INTO engnet_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","For if you refuse to release them and continue holding them, ");
INSERT INTO engnet_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","then the hand of the Lord will surely bring a very terrible plague on your livestock in the field, on the horses, the donkeys, the camels, the herds, and the flocks. ");
INSERT INTO engnet_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But the Lord will distinguish between the livestock of Israel and the livestock of Egypt, and nothing will die of all that the Israelites have.”’” ");
INSERT INTO engnet_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","The Lord set an appointed time, saying, “Tomorrow the Lord will do this in the land.” ");
INSERT INTO engnet_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And the Lord did this on the next day; all the livestock of the Egyptians died, but of the Israelites’ livestock not one died. ");
INSERT INTO engnet_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh sent representatives to investigate, and indeed, not even one of the livestock of Israel had died. But Pharaoh’s heart remained hard, and he did not release the people. ");
INSERT INTO engnet_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Then the Lord said to Moses and Aaron, “Take handfuls of soot from a furnace, and have Moses throw it into the air while Pharaoh is watching. ");
INSERT INTO engnet_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","It will become fine dust over the whole land of Egypt and will cause boils to break out and fester on both people and animals in all the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So they took soot from a furnace and stood before Pharaoh, Moses threw it into the air, and it caused festering boils to break out on both people and animals. ");
INSERT INTO engnet_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians could not stand before Moses because of the boils, for boils were on the magicians and on all the Egyptians. ");
INSERT INTO engnet_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","But the Lord hardened Pharaoh’s heart, and he did not listen to them, just as the Lord had predicted to Moses. ");
INSERT INTO engnet_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","The Lord said to Moses, “Get up early in the morning, stand before Pharaoh, and tell him, ‘Thus says the Lord, the God of the Hebrews: “Release my people so that they may serve me! ");
INSERT INTO engnet_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","For this time I will send all my plagues on your very self and on your servants and your people, so that you may know that there is no one like me in all the earth. ");
INSERT INTO engnet_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For by now I could have stretched out my hand and struck you and your people with plague, and you would have been destroyed from the earth. ");
INSERT INTO engnet_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But for this purpose I have caused you to stand: to show you my strength, and so that my name may be declared in all the earth. ");
INSERT INTO engnet_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","You are still exalting yourself against my people by not releasing them. ");
INSERT INTO engnet_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","I am going to cause very severe hail to rain down about this time tomorrow, such hail as has never occurred in Egypt from the day it was founded until now. ");
INSERT INTO engnet_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","So now, send instructions to gather your livestock and all your possessions in the fields to a safe place. Every person or animal caught in the field and not brought into the house – the hail will come down on them, and they will die!”’” ");
INSERT INTO engnet_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Those of Pharaoh’s servants who feared the word of the Lord hurried to bring their servants and livestock into the houses, ");
INSERT INTO engnet_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","but those who did not take the word of the Lord seriously left their servants and their cattle in the field. ");
INSERT INTO engnet_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Then the Lord said to Moses, “Extend your hand toward the sky that there may be hail in all the land of Egypt, on people and on animals, and on everything that grows in the field in the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","When Moses extended his staff toward the sky, the Lord sent thunder and hail, and fire fell to the earth; so the Lord caused hail to rain down on the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hail fell and fire mingled with the hail; the hail was so severe that there had not been any like it in all the land of Egypt since it had become a nation. ");
INSERT INTO engnet_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","The hail struck everything in the open fields, both people and animals, throughout all the land of Egypt. The hail struck everything that grows in the field, and it broke all the trees of the field to pieces. ");
INSERT INTO engnet_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen, where the Israelites lived, was there no hail. ");
INSERT INTO engnet_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","So Pharaoh sent and summoned Moses and Aaron and said to them, “I have sinned this time! The Lord is righteous, and I and my people are guilty. ");
INSERT INTO engnet_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray to the Lord, for the mighty thunderings and hail are too much! I will release you and you will stay no longer.” ");
INSERT INTO engnet_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses said to him, “When I leave the city I will spread my hands to the Lord, the thunder will cease, and there will be no more hail, so that you may know that the earth belongs to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your servants, I know that you do not yet fear the Lord God.” ");
INSERT INTO engnet_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Now the flax and the barley were struck by the hail, for the barley had ripened and the flax was in bud. ");
INSERT INTO engnet_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But the wheat and the spelt were not struck, for they are later crops.) ");
INSERT INTO engnet_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","So Moses left Pharaoh, went out of the city, and spread out his hands to the Lord, and the thunder and the hail ceased, and the rain stopped pouring on the earth. ");
INSERT INTO engnet_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain and hail and thunder ceased, he sinned again: both he and his servants hardened their hearts. ");
INSERT INTO engnet_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","So Pharaoh’s heart remained hard, and he did not release the Israelites, as the Lord had predicted through Moses. ");
INSERT INTO engnet_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","The Lord said to Moses, “Go to Pharaoh, for I have hardened his heart and the heart of his servants, in order to display these signs of mine before him, ");
INSERT INTO engnet_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and in order that in the hearing of your son and your grandson you may tell how I made fools of the Egyptians and about my signs that I displayed among them, so that you may know that I am the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","So Moses and Aaron came to Pharaoh and told him, “Thus says the Lord, the God of the Hebrews: ‘How long do you refuse to humble yourself before me? Release my people so that they may serve me! ");
INSERT INTO engnet_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","But if you refuse to release my people, I am going to bring locusts into your territory tomorrow. ");
INSERT INTO engnet_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","They will cover the surface of the earth, so that you will be unable to see the ground. They will eat the remainder of what escaped – what is left over for you – from the hail, and they will eat every tree that grows for you from the field. ");
INSERT INTO engnet_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will fill your houses, the houses of your servants, and all the houses of Egypt, such as neither your fathers nor your grandfathers have seen since they have been in the land until this day!’” Then Moses turned and went out from Pharaoh. ");
INSERT INTO engnet_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh’s servants said to him, “How long will this man be a menace to us? Release the people so that they may serve the Lord their God. Do you not know that Egypt is destroyed?” ");
INSERT INTO engnet_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","So Moses and Aaron were brought back to Pharaoh, and he said to them, “Go, serve the Lord your God. Exactly who is going with you?” ");
INSERT INTO engnet_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses said, “We will go with our young and our old, with our sons and our daughters, and with our sheep and our cattle we will go, because we are to hold a pilgrim feast for the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","He said to them, “The Lord will need to be with you if I release you and your dependents! Watch out! Trouble is right in front of you! ");
INSERT INTO engnet_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","No! Go, you men only, and serve the Lord, for that is what you want.” Then Moses and Aaron were driven out of Pharaoh’s presence. ");
INSERT INTO engnet_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","The Lord said to Moses, “Extend your hand over the land of Egypt for the locusts, that they may come up over the land of Egypt and eat everything that grows in the ground, everything that the hail has left.” ");
INSERT INTO engnet_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","So Moses extended his staff over the land of Egypt, and then the Lord brought an east wind on the land all that day and all night. The morning came, and the east wind had brought up the locusts! ");
INSERT INTO engnet_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts went up over all the land of Egypt and settled down in all the territory of Egypt. It was very severe; there had been no locusts like them before, nor will there be such ever again. ");
INSERT INTO engnet_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the surface of all the ground, so that the ground became dark with them, and they ate all the vegetation of the ground and all the fruit of the trees that the hail had left. Nothing green remained on the trees or on anything that grew in the fields throughout the whole land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Then Pharaoh quickly summoned Moses and Aaron and said, “I have sinned against the Lord your God and against you! ");
INSERT INTO engnet_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","So now, forgive my sin this time only, and pray to the Lord your God that he would only take this death away from me.” ");
INSERT INTO engnet_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses went out from Pharaoh and prayed to the Lord, ");
INSERT INTO engnet_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","and the Lord turned a very strong west wind, and it picked up the locusts and blew them into the Red Sea. Not one locust remained in all the territory of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the Lord hardened Pharaoh’s heart, and he did not release the Israelites. ");
INSERT INTO engnet_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","The Lord said to Moses, “Extend your hand toward heaven so that there may be darkness over the land of Egypt, a darkness so thick it can be felt.” ");
INSERT INTO engnet_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","So Moses extended his hand toward heaven, and there was absolute darkness throughout the land of Egypt for three days. ");
INSERT INTO engnet_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","No one could see another person, and no one could rise from his place for three days. But the Israelites had light in the places where they lived. ");
INSERT INTO engnet_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Then Pharaoh summoned Moses and said, “Go, serve the Lord – only your flocks and herds will be detained. Even your families may go with you.” ");
INSERT INTO engnet_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses said, “Will you also provide us with sacrifices and burnt offerings that we may present them to the Lord our God? ");
INSERT INTO engnet_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our livestock must also go with us! Not a hoof is to be left behind! For we must take these animals to serve the Lord our God. Until we arrive there, we do not know what we must use to serve the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the Lord hardened Pharaoh’s heart, and he was not willing to release them. ");
INSERT INTO engnet_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh said to him, “Go from me! Watch out for yourself! Do not appear before me again, for when you see my face you will die!” ");
INSERT INTO engnet_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses said, “As you wish! I will not see your face again.” ");
INSERT INTO engnet_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","The Lord said to Moses, “I will bring one more plague on Pharaoh and on Egypt; after that he will release you from this place. When he releases you, he will drive you out completely from this place. ");
INSERT INTO engnet_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Instruct the people that each man and each woman is to request from his or her neighbor items of silver and gold.” ");
INSERT INTO engnet_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Now the Lord granted the people favor with the Egyptians. Moreover, the man Moses was very great in the land of Egypt, respected by Pharaoh’s servants and by the Egyptian people.) ");
INSERT INTO engnet_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses said, “Thus says the Lord: ‘About midnight I will go throughout Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and all the firstborn in the land of Egypt will die, from the firstborn son of Pharaoh who sits on his throne, to the firstborn son of the slave girl who is at her hand mill, and all the firstborn of the cattle. ");
INSERT INTO engnet_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","There will be a great cry throughout the whole land of Egypt, such as there has never been, nor ever will be again. ");
INSERT INTO engnet_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But against any of the Israelites not even a dog will bark against either people or animals, so that you may know that the Lord distinguishes between Egypt and Israel.’ ");
INSERT INTO engnet_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","All these your servants will come down to me and bow down to me, saying, ‘Go, you and all the people who follow you,’ and after that I will go out.” Then Moses went out from Pharaoh in great anger. ");
INSERT INTO engnet_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","The Lord said to Moses, “Pharaoh will not listen to you, so that my wonders may be multiplied in the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","So Moses and Aaron did all these wonders before Pharaoh, but the Lord hardened Pharaoh’s heart, and he did not release the Israelites from his land. ");
INSERT INTO engnet_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","The Lord said to Moses and Aaron in the land of Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“This month is to be your beginning of months; it will be your first month of the year. ");
INSERT INTO engnet_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tell the whole community of Israel, ‘In the tenth day of this month they each must take a lamb for themselves according to their families – a lamb for each household. ");
INSERT INTO engnet_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","If any household is too small for a lamb, the man and his next-door neighbor are to take a lamb according to the number of people – you will make your count for the lamb according to how much each one can eat. ");
INSERT INTO engnet_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your lamb must be perfect, a male, one year old; you may take it from the sheep or from the goats. ");
INSERT INTO engnet_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You must care for it until the fourteenth day of this month, and then the whole community of Israel will kill it around sundown. ");
INSERT INTO engnet_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","They will take some of the blood and put it on the two side posts and top of the doorframe of the houses where they will eat it. ");
INSERT INTO engnet_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","They will eat the meat the same night; they will eat it roasted over the fire with bread made without yeast and with bitter herbs. ");
INSERT INTO engnet_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Do not eat it raw or boiled in water, but roast it over the fire with its head, its legs, and its entrails. ");
INSERT INTO engnet_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","You must leave nothing until morning, but you must burn with fire whatever remains of it until morning. ");
INSERT INTO engnet_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","This is how you are to eat it – dressed to travel, your sandals on your feet, and your staff in your hand. You are to eat it in haste. It is the Lord’s Passover. ");
INSERT INTO engnet_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","I will pass through the land of Egypt in the same night, and I will attack all the firstborn in the land of Egypt, both of humans and of animals, and on all the gods of Egypt I will execute judgment. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood will be a sign for you on the houses where you are, so that when I see the blood I will pass over you, and this plague will not fall on you to destroy you when I attack the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","This day will become a memorial for you, and you will celebrate it as a festival to the Lord – you will celebrate it perpetually as a lasting ordinance. ");
INSERT INTO engnet_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For seven days you must eat bread made without yeast. Surely on the first day you must put away yeast from your houses because anyone who eats bread made with yeast from the first day to the seventh day will be cut off from Israel. ");
INSERT INTO engnet_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","On the first day there will be a holy convocation, and on the seventh day there will be a holy convocation for you. You must do no work of any kind on them, only what every person will eat – that alone may be prepared for you. ");
INSERT INTO engnet_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","So you will keep the Feast of Unleavened Bread, because on this very day I brought your regiments out from the land of Egypt, and so you must keep this day perpetually as a lasting ordinance. ");
INSERT INTO engnet_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month, from the fourteenth day of the month, in the evening, you will eat bread made without yeast until the twenty-first day of the month in the evening. ");
INSERT INTO engnet_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","For seven days yeast must not be found in your houses, for whoever eats what is made with yeast – that person will be cut off from the community of Israel, whether a foreigner or one born in the land. ");
INSERT INTO engnet_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You will not eat anything made with yeast; in all the places where you live you must eat bread made without yeast.’” ");
INSERT INTO engnet_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses summoned all the elders of Israel, and told them, “Go and select for yourselves a lamb or young goat for your families, and kill the Passover animals. ");
INSERT INTO engnet_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Take a branch of hyssop, dip it in the blood that is in the basin, and apply to the top of the doorframe and the two side posts some of the blood that is in the basin. Not one of you is to go out the door of his house until morning. ");
INSERT INTO engnet_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","For the Lord will pass through to strike Egypt, and when he sees the blood on the top of the doorframe and the two side posts, then the Lord will pass over the door, and he will not permit the destroyer to enter your houses to strike you. ");
INSERT INTO engnet_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You must observe this event as an ordinance for you and for your children forever. ");
INSERT INTO engnet_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","When you enter the land that the Lord will give to you, just as he said, you must observe this ceremony. ");
INSERT INTO engnet_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children ask you, ‘What does this ceremony mean to you?’ – ");
INSERT INTO engnet_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","then you will say, ‘It is the sacrifice of the Lord’s Passover, when he passed over the houses of the Israelites in Egypt, when he struck Egypt and delivered our households.’” The people bowed down low to the ground, ");
INSERT INTO engnet_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","and the Israelites went away and did exactly as the Lord had commanded Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","It happened at midnight – the Lord attacked all the firstborn in the land of Egypt, from the firstborn of Pharaoh who sat on his throne to the firstborn of the captive who was in the prison, and all the firstborn of the cattle. ");
INSERT INTO engnet_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaoh got up in the night, along with all his servants and all Egypt, and there was a great cry in Egypt, for there was no house in which there was not someone dead. ");
INSERT INTO engnet_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pharaoh summoned Moses and Aaron in the night and said, “Get up, get out from among my people, both you and the Israelites! Go, serve the Lord as you have requested! ");
INSERT INTO engnet_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Also, take your flocks and your herds, just as you have requested, and leave. But bless me also.” ");
INSERT INTO engnet_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","The Egyptians were urging the people on, in order to send them out of the land quickly, for they were saying, “We are all dead!” ");
INSERT INTO engnet_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","So the people took their dough before the yeast was added, with their kneading troughs bound up in their clothing on their shoulders. ");
INSERT INTO engnet_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Now the Israelites had done as Moses told them – they had requested from the Egyptians silver and gold items and clothing. ");
INSERT INTO engnet_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","The Lord gave the people favor in the sight of the Egyptians, and they gave them whatever they wanted, and so they plundered Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israelites journeyed from Rameses to Sukkoth. There were about 600,000 men on foot, plus their dependants. ");
INSERT INTO engnet_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","A mixed multitude also went up with them, and flocks and herds – a very large number of cattle. ");
INSERT INTO engnet_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","They baked cakes of bread without yeast using the dough they had brought from Egypt, for it was made without yeast – because they were thrust out of Egypt and were not able to delay, they could not prepare food for themselves either. ");
INSERT INTO engnet_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Now the length of time the Israelites lived in Egypt was 430 years. ");
INSERT INTO engnet_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","At the end of the 430 years, on the very day, all the regiments of the Lord went out of the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","It was a night of vigil for the Lord to bring them out from the land of Egypt, and so on this night all Israel is to keep the vigil to the Lord for generations to come. ");
INSERT INTO engnet_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","The Lord said to Moses and Aaron, “This is the ordinance of the Passover. No foreigner may share in eating it. ");
INSERT INTO engnet_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But everyone’s servant who is bought for money, after you have circumcised him, may eat it. ");
INSERT INTO engnet_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A foreigner and a hired worker must not eat it. ");
INSERT INTO engnet_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","It must be eaten in one house; you must not bring any of the meat outside the house, and you must not break a bone of it. ");
INSERT INTO engnet_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","The whole community of Israel must observe it. ");
INSERT INTO engnet_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“When a foreigner lives with you and wants to observe the Passover to the Lord, all his males must be circumcised, and then he may approach and observe it, and he will be like one who is born in the land – but no uncircumcised person may eat of it. ");
INSERT INTO engnet_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","The same law will apply to the person who is native-born and to the foreigner who lives among you.” ");
INSERT INTO engnet_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","So all the Israelites did exactly as the Lord commanded Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And on this very day the Lord brought the Israelites out of the land of Egypt by their regiments. ");
INSERT INTO engnet_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Set apart to me every firstborn male – the first offspring of every womb among the Israelites, whether human or animal; it is mine.” ");
INSERT INTO engnet_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses said to the people, “Remember this day on which you came out from Egypt, from the place where you were enslaved, for the Lord brought you out of there with a mighty hand – and no bread made with yeast may be eaten. ");
INSERT INTO engnet_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","On this day, in the month of Abib, you are going out. ");
INSERT INTO engnet_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","When the Lord brings you to the land of the Canaanites, Hittites, Amorites, Hivites, and Jebusites, which he swore to your fathers to give you, a land flowing with milk and honey, then you will keep this ceremony in this month. ");
INSERT INTO engnet_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days you must eat bread made without yeast, and on the seventh day there is to be a festival to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Bread made without yeast must be eaten for seven days; no bread made with yeast shall be seen among you, and you must have no yeast among you within any of your borders. ");
INSERT INTO engnet_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","You are to tell your son on that day, ‘It is because of what the Lord did for me when I came out of Egypt.’ ");
INSERT INTO engnet_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","It will be a sign for you on your hand and a memorial on your forehead, so that the law of the Lord may be in your mouth, for with a mighty hand the Lord brought you out of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","So you must keep this ordinance at its appointed time from year to year. ");
INSERT INTO engnet_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","When the Lord brings you into the land of the Canaanites, as he swore to you and to your fathers, and gives it to you, ");
INSERT INTO engnet_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","then you must give over to the Lord the first offspring of every womb. Every firstling of a beast that you have – the males will be the Lord’s. ");
INSERT INTO engnet_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Every firstling of a donkey you must redeem with a lamb, and if you do not redeem it, then you must break its neck. Every firstborn of your sons you must redeem. ");
INSERT INTO engnet_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","In the future, when your son asks you ‘What is this?’ you are to tell him, ‘With a mighty hand the Lord brought us out from Egypt, from the land of slavery. ");
INSERT INTO engnet_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","When Pharaoh stubbornly refused to release us, the Lord killed all the firstborn in the land of Egypt, from the firstborn of people to the firstborn of animals. That is why I am sacrificing to the Lord the first male offspring of every womb, but all my firstborn sons I redeem.’ ");
INSERT INTO engnet_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","It will be for a sign on your hand and for frontlets on your forehead, for with a mighty hand the Lord brought us out of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When Pharaoh released the people, God did not lead them by the way to the land of the Philistines, although that was nearby, for God said, “Lest the people change their minds and return to Egypt when they experience war.” ");
INSERT INTO engnet_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So God brought the people around by the way of the desert to the Red Sea, and the Israelites went up from the land of Egypt prepared for battle. ");
INSERT INTO engnet_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses took the bones of Joseph with him, for Joseph had made the Israelites solemnly swear, “God will surely attend to you, and you will carry my bones up from this place with you.” ");
INSERT INTO engnet_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","They journeyed from Sukkoth and camped in Etham, on the edge of the desert. ");
INSERT INTO engnet_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Now the Lord was going before them by day in a pillar of cloud to lead them in the way, and by night in a pillar of fire to give them light, so that they could travel day or night. ");
INSERT INTO engnet_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","He did not remove the pillar of cloud by day nor the pillar of fire by night from before the people. ");
INSERT INTO engnet_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tell the Israelites that they must turn and camp before Pi-hahiroth, between Migdol and the sea; you are to camp by the sea before Baal Zephon opposite it. ");
INSERT INTO engnet_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh will think regarding the Israelites, ‘They are wandering around confused in the land – the desert has closed in on them.’ ");
INSERT INTO engnet_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I will harden Pharaoh’s heart, and he will chase after them. I will gain honor because of Pharaoh and because of all his army, and the Egyptians will know that I am the Lord.” So this is what they did. ");
INSERT INTO engnet_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","When it was reported to the king of Egypt that the people had fled, the heart of Pharaoh and his servants was turned against the people, and the king and his servants said, “What in the world have we done? For we have released the people of Israel from serving us!” ");
INSERT INTO engnet_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Then he prepared his chariots and took his army with him. ");
INSERT INTO engnet_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took six hundred select chariots, and all the rest of the chariots of Egypt, and officers on all of them. ");
INSERT INTO engnet_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","But the Lord hardened the heart of Pharaoh king of Egypt, and he chased after the Israelites. Now the Israelites were going out defiantly. ");
INSERT INTO engnet_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","The Egyptians chased after them, and all the horses and chariots of Pharaoh and his horsemen and his army overtook them camping by the sea, beside Pi-hahiroth, before Baal-Zephon. ");
INSERT INTO engnet_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","When Pharaoh got closer, the Israelites looked up, and there were the Egyptians marching after them, and they were terrified. The Israelites cried out to the Lord, ");
INSERT INTO engnet_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","and they said to Moses, “Is it because there are no graves in Egypt that you have taken us away to die in the desert? What in the world have you done to us by bringing us out of Egypt? ");
INSERT INTO engnet_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Isn’t this what we told you in Egypt, ‘Leave us alone so that we can serve the Egyptians, because it is better for us to serve the Egyptians than to die in the desert!’” ");
INSERT INTO engnet_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses said to the people, “Do not fear! Stand firm and see the salvation of the Lord that he will provide for you today; for the Egyptians that you see today you will never, ever see again. ");
INSERT INTO engnet_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The Lord will fight for you, and you can be still.” ");
INSERT INTO engnet_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","The Lord said to Moses, “Why do you cry out to me? Tell the Israelites to move on. ");
INSERT INTO engnet_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","And as for you, lift up your staff and extend your hand toward the sea and divide it, so that the Israelites may go through the middle of the sea on dry ground. ");
INSERT INTO engnet_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","And as for me, I am going to harden the hearts of the Egyptians so that they will come after them, that I may be honored because of Pharaoh and his army and his chariots and his horsemen. ");
INSERT INTO engnet_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","And the Egyptians will know that I am the Lord when I have gained my honor because of Pharaoh, his chariots, and his horsemen.” ");
INSERT INTO engnet_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","The angel of God, who was going before the camp of Israel, moved and went behind them, and the pillar of cloud moved from before them and stood behind them. ");
INSERT INTO engnet_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","It came between the Egyptian camp and the Israelite camp; it was a dark cloud and it lit up the night so that one camp did not come near the other the whole night. ");
INSERT INTO engnet_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses stretched out his hand toward the sea, and the Lord drove the sea apart by a strong east wind all that night, and he made the sea into dry land, and the water was divided. ");
INSERT INTO engnet_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","So the Israelites went through the middle of the sea on dry ground, the water forming a wall for them on their right and on their left. ");
INSERT INTO engnet_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","The Egyptians chased them and followed them into the middle of the sea – all the horses of Pharaoh, his chariots, and his horsemen. ");
INSERT INTO engnet_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","In the morning watch the Lord looked down on the Egyptian army through the pillar of fire and cloud, and he threw the Egyptian army into a panic. ");
INSERT INTO engnet_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","He jammed the wheels of their chariots so that they had difficulty driving, and the Egyptians said, “Let’s flee from Israel, for the Lord fights for them against Egypt!” ");
INSERT INTO engnet_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","The Lord said to Moses, “Extend your hand toward the sea, so that the waters may flow back on the Egyptians, on their chariots, and on their horsemen!” ");
INSERT INTO engnet_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So Moses extended his hand toward the sea, and the sea returned to its normal state when the sun began to rise. Now the Egyptians were fleeing before it, but the Lord overthrew the Egyptians in the middle of the sea. ");
INSERT INTO engnet_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The water returned and covered the chariots and the horsemen and all the army of Pharaoh that was coming after the Israelites into the sea – not so much as one of them survived! ");
INSERT INTO engnet_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the Israelites walked on dry ground in the middle of the sea, the water forming a wall for them on their right and on their left. ");
INSERT INTO engnet_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So the Lord saved Israel on that day from the power of the Egyptians, and Israel saw the Egyptians dead on the shore of the sea. ");
INSERT INTO engnet_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","When Israel saw the great power that the Lord had exercised over the Egyptians, they feared the Lord, and they believed in the Lord and in his servant Moses. ");
INSERT INTO engnet_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the Israelites sang this song to the Lord. They said, “I will sing to the Lord, for he has triumphed gloriously, the horse and its rider he has thrown into the sea. ");
INSERT INTO engnet_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The Lord is my strength and my song, and he has become my salvation. This is my God, and I will praise him, my father’s God, and I will exalt him. ");
INSERT INTO engnet_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The Lord is a warrior, the Lord is his name. ");
INSERT INTO engnet_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","The chariots of Pharaoh and his army he has thrown into the sea, and his chosen officers were drowned in the Red Sea. ");
INSERT INTO engnet_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The depths have covered them, they went down to the bottom like a stone. ");
INSERT INTO engnet_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Your right hand, O Lord, was majestic in power, your right hand, O Lord, shattered the enemy. ");
INSERT INTO engnet_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In the abundance of your majesty you have overthrown those who rise up against you. You sent forth your wrath; it consumed them like stubble. ");
INSERT INTO engnet_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","By the blast of your nostrils the waters were piled up, the flowing water stood upright like a heap, and the deep waters were solidified in the heart of the sea. ");
INSERT INTO engnet_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy said, ‘I will chase, I will overtake, I will divide the spoil; my desire will be satisfied on them. I will draw my sword, my hand will destroy them.’ ");
INSERT INTO engnet_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But you blew with your breath, and the sea covered them. They sank like lead in the mighty waters. ");
INSERT INTO engnet_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like you, O Lord, among the gods? Who is like you? – majestic in holiness, fearful in praises, working wonders? ");
INSERT INTO engnet_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You stretched out your right hand, the earth swallowed them. ");
INSERT INTO engnet_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","By your loyal love you will lead the people whom you have redeemed; you will guide them by your strength to your holy dwelling place. ");
INSERT INTO engnet_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The nations will hear and tremble; anguish will seize the inhabitants of Philistia. ");
INSERT INTO engnet_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then the chiefs of Edom will be terrified, trembling will seize the leaders of Moab, and the inhabitants of Canaan will shake. ");
INSERT INTO engnet_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Fear and dread will fall on them; by the greatness of your arm they will be as still as stone until your people pass by, O Lord, until the people whom you have bought pass by. ");
INSERT INTO engnet_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will bring them in and plant them in the mountain of your inheritance, in the place you made for your residence, O Lord, the sanctuary, O Lord, that your hands have established. ");
INSERT INTO engnet_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The Lord will reign forever and ever! ");
INSERT INTO engnet_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For the horses of Pharaoh came with his chariots and his footmen into the sea, and the Lord brought back the waters of the sea on them, but the Israelites walked on dry land in the middle of the sea.” ");
INSERT INTO engnet_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam the prophetess, the sister of Aaron, took a hand-drum in her hand, and all the women went out after her with hand-drums and with dances. ");
INSERT INTO engnet_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam sang in response to them, “Sing to the Lord, for he has triumphed gloriously; the horse and its rider he has thrown into the sea.” ");
INSERT INTO engnet_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses led Israel to journey away from the Red Sea. They went out to the Desert of Shur, walked for three days into the desert, and found no water. ");
INSERT INTO engnet_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Then they came to Marah, but they were not able to drink the waters of Marah, because they were bitter. (That is why its name was Marah.) ");
INSERT INTO engnet_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","So the people murmured against Moses, saying, “What can we drink?” ");
INSERT INTO engnet_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","He cried out to the Lord, and the Lord showed him a tree. When Moses threw it into the water, the water became safe to drink. There the Lord made for them a binding ordinance, and there he tested them. ");
INSERT INTO engnet_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","He said, “If you will diligently obey the Lord your God, and do what is right in his sight, and pay attention to his commandments, and keep all his statutes, then all the diseases that I brought on the Egyptians I will not bring on you, for I, the Lord, am your healer.” ");
INSERT INTO engnet_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Then they came to Elim, where there were twelve wells of water and seventy palm trees, and they camped there by the water. ");
INSERT INTO engnet_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","When they journeyed from Elim, the entire company of Israelites came to the Desert of Sin, which is between Elim and Sinai, on the fifteenth day of the second month after their exodus from the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","The entire company of Israelites murmured against Moses and Aaron in the desert. ");
INSERT INTO engnet_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","The Israelites said to them, “If only we had died by the hand of the Lord in the land of Egypt, when we sat by the pots of meat, when we ate bread to the full, for you have brought us out into this desert to kill this whole assembly with hunger!” ");
INSERT INTO engnet_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then the Lord said to Moses, “I am going to rain bread from heaven for you, and the people will go out and gather the amount for each day, so that I may test them. Will they walk in my law or not? ");
INSERT INTO engnet_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","On the sixth day they will prepare what they bring in, and it will be twice as much as they gather every other day.” ");
INSERT INTO engnet_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moses and Aaron said to all the Israelites, “In the evening you will know that the Lord has brought you out of the land of Egypt, ");
INSERT INTO engnet_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","and in the morning you will see the glory of the Lord, because he has heard your murmurings against the Lord. As for us, what are we, that you should murmur against us?” ");
INSERT INTO engnet_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moses said, “You will know this when the Lord gives you meat to eat in the evening and bread in the morning to satisfy you, because the Lord has heard your murmurings that you are murmuring against him. As for us, what are we? Your murmurings are not against us, but against the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Then Moses said to Aaron, “Tell the whole community of the Israelites, ‘Come before the Lord, because he has heard your murmurings.’” ");
INSERT INTO engnet_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","As Aaron spoke to the whole community of the Israelites and they looked toward the desert, there the glory of the Lord appeared in the cloud, ");
INSERT INTO engnet_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","and the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the murmurings of the Israelites. Tell them, ‘During the evening you will eat meat, and in the morning you will be satisfied with bread, so that you may know that I am the Lord your God.’” ");
INSERT INTO engnet_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","In the evening the quail came up and covered the camp, and in the morning a layer of dew was all around the camp. ");
INSERT INTO engnet_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","When the layer of dew had evaporated, there on the surface of the desert was a thin flaky substance, thin like frost on the earth. ");
INSERT INTO engnet_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the Israelites saw it, they said to one another, “What is it?” because they did not know what it was. Moses said to them, “It is the bread that the Lord has given you for food. ");
INSERT INTO engnet_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","“This is what the Lord has commanded: ‘Each person is to gather from it what he can eat, an omer per person according to the number of your people; each one will pick it up for whoever lives in his tent.’” ");
INSERT INTO engnet_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","The Israelites did so, and they gathered – some more, some less. ");
INSERT INTO engnet_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","When they measured with an omer, the one who gathered much had nothing left over, and the one who gathered little lacked nothing; each one had gathered what he could eat. ");
INSERT INTO engnet_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses said to them, “No one is to keep any of it until morning.” ");
INSERT INTO engnet_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But they did not listen to Moses; some kept part of it until morning, and it was full of worms and began to stink, and Moses was angry with them. ");
INSERT INTO engnet_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","So they gathered it each morning, each person according to what he could eat, and when the sun got hot, it would melt. ");
INSERT INTO engnet_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","And on the sixth day they gathered twice as much food, two omers per person; and all the leaders of the community came and told Moses. ");
INSERT INTO engnet_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","He said to them, “This is what the Lord has said: ‘Tomorrow is a time of cessation from work, a holy Sabbath to the Lord. Whatever you want to bake, bake today; whatever you want to boil, boil today; whatever is left put aside for yourselves to be kept until morning.’” ");
INSERT INTO engnet_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So they put it aside until the morning, just as Moses had commanded, and it did not stink, nor were there any worms in it. ");
INSERT INTO engnet_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses said, “Eat it today, for today is a Sabbath to the Lord; today you will not find it in the area. ");
INSERT INTO engnet_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Six days you will gather it, but on the seventh day, the Sabbath, there will not be any.” ");
INSERT INTO engnet_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","On the seventh day some of the people went out to gather it, but they found nothing. ");
INSERT INTO engnet_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","So the Lord said to Moses, “How long do you refuse to obey my commandments and my instructions? ");
INSERT INTO engnet_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","See, because the Lord has given you the Sabbath, that is why he is giving you food for two days on the sixth day. Each of you stay where you are; let no one go out of his place on the seventh day.” ");
INSERT INTO engnet_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the seventh day. ");
INSERT INTO engnet_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The house of Israel called its name “manna.” It was like coriander seed and was white, and it tasted like wafers with honey. ");
INSERT INTO engnet_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses said, “This is what the Lord has commanded: ‘Fill an omer with it to be kept for generations to come, so that they may see the food I fed you in the desert when I brought you out from the land of Egypt.’” ");
INSERT INTO engnet_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses said to Aaron, “Take a jar and put in it an omer full of manna, and place it before the Lord to be kept for generations to come.” ");
INSERT INTO engnet_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Just as the Lord commanded Moses, so Aaron placed it before the Testimony for safekeeping. ");
INSERT INTO engnet_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Now the Israelites ate manna forty years, until they came to a land that was inhabited; they ate manna until they came to the border of the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Now an omer is one tenth of an ephah.) ");
INSERT INTO engnet_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","The whole community of the Israelites traveled on their journey from the Desert of Sin according to the Lord’s instruction, and they pitched camp in Rephidim. Now there was no water for the people to drink. ");
INSERT INTO engnet_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So the people contended with Moses, and they said, “Give us water to drink!” Moses said to them, “Why do you contend with me? Why do you test the Lord?” ");
INSERT INTO engnet_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people were very thirsty there for water, and they murmured against Moses and said, “Why in the world did you bring us up out of Egypt – to kill us and our children and our cattle with thirst?” ");
INSERT INTO engnet_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Then Moses cried out to the Lord, “What will I do with this people? – a little more and they will stone me!” ");
INSERT INTO engnet_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","The Lord said to Moses, “Go over before the people; take with you some of the elders of Israel and take in your hand your staff with which you struck the Nile and go. ");
INSERT INTO engnet_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","I will be standing before you there on the rock in Horeb, and you will strike the rock, and water will come out of it so that the people may drink.” And Moses did so in plain view of the elders of Israel. ");
INSERT INTO engnet_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","He called the name of the place Massah and Meribah, because of the contending of the Israelites and because of their testing the Lord, saying, “Is the Lord among us or not?” ");
INSERT INTO engnet_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek came and attacked Israel in Rephidim. ");
INSERT INTO engnet_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","So Moses said to Joshua, “Choose some of our men and go out, fight against Amalek. Tomorrow I will stand on top of the hill with the staff of God in my hand.” ");
INSERT INTO engnet_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","So Joshua fought against Amalek just as Moses had instructed him; and Moses and Aaron and Hur went up to the top of the hill. ");
INSERT INTO engnet_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Whenever Moses would raise his hands, then Israel prevailed, but whenever he would rest his hands, then Amalek prevailed. ");
INSERT INTO engnet_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","When the hands of Moses became heavy, they took a stone and put it under him, and Aaron and Hur held up his hands, one on one side and one on the other, and so his hands were steady until the sun went down. ");
INSERT INTO engnet_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","So Joshua destroyed Amalek and his army with the sword. ");
INSERT INTO engnet_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","The Lord said to Moses, “Write this as a memorial in the book, and rehearse it in Joshua’s hearing; for I will surely wipe out the remembrance of Amalek from under heaven. ");
INSERT INTO engnet_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moses built an altar, and he called it “The Lord is my Banner,” ");
INSERT INTO engnet_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","for he said, “For a hand was lifted up to the throne of the Lord – that the Lord will have war with Amalek from generation to generation.” ");
INSERT INTO engnet_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethro, the priest of Midian, Moses’ father-in-law, heard about all that God had done for Moses and for his people Israel, that the Lord had brought Israel out of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jethro, Moses’ father-in-law, took Moses’ wife Zipporah after he had sent her back, ");
INSERT INTO engnet_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","and her two sons, one of whom was named Gershom (for Moses had said, “I have been a foreigner in a foreign land”), ");
INSERT INTO engnet_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","and the other Eliezer (for Moses had said, “The God of my father has been my help and delivered me from the sword of Pharaoh”). ");
INSERT INTO engnet_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethro, Moses’ father-in-law, together with Moses’ sons and his wife, came to Moses in the desert where he was camping by the mountain of God. ");
INSERT INTO engnet_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","He said to Moses, “I, your father-in-law Jethro, am coming to you, along with your wife and her two sons with her.” ");
INSERT INTO engnet_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses went out to meet his father-in-law and bowed down and kissed him; they each asked about the other’s welfare, and then they went into the tent. ");
INSERT INTO engnet_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses told his father-in-law all that the Lord had done to Pharaoh and to Egypt for Israel’s sake, and all the hardship that had come on them along the way, and how the Lord had delivered them. ");
INSERT INTO engnet_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro rejoiced because of all the good that the Lord had done for Israel, whom he had delivered from the hand of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro said, “Blessed be the Lord who has delivered you from the hand of Egypt, and from the hand of Pharaoh, who has delivered the people from the Egyptians’ control! ");
INSERT INTO engnet_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I know that the Lord is greater than all the gods, for in the thing in which they dealt proudly against them he has destroyed them.” ");
INSERT INTO engnet_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Then Jethro, Moses’ father-in-law, brought a burnt offering and sacrifices for God, and Aaron and all the elders of Israel came to eat food with the father-in-law of Moses before God. ");
INSERT INTO engnet_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","On the next day Moses sat to judge the people, and the people stood around Moses from morning until evening. ");
INSERT INTO engnet_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When Moses’ father-in-law saw all that he was doing for the people, he said, “What is this that you are doing for the people? Why are you sitting by yourself, and all the people stand around you from morning until evening?” ");
INSERT INTO engnet_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moses said to his father-in-law, “Because the people come to me to inquire of God. ");
INSERT INTO engnet_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","When they have a dispute, it comes to me and I decide between a man and his neighbor, and I make known the decrees of God and his laws.” ");
INSERT INTO engnet_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moses’ father-in-law said to him, “What you are doing is not good! ");
INSERT INTO engnet_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","You will surely wear out, both you and these people who are with you, for this is too heavy a burden for you; you are not able to do it by yourself. ");
INSERT INTO engnet_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Now listen to me, I will give you advice, and may God be with you: You be a representative for the people to God, and you bring their disputes to God; ");
INSERT INTO engnet_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","warn them of the statutes and the laws, and make known to them the way in which they must walk and the work they must do. ");
INSERT INTO engnet_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","But you choose from the people capable men, God-fearing, men of truth, those who hate bribes, and put them over the people as rulers of thousands, rulers of hundreds, rulers of fifties, and rulers of tens. ");
INSERT INTO engnet_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","They will judge the people under normal circumstances, and every difficult case they will bring to you, but every small case they themselves will judge, so that you may make it easier for yourself, and they will bear the burden with you. ");
INSERT INTO engnet_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you do this thing, and God so commands you, then you will be able to endure, and all these people will be able to go home satisfied.” ");
INSERT INTO engnet_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses listened to his father-in-law and did everything he had said. ");
INSERT INTO engnet_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses chose capable men from all Israel, and he made them heads over the people, rulers of thousands, rulers of hundreds, rulers of fifties, and rulers of tens. ");
INSERT INTO engnet_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","They judged the people under normal circumstances; the difficult cases they would bring to Moses, but every small case they would judge themselves. ");
INSERT INTO engnet_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Then Moses sent his father-in-law on his way, and so Jethro went to his own land. ");
INSERT INTO engnet_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month after the Israelites went out from the land of Egypt, on the very day, they came to the Desert of Sinai. ");
INSERT INTO engnet_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","After they journeyed from Rephidim, they came to the Desert of Sinai, and they camped in the desert; Israel camped there in front of the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses went up to God, and the Lord called to him from the mountain, “Thus you will tell the house of Jacob, and declare to the people of Israel: ");
INSERT INTO engnet_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You yourselves have seen what I did to Egypt and how I lifted you on eagles’ wings and brought you to myself. ");
INSERT INTO engnet_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","And now, if you will diligently listen to me and keep my covenant, then you will be my special possession out of all the nations, for all the earth is mine, ");
INSERT INTO engnet_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","and you will be to me a kingdom of priests and a holy nation.’ These are the words that you will speak to the Israelites.” ");
INSERT INTO engnet_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses came and summoned the elders of Israel. He set before them all these words that the Lord had commanded him, ");
INSERT INTO engnet_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","and all the people answered together, “All that the Lord has commanded we will do!” So Moses brought the words of the people back to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","The Lord said to Moses, “I am going to come to you in a dense cloud, so that the people may hear when I speak with you and so that they will always believe in you.” And Moses told the words of the people to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","The Lord said to Moses, “Go to the people and sanctify them today and tomorrow, and make them wash their clothes ");
INSERT INTO engnet_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and be ready for the third day, for on the third day the Lord will come down on Mount Sinai in the sight of all the people. ");
INSERT INTO engnet_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","You must set boundaries for the people all around, saying, ‘Take heed to yourselves not to go up on the mountain nor touch its edge. Whoever touches the mountain will surely be put to death! ");
INSERT INTO engnet_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No hand will touch him – but he will surely be stoned or shot through, whether a beast or a human being; he must not live.’ When the ram’s horn sounds a long blast they may go up on the mountain.” ");
INSERT INTO engnet_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Then Moses went down from the mountain to the people and sanctified the people, and they washed their clothes. ");
INSERT INTO engnet_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","He said to the people, “Be ready for the third day. Do not go near your wives.” ");
INSERT INTO engnet_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","On the third day in the morning there was thunder and lightning and a dense cloud on the mountain, and the sound of a very loud horn; all the people who were in the camp trembled. ");
INSERT INTO engnet_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses brought the people out of the camp to meet God, and they took their place at the foot of the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Now Mount Sinai was completely covered with smoke because the Lord had descended on it in fire, and its smoke went up like the smoke of a great furnace, and the whole mountain shook violently. ");
INSERT INTO engnet_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","When the sound of the horn grew louder and louder, Moses was speaking and God was answering him with a voice. ");
INSERT INTO engnet_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","The Lord came down on Mount Sinai, on the top of the mountain, and the Lord summoned Moses to the top of the mountain, and Moses went up. ");
INSERT INTO engnet_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","The Lord said to Moses, “Go down and solemnly warn the people, lest they force their way through to the Lord to look, and many of them perish. ");
INSERT INTO engnet_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Let the priests also, who approach the Lord, sanctify themselves, lest the Lord break through against them.” ");
INSERT INTO engnet_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses said to the Lord, “The people are not able to come up to Mount Sinai, because you solemnly warned us, ‘Set boundaries for the mountain and set it apart.’” ");
INSERT INTO engnet_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","The Lord said to him, “Go, get down, and come up, and Aaron with you, but do not let the priests and the people force their way through to come up to the Lord, lest he break through against them.” ");
INSERT INTO engnet_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people and spoke to them. ");
INSERT INTO engnet_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God spoke all these words: ");
INSERT INTO engnet_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I, the Lord, am your God, who brought you from the land of Egypt, from the house of slavery. ");
INSERT INTO engnet_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“You shall have no other gods before me. ");
INSERT INTO engnet_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“You shall not make for yourself a carved image or any likeness of anything that is in heaven above or that is on the earth beneath or that is in the water below. ");
INSERT INTO engnet_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You shall not bow down to them or serve them, for I, the Lord, your God, am a jealous God, responding to the transgression of fathers by dealing with children to the third and fourth generations of those who reject me, ");
INSERT INTO engnet_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","and showing covenant faithfulness to a thousand generations of those who love me and keep my commandments. ");
INSERT INTO engnet_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“You shall not take the name of the Lord your God in vain, for the Lord will not hold guiltless anyone who takes his name in vain. ");
INSERT INTO engnet_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Remember the Sabbath day to set it apart as holy. ");
INSERT INTO engnet_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","For six days you may labor and do all your work, ");
INSERT INTO engnet_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is a Sabbath to the Lord your God; on it you shall not do any work, you, or your son, or your daughter, or your male servant, or your female servant, or your cattle, or the resident foreigner who is in your gates. ");
INSERT INTO engnet_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in six days the Lord made the heavens and the earth and the sea and all that is in them, and he rested on the seventh day; therefore the Lord blessed the Sabbath day and set it apart as holy. ");
INSERT INTO engnet_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Honor your father and your mother, that you may live a long time in the land the Lord your God is giving to you. ");
INSERT INTO engnet_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“You shall not murder. ");
INSERT INTO engnet_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“You shall not commit adultery. ");
INSERT INTO engnet_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“You shall not steal. ");
INSERT INTO engnet_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“You shall not give false testimony against your neighbor. ");
INSERT INTO engnet_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“You shall not covet your neighbor’s house. You shall not covet your neighbor’s wife, nor his male servant, nor his female servant, nor his ox, nor his donkey, nor anything that belongs to your neighbor.” ");
INSERT INTO engnet_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","All the people were seeing the thundering and the lightning, and heard the sound of the horn, and saw the mountain smoking – and when the people saw it they trembled with fear and kept their distance. ");
INSERT INTO engnet_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","They said to Moses, “You speak to us and we will listen, but do not let God speak with us, lest we die.” ");
INSERT INTO engnet_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses said to the people, “Do not fear, for God has come to test you, that the fear of him may be before you so that you do not sin.” ");
INSERT INTO engnet_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","The people kept their distance, but Moses drew near the thick darkness where God was. ");
INSERT INTO engnet_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","The Lord said to Moses: “Thus you will tell the Israelites: ‘You yourselves have seen that I have spoken with you from heaven. ");
INSERT INTO engnet_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","You must not make gods of silver alongside me, nor make gods of gold for yourselves. ");
INSERT INTO engnet_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","‘You must make for me an altar made of earth, and you will sacrifice on it your burnt offerings and your peace offerings, your sheep and your cattle. In every place where I cause my name to be honored I will come to you and I will bless you. ");
INSERT INTO engnet_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","If you make me an altar of stone, you must not build it of stones shaped with tools, for if you use your tool on it you have defiled it. ");
INSERT INTO engnet_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","And you must not go up by steps to my altar, so that your nakedness is not exposed.’ ");
INSERT INTO engnet_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“These are the decisions that you will set before them: ");
INSERT INTO engnet_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“If you buy a Hebrew servant, he is to serve you for six years, but in the seventh year he will go out free without paying anything. ");
INSERT INTO engnet_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he came in by himself he will go out by himself; if he had a wife when he came in, then his wife will go out with him. ");
INSERT INTO engnet_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master gave him a wife, and she bore sons or daughters, the wife and the children will belong to her master, and he will go out by himself. ");
INSERT INTO engnet_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant should declare, ‘I love my master, my wife, and my children; I will not go out free,’ ");
INSERT INTO engnet_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master must bring him to the judges, and he will bring him to the door or the doorposts, and his master will pierce his ear with an awl, and he shall serve him forever. ");
INSERT INTO engnet_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“If a man sells his daughter as a female servant, she will not go out as the male servants do. ");
INSERT INTO engnet_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she does not please her master, who has designated her for himself, then he must let her be redeemed. He has no right to sell her to a foreign nation, because he has dealt deceitfully with her. ");
INSERT INTO engnet_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If he designated her for his son, then he will deal with her according to the customary rights of daughters. ");
INSERT INTO engnet_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he takes another wife, he must not diminish the first one’s food, her clothing, or her marital rights. ");
INSERT INTO engnet_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","If he does not provide her with these three things, then she will go out free, without paying money. ");
INSERT INTO engnet_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Whoever strikes someone so that he dies must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","But if he does not do it with premeditation, but it happens by accident, then I will appoint for you a place where he may flee. ");
INSERT INTO engnet_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if a man willfully attacks his neighbor to kill him cunningly, you will take him even from my altar that he may die. ");
INSERT INTO engnet_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Whoever strikes his father or his mother must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Whoever kidnaps someone and sells him, or is caught still holding him, must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Whoever treats his father or his mother disgracefully must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“If men fight, and one strikes his neighbor with a stone or with his fist and he does not die, but must remain in bed, ");
INSERT INTO engnet_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","and then if he gets up and walks about outside on his staff, then the one who struck him is innocent, except he must pay for the injured person’s loss of time and see to it that he is fully healed. ");
INSERT INTO engnet_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“If a man strikes his male servant or his female servant with a staff so that he or she dies as a result of the blow, he will surely be punished. ");
INSERT INTO engnet_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","However, if the injured servant survives one or two days, the owner will not be punished, for he has suffered the loss. ");
INSERT INTO engnet_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“If men fight and hit a pregnant woman and her child is born prematurely, but there is no serious injury, he will surely be punished in accordance with what the woman’s husband demands of him, and he will pay what the court decides. ");
INSERT INTO engnet_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if there is serious injury, then you will give a life for a life, ");
INSERT INTO engnet_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engnet_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burn for burn, wound for wound, bruise for bruise. ");
INSERT INTO engnet_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“If a man strikes the eye of his male servant or his female servant so that he destroys it, he will let the servant go free as compensation for the eye. ");
INSERT INTO engnet_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","If he knocks out the tooth of his male servant or his female servant, he will let the servant go free as compensation for the tooth. ");
INSERT INTO engnet_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“If an ox gores a man or a woman so that either dies, then the ox must surely be stoned and its flesh must not be eaten, but the owner of the ox will be acquitted. ");
INSERT INTO engnet_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox had the habit of goring, and its owner was warned, and he did not take the necessary precautions, and then it killed a man or a woman, the ox must be stoned and the man must be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If a ransom is set for him, then he must pay the redemption for his life according to whatever amount was set for him. ");
INSERT INTO engnet_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the ox gores a son or a daughter, the owner will be dealt with according to this rule. ");
INSERT INTO engnet_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the ox gores a male servant or a female servant, the owner must pay thirty shekels of silver, and the ox must be stoned. ");
INSERT INTO engnet_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“If a man opens a pit or if a man digs a pit and does not cover it, and an ox or a donkey falls into it, ");
INSERT INTO engnet_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit must repay the loss. He must give money to its owner, and the dead animal will become his. ");
INSERT INTO engnet_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","If the ox of one man injures the ox of his neighbor so that it dies, then they will sell the live ox and divide its proceeds, and they will also divide the dead ox. ");
INSERT INTO engnet_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Or if it is known that the ox had the habit of goring, and its owner did not take the necessary precautions, he must surely pay ox for ox, and the dead animal will become his. ");
INSERT INTO engnet_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“If a man steals an ox or a sheep and kills it or sells it, he must pay back five head of cattle for the ox, and four sheep for the one sheep. ");
INSERT INTO engnet_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“If a thief is caught breaking in and is struck so that he dies, there will be no blood guilt for him. ");
INSERT INTO engnet_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","If the sun has risen on him, then there is blood guilt for him. A thief must surely make full restitution; if he has nothing, then he will be sold for his theft. ");
INSERT INTO engnet_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If the stolen item should in fact be found alive in his possession, whether it be an ox or a donkey or a sheep, he must pay back double. ");
INSERT INTO engnet_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“If a man grazes his livestock in a field or a vineyard, and he lets the livestock loose and they graze in the field of another man, he must make restitution from the best of his own field and the best of his own vineyard. ");
INSERT INTO engnet_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“If a fire breaks out and spreads to thorn bushes, so that stacked grain or standing grain or the whole field is consumed, the one who started the fire must surely make restitution. ");
INSERT INTO engnet_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“If a man gives his neighbor money or articles for safekeeping, and it is stolen from the man’s house, if the thief is caught, he must repay double. ");
INSERT INTO engnet_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If the thief is not caught, then the owner of the house will be brought before the judges to see whether he has laid his hand on his neighbor’s goods. ");
INSERT INTO engnet_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","In all cases of illegal possessions, whether for an ox, a donkey, a sheep, a garment, or any kind of lost item, about which someone says ‘This belongs to me,’ the matter of the two of them will come before the judges, and the one whom the judges declare guilty must repay double to his neighbor. ");
INSERT INTO engnet_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","If a man gives his neighbor a donkey or an ox or a sheep or any beast to keep, and it dies or is hurt or is carried away without anyone seeing it, ");
INSERT INTO engnet_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","then there will be an oath to the Lord between the two of them, that he has not laid his hand on his neighbor’s goods, and its owner will accept this, and he will not have to pay. ");
INSERT INTO engnet_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if it was stolen from him, he will pay its owner. ");
INSERT INTO engnet_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If it is torn in pieces, then he will bring it for evidence, and he will not have to pay for what was torn. ");
INSERT INTO engnet_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“If a man borrows an animal from his neighbor, and it is hurt or dies when its owner was not with it, the man who borrowed it will surely pay. ");
INSERT INTO engnet_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","If its owner was with it, he will not have to pay; if it was hired, what was paid for the hire covers it. ");
INSERT INTO engnet_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“If a man seduces a virgin who is not engaged and has sexual relations with her, he must surely endow her to be his wife. ");
INSERT INTO engnet_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father refuses to give her to him, he must pay money for the bride price of virgins. ");
INSERT INTO engnet_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“You must not allow a sorceress to live. ");
INSERT INTO engnet_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Whoever has sexual relations with a beast must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Whoever sacrifices to a god other than the Lord alone must be utterly destroyed. ");
INSERT INTO engnet_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“You must not wrong a foreigner nor oppress him, for you were foreigners in the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“You must not afflict any widow or orphan. ");
INSERT INTO engnet_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you afflict them in any way and they cry to me, I will surely hear their cry, ");
INSERT INTO engnet_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","and my anger will burn and I will kill you with the sword, and your wives will be widows and your children will be fatherless. ");
INSERT INTO engnet_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“If you lend money to any of my people who are needy among you, do not be like a moneylender to him; do not charge him interest. ");
INSERT INTO engnet_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If you do take the garment of your neighbor in pledge, you must return it to him by the time the sun goes down, ");
INSERT INTO engnet_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","for it is his only covering – it is his garment for his body. What else can he sleep in? And when he cries out to me, I will hear, for I am gracious. ");
INSERT INTO engnet_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“You must not blaspheme God or curse the ruler of your people. ");
INSERT INTO engnet_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Do not hold back offerings from your granaries or your vats. You must give me the firstborn of your sons. ");
INSERT INTO engnet_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You must also do this for your oxen and for your sheep; seven days they may remain with their mothers, but give them to me on the eighth day. ");
INSERT INTO engnet_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“You will be holy people to me; you must not eat any meat torn by animals in the field. You must throw it to the dogs. ");
INSERT INTO engnet_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“You must not give a false report. Do not make common cause with the wicked to be a malicious witness. ");
INSERT INTO engnet_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“You must not follow a crowd in doing evil things; in a lawsuit you must not offer testimony that agrees with a crowd so as to pervert justice, ");
INSERT INTO engnet_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","and you must not show partiality to a poor man in his lawsuit. ");
INSERT INTO engnet_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“If you encounter your enemy’s ox or donkey wandering off, you must by all means return it to him. ");
INSERT INTO engnet_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the donkey of someone who hates you fallen under its load, you must not ignore him, but be sure to help him with it. ");
INSERT INTO engnet_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“You must not turn away justice for your poor people in their lawsuits. ");
INSERT INTO engnet_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Keep your distance from a false charge – do not kill the innocent and the righteous, for I will not justify the wicked. ");
INSERT INTO engnet_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“You must not accept a bribe, for a bribe blinds those who see and subverts the words of the righteous. ");
INSERT INTO engnet_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“You must not oppress a foreigner, since you know the life of a foreigner, for you were foreigners in the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“For six years you are to sow your land and gather in its produce. ");
INSERT INTO engnet_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But in the seventh year you must let it lie fallow and leave it alone so that the poor of your people may eat, and what they leave any animal in the field may eat; you must do likewise with your vineyard and your olive grove. ");
INSERT INTO engnet_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","For six days you are to do your work, but on the seventh day you must cease, in order that your ox and your donkey may rest and that your female servant’s son and any hired help may refresh themselves. ");
INSERT INTO engnet_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Pay attention to do everything I have told you, and do not even mention the names of other gods – do not let them be heard on your lips. ");
INSERT INTO engnet_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Three times in the year you must make a pilgrim feast to me. ");
INSERT INTO engnet_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You are to observe the Feast of Unleavened Bread; seven days you must eat bread made without yeast, as I commanded you, at the appointed time of the month of Abib, for at that time you came out of Egypt. No one may appear before me empty-handed. ");
INSERT INTO engnet_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“You are also to observe the Feast of Harvest, the firstfruits of your labors that you have sown in the field, and the Feast of Ingathering at the end of the year when you have gathered in your harvest out of the field. ");
INSERT INTO engnet_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","At three times in the year all your males will appear before the Lord God. ");
INSERT INTO engnet_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“You must not offer the blood of my sacrifice with bread containing yeast; the fat of my festal sacrifice must not remain until morning. ");
INSERT INTO engnet_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","The first of the firstfruits of your soil you must bring to the house of the Lord your God. “You must not cook a young goat in its mother’s milk. ");
INSERT INTO engnet_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“I am going to send an angel before you to protect you as you journey and to bring you into the place that I have prepared. ");
INSERT INTO engnet_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Take heed because of him, and obey his voice; do not rebel against him, for he will not pardon your transgressions, for my name is in him. ");
INSERT INTO engnet_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if you diligently obey him and do all that I command, then I will be an enemy to your enemies, and I will be an adversary to your adversaries. ");
INSERT INTO engnet_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For my angel will go before you and bring you to the Amorites, the Hittites, the Perizzites, the Canaanites, the Hivites, and the Jebusites, and I will destroy them completely. ");
INSERT INTO engnet_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“You must not bow down to their gods; you must not serve them or do according to their practices. Instead you must completely overthrow them and smash their standing stones to pieces. ");
INSERT INTO engnet_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You must serve the Lord your God, and he will bless your bread and your water, and I will remove sickness from your midst. ");
INSERT INTO engnet_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No woman will miscarry her young or be barren in your land. I will fulfill the number of your days. ");
INSERT INTO engnet_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“I will send my terror before you, and I will destroy all the people whom you encounter; I will make all your enemies turn their backs to you. ");
INSERT INTO engnet_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send hornets before you that will drive out the Hivite, the Canaanite, and the Hittite before you. ");
INSERT INTO engnet_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out before you in one year, lest the land become desolate and the wild animals multiply against you. ");
INSERT INTO engnet_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Little by little I will drive them out before you, until you become fruitful and inherit the land. ");
INSERT INTO engnet_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will set your boundaries from the Red Sea to the sea of the Philistines, and from the desert to the River, for I will deliver the inhabitants of the land into your hand, and you will drive them out before you. ");
INSERT INTO engnet_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“You must make no covenant with them or with their gods. ");
INSERT INTO engnet_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They must not live in your land, lest they make you sin against me, for if you serve their gods, it will surely be a snare to you.” ");
INSERT INTO engnet_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","But to Moses the Lord said, “Come up to the Lord, you and Aaron, Nadab and Abihu, and seventy of the elders of Israel, and worship from a distance. ");
INSERT INTO engnet_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alone may come near the Lord, but the others must not come near, nor may the people go up with him.” ");
INSERT INTO engnet_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses came and told the people all the Lord’s words and all the decisions. All the people answered together, “We are willing to do all the words that the Lord has said,” ");
INSERT INTO engnet_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","and Moses wrote down all the words of the Lord. Early in the morning he built an altar at the foot of the mountain and arranged twelve standing stones – according to the twelve tribes of Israel. ");
INSERT INTO engnet_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","He sent young Israelite men, and they offered burnt offerings and sacrificed young bulls for peace offerings to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses took half of the blood and put it in bowls, and half of the blood he splashed on the altar. ");
INSERT INTO engnet_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","He took the Book of the Covenant and read it aloud to the people, and they said, “We are willing to do and obey all that the Lord has spoken.” ");
INSERT INTO engnet_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","So Moses took the blood and splashed it on the people and said, “This is the blood of the covenant that the Lord has made with you in accordance with all these words.” ");
INSERT INTO engnet_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moses and Aaron, Nadab and Abihu, and the seventy elders of Israel went up, ");
INSERT INTO engnet_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","and they saw the God of Israel. Under his feet there was something like a pavement made of sapphire, clear like the sky itself. ");
INSERT INTO engnet_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","But he did not lay a hand on the leaders of the Israelites, so they saw God, and they ate and they drank. ");
INSERT INTO engnet_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","The Lord said to Moses, “Come up to me to the mountain and remain there, and I will give you the stone tablets with the law and the commandments that I have written, so that you may teach them.” ");
INSERT INTO engnet_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","So Moses set out with Joshua his attendant, and Moses went up the mountain of God. ");
INSERT INTO engnet_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","He told the elders, “Wait for us in this place until we return to you. Here are Aaron and Hur with you. Whoever has any matters of dispute can approach them.” ");
INSERT INTO engnet_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses went up the mountain, and the cloud covered the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","The glory of the Lord resided on Mount Sinai, and the cloud covered it for six days. On the seventh day he called to Moses from within the cloud. ");
INSERT INTO engnet_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Now the appearance of the glory of the Lord was like a devouring fire on the top of the mountain in plain view of the people. ");
INSERT INTO engnet_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses went into the cloud when he went up the mountain, and Moses was on the mountain forty days and forty nights. ");
INSERT INTO engnet_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tell the Israelites to take an offering for me; from every person motivated by a willing heart you are to receive my offering. ");
INSERT INTO engnet_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","This is the offering you are to accept from them: gold, silver, bronze, ");
INSERT INTO engnet_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, scarlet, fine linen, goat’s hair, ");
INSERT INTO engnet_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ram skins dyed red, fine leather, acacia wood, ");
INSERT INTO engnet_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil for the light, spices for the anointing oil and for fragrant incense, ");
INSERT INTO engnet_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onyx stones, and other gems to be set in the ephod and in the breastpiece. ");
INSERT INTO engnet_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Let them make for me a sanctuary, so that I may live among them. ");
INSERT INTO engnet_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","According to all that I am showing you – the pattern of the tabernacle and the pattern of all its furnishings – you must make it exactly so. ");
INSERT INTO engnet_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“They are to make an ark of acacia wood – its length is to be three feet nine inches, its width two feet three inches, and its height two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","You are to overlay it with pure gold – both inside and outside you must overlay it, and you are to make a surrounding border of gold over it. ");
INSERT INTO engnet_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","You are to cast four gold rings for it and put them on its four feet, with two rings on one side and two rings on the other side. ");
INSERT INTO engnet_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","You are to make poles of acacia wood, overlay them with gold, ");
INSERT INTO engnet_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","and put the poles into the rings at the sides of the ark in order to carry the ark with them. ");
INSERT INTO engnet_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles must remain in the rings of the ark; they must not be removed from it. ");
INSERT INTO engnet_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","You are to put into the ark the testimony that I will give to you. ");
INSERT INTO engnet_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“You are to make an atonement lid of pure gold; its length is to be three feet nine inches, and its width is to be two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","You are to make two cherubim of gold; you are to make them of hammered metal on the two ends of the atonement lid. ");
INSERT INTO engnet_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Make one cherub on one end and one cherub on the other end; from the atonement lid you are to make the cherubim on the two ends. ");
INSERT INTO engnet_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","The cherubim are to be spreading their wings upward, overshadowing the atonement lid with their wings, and the cherubim are to face each other, looking toward the atonement lid. ");
INSERT INTO engnet_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","You are to put the atonement lid on top of the ark, and in the ark you are to put the testimony I am giving you. ");
INSERT INTO engnet_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I will meet with you there, and from above the atonement lid, from between the two cherubim that are over the ark of the testimony, I will speak with you about all that I will command you for the Israelites. ");
INSERT INTO engnet_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“You are to make a table of acacia wood; its length is to be three feet, its width one foot six inches, and its height two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","You are to overlay it with pure gold, and you are to make a surrounding border of gold for it. ");
INSERT INTO engnet_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","You are to make a surrounding frame for it about three inches broad, and you are to make a surrounding border of gold for its frame. ");
INSERT INTO engnet_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","You are to make four rings of gold for it and attach the rings at the four corners where its four legs are. ");
INSERT INTO engnet_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings are to be close to the frame to provide places for the poles to carry the table. ");
INSERT INTO engnet_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","You are to make the poles of acacia wood and overlay them with gold, so that the table may be carried with them. ");
INSERT INTO engnet_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","You are to make its plates, its ladles, its pitchers, and its bowls, to be used in pouring out offerings; you are to make them of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","You are to set the Bread of the Presence on the table before me continually. ");
INSERT INTO engnet_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“You are to make a lampstand of pure gold. The lampstand is to be made of hammered metal; its base and its shaft, its cups, its buds, and its blossoms are to be from the same piece. ");
INSERT INTO engnet_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Six branches are to extend from the sides of the lampstand, three branches of the lampstand from one side of it and three branches of the lampstand from the other side of it. ");
INSERT INTO engnet_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Three cups shaped like almond flowers with buds and blossoms are to be on one branch, and three cups shaped like almond flowers with buds and blossoms are to be on the next branch, and the same for the six branches extending from the lampstand. ");
INSERT INTO engnet_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","On the lampstand there are to be four cups shaped like almond flowers with buds and blossoms, ");
INSERT INTO engnet_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","with a bud under the first two branches from it, and a bud under the next two branches from it, and a bud under the third two branches from it, according to the six branches that extend from the lampstand. ");
INSERT INTO engnet_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Their buds and their branches will be one piece, all of it one hammered piece of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“You are to make its seven lamps, and then set its lamps up on it, so that it will give light to the area in front of it. ");
INSERT INTO engnet_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Its trimmers and its trays are to be of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","About seventy-five pounds of pure gold is to be used for it and for all these utensils. ");
INSERT INTO engnet_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Now be sure to make them according to the pattern you were shown on the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“The tabernacle itself you are to make with ten curtains of fine twisted linen and blue and purple and scarlet; you are to make them with cherubim that are the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","The length of each curtain is to be forty-two feet, and the width of each curtain is to be six feet – the same size for each of the curtains. ");
INSERT INTO engnet_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five curtains are to be joined, one to another, and the other five curtains are to be joined, one to another. ");
INSERT INTO engnet_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","You are to make loops of blue material along the edge of the end curtain in one set, and in the same way you are to make loops in the outer edge of the end curtain in the second set. ");
INSERT INTO engnet_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","You are to make fifty loops on the one curtain, and you are to make fifty loops on the end curtain which is on the second set, so that the loops are opposite one to another. ");
INSERT INTO engnet_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","You are to make fifty gold clasps and join the curtains together with the clasps, so that the tabernacle is a unit. ");
INSERT INTO engnet_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“You are to make curtains of goats’ hair for a tent over the tabernacle; you are to make eleven curtains. ");
INSERT INTO engnet_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","The length of each curtain is to be forty-five feet, and the width of each curtain is to be six feet – the same size for the eleven curtains. ");
INSERT INTO engnet_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","You are to join five curtains by themselves and six curtains by themselves. You are to double over the sixth curtain at the front of the tent. ");
INSERT INTO engnet_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","You are to make fifty loops along the edge of the end curtain in one set and fifty loops along the edge of the curtain that joins the second set. ");
INSERT INTO engnet_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","You are to make fifty bronze clasps and put the clasps into the loops and join the tent together so that it is a unit. ");
INSERT INTO engnet_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Now the part that remains of the curtains of the tent – the half curtain that remains will hang over at the back of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","The foot and a half on the one side and the foot and a half on the other side of what remains in the length of the curtains of the tent will hang over the sides of the tabernacle, on one side and the other side, to cover it. ");
INSERT INTO engnet_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“You are to make a covering for the tent out of ram skins dyed red and over that a covering of fine leather. ");
INSERT INTO engnet_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“You are to make the frames for the tabernacle out of acacia wood as uprights. ");
INSERT INTO engnet_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Each frame is to be fifteen feet long, and each frame is to be two feet three inches wide, ");
INSERT INTO engnet_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","with two projections per frame parallel one to another. You are to make all the frames of the tabernacle in this way. ");
INSERT INTO engnet_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","So you are to make the frames for the tabernacle: twenty frames for the south side, ");
INSERT INTO engnet_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","and you are to make forty silver bases to go under the twenty frames – two bases under the first frame for its two projections, and likewise two bases under the next frame for its two projections; ");
INSERT INTO engnet_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","and for the second side of the tabernacle, the north side, twenty frames, ");
INSERT INTO engnet_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and their forty silver bases, two bases under the first frame, and two bases under the next frame. ");
INSERT INTO engnet_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","And for the back of the tabernacle on the west you will make six frames. ");
INSERT INTO engnet_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","You are to make two frames for the corners of the tabernacle on the back. ");
INSERT INTO engnet_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","At the two corners they must be doubled at the lower end and finished together at the top in one ring. So it will be for both. ");
INSERT INTO engnet_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","So there are to be eight frames and their silver bases, sixteen bases, two bases under the first frame, and two bases under the next frame. ");
INSERT INTO engnet_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“You are to make bars of acacia wood, five for the frames on one side of the tabernacle, ");
INSERT INTO engnet_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","and five bars for the frames on the second side of the tabernacle, and five bars for the frames on the back of the tabernacle on the west. ");
INSERT INTO engnet_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The middle bar in the center of the frames will reach from end to end. ");
INSERT INTO engnet_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","You are to overlay the frames with gold and make their rings of gold to provide places for the bars, and you are to overlay the bars with gold. ");
INSERT INTO engnet_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","You are to set up the tabernacle according to the plan that you were shown on the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“You are to make a special curtain of blue, purple, and scarlet yarn and fine twisted linen; it is to be made with cherubim, the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","You are to hang it with gold hooks on four posts of acacia wood overlaid with gold, set in four silver bases. ");
INSERT INTO engnet_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","You are to hang this curtain under the clasps and bring the ark of the testimony in there behind the curtain. The curtain will make a division for you between the Holy Place and the Most Holy Place. ");
INSERT INTO engnet_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","You are to put the atonement lid on the ark of the testimony in the Most Holy Place. ");
INSERT INTO engnet_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","You are to put the table outside the curtain and the lampstand on the south side of the tabernacle, opposite the table, and you are to place the table on the north side. ");
INSERT INTO engnet_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“You are to make a hanging for the entrance of the tent of blue, purple, and scarlet yarn and fine twined linen, the work of an embroiderer. ");
INSERT INTO engnet_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","You are to make for the hanging five posts of acacia wood and overlay them with gold, and their hooks will be gold, and you are to cast five bronze bases for them. ");
INSERT INTO engnet_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“You are to make the altar of acacia wood, seven feet six inches long, and seven feet six inches wide; the altar is to be square, and its height is to be four feet six inches. ");
INSERT INTO engnet_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","You are to make its four horns on its four corners; its horns will be part of it, and you are to overlay it with bronze. ");
INSERT INTO engnet_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","You are to make its pots for the ashes, its shovels, its tossing bowls, its meat hooks, and its fire pans – you are to make all its utensils of bronze. ");
INSERT INTO engnet_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","You are to make a grating for it, a network of bronze, and you are to make on the network four bronze rings on its four corners. ");
INSERT INTO engnet_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","You are to put it under the ledge of the altar below, so that the network will come halfway up the altar. ");
INSERT INTO engnet_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","You are to make poles for the altar, poles of acacia wood, and you are to overlay them with bronze. ");
INSERT INTO engnet_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","The poles are to be put into the rings so that the poles will be on two sides of the altar when carrying it. ");
INSERT INTO engnet_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","You are to make the altar hollow, out of boards. Just as it was shown you on the mountain, so they must make it. ");
INSERT INTO engnet_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“You are to make the courtyard of the tabernacle. For the south side there are to be hangings for the courtyard of fine twisted linen, one hundred fifty feet long for one side, ");
INSERT INTO engnet_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","with twenty posts and their twenty bronze bases, with the hooks of the posts and their bands of silver. ");
INSERT INTO engnet_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Likewise for its length on the north side, there are to be hangings for one hundred fifty feet, with twenty posts and their twenty bronze bases, with silver hooks and bands on the posts. ");
INSERT INTO engnet_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","The width of the court on the west side is to be seventy-five feet with hangings, with their ten posts and their ten bases. ");
INSERT INTO engnet_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The width of the court on the east side, toward the sunrise, is to be seventy-five feet. ");
INSERT INTO engnet_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","The hangings on one side of the gate are to be twenty-two and a half feet long, with their three posts and their three bases. ");
INSERT INTO engnet_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","On the second side there are to be hangings twenty-two and a half feet long, with their three posts and their three bases. ");
INSERT INTO engnet_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","For the gate of the courtyard there is to be a curtain of thirty feet, of blue, purple, and scarlet yarn and fine twined linen, the work of an embroiderer, with four posts and their four bases. ");
INSERT INTO engnet_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the posts around the courtyard are to have silver bands; their hooks are to be silver, and their bases bronze. ");
INSERT INTO engnet_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The length of the courtyard is to be one hundred fifty feet and the width seventy-five feet, and the height of the fine twisted linen hangings is to be seven and a half feet, with their bronze bases. ");
INSERT INTO engnet_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the utensils of the tabernacle used in all its service, all its tent pegs, and all the tent pegs of the courtyard are to be made of bronze. ");
INSERT INTO engnet_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“You are to command the Israelites that they bring to you pure oil of pressed olives for the light, so that the lamps will burn regularly. ");
INSERT INTO engnet_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the tent of meeting outside the curtain that is before the testimony, Aaron and his sons are to arrange it from evening to morning before the Lord. This is to be a lasting ordinance among the Israelites for generations to come. ");
INSERT INTO engnet_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“And you, bring near to you your brother Aaron and his sons with him from among the Israelites, so that they may minister as my priests – Aaron, Nadab and Abihu, Eleazar and Ithamar, Aaron’s sons. ");
INSERT INTO engnet_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","You must make holy garments for your brother Aaron, for glory and for beauty. ");
INSERT INTO engnet_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","You are to speak to all who are specially skilled, whom I have filled with the spirit of wisdom, so that they may make Aaron’s garments to set him apart to minister as my priest. ");
INSERT INTO engnet_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Now these are the garments that they are to make: a breastpiece, an ephod, a robe, a fitted tunic, a turban, and a sash. They are to make holy garments for your brother Aaron and for his sons, that they may minister as my priests. ");
INSERT INTO engnet_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","The artisans are to use the gold, blue, purple, scarlet, and fine linen. ");
INSERT INTO engnet_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“They are to make the ephod of gold, blue, purple, scarlet, and fine twisted linen, the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It is to have two shoulder pieces attached to two of its corners, so it can be joined together. ");
INSERT INTO engnet_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","The artistically woven waistband of the ephod that is on it is to be like it, of one piece with the ephod, of gold, blue, purple, scarlet, and fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“You are to take two onyx stones and engrave on them the names of the sons of Israel, ");
INSERT INTO engnet_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six of their names on one stone, and the six remaining names on the second stone, according to the order of their birth. ");
INSERT INTO engnet_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","You are to engrave the two stones with the names of the sons of Israel with the work of an engraver in stone, like the engravings of a seal; you are to have them set in gold filigree settings. ");
INSERT INTO engnet_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","You are to put the two stones on the shoulders of the ephod, stones of memorial for the sons of Israel, and Aaron will bear their names before the Lord on his two shoulders for a memorial. ");
INSERT INTO engnet_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","You are to make filigree settings of gold ");
INSERT INTO engnet_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two braided chains of pure gold, like a cord, and attach the chains to the settings. ");
INSERT INTO engnet_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“You are to make a breastpiece for use in making decisions, the work of an artistic designer; you are to make it in the same fashion as the ephod; you are to make it of gold, blue, purple, scarlet, and fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It is to be square when doubled, nine inches long and nine inches wide. ");
INSERT INTO engnet_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","You are to set in it a setting for stones, four rows of stones, a row with a ruby, a topaz, and a beryl – the first row; ");
INSERT INTO engnet_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","and the second row, a turquoise, a sapphire, and an emerald; ");
INSERT INTO engnet_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","and the third row, a jacinth, an agate, and an amethyst; ");
INSERT INTO engnet_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","and the fourth row, a chrysolite, an onyx, and a jasper. They are to be enclosed in gold in their filigree settings. ");
INSERT INTO engnet_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","The stones are to be for the names of the sons of Israel, twelve, according to the number of their names. Each name according to the twelve tribes is to be like the engravings of a seal. ");
INSERT INTO engnet_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“You are to make for the breastpiece braided chains like cords of pure gold, ");
INSERT INTO engnet_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","and you are to make for the breastpiece two gold rings and attach the two rings to the upper two ends of the breastpiece. ");
INSERT INTO engnet_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","You are to attach the two gold chains to the two rings at the ends of the breastpiece; ");
INSERT INTO engnet_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","the other two ends of the two chains you will attach to the two settings and then attach them to the shoulder pieces of the ephod at the front of it. ");
INSERT INTO engnet_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","You are to make two rings of gold and put them on the other two ends of the breastpiece, on its edge that is on the inner side of the ephod. ");
INSERT INTO engnet_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","You are to make two more gold rings and attach them to the bottom of the two shoulder pieces on the front of the ephod, close to the juncture above the waistband of the ephod. ");
INSERT INTO engnet_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","They are to tie the breastpiece by its rings to the rings of the ephod by blue cord, so that it may be above the waistband of the ephod, and so that the breastpiece will not be loose from the ephod. ");
INSERT INTO engnet_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaron will bear the names of the sons of Israel in the breastpiece of decision over his heart when he goes into the holy place, for a memorial before the Lord continually. ");
INSERT INTO engnet_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“You are to put the Urim and the Thummim into the breastpiece of decision; and they are to be over Aaron’s heart when he goes in before the Lord. Aaron is to bear the decisions of the Israelites over his heart before the Lord continually. ");
INSERT INTO engnet_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“You are to make the robe of the ephod completely blue. ");
INSERT INTO engnet_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","There is to be an opening in its top in the center of it, with an edge all around the opening, the work of a weaver, like the opening of a collar, so that it cannot be torn. ");
INSERT INTO engnet_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","You are to make pomegranates of blue, purple, and scarlet all around its hem and bells of gold between them all around. ");
INSERT INTO engnet_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","The pattern is to be a gold bell and a pomegranate, a gold bell and a pomegranate, all around the hem of the robe. ");
INSERT INTO engnet_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","The robe is to be on Aaron as he ministers, and his sound will be heard when he enters the Holy Place before the Lord and when he leaves, so that he does not die. ");
INSERT INTO engnet_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“You are to make a plate of pure gold and engrave on it the way a seal is engraved: “Holiness to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","You are to attach to it a blue cord so that it will be on the turban; it is to be on the front of the turban, ");
INSERT INTO engnet_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","It will be on Aaron’s forehead, and Aaron will bear the iniquity of the holy things, which the Israelites are to sanctify by all their holy gifts; it will always be on his forehead, for their acceptance before the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","You are to weave the tunic of fine linen and make the turban of fine linen, and make the sash the work of an embroiderer. ");
INSERT INTO engnet_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“For Aaron’s sons you are to make tunics, sashes, and headbands for glory and for beauty. ");
INSERT INTO engnet_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“You are to clothe them – your brother Aaron and his sons with him – and anoint them and ordain them and set them apart as holy, so that they may minister as my priests. ");
INSERT INTO engnet_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Make for them linen undergarments to cover their naked bodies; they must cover from the waist to the thighs. ");
INSERT INTO engnet_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","These must be on Aaron and his sons when they enter to the tent of meeting, or when they approach the altar to minister in the Holy Place, so that they bear no iniquity and die. It is to be a perpetual ordinance for him and for his descendants after him. ");
INSERT INTO engnet_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Now this is what you are to do for them to consecrate them so that they may minister as my priests. Take a young bull and two rams without blemish; ");
INSERT INTO engnet_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","and bread made without yeast, and perforated cakes without yeast mixed with oil, and wafers without yeast spread with oil – you are to make them using fine wheat flour. ");
INSERT INTO engnet_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","You are to put them in one basket and present them in the basket, along with the bull and the two rams. ");
INSERT INTO engnet_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“You are to present Aaron and his sons at the entrance of the tent of meeting. You are to wash them with water ");
INSERT INTO engnet_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","and take the garments and clothe Aaron with the tunic, the robe of the ephod, the ephod, and the breastpiece; you are to fasten the ephod on him by using the skillfully woven waistband. ");
INSERT INTO engnet_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","You are to put the turban on his head and put the holy diadem on the turban. ");
INSERT INTO engnet_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","You are to take the anointing oil and pour it on his head and anoint him. ");
INSERT INTO engnet_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","You are to present his sons and clothe them with tunics ");
INSERT INTO engnet_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","and wrap the sashes around Aaron and his sons and put headbands on them, and so the ministry of priesthood will belong to them by a perpetual ordinance. Thus you are to consecrate Aaron and his sons. ");
INSERT INTO engnet_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“You are to present the bull at the front of the tent of meeting, and Aaron and his sons are to put their hands on the head of the bull. ");
INSERT INTO engnet_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","You are to kill the bull before the Lord at the entrance to the tent of meeting ");
INSERT INTO engnet_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","and take some of the blood of the bull and put it on the horns of the altar with your finger; all the rest of the blood you are to pour out at the base of the altar. ");
INSERT INTO engnet_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","You are to take all the fat that covers the entrails, and the lobe that is above the liver, and the two kidneys and the fat that is on them, and burn them on the altar. ");
INSERT INTO engnet_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But the meat of the bull, its skin, and its dung you are to burn up outside the camp. It is the purification offering. ");
INSERT INTO engnet_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“You are to take one ram, and Aaron and his sons are to lay their hands on the ram’s head, ");
INSERT INTO engnet_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","and you are to kill the ram and take its blood and splash it all around on the altar. ");
INSERT INTO engnet_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Then you are to cut the ram into pieces and wash the entrails and its legs and put them on its pieces and on its head ");
INSERT INTO engnet_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","and burn the whole ram on the altar. It is a burnt offering to the Lord, a soothing aroma; it is an offering made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“You are to take the second ram, and Aaron and his sons are to lay their hands on the ram’s head, ");
INSERT INTO engnet_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","and you are to kill the ram and take some of its blood and put it on the tip of the right ear of Aaron, on the tip of the right ear of his sons, on the thumb of their right hand, and on the big toe of their right foot, and then splash the blood all around on the altar. ");
INSERT INTO engnet_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","You are to take some of the blood that is on the altar and some of the anointing oil and sprinkle it on Aaron, on his garments, on his sons, and on his sons’ garments with him, so that he may be holy, he and his garments along with his sons and his sons’ garments. ");
INSERT INTO engnet_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“You are to take from the ram the fat, the fat tail, the fat that covers the entrails, the lobe of the liver, the two kidneys and the fat that is on them, and the right thigh – for it is the ram for consecration – ");
INSERT INTO engnet_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","and one round flat cake of bread, one perforated cake of oiled bread, and one wafer from the basket of bread made without yeast that is before the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","You are to put all these in Aaron’s hands and in his sons’ hands, and you are to wave them as a wave offering before the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then you are to take them from their hands and burn them on the altar for a burnt offering, for a soothing aroma before the Lord. It is an offering made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","You are to take the breast of the ram of Aaron’s consecration; you are to wave it as a wave offering before the Lord, and it is to be your share. ");
INSERT INTO engnet_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","You are to sanctify the breast of the wave offering and the thigh of the contribution, which were waved and lifted up as a contribution from the ram of consecration, from what belongs to Aaron and to his sons. ");
INSERT INTO engnet_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","It is to belong to Aaron and to his sons from the Israelites, by a perpetual ordinance, for it is a contribution. It is to be a contribution from the Israelites from their peace offerings, their contribution to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“The holy garments that belong to Aaron are to belong to his sons after him, so that they may be anointed in them and consecrated in them. ");
INSERT INTO engnet_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","The priest who succeeds him from his sons, when he first comes to the tent of meeting to minister in the Holy Place, is to wear them for seven days. ");
INSERT INTO engnet_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“You are to take the ram of the consecration and cook its meat in a holy place. ");
INSERT INTO engnet_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron and his sons are to eat the meat of the ram and the bread that was in the basket at the entrance of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They are to eat those things by which atonement was made to consecrate and to set them apart, but no one else may eat them, for they are holy. ");
INSERT INTO engnet_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If any of the meat from the consecration offerings or any of the bread is left over until morning, then you are to burn up what is left over. It must not be eaten, because it is holy. ");
INSERT INTO engnet_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Thus you are to do for Aaron and for his sons, according to all that I have commanded you; you are to consecrate them for seven days. ");
INSERT INTO engnet_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Every day you are to prepare a bull for a purification offering for atonement. You are to purge the altar by making atonement for it, and you are to anoint it to set it apart as holy. ");
INSERT INTO engnet_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","For seven days you are to make atonement for the altar and set it apart as holy. Then the altar will be most holy. Anything that touches the altar will be holy. ");
INSERT INTO engnet_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Now this is what you are to prepare on the altar every day continually: two lambs a year old. ");
INSERT INTO engnet_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","The first lamb you are to prepare in the morning, and the second lamb you are to prepare around sundown. ");
INSERT INTO engnet_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","With the first lamb offer a tenth of an ephah of fine flour mixed with a fourth of a hin of oil from pressed olives, and a fourth of a hin of wine as a drink offering. ");
INSERT INTO engnet_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","The second lamb you are to offer around sundown; you are to prepare for it the same meal offering as for the morning and the same drink offering, for a soothing aroma, an offering made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“This will be a regular burnt offering throughout your generations at the entrance of the tent of meeting before the Lord, where I will meet with you to speak to you there. ");
INSERT INTO engnet_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","There I will meet with the Israelites, and it will be set apart as holy by my glory. ");
INSERT INTO engnet_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“So I will set apart as holy the tent of meeting and the altar, and I will set apart as holy Aaron and his sons, that they may minister as priests to me. ");
INSERT INTO engnet_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I will reside among the Israelites, and I will be their God, ");
INSERT INTO engnet_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","and they will know that I am the Lord their God, who brought them out from the land of Egypt, so that I may reside among them. I am the Lord their God. ");
INSERT INTO engnet_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“You are to make an altar for burning incense; you are to make it of acacia wood. ");
INSERT INTO engnet_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Its length is to be a foot and a half and its width a foot and a half; it will be square. Its height is to be three feet, with its horns of one piece with it. ");
INSERT INTO engnet_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","You are to overlay it with pure gold – its top, its four walls, and its horns – and make a surrounding border of gold for it. ");
INSERT INTO engnet_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","You are to make two gold rings for it under its border, on its two flanks; you are to make them on its two sides. The rings will be places for poles to carry it with. ");
INSERT INTO engnet_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","You are to make the poles of acacia wood and overlay them with gold. ");
INSERT INTO engnet_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","“You are to put it in front of the curtain that is before the ark of the testimony (before the atonement lid that is over the testimony), where I will meet you. ");
INSERT INTO engnet_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron is to burn sweet incense on it morning by morning; when he attends to the lamps he is to burn incense. ");
INSERT INTO engnet_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","When Aaron sets up the lamps around sundown he is to burn incense on it; it is to be a regular incense offering before the Lord throughout your generations. ");
INSERT INTO engnet_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","You must not offer strange incense on it, nor burnt offering, nor meal offering, and you must not pour out a drink offering on it. ");
INSERT INTO engnet_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron is to make atonement on its horns once in the year with some of the blood of the sin offering for atonement; once in the year he is to make atonement on it throughout your generations. It is most holy to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When you take a census of the Israelites according to their number, then each man is to pay a ransom for his life to the Lord when you number them, so that there will be no plague among them when you number them. ");
INSERT INTO engnet_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Everyone who crosses over to those who are numbered is to pay this: a half shekel according to the shekel of the sanctuary (a shekel weighs twenty gerahs). The half shekel is to be an offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone who crosses over to those numbered, from twenty years old and up, is to pay an offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","The rich are not to increase it, and the poor are not to pay less than the half shekel when giving the offering of the Lord, to make atonement for your lives. ");
INSERT INTO engnet_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","You are to receive the atonement money from the Israelites and give it for the service of the tent of meeting. It will be a memorial for the Israelites before the Lord, to make atonement for your lives.” ");
INSERT INTO engnet_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“You are also to make a large bronze basin with a bronze stand for washing. You are to put it between the tent of meeting and the altar and put water in it, ");
INSERT INTO engnet_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","and Aaron and his sons must wash their hands and their feet from it. ");
INSERT INTO engnet_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","When they enter the tent of meeting, they must wash with water so that they do not die. Also, when they approach the altar to minister by burning incense as an offering made by fire to the Lord, ");
INSERT INTO engnet_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","they must wash their hands and their feet so that they do not die. And this will be a perpetual ordinance for them and for their descendants throughout their generations.” ");
INSERT INTO engnet_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Take choice spices: twelve and a half pounds of free-flowing myrrh, half that – about six and a quarter pounds – of sweet-smelling cinnamon, six and a quarter pounds of sweet-smelling cane, ");
INSERT INTO engnet_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","and twelve and a half pounds of cassia, all weighed according to the sanctuary shekel, and four quarts of olive oil. ");
INSERT INTO engnet_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","You are to make this into a sacred anointing oil, a perfumed compound, the work of a perfumer. It will be sacred anointing oil. ");
INSERT INTO engnet_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“With it you are to anoint the tent of meeting, the ark of the testimony, ");
INSERT INTO engnet_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all its utensils, the lampstand and its utensils, the altar of incense, ");
INSERT INTO engnet_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","the altar for the burnt offering and all its utensils, and the laver and its base. ");
INSERT INTO engnet_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","So you are to sanctify them, and they will be most holy; anything that touches them will be holy. ");
INSERT INTO engnet_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“You are to anoint Aaron and his sons and sanctify them, so that they may minister as my priests. ");
INSERT INTO engnet_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And you are to tell the Israelites: ‘This is to be my sacred anointing oil throughout your generations. ");
INSERT INTO engnet_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","It must not be applied to people’s bodies, and you must not make any like it with the same recipe. It is holy, and it must be holy to you. ");
INSERT INTO engnet_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whoever makes perfume like it and whoever puts any of it on someone not a priest will be cut off from his people.’” ");
INSERT INTO engnet_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","The Lord said to Moses: “Take spices, gum resin, onycha, galbanum, and pure frankincense of equal amounts ");
INSERT INTO engnet_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","and make it into an incense, a perfume, the work of a perfumer. It is to be finely ground, and pure and sacred. ");
INSERT INTO engnet_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","You are to beat some of it very fine and put some of it before the ark of the testimony in the tent of meeting where I will meet with you; it is to be most holy to you. ");
INSERT INTO engnet_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","And the incense that you are to make, you must not make for yourselves using the same recipe; it is to be most holy to you, belonging to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Whoever makes anything like it, to use as perfume, will be cut off from his people.” ");
INSERT INTO engnet_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“See, I have chosen Bezalel son of Uri, the son of Hur, of the tribe of Judah, ");
INSERT INTO engnet_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","and I have filled him with the Spirit of God in skill, in understanding, in knowledge, and in all kinds of craftsmanship, ");
INSERT INTO engnet_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","to make artistic designs for work with gold, with silver, and with bronze, ");
INSERT INTO engnet_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","and with cutting and setting stone, and with cutting wood, to work in all kinds of craftsmanship. ");
INSERT INTO engnet_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Moreover, I have also given him Oholiab son of Ahisamach, of the tribe of Dan, and I have given ability to all the specially skilled, that they may make everything I have commanded you: ");
INSERT INTO engnet_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the tent of meeting, the ark of the testimony, the atonement lid that is on it, all the furnishings of the tent, ");
INSERT INTO engnet_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table with its utensils, the pure lampstand with all its utensils, the altar of incense, ");
INSERT INTO engnet_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar for the burnt offering with all its utensils, the large basin with its base, ");
INSERT INTO engnet_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","the woven garments, the holy garments for Aaron the priest and the garments for his sons, to minister as priests, ");
INSERT INTO engnet_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","the anointing oil, and sweet incense for the Holy Place. They will make all these things just as I have commanded you.” ");
INSERT INTO engnet_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","The Lord said to Moses, ");
INSERT INTO engnet_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israelites, ‘Surely you must keep my Sabbaths, for it is a sign between me and you throughout your generations, that you may know that I am the Lord who sanctifies you. ");
INSERT INTO engnet_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","So you must keep the Sabbath, for it is holy for you. Everyone who defiles it must surely be put to death; indeed, if anyone does any work on it, then that person will be cut off from among his people. ");
INSERT INTO engnet_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Six days work may be done, but on the seventh day is a Sabbath of complete rest, holy to the Lord; anyone who does work on the Sabbath day must surely be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","The Israelites must keep the Sabbath by observing the Sabbath throughout their generations as a perpetual covenant. ");
INSERT INTO engnet_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It is a sign between me and the Israelites forever; for in six days the Lord made the heavens and the earth, and on the seventh day he rested and was refreshed.’” ");
INSERT INTO engnet_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","He gave Moses two tablets of testimony when he had finished speaking with him on Mount Sinai, tablets of stone written by the finger of God. ");
INSERT INTO engnet_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","When the people saw that Moses delayed in coming down from the mountain, they gathered around Aaron and said to him, “Get up, make us gods that will go before us. As for this fellow Moses, the man who brought us up from the land of Egypt, we do not know what has become of him!” ");
INSERT INTO engnet_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","So Aaron said to them, “Break off the gold earrings that are on the ears of your wives, your sons, and your daughters, and bring them to me.” ");
INSERT INTO engnet_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","So all the people broke off the gold earrings that were on their ears and brought them to Aaron. ");
INSERT INTO engnet_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He accepted the gold from them, fashioned it with an engraving tool, and made a molten calf. Then they said, “These are your gods, O Israel, who brought you up out of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw this, he built an altar before it, and Aaron made a proclamation and said, “Tomorrow will be a feast to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","So they got up early on the next day and offered up burnt offerings and brought peace offerings, and the people sat down to eat and drink, and they rose up to play. ");
INSERT INTO engnet_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","The Lord spoke to Moses: “Go quickly, descend, because your people, whom you brought up from the land of Egypt, have acted corruptly. ");
INSERT INTO engnet_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have quickly turned aside from the way that I commanded them – they have made for themselves a molten calf and have bowed down to it and sacrificed to it and said, ‘These are your gods, O Israel, which brought you up from the land of Egypt.’” ");
INSERT INTO engnet_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Then the Lord said to Moses: “I have seen this people. Look what a stiff-necked people they are! ");
INSERT INTO engnet_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","So now, leave me alone so that my anger can burn against them and I can destroy them, and I will make from you a great nation.” ");
INSERT INTO engnet_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses sought the favor of the Lord his God and said, “O Lord, why does your anger burn against your people, whom you have brought out from the land of Egypt with great power and with a mighty hand? ");
INSERT INTO engnet_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians say, ‘For evil he led them out to kill them in the mountains and to destroy them from the face of the earth’? Turn from your burning anger, and relent of this evil against your people. ");
INSERT INTO engnet_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Abraham, Isaac, and Israel your servants, to whom you swore by yourself and told them, ‘I will multiply your descendants like the stars of heaven, and all this land that I have spoken about I will give to your descendants, and they will inherit it forever.’” ");
INSERT INTO engnet_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Then the Lord relented over the evil that he had said he would do to his people. ");
INSERT INTO engnet_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moses turned and went down from the mountain with the two tablets of the testimony in his hands. The tablets were written on both sides – they were written on the front and on the back. ");
INSERT INTO engnet_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Now the tablets were the work of God, and the writing was the writing of God, engraved on the tablets. ");
INSERT INTO engnet_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","When Joshua heard the noise of the people as they shouted, he said to Moses, “It is the sound of war in the camp!” ");
INSERT INTO engnet_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses said, “It is not the sound of those who shout for victory, nor is it the sound of those who cry because they are overcome, but the sound of singing I hear.” ");
INSERT INTO engnet_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","When he approached the camp and saw the calf and the dancing, Moses became extremely angry. He threw the tablets from his hands and broke them to pieces at the bottom of the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","He took the calf they had made and burned it in the fire, ground it to powder, poured it out on the water, and made the Israelites drink it. ");
INSERT INTO engnet_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moses said to Aaron, “What did this people do to you, that you have brought on them so great a sin?” ");
INSERT INTO engnet_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron said, “Do not let your anger burn hot, my lord; you know these people, that they tend to evil. ");
INSERT INTO engnet_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","They said to me, ‘Make us gods that will go before us, for as for this fellow Moses, the man who brought us up out of the land of Egypt, we do not know what has happened to him.’ ");
INSERT INTO engnet_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I said to them, ‘Whoever has gold, break it off.’ So they gave it to me, and I threw it into the fire, and this calf came out.” ");
INSERT INTO engnet_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses saw that the people were running wild, for Aaron had let them get completely out of control, causing derision from their enemies. ");
INSERT INTO engnet_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","So Moses stood at the entrance of the camp and said, “Whoever is for the Lord, come to me.” All the Levites gathered around him, ");
INSERT INTO engnet_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","and he said to them, “Thus says the Lord, the God of Israel, ‘Each man fasten his sword on his side, and go back and forth from entrance to entrance throughout the camp, and each one kill his brother, his friend, and his neighbor.’” ");
INSERT INTO engnet_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The Levites did what Moses ordered, and that day about three thousand men of the people died. ");
INSERT INTO engnet_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses said, “You have been consecrated today for the Lord, for each of you was against his son or against his brother, so he has given a blessing to you today.” ");
INSERT INTO engnet_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The next day Moses said to the people, “You have committed a very serious sin, but now I will go up to the Lord – perhaps I can make atonement on behalf of your sin.” ");
INSERT INTO engnet_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","So Moses returned to the Lord and said, “Alas, this people has committed a very serious sin, and they have made for themselves gods of gold. ");
INSERT INTO engnet_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now, if you will forgive their sin…, but if not, wipe me out from your book that you have written.” ");
INSERT INTO engnet_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","The Lord said to Moses, “Whoever has sinned against me – that person I will wipe out of my book. ");
INSERT INTO engnet_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","So now go, lead the people to the place I have spoken to you about. See, my angel will go before you. But on the day that I punish, I will indeed punish them for their sin.” ");
INSERT INTO engnet_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And the Lord sent a plague on the people because they had made the calf – the one Aaron made. ");
INSERT INTO engnet_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","The Lord said to Moses, “Go up from here, you and the people whom you brought up out of the land of Egypt, to the land I promised on oath to Abraham, to Isaac, and to Jacob, saying, ‘I will give it to your descendants.’ ");
INSERT INTO engnet_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I will send an angel before you, and I will drive out the Canaanite, the Amorite, the Hittite, the Perizzite, the Hivite, and the Jebusite. ");
INSERT INTO engnet_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Go up to a land flowing with milk and honey. But I will not go up among you, for you are a stiff-necked people, and I might destroy you on the way.” ");
INSERT INTO engnet_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","When the people heard this troubling word they mourned; no one put on his ornaments. ");
INSERT INTO engnet_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","For the Lord had said to Moses, “Tell the Israelites, ‘You are a stiff-necked people. If I went up among you for a moment, I might destroy you. Now take off your ornaments, that I may know what I should do to you.’” ");
INSERT INTO engnet_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the Israelites stripped off their ornaments by Mount Horeb. ");
INSERT INTO engnet_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses took the tent and pitched it outside the camp, at a good distance from the camp, and he called it the tent of meeting. Anyone seeking the Lord would go out to the tent of meeting that was outside the camp. ");
INSERT INTO engnet_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","And when Moses went out to the tent, all the people would get up and stand at the entrance to their tents and watch Moses until he entered the tent. ");
INSERT INTO engnet_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","And whenever Moses entered the tent, the pillar of cloud would descend and stand at the entrance of the tent, and the Lord would speak with Moses. ");
INSERT INTO engnet_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","When all the people would see the pillar of cloud standing at the entrance of the tent, all the people, each one at the entrance of his own tent, would rise and worship. ");
INSERT INTO engnet_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","The Lord would speak to Moses face to face, the way a person speaks to a friend. Then Moses would return to the camp, but his servant, Joshua son of Nun, a young man, did not leave the tent. ");
INSERT INTO engnet_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses said to the Lord, “See, you have been saying to me, ‘Bring this people up,’ but you have not let me know whom you will send with me. But you said, ‘I know you by name, and also you have found favor in my sight.’ ");
INSERT INTO engnet_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Now if I have found favor in your sight, show me your way, that I may know you, that I may continue to find favor in your sight. And see that this nation is your people.” ");
INSERT INTO engnet_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","And the Lord said, “My presence will go with you, and I will give you rest.” ");
INSERT INTO engnet_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","And Moses said to him, “If your presence does not go with us, do not take us up from here. ");
INSERT INTO engnet_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For how will it be known then that I have found favor in your sight, I and your people? Is it not by your going with us, so that we will be distinguished, I and your people, from all the people who are on the face of the earth?” ");
INSERT INTO engnet_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","The Lord said to Moses, “I will do this thing also that you have requested, for you have found favor in my sight, and I know you by name.” ");
INSERT INTO engnet_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","And Moses said, “Show me your glory.” ");
INSERT INTO engnet_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","And the Lord said, “I will make all my goodness pass before your face, and I will proclaim the Lord by name before you; I will be gracious to whom I will be gracious, I will show mercy to whom I will show mercy.” ");
INSERT INTO engnet_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But he added, “You cannot see my face, for no one can see me and live.” ");
INSERT INTO engnet_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","The Lord said, “Here is a place by me; you will station yourself on a rock. ");
INSERT INTO engnet_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","When my glory passes by, I will put you in a cleft in the rock and will cover you with my hand while I pass by. ");
INSERT INTO engnet_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take away my hand, and you will see my back, but my face must not be seen.” ");
INSERT INTO engnet_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","The Lord said to Moses, “Cut out two tablets of stone like the first, and I will write on the tablets the words that were on the first tablets, which you smashed. ");
INSERT INTO engnet_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Be prepared in the morning, and go up in the morning to Mount Sinai, and station yourself for me there on the top of the mountain. ");
INSERT INTO engnet_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one is to come up with you; do not let anyone be seen anywhere on the mountain; not even the flocks or the herds may graze in front of that mountain.” ");
INSERT INTO engnet_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses cut out two tablets of stone like the first; early in the morning he went up to Mount Sinai, just as the Lord had commanded him, and he took in his hand the two tablets of stone. ");
INSERT INTO engnet_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","The Lord descended in the cloud and stood with him there and proclaimed the Lord by name. ");
INSERT INTO engnet_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","The Lord passed by before him and proclaimed: “The Lord, the Lord, the compassionate and gracious God, slow to anger, and abounding in loyal love and faithfulness, ");
INSERT INTO engnet_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","keeping loyal love for thousands, forgiving iniquity and transgression and sin. But he by no means leaves the guilty unpunished, responding to the transgression of fathers by dealing with children and children’s children, to the third and fourth generation.” ");
INSERT INTO engnet_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses quickly bowed to the ground and worshiped ");
INSERT INTO engnet_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","and said, “If now I have found favor in your sight, O Lord, let my Lord go among us, for we are a stiff-necked people; pardon our iniquity and our sin, and take us for your inheritance.” ");
INSERT INTO engnet_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","He said, “See, I am going to make a covenant before all your people. I will do wonders such as have not been done in all the earth, nor in any nation. All the people among whom you live will see the work of the Lord, for it is a fearful thing that I am doing with you. ");
INSERT INTO engnet_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Obey what I am commanding you this day. I am going to drive out before you the Amorite, the Canaanite, the Hittite, the Perizzite, the Hivite, and the Jebusite. ");
INSERT INTO engnet_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be careful not to make a covenant with the inhabitants of the land where you are going, lest it become a snare among you. ");
INSERT INTO engnet_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Rather you must destroy their altars, smash their images, and cut down their Asherah poles. ");
INSERT INTO engnet_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For you must not worship any other god, for the Lord, whose name is Jealous, is a jealous God. ");
INSERT INTO engnet_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Be careful not to make a covenant with the inhabitants of the land, for when they prostitute themselves to their gods and sacrifice to their gods, and someone invites you, you will eat from his sacrifice; ");
INSERT INTO engnet_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","and you then take his daughters for your sons, and when his daughters prostitute themselves to their gods, they will make your sons prostitute themselves to their gods as well. ");
INSERT INTO engnet_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","You must not make yourselves molten gods. ");
INSERT INTO engnet_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“You must keep the Feast of Unleavened Bread. For seven days you must eat bread made without yeast, as I commanded you; do this at the appointed time of the month Abib, for in the month Abib you came out of Egypt. ");
INSERT INTO engnet_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Every firstborn of the womb belongs to me, even every firstborn of your cattle that is a male, whether ox or sheep. ");
INSERT INTO engnet_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Now the firstling of a donkey you may redeem with a lamb, but if you do not redeem it, then break its neck. You must redeem all the firstborn of your sons. “No one will appear before me empty-handed. ");
INSERT INTO engnet_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“On six days you may labor, but on the seventh day you must rest; even at the time of plowing and of harvest you are to rest. ");
INSERT INTO engnet_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“You must observe the Feast of Weeks – the firstfruits of the harvest of wheat – and the Feast of Ingathering at the end of the year. ");
INSERT INTO engnet_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","At three times in the year all your men must appear before the Lord God, the God of Israel. ");
INSERT INTO engnet_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out the nations before you and enlarge your borders; no one will covet your land when you go up to appear before the Lord your God three times in the year. ");
INSERT INTO engnet_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“You must not offer the blood of my sacrifice with yeast; the sacrifice from the feast of Passover must not remain until the following morning. ");
INSERT INTO engnet_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“The first of the firstfruits of your soil you must bring to the house of the Lord your God. You must not cook a young goat in its mother’s milk.” ");
INSERT INTO engnet_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","The Lord said to Moses, “Write down these words, for in accordance with these words I have made a covenant with you and with Israel.” ");
INSERT INTO engnet_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","So he was there with the Lord forty days and forty nights; he did not eat bread, and he did not drink water. He wrote on the tablets the words of the covenant, the ten commandments. ");
INSERT INTO engnet_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Now when Moses came down from Mount Sinai with the two tablets of the testimony in his hand – when he came down from the mountain, Moses did not know that the skin of his face shone while he talked with him. ");
INSERT INTO engnet_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","When Aaron and all the Israelites saw Moses, the skin of his face shone; and they were afraid to approach him. ");
INSERT INTO engnet_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses called to them, so Aaron and all the leaders of the community came back to him, and Moses spoke to them. ");
INSERT INTO engnet_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","After this all the Israelites approached, and he commanded them all that the Lord had spoken to him on Mount Sinai. ");
INSERT INTO engnet_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses finished speaking with them, he would put a veil on his face. ");
INSERT INTO engnet_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But when Moses went in before the Lord to speak with him, he would remove the veil until he came out. Then he would come out and tell the Israelites what he had been commanded. ");
INSERT INTO engnet_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","When the Israelites would see the face of Moses, that the skin of Moses’ face shone, Moses would put the veil on his face again, until he went in to speak with the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses assembled the whole community of the Israelites and said to them, “These are the things that the Lord has commanded you to do. ");
INSERT INTO engnet_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","In six days work may be done, but on the seventh day there must be a holy day for you, a Sabbath of complete rest to the Lord. Anyone who does work on it will be put to death. ");
INSERT INTO engnet_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","You must not kindle a fire in any of your homes on the Sabbath day.” ");
INSERT INTO engnet_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses spoke to the whole community of the Israelites, “This is the word that the Lord has commanded: ");
INSERT INTO engnet_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Take an offering for the Lord. Let everyone who has a willing heart bring an offering to the Lord: gold, silver, bronze, ");
INSERT INTO engnet_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, and scarlet yarn, fine linen, goat’s hair, ");
INSERT INTO engnet_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ram skins dyed red, fine leather, acacia wood, ");
INSERT INTO engnet_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olive oil for the light, spices for the anointing oil and for the fragrant incense, ");
INSERT INTO engnet_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onyx stones, and other gems for mounting on the ephod and the breastpiece. ");
INSERT INTO engnet_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Every skilled person among you is to come and make all that the Lord has commanded: ");
INSERT INTO engnet_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the tabernacle with its tent, its covering, its clasps, its frames, its crossbars, its posts, and its bases; ");
INSERT INTO engnet_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the ark, with its poles, the atonement lid, and the special curtain that conceals it; ");
INSERT INTO engnet_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table with its poles and all its vessels, and the Bread of the Presence; ");
INSERT INTO engnet_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand for the light and its accessories, its lamps, and oil for the light; ");
INSERT INTO engnet_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","and the altar of incense with its poles, the anointing oil, and the fragrant incense; the hanging for the door at the entrance of the tabernacle; ");
INSERT INTO engnet_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar for the burnt offering with its bronze grating that is on it, its poles, and all its utensils; the large basin and its pedestal; ");
INSERT INTO engnet_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the hangings of the courtyard, its posts and its bases, and the curtain for the gateway to the courtyard; ");
INSERT INTO engnet_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tent pegs for the tabernacle and tent pegs for the courtyard and their ropes; ");
INSERT INTO engnet_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","the woven garments for serving in the holy place, the holy garments for Aaron the priest, and the garments for his sons to minister as priests.” ");
INSERT INTO engnet_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","So the whole community of the Israelites went out from the presence of Moses. ");
INSERT INTO engnet_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Everyone whose heart stirred him to action and everyone whose spirit was willing came and brought the offering for the Lord for the work of the tent of meeting, for all its service, and for the holy garments. ");
INSERT INTO engnet_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","They came, men and women alike, all who had willing hearts. They brought brooches, earrings, rings and ornaments, all kinds of gold jewelry, and everyone came who waved a wave offering of gold to the Lord. ");
INSERT INTO engnet_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone who had blue, purple, or scarlet yarn, fine linen, goats’ hair, ram skins dyed red, or fine leather brought them. ");
INSERT INTO engnet_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone making an offering of silver or bronze brought it as an offering to the Lord, and everyone who had acacia wood for any work of the service brought it. ");
INSERT INTO engnet_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Every woman who was skilled spun with her hands and brought what she had spun, blue, purple, or scarlet yarn, or fine linen, ");
INSERT INTO engnet_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","and all the women whose heart stirred them to action and who were skilled spun goats’ hair. ");
INSERT INTO engnet_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The leaders brought onyx stones and other gems to be mounted for the ephod and the breastpiece, ");
INSERT INTO engnet_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","and spices and olive oil for the light, for the anointing oil, and for the fragrant incense. ");
INSERT INTO engnet_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","The Israelites brought a freewill offering to the Lord, every man and woman whose heart was willing to bring materials for all the work that the Lord through Moses had commanded them to do. ");
INSERT INTO engnet_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moses said to the Israelites, “See, the Lord has chosen Bezalel son of Uri, the son of Hur, of the tribe of Judah. ");
INSERT INTO engnet_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","He has filled him with the Spirit of God – with skill, with understanding, with knowledge, and in all kinds of work, ");
INSERT INTO engnet_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","to design artistic designs, to work in gold, in silver, and in bronze, ");
INSERT INTO engnet_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","and in cutting stones for their setting, and in cutting wood, to do work in every artistic craft. ");
INSERT INTO engnet_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","And he has put it in his heart to teach, he and Oholiab son of Ahisamach, of the tribe of Dan. ");
INSERT INTO engnet_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has filled them with skill to do all kinds of work as craftsmen, as designers, as embroiderers in blue, purple, and scarlet yarn and in fine linen, and as weavers. They are craftsmen in all the work and artistic designers. ");
INSERT INTO engnet_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","So Bezalel and Oholiab and every skilled person in whom the Lord has put skill and ability to know how to do all the work for the service of the sanctuary are to do the work according to all that the Lord has commanded.” ");
INSERT INTO engnet_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses summoned Bezalel and Oholiab and every skilled person in whom the Lord had put skill – everyone whose heart stirred him to volunteer to do the work, ");
INSERT INTO engnet_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","and they received from Moses all the offerings the Israelites had brought to do the work for the service of the sanctuary, and they still continued to bring him a freewill offering each morning. ");
INSERT INTO engnet_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","So all the skilled people who were doing all the work on the sanctuary came from the work they were doing ");
INSERT INTO engnet_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","and told Moses, “The people are bringing much more than is needed for the completion of the work which the Lord commanded us to do!” ");
INSERT INTO engnet_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moses instructed them to take his message throughout the camp, saying, “Let no man or woman do any more work for the offering for the sanctuary.” So the people were restrained from bringing any more. ");
INSERT INTO engnet_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Now the materials were more than enough for them to do all the work. ");
INSERT INTO engnet_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","All the skilled among those who were doing the work made the tabernacle with ten curtains of fine twisted linen and blue and purple and scarlet; they were made with cherubim that were the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","The length of one curtain was forty-two feet, and the width of one curtain was six feet – the same size for each of the curtains. ");
INSERT INTO engnet_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","He joined five of the curtains to one another, and the other five curtains he joined to one another. ");
INSERT INTO engnet_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","He made loops of blue material along the edge of the end curtain in the first set; he did the same along the edge of the end curtain in the second set. ");
INSERT INTO engnet_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","He made fifty loops on the first curtain, and he made fifty loops on the end curtain that was in the second set, with the loops opposite one another. ");
INSERT INTO engnet_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","He made fifty gold clasps and joined the curtains together to one another with the clasps, so that the tabernacle was a unit. ");
INSERT INTO engnet_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","He made curtains of goats’ hair for a tent over the tabernacle; he made eleven curtains. ");
INSERT INTO engnet_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","The length of one curtain was forty-five feet, and the width of one curtain was six feet – one size for all eleven curtains. ");
INSERT INTO engnet_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","He joined five curtains by themselves and six curtains by themselves. ");
INSERT INTO engnet_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","He made fifty loops along the edge of the end curtain in the first set and fifty loops along the edge of the curtain that joined the second set. ");
INSERT INTO engnet_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","He made fifty bronze clasps to join the tent together so that it might be a unit. ");
INSERT INTO engnet_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","He made a covering for the tent out of ram skins dyed red and over that a covering of fine leather. ");
INSERT INTO engnet_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","He made the frames for the tabernacle of acacia wood as uprights. ");
INSERT INTO engnet_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","The length of each frame was fifteen feet, the width of each frame was two and a quarter feet, ");
INSERT INTO engnet_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","with two projections per frame parallel one to another. He made all the frames of the tabernacle in this way. ");
INSERT INTO engnet_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","So he made frames for the tabernacle: twenty frames for the south side. ");
INSERT INTO engnet_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","He made forty silver bases under the twenty frames – two bases under the first frame for its two projections, and likewise two bases under the next frame for its two projections, ");
INSERT INTO engnet_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","and for the second side of the tabernacle, the north side, he made twenty frames ");
INSERT INTO engnet_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and their forty silver bases, two bases under the first frame and two bases under the next frame. ");
INSERT INTO engnet_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","And for the back of the tabernacle on the west he made six frames. ");
INSERT INTO engnet_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","He made two frames for the corners of the tabernacle on the back. ");
INSERT INTO engnet_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","At the two corners they were doubled at the lower end and finished together at the top in one ring. So he did for both. ");
INSERT INTO engnet_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","So there were eight frames and their silver bases, sixteen bases, two bases under each frame. ");
INSERT INTO engnet_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","He made bars of acacia wood, five for the frames on one side of the tabernacle ");
INSERT INTO engnet_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","and five bars for the frames on the second side of the tabernacle, and five bars for the frames of the tabernacle for the back side on the west. ");
INSERT INTO engnet_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","He made the middle bar to reach from end to end in the center of the frames. ");
INSERT INTO engnet_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","He overlaid the frames with gold and made their rings of gold to provide places for the bars, and he overlaid the bars with gold. ");
INSERT INTO engnet_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","He made the special curtain of blue, purple, and scarlet yarn and fine twisted linen; he made it with cherubim, the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","He made for it four posts of acacia wood and overlaid them with gold, with gold hooks, and he cast for them four silver bases. ");
INSERT INTO engnet_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","He made a hanging for the entrance of the tent of blue, purple, and scarlet yarn and fine twisted linen, the work of an embroiderer, ");
INSERT INTO engnet_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","and its five posts and their hooks. He overlaid their tops and their bands with gold, but their five bases were bronze. ");
INSERT INTO engnet_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel made the ark of acacia wood; its length was three feet nine inches, its width two feet three inches, and its height two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He overlaid it with pure gold, inside and out, and he made a surrounding border of gold for it. ");
INSERT INTO engnet_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He cast four gold rings for it that he put on its four feet, with two rings on one side and two rings on the other side. ");
INSERT INTO engnet_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","He made poles of acacia wood, overlaid them with gold, ");
INSERT INTO engnet_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","and put the poles into the rings on the sides of the ark in order to carry the ark. ");
INSERT INTO engnet_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He made an atonement lid of pure gold; its length was three feet nine inches, and its width was two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","He made two cherubim of gold; he made them of hammered metal on the two ends of the atonement lid, ");
INSERT INTO engnet_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","one cherub on one end and one cherub on the other end. He made the cherubim from the atonement lid on its two ends. ");
INSERT INTO engnet_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","The cherubim were spreading their wings upward, overshadowing the atonement lid with their wings. The cherubim faced each other, looking toward the atonement lid. ");
INSERT INTO engnet_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","He made the table of acacia wood; its length was three feet, its width one foot six inches, and its height two feet three inches. ");
INSERT INTO engnet_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He overlaid it with pure gold, and he made a surrounding border of gold for it. ");
INSERT INTO engnet_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","He made a surrounding frame for it about three inches wide, and he made a surrounding border of gold for its frame. ");
INSERT INTO engnet_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He cast four gold rings for it and attached the rings at the four corners where its four legs were. ");
INSERT INTO engnet_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were close to the frame to provide places for the poles to carry the table. ");
INSERT INTO engnet_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made the poles of acacia wood and overlaid them with gold, to carry the table. ");
INSERT INTO engnet_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He made the vessels which were on the table out of pure gold, its plates, its ladles, its pitchers, and its bowls, to be used in pouring out offerings. ");
INSERT INTO engnet_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","He made the lampstand of pure gold. He made the lampstand of hammered metal; its base and its shaft, its cups, its buds, and its blossoms were from the same piece. ");
INSERT INTO engnet_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches were extending from its sides, three branches of the lampstand from one side of it, and three branches of the lampstand from the other side of it. ");
INSERT INTO engnet_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Three cups shaped like almond flowers with buds and blossoms were on the first branch, and three cups shaped like almond flowers with buds and blossoms were on the next branch, and the same for the six branches that were extending from the lampstand. ");
INSERT INTO engnet_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","On the lampstand there were four cups shaped like almond flowers with buds and blossoms, ");
INSERT INTO engnet_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","with a bud under the first two branches from it, and a bud under the next two branches from it, and a bud under the third two branches from it; according to the six branches that extended from it. ");
INSERT INTO engnet_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Their buds and their branches were of one piece; all of it was one hammered piece of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","He made its seven lamps, its trimmers, and its trays of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He made the lampstand and all its accessories with seventy-five pounds of pure gold. ");
INSERT INTO engnet_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","He made the incense altar of acacia wood. Its length was a foot and a half and its width a foot and a half – a square – and its height was three feet. Its horns were of one piece with it. ");
INSERT INTO engnet_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He overlaid it with pure gold – its top, its four walls, and its horns – and he made a surrounding border of gold for it. ");
INSERT INTO engnet_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He also made two gold rings for it under its border, on its two sides, on opposite sides, as places for poles to carry it with. ");
INSERT INTO engnet_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made the poles of acacia wood and overlaid them with gold. ");
INSERT INTO engnet_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He made the sacred anointing oil and the pure fragrant incense, the work of a perfumer. ");
INSERT INTO engnet_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","He made the altar for the burnt offering of acacia wood seven feet six inches long and seven feet six inches wide – it was square – and its height was four feet six inches. ");
INSERT INTO engnet_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made its horns on its four corners; its horns were part of it, and he overlaid it with bronze. ");
INSERT INTO engnet_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He made all the utensils of the altar – the pots, the shovels, the tossing bowls, the meat hooks, and the fire pans – he made all its utensils of bronze. ");
INSERT INTO engnet_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","He made a grating for the altar, a network of bronze under its ledge, halfway up from the bottom. ");
INSERT INTO engnet_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","He cast four rings for the four corners of the bronze grating, to provide places for the poles. ");
INSERT INTO engnet_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","He made the poles of acacia wood and overlaid them with bronze. ");
INSERT INTO engnet_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the poles into the rings on the sides of the altar, with which to carry it. He made the altar hollow, out of boards. ");
INSERT INTO engnet_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","He made the large basin of bronze and its pedestal of bronze from the mirrors of the women who served at the entrance of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","He made the courtyard. For the south side the hangings of the courtyard were of fine twisted linen, one hundred fifty feet long, ");
INSERT INTO engnet_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","with their twenty posts and their twenty bronze bases, with the hooks of the posts and their bands of silver. ");
INSERT INTO engnet_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","For the north side the hangings were one hundred fifty feet, with their twenty posts and their twenty bronze bases, with the hooks of the posts and their bands of silver. ");
INSERT INTO engnet_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","For the west side there were hangings seventy-five feet long, with their ten posts and their ten bases, with the hooks of the posts and their bands of silver. ");
INSERT INTO engnet_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","For the east side, toward the sunrise, it was seventy-five feet wide, ");
INSERT INTO engnet_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","with hangings on one side of the gate that were twenty-two and a half feet long, with their three posts and their three bases, ");
INSERT INTO engnet_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","and for the second side of the gate of the courtyard, just like the other, the hangings were twenty-two and a half feet long, with their three posts and their three bases. ");
INSERT INTO engnet_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the hangings around the courtyard were of fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The bases for the posts were bronze. The hooks of the posts and their bands were silver, their tops were overlaid with silver, and all the posts of the courtyard had silver bands. ");
INSERT INTO engnet_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The curtain for the gate of the courtyard was of blue, purple, and scarlet yarn and fine twisted linen, the work of an embroiderer. It was thirty feet long, and like the hangings in the courtyard, it was seven and a half feet high, ");
INSERT INTO engnet_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","with four posts and their four bronze bases. Their hooks and their bands were silver, and their tops were overlaid with silver. ");
INSERT INTO engnet_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs of the tabernacle and of the courtyard all around were bronze. ");
INSERT INTO engnet_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","This is the inventory of the tabernacle, the tabernacle of the testimony, which was counted by the order of Moses, being the work of the Levites under the direction of Ithamar, son of Aaron the priest. ");
INSERT INTO engnet_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Now Bezalel son of Uri, the son of Hur, of the tribe of Judah, made everything that the Lord had commanded Moses; ");
INSERT INTO engnet_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","and with him was Oholiab son of Ahisamach, of the tribe of Dan, an artisan, a designer, and an embroiderer in blue, purple, and scarlet yarn and fine linen. ");
INSERT INTO engnet_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold that was used for the work, in all the work of the sanctuary (namely, the gold of the wave offering) was twenty-nine talents and 730 shekels, according to the sanctuary shekel. ");
INSERT INTO engnet_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","The silver of those who were numbered of the community was one hundred talents and 1,775 shekels, according to the sanctuary shekel, ");
INSERT INTO engnet_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","one beka per person, that is, a half shekel, according to the sanctuary shekel, for everyone who crossed over to those numbered, from twenty years old or older, 603,550 in all. ");
INSERT INTO engnet_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","The one hundred talents of silver were used for casting the bases of the sanctuary and the bases of the special curtain – one hundred bases for one hundred talents, one talent per base. ");
INSERT INTO engnet_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","From the remaining 1,775 shekels he made hooks for the posts, overlaid their tops, and made bands for them. ");
INSERT INTO engnet_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The bronze of the wave offering was seventy talents and 2,400 shekels. ");
INSERT INTO engnet_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","With it he made the bases for the door of the tent of meeting, the bronze altar, the bronze grating for it, and all the utensils of the altar, ");
INSERT INTO engnet_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the bases for the courtyard all around, the bases for the gate of the courtyard, all the tent pegs of the tabernacle, and all the tent pegs of the courtyard all around. ");
INSERT INTO engnet_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","From the blue, purple, and scarlet yarn they made woven garments for serving in the sanctuary; they made holy garments that were for Aaron, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","He made the ephod of gold, blue, purple, scarlet, and fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They hammered the gold into thin sheets and cut it into narrow strips to weave them into the blue, purple, and scarlet yarn, and into the fine linen, the work of an artistic designer. ");
INSERT INTO engnet_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made shoulder pieces for it, attached to two of its corners, so it could be joined together. ");
INSERT INTO engnet_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","The artistically woven waistband of the ephod that was on it was like it, of one piece with it, of gold, blue, purple, and scarlet yarn and fine twisted linen, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They set the onyx stones in gold filigree settings, engraved as with the engravings of a seal with the names of the sons of Israel. ");
INSERT INTO engnet_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","He put them on the shoulder pieces of the ephod as stones of memorial for the Israelites, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","He made the breastpiece, the work of an artistic designer, in the same fashion as the ephod, of gold, blue, purple, and scarlet, and fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square – they made the breastpiece doubled, nine inches long and nine inches wide when doubled. ");
INSERT INTO engnet_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They set on it four rows of stones: a row with a ruby, a topaz, and a beryl – the first row; ");
INSERT INTO engnet_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","and the second row, a turquoise, a sapphire, and an emerald; ");
INSERT INTO engnet_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","and the third row, a jacinth, an agate, and an amethyst; ");
INSERT INTO engnet_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","and the fourth row, a chrysolite, an onyx, and a jasper. They were enclosed in gold filigree settings. ");
INSERT INTO engnet_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","The stones were for the names of the sons of Israel, twelve, corresponding to the number of their names. Each name corresponding to one of the twelve tribes was like the engravings of a seal. ");
INSERT INTO engnet_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","They made for the breastpiece braided chains like cords of pure gold, ");
INSERT INTO engnet_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","and they made two gold filigree settings and two gold rings, and they attached the two rings to the upper two ends of the breastpiece. ");
INSERT INTO engnet_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They attached the two gold chains to the two rings at the ends of the breastpiece; ");
INSERT INTO engnet_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","the other two ends of the two chains they attached to the two settings, and they attached them to the shoulder pieces of the ephod at the front of it. ");
INSERT INTO engnet_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","They made two rings of gold and put them on the other two ends of the breastpiece on its edge, which is on the inner side of the ephod. ");
INSERT INTO engnet_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two more gold rings and attached them to the bottom of the two shoulder pieces on the front of the ephod, close to the juncture above the waistband of the ephod. ");
INSERT INTO engnet_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","They tied the breastpiece by its rings to the rings of the ephod by blue cord, so that it was above the waistband of the ephod, so that the breastpiece would not be loose from the ephod, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","He made the robe of the ephod completely blue, the work of a weaver. ");
INSERT INTO engnet_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","There was an opening in the center of the robe, like the opening of a collar, with an edge all around the opening so that it could not be torn. ");
INSERT INTO engnet_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","They made pomegranates of blue, purple, and scarlet yarn and twisted linen around the hem of the robe. ");
INSERT INTO engnet_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","They made bells of pure gold and attached the bells between the pomegranates around the hem of the robe between the pomegranates. ");
INSERT INTO engnet_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","There was a bell and a pomegranate, a bell and a pomegranate, all around the hem of the robe, to be used in ministering, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","They made tunics of fine linen – the work of a weaver, for Aaron and for his sons – ");
INSERT INTO engnet_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","and the turban of fine linen, the headbands of fine linen, and the undergarments of fine twisted linen. ");
INSERT INTO engnet_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","The sash was of fine twisted linen and blue, purple, and scarlet yarn, the work of an embroiderer, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They made a plate, the holy diadem, of pure gold and wrote on it an inscription, as on the engravings of a seal, “Holiness to the Lord.” ");
INSERT INTO engnet_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They attached to it a blue cord, to attach it to the turban above, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So all the work of the tabernacle, the tent of meeting, was completed, and the Israelites did according to all that the Lord had commanded Moses – they did it exactly so. ");
INSERT INTO engnet_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","They brought the tabernacle to Moses, the tent and all its furnishings, clasps, frames, bars, posts, and bases; ");
INSERT INTO engnet_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","and the coverings of ram skins dyed red, the covering of fine leather, and the protecting curtain; ");
INSERT INTO engnet_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the ark of the testimony and its poles, and the atonement lid; ");
INSERT INTO engnet_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table, all its utensils, and the Bread of the Presence; ");
INSERT INTO engnet_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the pure lampstand, its lamps, with the lamps set in order, and all its accessories, and oil for the light; ");
INSERT INTO engnet_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","and the gold altar, and the anointing oil, and the fragrant incense; and the curtain for the entrance to the tent; ");
INSERT INTO engnet_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar and its bronze grating, its poles, and all its utensils; the large basin with its pedestal; ");
INSERT INTO engnet_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the hangings of the courtyard, its posts and its bases, and the curtain for the gateway of the courtyard, its ropes and its tent pegs, and all the furnishings for the service of the tabernacle, for the tent of meeting; ");
INSERT INTO engnet_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","the woven garments for serving in the sanctuary, the holy garments for Aaron the priest, and the garments for his sons to minister as priests. ");
INSERT INTO engnet_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The Israelites did all the work according to all that the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses inspected all the work – and they had done it just as the Lord had commanded – they had done it exactly – and Moses blessed them. ");
INSERT INTO engnet_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month you are to set up the tabernacle, the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","You are to place the ark of the testimony in it and shield the ark with the special curtain. ");
INSERT INTO engnet_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","You are to bring in the table and set out the things that belong on it; then you are to bring in the lampstand and set up its lamps. ");
INSERT INTO engnet_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","You are to put the gold altar for incense in front of the ark of the testimony and put the curtain at the entrance to the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","You are to put the altar for the burnt offering in front of the entrance to the tabernacle, the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","You are to put the large basin between the tent of meeting and the altar and put water in it. ");
INSERT INTO engnet_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","You are to set up the courtyard around it and put the curtain at the gate of the courtyard. ");
INSERT INTO engnet_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","And take the anointing oil, and anoint the tabernacle and all that is in it, and sanctify it and all its furnishings, and it will be holy. ");
INSERT INTO engnet_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Then you are to anoint the altar for the burnt offering with all its utensils; you are to sanctify the altar, and it will be the most holy altar. ");
INSERT INTO engnet_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","You must also anoint the large basin and its pedestal, and you are to sanctify it. ");
INSERT INTO engnet_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“You are to bring Aaron and his sons to the entrance of the tent of meeting and wash them with water. ");
INSERT INTO engnet_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Then you are to clothe Aaron with the holy garments and anoint him and sanctify him so that he may minister as my priest. ");
INSERT INTO engnet_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","You are to bring his sons and clothe them with tunics ");
INSERT INTO engnet_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","and anoint them just as you anointed their father, so that they may minister as my priests; their anointing will make them a priesthood that will continue throughout their generations.” ");
INSERT INTO engnet_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","This is what Moses did, according to all the Lord had commanded him – so he did. ");
INSERT INTO engnet_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","So the tabernacle was set up on the first day of the first month, in the second year. ");
INSERT INTO engnet_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","When Moses set up the tabernacle and put its bases in place, he set up its frames, attached its bars, and set up its posts. ");
INSERT INTO engnet_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Then he spread the tent over the tabernacle and put the covering of the tent over it, as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","He took the testimony and put it in the ark, attached the poles to the ark, and then put the atonement lid on the ark. ");
INSERT INTO engnet_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","And he brought the ark into the tabernacle, hung the protecting curtain, and shielded the ark of the testimony from view, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","And he put the table in the tent of meeting, on the north side of the tabernacle, outside the curtain. ");
INSERT INTO engnet_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","And he set the bread in order on it before the Lord, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","And he put the lampstand in the tent of meeting opposite the table, on the south side of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Then he set up the lamps before the Lord, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","And he put the gold altar in the tent of meeting in front of the curtain, ");
INSERT INTO engnet_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and he burned fragrant incense on it, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Then he put the curtain at the entrance to the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","He also put the altar for the burnt offering by the entrance to the tabernacle, the tent of meeting, and offered on it the burnt offering and the meal offering, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Then he put the large basin between the tent of meeting and the altar and put water in it for washing. ");
INSERT INTO engnet_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses and Aaron and his sons would wash their hands and their feet from it. ");
INSERT INTO engnet_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Whenever they entered the tent of meeting, and whenever they approached the altar, they would wash, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And he set up the courtyard around the tabernacle and the altar, and put the curtain at the gate of the courtyard. So Moses finished the work. ");
INSERT INTO engnet_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the tent of meeting, and the glory of the Lord filled the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses was not able to enter the tent of meeting because the cloud settled on it and the glory of the Lord filled the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","But when the cloud was lifted up from the tabernacle, the Israelites would set out on all their journeys; ");
INSERT INTO engnet_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","but if the cloud was not lifted up, then they would not journey further until the day it was lifted up. ");
INSERT INTO engnet_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the cloud of the Lord was on the tabernacle by day, but fire would be on it at night, in plain view of all the house of Israel, throughout all their journeys. ");
INSERT INTO engnet_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Then the Lord called to Moses and spoke to him from the Meeting Tent: ");
INSERT INTO engnet_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Speak to the Israelites and tell them, ‘When someone among you presents an offering to the Lord, you must present your offering from the domesticated animals, either from the herd or from the flock. ");
INSERT INTO engnet_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘If his offering is a burnt offering from the herd he must present it as a flawless male; he must present it at the entrance of the Meeting Tent for its acceptance before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","He must lay his hand on the head of the burnt offering, and it will be accepted for him to make atonement on his behalf. ");
INSERT INTO engnet_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Then the one presenting the offering must slaughter the bull before the Lord, and the sons of Aaron, the priests, must present the blood and splash the blood against the sides of the altar which is at the entrance of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Next, the one presenting the offering must skin the burnt offering and cut it into parts, ");
INSERT INTO engnet_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","and the sons of Aaron, the priest, must put fire on the altar and arrange wood on the fire. ");
INSERT INTO engnet_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Then the sons of Aaron, the priests, must arrange the parts with the head and the suet on the wood that is in the fire on the altar. ");
INSERT INTO engnet_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Finally, the one presenting the offering must wash its entrails and its legs in water and the priest must offer all of it up in smoke on the altar – it is a burnt offering, a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘If his offering is from the flock for a burnt offering – from the sheep or the goats – he must present a flawless male, ");
INSERT INTO engnet_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","and must slaughter it on the north side of the altar before the Lord, and the sons of Aaron, the priests, will splash its blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Next, the one presenting the offering must cut it into parts, with its head and its suet, and the priest must arrange them on the wood which is in the fire, on the altar. ");
INSERT INTO engnet_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Then the one presenting the offering must wash the entrails and the legs in water, and the priest must present all of it and offer it up in smoke on the altar – it is a burnt offering, a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘If his offering to the Lord is a burnt offering from the birds, he must present his offering from the turtledoves or from the young pigeons. ");
INSERT INTO engnet_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest must present it at the altar, pinch off its head and offer the head up in smoke on the altar, and its blood must be drained out against the side of the altar. ");
INSERT INTO engnet_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Then the priest must remove its entrails by cutting off its tail feathers, and throw them to the east side of the altar into the place of fatty ashes, ");
INSERT INTO engnet_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","and tear it open by its wings without dividing it into two parts. Finally, the priest must offer it up in smoke on the altar on the wood which is in the fire – it is a burnt offering, a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘When a person presents a grain offering to the Lord, his offering must consist of choice wheat flour, and he must pour olive oil on it and put frankincense on it. ");
INSERT INTO engnet_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Then he must bring it to the sons of Aaron, the priests, and the priest must scoop out from there a handful of its choice wheat flour and some of its olive oil in addition to all of its frankincense, and the priest must offer its memorial portion up in smoke on the altar – it is a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","The remainder of the grain offering belongs to Aaron and to his sons – it is most holy from the gifts of the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘When you present an offering of grain baked in an oven, it must be made of choice wheat flour baked into unleavened loaves mixed with olive oil or unleavened wafers smeared with olive oil. ");
INSERT INTO engnet_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your offering is a grain offering made on the griddle, it must be choice wheat flour mixed with olive oil, unleavened. ");
INSERT INTO engnet_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Crumble it in pieces and pour olive oil on it – it is a grain offering. ");
INSERT INTO engnet_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your offering is a grain offering made in a pan, it must be made of choice wheat flour deep fried in olive oil. ");
INSERT INTO engnet_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“‘You must bring the grain offering that must be made from these to the Lord. Present it to the priest, and he will bring it to the altar. ");
INSERT INTO engnet_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Then the priest must take up from the grain offering its memorial portion and offer it up in smoke on the altar – it is a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","The remainder of the grain offering belongs to Aaron and to his sons – it is most holy from the gifts of the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘No grain offering which you present to the Lord can be made with yeast, for you must not offer up in smoke any yeast or honey as a gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You can present them to the Lord as an offering of first fruit, but they must not go up to the altar for a soothing aroma. ");
INSERT INTO engnet_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Moreover, you must season every one of your grain offerings with salt; you must not allow the salt of the covenant of your God to be missing from your grain offering – on every one of your grain offerings you must present salt. ");
INSERT INTO engnet_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘If you present a grain offering of first ripe grain to the Lord, you must present your grain offering of first ripe grain as soft kernels roasted in fire – crushed bits of fresh grain. ");
INSERT INTO engnet_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","And you must put olive oil on it and set frankincense on it – it is a grain offering. ");
INSERT INTO engnet_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Then the priest must offer its memorial portion up in smoke – some of its crushed bits, some of its olive oil, in addition to all of its frankincense – it is a gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘Now if his offering is a peace offering sacrifice, if he presents an offering from the herd, he must present before the Lord a flawless male or a female. ");
INSERT INTO engnet_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","He must lay his hand on the head of his offering and slaughter it at the entrance of the Meeting Tent, and the sons of Aaron, the priests, must splash the blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Then the one presenting the offering must present a gift to the Lord from the peace offering sacrifice: He must remove the fat that covers the entrails and all the fat that surrounds the entrails, ");
INSERT INTO engnet_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","the two kidneys with the fat on their sinews, and the protruding lobe on the liver (which he is to remove along with the kidneys). ");
INSERT INTO engnet_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Then the sons of Aaron must offer it up in smoke on the altar atop the burnt offering that is on the wood in the fire as a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘If his offering for a peace offering sacrifice to the Lord is from the flock, he must present a flawless male or female. ");
INSERT INTO engnet_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If he presents a sheep as his offering, he must present it before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","He must lay his hand on the head of his offering and slaughter it before the Meeting Tent, and the sons of Aaron must splash its blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Then he must present a gift to the Lord from the peace offering sacrifice: He must remove all the fatty tail up to the end of the spine, the fat covering the entrails, and all the fat on the entrails, ");
INSERT INTO engnet_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","the two kidneys with the fat on their sinews, and the protruding lobe on the liver (which he is to remove along with the kidneys). ");
INSERT INTO engnet_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Then the priest must offer it up in smoke on the altar as a food gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘If his offering is a goat he must present it before the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","lay his hand on its head, and slaughter it before the Meeting Tent, and the sons of Aaron must splash its blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Then he must present from it his offering as a gift to the Lord: the fat which covers the entrails and all the fat on the entrails, ");
INSERT INTO engnet_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","the two kidneys with the fat on their sinews, and the protruding lobe on the liver (which he is to remove along with the kidneys). ");
INSERT INTO engnet_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Then the priest must offer them up in smoke on the altar as a food gift for a soothing aroma – all the fat belongs to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","This is a perpetual statute throughout your generations in all the places where you live: You must never eat any fat or any blood.’” ");
INSERT INTO engnet_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tell the Israelites, ‘When a person sins by straying unintentionally from any of the Lord’s commandments which must not be violated, and violates any one of them – ");
INSERT INTO engnet_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“‘If the high priest sins so that the people are guilty, on account of the sin he has committed he must present a flawless young bull to the Lord for a sin offering. ");
INSERT INTO engnet_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He must bring the bull to the entrance of the Meeting Tent before the Lord, lay his hand on the head of the bull, and slaughter the bull before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Then that high priest must take some of the blood of the bull and bring it to the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","The priest must dip his finger in the blood and sprinkle some of it seven times before the Lord toward the front of the veil-canopy of the sanctuary. ");
INSERT INTO engnet_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","The priest must put some of the blood on the horns of the altar of fragrant incense that is before the Lord in the Meeting Tent, and all the rest of the bull’s blood he must pour out at the base of the altar of burnt offering that is at the entrance of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","“‘Then he must take up all the fat from the sin offering bull: the fat covering the entrails and all the fat surrounding the entrails, ");
INSERT INTO engnet_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","the two kidneys with the fat on their sinews, and the protruding lobe on the liver (which he is to remove along with the kidneys) ");
INSERT INTO engnet_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","– just as it is taken from the ox of the peace offering sacrifice – and the priest must offer them up in smoke on the altar of burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","But the hide of the bull, all its flesh along with its head and its legs, its entrails, and its dung – ");
INSERT INTO engnet_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","all the rest of the bull – he must bring outside the camp to a ceremonially clean place, to the fatty ash pile, and he must burn it on a wood fire; it must be burned on the fatty ash pile. ");
INSERT INTO engnet_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘If the whole congregation of Israel strays unintentionally and the matter is not noticed by the assembly, and they violate one of the Lord’s commandments, which must not be violated, so they become guilty, ");
INSERT INTO engnet_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","the assembly must present a young bull for a sin offering when the sin they have committed becomes known. They must bring it before the Meeting Tent, ");
INSERT INTO engnet_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","the elders of the congregation must lay their hands on the head of the bull before the Lord, and someone must slaughter the bull before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Then the high priest must bring some of the blood of the bull to the Meeting Tent, ");
INSERT INTO engnet_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","and that priest must dip his finger in the blood and sprinkle some of the blood seven times before the Lord toward the front of the veil-canopy. ");
INSERT INTO engnet_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He must put some of the blood on the horns of the altar which is before the Lord in the Meeting Tent, and all the rest of the blood he must pour out at the base of the altar of burnt offering that is at the entrance of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","“‘Then the priest must take all its fat and offer the fat up in smoke on the altar. ");
INSERT INTO engnet_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He must do with the rest of the bull just as he did with the bull of the sin offering; this is what he must do with it. So the priest will make atonement on their behalf and they will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","He must bring the rest of the bull outside the camp and burn it just as he burned the first bull – it is the sin offering of the assembly. ");
INSERT INTO engnet_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘Whenever a leader, by straying unintentionally, sins and violates one of the commandments of the Lord his God which must not be violated, and he pleads guilty, ");
INSERT INTO engnet_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","or his sin that he committed is made known to him, he must bring a flawless male goat as his offering. ");
INSERT INTO engnet_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He must lay his hand on the head of the male goat and slaughter it in the place where the burnt offering is slaughtered before the Lord – it is a sin offering. ");
INSERT INTO engnet_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Then the priest must take some of the blood of the sin offering with his finger and put it on the horns of the altar of burnt offering, and he must pour out the rest of its blood at the base of the altar of burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Then the priest must offer all of its fat up in smoke on the altar like the fat of the peace offering sacrifice. So the priest will make atonement on his behalf for his sin and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘If an ordinary individual sins by straying unintentionally when he violates one of the Lord’s commandments which must not be violated, and he pleads guilty ");
INSERT INTO engnet_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","or his sin that he committed is made known to him, he must bring a flawless female goat as his offering for the sin that he committed. ");
INSERT INTO engnet_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He must lay his hand on the head of the sin offering and slaughter the sin offering in the place where the burnt offering is slaughtered. ");
INSERT INTO engnet_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Then the priest must take some of its blood with his finger and put it on the horns of the altar of burnt offering, and he must pour out all the rest of its blood at the base of the altar. ");
INSERT INTO engnet_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Then he must remove all of its fat (just as fat was removed from the peace offering sacrifice) and the priest must offer it up in smoke on the altar for a soothing aroma to the Lord. So the priest will make atonement on his behalf and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘But if he brings a sheep as his offering, for a sin offering, he must bring a flawless female. ");
INSERT INTO engnet_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He must lay his hand on the head of the sin offering and slaughter it for a sin offering in the place where the burnt offering is slaughtered. ");
INSERT INTO engnet_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Then the priest must take some of the blood of the sin offering with his finger and put it on the horns of the altar of burnt offering, and he must pour out all the rest of its blood at the base of the altar. ");
INSERT INTO engnet_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Then the one who brought the offering must remove all its fat (just as the fat of the sheep is removed from the peace offering sacrifice) and the priest must offer them up in smoke on the altar on top of the other gifts of the Lord. So the priest will make atonement on his behalf for his sin which he has committed and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘When a person sins in that he hears a public curse against one who fails to testify and he is a witness (he either saw or knew what had happened ) and he does not make it known, then he will bear his punishment for iniquity. ");
INSERT INTO engnet_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Or when there is a person who touches anything ceremonially unclean, whether the carcass of an unclean wild animal, or the carcass of an unclean domesticated animal, or the carcass of an unclean creeping thing, even if he did not realize it, but he himself has become unclean and is guilty; ");
INSERT INTO engnet_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","or when he touches human uncleanness with regard to anything by which he can become unclean, even if he did not realize it, but he himself has later come to know it and is guilty; ");
INSERT INTO engnet_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","or when a person swears an oath, speaking thoughtlessly with his lips, whether to do evil or to do good, with regard to anything which the individual might speak thoughtlessly in an oath, even if he did not realize it, but he himself has later come to know it and is guilty with regard to one of these oaths – ");
INSERT INTO engnet_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","when an individual becomes guilty with regard to one of these things he must confess how he has sinned, ");
INSERT INTO engnet_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","and he must bring his penalty for guilt to the Lord for his sin that he has committed, a female from the flock, whether a female sheep or a female goat, for a sin offering. So the priest will make atonement on his behalf for his sin. ");
INSERT INTO engnet_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘If he cannot afford an animal from the flock, he must bring his penalty for guilt for his sin that he has committed, two turtledoves or two young pigeons, to the Lord, one for a sin offering and one for a burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","He must bring them to the priest and present first the one that is for a sin offering. The priest must pinch its head at the nape of its neck, but must not sever the head from the body. ");
INSERT INTO engnet_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Then he must sprinkle some of the blood of the sin offering on the wall of the altar, and the remainder of the blood must be squeezed out at the base of the altar – it is a sin offering. ");
INSERT INTO engnet_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","The second bird he must make a burnt offering according to the standard regulation. So the priest will make atonement on behalf of this person for his sin which he has committed, and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘If he cannot afford two turtledoves or two young pigeons, he must bring as his offering for his sin which he has committed a tenth of an ephah of choice wheat flour for a sin offering. He must not place olive oil on it and he must not put frankincense on it, because it is a sin offering. ");
INSERT INTO engnet_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","He must bring it to the priest and the priest must scoop out from it a handful as its memorial portion and offer it up in smoke on the altar on top of the other gifts of the Lord – it is a sin offering. ");
INSERT INTO engnet_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","So the priest will make atonement on his behalf for his sin which he has committed by doing one of these things, and he will be forgiven. The remainder of the offering will belong to the priest like the grain offering.’” ");
INSERT INTO engnet_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“When a person commits a trespass and sins by straying unintentionally from the regulations about the Lord’s holy things, then he must bring his penalty for guilt to the Lord, a flawless ram from the flock, convertible into silver shekels according to the standard of the sanctuary shekel, for a guilt offering. ");
INSERT INTO engnet_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","And whatever holy thing he violated he must restore and must add one fifth to it and give it to the priest. So the priest will make atonement on his behalf with the guilt offering ram and he will be forgiven.” ");
INSERT INTO engnet_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“If a person sins and violates any of the Lord’s commandments which must not be violated (although he did not know it at the time, but later realizes he is guilty), then he will bear his punishment for iniquity ");
INSERT INTO engnet_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","and must bring a flawless ram from the flock, convertible into silver shekels, for a guilt offering to the priest. So the priest will make atonement on his behalf for his error which he committed (although he himself had not known it) and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a guilt offering; he was surely guilty before the Lord.” ");
INSERT INTO engnet_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“When a person sins and commits a trespass against the Lord by deceiving his fellow citizen in regard to something held in trust, or a pledge, or something stolen, or by extorting something from his fellow citizen, ");
INSERT INTO engnet_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","or has found something lost and denies it and swears falsely concerning any one of the things that someone might do to sin – ");
INSERT INTO engnet_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","when it happens that he sins and he is found guilty, then he must return whatever he had stolen, or whatever he had extorted, or the thing that he had held in trust, or the lost thing that he had found, ");
INSERT INTO engnet_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or anything about which he swears falsely. He must restore it in full and add one fifth to it; he must give it to its owner when he is found guilty. ");
INSERT INTO engnet_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Then he must bring his guilt offering to the Lord, a flawless ram from the flock, convertible into silver shekels, for a guilt offering to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","So the priest will make atonement on his behalf before the Lord and he will be forgiven for whatever he has done to become guilty.” ");
INSERT INTO engnet_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Command Aaron and his sons, ‘This is the law of the burnt offering. The burnt offering is to remain on the hearth on the altar all night until morning, and the fire of the altar must be kept burning on it. ");
INSERT INTO engnet_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Then the priest must put on his linen robe and must put linen leggings over his bare flesh, and he must take up the fatty ashes of the burnt offering that the fire consumed on the altar, and he must place them beside the altar. ");
INSERT INTO engnet_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then he must take off his clothes and put on other clothes, and he must bring the fatty ashes outside the camp to a ceremonially clean place, ");
INSERT INTO engnet_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","but the fire which is on the altar must be kept burning on it. It must not be extinguished. So the priest must kindle wood on it morning by morning, and he must arrange the burnt offering on it and offer the fat of the peace offering up in smoke on it. ");
INSERT INTO engnet_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","A continual fire must be kept burning on the altar. It must not be extinguished. ");
INSERT INTO engnet_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘This is the law of the grain offering. The sons of Aaron are to present it before the Lord in front of the altar, ");
INSERT INTO engnet_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","and the priest must take up with his hand some of the choice wheat flour of the grain offering and some of its olive oil, and all of the frankincense that is on the grain offering, and he must offer its memorial portion up in smoke on the altar as a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaron and his sons are to eat what is left over from it. It must be eaten unleavened in a holy place; they are to eat it in the courtyard of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It must not be baked with yeast. I have given it as their portion from my gifts. It is most holy, like the sin offering and the guilt offering. ");
INSERT INTO engnet_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Every male among the sons of Aaron may eat it. It is a perpetual allotted portion throughout your generations from the gifts of the Lord. Anyone who touches these gifts must be holy.’” ");
INSERT INTO engnet_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering of Aaron and his sons which they must present to the Lord on the day when he is anointed: a tenth of an ephah of choice wheat flour as a continual grain offering, half of it in the morning and half of it in the evening. ");
INSERT INTO engnet_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","It must be made with olive oil on a griddle and you must bring it well soaked, so you must present a grain offering of broken pieces as a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","The high priest who succeeds him from among his sons must do it. It is a perpetual statute; it must be offered up in smoke as a whole offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every grain offering of a priest must be a whole offering; it must not be eaten.” ");
INSERT INTO engnet_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tell Aaron and his sons, ‘This is the law of the sin offering. In the place where the burnt offering is slaughtered the sin offering must be slaughtered before the Lord. It is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers it for sin is to eat it. It must be eaten in a holy place, in the court of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Anyone who touches its meat must be holy, and whoever spatters some of its blood on a garment, you must wash whatever he spatters it on in a holy place. ");
INSERT INTO engnet_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Any clay vessel it is boiled in must be broken, and if it was boiled in a bronze vessel, then that vessel must be rubbed out and rinsed in water. ");
INSERT INTO engnet_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Any male among the priests may eat it. It is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But any sin offering from which some of its blood is brought into the Meeting Tent to make atonement in the sanctuary must not be eaten. It must be burned up in the fire. ");
INSERT INTO engnet_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘This is the law of the guilt offering. It is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","In the place where they slaughter the burnt offering they must slaughter the guilt offering, and the officiating priest must splash the blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Then the one making the offering must present all its fat: the fatty tail, the fat covering the entrails, ");
INSERT INTO engnet_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","the two kidneys and the fat on their sinews, and the protruding lobe on the liver (which he must remove along with the kidneys). ");
INSERT INTO engnet_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Then the priest must offer them up in smoke on the altar as a gift to the Lord. It is a guilt offering. ");
INSERT INTO engnet_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Any male among the priests may eat it. It must be eaten in a holy place. It is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","The law is the same for the sin offering and the guilt offering; it belongs to the priest who makes atonement with it. ");
INSERT INTO engnet_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","“‘As for the priest who presents someone’s burnt offering, the hide of that burnt offering which he presented belongs to him. ");
INSERT INTO engnet_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Every grain offering which is baked in the oven or made in the pan or on the griddle belongs to the priest who presented it. ");
INSERT INTO engnet_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Every grain offering, whether mixed with olive oil or dry, belongs to all the sons of Aaron, each one alike. ");
INSERT INTO engnet_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘This is the law of the peace offering sacrifice which he is to present to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If he presents it on account of thanksgiving, along with the thank offering sacrifice he must present unleavened loaves mixed with olive oil, unleavened wafers smeared with olive oil, and well soaked ring-shaped loaves made of choice wheat flour mixed with olive oil. ");
INSERT INTO engnet_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","He must present this grain offering in addition to ring-shaped loaves of leavened bread which regularly accompany the sacrifice of his thanksgiving peace offering. ");
INSERT INTO engnet_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","He must present one of each kind of grain offering as a contribution offering to the Lord; it belongs to the priest who splashes the blood of the peace offering. ");
INSERT INTO engnet_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The meat of his thanksgiving peace offering must be eaten on the day of his offering; he must not set any of it aside until morning. ");
INSERT INTO engnet_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘If his offering is a votive or freewill sacrifice, it may be eaten on the day he presents his sacrifice, and also the leftovers from it may be eaten on the next day, ");
INSERT INTO engnet_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","but the leftovers from the meat of the sacrifice must be burned up in the fire on the third day. ");
INSERT INTO engnet_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If some of the meat of his peace offering sacrifice is ever eaten on the third day it will not be accepted; it will not be accounted to the one who presented it, since it is spoiled, and the person who eats from it will bear his punishment for iniquity. ");
INSERT INTO engnet_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","The meat which touches anything ceremonially unclean must not be eaten; it must be burned up in the fire. As for ceremonially clean meat, everyone who is ceremonially clean may eat the meat. ");
INSERT INTO engnet_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","The person who eats meat from the peace offering sacrifice which belongs to the Lord while his uncleanness persists will be cut off from his people. ");
INSERT INTO engnet_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","When a person touches anything unclean (whether human uncleanness, or an unclean animal, or an unclean detestable creature) and eats some of the meat of the peace offering sacrifice which belongs to the Lord, that person will be cut off from his people.’” ");
INSERT INTO engnet_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Tell the Israelites, ‘You must not eat any fat of an ox, sheep, or goat. ");
INSERT INTO engnet_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Moreover, the fat of an animal that has died of natural causes and the fat of an animal torn by beasts may be used for any other purpose, but you must certainly never eat it. ");
INSERT INTO engnet_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","If anyone eats fat from the animal from which he presents a gift to the Lord, that person will be cut off from his people. ");
INSERT INTO engnet_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","And you must not eat any blood of the birds or the domesticated land animals in any of the places where you live. ");
INSERT INTO engnet_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Any person who eats any blood – that person will be cut off from his people.’” ");
INSERT INTO engnet_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tell the Israelites, ‘The one who presents his peace offering sacrifice to the Lord must bring his offering to the Lord from his peace offering sacrifice. ");
INSERT INTO engnet_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","With his own hands he must bring the Lord’s gifts. He must bring the fat with the breast to wave the breast as a wave offering before the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","and the priest must offer the fat up in smoke on the altar, but the breast will belong to Aaron and his sons. ");
INSERT INTO engnet_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","The right thigh you must give as a contribution offering to the priest from your peace offering sacrifices. ");
INSERT INTO engnet_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","The one from Aaron’s sons who presents the blood of the peace offering and fat will have the right thigh as his share, ");
INSERT INTO engnet_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","for the breast of the wave offering and the thigh of the contribution offering I have taken from the Israelites out of their peace offering sacrifices and have given them to Aaron the priest and to his sons from the people of Israel as a perpetual allotted portion.’” ");
INSERT INTO engnet_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the allotment of Aaron and the allotment of his sons from the Lord’s gifts on the day Moses presented them to serve as priests to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","This is what the Lord commanded to give to them from the Israelites on the day Moses anointed them – a perpetual allotted portion throughout their generations. ");
INSERT INTO engnet_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law for the burnt offering, the grain offering, the sin offering, the guilt offering, the ordination offering, and the peace offering sacrifice, ");
INSERT INTO engnet_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","which the Lord commanded Moses on Mount Sinai on the day he commanded the Israelites to present their offerings to the Lord in the wilderness of Sinai. ");
INSERT INTO engnet_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Take Aaron and his sons with him, and the garments, the anointing oil, the sin offering bull, the two rams, and the basket of unleavened bread, ");
INSERT INTO engnet_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","and assemble the whole congregation at the entrance of the Meeting Tent.” ");
INSERT INTO engnet_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","So Moses did just as the Lord commanded him, and the congregation assembled at the entrance of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Then Moses said to the congregation: “This is what the Lord has commanded to be done.” ");
INSERT INTO engnet_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","So Moses brought Aaron and his sons forward and washed them with water. ");
INSERT INTO engnet_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Then he put the tunic on Aaron, wrapped the sash around him, and clothed him with the robe. Next he put the ephod on him and placed on him the decorated band of the ephod, and fastened the ephod closely to him with the band. ");
INSERT INTO engnet_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","He then set the breastpiece on him and put the Urim and Thummim into the breastpiece. ");
INSERT INTO engnet_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Finally, he set the turban on his head and attached the gold plate, the holy diadem, to the front of the turban just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Then Moses took the anointing oil and anointed the tabernacle and everything in it, and so consecrated them. ");
INSERT INTO engnet_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Next he sprinkled some of it on the altar seven times and so anointed the altar, all its vessels, and the wash basin and its stand to consecrate them. ");
INSERT INTO engnet_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He then poured some of the anointing oil on the head of Aaron and anointed him to consecrate him. ");
INSERT INTO engnet_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moses also brought forward Aaron’s sons, clothed them with tunics, wrapped sashes around them, and wrapped headbands on them just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Then he brought near the sin offering bull and Aaron and his sons laid their hands on the head of the sin offering bull, ");
INSERT INTO engnet_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","and he slaughtered it. Moses then took the blood and put it all around on the horns of the altar with his finger and decontaminated the altar, and he poured out the rest of the blood at the base of the altar and so consecrated it to make atonement on it. ");
INSERT INTO engnet_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Then he took all the fat on the entrails, the protruding lobe of the liver, and the two kidneys and their fat, and Moses offered it all up in smoke on the altar, ");
INSERT INTO engnet_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","but the rest of the bull – its hide, its flesh, and its dung – he completely burned up outside the camp just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Then he presented the burnt offering ram and Aaron and his sons laid their hands on the head of the ram, ");
INSERT INTO engnet_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","and he slaughtered it. Moses then splashed the blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Then he cut the ram into parts, and Moses offered the head, the parts, and the suet up in smoke, ");
INSERT INTO engnet_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","but the entrails and the legs he washed with water, and Moses offered the whole ram up in smoke on the altar – it was a burnt offering for a soothing aroma, a gift to the Lord, just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Then he presented the second ram, the ram of ordination, and Aaron and his sons laid their hands on the head of the ram ");
INSERT INTO engnet_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","and he slaughtered it. Moses then took some of its blood and put it on Aaron’s right earlobe, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engnet_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Next he brought Aaron’s sons forward, and Moses put some of the blood on their right earlobes, on their right thumbs, and on the big toes of their right feet, and Moses splashed the rest of the blood against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Then he took the fat (the fatty tail, all the fat on the entrails, the protruding lobe of the liver, and the two kidneys and their fat ) and the right thigh, ");
INSERT INTO engnet_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","and from the basket of unleavened bread that was before the Lord he took one unleavened loaf, one loaf of bread mixed with olive oil, and one wafer, and placed them on the fat parts and on the right thigh. ");
INSERT INTO engnet_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","He then put all of them on the palms of Aaron and his sons, who waved them as a wave offering before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moses then took them from their palms and offered them up in smoke on the altar on top of the burnt offering – they were an ordination offering for a soothing aroma; it was a gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Finally, Moses took the breast and waved it as a wave offering before the Lord from the ram of ordination. It was Moses’ share just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Then Moses took some of the anointing oil and some of the blood which was on the altar and sprinkled it on Aaron and his garments, and on his sons and his sons’ garments with him. So he consecrated Aaron, his garments, and his sons and his sons’ garments with him. ");
INSERT INTO engnet_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Then Moses said to Aaron and his sons, “Boil the meat at the entrance of the Meeting Tent, and there you are to eat it and the bread which is in the ordination offering basket, just as I have commanded, saying, ‘Aaron and his sons are to eat it,’ ");
INSERT INTO engnet_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","but the remainder of the meat and the bread you must burn with fire. ");
INSERT INTO engnet_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","And you must not go out from the entrance of the Meeting Tent for seven days, until the day when your days of ordination are completed, because you must be ordained over a seven-day period. ");
INSERT INTO engnet_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What has been done on this day the Lord has commanded to be done to make atonement for you. ");
INSERT INTO engnet_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You must reside at the entrance of the Meeting Tent day and night for seven days and keep the charge of the Lord so that you will not die, for this is what I have been commanded.” ");
INSERT INTO engnet_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aaron and his sons did all the things the Lord had commanded through Moses. ");
INSERT INTO engnet_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day Moses summoned Aaron and his sons and the elders of Israel, ");
INSERT INTO engnet_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","and said to Aaron, “Take for yourself a bull calf for a sin offering and a ram for a burnt offering, both flawless, and present them before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Then tell the Israelites: ‘Take a male goat for a sin offering and a calf and lamb, both a year old and flawless, for a burnt offering, ");
INSERT INTO engnet_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","and an ox and a ram for peace offerings to sacrifice before the Lord, and a grain offering mixed with olive oil, for today the Lord is going to appear to you.’” ");
INSERT INTO engnet_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","So they took what Moses had commanded to the front of the Meeting Tent and the whole congregation presented them and stood before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Then Moses said, “This is what the Lord has commanded you to do so that the glory of the Lord may appear to you.” ");
INSERT INTO engnet_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moses then said to Aaron, “Approach the altar and make your sin offering and your burnt offering, and make atonement on behalf of yourself and on behalf of the people; and also make the people’s offering and make atonement on behalf of them just as the Lord has commanded.” ");
INSERT INTO engnet_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron approached the altar and slaughtered the sin offering calf which was for himself. ");
INSERT INTO engnet_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Then Aaron’s sons presented the blood to him and he dipped his finger in the blood and put it on the horns of the altar, and the rest of the blood he poured out at the base of the altar. ");
INSERT INTO engnet_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","The fat and the kidneys and the protruding lobe of the liver from the sin offering he offered up in smoke on the altar just as the Lord had commanded Moses, ");
INSERT INTO engnet_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","but the flesh and the hide he completely burned up outside the camp. ");
INSERT INTO engnet_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","He then slaughtered the burnt offering, and his sons handed the blood to him and he splashed it against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","The burnt offering itself they handed to him by its parts, including the head, and he offered them up in smoke on the altar, ");
INSERT INTO engnet_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","and he washed the entrails and the legs and offered them up in smoke on top of the burnt offering on the altar. ");
INSERT INTO engnet_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Then he presented the people’s offering. He took the sin offering male goat which was for the people, slaughtered it, and performed a decontamination rite with it like the first one. ");
INSERT INTO engnet_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He then presented the burnt offering, and did it according to the standard regulation. ");
INSERT INTO engnet_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Next he presented the grain offering, filled his hand with some of it, and offered it up in smoke on the altar in addition to the morning burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Then he slaughtered the ox and the ram – the peace offering sacrifices which were for the people – and Aaron’s sons handed the blood to him and he splashed it against the altar’s sides. ");
INSERT INTO engnet_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","As for the fat parts from the ox and from the ram (the fatty tail, the fat covering the entrails, the kidneys, and the protruding lobe of the liver), ");
INSERT INTO engnet_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","they set those on the breasts and he offered the fat parts up in smoke on the altar. ");
INSERT INTO engnet_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Finally Aaron waved the breasts and the right thigh as a wave offering before the Lord just as Moses had commanded. ");
INSERT INTO engnet_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Then Aaron lifted up his hands toward the people and blessed them and descended from making the sin offering, the burnt offering, and the peace offering. ");
INSERT INTO engnet_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron then entered into the Meeting Tent. When they came out, they blessed the people, and the glory of the Lord appeared to all the people. ");
INSERT INTO engnet_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Then fire went out from the presence of the Lord and consumed the burnt offering and the fat parts on the altar, and all the people saw it, so they shouted loudly and fell down with their faces to the ground. ");
INSERT INTO engnet_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Then Aaron’s sons, Nadab and Abihu, each took his fire pan and put fire in it, set incense on it, and presented strange fire before the Lord, which he had not commanded them to do. ");
INSERT INTO engnet_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","So fire went out from the presence of the Lord and consumed them so that they died before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moses then said to Aaron, “This is what the Lord spoke: ‘Among the ones close to me I will show myself holy, and in the presence of all the people I will be honored.’” So Aaron kept silent. ");
INSERT INTO engnet_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses then called to Mishael and Elzaphan, the sons of Uzziel, Aaron’s uncle, and said to them, “Come near, carry your brothers away from the front of the sanctuary to a place outside the camp.” ");
INSERT INTO engnet_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they came near and carried them away in their tunics to a place outside the camp just as Moses had spoken. ");
INSERT INTO engnet_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses said to Aaron and to Eleazar and Ithamar his other two sons, “Do not dishevel the hair of your heads and do not tear your garments, so that you do not die and so that wrath does not come on the whole congregation. Your brothers, all the house of Israel, are to mourn the burning which the Lord has caused, ");
INSERT INTO engnet_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","but you must not go out from the entrance of the Meeting Tent lest you die, for the Lord’s anointing oil is on you.” So they acted according to the word of Moses. ");
INSERT INTO engnet_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Then the Lord spoke to Aaron, ");
INSERT INTO engnet_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Do not drink wine or strong drink, you and your sons with you, when you enter into the Meeting Tent, so that you do not die, which is a perpetual statute throughout your generations, ");
INSERT INTO engnet_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","as well as to distinguish between the holy and the common, and between the unclean and the clean, ");
INSERT INTO engnet_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","and to teach the Israelites all the statutes that the Lord has spoken to them through Moses.” ");
INSERT INTO engnet_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Then Moses spoke to Aaron and to Eleazar and Ithamar, his remaining sons, “Take the grain offering which remains from the gifts of the Lord and eat it unleavened beside the altar, for it is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","You must eat it in a holy place because it is your allotted portion and the allotted portion of your sons from the gifts of the Lord, for this is what I have been commanded. ");
INSERT INTO engnet_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Also, the breast of the wave offering and the thigh of the contribution offering you must eat in a ceremonially clean place, you and your sons and daughters with you, for they have been given as your allotted portion and the allotted portion of your sons from the peace offering sacrifices of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The thigh of the contribution offering and the breast of the wave offering they must bring in addition to the gifts of the fat parts to wave them as a wave offering before the Lord, and it will belong to you and your sons with you for a perpetual statute just as the Lord has commanded.” ");
INSERT INTO engnet_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Later Moses sought diligently for the sin offering male goat, but it had actually been burnt. So he became angry at Eleazar and Ithamar, Aaron’s remaining sons, saying, ");
INSERT INTO engnet_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why did you not eat the sin offering in the sanctuary? For it is most holy and he gave it to you to bear the iniquity of the congregation, to make atonement on their behalf before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","See here! Its blood was not brought into the holy place within! You should certainly have eaten it in the sanctuary just as I commanded!” ");
INSERT INTO engnet_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","But Aaron spoke to Moses, “See here! Just today they presented their sin offering and their burnt offering before the Lord and such things as these have happened to me! If I had eaten a sin offering today would the Lord have been pleased?” ");
INSERT INTO engnet_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses heard this explanation, he was satisfied. ");
INSERT INTO engnet_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","The Lord spoke to Moses and Aaron, saying to them, ");
INSERT INTO engnet_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Tell the Israelites: ‘This is the kind of creature you may eat from among all the animals that are on the land. ");
INSERT INTO engnet_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","You may eat any among the animals that has a divided hoof (the hooves are completely split in two ) and that also chews the cud. ");
INSERT INTO engnet_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","However, you must not eat these from among those that chew the cud and have divided hooves: The camel is unclean to you because it chews the cud even though its hoof is not divided. ");
INSERT INTO engnet_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","The rock badger is unclean to you because it chews the cud even though its hoof is not divided. ");
INSERT INTO engnet_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","The hare is unclean to you because it chews the cud even though its hoof is not divided. ");
INSERT INTO engnet_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","The pig is unclean to you because its hoof is divided (the hoof is completely split in two ), even though it does not chew the cud. ");
INSERT INTO engnet_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You must not eat from their meat and you must not touch their carcasses; they are unclean to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘These you can eat from all creatures that are in the water: Any creatures in the water that have both fins and scales, whether in the seas or in the streams, you may eat. ");
INSERT INTO engnet_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But any creatures that do not have both fins and scales, whether in the seas or in the streams, from all the swarming things of the water and from all the living creatures that are in the water, are detestable to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Since they are detestable to you, you must not eat their meat and their carcass you must detest. ");
INSERT INTO engnet_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Any creature in the water that does not have both fins and scales is detestable to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘These you are to detest from among the birds – they must not be eaten, because they are detestable: the griffon vulture, the bearded vulture, the black vulture, ");
INSERT INTO engnet_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","the kite, the buzzard of any kind, ");
INSERT INTO engnet_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","every kind of crow, ");
INSERT INTO engnet_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","the eagle owl, the short-eared owl, the long-eared owl, the hawk of any kind, ");
INSERT INTO engnet_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","the little owl, the cormorant, the screech owl, ");
INSERT INTO engnet_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","the white owl, the scops owl, the osprey, ");
INSERT INTO engnet_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","the stork, the heron of any kind, the hoopoe, and the bat. ");
INSERT INTO engnet_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘Every winged swarming thing that walks on all fours is detestable to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","However, this you may eat from all the winged swarming things that walk on all fours, which have jointed legs to hop with on the land. ");
INSERT INTO engnet_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","These you may eat from them: the locust of any kind, the bald locust of any kind, the cricket of any kind, the grasshopper of any kind. ");
INSERT INTO engnet_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","But any other winged swarming thing that has four legs is detestable to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘By these you defile yourselves; anyone who touches their carcass will be unclean until the evening, ");
INSERT INTO engnet_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","and anyone who carries their carcass must wash his clothes and will be unclean until the evening. ");
INSERT INTO engnet_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“‘All animals that divide the hoof but it is not completely split in two and do not chew the cud are unclean to you; anyone who touches them becomes unclean. ");
INSERT INTO engnet_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","All that walk on their paws among all the creatures that walk on all fours are unclean to you. Anyone who touches their carcass will be unclean until the evening, ");
INSERT INTO engnet_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","and the one who carries their carcass must wash his clothes and be unclean until the evening; they are unclean to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘Now this is what is unclean to you among the swarming things that swarm on the land: the rat, the mouse, the large lizard of any kind, ");
INSERT INTO engnet_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","the Mediterranean gecko, the spotted lizard, the wall gecko, the skink, and the chameleon. ");
INSERT INTO engnet_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These are the ones that are unclean to you among all the swarming things. Anyone who touches them when they die will be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Also, anything they fall on when they die will become unclean – any wood vessel or garment or article of leather or sackcloth. Any such vessel with which work is done must be immersed in water and will be unclean until the evening. Then it will become clean. ");
INSERT INTO engnet_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","As for any clay vessel they fall into, everything in it will become unclean and you must break it. ");
INSERT INTO engnet_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Any food that may be eaten which becomes soaked with water will become unclean. Anything drinkable in any such vessel will become unclean. ");
INSERT INTO engnet_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anything their carcass may fall on will become unclean. An oven or small stove must be smashed to pieces; they are unclean, and they will stay unclean to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","However, a spring or a cistern which collects water will be clean, but one who touches their carcass will be unclean. ");
INSERT INTO engnet_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Now, if such a carcass falls on any sowing seed which is to be sown, it is clean, ");
INSERT INTO engnet_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","but if water is put on the seed and such a carcass falls on it, it is unclean to you. ");
INSERT INTO engnet_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘Now if an animal that you may eat dies, whoever touches its carcass will be unclean until the evening. ");
INSERT INTO engnet_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","One who eats from its carcass must wash his clothes and be unclean until the evening, and whoever carries its carcass must wash his clothes and be unclean until the evening. ");
INSERT INTO engnet_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Every swarming thing that swarms on the land is detestable; it must not be eaten. ");
INSERT INTO engnet_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","You must not eat anything that crawls on its belly or anything that walks on all fours or on any number of legs of all the swarming things that swarm on the land, because they are detestable. ");
INSERT INTO engnet_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Do not make yourselves detestable by any of the swarming things. You must not defile yourselves by them and become unclean by them, ");
INSERT INTO engnet_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","for I am the Lord your God and you are to sanctify yourselves and be holy because I am holy. You must not defile yourselves by any of the swarming things that creep on the ground, ");
INSERT INTO engnet_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","for I am the Lord who brought you up from the land of Egypt to be your God, and you are to be holy because I am holy. ");
INSERT INTO engnet_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the law of the land animals, the birds, all the living creatures that move in the water, and all the creatures that swarm on the land, ");
INSERT INTO engnet_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","to distinguish between the unclean and the clean, between the living creatures that may be eaten and the living creatures that must not be eaten.’” ");
INSERT INTO engnet_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Tell the Israelites, ‘When a woman produces offspring and bears a male child, she will be unclean seven days, as she is unclean during the days of her menstruation. ");
INSERT INTO engnet_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","On the eighth day the flesh of his foreskin must be circumcised. ");
INSERT INTO engnet_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Then she will remain thirty-three days in blood purity. She must not touch anything holy and she must not enter the sanctuary until the days of her purification are fulfilled. ");
INSERT INTO engnet_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","If she bears a female child, she will be impure fourteen days as during her menstrual flow, and she will remain sixty-six days in blood purity. ");
INSERT INTO engnet_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘When the days of her purification are completed for a son or for a daughter, she must bring a one year old lamb for a burnt offering and a young pigeon or turtledove for a sin offering to the entrance of the Meeting Tent, to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","The priest is to present it before the Lord and make atonement on her behalf, and she will be clean from her flow of blood. This is the law of the one who bears a child, for the male or the female child. ");
INSERT INTO engnet_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","If she cannot afford a sheep, then she must take two turtledoves or two young pigeons, one for a burnt offering and one for a sin offering, and the priest is to make atonement on her behalf, and she will be clean.’” ");
INSERT INTO engnet_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“When someone has a swelling or a scab or a bright spot on the skin of his body that may become a diseased infection, he must be brought to Aaron the priest or one of his sons, the priests. ");
INSERT INTO engnet_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest must then examine the infection on the skin of the body, and if the hair in the infection has turned white and the infection appears to be deeper than the skin of the body, then it is a diseased infection, so when the priest examines it he must pronounce the person unclean. ");
INSERT INTO engnet_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“If it is a white bright spot on the skin of his body, but it does not appear to be deeper than the skin, and the hair has not turned white, then the priest is to quarantine the person with the infection for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","The priest must then examine it on the seventh day, and if, as far as he can see, the infection has stayed the same and has not spread on the skin, then the priest is to quarantine the person for another seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","The priest must then examine it again on the seventh day, and if the infection has faded and has not spread on the skin, then the priest is to pronounce the person clean. It is a scab, so he must wash his clothes and be clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","If, however, the scab is spreading further on the skin after he has shown himself to the priest for his purification, then he must show himself to the priest a second time. ");
INSERT INTO engnet_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest must then examine it, and if the scab has spread on the skin, then the priest is to pronounce the person unclean. It is a disease. ");
INSERT INTO engnet_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“When someone has a diseased infection, he must be brought to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","The priest will then examine it, and if a white swelling is on the skin, it has turned the hair white, and there is raw flesh in the swelling, ");
INSERT INTO engnet_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is a chronic disease on the skin of his body, so the priest is to pronounce him unclean. The priest must not merely quarantine him, for he is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","If, however, the disease breaks out on the skin so that the disease covers all the skin of the person with the infection from his head to his feet, as far as the priest can see, ");
INSERT INTO engnet_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","the priest must then examine it, and if the disease covers his whole body, he is to pronounce the person with the infection clean. He has turned all white, so he is clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But whenever raw flesh appears in it he will be unclean, ");
INSERT INTO engnet_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","so the priest is to examine the raw flesh and pronounce him unclean – it is diseased. ");
INSERT INTO engnet_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","If, however, the raw flesh once again turns white, then he must come to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest will then examine it, and if the infection has turned white, the priest is to pronounce the person with the infection clean – he is clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“When someone’s body has a boil on its skin and it heals, ");
INSERT INTO engnet_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and in the place of the boil there is a white swelling or a reddish white bright spot, he must show himself to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest will then examine it, and if it appears to be deeper than the skin and its hair has turned white, then the priest is to pronounce the person unclean. It is a diseased infection that has broken out in the boil. ");
INSERT INTO engnet_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","If, however, the priest examines it, and there is no white hair in it, it is not deeper than the skin, and it has faded, then the priest is to quarantine him for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If it is spreading further on the skin, then the priest is to pronounce him unclean. It is an infection. ");
INSERT INTO engnet_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright spot stays in its place and has not spread, it is the scar of the boil, so the priest is to pronounce him clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“When a body has a burn on its skin and the raw area of the burn becomes a reddish white or white bright spot, ");
INSERT INTO engnet_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","the priest must examine it, and if the hair has turned white in the bright spot and it appears to be deeper than the skin, it is a disease that has broken out in the burn. The priest is to pronounce the person unclean. It is a diseased infection. ");
INSERT INTO engnet_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","If, however, the priest examines it and there is no white hair in the bright spot, it is not deeper than the skin, and it has faded, then the priest is to quarantine him for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","The priest must then examine it on the seventh day, and if it is spreading further on the skin, then the priest is to pronounce him unclean. It is a diseased infection. ");
INSERT INTO engnet_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","But if the bright spot stays in its place, has not spread on the skin, and it has faded, then it is the swelling of the burn, so the priest is to pronounce him clean, because it is the scar of the burn. ");
INSERT INTO engnet_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“When a man or a woman has an infection on the head or in the beard, ");
INSERT INTO engnet_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","the priest is to examine the infection, and if it appears to be deeper than the skin and the hair in it is reddish yellow and thin, then the priest is to pronounce the person unclean. It is scall, a disease of the head or the beard. ");
INSERT INTO engnet_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","But if the priest examines the scall infection and it does not appear to be deeper than the skin, and there is no black hair in it, then the priest is to quarantine the person with the scall infection for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","The priest must then examine the infection on the seventh day, and if the scall has not spread, there is no reddish yellow hair in it, and the scall does not appear to be deeper than the skin, ");
INSERT INTO engnet_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then the individual is to shave himself, but he must not shave the area affected by the scall, and the priest is to quarantine the person with the scall for another seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","The priest must then examine the scall on the seventh day, and if the scall has not spread on the skin and it does not appear to be deeper than the skin, then the priest is to pronounce him clean. So he is to wash his clothes and be clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","If, however, the scall spreads further on the skin after his purification, ");
INSERT INTO engnet_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","then the priest is to examine it, and if the scall has spread on the skin the priest is not to search further for reddish yellow hair. The person is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","If, as far as the priest can see, the scall has stayed the same and black hair has sprouted in it, the scall has been healed; the person is clean. So the priest is to pronounce him clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“When a man or a woman has bright spots – white bright spots – on the skin of their body, ");
INSERT INTO engnet_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","the priest is to examine them, and if the bright spots on the skin of their body are faded white, it is a harmless rash that has broken out on the skin. The person is clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“When a man’s head is bare so that he is balding in back, he is clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","If his head is bare on the forehead so that he is balding in front, he is clean. ");
INSERT INTO engnet_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if there is a reddish white infection in the back or front bald area, it is a disease breaking out in his back or front bald area. ");
INSERT INTO engnet_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","The priest is to examine it, and if the swelling of the infection is reddish white in the back or front bald area like the appearance of a disease on the skin of the body, ");
INSERT INTO engnet_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he is a diseased man. He is unclean. The priest must surely pronounce him unclean because of his infection on his head. ");
INSERT INTO engnet_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“As for the diseased person who has the infection, his clothes must be torn, the hair of his head must be unbound, he must cover his mustache, and he must call out ‘Unclean! Unclean!’ ");
INSERT INTO engnet_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","The whole time he has the infection he will be continually unclean. He must live in isolation, and his place of residence must be outside the camp. ");
INSERT INTO engnet_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“When a garment has a diseased infection in it, whether a wool or linen garment, ");
INSERT INTO engnet_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","or in the warp or woof of the linen or the wool, or in leather or anything made of leather, ");
INSERT INTO engnet_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","if the infection in the garment or leather or warp or woof or any article of leather is yellowish green or reddish, it is a diseased infection and it must be shown to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest is to examine and then quarantine the article with the infection for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","He must then examine the infection on the seventh day. If the infection has spread in the garment, or in the warp, or in the woof, or in the leather – whatever the article into which the leather was made – the infection is a malignant disease. It is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He must burn the garment or the warp or the woof, whether wool or linen, or any article of leather which has the infection in it. Because it is a malignant disease it must be burned up in the fire. ");
INSERT INTO engnet_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","But if the priest examines it and the infection has not spread in the garment or in the warp or in the woof or in any article of leather, ");
INSERT INTO engnet_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","the priest is to command that they wash whatever has the infection and quarantine it for another seven days. ");
INSERT INTO engnet_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","The priest must then examine it after the infection has been washed out, and if the infection has not changed its appearance even though the infection has not spread, it is unclean. You must burn it up in the fire. It is a fungus, whether on the back side or front side of the article. ");
INSERT INTO engnet_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","But if the priest has examined it and the infection has faded after it has been washed, he is to tear it out of the garment or the leather or the warp or the woof. ");
INSERT INTO engnet_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Then if it still appears again in the garment or the warp or the woof, or in any article of leather, it is an outbreak. Whatever has the infection in it you must burn up in the fire. ");
INSERT INTO engnet_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","But the garment or the warp or the woof or any article of leather which you wash and infection disappears from it is to be washed a second time and it will be clean.” ");
INSERT INTO engnet_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law of the diseased infection in the garment of wool or linen, or the warp or woof, or any article of leather, for pronouncing it clean or unclean. ");
INSERT INTO engnet_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“This is the law of the diseased person on the day of his purification, when he is brought to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The priest is to go outside the camp and examine the infection. If the infection of the diseased person has been healed, ");
INSERT INTO engnet_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","then the priest will command that two live clean birds, a piece of cedar wood, a scrap of crimson fabric, and some twigs of hyssop be taken up for the one being cleansed. ");
INSERT INTO engnet_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","The priest will then command that one bird be slaughtered into a clay vessel over fresh water. ");
INSERT INTO engnet_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Then he is to take the live bird along with the piece of cedar wood, the scrap of crimson fabric, and the twigs of hyssop, and he is to dip them and the live bird in the blood of the bird slaughtered over the fresh water, ");
INSERT INTO engnet_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","and sprinkle it seven times on the one being cleansed from the disease, pronounce him clean, and send the live bird away over the open countryside. ");
INSERT INTO engnet_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“The one being cleansed must then wash his clothes, shave off all his hair, and bathe in water, and so be clean. Then afterward he may enter the camp, but he must live outside his tent seven days. ");
INSERT INTO engnet_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","When the seventh day comes he must shave all his hair – his head, his beard, his eyebrows, all his hair – and he must wash his clothes, bathe his body in water, and so be clean. ");
INSERT INTO engnet_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“On the eighth day he must take two flawless male lambs, one flawless yearling female lamb, three-tenths of an ephah of choice wheat flour as a grain offering mixed with olive oil, and one log of olive oil, ");
INSERT INTO engnet_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","and the priest who pronounces him clean will have the man who is being cleansed stand along with these offerings before the Lord at the entrance of the Meeting Tent. ");
INSERT INTO engnet_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“The priest is to take one male lamb and present it for a guilt offering along with the log of olive oil and present them as a wave offering before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","He must then slaughter the male lamb in the place where the sin offering and the burnt offering are slaughtered, in the sanctuary, because, like the sin offering, the guilt offering belongs to the priest; it is most holy. ");
INSERT INTO engnet_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Then the priest is to take some of the blood of the guilt offering and put it on the right earlobe of the one being cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engnet_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","The priest will then take some of the log of olive oil and pour it into his own left hand. ");
INSERT INTO engnet_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Then the priest is to dip his right forefinger into the olive oil that is in his left hand, and sprinkle some of the olive oil with his finger seven times before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","The priest will then put some of the rest of the olive oil that is in his hand on the right earlobe of the one being cleansed, on the thumb of his right hand, and on the big toe of his right foot, on the blood of the guilt offering, ");
INSERT INTO engnet_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","and the remainder of the olive oil that is in his hand the priest is to put on the head of the one being cleansed. So the priest is to make atonement for him before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“The priest must then perform the sin offering and make atonement for the one being cleansed from his impurity. After that he is to slaughter the burnt offering, ");
INSERT INTO engnet_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","and the priest is to offer the burnt offering and the grain offering on the altar. So the priest is to make atonement for him and he will be clean. ");
INSERT INTO engnet_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“If the person is poor and does not have sufficient means, he must take one male lamb as a guilt offering for a wave offering to make atonement for himself, one-tenth of an ephah of choice wheat flour mixed with olive oil for a grain offering, a log of olive oil, ");
INSERT INTO engnet_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two turtledoves or two young pigeons, which are within his means. One will be a sin offering and the other a burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“On the eighth day he must bring them for his purification to the priest at the entrance of the Meeting Tent before the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","and the priest is to take the male lamb of the guilt offering and the log of olive oil and wave them as a wave offering before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Then he is to slaughter the male lamb of the guilt offering, and the priest is to take some of the blood of the guilt offering and put it on the right earlobe of the one being cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engnet_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","The priest will then pour some of the olive oil into his own left hand, ");
INSERT INTO engnet_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and sprinkle some of the olive oil that is in his left hand with his right forefinger seven times before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Then the priest is to put some of the olive oil that is in his hand on the right earlobe of the one being cleansed, on the thumb of his right hand, and on the big toe of his right foot, on the place of the blood of the guilt offering, ");
INSERT INTO engnet_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","and the remainder of the olive oil that is in the hand of the priest he is to put on the head of the one being cleansed to make atonement for him before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“He will then make one of the turtledoves or young pigeons, which are within his means, ");
INSERT INTO engnet_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","a sin offering and the other a burnt offering along with the grain offering. So the priest is to make atonement for the one being cleansed before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law of the one in whom there is a diseased infection, who does not have sufficient means for his purification.” ");
INSERT INTO engnet_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“When you enter the land of Canaan which I am about to give to you for a possession, and I put a diseased infection in a house in the land you are to possess, ");
INSERT INTO engnet_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","then whoever owns the house must come and declare to the priest, ‘Something like an infection is visible to me in the house.’ ");
INSERT INTO engnet_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Then the priest will command that the house be cleared before the priest enters to examine the infection so that everything in the house does not become unclean, and afterward the priest will enter to examine the house. ");
INSERT INTO engnet_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He is to examine the infection, and if the infection in the walls of the house consists of yellowish green or reddish eruptions, and it appears to be deeper than the surface of the wall, ");
INSERT INTO engnet_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","then the priest is to go out of the house to the doorway of the house and quarantine the house for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","The priest must return on the seventh day and examine it, and if the infection has spread in the walls of the house, ");
INSERT INTO engnet_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","then the priest is to command that the stones that had the infection in them be pulled and thrown outside the city into an unclean place. ");
INSERT INTO engnet_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Then he is to have the house scraped all around on the inside, and the plaster which is scraped off must be dumped outside the city into an unclean place. ");
INSERT INTO engnet_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","They are then to take other stones and replace those stones, and he is to take other plaster and replaster the house. ");
INSERT INTO engnet_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“If the infection returns and breaks out in the house after he has pulled out the stones, scraped the house, and it is replastered, ");
INSERT INTO engnet_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","the priest is to come and examine it, and if the infection has spread in the house, it is a malignant disease in the house. It is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","He must tear down the house, its stones, its wood, and all the plaster of the house, and bring all of it outside the city to an unclean place. ");
INSERT INTO engnet_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Anyone who enters the house all the days the priest has quarantined it will be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Anyone who lies down in the house must wash his clothes. Anyone who eats in the house must wash his clothes. ");
INSERT INTO engnet_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“If, however, the priest enters and examines it, and the infection has not spread in the house after the house has been replastered, then the priest is to pronounce the house clean because the infection has been healed. ");
INSERT INTO engnet_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Then he is to take two birds, a piece of cedar wood, a scrap of crimson fabric, and some twigs of hyssop to decontaminate the house, ");
INSERT INTO engnet_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","and he is to slaughter one bird into a clay vessel over fresh water. ");
INSERT INTO engnet_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","He must then take the piece of cedar wood, the twigs of hyssop, the scrap of crimson fabric, and the live bird, and dip them in the blood of the slaughtered bird and in the fresh water, and sprinkle the house seven times. ");
INSERT INTO engnet_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","So he is to decontaminate the house with the blood of the bird, the fresh water, the live bird, the piece of cedar wood, the twigs of hyssop, and the scrap of crimson fabric, ");
INSERT INTO engnet_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","and he is to send the live bird away outside the city into the open countryside. So he is to make atonement for the house and it will be clean. ");
INSERT INTO engnet_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“This is the law for all diseased infections, for scall, ");
INSERT INTO engnet_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","for the diseased garment, for the house, ");
INSERT INTO engnet_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","for the swelling, for the scab, and for the bright spot, ");
INSERT INTO engnet_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to teach when something is unclean and when it is clean. This is the law for dealing with infectious disease.” ");
INSERT INTO engnet_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Speak to the Israelites and tell them, ‘When any man has a discharge from his body, his discharge is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Now this is his uncleanness in regard to his discharge – whether his body secretes his discharge or blocks his discharge, he is unclean. All the days that his body has a discharge or his body blocks his discharge, this is his uncleanness. ");
INSERT INTO engnet_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘Any bed the man with a discharge lies on will be unclean, and any furniture he sits on will be unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Anyone who touches his bed must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","The one who sits on the furniture the man with a discharge sits on must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","The one who touches the body of the man with a discharge must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","If the man with a discharge spits on a person who is ceremonially clean, that person must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Any means of riding the man with a discharge rides on will be unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Anyone who touches anything that was under him will be unclean until evening, and the one who carries those items must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Anyone whom the man with the discharge touches without having rinsed his hands in water must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","A clay vessel which the man with the discharge touches must be broken, and any wooden utensil must be rinsed in water. ");
INSERT INTO engnet_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“‘When the man with the discharge becomes clean from his discharge he is to count off for himself seven days for his purification, and he must wash his clothes, bathe in fresh water, and be clean. ");
INSERT INTO engnet_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Then on the eighth day he is to take for himself two turtledoves or two young pigeons, and he is to present himself before the Lord at the entrance of the Meeting Tent and give them to the priest, ");
INSERT INTO engnet_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","and the priest is to make one of them a sin offering and the other a burnt offering. So the priest is to make atonement for him before the Lord for his discharge. ");
INSERT INTO engnet_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘When a man has a seminal emission, he must bathe his whole body in water and be unclean until evening, ");
INSERT INTO engnet_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","and he must wash in water any clothing or leather that has semen on it, and it will be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","When a man has sexual intercourse with a woman and there is a seminal emission, they must bathe in water and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘When a woman has a discharge and her discharge is blood from her body, she is to be in her menstruation seven days, and anyone who touches her will be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Anything she lies on during her menstruation will be unclean, and anything she sits on will be unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Anyone who touches her bed must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Anyone who touches any furniture she sits on must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","If there is something on the bed or on the furniture she sits on, when he touches it he will be unclean until evening, ");
INSERT INTO engnet_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","and if a man actually has sexual intercourse with her so that her menstrual impurity touches him, then he will be unclean seven days and any bed he lies on will be unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘When a woman’s discharge of blood flows many days not at the time of her menstruation, or if it flows beyond the time of her menstruation, all the days of her discharge of impurity will be like the days of her menstruation – she is unclean. ");
INSERT INTO engnet_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Any bed she lies on all the days of her discharge will be to her like the bed of her menstruation, any furniture she sits on will be unclean like the impurity of her menstruation, ");
INSERT INTO engnet_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","and anyone who touches them will be unclean, and he must wash his clothes, bathe in water, and be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘If she becomes clean from her discharge, then she is to count off for herself seven days, and afterward she will be clean. ");
INSERT INTO engnet_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Then on the eighth day she must take for herself two turtledoves or two young pigeons and she must bring them to the priest at the entrance of the Meeting Tent, ");
INSERT INTO engnet_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","and the priest is to make one a sin offering and the other a burnt offering. So the priest is to make atonement for her before the Lord from her discharge of impurity. ");
INSERT INTO engnet_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘Thus you are to set the Israelites apart from their impurity so that they do not die in their impurity by defiling my tabernacle which is in their midst. ");
INSERT INTO engnet_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the law of the one with a discharge: the one who has a seminal emission and becomes unclean by it, ");
INSERT INTO engnet_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","the one who is sick in her menstruation, the one with a discharge, whether male or female, and a man who has sexual intercourse with an unclean woman.’” ");
INSERT INTO engnet_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","The Lord spoke to Moses after the death of Aaron’s two sons when they approached the presence of the Lord and died, ");
INSERT INTO engnet_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","and the Lord said to Moses: “Tell Aaron your brother that he must not enter at any time into the holy place inside the veil-canopy in front of the atonement plate that is on the ark so that he may not die, for I will appear in the cloud over the atonement plate. ");
INSERT INTO engnet_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“In this way Aaron is to enter into the sanctuary – with a young bull for a sin offering and a ram for a burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He must put on a holy linen tunic, linen leggings are to cover his body, and he is to wrap himself with a linen sash and wrap his head with a linen turban. They are holy garments, so he must bathe his body in water and put them on. ");
INSERT INTO engnet_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","He must also take two male goats from the congregation of the Israelites for a sin offering and one ram for a burnt offering. ");
INSERT INTO engnet_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Then Aaron is to present the sin offering bull which is for himself and is to make atonement on behalf of himself and his household. ");
INSERT INTO engnet_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","He must then take the two goats and stand them before the Lord at the entrance of the Meeting Tent, ");
INSERT INTO engnet_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","and Aaron is to cast lots over the two goats, one lot for the Lord and one lot for Azazel. ");
INSERT INTO engnet_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron must then present the goat which has been designated by lot for the Lord, and he is to make it a sin offering, ");
INSERT INTO engnet_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","but the goat which has been designated by lot for Azazel is to be stood alive before the Lord to make atonement on it by sending it away to Azazel into the wilderness. ");
INSERT INTO engnet_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaron is to present the sin offering bull which is for himself, and he is to make atonement on behalf of himself and his household. He is to slaughter the sin offering bull which is for himself, ");
INSERT INTO engnet_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","and take a censer full of coals of fire from the altar before the Lord and a full double handful of finely ground fragrant incense, and bring them inside the veil-canopy. ");
INSERT INTO engnet_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","He must then put the incense on the fire before the Lord, and the cloud of incense will cover the atonement plate which is above the ark of the testimony, so that he will not die. ");
INSERT INTO engnet_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Then he is to take some of the blood of the bull and sprinkle it with his finger on the eastern face of the atonement plate, and in front of the atonement plate he is to sprinkle some of the blood seven times with his finger. ");
INSERT INTO engnet_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“He must then slaughter the sin offering goat which is for the people. He is to bring its blood inside the veil-canopy, and he is to do with its blood just as he did to the blood of the bull: He is to sprinkle it on the atonement plate and in front of the atonement plate. ");
INSERT INTO engnet_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","So he is to make atonement for the holy place from the impurities of the Israelites and from their transgressions with regard to all their sins, and thus he is to do for the Meeting Tent which resides with them in the midst of their impurities. ");
INSERT INTO engnet_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nobody is to be in the Meeting Tent when he enters to make atonement in the holy place until he goes out, and he has made atonement on his behalf, on behalf of his household, and on behalf of the whole assembly of Israel. ");
INSERT INTO engnet_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Then he is to go out to the altar which is before the Lord and make atonement for it. He is to take some of the blood of the bull and some of the blood of the goat, and put it all around on the horns of the altar. ");
INSERT INTO engnet_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Then he is to sprinkle on it some of the blood with his finger seven times, and cleanse and consecrate it from the impurities of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“When he has finished purifying the holy place, the Meeting Tent, and the altar, he is to present the live goat. ");
INSERT INTO engnet_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron is to lay his two hands on the head of the live goat and confess over it all the iniquities of the Israelites and all their transgressions in regard to all their sins, and thus he is to put them on the head of the goat and send it away into the wilderness by the hand of a man standing ready. ");
INSERT INTO engnet_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","The goat is to bear on itself all their iniquities into an inaccessible land, so he is to send the goat away in the wilderness. ");
INSERT INTO engnet_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Aaron must then enter the Meeting Tent and take off the linen garments which he had put on when he entered the sanctuary, and leave them there. ");
INSERT INTO engnet_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Then he must bathe his body in water in a holy place, put on his clothes, and go out and make his burnt offering and the people’s burnt offering. So he is to make atonement on behalf of himself and the people. ");
INSERT INTO engnet_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","“Then he is to offer up the fat of the sin offering in smoke on the altar, ");
INSERT INTO engnet_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","and the one who sent the goat away to Azazel must wash his clothes, bathe his body in water, and afterward he may reenter the camp. ");
INSERT INTO engnet_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The bull of the sin offering and the goat of the sin offering, whose blood was brought to make atonement in the holy place, must be brought outside the camp and their hide, their flesh, and their dung must be burned up, ");
INSERT INTO engnet_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","and the one who burns them must wash his clothes and bathe his body in water, and afterward he may reenter the camp. ");
INSERT INTO engnet_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“This is to be a perpetual statute for you. In the seventh month, on the tenth day of the month, you must humble yourselves and do no work of any kind, both the native citizen and the foreigner who resides in your midst, ");
INSERT INTO engnet_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","for on this day atonement is to be made for you to cleanse you from all your sins; you must be clean before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is to be a Sabbath of complete rest for you, and you must humble yourselves. It is a perpetual statute. ");
INSERT INTO engnet_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“The priest who is anointed and ordained to act as high priest in place of his father is to make atonement. He is to put on the linen garments, the holy garments, ");
INSERT INTO engnet_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","and he is to purify the Most Holy Place, he is to purify the Meeting Tent and the altar, and he is to make atonement for the priests and for all the people of the assembly. ");
INSERT INTO engnet_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","This is to be a perpetual statute for you to make atonement for the Israelites for all their sins once a year.” So he did just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron, his sons, and all the Israelites, and tell them: ‘This is the word that the Lord has commanded: ");
INSERT INTO engnet_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Blood guilt will be accounted to any man from the house of Israel who slaughters an ox or a lamb or a goat inside the camp or outside the camp, ");
INSERT INTO engnet_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","but has not brought it to the entrance of the Meeting Tent to present it as an offering to the Lord before the tabernacle of the Lord. He has shed blood, so that man will be cut off from the midst of his people. ");
INSERT INTO engnet_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","This is so that the Israelites will bring their sacrifices that they are sacrificing in the open field to the Lord at the entrance of the Meeting Tent to the priest and sacrifice them there as peace offering sacrifices to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","The priest is to splash the blood on the altar of the Lord at the entrance of the Meeting Tent, and offer the fat up in smoke for a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","So they must no longer offer their sacrifices to the goat demons, acting like prostitutes by going after them. This is to be a perpetual statute for them throughout their generations. ");
INSERT INTO engnet_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“You are to say to them: ‘Any man from the house of Israel or from the foreigners who reside in their midst, who offers a burnt offering or a sacrifice ");
INSERT INTO engnet_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","but does not bring it to the entrance of the Meeting Tent to offer it to the Lord – that person will be cut off from his people. ");
INSERT INTO engnet_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Any man from the house of Israel or from the foreigners who reside in their midst who eats any blood, I will set my face against that person who eats the blood, and I will cut him off from the midst of his people, ");
INSERT INTO engnet_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","for the life of every living thing is in the blood. So I myself have assigned it to you on the altar to make atonement for your lives, for the blood makes atonement by means of the life. ");
INSERT INTO engnet_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore, I have said to the Israelites: No person among you is to eat blood, and no resident foreigner who lives among you is to eat blood. ");
INSERT INTO engnet_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“‘Any man from the Israelites or from the foreigners who reside in their midst who hunts a wild animal or a bird that may be eaten must pour out its blood and cover it with soil, ");
INSERT INTO engnet_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","for the life of all flesh is its blood. So I have said to the Israelites: You must not eat the blood of any living thing because the life of every living thing is its blood – all who eat it will be cut off. ");
INSERT INTO engnet_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“‘Any person who eats an animal that has died of natural causes or an animal torn by beasts, whether a native citizen or a foreigner, must wash his clothes, bathe in water, and be unclean until evening; then he becomes clean. ");
INSERT INTO engnet_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he does not wash his clothes and does not bathe his body, he will bear his punishment for iniquity.’” ");
INSERT INTO engnet_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Speak to the Israelites and tell them, ‘I am the Lord your God! ");
INSERT INTO engnet_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You must not do as they do in the land of Egypt where you have been living, and you must not do as they do in the land of Canaan into which I am about to bring you; you must not walk in their statutes. ");
INSERT INTO engnet_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","You must observe my regulations and you must be sure to walk in my statutes. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","So you must keep my statutes and my regulations; anyone who does so will live by keeping them. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘No man is to approach any close relative to have sexual intercourse with her. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","You must not expose your father’s nakedness by having sexual intercourse with your mother. She is your mother; you must not have intercourse with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","You must not have sexual intercourse with your father’s wife; she is your father’s nakedness. ");
INSERT INTO engnet_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","You must not have sexual intercourse with your sister, whether she is your father’s daughter or your mother’s daughter, whether she is born in the same household or born outside it; you must not have sexual intercourse with either of them. ");
INSERT INTO engnet_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","You must not expose the nakedness of your son’s daughter or your daughter’s daughter by having sexual intercourse with them, because they are your own nakedness. ");
INSERT INTO engnet_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","You must not have sexual intercourse with the daughter of your father’s wife born of your father; she is your sister. You must not have intercourse with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","You must not have sexual intercourse with your father’s sister; she is your father’s flesh. ");
INSERT INTO engnet_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","You must not have sexual intercourse with your mother’s sister, because she is your mother’s flesh. ");
INSERT INTO engnet_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","You must not expose the nakedness of your father’s brother; you must not approach his wife to have sexual intercourse with her. She is your aunt. ");
INSERT INTO engnet_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","You must not have sexual intercourse with your daughter-in-law; she is your son’s wife. You must not have intercourse with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","You must not have sexual intercourse with your brother’s wife; she is your brother’s nakedness. ");
INSERT INTO engnet_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","You must not have sexual intercourse with both a woman and her daughter; you must not take as wife either her son’s daughter or her daughter’s daughter to have intercourse with them. They are closely related to her – it is lewdness. ");
INSERT INTO engnet_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","You must not take a woman in marriage and then marry her sister as a rival wife while she is still alive, to have sexual intercourse with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘You must not approach a woman in her menstrual impurity to have sexual intercourse with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","You must not have sexual intercourse with the wife of your fellow citizen to become unclean with her. ");
INSERT INTO engnet_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","You must not give any of your children as an offering to Molech, so that you do not profane the name of your God. I am the Lord! ");
INSERT INTO engnet_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","You must not have sexual intercourse with a male as one has sexual intercourse with a woman; it is a detestable act. ");
INSERT INTO engnet_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","You must not have sexual intercourse with any animal to become defiled with it, and a woman must not stand before an animal to have sexual intercourse with it; it is a perversion. ");
INSERT INTO engnet_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘Do not defile yourselves with any of these things, for the nations which I am about to drive out before you have been defiled with all these things. ");
INSERT INTO engnet_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Therefore the land has become unclean and I have brought the punishment for its iniquity upon it, so that the land has vomited out its inhabitants. ");
INSERT INTO engnet_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","You yourselves must obey my statutes and my regulations and must not do any of these abominations, both the native citizen and the resident foreigner in your midst, ");
INSERT INTO engnet_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","for the people who were in the land before you have done all these abominations, and the land has become unclean. ");
INSERT INTO engnet_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","So do not make the land vomit you out because you defile it just as it has vomited out the nations that were before you. ");
INSERT INTO engnet_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","For if anyone does any of these abominations, the persons who do them will be cut off from the midst of their people. ");
INSERT INTO engnet_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","You must obey my charge to not practice any of the abominable statutes that have been done before you, so that you do not defile yourselves by them. I am the Lord your God.’” ");
INSERT INTO engnet_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Speak to the whole congregation of the Israelites and tell them, ‘You must be holy because I, the Lord your God, am holy. ");
INSERT INTO engnet_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Each of you must respect his mother and his father, and you must keep my Sabbaths. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Do not turn to idols, and you must not make for yourselves gods of cast metal. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘When you sacrifice a peace offering sacrifice to the Lord, you must sacrifice it so that it is accepted for you. ");
INSERT INTO engnet_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It must be eaten on the day of your sacrifice and on the following day, but what is left over until the third day must be burned up. ");
INSERT INTO engnet_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If, however, it is eaten on the third day, it is spoiled, it will not be accepted, ");
INSERT INTO engnet_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","and the one who eats it will bear his punishment for iniquity because he has profaned what is holy to the Lord. That person will be cut off from his people. ");
INSERT INTO engnet_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘When you gather in the harvest of your land, you must not completely harvest the corner of your field, and you must not gather up the gleanings of your harvest. ");
INSERT INTO engnet_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","You must not pick your vineyard bare, and you must not gather up the fallen grapes of your vineyard. You must leave them for the poor and the foreigner. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘You must not steal, you must not tell lies, and you must not deal falsely with your fellow citizen. ");
INSERT INTO engnet_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","You must not swear falsely in my name, so that you do not profane the name of your God. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","You must not oppress your neighbor or commit robbery against him. You must not withhold the wages of the hired laborer overnight until morning. ");
INSERT INTO engnet_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","You must not curse a deaf person or put a stumbling block in front of a blind person. You must fear your God; I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘You must not deal unjustly in judgment: you must neither show partiality to the poor nor honor the rich. You must judge your fellow citizen fairly. ");
INSERT INTO engnet_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","You must not go about as a slanderer among your people. You must not stand idly by when your neighbor’s life is at stake. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","You must not hate your brother in your heart. You must surely reprove your fellow citizen so that you do not incur sin on account of him. ");
INSERT INTO engnet_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","You must not take vengeance or bear a grudge against the children of your people, but you must love your neighbor as yourself. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","You must keep my statutes. You must not allow two different kinds of your animals to breed, you must not sow your field with two different kinds of seed, and you must not wear a garment made of two different kinds of fabric. ");
INSERT INTO engnet_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘When a man has sexual intercourse with a woman, although she is a slave woman designated for another man and she has not yet been ransomed, or freedom has not been granted to her, there will be an obligation to pay compensation. They must not be put to death, because she was not free. ");
INSERT INTO engnet_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","He must bring his guilt offering to the Lord at the entrance of the Meeting Tent, a guilt offering ram, ");
INSERT INTO engnet_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","and the priest is to make atonement for him with the ram of the guilt offering before the Lord for his sin that he has committed, and he will be forgiven of his sin that he has committed. ");
INSERT INTO engnet_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘When you enter the land and plant any fruit tree, you must consider its fruit to be forbidden. Three years it will be forbidden to you; it must not be eaten. ");
INSERT INTO engnet_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In the fourth year all its fruit will be holy, praise offerings to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Then in the fifth year you may eat its fruit to add its produce to your harvest. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘You must not eat anything with the blood still in it. You must not practice either divination or soothsaying. ");
INSERT INTO engnet_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","You must not round off the corners of the hair on your head or ruin the corners of your beard. ");
INSERT INTO engnet_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","You must not slash your body for a dead person or incise a tattoo on yourself. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Do not profane your daughter by making her a prostitute, so that the land does not practice prostitution and become full of lewdness. ");
INSERT INTO engnet_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘You must keep my Sabbaths and fear my sanctuary. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Do not turn to the spirits of the dead and do not seek familiar spirits to become unclean by them. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","You must stand up in the presence of the aged, honor the presence of an elder, and fear your God. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","When a foreigner resides with you in your land, you must not oppress him. ");
INSERT INTO engnet_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","The foreigner who resides with you must be to you like a native citizen among you; so you must love him as yourself, because you were foreigners in the land of Egypt. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","You must not do injustice in the regulation of measures, whether of length, weight, or volume. ");
INSERT INTO engnet_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","You must have honest balances, honest weights, an honest ephah, and an honest hin. I am the Lord your God who brought you out from the land of Egypt. ");
INSERT INTO engnet_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","You must be sure to obey all my statutes and regulations. I am the Lord.’” ");
INSERT INTO engnet_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“You are to say to the Israelites, ‘Any man from the Israelites or from the foreigners who reside in Israel who gives any of his children to Molech must be put to death; the people of the land must pelt him with stones. ");
INSERT INTO engnet_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I myself will set my face against that man and cut him off from the midst of his people, because he has given some of his children to Molech and thereby defiled my sanctuary and profaned my holy name. ");
INSERT INTO engnet_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","If, however, the people of the land shut their eyes to that man when he gives some of his children to Molech so that they do not put him to death, ");
INSERT INTO engnet_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","I myself will set my face against that man and his clan. I will cut off from the midst of their people both him and all who follow after him in spiritual prostitution, to commit prostitution by worshiping Molech. ");
INSERT INTO engnet_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘The person who turns to the spirits of the dead and familiar spirits to commit prostitution by going after them, I will set my face against that person and cut him off from the midst of his people. ");
INSERT INTO engnet_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘You must sanctify yourselves and be holy, because I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","You must be sure to obey my statutes. I am the Lord who sanctifies you. ");
INSERT INTO engnet_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘If anyone curses his father and mother he must be put to death. He has cursed his father and mother; his blood guilt is on himself. ");
INSERT INTO engnet_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","If a man commits adultery with his neighbor’s wife, both the adulterer and the adulteress must be put to death. ");
INSERT INTO engnet_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","If a man has sexual intercourse with his father’s wife, he has exposed his father’s nakedness. Both of them must be put to death; their blood guilt is on themselves. ");
INSERT INTO engnet_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","If a man has sexual intercourse with his daughter-in-law, both of them must be put to death. They have committed perversion; their blood guilt is on themselves. ");
INSERT INTO engnet_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","If a man has sexual intercourse with a male as one has sexual intercourse with a woman, the two of them have committed an abomination. They must be put to death; their blood guilt is on themselves. ");
INSERT INTO engnet_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","If a man has sexual intercourse with both a woman and her mother, it is lewdness. Both he and they must be burned to death, so there is no lewdness in your midst. ");
INSERT INTO engnet_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","If a man has sexual intercourse with any animal, he must be put to death, and you must kill the animal. ");
INSERT INTO engnet_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","If a woman approaches any animal to have sexual intercourse with it, you must kill the woman, and the animal must be put to death; their blood guilt is on themselves. ");
INSERT INTO engnet_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘If a man has sexual intercourse with his sister, whether the daughter of his father or his mother, so that he sees her nakedness and she sees his nakedness, it is a disgrace. They must be cut off in the sight of the children of their people. He has exposed his sister’s nakedness; he will bear his punishment for iniquity. ");
INSERT INTO engnet_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","If a man has sexual intercourse with a menstruating woman and uncovers her nakedness, he has laid bare her fountain of blood and she has exposed the fountain of her blood, so both of them must be cut off from the midst of their people. ");
INSERT INTO engnet_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","You must not expose the nakedness of your mother’s sister and your father’s sister, for such a person has laid bare his own close relative. They must bear their punishment for iniquity. ");
INSERT INTO engnet_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","If a man has sexual intercourse with his aunt, he has exposed his uncle’s nakedness; they must bear responsibility for their sin, they will die childless. ");
INSERT INTO engnet_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","If a man has sexual intercourse with his brother’s wife, it is indecency. He has exposed his brother’s nakedness; they will be childless. ");
INSERT INTO engnet_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘You must be sure to obey all my statutes and regulations, so that the land to which I am about to bring you to take up residence there does not vomit you out. ");
INSERT INTO engnet_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","You must not walk in the statutes of the nation which I am about to drive out before you, because they have done all these things and I am filled with disgust against them. ");
INSERT INTO engnet_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","So I have said to you: You yourselves will possess their land and I myself will give it to you for a possession, a land flowing with milk and honey. I am the Lord your God who has set you apart from the other peoples. ");
INSERT INTO engnet_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Therefore you must distinguish between the clean animal and the unclean, and between the unclean bird and the clean, and you must not make yourselves detestable by means of an animal or bird or anything that creeps on the ground – creatures I have distinguished for you as unclean. ");
INSERT INTO engnet_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You must be holy to me because I, the Lord, am holy, and I have set you apart from the other peoples to be mine. ");
INSERT INTO engnet_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘A man or woman who has in them a spirit of the dead or a familiar spirit must be put to death. They must pelt them with stones; their blood guilt is on themselves.’” ");
INSERT INTO engnet_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","The Lord said to Moses: “Say to the priests, the sons of Aaron – say to them, ‘For a dead person no priest is to defile himself among his people, ");
INSERT INTO engnet_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","except for his close relative who is near to him: his mother, his father, his son, his daughter, his brother, ");
INSERT INTO engnet_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","and his virgin sister who is near to him, who has no husband; he may defile himself for her. ");
INSERT INTO engnet_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","He must not defile himself as a husband among his people so as to profane himself. ");
INSERT INTO engnet_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Priests must not have a bald spot shaved on their head, they must not shave the corner of their beard, and they must not cut slashes in their body. ");
INSERT INTO engnet_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","“‘They must be holy to their God, and they must not profane the name of their God, because they are the ones who present the Lord’s gifts, the food of their God. Therefore they must be holy. ");
INSERT INTO engnet_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","They must not take a wife defiled by prostitution, nor are they to take a wife divorced from her husband, for the priest is holy to his God. ");
INSERT INTO engnet_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","You must sanctify him because he presents the food of your God. He must be holy to you because I, the Lord who sanctifies you all, am holy. ");
INSERT INTO engnet_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","If a daughter of a priest profanes herself by engaging in prostitution, she is profaning her father. She must be burned to death. ");
INSERT INTO engnet_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘The high priest – who is greater than his brothers, on whose head the anointing oil is poured, who has been ordained to wear the priestly garments – must neither dishevel the hair of his head nor tear his garments. ");
INSERT INTO engnet_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not go where there is any dead person; he must not defile himself even for his father and his mother. ");
INSERT INTO engnet_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He must not go out from the sanctuary and must not profane the sanctuary of his God, because the dedication of the anointing oil of his God is on him. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","He must take a wife who is a virgin. ");
INSERT INTO engnet_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He must not marry a widow, a divorced woman, or one profaned by prostitution; he may only take a virgin from his people as a wife. ");
INSERT INTO engnet_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","He must not profane his children among his people, for I am the Lord who sanctifies him.’” ");
INSERT INTO engnet_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tell Aaron, ‘No man from your descendants throughout their generations who has a physical flaw is to approach to present the food of his God. ");
INSERT INTO engnet_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Certainly no man who has a physical flaw is to approach: a blind man, or one who is lame, or one with a slit nose, or a limb too long, ");
INSERT INTO engnet_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","or a man who has had a broken leg or arm, ");
INSERT INTO engnet_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","or a hunchback, or a dwarf, or one with a spot in his eye, or a festering eruption, or a feverish rash, or a crushed testicle. ");
INSERT INTO engnet_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No man from the descendants of Aaron the priest who has a physical flaw may step forward to present the Lord’s gifts; he has a physical flaw, so he must not step forward to present the food of his God. ");
INSERT INTO engnet_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He may eat both the most holy and the holy food of his God, ");
INSERT INTO engnet_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","but he must not go into the veil-canopy or step forward to the altar because he has a physical flaw. Thus he must not profane my holy places, for I am the Lord who sanctifies them.’” ");
INSERT INTO engnet_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","So Moses spoke these things to Aaron, his sons, and all the Israelites. ");
INSERT INTO engnet_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons that they must deal respectfully with the holy offerings of the Israelites, which they consecrate to me, so that they do not profane my holy name. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Say to them, ‘Throughout your generations, if any man from all your descendants approaches the holy offerings which the Israelites consecrate to the Lord while he is impure, that person must be cut off from before me. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","No man from the descendants of Aaron who is diseased or has a discharge may eat the holy offerings until he becomes clean. The one who touches anything made unclean by contact with a dead person, or a man who has a seminal emission, ");
INSERT INTO engnet_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or a man who touches a swarming thing by which he becomes unclean, or touches a person by which he becomes unclean, whatever that person’s impurity – ");
INSERT INTO engnet_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","the person who touches any of these will be unclean until evening and must not eat from the holy offerings unless he has bathed his body in water. ");
INSERT INTO engnet_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","When the sun goes down he will be clean, and afterward he may eat from the holy offerings, because they are his food. ");
INSERT INTO engnet_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He must not eat an animal that has died of natural causes or an animal torn by beasts and thus become unclean by it. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","They must keep my charge so that they do not incur sin on account of it and therefore die because they profane it. I am the Lord who sanctifies them. ");
INSERT INTO engnet_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘No lay person may eat anything holy. Neither a priest’s lodger nor a hired laborer may eat anything holy, ");
INSERT INTO engnet_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","but if a priest buys a person with his own money, that person may eat the holy offerings, and those born in the priest’s own house may eat his food. ");
INSERT INTO engnet_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If a priest’s daughter marries a lay person, she may not eat the holy contribution offerings, ");
INSERT INTO engnet_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","but if a priest’s daughter is a widow or divorced, and she has no children so that she returns to live in her father’s house as in her youth, she may eat from her father’s food, but no lay person may eat it. ");
INSERT INTO engnet_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘If a man eats a holy offering by mistake, he must add one fifth to it and give the holy offering to the priest. ");
INSERT INTO engnet_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","They must not profane the holy offerings which the Israelites contribute to the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","and so cause them to incur a penalty for guilt when they eat their holy offerings, for I am the Lord who sanctifies them.’” ");
INSERT INTO engnet_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Speak to Aaron, his sons, and all the Israelites and tell them, ‘When any man from the house of Israel or from the foreigners in Israel presents his offering for any of the votive or freewill offerings which they present to the Lord as a burnt offering, ");
INSERT INTO engnet_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","if it is to be acceptable for your benefit it must be a flawless male from the cattle, sheep, or goats. ");
INSERT INTO engnet_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","You must not present anything that has a flaw, because it will not be acceptable for your benefit. ");
INSERT INTO engnet_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","If a man presents a peace offering sacrifice to the Lord for a special votive offering or for a freewill offering from the herd or the flock, it must be flawless to be acceptable; it must have no flaw. ");
INSERT INTO engnet_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","“‘You must not present to the Lord something blind, or with a broken bone, or mutilated, or with a running sore, or with a festering eruption, or with a feverish rash. You must not give any of these as a gift on the altar to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","As for an ox or a sheep with a limb too long or stunted, you may present it as a freewill offering, but it will not be acceptable for a votive offering. ");
INSERT INTO engnet_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","You must not present to the Lord something with testicles that are bruised, crushed, torn, or cut off; you must not do this in your land. ");
INSERT INTO engnet_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Even from a foreigner you must not present the food of your God from such animals as these, for they are ruined and flawed; they will not be acceptable for your benefit.’” ");
INSERT INTO engnet_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When an ox, lamb, or goat is born, it must be under the care of its mother seven days, but from the eighth day onward it will be acceptable as an offering gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","You must not slaughter an ox or a sheep and its young on the same day. ");
INSERT INTO engnet_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","When you sacrifice a thanksgiving offering to the Lord, you must sacrifice it so that it is acceptable for your benefit. ");
INSERT INTO engnet_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","On that very day it must be eaten; you must not leave any part of it over until morning. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“You must be sure to do my commandments. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","You must not profane my holy name, and I will be sanctified in the midst of the Israelites. I am the Lord who sanctifies you, ");
INSERT INTO engnet_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","the one who brought you out from the land of Egypt to be your God. I am the Lord.” ");
INSERT INTO engnet_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Speak to the Israelites and tell them, ‘These are the Lord’s appointed times which you must proclaim as holy assemblies – my appointed times: ");
INSERT INTO engnet_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Six days work may be done, but on the seventh day there must be a Sabbath of complete rest, a holy assembly. You must not do any work; it is a Sabbath to the Lord in all the places where you live. ");
INSERT INTO engnet_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘These are the Lord’s appointed times, holy assemblies, which you must proclaim at their appointed time. ");
INSERT INTO engnet_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","In the first month, on the fourteenth day of the month, at twilight, is a Passover offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Then on the fifteenth day of the same month will be the festival of unleavened bread to the Lord; seven days you must eat unleavened bread. ");
INSERT INTO engnet_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day there will be a holy assembly for you; you must not do any regular work. ");
INSERT INTO engnet_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","You must present a gift to the Lord for seven days, and the seventh day is a holy assembly; you must not do any regular work.’” ");
INSERT INTO engnet_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Speak to the Israelites and tell them, ‘When you enter the land that I am about to give to you and you gather in its harvest, then you must bring the sheaf of the first portion of your harvest to the priest, ");
INSERT INTO engnet_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","and he must wave the sheaf before the Lord to be accepted for your benefit – on the day after the Sabbath the priest is to wave it. ");
INSERT INTO engnet_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","On the day you wave the sheaf you must also offer a flawless yearling lamb for a burnt offering to the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","along with its grain offering, two tenths of an ephah of choice wheat flour mixed with olive oil, as a gift to the Lord, a soothing aroma, and its drink offering, one fourth of a hin of wine. ");
INSERT INTO engnet_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","You must not eat bread, roasted grain, or fresh grain until this very day, until you bring the offering of your God. This is a perpetual statute throughout your generations in all the places where you live. ");
INSERT INTO engnet_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘You must count for yourselves seven weeks from the day after the Sabbath, from the day you bring the wave offering sheaf; they must be complete weeks. ");
INSERT INTO engnet_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","You must count fifty days – until the day after the seventh Sabbath – and then you must present a new grain offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","From the places where you live you must bring two loaves of bread for a wave offering; they must be made from two tenths of an ephah of fine wheat flour, baked with yeast, as first fruits to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Along with the loaves of bread, you must also present seven flawless yearling lambs, one young bull, and two rams. They are to be a burnt offering to the Lord along with their grain offering and drink offerings, a gift of a soothing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","You must also offer one male goat for a sin offering and two yearling lambs for a peace offering sacrifice, ");
INSERT INTO engnet_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","and the priest is to wave them – the two lambs – along with the bread of the first fruits, as a wave offering before the Lord; they will be holy to the Lord for the priest. ");
INSERT INTO engnet_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","“‘On this very day you must proclaim an assembly; it is to be a holy assembly for you. You must not do any regular work. This is a perpetual statute in all the places where you live throughout your generations. ");
INSERT INTO engnet_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","When you gather in the harvest of your land, you must not completely harvest the corner of your field, and you must not gather up the gleanings of your harvest. You must leave them for the poor and the foreigner. I am the Lord your God.’” ");
INSERT INTO engnet_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tell the Israelites, ‘In the seventh month, on the first day of the month, you must have a complete rest, a memorial announced by loud horn blasts, a holy assembly. ");
INSERT INTO engnet_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","You must not do any regular work, but you must present a gift to the Lord.’” ");
INSERT INTO engnet_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“The tenth day of this seventh month is the Day of Atonement. It is to be a holy assembly for you, and you must humble yourselves and present a gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","You must not do any work on this particular day, because it is a day of atonement to make atonement for yourselves before the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Indeed, any person who does not behave with humility on this particular day will be cut off from his people. ");
INSERT INTO engnet_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","As for any person who does any work on this particular day, I will exterminate that person from the midst of his people! ");
INSERT INTO engnet_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You must not do any work. This is a perpetual statute throughout your generations in all the places where you live. ");
INSERT INTO engnet_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It is a Sabbath of complete rest for you, and you must humble yourselves on the ninth day of the month in the evening, from evening until evening you must observe your Sabbath.” ");
INSERT INTO engnet_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tell the Israelites, ‘On the fifteenth day of this seventh month is the Festival of Temporary Shelters for seven days to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day is a holy assembly; you must do no regular work. ");
INSERT INTO engnet_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","For seven days you must present a gift to the Lord. On the eighth day there is to be a holy assembly for you, and you must present a gift to the Lord. It is a solemn assembly day; you must not do any regular work. ");
INSERT INTO engnet_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘These are the appointed times of the Lord that you must proclaim as holy assemblies to present a gift to the Lord – burnt offering, grain offering, sacrifice, and drink offerings, each day according to its regulation, ");
INSERT INTO engnet_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","besides the Sabbaths of the Lord and all your gifts, votive offerings, and freewill offerings which you must give to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘On the fifteenth day of the seventh month, when you gather in the produce of the land, you must celebrate a pilgrim festival of the Lord for seven days. On the first day is a complete rest and on the eighth day is complete rest. ");
INSERT INTO engnet_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day you must take for yourselves branches from majestic trees – palm branches, branches of leafy trees, and willows of the brook – and you must rejoice before the Lord your God for seven days. ");
INSERT INTO engnet_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You must celebrate it as a pilgrim festival to the Lord for seven days in the year. This is a perpetual statute throughout your generations; you must celebrate it in the seventh month. ");
INSERT INTO engnet_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You must live in temporary shelters for seven days; every native citizen in Israel must live in temporary shelters, ");
INSERT INTO engnet_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","so that your future generations may know that I made the Israelites live in temporary shelters when I brought them out from the land of Egypt. I am the Lord your God.’” ");
INSERT INTO engnet_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses spoke to the Israelites about the appointed times of the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the Israelites to bring to you pure oil of beaten olives for the light, to make a lamp burn continually. ");
INSERT INTO engnet_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the veil-canopy of the congregation in the Meeting Tent Aaron must arrange it from evening until morning before the Lord continually. This is a perpetual statute throughout your generations. ");
INSERT INTO engnet_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","On the ceremonially pure lampstand he must arrange the lamps before the Lord continually. ");
INSERT INTO engnet_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“You must take choice wheat flour and bake twelve loaves; there must be two tenths of an ephah of flour in each loaf, ");
INSERT INTO engnet_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","and you must set them in two rows, six in a row, on the ceremonially pure table before the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","You must put pure frankincense on each row, and it will become a memorial portion for the bread, a gift to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Each Sabbath day Aaron must arrange it before the Lord continually; this portion is from the Israelites as a perpetual covenant. ");
INSERT INTO engnet_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","It will belong to Aaron and his sons, and they must eat it in a holy place because it is most holy to him, a perpetual allotted portion from the gifts of the Lord.” ");
INSERT INTO engnet_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Now an Israelite woman’s son whose father was an Egyptian went out among the Israelites, and the Israelite woman’s son and an Israelite man had a fight in the camp. ");
INSERT INTO engnet_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The Israelite woman’s son misused the Name and cursed, so they brought him to Moses. (Now his mother’s name was Shelomith daughter of Dibri, of the tribe of Dan.) ");
INSERT INTO engnet_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","So they placed him in custody until they were able to make a clear legal decision for themselves based on words from the mouth of the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Bring the one who cursed outside the camp, and all who heard him are to lay their hands on his head, and the whole congregation is to stone him to death. ");
INSERT INTO engnet_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Moreover, you are to tell the Israelites, ‘If any man curses his God he will bear responsibility for his sin, ");
INSERT INTO engnet_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","and one who misuses the name of the Lord must surely be put to death. The whole congregation must surely stone him, whether he is a foreigner or a native citizen; when he misuses the Name he must be put to death. ");
INSERT INTO engnet_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘If a man beats any person to death, he must be put to death. ");
INSERT INTO engnet_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","One who beats an animal to death must make restitution for it, life for life. ");
INSERT INTO engnet_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","If a man inflicts an injury on his fellow citizen, just as he has done it must be done to him – ");
INSERT INTO engnet_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture for fracture, eye for eye, tooth for tooth – just as he inflicts an injury on another person that same injury must be inflicted on him. ");
INSERT INTO engnet_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","One who beats an animal to death must make restitution for it, but one who beats a person to death must be put to death. ");
INSERT INTO engnet_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","There will be one regulation for you, whether a foreigner or a native citizen, for I am the Lord your God.’” ");
INSERT INTO engnet_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Then Moses spoke to the Israelites and they brought the one who cursed outside the camp and stoned him with stones. So the Israelites did just as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","The Lord spoke to Moses at Mount Sinai: ");
INSERT INTO engnet_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Speak to the Israelites and tell them, ‘When you enter the land that I am giving you, the land must observe a Sabbath to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Six years you may sow your field, and six years you may prune your vineyard and gather the produce, ");
INSERT INTO engnet_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","but in the seventh year the land must have a Sabbath of complete rest – a Sabbath to the Lord. You must not sow your field or prune your vineyard. ");
INSERT INTO engnet_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","You must not gather in the aftergrowth of your harvest and you must not pick the grapes of your unpruned vines; the land must have a year of complete rest. ");
INSERT INTO engnet_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","You may have the Sabbath produce of the land to eat – you, your male servant, your female servant, your hired worker, the resident foreigner who stays with you, ");
INSERT INTO engnet_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","your cattle, and the wild animals that are in your land – all its produce will be for you to eat. ");
INSERT INTO engnet_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘You must count off seven weeks of years, seven times seven years, and the days of the seven weeks of years will amount to forty-nine years. ");
INSERT INTO engnet_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","You must sound loud horn blasts – in the seventh month, on the tenth day of the month, on the Day of Atonement – you must sound the horn in your entire land. ");
INSERT INTO engnet_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","So you must consecrate the fiftieth year, and you must proclaim a release in the land for all its inhabitants. That year will be your jubilee; each one of you must return to his property and each one of you must return to his clan. ");
INSERT INTO engnet_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","That fiftieth year will be your jubilee; you must not sow the land, harvest its aftergrowth, or pick the grapes of its unpruned vines. ");
INSERT INTO engnet_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Because that year is a jubilee, it will be holy to you – you may eat its produce from the field. ");
INSERT INTO engnet_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘In this year of jubilee you must each return to your property. ");
INSERT INTO engnet_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","If you make a sale to your fellow citizen or buy from your fellow citizen, no one is to wrong his brother. ");
INSERT INTO engnet_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","You may buy it from your fellow citizen according to the number of years since the last jubilee; he may sell it to you according to the years of produce that are left. ");
INSERT INTO engnet_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","The more years there are, the more you may make its purchase price, and the fewer years there are, the less you must make its purchase price, because he is only selling to you a number of years of produce. ");
INSERT INTO engnet_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","No one is to oppress his fellow citizen, but you must fear your God, because I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","You must obey my statutes and my regulations; you must be sure to keep them so that you may live securely in the land. ");
INSERT INTO engnet_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","“‘The land will give its fruit and you may eat until you are satisfied, and you may live securely in the land. ");
INSERT INTO engnet_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","If you say, ‘What will we eat in the seventh year if we do not sow and gather our produce?’ ");
INSERT INTO engnet_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I will command my blessing for you in the sixth year so that it may yield the produce for three years, ");
INSERT INTO engnet_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","and you may sow the eighth year and eat from that sixth year’s produce – old produce. Until you bring in the ninth year’s produce, you may eat old produce. ");
INSERT INTO engnet_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","The land must not be sold without reclaim because the land belongs to me, for you are foreigners and residents with me. ");
INSERT INTO engnet_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","In all your landed property you must provide for the right of redemption of the land. ");
INSERT INTO engnet_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“‘If your brother becomes impoverished and sells some of his property, his near redeemer is to come to you and redeem what his brother sold. ");
INSERT INTO engnet_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","If a man has no redeemer, but he prospers and gains enough for its redemption, ");
INSERT INTO engnet_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","he is to calculate the value of the years it was sold, refund the balance to the man to whom he had sold it, and return to his property. ");
INSERT INTO engnet_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","If he has not prospered enough to refund a balance to him, then what he sold will belong to the one who bought it until the jubilee year, but it must revert in the jubilee and the original owner may return to his property. ");
INSERT INTO engnet_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“‘If a man sells a residential house in a walled city, its right of redemption must extend until one full year from its sale; its right of redemption must extend to a full calendar year. ");
INSERT INTO engnet_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If it is not redeemed before the full calendar year is ended, the house in the walled city will belong without reclaim to the one who bought it throughout his generations; it will not revert in the jubilee. ");
INSERT INTO engnet_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","The houses of villages, however, which have no wall surrounding them must be considered as the field of the land; they will have the right of redemption and must revert in the jubilee. ");
INSERT INTO engnet_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","As for the cities of the Levites, the houses in the cities which they possess, the Levites must have a perpetual right of redemption. ");
INSERT INTO engnet_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Whatever someone among the Levites might redeem – the sale of a house which is his property in a city – must revert in the jubilee, because the houses of the cities of the Levites are their property in the midst of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Moreover, the open field areas of their cities must not be sold, because that is their perpetual possession. ");
INSERT INTO engnet_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“‘If your brother becomes impoverished and is indebted to you, you must support him; he must live with you like a foreign resident. ");
INSERT INTO engnet_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Do not take interest or profit from him, but you must fear your God and your brother must live with you. ");
INSERT INTO engnet_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","You must not lend him your money at interest and you must not sell him food for profit. ");
INSERT INTO engnet_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the Lord your God who brought you out from the land of Egypt to give you the land of Canaan – to be your God. ");
INSERT INTO engnet_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“‘If your brother becomes impoverished with regard to you so that he sells himself to you, you must not subject him to slave service. ");
INSERT INTO engnet_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","He must be with you as a hired worker, as a resident foreigner; he must serve with you until the year of jubilee, ");
INSERT INTO engnet_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","but then he may go free, he and his children with him, and may return to his family and to the property of his ancestors. ");
INSERT INTO engnet_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Since they are my servants whom I brought out from the land of Egypt, they must not be sold in a slave sale. ");
INSERT INTO engnet_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","You must not rule over him harshly, but you must fear your God. ");
INSERT INTO engnet_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“‘As for your male and female slaves who may belong to you – you may buy male and female slaves from the nations all around you. ");
INSERT INTO engnet_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Also you may buy slaves from the children of the foreigners who reside with you, and from their families that are with you, whom they have fathered in your land, they may become your property. ");
INSERT INTO engnet_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You may give them as inheritance to your children after you to possess as property. You may enslave them perpetually. However, as for your brothers the Israelites, no man may rule over his brother harshly. ");
INSERT INTO engnet_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“‘If a resident foreigner who is with you prospers and your brother becomes impoverished with regard to him so that he sells himself to a resident foreigner who is with you or to a member of a foreigner’s family, ");
INSERT INTO engnet_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","after he has sold himself he retains a right of redemption. One of his brothers may redeem him, ");
INSERT INTO engnet_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","or his uncle or his cousin may redeem him, or anyone of the rest of his blood relatives – his family – may redeem him, or if he prospers he may redeem himself. ");
INSERT INTO engnet_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","He must calculate with the one who bought him the number of years from the year he sold himself to him until the jubilee year, and the cost of his sale must correspond to the number of years, according to the rate of wages a hired worker would have earned while with him. ");
INSERT INTO engnet_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are still many years, in keeping with them he must refund most of the cost of his purchase for his redemption, ");
INSERT INTO engnet_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","but if only a few years remain until the jubilee, he must calculate for himself in keeping with the remaining years and refund it for his redemption. ");
INSERT INTO engnet_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","He must be with the one who bought him like a yearly hired worker. The one who bought him must not rule over him harshly in your sight. ");
INSERT INTO engnet_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","If, however, he is not redeemed in these ways, he must go free in the jubilee year, he and his children with him, ");
INSERT INTO engnet_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","because the Israelites are my own servants; they are my servants whom I brought out from the land of Egypt. I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“‘You must not make for yourselves idols, so you must not set up for yourselves a carved image or a pillar, and you must not place a sculpted stone in your land to bow down before it, for I am the Lord your God. ");
INSERT INTO engnet_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","You must keep my Sabbaths and reverence my sanctuary. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“‘If you walk in my statutes and are sure to obey my commandments, ");
INSERT INTO engnet_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","I will give you your rains in their time so that the land will give its yield and the trees of the field will produce their fruit. ");
INSERT INTO engnet_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Threshing season will extend for you until the season for harvesting grapes, and the season for harvesting grapes will extend until sowing season, so you will eat your bread until you are satisfied, and you will live securely in your land. ");
INSERT INTO engnet_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","I will grant peace in the land so that you will lie down to sleep without anyone terrifying you. I will remove harmful animals from the land, and no sword of war will pass through your land. ");
INSERT INTO engnet_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You will pursue your enemies and they will fall before you by the sword. ");
INSERT INTO engnet_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will pursue a hundred, and a hundred of you will pursue ten thousand, and your enemies will fall before you by the sword. ");
INSERT INTO engnet_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I will turn to you, make you fruitful, multiply you, and maintain my covenant with you. ");
INSERT INTO engnet_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You will still be eating stored produce from the previous year and will have to clean out what is stored from the previous year to make room for new. ");
INSERT INTO engnet_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","“‘I will put my tabernacle in your midst and I will not abhor you. ");
INSERT INTO engnet_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk among you, and I will be your God and you will be my people. ");
INSERT INTO engnet_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the Lord your God who brought you out from the land of Egypt, from being their slaves, and I broke the bars of your yoke and caused you to walk upright. ");
INSERT INTO engnet_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“‘If, however, you do not obey me and keep all these commandments – ");
INSERT INTO engnet_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","if you reject my statutes and abhor my regulations so that you do not keep all my commandments and you break my covenant – ");
INSERT INTO engnet_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","I for my part will do this to you: I will inflict horror on you, consumption and fever, which diminish eyesight and drain away the vitality of life. You will sow your seed in vain because your enemies will eat it. ");
INSERT INTO engnet_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will set my face against you. You will be struck down before your enemies, those who hate you will rule over you, and you will flee when there is no one pursuing you. ");
INSERT INTO engnet_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“‘If, in spite of all these things, you do not obey me, I will discipline you seven times more on account of your sins. ");
INSERT INTO engnet_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will break your strong pride and make your sky like iron and your land like bronze. ");
INSERT INTO engnet_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Your strength will be used up in vain, your land will not give its yield, and the trees of the land will not produce their fruit. ");
INSERT INTO engnet_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“‘If you walk in hostility against me and are not willing to obey me, I will increase your affliction seven times according to your sins. ");
INSERT INTO engnet_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send the wild animals against you and they will bereave you of your children, annihilate your cattle, and diminish your population so that your roads will become deserted. ");
INSERT INTO engnet_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“‘If in spite of these things you do not allow yourselves to be disciplined and you walk in hostility against me, ");
INSERT INTO engnet_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","I myself will also walk in hostility against you and strike you seven times on account of your sins. ");
INSERT INTO engnet_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I will bring on you an avenging sword, a covenant vengeance. Although you will gather together into your cities, I will send pestilence among you and you will be given into enemy hands. ");
INSERT INTO engnet_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I break off your supply of bread, ten women will bake your bread in one oven; they will ration your bread by weight, and you will eat and not be satisfied. ");
INSERT INTO engnet_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“‘If in spite of this you do not obey me but walk in hostility against me, ");
INSERT INTO engnet_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","I will walk in hostile rage against you and I myself will also discipline you seven times on account of your sins. ");
INSERT INTO engnet_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will eat the flesh of your sons and the flesh of your daughters. ");
INSERT INTO engnet_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places and cut down your incense altars, and I will stack your dead bodies on top of the lifeless bodies of your idols. I will abhor you. ");
INSERT INTO engnet_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will lay your cities waste and make your sanctuaries desolate, and I will refuse to smell your soothing aromas. ");
INSERT INTO engnet_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I myself will make the land desolate and your enemies who live in it will be appalled. ");
INSERT INTO engnet_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I will scatter you among the nations and unsheathe the sword after you, so your land will become desolate and your cities will become a waste. ");
INSERT INTO engnet_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“‘Then the land will make up for its Sabbaths all the days it lies desolate while you are in the land of your enemies; then the land will rest and make up its Sabbaths. ");
INSERT INTO engnet_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","All the days of the desolation it will have the rest it did not have on your Sabbaths when you lived on it. ");
INSERT INTO engnet_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“‘As for the ones who remain among you, I will bring despair into their hearts in the lands of their enemies. The sound of a blowing leaf will pursue them, and they will flee as one who flees the sword and fall down even though there is no pursuer. ");
INSERT INTO engnet_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","They will stumble over each other as those who flee before a sword, though there is no pursuer, and there will be no one to take a stand for you before your enemies. ");
INSERT INTO engnet_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You will perish among the nations; the land of your enemies will consume you. ");
INSERT INTO engnet_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","“‘As for the ones who remain among you, they will rot away because of their iniquity in the lands of your enemies, and they will also rot away because of their ancestors’ iniquities which are with them. ");
INSERT INTO engnet_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","However, when they confess their iniquity and their ancestors’ iniquity which they committed by trespassing against me, by which they also walked in hostility against me ");
INSERT INTO engnet_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","(and I myself will walk in hostility against them and bring them into the land of their enemies), and then their uncircumcised hearts become humbled and they make up for their iniquity, ");
INSERT INTO engnet_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","I will remember my covenant with Jacob and also my covenant with Isaac and also my covenant with Abraham, and I will remember the land. ");
INSERT INTO engnet_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","The land will be abandoned by them in order that it may make up for its Sabbaths while it is made desolate without them, and they will make up for their iniquity because they have rejected my regulations and have abhorred my statutes. ");
INSERT INTO engnet_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","In spite of this, however, when they are in the land of their enemies I will not reject them and abhor them to make a complete end of them, to break my covenant with them, for I am the Lord their God. ");
INSERT INTO engnet_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","I will remember for them the covenant with their ancestors whom I brought out from the land of Egypt in the sight of the nations to be their God. I am the Lord.’” ");
INSERT INTO engnet_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the statutes, regulations, and instructions which the Lord established between himself and the Israelites at Mount Sinai through Moses. ");
INSERT INTO engnet_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Speak to the Israelites and tell them, ‘When a man makes a special votive offering based on the conversion value of persons to the Lord, ");
INSERT INTO engnet_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","the conversion value of the male from twenty years old up to sixty years old is fifty shekels by the standard of the sanctuary shekel. ");
INSERT INTO engnet_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","If the person is a female, the conversion value is thirty shekels. ");
INSERT INTO engnet_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","If the person is from five years old up to twenty years old, the conversion value of the male is twenty shekels, and for the female ten shekels. ");
INSERT INTO engnet_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","If the person is one month old up to five years old, the conversion value of the male is five shekels of silver, and for the female the conversion value is three shekels of silver. ");
INSERT INTO engnet_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","If the person is from sixty years old and older, if he is a male the conversion value is fifteen shekels, and for the female ten shekels. ");
INSERT INTO engnet_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","If he is too poor to pay the conversion value, he must stand the person before the priest and the priest will establish his conversion value; according to what the man who made the vow can afford, the priest will establish his conversion value. ");
INSERT INTO engnet_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘If what is vowed is a kind of animal from which an offering may be presented to the Lord, anything which he gives to the Lord from this kind of animal will be holy. ");
INSERT INTO engnet_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He must not replace or exchange it, good for bad or bad for good, and if he does indeed exchange one animal for another animal, then both the original animal and its substitute will be holy. ");
INSERT INTO engnet_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","If what is vowed is an unclean animal from which an offering must not be presented to the Lord, then he must stand the animal before the priest, ");
INSERT INTO engnet_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","and the priest will establish its conversion value, whether good or bad. According to the assessed conversion value of the priest, thus it will be. ");
INSERT INTO engnet_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If, however, the person who made the vow redeems the animal, he must add one fifth to its conversion value. ");
INSERT INTO engnet_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘If a man consecrates his house as holy to the Lord, the priest will establish its conversion value, whether good or bad. Just as the priest establishes its conversion value, thus it will stand. ");
INSERT INTO engnet_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","If the one who consecrates it redeems his house, he must add to it one fifth of its conversion value in silver, and it will belong to him. ");
INSERT INTO engnet_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘If a man consecrates to the Lord some of his own landed property, the conversion value must be calculated in accordance with the amount of seed needed to sow it, a homer of barley seed being priced at fifty shekels of silver. ");
INSERT INTO engnet_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he consecrates his field in the jubilee year, the conversion value will stand, ");
INSERT INTO engnet_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","but if he consecrates his field after the jubilee, the priest will calculate the price for him according to the years that are left until the next jubilee year, and it will be deducted from the conversion value. ");
INSERT INTO engnet_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","If, however, the one who consecrated the field redeems it, he must add to it one fifth of the conversion price and it will belong to him. ");
INSERT INTO engnet_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","If he does not redeem the field, but sells the field to someone else, he may never redeem it. ");
INSERT INTO engnet_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","When it reverts in the jubilee, the field will be holy to the Lord like a permanently dedicated field; it will become the priest’s property. ");
INSERT INTO engnet_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘If he consecrates to the Lord a field he has purchased, which is not part of his own landed property, ");
INSERT INTO engnet_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","the priest will calculate for him the amount of its conversion value until the jubilee year, and he must pay the conversion value on that jubilee day as something that is holy to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the jubilee year the field will return to the one from whom he bought it, the one to whom it belongs as landed property. ");
INSERT INTO engnet_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Every conversion value must be calculated by the standard of the sanctuary shekel; twenty gerahs to the shekel. ");
INSERT INTO engnet_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘Surely no man may consecrate a firstborn that already belongs to the Lord as a firstborn among the animals; whether it is an ox or a sheep, it belongs to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","If, however, it is among the unclean animals, he may ransom it according to its conversion value and must add one fifth to it, but if it is not redeemed it must be sold according to its conversion value. ");
INSERT INTO engnet_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘Surely anything which a man permanently dedicates to the Lord from all that belongs to him, whether from people, animals, or his landed property, must be neither sold nor redeemed; anything permanently dedicated is most holy to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Any human being who is permanently dedicated must not be ransomed; such a person must be put to death. ");
INSERT INTO engnet_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘Any tithe of the land, from the grain of the land or from the fruit of the trees, belongs to the Lord; it is holy to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If a man redeems part of his tithe, however, he must add one fifth to it. ");
INSERT INTO engnet_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","All the tithe of herd or flock, everything which passes under the rod, the tenth one will be holy to the Lord. ");
INSERT INTO engnet_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","The owner must not examine the animals to distinguish between good and bad, and he must not exchange it. If, however, he does exchange it, both the original animal and its substitute will be holy. It must not be redeemed.’” ");
INSERT INTO engnet_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commandments which the Lord commanded Moses to tell the Israelites at Mount Sinai. ");
INSERT INTO engnet_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Now the Lord spoke to Moses in the tent of meeting in the wilderness of Sinai on the first day of the second month of the second year after the Israelites departed from the land of Egypt. He said: ");
INSERT INTO engnet_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Take a census of the entire Israelite community by their clans and families, counting the name of every individual male. ");
INSERT INTO engnet_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","You and Aaron are to number all in Israel who can serve in the army, those who are twenty years old or older, by their divisions. ");
INSERT INTO engnet_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","And to help you there is to be a man from each tribe, each man the head of his family. ");
INSERT INTO engnet_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Now these are the names of the men who are to help you: from Reuben, Elizur son of Shedeur; ");
INSERT INTO engnet_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","from Simeon, Shelumiel son of Zurishaddai; ");
INSERT INTO engnet_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","from Judah, Nahshon son of Amminadab; ");
INSERT INTO engnet_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","from Issachar, Nethanel son of Zuar; ");
INSERT INTO engnet_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","from Zebulun, Eliab son of Helon; ");
INSERT INTO engnet_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","from the sons of Joseph: from Ephraim, Elishama son of Ammihud; from Manasseh, Gamaliel son of Pedahzur; ");
INSERT INTO engnet_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","from Benjamin, Abidan son of Gideoni; ");
INSERT INTO engnet_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","from Dan, Ahiezer son of Ammishaddai; ");
INSERT INTO engnet_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","from Asher, Pagiel son of Ocran; ");
INSERT INTO engnet_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","from Gad, Eliasaph son of Deuel; ");
INSERT INTO engnet_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","from Naphtali, Ahira son of Enan.” ");
INSERT INTO engnet_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These were the ones chosen from the community, leaders of their ancestral tribes. They were the heads of the thousands of Israel. ");
INSERT INTO engnet_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","So Moses and Aaron took these men who had been mentioned specifically by name, ");
INSERT INTO engnet_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and they assembled the entire community together on the first day of the second month. Then the people recorded their ancestry by their clans and families, and the men who were twenty years old or older were listed by name individually, ");
INSERT INTO engnet_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","just as the Lord had commanded Moses. And so he numbered them in the wilderness of Sinai. ");
INSERT INTO engnet_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","And they were as follows: The descendants of Reuben, the firstborn son of Israel: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name individually. ");
INSERT INTO engnet_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Those of them who were numbered from the tribe of Reuben were 46,500. ");
INSERT INTO engnet_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","From the descendants of Simeon: According to the records of their clans and families, all the males numbered of them twenty years old or older who could serve in the army were listed by name individually. ");
INSERT INTO engnet_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Those of them who were numbered from the tribe of Simeon were 59,300. ");
INSERT INTO engnet_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","From the descendants of Gad: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Those of them who were numbered from the tribe of Gad were 45,650. ");
INSERT INTO engnet_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","From the descendants of Judah: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Those of them who were numbered from the tribe of Judah were 74,600. ");
INSERT INTO engnet_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","From the descendants of Issachar: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Those of them who were numbered from the tribe of Issachar were 54,400. ");
INSERT INTO engnet_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","From the descendants of Zebulun: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Those of them who were numbered from the tribe of Zebulun were 57,400. ");
INSERT INTO engnet_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","From the sons of Joseph: From the descendants of Ephraim: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Those of them who were numbered from the tribe of Ephraim were 40,500. ");
INSERT INTO engnet_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","From the descendants of Manasseh: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Those of them who were numbered from the tribe of Manasseh were 32,200. ");
INSERT INTO engnet_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","From the descendants of Benjamin: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Those of them who were numbered from the tribe of Benjamin were 35,400. ");
INSERT INTO engnet_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","From the descendants of Dan: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Those of them who were numbered from the tribe of Dan were 62,700. ");
INSERT INTO engnet_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","From the descendants of Asher: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Those of them who were numbered from the tribe of Asher were 41,500. ");
INSERT INTO engnet_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","From the descendants of Naphtali: According to the records of their clans and families, all the males twenty years old or older who could serve in the army were listed by name. ");
INSERT INTO engnet_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Those of them who were numbered from the tribe of Naphtali were 53,400. ");
INSERT INTO engnet_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These were the men whom Moses and Aaron numbered along with the twelve leaders of Israel, each of whom was from his own family. ");
INSERT INTO engnet_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","All the Israelites who were twenty years old or older, who could serve in Israel’s army, were numbered according to their families. ");
INSERT INTO engnet_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","And all those numbered totaled 603,550. ");
INSERT INTO engnet_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","But the Levites, according to the tribe of their fathers, were not numbered among them. ");
INSERT INTO engnet_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","The Lord had said to Moses, ");
INSERT INTO engnet_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Only the tribe of Levi you must not number or count with the other Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","But appoint the Levites over the tabernacle of the testimony, over all its furnishings and over everything in it. They must carry the tabernacle and all its furnishings; and they must attend to it and camp around it. ");
INSERT INTO engnet_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Whenever the tabernacle is to move, the Levites must take it down, and whenever the tabernacle is to be reassembled, the Levites must set it up. Any unauthorized person who approaches it must be killed. ");
INSERT INTO engnet_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","“The Israelites will camp according to their divisions, each man in his camp, and each man by his standard. ");
INSERT INTO engnet_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levites must camp around the tabernacle of the testimony, so that the Lord’s anger will not fall on the Israelite community. The Levites are responsible for the care of the tabernacle of the testimony.” ");
INSERT INTO engnet_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","The Israelites did according to all that the Lord commanded Moses – that is what they did. ");
INSERT INTO engnet_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","The Lord spoke to Moses and to Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Every one of the Israelites must camp under his standard with the emblems of his family; they must camp at some distance around the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Now those who will be camping on the east, toward the sunrise, are the divisions of the camp of Judah under their standard. The leader of the people of Judah is Nahshon son of Amminadab. ");
INSERT INTO engnet_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Those numbered in his division are 74,600. ");
INSERT INTO engnet_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Those who will be camping next to them are the tribe of Issachar. The leader of the people of Issachar is Nethanel son of Zuar. ");
INSERT INTO engnet_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Those numbered in his division are 54,400. ");
INSERT INTO engnet_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Next will be the tribe of Zebulun. The leader of the people of Zebulun is Eliab son of Helon. ");
INSERT INTO engnet_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Those numbered in his division are 57,400. ");
INSERT INTO engnet_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","All those numbered of the camp of Judah, according to their divisions, are 186,400. They will travel at the front. ");
INSERT INTO engnet_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“On the south will be the divisions of the camp of Reuben under their standard. The leader of the people of Reuben is Elizur son of Shedeur. ");
INSERT INTO engnet_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Those numbered in his division are 46,500. ");
INSERT INTO engnet_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Those who will be camping next to them are the tribe of Simeon. The leader of the people of Simeon is Shelumiel son of Zurishaddai. ");
INSERT INTO engnet_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Those numbered in his division are 59,300. ");
INSERT INTO engnet_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Next will be the tribe of Gad. The leader of the people of Gad is Eliasaph son of Deuel. ");
INSERT INTO engnet_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Those numbered in his division are 45,650. ");
INSERT INTO engnet_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","All those numbered of the camp of Reuben, according to their divisions, are 151,450. They will travel second. ");
INSERT INTO engnet_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Then the tent of meeting with the camp of the Levites will travel in the middle of the camps. They will travel in the same order as they camped, each in his own place under his standard. ");
INSERT INTO engnet_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“On the west will be the divisions of the camp of Ephraim under their standard. The leader of the people of Ephraim is Elishama son of Amihud. ");
INSERT INTO engnet_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Those numbered in his division are 40,500. ");
INSERT INTO engnet_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Next to them will be the tribe of Manasseh. The leader of the people of Manasseh is Gamaliel son of Pedahzur. ");
INSERT INTO engnet_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Those numbered in his division are 32,200. ");
INSERT INTO engnet_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Next will be the tribe of Benjamin. The leader of the people of Benjamin is Abidan son of Gideoni. ");
INSERT INTO engnet_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Those numbered in his division are 35,400. ");
INSERT INTO engnet_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","All those numbered of the camp of Ephraim, according to their divisions, are 108,100. They will travel third. ");
INSERT INTO engnet_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“On the north will be the divisions of the camp of Dan, under their standards. The leader of the people of Dan is Ahiezer son of Ammishaddai. ");
INSERT INTO engnet_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Those numbered in his division are 62,700. ");
INSERT INTO engnet_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Those who will be camping next to them are the tribe of Asher. The leader of the people of Asher is Pagiel son of Ocran. ");
INSERT INTO engnet_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Those numbered in his division are 41,500. ");
INSERT INTO engnet_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Next will be the tribe of Naphtali. The leader of the people of Naphtali is Ahira son of Enan. ");
INSERT INTO engnet_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Those numbered in his division are 53,400. ");
INSERT INTO engnet_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","All those numbered of the camp of Dan are 157,600. They will travel last, under their standards.” ");
INSERT INTO engnet_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are the Israelites, numbered according to their families. All those numbered in the camps, by their divisions, are 603,550. ");
INSERT INTO engnet_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levites were not numbered among the other Israelites, as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","So the Israelites did according to all that the Lord commanded Moses; that is the way they camped under their standards, and that is the way they traveled, each with his clan and family. ");
INSERT INTO engnet_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Now these are the records of Aaron and Moses when the Lord spoke with Moses on Mount Sinai. ");
INSERT INTO engnet_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","These are the names of the sons of Aaron: Nadab, the firstborn, and Abihu, Eleazar, and Ithamar. ");
INSERT INTO engnet_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These are the names of the sons of Aaron, the anointed priests, whom he consecrated to minister as priests. ");
INSERT INTO engnet_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab and Abihu died before the Lord when they offered strange fire before the Lord in the wilderness of Sinai, and they had no children. So Eleazar and Ithamar ministered as priests in the presence of Aaron their father. ");
INSERT INTO engnet_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring the tribe of Levi near, and present them before Aaron the priest, that they may serve him. ");
INSERT INTO engnet_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They are responsible for his needs and the needs of the whole community before the tent of meeting, by attending to the service of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","And they are responsible for all the furnishings of the tent of meeting, and for the needs of the Israelites, as they serve in the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","You are to assign the Levites to Aaron and his sons; they will be assigned exclusively to him out of all the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","So you are to appoint Aaron and his sons, and they will be responsible for their priesthood; but the unauthorized person who comes near must be put to death.” ");
INSERT INTO engnet_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Look, I myself have taken the Levites from among the Israelites instead of every firstborn who opens the womb among the Israelites. So the Levites belong to me, ");
INSERT INTO engnet_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","because all the firstborn are mine. When I destroyed all the firstborn in the land of Egypt, I set apart for myself all the firstborn in Israel, both man and beast. They belong to me. I am the Lord.” ");
INSERT INTO engnet_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Then the Lord spoke to Moses in the wilderness of Sinai: ");
INSERT INTO engnet_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Number the Levites by their clans and their families; every male from a month old and upward you are to number.” ");
INSERT INTO engnet_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses numbered them according to the word of the Lord, just as he had been commanded. ");
INSERT INTO engnet_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","These were the sons of Levi by their names: Gershon, Kohath, and Merari. ");
INSERT INTO engnet_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","These are the names of the sons of Gershon by their families: Libni and Shimei. ");
INSERT INTO engnet_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","The sons of Kohath by their families were: Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engnet_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","The sons of Merari by their families were Mahli and Mushi. These are the families of the Levites by their clans. ");
INSERT INTO engnet_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","From Gershon came the family of the Libnites and the family of the Shimeites; these were the families of the Gershonites. ");
INSERT INTO engnet_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Those of them who were numbered, counting every male from a month old and upward, were 7,500. ");
INSERT INTO engnet_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The families of the Gershonites were to camp behind the tabernacle toward the west. ");
INSERT INTO engnet_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Now the leader of the clan of the Gershonites was Eliasaph son of Lael. ");
INSERT INTO engnet_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","And the responsibilities of the Gershonites in the tent of meeting included the tabernacle, the tent with its covering, the curtain at the entrance of the tent of meeting, ");
INSERT INTO engnet_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","the hangings of the courtyard, the curtain at the entrance to the courtyard that surrounded the tabernacle and the altar, and their ropes, plus all the service connected with these things. ");
INSERT INTO engnet_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","From Kohath came the family of the Amramites, the family of the Izharites, the family of the Hebronites, and the family of the Uzzielites; these were the families of the Kohathites. ");
INSERT INTO engnet_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Counting every male from a month old and upward, there were 8,600. They were responsible for the care of the sanctuary. ");
INSERT INTO engnet_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The families of the Kohathites were to camp on the south side of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Now the leader of the clan of the families of the Kohathites was Elizaphan son of Uzziel. ");
INSERT INTO engnet_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Their responsibilities included the ark, the table, the lampstand, the altars, and the utensils of the sanctuary with which they ministered, the curtain, and all their service. ");
INSERT INTO engnet_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Now the head of all the Levitical leaders was Eleazar son of Aaron the priest. He was appointed over those who were responsible for the sanctuary. ");
INSERT INTO engnet_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","From Merari came the family of the Mahlites and the family of the Mushites; these were the families of Merari. ");
INSERT INTO engnet_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Those of them who were numbered, counting every male from a month old and upward, were 6,200. ");
INSERT INTO engnet_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Now the leader of the clan of the families of Merari was Zuriel son of Abihail. These were to camp on the north side of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The appointed responsibilities of the Merarites included the frames of the tabernacle, its crossbars, its posts, its sockets, its utensils, plus all the service connected with these things, ");
INSERT INTO engnet_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","and the pillars of the courtyard all around, with their sockets, their pegs, and their ropes. ");
INSERT INTO engnet_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","But those who were to camp in front of the tabernacle on the east, in front of the tent of meeting, were Moses, Aaron, and his sons. They were responsible for the needs of the sanctuary and for the needs of the Israelites, but the unauthorized person who approached was to be put to death. ");
INSERT INTO engnet_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","All who were numbered of the Levites, whom Moses and Aaron numbered by the word of the Lord, according to their families, every male from a month old and upward, were 22,000. ");
INSERT INTO engnet_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Then the Lord said to Moses, “Number all the firstborn males of the Israelites from a month old and upward, and take the number of their names. ");
INSERT INTO engnet_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","And take the Levites for me – I am the Lord – instead of all the firstborn males among the Israelites, and the livestock of the Levites instead of all the firstborn of the livestock of the Israelites.” ");
INSERT INTO engnet_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","So Moses numbered all the firstborn males among the Israelites, as the Lord had commanded him. ");
INSERT INTO engnet_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","And all the firstborn males, by the number of the names from a month old and upward, totaled 22,273. ");
INSERT INTO engnet_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Take the Levites instead of all the firstborn males among the Israelites, and the livestock of the Levites instead of their livestock. And the Levites will be mine. I am the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","And for the redemption of the 273 firstborn males of the Israelites who exceed the number of the Levites, ");
INSERT INTO engnet_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","collect five shekels for each one individually; you are to collect this amount in the currency of the sanctuary shekel (this shekel is twenty gerahs). ");
INSERT INTO engnet_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","And give the money for the redemption of the excess number of them to Aaron and his sons.” ");
INSERT INTO engnet_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","So Moses took the redemption money from those who were in excess of those redeemed by the Levites. ");
INSERT INTO engnet_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","From the firstborn males of the Israelites he collected the money, 1,365 shekels, according to the sanctuary shekel. ");
INSERT INTO engnet_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moses gave the redemption money to Aaron and his sons, according to the word of the Lord, as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Then the Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Take a census of the Kohathites from among the Levites, by their families and by their clans, ");
INSERT INTO engnet_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","from thirty years old and upward to fifty years old, all who enter the company to do the work in the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","This is the service of the Kohathites in the tent of meeting, relating to the most holy things. ");
INSERT INTO engnet_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","When it is time for the camp to journey, Aaron and his sons must come and take down the screening curtain and cover the ark of the testimony with it. ");
INSERT INTO engnet_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Then they must put over it a covering of fine leather and spread over that a cloth entirely of blue, and then they must insert its poles. ");
INSERT INTO engnet_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“On the table of the presence they must spread a blue cloth, and put on it the dishes, the pans, the bowls, and the pitchers for pouring, and the Bread of the Presence must be on it continually. ");
INSERT INTO engnet_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","They must spread over them a scarlet cloth, and cover the same with a covering of fine leather; and they must insert its poles. ");
INSERT INTO engnet_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“They must take a blue cloth and cover the lampstand of the light, with its lamps, its wick-trimmers, its trays, and all its oil vessels, with which they service it. ");
INSERT INTO engnet_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Then they must put it with all its utensils in a covering of fine leather, and put it on a carrying beam. ");
INSERT INTO engnet_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“They must spread a blue cloth on the gold altar, and cover it with a covering of fine leather; and they must insert its poles. ");
INSERT INTO engnet_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Then they must take all the utensils of the service, with which they serve in the sanctuary, put them in a blue cloth, cover them with a covering of fine leather, and put them on a carrying beam. ");
INSERT INTO engnet_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Also, they must take away the ashes from the altar and spread a purple cloth over it. ");
INSERT INTO engnet_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Then they must place on it all its implements with which they serve there – the trays, the meat forks, the shovels, the basins, and all the utensils of the altar – and they must spread on it a covering of fine leather, and then insert its poles. ");
INSERT INTO engnet_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“When Aaron and his sons have finished covering the sanctuary and all the furnishings of the sanctuary, when the camp is ready to journey, then the Kohathites will come to carry them; but they must not touch any holy thing, or they will die. These are the responsibilities of the Kohathites with the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“The appointed responsibility of Eleazar son of Aaron the priest is for the oil for the light, and the spiced incense, and the daily grain offering, and the anointing oil; he also has the appointed responsibility over all the tabernacle with all that is in it, over the sanctuary and over all its furnishings.” ");
INSERT INTO engnet_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Then the Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Do not allow the tribe of the families of the Kohathites to be cut off from among the Levites; ");
INSERT INTO engnet_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","but in order that they will live and not die when they approach the most holy things, do this for them: Aaron and his sons will go in and appoint each man to his service and his responsibility. ");
INSERT INTO engnet_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But the Kohathites are not to go in to watch while the holy things are being covered, or they will die.” ");
INSERT INTO engnet_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Also take a census of the Gershonites, by their clans and by their families. ");
INSERT INTO engnet_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","You must number them from thirty years old and upward to fifty years old, all who enter the company to do the work of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is the service of the families of Gershonites, as they serve and carry it. ");
INSERT INTO engnet_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They must carry the curtains for the tabernacle and the tent of meeting with its covering, the covering of fine leather that is over it, the curtains for the entrance of the tent of meeting, ");
INSERT INTO engnet_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","the hangings for the courtyard, the curtain for the entrance of the gate of the court, which is around the tabernacle and the altar, and their ropes, along with all the furnishings for their service and everything that is made for them. So they are to serve. ");
INSERT INTO engnet_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","“All the service of the Gershonites, whether carrying loads or for any of their work, will be at the direction of Aaron and his sons. You will assign them all their tasks as their responsibility. ");
INSERT INTO engnet_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the families of the Gershonites concerning the tent of meeting. Their responsibilities will be under the authority of Ithamar son of Aaron the priest. ");
INSERT INTO engnet_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“As for the sons of Merari, you are to number them by their families and by their clans. ");
INSERT INTO engnet_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","You must number them from thirty years old and upward to fifty years old, all who enter the company to do the work of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","This is what they are responsible to carry as their entire service in the tent of meeting: the frames of the tabernacle, its crossbars, its posts, its sockets, ");
INSERT INTO engnet_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","and the posts of the surrounding courtyard with their sockets, tent pegs, and ropes, along with all their furnishings and everything for their service. You are to assign by names the items that each man is responsible to carry. ");
INSERT INTO engnet_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the service of the families of the Merarites, their entire service concerning the tent of meeting, under the authority of Ithamar son of Aaron the priest.” ");
INSERT INTO engnet_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","So Moses and Aaron and the leaders of the community numbered the Kohathites by their families and by clans, ");
INSERT INTO engnet_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","from thirty years old and upward to fifty years old, everyone who entered the company for the work in the tent of meeting; ");
INSERT INTO engnet_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","and those of them numbered by their families were 2,750. ");
INSERT INTO engnet_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These were those numbered from the families of the Kohathites, everyone who served in the tent of meeting, whom Moses and Aaron numbered according to the word of the Lord by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Those numbered from the Gershonites, by their families and by their clans, ");
INSERT INTO engnet_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","from thirty years old and upward to fifty years old, everyone who entered the company for the work in the tent of meeting – ");
INSERT INTO engnet_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","those of them numbered by their families, by their clans, were 2,630. ");
INSERT INTO engnet_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These were those numbered from the families of the Gershonites, everyone who served in the tent of meeting, whom Moses and Aaron numbered according to the word of the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Those numbered from the families of the Merarites, by their families, by their clans, ");
INSERT INTO engnet_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","from thirty years old and upward to fifty years old, everyone who entered the company for the work in the tent of meeting – ");
INSERT INTO engnet_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","those of them numbered by their families were 3,200. ");
INSERT INTO engnet_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These are those numbered from the families of the Merarites, whom Moses and Aaron numbered according to the word of the Lord by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","All who were numbered of the Levites, whom Moses, Aaron, and the leaders of Israel numbered by their families and by their clans, ");
INSERT INTO engnet_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","from thirty years old and upward to fifty years old, everyone who entered to do the work of service and the work of carrying relating to the tent of meeting – ");
INSERT INTO engnet_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","those of them numbered were 8,580. ");
INSERT INTO engnet_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","According to the word of the Lord they were numbered, by the authority of Moses, each according to his service and according to what he was to carry. Thus were they numbered by him, as the Lord had commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Command the Israelites to expel from the camp every leper, everyone who has a discharge, and whoever becomes defiled by a corpse. ");
INSERT INTO engnet_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","You must expel both men and women; you must put them outside the camp, so that they will not defile their camps, among which I live.” ");
INSERT INTO engnet_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","So the Israelites did so, and expelled them outside the camp. As the Lord had spoken to Moses, so the Israelites did. ");
INSERT INTO engnet_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tell the Israelites, ‘When a man or a woman commits any sin that people commit, thereby breaking faith with the Lord, and that person is found guilty, ");
INSERT INTO engnet_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","then he must confess his sin that he has committed and must make full reparation, add one fifth to it, and give it to whomever he wronged. ");
INSERT INTO engnet_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the individual has no close relative to whom reparation can be made for the wrong, the reparation for the wrong must be paid to the Lord for the priest, in addition to the ram of atonement by which atonement is made for him. ");
INSERT INTO engnet_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Every offering of all the Israelites’ holy things that they bring to the priest will be his. ");
INSERT INTO engnet_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Every man’s holy things will be his; whatever any man gives the priest will be his.’” ");
INSERT INTO engnet_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Speak to the Israelites and tell them, ‘If any man’s wife goes astray and behaves unfaithfully toward him, ");
INSERT INTO engnet_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","and a man has sexual relations with her without her husband knowing it, and it is hidden that she has defiled herself, since there was no witness against her, nor was she caught – ");
INSERT INTO engnet_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","and if jealous feelings come over him and he becomes suspicious of his wife, when she is defiled; or if jealous feelings come over him and he becomes suspicious of his wife, when she is not defiled – ");
INSERT INTO engnet_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","then the man must bring his wife to the priest, and he must bring the offering required for her, one tenth of an ephah of barley meal; he must not pour olive oil on it or put frankincense on it, because it is a grain offering of suspicion, a grain offering for remembering, for bringing iniquity to remembrance. ");
INSERT INTO engnet_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“‘Then the priest will bring her near and have her stand before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","The priest will then take holy water in a pottery jar, and take some of the dust that is on the floor of the tabernacle, and put it into the water. ");
INSERT INTO engnet_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Then the priest will have the woman stand before the Lord, uncover the woman’s head, and put the grain offering for remembering in her hands, which is the grain offering of suspicion. The priest will hold in his hand the bitter water that brings a curse. ");
INSERT INTO engnet_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Then the priest will put the woman under oath and say to the her, “If no other man has had sexual relations with you, and if you have not gone astray and become defiled while under your husband’s authority, may you be free from this bitter water that brings a curse. ");
INSERT INTO engnet_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have gone astray while under your husband’s authority, and if you have defiled yourself and some man other than your husband has had sexual relations with you….” ");
INSERT INTO engnet_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Then the priest will put the woman under the oath of the curse and will say to the her, “The Lord make you an attested curse among your people, if the Lord makes your thigh fall away and your abdomen swell; ");
INSERT INTO engnet_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","and this water that causes the curse will go into your stomach, and make your abdomen swell and your thigh rot.” Then the woman must say, “Amen, amen.” ");
INSERT INTO engnet_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“‘Then the priest will write these curses on a scroll and then scrape them off into the bitter water. ");
INSERT INTO engnet_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","He will make the woman drink the bitter water that brings a curse, and the water that brings a curse will enter her to produce bitterness. ");
INSERT INTO engnet_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","The priest will take the grain offering of suspicion from the woman’s hand, wave the grain offering before the Lord, and bring it to the altar. ");
INSERT INTO engnet_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Then the priest will take a handful of the grain offering as its memorial portion, burn it on the altar, and afterward make the woman drink the water. ");
INSERT INTO engnet_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","When he has made her drink the water, then, if she has defiled herself and behaved unfaithfully toward her husband, the water that brings a curse will enter her to produce bitterness – her abdomen will swell, her thigh will fall away, and the woman will become a curse among her people. ");
INSERT INTO engnet_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman has not defiled herself, and is clean, then she will be free of ill effects and will be able to bear children. ");
INSERT INTO engnet_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“‘This is the law for cases of jealousy, when a wife, while under her husband’s authority, goes astray and defiles herself, ");
INSERT INTO engnet_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when jealous feelings come over a man and he becomes suspicious of his wife; then he must have the woman stand before the Lord, and the priest will carry out all this law upon her. ");
INSERT INTO engnet_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Then the man will be free from iniquity, but that woman will bear the consequences of her iniquity.’” ");
INSERT INTO engnet_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Speak to the Israelites, and tell them, ‘When either a man or a woman takes a special vow, to take a vow as a Nazirite, to separate himself to the Lord, ");
INSERT INTO engnet_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","he must separate himself from wine and strong drink, he must drink neither vinegar made from wine nor vinegar made from strong drink, nor may he drink any juice of grapes, nor eat fresh grapes or raisins. ");
INSERT INTO engnet_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","All the days of his separation he must not eat anything that is produced by the grapevine, from seed to skin. ");
INSERT INTO engnet_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘All the days of the vow of his separation no razor may be used on his head until the time is fulfilled for which he separated himself to the Lord. He will be holy, and he must let the locks of hair on his head grow long. ");
INSERT INTO engnet_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘All the days that he separates himself to the Lord he must not contact a dead body. ");
INSERT INTO engnet_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","He must not defile himself even for his father or his mother or his brother or his sister if they die, because the separation for his God is on his head. ");
INSERT INTO engnet_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","All the days of his separation he must be holy to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘If anyone dies very suddenly beside him and he defiles his consecrated head, then he must shave his head on the day of his purification – on the seventh day he must shave it. ");
INSERT INTO engnet_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","On the eighth day he is to bring two turtledoves or two young pigeons to the priest, to the entrance to the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Then the priest will offer one for a purification offering and the other as a burnt offering, and make atonement for him, because of his transgression in regard to the corpse. So he must reconsecrate his head on that day. ");
INSERT INTO engnet_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","He must rededicate to the Lord the days of his separation and bring a male lamb in its first year as a reparation offering, but the former days will not be counted because his separation was defiled. ");
INSERT INTO engnet_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘Now this is the law of the Nazirite: When the days of his separation are fulfilled, he must be brought to the entrance of the tent of meeting, ");
INSERT INTO engnet_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and he must present his offering to the Lord: one male lamb in its first year without blemish for a burnt offering, one ewe lamb in its first year without blemish for a purification offering, one ram without blemish for a peace offering, ");
INSERT INTO engnet_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","and a basket of bread made without yeast, cakes of fine flour mixed with olive oil, wafers made without yeast and smeared with olive oil, and their grain offering and their drink offerings. ");
INSERT INTO engnet_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“‘Then the priest must present all these before the Lord and offer his purification offering and his burnt offering. ");
INSERT INTO engnet_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Then he must offer the ram as a peace offering to the Lord, with the basket of bread made without yeast; the priest must also offer his grain offering and his drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“‘Then the Nazirite must shave his consecrated head at the entrance to the tent of meeting and must take the hair from his consecrated head and put it on the fire where the peace offering is burning. ");
INSERT INTO engnet_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","And the priest must take the boiled shoulder of the ram, one cake made without yeast from the basket, and one wafer made without yeast, and put them on the hands of the Nazirite after he has shaved his consecrated head; ");
INSERT INTO engnet_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","then the priest must wave them as a wave offering before the Lord; it is a holy portion for the priest, together with the breast of the wave offering and the thigh of the raised offering. After this the Nazirite may drink wine.’ ");
INSERT INTO engnet_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“This is the law of the Nazirite who vows to the Lord his offering according to his separation, as well as whatever else he can provide. Thus he must fulfill his vow that he makes, according to the law of his separation.” ");
INSERT INTO engnet_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tell Aaron and his sons, ‘This is the way you are to bless the Israelites. Say to them: ");
INSERT INTO engnet_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“The Lord bless you and protect you; ");
INSERT INTO engnet_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","The Lord make his face to shine upon you, and be gracious to you; ");
INSERT INTO engnet_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","The Lord lift up his countenance upon you and give you peace.”’ ");
INSERT INTO engnet_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","So they will put my name on the Israelites, and I will bless them.” ");
INSERT INTO engnet_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","When Moses had completed setting up the tabernacle, he anointed it and consecrated it and all its furnishings, and he anointed and consecrated the altar and all its utensils. ");
INSERT INTO engnet_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Then the leaders of Israel, the heads of their clans, made an offering. They were the leaders of the tribes; they were the ones who had been supervising the numbering. ");
INSERT INTO engnet_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","They brought their offering before the Lord, six covered carts and twelve oxen – one cart for every two of the leaders, and an ox for each one; and they presented them in front of the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Receive these gifts from them, that they may be used in doing the work of the tent of meeting; and you must give them to the Levites, to every man as his service requires.” ");
INSERT INTO engnet_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","So Moses accepted the carts and the oxen and gave them to the Levites. ");
INSERT INTO engnet_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave two carts and four oxen to the Gershonites, as their service required; ");
INSERT INTO engnet_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","and he gave four carts and eight oxen to the Merarites, as their service required, under the authority of Ithamar son of Aaron the priest. ");
INSERT INTO engnet_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But to the Kohathites he gave none, because the service of the holy things, which they carried on their shoulders, was their responsibility. ");
INSERT INTO engnet_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","The leaders offered gifts for the dedication of the altar when it was anointed. And the leaders presented their offering before the altar. ");
INSERT INTO engnet_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","For the Lord said to Moses, “They must present their offering, one leader for each day, for the dedication of the altar.” ");
INSERT INTO engnet_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","The one who presented his offering on the first day was Nahshon son of Amminadab, from the tribe of Judah. ");
INSERT INTO engnet_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","His offering was one silver platter weighing 130 shekels, and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five male lambs in their first year. This was the offering of Nahshon son of Amminadab. ");
INSERT INTO engnet_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day Nethanel son of Zuar, leader of Issachar, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","He offered for his offering one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five male lambs in their first year. This was the offering of Nethanel son of Zuar. ");
INSERT INTO engnet_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day Eliab son of Helon, leader of the Zebulunites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five male lambs in their first year. This was the offering of Eliab son of Helon. ");
INSERT INTO engnet_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day Elizur son of Shedeur, leader of the Reubenites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Elizur son of Shedeur. ");
INSERT INTO engnet_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day Shelumiel son of Zurishaddai, leader of the Simeonites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","one gold pan weighing 10 shekels; ");
INSERT INTO engnet_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Sheloumiel son of Zurishaddai. ");
INSERT INTO engnet_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day Eliasaph son of Deuel, leader of the Gadites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","one gold pan weighing 10 shekels; ");
INSERT INTO engnet_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Eliasaph son of Deuel. ");
INSERT INTO engnet_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day Elishama son of Ammihud, leader of the Ephraimites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Elishama son of Ammihud. ");
INSERT INTO engnet_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day Gamaliel son of Pedahzur, leader of the Manassehites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Gamaliel son of Pedahzur. ");
INSERT INTO engnet_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day Abidan son of Gideoni, leader of the Benjaminites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Abidan son of Gideoni. ");
INSERT INTO engnet_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day Ahiezer son of Amishaddai, leader of the Danites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Ahiezer son of Amishaddai. ");
INSERT INTO engnet_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day Pagiel son of Ocran, leader of the Asherites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","one gold pan weighing 10 shekels, full of incense; ");
INSERT INTO engnet_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Pagiel son of Ocran. ");
INSERT INTO engnet_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day Ahira son of Enan, leader of the Naphtalites, presented an offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His offering was one silver platter weighing 130 shekels and one silver sprinkling bowl weighing 70 shekels, both according to the sanctuary shekel, each of them full of fine flour mixed with olive oil as a grain offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","one gold pan weighing 10 shekels; ");
INSERT INTO engnet_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","one young bull, one ram, and one male lamb in its first year, for a burnt offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","one male goat for a purification offering; ");
INSERT INTO engnet_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","and for the sacrifice of peace offerings: two bulls, five rams, five male goats, and five lambs in their first year. This was the offering of Ahira son of Enan. ");
INSERT INTO engnet_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","This was the dedication for the altar from the leaders of Israel, when it was anointed: twelve silver platters, twelve silver sprinkling bowls, and twelve gold pans. ");
INSERT INTO engnet_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each silver platter weighed 130 shekels, and each silver sprinkling bowl weighed 70 shekels. All the silver of the vessels weighed 2,400 shekels, according to the sanctuary shekel. ");
INSERT INTO engnet_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The twelve gold pans full of incense weighed 10 shekels each, according to the sanctuary shekel; all the gold of the pans weighed 120 shekels. ");
INSERT INTO engnet_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","All the animals for the burnt offering were 12 young bulls, 12 rams, 12 male lambs in their first year, with their grain offering, and 12 male goats for a purification offering. ");
INSERT INTO engnet_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","All the animals for the sacrifice for the peace offering were 24 young bulls, 60 rams, 60 male goats, and 60 lambs in their first year. These were the dedication offerings for the altar after it was anointed. ");
INSERT INTO engnet_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Now when Moses went into the tent of meeting to speak with the Lord, he heard the voice speaking to him from above the atonement lid that was on the ark of the testimony, from between the two cherubim. Thus he spoke to him. ");
INSERT INTO engnet_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Speak to Aaron and tell him, ‘When you set up the lamps, the seven lamps are to give light in front of the lampstand.’” ");
INSERT INTO engnet_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aaron did so; he set up the lamps to face toward the front of the lampstand, as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","This is how the lampstand was made: It was beaten work in gold; from its shaft to its flowers it was beaten work. According to the pattern which the Lord had shown Moses, so he made the lampstand. ");
INSERT INTO engnet_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Take the Levites from among the Israelites and purify them. ");
INSERT INTO engnet_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","And do this to them to purify them: Sprinkle water of purification on them; then have them shave all their body and wash their clothes, and so purify themselves. ");
INSERT INTO engnet_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then they are to take a young bull with its grain offering of fine flour mixed with olive oil; and you are to take a second young bull for a purification offering. ");
INSERT INTO engnet_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","You are to bring the Levites before the tent of meeting and assemble the entire community of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Then you are to bring the Levites before the Lord, and the Israelites are to lay their hands on the Levites; ");
INSERT INTO engnet_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","and Aaron is to offer the Levites before the Lord as a wave offering from the Israelites, that they may do the work of the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","When the Levites lay their hands on the heads of the bulls, offer the one for a purification offering and the other for a whole burnt offering to the Lord, to make atonement for the Levites. ");
INSERT INTO engnet_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","You are to have the Levites stand before Aaron and his sons, and then offer them as a wave offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","And so you are to separate the Levites from among the Israelites, and the Levites will be mine. ");
INSERT INTO engnet_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“After this, the Levites will go in to do the work of the tent of meeting. So you must cleanse them and offer them like a wave offering. ");
INSERT INTO engnet_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For they are entirely given to me from among the Israelites. I have taken them for myself instead of all who open the womb, the firstborn sons of all the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For all the firstborn males among the Israelites are mine, both humans and animals; when I destroyed all the firstborn in the land of Egypt I set them apart for myself. ");
INSERT INTO engnet_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","So I have taken the Levites instead of all the firstborn sons among the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I have given the Levites as a gift to Aaron and his sons from among the Israelites, to do the work for the Israelites in the tent of meeting, and to make atonement for the Israelites, so there will be no plague among the Israelites when the Israelites come near the sanctuary.” ");
INSERT INTO engnet_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","So Moses and Aaron and the entire community of the Israelites did this with the Levites. According to all that the Lord commanded Moses concerning the Levites, this is what the Israelites did with them. ");
INSERT INTO engnet_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites purified themselves and washed their clothing; then Aaron presented them like a wave offering before the Lord, and Aaron made atonement for them to purify them. ");
INSERT INTO engnet_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After this, the Levites went in to do their work in the tent of meeting before Aaron and before his sons. As the Lord had commanded Moses concerning the Levites, so they did. ");
INSERT INTO engnet_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“This is what pertains to the Levites: At the age of twenty-five years and upward one may begin to join the company in the work of the tent of meeting, ");
INSERT INTO engnet_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","and at the age of fifty years they must retire from performing the work and may no longer work. ");
INSERT INTO engnet_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","They may assist their colleagues in the tent of meeting, to attend to needs, but they must do no work. This is the way you must establish the Levites regarding their duties.” ");
INSERT INTO engnet_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","The Lord spoke to Moses in the wilderness of Sinai, in the first month of the second year after they had come out of the land of Egypt: ");
INSERT INTO engnet_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“The Israelites are to observe the Passover at its appointed time. ");
INSERT INTO engnet_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","In the fourteenth day of this month, at twilight, you are to observe it at its appointed time; you must keep it in accordance with all its statutes and all its customs.” ");
INSERT INTO engnet_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","So Moses instructed the Israelites to observe the Passover. ");
INSERT INTO engnet_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","And they observed the Passover on the fourteenth day of the first month at twilight in the wilderness of Sinai; in accordance with all that the Lord had commanded Moses, so the Israelites did. ");
INSERT INTO engnet_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","It happened that some men who were ceremonially defiled by the dead body of a man could not keep the Passover on that day, so they came before Moses and before Aaron on that day. ");
INSERT INTO engnet_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","And those men said to him, “We are ceremonially defiled by the dead body of a man; why are we kept back from offering the Lord’s offering at its appointed time among the Israelites?” ");
INSERT INTO engnet_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","So Moses said to them, “Remain here and I will hear what the Lord will command concerning you.” ");
INSERT INTO engnet_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tell the Israelites, ‘If any of you or of your posterity become ceremonially defiled by touching a dead body, or are on a journey far away, then he may observe the Passover to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","They may observe it on the fourteenth day of the second month at twilight; they are to eat it with bread made without yeast and with bitter herbs. ");
INSERT INTO engnet_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They must not leave any of it until morning, nor break any of its bones; they must observe it in accordance with every statute of the Passover. ");
INSERT INTO engnet_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But the man who is ceremonially clean, and was not on a journey, and fails to keep the Passover, that person must be cut off from his people. Because he did not bring the Lord’s offering at its appointed time, that man must bear his sin. ");
INSERT INTO engnet_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","If a resident foreigner lives among you and wants to keep the Passover to the Lord, he must do so according to the statute of the Passover, and according to its custom. You must have the same statute for the resident foreigner and for the one who was born in the land.’” ");
INSERT INTO engnet_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","On the day that the tabernacle was set up, the cloud covered the tabernacle – the tent of the testimony – and from evening until morning there was a fiery appearance over the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","This is the way it used to be continually: The cloud would cover it by day, and there was a fiery appearance by night. ");
INSERT INTO engnet_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Whenever the cloud was taken up from the tabernacle, then after that the Israelites would begin their journey; and in whatever place the cloud settled, there the Israelites would make camp. ");
INSERT INTO engnet_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At the commandment of the Lord the Israelites would begin their journey, and at the commandment of the Lord they would make camp; as long as the cloud remained settled over the tabernacle they would camp. ");
INSERT INTO engnet_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","When the cloud remained over the tabernacle many days, then the Israelites obeyed the instructions of the Lord and did not journey. ");
INSERT INTO engnet_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","When the cloud remained over the tabernacle a number of days, they remained camped according to the Lord’s commandment, and according to the Lord’s commandment they would journey. ");
INSERT INTO engnet_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","And when the cloud remained only from evening until morning, when the cloud was taken up the following morning, then they traveled on. Whether by day or by night, when the cloud was taken up they traveled. ");
INSERT INTO engnet_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether it was for two days, or a month, or a year, that the cloud prolonged its stay over the tabernacle, the Israelites remained camped without traveling; but when it was taken up, they traveled on. ");
INSERT INTO engnet_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","At the commandment of the Lord they camped, and at the commandment of the Lord they traveled on; they kept the instructions of the Lord according to the commandment of the Lord, by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two trumpets of silver; you are to make them from a single hammered piece. You will use them for assembling the community and for directing the traveling of the camps. ");
INSERT INTO engnet_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","When they blow them both, all the community must come to you to the entrance of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","“But if they blow with one trumpet, then the leaders, the heads of the thousands of Israel, must come to you. ");
INSERT INTO engnet_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you blow an alarm, then the camps that are located on the east side must begin to travel. ");
INSERT INTO engnet_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","And when you blow an alarm the second time, then the camps that are located on the south side must begin to travel. An alarm must be sounded for their journeys. ");
INSERT INTO engnet_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But when you assemble the community, you must blow, but you must not sound an alarm. ");
INSERT INTO engnet_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","The sons of Aaron, the priests, must blow the trumpets; and they will be to you for an eternal ordinance throughout your generations. ");
INSERT INTO engnet_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","If you go to war in your land against an adversary who opposes you, then you must sound an alarm with the trumpets, and you will be remembered before the Lord your God, and you will be saved from your enemies. ");
INSERT INTO engnet_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Also in the time when you rejoice, such as on your appointed festivals or at the beginnings of your months, you must blow with your trumpets over your burnt offerings and over the sacrifices of your peace offerings, so that they may become a memorial for you before your God: I am the Lord your God.” ");
INSERT INTO engnet_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","On the twentieth day of the second month, in the second year, the cloud was taken up from the tabernacle of the testimony. ");
INSERT INTO engnet_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","So the Israelites set out on their journeys from the wilderness of Sinai; and the cloud settled in the wilderness of Paran. ");
INSERT INTO engnet_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","This was the first time they set out on their journey according to the commandment of the Lord, by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","The standard of the camp of the Judahites set out first according to their companies, and over his company was Nahshon son of Amminadab. ");
INSERT INTO engnet_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Over the company of the tribe of Issacharites was Nathanel son of Zuar, ");
INSERT INTO engnet_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","and over the company of the tribe of the Zebulunites was Elion son of Helon. ");
INSERT INTO engnet_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then the tabernacle was dismantled, and the sons of Gershon and the sons of Merari set out, carrying the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","The standard of the camp of Reuben set out according to their companies; over his company was Elizur son of Shedeur. ");
INSERT INTO engnet_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Over the company of the tribe of the Simeonites was Shelumiel son of Zurishaddai, ");
INSERT INTO engnet_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","and over the company of the tribe of the Gadites was Eliasaph son of Deuel. ");
INSERT INTO engnet_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","And the Kohathites set out, carrying the articles for the sanctuary; the tabernacle was to be set up before they arrived. ");
INSERT INTO engnet_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","And the standard of the camp of the Ephraimites set out according to their companies; over his company was Elishama son of Ammihud. ");
INSERT INTO engnet_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Over the company of the tribe of the Manassehites was Gamaliel son of Pedahzur, ");
INSERT INTO engnet_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","and over the company of the tribe of Benjaminites was Abidan son of Gideoni. ");
INSERT INTO engnet_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","The standard of the camp of the Danites set out, which was the rear guard of all the camps by their companies; over his company was Ahiezer son of Ammishaddai. ");
INSERT INTO engnet_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Over the company of the tribe of the Asherites was Pagiel son of Ocran, ");
INSERT INTO engnet_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","and over the company of the tribe of the Naphtalites was Ahira son of Enan. ");
INSERT INTO engnet_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","These were the traveling arrangements of the Israelites according to their companies when they traveled. ");
INSERT INTO engnet_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses said to Hobab son of Reuel, the Midianite, Moses’ father-in-law, “We are journeying to the place about which the Lord said, ‘I will give it to you.’ Come with us and we will treat you well, for the Lord has promised good things for Israel.” ");
INSERT INTO engnet_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But Hobab said to him, “I will not go, but I will go instead to my own land and to my kindred.” ");
INSERT INTO engnet_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moses said, “Do not leave us, because you know places for us to camp in the wilderness, and you could be our guide. ");
INSERT INTO engnet_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","And if you come with us, it is certain that whatever good things the Lord will favor us with, we will share with you as well.” ");
INSERT INTO engnet_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","So they traveled from the mountain of the Lord three days’ journey; and the ark of the covenant of the Lord was traveling before them during the three days’ journey, to find a resting place for them. ");
INSERT INTO engnet_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","And the cloud of the Lord was over them by day, when they traveled from the camp. ");
INSERT INTO engnet_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","And when the ark traveled, Moses would say, “Rise up, O Lord! May your enemies be scattered, and may those who hate you flee before you!” ");
INSERT INTO engnet_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when it came to rest he would say, “Return, O Lord, to the many thousands of Israel!” ");
INSERT INTO engnet_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","When the people complained, it displeased the Lord. When the Lord heard it, his anger burned, and so the fire of the Lord burned among them and consumed some of the outer parts of the camp. ");
INSERT INTO engnet_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","When the people cried to Moses, he prayed to the Lord, and the fire died out. ");
INSERT INTO engnet_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So he called the name of that place Taberah because there the fire of the Lord burned among them. ");
INSERT INTO engnet_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Now the mixed multitude who were among them craved more desirable foods, and so the Israelites wept again and said, “If only we had meat to eat! ");
INSERT INTO engnet_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish we used to eat freely in Egypt, the cucumbers, the melons, the leeks, the onions, and the garlic. ");
INSERT INTO engnet_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now we are dried up, and there is nothing at all before us except this manna!” ");
INSERT INTO engnet_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Now the manna was like coriander seed, and its color like the color of bdellium. ");
INSERT INTO engnet_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","And the people went about and gathered it, and ground it with mills or pounded it in mortars; they baked it in pans and made cakes of it. It tasted like fresh olive oil. ");
INSERT INTO engnet_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","And when the dew came down on the camp in the night, the manna fell with it.) ");
INSERT INTO engnet_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses heard the people weeping throughout their families, everyone at the door of his tent; and when the anger of the Lord was kindled greatly, Moses was also displeased. ");
INSERT INTO engnet_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","And Moses said to the Lord, “Why have you afflicted your servant? Why have I not found favor in your sight, that you lay the burden of this entire people on me? ");
INSERT INTO engnet_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Did I conceive this entire people? Did I give birth to them, that you should say to me, ‘Carry them in your arms, as a foster father bears a nursing child,’ to the land which you swore to their fathers? ");
INSERT INTO engnet_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","From where shall I get meat to give to this entire people, for they cry to me, ‘Give us meat, that we may eat!’ ");
INSERT INTO engnet_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I am not able to bear this entire people alone, because it is too heavy for me! ");
INSERT INTO engnet_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","But if you are going to deal with me like this, then kill me immediately. If I have found favor in your sight then do not let me see my trouble.” ");
INSERT INTO engnet_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","The Lord said to Moses, “Gather to me seventy men of the elders of Israel, whom you know are elders of the people and officials over them, and bring them to the tent of meeting; let them take their position there with you. ");
INSERT INTO engnet_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Then I will come down and speak with you there, and I will take part of the spirit that is on you, and will put it on them, and they will bear some of the burden of the people with you, so that you do not bear it all by yourself. ");
INSERT INTO engnet_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“And say to the people, ‘Sanctify yourselves for tomorrow, and you will eat meat, for you have wept in the hearing of the Lord, saying, “Who will give us meat to eat, for life was good for us in Egypt?” Therefore the Lord will give you meat, and you will eat. ");
INSERT INTO engnet_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will eat, not just one day, nor two days, nor five days, nor ten days, nor twenty days, ");
INSERT INTO engnet_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","but a whole month, until it comes out your nostrils and makes you sick, because you have despised the Lord who is among you and have wept before him, saying, “Why did we ever come out of Egypt?”’” ");
INSERT INTO engnet_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses said, “The people around me are 600,000 on foot; but you say, ‘I will give them meat, that they may eat for a whole month.’ ");
INSERT INTO engnet_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Would they have enough if the flocks and herds were slaughtered for them? If all the fish of the sea were caught for them, would they have enough?” ");
INSERT INTO engnet_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","And the Lord said to Moses, “Is the Lord’s hand shortened? Now you will see whether my word to you will come true or not!” ");
INSERT INTO engnet_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","So Moses went out and told the people the words of the Lord. He then gathered seventy men of the elders of the people and had them stand around the tabernacle. ");
INSERT INTO engnet_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","And the Lord came down in the cloud and spoke to them, and he took some of the Spirit that was on Moses and put it on the seventy elders. When the Spirit rested on them, they prophesied, but did not do so again. ");
INSERT INTO engnet_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","But two men remained in the camp; one’s name was Eldad, and the other’s name was Medad. And the spirit rested on them. (Now they were among those in the registration, but had not gone to the tabernacle.) So they prophesied in the camp. ");
INSERT INTO engnet_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","And a young man ran and told Moses, “Eldad and Medad are prophesying in the camp!” ");
INSERT INTO engnet_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua son of Nun, the servant of Moses, one of his choice young men, said, “My lord Moses, stop them!” ");
INSERT INTO engnet_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moses said to him, “Are you jealous for me? I wish that all the Lord’s people were prophets, that the Lord would put his Spirit on them!” ");
INSERT INTO engnet_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses returned to the camp along with the elders of Israel. ");
INSERT INTO engnet_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Now a wind went out from the Lord and brought quail from the sea, and let them fall near the camp, about a day’s journey on this side, and about a day’s journey on the other side, all around the camp, and about three feet high on the surface of the ground. ");
INSERT INTO engnet_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","And the people stayed up all that day, all that night, and all the next day, and gathered the quail. The one who gathered the least gathered ten homers, and they spread them out for themselves all around the camp. ");
INSERT INTO engnet_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","But while the meat was still between their teeth, before they chewed it, the anger of the Lord burned against the people, and the Lord struck the people with a very great plague. ");
INSERT INTO engnet_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","So the name of that place was called Kibroth Hattaavah, because there they buried the people that craved different food. ");
INSERT INTO engnet_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","The people traveled from Kibroth Hattaavah to Hazeroth, and they stayed at Hazeroth. ");
INSERT INTO engnet_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Then Miriam and Aaron spoke against Moses because of the Cushite woman he had married (for he had married an Ethiopian woman). ");
INSERT INTO engnet_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","They said, “Has the Lord only spoken through Moses? Has he not also spoken through us?” And the Lord heard it. ");
INSERT INTO engnet_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Now the man Moses was very humble, more so than any man on the face of the earth.) ");
INSERT INTO engnet_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","The Lord spoke immediately to Moses, Aaron, and Miriam: “The three of you come to the tent of meeting.” So the three of them went. ");
INSERT INTO engnet_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","And the Lord came down in a pillar of cloud and stood at the entrance of the tent; he then called Aaron and Miriam, and they both came forward. ");
INSERT INTO engnet_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","The Lord said, “Hear now my words: If there is a prophet among you, I the Lord will make myself known to him in a vision; I will speak with him in a dream. ");
INSERT INTO engnet_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","My servant Moses is not like this; he is faithful in all my house. ");
INSERT INTO engnet_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","With him I will speak face to face, openly, and not in riddles; and he will see the form of the Lord. Why then were you not afraid to speak against my servant Moses?” ");
INSERT INTO engnet_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","The anger of the Lord burned against them, and he departed. ");
INSERT INTO engnet_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","When the cloud departed from above the tent, Miriam became leprous as snow. Then Aaron looked at Miriam, and she was leprous! ");
INSERT INTO engnet_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","So Aaron said to Moses, “O my lord, please do not hold this sin against us, in which we have acted foolishly and have sinned! ");
INSERT INTO engnet_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Do not let her be like a baby born dead, whose flesh is half-consumed when it comes out of its mother’s womb!” ");
INSERT INTO engnet_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Then Moses cried to the Lord, “Heal her now, O God.” ");
INSERT INTO engnet_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","The Lord said to Moses, “If her father had only spit in her face, would she not have been disgraced for seven days? Shut her out from the camp seven days, and afterward she can be brought back in again.” ");
INSERT INTO engnet_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So Miriam was shut outside of the camp for seven days, and the people did not journey on until Miriam was brought back in. ");
INSERT INTO engnet_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","After that the people moved from Hazeroth and camped in the wilderness of Paran. ");
INSERT INTO engnet_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send out men to investigate the land of Canaan, which I am giving to the Israelites. You are to send one man from each ancestral tribe, each one a leader among them.” ");
INSERT INTO engnet_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","So Moses sent them from the wilderness of Paran at the command of the Lord. All of them were leaders of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Now these were their names: from the tribe of Reuben, Shammua son of Zaccur; ");
INSERT INTO engnet_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","from the tribe of Simeon, Shaphat son of Hori; ");
INSERT INTO engnet_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","from the tribe of Judah, Caleb son of Jephunneh; ");
INSERT INTO engnet_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","from the tribe of Issachar, Igal son of Joseph; ");
INSERT INTO engnet_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","from the tribe of Ephraim, Hoshea son of Nun; ");
INSERT INTO engnet_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","from the tribe of Benjamin, Palti son of Raphu; ");
INSERT INTO engnet_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","from the tribe of Zebulun, Gaddiel son of Sodi; ");
INSERT INTO engnet_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","from the tribe of Joseph, namely, the tribe of Manasseh, Gaddi son of Susi; ");
INSERT INTO engnet_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","from the tribe of Dan, Ammiel son of Gemalli; ");
INSERT INTO engnet_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","from the tribe of Asher, Sethur son of Michael; ");
INSERT INTO engnet_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","from the tribe of Naphtali, Nahbi son of Vopshi; ");
INSERT INTO engnet_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","from the tribe of Gad, Geuel son of Maki. ");
INSERT INTO engnet_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men whom Moses sent to investigate the land. And Moses gave Hoshea son of Nun the name Joshua. ");
INSERT INTO engnet_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","When Moses sent them to investigate the land of Canaan, he told them, “Go up through the Negev, and then go up into the hill country ");
INSERT INTO engnet_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","and see what the land is like, and whether the people who live in it are strong or weak, few or many, ");
INSERT INTO engnet_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","and whether the land they live in is good or bad, and whether the cities they inhabit are like camps or fortified cities, ");
INSERT INTO engnet_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","and whether the land is rich or poor, and whether or not there are forests in it. And be brave, and bring back some of the fruit of the land.” Now it was the time of year for the first ripe grapes. ");
INSERT INTO engnet_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went up and investigated the land from the wilderness of Zin to Rehob, at the entrance of Hamath. ");
INSERT INTO engnet_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","When they went up through the Negev, they came to Hebron where Ahiman, Sheshai, and Talmai, descendants of Anak, were living. (Now Hebron had been built seven years before Zoan in Egypt.) ");
INSERT INTO engnet_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","When they came to the valley of Eshcol, they cut down from there a branch with one cluster of grapes, and they carried it on a staff between two men, as well as some of the pomegranates and the figs. ");
INSERT INTO engnet_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place was called the Eshcol Valley, because of the cluster of grapes that the Israelites cut from there. ");
INSERT INTO engnet_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","They returned from investigating the land after forty days. ");
INSERT INTO engnet_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","They came back to Moses and Aaron and to the whole community of the Israelites in the wilderness of Paran at Kadesh. They reported to the whole community and showed the fruit of the land. ");
INSERT INTO engnet_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","They told Moses, “We went to the land where you sent us. It is indeed flowing with milk and honey, and this is its fruit. ");
INSERT INTO engnet_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But the inhabitants are strong, and the cities are fortified and very large. Moreover we saw the descendants of Anak there. ");
INSERT INTO engnet_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalekites live in the land of the Negev; the Hittites, Jebusites, and Amorites live in the hill country; and the Canaanites live by the sea and along the banks of the Jordan.” ");
INSERT INTO engnet_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Then Caleb silenced the people before Moses, saying, “Let us go up and occupy it, for we are well able to conquer it.” ");
INSERT INTO engnet_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone up with him said, “We are not able to go up against these people, because they are stronger than we are!” ");
INSERT INTO engnet_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Then they presented the Israelites with a discouraging report of the land they had investigated, saying, “The land that we passed through to investigate is a land that devours its inhabitants. All the people we saw there are of great stature. ");
INSERT INTO engnet_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We even saw the Nephilim there (the descendants of Anak came from the Nephilim), and we seemed liked grasshoppers both to ourselves and to them.” ");
INSERT INTO engnet_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Then all the community raised a loud cry, and the people wept that night. ");
INSERT INTO engnet_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","And all the Israelites murmured against Moses and Aaron, and the whole congregation said to them, “If only we had died in the land of Egypt, or if only we had perished in this wilderness! ");
INSERT INTO engnet_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why has the Lord brought us into this land only to be killed by the sword, that our wives and our children should become plunder? Wouldn’t it be better for us to return to Egypt?” ");
INSERT INTO engnet_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","So they said to one another, “Let’s appoint a leader and return to Egypt.” ");
INSERT INTO engnet_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moses and Aaron fell down with their faces to the ground before the whole assembled community of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","And Joshua son of Nun and Caleb son of Jephunneh, two of those who had investigated the land, tore their garments. ");
INSERT INTO engnet_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","They said to the whole community of the Israelites, “The land we passed through to investigate is an exceedingly good land. ");
INSERT INTO engnet_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If the Lord delights in us, then he will bring us into this land and give it to us – a land that is flowing with milk and honey. ");
INSERT INTO engnet_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only do not rebel against the Lord, and do not fear the people of the land, for they are bread for us. Their protection has turned aside from them, but the Lord is with us. Do not fear them!” ");
INSERT INTO engnet_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","However, the whole community threatened to stone them. But the glory of the Lord appeared to all the Israelites at the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","The Lord said to Moses, “How long will this people despise me, and how long will they not believe in me, in spite of the signs that I have done among them? ");
INSERT INTO engnet_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will strike them with the pestilence, and I will disinherit them; I will make you into a nation that is greater and mightier than they!” ");
INSERT INTO engnet_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moses said to the Lord, “When the Egyptians hear it – for you brought up this people by your power from among them – ");
INSERT INTO engnet_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","then they will tell it to the inhabitants of this land. They have heard that you, Lord, are among this people, that you, Lord, are seen face to face, that your cloud stands over them, and that you go before them by day in a pillar of cloud and in a pillar of fire by night. ");
INSERT INTO engnet_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","If you kill this entire people at once, then the nations that have heard of your fame will say, ");
INSERT INTO engnet_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Because the Lord was not able to bring this people into the land that he swore to them, he killed them in the wilderness.’ ");
INSERT INTO engnet_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","So now, let the power of my Lord be great, just as you have said, ");
INSERT INTO engnet_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘The Lord is slow to anger and abounding in loyal love, forgiving iniquity and transgression, but by no means clearing the guilty, visiting the iniquity of the fathers on the children until the third and fourth generations.’ ");
INSERT INTO engnet_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Please forgive the iniquity of this people according to your great loyal love, just as you have forgiven this people from Egypt even until now.” ");
INSERT INTO engnet_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Then the Lord said, “I have forgiven them as you asked. ");
INSERT INTO engnet_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","But truly, as I live, all the earth will be filled with the glory of the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","For all the people have seen my glory and my signs that I did in Egypt and in the wilderness, and yet have tempted me now these ten times, and have not obeyed me, ");
INSERT INTO engnet_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","they will by no means see the land that I swore to their fathers, nor will any of them who despised me see it. ");
INSERT INTO engnet_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Only my servant Caleb, because he had a different spirit and has followed me fully – I will bring him into the land where he had gone, and his descendants will possess it. ");
INSERT INTO engnet_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Now the Amalekites and the Canaanites were living in the valleys.) Tomorrow, turn and journey into the wilderness by the way of the Red Sea.” ");
INSERT INTO engnet_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long must I bear with this evil congregation that murmurs against me? I have heard the complaints of the Israelites that they murmured against me. ");
INSERT INTO engnet_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Say to them, ‘As I live, says the Lord, I will surely do to you just what you have spoken in my hearing. ");
INSERT INTO engnet_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your dead bodies will fall in this wilderness – all those of you who were numbered, according to your full number, from twenty years old and upward, who have murmured against me. ");
INSERT INTO engnet_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","You will by no means enter into the land where I swore to settle you. The only exceptions are Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engnet_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But I will bring in your little ones, whom you said would become victims of war, and they will enjoy the land that you have despised. ");
INSERT INTO engnet_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But as for you, your dead bodies will fall in this wilderness, ");
INSERT INTO engnet_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","and your children will wander in the wilderness forty years and suffer for your unfaithfulness, until your dead bodies lie finished in the wilderness. ");
INSERT INTO engnet_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","According to the number of the days you have investigated this land, forty days – one day for a year – you will suffer for your iniquities, forty years, and you will know what it means to thwart me. ");
INSERT INTO engnet_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, the Lord, have said, “I will surely do so to all this evil congregation that has gathered together against me. In this wilderness they will be finished, and there they will die!”’” ");
INSERT INTO engnet_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","The men whom Moses sent to investigate the land, who returned and made the whole community murmur against him by producing an evil report about the land, ");
INSERT INTO engnet_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","those men who produced the evil report about the land, died by the plague before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Joshua son of Nun and Caleb son of Jephunneh, who were among the men who went to investigate the land, lived. ");
INSERT INTO engnet_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","When Moses told these things to all the Israelites, the people mourned greatly. ");
INSERT INTO engnet_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","And early in the morning they went up to the crest of the hill country, saying, “Here we are, and we will go up to the place that the Lord commanded, for we have sinned.” ");
INSERT INTO engnet_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses said, “Why are you now transgressing the commandment of the Lord? It will not succeed! ");
INSERT INTO engnet_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Do not go up, for the Lord is not among you, and you will be defeated before your enemies. ");
INSERT INTO engnet_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For the Amalekites and the Canaanites are there before you, and you will fall by the sword. Because you have turned away from the Lord, the Lord will not be with you.” ");
INSERT INTO engnet_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they dared to go up to the crest of the hill, although neither the ark of the covenant of the Lord nor Moses departed from the camp. ");
INSERT INTO engnet_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","So the Amalekites and the Canaanites who lived in that hill country swooped down and attacked them as far as Hormah. ");
INSERT INTO engnet_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Speak to the Israelites and tell them, ‘When you enter the land where you are to live, which I am giving you, ");
INSERT INTO engnet_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","and you make an offering by fire to the Lord from the herd or from the flock (whether a burnt offering or a sacrifice for discharging a vow or as a freewill offering or in your solemn feasts) to create a pleasing aroma to the Lord, ");
INSERT INTO engnet_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","then the one who presents his offering to the Lord must bring a grain offering of one-tenth of an ephah of finely ground flour mixed with one fourth of a hin of olive oil. ");
INSERT INTO engnet_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","You must also prepare one-fourth of a hin of wine for a drink offering with the burnt offering or the sacrifice for each lamb. ");
INSERT INTO engnet_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Or for a ram, you must prepare as a grain offering two-tenths of an ephah of finely ground flour mixed with one-third of a hin of olive oil, ");
INSERT INTO engnet_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","and for a drink offering you must offer one-third of a hin of wine as a pleasing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","And when you prepare a young bull as a burnt offering or a sacrifice for discharging a vow or as a peace offering to the Lord, ");
INSERT INTO engnet_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","then a grain offering of three-tenths of an ephah of finely ground flour mixed with half a hin of olive oil must be presented with the young bull, ");
INSERT INTO engnet_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","and you must present as the drink offering half a hin of wine with the fire offering as a pleasing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","This is what is to be done for each ox, or each ram, or each of the male lambs or the goats. ");
INSERT INTO engnet_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","You must do so for each one according to the number that you prepare. ");
INSERT INTO engnet_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“‘Every native-born person must do these things in this way to present an offering made by fire as a pleasing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","If a resident foreigner is living with you – or whoever is among you in future generations – and prepares an offering made by fire as a pleasing aroma to the Lord, he must do it the same way you are to do it. ");
INSERT INTO engnet_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","One statute must apply to you who belong to the congregation and to the resident foreigner who is living among you, as a permanent statute for your future generations. You and the resident foreigner will be alike before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","One law and one custom must apply to you and to the resident foreigner who lives alongside you.’” ");
INSERT INTO engnet_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Speak to the Israelites and tell them, ‘When you enter the land to which I am bringing you ");
INSERT INTO engnet_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","and you eat some of the food of the land, you must offer up a raised offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","You must offer up a cake of the first of your finely ground flour as a raised offering; as you offer the raised offering of the threshing floor, so you must offer it up. ");
INSERT INTO engnet_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","You must give to the Lord some of the first of your finely ground flour as a raised offering in your future generations. ");
INSERT INTO engnet_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“‘If you sin unintentionally and do not observe all these commandments that the Lord has spoken to Moses – ");
INSERT INTO engnet_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","all that the Lord has commanded you by the authority of Moses, from the day that the Lord commanded Moses and continuing through your future generations – ");
INSERT INTO engnet_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","then if anything is done unintentionally without the knowledge of the community, the whole community must prepare one young bull for a burnt offering – for a pleasing aroma to the Lord – along with its grain offering and its customary drink offering, and one male goat for a purification offering. ");
INSERT INTO engnet_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","And the priest is to make atonement for the whole community of the Israelites, and they will be forgiven, because it was unintentional and they have brought their offering, an offering made by fire to the Lord, and their purification offering before the Lord, for their unintentional offense. ");
INSERT INTO engnet_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","And the whole community of the Israelites and the resident foreigner who lives among them will be forgiven, since all the people were involved in the unintentional offense. ");
INSERT INTO engnet_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘If any person sins unintentionally, then he must bring a yearling female goat for a purification offering. ");
INSERT INTO engnet_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","And the priest must make atonement for the person who sins unintentionally – when he sins unintentionally before the Lord – to make atonement for him, and he will be forgiven. ");
INSERT INTO engnet_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You must have one law for the person who sins unintentionally, both for the native-born among the Israelites and for the resident foreigner who lives among them. ");
INSERT INTO engnet_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“‘But the person who acts defiantly, whether native-born or a resident foreigner, insults the Lord. That person must be cut off from among his people. ");
INSERT INTO engnet_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Because he has despised the word of the Lord and has broken his commandment, that person must be completely cut off. His iniquity will be on him.’” ");
INSERT INTO engnet_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","When the Israelites were in the wilderness they found a man gathering wood on the Sabbath day. ");
INSERT INTO engnet_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Those who found him gathering wood brought him to Moses and Aaron and to the whole community. ");
INSERT INTO engnet_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They put him in custody, because there was no clear instruction about what should be done to him. ");
INSERT INTO engnet_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Then the Lord said to Moses, “The man must surely be put to death; the whole community must stone him with stones outside the camp.” ");
INSERT INTO engnet_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So the whole community took him outside the camp and stoned him to death, just as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Speak to the Israelites and tell them to make tassels for themselves on the corners of their garments throughout their generations, and put a blue thread on the tassel of the corners. ");
INSERT INTO engnet_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","You must have this tassel so that you may look at it and remember all the commandments of the Lord and obey them and so that you do not follow after your own heart and your own eyes that lead you to unfaithfulness. ");
INSERT INTO engnet_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Thus you will remember and obey all my commandments and be holy to your God. ");
INSERT INTO engnet_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the Lord your God, who brought you out of the land of Egypt to be your God. I am the Lord your God.” ");
INSERT INTO engnet_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah son of Izhar, the son of Kohath, the son of Levi, and Dathan and Abiram, the sons of Eliab, and On son of Peleth, who were Reubenites, took men ");
INSERT INTO engnet_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","and rebelled against Moses, along with some of the Israelites, 250 leaders of the community, chosen from the assembly, famous men. ");
INSERT INTO engnet_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","And they assembled against Moses and Aaron, saying to them, “You take too much upon yourselves, seeing that the whole community is holy, every one of them, and the Lord is among them. Why then do you exalt yourselves above the community of the Lord?” ");
INSERT INTO engnet_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard it he fell down with his face to the ground. ");
INSERT INTO engnet_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Then he said to Korah and to all his company, “In the morning the Lord will make known who are his, and who is holy. He will cause that person to approach him; the person he has chosen he will cause to approach him. ");
INSERT INTO engnet_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Do this, Korah, you and all your company: Take censers, ");
INSERT INTO engnet_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","put fire in them, and set incense on them before the Lord tomorrow, and the man whom the Lord chooses will be holy. You take too much upon yourselves, you sons of Levi!” ");
INSERT INTO engnet_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses said to Korah, “Listen now, you sons of Levi! ");
INSERT INTO engnet_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Does it seem too small a thing to you that the God of Israel has separated you from the community of Israel to bring you near to himself, to perform the service of the tabernacle of the Lord, and to stand before the community to minister to them? ");
INSERT INTO engnet_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","He has brought you near and all your brothers, the sons of Levi, with you. Do you now seek the priesthood also? ");
INSERT INTO engnet_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Therefore you and all your company have assembled together against the Lord! And Aaron – what is he that you murmur against him?” ");
INSERT INTO engnet_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses summoned Dathan and Abiram, the sons of Eliab, but they said, “We will not come up. ");
INSERT INTO engnet_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it a small thing that you have brought us up out of the land that flows with milk and honey, to kill us in the wilderness? Now do you want to make yourself a prince over us? ");
INSERT INTO engnet_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Moreover, you have not brought us into a land that flows with milk and honey, nor given us an inheritance of fields and vineyards. Do you think you can blind these men? We will not come up.” ");
INSERT INTO engnet_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses was very angry, and he said to the Lord, “Have no respect for their offering! I have not taken so much as one donkey from them, nor have I harmed any one of them!” ");
INSERT INTO engnet_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Then Moses said to Korah, “You and all your company present yourselves before the Lord – you and they, and Aaron – tomorrow. ");
INSERT INTO engnet_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","And each of you take his censer, put incense in it, and then each of you present his censer before the Lord: 250 censers, along with you, and Aaron – each of you with his censer.” ");
INSERT INTO engnet_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So everyone took his censer, put fire in it, and set incense on it, and stood at the entrance of the tent of meeting, with Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","When Korah assembled the whole community against them at the entrance of the tent of meeting, then the glory of the Lord appeared to the whole community. ");
INSERT INTO engnet_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separate yourselves from among this community, that I may consume them in an instant.” ");
INSERT INTO engnet_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Then they threw themselves down with their faces to the ground and said, “O God, the God of the spirits of all people, will you be angry with the whole community when only one man sins?” ");
INSERT INTO engnet_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","So the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tell the community: ‘Get away from around the homes of Korah, Dathan, and Abiram.’” ");
INSERT INTO engnet_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Then Moses got up and went to Dathan and Abiram; and the elders of Israel went after him. ");
INSERT INTO engnet_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","And he said to the community, “Move away from the tents of these wicked men, and do not touch anything they have, lest you be destroyed because of all their sins.” ");
INSERT INTO engnet_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So they got away from the homes of Korah, Dathan, and Abiram on every side, and Dathan and Abiram came out and stationed themselves in the entrances of their tents with their wives, their children, and their toddlers. ");
INSERT INTO engnet_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Then Moses said, “This is how you will know that the Lord has sent me to do all these works, for I have not done them of my own will. ");
INSERT INTO engnet_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die a natural death, or if they share the fate of all men, then the Lord has not sent me. ");
INSERT INTO engnet_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the Lord does something entirely new, and the earth opens its mouth and swallows them up along with all that they have, and they go down alive to the grave, then you will know that these men have despised the Lord!” ");
INSERT INTO engnet_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","When he had finished speaking all these words, the ground that was under them split open, ");
INSERT INTO engnet_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","and the earth opened its mouth and swallowed them, along with their households, and all Korah’s men, and all their goods. ");
INSERT INTO engnet_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They and all that they had went down alive into the pit, and the earth closed over them. So they perished from among the community. ");
INSERT INTO engnet_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","All the Israelites who were around them fled at their cry, for they said, “What if the earth swallows us too?” ");
INSERT INTO engnet_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Then a fire went out from the Lord and devoured the 250 men who offered incense. ");
INSERT INTO engnet_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tell Eleazar son of Aaron the priest to pick up the censers out of the flame, for they are holy, and then scatter the coals of fire at a distance. ");
INSERT INTO engnet_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","As for the censers of these men who sinned at the cost of their lives, they must be made into hammered sheets for covering the altar, because they presented them before the Lord and sanctified them. They will become a sign to the Israelites.” ");
INSERT INTO engnet_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest took the bronze censers presented by those who had been burned up, and they were hammered out as a covering for the altar. ");
INSERT INTO engnet_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","It was a memorial for the Israelites, that no outsider who is not a descendant of Aaron should approach to burn incense before the Lord, that he might not become like Korah and his company – just as the Lord had spoken by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","But on the next day the whole community of Israelites murmured against Moses and Aaron, saying, “You have killed the Lord’s people!” ");
INSERT INTO engnet_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","When the community assembled against Moses and Aaron, they turned toward the tent of meeting – and the cloud covered it, and the glory of the Lord appeared. ");
INSERT INTO engnet_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Then Moses and Aaron stood before the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Get away from this community, so that I can consume them in an instant!” But they threw themselves down with their faces to the ground. ");
INSERT INTO engnet_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Then Moses said to Aaron, “Take the censer, put burning coals from the altar in it, place incense on it, and go quickly into the assembly and make atonement for them, for wrath has gone out from the Lord – the plague has begun!” ");
INSERT INTO engnet_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","So Aaron did as Moses commanded and ran into the middle of the assembly, where the plague was just beginning among the people. So he placed incense on the coals and made atonement for the people. ");
INSERT INTO engnet_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He stood between the dead and the living, and the plague was stopped. ");
INSERT INTO engnet_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Now 14,700 people died in the plague, in addition to those who died in the event with Korah. ");
INSERT INTO engnet_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Then Aaron returned to Moses at the entrance of the tent of meeting, and the plague was stopped. ");
INSERT INTO engnet_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Speak to the Israelites, and receive from them a staff from each tribe, one from every tribal leader, twelve staffs; you must write each man’s name on his staff. ");
INSERT INTO engnet_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","You must write Aaron’s name on the staff of Levi; for one staff is for the head of every tribe. ");
INSERT INTO engnet_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","You must place them in the tent of meeting before the ark of the covenant where I meet with you. ");
INSERT INTO engnet_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","And the staff of the man whom I choose will blossom; so I will rid myself of the complaints of the Israelites, which they murmur against you.” ");
INSERT INTO engnet_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses spoke to the Israelites, and each of their leaders gave him a staff, one for each leader, according to their tribes – twelve staffs; the staff of Aaron was among their staffs. ");
INSERT INTO engnet_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Then Moses placed the staffs before the Lord in the tent of the testimony. ");
INSERT INTO engnet_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","On the next day Moses went into the tent of the testimony – and the staff of Aaron for the house of Levi had sprouted, and brought forth buds, and produced blossoms, and yielded almonds! ");
INSERT INTO engnet_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","So Moses brought out all the staffs from before the Lord to all the Israelites. They looked at them, and each man took his staff. ");
INSERT INTO engnet_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","The Lord said to Moses, “Bring Aaron’s staff back before the testimony to be preserved for a sign to the rebels, so that you may bring their murmurings to an end before me, that they will not die.” ");
INSERT INTO engnet_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","So Moses did as the Lord commanded him – this is what he did. ");
INSERT INTO engnet_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","The Israelites said to Moses, “We are bound to die! We perish, we all perish! ");
INSERT INTO engnet_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Anyone who even comes close to the tabernacle of the Lord will die! Are we all to die?” ");
INSERT INTO engnet_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","The Lord said to Aaron, “You and your sons and your tribe with you must bear the iniquity of the sanctuary, and you and your sons with you must bear the iniquity of your priesthood. ");
INSERT INTO engnet_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","“Bring with you your brothers, the tribe of Levi, the tribe of your father, so that they may join with you and minister to you while you and your sons with you are before the tent of the testimony. ");
INSERT INTO engnet_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","They must be responsible to care for you and to care for the entire tabernacle. However, they must not come near the furnishings of the sanctuary and the altar, or both they and you will die. ");
INSERT INTO engnet_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They must join with you, and they will be responsible for the care of the tent of meeting, for all the service of the tent, but no unauthorized person may approach you. ");
INSERT INTO engnet_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","You will be responsible for the care of the sanctuary and the care of the altar, so that there will be no more wrath on the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","I myself have chosen your brothers the Levites from among the Israelites. They are given to you as a gift from the Lord, to perform the duties of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But you and your sons with you are responsible for your priestly duties, for everything at the altar and within the curtain. And you must serve. I give you the priesthood as a gift for service; but the unauthorized person who approaches must be put to death.” ");
INSERT INTO engnet_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","The Lord spoke to Aaron, “See, I have given you the responsibility for my raised offerings; I have given all the holy things of the Israelites to you as your priestly portion and to your sons as a perpetual ordinance. ");
INSERT INTO engnet_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Of all the most holy offerings reserved from the fire this will be yours: Every offering of theirs, whether from every grain offering or from every purification offering or from every reparation offering which they bring to me, will be most holy for you and for your sons. ");
INSERT INTO engnet_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","You are to eat it as a most holy offering; every male may eat it. It will be holy to you. ");
INSERT INTO engnet_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“And this is yours: the raised offering of their gift, along with all the wave offerings of the Israelites. I have given them to you and to your sons and daughters with you as a perpetual ordinance. Everyone who is ceremonially clean in your household may eat of it. ");
INSERT INTO engnet_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“All the best of the olive oil and all the best of the wine and of the wheat, the first fruits of these things that they give to the Lord, I have given to you. ");
INSERT INTO engnet_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","And whatever first ripe fruit in their land they bring to the Lord will be yours; everyone who is ceremonially clean in your household may eat of it. ");
INSERT INTO engnet_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Everything devoted in Israel will be yours. ");
INSERT INTO engnet_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","The firstborn of every womb which they present to the Lord, whether human or animal, will be yours. Nevertheless, the firstborn sons you must redeem, and the firstborn males of unclean animals you must redeem. ");
INSERT INTO engnet_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","And those that must be redeemed you are to redeem when they are a month old, according to your estimation, for five shekels of silver according to the sanctuary shekel (which is twenty gerahs). ");
INSERT INTO engnet_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But you must not redeem the firstborn of a cow or a sheep or a goat; they are holy. You must splash their blood on the altar and burn their fat for an offering made by fire for a pleasing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","And their meat will be yours, just as the breast and the right hip of the raised offering is yours. ");
INSERT INTO engnet_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the raised offerings of the holy things that the Israelites offer to the Lord, I have given to you, and to your sons and daughters with you, as a perpetual ordinance. It is a covenant of salt forever before the Lord for you and for your descendants with you.” ");
INSERT INTO engnet_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","The Lord spoke to Aaron, “You will have no inheritance in their land, nor will you have any portion of property among them – I am your portion and your inheritance among the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","See, I have given the Levites all the tithes in Israel for an inheritance, for their service which they perform – the service of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","No longer may the Israelites approach the tent of meeting, or else they will bear their sin and die. ");
INSERT INTO engnet_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","But the Levites must perform the service of the tent of meeting, and they must bear their iniquity. It will be a perpetual ordinance throughout your generations that among the Israelites the Levites have no inheritance. ");
INSERT INTO engnet_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","But I have given to the Levites for an inheritance the tithes of the Israelites that are offered to the Lord as a raised offering. That is why I said to them that among the Israelites they are to have no inheritance.” ");
INSERT INTO engnet_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“You are to speak to the Levites, and you must tell them, ‘When you receive from the Israelites the tithe that I have given you from them as your inheritance, then you are to offer up from it as a raised offering to the Lord a tenth of the tithe. ");
INSERT INTO engnet_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","And your raised offering will be credited to you as though it were grain from the threshing floor or as new wine from the winepress. ");
INSERT INTO engnet_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Thus you are to offer up a raised offering to the Lord of all your tithes which you receive from the Israelites; and you must give the Lord’s raised offering from it to Aaron the priest. ");
INSERT INTO engnet_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","From all your gifts you must offer up every raised offering due the Lord, from all the best of it, and the holiest part of it.’ ");
INSERT INTO engnet_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Therefore you will say to them, ‘When you offer up the best of it, then it will be credited to the Levites as the product of the threshing floor and as the product of the winepress. ");
INSERT INTO engnet_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","And you may eat it in any place, you and your household, because it is your wages for your service in the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","And you will bear no sin concerning it when you offer up the best of it. And you must not profane the holy things of the Israelites, or else you will die.’” ");
INSERT INTO engnet_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","The Lord spoke to Moses and Aaron: ");
INSERT INTO engnet_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“This is the ordinance of the law which the Lord has commanded: ‘Instruct the Israelites to bring you a red heifer without blemish, which has no defect and has never carried a yoke. ");
INSERT INTO engnet_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","You must give it to Eleazar the priest so that he can take it outside the camp, and it must be slaughtered before him. ");
INSERT INTO engnet_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar the priest is to take some of its blood with his finger, and sprinkle some of the blood seven times directly in front of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Then the heifer must be burned in his sight – its skin, its flesh, its blood, and its offal is to be burned. ");
INSERT INTO engnet_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","And the priest must take cedar wood, hyssop, and scarlet wool and throw them into the midst of the fire where the heifer is burning. ");
INSERT INTO engnet_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the priest must wash his clothes and bathe himself in water, and afterward he may come into the camp, but the priest will be ceremonially unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The one who burns it must wash his clothes in water and bathe himself in water. He will be ceremonially unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“‘Then a man who is ceremonially clean must gather up the ashes of the red heifer and put them in a ceremonially clean place outside the camp. They must be kept for the community of the Israelites for use in the water of purification – it is a purification for sin. ");
INSERT INTO engnet_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","The one who gathers the ashes of the heifer must wash his clothes and be ceremonially unclean until evening. This will be a permanent ordinance both for the Israelites and the resident foreigner who lives among them. ");
INSERT INTO engnet_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“‘Whoever touches the corpse of any person will be ceremonially unclean seven days. ");
INSERT INTO engnet_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He must purify himself with water on the third day and on the seventh day, and so will be clean. But if he does not purify himself on the third day and the seventh day, then he will not be clean. ");
INSERT INTO engnet_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Anyone who touches the corpse of any dead person and does not purify himself defiles the tabernacle of the Lord. And that person must be cut off from Israel, because the water of purification was not sprinkled on him. He will be unclean; his uncleanness remains on him. ");
INSERT INTO engnet_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“‘This is the law: When a man dies in a tent, anyone who comes into the tent and all who are in the tent will be ceremonially unclean seven days. ");
INSERT INTO engnet_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","And every open container that has no covering fastened on it is unclean. ");
INSERT INTO engnet_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","And whoever touches the body of someone killed with a sword in the open fields, or the body of someone who died of natural causes, or a human bone, or a grave, will be unclean seven days. ");
INSERT INTO engnet_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“‘For a ceremonially unclean person you must take some of the ashes of the heifer burnt for purification from sin and pour fresh running water over them in a vessel. ");
INSERT INTO engnet_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Then a ceremonially clean person must take hyssop, dip it in the water, and sprinkle it on the tent, on all its furnishings, and on the people who were there, or on the one who touched a bone, or one killed, or one who died, or a grave. ");
INSERT INTO engnet_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","And the clean person must sprinkle the unclean on the third day and on the seventh day; and on the seventh day he must purify him, and then he must wash his clothes, and bathe in water, and he will be clean in the evening. ");
INSERT INTO engnet_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But the man who is unclean and does not purify himself, that person must be cut off from among the community, because he has polluted the sanctuary of the Lord; the water of purification was not sprinkled on him, so he is unclean. ");
INSERT INTO engnet_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","“‘So this will be a perpetual ordinance for them: The one who sprinkles the water of purification must wash his clothes, and the one who touches the water of purification will be unclean until evening. ");
INSERT INTO engnet_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","And whatever the unclean person touches will be unclean, and the person who touches it will be unclean until evening.’” ");
INSERT INTO engnet_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Then the entire community of Israel entered the wilderness of Zin in the first month, and the people stayed in Kadesh. Miriam died and was buried there. ");
INSERT INTO engnet_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","And there was no water for the community, and so they gathered themselves together against Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","The people contended with Moses, saying, “If only we had died when our brothers died before the Lord! ");
INSERT INTO engnet_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you brought up the Lord’s community into this wilderness? So that we and our cattle should die here? ");
INSERT INTO engnet_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why have you brought us up from Egypt only to bring us to this dreadful place? It is no place for grain, or figs, or vines, or pomegranates; nor is there any water to drink!” ");
INSERT INTO engnet_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","So Moses and Aaron went from the presence of the assembly to the entrance to the tent of meeting. They then threw themselves down with their faces to the ground, and the glory of the Lord appeared to them. ");
INSERT INTO engnet_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Take the staff and assemble the community, you and Aaron your brother, and then speak to the rock before their eyes. It will pour forth its water, and you will bring water out of the rock for them, and so you will give the community and their beasts water to drink.” ");
INSERT INTO engnet_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","So Moses took the staff from before the Lord, just as he commanded him. ");
INSERT INTO engnet_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Then Moses and Aaron gathered the community together in front of the rock, and he said to them, “Listen, you rebels, must we bring water out of this rock for you?” ");
INSERT INTO engnet_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Then Moses raised his hand, and struck the rock twice with his staff. And water came out abundantly. So the community drank, and their beasts drank too. ");
INSERT INTO engnet_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Then the Lord spoke to Moses and Aaron, “Because you did not trust me enough to show me as holy before the Israelites, therefore you will not bring this community into the land I have given them.” ");
INSERT INTO engnet_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These are the waters of Meribah, because the Israelites contended with the Lord, and his holiness was maintained among them. ");
INSERT INTO engnet_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses sent messengers from Kadesh to the king of Edom: “Thus says your brother Israel: ‘You know all the hardships we have experienced, ");
INSERT INTO engnet_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","how our ancestors went down into Egypt, and we lived in Egypt a long time, and the Egyptians treated us and our ancestors badly. ");
INSERT INTO engnet_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","So when we cried to the Lord, he heard our voice and sent a messenger, and has brought us up out of Egypt. Now we are here in Kadesh, a town on the edge of your country. ");
INSERT INTO engnet_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Please let us pass through your country. We will not pass through the fields or through the vineyards, nor will we drink water from any well. We will go by the King’s Highway; we will not turn to the right or the left until we have passed through your region.’” ");
INSERT INTO engnet_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But Edom said to him, “You will not pass through me, or I will come out against you with the sword.” ");
INSERT INTO engnet_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Then the Israelites said to him, “We will go along the highway, and if we or our cattle drink any of your water, we will pay for it. We will only pass through on our feet, without doing anything else.” ");
INSERT INTO engnet_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But he said, “You may not pass through.” Then Edom came out against them with a large and powerful force. ");
INSERT INTO engnet_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","So Edom refused to give Israel passage through his border; therefore Israel turned away from him. ");
INSERT INTO engnet_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","So the entire company of Israelites traveled from Kadesh and came to Mount Hor. ");
INSERT INTO engnet_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","And the Lord spoke to Moses and Aaron in Mount Hor, by the border of the land of Edom. He said: ");
INSERT INTO engnet_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron will be gathered to his ancestors, for he will not enter into the land I have given to the Israelites because both of you rebelled against my word at the waters of Meribah. ");
INSERT INTO engnet_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aaron and Eleazar his son, and bring them up on Mount Hor. ");
INSERT INTO engnet_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Remove Aaron’s priestly garments and put them on Eleazar his son, and Aaron will be gathered to his ancestors and will die there.” ");
INSERT INTO engnet_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","So Moses did as the Lord commanded; and they went up Mount Hor in the sight of the whole community. ");
INSERT INTO engnet_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","And Moses removed Aaron’s garments and put them on his son Eleazar. So Aaron died there on the top of the mountain. And Moses and Eleazar came down from the mountain. ");
INSERT INTO engnet_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","When all the community saw that Aaron was dead, the whole house of Israel mourned for Aaron thirty days. ");
INSERT INTO engnet_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","When the Canaanite king of Arad who lived in the Negev heard that Israel was approaching along the road to Atharim, he fought against Israel and took some of them prisoner. ");
INSERT INTO engnet_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","So Israel made a vow to the Lord and said, “If you will indeed deliver this people into our hand, then we will utterly destroy their cities.” ");
INSERT INTO engnet_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","The Lord listened to the voice of Israel and delivered up the Canaanites, and they utterly destroyed them and their cities. So the name of the place was called Hormah. ");
INSERT INTO engnet_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Then they traveled from Mount Hor by the road to the Red Sea, to go around the land of Edom, but the people became impatient along the way. ");
INSERT INTO engnet_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","And the people spoke against God and against Moses, “Why have you brought us up out of Egypt to die in the wilderness, for there is no bread or water, and we detest this worthless food.” ");
INSERT INTO engnet_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","So the Lord sent poisonous snakes among the people, and they bit the people; many people of Israel died. ");
INSERT INTO engnet_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Then the people came to Moses and said, “We have sinned, for we have spoken against the Lord and against you. Pray to the Lord that he would take away the snakes from us.” So Moses prayed for the people. ");
INSERT INTO engnet_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","The Lord said to Moses, “Make a poisonous snake and set it on a pole. When anyone who is bitten looks at it, he will live.” ");
INSERT INTO engnet_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","So Moses made a bronze snake and put it on a pole, so that if a snake had bitten someone, when he looked at the bronze snake he lived. ");
INSERT INTO engnet_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","The Israelites traveled on and camped in Oboth. ");
INSERT INTO engnet_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Then they traveled on from Oboth and camped at Iye Abarim, in the wilderness that is before Moab, on the eastern side. ");
INSERT INTO engnet_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From there they moved on and camped in the valley of Zered. ");
INSERT INTO engnet_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From there they moved on and camped on the other side of the Arnon, in the wilderness that extends from the regions of the Amorites, for Arnon is the border of Moab, between Moab and the Amorites. ");
INSERT INTO engnet_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","This is why it is said in the Book of the Wars of the Lord, “Waheb in Suphah and the wadis, the Arnon ");
INSERT INTO engnet_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","and the slope of the valleys that extends to the dwelling of Ar, and falls off at the border of Moab.” ");
INSERT INTO engnet_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","And from there they traveled to Beer; that is the well where the Lord spoke to Moses, “Gather the people and I will give them water.” ");
INSERT INTO engnet_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Israel sang this song: “Spring up, O well, sing to it! ");
INSERT INTO engnet_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The well which the princes dug, which the leaders of the people opened with their scepters and their staffs.” And from the wilderness they traveled to Mattanah; ");
INSERT INTO engnet_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","and from Mattanah to Nahaliel; and from Nahaliel to Bamoth; ");
INSERT INTO engnet_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth to the valley that is in the country of Moab, near the top of Pisgah, which overlooks the wilderness. ");
INSERT INTO engnet_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Then Israel sent messengers to King Sihon of the Amorites, saying, ");
INSERT INTO engnet_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Let us pass through your land; we will not turn aside into the fields or into the vineyards, nor will we drink water from any well, but we will go along the King’s Highway until we pass your borders.” ");
INSERT INTO engnet_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But Sihon did not permit Israel to pass through his border; he gathered all his forces together and went out against Israel into the wilderness. When he came to Jahaz, he fought against Israel. ");
INSERT INTO engnet_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","But the Israelites defeated him in battle and took possession of his land from the Arnon to the Jabbok, as far as the Ammonites, for the border of the Ammonites was strongly defended. ");
INSERT INTO engnet_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","So Israel took all these cities; and Israel settled in all the cities of the Amorites, in Heshbon, and in all its villages. ");
INSERT INTO engnet_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","For Heshbon was the city of King Sihon of the Amorites. Now he had fought against the former king of Moab and had taken all of his land from his control, as far as the Arnon. ");
INSERT INTO engnet_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","That is why those who speak in proverbs say, “Come to Heshbon, let it be built. Let the city of Sihon be established! ");
INSERT INTO engnet_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For fire went out from Heshbon, a flame from the city of Sihon. It has consumed Ar of Moab and the lords of the high places of Arnon. ");
INSERT INTO engnet_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to you, Moab. You are ruined, O people of Chemosh! He has made his sons fugitives, and his daughters the prisoners of King Sihon of the Amorites. ");
INSERT INTO engnet_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","We have overpowered them; Heshbon has perished as far as Dibon. We have shattered them as far as Nophah, which reaches to Medeba.” ");
INSERT INTO engnet_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","So the Israelites lived in the land of the Amorites. ");
INSERT INTO engnet_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moses sent spies to reconnoiter Jaazer, and they captured its villages and dispossessed the Amorites who were there. ");
INSERT INTO engnet_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then they turned and went up by the road to Bashan. And King Og of Bashan and all his forces marched out against them to do battle at Edrei. ");
INSERT INTO engnet_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","And the Lord said to Moses, “Do not fear him, for I have delivered him and all his people and his land into your hand. You will do to him what you did to King Sihon of the Amorites, who lived in Heshbon. ");
INSERT INTO engnet_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they defeated Og, his sons, and all his people, until there were no survivors, and they possessed his land. ");
INSERT INTO engnet_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","The Israelites traveled on and camped in the plains of Moab on the side of the Jordan River across from Jericho. ");
INSERT INTO engnet_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak son of Zippor saw all that the Israelites had done to the Amorites. ");
INSERT INTO engnet_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","And the Moabites were greatly afraid of the people, because they were so numerous. The Moabites were sick with fear because of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","So the Moabites said to the elders of Midian, “Now this mass of people will lick up everything around us, as the bull devours the grass of the field. Now Balak son of Zippor was king of the Moabites at this time. ");
INSERT INTO engnet_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","And he sent messengers to Balaam son of Beor at Pethor, which is by the Euphrates River in the land of Amaw, to summon him, saying, “Look, a nation has come out of Egypt. They cover the face of the earth, and they are settling next to me. ");
INSERT INTO engnet_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So now, please come and curse this nation for me, for they are too powerful for me. Perhaps I will prevail so that we may conquer them and drive them out of the land. For I know that whoever you bless is blessed, and whoever you curse is cursed.” ");
INSERT INTO engnet_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","So the elders of Moab and the elders of Midian departed with the fee for divination in their hand. They came to Balaam and reported to him the words of Balak. ");
INSERT INTO engnet_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","He replied to them, “Stay here tonight, and I will bring back to you whatever word the Lord may speak to me.” So the princes of Moab stayed with Balaam. ");
INSERT INTO engnet_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","And God came to Balaam and said, “Who are these men with you?” ");
INSERT INTO engnet_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam said to God, “Balak son of Zippor, king of Moab, has sent a message to me, saying, ");
INSERT INTO engnet_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Look, a nation has come out of Egypt, and it covers the face of the earth. Come now and put a curse on them for me; perhaps I will be able to defeat them and drive them out.” ");
INSERT INTO engnet_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","But God said to Balaam, “You must not go with them; you must not curse the people, for they are blessed.” ");
INSERT INTO engnet_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","So Balaam got up in the morning, and said to the princes of Balak, “Go to your land, for the Lord has refused to permit me to go with you.” ");
INSERT INTO engnet_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","So the princes of Moab departed and went back to Balak and said, “Balaam refused to come with us.” ");
INSERT INTO engnet_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak again sent princes, more numerous and more distinguished than the first. ");
INSERT INTO engnet_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","And they came to Balaam and said to him, “Thus says Balak son of Zippor: ‘Please do not let anything hinder you from coming to me. ");
INSERT INTO engnet_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","For I will honor you greatly, and whatever you tell me I will do. So come, put a curse on this nation for me.’” ");
INSERT INTO engnet_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam replied to the servants of Balak, “Even if Balak would give me his palace full of silver and gold, I could not transgress the commandment of the Lord my God to do less or more. ");
INSERT INTO engnet_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Now therefore, please stay the night here also, that I may know what more the Lord might say to me.” ");
INSERT INTO engnet_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God came to Balaam that night, and said to him, “If the men have come to call you, get up and go with them; but the word that I will say to you, that you must do.” ");
INSERT INTO engnet_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","So Balaam got up in the morning, saddled his donkey, and went with the princes of Moab. ");
INSERT INTO engnet_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Then God’s anger was kindled because he went, and the angel of the Lord stood in the road to oppose him. Now he was riding on his donkey and his two servants were with him. ");
INSERT INTO engnet_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","And the donkey saw the angel of the Lord standing in the road with his sword drawn in his hand, so the donkey turned aside from the road and went into the field. But Balaam beat the donkey, to make her turn back to the road. ");
INSERT INTO engnet_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the angel of the Lord stood in a path among the vineyards, where there was a wall on either side. ");
INSERT INTO engnet_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","And when the donkey saw the angel of the Lord, she pressed herself into the wall, and crushed Balaam’s foot against the wall. So he beat her again. ");
INSERT INTO engnet_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Then the angel of the Lord went farther, and stood in a narrow place, where there was no way to turn either to the right or to the left. ");
INSERT INTO engnet_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","When the donkey saw the angel of the Lord, she crouched down under Balaam. Then Balaam was angry, and he beat his donkey with a staff. ");
INSERT INTO engnet_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Then the Lord opened the mouth of the donkey, and she said to Balaam, “What have I done to you that you have beaten me these three times?” ");
INSERT INTO engnet_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","And Balaam said to the donkey, “You have made me look stupid; I wish there were a sword in my hand, for I would kill you right now.” ");
INSERT INTO engnet_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","The donkey said to Balaam, “Am not I your donkey that you have ridden ever since I was yours until this day? Have I ever attempted to treat you this way?” And he said, “No.” ");
INSERT INTO engnet_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the Lord opened Balaam’s eyes, and he saw the angel of the Lord standing in the way with his sword drawn in his hand; so he bowed his head and threw himself down with his face to the ground. ");
INSERT INTO engnet_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","The angel of the Lord said to him, “Why have you beaten your donkey these three times? Look, I came out to oppose you because what you are doing is perverse before me. ");
INSERT INTO engnet_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","The donkey saw me and turned from me these three times. If she had not turned from me, I would have killed you but saved her alive.” ");
INSERT INTO engnet_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam said to the angel of the Lord, “I have sinned, for I did not know that you stood against me in the road. So now, if it is evil in your sight, I will go back home.” ");
INSERT INTO engnet_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","But the angel of the Lord said to Balaam, “Go with the men, but you may only speak the word that I will speak to you.” So Balaam went with the princes of Balak. ");
INSERT INTO engnet_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","When Balak heard that Balaam was coming, he went out to meet him at a city of Moab which was on the border of the Arnon at the boundary of his territory. ");
INSERT INTO engnet_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak said to Balaam, “Did I not send again and again to you to summon you? Why did you not come to me? Am I not able to honor you?” ");
INSERT INTO engnet_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam said to Balak, “Look, I have come to you. Now, am I able to speak just anything? I must speak only the word that God puts in my mouth.” ");
INSERT INTO engnet_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","So Balaam went with Balak, and they came to Kiriath-huzoth. ");
INSERT INTO engnet_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","And Balak sacrificed bulls and sheep, and sent some to Balaam, and to the princes who were with him. ");
INSERT INTO engnet_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Then on the next morning Balak took Balaam, and brought him up to Bamoth Baal. From there he saw the extent of the nation. ");
INSERT INTO engnet_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam said to Balak, “Build me seven altars here, and prepare for me here seven bulls and seven rams.” ");
INSERT INTO engnet_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","So Balak did just as Balaam had said. Balak and Balaam then offered on each altar a bull and a ram. ");
INSERT INTO engnet_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam said to Balak, “Station yourself by your burnt offering, and I will go off; perhaps the Lord will come to meet me, and whatever he reveals to me I will tell you.” Then he went to a deserted height. ");
INSERT INTO engnet_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Then God met Balaam, who said to him, “I have prepared seven altars, and I have offered on each altar a bull and a ram.” ");
INSERT INTO engnet_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Then the Lord put a message in Balaam’s mouth and said, “Return to Balak, and speak what I tell you.” ");
INSERT INTO engnet_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So he returned to him, and he was still standing by his burnt offering, he and all the princes of Moab. ");
INSERT INTO engnet_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Then Balaam uttered his oracle, saying, “Balak, the king of Moab, brought me from Aram, out of the mountains of the east, saying, ‘Come, pronounce a curse on Jacob for me; come, denounce Israel.’ ");
INSERT INTO engnet_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How can I curse one whom God has not cursed, or how can I denounce one whom the Lord has not denounced? ");
INSERT INTO engnet_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For from the top of the rocks I see them; from the hills I watch them. Indeed, a nation that lives alone, and it will not be reckoned among the nations. ");
INSERT INTO engnet_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count the dust of Jacob, Or number the fourth part of Israel? Let me die the death of the upright, and let the end of my life be like theirs.” ");
INSERT INTO engnet_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Then Balak said to Balaam, “What have you done to me? I brought you to curse my enemies, but on the contrary you have only blessed them!” ");
INSERT INTO engnet_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaam replied, “Must I not be careful to speak what the Lord has put in my mouth?” ");
INSERT INTO engnet_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak said to him, “Please come with me to another place from which you can observe them. You will see only a part of them, but you will not see all of them. Curse them for me from there.” ");
INSERT INTO engnet_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","So Balak brought Balaam to the field of Zophim, to the top of Pisgah, where he built seven altars and offered a bull and a ram on each altar. ");
INSERT INTO engnet_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","And Balaam said to Balak, “Station yourself here by your burnt offering, while I meet the Lord there. ");
INSERT INTO engnet_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Then the Lord met Balaam and put a message in his mouth and said, “Return to Balak, and speak what I tell you.” ");
INSERT INTO engnet_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","When Balaam came to him, he was still standing by his burnt offering, along with the princes of Moab. And Balak said to him, “What has the Lord spoken?” ");
INSERT INTO engnet_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam uttered his oracle, and said, “Rise up, Balak, and hear; Listen to me, son of Zippor: ");
INSERT INTO engnet_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man, that he should lie, nor a human being, that he should change his mind. Has he said, and will he not do it? Or has he spoken, and will he not make it happen? ");
INSERT INTO engnet_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Indeed, I have received a command to bless; he has blessed, and I cannot reverse it. ");
INSERT INTO engnet_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He has not looked on iniquity in Jacob, nor has he seen trouble in Israel. The Lord their God is with them; his acclamation as king is among them. ");
INSERT INTO engnet_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God brought them out of Egypt. They have, as it were, the strength of a wild bull. ");
INSERT INTO engnet_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","For there is no spell against Jacob, nor is there any divination against Israel. At this time it must be said of Jacob and of Israel, ‘Look at what God has done!’ ");
INSERT INTO engnet_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Indeed, the people will rise up like a lioness, and like a lion raises himself up; they will not lie down until they eat their prey, and drink the blood of the slain.” ");
INSERT INTO engnet_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak said to Balaam, “Neither curse them at all nor bless them at all!” ");
INSERT INTO engnet_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam replied to Balak, “Did I not tell you, ‘All that the Lord speaks, I must do’?” ");
INSERT INTO engnet_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak said to Balaam, “Come, please; I will take you to another place. Perhaps it will please God to let you curse them for me from there.” ");
INSERT INTO engnet_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","So Balak took Balaam to the top of Peor, that looks toward the wilderness. ");
INSERT INTO engnet_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Then Balaam said to Balak, “Build seven altars here for me, and prepare seven bulls and seven rams.” ");
INSERT INTO engnet_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","So Balak did as Balaam had said, and offered a bull and a ram on each altar. ");
INSERT INTO engnet_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","When Balaam saw that it pleased the Lord to bless Israel, he did not go as at the other times to seek for omens, but he set his face toward the wilderness. ");
INSERT INTO engnet_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","When Balaam lifted up his eyes, he saw Israel camped tribe by tribe; and the Spirit of God came upon him. ");
INSERT INTO engnet_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Then he uttered this oracle: “The oracle of Balaam son of Beor; the oracle of the man whose eyes are open; ");
INSERT INTO engnet_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","the oracle of the one who hears the words of God, who sees a vision from the Almighty, although falling flat on the ground with eyes open: ");
INSERT INTO engnet_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‘How beautiful are your tents, O Jacob, and your dwelling places, O Israel! ");
INSERT INTO engnet_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","They are like valleys stretched forth, like gardens by the river’s side, like aloes that the Lord has planted, and like cedar trees beside the waters. ");
INSERT INTO engnet_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","He will pour the water out of his buckets, and their descendants will be like abundant water; their king will be greater than Agag, and their kingdom will be exalted. ");
INSERT INTO engnet_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God brought them out of Egypt. They have, as it were, the strength of a young bull; they will devour hostile people and will break their bones and will pierce them through with arrows. ");
INSERT INTO engnet_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","They crouch and lie down like a lion, and as a lioness, who can stir him? Blessed is the one who blesses you, and cursed is the one who curses you!’” ");
INSERT INTO engnet_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Then Balak became very angry at Balaam, and he struck his hands together. Balak said to Balaam, “I called you to curse my enemies, and look, you have done nothing but bless them these three times! ");
INSERT INTO engnet_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","So now, go back where you came from! I said that I would greatly honor you; but now the Lord has stood in the way of your honor.” ");
INSERT INTO engnet_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam said to Balak, “Did I not also tell your messengers whom you sent to me, ");
INSERT INTO engnet_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘If Balak would give me his palace full of silver and gold, I cannot go beyond the commandment of the Lord to do either good or evil of my own will, but whatever the Lord tells me I must speak’? ");
INSERT INTO engnet_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","And now, I am about to go back to my own people. Come now, and I will advise you as to what this people will do to your people in the future.” ");
INSERT INTO engnet_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Then he uttered this oracle: “The oracle of Balaam son of Beor; the oracle of the man whose eyes are open; ");
INSERT INTO engnet_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","the oracle of the one who hears the words of God, and who knows the knowledge of the Most High, who sees a vision from the Almighty, although falling flat on the ground with eyes open: ");
INSERT INTO engnet_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","‘I see him, but not now; I behold him, but not close at hand. A star will march forth out of Jacob, and a scepter will rise out of Israel. He will crush the skulls of Moab, and the heads of all the sons of Sheth. ");
INSERT INTO engnet_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom will be a possession, Seir, his enemies, will also be a possession; but Israel will act valiantly. ");
INSERT INTO engnet_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","A ruler will be established from Jacob; he will destroy the remains of the city.’” ");
INSERT INTO engnet_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Then Balaam looked on Amalek and delivered this oracle: “Amalek was the first of the nations, but his end will be that he will perish.” ");
INSERT INTO engnet_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Then he looked on the Kenites and uttered this oracle: “Your dwelling place seems strong, and your nest is set on a rocky cliff. ");
INSERT INTO engnet_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nevertheless the Kenite will be consumed. How long will Asshur take you away captive?” ");
INSERT INTO engnet_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Then he uttered this oracle: “O, who will survive when God does this! ");
INSERT INTO engnet_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ships will come from the coast of Kittim, and will afflict Asshur, and will afflict Eber, and he will also perish forever.” ");
INSERT INTO engnet_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam got up and departed and returned to his home, and Balak also went his way. ");
INSERT INTO engnet_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","When Israel lived in Shittim, the people began to commit sexual immorality with the daughters of Moab. ");
INSERT INTO engnet_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","These women invited the people to the sacrifices of their gods; then the people ate and bowed down to their gods. ");
INSERT INTO engnet_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","When Israel joined themselves to Baal-peor, the anger of the Lord flared up against Israel. ");
INSERT INTO engnet_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","The Lord said to Moses, “Arrest all the leaders of the people, and hang them up before the Lord in broad daylight, so that the fierce anger of the Lord may be turned away from Israel.” ");
INSERT INTO engnet_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses said to the judges of Israel, “Each of you must execute those of his men who were joined to Baal-peor.” ");
INSERT INTO engnet_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Just then one of the Israelites came and brought to his brothers a Midianite woman in the plain view of Moses and of the whole community of the Israelites, while they were weeping at the entrance of the tent of meeting. ");
INSERT INTO engnet_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","When Phinehas son of Eleazar, the son of Aaron the priest, saw it, he got up from among the assembly, took a javelin in his hand, ");
INSERT INTO engnet_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","and went after the Israelite man into the tent and thrust through the Israelite man and into the woman’s abdomen. So the plague was stopped from the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Those that died in the plague were 24,000. ");
INSERT INTO engnet_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas son of Eleazar, the son of Aaron the priest, has turned my anger away from the Israelites, when he manifested such zeal for my sake among them, so that I did not consume the Israelites in my zeal. ");
INSERT INTO engnet_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Therefore, announce: ‘I am going to give to him my covenant of peace. ");
INSERT INTO engnet_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","So it will be to him and his descendants after him a covenant of a permanent priesthood, because he has been zealous for his God, and has made atonement for the Israelites.’” ");
INSERT INTO engnet_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Now the name of the Israelite who was stabbed – the one who was stabbed with the Midianite woman – was Zimri son of Salu, a leader of a clan of the Simeonites. ");
INSERT INTO engnet_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","The name of the Midianite woman who was killed was Cozbi daughter of Zur. He was a leader over the people of a clan of Midian. ");
INSERT INTO engnet_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Bring trouble to the Midianites, and destroy them, ");
INSERT INTO engnet_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","because they bring trouble to you by their treachery with which they have deceived you in the matter of Peor, and in the matter of Cozbi, the daughter of a prince of Midian, their sister, who was killed on the day of the plague that happened as a result of Peor.” ");
INSERT INTO engnet_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","After the plague the Lord said to Moses and to Eleazar son of Aaron the priest, ");
INSERT INTO engnet_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Take a census of the whole community of Israelites, from twenty years old and upward, by their clans, everyone who can serve in the army of Israel.” ");
INSERT INTO engnet_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","So Moses and Eleazar the priest spoke with them in the plains of Moab, by the Jordan River across from Jericho. They said, ");
INSERT INTO engnet_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Number the people from twenty years old and upward, just as the Lord commanded Moses and the Israelites who went out from the land of Egypt.” ");
INSERT INTO engnet_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben was the firstborn of Israel. The Reubenites: from Hanoch, the family of the Hanochites; from Pallu, the family of the Palluites; ");
INSERT INTO engnet_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","from Hezron, the family of the Hezronites; from Carmi, the family of the Carmites. ");
INSERT INTO engnet_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These were the families of the Reubenites; and those numbered of them were 43,730. ");
INSERT INTO engnet_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu’s descendant was Eliab. ");
INSERT INTO engnet_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab’s descendants were Nemuel, Dathan, and Abiram. It was Dathan and Abiram who as leaders of the community rebelled against Moses and Aaron with the followers of Korah when they rebelled against the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","The earth opened its mouth and swallowed them and Korah at the time that company died, when the fire consumed 250 men. So they became a warning. ");
INSERT INTO engnet_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","But the descendants of Korah did not die. ");
INSERT INTO engnet_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","The Simeonites by their families: from Nemuel, the family of the Nemuelites; from Jamin, the family of the Jaminites; from Jakin, the family of the Jakinites; ");
INSERT INTO engnet_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","from Zerah, the family of the Zerahites; and from Shaul, the family of the Shaulites. ");
INSERT INTO engnet_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These were the families of the Simeonites, 22,200. ");
INSERT INTO engnet_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","The Gadites by their families: from Zephon, the family of the Zephonites; from Haggi, the family of the Haggites; from Shuni, the family of the Shunites; ");
INSERT INTO engnet_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","from Ozni, the family of the Oznites; from Eri, the family of the Erites; ");
INSERT INTO engnet_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","from Arod, the family of the Arodites, and from Areli, the family of the Arelites. ");
INSERT INTO engnet_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These were the families of the Gadites according to those numbered of them, 40,500. ");
INSERT INTO engnet_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The descendants of Judah were Er and Onan, but Er and Onan died in the land of Canaan. ");
INSERT INTO engnet_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","And the Judahites by their families were: from Shelah, the family of the Shelahites; from Perez, the family of the Perezites; and from Zerah, the family of the Zerahites. ");
INSERT INTO engnet_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","And the Perezites were: from Hezron, the family of the Hezronites; from Hamul, the family of the Hamulites. ");
INSERT INTO engnet_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These were the families of Judah according to those numbered of them, 76,500. ");
INSERT INTO engnet_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The Issacharites by their families: from Tola, the family of the Tolaites; from Puah, the family of the Puites; ");
INSERT INTO engnet_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","from Jashub, the family of the Jashubites; and from Shimron, the family of the Shimronites. ");
INSERT INTO engnet_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These were the families of Issachar, according to those numbered of them, 64,300. ");
INSERT INTO engnet_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The Zebulunites by their families: from Sered, the family of the Sardites; from Elon, the family of the Elonites; from Jahleel, the family of the Jahleelites. ");
INSERT INTO engnet_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These were the families of the Zebulunites, according to those numbered of them, 60,500. ");
INSERT INTO engnet_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The descendants of Joseph by their families: Manasseh and Ephraim. ");
INSERT INTO engnet_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The Manassehites: from Machir, the family of the Machirites (now Machir became the father of Gilead); from Gilead, the family of the Gileadites. ");
INSERT INTO engnet_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These were the Gileadites: from Iezer, the family of the Iezerites; from Helek, the family of the Helekites; ");
INSERT INTO engnet_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","from Asriel, the family of the Asrielites; from Shechem, the family of the Shechemites; ");
INSERT INTO engnet_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","from Shemida, the family of the Shemidaites; from Hepher, the family of the Hepherites. ");
INSERT INTO engnet_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Now Zelophehad son of Hepher had no sons, but only daughters; and the names of the daughters of Zelophehad were Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engnet_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These were the families of Manasseh; those numbered of them were 52,700. ");
INSERT INTO engnet_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These are the Ephraimites by their families: from Shuthelah, the family of the Shuthelahites; from Beker, the family of the Bekerites; from Tahan, the family of the Tahanites. ");
INSERT INTO engnet_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Now these were the Shuthelahites: from Eran, the family of the Eranites. ");
INSERT INTO engnet_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These were the families of the Ephraimites, according to those numbered of them, 32,500. These were the descendants of Joseph by their families. ");
INSERT INTO engnet_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The Benjaminites by their families: from Bela, the family of the Belaites; from Ashbel, the family of the Ashbelites; from Ahiram, the family of the Ahiramites; ");
INSERT INTO engnet_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","from Shupham, the family of the Shuphamites; from Hupham, the family of the Huphamites. ");
INSERT INTO engnet_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","The descendants of Bela were Ard and Naaman. From Ard, the family of the Ardites; from Naaman, the family of the Naamanites. ");
INSERT INTO engnet_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These are the Benjaminites, according to their families, and according to those numbered of them, 45,600. ");
INSERT INTO engnet_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These are the Danites by their families: from Shuham, the family of the Shuhamites. These were the families of Dan, according to their families. ");
INSERT INTO engnet_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All the families of the Shuhahites according to those numbered of them were 64,400. ");
INSERT INTO engnet_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The Asherites by their families: from Imnah, the family of the Imnahites; from Ishvi, the family of the Ishvites; from Beriah, the family of the Beriahites. ");
INSERT INTO engnet_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","From the Beriahites: from Heber, the family of the Heberites; from Malkiel, the family of the Malkielites. ");
INSERT INTO engnet_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Now the name of the daughter of Asher was Serah. ");
INSERT INTO engnet_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These are the families of the Asherites, according to those numbered of them, 53,400. ");
INSERT INTO engnet_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The Naphtalites by their families: from Jahzeel, the family of the Jahzeelites; from Guni, the family of the Gunites; ");
INSERT INTO engnet_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","from Jezer, the family of the Jezerites; from Shillem, the family of the Shillemites. ");
INSERT INTO engnet_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These were the families of Naphtali according to their families; and those numbered of them were 45,400. ");
INSERT INTO engnet_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These were those numbered of the Israelites, 601,730. ");
INSERT INTO engnet_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“To these the land must be divided as an inheritance according to the number of the names. ");
INSERT INTO engnet_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To a larger group you will give a larger inheritance, and to a smaller group you will give a smaller inheritance. To each one its inheritance must be given according to the number of people in it. ");
INSERT INTO engnet_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","The land must be divided by lot; and they will inherit in accordance with the names of their ancestral tribes. ");
INSERT INTO engnet_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Their inheritance must be apportioned by lot among the larger and smaller groups. ");
INSERT INTO engnet_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","And these are the Levites who were numbered according to their families: from Gershon, the family of the Gershonites; of Kohath, the family of the Kohathites; from Merari, the family of the Merarites. ");
INSERT INTO engnet_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are the families of the Levites: the family of the Libnites, the family of the Hebronites, the family of the Mahlites, the family of the Mushites, the family of the Korahites. Kohath became the father of Amram. ");
INSERT INTO engnet_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Now the name of Amram’s wife was Jochebed, daughter of Levi, who was born to Levi in Egypt. And to Amram she bore Aaron, Moses, and Miriam their sister. ");
INSERT INTO engnet_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","And to Aaron were born Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engnet_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","But Nadab and Abihu died when they offered strange fire before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Those of them who were numbered were 23,000, all males from a month old and upward, for they were not numbered among the Israelites; no inheritance was given to them among the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These are those who were numbered by Moses and Eleazar the priest, who numbered the Israelites in the plains of Moab along the Jordan River opposite Jericho. ");
INSERT INTO engnet_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","But there was not a man among these who had been among those numbered by Moses and Aaron the priest when they numbered the Israelites in the wilderness of Sinai. ");
INSERT INTO engnet_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For the Lord had said of them, “They will surely die in the wilderness.” And there was not left a single man of them, except Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engnet_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Then the daughters of Zelophehad son of Hepher, the son of Gilead, the son of Machir, the son of Manasseh of the families of Manasseh, the son Joseph came forward. Now these are the names of his daughters: Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engnet_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","And they stood before Moses and Eleazar the priest and the leaders of the whole assembly at the entrance to the tent of meeting and said, ");
INSERT INTO engnet_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died in the wilderness, although he was not part of the company of those that gathered themselves together against the Lord in the company of Korah; but he died for his own sin, and he had no sons. ");
INSERT INTO engnet_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should the name of our father be lost from among his family because he had no son? Give us a possession among the relatives of our father.” ");
INSERT INTO engnet_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","So Moses brought their case before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","The Lord said to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“The daughters of Zelophehad have a valid claim. You must indeed give them possession of an inheritance among their father’s relatives, and you must transfer the inheritance of their father to them. ");
INSERT INTO engnet_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","And you must tell the Israelites, ‘If a man dies and has no son, then you must transfer his inheritance to his daughter; ");
INSERT INTO engnet_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","and if he has no daughter, then you are to give his inheritance to his brothers; ");
INSERT INTO engnet_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","and if he has no brothers, then you are to give his inheritance to his father’s brothers; ");
INSERT INTO engnet_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","and if his father has no brothers, then you are to give his inheritance to his relative nearest to him from his family, and he will possess it. This will be for the Israelites a legal requirement, as the Lord commanded Moses.’” ");
INSERT INTO engnet_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Then the Lord said to Moses, “Go up this mountain of the Abarim range, and see the land I have given to the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","When you have seen it, you will be gathered to your ancestors, as Aaron your brother was gathered to his ancestors. ");
INSERT INTO engnet_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","For in the wilderness of Zin when the community rebelled against me, you rebelled against my command to show me as holy before their eyes over the water – the water of Meribah in Kadesh in the wilderness of Zin.” ");
INSERT INTO engnet_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Then Moses spoke to the Lord: ");
INSERT INTO engnet_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Let the Lord, the God of the spirits of all humankind, appoint a man over the community, ");
INSERT INTO engnet_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who will go out before them, and who will come in before them, and who will lead them out, and who will bring them in, so that the community of the Lord may not be like sheep that have no shepherd.” ");
INSERT INTO engnet_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","The Lord replied to Moses, “Take Joshua son of Nun, a man in whom is such a spirit, and lay your hand on him; ");
INSERT INTO engnet_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","set him before Eleazar the priest and before the whole community, and commission him publicly. ");
INSERT INTO engnet_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Then you must delegate some of your authority to him, so that the whole community of the Israelites will be obedient. ");
INSERT INTO engnet_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","And he will stand before Eleazar the priest, who will seek counsel for him before the Lord by the decision of the Urim. At his command they will go out, and at his command they will come in, he and all the Israelites with him, the whole community.” ");
INSERT INTO engnet_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","So Moses did as the Lord commanded him; he took Joshua and set him before Eleazar the priest and before the whole community. ");
INSERT INTO engnet_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","He laid his hands on him and commissioned him, just as the Lord commanded, by the authority of Moses. ");
INSERT INTO engnet_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Command the Israelites: ‘With regard to my offering, be sure to offer my food for my offering made by fire, as a pleasing aroma to me at its appointed time.’ ");
INSERT INTO engnet_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","You will say to them, ‘This is the offering made by fire which you must offer to the Lord: two unblemished lambs one year old each day for a continual burnt offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","The first lamb you must offer in the morning, and the second lamb you must offer in the late afternoon, ");
INSERT INTO engnet_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","with one-tenth of an ephah of finely ground flour as a grain offering mixed with one quarter of a hin of pressed olive oil. ");
INSERT INTO engnet_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","It is a continual burnt offering that was instituted on Mount Sinai as a pleasing aroma, an offering made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","“‘And its drink offering must be one quarter of a hin for each lamb. You must pour out the strong drink as a drink offering to the Lord in the holy place. ");
INSERT INTO engnet_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","And the second lamb you must offer in the late afternoon; just as you offered the grain offering and drink offering in the morning, you must offer it as an offering made by fire, as a pleasing aroma to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘On the Sabbath day, you must offer two unblemished lambs a year old, and two-tenths of an ephah of finely ground flour as a grain offering, mixed with olive oil, along with its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is the burnt offering for every Sabbath, besides the continual burnt offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘On the first day of each month you must offer as a burnt offering to the Lord two young bulls, one ram, and seven unblemished lambs a year old, ");
INSERT INTO engnet_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","with three-tenths of an ephah of finely ground flour mixed with olive oil as a grain offering for each bull, and two-tenths of an ephah of finely ground flour mixed with olive oil as a grain offering for the ram, ");
INSERT INTO engnet_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","and one-tenth of an ephah of finely ground flour mixed with olive oil as a grain offering for each lamb, as a burnt offering for a pleasing aroma, an offering made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","For their drink offerings, include half a hin of wine with each bull, one-third of a hin for the ram, and one-fourth of a hin for each lamb. This is the burnt offering for each month throughout the months of the year. ");
INSERT INTO engnet_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","And one male goat must be offered to the Lord as a purification offering, in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘On the fourteenth day of the first month is the Lord’s Passover. ");
INSERT INTO engnet_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","And on the fifteenth day of this month is the festival. For seven days bread made without yeast must be eaten. ");
INSERT INTO engnet_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","And on the first day there is to be a holy assembly; you must do no ordinary work on it. ");
INSERT INTO engnet_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","“‘But you must offer to the Lord an offering made by fire, a burnt offering of two young bulls, one ram, and seven lambs one year old; they must all be unblemished. ");
INSERT INTO engnet_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","And their grain offering is to be of finely ground flour mixed with olive oil. For each bull you must offer three-tenths of an ephah, and two-tenths for the ram. ");
INSERT INTO engnet_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","For each of the seven lambs you are to offer one-tenth of an ephah, ");
INSERT INTO engnet_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","as well as one goat for a purification offering, to make atonement for you. ");
INSERT INTO engnet_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You must offer these in addition to the burnt offering in the morning which is for a continual burnt offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","In this manner you must offer daily throughout the seven days the food of the sacrifice made by fire as a sweet aroma to the Lord. It is to be offered in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","On the seventh day you are to have a holy assembly, you must do no regular work. ");
INSERT INTO engnet_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘Also, on the day of the first fruits, when you bring a new grain offering to the Lord during your Feast of Weeks, you are to have a holy assembly. You must do no ordinary work. ");
INSERT INTO engnet_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","But you must offer as the burnt offering, as a sweet aroma to the Lord, two young bulls, one ram, seven lambs one year old, ");
INSERT INTO engnet_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","with their grain offering of finely ground flour mixed with olive oil: three-tenths of an ephah for each bull, two-tenths for the one ram, ");
INSERT INTO engnet_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","with one-tenth for each of the seven lambs, ");
INSERT INTO engnet_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","as well as one male goat to make an atonement for you. ");
INSERT INTO engnet_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","You are to offer them with their drink offerings in addition to the continual burnt offering and its grain offering – they must be unblemished. ");
INSERT INTO engnet_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘On the first day of the seventh month, you are to hold a holy assembly. You must not do your ordinary work, for it is a day of blowing trumpets for you. ");
INSERT INTO engnet_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","You must offer a burnt offering as a sweet aroma to the Lord: one young bull, one ram, and seven lambs one year old without blemish. ");
INSERT INTO engnet_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","“‘Their grain offering is to be of finely ground flour mixed with olive oil, three-tenths of an ephah for the bull, two-tenths of an ephah for the ram, ");
INSERT INTO engnet_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and one-tenth for each of the seven lambs, ");
INSERT INTO engnet_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","with one male goat for a purification offering to make an atonement for you; ");
INSERT INTO engnet_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","this is in addition to the monthly burnt offering and its grain offering, and the daily burnt offering with its grain offering and their drink offerings as prescribed, as a sweet aroma, a sacrifice made by fire to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘On the tenth day of this seventh month you are to have a holy assembly. You must humble yourselves; you must not do any work on it. ");
INSERT INTO engnet_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","But you must offer a burnt offering as a pleasing aroma to the Lord, one young bull, one ram, and seven lambs one year old, all of them without blemish. ");
INSERT INTO engnet_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Their grain offering must be of finely ground flour mixed with olive oil, three-tenths of an ephah for the bull, two-tenths for the ram, ");
INSERT INTO engnet_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","and one-tenth for each of the seven lambs, ");
INSERT INTO engnet_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","along with one male goat for a purification offering, in addition to the purification offering for atonement and the continual burnt offering with its grain offering and their drink offerings. ");
INSERT INTO engnet_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘On the fifteenth day of the seventh month you are to have a holy assembly; you must do no ordinary work, and you must keep a festival to the Lord for seven days. ");
INSERT INTO engnet_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","You must offer a burnt offering, an offering made by fire as a pleasing aroma to the Lord: thirteen young bulls, two rams, and fourteen lambs each one year old, all of them without blemish. ");
INSERT INTO engnet_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Their grain offering must be of finely ground flour mixed with olive oil, three-tenths of an ephah for each of the thirteen bulls, two-tenths of an ephah for each of the two rams, ");
INSERT INTO engnet_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and one-tenth for each of the fourteen lambs, ");
INSERT INTO engnet_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘On the second day you must offer twelve young bulls, two rams, fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and their drink offerings. ");
INSERT INTO engnet_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘On the third day you must offer eleven bulls, two rams, fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘On the fourth day you must offer ten bulls, two rams, and fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘On the fifth day you must offer nine bulls, two rams, and fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘On the sixth day you must offer eight bulls, two rams, and fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘On the seventh day you must offer seven bulls, two rams, and fourteen lambs one year old, all without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","and their grain offering and their drink offerings for the bulls, for the rams, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘On the eighth day you are to have a holy assembly; you must do no ordinary work on it. ");
INSERT INTO engnet_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","But you must offer a burnt offering, an offering made by fire, as a pleasing aroma to the Lord, one bull, one ram, seven lambs one year old, all of them without blemish, ");
INSERT INTO engnet_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","and with their grain offering and their drink offerings for the bull, for the ram, and for the lambs, according to their number as prescribed, ");
INSERT INTO engnet_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","along with one male goat for a purification offering, in addition to the continual burnt offering with its grain offering and its drink offering. ");
INSERT INTO engnet_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘These things you must present to the Lord at your appointed times, in addition to your vows and your freewill offerings, as your burnt offerings, your grain offerings, your drink offerings, and your peace offerings.’” ");
INSERT INTO engnet_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","So Moses told the Israelites everything, just as the Lord had commanded him. ");
INSERT INTO engnet_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses told the leaders of the tribes concerning the Israelites, “This is what the Lord has commanded: ");
INSERT INTO engnet_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","If a man makes a vow to the Lord or takes an oath of binding obligation on himself, he must not break his word, but must do whatever he has promised. ");
INSERT INTO engnet_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“If a young woman who is still living in her father’s house makes a vow to the Lord or places herself under an obligation, ");
INSERT INTO engnet_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","and her father hears of her vow or the obligation to which she has pledged herself, and her father remains silent about her, then all her vows will stand, and every obligation to which she has pledged herself will stand. ");
INSERT INTO engnet_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father overrules her when he hears about it, then none of her vows or her obligations which she has pledged for herself will stand. And the Lord will release her from it, because her father overruled her. ");
INSERT INTO engnet_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“And if she marries a husband while under a vow, or she uttered anything impulsively by which she has pledged herself, ");
INSERT INTO engnet_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","and her husband hears about it, but remains silent about her when he hears about it, then her vows will stand and her obligations which she has pledged for herself will stand. ");
INSERT INTO engnet_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if when her husband hears it he overrules her, then he will nullify the vow she has taken, and whatever she uttered impulsively which she has pledged for herself. And the Lord will release her from it. ");
INSERT INTO engnet_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“But every vow of a widow or of a divorced woman which she has pledged for herself will remain intact. ");
INSERT INTO engnet_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","If she made the vow in her husband’s house or put herself under obligation with an oath, ");
INSERT INTO engnet_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband heard about it, but remained silent about her, and did not overrule her, then all her vows will stand, and every obligation which she pledged for herself will stand. ");
INSERT INTO engnet_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband clearly nullifies them when he hears them, then whatever she says by way of vows or obligations will not stand. Her husband has made them void, and the Lord will release her from them. ");
INSERT INTO engnet_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","“Any vow or sworn obligation that would bring affliction to her, her husband can confirm or nullify. ");
INSERT INTO engnet_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if her husband remains completely silent about her from day to day, he thus confirms all her vows or all her obligations which she is under; he confirms them because he remained silent about when he heard them. ");
INSERT INTO engnet_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if he should nullify them after he has heard them, then he will bear her iniquity.” ");
INSERT INTO engnet_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the statutes that the Lord commanded Moses, relating to a man and his wife, and a father and his young daughter who is still living in her father’s house. ");
INSERT INTO engnet_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","The Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Exact vengeance for the Israelites on the Midianites – after that you will be gathered to your people.” ");
INSERT INTO engnet_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","So Moses spoke to the people: “Arm men from among you for the war, to attack the Midianites and to execute the Lord’s vengeance on Midian. ");
INSERT INTO engnet_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","You must send to the battle a thousand men from every tribe throughout all the tribes of Israel.” ");
INSERT INTO engnet_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So a thousand from every tribe, twelve thousand armed for battle in all, were provided out of the thousands of Israel. ");
INSERT INTO engnet_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","So Moses sent them to the war, one thousand from every tribe, with Phinehas son of Eleazar the priest, who was in charge of the holy articles and the signal trumpets. ");
INSERT INTO engnet_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","They fought against the Midianites, as the Lord commanded Moses, and they killed every male. ");
INSERT INTO engnet_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","They killed the kings of Midian in addition to those slain – Evi, Rekem, Zur, Hur, and Reba – five Midianite kings. They also killed Balaam son of Beor with the sword. ");
INSERT INTO engnet_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The Israelites took the women of Midian captives along with their little ones, and took all their herds, all their flocks, and all their goods as plunder. ");
INSERT INTO engnet_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","They burned all their towns where they lived and all their encampments. ");
INSERT INTO engnet_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","They took all the plunder and all the spoils, both people and animals. ");
INSERT INTO engnet_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","They brought the captives and the spoils and the plunder to Moses, to Eleazar the priest, and to the Israelite community, to the camp on the plains of Moab, along the Jordan River across from Jericho. ");
INSERT INTO engnet_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, Eleazar the priest, and all the leaders of the community went out to meet them outside the camp. ");
INSERT INTO engnet_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","But Moses was furious with the officers of the army, the commanders over thousands and commanders over hundreds, who had come from service in the war. ");
INSERT INTO engnet_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moses said to them, “Have you allowed all the women to live? ");
INSERT INTO engnet_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Look, these people through the counsel of Balaam caused the Israelites to act treacherously against the Lord in the matter of Peor – which resulted in the plague among the community of the Lord! ");
INSERT INTO engnet_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Now therefore kill every boy, and kill every woman who has had sexual intercourse with a man. ");
INSERT INTO engnet_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","But all the young women who have not had sexual intercourse with a man will be yours. ");
INSERT INTO engnet_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Any of you who has killed anyone or touched any of the dead, remain outside the camp for seven days; purify yourselves and your captives on the third day, and on the seventh day. ");
INSERT INTO engnet_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","You must purify each garment and everything that is made of skin, everything made of goat’s hair, and everything made of wood.” ");
INSERT INTO engnet_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Then Eleazar the priest said to the men of war who had gone into the battle, “This is the ordinance of the law that the Lord commanded Moses: ");
INSERT INTO engnet_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","‘Only the gold, the silver, the bronze, the iron, the tin, and the lead, ");
INSERT INTO engnet_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","everything that may stand the fire, you are to pass through the fire, and it will be ceremonially clean, but it must still be purified with the water of purification. Anything that cannot withstand the fire you must pass through the water. ");
INSERT INTO engnet_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","You must wash your clothes on the seventh day, and you will be ceremonially clean, and afterward you may enter the camp.’” ");
INSERT INTO engnet_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Then the Lord spoke to Moses: ");
INSERT INTO engnet_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“You and Eleazar the priest, and all the family leaders of the community, take the sum of the plunder that was captured, both people and animals. ");
INSERT INTO engnet_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Divide the plunder into two parts, one for those who took part in the war – who went out to battle – and the other for all the community. ");
INSERT INTO engnet_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","“You must exact a tribute for the Lord from the fighting men who went out to battle: one life out of five hundred, from the people, the cattle, and from the donkeys and the sheep. ");
INSERT INTO engnet_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","You are to take it from their half-share and give it to Eleazar the priest for a raised offering to the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","From the Israelites’ half-share you are to take one portion out of fifty of the people, the cattle, the donkeys, and the sheep – from every kind of animal – and you are to give them to the Levites, who are responsible for the care of the Lord’s tabernacle.” ");
INSERT INTO engnet_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","So Moses and Eleazar the priest did as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","The spoil that remained of the plunder which the fighting men had gathered was 675,000 sheep, ");
INSERT INTO engnet_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 cattle, ");
INSERT INTO engnet_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 donkeys, ");
INSERT INTO engnet_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and 32,000 young women who had never had sexual intercourse with a man. ");
INSERT INTO engnet_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","The half-portion of those who went to war numbered 337,500 sheep; ");
INSERT INTO engnet_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","the Lord’s tribute from the sheep was 675. ");
INSERT INTO engnet_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","The cattle numbered 36,000; the Lord’s tribute was 72. ");
INSERT INTO engnet_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","The donkeys were 30,500, of which the Lord’s tribute was 61. ");
INSERT INTO engnet_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","The people were 16,000, of which the Lord’s tribute was 32 people. ");
INSERT INTO engnet_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","So Moses gave the tribute, which was the Lord’s raised offering, to Eleazar the priest, as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","From the Israelites’ half-share that Moses had separated from the fighting men, ");
INSERT INTO engnet_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","there were 337,500 sheep from the portion belonging to the community, ");
INSERT INTO engnet_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 cattle, ");
INSERT INTO engnet_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 donkeys, ");
INSERT INTO engnet_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and 16,000 people. ");
INSERT INTO engnet_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","From the Israelites’ share Moses took one of every fifty people and animals and gave them to the Levites who were responsible for the care of the Lord’s tabernacle, just as the Lord commanded Moses. ");
INSERT INTO engnet_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Then the officers who were over the thousands of the army, the commanders over thousands and the commanders over hundreds, approached Moses ");
INSERT INTO engnet_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","and said to him, “Your servants have taken a count of the men who were in the battle, who were under our authority, and not one is missing. ");
INSERT INTO engnet_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","So we have brought as an offering for the Lord what each man found: gold ornaments, armlets, bracelets, signet rings, earrings, and necklaces, to make atonement for ourselves before the Lord.” ");
INSERT INTO engnet_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses and Eleazar the priest took the gold from them, all of it in the form of ornaments. ");
INSERT INTO engnet_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","All the gold of the offering they offered up to the Lord from the commanders of thousands and the commanders of hundreds weighed 16,750 shekels. ");
INSERT INTO engnet_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Each soldier had taken plunder for himself. ");
INSERT INTO engnet_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","So Moses and Eleazar the priest received the gold from the commanders of thousands and commanders of hundreds and brought it into the tent of meeting as a memorial for the Israelites before the Lord. ");
INSERT INTO engnet_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Now the Reubenites and the Gadites possessed a very large number of cattle. When they saw that the lands of Jazer and Gilead were ideal for cattle, ");
INSERT INTO engnet_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","the Gadites and the Reubenites came and addressed Moses, Eleazar the priest, and the leaders of the community. They said, ");
INSERT INTO engnet_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, and Beon, ");
INSERT INTO engnet_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","the land that the Lord subdued before the community of Israel, is ideal for cattle, and your servants have cattle.” ");
INSERT INTO engnet_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","So they said, “If we have found favor in your sight, let this land be given to your servants for our inheritance. Do not have us cross the Jordan River.” ");
INSERT INTO engnet_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moses said to the Gadites and the Reubenites, “Must your brothers go to war while you remain here? ");
INSERT INTO engnet_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why do you frustrate the intent of the Israelites to cross over into the land which the Lord has given them? ");
INSERT INTO engnet_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Your fathers did the same thing when I sent them from Kadesh Barnea to see the land. ");
INSERT INTO engnet_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","When they went up to the Eshcol Valley and saw the land, they frustrated the intent of the Israelites so that they did not enter the land that the Lord had given them. ");
INSERT INTO engnet_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","So the anger of the Lord was kindled that day, and he swore, ");
INSERT INTO engnet_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Because they have not followed me wholeheartedly, not one of the men twenty years old and upward who came from Egypt will see the land that I swore to give to Abraham, Isaac, and Jacob, ");
INSERT INTO engnet_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","except Caleb son of Jephunneh the Kenizzite, and Joshua son of Nun, for they followed the Lord wholeheartedly.’ ");
INSERT INTO engnet_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","So the Lord’s anger was kindled against the Israelites, and he made them wander in the wilderness for forty years, until all that generation that had done wickedly before the Lord was finished. ");
INSERT INTO engnet_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Now look, you are standing in your fathers’ place, a brood of sinners, to increase still further the fierce wrath of the Lord against the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","For if you turn away from following him, he will once again abandon them in the wilderness, and you will be the reason for their destruction.” ");
INSERT INTO engnet_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Then they came very close to him and said, “We will build sheep folds here for our flocks and cities for our families, ");
INSERT INTO engnet_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","but we will maintain ourselves in armed readiness and go before the Israelites until whenever we have brought them to their place. Our descendants will be living in fortified towns as a protection against the inhabitants of the land. ");
INSERT INTO engnet_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not return to our homes until every Israelite has his inheritance. ");
INSERT INTO engnet_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","For we will not accept any inheritance on the other side of the Jordan River and beyond, because our inheritance has come to us on this eastern side of the Jordan.” ");
INSERT INTO engnet_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Then Moses replied, “If you will do this thing, and if you will arm yourselves for battle before the Lord, ");
INSERT INTO engnet_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","and if all your armed men cross the Jordan before the Lord until he drives out his enemies from his presence ");
INSERT INTO engnet_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","and the land is subdued before the Lord, then afterward you may return and be free of your obligation to the Lord and to Israel. This land will then be your possession in the Lord’s sight. ");
INSERT INTO engnet_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“But if you do not do this, then look, you will have sinned against the Lord. And know that your sin will find you out. ");
INSERT INTO engnet_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","So build cities for your descendants and pens for your sheep, but do what you have said you would do.” ");
INSERT INTO engnet_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","So the Gadites and the Reubenites replied to Moses, “Your servants will do as my lord commands. ");
INSERT INTO engnet_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our children, our wives, our flocks, and all our livestock will be there in the cities of Gilead, ");
INSERT INTO engnet_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","but your servants will cross over, every man armed for war, to do battle in the Lord’s presence, just as my lord says.” ");
INSERT INTO engnet_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses gave orders about them to Eleazar the priest, to Joshua son of Nun, and to the heads of the families of the Israelite tribes. ");
INSERT INTO engnet_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses said to them: “If the Gadites and the Reubenites cross the Jordan with you, each one equipped for battle in the Lord’s presence, and you conquer the land, then you must allot them the territory of Gilead as their possession. ");
INSERT INTO engnet_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they do not cross over with you armed, they must receive possessions among you in Canaan.” ");
INSERT INTO engnet_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Then the Gadites and the Reubenites answered, “Your servants will do what the Lord has spoken. ");
INSERT INTO engnet_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will cross armed in the Lord’s presence into the land of Canaan, and then the possession of our inheritance that we inherit will be ours on this side of the Jordan River.” ");
INSERT INTO engnet_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So Moses gave to the Gadites, the Reubenites, and to half the tribe of Manasseh son of Joseph the realm of King Sihon of the Amorites, and the realm of King Og of Bashan, the entire land with its cities and the territory surrounding them. ");
INSERT INTO engnet_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","The Gadites rebuilt Dibon, Ataroth, Aroer, ");
INSERT INTO engnet_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth Shophan, Jazer, Jogbehah, ");
INSERT INTO engnet_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, and Beth Haran as fortified cities, and constructed pens for their flocks. ");
INSERT INTO engnet_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The Reubenites rebuilt Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engnet_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon (with a change of name), and Sibmah. They renamed the cities they built. ");
INSERT INTO engnet_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","The descendants of Machir son of Manasseh went to Gilead, took it, and dispossessed the Amorites who were in it. ");
INSERT INTO engnet_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","So Moses gave Gilead to Machir, son of Manasseh, and he lived there. ");
INSERT INTO engnet_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Now Jair son of Manasseh went and captured their small towns and named them Havvoth Jair. ");
INSERT INTO engnet_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Then Nobah went and captured Kenath and its villages and called it Nobah after his own name. ");
INSERT INTO engnet_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","These are the journeys of the Israelites, who went out of the land of Egypt by their divisions under the authority of Moses and Aaron. ");
INSERT INTO engnet_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses recorded their departures according to their journeys, by the commandment of the Lord; now these are their journeys according to their departures. ");
INSERT INTO engnet_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","They departed from Rameses in the first month, on the fifteenth day of the first month; on the day after the Passover the Israelites went out defiantly in plain sight of all the Egyptians. ");
INSERT INTO engnet_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Now the Egyptians were burying all their firstborn, whom the Lord had killed among them; the Lord also executed judgments on their gods. ");
INSERT INTO engnet_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The Israelites traveled from Rameses and camped in Succoth. ");
INSERT INTO engnet_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","They traveled from Succoth, and camped in Etham, which is on the edge of the wilderness. ");
INSERT INTO engnet_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","They traveled from Etham, and turned again to Pi-hahiroth, which is before Baal-Zephon; and they camped before Migdal. ");
INSERT INTO engnet_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","They traveled from Pi-hahiroth, and passed through the middle of the sea into the wilderness, and went three days’ journey in the wilderness of Etham, and camped in Marah. ");
INSERT INTO engnet_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","They traveled from Marah and came to Elim; in Elim there are twelve fountains of water and seventy palm trees, so they camped there. ");
INSERT INTO engnet_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","They traveled from Elim, and camped by the Red Sea. ");
INSERT INTO engnet_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","They traveled from the Red Sea and camped in the wilderness of Zin. ");
INSERT INTO engnet_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","They traveled from the wilderness of Zin and camped in Dophkah. ");
INSERT INTO engnet_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","And they traveled from Dophkah, and camped in Alush. ");
INSERT INTO engnet_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","They traveled from Alush and camped at Rephidim, where there was no water for the people to drink. ");
INSERT INTO engnet_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","They traveled from Rephidim and camped in the wilderness of Sinai. ");
INSERT INTO engnet_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","They traveled from the desert of Sinai and camped at Kibroth Hattaavah. ");
INSERT INTO engnet_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","They traveled from Kibroth Hattaavah and camped at Hazeroth. ");
INSERT INTO engnet_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","They traveled from Hazeroth and camped in Rithmah. ");
INSERT INTO engnet_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","They traveled from Rithmah and camped at Rimmon-perez. ");
INSERT INTO engnet_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","They traveled from Rimmon-perez and camped in Libnah. ");
INSERT INTO engnet_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","They traveled from Libnah and camped at Rissah. ");
INSERT INTO engnet_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","They traveled from Rissah and camped in Kehelathah. ");
INSERT INTO engnet_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","They traveled from Kehelathah and camped at Mount Shepher. ");
INSERT INTO engnet_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","They traveled from Mount Shepher and camped in Haradah. ");
INSERT INTO engnet_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","They traveled from Haradah and camped in Makheloth. ");
INSERT INTO engnet_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","They traveled from Makheloth and camped at Tahath. ");
INSERT INTO engnet_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","They traveled from Tahath and camped at Terah. ");
INSERT INTO engnet_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","They traveled from Terah and camped in Mithcah. ");
INSERT INTO engnet_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","They traveled from Mithcah and camped in Hashmonah. ");
INSERT INTO engnet_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","They traveled from Hashmonah and camped in Moseroth. ");
INSERT INTO engnet_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","They traveled from Moseroth and camped in Bene-jaakan. ");
INSERT INTO engnet_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","They traveled from Bene-jaakan and camped at Hor-haggidgad. ");
INSERT INTO engnet_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","They traveled from Hor-haggidgad and camped in Jotbathah. ");
INSERT INTO engnet_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","They traveled from Jotbathah and camped in Abronah. ");
INSERT INTO engnet_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","They traveled from Abronah and camped at Ezion-geber. ");
INSERT INTO engnet_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","They traveled from Ezion-geber and camped in the wilderness of Zin, which is Kadesh. ");
INSERT INTO engnet_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","They traveled from Kadesh and camped in Mount Hor at the edge of the land of Edom. ");
INSERT INTO engnet_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Aaron the priest ascended Mount Hor at the command of the Lord, and he died there in the fortieth year after the Israelites had come out of the land of Egypt on the first day of the fifth month. ");
INSERT INTO engnet_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Now Aaron was 123 years old when he died in Mount Hor. ");
INSERT INTO engnet_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","The king of Arad, the Canaanite king who lived in the south of the land of Canaan, heard about the approach of the Israelites. ");
INSERT INTO engnet_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","They traveled from Mount Hor and camped in Zalmonah. ");
INSERT INTO engnet_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","They traveled from Zalmonah and camped in Punon. ");
INSERT INTO engnet_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","They traveled from Punon and camped in Oboth. ");
INSERT INTO engnet_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","They traveled from Oboth and camped in Iye-abarim, on the border of Moab. ");
INSERT INTO engnet_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","They traveled from Iim and camped in Dibon-gad. ");
INSERT INTO engnet_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","They traveled from Dibon-gad and camped in Almon-diblathaim. ");
INSERT INTO engnet_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","They traveled from Almon-diblathaim and camped in the mountains of Abarim before Nebo. ");
INSERT INTO engnet_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","They traveled from the mountains of Abarim and camped in the plains of Moab by the Jordan River across from Jericho. ");
INSERT INTO engnet_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","They camped by the Jordan, from Beth-jeshimoth as far as Abel-shittim in the plains of Moab. ");
INSERT INTO engnet_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","The Lord spoke to Moses in the plains of Moab by the Jordan, across from Jericho. He said: ");
INSERT INTO engnet_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Speak to the Israelites and tell them, ‘When you have crossed the Jordan into the land of Canaan, ");
INSERT INTO engnet_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","you must drive out all the inhabitants of the land before you. Destroy all their carved images, all their molten images, and demolish their high places. ");
INSERT INTO engnet_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","You must dispossess the inhabitants of the land and live in it, for I have given you the land to possess it. ");
INSERT INTO engnet_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","You must divide the land by lot for an inheritance among your families. To a larger group you must give a larger inheritance, and to a smaller group you must give a smaller inheritance. Everyone’s inheritance must be in the place where his lot falls. You must inherit according to your ancestral tribes. ");
INSERT I