﻿USE sofia;
DROP TABLE IF EXISTS sofia.engmsb_vpl;
CREATE TABLE engmsb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engmsb_vpl WRITE;
INSERT INTO engmsb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning God created the heavens and the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Now the earth was formless and void, and darkness was over the surface of the deep. And the Spirit of God was hovering over the surface of the waters. ");
INSERT INTO engmsb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","And God said, “Let there be light,” and there was light. ");
INSERT INTO engmsb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","And God saw that the light was good, and He separated the light from the darkness. ");
INSERT INTO engmsb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God called the light “day,” and the darkness He called “night.” And there was evening, and there was morning—the first day. ");
INSERT INTO engmsb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","And God said, “Let there be an expanse between the waters, to separate the waters from the waters.” ");
INSERT INTO engmsb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","So God made the expanse and separated the waters beneath it from the waters above. And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God called the expanse “sky.” And there was evening, and there was morning—the second day. ");
INSERT INTO engmsb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","And God said, “Let the waters under the sky be gathered into one place, so that the dry land may appear.” And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the dry land “earth,” and the gathering of waters He called “seas.” And God saw that it was good. ");
INSERT INTO engmsb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Then God said, “Let the earth bring forth vegetation: seed-bearing plants and fruit trees, each bearing fruit with seed according to its kind.” And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The earth produced vegetation: seed-bearing plants according to their kinds and trees bearing fruit with seed according to their kinds. And God saw that it was good. ");
INSERT INTO engmsb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","And there was evening, and there was morning—the third day. ");
INSERT INTO engmsb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","And God said, “Let there be lights in the expanse of the sky to distinguish between the day and the night, and let them be signs to mark the seasons and days and years. ");
INSERT INTO engmsb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","And let them serve as lights in the expanse of the sky to shine upon the earth.” And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God made two great lights: the greater light to rule the day and the lesser light to rule the night. And He made the stars as well. ");
INSERT INTO engmsb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God set these lights in the expanse of the sky to shine upon the earth, ");
INSERT INTO engmsb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to preside over the day and the night, and to separate the light from the darkness. And God saw that it was good. ");
INSERT INTO engmsb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","And there was evening, and there was morning—the fourth day. ");
INSERT INTO engmsb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","And God said, “Let the waters teem with living creatures, and let birds fly above the earth in the open expanse of the sky.” ");
INSERT INTO engmsb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","So God created the great sea creatures and every living thing that moves, with which the waters teemed according to their kinds, and every winged bird after its kind. And God saw that it was good. ");
INSERT INTO engmsb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Then God blessed them and said, “Be fruitful and multiply and fill the waters of the seas, and let birds multiply on the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","And there was evening, and there was morning—the fifth day. ");
INSERT INTO engmsb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","And God said, “Let the earth bring forth living creatures according to their kinds: livestock, land crawlers, and beasts of the earth according to their kinds.” And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made the beasts of the earth according to their kinds, the livestock according to their kinds, and everything that crawls upon the earth according to its kind. And God saw that it was good. ");
INSERT INTO engmsb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Then God said, “Let Us make man in Our image, after Our likeness, to rule over the fish of the sea and the birds of the air, over the livestock, and over all the earth itself and every creature that crawls upon it.” ");
INSERT INTO engmsb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So God created man in His own image; in the image of God He created him; male and female He created them. ");
INSERT INTO engmsb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them and said to them, “Be fruitful and multiply, and fill the earth and subdue it; rule over the fish of the sea and the birds of the air and every creature that crawls upon the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Then God said, “Behold, I have given you every seed-bearing plant on the face of all the earth, and every tree whose fruit contains seed. They will be yours for food. ");
INSERT INTO engmsb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And to every beast of the earth and every bird of the air and every creature that crawls upon the earth—everything that has the breath of life in it—I have given every green plant for food.” And it was so. ");
INSERT INTO engmsb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","And God looked upon all that He had made, and indeed, it was very good. And there was evening, and there was morning—the sixth day. ");
INSERT INTO engmsb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Thus the heavens and the earth were completed in all their vast array. ");
INSERT INTO engmsb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","And by the seventh day God had finished the work He had been doing; so on that day He rested from all His work. ");
INSERT INTO engmsb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Then God blessed the seventh day and sanctified it, because on that day He rested from all the work of creation that He had accomplished. ");
INSERT INTO engmsb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This is the account of the heavens and the earth when they were created, in the day that the LORD God made them. ");
INSERT INTO engmsb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Now no shrub of the field had yet appeared on the earth, nor had any plant of the field sprouted, for the LORD God had not yet sent rain upon the earth, and there was no man to cultivate the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","But springs welled up from the earth and watered the whole surface of the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Then the LORD God formed man from the dust of the ground and breathed the breath of life into his nostrils, and the man became a living being. ");
INSERT INTO engmsb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","And the LORD God planted a garden in Eden, in the east, where He placed the man He had formed. ");
INSERT INTO engmsb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Out of the ground the LORD God gave growth to every tree that is pleasing to the eye and good for food. And in the middle of the garden were the tree of life and the tree of the knowledge of good and evil. ");
INSERT INTO engmsb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Now a river flowed out of Eden to water the garden, and from there it branched into four headwaters: ");
INSERT INTO engmsb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first river is the Pishon; it winds through the whole land of Havilah, where there is gold. ");
INSERT INTO engmsb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","And the gold of that land is pure, and bdellium and onyx are found there. ");
INSERT INTO engmsb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river is the Gihon; it winds through the whole land of Cush. ");
INSERT INTO engmsb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river is the Tigris; it runs along the east side of Assyria. And the fourth river is the Euphrates. ");
INSERT INTO engmsb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Then the LORD God took the man and placed him in the Garden of Eden to cultivate and keep it. ");
INSERT INTO engmsb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","And the LORD God commanded him, “You may eat freely from every tree of the garden, ");
INSERT INTO engmsb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","but you must not eat from the tree of the knowledge of good and evil; for in the day that you eat of it, you will surely die.” ");
INSERT INTO engmsb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","The LORD God also said, “It is not good for the man to be alone. I will make for him a suitable helper.” ");
INSERT INTO engmsb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","And out of the ground the LORD God formed every beast of the field and every bird of the air, and He brought them to the man to see what he would name each one. And whatever the man called each living creature, that was its name. ");
INSERT INTO engmsb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","The man gave names to all the livestock, to the birds of the air, and to every beast of the field. But for Adam no suitable helper was found. ");
INSERT INTO engmsb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So the LORD God caused the man to fall into a deep sleep, and while he slept, He took one of the man’s ribs and closed up the area with flesh. ");
INSERT INTO engmsb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","And from the rib that the LORD God had taken from the man, He made a woman and brought her to him. ");
INSERT INTO engmsb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","And the man said: “This is now bone of my bones and flesh of my flesh; she shall be called ‘woman,’ for out of man she was taken.” ");
INSERT INTO engmsb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","For this reason a man will leave his father and mother and be united to his wife, and they will become one flesh. ");
INSERT INTO engmsb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","And the man and his wife were both naked, and they were not ashamed. ");
INSERT INTO engmsb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Now the serpent was more crafty than any beast of the field that the LORD God had made. And he said to the woman, “Did God really say, ‘You must not eat from any tree in the garden?’” ");
INSERT INTO engmsb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman answered the serpent, “We may eat the fruit of the trees of the garden, ");
INSERT INTO engmsb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","but about the fruit of the tree in the middle of the garden, God has said, ‘You must not eat of it or touch it, or you will die.’” ");
INSERT INTO engmsb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“You will not surely die,” the serpent told the woman. ");
INSERT INTO engmsb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“For God knows that in the day you eat of it, your eyes will be opened and you will be like God, knowing good and evil.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","When the woman saw that the tree was good for food and pleasing to the eyes, and that it was desirable for obtaining wisdom, she took the fruit and ate it. She also gave some to her husband who was with her, and he ate it. ");
INSERT INTO engmsb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","And the eyes of both of them were opened, and they knew that they were naked; so they sewed together fig leaves and made coverings for themselves. ");
INSERT INTO engmsb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Then the man and his wife heard the voice of the LORD God walking in the garden in the breeze of the day, and they hid themselves from the presence of the LORD God among the trees of the garden. ");
INSERT INTO engmsb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","But the LORD God called out to the man, “Where are you?” ");
INSERT INTO engmsb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“I heard Your voice in the garden,” he replied, “and I was afraid because I was naked; so I hid myself.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Who told you that you were naked?” asked the LORD God. “Have you eaten from the tree of which I commanded you not to eat?” ");
INSERT INTO engmsb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","And the man answered, “The woman whom You gave me, she gave me fruit from the tree, and I ate it.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Then the LORD God said to the woman, “What is this you have done?” “The serpent deceived me,” she replied, “and I ate.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","So the LORD God said to the serpent: “Because you have done this, cursed are you above all livestock and every beast of the field! On your belly will you go, and dust you will eat, all the days of your life. ");
INSERT INTO engmsb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","And I will put enmity between you and the woman, and between your seed and her seed. He will crush your head, and you will strike his heel.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","To the woman He said: “I will sharply increase your pain in childbirth; in pain you will bring forth children. Your desire will be for your husband, and he will rule over you.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","And to Adam He said: “Because you have listened to the voice of your wife and have eaten from the tree of which I commanded you not to eat, cursed is the ground because of you; through toil you will eat of it all the days of your life. ");
INSERT INTO engmsb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Both thorns and thistles it will yield for you, and you will eat the plants of the field. ");
INSERT INTO engmsb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","By the sweat of your brow you will eat your bread, until you return to the ground—because out of it were you taken. For dust you are, and to dust you shall return.” ");
INSERT INTO engmsb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","And Adam named his wife Eve, because she would be the mother of all the living. ");
INSERT INTO engmsb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","And the LORD God made garments of skin for Adam and his wife, and He clothed them. ");
INSERT INTO engmsb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Then the LORD God said, “Behold, the man has become like one of Us, knowing good and evil. And now, lest he reach out his hand and take also from the tree of life, and eat, and live forever...” ");
INSERT INTO engmsb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Therefore the LORD God banished him from the Garden of Eden to work the ground from which he had been taken. ");
INSERT INTO engmsb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","So He drove out the man and stationed cherubim on the east side of the Garden of Eden, along with a whirling sword of flame to guard the way to the tree of life. ");
INSERT INTO engmsb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","And Adam had relations with his wife Eve, and she conceived and gave birth to Cain. “With the help of the LORD I have brought forth a man,” she said. ");
INSERT INTO engmsb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Later she gave birth to Cain’s brother Abel. Now Abel was a keeper of sheep, while Cain was a tiller of the soil. ");
INSERT INTO engmsb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","So in the course of time, Cain brought some of the fruit of the soil as an offering to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","while Abel brought the best portions of the firstborn of his flock. And the LORD looked with favor on Abel and his offering, ");
INSERT INTO engmsb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but He had no regard for Cain and his offering. So Cain became very angry, and his countenance fell. ");
INSERT INTO engmsb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","“Why are you angry,” said the LORD to Cain, “and why has your countenance fallen? ");
INSERT INTO engmsb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you do what is right, will you not be accepted? But if you refuse to do what is right, sin is crouching at your door; it desires you, but you must master it.” ");
INSERT INTO engmsb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Then Cain said to his brother Abel, “Let us go out to the field.” And while they were in the field, Cain rose up against his brother Abel and killed him. ");
INSERT INTO engmsb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","And the LORD said to Cain, “Where is your brother Abel?” “I do not know!” he answered. “Am I my brother’s keeper?” ");
INSERT INTO engmsb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","“What have you done?” replied the LORD. “The voice of your brother’s blood cries out to Me from the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Now you are cursed and banished from the ground, which has opened its mouth to receive your brother’s blood from your hand. ");
INSERT INTO engmsb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When you till the ground, it will no longer yield its produce to you. You will be a fugitive and a wanderer on the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","But Cain said to the LORD, “My punishment is greater than I can bear. ");
INSERT INTO engmsb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Behold, this day You have driven me from the face of the earth, and from Your face I will be hidden; I will be a fugitive and a wanderer on the earth, and whoever finds me will kill me.” ");
INSERT INTO engmsb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","“Not so!” replied the LORD. “If anyone slays Cain, then Cain will be avenged sevenfold.” And the LORD placed a mark on Cain, so that no one who found him would kill him. ");
INSERT INTO engmsb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","So Cain went out from the presence of the LORD and settled in the land of Nod, east of Eden. ");
INSERT INTO engmsb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","And Cain had relations with his wife, and she conceived and gave birth to Enoch. Then Cain built a city and named it after his son Enoch. ");
INSERT INTO engmsb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Now to Enoch was born Irad, and Irad was the father of Mehujael, and Mehujael was the father of Methusael, and Methusael was the father of Lamech. ");
INSERT INTO engmsb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","And Lamech married two women, one named Adah and the other Zillah. ");
INSERT INTO engmsb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to Jabal; he was the father of those who dwell in tents and raise livestock. ");
INSERT INTO engmsb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","And his brother’s name was Jubal; he was the father of all who play the harp and flute. ");
INSERT INTO engmsb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","And Zillah gave birth to Tubal-cain, a forger of every implement of bronze and iron. And the sister of Tubal-cain was Naamah. ");
INSERT INTO engmsb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Then Lamech said to his wives: “Adah and Zillah, hear my voice; wives of Lamech, listen to my speech. For I have slain a man for wounding me, a young man for striking me. ");
INSERT INTO engmsb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If Cain is avenged sevenfold, then Lamech seventy-sevenfold.” ");
INSERT INTO engmsb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","And Adam again had relations with his wife, and she gave birth to a son and named him Seth, saying, “God has granted me another seed in place of Abel, since Cain killed him.” ");
INSERT INTO engmsb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","And to Seth also a son was born, and he called him Enosh. At that time men began to call upon the name of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the book of the generations of Adam. In the day that God created man, He made him in His own likeness. ");
INSERT INTO engmsb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Male and female He created them, and He blessed them. And in the day they were created, He called them “man.” ");
INSERT INTO engmsb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","When Adam was 130 years old, he had a son in his own likeness, after his own image; and he named him Seth. ");
INSERT INTO engmsb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","And after he had become the father of Seth, Adam lived 800 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","So Adam lived a total of 930 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","When Seth was 105 years old, he became the father of Enosh. ");
INSERT INTO engmsb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","And after he had become the father of Enosh, Seth lived 807 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","So Seth lived a total of 912 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","When Enosh was 90 years old, he became the father of Kenan. ");
INSERT INTO engmsb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","And after he had become the father of Kenan, Enosh lived 815 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","So Enosh lived a total of 905 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","When Kenan was 70 years old, he became the father of Mahalalel. ");
INSERT INTO engmsb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","And after he had become the father of Mahalalel, Kenan lived 840 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","So Kenan lived a total of 910 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel was 65 years old, he became the father of Jared. ");
INSERT INTO engmsb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","And after he had become the father of Jared, Mahalalel lived 830 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","So Mahalalel lived a total of 895 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","When Jared was 162 years old, he became the father of Enoch. ");
INSERT INTO engmsb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","And after he had become the father of Enoch, Jared lived 800 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","So Jared lived a total of 962 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","When Enoch was 65 years old, he became the father of Methuselah. ");
INSERT INTO engmsb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","And after he had become the father of Methuselah, Enoch walked with God 300 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","So Enoch lived a total of 365 years. ");
INSERT INTO engmsb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch walked with God, and then he was no more, because God had taken him away. ");
INSERT INTO engmsb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","When Methuselah was 187 years old, he became the father of Lamech. ");
INSERT INTO engmsb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","And after he had become the father of Lamech, Methuselah lived 782 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","So Methuselah lived a total of 969 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech was 182 years old, he had a son. ");
INSERT INTO engmsb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","And he named him Noah, saying, “May this one comfort us in the labor and toil of our hands caused by the ground that the LORD has cursed.” ");
INSERT INTO engmsb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","And after he had become the father of Noah, Lamech lived 595 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","So Lamech lived a total of 777 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","After Noah was 500 years old, he became the father of Shem, Ham, and Japheth. ");
INSERT INTO engmsb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Now when men began to multiply on the face of the earth and daughters were born to them, ");
INSERT INTO engmsb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","the sons of God saw that the daughters of men were beautiful, and they took as wives whomever they chose. ");
INSERT INTO engmsb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","So the LORD said, “My Spirit will not contend with man forever, for he is mortal; his days shall be 120 years.” ");
INSERT INTO engmsb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","The Nephilim were on the earth in those days—and afterward as well—when the sons of God had relations with the daughters of men. And they bore them children who became the mighty men of old, men of renown. ");
INSERT INTO engmsb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Then the LORD saw that the wickedness of man was great upon the earth, and that every inclination of the thoughts of his heart was altogether evil all the time. ");
INSERT INTO engmsb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","And the LORD regretted that He had made man on the earth, and He was grieved in His heart. ");
INSERT INTO engmsb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So the LORD said, “I will blot out man, whom I have created, from the face of the earth—every man and beast and crawling creature and bird of the air—for I am grieved that I have made them.” ");
INSERT INTO engmsb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Noah, however, found favor in the eyes of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the account of Noah. Noah was a righteous man, blameless in his generation; Noah walked with God. ");
INSERT INTO engmsb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","And Noah had three sons: Shem, Ham, and Japheth. ");
INSERT INTO engmsb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Now the earth was corrupt in the sight of God, and full of violence. ");
INSERT INTO engmsb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","And God looked upon the earth and saw that it was corrupt; for all living creatures on the earth had corrupted their ways. ");
INSERT INTO engmsb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Then God said to Noah, “The end of all living creatures has come before Me, because through them the earth is full of violence. Now behold, I will destroy both them and the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Make for yourself an ark of gopher wood; make rooms in the ark and coat it with pitch inside and out. ");
INSERT INTO engmsb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","And this is how you are to build it: The ark is to be 300 cubits long, 50 cubits wide, and 30 cubits high. ");
INSERT INTO engmsb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","You are to make a roof for the ark, finish its walls a cubit from the top, place a door in the side of the ark, and build lower, middle, and upper decks. ");
INSERT INTO engmsb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","And behold, I will bring floodwaters upon the earth to destroy every creature under the heavens that has the breath of life. Everything on the earth will perish. ");
INSERT INTO engmsb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But I will establish My covenant with you, and you will enter the ark—you and your sons and your wife and your sons’ wives with you. ");
INSERT INTO engmsb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","And you are to bring two of every living creature into the ark—male and female—to keep them alive with you. ");
INSERT INTO engmsb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Two of every kind of bird and animal and crawling creature will come to you to be kept alive. ");
INSERT INTO engmsb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","You are also to take for yourself every kind of food that is eaten and gather it as food for yourselves and for the animals.” ");
INSERT INTO engmsb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","So Noah did everything precisely as God had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Then the LORD said to Noah, “Go into the ark, you and all your family, because I have found you righteous in this generation. ");
INSERT INTO engmsb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","You are to take with you seven pairs of every kind of clean animal, a male and its mate; a pair of every kind of unclean animal, a male and its mate; ");
INSERT INTO engmsb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","and seven pairs of every kind of bird of the air, male and female, to preserve their offspring on the face of all the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","For seven days from now I will send rain on the earth for forty days and forty nights, and I will wipe from the face of the earth every living thing I have made.” ");
INSERT INTO engmsb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","And Noah did all that the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Now Noah was 600 years old when the floodwaters came upon the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","And Noah and his wife, with his sons and their wives, entered the ark to escape the waters of the flood. ");
INSERT INTO engmsb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","The clean and unclean animals, the birds, and everything that crawls along the ground ");
INSERT INTO engmsb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","came to Noah to enter the ark, two by two, male and female, as God had commanded Noah. ");
INSERT INTO engmsb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","And after seven days the floodwaters came upon the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","In the six hundredth year of Noah’s life, on the seventeenth day of the second month, all the fountains of the great deep burst forth, and the floodgates of the heavens were opened. ");
INSERT INTO engmsb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","And the rain fell upon the earth for forty days and forty nights. ");
INSERT INTO engmsb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","On that very day Noah entered the ark, along with his sons Shem, Ham, and Japheth, and his wife, and the three wives of his sons— ");
INSERT INTO engmsb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","they and every kind of wild animal, livestock, crawling creature, bird, and winged creature. ");
INSERT INTO engmsb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","They came to Noah to enter the ark, two by two of every creature with the breath of life. ");
INSERT INTO engmsb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","And they entered, the male and female of every living thing, as God had commanded Noah. Then the LORD shut him in. ");
INSERT INTO engmsb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","For forty days the flood kept coming on the earth, and the waters rose and lifted the ark high above the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","So the waters continued to surge and rise greatly on the earth, and the ark floated on the surface of the waters. ");
INSERT INTO engmsb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Finally, the waters completely prevailed upon the earth, so that all the high mountains under all the heavens were covered. ");
INSERT INTO engmsb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The waters rose and covered the mountaintops to a depth of fifteen cubits. ");
INSERT INTO engmsb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","And every living thing that moved upon the earth perished—birds, livestock, animals, every creature that swarms upon the earth, and all mankind. ");
INSERT INTO engmsb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Of all that was on dry land, everything that had the breath of life in its nostrils died. ");
INSERT INTO engmsb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","And every living thing on the face of the earth was destroyed—man and livestock, crawling creatures and birds of the air; they were blotted out from the earth, and only Noah and those with him in the ark remained. ");
INSERT INTO engmsb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","And the waters prevailed upon the earth for 150 days. ");
INSERT INTO engmsb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","But God remembered Noah and all the animals and livestock that were with him in the ark. And God sent a wind over the earth, and the waters began to subside. ");
INSERT INTO engmsb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The springs of the deep and the floodgates of the heavens were closed, and the rain from the sky was restrained. ");
INSERT INTO engmsb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The waters receded steadily from the earth, and after 150 days the waters had gone down. ");
INSERT INTO engmsb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","On the seventeenth day of the seventh month, the ark came to rest on the mountains of Ararat. ");
INSERT INTO engmsb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","And the waters continued to recede until the tenth month, and on the first day of the tenth month the tops of the mountains became visible. ");
INSERT INTO engmsb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","After forty days Noah opened the window he had made in the ark ");
INSERT INTO engmsb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","and sent out a raven. It kept flying back and forth until the waters had dried up from the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Then Noah sent out a dove to see if the waters had receded from the surface of the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the dove found no place to rest her foot, and she returned to him in the ark, because the waters were still covering the surface of all the earth. So he reached out his hand and brought her back inside the ark. ");
INSERT INTO engmsb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noah waited seven more days and again sent out the dove from the ark. ");
INSERT INTO engmsb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","And behold, the dove returned to him in the evening with a freshly plucked olive leaf in her beak. So Noah knew that the waters had receded from the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","And Noah waited seven more days and sent out the dove again, but this time she did not return to him. ");
INSERT INTO engmsb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","In Noah’s six hundred and first year, on the first day of the first month, the waters had dried up from the earth. So Noah removed the covering from the ark and saw that the surface of the ground was dry. ");
INSERT INTO engmsb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","By the twenty-seventh day of the second month, the earth was fully dry. ");
INSERT INTO engmsb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God said to Noah, ");
INSERT INTO engmsb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Come out of the ark, you and your wife, along with your sons and their wives. ");
INSERT INTO engmsb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring out all the living creatures that are with you—birds, livestock, and everything that crawls upon the ground—so that they can spread out over the earth and be fruitful and multiply upon it.” ");
INSERT INTO engmsb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","So Noah came out, along with his sons and his wife and his sons’ wives. ");
INSERT INTO engmsb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Every living creature, every creeping thing, and every bird—everything that moves upon the earth—came out of the ark, kind by kind. ");
INSERT INTO engmsb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Then Noah built an altar to the LORD. And taking from every kind of clean animal and clean bird, he offered burnt offerings on the altar. ");
INSERT INTO engmsb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","When the LORD smelled the pleasing aroma, He said in His heart, “Never again will I curse the ground because of man, even though every inclination of his heart is evil from his youth. And never again will I destroy all living creatures as I have done. ");
INSERT INTO engmsb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","As long as the earth endures, seedtime and harvest, cold and heat, summer and winter, day and night shall never cease.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","And God blessed Noah and his sons and said to them, “Be fruitful and multiply and fill the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","The fear and dread of you will fall on every living creature on the earth, every bird of the air, every creature that crawls on the ground, and all the fish of the sea. They are delivered into your hand. ");
INSERT INTO engmsb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Everything that lives and moves will be food for you; just as I gave you the green plants, I now give you all things. ");
INSERT INTO engmsb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But you must not eat meat with its lifeblood still in it. ");
INSERT INTO engmsb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","And surely I will require the life of any man or beast by whose hand your lifeblood is shed. I will demand an accounting from anyone who takes the life of his fellow man: ");
INSERT INTO engmsb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever sheds the blood of man, by man his blood will be shed; for in His own image God has made mankind. ");
INSERT INTO engmsb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","But as for you, be fruitful and multiply; spread out across the earth and multiply upon it.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Then God said to Noah and his sons with him, ");
INSERT INTO engmsb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Behold, I now establish My covenant with you and your descendants after you, ");
INSERT INTO engmsb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with every living creature that was with you—the birds, the livestock, and every beast of the earth—every living thing that came out of the ark. ");
INSERT INTO engmsb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","And I establish My covenant with you: Never again will all life be cut off by the waters of a flood; never again will there be a flood to destroy the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God said, “This is the sign of the covenant I am making between Me and you and every living creature with you, a covenant for all generations to come: ");
INSERT INTO engmsb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I have set My rainbow in the clouds, and it will be a sign of the covenant between Me and the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Whenever I form clouds over the earth and the rainbow appears in the clouds, ");
INSERT INTO engmsb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","I will remember My covenant between Me and you and every living creature of every kind. Never again will the waters become a flood to destroy all life. ");
INSERT INTO engmsb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","And whenever the rainbow appears in the clouds, I will see it and remember the everlasting covenant between God and every living creature of every kind that is on the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","So God said to Noah, “This is the sign of the covenant that I have established between Me and every creature on the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","The sons of Noah who came out of the ark were Shem, Ham, and Japheth. And Ham was the father of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three were the sons of Noah, and from them the whole earth was populated. ");
INSERT INTO engmsb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Now Noah, a man of the soil, proceeded to plant a vineyard. ");
INSERT INTO engmsb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","But when he drank some of its wine, he became drunk and uncovered himself inside his tent. ");
INSERT INTO engmsb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","And Ham, the father of Canaan, saw his father’s nakedness and told his two brothers outside. ");
INSERT INTO engmsb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Then Shem and Japheth took a garment and placed it across their shoulders, and walking backward, they covered their father’s nakedness. Their faces were turned away so that they did not see their father’s nakedness. ");
INSERT INTO engmsb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","When Noah awoke from his drunkenness and learned what his youngest son had done to him, ");
INSERT INTO engmsb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","he said, “Cursed be Canaan! A servant of servants shall he be to his brothers.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","He also declared: “Blessed be the LORD, the God of Shem! May Canaan be the servant of Shem. ");
INSERT INTO engmsb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God expand the territory of Japheth; may he dwell in the tents of Shem, and may Canaan be his servant.” ");
INSERT INTO engmsb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","After the flood, Noah lived 350 years. ");
INSERT INTO engmsb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","So Noah lived a total of 950 years, and then he died. ");
INSERT INTO engmsb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","This is the account of Noah’s sons Shem, Ham, and Japheth, who also had sons after the flood. ");
INSERT INTO engmsb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth: Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engmsb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer: Ashkenaz, Riphath, and Togarmah. ");
INSERT INTO engmsb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","And the sons of Javan: Elishah, Tarshish, the Kittites, and the Rodanites. ");
INSERT INTO engmsb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","From these, the maritime peoples separated into their territories, according to their languages, by clans within their nations. ");
INSERT INTO engmsb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The sons of Ham: Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The sons of Cush: Seba, Havilah, Sabtah, Raamah, and Sabteca. And the sons of Raamah: Sheba and Dedan. ");
INSERT INTO engmsb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush was the father of Nimrod, who began to be a mighty one on the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a mighty hunter before the LORD; so it is said, “Like Nimrod, a mighty hunter before the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","His kingdom began in Babylon, Erech, Accad, and Calneh, in the land of Shinar. ");
INSERT INTO engmsb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From that land he went forth into Assyria, where he built Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO engmsb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, which is between Nineveh and the great city of Calah. ");
INSERT INTO engmsb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim was the father of the Ludites, the Anamites, the Lehabites, the Naphtuhites, ");
INSERT INTO engmsb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","the Pathrusites, the Casluhites (from whom the Philistines came), and the Caphtorites. ");
INSERT INTO engmsb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","And Canaan was the father of Sidon his firstborn, and of the Hittites, ");
INSERT INTO engmsb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","the Jebusites, the Amorites, the Girgashites, ");
INSERT INTO engmsb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","the Hivites, the Arkites, the Sinites, ");
INSERT INTO engmsb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","the Arvadites, the Zemarites, and the Hamathites. Later the Canaanite clans were scattered, ");
INSERT INTO engmsb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","and the borders of Canaan extended from Sidon toward Gerar as far as Gaza, and then toward Sodom, Gomorrah, Admah, and Zeboiim, as far as Lasha. ");
INSERT INTO engmsb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These are the sons of Ham according to their clans, languages, lands, and nations. ");
INSERT INTO engmsb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","And sons were also born to Shem, the older brother of Japheth; Shem was the forefather of all the sons of Eber. ");
INSERT INTO engmsb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem: Elam, Asshur, Arphaxad, Lud, and Aram. ");
INSERT INTO engmsb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram: Uz, Hul, Gether, and Mash. ");
INSERT INTO engmsb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad was the father of Shelah, and Shelah was the father of Eber. ");
INSERT INTO engmsb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Two sons were born to Eber: One was named Peleg, because in his days the earth was divided, and his brother was named Joktan. ");
INSERT INTO engmsb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","And Joktan was the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engmsb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engmsb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engmsb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All these were sons of Joktan. ");
INSERT INTO engmsb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Their territory extended from Mesha to Sephar, in the eastern hill country. ");
INSERT INTO engmsb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the sons of Shem, according to their clans, languages, lands, and nations. ");
INSERT INTO engmsb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","All these are the clans of Noah’s sons, according to their generations and nations. From these the nations of the earth spread out after the flood. ");
INSERT INTO engmsb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Now the whole world had one language and a common form of speech. ");
INSERT INTO engmsb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","And as people journeyed eastward, they found a plain in the land of Shinar and settled there. ");
INSERT INTO engmsb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","And they said to one another, “Come, let us make bricks and bake them thoroughly.” So they used brick instead of stone, and tar instead of mortar. ");
INSERT INTO engmsb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","“Come,” they said, “let us build for ourselves a city with a tower that reaches to the heavens, that we may make a name for ourselves and not be scattered over the face of all the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Then the LORD came down to see the city and the tower that the sons of men were building. ");
INSERT INTO engmsb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","And the LORD said, “If they have begun to do this as one people speaking the same language, then nothing they devise will be beyond them. ");
INSERT INTO engmsb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Come, let Us go down and confuse their language, so that they will not understand one another’s speech.” ");
INSERT INTO engmsb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So the LORD scattered them from there over the face of all the earth, and they stopped building the city. ");
INSERT INTO engmsb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","That is why it is called Babel, for there the LORD confused the language of the whole world, and from that place the LORD scattered them over the face of all the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","This is the account of Shem. Two years after the flood, when Shem was 100 years old, he became the father of Arphaxad. ");
INSERT INTO engmsb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","And after he had become the father of Arphaxad, Shem lived 500 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphaxad was 35 years old, he became the father of Shelah. ");
INSERT INTO engmsb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","And after he had become the father of Shelah, Arphaxad lived 403 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","When Shelah was 30 years old, he became the father of Eber. ");
INSERT INTO engmsb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","And after he had become the father of Eber, Shelah lived 403 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","When Eber was 34 years old, he became the father of Peleg. ");
INSERT INTO engmsb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","And after he had become the father of Peleg, Eber lived 430 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","When Peleg was 30 years old, he became the father of Reu. ");
INSERT INTO engmsb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","And after he had become the father of Reu, Peleg lived 209 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","When Reu was 32 years old, he became the father of Serug. ");
INSERT INTO engmsb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","And after he had become the father of Serug, Reu lived 207 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","When Serug was 30 years old, he became the father of Nahor. ");
INSERT INTO engmsb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","And after he had become the father of Nahor, Serug lived 200 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","When Nahor was 29 years old, he became the father of Terah. ");
INSERT INTO engmsb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","And after he had become the father of Terah, Nahor lived 119 years and had other sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","When Terah was 70 years old, he became the father of Abram, Nahor, and Haran. ");
INSERT INTO engmsb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","This is the account of Terah. Terah became the father of Abram, Nahor, and Haran. And Haran became the father of Lot. ");
INSERT INTO engmsb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","During his father Terah’s lifetime, Haran died in his native land, in Ur of the Chaldeans. ");
INSERT INTO engmsb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","And Abram and Nahor took wives for themselves. Abram’s wife was named Sarai, and Nahor’s wife was named Milcah; she was the daughter of Haran, who was the father of both Milcah and Iscah. ");
INSERT INTO engmsb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","But Sarai was barren; she had no children. ");
INSERT INTO engmsb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","And Terah took his son Abram, his grandson Lot son of Haran, and his daughter-in-law Sarai the wife of Abram, and they set out from Ur of the Chaldeans for the land of Canaan. But when they arrived in Haran, they settled there. ");
INSERT INTO engmsb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah lived 205 years, and he died in Haran. ");
INSERT INTO engmsb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Then the LORD said to Abram, “Leave your country, your kindred, and your father’s household, and go to the land I will show you. ");
INSERT INTO engmsb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will make you into a great nation, and I will bless you; I will make your name great, so that you will be a blessing. ");
INSERT INTO engmsb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you and curse those who curse you; and all the families of the earth will be blessed through you.” ");
INSERT INTO engmsb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram departed, as the LORD had directed him, and Lot went with him. Abram was seventy-five years old when he left Haran. ");
INSERT INTO engmsb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","And Abram took his wife Sarai, his nephew Lot, and all the possessions and people they had acquired in Haran, and set out for the land of Canaan. When they came to the land of Canaan, ");
INSERT INTO engmsb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traveled through the land as far as the site of the Oak of Moreh at Shechem. And at that time the Canaanites were in the land. ");
INSERT INTO engmsb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Then the LORD appeared to Abram and said, “I will give this land to your offspring.” So Abram built an altar there to the LORD, who had appeared to him. ");
INSERT INTO engmsb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","From there Abram moved on to the hill country east of Bethel and pitched his tent, with Bethel to the west and Ai to the east. There he built an altar to the LORD, and he called on the name of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","And Abram journeyed on toward the Negev. ");
INSERT INTO engmsb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Now there was a famine in the land. So Abram went down to Egypt to live there for a while because the famine was severe. ");
INSERT INTO engmsb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As he was about to enter Egypt, he said to his wife Sarai, “Look, I know that you are a beautiful woman, ");
INSERT INTO engmsb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","and when the Egyptians see you, they will say, ‘This is his wife.’ Then they will kill me but will let you live. ");
INSERT INTO engmsb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Please say you are my sister, so that I will be treated well for your sake, and on account of you my life will be spared.” ");
INSERT INTO engmsb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","So when Abram entered Egypt, the Egyptians saw that the woman was very beautiful. ");
INSERT INTO engmsb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","When Pharaoh’s officials saw Sarai, they commended her to him, and she was taken into the palace of Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","He treated Abram well on her account, and Abram acquired sheep and cattle, male and female donkeys, menservants and maidservants, and camels. ");
INSERT INTO engmsb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","The LORD, however, afflicted Pharaoh and his household with severe plagues because of Abram’s wife Sarai. ");
INSERT INTO engmsb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","So Pharaoh summoned Abram and asked, “What have you done to me? Why didn’t you tell me she was your wife? ");
INSERT INTO engmsb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, ‘She is my sister,’ so that I took her as my wife? Now then, here is your wife. Take her and go!” ");
INSERT INTO engmsb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Then Pharaoh gave his men orders concerning Abram, and they sent him away with his wife and all his possessions. ");
INSERT INTO engmsb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram went up out of Egypt into the Negev—he and his wife and all his possessions—and Lot was with him. ");
INSERT INTO engmsb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","And Abram had become extremely wealthy in livestock and silver and gold. ");
INSERT INTO engmsb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","From the Negev he journeyed from place to place toward Bethel, until he came to the place between Bethel and Ai where his tent had formerly been pitched, ");
INSERT INTO engmsb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","to the site where he had built the altar. And there Abram called on the name of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Now Lot, who was traveling with Abram, also had flocks and herds and tents. ");
INSERT INTO engmsb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","But the land was unable to support both of them while they stayed together, for they had so many possessions that they were unable to coexist. ");
INSERT INTO engmsb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","And there was discord between the herdsmen of Abram and the herdsmen of Lot. At that time the Canaanites and the Perizzites were also living in the land. ");
INSERT INTO engmsb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","So Abram said to Lot, “Please let there be no contention between you and me, or between your herdsmen and my herdsmen. After all, we are kinsmen. ");
INSERT INTO engmsb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Is not the whole land before you? Now separate yourself from me. If you go to the left, I will go to the right; if you go to the right, I will go to the left.” ");
INSERT INTO engmsb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","And Lot looked out and saw that the whole plain of the Jordan, all the way to Zoar, was well watered like the garden of the LORD, like the land of Egypt. (This was before the LORD destroyed Sodom and Gomorrah.) ");
INSERT INTO engmsb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose the whole plain of the Jordan for himself and set out toward the east. And Abram and Lot parted company. ");
INSERT INTO engmsb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram lived in the land of Canaan, but Lot settled in the cities of the plain and pitched his tent toward Sodom. ");
INSERT INTO engmsb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","But the men of Sodom were wicked, sinning greatly against the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After Lot had departed, the LORD said to Abram, “Now lift up your eyes from the place where you are, and look to the north and south and east and west, ");
INSERT INTO engmsb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","for all the land that you see, I will give to you and your offspring forever. ");
INSERT INTO engmsb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will make your offspring like the dust of the earth, so that if one could count the dust of the earth, then your offspring could be counted. ");
INSERT INTO engmsb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Get up and walk around the land, through its length and breadth, for I will give it to you.” ");
INSERT INTO engmsb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram moved his tent and went to live near the Oaks of Mamre at Hebron, where he built an altar to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","In those days Amraphel king of Shinar, Arioch king of Ellasar, Chedorlaomer king of Elam, and Tidal king of Goiim ");
INSERT INTO engmsb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","went to war against Bera king of Sodom, Birsha king of Gomorrah, Shinab king of Admah, Shemeber king of Zeboiim, and the king of Bela (that is, Zoar). ");
INSERT INTO engmsb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","The latter five came as allies to the Valley of Siddim (that is, the Salt Sea). ");
INSERT INTO engmsb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","For twelve years they had been subject to Chedorlaomer, but in the thirteenth year they rebelled. ");
INSERT INTO engmsb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In the fourteenth year, Chedorlaomer and the kings allied with him went out and defeated the Rephaites in Ashteroth-karnaim, the Zuzites in Ham, the Emites in Shaveh-kiriathaim, ");
INSERT INTO engmsb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in the area of Mount Seir, as far as El-paran, which is near the desert. ");
INSERT INTO engmsb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they turned back to invade En-mishpat (that is, Kadesh), and they conquered the whole territory of the Amalekites, as well as the Amorites who lived in Hazazon-tamar. ");
INSERT INTO engmsb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Then the king of Sodom, the king of Gomorrah, the king of Admah, the king of Zeboiim, and the king of Bela (that is, Zoar) marched out and arrayed themselves for battle in the Valley of Siddim ");
INSERT INTO engmsb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","against Chedorlaomer king of Elam, Tidal king of Goiim, Amraphel king of Shinar, and Arioch king of Ellasar—four kings against five. ");
INSERT INTO engmsb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Now the Valley of Siddim was full of tar pits, and as the kings of Sodom and Gomorrah fled, some men fell into the pits, but the survivors fled to the hill country. ");
INSERT INTO engmsb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","The four kings seized all the goods of Sodom and Gomorrah and all their food, and they went on their way. ");
INSERT INTO engmsb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They also carried off Abram’s nephew Lot and his possessions, since Lot was living in Sodom. ");
INSERT INTO engmsb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Then an escapee came and reported this to Abram the Hebrew. Now Abram was living near the Oaks of Mamre the Amorite, a brother of Eshcol and Aner, all of whom were bound by treaty to Abram. ");
INSERT INTO engmsb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","And when Abram heard that his relative had been captured, he mobilized the 318 trained men born in his household, and they set out in pursuit as far as Dan. ");
INSERT INTO engmsb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","During the night, Abram divided his forces and routed Chedorlaomer’s army, pursuing them as far as Hobah, north of Damascus. ");
INSERT INTO engmsb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","He retrieved all the goods, as well as his relative Lot and his possessions, together with the women and the rest of the people. ");
INSERT INTO engmsb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","After Abram returned from defeating Chedorlaomer and the kings allied with him, the king of Sodom went out to meet him in the Valley of Shaveh (that is, the King’s Valley). ");
INSERT INTO engmsb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Then Melchizedek king of Salem brought out bread and wine—since he was priest of God Most High— ");
INSERT INTO engmsb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","and he blessed Abram and said: “Blessed be Abram by God Most High, Creator of heaven and earth, ");
INSERT INTO engmsb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","and blessed be God Most High, who has delivered your enemies into your hand.” Then Abram gave Melchizedek a tenth of everything. ");
INSERT INTO engmsb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","The king of Sodom said to Abram, “Give me the people, but take the goods for yourself.” ");
INSERT INTO engmsb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram replied to the king of Sodom, “I have raised my hand to the LORD God Most High, Creator of heaven and earth, ");
INSERT INTO engmsb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I will not accept even a thread, or a strap of a sandal, or anything that belongs to you, lest you should say, ‘I have made Abram rich.’ ");
INSERT INTO engmsb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","I will accept nothing but what my men have eaten and the share for the men who went with me—Aner, Eshcol, and Mamre. They may take their portion.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After these events, the word of the LORD came to Abram in a vision: “Do not be afraid, Abram. I am your shield, your very great reward.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","But Abram replied, “O Lord GOD, what can You give me, since I remain childless, and the heir of my house is Eliezer of Damascus?” ");
INSERT INTO engmsb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram continued, “Behold, You have given me no offspring, so a servant in my household will be my heir.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Then the word of the LORD came to Abram, saying, “This one will not be your heir, but one who comes from your own body will be your heir.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","And the LORD took him outside and said, “Now look to the heavens and count the stars, if you are able.” Then He told him, “So shall your offspring be.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram believed the LORD, and it was credited to him as righteousness. ");
INSERT INTO engmsb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","The LORD also told him, “I am the LORD, who brought you out of Ur of the Chaldeans to give you this land to possess.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","But Abram replied, “Lord GOD, how can I know that I will possess it?” ");
INSERT INTO engmsb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","And the LORD said to him, “Bring Me a heifer, a goat, and a ram, each three years old, along with a turtledove and a young pigeon.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","So Abram brought all these to Him, split each of them down the middle, and laid the halves opposite each other. The birds, however, he did not cut in half. ");
INSERT INTO engmsb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","And the birds of prey descended on the carcasses, but Abram drove them away. ");
INSERT INTO engmsb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","As the sun was setting, Abram fell into a deep sleep, and suddenly great terror and darkness overwhelmed him. ");
INSERT INTO engmsb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Then the LORD said to Abram, “Know for certain that your descendants will be strangers in a land that is not their own, and they will be enslaved and mistreated four hundred years. ");
INSERT INTO engmsb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","But I will judge the nation they serve as slaves, and afterward they will depart with many possessions. ");
INSERT INTO engmsb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","You, however, will go to your fathers in peace and be buried at a ripe old age. ");
INSERT INTO engmsb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","In the fourth generation your descendants will return here, for the iniquity of the Amorites is not yet complete.” ");
INSERT INTO engmsb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","When the sun had set and darkness had fallen, behold, a smoking firepot and a flaming torch appeared and passed between the halves of the carcasses. ");
INSERT INTO engmsb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","On that day the LORD made a covenant with Abram, saying, “To your descendants I have given this land—from the river of Egypt to the great River Euphrates— ");
INSERT INTO engmsb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","the land of the Kenites, Kenizzites, Kadmonites, ");
INSERT INTO engmsb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittites, Perizzites, Rephaites, ");
INSERT INTO engmsb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorites, Canaanites, Girgashites, and Jebusites.” ");
INSERT INTO engmsb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Now Abram’s wife Sarai had borne him no children, but she had an Egyptian maidservant named Hagar. ");
INSERT INTO engmsb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","So Sarai said to Abram, “Look now, the LORD has prevented me from bearing children. Please go to my maidservant; perhaps I can build a family by her.” And Abram listened to the voice of Sarai. ");
INSERT INTO engmsb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So after he had lived in Canaan for ten years, his wife Sarai took her Egyptian maidservant Hagar and gave her to Abram to be his wife. ");
INSERT INTO engmsb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","And he slept with Hagar, and she conceived. But when Hagar realized that she was pregnant, she began to despise her mistress. ");
INSERT INTO engmsb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai said to Abram, “May the wrong done to me be upon you! I delivered my servant into your arms, and ever since she saw that she was pregnant, she has treated me with contempt. May the LORD judge between you and me.” ");
INSERT INTO engmsb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“Here,” said Abram, “your servant is in your hands. Do whatever you want with her.” Then Sarai treated Hagar so harshly that she fled from her. ");
INSERT INTO engmsb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Now the angel of the LORD found Hagar by a spring of water in the desert—the spring along the road to Shur. ");
INSERT INTO engmsb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Hagar, servant of Sarai,” he said, “where have you come from, and where are you going?” “I am running away from my mistress Sarai,” she replied. ");
INSERT INTO engmsb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","So the angel of the LORD told her, “Return to your mistress and submit to her authority.” ");
INSERT INTO engmsb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Then the angel added, “I will greatly multiply your offspring so that they will be too numerous to count.” ");
INSERT INTO engmsb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The angel of the LORD proceeded: “Behold, you have conceived and will bear a son. And you shall name him Ishmael, for the LORD has heard your cry of affliction. ");
INSERT INTO engmsb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He will be a wild donkey of a man, and his hand will be against everyone, and everyone’s hand against him; he will live in hostility toward all his brothers.” ");
INSERT INTO engmsb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","So Hagar gave this name to the LORD who had spoken to her: “You are the God who sees me,” for she said, “Here I have seen the One who sees me!” ");
INSERT INTO engmsb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Therefore the well was called Beer-lahai-roi. It is located between Kadesh and Bered. ");
INSERT INTO engmsb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","And Hagar bore Abram a son, and Abram gave the name Ishmael to the son she had borne. ");
INSERT INTO engmsb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was eighty-six years old when Hagar bore Ishmael to him. ");
INSERT INTO engmsb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was ninety-nine years old, the LORD appeared to him and said, “I am God Almighty. Walk before Me and be blameless. ");
INSERT INTO engmsb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I will establish My covenant between Me and you, and I will multiply you exceedingly.” ");
INSERT INTO engmsb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Then Abram fell facedown, and God said to him, ");
INSERT INTO engmsb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“As for Me, this is My covenant with you: You will be the father of many nations. ");
INSERT INTO engmsb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","No longer will you be called Abram, but your name will be Abraham, for I have made you a father of many nations. ");
INSERT INTO engmsb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make you exceedingly fruitful; I will make nations of you, and kings will descend from you. ");
INSERT INTO engmsb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I will establish My covenant as an everlasting covenant between Me and you and your descendants after you, to be your God and the God of your descendants after you. ");
INSERT INTO engmsb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","And to you and your descendants I will give the land where you are residing—all the land of Canaan—as an eternal possession; and I will be their God.” ");
INSERT INTO engmsb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God also said to Abraham, “You must keep My covenant—you and your descendants in the generations after you. ");
INSERT INTO engmsb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is My covenant with you and your descendants after you, which you are to keep: Every male among you must be circumcised. ");
INSERT INTO engmsb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You are to circumcise the flesh of your foreskin, and this will be a sign of the covenant between Me and you. ");
INSERT INTO engmsb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Generation after generation, every male must be circumcised when he is eight days old, including those born in your household and those purchased from a foreigner—even those who are not your offspring. ");
INSERT INTO engmsb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Whether they are born in your household or purchased, they must be circumcised. My covenant in your flesh will be an everlasting covenant. ");
INSERT INTO engmsb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","But if any male is not circumcised, he will be cut off from his people; he has broken My covenant.” ");
INSERT INTO engmsb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Then God said to Abraham, “As for Sarai your wife, do not call her Sarai, for her name is to be Sarah. ");
INSERT INTO engmsb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","And I will bless her and will surely give you a son by her. I will bless her, and she will be the mother of nations; kings of peoples will descend from her.” ");
INSERT INTO engmsb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham fell facedown. Then he laughed and said to himself, “Can a child be born to a man who is a hundred years old? Can Sarah give birth at the age of ninety?” ");
INSERT INTO engmsb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","And Abraham said to God, “O that Ishmael might live under Your blessing!” ");
INSERT INTO engmsb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","But God replied, “Your wife Sarah will indeed bear you a son, and you are to name him Isaac. I will establish My covenant with him as an everlasting covenant for his descendants after him. ");
INSERT INTO engmsb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","As for Ishmael, I have heard you, and I will surely bless him; I will make him fruitful and multiply him greatly. He will become the father of twelve rulers, and I will make him into a great nation. ");
INSERT INTO engmsb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But I will establish My covenant with Isaac, whom Sarah will bear to you at this time next year.” ");
INSERT INTO engmsb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When He had finished speaking with Abraham, God went up from him. ");
INSERT INTO engmsb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","On that very day Abraham took his son Ishmael and all those born in his household or purchased with his money—every male among the members of Abraham’s household—and he circumcised them, just as God had told him. ");
INSERT INTO engmsb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","So Abraham was ninety-nine years old when he was circumcised, ");
INSERT INTO engmsb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","and his son Ishmael was thirteen; ");
INSERT INTO engmsb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham and his son Ishmael were circumcised on the same day. ");
INSERT INTO engmsb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","And all the men of Abraham’s household—both servants born in his household and those purchased from foreigners—were circumcised with him. ");
INSERT INTO engmsb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Then the LORD appeared to Abraham by the Oaks of Mamre in the heat of the day, while he was sitting at the entrance of his tent. ");
INSERT INTO engmsb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","And Abraham looked up and saw three men standing nearby. When he saw them, he ran from the entrance of his tent to meet them and bowed low to the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“My lord,” said Abraham, “if I have found favor in your sight, please do not pass your servant by. ");
INSERT INTO engmsb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let a little water be brought, that you may wash your feet and rest yourselves under the tree. ");
INSERT INTO engmsb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","And I will bring a bit of bread so that you may refresh yourselves. This is why you have passed your servant’s way. After that, you may continue on your way.” “Yes,” they replied, “you may do as you have said.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","So Abraham hurried into the tent and said to Sarah, “Quick! Prepare three seahs of fine flour, knead it, and bake some bread.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Meanwhile, Abraham ran to the herd, selected a tender and choice calf, and gave it to a servant, who hurried to prepare it. ");
INSERT INTO engmsb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Then Abraham brought curds and milk and the calf that had been prepared, and he set them before the men and stood by them under the tree as they ate. ");
INSERT INTO engmsb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Where is your wife Sarah?” they asked. “There, in the tent,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Then the LORD said, “I will surely return to you at this time next year, and your wife Sarah will have a son!” Now Sarah was behind him, listening at the entrance to the tent. ");
INSERT INTO engmsb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","And Abraham and Sarah were already old and well along in years; Sarah had passed the age of childbearing. ");
INSERT INTO engmsb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","So she laughed to herself, saying, “After I am worn out and my master is old, will I now have this pleasure?” ");
INSERT INTO engmsb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","And the LORD asked Abraham, “Why did Sarah laugh and say, ‘Can I really bear a child when I am old?’ ");
INSERT INTO engmsb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is anything too difficult for the LORD? At the appointed time I will return to you—in about a year—and Sarah will have a son.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","But Sarah was afraid, so she denied it and said, “I did not laugh.” “No,” replied the LORD, “but you did laugh.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","When the men got up to leave, they looked out over Sodom, and Abraham walked along with them to see them off. ");
INSERT INTO engmsb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","And the LORD said, “Shall I hide from Abraham what I am about to do? ");
INSERT INTO engmsb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham will surely become a great and powerful nation, and through him all the nations of the earth will be blessed. ");
INSERT INTO engmsb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","For I have chosen him, so that he will command his children and his household after him to keep the way of the LORD by doing what is right and just, in order that the LORD may bring upon Abraham what He has promised.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Then the LORD said, “The outcry against Sodom and Gomorrah is great. Because their sin is so grievous, ");
INSERT INTO engmsb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go down to see if their actions fully justify the outcry that has reached Me. If not, I will find out.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","And the two men turned away and went toward Sodom, but Abraham remained standing before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham stepped forward and said, “Will You really sweep away the righteous with the wicked? ");
INSERT INTO engmsb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What if there are fifty righteous ones in the city? Will You really sweep it away and not spare the place for the sake of the fifty righteous ones who are there? ");
INSERT INTO engmsb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Far be it from You to do such a thing—to kill the righteous with the wicked, so that the righteous and the wicked are treated alike. Far be it from You! Will not the Judge of all the earth do what is right?” ");
INSERT INTO engmsb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","So the LORD replied, “If I find fifty righteous ones within the city of Sodom, on their account I will spare the whole place.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Then Abraham answered, “Now that I have ventured to speak to the Lord—though I am but dust and ashes— ");
INSERT INTO engmsb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","suppose the fifty righteous ones lack five. Will You destroy the whole city for the lack of five?” He replied, “If I find forty-five there, I will not destroy it.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Once again Abraham spoke to the LORD, “Suppose forty are found there?” He answered, “On account of the forty, I will not do it.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Then Abraham said, “May the Lord not be angry, but let me speak further. Suppose thirty are found there?” He replied, “If I find thirty there, I will not do it.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","And Abraham said, “Now that I have ventured to speak to the Lord, suppose twenty are found there?” He answered, “On account of the twenty, I will not destroy it.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Finally, Abraham said, “May the Lord not be angry, but let me speak once more. Suppose ten are found there?” And He answered, “On account of the ten, I will not destroy it.” ");
INSERT INTO engmsb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","When the LORD had finished speaking with Abraham, He departed, and Abraham returned home. ");
INSERT INTO engmsb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Now the two angels arrived at Sodom in the evening, and Lot was sitting in the gateway of the city. When Lot saw them, he got up to meet them, bowed facedown, ");
INSERT INTO engmsb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","and said, “My lords, please turn aside into the house of your servant; wash your feet and spend the night. Then you can rise early and go on your way.” “No,” they answered, “we will spend the night in the square.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But Lot insisted so strongly that they followed him into his house. He prepared a feast for them and baked unleavened bread, and they ate. ");
INSERT INTO engmsb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Before they had gone to bed, all the men of the city of Sodom, both young and old, surrounded the house. ");
INSERT INTO engmsb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They called out to Lot, saying, “Where are the men who came to you tonight? Send them out to us so we can have relations with them!” ");
INSERT INTO engmsb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went outside to meet them, shutting the door behind him. ");
INSERT INTO engmsb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Please, my brothers,” he pleaded, “don’t do such a wicked thing! ");
INSERT INTO engmsb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Look, I have two daughters who have never slept with a man. Let me bring them to you, and you can do to them as you please. But do not do anything to these men, for they have come under the protection of my roof.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Get out of the way!” they replied. And they declared, “This one came here as a foreigner, and he is already acting like a judge! Now we will treat you worse than them.” And they pressed in on Lot and moved in to break down the door. ");
INSERT INTO engmsb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the men inside reached out, pulled Lot into the house with them, and shut the door. ");
INSERT INTO engmsb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","And they struck the men at the entrance, young and old, with blindness, so that they wearied themselves trying to find the door. ");
INSERT INTO engmsb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Then the two men said to Lot, “Do you have anyone else here—a son-in-law, your sons or daughters, or anyone else in the city who belongs to you? Get them out of here, ");
INSERT INTO engmsb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","because we are about to destroy this place. For the outcry to the LORD against its people is so great that He has sent us to destroy it.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","So Lot went out and spoke to the sons-in-law who were pledged in marriage to his daughters. “Get up,” he said. “Get out of this place, for the LORD is about to destroy the city!” But his sons-in-law thought he was joking. ");
INSERT INTO engmsb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","At daybreak the angels hurried Lot along, saying, “Get up! Take your wife and your two daughters who are here, or you will be swept away in the punishment of the city.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But when Lot hesitated, the men grabbed his hand and the hands of his wife and his two daughters. And they led them safely out of the city, because of the LORD’s compassion for them. ");
INSERT INTO engmsb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","As soon as the men had brought them out, one of them said, “Run for your lives! Do not look back, and do not stop anywhere on the plain! Flee to the mountains, or you will be swept away!” ");
INSERT INTO engmsb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","But Lot replied, “No, my lords, please! ");
INSERT INTO engmsb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Your servant has indeed found favor in your sight, and you have shown me great kindness by sparing my life. But I cannot run to the mountains; the disaster will overtake me, and I will die. ");
INSERT INTO engmsb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, there is a town nearby where I can flee, and it is a small place. Please let me flee there—is it not a small place? Then my life will be saved.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Very well,” he answered, “I will grant this request as well, and will not demolish the town you indicate. ");
INSERT INTO engmsb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hurry! Run there quickly, for I cannot do anything until you reach it.” That is why the town was called Zoar. ");
INSERT INTO engmsb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","And by the time the sun had risen over the land, Lot had reached Zoar. ");
INSERT INTO engmsb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then the LORD rained down sulfur and fire on Sodom and Gomorrah—from the LORD out of the heavens. ");
INSERT INTO engmsb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Thus He destroyed these cities and the entire plain, including all the inhabitants of the cities and everything that grew on the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot’s wife looked back, and she became a pillar of salt. ");
INSERT INTO engmsb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Early the next morning, Abraham got up and returned to the place where he had stood before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked down toward Sodom and Gomorrah and all the land of the plain, and he saw the smoke rising from the land like smoke from a furnace. ");
INSERT INTO engmsb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","So when God destroyed the cities of the plain, He remembered Abraham, and He brought Lot out of the catastrophe that destroyed the cities where he had lived. ");
INSERT INTO engmsb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot and his two daughters left Zoar and settled in the mountains—for he was afraid to stay in Zoar—where they lived in a cave. ");
INSERT INTO engmsb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","One day the older daughter said to the younger, “Our father is old, and there is no man in the land to sleep with us, as is the custom over all the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come, let us get our father drunk with wine so we can sleep with him and preserve his line.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So that night they got their father drunk with wine, and the firstborn went in and slept with her father; he was not aware when she lay down or when she got up. ");
INSERT INTO engmsb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day the older daughter said to the younger, “Look, I slept with my father last night. Let us get him drunk with wine again tonight so you can go in and sleep with him and we can preserve our father’s line.” ");
INSERT INTO engmsb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So again that night they got their father drunk with wine, and the younger daughter went in and slept with him; he was not aware when she lay down or when she got up. ");
INSERT INTO engmsb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Thus both of Lot’s daughters became pregnant by their father. ");
INSERT INTO engmsb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The older daughter gave birth to a son and named him Moab. He is the father of the Moabites of today. ");
INSERT INTO engmsb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger daughter also gave birth to a son, and she named him Ben-ammi. He is the father of the Ammonites of today. ");
INSERT INTO engmsb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Now Abraham journeyed from there to the region of the Negev and settled between Kadesh and Shur. While he was staying in Gerar, ");
INSERT INTO engmsb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham said of his wife Sarah, “She is my sister.” So Abimelech king of Gerar had Sarah brought to him. ");
INSERT INTO engmsb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","One night, however, God came to Abimelech in a dream and told him, “You are as good as dead because of the woman you have taken, for she is a married woman.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Now Abimelech had not gone near her, so he replied, “Lord, would You destroy a nation even though it is innocent? ");
INSERT INTO engmsb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Didn’t Abraham tell me, ‘She is my sister’? And she herself said, ‘He is my brother.’ I have done this in the integrity of my heart and the innocence of my hands.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Then God said to Abimelech in the dream, “Yes, I know that you did this with a clear conscience, and so I have kept you from sinning against Me. That is why I did not let you touch her. ");
INSERT INTO engmsb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Now return the man’s wife, for he is a prophet; he will pray for you and you will live. But if you do not restore her, be aware that you will surely die—you and all who belong to you.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Early the next morning Abimelech got up and summoned all his servants; and when he described to them all that had happened, the men were terrified. ");
INSERT INTO engmsb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech called Abraham and asked, “What have you done to us? How have I sinned against you, that you have brought such tremendous guilt upon me and my kingdom? You have done things to me that should not be done.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelech also asked Abraham, “What prompted you to do such a thing?” ");
INSERT INTO engmsb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham replied, “I thought to myself, ‘Surely there is no fear of God in this place. They will kill me on account of my wife.’ ");
INSERT INTO engmsb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Besides, she really is my sister, the daughter of my father—though not the daughter of my mother—and she became my wife. ");
INSERT INTO engmsb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","So when God had me journey from my father’s house, I said to Sarah, ‘This is how you can show your loyalty to me: Wherever we go, say of me, “He is my brother.”’” ");
INSERT INTO engmsb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","So Abimelech brought sheep and cattle, menservants and maidservants, and he gave them to Abraham and restored his wife Sarah to him. ");
INSERT INTO engmsb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelech said, “Look, my land is before you. Settle wherever you please.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","And he said to Sarah, “See, I am giving your brother a thousand pieces of silver. It is your vindication before all who are with you; you are completely cleared.” ");
INSERT INTO engmsb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Then Abraham prayed to God, and God healed Abimelech and his wife and his maidservants, so that they could again bear children— ");
INSERT INTO engmsb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","for on account of Abraham’s wife Sarah, the LORD had completely closed all the wombs in Abimelech’s household. ");
INSERT INTO engmsb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Now the LORD attended to Sarah as He had said, and the LORD did for Sarah what He had promised. ");
INSERT INTO engmsb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","So Sarah conceived and bore a son to Abraham in his old age, at the very time God had promised. ");
INSERT INTO engmsb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","And Abraham gave the name Isaac to the son Sarah bore to him. ");
INSERT INTO engmsb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","When his son Isaac was eight days old, Abraham circumcised him, as God had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was a hundred years old when his son Isaac was born to him. ");
INSERT INTO engmsb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Then Sarah said, “God has made me laugh, and everyone who hears of this will laugh with me.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She added, “Who would have told Abraham that Sarah would nurse children? Yet I have borne him a son in his old age.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","So the child grew and was weaned, and Abraham held a great feast on the day Isaac was weaned. ");
INSERT INTO engmsb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","But Sarah saw that the son whom Hagar the Egyptian had borne to Abraham was mocking her son, ");
INSERT INTO engmsb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","and she said to Abraham, “Expel the slave woman and her son, for the slave woman’s son will never share in the inheritance with my son Isaac!” ");
INSERT INTO engmsb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Now this matter distressed Abraham greatly because it concerned his son Ishmael. ");
INSERT INTO engmsb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Do not be distressed about the boy and your maidservant. Listen to everything that Sarah tells you, for through Isaac your offspring will be reckoned. ");
INSERT INTO engmsb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","But I will also make a nation of the slave woman’s son, because he is your offspring.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Early in the morning, Abraham got up, took bread and a skin of water, put them on Hagar’s shoulders, and sent her away with the boy. She left and wandered in the Wilderness of Beersheba. ");
INSERT INTO engmsb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","When the water in the skin was gone, she left the boy under one of the bushes. ");
INSERT INTO engmsb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Then she went off and sat down nearby, about a bowshot away, for she said, “I cannot bear to watch the boy die!” And as she sat nearby, she lifted up her voice and wept. ");
INSERT INTO engmsb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Then God heard the voice of the boy, and the angel of God called to Hagar from heaven, “What is wrong, Hagar? Do not be afraid, for God has heard the voice of the boy where he lies. ");
INSERT INTO engmsb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Get up, lift up the boy, and take him by the hand, for I will make him into a great nation.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God opened her eyes, and she saw a well of water. So she went and filled the skin with water and gave the boy a drink. ");
INSERT INTO engmsb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","And God was with the boy, and he grew up and settled in the wilderness and became a great archer. ");
INSERT INTO engmsb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","And while he was dwelling in the Wilderness of Paran, his mother got a wife for him from the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","At that time Abimelech and Phicol the commander of his army said to Abraham, “God is with you in all that you do. ");
INSERT INTO engmsb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Now, therefore, swear to me here before God that you will not deal falsely with me or my children or descendants. Show to me and to the country in which you reside the same kindness that I have shown to you.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Abraham replied, “I swear it.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","But when Abraham complained to Abimelech about a well that Abimelech’s servants had seized, ");
INSERT INTO engmsb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelech replied, “I do not know who has done this. You did not tell me, so I have not heard about it until today.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","So Abraham brought sheep and cattle and gave them to Abimelech, and the two men made a covenant. ");
INSERT INTO engmsb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham separated seven ewe lambs from the flock, ");
INSERT INTO engmsb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","and Abimelech asked him, “Why have you set apart these seven ewe lambs?” ");
INSERT INTO engmsb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","He replied, “You are to accept the seven ewe lambs from my hand as my witness that I dug this well.” ");
INSERT INTO engmsb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","So that place was called Beersheba, because it was there that the two of them swore an oath. ");
INSERT INTO engmsb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","After they had made the covenant at Beersheba, Abimelech and Phicol the commander of his army got up and returned to the land of the Philistines. ");
INSERT INTO engmsb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","And Abraham planted a tamarisk tree in Beersheba, and there he called upon the name of the LORD, the Eternal God. ");
INSERT INTO engmsb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","And Abraham resided in the land of the Philistines for a long time. ");
INSERT INTO engmsb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Some time later God tested Abraham and said to him, “Abraham!” “Here I am,” he answered. ");
INSERT INTO engmsb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Take your son,” God said, “your only son Isaac, whom you love, and go to the land of Moriah. Offer him there as a burnt offering on one of the mountains, which I will show you.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","So Abraham got up early the next morning, saddled his donkey, and took along two of his servants and his son Isaac. He split the wood for a burnt offering and set out for the place God had designated. ");
INSERT INTO engmsb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","On the third day Abraham looked up and saw the place in the distance. ");
INSERT INTO engmsb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","“Stay here with the donkey,” Abraham told his servants. “The boy and I will go over there to worship, and then we will return to you.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham took the wood for the burnt offering and placed it on his son Isaac. He himself carried the fire and the sacrificial knife, and the two of them walked on together. ");
INSERT INTO engmsb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Then Isaac said to his father Abraham, “My father!” “Here I am, my son,” he replied. “The fire and the wood are here,” said Isaac, “but where is the lamb for the burnt offering?” ");
INSERT INTO engmsb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham answered, “God Himself will provide the lamb for the burnt offering, my son.” And the two walked on together. ");
INSERT INTO engmsb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","When they arrived at the place God had designated, Abraham built the altar there and arranged the wood. He bound his son Isaac and placed him on the altar, atop the wood. ");
INSERT INTO engmsb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Then Abraham reached out his hand and took the knife to slaughter his son. ");
INSERT INTO engmsb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Just then the angel of the LORD called out to him from heaven, “Abraham, Abraham!” “Here I am,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Do not lay a hand on the boy or do anything to him,” said the angel, “for now I know that you fear God, since you have not withheld your only son from me.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Then Abraham looked up and saw behind him a ram in a thicket, caught by its horns. So he went and took the ram and offered it as a burnt offering in place of his son. ");
INSERT INTO engmsb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","And Abraham called that place The LORD Will Provide. So to this day it is said, “On the mountain of the LORD it will be provided.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","And the angel of the LORD called to Abraham from heaven a second time, ");
INSERT INTO engmsb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","saying, “By Myself I have sworn, declares the LORD, that because you have done this and have not withheld your only son, ");
INSERT INTO engmsb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I will surely bless you, and I will multiply your descendants like the stars in the sky and the sand on the seashore. Your descendants will possess the gates of their enemies. ");
INSERT INTO engmsb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","And through your offspring all nations of the earth will be blessed, because you have obeyed My voice.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham went back to his servants, and they got up and set out together for Beersheba. And Abraham settled in Beersheba. ");
INSERT INTO engmsb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Some time later, Abraham was told, “Milcah has also borne sons to your brother Nahor: ");
INSERT INTO engmsb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz the firstborn, his brother Buz, Kemuel (the father of Aram), ");
INSERT INTO engmsb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, and Bethuel.” ");
INSERT INTO engmsb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","And Bethuel became the father of Rebekah. Milcah bore these eight sons to Abraham’s brother Nahor. ");
INSERT INTO engmsb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Moreover, Nahor’s concubine, whose name was Reumah, bore Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engmsb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Now Sarah lived to be 127 years old. ");
INSERT INTO engmsb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","She died in Kiriath-arba (that is, Hebron) in the land of Canaan, and Abraham went out to mourn and to weep for her. ");
INSERT INTO engmsb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Then Abraham got up from beside his dead wife and said to the Hittites, ");
INSERT INTO engmsb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a foreigner and an outsider among you. Give me a burial site among you so that I can bury my dead.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The Hittites replied to Abraham, ");
INSERT INTO engmsb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Listen to us, sir. You are God’s chosen one among us. Bury your dead in the finest of our tombs. None of us will withhold his tomb for burying your dead.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Then Abraham rose and bowed down before the people of the land, the Hittites. ");
INSERT INTO engmsb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“If you are willing for me to bury my dead,” he said to them, “listen to me, and approach Ephron son of Zohar on my behalf ");
INSERT INTO engmsb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","to sell me the cave of Machpelah that belongs to him; it is at the end of his field. Let him sell it to me in your presence for full price, so that I may have a burial site.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Now Ephron was sitting among the sons of Heth. So in the presence of all the Hittites who had come to the gate of his city, Ephron the Hittite answered Abraham, ");
INSERT INTO engmsb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, my lord. Listen to me. I give you the field, and I give you the cave that is in it. I give it to you in the presence of my people. Bury your dead.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Again Abraham bowed down before the people of the land ");
INSERT INTO engmsb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","and said to Ephron in their presence, “If you will please listen to me, I will pay you the price of the field. Accept it from me, so that I may bury my dead there.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, ");
INSERT INTO engmsb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Listen to me, my lord. The land is worth four hundred shekels of silver, but what is that between you and me? Bury your dead.” ");
INSERT INTO engmsb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham agreed to Ephron’s terms and weighed out for him the price he had named in the hearing of the Hittites: four hundred shekels of silver, according to the standard of the merchants. ");
INSERT INTO engmsb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So Ephron’s field at Machpelah near Mamre, the cave that was in it, and all the trees within the boundaries of the field were deeded over ");
INSERT INTO engmsb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","to Abraham’s possession in the presence of all the Hittites who had come to the gate of his city. ");
INSERT INTO engmsb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After this, Abraham buried his wife Sarah in the cave of the field at Machpelah near Mamre (that is, Hebron) in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","So the field and its cave were deeded by the Hittites to Abraham as a burial site. ");
INSERT INTO engmsb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","By now Abraham was old and well along in years, and the LORD had blessed him in every way. ");
INSERT INTO engmsb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","So Abraham instructed the chief servant of his household, who managed all he owned, “Place your hand under my thigh, ");
INSERT INTO engmsb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","and I will have you swear by the LORD, the God of heaven and the God of earth, that you will not take a wife for my son from the daughters of the Canaanites among whom I am dwelling, ");
INSERT INTO engmsb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","but will go to my country and my kindred to take a wife for my son Isaac.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant asked him, “What if the woman is unwilling to follow me to this land? Shall I then take your son back to the land from which you came?” ");
INSERT INTO engmsb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham replied, “Make sure that you do not take my son back there. ");
INSERT INTO engmsb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","The LORD, the God of heaven, who brought me from my father’s house and my native land, who spoke to me and promised me on oath, saying, ‘To your offspring I will give this land’—He will send His angel before you so that you can take a wife for my son from there. ");
INSERT INTO engmsb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","And if the woman is unwilling to follow you, then you are released from this oath of mine. Only do not take my son back there.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So the servant placed his hand under the thigh of his master Abraham and swore an oath to him concerning this matter. ");
INSERT INTO engmsb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Then the servant took ten of his master’s camels and departed with all manner of good things from his master in hand. And he set out for Nahor’s hometown in Aram-naharaim. ");
INSERT INTO engmsb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","As evening approached, he made the camels kneel down near the well outside the town at the time when the women went out to draw water. ");
INSERT INTO engmsb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","“O LORD, God of my master Abraham,” he prayed, “please grant me success today, and show kindness to my master Abraham. ");
INSERT INTO engmsb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Here I am, standing beside the spring, and the daughters of the townspeople are coming out to draw water. ");
INSERT INTO engmsb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Now may it happen that the girl to whom I say, ‘Please let down your jar that I may drink,’ and who responds, ‘Drink, and I will water your camels as well’—let her be the one You have appointed for Your servant Isaac. By this I will know that You have shown kindness to my master.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Before the servant had finished praying, Rebekah came out with her jar on her shoulder. She was the daughter of Bethuel son of Milcah, the wife of Abraham’s brother Nahor. ");
INSERT INTO engmsb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Now the girl was very beautiful, a virgin who had not had relations with any man. She went down to the spring, filled her jar, and came up again. ");
INSERT INTO engmsb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","So the servant ran to meet her and said, “Please let me have a little water from your jar.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Drink, my lord,” she replied, and she quickly lowered her jar to her hands and gave him a drink. ");
INSERT INTO engmsb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","After she had given him a drink, she said, “I will also draw water for your camels, until they have had enough to drink.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","And she quickly emptied her jar into the trough and ran back to the well to draw water, until she had drawn water for all his camels. ");
INSERT INTO engmsb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Meanwhile, the man watched her silently to see whether or not the LORD had made his journey a success. ");
INSERT INTO engmsb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","And after the camels had finished drinking, he took out a gold ring weighing a beka, and two gold bracelets for her wrists weighing ten shekels. ");
INSERT INTO engmsb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“Whose daughter are you?” he asked. “Please tell me, is there room in your father’s house for us to spend the night?” ");
INSERT INTO engmsb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She replied, “I am the daughter of Bethuel, the son that Milcah bore to Nahor.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Then she added, “We have plenty of straw and feed, as well as a place for you to spend the night.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Then the man bowed down and worshiped the LORD, ");
INSERT INTO engmsb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","saying, “Blessed be the LORD, the God of my master Abraham, who has not withheld His kindness and faithfulness from my master. As for me, the LORD has led me on the journey to the house of my master’s relatives.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","The girl ran and told her mother’s household about these things. ");
INSERT INTO engmsb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Now Rebekah had a brother named Laban, and he rushed out to the man at the spring. ");
INSERT INTO engmsb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","As soon as he saw the ring, and the bracelets on his sister’s wrists, and heard Rebekah’s words, “The man said this to me,” he went and found the man standing by the camels near the spring. ");
INSERT INTO engmsb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Come, you who are blessed by the LORD,” said Laban. “Why are you standing out here? I have prepared the house and a place for the camels.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So the man came to the house, and the camels were unloaded. Straw and feed were brought to the camels, and water to wash his feet and the feet of his companions. ");
INSERT INTO engmsb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Then a meal was set before the man, but he said, “I will not eat until I have told you what I came to say.” So Laban said, “Please speak.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“I am Abraham’s servant,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“The LORD has greatly blessed my master, and he has become rich. He has given him sheep and cattle, silver and gold, menservants and maidservants, camels and donkeys. ");
INSERT INTO engmsb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","My master’s wife Sarah has borne him a son in her old age, and my master has given him everything he owns. ");
INSERT INTO engmsb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me swear an oath and said, ‘You shall not take a wife for my son from the daughters of the Canaanites in whose land I dwell, ");
INSERT INTO engmsb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","but you shall go to my father’s house and to my kindred to take a wife for my son.’ ");
INSERT INTO engmsb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Then I asked my master, ‘What if the woman will not come back with me?’ ");
INSERT INTO engmsb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","And he told me, ‘The LORD, before whom I have walked, will send His angel with you and make your journey a success, so that you may take a wife for my son from my kindred and from my father’s house. ");
INSERT INTO engmsb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","And when you go to my kindred, if they refuse to give her to you, then you will be released from my oath.’ ");
INSERT INTO engmsb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","So when I came to the spring today, I prayed: O LORD, God of my master Abraham, if only You would make my journey a success! ");
INSERT INTO engmsb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Here I am, standing beside this spring. Now if a maiden comes out to draw water and I say to her, ‘Please let me drink a little water from your jar,’ ");
INSERT INTO engmsb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","and she replies, ‘Drink, and I will draw water for your camels as well,’ may she be the woman the LORD has appointed for my master’s son. ");
INSERT INTO engmsb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","And before I had finished praying in my heart, there was Rebekah coming out with her jar on her shoulder, and she went down to the spring and drew water. So I said to her, ‘Please give me a drink.’ ");
INSERT INTO engmsb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lowered her jar from her shoulder and said, ‘Drink, and I will water your camels as well.’ So I drank, and she also watered the camels. ");
INSERT INTO engmsb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Then I asked her, ‘Whose daughter are you?’ She replied, ‘The daughter of Bethuel son of Nahor, whom Milcah bore to him.’ So I put the ring on her nose and the bracelets on her wrists. ");
INSERT INTO engmsb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I bowed down and worshiped the LORD; and I blessed the LORD, the God of my master Abraham, who led me on the right road to take the granddaughter of my master’s brother for his son. ");
INSERT INTO engmsb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now if you will show kindness and faithfulness to my master, tell me; but if not, let me know, so that I may go elsewhere.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban and Bethuel answered, “This is from the LORD; we have no choice in the matter. ");
INSERT INTO engmsb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah is here before you. Take her and go, and let her become the wife of your master’s son, just as the LORD has decreed.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham’s servant heard their words, he bowed down to the ground before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then he brought out jewels of silver and gold, and articles of clothing, and he gave them to Rebekah. He also gave precious gifts to her brother and her mother. ");
INSERT INTO engmsb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Then he and the men with him ate and drank and spent the night there. When they got up the next morning, he said, “Send me on my way to my master.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But her brother and mother said, “Let the girl remain with us ten days or so. After that, she may go.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","But he replied, “Do not delay me, since the LORD has made my journey a success. Send me on my way so that I may go to my master.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","So they said, “We will call the girl and ask her opinion.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","They called Rebekah and asked her, “Will you go with this man?” “I will go,” she replied. ");
INSERT INTO engmsb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they sent their sister Rebekah on her way, along with her nurse and Abraham’s servant and his men. ");
INSERT INTO engmsb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","And they blessed Rebekah and said to her, “Our sister, may you become the mother of thousands upon thousands. May your offspring possess the gates of their enemies.” ");
INSERT INTO engmsb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her servant girls got ready, mounted the camels, and followed the man. So the servant took Rebekah and left. ");
INSERT INTO engmsb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Now Isaac had just returned from Beer-lahai-roi, for he was living in the Negev. ");
INSERT INTO engmsb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Early in the evening, Isaac went out to the field to meditate, and looking up, he saw the camels approaching. ");
INSERT INTO engmsb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","And when Rebekah looked up and saw Isaac, she got down from her camel ");
INSERT INTO engmsb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","and asked the servant, “Who is that man in the field coming to meet us?” “It is my master,” the servant answered. So she took her veil and covered herself. ");
INSERT INTO engmsb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Then the servant told Isaac all that he had done. ");
INSERT INTO engmsb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","And Isaac brought her into the tent of his mother Sarah and took Rebekah as his wife. And Isaac loved her and was comforted after his mother’s death. ");
INSERT INTO engmsb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Now Abraham had taken another wife, named Keturah, ");
INSERT INTO engmsb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","and she bore him Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engmsb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan was the father of Sheba and Dedan. And the sons of Dedan were the Asshurites, the Letushites, and the Leummites. ");
INSERT INTO engmsb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. All these were descendants of Keturah. ");
INSERT INTO engmsb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham left everything he owned to Isaac. ");
INSERT INTO engmsb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But while he was still alive, Abraham gave gifts to the sons of his concubines and sent them away from his son Isaac to the land of the east. ");
INSERT INTO engmsb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham lived a total of 175 years. ");
INSERT INTO engmsb_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","And at a ripe old age he breathed his last and died, old and contented, and was gathered to his people. ");
INSERT INTO engmsb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","His sons Isaac and Ishmael buried him in the cave of Machpelah near Mamre, in the field of Ephron son of Zohar the Hittite. ");
INSERT INTO engmsb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","This was the field that Abraham had bought from the Hittites. Abraham was buried there with his wife Sarah. ");
INSERT INTO engmsb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After Abraham’s death, God blessed his son Isaac, who lived near Beer-lahai-roi. ");
INSERT INTO engmsb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","This is the account of Abraham’s son Ishmael, whom Hagar the Egyptian, Sarah’s maidservant, bore to Abraham. ");
INSERT INTO engmsb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are the names of the sons of Ishmael in the order of their birth: Nebaioth the firstborn of Ishmael, then Kedar, Adbeel, Mibsam, ");
INSERT INTO engmsb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engmsb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engmsb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These were the sons of Ishmael, and these were their names by their villages and encampments—twelve princes of their tribes. ");
INSERT INTO engmsb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived a total of 137 years. Then he breathed his last and died, and was gathered to his people. ");
INSERT INTO engmsb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ishmael’s descendants settled from Havilah to Shur, which is near the border of Egypt as you go toward Asshur. And they lived in hostility toward all their brothers. ");
INSERT INTO engmsb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","This is the account of Abraham’s son Isaac. Abraham became the father of Isaac, ");
INSERT INTO engmsb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","and Isaac was forty years old when he married Rebekah, the daughter of Bethuel the Aramean from Paddan-aram and the sister of Laban the Aramean. ");
INSERT INTO engmsb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Later, Isaac prayed to the LORD on behalf of his wife, because she was barren. And the LORD heard his prayer, and his wife Rebekah conceived. ");
INSERT INTO engmsb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","But the children inside her struggled with each other, and she said, “Why is this happening to me?” So Rebekah went to inquire of the LORD, ");
INSERT INTO engmsb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","and He declared to her: “Two nations are in your womb, and two peoples from within you will be separated; one people will be stronger than the other, and the older will serve the younger.” ");
INSERT INTO engmsb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When her time came to give birth, there were indeed twins in her womb. ");
INSERT INTO engmsb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first one came out red, covered with hair like a fur coat; so they named him Esau. ");
INSERT INTO engmsb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","After this, his brother came out grasping Esau’s heel; so he was named Jacob. And Isaac was sixty years old when the twins were born. ");
INSERT INTO engmsb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","When the boys grew up, Esau became a skillful hunter, a man of the field, while Jacob was a quiet man who stayed at home. ");
INSERT INTO engmsb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Because Isaac had a taste for wild game, he loved Esau; but Rebekah loved Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day, while Jacob was cooking some stew, Esau came in from the field and was famished. ");
INSERT INTO engmsb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","He said to Jacob, “Let me eat some of that red stew, for I am famished.” (That is why he was also called Edom.) ");
INSERT INTO engmsb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","“First sell me your birthright,” Jacob replied. ");
INSERT INTO engmsb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Look,” said Esau, “I am about to die, so what good is a birthright to me?” ");
INSERT INTO engmsb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","“Swear to me first,” Jacob said. So Esau swore to Jacob and sold him the birthright. ");
INSERT INTO engmsb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave some bread and lentil stew to Esau, who ate and drank and then got up and went away. Thus Esau despised his birthright. ");
INSERT INTO engmsb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Now there was another famine in the land, subsequent to the one that had occurred in Abraham’s time. And Isaac went to Abimelech king of the Philistines at Gerar. ");
INSERT INTO engmsb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","The LORD appeared to Isaac and said, “Do not go down to Egypt. Settle in the land where I tell you. ");
INSERT INTO engmsb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay in this land as a foreigner, and I will be with you and bless you. For I will give all these lands to you and your offspring, and I will confirm the oath that I swore to your father Abraham. ");
INSERT INTO engmsb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will make your descendants as numerous as the stars in the sky, and I will give them all these lands, and through your offspring all nations of the earth will be blessed, ");
INSERT INTO engmsb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","because Abraham listened to My voice and kept My charge, My commandments, My statutes, and My laws.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac settled in Gerar. ");
INSERT INTO engmsb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","But when the men of that place asked about his wife, he said, “She is my sister.” For he was afraid to say, “She is my wife,” since he thought to himself, “The men of this place will kill me on account of Rebekah, because she is so beautiful.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","When Isaac had been there a long time, Abimelech king of the Philistines looked down from the window and was surprised to see Isaac caressing his wife Rebekah. ");
INSERT INTO engmsb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech sent for Isaac and said, “So she is really your wife! How could you say, ‘She is my sister’?” Isaac replied, “Because I thought I might die on account of her.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“What is this you have done to us?” asked Abimelech. “One of the people could easily have slept with your wife, and you would have brought guilt upon us.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","So Abimelech warned all the people, saying, “Whoever harms this man or his wife will surely be put to death.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Now Isaac sowed seed in the land, and that very year he reaped a hundredfold. And the LORD blessed him, ");
INSERT INTO engmsb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","and he became richer and richer, until he was exceedingly wealthy. ");
INSERT INTO engmsb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He owned so many flocks and herds and servants that the Philistines envied him. ");
INSERT INTO engmsb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So the Philistines took dirt and stopped up all the wells that his father’s servants had dug in the days of his father Abraham. ");
INSERT INTO engmsb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Then Abimelech said to Isaac, “Depart from us, for you are much too powerful for us.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac left that place and encamped in the Valley of Gerar and settled there. ");
INSERT INTO engmsb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac reopened the wells that had been dug in the days of his father Abraham, which the Philistines had stopped up after Abraham died. And he gave these wells the same names his father had given them. ");
INSERT INTO engmsb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Then Isaac’s servants dug in the valley and found a well of fresh water there. ");
INSERT INTO engmsb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But the herdsmen of Gerar quarreled with Isaac’s herdsmen and said, “The water is ours!” So he named the well Esek, because they contended with him. ");
INSERT INTO engmsb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Then they dug another well and quarreled over that one also; so he named it Sitnah. ");
INSERT INTO engmsb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","He moved on from there and dug another well, and they did not quarrel over it. He named it Rehoboth and said, “At last the LORD has made room for us, and we will be fruitful in the land.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","From there Isaac went up to Beersheba, ");
INSERT INTO engmsb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","and that night the LORD appeared to him and said, “I am the God of your father Abraham. Do not be afraid, for I am with you. I will bless you and multiply your descendants for the sake of My servant Abraham.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","So Isaac built an altar there and called on the name of the LORD, and he pitched his tent there. His servants also dug a well there. ");
INSERT INTO engmsb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Later, Abimelech came to Isaac from Gerar, with Ahuzzath his adviser and Phicol the commander of his army. ");
INSERT INTO engmsb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","“Why have you come to me?” Isaac asked them. “You hated me and sent me away.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“We can plainly see that the LORD has been with you,” they replied. “We recommend that there should now be an oath between us and you. Let us make a covenant with you ");
INSERT INTO engmsb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","that you will not harm us, just as we have not harmed you but have done only good to you, sending you on your way in peace. And now you are blessed by the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac prepared a feast for them, and they ate and drank. ");
INSERT INTO engmsb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","And they got up early the next morning and swore an oath to each other. Then Isaac sent them on their way, and they left him in peace. ");
INSERT INTO engmsb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","On that same day, Isaac’s servants came and told him about the well they had dug. “We have found water!” they told him. ");
INSERT INTO engmsb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","So he called it Shibah, and to this day the name of the city is Beersheba. ");
INSERT INTO engmsb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was forty years old, he took as his wives Judith daughter of Beeri the Hittite and Basemath daughter of Elon the Hittite. ");
INSERT INTO engmsb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","And they brought grief to Isaac and Rebekah. ");
INSERT INTO engmsb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","When Isaac was old and his eyes were so weak that he could no longer see, he called his older son Esau and said to him, “My son.” “Here I am,” Esau replied. ");
INSERT INTO engmsb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“Look,” said Isaac, “I am now old, and I do not know the day of my death. ");
INSERT INTO engmsb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Take your weapons—your quiver and bow—and go out into the field to hunt some game for me. ");
INSERT INTO engmsb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Then prepare a tasty dish that I love and bring it to me to eat, so that I may bless you before I die.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Now Rebekah was listening to what Isaac told his son Esau. So when Esau went into the field to hunt game and bring it back, ");
INSERT INTO engmsb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah said to her son Jacob, “Behold, I overheard your father saying to your brother Esau, ");
INSERT INTO engmsb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bring me some game and prepare me a tasty dish to eat, so that I may bless you in the presence of the LORD before I die.’ ");
INSERT INTO engmsb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now, my son, listen to my voice and do exactly as I tell you. ");
INSERT INTO engmsb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go out to the flock and bring me two choice young goats, so that I can make them into a tasty dish for your father—the kind he loves. ");
INSERT INTO engmsb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then take it to your father to eat, so that he may bless you before he dies.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob answered his mother Rebekah, “Look, my brother Esau is a hairy man, but I am smooth-skinned. ");
INSERT INTO engmsb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","What if my father touches me? Then I would be revealed to him as a deceiver, and I would bring upon myself a curse rather than a blessing.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","His mother replied, “Your curse be on me, my son. Just obey my voice and go get them for me.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went and got two goats and brought them to his mother, who made the tasty food his father loved. ");
INSERT INTO engmsb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","And Rebekah took the finest clothes in the house that belonged to her older son Esau, and she put them on her younger son Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She also put the skins of the young goats on his hands and on the smooth part of his neck. ");
INSERT INTO engmsb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then she handed her son Jacob the tasty food and bread she had made. ");
INSERT INTO engmsb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","So Jacob went to his father and said, “My father.” “Here I am!” he answered. “Which one are you, my son?” ");
INSERT INTO engmsb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau, your firstborn. I have done as you told me. Please sit up and eat some of my game, so that you may bless me.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","But Isaac asked his son, “How did you ever find it so quickly, my son?” “Because the LORD your God brought it to me,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Then Isaac said to Jacob, “Please come closer so I can touch you, my son. Are you really my son Esau, or not?” ");
INSERT INTO engmsb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","So Jacob came close to his father Isaac, who touched him and said, “The voice is the voice of Jacob, but the hands are the hands of Esau.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac did not recognize him, because his hands were hairy like those of his brother Esau; so he blessed him. ");
INSERT INTO engmsb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Again he asked, “Are you really my son Esau?” And he replied, “I am.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“Serve me,” said Isaac, “and let me eat some of my son’s game, so that I may bless you.” Jacob brought it to him, and he ate; then he brought him wine, and he drank. ");
INSERT INTO engmsb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then his father Isaac said to him, “Please come near and kiss me, my son.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So he came near and kissed him. When Isaac smelled his clothing, he blessed him and said: “Ah, the smell of my son is like the smell of a field that the LORD has blessed. ");
INSERT INTO engmsb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","May God give to you the dew of heaven and the richness of the earth—an abundance of grain and new wine. ");
INSERT INTO engmsb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","May peoples serve you and nations bow down to you. May you be the master of your brothers, and may the sons of your mother bow down to you. May those who curse you be cursed, and those who bless you be blessed.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","As soon as Isaac had finished blessing him and Jacob had left his father’s presence, his brother Esau returned from the hunt. ");
INSERT INTO engmsb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He too made some tasty food, brought it to his father, and said to him, “My father, sit up and eat of your son’s game, so that you may bless me.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","But his father Isaac replied, “Who are you?” “I am Esau, your firstborn son,” he answered. ");
INSERT INTO engmsb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac began to tremble violently and said, “Who was it, then, who hunted the game and brought it to me? Before you came in, I ate it all and blessed him—and indeed, he will be blessed!” ");
INSERT INTO engmsb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard his father’s words, he let out a loud and bitter cry and said to his father, “Bless me too, O my father!” ");
INSERT INTO engmsb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","But Isaac replied, “Your brother came deceitfully and took your blessing.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","So Esau declared, “Is he not rightly named Jacob? For he has cheated me twice. He took my birthright, and now he has taken my blessing.” Then he asked, “Haven’t you saved a blessing for me?” ");
INSERT INTO engmsb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","But Isaac answered Esau: “Look, I have made him your master and given him all his relatives as servants; I have sustained him with grain and new wine. What is left that I can do for you, my son?” ");
INSERT INTO engmsb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau said to his father, “Do you have only one blessing, my father? Bless me too, O my father!” Then Esau wept aloud. ");
INSERT INTO engmsb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","His father Isaac answered him: “Behold, your dwelling place shall be away from the richness of the land, away from the dew of heaven above. ");
INSERT INTO engmsb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You shall live by the sword and serve your brother. But when you rebel, you will tear his yoke from your neck.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau held a grudge against Jacob because of the blessing his father had given him. And Esau said in his heart, “The days of mourning for my father are at hand; then I will kill my brother Jacob.” ");
INSERT INTO engmsb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","When the words of her older son Esau were relayed to Rebekah, she sent for her younger son Jacob and told him, “Look, your brother Esau is consoling himself by plotting to kill you. ");
INSERT INTO engmsb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So now, my son, obey my voice and flee at once to my brother Laban in Haran. ");
INSERT INTO engmsb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him for a while, until your brother’s fury subsides— ");
INSERT INTO engmsb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","until your brother’s rage against you wanes and he forgets what you have done to him. Then I will send for you and bring you back from there. Why should I lose both of you in one day?” ");
INSERT INTO engmsb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah said to Isaac, “I am weary of my life because of these Hittite women. If Jacob takes a Hittite wife from among them, what good is my life?” ");
INSERT INTO engmsb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","So Isaac called for Jacob and blessed him. “Do not take a wife from the Canaanite women,” he commanded. ");
INSERT INTO engmsb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","“Go at once to Paddan-aram, to the house of your mother’s father Bethuel, and take a wife from among the daughters of Laban, your mother’s brother. ");
INSERT INTO engmsb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","May God Almighty bless you and make you fruitful and multiply you, so that you may become a company of peoples. ");
INSERT INTO engmsb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","And may He give the blessing of Abraham to you and your descendants, so that you may possess the land where you dwell as a foreigner, the land God gave to Abraham.” ");
INSERT INTO engmsb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob to Paddan-aram, to Laban son of Bethuel the Aramean, the brother of Rebekah, who was the mother of Jacob and Esau. ");
INSERT INTO engmsb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Now Esau learned that Isaac had blessed Jacob and sent him to Paddan-aram to take a wife there, commanding him, “Do not marry a Canaanite woman,” ");
INSERT INTO engmsb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","and that Jacob had obeyed his father and mother and gone to Paddan-aram. ");
INSERT INTO engmsb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","And seeing that his father Isaac disapproved of the Canaanite women, ");
INSERT INTO engmsb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau went to Ishmael and married Mahalath, the sister of Nebaioth and daughter of Abraham’s son Ishmael, in addition to the wives he already had. ");
INSERT INTO engmsb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Meanwhile Jacob left Beersheba and set out for Haran. ");
INSERT INTO engmsb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","On reaching a certain place, he spent the night there because the sun had set. And taking one of the stones from that place, he put it under his head and lay down to sleep. ");
INSERT INTO engmsb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","And Jacob had a dream about a ladder that rested on the earth with its top reaching up to heaven, and God’s angels were going up and down the ladder. ");
INSERT INTO engmsb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","And there at the top the LORD was standing and saying, “I am the LORD, the God of your father Abraham and the God of Isaac. I will give you and your descendants the land on which you now lie. ");
INSERT INTO engmsb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your descendants will be like the dust of the earth, and you will spread out to the west and east and north and south. All the families of the earth will be blessed through you and your offspring. ");
INSERT INTO engmsb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Look, I am with you, and I will watch over you wherever you go, and I will bring you back to this land. For I will not leave you until I have done what I have promised you.” ");
INSERT INTO engmsb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","When Jacob woke up, he said, “Surely the LORD is in this place, and I was unaware of it.” ");
INSERT INTO engmsb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","And he was afraid and said, “How awesome is this place! This is none other than the house of God; this is the gate of heaven!” ");
INSERT INTO engmsb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Early the next morning, Jacob took the stone that he had placed under his head, and he set it up as a pillar. He poured oil on top of it, ");
INSERT INTO engmsb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","and he called that place Bethel, though previously the city had been named Luz. ");
INSERT INTO engmsb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Then Jacob made a vow, saying, “If God will be with me and watch over me on this journey, and if He will provide me with food to eat and clothes to wear, ");
INSERT INTO engmsb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","so that I may return safely to my father’s house, then the LORD will be my God. ");
INSERT INTO engmsb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","And this stone I have set up as a pillar will be God’s house, and of all that You give me I will surely give You a tenth.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob resumed his journey and came to the land of the people of the east. ");
INSERT INTO engmsb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","He looked and saw a well in the field, and near it lay three flocks of sheep, because the sheep were watered from this well. And a large stone covered the mouth of the well. ");
INSERT INTO engmsb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","When all the flocks had been gathered there, the shepherds would roll away the stone from the mouth of the well and water the sheep. Then they would return the stone to its place over the mouth of the well. ");
INSERT INTO engmsb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","“My brothers,” Jacob asked the shepherds, “where are you from?” “We are from Haran,” they answered. ");
INSERT INTO engmsb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Do you know Laban the grandson of Nahor?” Jacob asked. “We know him,” they replied. ");
INSERT INTO engmsb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“Is he well?” Jacob inquired. “Yes,” they answered, “and here comes his daughter Rachel with his sheep.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“Look,” said Jacob, “it is still broad daylight; it is not yet time to gather the livestock. Water the sheep and take them back to pasture.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","But they replied, “We cannot, until all the flocks have been gathered and the stone has been rolled away from the mouth of the well. Then we will water the sheep.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was still speaking with them, Rachel arrived with her father’s sheep, for she was a shepherdess. ");
INSERT INTO engmsb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","As soon as Jacob saw Rachel, the daughter of his mother’s brother Laban, with Laban’s sheep, he went up and rolled the stone away from the mouth of the well and watered his uncle’s sheep. ");
INSERT INTO engmsb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then Jacob kissed Rachel and wept aloud. ");
INSERT INTO engmsb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","He told Rachel that he was Rebekah’s son, a relative of her father, and she ran and told her father. ");
INSERT INTO engmsb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","When Laban heard the news about his sister’s son Jacob, he ran out to meet him. He embraced him and kissed him and brought him to his home, where Jacob told him all that had happened. ");
INSERT INTO engmsb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Then Laban declared, “You are indeed my own flesh and blood.” After Jacob had stayed with him a month, ");
INSERT INTO engmsb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban said to him, “Just because you are my relative, should you work for nothing? Tell me what your wages should be.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Now Laban had two daughters; the older was named Leah, and the younger was named Rachel. ");
INSERT INTO engmsb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah had weak eyes, but Rachel was shapely and beautiful. ");
INSERT INTO engmsb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Since Jacob loved Rachel, he answered, “I will serve you seven years for your younger daughter Rachel.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban replied, “Better that I give her to you than to another. Stay here with me.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob served seven years for Rachel, yet it seemed but a few days because of his love for her. ");
INSERT INTO engmsb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Finally Jacob said to Laban, “Grant me my wife, for my time is complete, and I want to sleep with her.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban invited all the men of that place and prepared a feast. ");
INSERT INTO engmsb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","But when evening came, Laban took his daughter Leah and gave her to Jacob, and he slept with her. ");
INSERT INTO engmsb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","And Laban gave his servant girl Zilpah to his daughter Leah as her maidservant. ");
INSERT INTO engmsb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","When morning came, there was Leah! “What have you done to me?” Jacob said to Laban. “Wasn’t it for Rachel that I served you? Why have you deceived me?” ");
INSERT INTO engmsb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban replied, “It is not our custom here to give the younger daughter in marriage before the older. ");
INSERT INTO engmsb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Finish this week’s celebration, and we will give you the younger one in return for another seven years of work.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","And Jacob did just that. He finished the week’s celebration, and Laban gave him his daughter Rachel as his wife. ");
INSERT INTO engmsb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban also gave his servant girl Bilhah to his daughter Rachel as her maidservant. ");
INSERT INTO engmsb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob slept with Rachel as well, and indeed, he loved Rachel more than Leah. So he worked for Laban another seven years. ");
INSERT INTO engmsb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","When the LORD saw that Leah was unloved, He opened her womb; but Rachel was barren. ");
INSERT INTO engmsb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","And Leah conceived and gave birth to a son, and she named him Reuben, for she said, “The LORD has seen my affliction. Surely my husband will love me now.” ");
INSERT INTO engmsb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Again she conceived and gave birth to a son, and she said, “Because the LORD has heard that I am unloved, He has given me this son as well.” So she named him Simeon. ");
INSERT INTO engmsb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Once again Leah conceived and gave birth to a son, and she said, “Now at last my husband will become attached to me, because I have borne him three sons.” So he was named Levi. ");
INSERT INTO engmsb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","And once more she conceived and gave birth to a son and said, “This time I will praise the LORD.” So she named him Judah. Then Leah stopped having children. ");
INSERT INTO engmsb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","When Rachel saw that she was not bearing any children for Jacob, she envied her sister. “Give me children, or I will die!” she said to Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob became angry with Rachel and said, “Am I in the place of God, who has withheld children from you?” ");
INSERT INTO engmsb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Then she said, “Here is my maidservant Bilhah. Sleep with her, that she may bear children for me, so that through her I too can build a family.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So Rachel gave Jacob her servant Bilhah as a wife, and he slept with her, ");
INSERT INTO engmsb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","and Bilhah conceived and bore him a son. ");
INSERT INTO engmsb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Then Rachel said, “God has vindicated me; He has heard my plea and given me a son.” So she named him Dan. ");
INSERT INTO engmsb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","And Rachel’s servant Bilhah conceived again and bore Jacob a second son. ");
INSERT INTO engmsb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Then Rachel said, “In my great struggles, I have wrestled with my sister and won.” So she named him Naphtali. ");
INSERT INTO engmsb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","When Leah saw that she had stopped having children, she gave her servant Zilpah to Jacob as a wife. ");
INSERT INTO engmsb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","And Leah’s servant Zilpah bore Jacob a son. ");
INSERT INTO engmsb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Then Leah said, “How fortunate!” So she named him Gad. ");
INSERT INTO engmsb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","When Leah’s servant Zilpah bore Jacob a second son, ");
INSERT INTO engmsb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “How happy I am! For the women call me happy.” So she named him Asher. ");
INSERT INTO engmsb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Now during the wheat harvest, Reuben went out and found some mandrakes in the field. When he brought them to his mother, Rachel begged Leah, “Please give me some of your son’s mandrakes.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","But Leah replied, “Is it not enough that you have taken away my husband? Now you want to take my son’s mandrakes as well?” “Very well,” said Rachel, “he may sleep with you tonight in exchange for your son’s mandrakes.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","When Jacob came in from the field that evening, Leah went out to meet him and said, “You must come with me, for I have hired you with my son’s mandrakes.” So he slept with her that night. ");
INSERT INTO engmsb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","And God listened to Leah, and she conceived and bore a fifth son to Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Then Leah said, “God has rewarded me for giving my maidservant to my husband.” So she named him Issachar. ");
INSERT INTO engmsb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Again Leah conceived and bore a sixth son to Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","“God has given me a good gift,” she said. “This time my husband will honor me, because I have borne him six sons.” And she named him Zebulun. ");
INSERT INTO engmsb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","After that, Leah gave birth to a daughter and named her Dinah. ");
INSERT INTO engmsb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God remembered Rachel. He listened to her and opened her womb, ");
INSERT INTO engmsb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","and she conceived and gave birth to a son. “God has taken away my shame,” she said. ");
INSERT INTO engmsb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She named him Joseph, and said, “May the LORD add to me another son.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Now after Rachel had given birth to Joseph, Jacob said to Laban, “Send me on my way so I can return to my homeland. ");
INSERT INTO engmsb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and children for whom I have served you, that I may go on my way. You know how hard I have worked for you.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","But Laban replied, “If I have found favor in your eyes, please stay. I have learned by divination that the LORD has blessed me because of you.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","And he added, “Name your wages, and I will pay them.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Then Jacob answered, “You know how I have served you and how your livestock have thrived under my care. ");
INSERT INTO engmsb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Indeed, you had very little before my arrival, but now your wealth has increased many times over. The LORD has blessed you wherever I set foot. But now, when may I also provide for my own household?” ");
INSERT INTO engmsb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“What can I give you?” Laban asked. “You do not need to give me anything,” Jacob replied. “If you do this one thing for me, I will keep on shepherding and keeping your flocks. ");
INSERT INTO engmsb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Let me go through all your flocks today and remove from them every speckled or spotted sheep, every dark-colored lamb, and every spotted or speckled goat. These will be my wages. ");
INSERT INTO engmsb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","So my honesty will testify for me when you come to check on my wages in the future. If I have any goats that are not speckled or spotted, or any lambs that are not dark-colored, they will be considered stolen.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Agreed,” said Laban. “Let it be as you have said.” ");
INSERT INTO engmsb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","That very day Laban removed all the streaked or spotted male goats and every speckled or spotted female goat—every one that had any white on it—and every dark-colored lamb, and he placed them under the care of his sons. ");
INSERT INTO engmsb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Then he put a three-day journey between himself and Jacob, while Jacob was shepherding the rest of Laban’s flocks. ");
INSERT INTO engmsb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob, however, took fresh branches of poplar, almond, and plane trees, and peeled the bark, exposing the white inner wood of the branches. ");
INSERT INTO engmsb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Then he set the peeled branches in the watering troughs in front of the flocks coming in to drink. So when the flocks were in heat and came to drink, ");
INSERT INTO engmsb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","they mated in front of the branches. And they bore young that were streaked or speckled or spotted. ");
INSERT INTO engmsb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob set apart the young, but made the rest face the streaked dark-colored sheep in Laban’s flocks. Then he set his own stock apart and did not put them with Laban’s animals. ");
INSERT INTO engmsb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Whenever the stronger females of the flock were in heat, Jacob would place the branches in the troughs, in full view of the animals, so that they would breed in front of the branches. ");
INSERT INTO engmsb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But if the animals were weak, he did not set out the branches. So the weaker animals went to Laban and the stronger ones to Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Thus Jacob became exceedingly prosperous. He owned large flocks, maidservants and menservants, and camels and donkeys. ");
INSERT INTO engmsb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Now Jacob heard that Laban’s sons were saying, “Jacob has taken away all that belonged to our father and built all this wealth at our father’s expense.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","And Jacob saw from the countenance of Laban that his attitude toward him had changed. ");
INSERT INTO engmsb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Then the LORD said to Jacob, “Go back to the land of your fathers and to your kindred, and I will be with you.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","So Jacob sent word and called Rachel and Leah to the field where his flocks were, ");
INSERT INTO engmsb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","and he told them, “I can see from your father’s countenance that his attitude toward me has changed; but the God of my father has been with me. ");
INSERT INTO engmsb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You know that I have served your father with all my strength. ");
INSERT INTO engmsb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","And although he has cheated me and changed my wages ten times, God has not allowed him to harm me. ");
INSERT INTO engmsb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, ‘The speckled will be your wages,’ then the whole flock bore speckled offspring. If he said, ‘The streaked will be your wages,’ then the whole flock bore streaked offspring. ");
INSERT INTO engmsb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Thus God has taken away your father’s livestock and given them to me. ");
INSERT INTO engmsb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","When the flocks were breeding, I saw in a dream that the streaked, spotted, and speckled males were mating with the females. ");
INSERT INTO engmsb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","In that dream the angel of God said to me, ‘Jacob!’ And I replied, ‘Here I am.’ ");
INSERT INTO engmsb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Look up,’ he said, ‘and see that all the males that are mating with the flock are streaked, spotted, or speckled; for I have seen all that Laban has done to you. ");
INSERT INTO engmsb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel, where you anointed the pillar and made a solemn vow to Me. Now get up, leave this land at once, and return to your native land.’” ");
INSERT INTO engmsb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","And Rachel and Leah replied, “Do we have any portion or inheritance left in our father’s house? ");
INSERT INTO engmsb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Are we not regarded by him as outsiders? Not only has he sold us, but he has certainly squandered what was paid for us. ");
INSERT INTO engmsb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Surely all the wealth that God has taken away from our father belongs to us and to our children. So do whatever God has told you.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Then Jacob got up and put his children and his wives on camels, ");
INSERT INTO engmsb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","and he drove all his livestock before him, along with all the possessions he had acquired in Paddan-aram, to go to his father Isaac in the land in Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Now while Laban was out shearing his sheep, Rachel stole her father’s household idols. ");
INSERT INTO engmsb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Moreover, Jacob deceived Laban the Aramean by not telling him that he was running away. ");
INSERT INTO engmsb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So he fled with all his possessions, crossed the Euphrates, and headed for the hill country of Gilead. ");
INSERT INTO engmsb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","On the third day Laban was informed that Jacob had fled. ");
INSERT INTO engmsb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","So he took his relatives with him, pursued Jacob for seven days, and overtook him in the hill country of Gilead. ");
INSERT INTO engmsb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","But that night God came to Laban the Aramean in a dream and warned him, “Be careful not to say anything to Jacob, either good or bad.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Now Jacob had pitched his tent in the hill country of Gilead when Laban overtook him, and Laban and his relatives camped there as well. ");
INSERT INTO engmsb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Then Laban said to Jacob, “What have you done? You have deceived me and carried off my daughters like captives of war! ");
INSERT INTO engmsb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you run away secretly and deceive me, without even telling me? I would have sent you away with joy and singing, with tambourines and harps. ");
INSERT INTO engmsb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","But you did not even let me kiss my grandchildren and my daughters goodbye. Now you have done a foolish thing. ");
INSERT INTO engmsb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I have power to do you great harm, but last night the God of your father said to me, ‘Be careful not to say anything to Jacob, either good or bad.’ ");
INSERT INTO engmsb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Now you have gone off because you long for your father’s house. But why have you stolen my gods?” ");
INSERT INTO engmsb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","“I was afraid,” Jacob answered, “for I thought you would take your daughters from me by force. ");
INSERT INTO engmsb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","If you find your gods with anyone here, he shall not live! In the presence of our relatives, see for yourself if anything is yours, and take it back.” For Jacob did not know that Rachel had stolen the idols. ");
INSERT INTO engmsb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","So Laban went into Jacob’s tent, then Leah’s tent, and then the tents of the two maidservants, but he found nothing. Then he left Leah’s tent and entered Rachel’s tent. ");
INSERT INTO engmsb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Now Rachel had taken Laban’s household idols, put them in the saddlebag of her camel, and was sitting on them. And Laban searched everything in the tent but found nothing. ");
INSERT INTO engmsb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel said to her father, “Sir, do not be angry that I cannot stand up before you; for I am having my period.” So Laban searched but could not find the household idols. ");
INSERT INTO engmsb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Then Jacob became incensed and challenged Laban. “What is my crime?” he said. “For what sin of mine have you so hotly pursued me? ");
INSERT INTO engmsb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","You have searched all my goods! Have you found anything that belongs to you? Put it here before my brothers and yours, that they may judge between the two of us. ");
INSERT INTO engmsb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I have been with you for twenty years now. Your sheep and goats have not miscarried, nor have I eaten the rams of your flock. ");
INSERT INTO engmsb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","I did not bring you anything torn by wild beasts; I bore the loss myself. And you demanded payment from me for what was stolen by day or night. ");
INSERT INTO engmsb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","As it was, the heat consumed me by day and the frost by night, and sleep fled from my eyes. ");
INSERT INTO engmsb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Thus for twenty years I have served in your household—fourteen years for your two daughters and six years for your flocks—and you have changed my wages ten times! ");
INSERT INTO engmsb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","If the God of my father, the God of Abraham and the Fear of Isaac, had not been with me, surely by now you would have sent me away empty-handed. But God has seen my affliction and the toil of my hands, and last night He rendered judgment.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","But Laban answered Jacob, “These daughters are my daughters, these sons are my sons, and these flocks are my flocks! Everything you see is mine! Yet what can I do today about these daughters of mine or the children they have borne? ");
INSERT INTO engmsb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Come now, let us make a covenant, you and I, and let it serve as a witness between you and me.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob picked out a stone and set it up as a pillar, ");
INSERT INTO engmsb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","and he said to his relatives, “Gather some stones.” So they took stones and made a mound, and there by the mound they ate. ");
INSERT INTO engmsb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban called it Jegar-sahadutha, and Jacob called it Galeed. ");
INSERT INTO engmsb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Then Laban declared, “This mound is a witness between you and me this day.” Therefore the place was called Galeed. ");
INSERT INTO engmsb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","It was also called Mizpah, because Laban said, “May the LORD keep watch between you and me when we are absent from each other. ");
INSERT INTO engmsb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you mistreat my daughters or take other wives, although no one is with us, remember that God is a witness between you and me.” ");
INSERT INTO engmsb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban also said to Jacob, “Here is the mound, and here is the pillar I have set up between you and me. ");
INSERT INTO engmsb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","This mound is a witness, and this pillar is a witness, that I will not go past this mound to harm you, and you will not go past this mound and pillar to harm me. ");
INSERT INTO engmsb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham and the God of Nahor, the God of their father, judge between us.” So Jacob swore by the Fear of his father Isaac. ");
INSERT INTO engmsb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then Jacob offered a sacrifice on the mountain and invited his relatives to eat a meal. And after they had eaten, they spent the night on the mountain. ");
INSERT INTO engmsb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early the next morning, Laban got up and kissed his grandchildren and daughters and blessed them. Then he left to return home. ");
INSERT INTO engmsb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob also went on his way, and the angels of God met him. ");
INSERT INTO engmsb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When Jacob saw them, he said, “This is the camp of God.” So he named that place Mahanaim. ");
INSERT INTO engmsb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob sent messengers ahead of him to his brother Esau in the land of Seir, the country of Edom. ");
INSERT INTO engmsb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He instructed them, “You are to say to my master Esau, ‘Your servant Jacob says: I have been staying with Laban and have remained there until now. ");
INSERT INTO engmsb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have oxen, donkeys, flocks, menservants, and maidservants. I have sent this message to inform my master, so that I may find favor in your sight.’” ");
INSERT INTO engmsb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","When the messengers returned to Jacob, they said, “We went to your brother Esau, and now he is coming to meet you—he and four hundred men with him.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","In great fear and distress, Jacob divided his people into two camps, as well as the flocks and herds and camels. ");
INSERT INTO engmsb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","He thought, “If Esau comes and attacks one camp, then the other camp can escape.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob declared, “O God of my father Abraham, God of my father Isaac, the LORD who told me, ‘Go back to your country and to your kindred, and I will make you prosper,’ ");
INSERT INTO engmsb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I am unworthy of all the kindness and faithfulness You have shown Your servant. Indeed, with only my staff I came across the Jordan, but now I have become two camps. ");
INSERT INTO engmsb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Please deliver me from the hand of my brother Esau, for I am afraid that he may come and attack me and the mothers and children with me. ");
INSERT INTO engmsb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","But You have said, ‘I will surely make you prosper, and I will make your offspring like the sand of the sea, too numerous to count.’” ");
INSERT INTO engmsb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob spent the night there, and from what he had brought with him, he selected a gift for his brother Esau: ");
INSERT INTO engmsb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 female goats, 20 male goats, 200 ewes, 20 rams, ");
INSERT INTO engmsb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 milk camels with their young, 40 cows, 10 bulls, 20 female donkeys, and 10 male donkeys. ");
INSERT INTO engmsb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He entrusted them to his servants in separate herds and told them, “Go on ahead of me, and keep some distance between the herds.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He instructed the one in the lead, “When my brother Esau meets you and asks, ‘To whom do you belong, where are you going, and whose animals are these before you?’ ");
INSERT INTO engmsb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","then you are to say, ‘They belong to your servant Jacob. They are a gift, sent to my lord Esau. And behold, Jacob is behind us.’” ");
INSERT INTO engmsb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He also instructed the second, the third, and all those following behind the herds: “When you meet Esau, you are to say the same thing to him. ");
INSERT INTO engmsb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You are also to say, ‘Look, your servant Jacob is right behind us.’” For he thought, “I will appease Esau with the gift that is going before me. After that I can face him, and perhaps he will accept me.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So Jacob’s gifts went on before him, while he spent the night in the camp. ");
INSERT INTO engmsb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","During the night Jacob got up and took his two wives, his two maidservants, and his eleven sons, and crossed the ford of the Jabbok. ");
INSERT INTO engmsb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","He took them and sent them across the stream, along with all his possessions. ");
INSERT INTO engmsb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","So Jacob was left all alone, and there a man wrestled with him until daybreak. ");
INSERT INTO engmsb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man saw that he could not overpower Jacob, he struck the socket of Jacob’s hip and dislocated it as they wrestled. ");
INSERT INTO engmsb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then the man said, “Let me go, for it is daybreak.” But Jacob replied, “I will not let you go unless you bless me.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“What is your name?” the man asked. “Jacob,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Then the man said, “Your name will no longer be Jacob, but Israel, because you have struggled with God and with men, and you have prevailed.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","And Jacob requested, “Please tell me your name.” But he replied, “Why do you ask my name?” Then he blessed Jacob there. ");
INSERT INTO engmsb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","So Jacob named the place Peniel, saying, “Indeed, I have seen God face to face, and yet my life was spared.” ");
INSERT INTO engmsb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun rose above him as he passed by Penuel, and he was limping because of his hip. ");
INSERT INTO engmsb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Therefore to this day the Israelites do not eat the tendon attached to the socket of the hip, because the socket of Jacob’s hip was struck near that tendon. ");
INSERT INTO engmsb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Now Jacob looked up and saw Esau coming toward him with four hundred men. So he divided the children among Leah, Rachel, and the two maidservants. ");
INSERT INTO engmsb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He put the maidservants and their children in front, Leah and her children next, and Rachel and Joseph at the rear. ");
INSERT INTO engmsb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","But Jacob himself went on ahead and bowed to the ground seven times as he approached his brother. ");
INSERT INTO engmsb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau, however, ran to him and embraced him, threw his arms around his neck, and kissed him. And they both wept. ");
INSERT INTO engmsb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","When Esau looked up and saw the women and children, he asked, “Who are these with you?” Jacob answered, “These are the children God has graciously given your servant.” ");
INSERT INTO engmsb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the maidservants and their children approached and bowed down. ");
INSERT INTO engmsb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leah and her children also approached and bowed down, and then Joseph and Rachel approached and bowed down. ");
INSERT INTO engmsb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“What do you mean by sending this whole company to meet me?” asked Esau. “To find favor in your sight, my lord,” Jacob answered. ");
INSERT INTO engmsb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","“I already have plenty, my brother,” Esau replied. “Keep what belongs to you.” ");
INSERT INTO engmsb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","But Jacob insisted, “No, please! If I have found favor in your sight, then receive this gift from my hand. For indeed, I have seen your face, and it is like seeing the face of God, since you have received me favorably. ");
INSERT INTO engmsb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please accept my gift that was brought to you, because God has been gracious to me and I have all I need.” So Jacob pressed him until he accepted. ");
INSERT INTO engmsb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Let us be on our way, and I will go ahead of you.” ");
INSERT INTO engmsb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","But Jacob replied, “My lord knows that the children are frail, and I must care for sheep and cattle that are nursing their young. If they are driven hard for even a day, all the animals will die. ");
INSERT INTO engmsb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Please let my lord go ahead of his servant. I will continue on slowly, at a comfortable pace for the livestock and children, until I come to my lord at Seir.” ");
INSERT INTO engmsb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“Let me leave some of my people with you,” Esau said. But Jacob replied, “Why do that? Let me find favor in the sight of my lord.” ");
INSERT INTO engmsb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So that day Esau started on his way back to Seir, ");
INSERT INTO engmsb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","but Jacob went on to Succoth, where he built a house for himself and shelters for his livestock; that is why the place was called Succoth. ");
INSERT INTO engmsb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","After Jacob had come from Paddan-aram, he arrived safely at the city of Shechem in the land of Canaan, and he camped just outside the city. ");
INSERT INTO engmsb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","And the plot of ground where he pitched his tent, he purchased from the sons of Hamor, Shechem’s father, for a hundred pieces of silver. ");
INSERT INTO engmsb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","There he set up an altar and called it El-Elohe-Israel. ");
INSERT INTO engmsb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Now Dinah, the daughter Leah had borne to Jacob, went out to visit the daughters of the land. ");
INSERT INTO engmsb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","When Shechem son of Hamor the Hivite, the prince of the region, saw her, he took her and lay with her by force. ");
INSERT INTO engmsb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","And his soul was drawn to Dinah, the daughter of Jacob. He loved the young girl and spoke to her tenderly. ");
INSERT INTO engmsb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","So Shechem told his father Hamor, “Get me this girl as a wife.” ");
INSERT INTO engmsb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob heard that Shechem had defiled his daughter Dinah, but since his sons were with his livestock in the field, he remained silent about it until they returned. ");
INSERT INTO engmsb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Meanwhile, Shechem’s father Hamor came to speak with Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","When Jacob’s sons heard what had happened, they returned from the field. They were filled with grief and fury, because Shechem had committed an outrage in Israel by lying with Jacob’s daughter—a thing that should not be done. ");
INSERT INTO engmsb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","But Hamor said to them, “My son Shechem longs for your daughter. Please give her to him as his wife. ");
INSERT INTO engmsb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Intermarry with us; give us your daughters and take our daughters for yourselves. ");
INSERT INTO engmsb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You may settle among us, and the land will be open to you. Live here, move about freely, and acquire your own property.” ");
INSERT INTO engmsb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Then Shechem said to Dinah’s father and brothers, “Grant me this favor, and I will give you whatever you ask. ");
INSERT INTO engmsb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Demand a high dowry and an expensive gift, and I will give you whatever you ask. Only give me the girl as my wife!” ");
INSERT INTO engmsb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","But because Shechem had defiled their sister Dinah, Jacob’s sons answered him and his father Hamor deceitfully. ");
INSERT INTO engmsb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“We cannot do such a thing,” they said. “To give our sister to an uncircumcised man would be a disgrace to us. ");
INSERT INTO engmsb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","We will consent to this on one condition, that you become circumcised like us—every one of your males. ");
INSERT INTO engmsb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then we will give you our daughters and take your daughters for ourselves. We will dwell among you and become one people. ");
INSERT INTO engmsb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you will not agree to be circumcised, then we will take our sister and go.” ");
INSERT INTO engmsb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Their offer seemed good to Hamor and his son Shechem. ");
INSERT INTO engmsb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","The young man, who was the most respected of all his father’s household, did not hesitate to fulfill this request, because he was delighted with Jacob’s daughter. ");
INSERT INTO engmsb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","So Hamor and his son Shechem went to the gate of their city and addressed the men of their city: ");
INSERT INTO engmsb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are at peace with us. Let them live and trade in our land; indeed, it is large enough for them. Let us take their daughters in marriage and give our daughters to them. ");
INSERT INTO engmsb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But only on this condition will the men agree to dwell with us and be one people: if all our men are circumcised as they are. ");
INSERT INTO engmsb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Will not their livestock, their possessions, and all their animals become ours? Only let us consent to them, and they will dwell among us.” ");
INSERT INTO engmsb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","All the men who went out of the city gate listened to Hamor and his son Shechem, and every male of the city was circumcised. ");
INSERT INTO engmsb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Three days later, while they were still in pain, two of Jacob’s sons (Dinah’s brothers Simeon and Levi) took their swords, went into the unsuspecting city, and slaughtered every male. ");
INSERT INTO engmsb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They killed Hamor and his son Shechem with their swords, took Dinah out of Shechem’s house, and went away. ");
INSERT INTO engmsb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob’s other sons came upon the slaughter and looted the city, because their sister had been defiled. ");
INSERT INTO engmsb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their flocks and herds and donkeys, and everything else in the city or in the field. ");
INSERT INTO engmsb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","They carried off all their possessions and women and children, and they plundered everything in their houses. ");
INSERT INTO engmsb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Then Jacob said to Simeon and Levi, “You have brought trouble upon me by making me a stench to the Canaanites and Perizzites, the people of this land. We are few in number; if they unite against me and attack me, I and my household will be destroyed.” ");
INSERT INTO engmsb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But they replied, “Should he have treated our sister like a prostitute?” ");
INSERT INTO engmsb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Then God said to Jacob, “Arise, go up to Bethel, and settle there. Build an altar there to the God who appeared to you when you fled from your brother Esau.” ");
INSERT INTO engmsb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Jacob told his household and all who were with him, “Get rid of the foreign gods that are among you. Purify yourselves and change your garments. ");
INSERT INTO engmsb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Then let us arise and go to Bethel. I will build an altar there to God, who answered me in my day of distress. He has been with me wherever I have gone.” ");
INSERT INTO engmsb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So they gave Jacob all their foreign gods and all their earrings, and Jacob buried them under the oak near Shechem. ");
INSERT INTO engmsb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","As they set out, a terror from God fell over the surrounding cities, so that they did not pursue Jacob’s sons. ");
INSERT INTO engmsb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","So Jacob and everyone with him arrived in Luz (that is, Bethel) in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","There Jacob built an altar, and he called that place El-bethel, because it was there that God had revealed Himself to Jacob as he fled from his brother. ");
INSERT INTO engmsb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Now Deborah, Rebekah’s nurse, died and was buried under the oak below Bethel. So Jacob named it Allon-bacuth. ");
INSERT INTO engmsb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","After Jacob had returned from Paddan-aram, God appeared to him again and blessed him. ");
INSERT INTO engmsb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","And God said to him, “Though your name is Jacob, you will no longer be called Jacob. Instead, your name will be Israel.” So God named him Israel. ");
INSERT INTO engmsb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","And God told him, “I am God Almighty. Be fruitful and multiply. A nation—even a company of nations—shall come from you, and kings shall descend from you. ");
INSERT INTO engmsb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","The land that I gave to Abraham and Isaac I will give to you, and I will give this land to your descendants after you.” ");
INSERT INTO engmsb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Then God went up from the place where He had spoken with him. ");
INSERT INTO engmsb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","So Jacob set up a pillar in the place where God had spoken with him—a stone marker—and he poured out a drink offering on it and anointed it with oil. ");
INSERT INTO engmsb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob called the place where God had spoken with him Bethel. ");
INSERT INTO engmsb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Later, they set out from Bethel, and while they were still some distance from Ephrath, Rachel began to give birth, and her labor was difficult. ");
INSERT INTO engmsb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","During her severe labor, the midwife said to her, “Do not be afraid, for you are having another son.” ");
INSERT INTO engmsb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","And with her last breath—for she was dying—she named him Ben-oni. But his father called him Benjamin. ");
INSERT INTO engmsb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","So Rachel died and was buried on the way to Ephrath (that is, Bethlehem). ");
INSERT INTO engmsb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a pillar on her grave; it marks Rachel’s tomb to this day. ");
INSERT INTO engmsb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel again set out and pitched his tent beyond the Tower of Eder. ");
INSERT INTO engmsb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","While Israel was living in that region, Reuben went in and slept with his father’s concubine Bilhah, and Israel heard about it. Jacob had twelve sons: ");
INSERT INTO engmsb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah were Reuben the firstborn of Jacob, Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engmsb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel were Joseph and Benjamin. ");
INSERT INTO engmsb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Rachel’s maidservant Bilhah were Dan and Naphtali. ");
INSERT INTO engmsb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","And the sons of Leah’s maidservant Zilpah were Gad and Asher. These are the sons of Jacob, who were born to him in Paddan-aram. ");
INSERT INTO engmsb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob returned to his father Isaac at Mamre, near Kiriath-arba (that is, Hebron), where Abraham and Isaac had stayed. ");
INSERT INTO engmsb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","And Isaac lived 180 years. ");
INSERT INTO engmsb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Then he breathed his last and died and was gathered to his people, old and full of years. And his sons Esau and Jacob buried him. ");
INSERT INTO engmsb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","This is the account of Esau (that is, Edom). ");
INSERT INTO engmsb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau took his wives from the daughters of Canaan: Adah daughter of Elon the Hittite, Oholibamah daughter of Anah and granddaughter of Zibeon the Hivite, ");
INSERT INTO engmsb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","and Basemath daughter of Ishmael and sister of Nebaioth. ");
INSERT INTO engmsb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","And Adah bore Eliphaz to Esau, Basemath gave birth to Reuel, ");
INSERT INTO engmsb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","and Oholibamah gave birth to Jeush, Jalam, and Korah. These were the sons of Esau, who were born to him in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Later, Esau took his wives and sons and daughters and all the people of his household, along with his livestock, all his other animals, and all the property he had acquired in Canaan, and he moved to a land far away from his brother Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","For their possessions were too great for them to dwell together; the land where they stayed could not support them because of their livestock. ");
INSERT INTO engmsb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","So Esau (that is, Edom) settled in the area of Mount Seir. ");
INSERT INTO engmsb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","This is the account of Esau, the father of the Edomites, in the area of Mount Seir. ");
INSERT INTO engmsb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These are the names of Esau’s sons: Eliphaz son of Esau’s wife Adah, and Reuel son of Esau’s wife Basemath. ");
INSERT INTO engmsb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engmsb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Additionally, Timna, a concubine of Esau’s son Eliphaz, gave birth to Amalek. These are the grandsons of Esau’s wife Adah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","These are the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah. They are the grandsons of Esau’s wife Basemath. ");
INSERT INTO engmsb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","These are the sons of Esau’s wife Oholibamah (daughter of Anah and granddaughter of Zibeon) whom she bore to Esau: Jeush, Jalam, and Korah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These are the chiefs among the sons of Esau. The sons of Eliphaz the firstborn of Esau: Chiefs Teman, Omar, Zepho, Kenaz, ");
INSERT INTO engmsb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, and Amalek. They are the chiefs of Eliphaz in the land of Edom, and they are the grandsons of Adah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These are the sons of Esau’s son Reuel: Chiefs Nahath, Zerah, Shammah, and Mizzah. They are the chiefs descended from Reuel in the land of Edom, and they are the grandsons of Esau’s wife Basemath. ");
INSERT INTO engmsb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These are the sons of Esau’s wife Oholibamah: Chiefs Jeush, Jalam, and Korah. They are the chiefs descended from Esau’s wife Oholibamah, the daughter of Anah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","All these are the sons of Esau (that is, Edom), and they were their chiefs. ");
INSERT INTO engmsb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These are the sons of Seir the Horite, who were living in the land: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engmsb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. They are the chiefs of the Horites, the descendants of Seir in the land of Edom. ");
INSERT INTO engmsb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The sons of Lotan were Hori and Hemam. Timna was Lotan’s sister. ");
INSERT INTO engmsb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","These are the sons of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engmsb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","These are the sons of Zibeon: Aiah and Anah. (This is the Anah who found the hot springs in the wilderness as he was pasturing the donkeys of his father Zibeon.) ");
INSERT INTO engmsb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","These are the children of Anah: Dishon and Oholibamah daughter of Anah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These are the sons of Dishon: Hemdan, Eshban, Ithran, and Cheran. ");
INSERT INTO engmsb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These are the sons of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engmsb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These are the sons of Dishan: Uz and Aran. ");
INSERT INTO engmsb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the chiefs of the Horites: Chiefs Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engmsb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, and Dishan. They are the chiefs of the Horites, according to their divisions in the land of Seir. ");
INSERT INTO engmsb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These are the kings who reigned in the land of Edom before any king reigned over the Israelites: ");
INSERT INTO engmsb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela son of Beor reigned in Edom; the name of his city was Dinhabah. ");
INSERT INTO engmsb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, Jobab son of Zerah from Bozrah reigned in his place. ");
INSERT INTO engmsb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham from the land of the Temanites reigned in his place. ");
INSERT INTO engmsb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Hadad son of Bedad, who defeated Midian in the country of Moab, reigned in his place. And the name of his city was Avith. ");
INSERT INTO engmsb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, Samlah from Masrekah reigned in his place. ");
INSERT INTO engmsb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, Shaul from Rehoboth on the Euphrates reigned in his place. ");
INSERT INTO engmsb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, Baal-hanan son of Achbor reigned in his place. ");
INSERT INTO engmsb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Baal-hanan son of Achbor died, Hadad reigned in his place. His city was named Pau, and his wife’s name was Mehetabel daughter of Matred, the daughter of Me-zahab. ");
INSERT INTO engmsb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These are the names of Esau’s chiefs, according to their families and regions, by their names: Chiefs Timna, Alvah, Jetheth, ");
INSERT INTO engmsb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO engmsb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO engmsb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, and Iram. These were the chiefs of Edom, according to their settlements in the land they possessed. Esau was the father of the Edomites. ");
INSERT INTO engmsb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Now Jacob lived in the land where his father had resided, the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the account of Jacob. When Joseph was seventeen years old, he was tending the flock with his brothers, the sons of his father’s wives Bilhah and Zilpah, and he brought their father a bad report about them. ");
INSERT INTO engmsb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Now Israel loved Joseph more than his other sons, because Joseph had been born to him in his old age; so he made him a robe of many colors. ");
INSERT INTO engmsb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","When Joseph’s brothers saw that their father loved him more than any of them, they hated him and could not speak a kind word to him. ");
INSERT INTO engmsb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Then Joseph had a dream, and when he told it to his brothers, they hated him even more. ");
INSERT INTO engmsb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","He said to them, “Listen to this dream I had: ");
INSERT INTO engmsb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","We were binding sheaves of grain in the field, and suddenly my sheaf rose and stood upright, while your sheaves gathered around and bowed down to mine.” ");
INSERT INTO engmsb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","“Do you intend to reign over us?” his brothers asked. “Will you actually rule us?” So they hated him even more because of his dream and his statements. ");
INSERT INTO engmsb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Then Joseph had another dream and told it to his brothers. “Look,” he said, “I had another dream, and this time the sun and moon and eleven stars were bowing down to me.” ");
INSERT INTO engmsb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He told his father and brothers, but his father rebuked him and said, “What is this dream that you have had? Will your mother and brothers and I actually come and bow down to the ground before you?” ");
INSERT INTO engmsb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","And his brothers were jealous of him, but his father kept in mind what he had said. ");
INSERT INTO engmsb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Some time later, Joseph’s brothers had gone to pasture their father’s flocks near Shechem. ");
INSERT INTO engmsb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel said to him, “Are not your brothers pasturing the flocks at Shechem? Get ready; I am sending you to them.” “I am ready,” Joseph replied. ");
INSERT INTO engmsb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Then Israel told him, “Go now and see how your brothers and the flocks are faring, and bring word back to me.” So he sent him off from the Valley of Hebron. And when Joseph arrived in Shechem, ");
INSERT INTO engmsb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","a man found him wandering in the field and asked, “What are you looking for?” ");
INSERT INTO engmsb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“I am looking for my brothers,” Joseph replied. “Can you please tell me where they are pasturing their flocks?” ");
INSERT INTO engmsb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“They have moved on from here,” the man answered. “I heard them say, ‘Let us go to Dothan.’” So Joseph set out after his brothers and found them at Dothan. ");
INSERT INTO engmsb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Now Joseph’s brothers saw him in the distance, and before he arrived, they plotted to kill him. ");
INSERT INTO engmsb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Here comes that dreamer!” they said to one another. ");
INSERT INTO engmsb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Come now, let us kill him and throw him into one of the pits. We can say that a vicious animal has devoured him. Then we shall see what becomes of his dreams!” ");
INSERT INTO engmsb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","When Reuben heard this, he tried to rescue Joseph from their hands. “Let us not take his life,” he said. ");
INSERT INTO engmsb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“Do not shed his blood. Throw him into this pit in the wilderness, but do not lay a hand on him.” Reuben said this so that he could rescue Joseph from their hands and return him to his father. ");
INSERT INTO engmsb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","So when Joseph came to his brothers, they stripped him of his robe—the robe of many colors he was wearing— ");
INSERT INTO engmsb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","and they took him and threw him into the pit. Now the pit was empty, with no water in it. ");
INSERT INTO engmsb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","And as they sat down to eat a meal, they looked up and saw a caravan of Ishmaelites coming from Gilead. Their camels were carrying spices, balm, and myrrh on their way down to Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Then Judah said to his brothers, “What profit will we gain if we kill our brother and cover up his blood? ");
INSERT INTO engmsb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Come, let us sell him to the Ishmaelites and not lay a hand on him; for he is our brother, our own flesh.” And they agreed. ");
INSERT INTO engmsb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","So when the Midianite traders passed by, his brothers pulled Joseph out of the pit and sold him for twenty shekels of silver to the Ishmaelites, who took him to Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","When Reuben returned to the pit and saw that Joseph was not there, he tore his clothes, ");
INSERT INTO engmsb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","returned to his brothers, and said, “The boy is gone! What am I going to do?” ");
INSERT INTO engmsb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Then they took Joseph’s robe, slaughtered a young goat, and dipped the robe in its blood. ");
INSERT INTO engmsb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","They sent the robe of many colors to their father and said, “We found this. Examine it to see whether it is your son’s robe or not.” ");
INSERT INTO engmsb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","His father recognized it and said, “It is my son’s robe! A vicious animal has devoured him. Joseph has surely been torn to pieces!” ");
INSERT INTO engmsb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Then Jacob tore his clothes, put sackcloth around his waist, and mourned for his son many days. ");
INSERT INTO engmsb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All his sons and daughters tried to comfort him, but he refused to be comforted. “No,” he said. “I will go down to Sheol mourning for my son.” So his father wept for him. ");
INSERT INTO engmsb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Meanwhile, the Midianites sold Joseph in Egypt to Potiphar, an officer of Pharaoh and captain of the guard. ");
INSERT INTO engmsb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","About that time, Judah left his brothers and settled near a man named Hirah, an Adullamite. ");
INSERT INTO engmsb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","There Judah saw the daughter of a Canaanite man named Shua, and he took her as a wife and slept with her. ");
INSERT INTO engmsb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","So she conceived and gave birth to a son, and Judah named him Er. ");
INSERT INTO engmsb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Again she conceived and gave birth to a son, and she named him Onan. ");
INSERT INTO engmsb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Then she gave birth to another son and named him Shelah; it was at Chezib that she gave birth to him. ");
INSERT INTO engmsb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Now Judah acquired a wife for Er, his firstborn, and her name was Tamar. ");
INSERT INTO engmsb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Er, Judah’s firstborn, was wicked in the sight of the LORD; so the LORD put him to death. ");
INSERT INTO engmsb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah said to Onan, “Sleep with your brother’s wife. Perform your duty as her brother-in-law and raise up offspring for your brother.” ");
INSERT INTO engmsb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","But Onan knew that the offspring would not belong to him; so whenever he would sleep with his brother’s wife, he would spill his seed on the ground so that he would not produce offspring for his brother. ");
INSERT INTO engmsb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","What he did was wicked in the sight of the LORD, so He put Onan to death as well. ");
INSERT INTO engmsb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to his daughter-in-law Tamar, “Live as a widow in your father’s house until my son Shelah grows up.” For he thought, “He may die too, like his brothers.” So Tamar went to live in her father’s house. ");
INSERT INTO engmsb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","After a long time Judah’s wife, the daughter of Shua, died. When Judah had finished mourning, he and his friend Hirah the Adullamite went up to his sheepshearers at Timnah. ");
INSERT INTO engmsb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","When Tamar was told, “Your father-in-law is going up to Timnah to shear his sheep,” ");
INSERT INTO engmsb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","she removed her widow’s garments, covered her face with a veil to disguise herself, and sat at the entrance to Enaim, which is on the way to Timnah. For she saw that although Shelah had grown up, she had not been given to him as a wife. ");
INSERT INTO engmsb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","When Judah saw her, he thought she was a prostitute because she had covered her face. ");
INSERT INTO engmsb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Not realizing that she was his daughter-in-law, he went over to her and said, “Come now, let me sleep with you.” “What will you give me for sleeping with you?” she inquired. ");
INSERT INTO engmsb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“I will send you a young goat from my flock,” Judah answered. But she replied, “Only if you leave me something as a pledge until you send it.” ");
INSERT INTO engmsb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“What pledge should I give you?” he asked. She answered, “Your seal and your cord, and the staff in your hand.” So he gave them to her and slept with her, and she became pregnant by him. ");
INSERT INTO engmsb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Then Tamar got up and departed. And she removed her veil and put on her widow’s garments again. ");
INSERT INTO engmsb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Now when Judah sent his friend Hirah the Adullamite with the young goat to collect the items he had left with the woman, he could not find her. ");
INSERT INTO engmsb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","He asked the men of that place, “Where is the shrine prostitute who was beside the road at Enaim?” “No shrine prostitute has been here,” they answered. ");
INSERT INTO engmsb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So Hirah returned to Judah and said, “I could not find her, and furthermore, the men of that place said, ‘No shrine prostitute has been here.’” ");
INSERT INTO engmsb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“Let her keep the items,” Judah replied. “Otherwise we will become a laughingstock. After all, I did send her this young goat, but you could not find her.” ");
INSERT INTO engmsb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","About three months later, Judah was told, “Your daughter-in-law Tamar has prostituted herself, and now she is pregnant.” “Bring her out!” Judah replied. “Let her be burned to death!” ");
INSERT INTO engmsb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","As she was being brought out, Tamar sent a message to her father-in-law: “I am pregnant by the man to whom these items belong.” And she added, “Please examine them. Whose seal and cord and staff are these?” ");
INSERT INTO engmsb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah recognized the items and said, “She is more righteous than I, since I did not give her to my son Shelah.” And he did not have relations with her again. ");
INSERT INTO engmsb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","When the time came for Tamar to give birth, there were twins in her womb. ");
INSERT INTO engmsb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","And as she was giving birth, one of them put out his hand; so the midwife took a scarlet thread and tied it around his wrist. “This one came out first,” she announced. ");
INSERT INTO engmsb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But when he pulled his hand back and his brother came out, she said, “You have broken out first!” So he was named Perez. ");
INSERT INTO engmsb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Then his brother came out with the scarlet thread around his wrist, and he was named Zerah. ");
INSERT INTO engmsb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Meanwhile, Joseph had been taken down to Egypt, where an Egyptian named Potiphar, an officer of Pharaoh and captain of the guard, bought him from the Ishmaelites who had taken him there. ");
INSERT INTO engmsb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","And the LORD was with Joseph, and he became a successful man, serving in the household of his Egyptian master. ");
INSERT INTO engmsb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","When his master saw that the LORD was with him and made him prosper in all he did, ");
INSERT INTO engmsb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph found favor in his sight and became his personal attendant. Potiphar put him in charge of his household and entrusted him with everything he owned. ");
INSERT INTO engmsb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","From the time that he put Joseph in charge of his household and all he owned, the LORD blessed the Egyptian’s household on account of him. The LORD’s blessing was on everything he owned, both in his house and in his field. ");
INSERT INTO engmsb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","So Potiphar left all that he owned in Joseph’s care; he did not concern himself with anything except the food he ate. Now Joseph was well-built and handsome, ");
INSERT INTO engmsb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","and after some time his master’s wife cast her eyes upon Joseph and said, “Sleep with me.” ");
INSERT INTO engmsb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he refused. “Look,” he said to his master’s wife, “with me here, my master does not concern himself with anything in his house, and he has entrusted everything he owns to my care. ");
INSERT INTO engmsb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","No one in this house is greater than I am. He has withheld nothing from me except you, because you are his wife. So how could I do such a great evil and sin against God?” ");
INSERT INTO engmsb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Although Potiphar’s wife spoke to Joseph day after day, he refused to go to bed with her or even be near her. ");
INSERT INTO engmsb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","One day, however, Joseph went into the house to attend to his work, and not a single household servant was inside. ");
INSERT INTO engmsb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","She grabbed Joseph by his cloak and said, “Sleep with me!” But leaving his cloak in her hand, he escaped and ran outside. ");
INSERT INTO engmsb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","When she saw that he had left his cloak in her hand and had run out of the house, ");
INSERT INTO engmsb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","she called her household servants. “Look,” she said, “this Hebrew has been brought to us to make sport of us. He came to me so he could sleep with me, but I screamed as loud as I could. ");
INSERT INTO engmsb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","When he heard me scream for help, he left his cloak beside me and ran out of the house.” ");
INSERT INTO engmsb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","So Potiphar’s wife kept Joseph’s cloak beside her until his master came home. ");
INSERT INTO engmsb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Then she told him the same story: “The Hebrew slave you brought us came to me to make sport of me, ");
INSERT INTO engmsb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","but when I screamed for help, he left his cloak beside me and ran out of the house.” ");
INSERT INTO engmsb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","When his master heard the story his wife told him, saying, “This is what your slave did to me,” he burned with anger. ");
INSERT INTO engmsb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","So Joseph’s master took him and had him thrown into the prison where the king’s prisoners were confined. While Joseph was there in the prison, ");
INSERT INTO engmsb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","the LORD was with him and extended kindness to him, granting him favor in the eyes of the prison warden. ");
INSERT INTO engmsb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","And the warden put all the prisoners under Joseph’s care, so that he was responsible for all that was done in the prison. ");
INSERT INTO engmsb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The warden did not concern himself with anything under Joseph’s care, because the LORD was with Joseph and gave him success in whatever he did. ");
INSERT INTO engmsb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Some time later, the king’s cupbearer and baker offended their master, the king of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh was angry with his two officers, the chief cupbearer and the chief baker, ");
INSERT INTO engmsb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","and imprisoned them in the house of the captain of the guard, the same prison where Joseph was confined. ");
INSERT INTO engmsb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The captain of the guard assigned them to Joseph, and he became their personal attendant. After they had been in custody for some time, ");
INSERT INTO engmsb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","both of these men—the Egyptian king’s cupbearer and baker, who were being held in the prison—had a dream on the same night, and each dream had its own meaning. ");
INSERT INTO engmsb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","When Joseph came to them in the morning, he saw that they were distraught. ");
INSERT INTO engmsb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","So he asked the officials of Pharaoh who were in custody with him in his master’s house, “Why are your faces so downcast today?” ");
INSERT INTO engmsb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“We both had dreams,” they replied, “but there is no one to interpret them.” Then Joseph said to them, “Don’t interpretations belong to God? Tell me your dreams.” ");
INSERT INTO engmsb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the chief cupbearer told Joseph his dream: “In my dream there was a vine before me, ");
INSERT INTO engmsb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","and on the vine were three branches. As it budded, its blossoms opened and its clusters ripened into grapes. ");
INSERT INTO engmsb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh’s cup was in my hand, and I took the grapes, squeezed them into his cup, and placed the cup in his hand.” ");
INSERT INTO engmsb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph replied, “This is the interpretation: The three branches are three days. ");
INSERT INTO engmsb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Within three days Pharaoh will lift up your head and restore your position. You will put Pharaoh’s cup in his hand, just as you did when you were his cupbearer. ");
INSERT INTO engmsb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But when it goes well for you, please remember me and show me kindness by mentioning me to Pharaoh, that he might bring me out of this prison. ");
INSERT INTO engmsb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","For I was kidnapped from the land of the Hebrews, and even here I have done nothing for which they should have put me in this dungeon.” ");
INSERT INTO engmsb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief baker saw that the interpretation was favorable, he said to Joseph, “I too had a dream: There were three baskets of white bread on my head. ");
INSERT INTO engmsb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket were all sorts of baked goods for Pharaoh, but the birds were eating them out of the basket on my head.” ");
INSERT INTO engmsb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph replied, “This is the interpretation: The three baskets are three days. ");
INSERT INTO engmsb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Within three days Pharaoh will lift off your head and hang you on a tree. Then the birds will eat the flesh of your body.” ");
INSERT INTO engmsb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","On the third day, which was Pharaoh’s birthday, he held a feast for all his officials, and in their presence he lifted up the heads of the chief cupbearer and the chief baker. ");
INSERT INTO engmsb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Pharaoh restored the chief cupbearer to his position, so that he once again placed the cup in Pharaoh’s hand. ");
INSERT INTO engmsb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But Pharaoh hanged the chief baker, just as Joseph had described to them in his interpretation. ");
INSERT INTO engmsb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","The chief cupbearer, however, did not remember Joseph; he forgot all about him. ");
INSERT INTO engmsb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","After two full years had passed, Pharaoh had a dream: He was standing beside the Nile, ");
INSERT INTO engmsb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","when seven cows, sleek and well-fed, came up from the river and began to graze among the reeds. ");
INSERT INTO engmsb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","After them, seven other cows, sickly and thin, came up from the Nile and stood beside the well-fed cows on the bank of the river. ");
INSERT INTO engmsb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","And the cows that were sickly and thin devoured the seven sleek, well-fed cows. Then Pharaoh woke up, ");
INSERT INTO engmsb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","but he fell back asleep and dreamed a second time: Seven heads of grain, plump and ripe, came up on one stalk. ");
INSERT INTO engmsb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","After them, seven other heads of grain sprouted, thin and scorched by the east wind. ");
INSERT INTO engmsb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","And the thin heads of grain swallowed up the seven plump, ripe ones. Then Pharaoh awoke and realized it was a dream. ");
INSERT INTO engmsb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","In the morning his spirit was troubled, so he summoned all the magicians and wise men of Egypt. Pharaoh told them his dreams, but no one could interpret them for him. ");
INSERT INTO engmsb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the chief cupbearer said to Pharaoh, “Today I recall my failures. ");
INSERT INTO engmsb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaoh was once angry with his servants, and he put me and the chief baker in the custody of the captain of the guard. ");
INSERT INTO engmsb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","One night both the chief baker and I had dreams, and each dream had its own meaning. ");
INSERT INTO engmsb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Now a young Hebrew was there with us, a servant of the captain of the guard. We told him our dreams and he interpreted them for us individually. ");
INSERT INTO engmsb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","And it happened to us just as he had interpreted: I was restored to my position, and the other man was hanged.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","So Pharaoh sent for Joseph, who was quickly brought out of the dungeon. After he had shaved and changed his clothes, he went in before Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, and no one can interpret it. But I have heard it said of you that when you hear a dream you can interpret it.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“I myself cannot do it,” Joseph replied, “but God will give Pharaoh a sound answer.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Then Pharaoh said to Joseph: “In my dream I was standing on the bank of the Nile, ");
INSERT INTO engmsb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","when seven cows, well-fed and sleek, came up from the river and began to graze among the reeds. ");
INSERT INTO engmsb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","After them, seven other cows—sickly, ugly, and thin—came up. I have never seen such ugly cows in all the land of Egypt! ");
INSERT INTO engmsb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Then the thin, ugly cows devoured the seven well-fed cows that were there first. ");
INSERT INTO engmsb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","When they had devoured them, however, no one could tell that they had done so; their appearance was as ugly as it had been before. Then I awoke. ");
INSERT INTO engmsb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","In my dream I also saw seven heads of grain, plump and ripe, growing on a single stalk. ");
INSERT INTO engmsb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","After them, seven other heads of grain sprouted—withered, thin, and scorched by the east wind. ");
INSERT INTO engmsb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","And the thin heads of grain swallowed the seven plump ones. I told this dream to the magicians, but no one could explain it to me.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","At this, Joseph said to Pharaoh, “The dreams of Pharaoh are one and the same. God has revealed to Pharaoh what He is about to do. ");
INSERT INTO engmsb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows are seven years, and the seven ripe heads of grain are seven years. The dreams have the same meaning. ");
INSERT INTO engmsb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Moreover, the seven thin, ugly cows that came up after them are seven years, and so are the seven worthless heads of grain scorched by the east wind—they are seven years of famine. ");
INSERT INTO engmsb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","It is just as I said to Pharaoh: God has shown Pharaoh what He is about to do. ");
INSERT INTO engmsb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Behold, seven years of great abundance are coming throughout the land of Egypt, ");
INSERT INTO engmsb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","but seven years of famine will follow them. Then all the abundance in the land of Egypt will be forgotten, and the famine will devastate the land. ");
INSERT INTO engmsb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","The abundance in the land will not be remembered, since the famine that follows it will be so severe. ");
INSERT INTO engmsb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Moreover, because the dream was given to Pharaoh in two versions, the matter has been decreed by God, and He will carry it out shortly. ");
INSERT INTO engmsb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Now, therefore, Pharaoh should look for a discerning and wise man and set him over the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Let Pharaoh take action and appoint commissioners over the land to take a fifth of the harvest of Egypt during the seven years of abundance. ");
INSERT INTO engmsb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Under the authority of Pharaoh, let them collect all the excess food from these good years, that they may come and lay up the grain to be preserved as food in the cities. ");
INSERT INTO engmsb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","This food will be a reserve for the land during the seven years of famine to come upon the land of Egypt. Then the country will not perish in the famine.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","This proposal pleased Pharaoh and all his officials. ");
INSERT INTO engmsb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","So Pharaoh asked them, “Can we find anyone like this man, in whom the Spirit of God abides?” ");
INSERT INTO engmsb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Then Pharaoh said to Joseph, “Since God has made all this known to you, there is no one as discerning and wise as you. ");
INSERT INTO engmsb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","You shall be in charge of my house, and all my people are to obey your commands. Only with regard to the throne will I be greater than you.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaoh also told Joseph, “I hereby place you over all the land of Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Then Pharaoh removed the signet ring from his finger, put it on Joseph’s finger, clothed him in garments of fine linen, and placed a gold chain around his neck. ");
INSERT INTO engmsb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","He had Joseph ride in his second chariot, with men calling out before him, “Bow the knee!” So he placed him over all the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","And Pharaoh declared to Joseph, “I am Pharaoh, but without your permission, no one in all the land of Egypt shall lift his hand or foot.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaoh gave Joseph the name Zaphenath-paneah, and he gave him Asenath daughter of Potiphera, priest of On, to be his wife. And Joseph took charge of all the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Now Joseph was thirty years old when he entered the service of Pharaoh king of Egypt. And Joseph left Pharaoh’s presence and traveled throughout the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","During the seven years of abundance, the land brought forth bountifully. ");
INSERT INTO engmsb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","During those seven years, Joseph collected all the excess food in the land of Egypt and stored it in the cities. In every city he laid up the food from the fields around it. ");
INSERT INTO engmsb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","So Joseph stored up grain in such abundance, like the sand of the sea, that he stopped keeping track of it; for it was beyond measure. ");
INSERT INTO engmsb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Before the years of famine arrived, two sons were born to Joseph by Asenath daughter of Potiphera, priest of On. ");
INSERT INTO engmsb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named the firstborn Manasseh, saying, “God has made me forget all my hardship and all my father’s household.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","And the second son he named Ephraim, saying, “God has made me fruitful in the land of my affliction.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","When the seven years of abundance in the land of Egypt came to an end, ");
INSERT INTO engmsb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","the seven years of famine began, just as Joseph had said. And although there was famine in every country, there was food throughout the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When extreme hunger came to all the land of Egypt and the people cried out to Pharaoh for food, he told all the Egyptians, “Go to Joseph and do whatever he tells you.” ");
INSERT INTO engmsb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","When the famine had spread over all the land, Joseph opened up all the storehouses and sold grain to the Egyptians; for the famine was severe in the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","And every nation came to Joseph in Egypt to buy grain, because the famine was severe over all the earth. ");
INSERT INTO engmsb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","When Jacob learned that there was grain in Egypt, he said to his sons, “Why are you staring at one another?” ");
INSERT INTO engmsb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“Look,” he added, “I have heard that there is grain in Egypt. Go down there and buy some for us, so that we may live and not die.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So ten of Joseph’s brothers went down to buy grain from Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob did not send Joseph’s brother Benjamin with his brothers, for he said, “I am afraid that harm might befall him.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So the sons of Israel were among those who came to buy grain, since the famine had also spread to the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Now Joseph was the ruler of the land; he was the one who sold grain to all its people. So when his brothers arrived, they bowed down before him with their faces to the ground. ");
INSERT INTO engmsb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","And when Joseph saw his brothers, he recognized them, but he treated them as strangers and spoke harshly to them. “Where have you come from?” he asked. “From the land of Canaan,” they replied. “We are here to buy food.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Although Joseph recognized his brothers, they did not recognize him. ");
INSERT INTO engmsb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph remembered his dreams about them and said, “You are spies! You have come to see if our land is vulnerable.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Not so, my lord,” they replied. “Your servants have come to buy food. ");
INSERT INTO engmsb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all sons of one man. Your servants are honest men, not spies.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“No,” he told them. “You have come to see if our land is vulnerable.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","But they answered, “Your servants are twelve brothers, the sons of one man in the land of Canaan. The youngest is now with our father, and one is no more.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Then Joseph declared, “Just as I said, you are spies! ");
INSERT INTO engmsb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","And this is how you will be tested: As surely as Pharaoh lives, you shall not leave this place unless your youngest brother comes here. ");
INSERT INTO engmsb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Send one of your number to get your brother; the rest of you will be confined so that the truth of your words may be tested. If they are untrue, then as surely as Pharaoh lives, you are spies!” ");
INSERT INTO engmsb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","So Joseph imprisoned them for three days, ");
INSERT INTO engmsb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","and on the third day he said to them, “I fear God. So do this and you will live: ");
INSERT INTO engmsb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest, leave one of your brothers in custody while the rest of you go and take back grain to relieve the hunger of your households. ");
INSERT INTO engmsb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Then bring your youngest brother to me so that your words can be verified, that you may not die.” And to this they consented. ");
INSERT INTO engmsb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Then they said to one another, “Surely we are being punished because of our brother. We saw his anguish when he pleaded with us, but we would not listen. That is why this distress has come upon us.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","And Reuben responded, “Didn’t I tell you not to sin against the boy? But you would not listen. Now we must account for his blood!” ");
INSERT INTO engmsb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","They did not realize that Joseph understood them, since there was an interpreter between them. ");
INSERT INTO engmsb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","And he turned away from them and wept. When he turned back and spoke to them, he took Simeon from them and had him bound before their eyes. ");
INSERT INTO engmsb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Then Joseph gave orders to fill their bags with grain, to return each man’s silver to his sack, and to give them provisions for their journey. This order was carried out, ");
INSERT INTO engmsb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","and they loaded the grain on their donkeys and departed. ");
INSERT INTO engmsb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","At the place where they lodged for the night, one of them opened his sack to get feed for his donkey, and he saw his silver in the mouth of the sack. ");
INSERT INTO engmsb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“My silver has been returned!” he said to his brothers. “It is here in my sack.” Their hearts sank, and trembling, they turned to one another and said, “What is this that God has done to us?” ");
INSERT INTO engmsb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","When they reached their father Jacob in the land of Canaan, they described to him all that had happened to them: ");
INSERT INTO engmsb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man who is lord of the land spoke harshly to us and accused us of spying on the country. ");
INSERT INTO engmsb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","But we told him, ‘We are honest men, not spies. ");
INSERT INTO engmsb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, sons of one father. One is no more, and the youngest is now with our father in the land of Canaan.’ ");
INSERT INTO engmsb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Then the man who is lord of the land said to us, ‘This is how I will know whether you are honest: Leave one brother with me, take food to relieve the hunger of your households, and go. ");
INSERT INTO engmsb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","But bring your youngest brother back to me so I will know that you are not spies but honest men. Then I will give your brother back to you, and you can trade in the land.’” ");
INSERT INTO engmsb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","As they began emptying their sacks, there in each man’s sack was his bag of silver! And when they and their father saw the bags of silver, they were dismayed. ");
INSERT INTO engmsb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Their father Jacob said to them, “You have deprived me of my sons. Joseph is gone and Simeon is no more. Now you want to take Benjamin. Everything is going against me!” ");
INSERT INTO engmsb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Then Reuben said to his father, “You may kill my two sons if I fail to bring him back to you. Put him in my care, and I will return him.” ");
INSERT INTO engmsb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But Jacob replied, “My son will not go down there with you, for his brother is dead, and he alone is left. If any harm comes to him on your journey, you will bring my gray hair down to Sheol in sorrow.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Now the famine was still severe in the land. ");
INSERT INTO engmsb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","So when Jacob’s sons had eaten all the grain they had brought from Egypt, their father said to them, “Go back and buy us a little more food.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Judah replied, “The man solemnly warned us, ‘You will not see my face again unless your brother is with you.’ ");
INSERT INTO engmsb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you will send our brother with us, we will go down and buy food for you. ");
INSERT INTO engmsb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you will not send him, we will not go; for the man told us, ‘You will not see my face again unless your brother is with you.’” ");
INSERT INTO engmsb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“Why did you bring this trouble upon me?” Israel asked. “Why did you tell the man you had another brother?” ");
INSERT INTO engmsb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","They replied, “The man questioned us in detail about ourselves and our family: ‘Is your father still alive? Do you have another brother?’ And we answered him accordingly. How could we possibly know that he would say, ‘Bring your brother here’?” ");
INSERT INTO engmsb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","And Judah said to his father Israel, “Send the boy with me, and we will go at once, so that we may live and not die—neither we, nor you, nor our children. ");
INSERT INTO engmsb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I will guarantee his safety. You may hold me personally responsible. If I do not bring him back and set him before you, then may I bear the guilt before you all my life. ");
INSERT INTO engmsb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","If we had not delayed, we could have come and gone twice by now.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Israel said to them, “If it must be so, then do this: Put some of the best products of the land in your packs and carry them down as a gift for the man—a little balm and a little honey, spices and myrrh, pistachios and almonds. ");
INSERT INTO engmsb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take double the silver with you so that you may return the silver that was put back into the mouths of your sacks. Perhaps it was a mistake. ");
INSERT INTO engmsb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take your brother as well, and return to the man at once. ");
INSERT INTO engmsb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","May God Almighty grant you mercy before the man, that he may release your other brother along with Benjamin. As for me, if I am bereaved, I am bereaved.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So the men took these gifts, along with double the amount of silver, and Benjamin as well. Then they hurried down to Egypt and stood before Joseph. ");
INSERT INTO engmsb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with his brothers, he said to the steward of his house, “Take these men to my house. Slaughter an animal and prepare it, for they shall dine with me at noon.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The man did as Joseph had commanded and took the brothers to Joseph’s house. ");
INSERT INTO engmsb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","But the brothers were frightened that they had been taken to Joseph’s house. “We have been brought here because of the silver that was returned in our bags the first time,” they said. “They intend to overpower us and take us as slaves, along with our donkeys.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So they approached Joseph’s steward and spoke to him at the entrance to the house. ");
INSERT INTO engmsb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Please, sir,” they said, “we really did come down here the first time to buy food. ");
INSERT INTO engmsb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","But when we came to the place we lodged for the night, we opened our sacks and, behold, each of us found his silver in the mouth of his sack! It was the full amount of our silver, and we have brought it back with us. ");
INSERT INTO engmsb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We have brought additional silver with us to buy food. We do not know who put our silver in our sacks.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“It is fine,” said the steward. “Do not be afraid. Your God, the God of your father, gave you the treasure that was in your sacks. I received your silver.” Then he brought Simeon out to them. ");
INSERT INTO engmsb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","And the steward took the men into Joseph’s house, gave them water to wash their feet, and provided food for their donkeys. ");
INSERT INTO engmsb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Since the brothers had been told that they were going to eat a meal there, they prepared their gift for Joseph’s arrival at noon. ");
INSERT INTO engmsb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, they presented him with the gifts they had brought, and they bowed to the ground before him. ");
INSERT INTO engmsb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked if they were well, and then he asked, “How is your elderly father you told me about? Is he still alive?” ");
INSERT INTO engmsb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Your servant our father is well,” they answered. “He is still alive.” And they bowed down to honor him. ");
INSERT INTO engmsb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","When Joseph looked up and saw his brother Benjamin, his own mother’s son, he asked, “Is this your youngest brother, the one you told me about?” Then he declared, “May God be gracious to you, my son.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph hurried out because he was moved to tears for his brother, and he went to a private room to weep. ");
INSERT INTO engmsb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then he washed his face and came back out. Regaining his composure, he said, “Serve the meal.” ");
INSERT INTO engmsb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","They separately served Joseph, his brothers, and the Egyptians. They ate separately because the Egyptians would not eat with the Hebrews, since that was detestable to them. ");
INSERT INTO engmsb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","They were seated before Joseph in order by age, from the firstborn to the youngest, and the men looked at one another in astonishment. ");
INSERT INTO engmsb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","When the portions were served to them from Joseph’s table, Benjamin’s portion was five times larger than any of the others. So they feasted and drank freely with Joseph. ");
INSERT INTO engmsb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Then Joseph instructed his steward: “Fill the men’s sacks with as much food as they can carry, and put each one’s silver in the mouth of his sack. ");
INSERT INTO engmsb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Put my cup, the silver one, in the mouth of the youngest one’s sack, along with the silver for his grain.” So the steward did as Joseph had instructed. ");
INSERT INTO engmsb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","At daybreak, the men were sent on their way with their donkeys. ");
INSERT INTO engmsb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","They had not gone far from the city when Joseph told his steward, “Pursue the men at once, and when you overtake them, ask, ‘Why have you repaid good with evil? ");
INSERT INTO engmsb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Is this not the cup my master drinks from and uses for divination? What you have done is wicked!’” ");
INSERT INTO engmsb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","When the steward overtook them, he relayed these words to them. ");
INSERT INTO engmsb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","“Why does my lord say these things?” they asked. “Your servants could not possibly do such a thing. ");
INSERT INTO engmsb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","We even brought back to you from the land of Canaan the silver we found in the mouths of our sacks. Why would we steal silver or gold from your master’s house? ");
INSERT INTO engmsb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If any of your servants is found to have it, he must die, and the rest will become slaves of my lord.” ");
INSERT INTO engmsb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“As you say,” replied the steward. “But only the one who is found with the cup will be my slave, and the rest of you shall be free of blame.” ");
INSERT INTO engmsb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","So each one quickly lowered his sack to the ground and opened it. ");
INSERT INTO engmsb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","The steward searched, beginning with the oldest and ending with the youngest—and the cup was found in Benjamin’s sack. ");
INSERT INTO engmsb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Then they all tore their clothes, loaded their donkeys, and returned to the city. ");
INSERT INTO engmsb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","When Judah and his brothers arrived at Joseph’s house, he was still there, and they fell to the ground before him. ");
INSERT INTO engmsb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","“What is this deed you have done?” Joseph declared. “Do you not know that a man like me can surely divine the truth?” ");
INSERT INTO engmsb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“What can we say to my lord?” Judah replied. “How can we plead? How can we justify ourselves? God has exposed the iniquity of your servants. We are now my lord’s slaves—both we and the one who was found with the cup.” ");
INSERT INTO engmsb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But Joseph replied, “Far be it from me to do this. The man who was found with the cup will be my slave. The rest of you may return to your father in peace.” ");
INSERT INTO engmsb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah approached Joseph and said, “Sir, please let your servant speak personally to my lord. Do not be angry with your servant, for you are equal to Pharaoh himself. ");
INSERT INTO engmsb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord asked his servants, ‘Do you have a father or a brother?’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","And we answered, ‘We have an elderly father and a younger brother, the child of his old age. The boy’s brother is dead. He is the only one of his mother’s sons left, and his father loves him.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you told your servants, ‘Bring him down to me so that I can see him for myself.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","So we said to my lord, ‘The boy cannot leave his father. If he were to leave, his father would die.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you said to your servants, ‘Unless your younger brother comes down with you, you will not see my face again.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Now when we returned to your servant my father, we relayed your words to him. ");
INSERT INTO engmsb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Then our father said, ‘Go back and buy us some food.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","But we answered, ‘We cannot go down there unless our younger brother goes with us. So if our younger brother is not with us, we cannot see the man.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","And your servant my father said to us, ‘You know that my wife bore me two sons. ");
INSERT INTO engmsb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","When one of them was gone, I said: “Surely he has been torn to pieces.” And I have not seen him since. ");
INSERT INTO engmsb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Now if you also take this one from me and harm comes to him, you will bring my gray hair down to Sheol in sorrow.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","So if the boy is not with us when I return to your servant, and if my father, whose life is wrapped up in the boy’s life, ");
INSERT INTO engmsb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sees that the boy is not with us, he will die. Then your servants will have brought the gray hair of your servant our father down to Sheol in sorrow. ");
INSERT INTO engmsb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Indeed, your servant guaranteed the boy’s safety to my father, saying, ‘If I do not return him to you, I will bear the guilt before you, my father, all my life.’ ");
INSERT INTO engmsb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Now please let your servant stay here as my lord’s slave in place of the boy. Let him return with his brothers. ");
INSERT INTO engmsb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how can I go back to my father without the boy? I could not bear to see the misery that would overwhelm him.” ");
INSERT INTO engmsb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Then Joseph could no longer control himself before all his attendants, and he cried out, “Send everyone away from me!” So none of them were with Joseph when he made himself known to his brothers. ");
INSERT INTO engmsb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","But he wept so loudly that the Egyptians heard him, and Pharaoh’s household soon heard of it. ");
INSERT INTO engmsb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph said to his brothers, “I am Joseph! Is my father still alive?” But they were unable to answer him, because they were terrified in his presence. ");
INSERT INTO engmsb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Then Joseph said to his brothers, “Please come near me.” And they did so. “I am Joseph, your brother,” he said, “the one you sold into Egypt! ");
INSERT INTO engmsb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","And now, do not be distressed or angry with yourselves that you sold me into this place, because it was to save lives that God sent me before you. ");
INSERT INTO engmsb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","For the famine has covered the land these two years, and there will be five more years without plowing or harvesting. ");
INSERT INTO engmsb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me before you to preserve you as a remnant on the earth and to save your lives by a great deliverance. ");
INSERT INTO engmsb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Therefore it was not you who sent me here, but God, who has made me a father to Pharaoh—lord of all his household and ruler over all the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Now return quickly to my father and tell him, ‘This is what your son Joseph says: God has made me lord of all Egypt. Come down to me without delay. ");
INSERT INTO engmsb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You shall settle in the land of Goshen and be near me—you and your children and grandchildren, your flocks and herds, and everything you own. ");
INSERT INTO engmsb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","And there I will provide for you, because there will be five more years of famine. Otherwise, you and your household and everything you own will come to destitution.’ ");
INSERT INTO engmsb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Behold! You and my brother Benjamin can see that I, Joseph, am the one speaking with you. ");
INSERT INTO engmsb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tell my father about all my splendor in Egypt and everything you have seen. And bring my father down here quickly.” ");
INSERT INTO engmsb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then Joseph threw his arms around his brother Benjamin and wept, and Benjamin wept as they embraced. ");
INSERT INTO engmsb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Joseph kissed each of his brothers as he wept over them. And afterward his brothers talked with him. ");
INSERT INTO engmsb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","When the news reached Pharaoh’s house that Joseph’s brothers had come, Pharaoh and his servants were pleased. ");
INSERT INTO engmsb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh said to Joseph, “Tell your brothers, ‘Do as follows: Load your animals and return to the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Then bring your father and your families and return to me. I will give you the best of the land of Egypt, and you shall eat from the fat of the land.’ ");
INSERT INTO engmsb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","You are also directed to tell them: ‘Take wagons from the land of Egypt for your young children and your wives, and bring your father and come back. ");
INSERT INTO engmsb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","But pay no regard to your belongings, for the best of all the land of Egypt is yours.’” ");
INSERT INTO engmsb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","So the sons of Israel did as they were told. Joseph gave them wagons as Pharaoh had instructed, and he also gave them provisions for their journey. ");
INSERT INTO engmsb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","He gave new garments to each of them, but to Benjamin he gave three hundred shekels of silver and five sets of clothes. ");
INSERT INTO engmsb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","And he sent to his father the following: ten donkeys loaded with the best of Egypt, and ten female donkeys loaded with grain and bread and provisions for his father’s journey. ");
INSERT INTO engmsb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Then Joseph sent his brothers on their way, and as they were leaving, he said to them, “Do not quarrel on the way!” ");
INSERT INTO engmsb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So the brothers went up out of Egypt and came to their father Jacob in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Joseph is still alive,” they said, “and he is ruler over all the land of Egypt!” But Jacob was stunned, for he did not believe them. ");
INSERT INTO engmsb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","However, when they relayed all that Joseph had told them, and when he saw the wagons that Joseph had sent to carry him back, the spirit of their father Jacob was revived. ");
INSERT INTO engmsb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Enough!” declared Israel. “My son Joseph is still alive! I will go to see him before I die.” ");
INSERT INTO engmsb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Israel set out with all that he had, and when he came to Beersheba, he offered sacrifices to the God of his father Isaac. ");
INSERT INTO engmsb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","And that night God spoke to Israel in a vision: “Jacob, Jacob!” He said. “Here I am,” replied Jacob. ");
INSERT INTO engmsb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“I am God,” He said, “the God of your father. Do not be afraid to go down to Egypt, for I will make you into a great nation there. ");
INSERT INTO engmsb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go down with you to Egypt, and I will surely bring you back. And Joseph’s own hands will close your eyes.” ");
INSERT INTO engmsb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob departed from Beersheba, and the sons of Israel took their father Jacob in the wagons Pharaoh had sent to carry him, along with their children and wives. ");
INSERT INTO engmsb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","They also took the livestock and possessions they had acquired in the land of Canaan, and Jacob and all his offspring went to Egypt. ");
INSERT INTO engmsb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jacob took with him to Egypt his sons and grandsons, and his daughters and granddaughters—all his offspring. ");
INSERT INTO engmsb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Now these are the names of the sons of Israel (Jacob and his descendants) who went to Egypt: Reuben, Jacob’s firstborn. ");
INSERT INTO engmsb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","The sons of Reuben: Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engmsb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","The sons of Simeon: Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul the son of a Canaanite woman. ");
INSERT INTO engmsb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","The sons of Levi: Gershon, Kohath, and Merari. ");
INSERT INTO engmsb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","The sons of Judah: Er, Onan, Shelah, Perez, and Zerah; but Er and Onan died in the land of Canaan. The sons of Perez: Hezron and Hamul. ");
INSERT INTO engmsb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","The sons of Issachar: Tola, Puvah, Job, and Shimron. ");
INSERT INTO engmsb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","The sons of Zebulun: Sered, Elon, and Jahleel. ");
INSERT INTO engmsb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are the sons of Leah born to Jacob in Paddan-aram, in addition to his daughter Dinah. The total number of sons and daughters was thirty-three. ");
INSERT INTO engmsb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","The sons of Gad: Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engmsb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","The children of Asher: Imnah, Ishvah, Ishvi, Beriah, and their sister Serah. The sons of Beriah: Heber and Malchiel. ");
INSERT INTO engmsb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the sons of Jacob born to Zilpah—whom Laban gave to his daughter Leah—sixteen in all. ");
INSERT INTO engmsb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Jacob’s wife Rachel: Joseph and Benjamin. ");
INSERT INTO engmsb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Manasseh and Ephraim were born to Joseph in the land of Egypt by Asenath daughter of Potiphera, priest of On. ");
INSERT INTO engmsb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","The sons of Benjamin: Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard. ");
INSERT INTO engmsb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are the sons of Rachel born to Jacob—fourteen in all. ");
INSERT INTO engmsb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","The son of Dan: Hushim. ");
INSERT INTO engmsb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","The sons of Naphtali: Jahzeel, Guni, Jezer, and Shillem. ");
INSERT INTO engmsb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are the sons of Jacob born to Bilhah, whom Laban gave to his daughter Rachel—seven in all. ");
INSERT INTO engmsb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All those belonging to Jacob who came to Egypt—his direct descendants, besides the wives of Jacob’s sons—numbered sixty-six persons. ");
INSERT INTO engmsb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","And with the two sons who had been born to Joseph in Egypt, the members of Jacob’s family who went to Egypt were seventy in all. ");
INSERT INTO engmsb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Now Jacob had sent Judah ahead of him to Joseph to get directions to Goshen. When Jacob’s family arrived in the land of Goshen, ");
INSERT INTO engmsb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph prepared his chariot and went there to meet his father Israel. Joseph presented himself to him, embraced him, and wept profusely. ");
INSERT INTO engmsb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Then Israel said to Joseph, “Finally I can die, now that I have seen your face and know that you are still alive!” ");
INSERT INTO engmsb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph said to his brothers and to his father’s household, “I will go up and inform Pharaoh: ‘My brothers and my father’s household from the land of Canaan have come to me. ");
INSERT INTO engmsb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","The men are shepherds; they raise livestock, and they have brought their flocks and herds and all that they own.’ ");
INSERT INTO engmsb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","When Pharaoh summons you and asks, ‘What is your occupation?’ ");
INSERT INTO engmsb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","you are to say, ‘Your servants have raised livestock ever since our youth—both we and our fathers.’ Then you will be allowed to settle in the land of Goshen, since all shepherds are detestable to the Egyptians.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","So Joseph went and told Pharaoh: “My father and my brothers, with their flocks and herds and all they own, have come from the land of Canaan and are now in Goshen.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","And he chose five of his brothers and presented them before Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","“What is your occupation?” Pharaoh asked Joseph’s brothers. “Your servants are shepherds,” they replied, “both we and our fathers.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Then they said to Pharaoh, “We have come to live in the land for a time, because there is no pasture for the flocks of your servants, since the famine in the land of Canaan has been severe. So now, please allow your servants to settle in the land of Goshen.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaoh said to Joseph, “Now that your father and brothers have come to you, ");
INSERT INTO engmsb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","the land of Egypt is before you; settle your father and brothers in the best part of the land. They may dwell in the land of Goshen. And if you know of any talented men among them, put them in charge of my own livestock.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph brought in his father Jacob and presented him before Pharaoh, and Jacob blessed Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","“How many years have you lived?” Pharaoh asked. ");
INSERT INTO engmsb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“My travels have lasted 130 years,” Jacob replied. “My years have been few and hard, and they have not matched the years of the travels of my fathers.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob blessed Pharaoh and departed from his presence. ");
INSERT INTO engmsb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","So Joseph settled his father and brothers in the land of Egypt and gave them property in the best part of the land, the district of Rameses, as Pharaoh had commanded. ");
INSERT INTO engmsb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph also provided his father and brothers and all his father’s household with food for their families. ");
INSERT INTO engmsb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","There was no food, however, in all that region, because the famine was so severe; the lands of Egypt and Canaan had been exhausted by the famine. ");
INSERT INTO engmsb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph collected all the money to be found in the land of Egypt and the land of Canaan in exchange for the grain they were buying, and he brought it into Pharaoh’s palace. ");
INSERT INTO engmsb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","When the money from the lands of Egypt and Canaan was gone, all the Egyptians came to Joseph and said, “Give us food. Why should we die before your eyes? For our funds have run out!” ");
INSERT INTO engmsb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“Then bring me your livestock,” said Joseph. “Since the money is gone, I will sell you food in exchange for your livestock.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they brought their livestock to Joseph, and he gave them food in exchange for their horses, their flocks and herds, and their donkeys. Throughout that year he provided them with food in exchange for all their livestock. ");
INSERT INTO engmsb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","When that year was over, they came to him the second year and said, “We cannot hide from our lord that our money is gone and all our livestock belongs to you. There is nothing left for our lord except our bodies and our land. ");
INSERT INTO engmsb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Why should we perish before your eyes—we and our land as well? Purchase us and our land in exchange for food. Then we, along with our land, will be slaves to Pharaoh. Give us seed that we may live and not die, and that the land may not become desolate.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph acquired for Pharaoh all the land in Egypt; the Egyptians, one and all, sold their fields because the famine was so severe upon them. The land became Pharaoh’s, ");
INSERT INTO engmsb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","and Joseph reduced the people to servitude from one end of Egypt to the other. ");
INSERT INTO engmsb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","However, he did not acquire the priests’ portion of the land, for it had been given to them by Pharaoh. They ate the rations that Pharaoh supplied; so they did not sell their land. ");
INSERT INTO engmsb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Joseph said to the people, “Now that I have acquired you and your land for Pharaoh this day, here is seed for you to sow in the land. ");
INSERT INTO engmsb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","At harvest time, you are to give a fifth of it to Pharaoh, and four-fifths will be yours as seed for the field and food for yourselves and your households and children.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“You have saved our lives,” they said. “We have found favor in our lord’s eyes, and we will be Pharaoh’s servants.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph established a law that a fifth of the produce belongs to Pharaoh, and it is in effect in the land of Egypt to this day. Only the priests’ land does not belong to Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Now the Israelites settled in the land of Egypt, in the region of Goshen. They acquired property there and became fruitful and increased greatly in number. ");
INSERT INTO engmsb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","And Jacob lived in the land of Egypt seventeen years, and the length of his life was 147 years. ");
INSERT INTO engmsb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","When the time drew near for Israel to die, he called his son Joseph and said to him, “If I have found favor in your eyes, put your hand under my thigh and promise to show me kindness and faithfulness. Do not bury me in Egypt, ");
INSERT INTO engmsb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","but when I lie down with my fathers, carry me out of Egypt and bury me with them.” Joseph answered, “I will do as you have requested.” ");
INSERT INTO engmsb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“Swear to me,” Jacob said. So Joseph swore to him, and Israel bowed in worship at the head of his bed. ");
INSERT INTO engmsb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Some time later Joseph was told, “Your father is ill.” So he set out with his two sons, Manasseh and Ephraim. ");
INSERT INTO engmsb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When Jacob was told, “Your son Joseph has come to you,” Israel rallied his strength and sat up in bed. ");
INSERT INTO engmsb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob said to Joseph, “God Almighty appeared to me at Luz in the land of Canaan, and there He blessed me ");
INSERT INTO engmsb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","and told me, ‘Behold, I will make you fruitful and multiply you; I will make you a multitude of peoples, and will give this land to your descendants after you as an everlasting possession.’ ");
INSERT INTO engmsb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","And now your two sons born to you in Egypt before I came to you here shall be reckoned as mine; Ephraim and Manasseh shall be mine, just as Reuben and Simeon are mine. ");
INSERT INTO engmsb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Any children born to you after them shall be yours, and they shall be called by the names of their brothers in the territory they inherit. ");
INSERT INTO engmsb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Now as for me, when I was returning from Paddan, to my sorrow Rachel died along the way in the land of Canaan, some distance from Ephrath. So I buried her there beside the road to Ephrath” (that is, Bethlehem). ");
INSERT INTO engmsb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","When Israel saw the sons of Joseph, he asked, “Who are these?” ");
INSERT INTO engmsb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph said to his father, “They are the sons God has given me in this place.” So Jacob said, “Please bring them to me, that I may bless them.” ");
INSERT INTO engmsb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Now Israel’s eyesight was poor because of old age; he could hardly see. Joseph brought his sons to him, and his father kissed them and embraced them. ");
INSERT INTO engmsb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","“I never expected to see your face again,” Israel said to Joseph, “but now God has let me see your children as well.” ");
INSERT INTO engmsb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Then Joseph removed his sons from his father’s knees and bowed facedown. ");
INSERT INTO engmsb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","And Joseph took both of them—with Ephraim in his right hand toward Israel’s left hand, and Manasseh in his left hand toward Israel’s right hand—and brought them close to him. ");
INSERT INTO engmsb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","But Israel stretched out his right hand and put it on the head of Ephraim, the younger; and crossing his hands, he put his left on Manasseh’s head, although Manasseh was the firstborn. ");
INSERT INTO engmsb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Then he blessed Joseph and said: “May the God before whom my fathers Abraham and Isaac walked, the God who has been my shepherd all my life to this day, ");
INSERT INTO engmsb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the angel who has redeemed me from all harm—may He bless these boys. And may they be called by my name and the names of my fathers Abraham and Isaac, and may they grow into a multitude upon the earth.” ");
INSERT INTO engmsb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","When Joseph saw that his father had placed his right hand on Ephraim’s head, he was displeased and took his father’s hand to move it from Ephraim’s head to Manasseh’s. ");
INSERT INTO engmsb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Not so, my father!” Joseph said. “This one is the firstborn; put your right hand on his head.” ");
INSERT INTO engmsb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father refused. “I know, my son, I know!” he said. “He too shall become a people, and he too shall be great; nevertheless, his younger brother shall be greater than he, and his offspring shall become a multitude of nations.” ");
INSERT INTO engmsb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So that day Jacob blessed them and said: “By you shall Israel pronounce this blessing: ‘May God make you like Ephraim and Manasseh.’” So he put Ephraim before Manasseh. ");
INSERT INTO engmsb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Israel said to Joseph, “Look, I am about to die, but God will be with you and bring you back to the land of your fathers. ");
INSERT INTO engmsb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","And to you, as one who is above your brothers, I give the ridge of land that I took from the Amorites with my sword and bow.” ");
INSERT INTO engmsb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Then Jacob called for his sons and said, “Gather around so that I can tell you what will happen to you in the days to come: ");
INSERT INTO engmsb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Come together and listen, O sons of Jacob; listen to your father Israel. ");
INSERT INTO engmsb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my firstborn, my might, and the beginning of my strength, excelling in honor, excelling in power. ");
INSERT INTO engmsb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Uncontrolled as the waters, you will no longer excel, because you went up to your father’s bed, onto my couch, and defiled it. ");
INSERT INTO engmsb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are brothers; their swords are weapons of violence. ");
INSERT INTO engmsb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","May I never enter their council; may I never join their assembly. For they kill men in their anger, and hamstring oxen on a whim. ");
INSERT INTO engmsb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Cursed be their anger, for it is strong, and their wrath, for it is cruel! I will disperse them in Jacob and scatter them in Israel. ");
INSERT INTO engmsb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, your brothers shall praise you. Your hand shall be on the necks of your enemies; your father’s sons shall bow down to you. ");
INSERT INTO engmsb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is a young lion—my son, you return from the prey. Like a lion he crouches and lies down; like a lioness, who dares to rouse him? ");
INSERT INTO engmsb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The scepter will not depart from Judah, nor the staff from between his feet, until Shiloh comes and the allegiance of the nations is his. ");
INSERT INTO engmsb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He ties his donkey to the vine, his colt to the choicest branch. He washes his garments in wine, his robes in the blood of grapes. ");
INSERT INTO engmsb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes are darker than wine, and his teeth are whiter than milk. ");
INSERT INTO engmsb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun shall dwell by the seashore and become a harbor for ships; his border shall extend to Sidon. ");
INSERT INTO engmsb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar is a strong donkey, lying down between the sheepfolds. ");
INSERT INTO engmsb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He saw that his resting place was good and that his land was pleasant, so he bent his shoulder to the burden and submitted to labor as a servant. ");
INSERT INTO engmsb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan shall provide justice for his people as one of the tribes of Israel. ");
INSERT INTO engmsb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","He will be a snake by the road, a viper in the path that bites the horse’s heels so that its rider tumbles backward. ");
INSERT INTO engmsb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I await Your salvation, O LORD. ");
INSERT INTO engmsb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad will be attacked by raiders, but he will attack their heels. ");
INSERT INTO engmsb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher’s food will be rich; he shall provide royal delicacies. ");
INSERT INTO engmsb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a doe set free that bears beautiful fawns. ");
INSERT INTO engmsb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a fruitful vine—a fruitful vine by a spring, whose branches scale the wall. ");
INSERT INTO engmsb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The archers attacked him with bitterness; they aimed at him in hostility. ");
INSERT INTO engmsb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yet he steadied his bow, and his strong arms were tempered by the hands of the Mighty One of Jacob, in the name of the Shepherd, the Rock of Israel, ");
INSERT INTO engmsb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","by the God of your father who helps you, and by the Almighty who blesses you, with blessings of the heavens above, with blessings of the depths below, with blessings of the breasts and womb. ");
INSERT INTO engmsb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings of your father have surpassed the blessings of the ancient mountains and the bounty of the everlasting hills. May they rest on the head of Joseph, on the brow of the prince of his brothers. ");
INSERT INTO engmsb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is a ravenous wolf; in the morning he devours the prey, in the evening he divides the plunder.” ");
INSERT INTO engmsb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are the tribes of Israel, twelve in all, and this was what their father said to them. He blessed them, and he blessed each one with a suitable blessing. ");
INSERT INTO engmsb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then Jacob instructed them, “I am about to be gathered to my people. Bury me with my fathers in the cave in the field of Ephron the Hittite. ");
INSERT INTO engmsb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","The cave is in the field of Machpelah near Mamre, in the land of Canaan. This is the field Abraham purchased from Ephron the Hittite as a burial site. ");
INSERT INTO engmsb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","There Abraham and his wife Sarah are buried, there Isaac and his wife Rebekah are buried, and there I buried Leah. ");
INSERT INTO engmsb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The field and the cave that is in it were purchased from the Hittites.” ");
INSERT INTO engmsb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob had finished instructing his sons, he pulled his feet into the bed and breathed his last, and he was gathered to his people. ");
INSERT INTO engmsb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Then Joseph fell upon his father’s face, wept over him, and kissed him. ");
INSERT INTO engmsb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","And Joseph directed the physicians in his service to embalm his father Israel. So they embalmed him, ");
INSERT INTO engmsb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","taking the forty days required to complete the embalming. And the Egyptians mourned for him seventy days. ");
INSERT INTO engmsb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","When the days of mourning had passed, Joseph said to Pharaoh’s court, “If I have found favor in your eyes, please tell Pharaoh that ");
INSERT INTO engmsb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","my father made me swear an oath when he said, ‘I am about to die. You must bury me in the tomb that I dug for myself in the land of Canaan.’ Now let me go and bury my father, and then return.” ");
INSERT INTO engmsb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh replied, “Go up and bury your father, as he made you swear to do.” ");
INSERT INTO engmsb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Then Joseph went to bury his father, and all the servants of Pharaoh accompanied him—the elders of Pharaoh’s household and all the elders of the land of Egypt— ");
INSERT INTO engmsb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","along with all of Joseph’s household, and his brothers, and his father’s household. Only their children and flocks and herds were left in Goshen. ");
INSERT INTO engmsb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Chariots and horsemen alike went up with him, and it was an exceedingly large procession. ");
INSERT INTO engmsb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","When they reached the threshing floor of Atad, which is across the Jordan, they lamented and wailed loudly, and Joseph mourned for his father seven days. ");
INSERT INTO engmsb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the Canaanites of the land saw the mourning at the threshing floor of Atad, they said, “This is a solemn ceremony of mourning by the Egyptians.” Thus the place across the Jordan is called Abel-mizraim. ");
INSERT INTO engmsb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","So Jacob’s sons did as he had charged them. ");
INSERT INTO engmsb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","They carried him to the land of Canaan and buried him in the cave at Machpelah in the field near Mamre, which Abraham had purchased from Ephron the Hittite as a burial site. ");
INSERT INTO engmsb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After Joseph had buried his father, he returned to Egypt with his brothers and all who had gone with him to bury his father. ");
INSERT INTO engmsb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","When Joseph’s brothers saw that their father was dead, they said, “What if Joseph bears a grudge? Then he will surely repay us for all the evil that we did to him.” ");
INSERT INTO engmsb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they sent word to Joseph, saying, “Before he died, your father commanded, ");
INSERT INTO engmsb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘This is what you are to say to Joseph: I beg you, please forgive the transgression and sin of your brothers, for they did you wrong.’ So now, Joseph, please forgive the transgression of the servants of the God of your father.” When their message came to him, Joseph wept. ");
INSERT INTO engmsb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","His brothers also came to him, bowed down before him, and said, “We are your slaves!” ");
INSERT INTO engmsb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","But Joseph replied, “Do not be afraid. Am I in the place of God? ");
INSERT INTO engmsb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","As for you, what you intended against me for evil, God intended for good, in order to accomplish a day like this—to preserve the lives of many people. ");
INSERT INTO engmsb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Therefore do not be afraid. I will provide for you and your little ones.” So Joseph reassured his brothers and spoke kindly to them. ");
INSERT INTO engmsb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Now Joseph and his father’s household remained in Egypt, and Joseph lived to the age of 110. ");
INSERT INTO engmsb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","He saw Ephraim’s sons to the third generation, and indeed the sons of Machir son of Manasseh were brought up on Joseph’s knees. ");
INSERT INTO engmsb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Then Joseph said to his brothers, “I am about to die, but God will surely visit you and bring you up from this land to the land He promised on oath to Abraham, Isaac, and Jacob.” ");
INSERT INTO engmsb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","And Joseph made the sons of Israel take an oath and said, “God will surely attend to you, and then you must carry my bones up from this place.” ");
INSERT INTO engmsb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","So Joseph died at the age of 110. And they embalmed his body and placed it in a coffin in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","These are the names of the sons of Israel who went to Egypt with Jacob, each with his family: ");
INSERT INTO engmsb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah; ");
INSERT INTO engmsb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin; ");
INSERT INTO engmsb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali; Gad and Asher. ");
INSERT INTO engmsb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","The descendants of Jacob numbered seventy in all, including Joseph, who was already in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Now Joseph and all his brothers and all that generation died, ");
INSERT INTO engmsb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","but the Israelites were fruitful and increased rapidly; they multiplied and became exceedingly numerous, so that the land was filled with them. ");
INSERT INTO engmsb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Then a new king, who did not know Joseph, came to power in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Look,” he said to his people, “the Israelites have become too numerous and too powerful for us. ");
INSERT INTO engmsb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Come, let us deal shrewdly with them, or they will increase even more; and if a war breaks out, they may join our enemies, fight against us, and leave the country.” ");
INSERT INTO engmsb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So the Egyptians appointed taskmasters over the Israelites to oppress them with forced labor. As a result, they built Pithom and Rameses as store cities for Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more they were oppressed, the more they multiplied and flourished; so the Egyptians came to dread the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","They worked the Israelites ruthlessly ");
INSERT INTO engmsb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","and made their lives bitter with hard labor in brick and mortar, and with all kinds of work in the fields. Every service they imposed was harsh. ");
INSERT INTO engmsb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Then the king of Egypt said to the Hebrew midwives, whose names were Shiphrah and Puah, ");
INSERT INTO engmsb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“When you help the Hebrew women give birth, observe them on the birthstools. If the child is a son, kill him; but if it is a daughter, let her live.” ");
INSERT INTO engmsb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","The midwives, however, feared God and did not do as the king of Egypt had instructed; they let the boys live. ");
INSERT INTO engmsb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","So the king of Egypt summoned the midwives and asked them, “Why have you done this? Why have you let the boys live?” ");
INSERT INTO engmsb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The midwives answered Pharaoh, “The Hebrew women are not like the Egyptian women, for they are vigorous and give birth before a midwife arrives.” ");
INSERT INTO engmsb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","So God was good to the midwives, and the people multiplied and became even more numerous. ");
INSERT INTO engmsb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","And because the midwives feared God, He gave them families of their own. ");
INSERT INTO engmsb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Then Pharaoh commanded all his people: “Every son born to the Hebrews you must throw into the Nile, but every daughter you may allow to live.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Now a man of the house of Levi married a Levite woman, ");
INSERT INTO engmsb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","and she conceived and gave birth to a son. When she saw that he was a beautiful child, she hid him for three months. ");
INSERT INTO engmsb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","But when she could no longer hide him, she got him a papyrus basket and coated it with tar and pitch. Then she placed the child in the basket and set it among the reeds along the bank of the Nile. ");
INSERT INTO engmsb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","And his sister stood at a distance to see what would happen to him. ");
INSERT INTO engmsb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Soon the daughter of Pharaoh went down to bathe in the Nile, and her attendants were walking along the riverbank. And when she saw the basket among the reeds, she sent her maidservant to retrieve it. ");
INSERT INTO engmsb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","When she opened it, she saw the child, and behold, the little boy was crying. So she had compassion on him and said, “This is one of the Hebrew children.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Then his sister said to Pharaoh’s daughter, “Shall I go and call one of the Hebrew women to nurse the child for you?” ");
INSERT INTO engmsb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Go ahead,” Pharaoh’s daughter told her. And the girl went and called the boy’s mother. ");
INSERT INTO engmsb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pharaoh’s daughter said to her, “Take this child and nurse him for me, and I will pay your wages.” So the woman took the boy and nursed him. ");
INSERT INTO engmsb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","When the child had grown older, she brought him to Pharaoh’s daughter, and he became her son. She named him Moses and explained, “I drew him out of the water.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","One day, after Moses had grown up, he went out to his own people and observed their hard labor. He saw an Egyptian beating a Hebrew, one of his own people. ");
INSERT INTO engmsb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","After looking this way and that and seeing no one, he struck down the Egyptian and hid his body in the sand. ");
INSERT INTO engmsb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","The next day Moses went out and saw two Hebrews fighting. He asked the one in the wrong, “Why are you attacking your companion?” ");
INSERT INTO engmsb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","But the man replied, “Who made you ruler and judge over us? Are you planning to kill me as you killed the Egyptian?” Then Moses was afraid and thought, “This thing I have done has surely become known.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","When Pharaoh heard about this matter, he sought to kill Moses. But Moses fled from Pharaoh and settled in the land of Midian, where he sat down beside a well. ");
INSERT INTO engmsb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Now the priest of Midian had seven daughters, and they came to draw water and fill the troughs to water their father’s flock. ");
INSERT INTO engmsb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","And when some shepherds came along and drove them away, Moses rose up to help them and watered their flock. ");
INSERT INTO engmsb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","When the daughters returned to their father Reuel, he asked them, “Why have you returned so early today?” ");
INSERT INTO engmsb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","“An Egyptian rescued us from the shepherds,” they replied. “He even drew water for us and watered the flock.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“So where is he?” their father asked. “Why did you leave the man behind? Invite him to have something to eat.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses agreed to stay with the man, and he gave his daughter Zipporah to Moses in marriage. ");
INSERT INTO engmsb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","And she gave birth to a son, and Moses named him Gershom, saying, “I have become a foreigner in a foreign land.” ");
INSERT INTO engmsb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","After a long time, the king of Egypt died. The Israelites groaned and cried out under their burden of slavery, and their cry for deliverance from bondage ascended to God. ");
INSERT INTO engmsb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","So God heard their groaning, and He remembered His covenant with Abraham, Isaac, and Jacob. ");
INSERT INTO engmsb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw the Israelites and took notice. ");
INSERT INTO engmsb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Meanwhile, Moses was shepherding the flock of his father-in-law Jethro, the priest of Midian. He led the flock to the far side of the wilderness and came to Horeb, the mountain of God. ");
INSERT INTO engmsb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","There the angel of the LORD appeared to him in a blazing fire from within a bush. Moses saw the bush ablaze with fire, but it was not consumed. ");
INSERT INTO engmsb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","So Moses thought, “I must go over and see this marvelous sight. Why is the bush not burning up?” ");
INSERT INTO engmsb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When the LORD saw that he had gone over to look, God called out to him from within the bush, “Moses, Moses!” “Here I am,” he answered. ");
INSERT INTO engmsb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Do not come any closer,” God said. “Take off your sandals, for the place where you are standing is holy ground.” ");
INSERT INTO engmsb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Then He said, “I am the God of your father, the God of Abraham, the God of Isaac, and the God of Jacob.” At this, Moses hid his face, for he was afraid to look at God. ");
INSERT INTO engmsb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","The LORD said, “I have indeed seen the affliction of My people in Egypt. I have heard them crying out because of their oppressors, and I am aware of their sufferings. ");
INSERT INTO engmsb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","I have come down to rescue them from the hand of the Egyptians and to bring them up out of that land to a good and spacious land, a land flowing with milk and honey—the home of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engmsb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","And now the cry of the Israelites has reached Me, and I have seen how severely the Egyptians are oppressing them. ");
INSERT INTO engmsb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Therefore, go! I am sending you to Pharaoh to bring My people the Israelites out of Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","But Moses asked God, “Who am I, that I should go to Pharaoh and bring the Israelites out of Egypt?” ");
INSERT INTO engmsb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","“I will surely be with you,” God said, “and this will be the sign to you that I have sent you: When you have brought the people out of Egypt, all of you will worship God on this mountain.” ");
INSERT INTO engmsb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Then Moses asked God, “Suppose I go to the Israelites and say to them, ‘The God of your fathers has sent me to you,’ and they ask me, ‘What is His name?’ What should I tell them?” ");
INSERT INTO engmsb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God said to Moses, “I AM WHO I AM. This is what you are to say to the Israelites: ‘I AM has sent me to you.’” ");
INSERT INTO engmsb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","God also told Moses, “Say to the Israelites, ‘The LORD, the God of your fathers—the God of Abraham, the God of Isaac, and the God of Jacob—has sent me to you.’ This is My name forever, and this is how I am to be remembered in every generation. ");
INSERT INTO engmsb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go, assemble the elders of Israel and say to them, ‘The LORD, the God of your fathers—the God of Abraham, Isaac, and Jacob—has appeared to me and said: I have surely attended to you and have seen what has been done to you in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","And I have promised to bring you up out of your affliction in Egypt, into the land of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites—a land flowing with milk and honey.’ ");
INSERT INTO engmsb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","The elders of Israel will listen to what you say, and you must go with them to the king of Egypt and tell him, ‘The LORD, the God of the Hebrews, has met with us. Now please let us take a three-day journey into the wilderness, so that we may sacrifice to the LORD our God.’ ");
INSERT INTO engmsb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But I know that the king of Egypt will not allow you to go unless a mighty hand compels him. ");
INSERT INTO engmsb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","So I will stretch out My hand and strike the Egyptians with all the wonders I will perform among them. And after that, he will release you. ");
INSERT INTO engmsb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","And I will grant this people such favor in the sight of the Egyptians that when you leave, you will not go away empty-handed. ");
INSERT INTO engmsb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Every woman shall ask her neighbor and any woman staying in her house for silver and gold jewelry and clothing, and you will put them on your sons and daughters. So you will plunder the Egyptians.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Then Moses answered, “What if they do not believe me or listen to my voice? For they may say, ‘The LORD has not appeared to you.’” ");
INSERT INTO engmsb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","And the LORD asked him, “What is that in your hand?” “A staff,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“Throw it on the ground,” said the LORD. So Moses threw it on the ground, and it became a snake, and he ran from it. ");
INSERT INTO engmsb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","“Stretch out your hand and grab it by the tail,” the LORD said to Moses, who reached out his hand and caught the snake, and it turned back into a staff in his hand. ");
INSERT INTO engmsb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“This is so that they may believe that the LORD, the God of their fathers—the God of Abraham, the God of Isaac, and the God of Jacob—has appeared to you.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Furthermore, the LORD said to Moses, “Put your hand inside your cloak.” So he put his hand inside his cloak, and when he took it out, his hand was leprous, white as snow. ");
INSERT INTO engmsb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Put your hand back inside your cloak,” said the LORD. So Moses put his hand back inside his cloak, and when he took it out, it was restored, like the rest of his skin. ");
INSERT INTO engmsb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","And the LORD said, “If they refuse to believe you or heed the witness of the first sign, they may believe that of the second. ");
INSERT INTO engmsb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","But if they do not believe even these two signs or listen to your voice, take some water from the Nile and pour it on the dry ground. Then the water you take from the Nile will become blood on the ground.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","“Please, Lord,” Moses replied, “I have never been eloquent, neither in the past nor since You have spoken to Your servant, for I am slow of speech and tongue.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","And the LORD said to him, “Who gave man his mouth? Or who makes the mute or the deaf, the sighted or the blind? Is it not I, the LORD? ");
INSERT INTO engmsb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Now go! I will help you as you speak, and I will teach you what to say.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","But Moses replied, “Please, Lord, send someone else.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Then the anger of the LORD burned against Moses, and He said, “Is not Aaron the Levite your brother? I know that he can speak well, and he is now on his way to meet you. When he sees you, he will be glad in his heart. ");
INSERT INTO engmsb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","You are to speak to him and put the words in his mouth. I will help both of you to speak, and I will teach you what to do. ");
INSERT INTO engmsb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","He will speak to the people for you. He will be your spokesman, and it will be as if you were God to him. ");
INSERT INTO engmsb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","But take this staff in your hand so you can perform signs with it.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Then Moses went back to his father-in-law Jethro and said to him, “Please let me return to my brothers in Egypt to see if they are still alive.” “Go in peace,” Jethro replied. ");
INSERT INTO engmsb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Now the LORD had said to Moses in Midian, “Go back to Egypt, for all the men who sought to kill you are dead.” ");
INSERT INTO engmsb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","So Moses took his wife and sons, put them on a donkey, and headed back to Egypt. And he took the staff of God in his hand. ");
INSERT INTO engmsb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","The LORD instructed Moses, “When you go back to Egypt, see that you perform before Pharaoh all the wonders that I have put within your power. But I will harden his heart so that he will not let the people go. ");
INSERT INTO engmsb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Then tell Pharaoh that this is what the LORD says: ‘Israel is My firstborn son, ");
INSERT INTO engmsb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","and I told you to let My son go so that he may worship Me. But since you have refused to let him go, behold, I will kill your firstborn son!’” ");
INSERT INTO engmsb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Now at a lodging place along the way, the LORD met Moses and was about to kill him. ");
INSERT INTO engmsb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","But Zipporah took a flint knife, cut off her son’s foreskin, and touched it to Moses’ feet. “Surely you are a bridegroom of blood to me,” she said. ");
INSERT INTO engmsb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","So the LORD let him alone. (When she said, “bridegroom of blood,” she was referring to the circumcision.) ");
INSERT INTO engmsb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Meanwhile, the LORD had said to Aaron, “Go and meet Moses in the wilderness.” So he went and met Moses at the mountain of God and kissed him. ");
INSERT INTO engmsb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","And Moses told Aaron everything the LORD had sent him to say, and all the signs He had commanded him to perform. ");
INSERT INTO engmsb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Then Moses and Aaron went and assembled all the elders of the Israelites, ");
INSERT INTO engmsb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","and Aaron relayed everything the LORD had said to Moses. And Moses performed the signs before the people, ");
INSERT INTO engmsb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","and they believed. And when they heard that the LORD had attended to the Israelites and had seen their affliction, they bowed down and worshiped. ");
INSERT INTO engmsb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","After that, Moses and Aaron went to Pharaoh and said, “This is what the LORD, the God of Israel, says: ‘Let My people go, so that they may hold a feast to Me in the wilderness.’” ");
INSERT INTO engmsb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","But Pharaoh replied, “Who is the LORD that I should obey His voice and let Israel go? I do not know the LORD, and I will not let Israel go.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","“The God of the Hebrews has met with us,” they answered. “Please let us go on a three-day journey into the wilderness to sacrifice to the LORD our God, or He may strike us with plagues or with the sword.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","But the king of Egypt said to them, “Moses and Aaron, why do you draw the people away from their work? Get back to your labor!” ");
INSERT INTO engmsb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaoh also said, “Look, the people of the land are now numerous, and you would be stopping them from their labor.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","That same day Pharaoh commanded the taskmasters of the people and their foremen: ");
INSERT INTO engmsb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“You shall no longer supply the people with straw for making bricks. They must go and gather their own straw. ");
INSERT INTO engmsb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But require of them the same quota of bricks as before; do not reduce it. For they are lazy; that is why they are crying out, ‘Let us go and sacrifice to our God.’ ");
INSERT INTO engmsb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Make the work harder on the men so they will be occupied and pay no attention to these lies.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the taskmasters and foremen of the people went out and said to them, “This is what Pharaoh says: ‘I am no longer giving you straw. ");
INSERT INTO engmsb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go and get your own straw wherever you can find it; but your workload will in no way be reduced.’” ");
INSERT INTO engmsb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people scattered all over the land of Egypt to gather stubble for straw. ");
INSERT INTO engmsb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The taskmasters kept pressing them, saying, “Fulfill your quota each day, just as you did when straw was provided.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Then the Israelite foremen, whom Pharaoh’s taskmasters had set over the people, were beaten and asked, “Why have you not fulfilled your quota of bricks yesterday or today, as you did before?” ");
INSERT INTO engmsb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","So the Israelite foremen went and appealed to Pharaoh: “Why are you treating your servants this way? ");
INSERT INTO engmsb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","No straw has been given to your servants, yet we are told, ‘Make bricks!’ Look, your servants are being beaten, but the fault is with your own people.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","“You are slackers!” Pharaoh replied. “Slackers! That is why you keep saying, ‘Let us go and sacrifice to the LORD.’ ");
INSERT INTO engmsb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Now get to work. You will be given no straw, yet you must deliver the full quota of bricks.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Israelite foremen realized they were in trouble when they were told, “You must not reduce your daily quota of bricks.” ");
INSERT INTO engmsb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","When they left Pharaoh, they confronted Moses and Aaron, who stood waiting to meet them. ");
INSERT INTO engmsb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","“May the LORD look upon you and judge you,” the foremen said, “for you have made us a stench before Pharaoh and his officials; you have placed in their hand a sword to kill us!” ");
INSERT INTO engmsb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","So Moses returned to the LORD and asked, “Lord, why have You brought trouble upon this people? Is this why You sent me? ");
INSERT INTO engmsb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ever since I went to Pharaoh to speak in Your name, he has brought trouble on this people, and You have not delivered Your people in any way.” ");
INSERT INTO engmsb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","But the LORD said to Moses, “Now you will see what I will do to Pharaoh, for because of My mighty hand he will let the people go; because of My strong hand he will drive them out of his land.” ");
INSERT INTO engmsb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God also told Moses, “I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I appeared to Abraham, to Isaac, and to Jacob as God Almighty, but by My name the LORD I did not make Myself known to them. ");
INSERT INTO engmsb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I also established My covenant with them to give them the land of Canaan, the land where they lived as foreigners. ");
INSERT INTO engmsb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Furthermore, I have heard the groaning of the Israelites, whom the Egyptians are enslaving, and I have remembered My covenant. ");
INSERT INTO engmsb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Therefore tell the Israelites: ‘I am the LORD, and I will bring you out from under the yoke of the Egyptians and deliver you from their bondage. I will redeem you with an outstretched arm and with mighty acts of judgment. ");
INSERT INTO engmsb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will take you as My own people, and I will be your God. Then you will know that I am the LORD your God, who brought you out from under the yoke of the Egyptians. ");
INSERT INTO engmsb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","And I will bring you into the land that I swore to give to Abraham, Isaac, and Jacob. I will give it to you as a possession. I am the LORD!’” ");
INSERT INTO engmsb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses relayed this message to the Israelites, but on account of their broken spirit and cruel bondage, they did not listen to him. ");
INSERT INTO engmsb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","So the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go and tell Pharaoh king of Egypt to let the Israelites go out of his land.” ");
INSERT INTO engmsb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","But in the LORD’s presence Moses replied, “If the Israelites will not listen to me, then why would Pharaoh listen to me, since I am unskilled in speech?” ");
INSERT INTO engmsb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Then the LORD spoke to Moses and Aaron and gave them a charge concerning both the Israelites and Pharaoh king of Egypt, to bring the Israelites out of the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These were the heads of their fathers’ houses: The sons of Reuben, the firstborn of Israel, were Hanoch and Pallu, Hezron and Carmi. These were the clans of Reuben. ");
INSERT INTO engmsb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon were Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul, the son of a Canaanite woman. These were the clans of Simeon. ");
INSERT INTO engmsb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","These were the names of the sons of Levi according to their records: Gershon, Kohath, and Merari. Levi lived 137 years. ");
INSERT INTO engmsb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon were Libni and Shimei, by their clans. ");
INSERT INTO engmsb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath were Amram, Izhar, Hebron, and Uzziel. Kohath lived 133 years. ");
INSERT INTO engmsb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari were Mahli and Mushi. These were the clans of the Levites according to their records. ");
INSERT INTO engmsb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","And Amram married his father’s sister Jochebed, and she bore him Aaron and Moses. Amram lived 137 years. ");
INSERT INTO engmsb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar were Korah, Nepheg, and Zichri. ");
INSERT INTO engmsb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel were Mishael, Elzaphan, and Sithri. ");
INSERT INTO engmsb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","And Aaron married Elisheba, the daughter of Amminadab and sister of Nahshon, and she bore him Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engmsb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah were Assir, Elkanah, and Abiasaph. These were the clans of the Korahites. ");
INSERT INTO engmsb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron’s son Eleazar married one of the daughters of Putiel, and she bore him Phinehas. These were the heads of the Levite families by their clans. ");
INSERT INTO engmsb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","It was this Aaron and Moses to whom the LORD said, “Bring the Israelites out of the land of Egypt by their divisions.” ");
INSERT INTO engmsb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moses and Aaron were the ones who spoke to Pharaoh king of Egypt in order to bring the Israelites out of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Now on the day that the LORD spoke to Moses in Egypt, ");
INSERT INTO engmsb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","He said to him, “I am the LORD; tell Pharaoh king of Egypt everything I say to you.” ");
INSERT INTO engmsb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But in the LORD’s presence Moses replied, “Since I am unskilled in speech, why would Pharaoh listen to me?” ");
INSERT INTO engmsb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","The LORD answered Moses, “See, I have made you like God to Pharaoh, and your brother Aaron will be your prophet. ");
INSERT INTO engmsb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You are to speak all that I command you, and your brother Aaron is to tell Pharaoh to let the Israelites go out of his land. ");
INSERT INTO engmsb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will harden Pharaoh’s heart, and though I will multiply My signs and wonders in the land of Egypt, ");
INSERT INTO engmsb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pharaoh will not listen to you. Then I will lay My hand on Egypt, and by mighty acts of judgment I will bring the divisions of My people the Israelites out of the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","And the Egyptians will know that I am the LORD, when I stretch out My hand against Egypt and bring the Israelites out from among them.” ");
INSERT INTO engmsb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","So Moses and Aaron did just as the LORD had commanded them. ");
INSERT INTO engmsb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was eighty years old and Aaron was eighty-three when they spoke to Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","The LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“When Pharaoh tells you, ‘Perform a miracle,’ you are to say to Aaron, ‘Take your staff and throw it down before Pharaoh,’ and it will become a serpent.” ");
INSERT INTO engmsb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","So Moses and Aaron went to Pharaoh and did just as the LORD had commanded. Aaron threw his staff down before Pharaoh and his officials, and it became a serpent. ");
INSERT INTO engmsb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","But Pharaoh called the wise men and sorcerers and magicians of Egypt, and they also did the same things by their magic arts. ");
INSERT INTO engmsb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Each one threw down his staff, and it became a serpent. But Aaron’s staff swallowed up the other staffs. ");
INSERT INTO engmsb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Still, Pharaoh’s heart was hardened, and he would not listen to them, just as the LORD had said. ");
INSERT INTO engmsb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Then the LORD said to Moses, “Pharaoh’s heart is unyielding; he refuses to let the people go. ");
INSERT INTO engmsb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go to Pharaoh in the morning as you see him walking out to the water. Wait on the bank of the Nile to meet him, and take in your hand the staff that was changed into a snake. ");
INSERT INTO engmsb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Then say to him, ‘The LORD, the God of the Hebrews, has sent me to tell you: Let My people go, so that they may worship Me in the wilderness. But until now you have not listened. ");
INSERT INTO engmsb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","This is what the LORD says: By this you will know that I am the LORD. Behold, with the staff in my hand I will strike the water of the Nile, and it will turn to blood. ");
INSERT INTO engmsb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","The fish in the Nile will die, the river will stink, and the Egyptians will be unable to drink its water.’” ");
INSERT INTO engmsb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","And the LORD said to Moses, “Tell Aaron, ‘Take your staff and stretch out your hand over the waters of Egypt—over their rivers and canals and ponds and all the reservoirs—that they may become blood.’ There will be blood throughout the land of Egypt, even in the vessels of wood and stone.” ");
INSERT INTO engmsb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses and Aaron did just as the LORD had commanded; in the presence of Pharaoh and his officials, Aaron raised the staff and struck the water of the Nile, and all the water was turned to blood. ");
INSERT INTO engmsb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","The fish in the Nile died, and the river smelled so bad that the Egyptians could not drink its water. And there was blood throughout the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","But the magicians of Egypt did the same things by their magic arts. So Pharaoh’s heart was hardened, and he would not listen to Moses and Aaron, just as the LORD had said. ");
INSERT INTO engmsb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Instead, Pharaoh turned around, went into his palace, and did not take any of this to heart. ");
INSERT INTO engmsb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","So all the Egyptians dug around the Nile for water to drink, because they could not drink the water from the river. ");
INSERT INTO engmsb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","And seven full days passed after the LORD had struck the Nile. ");
INSERT INTO engmsb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then the LORD said to Moses, “Go to Pharaoh and tell him that this is what the LORD says: ‘Let My people go, so that they may worship Me. ");
INSERT INTO engmsb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","But if you refuse to let them go, I will plague your whole country with frogs. ");
INSERT INTO engmsb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The Nile will teem with frogs, and they will come into your palace and up to your bedroom and onto your bed, into the houses of your officials and your people, and into your ovens and kneading bowls. ");
INSERT INTO engmsb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs will come up on you and your people and all your officials.’” ");
INSERT INTO engmsb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","And the LORD said to Moses, “Tell Aaron, ‘Stretch out your hand with your staff over the rivers and canals and ponds, and cause the frogs to come up onto the land of Egypt.’” ");
INSERT INTO engmsb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","So Aaron stretched out his hand over the waters of Egypt, and the frogs came up and covered the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","But the magicians did the same thing by their magic arts, and they also brought frogs up onto the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pharaoh summoned Moses and Aaron and said, “Pray to the LORD to take the frogs away from me and my people. Then I will let your people go, that they may sacrifice to the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses said to Pharaoh, “You may have the honor over me. When shall I pray for you and your officials and your people that the frogs (except for those in the Nile) may be taken away from you and your houses?” ");
INSERT INTO engmsb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“Tomorrow,” Pharaoh answered. “May it be as you say,” Moses replied, “so that you may know that there is no one like the LORD our God. ");
INSERT INTO engmsb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will depart from you and your houses and your officials and your people; they will remain only in the Nile.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","After Moses and Aaron had left Pharaoh, Moses cried out to the LORD for help with the frogs that He had brought against Pharaoh. ");
INSERT INTO engmsb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And the LORD did as Moses requested, and the frogs in the houses, the courtyards, and the fields died. ");
INSERT INTO engmsb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","They were piled into countless heaps, and there was a terrible stench in the land. ");
INSERT INTO engmsb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","When Pharaoh saw that there was relief, however, he hardened his heart and would not listen to Moses and Aaron, just as the LORD had said. ");
INSERT INTO engmsb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Then the LORD said to Moses, “Tell Aaron, ‘Stretch out your staff and strike the dust of the earth, that it may turn into swarms of gnats throughout the land of Egypt.’” ");
INSERT INTO engmsb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","This they did, and when Aaron stretched out his hand with his staff and struck the dust of the earth, gnats came upon man and beast. All the dust of the earth turned into gnats throughout the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The magicians tried to produce gnats using their magic arts, but they could not. And the gnats remained on man and beast. ");
INSERT INTO engmsb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","“This is the finger of God,” the magicians said to Pharaoh. But Pharaoh’s heart was hardened, and he would not listen to them, just as the LORD had said. ");
INSERT INTO engmsb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Then the LORD said to Moses, “Get up early in the morning, and when Pharaoh goes out to the water, stand before him and tell him that this is what the LORD says: ‘Let My people go, so that they may worship Me. ");
INSERT INTO engmsb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","But if you will not let My people go, I will send swarms of flies upon you and your officials and your people and your houses. The houses of the Egyptians and even the ground where they stand will be full of flies. ");
INSERT INTO engmsb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But on that day I will give special treatment to the land of Goshen, where My people live; no swarms of flies will be found there. In this way you will know that I, the LORD, am in the land. ");
INSERT INTO engmsb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will make a distinction between My people and your people. This sign will take place tomorrow.’” ");
INSERT INTO engmsb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","And the LORD did so. Thick swarms of flies poured into Pharaoh’s palace and into the houses of his officials. Throughout Egypt the land was ruined by swarms of flies. ");
INSERT INTO engmsb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Then Pharaoh summoned Moses and Aaron and said, “Go, sacrifice to your God within this land.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","But Moses replied, “It would not be right to do that, because the sacrifices we offer to the LORD our God would be detestable to the Egyptians. If we offer sacrifices that are detestable before the Egyptians, will they not stone us? ");
INSERT INTO engmsb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","We must make a three-day journey into the wilderness and sacrifice to the LORD our God as He commands us.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh answered, “I will let you go and sacrifice to the LORD your God in the wilderness, but you must not go very far. Now pray for me.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","“As soon as I leave you,” Moses said, “I will pray to the LORD, so that tomorrow the swarms of flies will depart from Pharaoh and his officials and his people. But Pharaoh must not act deceitfully again by refusing to let the people go and sacrifice to the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Then Moses left Pharaoh and prayed to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","and the LORD did as Moses requested. He removed the swarms of flies from Pharaoh and his officials and his people; not one fly remained. ");
INSERT INTO engmsb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But Pharaoh hardened his heart this time as well, and he would not let the people go. ");
INSERT INTO engmsb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then the LORD said to Moses, “Go to Pharaoh and tell him that this is what the LORD, the God of the Hebrews, says: ‘Let My people go, so that they may worship Me. ");
INSERT INTO engmsb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","But if you continue to restrain them and refuse to let them go, ");
INSERT INTO engmsb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","then the hand of the LORD will bring a severe plague on your livestock in the field—on your horses, donkeys, camels, herds, and flocks. ");
INSERT INTO engmsb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But the LORD will make a distinction between the livestock of Israel and the livestock of Egypt, so that no animal belonging to the Israelites will die.’” ");
INSERT INTO engmsb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","The LORD set a time, saying, “Tomorrow the LORD will do this in the land.” ");
INSERT INTO engmsb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","And the next day the LORD did just that. All the livestock of the Egyptians died, but not one animal belonging to the Israelites died. ");
INSERT INTO engmsb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh sent officials and found that none of the livestock of the Israelites had died. But Pharaoh’s heart was hardened, and he would not let the people go. ");
INSERT INTO engmsb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Then the LORD said to Moses and Aaron, “Take handfuls of soot from the furnace; in the sight of Pharaoh, Moses is to toss it into the air. ");
INSERT INTO engmsb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","It will become fine dust over all the land of Egypt, and festering boils will break out on man and beast throughout the land.” ");
INSERT INTO engmsb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So they took soot from the furnace and stood before Pharaoh. Moses tossed it into the air, and festering boils broke out on man and beast. ");
INSERT INTO engmsb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians could not stand before Moses, because the boils had broken out on them and on all the Egyptians. ");
INSERT INTO engmsb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","But the LORD hardened Pharaoh’s heart, and he would not listen to them, just as the LORD had said to Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Then the LORD said to Moses, “Get up early in the morning, stand before Pharaoh, and tell him that this is what the LORD, the God of the Hebrews, says: ‘Let My people go, so that they may worship Me. ");
INSERT INTO engmsb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Otherwise, I will send all My plagues against you and your officials and your people, so you may know that there is no one like Me in all the earth. ");
INSERT INTO engmsb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","For by this time I could have stretched out My hand and struck you and your people with a plague to wipe you off the earth. ");
INSERT INTO engmsb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But I have raised you up for this very purpose, that I might display My power to you, and that My name might be proclaimed in all the earth. ");
INSERT INTO engmsb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Still, you lord it over My people and do not allow them to go. ");
INSERT INTO engmsb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Behold, at this time tomorrow I will rain down the worst hail that has ever fallen on Egypt, from the day it was founded until now. ");
INSERT INTO engmsb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","So give orders now to shelter your livestock and everything you have in the field. Every man or beast that remains in the field and is not brought inside will die when the hail comes down upon them.’” ");
INSERT INTO engmsb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Those among Pharaoh’s officials who feared the word of the LORD hurried to bring their servants and livestock to shelter, ");
INSERT INTO engmsb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","but those who disregarded the word of the LORD left their servants and livestock in the field. ");
INSERT INTO engmsb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Then the LORD said to Moses, “Stretch out your hand toward heaven, so that hail may fall on all the land of Egypt—on man and beast and every plant of the field throughout the land of Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","So Moses stretched out his staff toward heaven, and the LORD sent thunder and hail, and lightning struck the earth. So the LORD rained down hail upon the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","The hail fell and the lightning continued flashing through it. The hail was so severe that nothing like it had ever been seen in all the land of Egypt from the time it became a nation. ");
INSERT INTO engmsb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Throughout the land of Egypt, the hail struck down everything in the field, both man and beast; it beat down every plant of the field and stripped every tree. ");
INSERT INTO engmsb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","The only place where it did not hail was in the land of Goshen, where the Israelites lived. ");
INSERT INTO engmsb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Then Pharaoh summoned Moses and Aaron. “This time I have sinned,” he said. “The LORD is righteous, and I and my people are wicked. ");
INSERT INTO engmsb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray to the LORD, for there has been enough of God’s thunder and hail. I will let you go; you do not need to stay any longer.” ");
INSERT INTO engmsb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses said to him, “When I have left the city, I will spread out my hands to the LORD. The thunder will cease, and there will be no more hail, so that you may know that the earth is the LORD’s. ");
INSERT INTO engmsb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But as for you and your officials, I know that you still do not fear the LORD our God.” ");
INSERT INTO engmsb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Now the flax and barley were destroyed, since the barley was ripe and the flax was in bloom; ");
INSERT INTO engmsb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","but the wheat and spelt were not destroyed, because they are late crops.) ");
INSERT INTO engmsb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Then Moses departed from Pharaoh, went out of the city, and spread out his hands to the LORD. The thunder and hail ceased, and the rain no longer poured down on the land. ");
INSERT INTO engmsb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain and hail and thunder had ceased, he sinned again and hardened his heart—he and his officials. ");
INSERT INTO engmsb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","So Pharaoh’s heart was hardened, and he would not let the Israelites go, just as the LORD had said through Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Then the LORD said to Moses, “Go to Pharaoh, for I have hardened his heart and the hearts of his officials, that I may perform these miraculous signs of Mine among them, ");
INSERT INTO engmsb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","and that you may tell your children and grandchildren how severely I dealt with the Egyptians when I performed miraculous signs among them, so that all of you may know that I am the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","So Moses and Aaron went to Pharaoh and told him, “This is what the LORD, the God of the Hebrews, says: ‘How long will you refuse to humble yourself before Me? Let My people go, so that they may worship Me. ");
INSERT INTO engmsb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","But if you refuse to let My people go, I will bring locusts into your territory tomorrow. ");
INSERT INTO engmsb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","They will cover the face of the land so that no one can see it. They will devour whatever is left after the hail and eat every tree that grows in your fields. ");
INSERT INTO engmsb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will fill your houses and the houses of all your officials and every Egyptian—something neither your fathers nor your grandfathers have seen since the day they came into this land.’” Then Moses turned and left Pharaoh’s presence. ");
INSERT INTO engmsb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh’s officials asked him, “How long will this man be a snare to us? Let the people go, so that they may worship the LORD their God. Do you not yet realize that Egypt lies in ruins?” ");
INSERT INTO engmsb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","So Moses and Aaron were brought back to Pharaoh. “Go, worship the LORD your God,” he said. “But who exactly will be going?” ");
INSERT INTO engmsb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“We will go with our young and old,” Moses replied. “We will go with our sons and daughters, and with our flocks and herds, for we must hold a feast to the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Then Pharaoh told them, “May the LORD be with you if I ever let you go with your little ones. Clearly you are bent on evil. ");
INSERT INTO engmsb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","No, only the men may go and worship the LORD, since that is what you have been requesting.” And Moses and Aaron were driven from Pharaoh’s presence. ");
INSERT INTO engmsb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Then the LORD said to Moses, “Stretch out your hand over the land of Egypt, so that the locusts may swarm over it and devour every plant in the land—everything that the hail has left behind.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","So Moses stretched out his staff over the land of Egypt, and throughout that day and night the LORD sent an east wind across the land. By morning the east wind had brought the locusts. ");
INSERT INTO engmsb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts swarmed across the land and settled over the entire territory of Egypt. Never before had there been so many locusts, and never again will there be. ");
INSERT INTO engmsb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the face of all the land until it was black, and they consumed all the plants on the ground and all the fruit on the trees that the hail had left behind. Nothing green was left on any tree or plant in all the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaoh quickly summoned Moses and Aaron and said, “I have sinned against the LORD your God and against you. ");
INSERT INTO engmsb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Now please forgive my sin once more and appeal to the LORD your God, that He may remove this death from me.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","So Moses left Pharaoh’s presence and appealed to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","And the LORD changed the wind to a very strong west wind that carried off the locusts and blew them into the Red Sea. Not a single locust remained anywhere in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the LORD hardened Pharaoh’s heart, and he would not let the Israelites go. ");
INSERT INTO engmsb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Then the LORD said to Moses, “Stretch out your hand toward heaven, so that darkness may spread over the land of Egypt—a palpable darkness.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","So Moses stretched out his hand toward heaven, and total darkness covered all the land of Egypt for three days. ");
INSERT INTO engmsb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","No one could see anyone else, and for three days no one left his place. Yet all the Israelites had light in their dwellings. ");
INSERT INTO engmsb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Then Pharaoh summoned Moses and said, “Go, worship the LORD. Even your little ones may go with you; only your flocks and herds must stay behind.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses replied, “You must also provide us with sacrifices and burnt offerings to present to the LORD our God. ");
INSERT INTO engmsb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Even our livestock must go with us; not a hoof will be left behind, for we will need some of them to worship the LORD our God, and we will not know how we are to worship the LORD until we arrive.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the LORD hardened Pharaoh’s heart, and he was unwilling to let them go. ");
INSERT INTO engmsb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","“Depart from me!” Pharaoh said to Moses. “Make sure you never see my face again, for on the day you see my face, you will die.” ");
INSERT INTO engmsb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“As you say,” Moses replied, “I will never see your face again.” ");
INSERT INTO engmsb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Then the LORD said to Moses, “I will bring upon Pharaoh and Egypt one more plague. After that, he will allow you to leave this place. And when he lets you go, he will drive you out completely. ");
INSERT INTO engmsb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Now announce to the people that men and women alike should ask their neighbors for articles of silver and gold.” ");
INSERT INTO engmsb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","And the LORD gave the people favor in the sight of the Egyptians. Moreover, Moses himself was highly regarded in Egypt by Pharaoh’s officials and by the people. ");
INSERT INTO engmsb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","So Moses declared, “This is what the LORD says: ‘About midnight I will go throughout Egypt, ");
INSERT INTO engmsb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and every firstborn son in the land of Egypt will die, from the firstborn of Pharaoh who sits on his throne, to the firstborn of the servant girl behind the hand mill, as well as the firstborn of all the cattle. ");
INSERT INTO engmsb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Then a great cry will go out over all the land of Egypt. Such an outcry has never been heard before and will never be heard again. ");
INSERT INTO engmsb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But among all the Israelites, not even a dog will snarl at man or beast.’ Then you will know that the LORD makes a distinction between Egypt and Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","And all these officials of yours will come and bow before me, saying, ‘Go, you and all the people who follow you!’ After that, I will depart.” And hot with anger, Moses left Pharaoh’s presence. ");
INSERT INTO engmsb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","The LORD said to Moses, “Pharaoh will not listen to you, so that My wonders may be multiplied in the land of Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses and Aaron did all these wonders before Pharaoh, but the LORD hardened Pharaoh’s heart so that he would not let the Israelites go out of his land. ");
INSERT INTO engmsb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Now the LORD said to Moses and Aaron in the land of Egypt, ");
INSERT INTO engmsb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“This month is the beginning of months for you; it shall be the first month of your year. ");
INSERT INTO engmsb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tell the whole congregation of Israel that on the tenth day of this month each man must select a lamb for his family, one per household. ");
INSERT INTO engmsb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","If the household is too small for a whole lamb, they are to share with the nearest neighbor based on the number of people, and apportion the lamb accordingly. ");
INSERT INTO engmsb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your lamb must be an unblemished year-old male, and you may take it from the sheep or the goats. ");
INSERT INTO engmsb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You must keep it until the fourteenth day of the month, when the whole assembly of the congregation of Israel will slaughter the animals at twilight. ");
INSERT INTO engmsb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","They are to take some of the blood and put it on the sides and tops of the doorframes of the houses where they eat the lambs. ");
INSERT INTO engmsb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","They are to eat the meat that night, roasted over the fire, along with unleavened bread and bitter herbs. ");
INSERT INTO engmsb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Do not eat any of the meat raw or cooked in boiling water, but only roasted over the fire—its head and legs and inner parts. ");
INSERT INTO engmsb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Do not leave any of it until morning; before the morning you must burn up any part that is left over. ");
INSERT INTO engmsb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","This is how you are to eat it: You must be fully dressed for travel, with your sandals on your feet and your staff in your hand. You are to eat in haste; it is the LORD’s Passover. ");
INSERT INTO engmsb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","On that night I will pass through the land of Egypt and strike down every firstborn male, both man and beast, and I will execute judgment against all the gods of Egypt. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood on the houses where you are staying will be a sign; when I see the blood, I will pass over you. No plague will fall on you to destroy you when I strike the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","And this day will be a memorial for you, and you are to celebrate it as a feast to the LORD, as a permanent statute for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For seven days you must eat unleavened bread. On the first day you are to remove the leaven from your houses. Whoever eats anything leavened from the first day through the seventh must be cut off from Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","On the first day you are to hold a sacred assembly, and another on the seventh day. You must not do any work on those days, except to prepare the meals—that is all you may do. ");
INSERT INTO engmsb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","So you are to keep the Feast of Unleavened Bread, for on this very day I brought your divisions out of the land of Egypt. You must keep this day as a permanent statute for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month you are to eat unleavened bread, from the evening of the fourteenth day until the evening of the twenty-first day. ");
INSERT INTO engmsb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","For seven days there must be no leaven found in your houses. If anyone eats something leavened, that person, whether a foreigner or native of the land, must be cut off from the congregation of Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You are not to eat anything leavened; eat unleavened bread in all your homes.” ");
INSERT INTO engmsb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses summoned all the elders of Israel and told them, “Go at once and select for yourselves a lamb for each family, and slaughter the Passover lamb. ");
INSERT INTO engmsb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Take a cluster of hyssop, dip it into the blood in the basin, and brush the blood on the top and sides of the doorframe. None of you shall go out the door of his house until morning. ");
INSERT INTO engmsb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","When the LORD passes through to strike down the Egyptians, He will see the blood on the top and sides of the doorframe and will pass over that doorway; so He will not allow the destroyer to enter your houses and strike you down. ");
INSERT INTO engmsb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","And you are to keep this command as a permanent statute for you and your descendants. ");
INSERT INTO engmsb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","When you enter the land that the LORD will give you as He promised, you are to keep this service. ");
INSERT INTO engmsb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children ask you, ‘What does this service mean to you?’ ");
INSERT INTO engmsb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","you are to reply, ‘It is the Passover sacrifice to the LORD, who passed over the houses of the Israelites in Egypt when He struck down the Egyptians and spared our homes.’” Then the people bowed down and worshiped. ");
INSERT INTO engmsb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","And the Israelites went and did just what the LORD had commanded Moses and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Now at midnight the LORD struck down every firstborn male in the land of Egypt, from the firstborn of Pharaoh, who sat on his throne, to the firstborn of the prisoner in the dungeon, as well as all the firstborn among the livestock. ");
INSERT INTO engmsb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","During the night Pharaoh got up—he and all his officials and all the Egyptians—and there was loud wailing in Egypt; for there was no house without someone dead. ");
INSERT INTO engmsb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Then Pharaoh summoned Moses and Aaron by night and said, “Get up, leave my people, both you and the Israelites! Go, worship the LORD as you have requested. ");
INSERT INTO engmsb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take your flocks and herds as well, just as you have said, and depart! And bless me also.” ");
INSERT INTO engmsb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","And in order to send them out of the land quickly, the Egyptians urged the people on. “For otherwise,” they said, “we are all going to die!” ");
INSERT INTO engmsb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","So the people took their dough before it was leavened, carrying it on their shoulders in kneading bowls wrapped in clothing. ");
INSERT INTO engmsb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Furthermore, the Israelites acted on Moses’ word and asked the Egyptians for articles of silver and gold, and for clothing. ");
INSERT INTO engmsb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","And the LORD gave the people such favor in the sight of the Egyptians that they granted their request. In this way they plundered the Egyptians. ");
INSERT INTO engmsb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israelites journeyed from Rameses to Succoth with about 600,000 men on foot, besides women and children. ");
INSERT INTO engmsb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","And a mixed multitude also went up with them, along with great droves of livestock, both flocks and herds. ");
INSERT INTO engmsb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Since their dough had no leaven, the people baked what they had brought out of Egypt into unleavened loaves. For when they had been driven out of Egypt, they could not delay and had not prepared any provisions for themselves. ");
INSERT INTO engmsb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Now the duration of the Israelites’ stay in Egypt was 430 years. ");
INSERT INTO engmsb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","At the end of the 430 years, to the very day, all the LORD’s divisions went out of the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Because the LORD kept a vigil that night to bring them out of the land of Egypt, this same night is to be a vigil to the LORD, to be observed by all the Israelites for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","And the LORD said to Moses and Aaron, “This is the statute of the Passover: No foreigner is to eat of it. ");
INSERT INTO engmsb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But any slave who has been purchased may eat of it, after you have circumcised him. ");
INSERT INTO engmsb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","A temporary resident or hired hand shall not eat the Passover. ");
INSERT INTO engmsb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","It must be eaten inside one house. You are not to take any of the meat outside the house, and you may not break any of the bones. ");
INSERT INTO engmsb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","The whole congregation of Israel must celebrate it. ");
INSERT INTO engmsb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","If a foreigner resides with you and wants to celebrate the LORD’s Passover, all the males in the household must be circumcised; then he may come near to celebrate it, and he shall be like a native of the land. But no uncircumcised man may eat of it. ");
INSERT INTO engmsb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","The same law shall apply to both the native and the foreigner who resides among you.” ");
INSERT INTO engmsb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Then all the Israelites did this—they did just as the LORD had commanded Moses and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","And on that very day the LORD brought the Israelites out of the land of Egypt by their divisions. ");
INSERT INTO engmsb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Consecrate to Me every firstborn male. The firstborn from every womb among the Israelites belongs to Me, both of man and beast.” ");
INSERT INTO engmsb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","So Moses told the people, “Remember this day, the day you came out of Egypt, out of the house of slavery; for the LORD brought you out of it by the strength of His hand. And nothing leavened shall be eaten. ");
INSERT INTO engmsb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Today, in the month of Abib, you are leaving. ");
INSERT INTO engmsb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","And when the LORD brings you into the land of the Canaanites, Hittites, Amorites, Hivites, and Jebusites—the land He swore to your fathers that He would give you, a land flowing with milk and honey—you shall keep this service in this month. ");
INSERT INTO engmsb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days you are to eat unleavened bread, and on the seventh day there shall be a feast to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Unleavened bread shall be eaten during those seven days. Nothing leavened may be found among you, nor shall leaven be found anywhere within your borders. ");
INSERT INTO engmsb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","And on that day you are to explain to your son, ‘This is because of what the LORD did for me when I came out of Egypt.’ ");
INSERT INTO engmsb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","It shall be a sign for you on your hand and a reminder on your forehead that the Law of the LORD is to be on your lips. For with a mighty hand the LORD brought you out of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Therefore you shall keep this statute at the appointed time year after year. ");
INSERT INTO engmsb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","And after the LORD brings you into the land of the Canaanites and gives it to you, as He swore to you and your fathers, ");
INSERT INTO engmsb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","you are to present to the LORD the firstborn male of every womb. All the firstborn males of your livestock belong to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","You must redeem every firstborn donkey with a lamb, and if you do not redeem it, you are to break its neck. And every firstborn of your sons you must redeem. ");
INSERT INTO engmsb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","In the future, when your son asks you, ‘What does this mean?’ you are to tell him, ‘With a mighty hand the LORD brought us out of Egypt, out of the house of slavery. ");
INSERT INTO engmsb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","And when Pharaoh stubbornly refused to let us go, the LORD killed every firstborn in the land of Egypt, both of man and beast. This is why I sacrifice to the LORD the firstborn male of every womb, but I redeem all the firstborn of my sons.’ ");
INSERT INTO engmsb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","So it shall serve as a sign on your hand and a symbol on your forehead, for with a mighty hand the LORD brought us out of Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When Pharaoh let the people go, God did not lead them along the road through the land of the Philistines, though it was shorter. For God said, “If the people face war, they might change their minds and return to Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So God led the people around by the way of the wilderness toward the Red Sea. And the Israelites left the land of Egypt arrayed for battle. ");
INSERT INTO engmsb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses took the bones of Joseph with him because Joseph had made the sons of Israel swear a solemn oath when he said, “God will surely attend to you, and then you must carry my bones with you from this place.” ");
INSERT INTO engmsb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","They set out from Succoth and camped at Etham on the edge of the wilderness. ");
INSERT INTO engmsb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","And the LORD went before them in a pillar of cloud to guide their way by day, and in a pillar of fire to give them light by night, so that they could travel by day or night. ");
INSERT INTO engmsb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Neither the pillar of cloud by day nor the pillar of fire by night left its place before the people. ");
INSERT INTO engmsb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tell the Israelites to turn back and encamp before Pi-hahiroth, between Migdol and the sea. You are to encamp by the sea, directly opposite Baal-zephon. ");
INSERT INTO engmsb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","For Pharaoh will say of the Israelites, ‘They are wandering the land in confusion; the wilderness has boxed them in.’ ");
INSERT INTO engmsb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","And I will harden Pharaoh’s heart so that he will pursue them. But I will gain honor by means of Pharaoh and all his army, and the Egyptians will know that I am the LORD.” So this is what the Israelites did. ");
INSERT INTO engmsb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","When the king of Egypt was told that the people had fled, Pharaoh and his officials changed their minds about them and said, “What have we done? We have released Israel from serving us.” ");
INSERT INTO engmsb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","So Pharaoh prepared his chariot and took his army with him. ");
INSERT INTO engmsb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took 600 of the best chariots, and all the other chariots of Egypt, with officers over all of them. ");
INSERT INTO engmsb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","And the LORD hardened the heart of Pharaoh king of Egypt so that he pursued the Israelites, who were marching out defiantly. ");
INSERT INTO engmsb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","The Egyptians—all Pharaoh’s horses and chariots, horsemen and troops—pursued the Israelites and overtook them as they camped by the sea near Pi-hahiroth, opposite Baal-zephon. ");
INSERT INTO engmsb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","As Pharaoh approached, the Israelites looked up and saw the Egyptians marching after them, and they were terrified and cried out to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","They said to Moses, “Was it because there were no graves in Egypt that you brought us into the wilderness to die? What have you done to us by bringing us out of Egypt? ");
INSERT INTO engmsb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Did we not say to you in Egypt, ‘Leave us alone so that we may serve the Egyptians’? For it would have been better for us to serve the Egyptians than to die in the wilderness.” ");
INSERT INTO engmsb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","But Moses told the people, “Do not be afraid. Stand firm and you will see the LORD’s salvation, which He will accomplish for you today; for the Egyptians you see today, you will never see again. ");
INSERT INTO engmsb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The LORD will fight for you; you need only to be still.” ");
INSERT INTO engmsb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Then the LORD said to Moses, “Why are you crying out to Me? Tell the Israelites to go forward. ");
INSERT INTO engmsb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","And as for you, lift up your staff and stretch out your hand over the sea and divide it, so that the Israelites can go through the sea on dry ground. ");
INSERT INTO engmsb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","And I will harden the hearts of the Egyptians so that they will go in after them. Then I will gain honor by means of Pharaoh and all his army and chariots and horsemen. ");
INSERT INTO engmsb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","The Egyptians will know that I am the LORD when I am honored through Pharaoh, his chariots, and his horsemen.” ");
INSERT INTO engmsb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","And the angel of God, who had gone before the camp of Israel, withdrew and went behind them. The pillar of cloud also moved from before them and stood behind them, ");
INSERT INTO engmsb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","so that it came between the camps of Egypt and Israel. The cloud was there in the darkness, but it lit up the night. So all night long neither camp went near the other. ");
INSERT INTO engmsb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Then Moses stretched out his hand over the sea, and all that night the LORD drove back the sea with a strong east wind that turned it into dry land. So the waters were divided, ");
INSERT INTO engmsb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","and the Israelites went through the sea on dry ground, with walls of water on their right and on their left. ");
INSERT INTO engmsb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","And the Egyptians chased after them—all Pharaoh’s horses, chariots, and horsemen—and followed them into the sea. ");
INSERT INTO engmsb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","At morning watch, however, the LORD looked down on the army of the Egyptians from the pillar of fire and cloud, and He threw their camp into confusion. ");
INSERT INTO engmsb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","He caused their chariot wheels to wobble, so that they had difficulty driving. “Let us flee from the Israelites,” said the Egyptians, “for the LORD is fighting for them against Egypt!” ");
INSERT INTO engmsb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Then the LORD said to Moses, “Stretch out your hand over the sea, so that the waters may flow back over the Egyptians and their chariots and horsemen.” ");
INSERT INTO engmsb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So Moses stretched out his hand over the sea, and at daybreak the sea returned to its normal state. As the Egyptians were retreating, the LORD swept them into the sea. ");
INSERT INTO engmsb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The waters flowed back and covered the chariots and horsemen—the entire army of Pharaoh that had chased the Israelites into the sea. Not one of them survived. ");
INSERT INTO engmsb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the Israelites had walked through the sea on dry ground, with walls of water on their right and on their left. ");
INSERT INTO engmsb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","That day the LORD saved Israel from the hand of the Egyptians, and Israel saw the Egyptians dead on the shore. ");
INSERT INTO engmsb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","When Israel saw the great power that the LORD had exercised over the Egyptians, the people feared the LORD and believed in Him and in His servant Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the Israelites sang this song to the LORD: “I will sing to the LORD, for He is highly exalted. The horse and rider He has thrown into the sea. ");
INSERT INTO engmsb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The LORD is my strength and my song, and He has become my salvation. He is my God, and I will praise Him, my father’s God, and I will exalt Him. ");
INSERT INTO engmsb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The LORD is a warrior, the LORD is His name. ");
INSERT INTO engmsb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pharaoh’s chariots and army He has cast into the sea; the finest of his officers are drowned in the Red Sea. ");
INSERT INTO engmsb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The depths have covered them; they sank there like a stone. ");
INSERT INTO engmsb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Your right hand, O LORD, is majestic in power; Your right hand, O LORD, has shattered the enemy. ");
INSERT INTO engmsb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","You overthrew Your adversaries by Your great majesty. You unleashed Your burning wrath; it consumed them like stubble. ");
INSERT INTO engmsb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","At the blast of Your nostrils the waters piled up; like a wall the currents stood firm; the depths congealed in the heart of the sea. ");
INSERT INTO engmsb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy declared, ‘I will pursue, I will overtake. I will divide the spoils; I will gorge myself on them. I will draw my sword; my hand will destroy them.’ ");
INSERT INTO engmsb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But You blew with Your breath, and the sea covered them. They sank like lead in the mighty waters. ");
INSERT INTO engmsb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who among the gods is like You, O LORD? Who is like You—majestic in holiness, revered with praises, performing wonders? ");
INSERT INTO engmsb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You stretched out Your right hand, and the earth swallowed them up. ");
INSERT INTO engmsb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","With loving devotion You will lead the people You have redeemed; with Your strength You will guide them to Your holy dwelling. ");
INSERT INTO engmsb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The nations will hear and tremble; anguish will grip the dwellers of Philistia. ");
INSERT INTO engmsb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Then the chiefs of Edom will be dismayed; trembling will seize the leaders of Moab; those who dwell in Canaan will melt away, ");
INSERT INTO engmsb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","and terror and dread will fall on them. By the power of Your arm they will be as still as a stone until Your people pass by, O LORD, until the people You have bought pass by. ");
INSERT INTO engmsb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will bring them in and plant them on the mountain of Your inheritance—the place, O LORD, You have prepared for Your dwelling, the sanctuary, O Lord, Your hands have established. ");
INSERT INTO engmsb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The LORD will reign forever and ever!” ");
INSERT INTO engmsb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","For when Pharaoh’s horses, chariots, and horsemen went into the sea, the LORD brought the waters of the sea back over them. But the Israelites walked through the sea on dry ground. ");
INSERT INTO engmsb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Then Miriam the prophetess, Aaron’s sister, took a tambourine in her hand, and all the women followed her with tambourines and dancing. ");
INSERT INTO engmsb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","And Miriam sang back to them: “Sing to the LORD, for He is highly exalted; the horse and rider He has thrown into the sea.” ");
INSERT INTO engmsb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses led Israel from the Red Sea, and they went out into the Desert of Shur. For three days they walked in the desert without finding water. ");
INSERT INTO engmsb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","And when they came to Marah, they could not drink the water there because it was bitter. (That is why it was named Marah.) ");
INSERT INTO engmsb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","So the people grumbled against Moses, saying, “What are we to drink?” ");
INSERT INTO engmsb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","And Moses cried out to the LORD, and the LORD showed him a log. And when he cast it into the waters, they were sweetened. There the LORD made for them a statute and an ordinance, and there He tested them, ");
INSERT INTO engmsb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","saying, “If you will listen carefully to the voice of the LORD your God, and do what is right in His eyes, and pay attention to His commands, and keep all His statutes, then I will not bring on you any of the diseases I inflicted on the Egyptians. For I am the LORD who heals you.” ");
INSERT INTO engmsb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Then they came to Elim, where there were twelve springs of water and seventy palm trees, and they camped there by the waters. ");
INSERT INTO engmsb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","On the fifteenth day of the second month after they had left the land of Egypt, the whole congregation of Israel set out from Elim and came to the Desert of Sin, which is between Elim and Sinai. ");
INSERT INTO engmsb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","And there in the desert the whole congregation of Israel grumbled against Moses and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“If only we had died by the LORD’s hand in the land of Egypt!” they said. “There we sat by pots of meat and ate our fill of bread, but you have brought us into this desert to starve this whole assembly to death!” ");
INSERT INTO engmsb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then the LORD said to Moses, “Behold, I will rain down bread from heaven for you. Each day the people are to go out and gather enough for that day. In this way I will test whether or not they will follow My instructions. ");
INSERT INTO engmsb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Then on the sixth day, when they prepare what they bring in, it will be twice as much as they gather on the other days.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","So Moses and Aaron said to all the Israelites, “This evening you will know that it was the LORD who brought you out of the land of Egypt, ");
INSERT INTO engmsb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","and in the morning you will see the LORD’s glory, because He has heard your grumbling against Him. For who are we, that you should grumble against us?” ");
INSERT INTO engmsb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","And Moses added, “The LORD will give you meat to eat this evening and bread to fill you in the morning, for He has heard your grumbling against Him. Who are we? Your grumblings are not against us but against the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Then Moses said to Aaron, “Tell the whole congregation of Israel, ‘Come before the LORD, for He has heard your grumbling.’” ");
INSERT INTO engmsb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","And as Aaron was speaking to the whole congregation of Israel, they looked toward the desert, and there in a cloud the glory of the LORD appeared. ");
INSERT INTO engmsb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the grumbling of the Israelites. Tell them, ‘At twilight you will eat meat, and in the morning you will be filled with bread. Then you will know that I am the LORD your God.’” ");
INSERT INTO engmsb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","That evening quail came and covered the camp, and in the morning there was a layer of dew around the camp. ");
INSERT INTO engmsb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","When the layer of dew had evaporated, there were thin flakes on the desert floor, as fine as frost on the ground. ");
INSERT INTO engmsb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the Israelites saw it, they asked one another, “What is it?” For they did not know what it was. So Moses told them, “It is the bread that the LORD has given you to eat. ");
INSERT INTO engmsb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is what the LORD has commanded: ‘Each one is to gather as much as he needs. You may take an omer for each person in your tent.’” ");
INSERT INTO engmsb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","So the Israelites did this. Some gathered more, and some less. ");
INSERT INTO engmsb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","When they measured it by the omer, he who gathered much had no excess, and he who gathered little had no shortfall. Each one gathered as much as he needed to eat. ");
INSERT INTO engmsb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Then Moses said to them, “No one may keep any of it until morning.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But they did not listen to Moses; some people left part of it until morning, and it became infested with maggots and began to smell. So Moses was angry with them. ");
INSERT INTO engmsb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Every morning each one gathered as much as was needed, and when the sun grew hot, it melted away. ");
INSERT INTO engmsb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","On the sixth day, they gathered twice as much food—two omers per person—and all the leaders of the congregation came and reported this to Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","He told them, “This is what the LORD has said: ‘Tomorrow is to be a day of complete rest, a holy Sabbath to the LORD. So bake what you want to bake, and boil what you want to boil. Then set aside whatever remains and keep it until morning.’” ");
INSERT INTO engmsb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So they set it aside until morning as Moses had commanded, and it did not smell or contain any maggots. ");
INSERT INTO engmsb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","“Eat it today,” Moses said, “because today is a Sabbath to the LORD. Today you will not find anything in the field. ");
INSERT INTO engmsb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","For six days you may gather, but on the seventh day, the Sabbath, it will not be there.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yet on the seventh day some of the people went out to gather, but they did not find anything. ");
INSERT INTO engmsb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Then the LORD said to Moses, “How long will you refuse to keep My commandments and instructions? ");
INSERT INTO engmsb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Understand that the LORD has given you the Sabbath; that is why on the sixth day He will give you bread for two days. On the seventh day, everyone must stay where he is; no one may leave his place.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the seventh day. ");
INSERT INTO engmsb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Now the house of Israel called the bread manna. It was white like coriander seed and tasted like wafers made with honey. ");
INSERT INTO engmsb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses said, “This is what the LORD has commanded: ‘Keep an omer of manna for the generations to come, so that they may see the bread I fed you in the wilderness when I brought you out of the land of Egypt.’” ");
INSERT INTO engmsb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","So Moses told Aaron, “Take a jar and fill it with an omer of manna. Then place it before the LORD to be preserved for the generations to come.” ");
INSERT INTO engmsb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","And Aaron placed it in front of the Testimony, to be preserved just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The Israelites ate manna forty years, until they came to a land where they could settle; they ate manna until they reached the border of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Now an omer is a tenth of an ephah.) ");
INSERT INTO engmsb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Then the whole congregation of Israel left the Desert of Sin, moving from place to place as the LORD commanded. They camped at Rephidim, but there was no water for the people to drink. ");
INSERT INTO engmsb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So the people contended with Moses, “Give us water to drink.” “Why do you contend with me?” Moses replied. “Why do you test the LORD?” ");
INSERT INTO engmsb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people thirsted for water there, and they grumbled against Moses: “Why have you brought us out of Egypt—to make us and our children and livestock die of thirst?” ");
INSERT INTO engmsb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Then Moses cried out to the LORD, “What should I do with these people? A little more and they will stone me!” ");
INSERT INTO engmsb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","And the LORD said to Moses, “Walk on ahead of the people and take some of the elders of Israel with you. Take along in your hand the staff with which you struck the Nile, and go. ");
INSERT INTO engmsb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Behold, I will stand there before you by the rock at Horeb. And when you strike the rock, water will come out of it for the people to drink.” So Moses did this in the sight of the elders of Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","He named the place Massah and Meribah because the Israelites quarreled, and because they tested the LORD, saying, “Is the LORD among us or not?” ");
INSERT INTO engmsb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","After this, the Amalekites came and attacked the Israelites at Rephidim. ");
INSERT INTO engmsb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","So Moses said to Joshua, “Choose some of our men and go out to fight the Amalekites. Tomorrow I will stand on the hilltop with the staff of God in my hand.” ");
INSERT INTO engmsb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua did as Moses had instructed him and fought against the Amalekites, while Moses, Aaron, and Hur went up to the top of the hill. ");
INSERT INTO engmsb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","As long as Moses held up his hands, Israel prevailed; but when he lowered them, Amalek prevailed. ");
INSERT INTO engmsb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","When Moses’ hands grew heavy, they took a stone and put it under him, and he sat on it. Then Aaron and Hur held his hands up, one on each side, so that his hands remained steady until the sun went down. ");
INSERT INTO engmsb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","So Joshua overwhelmed Amalek and his army with the sword. ");
INSERT INTO engmsb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Then the LORD said to Moses, “Write this on a scroll as a reminder and recite it to Joshua, because I will utterly blot out the memory of Amalek from under heaven.” ");
INSERT INTO engmsb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","And Moses built an altar and named it The LORD Is My Banner. ");
INSERT INTO engmsb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“Indeed,” he said, “a hand was lifted up toward the throne of the LORD. The LORD will war against Amalek from generation to generation.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Now Moses’ father-in-law Jethro, the priest of Midian, heard about all that God had done for Moses and His people Israel, and how the LORD had brought Israel out of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","After Moses had sent back his wife Zipporah, his father-in-law Jethro had received her, ");
INSERT INTO engmsb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","along with her two sons. One son was named Gershom, for Moses had said, “I have been a foreigner in a foreign land.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","The other son was named Eliezer, for Moses had said, “The God of my father was my helper and delivered me from the sword of Pharaoh.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moses’ father-in-law Jethro, along with Moses’ wife and sons, came to him in the desert, where he was encamped at the mountain of God. ");
INSERT INTO engmsb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","He sent word to Moses, “I, your father-in-law Jethro, am coming to you with your wife and her two sons.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","So Moses went out to meet his father-in-law and bowed down and kissed him. They greeted each other and went into the tent. ");
INSERT INTO engmsb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Then Moses recounted to his father-in-law all that the LORD had done to Pharaoh and the Egyptians for Israel’s sake, all the hardships they had encountered along the way, and how the LORD had delivered them. ");
INSERT INTO engmsb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","And Jethro rejoiced over all the good things the LORD had done for Israel, whom He had rescued from the hand of the Egyptians. ");
INSERT INTO engmsb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro declared, “Blessed be the LORD, who has delivered you from the hand of the Egyptians and of Pharaoh, and who has delivered the people from the hand of the Egyptians. ");
INSERT INTO engmsb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I know that the LORD is greater than all other gods, for He did this when they treated Israel with arrogance.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Then Moses’ father-in-law Jethro brought a burnt offering and sacrifices to God, and Aaron came with all the elders of Israel to eat bread with Moses’ father-in-law in the presence of God. ");
INSERT INTO engmsb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","The next day Moses took his seat to judge the people, and they stood around him from morning until evening. ");
INSERT INTO engmsb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When his father-in-law saw all that Moses was doing for the people, he asked, “What is this that you are doing for the people? Why do you sit alone as judge, with all the people standing around you from morning till evening?” ");
INSERT INTO engmsb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","“Because the people come to me to inquire of God,” Moses replied. ");
INSERT INTO engmsb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","“Whenever they have a dispute, it is brought to me to judge between one man and another, and I make known to them the statutes and laws of God.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","But Moses’ father-in-law said to him, “What you are doing is not good. ");
INSERT INTO engmsb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Surely you and these people with you will wear yourselves out, because the task is too heavy for you. You cannot handle it alone. ");
INSERT INTO engmsb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Now listen to me; I will give you some advice, and may God be with you. You must be the people’s representative before God and bring their causes to Him. ");
INSERT INTO engmsb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Teach them the statutes and laws, and show them the way to live and the work they must do. ");
INSERT INTO engmsb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Furthermore, select capable men from among the people—God-fearing, trustworthy men who are averse to dishonest gain. Appoint them over the people as leaders of thousands, of hundreds, of fifties, and of tens. ");
INSERT INTO engmsb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Have these men judge the people at all times. Then they can bring you any major issue, but all minor cases they can judge on their own, so that your load may be lightened as they share it with you. ");
INSERT INTO engmsb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you follow this advice and God so directs you, then you will be able to endure, and all these people can go home in peace.” ");
INSERT INTO engmsb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses listened to his father-in-law and did everything he said. ");
INSERT INTO engmsb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","So Moses chose capable men from all Israel and made them heads over the people as leaders of thousands, of hundreds, of fifties, and of tens. ");
INSERT INTO engmsb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","And they judged the people at all times; they would bring the difficult cases to Moses, but any minor issue they would judge themselves. ");
INSERT INTO engmsb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Then Moses sent his father-in-law on his way, and Jethro returned to his own land. ");
INSERT INTO engmsb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","In the third month, on the same day of the month that the Israelites had left the land of Egypt, they came to the Wilderness of Sinai. ");
INSERT INTO engmsb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","After they had set out from Rephidim, they entered the Wilderness of Sinai, and Israel camped there in front of the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Then Moses went up to God, and the LORD called to him from the mountain, “This is what you are to tell the house of Jacob and explain to the sons of Israel: ");
INSERT INTO engmsb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You have seen for yourselves what I did to Egypt, and how I carried you on eagles’ wings and brought you to Myself. ");
INSERT INTO engmsb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Now if you will indeed obey My voice and keep My covenant, you will be My treasured possession out of all the nations—for the whole earth is Mine. ");
INSERT INTO engmsb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","And unto Me you shall be a kingdom of priests and a holy nation.’ These are the words that you are to speak to the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses went back and summoned the elders of the people and set before them all these words that the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","And all the people answered together, “We will do everything that the LORD has spoken.” So Moses brought their words back to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","The LORD said to Moses, “Behold, I will come to you in a dense cloud, so that the people will hear when I speak with you, and they will always put their trust in you.” And Moses relayed to the LORD what the people had said. ");
INSERT INTO engmsb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Then the LORD said to Moses, “Go to the people and consecrate them today and tomorrow. They must wash their clothes ");
INSERT INTO engmsb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and be prepared by the third day, for on the third day the LORD will come down on Mount Sinai in the sight of all the people. ");
INSERT INTO engmsb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","And you are to set up a boundary for the people around the mountain and tell them, ‘Be careful not to go up on the mountain or touch its base. Whoever touches the mountain shall surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","No hand shall touch him, but he shall surely be stoned or shot with arrows—whether man or beast, he must not live.’ Only when the ram’s horn sounds a long blast may they approach the mountain.” ");
INSERT INTO engmsb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","When Moses came down from the mountain to the people, he consecrated them, and they washed their clothes. ");
INSERT INTO engmsb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","“Be prepared for the third day,” he said to the people. “Do not draw near to a woman.” ");
INSERT INTO engmsb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","On the third day, when morning came, there was thunder and lightning. A thick cloud was upon the mountain, and a very loud blast of the ram’s horn went out, so that all the people in the camp trembled. ");
INSERT INTO engmsb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Then Moses brought the people out of the camp to meet with God, and they stood at the foot of the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mount Sinai was completely enveloped in smoke, because the LORD had descended on it in fire. And the smoke rose like the smoke of a furnace, and the whole mountain quaked violently. ");
INSERT INTO engmsb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","And as the sound of the ram’s horn grew louder and louder, Moses spoke and God answered him in the thunder. ");
INSERT INTO engmsb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","The LORD descended to the top of Mount Sinai and called Moses to the summit. So Moses went up, ");
INSERT INTO engmsb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","and the LORD said to him, “Go down and warn the people not to break through to see the LORD, lest many of them perish. ");
INSERT INTO engmsb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Even the priests who approach the LORD must consecrate themselves, or the LORD will break out against them.” ");
INSERT INTO engmsb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","But Moses said to the LORD, “The people cannot come up Mount Sinai, for You solemnly warned us, ‘Put a boundary around the mountain and set it apart as holy.’” ");
INSERT INTO engmsb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","And the LORD replied, “Go down and bring Aaron with you. But the priests and the people must not break through to come up to the LORD, or He will break out against them.” ");
INSERT INTO engmsb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people and spoke to them. ");
INSERT INTO engmsb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","And God spoke all these words: ");
INSERT INTO engmsb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am the LORD your God, who brought you out of the land of Egypt, out of the house of slavery. ");
INSERT INTO engmsb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","You shall have no other gods before Me. ");
INSERT INTO engmsb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","You shall not make for yourself an idol in the form of anything in the heavens above, on the earth below, or in the waters beneath. ");
INSERT INTO engmsb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You shall not bow down to them or worship them; for I, the LORD your God, am a jealous God, visiting the iniquity of the fathers on their children to the third and fourth generations of those who hate Me, ");
INSERT INTO engmsb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","but showing loving devotion to a thousand generations of those who love Me and keep My commandments. ");
INSERT INTO engmsb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","You shall not take the name of the LORD your God in vain, for the LORD will not leave anyone unpunished who takes His name in vain. ");
INSERT INTO engmsb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Remember the Sabbath day by keeping it holy. ");
INSERT INTO engmsb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Six days you shall labor and do all your work, ");
INSERT INTO engmsb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is a Sabbath to the LORD your God, on which you must not do any work—neither you, nor your son or daughter, nor your manservant or maidservant or livestock, nor the foreigner within your gates. ");
INSERT INTO engmsb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For in six days the LORD made the heavens and the earth and the sea and all that is in them, but on the seventh day He rested. Therefore the LORD blessed the Sabbath day and set it apart as holy. ");
INSERT INTO engmsb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honor your father and mother, so that your days may be long in the land that the LORD your God is giving you. ");
INSERT INTO engmsb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","You shall not murder. ");
INSERT INTO engmsb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","You shall not commit adultery. ");
INSERT INTO engmsb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","You shall not steal. ");
INSERT INTO engmsb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","You shall not bear false witness against your neighbor. ");
INSERT INTO engmsb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","You shall not covet your neighbor’s house. You shall not covet your neighbor’s wife, or his manservant or maidservant, or his ox or donkey, or anything that belongs to your neighbor.” ");
INSERT INTO engmsb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","When all the people witnessed the thunder and lightning, the sounding of the ram’s horn, and the mountain enveloped in smoke, they trembled and stood at a distance. ");
INSERT INTO engmsb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","“Speak to us yourself and we will listen,” they said to Moses. “But do not let God speak to us, or we will die.” ");
INSERT INTO engmsb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","“Do not be afraid,” Moses replied. “For God has come to test you, so that the fear of Him may be before you, to keep you from sinning.” ");
INSERT INTO engmsb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","And the people stood at a distance as Moses approached the thick darkness where God was. ");
INSERT INTO engmsb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Then the LORD said to Moses, “This is what you are to tell the Israelites: ‘You have seen for yourselves that I have spoken to you from heaven. ");
INSERT INTO engmsb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","You are not to make any gods alongside Me; you are not to make for yourselves gods of silver or gold. ");
INSERT INTO engmsb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","You are to make for Me an altar of earth, and sacrifice on it your burnt offerings and peace offerings, your sheep and goats and cattle. In every place where I cause My name to be remembered, I will come to you and bless you. ");
INSERT INTO engmsb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Now if you make an altar of stones for Me, you must not build it with stones shaped by tools; for if you use a chisel on it, you will defile it. ");
INSERT INTO engmsb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","And you must not go up to My altar on steps, lest your nakedness be exposed on it.’ ");
INSERT INTO engmsb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“These are the ordinances that you are to set before them: ");
INSERT INTO engmsb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","If you buy a Hebrew servant, he is to serve you for six years. But in the seventh year, he shall go free without paying anything. ");
INSERT INTO engmsb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he arrived alone, he is to leave alone; if he arrived with a wife, she is to leave with him. ");
INSERT INTO engmsb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master gives him a wife and she bears him sons or daughters, the woman and her children shall belong to her master, and only the man shall go free. ");
INSERT INTO engmsb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","But if the servant declares, ‘I love my master and my wife and children; I do not want to go free,’ ");
INSERT INTO engmsb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master is to bring him before the judges. And he shall take him to the door or doorpost and pierce his ear with an awl. Then he shall serve his master for life. ");
INSERT INTO engmsb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","And if a man sells his daughter as a servant, she is not to go free as the menservants do. ");
INSERT INTO engmsb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If she is displeasing in the eyes of her master who had designated her for himself, he must allow her to be redeemed. He has no right to sell her to foreigners, since he has broken faith with her. ");
INSERT INTO engmsb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","And if he chooses her for his son, he must deal with her as with a daughter. ");
INSERT INTO engmsb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he takes another wife, he must not reduce the food, clothing, or marital rights of his first wife. ");
INSERT INTO engmsb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","If, however, he does not provide her with these three things, she is free to go without monetary payment. ");
INSERT INTO engmsb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Whoever strikes and kills a man must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","If, however, he did not lie in wait, but God allowed it to happen, then I will appoint for you a place where he may flee. ");
INSERT INTO engmsb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if a man schemes and acts willfully against his neighbor to kill him, you must take him away from My altar to be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Whoever strikes his father or mother must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Whoever kidnaps another man must be put to death, whether he sells him or the man is found in his possession. ");
INSERT INTO engmsb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Anyone who curses his father or mother must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","If men are quarreling and one strikes the other with a stone or a fist, and he does not die but is confined to bed, ");
INSERT INTO engmsb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","then the one who struck him shall go unpunished, as long as the other can get up and walk around outside with his staff. Nevertheless, he must compensate the man for his lost work and see that he is completely healed. ");
INSERT INTO engmsb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","If a man strikes his manservant or maidservant with a rod, and the servant dies by his hand, he shall surely be punished. ");
INSERT INTO engmsb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","However, if the servant gets up after a day or two, the owner shall not be punished, since the servant is his property. ");
INSERT INTO engmsb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men who are fighting strike a pregnant woman and her child is born prematurely, but there is no further injury, he shall surely be fined as the woman’s husband demands and as the court allows. ");
INSERT INTO engmsb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if a serious injury results, then you must require a life for a life— ");
INSERT INTO engmsb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","eye for eye, tooth for tooth, hand for hand, foot for foot, ");
INSERT INTO engmsb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","burn for burn, wound for wound, and stripe for stripe. ");
INSERT INTO engmsb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","If a man strikes and blinds the eye of his manservant or maidservant, he must let the servant go free as compensation for the eye. ");
INSERT INTO engmsb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","And if he knocks out the tooth of his manservant or maidservant, he must let the servant go free as compensation for the tooth. ");
INSERT INTO engmsb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox gores a man or woman to death, the ox must surely be stoned, and its meat must not be eaten. But the owner of the ox shall not be held responsible. ");
INSERT INTO engmsb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox has a habit of goring, and its owner has been warned yet does not restrain it, and it kills a man or woman, then the ox must be stoned and its owner must also be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","If payment is demanded of him instead, he may redeem his life by paying the full amount demanded of him. ");
INSERT INTO engmsb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the ox gores a son or a daughter, it shall be done to him according to the same rule. ");
INSERT INTO engmsb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the ox gores a manservant or maidservant, the owner must pay thirty shekels of silver to the master of that servant, and the ox must be stoned. ");
INSERT INTO engmsb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","If a man opens or digs a pit and fails to cover it, and an ox or a donkey falls into it, ");
INSERT INTO engmsb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit shall make restitution; he must pay its owner, and the dead animal will be his. ");
INSERT INTO engmsb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","If a man’s ox injures his neighbor’s ox and it dies, they must sell the live one and divide the proceeds; they also must divide the dead animal. ");
INSERT INTO engmsb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if it was known that the ox had a habit of goring, yet its owner failed to restrain it, he shall pay full compensation, ox for ox, and the dead animal will be his. ");
INSERT INTO engmsb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“If a man steals an ox or a sheep and slaughters or sells it, he must repay five oxen for an ox and four sheep for a sheep. ");
INSERT INTO engmsb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If a thief is caught breaking in and is beaten to death, no one shall be guilty of bloodshed. ");
INSERT INTO engmsb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","But if it happens after sunrise, there is guilt for his bloodshed. A thief must make full restitution; if he has nothing, he himself shall be sold for his theft. ");
INSERT INTO engmsb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If what was stolen is actually found alive in his possession—whether ox or donkey or sheep—he must pay back double. ");
INSERT INTO engmsb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If a man grazes his livestock in a field or vineyard and allows them to stray so that they graze in someone else’s field, he must make restitution from the best of his own field or vineyard. ");
INSERT INTO engmsb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","If a fire breaks out and spreads to thornbushes so that it consumes stacked or standing grain, or the whole field, the one who started the fire must make full restitution. ");
INSERT INTO engmsb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If a man gives his neighbor money or goods for safekeeping and they are stolen from the neighbor’s house, the thief, if caught, must pay back double. ");
INSERT INTO engmsb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If the thief is not found, the owner of the house must appear before the judges to determine whether he has taken his neighbor’s property. ");
INSERT INTO engmsb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","In all cases of illegal possession of an ox, a donkey, a sheep, a garment, or any lost item that someone claims, ‘This is mine,’ both parties shall bring their cases before the judges. The one whom the judges find guilty must pay back double to his neighbor. ");
INSERT INTO engmsb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","If a man gives a donkey, an ox, a sheep, or any other animal to be cared for by his neighbor, but it dies or is injured or stolen while no one is watching, ");
INSERT INTO engmsb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","an oath before the LORD shall be made between the parties to determine whether or not the man has taken his neighbor’s property. The owner must accept the oath and require no restitution. ");
INSERT INTO engmsb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if the animal was actually stolen from the neighbor, he must make restitution to the owner. ");
INSERT INTO engmsb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If the animal was torn to pieces, he shall bring it as evidence; he need not make restitution for the torn carcass. ");
INSERT INTO engmsb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","If a man borrows an animal from his neighbor and it is injured or dies while its owner is not present, he must make full restitution. ");
INSERT INTO engmsb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","If the owner was present, no restitution is required. If the animal was rented, the fee covers the loss. ");
INSERT INTO engmsb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If a man seduces a virgin who is not pledged in marriage and sleeps with her, he must pay the full dowry for her to be his wife. ");
INSERT INTO engmsb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father absolutely refuses to give her to him, the man still must pay an amount comparable to the bridal price of a virgin. ");
INSERT INTO engmsb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","You must not allow a sorceress to live. ");
INSERT INTO engmsb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Whoever lies with an animal must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","If anyone sacrifices to any god other than the LORD alone, he must be set apart for destruction. ");
INSERT INTO engmsb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","You must not exploit or oppress a foreign resident, for you yourselves were foreigners in the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","You must not mistreat any widow or orphan. ");
INSERT INTO engmsb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you do mistreat them, and they cry out to Me in distress, I will surely hear their cry. ");
INSERT INTO engmsb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","My anger will be kindled, and I will kill you with the sword; then your wives will become widows and your children will be fatherless. ");
INSERT INTO engmsb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If you lend money to one of My people among you who is poor, you must not act as a creditor to him; you are not to charge him interest. ");
INSERT INTO engmsb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If you take your neighbor’s cloak as collateral, return it to him by sunset, ");
INSERT INTO engmsb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","because his cloak is the only covering he has for his body. What else will he sleep in? And if he cries out to Me, I will hear, for I am compassionate. ");
INSERT INTO engmsb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","You must not blaspheme God or curse the ruler of your people. ");
INSERT INTO engmsb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","You must not hold back offerings from your granaries or vats. You are to give Me the firstborn of your sons. ");
INSERT INTO engmsb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You shall do likewise with your cattle and your sheep. Let them stay with their mothers for seven days, but on the eighth day you are to give them to Me. ");
INSERT INTO engmsb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","You are to be My holy people. You must not eat the meat of a mauled animal found in the field; you are to throw it to the dogs. ");
INSERT INTO engmsb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“You shall not spread a false report. Do not join the wicked by being a malicious witness. ");
INSERT INTO engmsb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","You shall not follow the crowd in wrongdoing. When you testify in a lawsuit, do not pervert justice by siding with the crowd. ");
INSERT INTO engmsb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","And do not show favoritism to a poor man in his lawsuit. ");
INSERT INTO engmsb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If you encounter your enemy’s stray ox or donkey, you must return it to him. ");
INSERT INTO engmsb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the donkey of one who hates you fallen under its load, do not leave it there; you must help him with it. ");
INSERT INTO engmsb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","You shall not deny justice to the poor in their lawsuits. ");
INSERT INTO engmsb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Stay far away from a false accusation. Do not kill the innocent or the just, for I will not acquit the guilty. ");
INSERT INTO engmsb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Do not accept a bribe, for a bribe blinds those who see and twists the words of the righteous. ");
INSERT INTO engmsb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Do not oppress a foreign resident, since you yourselves know how it feels to be foreigners; for you were foreigners in the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","For six years you are to sow your land and gather its produce, ");
INSERT INTO engmsb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","but in the seventh year you must let it rest and lie fallow, so that the poor among your people may eat from the field and the wild animals may consume what they leave. Do the same with your vineyard and olive grove. ");
INSERT INTO engmsb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","For six days you are to do your work, but on the seventh day you must cease, so that your ox and your donkey may rest and the son of your maidservant may be refreshed, as well as the foreign resident. ");
INSERT INTO engmsb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Pay close attention to everything I have said to you. You must not invoke the names of other gods; they must not be heard on your lips. ");
INSERT INTO engmsb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Three times a year you are to celebrate a feast to Me. ");
INSERT INTO engmsb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You are to keep the Feast of Unleavened Bread as I commanded you: At the appointed time in the month of Abib you are to eat unleavened bread for seven days, because that was the month you came out of Egypt. No one may appear before Me empty-handed. ");
INSERT INTO engmsb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","You are also to keep the Feast of Harvest with the firstfruits of the produce from what you sow in the field. And keep the Feast of Ingathering at the end of the year, when you gather your produce from the field. ");
INSERT INTO engmsb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Three times a year all your males are to appear before the Lord GOD. ");
INSERT INTO engmsb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","You must not offer the blood of My sacrifices with anything leavened, nor may the fat of My feast remain until morning. ");
INSERT INTO engmsb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Bring the best of the firstfruits of your soil to the house of the LORD your God. You must not cook a young goat in its mother’s milk. ");
INSERT INTO engmsb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Behold, I am sending an angel before you to protect you along the way and to bring you to the place I have prepared. ");
INSERT INTO engmsb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pay attention to him and listen to his voice; do not defy him, for he will not forgive rebellion, since My Name is in him. ");
INSERT INTO engmsb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","But if you will listen carefully to his voice and do everything I say, I will be an enemy to your enemies and a foe to your foes. ");
INSERT INTO engmsb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For My angel will go before you and bring you into the land of the Amorites, Hittites, Perizzites, Canaanites, Hivites, and Jebusites, and I will annihilate them. ");
INSERT INTO engmsb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","You must not bow down to their gods or serve them or follow their practices. Instead, you are to demolish them and smash their sacred stones to pieces. ");
INSERT INTO engmsb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","So you shall serve the LORD your God, and He will bless your bread and your water. And I will take away sickness from among you. ");
INSERT INTO engmsb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No woman in your land will miscarry or be barren; I will fulfill the number of your days. ");
INSERT INTO engmsb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send My terror ahead of you and throw into confusion every nation you encounter. I will make all your enemies turn and run. ");
INSERT INTO engmsb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send the hornet before you to drive the Hivites and Canaanites and Hittites out of your way. ");
INSERT INTO engmsb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out before you in a single year; otherwise the land would become desolate and wild animals would multiply against you. ");
INSERT INTO engmsb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Little by little I will drive them out ahead of you, until you become fruitful and possess the land. ");
INSERT INTO engmsb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","And I will establish your borders from the Red Sea to the Sea of the Philistines, and from the desert to the Euphrates. For I will deliver the inhabitants into your hand, and you will drive them out before you. ");
INSERT INTO engmsb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","You shall make no covenant with them or with their gods. ");
INSERT INTO engmsb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They must not remain in your land, lest they cause you to sin against Me. For if you serve their gods, it will surely be a snare to you.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Then the LORD said to Moses, “Come up to the LORD—you and Aaron, Nadab and Abihu, and seventy of Israel’s elders—and you are to worship at a distance. ");
INSERT INTO engmsb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses alone shall approach the LORD, but the others must not come near. And the people may not go up with him.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","When Moses came and told the people all the words and ordinances of the LORD, they all responded with one voice: “All the words that the LORD has spoken, we will do.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","And Moses wrote down all the words of the LORD. Early the next morning he got up and built an altar at the base of the mountain, along with twelve pillars for the twelve tribes of Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Then he sent out some young men of Israel, and they offered burnt offerings and sacrificed young bulls as peace offerings to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses took half of the blood and put it in bowls, and the other half he splattered on the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Then he took the Book of the Covenant and read it to the people, who replied, “All that the LORD has spoken we will do, and we will be obedient.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","So Moses took the blood, splattered it on the people, and said, “This is the blood of the covenant that the LORD has made with you in accordance with all these words.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses went up with Aaron, Nadab and Abihu, and seventy of the elders of Israel, ");
INSERT INTO engmsb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","and they saw the God of Israel. Under His feet was a work like a pavement made of sapphire, as clear as the sky itself. ");
INSERT INTO engmsb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","But God did not lay His hand on the nobles of Israel; they saw Him, and they ate and drank. ");
INSERT INTO engmsb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Then the LORD said to Moses, “Come up to Me on the mountain and stay here, so that I may give you the tablets of stone, with the law and commandments I have written for their instruction.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","So Moses set out with Joshua his attendant and went up on the mountain of God. ");
INSERT INTO engmsb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","And he said to the elders, “Wait here for us until we return to you. Aaron and Hur are here with you. Whoever has a dispute can go to them.” ");
INSERT INTO engmsb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","When Moses went up on the mountain, the cloud covered it, ");
INSERT INTO engmsb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","and the glory of the LORD settled on Mount Sinai. For six days the cloud covered it, and on the seventh day the LORD called to Moses from within the cloud. ");
INSERT INTO engmsb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","And the sight of the glory of the LORD was like a consuming fire on the mountaintop in the eyes of the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses entered the cloud as he went up on the mountain, and he remained on the mountain forty days and forty nights. ");
INSERT INTO engmsb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tell the Israelites to bring Me an offering. You are to receive My offering from every man whose heart compels him. ");
INSERT INTO engmsb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","This is the offering you are to accept from them: gold, silver, and bronze; ");
INSERT INTO engmsb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, and scarlet yarn; fine linen and goat hair; ");
INSERT INTO engmsb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ram skins dyed red and fine leather; acacia wood; ");
INSERT INTO engmsb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olive oil for the light; spices for the anointing oil and for the fragrant incense; ");
INSERT INTO engmsb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","and onyx stones and gemstones to be mounted on the ephod and breastpiece. ");
INSERT INTO engmsb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","And they are to make a sanctuary for Me, so that I may dwell among them. ");
INSERT INTO engmsb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","You must make the tabernacle and design all its furnishings according to the pattern I show you. ");
INSERT INTO engmsb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","And they are to construct an ark of acacia wood, two and a half cubits long, a cubit and a half wide, and a cubit and a half high. ");
INSERT INTO engmsb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Overlay it with pure gold both inside and out, and make a gold molding around it. ");
INSERT INTO engmsb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Cast four gold rings for it and fasten them to its four feet, two rings on one side and two on the other. ");
INSERT INTO engmsb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","And make poles of acacia wood and overlay them with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Insert the poles into the rings on the sides of the ark, in order to carry it. ");
INSERT INTO engmsb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles are to remain in the rings of the ark; they must not be removed. ");
INSERT INTO engmsb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","And place inside the ark the Testimony, which I will give you. ");
INSERT INTO engmsb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","And you are to construct a mercy seat of pure gold, two and a half cubits long and a cubit and a half wide. ");
INSERT INTO engmsb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Make two cherubim of hammered gold at the ends of the mercy seat, ");
INSERT INTO engmsb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","one cherub on one end and one on the other, all made from one piece of gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","And the cherubim are to have wings that spread upward, overshadowing the mercy seat. The cherubim are to face each other, looking toward the mercy seat. ");
INSERT INTO engmsb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Set the mercy seat atop the ark and put the Testimony that I will give you into the ark. ");
INSERT INTO engmsb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","And I will meet with you there above the mercy seat, between the two cherubim that are over the ark of the Testimony; I will speak with you about all that I command you regarding the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","You are also to make a table of acacia wood two cubits long, a cubit wide, and a cubit and a half high. ");
INSERT INTO engmsb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Overlay it with pure gold and make a gold molding around it. ");
INSERT INTO engmsb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","And make a rim around it a handbreadth wide and put a gold molding on the rim. ");
INSERT INTO engmsb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Make four gold rings for the table and fasten them to the four corners at its four legs. ");
INSERT INTO engmsb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings are to be close to the rim, to serve as holders for the poles used to carry the table. ");
INSERT INTO engmsb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Make the poles of acacia wood and overlay them with gold, so that the table may be carried with them. ");
INSERT INTO engmsb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","You are also to make the plates and dishes, as well as the pitchers and bowls for pouring drink offerings. Make them out of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","And place the Bread of the Presence on the table before Me at all times. ");
INSERT INTO engmsb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Then you are to make a lampstand of pure, hammered gold. It shall be made of one piece, including its base and shaft, its cups, and its buds and petals. ");
INSERT INTO engmsb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Six branches are to extend from the sides of the lampstand—three on one side and three on the other. ");
INSERT INTO engmsb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","There are to be three cups shaped like almond blossoms on the first branch, each with buds and petals, three on the next branch, and the same for all six branches that extend from the lampstand. ");
INSERT INTO engmsb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","And on the lampstand there shall be four cups shaped like almond blossoms with buds and petals. ");
INSERT INTO engmsb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","For the six branches that extend from the lampstand, a bud must be under the first pair of branches, a bud under the second pair, and a bud under the third pair. ");
INSERT INTO engmsb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","The buds and branches are to be all of one piece with the lampstand, hammered out of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Make seven lamps and set them up on the lampstand so that they illuminate the area in front of it. ");
INSERT INTO engmsb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","The wick trimmers and their trays must be of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","The lampstand and all these utensils shall be made from a talent of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","See to it that you make everything according to the pattern shown you on the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“You are to construct the tabernacle itself with ten curtains of finely spun linen, each with blue, purple, and scarlet yarn, and cherubim skillfully worked into them. ");
INSERT INTO engmsb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Each curtain shall be twenty-eight cubits long and four cubits wide—all curtains the same size. ");
INSERT INTO engmsb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Five of the curtains are to be joined together, and the other five joined as well. ");
INSERT INTO engmsb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Make loops of blue material on the edge of the end curtain in the first set, and do the same for the end curtain in the second set. ");
INSERT INTO engmsb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Make fifty loops on one curtain and fifty loops on the end curtain of the second set, so that the loops line up opposite one another. ");
INSERT INTO engmsb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Make fifty gold clasps as well, and join the curtains together with the clasps, so that the tabernacle will be a unit. ");
INSERT INTO engmsb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","You are to make curtains of goat hair for the tent over the tabernacle—eleven curtains in all. ");
INSERT INTO engmsb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Each of the eleven curtains is to be the same size—thirty cubits long and four cubits wide. ");
INSERT INTO engmsb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Join five of the curtains into one set and the other six into another. Then fold the sixth curtain over double at the front of the tent. ");
INSERT INTO engmsb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Make fifty loops along the edge of the end curtain in the first set, and fifty loops along the edge of the corresponding curtain in the second set. ");
INSERT INTO engmsb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Make fifty bronze clasps and put them through the loops to join the tent together as a unit. ");
INSERT INTO engmsb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","As for the overlap that remains of the tent curtains, the half curtain that is left over shall hang down over the back of the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","And the tent curtains will be a cubit longer on either side, and the excess will hang over the sides of the tabernacle to cover it. ");
INSERT INTO engmsb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Also make a covering for the tent out of ram skins dyed red, and over that a covering of fine leather. ");
INSERT INTO engmsb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","You are to construct upright frames of acacia wood for the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Each frame is to be ten cubits long and a cubit and a half wide. ");
INSERT INTO engmsb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Two tenons must be connected to each other for each frame. Make all the frames of the tabernacle in this way. ");
INSERT INTO engmsb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Construct twenty frames for the south side of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","with forty silver bases under the twenty frames—two bases for each frame, one under each tenon. ");
INSERT INTO engmsb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","For the second side of the tabernacle, the north side, make twenty frames ");
INSERT INTO engmsb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and forty silver bases—two bases under each frame. ");
INSERT INTO engmsb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Make six frames for the rear of the tabernacle, the west side, ");
INSERT INTO engmsb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","and two frames for the two back corners of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","coupled together from bottom to top and fitted into a single ring. These will serve as the two corners. ");
INSERT INTO engmsb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","So there are to be eight frames and sixteen silver bases—two under each frame. ");
INSERT INTO engmsb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","You are also to make five crossbars of acacia wood for the frames on one side of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","five for those on the other side, and five for those on the rear side of the tabernacle, to the west. ");
INSERT INTO engmsb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The central crossbar in the middle of the frames shall extend from one end to the other. ");
INSERT INTO engmsb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Overlay the frames with gold and make gold rings to hold the crossbars. Also overlay the crossbars with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","So you are to set up the tabernacle according to the pattern shown you on the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Make a veil of blue, purple, and scarlet yarn, and finely spun linen, with cherubim skillfully worked into it. ");
INSERT INTO engmsb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hang it with gold hooks on four posts of acacia wood, overlaid with gold and standing on four silver bases. ");
INSERT INTO engmsb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","And hang the veil from the clasps and place the ark of the Testimony behind the veil. So the veil will separate the Holy Place from the Most Holy Place. ");
INSERT INTO engmsb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Put the mercy seat on the ark of the Testimony in the Most Holy Place. ");
INSERT INTO engmsb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","And place the table outside the veil on the north side of the tabernacle, and put the lampstand opposite the table, on the south side. ");
INSERT INTO engmsb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","For the entrance to the tent, you are to make a curtain embroidered with blue, purple, and scarlet yarn, and finely spun linen. ");
INSERT INTO engmsb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Make five posts of acacia wood for the curtain, overlay them with gold hooks, and cast five bronze bases for them. ");
INSERT INTO engmsb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“You are to build an altar of acacia wood. The altar must be square, five cubits long, five cubits wide, and three cubits high. ");
INSERT INTO engmsb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Make a horn on each of its four corners, so that the horns are of one piece, and overlay it with bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Make all its utensils of bronze—its pots for removing ashes, its shovels, its sprinkling bowls, its meat forks, and its firepans. ");
INSERT INTO engmsb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Construct for it a grate of bronze mesh, and make a bronze ring at each of the four corners of the mesh. ");
INSERT INTO engmsb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Set the grate beneath the ledge of the altar, so that the mesh comes halfway up the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Additionally, make poles of acacia wood for the altar and overlay them with bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","The poles are to be inserted into the rings so that the poles are on two sides of the altar when it is carried. ");
INSERT INTO engmsb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Construct the altar with boards so that it is hollow. It is to be made just as you were shown on the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","You are also to make a courtyard for the tabernacle. On the south side of the courtyard make curtains of finely spun linen, a hundred cubits long on one side, ");
INSERT INTO engmsb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","with twenty posts and twenty bronze bases, and silver hooks and bands on the posts. ");
INSERT INTO engmsb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Likewise there are to be curtains on the north side, a hundred cubits long, with twenty posts and twenty bronze bases, and with silver hooks and bands on the posts. ");
INSERT INTO engmsb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","The curtains on the west side of the courtyard shall be fifty cubits wide, with ten posts and ten bases. ");
INSERT INTO engmsb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The east side of the courtyard, toward the sunrise, is to be fifty cubits wide. ");
INSERT INTO engmsb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Make the curtains on one side fifteen cubits long, with three posts and three bases, ");
INSERT INTO engmsb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","and the curtains on the other side fifteen cubits long, with three posts and three bases. ");
INSERT INTO engmsb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","The gate of the courtyard shall be twenty cubits long, with a curtain embroidered with blue, purple, and scarlet yarn, and finely spun linen. It shall have four posts and four bases. ");
INSERT INTO engmsb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the posts around the courtyard shall have silver bands, silver hooks, and bronze bases. ");
INSERT INTO engmsb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The entire courtyard shall be a hundred cubits long and fifty cubits wide, with curtains of finely spun linen five cubits high, and with bronze bases. ");
INSERT INTO engmsb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the utensils of the tabernacle for every use, including all its tent pegs and the tent pegs of the courtyard, shall be made of bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","And you are to command the Israelites to bring you pure oil of pressed olives for the light, to keep the lamps burning continually. ");
INSERT INTO engmsb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the Tent of Meeting, outside the veil that is in front of the Testimony, Aaron and his sons are to tend the lamps before the LORD from evening until morning. This is to be a permanent statute for the Israelites for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Next, have your brother Aaron brought to you from among the Israelites, along with his sons Nadab, Abihu, Eleazar, and Ithamar, to serve Me as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Make holy garments for your brother Aaron, to give him glory and splendor. ");
INSERT INTO engmsb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","You are to instruct all the skilled craftsmen, whom I have filled with a spirit of wisdom, to make garments for Aaron’s consecration, so that he may serve Me as priest. ");
INSERT INTO engmsb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","These are the garments that they shall make: a breastpiece, an ephod, a robe, a woven tunic, a turban, and a sash. They are to make these holy garments for your brother Aaron and his sons, so that they may serve Me as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","They shall use gold, along with blue, purple, and scarlet yarn, and fine linen. ");
INSERT INTO engmsb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","They are to make the ephod of finely spun linen embroidered with gold, and with blue, purple, and scarlet yarn. ");
INSERT INTO engmsb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","It shall have two shoulder pieces attached at two of its corners, so it can be fastened. ");
INSERT INTO engmsb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","And the skillfully woven waistband of the ephod must be of one piece, of the same workmanship—with gold, with blue, purple, and scarlet yarn, and with finely spun linen. ");
INSERT INTO engmsb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Take two onyx stones and engrave on them the names of the sons of Israel: ");
INSERT INTO engmsb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six of their names on one stone and the remaining six on the other, in the order of their birth. ");
INSERT INTO engmsb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Engrave the names of the sons of Israel on the two stones the way a gem cutter engraves a seal. Then mount the stones in gold filigree settings. ");
INSERT INTO engmsb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Fasten both stones on the shoulder pieces of the ephod as memorial stones for the sons of Israel. Aaron is to bear their names on his two shoulders as a memorial before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Fashion gold filigree settings ");
INSERT INTO engmsb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two chains of pure gold, made of braided cord work; and attach these chains to the settings. ");
INSERT INTO engmsb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","You are also to make a breastpiece of judgment with the same workmanship as the ephod. Construct it with gold, with blue, purple, and scarlet yarn, and with finely spun linen. ");
INSERT INTO engmsb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It must be square when folded over double, a span long and a span wide. ");
INSERT INTO engmsb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","And mount on it a setting of gemstones, four rows of stones: In the first row there shall be a ruby, a topaz, and an emerald; ");
INSERT INTO engmsb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","in the second row a turquoise, a sapphire, and a diamond; ");
INSERT INTO engmsb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","in the third row a jacinth, an agate, and an amethyst; ");
INSERT INTO engmsb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","and in the fourth row a beryl, an onyx, and a jasper. Mount these stones in gold filigree settings. ");
INSERT INTO engmsb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","The twelve stones are to correspond to the names of the sons of Israel, each engraved like a seal with the name of one of the twelve tribes. ");
INSERT INTO engmsb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","For the breastpiece, make braided chains like cords of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","You are also to make two gold rings and fasten them to the two corners of the breastpiece. ");
INSERT INTO engmsb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Then fasten the two gold chains to the two gold rings at the corners of the breastpiece, ");
INSERT INTO engmsb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","and fasten the other ends of the two chains to the two filigree settings, attaching them to the shoulder pieces of the ephod at the front. ");
INSERT INTO engmsb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Make two more gold rings and attach them to the other two corners of the breastpiece, on the inside edge next to the ephod. ");
INSERT INTO engmsb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Make two additional gold rings and attach them to the bottom of the two shoulder pieces of the ephod, on its front, near its seam just above its woven waistband. ");
INSERT INTO engmsb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","The rings of the breastpiece shall be tied to the rings of the ephod with a cord of blue yarn, so that the breastpiece is above the waistband of the ephod and does not swing out from the ephod. ");
INSERT INTO engmsb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Whenever Aaron enters the Holy Place, he shall bear the names of the sons of Israel over his heart on the breastpiece of judgment, as a continual reminder before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","And place the Urim and Thummim in the breastpiece of judgment, so that they will also be over Aaron’s heart whenever he comes before the LORD. Aaron will continually carry the judgment of the sons of Israel over his heart before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","You are to make the robe of the ephod entirely of blue cloth, ");
INSERT INTO engmsb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","with an opening at its top in the center. Around the opening shall be a woven collar with an opening like that of a garment, so that it will not tear. ");
INSERT INTO engmsb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Make pomegranates of blue, purple, and scarlet yarn all the way around the lower hem, with gold bells between them, ");
INSERT INTO engmsb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","alternating the gold bells and pomegranates around the lower hem of the robe. ");
INSERT INTO engmsb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron must wear the robe whenever he ministers, and its sound will be heard when he enters or exits the sanctuary before the LORD, so that he will not die. ");
INSERT INTO engmsb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","You are to make a plate of pure gold and engrave on it as on a seal: HOLY TO THE LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Fasten to it a blue cord to mount it on the turban; it shall be on the front of the turban. ");
INSERT INTO engmsb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","And it will be worn on Aaron’s forehead, so that he may bear the iniquity of the holy things that the sons of Israel consecrate with regard to all their holy gifts. It shall always be on his forehead, so that they may be acceptable before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","You are to weave the tunic with fine linen, make the turban of fine linen, and fashion an embroidered sash. ");
INSERT INTO engmsb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Make tunics, sashes, and headbands for Aaron’s sons, to give them glory and splendor. ");
INSERT INTO engmsb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","After you put these garments on your brother Aaron and his sons, anoint them, ordain them, and consecrate them so that they may serve Me as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Make linen undergarments to cover their bare flesh, extending from waist to thigh. ");
INSERT INTO engmsb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons must wear them whenever they enter the Tent of Meeting or approach the altar to minister in the Holy Place, so that they will not incur guilt and die. This is to be a permanent statute for Aaron and his descendants. ");
INSERT INTO engmsb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Now this is what you are to do to consecrate Aaron and his sons to serve Me as priests: Take a young bull and two rams without blemish, ");
INSERT INTO engmsb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","along with unleavened bread, unleavened cakes mixed with oil, and unleavened wafers anointed with oil. Make them out of fine wheat flour, ");
INSERT INTO engmsb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","put them in a basket, and present them in the basket, along with the bull and the two rams. ");
INSERT INTO engmsb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Then present Aaron and his sons at the entrance to the Tent of Meeting and wash them with water. ");
INSERT INTO engmsb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Take the garments and clothe Aaron with the tunic, the robe of the ephod, the ephod itself, and the breastplate. Fasten the ephod on him with its woven waistband. ");
INSERT INTO engmsb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Put the turban on his head and attach the holy diadem to the turban. ");
INSERT INTO engmsb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then take the anointing oil and anoint him by pouring it on his head. ");
INSERT INTO engmsb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Present his sons as well and clothe them with tunics. ");
INSERT INTO engmsb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Wrap the sashes around Aaron and his sons and tie headbands on them. The priesthood shall be theirs by a permanent statute. In this way you are to ordain Aaron and his sons. ");
INSERT INTO engmsb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","You are to present the bull at the front of the Tent of Meeting, and Aaron and his sons are to lay their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","And you shall slaughter the bull before the LORD at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Take some of the blood of the bull and put it on the horns of the altar with your finger; then pour out the rest of the blood at the base of the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Take all the fat that covers the entrails and the lobe of the liver, and both kidneys with the fat on them, and burn them on the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But burn the flesh of the bull and its hide and dung outside the camp; it is a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Take one of the rams, and Aaron and his sons shall lay their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","You are to slaughter the ram, take its blood, and splatter it on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Cut the ram into pieces, wash the entrails and legs, and place them with its head and other pieces. ");
INSERT INTO engmsb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Then burn the entire ram on the altar; it is a burnt offering to the LORD, a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Take the second ram, and Aaron and his sons are to lay their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Slaughter the ram, take some of its blood, and put it on the right earlobes of Aaron and his sons, on the thumbs of their right hands, and on the big toes of their right feet. Splatter the remaining blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","And take some of the blood on the altar and some of the anointing oil and sprinkle it on Aaron and his garments, as well as on his sons and their garments. Then he and his garments will be consecrated, as well as his sons and their garments. ");
INSERT INTO engmsb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Take the fat from the ram, the fat tail, the fat covering the entrails, the lobe of the liver, both kidneys with the fat on them, and the right thigh (since this is a ram for ordination), ");
INSERT INTO engmsb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","along with one loaf of bread, one cake of bread made with oil, and one wafer from the basket of unleavened bread that is before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Put all these in the hands of Aaron and his sons and wave them before the LORD as a wave offering. ");
INSERT INTO engmsb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then take them from their hands and burn them on the altar atop the burnt offering as a pleasing aroma before the LORD; it is a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Take the breast of the ram of Aaron’s ordination and wave it before the LORD as a wave offering, and it will be your portion. ");
INSERT INTO engmsb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Consecrate for Aaron and his sons the breast of the wave offering that is waved and the thigh of the heave offering that is lifted up from the ram of ordination. ");
INSERT INTO engmsb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","This will belong to Aaron and his sons as a regular portion from the Israelites, for it is the heave offering the Israelites will make to the LORD from their peace offerings. ");
INSERT INTO engmsb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","The holy garments that belong to Aaron will belong to his sons after him, so they can be anointed and ordained in them. ");
INSERT INTO engmsb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","The son who succeeds him as priest and enters the Tent of Meeting to minister in the Holy Place must wear them for seven days. ");
INSERT INTO engmsb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","You are to take the ram of ordination and boil its flesh in a holy place. ");
INSERT INTO engmsb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","At the entrance to the Tent of Meeting, Aaron and his sons are to eat the meat of the ram and the bread that is in the basket. ");
INSERT INTO engmsb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They must eat those things by which atonement was made for their ordination and consecration. But no outsider may eat them, because these things are sacred. ");
INSERT INTO engmsb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","And if any of the meat of ordination or any bread is left until the morning, you are to burn up the remainder. It must not be eaten, because it is sacred. ");
INSERT INTO engmsb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","This is what you are to do for Aaron and his sons based on all that I have commanded you, taking seven days to ordain them. ");
INSERT INTO engmsb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Sacrifice a bull as a sin offering each day for atonement. Purify the altar by making atonement for it, and anoint it to consecrate it. ");
INSERT INTO engmsb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","For seven days you shall make atonement for the altar and consecrate it. Then the altar will become most holy; whatever touches the altar will be holy. ");
INSERT INTO engmsb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","This is what you are to offer regularly on the altar, each day: two lambs that are a year old. ");
INSERT INTO engmsb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Offer one lamb in the morning and the other at twilight. ");
INSERT INTO engmsb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","With the first lamb offer a tenth of an ephah of fine flour, mixed with a quarter hin of oil from pressed olives, and a drink offering of a quarter hin of wine. ");
INSERT INTO engmsb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","And offer the second lamb at twilight with the same grain offering and drink offering as in the morning, as a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","For the generations to come, this burnt offering shall be made regularly at the entrance to the Tent of Meeting before the LORD, where I will meet you to speak with you. ");
INSERT INTO engmsb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I will also meet with the Israelites there, and that place will be consecrated by My glory. ");
INSERT INTO engmsb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","So I will consecrate the Tent of Meeting and the altar, and I will consecrate Aaron and his sons to serve Me as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Then I will dwell among the Israelites and be their God. ");
INSERT INTO engmsb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","And they will know that I am the LORD their God, who brought them out of the land of Egypt so that I might dwell among them. I am the LORD their God. ");
INSERT INTO engmsb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“You are also to make an altar of acacia wood for the burning of incense. ");
INSERT INTO engmsb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","It is to be square, a cubit long, a cubit wide, and two cubits high. Its horns must be of one piece. ");
INSERT INTO engmsb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Overlay with pure gold the top and all the sides and horns, and make a molding of gold around it. ");
INSERT INTO engmsb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","And make two gold rings below the molding on opposite sides to hold the poles used to carry it. ");
INSERT INTO engmsb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Make the poles of acacia wood and overlay them with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Place the altar in front of the veil that is before the ark of the Testimony—before the mercy seat that is over the Testimony—where I will meet with you. ");
INSERT INTO engmsb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","And Aaron is to burn fragrant incense on it every morning when he tends the lamps. ");
INSERT INTO engmsb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","When Aaron sets up the lamps at twilight, he must burn the incense perpetually before the LORD for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","On this altar you must not offer unauthorized incense or a burnt offering or grain offering; nor are you to pour a drink offering on it. ");
INSERT INTO engmsb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Once a year Aaron shall make atonement on the horns of the altar. Throughout your generations he shall make atonement on it annually with the blood of the sin offering of atonement. The altar is most holy to the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When you take a census of the Israelites to number them, each man must pay the LORD a ransom for his life when he is counted. Then no plague will come upon them when they are numbered. ");
INSERT INTO engmsb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Everyone who crosses over to those counted must pay a half shekel, according to the sanctuary shekel, which weighs twenty gerahs. This half shekel is an offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Everyone twenty years of age or older who crosses over must give this offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","In making the offering to the LORD to atone for your lives, the rich shall not give more than a half shekel, nor shall the poor give less. ");
INSERT INTO engmsb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Take the atonement money from the Israelites and use it for the service of the Tent of Meeting. It will serve as a memorial for the Israelites before the LORD to make atonement for your lives.” ");
INSERT INTO engmsb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“You are to make a bronze basin with a bronze stand for washing. Set it between the Tent of Meeting and the altar, and put water in it, ");
INSERT INTO engmsb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","with which Aaron and his sons are to wash their hands and feet. ");
INSERT INTO engmsb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Whenever they enter the Tent of Meeting or approach the altar to minister by presenting a food offering to the LORD, they must wash with water so that they will not die. ");
INSERT INTO engmsb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Thus they are to wash their hands and feet so that they will not die; this shall be a permanent statute for Aaron and his descendants for the generations to come.” ");
INSERT INTO engmsb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Take the finest spices: 500 shekels of liquid myrrh, half that amount (250 shekels) of fragrant cinnamon, 250 shekels of fragrant cane, ");
INSERT INTO engmsb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 shekels of cassia—all according to the sanctuary shekel—and a hin of olive oil. ");
INSERT INTO engmsb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Prepare from these a sacred anointing oil, a fragrant blend, the work of a perfumer; it will be a sacred anointing oil. ");
INSERT INTO engmsb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Use this oil to anoint the Tent of Meeting, the ark of the Testimony, ");
INSERT INTO engmsb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all its utensils, the lampstand and its utensils, the altar of incense, ");
INSERT INTO engmsb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","the altar of burnt offering and all its utensils, and the basin with its stand. ");
INSERT INTO engmsb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","You are to consecrate them so that they will be most holy. Whatever touches them shall be holy. ");
INSERT INTO engmsb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Anoint Aaron and his sons and consecrate them to serve Me as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","And you are to tell the Israelites, ‘This will be My sacred anointing oil for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","It must not be used to anoint an ordinary man, and you must not make anything like it with the same formula. It is holy, and it must be holy to you. ");
INSERT INTO engmsb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Anyone who mixes perfume like it or puts it on an outsider shall be cut off from his people.’” ");
INSERT INTO engmsb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","The LORD also said to Moses, “Take fragrant spices—gum resin, onycha, galbanum, and pure frankincense—in equal measures, ");
INSERT INTO engmsb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","and make a fragrant blend of incense, the work of a perfumer, seasoned with salt, pure and holy. ");
INSERT INTO engmsb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Grind some of it into fine powder and place it in front of the Testimony in the Tent of Meeting, where I will meet with you. It shall be most holy to you. ");
INSERT INTO engmsb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","You are never to use this formula to make incense for yourselves; you shall regard it as holy to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Anyone who makes something like it to enjoy its fragrance shall be cut off from his people.” ");
INSERT INTO engmsb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“See, I have called by name Bezalel son of Uri, the son of Hur, of the tribe of Judah. ");
INSERT INTO engmsb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","And I have filled him with the Spirit of God, with skill, ability, and knowledge in all kinds of craftsmanship, ");
INSERT INTO engmsb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","to design artistic works in gold, silver, and bronze, ");
INSERT INTO engmsb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","to cut gemstones for settings, and to carve wood, so that he may be a master of every craft. ");
INSERT INTO engmsb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Moreover, I have selected Oholiab son of Ahisamach, of the tribe of Dan, as his assistant. I have also given skill to all the craftsmen, that they may fashion all that I have commanded you: ");
INSERT INTO engmsb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the Tent of Meeting, the ark of the Testimony and the mercy seat upon it, and all the other furnishings of the tent— ");
INSERT INTO engmsb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table with its utensils, the pure gold lampstand with all its utensils, the altar of incense, ");
INSERT INTO engmsb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar of burnt offering with all its utensils, and the basin with its stand— ");
INSERT INTO engmsb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","as well as the woven garments, both the holy garments for Aaron the priest and the garments for his sons to serve as priests, ");
INSERT INTO engmsb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","in addition to the anointing oil and fragrant incense for the Holy Place. They are to make them according to all that I have commanded you.” ");
INSERT INTO engmsb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israelites, ‘Surely you must keep My Sabbaths, for this will be a sign between Me and you for the generations to come, so that you may know that I am the LORD who sanctifies you. ");
INSERT INTO engmsb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Keep the Sabbath, for it is holy to you. Anyone who profanes it must surely be put to death. Whoever does any work on that day must be cut off from among his people. ");
INSERT INTO engmsb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","For six days work may be done, but the seventh day is a Sabbath of complete rest, holy to the LORD. Whoever does any work on the Sabbath day must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","The Israelites must keep the Sabbath, celebrating it as a permanent covenant for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It is a sign between Me and the Israelites forever; for in six days the LORD made the heavens and the earth, but on the seventh day He rested and was refreshed.’” ");
INSERT INTO engmsb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When the LORD had finished speaking with Moses on Mount Sinai, He gave him the two tablets of the Testimony, tablets of stone inscribed by the finger of God. ");
INSERT INTO engmsb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Now when the people saw that Moses was delayed in coming down from the mountain, they gathered around Aaron and said, “Come, make us gods who will go before us. As for this Moses who brought us up out of the land of Egypt, we do not know what has happened to him!” ");
INSERT INTO engmsb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","So Aaron told them, “Take off the gold earrings that are on your wives and sons and daughters, and bring them to me.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Then all the people took off their gold earrings and brought them to Aaron. ");
INSERT INTO engmsb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He took the gold from their hands, and with an engraving tool he fashioned it into a molten calf. And they said, “These, O Israel, are your gods, who brought you up out of the land of Egypt!” ");
INSERT INTO engmsb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw this, he built an altar before the calf and proclaimed: “Tomorrow shall be a feast to the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","So the next day they arose, offered burnt offerings, and presented peace offerings. And the people sat down to eat and drink and got up to indulge in revelry. ");
INSERT INTO engmsb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Then the LORD said to Moses, “Go down at once, for your people, whom you brought up out of the land of Egypt, have corrupted themselves. ");
INSERT INTO engmsb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","How quickly they have turned aside from the way that I commanded them! They have made for themselves a molten calf and have bowed down to it. They have sacrificed to it and said, ‘These, O Israel, are your gods, who brought you up out of the land of Egypt.’” ");
INSERT INTO engmsb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","The LORD also said to Moses, “I have seen this people, and they are indeed a stiff-necked people. ");
INSERT INTO engmsb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now leave Me alone, so that My anger may burn against them and consume them. Then I will make you into a great nation.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses sought the favor of the LORD his God, saying, “O LORD, why does Your anger burn against Your people, whom You brought out of the land of Egypt with great power and a mighty hand? ");
INSERT INTO engmsb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians declare, ‘He brought them out with evil intent, to kill them in the mountains and wipe them from the face of the earth’? Turn from Your fierce anger and relent from doing harm to Your people. ");
INSERT INTO engmsb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Your servants Abraham, Isaac, and Israel, to whom You swore by Your very self when You declared, ‘I will make your descendants as numerous as the stars in the sky, and I will give your descendants all this land that I have promised, and it shall be their inheritance forever.’” ");
INSERT INTO engmsb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","So the LORD relented from the calamity He had threatened to bring on His people. ");
INSERT INTO engmsb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Then Moses turned and went down the mountain with the two tablets of the Testimony in his hands. They were inscribed on both sides, front and back. ");
INSERT INTO engmsb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","The tablets were the work of God, and the writing was the writing of God, engraved on the tablets. ");
INSERT INTO engmsb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","When Joshua heard the sound of the people shouting, he said to Moses, “The sound of war is in the camp.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","But Moses replied: “It is neither the cry of victory nor the cry of defeat; I hear the sound of singing!” ");
INSERT INTO engmsb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","As Moses approached the camp and saw the calf and the dancing, he burned with anger and threw the tablets out of his hands, shattering them at the base of the mountain. ");
INSERT INTO engmsb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Then he took the calf they had made, burned it in the fire, ground it to powder, and scattered the powder over the face of the water. Then he forced the Israelites to drink it. ");
INSERT INTO engmsb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","“What did this people do to you,” Moses asked Aaron, “that you have led them into so great a sin?” ");
INSERT INTO engmsb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“Do not be enraged, my lord,” Aaron replied. “You yourself know that the people are intent on evil. ");
INSERT INTO engmsb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","They told me, ‘Make us gods who will go before us. As for this Moses who brought us up out of the land of Egypt, we do not know what has happened to him!’ ");
INSERT INTO engmsb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I said to them, ‘Whoever has gold, let him take it off,’ and they gave it to me. And when I threw it into the fire, out came this calf!” ");
INSERT INTO engmsb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses saw that the people were out of control, for Aaron had let them run wild and become a laughingstock to their enemies. ");
INSERT INTO engmsb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","So Moses stood at the entrance to the camp and said, “Whoever is for the LORD, come to me.” And all the Levites gathered around him. ");
INSERT INTO engmsb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","He told them, “This is what the LORD, the God of Israel, says: ‘Each of you men is to fasten his sword to his side, go back and forth through the camp from gate to gate, and slay his brother, his friend, and his neighbor.’” ");
INSERT INTO engmsb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The Levites did as Moses commanded, and that day about three thousand of the people fell dead. ");
INSERT INTO engmsb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Afterward, Moses said, “Today you have been ordained for service to the LORD, since each man went against his son and his brother; so the LORD has bestowed a blessing on you this day.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The next day Moses said to the people, “You have committed a great sin. Now I will go up to the LORD; perhaps I can make atonement for your sin.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","So Moses returned to the LORD and said, “Oh, what a great sin these people have committed! They have made gods of gold for themselves. ");
INSERT INTO engmsb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Yet now, if You would only forgive their sin.... But if not, please blot me out of the book that You have written.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","The LORD replied to Moses, “Whoever has sinned against Me, I will blot out of My book. ");
INSERT INTO engmsb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Now go, lead the people to the place I described. Behold, My angel shall go before you. But on the day I settle accounts, I will punish them for their sin.” ");
INSERT INTO engmsb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","And the LORD sent a plague on the people because of what they had done with the calf that Aaron had made. ");
INSERT INTO engmsb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Then the LORD said to Moses, “Leave this place, you and the people you brought up out of the land of Egypt, and go to the land that I promised to Abraham, Isaac, and Jacob when I said, ‘I will give it to your descendants.’ ");
INSERT INTO engmsb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","And I will send an angel before you, and I will drive out the Canaanites, Amorites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engmsb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Go up to a land flowing with milk and honey. But I will not go with you, because you are a stiff-necked people; otherwise, I might destroy you on the way.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","When the people heard this bad news, they went into mourning, and no one put on any of his jewelry. ");
INSERT INTO engmsb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","For the LORD had said to Moses, “Tell the Israelites, ‘You are a stiff-necked people. If I should go with you for a single moment, I would destroy you. Now take off your jewelry, and I will decide what to do with you.’” ");
INSERT INTO engmsb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the Israelites stripped themselves of their jewelry from Mount Horeb onward. ");
INSERT INTO engmsb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Now Moses used to take the tent and pitch it at a distance outside the camp. He called it the Tent of Meeting, and anyone inquiring of the LORD would go to the Tent of Meeting outside the camp. ");
INSERT INTO engmsb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Then, whenever Moses went out to the tent, all the people would stand at the entrances to their own tents and watch Moses until he entered the tent. ");
INSERT INTO engmsb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","As Moses entered the tent, the pillar of cloud would come down and remain at the entrance, and the LORD would speak with Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","When all the people saw the pillar of cloud standing at the entrance to the tent, they would stand up and worship, each one at the entrance to his own tent. ");
INSERT INTO engmsb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Thus the LORD would speak to Moses face to face, as a man speaks to his friend. Then Moses would return to the camp, but his young assistant Joshua son of Nun would not leave the tent. ");
INSERT INTO engmsb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Then Moses said to the LORD, “Look, You have been telling me, ‘Lead this people up,’ but You have not let me know whom You will send with me. Yet You have said, ‘I know you by name, and you have found favor in My sight.’ ");
INSERT INTO engmsb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Now if indeed I have found favor in Your sight, please let me know Your ways, that I may know You and find favor in Your sight. Remember that this nation is Your people.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","And the LORD answered, “My Presence will go with you, and I will give you rest.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","“If Your Presence does not go with us,” Moses replied, “do not lead us up from here. ");
INSERT INTO engmsb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","For how then can it be known that Your people and I have found favor in Your sight, unless You go with us? How else will we be distinguished from all the other people on the face of the earth?” ");
INSERT INTO engmsb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","So the LORD said to Moses, “I will do this very thing you have asked, for you have found favor in My sight, and I know you by name.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Then Moses said, “Please show me Your glory.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","“I will cause all My goodness to pass before you,” the LORD replied, “and I will proclaim My name—the LORD—in your presence. I will have mercy on whom I have mercy, and I will have compassion on whom I have compassion.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But He added, “You cannot see My face, for no one can see Me and live.” ");
INSERT INTO engmsb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","The LORD continued, “There is a place near Me where you are to stand upon a rock, ");
INSERT INTO engmsb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","and when My glory passes by, I will put you in a cleft of the rock and cover you with My hand until I have passed by. ");
INSERT INTO engmsb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take My hand away, and you will see My back; but My face must not be seen.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Then the LORD said to Moses, “Chisel out two stone tablets like the originals, and I will write on them the words that were on the first tablets, which you broke. ");
INSERT INTO engmsb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Be ready in the morning, and come up on Mount Sinai to present yourself before Me on the mountaintop. ");
INSERT INTO engmsb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one may go up with you; in fact, no one may be seen anywhere on the mountain—not even the flocks or herds may graze in front of the mountain.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses chiseled out two stone tablets like the originals. He rose early in the morning, and taking the two stone tablets in his hands, he went up Mount Sinai as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","And the LORD descended in a cloud, stood with him there, and proclaimed His name, the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Then the LORD passed in front of Moses and called out: “The LORD, the LORD God, is compassionate and gracious, slow to anger, abounding in loving devotion and faithfulness, ");
INSERT INTO engmsb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","maintaining loving devotion to a thousand generations, forgiving iniquity, transgression, and sin. Yet He will by no means leave the guilty unpunished; He will visit the iniquity of the fathers on their children and grandchildren to the third and fourth generations.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses immediately bowed down to the ground and worshiped. ");
INSERT INTO engmsb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“O Lord,” he said, “if I have indeed found favor in Your sight, my Lord, please go with us. Although this is a stiff-necked people, forgive our iniquity and sin, and take us as Your inheritance.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","And the LORD said, “Behold, I am making a covenant. Before all your people I will perform wonders that have never been done in any nation in all the world. All the people among whom you live will see the LORD’s work, for it is an awesome thing that I am doing with you. ");
INSERT INTO engmsb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Observe what I command you this day. I will drive out before you the Amorites, Canaanites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engmsb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be careful not to make a treaty with the inhabitants of the land you are entering, lest they become a snare in your midst. ");
INSERT INTO engmsb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Rather, you must tear down their altars, smash their sacred stones, and chop down their Asherah poles. ");
INSERT INTO engmsb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","For you must not worship any other god, for the LORD, whose name is Jealous, is a jealous God. ");
INSERT INTO engmsb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Do not make a covenant with the inhabitants of the land, for when they prostitute themselves to their gods and sacrifice to them, they will invite you, and you will eat their sacrifices. ");
INSERT INTO engmsb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","And when you take some of their daughters as brides for your sons, their daughters will prostitute themselves to their gods and cause your sons to do the same. ");
INSERT INTO engmsb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","You shall make no molten gods for yourselves. ");
INSERT INTO engmsb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","You are to keep the Feast of Unleavened Bread. For seven days at the appointed time in the month of Abib, you are to eat unleavened bread as I commanded you. For in the month of Abib you came out of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","The first offspring of every womb belongs to Me, including all the firstborn males among your livestock, whether cattle or sheep. ");
INSERT INTO engmsb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","You must redeem the firstborn of a donkey with a lamb; but if you do not redeem it, you are to break its neck. You must redeem all the firstborn of your sons. No one shall appear before Me empty-handed. ");
INSERT INTO engmsb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Six days you shall labor, but on the seventh day you shall rest; even in the seasons of plowing and harvesting, you must rest. ");
INSERT INTO engmsb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","And you are to celebrate the Feast of Weeks with the firstfruits of the wheat harvest, and the Feast of Ingathering at the turn of the year. ");
INSERT INTO engmsb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times a year all your males are to appear before the Lord GOD, the God of Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","For I will drive out the nations before you and enlarge your borders, and no one will covet your land when you go up three times a year to appear before the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Do not offer the blood of a sacrifice to Me along with anything leavened, and do not let any of the sacrifice from the Passover Feast remain until morning. ");
INSERT INTO engmsb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Bring the best of the firstfruits of your soil to the house of the LORD your God. You must not cook a young goat in its mother’s milk.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","The LORD also said to Moses, “Write down these words, for in accordance with these words I have made a covenant with you and with Israel.” ");
INSERT INTO engmsb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","So Moses was there with the LORD forty days and forty nights without eating bread or drinking water. He wrote on the tablets the words of the covenant—the Ten Commandments. ");
INSERT INTO engmsb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","And when Moses came down from Mount Sinai with the two tablets of the Testimony in his hands, he was unaware that his face had become radiant from speaking with the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron and all the Israelites looked at Moses, and behold, his face was radiant. And they were afraid to approach him. ");
INSERT INTO engmsb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses called out to them; so Aaron and all the leaders of the congregation returned to him, and Moses spoke to them. ");
INSERT INTO engmsb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","And after this all the Israelites came near, and Moses commanded them to do everything that the LORD had told him on Mount Sinai. ");
INSERT INTO engmsb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses had finished speaking with them, he put a veil over his face. ");
INSERT INTO engmsb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","But whenever Moses went in before the LORD to speak with Him, he would remove the veil until he came out. And when he came out, he would tell the Israelites what he had been commanded, ");
INSERT INTO engmsb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","and the Israelites would see that the face of Moses was radiant. So Moses would put the veil back over his face until he went in to speak with the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Then Moses assembled the whole congregation of Israel and said to them, “These are the things that the LORD has commanded you to do: ");
INSERT INTO engmsb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","For six days work may be done, but the seventh day shall be your holy day, a Sabbath of complete rest to the LORD. Whoever does any work on that day must be put to death. ");
INSERT INTO engmsb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Do not light a fire in any of your dwellings on the Sabbath day.” ");
INSERT INTO engmsb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses also told the whole congregation of Israel, “This is what the LORD has commanded: ");
INSERT INTO engmsb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Take from among you an offering to the LORD. Let everyone whose heart is willing bring an offering to the LORD: gold, silver, and bronze; ");
INSERT INTO engmsb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, and scarlet yarn; fine linen and goat hair; ");
INSERT INTO engmsb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ram skins dyed red and fine leather; acacia wood; ");
INSERT INTO engmsb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olive oil for the light; spices for the anointing oil and for the fragrant incense; ");
INSERT INTO engmsb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","and onyx stones and gemstones to be mounted on the ephod and breastpiece. ");
INSERT INTO engmsb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Let every skilled craftsman among you come and make everything that the LORD has commanded: ");
INSERT INTO engmsb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the tabernacle with its tent and covering, its clasps and frames, its crossbars, posts, and bases; ");
INSERT INTO engmsb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the ark with its poles and mercy seat, and the veil to shield it; ");
INSERT INTO engmsb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table with its poles, all its utensils, and the Bread of the Presence; ");
INSERT INTO engmsb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand for light with its accessories and lamps and oil for the light; ");
INSERT INTO engmsb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","the altar of incense with its poles; the anointing oil and fragrant incense; the curtain for the doorway at the entrance to the tabernacle; ");
INSERT INTO engmsb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar of burnt offering with its bronze grate, its poles, and all its utensils; the basin with its stand; ");
INSERT INTO engmsb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the curtains of the courtyard with its posts and bases, and the curtain for the gate of the courtyard; ");
INSERT INTO engmsb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","the tent pegs for the tabernacle and for the courtyard, along with their ropes; ");
INSERT INTO engmsb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","and the woven garments for ministering in the holy place—both the holy garments for Aaron the priest and the garments for his sons to serve as priests.” ");
INSERT INTO engmsb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Then the whole congregation of Israel withdrew from the presence of Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","And everyone whose heart stirred him and whose spirit prompted him came and brought an offering to the LORD for the work on the Tent of Meeting, for all its services, and for the holy garments. ");
INSERT INTO engmsb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","So all who had willing hearts, both men and women, came and brought brooches and earrings, rings and necklaces, and all kinds of gold jewelry. And they all presented their gold as a wave offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone who had blue, purple, or scarlet yarn, or fine linen, goat hair, ram skins dyed red, or articles of fine leather, brought them. ");
INSERT INTO engmsb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","And all who could present an offering of silver or bronze brought it as a contribution to the LORD. Also, everyone who had acacia wood for any part of the service brought it. ");
INSERT INTO engmsb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Every skilled woman spun with her hands and brought what she had spun: blue, purple, or scarlet yarn, or fine linen. ");
INSERT INTO engmsb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And all the skilled women whose hearts were stirred spun the goat hair. ");
INSERT INTO engmsb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The leaders brought onyx stones and gemstones to mount on the ephod and breastpiece, ");
INSERT INTO engmsb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","as well as spices and olive oil for the light, for the anointing oil, and for the fragrant incense. ");
INSERT INTO engmsb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","So all the men and women of the Israelites whose hearts prompted them brought a freewill offering to the LORD for all the work that the LORD through Moses had commanded them to do. ");
INSERT INTO engmsb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Then Moses said to the Israelites, “See, the LORD has called by name Bezalel son of Uri, the son of Hur, of the tribe of Judah. ");
INSERT INTO engmsb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","And He has filled him with the Spirit of God, with skill, ability, and knowledge in all kinds of craftsmanship, ");
INSERT INTO engmsb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","to design artistic works in gold, silver, and bronze, ");
INSERT INTO engmsb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","to cut gemstones for settings, and to carve wood, so that he may be a master of every artistic craft. ");
INSERT INTO engmsb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","And the LORD has given both him and Oholiab son of Ahisamach, of the tribe of Dan, the ability to teach others. ");
INSERT INTO engmsb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has filled them with skill to do all kinds of work as engravers, designers, embroiderers in blue, purple, and scarlet yarn and fine linen, and as weavers—as artistic designers of every kind of craft. ");
INSERT INTO engmsb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“So Bezalel, Oholiab, and every skilled person are to carry out everything commanded by the LORD, who has given them skill and ability to know how to perform all the work of constructing the sanctuary.” ");
INSERT INTO engmsb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Then Moses summoned Bezalel, Oholiab, and every skilled person whom the LORD had gifted—everyone whose heart stirred him to come and do the work. ");
INSERT INTO engmsb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","They received from Moses all the contributions that the Israelites had brought to carry out the service of constructing the sanctuary. Meanwhile, the people continued to bring freewill offerings morning after morning, ");
INSERT INTO engmsb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","so that all the skilled craftsmen who were doing all the work on the sanctuary left their work ");
INSERT INTO engmsb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","and said to Moses, “The people are bringing more than enough for doing the work the LORD has commanded us to do.” ");
INSERT INTO engmsb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","After Moses had given an order, they sent a proclamation throughout the camp: “No man or woman should make anything else as an offering for the sanctuary.” So the people were restrained from bringing more, ");
INSERT INTO engmsb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","since what they already had was more than enough to perform all the work. ");
INSERT INTO engmsb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","All the skilled craftsmen among the workmen made the ten curtains for the tabernacle. They were made of finely spun linen, as well as blue, purple, and scarlet yarn, with cherubim skillfully worked into them. ");
INSERT INTO engmsb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Each curtain was twenty-eight cubits long and four cubits wide; all the curtains were the same size. ");
INSERT INTO engmsb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","And he joined five of the curtains together, and the other five he joined as well. ");
INSERT INTO engmsb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","He made loops of blue material on the edge of the end curtain in the first set, and also on the end curtain in the second set. ");
INSERT INTO engmsb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","He made fifty loops on one curtain and fifty loops on the end curtain of the second set, so that the loops lined up opposite one another. ");
INSERT INTO engmsb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","He also made fifty gold clasps to join the curtains together, so that the tabernacle was a unit. ");
INSERT INTO engmsb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","He then made curtains of goat hair for the tent over the tabernacle—eleven curtains in all. ");
INSERT INTO engmsb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Each of the eleven curtains was the same size—thirty cubits long and four cubits wide. ");
INSERT INTO engmsb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","He joined five of the curtains into one set and the other six into another. ");
INSERT INTO engmsb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","He made fifty loops along the edge of the end curtain in the first set, and fifty loops along the edge of the corresponding curtain in the second set. ");
INSERT INTO engmsb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","He also made fifty bronze clasps to join the tent together as a unit. ");
INSERT INTO engmsb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Additionally, he made for the tent a covering of ram skins dyed red, and over that a covering of fine leather. ");
INSERT INTO engmsb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Next, he constructed upright frames of acacia wood for the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Each frame was ten cubits long and a cubit and a half wide. ");
INSERT INTO engmsb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Two tenons were connected to each other for each frame. He made all the frames of the tabernacle in this way. ");
INSERT INTO engmsb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","He constructed twenty frames for the south side of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","with forty silver bases to put under the twenty frames—two bases for each frame, one under each tenon. ");
INSERT INTO engmsb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","For the second side of the tabernacle, the north side, he made twenty frames ");
INSERT INTO engmsb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and forty silver bases—two bases under each frame. ");
INSERT INTO engmsb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","He made six frames for the rear of the tabernacle, the west side, ");
INSERT INTO engmsb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","and two frames for the two back corners of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","coupled together from bottom to top and fitted into a single ring. He made both corners in this way. ");
INSERT INTO engmsb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","So there were eight frames and sixteen silver bases—two under each frame. ");
INSERT INTO engmsb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","He also made five crossbars of acacia wood for the frames on one side of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","five for those on the other side, and five for those on the rear side of the tabernacle, to the west. ");
INSERT INTO engmsb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","He made the central crossbar to run through the center of the frames, from one end to the other. ");
INSERT INTO engmsb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","And he overlaid the frames with gold and made gold rings to hold the crossbars. He also overlaid the crossbars with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Next, he made the veil of blue, purple, and scarlet yarn, and finely spun linen, with cherubim skillfully worked into it. ");
INSERT INTO engmsb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","He also made four posts of acacia wood for it and overlaid them with gold, along with gold hooks; and he cast four silver bases for the posts. ");
INSERT INTO engmsb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","For the entrance to the tent, he made a curtain embroidered with blue, purple, and scarlet yarn, and finely spun linen, ");
INSERT INTO engmsb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","together with five posts and their hooks. He overlaid the tops of the posts and their bands with gold, and their five bases were bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel went on to construct the ark of acacia wood, two and a half cubits long, a cubit and a half wide, and a cubit and a half high. ");
INSERT INTO engmsb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He overlaid it with pure gold, both inside and out, and made a gold molding around it. ");
INSERT INTO engmsb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","And he cast four gold rings for its four feet, two rings on one side and two on the other. ");
INSERT INTO engmsb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Then he made poles of acacia wood and overlaid them with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He inserted the poles into the rings on the sides of the ark in order to carry it. ");
INSERT INTO engmsb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He constructed a mercy seat of pure gold, two and a half cubits long and a cubit and a half wide. ");
INSERT INTO engmsb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","He made two cherubim of hammered gold at the ends of the mercy seat, ");
INSERT INTO engmsb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","one cherub on one end and one on the other, all made from one piece of gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","And the cherubim had wings that spread upward, overshadowing the mercy seat. The cherubim faced each other, looking toward the mercy seat. ");
INSERT INTO engmsb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","He also made the table of acacia wood two cubits long, a cubit wide, and a cubit and a half high. ");
INSERT INTO engmsb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He overlaid it with pure gold and made a gold molding around it. ");
INSERT INTO engmsb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","And he made a rim around it a handbreadth wide and put a gold molding on the rim. ");
INSERT INTO engmsb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He cast four gold rings for the table and fastened them to the four corners at its four legs. ");
INSERT INTO engmsb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were placed close to the rim, to serve as holders for the poles used to carry the table. ");
INSERT INTO engmsb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made the poles of acacia wood for carrying the table and overlaid them with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He also made the utensils for the table out of pure gold: its plates and dishes, as well as its bowls and pitchers for pouring drink offerings. ");
INSERT INTO engmsb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Then he made the lampstand out of pure hammered gold, all of one piece: its base and shaft, its cups, and its buds and petals. ");
INSERT INTO engmsb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches extended from the sides, three on one side and three on the other. ");
INSERT INTO engmsb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","There were three cups shaped like almond blossoms on the first branch, each with buds and petals, three on the next branch, and the same for all six branches that extended from the lampstand. ");
INSERT INTO engmsb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","And on the lampstand were four cups shaped like almond blossoms with buds and petals. ");
INSERT INTO engmsb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","A bud was under the first pair of branches that extended from the lampstand, a bud under the second pair, and a bud under the third pair. ");
INSERT INTO engmsb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","The buds and branches were all of one piece with the lampstand, hammered out of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","He also made its seven lamps, its wick trimmers, and trays of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He made the lampstand and all its utensils from a talent of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","He made the altar of incense out of acacia wood. It was square, a cubit long, a cubit wide, and two cubits high. Its horns were of one piece. ");
INSERT INTO engmsb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","And he overlaid with pure gold the top and all the sides and horns. Then he made a molding of gold around it. ");
INSERT INTO engmsb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two gold rings below the molding on opposite sides to hold the poles used to carry it. ");
INSERT INTO engmsb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","And he made the poles of acacia wood and overlaid them with gold. ");
INSERT INTO engmsb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He also made the sacred anointing oil and the pure, fragrant incense, the work of a perfumer. ");
INSERT INTO engmsb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel constructed the altar of burnt offering from acacia wood. It was square, five cubits long, five cubits wide, and three cubits high. ");
INSERT INTO engmsb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made a horn at each of its four corners, so that the horns and altar were of one piece, and he overlaid the altar with bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He made all the altar’s utensils of bronze—its pots, shovels, sprinkling bowls, meat forks, and firepans. ");
INSERT INTO engmsb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","He made a grate of bronze mesh for the altar under its ledge, halfway up from the bottom. ");
INSERT INTO engmsb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","At the four corners of the bronze grate he cast four rings as holders for the poles. ");
INSERT INTO engmsb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","And he made the poles of acacia wood and overlaid them with bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Then he inserted the poles into the rings on the sides of the altar for carrying it. He made the altar with boards so that it was hollow. ");
INSERT INTO engmsb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Next he made the bronze basin and its stand from the mirrors of the women who served at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Then he constructed the courtyard. The south side of the courtyard was a hundred cubits long and had curtains of finely spun linen, ");
INSERT INTO engmsb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","with twenty posts and twenty bronze bases, and with silver hooks and bands on the posts. ");
INSERT INTO engmsb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","The north side was also a hundred cubits long, with twenty posts and twenty bronze bases. The hooks and bands of the posts were silver. ");
INSERT INTO engmsb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","The west side was fifty cubits long and had curtains, with ten posts and ten bases. The hooks and bands of the posts were silver. ");
INSERT INTO engmsb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","And the east side, toward the sunrise, was also fifty cubits long. ");
INSERT INTO engmsb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","The curtains on one side of the entrance were fifteen cubits long, with three posts and three bases. ");
INSERT INTO engmsb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","And the curtains on the other side were also fifteen cubits long, with three posts and three bases as well. ");
INSERT INTO engmsb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the curtains around the courtyard were made of finely spun linen. ");
INSERT INTO engmsb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The bases for the posts were bronze, the hooks and bands were silver, and the plating for the tops of the posts was silver. So all the posts of the courtyard were banded with silver. ");
INSERT INTO engmsb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The curtain for the entrance to the courtyard was embroidered with blue, purple, and scarlet yarn, and finely spun linen. It was twenty cubits long and, like the curtains of the courtyard, five cubits high, ");
INSERT INTO engmsb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","with four posts and four bronze bases. Their hooks were silver, as well as the bands and the plating of their tops. ");
INSERT INTO engmsb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs for the tabernacle and for the surrounding courtyard were bronze. ");
INSERT INTO engmsb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","This is the inventory for the tabernacle, the tabernacle of the Testimony, as recorded at Moses’ command by the Levites under the direction of Ithamar son of Aaron the priest. ");
INSERT INTO engmsb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel son of Uri, the son of Hur, of the tribe of Judah, made everything that the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","With him was Oholiab son of Ahisamach, of the tribe of Dan, an engraver, designer, and embroiderer in blue, purple, and scarlet yarn and fine linen. ");
INSERT INTO engmsb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","All the gold from the wave offering used for the work on the sanctuary totaled 29 talents and 730 shekels, according to the sanctuary shekel. ");
INSERT INTO engmsb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","The silver from those numbered among the congregation totaled 100 talents and 1,775 shekels, according to the sanctuary shekel— ");
INSERT INTO engmsb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","a beka per person, that is, half a shekel, according to the sanctuary shekel, from everyone twenty years of age or older who had crossed over to be numbered, a total of 603,550 men. ");
INSERT INTO engmsb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","The hundred talents of silver were used to cast the bases of the sanctuary and the bases of the veil—100 bases from the 100 talents, one talent per base. ");
INSERT INTO engmsb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","With the 1,775 shekels of silver he made the hooks for the posts, overlaid their tops, and supplied bands for them. ");
INSERT INTO engmsb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The bronze from the wave offering totaled 70 talents and 2,400 shekels. ");
INSERT INTO engmsb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","He used it to make the bases for the entrance to the Tent of Meeting, the bronze altar and its bronze grating, all the utensils for the altar, ");
INSERT INTO engmsb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the bases for the surrounding courtyard and its gate, and all the tent pegs for the tabernacle and its surrounding courtyard. ");
INSERT INTO engmsb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","From the blue, purple, and scarlet yarn they made specially woven garments for ministry in the sanctuary, as well as the holy garments for Aaron, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezalel made the ephod of finely spun linen embroidered with gold, and with blue, purple, and scarlet yarn. ");
INSERT INTO engmsb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They hammered out thin sheets of gold and cut threads from them to interweave with the blue, purple, and scarlet yarn, and fine linen—the work of a skilled craftsman. ");
INSERT INTO engmsb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made shoulder pieces for the ephod, which were attached at two of its corners, so it could be fastened. ");
INSERT INTO engmsb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","And the skillfully woven waistband of the ephod was of one piece with the ephod, of the same workmanship—with gold, with blue, purple, and scarlet yarn, and with finely spun linen, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They mounted the onyx stones in gold filigree settings, engraved like a seal with the names of the sons of Israel. ");
INSERT INTO engmsb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Then they fastened them on the shoulder pieces of the ephod as memorial stones for the sons of Israel, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","He made the breastpiece with the same workmanship as the ephod, with gold, with blue, purple, and scarlet yarn, and with finely spun linen. ");
INSERT INTO engmsb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square when folded over double, a span long and a span wide. ");
INSERT INTO engmsb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","And they mounted on it four rows of gemstones: The first row had a ruby, a topaz, and an emerald; ");
INSERT INTO engmsb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","the second row had a turquoise, a sapphire, and a diamond; ");
INSERT INTO engmsb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","the third row had a jacinth, an agate, and an amethyst; ");
INSERT INTO engmsb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","and the fourth row had a beryl, an onyx, and a jasper. These stones were mounted in gold filigree settings. ");
INSERT INTO engmsb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","The twelve stones corresponded to the names of the sons of Israel. Each stone was engraved like a seal with the name of one of the twelve tribes. ");
INSERT INTO engmsb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","For the breastpiece they made braided chains like cords of pure gold. ");
INSERT INTO engmsb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","They also made two gold filigree settings and two gold rings, and fastened the two rings to the two corners of the breastpiece. ");
INSERT INTO engmsb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Then they fastened the two gold chains to the two gold rings at the corners of the breastpiece, ");
INSERT INTO engmsb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","and they fastened the other ends of the two chains to the two filigree settings, attaching them to the shoulder pieces of the ephod at the front. ");
INSERT INTO engmsb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","They made two more gold rings and attached them to the other two corners of the breastpiece, on the inside edge next to the ephod. ");
INSERT INTO engmsb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two additional gold rings and attached them to the bottom of the two shoulder pieces of the ephod, on its front, near the seam just above its woven waistband. ");
INSERT INTO engmsb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Then they tied the rings of the breastpiece to the rings of the ephod with a cord of blue yarn, so that the breastpiece was above the waistband of the ephod and would not swing out from the ephod, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","They made the robe of the ephod entirely of blue cloth, the work of a weaver, ");
INSERT INTO engmsb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","with an opening in the center of the robe like that of a garment, with a collar around the opening so that it would not tear. ");
INSERT INTO engmsb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","They made pomegranates of blue, purple, and scarlet yarn and finely spun linen on the lower hem of the robe. ");
INSERT INTO engmsb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","They also made bells of pure gold and attached them around the hem between the pomegranates, ");
INSERT INTO engmsb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","alternating the bells and pomegranates around the lower hem of the robe to be worn for ministry, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","For Aaron and his sons they made tunics of fine linen, the work of a weaver, ");
INSERT INTO engmsb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","as well as the turban of fine linen, the ornate headbands and undergarments of finely spun linen, ");
INSERT INTO engmsb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","and the sash of finely spun linen, embroidered with blue, purple, and scarlet yarn, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They also made the plate of the holy crown of pure gold, and they engraved on it, like an inscription on a seal: HOLY TO THE LORD. ");
INSERT INTO engmsb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Then they fastened to it a blue cord to mount it on the turban, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So all the work for the tabernacle, the Tent of Meeting, was completed. The Israelites did everything just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Then they brought the tabernacle to Moses: the tent with all its furnishings, its clasps, its frames, its crossbars, and its posts and bases; ");
INSERT INTO engmsb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","the covering of ram skins dyed red, the covering of fine leather, and the veil of the covering; ");
INSERT INTO engmsb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the ark of the Testimony with its poles and the mercy seat; ");
INSERT INTO engmsb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table with all its utensils and the Bread of the Presence; ");
INSERT INTO engmsb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the pure gold lampstand with its row of lamps and all its utensils, as well as the oil for the light; ");
INSERT INTO engmsb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","the gold altar, the anointing oil, the fragrant incense, and the curtain for the entrance to the tent; ");
INSERT INTO engmsb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar with its bronze grating, its poles, and all its utensils; the basin with its stand; ");
INSERT INTO engmsb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the curtains of the courtyard with its posts and bases; the curtain for the gate of the courtyard, its ropes and tent pegs, and all the equipment for the service of the tabernacle, the Tent of Meeting; ");
INSERT INTO engmsb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","and the woven garments for ministering in the sanctuary, both the holy garments for Aaron the priest and the garments for his sons to serve as priests. ");
INSERT INTO engmsb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The Israelites had done all the work just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","And Moses inspected all the work and saw that they had accomplished it just as the LORD had commanded. So Moses blessed them. ");
INSERT INTO engmsb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month you are to set up the tabernacle, the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Put the ark of the Testimony in it and screen off the ark with the veil. ");
INSERT INTO engmsb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Then bring in the table and set out its arrangement; bring in the lampstand as well, and set up its lamps. ");
INSERT INTO engmsb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Place the gold altar of incense in front of the ark of the Testimony, and hang the curtain at the entrance to the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Place the altar of burnt offering in front of the entrance to the tabernacle, the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","And place the basin between the Tent of Meeting and the altar, and put water in it. ");
INSERT INTO engmsb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Set up the surrounding courtyard and hang the curtain for the entrance to the courtyard. ");
INSERT INTO engmsb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Take the anointing oil and anoint the tabernacle and everything in it; consecrate it along with all its furnishings, and it shall be holy. ");
INSERT INTO engmsb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Anoint the altar of burnt offering and all its utensils; consecrate the altar, and it shall be most holy. ");
INSERT INTO engmsb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Anoint the basin and its stand and consecrate them. ");
INSERT INTO engmsb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Then bring Aaron and his sons to the entrance to the Tent of Meeting and wash them with water. ");
INSERT INTO engmsb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","And you are to clothe Aaron with the holy garments, anoint him, and consecrate him, so that he may serve Me as a priest. ");
INSERT INTO engmsb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Bring his sons forward and clothe them with tunics. ");
INSERT INTO engmsb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Anoint them just as you anointed their father, so that they may also serve Me as priests. Their anointing will qualify them for a permanent priesthood throughout their generations.” ");
INSERT INTO engmsb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses did everything just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","So the tabernacle was set up on the first day of the first month of the second year. ");
INSERT INTO engmsb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","When Moses set up the tabernacle, he laid its bases, positioned its frames, inserted its crossbars, and set up its posts. ");
INSERT INTO engmsb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Then he spread the tent over the tabernacle and put the covering over the tent, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Moses took the Testimony and placed it in the ark, attaching the poles to the ark; and he set the mercy seat atop the ark. ");
INSERT INTO engmsb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Then he brought the ark into the tabernacle, put up the veil for the screen, and shielded off the ark of the Testimony, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Moses placed the table in the Tent of Meeting on the north side of the tabernacle, outside the veil. ");
INSERT INTO engmsb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","He arranged the bread on it before the LORD, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","He also placed the lampstand in the Tent of Meeting opposite the table on the south side of the tabernacle ");
INSERT INTO engmsb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","and set up the lamps before the LORD, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Moses placed the gold altar in the Tent of Meeting, in front of the veil, ");
INSERT INTO engmsb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and he burned fragrant incense on it, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Then he put up the curtain at the entrance to the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","He placed the altar of burnt offering near the entrance to the tabernacle, the Tent of Meeting, and offered on it the burnt offering and the grain offering, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","He placed the basin between the Tent of Meeting and the altar and put water in it for washing; ");
INSERT INTO engmsb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","and from it Moses, Aaron, and his sons washed their hands and feet. ");
INSERT INTO engmsb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","They washed whenever they entered the Tent of Meeting or approached the altar, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","And Moses set up the courtyard around the tabernacle and the altar, and he hung the curtain for the entrance to the courtyard. So Moses finished the work. ");
INSERT INTO engmsb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the Tent of Meeting, and the glory of the LORD filled the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses was unable to enter the Tent of Meeting because the cloud had settled on it, and the glory of the LORD filled the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Whenever the cloud was lifted from above the tabernacle, the Israelites would set out through all the stages of their journey. ");
INSERT INTO engmsb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","If the cloud was not lifted, they would not set out until the day it was taken up. ");
INSERT INTO engmsb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","For the cloud of the LORD was over the tabernacle by day, and fire was in the cloud by night, in the sight of all the house of Israel through all their journeys. ");
INSERT INTO engmsb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Then the LORD called to Moses and spoke to him from the Tent of Meeting, saying, ");
INSERT INTO engmsb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Speak to the Israelites and tell them: When any of you brings an offering to the LORD, you may bring as your offering an animal from the herd or the flock. ");
INSERT INTO engmsb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If his offering is a burnt offering from the herd, he is to present an unblemished male. He must bring it to the entrance to the Tent of Meeting for its acceptance before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","He is to lay his hand on the head of the burnt offering, so it can be accepted on his behalf to make atonement for him. ");
INSERT INTO engmsb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","And he shall slaughter the young bull before the LORD, and Aaron’s sons the priests are to present the blood and splatter it on all sides of the altar at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Next, he is to skin the burnt offering and cut it into pieces. ");
INSERT INTO engmsb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","The sons of Aaron the priest shall put a fire on the altar and arrange wood on the fire. ");
INSERT INTO engmsb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Then Aaron’s sons the priests are to arrange the pieces, including the head and the fat, atop the burning wood on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","The entrails and legs must be washed with water, and the priest shall burn all of it on the altar as a burnt offering, a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","If, however, one’s offering is a burnt offering from the flock—from the sheep or goats—he is to present an unblemished male. ");
INSERT INTO engmsb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He shall slaughter it on the north side of the altar before the LORD, and Aaron’s sons the priests are to splatter its blood against the altar on all sides. ");
INSERT INTO engmsb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","He is to cut the animal into pieces, and the priest shall arrange them, including the head and fat, atop the burning wood that is on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","The entrails and legs must be washed with water, and the priest shall present all of it and burn it on the altar; it is a burnt offering, a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","If, instead, one’s offering to the LORD is a burnt offering of birds, he is to present a turtledove or a young pigeon. ");
INSERT INTO engmsb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Then the priest shall bring it to the altar, twist off its head, and burn it on the altar; its blood should be drained out on the side of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","And he is to remove the crop with its contents and throw it to the east side of the altar, in the place for ashes. ");
INSERT INTO engmsb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","He shall tear it open by its wings, without dividing the bird completely. And the priest is to burn it on the altar atop the burning wood. It is a burnt offering, a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“When anyone brings a grain offering to the LORD, his offering must consist of fine flour. He is to pour olive oil on it, put frankincense on it, ");
INSERT INTO engmsb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","and bring it to Aaron’s sons the priests. The priest shall take a handful of the flour and oil, together with all the frankincense, and burn this as a memorial portion on the altar, a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","The remainder of the grain offering shall belong to Aaron and his sons; it is a most holy part of the food offerings to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Now if you bring an offering of grain baked in an oven, it must consist of fine flour, either unleavened cakes mixed with oil or unleavened wafers coated with oil. ");
INSERT INTO engmsb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your offering is a grain offering prepared on a griddle, it must be unleavened bread made of fine flour mixed with oil. ");
INSERT INTO engmsb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Crumble it and pour oil on it; it is a grain offering. ");
INSERT INTO engmsb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your offering is a grain offering cooked in a pan, it must consist of fine flour with oil. ");
INSERT INTO engmsb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","When you bring to the LORD the grain offering made in any of these ways, it is to be presented to the priest, and he shall take it to the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","The priest is to remove the memorial portion from the grain offering and burn it on the altar as a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","But the remainder of the grain offering shall belong to Aaron and his sons; it is a most holy part of the food offerings to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No grain offering that you present to the LORD may be made with leaven, for you are not to burn any leaven or honey as a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You may bring them to the LORD as an offering of firstfruits, but they must not go up on the altar as a pleasing aroma. ");
INSERT INTO engmsb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","And you shall season each of your grain offerings with salt. You must not leave the salt of the covenant of your God out of your grain offering; you are to add salt to each of your offerings. ");
INSERT INTO engmsb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","If you bring a grain offering of firstfruits to the LORD, you shall offer crushed heads of new grain roasted on the fire. ");
INSERT INTO engmsb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","And you are to put oil and frankincense on it; it is a grain offering. ");
INSERT INTO engmsb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","The priest shall then burn the memorial portion of the crushed grain and the oil, together with all its frankincense, as a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“If one’s offering is a peace offering and he offers an animal from the herd, whether male or female, he must present it without blemish before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","He is to lay his hand on the head of the offering and slaughter it at the entrance to the Tent of Meeting. Then Aaron’s sons the priests shall splatter the blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","From the peace offering he is to bring a food offering to the LORD: the fat that covers the entrails, all the fat that is on them, ");
INSERT INTO engmsb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","both kidneys with the fat on them near the loins, and the lobe of the liver, which he is to remove with the kidneys. ");
INSERT INTO engmsb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Then Aaron’s sons are to burn it on the altar atop the burnt offering that is on the burning wood, as a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","If, however, one’s peace offering to the LORD is from the flock, he must present a male or female without blemish. ");
INSERT INTO engmsb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If he is presenting a lamb for his offering, he must present it before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","He is to lay his hand on the head of his offering and slaughter it in front of the Tent of Meeting. Then Aaron’s sons shall splatter its blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","And from the peace offering he shall bring a food offering to the LORD consisting of its fat: the entire fat tail cut off close to the backbone, the fat that covers the entrails, all the fat that is on them, ");
INSERT INTO engmsb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","both kidneys with the fat on them near the loins, and the lobe of the liver, which he is to remove with the kidneys. ");
INSERT INTO engmsb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Then the priest is to burn them on the altar as food, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","If one’s offering is a goat, he is to present it before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","He must lay his hand on its head and slaughter it in front of the Tent of Meeting. Then Aaron’s sons shall splatter its blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","And from his offering he shall present a food offering to the LORD: the fat that covers the entrails, all the fat that is on them, ");
INSERT INTO engmsb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","both kidneys with the fat on them near the loins, and the lobe of the liver, which he is to remove with the kidneys. ");
INSERT INTO engmsb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Then the priest is to burn the food on the altar as a food offering, a pleasing aroma. All the fat is the LORD’s. ");
INSERT INTO engmsb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","This is a permanent statute for the generations to come, wherever you live: You must not eat any fat or any blood.” ");
INSERT INTO engmsb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tell the Israelites to do as follows with one who sins unintentionally against any of the LORD’s commandments and does what is forbidden by them: ");
INSERT INTO engmsb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If the anointed priest sins, bringing guilt on the people, he must bring to the LORD a young bull without blemish as a sin offering for the sin he has committed. ");
INSERT INTO engmsb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He must bring the bull to the entrance to the Tent of Meeting before the LORD, lay his hand on the bull’s head, and slaughter it before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Then the anointed priest shall take some of the bull’s blood and bring it into the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","The priest is to dip his finger in the blood and sprinkle some of it seven times before the LORD, in front of the veil of the sanctuary. ");
INSERT INTO engmsb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","The priest must then put some of the blood on the horns of the altar of fragrant incense that is before the LORD in the Tent of Meeting. And he is to pour out the rest of the bull’s blood at the base of the altar of burnt offering at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Then he shall remove all the fat from the bull of the sin offering—the fat that covers the entrails, all the fat that is on them, ");
INSERT INTO engmsb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","both kidneys with the fat on them near the loins, and the lobe of the liver, which he is to remove with the kidneys— ");
INSERT INTO engmsb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","just as the fat is removed from the ox of the peace offering. Then the priest shall burn them on the altar of burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","But the hide of the bull and all its flesh, with its head and legs and its entrails and dung— ");
INSERT INTO engmsb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","all the rest of the bull—he must take outside the camp to a ceremonially clean place where the ashes are poured out, and there he must burn it on a wood fire on the ash heap. ");
INSERT INTO engmsb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Now if the whole congregation of Israel strays unintentionally and the matter escapes the notice of the assembly so that they violate any of the LORD’s commandments and incur guilt by doing what is forbidden, ");
INSERT INTO engmsb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","when they become aware of the sin they have committed, then the assembly must bring a young bull as a sin offering and present it before the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders of the congregation are to lay their hands on the bull’s head before the LORD, and it shall be slaughtered before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Then the anointed priest is to bring some of the bull’s blood into the Tent of Meeting, ");
INSERT INTO engmsb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","and he is to dip his finger in the blood and sprinkle it seven times before the LORD in front of the veil. ");
INSERT INTO engmsb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He is also to put some of the blood on the horns of the altar that is before the LORD in the Tent of Meeting, and he must pour out the rest of the blood at the base of the altar of burnt offering at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","And he is to remove all the fat from it and burn it on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He shall offer this bull just as he did the bull for the sin offering; in this way the priest will make atonement on their behalf, and they will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Then he is to take the bull outside the camp and burn it, just as he burned the first bull. It is the sin offering for the assembly. ");
INSERT INTO engmsb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","When a leader sins unintentionally and does what is prohibited by any of the commandments of the LORD his God, he incurs guilt. ");
INSERT INTO engmsb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","When he becomes aware of the sin he has committed, he must bring an unblemished male goat as his offering. ");
INSERT INTO engmsb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He is to lay his hand on the head of the goat and slaughter it at the place where the burnt offering is slaughtered before the LORD. It is a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Then the priest is to take some of the blood of the sin offering with his finger, put it on the horns of the altar of burnt offering, and pour out the rest of the blood at the base of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","He must burn all its fat on the altar, like the fat of the peace offerings; thus the priest will make atonement for that man’s sin, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","And if one of the common people sins unintentionally and does what is prohibited by any of the LORD’s commandments, he incurs guilt. ");
INSERT INTO engmsb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","When he becomes aware of the sin he has committed, he must bring an unblemished female goat as his offering for that sin. ");
INSERT INTO engmsb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He is to lay his hand on the head of the sin offering and slaughter it at the place of the burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Then the priest is to take some of its blood with his finger, put it on the horns of the altar of burnt offering, and pour out the rest of the blood at the base of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Then he is to remove all the fat, just as it is removed from the peace offering, and the priest is to burn it on the altar as a pleasing aroma to the LORD. In this way the priest will make atonement for him, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","If, however, he brings a lamb as a sin offering, he must bring an unblemished female. ");
INSERT INTO engmsb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","And he is to lay his hand on the head of the sin offering and slaughter it as a sin offering at the place where the burnt offering is slaughtered. ");
INSERT INTO engmsb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Then the priest is to take some of the blood of the sin offering with his finger, put it on the horns of the altar of burnt offering, and pour out the rest of its blood at the base of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","And he shall remove all the fat, just as the fat of the lamb is removed from the peace offerings, and he shall burn it on the altar along with the food offerings to the LORD. In this way the priest will make atonement for him for the sin he has committed, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“If someone sins by failing to testify when he hears a public charge about something he has witnessed, whether he has seen it or learned of it, he shall bear the iniquity. ");
INSERT INTO engmsb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Or if a person touches anything unclean—whether the carcass of any unclean wild animal or livestock or crawling creature—even if he is unaware of it, he is unclean and guilty. ");
INSERT INTO engmsb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Or if he touches human uncleanness—anything by which one becomes unclean—even if he is unaware of it, when he realizes it, he is guilty. ");
INSERT INTO engmsb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Or if someone swears thoughtlessly with his lips to do anything good or evil—in whatever matter a man may rashly pronounce an oath—even if he is unaware of it, when he realizes it, he is guilty in the matter. ");
INSERT INTO engmsb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","If someone incurs guilt in one of these ways, he must confess the sin he has committed, ");
INSERT INTO engmsb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","and he must bring his guilt offering to the LORD for the sin he has committed: a female lamb or goat from the flock as a sin offering. And the priest will make atonement for him concerning his sin. ");
INSERT INTO engmsb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","If, however, he cannot afford a lamb, he may bring to the LORD as restitution for his sin two turtledoves or two young pigeons—one as a sin offering and the other as a burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","He is to bring them to the priest, who shall first present the one for the sin offering. He is to twist its head at the front of its neck without severing it; ");
INSERT INTO engmsb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","then he is to sprinkle some of the blood of the sin offering on the side of the altar, while the rest of the blood is drained out at the base of the altar. It is a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","And the priest must prepare the second bird as a burnt offering according to the ordinance. In this way the priest will make atonement for him for the sin he has committed, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","But if he cannot afford two turtledoves or two young pigeons, he may bring a tenth of an ephah of fine flour as a sin offering. He must not put olive oil or frankincense on it, because it is a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","He is to bring it to the priest, who shall take a handful from it as a memorial portion and burn it on the altar atop the food offerings to the LORD; it is a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","In this way the priest will make atonement for him for any of these sins he has committed, and he will be forgiven. The remainder will belong to the priest, like the grain offering.” ");
INSERT INTO engmsb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“If someone acts unfaithfully and sins unintentionally against any of the LORD’s holy things, he must bring his guilt offering to the LORD: an unblemished ram from the flock, of proper value in silver shekels according to the sanctuary shekel; it is a guilt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Regarding any holy thing he has harmed, he must make restitution by adding a fifth of its value to it and giving it to the priest, who will make atonement on his behalf with the ram as a guilt offering, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","If someone sins and violates any of the LORD’s commandments even though he was unaware, he is guilty and shall bear his punishment. ");
INSERT INTO engmsb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","He is to bring to the priest an unblemished ram of proper value from the flock as a guilt offering. Then the priest will make atonement on his behalf for the wrong he has committed in ignorance, and he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a guilt offering; he was certainly guilty before the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“If someone sins and acts unfaithfully against the LORD by deceiving his neighbor in regard to a deposit or security entrusted to him or stolen, or if he extorts his neighbor ");
INSERT INTO engmsb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","or finds lost property and lies about it and swears falsely, or if he commits any such sin that a man might commit— ");
INSERT INTO engmsb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","once he has sinned and becomes guilty, he must return what he has stolen or taken by extortion, or the deposit entrusted to him, or the lost property he found, ");
INSERT INTO engmsb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or anything else about which he has sworn falsely. He must make restitution in full, add a fifth of the value, and pay it to the owner on the day he acknowledges his guilt. ");
INSERT INTO engmsb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Then he must bring to the priest his guilt offering to the LORD: an unblemished ram of proper value from the flock. ");
INSERT INTO engmsb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","In this way the priest will make atonement for him before the LORD, and he will be forgiven for anything he may have done to incur guilt.” ");
INSERT INTO engmsb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Command Aaron and his sons that this is the law of the burnt offering: The burnt offering is to remain on the hearth of the altar all night, until morning, and the fire must be kept burning on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","And the priest shall put on his linen robe and linen undergarments, and he shall remove from the altar the ashes of the burnt offering that the fire has consumed and place them beside it. ");
INSERT INTO engmsb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then he must take off his garments, put on other clothes, and carry the ashes outside the camp to a ceremonially clean place. ");
INSERT INTO engmsb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar shall be kept burning; it must not be extinguished. Every morning the priest is to add wood to the fire, arrange the burnt offering on it, and burn the fat portions of the peace offerings on it. ");
INSERT INTO engmsb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","The fire shall be kept burning on the altar continually; it must not be extinguished. ");
INSERT INTO engmsb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Now this is the law of the grain offering: Aaron’s sons shall present it before the LORD in front of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","The priest is to remove a handful of fine flour and olive oil, together with all the frankincense from the grain offering, and burn the memorial portion on the altar as a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaron and his sons are to eat the remainder. It must be eaten without leaven in a holy place; they are to eat it in the courtyard of the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It must not be baked with leaven; I have assigned it as their portion of My food offerings. It is most holy, like the sin offering and the guilt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Any male among the sons of Aaron may eat it. This is a permanent portion from the food offerings to the LORD for the generations to come. Anything that touches them will become holy.” ");
INSERT INTO engmsb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering that Aaron and his sons must present to the LORD on the day he is anointed: a tenth of an ephah of fine flour as a regular grain offering, half of it in the morning and half in the evening. ");
INSERT INTO engmsb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","It shall be prepared with oil on a griddle; you are to bring it well-kneaded and present it as a grain offering broken in pieces, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","The priest, who is one of Aaron’s sons and will be anointed to take his place, is to prepare it. As a permanent portion for the LORD, it must be burned completely. ");
INSERT INTO engmsb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every grain offering for a priest shall be burned completely; it is not to be eaten.” ");
INSERT INTO engmsb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tell Aaron and his sons that this is the law of the sin offering: In the place where the burnt offering is slaughtered, the sin offering shall be slaughtered before the LORD; it is most holy. ");
INSERT INTO engmsb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers it shall eat it; it must be eaten in a holy place, in the courtyard of the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Anything that touches its flesh will become holy, and if any of the blood is spattered on a garment, you must wash it in a holy place. ");
INSERT INTO engmsb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","The clay pot in which the sin offering is boiled must be broken; if it is boiled in a bronze pot, the pot must be scoured and rinsed with water. ");
INSERT INTO engmsb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Any male among the priests may eat it; it is most holy. ");
INSERT INTO engmsb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But no sin offering may be eaten if its blood has been brought into the Tent of Meeting to make atonement in the Holy Place; it must be burned. ");
INSERT INTO engmsb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Now this is the law of the guilt offering, which is most holy: ");
INSERT INTO engmsb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","The guilt offering must be slaughtered in the place where the burnt offering is slaughtered, and the priest shall splatter its blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","And all the fat from it shall be offered: the fat tail, the fat that covers the entrails, ");
INSERT INTO engmsb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","both kidneys with the fat on them near the loins, and the lobe of the liver, which is to be removed with the kidneys. ");
INSERT INTO engmsb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","The priest shall burn them on the altar as a food offering to the LORD; it is a guilt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Every male among the priests may eat of it. It must be eaten in a holy place; it is most holy. ");
INSERT INTO engmsb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","The guilt offering is like the sin offering; the same law applies to both. It belongs to the priest who makes atonement with it. ");
INSERT INTO engmsb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","As for the priest who presents a burnt offering for anyone, the hide of that offering belongs to him. ");
INSERT INTO engmsb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Likewise, every grain offering that is baked in an oven or cooked in a pan or on a griddle belongs to the priest who presents it, ");
INSERT INTO engmsb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","and every grain offering, whether dry or mixed with oil, belongs equally to all the sons of Aaron. ");
INSERT INTO engmsb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Now this is the law of the peace offering that one may present to the LORD: ");
INSERT INTO engmsb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If he offers it in thanksgiving, then along with the sacrifice of thanksgiving he shall offer unleavened cakes mixed with olive oil, unleavened wafers coated with oil, and well-kneaded cakes of fine flour mixed with oil. ");
INSERT INTO engmsb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Along with his peace offering of thanksgiving he is to present an offering with cakes of leavened bread. ");
INSERT INTO engmsb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","From the cakes he must present one portion of each offering as a contribution to the LORD. It belongs to the priest who sprinkles the blood of the peace offering. ");
INSERT INTO engmsb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The meat of the sacrifice of his peace offering of thanksgiving must be eaten on the day he offers it; none of it may be left until morning. ");
INSERT INTO engmsb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","If, however, the sacrifice he offers is a vow or a freewill offering, it shall be eaten on the day he presents his sacrifice, but the remainder may be eaten on the next day. ");
INSERT INTO engmsb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","But any meat of the sacrifice remaining until the third day must be burned up. ");
INSERT INTO engmsb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If any of the meat from his peace offering is eaten on the third day, it will not be accepted. It will not be credited to the one who presented it; it shall be an abomination, and the one who eats of it shall bear his iniquity. ");
INSERT INTO engmsb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Meat that touches anything unclean must not be eaten; it is to be burned up. As for any other meat, anyone who is ceremonially clean may eat it. ");
INSERT INTO engmsb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But if anyone who is unclean eats meat from the peace offering that belongs to the LORD, that person must be cut off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","If one touches anything unclean, whether human uncleanness, an unclean animal, or any unclean, detestable thing, and then eats any of the meat of the peace offering that belongs to the LORD, that person must be cut off from his people.” ");
INSERT INTO engmsb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Speak to the Israelites and say, ‘You are not to eat any of the fat of an ox, a sheep, or a goat. ");
INSERT INTO engmsb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","The fat of an animal found dead or mauled by wild beasts may be used for any other purpose, but you must not eat it. ");
INSERT INTO engmsb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","If anyone eats the fat of an animal from which a food offering may be presented to the LORD, the one who eats it must be cut off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","You must not eat the blood of any bird or animal in any of your dwellings. ");
INSERT INTO engmsb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","If anyone eats blood, that person must be cut off from his people.’” ");
INSERT INTO engmsb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Speak to the Israelites and say, ‘Anyone who presents a peace offering to the LORD must bring it as his sacrifice to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","With his own hands he is to bring the food offerings to the LORD; he shall bring the fat, together with the breast, and wave the breast as a wave offering before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The priest is to burn the fat on the altar, but the breast belongs to Aaron and his sons. ");
INSERT INTO engmsb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","And you are to give the right thigh to the priest as a contribution from your peace offering. ");
INSERT INTO engmsb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","The son of Aaron who presents the blood and fat of the peace offering shall have the right thigh as a portion. ");
INSERT INTO engmsb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","I have taken from the sons of Israel the breast of the wave offering and the thigh of the contribution of their peace offerings, and I have given them to Aaron the priest and his sons as a permanent portion from the sons of Israel.’” ");
INSERT INTO engmsb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the portion of the food offerings to the LORD for Aaron and his sons since the day they were presented to serve the LORD as priests. ");
INSERT INTO engmsb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","On the day they were anointed, the LORD commanded that this be given them by the sons of Israel. It is a permanent portion for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","This is the law of the burnt offering, the grain offering, the sin offering, the guilt offering, the ordination offering, and the peace offering, ");
INSERT INTO engmsb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","which the LORD gave Moses on Mount Sinai on the day He commanded the Israelites to present their offerings to the LORD in the Wilderness of Sinai. ");
INSERT INTO engmsb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Take Aaron and his sons, their garments, the anointing oil, the bull of the sin offering, the two rams, and the basket of unleavened bread, ");
INSERT INTO engmsb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","and assemble the whole congregation at the entrance to the Tent of Meeting.” ");
INSERT INTO engmsb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","So Moses did as the LORD had commanded him, and the assembly gathered at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","And Moses said to them, “This is what the LORD has commanded to be done.” ");
INSERT INTO engmsb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Then Moses presented Aaron and his sons and washed them with water. ");
INSERT INTO engmsb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He put the tunic on Aaron, tied the sash around him, clothed him with the robe, and put the ephod on him. He tied the woven band of the ephod around him and fastened it to him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Then he put the breastpiece on him and placed the Urim and Thummim in the breastpiece. ");
INSERT INTO engmsb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Moses also put the turban on Aaron’s head and set the gold plate, the holy diadem, on the front of the turban, as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Next, Moses took the anointing oil and anointed the tabernacle and everything in it; and so he consecrated them. ");
INSERT INTO engmsb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He sprinkled some of the oil on the altar seven times, anointing the altar and all its utensils, and the basin with its stand, to consecrate them. ");
INSERT INTO engmsb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He also poured some of the anointing oil on Aaron’s head and anointed him to consecrate him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Then Moses presented Aaron’s sons, put tunics on them, wrapped sashes around them, and tied headbands on them, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Moses then brought the bull near for the sin offering, and Aaron and his sons laid their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moses slaughtered the bull, took some of the blood, and applied it with his finger to all four horns of the altar, purifying the altar. He poured out the rest of the blood at the base of the altar and consecrated it so that atonement could be made on it. ");
INSERT INTO engmsb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses also took all the fat that was on the entrails, the lobe of the liver, and both kidneys and their fat, and burned it all on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the bull with its hide, flesh, and dung he burned outside the camp, as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Then Moses presented the ram for the burnt offering, and Aaron and his sons laid their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moses slaughtered the ram and splattered the blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","He cut the ram into pieces and burned the head, the pieces, and the fat. ");
INSERT INTO engmsb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","He washed the entrails and legs with water and burned the entire ram on the altar as a burnt offering, a pleasing aroma, a food offering to the LORD, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","After that, Moses presented the other ram, the ram of ordination, and Aaron and his sons laid their hands on its head. ");
INSERT INTO engmsb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moses slaughtered the ram and took some of its blood and put it on Aaron’s right earlobe, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engmsb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Moses also presented Aaron’s sons and put some of the blood on their right earlobes, on the thumbs of their right hands, and on the big toes of their right feet. Then he splattered the blood on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","And Moses took the fat—the fat tail, all the fat that was on the entrails, the lobe of the liver, and both kidneys with their fat—as well as the right thigh. ");
INSERT INTO engmsb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","And from the basket of unleavened bread that was before the LORD, he took one cake of unleavened bread, one cake of bread made with oil, and one wafer, and he placed them on the fat portions and on the right thigh. ");
INSERT INTO engmsb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","He put all these in the hands of Aaron and his sons and waved them before the LORD as a wave offering. ");
INSERT INTO engmsb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Then Moses took these from their hands and burned them on the altar with the burnt offering. This was an ordination offering, a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","He also took the breast—Moses’ portion of the ram of ordination—and waved it before the LORD as a wave offering, as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Next, Moses took some of the anointing oil and some of the blood that was on the altar and sprinkled them on Aaron and his garments, and on his sons and their garments. So he consecrated Aaron and his garments, as well as Aaron’s sons and their garments. ");
INSERT INTO engmsb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","And Moses said to Aaron and his sons, “Boil the meat at the entrance to the Tent of Meeting and eat it there with the bread that is in the basket of ordination offerings, as I commanded, saying, ‘Aaron and his sons are to eat it.’ ");
INSERT INTO engmsb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Then you must burn up the remainder of the meat and bread. ");
INSERT INTO engmsb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","You must not go outside the entrance to the Tent of Meeting for seven days, until the days of your ordination are complete; for it will take seven days to ordain you. ");
INSERT INTO engmsb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What has been done today has been commanded by the LORD in order to make atonement on your behalf. ");
INSERT INTO engmsb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You must remain at the entrance to the Tent of Meeting day and night for seven days and keep the LORD’s charge so that you will not die, for this is what I have been commanded.” ");
INSERT INTO engmsb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aaron and his sons did everything the LORD had commanded through Moses. ");
INSERT INTO engmsb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day Moses summoned Aaron and his sons and the elders of Israel. ");
INSERT INTO engmsb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","He said to Aaron, “Take for yourself a young bull for a sin offering and a ram for a burnt offering, both without blemish, and present them before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Then speak to the Israelites and say, ‘Take a male goat for a sin offering, a calf and a lamb—both a year old and without blemish—for a burnt offering, ");
INSERT INTO engmsb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","an ox and a ram for a peace offering to sacrifice before the LORD, and a grain offering mixed with oil. For today the LORD will appear to you.’” ");
INSERT INTO engmsb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","So they took what Moses had commanded to the front of the Tent of Meeting, and the whole congregation drew near and stood before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","And Moses said, “This is what the LORD has commanded you to do, so that the glory of the LORD may appear to you.” ");
INSERT INTO engmsb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Then Moses said to Aaron, “Approach the altar and sacrifice your sin offering and your burnt offering to make atonement for yourself and for the people. And sacrifice the people’s offering to make atonement for them, as the LORD has commanded.” ");
INSERT INTO engmsb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron approached the altar and slaughtered the calf as a sin offering for himself. ");
INSERT INTO engmsb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","The sons of Aaron brought the blood to him, and he dipped his finger in the blood and applied it to the horns of the altar. And he poured out the rest of the blood at the base of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","On the altar he burned the fat, the kidneys, and the lobe of the liver from the sin offering, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","But he burned up the flesh and the hide outside the camp. ");
INSERT INTO engmsb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Then Aaron slaughtered the burnt offering. His sons brought him the blood, and he splattered it on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","They brought him the burnt offering piece by piece, including the head, and he burned them on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He washed the entrails and the legs and burned them atop the burnt offering on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Aaron then presented the people’s offering. He took the male goat for the people’s sin offering, slaughtered it, and offered it for sin like the first one. ");
INSERT INTO engmsb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He presented the burnt offering and offered it according to the ordinance. ");
INSERT INTO engmsb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Next he presented the grain offering, took a handful of it, and burned it on the altar in addition to the morning’s burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Then he slaughtered the ox and the ram as the people’s peace offering. His sons brought him the blood, and he splattered it on all sides of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","They also brought the fat portions from the ox and the ram—the fat tail, the fat covering the entrails, the kidneys, and the lobe of the liver— ");
INSERT INTO engmsb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","and placed these on the breasts. Aaron burned the fat portions on the altar, ");
INSERT INTO engmsb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","but he waved the breasts and the right thigh as a wave offering before the LORD, as Moses had commanded. ");
INSERT INTO engmsb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaron lifted up his hands toward the people and blessed them. And having made the sin offering, the burnt offering, and the peace offering, he stepped down. ");
INSERT INTO engmsb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron then entered the Tent of Meeting. When they came out, they blessed the people, and the glory of the LORD appeared to all the people. ");
INSERT INTO engmsb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Fire came out from the presence of the LORD and consumed the burnt offering and the fat portions on the altar. And when all the people saw it, they shouted for joy and fell facedown. ");
INSERT INTO engmsb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Now Aaron’s sons Nadab and Abihu took their censers, put fire in them and added incense, and offered unauthorized fire before the LORD, contrary to His command. ");
INSERT INTO engmsb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","So fire came out from the presence of the LORD and consumed them, and they died in the presence of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses said to Aaron, “This is what the LORD meant when He said: ‘To those who come near Me I will show My holiness, and in the sight of all the people I will reveal My glory.’” But Aaron remained silent. ");
INSERT INTO engmsb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses summoned Mishael and Elzaphan, sons of Aaron’s uncle Uzziel, and said to them, “Come here; carry the bodies of your cousins outside the camp, away from the front of the sanctuary.” ");
INSERT INTO engmsb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So they came forward and carried them, still in their tunics, outside the camp, as Moses had directed. ");
INSERT INTO engmsb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses said to Aaron and his sons Eleazar and Ithamar, “Do not let your hair become disheveled and do not tear your garments, or else you will die, and the LORD will be angry with the whole congregation. But your brothers, the whole house of Israel, may mourn on account of the fire that the LORD has ignited. ");
INSERT INTO engmsb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","You shall not go outside the entrance to the Tent of Meeting, or you will die, for the LORD’s anointing oil is on you.” So they did as Moses instructed. ");
INSERT INTO engmsb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Then the LORD said to Aaron, ");
INSERT INTO engmsb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“You and your sons are not to drink wine or strong drink when you enter the Tent of Meeting, or else you will die; this is a permanent statute for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","You must distinguish between the holy and the common, between the clean and the unclean, ");
INSERT INTO engmsb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","so that you may teach the Israelites all the statutes that the LORD has given them through Moses.” ");
INSERT INTO engmsb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","And Moses said to Aaron and his remaining sons, Eleazar and Ithamar, “Take the grain offering that remains from the food offerings to the LORD and eat it without leaven beside the altar, because it is most holy. ");
INSERT INTO engmsb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","You shall eat it in a holy place, because it is your share and your sons’ share of the food offerings to the LORD; for this is what I have been commanded. ");
INSERT INTO engmsb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","And you and your sons and daughters may eat the breast of the wave offering and the thigh of the contribution in a ceremonially clean place, because these portions have been assigned to you and your children from the peace offerings of the sons of Israel. ");
INSERT INTO engmsb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","They are to bring the thigh of the contribution and the breast of the wave offering, together with the fat portions of the food offerings, to wave as a wave offering before the LORD. It will belong permanently to you and your children, as the LORD has commanded.” ");
INSERT INTO engmsb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Later, Moses searched carefully for the goat of the sin offering, and behold, it had been burned up. He was angry with Eleazar and Ithamar, Aaron’s remaining sons, and asked, ");
INSERT INTO engmsb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why didn’t you eat the sin offering in the holy place? For it is most holy; it was given to you to take away the guilt of the congregation by making atonement for them before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Since its blood was not brought inside the holy place, you should have eaten it in the sanctuary area, as I commanded.” ");
INSERT INTO engmsb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","But Aaron replied to Moses, “Behold, this very day they presented their sin offering and their burnt offering before the LORD. Since these things have happened to me, if I had eaten the sin offering today, would it have been acceptable in the sight of the LORD?” ");
INSERT INTO engmsb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","And when Moses heard this explanation, he was satisfied. ");
INSERT INTO engmsb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","The LORD spoke again to Moses and Aaron, telling them, ");
INSERT INTO engmsb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Say to the Israelites, ‘Of all the beasts of the earth, these ones you may eat: ");
INSERT INTO engmsb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","You may eat any animal that has a split hoof completely divided and that chews the cud. ");
INSERT INTO engmsb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","But of those that only chew the cud or only have a divided hoof, you are not to eat the following: The camel, though it chews the cud, does not have a divided hoof; it is unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","The rock badger, though it chews the cud, does not have a divided hoof; it is unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","The rabbit, though it chews the cud, does not have a divided hoof; it is unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","And the pig, though it has a split hoof completely divided, does not chew the cud; it is unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You must not eat their meat or touch their carcasses; they are unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Of all the creatures that live in the water, whether in the seas or in the streams, you may eat anything with fins and scales. ");
INSERT INTO engmsb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But the following among all the teeming life and creatures in the water are detestable to you: everything in the seas or streams that does not have fins and scales. ");
INSERT INTO engmsb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","They shall be an abomination to you; you must not eat their meat, and you must detest their carcasses. ");
INSERT INTO engmsb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Everything in the water that does not have fins and scales shall be detestable to you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Additionally, you are to detest the following birds, and they must not be eaten because they are detestable: the eagle, the bearded vulture, the black vulture, ");
INSERT INTO engmsb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","the kite, any kind of falcon, ");
INSERT INTO engmsb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","any kind of raven, ");
INSERT INTO engmsb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","the ostrich, the screech owl, the gull, any kind of hawk, ");
INSERT INTO engmsb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","the little owl, the cormorant, the great owl, ");
INSERT INTO engmsb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","the white owl, the desert owl, the osprey, ");
INSERT INTO engmsb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","the stork, any kind of heron, the hoopoe, and the bat. ");
INSERT INTO engmsb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","All flying insects that walk on all fours are detestable to you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","However, you may eat the following kinds of flying insects that walk on all fours: those having jointed legs above their feet for hopping on the ground. ");
INSERT INTO engmsb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Of these you may eat any kind of locust, katydid, cricket, or grasshopper. ");
INSERT INTO engmsb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","All other flying insects that have four legs are detestable to you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","These creatures will make you unclean. Whoever touches their carcasses will be unclean until evening, ");
INSERT INTO engmsb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","and whoever picks up one of their carcasses must wash his clothes, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Every animal with hooves not completely divided or that does not chew the cud is unclean for you. Whoever touches any of them will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","All the four-footed animals that walk on their paws are unclean for you; whoever touches their carcasses will be unclean until evening, ");
INSERT INTO engmsb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","and anyone who picks up a carcass must wash his clothes, and he will be unclean until evening. They are unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","The following creatures that move along the ground are unclean for you: the mole, the mouse, any kind of great lizard, ");
INSERT INTO engmsb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","the gecko, the monitor lizard, the common lizard, the skink, and the chameleon. ");
INSERT INTO engmsb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These animals are unclean for you among all the crawling creatures. Whoever touches them when they are dead shall be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","When one of them dies and falls on something, that article becomes unclean; any article of wood, clothing, leather, sackcloth, or any implement used for work must be rinsed with water and will remain unclean until evening; then it will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","If any of them falls into a clay pot, everything in it will be unclean; you must break the pot. ");
INSERT INTO engmsb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Any food coming into contact with water from that pot will be unclean, and any drink in such a container will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anything upon which one of their carcasses falls will be unclean. If it is an oven or cooking pot, it must be smashed; it is unclean and will remain unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Nevertheless, a spring or cistern containing water will remain clean, but one who touches a carcass in it will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If a carcass falls on any seed for sowing, the seed is clean; ");
INSERT INTO engmsb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","but if water has been put on the seed and a carcass falls on it, it is unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","If an animal that you may eat dies, anyone who touches the carcass will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Whoever eats from the carcass must wash his clothes and will be unclean until evening, and anyone who picks up the carcass must wash his clothes and will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Every creature that moves along the ground is detestable; it must not be eaten. ");
INSERT INTO engmsb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Do not eat any creature that moves along the ground, whether it crawls on its belly or walks on four or more feet; for such creatures are detestable. ");
INSERT INTO engmsb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Do not defile yourselves by any crawling creature; do not become unclean or defiled by them. ");
INSERT INTO engmsb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","For I am the LORD your God; consecrate yourselves, therefore, and be holy, because I am holy. You must not defile yourselves by any creature that crawls along the ground. ");
INSERT INTO engmsb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","For I am the LORD, who brought you up out of the land of Egypt so that I would be your God; therefore be holy, because I am holy. ");
INSERT INTO engmsb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","This is the law regarding animals, birds, all living creatures that move in the water, and all creatures that crawl along the ground. ");
INSERT INTO engmsb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","You must distinguish between the unclean and the clean, between animals that may be eaten and those that may not.’” ");
INSERT INTO engmsb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Say to the Israelites, ‘A woman who becomes pregnant and gives birth to a son will be unclean for seven days, as she is during the days of her menstruation. ");
INSERT INTO engmsb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","And on the eighth day the flesh of the boy’s foreskin is to be circumcised. ");
INSERT INTO engmsb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","The woman shall continue in purification from her bleeding for thirty-three days. She must not touch anything sacred or go into the sanctuary until the days of her purification are complete. ");
INSERT INTO engmsb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","If, however, she gives birth to a daughter, the woman will be unclean for two weeks as she is during her menstruation. Then she must continue in purification from her bleeding for sixty-six days. ");
INSERT INTO engmsb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","When the days of her purification are complete, whether for a son or for a daughter, she is to bring to the priest at the entrance to the Tent of Meeting a year-old lamb for a burnt offering and a young pigeon or a turtledove for a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","And the priest will present them before the LORD and make atonement for her; and she shall be ceremonially cleansed from her flow of blood. This is the law for a woman giving birth, whether to a male or to a female. ");
INSERT INTO engmsb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","But if she cannot afford a lamb, she shall bring two turtledoves or two young pigeons, one for a burnt offering and the other for a sin offering. Then the priest will make atonement for her, and she will be clean.’” ");
INSERT INTO engmsb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“When someone has a swelling or rash or bright spot on his skin that may be an infectious skin disease, he must be brought to Aaron the priest or to one of his sons who is a priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest is to examine the infection on his skin, and if the hair in the infection has turned white and the sore appears to be deeper than the skin, it is a skin disease. After the priest examines him, he must pronounce him unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","If, however, the spot on his skin is white and does not appear to be deeper than the skin, and the hair in it has not turned white, the priest shall isolate the infected person for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","On the seventh day the priest is to reexamine him, and if he sees that the infection is unchanged and has not spread on the skin, the priest must isolate him for another seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","The priest will examine him again on the seventh day, and if the sore has faded and has not spread on the skin, the priest shall pronounce him clean; it is a rash. The person must wash his clothes and be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","But if the rash spreads further on his skin after he has shown himself to the priest for his cleansing, he must present himself again to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest will reexamine him, and if the rash has spread on the skin, the priest must pronounce him unclean; it is a skin disease. ");
INSERT INTO engmsb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","When anyone develops a skin disease, he must be brought to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","The priest will examine him, and if there is a white swelling on the skin that has turned the hair white, and there is raw flesh in the swelling, ");
INSERT INTO engmsb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is a chronic skin disease and the priest must pronounce him unclean. He need not isolate him, for he is unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","But if the skin disease breaks out all over his skin so that it covers all the skin of the infected person from head to foot, as far as the priest can see, ");
INSERT INTO engmsb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","the priest shall examine him, and if the disease has covered his entire body, he is to pronounce the infected person clean. Since it has all turned white, he is clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But whenever raw flesh appears on someone, he will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","When the priest sees the raw flesh, he must pronounce him unclean. The raw flesh is unclean; it is a skin disease. ");
INSERT INTO engmsb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","But if the raw flesh changes and turns white, he must go to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest will reexamine him, and if the infection has turned white, the priest is to pronounce the infected person clean; then he is clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","When a boil appears on someone’s skin and it heals, ");
INSERT INTO engmsb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and a white swelling or a reddish-white spot develops where the boil was, he must present himself to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest shall examine it, and if it appears to be beneath the skin and the hair in it has turned white, the priest shall pronounce him unclean; it is a diseased infection that has broken out in the boil. ");
INSERT INTO engmsb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But when the priest examines it, if there is no white hair in it, and it is not beneath the skin and has faded, the priest shall isolate him for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If it spreads any further on the skin, the priest must pronounce him unclean; it is an infection. ");
INSERT INTO engmsb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the spot remains unchanged and does not spread, it is only the scar from the boil, and the priest shall pronounce him clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","When there is a burn on someone’s skin and the raw area of the burn becomes reddish-white or white, ");
INSERT INTO engmsb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","the priest must examine it. If the hair in the spot has turned white and the spot appears to be deeper than the skin, it is a disease that has broken out in the burn. The priest must pronounce him unclean; it is a diseased infection. ");
INSERT INTO engmsb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the priest examines it and there is no white hair in the spot, and it is not beneath the skin but has faded, the priest shall isolate him for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","On the seventh day the priest is to reexamine him, and if it has spread further on the skin, the priest must pronounce him unclean; it is a diseased infection. ");
INSERT INTO engmsb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","But if the spot is unchanged and has not spread on the skin but has faded, it is a swelling from the burn, and the priest is to pronounce him clean; for it is only the scar from the burn. ");
INSERT INTO engmsb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","If a man or woman has an infection on the head or chin, ");
INSERT INTO engmsb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","the priest shall examine the infection, and if it appears to be deeper than the skin and the hair in it is yellow and thin, the priest must pronounce him unclean; it is a scaly outbreak, an infectious disease of the head or chin. ");
INSERT INTO engmsb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","But if the priest examines the scaly infection and it does not appear to be deeper than the skin, and there is no black hair in it, the priest shall isolate the infected person for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day the priest is to reexamine the infection, and if the scaly outbreak has not spread and there is no yellow hair in it, and it does not appear to be deeper than the skin, ");
INSERT INTO engmsb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then the person must shave himself except for the scaly area. Then the priest shall isolate him for another seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day the priest shall examine the scaly outbreak, and if it has not spread on the skin and does not appear to be deeper than the skin, the priest is to pronounce him clean. He must wash his clothes, and he will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","If, however, the scaly outbreak spreads further on the skin after his cleansing, ");
INSERT INTO engmsb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","the priest is to examine him, and if the scaly outbreak has spread on the skin, the priest need not look for yellow hair; the person is unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","If, however, in his sight the scaly outbreak is unchanged and black hair has grown in it, then it has healed. He is clean, and the priest is to pronounce him clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","When a man or a woman has white spots on the skin, ");
INSERT INTO engmsb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","the priest shall examine them, and if the spots are dull white, it is a harmless rash that has broken out on the skin; the person is clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Now if a man loses his hair and is bald, he is still clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Or if his hairline recedes and he is bald on his forehead, he is still clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if there is a reddish-white sore on the bald head or forehead, it is an infectious disease breaking out on it. ");
INSERT INTO engmsb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","The priest is to examine him, and if the swelling of the infection on his bald head or forehead is reddish-white like a skin disease, ");
INSERT INTO engmsb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","the man is diseased; he is unclean. The priest must pronounce him unclean because of the infection on his head. ");
INSERT INTO engmsb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","A diseased person must wear torn clothes and let his hair hang loose, and he must cover his mouth and cry out, ‘Unclean, unclean!’ ");
INSERT INTO engmsb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","As long as he has the infection, he remains unclean. He must live alone in a place outside the camp. ");
INSERT INTO engmsb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","If any fabric is contaminated with mildew—any wool or linen garment, ");
INSERT INTO engmsb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","any weave or knit of linen or wool, or any article of leather— ");
INSERT INTO engmsb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","and if the mark in the fabric, leather, weave, knit, or leather article is green or red, then it is contaminated with mildew and must be shown to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","And the priest is to examine the mildew and isolate the contaminated fabric for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","On the seventh day the priest shall reexamine it, and if the mildew has spread in the fabric, weave, knit, or leather, then regardless of how it is used, it is a harmful mildew; the article is unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He is to burn the fabric, weave, or knit, whether the contaminated item is wool or linen or leather. Since the mildew is harmful, the article must be burned up. ");
INSERT INTO engmsb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","But when the priest reexamines it, if the mildew has not spread in the fabric, weave, knit, or leather article, ");
INSERT INTO engmsb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","the priest is to order the contaminated article to be washed and isolated for another seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","After it has been washed, the priest is to reexamine it, and if the mildewed article has not changed in appearance, it is unclean. Even though the mildew has not spread, you must burn it, whether the rot is on the front or back. ");
INSERT INTO engmsb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","If the priest examines it and the mildew has faded after it has been washed, he must cut the contaminated section out of the fabric, leather, weave, or knit. ");
INSERT INTO engmsb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","But if it reappears in the fabric, weave, or knit, or on any leather article, it is spreading. You must burn the contaminated article. ");
INSERT INTO engmsb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","If the mildew disappears from the fabric, weave, or knit, or any leather article after washing, then it is to be washed again, and it will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","This is the law concerning a mildew contamination in wool or linen fabric, weave, or knit, or any leather article, for pronouncing it clean or unclean.” ");
INSERT INTO engmsb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“This is the law for the one afflicted with a skin disease on the day of his cleansing, when he is brought to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The priest is to go outside the camp to examine him, and if the skin disease of the afflicted person has healed, ");
INSERT INTO engmsb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","the priest shall order that two live clean birds, cedar wood, scarlet yarn, and hyssop be brought for the one to be cleansed. ");
INSERT INTO engmsb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Then the priest shall command that one of the birds be slaughtered over fresh water in a clay pot. ");
INSERT INTO engmsb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","And he is to take the live bird together with the cedar wood, scarlet yarn, and hyssop, and dip them into the blood of the bird that was slaughtered over the fresh water. ");
INSERT INTO engmsb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Seven times he shall sprinkle the one to be cleansed of the skin disease. Then he shall pronounce him clean and release the live bird into the open field. ");
INSERT INTO engmsb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","The one being cleansed must wash his clothes, shave off all his hair, and bathe with water; then he will be ceremonially clean. Afterward, he may enter the camp, but he must remain outside his tent for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","On the seventh day he must shave off all his hair—his head, his beard, his eyebrows, and the rest of his hair. He must wash his clothes and bathe himself with water, and he will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","On the eighth day he is to bring two unblemished male lambs, an unblemished ewe lamb a year old, a grain offering of three-tenths of an ephah of fine flour mixed with olive oil, and one log of olive oil. ");
INSERT INTO engmsb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest who performs the cleansing shall present the one to be cleansed, together with these offerings, before the LORD at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Then the priest is to take one of the male lambs and present it as a guilt offering, along with the log of olive oil; and he must wave them as a wave offering before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Then he is to slaughter the lamb in the sanctuary area where the sin offering and burnt offering are slaughtered. Like the sin offering, the guilt offering belongs to the priest; it is most holy. ");
INSERT INTO engmsb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","The priest is to take some of the blood from the guilt offering and put it on the right earlobe of the one to be cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engmsb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Then the priest shall take some of the log of olive oil, pour it into his left palm, ");
INSERT INTO engmsb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","dip his right forefinger into the oil in his left palm, and sprinkle some of the oil with his finger seven times before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","And the priest is to put some of the oil remaining in his palm on the right earlobe of the one to be cleansed, on the thumb of his right hand, and on the big toe of his right foot, on top of the blood of the guilt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","The rest of the oil in his palm, the priest is to put on the head of the one to be cleansed, to make atonement for him before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Then the priest is to sacrifice the sin offering and make atonement for the one to be cleansed from his uncleanness. After that, the priest shall slaughter the burnt offering ");
INSERT INTO engmsb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","and offer it on the altar, with the grain offering, to make atonement for him, and he will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","If, however, the person is poor and cannot afford these offerings, he is to take one male lamb as a guilt offering to be waved to make atonement for him, along with a tenth of an ephah of fine flour mixed with olive oil for a grain offering, a log of olive oil, ");
INSERT INTO engmsb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two turtledoves or two young pigeons, whichever he can afford, one to be a sin offering and the other a burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","On the eighth day he is to bring them for his cleansing to the priest at the entrance to the Tent of Meeting before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest shall take the lamb for the guilt offering, along with the log of olive oil, and wave them as a wave offering before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","And after he slaughters the lamb for the guilt offering, the priest is to take some of the blood of the guilt offering and put it on the right earlobe of the one to be cleansed, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engmsb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Then the priest is to pour some of the oil into his left palm ");
INSERT INTO engmsb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and sprinkle with his right forefinger some of the oil in his left palm seven times before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","The priest shall also put some of the oil in his palm on the right earlobe of the one to be cleansed, on the thumb of his right hand, and on the big toe of his right foot—on the same places as the blood of the guilt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","The rest of the oil in his palm, the priest is to put on the head of the one to be cleansed, to make atonement for him before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Then he must sacrifice the turtledoves or young pigeons, whichever he can afford, ");
INSERT INTO engmsb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","one as a sin offering and the other as a burnt offering, together with the grain offering. In this way the priest will make atonement before the LORD for the one to be cleansed. ");
INSERT INTO engmsb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","This is the law for someone who has a skin disease and cannot afford the cost of his cleansing.” ");
INSERT INTO engmsb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“When you enter the land of Canaan, which I am giving you as your possession, and I put a contamination of mildew into a house in that land, ");
INSERT INTO engmsb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","the owner of the house shall come and tell the priest, ‘Something like mildew has appeared in my house.’ ");
INSERT INTO engmsb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","The priest must order that the house be cleared before he enters it to examine the mildew, so that nothing in the house will become unclean. After this, the priest shall go in to inspect the house. ");
INSERT INTO engmsb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He is to examine the house, and if the mildew on the walls consists of green or red depressions that appear to be beneath the surface of the wall, ");
INSERT INTO engmsb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","the priest shall go outside the doorway of the house and close it up for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","On the seventh day the priest is to return and inspect the house. If the mildew has spread on the walls, ");
INSERT INTO engmsb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","he must order that the contaminated stones be pulled out and thrown into an unclean place outside the city. ");
INSERT INTO engmsb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","And he shall have the inside of the house scraped completely and the plaster that is scraped off dumped into an unclean place outside the city. ");
INSERT INTO engmsb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","So different stones must be obtained to replace the contaminated ones, as well as additional mortar to replaster the house. ");
INSERT INTO engmsb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","If the mildew reappears in the house after the stones have been torn out and the house has been scraped and replastered, ");
INSERT INTO engmsb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","the priest must come and inspect it. If the mildew has spread in the house, it is a destructive mildew; the house is unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","It must be torn down with its stones, its timbers, and all its plaster, and taken outside the city to an unclean place. ");
INSERT INTO engmsb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Anyone who enters the house during any of the days that it is closed up will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","And anyone who sleeps in the house or eats in it must wash his clothes. ");
INSERT INTO engmsb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","If, however, the priest comes and inspects it, and the mildew has not spread after the house has been replastered, he shall pronounce the house clean, because the mildew is gone. ");
INSERT INTO engmsb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","He is to take two birds, cedar wood, scarlet yarn, and hyssop to purify the house; ");
INSERT INTO engmsb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","and he shall slaughter one of the birds over fresh water in a clay pot. ");
INSERT INTO engmsb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Then he shall take the cedar wood, the hyssop, the scarlet yarn, and the live bird, dip them in the blood of the slaughtered bird and the fresh water, and sprinkle the house seven times. ");
INSERT INTO engmsb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","And he shall cleanse the house with the bird’s blood, the fresh water, the live bird, the cedar wood, the hyssop, and the scarlet yarn. ");
INSERT INTO engmsb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Finally, he is to release the live bird into the open fields outside the city. In this way he will make atonement for the house, and it will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","This is the law for any infectious skin disease, for a scaly outbreak, ");
INSERT INTO engmsb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","for mildew in clothing or in a house, ");
INSERT INTO engmsb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","and for a swelling, rash, or spot, ");
INSERT INTO engmsb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","to determine when something is clean or unclean. This is the law regarding skin diseases and mildew.” ");
INSERT INTO engmsb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","And the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Say to the Israelites, ‘When any man has a bodily discharge, the discharge is unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","This uncleanness is from his discharge, whether his body allows the discharge to flow or blocks it. So his discharge will bring about uncleanness. ");
INSERT INTO engmsb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Any bed on which the man with the discharge lies will be unclean, and any furniture on which he sits will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Anyone who touches his bed must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Whoever sits on furniture on which the man with the discharge was sitting must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Whoever touches the body of the man with a discharge must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","If the man with the discharge spits on one who is clean, that person must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Any saddle on which the man with the discharge rides will be unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Whoever touches anything that was under him will be unclean until evening, and whoever carries such things must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","If the man with the discharge touches anyone without first rinsing his hands with water, the one who was touched must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Any clay pot that the man with the discharge touches must be broken, and any wooden utensil must be rinsed with water. ");
INSERT INTO engmsb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","When the man has been cleansed from his discharge, he must count off seven days for his cleansing, wash his clothes, and bathe himself in fresh water, and he shall be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","On the eighth day he is to take two turtledoves or two young pigeons, come before the LORD at the entrance to the Tent of Meeting, and give them to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest is to sacrifice them, one as a sin offering and the other as a burnt offering. In this way the priest will make atonement for the man before the LORD because of his discharge. ");
INSERT INTO engmsb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","When a man has an emission of semen, he must bathe his whole body with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Any clothing or leather on which there is an emission of semen must be washed with water, and it will remain unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","If a man lies with a woman and there is an emission of semen, both must bathe with water, and they will remain unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","When a woman has a discharge consisting of blood from her body, she will be unclean due to her menstruation for seven days, and anyone who touches her will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Anything on which she lies or sits during her menstruation will be unclean, ");
INSERT INTO engmsb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","and anyone who touches her bed must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Whoever touches any furniture on which she was sitting must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","And whether it is a bed or furniture on which she was sitting, whoever touches it will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","If a man lies with her and her menstrual flow touches him, he will be unclean for seven days, and any bed on which he lies will become unclean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","When a woman has a discharge of her blood for many days at a time other than her menstrual period, or if it continues beyond her period, she will be unclean all the days of her unclean discharge, just as she is during the days of her menstruation. ");
INSERT INTO engmsb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Any bed on which she lies or any furniture on which she sits during the days of her discharge will be unclean, like her bed during her menstrual period. ");
INSERT INTO engmsb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Anyone who touches these things will be unclean; he must wash his clothes and bathe with water, and he will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","When a woman is cleansed of her discharge, she must count off seven days, and after that she will be ceremonially clean. ");
INSERT INTO engmsb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","On the eighth day she is to take two turtledoves or two young pigeons and bring them to the priest at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","The priest is to sacrifice one as a sin offering and the other as a burnt offering. In this way the priest will make atonement for her before the LORD for her unclean discharge. ");
INSERT INTO engmsb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","You must keep the children of Israel separate from their uncleanness, so that they do not die by defiling My tabernacle, which is among them. ");
INSERT INTO engmsb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","This is the law of him who has a discharge, of the man who has an emission of semen whereby he is unclean, ");
INSERT INTO engmsb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","of a woman in her menstrual period, of any male or female who has a discharge, and of a man who lies with an unclean woman.’” ");
INSERT INTO engmsb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Now the LORD spoke to Moses after the death of two of Aaron’s sons when they approached the presence of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","And the LORD said to Moses: “Tell your brother Aaron not to enter freely into the Most Holy Place behind the veil in front of the mercy seat on the ark, or else he will die, because I appear in the cloud above the mercy seat. ");
INSERT INTO engmsb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","This is how Aaron is to enter the Holy Place: with a young bull for a sin offering and a ram for a burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He is to wear the sacred linen tunic, with linen undergarments. He must tie a linen sash around him and put on the linen turban. These are holy garments, and he must bathe himself with water before he wears them. ");
INSERT INTO engmsb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","And he shall take from the congregation of Israel two male goats for a sin offering and one ram for a burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron is to present the bull for his sin offering and make atonement for himself and his household. ");
INSERT INTO engmsb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Then he shall take the two goats and present them before the LORD at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","After Aaron casts lots for the two goats, one for the LORD and the other for the scapegoat, ");
INSERT INTO engmsb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","he shall present the goat chosen by lot for the LORD and sacrifice it as a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat chosen by lot as the scapegoat shall be presented alive before the LORD to make atonement by sending it into the wilderness as the scapegoat. ");
INSERT INTO engmsb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","When Aaron presents the bull for his sin offering and makes atonement for himself and his household, he is to slaughter the bull for his own sin offering. ");
INSERT INTO engmsb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Then he must take a censer full of burning coals from the altar before the LORD, and two handfuls of finely ground fragrant incense, and take them inside the veil. ");
INSERT INTO engmsb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","He is to put the incense on the fire before the LORD, and the cloud of incense will cover the mercy seat above the Testimony, so that he will not die. ");
INSERT INTO engmsb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","And he is to take some of the bull’s blood and sprinkle it with his finger on the east side of the mercy seat; then he shall sprinkle some of it with his finger seven times before the mercy seat. ");
INSERT INTO engmsb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Aaron shall then slaughter the goat for the sin offering for the people and bring its blood behind the veil, and with its blood he must do as he did with the bull’s blood: He is to sprinkle it against the mercy seat and in front of it. ");
INSERT INTO engmsb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","So he shall make atonement for the Most Holy Place because of the impurities and rebellious acts of the Israelites in regard to all their sins. He is to do the same for the Tent of Meeting which abides among them in the midst of their impurities. ");
INSERT INTO engmsb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","No one may be in the Tent of Meeting from the time Aaron goes in to make atonement in the Most Holy Place until he leaves, after he has made atonement for himself, his household, and the whole assembly of Israel. ");
INSERT INTO engmsb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Then he shall go out to the altar that is before the LORD and make atonement for it. He is to take some of the bull’s blood and some of the goat’s blood and put it on all the horns of the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","He is to sprinkle some of the blood on it with his finger seven times to cleanse it and consecrate it from the uncleanness of the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","When Aaron has finished purifying the Most Holy Place, the Tent of Meeting, and the altar, he is to bring forward the live goat. ");
INSERT INTO engmsb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Then he is to lay both hands on the head of the live goat and confess over it all the iniquities and rebellious acts of the Israelites in regard to all their sins. He is to put them on the goat’s head and send it away into the wilderness by the hand of a man appointed for the task. ");
INSERT INTO engmsb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","The goat will carry on itself all their iniquities into a solitary place, and the man will release it into the wilderness. ");
INSERT INTO engmsb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Then Aaron is to enter the Tent of Meeting, take off the linen garments he put on before entering the Most Holy Place, and leave them there. ");
INSERT INTO engmsb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","He is to bathe himself with water in a holy place and put on his own clothes. Then he must go out and sacrifice his burnt offering and the people’s burnt offering to make atonement for himself and for the people. ");
INSERT INTO engmsb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","He is also to burn the fat of the sin offering on the altar. ");
INSERT INTO engmsb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","The man who released the goat as the scapegoat must wash his clothes and bathe himself with water; afterward he may reenter the camp. ");
INSERT INTO engmsb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The bull for the sin offering and the goat for the sin offering, whose blood was brought into the Most Holy Place to make atonement, must be taken outside the camp; and their hides, flesh, and dung must be burned up. ");
INSERT INTO engmsb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","The one who burns them must wash his clothes and bathe himself with water, and afterward he may reenter the camp. ");
INSERT INTO engmsb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","This is to be a permanent statute for you: On the tenth day of the seventh month, you shall humble yourselves and not do any work—whether the native or the foreigner who resides among you— ");
INSERT INTO engmsb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","because on this day atonement will be made for you to cleanse you, and you will be clean from all your sins before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is a Sabbath of complete rest for you, that you may humble yourselves; it is a permanent statute. ");
INSERT INTO engmsb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","The priest who is anointed and ordained to succeed his father as high priest shall make atonement. He will put on the sacred linen garments ");
INSERT INTO engmsb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","and make atonement for the Most Holy Place, the Tent of Meeting, and the altar, and for the priests and all the people of the assembly. ");
INSERT INTO engmsb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","This is to be a permanent statute for you, to make atonement once a year for the Israelites because of all their sins.” And all this was done as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron, his sons, and all the Israelites and tell them this is what the LORD has commanded: ");
INSERT INTO engmsb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","‘Anyone from the house of Israel who slaughters an ox, a lamb, or a goat in the camp or outside of it ");
INSERT INTO engmsb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","instead of bringing it to the entrance to the Tent of Meeting to present it as an offering to the LORD before His tabernacle—that man shall incur bloodguilt. He has shed blood and must be cut off from among his people. ");
INSERT INTO engmsb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","For this reason the Israelites will bring to the LORD the sacrifices they have been offering in the open fields. They are to bring them to the priest at the entrance to the Tent of Meeting and offer them as sacrifices of peace offerings to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","The priest will then splatter the blood on the altar of the LORD at the entrance to the Tent of Meeting and burn the fat as a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","They must no longer offer their sacrifices to the goat demons to which they have prostituted themselves. This will be a permanent statute for them for the generations to come.’ ");
INSERT INTO engmsb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tell them that if anyone from the house of Israel or any foreigner living among them offers a burnt offering or a sacrifice ");
INSERT INTO engmsb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","but does not bring it to the entrance to the Tent of Meeting to sacrifice it to the LORD, that man must be cut off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","If anyone from the house of Israel or a foreigner living among them eats any blood, I will set My face against that person and cut him off from among his people. ");
INSERT INTO engmsb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","For the life of the flesh is in the blood, and I have given it to you to make atonement for your souls upon the altar; for it is the blood that makes atonement for the soul. ");
INSERT INTO engmsb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Therefore I say to the Israelites, ‘None of you may eat blood, nor may any foreigner living among you eat blood.’ ");
INSERT INTO engmsb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","And if any Israelite or foreigner living among them hunts down a wild animal or bird that may be eaten, he must drain its blood and cover it with dirt. ");
INSERT INTO engmsb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","For the life of all flesh is its blood. Therefore I have told the Israelites, ‘You must not eat the blood of any living thing, because the life of all flesh is its blood; whoever eats it must be cut off.’ ");
INSERT INTO engmsb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","And any person, whether native or foreigner, who eats anything found dead or mauled by wild beasts must wash his clothes and bathe with water, and he will be unclean until evening; then he will be clean. ");
INSERT INTO engmsb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if he does not wash his clothes and bathe himself, then he shall bear his iniquity.” ");
INSERT INTO engmsb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Speak to the Israelites and tell them: I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You must not follow the practices of the land of Egypt, where you used to live, and you must not follow the practices of the land of Canaan, into which I am bringing you. You must not walk in their customs. ");
INSERT INTO engmsb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","You are to practice My judgments and keep My statutes by walking in them. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Keep My statutes and My judgments, for the man who does these things will live by them. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","None of you are to approach any close relative to have sexual relations. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","You must not expose the nakedness of your father by having sexual relations with your mother. She is your mother; you must not have sexual relations with her. ");
INSERT INTO engmsb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","You must not have sexual relations with your father’s wife; it would dishonor your father. ");
INSERT INTO engmsb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","You must not have sexual relations with your sister, either your father’s daughter or your mother’s daughter, whether she was born in the same home or elsewhere. ");
INSERT INTO engmsb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","You must not have sexual relations with your son’s daughter or your daughter’s daughter, for that would shame your family. ");
INSERT INTO engmsb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","You must not have sexual relations with the daughter of your father’s wife, born to your father; she is your sister. ");
INSERT INTO engmsb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","You must not have sexual relations with your father’s sister; she is your father’s close relative. ");
INSERT INTO engmsb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","You must not have sexual relations with your mother’s sister, for she is your mother’s close relative. ");
INSERT INTO engmsb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","You must not dishonor your father’s brother by approaching his wife to have sexual relations with her; she is your aunt. ");
INSERT INTO engmsb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","You must not have sexual relations with your daughter-in-law. She is your son’s wife; you are not to have sexual relations with her. ");
INSERT INTO engmsb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","You must not have sexual relations with your brother’s wife; that would shame your brother. ");
INSERT INTO engmsb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","You must not have sexual relations with both a woman and her daughter. You are not to marry her son’s daughter or her daughter’s daughter and have sexual relations with her. They are close relatives; it is depraved. ");
INSERT INTO engmsb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","You must not take your wife’s sister as a rival wife and have sexual relations with her while your wife is still alive. ");
INSERT INTO engmsb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","You must not approach a woman to have sexual relations with her during her menstrual period. ");
INSERT INTO engmsb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","You must not lie carnally with your neighbor’s wife and thus defile yourself with her. ");
INSERT INTO engmsb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","You must not give any of your children to be sacrificed to Molech, for you must not profane the name of your God. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","You must not lie with a man as with a woman; that is an abomination. ");
INSERT INTO engmsb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","You must not lie carnally with any animal, thus defiling yourself with it; a woman must not stand before an animal to mate with it; that is a perversion. ");
INSERT INTO engmsb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Do not defile yourselves by any of these practices, for by all these things the nations I am driving out before you have defiled themselves. ");
INSERT INTO engmsb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Even the land has become defiled, so I am punishing it for its sin, and the land will vomit out its inhabitants. ");
INSERT INTO engmsb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","But you are to keep My statutes and ordinances, and you must not commit any of these abominations—neither your native-born nor the foreigner who lives among you. ");
INSERT INTO engmsb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","For the men who were in the land before you committed all these abominations, and the land has become defiled. ");
INSERT INTO engmsb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","So if you defile the land, it will vomit you out as it spewed out the nations before you. ");
INSERT INTO engmsb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Therefore anyone who commits any of these abominations must be cut off from among his people. ");
INSERT INTO engmsb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","You must keep My charge not to practice any of the abominable customs that were practiced before you, so that you do not defile yourselves by them. I am the LORD your God.” ");
INSERT INTO engmsb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Speak to the whole congregation of Israel and tell them: Be holy because I, the LORD your God, am holy. ");
INSERT INTO engmsb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Each of you must respect his mother and father, and you must keep My Sabbaths. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Do not turn to idols or make for yourselves molten gods. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","When you sacrifice a peace offering to the LORD, you shall offer it for your acceptance. ");
INSERT INTO engmsb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It shall be eaten on the day you sacrifice it, or on the next day; but what remains on the third day must be burned up. ");
INSERT INTO engmsb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If any of it is eaten on the third day, it is tainted and will not be accepted. ");
INSERT INTO engmsb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Whoever eats it will bear his iniquity, for he has profaned what is holy to the LORD. That person must be cut off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","When you reap the harvest of your land, you are not to reap to the very edges of your field or gather the gleanings of your harvest. ");
INSERT INTO engmsb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","You must not strip your vineyard bare or gather its fallen grapes. Leave them for the poor and the foreigner. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","You must not steal. You must not lie or deceive one another. ");
INSERT INTO engmsb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","You must not swear falsely by My name and so profane the name of your God. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","You must not defraud your neighbor or rob him. You must not withhold until morning the wages due a hired hand. ");
INSERT INTO engmsb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","You must not curse the deaf or place a stumbling block before the blind, but you shall fear your God. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","You must not pervert justice; you must not show partiality to the poor or favoritism to the rich; you are to judge your neighbor fairly. ");
INSERT INTO engmsb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","You must not go about spreading slander among your people. You must not endanger the life of your neighbor. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","You must not harbor hatred against your brother in your heart. Directly rebuke your neighbor, so that you will not incur guilt on account of him. ");
INSERT INTO engmsb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Do not seek revenge or bear a grudge against any of your people, but love your neighbor as yourself. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","You are to keep My statutes. You shall not crossbreed two different kinds of livestock; you shall not sow your fields with two kinds of seed; and you shall not wear clothing made of two kinds of material. ");
INSERT INTO engmsb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","If a man lies carnally with a slave girl promised to another man but who has not been redeemed or given her freedom, there must be due punishment. But they are not to be put to death, because she had not been freed. ");
INSERT INTO engmsb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","The man, however, must bring a ram to the entrance to the Tent of Meeting as his guilt offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","The priest shall make atonement on his behalf before the LORD with the ram of the guilt offering for the sin he has committed, and he will be forgiven the sin he has committed. ");
INSERT INTO engmsb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","When you enter the land and plant any kind of tree for food, you shall regard the fruit as forbidden. For three years it will be forbidden to you and must not be eaten. ");
INSERT INTO engmsb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In the fourth year all its fruit must be consecrated as a praise offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","But in the fifth year you may eat its fruit; thus your harvest will be increased. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","You must not eat anything with blood still in it. You must not practice divination or sorcery. ");
INSERT INTO engmsb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","You must not cut off the hair at the sides of your head or clip off the edges of your beard. ");
INSERT INTO engmsb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","You must not make any cuts in your bodies for the dead or put tattoo marks on yourselves. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","You must not defile your daughter by making her a prostitute, or the land will be prostituted and filled with depravity. ");
INSERT INTO engmsb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","You must keep My Sabbaths and have reverence for My sanctuary. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","You must not turn to mediums or spiritists; do not seek them out, or you will be defiled by them. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","You are to rise in the presence of the elderly, honor the aged, and fear your God. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","When a foreigner resides with you in your land, you must not oppress him. ");
INSERT INTO engmsb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","You must treat the foreigner living among you as native-born and love him as yourself, for you were foreigners in the land of Egypt. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","You must not use dishonest measures of length, weight, or volume. ");
INSERT INTO engmsb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","You shall maintain honest scales and weights, an honest ephah, and an honest hin. I am the LORD your God, who brought you out of the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","You must keep all My statutes and all My ordinances and follow them. I am the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tell the Israelites, ‘Any Israelite or foreigner living in Israel who gives any of his children to Molech must be put to death. The people of the land are to stone him. ");
INSERT INTO engmsb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","And I will set My face against that man and cut him off from his people, because by giving his offspring to Molech, he has defiled My sanctuary and profaned My holy name. ");
INSERT INTO engmsb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","And if the people of the land ever hide their eyes and fail to put to death the man who gives one of his children to Molech, ");
INSERT INTO engmsb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","then I will set My face against that man and his family and cut off from among their people both him and all who follow him in prostituting themselves with Molech. ");
INSERT INTO engmsb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Whoever turns to mediums or spiritists to prostitute himself with them, I will also set My face against that person and cut him off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Consecrate yourselves, therefore, and be holy, because I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","And you shall keep My statutes and practice them. I am the LORD who sanctifies you. ");
INSERT INTO engmsb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","If anyone curses his father or mother, he must be put to death. He has cursed his father or mother; his blood shall be upon him. ");
INSERT INTO engmsb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","If a man commits adultery with another man’s wife—with the wife of his neighbor—both the adulterer and the adulteress must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","If a man lies with his father’s wife, he has uncovered his father’s nakedness. Both must surely be put to death; their blood is upon them. ");
INSERT INTO engmsb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","If a man lies with his daughter-in-law, both must surely be put to death. They have acted perversely; their blood is upon them. ");
INSERT INTO engmsb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","If a man lies with a man as with a woman, they have both committed an abomination. They must surely be put to death; their blood is upon them. ");
INSERT INTO engmsb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","If a man marries both a woman and her mother, it is depraved. Both he and they must be burned in the fire, so that there will be no depravity among you. ");
INSERT INTO engmsb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","If a man lies carnally with an animal, he must be put to death. And you are also to kill the animal. ");
INSERT INTO engmsb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","If a woman approaches any animal to mate with it, you must kill both the woman and the animal. They must surely be put to death; their blood is upon them. ");
INSERT INTO engmsb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","If a man marries his sister, whether the daughter of his father or of his mother, and they have sexual relations, it is a disgrace. They must be cut off in the sight of their people. He has uncovered the nakedness of his sister; he shall bear his iniquity. ");
INSERT INTO engmsb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","If a man lies with a menstruating woman and has sexual relations with her, he has exposed the source of her flow, and she has uncovered the source of her blood. Both of them must be cut off from among their people. ");
INSERT INTO engmsb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","You must not have sexual relations with the sister of your mother or your father, for it is exposing one’s own kin; both shall bear their iniquity. ");
INSERT INTO engmsb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","If a man lies with his uncle’s wife, he has uncovered the nakedness of his uncle. They will bear their sin; they shall die childless. ");
INSERT INTO engmsb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","If a man marries his brother’s wife, it is an act of impurity. He has uncovered the nakedness of his brother; they shall be childless. ");
INSERT INTO engmsb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","You are therefore to keep all My statutes and ordinances, so that the land where I am bringing you to live will not vomit you out. ");
INSERT INTO engmsb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","You must not follow the statutes of the nations I am driving out before you. Because they did all these things, I abhorred them. ");
INSERT INTO engmsb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have told you that you will inherit their land, since I will give it to you as an inheritance—a land flowing with milk and honey. I am the LORD your God, who has set you apart from the peoples. ");
INSERT INTO engmsb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","You are therefore to distinguish between clean and unclean animals and birds. Do not become contaminated by any animal or bird, or by anything that crawls on the ground; I have set these apart as unclean for you. ");
INSERT INTO engmsb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You are to be holy to Me because I, the LORD, am holy, and I have set you apart from the nations to be My own. ");
INSERT INTO engmsb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","A man or a woman who is a medium or spiritist must surely be put to death. They shall be stoned; their blood is upon them.’” ");
INSERT INTO engmsb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Then the LORD said to Moses, “Speak to Aaron’s sons, the priests, and tell them that a priest is not to defile himself for a dead person among his people, ");
INSERT INTO engmsb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","except for his immediate family—his mother, father, son, daughter, or brother, ");
INSERT INTO engmsb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","or his unmarried sister who is near to him, since she has no husband. ");
INSERT INTO engmsb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","He is not to defile himself for those related to him by marriage, and so profane himself. ");
INSERT INTO engmsb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Priests must not make bald spots on their heads, shave off the edges of their beards, or make cuts in their bodies. ");
INSERT INTO engmsb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They must be holy to their God and not profane the name of their God. Because they present to the LORD the food offerings, the food of their God, they must be holy. ");
INSERT INTO engmsb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","A priest must not marry a woman defiled by prostitution or divorced by her husband, for the priest is holy to his God. ");
INSERT INTO engmsb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","You are to regard him as holy, since he presents the food of your God. He shall be holy to you, because I the LORD am holy—I who set you apart. ");
INSERT INTO engmsb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","If a priest’s daughter defiles herself by prostituting herself, she profanes her father; she must be burned in the fire. ");
INSERT INTO engmsb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","The priest who is highest among his brothers, who has had the anointing oil poured on his head and has been ordained to wear the priestly garments, must not let his hair hang loose or tear his garments. ");
INSERT INTO engmsb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not go near any dead body; he must not defile himself, even for his father or mother. ");
INSERT INTO engmsb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He must not leave or desecrate the sanctuary of his God, for the consecration of the anointing oil of his God is on him. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","The woman he marries must be a virgin. ");
INSERT INTO engmsb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He is not to marry a widow, a divorced woman, or one defiled by prostitution. He is to marry a virgin from his own people, ");
INSERT INTO engmsb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","so that he does not defile his offspring among his people, for I am the LORD who sanctifies him.” ");
INSERT INTO engmsb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Say to Aaron, ‘For the generations to come, none of your descendants who has a physical defect may approach to offer the food of his God. ");
INSERT INTO engmsb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","No man who has any defect may approach—no man who is blind, lame, disfigured, or deformed; ");
INSERT INTO engmsb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","no man who has a broken foot or hand, ");
INSERT INTO engmsb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","or who is a hunchback or dwarf, or who has an eye defect, a festering rash, scabs, or a crushed testicle. ");
INSERT INTO engmsb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No descendant of Aaron the priest who has a defect shall approach to present the food offerings to the LORD. Since he has a defect, he is not to come near to offer the food of his God. ");
INSERT INTO engmsb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He may eat the most holy food of his God as well as the holy food, ");
INSERT INTO engmsb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","but because he has a defect, he must not go near the veil or approach the altar, so as not to desecrate My sanctuaries. For I am the LORD who sanctifies them.’” ");
INSERT INTO engmsb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moses told this to Aaron and his sons and to all the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons to treat with respect the sacred offerings that the Israelites have consecrated to Me, so that they do not profane My holy name. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Tell them that for the generations to come, if any of their descendants in a state of uncleanness approaches the sacred offerings that the Israelites consecrate to the LORD, that person must be cut off from My presence. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","If a descendant of Aaron has a skin disease or a discharge, he may not eat the sacred offerings until he is clean. Whoever touches anything defiled by a corpse or by a man who has an emission of semen, ");
INSERT INTO engmsb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or whoever touches a crawling creature or a person that makes him unclean, whatever the uncleanness may be— ");
INSERT INTO engmsb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","the man who touches any of these will remain unclean until evening. He must not eat from the sacred offerings unless he has bathed himself with water. ");
INSERT INTO engmsb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","When the sun has set, he will become clean, and then he may eat from the sacred offerings, for they are his food. ");
INSERT INTO engmsb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He must not eat anything found dead or torn by wild animals, which would make him unclean. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","The priests must keep My charge, lest they bear the guilt and die because they profane it. I am the LORD who sanctifies them. ");
INSERT INTO engmsb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","No one outside a priest’s family may eat the sacred offering, nor may the guest of a priest or his hired hand eat it. ");
INSERT INTO engmsb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if a priest buys a slave with his own money, or if a slave is born in his household, that slave may eat his food. ");
INSERT INTO engmsb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If the priest’s daughter is married to a man other than a priest, she is not to eat of the sacred contributions. ");
INSERT INTO engmsb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest’s daughter with no children becomes widowed or divorced and returns to her father’s house, she may share her father’s food as in her youth. But no outsider may share it. ");
INSERT INTO engmsb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","If anyone eats a sacred offering in error, he must add a fifth to its value and give the sacred offering to the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","The priests must not profane the sacred offerings that the Israelites present to the LORD ");
INSERT INTO engmsb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","by allowing the people to eat the sacred offerings and thus to bear the punishment for guilt. For I am the LORD who sanctifies them.” ");
INSERT INTO engmsb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Speak to Aaron and his sons and all the Israelites and tell them, ‘Any man of the house of Israel or any foreign resident who presents a gift for a burnt offering to the LORD, whether to fulfill a vow or as a freewill offering, ");
INSERT INTO engmsb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","must offer an unblemished male from the cattle, sheep, or goats in order for it to be accepted on your behalf. ");
INSERT INTO engmsb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","You must not present anything with a defect, because it will not be accepted on your behalf. ");
INSERT INTO engmsb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","When a man presents a peace offering to the LORD from the herd or flock to fulfill a vow or as a freewill offering, it must be without blemish or defect to be acceptable. ");
INSERT INTO engmsb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","You are not to present to the LORD any animal that is blind, injured, or maimed, or anything with a running sore, a festering rash, or a scab; you must not put any of these on the altar as a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","You may present as a freewill offering an ox or sheep that has a deformed or stunted limb, but it is not acceptable in fulfillment of a vow. ");
INSERT INTO engmsb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","You are not to present to the LORD an animal whose testicles are bruised, crushed, torn, or cut; you are not to sacrifice them in your land. ");
INSERT INTO engmsb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Neither you nor a foreigner shall present food to your God from any such animal. They will not be accepted on your behalf, because they are deformed and flawed.’” ");
INSERT INTO engmsb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When an ox, a sheep, or a goat is born, it must remain with its mother for seven days. From the eighth day on, it will be acceptable as a food offering presented to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","But you must not slaughter an ox or a sheep on the same day as its young. ");
INSERT INTO engmsb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","When you sacrifice a thank offering to the LORD, offer it so that it may be acceptable on your behalf. ");
INSERT INTO engmsb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","It must be eaten that same day. Do not leave any of it until morning. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","You are to keep My commandments and practice them. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","You must not profane My holy name. I must be acknowledged as holy among the Israelites. I am the LORD who sanctifies you, ");
INSERT INTO engmsb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","who brought you out of the land of Egypt to be your God. I am the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Speak to the Israelites and say to them, ‘These are My appointed feasts, the feasts of the LORD that you are to proclaim as sacred assemblies. ");
INSERT INTO engmsb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","For six days work may be done, but the seventh day is a Sabbath of complete rest, a day of sacred assembly. You must not do any work; wherever you live, it is a Sabbath to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the LORD’s appointed feasts, the sacred assemblies you are to proclaim at their appointed times. ");
INSERT INTO engmsb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","The Passover to the LORD begins at twilight on the fourteenth day of the first month. ");
INSERT INTO engmsb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","On the fifteenth day of the same month begins the Feast of Unleavened Bread to the LORD. For seven days you must eat unleavened bread. ");
INSERT INTO engmsb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day you are to hold a sacred assembly; you are not to do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","For seven days you are to present a food offering to the LORD. On the seventh day there shall be a sacred assembly; you must not do any regular work.’” ");
INSERT INTO engmsb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Speak to the Israelites and say, ‘When you enter the land that I am giving you and you reap its harvest, you are to bring to the priest a sheaf of the firstfruits of your harvest. ");
INSERT INTO engmsb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","And he shall wave the sheaf before the LORD so that it may be accepted on your behalf; the priest is to wave it on the day after the Sabbath. ");
INSERT INTO engmsb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","On the day you wave the sheaf, you shall offer a year-old lamb without blemish as a burnt offering to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","along with its grain offering of two-tenths of an ephah of fine flour mixed with oil—a food offering to the LORD, a pleasing aroma—and its drink offering of a quarter hin of wine. ");
INSERT INTO engmsb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","You must not eat any bread or roasted or new grain until the very day you have brought this offering to your God. This is to be a permanent statute for the generations to come, wherever you live. ");
INSERT INTO engmsb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","From the day after the Sabbath, the day you brought the sheaf of the wave offering, you are to count off seven full weeks. ");
INSERT INTO engmsb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","You shall count off fifty days until the day after the seventh Sabbath, and then present an offering of new grain to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bring two loaves of bread from your dwellings as a wave offering, each made from two-tenths of an ephah of fine flour, baked with leaven, as the firstfruits to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Along with the bread you are to present seven unblemished male lambs a year old, one young bull, and two rams. They will be a burnt offering to the LORD, together with their grain offerings and drink offerings—a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","You shall also prepare one male goat as a sin offering and two male lambs a year old as a peace offering. ");
INSERT INTO engmsb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","The priest is to wave the lambs as a wave offering before the LORD, together with the bread of the firstfruits. The bread and the two lambs shall be holy to the LORD for the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","On that same day you are to proclaim a sacred assembly, and you must not do any regular work. This is to be a permanent statute wherever you live for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","When you reap the harvest of your land, do not reap all the way to the edges of your field or gather the gleanings of your harvest. Leave them for the poor and the foreign resident. I am the LORD your God.’” ");
INSERT INTO engmsb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","The LORD also said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Speak to the Israelites and say, ‘On the first day of the seventh month you are to have a day of rest, a sacred assembly announced by trumpet blasts. ");
INSERT INTO engmsb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","You must not do any regular work, but you are to present a food offering to the LORD.’” ");
INSERT INTO engmsb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Again the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“The tenth day of this seventh month is the Day of Atonement. You shall hold a sacred assembly and humble yourselves, and present a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","On this day you are not to do any work, for it is the Day of Atonement, when atonement is made for you before the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","If anyone does not humble himself on this day, he must be cut off from his people. ");
INSERT INTO engmsb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","I will destroy from among his people anyone who does any work on this day. ");
INSERT INTO engmsb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You are not to do any work at all. This is a permanent statute for the generations to come, wherever you live. ");
INSERT INTO engmsb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It will be a Sabbath of complete rest for you, and you shall humble yourselves. From the evening of the ninth day of the month until the following evening you are to keep your Sabbath.” ");
INSERT INTO engmsb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Speak to the Israelites and say, ‘On the fifteenth day of the seventh month the Feast of Tabernacles to the LORD begins, and it continues for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day there shall be a sacred assembly. You must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","For seven days you are to present a food offering to the LORD. On the eighth day you are to hold a sacred assembly and present a food offering to the LORD. It is a solemn assembly; you must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the LORD’s appointed feasts, which you are to proclaim as sacred assemblies for presenting food offerings to the LORD—burnt offerings and grain offerings, sacrifices and drink offerings, each on its designated day. ");
INSERT INTO engmsb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","These offerings are in addition to the offerings for the LORD’s Sabbaths, and in addition to your gifts, to all your vow offerings, and to all the freewill offerings you give to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","On the fifteenth day of the seventh month, after you have gathered the produce of the land, you are to celebrate a feast to the LORD for seven days. There shall be complete rest on the first day and also on the eighth day. ");
INSERT INTO engmsb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day you are to gather the fruit of majestic trees, the branches of palm trees, and the boughs of leafy trees and of willows of the brook. And you are to rejoice before the LORD your God for seven days. ");
INSERT INTO engmsb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You are to celebrate this as a feast to the LORD for seven days each year. This is a permanent statute for the generations to come; you are to celebrate it in the seventh month. ");
INSERT INTO engmsb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You are to dwell in booths for seven days. All the native-born of Israel must dwell in booths, ");
INSERT INTO engmsb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","so that your descendants may know that I made the Israelites dwell in booths when I brought them out of the land of Egypt. I am the LORD your God.’” ");
INSERT INTO engmsb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses announced to the Israelites the appointed feasts of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the Israelites to bring you pure oil of pressed olives for the light, to keep the lamps burning continually. ");
INSERT INTO engmsb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Outside the veil of the Testimony in the Tent of Meeting, Aaron is to tend the lamps continually before the LORD from evening until morning. This is to be a permanent statute for the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","He shall tend the lamps on the pure gold lampstand before the LORD continually. ");
INSERT INTO engmsb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","You are also to take fine flour and bake twelve loaves, using two-tenths of an ephah for each loaf, ");
INSERT INTO engmsb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","and set them in two rows—six per row—on the table of pure gold before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","And you are to place pure frankincense near each row, so that it may serve as a memorial portion for the bread, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day the bread is to be set out before the LORD on behalf of the Israelites as a permanent covenant. ");
INSERT INTO engmsb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","It belongs to Aaron and his sons, who are to eat it in a holy place; for it is to him a most holy part of the food offerings to the LORD—his portion forever.” ");
INSERT INTO engmsb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Now the son of an Israelite mother and an Egyptian father went out among the Israelites, and a fight broke out in the camp between him and an Israelite. ");
INSERT INTO engmsb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The son of the Israelite woman blasphemed the Name with a curse. So they brought him to Moses. (His mother’s name was Shelomith daughter of Dibri, of the tribe of Dan.) ");
INSERT INTO engmsb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","They placed him in custody until the will of the LORD should be made clear to them. ");
INSERT INTO engmsb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Take the blasphemer outside the camp, and have all who heard him lay their hands on his head; then have the whole assembly stone him. ");
INSERT INTO engmsb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","And you are to tell the Israelites, ‘If anyone curses his God, he shall bear the consequences of his sin. ");
INSERT INTO engmsb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Whoever blasphemes the name of the LORD must surely be put to death; the whole assembly must surely stone him, whether he is a foreign resident or native; if he blasphemes the Name, he must be put to death. ");
INSERT INTO engmsb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","And if a man takes the life of anyone else, he must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Whoever kills an animal must make restitution—life for life. ");
INSERT INTO engmsb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","If anyone injures his neighbor, whatever he has done must be done to him: ");
INSERT INTO engmsb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture for fracture, eye for eye, tooth for tooth. Just as he injured the other person, the same must be inflicted on him. ");
INSERT INTO engmsb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Whoever kills an animal must make restitution, but whoever kills a man must be put to death. ");
INSERT INTO engmsb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","You are to have the same standard of law for the foreign resident and the native; for I am the LORD your God.’” ");
INSERT INTO engmsb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Then Moses spoke to the Israelites, and they took the blasphemer outside the camp and stoned him. So the Israelites did as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Then the LORD said to Moses on Mount Sinai, ");
INSERT INTO engmsb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Speak to the Israelites and say to them: When you enter the land that I am giving you, the land itself must observe a Sabbath to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","For six years you may sow your field and prune your vineyard and gather its crops. ");
INSERT INTO engmsb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But in the seventh year there shall be a Sabbath of complete rest for the land—a Sabbath to the LORD. You are not to sow your field or prune your vineyard. ");
INSERT INTO engmsb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","You are not to reap the aftergrowth of your harvest or gather the grapes of your untended vines. The land must have a year of complete rest. ");
INSERT INTO engmsb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Whatever the land yields during the Sabbath year shall be food for you—for yourself, your manservant and maidservant, the hired hand or foreigner who stays with you, ");
INSERT INTO engmsb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","and for your livestock and the wild animals in your land. All its growth may serve as food. ");
INSERT INTO engmsb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","And you shall count off seven Sabbaths of years—seven times seven years—so that the seven Sabbaths of years amount to forty-nine years. ");
INSERT INTO engmsb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then you are to sound the horn far and wide on the tenth day of the seventh month, the Day of Atonement. You shall sound it throughout your land. ");
INSERT INTO engmsb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","So you are to consecrate the fiftieth year and proclaim liberty in the land for all its inhabitants. It shall be your Jubilee, when each of you is to return to his property and to his clan. ");
INSERT INTO engmsb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","The fiftieth year will be a Jubilee for you; you are not to sow the land or reap its aftergrowth or harvest the untended vines. ");
INSERT INTO engmsb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","For it is a Jubilee; it shall be holy to you. You may eat only the crops taken directly from the field. ");
INSERT INTO engmsb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In this Year of Jubilee, each of you shall return to his own property. ");
INSERT INTO engmsb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","If you make a sale to your neighbor or a purchase from him, you must not take advantage of each other. ");
INSERT INTO engmsb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","You are to buy from your neighbor according to the number of years since the last Jubilee; he is to sell to you according to the number of harvest years remaining. ");
INSERT INTO engmsb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","You shall increase the price in proportion to a greater number of years, or decrease it in proportion to a lesser number of years; for he is selling you a given number of harvests. ");
INSERT INTO engmsb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Do not take advantage of each other, but fear your God; for I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","You are to keep My statutes and carefully observe My judgments, so that you may dwell securely in the land. ");
INSERT INTO engmsb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Then the land will yield its fruit, so that you can eat your fill and dwell in safety in the land. ");
INSERT INTO engmsb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Now you may wonder, ‘What will we eat in the seventh year if we do not sow or gather our produce?’ ");
INSERT INTO engmsb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","But I will send My blessing upon you in the sixth year, so that the land will yield a crop sufficient for three years. ");
INSERT INTO engmsb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","While you are sowing in the eighth year, you will be eating from the previous harvest, until the ninth year’s harvest comes in. ");
INSERT INTO engmsb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","The land must not be sold permanently, because it is Mine, and you are but foreigners and residents with Me. ");
INSERT INTO engmsb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Thus for every piece of property you possess, you must provide for the redemption of the land. ");
INSERT INTO engmsb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If your brother becomes impoverished and sells some of his property, his nearest of kin may come and redeem what his brother has sold. ");
INSERT INTO engmsb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Or if a man has no one to redeem it for him, but he prospers and acquires enough to redeem his land, ");
INSERT INTO engmsb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","he shall calculate the years since its sale, repay the balance to the man to whom he sold it, and return to his property. ");
INSERT INTO engmsb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if he cannot obtain enough to repay him, what he sold will remain in possession of the buyer until the Year of Jubilee. In the Jubilee, however, it is to be released, so that he may return to his property. ");
INSERT INTO engmsb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","If a man sells a house in a walled city, he retains his right of redemption until a full year after its sale; during that year it may be redeemed. ");
INSERT INTO engmsb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If it is not redeemed by the end of a full year, then the house in the walled city is permanently transferred to its buyer and his descendants. It is not to be released in the Jubilee. ");
INSERT INTO engmsb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But houses in villages with no walls around them are to be considered as open fields. They may be redeemed, and they shall be released in the Jubilee. ");
INSERT INTO engmsb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","As for the cities of the Levites, the Levites always have the right to redeem their houses in the cities they possess. ");
INSERT INTO engmsb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","So whatever belongs to the Levites may be redeemed—a house sold in a city they possess—and must be released in the Jubilee, because the houses in the cities of the Levites are their possession among the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","But the open pastureland around their cities may not be sold, for this is their permanent possession. ");
INSERT INTO engmsb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Now if your countryman becomes destitute and cannot support himself among you, then you are to help him as you would a foreigner or stranger, so that he can continue to live among you. ");
INSERT INTO engmsb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Do not take any interest or profit from him, but fear your God, that your countryman may live among you. ");
INSERT INTO engmsb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","You must not lend him your silver at interest or sell him your food for profit. ");
INSERT INTO engmsb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the LORD your God, who brought you out of the land of Egypt to give you the land of Canaan and to be your God. ");
INSERT INTO engmsb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","If a countryman among you becomes destitute and sells himself to you, then you must not force him into slave labor. ");
INSERT INTO engmsb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Let him stay with you as a hired worker or temporary resident; he is to work for you until the Year of Jubilee. ");
INSERT INTO engmsb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then he and his children are to be released, and he may return to his clan and to the property of his fathers. ");
INSERT INTO engmsb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Because the Israelites are My servants, whom I brought out of the land of Egypt, they are not to be sold as slaves. ");
INSERT INTO engmsb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","You are not to rule over them harshly, but you shall fear your God. ");
INSERT INTO engmsb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Your menservants and maidservants shall come from the nations around you, from whom you may purchase them. ");
INSERT INTO engmsb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","You may also purchase them from the foreigners residing among you or their clans living among you who are born in your land. These may become your property. ");
INSERT INTO engmsb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You may leave them to your sons after you to inherit as property; you can make them slaves for life. But as for your brothers, the Israelites, no man may rule harshly over his brother. ");
INSERT INTO engmsb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","If a foreigner residing among you prospers, but your countryman dwelling near him becomes destitute and sells himself to the foreigner or to a member of his clan, ");
INSERT INTO engmsb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","he retains the right of redemption after he has sold himself. One of his brothers may redeem him: ");
INSERT INTO engmsb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","either his uncle or cousin or any close relative from his clan may redeem him. Or if he prospers, he may redeem himself. ");
INSERT INTO engmsb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","He and his purchaser will then count the time from the year he sold himself up to the Year of Jubilee. The price of his sale will be determined by the number of years, based on the daily wages of a hired hand. ");
INSERT INTO engmsb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If many years remain, he must pay for his redemption in proportion to his purchase price. ");
INSERT INTO engmsb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If only a few years remain until the Year of Jubilee, he is to calculate and pay his redemption according to his remaining years. ");
INSERT INTO engmsb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","He shall be treated like a man hired from year to year, but a foreign owner must not rule over him harshly in your sight. ");
INSERT INTO engmsb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Even if he is not redeemed in any of these ways, he and his children shall be released in the Year of Jubilee. ");
INSERT INTO engmsb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For the Israelites are My servants. They are My servants, whom I brought out of the land of Egypt. I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“You must not make idols for yourselves or set up a carved image or sacred pillar; you must not place a sculpted stone in your land to bow down to it. For I am the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","You must keep My Sabbaths and have reverence for My sanctuary. I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If you follow My statutes and carefully keep My commandments, ");
INSERT INTO engmsb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","I will give you rains in their season, and the land will yield its produce, and the trees of the field will bear their fruit. ");
INSERT INTO engmsb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Your threshing will continue until the grape harvest, and the grape harvest will continue until sowing time; you will have your fill of food to eat and will dwell securely in your land. ");
INSERT INTO engmsb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","And I will give peace to the land, and you will lie down with nothing to fear. I will rid the land of dangerous animals, and no sword will pass through your land. ");
INSERT INTO engmsb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You will pursue your enemies, and they will fall by the sword before you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will pursue a hundred, and a hundred of you will pursue ten thousand, and your enemies will fall by the sword before you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I will turn toward you and make you fruitful and multiply you, and I will establish My covenant with you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You will still be eating the old supply of grain when you need to clear it out to make room for the new. ");
INSERT INTO engmsb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","And I will make My dwelling place among you, and My soul will not despise you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk among you and be your God, and you will be My people. ");
INSERT INTO engmsb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the LORD your God, who brought you out of the land of Egypt so that you would no longer be slaves to the Egyptians. I broke the bars of your yoke and enabled you to walk in uprightness. ");
INSERT INTO engmsb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","If, however, you fail to obey Me and to carry out all these commandments, ");
INSERT INTO engmsb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","and if you reject My statutes, despise My ordinances, and neglect to carry out all My commandments, and so break My covenant, ");
INSERT INTO engmsb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","then this is what I will do to you: I will bring upon you sudden terror, wasting disease, and fever that will destroy your sight and drain your life. You will sow your seed in vain, because your enemies will eat it. ");
INSERT INTO engmsb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","And I will set My face against you, so that you will be defeated by your enemies. Those who hate you will rule over you, and you will flee when no one pursues you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","And if after all this you will not obey Me, I will proceed to punish you sevenfold for your sins. ");
INSERT INTO engmsb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will break down your stubborn pride and make your sky like iron and your land like bronze, ");
INSERT INTO engmsb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","and your strength will be spent in vain. For your land will not yield its produce, and the trees of the land will not bear their fruit. ");
INSERT INTO engmsb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","If you walk in hostility toward Me and refuse to obey Me, I will multiply your plagues seven times, according to your sins. ");
INSERT INTO engmsb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send wild animals against you to rob you of your children, destroy your livestock, and reduce your numbers, until your roads lie desolate. ");
INSERT INTO engmsb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","And if in spite of these things you do not accept My discipline, but continue to walk in hostility toward Me, ");
INSERT INTO engmsb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I will act with hostility toward you, and I will strike you sevenfold for your sins. ");
INSERT INTO engmsb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","And I will bring a sword against you to execute the vengeance of the covenant. Though you withdraw into your cities, I will send a plague among you, and you will be delivered into the hand of the enemy. ");
INSERT INTO engmsb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","When I cut off your supply of bread, ten women will bake your bread in a single oven and dole out your bread by weight, so that you will eat but not be satisfied. ");
INSERT INTO engmsb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","But if in spite of all this you do not obey Me, but continue to walk in hostility toward Me, ");
INSERT INTO engmsb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I will walk in fury against you, and I, even I, will punish you sevenfold for your sins. ");
INSERT INTO engmsb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will eat the flesh of your own sons and daughters. ");
INSERT INTO engmsb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places, cut down your incense altars, and heap your lifeless bodies on the lifeless remains of your idols; and My soul will despise you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will reduce your cities to rubble and lay waste your sanctuaries, and I will refuse to smell the pleasing aroma of your sacrifices. ");
INSERT INTO engmsb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","And I will lay waste the land, so that your enemies who dwell in it will be appalled. ");
INSERT INTO engmsb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","But I will scatter you among the nations and will draw out a sword after you as your land becomes desolate and your cities are laid waste. ");
INSERT INTO engmsb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Then the land shall enjoy its Sabbaths all the days it lies desolate, while you are in the land of your enemies. At that time the land will rest and enjoy its Sabbaths. ");
INSERT INTO engmsb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","As long as it lies desolate, the land will have the rest it did not receive during the Sabbaths when you lived in it. ");
INSERT INTO engmsb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","As for those of you who survive, I will send a faintness into their hearts in the lands of their enemies, so that even the sound of a windblown leaf will put them to flight. And they will flee as one flees the sword, and fall when no one pursues them. ");
INSERT INTO engmsb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","They will stumble over one another as before the sword, though no one is behind them. So you will not be able to stand against your enemies. ");
INSERT INTO engmsb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You will perish among the nations, and the land of your enemies will consume you. ");
INSERT INTO engmsb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Those of you who survive in the lands of your enemies will waste away in their iniquity and will decay in the sins of their fathers. ");
INSERT INTO engmsb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","But if they will confess their iniquity and that of their fathers in the unfaithfulness that they practiced against Me, by which they have also walked in hostility toward Me— ");
INSERT INTO engmsb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","and I acted with hostility toward them and brought them into the land of their enemies—and if their uncircumcised hearts will be humbled and they will make amends for their iniquity, ");
INSERT INTO engmsb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","then I will remember My covenant with Jacob and My covenant with Isaac and My covenant with Abraham, and I will remember the land. ");
INSERT INTO engmsb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","For the land will be abandoned by them, and it will enjoy its Sabbaths by lying desolate without them. And they will pay the penalty for their iniquity, because they rejected My ordinances and abhorred My statutes. ");
INSERT INTO engmsb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Yet in spite of this, when they are in the land of their enemies, I will not reject or despise them so as to destroy them and break My covenant with them; for I am the LORD their God. ");
INSERT INTO engmsb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","But for their sake I will remember the covenant with their fathers, whom I brought out of the land of Egypt in the sight of the nations, that I might be their God. I am the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the statutes, ordinances, and laws that the LORD established between Himself and the Israelites through Moses on Mount Sinai. ");
INSERT INTO engmsb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Speak to the Israelites and say to them, ‘When someone makes a special vow to the LORD involving the value of persons, ");
INSERT INTO engmsb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","if the valuation concerns a male from twenty to sixty years of age, then your valuation shall be fifty shekels of silver, according to the sanctuary shekel. ");
INSERT INTO engmsb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Or if it is a female, then your valuation shall be thirty shekels. ");
INSERT INTO engmsb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","And if the person is from five to twenty years of age, then your valuation for the male shall be twenty shekels, and for the female ten shekels. ");
INSERT INTO engmsb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Now if the person is from one month to five years of age, then your valuation for the male shall be five shekels of silver, and for the female three shekels of silver. ");
INSERT INTO engmsb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","And if the person is sixty years of age or older, then your valuation shall be fifteen shekels for the male and ten shekels for the female. ");
INSERT INTO engmsb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","But if the one making the vow is too poor to pay the valuation, he is to present the person before the priest, who shall set the value according to what the one making the vow can afford. ");
INSERT INTO engmsb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","If he vows an animal that may be brought as an offering to the LORD, any such animal given to the LORD shall be holy. ");
INSERT INTO engmsb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He must not replace it or exchange it, either good for bad or bad for good. But if he does substitute one animal for another, both that animal and its substitute will be holy. ");
INSERT INTO engmsb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","But if the vow involves any of the unclean animals that may not be brought as an offering to the LORD, the animal must be presented before the priest. ");
INSERT INTO engmsb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","The priest shall set its value, whether high or low; as the priest values it, the price will be set. ");
INSERT INTO engmsb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If, however, the owner decides to redeem the animal, he must add a fifth to its value. ");
INSERT INTO engmsb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Now if a man consecrates his house as holy to the LORD, then the priest shall value it either as good or bad. The price will stand just as the priest values it. ");
INSERT INTO engmsb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","But if he who consecrated his house redeems it, he must add a fifth to the assessed value, and it will belong to him. ");
INSERT INTO engmsb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","If a man consecrates to the LORD a parcel of his land, then your valuation shall be proportional to the seed required for it—fifty shekels of silver for every homer of barley seed. ");
INSERT INTO engmsb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If he consecrates his field during the Year of Jubilee, the price will stand according to your valuation. ");
INSERT INTO engmsb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if he consecrates his field after the Jubilee, the priest is to calculate the price in proportion to the years left until the next Year of Jubilee, so that your valuation will be reduced. ");
INSERT INTO engmsb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","And if the one who consecrated the field decides to redeem it, he must add a fifth to the assessed value, and it shall belong to him. ");
INSERT INTO engmsb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","If, however, he does not redeem the field, or if he has sold it to another man, it may no longer be redeemed. ");
INSERT INTO engmsb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","When the field is released in the Jubilee, it will become holy, like a field devoted to the LORD; it becomes the property of the priests. ");
INSERT INTO engmsb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Now if a man consecrates to the LORD a field he has purchased, which is not a part of his own property, ");
INSERT INTO engmsb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then the priest shall calculate for him the value up to the Year of Jubilee, and the man shall pay the assessed value on that day as a sacred offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the Year of Jubilee the field shall return to the one from whom it was bought—the original owner of the land. ");
INSERT INTO engmsb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Every valuation will be according to the sanctuary shekel, twenty gerahs to the shekel. ");
INSERT INTO engmsb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","But no one may consecrate a firstborn of the livestock, because a firstborn belongs to the LORD. Whether it is an ox or a sheep, it is the LORD’s. ");
INSERT INTO engmsb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","But if it is among the unclean animals, then he may redeem it according to your valuation and add a fifth of its value. If it is not redeemed, then it shall be sold according to your valuation. ");
INSERT INTO engmsb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Nothing that a man sets apart to the LORD from all he owns—whether a man, an animal, or his inherited land—can be sold or redeemed; everything so devoted is most holy to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","No person set apart for destruction may be ransomed; he must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Thus any tithe from the land, whether from the seed of the land or the fruit of the trees, belongs to the LORD; it is holy to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If a man wishes to redeem part of his tithe, he must add a fifth to its value. ");
INSERT INTO engmsb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Every tenth animal from the herd or flock that passes under the shepherd’s rod will be holy to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","He must not inspect whether it is good or bad, and he shall not make any substitution. But if he does make a substitution, both the animal and its substitute shall become holy; they cannot be redeemed.’” ");
INSERT INTO engmsb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commandments that the LORD gave to Moses for the Israelites on Mount Sinai. ");
INSERT INTO engmsb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","On the first day of the second month of the second year after the Israelites had come out of the land of Egypt, the LORD spoke to Moses in the Tent of Meeting in the Wilderness of Sinai. He said: ");
INSERT INTO engmsb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Take a census of the whole congregation of Israel by their clans and families, listing every man by name, one by one. ");
INSERT INTO engmsb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","You and Aaron are to number those who are twenty years of age or older by their divisions—everyone who can serve in Israel’s army. ");
INSERT INTO engmsb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","And one man from each tribe, the head of each family, must be there with you. ");
INSERT INTO engmsb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of the men who are to assist you: From the tribe of Reuben, Elizur son of Shedeur; ");
INSERT INTO engmsb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","from Simeon, Shelumiel son of Zurishaddai; ");
INSERT INTO engmsb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","from Judah, Nahshon son of Amminadab; ");
INSERT INTO engmsb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","from Issachar, Nethanel son of Zuar; ");
INSERT INTO engmsb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","from Zebulun, Eliab son of Helon; ");
INSERT INTO engmsb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","from the sons of Joseph: from Ephraim, Elishama son of Ammihud, and from Manasseh, Gamaliel son of Pedahzur; ");
INSERT INTO engmsb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","from Benjamin, Abidan son of Gideoni; ");
INSERT INTO engmsb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","from Dan, Ahiezer son of Ammishaddai; ");
INSERT INTO engmsb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","from Asher, Pagiel son of Ocran; ");
INSERT INTO engmsb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","from Gad, Eliasaph son of Deuel; ");
INSERT INTO engmsb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","and from Naphtali, Ahira son of Enan.” ");
INSERT INTO engmsb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These men were appointed from the congregation; they were the leaders of the tribes of their fathers, the heads of the clans of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","So Moses and Aaron took these men who had been designated by name, ");
INSERT INTO engmsb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and on the first day of the second month they assembled the whole congregation and recorded their ancestry by clans and families, counting one by one the names of those twenty years of age or older, ");
INSERT INTO engmsb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","just as the LORD had commanded Moses. So Moses numbered them in the Wilderness of Sinai: ");
INSERT INTO engmsb_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","From the sons of Reuben, the firstborn of Israel, according to the records of their clans and families, counting one by one the names of every male twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","those registered to the tribe of Reuben numbered 46,500. ");
INSERT INTO engmsb_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","From the sons of Simeon, according to the records of their clans and families, counting one by one the names of every male twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","those registered to the tribe of Simeon numbered 59,300. ");
INSERT INTO engmsb_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","From the sons of Gad, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","those registered to the tribe of Gad numbered 45,650. ");
INSERT INTO engmsb_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","From the sons of Judah, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","those registered to the tribe of Judah numbered 74,600. ");
INSERT INTO engmsb_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","From the sons of Issachar, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","those registered to the tribe of Issachar numbered 54,400. ");
INSERT INTO engmsb_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","From the sons of Zebulun, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","those registered to the tribe of Zebulun numbered 57,400. ");
INSERT INTO engmsb_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","From the sons of Joseph: From the sons of Ephraim, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","those registered to the tribe of Ephraim numbered 40,500. ");
INSERT INTO engmsb_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","And from the sons of Manasseh, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","those registered to the tribe of Manasseh numbered 32,200. ");
INSERT INTO engmsb_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","From the sons of Benjamin, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","those registered to the tribe of Benjamin numbered 35,400. ");
INSERT INTO engmsb_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","From the sons of Dan, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","those registered to the tribe of Dan numbered 62,700. ");
INSERT INTO engmsb_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","From the sons of Asher, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","those registered to the tribe of Asher numbered 41,500. ");
INSERT INTO engmsb_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","From the sons of Naphtali, according to the records of their clans and families, counting the names of all those twenty years of age or older who could serve in the army, ");
INSERT INTO engmsb_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","those registered to the tribe of Naphtali numbered 53,400. ");
INSERT INTO engmsb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These were the men numbered by Moses and Aaron, with the assistance of the twelve leaders of Israel, each one representing his family. ");
INSERT INTO engmsb_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","So all the Israelites twenty years of age or older who could serve in Israel’s army were counted according to their families. ");
INSERT INTO engmsb_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","And all those counted totaled 603,550. ");
INSERT INTO engmsb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","The Levites, however, were not numbered along with them by the tribe of their fathers. ");
INSERT INTO engmsb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","For the LORD had said to Moses: ");
INSERT INTO engmsb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Do not number the tribe of Levi in the census with the other Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Instead, you are to appoint the Levites over the tabernacle of the Testimony, all its furnishings, and everything in it. They shall carry the tabernacle and all its articles, care for it, and camp around it. ");
INSERT INTO engmsb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Whenever the tabernacle is to move, the Levites are to take it down, and whenever it is to be pitched, the Levites are to set it up. Any outsider who goes near it must be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The Israelites are to camp by their divisions, each man in his own camp and under his own standard. ");
INSERT INTO engmsb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levites are to camp around the tabernacle of the Testimony and watch over it, so that no wrath will fall on the congregation of Israel. So the Levites are responsible for the tabernacle of the Testimony.” ");
INSERT INTO engmsb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Thus the Israelites did everything just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Then the LORD said to Moses and Aaron: ");
INSERT INTO engmsb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“The Israelites are to camp around the Tent of Meeting at a distance from it, each man under his standard, with the banners of his family. ");
INSERT INTO engmsb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","On the east side, toward the sunrise, the divisions of Judah are to camp under their standard: The leader of the Judahites is Nahshon son of Amminadab, ");
INSERT INTO engmsb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","and his division numbers 74,600. ");
INSERT INTO engmsb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","The tribe of Issachar will camp next to it. The leader of the Issacharites is Nethanel son of Zuar, ");
INSERT INTO engmsb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","and his division numbers 54,400. ");
INSERT INTO engmsb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Next will be the tribe of Zebulun. The leader of the Zebulunites is Eliab son of Helon, ");
INSERT INTO engmsb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","and his division numbers 57,400. ");
INSERT INTO engmsb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","The total number of men in the divisions of the camp of Judah is 186,400; they shall set out first. ");
INSERT INTO engmsb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","On the south side, the divisions of Reuben are to camp under their standard: The leader of the Reubenites is Elizur son of Shedeur, ");
INSERT INTO engmsb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","and his division numbers 46,500. ");
INSERT INTO engmsb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","The tribe of Simeon will camp next to it. The leader of the Simeonites is Shelumiel son of Zurishaddai, ");
INSERT INTO engmsb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","and his division numbers 59,300. ");
INSERT INTO engmsb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Next will be the tribe of Gad. The leader of the Gadites is Eliasaph son of Deuel, ");
INSERT INTO engmsb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","and his division numbers 45,650. ");
INSERT INTO engmsb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","The total number of men in the divisions of the camp of Reuben is 151,450; they shall set out second. ");
INSERT INTO engmsb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","In the middle of the camps, the Tent of Meeting is to travel with the camp of the Levites. They are to set out in the order they encamped, each in his own place under his standard. ");
INSERT INTO engmsb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","On the west side, the divisions of Ephraim are to camp under their standard: The leader of the Ephraimites is Elishama son of Ammihud, ");
INSERT INTO engmsb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","and his division numbers 40,500. ");
INSERT INTO engmsb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","The tribe of Manasseh will be next to it. The leader of the Manassites is Gamaliel son of Pedahzur, ");
INSERT INTO engmsb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","and his division numbers 32,200. ");
INSERT INTO engmsb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Next will be the tribe of Benjamin. The leader of the Benjamites is Abidan son of Gideoni, ");
INSERT INTO engmsb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","and his division numbers 35,400. ");
INSERT INTO engmsb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","The total number of men in the divisions of the camp of Ephraim is 108,100; they shall set out third. ");
INSERT INTO engmsb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","On the north side, the divisions of Dan are to camp under their standard: The leader of the Danites is Ahiezer son of Ammishaddai, ");
INSERT INTO engmsb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","and his division numbers 62,700. ");
INSERT INTO engmsb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","The tribe of Asher will camp next to it. The leader of the Asherites is Pagiel son of Ocran, ");
INSERT INTO engmsb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","and his division numbers 41,500. ");
INSERT INTO engmsb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Next will be the tribe of Naphtali. The leader of the Naphtalites is Ahira son of Enan, ");
INSERT INTO engmsb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","and his division numbers 53,400. ");
INSERT INTO engmsb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","The total number of men in the camp of Dan is 157,600; they shall set out last, under their standards.” ");
INSERT INTO engmsb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","These are the Israelites, numbered according to their families. The total of those counted in the camps, by their divisions, was 603,550. ");
INSERT INTO engmsb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","But the Levites were not counted among the other Israelites, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","So the Israelites did everything the LORD commanded Moses; they camped under their standards in this way and set out in the same way, each man with his clan and his family. ");
INSERT INTO engmsb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","This is the account of Aaron and Moses at the time the LORD spoke with Moses on Mount Sinai. ");
INSERT INTO engmsb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","These are the names of the sons of Aaron: Nadab the firstborn, then Abihu, Eleazar, and Ithamar. ");
INSERT INTO engmsb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These were Aaron’s sons, the anointed priests, who were ordained to serve as priests. ");
INSERT INTO engmsb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab and Abihu, however, died in the presence of the LORD when they offered unauthorized fire before the LORD in the Wilderness of Sinai. And since they had no sons, only Eleazar and Ithamar served as priests during the lifetime of their father Aaron. ");
INSERT INTO engmsb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring the tribe of Levi and present them to Aaron the priest to assist him. ");
INSERT INTO engmsb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They are to perform duties for him and for the whole congregation before the Tent of Meeting, attending to the service of the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","They shall take care of all the furnishings of the Tent of Meeting and fulfill obligations for the Israelites by attending to the service of the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Assign the Levites to Aaron and his sons; they have been given exclusively to him from among the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","So you shall appoint Aaron and his sons to carry out the duties of the priesthood; but any outsider who approaches the tabernacle must be put to death.” ");
INSERT INTO engmsb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Again the LORD spoke to Moses, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Behold, I have taken the Levites from among the children of Israel in place of every firstborn Israelite from the womb. The Levites belong to Me, ");
INSERT INTO engmsb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","for all the firstborn are Mine. On the day I struck down every firstborn in the land of Egypt, I consecrated to Myself all the firstborn in Israel, both man and beast. They are Mine; I am the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Then the LORD spoke to Moses in the Wilderness of Sinai, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Number the Levites by their families and clans. You are to count every male a month old or more.” ");
INSERT INTO engmsb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses numbered them according to the word of the LORD, as he had been commanded. ");
INSERT INTO engmsb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","These were the sons of Levi by name: Gershon, Kohath, and Merari. ");
INSERT INTO engmsb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","These were the names of the sons of Gershon by their clans: Libni and Shimei. ");
INSERT INTO engmsb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","The sons of Kohath by their clans were Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engmsb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","And the sons of Merari by their clans were Mahli and Mushi. These were the clans of the Levites, according to their families. ");
INSERT INTO engmsb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","From Gershon came the Libnite clan and the Shimeite clan; these were the Gershonite clans. ");
INSERT INTO engmsb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","The number of all the males a month old or more was 7,500. ");
INSERT INTO engmsb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The Gershonite clans were to camp on the west, behind the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","and the leader of the families of the Gershonites was Eliasaph son of Lael. ");
INSERT INTO engmsb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","The duties of the Gershonites at the Tent of Meeting were the tabernacle and tent, its covering, the curtain for the entrance to the Tent of Meeting, ");
INSERT INTO engmsb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","the curtains of the courtyard, the curtain for the entrance to the courtyard that surrounds the tabernacle and altar, and the cords—all the service for these items. ");
INSERT INTO engmsb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","From Kohath came the clans of the Amramites, the Izharites, the Hebronites, and the Uzzielites; these were the clans of the Kohathites. ");
INSERT INTO engmsb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","The number of all the males a month old or more was 8,600. They were responsible for the duties of the sanctuary. ");
INSERT INTO engmsb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The clans of the Kohathites were to camp on the south side of the tabernacle, ");
INSERT INTO engmsb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","and the leader of the families of the Kohathites was Elizaphan son of Uzziel. ");
INSERT INTO engmsb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Their duties were the ark, the table, the lampstand, the altars, the articles of the sanctuary used with them, and the curtain—all the service for these items. ");
INSERT INTO engmsb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","The chief of the leaders of the Levites was Eleazar son of Aaron the priest; he oversaw those responsible for the duties of the sanctuary. ");
INSERT INTO engmsb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","From Merari came the clans of the Mahlites and Mushites; these were the Merarite clans. ");
INSERT INTO engmsb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","The number of all the males a month old or more was 6,200. ");
INSERT INTO engmsb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","The leader of the families of the Merarites was Zuriel son of Abihail; they were to camp on the north side of the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The duties assigned to the sons of Merari were the tabernacle’s frames, crossbars, posts, bases, and all its equipment—all the service for these items, ");
INSERT INTO engmsb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","as well as the posts of the surrounding courtyard with their bases, tent pegs, and ropes. ");
INSERT INTO engmsb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses, Aaron, and Aaron’s sons were to camp to the east of the tabernacle, toward the sunrise, before the Tent of Meeting. They were to perform the duties of the sanctuary as a service on behalf of the Israelites; but any outsider who approached the sanctuary was to be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","The total number of Levites that Moses and Aaron counted by their clans at the LORD’s command, including all the males a month old or more, was 22,000. ");
INSERT INTO engmsb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Then the LORD said to Moses, “Number every firstborn male of the Israelites a month old or more, and list their names. ");
INSERT INTO engmsb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","You are to take the Levites for Me—I am the LORD—in place of all the firstborn of Israel, and the livestock of the Levites in place of all the firstborn of the livestock of the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","So Moses numbered all the firstborn of the Israelites, as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","The total number of the firstborn males a month old or more, listed by name, was 22,273. ");
INSERT INTO engmsb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Again the LORD spoke to Moses, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Take the Levites in place of all the firstborn of Israel, and the livestock of the Levites in place of their livestock. The Levites belong to Me; I am the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","To redeem the 273 firstborn Israelites who outnumber the Levites, ");
INSERT INTO engmsb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","you are to collect five shekels for each one, according to the sanctuary shekel of twenty gerahs. ");
INSERT INTO engmsb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Give the money to Aaron and his sons as the redemption price for the excess among the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","So Moses collected the redemption money from those in excess of the number redeemed by the Levites. ");
INSERT INTO engmsb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","He collected the money from the firstborn of the Israelites: 1,365 shekels, according to the sanctuary shekel. ");
INSERT INTO engmsb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","And Moses gave the redemption money to Aaron and his sons in obedience to the word of the LORD, just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Take a census of the Kohathites among the Levites by their clans and families, ");
INSERT INTO engmsb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","men from thirty to fifty years old—everyone who is qualified to serve in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","This service of the Kohathites at the Tent of Meeting regards the most holy things. ");
INSERT INTO engmsb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Whenever the camp sets out, Aaron and his sons are to go in, take down the veil of the curtain, and cover the ark of the Testimony with it. ");
INSERT INTO engmsb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","They are to place over this a covering of fine leather, spread a solid blue cloth over it, and insert its poles. ");
INSERT INTO engmsb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Over the table of the Presence they are to spread a blue cloth and place the plates and cups on it, along with the bowls and pitchers for the drink offering. The regular bread offering is to remain on it. ");
INSERT INTO engmsb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","And they shall spread a scarlet cloth over them, cover them with fine leather, and insert the poles. ");
INSERT INTO engmsb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","They are to take a blue cloth and cover the lampstand used for light, together with its lamps, wick trimmers, and trays, as well as the jars of oil with which to supply it. ");
INSERT INTO engmsb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Then they shall wrap it and all its utensils inside a covering of fine leather and put it on the carrying frame. ");
INSERT INTO engmsb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Over the gold altar they are to spread a blue cloth, cover it with fine leather, and insert the poles. ");
INSERT INTO engmsb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","They are to take all the utensils for serving in the sanctuary, place them in a blue cloth, cover them with fine leather, and put them on the carrying frame. ");
INSERT INTO engmsb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Then they shall remove the ashes from the bronze altar, spread a purple cloth over it, ");
INSERT INTO engmsb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","and place on it all the vessels used to serve there: the firepans, meat forks, shovels, and sprinkling bowls—all the equipment of the altar. They are to spread over it a covering of fine leather and insert the poles. ");
INSERT INTO engmsb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","When Aaron and his sons have finished covering the holy objects and all their equipment, as soon as the camp is ready to move, the Kohathites shall come and do the carrying. But they must not touch the holy objects, or they will die. These are the transportation duties of the Kohathites regarding the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar son of Aaron the priest shall oversee the oil for the light, the fragrant incense, the daily grain offering, and the anointing oil. He has oversight of the entire tabernacle and everything in it, including the holy objects and their utensils.” ");
INSERT INTO engmsb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Do not allow the Kohathite tribal clans to be cut off from among the Levites. ");
INSERT INTO engmsb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","In order that they may live and not die when they come near the most holy things, do this for them: Aaron and his sons are to go in and assign each man his task and what he is to carry. ");
INSERT INTO engmsb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But the Kohathites are not to go in and look at the holy objects, even for a moment, or they will die.” ");
INSERT INTO engmsb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Take a census of the Gershonites as well, by their families and clans, ");
INSERT INTO engmsb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","from thirty to fifty years old, counting everyone who comes to serve in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is the service of the Gershonite clans regarding work and transport: ");
INSERT INTO engmsb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They are to carry the curtains of the tabernacle, the Tent of Meeting with the covering of fine leather over it, the curtains for the entrance to the Tent of Meeting, ");
INSERT INTO engmsb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","the curtains of the courtyard, and the curtains for the entrance at the gate of the courtyard that surrounds the tabernacle and altar, along with their ropes and all the equipment for their service. The Gershonites will do all that needs to be done with these items. ");
INSERT INTO engmsb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","All the service of the Gershonites—all their transport duties and other work—is to be done at the direction of Aaron and his sons; you are to assign to them all that they are responsible to carry. ");
INSERT INTO engmsb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the service of the Gershonite clans at the Tent of Meeting, and their duties shall be under the direction of Ithamar son of Aaron the priest. ");
INSERT INTO engmsb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","As for the sons of Merari, you are to number them by their clans and families, ");
INSERT INTO engmsb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","from thirty to fifty years old, counting everyone who comes to serve in the work of the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","This is the duty for all their service at the Tent of Meeting: to carry the frames of the tabernacle with its crossbars, posts, and bases, ");
INSERT INTO engmsb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","and the posts of the surrounding courtyard with their bases, tent pegs, and ropes, including all their equipment and everything related to their use. You shall assign by name the items that they are responsible to carry. ");
INSERT INTO engmsb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is the service of the Merarite clans according to all their work at the Tent of Meeting, under the direction of Ithamar son of Aaron the priest.” ");
INSERT INTO engmsb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","So Moses, Aaron, and the leaders of the congregation numbered the Kohathites by their clans and families, ");
INSERT INTO engmsb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","everyone from thirty to fifty years old who came to serve in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","And those numbered by their clans totaled 2,750. ");
INSERT INTO engmsb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","These were counted from the Kohathite clans, everyone who could serve at the Tent of Meeting. Moses and Aaron numbered them according to the command of the LORD through Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Then the Gershonites were numbered by their clans and families, ");
INSERT INTO engmsb_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","everyone from thirty to fifty years old who came to serve in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","And those numbered by their clans and families totaled 2,630. ");
INSERT INTO engmsb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","These were counted from the Gershonite clans who served at the Tent of Meeting, whom Moses and Aaron counted at the LORD’s command. ");
INSERT INTO engmsb_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","And the Merarites were numbered by their clans and families, ");
INSERT INTO engmsb_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","everyone from thirty to fifty years old who came to serve in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","The men registered by their clans numbered 3,200. ");
INSERT INTO engmsb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","These were counted from the Merarite clans, whom Moses and Aaron numbered at the LORD’s command through Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","So Moses, Aaron, and the leaders of Israel numbered by their clans and families all the Levites ");
INSERT INTO engmsb_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","from thirty to fifty years old who came to do the work of serving and carrying the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","And the number of men was 8,580. ");
INSERT INTO engmsb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","At the LORD’s command through Moses they were numbered, and each one was assigned his work and burden, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Command the Israelites to send away from the camp anyone with a skin disease, anyone who has a bodily discharge, and anyone who is defiled by a dead body. ");
INSERT INTO engmsb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","You must send away male and female alike; send them outside the camp so they will not defile their camp, where I dwell among them.” ");
INSERT INTO engmsb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","So the Israelites did this, sending such people outside the camp. They did just as the LORD had instructed Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tell the Israelites that when a man or woman acts unfaithfully against the LORD by committing any sin against another, that person is guilty ");
INSERT INTO engmsb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","and must confess the sin he has committed. He must make full restitution, add a fifth to its value, and give all this to the one he has wronged. ");
INSERT INTO engmsb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But if the man has no relative to whom restitution can be made for the wrong, the restitution belongs to the LORD and must be given to the priest along with the ram of atonement, by which the atonement is made for him. ");
INSERT INTO engmsb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Every sacred contribution the Israelites bring to the priest shall belong to him. ");
INSERT INTO engmsb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Each man’s sacred gifts are his own, but whatever he gives to the priest will belong to the priest.” ");
INSERT INTO engmsb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Speak to the Israelites and tell them that if any man’s wife goes astray and is unfaithful to him ");
INSERT INTO engmsb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","by sleeping with another man, and it is concealed from her husband and her impurity is undetected (since there is no witness against her and she was not caught in the act), ");
INSERT INTO engmsb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","and if a feeling of jealousy comes over her husband and he suspects his wife who has defiled herself—or if a feeling of jealousy comes over him and he suspects her even though she has not defiled herself— ");
INSERT INTO engmsb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","then he is to bring his wife to the priest. He must also bring for her an offering of a tenth of an ephah of barley flour. He is not to pour oil over it or put frankincense on it, because it is a grain offering for jealousy, an offering of memorial as a reminder of iniquity. ");
INSERT INTO engmsb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","The priest is to bring the wife forward and have her stand before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Then he is to take some holy water in a clay jar and put some of the dust from the tabernacle floor into the water. ");
INSERT INTO engmsb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","After the priest has the woman stand before the LORD, he is to let down her hair and place in her hands the grain offering of memorial, which is the grain offering for jealousy. The priest is to hold the bitter water that brings a curse. ");
INSERT INTO engmsb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","And he is to put the woman under oath and say to her, ‘If no other man has slept with you and you have not gone astray and become defiled while under your husband’s authority, may you be immune to this bitter water that brings a curse. ");
INSERT INTO engmsb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have gone astray while under your husband’s authority and have defiled yourself and lain carnally with a man other than your husband’— ");
INSERT INTO engmsb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","and the priest shall have the woman swear under the oath of the curse—‘then may the LORD make you an attested curse among your people by making your thigh shrivel and your belly swell. ");
INSERT INTO engmsb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","May this water that brings a curse enter your stomach and cause your belly to swell and your thigh to shrivel.’ Then the woman is to say, ‘Amen, Amen.’ ");
INSERT INTO engmsb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","And the priest shall write these curses on a scroll and wash them off into the bitter water. ");
INSERT INTO engmsb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","He is to have the woman drink the bitter water that brings a curse, and it will enter her and may cause her bitter suffering. ");
INSERT INTO engmsb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","The priest shall take from her hand the grain offering for jealousy, wave it before the LORD, and bring it to the altar. ");
INSERT INTO engmsb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Then the priest is to take a handful of the grain offering as a memorial portion and burn it on the altar; after that he is to have the woman drink the water. ");
INSERT INTO engmsb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","When he has made her drink the water, if she has defiled herself and been unfaithful to her husband, then the water that brings a curse will enter her and cause bitter suffering; her belly will swell, her thigh will shrivel, and she will become accursed among her people. ");
INSERT INTO engmsb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman has not defiled herself and is clean, she will be unaffected and able to conceive children. ");
INSERT INTO engmsb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the law of jealousy when a wife goes astray and defiles herself while under her husband’s authority, ");
INSERT INTO engmsb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when a feeling of jealousy comes over a husband and he suspects his wife. He is to have the woman stand before the LORD, and the priest is to apply to her this entire law. ");
INSERT INTO engmsb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","The husband will be free from guilt, but the woman shall bear her iniquity.” ");
INSERT INTO engmsb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Speak to the Israelites and tell them that if a man or woman makes a special vow, the vow of a Nazirite, to separate himself to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","he is to abstain from wine and strong drink. He must not drink vinegar made from wine or strong drink, and he must not drink any grape juice or eat fresh grapes or raisins. ");
INSERT INTO engmsb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","All the days of his separation, he is not to eat anything that comes from the grapevine, not even the seeds or skins. ");
INSERT INTO engmsb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","For the entire period of his vow of separation, no razor shall touch his head. He must be holy until the time of his separation to the LORD is complete; he must let the hair of his head grow long. ");
INSERT INTO engmsb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Throughout the days of his separation to the LORD, he must not go near a dead body. ");
INSERT INTO engmsb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Even if his father or mother or brother or sister should die, he is not to defile himself, because the symbol of consecration to his God is upon his head. ");
INSERT INTO engmsb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Throughout the time of his separation, he is holy to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","If someone suddenly dies in his presence and defiles his consecrated head of hair, he must shave his head on the day of his cleansing—the seventh day. ");
INSERT INTO engmsb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","On the eighth day he must bring two turtledoves or two young pigeons to the priest at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","And the priest is to offer one as a sin offering and the other as a burnt offering to make atonement for him, because he has sinned by being in the presence of the dead body. On that day he must consecrate his head again. ");
INSERT INTO engmsb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","He must rededicate his time of separation to the LORD and bring a year-old male lamb as a guilt offering. But the preceding days shall not be counted, because his separation was defiled. ");
INSERT INTO engmsb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Now this is the law of the Nazirite when his time of separation is complete: He must be brought to the entrance to the Tent of Meeting, ");
INSERT INTO engmsb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and he is to present an offering to the LORD of an unblemished year-old male lamb as a burnt offering, an unblemished year-old female lamb as a sin offering, and an unblemished ram as a peace offering— ");
INSERT INTO engmsb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","together with their grain offerings and drink offerings—and a basket of unleavened cakes made from fine flour mixed with oil and unleavened wafers coated with oil. ");
INSERT INTO engmsb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","The priest is to present all these before the LORD and make the sin offering and the burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","He shall also offer the ram as a peace offering to the LORD, along with the basket of unleavened bread. And the priest is to offer the accompanying grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Then at the entrance to the Tent of Meeting, the Nazirite is to shave his consecrated head, take the hair, and put it on the fire under the peace offering. ");
INSERT INTO engmsb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","And the priest is to take the boiled shoulder from the ram, one unleavened cake from the basket, and one unleavened wafer, and put them into the hands of the Nazirite who has just shaved the hair of his consecration. ");
INSERT INTO engmsb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","The priest shall then wave them as a wave offering before the LORD. This is a holy portion for the priest, in addition to the breast of the wave offering and the thigh that was presented. After that, the Nazirite may drink wine. ");
INSERT INTO engmsb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","This is the law of the Nazirite who vows his offering to the LORD for his separation, in addition to whatever else he can afford; he must fulfill whatever vow he makes, according to the law of his separation.” ");
INSERT INTO engmsb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tell Aaron and his sons: This is how you are to bless the Israelites. Say to them: ");
INSERT INTO engmsb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘May the LORD bless you and keep you; ");
INSERT INTO engmsb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","may the LORD cause His face to shine upon you and be gracious to you; ");
INSERT INTO engmsb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","may the LORD lift up His countenance toward you and give you peace.’ ");
INSERT INTO engmsb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","So they shall put My name on the Israelites, and I will bless them.” ");
INSERT INTO engmsb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","On the day Moses finished setting up the tabernacle, he anointed and consecrated it and all its furnishings, along with the altar and all its utensils. ");
INSERT INTO engmsb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","And the leaders of Israel, the heads of their families, presented an offering. These men were the tribal leaders who had supervised the registration. ");
INSERT INTO engmsb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","They brought as their offering before the LORD six covered carts and twelve oxen—an ox from each leader and a cart from every two leaders—and presented them before the tabernacle. ");
INSERT INTO engmsb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept these gifts from them, that they may be used in the work of the Tent of Meeting. And give them to the Levites, to each man according to his service.” ");
INSERT INTO engmsb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","So Moses took the carts and oxen and gave them to the Levites. ");
INSERT INTO engmsb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave the Gershonites two carts and four oxen, as their service required, ");
INSERT INTO engmsb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","and he gave the Merarites four carts and eight oxen, as their service required, all under the direction of Ithamar son of Aaron the priest. ");
INSERT INTO engmsb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","But he did not give any to the Kohathites, since they were to carry on their shoulders the holy objects for which they were responsible. ");
INSERT INTO engmsb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","When the altar was anointed, the leaders approached with their offerings for its dedication and presented them before the altar. ");
INSERT INTO engmsb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","And the LORD said to Moses, “Each day one leader is to present his offering for the dedication of the altar.” ");
INSERT INTO engmsb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","On the first day Nahshon son of Amminadab from the tribe of Judah drew near with his offering. ");
INSERT INTO engmsb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Nahshon son of Amminadab. ");
INSERT INTO engmsb_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","On the second day Nethanel son of Zuar, the leader of Issachar, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","The offering he presented was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Nethanel son of Zuar. ");
INSERT INTO engmsb_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","On the third day Eliab son of Helon, the leader of the Zebulunites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Eliab son of Helon. ");
INSERT INTO engmsb_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","On the fourth day Elizur son of Shedeur, the leader of the Reubenites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Elizur son of Shedeur. ");
INSERT INTO engmsb_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","On the fifth day Shelumiel son of Zurishaddai, the leader of the Simeonites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Shelumiel son of Zurishaddai. ");
INSERT INTO engmsb_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","On the sixth day Eliasaph son of Deuel, the leader of the Gadites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Eliasaph son of Deuel. ");
INSERT INTO engmsb_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","On the seventh day Elishama son of Ammihud, the leader of the Ephraimites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Elishama son of Ammihud. ");
INSERT INTO engmsb_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","On the eighth day Gamaliel son of Pedahzur, the leader of the Manassites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Gamaliel son of Pedahzur. ");
INSERT INTO engmsb_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","On the ninth day Abidan son of Gideoni, the leader of the Benjamites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Abidan son of Gideoni. ");
INSERT INTO engmsb_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","On the tenth day Ahiezer son of Ammishaddai, the leader of the Danites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Ahiezer son of Ammishaddai. ");
INSERT INTO engmsb_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","On the eleventh day Pagiel son of Ocran, the leader of the Asherites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Pagiel son of Ocran. ");
INSERT INTO engmsb_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","On the twelfth day Ahira son of Enan, the leader of the Naphtalites, drew near. ");
INSERT INTO engmsb_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","His offering was one silver platter weighing a hundred and thirty shekels, and one silver bowl weighing seventy shekels, both according to the sanctuary shekel and filled with fine flour mixed with oil for a grain offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","one gold dish weighing ten shekels, filled with incense; ");
INSERT INTO engmsb_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","one young bull, one ram, and one male lamb a year old for a burnt offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","one male goat for a sin offering; ");
INSERT INTO engmsb_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","and a peace offering of two oxen, five rams, five male goats, and five male lambs a year old. This was the offering of Ahira son of Enan. ");
INSERT INTO engmsb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","So these were the offerings from the leaders of Israel for the dedication of the altar when it was anointed: twelve silver platters, twelve silver bowls, and twelve gold dishes. ");
INSERT INTO engmsb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each silver platter weighed a hundred and thirty shekels, and each silver bowl seventy shekels. The total weight of the silver articles was two thousand four hundred shekels, according to the sanctuary shekel. ");
INSERT INTO engmsb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The twelve gold dishes filled with incense weighed ten shekels each, according to the sanctuary shekel. The total weight of the gold dishes was a hundred and twenty shekels. ");
INSERT INTO engmsb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","All the livestock for the burnt offering totaled twelve bulls, twelve rams, and twelve male lambs a year old—together with their grain offerings—and twelve male goats for the sin offering. ");
INSERT INTO engmsb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","All the livestock sacrificed for the peace offering totaled twenty-four bulls, sixty rams, sixty male goats, and sixty male lambs a year old. This was the dedication offering for the altar after it was anointed. ");
INSERT INTO engmsb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","When Moses entered the Tent of Meeting to speak with the LORD, he heard the voice speaking to him from between the two cherubim above the mercy seat on the ark of the Testimony. Thus the LORD spoke to him. ");
INSERT INTO engmsb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Speak to Aaron and tell him: ‘When you set up the seven lamps, they are to light the area in front of the lampstand.’” ");
INSERT INTO engmsb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","And Aaron did so; he set up the lamps facing toward the front of the lampstand, just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","This is how the lampstand was constructed: it was made of hammered gold from its base to its blossoms, fashioned according to the pattern the LORD had shown Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Again the LORD spoke to Moses, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Take the Levites from among the Israelites and make them ceremonially clean. ");
INSERT INTO engmsb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","This is what you must do to cleanse them: Sprinkle them with the water of purification. Have them shave their whole bodies and wash their clothes, and so purify themselves. ");
INSERT INTO engmsb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Then have them take a young bull with its grain offering of fine flour mixed with oil, and you are to take a second young bull for a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Bring the Levites before the Tent of Meeting and assemble the whole congregation of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","You are to present the Levites before the LORD and have the Israelites lay their hands upon them. ");
INSERT INTO engmsb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron is to present the Levites before the LORD as a wave offering from the sons of Israel, so that they may perform the service of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","And the Levites are to lay their hands on the heads of the bulls, and offer to the LORD one as a sin offering and the other as a burnt offering, to make atonement for the Levites. ");
INSERT INTO engmsb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","You are to have the Levites stand before Aaron and his sons and then present them before the LORD as a wave offering. ");
INSERT INTO engmsb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","In this way you shall separate the Levites from the rest of the Israelites, and the Levites will belong to Me. ");
INSERT INTO engmsb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","After you have cleansed them and presented them as a wave offering, they may come to serve at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","For the Levites have been wholly given to Me from among the sons of Israel. I have taken them for Myself in place of all who come first from the womb, the firstborn of all the sons of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","For every firstborn male in Israel is Mine, both man and beast. I set them apart for Myself on the day I struck down all the firstborn in the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","But I have taken the Levites in place of all the firstborn among the sons of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","And I have given the Levites as a gift to Aaron and his sons from among the Israelites, to perform the service for the Israelites at the Tent of Meeting and to make atonement on their behalf, so that no plague will come against the Israelites when they approach the sanctuary.” ");
INSERT INTO engmsb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","So Moses, Aaron, and the whole congregation of Israel did with the Levites everything that the LORD had commanded Moses they should do. ");
INSERT INTO engmsb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites purified themselves and washed their clothes, and Aaron presented them as a wave offering before the LORD. Aaron also made atonement for them to cleanse them. ");
INSERT INTO engmsb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After that, the Levites came to perform their service at the Tent of Meeting in the presence of Aaron and his sons. Thus they did with the Levites just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“This applies to the Levites: Men twenty-five years of age or older shall enter to perform the service in the work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","But at the age of fifty, they must retire from performing the work and no longer serve. ");
INSERT INTO engmsb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","After that, they may assist their brothers in fulfilling their duties at the Tent of Meeting, but they themselves are not to do the work. This is how you are to assign responsibilities to the Levites.” ");
INSERT INTO engmsb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","In the first month of the second year after Israel had come out of the land of Egypt, the LORD spoke to Moses in the Wilderness of Sinai: ");
INSERT INTO engmsb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“The Israelites are to observe the Passover at its appointed time. ");
INSERT INTO engmsb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","You are to observe it at the appointed time, at twilight on the fourteenth day of this month, in accordance with its statutes and ordinances.” ");
INSERT INTO engmsb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","So Moses told the Israelites to observe the Passover, ");
INSERT INTO engmsb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","and they did so in the Wilderness of Sinai, at twilight on the fourteenth day of the first month. The Israelites did everything just as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","But there were some men who were unclean due to a dead body, so they could not observe the Passover on that day. And they came before Moses and Aaron that same day ");
INSERT INTO engmsb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","and said to Moses, “We are unclean because of a dead body, but why should we be excluded from presenting the LORD’s offering with the other Israelites at the appointed time?” ");
INSERT INTO engmsb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","“Wait here until I find out what the LORD commands concerning you,” Moses replied. ");
INSERT INTO engmsb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tell the Israelites: ‘When any one of you or your descendants is unclean because of a dead body, or is away on a journey, he may still observe the Passover to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Such people are to observe it at twilight on the fourteenth day of the second month. They are to eat the lamb, together with unleavened bread and bitter herbs; ");
INSERT INTO engmsb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","they may not leave any of it until morning or break any of its bones. They must observe the Passover according to all its statutes. ");
INSERT INTO engmsb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But if a man who is ceremonially clean and is not on a journey still fails to observe the Passover, he must be cut off from his people, because he did not present the LORD’s offering at its appointed time. That man will bear the consequences of his sin. ");
INSERT INTO engmsb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","If a foreigner dwelling among you wants to observe the Passover to the LORD, he is to do so according to the Passover statute and its ordinances. You are to apply the same statute to both the foreigner and the native of the land.’” ");
INSERT INTO engmsb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","On the day that the tabernacle, the Tent of the Testimony, was set up, the cloud covered it and appeared like fire above the tabernacle from evening until morning. ");
INSERT INTO engmsb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","It remained that way continually; the cloud would cover the tabernacle by day, and at night it would appear like fire. ");
INSERT INTO engmsb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Whenever the cloud was lifted from above the Tent, the Israelites would set out, and wherever the cloud settled, there the Israelites would camp. ");
INSERT INTO engmsb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","At the LORD’s command the Israelites set out, and at the LORD’s command they camped. As long as the cloud remained over the tabernacle, they remained encamped. ");
INSERT INTO engmsb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Even when the cloud lingered over the tabernacle for many days, the Israelites kept the LORD’s charge and did not set out. ");
INSERT INTO engmsb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud remained over the tabernacle for only a few days, and they would camp at the LORD’s command and set out at the LORD’s command. ");
INSERT INTO engmsb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud remained only from evening until morning, and when it lifted in the morning, they would set out. Whether it was by day or by night, when the cloud was taken up, they would set out. ");
INSERT INTO engmsb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Whether the cloud lingered for two days, a month, or longer, the Israelites camped and did not set out as long as the cloud remained over the tabernacle; but when it was lifted, they would set out. ");
INSERT INTO engmsb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","They camped at the LORD’s command, and they set out at the LORD’s command; they carried out the LORD’s charge according to His command through Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two trumpets of hammered silver to be used for calling the congregation and for having the camps set out. ");
INSERT INTO engmsb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","When both are sounded, the whole congregation is to assemble before you at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","But if only one is sounded, then the leaders, the heads of the clans of Israel, are to gather before you. ");
INSERT INTO engmsb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you sound short blasts, the camps that lie on the east side are to set out. ");
INSERT INTO engmsb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When you sound the short blasts a second time, the camps that lie on the south side are to set out. The blasts are to signal them to set out. ");
INSERT INTO engmsb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","To convene the assembly, you are to sound long blasts, not short ones. ");
INSERT INTO engmsb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","The sons of Aaron, the priests, are to sound the trumpets. This shall be a permanent statute for you and the generations to come. ");
INSERT INTO engmsb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","When you enter into battle in your land against an adversary who attacks you, sound short blasts on the trumpets, and you will be remembered before the LORD your God and saved from your enemies. ");
INSERT INTO engmsb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","And on your joyous occasions, your appointed feasts, and the beginning of each month, you are to blow the trumpets over your burnt offerings and peace offerings to serve as a reminder for you before your God. I am the LORD your God.” ");
INSERT INTO engmsb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","On the twentieth day of the second month of the second year, the cloud was lifted from above the tabernacle of the Testimony, ");
INSERT INTO engmsb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","and the Israelites set out from the Wilderness of Sinai, traveling from place to place until the cloud settled in the Wilderness of Paran. ");
INSERT INTO engmsb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","They set out this first time according to the LORD’s command through Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","First, the divisions of the camp of Judah set out under their standard, with Nahshon son of Amminadab in command. ");
INSERT INTO engmsb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel son of Zuar was over the division of the tribe of Issachar, ");
INSERT INTO engmsb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","and Eliab son of Helon was over the division of the tribe of Zebulun. ");
INSERT INTO engmsb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then the tabernacle was taken down, and the Gershonites and the Merarites set out, transporting it. ");
INSERT INTO engmsb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Then the divisions of the camp of Reuben set out under their standard, with Elizur son of Shedeur in command. ");
INSERT INTO engmsb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel son of Zurishaddai was over the division of the tribe of Simeon, ");
INSERT INTO engmsb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","and Eliasaph son of Deuel was over the division of the tribe of Gad. ");
INSERT INTO engmsb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Then the Kohathites set out, transporting the holy objects; the tabernacle was to be set up before their arrival. ");
INSERT INTO engmsb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Next, the divisions of the camp of Ephraim set out under their standard, with Elishama son of Ammihud in command. ");
INSERT INTO engmsb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel son of Pedahzur was over the division of the tribe of Manasseh, ");
INSERT INTO engmsb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","and Abidan son of Gideoni was over the division of the tribe of Benjamin. ");
INSERT INTO engmsb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Finally, the divisions of the camp of Dan set out under their standard, serving as the rear guard for all units, with Ahiezer son of Ammishaddai in command. ");
INSERT INTO engmsb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel son of Ocran was over the division of the tribe of Asher, ");
INSERT INTO engmsb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","and Ahira son of Enan was over the division of the tribe of Naphtali. ");
INSERT INTO engmsb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","This was the order of march for the Israelite divisions as they set out. ");
INSERT INTO engmsb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Then Moses said to Hobab, the son of Moses’ father-in-law Reuel the Midianite, “We are setting out for the place of which the LORD said: ‘I will give it to you.’ Come with us, and we will treat you well, for the LORD has promised good things to Israel.” ");
INSERT INTO engmsb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","“I will not go,” Hobab replied. “Instead, I am going back to my own land and my own people.” ");
INSERT INTO engmsb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","“Please do not leave us,” Moses said, “since you know where we should camp in the wilderness, and you can serve as our eyes. ");
INSERT INTO engmsb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","If you come with us, we will share with you whatever good things the LORD gives us.” ");
INSERT INTO engmsb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","So they set out on a three-day journey from the mountain of the LORD, with the ark of the covenant of the LORD traveling ahead of them for those three days to seek a resting place for them. ");
INSERT INTO engmsb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","And the cloud of the LORD was over them by day when they set out from the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Whenever the ark set out, Moses would say, “Rise up, O LORD! May Your enemies be scattered; may those who hate You flee before You.” ");
INSERT INTO engmsb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when it came to rest, he would say: “Return, O LORD, to the countless thousands of Israel.” ");
INSERT INTO engmsb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Soon the people began to complain about their hardship in the hearing of the LORD, and when He heard them, His anger was kindled, and fire from the LORD blazed among them and consumed the outskirts of the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","And the people cried out to Moses, and he prayed to the LORD, and the fire died down. ");
INSERT INTO engmsb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So that place was called Taberah, because the fire of the LORD had burned among them. ");
INSERT INTO engmsb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Meanwhile, the rabble among them had a strong craving for other food, and again the Israelites wept and said, “Who will feed us meat? ");
INSERT INTO engmsb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish we ate freely in Egypt, along with the cucumbers, melons, leeks, onions, and garlic. ");
INSERT INTO engmsb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now our appetite is gone; there is nothing to see but this manna!” ");
INSERT INTO engmsb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Now the manna resembled coriander seed, and its appearance was like that of gum resin. ");
INSERT INTO engmsb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people walked around and gathered it, ground it on a handmill or crushed it in a mortar, then boiled it in a cooking pot or shaped it into cakes. It tasted like pastry baked with fine oil. ");
INSERT INTO engmsb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","When the dew fell on the camp at night, the manna would fall with it. ");
INSERT INTO engmsb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Then Moses heard the people of family after family weeping at the entrances to their tents, and the anger of the LORD was kindled greatly, and Moses was also displeased. ");
INSERT INTO engmsb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","So Moses asked the LORD, “Why have You brought this trouble on Your servant? Why have I not found favor in Your sight, that You have laid upon me the burden of all these people? ");
INSERT INTO engmsb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Did I conceive all these people? Did I give them birth, so that You should tell me, ‘Carry them in your bosom, as a nurse carries an infant,’ to the land that You swore to give their fathers? ");
INSERT INTO engmsb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where can I get meat for all these people? For they keep crying out to me, ‘Give us meat to eat!’ ");
INSERT INTO engmsb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I cannot carry all these people by myself; it is too burdensome for me. ");
INSERT INTO engmsb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If this is how You are going to treat me, please kill me right now—if I have found favor in Your eyes—and let me not see my own wretchedness.” ");
INSERT INTO engmsb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Then the LORD said to Moses, “Bring Me seventy of the elders of Israel known to you as leaders and officers of the people. Bring them to the Tent of Meeting and have them stand there with you. ");
INSERT INTO engmsb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","And I will come down and speak with you there, and I will take some of the Spirit that is on you and put that Spirit on them. They will help you bear the burden of the people, so that you do not have to bear it by yourself. ");
INSERT INTO engmsb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","And say to the people: Consecrate yourselves for tomorrow, and you will eat meat, because you have cried out in the hearing of the LORD, saying: ‘Who will feed us meat? For we were better off in Egypt!’ Therefore the LORD will give you meat, and you will eat. ");
INSERT INTO engmsb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will eat it not for one or two days, nor for five or ten or twenty days, ");
INSERT INTO engmsb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","but for a whole month—until it comes out of your nostrils and makes you nauseous—because you have rejected the LORD, who is among you, and have cried out before Him, saying, ‘Why did we ever leave Egypt?’” ");
INSERT INTO engmsb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","But Moses replied, “Here I am among 600,000 men on foot, yet You say, ‘I will give them meat, and they will eat for a month.’ ");
INSERT INTO engmsb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","If all our flocks and herds were slaughtered for them, would they have enough? Or if all the fish in the sea were caught for them, would they have enough?” ");
INSERT INTO engmsb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","The LORD answered Moses, “Is the LORD’s arm too short? Now you will see whether or not My word will come to pass.” ");
INSERT INTO engmsb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","So Moses went out and relayed to the people the words of the LORD, and he gathered seventy of the elders of the people and had them stand around the tent. ");
INSERT INTO engmsb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Then the LORD came down in the cloud and spoke to him, and He took some of the Spirit that was on Moses and placed that Spirit on the seventy elders. As the Spirit rested on them, they prophesied—but they never did so again. ");
INSERT INTO engmsb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Two men, however, had remained in the camp—one named Eldad and the other Medad—and the Spirit rested on them. They were among those listed, but they had not gone out to the tent, and they prophesied in the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A young man ran and reported to Moses, “Eldad and Medad are prophesying in the camp.” ");
INSERT INTO engmsb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua son of Nun, the attendant to Moses since youth, spoke up and said, “Moses, my lord, stop them!” ");
INSERT INTO engmsb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","But Moses replied, “Are you jealous on my account? I wish that all the LORD’s people were prophets and that the LORD would place His Spirit on them!” ");
INSERT INTO engmsb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses returned to the camp, along with the elders of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Now a wind sent by the LORD came up, drove in quail from the sea, and brought them near the camp, about two cubits above the surface of the ground, for a day’s journey in every direction around the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","All that day and night, and all the next day, the people stayed up gathering the quail. No one gathered less than ten homers, and they spread them out all around the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","But while the meat was still between their teeth, before it was chewed, the anger of the LORD burned against the people, and the LORD struck them with a severe plague. ");
INSERT INTO engmsb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","So they called that place Kibroth-hattaavah, because there they buried the people who had craved other food. ");
INSERT INTO engmsb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth-hattaavah the people moved on to Hazeroth, where they remained for some time. ");
INSERT INTO engmsb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Then Miriam and Aaron criticized Moses because of the Cushite woman he had married, for he had taken a Cushite wife. ");
INSERT INTO engmsb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Does the LORD speak only through Moses?” they said. “Does He not also speak through us?” And the LORD heard this. ");
INSERT INTO engmsb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Now Moses was a very humble man, more so than any man on the face of the earth. ");
INSERT INTO engmsb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","And suddenly the LORD said to Moses, Aaron, and Miriam, “You three, come out to the Tent of Meeting.” So the three went out, ");
INSERT INTO engmsb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","and the LORD came down in a pillar of cloud, stood at the entrance to the Tent, and summoned Aaron and Miriam. When both of them had stepped forward, ");
INSERT INTO engmsb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","He said, “Hear now My words: If there is a prophet among you, I, the LORD, will reveal Myself to him in a vision; I will speak to him in a dream. ");
INSERT INTO engmsb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","But this is not so with My servant Moses; he is faithful in all My house. ");
INSERT INTO engmsb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","I speak with him face to face, clearly and not in riddles; he sees the form of the LORD. Why then were you unafraid to speak against My servant Moses?” ");
INSERT INTO engmsb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","So the anger of the LORD burned against them, and He departed. ");
INSERT INTO engmsb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","As the cloud lifted from above the Tent, suddenly Miriam became leprous, white as snow. Aaron turned toward her, saw that she was leprous, ");
INSERT INTO engmsb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","and said to Moses, “My lord, please do not hold against us this sin we have so foolishly committed. ");
INSERT INTO engmsb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Please do not let her be like a stillborn infant whose flesh is half consumed when he comes out of his mother’s womb.” ");
INSERT INTO engmsb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","So Moses cried out to the LORD, “O God, please heal her!” ");
INSERT INTO engmsb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","But the LORD answered Moses, “If her father had but spit in her face, would she not have been in disgrace for seven days? Let her be confined outside the camp for seven days; after that she may be brought back in.” ");
INSERT INTO engmsb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So Miriam was confined outside the camp for seven days, and the people did not move on until she was brought in again. ");
INSERT INTO engmsb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","After that, the people set out from Hazeroth and camped in the Wilderness of Paran. ");
INSERT INTO engmsb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send out for yourself men to spy out the land of Canaan, which I am giving to the Israelites. From each of their fathers’ tribes send one man who is a leader among them.” ");
INSERT INTO engmsb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","So at the command of the LORD, Moses sent them out from the Wilderness of Paran. All the men were leaders of the Israelites, ");
INSERT INTO engmsb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","and these were their names: From the tribe of Reuben, Shammua son of Zaccur; ");
INSERT INTO engmsb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","from the tribe of Simeon, Shaphat son of Hori; ");
INSERT INTO engmsb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","from the tribe of Judah, Caleb son of Jephunneh; ");
INSERT INTO engmsb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","from the tribe of Issachar, Igal son of Joseph; ");
INSERT INTO engmsb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","from the tribe of Ephraim, Hoshea son of Nun; ");
INSERT INTO engmsb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","from the tribe of Benjamin, Palti son of Raphu; ");
INSERT INTO engmsb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","from the tribe of Zebulun, Gaddiel son of Sodi; ");
INSERT INTO engmsb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","from the tribe of Manasseh (a tribe of Joseph), Gaddi son of Susi; ");
INSERT INTO engmsb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","from the tribe of Dan, Ammiel son of Gemalli; ");
INSERT INTO engmsb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","from the tribe of Asher, Sethur son of Michael; ");
INSERT INTO engmsb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","from the tribe of Naphtali, Nahbi son of Vophsi; ");
INSERT INTO engmsb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","and from the tribe of Gad, Geuel son of Machi. ");
INSERT INTO engmsb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These were the names of the men Moses sent to spy out the land; and Moses gave to Hoshea son of Nun the name Joshua. ");
INSERT INTO engmsb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","When Moses sent them to spy out the land of Canaan, he told them, “Go up through the Negev and into the hill country. ");
INSERT INTO engmsb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","See what the land is like and whether its people are strong or weak, few or many. ");
INSERT INTO engmsb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Is the land where they live good or bad? Are the cities where they dwell open camps or fortifications? ");
INSERT INTO engmsb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Is the soil fertile or unproductive? Are there trees in it or not? Be courageous and bring back some of the fruit of the land.” (It was the season for the first ripe grapes.) ");
INSERT INTO engmsb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went up and spied out the land from the Wilderness of Zin as far as Rehob, toward Lebo-hamath. ");
INSERT INTO engmsb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They went up through the Negev and came to Hebron, where Ahiman, Sheshai, and Talmai, the descendants of Anak, dwelled. It had been built seven years before Zoan in Egypt. ");
INSERT INTO engmsb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","When they came to the Valley of Eshcol, they cut down a branch with a single cluster of grapes, which they carried on a pole between two men. They also took some pomegranates and figs. ");
INSERT INTO engmsb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Because of the cluster of grapes the Israelites cut there, that place was called the Valley of Eshcol. ");
INSERT INTO engmsb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","After forty days the men returned from spying out the land, ");
INSERT INTO engmsb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","and they went back to Moses, Aaron, and the whole congregation of Israel in the Wilderness of Paran at Kadesh. They brought back a report for the whole congregation and showed them the fruit of the land. ");
INSERT INTO engmsb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","And they gave this account to Moses: “We went into the land to which you sent us, and indeed, it is flowing with milk and honey. Here is some of its fruit! ");
INSERT INTO engmsb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Nevertheless, the people living in the land are strong, and the cities are large and fortified. We even saw the descendants of Anak there. ");
INSERT INTO engmsb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalekites live in the land of the Negev; the Hittites, Jebusites, and Amorites live in the hill country; and the Canaanites live by the sea and along the Jordan.” ");
INSERT INTO engmsb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Then Caleb quieted the people before Moses and said, “We must go up and take possession of the land, for we can certainly conquer it!” ");
INSERT INTO engmsb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone up with him replied, “We cannot go up against the people, for they are stronger than we are!” ");
INSERT INTO engmsb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","So they gave the Israelites a bad report about the land that they had spied out: “The land we explored devours its inhabitants, and all the people we saw there are great in stature. ");
INSERT INTO engmsb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We even saw the Nephilim there—the descendants of Anak that come from the Nephilim! We seemed like grasshoppers in our own sight, and we must have seemed the same to them!” ");
INSERT INTO engmsb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Then the whole congregation lifted up their voices and cried out, and that night the people wept. ");
INSERT INTO engmsb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","All the Israelites grumbled against Moses and Aaron, and the whole congregation said to them, “If only we had died in the land of Egypt, or if only we had died in this wilderness! ");
INSERT INTO engmsb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why is the LORD bringing us into this land to fall by the sword? Our wives and children will become plunder. Would it not be better for us to go back to Egypt?” ");
INSERT INTO engmsb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","So they said to one another, “Let us appoint a leader and return to Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Then Moses and Aaron fell facedown before the whole assembly of the congregation of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua son of Nun and Caleb son of Jephunneh, who were among those who had spied out the land, tore their clothes ");
INSERT INTO engmsb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","and said to the whole congregation of Israel, “The land we passed through and explored is an exceedingly good land. ");
INSERT INTO engmsb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If the LORD delights in us, He will bring us into this land, a land flowing with milk and honey, and He will give it to us. ");
INSERT INTO engmsb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Only do not rebel against the LORD, and do not be afraid of the people of the land, for they will be like bread for us. Their protection has been removed, and the LORD is with us. Do not be afraid of them!” ");
INSERT INTO engmsb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","But the whole congregation threatened to stone Joshua and Caleb. Then the glory of the LORD appeared to all the Israelites at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","And the LORD said to Moses, “How long will this people treat Me with contempt? How long will they refuse to believe in Me, despite all the signs I have performed among them? ");
INSERT INTO engmsb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will strike them with a plague and destroy them—and I will make you into a nation greater and mightier than they are.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","But Moses said to the LORD, “The Egyptians will hear of it, for by Your strength You brought this people from among them. ");
INSERT INTO engmsb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","And they will tell it to the inhabitants of this land. They have already heard that You, O LORD, are in the midst of this people, that You, O LORD, have been seen face to face, that Your cloud stands over them, and that You go before them in a pillar of cloud by day and a pillar of fire by night. ");
INSERT INTO engmsb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","If You kill this people as one man, the nations who have heard of Your fame will say, ");
INSERT INTO engmsb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Because the LORD was unable to bring this people into the land He swore to give them, He has slaughtered them in the wilderness.’ ");
INSERT INTO engmsb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","So now I pray, may the power of my Lord be magnified, just as You have declared: ");
INSERT INTO engmsb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘The LORD is slow to anger and abounding in loving devotion, forgiving iniquity and transgression. Yet He will by no means leave the guilty unpunished; He will visit the iniquity of the fathers upon their children to the third and fourth generation.’ ");
INSERT INTO engmsb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardon, I pray, the iniquity of this people, in keeping with the greatness of Your loving devotion, just as You have forgiven them ever since they left Egypt.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","“I have pardoned them as you requested,” the LORD replied. ");
INSERT INTO engmsb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“Yet as surely as I live and as surely as the whole earth is filled with the glory of the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","not one of the men who have seen My glory and the signs I performed in Egypt and in the wilderness—yet have tested Me and disobeyed Me these ten times— ");
INSERT INTO engmsb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","not one will ever see the land that I swore to give their fathers. None of those who have treated Me with contempt will see it. ");
INSERT INTO engmsb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But because My servant Caleb has a different spirit and has followed Me wholeheartedly, I will bring him into the land he has entered, and his descendants will inherit it. ");
INSERT INTO engmsb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Now since the Amalekites and Canaanites are living in the valleys, turn back tomorrow and head for the wilderness along the route to the Red Sea.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long will this wicked congregation grumble against Me? I have heard the complaints that the Israelites are making against Me. ");
INSERT INTO engmsb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","So tell them: As surely as I live, declares the LORD, I will do to you exactly as I heard you say. ");
INSERT INTO engmsb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Your bodies will fall in this wilderness—all who were numbered in the census, everyone twenty years of age or older—because you have grumbled against Me. ");
INSERT INTO engmsb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Surely none of you will enter the land in which I swore to settle you, except Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engmsb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","But I will bring your children, whom you said would become plunder, into the land you have rejected—and they will enjoy it. ");
INSERT INTO engmsb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","As for you, however, your bodies will fall in this wilderness. ");
INSERT INTO engmsb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Your children will be shepherds in the wilderness for forty years, and they will suffer for your unfaithfulness until the last of your bodies lies in the wilderness. ");
INSERT INTO engmsb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","In keeping with the forty days you spied out the land, you shall bear your guilt forty years—a year for each day—and you will experience My alienation. ");
INSERT INTO engmsb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, the LORD, have spoken, and I will surely do these things to this entire wicked congregation, which has conspired against Me. They will meet their end in the wilderness, and there they will die.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","So the men Moses had sent to spy out the land, who had returned and made the whole congregation grumble against him by bringing out a bad report about the land— ");
INSERT INTO engmsb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","those men who had brought out the bad report about the land—were struck down by a plague before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Of those men who had gone to spy out the land, only Joshua son of Nun and Caleb son of Jephunneh remained alive. ");
INSERT INTO engmsb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","And when Moses relayed these words to all the Israelites, the people mourned bitterly. ");
INSERT INTO engmsb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Early the next morning they got up and went up toward the ridge of the hill country. “We have indeed sinned,” they said, “but we will go to the place the LORD has promised.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses said, “Why are you transgressing the commandment of the LORD? This will not succeed! ");
INSERT INTO engmsb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Do not go up, lest you be struck down by your enemies, because the LORD is not among you. ");
INSERT INTO engmsb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","For there the Amalekites and Canaanites will face you, and you will fall by the sword. Because you have turned away from the LORD, He will not be with you.” ");
INSERT INTO engmsb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they dared to go up to the ridge of the hill country, though neither Moses nor the ark of the covenant of the LORD moved from the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Then the Amalekites and Canaanites who lived in that part of the hill country came down, attacked them, and routed them all the way to Hormah. ");
INSERT INTO engmsb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Speak to the Israelites and tell them: After you enter the land that I am giving you as a home ");
INSERT INTO engmsb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","and you present a food offering to the LORD from the herd or flock to produce a pleasing aroma to the LORD—either a burnt offering or a sacrifice, for a special vow or freewill offering or appointed feast— ");
INSERT INTO engmsb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","then the one presenting his offering to the LORD shall also present a grain offering of a tenth of an ephah of fine flour mixed with a quarter hin of olive oil. ");
INSERT INTO engmsb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","With the burnt offering or sacrifice of each lamb, you are to prepare a quarter hin of wine as a drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","With a ram you are to prepare a grain offering of two-tenths of an ephah of fine flour mixed with a third of a hin of olive oil, ");
INSERT INTO engmsb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","and a third of a hin of wine as a drink offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","When you prepare a young bull as a burnt offering or sacrifice to fulfill a vow or as a peace offering to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","present with the bull a grain offering of three-tenths of an ephah of fine flour mixed with half a hin of olive oil. ");
INSERT INTO engmsb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Also present half a hin of wine as a drink offering. It is a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","This is to be done for each bull, ram, lamb, or goat. ");
INSERT INTO engmsb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","This is how you must prepare each one, no matter how many. ");
INSERT INTO engmsb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Everyone who is native-born shall prepare these things in this way when he presents a food offering as a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","And for the generations to come, if a foreigner residing with you or someone else among you wants to prepare a food offering as a pleasing aroma to the LORD, he is to do exactly as you do. ");
INSERT INTO engmsb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","The assembly is to have the same statute both for you and for the foreign resident; it is a permanent statute for the generations to come. You and the foreigner shall be the same before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","The same law and the same ordinance will apply both to you and to the foreigner residing with you.” ");
INSERT INTO engmsb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Speak to the Israelites and tell them: When you enter the land to which I am bringing you ");
INSERT INTO engmsb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","and you eat the food of the land, you shall lift up an offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","From the first of your dough, you are to lift up a cake as a contribution; offer it just like an offering from the threshing floor. ");
INSERT INTO engmsb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Throughout your generations, you are to give the LORD an offering from the first of your dough. ");
INSERT INTO engmsb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Now if you stray unintentionally and do not obey all these commandments that the LORD has spoken to Moses— ");
INSERT INTO engmsb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","all that the LORD has commanded you through Moses from the day the LORD gave them and continuing through the generations to come— ");
INSERT INTO engmsb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","and if it was done unintentionally without the knowledge of the congregation, then the whole congregation is to prepare one young bull as a burnt offering, a pleasing aroma to the LORD, with its grain offering and drink offering according to the regulation, and one male goat as a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","The priest is to make atonement for the whole congregation of Israel, so that they may be forgiven; for the sin was unintentional and they have brought to the LORD a food offering and a sin offering, presented before the LORD for their unintentional sin. ");
INSERT INTO engmsb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Then the whole congregation of Israel and the foreigners residing among them will be forgiven, since it happened to all the people unintentionally. ");
INSERT INTO engmsb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Also, if one person sins unintentionally, he is to present a year-old female goat as a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","And the priest shall make atonement before the LORD on behalf of the person who erred by sinning unintentionally; and when atonement has been made for him, he will be forgiven. ");
INSERT INTO engmsb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You shall have the same law for the one who acts in error, whether he is a native-born Israelite or a foreigner residing among you. ");
INSERT INTO engmsb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the person who sins defiantly, whether a native or foreigner, blasphemes the LORD. That person shall be cut off from among his people. ");
INSERT INTO engmsb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","He shall certainly be cut off, because he has despised the word of the LORD and broken His commandment; his guilt remains on him.” ");
INSERT INTO engmsb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","While the Israelites were in the wilderness, a man was found gathering wood on the Sabbath day. ");
INSERT INTO engmsb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Those who found the man gathering wood brought him to Moses, Aaron, and the whole congregation, ");
INSERT INTO engmsb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","and because it had not been declared what should be done to him, they placed him in custody. ");
INSERT INTO engmsb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","And the LORD said to Moses, “The man must surely be put to death. The whole congregation is to stone him outside the camp.” ");
INSERT INTO engmsb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So the whole congregation took the man outside the camp and stoned him to death, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Speak to the Israelites and tell them that throughout the generations to come they are to make for themselves tassels for the corners of their garments, with a blue cord on each tassel. ");
INSERT INTO engmsb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","These will serve as tassels for you to look at, so that you may remember all the commandments of the LORD, that you may obey them and not prostitute yourselves by following your own heart and your own eyes. ");
INSERT INTO engmsb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Then you will remember and obey all My commandments, and you will be holy to your God. ");
INSERT INTO engmsb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the LORD your God who brought you out of the land of Egypt to be your God. I am the LORD your God.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Now Korah son of Izhar, the son of Kohath son of Levi, along with some Reubenites—Dathan and Abiram, sons of Eliab, and On son of Peleth—conducted ");
INSERT INTO engmsb_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","a rebellion against Moses, along with 250 men of Israel renowned as leaders of the congregation and representatives in the assembly. ");
INSERT INTO engmsb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They came together against Moses and Aaron and told them, “You have taken too much upon yourselves! For everyone in the entire congregation is holy, and the LORD is in their midst. Why then do you exalt yourselves above the assembly of the LORD?” ");
INSERT INTO engmsb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard this, he fell facedown. ");
INSERT INTO engmsb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Then he said to Korah and all his followers, “Tomorrow morning the LORD will reveal who belongs to Him and who is holy, and He will bring that person near to Himself. The one He chooses He will bring near to Himself. ");
INSERT INTO engmsb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","You, Korah, and all your followers are to do as follows: Take censers, ");
INSERT INTO engmsb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","and tomorrow you are to place fire and incense in them in the presence of the LORD. Then the man the LORD chooses will be the one who is holy. It is you sons of Levi who have taken too much upon yourselves!” ");
INSERT INTO engmsb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses also said to Korah, “Now listen, you sons of Levi! ");
INSERT INTO engmsb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Is it not enough for you that the God of Israel has separated you from the congregation of Israel and brought you near to Himself to perform the work at the LORD’s tabernacle, and to stand before the congregation to minister to them? ");
INSERT INTO engmsb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","He has brought you near, you and all your fellow Levites, but you are seeking the priesthood as well. ");
INSERT INTO engmsb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Therefore, it is you and all your followers who have conspired against the LORD! As for Aaron, who is he that you should grumble against him?” ");
INSERT INTO engmsb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses summoned Dathan and Abiram, the sons of Eliab, but they said, “We will not come! ");
INSERT INTO engmsb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Is it not enough that you have brought us up out of a land flowing with milk and honey to kill us in the wilderness? Must you also appoint yourself as ruler over us? ");
INSERT INTO engmsb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Moreover, you have not brought us into a land flowing with milk and honey or given us an inheritance of fields and vineyards. Will you gouge out the eyes of these men? No, we will not come!” ");
INSERT INTO engmsb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Then Moses became very angry and said to the LORD, “Do not regard their offering. I have not taken one donkey from them or mistreated a single one of them.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","And Moses said to Korah, “You and all your followers are to appear before the LORD tomorrow—you and they and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Each man is to take his censer, place incense in it, and present it before the LORD—250 censers. You and Aaron are to present your censers as well.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So each man took his censer, put fire and incense in it, and stood with Moses and Aaron at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","When Korah had gathered his whole assembly against them at the entrance to the Tent of Meeting, the glory of the LORD appeared to the whole congregation. ");
INSERT INTO engmsb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","And the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separate yourselves from this congregation so that I may consume them in an instant.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","But Moses and Aaron fell facedown and said, “O God, the God of the spirits of all flesh, when one man sins, will You be angry with the whole congregation?” ");
INSERT INTO engmsb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tell the congregation to move away from the dwellings of Korah, Dathan, and Abiram.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","So Moses got up and went to Dathan and Abiram, and the elders of Israel followed him. ");
INSERT INTO engmsb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","And he warned the congregation, “Move away now from the tents of these wicked men. Do not touch anything that belongs to them, or you will be swept away because of all their sins.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So they moved away from the dwellings of Korah, Dathan, and Abiram. Meanwhile, Dathan and Abiram had come out and stood at the entrances to their tents with their wives and children and infants. ");
INSERT INTO engmsb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Then Moses said, “This is how you will know that the LORD has sent me to do all these things, for it was not my own doing: ");
INSERT INTO engmsb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die a natural death, or if they suffer the fate of all men, then the LORD has not sent me. ");
INSERT INTO engmsb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the LORD brings about something unprecedented, and the earth opens its mouth and swallows them and all that belongs to them so that they go down alive into Sheol, then you will know that these men have treated the LORD with contempt.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","As soon as Moses had finished saying all this, the ground beneath them split open, ");
INSERT INTO engmsb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","and the earth opened its mouth and swallowed them and their households—all Korah’s men and all their possessions. ");
INSERT INTO engmsb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They went down alive into Sheol with all they owned. The earth closed over them, and they vanished from the assembly. ");
INSERT INTO engmsb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","At their cries, all the people of Israel who were around them fled, saying, “The earth may swallow us too!” ");
INSERT INTO engmsb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","And fire came forth from the LORD and consumed the 250 men who were offering the incense. ");
INSERT INTO engmsb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tell Eleazar son of Aaron the priest to remove the censers from the flames and to scatter the coals far away, because the censers are holy. ");
INSERT INTO engmsb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","As for the censers of those who sinned at the cost of their own lives, hammer them into sheets to overlay the altar, for these were presented before the LORD, and so have become holy. They will serve as a sign to the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest took the bronze censers brought by those who had been burned up, and he had them hammered out to overlay the altar, ");
INSERT INTO engmsb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","just as the LORD commanded him through Moses. This was to be a reminder to the Israelites that no outsider who is not a descendant of Aaron should approach to offer incense before the LORD, lest he become like Korah and his followers. ");
INSERT INTO engmsb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","The next day the whole congregation of Israel grumbled against Moses and Aaron, saying, “You have killed the LORD’s people!” ");
INSERT INTO engmsb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","But when the congregation gathered against them, Moses and Aaron turned toward the Tent of Meeting, and suddenly the cloud covered it and the glory of the LORD appeared. ");
INSERT INTO engmsb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Then Moses and Aaron went to the front of the Tent of Meeting, ");
INSERT INTO engmsb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","and the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Get away from this congregation so that I may consume them in an instant.” And Moses and Aaron fell facedown. ");
INSERT INTO engmsb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses said to Aaron, “Take your censer, place fire from the altar in it, and add incense. Go quickly to the congregation and make atonement for them, because wrath has come out from the LORD; the plague has begun.” ");
INSERT INTO engmsb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","So Aaron took the censer as Moses had ordered and ran into the midst of the assembly. And seeing that the plague had begun among the people, he offered the incense and made atonement for the people. ");
INSERT INTO engmsb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He stood between the living and the dead, and the plague was halted. ");
INSERT INTO engmsb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","But those who died from the plague numbered 14,700, in addition to those who had died on account of Korah. ");
INSERT INTO engmsb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Then Aaron returned to Moses at the entrance to the Tent of Meeting, since the plague had been halted. ");
INSERT INTO engmsb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Speak to the Israelites and take from them twelve staffs, one from the leader of each tribe. Write each man’s name on his staff, ");
INSERT INTO engmsb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","and write Aaron’s name on the staff of Levi, because there must be one staff for the head of each tribe. ");
INSERT INTO engmsb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Place the staffs in the Tent of Meeting in front of the Testimony, where I meet with you. ");
INSERT INTO engmsb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","The staff belonging to the man I choose will sprout, and I will rid Myself of the constant grumbling of the Israelites against you.” ");
INSERT INTO engmsb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses spoke to the Israelites, and each of their leaders gave him a staff—one for each of the leaders of their tribes, twelve staffs in all. And Aaron’s staff was among them. ");
INSERT INTO engmsb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Then Moses placed the staffs before the LORD in the Tent of the Testimony. ");
INSERT INTO engmsb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","The next day Moses entered the Tent of the Testimony and saw that Aaron’s staff, representing the house of Levi, had sprouted, put forth buds, blossomed, and produced almonds. ");
INSERT INTO engmsb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Then Moses brought out all the staffs from the LORD’s presence to all the Israelites. They saw them, and each man took his own staff. ");
INSERT INTO engmsb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","The LORD said to Moses, “Put Aaron’s staff back in front of the Testimony, to be kept as a sign for the rebellious, so that you may put an end to their grumbling against Me, lest they die.” ");
INSERT INTO engmsb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","So Moses did as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Then the Israelites declared to Moses, “Look, we are perishing! We are lost; we are all lost! ");
INSERT INTO engmsb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Anyone who comes near the tabernacle of the LORD will die. Are we all going to perish?” ");
INSERT INTO engmsb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","So the LORD said to Aaron, “You and your sons and your father’s house must bear the iniquity involving the sanctuary. And you and your sons alone must bear the iniquity involving your priesthood. ");
INSERT INTO engmsb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","But bring with you also your brothers from the tribe of Levi, the tribe of your father, that they may join you and assist you and your sons before the Tent of the Testimony. ");
INSERT INTO engmsb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","And they shall attend to your duties and to all the duties of the Tent; but they must not come near to the furnishings of the sanctuary or the altar, or both they and you will die. ");
INSERT INTO engmsb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They are to join you and attend to the duties of the Tent of Meeting, doing all the work at the Tent; but no outsider may come near you. ");
INSERT INTO engmsb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","And you shall attend to the duties of the sanctuary and of the altar, so that wrath may not fall on the Israelites again. ");
INSERT INTO engmsb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Behold, I Myself have selected your fellow Levites from the Israelites as a gift to you, dedicated to the LORD to perform the service for the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But only you and your sons shall attend to your priesthood for everything concerning the altar and what is inside the veil, and you are to perform that service. I am giving you the work of the priesthood as a gift, but any outsider who comes near the sanctuary must be put to death.” ");
INSERT INTO engmsb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Then the LORD said to Aaron, “Behold, I have put you in charge of My offerings. As for all the sacred offerings of the Israelites, I have given them to you and your sons as a portion and a permanent statute. ");
INSERT INTO engmsb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","A portion of the most holy offerings reserved from the fire will be yours. From all the offerings they render to Me as most holy offerings, whether grain offerings or sin offerings or guilt offerings, that part belongs to you and your sons. ");
INSERT INTO engmsb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","You are to eat it as a most holy offering, and every male may eat it. You shall regard it as holy. ");
INSERT INTO engmsb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","And this is yours as well: the offering of their gifts, along with all the wave offerings of the Israelites. I have given this to you and your sons and daughters as a permanent statute. Every ceremonially clean person in your household may eat it. ");
INSERT INTO engmsb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","I give you all the freshest olive oil and all the finest new wine and grain that the Israelites give to the LORD as their firstfruits. ");
INSERT INTO engmsb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The firstfruits of everything in their land that they bring to the LORD will belong to you. Every ceremonially clean person in your household may eat them. ");
INSERT INTO engmsb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Every devoted thing in Israel belongs to you. ");
INSERT INTO engmsb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","The firstborn of every womb, whether man or beast, that is offered to the LORD belongs to you. But you must surely redeem every firstborn son and every firstborn male of unclean animals. ");
INSERT INTO engmsb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","You are to pay the redemption price for a month-old male according to your valuation: five shekels of silver, according to the sanctuary shekel, which is twenty gerahs. ");
INSERT INTO engmsb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But you must not redeem the firstborn of an ox, a sheep, or a goat; they are holy. You are to splatter their blood on the altar and burn their fat as a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","And their meat belongs to you, just as the breast and right thigh of the wave offering belong to you. ");
INSERT INTO engmsb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","All the holy offerings that the Israelites present to the LORD I give to you and to your sons and daughters as a permanent statute. It is a permanent covenant of salt before the LORD for you and your offspring.” ");
INSERT INTO engmsb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Then the LORD said to Aaron, “You will have no inheritance in their land, nor will you have any portion among them. I am your portion and your inheritance among the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Behold, I have given to the Levites all the tithes in Israel as an inheritance in return for the work they do, the service of the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","No longer may the Israelites come near to the Tent of Meeting, or they will incur guilt and die. ");
INSERT INTO engmsb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","The Levites are to perform the work of the Tent of Meeting, and they must bear their iniquity. This is a permanent statute for the generations to come. The Levites will not receive an inheritance among the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","For I have given to the Levites as their inheritance the tithe that the Israelites present to the LORD as a contribution. That is why I told them that they would not receive an inheritance among the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","And the LORD instructed Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Speak to the Levites and tell them: ‘When you receive from the Israelites the tithe that I have given you as your inheritance, you must present part of it as an offering to the LORD—a tithe of the tithe. ");
INSERT INTO engmsb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Your offering will be reckoned to you as grain from the threshing floor or juice from the winepress. ");
INSERT INTO engmsb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","So you are to present an offering to the LORD from all the tithes you receive from the Israelites, and from these you are to give the LORD’s offering to Aaron the priest. ");
INSERT INTO engmsb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","You must present the offering due the LORD from all the best of every gift, the holiest part of it.’ ");
INSERT INTO engmsb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Therefore say to the Levites, ‘When you have presented the best part, it will be reckoned to you as the produce of the threshing floor or winepress. ");
INSERT INTO engmsb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","And you and your households may eat the rest of it anywhere; it is the compensation for your work at the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Once you have presented the best part of it, you will not incur guilt because of it. But you must not defile the sacred offerings of the Israelites, or else you will die.’” ");
INSERT INTO engmsb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Then the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“This is the statute of the law that the LORD has commanded: Instruct the Israelites to bring you an unblemished red heifer that has no defect and has never been placed under a yoke. ");
INSERT INTO engmsb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Give it to Eleazar the priest, and he will have it brought outside the camp and slaughtered in his presence. ");
INSERT INTO engmsb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar the priest is to take some of its blood on his finger and sprinkle it seven times toward the front of the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Then the heifer must be burned in his sight. Its hide, its flesh, and its blood are to be burned, along with its dung. ");
INSERT INTO engmsb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","The priest is to take cedar wood, hyssop, and scarlet wool and throw them onto the burning heifer. ");
INSERT INTO engmsb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the priest must wash his clothes and bathe his body in water; after that he may enter the camp, but he will be ceremonially unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The one who burned the heifer must also wash his clothes and bathe his body in water, and he too will be ceremonially unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Then a man who is ceremonially clean is to gather up the ashes of the heifer and store them in a ceremonially clean place outside the camp. They must be kept by the congregation of Israel for preparing the water of purification; this is for purification from sin. ");
INSERT INTO engmsb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","The man who has gathered up the ashes of the heifer must also wash his clothes, and he will be ceremonially unclean until evening. This is a permanent statute for the Israelites and for the foreigner residing among them. ");
INSERT INTO engmsb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Whoever touches any dead body will be unclean for seven days. ");
INSERT INTO engmsb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","He must purify himself with the water on the third day and on the seventh day; then he will be clean. But if he does not purify himself on the third and seventh days, he will not be clean. ");
INSERT INTO engmsb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Anyone who touches a human corpse and fails to purify himself defiles the tabernacle of the LORD. That person must be cut off from Israel. He remains unclean, because the water of purification has not been sprinkled on him, and his uncleanness is still on him. ");
INSERT INTO engmsb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","This is the law when a person dies in a tent: Everyone who enters the tent and everyone already in the tent will be unclean for seven days, ");
INSERT INTO engmsb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","and any open container without a lid fastened on it is unclean. ");
INSERT INTO engmsb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Anyone in the open field who touches someone who has been killed by the sword or has died of natural causes, or anyone who touches a human bone or a grave, will be unclean for seven days. ");
INSERT INTO engmsb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","For the purification of the unclean person, take some of the ashes of the burnt sin offering, put them in a jar, and pour fresh water over them. ");
INSERT INTO engmsb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Then a man who is ceremonially clean is to take some hyssop, dip it in the water, and sprinkle the tent, all the furnishings, and the people who were there. He is also to sprinkle the one who touched a bone, a grave, or a person who has died or been slain. ");
INSERT INTO engmsb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","The man who is ceremonially clean is to sprinkle the unclean person on the third day and on the seventh day. After he purifies the unclean person on the seventh day, the one being cleansed must wash his clothes and bathe in water, and that evening he will be clean. ");
INSERT INTO engmsb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But if a person who is unclean does not purify himself, he will be cut off from the assembly, because he has defiled the sanctuary of the LORD. The water of purification has not been sprinkled on him; he is unclean. ");
INSERT INTO engmsb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","This is a permanent statute for the people: The one who sprinkles the water of purification must wash his clothes, and whoever touches the water of purification will be unclean until evening. ");
INSERT INTO engmsb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Anything the unclean person touches will become unclean, and anyone who touches it will be unclean until evening.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","In the first month, the whole congregation of Israel entered the Wilderness of Zin and stayed in Kadesh. There Miriam died and was buried. ");
INSERT INTO engmsb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Now there was no water for the congregation, so they gathered against Moses and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","The people quarreled with Moses and said, “If only we had perished with our brothers before the LORD! ");
INSERT INTO engmsb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you brought the LORD’s assembly into this wilderness for us and our livestock to die here? ");
INSERT INTO engmsb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why have you led us up out of Egypt to bring us to this wretched place? It is not a place of grain, figs, vines, or pomegranates—and there is no water to drink!” ");
INSERT INTO engmsb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Then Moses and Aaron went from the presence of the assembly to the entrance to the Tent of Meeting. They fell facedown, and the glory of the LORD appeared to them. ");
INSERT INTO engmsb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Take the staff and assemble the congregation. You and your brother Aaron are to speak to the rock while they watch, and it will pour out its water. You will bring out water from the rock and provide drink for the congregation and their livestock.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","So Moses took the staff from the LORD’s presence, just as he had been commanded. ");
INSERT INTO engmsb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Then Moses and Aaron gathered the assembly in front of the rock, and Moses said to them, “Listen now, you rebels, must we bring you water out of this rock?” ");
INSERT INTO engmsb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Then Moses raised his hand and struck the rock twice with his staff, so that a great amount of water gushed out, and the congregation and their livestock were able to drink. ");
INSERT INTO engmsb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","But the LORD said to Moses and Aaron, “Because you did not trust Me to show My holiness in the sight of the Israelites, you will not bring this assembly into the land that I have given them.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","These were the waters of Meribah, where the Israelites quarreled with the LORD, and He showed His holiness among them. ");
INSERT INTO engmsb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","From Kadesh, Moses sent messengers to tell the king of Edom, “This is what your brother Israel says: You know all the hardship that has befallen us, ");
INSERT INTO engmsb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","how our fathers went down to Egypt, where we lived many years. The Egyptians mistreated us and our fathers, ");
INSERT INTO engmsb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","and when we cried out to the LORD, He heard our voice, sent an angel, and brought us out of Egypt. Now look, we are in Kadesh, a city on the edge of your territory. ");
INSERT INTO engmsb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Please let us pass through your land. We will not go through any field or vineyard, or drink water from any well. We will stay on the King’s Highway; we will not turn to the right or to the left until we have passed through your territory.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But Edom answered, “You may not travel through our land, or we will come out and confront you with the sword.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","“We will stay on the main road,” the Israelites replied, “and if we or our herds drink your water, we will pay for it. There will be no problem; only let us pass through on foot.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But Edom insisted, “You may not pass through.” And they came out to confront the Israelites with a large army and a strong hand. ");
INSERT INTO engmsb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","So Edom refused to allow Israel to pass through their territory, and Israel turned away from them. ");
INSERT INTO engmsb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","After they had set out from Kadesh, the whole congregation of Israel came to Mount Hor. ");
INSERT INTO engmsb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","And at Mount Hor, near the border of the land of Edom, the LORD said to Moses and Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron will be gathered to his people; he will not enter the land that I have given the Israelites, because both of you rebelled against My command at the waters of Meribah. ");
INSERT INTO engmsb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Take Aaron and his son Eleazar and bring them up Mount Hor. ");
INSERT INTO engmsb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Remove Aaron’s priestly garments and put them on his son Eleazar. Aaron will be gathered to his people and will die there.” ");
INSERT INTO engmsb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","So Moses did as the LORD had commanded, and they climbed Mount Hor in the sight of the whole congregation. ");
INSERT INTO engmsb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","After Moses had removed Aaron’s garments and put them on his son Eleazar, Aaron died there on top of the mountain. Then Moses and Eleazar came down from the mountain. ");
INSERT INTO engmsb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","When the whole congregation saw that Aaron had died, the entire house of Israel mourned for him thirty days. ");
INSERT INTO engmsb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","When the Canaanite king of Arad, who lived in the Negev, heard that Israel was coming along the road to Atharim, he attacked Israel and captured some prisoners. ");
INSERT INTO engmsb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","So Israel made a vow to the LORD: “If You will deliver this people into our hands, we will devote their cities to destruction.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","And the LORD heard Israel’s plea and delivered up the Canaanites. Israel devoted them and their cities to destruction; so they named the place Hormah. ");
INSERT INTO engmsb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Then they set out from Mount Hor along the route to the Red Sea, in order to bypass the land of Edom. But the people grew impatient on the journey ");
INSERT INTO engmsb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","and spoke against God and against Moses: “Why have you led us up out of Egypt to die in the wilderness? There is no bread or water, and we detest this wretched food!” ");
INSERT INTO engmsb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","So the LORD sent venomous snakes among the people, and many of the Israelites were bitten and died. ");
INSERT INTO engmsb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Then the people came to Moses and said, “We have sinned by speaking against the LORD and against you. Intercede with the LORD so He will take the snakes away from us.” So Moses interceded for the people. ");
INSERT INTO engmsb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Then the LORD said to Moses, “Make a fiery serpent and mount it on a pole. When anyone who is bitten looks at it, he will live.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","So Moses made a bronze snake and mounted it on a pole. If anyone who was bitten looked at the bronze snake, he would live. ");
INSERT INTO engmsb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Then the Israelites set out and camped at Oboth. ");
INSERT INTO engmsb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","They journeyed from Oboth and camped at Iye-abarim in the wilderness opposite Moab to the east. ");
INSERT INTO engmsb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","From there they set out and camped in the Valley of Zered. ");
INSERT INTO engmsb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","From there they moved on and camped on the other side of the Arnon, in the wilderness that extends into the Amorite territory. Now the Arnon is the border between the Moabites and the Amorites. ");
INSERT INTO engmsb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Therefore it is stated in the Book of the Wars of the LORD: “Waheb in Suphah and the wadis of the Arnon, ");
INSERT INTO engmsb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","even the slopes of the wadis that extend to the site of Ar and lie along the border of Moab.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","From there they went on to Beer, the well where the LORD said to Moses, “Gather the people so that I may give them water.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then Israel sang this song: “Spring up, O well, all of you sing to it! ");
INSERT INTO engmsb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The princes dug the well; the nobles of the people hollowed it out with their scepters and with their staffs.” From the wilderness the Israelites went on to Mattanah, ");
INSERT INTO engmsb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","and from Mattanah to Nahaliel, and from Nahaliel to Bamoth, ");
INSERT INTO engmsb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth to the valley in Moab where the top of Pisgah overlooks the wasteland. ");
INSERT INTO engmsb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Then Israel sent messengers to Sihon king of the Amorites, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Let us pass through your land. We will not turn aside into any field or vineyard, or drink water from any well. We will stay on the King’s Highway until we have passed through your territory.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But Sihon would not let Israel pass through his territory. Instead, he gathered his whole army and went out to confront Israel in the wilderness. When he came to Jahaz, he fought against Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","And Israel put him to the sword and took possession of his land, from the Arnon to the Jabbok—but only up to the border of the Ammonites, because it was fortified. ");
INSERT INTO engmsb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel captured all the cities of the Amorites and occupied them, including Heshbon and all its villages. ");
INSERT INTO engmsb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon was the city of Sihon king of the Amorites, who had fought against the former king of Moab and taken all his land as far as the Arnon. ");
INSERT INTO engmsb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","That is why the poets say: “Come to Heshbon, let it be rebuilt; let the city of Sihon be restored. ");
INSERT INTO engmsb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For a fire went out from Heshbon, a blaze from the city of Sihon. It consumed Ar of Moab, the rulers of Arnon’s heights. ");
INSERT INTO engmsb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Woe to you, O Moab! You are destroyed, O people of Chemosh! He gave up his sons as refugees, and his daughters into captivity to Sihon king of the Amorites. ");
INSERT INTO engmsb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","But we have overthrown them; Heshbon is destroyed as far as Dibon. We demolished them as far as Nophah, which reaches to Medeba.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","So Israel lived in the land of the Amorites. ");
INSERT INTO engmsb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","After Moses had sent spies to Jazer, Israel captured its villages and drove out the Amorites who were there. ");
INSERT INTO engmsb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then they turned and went up the road to Bashan, and Og king of Bashan and his whole army came out to meet them in battle at Edrei. ");
INSERT INTO engmsb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","But the LORD said to Moses, “Do not fear him, for I have delivered him into your hand, along with all his people and his land. Do to him as you did to Sihon king of the Amorites, who lived in Heshbon.” ");
INSERT INTO engmsb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they struck down Og, along with his sons and his whole army, until no remnant was left. And they took possession of his land. ");
INSERT INTO engmsb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Then the Israelites traveled on and camped in the plains of Moab near the Jordan, across from Jericho. ");
INSERT INTO engmsb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Now Balak son of Zippor saw all that Israel had done to the Amorites, ");
INSERT INTO engmsb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","and Moab was terrified of the people because they were numerous. Indeed, Moab dreaded the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","So the Moabites said to the elders of Midian, “This horde will devour everything around us, as an ox licks up the grass of the field.” Since Balak son of Zippor was king of Moab at that time, ");
INSERT INTO engmsb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","he sent messengers to summon Balaam son of Beor at Pethor, which is by the Euphrates in the land of his people. “Behold, a people has come out of Egypt,” said Balak. “They cover the face of the land and have settled next to me. ");
INSERT INTO engmsb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","So please come now and put a curse on this people, because they are too mighty for me. Perhaps I may be able to defeat them and drive them out of the land; for I know that those you bless are blessed, and those you curse are cursed.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","The elders of Moab and Midian departed with the fees for divination in hand. They came to Balaam and relayed to him the words of Balak. ");
INSERT INTO engmsb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“Spend the night here,” Balaam replied, “and I will give you the answer that the LORD speaks to me.” So the princes of Moab stayed with Balaam. ");
INSERT INTO engmsb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Then God came to Balaam and asked, “Who are these men with you?” ");
INSERT INTO engmsb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","And Balaam said to God, “Balak son of Zippor, king of Moab, sent me this message: ");
INSERT INTO engmsb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Behold, a people has come out of Egypt, and they cover the face of the land. Now come and put a curse on them for me. Perhaps I may be able to fight against them and drive them away.’” ");
INSERT INTO engmsb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","But God said to Balaam, “Do not go with them. You are not to curse this people, for they are blessed.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","So Balaam got up the next morning and said to Balak’s princes, “Go back to your homeland, because the LORD has refused to let me go with you.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","And the princes of Moab arose, returned to Balak, and said, “Balaam refused to come with us.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Then Balak sent other princes, more numerous and more distinguished than the first messengers. ");
INSERT INTO engmsb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","They came to Balaam and said, “This is what Balak son of Zippor says: ‘Please let nothing hinder you from coming to me, ");
INSERT INTO engmsb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","for I will honor you richly and do whatever you say. So please come and put a curse on this people for me!’” ");
INSERT INTO engmsb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","But Balaam replied to the servants of Balak, “If Balak were to give me his house full of silver and gold, I could not do anything small or great to go beyond the command of the LORD my God. ");
INSERT INTO engmsb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","So now, please stay here overnight as the others did, that I may find out what else the LORD has to tell me.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","That night God came to Balaam and said, “Since these men have come to summon you, get up and go with them, but you must only do what I tell you.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","So in the morning Balaam got up, saddled his donkey, and went with the princes of Moab. ");
INSERT INTO engmsb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Then God’s anger was kindled because Balaam was going along, and the angel of the LORD stood in the road to oppose him. Balaam was riding his donkey, and his two servants were with him. ");
INSERT INTO engmsb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","When the donkey saw the angel of the LORD standing in the road with a drawn sword in his hand, she turned off the path and went into a field. So Balaam beat her to return her to the path. ");
INSERT INTO engmsb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the angel of the LORD stood in a narrow passage between two vineyards, with walls on either side. ");
INSERT INTO engmsb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","And the donkey saw the angel of the LORD and pressed herself against the wall, crushing Balaam’s foot against it. So he beat her once again. ");
INSERT INTO engmsb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","And the angel of the LORD moved on ahead and stood in a narrow place where there was no room to turn to the right or left. ");
INSERT INTO engmsb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","When the donkey saw the angel of the LORD, she lay down under Balaam, and he became furious and beat her with his staff. ");
INSERT INTO engmsb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Then the LORD opened the donkey’s mouth, and she said to Balaam, “What have I done to you that you have beaten me these three times?” ");
INSERT INTO engmsb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam answered the donkey, “You have made a fool of me! If I had a sword in my hand, I would kill you right now!” ");
INSERT INTO engmsb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","But the donkey said to Balaam, “Am I not the donkey you have ridden all your life until today? Have I ever treated you this way before?” “No,” he replied. ");
INSERT INTO engmsb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the LORD opened Balaam’s eyes, and he saw the angel of the LORD standing in the road with a drawn sword in his hand. And Balaam bowed low and fell facedown. ");
INSERT INTO engmsb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","The angel of the LORD asked him, “Why have you beaten your donkey these three times? Behold, I have come out to oppose you, because your way is perverse before me. ");
INSERT INTO engmsb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","The donkey saw me and turned away from me these three times. If she had not turned away, then by now I would surely have killed you and let her live.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","“I have sinned,” Balaam said to the angel of the LORD, “for I did not realize that you were standing in the road to confront me. And now, if this is displeasing in your sight, I will go back home.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","But the angel of the LORD said to Balaam, “Go with the men, but you are to speak only what I tell you.” So Balaam went with the princes of Balak. ");
INSERT INTO engmsb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","When Balak heard that Balaam was coming, he went out to meet him at the Moabite city on the Arnon border, at the edge of his territory. ");
INSERT INTO engmsb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","And he said to Balaam, “Did I not send you an urgent summons? Why did you not come to me? Am I really not able to reward you richly?” ");
INSERT INTO engmsb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“See, I have come to you,” Balaam replied, “but can I say just anything? I must speak only the word that God puts in my mouth.” ");
INSERT INTO engmsb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","So Balaam accompanied Balak, and they came to Kiriath-huzoth. ");
INSERT INTO engmsb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrificed cattle and sheep, and he gave portions to Balaam and the princes who were with him. ");
INSERT INTO engmsb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","The next morning, Balak took Balaam and brought him up to Bamoth-baal. From there he could see the outskirts of the camp of the people. ");
INSERT INTO engmsb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Then Balaam said to Balak, “Build for me seven altars here, and prepare for me seven bulls and seven rams.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","So Balak did as Balaam had instructed, and Balak and Balaam offered a bull and a ram on each altar. ");
INSERT INTO engmsb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","“Stay here by your burnt offering while I am gone,” Balaam said to Balak. “Perhaps the LORD will meet with me. And whatever He reveals to me, I will tell you.” So Balaam went off to a barren height, ");
INSERT INTO engmsb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","and God met with him. “I have set up seven altars,” Balaam said, “and on each altar I have offered a bull and a ram.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Then the LORD put a message in Balaam’s mouth, saying, “Return to Balak and give him this message.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So he returned to Balak, who was standing there beside his burnt offering, with all the princes of Moab. ");
INSERT INTO engmsb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","And Balaam lifted up an oracle, saying: “Balak brought me from Aram, the king of Moab from the mountains of the east. ‘Come,’ he said, ‘put a curse on Jacob for me; come and denounce Israel!’ ");
INSERT INTO engmsb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","How can I curse those whom God has not cursed? How can I denounce those whom the LORD has not denounced? ");
INSERT INTO engmsb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For I see them from atop the rocky cliffs, and I watch them from the hills. Behold, a people dwelling apart, not reckoning themselves among the nations. ");
INSERT INTO engmsb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count the dust of Jacob or number even a fourth of Israel? Let me die the death of the righteous; let my end be like theirs!” ");
INSERT INTO engmsb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Then Balak said to Balaam, “What have you done to me? I brought you here to curse my enemies, and behold, you have only blessed them!” ");
INSERT INTO engmsb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","But Balaam replied, “Should I not speak exactly what the LORD puts in my mouth?” ");
INSERT INTO engmsb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Then Balak said to him, “Please come with me to another place where you can see them. You will only see the outskirts of their camp—not all of them. And from there, curse them for me.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","So Balak took him to the field of Zophim, to the top of Pisgah, where he built seven altars and offered a bull and a ram on each altar. ");
INSERT INTO engmsb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam said to Balak, “Stay here beside your burnt offering while I meet the LORD over there.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","And the LORD met with Balaam and put a message in his mouth, saying, “Return to Balak and speak what I tell you.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","So he returned to Balak, who was standing there by his burnt offering with the princes of Moab. “What did the LORD say?” Balak asked. ");
INSERT INTO engmsb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Then Balaam lifted up an oracle, saying: “Arise, O Balak, and listen; give ear to me, O son of Zippor. ");
INSERT INTO engmsb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man, that He should lie, or a son of man, that He should change His mind. Does He speak and not act? Does He promise and not fulfill? ");
INSERT INTO engmsb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","I have indeed received a command to bless; He has blessed, and I cannot change it. ");
INSERT INTO engmsb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He considers no disaster for Jacob; He sees no trouble for Israel. The LORD their God is with them, and the shout of the King is among them. ");
INSERT INTO engmsb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God brought them out of Egypt with strength like a wild ox. ");
INSERT INTO engmsb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","For there is no spell against Jacob and no divination against Israel. It will now be said of Jacob and Israel, ‘What great things God has done!’ ");
INSERT INTO engmsb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Behold, the people rise like a lioness; they rouse themselves like a lion, not resting until they devour their prey and drink the blood of the slain.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Now Balak said to Balaam, “Then neither curse them at all nor bless them at all!” ");
INSERT INTO engmsb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam replied, “Did I not tell you that whatever the LORD says, I must do?” ");
INSERT INTO engmsb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","“Please come,” said Balak, “I will take you to another place. Perhaps it will please God that you curse them for me from there.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","And Balak took Balaam to the top of Peor, which overlooks the wasteland. ");
INSERT INTO engmsb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Then Balaam said, “Build for me seven altars here, and prepare for me seven bulls and seven rams.” ");
INSERT INTO engmsb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","So Balak did as Balaam had instructed, and he offered a bull and a ram on each altar. ");
INSERT INTO engmsb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","And when Balaam saw that it pleased the LORD to bless Israel, he did not seek omens as on previous occasions, but he turned his face toward the wilderness. ");
INSERT INTO engmsb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","When Balaam looked up and saw Israel encamped tribe by tribe, the Spirit of God came upon him, ");
INSERT INTO engmsb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","and he lifted up an oracle, saying: “This is the prophecy of Balaam son of Beor, the prophecy of a man whose eyes are open, ");
INSERT INTO engmsb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","the prophecy of one who hears the words of God, who sees a vision from the Almighty, who bows down with eyes wide open: ");
INSERT INTO engmsb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How lovely are your tents, O Jacob, your dwellings, O Israel! ");
INSERT INTO engmsb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","They spread out like palm groves, like gardens beside a stream, like aloes the LORD has planted, like cedars beside the waters. ");
INSERT INTO engmsb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Water will flow from his buckets, and his seed will have abundant water. His king will be greater than Agag, and his kingdom will be exalted. ");
INSERT INTO engmsb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God brought him out of Egypt with strength like a wild ox, to devour hostile nations and crush their bones, to pierce them with arrows. ");
INSERT INTO engmsb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","He crouches, he lies down like a lion, like a lioness—who dares to rouse him? Blessed are those who bless you and cursed are those who curse you.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Then Balak’s anger burned against Balaam, and he struck his hands together and said to Balaam, “I summoned you to curse my enemies, but behold, you have persisted in blessing them these three times. ");
INSERT INTO engmsb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Therefore, flee at once to your home! I said I would reward you richly, but instead the LORD has denied your reward.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam answered Balak, “Did I not already tell the messengers you sent me ");
INSERT INTO engmsb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","that even if Balak were to give me his house full of silver and gold, I could not do anything of my own accord, good or bad, to go beyond the command of the LORD? I must speak whatever the LORD says. ");
INSERT INTO engmsb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Now I am going back to my people, but come, let me warn you what this people will do to your people in the days to come.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Then Balaam lifted up an oracle, saying, “This is the prophecy of Balaam son of Beor, the prophecy of a man whose eyes are open, ");
INSERT INTO engmsb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","the prophecy of one who hears the words of God, who has knowledge from the Most High, who sees a vision from the Almighty, who bows down with eyes wide open: ");
INSERT INTO engmsb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but not now; I behold him, but not near. A star will come forth from Jacob, and a scepter will arise from Israel. He will crush the skulls of Moab and strike down all the sons of Sheth. ");
INSERT INTO engmsb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edom will become a possession, as will Seir, his enemy; but Israel will perform with valor. ");
INSERT INTO engmsb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","A ruler will come from Jacob and destroy the survivors of the city.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Then Balaam saw Amalek and lifted up an oracle, saying: “Amalek was first among the nations, but his end is destruction.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Next he saw the Kenites and lifted up an oracle, saying: “Your dwelling place is secure, and your nest is set in a cliff. ");
INSERT INTO engmsb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Yet Kain will be destroyed when Asshur takes you captive.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Once more Balaam lifted up an oracle, saying: “Ah, who can live unless God has ordained it? ");
INSERT INTO engmsb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ships will come from the coasts of Cyprus; they will subdue Asshur and Eber, but they too will perish forever.” ");
INSERT INTO engmsb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Then Balaam arose and returned to his homeland, and Balak also went on his way. ");
INSERT INTO engmsb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","While Israel was staying in Shittim, the men began to indulge in sexual immorality with the daughters of Moab, ");
INSERT INTO engmsb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","who also invited them to the sacrifices for their gods. And the people ate and bowed down to these gods. ");
INSERT INTO engmsb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","So Israel joined in worshiping Baal of Peor, and the anger of the LORD burned against them. ");
INSERT INTO engmsb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Then the LORD said to Moses, “Take all the leaders of the people and execute them in broad daylight before the LORD, so that His fierce anger may turn away from Israel.” ");
INSERT INTO engmsb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses told the judges of Israel, “Each of you must kill all of his men who have joined in worshiping Baal of Peor.” ");
INSERT INTO engmsb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Just then an Israelite man brought to his family a Midianite woman in the sight of Moses and the whole congregation of Israel while they were weeping at the entrance to the Tent of Meeting. ");
INSERT INTO engmsb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","On seeing this, Phinehas son of Eleazar, the son of Aaron the priest, got up from the assembly, took a spear in his hand, ");
INSERT INTO engmsb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","followed the Israelite into his tent, and drove the spear through both of them—through the Israelite and on through the belly of the woman. So the plague against the Israelites was halted, ");
INSERT INTO engmsb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","but those who died in the plague numbered 24,000. ");
INSERT INTO engmsb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas son of Eleazar, the son of Aaron the priest, has turned My wrath away from the Israelites; for he was zealous for My sake among them, so that I did not consume the Israelites in My zeal. ");
INSERT INTO engmsb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Declare, therefore, that I am granting him My covenant of peace. ");
INSERT INTO engmsb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","It will be a covenant of permanent priesthood for him and his descendants, because he was zealous for his God and made atonement for the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","The name of the Israelite who was slain with the Midianite woman was Zimri son of Salu, the leader of a Simeonite family. ");
INSERT INTO engmsb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","And the name of the slain Midianite woman was Cozbi, the daughter of Zur, a tribal chief of a Midianite family. ");
INSERT INTO engmsb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Attack the Midianites and strike them dead. ");
INSERT INTO engmsb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","For they assailed you deceitfully when they seduced you in the matter of Peor and their sister Cozbi, the daughter of the Midianite leader, the woman who was killed on the day the plague came because of Peor.” ");
INSERT INTO engmsb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","After the plague had ended, the LORD said to Moses and Eleazar son of Aaron the priest, ");
INSERT INTO engmsb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Take a census of the whole congregation of Israel by the houses of their fathers—all those twenty years of age or older who can serve in the army of Israel.” ");
INSERT INTO engmsb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","So on the plains of Moab by the Jordan, across from Jericho, Moses and Eleazar the priest issued the instruction, ");
INSERT INTO engmsb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Take a census of the men twenty years of age or older, as the LORD has commanded Moses.” And these were the Israelites who came out of the land of Egypt: ");
INSERT INTO engmsb_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Reuben was the firstborn of Israel. These were the descendants of Reuben: The Hanochite clan from Hanoch, the Palluite clan from Pallu, ");
INSERT INTO engmsb_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","the Hezronite clan from Hezron, and the Carmite clan from Carmi. ");
INSERT INTO engmsb_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These were the clans of Reuben, and their registration numbered 43,730. ");
INSERT INTO engmsb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Now the son of Pallu was Eliab, ");
INSERT INTO engmsb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","and the sons of Eliab were Nemuel, Dathan, and Abiram. It was Dathan and Abiram, chosen by the congregation, who rebelled against Moses and Aaron with the followers of Korah who rebelled against the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","And the earth opened its mouth and swallowed them along with Korah, whose followers died when the fire consumed 250 men. They serve as a warning sign. ");
INSERT INTO engmsb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","However, the line of Korah did not die out. ");
INSERT INTO engmsb_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","These were the descendants of Simeon by their clans: The Nemuelite clan from Nemuel, the Jaminite clan from Jamin, the Jachinite clan from Jachin, ");
INSERT INTO engmsb_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","the Zerahite clan from Zerah, and the Shaulite clan from Shaul. ");
INSERT INTO engmsb_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These were the clans of Simeon, and there were 22,200 men. ");
INSERT INTO engmsb_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","These were the descendants of Gad by their clans: The Zephonite clan from Zephon, the Haggite clan from Haggi, the Shunite clan from Shuni, ");
INSERT INTO engmsb_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","the Oznite clan from Ozni, the Erite clan from Eri, ");
INSERT INTO engmsb_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","the Arodite clan from Arod, and the Arelite clan from Areli. ");
INSERT INTO engmsb_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These were the clans of Gad, and their registration numbered 40,500. ");
INSERT INTO engmsb_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The sons of Judah were Er and Onan, but they died in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","These were the descendants of Judah by their clans: The Shelanite clan from Shelah, the Perezite clan from Perez, and the Zerahite clan from Zerah. ");
INSERT INTO engmsb_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","And these were the descendants of Perez: the Hezronite clan from Hezron and the Hamulite clan from Hamul. ");
INSERT INTO engmsb_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These were the clans of Judah, and their registration numbered 76,500. ");
INSERT INTO engmsb_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","These were the descendants of Issachar by their clans: The Tolaite clan from Tola, the Punite clan from Puvah, ");
INSERT INTO engmsb_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","the Jashubite clan from Jashub, and the Shimronite clan from Shimron. ");
INSERT INTO engmsb_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These were the clans of Issachar, and their registration numbered 64,300. ");
INSERT INTO engmsb_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","These were the descendants of Zebulun by their clans: The Seredite clan from Sered, the Elonite clan from Elon, and the Jahleelite clan from Jahleel. ");
INSERT INTO engmsb_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These were the clans of Zebulun, and their registration numbered 60,500. ");
INSERT INTO engmsb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","The descendants of Joseph included the clans of Manasseh and Ephraim. ");
INSERT INTO engmsb_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","These were the descendants of Manasseh: The Machirite clan from Machir, the father of Gilead, and the Gileadite clan from Gilead. ");
INSERT INTO engmsb_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","These were the descendants of Gilead: the Iezerite clan from Iezer, the Helekite clan from Helek, ");
INSERT INTO engmsb_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","the Asrielite clan from Asriel, the Shechemite clan from Shechem, ");
INSERT INTO engmsb_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","the Shemidaite clan from Shemida, and the Hepherite clan from Hepher. ");
INSERT INTO engmsb_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Now Zelophehad son of Hepher had no sons but only daughters. The names of his daughters were Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engmsb_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These were the clans of Manasseh, and their registration numbered 52,700. ");
INSERT INTO engmsb_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These were the descendants of Ephraim by their clans: The Shuthelahite clan from Shuthelah, the Becherite clan from Becher, and the Tahanite clan from Tahan. ");
INSERT INTO engmsb_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","And the descendants of Shuthelah were the Eranite clan from Eran. ");
INSERT INTO engmsb_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These were the clans of Ephraim, and their registration numbered 32,500. These clans were the descendants of Joseph. ");
INSERT INTO engmsb_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","These were the descendants of Benjamin by their clans: The Belaite clan from Bela, the Ashbelite clan from Ashbel, the Ahiramite clan from Ahiram, ");
INSERT INTO engmsb_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","the Shuphamite clan from Shupham, and the Huphamite clan from Hupham. ");
INSERT INTO engmsb_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","And the descendants of Bela from Ard and Naaman were the Ardite clan from Ard and the Naamite clan from Naaman. ");
INSERT INTO engmsb_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These were the clans of Benjamin, and their registration numbered 45,600. ");
INSERT INTO engmsb_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These were the descendants of Dan by their clans: The Shuhamite clan from Shuham. These were the clans of Dan. ");
INSERT INTO engmsb_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","All of them were Shuhamite clans, and their registration numbered 64,400. ");
INSERT INTO engmsb_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","These were the descendants of Asher by their clans: The Imnite clan from Imnah, the Ishvite clan from Ishvi, and the Beriite clan from Beriah. ");
INSERT INTO engmsb_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","And these were the descendants of Beriah: the Heberite clan from Heber and the Malchielite clan from Malchiel. ");
INSERT INTO engmsb_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","And the name of Asher’s daughter was Serah. ");
INSERT INTO engmsb_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These were the clans of Asher, and their registration numbered 53,400. ");
INSERT INTO engmsb_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","These were the descendants of Naphtali by their clans: The Jahzeelite clan from Jahzeel, the Gunite clan from Guni, ");
INSERT INTO engmsb_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","the Jezerite clan from Jezer, and the Shillemite clan from Shillem. ");
INSERT INTO engmsb_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These were the clans of Naphtali, and their registration numbered 45,400. ");
INSERT INTO engmsb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","These men of Israel numbered 601,730 in all. ");
INSERT INTO engmsb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“The land is to be divided among the tribes as an inheritance, according to the number of names. ");
INSERT INTO engmsb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Increase the inheritance for a large tribe and decrease it for a small one; each tribe is to receive its inheritance according to the number of those registered. ");
INSERT INTO engmsb_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Indeed, the land must be divided by lot; they shall receive their inheritance according to the names of the tribes of their fathers. ");
INSERT INTO engmsb_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Each inheritance is to be divided by lot among the larger and smaller tribes.” ");
INSERT INTO engmsb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Now these were the Levites numbered by their clans: The Gershonite clan from Gershon, the Kohathite clan from Kohath, and the Merarite clan from Merari. ");
INSERT INTO engmsb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These were the families of the Levites: The Libnite clan, the Hebronite clan, the Mahlite clan, the Mushite clan, and the Korahite clan. Now Kohath was the father of Amram, ");
INSERT INTO engmsb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","and Amram’s wife was named Jochebed. She was also a daughter of Levi, born to Levi in Egypt. To Amram she bore Aaron, Moses, and their sister Miriam. ");
INSERT INTO engmsb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Nadab, Abihu, Eleazar, and Ithamar were born to Aaron, ");
INSERT INTO engmsb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","but Nadab and Abihu died when they offered unauthorized fire before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","The registration of the Levites totaled 23,000, every male a month old or more; they were not numbered among the other Israelites, because no inheritance was given to them among the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","These were the ones numbered by Moses and Eleazar the priest when they counted the Israelites on the plains of Moab by the Jordan, across from Jericho. ");
INSERT INTO engmsb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Among all these, however, there was not one who had been numbered by Moses and Aaron the priest when they counted the Israelites in the Wilderness of Sinai. ");
INSERT INTO engmsb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","For the LORD had told them that they would surely die in the wilderness. Not one was left except Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engmsb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Now the daughters of Zelophehad son of Hepher, the son of Gilead, the son of Machir, the son of Manasseh, belonged to the clans of Manasseh son of Joseph. These were the names of his daughters: Mahlah, Noah, Hoglah, Milcah, and Tirzah. They approached ");
INSERT INTO engmsb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","the entrance to the Tent of Meeting, stood before Moses, Eleazar the priest, the leaders, and the whole congregation, and said, ");
INSERT INTO engmsb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died in the wilderness, but he was not among the followers of Korah who gathered together against the LORD. Instead, he died because of his own sin, and he had no sons. ");
INSERT INTO engmsb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should the name of our father disappear from his clan because he had no sons? Give us property among our father’s brothers.” ");
INSERT INTO engmsb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","So Moses brought their case before the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","and the LORD answered him, ");
INSERT INTO engmsb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“The daughters of Zelophehad speak correctly. You certainly must give them property as an inheritance among their father’s brothers and transfer their father’s inheritance to them. ");
INSERT INTO engmsb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Furthermore, you shall say to the Israelites, ‘If a man dies and leaves no son, you are to transfer his inheritance to his daughter. ");
INSERT INTO engmsb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","If he has no daughter, give his inheritance to his brothers. ");
INSERT INTO engmsb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","If he has no brothers, give his inheritance to his father’s brothers. ");
INSERT INTO engmsb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","And if his father has no brothers, give his inheritance to the next of kin from his clan, that he may take possession of it. This is to be a statutory ordinance for the Israelites, as the LORD has commanded Moses.’” ");
INSERT INTO engmsb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Then the LORD said to Moses, “Go up this mountain of the Abarim range and see the land that I have given the Israelites. ");
INSERT INTO engmsb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","After you have seen it, you too will be gathered to your people, as your brother Aaron was; ");
INSERT INTO engmsb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","for when the congregation contended in the Wilderness of Zin, both of you rebelled against My command to show My holiness in their sight regarding the waters.” Those were the waters of Meribah in Kadesh, in the Wilderness of Zin. ");
INSERT INTO engmsb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","So Moses appealed to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“May the LORD, the God of the spirits of all flesh, appoint a man over the congregation ");
INSERT INTO engmsb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who will go out and come in before them, and who will lead them out and bring them in, so that the congregation of the LORD will not be like sheep without a shepherd.” ");
INSERT INTO engmsb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","And the LORD replied to Moses, “Take Joshua son of Nun, a man with the Spirit in him, and lay your hands on him. ");
INSERT INTO engmsb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Have him stand before Eleazar the priest and the whole congregation, and commission him in their sight. ");
INSERT INTO engmsb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Confer on him some of your authority, so that the whole congregation of Israel will obey him. ");
INSERT INTO engmsb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","He shall stand before Eleazar the priest, who will seek counsel for him before the LORD by the judgment of the Urim. At his command, he and all the Israelites with him—the entire congregation—will go out and come in.” ");
INSERT INTO engmsb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses did as the LORD had commanded him. He took Joshua, had him stand before Eleazar the priest and the whole congregation, ");
INSERT INTO engmsb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","and laid his hands on him and commissioned him, as the LORD had instructed through Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Command the Israelites and say to them: See that you present to Me at its appointed time the food for My food offerings, as a pleasing aroma to Me. ");
INSERT INTO engmsb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","And tell them that this is the food offering you are to present to the LORD as a regular burnt offering each day: two unblemished year-old male lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Offer one lamb in the morning and the other at twilight, ");
INSERT INTO engmsb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","along with a tenth of an ephah of fine flour as a grain offering, mixed with a quarter hin of oil from pressed olives. ");
INSERT INTO engmsb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","This is a regular burnt offering established at Mount Sinai as a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","The drink offering accompanying each lamb shall be a quarter hin. Pour out the offering of fermented drink to the LORD in the sanctuary area. ");
INSERT INTO engmsb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","And offer the second lamb at twilight, with the same grain offering and drink offering as in the morning. It is a food offering, a pleasing aroma to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","On the Sabbath day, present two unblemished year-old male lambs, accompanied by a grain offering of two-tenths of an ephah of fine flour mixed with oil, as well as a drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is the burnt offering for every Sabbath, in addition to the regular burnt offering and its drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","At the beginning of every month, you are to present to the LORD a burnt offering of two young bulls, one ram, and seven male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","along with three-tenths of an ephah of fine flour mixed with oil as a grain offering with each bull, two-tenths of an ephah of fine flour mixed with oil as a grain offering with the ram, ");
INSERT INTO engmsb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","and a tenth of an ephah of fine flour mixed with oil as a grain offering with each lamb. This is a burnt offering, a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Their drink offerings shall be half a hin of wine with each bull, a third of a hin with the ram, and a quarter hin with each lamb. This is the monthly burnt offering to be made at each new moon throughout the year. ");
INSERT INTO engmsb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","In addition to the regular burnt offering with its drink offering, one male goat is to be presented to the LORD as a sin offering. ");
INSERT INTO engmsb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","The fourteenth day of the first month is the LORD’s Passover. ");
INSERT INTO engmsb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","On the fifteenth day of this month, there shall be a feast; for seven days unleavened bread is to be eaten. ");
INSERT INTO engmsb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","On the first day there is to be a sacred assembly; you must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Present to the LORD a food offering, a burnt offering of two young bulls, one ram, and seven male lambs a year old, all unblemished. ");
INSERT INTO engmsb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","The grain offering shall consist of fine flour mixed with oil; offer three-tenths of an ephah with each bull, two-tenths of an ephah with the ram, ");
INSERT INTO engmsb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","and a tenth of an ephah with each of the seven lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Include one male goat as a sin offering to make atonement for you. ");
INSERT INTO engmsb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You are to present these in addition to the regular morning burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Offer the same food each day for seven days as a food offering, a pleasing aroma to the LORD. It is to be offered with its drink offering and the regular burnt offering. ");
INSERT INTO engmsb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","On the seventh day you shall hold a sacred assembly; you must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","On the day of firstfruits, when you present an offering of new grain to the LORD during the Feast of Weeks, you are to hold a sacred assembly; you must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Present a burnt offering of two young bulls, one ram, and seven male lambs a year old as a pleasing aroma to the LORD, ");
INSERT INTO engmsb_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","together with their grain offerings of fine flour mixed with oil—three-tenths of an ephah with each bull, two-tenths of an ephah with the ram, ");
INSERT INTO engmsb_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","and a tenth of an ephah with each of the seven lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Include one male goat to make atonement for you. ");
INSERT INTO engmsb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Offer them with their drink offerings in addition to the regular burnt offering and its grain offering. The animals must be unblemished. ");
INSERT INTO engmsb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“On the first day of the seventh month, you are to hold a sacred assembly, and you must not do any regular work. This will be a day for you to sound the trumpets. ");
INSERT INTO engmsb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","As a pleasing aroma to the LORD, you are to present a burnt offering of one young bull, one ram, and seven male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","together with their grain offerings of fine flour mixed with oil—three-tenths of an ephah with the bull, two-tenths of an ephah with the ram, ");
INSERT INTO engmsb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and a tenth of an ephah with each of the seven male lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Include one male goat as a sin offering to make atonement for you. ");
INSERT INTO engmsb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","These are in addition to the monthly and daily burnt offerings with their prescribed grain offerings and drink offerings. They are a pleasing aroma, a food offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","On the tenth day of this seventh month, you are to hold a sacred assembly, and you shall humble yourselves; you must not do any work. ");
INSERT INTO engmsb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Present as a pleasing aroma to the LORD a burnt offering of one young bull, one ram, and seven male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","together with their grain offerings of fine flour mixed with oil—three-tenths of an ephah with the bull, two-tenths of an ephah with the ram, ");
INSERT INTO engmsb_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","and a tenth of an ephah with each of the seven lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Include one male goat for a sin offering, in addition to the sin offering of atonement and the regular burnt offering with its grain offering and drink offerings. ");
INSERT INTO engmsb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","On the fifteenth day of the seventh month, you are to hold a sacred assembly; you must not do any regular work, and you shall observe a feast to the LORD for seven days. ");
INSERT INTO engmsb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","As a pleasing aroma to the LORD, you are to present a food offering, a burnt offering of thirteen young bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","along with the grain offering of three-tenths of an ephah of fine flour mixed with oil with each of the thirteen bulls, two-tenths of an ephah with each of the two rams, ");
INSERT INTO engmsb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and a tenth of an ephah with each of the fourteen lambs. ");
INSERT INTO engmsb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","On the second day you are to present twelve young bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","On the third day you are to present eleven bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","On the fourth day you are to present ten bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","On the fifth day you are to present nine bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","On the sixth day you are to present eight bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","On the seventh day you are to present seven bulls, two rams, and fourteen male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","On the eighth day you are to hold a solemn assembly; you must not do any regular work. ");
INSERT INTO engmsb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","As a pleasing aroma to the LORD, you are to present a food offering, a burnt offering of one bull, one ram, and seven male lambs a year old, all unblemished, ");
INSERT INTO engmsb_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","along with the grain and drink offerings for the bulls, rams, and lambs, according to the number prescribed. ");
INSERT INTO engmsb_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Include one male goat as a sin offering, in addition to the regular burnt offering with its grain offering and drink offering. ");
INSERT INTO engmsb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","You are to present these offerings to the LORD at your appointed times, in addition to your vow and freewill offerings, whether burnt offerings, grain offerings, drink offerings, or peace offerings.” ");
INSERT INTO engmsb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","So Moses spoke all this to the Israelites just as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Then Moses said to the heads of the tribes of Israel, “This is what the LORD has commanded: ");
INSERT INTO engmsb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","If a man makes a vow to the LORD or swears an oath to obligate himself by a pledge, he must not break his word; he must do everything he has promised. ");
INSERT INTO engmsb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","And if a woman in her father’s house during her youth makes a vow to the LORD or obligates herself by a pledge, ");
INSERT INTO engmsb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","and her father hears about her vow or pledge but says nothing to her, then all the vows or pledges by which she has bound herself shall stand. ");
INSERT INTO engmsb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father prohibits her on the day he hears about it, then none of the vows or pledges by which she has bound herself shall stand. The LORD will absolve her because her father has prohibited her. ");
INSERT INTO engmsb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","If a woman marries while under a vow or rash promise by which she has bound herself, ");
INSERT INTO engmsb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","and her husband hears of it but says nothing to her on that day, then the vows or pledges by which she has bound herself shall stand. ");
INSERT INTO engmsb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if her husband prohibits her when he hears of it, he nullifies the vow that binds her or the rash promise she has made, and the LORD will absolve her. ");
INSERT INTO engmsb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Every vow a widow or divorced woman pledges to fulfill is binding on her. ");
INSERT INTO engmsb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","If a woman in her husband’s house has made a vow or put herself under an obligation with an oath, ");
INSERT INTO engmsb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband hears of it but says nothing to her and does not prohibit her, then all the vows or pledges by which she has bound herself shall stand. ");
INSERT INTO engmsb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband nullifies them on the day he hears of them, then nothing that came from her lips, whether her vows or pledges, shall stand. Her husband has nullified them, and the LORD will absolve her. ");
INSERT INTO engmsb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Her husband may confirm or nullify any vow or any sworn pledge to deny herself. ");
INSERT INTO engmsb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if her husband says nothing to her from day to day, then he confirms all the vows and pledges that bind her. He has confirmed them, because he said nothing to her on the day he heard about them. ");
INSERT INTO engmsb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if he nullifies them after he hears of them, then he will bear her iniquity.” ");
INSERT INTO engmsb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the statutes that the LORD commanded Moses concerning the relationship between a man and his wife, and between a father and a young daughter still in his home. ");
INSERT INTO engmsb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","And the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Take vengeance on the Midianites for the Israelites. After that, you will be gathered to your people.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","So Moses told the people, “Arm some of your men for war, that they may go against the Midianites and execute the LORD’s vengeance on them. ");
INSERT INTO engmsb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Send into battle a thousand men from each tribe of Israel.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So a thousand men were recruited from each tribe of Israel—twelve thousand armed for war. ");
INSERT INTO engmsb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","And Moses sent the thousand from each tribe into battle, along with Phinehas son of Eleazar the priest, who took with him the vessels of the sanctuary and the trumpets for signaling. ");
INSERT INTO engmsb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Then they waged war against Midian, as the LORD had commanded Moses, and they killed every male. ");
INSERT INTO engmsb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Among the slain were Evi, Rekem, Zur, Hur, and Reba—the five kings of Midian. They also killed Balaam son of Beor with the sword. ");
INSERT INTO engmsb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The Israelites captured the Midianite women and their children, and they plundered all their herds, flocks, and goods. ");
INSERT INTO engmsb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Then they burned all the cities where the Midianites had lived, as well as all their encampments, ");
INSERT INTO engmsb_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","and carried away all the plunder and spoils, both people and animals. ");
INSERT INTO engmsb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","They brought the captives, spoils, and plunder to Moses, to Eleazar the priest, and to the congregation of Israel at the camp on the plains of Moab, by the Jordan across from Jericho. ");
INSERT INTO engmsb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","And Moses, Eleazar the priest, and all the leaders of the congregation went to meet them outside the camp. ");
INSERT INTO engmsb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","But Moses was angry with the officers of the army—the commanders of thousands and commanders of hundreds—who were returning from the battle. ");
INSERT INTO engmsb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“Have you spared all the women?” he asked them. ");
INSERT INTO engmsb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“Look, these women caused the sons of Israel, through the counsel of Balaam, to turn unfaithfully against the LORD at Peor, so that the plague struck the congregation of the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","So now, kill all the boys, as well as every woman who has had relations with a man, ");
INSERT INTO engmsb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","but spare for yourselves every girl who has never had relations with a man. ");
INSERT INTO engmsb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","All of you who have killed a person or touched the dead are to remain outside the camp for seven days. On the third day and the seventh day you are to purify both yourselves and your captives. ");
INSERT INTO engmsb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","And purify every garment and leather good, everything made of goat’s hair, and every article of wood.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Then Eleazar the priest said to the soldiers who had gone into battle, “This is the statute of the law which the LORD has commanded Moses: ");
INSERT INTO engmsb_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Only the gold, silver, bronze, iron, tin, and lead— ");
INSERT INTO engmsb_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","everything that can withstand the fire—must be put through the fire, and it will be clean. But it must still be purified with the water of purification. And everything that cannot withstand the fire must pass through the water. ");
INSERT INTO engmsb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","On the seventh day you are to wash your clothes, and you will be clean. After that you may enter the camp.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","The LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“You and Eleazar the priest and the family heads of the congregation are to take a count of what was captured, both of man and beast. ");
INSERT INTO engmsb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Then divide the captives between the troops who went out to battle and the rest of the congregation. ");
INSERT INTO engmsb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Set aside a tribute for the LORD from what belongs to the soldiers who went into battle: one out of every five hundred, whether persons, cattle, donkeys, or sheep. ");
INSERT INTO engmsb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take it from their half and give it to Eleazar the priest as an offering to the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","From the Israelites’ half, take one out of every fifty, whether persons, cattle, donkeys, sheep, or other animals, and give them to the Levites who keep charge of the tabernacle of the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","So Moses and Eleazar the priest did as the LORD had commanded Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","and this plunder remained from the spoils the soldiers had taken: 675,000 sheep, ");
INSERT INTO engmsb_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 cattle, ");
INSERT INTO engmsb_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 donkeys, ");
INSERT INTO engmsb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and 32,000 women who had not slept with a man. ");
INSERT INTO engmsb_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","This was the half portion for those who had gone to war: 337,500 sheep, ");
INSERT INTO engmsb_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","including a tribute to the LORD of 675, ");
INSERT INTO engmsb_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 cattle, including a tribute to the LORD of 72, ");
INSERT INTO engmsb_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 donkeys, including a tribute to the LORD of 61, ");
INSERT INTO engmsb_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","and 16,000 people, including a tribute to the LORD of 32. ");
INSERT INTO engmsb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses gave the tribute to Eleazar the priest as an offering for the LORD, as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","From the Israelites’ half, which Moses had set apart from the men who had gone to war, ");
INSERT INTO engmsb_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","this half belonged to the congregation: 337,500 sheep, ");
INSERT INTO engmsb_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 cattle, ");
INSERT INTO engmsb_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 donkeys, ");
INSERT INTO engmsb_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and 16,000 people. ");
INSERT INTO engmsb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","From the Israelites’ half, Moses took one out of every fifty persons and animals and gave them to the Levites who kept charge of the tabernacle of the LORD, as the LORD had commanded him. ");
INSERT INTO engmsb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Then the officers who were over the units of the army—the commanders of thousands and of hundreds—approached Moses ");
INSERT INTO engmsb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","and said, “Your servants have counted the soldiers under our command, and not one of us is missing. ");
INSERT INTO engmsb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","So we have brought to the LORD an offering of the gold articles each man acquired—armlets, bracelets, rings, earrings, and necklaces—to make atonement for ourselves before the LORD.” ");
INSERT INTO engmsb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","So Moses and Eleazar the priest received from them all the articles made out of gold. ");
INSERT INTO engmsb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","All the gold that the commanders of thousands and of hundreds presented as an offering to the LORD weighed 16,750 shekels. ");
INSERT INTO engmsb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Each of the soldiers had taken plunder for himself. ");
INSERT INTO engmsb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","And Moses and Eleazar the priest received the gold from the commanders of thousands and of hundreds and brought it into the Tent of Meeting as a memorial for the Israelites before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Now the Reubenites and Gadites, who had very large herds and flocks, surveyed the lands of Jazer and Gilead, and they saw that the region was suitable for livestock. ");
INSERT INTO engmsb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","So the Gadites and Reubenites came to Moses, Eleazar the priest, and the leaders of the congregation, and said, ");
INSERT INTO engmsb_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, and Beon, ");
INSERT INTO engmsb_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","which the LORD conquered before the congregation of Israel, are suitable for livestock—and your servants have livestock.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","“If we have found favor in your sight,” they said, “let this land be given to your servants as a possession. Do not make us cross the Jordan.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","But Moses asked the Gadites and Reubenites, “Shall your brothers go to war while you sit here? ");
INSERT INTO engmsb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why are you discouraging the Israelites from crossing into the land that the LORD has given them? ");
INSERT INTO engmsb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","This is what your fathers did when I sent them from Kadesh-barnea to inspect the land. ");
INSERT INTO engmsb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","For when your fathers went up to the Valley of Eshcol and saw the land, they discouraged the Israelites from entering the land that the LORD had given them. ");
INSERT INTO engmsb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","So the anger of the LORD was kindled that day, and He swore an oath, saying, ");
INSERT INTO engmsb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Because they did not follow Me wholeheartedly, not one of the men twenty years of age or older who came out of Egypt will see the land that I swore to give Abraham, Isaac, and Jacob— ");
INSERT INTO engmsb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","not one except Caleb son of Jephunneh the Kenizzite and Joshua son of Nun—because they did follow the LORD wholeheartedly.’ ");
INSERT INTO engmsb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","The anger of the LORD burned against Israel, and He made them wander in the wilderness forty years, until the whole generation who had done evil in His sight was gone. ");
INSERT INTO engmsb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Now behold, you, a brood of sinners, have risen up in place of your fathers to further stoke the burning anger of the LORD against Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","For if you turn away from following Him, He will once again leave this people in the wilderness, and you will be the cause of their destruction.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Then the Gadites and Reubenites approached Moses and said, “We want to build sheepfolds here for our livestock and cities for our little ones. ");
INSERT INTO engmsb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","But we will arm ourselves and be ready to go ahead of the Israelites until we have brought them into their place. Meanwhile, our little ones will remain in the fortified cities for protection from the inhabitants of the land. ");
INSERT INTO engmsb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not return to our homes until every Israelite has taken possession of his inheritance. ");
INSERT INTO engmsb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Yet we will not have an inheritance with them across the Jordan and beyond, because our inheritance has come to us on the east side of the Jordan.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moses replied, “If you will do this—if you will arm yourselves before the LORD for battle, ");
INSERT INTO engmsb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","and if every one of your armed men crosses the Jordan before the LORD, until He has driven His enemies out before Him, ");
INSERT INTO engmsb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","then when the land is subdued before the LORD, you may return and be free of obligation to the LORD and to Israel. And this land will belong to you as a possession before the LORD. ");
INSERT INTO engmsb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","But if you do not do this, you will certainly sin against the LORD—and be assured that your sin will find you out. ");
INSERT INTO engmsb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Build cities for your little ones and folds for your flocks, but do what you have promised.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","The Gadites and Reubenites said to Moses, “Your servants will do just as our lord commands. ");
INSERT INTO engmsb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our children, our wives, our livestock, and all our animals will remain here in the cities of Gilead. ");
INSERT INTO engmsb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","But your servants are equipped for war, and every man will cross over to the battle before the LORD, just as our lord says.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses gave orders about them to Eleazar the priest, to Joshua son of Nun, and to the family leaders of the tribes of Israel. ");
INSERT INTO engmsb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","And Moses said to them, “If the Gadites and Reubenites cross the Jordan with you, with every man armed for battle before the LORD, and the land is subdued before you, then you are to give them the land of Gilead as a possession. ");
INSERT INTO engmsb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they do not arm themselves and go across with you, then they must accept their possession among you in the land of Canaan.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","The Gadites and Reubenites replied, “As the LORD has spoken to your servants, so we will do. ");
INSERT INTO engmsb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will cross over into the land of Canaan armed before the LORD, that we may have our inheritance on this side of the Jordan.” ");
INSERT INTO engmsb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So Moses gave to the Gadites, to the Reubenites, and to the half-tribe of Manasseh son of Joseph the kingdom of Sihon king of the Amorites and the kingdom of Og king of Bashan—the land including its cities and the territory surrounding them. ");
INSERT INTO engmsb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","And the Gadites built up Dibon, Ataroth, Aroer, ");
INSERT INTO engmsb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-shophan, Jazer, Jogbehah, ");
INSERT INTO engmsb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth-nimrah, and Beth-haran as fortified cities, and they built folds for their flocks. ");
INSERT INTO engmsb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The Reubenites built up Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engmsb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","as well as Nebo and Baal-meon (whose names were changed), and Sibmah. And they renamed the cities they rebuilt. ");
INSERT INTO engmsb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","The descendants of Machir son of Manasseh went to Gilead, captured it, and drove out the Amorites who were there. ");
INSERT INTO engmsb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","So Moses gave Gilead to the clan of Machir son of Manasseh, and they settled there. ");
INSERT INTO engmsb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, a descendant of Manasseh, went and captured their villages and called them Havvoth-jair. ");
INSERT INTO engmsb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","And Nobah went and captured Kenath and its villages and called it Nobah, after his own name. ");
INSERT INTO engmsb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","These are the journeys of the Israelites when they came out of the land of Egypt by their divisions under the leadership of Moses and Aaron. ");
INSERT INTO engmsb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","At the LORD’s command, Moses recorded the stages of their journey. These are the stages listed by their starting points: ");
INSERT INTO engmsb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","On the fifteenth day of the first month, on the day after the Passover, the Israelites set out from Rameses. They marched out defiantly in full view of all the Egyptians, ");
INSERT INTO engmsb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","who were burying all their firstborn, whom the LORD had struck down among them; for the LORD had executed judgment against their gods. ");
INSERT INTO engmsb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The Israelites set out from Rameses and camped at Succoth. ");
INSERT INTO engmsb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","They set out from Succoth and camped at Etham, on the edge of the wilderness. ");
INSERT INTO engmsb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","They set out from Etham and turned back to Pi-hahiroth, opposite Baal-zephon, and they camped near Migdol. ");
INSERT INTO engmsb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","They set out from Pi-hahiroth and crossed through the sea, into the wilderness, and they journeyed three days into the Wilderness of Etham and camped at Marah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","They set out from Marah and came to Elim, where there were twelve springs and seventy palm trees, and they camped there. ");
INSERT INTO engmsb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","They set out from Elim and camped by the Red Sea. ");
INSERT INTO engmsb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","They set out from the Red Sea and camped in the Desert of Sin. ");
INSERT INTO engmsb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","They set out from the Desert of Sin and camped at Dophkah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","They set out from Dophkah and camped at Alush. ");
INSERT INTO engmsb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","They set out from Alush and camped at Rephidim, where there was no water for the people to drink. ");
INSERT INTO engmsb_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","They set out from Rephidim and camped in the Wilderness of Sinai. ");
INSERT INTO engmsb_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","They set out from the Wilderness of Sinai and camped at Kibroth-hattaavah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","They set out from Kibroth-hattaavah and camped at Hazeroth. ");
INSERT INTO engmsb_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","They set out from Hazeroth and camped at Rithmah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","They set out from Rithmah and camped at Rimmon-perez. ");
INSERT INTO engmsb_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","They set out from Rimmon-perez and camped at Libnah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","They set out from Libnah and camped at Rissah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","They set out from Rissah and camped at Kehelathah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","They set out from Kehelathah and camped at Mount Shepher. ");
INSERT INTO engmsb_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","They set out from Mount Shepher and camped at Haradah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","They set out from Haradah and camped at Makheloth. ");
INSERT INTO engmsb_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","They set out from Makheloth and camped at Tahath. ");
INSERT INTO engmsb_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","They set out from Tahath and camped at Terah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","They set out from Terah and camped at Mithkah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","They set out from Mithkah and camped at Hashmonah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","They set out from Hashmonah and camped at Moseroth. ");
INSERT INTO engmsb_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","They set out from Moseroth and camped at Bene-jaakan. ");
INSERT INTO engmsb_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","They set out from Bene-jaakan and camped at Hor-haggidgad. ");
INSERT INTO engmsb_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","They set out from Hor-haggidgad and camped at Jotbathah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","They set out from Jotbathah and camped at Abronah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","They set out from Abronah and camped at Ezion-geber. ");
INSERT INTO engmsb_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","They set out from Ezion-geber and camped at Kadesh in the Wilderness of Zin. ");
INSERT INTO engmsb_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","They set out from Kadesh and camped at Mount Hor, on the outskirts of the land of Edom. ");
INSERT INTO engmsb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","At the LORD’s command, Aaron the priest climbed Mount Hor and died there on the first day of the fifth month, in the fortieth year after the Israelites had come out of the land of Egypt. ");
INSERT INTO engmsb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron was 123 years old when he died on Mount Hor. ");
INSERT INTO engmsb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Now the Canaanite king of Arad, who lived in the Negev in the land of Canaan, heard that the Israelites were coming. ");
INSERT INTO engmsb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","And the Israelites set out from Mount Hor and camped at Zalmonah. ");
INSERT INTO engmsb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","They set out from Zalmonah and camped at Punon. ");
INSERT INTO engmsb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","They set out from Punon and camped at Oboth. ");
INSERT INTO engmsb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","They set out from Oboth and camped at Iye-abarim on the border of Moab. ");
INSERT INTO engmsb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","They set out from Iyim and camped at Dibon-gad. ");
INSERT INTO engmsb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","They set out from Dibon-gad and camped at Almon-diblathaim. ");
INSERT INTO engmsb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","They set out from Almon-diblathaim and camped in the mountains of Abarim facing Nebo. ");
INSERT INTO engmsb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","They set out from the mountains of Abarim and camped on the plains of Moab by the Jordan across from Jericho. ");
INSERT INTO engmsb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","And there on the plains of Moab they camped by the Jordan, from Beth-jeshimoth to Abel-shittim. ");
INSERT INTO engmsb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","On the plains of Moab by the Jordan across from Jericho, the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Speak to the Israelites and tell them: When you cross the Jordan into the land of Canaan, ");
INSERT INTO engmsb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","you must drive out before you all the inhabitants of the land, destroy all their carved images and cast idols, and demolish all their high places. ");
INSERT INTO engmsb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","You are to take possession of the land and settle in it, for I have given you the land to possess. ");
INSERT INTO engmsb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","And you are to divide the land by lot according to your clans. Give a larger inheritance to a larger clan and a smaller inheritance to a smaller one. Whatever falls to each one by lot will be his. You will receive an inheritance according to the tribes of your fathers. ");
INSERT INTO engmsb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","But if you do not drive out the inhabitants of the land before you, those you allow to remain will become barbs in your eyes and thorns in your sides; they will harass you in the land where you settle. ");
INSERT INTO engmsb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","And then I will do to you what I had planned to do to them.” ");
INSERT INTO engmsb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Command the Israelites and say to them: When you enter the land of Canaan, it will be allotted to you as an inheritance with these boundaries: ");
INSERT INTO engmsb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Your southern border will extend from the Wilderness of Zin along the border of Edom. On the east, your southern border will run from the end of the Salt Sea, ");
INSERT INTO engmsb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","cross south of the Ascent of Akrabbim, continue to Zin, and go south of Kadesh-barnea. Then it will go on to Hazar-addar and proceed to Azmon, ");
INSERT INTO engmsb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","where it will turn from Azmon, join the Brook of Egypt, and end at the Sea. ");
INSERT INTO engmsb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Your western border will be the coastline of the Great Sea; this will be your boundary on the west. ");
INSERT INTO engmsb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Your northern border will run from the Great Sea directly to Mount Hor, ");
INSERT INTO engmsb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","and from Mount Hor to Lebo-hamath, then extend to Zedad, ");
INSERT INTO engmsb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","continue to Ziphron, and end at Hazar-enan. This will be your boundary on the north. ");
INSERT INTO engmsb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","And your eastern border will run straight from Hazar-enan to Shepham, ");
INSERT INTO engmsb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","then go down from Shepham to Riblah on the east side of Ain and continue along the slopes east of the Sea of Chinnereth. ");
INSERT INTO engmsb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Then the border will go down along the Jordan and end at the Salt Sea. This will be your land, defined by its borders on all sides.” ");
INSERT INTO engmsb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","So Moses commanded the Israelites, “Apportion this land by lot as an inheritance. The LORD has commanded that it be given to the nine and a half tribes. ");
INSERT INTO engmsb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","For the tribes of the Reubenites and Gadites, along with the half-tribe of Manasseh, have already received their inheritance. ");
INSERT INTO engmsb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","These two and a half tribes have received their inheritance across the Jordan from Jericho, toward the sunrise.” ");
INSERT INTO engmsb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“These are the names of the men who are to assign the land as an inheritance for you: Eleazar the priest and Joshua son of Nun. ");
INSERT INTO engmsb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Appoint one leader from each tribe to distribute the land. ");
INSERT INTO engmsb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","These are their names: Caleb son of Jephunneh from the tribe of Judah; ");
INSERT INTO engmsb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Shemuel son of Ammihud from the tribe of Simeon; ");
INSERT INTO engmsb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad son of Chislon from the tribe of Benjamin; ");
INSERT INTO engmsb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Bukki son of Jogli, a leader from the tribe of Dan; ");
INSERT INTO engmsb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanniel son of Ephod, a leader from the tribe of Manasseh son of Joseph; ");
INSERT INTO engmsb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemuel son of Shiphtan, a leader from the tribe of Ephraim; ");
INSERT INTO engmsb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Eli-zaphan son of Parnach, a leader from the tribe of Zebulun; ");
INSERT INTO engmsb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltiel son of Azzan, a leader from the tribe of Issachar; ");
INSERT INTO engmsb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihud son of Shelomi, a leader from the tribe of Asher; ");
INSERT INTO engmsb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","and Pedahel son of Ammihud, a leader from the tribe of Naphtali.” ");
INSERT INTO engmsb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","These are the ones whom the LORD commanded to apportion the inheritance to the Israelites in the land of Canaan. ");
INSERT INTO engmsb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Again the LORD spoke to Moses on the plains of Moab by the Jordan across from Jericho: ");
INSERT INTO engmsb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Command the Israelites to give, from the inheritance they will possess, cities for the Levites to live in and pasturelands around the cities. ");
INSERT INTO engmsb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","The cities will be for them to live in, and the pasturelands will be for their herds, their flocks, and all their other livestock. ");
INSERT INTO engmsb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","The pasturelands around the cities you are to give the Levites will extend a thousand cubits from the wall on every side. ");
INSERT INTO engmsb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","You are also to measure two thousand cubits outside the city on the east, two thousand on the south, two thousand on the west, and two thousand on the north, with the city in the center. These areas will serve as larger pasturelands for the cities. ");
INSERT INTO engmsb_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Six of the cities you give the Levites are to be appointed as cities of refuge, to which a manslayer may flee. In addition to these, give the Levites forty-two other cities. ");
INSERT INTO engmsb_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","The total number of cities you give the Levites will be forty-eight, with their corresponding pasturelands. ");
INSERT INTO engmsb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","The cities that you apportion from the territory of the Israelites should be given to the Levites in proportion to the inheritance of each tribe: more from a larger tribe and less from a smaller one.” ");
INSERT INTO engmsb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Then the LORD said to Moses, ");
INSERT INTO engmsb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Speak to the Israelites and tell them: When you cross the Jordan into the land of Canaan, ");
INSERT INTO engmsb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","designate cities to serve as your cities of refuge, so that a person who kills someone unintentionally may flee there. ");
INSERT INTO engmsb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","You are to have these cities as a refuge from the avenger, so that the manslayer will not die until he stands trial before the assembly. ");
INSERT INTO engmsb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","The cities you select will be your six cities of refuge. ");
INSERT INTO engmsb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Select three cities across the Jordan and three in the land of Canaan as cities of refuge. ");
INSERT INTO engmsb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","These six cities will serve as a refuge for the Israelites and for the foreigner or stranger among them, so that anyone who kills a person unintentionally may flee there. ");
INSERT INTO engmsb_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","If, however, anyone strikes a person with an iron object and kills him, he is a murderer; the murderer must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Or if anyone has in his hand a stone of deadly size, and he strikes and kills another, he is a murderer; the murderer must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","If anyone has in his hand a deadly object of wood, and he strikes and kills another, he is a murderer; the murderer must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","The avenger of blood is to put the murderer to death; when he finds him, he is to kill him. ");
INSERT INTO engmsb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Likewise, if anyone maliciously pushes another or intentionally throws an object at him and kills him, ");
INSERT INTO engmsb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","or if in hostility he strikes him with his hand and he dies, the one who struck him must surely be put to death; he is a murderer. When the avenger of blood finds the murderer, he is to kill him. ");
INSERT INTO engmsb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","But if anyone pushes a person suddenly, without hostility, or throws an object at him unintentionally, ");
INSERT INTO engmsb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","or without looking drops a heavy stone that kills him, but he was not an enemy and did not intend to harm him, ");
INSERT INTO engmsb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","then the congregation must judge between the slayer and the avenger of blood according to these ordinances. ");
INSERT INTO engmsb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","The assembly is to protect the manslayer from the hand of the avenger of blood. Then the assembly will return him to the city of refuge to which he fled, and he must live there until the death of the high priest, who was anointed with the holy oil. ");
INSERT INTO engmsb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","But if the manslayer ever goes outside the limits of the city of refuge to which he fled ");
INSERT INTO engmsb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","and the avenger of blood finds him outside of his city of refuge and kills him, then the avenger will not be guilty of bloodshed, ");
INSERT INTO engmsb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","because the manslayer must remain in his city of refuge until the death of the high priest. Only after the death of the high priest may he return to the land he owns. ");
INSERT INTO engmsb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","This will be a statutory ordinance for you for the generations to come, wherever you live. ");
INSERT INTO engmsb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","If anyone kills a person, the murderer is to be put to death on the testimony of the witnesses. But no one is to be put to death based on the testimony of a lone witness. ");
INSERT INTO engmsb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","You are not to accept a ransom for the life of a murderer who deserves to die; he must surely be put to death. ");
INSERT INTO engmsb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Nor should you accept a ransom for the person who flees to a city of refuge and allow him to return and live on his own land before the death of the high priest. ");
INSERT INTO engmsb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Do not pollute the land where you live, for bloodshed pollutes the land, and no atonement can be made for the land on which the blood is shed, except by the blood of the one who shed it. ");
INSERT INTO engmsb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Do not defile the land where you live and where I dwell. For I, the LORD, dwell among the Israelites.” ");
INSERT INTO engmsb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Now the family heads of the clan of Gilead son of Machir son of Manasseh, one of the clans of Joseph, approached Moses and the leaders who were the heads of the Israelite families and addressed them, ");
INSERT INTO engmsb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","saying, “When the LORD commanded my lord to give the land as an inheritance to the Israelites by lot, He also commanded him to give the inheritance of our brother Zelophehad to his daughters. ");
INSERT INTO engmsb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","But if they marry any of the men from the other tribes of Israel, their inheritance will be withdrawn from the portion of our fathers and added to the tribe into which they marry. So our allotted inheritance would be taken away. ");
INSERT INTO engmsb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","And when the Jubilee for the Israelites comes, their inheritance will be added to the tribe into which they marry and taken away from the tribe of our fathers.” ");
INSERT INTO engmsb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","So at the word of the LORD, Moses commanded the Israelites: “The tribe of the sons of Joseph speaks correctly. ");
INSERT INTO engmsb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","This is what the LORD has commanded concerning the daughters of Zelophehad: They may marry anyone they please, provided they marry within a clan of the tribe of their father. ");
INSERT INTO engmsb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","No inheritance in Israel may be transferred from tribe to tribe, because each of the Israelites is to retain the inheritance of the tribe of his fathers. ");
INSERT INTO engmsb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Every daughter who possesses an inheritance from any Israelite tribe must marry within a clan of the tribe of her father, so that every Israelite will possess the inheritance of his fathers. ");
INSERT INTO engmsb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","No inheritance may be transferred from one tribe to another, for each tribe of Israel must retain its inheritance.” ");
INSERT INTO engmsb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","So the daughters of Zelophehad did as the LORD had commanded Moses. ");
INSERT INTO engmsb_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahlah, Tirzah, Hoglah, Milcah, and Noah, the daughters of Zelophehad, were married to cousins on their father’s side. ");
INSERT INTO engmsb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","They married within the clans of the descendants of Manasseh son of Joseph, and their inheritance remained within the tribe of their father’s clan. ");
INSERT INTO engmsb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","These are the commandments and ordinances that the LORD gave the Israelites through Moses on the plains of Moab by the Jordan across from Jericho. ");
INSERT INTO engmsb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","These are the words that Moses spoke to all Israel in the wilderness east of the Jordan—in the Arabah opposite Suph—between Paran and Tophel, Laban, Hazeroth, and Dizahab. ");
INSERT INTO engmsb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","It is an eleven-day journey from Horeb to Kadesh-barnea by way of Mount Seir. ");
INSERT INTO engmsb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","In the fortieth year, on the first day of the eleventh month, Moses proclaimed to the Israelites all that the LORD had commanded him concerning them. ");
INSERT INTO engmsb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","This was after he had defeated Sihon king of the Amorites, who lived in Heshbon, and then at Edrei had defeated Og king of Bashan, who lived in Ashtaroth. ");
INSERT INTO engmsb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","On the east side of the Jordan in the land of Moab, Moses began to explain this law, saying: ");
INSERT INTO engmsb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","The LORD our God said to us at Horeb: “You have stayed at this mountain long enough. ");
INSERT INTO engmsb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Resume your journey and go to the hill country of the Amorites; go to all the neighboring peoples in the Arabah, in the hill country, in the foothills, in the Negev, and along the seacoast to the land of the Canaanites and to Lebanon, as far as the great River Euphrates. ");
INSERT INTO engmsb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","See, I have placed the land before you. Enter and possess the land that the LORD swore He would give to your fathers Abraham, Isaac, and Jacob, and to their descendants after them.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","At that time I said to you, “I cannot carry the burden for you alone. ");
INSERT INTO engmsb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","The LORD your God has multiplied you, so that today you are as numerous as the stars in the sky. ");
INSERT INTO engmsb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","May the LORD, the God of your fathers, increase you a thousand times over and bless you as He has promised. ");
INSERT INTO engmsb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","But how can I bear your troubles, burdens, and disputes all by myself? ");
INSERT INTO engmsb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Choose for yourselves wise, understanding, and respected men from each of your tribes, and I will appoint them as your leaders.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","And you answered me and said, “What you propose to do is good.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","So I took the leaders of your tribes, wise and respected men, and appointed them as leaders over you—as commanders of thousands, of hundreds, of fifties, and of tens, and as officers for your tribes. ");
INSERT INTO engmsb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","At that time I charged your judges: “Hear the disputes between your brothers, and judge fairly between a man and his brother or a foreign resident. ");
INSERT INTO engmsb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Show no partiality in judging; hear both small and great alike. Do not be intimidated by anyone, for judgment belongs to God. And bring to me any case too difficult for you, and I will hear it.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","And at that time I commanded you all the things you were to do. ");
INSERT INTO engmsb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","And just as the LORD our God had commanded us, we set out from Horeb and went toward the hill country of the Amorites, through all the vast and terrifying wilderness you have seen. When we reached Kadesh-barnea, ");
INSERT INTO engmsb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","I said: “You have reached the hill country of the Amorites, which the LORD our God is giving us. ");
INSERT INTO engmsb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","See, the LORD your God has placed the land before you. Go up and take possession of it as the LORD, the God of your fathers, has told you. Do not be afraid or discouraged.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Then all of you approached me and said, “Let us send men ahead of us to search out the land and bring us word of what route to follow and which cities to enter.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","The plan seemed good to me, so I selected twelve men from among you, one from each tribe. ");
INSERT INTO engmsb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","They left and went up into the hill country, and came to the Valley of Eshcol and spied out the land. ");
INSERT INTO engmsb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","They took some of the fruit of the land in their hands, carried it down to us, and brought us word: “It is a good land that the LORD our God is giving us.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","But you were unwilling to go up; you rebelled against the command of the LORD your God. ");
INSERT INTO engmsb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","You grumbled in your tents and said, “Because the LORD hates us, He has brought us out of the land of Egypt to deliver us into the hand of the Amorites to be annihilated. ");
INSERT INTO engmsb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Where can we go? Our brothers have made our hearts melt, saying: ‘The people are larger and taller than we are; the cities are large, with walls up to the heavens. We even saw the descendants of the Anakim there.’” ");
INSERT INTO engmsb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","So I said to you: “Do not be terrified or afraid of them! ");
INSERT INTO engmsb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","The LORD your God, who goes before you, will fight for you, just as you saw Him do for you in Egypt ");
INSERT INTO engmsb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","and in the wilderness, where the LORD your God carried you, as a man carries his son, all the way by which you traveled until you reached this place.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","But in spite of all this, you did not trust the LORD your God, ");
INSERT INTO engmsb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","who went before you on the journey, in the fire by night and in the cloud by day, to seek out a place for you to camp and to show you the road to travel. ");
INSERT INTO engmsb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","When the LORD heard your words, He grew angry and swore an oath, saying, ");
INSERT INTO engmsb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Not one of the men of this evil generation shall see the good land I swore to give your fathers, ");
INSERT INTO engmsb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","except Caleb son of Jephunneh. He will see it, and I will give him and his descendants the land on which he has set foot, because he followed the LORD wholeheartedly.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","The LORD was also angry with me on your account, and He said, “Not even you shall enter the land. ");
INSERT INTO engmsb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Joshua son of Nun, who stands before you, will enter it. Encourage him, for he will enable Israel to inherit the land. ");
INSERT INTO engmsb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","And the little ones you said would become captives—your children who on that day did not know good from evil—will enter the land that I will give them, and they will possess it. ");
INSERT INTO engmsb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","But you are to turn back and head for the wilderness along the route to the Red Sea.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“We have sinned against the LORD,” you replied. “We will go up and fight, as the LORD our God has commanded us.” Then each of you put on his weapons of war, thinking it easy to go up into the hill country. ");
INSERT INTO engmsb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","But the LORD said to me, “Tell them not to go up and fight, for I am not with you to keep you from defeat by your enemies.” ");
INSERT INTO engmsb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","So I spoke to you, but you would not listen. You rebelled against the command of the LORD and presumptuously went up into the hill country. ");
INSERT INTO engmsb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Then the Amorites who lived in the hills came out against you and chased you like a swarm of bees. They routed you from Seir all the way to Hormah. ");
INSERT INTO engmsb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","And you returned and wept before the LORD, but He would not listen to your voice or give ear to you. ");
INSERT INTO engmsb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","For this reason you stayed in Kadesh for a long time—a very long time. ");
INSERT INTO engmsb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Then we turned back and headed for the wilderness by way of the Red Sea, as the LORD had instructed me, and for many days we wandered around Mount Seir. ");
INSERT INTO engmsb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","At this time the LORD said to me, ");
INSERT INTO engmsb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“You have been wandering around this hill country long enough; turn to the north ");
INSERT INTO engmsb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","and command the people: ‘You will pass through the territory of your brothers, the descendants of Esau, who live in Seir. They will be afraid of you, so you must be very careful. ");
INSERT INTO engmsb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Do not provoke them, for I will not give you any of their land, not even a footprint, because I have given Mount Seir to Esau as his possession. ");
INSERT INTO engmsb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","You are to pay them in silver for the food you eat and the water you drink.’” ");
INSERT INTO engmsb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Indeed, the LORD your God has blessed you in all the work of your hands. He has watched over your journey through this vast wilderness. The LORD your God has been with you these forty years, and you have lacked nothing. ");
INSERT INTO engmsb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","So we passed by our brothers, the descendants of Esau, who live in Seir. We turned away from the Arabah road, which comes up from Elath and Ezion-geber, and traveled along the road of the Wilderness of Moab. ");
INSERT INTO engmsb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Then the LORD said to me, “Do not harass the Moabites or provoke them to war, for I will not give you any of their land, because I have given Ar to the descendants of Lot as their possession.” ");
INSERT INTO engmsb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(The Emites used to live there, a people great and many, as tall as the Anakites. ");
INSERT INTO engmsb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Like the Anakites, they were also regarded as Rephaim, though the Moabites called them Emites. ");
INSERT INTO engmsb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","The Horites used to live in Seir, but the descendants of Esau drove them out. They destroyed the Horites from before them and settled in their place, just as Israel did in the land that the LORD gave them as their possession.) ");
INSERT INTO engmsb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Now arise and cross over the Brook of Zered.” So we crossed over the Brook of Zered. ");
INSERT INTO engmsb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","The time we spent traveling from Kadesh-barnea until we crossed over the Brook of Zered was thirty-eight years, until that entire generation of fighting men had perished from the camp, as the LORD had sworn to them. ");
INSERT INTO engmsb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Indeed, the LORD’s hand was against them, to eliminate them from the camp, until they had all perished. ");
INSERT INTO engmsb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Now when all the fighting men among the people had died, ");
INSERT INTO engmsb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","the LORD said to me, ");
INSERT INTO engmsb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Today you are going to cross the border of Moab at Ar. ");
INSERT INTO engmsb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","But when you get close to the Ammonites, do not harass them or provoke them, for I will not give you any of the land of the Ammonites. I have given it to the descendants of Lot as their possession.” ");
INSERT INTO engmsb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(That too was regarded as the land of the Rephaim, who used to live there, though the Ammonites called them Zamzummites. ");
INSERT INTO engmsb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","They were a people great and many, as tall as the Anakites. But the LORD destroyed them from before the Ammonites, who drove them out and settled in their place, ");
INSERT INTO engmsb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","just as He had done for the descendants of Esau who lived in Seir, when He destroyed the Horites from before them. They drove them out and have lived in their place to this day. ");
INSERT INTO engmsb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","And the Avvim, who lived in villages as far as Gaza, were destroyed by the Caphtorites, who came out of Caphtor and settled in their place.) ");
INSERT INTO engmsb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Arise, set out, and cross the Arnon Valley. See, I have delivered into your hand Sihon the Amorite, king of Heshbon, and his land. Begin to take possession of it and engage him in battle. ");
INSERT INTO engmsb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","This very day I will begin to put the dread and fear of you upon all the nations under heaven. They will hear the reports of you and tremble in anguish because of you.” ");
INSERT INTO engmsb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","So from the Wilderness of Kedemoth I sent messengers with an offer of peace to Sihon king of Heshbon, saying, ");
INSERT INTO engmsb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Let us pass through your land; we will stay on the main road. We will not turn to the right or to the left. ");
INSERT INTO engmsb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","You can sell us food to eat and water to drink in exchange for silver. Only let us pass through on foot, ");
INSERT INTO engmsb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","just as the descendants of Esau who live in Seir and the Moabites who live in Ar did for us, until we cross the Jordan into the land that the LORD our God is giving us.” ");
INSERT INTO engmsb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","But Sihon king of Heshbon would not let us pass through, for the LORD your God had made his spirit stubborn and his heart obstinate, that He might deliver him into your hand, as is the case this day. ");
INSERT INTO engmsb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Then the LORD said to me, “See, I have begun to deliver Sihon and his land over to you. Now begin to conquer and possess his land.” ");
INSERT INTO engmsb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","So Sihon and his whole army came out for battle against us at Jahaz. ");
INSERT INTO engmsb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","And the LORD our God delivered him over to us, and we defeated him and his sons and his whole army. ");
INSERT INTO engmsb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","At that time we captured all his cities and devoted to destruction the people of every city, including women and children. We left no survivors. ");
INSERT INTO engmsb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","We carried off for ourselves only the livestock and the plunder from the cities we captured. ");
INSERT INTO engmsb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","From Aroer on the rim of the Arnon Valley, along with the city in the valley, even as far as Gilead, not one city had walls too high for us. The LORD our God gave us all of them. ");
INSERT INTO engmsb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","But you did not go near the land of the Ammonites, or the land along the banks of the Jabbok River, or the cities of the hill country, or any place that the LORD our God had forbidden. ");
INSERT INTO engmsb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Then we turned and went up the road to Bashan, and Og king of Bashan and his whole army came out to meet us in battle at Edrei. ");
INSERT INTO engmsb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","But the LORD said to me, “Do not fear him, for I have delivered him into your hand, along with all his people and his land. Do to him as you did to Sihon king of the Amorites, who lived in Heshbon.” ");
INSERT INTO engmsb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","So the LORD our God also delivered Og king of Bashan and his whole army into our hands. We struck them down until no survivor was left. ");
INSERT INTO engmsb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","At that time we captured all sixty of his cities. There was not a single city we failed to take—the entire region of Argob, the kingdom of Og in Bashan. ");
INSERT INTO engmsb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","All these cities were fortified with high walls and gates and bars, and there were many more unwalled villages. ");
INSERT INTO engmsb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","We devoted them to destruction, as we had done to Sihon king of Heshbon, utterly destroying the men, women, and children of every city. ");
INSERT INTO engmsb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","But all the livestock and plunder of the cities we carried off for ourselves. ");
INSERT INTO engmsb_vpl VALUES ("DT3_8","006_3_8","DE