﻿USE sofia;
DROP TABLE IF EXISTS sofia.engfbv_vpl;
CREATE TABLE engfbv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engfbv_vpl WRITE;
INSERT INTO engfbv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","In the beginning God created the heavens and the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","The earth was formless and empty, and darkness covered the surface of the deep. The Spirit of God moved over the surface of the waters. ");
INSERT INTO engfbv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","God said, “Let there be light!” and there was light. ");
INSERT INTO engfbv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God saw that the light was good, and he separated the light from the darkness. ");
INSERT INTO engfbv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God called the light “day,” and he called the darkness “night.” So there was evening, and then the morning, making day one. ");
INSERT INTO engfbv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God said, “Let there be an expanse in the middle of the waters to divide the waters.” ");
INSERT INTO engfbv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","So God made an expanse to divide the waters that were above from the waters that were below. And that's what happened. ");
INSERT INTO engfbv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God called the expanse, “sky.” So there was evening, and then the morning, making day two. ");
INSERT INTO engfbv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God said, “Let the waters below the sky collect together in one place so that the land may appear.” And so it was. ");
INSERT INTO engfbv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God called the land “earth” and the waters “seas.” God saw that it was good. ");
INSERT INTO engfbv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God said, “Let the earth produce vegetation—plants that produce seeds and trees that produce seeded fruit—each one according to its own kind.” And that's what happened. ");
INSERT INTO engfbv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The earth produced vegetation—plants that produce seeds and trees that produce seeded fruit—each one according to its own kind. God saw that it was good. ");
INSERT INTO engfbv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","So there was evening, and then the morning, making day three. ");
INSERT INTO engfbv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God said, “Let there be lights in the sky to separate day from night, and to provide a way to mark seasons, days, and years. ");
INSERT INTO engfbv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","They shall be lights in the sky to shine on the earth.” And that's what happened. ");
INSERT INTO engfbv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God created two great lights: the larger one in charge of the day, and the smaller one in charge of the night. He created the stars too. ");
INSERT INTO engfbv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God placed these lights in the sky to shine upon the earth, ");
INSERT INTO engfbv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","to be in charge of the day and in charge of the night, and to separate light from darkness. God saw that it was good. ");
INSERT INTO engfbv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","So there was evening, and then the morning, making day four. ");
INSERT INTO engfbv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God said, “Let the waters be full of living creatures, and let birds fly above the earth in the sky.” ");
INSERT INTO engfbv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","So God created huge sea creatures and all the living things that swim and fill the waters, each one according to its own kind; and every bird that flies, each one according to its own kind. God saw that it was good. ");
INSERT INTO engfbv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed them and said, “Reproduce and increase, and fill the waters of the seas, and let the birds increase on the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","So there was evening, and then the morning, making day five. ");
INSERT INTO engfbv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God said, “Let the land produce living creatures, each one according to its own kind—the livestock, the creatures that run along the ground, and the wild animals, each one according to its own kind.” And that's what happened. ");
INSERT INTO engfbv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God made the wild animals, the livestock, and the creatures that run along the ground, all according to their own kind. God saw that it was good. ");
INSERT INTO engfbv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","God said, “Let us make human beings in our image who are like us. They will have authority over the fish of the sea and the birds of the air, over the livestock, and over the whole of the earth and every creature that moves on it.” ");
INSERT INTO engfbv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So God created human beings in his own image. He created them in the image of God. He created them male and female. ");
INSERT INTO engfbv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them and told them, “Reproduce, increase, and spread throughout the earth and control it; exercise authority over the fish of the sea and the birds of the air and every creature that moves on the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God said, “Look, I'm giving you as your food every seed-bearing plant anywhere on earth, and every tree that produces fruit with seeds. ");
INSERT INTO engfbv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","I'm giving all the green plants to all the land animals, to the birds, and to every creature that moves on the earth—to every living thing.” And that's what happened. ");
INSERT INTO engfbv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God saw everything that he had created, and yes, it was very good. So there was evening, and then the morning, making day six. ");
INSERT INTO engfbv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","The creation of the heavens, the earth, and everything in them was complete. ");
INSERT INTO engfbv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","By the time the seventh day came, God had finished the work he'd done, and he rested on the seventh day from all the work he'd been doing. ");
INSERT INTO engfbv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed the seventh day, and set it apart as holy, because he rested from all the work he'd done in creation. ");
INSERT INTO engfbv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This is the account of the Lord God's creation when he made the heavens and the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Up to this point there were no wild plants or crops growing on the earth, because the Lord God hadn't sent rain, and there was no one to cultivate the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Dew came up from the earth and made the whole surface of the ground wet. ");
INSERT INTO engfbv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","The Lord God shaped the man Adam from the dust of the ground. He breathed into his nostrils the breath of life, and Adam became a living being. ");
INSERT INTO engfbv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","The Lord planted a garden in Eden, in the east. There he put the man Adam he had created. ");
INSERT INTO engfbv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","The Lord God made all kinds of trees grow in the garden, beautiful trees and trees producing fruit that's good to eat. The tree of life was in the middle of the garden, along with the tree of the knowledge of good and evil. ");
INSERT INTO engfbv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river flowed out from Eden to water the garden. From there it split into four branches. ");
INSERT INTO engfbv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The first branch was called the Pishon and it flowed through the whole land of Havilah, where gold is found. ");
INSERT INTO engfbv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(The gold from that land is pure. Bdellium and onyx stone are also found there.) ");
INSERT INTO engfbv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The second branch was called the Gihon and it flowed through the whole land of Cush. ");
INSERT INTO engfbv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The third branch was called the Tigris and it flowed east of the city of Asshur. The fourth branch was called the Euphrates. ");
INSERT INTO engfbv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","The Lord God put the man in the Garden of Eden to cultivate it and care for it. ");
INSERT INTO engfbv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","The Lord God ordered Adam, “You are free to eat fruit from every tree in the garden, ");
INSERT INTO engfbv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","but you must not eat from the tree of the knowledge of good and evil, because the day you eat from it you are certain to die.” ");
INSERT INTO engfbv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Then the Lord God said, “It's not good for Adam to be alone. I will make someone to help him, someone that's like him.” ");
INSERT INTO engfbv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","The Lord God used the ground to make all the wild animals, and all the birds. He took them all to Adam to see what he would call them, and Adam named every living creature. ");
INSERT INTO engfbv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Adam gave names to all the livestock, all the birds, and all the wild animals. But Adam didn't find anyone like him who could help him. ");
INSERT INTO engfbv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So the Lord God put Adam into a deep sleep and as he slept the Lord God removed one of Adam's ribs and closed up the place where he took it with body tissue. ");
INSERT INTO engfbv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","The Lord God made a woman, using the rib he'd taken from Adam, and presented her to Adam. ");
INSERT INTO engfbv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","“Finally!” said Adam. “Here is bone from my bone and flesh from my flesh. She shall be called woman, because she was taken out of man.” ");
INSERT INTO engfbv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","This is the reason a man leaves his father and mother and is joined to his wife, and the two become one being. ");
INSERT INTO engfbv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Adam and his wife Eve were both naked, but they weren't embarrassed about it. ");
INSERT INTO engfbv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","The serpent was more cunning than any of the other wild animals that the Lord God had made. He asked Eve, “Did God really say that you can't eat fruit from every tree in the garden?” ");
INSERT INTO engfbv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Eve replied to the serpent, “We can eat from the trees in the garden, but not the fruit from the tree in the middle of the garden. ");
INSERT INTO engfbv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","God told us, ‘You mustn't eat from that tree, or even touch it, otherwise you'll die.’” ");
INSERT INTO engfbv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“You certainly won't die,” the serpent told Eve. ");
INSERT INTO engfbv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“It's because God knows that as soon as you eat it, you'll see things differently, and you'll be like God, knowing both what is good and what is evil.” ");
INSERT INTO engfbv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eve saw that the fruit of the tree appeared good to eat. It looked very attractive. She really wanted it so she could become wise. So she took some of its fruit and ate it, and she gave some to her husband, who was with her, and he ate it too. ");
INSERT INTO engfbv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Immediately they saw everything differently and realized they were naked. So they sewed fig leaves together to cover themselves up. ");
INSERT INTO engfbv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Later they heard the Lord walking in the garden in the evening when the breeze was blowing. Adam and Eve went and hid out of sight of the Lord God among the trees of the garden. ");
INSERT INTO engfbv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","The Lord God called out to Adam, “Where are you?” ");
INSERT INTO engfbv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“I heard you walking in the garden and I was afraid because I was naked, so I hid,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Who told you that you were naked?” asked the Lord God. “Did you eat fruit from the tree I ordered you not to?” ");
INSERT INTO engfbv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“It was the woman you gave me who gave me the fruit from the tree, and I ate it,” Adam replied. ");
INSERT INTO engfbv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","The Lord God asked Eve, “Why have you done this?” “The serpent tricked me, and so I ate it,” she replied. ");
INSERT INTO engfbv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Then the Lord God told the serpent, “Because of what you've done, you are cursed more than any of the other animals. You will slide along on your belly and eat dust as long as you live. ");
INSERT INTO engfbv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I will make sure you and your children, and the woman and her children, are enemies. One of her children will crush your head, and you will strike his heel.” ");
INSERT INTO engfbv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","He told Eve, “I will make pregnancy much more difficult, and giving birth will be very painful. However, you will still desire your husband, but he will have control over you.” ");
INSERT INTO engfbv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","He told Adam, “Because you did what your wife told you, and ate fruit from the tree after I ordered you, ‘Don't eat fruit from this tree,’ the ground is now cursed because of you. You will have to work painfully hard to grow food from it throughout your whole life. ");
INSERT INTO engfbv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","It will grow thorns and thistles for you, and you will have to eat wild plants. ");
INSERT INTO engfbv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","You will have to sweat to grow enough food to eat until you die and return to the ground. For you were made from dust and you will return to dust.” ");
INSERT INTO engfbv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam named his wife Eve, because she was to be the mother of all human beings. ");
INSERT INTO engfbv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","The Lord God made Adam and Eve clothes from animal skins and dressed them. ");
INSERT INTO engfbv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Then the Lord God observed, “Look, the human beings have become like one of us, knowing both what is good and what is evil. Now if they take the fruit from the tree of life and eat it, then they'll live forever!” ");
INSERT INTO engfbv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So the Lord God expelled them from the Garden of Eden. He sent Adam to cultivate the ground from which he'd been made. ");
INSERT INTO engfbv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","After he drove them out, the Lord God placed on the east side of the Garden of Eden angels and a sword that flashed in every direction. They were to prevent access to the tree of life. ");
INSERT INTO engfbv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam slept with his wife Eve and she became pregnant. She gave birth to Cain, and said, “With the Lord's help I have made a man.” ");
INSERT INTO engfbv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Later she gave birth to his brother Abel. Abel became a shepherd, while Cain was a crop farmer. ");
INSERT INTO engfbv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sometime later Cain brought some of the produce he'd grown as an offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel also brought an offering: the firstborn lambs of his flock, selecting the very best parts to offer. The Lord was pleased with Abel and his offering, ");
INSERT INTO engfbv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","but he wasn't pleased with Cain and his offering, which made Cain very angry and he frowned in annoyance. ");
INSERT INTO engfbv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","The Lord said to Cain, “Why are you so angry? Why do you look so annoyed? ");
INSERT INTO engfbv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","If you were doing what's right, then you'd be looking happy. But if you don't do what's right, then sin will be like an animal crouching outside your home, ready to pounce on you. It wants to have you, but you must be the one in control.” ");
INSERT INTO engfbv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Later, when Cain was talking with his brother Abel they went out into the fields where Cain attacked his brother and killed him. ");
INSERT INTO engfbv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","“Where is your brother Abel?” the Lord asked Cain. “How should I know?” he replied. “Am I supposed to be my brother's care-giver?” ");
INSERT INTO engfbv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","“What have you done?” the Lord asked. “Your brother's blood is crying out to me from the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Consequently you are more cursed than the ground because you soaked it with your brother's blood. ");
INSERT INTO engfbv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","When you cultivate the ground, it won't produce crops for you. You'll be always on the run, wandering all over the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","“My punishment is more than I can take,” Cain replied. ");
INSERT INTO engfbv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","“Look! You're driving me away right now—cursing the ground and banishing me from your presence. I'm going to have to hide and always be on the run, left to wander all over the earth. Anyone who finds me is going to kill me!” ");
INSERT INTO engfbv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","But the Lord replied, “No, Cain. Anyone who kills you will be punished seven times over.” The Lord placed a mark on Cain so that no one who came across him would kill him. ");
INSERT INTO engfbv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","So Cain left the Lord's presence and went to live in a land called Nod, east of Eden. ");
INSERT INTO engfbv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain slept with his wife and she became pregnant. She had a son named Enoch. At that time Cain was building a town, so he named it after his son Enoch. ");
INSERT INTO engfbv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch had a son named Irad. Irad was the father of Mehujael, Mehujael was the father of Methushael, and Methushael was the father of Lamech. ");
INSERT INTO engfbv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech married two women. The first was named Adah, and the second was named Zillah. ");
INSERT INTO engfbv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah had a son named Jabal. He was the father of those who live in tents and have livestock. ");
INSERT INTO engfbv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","He had a brother named Jubal; he was the father of all those who play stringed and wind instruments. ");
INSERT INTO engfbv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah also had a son. He was named Tubal-cain and he was a blacksmith, making different kinds of tools out of bronze and iron. Tubal-cain's sister was named Naamah. ");
INSERT INTO engfbv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","At one time Lamech told his wives, “Adah and Zillah, listen to me. You wives of Lamech, pay attention to what I have to say. I killed a man because he wounded me; I killed a young man because he injured me. ");
INSERT INTO engfbv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","If the sentence for killing Cain was to be punished seven times over, then if someone kills me, Lamech, the punishment should be seventy-seven times.” ");
INSERT INTO engfbv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam slept with his wife again, and she had a son and named him Seth, explaining that, “God has given me another child to replace Abel, the one Cain killed.” ");
INSERT INTO engfbv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Later Seth had a son named Enosh, because at that time people began to worship the Lord by name. ");
INSERT INTO engfbv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the record of Adam's descendants. When God created human beings, he made them to be like him. ");
INSERT INTO engfbv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He created them male and female, and blessed them. On the day he created them he called them “human.” ");
INSERT INTO engfbv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","When Adam was 130, he had a son who was like him, made in his image; and he named him Seth. ");
INSERT INTO engfbv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam lived another 800 years after Seth was born, and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam lived a total of 930 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","When Seth was 105, he had Enosh. ");
INSERT INTO engfbv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth lived another 807 years after Enosh was born, and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth lived a total of 912 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","When Enosh was 90, he had Kenan. ");
INSERT INTO engfbv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosh lived another 815 years after Kenan was born, and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh lived a total of 905 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","When Kenan was 70, he had Mehalalel. ");
INSERT INTO engfbv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan lived another 840 years after Mehalalel was born, and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan lived a total of 910 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel was 65, he had Jared. ");
INSERT INTO engfbv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","After Jared was born, Mahalalel lived another 830 years and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel lived a total of 895 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","When Jared was 162, he had Enoch. ");
INSERT INTO engfbv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","After Enoch was born, Jared lived 800 years and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared lived a total of 962 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","When Enoch was 65, he had Methuselah. ");
INSERT INTO engfbv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","He had a close relationship with God. After Methuselah was born, Enoch lived another 300 years and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch lived a total of 365 years. ");
INSERT INTO engfbv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoch had such a close relationship with God that he didn't die, he just wasn't there anymore, because God took him. ");
INSERT INTO engfbv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","When Methuselah was 187, he had Lamech. ");
INSERT INTO engfbv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","After Lamech was born, Methuselah lived another 782 years and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah lived a total of 969 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech was 182, he had a son. ");
INSERT INTO engfbv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","He named him Noah, with the explanation, “He will provide relief for us from all the hard manual labor we need to do in cultivating the ground the Lord has cursed.” ");
INSERT INTO engfbv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","After Noah was born, Lamech lived another 595 years and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech lived a total of 777 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah was 500 before he had Shem, Ham, and Japheth. ");
INSERT INTO engfbv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","People started to increase in number and spread out across the earth. Daughters were born to them, ");
INSERT INTO engfbv_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","and the sons of God saw that these women were beautiful, and they took whichever ones they wanted. ");
INSERT INTO engfbv_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Then the Lord said, “My life-giving Spirit will not remain in these people forever, because they are only mortal. The time they have left will be 120 years.” ");
INSERT INTO engfbv_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","There were giants on earth in those days, and also later on. They were born after the sons of God slept with the daughters of these people. Their sons became the great warriors and famous men of ancient times. ");
INSERT INTO engfbv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","The Lord saw how terribly evil people on earth had become—every single thought in their minds was evil all the time! ");
INSERT INTO engfbv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","The Lord was sorry he'd made human beings to live on the earth; it made him very sad to think about it. ");
INSERT INTO engfbv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So the Lord said, “I'm going to wipe out these people I created from the earth, and not only them but also the animals, the creatures that run along the ground, and the birds, because I'm sorry I made them.” ");
INSERT INTO engfbv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But the Lord was pleased with Noah. ");
INSERT INTO engfbv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the story of Noah and his family. Noah was a man of integrity, living a moral life among the people of his time. He had a close relationship with God. ");
INSERT INTO engfbv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah had three sons: Shem, Ham, and Japheth. ");
INSERT INTO engfbv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","God saw how corrupt the whole world had become, full of violent and lawless people. ");
INSERT INTO engfbv_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God recognized that the corruption in the world was due to everyone on earth living corrupt lives. ");
INSERT INTO engfbv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","So God told Noah, “I have decided to put an end to all people on earth because they are all violent and lawless. I myself am going to destroy all of them, along with the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Build an ark out of cypress wood. Make rooms inside the ark, and coat it with tar, both inside and out. ");
INSERT INTO engfbv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","This is how to build it: the ark is to measure 300 cubits long, 50 cubits wide, and 30 cubits high. ");
INSERT INTO engfbv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Make a roof for the ark, leaving a cubit-wide opening between the roof and the top of the sides. Put a door in the side of the ark, and construct three decks inside. ");
INSERT INTO engfbv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","I myself am going to flood the earth with water that will destroy everything that breathes. Every living thing everywhere on earth will die. ");
INSERT INTO engfbv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","But I will keep my agreement with you. You are to go into the ark, taking with you your wife and your sons and their wives. ");
INSERT INTO engfbv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Take a pair, male and female, of every kind of animal into the ark and make sure you keep them alive. ");
INSERT INTO engfbv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","The same applies to every kind of bird, livestock, and the creatures that run along the ground—a pair of every kind will come to you so they can be kept alive. ");
INSERT INTO engfbv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Take all kinds of food with you too. Store it so you and the animals will have enough to eat.” ");
INSERT INTO engfbv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah did exactly what God ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","The Lord told Noah, “Go into the ark with all your family. I have seen how you are a man of integrity, living a moral life among the people of this generation. ");
INSERT INTO engfbv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Take with you seven pairs, male and female, of every kind of clean animal, and one pair, male and female, of every kind of unclean animal. ");
INSERT INTO engfbv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","In addition take seven pairs, male and female, of all the birds, so their different kinds will survive throughout the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","In seven days I'm going to make it rain for forty days and nights. I'm going to wipe out from the surface of the earth all the living creatures I made.” ");
INSERT INTO engfbv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah did exactly what the Lord ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was 600 when the flood waters covered the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noah went into the ark, taking with him his wife and his sons and their wives, because of the flood. ");
INSERT INTO engfbv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Clean and unclean animals, birds, and creatures that run along the ground, ");
INSERT INTO engfbv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","went into the ark with Noah. They came in pairs, male and female, just as God had told Noah. ");
INSERT INTO engfbv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","After seven days the floodwaters swept over the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah was 600 when on the seventeenth day of the second month all the subterranean waters burst through the earth, and heavy rain poured down from the sky. ");
INSERT INTO engfbv_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Rain continued to fall on the earth for forty days and nights. ");
INSERT INTO engfbv_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","That was the actual day when Noah, his wife, and their sons, Shem, Ham, and Japheth together with their three wives went into the ark. ");
INSERT INTO engfbv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They had with them every kind of wild animals, livestock, creatures that run along the ground, and birds—everything with wings. ");
INSERT INTO engfbv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","They all came into the ark with Noah in pairs—every living thing that breathes. ");
INSERT INTO engfbv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","A male and a female of every creature entered, as God had told Noah. Then the Lord shut the door behind him. ");
INSERT INTO engfbv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","The flood increased for forty days, lifting the ark so that it floated up from the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The floodwaters surged and grew deeper and deeper over the earth, but the ark floated along on the surface. ");
INSERT INTO engfbv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Finally the water grew so deep that even the highest mountains were covered—all that could be seen was sky. ");
INSERT INTO engfbv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The water rose so much that it was higher than the mountains by fifteen cubits. ");
INSERT INTO engfbv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Everything living on earth died—the birds, livestock, wild animals, all creatures that run along the ground, and all the people. ");
INSERT INTO engfbv_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Everything on land that breathed, died. ");
INSERT INTO engfbv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","The Lord wiped out all life on earth—people, livestock, creatures that run along the ground, and birds. All were killed. The only ones left were Noah and those with him on the ark. ");
INSERT INTO engfbv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The earth remained flooded for 150 days. ");
INSERT INTO engfbv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","But God hadn't forgotten about Noah and all the wild animals and livestock with him in the ark. God sent a wind to blow over the earth, and the floodwaters started to drop. ");
INSERT INTO engfbv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","The subterranean waters were closed off, and the heavy rainfall was stopped. ");
INSERT INTO engfbv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","The floodwaters steadily receded from the earth. They had gone down so much that by 150 days after the flood began ");
INSERT INTO engfbv_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","the ark grounded on the mountains of Ararat. This happened on the seventeenth day of the seventh month. ");
INSERT INTO engfbv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The waters continued to drop so that by the first day of the tenth month the tops of mountains could be seen. ");
INSERT INTO engfbv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Forty days later Noah opened the window he'd made in the ark, ");
INSERT INTO engfbv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","and sent a raven out. It flew back and forth until the water on the earth had dried up. ");
INSERT INTO engfbv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Then he sent a dove out to see if the waters had gone down enough to expose dry ground. ");
INSERT INTO engfbv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","But the dove couldn't find anywhere to land. So it came back to Noah in the ark because water was still covering the whole earth. He reached out his hand, picked up the dove, and took it back into the ark with him. ");
INSERT INTO engfbv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","He waited another seven days and sent the dove out from the ark again. ");
INSERT INTO engfbv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","When it came back to him in the evening it had a freshly-picked olive leaf in its beak, so Noah knew the floodwaters were mainly gone from the earth. ");
INSERT INTO engfbv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Again he waited another seven days and sent the dove out again, but this time it didn't return to him. ");
INSERT INTO engfbv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","By now Noah was 601, and by the first day of the first month, the floodwaters on the earth were gone. Noah pulled back the ark's covering and saw that the ground was drying out. ");
INSERT INTO engfbv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","By the twenty-seventh day of the second month the earth was dry. ");
INSERT INTO engfbv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God told Noah, ");
INSERT INTO engfbv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Leave the ark, you and your wife, your sons and their wives. ");
INSERT INTO engfbv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Let all the animals go—the birds, the wild animals, the creatures that run along the ground—so that they can breed and increase their numbers on the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","So Noah and his wife, his sons and their wives, left the ark. ");
INSERT INTO engfbv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","All the animals, all the creatures that run along the ground, all the birds—everything that lives on land—also left, each kind leaving together. ");
INSERT INTO engfbv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah built an altar, and sacrificed some of the clean animals and birds as a burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","The Lord accepted the sacrifice, and said to himself, “I won't ever again curse the ground because of human beings, even though every single thought in their minds is evil from childhood. I won't ever destroy all life again as I have just done. ");
INSERT INTO engfbv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","As long as the earth exists, seedtime and harvest, cold and heat, summer and winter, day and night, will never come to an end.” ");
INSERT INTO engfbv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God blessed Noah and his sons, and told them, “Reproduce, increase, and spread throughout the earth! ");
INSERT INTO engfbv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","All animals will be very afraid of you—this includes all the birds, all the creatures that run along the ground, and all the fish in the sea. You are in charge of them. ");
INSERT INTO engfbv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Every living creature that moves will be food for you, as well as all the green plants. ");
INSERT INTO engfbv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But do not eat meat with the lifeblood still in it. ");
INSERT INTO engfbv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","If your blood is shed by any animal, I will call it to account; and if your blood is shed by any person, I will call that person to account. ");
INSERT INTO engfbv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Whoever sheds the blood of a human being will have their blood shed by human beings. For God made human beings in his image. ");
INSERT INTO engfbv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Reproduce, increase, and spread throughout the earth—have many descendants!” ");
INSERT INTO engfbv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Then God told Noah and his sons who were there with him, ");
INSERT INTO engfbv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Listen, I'm making my agreement with you and your descendants, ");
INSERT INTO engfbv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","and with all the animals around you—the birds, the livestock, and all the wild animals of the earth—every animal that accompanied you on the ark. ");
INSERT INTO engfbv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","In my agreement I'm promising you that I won't ever again destroy all life by means of a flood—there won't be a destructive flood like this again.” ");
INSERT INTO engfbv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Then God said, “I'm going to give you a sign to confirm the agreement I'm making between me and you and all living creatures, an agreement that will last for all generations. ");
INSERT INTO engfbv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I've placed my rainbow in the clouds, and this will be the sign of my agreement with you and with all life on earth. ");
INSERT INTO engfbv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Whenever I make clouds form over the earth and the rainbow appears, ");
INSERT INTO engfbv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","it will remind me of my agreement between me and you and every kind of living creature that floodwaters won't ever again destroy all life. ");
INSERT INTO engfbv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","I will see the rainbow in the clouds and it will remind me of the eternal agreement between God and every kind of living creature that lives on the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Then God told Noah, “This is the sign of the agreement I'm making between me and every creature on earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noah's sons who left the ark were Shem, Ham, and Japheth. (Ham was the father of the Canaanites.) ");
INSERT INTO engfbv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","All the people who are spread over the world are descended from these three sons of Noah. ");
INSERT INTO engfbv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah started to cultivate the ground as a farmer, and he planted a vineyard. ");
INSERT INTO engfbv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","He drank some of the wine he'd produced, got drunk, and fell asleep in his tent, naked. ");
INSERT INTO engfbv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, the father of Canaan, saw his father's private parts and went and told his two brothers who were outside. ");
INSERT INTO engfbv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem and Japheth picked up a cloak and, holding it over their shoulders, walked in backwards and covered up their father's privates. They made sure to look the other way so they wouldn't see their father's privates. ");
INSERT INTO engfbv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","When Noah woke up from his drunken sleep, he discovered what his youngest son had done, ");
INSERT INTO engfbv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","and said, “May Canaan be cursed! He will be the lowest kind of slave and will serve his brothers!” ");
INSERT INTO engfbv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Then Noah continued, “May the Lord be blessed, the God of Shem, and may Canaan be his slave. ");
INSERT INTO engfbv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God give Japtheth plenty of space to accommodate his many descendants, and may they live at peace among Shem's people, and may Canaan also be his slave.” ");
INSERT INTO engfbv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah lived for another 350 years after the flood. ");
INSERT INTO engfbv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noah lived a total of 950 years, and then he died. ");
INSERT INTO engfbv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","The following are the genealogies of the sons of Noah: Shem, Ham, and Japheth. They had sons born to them after the flood. ");
INSERT INTO engfbv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","The sons of Japheth: Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engfbv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","The sons of Gomer: Ashkenaz, Riphath, and Togarmah. ");
INSERT INTO engfbv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","The sons of Javan: Elishah, Tarshish, Kittim, and Dodanim. ");
INSERT INTO engfbv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","The descendants of these ancestors spread throughout the coastal areas, each group having their own language, with their families developing into different nations. ");
INSERT INTO engfbv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","The sons of Ham: Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","The sons of Cush: Seba, Havilah, Sabtah, Raamah, and Sabteca. The sons of Raamah: Sheba and Dedan. ");
INSERT INTO engfbv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush was also the father of Nimrod, who set himself up as the first tyrant on earth. ");
INSERT INTO engfbv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a powerful fighter who defied the Lord; which is why there's the expression, “Like Nimrod, a powerful fighter who defied the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","His kingdom began in the cities of Babel, Erech, Akkad, and Calneh, all located in the land of Shinar. ");
INSERT INTO engfbv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","From there he moved into Assyria and built the cities of Nineveh, Rehoboth-Ir, Calah, ");
INSERT INTO engfbv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","and Resen, which lies between Nineveh and the great city of Calah. ");
INSERT INTO engfbv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim was the father of the Ludites, the Anamites, the Lehabites, the Naphtuhites, ");
INSERT INTO engfbv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","the Pathrusites, the Casluhites, and the Caphtorites (ancestors of the Philistines). ");
INSERT INTO engfbv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan was the father of Sidon, his firstborn, and of the Hittites, ");
INSERT INTO engfbv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","the Jebusites, the Amorites, the Girgashites, ");
INSERT INTO engfbv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","the Hivites, the Arkites, the Sinites, ");
INSERT INTO engfbv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","the Arvadites, the Zemarites, and the Hamathites. Later the Canaanite tribes spread out ");
INSERT INTO engfbv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","and the territory of the Canaanites stretched from Sidon towards Gerar and all the way to Gaza, then towards Sodom, Gomorrah, Admah, and Zeboiim, all the way to Lasha. ");
INSERT INTO engfbv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","These were the sons of Ham according to their tribes, languages, lands, and nation. ");
INSERT INTO engfbv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem, whose older brother was Japheth, also had sons. Shem was the forefather of all the sons of Eber. ");
INSERT INTO engfbv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","The sons of Shem: Elam, Asshur, Arphaxad, Lud, and Aram. ");
INSERT INTO engfbv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","The sons of Aram: Uz, Hul, Gether, and Mash. ");
INSERT INTO engfbv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad was the father of Shelah. Shelah was the father of Eber. ");
INSERT INTO engfbv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber had two sons. One was named Peleg, because in his time the earth was divided; the name of his brother was Joktan. ");
INSERT INTO engfbv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan was the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engfbv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engfbv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engfbv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. These were all sons of Joktan. ");
INSERT INTO engfbv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","They lived in the land lying between Mesha to Sephar, in the hill country to the east. ");
INSERT INTO engfbv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These were the sons of Shem, according to their tribes, languages, lands, and nations. ");
INSERT INTO engfbv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","These were all the tribes descended from Noah's sons, according to their genealogies and national groups. From these ancestors the different nations of the earth spread around the world after the flood. ");
INSERT INTO engfbv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","At that time the whole world spoke just one language and used words with the same meaning. ");
INSERT INTO engfbv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","As they moved east they discovered a plain in the land of Shinar so they settled there. ");
INSERT INTO engfbv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","They said to one another, “Come on, let's make some bricks and bake them with fire.” (They used brick instead of stone, and tar instead of cement). ");
INSERT INTO engfbv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Then they said, “Now let's build a city for ourselves with a tower whose top reaches the heavens. That way we'll gain a great reputation and we won't end up being scattered all over the world.” ");
INSERT INTO engfbv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","But the Lord came down to take a look at the city and the tower that the people were building. ");
INSERT INTO engfbv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","The Lord said, “Look! These people are united and they all speak one language. If this is what they can do now when they're just getting started, nothing will be impossible for them when they all put their minds to it! ");
INSERT INTO engfbv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","We need to go down and mix up their language and make it confused so they won't be able to understand what they're saying to one other.” ");
INSERT INTO engfbv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","The Lord sent them away from there and scattered them all over the world, and they gave up building the city. ");
INSERT INTO engfbv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","That's why it was called Babel, because the Lord made the language of the world confused. ");
INSERT INTO engfbv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","The following is the genealogy of Shem. When Shem was 100, he had Arphaxad. This was two years after the flood. ");
INSERT INTO engfbv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shem lived another 500 years after Arphaxad was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphaxad was 35, he had Shelah. ");
INSERT INTO engfbv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arphaxad lived another 403 years after Shelah was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","When Shelah was 30, he had Eber. ");
INSERT INTO engfbv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Shelah lived another 403 years after Eber was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","When Eber was 34, he had Peleg. ");
INSERT INTO engfbv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber lived another 430 years after Peleg was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","When Peleg was 30, he had Reu. ");
INSERT INTO engfbv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg lived another 209 years after Reu was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","When Reu was 32, he had Serug. ");
INSERT INTO engfbv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu lived another 207 years after Serug was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","When Serug was 30, he had Nahor. ");
INSERT INTO engfbv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug lived another 200 years after Nahor was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","When Nahor was 29, he had Terah. ");
INSERT INTO engfbv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor lived another 119 years after Terah was born and had other sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","When Terah was 70, he had Abram, Nahor, and Haran. ");
INSERT INTO engfbv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","The following is the genealogy of Terah. Terah was the father of Abram, Nahor, and Haran. Haran was the father of Lot. ");
INSERT INTO engfbv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","However, Haran died while his father, Terah, was still alive, in Ur of the Chaldeans, the land of his birth. ");
INSERT INTO engfbv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram and Nahor both got married. Abram's wife was named Sarai, and Nahor's wife was named Milcah. (She was the daughter of Haran, who was the father of both Milcah and Iscah). ");
INSERT INTO engfbv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai wasn't able to become pregnant and so had no children. ");
INSERT INTO engfbv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah took his son Abram, his grandson Lot (who was the son of Haran), his daughter-in-law Sarai (the wife of his son Abram), and left Ur of the Chaldeans to move to the land of Canaan. They got as far as Haran and settled there. ");
INSERT INTO engfbv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah lived for 205 years and died in Haran. ");
INSERT INTO engfbv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","The Lord told Abram, “Leave your country, your relatives, your family home, and travel to the land I'm going to show you. ");
INSERT INTO engfbv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will make you the ancestor of a great nation and I will bless you. I will make sure you have a great reputation and that you are a blessing to others. ");
INSERT INTO engfbv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you; I will curse those who curse you. Everyone on earth will be blessed through you.” ");
INSERT INTO engfbv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram left following the Lord's instructions, and Lot went with him. Abram was 75 when he left Haran. ");
INSERT INTO engfbv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","With him went his wife Sarai, his nephew Lot, together with all the possessions they had collected and the people that had joined them in Haran. They left for the land of Canaan. When they arrived there, ");
INSERT INTO engfbv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traveled on through the land as far as a place called Shechem, stopping at the oak tree of Moreh. At that time the land was occupied by Canaanites. ");
INSERT INTO engfbv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","The Lord appeared to Abram and said, “I'm going to give this land to your descendants.” So Abram built an altar to the Lord there because that was where the Lord appeared to him. ");
INSERT INTO engfbv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Then he moved on to the hill country east of Bethel and set up camp there. Bethel was to the west and Ai to the east. He built an altar to the Lord there and worshiped him. ");
INSERT INTO engfbv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","After that he went on his way, heading towards the Negev. ");
INSERT INTO engfbv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","But the land had been hit by famine. So Abram continued on to Egypt, planning to live there because the famine was so bad. ");
INSERT INTO engfbv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","As he approached Egypt and was about to cross the border, he said to his wife Sarai, “Look, I know what a beautiful woman you are. ");
INSERT INTO engfbv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","When the Egyptians see you, they'll say, ‘She's his wife,’ and they'll kill me but not you! ");
INSERT INTO engfbv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tell them you're my sister so I'll be treated well because of you, and my life will be spared for your sake.” ");
INSERT INTO engfbv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","When Abram arrived in Egypt, the people there saw how beautiful Sarai was. ");
INSERT INTO engfbv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pharaoh's officials also noticed and spoke positively about her to Pharaoh. So Sarai was taken to his palace to become one of his wives. ");
INSERT INTO engfbv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pharaoh treated Abram well because of her, giving him sheep and cattle, male donkeys, male servants, female servants, female donkeys, and camels. ");
INSERT INTO engfbv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","But the Lord caused Pharaoh and the people in his palace to suffer from terrible diseases because of Sarai, Abram's wife. ");
INSERT INTO engfbv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","So Pharaoh ordered Abram brought to him and said, “What have you done to me? Why didn't you tell me that she was your wife? ");
INSERT INTO engfbv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Why did you say, ‘She's my sister,’ and let me take her to become one of my wives? So here's your wife! Take her and leave!” ");
INSERT INTO engfbv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pharaoh ordered his guards to expel him and his wife from the country, along with everyone with them and all their possessions. ");
INSERT INTO engfbv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram left Egypt and went back into the Negev along with Sarai, Lot, and everyone with them, as well as all their possessions. ");
INSERT INTO engfbv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram was very rich, having many herds of livestock and a great deal of silver and gold. ");
INSERT INTO engfbv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","He left the Negev and traveled in stages to Bethel, back to the place where he'd camped before, between Bethel and Ai. ");
INSERT INTO engfbv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","This was where he'd first built an altar. He worshiped the Lord there as he had done previously. ");
INSERT INTO engfbv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, who was traveling with Abram, also had many flocks, herds, and tents, ");
INSERT INTO engfbv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","so much so that the available land couldn't support both of them—they had so much livestock they couldn't stay together anymore. ");
INSERT INTO engfbv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abram's and Lot's herdsmen were arguing, and in addition the Canaanites and Perizzites were also living in the land at that time. ");
INSERT INTO engfbv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","So Abram said to Lot, “Please don't let's have arguments between us, or between our herdsmen, because we're family. ");
INSERT INTO engfbv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","You see all this land that's available right in front of you? We have to split up. If you choose to go to the left, I'll go to the right. If you choose to go to the right, I'll go to the left.” ");
INSERT INTO engfbv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked over the whole Jordan valley towards Zoar, and saw that it was well-watered, looking like the Garden of Eden, like the land of Egypt. (This was before the Lord destroyed Sodom and Gomorrah.) ");
INSERT INTO engfbv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose the whole Jordan valley and went east, and the two separated from each other. ");
INSERT INTO engfbv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram went to live in the land of Canaan, while Lot settled down among the towns in the valley, setting up his tents near Sodom. ");
INSERT INTO engfbv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","(The people of Sodom were very wicked, committing terrible sins that offended the Lord.) ");
INSERT INTO engfbv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After separating from Lot, the Lord told Abram, “Look around you from where you're standing, to the north, south, east, and west. ");
INSERT INTO engfbv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","I'm giving all this land you see to you and your descendants forever. ");
INSERT INTO engfbv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","You will have so many descendants that they'll be like the dust of the earth. If anyone could count dust then they could count the number of your descendants! ");
INSERT INTO engfbv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Go and walk through the whole land in all directions because I'm giving it to you.” ");
INSERT INTO engfbv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram went to live at Hebron, setting up his tents among the oaks at Mamre, where he built an altar to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","At that time Amraphel was king of Shinar, and he allied himself with Arioch, king of Ellasar, Chedorlaomer, king of Elam, and Tidal, king of Goiim. ");
INSERT INTO engfbv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","They attacked Bera, king of Sodom, Birsha, king of Gomorrah, Shinab, king of Admah, Shemeber, king of Zeboiim, and the king of Bela (otherwise known as Zoar). ");
INSERT INTO engfbv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these in the second group joined forces in the Valley of Siddim (the Dead Sea valley). ");
INSERT INTO engfbv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","They had been under the rule of Chedorlaomer for twelve years, but in the thirteenth year they rebelled against him. ");
INSERT INTO engfbv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","In the fourteenth year Chedorlaomer invaded, along with the kings in his alliance. They defeated the Rephaites in Ashteroth-karnaim, the Zuzites in Ham, the Emites in Shaveh-kiriathaim, ");
INSERT INTO engfbv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","and the Horites in their hill country of Seir, all the way to El-paran, near the desert. ");
INSERT INTO engfbv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then they swung back through and attacked En-mishpat (otherwise known as Kadesh) and conquered the whole country belonging to the Amalekites, as well as the Amorites who lived in Hazazon-tamar. ");
INSERT INTO engfbv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Then the king of Sodom, the king of Gomorrah, the king of Admah, the king of Zeboiim, and the king of Bela (otherwise known as Zoar) marched out and prepared for battle in the Valley of Siddim. ");
INSERT INTO engfbv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","They fought Chedorlaomer, king of Elam, Tidal, king of Goiim, Amraphel, king of Shinar, and Arioch, king of Ellasar—four kings on one side against five on the other. ");
INSERT INTO engfbv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","There were many tar pits in the Valley of Siddim, and as the defeated kings of Sodom and Gomorrah ran away, some of their men fell into them while the rest ran to the hills. ");
INSERT INTO engfbv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","The invaders took from Sodom and Gomorrah all their possessions and food and left. ");
INSERT INTO engfbv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","They also captured Lot, Abram's nephew, and his possessions, because he was living in Sodom. ");
INSERT INTO engfbv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","But one of those captured escaped and went and told Abram the Hebrew what had happened. Abram was living by the oaks of Mamre the Amorite, whose brothers were Eshcol and Aner. All of them were Abram's allies. ");
INSERT INTO engfbv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","When Abram found out that his nephew had been captured, he called together 318 fighting men who had been born in his household and chased after them all the way to Dan. ");
INSERT INTO engfbv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","There he divided his men into groups and attacked at night, defeating the enemy and chasing them as far as Hobah, north of Damascus. ");
INSERT INTO engfbv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram recovered all that had been taken, including Lot and his possessions, and also brought back the women and others who had been captured. ");
INSERT INTO engfbv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","When Abram returned after defeating Chedorlaomer and his allies, the king of Sodom came out to meet him at the Valley of Shaveh (or Valley of the King). ");
INSERT INTO engfbv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchizedek, king of Salem, brought out bread and wine. He was a priest of the Most High God. ");
INSERT INTO engfbv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","He blessed Abram, telling him, “May Abram be blessed by the Most High God, Creator of heaven and earth. ");
INSERT INTO engfbv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","May the Most High God be praised, who handed your enemies over to you.” Then Abram gave Melchizedek one tenth of everything. ");
INSERT INTO engfbv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","The king of Sodom told Abram, “Let me have the people back, and you can keep everything else for yourself.” ");
INSERT INTO engfbv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram replied to the king of Sodom, “I raise my hand, making a solemn promise to the Lord, the Most High God, Creator of heaven and earth, ");
INSERT INTO engfbv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","that I refuse to take anything belonging to you, not a single thread or a sandal strap. Otherwise you might claim, ‘It was me who made Abram rich!’ ");
INSERT INTO engfbv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","I won't take anything except what my men have eaten, and the share for those who accompanied me—Aner, Eshcol, and Mamre. Let them have their share.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After all this had happened, God spoke to Abram in a vision, telling him, “Don't be afraid, Abram! I am your protector, and your truly great reward!” ");
INSERT INTO engfbv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","But Abram replied, “Lord God, what good is whatever you give me? I don't have any children, and the heir to all that I have is Eliezer of Damascus.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram went on to complain, “Look! You haven't given me any children, so a servant from my household has to be my heir!” ");
INSERT INTO engfbv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","But then the Lord told him, “This man won't be your heir. Your heir will be your very own son.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","The Lord took Abram outside and said to him, “Look up at the sky. See if you can count the stars! That's how many descendants you will have!” ");
INSERT INTO engfbv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram trusted what the Lord said, and so the Lord counted Abram as being in a right relationship with him. ");
INSERT INTO engfbv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","The Lord also told him, “I am the Lord, who led you from Ur of the Chaldeans to give you this land for you to own.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","“But Lord God, how can I be certain that I will own it?” Abram asked. ");
INSERT INTO engfbv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","The Lord told him, “Bring me a cow, a goat, and a ram, all of them three years old, together with a dove and a young pigeon.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","So Abram took and killed the three animals. Then he cut them in half, and placed each half opposite the other. However, he didn't cut the birds in half. ");
INSERT INTO engfbv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","When vultures flew down on the carcasses, Abram frightened them off. ");
INSERT INTO engfbv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","As the sun went down, a deep sleep came over Abram, and at the same time a dense and terrifying darkness fell on him. ");
INSERT INTO engfbv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","The Lord explained to Abram, “You can be absolutely sure that your descendants will be strangers in a foreign land, where they will be slaves and mistreated for 400 years. ");
INSERT INTO engfbv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","However, I will punish the nation that makes them slaves, and later on they will leave, taking many valuable possessions with them. ");
INSERT INTO engfbv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","But as for you, you will die in peace and be buried, having lived a good long life. ");
INSERT INTO engfbv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Four generations later your descendants will come back here to live, because right now the sins of the Amorites have not reached their full extent.” ");
INSERT INTO engfbv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","After the sun set and it grew dark, suddenly a smoking furnace and a flaming torch appeared and passed between the halves of the animal carcasses. ");
INSERT INTO engfbv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","This is how the Lord made an agreement with Abram that day and promised him, “I'm giving this land to your descendants. It extends from the Wadi of Egypt to the great Euphrates River, ");
INSERT INTO engfbv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","and includes the territory of the Kenites, Kenizzites, Kadmonites, ");
INSERT INTO engfbv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittites, Perizzites, Rephaites, ");
INSERT INTO engfbv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorites, Canaanites, Girgashites, and Jebusites.” ");
INSERT INTO engfbv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, Abram's wife, hadn't been able to have any children for him. However, she owned a female Egyptian slave named Hagar, ");
INSERT INTO engfbv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","so Sarai said to Abram, “Please listen to me. The Lord hasn't let me have any children. So please go and sleep with my slave. Maybe I can have a family through her.” Abram agreed to what Sarai had suggested. ");
INSERT INTO engfbv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So Sarai, Abram's wife took her Egyptian slave Hagar and gave her to her husband as his wife. Abram had been living in the land of Canaan for ten years when this happened. ");
INSERT INTO engfbv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram slept with Hagar and she became pregnant. When she realized she was pregnant, she treated her mistress with contempt. ");
INSERT INTO engfbv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai complained to Abram, “What I'm suffering is all your doing! I gave you my servant to sleep with, and now that she knows she's pregnant, she treats me with contempt. May the Lord decide who's at fault—you or me!” ");
INSERT INTO engfbv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“Listen, she's your slave!” Abram replied. “You can do whatever you want to her.” Sarai treated Hagar so badly that she ran away. ");
INSERT INTO engfbv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","The angel of the Lord met Hagar at a spring in the desert—the spring on the road to Shur. ");
INSERT INTO engfbv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","He asked her, “Hagar, Sarai's slave—where have you come from, and where are you going?” “I'm running away from my mistress Sarai,” she replied. ");
INSERT INTO engfbv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","“Go back to your mistress and do what she tells you,” the angel of the Lord told her. ");
INSERT INTO engfbv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Then he continued, “I will give you many, many descendants—in fact they'll be so many they can't be counted.” ");
INSERT INTO engfbv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","The angel of the Lord went on to tell her: “Listen! You're pregnant, and you will have a son. You are to name him Ishmael, for the Lord has heard how you've suffered. ");
INSERT INTO engfbv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","He'll be a wild donkey kind of man—he will fight with everyone, and everyone will fight with him. He will forever be fighting with his relatives.” ");
INSERT INTO engfbv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","From then on Hagar called the Lord who spoke to her, “You are the God who sees me,” because she said, “Here I saw the one who sees me.” ");
INSERT INTO engfbv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","That's why the well is called “the Well of the Living One who Sees Me.” It's still there, between Kadesh and Bered. ");
INSERT INTO engfbv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar gave birth to a son for Abram. Abram named his son Ishmael. ");
INSERT INTO engfbv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was 86 when Hagar had Ishmael. ");
INSERT INTO engfbv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was 99, the Lord appeared to him and told him, “I am God Almighty. Live in my presence and don't do wrong. ");
INSERT INTO engfbv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","I will make my agreement between me and you, and I will give you many, many descendants.” ");
INSERT INTO engfbv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram bowed down with his face to the ground, and God told him, ");
INSERT INTO engfbv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Listen! This is the agreement I'm making with you. You will be the father of many nations, ");
INSERT INTO engfbv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","so your name won't be Abram any longer. Instead, your name will be Abraham because I'm going to make you the father of many nations. ");
INSERT INTO engfbv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will make sure you have a large number of descendants. They will become many nations, and some of their kings will also come from your line. ");
INSERT INTO engfbv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","I promise to continue my agreement with you, and with your descendants who come after you, for generations to come. This is an eternal agreement. I will always be your God, and the God of your descendants. ");
INSERT INTO engfbv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","I will give you and your descendants the whole country of Canaan—where you've been living as a foreigner—as land to own forever, and I will be their God.” ");
INSERT INTO engfbv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God told Abraham, “Your part is to keep my agreement—you and your descendants for generations to come. ");
INSERT INTO engfbv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is my agreement with you and your descendants who come after you, the agreement you are to keep: every male among you shall be circumcised. ");
INSERT INTO engfbv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You are to circumcise your foreskin, and this will be the sign of the agreement between me and you. ");
INSERT INTO engfbv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","From now and for all generations to come every male among you who is eight days old must be circumcised. This includes not only your sons but also those born in your household or bought from foreigners. ");
INSERT INTO engfbv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","You must circumcise those born in your household or bought from foreigners as a sign in your bodies of my eternal agreement. ");
INSERT INTO engfbv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Any uncircumcised male who refuses circumcision will be excluded from his people because he has broken my agreement.” ");
INSERT INTO engfbv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Then God told Abraham, “Now about Sarai your wife. Don't call her Sarai any longer. Instead, her name will be Sarah. ");
INSERT INTO engfbv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her and I promise to give you a son by her. I will bless her so that she will become the mother of nations, and kings will be among her descendants.” ");
INSERT INTO engfbv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham bowed down with his face to the ground. But inside he was laughing, asking himself, “How on earth could I have a son at the age of one hundred? How could Sarah have a child when she is ninety?” ");
INSERT INTO engfbv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham said to God, “May Ishmael always live under your blessing!” ");
INSERT INTO engfbv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","“No, it's your wife Sarah who is going to have a son for you!” God replied. “You are to call him Isaac. I will keep my agreement with him and his descendants as an eternal agreement. ");
INSERT INTO engfbv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Now about Ishmael. I heard what you said, and I will also bless him. I will make sure he has a great many descendants. He will be the father of twelve princes, and I will make him into a great nation. ");
INSERT INTO engfbv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But it's with Isaac that I will keep my agreement, the son Sarah will give birth to about this time next year.” ");
INSERT INTO engfbv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","When God had finished speaking with Abraham he left him. ");
INSERT INTO engfbv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","That day Abraham circumcised his son Ishmael as well as all those born in his household or purchased, in fact every male among the members of Abraham's household, just as God had told him. ");
INSERT INTO engfbv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was 99 when he was circumcised, ");
INSERT INTO engfbv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","and his son Ishmael was thirteen. ");
INSERT INTO engfbv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Both Abraham and his son Ishmael were circumcised on the same day. ");
INSERT INTO engfbv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","All the males in Abraham's household, including those born in his household or purchased from foreigners, were circumcised with him. ");
INSERT INTO engfbv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","The Lord appeared to Abraham at the oaks of Mamre. Abraham was sitting at the entrance to his tent as the day became really hot. ");
INSERT INTO engfbv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","He looked up and all of a sudden he saw three men standing there. As soon as he saw them, he ran over to meet them and bowed low to the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","He said, “Sir, if you please, don't continue your journey without spending some time here with me, your servant. ");
INSERT INTO engfbv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Let me have some water brought so you can wash your feet and rest under the tree. ");
INSERT INTO engfbv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Also let me bring some food so you can get your strength back before you go on your way, now that you've come to visit me here.” “That would be fine,” they answered. “Please do as you've suggested.” ");
INSERT INTO engfbv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham hurried back to the tent and told Sarah, “Quick! Make some bread using three large measures of the best flour. Knead the dough and bake the bread.” ");
INSERT INTO engfbv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then Abraham ran to the cattle herd and chose a good, young calf and gave it to his servant who quickly killed and cooked it. ");
INSERT INTO engfbv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Then he took some yogurt, milk, and the cooked meat, and placed the food in front of them. He stood nearby under a tree while they ate. ");
INSERT INTO engfbv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Where is your wife Sarah?” they asked him. “Over there, inside the tent,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Then one said, “I promise you that I will come back to visit you about this time next year, and your wife Sarah will have a son.” Sarah was listening, hiding just inside the entrance to the tent behind him. ");
INSERT INTO engfbv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham and Sarah were old, getting on in years. Sarah was well past the age of having children. ");
INSERT INTO engfbv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah was laughing inside, saying to herself, “Now that I'm old and worn out, how would I experience pleasure? My husband is old too!” ");
INSERT INTO engfbv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","The Lord asked Abraham, “Why did Sarah laugh and ask, ‘How could it possibly be true that I'll have a child now I'm so old?’ ");
INSERT INTO engfbv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Is anything too difficult for the Lord to do? I will come back next year when I said I would, in the spring, and Sarah will have a son.” ");
INSERT INTO engfbv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah denied it because she was afraid, claiming, “I didn't laugh.” “Yes, you did laugh,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Then the men left. They looked down on Sodom and headed in that direction. Abraham accompanied them part of the way. ");
INSERT INTO engfbv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Then the Lord said, “Should I keep from Abraham what I'm going to do? ");
INSERT INTO engfbv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham will definitely become a great and powerful nation, and all the nations on earth will be blessed through him. ");
INSERT INTO engfbv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I've chosen him so that he will teach his sons and their families to follow the way of the Lord by doing what is right and good, so that I, the Lord, can do for Abraham what I promised.” ");
INSERT INTO engfbv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Then the Lord said, “There are many complaints made against Sodom and Gomorrah because they sin so blatantly. ");
INSERT INTO engfbv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I'm going to see if these complaints that have reached me are completely true. I'll know if they're not.” ");
INSERT INTO engfbv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","The two men turned and went towards Sodom, but the Lord stayed there with Abraham. ");
INSERT INTO engfbv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham came to him and asked: “Are you really going to wipe out the good people along with the wicked? ");
INSERT INTO engfbv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What if there are fifty good people in the town? Are you still going to wipe it out despite the fifty good people there? ");
INSERT INTO engfbv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","No, you can't do something like that! You can't kill the good with the wicked, otherwise you would be treating the good and the wicked in the same way. You can't do that! Isn't the Judge of all the earth going to do the right thing?” ");
INSERT INTO engfbv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","“If I find fifty good people in Sodom, I'll spare the whole town because of them,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","“Since I've started, let me go on speaking to my Lord, even though I'm nothing but dust and ashes,” Abraham continued. ");
INSERT INTO engfbv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","“What if there are forty-five good people, just five less? Are you still going to wipe out the whole town just because there are five fewer people?” “I won't destroy it if I find forty-five,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham spoke up again and he asked the Lord, “What if only forty can be found?” “I won't do it for the sake of the forty,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","“My Lord, please don't get angry with me,” Abraham went on. “Let me ask this—what if only thirty were found?” “I won't do it if I find thirty,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","“I admit I've been very bold to speak to my Lord like this,” Abraham said. “What if only twenty are found there?” “I won't do it for the sake of the twenty,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","“Please don't get angry with me, my Lord,” Abraham said. “Just let me ask one more thing. What if only ten are found there?” “I won't destroy it for the sake of the ten,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","The Lord left once he had finished speaking with Abraham, and Abraham went home. ");
INSERT INTO engfbv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","The two angels arrived at Sodom in the evening. Lot happened to be sitting at the entrance to Sodom, and when he saw them he stood up to meet them, and bowed low with his face to the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Sirs, please come and stay with me for the night,” he said. “You can wash your feet and then be on your way early in the morning.” They replied, “No, it's fine. We'll spend the night here in the square.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But Lot insisted, and they went with him to his house. He made them a meal and baked bread for them to eat. ");
INSERT INTO engfbv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","But they hadn't even gone to bed before the men of Sodom, young and old, from every part of town, came and surrounded the house. ");
INSERT INTO engfbv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","They shouted out to Lot, “Where are the men who came to stay with you tonight? Bring them out here to us so we can have sex with them.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went out to talk to them in the doorway, closing the door behind him. ");
INSERT INTO engfbv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“My friends, please don't do such an evil thing! ");
INSERT INTO engfbv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Listen, I've got two virgin daughters. Let me bring them out to you, and you can do to them whatever you want, but please don't do anything to these men. It's my responsibility to look after them.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“Out of our way!” they shouted. “Who do you think you are, coming to live here and now trying to judge us? We'll do even worse things to you than we were going to do to these men!” They rushed forward at Lot and tried to break down the door. ");
INSERT INTO engfbv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the men inside reached out and grabbed Lot, dragged him inside, and slammed the door shut. ");
INSERT INTO engfbv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then they made all the men in the doorway, young and old, suddenly go blind so they couldn't find the door. ");
INSERT INTO engfbv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","The two men asked Lot, “Is there anyone else here who's part of your family—sons-in-law, or sons or daughters, or anyone else in the town? If there are, make sure they leave, ");
INSERT INTO engfbv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","because we are about to destroy this place. The complaints that have reached the Lord about its people have become so bad that he has sent us to destroy it.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot went immediately to speak to the men who were engaged to marry his daughters. “Get up quickly and leave,” he said, “because the Lord is about to destroy the town!” But they thought it was just a joke. ");
INSERT INTO engfbv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","At dawn, the angels begged Lot to be quick, telling him, “Hurry up! Leave right now with your wife and your two daughters here, otherwise you'll be wiped out when the city is punished.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","But Lot hesitated. The men grabbed his hand, and those of his wife and two daughters, and dragged them along, leaving them outside the town. The Lord was kind to them to do this. ");
INSERT INTO engfbv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","As soon as they were outside, one of the men said, “Run for your lives! Don't look back, and don't stop anywhere in the valley! Run to the mountains otherwise you'll be destroyed!” ");
INSERT INTO engfbv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","“Please sir, not that!” Lot replied. ");
INSERT INTO engfbv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","“If you don't mind, since you have already been so kind to me by saving my life, don't make me run to the mountains—I just can't make it. The destruction will overtake me and I'll die! ");
INSERT INTO engfbv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, there's a town nearby that's close enough to run to, and it's so small. Please let me run there—it's really very small. It would save my life.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","“Fine—I'll do as you ask,” he replied. “I won't destroy this town you've mentioned. ");
INSERT INTO engfbv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","But hurry up and run there quickly, because I can't do anything until you get there.” (This is why the town was called Zoar.) ");
INSERT INTO engfbv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","The sun had already risen by the time Lot reached Zoar. ");
INSERT INTO engfbv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Then the Lord rained down fire and burning sulfur from the sky on Sodom and Gomorrah. ");
INSERT INTO engfbv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","He completely destroyed the towns and all their inhabitants, the whole valley and everything growing there. ");
INSERT INTO engfbv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","But Lot's wife, who was lagging behind, looked back, and she turned into a pillar of salt. ");
INSERT INTO engfbv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham got up early the next morning and went back to where he had stood before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","He looked down at Sodom and Gomorrah and the whole valley floor, and saw the land burning, sending up smoke like from a furnace. ");
INSERT INTO engfbv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","When God destroyed the towns of the valley he didn't forget the promise he made Abraham, and he saved Lot from the destruction of the towns where Lot was living. ");
INSERT INTO engfbv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot was afraid to stay in Zoar, so he left town and went to live in a cave in the mountains with his two daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Sometime later the older daughter said to the younger one, “Our father is growing old, and there's no men left to give us children like everyone does. ");
INSERT INTO engfbv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Come on, let's get our father drunk with wine and sleep with him so we can keep his family line going.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","So they got their father drunk with wine that night. The older daughter went and slept with him, and he didn't notice when she lay down or when she got up. ");
INSERT INTO engfbv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day the older daughter said to the younger one, “Last night I slept with our father. Let's get him drunk with wine again tonight and you can go and sleep with him so we can keep his family line going.” ");
INSERT INTO engfbv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So once again that night they got their father drunk with wine and the younger daughter went and slept with him, and he didn't notice when she lay down or when she got up. ");
INSERT INTO engfbv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","This is how both Lot's daughters became pregnant by their father. ");
INSERT INTO engfbv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The older daughter had a son, and she called him Moab. He is the ancestor of the Moabites of today. ");
INSERT INTO engfbv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger daughter had a son too, and she called him Ben-ammi. He is the ancestor of the Ammonites of today. ");
INSERT INTO engfbv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham traveled towards the Negev, staying between Kadesh and Shur. After that he moved on to live in Gerar. ");
INSERT INTO engfbv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","During his time there, when Abraham told people about his wife Sarah, he said, “She's my sister.” So Abimelech, king of Gerar, sent for Sarah and took her to become one of his wives. ");
INSERT INTO engfbv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But God appeared to Abimelech in a dream and told him, “Listen! You're going to die because the woman you've taken is already married—she has a husband.” ");
INSERT INTO engfbv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelech hadn't touched Sarah, and he asked, “Lord, do you kill good people? ");
INSERT INTO engfbv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Didn't Abraham tell me himself, ‘She's my sister,’ and didn't Sarah also say, ‘He's my brother’? I did this in all innocence—my conscience is clear!” ");
INSERT INTO engfbv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","God told him in the dream, “Yes, I know you did this in all innocence, so I prevented you from sinning against me. That's why I didn't let you touch her. ");
INSERT INTO engfbv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Send the man's wife back to him. He's a prophet. He will pray for you, and you will live. But if you don't send her back to him, you should know for sure that you and all your family will die.” ");
INSERT INTO engfbv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelech got up early in the morning and called all his servants together. He explained everything that had happened, and they were all terrified. ");
INSERT INTO engfbv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech summoned Abraham and asked him “What have you done to us? How have I wronged you that you should treat me like this, bringing this terrible sin on me and my kingdom? You've done things to me that no one should ever do!” ");
INSERT INTO engfbv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Then Abimelech asked Abraham “What were you thinking when you did this?” ");
INSERT INTO engfbv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","“Well, I thought to myself, ‘Nobody respects God in this place. They'll kill me just to get my wife,’” Abraham replied. ");
INSERT INTO engfbv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","“Anyway, she really is my sister, the daughter of my father but not my mother, and I married her. ");
INSERT INTO engfbv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Since my God made me move far away from my family home, I told her, ‘If you really love me, then wherever you go with me you must tell people: He's my brother.’” ");
INSERT INTO engfbv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Then Abimelech gave Abraham gifts of sheep, cattle, and male and female slaves, and returned his wife Sarah to him. ");
INSERT INTO engfbv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech told him, “Look over my land. You can choose to live anywhere you like.” ");
INSERT INTO engfbv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelech also told Sarah, “Notice that I'm giving your brother a thousand pieces of silver. This is to compensate you for the wrong done to you in the eyes of everyone with you, and to make sure that your name is publicly cleared.” ");
INSERT INTO engfbv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Then Abraham prayed to God, and God healed Abimelech, his wife, and his female slaves, so that they could have children again. ");
INSERT INTO engfbv_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","For the Lord had made all the women unable to have children because Abraham's wife, Sarah, had been taken. ");
INSERT INTO engfbv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","The Lord came to help Sarah as he'd said he would. The Lord did for Sarah what he'd promised. ");
INSERT INTO engfbv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","She became pregnant and had a son for Abraham when he was old, at the exact time God said she would. ");
INSERT INTO engfbv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham named their son Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circumcised him when Isaac was eight days old, following God's command. ");
INSERT INTO engfbv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was 100 when Isaac was born. ");
INSERT INTO engfbv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah declared, “God has made me laugh, and all those who hear about this will laugh with me.” ");
INSERT INTO engfbv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","She also said, “Would anyone have announced to Abraham that Sarah was going to have children to nurse? But now I have had a son for Abraham even when he was old!” ");
INSERT INTO engfbv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","The baby grew up, and on the day Isaac was weaned Abraham held a large feast. ");
INSERT INTO engfbv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","But Sarah noticed that Ishmael, Hagar the Egyptian's son she'd had for Abraham, was making fun of Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","So she went to Abraham and told him, “You have to get rid of this slave woman and this son of hers! A slave woman's son is not going to be one of your heirs and inherit together with my son Isaac!” ");
INSERT INTO engfbv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham felt very bad about it because Ishmael was his son. ");
INSERT INTO engfbv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God told Abraham, “Don't feel bad about the boy and the slave woman. Do whatever Sarah tells you, because it's through Isaac that your descendants will be counted. ");
INSERT INTO engfbv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Don't worry—I will also make the son of the slave woman into a nation because he's your son.” ");
INSERT INTO engfbv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham got up early the next morning. He packed up some food and a skin of water which he gave to Hagar, putting them on her shoulder. Then he sent her and the boy away. She left and wandered through the Desert of Beersheba. ");
INSERT INTO engfbv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","When the water ran out, she left the boy under one of the bushes. ");
INSERT INTO engfbv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","She went and sat down some way off, a few hundred yards away, saying, “I can't bear to watch my son die!” As she sat down she burst into tears. ");
INSERT INTO engfbv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God heard the boy's cries, and the angel of God called to Hagar from heaven and asked her, “What's the matter, Hagar? Don't be afraid! God has heard the boy crying from where he is. ");
INSERT INTO engfbv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Get up, go over and help the boy up, and encourage him, for I will make him into a great nation.” ");
INSERT INTO engfbv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","God opened her eyes and she saw a well nearby. She went and filled the skin with water and gave the boy a drink. ");
INSERT INTO engfbv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God blessed Ishmael and he grew up, living in the desert. He became a skilled archer. ");
INSERT INTO engfbv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","He lived in the Desert of Paran. His mother chose a wife for him from the land of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Around this time Abimelech came with Phicol, the commander of his army, to see Abraham. “God blesses you in everything you do,” Abimelech said. ");
INSERT INTO engfbv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","“So swear to me right here and now that you won't betray me, my children, or my descendants. In the same way I've proved I'm trustworthy to you, do the same to me and my country where you're currently living.” ");
INSERT INTO engfbv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“I so swear,” Abraham replied. ");
INSERT INTO engfbv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Then Abraham raised an issue with Abimelech of a well that Abimelech's servants had taken by force. ");
INSERT INTO engfbv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","“I don't know who did this, and you didn't mention it before. I haven't heard anything about it until today,” Abimelech responded. ");
INSERT INTO engfbv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Then Abraham gave Abimelech some of his sheep and cattle, and the two of them made an agreement. ");
INSERT INTO engfbv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham also separated out seven female lambs from the flock. ");
INSERT INTO engfbv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","“What are these seven female lambs for that you've separated from the flock?” Abimelech asked. ");
INSERT INTO engfbv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","“I'm giving you these seven female lambs in return for your admission that I dug this well,” Abraham replied. ");
INSERT INTO engfbv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","That's why he called the place Beersheba, because the two of them swore an oath to each other. ");
INSERT INTO engfbv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","After making the agreement at Beersheba, Abimelech and Phicol the commander of his army left and went home to the country of the Philistines. ");
INSERT INTO engfbv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a tamarisk tree in Beersheba and there he worshiped the Lord, the Eternal God. ");
INSERT INTO engfbv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham lived in the country of the Philistines for a long time. ");
INSERT INTO engfbv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Sometime later God tested Abraham. He called out to him, “Abraham!” “I'm here,” Abraham replied. ");
INSERT INTO engfbv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","God told him, “Go with your son, your only son, the one you love, to the land of Moriah and sacrifice him there as a burnt offering on one of the mountains that I'll tell you about.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham got up early in the morning and saddled up his donkey. He took two servants and Isaac with him and went to cut firewood for the burnt offering. Then he left with them to go to the place God had told him about. ");
INSERT INTO engfbv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","After traveling for three days Abraham could see the place in the distance. ");
INSERT INTO engfbv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","He told his servants, “Wait here with the donkey while I go with the boy and worship God. Then we'll return.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham had Isaac carry the wood for the burnt offering, while he carried the fire and the knife, and they walked up together. ");
INSERT INTO engfbv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac said to Abraham, “Father?” “Yes, my son?” Abraham replied. “Well, we have the fire and the wood, but where's the lamb for the burnt offering?” Isaac asked. ");
INSERT INTO engfbv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“God will provide the lamb for the burnt offering, my son,” Abraham replied, and they went on walking up together. ");
INSERT INTO engfbv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","When they arrived at the place where God had told him to go, Abraham built an altar and placed the wood on it. Then he bound his son Isaac and placed him on the altar on top of the wood. ");
INSERT INTO engfbv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham picked up the knife, ready to slaughter his son. ");
INSERT INTO engfbv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","But the angel of the Lord shouted to him from heaven, “Abraham! Abraham!” “Yes, I'm here,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","The angel said, “Don't touch the boy! Don't do anything to him, because now I know that you truly do what God tells you. You didn't refuse to give me your son, your only son.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham looked up and saw a ram caught by its horns in some bushes. He brought the ram over and sacrificed it as a burnt offering in place of his son. ");
INSERT INTO engfbv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham called the place “The Lord will Provide.” That's still a saying people use today: “the Lord will provide on his mountain.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The angel of the Lord shouted again to Abraham from heaven, ");
INSERT INTO engfbv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“I swear by myself, says the Lord, that because you have done this and didn't refuse to give me your son, your only son, ");
INSERT INTO engfbv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","you can be sure that I will bless you and give you many descendants. They will be as numerous as the stars of heaven and the sand of the seashore, and they will conquer their enemies. ");
INSERT INTO engfbv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","All the nations of the earth will be blessed by your descendants because you did what I told you.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham returned to his servants, and they went back together to Beersheba where Abraham was living. ");
INSERT INTO engfbv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Sometime later, Abraham was told, “Milcah has had sons for your brother Nahor.” ");
INSERT INTO engfbv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz was the firstborn, then his brother Buz, Kemuel (who became the ancestor of Arameans), ");
INSERT INTO engfbv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, and Bethuel. ");
INSERT INTO engfbv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Bethuel was Rebekah's father.) Milcah had these eight sons for Abraham's brother Nahor. ");
INSERT INTO engfbv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","In addition, Reumah his concubine had Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engfbv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived to be 127, ");
INSERT INTO engfbv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","and then she died at Kiriath-arba (or Hebron) in the land of Canaan. Abraham went in to mourn her death and to weep over her. ");
INSERT INTO engfbv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Then Abraham got up from beside his wife's body and went to talk with the leaders of the Hittites. ");
INSERT INTO engfbv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am a foreigner, a stranger living among you,” he said. “Please let me buy a burial site so I can bury my dead wife.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The Hittites answered Abraham, telling him, ");
INSERT INTO engfbv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Listen, my lord, you are a highly-respected prince among us. Choose the very best of our burial sites to bury your dead. None of us will say no to you.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham got up and bowed low before the Hittites, the local people, ");
INSERT INTO engfbv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","and said to them, “If you agree to help me bury my dead, listen to my proposal. Could you please ask Ephron, son of Zohar, ");
INSERT INTO engfbv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","to sell me the cave of Machpelah that belongs to him, down at the end of his field. I'm willing to pay him the full price here in your presence so I can have my own burial site.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron the Hittite was sitting there among his people. He replied to Abraham in the presence of the Hittites who were there at the town gate. ");
INSERT INTO engfbv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, my lord,” he said. “Please listen to me. I give you the field and the cave that is there. I give it to you and my people are my witnesses. Please go and bury your dead.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham bowed low before the local people, ");
INSERT INTO engfbv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","and said to Ephron so everyone could hear, “Please listen to me. I will pay the price for the field. Take the money and let me go and bury my dead there.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron replied to Abraham, telling him, ");
INSERT INTO engfbv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“My lord, please listen to me. The land is worth four hundred pieces of silver. But what's that between us? Go and bury your dead.” ");
INSERT INTO engfbv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham accepted Ephron's offer. Abraham weighed out and gave to Ephron the four hundred pieces of silver he'd mentioned, using the standard weights used by merchants, and with the Hittites acting as witnesses. ");
INSERT INTO engfbv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","So the property was legally transferred. It comprised Ephron's field in Machpelah near Mamre, both the field and the cave there, as well as all the trees in the field, and all the area up to the existing boundaries. ");
INSERT INTO engfbv_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","This all became Abraham's property, and the transaction was witnessed by the Hittites who were there at the town gate. ");
INSERT INTO engfbv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Then Abraham went and buried Sarah his wife in the cave in the field at Machpelah near Mamre (or Hebron) in the land of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ownership of the field and the cave there was transferred from the Hittites to Abraham to serve as his burial place. ");
INSERT INTO engfbv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham by now was old, really old, and the Lord had blessed him in every possible way. ");
INSERT INTO engfbv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","At that time Abraham told his oldest servant who was in charge of his whole household, “Put your hand under my thigh, ");
INSERT INTO engfbv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","and swear an oath by the Lord, the God of heaven and the God of earth, that you won't arrange for my son to marry any daughter of the these Canaanite people that I'm living among. ");
INSERT INTO engfbv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Instead, go to my homeland where my relatives live, and find a wife there for my son Isaac.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","“What if the woman refuses to come back with me to this country?” the servant asked. “Should I take your son back to the country you came from?” ");
INSERT INTO engfbv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","“No, you mustn't take my son back there,” Abraham replied. ");
INSERT INTO engfbv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","“The Lord, the God of heaven, took me from my family home and my own country. He spoke to me and swore an oath to me in which he promised, ‘I will give this land to your descendants.’ He is the one who will send his angel ahead of you so that you can find a wife there for my son. ");
INSERT INTO engfbv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","However, if the woman refuses to return here with you, then you are released from this oath. But make sure you don't take my son back there.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","The servant put his hand under the thigh of his master Abraham and swore an oath to do as he had been told. ");
INSERT INTO engfbv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Then the servant arranged for ten of his master's camels to carry all kinds of valuable gifts from Abraham and left for the town of Nahor in Aram-naharaim. ");
INSERT INTO engfbv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Arriving in the evening, he had the camels kneel down by the spring that was outside the town. This was the time when women went out to fetch water. ");
INSERT INTO engfbv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","He prayed, “Lord, the God of my master Abraham, please let me be successful today, and please show your faithfulness to my master Abraham. ");
INSERT INTO engfbv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Look, I'm standing here beside this spring, and the young women of the town are coming to get water. ");
INSERT INTO engfbv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","May it happen like this. The young woman that I ask, ‘Please hold your water jar so I can have a drink,’ and she replies, ‘Please drink, and I'll give your camels water too’ —may she be the one you've chosen as a wife for your servant Isaac. This way I'll know that you've shown your faithfulness to my master.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","He hadn't even finished praying when he saw Rebekah coming to get water, carrying her water jar on her shoulder. She was the daughter of Bethuel, son of Milkah. Milkah was the wife of Abraham's brother Nahor. ");
INSERT INTO engfbv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","She was very beautiful, a virgin—no one had slept with her. She went down to the spring, filled her jar, and came back up. ");
INSERT INTO engfbv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","The servant ran over to meet her and asked, “Please let me drink a few sips of water from your jar.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","“Please drink, my lord,” she replied. She quickly lifted the jar down from her shoulder and held it for him to drink. ");
INSERT INTO engfbv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","After she finished giving him a drink, she said, “Let me get water for your camels too until they've had enough.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","She quickly emptied her jar into the trough and ran back to the spring to get more water. She brought enough for all his camels. ");
INSERT INTO engfbv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","The man observed her in silence to see if the Lord had made his journey successful or not. ");
INSERT INTO engfbv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Once the camels had finished drinking, he gave her a gold nose-ring and two heavy gold bracelets for her wrists. ");
INSERT INTO engfbv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Then he asked her, “Whose daughter are you? Also could you tell me, is there room in your father's house for us to spend the night?” ");
INSERT INTO engfbv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","She replied, “I'm the daughter of Bethuel, the son of Milcah and Nahor.” Then she added, “We have plenty of straw and food for the camels, ");
INSERT INTO engfbv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","and yes, we have room for you to spend the night.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The man kneeled down and bowed in worship to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Thank you Lord, the God of my master Abraham,” he prayed. “You have not forgotten your commitment and faithfulness to my master. And Lord, you have led me directly to the home of my master's relatives!” ");
INSERT INTO engfbv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","She ran to her mother's house and told her family what had happened. ");
INSERT INTO engfbv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah had a brother named Laban, and he ran out to meet the man who had remained at the spring. ");
INSERT INTO engfbv_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","He'd noticed the nose-ring and the bracelets she was wearing, and he'd heard his sister Rebekah explaining, “This is what the man told me.” When he arrived the man was still there, standing with his camels beside the spring. ");
INSERT INTO engfbv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Please come home with me, you who are blessed by the Lord,” said Laban. “What are you standing out here for? I've got a room at home ready for you, and a place for the camels to stay.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So the man went home with him. Laban unloaded the camels and gave them straw and food to eat. He also provided water for the man to wash his feet, as well as for the men who were with him. ");
INSERT INTO engfbv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Then Laban had food brought in. But the man told him, “I'm not going to eat until I've explained why I'm here.” “Please explain,” Laban replied. ");
INSERT INTO engfbv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“I'm Abraham's servant,” the man began. ");
INSERT INTO engfbv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“The Lord has blessed my master so much, and now he is a wealthy and powerful man. The Lord has given him sheep and cattle, silver and gold, male and female servants, and camels and donkeys. ");
INSERT INTO engfbv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","His wife Sarah has had a son for my master even in her old age, and my master has given him everything he owns. ");
INSERT INTO engfbv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master made me swear an oath, saying, ‘You must not arrange for my son to marry any daughter of the Canaanite people in whose land I'm living. ");
INSERT INTO engfbv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Instead, go to my family home where my relatives live, and find a wife there for my son Isaac.’ ");
INSERT INTO engfbv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I said to my master, ‘What if the woman refuses to come back with me?’ ");
INSERT INTO engfbv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","He told me, ‘The Lord, in whose presence I have lived my life, will send his angel with you, and he will make your journey successful—you will find a wife for my son from my relatives, from my father's family. ");
INSERT INTO engfbv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","You will be released from the oath you swear to me if, when you go to my family, they refuse to let her return with you.’ ");
INSERT INTO engfbv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Today when I arrived at the spring, I prayed, Lord, God of my master Abraham, please let the journey I have taken be successful. ");
INSERT INTO engfbv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Look, I'm standing here beside this spring. May it happen like this. If a young woman comes to get water, and I say, ‘Please give me a few sips of water to drink,’ ");
INSERT INTO engfbv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","and she says to me, ‘Please drink, and I'll get water for your camels too’ —may she be the one you've chosen as a wife for your servant Isaac.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“I hadn't even finished praying silently when I saw Rebekah coming to get water, carrying her water jar on her shoulder. She went down to the spring to get water, and I said to her, ‘Please give me a drink.’ ");
INSERT INTO engfbv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lifted the jar down from her shoulder and she said, ‘Please drink, and I'll get water for your camels too.’ So I drank, and she got water for the camels. ");
INSERT INTO engfbv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","I asked her, ‘Whose daughter are you?’ She replied, ‘I'm the daughter of Bethuel, the son of Milcah and Nahor.’ So I put the ring in her nose, and the bracelets on her wrists. ");
INSERT INTO engfbv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Then I kneeled down and bowed in worship to the Lord. I thanked the Lord, the God of my master Abraham, for he led me directly to find my master's niece for his son. ");
INSERT INTO engfbv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","So please tell me now, will you show commitment and faithfulness to my master? Please tell me yes or no so I can decide what to do next.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban and Bethuel replied, “Clearly all this is from the Lord, so we can't argue one way or the other. ");
INSERT INTO engfbv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah's here, you can take her and leave. She can become the wife of your master's son, as the Lord has decided.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","As soon as Abraham's servant heard their decision, he bowed down in worship to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then he unpacked silver and gold jewelry and expensive clothes and gave them to Rebekah. He also gave valuable presents to her brother and her mother. ");
INSERT INTO engfbv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","He and the men with him ate and drank, and spent the night there. When they got up in the morning, he said, “Let me leave now and go home to my master.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","But her brother and her mother said, “Let her stay with us for another ten days or so. She can leave after that.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","“Please don't delay me,” he told them. “The Lord has made my journey successful, so let me leave and go back to my master.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“Let's call Rebekah and find out what she wants to do,” they suggested. ");
INSERT INTO engfbv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","They called Rebekah in and asked her, “Do you want to go with this man now?” “Yes, I'll go,” she replied. ");
INSERT INTO engfbv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they let Laban's sister Rebekah leave with Abraham's servant and his men, together with the woman who had nursed her as a child. ");
INSERT INTO engfbv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","They asked a blessing on her, saying, “Our dear sister, may you become the mother to thousands and thousands of descendants, and may they conquer their enemies.” ");
INSERT INTO engfbv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her servant girls got on the camels. They followed Abraham's servant and left. ");
INSERT INTO engfbv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Meanwhile Isaac, who was living in the Negev, had just come back from Beer-lahai-roi. ");
INSERT INTO engfbv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","He went out into the fields one evening to think things over. He looked into the distance and saw camels coming. ");
INSERT INTO engfbv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah was also keeping a look out. When she saw Isaac, she got down from her camel. ");
INSERT INTO engfbv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","She asked the servant, “Who is this walking through the fields to meet us?” “He's my master, Isaac,” he replied. So she put on her veil to cover herself. ");
INSERT INTO engfbv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant told Isaac everything he'd done. ");
INSERT INTO engfbv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac took Rebekah into his mother Sarah's tent, and he married her. He loved her, and she brought him comfort after his grief over his mother's death. ");
INSERT INTO engfbv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham married another wife; her name was Keturah. ");
INSERT INTO engfbv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She had the following sons: Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engfbv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan was the father of Sheba and Dedan. The descendants of Dedan were the Asshurites, the Letushites, and the Leummites. ");
INSERT INTO engfbv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. These were all descendants of Keturah. ");
INSERT INTO engfbv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham left everything he owned to Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","But while he was still alive, he gave gifts to the sons of his concubines and sent them to live in the east, well away from Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham lived to be 175 ");
INSERT INTO engfbv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","when he breathed his last and died at a good old age. He had lived a full life, and now he joined his forefathers in death. ");
INSERT INTO engfbv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","His sons Isaac and Ishmael buried him in the cave of Machpelah near Mamre, in the field that had belonged to Ephron, son of Zohar, the Hittite. ");
INSERT INTO engfbv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","This was the field Abraham had bought from the Hittites. Abraham was buried there with his wife Sarah. ");
INSERT INTO engfbv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After Abraham's death, God blessed his son Isaac, who was living near Beer-lahai-roi. ");
INSERT INTO engfbv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","This is the genealogy of Abraham's son Ishmael. His mother Hagar was Sarah's Egyptian slave. ");
INSERT INTO engfbv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These were the names of the sons of Ishmael according to their family genealogy: Nebaioth (firstborn), Kedar, Adbeel, Mibsam, ");
INSERT INTO engfbv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engfbv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engfbv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These were the sons of Ishmael, and these became the names of the places where they lived and camped—the twelve family rulers of their tribes. ");
INSERT INTO engfbv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived to be 137. Then he breathed his last and died, and joined his forefathers in death. ");
INSERT INTO engfbv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ishmael's descendants inhabited the region from Havilah to Shur, near the border of Egypt in the direction of Asshur. They were forever fighting with one other. ");
INSERT INTO engfbv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","The following is the genealogy of Abraham's son Isaac. Abraham was the father of Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","When Isaac was 40 he married Rebekah, the daughter of Bethuel the Aramean from Paddan-aram and the sister of Laban the Aramean. ");
INSERT INTO engfbv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac prayed to the Lord for help on behalf of his wife because she couldn't have children. The Lord answered his prayer and she became pregnant. ");
INSERT INTO engfbv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","The twin babies inside her struggled with each other. So she asked the Lord, “Why is this happening to me?” ");
INSERT INTO engfbv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","“You have two nations inside you,” the Lord replied. “You're going to give birth to two peoples who will compete against each other. One will be stronger than the other; the older one will be the servant of the younger one.” ");
INSERT INTO engfbv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When the time came she gave birth to twins. ");
INSERT INTO engfbv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first baby to be born was red, and covered with hair like a coat. So they named him Esau. ");
INSERT INTO engfbv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Then his twin brother was born, holding on to Esau's heel. So he was named Jacob. Isaac was 60 when they were born. ");
INSERT INTO engfbv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","The boys grew up and Esau became a skilled hunter, at home in the countryside. Jacob was quiet and liked to stay at home in the tents. ");
INSERT INTO engfbv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac loved Esau because he brought him tasty wild game to eat, while Rebekah loved Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day Jacob was cooking some stew when Esau got back from the countryside, tired out and starving hungry. ");
INSERT INTO engfbv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","“Give me some of that red stew,” Esau told Jacob. “I'm absolutely starving!” (That's how Esau got his other name, “Edom,” meaning “red.”) ");
INSERT INTO engfbv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","“First sell me your rights as the firstborn son,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Look! I'm dying here! What use are the rights of the firstborn to me?” Esau declared. ");
INSERT INTO engfbv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","“First you have to swear to me,” Jacob demanded. So Esau swore an oath selling his rights of the firstborn to Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave Esau some bread and lentil stew. He ate and drank, and then he got up and left. By doing this Esau showed how little he cared for his rights as the firstborn son. ");
INSERT INTO engfbv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","There was a famine in the country—not the one that happened before in Abraham's time, but a later one. So Isaac moved to Gerar in the territory of Abimelech, king of the Philistines. ");
INSERT INTO engfbv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","The Lord appeared to Isaac and told him, “Don't go to Egypt—live in the country that I tell you to. ");
INSERT INTO engfbv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay here in this country. I will be with you and I will bless you, because I'm going to give you and your descendants all these lands. I will keep the solemn promise that I swore to Abraham your father. ");
INSERT INTO engfbv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will make your descendants as numerous as the stars of heaven and I will give them all these lands. All the nations of the earth will be blessed by your descendants, ");
INSERT INTO engfbv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","because Abraham did what I told him, and kept my requirements, my commands, my regulations, and my laws.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac stayed in Gerar. ");
INSERT INTO engfbv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","When the men there asked him about his wife, he told them, “She's my sister,” because he was afraid. He said to himself, “If I say she's my wife, the men here will kill me to get Rebekah, because she's so beautiful.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","But later on, after he'd been there a while, Abimelech, king of the Philistines, happened to look out the window and saw Isaac lovingly fondling his wife Rebekah. ");
INSERT INTO engfbv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech sent for Isaac and complained. “From what I saw she's clearly your wife!” he said. “Why on earth did you say, ‘She's my sister’?” “Because I thought I'd be killed because of her,” Isaac replied. ");
INSERT INTO engfbv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“Why would you do this to us?” Abimelech asked. “One of the men here might have slept with your wife, and you would have made us all guilty!” ");
INSERT INTO engfbv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelech issued orders to all the people, warning them, “Anyone who touches this man or his wife will be executed.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac sowed grain that year, and the Lord blessed him with a harvest that was a hundred times what he planted. ");
INSERT INTO engfbv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","He became a rich man, and his wealth steadily increased until he was very rich. ");
INSERT INTO engfbv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He owned many flocks of sheep and herds of cattle, as well as many slaves. He had so much that the Philistines became jealous of him. ");
INSERT INTO engfbv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So the Philistines used dirt to block up all the wells his father Abraham's servants had dug. ");
INSERT INTO engfbv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Then Abimelech told Isaac, “You have to leave our country, because you've become much too powerful for us.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac moved away and set up his tents in the Gerar Valley where he settled down. ");
INSERT INTO engfbv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","He unblocked the wells that had been dug in his father Abraham's time—the ones the Philistines had blocked after the death of Abraham. He gave them the same names his father had. ");
INSERT INTO engfbv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac's servants also dug a new well in the valley and found spring water. ");
INSERT INTO engfbv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But the herdsmen from Gerar argued with Isaac's herdsmen, claiming, “That's our water!” So Isaac named the well, “Argument,” because they argued with him. ");
INSERT INTO engfbv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","He had another well dug, and they argued over that one too. He named the well, “Opposition.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","So they moved on from there and he had another well dug. This time there was no argument so he named the well, “Freedom,” saying, “Now the Lord has given us freedom to expand and be successful in this land.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","From there he moved on to Beersheba. ");
INSERT INTO engfbv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","That night the Lord appeared to him and said, “I am the God of Abraham your father. Don't be afraid, for I am with you. I will bless you and give you many descendants for the sake of my servant Abraham.” ");
INSERT INTO engfbv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaac built an altar and worshiped the Lord. He also set up his tent, and his servants dug a well there. ");
INSERT INTO engfbv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sometime later Abimelech came from Gerar to see Isaac, along with Ahuzzath his advisor, and Phicol the commander of his army. ");
INSERT INTO engfbv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","“Why have you come to see me?” Isaac asked them. “Previously you hated me and told me to leave!” ");
INSERT INTO engfbv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","“Now we realize that the Lord is with you,” they replied. “So we agreed that we should make a sworn agreement with you. ");
INSERT INTO engfbv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","You'll promise not to harm us in the same way we've never hurt you. You'll agree that we've always treated you well, and when we asked you to leave we did so kindly. Now look at how the Lord is blessing you!” ");
INSERT INTO engfbv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac had a special meal prepared to celebrate the agreement. They ate and drank, ");
INSERT INTO engfbv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","and got up early in the morning and they each swore oaths to one other. Then Isaac sent them on their way, and they left in peace. ");
INSERT INTO engfbv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","It was that very day when Isaac's servants who'd been digging a well came and told him, “We've found water!” ");
INSERT INTO engfbv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","So Isaac named the well, “Oath,” and that's why the name of the town is “Well of the Oath” (Beersheba) to this day. ");
INSERT INTO engfbv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was 40, he married Judith, daughter of Beeri the Hittite, as well as Basemath, daughter of Elon the Hittite. ");
INSERT INTO engfbv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","They caused Isaac and Rebekah a great deal of grief. ");
INSERT INTO engfbv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac was old and going blind. He called for Esau, his oldest son, and said, “My son.” “I'm here,” Esau replied. ");
INSERT INTO engfbv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“I'm old now,” said Isaac, “I may die soon, who knows? ");
INSERT INTO engfbv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So please take your bow and arrows and go hunting in the countryside for some meat for me. ");
INSERT INTO engfbv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Make me that tasty food that I love and bring it to me to eat, so I can bless you before I die.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebekah heard what Isaac told his son Esau. So when Esau left to go hunting in the countryside for wild game, ");
INSERT INTO engfbv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah told her son Jacob, “Listen! I heard your father tell your brother, ");
INSERT INTO engfbv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Get me some wild game and make me some tasty food so I can eat it and then bless you in the presence of the Lord before I die.’ ");
INSERT INTO engfbv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Now then, my son, listen to me and do exactly what I tell you. ");
INSERT INTO engfbv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go to the flock and bring me two nice young goats. I'll cook them and make the tasty food your father loves. ");
INSERT INTO engfbv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then you take it to your father to eat, so he can bless you in the presence of the Lord before he dies.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","“But listen,” Jacob replied to his mother Rebekah, “my brother Esau is a hairy man, and I'm a smooth man. ");
INSERT INTO engfbv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Maybe my father will notice when he touches me. Then it will look like I'm deceiving him and I'll bring a curse down on myself instead of a blessing.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","“Let the curse fall on me, my son,” his mother replied. “Just do what I tell you. Go and get the young goats for me.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went and got them and took them to his mother, and she made some tasty food, the way his father loved. ");
INSERT INTO engfbv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Then Rebekah went and got her older son Esau's best clothes that she had at home and put them on Jacob her younger son. ");
INSERT INTO engfbv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She put the goatskins on his hands and on the smooth part of his neck. ");
INSERT INTO engfbv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then she handed her son Jacob the tasty food and the bread she'd made. ");
INSERT INTO engfbv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","He went in to see his father, and called out, “My father, I'm here.” “Which son are you?” Isaac asked. ");
INSERT INTO engfbv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“It's me Esau, your firstborn son,” Jacob told his father. “I did what you told me. So please sit up and eat some of my wild game meat so you can bless me.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","“How did you find an animal so fast, my son?” Isaac asked. “Because the Lord your God sent it my way,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","“Come over here so I can touch you, my son,” Isaac told Jacob, “so I can tell if you're really my son Esau or not.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob went over to his father Isaac, who touched him and said, “It's Jacob's voice but Esau's hands.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac didn't realize it was really Jacob because his hands were hairy like his brother Esau's, so Isaac got ready to bless him. ");
INSERT INTO engfbv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“It's really you, my son Esau?” he asked again. “Yes, it's me,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Then he said, “My son, bring me some of your wild game to eat, so that I may give you my blessing.” Jacob brought some for him to eat, as well as some wine for him to drink. ");
INSERT INTO engfbv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Afterwards he said to Isaac, “Come here and kiss me, my son.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So Jacob went over and kissed him, and Isaac could smell the clothes Jacob was wearing. So he went ahead with the blessing, saying to himself, “See—the smell of my son is like the smell of a field that the Lord has blessed.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“May God use the dew of heaven and fertile land to give you rich harvests of grain and new wine! ");
INSERT INTO engfbv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","May the people of different nations serve you and bow down to you. May you rule over your relatives, and may they bow down to you. May everyone who curses you be cursed, and may everyone who blesses you be blessed.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","After Isaac finished blessing Jacob—in fact Jacob had just left his father—Esau returned from his hunting trip. ");
INSERT INTO engfbv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","He had also made some tasty food, and took it to his father. Esau said to Isaac, “Sit up, my father, and eat some of my wild game so you can bless me.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Who are you?” Isaac asked him. “I'm your son, your firstborn son, Esau,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac started to shake all over and asked, “So who was it who went hunting game and then brought it to me? I ate it all before you came back and I blessed him. His blessing will remain.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard his father's words, he cried out in great anger and bitterness, and pleaded with his father, “Please bless me too, my father!” ");
INSERT INTO engfbv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","But Isaac replied, “Your brother came and deceived me—he stole your blessing!” ");
INSERT INTO engfbv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“Isn't he well named—Jacob the deceiver!” said Esau. “He's deceived me twice. First he took my birthright, and now he's stolen my blessing! Haven't you kept a blessing for me?” ");
INSERT INTO engfbv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac replied to Esau. “I have made him ruler over you, and have said that all his relatives will be his servants. I have declared that he will be well supplied with grain and new wine. So what is left that I can do for you, my son?” ");
INSERT INTO engfbv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","“Do you only have one blessing, my father?” Esau asked. “Please bless me too!” Then Esau began to cry very loudly. ");
INSERT INTO engfbv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Then his father Isaac declared, “Listen! You will live far away from fertile land, far from the dew of heaven that falls from above. ");
INSERT INTO engfbv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will make a living by using your sword, and you will be your brother's servant. But when you rebel, you will throw off his yoke from your neck.” ");
INSERT INTO engfbv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","From then on Esau hated Jacob because of his father's blessing. Esau said to himself, “Soon the time will come when I'll mourn my father's death. Then I'll kill my brother Jacob!” ");
INSERT INTO engfbv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","However, Rebekah found out what Esau was saying, so she sent for Jacob. “Look,” she told him, “your brother Esau is making himself feel better by making plans to kill you. ");
INSERT INTO engfbv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So, my son, listen carefully to what I tell you. Leave immediately and go to my brother Laban in Haran. ");
INSERT INTO engfbv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him for a while until your brother's anger cools down. ");
INSERT INTO engfbv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Once he's cooled down and forgets what you did to him, I'll send for you to come back. Why should I lose both of you in a single day?” ");
INSERT INTO engfbv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah went and told Isaac, “I'm so sick of these Hittite women—they're ruining my life! If Jacob also marries a Hittite woman like them, one of the local people, I'd rather die!” ");
INSERT INTO engfbv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac called for Jacob and blessed him. “Don't marry a Canaanite woman,” he ordered him. ");
INSERT INTO engfbv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","“Leave right away and go to Paddan-aram, to the home of Bethuel, your mother's father. Find yourself a wife there—a daughter of Laban, your mother's brother. ");
INSERT INTO engfbv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","God Almighty bless you and may your descendants be so numerous that you become the ancestor of many nations. ");
INSERT INTO engfbv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","May he grant you and your descendants the same blessing he gave to Abraham, so that you may take over the land where you now live as a foreigner, the land God gave to Abraham.” ");
INSERT INTO engfbv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob on his way. He traveled to Paddan-aram, to Laban, son of Bethuel the Aramean. Laban was the brother of Rebekah, the mother of Jacob and Esau. ");
INSERT INTO engfbv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau found out that Isaac had blessed Jacob and had sent him to Paddan-aram to find a wife there, and that when he blessed him he ordered him, “Don't marry a Canaanite woman.” ");
INSERT INTO engfbv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","He also discovered that Jacob had done what his father and mother told him and had left for Paddan-aram. ");
INSERT INTO engfbv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","This made Esau realize how much his father disliked Canaanite women. ");
INSERT INTO engfbv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So he went to Ishmael's family and married an additional wife—Mahalath, the daughter of Ishmael, Abraham's son, the sister of Nebaioth. ");
INSERT INTO engfbv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","In the meantime Jacob had set off from Beersheba on his way to Haran. ");
INSERT INTO engfbv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","He arrived after sunset at a particular place and stopped there for the night. He picked up a stone, put it under his head, lay down and went to sleep. ");
INSERT INTO engfbv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","He dreamed he saw a stairway that started on earth, and the top reached all the way into heaven. He saw God's angels going up and down on it. ");
INSERT INTO engfbv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Then he saw the Lord standing over him, who said, “I am the Lord, the God of your father Abraham, and the God of Isaac. I'm giving you and your descendants the land you're lying on. ");
INSERT INTO engfbv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Your descendants will be as numerous as the dust of the earth, and will spread out west and east, and north and south. Everyone on earth will be blessed by your descendants. ");
INSERT INTO engfbv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Listen! I am with you and will take care of you wherever you go. I will bring you back to this country. I won't leave you because I'm going to do what I've promised you.” ");
INSERT INTO engfbv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","When Jacob woke up he said to himself, “The Lord is right here, in this place, and I didn't realize it!” ");
INSERT INTO engfbv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","He became frightened and said, “This is a scary place! It must be the house of God and the entrance to heaven.” ");
INSERT INTO engfbv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","When Jacob got up in the morning he took the stone he'd put under his head and set it upright as a stone pillar and poured some olive oil on it. ");
INSERT INTO engfbv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","He named the place “Bethel,” (previously it was called Luz). ");
INSERT INTO engfbv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob also made a solemn promise, saying, “God, if you will be with me, and take care of me on my journey, and give me food to eat and clothes to wear ");
INSERT INTO engfbv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","so I can return safely to my father's home, then you Lord will be my God. ");
INSERT INTO engfbv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","This stone pillar that I've set up will be the house of God, and I will give you one tenth of all you give me.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob went quickly on his way, and arrived in the land of the eastern people. ");
INSERT INTO engfbv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","As he looked around he saw a well in a field with three flocks of sheep lying down beside it, waiting to be given water. A large stone covered the top of the well. ");
INSERT INTO engfbv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","The usual practice was that once all the flocks had arrived, the shepherds would roll away the stone from the well and give their sheep water. Then they would put the stone back again. ");
INSERT INTO engfbv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob asked them, “My brothers, where are you from?” “We're from Haran,” they replied. ");
INSERT INTO engfbv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“Do you know Laban, Nahor's grandson?” he asked. “Yes, we know him,” they replied. ");
INSERT INTO engfbv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“How is he?” he asked. “He's well,” they replied. “Look! In fact here's his daughter Rachel coming with the sheep right now.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“Look, there's still plenty of daylight left,” said Jacob. “It's too early to round up the sheep yet. Why not let them drink so they can go back to grazing?” ");
INSERT INTO engfbv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“We can't do that until all the flocks have arrived,” they told him. “Then we roll away the stone from the well and let the sheep drink.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While he was still talking with them Rachel arrived with the flock she was looking after for her father. ");
INSERT INTO engfbv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","When Jacob saw Rachel, the daughter of Laban, his mother's brother, he went over and rolled away the stone from the well so Laban's sheep could drink. ");
INSERT INTO engfbv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then Jacob kissed Rachel and wept for joy. ");
INSERT INTO engfbv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","(He had told her that he was a relative of her father, Rebekah's son.) She ran and told her father what had happened. ");
INSERT INTO engfbv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","As soon as Laban heard the news about Jacob he ran out to meet him. He hugged him and kissed him, and took him home. After Jacob had explained everything to Laban, ");
INSERT INTO engfbv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban told him, “No question about it—you're my own flesh and blood!” Jacob stayed with Laban for a month. ");
INSERT INTO engfbv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","One day Laban said to him, “You're my relative so you shouldn't be working for me for nothing! Tell me, what should I pay you?” ");
INSERT INTO engfbv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban had two daughters. The older one was Leah, and the younger one was Rachel. ");
INSERT INTO engfbv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah had kind eyes, but Rachel had a shapely figure and beautiful looks. ");
INSERT INTO engfbv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob was in love with Rachel so he promised Laban, “I'll do seven years work for you for Rachel, your younger daughter.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","“Well it's better for me to give her to you than anyone else,” Laban replied. “So stay here and work for me.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob worked for Laban for seven years, but to him they seemed like just a few days because he really loved her. ");
INSERT INTO engfbv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Then Jacob said to Laban, “I've completed the time we agreed. Now give me your daughter to be my wife.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban organized a wedding banquet and invited everyone around to come. ");
INSERT INTO engfbv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","But once it was dark Laban brought his daughter Leah to Jacob, and he slept with her. ");
INSERT INTO engfbv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban also arranged for his servant Zilpah to be Leah's personal maid.) ");
INSERT INTO engfbv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","When morning came, he saw it was Leah! He went to Laban and asked angrily, “What have you done to me? It was for Rachel that I worked for you! Why have you deceived me?” ");
INSERT INTO engfbv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","“Here we don't give the younger daughter in marriage before the firstborn,” Laban replied. ");
INSERT INTO engfbv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“Finish this week of wedding celebrations and then I'll give you the other daughter as well, as long as you work another seven years for me.” ");
INSERT INTO engfbv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob agreed. He finished the week of wedding celebrations for Leah, and then Laban gave Jacob his daughter Rachel as his wife as well. ");
INSERT INTO engfbv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban also arranged for his servant Bilhah to be Rachel's personal maid.) ");
INSERT INTO engfbv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","So Jacob slept with Rachel as well, and he loved Rachel more than Leah. He worked for Laban another seven years for Rachel. ");
INSERT INTO engfbv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","When the Lord saw that Leah wasn't loved he helped Leah to have children, but not Rachel. ");
INSERT INTO engfbv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah became pregnant, and had a son she named Reuben, for she said, “The Lord saw how much I was suffering and now my husband will love me!” ");
INSERT INTO engfbv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Then Leah became pregnant again, and had another son. She said, “The Lord has heard that I'm not loved so he gave me this son.” So she named him Simeon. ");
INSERT INTO engfbv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leah became pregnant for the third time, and had another son. She said, “Finally my husband will be attached to me because now I've given him three sons.” That's why he was named Levi. ");
INSERT INTO engfbv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Once again Leah became pregnant and had another son. She named him Judah, for she said, “Now I can really praise the Lord!” After that she had no more children. ");
INSERT INTO engfbv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","When Rachel realized she was unable to give Jacob any children she was jealous of her sister. She complained to Jacob, “I'll die if you don't give me children!” ");
INSERT INTO engfbv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob became angry with Rachel and told her, “Am I God? Do you think I'm the one stopping you having children?” ");
INSERT INTO engfbv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","“Here's my personal maid Bilhah,” Rachel replied. “Sleep with her and she can have children for me so I'll have a family too.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","She gave her personal maid Bilhah to him as a wife and Jacob slept with her. ");
INSERT INTO engfbv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah became pregnant and had a son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel said, “God has judged in my favor! He listened to me and gave me a son.” So she named him Dan. ");
INSERT INTO engfbv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rachel's personal maid Bilhah became pregnant again and had a second son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel said, “I've had a hard struggle with my sister, but I've won.” So she named him Naphtali. ");
INSERT INTO engfbv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah realized she wasn't having any more children, so she gave her personal maid Zilpah to Jacob as a wife. ");
INSERT INTO engfbv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpah had a son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “I'm really fortunate!” So she named him Gad. ");
INSERT INTO engfbv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leah's personal maid Zilpah became pregnant again and had a second son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “I'm so happy, and the other women will say I'm happy too!” So she named him Asher. ");
INSERT INTO engfbv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","At the time of the wheat harvest Reuben found some mandrake plants when he was out in the fields. He took them back to his mother Leah. Rachel asked Leah, “Please give me some of the mandrakes your son found.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","“Aren't you satisfied with stealing my husband?” Leah replied. “Are you going to take my son's mandrakes too?” “Fine, he can sleep with you tonight if you give me some mandrakes in return,” Rachel responded. ");
INSERT INTO engfbv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","When Jacob came in from the fields that evening, Leah went out to meet him. “You have to sleep with me because I've paid for you with my son's mandrakes,” she told him. So he slept with her that night. ");
INSERT INTO engfbv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God heard Leah's request, and she became pregnant and had a fifth son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah said, “The Lord has rewarded me for giving my personal maid to my husband.” So she named him Issachar. ");
INSERT INTO engfbv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Then Leah became pregnant again and had a sixth son for Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah said, “God has given me a good gift. Now my husband will honor me because I've given him six sons.” So she named him Zebulun. ");
INSERT INTO engfbv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Later she had a daughter she named Dinah. ");
INSERT INTO engfbv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God paid attention to Rachel and listened to her appeals, and helped her to have children. ");
INSERT INTO engfbv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She became pregnant and had a son. “God has removed my disgrace,” she said. ");
INSERT INTO engfbv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","She named him Joseph, saying, “May the Lord give me an additional son.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Once Rachel had given birth to Joseph, Jacob said to Laban, “Let me leave so I can return to my home and my own country. ");
INSERT INTO engfbv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and children because I worked for you to have them. Let me go now because you know very well how much work I've done for you.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","“Please be so kind as to stay,” Laban replied, “because I have discovered that the Lord has blessed me because of you.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Then Laban continued, “Tell me how much to pay you and I'll give it to you.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","“You certainly know how much work I've done for you, and how well your flocks have done under my care. ");
INSERT INTO engfbv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","You hardly had anything before I arrived, but now you have so much! The Lord has blessed you through what I've done. When am I going to be able to provide for my own family?” ");
INSERT INTO engfbv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“Well, what do you propose I give you?” Laban asked again. “You don't have to give me anything,” Jacob replied. “If you want to do something for me, then how about this: I'll go on looking after your flocks, making sure they're fed. ");
INSERT INTO engfbv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Let me go through your flocks today and take all the sheep that are speckled or spotted, and all the dark ones, as well as all the speckled and spotted goats. They'll be my wages. ");
INSERT INTO engfbv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","In the future you'll be able to prove that I've been honest. When you check my flock, any goats that don't have speckles or spots, or any sheep that aren't dark will be considered stolen from you.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“Very good,” Laban agreed. “We'll do as you say.” ");
INSERT INTO engfbv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","However, the same day Laban went and removed all the striped and spotted male goats, all the speckled and spotted female goats, and all the dark sheep. He had his sons look after them and sent them away— ");
INSERT INTO engfbv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","a three day journey between them and Jacob, while Jacob was looking after the rest of Laban's flocks. ");
INSERT INTO engfbv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Then Jacob cut some sticks from poplar, almond, and plane trees that had white wood under the bark. He peeled off some of the bark, making the sticks look streaked with white. ");
INSERT INTO engfbv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","He put the sticks he'd peeled in the water troughs where the flocks came to drink because that's where they mated. ");
INSERT INTO engfbv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","The flocks mated in front of the sticks and gave birth to young that were streaked, speckled, and spotted. ");
INSERT INTO engfbv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separated all these ones out. Then he made his flock face towards those in Laban's flock that were streaked and dark. This is the way he kept his flocks apart from Laban's flock. ");
INSERT INTO engfbv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","When the strong females were ready to breed, Jacob put the sticks in the troughs where the flocks could see them when they mated. ");
INSERT INTO engfbv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","He didn't do this for the weaker females. The weaker ones went to Laban, and the strong ones went to Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","In this way Jacob became an extremely rich man with large flocks, and many male and female slaves, camels, and donkeys. ");
INSERT INTO engfbv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob found out that Laban's sons were saying, “Jacob has taken everything that belonged to our father. All the wealth he has actually came from our father.” ");
INSERT INTO engfbv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob also noticed that Laban was treating him differently to the way he had before. ");
INSERT INTO engfbv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","The Lord told Jacob, “Go back to the country of your forefathers, to your family home. I will be with you.” ");
INSERT INTO engfbv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob sent for Rachel and Leah, telling them to come and meet him out in the fields where he was with his flock. ");
INSERT INTO engfbv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","“I've noticed that your father is treating me differently to the way he did before,” he told them. “But the God of my father will be with me. ");
INSERT INTO engfbv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You both know very well how hard I worked for your father. ");
INSERT INTO engfbv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","But he's been cheating me—he's reduced my wages ten times! However, God hasn't let him hurt me. ");
INSERT INTO engfbv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","If he said, ‘You can have the speckled ones as your wages,’ then the whole flock had speckled young. If he said, ‘You can have the streaked ones as your wages,’ then the whole flock had streaked young. ");
INSERT INTO engfbv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","This is how God took your father's livestock and gave them to me. ");
INSERT INTO engfbv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","During the time the flock was breeding I had a dream where I saw that the male goats mating with the flock were all streaked, speckled, or spotted. ");
INSERT INTO engfbv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Then in the dream the angel of the Lord spoke to me and said, ‘Jacob!’ I replied, ‘I'm here.’ ");
INSERT INTO engfbv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","He told me, ‘Take a look and you'll see that all the male goats mating with the flock are streaked, speckled or spotted, for I've been watching everything that Laban has been doing to you. ");
INSERT INTO engfbv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God of Bethel, where you poured olive oil on the stone pillar and made a solemn promise to me. Now get ready to leave this land and go back to your homeland.’” ");
INSERT INTO engfbv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","“There's nothing for us to inherit from our father's estate anyway,” Rachel and Leah replied. ");
INSERT INTO engfbv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","“He treats us like foreigners because he sold us to you, and now he's spent all that money. ");
INSERT INTO engfbv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","All the wealth that God has taken from him belongs to us and our children, so do whatever God has told you to do!” ");
INSERT INTO engfbv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","So Jacob got ready. He helped his children and his wives onto the camels, ");
INSERT INTO engfbv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","and drove all his livestock in front of him. He took with him all his possessions and livestock he'd gained during his time in Paddan-aram, and left to go back to his father in the country of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","While Laban was away from home shearing his sheep, Rachel stole the household idols that belonged to her father. ");
INSERT INTO engfbv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob also deceived Laban the Aramean by not informing him that he was going to run away. ");
INSERT INTO engfbv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","So Jacob left in a hurry with everything he had, crossed the Euphrates River, and headed towards the hill country of Gilead. ");
INSERT INTO engfbv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Three days later Laban found out that Jacob had run away. ");
INSERT INTO engfbv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Taking some of his relatives with him, he chased after Jacob and caught up with him seven days later in the hill country of Gilead. ");
INSERT INTO engfbv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","But during the night God came to Laban in a dream and told him, “Watch what you say to Jacob. Don't try to persuade him to come back, and don't threaten him either.” ");
INSERT INTO engfbv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob had set up his tents in the hill country of Gilead when Laban caught up with him, so Laban and his relatives did the same. ");
INSERT INTO engfbv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","“Why did you deceive me like this?” Laban asked Jacob. “You carried off my daughters as if they were some prisoners captured by the sword! ");
INSERT INTO engfbv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you run away in secret, trying to trick me? Why didn't you come and tell me? I would have given you a good send-off, a celebration with singing and the music of tambourines and lyres. ");
INSERT INTO engfbv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","You didn't even let me kiss my grandchildren and daughters goodbye! You've really acted stupidly! ");
INSERT INTO engfbv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I could really punish you badly, but the God of your father spoke to me last night and told me, ‘Watch what you say to Jacob. Don't try to persuade him to come back, and don't threaten him either.’ ");
INSERT INTO engfbv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Clearly you wanted to leave and go back to your family home, but why did you have to steal my idols?” ");
INSERT INTO engfbv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","“I ran away because I was afraid,” Jacob explained to Laban. “I was worried that you would take your daughters from me by force. ");
INSERT INTO engfbv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","As for your idols, anyone you find who has them will die. You can search everything in the presence of our relatives, and if you find I have anything that belongs to you, you can take it.” (Jacob didn't know that Rachel had stolen the household idols.) ");
INSERT INTO engfbv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban searched the tents of Jacob, Leah, and the two personal maids, but didn't find anything. He left Leah's tent and went into Rachel's tent. ");
INSERT INTO engfbv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel had put the household idols in a camel's saddlebag and was sitting on it. Laban carefully searched the whole tent but couldn't find them. ");
INSERT INTO engfbv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","She said to her father, “Sir, please don't get upset with me for not standing up in your presence, but I have my period.” He looked everywhere but didn't find the idols. ");
INSERT INTO engfbv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob got angry with Laban and confronted him, saying, “What crime am I guilty of? What wrong have I done to you that you've come hunting me down? ");
INSERT INTO engfbv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","You've searched through all my possessions. Did you find anything belonging to you? If you did, bring it out here before my relatives and yours so they can decide who's right! ");
INSERT INTO engfbv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I've worked for you for these past twenty years. During that time none of your sheep and goats miscarried, and I haven't eaten a single ram from your flock. ");
INSERT INTO engfbv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","If any of them were killed by wild animals, I never even brought you the carcass to prove the loss—I bore the loss myself. But you on the other hand always made me compensate you for any animals that were stolen, whether at night or in broad daylight. ");
INSERT INTO engfbv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Whether it was sweating in the heat of the day, or freezing in the cold of the night when I couldn't sleep, I went on working for you for twenty years in your home. ");
INSERT INTO engfbv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I worked fourteen years for your two daughters, and six more years with your flocks. You reduced my wages ten times! ");
INSERT INTO engfbv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","If it weren't for the God of my father, the God of Abraham, the awesome God of Isaac, who took care of me, you would have dismissed me with nothing. But God saw my suffering, how hard I worked, and he condemned you last night.” ");
INSERT INTO engfbv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban replied, “These are my daughters and these are my children and these are my flocks! In fact, everything you see here is mine! However, what can I do now about my daughters and their children? ");
INSERT INTO engfbv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So let's make a solemn agreement between you and I, and it will be a witness to our mutual commitment.” ");
INSERT INTO engfbv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob took a stone and set it upright as a pillar. ");
INSERT INTO engfbv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Then he told his relatives, “Go and collect some stones.” They all made a pile of stones and then sat beside it to eat a meal. ");
INSERT INTO engfbv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban called it Jegar-sahadutha, while Jacob called it Galeed. ");
INSERT INTO engfbv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban announced, “This pile of stone serves as a witness between me and you.” This is why it was called Galeed. ");
INSERT INTO engfbv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","It was also called Mizpah, for as Laban said, “May the Lord keep a close eye on both of us when we're not together. ");
INSERT INTO engfbv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","If you treat my daughters badly or marry more wives in addition to them, God will see what you do even if no one else finds out!” ");
INSERT INTO engfbv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Then Laban told Jacob, “Look at this pile of stones and this pillar that I have set up as a memorial of the agreement between you and me. ");
INSERT INTO engfbv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","They also act as a witness to our solemn promises to each other: I will not come past them to attack you; and you will not come past them to attack me. ");
INSERT INTO engfbv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham and the God of Nahor—the God of our forefathers—be the one to judge between us in any dispute.” Jacob in turn made his solemn promise in the name of the awesome God of his father Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then he offered a sacrifice on the mountain and invited all his relatives to eat a meal there. They spent the night on the mountain. ");
INSERT INTO engfbv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban got up early in the morning and kissed his grandchildren and his daughters goodbye. He blessed them, and then left to go back home. ");
INSERT INTO engfbv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob went on his way and some angels of God came to meet him. ");
INSERT INTO engfbv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When he saw them he said, “This must be God's camp!” He named the place “Two Camps.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","He sent messengers on ahead to meet his brother Esau who was living in the region of Seir in the country of Edom. ");
INSERT INTO engfbv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He told them, “This is what you are to say to my lord Esau. Your servant Jacob sends you this message. I've been staying with Laban up till now, ");
INSERT INTO engfbv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","and I have cattle and donkeys and sheep and goats, and male and female slaves. I've sent these messengers to explain this to you my lord, hoping you'll be pleased to see me.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers returned to Jacob and told him, “Your brother Esau is coming to meet you with 400 armed men!” ");
INSERT INTO engfbv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","When Jacob heard this, he was absolutely terrified. He split all the people with him, along with the sheep, goats, cattle, and camels, into two groups, ");
INSERT INTO engfbv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","saying to himself, “If Esau comes and destroys one group, the other one can get away.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob prayed, “God of my grandfather Abraham, God of my father Isaac! Lord, you were the one who told me, ‘Return to your own country and your family home, and I will treat you well.’ ");
INSERT INTO engfbv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","I don't deserve all the trustworthy love and faithfulness you have shown your servant. I crossed the Jordan years ago with just my walking stick, and now I have two large camps. ");
INSERT INTO engfbv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Please save me from my brother; defend me from Esau! I'm terrified that he's coming to attack me, my wives, and my children. ");
INSERT INTO engfbv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","You yourself told me, ‘I will definitely treat you well. I will make your descendants as numerous as the sand of the seashore—too many to count.’” ");
INSERT INTO engfbv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob stayed the night there. Then he picked out animals as a gift to his brother Esau: ");
INSERT INTO engfbv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 female goats, 20 male goats; 200 ewes, 20 rams; ");
INSERT INTO engfbv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 female camels with their young, 40 cows, 10 bulls; 20 female donkeys, 10 male donkeys. ");
INSERT INTO engfbv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He put his servants in charge of each of the separate herds and told them, “Go on ahead of me, and keep a good distance between the herds.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","He gave these instructions to those with the first herd: “When my brother Esau meets you and asks, ‘Who is your master, and where are you going, and whose are these animals with you?’ ");
INSERT INTO engfbv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","you are to say to him, ‘Your servant Jacob sends these as a gift to my lord Esau, and he's following us.’” ");
INSERT INTO engfbv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","He gave the same instructions to those with the second and third and all the subsequent herds, telling them, “This is what you are to say to Esau when he meets you. ");
INSERT INTO engfbv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You must also tell him, ‘Your servant Jacob is right behind us.’” Jacob said to himself, “Maybe by sending these gifts on ahead Esau won't be angry with me and when I meet him he'll be kind to me.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So the gifts went on ahead while Jacob spent the night at the camp. ");
INSERT INTO engfbv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","He got up during the night and took his two wives and the two personal maids and his eleven sons and crossed the Jabbok River at the ford. ");
INSERT INTO engfbv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","After helping them cross he also sent over everything that belonged to him. ");
INSERT INTO engfbv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","But Jacob stayed there alone. A man came and wrestled with him until dawn. ");
INSERT INTO engfbv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man realized he couldn't beat Jacob, he hit Jacob's hip socket and put it out of joint as he wrestled with him. ");
INSERT INTO engfbv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then the man said, “Let me go because it's almost dawn.” “I won't let you go unless you bless me,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“What's your name?” the man asked. “Jacob,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","“Jacob will no longer be your name,” said the man. “Instead you will be called Israel, because you fought with God and with men and you won.” ");
INSERT INTO engfbv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","“Please tell me your name,” Jacob asked. “Why do you ask me my name?” the man replied. Then he blessed Jacob there. ");
INSERT INTO engfbv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob named the place Peniel, saying, “I saw God face to face and I'm still alive!” ");
INSERT INTO engfbv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","The sun came up as Jacob left Peniel, limping along because of his damaged hip. ");
INSERT INTO engfbv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","(That's why, even today, Israelites don't eat the thigh tendon attached to the hip socket, because that's where the man hit Jacob's hip socket.) ");
INSERT INTO engfbv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob saw Esau in the distance, coming towards him with four hundred men. So he split up the children between Leah, Rachel and the two personal maids. ");
INSERT INTO engfbv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","He placed the two personal maids with their children first, then Leah and her children, and Rachel and Joseph last. ");
INSERT INTO engfbv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Then Jacob went ahead of them and bowed low to the ground seven times before approaching his brother. ");
INSERT INTO engfbv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau ran over to him and hugged him. He put his arms around his neck and kissed him. The two of them wept. ");
INSERT INTO engfbv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Then Esau looked around at the women and children. “Who are these people with you?” he asked. “They are the children God graciously gave your servant,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","The personal maids and their children came over and bowed down. ");
INSERT INTO engfbv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Then Leah and her children came over and bowed down. Lastly Joseph and Rachel came over and bowed down. ");
INSERT INTO engfbv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“What were all the livestock for that I met on the way?” Esau asked. “They're a gift to you my lord so you'd treat me well,” Jacob answered. ");
INSERT INTO engfbv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","“I have more than enough, my brother! You keep what you have,” said Esau. ");
INSERT INTO engfbv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","“No, please!” Jacob insisted. “If you're happy with me, then please accept the gift I'm giving you. Now I've seen your face again it's like seeing the face of God, and you have welcomed me so kindly! ");
INSERT INTO engfbv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Please take the gift I've brought to you because God has treated me so well and I have so much.” So Esau accepted it. ");
INSERT INTO engfbv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Let's get on our way,” Esau said. “I'll go ahead of you.” ");
INSERT INTO engfbv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","“My lord can see that the children are weak,” Jacob responded. “Also, the goats, sheep, and cattle are nursing their young, and if I push them too hard, they'll all die. ");
INSERT INTO engfbv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","You go on, my lord, and your servant will come along slowly, walking with the children, and I'll meet you at Seir.” ");
INSERT INTO engfbv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“Fine, but let me leave some of my men with you,” said Esau. “You're very kind, but there's no need to do that,” Jacob replied. ");
INSERT INTO engfbv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So Esau started on his way back to Seir that day. ");
INSERT INTO engfbv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","But Jacob headed to Succoth, where he built himself a house and shelters for the livestock. That's why the place is called Succoth. ");
INSERT INTO engfbv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Later Jacob continued his journey from Paddan-aram. He arrived safely at Shechem in the country of Canaan where he camped outside the town. ");
INSERT INTO engfbv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","He bought the plot of ground where he was camping from the sons of Hamor, the founder of Shechem, for 100 pieces of money. ");
INSERT INTO engfbv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","He built an altar there and called it El-Elohe-Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah, Jacob and Leah's daughter, went to visit some of the local women. ");
INSERT INTO engfbv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Shechem, son of Hamor the Hivite, the ruler of that area, saw her. He grabbed hold of her and raped her. ");
INSERT INTO engfbv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","However, then he fell deeply in love with Dinah and tried to get her to love him too. ");
INSERT INTO engfbv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","He went and asked his father, “Get this young girl for me so I can marry her.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob found out that Shechem had violated his daughter Dinah, but as his sons were away looking after the flocks in the fields he didn't say anything until they came home. ");
INSERT INTO engfbv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","In the meantime Hamor, Shechem's father, arrived to talk with Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","When Jacob's sons returned from the fields they were very upset when they heard the news and became extremely angry because Shechem had done something outrageous in Israel by having sex with Jacob's daughter—something that should never be done. ");
INSERT INTO engfbv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor told them, “My son Shechem is very much in love with your daughter and your sister Dinah. Please allow him to marry her. ");
INSERT INTO engfbv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","In fact we can have more marriages—you can give us your daughters and you can have our daughters. ");
INSERT INTO engfbv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You can live among us and settle down wherever you like. You can go where you want and buy land for yourselves.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Then Shechem himself spoke up, and said to Dinah's father and brothers, “Please accept me and my proposal, and I'll do whatever you ask. ");
INSERT INTO engfbv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","You can set the bride price as high as you like, and I'll pay it along with all the gifts I'll give. Just let me have the girl so I can marry her.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jacob's sons weren't honest when they answered him and his father Hamor because Shechem had violated their sister Dinah. ");
INSERT INTO engfbv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","They told them, “We can't do this! We can't allow our sister to marry a man who's not circumcised. That would bring disgrace on us. ");
INSERT INTO engfbv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","We will only agree to it with this condition: all of you must be circumcised like us. ");
INSERT INTO engfbv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then we will give you our daughters and take your daughters, and we will live among you and become one family. ");
INSERT INTO engfbv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","But if you don't agree with us that you should be circumcised, then we'll take our sister and leave.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor and his son Shechem agreed to what was proposed. ");
INSERT INTO engfbv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","The young man Shechem didn't waste any time in arranging this because he was infatuated with Jacob's daughter, and he was viewed as the most important person in his father's family. ");
INSERT INTO engfbv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor and Shechem went to the town gate and spoke to the other leaders there. ");
INSERT INTO engfbv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These men are our friends,” they told them. “Let's have them live here in our country and allow them to go wherever they want—it's big enough for all of them too. We can take their daughters as wives, and we can give our daughters to them to marry. ");
INSERT INTO engfbv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But they will only agree to this on one condition: they will only join us and become one family if every male among us is circumcised like they are. ");
INSERT INTO engfbv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","If that happens, won't all their livestock and property—all their animals—end up belonging to us? We just have to agree to this and they will come and live among us.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Everyone there at the town gate agreed with Hamor and Shechem so every male in the town was circumcised. ");
INSERT INTO engfbv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Three days later while they were still suffering pain, Simeon and Levi, two of Jacob's sons and Dinah's brothers, came with their swords into the town. Unopposed, they slaughtered every male. ");
INSERT INTO engfbv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","They killed Hamor and Shechem with their swords, took Dinah from Shechem's house, and left. ");
INSERT INTO engfbv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob's other sons arrived, robbed the dead bodies, and looted the town where their sister had been violated. ");
INSERT INTO engfbv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","They took their sheep, goats, cattle, and donkeys. They took whatever was in the town, and in the fields— ");
INSERT INTO engfbv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","all their possessions. They captured all their women and children, and plundered everything in their homes. ");
INSERT INTO engfbv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","But Jacob criticized Simeon and Levi, telling them, “You've just caused me a lot of trouble! You've made me like a bad smell among the people in this country, among the Canaanites and the Perizzites. I only have a few men, and if these people gather to attack me, I and my whole family will be wiped out.” ");
INSERT INTO engfbv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But they replied, “Should we have let him treat our sister like a prostitute?” ");
INSERT INTO engfbv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Then God told Jacob, “Get ready to go to Bethel and live there. Build an altar there to God, who appeared to you when you were running away from your brother Esau.” ");
INSERT INTO engfbv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Jacob told his family and everyone who was with him, “Get rid of the pagan idols you have with you. Purify yourselves and change your clothes. ");
INSERT INTO engfbv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","We have to get ready and go to Bethel so I can build an altar to God who answered me in my time of trouble. He has been with me wherever I went.” ");
INSERT INTO engfbv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","They handed over to Jacob all the pagan idols they had, as well as their earrings, and he buried them under the oak tree at Shechem. ");
INSERT INTO engfbv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","As they left on their journey, the terror of God spread over all the surrounding towns, so nobody tried to retaliate against Jacob's sons. ");
INSERT INTO engfbv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob and everyone with him arrived at Luz (also known as Bethel) in the country of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","He built an altar there and called the place El-Bethel, because that was where God had appeared to him when he was running away from his brother Esau. ");
INSERT INTO engfbv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, Rebekah's nurse, died and was buried under the oak near Bethel. So it was named “the oak of weeping.” ");
INSERT INTO engfbv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","God appeared to Jacob again and blessed him after his return from Paddan-aram. ");
INSERT INTO engfbv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God told him, “Jacob will not be your name any longer. Instead of Jacob your name will be Israel.” So God called him Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Then God said, “I am God Almighty! Reproduce, increase, and you will become a nation—in fact a group of nations—and kings will be among your descendants. ");
INSERT INTO engfbv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","I will give to you and to your descendants the land I also gave to Abraham and Isaac.” ");
INSERT INTO engfbv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Then God left the place where he had been speaking to Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Afterwards Jacob set up a stone pillar where God had spoken with him. He poured out a drink offering on it, and also olive oil. ");
INSERT INTO engfbv_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob called the place Bethel, because he had spoken with God there. ");
INSERT INTO engfbv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Then they moved on from Bethel. While they were still some distance from Ephrath, Rachel went into labor and had great difficulty giving birth. ");
INSERT INTO engfbv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","When she was in the worst birth-pains, the midwife told her, “Don't give up—you have another son!” ");
INSERT INTO engfbv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","But she was dying, and with her last breath she named him Benoni. But his father named him Benjamin. ");
INSERT INTO engfbv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel died and was buried on the way to Ephrath (also known as Bethlehem). ");
INSERT INTO engfbv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob set up a stone memorial over Rachel's grave, and it's still there to this day. ");
INSERT INTO engfbv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel moved on and camped beyond the watch tower at Eder. ");
INSERT INTO engfbv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","During the time he was living there, Reuben went and slept with Bilhah, his father's concubine, and Israel found out about it. These were the twelve sons of Jacob: ");
INSERT INTO engfbv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","The sons of Leah: Reuben (Jacob's firstborn), Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engfbv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","The sons of Rachel: Joseph and Benjamin. ");
INSERT INTO engfbv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","The sons of Rachel's personal maid Bilhah: Dan and Naphtali. ");
INSERT INTO engfbv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","The sons of Leah's personal maid Zilpah: Gad and Asher. These were the sons of Jacob, who were born to him while in Paddan-aram. ");
INSERT INTO engfbv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob returned home to his father Isaac at Mamre, near Kiriath-arba (also known as Hebron), where Abraham and Isaac had lived. ");
INSERT INTO engfbv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived to be 180 ");
INSERT INTO engfbv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","when he breathed his last and died at an old age. He had lived a full life, and now he joined his forefathers in death. His sons Esau and Jacob buried him. ");
INSERT INTO engfbv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","The following is the genealogy of Esau (also known as Edom). ");
INSERT INTO engfbv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau married two Canaanite women: Adah, daughter of Elon the Hittite, and Oholibamah, daughter of Anah, and granddaughter of Zibeon the Hivite. ");
INSERT INTO engfbv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","In addition he married Basemath, daughter of Ishmael and sister of Nebaioth. ");
INSERT INTO engfbv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah had a son for Esau named Eliphaz. Basemath had Reul. ");
INSERT INTO engfbv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah had Jeush, Jalam, and Korah. These were the sons of Esau, who were born to him in Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau took his wives, sons and daughters, and everyone in his household, together with his livestock, all his other animals, and all the possessions he had gained while in Canaan, and went to live in a country far away from his brother Jacob. ");
INSERT INTO engfbv_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","He did this because the land they were living in couldn't support both of them with all their livestock. ");
INSERT INTO engfbv_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esau settled down in the hill country of Seir. ");
INSERT INTO engfbv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","The following is the genealogy of Esau, father of the Edomites, who lived in the hill country of Seir: ");
INSERT INTO engfbv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","These were the names of Esau's sons: Eliphaz, son of Esau's wife Adah, and Reuel, son of Esau's wife Basemath. ");
INSERT INTO engfbv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","The sons of Eliphaz were: Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engfbv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, the concubine of Esau's son Eliphaz, had Amalek for Eliphaz. These were the descendants of Esau's wife Adah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","These were the sons of Reuel: Nahath, Zerah, Shammah, and Mizzah. They were the descendants of Esau's wife Basemath. ");
INSERT INTO engfbv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","These were the sons of Esau's wife Oholibamah, daughter of Anah and granddaughter of Zibeon, whom she had for Esau: Jeush, Jalam, and Korah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These were the tribal leaders of Esau's sons. The tribal leaders of the sons of Eliphaz (Esau's firstborn) were Teman, Omar, Zepho, Kenaz, ");
INSERT INTO engfbv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, and Amalek. They were the tribal leaders of Eliphaz in the country of Edom, and they were the descendants of Adah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","These were the sons of Esau's son Reuel: tribal leaders Nahath, Zerah, Shammah, and Mizzah. They were the tribal leaders descended from Reuel in the country of Edom, and they were the descendants of Esau's wife Basemath. ");
INSERT INTO engfbv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","These were the sons of Esau's wife Oholibamah: tribal leaders Jeush, Jalam, and Korah. They were the tribal leaders descended from Esau's wife Oholibamah, daughter of Anah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","All these were the sons of Esau (also called Edom), and they were their tribal leaders. ");
INSERT INTO engfbv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","These were the sons of Seir the Horite, who were living in the country: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engfbv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. They were the tribal leaders of the Horites, the descendants of Seir in the land of Edom. ");
INSERT INTO engfbv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","The sons of Lotan were Hori and Hemam. Timna was Lotan's sister. ");
INSERT INTO engfbv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","These were the sons of Shobal: Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engfbv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","These were the sons of Zibeon: Aiah and Anah. (This was the Anah who discovered the hot springs in the desert while he was looking after the donkeys of his father Zibeon.) ");
INSERT INTO engfbv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","These were the children of Anah: Dishon and Oholibamah, daughter of Anah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","These were the sons of Dishon: Hemdan, Eshban, Ithran, and Cheran. ");
INSERT INTO engfbv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","These were the sons of Ezer: Bilhan, Zaavan, and Akan. ");
INSERT INTO engfbv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","These were the sons of Dishan: Uz and Aran. ");
INSERT INTO engfbv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These were the tribal leaders of the Horites: tribal leaders Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engfbv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, and Dishan. They were the tribal leaders of the Horites listed according to their tribes in the country of Seir. ");
INSERT INTO engfbv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","These were the kings who ruled in the land of Edom before there was any king who ruled over the Israelites: ");
INSERT INTO engfbv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, son of Beor, ruled in Edom and the name of his town was Dinhabah. ");
INSERT INTO engfbv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, Jobab, son of Zerah from Bozrah, took over as king. ");
INSERT INTO engfbv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham from the land of the Temanites took over as king. ");
INSERT INTO engfbv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Hadad, son of Bedad, took over as king. He was the one who defeated the Midianites in the country of Moab, and the name of his town was Avith. ");
INSERT INTO engfbv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, Samlah from Masrekah took over as king. ");
INSERT INTO engfbv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, Shaul from Rehoboth on the Euphrates took over as king. ");
INSERT INTO engfbv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, Baal-hanan, son of Achbor, took over as king. ");
INSERT INTO engfbv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Baal-hanan, son of Achbor, died, Hadad took over as king. The name of his town was Pau, and his wife's name was Mehetabel, daughter of Matred, daughter of Me-zahab. ");
INSERT INTO engfbv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","These were the names of the tribal leaders descended from Esau, according to their families and where they lived, listed by name: tribal leaders Timna, Alvah, Jetheth, ");
INSERT INTO engfbv_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibamah, Elah, Pinon, ");
INSERT INTO engfbv_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO engfbv_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, and Iram. These were the tribal leaders of Edom, listed according to the places where they lived in the country. Esau was the ancestor of the Edomites. ");
INSERT INTO engfbv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob settled down and lived in Canaan as his father had done. ");
INSERT INTO engfbv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the story of Jacob and his family. Joseph was seventeen, and helped look after the flock with his brothers, the sons of Bilhah and Zilpah, his father's wives. Joseph told his father about some of the bad things his brothers were doing. ");
INSERT INTO engfbv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel loved Joseph more than any of his other sons, because Joseph had been born to him when he was already old. He made a colorful robe with long sleeves for Joseph. ");
INSERT INTO engfbv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","When his brothers noticed that their father loved him more than any of them, they hated him and had nothing good to say about him. ");
INSERT INTO engfbv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph had a dream, and when he told his brothers about it, they hated him even more. ");
INSERT INTO engfbv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Listen to this dream I had,” he told them. ");
INSERT INTO engfbv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“We were tying up bundles of grain out in the fields when all of a sudden my bundle stood up, and your bundles came over and bowed down to it.” ");
INSERT INTO engfbv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","“Do you really think you're going to be our king?” they asked. “Do you honestly believe you're going to rule over us?” They hated him even more because of his dream and how he described it. ");
INSERT INTO engfbv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Then he had another dream and told his brothers about it. “Listen, I had another dream,” he explained. “The sun and moon and eleven stars were bowing down before me.” ");
INSERT INTO engfbv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","He also told his father as well as his brothers, and his father told him off, saying, “What's this dream that you've had? Are we—I and your mother and brothers—really going to come and bow down to the ground before you?” ");
INSERT INTO engfbv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Joseph's brothers became jealous of him, but his father puzzled over the meaning of the dream. ");
INSERT INTO engfbv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","One day Joseph's brothers took their father's flocks to graze near Shechem. ");
INSERT INTO engfbv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel told Joseph, “Your brothers are looking after the sheep near Shechem. Get ready because I want you to go and see them.” “I'll do it,” Joseph replied. ");
INSERT INTO engfbv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","So he told him, “Off you go and see how your brothers and the flocks are doing, and come back and let me know.” So he sent him off. Joseph set out from the Hebron Valley, ");
INSERT INTO engfbv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","and arrived in Shechem. A man there found him wandering about in the field, so he asked him, “What are you looking for?” ");
INSERT INTO engfbv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“I'm looking for my brothers,” Joseph replied. “Can you please tell me where they're looking after the flock?” ");
INSERT INTO engfbv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","“They've already left,” the man replied. “I heard them say, ‘Let's go to Dothan.’” So Joseph followed his brothers and caught up with them at Dothan. ");
INSERT INTO engfbv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","But they saw him coming way off in the distance, and before he got to them, they made plans to kill him. ");
INSERT INTO engfbv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Look, here comes the Lord of Dreams!” they said to each other. ");
INSERT INTO engfbv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Come on, let's kill him and throw him into one of the pits. We'll say that some wild animal has eaten him. Then we'll see what happens to his dreams!” ");
INSERT INTO engfbv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","When Reuben heard all this, he tried to save Joseph from them. ");
INSERT INTO engfbv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“Let's not attack and kill him,” he suggested. “Don't murder him, just throw him into this pit here in the desert. You don't need to be guilty of violence.” Reuben said this so that he could come back later and rescue Joseph from them and take him home to his father. ");
INSERT INTO engfbv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","So when Joseph arrived, his brothers ripped off his robe—the colorful long-sleeved robe he was wearing— ");
INSERT INTO engfbv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","grabbed him and threw him into a pit. (The pit was empty—it didn't have any water in it.) ");
INSERT INTO engfbv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","They were just sitting down to have a meal when they saw a caravan of Ishmaelites coming from Gilead. Their camels were carrying aromatic spices, balm, and myrrh to take to Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","“What's the point of killing our brother?” Judah asked his brothers. “Then we'd have to cover up his death! ");
INSERT INTO engfbv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Instead, why don't we sell him to these Ishmaelites? We don't have to kill him. After all he's our brother, our own flesh and blood.” His brothers agreed. ");
INSERT INTO engfbv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","So when the Ishmaelites (who were traders from Midian) came by, they pulled Joseph out of the pit and sold him to them for twenty pieces of silver. The Ishmaelites took him to Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","When Reuben came back later and looked into the pit, Joseph was gone. He tore his clothes in grief. ");
INSERT INTO engfbv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","He returned to his brothers. “The boy's gone!” he moaned. “What am I going to do now?” ");
INSERT INTO engfbv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","They slaughtered a goat and dipped Joseph's robe in the blood. ");
INSERT INTO engfbv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Then they sent the colorful robe to their father with the message, “We found this. Please examine it and see if it's your son's robe or not.” ");
INSERT INTO engfbv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","His father recognized it right away and said, “This is my son's robe! Some wild animal must have eaten him. Poor Joseph has been ripped to pieces, no doubt about it!” ");
INSERT INTO engfbv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob tore his clothes in grief and dressed in sackcloth. He mourned the death of his son for a long time. ");
INSERT INTO engfbv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All his sons and daughters tried to console him, but he rejected their attempts. “No,” he said, “I will go down into my grave mourning for my son.” So Joseph's father went on weeping for him. ");
INSERT INTO engfbv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","In the meantime the Ishmaelites had arrived in Egypt and had sold Joseph to Potiphar. Potiphar was one of Pharaoh's officers, the captain of the guard. ");
INSERT INTO engfbv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Around this time, Judah left his brothers and set up his tents at Adullam, near to a local man named Hirah. ");
INSERT INTO engfbv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","There Judah happened to see the daughter of a Canaanite man named Shua and married her. He slept with her, ");
INSERT INTO engfbv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","and she became pregnant and had a son he named Er. ");
INSERT INTO engfbv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","She became pregnant again and had a son she named Onan. ");
INSERT INTO engfbv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Then she had another son she named Shelah who was born in Kezib. ");
INSERT INTO engfbv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Much later, Judah arranged for Er, his firstborn son, to marry a woman named Tamar. ");
INSERT INTO engfbv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Er did what was evil in the Lord's sight, so the Lord put him to death. ");
INSERT INTO engfbv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judah told Onan, “Go and sleep with your brother's wife to fulfill the requirements of a brother-in-law to have children on behalf of your brother.” ");
INSERT INTO engfbv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan realized that any children he had wouldn't be his own, so whenever he slept with his brother's wife he made sure she wouldn't become pregnant by withdrawing and spilling his semen on the ground. In this way he prevented any children being born on behalf of his brother. ");
INSERT INTO engfbv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","But what he did was evil in the Lord's sight, so he also put Onan to death. ");
INSERT INTO engfbv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah told his daughter-in-law Tamar, “Go to your father's house and live there as a widow until my son Shelah grows up.” For he thought, “Maybe he'll die too, just like his brothers.” So Tamar went and stayed in her father's house. ");
INSERT INTO engfbv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","A long time later Judah's wife, the daughter of Shua, died. After Judah had finished the time of mourning, he went to visit his sheepshearers at Timnah with his friend Hirah from Adullam. ");
INSERT INTO engfbv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar was told, “Your father-in-law is going to Timnah to shear his sheep.” ");
INSERT INTO engfbv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","So she took off her widow's clothes and covered herself with a veil, disguising herself. She sat down beside the entrance to Enaim, which is on the way to Timnah. She had realized that even though Shelah had now grown up, nothing had been done about her marrying him. ");
INSERT INTO engfbv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah saw her and thought she must be a prostitute because she had veiled her face. ");
INSERT INTO engfbv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","He went over to her at the side of the road and said, “I want to sleep with you.” He didn't know she was his daughter-in-law. “What will you give me if I let you sleep with me?” she asked. ");
INSERT INTO engfbv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“I'll send you a young goat from my flock,” he replied. “What guarantee will you give me to make sure you'll send it?” she asked. ");
INSERT INTO engfbv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“What guarantee do I have to give you?” he asked. “Your signet seal and its cord, and your walking stick that you're holding,” she replied. He handed them over to her. He slept with her and she became pregnant. ");
INSERT INTO engfbv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","She left, went home, took off her veil, and put on her widow's clothes. ");
INSERT INTO engfbv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah sent his friend Hirah from Adullam with a young goat to get back his belongings he'd left as a guarantee from the woman, but he couldn't find her. ");
INSERT INTO engfbv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hirah asked the men there, “Where's the cult prostitute that sits by the entrance road to Enaim?” “There's no cult prostitute here,” they answered. ");
INSERT INTO engfbv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hirah went back to Judah and told him, “I couldn't find her, and the men there said, ‘There's no cult prostitute here.’” ");
INSERT INTO engfbv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","“Let her keep what I gave her,” Judah replied. “We'll look ridiculous to people if we go on searching. In any case I did try to send her the young goat as promised but you couldn't find her.” ");
INSERT INTO engfbv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Then about three months later Judah was told, “Tamar your daughter-in-law has had sex like a prostitute and now as a result she's pregnant!” “Bring her out and burn her to death!” Judah ordered. ");
INSERT INTO engfbv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","As she was brought out, she sent a message to her father-in-law, saying, “I'm pregnant by the man who owns these things.” Then she added, “Please look carefully at this signet seal and its cord and walking stick. Who do they belong to?” ");
INSERT INTO engfbv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah recognized them right away and said, “She has honored the law more than I have, because I didn't give her in marriage to my son Shelah.” He didn't sleep with Tamar again. ");
INSERT INTO engfbv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","When the time came for Tamar to give birth, she was found to be carrying twins. ");
INSERT INTO engfbv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","One baby put out his hand, and the midwife tied a scarlet thread around his wrist and said, “This one came out first.” ");
INSERT INTO engfbv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But then he pulled back his hand and his brother was born, she said, “How did you burst out?” So he was named Perez. ");
INSERT INTO engfbv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Then his brother with the scarlet thread on his wrist was born. He was named Zerah. ");
INSERT INTO engfbv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph had been taken to Egypt by the Ishmaelites, who had sold him to Potiphar, an Egyptian who was one of Pharaoh's officers, the commander of the royal guard. ");
INSERT INTO engfbv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","The Lord was with Joseph and made him successful. He lived in his Egyptian master's house. ");
INSERT INTO engfbv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","His master noticed that the Lord was with him and made him successful in everything he did. ");
INSERT INTO engfbv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potiphar appreciated Joseph and his service, and put him in charge of his household and made him responsible for everything he owned. ");
INSERT INTO engfbv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","From the time he put Joseph in charge and trusted him with all he had, the Lord blessed Potiphar's household because of Joseph. The Lord blessed everything he had, whether in his house or in his fields. ");
INSERT INTO engfbv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","So Potiphar left Joseph to care for everything he owned. He didn't bother with anything except to decide what food he was going to eat. Now Joseph was handsome, having a good physique, ");
INSERT INTO engfbv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","so some time later he caught the eye of his master's wife. She propositioned him, saying, “Come here! Sleep with me!” ");
INSERT INTO engfbv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But he turned her down, telling his master's wife, “Look, my master trusts me so much he doesn't even bother to find out how his household is running. He's put me in charge of everything he owns— ");
INSERT INTO engfbv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","no one in this house has more authority than me! He hasn't held back anything from me except you, because you are his wife. So how could I do such an evil thing as this, and sin against God?” ");
INSERT INTO engfbv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Day after day she persisted in asking him, but he refused to sleep with her and tried to avoid her. ");
INSERT INTO engfbv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","But one day he went into the house to do his work and none of the other servants were there. ");
INSERT INTO engfbv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","She grabbed him by his clothing, and demanded, “Sleep with me!” But leaving his clothing in her hand, he ran out of the house. ");
INSERT INTO engfbv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Seeing that he'd left his clothing in her hand, and had run out of the house, ");
INSERT INTO engfbv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","she shouted out to her servants, “Look at this! He brought this Hebrew slave here to dishonor us! This man came to try and rape me, but I screamed at the top of my voice. ");
INSERT INTO engfbv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","When he heard me scream for help, he left his clothing beside me and ran outside.” ");
INSERT INTO engfbv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","She kept his clothing with her until her husband came home. ");
INSERT INTO engfbv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Then she told him her story. It went like this: “That Hebrew slave you brought here tried to come and dishonor me. ");
INSERT INTO engfbv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","But as soon as I screamed and called for help, he left his clothing beside me and ran outside.” ");
INSERT INTO engfbv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","When Potiphar heard the story his wife told him, saying, “This is what your servant did to me,” he became angry. ");
INSERT INTO engfbv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","He took Joseph and put him in the prison where the king's prisoners were kept, and there he stayed. ");
INSERT INTO engfbv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","But the Lord was with Joseph, showing him trustworthy love, and made the chief jailer pleased with him. ");
INSERT INTO engfbv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","So the chief jailer put Joseph in charge of all the prisoners there and gave him the responsibility for running the prison. ");
INSERT INTO engfbv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The chief jailer didn't bother with anything for Joseph took care of it all for the Lord was with him and made him successful. ");
INSERT INTO engfbv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Later on the cupbearer and the baker committed some offense against their master, the king of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh was angry with these two royal officials—the chief cupbearer and chief baker— ");
INSERT INTO engfbv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","and imprisoned them in the house of the commander of the guard, the same prison where Joseph was. ");
INSERT INTO engfbv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The commander of the guard assigned Joseph to them as their personal attendant. They were kept in prison for some time. ");
INSERT INTO engfbv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","One night while they were in prison the cupbearer and the baker for the king of Egypt each had a dream. They were different dreams, each with its own meaning. ");
INSERT INTO engfbv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","When Joseph arrived the next morning he noticed they both looked depressed. ");
INSERT INTO engfbv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","So he asked Pharaoh's officials who were imprisoned with him in his master's house, “Why are you looking so depressed?” ");
INSERT INTO engfbv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“We've both had dreams but can't find anyone to explain what they mean,” they said. So Joseph told them, “Isn't God the one who can interpret the meaning of dreams? Tell me your dreams.” ");
INSERT INTO engfbv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the chief cupbearer told Joseph his dream. “In my dream there was a vine right in front of me,” he explained. ");
INSERT INTO engfbv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","“The vine had three branches. As soon as it budded, it flowered, and produced clusters of ripe grapes. ");
INSERT INTO engfbv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I was holding Pharaoh's wine cup, so I picked the grapes and squeezed them into the cup and gave it to Pharaoh.” ");
INSERT INTO engfbv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“This is the meaning,” Joseph told him. “The three branches represent three days. ");
INSERT INTO engfbv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","In three days' time Pharaoh will take you out of prison and give you back your job, and you will hand Pharaoh his cup as you used to. ");
INSERT INTO engfbv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But when things go well for you, please remember me with kindness and speak to Pharaoh on my behalf, and please get me out of this prison. ");
INSERT INTO engfbv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","I was cruelly kidnapped from the land of the Hebrews, and now I'm here in this pit even though I've done nothing wrong.” ");
INSERT INTO engfbv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","When the chief baker saw that the interpretation was positive, he said to Joseph, “I also had a dream. I had three baskets of cakes on my head. ");
INSERT INTO engfbv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket were all the cakes and pastries for Pharaoh to eat, and the birds were eating them from the basket on my head.” ");
INSERT INTO engfbv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","“This is the meaning,” Joseph told him. “The three baskets represent three days. ");
INSERT INTO engfbv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","In three days' time Pharaoh will take you out of prison and hang you on a pole, and birds will eat your flesh.” ");
INSERT INTO engfbv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Three days later it happened to be Pharaoh's birthday, and he arranged a banquet for all his officials. He had the chief cupbearer and the chief baker released from prison and brought there before his officials. ");
INSERT INTO engfbv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He gave the chief cupbearer his job back, and he returned to his duties of handing Pharaoh his cup. ");
INSERT INTO engfbv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But he hanged the chief baker just as Joseph had said when he interpreted their dreams. ");
INSERT INTO engfbv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But the chief cupbearer didn't remember to say anything about Joseph—in fact he forgot all about him. ");
INSERT INTO engfbv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","A full two years later, Pharaoh had a dream that he was standing beside the River Nile. ");
INSERT INTO engfbv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","He saw seven cows coming up from the river. They looked well-fed and healthy as they grazed among the reeds. ");
INSERT INTO engfbv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Then he saw another seven cows that came up behind them. They looked ugly and skinny as they stood beside the other cows on the bank of the Nile. ");
INSERT INTO engfbv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Then the ugly, skinny cows ate the well-fed, healthy cows. Then Pharaoh woke up. ");
INSERT INTO engfbv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pharaoh fell asleep again and had a second dream. Seven heads of grain were growing on one stalk, ripe and healthy. ");
INSERT INTO engfbv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Then seven heads of grain grew up after them, thin and dried by the east wind. ");
INSERT INTO engfbv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","The seven thin and dried heads of grain swallowed up the ripe and healthy ones. Then Pharaoh woke up and realized he'd been dreaming. ");
INSERT INTO engfbv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","The next morning Pharaoh was worried by his dreams, so he sent for all the magicians and wise men in Egypt. Pharaoh told them about his dreams, but no one could interpret their meaning for him. ");
INSERT INTO engfbv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","But then the chief cupbearer spoke up. “Today I've just remembered a bad mistake I've made,” he explained. ");
INSERT INTO engfbv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","“Your Majesty was angry with some of your officials and you imprisoned me in the house of the commander of the guard, along with the chief baker. ");
INSERT INTO engfbv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","We each had a dream. They were different dreams, each with its own meaning. ");
INSERT INTO engfbv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","A young Hebrew was there with us, a slave of the commander of the guard. When we told him our dreams, he interpreted for us the meaning of our different dreams. ");
INSERT INTO engfbv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Everything happened just as he said it would—I was given back my job and the baker was hanged.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pharaoh summoned Joseph, and they quickly brought him from the prison. After he'd shaved and changed his clothes, he was presented to Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, but no one can interpret its meaning. But I've heard that when someone tells you a dream you know how to interpret it.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","“It's not me who can do this,” Joseph replied. “But God will explain its meaning to set Your Majesty's mind at rest.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaoh explained to Joseph, “In my dream I was standing on the bank of the Nile. ");
INSERT INTO engfbv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","I saw seven cows coming up from the river. They looked well-fed and healthy as they grazed among the reeds. ");
INSERT INTO engfbv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Then I saw another seven cows that came up behind them. They looked sickly and ugly and skinny—I've never seen such ugly cows in the whole of Egypt! ");
INSERT INTO engfbv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","These skinny, ugly cows ate the first seven healthy-looking cows. ");
INSERT INTO engfbv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","But afterwards you couldn't tell they'd eaten them because they looked just as skinny and ugly as before. Then I woke up. ");
INSERT INTO engfbv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Then I fell asleep again. In my second dream I saw seven heads of grain growing on one stalk, ripe and healthy. ");
INSERT INTO engfbv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Then seven heads of grain grew up after them, withered and thin and dried by the east wind. ");
INSERT INTO engfbv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","The seven thin heads of grain swallowed up the healthy ones. I told all this to the magicians, but none of them could explain its meaning to me.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","“Pharaoh's dreams mean the same thing,” Joseph responded. “God is telling Pharaoh what he is going to do. ");
INSERT INTO engfbv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows and the seven good heads of grain represent seven good years of harvest. The dreams mean the same thing. ");
INSERT INTO engfbv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","The seven skinny and ugly cows that came after them and the seven thin heads of grain dried by the east wind represent seven years of famine. ");
INSERT INTO engfbv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","It's just as I told Your Majesty—God has shown Pharaoh what he is going to do. ");
INSERT INTO engfbv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","There are going to be seven years with plenty of food produced throughout the whole country of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","But after them will come seven years of famine. People will forget the time when there was plenty of food throughout Egypt. Famine will ruin the country. ");
INSERT INTO engfbv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","The time of plenty will be completely forgotten because the famine that follows it will be so terrible. ");
INSERT INTO engfbv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","The fact that the dream was repeated twice means that it has definitely been decided by God, and that God is going to do this soon. ");
INSERT INTO engfbv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","So Your Majesty should choose a man with insight and wisdom, and put him in charge of the whole country of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Your Majesty should also appoint officials to be in charge of the land, and have them collect one-fifth of the produce of the country during the seven years of plenty. ");
INSERT INTO engfbv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","They should collect all the food during the good years that are soon coming, and store the grain under Pharaoh's authority, keeping it under guard to provide food for the towns. ");
INSERT INTO engfbv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","This will be a food reserve for the country during the seven years of famine so that the people won't die of starvation.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Pharaoh and all his officials thought Joseph's proposal was a good idea. ");
INSERT INTO engfbv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","So Pharaoh asked them, “Where can we find a man like this who has the spirit of God in him?” ");
INSERT INTO engfbv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Then Pharaoh spoke to Joseph, telling him, “Since God has revealed to you all this, and there's no one like you with such insight and wisdom, ");
INSERT INTO engfbv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","you will be in charge of all my affairs, and all my people will obey your orders. Only I with my status as king will be greater than you.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Then Pharaoh said to Joseph, “Look, I'm putting you in charge of the whole country of Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaoh took off his signet ring from his finger and put it on Joseph's finger. He dressed him in fine linen clothes and placed a golden chain around his neck. ");
INSERT INTO engfbv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","He had Joseph ride in the chariot designated for his second-in-command while his attendants went ahead, shouting, “Bow down!” This is how Pharaoh gave Joseph authority over all of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Then Pharaoh told Joseph, “I am Pharaoh, but without your permission nobody will lift a hand or a foot anywhere in the whole country.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaoh gave Joseph the name Zaphenath-paneah, and arranged for him to marry Asenath, the daughter of Potiphera, priest of On. This is how Joseph rose to power over the whole of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph was thirty when he started working for Pharaoh, king of Egypt. After he had left Pharaoh, Joseph traveled on an inspection tour throughout Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","During the seven years of good harvests, the land produced plenty of food. ");
INSERT INTO engfbv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","He collected all the food during the seven good years, and he stored the grain produced in the local fields in each town. ");
INSERT INTO engfbv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph piled up so much grain that it was like the sand of the seashore. Eventually he stopped keeping records because there was just so much! ");
INSERT INTO engfbv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","It was during this time, before the years of famine came, that Joseph had two sons by Asenath, the daughter of Potiphera, priest of On. ");
INSERT INTO engfbv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named his firstborn Manasseh, because he said, “The Lord has made me forget all my troubles and all my father's family.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","His second son he named Ephraim, because he said, “God has made me fruitful in the country of my misery.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","The seven years of plenty in Egypt came to an end, ");
INSERT INTO engfbv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","and the seven years of famine began, just as Joseph had said. There was famine in all the other countries but the whole of Egypt had food. ");
INSERT INTO engfbv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","When all of Egypt was hungry, the people cried out to Pharaoh for food, and he told everyone, “Go and see Joseph and do whatever he tells you.” ");
INSERT INTO engfbv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","The famine had spread all over the country so Joseph opened all the storehouses and sold grain to the people of Egypt. The famine was very bad in Egypt, ");
INSERT INTO engfbv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","in fact the famine was very bad everywhere, so people from other countries all around came to Egypt to buy grain from Joseph. ");
INSERT INTO engfbv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","When Jacob found out grain was available in Egypt, he asked his sons, “Why do you keep on looking at each other to do something? ");
INSERT INTO engfbv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I've heard there's grain in Egypt. Go there and buy some for us so we can stay alive—if not, we're going to die!” ");
INSERT INTO engfbv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So ten of Joseph's brothers went to Egypt to buy grain. ");
INSERT INTO engfbv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","But Jacob did not send Joseph's brother Benjamin with his other brothers, for he said, “I'm afraid something bad might happen to him.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So Israel's sons went to buy grain along with everyone else, because there was famine in Canaan too. ");
INSERT INTO engfbv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph was the governor of the country and he sold grain to all the people there. So Joseph's brothers went to him, and bowed low before him with their faces to the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph recognized them as soon as he saw them, but he acted like a stranger towards them and spoke to them in a severe way, saying, “Where are you from?” “From the country of Canaan,” they replied. “We've come to buy food.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Even though Joseph recognized his brothers, they didn't recognize him. ");
INSERT INTO engfbv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph thought back to the dreams he'd had about them, and told them, “No! You're spies! You've come to discover our country's weaknesses!” ");
INSERT INTO engfbv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“That's not true, my lord!” they responded. “We, your servants, have just come to buy food. ");
INSERT INTO engfbv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We're all the sons of one man and we're honest. We're not spies!” ");
INSERT INTO engfbv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","“No! You've come to find our country's weaknesses!” he insisted. ");
INSERT INTO engfbv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","“Your servants are twelve brothers, the sons of one man living in the country of Canaan,” they explained. “The youngest is right now with our father, and one has passed away.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“As I said before, you're spies!” Joseph declared. ");
INSERT INTO engfbv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","“This is how your story will be checked. I swear on Pharaoh's life that you'll never leave this country unless your younger brother comes here. ");
INSERT INTO engfbv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","One of you go back and bring your other brother here. The others of you will be kept here in prison until it's clear that you're telling the truth. If not, then I swear on Pharaoh's life it proves you're spies!” ");
INSERT INTO engfbv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","So Joseph put all of them in prison for three days. ");
INSERT INTO engfbv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","On the third day he told them, “Since I'm someone who respects God, do as I tell you and you'll live. ");
INSERT INTO engfbv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you're truly honest, choose one of your brothers to stay here in prison. The rest of you can go back home with grain for your hungry families. ");
INSERT INTO engfbv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","But you must bring your youngest brother here to me to prove what you're saying is true. If not, you will all die.” They agreed to do this. ");
INSERT INTO engfbv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","“Clearly we're being punished for what we did to our brother,” they said to each other. “We watched him in agony pleading with us for mercy, but we refused to listen to him. That's why we're in all this trouble.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben said to them, “Didn't I tell you, ‘Don't harm the boy!’ But you didn't listen to me. Now we're paying the price for what we did to him.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","They didn't realize that Joseph understood what they were saying because they were talking to him through an interpreter. ");
INSERT INTO engfbv_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Joseph stepped away from them because he started crying. He came back when he was able to speak to them again. He chose Simeon and had him tied up as they watched. ");
INSERT INTO engfbv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph gave the order to fill up their sacks with grain, and also to return the money they had paid by placing it in the sacks as well. He also ordered that they should be provided with food for their journey home. All this was done. ");
INSERT INTO engfbv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","The brothers loaded the grain onto their donkeys and then set off. ");
INSERT INTO engfbv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","On their way they stopped for the night, and one of them opened up his sack to give his donkey something to eat and saw his money there at the top of the sack. ");
INSERT INTO engfbv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He told his brothers, “My money's been returned to me. It's right here at the top of my sack!” They were horrified! Trembling with fear they asked each other, “What is this that God's done to us?” ");
INSERT INTO engfbv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","When they arrived home in Canaan, they told their father Jacob everything that had happened. ");
INSERT INTO engfbv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“The man who is the country's governor spoke to us in a severe way, and accused us of spying on the land,” they explained. ");
INSERT INTO engfbv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","“We told him, ‘We are honest men. We're not spies! ");
INSERT INTO engfbv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","We are twelve brothers, the sons of one father. One has passed away and the youngest is right now with our father in the country of Canaan.’ ");
INSERT INTO engfbv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Then the man who is the country's governor said to us, ‘This is how I'll find out if you're telling the truth: you are to leave one of your brothers here with me while the rest take grain home for your hungry families. ");
INSERT INTO engfbv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Then bring your youngest brother to me. That way I'll know you're not spies but you're telling the truth. I'll release your brother to you, and you can stay in the country and trade.’” ");
INSERT INTO engfbv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","As they emptied their sacks, each one's money bag was there in his sack! When they and their father saw the money bags, they were horrified. ");
INSERT INTO engfbv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob their father accused them, “You have taken Joseph from me—he's gone! Simeon is gone too! Now you want to take Benjamin away! I'm the one who's suffering from all of this!” ");
INSERT INTO engfbv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","“You can kill my two sons if I don't bring him back to you,” Reuben assured him. “Trust me with him, and I will bring him home to you myself.” ");
INSERT INTO engfbv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","“My son won't go there with you!” Jacob declared. “His brother is dead, and he's the only one I have left. If anything bad happens to him on the journey you're planning, you'll send this old man to his grave in grief.” ");
INSERT INTO engfbv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","The famine continued to be really bad in Canaan, ");
INSERT INTO engfbv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","so once they had finished the grain they'd brought from Egypt, their father told them, “You have to go back and buy some more grain for us.” ");
INSERT INTO engfbv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Judah responded, “The man was adamant when he warned us, ‘I won't even see you unless your brother is with you.’ ");
INSERT INTO engfbv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you send our brother Benjamin with us then we'll go and buy food for you. ");
INSERT INTO engfbv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you won't send him, then we won't go, because the man was very clear, ‘I won't even see you unless your brother is with you.’” ");
INSERT INTO engfbv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“Why have you made things so bad for me by telling the man you had another brother?” Israel asked. ");
INSERT INTO engfbv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","“The man kept on asking direct questions about us and our family like ‘Is your father still alive?’ and ‘Do you have another brother?’” they replied. “We just answered his questions. How were we to know he'd say, ‘Bring your brother here!’?” ");
INSERT INTO engfbv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah said to his father Israel, “Send the boy in my care, and we'll leave immediately, so that we can stay alive and not die—and that includes you and us and our children! ");
INSERT INTO engfbv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I promise to take care of him—I'll be personally responsible for bringing him back to you. If I don't, then I will always carry the blame! ");
INSERT INTO engfbv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Now let's go, because if we hadn't hesitated, we could have gone there and come back twice by now.” ");
INSERT INTO engfbv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","“If it has to be, then this is what you'll do,” Israel replied. “Take with you the best our country produces. Pack your bags with gifts for the man—balm, a little honey, spices, myrrh, pistachios, and almonds. ");
INSERT INTO engfbv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take double the money that was returned to you in your sacks—maybe it was a mistake. ");
INSERT INTO engfbv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take your brother and go back to the man right away. ");
INSERT INTO engfbv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","May God Almighty make the man treat you kindly so when you come before him he'll release your other brother and send Benjamin back. As for me, if I am to lose all my children, then so be it.” ");
INSERT INTO engfbv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So they packed the gifts, took double the money, and set off, accompanied by Benjamin. They arrived in Egypt and went to have an audience with Joseph. ");
INSERT INTO engfbv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin was with them, he told his household supervisor, “Take these men to my house. Slaughter an animal and make a meal, for they are going to eat with me at noon.” ");
INSERT INTO engfbv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The man did as Joseph ordered and took them to Joseph's house. ");
INSERT INTO engfbv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","They were really worried that they were being taken to Joseph's house. “It's because of the money that was put in our sacks the first time we came,” they said to each other. “That's why we're being brought in—so he can accuse us and attack us! He'll make us his slaves and take our donkeys!” ");
INSERT INTO engfbv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So they went and spoke to Joseph's household supervisor at the entrance to the house. ");
INSERT INTO engfbv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Please excuse us, my lord,” they said. “We came down the first time to buy food, ");
INSERT INTO engfbv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","and when we stopped for the night, we opened our sacks and each of us found our money—the exact amount—at the top of our sacks. So we've brought it back with us. ");
INSERT INTO engfbv_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","We've also brought more money to buy food. We've no idea who put our money in our sacks!” ");
INSERT INTO engfbv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“Everything's fine!” he told them. “Don't worry! Your God, the God of your father, must have given you the treasure hidden in your sacks. I got your money.” Then he brought Simeon out to meet them. ");
INSERT INTO engfbv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","The steward took them inside Joseph's house, gave them water to wash their feet, and supplied food for their donkeys. ");
INSERT INTO engfbv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","They got their gifts ready for when Joseph would come at noon, because they had found out that they were going to eat there. ");
INSERT INTO engfbv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph arrived at the house they gave him the gifts they had brought for him, and bowed low to the ground before him. ");
INSERT INTO engfbv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","He asked how they were, and then he asked, “How is your elderly father doing that you spoke of? Is he still alive?” ");
INSERT INTO engfbv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","“Yes, your servant our father is still alive, and is well,” they replied and bowed low in respect. ");
INSERT INTO engfbv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Then Joseph looked over at his brother Benjamin, the son of his own mother. “Is this your youngest brother that you told me about?” he asked. “God be gracious to you, my son,” he said. ");
INSERT INTO engfbv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph had to run out quickly because he was becoming so emotional at seeing his brother. He looked for a place to cry, and went to his room to weep there. ");
INSERT INTO engfbv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then he washed his face, got his emotions under control, and went back out. “Serve the food,” he ordered. ");
INSERT INTO engfbv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Joseph was served at a table by himself, and his brothers were served at a separate table. The Egyptians were also served at another table, because Egyptians cannot eat with Hebrews because they find this repulsive. ");
INSERT INTO engfbv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","The brothers had been seated in front of him in order by age, from the firstborn, the oldest, down to the youngest, and they looked at each other in complete surprise. ");
INSERT INTO engfbv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","The food was served to them from Joseph's table, and Benjamin received five times as much as anyone else. So they ate and drank plenty with him. ");
INSERT INTO engfbv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph ordered his household supervisor, “Fill the men's sacks with as much grain as they can hold and put each man's money at the top of his sack. ");
INSERT INTO engfbv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Then put my special silver cup at the top of the sack of the youngest, along with the money for his grain.” He did as Joseph told him. ");
INSERT INTO engfbv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","At sunrise they were sent on their way with their donkeys. ");
INSERT INTO engfbv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","They had hardly left the city when Joseph told his household supervisor, “Go after those men, and when you catch up with them, ask them, ‘Why have you paid back good with evil by stealing my master's silver cup? ");
INSERT INTO engfbv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","This is the cup he personally drinks from, and which he uses for divination. What you've done is really evil!’” ");
INSERT INTO engfbv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","When he caught up with them, he told them what Joseph had said. ");
INSERT INTO engfbv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","“My lord, what are you saying?” they replied. “We your servants wouldn't do anything like that! ");
INSERT INTO engfbv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Remember that we brought back the money we found at the top of our sacks when we returned from Canaan. Why would we steal silver or gold from your master's house? ");
INSERT INTO engfbv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If any one of us is found with it, he shall die, and all of us will become your slaves.” ");
INSERT INTO engfbv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Whatever you say,” the man replied, “but only the one found with it will become my slave since the rest of you will be free of any blame.” ");
INSERT INTO engfbv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","They all unloaded their sacks and put them on the ground. They each opened their own sacks. ");
INSERT INTO engfbv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","The household supervisor searched the sacks, beginning with the oldest and working his way down to the youngest. The cup was found in Benjamin's sack. ");
INSERT INTO engfbv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","The brothers tore their clothes in grief. Then they loaded their sacks back on their donkeys and headed back to the city. ");
INSERT INTO engfbv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Joseph was still at home when Judah and his brothers arrived, and they fell to the ground before him. ");
INSERT INTO engfbv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","“Why did you do this?” Joseph asked. “Don't you know a man like me can find out things through divination?” ");
INSERT INTO engfbv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“My lord, what can we say?” Judah replied. “How can we explain this to you? In what way can we prove our innocence? God has exposed the guilt of your servants. My lord, we are your slaves—all of us, including the one who was found with the cup.” ");
INSERT INTO engfbv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“I wouldn't do anything like that!” Joseph replied. “Only the man who was found with the cup will become my slave. The rest of you are free to return to your father.” ");
INSERT INTO engfbv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah came closer and said to him, “If you please, my lord, let your servant just say a word. Please don't become angry with your servant, even though you are as powerful as Pharaoh himself. ");
INSERT INTO engfbv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","My lord, previously you asked us, ‘Do you have a father or a brother?’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","We told you, my lord, ‘We have an elderly father, and a younger brother, born when our father was already old. The boy's brother is dead. He is the only one of his mother's children left, and his father loves him dearly.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you ordered us, ‘Bring him here to me so I can see him.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","We told you, ‘The boy can't leave his father; if he did, his father would die.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you told us, ‘If your youngest brother doesn't come with you, you won't see me again.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","So when we went back to your servant, our father, we explained to him everything you had told us. ");
INSERT INTO engfbv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","However, later on, our father told us, ‘Go back and buy some more food.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","But we said, ‘There's no way we can go back unless Benjamin our youngest brother goes with us, because we won't be able to see the man if Benjamin isn't with us.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Then my father said to us, ‘You realize that my wife had two sons for me. ");
INSERT INTO engfbv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","One is no more, ripped to pieces no doubt, for I've never seen him since. ");
INSERT INTO engfbv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If you take this one away from me too, and something bad happens to him, you'll send this old man to his grave in grief.’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","So if the boy isn't with us when I go back to my father, whose life depends on the life of the boy, ");
INSERT INTO engfbv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","as soon as he sees the boy isn't there he'll die, and we will really send this old man, our father, to his grave in grief. ");
INSERT INTO engfbv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","In fact I gave myself as the guarantee for the boy to my father. I told him, ‘If I don't bring him back to you, then I will always carry the blame!’ ");
INSERT INTO engfbv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","So please let me stay here as my lord's slave instead of the boy. Let him go back home with his brothers. ");
INSERT INTO engfbv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","For how could I ever go back to my father if the boy wasn't with me? I couldn't stand seeing the anguish that would cause my father.” ");
INSERT INTO engfbv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph couldn't control his emotions any longer while all his attendants were there, so he shouted out, “Everybody leave me!” So there was nobody else there when Joseph revealed who he was to his brothers. ");
INSERT INTO engfbv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","But he cried so loudly that the Egyptians could hear him, and they told Pharaoh's household about it. ");
INSERT INTO engfbv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","“I'm Joseph!” he announced to his brothers. “Is my father still alive?” They couldn't answer him as they were so surprised to see him face to face. ");
INSERT INTO engfbv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","“Please come closer to me,” he told his brothers. They came over to him. “I'm your brother Joseph who you sold into slavery in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","But don't be worried or get angry with yourselves that you sold me to be a slave here, because it was God who sent me ahead of you to save lives. ");
INSERT INTO engfbv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","The country has suffered from famine for two years already, but there will be five more years with no plowing or reaping. ");
INSERT INTO engfbv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God sent me ahead of you to make sure you would still have descendants, to save your lives in this miraculous way. ");
INSERT INTO engfbv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","So it wasn't you who sent me here, but God. He was the one who made me Pharaoh's chief advisor in charge of all his affairs, and ruler of the whole country of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Now hurry! Go back to my father and tell him, ‘This message comes from your son Joseph: God has made me the ruler of the whole of Egypt. Come to me now; don't wait. ");
INSERT INTO engfbv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You'll live in the land of Goshen so you can be close to me with your children and grandchildren, and with your flocks and herds and everything that belongs to you. ");
INSERT INTO engfbv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I'll make sure you have food, because there are still five more years of famine to come. Otherwise you and your family and your animals are going to starve.’” ");
INSERT INTO engfbv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Then Joseph told his brothers, “You can all see for yourselves—including my brother Benjamin—that it's really me talking to you! ");
INSERT INTO engfbv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tell my father how much I'm respected in Egypt. Tell him everything that you've seen. Hurry! Bring my father here quickly!” ");
INSERT INTO engfbv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","He hugged Benjamin, and Benjamin hugged him back. They both wept for joy. ");
INSERT INTO engfbv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","He kissed all his brothers and wept over them, and after that his brothers were able to start talking with him. ");
INSERT INTO engfbv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Word soon reached Pharaoh's palace that Joseph's brothers had arrived. Pharaoh and his officials were glad to hear the news. ");
INSERT INTO engfbv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh said to Joseph, “Tell your brothers, ‘This is what you are to do: Load your donkeys with grain and go back to the country of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Then bring your father and your families and return here to me. I will give you the best land in Egypt, and you shall eat the best food the country has to offer.’ ");
INSERT INTO engfbv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tell them to do this as well: ‘Take some wagons from Egypt for your children and your wives. Bring them and your father here. ");
INSERT INTO engfbv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Don't worry about bringing your possessions because the best of all Egypt is yours.’” ");
INSERT INTO engfbv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","So that's what the sons of Israel did. Joseph provided them with wagons, as Pharaoh had ordered. He also gave them supplies for their journey. ");
INSERT INTO engfbv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","He gave each of them new clothes. But to Benjamin he gave five sets of clothes and 300 pieces of silver. ");
INSERT INTO engfbv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Joseph also sent to his father the following: ten donkeys carrying the best things from Egypt, and ten female donkeys carrying grain and bread and supplies needed for his father's journey. ");
INSERT INTO engfbv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Then he saw his brothers off, and as they left he told them, “Don't argue on the way!” ");
INSERT INTO engfbv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So they left Egypt and went back home to their father Jacob in the country of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","“Joseph's still alive!” they told him. “It's true, and he's the ruler of the whole country of Egypt!” Jacob was stunned at the news—he just couldn't believe it! ");
INSERT INTO engfbv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","But when they told him everything that Joseph had said to them, and when he saw the wagons that Joseph had sent to take him to Egypt, Jacob came back to his senses. ");
INSERT INTO engfbv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel said, “All right, I believe you! My son Joseph is still alive! I'm going to go and see him before I die.” ");
INSERT INTO engfbv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Israel left for Egypt with everything he had. When he arrived at Beersheba he offered sacrifices to the God of his father Isaac. ");
INSERT INTO engfbv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","During the night God spoke to Israel in a vision. “Jacob! Jacob!” he called. “I'm here,” he replied. ");
INSERT INTO engfbv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“I am God, the God of your father! Don't be afraid to go to Egypt, because I will turn you and your descendants into a great nation. ");
INSERT INTO engfbv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go to Egypt with you, and I promise to bring you back again. And Joseph will personally close your eyes when you die.” ");
INSERT INTO engfbv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob left Beersheba. His sons took him, their children, and their wives to Egypt using the wagons Pharaoh had sent. ");
INSERT INTO engfbv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","They also took with them all their livestock and all the personal belongings they had accumulated in the country of Canaan. So Jacob and everyone in his extended family went to Egypt, ");
INSERT INTO engfbv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","including all his sons and grandsons, daughters and granddaughters. ");
INSERT INTO engfbv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","The following is the genealogy of Israel and his sons who went to Egypt: Reuben, Jacob's firstborn. ");
INSERT INTO engfbv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","The sons of Reuben: Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engfbv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","The sons of Simeon: Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul the son of a woman from Canaan. ");
INSERT INTO engfbv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","The sons of Levi: Gershon, Kohath, and Merari. ");
INSERT INTO engfbv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","The sons of Judah: Er, Onan, Shelah, Perez, and Zerah. However, Er and Onan died in Canaan. The sons of Perez: Hezron and Hamul. ");
INSERT INTO engfbv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","The sons of Issachar: Tola, Puvah, Job, and Shimron. ");
INSERT INTO engfbv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","The sons of Zebulun: Sered, Elon, and Jahleel. ");
INSERT INTO engfbv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","These are the sons Leah had for Jacob in Paddan-aram, as well as his daughter Dinah. The total number of sons and daughters and grandchildren was thirty-three. ");
INSERT INTO engfbv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","The sons of Gad: Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engfbv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","The sons of Asher: Imnah, Ishvah, Ishvi, Beriah, and their sister Serah. The sons of Beriah: Heber and Malchiel. ");
INSERT INTO engfbv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","These are the sons of Jacob Zilpah had, the servant given by Laban to his daughter Leah, a total of sixteen children and grandchildren. ");
INSERT INTO engfbv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","The sons of Jacob's wife Rachel: Joseph and Benjamin. ");
INSERT INTO engfbv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","The sons Joseph had in the land of Egypt by Asenath, daughter of Potiphera, priest of On: Manasseh and Ephraim. ");
INSERT INTO engfbv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","The sons of Benjamin: Bela, Becher, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard. ");
INSERT INTO engfbv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These are the sons that Rachel had for Jacob, a total of fourteen children and grandchildren. ");
INSERT INTO engfbv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","The son of Dan: Hushim. ");
INSERT INTO engfbv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","The sons of Naphtali: Jahzeel, Guni, Jezer, and Shillem. ");
INSERT INTO engfbv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These are the sons of Jacob that Bilhah had, the servant given by Laban to his daughter Rachel, a total of seven children and grandchildren. ");
INSERT INTO engfbv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","All those who were part of Jacob's family who came to Egypt (his blood relatives, apart from wives of Jacob's sons) totaled sixty-six. ");
INSERT INTO engfbv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Including the two sons Joseph had in Egypt, the total number of Jacob's family who were in Egypt was seventy. ");
INSERT INTO engfbv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah on ahead to meet Joseph and find out the way to Goshen. When they arrived in Goshen, ");
INSERT INTO engfbv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph ordered his chariot made ready and went to meet his father Israel there. As soon as he arrived, he hugged his father and wept for a long time. ");
INSERT INTO engfbv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","“Now I can die in peace because I have seen your face again and know you're still alive,” Israel told Joseph. ");
INSERT INTO engfbv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph told his brothers and his father's household, “I'm going to go and report to Pharaoh and tell him, ‘My brothers and my father's household have arrived from the country of Canaan to join me. ");
INSERT INTO engfbv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","They are shepherds and keep livestock. They have brought with them their flocks and herds and all their possessions.’ ");
INSERT INTO engfbv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","When Pharaoh calls for you and asks you, ‘What work do you do?’ ");
INSERT INTO engfbv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","tell him, ‘Your servants have looked after livestock since we were children, both us and our fathers before us.’ That way you'll be able to live here in Goshen, because Egyptians look down on shepherds.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph went to report to Pharaoh and told him, “My father and brothers, along with their flocks and herds and all their possessions, have arrived from the land of Canaan and now they're here in Goshen.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Joseph took five of his brothers to go with him and introduced them to Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh asked the brothers, “What work do you do?” “Your servants are shepherds, just like our fathers before us,” they replied. ");
INSERT INTO engfbv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","“We have come to live in Egypt because there's no grass left in Canaan for our flocks to eat,” they explained. “The famine is really bad in Canaan. So we would like to please ask permission to live in Goshen.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaoh said to Joseph, “Now that your father and brothers have arrived to join you, ");
INSERT INTO engfbv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","you can choose wherever you like in Egypt, the best place, for them to live. Let them live in Goshen. If you know any of them who are good at what they do, put them in charge of my livestock as well.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph went with his father Jacob and introduced him to Pharaoh. After Jacob blessed Pharaoh, ");
INSERT INTO engfbv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh asked him, “So how long have you lived?” ");
INSERT INTO engfbv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“I have been wandering for 130 years,” Jacob replied. “My life has been short and difficult—I have not lived as long as my forefathers who also wandered from place to place.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob blessed Pharaoh again before leaving him. ");
INSERT INTO engfbv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","So Joseph arranged for his father and brothers to live in Egypt and gave them land in the best part near Rameses, as Pharaoh had ordered. ");
INSERT INTO engfbv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","He also provided food for all of them—his father, his brothers, and his father's whole household—depending on family size. ");
INSERT INTO engfbv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","No food was left in the whole country because the famine had become so bad. Throughout Egypt and Canaan people were starving. ");
INSERT INTO engfbv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","By selling grain Joseph collected all the money in Egypt and Canaan, and placed it in Pharaoh's treasury. ");
INSERT INTO engfbv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Once the money from Egypt and Canaan had run out, the Egyptians all came to Joseph and demanded, “Give us food! Do you want us to die right in front of you? All our money is gone!” ");
INSERT INTO engfbv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“Bring me your livestock,” Joseph told them. “I'll give you grain in exchange for your livestock if you've run out of money.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So they brought Joseph their livestock, and he provided them with grain in exchange for their horses, sheep, goats, cattle, and donkeys. He gave them grain in return for their livestock during that year. ");
INSERT INTO engfbv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","But when that year was over, they came to him the next year and said, “My lord, we can't hide from you the fact that our money is gone and that you now own our livestock. All we have left to give you are our bodies and our land. ");
INSERT INTO engfbv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Do you want us to die right in front of you? So buy us and our land in return for food. Then our land will belong to Pharaoh, and we'll be his slaves. Just give us grain so we can live and won't die, and so the land won't be abandoned.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the land in Egypt for Pharaoh. Each and every Egyptian sold their fields, because the famine was hurting them so badly. The land ended up being owned by Pharaoh, ");
INSERT INTO engfbv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","and all the people became his slaves, from one end of Egypt to the other. ");
INSERT INTO engfbv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","The only land he didn't buy belonged to the priests because they had a food allowance provided to them by Pharaoh, so they didn't have to sell their land. ");
INSERT INTO engfbv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Then Joseph told the people, “Listen to me! Now that I have bought you and your land for Pharaoh, I'm giving you some seed for you to sow the fields. ");
INSERT INTO engfbv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","However, when it's harvested, you have to give one-fifth of it to Pharaoh. The other four-fifths you can keep as seed for the fields and as food for you, your households, and your children.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","“You've saved our lives,” they declared. “May you continue to treat us well, my lord, and we'll be Pharaoh's slaves.” ");
INSERT INTO engfbv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph made it a law for Egypt which is still is in effect today that one-fifth of all produce from the land belongs to Pharaoh. Only the priests' land was exempt since it did not belong to Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","The Israelites settled in Goshen in Egypt where they became prosperous landowners and rapidly increased in number. ");
INSERT INTO engfbv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in Egypt for seventeen years, so he lived in total 147 years. ");
INSERT INTO engfbv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","When the time came for Israel to die, he called for his son Joseph and said to him, “If you think well of me, place your hand under my thigh and promise to treat me with trustworthy love and faithfulness. Don't bury me here in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","When I die, bury me with my forefathers. You must take my body from Egypt to the family tomb and bury me with them.” “I will do as you say,” Joseph promised. ");
INSERT INTO engfbv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","“Swear to me that you will,” he said. Joseph swore that he would. Israel bowed in worship at the head of his bed. ");
INSERT INTO engfbv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sometime after this, Joseph was told, “Your father is sick.” So Joseph went to see him, taking with him his two sons Manasseh and Ephraim. ");
INSERT INTO engfbv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When Jacob was told, “Your son Joseph has come to you,” he gathered his strength and sat up in bed. ");
INSERT INTO engfbv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob said to Joseph, “God Almighty appeared to me at Luz in Canaan, and he blessed me there. ");
INSERT INTO engfbv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","He told me, ‘Listen! I will make you prosperous and make your descendants so numerous that you will become the ancestor of many nations, and I will give this land to your descendants to own forever.’ ");
INSERT INTO engfbv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","I am counting as mine your two sons Ephraim and Manasseh who were born here in Egypt before I arrived, just as Reuben and Simeon are mine. ");
INSERT INTO engfbv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Any other children you have after them will be yours, and will share their inheritance within the land of their older brothers. ");
INSERT INTO engfbv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","I'm doing this because tragically for me when I was returning from Paddan-aram, Rachel died in Canaan some distance from Ephrath. I buried her there on the way to Ephrath” (also known as Bethlehem). ");
INSERT INTO engfbv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel saw Joseph's sons and said, “So these are your sons?” ");
INSERT INTO engfbv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","“Yes, these are the sons God gave me here,” Joseph told his father. “Bring them over here so I can bless them,” he said. ");
INSERT INTO engfbv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel's eyesight was failing because of his age and he couldn't see well, so Joseph brought them close to his father, and he kissed and hugged them. ");
INSERT INTO engfbv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel said to Joseph, “I never thought I'd see your face again, and now God has even let me see your children!” ");
INSERT INTO engfbv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph took his sons from between Israel's knees, and bowed low with his face to the ground. ");
INSERT INTO engfbv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Then Joseph placed Ephraim on his right so he would be on Israel's left, and Manasseh on his left so he would be on Israel's right, and then brought them over to Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","But when Israel reached out his hands, he crossed them over and placed his right hand on Ephraim the younger son, and placed his left on Manasseh, the firstborn. ");
INSERT INTO engfbv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","He blessed Joseph, saying, “May the God my grandfather Abraham and my father worshiped—the God who has taken care of me like a shepherd throughout my life until now, ");
INSERT INTO engfbv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","the Angel who has saved me from all kinds of trouble—may he bless these boys. May my name and the names of my grandfather Abraham and father Isaac continue through them, and may they have many descendants that spread throughout the earth.” ");
INSERT INTO engfbv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph was unhappy when he saw his father had put his right hand on Ephraim, so he took his father's hand to try and move it from Ephraim's head to Manasseh's head. ");
INSERT INTO engfbv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Not like that, father, this is the firstborn; put your right hand on his head,” Joseph told him. ");
INSERT INTO engfbv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father refused, saying, “I know what I'm doing. Manasseh will also become an important people, but his younger brother will be greater than him, and his descendants will become a large nation.” ");
INSERT INTO engfbv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So Israel blessed them that day and said: “In the future the people of Israel will use your names to give a blessing, saying, ‘May God bless you like he did Ephraim and Manasseh.’” In saying this he placed Ephraim before Manasseh. ");
INSERT INTO engfbv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Israel said to Joseph, “I'm going to die soon, but God will be with you and bring you back to the land of your fathers. ");
INSERT INTO engfbv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","I'm also giving you something in addition to what I'm giving your brothers—the piece of land on the mountain slope of Shechem that I took from the Amorites with my sword and bow.” ");
INSERT INTO engfbv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob called his sons together, and said, “Gather round so I can tell you what's going to happen to you in the future. ");
INSERT INTO engfbv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Come here, sons of Jacob, and listen to Israel your father. ");
INSERT INTO engfbv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, you are my firstborn, conceived when I was strong, born when I was vigorous! You were above all others in position, above all others in power. ");
INSERT INTO engfbv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","But you boil over like water, so you won't be above anyone anymore, because you went and slept with my concubine; you violated my marriage bed. ");
INSERT INTO engfbv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon and Levi are two of the same kind—they use their weapons for destructive violence. ");
INSERT INTO engfbv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","I refuse to be part of their decisions; I refuse to participate in what they do. For they killed men in their anger; they crippled cattle just for fun. ");
INSERT INTO engfbv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","I curse their anger because it is too harsh; I curse their fury because it is too cruel! I will separate their descendants throughout Jacob; I will scatter them throughout Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah, your brothers will praise you. You will defeat your enemies. Your father's sons shall bow down to you in respect. ");
INSERT INTO engfbv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","My son Judah is a young lion coming back from eating its prey. He crouches and lies down like a lion. Like a lion, who would dare to disturb him? ");
INSERT INTO engfbv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judah will always hold the scepter, and the staff of authority will always be at his feet until Shiloh comes; the nations will obey him. ");
INSERT INTO engfbv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He ties his donkey to the vine, his donkey's colt to the best vine. He washes his clothes in wine, his robes in the red juice of grapes. ");
INSERT INTO engfbv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes sparkle more than wine, and his teeth are whiter than milk. ");
INSERT INTO engfbv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun will live on the seashore and provide a harbor for ships; his territory will extend towards Sidon. ");
INSERT INTO engfbv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar is a strong donkey, lying down between two saddle bags. ");
INSERT INTO engfbv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He sees that the place where he's resting is good, and the land is lovely, so he's willing to lower his back to accept the burden and to work as a slave. ");
INSERT INTO engfbv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan will judge his people as one of the tribes of Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan will be as dangerous as a snake beside the road, a viper by the path that bites the horse's heel, throwing its rider off backwards. ");
INSERT INTO engfbv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","I trust in you to save me, Lord. ");
INSERT INTO engfbv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Raiders will attack Gad, but he will attack their heels. ");
INSERT INTO engfbv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher will have delicious food—he'll produce fancy food for royalty. ");
INSERT INTO engfbv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali is a deer that's free to run; it gives birth to beautiful fawns. ");
INSERT INTO engfbv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph is a fruitful tree, a fruitful tree beside a spring, whose branches climb over the wall. ");
INSERT INTO engfbv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","The archers viciously attacked him; they shot their arrows at him with hate. ");
INSERT INTO engfbv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But he held his bow steady, and his arms and hands moved quickly in the strength of the Mighty One of Jacob, who is called the Shepherd, the Rock of Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","The God of your father will help you and the Almighty will bless you with blessings from the heavens above, with blessings from the depths below, with blessings for many children. ");
INSERT INTO engfbv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","The blessings your father received were greater than the blessings of his forefathers, more than the blessings of the eternal mountains. May they be upon the head of Joseph, on the forehead of the one set apart as a leader from his brothers. ");
INSERT INTO engfbv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin is a vicious wolf. In the morning he destroys his enemies, in the evening he divides the loot.” ");
INSERT INTO engfbv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are all of the twelve tribes of Israel, and this is what their father told them as he blessed them, each according to their respective blessings. ");
INSERT INTO engfbv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then he gave them the following instructions: “I'm going to die soon. Bury me with my forefathers in the cave in the field of Ephron the Hittite. ");
INSERT INTO engfbv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","This is the cave in the field of Machpelah, near Mamre in Canaan, that Abraham bought together with the field from Ephron the Hittite to own as a burial site. ");
INSERT INTO engfbv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham and his wife Sarah were buried there, Isaac and his wife Rebekah were buried there, and I buried Leah there. ");
INSERT INTO engfbv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","The field and the cave were bought from the Hittites.” ");
INSERT INTO engfbv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","When Jacob finished giving these instructions he pulled up his feet into the bed, breathed his last, and joined his forefathers in death. ");
INSERT INTO engfbv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph went and hugged his father, weeping over him and kissing him. ");
INSERT INTO engfbv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Then Joseph instructed the physicians who worked for him to embalm his father's body. So the physicians embalmed Israel. ");
INSERT INTO engfbv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","This took a full 40 days, the normal time for the process, and the Egyptians mourned for him for 70 days. ");
INSERT INTO engfbv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Once the time of mourning was over, Joseph said to Pharaoh's officials, “If you'd be so kind, please speak to Pharaoh on my behalf, and explain to him that ");
INSERT INTO engfbv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","my father made me swear an oath, telling me, ‘You must bury me in the tomb I've prepared for myself in Canaan. Please allow me to go and bury my father and then I'll return.’” ");
INSERT INTO engfbv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh replied, “Go and bury your father as he made you swear to do.” ");
INSERT INTO engfbv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph went to bury his father, and all Pharaoh's officials went with him—all Pharaoh's senior advisors and all the leaders of Egypt— ");
INSERT INTO engfbv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","as well as Joseph's family, his brothers, and his father's family. They only left the small children and their flocks and herds back in Goshen. ");
INSERT INTO engfbv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","They were accompanied by chariots and horsemen—a really large procession. ");
INSERT INTO engfbv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","When they got to the threshing floor of Atad, on the other side of the Jordan, they wept loudly in sorrow. Joseph held a seven-day ceremony of mourning for his father there. ");
INSERT INTO engfbv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","The Canaanites who lived there watched the ceremony of mourning at the threshing floor of Atad. They said, “This is a very sad time of mourning for the Egyptians,” so they renamed the place Abel-mizraim, which is on the other side of the Jordan. ");
INSERT INTO engfbv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacob's sons did what he had instructed them to do. ");
INSERT INTO engfbv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","They carried his body to Canaan and buried him in the cave at Machpelah in the field near Mamre, which Abraham had bought from Ephron the Hittite as a burial site. ");
INSERT INTO engfbv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After they had buried their father, Joseph and his brothers returned to Egypt along with all those who had gone with them. ");
INSERT INTO engfbv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","However, now that their father was dead, Joseph's brothers became worried, saying, “Maybe Joseph is holding a grudge against us, and he'll pay us back for all the bad things we did to him.” ");
INSERT INTO engfbv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So they sent a message to Joseph to tell him, “Before your father died, he gave this order: ");
INSERT INTO engfbv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘This is what you are to tell Joseph: Forgive your brothers their sins, the bad things they did to you, treating you in such a nasty way.’ Now please forgive us our sins, we who are servants of the God of your father.” When Joseph received their message, he cried. ");
INSERT INTO engfbv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Then his brothers themselves came and fell down before Joseph and said, “We are your slaves!” ");
INSERT INTO engfbv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","“You don't need to be afraid!” he told them. “I don't stand in the place of God, do I? ");
INSERT INTO engfbv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","While you planned bad things for me, God planned it for good so that in the end many lives could be saved. ");
INSERT INTO engfbv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So don't worry. I'll go on taking care of you and your children.” Speaking kindly like this he calmed them down. ");
INSERT INTO engfbv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph remained in Egypt, together with his father's whole family. He lived to be 110, ");
INSERT INTO engfbv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","and saw three generations of his son Ephraim, and the sons of Makir, Manasseh's son, were placed in his lap when they were born. ");
INSERT INTO engfbv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","“I'm going to die soon,” Joseph told his brothers, “but God will be with you, and he will lead you out of this country to the land that he swore to give to Abraham, Isaac, and Jacob.” ");
INSERT INTO engfbv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph made the sons of Israel swear an oath, saying, “When God comes to be with you, you must take my bones with you when you leave.” ");
INSERT INTO engfbv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph died when he was 110. After his body was embalmed, he was placed in a coffin in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","These were the names of the sons of Israel (Jacob) who came with him to Egypt along with their families: ");
INSERT INTO engfbv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, and Judah; ");
INSERT INTO engfbv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, and Benjamin; ");
INSERT INTO engfbv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan and Naphtali, Gad and Asher. ");
INSERT INTO engfbv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jacob had 70 descendants there, including Joseph who was already in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Eventually Joseph and all his brothers and all that generation died. ");
INSERT INTO engfbv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","However, the Israelites had many children and their numbers increased rapidly. In fact there were so many of them that they became very powerful—the country was full of them. ");
INSERT INTO engfbv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Then a new king came to power who didn't know anything about Joseph. ");
INSERT INTO engfbv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He conferred with his fellow Egyptians and said, “Look at these Israelites—there are more of them than us, and they're more powerful than us. ");
INSERT INTO engfbv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Let's deal wisely with them before they become so many that if there's a war they'll side with our enemies and fight us, and flee the country.” ");
INSERT INTO engfbv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","So the Egyptians made them do forced labor and put taskmasters in charge of them. They used them to build the storage towns of Pithom and Rameses. ");
INSERT INTO engfbv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","But the more the Israelites were mistreated, the more they grew in numbers and spread out—and the more the Egyptians detested them. ");
INSERT INTO engfbv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","The Egyptians worked the Israelites brutally, ");
INSERT INTO engfbv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","making their lives a misery. They made them do hard labor, building with mortar and brick, and all kinds of heavy work in the fields. In all of this hard labor they treated them brutally. ");
INSERT INTO engfbv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Then the king gave orders to the Hebrew midwives, Shiphrah and Puah. ");
INSERT INTO engfbv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","He told them, “When you assist the Hebrew women during childbirth, if you see it's a boy, kill him; but if it's a girl, let her live.” ");
INSERT INTO engfbv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But because the midwives revered God, they didn't do what the king of Egypt had ordered. They let the boys live as well. ");
INSERT INTO engfbv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","The king of Egypt called the midwives in and demanded to know, “Why have you done this— letting the male children live?” ");
INSERT INTO engfbv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","“Hebrew women aren't like Egyptian women,” the midwives told Pharaoh. “They give birth more easily—they have them before we midwives arrive.” ");
INSERT INTO engfbv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","God treated the midwives well, and the people increased in number so there were even more of them. ");
INSERT INTO engfbv_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Because the midwives revered God, he gave them families of their own. ");
INSERT INTO engfbv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Then Pharaoh issued this order to all his people: “Throw every Hebrew boy that's born into the Nile, but let every girl live.” ");
INSERT INTO engfbv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","It was around this time that a man from the tribe of Levi married a woman, also a Levite. ");
INSERT INTO engfbv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","She became pregnant and had a son. She saw he was a lovely baby, and she hid him for three months. ");
INSERT INTO engfbv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","But when she couldn't hide him anymore, she got a papyrus basket and covered it with tar and pitch. Then she put her baby in the basket and placed it among the reeds along the bank of the Nile. ");
INSERT INTO engfbv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","His sister waited some distance away, keeping an eye on him. ");
INSERT INTO engfbv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Then Pharaoh's daughter arrived to bathe in the Nile. Her ladies-in-waiting were walking along the bank of the river. When she saw the basket among the reeds, she sent her maid to get it and bring it to her. ");
INSERT INTO engfbv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","When she opened it she saw the baby boy. He was crying and she felt sorry for him. “This must be one of the Hebrew boys,” she said. ");
INSERT INTO engfbv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","His sister asked Pharaoh's daughter, “Would you like me to go and find one of the Hebrew women to nurse him for you?” ");
INSERT INTO engfbv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Yes, go and do that,” she replied. So the girl went and called the baby's mother to come. ");
INSERT INTO engfbv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","“Take this baby boy and nurse him for me,” Pharaoh's daughter told his mother. “I will pay you myself.” So his mother took him home and nursed him. ");
INSERT INTO engfbv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","When the boy was older she took him to Pharaoh's daughter, who adopted him as her son. She called him Moses, because she said, “I pulled him out of the water.” ");
INSERT INTO engfbv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Later, when Moses had grown up, he went to visit his people, the Hebrews. He saw them doing hard labor. He also saw an Egyptian beating a Hebrew, one of his own people. ");
INSERT INTO engfbv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","He looked all around to make sure no one was watching, and then he killed the Egyptian and buried his body in the sand. ");
INSERT INTO engfbv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","The following day he went back and he saw two Hebrews fighting with each other. He said to the one at fault, “Why are you beating one of your own people?” ");
INSERT INTO engfbv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","“Who put you in charge to judge us?” the man replied. “Are you going to kill me like you did the Egyptian?” Moses became frightened at this, and said to himself, “People know what I've done!” ");
INSERT INTO engfbv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","When Pharaoh found out, he tried to have Moses killed, but Moses ran away from Pharaoh and went to live in Midian. One day as he was sitting by a well, ");
INSERT INTO engfbv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","the Midianite priest's seven daughters came to fetch water to fill up the troughs so their father's flock could drink. ");
INSERT INTO engfbv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Some shepherds arrived and chased them off, but Moses intervened and rescued them, and watered their flock. ");
INSERT INTO engfbv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","When they got home, their father Reuel asked them, “How did you get back so quickly today?” ");
INSERT INTO engfbv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","“An Egyptian rescued us from some shepherds who attacked us,” they replied. “Then he even fetched water for us so the flock could drink.” ");
INSERT INTO engfbv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“So where is he?” Reuel asked his daughters. “You didn't just leave him there, did you? Go and invite him to eat with us!” ");
INSERT INTO engfbv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses agreed to stay with the man, who arranged for his daughter Zipporah to marry Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","She had a son, and Moses named him Gershom, for he said, “I'm an exile living in a foreign country.” ");
INSERT INTO engfbv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Years later, the king of Egypt died. But the Israelites were still groaning under their hard labor. Their cries for help because of their hardship reached God. ");
INSERT INTO engfbv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","God heard their groans, and recalled his agreement with Abraham, Isaac, and Jacob. ");
INSERT INTO engfbv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God also looked sympathetically on the Israelites, and was concerned for them. ");
INSERT INTO engfbv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses was a shepherd, looking after the flock of Jethro, his father-in-law, the Midianite priest. He led the flock far into the wilderness until he came to God's mountain, Mount Horeb. ");
INSERT INTO engfbv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","There the angel of the Lord appeared to him in a flame of fire from inside a bush. Moses looked carefully and saw that though the bush was on fire, it wasn't being burned up. ");
INSERT INTO engfbv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“Let me go over and take a look,” Moses said to himself. “It's very odd to see a bush that's not burning up.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","When the Lord saw that Moses was coming to take a look, God called to him from inside the bush, “Moses! Moses!” “I'm here,” Moses replied. ");
INSERT INTO engfbv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Don't come any closer!” God told him. “Take off your sandals because you're standing on holy ground.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Then he said, “I am the God of your father, the God of Abraham, the God of Isaac, and the God of Jacob.” Moses covered his face, because he was afraid to look at God. ");
INSERT INTO engfbv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","“I'm completely aware of the misery of my people in Egypt,” the Lord told him. “I have heard them crying out because of their taskmasters. I know how much they're suffering. ");
INSERT INTO engfbv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","That's why I have come down to rescue them from Egyptian oppression and to take them up from that country to a productive, wide-open land—a land flowing with milk and honey—where currently the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites are living. ");
INSERT INTO engfbv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Listen! The cries of the Israelites have reached me, and I have seen how badly the Egyptians are mistreating them. ");
INSERT INTO engfbv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Now you must leave, because I'm sending you to Pharaoh to lead my people Israel out of Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","But Moses said to God, “Why me? I'm a nobody! I couldn't go to Pharaoh and lead the Israelites out of Egypt!” ");
INSERT INTO engfbv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","“I'll be with you,” the Lord replied, “and this will be the sign that it is really me who is sending you: when you have led the people out of Egypt, you will worship God at this very mountain.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Then Moses said to God, “Look! If I were to go to the Israelites and say to them, ‘The God of your fathers has sent me to you,’ and they ask me, ‘What is his name?’ —then what should I tell them?” ");
INSERT INTO engfbv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","God replied to Moses, “‘I Am’ is who I am. Tell the Israelites this: ‘I Am’ has sent me to you.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Then God said to Moses, “Tell the Israelites, ‘The Lord—the God of your fathers, the God of Abraham, the God of Isaac, and the God of Jacob—has sent me to you. This is my name forever, the name you are to call me for all generations to come.’ ");
INSERT INTO engfbv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Go, and call all the elders of Israel to meet with you. Tell them, ‘The Lord, the God of your fathers, has appeared to me—the God of Abraham, Isaac, and Jacob. He said, “I have paid close attention to what's been happening to you in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","I have decided to take you away from the misery you're having in Egypt and bring you to the land of the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites, a land flowing with milk and honey.” ");
INSERT INTO engfbv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“The elders of Israel will accept what you say. Then you must go with them to the king of Egypt and tell him, ‘The Lord, the God of the Hebrews has revealed himself to us. So please let us go three days journey into the desert so we can offer sacrifices to the Lord our God there.’ ");
INSERT INTO engfbv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","But I know that the king of Egypt won't let you go unless he's forced to do so by a power stronger than him. ");
INSERT INTO engfbv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","So I will use my power to inflict on Egypt all the terrifying things that I'm about to do to them. After that he'll let you go. ");
INSERT INTO engfbv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","I will make the Egyptians treat you well as a people, so when you go you won't leave empty-handed. ");
INSERT INTO engfbv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Every woman will ask her neighbor as well as any woman living in her house for silver and gold jewelry and clothing, and put them on your sons and daughters. In this way you will take the wealth of the Egyptians with you.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","“But what if they don't believe me or listen to what I say?” Moses asked. “They could say, ‘The Lord didn't appear to you.’” ");
INSERT INTO engfbv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","The Lord asked him, “What are you holding in your hand?” “A walking stick,” Moses replied. ");
INSERT INTO engfbv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","“Throw it on the ground,” he told Moses. So Moses did. It turned into a snake and Moses ran away from it. ");
INSERT INTO engfbv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","“Reach out and grab hold of it by its tail,” the Lord told Moses. Moses did so and it turned back into a walking stick in his hand. ");
INSERT INTO engfbv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“You are to do this so that they will believe that I the Lord did appear to you, the God of their fathers, the God of Abraham, Isaac, and Jacob.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Then the Lord told him, “Put your hand inside your clothes close to your chest.” So Moses did as he was told. When he took his hand out, it was white like snow with a skin disease. ");
INSERT INTO engfbv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“Now put your hand back inside your clothes,” the Lord said. Moses did so. When he took it out again, his hand had returned to normal. ");
INSERT INTO engfbv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“If they don't believe you and they're not convinced by the first sign, they'll believe because of the second sign,” the Lord explained. ");
INSERT INTO engfbv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","“But if they still don't believe you or listen to you because of these two signs, then you are to take some water from the Nile and pour it out on the ground. The Nile water will turn into blood on the ground.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Then Moses said to the Lord, “Please excuse me, but I'm not someone who is good with words—not in the past, and not from the time you have been speaking with me, your servant. My speech is slow and I don't say things well.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","“Who gave people mouths?” the Lord asked him. “Who makes people deaf or dumb, able to see or blind? It's I, the Lord, who does that. ");
INSERT INTO engfbv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Now go, and I myself will be your mouth, and I will tell you what you are to say.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","“Please, Lord, send someone else!” Moses responded. ");
INSERT INTO engfbv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","The Lord got angry with Moses, and told him, “There's your brother Aaron, the Levite. I know he speaks well. He's on his way to meet you, and he'll be very happy to see you. ");
INSERT INTO engfbv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Speak to him and tell him what to say. I will be your mouth and his mouth, and I will tell you what you are to do. ");
INSERT INTO engfbv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aaron will speak on your behalf to the people, as if he was your mouth, and you will be in the place of God to him. ");
INSERT INTO engfbv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Make sure to take your walking stick with you so you can use it to do the signs.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Then Moses returned to Jethro his father-in-law and told him, “Please allow me to go back to my own people in Egypt so I can see if any of them are still alive.” “Go with my blessing,” Jethro replied. ");
INSERT INTO engfbv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","While Moses was in Midian, the Lord told him, “Go back to Egypt because all those who wanted to kill you have died.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses put his wife and sons on a donkey and went back to Egypt, carrying the walking stick that God had used to perform miracles. ");
INSERT INTO engfbv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","The Lord told Moses, “When you get back to Egypt, make sure to go to Pharaoh and carry out the miracles I've given you to do. I will make him stubborn and he will not let the people go. ");
INSERT INTO engfbv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","This is what you are to tell Pharaoh, ‘This is what the Lord says. Israel is my firstborn son. ");
INSERT INTO engfbv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I ordered you to let my son go so he can worship me. But you refused to release him, so I will now kill your firstborn son.’” ");
INSERT INTO engfbv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","But while they were on their way the Lord came to the place where they were staying, wanting to kill Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","However, Zipporah used a flint knife to cut off her son's foreskin. She touched his feet with it, and said to him, “You are a blood-husband to me.” ");
INSERT INTO engfbv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Calling him a blood-husband referred to circumcision.) After this the Lord left Moses alone. ");
INSERT INTO engfbv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","The Lord had told Aaron, “Go and meet Moses in the desert.” So Aaron went and met Moses at the mountain of God and greeted him with a kiss. ");
INSERT INTO engfbv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Then Moses explained to Aaron everything the Lord had sent him to say and all the miracles he had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moses and Aaron traveled to Egypt. There they had all the Israelite elders gather together. ");
INSERT INTO engfbv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron shared with them everything the Lord had told Moses, and Moses carried out the miracles so they could see them. ");
INSERT INTO engfbv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","The Israelites were convinced. When they heard that the Lord had come to them, and that he had been touched by their suffering, they bowed their heads and worshiped. ");
INSERT INTO engfbv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","After this Moses and Aaron went to Pharaoh and told him, “This is what the Lord, the God of Israel says, ‘Let my people go so they can hold a religious festival for me in the desert.’” ");
INSERT INTO engfbv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","“Who is this ‘Lord’ that I should listen to his request to let Israel go?” Pharaoh replied. “I don't know the Lord and I certainly won't let Israel leave!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","“The God of the Hebrews came to us,” they added. “Please allow us to go a three-day journey into the desert and offer sacrifices to the Lord our God. Otherwise he'll kill us by disease or by the sword.” ");
INSERT INTO engfbv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","“Moses and Aaron, why are you trying to take people away from their assigned labor?” Pharaoh asked. “Get back to work!” he ordered. ");
INSERT INTO engfbv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","“Look here,” he went on. “There are many of your people here in our country and you are preventing them from doing their assigned labor.” ");
INSERT INTO engfbv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","That very day he ordered the slave drivers and those in charge of the people: ");
INSERT INTO engfbv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Don't give them any more straw to make bricks like before. Have them go and collect the straw themselves. ");
INSERT INTO engfbv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But still make them produce the same quantity of bricks as before. They're lazy people—that's why they're calling out, asking, ‘Please let us go and offer sacrifices to our god.’ ");
INSERT INTO engfbv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Make their work harder so they can get on with it and not pay any attention to all these lies!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the slave drivers and those in charge went out and told the people, “This is what Pharaoh has ordered: ‘I won't give you any more straw. ");
INSERT INTO engfbv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go and get straw for yourselves wherever you can find it, because your work quota won't be reduced.’” ");
INSERT INTO engfbv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people went all over Egypt collecting stubble for straw. ");
INSERT INTO engfbv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The slave drivers kept on forcing them, saying, “You still have to do the same work as you did when you had straw provided!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","They beat the Israelite supervisors they had put in charge, shouting at them, “Why haven't you met your quota of bricks as you did before?” ");
INSERT INTO engfbv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","The Israelite supervisors went to Pharaoh to complain, saying, “Why are you treating us your servants like this? ");
INSERT INTO engfbv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","You don't give us any straw but your slave drivers demand that we make bricks, and they beat us! Your people are treating us badly!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","“No, you're just lazy, lazy people!” Pharaoh replied. “That's why you keep on asking, ‘Please let us go and offer sacrifices to the Lord.’ ");
INSERT INTO engfbv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Now get out of here and go back to work! You won't be given any straw but you'll still have to produce the full quota of bricks!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Israelite supervisors realized they were in trouble when they were told, “You must not reduce the daily production of bricks.” ");
INSERT INTO engfbv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","They went over to Moses and Aaron who were waiting for them after their meeting with Pharaoh, ");
INSERT INTO engfbv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","and said, “May the Lord see what you have done and judge you accordingly! You have made us like a bad smell to Pharaoh and his officials. You have put a sword in their hands to kill us!” ");
INSERT INTO engfbv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moses went back to the Lord and complained, “Why have you caused all this trouble for your own people, Lord? Was this why you sent me? ");
INSERT INTO engfbv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ever since I went to Pharaoh to speak for you, he has been even harder on your people, and you haven't done anything to save them!” ");
INSERT INTO engfbv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","But the Lord told Moses, “Now you'll see what I'm going to do to Pharaoh. Using my great strength I will force him to let them go; because of my power he will send them out from his country.” ");
INSERT INTO engfbv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","God spoke to Moses and told him, “I am Yahweh! ");
INSERT INTO engfbv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I revealed myself as God Almighty to Abraham, to Isaac, and to Jacob, but they didn't know my name, ‘Yahweh.’ ");
INSERT INTO engfbv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I also confirmed my solemn agreement with them to give them the land of Canaan, the country where they were living as foreigners. ");
INSERT INTO engfbv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","In addition I've heard the groans of the Israelites that the Egyptians are treating as slaves, and I haven't forgotten the agreement I promised them. ");
INSERT INTO engfbv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","So tell the Israelites, ‘I am the Lord and I will save you from the forced labor the Egyptians are making you do; I will set you free from being their slaves. I will rescue you using my power and imposing heavy punishments. ");
INSERT INTO engfbv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","I will make you my own people. Then you will know that I am the Lord your God, who rescued you from slavery in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I will take you to the land that I solemnly promised to give to Abraham, Isaac, and Jacob. I will give it to you to own. I am the Lord!’” ");
INSERT INTO engfbv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moses explained this to the Israelites but they did not listen to him, because they were so discouraged and because of the hard labor they were forced to do. ");
INSERT INTO engfbv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Then the Lord said to Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go and speak to Pharaoh, king of Egypt. Tell him to let the Israelites leave his country.” ");
INSERT INTO engfbv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","But Moses replied, “Even my own people don't listen to me. Why would Pharaoh listen to me, especially since I'm such a poor speaker?” ");
INSERT INTO engfbv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","But the Lord spoke to Moses and Aaron, and told them what to do regarding the people of Israel and Pharaoh, king of Egypt, in order to bring the Israelites out of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These were the Israelite family heads. The sons of Reuben, the firstborn son of Israel, were Hanok and Pallu, Hezron and Karmi. These were the families of Reuben. ");
INSERT INTO engfbv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","The sons of Simeon were Jemuel, Jamin, Ohad, Jachin, Zohar, and Shaul (the son of a Canaanite woman). These were the families of Simeon. ");
INSERT INTO engfbv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","These were the names of the sons of Levi according to their genealogical records: Gershon, Kohath, and Merari. Levi lived for 137 years. ");
INSERT INTO engfbv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","The sons of Gershon, by families, were Libni and Shimei. ");
INSERT INTO engfbv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","The sons of Kohath were Amram, Izhar, Hebron, and Uzziel. Kohath lived for 133 years. ");
INSERT INTO engfbv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","The sons of Merari were Mahli and Mushi. These were the families of the Levites according to their genealogical records. ");
INSERT INTO engfbv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram married his father's sister Jochebed, and she had their sons Aaron and Moses. Amram lived for 137 years. ");
INSERT INTO engfbv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","The sons of Izhar were Korah, Nepheg, and Zichri. ");
INSERT INTO engfbv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","The sons of Uzziel were Mishael, Elzaphan, and Sithri. ");
INSERT INTO engfbv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron married Elisheba, daughter of Amminadab and sister of Nahshon. She had their sons Nadab and Abihu, Eleazar and Ithamar. ");
INSERT INTO engfbv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah were Assir, Elkanah, and Abiasaph. These were the Korahite families. ");
INSERT INTO engfbv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, son of Aaron, married one of the daughters of Putiel, and she had their son Phinehas. These are the ancestors of the Levite families, listed according to their clans. Eleazar son of Aaron married one of the daughters of Putiel, and she gave birth to his son, Phinehas. These are the heads of the Levite families, listed by family. ");
INSERT INTO engfbv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron and Moses mentioned here are the ones the Lord told, “Lead the Israelites out of Egypt, divided up in their respective tribes.” ");
INSERT INTO engfbv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moses and Aaron were also the ones who went to speak with Pharaoh, king of Egypt, about the Israelites leaving Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","When the Lord spoke to Moses in Egypt, ");
INSERT INTO engfbv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","he said to him, “I am the Lord. Tell Pharaoh, king of Egypt, all that I tell you.” ");
INSERT INTO engfbv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Moses replied, “I'm not a good speaker—why would Pharaoh listen to me?” ");
INSERT INTO engfbv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","The Lord told Moses, “Look, I will make you seem like God to Pharaoh, and your brother Aaron will be your prophet. ");
INSERT INTO engfbv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You are to repeat everything that I tell you to say, and your brother Aaron must repeat it to Pharaoh so that he will let the Israelites leave his country. ");
INSERT INTO engfbv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will give Pharaoh a stubborn attitude, and though I will perform many signs and wonders in Egypt, he won't listen to you. ");
INSERT INTO engfbv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Then I will attack Egypt, imposing heavy punishments on them, and I will lead out by their tribes my people the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","In this way the Egyptians will know that I am the Lord—when I take action against Egypt and lead the Israelites out of the country.” ");
INSERT INTO engfbv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses and Aaron did exactly as the Lord had ordered. ");
INSERT INTO engfbv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was eighty and Aaron was eighty-three when they went and spoke to Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“When Pharaoh asks you, ‘Why don't you perform a miracle, then?’ tell Aaron, ‘Take your walking stick and throw it down in front of Pharaoh,’ and it will turn into a snake.” ");
INSERT INTO engfbv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moses and Aaron went to Pharaoh and did what the Lord had ordered. Aaron threw down his staff in front of Pharaoh and his officials, and it turned into a snake. ");
INSERT INTO engfbv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","But Pharaoh called in wise men and sorcerers, and these Egyptian magicians did the same thing using their magic arts. ");
INSERT INTO engfbv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Each of them threw down their walking sticks and they also turned into snakes, but Aaron's walking stick swallowed up all their walking sticks. ");
INSERT INTO engfbv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","But Pharaoh had a hard, stubborn attitude, and he wouldn't listen to them, as the Lord had predicted. ");
INSERT INTO engfbv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","The Lord said to Moses, “Pharaoh has a stubborn attitude—he's refusing to let the people go. ");
INSERT INTO engfbv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","So tomorrow morning go to Pharaoh as he walks down to the river. Wait to meet him on the bank of the Nile. Take with you the walking stick that turned into a snake. ");
INSERT INTO engfbv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tell him: The Lord, the God of the Hebrews, has sent me to say to you, ‘Let my people go, so that they can worship me in the desert. But you have not listened up until now. ");
INSERT INTO engfbv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","This is what the Lord is now telling you: This is how you will know that I am the Lord.’” “Watch! Using the walking stick I'm holding, I'm going to hit the water of the Nile, and it will turn to blood. ");
INSERT INTO engfbv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","The fish in the Nile will die, the river will smell, and the Egyptians won't be able to drink any of its water.” ");
INSERT INTO engfbv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","The Lord said to Moses, “Tell Aaron, ‘Take your walking stick in your hand and hold it out over the waters of Egypt, over their rivers and canals and ponds and pools, so that they will turn to blood. There will be blood through all of Egypt, even in containers made of wood and stone.’” ");
INSERT INTO engfbv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moses and Aaron did exactly as the Lord had ordered. While Pharaoh and all his officials watched, Aaron lifted up his walking stick and hit the water of the Nile. Immediately the whole river turned to blood! ");
INSERT INTO engfbv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","The fish in the Nile died, and the river smelled so awful that the Egyptians could not drink its water. There was blood through all of Egypt! ");
INSERT INTO engfbv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","But the Egyptian magicians did the same thing using their magic arts. Pharaoh maintained his stubborn attitude and he wouldn't listen to Moses and Aaron, just as the Lord had predicted. ");
INSERT INTO engfbv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh went back to his palace and didn't pay any attention to what had happened. ");
INSERT INTO engfbv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","All the Egyptians dug alongside the Nile because they couldn't drink its water. ");
INSERT INTO engfbv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Seven days went by after the Lord hit the Nile. ");
INSERT INTO engfbv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then the Lord told Moses, “Go and see Pharaoh and say to him, ‘This is what the Lord says: Let my people go, so that they can worship me. ");
INSERT INTO engfbv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","If you refuse to let them leave, I will send a plague of frogs all over your country. ");
INSERT INTO engfbv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","They will swarm out of the Nile, and they will enter your palace and get into your bedroom and jump onto your bed. They will get into the houses of your officials and jump around your people—even into your ovens and breadmaking bowls. ");
INSERT INTO engfbv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Frogs will jump all over you, your people, and all your officials.’” ");
INSERT INTO engfbv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","The Lord said to Moses, “Tell Aaron, ‘Hold out your walking stick in your hand over the rivers and canals and ponds, and make frogs spread over Egypt.’” ");
INSERT INTO engfbv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","So Aaron held out his hand over the waters of Egypt, and frogs came up and covered the land. ");
INSERT INTO engfbv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","But the Egyptian magicians did the same thing using their magic arts. They brought up frogs in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pharaoh called for Moses and Aaron and pleaded with them, “Pray to the Lord, and ask him to take away the frogs from me and my people. Then I will let your people go so they can offer sacrifices to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","“You may have the honor of deciding when I'll pray for you, your officials, and your people that the frogs will be removed from you and your houses. They will remain only in the Nile.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“Do it tomorrow,” Pharaoh replied. Moses said, “It will happen as you have requested so you will know that there is no one like the Lord our God. ");
INSERT INTO engfbv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will leave you and your houses, your officials and your people, and they will remain only in the Nile.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses and Aaron left Pharaoh, and Moses pleaded with the Lord about the frogs he had sent against Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","The Lord did as Moses asked. The frogs in the houses, the courtyards, and the fields died. ");
INSERT INTO engfbv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","The people collected them in pile upon pile, and the whole country smelled terrible. ");
INSERT INTO engfbv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh realized the plague had passed, he chose to become hard and stubborn again, and wouldn't listen to Moses and Aaron, just as the Lord had predicted. ");
INSERT INTO engfbv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","The Lord said to Moses, “Tell Aaron, ‘Pick up your walking stick and hit the dust of the ground. The dust will become gnats swarming all over Egypt.’” ");
INSERT INTO engfbv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","They did what the Lord said. When Aaron lifted up his walking stick and hit the dust of the earth, gnats swarmed over both people and animals. The dust in the whole of Egypt turned into gnats. ");
INSERT INTO engfbv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The magicians also tried to make gnats using their magic arts, but they couldn't. The gnats stayed on both people and animals. ");
INSERT INTO engfbv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","“This is an act of God,” the magicians told Pharaoh. But Pharaoh chose to be stubbornly hard-hearted, and he wouldn't listen to Moses and Aaron, just as the Lord had predicted. ");
INSERT INTO engfbv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","The Lord told Moses, “Tomorrow morning get up early and block Pharaoh's way as he walks down to the river. Tell him, ‘This is what the Lord says: Let my people go, so that they can worship me. ");
INSERT INTO engfbv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","If you don't let my people leave, I will send swarms of flies on you and your officials, and on your people and your houses. Every Egyptian house and even the ground on which they stand will be filled with swarms of flies. ");
INSERT INTO engfbv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","However, on this occasion I will treat the land of Goshen differently—that's where my people live—there won't be any swarms of flies there. This is how you will know that I, the Lord, am here in your country. ");
INSERT INTO engfbv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","I will distinguish my people from your people. You will see this sign that confirms it tomorrow.’” ");
INSERT INTO engfbv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","The Lord did what he had said. Huge swarms of flies swept into Pharaoh's palace and into the houses of his officials. The whole of Egypt was devastated because of these swarms of flies. ");
INSERT INTO engfbv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaoh called for Moses and Aaron and told them, “Go and offer sacrifices to your God here in this country.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","“No, that wouldn't be the right thing to do,” Moses replied. “The sacrifices we offer to the Lord our God would be offensive to Egyptians. If we went ahead and offered sacrifices offensive to Egyptians, they'd stone us! ");
INSERT INTO engfbv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","We must make a three-day journey into the wilderness and offer sacrifices there to the Lord our God as he has told us.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","“I'll let you go and offer sacrifices to the Lord your God in the desert, but don't go very far,” Pharaoh answered. “Now pray for me that this plague ends.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","“As soon as I leave you, I will pray to the Lord,” Moses replied, “and tomorrow the flies will leave Pharaoh and his officials and his people. But Pharaoh should be sure not to be deceitful again and refuse to let the people go and offer sacrifices to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moses left Pharaoh and prayed to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","and the Lord did as Moses asked, and removed the swarms of flies from Pharaoh and his officials and his people. Not a single fly remained. ");
INSERT INTO engfbv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But once again Pharaoh chose to be stubbornly hard-hearted and would not let the people leave. ");
INSERT INTO engfbv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","The Lord told Moses, “Go and speak to Pharaoh. Tell him, ‘This is what the Lord says: Let my people go, so that they can worship me. ");
INSERT INTO engfbv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","If you refuse to let them go and keep holding on to them, ");
INSERT INTO engfbv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","I will punish you by bringing a very severe plague on your livestock—on your horses, donkeys, camels, herds, and flocks. ");
INSERT INTO engfbv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But the Lord will distinguish between the livestock of the Israelites and the Egyptians, so that none of those belonging to the Israelites will die. ");
INSERT INTO engfbv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","The Lord has set a time, saying, Tomorrow this is what is going to happen here in the country.’” ");
INSERT INTO engfbv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","The following day the Lord did what he had said. All the Egyptians' livestock died, but not a single animal belonging to the Israelites died. ");
INSERT INTO engfbv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh sent out officials and discovered that not a single one of the Israelites' livestock had died. But Pharaoh was stubborn, and he would not let the people leave. ");
INSERT INTO engfbv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","The Lord told Moses and Aaron, “Go and get some handfuls of soot from a furnace. Then have Moses throw it into the air in front of Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","It will spread like fine dust over the whole country of Egypt, and open sores will break out on people and animals throughout the land.” ");
INSERT INTO engfbv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","They got soot from a furnace, and went to see Pharaoh. Moses threw it into the air, and open sores broke out on people and animals. ");
INSERT INTO engfbv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians were unable to come and appear before Moses, because they and all the other Egyptians were covered in sores. ");
INSERT INTO engfbv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","But the Lord gave Pharaoh a stubborn attitude, and he would not listen to them, just as the Lord had told Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","The Lord told Moses, “Tomorrow morning get up early and go to Pharaoh, and tell him that this is what the Lord, the God of the Hebrews, says: ‘Let my people go, so that they can worship me. ");
INSERT INTO engfbv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","This time I will direct all my plagues against you and your officials and your people, so you will realize that there is no one like me in all the earth. ");
INSERT INTO engfbv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","By now I could have reached out to strike you and your people with a plague that would have completely destroyed you. ");
INSERT INTO engfbv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","However, I have let you live so you can see my power, and that my reputation may be spread throughout the earth. ");
INSERT INTO engfbv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","But in your pride you are still tyrannizing my people, and refuse to let them leave. ");
INSERT INTO engfbv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","So watch out! About this time tomorrow I will send down the worst hailstorm that has ever fallen on Egypt, from the beginning of its history until now. ");
INSERT INTO engfbv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","So order your livestock and everything you have in the field to be brought inside. Every person and every animal that stays outside and is not brought inside will die when the hail falls on them.’” ");
INSERT INTO engfbv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Those of Pharaoh's officials who took seriously what the Lord said rushed to bring their servants and livestock inside. ");
INSERT INTO engfbv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","But those who didn't care what the Lord said left their servants and livestock outside. ");
INSERT INTO engfbv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","The Lord told Moses, “Lift your hand towards the sky so that a hailstorm will fall over the whole of Egypt, on people and on animals, and on everything growing in the fields of Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moses held up his staff toward heaven, and the Lord sent thunder and hail, and made lightning hit the ground. This is how the Lord rained hail down on Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","As the hail fell it was accompanied by lightning flashing back and forth. The hail that fell was so severe that nothing like it had ever been seen in the whole of Egypt since the beginning of its history. ");
INSERT INTO engfbv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","All across Egypt hail hit everything in the fields, both people and animals. It knocked down everything growing in the fields, and stripped every tree bare. ");
INSERT INTO engfbv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Only in the land of Goshen where the Israelites lived was there no hail. ");
INSERT INTO engfbv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaoh called for Moses and Aaron and told them, “I admit that I sinned this time! The Lord is right, and I and my people are wrong! ");
INSERT INTO engfbv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pray to the Lord for us, because there's been more than enough of God's thunder and hail. I will let you leave. You don't need to stay here any longer.” ");
INSERT INTO engfbv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","“Once I've left the city, I will pray to the Lord for you,” Moses told him. “The thunder will stop, and there'll be no more hail, so that you will realize that the earth belongs to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But I know you and your officials still do not really respect the Lord our God.” ");
INSERT INTO engfbv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(The flax and barley were destroyed, because the barley was ripe and the flax was flowering. ");
INSERT INTO engfbv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","However, the wheat and the spelt were not destroyed because they grow later.) ");
INSERT INTO engfbv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses left Pharaoh and went out of the city, and prayed to the Lord. The thunder and hail stopped, and the rainstorm finished. ");
INSERT INTO engfbv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain and hail and thunder had stopped, he sinned again, and he chose to become stubborn again, along with his officials. ");
INSERT INTO engfbv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Because of his stubborn attitude, Pharaoh would not let the Israelites leave, just as the Lord had predicted through Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","The Lord told Moses, “Go and see Pharaoh, because it was me who gave him and his officials a stubborn attitude so that I may perform my miracles before them. ");
INSERT INTO engfbv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","This is so you can tell your children and grandchildren how I made the Egyptians look foolish by doing these miracles among them, and so that you may know that I am the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moses and Aaron went to Pharaoh and told him, “This is what the Lord, the God of the Hebrews, says: ‘How long are you going to refuse to humble yourself before me? Let my people go, so that they can worship me. ");
INSERT INTO engfbv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","If you refuse to let my people leave, tomorrow I will send a plague of locusts into your country. ");
INSERT INTO engfbv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","There will be so many of them that they'll cover the ground so no one can see it. They will eat whatever crops were left by the hail, as well as every tree growing in your fields. ");
INSERT INTO engfbv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will swarm into your houses and into the houses of all your officials—in fact into the houses of every Egyptian. This is something that none of your forefathers ever saw from the time they arrived in this country.’” Then Moses and Aaron turned and left Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh's officials came to him and asked, “How long are you going to let this man cause us trouble? Let these people go so they can worship the Lord their God. Don't you realize that Egypt has been destroyed?” ");
INSERT INTO engfbv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Moses and Aaron were brought back to see Pharaoh. “Go and worship the Lord your God,” he told them. “But who of you will be going?” ");
INSERT INTO engfbv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“We will all go,” Moses replied. “Young and old, sons and daughters—and we'll take our flocks and herds with us, for we're going to have a religious festival for the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","“The Lord really would have to be with you if I let your children go with you!” Pharaoh answered. “Clearly you're planning some kind of evil trick! ");
INSERT INTO engfbv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","So no! Only the men can go and worship the Lord, because that's what you've been asking for.” Then he had Moses and Aaron thrown out. ");
INSERT INTO engfbv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","The Lord told Moses, “Lift up your hand over Egypt, so that the locusts may swarm over it and eat every plant in the country—everything that was left by the hail.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses held out his staff over Egypt, and all through that day and night the Lord sent an east wind blowing over the land. By the time morning came the east wind had brought in the locusts. ");
INSERT INTO engfbv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts swarmed across the land and settled in every part of the country. There had never been such a swarm of locusts ever before, and there won't be ever again. ");
INSERT INTO engfbv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the ground until it looked black, and they ate up all the plants in the fields and all the fruit on the trees that had been left by the hail. Not a single green leaf was left on any tree or plant anywhere in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaoh called urgently for Moses and Aaron and said, “I have sinned against the Lord your God and against you. ");
INSERT INTO engfbv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","So please forgive my sin just this one time and plead with the Lord your God, asking him to at least take away this deathly plague from me.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses left Pharaoh and prayed to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","The Lord changed the direction of the wind so that a strong westerly wind blew the locusts into the Red Sea. There wasn't a single locust left anywhere in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the Lord made Pharaoh stubborn, and he would not let the Israelites go. ");
INSERT INTO engfbv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","The Lord told Moses, “Lift your hand toward the sky so that darkness will fall over Egypt, darkness so thick that it can be felt.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses lifted up his hand toward heaven, and the whole of Egypt went completely dark for three days. ");
INSERT INTO engfbv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","No one could see anyone else, and no one moved from where they were for three days. But there was still light where all the Israelites lived. ");
INSERT INTO engfbv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Eventually Pharaoh called for Moses. “Go and worship the Lord,” he said. “Just leave your flocks and herds here. You can even take your children with you.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","But Moses replied, “You must also let us have animals for sacrifices and burnt offerings, so we can offer them to the Lord our God. ");
INSERT INTO engfbv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Our livestock have to go with us too—not a single animal will be left behind. We'll need some of them to worship the Lord our God, and we won't know how we are to worship the Lord until we get there.” ");
INSERT INTO engfbv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","But the Lord made Pharaoh stubborn, and he would not let them go. ");
INSERT INTO engfbv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh shouted at Moses, “Get out of here! I don't want to see you ever again! If I ever do see you again you'll die!” ");
INSERT INTO engfbv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“May it be as you say,” Moses replied. “I won't see you again.” ");
INSERT INTO engfbv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","The Lord told Moses, “There's one last plague I will bring down on Pharaoh and on Egypt. After that he will let you go, but when he does, he'll expel every one of you from the country. ");
INSERT INTO engfbv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Now go and tell the Israelites, both men and women, to ask their Egyptian neighbors for silver and gold objects.” ");
INSERT INTO engfbv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","The Lord made the Egyptians look favorably on the Israelites. In fact, Moses himself was highly respected in Egypt by both Pharaoh's officials and the ordinary people. ");
INSERT INTO engfbv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses said, “This is what the Lord says: Around midnight I will go through the whole of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Every firstborn son in the land of Egypt will die, from the firstborn of Pharaoh sitting on his throne to the firstborn of the servant girl working with a handmill, as well as all the firstborn of the cattle. ");
INSERT INTO engfbv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","There will be loud cries of mourning all over Egypt, such as have never been before, and will never be again. ");
INSERT INTO engfbv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But among all the Israelites there won't even be the sound of a dog barking at them or their animals. That way you will know that the Lord distinguishes between Egypt and Israel. ");
INSERT INTO engfbv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","All your officials will come to me, bowing down before me and saying, ‘Leave, and take everyone who follows you with you!’ After that I will leave.” Moses was very angry, and left Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","The Lord said to Moses, “Pharaoh is refusing to listen to you so I can do even more miracles in Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moses and Aaron did these miracles before Pharaoh, but the Lord gave Pharaoh a stubborn attitude, and he wouldn't let the Israelites leave his country. ");
INSERT INTO engfbv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","The Lord told Moses and Aaron while they were still in Egypt, ");
INSERT INTO engfbv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“This month will be for you the first month, the first month of your year. ");
INSERT INTO engfbv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Tell all the Israelites that on the tenth day of this month, every man must choose a lamb for his family, one for each household. ");
INSERT INTO engfbv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","However, if the household is too small for a whole lamb, then he and his nearest neighbor may choose a lamb according to the total number of people. Divide up the lamb depending on what everybody can eat. ");
INSERT INTO engfbv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Your lamb must be a year-old male without any defects, and you can take it either from the sheep or the goats. ");
INSERT INTO engfbv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Keep it until the fourteenth day of the month, when all the Israelites will slaughter the animals after sunset and before it gets dark. ");
INSERT INTO engfbv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","They are to take some of the blood and put it on the sides and tops of the doorframes of the houses where they have the meal. ");
INSERT INTO engfbv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","They are to roast the meat over a fire and eat it that night, together with unleavened bread and bitter herbs. ");
INSERT INTO engfbv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","You are not to eat the meat raw or boiled in water. All of it must be roasted over a fire, including the head, legs, and its insides. ");
INSERT INTO engfbv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Make sure nothing is left until the morning. If there is anything left over, burn it by morning. ");
INSERT INTO engfbv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","This is how you are to eat the meal. You should be dressed ready to travel, with your sandals on your feet and your walking stick in your hand. You are to eat quickly—it is the Lord's Passover. ");
INSERT INTO engfbv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","That very night I will go all through Egypt and kill every firstborn of both people and animals, and I will bring condemnation on all the gods of Egypt. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","The blood on the houses where you live will mark them out. When I see the blood, I will pass over you. No deathly plague will fall on you to destroy you when I attack Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","This will be a day to remember for you. You are to celebrate it as a festival to the Lord for generations to come. You will observe this for all time to come. ");
INSERT INTO engfbv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For seven days you must eat only bread made without yeast. On the first day you are to get rid of the yeast from your houses. Anyone who eats anything with yeast from the first day to the seventh day must be excluded from the Israelite community. ");
INSERT INTO engfbv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","On both the first day and on the seventh day you are to have a holy meeting. You must not work on those days, except to prepare food. That is all you are allowed to do. ");
INSERT INTO engfbv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","You are to keep the Feast of Unleavened Bread because on this very day I led your tribes by their respective divisions out of Egypt. You are to observe this day for all time to come. ");
INSERT INTO engfbv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","In the first month you are to eat bread without yeast from the evening of the fourteenth day until the evening of the twenty-first day. ");
INSERT INTO engfbv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","For seven days there must be no yeast in your houses. If anyone eats something with yeast in it, then they must be excluded from the Israelite community, whether they are a foreigner or a native of the land. ");
INSERT INTO engfbv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","You must not eat anything with yeast in it. Eat only bread without yeast in all your homes.” ");
INSERT INTO engfbv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Then Moses called together all the elders of Israel and told them, “Go immediately and choose a lamb for each of your families, and kill the Passover lamb. ");
INSERT INTO engfbv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Get a bunch of hyssop, dip it into the blood in the basin, and put some on the top and sides of the doorframe. None of you are to go out through door of the house until morning. ");
INSERT INTO engfbv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","When the Lord passes through to punish the Egyptians, he will see the blood on the top and sides of the doorframe. He will pass over the door, and he will not allow the destroyer to enter your houses and kill you. ");
INSERT INTO engfbv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You and your descendants are to remember to observe these instructions for all time to come. ");
INSERT INTO engfbv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","When you enter the land that the Lord promised to give you, you are to observe this ceremony. ");
INSERT INTO engfbv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children come and ask you, ‘Why is this ceremony important to you?’ ");
INSERT INTO engfbv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","you are to tell them, ‘This is the Passover sacrifice to the Lord. He was the one who passed over the houses of the Israelites in Egypt when he killed the Egyptians but spared our households.’” The people bowed down in worship. ");
INSERT INTO engfbv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Then the Israelites went and did just as the Lord had told Moses and Aaron. ");
INSERT INTO engfbv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","At midnight the Lord killed every firstborn male in the land of Egypt, from the firstborn of Pharaoh, who sat on his throne, to the firstborn of the prisoner in the jail, and also all the firstborn of the livestock. ");
INSERT INTO engfbv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaoh got up during the night, as well as all his officials and all the Egyptians. There were loud cries of agony throughout Egypt, because there wasn't a single house where someone hadn't died. ");
INSERT INTO engfbv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pharaoh called for Moses and Aaron during the night and told them, “Get out of here! Leave my people, the two of you and the Israelites! Go, so you can worship the Lord as you have asked. ");
INSERT INTO engfbv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take your flocks and herds as well, just like you've said, and leave! Oh, and bless me too.” ");
INSERT INTO engfbv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","The Egyptians urged the Israelites to leave their country as quickly as possible, saying, “Otherwise we'll all die!” ");
INSERT INTO engfbv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","So the Israelites picked up their dough before it had risen, and carried it on their shoulders in kneading bowls wrapped in clothing. ");
INSERT INTO engfbv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","In addition, the Israelites did what Moses had told them and asked the Egyptians for objects of silver and gold, and for clothing. ");
INSERT INTO engfbv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","The Lord had made the Egyptians look so favorably on the Israelites that they agreed to their request. In this way they took the wealth of the Egyptians. ");
INSERT INTO engfbv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israelites set out on foot from Rameses for Succoth and numbered about 600,000 men, as well as women and children. ");
INSERT INTO engfbv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","In addition many foreigners joined them. They also took with them large herds and flocks of livestock. ");
INSERT INTO engfbv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Since their bread dough didn't have any yeast, the Israelites baked what they had brought out of Egypt into loaves without yeast. This was because when they were driven out of Egypt they had to leave in a hurry and didn't have time to prepare food for themselves. ");
INSERT INTO engfbv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","The Israelites had lived in Egypt for 430 years. ");
INSERT INTO engfbv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","On the very day the 430 years ended, all the tribes of the Lord by their respective divisions left Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Because the Lord kept watch that night to lead them out of the land of Egypt, this same night you are to keep watch as an observance to honor the Lord, and this to be kept by all Israelites for generations to come. ");
INSERT INTO engfbv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","The Lord told Moses and Aaron, “This is the Passover ceremony. No foreigner is allowed to eat it. ");
INSERT INTO engfbv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","But any slave who has been bought can eat it once you have circumcised him. ");
INSERT INTO engfbv_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Foreign visitors or those hired from other nations shall not eat the Passover. ");
INSERT INTO engfbv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","It has to be eaten inside the house. You are not allowed to take any of the meat outside the house, or to break any of the bones. ");
INSERT INTO engfbv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","All Israelites are to celebrate it. ");
INSERT INTO engfbv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","If there's a foreigner who lives with you and wants to celebrate the Lord's Passover, all the males in their household have to be circumcised. Then he may come and celebrate it, and he shall be treated like a native of the land. But no man who is not circumcised may eat it. ");
INSERT INTO engfbv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","The same rule applies to both the native and the foreigner who lives among you.” ");
INSERT INTO engfbv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Then all the Israelites followed these instructions. They did exactly what the Lord had commanded Moses and Aaron. ");
INSERT INTO engfbv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","That very day the Lord led the Israelite tribes out of Egypt by their respective tribal divisions. ");
INSERT INTO engfbv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Every firstborn male is to be dedicated to me. The firstborn from every Israelite family belongs to me, and also every firstborn animal.” ");
INSERT INTO engfbv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","So Moses told the people, “Remember this is the day you left Egypt, the land of your slavery, for the Lord led you out of it by his amazing power. (Nothing with yeast in it shall be eaten.) ");
INSERT INTO engfbv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Today you are on your way, this day in the month of Abib. ");
INSERT INTO engfbv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","The Lord is going to take you into the land of the Canaanites, Hittites, Amorites, Hivites, and Jebusites, the land he promised your forefathers he would give you, a land flowing with milk and honey. So you are to observe this ceremony in this month. ");
INSERT INTO engfbv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","For seven days you are to only eat bread without yeast, and on the seventh day hold a religious festival to honor the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Only bread without yeast is to be eaten during those seven days. You are not to have any yeast, in fact there is to be no yeast in any place where you live. ");
INSERT INTO engfbv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","On that day tell your children, ‘This is because of what the Lord did for me when I left Egypt.’ ");
INSERT INTO engfbv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","When you celebrate this ceremony it will be like a sign on your hand and a reminder between your eyes that this teaching of the Lord should be spoken about regularly. For the Lord led you out of Egypt with his great power. ");
INSERT INTO engfbv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","That's why you are to observe this ceremony at the proper time every year. ");
INSERT INTO engfbv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Once the Lord takes you into the land of the Canaanites and gives it to you, as he promised you and your forefathers, ");
INSERT INTO engfbv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","you are to present to the Lord all firstborn males, human or animal. The firstborn males of your livestock all belong to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","You must buy back every firstborn donkey with a lamb, and if you don't do so, you have to break its neck. You must buy back every firstborn of your sons. ");
INSERT INTO engfbv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","When in the future your children come to you and ask, ‘Why is this ceremony important to you?’ you are to tell them, ‘The Lord led us out of Egypt, the land of our slavery, by his amazing power. ");
INSERT INTO engfbv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pharaoh stubbornly refused to let us leave, so the Lord killed every firstborn in the land of Egypt, both human and animal. That's the reason why I sacrifice to the Lord the firstborn male of every animal, and I buy back all the firstborn of my sons.’ ");
INSERT INTO engfbv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","In this way it will be like a sign on your hand and a reminder between your eyes, for the Lord led us out of Egypt by his amazing power.” ");
INSERT INTO engfbv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","When Pharaoh let the Israelites leave, God did not lead them along the road through the land of the Philistines, even though that was a shorter way. For God said, “If they are forced to fight, they might change their minds and go back to Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So God led the people by the longer way through the desert towards the Red Sea. When the Israelites left the land of Egypt they were like an army ready for battle. ");
INSERT INTO engfbv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses carried Joseph's bones with him because Joseph had made the sons of Israel swear a solemn promise, saying, “God will definitely take care of you, and then you must take my bones with you when you leave here.” ");
INSERT INTO engfbv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","They traveled on from Succoth and camped at Etham on the edge of the desert. ");
INSERT INTO engfbv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","The Lord went ahead of them as a pillar of cloud to show them the way during the day, and as a pillar of fire to provide them with light at night. Like this they could travel by day or night. ");
INSERT INTO engfbv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","The pillar of cloud during the day and the pillar of fire at night were always in front of the people. ");
INSERT INTO engfbv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tell the Israelites to turn back and set up camp near Pi-hahiroth, between Migdol and the sea. You are to camp beside the sea, opposite Baal-zephon. ");
INSERT INTO engfbv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh will conclude about the Israelites: ‘They're wandering about the country in confusion—the desert has blocked them from leaving.’ ");
INSERT INTO engfbv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I will give Pharaoh a stubborn attitude so that he will chase after them to get them back. But I will gain respect through what happens to Pharaoh and all his army, and the Egyptians will know that I am the Lord.” So the Israelites did as they were instructed. ");
INSERT INTO engfbv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","When the king of Egypt found out that the Israelites had left in a hurry, Pharaoh and his officials changed their minds about what had happened and said, “What have we done? We have let all these Israelite slaves go!” ");
INSERT INTO engfbv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","So Pharaoh had his chariot made ready and set out with his army. ");
INSERT INTO engfbv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took 600 of his best chariots along with all the other chariots of Egypt, each with their officer-in-charge. ");
INSERT INTO engfbv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","The Lord gave Pharaoh, king of Egypt, a stubborn attitude so he chased after the Israelites, who were leaving with their fists raised in triumph. ");
INSERT INTO engfbv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","The Egyptians set out in pursuit—all Pharaoh's horses and chariots, horsemen and soldiers. They caught up with the Israelites while they were camped beside the sea near Pi-hahiroth, opposite Baal-zephon. ");
INSERT INTO engfbv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","The Israelites looked back and saw Pharaoh and the Egyptian army approaching. They were absolutely terrified and cried out to the Lord for help. ");
INSERT INTO engfbv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","They complained to Moses, “Were there no graves in Egypt that you had to bring us out here in the desert to die? What have you done to us by making us leave Egypt? ");
INSERT INTO engfbv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Didn't we tell you back in Egypt, ‘Leave us alone so that we can go on being slaves to the Egyptians’? It would have been better for us to be Egyptian slaves than to die here in the desert!” ");
INSERT INTO engfbv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","But Moses said to the people, “Do not be afraid. Stand where you are and you will see how the Lord will save you today. The Egyptians you see right now, you will never see again! ");
INSERT INTO engfbv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","The Lord is going to fight for you—you don't need to do anything.” ");
INSERT INTO engfbv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","The Lord told Moses, “Why are you crying out to me for help? Tell the Israelites to move forward. ");
INSERT INTO engfbv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","You are to pick up your walking stick and hold it out in your hand over the sea. Divide it so the Israelites can walk through the sea on dry ground. ");
INSERT INTO engfbv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","I will give the Egyptians a stubborn, hard-hearted attitude so that they will chase in after them. Then I will gain respect through what happens to Pharaoh and all his army, chariots, and horsemen. ");
INSERT INTO engfbv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","The Egyptians will know that I am the Lord when I gain respect through Pharaoh, his chariots, and his horsemen.” ");
INSERT INTO engfbv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","The angel of God, who had been leading the Israelites, moved behind them. The pillar of cloud also moved from in front of them and stood behind them, ");
INSERT INTO engfbv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","so that it was positioned between the Egyptian and Israelite camps. The cloud was in darkness on one side, but it lit up the night on the other. No one from either camp went near the other during the night. ");
INSERT INTO engfbv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Then Moses held out his hand over the sea, and all through the night the Lord forced the sea back with a strong east wind, and turned the bottom of the sea into dry land. So the water was divided, ");
INSERT INTO engfbv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","and the Israelites walked through the sea on dry ground, with walls of water to their right and left. ");
INSERT INTO engfbv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","The Egyptians chased after them—all Pharaoh's horses, chariots, and horsemen. They followed the Israelites into the sea. ");
INSERT INTO engfbv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","But at the end of the night the Lord looked down on the Egyptian army from the pillar of fire and cloud, and he threw them into a panic. ");
INSERT INTO engfbv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","He made their chariot wheels get stuck so it was hard for them to drive. The Egyptians shouted out, “Retreat! We must run from the Israelites because the Lord is fighting for them against us!” ");
INSERT INTO engfbv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Then the Lord told Moses, “Hold out your hand over the sea, so that the water will pour back over the Egyptians and their chariots and horsemen.” ");
INSERT INTO engfbv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So Moses held out his hand over the sea, and at dawn the sea returned to normal. As the Egyptians retreated, the Lord swept them into the sea. ");
INSERT INTO engfbv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The water poured back and covered the chariots and horsemen—the whole of Pharaoh's army that had chased after the Israelites into the sea. Not a single one of them survived. ");
INSERT INTO engfbv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the Israelites had walked through the sea on dry ground, with walls of water to their right and left. ");
INSERT INTO engfbv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","The Lord saved the Israelites from the threat of the Egyptians—the Israelites saw the Egyptians lying dead on the shore. ");
INSERT INTO engfbv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","When the Israelites saw the great power that the Lord had used against the Egyptians, they were in awe of the Lord, and they trusted in him and in his servant Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the Israelites sang this song to the Lord: I will sing to the Lord, for he is supreme! He has thrown the horses and their riders into the sea. ");
INSERT INTO engfbv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The Lord gives me strength. He is the theme of my song. He saves me. He is my God, and I will praise him. He is my father's God, and I will honor him. ");
INSERT INTO engfbv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The Lord is like a warrior. His name is the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","He threw Pharaoh's chariots and his army into the sea. Pharaoh's best officers were drowned in the Red Sea. ");
INSERT INTO engfbv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The flooding water covered them. They dropped down into the depths like a stone. ");
INSERT INTO engfbv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Your power, Lord, is truly amazing! Your power, Lord, crushed the enemy. ");
INSERT INTO engfbv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","By your majestic power you destroyed those who opposed you. Your anger blazed out and burned them up like stubble. ");
INSERT INTO engfbv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","You blew and the sea piled up. The waves stood straight like a wall. The depths of the ocean turned solid. ");
INSERT INTO engfbv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","The enemy bragged, “I will chase them and catch up with them. I will divide the plunder. I will eat them alive. I will swing my sword. By my hand I will destroy them.” ");
INSERT INTO engfbv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But you blew with your breath and the sea swept over them. They sank down like lead in the swirling waters. ");
INSERT INTO engfbv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Who is like you among the gods, Lord? Who is like you, glorious in holiness, awesome in wonder, doing miracles? ");
INSERT INTO engfbv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You acted, and the earth swallowed the Egyptians. ");
INSERT INTO engfbv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","You led the people you saved with your trustworthy love. You will guide them in your strength to your holy home. ");
INSERT INTO engfbv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","The nations will hear what has happened and will shake with fear. The people who live in Philistia will experience agonizing distress. ");
INSERT INTO engfbv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","The Edomite chiefs will be terrified. The Moabite leaders will tremble. The people living in Canaan will melt away in panic. ");
INSERT INTO engfbv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Terror and fright will fall on them. Lord, because of your great power, they will be as still as stone until your people pass by, until the people you bought pass by. ");
INSERT INTO engfbv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will take your people and plant them on the mountain that you own, the place that you, Lord, have prepared as your home, the sanctuary that your hands have built, Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","The Lord will reign forever and ever! ");
INSERT INTO engfbv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","When Pharaoh's horses, chariots, and horsemen went into the sea, the Lord brought the water rushing back over them. But the Israelites walked through the sea on dry ground. ");
INSERT INTO engfbv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miriam the prophet, Aaron's sister, picked up a tambourine, and all the women followed her dancing and playing tambourines. ");
INSERT INTO engfbv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam sang to them: “Sing to the Lord, for he is supreme! He has thrown the horses and their riders into the sea.” ");
INSERT INTO engfbv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Then Moses led Israel away from the Red Sea and into the Desert of Shur. For three days they walked in the desert but couldn't find any water. ");
INSERT INTO engfbv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","When they arrived at Marah, the water there was too bitter to drink. (That's why the place is called Marah.) ");
INSERT INTO engfbv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","So the people complained to Moses, asking, “What are we going to drink?” ");
INSERT INTO engfbv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses called out to the Lord for help, and the Lord showed him a piece of wood. When he threw it into the water, it became sweet. There the Lord gave them rules and instructions and also tested their loyalty to him. ");
INSERT INTO engfbv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","He told them, “If you pay attention to what the Lord your God says, do what is right in his sight, obey his commands, and keep all his regulations, then I will not make you suffer from any of the diseases I gave the Egyptians because I am the Lord who heals you.” ");
INSERT INTO engfbv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Then they traveled on to Elim, which had twelve springs of water and seventy palm trees. They set up camp there beside the water. ");
INSERT INTO engfbv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","The whole Israelite community left Elim and went to the Desert of Sin, between Elim and Sinai. This was on the fifteenth day of the second month after they had left the land of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","There in the desert they complained to Moses and Aaron. ");
INSERT INTO engfbv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“The Lord should've killed us back in Egypt!” the Israelites told them. “At least there we could sit down beside stewpots of meat and eat bread until we were full. But you had to bring all of us out here in the desert to starve us all to death!” ");
INSERT INTO engfbv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","The Lord told Moses, “Just watch! I'm going to rain down bread from heaven for you! Each day the people are to go out and collect enough for that day. I'm going to test them by this to find out whether they'll follow my instructions or not. ");
INSERT INTO engfbv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","On the sixth day they are to collect twice as much as usual and prepare it.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","So Moses and Aaron explained to all the Israelites, “This evening you will have the proof that it was the Lord who led you out of Egypt, ");
INSERT INTO engfbv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","and in the morning you will see the glory of the Lord displayed as he responds to the complaints he's heard you making against him. For why should you be complaining to us? We're nobodies!” ");
INSERT INTO engfbv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Then Moses continued, “The Lord is going to give you meat to eat this evening and as much bread as you want in the morning, for he has heard your complaints against him. Why are you complaining to us nobodies? Your complaints aren't directed against us, but against the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Then Moses said to Aaron, “Tell the whole Israelite community, ‘Present yourselves before the Lord, because he has heard your complaints.’” ");
INSERT INTO engfbv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","While Aaron was still speaking to all the Israelites, they looked toward the desert and saw the glory of the Lord appear in a cloud. ");
INSERT INTO engfbv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the complaints of the Israelites. Tell them, ‘In the evening you will eat meat, and in the morning you will have as much bread as you want. Then you will know that I am the Lord your God.’” ");
INSERT INTO engfbv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","That evening quail flew in and landed, filling the camp. In the morning dew covered the ground all around the camp. ");
INSERT INTO engfbv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Once the dew had gone, there was something thin and flaky on the desert, looking like frost crystals on the ground. ");
INSERT INTO engfbv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the Israelites saw it, they asked each another, “What is it?” because they had no idea what it was. So Moses explained to them, “It's the bread the Lord has provided for you to eat. ");
INSERT INTO engfbv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","This is what the Lord has ordered you to do: ‘All of you shall collect as much as is needed. Take an omer for each person in your tent.’” ");
INSERT INTO engfbv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","So the Israelites did as they were told. Some collected more, while others collected less. ");
INSERT INTO engfbv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","But when they measured it out in omers, those who had collected a lot didn't have any left over, while those who had only collected a little still had enough. Each person collected as much as they needed to eat. ");
INSERT INTO engfbv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Then Moses said to them, “No one is to leave any of it until the morning.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But some didn't listen to Moses. They did leave some of it until the morning, and it was full of maggots and smelled bad. Moses became angry with them. ");
INSERT INTO engfbv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","So each morning everyone collected as much as they needed, and when the sun became hot, it melted away to nothing. ");
INSERT INTO engfbv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","However, on the sixth day, they collected twice as much of this food, two omers for each person. All the Israelite leaders came and told Moses what they had done. ");
INSERT INTO engfbv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses replied, “These are the Lord's instructions: ‘Tomorrow is a special day of rest, a holy Sabbath to honor the Lord. So bake what you want, and boil what you want. Then put to one side what's left and keep it until morning.’” ");
INSERT INTO engfbv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So they kept it until morning as Moses had ordered, and it didn't smell bad or have any maggots. ");
INSERT INTO engfbv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moses told them, “Eat it today, because today is a Sabbath to honor the Lord. Today you won't find anything out there. ");
INSERT INTO engfbv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","You can go out collecting for six days, but on the seventh day, the Sabbath, it won't be there.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","However, on the seventh day some people still went out collecting, but they did not find anything. ");
INSERT INTO engfbv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","The Lord told Moses, “How long are you going to refuse to obey my commands and instructions? ");
INSERT INTO engfbv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","You need to understand that the Lord has given you the Sabbath, so on the sixth day he will provide you with food for two days. On the seventh day, everyone has to stay where they are—no one needs to go out.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people did no work on the seventh day. ");
INSERT INTO engfbv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The Israelites called the food manna. It was white like coriander seed and tasted like wafers with honey. ");
INSERT INTO engfbv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses said, “This is what the Lord has ordered: ‘Keep an omer of manna as a reminder for future generations, so that they can see the food I used to feed you in the desert when I led you out of Egypt.’” ");
INSERT INTO engfbv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","So Moses told Aaron, “Take a jar and put an omer of manna in it. Then place it before the Lord to be kept as a reminder for future generations.” ");
INSERT INTO engfbv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron did so and placed the jar in front of the Testimony, to be preserved just as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The Israelites ate manna forty years, until they came to the land where they would settle down—they ate manna until they arrived at the border of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(An omer is a tenth of an ephah.) ");
INSERT INTO engfbv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Then all the Israelites left the Desert of Sin, going from place to place as they followed the Lord's commands. They camped at Rephidim, but there wasn't any water for the people to drink. ");
INSERT INTO engfbv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Some of them came and complained to Moses, saying, “Give us water to drink!” “Why are you complaining to me?” Moses asked. “Why are you trying to challenge the Lord?” ");
INSERT INTO engfbv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people were so thirsty for water there that they went on complaining to Moses, saying, “Why did you have to bring us out of Egypt? Are you trying to kill us and our children and livestock by thirst?” ");
INSERT INTO engfbv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses cried out to the Lord, “What am I going to do with these people? A bit more of this and they're going to stone me!” ");
INSERT INTO engfbv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","The Lord told Moses, “Go ahead of the people, and take some of the elders of Israel with you. Take with you the walking stick you used to hit the Nile, and just go on ahead. ");
INSERT INTO engfbv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Look, I will stand there beside you by the rock at Horeb. When you hit the rock water will pour out for the people to drink.” So Moses did this as the elders of Israel watched. ");
INSERT INTO engfbv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","He called the place Massah and Meribah because the Israelites argued there, and because they challenged the Lord, saying, “Is the Lord with us, or not?” ");
INSERT INTO engfbv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Then some Amalekites came and attacked the Israelites at Rephidim. ");
INSERT INTO engfbv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses told Joshua, “Choose some men and go out and fight the Amalekites. Tomorrow I'll stand on the top of this hill holding the walking stick of God.” ");
INSERT INTO engfbv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua did what Moses told him and fought the Amalekites, while Moses, Aaron, and Hur climbed to the top of the hill. ");
INSERT INTO engfbv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","As long as Moses held up the walking stick in his hands, the Israelites were the ones winning, but when he lowered them, it was the Amalekites. ");
INSERT INTO engfbv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","So when Moses' hands became heavy, the others took a stone and put it under him for him to sit on. Aaron and Hur stood on each side of Moses and held his hands up. In this way his hands were kept firmly up until the sun went down. ");
INSERT INTO engfbv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","As a result Joshua defeated the Amalekite army. ");
INSERT INTO engfbv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","The Lord told Moses, “Write all this down on a scroll as a reminder and read it out loud to Joshua, because I'm going to completely wipe out the Amalekites so nobody on earth will remember them.” ");
INSERT INTO engfbv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moses built an altar and called it “The Lord is my Banner of Victory.” ");
INSERT INTO engfbv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“Hold up the victory banner of the Lord!” Moses declared. “The Lord will go on fighting the Amalekites for all generations!” ");
INSERT INTO engfbv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moses' father-in-law Jethro, the priest of Midian, heard about everything God had done for Moses and his people the Israelites, and how the Lord had led them out of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","When Moses had sent home his wife Zipporah, his father-in-law Jethro had welcomed her, ");
INSERT INTO engfbv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","together with her two sons. One son was named Gershom, for Moses had said, “I have been a foreigner in a foreign land.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","The other son was named Eliezer, because Moses had said, “The God of my father was my helper, and saved me from death at Pharaoh's hand.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moses' father-in-law Jethro, together with Moses' wife and sons, came to see him in the desert at the camp near the mountain of God. ");
INSERT INTO engfbv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Moses was told beforehand, “I, your father-in-law Jethro, am coming to see you together with your wife and her two sons.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses went out to meet his father-in-law and bowed down and kissed him. They asked each other how they were and then went into the tent. ");
INSERT INTO engfbv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses told his father-in-law about everything the Lord had done to Pharaoh and the Egyptians on behalf of the Israelites, about all the troubles they had experienced on the way, and about how the Lord had saved them. ");
INSERT INTO engfbv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro was delighted to hear about all the good things the Lord had done for Israel when he'd saved them from the Egyptians. ");
INSERT INTO engfbv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro announced, “May the Lord be blessed, who saved you from the Egyptians and from Pharaoh. ");
INSERT INTO engfbv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","This is so convincing to me that the Lord is greater than all other gods, for he saved the people from the Egyptians when they acted so arrogantly towards the Israelites.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Then Jethro presented a burnt offering and sacrifices to God, and Aaron came with all the elders of Israel to eat a meal with him in God's presence. ");
INSERT INTO engfbv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","The following day Moses sat as a judge for the people, and they presented their cases to him from morning to evening. ");
INSERT INTO engfbv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","When his father-in-law saw everything that Moses was doing for the people, he asked, “What's all this you're doing for the people? Why are you sitting alone as judge, with everyone presenting their cases to you from morning to evening?” ");
INSERT INTO engfbv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","“Because the people come to me to ask God for his decision,” Moses replied. ");
INSERT INTO engfbv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","“When they argue over something, the case is brought before me to decide between them, and I explain to them God's laws and regulations.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Jethro told him, “What you're doing is not the best. ");
INSERT INTO engfbv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","You, and these people who come to you, are all going to wear yourselves out, because the workload is far too heavy. You can't handle it alone. ");
INSERT INTO engfbv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","So please listen to me. I'm going to give you some advice, and God will be with you. Yes, you must continue to be the people's representative before God, and take their cases to him. ");
INSERT INTO engfbv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Go on teaching them the laws and regulations. Show them how to live and the work they are to do. ");
INSERT INTO engfbv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","But now you should choose men who are competent from among the people, men who respect God and who are trustworthy and not corrupt. Put them in charge of the people as leaders of thousands, hundreds, fifties, and tens. ");
INSERT INTO engfbv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","These men are to judge the people on a continuing basis. Major issues they can bring to you, but they can decide all the small matters themselves. In this way your burden will be made lighter as they share it with you. ");
INSERT INTO engfbv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you follow my advice, and if it's what God tells you to do, then you will be able to survive, and all these people can go home satisfied that their cases have been heard.” ");
INSERT INTO engfbv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moses listened to what his father-in-law said and followed all his advice. ");
INSERT INTO engfbv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","So Moses chose competent men from all of Israel and put them in charge of the people as leaders of thousands, hundreds, fifties, and tens. ");
INSERT INTO engfbv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","They acted as judges for the people on a continuing basis. They brought the difficult cases to Moses, but they would judge the small matters themselves. ");
INSERT INTO engfbv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Then Moses sent Jethro on his way, and he went back to his own country. ");
INSERT INTO engfbv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Two months to the day after they left Egypt, the Israelites arrived at the Sinai desert. ");
INSERT INTO engfbv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","They had set out from Rephidim, and after they entered the Sinai desert they camped there in front of the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses went up the mountain to God. The Lord spoke to Moses from the mountain, and told him, “This is what you are to say to the descendants of Jacob, the Israelites: ");
INSERT INTO engfbv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You saw for yourselves what I did to the Egyptians, and how I carried you on eagles' wings, how I brought you to myself. ");
INSERT INTO engfbv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Now if you really obey what I say and keep the agreement with me, then out of all the nations you will be a special people that belong to me. While the whole world is mine, ");
INSERT INTO engfbv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","for me you will be a kingdom of priests, a holy nation.’ This is what you are to tell the Israelites.” ");
INSERT INTO engfbv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses went back down and summoned the elders of the people, and presented to them everything the Lord had ordered him to say. ");
INSERT INTO engfbv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Everyone answered, “We promise to do everything the Lord says.” Then Moses took the people's answer back to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","The Lord told Moses, “Look! I'm going to come to you in a thick cloud so the people will hear me speaking with you and as a result they will always trust you.” Then Moses reported to the Lord what the people had said. ");
INSERT INTO engfbv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","The Lord told Moses, “Go back down and prepare them spiritually today and tomorrow. They must wash their clothes ");
INSERT INTO engfbv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and be ready on the third day because that is when the Lord will descend upon Mount Sinai in the full view of everyone. ");
INSERT INTO engfbv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Set up a boundary for the people all around and warn them, ‘Watch out! Don't try to go up the mountain—don't even touch it! For anyone who touches the mountain will most certainly be killed. Don't touch any person or any animal that has touched the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Make sure they are stoned or shot with arrows—they must not be allowed to live.’ Only when there is a long blast on the ram's horn can the people come up the mountain.” ");
INSERT INTO engfbv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moses went down the mountain and prepared the people spiritually and they washed their clothes. ");
INSERT INTO engfbv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","He instructed the people, “Get ready for the third day, and don't be intimate with a woman.” ");
INSERT INTO engfbv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","When morning came on the third day there was thunder and lightning, and a thick cloud covered the mountain. There was the very loud sound of a ram's horn, and everyone in the camp shook with fear. ");
INSERT INTO engfbv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses led the people out from the camp to meet God. They stood at the foot of the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Smoke poured out over the whole of Mount Sinai because the Lord's presence had come down like fire. The smoke rose up like smoke from a furnace, and the whole mountain shook furiously. ");
INSERT INTO engfbv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","As the sound of the ram's horn grew louder and louder, Moses spoke, and God answered him in a loud, thunderous voice. ");
INSERT INTO engfbv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","The Lord descended on the top of Mount Sinai, and he called Moses to come up there. So Moses went up, ");
INSERT INTO engfbv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","and the Lord told him, “Go back down, and warn the people not to force their way across the boundary to try to come to the Lord or they will die. ");
INSERT INTO engfbv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Even the priests, who come before the Lord, must prepare themselves spiritually, so that the Lord does not punish them.” ");
INSERT INTO engfbv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","But Moses said to the Lord, “The people cannot come up Mount Sinai. You yourself warned us, ‘Set up a boundary around the mountain, and treat it as holy.’” ");
INSERT INTO engfbv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","The Lord told him, “Go down and bring Aaron back up with you. But the priests and the people must not force their way to come up to the Lord, or he will punish them.” ");
INSERT INTO engfbv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down and explained to the people what the Lord had said. ");
INSERT INTO engfbv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God spoke all the following words: ");
INSERT INTO engfbv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am the Lord your God, who led you out of Egypt, out of the land of your slavery. ");
INSERT INTO engfbv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","You must not have any other gods except me. ");
INSERT INTO engfbv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","You must not make for yourself any kind of idol, whether in the form of anything in the heavens above, or on the earth beneath, or in the waters below. ");
INSERT INTO engfbv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","You must not bow down before them or worship them; for I am the Lord your God and I am passionately exclusive. I lay the consequences of the sin of those who hate me on their sons, grandsons, and great-grandsons; ");
INSERT INTO engfbv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","but I show trustworthy love to the thousands of generations who love me and keep my commandments. ");
INSERT INTO engfbv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","You must not use the name of the Lord your God in a wrong way, for the Lord will not forgive anyone who uses his name in a wrong way. ");
INSERT INTO engfbv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Remember the Sabbath day to keep it holy. ");
INSERT INTO engfbv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","You have six days to work and earn your living, ");
INSERT INTO engfbv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","but the seventh day is the Sabbath to honor the Lord your God. On this day you must not do any work—not you, not your son or daughter, not your male slave or female slave or livestock, and not the foreigner who is staying with you. ");
INSERT INTO engfbv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","For the Lord made the heavens and the earth, the sea, and everything in them in six days, and then rested on the seventh day. That's why the Lord blessed the Sabbath day and made it holy. ");
INSERT INTO engfbv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honor your father and mother, so that you may live a long time in the land that the Lord your God is giving you. ");
INSERT INTO engfbv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","You must not murder. ");
INSERT INTO engfbv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","You must not commit adultery. ");
INSERT INTO engfbv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","You must not steal. ");
INSERT INTO engfbv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","You must not give false evidence against others. ");
INSERT INTO engfbv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","You must not desire to have anyone else's house. You must not desire to have their wife, or their male slave or female slave, or their ox or donkey, or anything else that belongs to them.” ");
INSERT INTO engfbv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","When all the people heard the thunder and the sound of the trumpet, and saw the lightning and the smoke from the mountain, they trembled with fear and stood a long way off. ");
INSERT INTO engfbv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","“You speak to us, and we'll listen,” they said to Moses. “But don't let God speak to us, or we'll die.” ");
INSERT INTO engfbv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moses told them, “Do not be afraid, for God has only come to test you. He wants you to be in awe of him so that you don't sin.” ");
INSERT INTO engfbv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","The people stood a long way off as Moses went over to the thick, dark cloud where God was. ");
INSERT INTO engfbv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","The Lord told Moses, “This is what you are to say to the Israelites: ‘You saw for yourselves that I spoke with you from heaven. ");
INSERT INTO engfbv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","You must not make any idols of silver or gold to worship in addition to me. ");
INSERT INTO engfbv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Make me an altar of earth, and sacrifice on it your burnt offerings and peace offerings, your sheep, goats, and cattle. Wherever I decide to be worshiped, I will come to you and bless you. ");
INSERT INTO engfbv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Now if you make an altar out of stones for me, you must not build it with cut stones, because if you use a chisel to cut the stone, you make it unholy. ");
INSERT INTO engfbv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Also, you must not go up to my altar using steps, so your private parts are not seen.’” ");
INSERT INTO engfbv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“These are the regulations you are to present to them: ");
INSERT INTO engfbv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","If you buy a Hebrew slave, he is to work for you for six years. But in the seventh year, he is to be freed without having to pay anything. ");
INSERT INTO engfbv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he was single when he came, he is to leave single. If he had a wife when he came, she is to leave with him. ");
INSERT INTO engfbv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If his master provides him a wife and she has children with him, the woman and her children shall belong to her master, and only the man shall be freed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","However, if the slave formally states, ‘I love my master and my wife and children; I do not want to be freed,’ ");
INSERT INTO engfbv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","then his master is to take him before the judges. Then he shall have him stand against the door or doorpost and use a metal tool to make a hole in his ear. Then he shall work for his master for life. ");
INSERT INTO engfbv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","If a man sells his daughter as a slave, she is not to be freed in the same way as male slaves. ");
INSERT INTO engfbv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If the man who chose her for himself is not pleased with her, he must let her be bought back. He is not permitted to sell her to foreigners, since he has been unfair to her. ");
INSERT INTO engfbv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If he chooses to give her to his son, he must treat her as a daughter. ");
INSERT INTO engfbv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","If he takes another woman, he must not reduce the food and clothing allowances and marital rights of the first. ");
INSERT INTO engfbv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","If he doesn't give her these three things, she is free to leave without paying anything. ");
INSERT INTO engfbv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Anyone who hits and kills someone else must be executed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","However, if it wasn't intentional and God let it happen, then I will arrange a place for you where they can run to and be safe. ");
INSERT INTO engfbv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But if someone deliberately plans and purposely kills another, you must take them away from my altar and execute them. ");
INSERT INTO engfbv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Anyone who hits their father or mother must be executed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Anyone who kidnaps someone else must be executed, whether the victim is sold or is still in their possession. ");
INSERT INTO engfbv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Anyone who despises their father or mother must be executed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","If men are fighting and one hits the other with a stone or with his fist, and the injured man doesn't die but has to stay in bed, ");
INSERT INTO engfbv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","and then gets up and walks around outside with his walking stick, then the one who hit him won't be punished. Even so, he must still compensate the man for the time lost from his work and make sure that he's completely healed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Anyone who hits their male or female slave with a rod, and the slave dies as a result, must be punished. ");
INSERT INTO engfbv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","However, if after a day or two the slave gets better, the owner won't be punished because the slave is their property. ");
INSERT INTO engfbv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","If men who are fighting happen to hit a pregnant woman so she gives birth prematurely, but no serious injury occurs, he must be fined whatever amount the woman's husband demands and as permitted by the judges. ");
INSERT INTO engfbv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if a serious injury does occur, then you must pay a life for a life, ");
INSERT INTO engfbv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","an eye for an eye, a tooth for a tooth, a hand for a hand, a foot for a foot, ");
INSERT INTO engfbv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","a burn for a burn, a wound for a wound, and a bruise for a bruise. ");
INSERT INTO engfbv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Anyone who hits their male or female slave in the eye and blinds them must free the slave as compensation for the eye. ");
INSERT INTO engfbv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Anyone who knocks out the tooth of their male or female slave must free the slave as compensation for the tooth. ");
INSERT INTO engfbv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","If an ox uses its horns to kill a man or woman, the ox must be stoned to death, and its meat must not be eaten. But the owner of the ox won't be punished. ");
INSERT INTO engfbv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the ox has repeatedly hurt people with its horns, and its owner has been warned but still doesn't keep it under control, and it kills a man or woman, then the ox must be stoned to death and its owner must also be executed. ");
INSERT INTO engfbv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","But if instead the payment of compensation is required, the owner may buy back his or her life by paying the full amount of compensation demanded. ");
INSERT INTO engfbv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","If the ox uses its horns and kills a son or a daughter the same rule is applicable. ");
INSERT INTO engfbv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","If the ox uses its horns and kills a male or female slave, the owner of the ox must pay thirty shekels of silver to the slave's master, and the ox must be stoned to death. ");
INSERT INTO engfbv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","If someone removes the cover of a cistern or digs one and doesn't cover it, and an ox or a donkey falls into it, ");
INSERT INTO engfbv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","the owner of the pit must pay compensation to the animal's owner and keep the dead animal. ");
INSERT INTO engfbv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","If someone's ox injures another's ox and it dies, they must sell the live one and share money received; they must also share the dead animal. ");
INSERT INTO engfbv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if it was known that the ox had repeatedly hurt people with its horns, and its owner had been warned but still didn't keep it under control, full compensation must be paid, ox for ox, but the owner can keep the dead animal.” ");
INSERT INTO engfbv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Anyone who steals an ox or a sheep and kills or sells it must pay back five oxen for one ox and four sheep for one sheep. ");
INSERT INTO engfbv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","If a thief is discovered breaking into someone's house and is beaten to death, no one shall be guilty of murder. ");
INSERT INTO engfbv_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","But if it happens during daylight, then someone is guilty of murder. A thief must pay everything back that's stolen. If he doesn't have anything, then he must be sold to pay for what was stolen. ");
INSERT INTO engfbv_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","If what was stolen is a live animal he still has, whether it's an ox, donkey, or sheep, he must pay back double. ");
INSERT INTO engfbv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","If livestock are grazing in a field or vineyard and their owner lets them stray so that they graze in someone else's field, their owner must pay compensation from the best of their own fields or vineyards. ");
INSERT INTO engfbv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","If a fire is started and it spreads to thorn bushes and then burns stacked or standing grain, or even the whole field, the person who started the fire must pay full compensation. ");
INSERT INTO engfbv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","If someone gives his neighbor money or possessions to be kept safe and they are stolen from the neighbor's house, if the thief is caught they must pay back double. ");
INSERT INTO engfbv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If the thief isn't caught the owner of the house must appear before the judges to find out whether he took his neighbor's property. ");
INSERT INTO engfbv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","If there's an argument over the ownership of an ox, a donkey, a sheep, a garment, or anything that was lost that someone says, ‘This is mine,’ both parties are to bring their case before the judges. The one whom the judges find in the wrong must pay the other back double. ");
INSERT INTO engfbv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","If someone asks a neighbor to look after a donkey, an ox, a sheep, or any other animal, but it dies or is injured or is stolen without anybody noticing, ");
INSERT INTO engfbv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","then an oath must be taken before the Lord to decide if the neighbor has taken the owner's property. The owner must accept the oath and not demand compensation. ");
INSERT INTO engfbv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","However, if the animal really was stolen from the neighbor, he must compensate the owner. ");
INSERT INTO engfbv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If it was killed and torn to pieces by a wild animal, the neighbor shall present the carcass as evidence and does not need to pay compensation. ");
INSERT INTO engfbv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","If someone borrows a neighbor's animal and it's injured or dies while its owner is not present, they must pay compensation in full. ");
INSERT INTO engfbv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","If the owner was present, no compensation is to be paid. If the animal was hired, only the hire charge needs to be paid. ");
INSERT INTO engfbv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","If a man seduces a virgin who is not engaged to be married and sleeps with her, he must pay the full bride-price for her to become his wife. ");
INSERT INTO engfbv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If her father adamantly refuses to give her to him, the man still must pay the same amount as the bride-price for a virgin. ");
INSERT INTO engfbv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","You must not allow a woman who practices witchcraft to live. ");
INSERT INTO engfbv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Anyone who has sex with an animal must be executed. ");
INSERT INTO engfbv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Anyone who sacrifices to any other god than the Lord must be set apart and executed. ");
INSERT INTO engfbv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","You must not exploit or mistreat a foreigner. Remember that you yourselves were once foreigners in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","You must not take advantage of any widow or orphan. ");
INSERT INTO engfbv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you mistreat them, and they call out to me for help, I will definitely respond to their cry. ");
INSERT INTO engfbv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","I will become angry, and I will kill you with the sword. Your wives will become widows and your children will be fatherless. ");
INSERT INTO engfbv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","If you lend money to any of my people because they're poor, you must not behave as a moneylender to them. You must not charge them any interest. ");
INSERT INTO engfbv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","If you require your neighbor's cloak as security for a loan, you must return it to him by sunset, ");
INSERT INTO engfbv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","because it's the only clothing he has for his body. What would he sleep in otherwise? If he calls out to me for help, I will listen, for I am considerate. ");
INSERT INTO engfbv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","You must not despise God or curse your people's leader. ");
INSERT INTO engfbv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","You must not hold on to the required offerings of your produce, olive oil, and wine. You must give me the firstborn of your sons. ");
INSERT INTO engfbv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","You must also give me the firstborn of your cattle, sheep, and goats. They can stay with their mothers for their first seven days, but give them to me on the eighth day. ");
INSERT INTO engfbv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","You are to be holy people to me. You must not eat any animal carcass that you find in the countryside that has been killed by wild animals. Throw it to the dogs to eat.” ");
INSERT INTO engfbv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“You must not spread stories that are lies. You must not help bad people by giving evidence that's malicious. ");
INSERT INTO engfbv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Don't follow the crowd in doing wrong. When you give evidence in a lawsuit, don't corrupt justice by siding with the majority. ");
INSERT INTO engfbv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Don't show favoritism to poor people in their legal cases either. ");
INSERT INTO engfbv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","If you come across your enemy's ox or donkey that has wandered off, take it back to him. ");
INSERT INTO engfbv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","If you see the donkey of someone who hates you that has fallen under its load, don't just leave it there. You must stop and help. ");
INSERT INTO engfbv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","You must not prevent the poor from getting justice in their lawsuits. ");
INSERT INTO engfbv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Don't have anything to do with making false accusations. Don't kill the innocent or those who do right, for I won't let the guilty go unpunished. ");
INSERT INTO engfbv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Don't accept bribes, for a bribe blinds those who can see, and undermines the evidence of the honest. ");
INSERT INTO engfbv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Don't abuse foreigners living among you, since you know very well what it's like to be foreigners, for you were once foreigners in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Six years you are to sow your land and harvest crops, ");
INSERT INTO engfbv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","but in the seventh year you are to let it rest and leave it uncultivated, so that poor people may eat what grows naturally from the field and the wild animals can finish what's left. Follow the same procedure for your vineyards and olive groves. ");
INSERT INTO engfbv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","You have six days to do your work, but on the seventh day you must stop working, so that your ox and your donkey can rest, and your slaves' families can catch their breath, as well as the foreigners living among you. ");
INSERT INTO engfbv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Make sure to pay attention to everything I've told you. Don't think to call on the names of other gods—you must not even mention them. ");
INSERT INTO engfbv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Three times every year you are to celebrate a feast dedicated to me. ");
INSERT INTO engfbv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","You are to observe the Festival of Unleavened Bread as I instructed you. You are to eat bread without yeast for seven days at the appropriate time in the month of Abib, because that was the month you left Egypt. No one can come before me without bringing an offering. ");
INSERT INTO engfbv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","You are also to observe the Festival of Harvest when you present the firstfruits of the produce from what you've sown in the fields. Lastly you are to observe the Festival of Gathering-In the Harvest at the end of the year, when you gather in the harvest of the rest of your crops from the field. ");
INSERT INTO engfbv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Every Israelite male is to come before the Lord God at these three times every year. ");
INSERT INTO engfbv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","You must not offer the blood of my sacrifices together with anything that contains yeast, and the fat from the offerings presented at my festival must not be left until morning. ");
INSERT INTO engfbv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Bring the best firstfruits of your crops to the house of the Lord your God. Don't cook a young goat in its mother's milk. ");
INSERT INTO engfbv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Look, I'm sending an angel ahead of you to protect you on the way and to take you to the place I've prepared for you. ");
INSERT INTO engfbv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Make sure you pay attention to him and do what he says. Don't oppose him, because he won't forgive rebellion, for he carries my authority. ");
INSERT INTO engfbv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","However, if you listen to him carefully, and do everything that I tell you, then I will be an enemy to your enemies and I will fight those who fight against you. ");
INSERT INTO engfbv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","For my angel will go ahead of you and take you into the land of the Amorites, Hittites, Perizzites, Canaanites, Hivites, and Jebusites, and I will wipe them out. ");
INSERT INTO engfbv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","You must not bow down to their gods or worship them or follow their pagan practices. No, you must demolish their idols and smash their sacred pillars into pieces. ");
INSERT INTO engfbv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You are to worship the Lord your God, and he will bless your food and water. I will make sure none of you fall sick. ");
INSERT INTO engfbv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","No woman will have a miscarriage or be without children. I will make sure you live long lives. ");
INSERT INTO engfbv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","I will send terror about me ahead of you which will throw every nation you meet into panic. I will make all your enemies turn and run away. ");
INSERT INTO engfbv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send hornets ahead of you to drive out before you the Hivites and Canaanites and Hittites. ");
INSERT INTO engfbv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","I will not drive them out in just one year, because the land would become desolate and you would have to deal with increased numbers of wild animals. ");
INSERT INTO engfbv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Bit by bit I will drive them out ahead of you, until there are enough of you to take possession of the land. ");
INSERT INTO engfbv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","I will fix your borders from the Red Sea to the Sea of the Philistines, and from the desert to the Euphrates River. I will hand the inhabitants of the land over to you, and you will drive them out. ");
INSERT INTO engfbv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","You must not make any agreement with them or with their gods. ");
INSERT INTO engfbv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","They must not be allowed to stay in your land, otherwise they will lead you to sin against me. For if you worship their gods, they will definitely become a trap for you.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","The Lord told Moses, “Come up to the Lord—you and Aaron, Nadab and Abihu, and seventy of Israel's elders. You are to worship at a distance. ");
INSERT INTO engfbv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Only Moses may approach the Lord—the others must not come near. The people may not go up the mountain with him.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses went and told the people all the Lord's instructions and regulations. They all responded together: “We will do everything the Lord says!” ");
INSERT INTO engfbv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses wrote down everything the Lord had said. He got up early the following morning and built an altar at the bottom of the mountain, and set up twelve pillars for each of the twelve tribes of Israel. ");
INSERT INTO engfbv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Then he sent out some young Israelite men who went and offered burnt offerings and sacrificed young bulls as peace offerings to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses put half of the blood into bowls, and sprinkled the other half on the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Then he picked up the Book of the Agreement and read it to the people. They replied, “We will do everything the Lord says. We will obey.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","So Moses took the blood, sprinkled it on the people, and said, “Look, this is the blood of the agreement that the Lord has made with you following these terms.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses and Aaron, Nadab and Abihu, and seventy of Israel's elders climbed up the mountain, ");
INSERT INTO engfbv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","and they saw the God of Israel. Under his feet was something like a tiled pavement made of lapis lazuli, as clear blue as the sky itself. ");
INSERT INTO engfbv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","But God did not harm the leaders of Israel—they saw him, and they ate and drank a sacred meal. ");
INSERT INTO engfbv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Then the Lord told Moses, “Come up the mountain to me, and stay here, so I can give you the stone tablets, with the instructions and commands I have written for them to learn.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","So Moses left with Joshua his attendant and climbed up the mountain of God. ");
INSERT INTO engfbv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","He told the elders, “Stay here and wait for us to return. Aaron and Hur are with you. If anyone has a problem, they can talk with them.” ");
INSERT INTO engfbv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","As Moses climbed up on the mountain, the cloud covered it. ");
INSERT INTO engfbv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","The Lord's glory came down on Mount Sinai, covering it for six days. On the seventh day the Lord called to Moses from inside the cloud. ");
INSERT INTO engfbv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","To the Israelites the Lord's glory looked like a burning fire on the top of the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moses went into the cloud as he climbed up on the mountain, and he stayed on the mountain for forty days and nights. ");
INSERT INTO engfbv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Instruct the Israelites to bring me an offering. You are to receive my offering from everyone who willingly wants to give. ");
INSERT INTO engfbv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","These are the items you are to accept from them as contributions: gold, silver, and bronze; ");
INSERT INTO engfbv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, and crimson thread; finely-spun linen and goat hair; ");
INSERT INTO engfbv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ram skins that have been tanned, and fine leather; acacia wood; ");
INSERT INTO engfbv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","olive oil for the lamps; spices for the olive oil used in anointing and for the fragrant incense; ");
INSERT INTO engfbv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","and onyx stones and other gemstones to be used in making the ephod and breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","They are to make me a sanctuary so I can live among them. ");
INSERT INTO engfbv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","You must make the Tabernacle and all its furnishings according to the design I'm going to show you. ");
INSERT INTO engfbv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","They are to make an Ark of acacia wood that measures two and a half cubits long by a cubit and a half wide by one and a half cubits high. ");
INSERT INTO engfbv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Cover it with pure gold on the inside and the outside, and make a gold trim to go around it. ");
INSERT INTO engfbv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Cast four gold rings and attach them to its four feet, two on one side and two on the other. ");
INSERT INTO engfbv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Make poles of acacia wood and cover them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Place the poles into the rings on the sides of the Ark, so it can be carried. ");
INSERT INTO engfbv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","The poles are to stay in the rings of the Ark; don't take them out. ");
INSERT INTO engfbv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Place inside the Ark the Testimony which I'm going to give you. ");
INSERT INTO engfbv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","You are to make an atonement cover of pure gold, two and a half cubits long by a cubit and a half wide. ");
INSERT INTO engfbv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Make two cherubim of hammered gold for the ends of the atonement cover, ");
INSERT INTO engfbv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","and put one cherub on each end. All of this is to be made from one piece of gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","The cherubim are to be designed with spread wings pointing upward, covering the atonement cover. The cherubim are to be placed facing each another, looking down towards the atonement cover. ");
INSERT INTO engfbv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Place the atonement cover on top of the Ark, and put the Testimony that I'm going to give you inside the Ark. ");
INSERT INTO engfbv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","I will meet with you there as arranged above the atonement cover, between the two cherubim that stand over the Ark of the Testimony, and I will talk with you about all the commands I will give the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Then you are to make a table of acacia wood two cubits long by a cubit wide by a cubit and a half high. ");
INSERT INTO engfbv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Cover it with pure gold and make a gold trim to go around it. ");
INSERT INTO engfbv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Make a border around it the width of a hand and put a gold trim on the border. ");
INSERT INTO engfbv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Make four gold rings for the table and attach them to the four corners of the table by the legs. ");
INSERT INTO engfbv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","The rings are to be close to the border to hold the poles used to carry the table. ");
INSERT INTO engfbv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Make the poles of acacia wood for carrying the table and cover them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Make plates and dishes for the table, as well as pitchers and bowls for pouring out drink offerings. Make all of them out of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Place the Bread of the Presence on the table so it is always in my presence. ");
INSERT INTO engfbv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Make a lampstand of pure, hammered gold. The whole of it is to be made of one piece—its base, shaft, cups, buds, and flowers. ");
INSERT INTO engfbv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","It is to have six branches coming out of the sides of the lampstand, three on each side. ");
INSERT INTO engfbv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Have three cups shaped like almond flowers on the first branch, each with buds and petals, three on the next branch. Each of six branches that come out will have three cups shaped like almond flowers, all complete with buds and petals. ");
INSERT INTO engfbv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","On the main shaft of the lampstand make four cups shaped like almond flowers, complete with buds and petals. ");
INSERT INTO engfbv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","On the six branches that come out from the lampstand, place a bud under the first pair of branches, a bud under the second pair, and a bud under the third pair. ");
INSERT INTO engfbv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","The buds and branches are to be made with the lampstand as one piece, hammered out of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Make seven lamps and place them on the lampstand so they can light up the area in front of it. ");
INSERT INTO engfbv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","The wick tongs and their trays are to be made of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","The lampstand and all these utensils will require a talent of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Be sure to make everything according to the design you were shown on the mountain.” ");
INSERT INTO engfbv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Make ten curtains for the Tabernacle of finely-spun linen, using blue, purple, and crimson threads. Have them embroidered with cherubim by someone who is skilled. ");
INSERT INTO engfbv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Each curtain is to measure twenty-eight cubits long by four cubits wide, and all the curtains are to be the same size. ");
INSERT INTO engfbv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Join five of the curtains together, and then do the same to the other five. ");
INSERT INTO engfbv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Use blue material to make loops on the edge of the last curtain of both sets. ");
INSERT INTO engfbv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Make fifty loops on one curtain and fifty loops on the last curtain of the second set, lining up the loops with each other. ");
INSERT INTO engfbv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Then make fifty gold clips and join the curtains together with the clips, so that the Tabernacle will be a single structure. ");
INSERT INTO engfbv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Make eleven curtains of goat hair as a tent to cover the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Each of the eleven curtains is to be the same size—thirty cubits long by four cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Join five of the curtains together as one set and the other six as another set. Then fold the sixth curtain in two at the front of the tent. ");
INSERT INTO engfbv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Make fifty loops on the edge of the last curtain in the first set, and fifty loops along the edge of the last curtain in the second set. ");
INSERT INTO engfbv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Make fifty bronze clips and put them in the loops to join the tent together as a single cover. ");
INSERT INTO engfbv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","The extra half-curtain of this tent covering will be left to hang over the back of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","The tent curtains will be a cubit longer on every side, and the extra length will hang over the sides of the Tabernacle so it is all covered. ");
INSERT INTO engfbv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Make a covering for the goat hair tent from tanned ram skins, and place an extra covering of fine leather over that. ");
INSERT INTO engfbv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Make an upright framework of acacia wood for the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Each frame is to be ten cubits long by one and a half cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Each frame will have two pegs so the frames can be connected to each other. Make all the frames of the Tabernacle like this. ");
INSERT INTO engfbv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Make twenty frames for the south side of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Make forty silver stands as supports for the twenty frames using two stands per frame, one under every frame peg. ");
INSERT INTO engfbv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Similarly for the north side of the Tabernacle, make twenty frames ");
INSERT INTO engfbv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","and forty silver stands, two stands per frame. ");
INSERT INTO engfbv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Make six frames for the back (west side) of the Tabernacle, ");
INSERT INTO engfbv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","along with two frames for its two back corners. ");
INSERT INTO engfbv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Join these corner frames at the bottom and at the top near to the first ring. This is how you are to make the two corner frames. ");
INSERT INTO engfbv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","In total there will be eight frames and sixteen silver stands, two under each frame. ");
INSERT INTO engfbv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Make five crossbars of acacia wood to hold together the frames on the south side of the Tabernacle, ");
INSERT INTO engfbv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","five for those on the north, and five for those at the back of the Tabernacle, to the west. ");
INSERT INTO engfbv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The central crossbar which is placed halfway up the frames will run from one end to the other. ");
INSERT INTO engfbv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Cover the frames with gold, and make gold rings to hold the crossbars in place. Cover the crossbars with gold too. ");
INSERT INTO engfbv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Assemble the Tabernacle following the design you were shown on the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Make a veil out of blue, purple, and crimson thread, and finely-spun linen, embroidered with cherubim by someone who is skilled. ");
INSERT INTO engfbv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Using gold hooks hang it from four posts of acacia wood covered with gold, held up by four silver stands. ");
INSERT INTO engfbv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Place the veil under the clips and take the Ark of the Testimony inside behind the veil. The veil will separate the Holy Place from the Most Holy Place. ");
INSERT INTO engfbv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Put the atonement cover on the Ark of the Testimony in the Most Holy Place. ");
INSERT INTO engfbv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Place the table outside the veil on the north side of the Tabernacle and put the lampstand opposite it on the south side. ");
INSERT INTO engfbv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Make a screen for the entrance to the tent using blue, purple, and crimson thread, and finely-spun linen. Have it embroidered. ");
INSERT INTO engfbv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Make five posts of acacia wood with gold hooks to hang the screen, and cast five bronze stands to hold them. ");
INSERT INTO engfbv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Make an altar of acacia wood. It is to be square and measure five cubits long by five cubits wide by three cubits high. ");
INSERT INTO engfbv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Make horns for each of its corners, all one piece with the altar, and cover the whole altar with bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Make all its utensils of bronze: buckets for removing ashes, shovels, sprinkling bowls, meat forks, and firepans. ");
INSERT INTO engfbv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Make a bronze mesh grate for it with a bronze ring on each of its corners. ");
INSERT INTO engfbv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Put the grate under the ledge of the altar, so that the mesh comes halfway down the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Make poles of acacia wood for the altar and cover them with bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","The poles are to be placed in the rings so that the poles are on either side of the altar when it is carried. ");
INSERT INTO engfbv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Make the altar hollow, using boards, just as you were shown on the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Make a courtyard for the Tabernacle. For the south side of the courtyard make curtains of finely-spun linen, a hundred cubits long on one side, ");
INSERT INTO engfbv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","with twenty posts and twenty bronze stands, with silver hooks and bands on the posts. ");
INSERT INTO engfbv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Similarly there are to be curtains placed on the north side in an identical arrangement. ");
INSERT INTO engfbv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","The curtains for the west side of the courtyard are to be fifty cubits wide, with ten posts and ten stands. ");
INSERT INTO engfbv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The east side of the courtyard that faces the sunrise is to be fifty cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Make the curtains on one side fifteen cubits long, with three posts and three stands, ");
INSERT INTO engfbv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","and the curtains on the other side just the same. ");
INSERT INTO engfbv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","The entrance to the courtyard is to be twenty cubits wide, with a curtain embroidered with blue, purple, and crimson thread, and finely-spun linen, held up by four posts and four stands. ");
INSERT INTO engfbv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the posts around the courtyard are to have silver bands, silver hooks, and bronze stands. ");
INSERT INTO engfbv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The whole courtyard is to be a hundred cubits long and fifty cubits wide, with curtains made of finely-spun linen five cubits high, and with bronze stands. ");
INSERT INTO engfbv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the rest of the equipment used in the Tabernacle, including its tent pegs and those for the courtyard, are to be made of bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","You are to order the Israelites to bring you pure, hand-pressed olive oil for the lamps so they can go on burning, giving light. ");
INSERT INTO engfbv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","In the Tent of Meeting, outside the veil in front of the Testimony, Aaron and his sons are to keep the lamps burning in the Lord's presence from evening until morning. This requirement is to be observed by the Israelites for all generations. ");
INSERT INTO engfbv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Have your brother Aaron come to you, along with his sons Nadab, Abihu, Eleazar, and Ithamar. They of all the Israelites are to serve me as priests. ");
INSERT INTO engfbv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","You are to have holy clothing made for your brother Aaron to make him look splendid and dignified. ");
INSERT INTO engfbv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","You are to give instructions to all the skilful workers, to those who have received from me their abilities, as to how to make clothing for Aaron's dedication, so that he can serve me as priest. ");
INSERT INTO engfbv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","These are the clothes for them to make: a breastpiece, an ephod, a robe, a pleated tunic, a turban, and a sash. These are the holy clothes they shall make for your brother Aaron and his sons so that they can serve me as priests. ");
INSERT INTO engfbv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","The workers are to use gold thread, together with blue, purple, and crimson thread, and finely-spun linen. ");
INSERT INTO engfbv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","They are to make the ephod of finely-woven linen embroidered with gold, and with blue, purple, and crimson thread, skillfully worked. ");
INSERT INTO engfbv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Two shoulder pieces are to be attached to the front and back pieces. ");
INSERT INTO engfbv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","The waistband of the ephod is to be one piece made in the same way, using gold thread, with blue, purple, and crimson thread, and with finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Engrave on two onyx stones the names of the Israelite tribes, ");
INSERT INTO engfbv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six names on one stone and six on the other, in birth order. ");
INSERT INTO engfbv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Engrave the names on the two stones the same way a jeweler engraves a personal seal. Then place the stones in ornamental gold settings. ");
INSERT INTO engfbv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Attach both stones to the shoulder pieces of the ephod as reminders for the Israelite tribes. Aaron is to wear their names on his two shoulders to remind the Israelites that he represents them when he goes in to the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Make ornamental gold settings ");
INSERT INTO engfbv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","and two braided chains of pure gold, and fasten these chains to the settings. ");
INSERT INTO engfbv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","You are also to make a breastpiece for decisions in the same skilful way as the ephod, to be used in determining the Lord's will. Make it using gold thread, with blue, purple, and crimson thread, and with finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","It has to be square when folded, measuring around nine inches in length and width. ");
INSERT INTO engfbv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Attach an arrangement of precious stones in four rows as follows. In the first row carnelian, peridot, and emerald. ");
INSERT INTO engfbv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","In the second row turquoise, lapis lazuli, and sardonyx. ");
INSERT INTO engfbv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","In the third row jacinth, agate, and amethyst. ");
INSERT INTO engfbv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","In the fourth row topaz, beryl, and jasper. Place these stones in ornamental gold settings. ");
INSERT INTO engfbv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Each of the twelve stones will be engraved like a personal seal with the name of one of the twelve Israelite tribes and will represent them. ");
INSERT INTO engfbv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Make cords of braided chains from pure gold to attach the breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Make two gold rings and fasten them to the two top corners of the breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Attach the two gold chains to the two gold rings on the corners of the breastpiece, ");
INSERT INTO engfbv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","and then fasten the opposite ends of the two chains to the ornamental gold settings on the shoulder pieces of the front side of the ephod. ");
INSERT INTO engfbv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Make two more gold rings and attach them to the two lower corners of the breastpiece, on the inside edge next to the ephod. ");
INSERT INTO engfbv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Make two more gold rings and attach them to the bottom of the two shoulder pieces of the front side of the ephod, near where it joins its woven waistband. ");
INSERT INTO engfbv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tie the rings of the breastpiece to the rings of the ephod with a cord of blue thread, so that the breastpiece won't come loose from the ephod. ");
INSERT INTO engfbv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Like this, whenever Aaron enters the Holy Place, he will wear the names of the Israelite tribes over his heart on the breastpiece, as a constant reminder before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Place the Urim and Thummim in the breastpiece of decision, so that they too will be over Aaron's heart whenever he comes into the Lord's presence. Aaron will continually carry the means of gaining decisions over his heart before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Make the robe that goes with the ephod exclusively from blue cloth, ");
INSERT INTO engfbv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","with an opening in the middle at the top. Stitch a woven collar around the opening to strengthen it so it won't tear. ");
INSERT INTO engfbv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Make pomegranates using blue, purple, and crimson thread and attach them all the way around its hem, with gold bells between them, ");
INSERT INTO engfbv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","having the gold bells and the pomegranates alternate. ");
INSERT INTO engfbv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron is to wear the robe whenever he serves, and the sound it makes will be heard when he enters or leaves the sanctuary as he goes into the Lord's presence, so that he won't die. ");
INSERT INTO engfbv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Make a plate of pure gold and engrave on it like a seal, “Holy to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Attach it to the front of the turban using a blue cord. ");
INSERT INTO engfbv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron will wear it on his forehead, so that he may take responsibility for the guilt of the offerings the Israelites make, and this applies to all their holy gifts. It must always remain on his forehead in order that the people are accepted in the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Weave the tunic with finely-spun linen and make the turban of the same material, and also make a sash and have it embroidered. ");
INSERT INTO engfbv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Make tunics, sashes, and headdresses for Aaron's sons, so that they will look splendid and dignified. ");
INSERT INTO engfbv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Put these clothes on your brother Aaron and his sons and then anoint them and ordain them. Dedicate them so that they can serve me as priests. ");
INSERT INTO engfbv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Make linen undershorts to cover their bare bodies, reaching from waist to thigh. ");
INSERT INTO engfbv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons are to wear them when they enter the Tent of Meeting or when they approach the altar to serve in the Holy Place, so that they will not bring guilt on themselves and die. This is a law for Aaron and his descendants forever. ");
INSERT INTO engfbv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Now this is how you are to proceed to dedicate them to serve me as priests. Take a young bull and two rams with no defects. ");
INSERT INTO engfbv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Then using the best wheat flour, make the following without yeast: bread, cakes mixed with olive oil, and wafers sprinkled with olive oil. ");
INSERT INTO engfbv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Put them all in a basket, and bring them as an offering, along with the bull and the two rams. ");
INSERT INTO engfbv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Then bring Aaron and his sons to the entrance of the Tent of Meeting, and wash them with water. ");
INSERT INTO engfbv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Take the clothes and put them on Aaron: the tunic, the robe of the ephod, the ephod itself, and the breastpiece. Tie the ephod on him with its waistband. ");
INSERT INTO engfbv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Wrap the turban on his head and attach the holy crown to the turban. ");
INSERT INTO engfbv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Then use the anointing oil to anoint him by pouring it over his head. ");
INSERT INTO engfbv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Then have his sons come and put the tunics on them. ");
INSERT INTO engfbv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tie the sashes around Aaron and his sons and put headdresses on them. The priesthood belongs to them forever. This is how you are to ordain Aaron and his sons. ");
INSERT INTO engfbv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Take the bull to the front of the Tent of Meeting, and Aaron and his sons are to place their hands on its head. ");
INSERT INTO engfbv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Then slaughter the bull in the Lord's presence at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Take some of the bull's blood and smear it on the horns of the altar with your finger. Then pour out the rest of the blood at the base of the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Take all the fat that covers the intestines, the best parts of the liver, and the two kidneys with their fat, and burn them on the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","But burn the bull's meat, its hide, and its excrement outside the camp—it is an offering for sin. ");
INSERT INTO engfbv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Next have Aaron and his sons place their hands on the head of one of the rams. ");
INSERT INTO engfbv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Slaughter the ram, take its blood, and splash it all around the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Cut the ram in pieces, wash the intestines and legs, and put them with the other pieces and the head. ");
INSERT INTO engfbv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Then burn all of the ram on the altar. It is a burnt offering to the Lord to be accepted by him. ");
INSERT INTO engfbv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Then have Aaron and his sons place their hands on the head of the other ram. ");
INSERT INTO engfbv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Slaughter the ram, and put some of its blood on the right earlobes of Aaron and his sons, and on the thumbs of their right hands, and on the big toes of their right feet. Splash the rest of its blood all around the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Take some of the blood from the altar and some of the anointing oil and sprinkle it on Aaron and his clothes, and on his sons and their clothes. Then he and his clothes will be made holy, likewise his sons and their clothes. ");
INSERT INTO engfbv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Take the fat from the ram, including the fat of its broad tail, the fat covering the intestines, the best parts of the liver, the two kidneys with their fat, as well as the right thigh (because this is a ram for ordination). ");
INSERT INTO engfbv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Also take one loaf of bread, one cake of bread made with olive oil, and one wafer from the basket of bread made without yeast that is in the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Give all of them to Aaron and his sons to wave before the Lord as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then take the different breads back and burn them on the altar on top of the burnt offering to the Lord to be accepted by him. ");
INSERT INTO engfbv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Take the breast of the ram of Aaron's ordination and wave it before the Lord as a wave offering. This is the part you can keep. ");
INSERT INTO engfbv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Set apart for Aaron and his sons the breast of the wave offering and the thigh of the offering that is lifted up, both taken from the ram of ordination. ");
INSERT INTO engfbv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","From now on whenever the Israelites lift up peace offerings to the Lord, these parts will belong to Aaron and his sons forever as a regular share from the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","The holy garments that Aaron has will be passed down to his descendants, so they can wear them when they're anointed and ordained. ");
INSERT INTO engfbv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","The descendant who succeeds him as priest and enters the Tent of Meeting to serve in the Holy Place must wear them for the seven days of his ordination. ");
INSERT INTO engfbv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Take the ram of ordination and boil its meat in a holy place. ");
INSERT INTO engfbv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron and his sons are to eat the ram's meat, and the bread that is in the basket, at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","They are to eat the meat and the bread that were part of the offerings that symbolized the forgiveness required for their ordination and dedication. No one else may eat them, because they are holy. ");
INSERT INTO engfbv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If any of the meat of ordination or any bread remains until the morning, burn what's left. It must not be eaten, because it's holy. ");
INSERT INTO engfbv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","This is the process you are to follow for Aaron and his sons, observing all the instructions I have given you. It will take seven days to ordain them. ");
INSERT INTO engfbv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Every day you are to sacrifice a bull as a sin offering for forgiveness. When you do this the altar needs to be purified. Anoint it to make it holy. ");
INSERT INTO engfbv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","For seven days you shall purify the altar and consecrate it. Then the altar will become completely holy, and everything that touches the altar will become holy. ");
INSERT INTO engfbv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","You are to offer two lambs that are a year old on the altar, daily and continually. ");
INSERT INTO engfbv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","In the morning offer one lamb, and offer the other one in the evening before it gets dark. ");
INSERT INTO engfbv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","With the first lamb also offer a tenth of an ephah of best quality flour, mixed with a quarter of a hin of olive oil, and a drink offering of a quarter of a hin of wine. ");
INSERT INTO engfbv_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Then offer the second lamb in the evening, with the same grain and drink offerings as in the morning, a burnt offering to the Lord and accepted by him. ");
INSERT INTO engfbv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","These burnt offerings will be made continually for all generations at the entrance to the Tent of Meeting in the Lord's presence. I will meet you there to speak with you. ");
INSERT INTO engfbv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I will meet with the Israelites there, and that place will be made holy by my glory. ");
INSERT INTO engfbv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","In this way I will dedicate the Tent of Meeting and the altar, and I will dedicate Aaron and his sons to serve me as priests. ");
INSERT INTO engfbv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Then I will live with the Israelites and be their God. ");
INSERT INTO engfbv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","They will know that I am the Lord their God, who led them out of Egypt, so that I could live with them. I am the Lord their God. ");
INSERT INTO engfbv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Make from acacia wood an altar for burning incense. ");
INSERT INTO engfbv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","It shall be square, measuring a cubit by a cubit, by two cubits high, with horns on its corners that are all one piece with the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cover its top, its side, and its horns with pure gold, and make a gold trim to go all around it. ");
INSERT INTO engfbv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","On two of the altar's sides make two gold rings and attach them below the trim to hold the poles that carry it. ");
INSERT INTO engfbv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Make the poles of acacia wood and cover them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Put the altar in front of the veil that hangs before the Ark of the Testimony and the atonement cover that is over the Testimony where I will meet with you. ");
INSERT INTO engfbv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron is to burn fragrant incense on the altar every morning when he takes care of the lamps. ");
INSERT INTO engfbv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","When he lights the lamps in the evening he must burn incense again so that incense will always be burned in the Lord's presence for generations to come. ");
INSERT INTO engfbv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Don't offer on this altar any unapproved incense or any burnt offering or grain offering, and do not pour out a drink offering upon it. ");
INSERT INTO engfbv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Once a year Aaron must perform the atonement ritual by placing blood on the horns of the altar from the sin offering for atonement. This yearly atonement ritual must be carried out for generations to come. This is the Lord's holy altar.” ");
INSERT INTO engfbv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“When you take a census of the Israelites, each man must pay the Lord to buy back his life when he's counted. Then they won't suffer from the plague when they're counted. ");
INSERT INTO engfbv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Each one who crosses over to those counted must give a half shekel (using the sanctuary shekel standard, which weighs twenty gerahs). This half shekel is an offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","This offering to the Lord is required from everyone twenty years old and more. ");
INSERT INTO engfbv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","When you give this offering to buy back your lives the rich are not to give more than a half shekel and the poor are not to give less. ");
INSERT INTO engfbv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Take this money paid by the Israelites and use it for the expenses involved in the services of the Tent of Meeting. It will serve as a reminder for the Israelites to buy back your lives in the presence of the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Make a bronze basin with a bronze stand for washing. Place it between the Tent of Meeting and the altar, and put water in it. ");
INSERT INTO engfbv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron and his sons will use it to wash their hands and feet. ");
INSERT INTO engfbv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Whenever they enter the Tent of Meeting, they are to wash with water so that they will not die. When they approach the altar to present burnt offerings to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","they must also wash so that they will not die. This requirement is to be observed by them and their descendants for all generations.” ");
INSERT INTO engfbv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Take the best quality spices: 500 shekels of liquid myrrh, 250 shekels of sweet-smelling cinnamon, 250 shekels of aromatic reed, ");
INSERT INTO engfbv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 shekels of cassia (weights using the sanctuary shekel standard), and a hin of olive oil. ");
INSERT INTO engfbv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mix these together into holy anointing oil, an aromatic blend like the product of an expert perfumer. Use it as holy anointing oil. ");
INSERT INTO engfbv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Use it to anoint the Tent of Meeting, the Ark of the Testimony, ");
INSERT INTO engfbv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","the table and all its equipment, the lampstand and its equipment, the altar of incense, ");
INSERT INTO engfbv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","the altar of burnt offering and all its utensils, and the basin plus its stand. ");
INSERT INTO engfbv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Dedicate them so that they will be especially holy. Whatever touches them will become holy. ");
INSERT INTO engfbv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Anoint Aaron and his sons too and dedicate them to serve as priests for me. ");
INSERT INTO engfbv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tell the Israelites, ‘This is to be my holy anointing oil for all generations to come. ");
INSERT INTO engfbv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Don't use it on ordinary people and don't make anything like it using the same formula. It is holy, and you must treat it as being holy. ");
INSERT INTO engfbv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Anyone who mixes anointing oil like it, or puts it on someone other than a priest, will be expelled from their people.’” ");
INSERT INTO engfbv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","The Lord told Moses, “Take equal amounts of these aromatic spices: balsam resin, onycha, galbanum, and pure frankincense. ");
INSERT INTO engfbv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Add some salt and make pure and holy incense blended like the product of an expert perfumer. ");
INSERT INTO engfbv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Grind some of it into powder and place it in front of the Ark of the Testimony in the Tent of Meeting, where I will meet with you. It shall be especially holy to you. ");
INSERT INTO engfbv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Don't make for yourselves any incense like it using the same formula. You are to consider this incense as holy to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Anyone who makes incense like this for themselves to enjoy will be expelled from their people.” ");
INSERT INTO engfbv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“I have chosen by name Bezalel, son of Uri, son of Hur, from the tribe of Judah. ");
INSERT INTO engfbv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I have filled him with the Spirit of God giving him ability, creativity, and expertise in all kinds of craftsmanship. ");
INSERT INTO engfbv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","He can produce designs in gold, silver, and bronze, ");
INSERT INTO engfbv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","he can cut gemstones to place in settings, and he can carve wood. He is a master of every craft. ");
INSERT INTO engfbv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","I have also chosen Oholiab, son of Ahisamach, from the tribe of Dan, to help him. I have also given all the craftsmen the skills needed to make everything that I have ordered you to make: ");
INSERT INTO engfbv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the Tent of Meeting, the Ark of the Testimony and its atonement cover, and all the other furniture in the Tent, ");
INSERT INTO engfbv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table with its equipment, the pure gold lampstand with all its equipment, the altar of incense, ");
INSERT INTO engfbv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar of burnt offering with all its utensils, and the basin plus its stand; ");
INSERT INTO engfbv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","as well as the woven clothes for both Aaron the priest and for his sons to serve as priests, ");
INSERT INTO engfbv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","as well as anointing oil and fragrant incense for the Holy Place. They are to make them following all the instructions I have given you.” ");
INSERT INTO engfbv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israelites, ‘It's absolutely essential that you keep my Sabbaths. The Sabbath will be a sign between me and you for generations to come, so that you'll know that I am the Lord who makes you holy. ");
INSERT INTO engfbv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","You shall keep the Sabbath because it is holy to you. Anyone who dishonors it must be killed. Anyone who works on that day must be cut off from their people. ");
INSERT INTO engfbv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Six days you can work, but the seventh day is to be a Sabbath of rest, holy to the Lord. Anyone who does any work on the Sabbath day must be killed. ");
INSERT INTO engfbv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","The Israelites must keep the Sabbath, observing the Sabbath as an everlasting agreement for generations to come. ");
INSERT INTO engfbv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","It's a sign between me and the Israelites forever, for the Lord made the heavens and the earth in six days, but on the seventh day he stopped and he rested.’” ");
INSERT INTO engfbv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When the Lord finished speaking with Moses on Mount Sinai, he gave him the two tablets of the Testimony, stone tablets written on by the finger of God. ");
INSERT INTO engfbv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","When the people realized how long Moses was taking before he came back down the mountain, they went together to see Aaron. They told him, “Get up! Make some gods for us who can lead us because this man Moses who brought us out of the land of Egypt—we don't know what's happened to him!” ");
INSERT INTO engfbv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","“Bring to me the gold earrings that your wives, sons, and daughters are wearing,” Aaron replied. ");
INSERT INTO engfbv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","So everyone took off the gold earrings they were wearing and brought them to Aaron. ");
INSERT INTO engfbv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He took what they gave him and using a molding tool cast an idol in the shape of a bull calf. They shouted out, “Israel, these are the gods that brought you out of the land of Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","When Aaron saw this, he built an altar in front of the golden calf and shouted out, “Tomorrow will be a festival to honor the Lord!” ");
INSERT INTO engfbv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Early the next day they sacrificed burnt offerings and presented peace offerings. Then they sat down to celebrate with eating and drinking. Then they got up to dance, and it became like an orgy. ");
INSERT INTO engfbv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Then the Lord told Moses, “Get back down, because your people that you brought out of Egypt are acting immorally. ");
INSERT INTO engfbv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have been so quick to abandon the way I ordered them to follow. They have made a metal bull calf idol for themselves, bowing before it in worship and offering sacrifices to it. They're saying, ‘These are the gods that brought you out of the land of Egypt.’” ");
INSERT INTO engfbv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“I know what these people are like,” the Lord continued saying to Moses. “They are so rebellious! ");
INSERT INTO engfbv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Now leave me! I am angry with them—let me finish them off! I will make you into a great nation.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses pleaded with the Lord his God, saying, “Why are you angry with the people you brought out of the land of Egypt with tremendous power and great strength? ");
INSERT INTO engfbv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Why should the Egyptians be able to say, ‘He brought them out with the evil purpose of killing them in the mountains, wiping them off the face of the earth’? Turn from your fierce anger. Please change your mind over the threat against your people. ");
INSERT INTO engfbv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember you swore a promise your servants Abraham, Isaac, and Jacob, telling them, ‘I will make your descendants as numerous as the stars of heaven, and give you all the land I promised to them, and they shall own it forever.’” ");
INSERT INTO engfbv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","The Lord changed his mind over the disaster he threatened to cause his people. ");
INSERT INTO engfbv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moses turned and went down the mountain, carrying the two stone tablets of the Law written on both sides. ");
INSERT INTO engfbv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God had made the tablets, and God had engraved the writing himself. ");
INSERT INTO engfbv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","When Joshua heard all the shouting from the camp, he said to Moses, “It sounds like fighting in the camp!” ");
INSERT INTO engfbv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","But Moses replied, “These are not the shouts of victory or of defeat. What I'm hearing is people partying!” ");
INSERT INTO engfbv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","As he approached the camp he saw the bull calf idol and the dancing. He got so angry that he threw down the stone tablets and smashed them there at the foot of the mountain. ");
INSERT INTO engfbv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","He took the bull calf and burned it, and ground it into powder. Then he mixed this with water and made the Israelites drink it. ");
INSERT INTO engfbv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Then Moses asked Aaron, “What did these people do to you that you made them sin so badly?” ");
INSERT INTO engfbv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“Please don't get angry with me, my lord,” Aaron replied, “You yourself know how liable these people are to do evil. ");
INSERT INTO engfbv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","They told me, ‘Make some gods for us who can lead us because this man Moses who brought us out of the land of Egypt—we don't know what's happened to him!’ ");
INSERT INTO engfbv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I said to them, ‘Anybody who has gold jewelry, take it off and give it to me.’ I threw the gold into the furnace and out came this bull calf.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses saw the people going completely wild because Aaron had let them, and that this had brought ridicule on them from their enemies. ");
INSERT INTO engfbv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","So he went and stood at the entrance to the camp, and shouted out, “Whoever is on the Lord's side, come and join me!” All the Levites gathered around him. ");
INSERT INTO engfbv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moses told them, “This is what the Lord, the God of Israel says: Each of you strap on a sword. Then go all through the camp from one end to the other and kill your brothers, friends, and neighbors.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The Levites did what Moses had told them, and that day around 3,000 men were killed. ");
INSERT INTO engfbv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses told the Levites, “Today you have dedicated yourselves to the Lord because you took action against your sons and brothers. Today you have gained a blessing for yourselves.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The following day Moses spoke to the people, saying, “You have sinned very badly. But now I will go up to the Lord. Maybe I can get him to forgive your sin.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","So Moses went back to the Lord. He said, “Please—the people have sinned very badly by making gods of gold for themselves. ");
INSERT INTO engfbv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","But now, if you will, forgive their sin. Otherwise just blot me out of the scroll in which you keep your records.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","But the Lord replied to Moses, “It's those who sinned against me who will be blotted out of my scroll. ");
INSERT INTO engfbv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Now go and lead the people to the place I told you about. Look, my angel will go before you, but at the time I decide to punish, I will punish them for their sin.” ");
INSERT INTO engfbv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","The Lord brought a plague on the people because they made Aaron make the bull calf. ");
INSERT INTO engfbv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Then the Lord told Moses, “Leave this place, you and the people you led out of Egypt, and go to the land I promised with an oath to give to Abraham, Isaac and Jacob, telling them, ‘I will give this land to your descendants.’ ");
INSERT INTO engfbv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","I will send an angel out in front of you, and I will drive out the Canaanites, Amorites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engfbv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Enter a land flowing with milk and honey, but I will not accompany you because you are a rebellious people. Otherwise I would destroy you on the way.” ");
INSERT INTO engfbv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","When the people heard these words of criticism, they mourned and didn't put on their jewelry. ");
INSERT INTO engfbv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","For the Lord had previously told Moses, “Tell the people of Israel, ‘You are a rebellious people. If I was with you for just a moment, I would wipe you out. Now remove your jewelry, and I'll decide what to do with you.’” ");
INSERT INTO engfbv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the Israelites took off their jewelry from the time they left Mount Sinai. ");
INSERT INTO engfbv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses used to set up the Tent of Meeting some way outside the camp. Anyone who wanted to ask the Lord anything could go out there to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Whenever Moses went out to the Tent, all the people would go and stand at the entrance of their tents. They would watch him until he had gone inside. ");
INSERT INTO engfbv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","As soon as Moses went into the Tent, the cloud column would descend and stand in the doorway as the Lord spoke with Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","When the people saw the cloud column standing in the doorway to the Tent, everyone would stand up and bow in worship at the entrance of their tents. ");
INSERT INTO engfbv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Moses would speak to the Lord face to face as you would talk to a friend, and then return to the camp. However, his young assistant Joshua, son of Nun, stayed in the Tent. ");
INSERT INTO engfbv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses said to the Lord, “Look, you've been telling me, ‘Go and lead these people,’ but you haven't let me know who you're going to send with me. And yet you have stated, ‘I know you personally, and I'm happy with you.’ ");
INSERT INTO engfbv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Now if it's true that you're happy with me, please teach me your ways so I can get to know you, and go on pleasing you. Remember that the people of this nation are yours.” ");
INSERT INTO engfbv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","The Lord replied, “I myself will go with you, and I will support you.” ");
INSERT INTO engfbv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","“If you don't go with us yourself, then please don't take us away from here,” Moses responded. ");
INSERT INTO engfbv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","“How will others know that you are happy with me, and with your people, if you don't accompany us? How would anyone tell us apart—me and your people—from every other people who live on the earth?” ");
INSERT INTO engfbv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","The Lord told Moses, “I promise to do what you've asked, because I'm happy with you and I know you personally.” ");
INSERT INTO engfbv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","“Now please reveal to me your glory,” Moses asked. ");
INSERT INTO engfbv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","“I will make all the goodness of my character pass in front of you, I will call out the name ‘Yahweh,’ I will show grace to those I want to show grace, and I will show mercy to those I want to show mercy. ");
INSERT INTO engfbv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But you won't be able to see my face, because no one can see my face and live.” ");
INSERT INTO engfbv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“Come here and stand by me on this rock,” the Lord went on, ");
INSERT INTO engfbv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","“and as my glory goes by I'll put you in a crevice of the rock, and I'll cover you with my hand until I have passed by. ");
INSERT INTO engfbv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I'll take my hand away and you'll see my back; but you won't see my face.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","The Lord told Moses, “Cut out two stone tablets like the first ones, and I will write on them again the same words that were on the first tablets—the ones you broke. ");
INSERT INTO engfbv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Get ready in the morning, and then come up Mount Sinai. Stand before me there on the mountain top. ");
INSERT INTO engfbv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nobody else can come up with you—I don't want to see anyone anywhere on the mountain, and no flocks or herds should graze at the foot of the mountain.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses cut out two stone tablets like the previous ones and went up Mount Sinai early in the morning as the Lord had ordered him, taking with him the two stone tablets. ");
INSERT INTO engfbv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","The Lord descended in a cloud, stood there with him, and called out the name “Yahweh.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","The Lord passed in front of him, calling out, “Yahweh! Yahweh! I am the God of grace and mercy! I am slow to become angry, full of trustworthy love and always faithful. ");
INSERT INTO engfbv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","I go on showing my trustworthy love to thousands, forgiving guilt, rebellion, and sin. But I will definitely not clear the wicked—the impact of sin will affect not only the parents, but also their children and grandchildren, up until the third and fourth generation.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moses quickly bowed down to the ground, and worshiped. ");
INSERT INTO engfbv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","He said, “Lord, if it's true that you're happy with me, please accompany us. Admittedly this is a rebellious people, but please forgive our guilt and sin. Accept us as specially belonging to you.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","The Lord said, “Look, I'm making an agreement with you. Right in front of all of you I will do miracles that have never been done before—not among anyone anywhere on earth. Everyone here and those around will see the Lord at work, for what I'm going to do for you will be incredible. ");
INSERT INTO engfbv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","But you must carefully follow what I tell you to do today. Pay attention! I'm going to drive out ahead of you the Amorites, Canaanites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engfbv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Make sure you don't agree to a peace treaty with the people living in the land where you are going. Otherwise they will become a trap for you. ");
INSERT INTO engfbv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","For you must tear down their altars, knock down their idolatrous pillars, and cut down their Asherah poles, ");
INSERT INTO engfbv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","because you must not worship any other gods than the Lord. His name stands for being exclusive, because he is a God who demands an exclusive relationship. ");
INSERT INTO engfbv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Make sure you don't agree to a peace treaty with the people living in the land, for when they prostitute themselves by worshiping and sacrificing to their gods, they will invite you to join them, and you will eat from their pagan sacrifices. ");
INSERT INTO engfbv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","When you have their daughters marry your sons and those daughters prostitute themselves to their gods, they will make your sons worship their gods in the same way. ");
INSERT INTO engfbv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Don't make any idols for yourselves. ");
INSERT INTO engfbv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Observe the Festival of Unleavened Bread. For seven days you are to eat bread made without yeast, as I ordered you to do. You are to do this at the specified time in the month of Abib, because that was the month when you left Egypt. ");
INSERT INTO engfbv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Every firstborn is mine. That includes all the firstborn males of your livestock from your cattle herds, and flocks. ");
INSERT INTO engfbv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","You can redeem the firstborn of a donkey with a lamb, but if you don't, you must break its neck. All your firstborn sons must be redeemed. No one is to come before me without an offering. ");
INSERT INTO engfbv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","You shall work for six days, but you shall rest on the seventh day. Even during the times of sowing and harvest you shall rest. ");
INSERT INTO engfbv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Observe the Festival of Weeks when you offer the firstfruits of wheat harvest, and the Harvest Festival at the end of the agricultural year. ");
INSERT INTO engfbv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Three times every year all your males must appear before the Lord Yahweh, the God of Israel. ");
INSERT INTO engfbv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","I will drive out the nations ahead of you and expand your borders, and no one will come and take your land when you go three times a year to appear before the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Don't offer bread made with yeast when you present a sacrifice to me, don't keep any sacrifice from the Passover Feast until the morning. ");
INSERT INTO engfbv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","When you harvest your crops, bring the firstfruits to the house of the Lord your God. Don't cook a young goat in milk from its mother.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Then the Lord told Moses, “Write down these words, because these are the basis for the agreement I have made with you and with Israel.” ");
INSERT INTO engfbv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses spent forty days and forty nights there with the Lord without eating bread or drinking water. He wrote down on the tablets the words of the agreement, the Ten Commandments. ");
INSERT INTO engfbv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","When Moses came down from Mount Sinai carrying the two tablets of the Law, he didn't realize that his face was shining brightly because he had been speaking with the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","When Aaron and the Israelites saw Moses with his face shining so brightly they were frightened to approach him. ");
INSERT INTO engfbv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses called out to them, so Aaron and all the community leaders went over to him, and he talked with them. ");
INSERT INTO engfbv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Afterwards all the Israelites came over and he gave them all the Lord's instructions he'd received on Mount Sinai. ");
INSERT INTO engfbv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","After Moses finished talking with them, he put a veil over his face. ");
INSERT INTO engfbv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","However, whenever Moses went in to talk with the Lord, he would take off the veil until he came out again. Then he would tell the Israelites the Lord's instructions, ");
INSERT INTO engfbv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","and the Israelites would see his face shining brightly. So he would put the veil over his face until the next time he went to talk with the Lord. ");
INSERT INTO engfbv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses summoned all the Israelites and told them, “This is what the Lord has ordered you to do: ");
INSERT INTO engfbv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Six days you can work, but the seventh day is to be a holy Sabbath of rest to the Lord. Anyone who does any work on the Sabbath day must be killed. ");
INSERT INTO engfbv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Don't even light a fire in any of your homes on the Sabbath day.” ");
INSERT INTO engfbv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses also told all the Israelites, “This is what the Lord has commanded: ");
INSERT INTO engfbv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Collect an offering to the Lord from what you have. Everyone who wants to should bring an offering to the Lord: gold, silver, and bronze; ");
INSERT INTO engfbv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, and crimson thread; finely-woven linen and goat hair; ");
INSERT INTO engfbv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","tanned ram skins and fine leather; acacia wood; ");
INSERT INTO engfbv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","olive oil for the lamps; spices for the anointing oil and for the aromatic incense; ");
INSERT INTO engfbv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","and onyx stones and gemstones for making the ephod and breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","All your skilled craftsmen are to come and make everything the Lord has commanded: ");
INSERT INTO engfbv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the Tabernacle with its tent and covering, its clips and frames, its crossbars, posts, and stands; ");
INSERT INTO engfbv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the Ark with its poles and atonement cover, and the veil to hang over it; ");
INSERT INTO engfbv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table with its poles, all its equipment, and the Bread of the Presence; ");
INSERT INTO engfbv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand of light with its equipment and lamps and olive oil to provide lighting; ");
INSERT INTO engfbv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","the altar of incense with its poles; the anointing oil and aromatic incense; the screen for the Tabernacle entrance and all its accessories; ");
INSERT INTO engfbv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar of burnt offering with its bronze grate, its poles and all its utensils; the basin plus its stand; ");
INSERT INTO engfbv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the curtains of the courtyard with its posts and bases, and the curtain for the courtyard entrance; ");
INSERT INTO engfbv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","the tent pegs for the Tabernacle and for the courtyard, as well as their ropes; ");
INSERT INTO engfbv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","and the woven clothes for serving in the holy place: the sacred clothing for Aaron the priest and for his sons to serve as priests.” ");
INSERT INTO engfbv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","The Israelites left Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","and all those who felt moved to do so and who had a willing spirit came and brought an offering to the Lord for the work making the Tent of Meeting, for everything required for its services, and for the sacred clothing. ");
INSERT INTO engfbv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","So everyone who was willing, both men and women, came and presented their gold as a thanks offering to the Lord, including brooches, earrings, rings, and necklaces—all kinds of gold jewelry. ");
INSERT INTO engfbv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone who had blue, purple, and crimson thread, finely-woven linen, goat hair, tanned ram skins, and fine leather, contributed them. ");
INSERT INTO engfbv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Those who could present an offering of silver or bronze brought it as a gift to the Lord. Everyone who had acacia wood for any part of the work donated it. ");
INSERT INTO engfbv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Every woman skilled in spinning with her hands brought what she had spun: blue, purple, or crimson thread, or finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","All the women who were willing to use their skills spun the goat hair. ");
INSERT INTO engfbv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The leaders brought onyx stones and gemstones to make the ephod and breastpiece, ");
INSERT INTO engfbv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","as well as spices and olive oil for lighting, for the anointing oil, and for the aromatic incense. ");
INSERT INTO engfbv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","All the Israelite men and women who were willing brought a freewill offering to the Lord for all the work in making what the Lord through Moses had ordered them to do. ");
INSERT INTO engfbv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Then Moses told the Israelites, “The Lord has chosen by name Bezalel, son of Uri, son of Hur, from the tribe of Judah. ");
INSERT INTO engfbv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","He has filled him with the Spirit of God giving him ability, creativity, and expertise in all kinds of craftsmanship. ");
INSERT INTO engfbv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","He can produce designs in gold, silver, and bronze, ");
INSERT INTO engfbv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","he can cut gemstones to place in settings, and he can carve wood. He is a master of every craft. ");
INSERT INTO engfbv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","The Lord has also given him and Oholiab son of Ahisamach, from the tribe of Dan, the ability to teach others. ");
INSERT INTO engfbv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has equipped them with skill to do all kinds of work as engravers, designers, embroiderers in blue, purple, and crimson thread, and finely-woven linen, and as weavers—in fact as skilled designers in all kinds of different crafts.” ");
INSERT INTO engfbv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“So Bezalel, Oholiab, and all the other craftsmen with the necessary expertise, given skill and ability by the Lord, are to work out how to accomplish all the work of constructing the sanctuary as commanded by the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moses summoned Bezalel, Oholiab, and all the skilled people who had been given special abilities by the Lord, everyone willing to come and do the work. ");
INSERT INTO engfbv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moses gave them everything the Israelites had contributed to carry out the work of constructing the sanctuary. In the meantime the people went on bringing freewill offerings every morning, ");
INSERT INTO engfbv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","so much so that all the craftsmen who were working on the sanctuary stopped what they were doing ");
INSERT INTO engfbv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","and went and told Moses, “The people have already brought enough to complete the work the Lord has ordered us to do.” ");
INSERT INTO engfbv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moses gave the order, and an announcement was made throughout the camp: “Men and women, don't bring anything more as an offering for the sanctuary.” So the people were stopped from bringing anything more, ");
INSERT INTO engfbv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","since there was already more than enough to do all the work necessary. ");
INSERT INTO engfbv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","The skilled craftsmen among the workers made the ten curtains for the Tabernacle. They were made of finely-spun linen together with blue, purple, and crimson thread, embroidered with cherubim. ");
INSERT INTO engfbv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Each curtain was twenty-eight cubits long by four cubits wide, and they were all the same size. ");
INSERT INTO engfbv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","They joined together five of the curtains as one set, and the other five as a second set. ");
INSERT INTO engfbv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","They used blue material to make loops on the edge of the last curtain of both sets. ");
INSERT INTO engfbv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","They made fifty loops on one curtain and fifty loops on the last curtain of the second set, lining up the loops with each another. ");
INSERT INTO engfbv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","They also made fifty gold clips and joined the curtains together with the clips, so that the Tabernacle was a single structure. ");
INSERT INTO engfbv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","They made eleven curtains of goat hair as a tent to cover the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Each of the eleven curtains was the same size—thirty cubits long by four cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","They joined five of the curtains together as one set and the other six as another set. ");
INSERT INTO engfbv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","They made fifty loops on the edge of the last curtain in the first set, and fifty loops on the edge of the last curtain in the second set. ");
INSERT INTO engfbv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","They made fifty bronze clips to join the tent together as a single cover. ");
INSERT INTO engfbv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","They made a covering for the goat hair tent from tanned ram skins, and placed an extra covering of fine leather over that. ");
INSERT INTO engfbv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","They made an upright framework of acacia wood for the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Each frame was ten cubits long by one and a half cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Each frame had two pegs so the frames could be connected to each other. They made all the frames of the Tabernacle like this. ");
INSERT INTO engfbv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","They made twenty frames for the south side of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","They made forty silver stands as supports for the twenty frames using two stands per frame, one under every frame peg. ");
INSERT INTO engfbv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Similarly for the north side of the Tabernacle, they made twenty frames ");
INSERT INTO engfbv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","and forty silver stands, two stands per frame. ");
INSERT INTO engfbv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","They made six frames for the back (west side) of the Tabernacle, ");
INSERT INTO engfbv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","along with two frames for its two back corners. ");
INSERT INTO engfbv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","They joined these corner frames at the bottom and at the top near to the first ring. This is how they made the two corner frames. ");
INSERT INTO engfbv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","In total there were eight frames and sixteen silver stands, two under each frame. ");
INSERT INTO engfbv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","They made five crossbars of acacia wood to hold together the frames on the south side of the Tabernacle, ");
INSERT INTO engfbv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","five for those on the north, and five for those at the back of the Tabernacle, to the west. ");
INSERT INTO engfbv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","They made the central crossbar which was placed halfway up the frames and ran from one end to the other. ");
INSERT INTO engfbv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","They covered the frames with gold, and made gold rings to hold the crossbars in place. They covered the crossbars with gold too. ");
INSERT INTO engfbv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","They made a veil out of blue, purple, and crimson thread, and finely-spun linen, embroidered with cherubim by someone who was skilled. ");
INSERT INTO engfbv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","They made four posts of acacia wood for it and covered them with gold. They made gold hooks for the posts and cast their four silver stands. ");
INSERT INTO engfbv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","They made a screen for the entrance to the tent using blue, purple, and crimson thread, and finely-spun linen, and had it embroidered. ");
INSERT INTO engfbv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","They also made five posts of acacia wood with hooks to hang the screen. They covered the tops of the posts and their bands with gold, and their five stands were made of bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel made the Ark of acacia wood measuring two and a half cubits long by a cubit and a half wide by one and a half cubits high. ");
INSERT INTO engfbv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He covered it with pure gold on the inside and the outside, and made a gold trim to go around it. ");
INSERT INTO engfbv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He cast four gold rings and attached them to its four feet, two on one side and two on the other. ");
INSERT INTO engfbv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","He made poles of acacia wood and covered them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He placed the poles into the rings on the sides of the Ark, so it could be carried. ");
INSERT INTO engfbv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","He made the atonement cover of pure gold, two and a half cubits long by a cubit and a half wide. ");
INSERT INTO engfbv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","He made two cherubim of hammered gold for the ends of the atonement cover, ");
INSERT INTO engfbv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","and put one cherub on each end. All of this was made from one piece of gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","The cherubim were designed with spread wings pointing upward, covering the atonement cover. The cherubim were placed facing each other, looking down towards the atonement cover. ");
INSERT INTO engfbv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Then he made the table of acacia wood two cubits long by a cubit wide by a cubit and a half high. ");
INSERT INTO engfbv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He covered it with pure gold and made a gold trim to go around it. ");
INSERT INTO engfbv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","He made a border around it the width of a hand and put a gold trim on the border. ");
INSERT INTO engfbv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","He cast four gold rings for the table and attached them to the four corners of the table by the legs. ");
INSERT INTO engfbv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","The rings were close to the border to hold the poles used to carry the table. ");
INSERT INTO engfbv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","He made the poles of acacia wood for carrying the table and covered them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","He made utensils for the table from pure gold: plates and dishes, bowls and pitchers for pouring out drink offerings. ");
INSERT INTO engfbv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","He made the lampstand of pure, hammered gold. The whole of it was made of one piece—its base, shaft, cups, buds, and flowers. ");
INSERT INTO engfbv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","It had six branches coming out of the sides of the lampstand, three on each side. It had three cups shaped like almond flowers on the first branch, each with buds and petals, and three on the next branch. ");
INSERT INTO engfbv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Each of the six branches that came out had three cups shaped like almond flowers, all complete with buds and petals. ");
INSERT INTO engfbv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","On the main shaft of the lampstand he made four cups shaped like almond flowers, complete with buds and petals. ");
INSERT INTO engfbv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","On the six branches that came out of it, he placed a bud under the first pair of branches, a bud under the second pair, and a bud under the third pair. ");
INSERT INTO engfbv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","The buds and branches were made with the lampstand as one piece, hammered out of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","He made seven lamps, as well as wick tongs and their trays of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","The lampstand and all these utensils required a talent of pure gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","He made the altar for burning incense from acacia wood. It was square, measuring a cubit by a cubit, by two cubits high, with horns on its corners that were all one piece with the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He covered its top, its side, and its horns with pure gold, and made a gold trim to go all around it. ");
INSERT INTO engfbv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two gold rings for the altar and attached them below the trim, two on either side, to hold the poles to carry it. ");
INSERT INTO engfbv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made the poles of acacia wood and covered them with gold. ");
INSERT INTO engfbv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","He made the holy anointing oil and the pure, aromatic incense like the product of an expert perfumer. ");
INSERT INTO engfbv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel made the altar of burnt offering from acacia wood. It was square, and measured five cubits long by five cubits wide by three cubits high. ");
INSERT INTO engfbv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made horns for each of its corners, all one piece with the altar, and covered the whole altar with bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He made all its utensils: buckets for removing ashes, shovels, sprinkling bowls, meat forks, and firepans. He made all its utensils of bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","He made a bronze mesh grate for the altar and placed it under the ledge of the altar, so that the mesh came halfway down the altar. ");
INSERT INTO engfbv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","He cast four bronze rings for the four corners of the grate as holders for the poles. ");
INSERT INTO engfbv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","He made poles of acacia wood for the altar and covered them with bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the poles through the rings on either side of the altar so it could be carried. He made the altar hollow, using boards. ");
INSERT INTO engfbv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","He made the bronze basin with its stand with bronze from the mirrors of the women who served at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Then he made a courtyard. For the south side of the courtyard he made curtains of finely-spun linen, a hundred cubits long on one side, ");
INSERT INTO engfbv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","with twenty posts and twenty bronze stands, with silver hooks and bands on the posts. ");
INSERT INTO engfbv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Similarly he made curtains placed on the north side in an identical arrangement. ");
INSERT INTO engfbv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","He made curtains for the west side of the courtyard fifty cubits wide, with ten posts and ten stands. ");
INSERT INTO engfbv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","The east side of the courtyard that faces the sunrise was fifty cubits wide. ");
INSERT INTO engfbv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","He made the curtains on one side fifteen cubits long, with three posts and three stands, ");
INSERT INTO engfbv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","and the curtains on the other side just the same. ");
INSERT INTO engfbv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the curtains around the courtyard were of finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The stands for the posts were bronze, the hooks and bands were silver, and the tops of the posts were covered with silver. All the posts around the courtyard had silver bands. ");
INSERT INTO engfbv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The curtain for the entrance to the courtyard was embroidered with blue, purple, and crimson thread, and finely-spun linen. It was twenty cubits long by five cubits high, the same height as the courtyard curtains. ");
INSERT INTO engfbv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","It was held up by four posts and four stands. The posts had silver hooks, tops, and bands. ");
INSERT INTO engfbv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs for the Tabernacle and for the surrounding courtyard were made of bronze. ");
INSERT INTO engfbv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","The following is what was used for the Tabernacle, the Tabernacle of the Testimony, recorded at Moses' direction by the Levites under the supervision of Ithamar, son of Aaron the priest. ");
INSERT INTO engfbv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel, son of Uri, son of Hur, from the tribe of Judah, made everything that the Lord had ordered Moses to make. ");
INSERT INTO engfbv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","He was assisted by Oholiab, son of Ahisamach, from the tribe of Dan, an engraver, designer, and embroiderer using blue, purple, and crimson thread and finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","The total amount of gold from the offering that was used for the work on the sanctuary was 29 talents and 730 shekels (using the sanctuary shekel standard). ");
INSERT INTO engfbv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","The total amount of silver from those who had been counted in the census was 100 talents and 1,775 shekels (using the sanctuary shekel standard). ");
INSERT INTO engfbv_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","This represents a beka per person, or half a shekel (using the sanctuary shekel standard) from everyone twenty years of age or older who had been censused, a total of 603,550 men. ");
INSERT INTO engfbv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","The hundred talents of silver were used to cast the sanctuary stands and the curtain stands, 100 bases from the 100 talents, or one talent per base. ");
INSERT INTO engfbv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bezalel used the 1,775 shekels of silver to make the hooks for the posts, cover their tops, and make bands for them. ");
INSERT INTO engfbv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","The total amount of bronze from the offering was 70 talents and 2,400 shekels. ");
INSERT INTO engfbv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bezalel used it to make the stands for the entrance to the Tent of Meeting, the bronze altar and its bronze grate, all the utensils for the altar, ");
INSERT INTO engfbv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","the stands for the courtyard and its entrance, and all the tent pegs for the Tabernacle and the courtyard. ");
INSERT INTO engfbv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","They made woven clothing from blue, purple, and crimson thread for serving in the sanctuary. They also made holy garments for Aaron, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","They made the ephod of finely-woven linen embroidered with gold, and with blue, purple, and crimson thread. ");
INSERT INTO engfbv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","They hammered out thin sheets of gold and cut threads from them to weave in with the blue, purple, and scarlet thread, together with fine linen, all skillfully worked. ");
INSERT INTO engfbv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Two shoulder pieces were attached to the front and back pieces. ");
INSERT INTO engfbv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","The waistband of the ephod was one piece made in the same way, using gold thread, with blue, purple, and crimson thread, and with finely-woven linen, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","They placed the onyx stones in ornamental gold settings, engraved with the names of the Israelite tribes in the same way a jeweler engraves a personal seal. ");
INSERT INTO engfbv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","They attached both stones to the shoulder pieces of the ephod as reminders for the Israelite tribes, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","They also made a breastpiece for decisions in the same skilful way as the ephod, to be used in determining the Lord's will. They made it using gold thread, with blue, purple, and crimson thread, and with finely-woven linen. ");
INSERT INTO engfbv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","It was square when folded, measuring around nine inches in length and width. ");
INSERT INTO engfbv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","They attached an arrangement of precious stones in four rows as follows. In the first row carnelian, peridot, and emerald. ");
INSERT INTO engfbv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","In the second row turquoise, lapis lazuli, and sardonyx. ");
INSERT INTO engfbv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","In the third row jacinth, agate, and amethyst. ");
INSERT INTO engfbv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","In the fourth row topaz, beryl, and jasper. They were all placed in ornamental gold settings. ");
INSERT INTO engfbv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Each of the twelve stones were engraved like a personal seal with the name of one of the twelve Israelites tribes and represented them. ");
INSERT INTO engfbv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","They made cords of braided chains from pure gold to attach the breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","They made two gold settings and two gold rings and fastened the rings to the two top corners of the breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They attached the two gold chains to the two gold rings on the corners of the breastpiece, ");
INSERT INTO engfbv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","and then fastened the opposite ends of the two chains to the ornamental gold settings on the shoulder pieces of the front side of the ephod. ");
INSERT INTO engfbv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","They made two more gold rings and attached them to the two lower corners of the breastpiece, on the inside edge next to the ephod. ");
INSERT INTO engfbv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They made two more gold rings and attached them to the bottom of the two shoulder pieces of the front side of the ephod, near where it joins its woven waistband. ");
INSERT INTO engfbv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","They tied the rings of the breastpiece to the rings of the ephod with a cord of blue thread, so that the breastpiece wouldn't come loose from the ephod, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","They made the robe that goes with the ephod exclusively from woven blue cloth, ");
INSERT INTO engfbv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","with an opening in the middle at the top. They stitched a woven collar around the opening to strengthen it so it wouldn't tear. ");
INSERT INTO engfbv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","They made pomegranates using blue, purple, and crimson thread and finely-woven linen and attached them all the way around its hem. ");
INSERT INTO engfbv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","They made pure gold bells and attached them between the pomegranates all the way around its hem, ");
INSERT INTO engfbv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","having the bells and the pomegranates alternate. The robe was to be used for priestly service, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","They made tunics with finely-spun linen made by a weaver for Aaron and his sons. ");
INSERT INTO engfbv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","They also made turbans, headdresses, and headbands of fine linen, and finely-woven linen undershorts, ");
INSERT INTO engfbv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","as well as sashes of finely-woven linen embroidered with blue, purple, and crimson thread, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","They made the plate of the holy crown of pure gold and wrote on it, engraved like a seal, “Holy to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They tied a blue cord to it to attach it to the front of the turban, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So all the work for the Tabernacle, the Tent of Meeting, was finished. The Israelites did everything as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Then they presented the Tabernacle to Moses: the tent with all its furniture, its clips, its frames, its crossbars, and its posts and stands; ");
INSERT INTO engfbv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","the covering of tanned ram skins, the covering of fine leather, and the veil; ");
INSERT INTO engfbv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","the Ark of the Testimony with its poles and the atonement cover; ");
INSERT INTO engfbv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","the table with all its equipment and the Bread of the Presence; ");
INSERT INTO engfbv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","the pure gold lampstand with its lamps placed in a row, and all its equipment, as well as the olive oil for the lamps; ");
INSERT INTO engfbv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","the gold altar, the anointing oil, the aromatic incense, and the screen for the tent's entrance; ");
INSERT INTO engfbv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","the bronze altar with its bronze grate, its poles, and all its utensils; the basin plus its stand; ");
INSERT INTO engfbv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","the curtains of the courtyard and its posts and stands; the curtain for the courtyard entrance, its ropes and tent pegs, and all the equipment for the services of the Tabernacle, the Tent of Meeting; ");
INSERT INTO engfbv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","and the woven garments for serving in the sanctuary, the holy clothes for Aaron the priest and for his sons to serve as priests. ");
INSERT INTO engfbv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The Israelites did all the work that the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses inspected all the work and made sure they had done it as the Lord had ordered. Then Moses blessed them. ");
INSERT INTO engfbv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Put up the Tabernacle, the Tent of Meeting, on the first day of the first month of the year. ");
INSERT INTO engfbv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Place the Ark of the Testimony inside it. Make sure the Ark is behind the veil. ");
INSERT INTO engfbv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Bring in the table and put on it what's necessary. Bring in the lampstand too, and set up its lamps. ");
INSERT INTO engfbv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Place the gold altar of incense in front of the Ark of the Testimony, and put up the screen at the entrance to the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Set up the altar of burnt offering opposite the entrance to the Tabernacle, the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Place the basin between the Tent of Meeting and the altar, and put water in it. ");
INSERT INTO engfbv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Set up the courtyard that's around it, and put up the curtain for the courtyard entrance. ");
INSERT INTO engfbv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Use the anointing oil to anoint the Tabernacle and everything in it. Dedicate it and all its furniture to make it holy. ");
INSERT INTO engfbv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Anoint the altar of burnt offering and all its utensils. Dedicate the altar and it will be especially holy. ");
INSERT INTO engfbv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Anoint and dedicate the basin with its stand. ");
INSERT INTO engfbv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Take Aaron and his sons to the entrance of the Tent of Meeting and wash them there with water. ");
INSERT INTO engfbv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Then you are to put on Aaron the holy clothes, anoint him, and dedicate him, so that he may serve me as a priest. ");
INSERT INTO engfbv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Have his sons come forward and dress them with tunics. ");
INSERT INTO engfbv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Anoint them in the same way as you anointed their father, so that they can also serve me as priests. Their anointing makes their line priests forever, for generations to come.” ");
INSERT INTO engfbv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses carried out all the Lord's instructions. ");
INSERT INTO engfbv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","The Tabernacle was put up on the first day of the first month of the second year. ");
INSERT INTO engfbv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","When Moses put up the Tabernacle, he placed its stands, attached its frames, connected its crossbars, and erected its posts. ");
INSERT INTO engfbv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Then he spread the tent over the Tabernacle and placed the covering over the tent, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Moses took the Testimony and put it in the Ark. He attached the poles to the Ark, and he placed the atonement cover on the top of the Ark. ");
INSERT INTO engfbv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Then he carried the Ark into the Tabernacle. He put up the veil, and made sure the Ark of the Testimony was behind it, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Moses placed the table inside the Tent of Meeting on the north side of the Tabernacle, outside the veil. ");
INSERT INTO engfbv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","He laid out the bread on it in the presence of the Lord, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","He placed the lampstand in the Tent of Meeting opposite the table on the south side of the Tabernacle ");
INSERT INTO engfbv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","and put up the lamps in the presence of the Lord, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Moses set up the gold altar in the Tent of Meeting, in front of the veil, ");
INSERT INTO engfbv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","and he burned aromatic incense on it, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Then he put up the screen at the entrance to the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","He set up the altar of burnt offering near the entrance to the Tabernacle, the Tent of Meeting, and presented the burnt offering and the grain offering, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","He placed the basin between the Tent of Meeting and the altar and put water in it for washing. ");
INSERT INTO engfbv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses, Aaron, and his sons used it to wash their hands and feet ");
INSERT INTO engfbv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","They washed whenever they went into the Tent of Meeting or approached the altar, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Moses set up the courtyard around the Tabernacle and the altar, and he put up the curtain for the courtyard entrance. This marked the end of the work done by Moses. ");
INSERT INTO engfbv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the Tent of Meeting, and the glory of the Lord filled the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses could not enter the Tent of Meeting because the cloud remained on it, and the glory of the Lord filled the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Whenever the cloud rose from the Tabernacle, the Israelites would set off again on their journey. ");
INSERT INTO engfbv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","If the cloud did not rise, they wouldn't set out until it did. ");
INSERT INTO engfbv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","The cloud of the Lord stayed over the Tabernacle by day, and fire burned inside the cloud by night, so that it could be seen by every Israelite wherever they traveled. ");
INSERT INTO engfbv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","The Lord called Moses and spoke to him from the Tent of Meeting, saying, ");
INSERT INTO engfbv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Go and speak to the Israelites and tell them: When you present an offering to the Lord, you may bring as your offering an animal from the herd of cattle or the flock of sheep or goats. ");
INSERT INTO engfbv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","If your offering is a burnt offering from a herd of cattle, you must offer a male without any defects. Bring it to the entrance of the Tent of Meeting so it can be accepted before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Put your hand on the head of the burnt offering, so it can be accepted on your behalf to make you right. ");
INSERT INTO engfbv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","You are to kill the bull in the Lord's presence, and Aaron's sons, the priests, are to take the blood and sprinkle it on all sides of the altar at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Then you are to skin the burnt offering and cut it into pieces. ");
INSERT INTO engfbv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","The sons of Aaron the priest shall start a fire on the altar and put wood on it. ");
INSERT INTO engfbv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Then the priests shall carefully place the pieces, including the head and the fat, on the wood burning on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","You shall wash the insides and legs with water, and the priest shall burn all of it on the altar as a burnt offering, a food offering, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","If your offering is a burnt offering from a flock, either sheep or goats, you must offer a male without any defects. ");
INSERT INTO engfbv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","You are to kill it on the north side of the altar in the Lord's presence, and Aaron's sons, the priests, are to take the blood and sprinkle it on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Then you are to cut it into pieces, and the priest shall carefully place the pieces, including the head and the fat, on the wood burning on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","You shall wash the insides and legs with water, and the priest shall burn all of it on the altar as a burnt offering, a food offering, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","If your offering to the Lord is a burnt offering of birds, you are to offer a turtledove or a young pigeon. ");
INSERT INTO engfbv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest shall take it to the altar, twist off its head, and burn it on the altar. Its blood shall be drained out on the side of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","He must remove the crop and the feathers, and throw them to the east side of the altar into the ash pile. ");
INSERT INTO engfbv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","He shall tear it open by its wings, but not completely apart. The priest is to burn it on the altar on the burning wood. It is a burnt offering, a food offering, to be accepted by the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“When you bring a grain offering to the Lord, your offering must be of the best flour. Pour olive oil on it and put frankincense on it, ");
INSERT INTO engfbv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","and take it to Aaron's sons the priests. The priest shall take a handful of the flour and olive oil mixture, as well as all the frankincense, and burn this as a ‘reminder part’ on the altar, a food offering, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","The rest of the grain offering is for Aaron and his sons; it is a most holy part of the offerings given to the Lord as food offerings. ");
INSERT INTO engfbv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","If your offering is of grain baked in an oven, it must be made from fine flour without using yeast. It can be cakes mixed with olive oil or wafers with olive oil spread on them. ");
INSERT INTO engfbv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If your offering is a grain offering cooked on a griddle, it must be made of fine flour mixed with olive oil without using yeast. ");
INSERT INTO engfbv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Break it up and pour olive oil over it; it is a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If your offering is a grain offering cooked in a pan, it must be made of fine flour with olive oil. ");
INSERT INTO engfbv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bring to the Lord the grain offering in whatever way it has been prepared. Present it to the priest, who will take it to the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","The priest is to take the ‘reminder part’ from the grain offering and burn it on the altar as a food offering, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","The rest of the grain offering is for Aaron and his sons; it is a most holy part of the food offerings given to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","No grain offering that you give to the Lord may be made using yeast. Don't burn any yeast or honey as a food offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You may give them to the Lord when you present your offerings of firstfruits, but they must not be offered on the altar to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","All of your grain offerings are to be seasoned with salt. Don't leave the salt of God's agreement out of your grain offering. Add salt to all of your offerings. ");
INSERT INTO engfbv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","When you bring a grain offering of firstfruits to the Lord, offer crushed heads of new grain roasted on the fire. ");
INSERT INTO engfbv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Put olive oil and frankincense on it; it is a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","The priest will burn the ‘reminder part’ of the crushed grain and olive oil, as well as all its frankincense, as a food offering to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“When you want to give a peace offering and you offer an animal from a herd of cattle, whether male or female, you must present one without any defects before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Put your hand on the head of the offering and kill it at the entrance to the Tent of Meeting. Then Aaron's sons the priests will sprinkle the blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","From the peace offering you are to bring a food offering to the Lord: all the fat that covers the insides, ");
INSERT INTO engfbv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","both kidneys with the fat on them by the loins, and the best part of the liver, which you are to remove together with the kidneys. ");
INSERT INTO engfbv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aaron's sons are to burn this on the altar on top of the burnt offering that is on the burning wood, as a food offering, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","When you want to give a peace offering and you offer an animal from a flock of sheep or goats, either male or female, you must present one without any defects before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If you are giving a lamb as your offering, you must present it before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Put your hand on the head of the offering and kill it in front of the Tent of Meeting. Then Aaron's sons the priests will sprinkle the blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","From the peace offering you are to bring a food offering to the Lord made up of its fat: the whole fat tail removed from close to the tailbone, all the fat that covers the insides, ");
INSERT INTO engfbv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","both kidneys with the fat on them by the loins, and the best part of the liver, which you are to remove together with the kidneys. ");
INSERT INTO engfbv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Then the priest is to burn this on the altar as a food offering, a food offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","If your offering is a goat, you are to present it before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Put your hand on its head and kill it in front of the Tent of Meeting. Then Aaron's sons the priests will sprinkle the blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","From your offering you are to present a food offering to the Lord made up of all the fat that covers the insides, ");
INSERT INTO engfbv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","both kidneys with the fat on them by the loins, and the best part of the liver, which you are to remove together with the kidneys. ");
INSERT INTO engfbv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Then the priest is to burn this on the altar as a food offering, an offering to the Lord using fire. All the fat is for the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","You must not eat any fat or any blood. This regulation is for all time and for all future generations everywhere you live.” ");
INSERT INTO engfbv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tell the Israelites that these are the rules to handle cases of those who sin unintentionally against any of the Lord's commandments and do what is not permitted. ");
INSERT INTO engfbv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","If it is the high priest who sins and brings guilt on everyone, he must present to the Lord a young bull without defects as a sin offering for his sin. ");
INSERT INTO engfbv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He must take the bull to the entrance of the Tent of Meeting before the Lord, put his hand on its head and kill it before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Then the high priest shall take some of the bull's blood into the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","The high priest shall dip his finger in the blood and sprinkle some of it seven times before the Lord in front of the veil of the sanctuary. ");
INSERT INTO engfbv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","The priest shall put some of the blood on the horns of the altar of aromatic incense that stands before the Lord in the Tent of Meeting. The rest of the bull's blood he is to pour out at the bottom of the altar of burnt offering at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Then he shall remove all the fat from the bull of the sin offering: all the fat that covers the insides, ");
INSERT INTO engfbv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","both kidneys with the fat on them by the loins, and the best part of the liver, which he is to remove together with the kidneys ");
INSERT INTO engfbv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","in the same way as the fat is removed from the bull of the peace offering. Then the priest shall burn this on the altar of burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","But the skin of the bull, all its flesh, head, legs, insides and waste— ");
INSERT INTO engfbv_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","all the rest of it—he has to take outside the camp to a place that is ceremonially clean, where the ashes are dumped, and he must burn it on a wood fire there on the ash heap. ");
INSERT INTO engfbv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","If the whole Israelite community goes astray unintentionally, and even though they are unaware of doing what is not permitted by any of the Lord's commandments, they are all still guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When they realize their sin, then they must bring a young bull as a sin offering and present it before the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders of Israel are to put their hands on its head and kill it before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Then the high priest shall take some of the bull's blood into the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","He shall dip his finger in the blood and sprinkle it seven times before the Lord in front of the veil. ");
INSERT INTO engfbv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He shall put some of the blood on the horns of the altar that stands before the Lord in the Tent of Meeting. Then he is to pour out the rest of the bull's blood at the bottom of the altar of burnt offering at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Then he shall remove all the fat from the bull and burn it on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He shall offer this bull in the same way he did for the sin offering. This is how the priest will make them right, and they will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Then he shall take the bull outside the camp and burn it, just as he burned the bull previously mentioned. It is the sin offering for the whole community. ");
INSERT INTO engfbv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","If a leader sins unintentionally and does what is not permitted by any of the commandments of the Lord his God, he is guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","When he realizes his sin, he must bring a male goat without defects as his offering. ");
INSERT INTO engfbv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He must put his hand on the head of the goat and kill it at the place where the burnt offering is killed before the Lord. It is a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Then the priest is to take some of the blood of the sin offering with his finger and put it on the horns of the altar of burnt offering, and pour out the rest of the blood at the bottom of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","He shall burn all its fat on the altar like the fat of the peace offerings. In this way the priest will make the man's sin right, and he will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","If any other Israelite sins unintentionally and does what is not permitted by any of the commandments of the Lord his God, he is guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","When he realizes his sin, he must bring a female goat without defects as his offering for that sin. ");
INSERT INTO engfbv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","He must put his hand on the head of the sin offering and kill it at the place of the burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Then the priest is to take some of its blood with his finger and put it on the horns of the altar of burnt offering, and pour out the rest of the blood at the bottom of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","He shall remove all its fat like the fat of the peace offerings and burn it on the altar and it will be accepted by the Lord. In this way the priest will make the man's sin right, and he will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","If he brings a lamb as a sin offering, he is to bring a female without defects. ");
INSERT INTO engfbv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","He must put his hand on the head of the sin offering and kill it as a sin offering at the place where the burnt offering is killed. ");
INSERT INTO engfbv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Then the priest is to take some of its blood with his finger and put it on the horns of the altar of burnt offering, and pour out the rest of the blood at the bottom of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","He shall remove all its fat like the fat of the lamb is removed from the peace offerings and burn it on the altar to be accepted by the Lord. In this way the priest will make the man's sin right, and he will be forgiven.” ");
INSERT INTO engfbv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“If you sin by not giving the evidence you have about a legal case, whether you saw something yourself or heard about it, you bear responsibility for your guilt. ");
INSERT INTO engfbv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","If you touch anything unclean such as the dead body of any unclean wild animal or farm animal or vermin, even if you're unaware of it, you become unclean and guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","If you touch something unclean from someone else who is unclean, even if you're unaware of it, you become guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","If you foolishly swear to do something (whether good or bad, and in whatever way people impulsively swear an oath), even if you're unaware of it being wrong, when you eventually realize it, you are guilty. ");
INSERT INTO engfbv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","If you become guilty in one of these ways, you must confess your sin, ");
INSERT INTO engfbv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","and you must take your guilt offering of a female lamb or goat to the Lord as a sin offering for your sin. The priest will make your sin right. ");
INSERT INTO engfbv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","If you can't afford a lamb, you may offer to the Lord as compensation for your sin two turtledoves or two young pigeons, one as a sin offering and one as a burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","You are to take them to the priest, who shall present the first one as the sin offering. He is to wring its head from the neck without removing it completely. ");
INSERT INTO engfbv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Then he is to sprinkle some of the blood of the sin offering on the side of the altar while the rest of the blood is poured out at the bottom of the altar. It is a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","The priest must then prepare the second bird as a burnt offering according to the regulations. In this way the priest will make you right for your sin, and you will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","If you can't afford two turtledoves or two young pigeons you may bring a tenth of an ephah of the best flour as a sin offering. Don't put olive oil or frankincense on it, because it is a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Take it to the priest, who shall take a handful as a ‘reminder part’ and burn it on the altar on top of the burnt offerings to the Lord. It is a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","This is how the priest will make right any of these sins you have committed, and you will be forgiven. The rest of the offering will belong to the priest, just like the grain offering.” ");
INSERT INTO engfbv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“If any of you neglects unintentionally anything that the Lord has declared belong to him and are holy, you must bring your guilt offering to the Lord: a ram without defects from your herd or the equivalent value in silver shekels (according to the sanctuary shekel standard). It is a guilt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","As regards any holy requirement you failed to contribute, you must pay compensation by adding a fifth of its value to it and then give it to the priest, who will make it right for you with the ram as a guilt offering, and you will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","If you sin and break any of the Lord's commandments, even if you are unaware of it, you are still guilty and bear responsibility for your guilt. ");
INSERT INTO engfbv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","You must take to the priest a ram without defects of the appropriate value from the flock as a guilt offering. Then the priest will make right for you the wrong you did in ignorance, and you will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","It is a guilt offering because you were guilty as far as the Lord was concerned.” ");
INSERT INTO engfbv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“If you sin against the Lord, breaking your commitment to him, then this is what must happen. You may have lied to your neighbor about something you entrusted to them, about some deposit paid, about something that was stolen, or maybe you were trying to cheat them. ");
INSERT INTO engfbv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","You may have found property someone lost, and you lied and made false statements about it, or you have sinned in other ways that people do in such situations. ");
INSERT INTO engfbv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","If you have sinned and become guilty you must return what you have stolen or cheated from your victims, the deposit you took, the lost property you found, ");
INSERT INTO engfbv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or anything else that must be given back that you lied about. You must pay full compensation plus a fifth of the value, and give it to the owner as soon as you accept that you are guilty of sin. ");
INSERT INTO engfbv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Then you must take to the priest your guilt offering for the Lord: a ram without defects of the appropriate value from the flock. ");
INSERT INTO engfbv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","This is how the priest will make you right before the Lord, and you will be forgiven whatever sins you may have done that you are guilty of.” ");
INSERT INTO engfbv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Give Aaron and his sons these instructions regarding the burnt offering. The burnt offering is to be left on the fireplace of the altar throughout night until morning, and the fire must be kept burning on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","The priest shall put on his linen clothes and underwear, and he shall take from the altar the greasy ashes of the burnt offering that the fire has burned up and set them down beside the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then he has to change his clothes, and take the ashes outside the camp to a place that's ceremonially clean. ");
INSERT INTO engfbv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire on the altar must be kept burning—don't let it go out. Each morning the priest is to add wood to the fire, carefully place the burnt offering on it, and burn the fat parts of the peace offerings on it. ");
INSERT INTO engfbv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","The fire must be kept burning on the altar continually—don't let it go out. ");
INSERT INTO engfbv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","These are the regulations for the grain offering: Aaron's sons are to present it before the Lord, in front of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","The priest shall remove a handful of the best flour mixed with olive oil, as well as all the frankincense from the grain offering, and burn the ‘reminder part’ on the altar to be to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","The rest is for Aaron and his sons to eat. It must be eaten without yeast in a holy place—the courtyard of the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","It must not be baked with yeast. I have provided it as their share of my food offerings. It is most holy, just like the sin offering and the guilt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Any of Aaron's male descendants may eat it. This is a permanent allowance from the food offerings to the Lord for future generations. Whatever touches them shall become holy.” ");
INSERT INTO engfbv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering that Aaron and his sons are to present to the Lord when they're anointed: a tenth of an ephah of the best flour as a usual grain offering, half in the morning and half in the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Cook it with olive oil on a griddle. Bring it well-kneaded and present it as a grain offering broken into pieces, to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","It is to be cooked by the priest who is one of Aaron's descendants and who is to be anointed to take his place. In this case since it is permanently allocated to the Lord, it must be burned completely. ");
INSERT INTO engfbv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every grain offering for a priest is to be burned completely. It must not be eaten.” ");
INSERT INTO engfbv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tell Aaron and his sons that these are the regulations for the sin offering. The sin offering is to be killed where the burnt offering is killed before the Lord, and it is most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers the sin offering is to eat it. It must be eaten without yeast in a holy place—the courtyard of the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Whatever touches it shall become holy and if any of the blood is splashed on clothing, you must wash it in a holy place. ");
INSERT INTO engfbv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","The clay pot used to boil the sin offering must be broken. If it's boiled in a bronze pot, the pot must be thoroughly cleaned and washed out with water. ");
INSERT INTO engfbv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Any male among the priests may eat it, it is most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But no sin offering may be eaten if its blood has been taken into the Tent of Meeting as a means to make things right in the Holy Place. In that case it must be burned.” ");
INSERT INTO engfbv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“These are the regulations for the guilt offering, it is most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","The guilt offering is to be killed where the burnt offering is killed, and the priest shall sprinkle its blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","All the fat from it shall be offered: the fat tail, the fat that covers the insides, ");
INSERT INTO engfbv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","both kidneys with the fat on them by the loins, and the best part of the liver, which the priest is to remove together with the kidneys. ");
INSERT INTO engfbv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","He shall burn them on the altar as a food offering to the Lord; it is a guilt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Any male among the priests may eat it. It must be eaten in a holy place, it is most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","The guilt offering is like the sin offering; the regulations are the same for both. The priest who presents the offering that ‘makes things right’ is to have it. ");
INSERT INTO engfbv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","In the case of ordinary burnt offerings, the priest shall have the animal's skin. ");
INSERT INTO engfbv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","In the same way all grain offerings that are baked in an oven or cooked in a pan or on a griddle is for the priest who presents it, ");
INSERT INTO engfbv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","and all grain offerings, whether they are mixed with olive oil or dry, they are for all of Aaron descendants. ");
INSERT INTO engfbv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","These are the regulations for the peace offering that you may present to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","If you offer it in a spirit of thanks, then along with the sacrifice of thanksgiving, you must offer bread, wafers, and well-kneaded cakes of the best flour all made without yeast and mixed or coated with olive oil. ");
INSERT INTO engfbv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","In addition to your peace offering of thanksgiving of breads made without yeast, you shall present an offering of breads made with yeast. ");
INSERT INTO engfbv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Present one of each kind of bread of the offering as a contribution to the Lord. It is for the priest who sprinkles the blood of the peace offering. ");
INSERT INTO engfbv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The meat of the sacrifice of your peace offering of thanksgiving must be eaten the same day you offer it. Don't leave any of it until the morning. ");
INSERT INTO engfbv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","If the sacrifice you're offering is to pay a vow or a freewill offering, it shall be eaten on the day you present your sacrifice, but what's left can be eaten the next day. ");
INSERT INTO engfbv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","However, any meat of the sacrifice still remaining on the third day must be burned. ");
INSERT INTO engfbv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If you eat any of the meat from your peace offering on the third day, it won't be accepted. You won't receive credit for offering it. In fact it will be treated as something disgusting, and anyone who eats it will bear responsibility for their guilt. ");
INSERT INTO engfbv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","If this meat touches anything unclean it must not be eaten; it must be burned. This meat may be eaten by those who are ceremonially clean. ");
INSERT INTO engfbv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","If anyone who is unclean eats meat from the peace offering given to the Lord, they must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Anyone who touches anything unclean, whether it's from a person, an unclean animal, or an unclean revolting thing, and then eats meat from the peace offering given to the Lord, they must be expelled from their people.” ");
INSERT INTO engfbv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Give these instructions to the Israelites. Tell them, ‘You must not eat any of the fat of a bull, a sheep, or a goat. ");
INSERT INTO engfbv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","You can use the fat of an animal found dead or killed by wild beasts for whatever purpose you want, but you must not eat it. ");
INSERT INTO engfbv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Anyone who eats the fat of an animal from a food offering presented to the Lord must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","You must not eat the blood of any bird or animal in any of your homes. ");
INSERT INTO engfbv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Anyone who eats blood must be expelled from their people.’” ");
INSERT INTO engfbv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Give these instructions to the Israelites. Tell them that if you present a peace offering to the Lord you must bring part of it as a special gift to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","You must personally bring the food offerings to the Lord; bring the fat as well as the breast, and wave the breast as a wave offering before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The priest shall burn the fat on the altar, but the breast is for Aaron and his sons. ");
INSERT INTO engfbv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Give the right thigh to the priest as a contribution from your peace offering. ");
INSERT INTO engfbv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","The priest as a descendant of Aaron who offers the blood and fat of the peace offering has the right thigh as his share. ");
INSERT INTO engfbv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","I have required from the Israelites the breast of the wave offering and the contribution of the thigh from their peace offerings, and I have given them to Aaron the priest and his sons as their share from the Israelites for all time.” ");
INSERT INTO engfbv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","This is the share of the food offerings given to the Lord that belongs to Aaron and his sons since the day they were appointed to serve the Lord as priests. ");
INSERT INTO engfbv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","From the time they were anointed, the Lord ordered that this be given them by the sons of Israel. It is their share for future generations. ");
INSERT INTO engfbv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","These are the regulations regarding the burnt offering, the grain offering, the sin offering, the guilt offering, the ordination offering, and the peace offering. ");
INSERT INTO engfbv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","The Lord gave these to Moses on Mount Sinai at the time he ordered the Israelites to give their offerings to him in the Wilderness of Sinai. ");
INSERT INTO engfbv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Go with Aaron and his sons, and take their priestly clothes, anointing oil, the bull of the sin offering, two rams, and the basket of bread made without yeast, ");
INSERT INTO engfbv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","and have everyone assemble at the entrance to the Tent of Meeting.” ");
INSERT INTO engfbv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses did as the Lord instructed him, and everyone gathered at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moses told them, “The following is what the Lord has ordered to be done.” ");
INSERT INTO engfbv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses had Aaron and his sons come forward, and he washed them with water. ");
INSERT INTO engfbv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","He dressed Aaron with the tunic, tied the sash around him, put the robe on him and then the ephod. He tied the waistband of the ephod around him, fastening it to him. ");
INSERT INTO engfbv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Then Moses attached the breastpiece to Aaron and put the Urim and Thummim in the breastpiece. ");
INSERT INTO engfbv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","He put the turban on Aaron's head and placed the gold plate, the holy crown, on the front of the turban, as the Lord had instructed him to do. ");
INSERT INTO engfbv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Then Moses took the anointing oil and anointed the Tabernacle and everything in it to dedicate it all. ");
INSERT INTO engfbv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He sprinkled some of the oil on the altar seven times to anoint it and all its utensils, as well as the basin with its stand to dedicate them. ");
INSERT INTO engfbv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Moses poured some of the anointing oil on Aaron's head to anoint him and to dedicate him. ");
INSERT INTO engfbv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Then Moses had Aaron's sons come forward. He dressed them in tunics, tied sashes around them, and wrapped headbands on them, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Moses brought the bull over for the sin offering, and Aaron and his sons put their hands on its head. ");
INSERT INTO engfbv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moses killed the bull and took some of the blood. He used his finger to put the blood on all four horns of the altar to dedicate it and purify it. He poured out the rest of the blood at the bottom of the altar, and consecrated the altar so that it could be used to make people right. ");
INSERT INTO engfbv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses took all the fat that covers the insides, the best part of the liver, both kidneys with the fat on them, burned all of it on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","But the rest of the bull—the skin, the meat, and the waste he burned outside the camp, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Moses brought the ram for the burnt offering, and Aaron and his sons put their hands on its head. ");
INSERT INTO engfbv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moses killed the ram and sprinkled the blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","He divided the ram into pieces and burned the head, the pieces, and the fat. ");
INSERT INTO engfbv_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","He washed the insides and legs with water and burned the whole ram on the altar as a burnt offering, a food offering to be accepted by the Lord, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Moses brought the second ram, the ram of ordination, and Aaron and his sons put their hands on its head. ");
INSERT INTO engfbv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moses killed the ram and took some of its blood. He put it on Aaron's right earlobe, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engfbv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Then Moses had Aaron and his sons come forward and put some of the blood on their right earlobes, on the thumbs of their right hands, and on the big toes of their right feet. Then he sprinkled blood on all sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Moses took the fat, including the fat tail, all the fat on the insides, the best part of the liver, both kidneys with the fat on them. Moses took the fat, together with the right thigh. ");
INSERT INTO engfbv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","He took one loaf of bread without yeast, one loaf made with olive oil, and one wafer from the basket of bread without yeast that was in the presence of the Lord. He placed them on top of the portions of fat and on the right thigh. ");
INSERT INTO engfbv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Then he gave them to Aaron and his sons, and waved them before the Lord as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","After this Moses took them back and burned them on the altar with the burnt offering. This was an ordination offering, a food offering to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses then took the breast, his share of the ordination ram, and waved it before the Lord as a wave offering, as the Lord had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses then took some of the anointing oil and some of the blood from the altar. He sprinkled them both on the clothes of Aaron and his sons. This is how he dedicated the clothes of Aaron and his sons. ");
INSERT INTO engfbv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moses told Aaron and his sons, “You are to boil the meat at the entrance to the Tent of Meeting, and then eat it there with the bread that is in the basket of offerings for the ordination, as I ordered: ‘It is for Aaron and his sons to eat.’ ");
INSERT INTO engfbv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Afterwards you must burn what's left over of the meat and bread. ");
INSERT INTO engfbv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","You are not to leave the entrance to the Tent of Meeting for seven days until the ordination ceremony is completed, because your ordination will take seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","What was done today was ordered by the Lord as a means of making you right. ");
INSERT INTO engfbv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You must stay at the entrance to the Tent of Meeting for seven days, day and night, and follow the Lord's commands so that you will not die, for this is what I have been ordered to do.” ");
INSERT INTO engfbv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron and his sons did everything that the Lord had ordered through Moses. ");
INSERT INTO engfbv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day after the ordination Moses called Aaron and his sons, and the elders of Israel, to meet with him. ");
INSERT INTO engfbv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","He told Aaron, “You need to bring a young bull as a sin offering and a ram as a burnt offering, both without defects, and present them before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Then tell the Israelites, ‘Bring the following offerings: a male goat as a sin offering; a calf and a lamb (both a year old and without defects), for a burnt offering; ");
INSERT INTO engfbv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","a bull and a ram as a peace offering to sacrifice before the Lord; and a grain offering mixed with olive oil. Do this because the Lord is going to reveal himself to you today.’” ");
INSERT INTO engfbv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Following Moses' orders they brought what he'd said to the front of the Tent of Meeting. Everyone came and stood before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moses said, “This is what the Lord ordered me to tell you to do, so that you may see his glory.” ");
INSERT INTO engfbv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Then Moses told Aaron, “Go to the altar and sacrifice your sin offering and your burnt offering to make you and the people right. Then sacrifice the offerings brought by the people as a means to make them right, as the Lord ordered.” ");
INSERT INTO engfbv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron went to the altar and killed the calf as a sin offering for himself. ");
INSERT INTO engfbv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","His sons brought the blood to him. He dipped his finger in the blood and put it on the horns of the altar. He poured out the rest of the blood at the bottom of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","He burned the fat, the kidneys, and the best part of the liver from the sin offering on the altar, as the Lord had ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","However, he burned up the meat and the skin outside the camp. ");
INSERT INTO engfbv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aaron killed the burnt offering. His sons brought him the blood, and he sprinkled it on the sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","They brought him the head and all the other pieces of the burnt offering, and he burned them on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He washed the insides and the legs and burned them with the rest of the burnt offering on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Then Aaron presented the offerings of the people. He killed the male goat as the sin offering for the people, and offered it in the same way as his own sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He presented the burnt offering, doing so in accordance with the regulations. ");
INSERT INTO engfbv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","He presented the grain offering. He took a handful from it and burned it on the altar, in addition to the burnt offering presented earlier that morning. ");
INSERT INTO engfbv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aaron killed the bull and the ram as the peace offering for the people. His sons brought him the blood, and he sprinkled it on the sides of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","They also brought him the fat portions from the bull, and from the ram—the fat tail, the fat covering the insides, the kidneys, and the best part of the liver— ");
INSERT INTO engfbv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","and put them on the breasts. Aaron burned the fat portions on the altar, ");
INSERT INTO engfbv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","but he waved the breasts and the right thigh as a wave offering before the Lord, as Moses had ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Then Aaron held up his hands towards the people and blessed them. After that he came down from the altar, having completed the sin offering, the burnt offering, and the peace offering. ");
INSERT INTO engfbv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron went into the Tent of Meeting. When they came out, they blessed the people, and the glory of the Lord was revealed to everyone. ");
INSERT INTO engfbv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Fire came from the presence of the Lord and burned up the burnt offering and the fat portions on the altar. When everyone saw this, they shouted for joy and fell down with their faces to the ground. ");
INSERT INTO engfbv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aaron's sons, Nadab and Abihu, set light to their incense burners using ordinary fire and put in incense, and in this way offered forbidden fire in the Lord's presence, something he had not authorized. ");
INSERT INTO engfbv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Fire came out from the Lord's presence and burned them up. They died in the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moses explained to Aaron, “This is what the Lord was talking about when he said: ‘I will show my holiness to those who approach me; I will reveal my glory so everyone can see.” But Aaron didn't reply. ");
INSERT INTO engfbv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moses called Mishael and Elzaphan, sons of Aaron's uncle Uzziel, and told them, “Come and carry away the bodies of your cousins and take them outside the camp, away from the front of the sanctuary.” ");
INSERT INTO engfbv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","They came and picked them up by their clothes, and took them outside the camp, as Moses had ordered. ");
INSERT INTO engfbv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses told Aaron and his sons Eleazar and Ithamar, “Don't leave your hair uncombed, and don't tear your clothes, otherwise you will die, and the Lord will be angry with everyone. But your relatives and all the other Israelites may mourn for those the Lord killed by fire. ");
INSERT INTO engfbv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Don't go outside the entrance to the Tent of Meeting, or you will die, because you have been anointed by the Lord.” They did what Moses said. ");
INSERT INTO engfbv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","The Lord told Aaron, ");
INSERT INTO engfbv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“You and your descendants must not drink wine or any other alcohol when you go in to the Tent of Meeting, otherwise you will die. This regulation is for all time and for all future generations. ");
INSERT INTO engfbv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","You must realize the difference between the holy and the ordinary, between clean and unclean, ");
INSERT INTO engfbv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","so you can teach the Israelites all the regulations that the Lord has given to them through Moses.” ");
INSERT INTO engfbv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moses told Aaron and his two sons who were left, Eleazar and Ithamar, “Take the grain offering that is left over from the food offerings given to the Lord and eat it without yeast beside the altar, because it is most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","You must eat it in a holy place, because it is the share for you and your descendants from the food offerings given to the Lord. This is what I have been ordered. ");
INSERT INTO engfbv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","You and your male and female descendants can eat the breast of the wave offering and the thigh contribution anywhere that is ceremonially clean, because you and your descendants have been given these as your share from the peace offerings of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The thigh contribution and the breast of the wave offering, as well as the fat portions of the food offerings made, they are to bring and wave as a wave offering before the Lord. They belong to you and your children forever as the Lord has ordered.” ");
INSERT INTO engfbv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moses checked what had happened to the goat of the sin offering, and found out that it had been burned. He got angry with Eleazar and Ithamar, the sons Aaron had left, and asked them, ");
INSERT INTO engfbv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why didn't you take the sin offering and eat it in the holy place, because it is most holy and it was given to you to take away the people's guilt by making them right before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","As its blood was not taken into the holy place, you should have eaten it in the sanctuary area, as I ordered.” ");
INSERT INTO engfbv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","So Aaron explained to Moses, “Look, it was today that they presented their sin offering and their burnt offering before the Lord. After all that's just happened to me, would the Lord have been pleased if I'd eaten the sin offering today?” ");
INSERT INTO engfbv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses heard what Aaron had to say, he accepted the explanation. ");
INSERT INTO engfbv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Give these instructions to the Israelites. These are the animals you are allowed to eat: ");
INSERT INTO engfbv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","any animal that both has a divided hoof and also chews the cud. ");
INSERT INTO engfbv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","However, if it either chews the cud, or has a divided hoof, then you may not eat it. These include: the camel, which though it chews the cud doesn't have a divided hoof, so it is unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","The rock hyrax, which though it chews the cud doesn't have a divided hoof, so it is unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","The hare, which though it chews the cud doesn't have a divided hoof, so it is unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","The pig, which though it has a divided hoof doesn't chew the cud, so it is unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","You are not to eat their meat or touch their dead bodies. They are unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","You are allowed to eat any creature with fins and scales that lives in the water, whether in the sea or in fresh water. ");
INSERT INTO engfbv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","But you are not allowed to eat any of the many creatures that don't have fins and scales that live in the water, whether in the sea or in fresh water. ");
INSERT INTO engfbv_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","They are repulsive. You must not eat their meat, and you must treat their dead bodies as repulsive. ");
INSERT INTO engfbv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","All such water creatures that don't have fins and scales are to be repulsive to you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","As for the birds, these must not be eaten because they are repulsive: eagle, griffon vulture, bearded vulture, ");
INSERT INTO engfbv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","buzzard, kite and similar birds of prey, ");
INSERT INTO engfbv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","any raven or crow, ");
INSERT INTO engfbv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","tawny owl, long-eared owl, gulls, any kind of hawk, ");
INSERT INTO engfbv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","little owl, fish owl, eagle owl, ");
INSERT INTO engfbv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","barn owl, desert owl, Egyptian vulture, ");
INSERT INTO engfbv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","storks and any kind of heron, hoopoe, and bats. ");
INSERT INTO engfbv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","All flying insects that crawl are repulsive to you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","But you can eat the following kinds of flying insects that crawl: those that have jointed legs they use to jump. ");
INSERT INTO engfbv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","So in this category you can eat any kind of locust, bald locust, cricket, or grasshopper. ");
INSERT INTO engfbv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","All other flying insects that crawl are repulsive to you, ");
INSERT INTO engfbv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","and will make you unclean. If you touch their dead bodies you will be unclean until the evening, ");
INSERT INTO engfbv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","and if you pick up one of their dead bodies you must wash your clothes, and you will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Every animal with hooves that are not divided, or that does not chew the cud, is unclean for you. If you touch any of them you will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Any four-legged animal that walks on its paws are unclean for you. If you touch their dead bodies you will be unclean until the evening, ");
INSERT INTO engfbv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","and if you pick up one of their dead bodies you must wash your clothes, and you will be unclean until the evening. They are unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","The following animals that run along the ground are unclean for you: rats, mice, any kind of large lizards, ");
INSERT INTO engfbv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geckos, monitor lizards, wall lizards, skinks, and chameleons. ");
INSERT INTO engfbv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","These animals that run along the ground are unclean for you. If you touch a dead one of them you will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Anything that one of them dies and lands on becomes unclean. Whatever it is—something made of wood, clothing, leather, sackcloth, or any work tool—it must be washed with water and will be unclean until the evening. Then it will become clean. ");
INSERT INTO engfbv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","If one of them falls into a clay pot, all that's in it becomes unclean. You must smash the pot. ");
INSERT INTO engfbv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","If water from that pot touches any food, that food becomes unclean, and any drink from a pot like that also becomes unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anything that one of their dead bodies falls on becomes unclean. If it's an oven or a stove, it must be smashed. It is permanently unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","On the other hand, if it's a spring or cistern containing water then it will remain clean, but if you touch one of these dead bodies in it you will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Similarly, if one of their dead bodies falls on any seed used for sowing, the seed remains clean; ");
INSERT INTO engfbv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","but if the seed has been soaked in water and one of their dead bodies falls on it, it is unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","If an animal that you are allowed to eat dies, anyone who touches the dead body will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","If you eat anything from the dead body you must wash your clothes and you will be unclean until the evening. If you pick up the dead body you must wash your clothes and you will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Every animal that crawls along the ground is repulsive—you must not eat it. ");
INSERT INTO engfbv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Don't eat any animal that crawls along the ground, whether it moves on its belly or walks on four feet or many feet. All such animals are repulsive. ");
INSERT INTO engfbv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Don't defile yourselves by any such crawling animal. Don't make yourselves unclean or defiled by them, ");
INSERT INTO engfbv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","because I am the Lord your God; so dedicate yourselves and be holy, because I am holy. Don't defile yourselves by any animal that crawls along the ground. ");
INSERT INTO engfbv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","I am the Lord who led you out of Egypt so that I could be your God. So be holy, because I am holy. ");
INSERT INTO engfbv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","These are the regulations about animals, birds, everything that lives in the water, and all animals that crawl along the ground. ");
INSERT INTO engfbv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","You must recognize the difference between unclean and clean, between those animals that can be eaten and those that can't.” ");
INSERT INTO engfbv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","The Lord told Moses, “Give these instructions to the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Any woman who becomes pregnant and has a boy, she will be unclean for one week, in the same way that she is unclean during her period. ");
INSERT INTO engfbv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","The boy's foreskin must be circumcised on the eighth day. ");
INSERT INTO engfbv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","The woman must wait a further thirty-three days for the purification of her bleeding. She is not allowed to touch anything holy, and she is not allowed to enter the sanctuary until her time of purification is finished. ");
INSERT INTO engfbv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","If a woman has a daughter, she will be unclean for two weeks, in the same way that she is unclean during her menstrual period. The woman must wait a further sixty-six days for the purification of her blood. ");
INSERT INTO engfbv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Once the time of purification is finished for either a son or a daughter, the woman must bring a year-old lamb as a burnt offering and a young pigeon or turtledove as a purification offering. She is to bring her offerings to the priest at the entrance of the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","The priest will then present them to the Lord to purify her so she will be clean from her bleeding. These are the regulations for a woman after she's had a son or a daughter. ");
INSERT INTO engfbv_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","If a woman can't afford to bring a lamb, she is to bring two turtledoves or two young pigeons. One is for the burnt offering and the other for the purification offering. The priest will offer them to purify her, and she will be clean.” ");
INSERT INTO engfbv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Anyone who has a swelling, a rash, or a spot on the skin that may be an infectious skin disease must be taken to Aaron the priest or to one of his descendants. ");
INSERT INTO engfbv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest will inspect whatever is on the skin. If the hair there has turned white and if the issue seems to be more than something on the surface, it is a serious skin disease, and the priest who inspects it will declare the person unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","But if the spot is only a white discoloration and doesn't seem to be more than superficial, and if the hair on the spot has not turned white, the priest will place the person in isolation for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","On the seventh day the priest will conduct another inspection, and if he discovers that the spot hasn't changed and hasn't spread on the skin, the priest must place the person in isolation for another seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","On the seventh day after this the priest will inspect it again. If the spot has faded and has not spread on the skin, the priest will declare the person clean since it was a rash. They must wash their clothes and will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","However, if the rash does spread after the person has been inspected by the priest and has been declared clean, the person must go back to be inspected again. ");
INSERT INTO engfbv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","If the priest discovers that the rash has spread, he must declare the person unclean because it is certainly a skin disease. ");
INSERT INTO engfbv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Anyone who develops an infectious skin disease must be taken to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","The priest will inspect them, and if there is a white swelling on the skin and the hair there has turned white, and there is an open wound in the swelling, ");
INSERT INTO engfbv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is a serious skin disease and the priest must declare them unclean. He doesn't need to place the person in isolation because they are unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","However, if the skin disease affects all their skin so that it covers their skin from head to toe, everywhere the priest can see, ");
INSERT INTO engfbv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","the priest shall inspect them, and if the disease has covered their entire body, he will declare the person clean. As it has all turned white, they are clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But if when someone's inspected an open wound is found, they will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","When the priest discovers an open wound, he must declare the person unclean. The open wound is unclean; it is an infectious skin disease. ");
INSERT INTO engfbv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","But if the open wound heals and becomes white, the person must go back to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest will inspect them again, and if the wound has turned white, the priest is to declare the person clean; then they are clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","When a boil comes up on someone's skin and then it heals, ");
INSERT INTO engfbv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","and a white swelling or a reddish-white spot appears in its place, they must show themselves to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest shall inspect it, and if it seems to be more than something on the surface, and if the hair there has turned white, the priest shall declare him unclean. It is a serious skin disease that has infected the boil. ");
INSERT INTO engfbv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","However, if when the priest inspects it, it doesn't have white hair in it and doesn't seem to be more than superficial, and has faded, the priest is to place the person in isolation for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If then the spot has spread further on the skin, the priest will declare them unclean; it is a disease. ");
INSERT INTO engfbv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the spot stays the same and doesn't spread, it's just the scar from the boil, and the priest will declare them clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","If someone has a burn on their skin and the place where it's raw changes into a reddish-white or white spot, ");
INSERT INTO engfbv_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","the priest must inspect it. If the hair in the spot has turned white and the spot seems to be more than something on the surface, it is a serious skin disease that has infected the burn, and the priest who inspects it will declare the person unclean. It is an infectious skin disease. ");
INSERT INTO engfbv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","However, if when the priest inspects it, it doesn't have white hair in it and doesn't seem to be more than superficial, and has faded, the priest is to place the person in isolation for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","On the seventh day the priest will inspect the person again. If then the spot has spread further on the skin, the priest will declare them unclean; it is a serious skin disease. ");
INSERT INTO engfbv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","But if the spot stays the same and hasn't spread on the skin, but has faded, it's the swelling from the burn, and the priest will declare them clean because it's just the scar from the burn. ");
INSERT INTO engfbv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","If someone, man or woman, has a sore on the head or chin, ");
INSERT INTO engfbv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","the priest shall inspect it, and if it appears to be more than superficial and the hair in it has become pale and thin, the priest must declare them unclean; it is an infection producing scabs, a serious disease of the head or chin. ");
INSERT INTO engfbv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","However, if the priest inspects the scabby infection and it doesn't seem to be more than superficial and has no pale hair in it, the priest is to place the person in isolation for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day the priest will inspect the person again and if the scabby infection has not spread and there is no pale hair in it, and it doesn't seem to be more than superficial, ");
INSERT INTO engfbv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","then the person must shave themselves except for the scaly area. The priest is to place the person in isolation for another seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day the priest will inspect the scabby infection, and if it has not spread on the skin and doesn't seem to be more than superficial, the priest is to pronounce the person clean. They must wash their clothes and will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","However, if the scabby infection has spread on the skin after having been declared clean, ");
INSERT INTO engfbv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","the priest must inspect them, and if the scabby infection has indeed spread on the skin, the priest doesn't need to check for pale hair; the person is unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if the priest sees that the scabby infection hasn't changed, and black hair has grown in it, then it has healed. The person is clean, and the priest must declare it. ");
INSERT INTO engfbv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","If someone, man or woman, has white spots on the skin, ");
INSERT INTO engfbv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","the priest shall inspect them, and if the spots appear a dull white, it's just a rash that has developed on the skin; the person is clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","If a man loses his hair and goes bald, he is still clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","If he has a receding hairline and he goes bald on his forehead, he is still clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if a reddish-white sore appears on his bald head or forehead, it is an infectious disease developing. ");
INSERT INTO engfbv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","The priest must inspect him, and if the swelling of the sore on his bald head or forehead looks reddish-white like a skin disease, ");
INSERT INTO engfbv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","then he has an infectious disease; he is unclean. The priest must declare him unclean because of the infection on his head. ");
INSERT INTO engfbv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Anyone who has such diseases must wear clothes that are torn and let their hair remain uncombed. They must cover their faces and shout out, ‘Unclean, unclean!’ ");
INSERT INTO engfbv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","They remain unclean as long as the infection lasts. They have to live alone somewhere outside the camp. ");
INSERT INTO engfbv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","The following regulations relate to any material that becomes affected by mold, such as wool or linen clothing, ");
INSERT INTO engfbv_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","anything woven or knitted made from linen or wool, or anything made of leather: ");
INSERT INTO engfbv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","If the spot is green or red on the material, whether it's leather, woven, or knitted or some other leather item, then it is infected with mold and must be shown to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest must inspect the mold and place the item in isolation for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","On the seventh day the priest shall inspect it again, and if the patch of mold has spread in the material, whether it's leather, woven, or knitted or some other leather item, then it is a harmful mold; the article is unclean, whatever it is being used for. ");
INSERT INTO engfbv_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","The priest is to burn it, whether the affected item is wool or linen or leather. Because the mold is harmful, the article must be burned. ");
INSERT INTO engfbv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","However, if when the priest inspects it again, the patch of mold has not spread, ");
INSERT INTO engfbv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","then the priest shall order that the affected item be washed and placed in isolation for another seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Once it has been washed, the priest is to inspect it again, and if the item with the mold hasn't changed how it looks, it is unclean. Though the mold hasn't spread, you must burn the item, whether the mold damage is on the inside or the outside. ");
INSERT INTO engfbv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","If the priest inspects it and the patch of mold has faded after it has been washed, he is to cut out the affected part of the material, whether it's leather, woven, or knitted. ");
INSERT INTO engfbv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","However, if the mold comes back then it is spreading. In that case you must burn the affected item. ");
INSERT INTO engfbv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","If the mold disappears after washing, then have it washed again, and it will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","These are the regulations regarding what needs to be done when mold contaminates wool or linen material, whether woven or knitted, or any leather item, as to declaring it clean or unclean.” ");
INSERT INTO engfbv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“These are the regulations regarding those who have had a skin disease when having been brought to the priest they are declared clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The priest must go outside the camp and inspect the person. If the skin disease has healed, ");
INSERT INTO engfbv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","the priest shall have two ceremonially clean birds brought to him, with some cedar wood, crimson thread, and hyssop, on behalf of the person to be made clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","The priest will order one of the birds to be killed over a clay pot filled with fresh water. ");
INSERT INTO engfbv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","He will take the live bird together with the cedar wood, crimson thread, and hyssop, and dip them in the blood of the bird that was killed over the fresh water. ");
INSERT INTO engfbv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","He will use the blood to sprinkle seven times the person being made clean of the skin disease. Then the priest will declare them clean and let the live bird fly away. ");
INSERT INTO engfbv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","The one being made clean must wash their clothes, shave off all their hair, and wash themselves with water; then they will be ceremonially clean. After that they can enter the camp, but they must stay outside their tent for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","On the seventh day they must shave off all their hair: their head, beard, eyebrows, and the rest of their hair. They must wash their clothes and wash themselves with water, and they will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","On the eighth day they are to bring two male lambs and one female lamb, all a year old and without defects; a grain offering consisting of three-tenths of an ephah of the best flour mixed with olive oil, and one ‘log’ of olive oil. ");
INSERT INTO engfbv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest who conducts the ceremony will present the person to be made clean to the Lord, along with these offerings, at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","The priest will take one of the male lambs and present it as a guilt offering, together with the log of olive oil; and he will wave them before the Lord as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Then he will kill the lamb near the sanctuary where the sin offering and burnt offering are killed. The sin offering and the guilt offering belong to the priest; they are most holy. ");
INSERT INTO engfbv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","The priest will put some of the blood from the guilt offering on their right earlobe, on their right thumb, and on the big toe of their right foot of the person being made clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","The priest will pour some of the log of olive oil into his left palm, ");
INSERT INTO engfbv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","dip his right index finger in it, and using his finger, sprinkle some of the olive oil seven times before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","The priest will then use some of the rest of the olive oil remaining in his palm on the person being made clean, and put it on top of the blood of the guilt offering. This will be on their right earlobe, on their right thumb, and on the big toe of their right foot, on top of the blood of the guilt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","What is left of the olive oil in his palm, the priest will put on the head of the person being made clean and then make them right before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","The priest will sacrifice the sin offering to make the person right, so that they are now clean from their uncleanness. After that, the priest will kill the burnt offering ");
INSERT INTO engfbv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","and offer it on the altar, together with the grain offering, to make them right, and they will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","But those who are poor and can't afford these offerings must bring one male lamb as a guilt offering to be waved to make them right, as well as a tenth an ephah of the best flour mixed with olive oil for a grain offering, a log of olive oil, ");
INSERT INTO engfbv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two turtledoves or two young pigeons, whichever they can afford. One is to be used as a sin offering and the other as a burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","On the eighth day they are to take them to the priest at the entrance to the Tent of Meeting before the Lord so they can be made clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest will take the lamb for the guilt offering, together with the log of olive oil, and wave them as a wave offering before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","After he kills the lamb for the guilt offering, the priest will take some of the blood of the guilt offering and put it on the right earlobe of the one being made clean, on their right thumb, and on the big toe of their right foot. ");
INSERT INTO engfbv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Then the priest will pour some of the olive oil into his left palm ");
INSERT INTO engfbv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","and using his right index finger, will sprinkle some of the oil from his left palm seven times before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","The priest shall also put some of the olive oil in his palm on the right earlobe of the person being made clean, on their right thumb, and on the big toe of their right foot, in the same places as the blood of the guilt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","What is left of the olive oil in his palm, the priest will put on the head of the person being made clean and then make them right before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Then they must sacrifice one of the turtledoves or young pigeons, whichever they can afford, ");
INSERT INTO engfbv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","one as a sin offering and the other as a burnt offering, along with the grain offering. This is how the priest will make the person right and clean before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","These are the regulations for those who have a skin disease and can't afford the usual offerings to make people clean.” ");
INSERT INTO engfbv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Then the Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“When you get to Canaan, the land I'm giving you to own, if I put some mold into a house there and contaminate it, ");
INSERT INTO engfbv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","the owner of the house must come and tell the priest, ‘It seems my house has something like mold.’ ");
INSERT INTO engfbv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","The priest must order the house to be emptied before he goes in to inspect the mold, so that nothing in the house will be declared unclean. Once that's done, the priest is to go in and inspect the house. ");
INSERT INTO engfbv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He will examine the house and see if the mold on the walls is made up of green or red indentations that go under the surface, ");
INSERT INTO engfbv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","the priest shall go out of the door and seal the house for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","On the seventh day the priest will return and inspect the house again. If the mold has spread on the walls, ");
INSERT INTO engfbv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","he will order the affected stones to be removed and disposed of in an unclean area outside the town. ");
INSERT INTO engfbv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Then he will order all the plaster inside of the house to be scraped off and dumped in an unclean area outside the town. ");
INSERT INTO engfbv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Different stones must be used to replace the ones removed, and new plaster will be needed to replaster the house. ");
INSERT INTO engfbv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","If the mold returns and affects the house again even after the stones have been removed and the house has been scraped and replastered, ");
INSERT INTO engfbv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","the priest must come and inspect it. If he sees the mold has spread in the house, it is a harmful mold; the house is unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","It must be demolished, and all its stones, timbers, and plaster must be taken and dumped in an unclean area outside the town. ");
INSERT INTO engfbv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Anyone who goes into the house during any time that it is sealed will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Anyone who sleeps or eats in the house must wash their clothes. ");
INSERT INTO engfbv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","However, if when the priest comes and inspects it and finds that the mold hasn't reappeared after the house was replastered, he shall declare the house clean because the mold is gone. ");
INSERT INTO engfbv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","He will bring two birds, cedar wood, crimson thread, and hyssop to make the house clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","He will kill one of the birds over a clay pot filled with fresh water. ");
INSERT INTO engfbv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","He will dip the live bird, the cedar wood, crimson thread, and hyssop, in the blood of the bird that was killed and the fresh water, and sprinkle the house seven times. ");
INSERT INTO engfbv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","He will make the house clean with the bird's blood, the fresh water, the live bird, the cedar wood, the hyssop, and the crimson thread. ");
INSERT INTO engfbv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Then he will let the live bird fly away outside the town. This is how he will make the house right, and it will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","These are the regulations for any infectious skin disease, for a scabby infection, ");
INSERT INTO engfbv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","for mold on clothing and in a house, ");
INSERT INTO engfbv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","as well as for a swelling, rash, or spot. ");
INSERT INTO engfbv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","They are used to decide whether something is clean or unclean. These are the regulations regarding skin diseases and mold.” ");
INSERT INTO engfbv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Tell the Israelites, When any man has a discharge from his genitals, the discharge is unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","The uncleanness comes from his discharge, whether his body allows it to flow out or blocks it. It makes him unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Any bed the man with the discharge lies on will be unclean, and anything he sits on will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Anyone who touches his bed has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Anyone who sits on whatever the man was sitting on has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Anyone who touches the man's body has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","If the man with the discharge spits on anyone who is clean, they have to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Whatever the man sits on when he's riding will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Anyone who touches whatever was under him will be unclean until the evening. Anyone who picks these things up has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","If the man with the discharge touches anyone without washing his hands with water first, the person who was touched has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Any clay item touched by the man must be broken, and any wooden item must be washed with water. ");
INSERT INTO engfbv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Once the discharge has healed, the man must allocate seven days for his cleaning process, wash his clothes, and wash himself in fresh water, and he will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","On the eighth day he must take two turtledoves or two young pigeons, come before the Lord at the entrance to the Tent of Meeting, and give them to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest will sacrifice them, one as a sin offering and the other as a burnt offering. This is how the priest will make the man right before the Lord because of his discharge. ");
INSERT INTO engfbv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","When a man has a release of semen, he must wash his whole body with water, and he will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Any clothing or leather that the release of semen falls on must be washed with water, and it will remain unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","If a man sleeps with a woman and there is a release of semen, both of them must wash with water, and they will remain unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","When a woman has a discharge of blood from her body, she will be unclean because of her period for seven days, and anyone who touches her will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Anything she lies or sits on during her period will be unclean, ");
INSERT INTO engfbv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","and anyone who touches her bed must wash their clothes and wash themselves with water, and will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Anyone who touches what she was sitting on has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Whether it's a bed or something she was sitting on, anyone who touches it will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","If a man sleeps with her and the blood from her period touches him, he will be unclean for seven days, and any bed he lies on will be unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","When a woman has a discharge of blood for several days when it's not the time for her period, or if it continues past her period, she will be unclean for the whole time she is bleeding, not just for the days of her period. ");
INSERT INTO engfbv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Any bed she lies on or anything she sits on while she has her discharge will be unclean, just as her bed is during her period. ");
INSERT INTO engfbv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Anyone who touches them has to wash their clothes, and wash themselves with water, and they will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Once the woman's discharge has healed, she must allocate seven days for her cleaning process, wash her clothes, and wash herself in fresh water, and she shall be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","On the eighth day she must take two turtledoves or two young pigeons, come before the Lord at the entrance to the Tent of Meeting, and give them to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","The priest will sacrifice them, one as a sin offering and the other as a burnt offering. This is how the priest will make her right before the Lord because of her discharge. ");
INSERT INTO engfbv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","This is how you must stop the Israelites from becoming ceremonially unclean, so that they don't die by making my Tabernacle unclean, the place where I live with them. ");
INSERT INTO engfbv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","These are the regulations regarding a man who has a discharge, a man who has a release of semen that makes him unclean, ");
INSERT INTO engfbv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","a woman during her period, any male or female who has a discharge, and a man who sleeps with an unclean woman.” ");
INSERT INTO engfbv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","The Lord spoke to Moses after the death of two of Aaron's sons when they went into the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","The Lord told Moses: “Warn your brother Aaron not to come into the Most Holy Place whenever he wants, otherwise he'll die. For that's where I appear in the cloud above the atonement cover of the Ark, behind the veil. ");
INSERT INTO engfbv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","These are the instructions as to how Aaron is to enter the sanctuary. He is to come with a young bull for a sin offering and a ram for a burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","He is to be wearing the holy linen tunic, with linen underwear. He has to tie a linen sash around him and put on the linen turban. These are holy clothes. He must wash himself with water before he puts them on. ");
INSERT INTO engfbv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","From the people of Israel he is to bring two male goats for a sin offering, and a ram for a burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron will present the bull as his own sin offering to make himself and his household right. ");
INSERT INTO engfbv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Then he will bring the two goats and present them before the Lord at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron will cast lots to choose between the goats, one for the Lord and the other for the scapegoat. ");
INSERT INTO engfbv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","He will present the goat that was chosen by lot for the Lord and sacrifice it as a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","The goat chosen by lot as the scapegoat is to be presented alive before the Lord to make things right by sending it away into the wilderness as the scapegoat. ");
INSERT INTO engfbv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron is to present the bull for his sin offering to make things right for himself and his household by killing the bull as his own sin offering. ");
INSERT INTO engfbv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Then he will fill up an incense burner with burning coals from the altar that is before the Lord, and with his hands full of finely ground sweet-smelling incense, take them behind the veil. ");
INSERT INTO engfbv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","In the presence of the Lord he will put the incense on the burning coals, and the smoke from the incense will cover the atonement cover above the Testimony, so that he will not die. ");
INSERT INTO engfbv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","He will take some of the bull's blood and with his finger sprinkle it on the east side of the atonement cover. He shall also sprinkle some of it with his finger seven times in front of the atonement cover. ");
INSERT INTO engfbv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Then Aaron will slaughter the goat for the sin offering for the people and bring its blood behind the veil, and with its blood he must do as he did with the bull's blood. He is to sprinkle it against the atonement cover and in front of it. ");
INSERT INTO engfbv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","This is how he will set right the Most Holy Place and purify it from the uncleanness of the Israelites, their acts of rebellion, and all their sins. He will do the same for the Tent of Meeting which is in the middle of their camp, surrounded by their unclean lives. ");
INSERT INTO engfbv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","No one can be in the Tent of Meeting from the time Aaron enters to purify the Most Holy Place until he leaves, after he has made things right for himself, his household, and all the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Then he shall go to the altar that is before the Lord and purify it. He is to take some of the blood from the bull and the goat and put it on all the horns of the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","He is to sprinkle some of the blood on it with his finger seven times to dedicate it and purify it from the uncleanness of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Once Aaron has finished purifying the Most Holy Place, the Tent of Meeting, and the altar, he is to present the live goat. ");
INSERT INTO engfbv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Then he will put both hands on the head of the live goat and confess over it all the wrongs of the Israelites, all their acts of rebellion, and all their sins. He is to put them on the goat's head and send it away into the desert, taken there by a man chosen to do it. ");
INSERT INTO engfbv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","The goat will take upon itself all their sins and go into a distant place, and the man will send it away into the desert. ");
INSERT INTO engfbv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aaron is to return to the Tent of Meeting, take off the linen clothes he put on before he went into the Most Holy Place, and leave them there. ");
INSERT INTO engfbv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","He is to wash himself with water in the sanctuary and put on his own clothes. Then he will go out and sacrifice his burnt offering and the people's burnt offering that makes him and the people right. ");
INSERT INTO engfbv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","He also must burn the fat of the sin offering on the altar. ");
INSERT INTO engfbv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","The man who went and sent away the scapegoat must wash his clothes and wash himself with water; then he may come back into the camp. ");
INSERT INTO engfbv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","The remains of the bull used for the sin offering and the goat for the sin offering, whose blood was brought into the Most Holy Place to purify it, must be taken outside the camp. Their skin, meat, and waste must be burned. ");
INSERT INTO engfbv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","The person who burns them must wash his clothes and wash himself with water; then he may come back into the camp. ");
INSERT INTO engfbv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","This regulation applies to you for all time. The tenth day of the seventh month is a day of self-denial for you. You are not to do any work. This applies to all who are native-born and also any foreigner who living among you, ");
INSERT INTO engfbv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","for on this day the process of making you right will be done, to make you clean from all your sins, clean before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","It is a Sabbath of Sabbaths, a day of rest and self-denial. This regulation applies for all time. ");
INSERT INTO engfbv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","The priest who is anointed and dedicated to succeed his father as high priest shall carry out the ceremony of making things right, and put on the holy linen clothes. ");
INSERT INTO engfbv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","He will carry out the purification of the Most Holy Place, the Tent of Meeting, and the altar, also making right the priests and all the people. ");
INSERT INTO engfbv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","This regulation applies to you for all time: once a year the Israelites have all their sins made right.” Moses did everything as the Lord had ordered. ");
INSERT INTO engfbv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Tell Aaron, his sons, and all the Israelites that this is what the Lord commands: ");
INSERT INTO engfbv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Any Israelite who kills a bull, a lamb, or a goat, whether inside the camp or outside of it, ");
INSERT INTO engfbv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","instead of bringing it to the entrance to the Tent of Meeting to present it as an offering to the Lord there, that person shall be held guilty of illegal killing. They have shed blood and must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","This is why the Israelites have to bring to the Lord the sacrifices they currently offer out in the fields. They must bring them to the priest at the entrance to the Tent of Meeting and offer them as peace offerings to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","The priest will sprinkle the blood on the altar of the Lord at the entrance to the Tent of Meeting, and burn the fat to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","They must not continue to offer their sacrifices to the goat devils with whom they have acted like prostitutes. This is a regulation for all time and for all future generations. ");
INSERT INTO engfbv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Warn them that any Israelite or any foreigner living among them who offers a burnt offering or a sacrifice ");
INSERT INTO engfbv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","without bringing it to the entrance to the Tent of Meeting to sacrifice it to the Lord must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","I will disown any Israelite or any foreigner living among them who eats any blood and I will expel them from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Life is in the body's blood. I have given it to you so that by putting it on the altar your lives can be made right, for it is the lifeblood that makes people's lives right. ");
INSERT INTO engfbv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","That's why I'm warning the Israelites: None of you is allowed to eat blood, and no foreigner living among you is allowed to eat blood. ");
INSERT INTO engfbv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Any Israelite or foreigner living among them who hunts and kills a wild animal or a bird which are allowed be eaten must drain the blood from its body and cover it with earth, ");
INSERT INTO engfbv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","for life is in the body's blood. That's why I have warned the Israelites: You are not allowed to eat the blood of anything living, for life is in the body's blood. Anyone who eats it must be expelled. ");
INSERT INTO engfbv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Anyone, Israelite or foreigner, who eats anything found dead or killed by wild animals must wash their clothes and wash with water, and they will be unclean until the evening. Then they will be clean. ");
INSERT INTO engfbv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","But if they don't wash their clothes and wash themselves with water, then they bear responsibility for their guilt.” ");
INSERT INTO engfbv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Tell the Israelites: I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Don't follow the ways of Egypt where you used to live, and don't follow the ways of Canaan where I'm going to take you. Don't adopt their practices. ");
INSERT INTO engfbv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Do what I tell you and keep my rules. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","If you keep my rules and do what I tell you, you will live. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Don't have sex with a close relative. ");
INSERT INTO engfbv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Don't shame your father by having sex with your mother. She is your mother; don't have sex with her. ");
INSERT INTO engfbv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Don't have sex with any of your father's wives and shame your father. ");
INSERT INTO engfbv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Don't have sex with your sister, whether she's your father's daughter or your mother's daughter, or whether she was born in the same house as you or somewhere else. ");
INSERT INTO engfbv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Don't have sex with your granddaughter, your son's daughter or your daughter's daughter, because that would be a shameful thing for you. ");
INSERT INTO engfbv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Don't have sex with the daughter of any of your father's wives or the daughter of your father. She is your sister. ");
INSERT INTO engfbv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Don't have sex with your father's sister. She is a close relative of your father. ");
INSERT INTO engfbv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Don't have sex with your mother's sister. She is a close relative of your mother. ");
INSERT INTO engfbv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Don't bring shame on your uncle by having sex with his wife. She is your aunt. ");
INSERT INTO engfbv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Don't have sex with your daughter-in-law. She is your son's wife. Don't have sex with her. ");
INSERT INTO engfbv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Don't have sex with your brother's wife and bring shame on your brother. ");
INSERT INTO engfbv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Don't have sex with both a woman and her daughter. Don't have sex with her son's daughter or her daughter's daughter. They are her close relatives. That is something I loathe. ");
INSERT INTO engfbv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Don't marry your wife's sister and have sex with her while your wife is still alive. They will be hostile wives to one other. ");
INSERT INTO engfbv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Don't have sex with a woman during the time she is unclean because of her period. ");
INSERT INTO engfbv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Don't commit any sex act with any other man's wife. This would pollute you and make you unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Don't give any of your children as a human sacrifice to Molech, for you must not disgrace the character of your God. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Don't have sex with a man as with a woman. That is something disgusting. ");
INSERT INTO engfbv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Don't have sex with any animal. This would pollute you and make you unclean. ");
INSERT INTO engfbv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","A woman must not give herself to an animal to have sex with it. That is something disgusting. Don't pollute yourselves and make yourselves unclean by doing anything like this. That's the reason I'm expelling these nations from the land—they polluted themselves because of all these practices. ");
INSERT INTO engfbv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Even the land has become polluted, so I am punishing it for the sins committed by the people who live there, and the land will vomit them out. ");
INSERT INTO engfbv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","You, however, must do what I tell you and keep my rules. You must not do any of these disgusting acts, whether an Israelite or a foreigner living among you. ");
INSERT INTO engfbv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","The people who lived in the land before you practiced all these disgusting things, and the land became polluted. ");
INSERT INTO engfbv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","If you pollute the land, it will vomit you out just like it did the nations before you. ");
INSERT INTO engfbv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Consequently anyone who does any of these disgusting things must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","You must accept my demand that you don't follow any of these disgusting practices done before you arrived. Don't pollute yourselves and make yourselves unclean. I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Tell all the Israelites: You must be holy because I am holy; I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Show respect for your mother and father, and keep my Sabbaths. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Don't turn to idols for help or make metal images of gods. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","When you sacrifice a peace offering to the Lord, make sure you do it correctly so God will accept you. ");
INSERT INTO engfbv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","It needs to be eaten the day you sacrifice it, or the next day. Whatever is left over on the third day must be burned. ");
INSERT INTO engfbv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","If you do eat some of it on the third day, the sacrifice becomes repulsive and won't be accepted. ");
INSERT INTO engfbv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Anyone who eats it will bear responsibility for their guilt, for they have made unclean what is holy to the Lord. They must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","When you harvest the crops grown on your land, don't harvest right up to the edges of your field, or collect what has been missed. ");
INSERT INTO engfbv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Don't take every last grape from your vineyard or pick up the ones that have fallen. Leave them for the poor people and foreigners. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Don't steal. Don't lie. Don't deceive each other. ");
INSERT INTO engfbv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Don't swear oaths in my name that are not true, otherwise you defame the character of your God. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Don't cheat others or rob them. Don't refuse to pay wages due to workers until the morning. ");
INSERT INTO engfbv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Don't speak badly about deaf people. Don't put objects in the way of blind people to trip them up. Instead show respect to your God. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Don't be a corrupt judge. Don't show favoritism to the poor or to the rich. Judge others fairly. ");
INSERT INTO engfbv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Don't go around spreading false rumors about people. Don't keep quiet when the lives of others are at risk. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Don't hold onto hateful feelings towards others. Talk honestly with your neighbors, so that you don't sin because of them. ");
INSERT INTO engfbv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Don't look for revenge or hold a grudge against anybody, but love your neighbor as yourself. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Do what I tell you! Don't make different kinds of livestock breed together. Don't sow your fields with two different kinds of seed. Don't wear clothes made of two different kinds of material. ");
INSERT INTO engfbv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","If a man has sex with a servant girl promised to become another man's wife, but who hasn't yet been bought or set free, then compensation has to be paid. However, they are not to be killed, because she hadn't been set free. ");
INSERT INTO engfbv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","But the man must bring a ram as his guilt offering to the Lord at the entrance of the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","The priest will set things right for him before the Lord using the ram of the guilt offering for the sin he has committed, and his sin will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","When you enter the land and plant any kind of fruit tree, treat the fruit at first as unclean. For three years you are forbidden to eat it. ");
INSERT INTO engfbv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","The fourth year all the fruit must be dedicated to the Lord as a praise offering. ");
INSERT INTO engfbv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","However, the fifth year you may eat the fruit and in this way you will have an even greater harvest. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Don't eat meat with blood in it. Don't use fortune-telling or witchcraft. ");
INSERT INTO engfbv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Don't cut your hair on the sides of your head or trim the sides of your beard, ");
INSERT INTO engfbv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","don't cut your bodies in some pagan ritual for the dead, and don't get yourselves tattoos. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Don't bring shame on your daughter by making her a prostitute, otherwise the land will become morally and spiritually depraved. ");
INSERT INTO engfbv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Keep my Sabbaths and show respect for my sanctuary. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Don't try and find help from mediums or spiritists—don't even go looking for them, otherwise they will corrupt you. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Stand up and be respectful of older people. Show reverence for your God. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Don't mistreat foreigners who live in your country. ");
INSERT INTO engfbv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Treat them in the same way as a fellow citizen, and love them as you love yourself, because you were once foreigners living in Egypt. I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Don't use dishonest weights and measures. ");
INSERT INTO engfbv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Make sure your scales and weights are accurate, that your measures of ephah and hin are correct. I am the Lord your God who led you out of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Keep all my rules and regulations, and make sure you follow them. I am the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Tell the Israelites: These regulations are for both Israelites and foreigners living among them. Anyone who sacrifices their children to Molech must be executed. The community must stone them to death. ");
INSERT INTO engfbv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I will disown them and expel them from their people, because by sacrificing their children to Molech they have polluted my sanctuary and disgraced my reputation. ");
INSERT INTO engfbv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","If the community decides to look the other way and not execute those who sacrifice their children to Molech, then I will take action against them myself. ");
INSERT INTO engfbv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","I will disown them and their family, and expel them from their people—and not just them, but everyone who follows them in spiritually prostituting themselves with Molech. ");
INSERT INTO engfbv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","I will also disown and expel from their people anyone who goes to mediums or spiritists and in this way commits spiritual prostitution with them. ");
INSERT INTO engfbv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","So dedicate yourselves and be holy, because I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Keep my rules and put them into practice. I am the Lord who makes you holy. ");
INSERT INTO engfbv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Anyone who curses their father or mother must be executed. They have cursed their father or mother; they bear the responsibility for their punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Any man who commits adultery with someone else's wife must be executed, as well as the woman. ");
INSERT INTO engfbv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","A man who has sex with his father's wife has brought shame on his father. Both the man and the woman must be executed. Both must surely be put to death; they bear the responsibility for their punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","A man who has sex with his daughter-in-law must be executed, as well as the woman. They have done something perverse; they bear the responsibility for their punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Men who have sex with other men as with a woman have done something disgusting. They must be executed; they bear the responsibility for their punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","A man who marries both a woman and her mother has acted perversely. They must all be burned to death so that there will be no such wickedness among you. ");
INSERT INTO engfbv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","A man who has sex with an animal must be executed, and the animal must be killed too. ");
INSERT INTO engfbv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","A woman who gives herself to an animal to have sex with it must be executed, along with the animal. They must both be killed; they bear the responsibility for their punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","A man who marries his sister, whether she's his father's daughter or his mother's daughter, and they have sex, has done something shameful. They must be expelled from their people in front of everybody. He has brought shame on his sister; he bears the responsibility for his punishment. ");
INSERT INTO engfbv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","A man who has sex with a woman having her period has exposed where her blood flow comes from, and she has too. They must both be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Don't have sex with your aunt, whether on your father's or your mother's side, because it brings shame on your own family. Both will bear responsibility for their sin. ");
INSERT INTO engfbv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","A man who has sex with his uncle's wife brings shame on his uncle. They will bear responsibility for their sin; they shall die without having children. ");
INSERT INTO engfbv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","A man who marries his brother's wife does something that is unclean. He has brought shame on his brother; the couple will have no children. ");
INSERT INTO engfbv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","So keep all my rules and regulations, so that the land where I'm taking you to live won't vomit you out. ");
INSERT INTO engfbv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Don't follow the practices of the nations I'm expelling for you. I detested them because they did all these evil things. ");
INSERT INTO engfbv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have promised you that you will take over their land. I'm going to give it to you to own, a land that flows with milk and honey. I am the Lord your God, who has made you a distinctive people different from all others. ");
INSERT INTO engfbv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","So make sure you observe the difference between clean and unclean animals and birds. Don't make yourselves unclean because of any animal or bird, or by anything that runs along the ground. I have made the difference clear: they are unclean for you. ");
INSERT INTO engfbv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","You shall be holy to me because I am holy. I am the Lord, and I have made you a distinctive people different from all other nations. You belong to me. ");
INSERT INTO engfbv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Anyone, man or woman, who is a medium or a spiritist must be executed. They are to be stoned to death; they bear the responsibility for their punishment.” ");
INSERT INTO engfbv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","The Lord told Moses, “Tell Aaron's sons, the priests: A priest is not to make himself unclean by touching the dead body of any of his relatives. ");
INSERT INTO engfbv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","The only exceptions are for his immediate family. This includes his mother, father, son, daughter, or brother, ");
INSERT INTO engfbv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","or his unmarried sister since she is a close relative because she doesn't have a husband. ");
INSERT INTO engfbv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","He must not make himself unclean for those only related to him by marriage—he is not to make himself ceremonially impure. ");
INSERT INTO engfbv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Priests are not to shave bald spots on their heads, trim the sides of their beards, or cut their bodies. ");
INSERT INTO engfbv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","They must be holy to their God and not disgrace their God's reputation. They are the ones who present the food offerings to the Lord, the food of their God. Consequently they must be holy. ");
INSERT INTO engfbv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","A priest is not to marry a woman made unclean through prostitution or who is divorced by her husband, for the priest must be holy to his God. ");
INSERT INTO engfbv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","You shall consider him holy because he presents the food offerings to your God. He shall be holy to you, because I am holy. I am the Lord, and I chose you as my special people. ");
INSERT INTO engfbv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","A priest's daughter who makes herself unclean through prostitution makes her father unclean. She must be executed by burning. ");
INSERT INTO engfbv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","The high priest has the highest place among the other priests. He has been anointed with olive oil poured on his head and has been ordained to wear the priestly clothing. He must not leave his hair uncombed or tear his clothes. ");
INSERT INTO engfbv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He is not to go near any dead body. He must not make himself unclean, even if it is for his own father or mother. ");
INSERT INTO engfbv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","He must not leave to deal with someone who has died or make the sanctuary of his God unclean because he has been dedicated by the anointing oil of his God. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","He can only marry a virgin. ");
INSERT INTO engfbv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He must not marry a widow, a divorced woman, or one made unclean through prostitution. He has to marry a virgin from his own people, ");
INSERT INTO engfbv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","so that he doesn't make his children unclean among his people, for I am the Lord who makes him holy.” ");
INSERT INTO engfbv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tell Aaron: These rules apply for all future generations. If any of your descendants has a physical defect, he is not allowed to come and present the food offerings of his God. ");
INSERT INTO engfbv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","No man is allowed to do this if he has any defects, including anyone who is blind, crippled, facially disfigured, or has deformities, ");
INSERT INTO engfbv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","anyone who has a broken foot or arm, ");
INSERT INTO engfbv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","anyone who is a hunchback or dwarf, or who has cataracts, skin sores or scabs, or a damaged testicle. ");
INSERT INTO engfbv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","No descendant of Aaron the priest who has a defect is allowed to come and present the food offerings to the Lord. Because he has a defect, he must not come and offer the food of his God. ");
INSERT INTO engfbv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He is still allowed to eat the food from the Most Holy Place of his God and also from the sanctuary, ");
INSERT INTO engfbv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","but because he has a defect, he is not allowed to go near the curtain or the altar, so that my sanctuary and everything in it are not made unclean, because I am the Lord who makes them holy.” ");
INSERT INTO engfbv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moses repeated this to Aaron and his sons, and to all the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons to be dedicated when dealing with the holy offerings that the Israelites have dedicated to me, so that they don't dishonor my holy character. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Tell them: These rules apply for all future generations. If any of your descendants in an unclean state comes close to the holy offerings that the Israelites dedicate to honor the Lord, that person must be expelled from my presence. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","If one of Aaron's descendants has a skin disease or a discharge, he is not allowed to eat the holy offerings until he is clean. Anyone who touches anything made unclean by a dead body or by a man who has had a release of semen, ");
INSERT INTO engfbv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","or anyone who touches an unclean animal or an unclean person (whatever the uncleanness is), ");
INSERT INTO engfbv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","anyone who touches anything like this will remain unclean until evening. He is not allowed to eat from the holy offerings unless he has washed himself with water. ");
INSERT INTO engfbv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","At sunset he will become clean, and then he is allowed to eat from the holy offerings because they provide his food. ");
INSERT INTO engfbv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","He must not eat anything that has died, or has been killed by wild animals, because that would make him unclean. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","The priests must do as I demand, so that they don't become guilty and die because they have not done so, treating my requirements with contempt. I am the Lord who makes them holy. ");
INSERT INTO engfbv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Anyone who isn't part of a priest's family is not allowed to eat the holy offerings. This also applies to a priest's guest or his paid worker. ");
INSERT INTO engfbv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","However, if a priest uses his own money to buy a slave, or if a slave is born in the priest's household, then that slave is allowed to eat his food. ");
INSERT INTO engfbv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","If the priest's daughter gets married to a man who isn't a priest, she is not allowed to eat the holy offerings. ");
INSERT INTO engfbv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","But if a priest's daughter without children is widowed or divorced and goes back to her father's house, she is allowed to eat her father's food as she did when she was growing up. But no one outside the priest's family can eat it. ");
INSERT INTO engfbv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Anyone who eats a holy offering by mistake must pay compensation by adding a fifth to its value, and give it all to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","The priests must not make the holy offerings the Israelites present to the Lord unclean ");
INSERT INTO engfbv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","by allowing the people to eat them and in so doing take upon themselves the punishment for guilt. For I am the Lord who makes them holy.” ");
INSERT INTO engfbv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Tell Aaron, his sons and all the Israelites: If you or a foreigner living with you wants to make a gift as a burnt offering to the Lord, whether it's to fulfill a promise or as a freewill offering, this is what you are to do. ");
INSERT INTO engfbv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","If it is to be accepted on your behalf you must offer a male without defects from the herds of cattle, sheep, or goats. ");
INSERT INTO engfbv_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Don't present anything with a defect because it won't be accepted on your behalf. ");
INSERT INTO engfbv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","If you want to present a peace offering to the Lord from the herd or flock to fulfill a promise or as a freewill offering, in order to be acceptable the animal must be perfect, completely without defects. ");
INSERT INTO engfbv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Don't present to the Lord an animal that is blind, injured, or damaged in some way, or has warts, skin sores, or scabs. Don't place any animal that has these on the altar as a food offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","However, you can present a freewill offering of a bull or sheep that has a leg that is too long or too short, but not if it is a sacrifice to fulfill a promise. ");
INSERT INTO engfbv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Don't present to the Lord an animal with testicles that are accidentally or deliberately damaged. You are not allowed to sacrifice any of these damaged animals in your land. ");
INSERT INTO engfbv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nor are you allowed to accept such animals from a foreigner that are damaged and defective.” ");
INSERT INTO engfbv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When a bull, a sheep, or a goat is born, it must stay with its mother for seven days. After eight days it can be accepted as a food offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","However, don't kill a bull or a sheep and its young on the same day. ");
INSERT INTO engfbv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","When you present a thank offering to the Lord, make sure to do so in a way that it will be accepted on your behalf. ");
INSERT INTO engfbv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","It has to be eaten on the same day. Don't leave any of it until morning. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Keep my rules and put them into practice. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Don't disgrace my holy character. I must be accepted as holy by you. I am the Lord who makes you holy. ");
INSERT INTO engfbv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","I am the one who led you out of Egypt to be your God. I am the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Tell the Israelites that these are my religious festivals, the festivals of the Lord that you are to call as the holy times when we meet together. ");
INSERT INTO engfbv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","You have six days to work, but the seventh day is a Sabbath of complete rest, a holy day of meeting together. Don't do any work. It is the Lord's Sabbath everywhere you live. ");
INSERT INTO engfbv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","These are the Lord's religious festivals, the holy meetings that you are to announce at their specific times. ");
INSERT INTO engfbv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","The Lord's Passover starts on the evening of the fourteenth day of the first month. ");
INSERT INTO engfbv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","The Lord's Festival of Unleavened Bread begins on the fifteenth day of the first month. For seven days the bread you eat must be made without yeast. ");
INSERT INTO engfbv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day you are to hold a holy meeting. You must not do any of your usual work. ");
INSERT INTO engfbv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","For seven days you shall present food offerings to the Lord. There is to be a holy meeting on the seventh day. You must not do any of your usual work.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Tell the Israelites that when you enter the land that I'm giving you and you harvest your crops, take a stack of grain from the firstfruits of your harvest to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","He will wave the stack of grain before the Lord so that it may be accepted on your behalf. The priest is to do this the day following the Sabbath. ");
INSERT INTO engfbv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","When you wave the stack of grain, you are to present a one-year-old lamb without defects as a burnt offering to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","together with its grain offering of two-tenths of an ephah of the best flour mixed with olive oil (a food offering to the Lord to be accepted by him) and its drink offering of a quarter of a hin of wine. ");
INSERT INTO engfbv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Don't eat any bread, roasted grain, or new grain until the time you bring this offering to your God. This regulation is for all time and for future generations everywhere you live. ");
INSERT INTO engfbv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Count seven full weeks from the day after the Sabbath—the day you brought the stack of grain as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Count fifty days until the day after the seventh Sabbath, and on that day present an offering of new grain to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bring two loaves of bread from your homes as a wave offering. Make them from two-tenths of an ephah of the best flour, baked with yeast, as the firstfruits to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","As well as the bread, present seven one-year-old male lambs without defects, one young bull, and two rams. They will be a burnt offering to the Lord, as well as their grain offerings and drink offerings, a food offering to the Lord to be accepted by him. ");
INSERT INTO engfbv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Present one male goat as a sin offering and two one-year-old male lambs as a peace offering. ");
INSERT INTO engfbv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","The priest will wave the lambs as a wave offering before the Lord, along with the bread of the firstfruits. The bread and the two lambs are holy to the Lord and belong to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","That same day you are to announce a holy meeting, and you must not do any of your usual work. This regulation is for all time and for future generations everywhere you live. ");
INSERT INTO engfbv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","When you harvest the crops grown on your land, don't harvest right up to the edges of your field, or collect what has been missed. Leave them for the poor people and foreigners. I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tell the Israelites that on the first day of the seventh month you are to have a special Sabbath of complete rest, a holy meeting that is announced by the sound of trumpets. ");
INSERT INTO engfbv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Don't do any of your usual work; instead you are to present a food offering to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“The Day of Atonement is on the tenth day of this seventh month. You are to have a holy meeting, deny yourselves, and present a food offering to the Lord ");
INSERT INTO engfbv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","On this day you must not do any of your usual work because it is the Day of Atonement, when things are made right for you before the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Anyone who does not practice self-denial on this day must be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","I will destroy anyone of you who does any work on this day. ");
INSERT INTO engfbv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Don't do any kind of work at all. This regulation is for all time and for future generations everywhere you live. ");
INSERT INTO engfbv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It is to be a Sabbath of complete rest for you, and you shall practice self-denial. You are to observe your Sabbath from the evening of the ninth day of the month until evening the next day.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tell the Israelites that the Feast of Tabernacles to honor the Lord begins on the fifteenth day of the seventh month and lasts for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","On the first day have a holy meeting. You must not do any of your usual work. ");
INSERT INTO engfbv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","For seven days you shall present food offerings to the Lord. On the eighth day you are to have another holy meeting and present a food offering to the Lord. It is a meeting for worship. You must not do any of your usual work. ");
INSERT INTO engfbv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","These are the Lord's holy festivals, which you are to announce as holy meetings for presenting food offerings to the Lord. These include burnt offerings, grain offerings, sacrifices and drink offerings, each according to the specific day. ");
INSERT INTO engfbv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","All of these offerings are in addition to those for the Lord's Sabbaths. They are also in addition to your gifts, to all your offerings to fulfill promises, and to all the freewill offerings you present to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","You shall celebrate a feast to honor the Lord for seven days on the fifteenth day of the seventh month, once you have harvested your crops. The first day and the eighth day are Sabbaths of complete rest. ");
INSERT INTO engfbv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day you are to gather branches from large trees, from palm trees, from leafy trees and of river willows, and celebrate before the Lord your God for seven days. ");
INSERT INTO engfbv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You are to hold this festival to honor the Lord for seven days every year. This regulation is for all time and for all future generations. ");
INSERT INTO engfbv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You are to live in temporary shelters for seven days. Every Israelite born in the country must live in shelters, ");
INSERT INTO engfbv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","so that your descendants will remember that I made the Israelites live in shelters when I led them out of Egypt. I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses told the Israelites all about the Lord's festivals. ");
INSERT INTO engfbv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Order the Israelites to bring you pure, pressed olive oil for the lamps, so they will always stay lit. ");
INSERT INTO engfbv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","From evening until morning Aaron is to constantly look after the lamps before the Lord, outside the veil of the Testimony in the Tent of Meeting. This regulation is for all time and for all future generations. ");
INSERT INTO engfbv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","He is to constantly look after the lamps placed on the pure gold lampstand before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Using the best flour bake twelve loaves, with two-tenths of an ephah of flour per loaf. ");
INSERT INTO engfbv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Place them in two piles, six in each pile, on the table made of pure gold that stands before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Place pure frankincense beside each pile to go with the bread to act as the ‘reminder part,’ a food offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day the bread shall be placed before the Lord, given by the Israelites as an ongoing sign of the eternal agreement. ");
INSERT INTO engfbv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","It is for Aaron and his descendants. They are to eat it in a holy place; for they must treat it as a most holy part of the food offerings given to the Lord. It is their share of the food offerings for all time.” ");
INSERT INTO engfbv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","One day a man who had an Israelite mother and an Egyptian father went into the Israelite camp and had a fight with an Israelite. ");
INSERT INTO engfbv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The Israelite woman's son cursed the name of the Lord. So they took him before Moses. (His mother's name was Shelomith, daughter of Dibri, from the tribe of Dan.) ");
INSERT INTO engfbv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","They detained him until it was clear what the Lord wanted them to do about it. ");
INSERT INTO engfbv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Take the man who cursed me outside the camp. Have all who heard him curse put their hands on his head; then have everyone stone him to death. ");
INSERT INTO engfbv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tell the Israelites that anyone who curses their God will be punished for their sin. ");
INSERT INTO engfbv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Anyone who curses the name of the Lord must be executed. All of you must stone them to death, whether they are a foreigner who lives with you or an Israelite. If they curse my name, they must be executed. ");
INSERT INTO engfbv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Anyone who kills someone else must be executed. ");
INSERT INTO engfbv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Anyone who kills an animal has to replace it—a life for a life. ");
INSERT INTO engfbv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","If anyone injures someone else, whatever they've done must be done to them: ");
INSERT INTO engfbv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","a broken bone for a broken bone, an eye for an eye, a tooth for a tooth. Whatever way they injured the victim, the same must be done to them. ");
INSERT INTO engfbv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Anyone who kills an animal has to replace it, but anyone who kills someone else must be executed. ");
INSERT INTO engfbv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","The same laws apply to foreigners who live with you as to Israelites, for I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moses told this to the Israelites, and they took the man who cursed the Lord outside the camp and stoned him to death. The Israelites did what the Lord ordered Moses to do. ");
INSERT INTO engfbv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","The Lord told Moses on Mount Sinai, ");
INSERT INTO engfbv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Tell the Israelites: When you enter the land that I'm giving you, the land itself must also observe a Sabbath rest in honor of the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Six years you can cultivate your fields, take care of your vineyards, and harvest your crops. ");
INSERT INTO engfbv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But the seventh year is to be a Sabbath of complete rest for the land, a Sabbath in honor of the Lord. Don't plant your fields or care for your vineyards. ");
INSERT INTO engfbv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Don't harvest what may have grown up in your fields, or collect the grapes from your vineyards that you haven't cared for. The land is to have a year of complete rest. ");
INSERT INTO engfbv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","You can eat whatever the land produces during the Sabbath year. This applies to yourself, your male and female slaves, paid workers and foreigners who live with you, ");
INSERT INTO engfbv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","and to your livestock and the wild animals living in your land. Whatever grows can be used for food. ");
INSERT INTO engfbv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Count seven ‘sabbaths’ of years, in other words, seven times seven years, so that the seven sabbaths of years come to forty-nine years. ");
INSERT INTO engfbv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Then blow the trumpet all through the country on the tenth day of the seventh month, which is the Day of Atonement. Make sure this signal is heard throughout your whole country. ");
INSERT INTO engfbv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","You are to dedicate the fiftieth year and announce freedom everywhere in the country for all who live there. This is to be your Jubilee, when each of you is to return to reclaim your property and to be part of your family once more. ");
INSERT INTO engfbv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","The fiftieth year will be a Jubilee for you. Don't sow the land; don't harvest what may have grown up in your fields, or collect the grapes from your vineyards that you haven't cared for. ");
INSERT INTO engfbv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","It is a Jubilee and it is to be holy to you. You can eat whatever the land produces. ");
INSERT INTO engfbv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In this Jubilee Year, every one of you shall return to your own property. ");
INSERT INTO engfbv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","If you sell land to your neighbor, or buy land from him, don't exploit one another. ");
INSERT INTO engfbv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","When you buy from your neighbor work out how many years have passed since the last Jubilee, for he is to sell to you depending on how many years of harvest remain. ");
INSERT INTO engfbv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","The more years that are left, the more you shall pay; the fewer years that are left, the less you shall pay, because he is actually selling you a specific number of harvests. ");
INSERT INTO engfbv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Don't exploit one another, but have respect for your God, because I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Keep my rules and observe my regulations, so you can live in safety in the land. ");
INSERT INTO engfbv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Then the land will produce good harvests, so you will have plenty to eat and live in safety there. ");
INSERT INTO engfbv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","But if you ask, ‘What are we going to do in the seventh year if we do not sow or harvest our crops?’ ");
INSERT INTO engfbv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I will bless you in the sixth year, so that the land will produce a crop that will be enough for three years. ");
INSERT INTO engfbv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","As you sow in the eighth year, you will still be eating from that harvest, which will last until your harvest in the ninth year. ");
INSERT INTO engfbv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Land must not be permanently sold, because it really belongs to me. To me you are only foreigners and travelers passing through. ");
INSERT INTO engfbv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","So whatever land you buy to own, you must make arrangements so it can be returned to its original owner. ");
INSERT INTO engfbv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If one of your people becomes poor and sells you some of their land, their close family can come and buy back what they have sold. ");
INSERT INTO engfbv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","However, if they don't have anyone who can buy it back, but in the meantime their financial situation improves and they have enough to buy back the land, ");
INSERT INTO engfbv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","they will work however many years it has been since the sale, and pay back the balance to the person who bought it, and go back to their property ");
INSERT INTO engfbv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","If they can't raise enough to pay the person back for the land, the buyer will remain its owner until the Jubilee Year. But in the Jubilee Year the land will be returned so that the original owners can go back to their property. ");
INSERT INTO engfbv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","If someone sells a house located in a walled town, they have the right to buy it back for a full year after selling it. It can be bought back any time during that year. ");
INSERT INTO engfbv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","If it isn't bought back by the end of a full year, then ownership of the house in the walled town is permanently transferred to the one who bought it and their descendants. It won't be returned in the Jubilee. ");
INSERT INTO engfbv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","But houses in villages that don't have walls around them are to be treated as located in the fields. They can be bought back, and will be returned in the Jubilee. ");
INSERT INTO engfbv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","However, the Levites always have the right to buy back their houses in the towns that belong to them. ");
INSERT INTO engfbv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Whatever the Levites own can be bought back, even houses sold in their towns, and must be returned in the Jubilee. That's because the houses in the towns of the Levites are what they were given to own as their share among the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","However, the fields surrounding their towns must not be sold because they belong to the Levites permanently. ");
INSERT INTO engfbv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","If any of your people become poor and can't survive, you must help them in the same way you would help a foreigner or a stranger, so that they can go on living in your neighborhood. ");
INSERT INTO engfbv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Don't make them pay you any interest or demand more than they borrowed, but respect your God so that they can remain living in your area. ");
INSERT INTO engfbv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Don't lend them silver with interest or sell them food at an inflated price. ");
INSERT INTO engfbv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Remember, I am the Lord your God who led you out of Egypt to give you the land of Canaan and to be your God. ");
INSERT INTO engfbv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","If any of your people become poor and have to sell themselves to work for you, don't force them to work as a slave. ");
INSERT INTO engfbv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Have them live with you like a paid worker who is staying with you for a while. They are to work for you until the Jubilee Year. ");
INSERT INTO engfbv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then they and their children must be freed, and they can go back to their family and to their family's property. ");
INSERT INTO engfbv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israelites are not to be sold as slaves because they belong to me as my slaves—I led them out of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Don't treat them with brutality. Have respect for your God. ");
INSERT INTO engfbv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Buy your male and female slaves from the surrounding nations. ");
INSERT INTO engfbv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","You can also buy them from foreigners who have come to live among you, or from their descendants born in your land. You can treat them as your property. ");
INSERT INTO engfbv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You can pass them on to your children to inherit as property after you die. You can make them slaves for life, but you must not brutally treat any of your own people, the Israelites, as a slave. ");
INSERT INTO engfbv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","If a foreigner among you becomes successful, and one of your people living nearby becomes poor and sells themselves to the foreigner or to a member of the foreigner's family, ");
INSERT INTO engfbv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","they still have the right of being bought back after the sale. A member of their family can buy them back— ");
INSERT INTO engfbv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","an uncle or cousin or any close relative from their family can buy them back. If they become successful, they can buy themselves back. ");
INSERT INTO engfbv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","The person concerned and their buyer will work out the time from the year of the sale up to the Jubilee Year. The price will depend on the number of years, calculated using the daily rate for a paid worker. ");
INSERT INTO engfbv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are many years left, they must pay a larger percentage of the purchase price. ");
INSERT INTO engfbv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If there are only a few years remaining before the Jubilee Year, then they only have to pay a percentage depending on the number of years still left. ");
INSERT INTO engfbv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","They are to live with their foreign owner just like a paid worker, hired from year to year, but see to it that the owner doesn't treat him brutally. ");
INSERT INTO engfbv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","If they are not bought back in any of the ways described, they and their children shall be freed in the Jubilee Year. ");
INSERT INTO engfbv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","For the Israelites belong to me as my slaves. They are my slaves—I led them out of Egypt. I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Don't make yourselves idols anywhere in your land and bow down to worship them, whether they are images or sacred pillars or stone sculptures. For I am the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Keep my Sabbaths and show respect for my sanctuary. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","If you follow my rules and keep my regulations, ");
INSERT INTO engfbv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","I will make sure it rains at the right time so that the ground will grow good crops and the fruit trees will be productive. ");
INSERT INTO engfbv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Your time of threshing will last right up to the grape harvest, and the grape harvest until the time you have to sow again. You will have more than enough to eat and you will live in safety in your land. ");
INSERT INTO engfbv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","I will make sure your land is at peace. You will be able to sleep without being afraid of anything. I will get rid of dangerous animals from the land, and you will not suffer from any violent enemy attacks. ");
INSERT INTO engfbv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","You will chase your enemies, and kill them with the sword. ");
INSERT INTO engfbv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will kill one hundred, and one hundred of you will kill ten thousand. You will destroy your enemies. ");
INSERT INTO engfbv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","I will come to help you, so you will reproduce and increase in numbers, and I will confirm my agreement with you. ");
INSERT INTO engfbv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You'll still be eating your old stock of grain when you need to get rid of it so you can store the new grain. ");
INSERT INTO engfbv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","I will come and live with you—I certainly won't reject you. ");
INSERT INTO engfbv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I shall always be right there with you. I will be your God, and you will be my people. ");
INSERT INTO engfbv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the Lord your God, who led you out of Egypt so you wouldn't have to be slaves to the Egyptians any longer. I smashed the yoke that kept you bent down and helped you to stand up straight. ");
INSERT INTO engfbv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","But if you don't pay attention to me and do what I tell you; ");
INSERT INTO engfbv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","if you reject my laws, hate my regulations, and refuse to follow my commandments, and consequently break my agreement, ");
INSERT INTO engfbv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","then this is what I am going to do to you: I will make you panic, and suffer from diseases like tuberculosis and fever that make you blind and drain your life away. It will be pointless for you to sow seed in your fields because your enemies will eat the harvest. ");
INSERT INTO engfbv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will turn against you, and you'll be defeated by your enemies. People who hate you will rule over you, and you'll run away even when there's no one chasing you! ");
INSERT INTO engfbv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","If after all this you still refuse to obey me, I will move to punishing you seven times over for your sins. ");
INSERT INTO engfbv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","I will break your self-reliant strength you're so proud of, and make your sky hard as iron and your land hard as bronze. ");
INSERT INTO engfbv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Your strength will be completely wasted because your land won't produce crops, and your trees won't produce fruit. ");
INSERT INTO engfbv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","If you go on opposing me and refusing to do what I tell you, I will make your punishments seven times worse, based on your sins. ");
INSERT INTO engfbv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send wild animals to kill your children, wipe out your livestock, and make you so few in number that there won't be anyone on your roads. ");
INSERT INTO engfbv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","However, if in spite of all this correction you still don't change but go on opposing me, ");
INSERT INTO engfbv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I will take action against you. I will punish you seven times over for your sins. ");
INSERT INTO engfbv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","I will send enemies with swords to attack you in retaliation for breaking the agreement. Even though you retreat into your towns for defense, I will plague you with disease, and you will be handed over to your enemies. ");
INSERT INTO engfbv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","I will send a famine so bread is in short supply. One oven will serve the needs of ten women baking bread. It will be distributed by weight so that you'll eat but won't have enough. ");
INSERT INTO engfbv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","However, if in spite of all this you don't obey me, but go on opposing me, ");
INSERT INTO engfbv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I will take action against you in a rage of fury, and I will punish you myself seven times over for your sins. ");
INSERT INTO engfbv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will eat the bodies of your own sons and daughters. ");
INSERT INTO engfbv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places of worship, smash your altars of incense, and pile up your dead bodies on what remains of your idols, which also have no life at all. I will really despise you. ");
INSERT INTO engfbv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will demolish your towns and destroy your pagan sanctuaries, and I will refuse to accept your sacrifices. ");
INSERT INTO engfbv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I will devastate your land myself, so that your enemies who come and live in it will be horrified at what has happened. ");
INSERT INTO engfbv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I'm going to scatter you among the nations. You will be chased out by armies with swords as your land is ruined and your towns are destroyed. ");
INSERT INTO engfbv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","At least then the land will be able to enjoy its Sabbaths all the time it's abandoned while you are in exile in the land of your enemies. The land will finally be able to rest and enjoy its Sabbaths. ");
INSERT INTO engfbv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","The whole time it's abandoned the land will observe the Sabbaths of rest that it wasn't able to do while you were living there. ");
INSERT INTO engfbv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","I will make those of you who survive so discouraged that as you live in the lands of your enemies even the sound of a leaf blowing in the wind will scare you into running away! You'll run away like you're being chased by someone with a sword, and fall down even though no one is after you. ");
INSERT INTO engfbv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","You'll trip over each other as you run away from the attack, even though no one's there. You'll have no power to resist your enemies. ");
INSERT INTO engfbv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You'll die in exile and you'll be buried in a foreign country. ");
INSERT INTO engfbv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Those of you who do manage to survive in the countries of your enemies will wither away because of their guilt, decaying as they share the sins of their fathers. ");
INSERT INTO engfbv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","They need to confess their sins and those of their fathers, acting in such an unfaithful way towards me, opposing me. ");
INSERT INTO engfbv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Because of this I took action against them and exiled them in the countries of their enemies. However, if they humbly give up their stubborn attitude and accept their punishment for their sins, ");
INSERT INTO engfbv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","then I will fulfill the agreement I made with Jacob, Isaac, and Abraham, and I will not forget my promise about the land. ");
INSERT INTO engfbv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","For the land will be left empty by them, and it will enjoy its Sabbaths being abandoned. They will pay for their sins, because they rejected my rules and regulations. ");
INSERT INTO engfbv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","But despite all this, even while they are living in land of their enemies, I will not reject or hate them so much as to destroy them and break my agreement with them, because I am the Lord their God. ");
INSERT INTO engfbv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Because of them I will renew the agreement I made with their fathers, those I led out of Egypt as the other nations watched, in order that I might be their God. I am the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the rules, regulations, and laws that the Lord set up between himself and the Israelites through Moses on Mount Sinai. ");
INSERT INTO engfbv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Tell the Israelites: When you make a special promise to dedicate someone to the Lord, these are the values you are to use. ");
INSERT INTO engfbv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","The value of a man aged twenty to sixty is fifty shekels of silver (using the sanctuary shekel standard). ");
INSERT INTO engfbv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","The value of a woman is thirty shekels. ");
INSERT INTO engfbv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","The value of someone aged five to twenty is twenty shekels for a male and ten shekels for a female. ");
INSERT INTO engfbv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","The value of someone aged one month to five years is five shekels of silver for a male and three shekels of silver for a female. ");
INSERT INTO engfbv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","The value of someone aged sixty or older is fifteen shekels for a male and ten shekels of silver for a female. ");
INSERT INTO engfbv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","However, if when you fulfill your promise you are poorer than the fixed value, you are to present the person before the priest, who will then set the value depending on what you can afford. ");
INSERT INTO engfbv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","If when you fulfill your promise you bring an animal that is permitted as an offering to the Lord, the animal given to the Lord shall be considered holy. ");
INSERT INTO engfbv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","You are not allowed to replace it or swap it, either for one that is better or one that is worse. However, if you do replace it then both animals become holy. ");
INSERT INTO engfbv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","If when you fulfill your promise you bring any unclean animal that is not permitted as an offering to the Lord, then you must show the animal to the priest. ");
INSERT INTO engfbv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","The priest will decide its value, whether high or low. Whatever value the priest places on it is final. ");
INSERT INTO engfbv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If you then decide to buy the animal back, you have to add one-fifth to its value in payment. ");
INSERT INTO engfbv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","If you dedicate your house as holy to the Lord, then the priest will decide its value, whether high or low. Whatever value the priest places on it remains final. ");
INSERT INTO engfbv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","But if you want to buy back your house, you have to add one-fifth to its value in payment. Then it will belong to you again. ");
INSERT INTO engfbv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","If you dedicate some of your land to the Lord, then its value shall be determined by the amount of seed required to sow it: fifty shekels of silver for every homer of barley seed used. ");
INSERT INTO engfbv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If you dedicate your field during the Jubilee Year, the value will be the full amount calculated. ");
INSERT INTO engfbv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if you dedicate your field after the Jubilee, the priest will work out the value depending on the number of years left until the next Jubilee Year, so reducing the value. ");
INSERT INTO engfbv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","But if you want to buy your field back, you have to add one-fifth to its value in payment. Then it will belong to you again. ");
INSERT INTO engfbv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","But if you don't buy the field back, or if you've already sold it to someone else, it can't ever be bought back. ");
INSERT INTO engfbv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","When the Jubilee comes, the field will become holy, in the same way as a field devoted to the Lord. It will become the property of the priests. ");
INSERT INTO engfbv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","If you dedicate to the Lord a field you've bought that was not part of your original property, ");
INSERT INTO engfbv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","the priest will work out the value until the next Jubilee Year. You will pay on that day the exact value, giving it as a holy offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","In the Jubilee Year, ownership of the field shall revert back to the person you bought it from—to the original owner of the land. ");
INSERT INTO engfbv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","(All values will use the sanctuary shekel standard of twenty gerahs to the shekel.) ");
INSERT INTO engfbv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","No one is allowed to dedicate the firstborn of the livestock, because the firstborn belongs to the Lord. Whether they are cattle, sheep, or goats, they are the Lord's. ");
INSERT INTO engfbv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","But if it is an unclean animal, then you can buy it back according to its value, adding on one-fifth extra. If it's not bought back, then it is to be sold according to its value. ");
INSERT INTO engfbv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Anything that you specially dedicate to the Lord from what you own, whether it's a person, an animal, or your land, can't be sold or bought back. Anything specially dedicated is most holy to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","No one who is specially dedicated to destruction can be bought back. They must be killed. ");
INSERT INTO engfbv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tithe from your crops or fruit belongs to the Lord; it is holy to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","If you want to buy back some of your tithe, you must add on one-fifth to its value. ");
INSERT INTO engfbv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","When you count your herds and flocks, every tenth animal that passes under the shepherd's rod is holy to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","You must not examine it to see if it's good or bad, and you must not replace it. However, if you do replace it then both animals become holy; they can't be bought back.” ");
INSERT INTO engfbv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the laws the Lord gave to Moses for the Israelites on Mount Sinai. ");
INSERT INTO engfbv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","The Lord spoke to Moses in the Tent of Meeting while they were in the Sinai desert. This was on the first day of the second month of the second year after the Israelites had left Egypt. He told him, ");
INSERT INTO engfbv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Census all the Israelites according to their tribe and family. Count every man and keep a record of each individual's name. ");
INSERT INTO engfbv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Those aged twenty or older who can do military service are to be registered by you and Aaron in their Israelite army divisions. ");
INSERT INTO engfbv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","A representative from each tribe, the head of a family, must be there with you. ");
INSERT INTO engfbv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of the men who will work with you: From the tribe of Reuben, Elizur, son of Shedeur; ");
INSERT INTO engfbv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","from the tribe of Simeon, Shelumiel, son of Zurishaddai; ");
INSERT INTO engfbv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","from the tribe of Judah, Nahshon, son of Amminadab; ");
INSERT INTO engfbv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","from the tribe of Issachar, Nethanel, son of Zuar; ");
INSERT INTO engfbv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","from the tribe of Zebulun, Eliab, son of Helon; ");
INSERT INTO engfbv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","from the sons of Joseph: from the tribe of Ephraim, Elishama, son of Ammihud, and from the tribe of Manasseh, Gamaliel, son of Pedahzur; ");
INSERT INTO engfbv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","from the tribe of Benjamin, Abidan, son of Gideoni; ");
INSERT INTO engfbv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","from the tribe of Dan, Ahiezer, son of Ammishaddai; ");
INSERT INTO engfbv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","from the tribe of Asher, Pagiel, son of Ocran; ");
INSERT INTO engfbv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","from the tribe of Gad, Eliasaph, son of Deuel; ");
INSERT INTO engfbv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","and from the tribe of Naphtali, Ahira, son of Enan.” ");
INSERT INTO engfbv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","These were the men chosen from the Israelite community. They were the leaders of their fathers' tribes; the heads of the families of Israel. ");
INSERT INTO engfbv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moses and Aaron summoned these men who had been selected by name. ");
INSERT INTO engfbv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","They had all the Israelites gather together on the first day of the second month, and recorded the people's genealogy according to their tribe and family, and counted up the names of all those aged twenty or older, ");
INSERT INTO engfbv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","as the Lord had told Moses to do. Moses conducted this census in the Sinai desert. ");
INSERT INTO engfbv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","The descendants of Reuben (he was Israel's firstborn son), men aged twenty or over, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","from the tribe of Reuben totaled 46,500. ");
INSERT INTO engfbv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","The descendants of Simeon, men aged twenty or over, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","from the tribe of Simeon totaled 59,300. ");
INSERT INTO engfbv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","The descendants of Gad, men aged twenty or over, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","from the tribe of Gad totaled 45,650. ");
INSERT INTO engfbv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","The descendants of Judah, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","from the tribe of Judah, totaled 74,600. ");
INSERT INTO engfbv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","The descendants of Issachar, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","from the tribe of Issachar, totaled 54,400. ");
INSERT INTO engfbv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","The descendants of Zebulun, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","from the tribe of Zebulun, totaled 57,400. ");
INSERT INTO engfbv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","The descendants of Joseph: the descendants of Ephraim, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","from the tribe of Ephraim, totaled 40,500. ");
INSERT INTO engfbv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","And the descendants of Manasseh, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","from the tribe of Manasseh, totaled 32,200. ");
INSERT INTO engfbv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","The descendants of Benjamin, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","from the tribe of Benjamin, totaled 35,400. ");
INSERT INTO engfbv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","The descendants of Dan, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","from the tribe of Dan, totaled 62,700. ");
INSERT INTO engfbv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","The descendants of Asher, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","from the tribe of Asher, totaled 41,500. ");
INSERT INTO engfbv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","The descendants of Naphtali, men aged twenty or older, were recorded by name according to the genealogical records of their tribe and families. All those registered who could serve in the army ");
INSERT INTO engfbv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","from the tribe of Naphtali, totaled 53,400. ");
INSERT INTO engfbv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","These were the totals of the men counted and registered by Moses and Aaron, with the help of the twelve leaders of Israel, who each represented their family. ");
INSERT INTO engfbv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","In this way all the Israelite men aged twenty or older who were able to serve in Israel's army were registered according to their families. ");
INSERT INTO engfbv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","The sum total of those registered was 603,550. ");
INSERT INTO engfbv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","However, the Levites were not registered with the others according to their tribe and families. ");
INSERT INTO engfbv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","This was because the Lord had told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Don't register the tribe of Levi; don't count them in the census with the other Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Put the Levites in charge of the Tabernacle and of the Testimony, as well as all its furniture and everything it contains. They are the ones responsible for carrying the Tabernacle and all its items. They are to care for it, and to make their camp around it. ");
INSERT INTO engfbv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","When it's time to move the Tabernacle, the Levites shall take it down, and when it's time to make camp, the Levites shall put it up. Any outsider who goes near it must be put to death. ");
INSERT INTO engfbv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The Israelites are to make camp according to their tribal divisions, each person in their own camp under their own flag. ");
INSERT INTO engfbv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","But the Levites are to set up their camp around the Tabernacle of the Testimony to prevent anyone from making me angry with the Israelites. The Levites are responsible for looking after the Tabernacle of the Testimony.” ");
INSERT INTO engfbv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","The Israelites did everything that the Lord ordered Moses that they should do. ");
INSERT INTO engfbv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“The Israelites are to set up their camp around the Tent of Meeting but some distance from it. Every member of each tribe will camp under their own flag and family banner. ");
INSERT INTO engfbv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","The tribal division of Judah is to camp under their flag on the east side. Their leader is Nahshon, son of Amminadab, ");
INSERT INTO engfbv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","and he has 74,600 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","The tribe of Issachar will camp next to them. Their leader is Nethanel, son of Zuar, ");
INSERT INTO engfbv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","and he has 54,400 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Next is the tribe of Zebulun. Their leader is Eliab, son of Helon, ");
INSERT INTO engfbv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","and he has 57,400 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","So the total number of men in the area of the camp of Judah is 186,400. When it's time to march out, they are the ones who will lead. ");
INSERT INTO engfbv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","The tribal division of Reuben is to camp under their flag on the south side. Their leader is Elizur, son of Shedeur, ");
INSERT INTO engfbv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","and he has 46,500 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","The tribe of Simeon will camp next to them. Their leader is Shelumiel, son of Zurishaddai, ");
INSERT INTO engfbv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","and he has 59,300 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Next is the tribe of Gad. Their leader is Eliasaph, son of Deuel, ");
INSERT INTO engfbv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","and he has 45,650 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","So the total number of men in the area of the camp of Reuben is 151,450. They shall march out in second place. ");
INSERT INTO engfbv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","The Tent of Meeting which stands at the center of the camp is to accompany the Levites. They are to march out in the same order as they set up camp, each in their rightful place under their flag. ");
INSERT INTO engfbv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","The tribal division of Ephraim is to camp under their flag on the west side. Their leader is Elishama, son of Ammihud, ");
INSERT INTO engfbv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","and he has 40,500 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","The tribe of Manasseh will camp next to them. Their leader is Gamaliel, son of Pedahzur, ");
INSERT INTO engfbv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","and he has 32,200 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Next is the tribe of Benjamin. Their leader is Abidan, son of Gideoni, ");
INSERT INTO engfbv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","and he has 35,400 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","So the total number of men in the area of the camp of Ephraim is 108,100. They shall march out in third place ");
INSERT INTO engfbv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","The tribal division of Dan is to camp under their flag on the north side. Their leader is Ahiezer, son of Ammishaddai, ");
INSERT INTO engfbv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","and he has 62,700 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","The tribe of Asher will camp next to them. Their leader is Pagiel, son of Ocran, ");
INSERT INTO engfbv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","and he has 41,500 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Next is the tribe of Naphtali. Their leader is Ahira son of Enan, ");
INSERT INTO engfbv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","and he has 53,400 men. ");
INSERT INTO engfbv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","So the total number of men in the area of the camp of Dan is 157,600;. They shall march out last, with their flags.” ");
INSERT INTO engfbv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","This sums up the registration of the Israelites, carried out by family. The final total of those counted in the camps by their tribal division was 603,550. ");
INSERT INTO engfbv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","However, the Levites were not counted among the other Israelites, following the Lord's instructions to Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","The Israelites did everything the Lord had ordered Moses. They set up their camps under their flags in their assigned positions, and marched out in the same order, each with their own tribe and family. ");
INSERT INTO engfbv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","This is the account concerning Aaron and Moses when the Lord spoke to Moses on Mount Sinai. ");
INSERT INTO engfbv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","The names of the sons of Aaron were: Nadab (firstborn), Abihu, Eleazar, and Ithamar. ");
INSERT INTO engfbv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These were the names of Aaron's sons who were anointed and ordained to serve as priests. ");
INSERT INTO engfbv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab and Abihu died in the Lord's presence when they offered forbidden fire before the Lord in the Sinai desert. Since they didn't have any sons, Eleazar and Ithamar served as priests while their father Aaron was alive. ");
INSERT INTO engfbv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Gather the tribe of Levi together and present them to Aaron the priest to help him with the ministry. ");
INSERT INTO engfbv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","They are to carry out duties on his behalf and for all the Israelites at the Tent of Meeting, looking after the service of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","They are responsible for caring for all the furniture of the Tent of Meeting, serving the Israelites through what they do in the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","The Levites are to work exclusively for Aaron and his sons because this is their assignment among the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","You are to appoint Aaron and his sons to have the responsibility of the priesthood. Anyone else who tries to act as a priest must be executed.” ");
INSERT INTO engfbv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“I've taken the Levites from the Israelites in place of every one of their firstborn. The Levites belong to me ");
INSERT INTO engfbv_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","because all the firstborn are mine. When I killed every firstborn in Egypt I set apart as holy to me all the firstborn of Israel, human and animal. They are mine. I am the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","The Lord spoke to Moses in the Sinai desert. He told him, ");
INSERT INTO engfbv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Register the Levites by their father's line and family. Count every male aged one month or older.” ");
INSERT INTO engfbv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses registered them following the Lord's instructions, just as he had been told. ");
INSERT INTO engfbv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","These were the names of Levi's sons: Gershon, Kohath, and Merari. ");
INSERT INTO engfbv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","These were the names of Gershon's sons by family: Libni and Shimei. ");
INSERT INTO engfbv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath's sons by family were Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engfbv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari's sons by family were Mahli and Mushi. These were the families of the Levites, according to their father's line. ");
INSERT INTO engfbv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","The family of Libni and the family of Shimei came from Gershon. These were the families of Gershon. ");
INSERT INTO engfbv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","The total of all males aged one month or older was 7,500. ");
INSERT INTO engfbv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The camp of families of Gershon was to the west, behind the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","The leader of the Gershon families was Eliasaph, son of Lael. ");
INSERT INTO engfbv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Their assigned responsibility for the Tent of Meeting was to take care of the Tabernacle and tent, its covering, the curtain at the entrance of the Tent of Meeting, ");
INSERT INTO engfbv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","the courtyard curtains, the curtain at the entrance to the courtyard surrounding the Tabernacle and altar, the ropes, and everything connected with their use. ");
INSERT INTO engfbv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","The families of Amram, Izhar, Hebron, and Uzziel came from Kohath. These were the families of Kohath. ");
INSERT INTO engfbv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","The total of all males aged one month or older was 8,600. Their assigned responsibility was to take care of the sanctuary. ");
INSERT INTO engfbv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The camp of families of Kohath was on the south side of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","The leader of the Kohath families was Elizaphan son of Uzziel. ");
INSERT INTO engfbv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Their assigned responsibility was to care for the Ark, the table, the lampstand, the altars, the articles of the sanctuary used with them, the veil, and everything connected with these items. ");
INSERT INTO engfbv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","The chief of the leaders of the Levites was Eleazar, son of Aaron the priest. He was in charge of those responsible for serving in the sanctuary. ");
INSERT INTO engfbv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","The family of Mahli and the family of Mushi came from Merari. These were the families of Merari. ");
INSERT INTO engfbv_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","The total of all males aged one month or older was 6,200. ");
INSERT INTO engfbv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","The leader of the Merari families was Zuriel, son of Abihail. Their camp was on the north side of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Their assigned responsibility was to take care of the Tabernacle's frames, crossbars, posts, stands, all its equipment, and everything connected with their use, ");
INSERT INTO engfbv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","as well as the posts of the surrounding courtyard with their stands, tent pegs, and ropes. ");
INSERT INTO engfbv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","The camp of Moses, Aaron, and Aaron's sons was to the east of the Tabernacle, in the direction of the sunrise, in front of the Tent of Meeting. They were responsible for the sanctuary on behalf of the Israelites. Anyone else who tried to act as a priest was to be executed. ");
INSERT INTO engfbv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","The sum total of Levites registered by Moses and Aaron as the Lord ordered was 22,000. This included all males aged one month or older. ");
INSERT INTO engfbv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","The Lord told Moses, “Conduct a census of all the firstborn Israelite males aged one month or older, and register their names. ");
INSERT INTO engfbv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Assign the Levites to me. I am the Lord. They are in place of all of the Israelites' firstborn children. The livestock of the Levites are in place of all the Israelites' firstborn livestock.” ");
INSERT INTO engfbv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moses conducted a census of all the firstborn of the Israelites, as the Lord had instructed him. ");
INSERT INTO engfbv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","The sum total of the firstborn males a month old or more, registered by name, was 22,273. ");
INSERT INTO engfbv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","The Lord spoke to Moses and told him, ");
INSERT INTO engfbv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“You are to take the Levites in place of all the firstborn children of Israel, and the livestock of the Levites in place of their livestock, because the Levites belong to me. I am the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","In order to buy back the 273 firstborn Israelites who are more than the number of Levites, ");
INSERT INTO engfbv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","collect five shekels for each of them (using the sanctuary shekel standard of twenty gerahs). ");
INSERT INTO engfbv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","He handed the money over to Aaron and his sons as the redemption price for the extra Israelites.” ");
INSERT INTO engfbv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moses collected the redemption money for those extra Israelites that were more than the number redeemed by the Levites. ");
INSERT INTO engfbv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","He collected the money given on behalf of the Israelites' firstborn children. It came to 1,365 shekels (using the sanctuary shekel standard). ");
INSERT INTO engfbv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moses gave this redemption money to Aaron and his sons as the Lord had told him to, following the Lord's instructions. ");
INSERT INTO engfbv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Register the descendants of Kohath from the tribe of Levi, according to their family and father's line. ");
INSERT INTO engfbv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Count men aged thirty to fifty—all who are entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","This work that they are to do in the Tent of Meetings involves the things that are most holy. ");
INSERT INTO engfbv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Whenever you move camp, Aaron and his sons will go in, take down the veil, and place it over the Ark of the Testimony. ");
INSERT INTO engfbv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","On top of this they are to put a fine leather covering, spread a cloth of solid blue over it, and then insert its carrying poles. ");
INSERT INTO engfbv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Have them spread a blue cloth over the table of the Presence as well, and put the plates and cups on it, as well as the bowls and jugs for the drink offering. The current bread offering is to stay on it. ");
INSERT INTO engfbv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Over everything they are to spread a crimson cloth, next a fine leather covering, and then insert its carrying poles. ");
INSERT INTO engfbv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Using a blue cloth, they are to cover the lampstand of light, together with its lamps, wick tongs, and trays, as well as the jars of olive oil used to fill them. ");
INSERT INTO engfbv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Then have them wrap it together with all its utensils inside a fine leather covering and place it on the carrying frame. ");
INSERT INTO engfbv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","They are to spread a blue cloth over the gold altar, cover it with fine leather, and then insert its carrying poles. ");
INSERT INTO engfbv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","They are to place all the utensils used for the service in the sanctuary in a blue cloth, cover them with fine leather, and place them on the carrying frame. ");
INSERT INTO engfbv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Have them clean the ashes from the bronze altar and spread a purple cloth over it, ");
INSERT INTO engfbv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","and put on it all the equipment used in the services on the altar: the firepans, meat forks, shovels, and sprinkling bowls. Spread over it a fine leather covering and then insert its carrying poles. ");
INSERT INTO engfbv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Once Aaron and his sons have finished covering these holy things and all the equipment connected with them, when the camp is ready to move, the priests of the Kohath family are to come and carry them. But they are forbidden to touch anything holy, otherwise they'll die. These are their responsibilities for moving the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleazar, son of Aaron the priest, is to supervise obtaining olive oil for the lamps, the aromatic incense, the daily grain offering, and the anointing oil. He is in charge of the whole Tabernacle and everything in it—all the holy things and equipment.” ");
INSERT INTO engfbv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Make sure the families of Kohath are not wiped out from the Levites. ");
INSERT INTO engfbv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","This is what you have to do so that they'll live and won't die by getting too close to something holy. Aaron and his sons must go in and tell each of them what they have to do and what they have to carry. ");
INSERT INTO engfbv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","But they must not go in and look at the things that are most holy, even for just a moment, otherwise they'll die.” ");
INSERT INTO engfbv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Register the descendants of Gershon, according to their family and father's line ");
INSERT INTO engfbv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Count men aged thirty to fifty—all who are entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","This is how the families of Gershon will serve in terms of working and carrying: ");
INSERT INTO engfbv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Have them carry the Tabernacle curtains, the Tent of Meeting with its fine leather covering, the curtains for the entrance to the Tent of Meeting, ");
INSERT INTO engfbv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","the courtyard curtains, the curtain at the entrance to the courtyard surrounding the Tabernacle and altar, the ropes, and everything connected with their use. The families of Gershon are responsible for everything required involving these items. ");
INSERT INTO engfbv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","All that they do is to be under the supervision of Aaron and his sons—all their work and carrying assignments. You are to tell them all they are required to carry. ");
INSERT INTO engfbv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","These are their responsibilities for moving the Tent of Meeting, carried out under the direction of Ithamar, son of Aaron the priest. ");
INSERT INTO engfbv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Register the descendants of Merari, according to their family and father's line. ");
INSERT INTO engfbv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Count men aged thirty to fifty—all who are entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","This is how they will serve in handling the Tent of Meeting: they are to carry the frames of the Tabernacle with its crossbars, posts, and stands, ");
INSERT INTO engfbv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","the posts of the surrounding courtyard with their stands, tent pegs, and ropes, all their equipment and everything connected with their use. You are to tell them by name what they are responsible for carrying. ");
INSERT INTO engfbv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","These are their responsibilities for all their work in moving the Tent of Meeting, carried out under the direction of Ithamar, son of Aaron the priest.” ");
INSERT INTO engfbv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moses, Aaron, and the Israelite leaders registered the families of Kohath according to their family and father's line. ");
INSERT INTO engfbv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","They counted men aged thirty to fifty—all who were entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","The total by families was 2,750. ");
INSERT INTO engfbv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","This was the total of the families of Kohath—all who were entitled to do the work of serving in the Tent of Meeting. Moses and Aaron registered them in accordance with the Lord's instructions to Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","The families of Gershon were counted, according to their family and father's line, ");
INSERT INTO engfbv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","men aged thirty to fifty—all who were entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","The total by families and father's line was 2,630. ");
INSERT INTO engfbv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","This was the total of the families of Gershon —all who were entitled to do the work of serving in the Tent of Meeting. They were registered by Moses and Aaron in accordance with the Lord's instructions. ");
INSERT INTO engfbv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","The families of Merari were counted, according to their family and father's line, ");
INSERT INTO engfbv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","men aged thirty to fifty—all who were entitled to do the work of serving in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","The total by families was 3,200. ");
INSERT INTO engfbv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","This was the total of the families of Merari registered by Moses and Aaron in accordance with the Lord's instructions. ");
INSERT INTO engfbv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","This is how Moses, Aaron, and the Israelite leaders registered all the Levites according to their family and father's line. ");
INSERT INTO engfbv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","They counted men aged thirty to fifty—all who were entitled to do the work of serving in the Tent of Meeting and carrying it. ");
INSERT INTO engfbv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","The sum total was 8,580. ");
INSERT INTO engfbv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","It was in response to the Lord's instructions that they were registered by Moses. Each of those registered were told what to do and what to carry, as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Order the Israelites to expel from the camp anyone who has a skin disease, or who has a discharge, or who is unclean from touching a dead body. ");
INSERT INTO engfbv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Whether male or female, you must expel them so they won't make their camp unclean, for that is where I live with them.” ");
INSERT INTO engfbv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","The Israelites followed these instructions, and expelled such people from the camp. They did what the Lord had told Moses they should do. ");
INSERT INTO engfbv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tell the Israelites that when a man or woman is unfaithful to the Lord by sinning against someone else, they are guilty ");
INSERT INTO engfbv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","and must confess their sin. They have to pay the full amount of compensation plus one-fifth of its value, and give this to the person they have wronged. ");
INSERT INTO engfbv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","However, if that person doesn't have a relative who can be paid the compensation, it belongs to the Lord and shall be given to the priest, together with a sacrificial ram by which the guilty person is set right. ");
INSERT INTO engfbv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","All holy offerings that the Israelites bring to the priest belong to him. ");
INSERT INTO engfbv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Your holy offerings belong to you, but once you give them to the priest they belong to him.” ");
INSERT INTO engfbv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Tell the Israelites that these are the instructions to follow if a man's wife has an affair, being unfaithful to him ");
INSERT INTO engfbv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","by sleeping with someone else. It may be that her husband doesn't find out and her unclean act wasn't witnessed—she wasn't caught out. ");
INSERT INTO engfbv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","But if her husband becomes jealous and suspicious of his wife, whether she's guilty or not, ");
INSERT INTO engfbv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","he is to take her before the priest. He is also to take with him on her behalf an offering of one tenth of an ephath of barley flour. He must also bring for her an offering of an ephath of barley flour. He's not to pour olive oil over it or put frankincense on it, since it's a grain offering for jealousy, a reminder offering to remind people about sin. ");
INSERT INTO engfbv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","The priest is to lead the wife forward and have her stand before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Then he shall fill a clay jar with holy water in a clay jar and sprinkle on it some dust from the floor of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Once the priest has had the woman stand before the Lord, he shall let her hair loose and have her hold the reminder grain offering—the grain offering used in cases of jealousy. The priest shall hold the bitter water that curses. ");
INSERT INTO engfbv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","He shall place the woman under oath and tell her, ‘If no one else has slept with you and you have not been unfaithful and become unclean while married to your husband, may you not be harmed by this bitter water that curses. ");
INSERT INTO engfbv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have been unfaithful while married to your husband and have become unclean and have had sex with someone else…’” ");
INSERT INTO engfbv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(Here the priest shall place the woman under the oath of the curse as follows.) “May the Lord place a curse on you that everyone knows about by having your thighs shrink and your belly swell up. ");
INSERT INTO engfbv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","May this water that curses go into your stomach and make your belly swell up and your thighs shrink. The woman is to answer, ‘I agree, I agree.’ ");
INSERT INTO engfbv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","The priest is to write these curses on a scroll and then wash them off into the bitter water. ");
INSERT INTO engfbv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","He shall make the woman drink the bitter water that curses, and it will cause her bitter pain if she is guilty. ");
INSERT INTO engfbv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","The priest shall take back from her the grain offering for jealousy, wave it before the Lord, and take it to the altar. ");
INSERT INTO engfbv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Then the priest shall take a handful of the grain offering as a reminder portion and burn it on the altar, and make the woman drink the water. ");
INSERT INTO engfbv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","After he has made her drink the water, if she has made herself unclean and has been unfaithful to her husband, then the water that curses will cause her bitter pain. Her belly will swell up and her thighs will shrink. She will become a cursed woman among her people. ");
INSERT INTO engfbv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman has not made herself unclean by being unfaithful and is clean, she will not experience this punishment and she will still be able to have children. ");
INSERT INTO engfbv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","This is the rule to follow in cases of jealousy when a wife has an affair and makes herself unclean while married to her husband, ");
INSERT INTO engfbv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","or when a husband starts feeling jealous and becomes suspicious of his wife. He shall have his wife stand before the Lord, and the priest is to carry out every part of this rule. ");
INSERT INTO engfbv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","If she is found guilty, her husband will not be held responsible. But the woman will bear the consequences of her sin.” ");
INSERT INTO engfbv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Tell the Israelites: If a man or a woman makes a special promise to become a Nazirite, to dedicate themselves to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","they must not drink any wine or other alcoholic drink. They must not even drink vinegar made from wine or other alcoholic drink, or any grape juice or eat grapes or raisins. ");
INSERT INTO engfbv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","The whole time they are dedicated to the Lord they must not eat anything from a grapevine, not even grape seeds or skins. ");
INSERT INTO engfbv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","They must not use a razor on their heads during the whole time of this promise of dedication. They must remain holy until their time of dedication to the Lord is finished. They must let their hair grow long. ");
INSERT INTO engfbv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","During this time of dedication to the Lord they must not go near a dead body. ");
INSERT INTO engfbv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Even if it's their father, mother, brother or sister who has died, they are not to make themselves unclean, because their uncut hair announces their dedication to God. ");
INSERT INTO engfbv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Through the whole time of their dedication they are to be holy to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","However, if someone dies suddenly close to them, making them unclean, they must wait seven days, and on the seventh day when they are made clean again they are to shave their heads. ");
INSERT INTO engfbv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","On the eighth day they shall take two turtledoves or two young pigeons to the priest at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","The priest will offer one as a sin offering and the other as a burnt offering to make them right, because they became guilty by being near the dead body. On that day they must re-dedicate themselves and let their hair grow again. ");
INSERT INTO engfbv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","They must re-dedicate themselves to the Lord for the full time they originally promised and bring a one-year-old male lamb as a guilt offering. The previous days don't count towards the time of dedication because they became unclean. ");
INSERT INTO engfbv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","These are the rules to be observed when the Nazirite's time of dedication is finished. They are to be taken to the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","There they are to present an offering to the Lord of a one-year-old male lamb without defects as a burnt offering, a one-year-old female lamb without defects as a sin offering, and a ram without defects as a peace offering. ");
INSERT INTO engfbv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","In addition they are to bring a basket of bread without yeast made from the best flour mixed with olive oil and wafers without yeast coated with olive oil as well as their grain offerings and drink offerings. ");
INSERT INTO engfbv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","The priest will present all these before the Lord as well as sacrificing the sin offering and the burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","He will also sacrifice a ram as a peace offering to the Lord, together with the basket of bread made without yeast. In addition the priest will present the grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Then the Nazirites are to shave their heads at the entrance to the Tent of Meeting. They shall take the hair from their heads that were dedicated, and place it on the fire under the peace offering. ");
INSERT INTO engfbv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Once the Nazirites have shaved, the priest will take the boiled shoulder from the ram, one bread without yeast from the basket, and one wafer without yeast, and place them in their hands. ");
INSERT INTO engfbv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","The priest will wave them as a wave offering before the Lord. These items are holy and belong to the priest, as well as the breast of the wave offering and the thigh that was offered. Once this is finished, Nazirites may drink wine. ");
INSERT INTO engfbv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","These are the rules to be observed when a Nazirite promises to give offerings to the Lord regarding their dedication. They can also bring additional offerings if they can afford it. Every Nazirite must fulfill whatever promises they have made when they dedicated themselves.” ");
INSERT INTO engfbv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tell Aaron and his sons: This is how you are to bless the Israelites. This is what they are to say: ");
INSERT INTO engfbv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘May the Lord bless you and take care of you. ");
INSERT INTO engfbv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","May the Lord smile on you and be gracious to you. ");
INSERT INTO engfbv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","May the Lord watch over you and give you peace.’ ");
INSERT INTO engfbv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Whenever the priests bless the Israelites in my name, I will bless them.” ");
INSERT INTO engfbv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","On the same day that Moses finished putting up the Tabernacle, he anointed it and dedicated it, along with all its furniture, the altar, and all its utensils. ");
INSERT INTO engfbv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","The Israelite leaders who were the heads of their families came and gave an offering. They were the same leaders of the tribes who had worked on the registration of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","They brought to the Lord an offering of six covered wagons and twelve oxen. Each leader gave an ox, and two leaders shared in giving a wagon. They presented them in front of the Tabernacle. ");
INSERT INTO engfbv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept what they're giving you and use them in the work of the Tent of Meeting. Give them to the Levites to use as required.” ");
INSERT INTO engfbv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moses accepted the wagons and oxen and handed them over to the Levites. ");
INSERT INTO engfbv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave two wagons and four oxen to the families of Gershon to use as they required. ");
INSERT INTO engfbv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","He gave four wagons and eight oxen to the families of Merari, to use as they required. The work was all to be done under the direction of Ithamar, son of Aaron the priest. ");
INSERT INTO engfbv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","He didn't give any wagons or oxen to the Kohathites because their responsibility was to carry on their shoulders the holy objects assigned to their care. ");
INSERT INTO engfbv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","The day the altar was anointed, the leaders came forward with their dedicatory offerings, presenting them in front of it. ");
INSERT INTO engfbv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","The Lord told Moses, “Have one leader come every day and present his offering for the dedication of the altar.” ");
INSERT INTO engfbv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","The first day Nahshon, son of Amminadab, of the tribe of Judah came forward with his offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","His offering was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Nahshon, son of Amminadab. ");
INSERT INTO engfbv_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","The second day Nethanel, son of Zuar, the leader of the tribe of Issachar, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Nethanel, son of Zuar. ");
INSERT INTO engfbv_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","The third day Eliab, son of Helon, the leader of the tribe of Zebulun, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Eliab, son of Helon. ");
INSERT INTO engfbv_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","The fourth day Elizur, son of Shedeur, the leader of the tribe of Reuben, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Elizur, son of Shedeur. ");
INSERT INTO engfbv_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","The fifth day Shelumiel, son of Zurishaddai, the leader of the tribe of Simeon, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Shelumiel, son of Zurishaddai. ");
INSERT INTO engfbv_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","The sixth day Eliasaph, son of Deuel, the leader of the tribe of Gad, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Eliasaph, son of Deuel. ");
INSERT INTO engfbv_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","The seventh day Elishama, son of Ammihud, the leader of the tribe of Ephraim, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Elishama, son of Ammihud. ");
INSERT INTO engfbv_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","The eighth day Gamaliel, son of Pedahzur, the leader of the tribe of Manasseh, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Gamaliel, son of Pedahzur. ");
INSERT INTO engfbv_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","The ninth day Abidan, son of Gideoni, the leader of the tribe of Benjamin, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Abidan, son of Gideoni. ");
INSERT INTO engfbv_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","The tenth day Ahiezer, son of Ammishaddai, the leader of the tribe of Dan, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Ahiezer, son of Ammishaddai. ");
INSERT INTO engfbv_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","The eleventh day Pagiel, son of Ocran, the leader of the tribe of Asher, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Pagiel, son of Ocran. ");
INSERT INTO engfbv_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","The twelfth day Ahira, son of Enan, the leader of the tribe of Naphtali, came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","The offering he presented was a silver plate that weighed a hundred and thirty shekels, and a silver bowl that weighed seventy shekels (using the sanctuary shekel standard). They were both filled with the best flour mixed with olive oil as a grain offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","He also presented a gold dish that weighed ten shekels filled with incense. As sacrifices he brought ");
INSERT INTO engfbv_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","a young bull, a ram, and a one-year-old male lamb as a burnt offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","a male goat as a sin offering, ");
INSERT INTO engfbv_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","and a peace offering of two oxen, five rams, five male goats, and five one-year-old male lambs. This was the offering of Ahira, son of Enan. ");
INSERT INTO engfbv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","So on the day the altar was anointed, the dedicatory offerings brought by the Israelite leaders were twelve silver plates, twelve silver bowls, and twelve gold dishes. ");
INSERT INTO engfbv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each silver platter weighed a hundred and thirty shekels, and each bowl weighed seventy shekels. The total weight of the silver was two thousand four hundred shekels (using the sanctuary shekel standard). ");
INSERT INTO engfbv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The twelve gold dishes filled with incense each weighed ten shekels (using the sanctuary shekel standard). The total weight of the gold was a hundred and twenty shekels. ");
INSERT INTO engfbv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","The animals presented as a burnt offering were twelve bulls, twelve rams, and twelve one-year-old male lambs, as well as their grain offerings, and twelve male goats as the sin offering. ");
INSERT INTO engfbv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","The animals presented as a peace offering were twenty-four bulls, sixty rams, sixty male goats, and sixty one-year-old male lambs. This was the dedicatory offering for the altar once it had been anointed. ");
INSERT INTO engfbv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Whenever Moses went into the Tent of Meeting to speak with the Lord, he would hear the voice speaking to him from the atonement cover on the Ark of the Testimony between the two cherubim. This is how the Lord spoke to him. ");
INSERT INTO engfbv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Tell Aaron, ‘When you place the seven lamps on the lampstand, make sure they shine towards the front.’” ");
INSERT INTO engfbv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","So that's what Aaron did. He placed the lamps facing towards the front of the lampstand, as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","The lampstand was made of hammered gold from its base to the flower decorations on the top, in accordance with the design that the Lord had shown Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Separate the Levites from the other Israelites and purify them. ");
INSERT INTO engfbv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","This is how you will purify them. Sprinkle on them the water of purification. They are to shave off all the hair from their bodies and wash their clothes so they will be clean. ");
INSERT INTO engfbv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Have them bring a young bull with its grain offering of the best flour mixed with olive oil, and you are to bring a second young bull as a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Take the Levites and have them stand in front of the Tent of Meeting and have all the Israelites gather there. ");
INSERT INTO engfbv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","When you bring the Levites to the Lord the Israelites are to place their hands upon them. ");
INSERT INTO engfbv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron shall present the Levites to the Lord as a wave offering from the Israelites so that they can do the Lord's work. ");
INSERT INTO engfbv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","The Levites are to place their hands on the heads of the bulls. One is to be sacrificed as a sin offering to the Lord, and the other as a burnt offering to set the Levites right with the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Have the Levites stand in front of Aaron and his sons and present them to the Lord as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","This is how you are to separate the Levites from the rest of the Israelites, and the Levites will belong to me. ");
INSERT INTO engfbv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","They can come and serve at the Tent of Meeting once you've purified them and presented them as a wave offering. ");
INSERT INTO engfbv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","The Levites have been completely given over to me by the Israelites. I have accepted them as mine in place of all the firstborn sons of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Every firstborn male in Israel belongs to me, both human and animal. I reserved them for myself at the time when I killed all the firstborn in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","I have taken the Levites in place of all the firstborn sons of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Of all the Israelites, the Levites are a gift from me to Aaron and his sons to serve the Israelites at the Tent of Meeting, and on their behalf to set them right, so that nothing bad will happen to them when they come to the sanctuary.” ");
INSERT INTO engfbv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moses, Aaron, and all the Israelites did everything that the Lord had ordered Moses that they should do regarding the Levites. ");
INSERT INTO engfbv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites purified themselves and washed their clothes. Then Aaron presented them as a wave offering to the Lord. Aaron also presented the sacrifice to make them right with the Lord so they would be clean. ");
INSERT INTO engfbv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Afterwards the Levites came to perform their service at the Tent of Meeting under the direction of Aaron and his sons. They followed all the instructions regarding the Levites that the Lord had given to Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“This rule applies to the Levites. Those twenty-five or older shall serve at the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","However, once they reach the age of fifty they need to retire from the work and won't serve any longer. ");
INSERT INTO engfbv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","They can still help their fellow Levites in their assignments, but they are not to do the actual work themselves. These are the arrangements in the case of the Levites.” ");
INSERT INTO engfbv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","The Lord spoke to Moses in the Sinai desert in the first month of the second year after Israel had left Egypt. He told him, ");
INSERT INTO engfbv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“The Israelites are to keep the Passover at its designated time. ");
INSERT INTO engfbv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Observe it at the time required—in the evening after sunset on the fourteenth day of this month, and do so in accordance with its rules and regulations.” ");
INSERT INTO engfbv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moses told the Israelites to observe the Passover. ");
INSERT INTO engfbv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","So they kept the Passover in the Sinai desert, beginning in the evening after sunset on the fourteenth day of the first month. The Israelites followed all the instructions the Lord had given to Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","However, there were some men who were unclean because they had been in contact with a dead body, so they could not keep the Passover on that day. They went to see Moses and Aaron the same day, ");
INSERT INTO engfbv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","and explained to Moses, “We are unclean because of a dead body, but why should that mean we're prevented from giving our offering to the Lord with the other Israelites at the appropriate time?” ");
INSERT INTO engfbv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","“Stay here while I find out what the Lord's instructions are concerning you,” Moses responded. ");
INSERT INTO engfbv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tell the Israelites: ‘If you or your descendants are unclean because of a dead body, or are away traveling, you can still keep the Lord's Passover. ");
INSERT INTO engfbv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","You are to observe it in the evening after sunset on the fourteenth day of the second month. You are to eat the lamb with the bread made without yeast, and the bitter herbs. ");
INSERT INTO engfbv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","You must not leave any of it until the following morning and you must not break any of its bones. You must observe the Passover according to all the regulations. ");
INSERT INTO engfbv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","However, anyone ceremonially clean and not away traveling who neglects to observe the Passover must be expelled from their people, because they didn't present the Lord's offering at the appropriate time. They will bear the responsibility for the consequences of their sin. ");
INSERT INTO engfbv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Any foreigners living among you who want to observe the Lord's Passover can do so following the Passover rules and regulations. The same rules apply to the foreigners as they do to you.’” ");
INSERT INTO engfbv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","The cloud covered the Tent of the Testimony (the Tabernacle) on the day that it was set up, and looked like fire above it from evening until the morning. ");
INSERT INTO engfbv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","It was always like this. The cloud covered the Tabernacle during the day and at night it looked like fire. ");
INSERT INTO engfbv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","When the cloud rose from over the Tent, the Israelites would move on, and where the cloud stopped, the Israelites would set up camp there. ");
INSERT INTO engfbv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","The Israelites moved on when the Lord told them to, and set up camp when the Lord told them to. While the cloud stayed over the Tabernacle, they remained camped there. ");
INSERT INTO engfbv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Even if the cloud didn't move for a long time, the Israelites did what the Lord told them and didn't move on. ");
INSERT INTO engfbv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud only stayed over the Tabernacle for a few days. As always they followed the Lord's command as to whether to camp or to move on. ");
INSERT INTO engfbv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud only stayed overnight, so when it rose in the morning they would move on. Whenever the cloud rose, day or night, they would leave. ");
INSERT INTO engfbv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","If the cloud stayed in one place for two days, or a month, or longer, the Israelites stayed where they were and didn't leave as long as the cloud remained over the Tabernacle. However, once it rose, they would leave. ");
INSERT INTO engfbv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","They camped when the Lord told them to, and left when he told them to. They followed the Lord's instructions that he gave to Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two trumpets out of hammered silver. They are to be used for summoning the Israelites and to have the camp move out. ");
INSERT INTO engfbv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","When both trumpets are blown, all the Israelites are to gather before you at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","But if only one is blown, then only the tribal leaders are to gather before you. ");
INSERT INTO engfbv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","When you blow the trumpet loudly, which is the alarm signal to move out, the camps on the east side are to march out first. ");
INSERT INTO engfbv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","When you blow the trumpet loudly the second time, the camps on the south side are to march out. That's their signal to start moving. ");
INSERT INTO engfbv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","To summon the people, blow the trumpets normally, not the loud alarm signal. ");
INSERT INTO engfbv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaron's descendants are to blow the trumpets. This regulation is for all time and for all future generations. ");
INSERT INTO engfbv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","When you're in your own land and have to go into battle against an enemy who has attacked you, blow the alarm signal and the Lord your God won't forget you—he will save you from your enemies. ");
INSERT INTO engfbv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Blow the trumpets when you celebrate too, at your regular feasts and at the beginning of each month. This is when you give your burnt offerings and fellowship offerings which act as a reminder for you before your God. I am the Lord your God.” ");
INSERT INTO engfbv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","The cloud rose up from the Tabernacle of the Testimony on the twentieth day of the second month of the second year. ");
INSERT INTO engfbv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","The Israelites left the Desert of Sinai and moved from place to place until the cloud stopped in the Desert of Paran. ");
INSERT INTO engfbv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","This was the first time they moved out following the Lord's command through Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","The tribal divisions of Judah went first, marching out under their flag, with Nahshon, son of Amminadab, in charge. ");
INSERT INTO engfbv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethanel, son of Zuar, was in charge of the tribal division of Issachar, ");
INSERT INTO engfbv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","and Eliab, son of Helon, was in charge of the tribal division of Zebulun. ");
INSERT INTO engfbv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then the Tabernacle was dismantled, and the Gershonites and the Merarites set off, carrying it. ");
INSERT INTO engfbv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Then came the divisions of Reuben who marched out under their flag, with Elizur, son of Shedeur, in charge. ");
INSERT INTO engfbv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumiel, son of Zurishaddai, was in charge of the tribal division of Simeon, ");
INSERT INTO engfbv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","and Eliasaph, son of Deuel, was in charge of the tribal division of Gad. ");
INSERT INTO engfbv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Then the Kohathites set off, carrying the holy objects. The Tabernacle would be put up before they arrived. ");
INSERT INTO engfbv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Then came the divisions of Ephraim who marched out under their flag, with Elishama, son of Ammihud in charge. ");
INSERT INTO engfbv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, son of Pedahzur, was in charge of the tribal division of Manasseh, ");
INSERT INTO engfbv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","and Abidan, son of Gideoni, was in charge of the tribal division of Benjamin. ");
INSERT INTO engfbv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Lastly came the divisions of Dan who marched out under their flag, defending the rear of all the tribal groups, with Ahiezer, son of Ammishaddai, in charge. ");
INSERT INTO engfbv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagiel, son of Ocran, was in charge of the tribal division of Asher, ");
INSERT INTO engfbv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","and Ahira, son of Enan, was in charge of the tribal division of Naphtali. ");
INSERT INTO engfbv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","This was the order in which the Israelite tribal divisions moved out. ");
INSERT INTO engfbv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moses explained to Hobab, the son of Moses' father-in-law Reuel the Midianite, “We're leaving for the place of which the Lord promised, ‘I'm going to give it to you.’ Come with us, and we'll be good to you, because the Lord has promised good things to Israel.” ");
INSERT INTO engfbv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","“No, I won't go—I'll return to my own country and my own people,” Hobab replied. ");
INSERT INTO engfbv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","“Please don't abandon us now,” Moses said, “because you're the one who knows where we should camp in the desert and you can guide us. ");
INSERT INTO engfbv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","If you come with us, whatever good things the Lord blesses us with we'll share with you.” ");
INSERT INTO engfbv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","They left the mountain of the Lord to go on a three-day journey. The Ark of the Lord's Agreement led the way for them during these three days to find a place for them to camp. ");
INSERT INTO engfbv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","The cloud of the Lord was above them during day as they moved on from the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Whenever the Ark was carried out, Moses would call out, “Stand up, Lord, and may your enemies be scattered, and may those who hate you run away from you.” ");
INSERT INTO engfbv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Whenever it was set down, he would call out, “Return, Lord, to the thousands and thousands of the people of Israel.” ");
INSERT INTO engfbv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","It wasn't long before the people started to complain about how much they were suffering. When the Lord heard what they were saying, he became angry. Fire from the Lord burned them, destroying some on the edge of the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","The people cried to Moses for help. He prayed to the Lord and the fire subsided. ");
INSERT INTO engfbv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So that place was named Taberah, because the fire from the Lord burned them. ");
INSERT INTO engfbv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","A group of troublemakers among them had such intense food cravings they affected the Israelites who started crying again, asking “Who's going to get us some meat to eat? ");
INSERT INTO engfbv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We think back to all the fish we ate in Egypt that didn't cost us anything, as well as the cucumbers, melons, leeks, onions, and garlic. ");
INSERT INTO engfbv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","We're fading away here! The only thing we ever see is this manna!” ");
INSERT INTO engfbv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna looked like coriander seeds, light in color like gum resin. ");
INSERT INTO engfbv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people would go out and collect it, grind it up in a mill or crush it in a mortar. Then they would boil it in a pot and make it into flatbread. It tasted like pastries made with the best olive oil. ");
INSERT INTO engfbv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","When the dew came down on the camp at night the manna would come down with it. ");
INSERT INTO engfbv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses heard all the families crying at the entrance to their tents. The Lord became very angry, and Moses was also upset. ");
INSERT INTO engfbv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","He asked the Lord, “Why have you made things so tough for me, your servant? Why are you so unhappy with me that you have placed on me the heavy responsibility for all these people? ");
INSERT INTO engfbv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Are they my children? Did I give birth to them, so you could tell me, ‘Hold them close to your chest like a nurse carrying a baby’ and take them to the land you promised to give to their forefathers? ");
INSERT INTO engfbv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Where am I supposed to get meat for all of them? They keep on complaining to me, ‘Get us some meat to eat!’ ");
INSERT INTO engfbv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I can't go on carrying all these people by myself—it's just too much. ");
INSERT INTO engfbv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If this is the way you're going to treat me, then please just kill me now so I don't have to face how depressed I've become. Please grant me this one request.” ");
INSERT INTO engfbv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","The Lord told Moses, “Bring before me seventy Israelite elders who you know are respected as leaders by the people. Take them to the Tent of Meeting. They will stand there with you. ");
INSERT INTO engfbv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","I will come down and talk with you there. I will take some of the Spirit you have and give it to them. They will take some of the responsibility for the people so you won't have to bear it alone. ");
INSERT INTO engfbv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tell the people: Purify yourselves, for tomorrow you'll have meat to eat, because you were complaining and the Lord heard you saying, ‘Who's going to get us some meat to eat? We were better off in Egypt!’ So the Lord is going to provide you with meat to eat. ");
INSERT INTO engfbv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You're going to eat it, not for just a day or two, and not for five or ten or twenty days. ");
INSERT INTO engfbv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","You're going to eat it for a whole month until it makes you vomit and it comes out through your nostrils, because you have rejected the Lord who is right here with you, complaining to him by saying, ‘Why on earth did we ever leave Egypt?’” ");
INSERT INTO engfbv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","But Moses replied, “Here I am with 600,000 people and you're telling me, ‘I'm going to give them meat and they'll eat it for a month’? ");
INSERT INTO engfbv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Even if all our flocks and herds were slaughtered, would that be enough for them? Even if all the fish in the sea were caught, would that be enough for them?” ");
INSERT INTO engfbv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","“Doesn't the Lord have the power to do that?” the Lord responded. “Now you're going to find out whether what I've said will happen or not!” ");
INSERT INTO engfbv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moses went and shared with the people what the Lord said. He summoned seventy elders of the people and had them stand around the tent. ");
INSERT INTO engfbv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Then the Lord came down and talked to him. The Lord took some of the Spirit Moses had and gave it to them. They prophesied, but this didn't ever happen again. ");
INSERT INTO engfbv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","However, two men named Eldad and Medad had stayed behind in the camp. The Spirit came on them too. (They had been put on the list of the seventy elders, but they hadn't gone to the tent. But they prophesied where they were in the camp anyway.) ");
INSERT INTO engfbv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A young lad ran and told Moses, “Eldad and Medad are prophesying in the camp.” ");
INSERT INTO engfbv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua, son of Nun, who had been Moses' assistant since he was young, reacted, saying, “Moses, my lord, you have to stop them!” ");
INSERT INTO engfbv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","“Are you jealous for my reputation?” Moses replied. “I wish that every one of the Lord's people were prophets and that the Lord would give his Spirit to all of them!” ");
INSERT INTO engfbv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses went back to the camp with the elders of Israel. ");
INSERT INTO engfbv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","The Lord sent a wind that blew quail in from the sea and deposited them near the camp. They covered the ground to a depth of about two cubits and extended for a day's journey in every direction from the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","All through that day and night, and all through the next day, the people went on collecting the quail. Everyone collected at least ten homers, and they spread them out to dry all around the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","But while the people were still biting into the meat, before they even chewed it down, the Lord showed his burning anger against them, killing some of them with a severe disease. ");
INSERT INTO engfbv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","They named that place Kibroth-hattaavah, because that was where they buried the people who had these intense food cravings. ");
INSERT INTO engfbv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Then they moved on from Kibroth-hattaavah to Hazeroth, where they stayed for some time. ");
INSERT INTO engfbv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam and Aaron were critical of Moses because of his Ethiopian wife—he'd married an Ethiopian woman. ");
INSERT INTO engfbv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Is it only through Moses that the Lord speaks?” they asked. “Doesn't he speak through us too?” The Lord heard all this. ");
INSERT INTO engfbv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Moses was a very humble man, more than anyone else on earth. ");
INSERT INTO engfbv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","All of a sudden the Lord called for Moses, Aaron, and Miriam, telling them, “The three of you, come to the Tent of Meeting.” The three of them did so. ");
INSERT INTO engfbv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","The Lord came down in a pillar of cloud and stood in the entrance to the Tent. He called Aaron and Miriam and they came forward. ");
INSERT INTO engfbv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","“Now listen to my words, he told them. If you had prophets, I the Lord would reveal myself to them in visions; I would communicate with them in dreams. ");
INSERT INTO engfbv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","But it's not like this with my servant Moses, who of all my people is the one who is faithful. ");
INSERT INTO engfbv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","I talk to him personally, face to face. I speak plainly, not in riddles. He sees the likeness of the Lord. So why weren't you afraid when you criticized my servant Moses?” ");
INSERT INTO engfbv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","The Lord was angry with them, and he left. ");
INSERT INTO engfbv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","As the cloud rose above the Tent, Miriam's skin suddenly turned white with leprosy. Aaron turned to look and saw that she had leprosy. ");
INSERT INTO engfbv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","He said to Moses, “My lord, please don't punish us for this sin that we've so stupidly committed. ");
INSERT INTO engfbv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Please don't let her become like a stillborn baby whose flesh is already decaying when they're born!” ");
INSERT INTO engfbv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moses called out to the Lord, “God, please heal her!” ");
INSERT INTO engfbv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","But the Lord replied to Moses, “If her father had spit in her face wouldn't she have been disgraced for seven days? Keep her in isolation outside the camp for seven days, and then she can be taken back in.” ");
INSERT INTO engfbv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam was kept in isolation outside the camp for seven days, and the people did not move on until she was taken back in. ");
INSERT INTO engfbv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Then the people left Hazeroth and set up camp in the Desert of Paran. ");
INSERT INTO engfbv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send some men to explore the land of Canaan, the country I'm giving to the Israelites. Choose one of the leaders from each of the tribes to go and do this.” ");
INSERT INTO engfbv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moses did as the Lord had ordered and sent the men out from the Desert of Paran. They were all leaders of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Their names were: Shammua son of Zaccur, from the tribe of Reuben. ");
INSERT INTO engfbv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Shaphat, son of Hori, from the tribe of Simeon. ");
INSERT INTO engfbv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Caleb, son of Jephunneh, from the tribe of Judah. ");
INSERT INTO engfbv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal, son of Joseph, from the tribe of Issachar. ");
INSERT INTO engfbv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hoshea, son of Nun, from the tribe of Ephraim. ");
INSERT INTO engfbv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti son of Raphu, from the tribe of Benjamin. ");
INSERT INTO engfbv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gaddiel, son of Sodi, from the tribe of Zebulun. ");
INSERT INTO engfbv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaddi, son of Susi, from the tribe of Manasseh (a tribe of Joseph). ");
INSERT INTO engfbv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Ammiel, son of Gemalli, from the tribe of Dan. ");
INSERT INTO engfbv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Sethur, son of Michael, from the tribe of Asher. ");
INSERT INTO engfbv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahbi, son of Vophsi, from the tribe of Naphtali. ");
INSERT INTO engfbv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Geuel, son of Machi, from the tribe of Gad. ");
INSERT INTO engfbv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These were the names of the men that Moses sent to explore the country. Moses called Hoshea Joshua. ");
INSERT INTO engfbv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses sent them out to explore the land of Canaan, telling them, “Go through the Negev and on into the hill country. ");
INSERT INTO engfbv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","See what the place looks like, and find out about the people living there—are they strong or weak? Are there many of them or only a few? ");
INSERT INTO engfbv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Is the land where they're living good or bad? Are their towns like open camps, or do they have defensive walls? ");
INSERT INTO engfbv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Is the soil productive or not? Is it forested? Be brave, and bring back some of the country's fruit.” (It was the beginning of the grape harvest.) ");
INSERT INTO engfbv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So the men went and explored the land all the way from the Desert of Zin to Rehob, bear Lebo-hamath. ");
INSERT INTO engfbv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They went through the Negev and arrived in Hebron where Ahiman, Sheshai, and Talmai, the descendants of Anak, lived. This town was built seven years before the Egyptian town of Zoan. ");
INSERT INTO engfbv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","When they arrived at the Valley of Eshcol they chopped down a branch that had just one bunch of grapes. They had to carry it on a pole held between two men. They also collected some pomegranates and figs. ");
INSERT INTO engfbv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(The place was named the Valley of Eshcol because of the bunch of grapes they took from there.) ");
INSERT INTO engfbv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Forty days later the men returned from exploring the country. ");
INSERT INTO engfbv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","They went to see Moses and Aaron, and all the Israelites gathered there at their camp in Kadesh in the Desert of Paran. They gave a report before everyone and showed them the fruit they had brought back from the country. ");
INSERT INTO engfbv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","This is the report they gave to Moses: “We went and explored the country you sent us to, and it is definitely very productive, as if it was flowing with milk and honey. Just look at some of its fruit! ");
INSERT INTO engfbv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But the people living there are strong, and their towns are big and have defensive walls. We also saw some descendants of Anak there. ");
INSERT INTO engfbv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalekites live in the Negev. The Hittites, Jebusites, and the Amorites live in the hill country. The Canaanites live on the sea coast and also beside the Jordan.” ");
INSERT INTO engfbv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Then Caleb asked for quiet as the people stood before Moses and told them, “Let's go and take over the land. We can conquer the country, no doubt about it!” ");
INSERT INTO engfbv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone with him disagreed. “We can't go and fight these people! They're much stronger than us!” ");
INSERT INTO engfbv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","They spread a negative report among the Israelites about the country they had explored. They told people, “The country we explored destroys the people that live there. Plus everyone we saw was really big! ");
INSERT INTO engfbv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We even saw giants there—people descended from Anak the giant! Compared to them we looked like grasshoppers, and we must have looked like that to them too!” ");
INSERT INTO engfbv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Then everybody there cried out loud all night. ");
INSERT INTO engfbv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","All the Israelites went and complained to Moses and Aaron, telling them, “If only we'd died in Egypt, or here in this desert! ");
INSERT INTO engfbv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Why is the Lord taking us to this country only to get us killed? Our wives and children will be captured and taken away as slaves! Wouldn't we be better off going back to Egypt?” ");
INSERT INTO engfbv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","They said to one another, “Let's choose a new leader and go back to Egypt.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moses and Aaron fell facedown on the ground in front of all the assembled Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua, son of Nun, and Caleb, son of Jephunneh, were there. They had been part of the group who had gone to spy out the land. They ripped their clothes, ");
INSERT INTO engfbv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","and told the Israelites, “The country we traveled through and explored has very good land. ");
INSERT INTO engfbv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","If the Lord is happy with us, he will take us there and give it to us, a land that's so productive it's like flowing with milk and honey. ");
INSERT INTO engfbv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Don't rebel and fight against the Lord. You don't need to be afraid of the people living there in the country—we can take them easily! They're defenseless and the Lord is with us. Don't be frightened of them!” ");
INSERT INTO engfbv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","In reply all the people shouted out, “Stone them!” But the glory of the Lord suddenly appeared in the Tent of Meeting, right in the middle of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","The Lord told Moses, “How long are these people going to reject me? How long are these people going to refuse to trust in me despite all the miracles I have done right in front of them? ");
INSERT INTO engfbv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I'm going to make them sick with a disease and kill them. Then I will make you into a nation that's greater and stronger than they are.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","But Moses told the Lord, “The Egyptians will find out about it! It was by your power that you led the Israelites out from among them. ");
INSERT INTO engfbv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","They will tell the people living in this country all about it. They've already heard that you, Lord, are with us Israelites, that you, Lord, are seen face to face, that your cloud stands guard over them, and that you lead them by a pillar of cloud during day and a pillar of fire at night. ");
INSERT INTO engfbv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","If you kill all these people in one go, the nations who have heard about you will say, ");
INSERT INTO engfbv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘The Lord killed these people in the desert because he wasn't able to take them to the country he promised to give them. He's killed them all in desert!’ ");
INSERT INTO engfbv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Now, Lord, please demonstrate the extent of your power just as you have said: ");
INSERT INTO engfbv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","The Lord is slow to become angry and is full of trustworthy love, forgiving sin and rebellion. However, he will not allow the guilty to go unpunished, bringing the consequences of the parents' sin on their children, grandchildren, and great-grandchildren. ");
INSERT INTO engfbv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Please forgive the sin of these people since your trustworthy love is so great, in the same way that you have forgiven them from the time they left Egypt until now.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","“I have forgiven them as you asked,” the Lord replied. ");
INSERT INTO engfbv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“But even so, as I live and as the whole earth is filled with the Lord's glory, ");
INSERT INTO engfbv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","not a single one of the those who saw my glory and the miracles I did in Egypt and in the desert—but provoked me and refused to obey me time and time again— ");
INSERT INTO engfbv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","not a single one of them is ever going to see the country I promised to give their forefathers. None of those who rejected me will see it. ");
INSERT INTO engfbv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But because my servant Caleb has a totally different spirit and is fully committed to me, I will lead him to the country he visited, and his descendants will own it. ");
INSERT INTO engfbv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Since the Amalekites and Canaanites are living in the valleys, tomorrow you are to turn around and head back into the desert, taking the route towards the Red Sea.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How much longer are these wicked people going to criticize me? I've heard what they're saying, making complaints against me. ");
INSERT INTO engfbv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Go and tell them, ‘As I live, declares the Lord, I'll do just what I heard you say you wanted, believe me! ");
INSERT INTO engfbv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","All of you will die in this desert, everyone who was registered in the census that counted those aged twenty or over, because you made complaints against me. ");
INSERT INTO engfbv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Absolutely none of you will enter the country I promised to give you to live in, except for Caleb, son of Jephunneh, and Joshua, son of Nun. ");
INSERT INTO engfbv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","However, I will take your children—those you said would be taken away as plunder—into the country you rejected, and they will appreciate it. ");
INSERT INTO engfbv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","But you—you are all going to die in this desert. ");
INSERT INTO engfbv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Your children will wander in the desert for forty years, suffering because of your lack of trust until all your bodies lie buried in the desert. ");
INSERT INTO engfbv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Just as you explored the country for forty days, so shall your punishment for your sins be forty years, a year for every day, and you will see what happens when I oppose you. ");
INSERT INTO engfbv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","I, the Lord, have spoken! Just see if I won't do this to all these wicked Israelites who have worked together to oppose me! They will end their lives in the desert—they will die there.’” ");
INSERT INTO engfbv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","The men that Moses had sent to explore the country—those who came back and because they gave a bad report they made all the Israelites complain against the Lord— ");
INSERT INTO engfbv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","those men who gave the bad report died before the Lord from plague. ");
INSERT INTO engfbv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","The only ones who lived were Joshua son of Nun and Caleb son of Jephunneh of those who went to explore the country. ");
INSERT INTO engfbv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","When Moses told the Israelites what the Lord had said they were very, very sad. ");
INSERT INTO engfbv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","They got up early the next morning planning to go into the hill country. “Yes we really did sin,” they said, “but now we're here and we'll go where the Lord told us.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses objected. “Why are you disobeying the Lord's command? You won't succeed in your plan! ");
INSERT INTO engfbv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Don't try and go, otherwise you will be killed by your enemies, because the Lord isn't with you. ");
INSERT INTO engfbv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","The Amalekites and Canaanites living there will attack you, and you will die by the sword. Because you rejected the Lord, he won't help you.” ");
INSERT INTO engfbv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But they were arrogant and went up into the hill country, even though Moses and the Ark of the Lord's Agreement didn't move from the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","The Amalekites and Canaanites who lived there in the hill country came down and attacked the Israelites and defeated them, and chased them all the way to Hormah. ");
INSERT INTO engfbv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Tell the Israelites, ‘These are instructions about what you are to do once you arrive in the country I'm giving you to live in. ");
INSERT INTO engfbv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","When you bring an offering to the Lord from your herd or flock (whether it's a burnt offering, a sacrifice to fulfill a promise you made, or a freewill or festival offering) that will be acceptable to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","then you shall also present a grain offering of one tenth of an ephah of the best flour mixed with a quarter hin of olive oil. ");
INSERT INTO engfbv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Add a quarter of a hin of wine as a drink offering to the burnt offering or the sacrifice of a lamb. ");
INSERT INTO engfbv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","When it comes to a ram, present a grain offering of two tenths of an ephah of the best flour mixed with a third of a hin of olive oil, ");
INSERT INTO engfbv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","along with a third of a hin of wine as a drink offering, all of them to be acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","When you bring a young bull as a burnt offering or a sacrifice to fulfill a promise you made or as a peace offering to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","then you shall also bring with the bull a grain offering of three-tenths of an ephah of the best flour mixed with half a hin of olive oil. ");
INSERT INTO engfbv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Add a half a hin of wine as a drink offering. All this is an offering to be acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","This is to be done for every bull, ram, lamb, or goat brought as an offering. ");
INSERT INTO engfbv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","This is what you need to do for each one, however many. ");
INSERT INTO engfbv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Every Israelite is to follow these instructions when they present an offering that is accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","This also applies for all future generations that if a foreigner living among you or anyone else among you wishes to present an offering acceptable to the Lord: they are to do exactly what you do. ");
INSERT INTO engfbv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","The whole congregation must have the same rules for you and for the foreigner living among you. This is a permanent law for all future generations You and the foreigner are to be treated the same way before the law. ");
INSERT INTO engfbv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","The same rules and regulations apply to you and the foreigner living among you.’” ");
INSERT INTO engfbv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Then the Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tell the Israelites, ‘When you get to the country where I'm leading you ");
INSERT INTO engfbv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","and you eat the food produced there, you shall give some of it as an offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","You are to give some of the flour you make into loaves as a gift—present it just like an offering from the threshing floor. ");
INSERT INTO engfbv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","For all future generations, you are to give the Lord an offering from the first of your flour. ");
INSERT INTO engfbv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Now if you collectively sin without meaning to and don't follow all these instructions that the Lord has given Moses— ");
INSERT INTO engfbv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","everything that the Lord has ordered you to do through Moses from the time that the Lord gave them and for all future generations— ");
INSERT INTO engfbv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","and if it was done unintentionally without everyone knowing about it, then the whole congregation is to present a young bull as a burnt offering to be accepted by the Lord, along with its grain offering and drink offering presented according to the rules, as well as a male goat as a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","In this way the priest is to make the whole congregation of Israel right with the Lord so that they can be forgiven, because the sin was unintentional and they have presented the Lord with a burnt offering and a sin offering, offered before the Lord for their unintentional sin. ");
INSERT INTO engfbv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Then the whole congregation of Israel and the foreigners living among them will be forgiven, because the people sinned unintentionally. ");
INSERT INTO engfbv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","In the case of an individual who sins without meaning to—they are to present a one-year-old female goat as a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","The priest will make the person who sinned unintentionally right before the Lord on their behalf. Once they have been made right, they will be forgiven. ");
INSERT INTO engfbv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","You shall apply the same law for the one who mistakenly sins to an Israelite or a foreigner living among you. ");
INSERT INTO engfbv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","But the person who sins in defiance, whether an Israelite or foreigner, is blaspheming the Lord. They shall be expelled from their people. ");
INSERT INTO engfbv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","They have to be expelled, because they have treated the word of the Lord with contempt and broken his commandment. They are responsible for the consequences of their own guilt.’” ");
INSERT INTO engfbv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","During the time the Israelites were wandering in the desert, a man was caught collecting firewood on the Sabbath. ");
INSERT INTO engfbv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","The people who found him collecting wood brought him before Moses, Aaron, and the rest of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They placed him under guard because it wasn't clear what should happen to him. ");
INSERT INTO engfbv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","The Lord told Moses, “This man has to be executed. All the Israelites are to stone him outside the camp.” ");
INSERT INTO engfbv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So they all took the man outside the camp and stoned him to death as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Sometime later the Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Tell the Israelites that for all future generations you must make tassels for the hems of your clothes and attach them with blue cord. ");
INSERT INTO engfbv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","When you look at these tassels you will be reminded to keep all the commandments of the Lord and not be unfaithful, following your own thoughts and desires. ");
INSERT INTO engfbv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","In this way you'll remember to keep all my commandments and you will be holy to your God. I am the Lord your God who led you out of Egypt to be your God. ");
INSERT INTO engfbv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the Lord your God!” ");
INSERT INTO engfbv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korah, son of Izhar, son of Kohath, son of Levi tried to take over leadership, along with Dathan and Abiram, sons of Eliab, and On, son of Peleth, who were from the tribe of Reuben. ");
INSERT INTO engfbv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","They rebelled against Moses, and were joined by 250 well-respected Israelite leaders and members of the assembly. ");
INSERT INTO engfbv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They joined together in opposition to Moses and Aaron, telling them, “You've taken too much power for yourselves! Every one of the Israelites is holy, and the Lord is among them. So why do you set yourselves above the Lord's assembly?” ");
INSERT INTO engfbv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard what they were saying, he fell facedown on the ground. ");
INSERT INTO engfbv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Then he told Korah and all those with him, “In the morning the Lord is going to make it clear who is his and who is holy, and allow that person to approach him. He will only allow whoever he chooses to approach him. ");
INSERT INTO engfbv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","This is what you, Korah, and everyone with you are going to do. Take some incense burners, ");
INSERT INTO engfbv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","and tomorrow put incense in them and set it on fire in the presence of the Lord. Then the man the Lord chooses is the one who is holy. It is you Levites who are taking too much power for yourselves!” ");
INSERT INTO engfbv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses also told Korah, “Listen, you Levites! ");
INSERT INTO engfbv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Do you think it's something insignificant that the God of Israel chose you from all the other Israelites and allowed you to approach him and carry out the work in the Lord's Tabernacle, to stand before the Israelites and serve them? ");
INSERT INTO engfbv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","He has allowed you the privilege of approaching him, Korah, you and all the other Levites, but now you want to have the priesthood as well! ");
INSERT INTO engfbv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","So in reality you and those who have joined you are fighting against the Lord—because who is Aaron that you should complain about him?” ");
INSERT INTO engfbv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moses summoned Dathan and Abiram, the sons of Eliab, but they replied, “We're not going to appear before you! ");
INSERT INTO engfbv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Haven't you done enough by taking us away from a land flowing with milk and honey in order to kill us out here in the desert? Do you have to make yourself a dictator as well, someone to rule us? ");
INSERT INTO engfbv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","On top of that you haven't taken us to a land flowing with milk and honey or given us fields and vineyards to own. Do you really think you can fool everyone? No, we will not attend!” ");
INSERT INTO engfbv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moses got really angry and said to the Lord, “Don't accept their offerings. I have never taken even a donkey from them or treated any of them badly.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moses told Korah, “You and all those who have joined you must appear before the Lord tomorrow—all of you and Aaron too. ");
INSERT INTO engfbv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Each one will take his incense burner, put incense in it, and offer it before the Lord. All 250 of you will use your incense burners and Aaron will as well.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So each one took his incense burner, put incense in it, set it on fire, and stood together with Moses and Aaron at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","When Korah had gathered all his rebellious group at the entrance to the Tent of Meeting, the Lord's glory appeared before the whole congregation. ");
INSERT INTO engfbv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Step away from these Israelites and I will destroy them right away.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","But Moses and Aaron fell facedown on the ground said, “God—God of everything that lives—when it's only one man who sins, must you be angry with everybody?” ");
INSERT INTO engfbv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Then the Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tell the people to move away from the homes of Korah, Dathan, and Abiram.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","So Moses went over to Dathan and Abiram, and the Israelite elders of Israel followed him. ");
INSERT INTO engfbv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","He ordered the people, “Move away from the tents of these wicked men and don't touch anything that belongs to them, otherwise you will be destroyed along with them in all their sins.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","The people moved away from the homes of Korah, Dathan, and Abiram. Dathan and Abiram came out and stood at the entrances to their tents along with their wives, children and little ones. ");
INSERT INTO engfbv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moses said, “This is how you will know that the Lord did send me to carry out everything I've done, for it wasn't anything I thought up. ");
INSERT INTO engfbv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","If these men die a natural death, experiencing the destiny of every human being, then the Lord didn't send me. ");
INSERT INTO engfbv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the Lord does something totally different, and the earth opens up and swallows them down along with everything that belongs to them so that they go down alive into Sheol, then you will know that these men have acted with contempt to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Immediately after Moses had finished saying all this, the ground under the rebels split apart, ");
INSERT INTO engfbv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","and the earth opened up and swallowed them and their households down, as well as everyone who was there with Korah and everything that belonged to them. ");
INSERT INTO engfbv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They went down alive into Sheol with all that they had. The earth closed over them, and they were no more. ");
INSERT INTO engfbv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","When they heard their cries, all the Israelites nearby ran away, shouting, “Watch out! The earth could swallow us too!” ");
INSERT INTO engfbv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Fire burst out from the Lord and burned up the 250 men who were offering incense. ");
INSERT INTO engfbv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Then the Lord said to Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tell Eleazar, son of Aaron the priest, to collect the holy incense burners from among those who have been burned up, and scatter the coals used for the incense well away from the camp. ");
INSERT INTO engfbv_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Have the incense burners of those who sinned at the expense of their own lives hammered into metal sheets as a covering for the altar, because they were offered before the Lord, and so have become holy. They will be a reminder to Israelites of what happened.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest collected the bronze incense burners used by those who had been burned up, and had them hammered out as a covering for the altar, ");
INSERT INTO engfbv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","following the instructions given to him from the Lord through Moses. This was to remind the Israelites that no one who is not a descendant of Aaron should come and offer incense before the Lord, otherwise they could end up like Korah and those with him. ");
INSERT INTO engfbv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","The next day all the Israelites complained to Moses and Aaron, saying, “You have killed the Lord's people!” ");
INSERT INTO engfbv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","But as the people gathered to confront them, Moses and Aaron went over to the Tent of Meeting, and suddenly the cloud covered it and the Lord's glory appeared. ");
INSERT INTO engfbv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moses and Aaron went and stood at the front of the Tent of Meeting, ");
INSERT INTO engfbv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","and the Lord said to Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Get away from these people and I will finish them off immediately.” Moses and Aaron fell facedown on the ground. ");
INSERT INTO engfbv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moses told Aaron, “Put some coals from the altar and some incense in your incense burner. Then run to the people and make them right before the Lord, for the Lord is angry with them and a plague has started.” ");
INSERT INTO engfbv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron took the incense burner just as Moses had told him and ran into the middle of the assembly. He saw that the plague had started to affect the people so he offered the incense and made the people right with the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","He stood between those who had died and those who were still alive, and the plague was stopped. ");
INSERT INTO engfbv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","However, 14,700 died from the plague in addition to those who'd died because of Korah. ");
INSERT INTO engfbv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Then Aaron went back to Moses at the entrance to the Tent of Meeting because the plague had been stopped. ");
INSERT INTO engfbv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tell the Israelites to bring twelve walking sticks, one from the leader of each tribe. Write the name of each man on the walking stick, ");
INSERT INTO engfbv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","and write Aaron's name on the walking stick of the tribe of Levi, because there has to be a walking stick for the head of each tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Place the walking sticks in the Tent of Meeting in front of the Testimony where I meet with you. ");
INSERT INTO engfbv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","The walking stick that belongs to the man I choose will sprout buds, and I will put a stop to the Israelites' constant complaints against you.” ");
INSERT INTO engfbv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moses explained this to the Israelites, and each of their leaders gave him a walking stick, one for each of the leaders of their tribes. So there were twelve walking sticks including the one belonging to Aaron. ");
INSERT INTO engfbv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses placed the walking sticks before the Lord in the Tent of the Testimony. ");
INSERT INTO engfbv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","The next day Moses went into the Tent of the Testimony and saw that Aaron's walking stick that represented the tribe of Levi, had sprouted and developed buds, flowered and produced almonds. ");
INSERT INTO engfbv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moses took all the walking sticks from the presence of the Lord and showed them to all the Israelites. They saw them, and each man collected his own walking stick. ");
INSERT INTO engfbv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","The Lord told Moses, “Put Aaron's walking stick back in front of the Testimony, to be kept there as a reminder to warn anyone who wants to rebel, so that you may stop their complaining against me. Otherwise they'll die.” ");
INSERT INTO engfbv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moses did what the Lord ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Then the Israelites came and told Moses, “Can't you see we're all going to die? We'll be destroyed! We're all going to be killed! ");
INSERT INTO engfbv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Anyone who dares to approach the Tabernacle of the Lord will die. Are we all going to be completely wiped out?” ");
INSERT INTO engfbv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","The Lord told Aaron, “You and your sons and the other Levites bear the responsibility for sins relating to the sanctuary. You and your sons alone bear the responsibility for sins relating to your priesthood. ");
INSERT INTO engfbv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Have your brothers from the tribe of Levi, your father's tribe, join you to help you and your sons with your service in the Tent of the Testimony. ");
INSERT INTO engfbv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","They will take care of your responsibilities and those relating to the Tent, but they must not come too close to the sacred objects of the sanctuary or the altar, otherwise they will die, and you will too. ");
INSERT INTO engfbv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They are to help you and take care of the responsibilities of the Tent of Meeting, doing all the work at the Tent, but they are not allowed to be with you during your priestly ministry. ");
INSERT INTO engfbv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","You are to carry out the responsibilities relating to the sanctuary and the altar, so that my anger will not fall on the Israelites again. ");
INSERT INTO engfbv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Look, I myself have chosen your brothers the Levites from the Israelites as my gift to you, dedicated to the Lord to do the work that relates to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But only you and your sons are responsible for your priesthood, doing all that concerns the altar and is behind the veil. Only you are to perform that service. I am giving you the gift of your priesthood, but anyone else who approaches the sanctuary must be executed.” ");
INSERT INTO engfbv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","The Lord told Aaron, “Listen, I have put you in charge of officiating at my offerings. All the holy contributions of the Israelites that they bring are reserved for you, and this is a permanent rule. ");
INSERT INTO engfbv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Part of the most holy offerings taken from the burnt offerings are yours. Part of all the offerings they give me as most holy offerings, whether it's grain offerings or sin offerings or guilt offerings, that part belongs to you and your sons. ");
INSERT INTO engfbv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","You shall eat it in a most holy place. Every male is allowed to eat it. You are to regard it as something holy. ");
INSERT INTO engfbv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","The following also belongs to you: the voluntary gifts as well as all the wave offerings of the Israelites. I have given this to you and your sons and daughters as a permanent rule. Everyone in your household who is ceremonially clean is allowed to eat it. ");
INSERT INTO engfbv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","I am giving you all the best olive oil and all the best new wine and grain that the Israelites give as firstfruits to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","The firstfruits of all the crops they produce in their land that they bring to the Lord are yours. Everyone in your family who is ceremonially clean is allowed to eat them. ");
INSERT INTO engfbv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Everything in Israel that is dedicated to the Lord is yours. ");
INSERT INTO engfbv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Every firstborn, whether human or animal, that is offered to the Lord is yours. But you must buy back every firstborn son and every firstborn male of unclean animals. ");
INSERT INTO engfbv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","When they are one month old you shall pay the redemption price of five shekels of silver (using the sanctuary shekel standard), equivalent to twenty gerahs. ");
INSERT INTO engfbv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","But you are not allowed to redeem the firstborn of an ox, a sheep, or a goat because they are holy. You shall sprinkle their blood on the altar, and burn their fat as a burnt offering accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Their meat is yours, in the same way that the breast and right thigh of the wave offering are yours. ");
INSERT INTO engfbv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","I am giving all the voluntary gifts that the Israelites present to the Lord to you and to your sons and daughters as a permanent rule. It is a permanent agreement of salt before the Lord for you and your descendants. ");
INSERT INTO engfbv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","You won't possess property in their country, and you won't have a share in their land. I am your share and your possession among the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Instead I have given the Levites all the tithes in Israel as compensation for the service they provide in doing the work in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","The Israelites are no longer allowed to approach the Tent of Meeting, or they will commit an offense and die. ");
INSERT INTO engfbv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","The Levites are to carry out the work in the Tent of Meeting, and they must take responsibility for any sins involved. This is a permanent rule for all future generations. The Levites won't receive a share of land among the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Instead I have given to the Levites as their compensation the tithe that the Israelites give to the Lord as a contribution. That's why I told them that they wouldn't receive a share of land among the Israelites.” ");
INSERT INTO engfbv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Talk to the Levites and explain to them, ‘When you receive from the Israelites the tithe that I have given you as your compensation, you must return part of it as an offering to the Lord: a tithe of the tithe. ");
INSERT INTO engfbv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Your offering will be considered as if it were the firstfruits of grain from your threshing floor or grape juice from the winepress. ");
INSERT INTO engfbv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","In this way you are to contribute an offering to the Lord from every tithe you receive from the Israelites, giving the Lord's offering to Aaron the priest. ");
INSERT INTO engfbv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","From all the gifts you receive you are to contribute as the Lord's offering the very best, the holiest part of every gift.’ ");
INSERT INTO engfbv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","So tell the Levites, ‘When you have presented the best part, it will be considered as your contribution produced by your threshing floor or winepress. ");
INSERT INTO engfbv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","You and your families may eat it anywhere because it's compensation for your service in the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","You will not be considered to have sinned if you have presented the best part of it. But if you treat the sacred offerings of the Israelites with disrespect you will die.’” ");
INSERT INTO engfbv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","The Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“This is a legal regulation the Lord has ordered, saying, Tell the Israelites to bring you a red cow without defects which has never been yoked. ");
INSERT INTO engfbv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Hand it over to Eleazar the priest, and he will take it outside the camp and have it slaughtered before him. ");
INSERT INTO engfbv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleazar the priest will put some of its blood on his finger and sprinkle it seven times towards the entrance of the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Then the cow must be burned as he watches. All of it is to be burned—its skin, meat, and blood, as well as its excrement. ");
INSERT INTO engfbv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","The priest shall throw cedar wood, hyssop, and crimson thread on the burning cow. ");
INSERT INTO engfbv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the priest shall wash his clothes and his body in water, and after that he may enter the camp, but he will remain unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The person who burned the cow shall also wash his clothes and his body in water, and he too will remain unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Then a man who is clean shall collect the ashes of the cow and keep them in a clean place outside the camp. They are to be kept by the Israelites to prepare the water of purification which is for purifying from sin. ");
INSERT INTO engfbv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","The man who collected the ashes of the cow shall also wash his clothes, and he will remain unclean until the evening. This is a permanent rule for the Israelites and for the foreigner that lives with them. ");
INSERT INTO engfbv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","If you touch a dead body you will be unclean for seven days. ");
INSERT INTO engfbv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","You must purify yourself with the water of purification on the third day and on the seventh day, and then you will be clean. But if you don't purify yourself on the third and seventh days, you won't be clean. ");
INSERT INTO engfbv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","If you touch a dead body and don't purify yourself, you make the Tabernacle of the Lord unclean and must be expelled from Israel. You are still unclean because the water of purification hasn't been sprinkled on you, and your uncleanness remains. ");
INSERT INTO engfbv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","The following regulation applies when a person dies in a tent. Everyone who comes into the tent and everyone who is already in the tent will be unclean for seven days. ");
INSERT INTO engfbv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Any open container there that doesn't have a closed lid is unclean. ");
INSERT INTO engfbv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","If you're out in the open and you touch someone who has been killed by the sword or who has died naturally, or if you touch a human bone or a grave, then you'll be unclean for seven days. ");
INSERT INTO engfbv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","This is the process for the purification if you are unclean. Take some of the ashes of the burnt offering for purification, and put them in a jar with fresh water. ");
INSERT INTO engfbv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","A man who is clean shall take some hyssop and dip it in the water. Then sprinkle the tent and everything inside it, and everybody who was there. He would also need to sprinkle you if you touched a bone, or a grave, or someone who has died or has been killed. ");
INSERT INTO engfbv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","The man who is clean is to sprinkle you both on the third day and on the seventh day. After you are purified on the seventh day, you must wash your clothes and yourself in water, and that evening you'll be clean. ");
INSERT INTO engfbv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","But if you don't purify yourself, you will be expelled from the Israelites, because you have made the Tabernacle of the Lord unclean. The water of purification hasn't been sprinkled on you, and you remain unclean. ");
INSERT INTO engfbv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","This is a permanent rule for everyone. The man who sprinkles the water of purification must wash his clothes, and anyone who touches the water of purification will be unclean until the evening. ");
INSERT INTO engfbv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Anything the unclean person touches will be unclean, and anyone who touches it will be unclean until the evening.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","It was during the first month of the year that all the Israelites arrived in the Desert of Zin and set up camp in Kadesh. (This was where Miriam died and was buried.) ");
INSERT INTO engfbv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","However, there was no water there for anyone to drink, so the people gathered to confront Moses and Aaron. ");
INSERT INTO engfbv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","They argued with Moses, saying, “If only we'd died with our relatives in the Lord's presence! ");
INSERT INTO engfbv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why have you brought the Lord's people into this desert just so we and our livestock can die here? ");
INSERT INTO engfbv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why did you lead us out of Egypt to come to this awful place? Nothing grows here—no grain or figs or vines or pomegranates. And there's no water to drink!” ");
INSERT INTO engfbv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moses and Aaron left the people and went to the entrance of the Tent of Meeting. There they fell facedown on the ground, and the glory of the Lord appeared to them. ");
INSERT INTO engfbv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Take the walking stick and have the people gather around you. As they watch, you and your brother Aaron will order the rock and it will pour out water. You will bring water from the rock so the people and their livestock can drink.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moses picked up the walking stick that was kept in the Lord's presence, as he had been ordered. ");
INSERT INTO engfbv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moses and Aaron had everyone gather in front of the rock. Moses said to them, “Listen, you bunch of rebels! Do we have to bring water out of this rock for you?” ");
INSERT INTO engfbv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Then Moses picked up the walking stick and hit the rock twice. Streams of water gushed out so that the people and their livestock could drink. ");
INSERT INTO engfbv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","But the Lord told Moses and Aaron, “Because you didn't trust me enough to demonstrate how holy I am to the Israelites, you will not be the ones to lead them into the country I've given them.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","The place where the Israelites argued with the Lord was called the waters of Meribah, and was where he revealed his holiness to them. ");
INSERT INTO engfbv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moses sent messengers from Kadesh to the king of Edom, telling him, “This is what your brother Israel says. You know all about the difficulties we've faced. ");
INSERT INTO engfbv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Our forefathers went to Egypt and we lived there for a long time. The Egyptians treated us and our forefathers badly, ");
INSERT INTO engfbv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","so we called out to the Lord for help, and he heard our cries. He sent an angel and led us out of Egypt. Listen, now we are in Kadesh, a town on the border of your territory. ");
INSERT INTO engfbv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Please allow us to travel through your country. We won't cross any of your fields or vineyards, or drink water from any of your wells. We will stay on the King's Highway; we won't turn off either to the right or to the left until we have passed through your country.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But the king of Edom replied, “You are forbidden to travel through our country, otherwise we will come out and stop you by force.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","“We'll keep to the main road,” the Israelites persisted. “If we or our livestock drink your water, we'll pay you for it. That's all we want—just to pass through on foot.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But the king of Edom insisted, “You are forbidden to travel through our country!” He came out with his large and powerful army to meet the Israelites head-on. ");
INSERT INTO engfbv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Since the king of Edom refused to allow Israel to travel through his territory, the Israelites had to turn back. ");
INSERT INTO engfbv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","The Israelites all left Kadesh and traveled to Mount Hor. ");
INSERT INTO engfbv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","At Mount Hor, near the border with the country of Edom, the Lord told Moses and Aaron, ");
INSERT INTO engfbv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron will shortly join his forefathers in death. He will not enter the country I have given the Israelites, because you both disobeyed my command at the waters of Meribah. ");
INSERT INTO engfbv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Have Aaron and his son Eleazar join you and climb up Mount Hor together. ");
INSERT INTO engfbv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Take off Aaron's priestly clothes and put them on his son Eleazar. Aaron is going to die there and join his forefathers in death.” ");
INSERT INTO engfbv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses did as the Lord ordered: They climbed up Mount Hor in full view of all the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses removed the priestly clothes that Aaron was wearing and put them on Aaron's son Eleazar. Aaron died there, on the top of the mountain. Then Moses and Eleazar went back down. ");
INSERT INTO engfbv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","When the people realized that Aaron had died, they all mourned for him for thirty days. ");
INSERT INTO engfbv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","The Canaanite king of Arad who lived in the Negev learned that the Israelites were approaching on the road to Atharim. He went and attacked Israel and took some of them prisoners. ");
INSERT INTO engfbv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","So Israel made a solemn promise to the Lord: “If you hand these people over to us, we pledge to completely destroy their towns.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","The Lord responded to their appeal and handed over the Canaanites to them. The Israelites completely destroyed them and their towns, and named the place Hormah. ");
INSERT INTO engfbv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","The Israelites left Mount Hor by the road leading to the Red Sea so they could avoid traveling through the country of Edom. But the people became bad-tempered on the way ");
INSERT INTO engfbv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","and made complaints against God and against Moses, saying, “Why did you lead us out of Egypt to die in the desert? We don't have bread or water, and we hate this awful food!” ");
INSERT INTO engfbv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","So the Lord sent poisonous snakes to attack them, and many Israelites were bitten and died. ");
INSERT INTO engfbv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","The people went to see Moses and told him, “We were wrong to make complaints against the Lord and against you. Please pray to the Lord to get rid of the snakes from us.” Moses prayed to the Lord on their behalf. ");
INSERT INTO engfbv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","The Lord told Moses, “Make a model of a snake and put it on a pole. When anyone who has been bitten looks at it, they will live.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moses made a snake out of bronze and put it on a pole. Those who looked at it did live. ");
INSERT INTO engfbv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","The Israelites left and camped at Oboth. ");
INSERT INTO engfbv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Then they moved on from Oboth and camped at Iye-abarim in the desert on the east side of Moab. ");
INSERT INTO engfbv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","They left there and camped in the Valley of Zered. ");
INSERT INTO engfbv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Then they moved on from there and camped on the far side of the Arnon River, in the desert near Amorite territory. The Arnon River is the border between the Moab and the Amorites. ");
INSERT INTO engfbv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","That's why the Book of the Wars of the Lord refers to “the town of Waheb in Suphah and the canyon of the Arnon, ");
INSERT INTO engfbv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","the canyon slopes that reach the village of Ar that lies on the border with Moab.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","From there they moved on to Beer, the well where the Lord told Moses, “Have the people gather together so I can give them water.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then the Israelites sang this song: “Pour out water, well! Everyone of you sing to it! ");
INSERT INTO engfbv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","The tribal chiefs dug the well; yes the leaders of the people dug the well with their rods of authority and their walking sticks.” The Israelites left the desert and carried on to Mattanah. ");
INSERT INTO engfbv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","From Mattanah they traveled to Nahaliel, from Nahaliel to Bamoth, ");
INSERT INTO engfbv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","and from Bamoth to the valley in the territory of Moab where the top of Mount Pisgah looks down on the wastelands. ");
INSERT INTO engfbv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Then Israel sent messengers to Sihon, king of the Amorites, with the following request: ");
INSERT INTO engfbv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Please allow us to travel through your country. We won't cross any of your fields or vineyards, or drink water from any of your wells. We will stay on the King's Highway until we have passed through your country.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But Sihon refused to allow the Israelites to travel through his territory. Instead, he called out his whole army and went out to meet the Israelites head-on in the desert. When he arrived at Jahaz, he attacked the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","The Israelites defeated them, killing them with their swords. They took over his land from the Arnon River to the Jabbok River —but only as far as the border of the Ammonites, because it was well defended. ");
INSERT INTO engfbv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","The Israelites conquered all the Amorite towns and took them over, including Heshbon and its surrounding villages. ");
INSERT INTO engfbv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon was the capital of Sihon, king of the Amorites, who had fought against the previous king of Moab and had taken from him all his land as far as the Arnon River. ");
INSERT INTO engfbv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","That's why the old songwriters wrote: “Come to Heshbon and have it be rebuilt; restore the town of Sihon! ");
INSERT INTO engfbv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","For a fire blazed out from Heshbon, a flame from the town of Sihon. It burned up Ar in Moab where the rulers live on the high places of Arnon. ");
INSERT INTO engfbv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","What a disaster you face, Moab! You are all going to die, people of Chemosh! You handed over your sons as exiles and your daughters as prisoners to Sihon, king of the Amorites. ");
INSERT INTO engfbv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","But now we have defeated the Amorites! Heshbon's rule has been destroyed all the way to Dibon. We wiped them out all the way to Nophah and on to Medeba.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","The Israelites occupied the country of the Amorites. ");
INSERT INTO engfbv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moses sent men to explore Jazer. The Israelites conquered its surrounding villages and expelled the Amorites living there. ");
INSERT INTO engfbv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then they continued on the road towards Bashan. Og, king of Bashan, led his whole army out to meet them head on, and fought them at Edrei. ");
INSERT INTO engfbv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","The Lord told Moses, “You don't need to be afraid of him, because I have handed him over to you, along with all his people and his land. Do to him what you did to Sihon, king of the Amorites, who ruled from Heshbon.” ");
INSERT INTO engfbv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So they killed Og, his sons, and all his army. Nobody survived, and the Israelites took over his country. ");
INSERT INTO engfbv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","The Israelites moved on and camped on the plains of Moab east of the Jordan, opposite Jericho. ");
INSERT INTO engfbv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, son of Zippor, had seen all that the Israelites had done to the Amorites. ");
INSERT INTO engfbv_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","The Moabites were terrified of the Israelites because there were so many of them. The Moabites dreaded the arrival of the Israelites ");
INSERT INTO engfbv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","and told the leaders of Midian, “This horde will eat up everything we have, just like an ox eats up grass in the field!” (Balak son of Zippor, was king of Moab at that time.) ");
INSERT INTO engfbv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","He sent messengers to call Balaam, son of Beor, who lived in Pethor near the Euphrates River in his own country. “Listen, a group of people has arrived here who came from Egypt,” Balak said in his message to Balaam. “There are hordes of them and they present a real threat to me. ");
INSERT INTO engfbv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Please come immediately and curse these people for me, because they are stronger than me. Maybe then I'll be able to attack them and drive them out of my country because I know that whoever you bless is blessed, and whoever you curse is cursed.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","The Moabite and Midianite leaders departed, taking payment for the fortune-telling with them. When they arrived they gave Balaam the message from Balak. ");
INSERT INTO engfbv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","“Stay the night and I'll let you know the answer the Lord gives me,” Balaam told them. So the Moabite leaders stayed there with Balaam. ");
INSERT INTO engfbv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God came to Balaam and asked him, “Who are these men staying with you?” ");
INSERT INTO engfbv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam told God, “Balak, son of Zippor, the king of Moab, sent me this message: ");
INSERT INTO engfbv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Listen, a group of people has arrived here who came from Egypt. There are hordes of them. Please come immediately and curse these people for me. Maybe then I'll be able to fight them and drive them out of my country.’” ");
INSERT INTO engfbv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","But God told Balaam, “You are not to go back with them. You must not curse this people, for they are blessed.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","In the morning Balaam got up and said to Balak's messengers, “Go back to where you came from because the Lord has refused to allow me to go with you.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","The Moabite leaders left. They returned to Balak, and told him, “Balaam refused to come back with us.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Then Balak sent even more leaders who were more prestigious than before. ");
INSERT INTO engfbv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","When they arrived they told Balaam, “This is what Balak son of Zippor says: ‘Please don't let anything stop you from coming to see me, ");
INSERT INTO engfbv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","because I will pay you a great deal and follow all the advice you give me. Please come and curse these people for me!’” ");
INSERT INTO engfbv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","But Balaam told Balak's officials, “Even if Balak gave me his whole palace full of silver and gold, I couldn't disobey the command of the Lord my God in any way. ");
INSERT INTO engfbv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Now you should also stay the night so I can see if the Lord has anything else to tell me.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","God came to Balaam during the night and told him, “Since these men have come for you, get up and go with them. But only do what I tell you.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","In the morning Balaam got up, put a saddle on his donkey, and left with the Moabite leaders. ");
INSERT INTO engfbv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","God got angry because Balaam had decided to go. The angel of the Lord came and stood in the road to confront him. Balaam was riding on his donkey, and he was accompanied by his two servants. ");
INSERT INTO engfbv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","The donkey saw the angel of the Lord standing in the road holding a drawn sword, so it turned from the road and went into a field. So Balaam beat it to make it go back to the road. ");
INSERT INTO engfbv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Then the angel of the Lord stood in a narrow part of the road that passed between two vineyards, with walls on both sides. ");
INSERT INTO engfbv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","The donkey saw the angel of the Lord and tried to get past. It pushed up against the wall and crushed Balaam's foot against it. So he beat it again. ");
INSERT INTO engfbv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Then the angel of the Lord went ahead and stood in a narrow place where there was no room to get past, either on the right or the left. ");
INSERT INTO engfbv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","The donkey saw the angel of the Lord and lay down under Balaam. He got angry and beat it with his walking stick. ");
INSERT INTO engfbv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","The Lord gave the donkey the ability to speak and it said to Balaam, “What have I done to you for you to beat me three times?” ");
INSERT INTO engfbv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","“You made me look stupid!” Balaam told the donkey. “If I was holding a sword, I'd kill you now!” ");
INSERT INTO engfbv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","But the donkey asked Balaam, “Aren't I the donkey you've ridden all your life right up to today? Have I ever treated you this way before?” “No,” he admitted. ");
INSERT INTO engfbv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the Lord gave Balaam the ability to see the angel of the Lord standing in the road holding a drawn sword. Balaam bowed low and fell facedown on the ground. ");
INSERT INTO engfbv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","The angel of the Lord asked him, “Why did you beat your donkey three times? Listen, I have come to confront you because you're being obstinate. ");
INSERT INTO engfbv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","The donkey saw me and avoided me three times. If it had not avoided me, by now I definitely would have killed you and allowed the donkey to live.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","“I have sinned because I did not realize that you were standing in the road to confront me,” Balaam said to the angel of the Lord, “So if this isn't what you want, I'll go back home.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","The angel of the Lord told Balaam, “No, you can go with the men, but only say what I tell you.” So Balaam continued on with Balak's officials. ");
INSERT INTO engfbv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","When Balak found out that Balaam was on his way, he went out to meet him at the Moabite town on the border at the Arnon River, the farthest point of his territory. ");
INSERT INTO engfbv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","He said to Balaam, “Didn't you think my call for you to come was urgent? Why didn't you come to me straight away? Did you think I couldn't pay you enough?” ");
INSERT INTO engfbv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","“Look, I'm here with you now, aren't I?” Balaam replied. “But do you think I can just say anything? I can only speak the words that God gives me to say.” ");
INSERT INTO engfbv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","So Balaam went with Balak and they arrived at Kiriath-huzoth. ");
INSERT INTO engfbv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrificed cattle and sheep, and he shared the meat with Balaam and the leaders who were with him. ");
INSERT INTO engfbv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","The next morning Balak took Balaam up to Bamoth-baal. From there he could see the extent of the Israelite camp. ");
INSERT INTO engfbv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Then Balaam told Balak, “Build seven altars for me here, and prepare seven bulls and seven rams for me to sacrifice.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak did as Balaam had said, and together they offered a bull and a ram on each altar. ");
INSERT INTO engfbv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam said to Balak, “Wait here beside your burnt offering while I go and see if perhaps the Lord will come and meet with me. Whatever he reveals to me, I'll share with you.” Then Balaam left to climb up a rocky crag. ");
INSERT INTO engfbv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","God met with him there, and Balaam said. “I have built seven altars and on each altar I have offered a bull and a ram.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","The Lord gave Balaam a message to share. He told him, “Go back to Balak and this is what you are to say to him.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So he went back to Balak, who was waiting there beside his burnt offering, along with all the Moabite leaders. ");
INSERT INTO engfbv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","This is the declaration that Balaam gave: “Balak brought me from Aram; the king of Moab brought me from the mountains of the east. He said, ‘Come and curse Jacob for me! Come and condemn Israel!’ ");
INSERT INTO engfbv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","But how can I curse what God has not cursed? How can I condemn what the Lord has not condemned? ");
INSERT INTO engfbv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","For I'm looking down on them from the top of rocky crags; I'm watching them from the hills. I see a people who live on their own, different from the other nations. ");
INSERT INTO engfbv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count Jacob's descendants? They are so many they're like dust! Who can count even a quarter of the Israelites? I would like to die as a good person dies! Let the end of my life be like their end!” ");
INSERT INTO engfbv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Then Balak complained to Balaam, “What on earth have you done to me? I brought you here to curse my enemies, and now look! All you have done is bless them!” ");
INSERT INTO engfbv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","But Balaam replied, “Don't you think I should say precisely what the Lord tells me?” ");
INSERT INTO engfbv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Then Balak said to him, “Please come with me to another place where you can see them. But you'll only see a part of their camp—you won't see all of them. You can curse them for me from there.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","He took him to the field of Zophim at the top of Mount Pisgah. There he built seven altars and offered a bull and a ram on each altar. ");
INSERT INTO engfbv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam told Balak, “Wait here beside your burnt offering while I meet the Lord over there.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","The Lord met Balaam and gave him a message to share. He told him, “Go back to Balak and this is what you are to say to him.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","So he went back to Balak, who was waiting there beside his burnt offering, along with all the Moabite leaders. “What did the Lord say?” Balak asked. ");
INSERT INTO engfbv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","This is the prophecy that Balaam delivered: “Stand up, Balak, and pay attention! Listen to me, son of Zippor! ");
INSERT INTO engfbv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God isn't a human being who would lie. He's not a mere mortal who changes his mind. Does he say he's going to do something but doesn't? Does he make promises he doesn't carry out? ");
INSERT INTO engfbv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Look, I have been ordered to give a blessing. God has blessed, and I can't change that. ");
INSERT INTO engfbv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","He's not expecting anything bad will happen to Jacob; he doesn't foresee any trouble for Israel. The Lord their God is with them; they celebrate him as their king. ");
INSERT INTO engfbv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God led them out of Egypt with great power, as strong as an ox. ");
INSERT INTO engfbv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","No spell can be cast against Jacob; no magic can be used against Israel. People will talk about Jacob and Israel, saying, ‘What amazing things God has done for them!’ ");
INSERT INTO engfbv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Look! The Israelites go out hunting like a lioness; they chase like a lion. They don't rest until they eat their prey, and drink the blood of their dead victim.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Then Balak said to Balaam, “If you can't give them any curses then at least don't give them any blessings!” ");
INSERT INTO engfbv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","But Balaam replied, “Didn't I explain to you that I have to do whatever the Lord tells me?” ");
INSERT INTO engfbv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","“Please come with me and I will take you somewhere else,” Balak said. “Maybe God would let you curse them for me from there.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak took Balaam to the top of Mount Peor, which looks down on the wastelands. ");
INSERT INTO engfbv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam told Balak, “Build seven altars for me here, and prepare seven bulls and seven rams for me to sacrifice.” ");
INSERT INTO engfbv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak did what Balaam told him, and he offered a bull and a ram on each altar. ");
INSERT INTO engfbv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","When Balaam saw that the Lord wanted to bless Israel, he chose not to use divination as he had previously. Instead he turned towards the desert, ");
INSERT INTO engfbv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","and as he looked at Israel camped there according to their respective tribes, the Spirit of God came on him. ");
INSERT INTO engfbv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","He gave a declaration, saying: ");
INSERT INTO engfbv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","“This is the prophecy of Balaam, son of Beor, the prophecy of a man who sees with eyes that are wide open, the prophecy of one who hears the words of God, who sees the vision given by Almighty, who bows down in respect with open eyes. ");
INSERT INTO engfbv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","How well set out your tents are, Jacob; the places where you live, Israel! ");
INSERT INTO engfbv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","They look like wooded valleys, like gardens beside a river, like aloe trees the Lord has planted, like cedars at the water's edge. ");
INSERT INTO engfbv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","The Israelites will pour out bucketfuls of water; their descendants will have plenty of water. Their king will be greater than King Agag; their kingdom will be glorious. ");
INSERT INTO engfbv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","God led them out of Egypt with great power, as strong as an ox, destroying enemy nations, breaking their bones, piercing them with arrows. ");
INSERT INTO engfbv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","They are like a lion that crouches and lies down. They are like a lioness that nobody dares to disturb. Those who bless you will be blessed; those who curse you will be cursed.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balak got angry with Balaam, and beat his fists together. He told Balaam, “I brought you here to curse my enemies, and now look! You keep on blessing them, doing it three times. ");
INSERT INTO engfbv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Leave right now! Go home! I promised to pay you well, but the Lord has made sure you wouldn't receive any payment.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","But Balaam said to Balak, “Didn't I already explain to the messengers you sent ");
INSERT INTO engfbv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","that even if you gave me your whole palace full of silver and gold, I couldn't do anything I wanted or disobey the command of the Lord my God in any way? I can only say what the Lord tells me. ");
INSERT INTO engfbv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Listen! I'm going back home now to my own people, but first let me warn you what these Israelites are going to do to your people in the future.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Then Balaam gave a declaration, saying, “This is the prophecy of Balaam, son of Beor, the prophecy of a man whose eyes are wide open ");
INSERT INTO engfbv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","the prophecy of one who hears the words of God, who receives knowledge from the Most High, who sees the vision given by Almighty, who bows down in respect with open eyes. ");
INSERT INTO engfbv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","I see him, but this isn't now. I observe him, but this isn't close at hand. In the future a leader like a star will come from Jacob, a ruler with a scepter will come to power from Israel. He will crush the heads of the Moabites, and destroy all the people of Seth. ");
INSERT INTO engfbv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","The country of Edom will be conquered, his enemy Seir will be conquered, and the Israelites will be victorious. ");
INSERT INTO engfbv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","A ruler from Jacob will come and destroy those left in the city.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam turned his attention to the Amalekites and gave this declaration about them, saying, “Amalek was first among the nations, but they will end up being destroyed.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","He turned his attention to the Kenites and gave this declaration about them, saying, “Where you live is safe and secure, like a nest on a cliff-face. ");
INSERT INTO engfbv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","But Kain will be burned down when Assyria conquers you.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Then Balaam gave another declaration, saying, “It's a tragedy! Who can survive when God does this? ");
INSERT INTO engfbv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ships will be sent from Cyprus to attack Assyria and Eber, but they too will be permanently destroyed.” ");
INSERT INTO engfbv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Then Balaam left and returned to his own country, and Balak left too. ");
INSERT INTO engfbv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","When the Israelites were staying at Shittim the men started to have sex with Moabite women ");
INSERT INTO engfbv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","who invited them to the sacrifices made to their gods. The Israelites ate the pagan meals and bowed down before these gods. ");
INSERT INTO engfbv_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","In this way the Israelites devoted themselves in worship to Baal of Peor, and the Lord was angry with them. ");
INSERT INTO engfbv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","The Lord told Moses, “Arrest all the Israelite leaders and kill them before the Lord where everyone can see in order to turn the Lord's furious anger away from the people.” ");
INSERT INTO engfbv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses instructed Israel's judges, “Each of you has to kill all of your men who have devoted themselves to worshiping Baal of Peor.” ");
INSERT INTO engfbv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Right then an Israelite man brought a Midianite woman to his family tent in full view of Moses and all the Israelites as they were crying at the entrance to the Tent of Meeting. ");
INSERT INTO engfbv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","When he saw this, Phinehas, son of Eleazar, the son of Aaron the priest, left the assembly, grabbed a spear ");
INSERT INTO engfbv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","and followed the man into his tent. There Phinehas drove the spear through both of them, through the Israelite and on into the woman's stomach. This action stopped the plague that had started to kill the Israelites, ");
INSERT INTO engfbv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","but 24,000 had already died. ");
INSERT INTO engfbv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinehas son of Eleazar, the son of Aaron the priest, has turned my anger away from the Israelites, because out of all of them he was passionately dedicated to me, so I did not destroy the Israelites in my passionate anger. ");
INSERT INTO engfbv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","So make an announcement that I am granting him my peace agreement. ");
INSERT INTO engfbv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","It will be an agreement that ensures a permanent priesthood for him and his descendants, because he was passionately dedicated to his God and set the Israelites right.” ");
INSERT INTO engfbv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","The name of the Israelite who was killed with the Midianite woman was Zimri, son of Salu, a family leader of the tribe of Simeon. ");
INSERT INTO engfbv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","The name of the Midianite woman who was killed was Cozbi, daughter of Zur, a family leader of a Midianite tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Attack the Midianites and kill them, ");
INSERT INTO engfbv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","because they attacked you deceptively, leading you astray by using Peor and their woman Cozbi, the daughter of the Midianite leader—the woman who was killed on the day the plague came because of their devotion to Peor.” ");
INSERT INTO engfbv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","After the plague was over, the Lord told Moses and Eleazar son of Aaron the priest, ");
INSERT INTO engfbv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Census all the Israelites by family—all those twenty years of age or older who are eligible for military service in the army of Israel.” ");
INSERT INTO engfbv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","There on the plains of Moab beside the Jordan opposite Jericho, Moses and Eleazar the priest gave the order, ");
INSERT INTO engfbv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Census the men twenty years of age or older, following the instructions the Lord gave to Moses.” The following is the genealogical record of those who left the land of Egypt. ");
INSERT INTO engfbv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","These were the descendants of Reuben, Israel's firstborn: Hanoch, ancestor of the Hanochite family; Pallu, ancestor of the Palluite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, ancestor of the Hezronite family; and Carmi, ancestor of the Carmite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","These were the families descended from Reuben and they numbered 43,730. ");
INSERT INTO engfbv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu's son was Eliab, ");
INSERT INTO engfbv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","and Eliab's sons were Nemuel, Dathan, and Abiram. (It was Dathan and Abiram, leaders chosen by the Israelites, who joined the rebellion against Moses and Aaron with the followers of Korah when they rebelled against the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","The earth opened up and swallowed them down, along with Korah. His followers died when the fire burned up 250 men. What happened to them was a warning to the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","But Korah's sons didn't die.) ");
INSERT INTO engfbv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","These were the descendants of Simeon by family: Nemuel, ancestor of the Nemuelite family; Jamin, ancestor of the Jaminite family; Jachin, ancestor of the Jachinite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah, ancestor of the Zerahite family; and Shaul, ancestor of the Shaulite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","These were the families descended from Simeon and they numbered 22,200. ");
INSERT INTO engfbv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","These were the descendants of Gad by family: Zephon, ancestor of the Zephonite family; Haggi, ancestor of the Haggite family; Shuni, ancestor of the Shunite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, ancestor of the Oznite family; Eri, ancestor of the Erite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod, ancestor of the Arodite family; Areli, ancestor of the Arelite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","These were the families descended from Gad and they numbered 40,500. ");
INSERT INTO engfbv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","The sons of Judah who died in Canaan were Er and Onan. These were the descendants of Judah by family: ");
INSERT INTO engfbv_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Shelah, ancestor of the Shelanite family; Perez, ancestor of the Perezite family; Zerah, ancestor of the Zerahite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","These were the descendants of Perez: Hezron, ancestor of the Hezronite family; and Hamul, ancestor of the Hamulite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These were the families descended from Judah and they numbered 76,500. ");
INSERT INTO engfbv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","These were the descendants of Issachar by family: Tola, ancestor of the Tolaite family; Puvah, ancestor of the Punite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub, ancestor of the Jashubite family; and Shimron, ancestor of the Shimronite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These were the families descended from Isaachar and they numbered 64,300. ");
INSERT INTO engfbv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","These were the descendants of Zebulun by family: Sered, ancestor of the Seredite family; Elon, ancestor of the Elonite family; and Jahleel, ancestor of the Jahleelite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These were the families descended from Zebulun, and they numbered 60,500. ");
INSERT INTO engfbv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","These were descendants of Joseph by family through Manasseh and Ephraim: ");
INSERT INTO engfbv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","The descendants of Manasseh: Machir (he was the father of Gilead), ancestor of the Machirite family; and Gilead, ancestor of the Gileadite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","The descendants of Gilead: Iezer, ancestor of the Iezerite family; Helek, ancestor of the Helekite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, ancestor of the Asrielite family; Shechem, ancestor of the Shechemite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida, ancestor of the Shemidaite family; and Hepher, ancestor of the Hepherite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelophehad, son of Hepher, didn't have any sons, only daughters. Their names were Mahlah, Noah, Hoglah, Milcah, and Tirzah.) ");
INSERT INTO engfbv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These were the families descended from Manasseh, and they numbered 52,700. ");
INSERT INTO engfbv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","These were the descendants of Ephraim by family: Shuthelah, ancestor of the Shuthelahite family; Becher, ancestor of the Becherite family; and Tahan, ancestor of the Tahanite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","The descendant of Shuthelah was Eran, ancestor of the Eranite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These were the families descended from Ephraim, and they numbered 32,500. These families were the descendants of Joseph. ");
INSERT INTO engfbv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","These were the descendants of Benjamin by family: Bela, ancestor of the Belaite family; Ashbel, ancestor of the Ashbelite family; Ahiram, ancestor of the Ahiramite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shupham, ancestor of the Shuphamite family; and Hupham, ancestor of the Huphamite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","The descendants of Bela were Ard, ancestor of the Ardite family; and Naaman, ancestor of the Naamite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These were the families descended from Benjamin, and they numbered 45,600. ");
INSERT INTO engfbv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","These were the descendants of Dan by family: Shuham, ancestor of the Shuhamite families. ");
INSERT INTO engfbv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","They were all Shuhamite families, and they numbered 64,400. ");
INSERT INTO engfbv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","These were the descendants of Asher by family: Imnah, ancestor of the Imnite family; Ishvi, ancestor of the Ishvite family; and Beriah, ancestor of the Beriite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","The descendants of Beriah were Heber, ancestor of the Heberite family; and Malchiel, ancestor of the Malchielite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","The name of Asher's daughter was Serah. ");
INSERT INTO engfbv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These were the families descended from Asher, and they numbered 53,400. ");
INSERT INTO engfbv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","These were the descendants of Naphtali by family: Jahzeel, ancestor of the Jahzeelite family; Guni, ancestor of the Gunite family; ");
INSERT INTO engfbv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer, ancestor of the Jezerite family; and Shillem, ancestor of the Sheillemite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These were the families descended from Naphtali, and they numbered 45,400. ");
INSERT INTO engfbv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","The total of all those counted was 601,730. ");
INSERT INTO engfbv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Divide the land that is to be owned based on the number of those censused. ");
INSERT INTO engfbv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Give a larger area of land to a larger tribe, and a smaller area to a smaller tribe. Each tribe shall receive their allotment of land depending on their number counted in the census. ");
INSERT INTO engfbv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","The land has to be divided up by casting lots. Everyone shall receive their allotted land based on the name of their ancestor's tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Every allocation of land is to be divided by casting lots among the tribes, whether large or small.” ");
INSERT INTO engfbv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","These were the Levites censused by family: Gershon, ancestor of the Gershonite family; Kohath, ancestor of the Kohathite family; and Merari, ancestor of the Merarite family. ");
INSERT INTO engfbv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","The following were the families of the Levites: the Libnite family, the Hebronite family, the Mahlite family, the Mushite family, and the Korahite family. Kohath was the father of Amram, ");
INSERT INTO engfbv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","and the name of Amram's wife was Jochebed. She was a descendant of Levi, born while the Levites were in Egypt. She had children with Amram: Aaron, Moses, and their sister Miriam. ");
INSERT INTO engfbv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron's sons were Nadab, Abihu, Eleazar, and Ithamar, ");
INSERT INTO engfbv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","but Nadab and Abihu died when they offered forbidden fire in the Lord's presence. ");
INSERT INTO engfbv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","The number of the Levites censused totaled 23,000. This included every male one month old or older. However, they were not counted with the other Israelites, because no land allotment was given to them with the other Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","This is the record of those who were censused by Moses and Eleazar the priest when they counted the Israelites on the plains of Moab beside the Jordan opposite Jericho. ");
INSERT INTO engfbv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","However, they did not include a single one who had previously been censused by Moses and Aaron the priest when they counted the Israelites in the Sinai Desert, ");
INSERT INTO engfbv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","because the Lord had told them that they would all die in the desert. No one was left except Caleb, son of Jephunneh, and Joshua, son of Nun. ");
INSERT INTO engfbv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","The daughters of Zelophehad came to present their case. Their father Zelophehad was the son of Hepher, son of Gilead, son of Machir, son of Manasseh, and was from the tribe of Manasseh, son of Joseph. The names of his daughters were Mahlah, Noah, Hoglah, Milcah, and Tirzah. They came ");
INSERT INTO engfbv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","and stood before Moses, Eleazar the priest, the leaders, and all the Israelites at the entrance to the Tent of Meeting. They said, ");
INSERT INTO engfbv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died in the desert, but he wasn't one of Korah's followers who joined together to rebel against the Lord. No, he died from his own sins, and he didn't have any sons. ");
INSERT INTO engfbv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Why should our family name be lost simply because he didn't have a son? Give us land to own alongside our uncles.” ");
INSERT INTO engfbv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moses took their case before the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","The Lord gave him this answer, ");
INSERT INTO engfbv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“What the daughters of Zelophehad are saying is right. You really must give them land to own alongside their uncles—give to them what would have been allocated to their father. ");
INSERT INTO engfbv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","In addition, tell the Israelites, ‘If a man dies and doesn't have a son, give his property to his daughter. ");
INSERT INTO engfbv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","If he doesn't have a daughter, give his property to his brothers. ");
INSERT INTO engfbv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","If he doesn't have brothers, give his property to his father's brothers. ");
INSERT INTO engfbv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","If his father doesn't have any brothers, give his property to his family's next of kin so that they can own it. This is a legal regulation for the Israelites, given as an order by the Lord to Moses.’” ");
INSERT INTO engfbv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","The Lord told Moses, “Go up into the Abarim mountains so you can see the land that I have given the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","After you have seen it, you will also join your forefathers in death, just as your brother Aaron did, ");
INSERT INTO engfbv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","because when the Israelites complained in the Desert of Zin, you both rebelled against my instructions to show my holiness before them in regard to providing water.” (These were the waters of Meribah in Kadesh, in the Desert of Zin.) ");
INSERT INTO engfbv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Then Moses pleaded with the Lord, ");
INSERT INTO engfbv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“May the Lord, the God who gives life to all living beings, choose a man to lead the Israelites ");
INSERT INTO engfbv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","who will tell them what to do and show them where to go, so that the people of the Lord won't be like sheep without a shepherd.” ");
INSERT INTO engfbv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","The Lord told Moses, “Call for Joshua, son of Nun, a man who has the Spirit in him, and place your hands on him. ");
INSERT INTO engfbv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Make him stand in front of Eleazar the priest and all the Israelites, and dedicate him while they watch. ");
INSERT INTO engfbv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Hand over some of your authority to him so that all the Israelites will obey him. ");
INSERT INTO engfbv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","When he needs instructions, he is to go before Eleazar the priest who will ask the Lord on his behalf and find out the decision using the Urim. Joshua will give orders to all the Israelites concerning everything they are to do.” ");
INSERT INTO engfbv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses followed the Lord's instructions. He had Joshua come and stand in front of Eleazar the priest and all the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Moses placed his hands on Joshua and dedicated him, just as the Lord had told him to do. ");
INSERT INTO engfbv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Give the following regulations to the Israelites: You are to present to me at the appropriate times my food offerings for me to accept. ");
INSERT INTO engfbv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tell them you are to present to the Lord every day two male lambs a year old as a continual burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Offer one lamb in the morning and one in the evening before it gets dark, ");
INSERT INTO engfbv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","along with one tenth of an ephah of the best flour for a grain offering, mixed with a quarter of a hin of pressed olive oil. ");
INSERT INTO engfbv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","This is a continual burnt offering that was begun at Mount Sinai as an offering acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","The drink offering that accompanies each lamb is to be a quarter of a hin. Pour out the offering of fermented drink to the Lord in the sanctuary. ");
INSERT INTO engfbv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Offer the second lamb in the evening before it gets dark, along with the same grain and drink offerings as in the morning. It is a burnt offering acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","On the Sabbath day, present male lambs two years old, without defects, along with a grain offering of two-tenths of an ephah of the best flour mixed with olive oil, and its drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This burnt offering is to be presented every Sabbath in addition to the continual burnt offering and its drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","At the start of every month, you are to present to the Lord a burnt offering of two young bulls, one ram, and seven male lambs a year old, all of them without defects, ");
INSERT INTO engfbv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","along with grain offerings consisting of three-tenths of an ephah of the best flour mixed with olive oil for each bull, two-tenths of an ephah of the best flour mixed with olive oil for the ram, ");
INSERT INTO engfbv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","and one tenth of an ephah of the best flour mixed with olive oil for each of the lambs. This is a burnt offering acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Their respective drink offerings shall be half a hin of wine for each bull, a third of a hin for the ram, and a quarter of a hin for each lamb. This is the monthly burnt offering to be presented every month during the year. ");
INSERT INTO engfbv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","As well as the continual burnt offering with its drink offering, present a male goat to the Lord as a sin offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","The Lord's Passover is on the fourteenth day of the first month. ");
INSERT INTO engfbv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","There shall be a festival on the fifteenth day of this month, and for seven days only eat bread without yeast. ");
INSERT INTO engfbv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Hold a holy meeting on the first day of the festival. Don't do any of your normal work. ");
INSERT INTO engfbv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Present to the Lord the following offerings: a burnt offering of two young bulls, one ram, and seven male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Their grain offerings shall be made of the best flour mixed with olive oil: three-tenths of an ephah for each bull, two-tenths of an ephah for the ram, ");
INSERT INTO engfbv_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","and one tenth of an ephah for each of the seven lambs. ");
INSERT INTO engfbv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Also present a male goat as a sin offering to make you right. ");
INSERT INTO engfbv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You are to present these offerings in addition to the continual morning burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Present the same offerings every day for seven days as burnt offerings to be accepted by the Lord. They are to be offered with their drink offering and the continual burnt offering. ");
INSERT INTO engfbv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Hold a holy meeting on the seventh day of the festival. Don't do any of your normal work. ");
INSERT INTO engfbv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","During the time you celebrate the Festival of Weeks, hold a holy meeting on the day of firstfruits when you present an offering of new grain to the Lord. Don't do any of your normal work. ");
INSERT INTO engfbv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Present a burnt offering of two young bulls, one ram, and seven male lambs a year old to be accepted by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","They are to be accompanied by their grain offerings of the best flour mixed with olive oil: three-tenths of an ephah for each bull, two-tenths of an ephah for the ram, ");
INSERT INTO engfbv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","and one tenth of an ephah for each of the seven lambs. ");
INSERT INTO engfbv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Also present a male goat as an offering to make you right. ");
INSERT INTO engfbv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Present these offerings along with their drink offerings in addition to the continual burnt offering and its grain offering. Make sure the animals sacrificed have no defects.” ");
INSERT INTO engfbv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Hold a holy meeting on the first day of the seventh month. Don't do any of your normal work. This is the day when you will blow the trumpets. ");
INSERT INTO engfbv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Present a burnt offering of one young bull, one ram, and seven male lambs a year old, all of them without defects, as a sacrifice acceptable to the Lord, ");
INSERT INTO engfbv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","along with their grain offerings of the best flour mixed with olive oil: three-tenths of an ephah for the bull, two-tenths of an ephah for the ram, ");
INSERT INTO engfbv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and one tenth of an ephah for each of the seven male lambs. ");
INSERT INTO engfbv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Also present a male goat as a sin offering to make you right. ");
INSERT INTO engfbv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","These offerings are in addition to the monthly and daily burnt offerings along with their required grain offerings and drink offerings. They are burnt offerings acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Hold a holy meeting on the tenth day of this seventh month, and practice self-denial. Don't do any of your normal work. ");
INSERT INTO engfbv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Present a burnt offering of one young bull, one ram, and seven male lambs a year old, all of them without defects, acceptable to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","They are to be accompanied by their grain offerings of the best flour mixed with olive oil: three-tenths of an ephah for the bull, two-tenths of an ephah for the ram, ");
INSERT INTO engfbv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","and one tenth of an ephah for each of the seven lambs. ");
INSERT INTO engfbv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Also present a male goat as a sin offering in addition to the sin offering to make you right and the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Hold a holy meeting on the fifteenth day of the seventh month. Don't do any of your normal work. You are to celebrate a festival dedicated to the Lord for seven days. ");
INSERT INTO engfbv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Present the following as a burnt offering acceptable to the Lord: thirteen young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","They are to be accompanied by their grain offerings of the best flour mixed with olive oil: three-tenths of an ephah of the best flour mixed with olive oil for each of the thirteen bulls, two-tenths of an ephah for each of the two rams, ");
INSERT INTO engfbv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and one tenth of an ephah for each of the fourteen lambs. ");
INSERT INTO engfbv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","On the second day present twelve young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","On the third day present eleven young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","On the fourth day present ten young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","On the fifth day present nine young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","On the sixth day present eight young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","On the seventh day present seven young bulls, two rams, and fourteen male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","On the eighth day all of you are to meet together. Don't do any of your normal work. ");
INSERT INTO engfbv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Present the following as a burnt offering acceptable to the Lord: one bull, two rams, and seven male lambs a year old, all of them without defects. ");
INSERT INTO engfbv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","They are to be accompanied by their grain offerings and drink offerings for the bulls, rams, and lambs, all according to the number required. ");
INSERT INTO engfbv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Also present a male goat as a sin offering in addition to the continual burnt offering with its grain offering and drink offering. ");
INSERT INTO engfbv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Present these offerings to the Lord at the times you are required to do so, in addition to your offerings to fulfill a promise and freewill offerings, whether they are burnt offerings, grain offerings, drink offerings, or peace offerings.” ");
INSERT INTO engfbv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses repeated all this to the Israelites as the Lord ordered him to do. ");
INSERT INTO engfbv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses told the tribal leaders of Israel, “This is what the Lord commands: ");
INSERT INTO engfbv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","If a man makes a solemn promise to the Lord, or pledges to do something by swearing an oath, he must not break his promise. He must do everything he said he would. ");
INSERT INTO engfbv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","If a woman who's young and still living in her father's house makes a solemn promise to the Lord or pledges to do something by swearing an oath ");
INSERT INTO engfbv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","and her father finds out about her promise or pledge but doesn't say anything to her, all the promises or pledges she has sworn to do will stand. ");
INSERT INTO engfbv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father disallows them as soon as he finds out, then none of her promises or pledges remain valid. The Lord will release her from keeping them because her father has disallowed them. ");
INSERT INTO engfbv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","If a woman marries after having made a solemn promise or sworn an oath without thinking ");
INSERT INTO engfbv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","and her husband finds out about it but doesn't say anything to her right away, all the promises or pledges she has sworn to do will stand. ");
INSERT INTO engfbv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if her husband disallows them when he finds out about it, then none of her promises or oaths remain valid and the Lord will release her from keeping them. ");
INSERT INTO engfbv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Every solemn promise made by a widow or a woman who is divorced must be kept. ");
INSERT INTO engfbv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","If a woman living with her husband makes a solemn promise to the Lord or pledges to do something by swearing an oath, ");
INSERT INTO engfbv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","and her husband finds out about her promise or pledge but doesn't say anything to her and doesn't disallow them, then all of her promises or pledges remain valid. ");
INSERT INTO engfbv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband disallows them as soon as he finds out about it, then none of her promises or oaths remain valid. The Lord will release her from keeping them because her husband has disallowed them. ");
INSERT INTO engfbv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Her husband may also confirm or disallow any solemn promise or pledge the woman may make for self-denial. ");
INSERT INTO engfbv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","But if her husband doesn't ever say a word to her about it, then he is assumed to have confirmed all the solemn promises and pledges she has made. ");
INSERT INTO engfbv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","However, if he disallows them some time later after finding out about them, then he will bear the responsibility for her breaking them.” ");
INSERT INTO engfbv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the regulations that the Lord gave to Moses regarding the relationship between a man and his wife, and between a father and a daughter who is young and still living at home. ");
INSERT INTO engfbv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Punish the Midianites because of what they did to the Israelites. After that you will join your forefathers in death.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moses instructed the people, “Have some of your men get ready for battle, so they can go and attack the Midianites and carry out the Lord's punishment on them. ");
INSERT INTO engfbv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","You are to contribute one thousand men from each Israelite tribe.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","So one thousand men were chosen from each Israelite tribe, making twelve thousand troops ready for battle. ");
INSERT INTO engfbv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moses sent them into battle, one thousand from each tribe, together with Phinehas, son of Eleazar the priest. He carried with him the holy objects from the sanctuary and the trumpets used for giving signals. ");
INSERT INTO engfbv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","They attacked the Midianites, as the Lord had told Moses to do, and they killed all the men. ");
INSERT INTO engfbv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Among those killed were the five kings of Midian, Evi, Rekem, Zur, Hur, and Reba. They also killed Balaam, son of Beor, with the sword. ");
INSERT INTO engfbv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The Israelites captured the Midianite women and children, and they took as plunder all their herds, flocks, and possessions. ");
INSERT INTO engfbv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","They set fire to all the Midianite towns and camps where they had lived, ");
INSERT INTO engfbv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","and carried away all the plunder and loot, including people and animals. ");
INSERT INTO engfbv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","They brought the prisoners, loot, and plunder to Moses, to Eleazar the priest, and to the rest of the Israelites where they were camped on the plains of Moab, beside the Jordan opposite Jericho. ");
INSERT INTO engfbv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moses, Eleazar the priest, and all the Israelite leaders went out of the camp to meet them. ");
INSERT INTO engfbv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moses was angry with the army officers, the commanders of thousands and commanders of hundreds, who returned from the battle. ");
INSERT INTO engfbv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","“Why did you let all the women live?” he asked them. ");
INSERT INTO engfbv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","“You realize that these were the same women who seduced the Israelite men, leading them to be unfaithful to the Lord at Peor, following Balaam's advice! That's why the Lord's people suffered from the plague! ");
INSERT INTO engfbv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","So go and kill all the boys, and every woman who has slept with a man. ");
INSERT INTO engfbv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Let all the girls who are virgins live. They are yours. ");
INSERT INTO engfbv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","All those of you who killed someone or touched a dead body must stay outside the camp for seven days. Purify yourselves and your prisoners on the third day and the seventh day. ");
INSERT INTO engfbv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Also purify all your clothing and anything made of leather, goat's hair, or wood.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleazar the priest told the soldiers who had gone into battle, “These are the legal regulations that the Lord has ordered Moses to be carried out: ");
INSERT INTO engfbv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","All that's made of gold, silver, bronze, iron, tin, and lead— ");
INSERT INTO engfbv_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","anything that doesn't burn—must be put through fire to make it clean. But it still has to be purified using water of purification. Anything that burns must be put through the water. ");
INSERT INTO engfbv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Wash your clothes on the seventh day and you will be clean. Then you can enter the camp.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“You, Eleazar the priest, and the Israelite family leaders are to take a record of the people and animals that were captured. ");
INSERT INTO engfbv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Then divide them between the troops who went into battle and the rest of the Israelites. ");
INSERT INTO engfbv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Take as a contribution to the Lord from what is allocated to the troops who went into battle one out of every five hundred people, cattle, donkeys, or sheep. ");
INSERT INTO engfbv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take this from their half share and give it to Eleazar the priest as an offering to the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","From the Israelites half share, take one out of every fifty people, cattle, donkeys, or sheep, or other animals, and give them to the Levites who take care of the Lord's Tabernacle.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moses and Eleazar the priest did as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","This was the list of plunder remaining that had been looted by the troops: 675,000 sheep, ");
INSERT INTO engfbv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 cattle, ");
INSERT INTO engfbv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 donkeys, ");
INSERT INTO engfbv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and 32,000 virgins. ");
INSERT INTO engfbv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","This was the half share for those who had gone to fight: 337,500 sheep, ");
INSERT INTO engfbv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","with a contribution for the Lord of 675, ");
INSERT INTO engfbv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","36,000 cattle, with a Lord's contribution of 72, ");
INSERT INTO engfbv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","30,500 donkeys, with a Lord's contribution of 61, ");
INSERT INTO engfbv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","and 16,000 people, with a Lord's contribution of 32. ");
INSERT INTO engfbv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses gave the contribution to Eleazar the priest as an offering to the Lord as the Lord had ordered Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","The Israelites' half share left after Moses had given the half share to the troops who had gone to fight, ");
INSERT INTO engfbv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","consisted of: 337,500 sheep, ");
INSERT INTO engfbv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 cattle, ");
INSERT INTO engfbv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 donkeys, ");
INSERT INTO engfbv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and 16,000 people. ");
INSERT INTO engfbv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Moses took from the Israelites' half one out of every fifty people and animals and gave them to the Levites who take care of the Lord's Tabernacle, as the Lord had ordered him. ");
INSERT INTO engfbv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","The army officers, the commanders of thousands and commanders of hundreds, came to Moses ");
INSERT INTO engfbv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","and told him, “We, your servants, have checked the troops we command and not a single man is missing. ");
INSERT INTO engfbv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","So we have brought the Lord an offering of the gold objects each man received—armlets, bracelets, rings, earrings, and necklaces—in order that we may be right before the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moses and Eleazar the priest accepted from them all the objects made out of gold. ");
INSERT INTO engfbv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","The gold that the commanders of thousands and of hundreds gave as an offering to the Lord weighed in total 16,750 shekels. ");
INSERT INTO engfbv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(The men who had fought in the battle had each taken plunder for himself.) ");
INSERT INTO engfbv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses and Eleazar the priest accepted the gold from the commanders of thousands and of hundreds and took it into the Tent of Meeting as a memorial offering for the Israelites in the presence of the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","The tribes of Reuben and Gad had large numbers of livestock and saw that the land of Jazer and Gilead was a good place to rear them. ");
INSERT INTO engfbv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","So they came to Moses, Eleazar the priest, and the Israelite leaders and said, ");
INSERT INTO engfbv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“The towns of Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo, and Beon, ");
INSERT INTO engfbv_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","which the Lord conquered in full view of the Israelites, are well-suited for the livestock that we your servants own.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","They continued, “Please respond to our request favorably: give us this land. Don't make us cross the Jordan.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","In reply Moses asked the tribes of Gad and Reuben, “Are you expecting your brothers to go and fight while you just sit here? ");
INSERT INTO engfbv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why discourage the Israelites from crossing into the country that the Lord has given them? ");
INSERT INTO engfbv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","This is just what your fathers did when I sent them out from Kadesh-barnea to explore the land. ");
INSERT INTO engfbv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","After your fathers traveled up the valley of Eshcol and explored the land, they discouraged the Israelites, persuading them not to enter the country that the Lord had given them. ");
INSERT INTO engfbv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","As a result, they made the Lord very angry that day, and he swore this oath, ");
INSERT INTO engfbv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Not a single one of those I saved from Egypt who is twenty years old or older will ever see the land I promised with an oath to give to Abraham, Isaac, and Jacob, because they were not completely committed to me— ");
INSERT INTO engfbv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","no one except Caleb, son of Jephunneh, the Kenizzite, and Joshua, son of Nun, because they were completely committed to me.’ ");
INSERT INTO engfbv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","The Lord was angry with Israel, and made them wander around in the desert for forty years, until the whole generation who had done evil in his sight had died. ");
INSERT INTO engfbv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Now look at you, you brood of sinners who have come to take your fathers' place to make the Lord even angrier with Israel! ");
INSERT INTO engfbv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","If you give up following him, he will abandon these people in the desert once again, and their deaths will be your fault!” ");
INSERT INTO engfbv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Then the tribes of Gad and Reuben came to Moses and told him, “We would plan to build stone walls to keep our livestock safe and towns for our children. ");
INSERT INTO engfbv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","But we will still get ourselves ready for battle, and we will be prepared to lead the Israelites until they can safely occupy their land. In the meantime, our children will stay behind, living in the fortified towns to protect them from the local people. ");
INSERT INTO engfbv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We won't return to our homes until every Israelite is in possession of their allotted land. ");
INSERT INTO engfbv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","However, we won't own any land on the other side of the Jordan because we've received this land to own on this eastern side of the Jordan.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moses responded, “If this is what you will actually do, if you will get yourselves ready for battle under the Lord's direction, ");
INSERT INTO engfbv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","and if all your troops cross the Jordan with the Lord until he has driven out his enemies ahead of him, ");
INSERT INTO engfbv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","then once the country is conquered with the Lord's help then you may return, and you will have fulfilled your obligations to the Lord and to Israel. You will own this land, granted to you by the Lord. ");
INSERT INTO engfbv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","But if you fail to do this, you will clearly be sinning against the Lord, and the consequences of your sin will catch up with you. ");
INSERT INTO engfbv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Go ahead and build towns for your children and stone walls for your flocks, but make sure you do what you've promised!” ");
INSERT INTO engfbv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","The tribes of Gad and Reuben promised Moses, “Sir, we your servants will do just as you have ordered. ");
INSERT INTO engfbv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our wives and children, our livestock and all our animals, will all remain here in the towns of Gilead. ");
INSERT INTO engfbv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","But we your servants are ready for battle, and all our troops will cross over to fight with the Lord's help, just as you have said, sir.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moses gave the following instructions about them to Eleazar the priest, to Joshua, son of Nun, and to the family leaders of the tribes of Israel. ");
INSERT INTO engfbv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses told them, “If the tribes of Gad and Reuben cross the Jordan with you, with all their troops ready for battle with the Lord's help, and the land is conquered as you advance, then give them the land of Gilead to own. ");
INSERT INTO engfbv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they don't get themselves ready for battle and cross over with you, then they must accept their allotted land among you in the country of Canaan.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","The tribes of Gad and Reuben responded, “We will do just as the Lord has told us, your servants. ");
INSERT INTO engfbv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will cross over and enter the country of Canaan ready for battle with the Lord's help, so that we may have our allotted share of land on this side of the Jordan.” ");
INSERT INTO engfbv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So Moses gave to the tribes of Gad and Reuben and the half-tribe of Manasseh, son of Joseph, the kingdom of Sihon, king of the Amorites, and the kingdom of Og, king of Bashan. This land included its towns and their surrounding area. ");
INSERT INTO engfbv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","The people of Gad rebuilt Dibon, Ataroth, Aroer, ");
INSERT INTO engfbv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-shophan, Jazer, Jogbehah, ");
INSERT INTO engfbv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth-nimrah, and Beth-haran as fortified towns, and they built stone walls for their flocks. ");
INSERT INTO engfbv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The people of Reuben rebuilt Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engfbv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","as well as Nebo and Baal-meon (changing their names), and Sibmah. In fact they renamed those towns they rebuilt. ");
INSERT INTO engfbv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","The descendants of Machir, son of Manasseh, attacked Gilead and captured it. They drove out the Amorites who were living there. ");
INSERT INTO engfbv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","So Moses gave Gilead to the family of Machir, son of Manasseh, and they settled there. ");
INSERT INTO engfbv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, a descendant of Manasseh, attacked their villages and captured them. He named them the Villages of Jair. ");
INSERT INTO engfbv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah attacked Kenath and captured it, along with its villages. He named it Nobah after himself. ");
INSERT INTO engfbv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","This is a record of the journeys made by the Israelites as they left Egypt in their tribal divisions led by Moses and Aaron. ");
INSERT INTO engfbv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moses recorded the different parts of their journey as instructed by the Lord. These are the journeys they made listed in order from where they started: ");
INSERT INTO engfbv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","The Israelites left Rameses on the fifteenth day of the first month, the day after the Passover. They set out in triumph as all the Egyptians watched. ");
INSERT INTO engfbv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","The Egyptians were burying all their firstborn that the Lord had killed, for the Lord had brought down his judgments on their gods. ");
INSERT INTO engfbv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The Israelites left Rameses and set up camp at Succoth. ");
INSERT INTO engfbv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","They moved on from Succoth and set up camp at Etham, on the edge of the desert. ");
INSERT INTO engfbv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","They moved on from Etham, turning back towards Pi-hahiroth, opposite Baal-zephon, and set up camp near Migdol. ");
INSERT INTO engfbv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","They moved on from Pi-hahiroth and crossed through the middle of the sea into the desert. They traveled on for three days into the Desert of Etham and set up camp at Marah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","They moved on from Marah and arrived at Elim, where there were twelve springs of water and seventy palm trees, and set up camp there. ");
INSERT INTO engfbv_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","They moved on from Elim and set up camp beside the Red Sea. ");
INSERT INTO engfbv_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","They moved on from the Red Sea and set up camp in the Desert of Sin. ");
INSERT INTO engfbv_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","They moved on from the Desert of Sin and set up camp at Dophkah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","They moved on from Dophkah and set up camp at Alush. ");
INSERT INTO engfbv_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","They moved on from Alush and set up camp at Rephidim. There wasn't any water there for the people to drink. ");
INSERT INTO engfbv_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","They moved on from Rephidim and set up camp in the Sinai Desert. ");
INSERT INTO engfbv_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","They moved on from the Sinai Desert and set up camp at Kibroth-hattaavah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","They moved on from Kibroth-hattaavah and set up camp at Hazeroth. ");
INSERT INTO engfbv_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","They moved on from Hazeroth and set up camp at Rithmah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","They moved on from Rithmah and set up camp at Rimmon-perez. ");
INSERT INTO engfbv_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","They moved on from Rimmon-perez and set up camp at Libnah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","They moved on from Libnah and set up camp at Rissah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","They moved on from Rissah and set up camp at Kehelathah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","They moved on from Kehelathah and set up camp at Mount Shepher. ");
INSERT INTO engfbv_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","They moved on from Mount Shepher and set up camp at Haradah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","They moved on from Haradah and set up camp at Makheloth. ");
INSERT INTO engfbv_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","They moved on from Makheloth and set up camp at Tahath. ");
INSERT INTO engfbv_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","They moved on from Tahath and set up camp at Terah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","They moved on from Terah and set up camp at Mithkah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","They moved on from Mithkah and set up camp at Hashmonah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","They moved on from Hashmonah and set up camp at Moseroth. ");
INSERT INTO engfbv_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","They moved on from Moseroth and set up camp at Bene-jaakan. ");
INSERT INTO engfbv_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","They moved on from Bene-jaakan and set up camp at Hor-haggidgad. ");
INSERT INTO engfbv_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","They moved on from Hor-haggidgad and set up camp at Jotbathah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","They moved on from Jotbathah and set up camp at Abronah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","They moved on from Abronah and set up camp at Ezion-geber. ");
INSERT INTO engfbv_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","They moved on from Ezion-geber and set up camp at Kadesh in the Desert of Zin. ");
INSERT INTO engfbv_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","They moved on from Kadesh and set up camp at Mount Hor, on the edge of Edom. ");
INSERT INTO engfbv_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Aaron the priest climbed Mount Hor as the Lord had directed, and he died there on the first day of the fifth month, in the fortieth year after the Israelites had left Egypt. ");
INSERT INTO engfbv_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron was 123 when he died on Mount Hor. ");
INSERT INTO engfbv_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","(The Canaanite king of Arad, who lived in the Negev in the country of Canaan, found out that the Israelites were on their way.) ");
INSERT INTO engfbv_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","The Israelites moved on from Mount Hor and set up camp at Zalmonah. ");
INSERT INTO engfbv_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","They moved on from Zalmonah and set up camp at Punon. ");
INSERT INTO engfbv_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","They moved on from Punon and set up camp at Oboth. ");
INSERT INTO engfbv_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","They moved on from Oboth and set up camp at Iye-abarim on the border of Moab. ");
INSERT INTO engfbv_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","They moved on from Iye-abarim and set up camp at Dibon-gad. ");
INSERT INTO engfbv_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","They moved on from Dibon-gad and set up camp at Almon-diblathaim. ");
INSERT INTO engfbv_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","They moved on from Almon-diblathaim and set up camp in the mountains of Abarim opposite Nebo. ");
INSERT INTO engfbv_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","They moved on from the mountains of Abarim and set up camp on the plains of Moab beside the Jordan opposite Jericho. ");
INSERT INTO engfbv_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","There on the plains of Moab they set up camp beside the Jordan, from Beth-jeshimoth to Abel-shittim. ");
INSERT INTO engfbv_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","This was where, on the plains of Moab beside the Jordan opposite Jericho, that the Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Tell the Israelites, Once you cross the Jordan and enter the country of Canaan, ");
INSERT INTO engfbv_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","you must drive out everyone living in the land, destroy all their carved images and metal idols, and tear down all their pagan temples. ");
INSERT INTO engfbv_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","You are to take over the country and settle there, because I have given you the land and it belongs to you. ");
INSERT INTO engfbv_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","You are to divide the land and allocate it by lot to the different tribal families. Give a larger portion to a larger family, and a smaller portion to a smaller family. Each one's allocation is decided by lot, and you will all receive an allocation depending on your tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","But if you don't drive out everyone living in the land, the people you allow to remain will be like grit in your eyes and thorns in your sides. They will cause you trouble where you settle in the country. ");
INSERT INTO engfbv_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Eventually the punishment I planned for them I will inflict on you.” ");
INSERT INTO engfbv_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Give this command to the Israelites: When you enter the country of Canaan, it will be allocated to you to own with the following boundaries: ");
INSERT INTO engfbv_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","The southern extent of your country will be from the Desert of Zin along the border of Edom. Your southern border will run east from the end of the Dead Sea, ");
INSERT INTO engfbv_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","cross south of Scorpion Pass, on to Zin, and reach its southern limit south of Kadesh-barnea. Then it will go to Hazar-addar and on to Azmon. ");
INSERT INTO engfbv_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","There the boundary will turn from Azmon to the Wadi of Egypt, ending at the Mediterranean Sea. ");
INSERT INTO engfbv_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Your western border will be the coast of the Mediterranean Sea. This is to be your boundary to the west. ");
INSERT INTO engfbv_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Your northern border will run from the Mediterranean Sea straight to Mount Hor. ");
INSERT INTO engfbv_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","From Mount Hor the boundary will go to Lebo-hamath, then on to Zedad, ");
INSERT INTO engfbv_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","to Ziphron, ending at Hazar-enan. This will be your boundary to the north. ");
INSERT INTO engfbv_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Your eastern border will run straight from Hazar-enan to Shepham ");
INSERT INTO engfbv_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Then the boundary will go down from Shepham to Riblah on the east side of Ain. It will pass down along the slopes east of the Sea of Galilee. ");
INSERT INTO engfbv_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Then the boundary will go down along the Jordan, ending at the Dead Sea. This is to be your land with its surrounding borders.” ");
INSERT INTO engfbv_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moses gave the order to the Israelites, “Allocate ownership of this land by lot. The Lord has commanded it to be given to the nine and a half tribes. ");
INSERT INTO engfbv_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","The tribes of Reuben and Gad, together with the half-tribe of Manasseh, have already received their allocation. ");
INSERT INTO engfbv_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","These two and a half tribes have received their allocation on the east side of the Jordan opposite Jericho.” ");
INSERT INTO engfbv_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“These are the names of the men who will be in charge of allocating ownership of the land for you: Eleazar the priest and Joshua, son of Nun. ");
INSERT INTO engfbv_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Have one leader from each tribe help in the distribution of the land. ");
INSERT INTO engfbv_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","These are their names: From the tribe of Judah: Caleb, son of Jephunneh. ");
INSERT INTO engfbv_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","From the tribe of Simeon: Shemuel, son of Ammihud. ");
INSERT INTO engfbv_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","From the tribe of Benjamin: Elidad, son of Chislon. ");
INSERT INTO engfbv_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","A leader from the tribe of Dan: Bukki, son of Jogli. ");
INSERT INTO engfbv_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","A leader from the tribe of Manasseh, son of Joseph: Hanniel son of Ephod. ");
INSERT INTO engfbv_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","A leader from the tribe of Ephraim: Kemuel, son of Shiphtan. ");
INSERT INTO engfbv_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","A leader from the tribe of Zebulun: Eli-zaphan, son of Parnach. ");
INSERT INTO engfbv_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","A leader from the tribe of Issachar: Paltiel, son of Azzan. ");
INSERT INTO engfbv_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","A leader from the tribe of Asher: Ahihud, son of Shelomi. ");
INSERT INTO engfbv_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","A leader from the tribe of Naphtali: Pedahel, son of Ammihud.” ");
INSERT INTO engfbv_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","These are the names of those the Lord put in charge of allocating land ownership in the country of Canaan. ");
INSERT INTO engfbv_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","The Lord spoke to Moses on the plains of Moab beside the Jordan opposite Jericho. He told him, ");
INSERT INTO engfbv_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Order the Israelites to provide from their land allocation towns for the Levites to live in and pastures around the towns. ");
INSERT INTO engfbv_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","The towns are for them to live in, and the pastures will be for their herds and their flocks—for all their livestock. ");
INSERT INTO engfbv_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","The pastures around the towns you give to the Levites are to extend out from the wall a thousand cubits on all sides. ");
INSERT INTO engfbv_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Measure two thousand cubits outside the town on the east, two thousand on the south, two thousand on the west, and two thousand on the north, with the town in the middle. These larger areas will be their pastures around the towns. ");
INSERT INTO engfbv_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Six of the towns you give the Levites are to be sanctuary towns, where a person who kills someone can run for protection. As well as these towns, give the Levites forty-two more. ");
INSERT INTO engfbv_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","The total number of towns you are to give the Levites is forty-eight, along with their pastures. ");
INSERT INTO engfbv_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","The towns that you allocate to be given to the Levites from the territory of the Israelites will be more from a larger tribe and less from a smaller one. The number will be in proportion to the size of the land allocation of each tribe.” ");
INSERT INTO engfbv_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","The Lord told Moses, ");
INSERT INTO engfbv_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Tell the Israelites: ‘When you cross over the Jordan into Canaan, ");
INSERT INTO engfbv_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","choose towns as your sanctuary towns, so a person who kills someone by mistake may run there. ");
INSERT INTO engfbv_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","These towns will be for you places of sanctuary from those seeking revenge, so that the killer will not die until they are tried in court. ");
INSERT INTO engfbv_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","The towns you choose will be your six sanctuary towns. ");
INSERT INTO engfbv_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Choose three cities on the other side of the Jordan and three in Canaan as cities of refuge. ");
INSERT INTO engfbv_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","These six cities will be places of sanctuary for the Israelites and for foreigners or settlers among them, so that anyone who kills a person by mistake may run there. ");
INSERT INTO engfbv_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","But if anyone deliberately hits someone with something made of iron and kills them, that person is a murderer and must be executed. ");
INSERT INTO engfbv_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","If anyone picks up something made of stone that could be used as a weapon and hits someone with it, and kills them, that person is a murderer and must be executed. ");
INSERT INTO engfbv_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","If anyone picks up something made of wood that could be used as a weapon and hits someone with it, and kills them, that person is a murderer and must be executed. ");
INSERT INTO engfbv_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","The avenger is to execute the murderer. When he finds the murderer, he is to kill him. ");
INSERT INTO engfbv_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Similarly, if anyone hates someone and knocks them down or deliberately throws something at them, and they're killed; ");
INSERT INTO engfbv_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","or if someone hits another with his hand and they die, the one who hit him must be executed because he is a murderer. When the avenger finds the murderer, he is to kill him. ");
INSERT INTO engfbv_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","But if anyone knocks someone else down without meaning to and without hating them, or throws something at them not meaning to hurt them, ");
INSERT INTO engfbv_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","or carelessly drops a heavy stone that kills them, but not as an enemy or intending to harm them, ");
INSERT INTO engfbv_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","then the community must judge between the killer and the avenger following these regulations. ");
INSERT INTO engfbv_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","The court is to protect the killer from being attacked by the avenger and must return him to the sanctuary town that he ran to, and he must stay there until the death of the high priest, who was anointed with holy oil. ");
INSERT INTO engfbv_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","But if the killer ever leaves the limits of the sanctuary town where he ran to, ");
INSERT INTO engfbv_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","and the avenger finds him outside his sanctuary town and kills him, then the avenger will not be guilty of murder, ");
INSERT INTO engfbv_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","because the killer has to stay in his sanctuary town until the death of the high priest. Only after the death of the high priest is he allowed to return to the land he owns. ");
INSERT INTO engfbv_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","These regulations apply to all future generations wherever you live. ");
INSERT INTO engfbv_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","If anyone kills a person, the murderer is to be executed based on the evidence given by witnesses, plural. No one is to be executed based on the evidence given by a single witness. ");
INSERT INTO engfbv_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","You are not to accept payment instead of executing a murderer who has been found guilty—they must be executed. ");
INSERT INTO engfbv_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Also you are not allowed to accept payment for a person who runs to a sanctuary town and permit him to return and live on his own land before the death of the high priest. ");
INSERT INTO engfbv_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Don't pollute the land where you live because bloodshed pollutes the land, and the land where blood is shed can't be purified except by the blood of the one who shed it. ");
INSERT INTO engfbv_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Don't make the land impure where you live because I live there too. I am the Lord, and I live with the Israelites.’” ");
INSERT INTO engfbv_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","The family heads of the descendants of Gilead, son of Machir, son of Manasseh, one of the tribes of Joseph, came and spoke before Moses and the Israelite leaders, the heads of families. ");
INSERT INTO engfbv_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","They said, “When the Lord ordered you, my lord, to allocate land ownership to the Israelites by lot, he also ordered you to give our brother Zelophehad's share to his daughters. ");
INSERT INTO engfbv_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","However, if they marry men from the other tribes of Israel, their allocation would be taken away from our fathers' share and added to the tribe of the men they marry. That part of our allocation would be lost to us. ");
INSERT INTO engfbv_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","So when the Jubilee for the Israelites comes around, their allocation would be added to the tribe into which they marry, and taken away from our fathers' tribe.” ");
INSERT INTO engfbv_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Following what the Lord told him, Moses gave these orders to the Israelites, “What the tribe of the sons of Joseph says is right. ");
INSERT INTO engfbv_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","This is what the Lord has ordered in regard to Zelophehad's daughters: They can marry anyone they want as long as they marry within a family that belongs to their father's tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","No land allocation in Israel may be passed from tribe to tribe, because every Israelite is to hold onto the allocation of his father's tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Every daughter who possesses an inheritance from any Israelite tribe must marry within a clan of the tribe of her father, so that every Israelite will possess the inheritance of his fathers. ");
INSERT INTO engfbv_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","No land allocation may be passed from one tribe to another, for each Israelite tribe must hold onto its own allocation.” ");
INSERT INTO engfbv_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Zelophehad's daughters followed the Lord's orders through Moses. ");
INSERT INTO engfbv_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Mahlah, Tirzah, Hoglah, Milcah, and Noah, Zelophehad's daughters, married cousins on their father's side. ");
INSERT INTO engfbv_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","They married within the families of the descendants of Manasseh, son of Joseph, and their land allocation stayed within their father's tribe. ");
INSERT INTO engfbv_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","These are the orders and regulations that the Lord gave the Israelites through Moses on the plains of Moab beside the Jordan opposite Jericho. ");
INSERT INTO engfbv_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","This is the record of what Moses told all the Israelites during their time in the desert to the east of the Jordan. They were in the Arabah near Suph, between Paran on the one side and Tophel, Laban, Hazeroth, and Di-zahab on the other. ");
INSERT INTO engfbv_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(It takes eleven days to go from Horeb to Kadesh-barnea by the road that passes Mount Seir.) ");
INSERT INTO engfbv_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","On the first day of the eleventh month of the fortieth year, Moses recounted to the Israelites everything that the Lord had instructed him to tell them. ");
INSERT INTO engfbv_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","This happened after he defeated Sihon king of the Amorites, who ruled in Heshbon, and then at Edrei after he defeated Og king of Bashan, who ruled in Ashtaroth. ");
INSERT INTO engfbv_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Speaking on the east side of the Jordan in the land of Moab, Moses began to explain these instructions, saying: ");
INSERT INTO engfbv_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","The Lord our God told us at Horeb: “You have remained here beside this mountain for long enough. ");
INSERT INTO engfbv_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Continue your journey and go to the hill country of the Amorites and all their neighbors, into the Jordan Valley, into the hill country, into the foothills, into the Negev, and along the coast to the country of the Canaanites up to Lebanon, as far as the great River Euphrates. ");
INSERT INTO engfbv_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Look, I'm giving this land to you. Go and take ownership of the land that the Lord promised he would give to your fathers Abraham, Isaac, and Jacob, and to their descendants who would follow them.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","That's when I told you, “I can't take responsibility for all of you by myself. ");
INSERT INTO engfbv_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","The Lord your God has increased your numbers so much that today there are as many of you as there are stars in the sky. ");
INSERT INTO engfbv_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","May the Lord, the God of your forefathers, multiply you a thousand times and bless you as he has promised. ");
INSERT INTO engfbv_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","But how can I take on all your troubles, burdens, and arguments just by myself? ");
INSERT INTO engfbv_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","You must choose for yourselves wise, experienced men with good judgment from each of your tribes, and I will put them in charge as your leaders.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","You replied to me, saying, “Your proposal is a good one.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","So I summoned your tribal leaders, men with good judgment, and put them in charge of you, as commanders and officials for your tribes. Some were responsible for thousands, some for hundreds, some for fifties, and some for tens. ");
INSERT INTO engfbv_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","At the same time I gave strict instructions to your judges: “Hear the cases brought between your brothers, and make sure you are fair when you judge between a man and his brother or a foreigner living among you. ");
INSERT INTO engfbv_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Don't show any favoritism when you judge—treat the powerful and the common people just the same. Don't let anyone intimidate you, because judgment is done on God's behalf. Bring me any case that is too hard for you, and I will hear it.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","This was also the time I instructed you about everything you had to do. ");
INSERT INTO engfbv_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Following the orders of the Lord our God, we left Horeb and set off towards the hill country of the Amorites, passing through the whole of the large and terrifying desert that you yourselves have experienced. When we reached Kadesh-barnea, ");
INSERT INTO engfbv_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","I explained to you, “You have reached the hill country of the Amorites, which the Lord our God is giving to us. ");
INSERT INTO engfbv_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Look, the Lord your God has given you the land! Go and take ownership of the land as the Lord, the God of your forefathers, has told you. Don't be frightened or terrified.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Then you all came to me and suggested, “Let's send men on ahead to explore the land and report back to us about what route to take and which towns we'll come across.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","It seemed like a good plan to me, so I chose twelve of your men, one from each tribe. ");
INSERT INTO engfbv_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","They set off and went up into the hill country as far as the Valley of Eshcol, exploring the land. ");
INSERT INTO engfbv_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","They brought back some of the country's fruit, carrying it down to us, and gave us the report: “The Lord our God is giving us good land.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","But you didn't want to go. You rebelled against the instructions of the Lord your God. ");
INSERT INTO engfbv_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","You complained while you were in your tents and said, “It's because the Lord hates us that he led us out of Egypt in order to hand us over to the Amorites to be wiped out. ");
INSERT INTO engfbv_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Where are we going? Our brothers terrified us because they told us: ‘The people are bigger and taller than us; the towns are large, with high walls that reach the sky. We even saw the descendants of the giant Anak there!’” ");
INSERT INTO engfbv_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","So I told you, “Don't be frightened or scared of them! ");
INSERT INTO engfbv_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","The Lord your God who leads your way will fight for you in the same way you saw him do for you in Egypt. ");
INSERT INTO engfbv_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","He did the same in the desert—you saw how the Lord your God carried you like a father carries his son during your whole journey until you arrived here.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Despite all this, you didn't trust the Lord your God, ");
INSERT INTO engfbv_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","who led you on the journey, present in the fire by night and in the cloud by day, looking to find a place for you to camp and to show you the way to go. ");
INSERT INTO engfbv_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","When the Lord heard what you were saying, he got angry and swore an oath: ");
INSERT INTO engfbv_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Not a single one of this evil generation will see the good land I promised to give your forefathers, ");
INSERT INTO engfbv_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","except Caleb, son of Jephunneh. He will see it, and I will give him and his descendants the land he explored, because he was completely committed to the Lord.” ");
INSERT INTO engfbv_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","The Lord also got angry with me because of you. He told me, “Even you won't enter the country. ");
INSERT INTO engfbv_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","However, Joshua, son of Nun, your assistant, will enter it. Encourage him, for he will help Israel to occupy the land. ");
INSERT INTO engfbv_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Your small children that you claimed would become prisoners, your children who at the