﻿USE sofia;
DROP TABLE IF EXISTS sofia.engf35_vpl;
CREATE TABLE engf35_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engf35_vpl WRITE;
INSERT INTO engf35_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A genealogy of Jesus Christ, son of David, son of Abraham: ");
INSERT INTO engf35_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham begot Isaac, then Isaac begot Jacob, then Jacob begot Judah and his brothers; ");
INSERT INTO engf35_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","then Judah begot Perez and Zerah by Tamar, then Perez begot Hezron, then Hezron begot Ram; ");
INSERT INTO engf35_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","then Ram begot Amminadab, then Amminadab begot Nahshon, then Nahshon begot Salmon; ");
INSERT INTO engf35_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","then Salmon begot Boaz by Rahab, then Boaz begot Obed by Ruth, then Obed begot Jesse, ");
INSERT INTO engf35_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","then Jesse begot David the king. Then King David begot Solomon by her who was of Uriah, ");
INSERT INTO engf35_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","then Solomon begot Rehoboam, then Rehoboam begot Abijah, then Abijah begot Asa; ");
INSERT INTO engf35_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","then Asa begot Jehoshaphat, then Jehoshaphat begot Joram, then Joram begot Uzziah; ");
INSERT INTO engf35_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","then Uzziah begot Jotham, then Jotham begot Ahaz, then Ahaz begot Hezekiah; ");
INSERT INTO engf35_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","then Hezekiah begot Manasseh, then Manasseh begot Amon, then Amon begot Josiah; ");
INSERT INTO engf35_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","then Josiah begot Jeconiah and his brothers about the time of the Babylonian captivity. ");
INSERT INTO engf35_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","After the Babylonian captivity Jeconiah begot Shealtiel, then Shealtiel begot Zerubbabel; ");
INSERT INTO engf35_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","then Zerubbabel begot Abiud, then Abiud begot Eliakim, then Eliakim begot Azor; ");
INSERT INTO engf35_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","then Azor begot Zadok, then Zadok begot Achim, then Achim begot Eliud; ");
INSERT INTO engf35_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","then Eliud begot Eleazar, then Eleazar begot Matthan, then Matthan begot Jacob; ");
INSERT INTO engf35_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","then Jacob begot Joseph the husband of Mary, by whom was begotten Jesus, who is called Christ. ");
INSERT INTO engf35_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","So all the generations from Abraham to David are fourteen generations, and from David until the Babylonian captivity are fourteen generations, and from the Babylonian captivity until the Christ are fourteen generations. ");
INSERT INTO engf35_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Now the birth of Jesus Christ was like this: After His mother Mary was betrothed to Joseph, before they joined together, she was found to be pregnant by the Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Then Joseph her husband, being a just man and not wanting to humiliate her publicly, decided to repudiate her secretly. ");
INSERT INTO engf35_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","But while he pondered these things, wow, an angel of the Lord appeared to him in a dream saying: “Joseph, son of David, do not be afraid to receive Mary as your wife, because that which has been conceived in her is of the Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","And she will give birth to a Son and you will call His name Jesus, because He will save His people from their sins.” ");
INSERT INTO engf35_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Now all this happened so that what was spoken by the Lord through the prophet should be fulfilled, namely: ");
INSERT INTO engf35_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Behold, the virgin will become pregnant and bear a Son, and they shall call His name Emmanuel”, which being translated is, ‘God with us’. ");
INSERT INTO engf35_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Then Joseph, being aroused from sleep, did as that angel of the Lord commanded him and received his wife, ");
INSERT INTO engf35_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","but did not know her until she had given birth to her son, the firstborn. And he called His name JESUS. ");
INSERT INTO engf35_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Now after Jesus was born in Bethlehem of Judea, in the days of Herod the king, behold, wise men magi from the East came into Jerusalem, ");
INSERT INTO engf35_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","saying: “Where is he who has been born King of the Jews? For we saw his star in the East and have come to worship him.” ");
INSERT INTO engf35_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","When Herod the king heard it he became agitated, and all Jerusalem with him. ");
INSERT INTO engf35_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","And gathering all the chief priests and scribes of the people, he inquired of them where the Christ was to be born. ");
INSERT INTO engf35_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","So they said to him: “In Bethlehem of Judea, for thus it stands written by the prophet: ");
INSERT INTO engf35_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘And you, Bethlehem, land of Judah, are not at all the least among the rulers of Judah, for out of you will come a Ruler who will shepherd my people Israel.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Then Herod, calling the wise men secretly, determined from them the time when the star appeared. ");
INSERT INTO engf35_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","And directing them to Bethlehem he said, “When you get there, search carefully for the young child; and should you find him, bring back word to me, so that I also may go and worship him.” ");
INSERT INTO engf35_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","So having heard the king they departed, and there was the star that they had seen in the East! It went before them until it arrived and stopped above where the young Child was. ");
INSERT INTO engf35_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Now when they saw the star they rejoiced with exceedingly great joy! ");
INSERT INTO engf35_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","And coming into the house they saw the young Child with Mary His mother, and falling down they worshiped Him; and opening their treasures they presented gifts to Him: gold, frankincense and myrrh. ");
INSERT INTO engf35_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Then, having been warned in a dream not to return to Herod, they departed for their own country by a different road. ");
INSERT INTO engf35_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Now when they had departed, again, an angel of the Lord appeared to Joseph in a dream saying: “Get up, take the young Child and His mother, flee to Egypt and stay there until I tell you; because Herod is about to seek the young Child to destroy Him!” ");
INSERT INTO engf35_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","So he got up and took the young Child and His mother by night and departed for Egypt. ");
INSERT INTO engf35_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","And he was there until the death of Herod, so that what was spoken by the Lord through the prophet should be fulfilled, namely: “Out of Egypt I called my Son.” ");
INSERT INTO engf35_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Then Herod, when he saw that he had been deceived by the wise men, became very angry, and he sent out and killed all the boys who were in Bethlehem and in all its districts, from two years old and under, according to the time which he had determined from the wise men. ");
INSERT INTO engf35_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Then what was spoken by Jeremiah the prophet was fulfilled, namely: ");
INSERT INTO engf35_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A voice was heard in Ramah, lamentation, weeping and great mourning; Rachel weeping for her children and not wanting to be comforted, because they are no more.” ");
INSERT INTO engf35_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Now Herod having died, there, an angel of the Lord appeared in a dream to Joseph in Egypt ");
INSERT INTO engf35_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","saying: “Get up, take the young Child and His mother and go into the land of Israel, for those seeking the life of the young Child have died.” ");
INSERT INTO engf35_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","So he got up and took the young Child and His mother and went into the land of Israel. ");
INSERT INTO engf35_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","But hearing that Archelaus was reigning over Judea instead of his father Herod, he was afraid to go there. And being warned in a dream he proceeded into the region of Galilee. ");
INSERT INTO engf35_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","And upon arriving he settled in a city called Natsareth Branch-town, so that what was spoken through the prophets should be fulfilled, that He would be called a Natsorean Branch-man. ");
INSERT INTO engf35_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Now in those days John the Baptizer began preaching in the wilderness of Judea ");
INSERT INTO engf35_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","and saying, “Repent, for the kingdom of the heavens has come near!” ");
INSERT INTO engf35_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","For this is he who was referred to by the prophet Isaiah, saying: “A voice crying-out, ‘Prepare in the wilderness the way of the Lord, make His paths straight.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Now John actually used clothes made from camel's hair and a leather belt around his waist; while his food was locusts and wild honey. ");
INSERT INTO engf35_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Then Jerusalem, all Judea and all the region of the Jordan went out to him, ");
INSERT INTO engf35_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","and were being baptized by him in the Jordan, confessing their sins. ");
INSERT INTO engf35_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","But seeing many of the Pharisees and Sadducees coming to his baptism, he said to them: “Brood of vipers! Who tipped you off to flee from the coming wrath? ");
INSERT INTO engf35_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Therefore produce fruit worthy of repentance, ");
INSERT INTO engf35_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","and don't even think to say within yourselves, ‘We have Abraham as father,’ for I say to you that God is able to raise up children to Abraham from these stones. ");
INSERT INTO engf35_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Indeed, already the ax is being laid to the root of the trees. So every tree not producing good fruit is cut down and thrown into the fire. ");
INSERT INTO engf35_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“I baptize you with water unto repentance, but the One coming after me is mightier than I, whose sandals I am not worthy to carry. He will baptize you with Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","His winnowing shovel is in His hand, and He will thoroughly clean out His threshing floor and gather His wheat into the barn; but He will burn up the chaff with unquenchable fire.” ");
INSERT INTO engf35_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Then Jesus came from Galilee to John at the Jordan to be baptized by him. ");
INSERT INTO engf35_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","But John tried to dissuade Him saying, “I have need to be baptized by You, and You are coming to me?” ");
INSERT INTO engf35_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","But in answer Jesus said to him, “Permit it now, because thus it is appropriate to us to fulfill all righteousness.” Then he permitted Him. ");
INSERT INTO engf35_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","And having been baptized Jesus came up directly from the water, when wow, the heavens were opened to Him, and he saw the Spirit of God coming down like a dove and alighting upon Him. ");
INSERT INTO engf35_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","And wow, a Voice from the heavens saying, “This is my Son, the beloved, in whom I am always well pleased!” ");
INSERT INTO engf35_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Then Jesus was led up by the Spirit into the wilderness to be tested by the devil. ");
INSERT INTO engf35_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","And having fasted forty days and forty nights, afterward He was hungry. ");
INSERT INTO engf35_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","And coming to Him the tempter said, “Since you are the Son of God, command that these stones become loaves of bread.” ");
INSERT INTO engf35_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","But in answer He said, “It is written: ‘Man shall not live on bread alone, but by every word coming out of God's mouth.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Then the devil takes Him into the holy city and sets Him upon the pinnacle of the temple, ");
INSERT INTO engf35_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","and says to Him, “Since you are the Son of God, throw yourself down; for it is written: ‘He will give orders to His angels about you, and they will lift you up on their hands, lest you strike your foot against a stone.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus said to him, “It is also written: ‘You shall not test the Lord your God!’ ” ");
INSERT INTO engf35_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Again the devil takes Him to a very high mountain and shows Him all the kingdoms of the world and their glory. ");
INSERT INTO engf35_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","And he says to Him, “All these things I will give to you, if You will fall down and worship me.” ");
INSERT INTO engf35_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Then Jesus says to him: “Get behind me, Satan! For it is written: ‘You shall worship the Lord your God, and Him only shall you serve.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Then the devil leaves Him, and then, angels came and began ministering to Him. ");
INSERT INTO engf35_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Now hearing that John had been put in prison, Jesus departed into Galilee. ");
INSERT INTO engf35_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","And leaving Natsareth behind, He went and took up residence in Capernaum by the sea, in the regions of Zebulun and Naphtali; ");
INSERT INTO engf35_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","so that what was spoken through Isaiah the prophet should be fulfilled, namely: ");
INSERT INTO engf35_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Land of Zebulun and land of Naphtali, way of the sea, beyond the Jordan, Galilee of the nations! ");
INSERT INTO engf35_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","The people sitting in darkness saw a great light, and upon those sitting in the place and shadow of death light has dawned.” ");
INSERT INTO engf35_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","From then on Jesus began to preach and to say, “Repent, for the kingdom of the heavens has come near.” ");
INSERT INTO engf35_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","And walking by the Sea of Galilee He saw two brothers, Simon (the one called Peter) and Andrew his brother, casting a circular net into the sea (for they were fishermen). ");
INSERT INTO engf35_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","And He says to them, “Follow me and I will make you fishers of men.” ");
INSERT INTO engf35_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","So leaving the nets immediately they followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","And going on from there He saw two other brothers, James (the one of Zebedee) and John his brother, in the boat with Zebedee their father, mending their nets. And He called them. ");
INSERT INTO engf35_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","So leaving the boat and their father immediately they followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus went about all Galilee, teaching in their synagogues and proclaiming the Gospel of the Kingdom, and healing every disease and every illness among the people. ");
INSERT INTO engf35_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","So His fame went throughout all Syria; and they brought to Him all who were sick—suffering with various diseases and torments, and being demonized and being moonstruck, and paralytics—and He healed them. ");
INSERT INTO engf35_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","So large crowds followed Him—from Galilee and Decapolis and Jerusalem and Judea and beyond the Jordan. ");
INSERT INTO engf35_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Now seeing the crowds He went up on the mountain, and upon His sitting down His disciples approached Him. ");
INSERT INTO engf35_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","And opening His mouth He started teaching them, saying: ");
INSERT INTO engf35_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blessed are the poor in spirit, for theirs is the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Blessed are those who mourn, for they will be comforted. ");
INSERT INTO engf35_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Blessed are the meek, for they will inherit the earth. ");
INSERT INTO engf35_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Blessed are those hungering and thirsting for righteousness, for they will be filled. ");
INSERT INTO engf35_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Blessed are the merciful, for they will be shown mercy. ");
INSERT INTO engf35_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Blessed are the pure in heart, for they will see God. ");
INSERT INTO engf35_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Blessed are the peacemakers, for they will be called sons of God. ");
INSERT INTO engf35_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Blessed are those who have been persecuted on account of righteousness, for theirs is the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Blessed are you when they revile and persecute you, and speak all kinds of evil against you, lying, because of Me. ");
INSERT INTO engf35_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rejoice and exult, because your reward in the heavens is great, for so they persecuted the prophets who were before you. ");
INSERT INTO engf35_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","You are the salt of the earth; but if the salt becomes insipid with what will it be salted? It is then good for nothing except to be thrown out and trampled down by the people. ");
INSERT INTO engf35_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","You are the light of the world. A city located upon a hill cannot be hidden. ");
INSERT INTO engf35_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nor do they light a lamp and place it under the hamper, but on the lampstand, and it shines on everything in the house. ");
INSERT INTO engf35_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","So also let your light shine before the people, so that they may see your good works and may glorify your Father, who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Do not suppose that I came to destroy the Law or the Prophets; I did not come to destroy but to fulfill. ");
INSERT INTO engf35_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","For assuredly I say to you, until heaven and earth pass away, not one iota nor one tittle shall pass away from the Law until everything happens. ");
INSERT INTO engf35_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Therefore, whoever annuls one of the least of these commandments and teaches that to the people will be called least in the kingdom of the heavens; but whoever does and teaches them, he will be called great in the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","For I say to you that unless your righteousness exceeds that of the scribes and Pharisees you will absolutely not enter the kingdom of the heavens! ");
INSERT INTO engf35_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“You have heard that it was said to the ancients, ‘You shall not murder, so whoever murders will be liable to the judgment.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","But I say to you that whoever gets angry with his brother without cause will be liable to the judgment. And whoever says to his brother, ‘Numbskull!’ will be liable to the council. But whoever says, ‘You absolute idiot!’ will be liable to hell fire. ");
INSERT INTO engf35_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Therefore, if you bring your gift to the altar and there remember that your brother has something against you, ");
INSERT INTO engf35_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","leave your gift there before the altar and go; first be reconciled with your brother and then, returning, offer your gift. ");
INSERT INTO engf35_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Be agreeable to your adversary quickly, while you are on the way with him, lest the adversary hand you over to the judge, and the judge hand you over to the officer, and you be thrown into prison. ");
INSERT INTO engf35_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Assuredly I say to you, you will by no means get out of there until you have paid the last penny. ");
INSERT INTO engf35_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“You have heard that it was said, ‘You shall not commit adultery.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","But I say to you that whoever looks at a woman to lust for her has already committed adultery with her in his heart. ");
INSERT INTO engf35_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","So if your right eye is causing you to fall, tear it out and throw it away; because it is better for you that one of your members perish than that your whole body be thrown into hell. ");
INSERT INTO engf35_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","And if your right hand is causing you to fall, cut it off and throw it away; because it is better for you that one of your members perish than that your whole body be thrown into hell. ");
INSERT INTO engf35_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","It was said, ‘Whoever divorces his wife, let him give her a certificate of divorce.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","But I say to you that whoever divorces his wife, except for a case of fornication, causes her to commit adultery, and whoever marries a divorced woman commits adultery. ");
INSERT INTO engf35_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Again you have heard that it was said to the ancients: ‘You shall not swear falsely, but you shall perform your oaths to the Lord.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","But I say to you not to swear at all: neither by heaven, because it is God's throne; ");
INSERT INTO engf35_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nor by the earth, because it is a stool for His feet; nor by Jerusalem, because it is the city of the great King. ");
INSERT INTO engf35_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nor shall you swear by your head, because you cannot make one hair white or black. ");
INSERT INTO engf35_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","But let your word be ‘yes yes’, ‘no no’; for whatever is more than these is from the malignant one. !! ");
INSERT INTO engf35_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“You have heard that it was said: ‘An eye for an eye, and a tooth for a tooth.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","But I say to you not to resist the evildoer; but whoever slaps you on your right cheek, turn the other to him also. ");
INSERT INTO engf35_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","“And if someone wants to sue you and take your tunic, let him have the cloak as well. ");
INSERT INTO engf35_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","And whoever compels you to go one mile, go with him two. ");
INSERT INTO engf35_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Give to him who asks you, and do not turn away from him who wants to borrow from you. ");
INSERT INTO engf35_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“You have heard that it was said: ‘You shall love your neighbor and hate your enemy.’ ");
INSERT INTO engf35_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","But I say to you: love your enemies, bless those who curse you, do good to those who hate you, and pray for those who mistreat you and persecute you, ");
INSERT INTO engf35_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","that you may prove to be sons of your Father in the heavens; for He makes His sun rise on the evil and on the good, and He sends rain on the just and the unjust. ");
INSERT INTO engf35_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","For if you love those who love you, what reward have you? Do not even the tax collectors do the same? ");
INSERT INTO engf35_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","And if you greet only your friends, what are you doing extra? Do not even the tax collectors do so? ");
INSERT INTO engf35_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Therefore, you be perfect just as your Father in the heavens is perfect. ");
INSERT INTO engf35_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Be careful not to do your charitable giving before the people so as to be seen by them. Otherwise you have no reward from your Father who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Therefore, whenever you do charitable giving do not sound a trumpet before you, as the hypocrites do in the synagogues and in the streets, so that they may be praised by the people. Assuredly I say to you, they already have their reward. ");
INSERT INTO engf35_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","But when you do charitable giving do not let your left hand know what your right hand is doing, ");
INSERT INTO engf35_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","so that your charitable giving may be in secret; and your Father who sees in secret will Himself repay you openly. ");
INSERT INTO engf35_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","And whenever you pray do not be like the hypocrites; for they love to pray standing in the synagogues and on the street corners, so that they may be seen by the people. Assuredly I say to you that they already have their reward. ");
INSERT INTO engf35_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","But you, whenever you pray, go into your room, and having shut the door pray to your Father who is in secret; and your Father who sees in secret will repay you openly. ");
INSERT INTO engf35_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“But when you pray do not babble like the heathen; for they think that they will be heard for their many words. ");
INSERT INTO engf35_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","So do not be like them, because your Father knows what you need before you ask Him. ");
INSERT INTO engf35_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Therefore, you pray like this: ‘Our Father who is in the heavens, let Your name be reverenced; ");
INSERT INTO engf35_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","let Your kingdom come, let Your will be done, on the earth just as in heaven. ");
INSERT INTO engf35_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Give us today our daily bread; ");
INSERT INTO engf35_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","and forgive us our debts, as we also forgive our debtors. ");
INSERT INTO engf35_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","And do not bring us into testing, but rescue us from the evil one; because Yours is the kingdom and the power and the glory forever. Amen.’ ");
INSERT INTO engf35_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","For if you forgive people their trespasses, your heavenly Father will also forgive you. ");
INSERT INTO engf35_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","But if you do not forgive people their trespasses, neither will your Father forgive your trespasses. ");
INSERT INTO engf35_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Also, whenever you fast do not become gloomy like the hypocrites, because they disfigure their faces so that people will notice that they are fasting. Assuredly I say to you that they already have their reward. ");
INSERT INTO engf35_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","But when you fast anoint your head and wash your face, ");
INSERT INTO engf35_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","so that you do not appear to the people to be fasting, but to your Father who is in secret; and your Father who sees in secret will repay you. ");
INSERT INTO engf35_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Do not lay up for yourselves treasures on the earth, where moth and rust ruin and where thieves break in and steal; ");
INSERT INTO engf35_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","but lay up for yourselves treasures in heaven, where neither moth nor rust ruins and where thieves neither break in nor steal; ");
INSERT INTO engf35_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","because where your treasure is there your heart will be also. ");
INSERT INTO engf35_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“The lamp of the body is the eye. So if your eye is sound, your whole body will be full of light. ");
INSERT INTO engf35_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","But if your eye is evil, your whole body will be full of darkness. So if the light that is in you is darkness, how great is that darkness! ");
INSERT INTO engf35_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“No one is able to serve two masters; for either he will hate the one and love the other, or he will be loyal to the one and despise the other. You cannot serve God and money. ");
INSERT INTO engf35_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Therefore, I say to you not to worry about your life, what you will eat or what you will drink; nor about your body, what you will put on. Is not life more than food and the body more than clothing? ");
INSERT INTO engf35_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Look at the birds of the air, that they neither sow nor reap nor gather into barns; yet your heavenly Father feeds them. Are you not superior to them? ");
INSERT INTO engf35_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","And which of you can add one cubit to his stature by worrying? ");
INSERT INTO engf35_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","And why do you worry about clothes? Consider the lilies of the field, how they grow; they neither labor nor spin, ");
INSERT INTO engf35_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","and yet I say to you that not even Solomon in all his splendor was arrayed like one of these. ");
INSERT INTO engf35_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Now if God so clothes the grass of the field, which exists today and tomorrow is thrown into the oven, will He not much more clothe you, you little-faiths? ");
INSERT INTO engf35_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Therefore do not worry saying, ‘What shall we eat?’ or ‘What shall we drink?’ or ‘What shall we wear?’ ");
INSERT INTO engf35_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","For the pagans seek all these things, and your heavenly Father knows that you need each of these things. ");
INSERT INTO engf35_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rather, seek first the kingdom of God and His righteousness, and all these things will be added to you. ");
INSERT INTO engf35_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Therefore do not worry about tomorrow, for tomorrow will worry about its own affairs. Each day has enough trouble of its own. ");
INSERT INTO engf35_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Do not judge, so that you be not judged. ");
INSERT INTO engf35_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Because with what judgment you judge, you will be judged; and with the measure you use, it will be measured back to you. ");
INSERT INTO engf35_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","So why do you look at the speck in your brother's eye but do not consider the plank in your own eye? ");
INSERT INTO engf35_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Or how will you say to your brother, ‘Let me remove the speck from your eye,’ when hey, there is a plank in yours? ");
INSERT INTO engf35_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hypocrite! First remove the plank from your own eye, and then you will see clearly to remove the speck from your brother's eye. ");
INSERT INTO engf35_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“A Do not give what is holy to the dogs, B nor cast your pearls before the pigs; B lest they trample them with their feet, and A turning around they tear you to pieces. ");
INSERT INTO engf35_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Keep asking, and it will be given to you; keep seeking, and you will find; keep knocking, and it will be opened to you. ");
INSERT INTO engf35_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","For each one asking, receives; and the one seeking, finds; and to the one knocking it will be opened. ");
INSERT INTO engf35_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Or which man is among you who, if his son asks for bread will give him a stone? ");
INSERT INTO engf35_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Or if he asks for a fish will give him a snake? ");
INSERT INTO engf35_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","If you then, being evil, know to give good gifts to your children, how much more will your Father who is in the heavens give good things to those who ask Him! ");
INSERT INTO engf35_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","So then, whatever you want people to do to you, do also to them, for this is the Law and the Prophets. ");
INSERT INTO engf35_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Go in through the narrow gate; because wide is the gate and broad is the way which leads away into perdition, and those who are going in through it are many. ");
INSERT INTO engf35_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","How narrow is the gate and confined the way which leads away into life, and those who are finding it are few! ");
INSERT INTO engf35_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Beware of false prophets who come to you in sheep's clothing, but inwardly they are ravenous wolves. ");
INSERT INTO engf35_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","You will know them by their fruits. Do people gather grapes from thorn bushes, or figs from thistles? ");
INSERT INTO engf35_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Just so, every good tree produces good fruits, but the rotten tree produces evil fruits. ");
INSERT INTO engf35_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A good tree cannot produce evil fruits, nor can a rotten tree produce good fruits. ");
INSERT INTO engf35_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","So every tree not producing good fruit is cut down and thrown into the fire. ");
INSERT INTO engf35_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Therefore, you will know them by their fruits. ");
INSERT INTO engf35_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Not everyone who says to me, ‘Lord, Lord,’ will go into the kingdom of the heavens, but he who does the will of my Father who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Many will say to me in that day, ‘Lord, Lord, did we not prophesy in Your name, and cast out demons in Your name, and perform many mighty works in Your name?’ ");
INSERT INTO engf35_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","And then I will declare to them, ‘I never knew you; depart from me you practitioners of lawlessness!’ ");
INSERT INTO engf35_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Therefore whoever hears these words of mine and does them, I will compare him to a prudent man who built his house on the bedrock; ");
INSERT INTO engf35_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","and the rain fell, and the rivers rose, and the winds blew and attacked that house; and it did not fall, because it was founded on the bedrock. ");
INSERT INTO engf35_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","But every one who hears these words of mine and does not do them will be compared to a foolish man who built his house on the sand; ");
INSERT INTO engf35_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","and the rain fell, and the rivers rose, and the winds blew and beat on that house; and it fell. And great was its fall!” ");
INSERT INTO engf35_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","And so it was, when Jesus had ended these words, that the crowds were astonished at His teaching, ");
INSERT INTO engf35_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","for He was teaching them as one having authority, and not like the scribes. ");
INSERT INTO engf35_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","So when He came down from the mountain large crowds followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","And then, a leper came and worshiped Him saying, “Lord, if You are willing, You can make me clean.” ");
INSERT INTO engf35_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","So reaching out His hand Jesus touched him, saying, “I am willing; be cleansed!” And immediately his leprosy was cleansed. ");
INSERT INTO engf35_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","And Jesus says to him: “See that you tell no one; but go, show yourself to the priest and offer the gift that Moses commanded, as a proof to them.” ");
INSERT INTO engf35_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","As He entered Capernaum a centurion came to Him, pleading with Him ");
INSERT INTO engf35_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","and saying, “Lord, my servant is lying at home paralyzed, being terribly tormented.” ");
INSERT INTO engf35_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","And Jesus says to him, “I will go and heal him.” ");
INSERT INTO engf35_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","But in answer the centurion said: “Lord, I am not worthy that you should come under my roof; but only speak a word and my servant will be healed. ");
INSERT INTO engf35_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","For I also am a man under authority, having soldiers under me. And I say to this one, ‘Go,’ and he goes; and to another, ‘Come,’ and he comes; and to my slave, ‘Do this,’ and he does.” ");
INSERT INTO engf35_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Upon hearing him Jesus marveled, and said to those who were following: “Assuredly I say to you, not even in Israel have I found such great faith! ");
INSERT INTO engf35_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","And I say to you that many will come from east and west and sit down with Abraham, Isaac and Jacob in the kingdom of the heavens; ");
INSERT INTO engf35_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","but the sons of the kingdom will be thrown out into the darkness farthest away. There, there will be weeping and gnashing of teeth.” ");
INSERT INTO engf35_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Then Jesus said to the centurion, “Go; and let it be done for you just as you believed.” And his servant was healed in that very hour. ");
INSERT INTO engf35_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Now when Jesus had come into Peter's house, He saw his mother-in-law laid up and burning with fever. ");
INSERT INTO engf35_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","So He touched her hand and the fever left her; and she got up and began to serve Him. ");
INSERT INTO engf35_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","And when evening came they brought to Him many who were demonized. And He cast out the spirits with a word, and healed all who were sick, ");
INSERT INTO engf35_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","so that what was spoken through Isaiah the prophet should be fulfilled, namely: “He Himself took our infirmities and bore our diseases.” ");
INSERT INTO engf35_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Seeing large crowds around Him Jesus gave an order to depart for the opposite shore. ");
INSERT INTO engf35_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Then a certain scribe approaching said to Him, “Teacher, I will follow you wherever you may go.” ");
INSERT INTO engf35_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","So Jesus says to him, “The foxes have dens and the birds of the air have nests, but the Son of the Man does not have where He may lay His head.” ");
INSERT INTO engf35_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Then a different one of the disciples said to Him, “Lord, permit me first to go and bury my father.” ");
INSERT INTO engf35_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","But Jesus said to him, “Follow me, and leave the dead to bury their own dead.” ");
INSERT INTO engf35_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Now when He got into the boat, His disciples followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","And then—a great tempest arose on the sea, so that the boat was covered by the waves. But He was sleeping. ");
INSERT INTO engf35_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","So the disciples came and awakened Him saying, “Lord, save us! We are perishing!” ");
INSERT INTO engf35_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","And He says to them, “Why are you cowardly, you little-faiths?” Then rising He rebuked the winds and the sea, and there was a great calm. ");
INSERT INTO engf35_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","So the men marveled, saying, “What sort of being is this, that even the winds and the sea obey Him?” ");
INSERT INTO engf35_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Upon His coming to the other side, to the region of the Gergesenes, two demonized men met Him, coming out from the tombs, very dangerous, so that no one could pass that way. ");
INSERT INTO engf35_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","And then—they cried out saying: “What do you have to do with us, Jesus, Son of God? Have you come here to torment us before the time?” ");
INSERT INTO engf35_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Now a good way off from them there was a herd of many pigs feeding. ");
INSERT INTO engf35_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","So the demons kept imploring Him saying, “Since you are going to cast us out, permit us to go into the herd of pigs.” ");
INSERT INTO engf35_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","So He said to them, “Go!” And coming out they went off into the herd of pigs. And then—the whole herd of pigs rushed down the steep bank into the sea and died in the water! ");
INSERT INTO engf35_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","So the swineherds ran away, and going into the town they told everything, including about the demonized men. ");
INSERT INTO engf35_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","And then, the whole town went out to meet with Jesus; and upon seeing Him they begged Him to depart from their borders. ");
INSERT INTO engf35_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","So getting into the boat He crossed over and came into His own city. ");
INSERT INTO engf35_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","And then, they came to Him carrying a paralytic lying on a pallet. And seeing their faith Jesus said to the paralytic, “Courage, son; your sins are forgiven you!” ");
INSERT INTO engf35_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","But then, some of the scribes said within themselves, “This man blasphemes!” ");
INSERT INTO engf35_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","So Jesus, knowing their thoughts, said: “Why do you think evil in your hearts? ");
INSERT INTO engf35_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","So which is easier, to say ‘Your sins are forgiven’, or to say ‘Get up and walk’? ");
INSERT INTO engf35_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","But so that you may know that the Son of the Man has authority on the earth to forgive sins”—then He says to the paralytic, “On your feet, pick up your pallet and go to your house!” ");
INSERT INTO engf35_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","So he got up and went off to his house. ");
INSERT INTO engf35_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","And seeing it the crowds marveled and glorified God, the one giving such authority to the people. ");
INSERT INTO engf35_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","And going on from there Jesus saw a man named Matthew sitting at the tax office, and He says to him, “Follow me.” So getting up he followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Now it happened, as He was reclining at the table in the house, that many tax collectors and sinners had also come and were reclining at the table with Jesus and His disciples! ");
INSERT INTO engf35_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Upon seeing this the Pharisees said to His disciples, “Why does your teacher eat and drink with the tax collectors and sinners?” ");
INSERT INTO engf35_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","But Jesus heard it, so He said to them: “Those who are strong do not need a physician, but those who are sick. ");
INSERT INTO engf35_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","But go and learn what this means, ‘I desire mercy and not sacrifice.’ For I did not come to call the righteous, but sinners to repentance.” ");
INSERT INTO engf35_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Then the disciples of John come to Him saying, “Why is it that we and the Pharisees fast about many things, but your disciples do not fast?” ");
INSERT INTO engf35_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","So Jesus said to them: “Can the friends of the bridegroom mourn as long as the bridegroom is with them? But the days will come when the bridegroom will be taken away from them, and then they will fast. ");
INSERT INTO engf35_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“And no one puts a patch of unshrunk cloth on an old garment; for the patch pulls away from the garment and the tear becomes worse. ");
INSERT INTO engf35_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nor do they put new wine into old wineskins; otherwise the wineskins burst and the wine spills out, and the wineskins will be ruined. But they put new wine into new wineskins, and both are preserved.” ");
INSERT INTO engf35_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","While He was saying these things to them, there he was; a certain ruler came and worshiped Him, saying, “My daughter has just died, but come and lay your hand on her and she will live.” ");
INSERT INTO engf35_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","So Jesus got up and followed him, with His disciples. ");
INSERT INTO engf35_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","And then—a woman who had been hemorrhaging for twelve years came from behind and touched the hem of His garment. ");
INSERT INTO engf35_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","For she kept saying to herself, “If only I may touch His garment I will be healed.” ");
INSERT INTO engf35_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","But Jesus, turning around and seeing her, said, “Take courage, daughter; your faith has made you well.” And the woman was healed from that very hour. ");
INSERT INTO engf35_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","When Jesus came into the ruler's house and saw the flutists and the crowd making a commotion, ");
INSERT INTO engf35_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","He says to them, “Go away, for the girl is not dead, but sleeping.” So they began to ridicule Him. ");
INSERT INTO engf35_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","But when the crowd had been put outside, He went in and grasped her hand, and the girl got up. ");
INSERT INTO engf35_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","And the report of this went out into all that land. ");
INSERT INTO engf35_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","As Jesus went on from there two blind men followed Him, crying out and saying, “Have mercy on us, Son of David!” ");
INSERT INTO engf35_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","And arriving in the house, the blind men approached Him; so He says to them, “Do you believe that I am able to do this?” They say to Him, “Yes, Lord.” ");
INSERT INTO engf35_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Then He touched their eyes saying, “According to your faith let it be to you.” ");
INSERT INTO engf35_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","And their eyes were opened. And Jesus sternly warned them saying, “See to it that no one knows!” ");
INSERT INTO engf35_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","But going out they spread the news about Him in all that country. ");
INSERT INTO engf35_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","As they were going out, well, they brought to Him a mute man, demonized. ");
INSERT INTO engf35_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","And when the demon was cast out, the mute spoke. And the crowds marveled saying, “Never was it seen like this in Israel!” ");
INSERT INTO engf35_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","But the Pharisees said, “He casts out demons by the ruler of the demons.” ");
INSERT INTO engf35_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Then Jesus went around to all the cities and villages, teaching in their synagogues and preaching the Gospel of the kingdom, and healing every disease and every illness among the people. ");
INSERT INTO engf35_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Seeing the crowds He was moved with compassion for them, because they were harassed and prostrated, like sheep without a shepherd. ");
INSERT INTO engf35_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Then He says to His disciples: “The harvest truly is plentiful, but the workers are few. ");
INSERT INTO engf35_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Therefore pray to the Lord of the harvest that He may send out workers into His harvest.” ");
INSERT INTO engf35_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","So summoning His twelve disciples He gave them authority over unclean spirits so as to cast them out, and to heal every disease and every illness. ");
INSERT INTO engf35_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Now the names of the twelve apostles are these: first Simon (the one called Peter) and Andrew his brother, James (the son of Zebedee) and John his brother, ");
INSERT INTO engf35_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip and Bartholomew, Thomas and Matthew (the tax collector), James (the son of Alphaeus) and Lebbaeus (who was surnamed Thaddeus), ");
INSERT INTO engf35_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon (the Canaanite) and Judas Iscariot (who also betrayed Him). ");
INSERT INTO engf35_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","These twelve Jesus sent out, and commanded them saying: “Do not go off into the road of the Gentiles, and do not enter a city of the Samaritans. ");
INSERT INTO engf35_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","But go rather to the lost sheep of the house of Israel. ");
INSERT INTO engf35_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","And as you go, preach, saying, ‘The kingdom of the heavens has come near.’ ");
INSERT INTO engf35_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Heal the sick, cleanse the lepers, cast out demons. You have received free of charge, give free of charge. ");
INSERT INTO engf35_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Do not provide gold nor silver nor copper in your money belts, ");
INSERT INTO engf35_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nor a knapsack for the road, nor two tunics, nor sandals, nor staffs; because the worker is worthy of his food. ");
INSERT INTO engf35_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“In whatever city or village you may enter, inquire who in it is worthy, and stay there until you go out. ");
INSERT INTO engf35_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Upon entering the house, greet it; ");
INSERT INTO engf35_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","and should the house be worthy, let your peace come upon it; but should it not be worthy, let your peace return to you. ");
INSERT INTO engf35_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","And whoever will not receive you nor hear your words, as you go out from that house or city shake off the dust from your feet. ");
INSERT INTO engf35_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Assuredly I say to you, it will be more tolerable for the land of Sodom and Gomorrah in the Day of judgment than for that city! ");
INSERT INTO engf35_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Now then, I am sending you out like sheep in the midst of wolves. Therefore be prudent like snakes and innocent like doves. ");
INSERT INTO engf35_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","But beware of the people, for they will hand you over to councils and flog you in their synagogues. ");
INSERT INTO engf35_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","And you will be brought before governors and even kings for my sake, as a testimony to them and to the nations. ");
INSERT INTO engf35_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","But whenever they hand you over, do not worry about how or what you will speak, for it will be given to you in that hour what you should speak; ");
INSERT INTO engf35_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","for it is not you who speak, but the Spirit of your Father who speaks in you. ");
INSERT INTO engf35_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Furthermore, brother will hand over brother to death, and a father a child, and children will rise up against parents and put them to death. ");
INSERT INTO engf35_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","And you will be hated by all for my name's sake; but the one enduring to the end, he will be delivered. ");
INSERT INTO engf35_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","But whenever they persecute you in this city, flee to another. For assuredly I say to you, you will certainly not go through all the cities of Israel before the Son of the Man comes. ");
INSERT INTO engf35_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A disciple is not above his teacher, nor a slave above his master. ");
INSERT INTO engf35_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","It is enough for a disciple that he become like his teacher, and a slave like his master. Since they have stigmatized the master of the house as Beelzebul, how much more those of his household! ");
INSERT INTO engf35_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","So do not fear them; because there is nothing concealed that will not be revealed, and secret that will not be known. ");
INSERT INTO engf35_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“What I tell you in the dark, say in the light; and what you hear in the ear, proclaim on the housetops. ");
INSERT INTO engf35_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","And do not be afraid of those who kill the body but cannot kill the soul. But rather fear the One who is able to destroy both soul and body in Hell. ");
INSERT INTO engf35_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Are not two sparrows sold for a copper coin? Yet not one of them will fall to the ground apart from your Father's will. ");
INSERT INTO engf35_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Why even the hairs of your head are all numbered! ");
INSERT INTO engf35_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Therefore do not be afraid; you are worth more than many sparrows. ");
INSERT INTO engf35_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Now then, everyone who will confess me before the people, I will also confess him before my Father who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","But whoever should deny me before the people, I will also deny him before my Father who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Do not suppose that I came to bring peace on the earth. I did not come to bring peace, but a sword. ");
INSERT INTO engf35_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","For I came to set a man against his father, and a daughter against her mother, and a daughter-in-law against her mother-in-law; ");
INSERT INTO engf35_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","and a man's enemies will be those of his own household. ");
INSERT INTO engf35_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“The one who is more devoted to father or mother than to me is not worthy of me, and the one who is more devoted to son or daughter than to me is not worthy of me; ");
INSERT INTO engf35_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","and he who does not take up his cross and follow after me is not worthy of me. ");
INSERT INTO engf35_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","The one ‘finding’ his life will lose it, and the one ‘losing’ his life for my sake will find it. ");
INSERT INTO engf35_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“The one receiving you receives me, and the one receiving me receives the One who sent me. ");
INSERT INTO engf35_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","The one receiving a prophet in the name of a prophet will receive a prophet's reward, and the one receiving a righteous man in the name of a righteous man will receive a righteous man's reward. ");
INSERT INTO engf35_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","And whoever should give so much as a cup of cold water to one of these little ones, in the name of a disciple, assuredly I say to you, he will certainly not lose his reward.” ");
INSERT INTO engf35_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","And so it was, when Jesus finished directing His twelve disciples, that He moved on from there to teach and preach in their towns. ");
INSERT INTO engf35_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","But John, hearing in prison about the works of the Messiah, sent two of his disciples ");
INSERT INTO engf35_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","to say to Him, “Are you the Coming One, or do we look for another?” ");
INSERT INTO engf35_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","By way of answer Jesus said to them: “Go and report to John the things that you hear and see: ");
INSERT INTO engf35_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","blind regain sight and lame walk, lepers are cleansed and deaf hear, dead are raised and the poor are evangelized. ");
INSERT INTO engf35_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","And, blessed be whoever is not offended at Me!” ");
INSERT INTO engf35_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","So as they departed Jesus began to say to the crowds concerning John: “What did you go out into the wilderness to see, a reed shaken by the wind? ");
INSERT INTO engf35_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","But what did you go out to see, a man clothed in soft garments? Actually, those who wear soft material are in kings' houses. ");
INSERT INTO engf35_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","But really, what did you go out to see, a prophet? Yes, I tell you, and far more than a prophet. ");
INSERT INTO engf35_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","For this is he of whom it is written: ‘Behold, I send my messenger before your face, who will prepare your way ahead of you.’ ");
INSERT INTO engf35_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Assuredly I say to you, among those born of women there has not arisen a greater than John the Baptizer; but he who is least in the kingdom of the heavens is greater than he. ");
INSERT INTO engf35_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","But from the days of John the Baptizer until now the kingdom of the heavens is being aggressive and aggressive people are seizing upon it. ");
INSERT INTO engf35_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","For all the prophets and the Law prophesied until John, ");
INSERT INTO engf35_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","and if you are willing to receive it, he is Elijah who is to come. ");
INSERT INTO engf35_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","He who has ears to hear, let him hear! ");
INSERT INTO engf35_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“But to what shall I compare this generation? It is like children sitting in a marketplace and calling to their friends ");
INSERT INTO engf35_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","and saying, ‘We played the flute for you and you did not dance; we mourned for you and you did not lament.’ ");
INSERT INTO engf35_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","For John came neither eating nor drinking and they say, ‘He has a demon’; ");
INSERT INTO engf35_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","the Son of the Man came eating and drinking and they say, ‘Just look, a glutton and a drunkard, a friend of tax collectors and sinners!’ Indeed, wisdom is vindicated by her children.” ");
INSERT INTO engf35_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Then He began to reproach the cities in which most of His mighty works had been done, because they did not repent. ");
INSERT INTO engf35_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Woe to you, Chorazin! Woe to you, Bethsaida! Because if the mighty works that were done in you had been done in Tyre and Sidon, they would have repented long ago in sackcloth and ashes. ");
INSERT INTO engf35_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","So I say to you, it will be more tolerable for Tyre and Sidon in the Day of judgment than for you! ");
INSERT INTO engf35_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","And you, Capernaum, ‘the one having been exalted to heaven’, you will be brought down to Hades! Because if the mighty works that were done in you had been done in Sodom, it would have remained until this day. ");
INSERT INTO engf35_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","So I say to you that it will be more tolerable for the land of Sodom in the Day of judgment than for you.” ");
INSERT INTO engf35_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","At that time Jesus reacted and said: “ ‘I praise You, Father, Lord of heaven and earth, that You have hidden these things from the wise and intelligent and have revealed them to ‘babes’. ");
INSERT INTO engf35_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yes, Father, because thus it was good to You.’ ");
INSERT INTO engf35_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“All things have been delivered to me by my Father, and no one really knows the Son except the Father; nor does anyone really know the Father except the Son, and the one to whom the Son may will to reveal Him. ");
INSERT INTO engf35_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Come to me all you who are laboring and are loaded down, and I will give you rest. ");
INSERT INTO engf35_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Take my yoke upon you and learn from me, because I am gentle and lowly in heart, and you will find rest for your souls; ");
INSERT INTO engf35_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","for my yoke is easy and my burden is light.” ");
INSERT INTO engf35_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","At that time Jesus went through the grain fields on the Sabbath. But His disciples became hungry and began to pluck heads of grain and to eat. ");
INSERT INTO engf35_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","And upon seeing it the Pharisees said to Him, “Hey, your disciples are doing what is not lawful to do on a Sabbath!” ");
INSERT INTO engf35_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","But He said to them: “Have you not read what David did when he became hungry, he and those who were with him, ");
INSERT INTO engf35_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","how he entered the house of God and ate the loaves of presentation, which was not lawful for him to eat, nor for those with him, but only for the priests? ");
INSERT INTO engf35_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Or have you not read in the Law that on the Sabbaths the priests in the temple profane the Sabbath and are guiltless? ");
INSERT INTO engf35_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yet I say to you that a greater than the temple is here. ");
INSERT INTO engf35_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","If you had but known what this means, ‘I desire mercy and not sacrifice,’ you would not have condemned the innocent. ");
INSERT INTO engf35_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Furthermore, the Son of the Man is Lord of the Sabbath!” ");
INSERT INTO engf35_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Now moving on from there He went into their synagogue. ");
INSERT INTO engf35_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","And there was a man with a withered hand! And they asked Him saying, “Is it lawful to heal on the Sabbath?”—so that they might accuse Him. ");
INSERT INTO engf35_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","So He said to them: “What man will there be among you who has one sheep, and should this one fall into a ditch on the Sabbath, will he not lay hold of it and lift it out? ");
INSERT INTO engf35_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Of how much more value then is a man than a sheep! Therefore it is lawful to do good on the Sabbath.” ");
INSERT INTO engf35_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Then He says to the man, “Stretch out your hand!” And he stretched it out, and it was restored whole like the other. ");
INSERT INTO engf35_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","But going out the Pharisees plotted against Him, how they might destroy Him. ");
INSERT INTO engf35_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","So being aware, Jesus withdrew from there. And large crowds followed Him, and He healed them all. ");
INSERT INTO engf35_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yet He warned them not to make Him known, ");
INSERT INTO engf35_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","so that what was spoken through Isaiah the prophet might be fulfilled, namely: ");
INSERT INTO engf35_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Behold my Servant whom I chose, my Beloved in whom my soul is well pleased! I will put my Spirit upon Him, and He will declare justice to the nations. ");
INSERT INTO engf35_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","He will not quarrel nor cry-out, nor will anyone hear His voice in the streets. ");
INSERT INTO engf35_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A bruised reed He will not break, and a smoldering wick He will not quench, until He sends justice forth to victory. ");
INSERT INTO engf35_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","And in His name Gentiles will trust.” ");
INSERT INTO engf35_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Then a demonized man was brought to Him, blind and mute, and He healed him, so that the A blind and B mute B spoke and A saw. ");
INSERT INTO engf35_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","And all the crowds were amazed and said, “Might this not be the Christ, the Son of David?” ");
INSERT INTO engf35_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","But upon hearing it the Pharisees said, “This fellow does not cast out demons except by Beelzebul, ruler of the demons.” ");
INSERT INTO engf35_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","But knowing their thoughts Jesus said to them: “Every kingdom divided against itself becomes desolate, and every city or house divided against itself will not stand. ");
INSERT INTO engf35_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So if Satan casts out Satan he is divided against himself. How then will his kingdom stand? ");
INSERT INTO engf35_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","And if I cast out demons by Beelzebul, by whom do your sons cast them out? Therefore they will be your judges. ");
INSERT INTO engf35_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","But if I cast out demons by the Spirit of God, then surely the kingdom of God has come upon you. ");
INSERT INTO engf35_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Or how can anyone go into the house of the strong man and plunder his goods, unless he first binds the strong man? Then he can plunder the house. ");
INSERT INTO engf35_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“He who is not with me is against me, and he who does not gather with me scatters. ");
INSERT INTO engf35_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Therefore I say to you, every sin and blasphemy will be forgiven people, but the blasphemy against the Spirit will not be forgiven people. ");
INSERT INTO engf35_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","And whoever speaks a word against the Son of the Man, it will be forgiven him; but whoever speaks against the Holy Spirit, it will not be forgiven him, neither in the present age nor in the next. ");
INSERT INTO engf35_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Either make the tree good and its fruit good, or make the tree rotten and its fruit rotten; for the tree is known by the fruit. ");
INSERT INTO engf35_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Brood of vipers! How can you, being malignant, speak good things? For out of the abundance of the heart the mouth speaks. ");
INSERT INTO engf35_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","The good man out of the good reservoir brings forth good things, and the malignant man out of the malignant reservoir brings forth malignant things. ");
INSERT INTO engf35_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Furthermore, I say to you that for every useless word whatever that people may speak, they will give account of it in the Day of judgment. ");
INSERT INTO engf35_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","For by your words you will be justified, and by your words you will be condemned.” ");
INSERT INTO engf35_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Then some of the scribes and Pharisees reacted saying, “Teacher, we want to see a sign from you.” ");
INSERT INTO engf35_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","But in answer He said to them: “A malignant and adulterous generation seeks a sign, and no sign will be given to it except the sign of the prophet Jonah. ");
INSERT INTO engf35_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","For just as Jonah was three days and three nights in the stomach of the sea monster, so will the Son of the Man be three days and three nights in the heart of the earth. ");
INSERT INTO engf35_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ninevite men will arise with this generation at the judgment and will condemn it, because they repented at the preaching of Jonah; and really, a greater than Jonah is here. ");
INSERT INTO engf35_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","The queen of the South will be raised with this generation at the judgment and she will condemn it, because she came from the ends of the earth to hear the wisdom of Solomon; and really, a greater than Solomon is here. ");
INSERT INTO engf35_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Now when an unclean spirit demon goes out from a man, it goes through arid places looking for rest, but finds none. ");
INSERT INTO engf35_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Then it says, ‘I will return to my house from where I came.’ And coming it finds it unoccupied, swept and put in order. ");
INSERT INTO engf35_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Then it goes and takes along with itself seven different spirits, more malignant than itself, and going in it dwells there; and the last state of that man becomes worse than the first. Just so it will be for this malignant generation also.” ");
INSERT INTO engf35_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","But then, while He was still speaking to the crowds, His mother and brothers stood outside, seeking to speak with Him. ");
INSERT INTO engf35_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","So someone said to Him, “Look, your mother and your brothers are standing outside, seeking to speak with you.” ");
INSERT INTO engf35_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","But in answer He said to the one who told Him, “Who is my mother, and who are my brothers?” ");
INSERT INTO engf35_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","And stretching out His hand toward His disciples He said: “Here are my mother and my brothers! ");
INSERT INTO engf35_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","For whoever does the will of my Father in the heavens, he is my brother and sister and mother.” ");
INSERT INTO engf35_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","On the same day Jesus went out of the house and sat by the sea. ");
INSERT INTO engf35_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","And large crowds were gathered together to Him, so He got into a boat to sit down; and the whole crowd stood on the shore. ");
INSERT INTO engf35_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Then He spoke many things to them in parables saying: “Listen, a sower went out to sow. ");
INSERT INTO engf35_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","And as he sowed, some seeds fell alongside the road, and the birds came and devoured them. ");
INSERT INTO engf35_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Others fell on stony places, where they did not have much earth; so they sprouted quickly because they had no depth of earth. ");
INSERT INTO engf35_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","But when the sun came up they were scorched, and because they had no root they withered away. ");
INSERT INTO engf35_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","And others fell among the thorns, and the thorns grew up and smothered them. ");
INSERT INTO engf35_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","But others fell on the good ground and yielded a crop: some a hundredfold, some sixty, some thirty. ");
INSERT INTO engf35_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","He who has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","And the disciples approached and said to Him, “Why do you speak to them in parables?” ");
INSERT INTO engf35_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","So in answer He said to them: “To you it has been given to know the mysteries of the kingdom of the heavens, but to them it has not been given. ");
INSERT INTO engf35_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","For whoever has, to him more will be given and he will have abundance; but whoever does not have, even what he has will be taken away from him. ");
INSERT INTO engf35_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Therefore I speak to them in parables, that seeing they not see and hearing they not hear nor understand. ");
INSERT INTO engf35_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","And in them the prophecy of Isaiah is fulfilled, which says: ‘By hearing you (ye) will hear and not understand, and seeing you will see and not perceive. ");
INSERT INTO engf35_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Because the A hearts of this people have grown dull, and their B ears hard of hearing, and their C eyes they have closed; lest they should see with their C eyes and hear with their B ears and understand with their A hearts, and turn around; and I would heal them.’ ");
INSERT INTO engf35_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","But blessed are your eyes because they see, and your ears because they hear; ");
INSERT INTO engf35_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","for assuredly I say to you that many prophets and righteous ones desired to see what you see and did not see it, and to hear what you hear and did not hear it. ");
INSERT INTO engf35_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Therefore hear the parable of the sower: ");
INSERT INTO engf35_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","When anyone hears the word of the kingdom and does not understand, the malignant one comes and snatches away what was sown in his heart—this is the seed sown alongside the road. ");
INSERT INTO engf35_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","But the seed sown on stony places—this is he who hears the word and directly receives it with joy, ");
INSERT INTO engf35_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","but he has no root in himself and is short-lived; for when trial or persecution comes because of the word, directly he is offended. ");
INSERT INTO engf35_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","But the seed sown among the thorns—this is he who hears the word, but the care of this age and the deceitfulness of riches choke out the word, and it becomes fruitless. ");
INSERT INTO engf35_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Now the seed sown on the good ground—this is he who hears the word and understands, who indeed bears fruit and produces: some a hundredfold, some sixty, some thirty.” ");
INSERT INTO engf35_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","He put another parable to them, saying: “The kingdom of the heavens is like a man who sowed good seed in his field; ");
INSERT INTO engf35_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","but while the people were sleeping his enemy came and sowed tares among the wheat and went away. ");
INSERT INTO engf35_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","But when the stalk sprouted and produced fruit, then the tares also appeared. ");
INSERT INTO engf35_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","So the servants of the owner came and said to him, ‘Sir, was it not good seed that you sowed in your field? How then does it have tares?’ ");
INSERT INTO engf35_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","He said to them, ‘An enemy did it.’ The servants said to him, ‘So do you want us to go and gather them up?’ ");
INSERT INTO engf35_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","But he said: ‘No, lest gathering up the tares you also uproot the wheat with them. ");
INSERT INTO engf35_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Let both grow together until the harvest, and at the time of the harvest I will say to the reapers, “First gather up the tares and bind them into bundles to burn them, but gather the wheat into my barn.” ’ ” ");
INSERT INTO engf35_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","He put another parable to them, saying: “The kingdom of the heavens is like a mustard seed which a man took and sowed in his field; ");
INSERT INTO engf35_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","which indeed is smaller than all the seeds, but when it is grown it is greater than all the vegetables and becomes a tree, so that the birds of the air come and rest in its branches.” ");
INSERT INTO engf35_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","He spoke another parable to them: “The kingdom of the heavens is like yeast, which a woman took and hid in three measures of meal until it was all leavened.” ");
INSERT INTO engf35_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","All these things Jesus spoke to the crowds in parables, and without a parable He did not speak to them, ");
INSERT INTO engf35_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","so that what was spoken through the prophet should be fulfilled, namely: “I will open my mouth in parables; I will utter things kept secret from the foundation of the world.” ");
INSERT INTO engf35_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Then Jesus dismissed the crowds and went into the house. And His disciples approached Him saying, “Explain to us the parable of the tares of the field.” ");
INSERT INTO engf35_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","So He answered and said to them: “He who sows the good seed is the Son of the Man. ");
INSERT INTO engf35_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","The field is the world; as for the good seed, these are the sons of the kingdom, while the tares are the sons of the malignant one. ");
INSERT INTO engf35_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","The enemy who sowed them is the devil; the harvest is the end of the age, and the reapers are angels. ");
INSERT INTO engf35_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Therefore just as the tares are gathered and burned with fire, so it will be at the end of this age. ");
INSERT INTO engf35_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","The Son of the Man will send out His angels, and they will collect out of His kingdom everything that is offensive, and those who perpetrate lawlessness; ");
INSERT INTO engf35_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","and they will throw them into the furnace of fire. There there will be weeping and gnashing of teeth. ");
INSERT INTO engf35_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Then the righteous will shine forth as the sun in the kingdom of their Father. He who has ears to hear, let him hear. ");
INSERT INTO engf35_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Again, the kingdom of the heavens is like a treasure hidden in a field, which a man found and re-hid, and in his joy he goes and sells everything he has and buys that field. ");
INSERT INTO engf35_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Again, the kingdom of the heavens is like a man, a merchant, seeking beautiful pearls, ");
INSERT INTO engf35_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","who upon finding one very valuable pearl went and sold everything he had and bought it. ");
INSERT INTO engf35_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Again, the kingdom of the heavens is like a seine that was cast into the sea and gathered of every kind, ");
INSERT INTO engf35_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","which, when it was full, they pulled upon the shore; and sitting down they collected the good into vessels, but threw out the bad. ");
INSERT INTO engf35_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","So it will be at the end of the age. The angels will come forth and will separate the malignant out from among the righteous, ");
INSERT INTO engf35_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","and they will throw them into the furnace of fire. There there will be weeping and gnashing of teeth.” ");
INSERT INTO engf35_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus says to them, “Did you understand all these things?” They say to Him, “Yes, Lord.” ");
INSERT INTO engf35_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","So He said to them, “Therefore every scribe who has been discipled into the kingdom of the heavens is like a man, a householder, who brings out of his reservoir things new and old.” ");
INSERT INTO engf35_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Now it happened, when Jesus had finished these parables, that He departed from there. ");
INSERT INTO engf35_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","And coming into His hometown He began to teach them in their synagogue, so that they were astonished and said: “Where did this man get this wisdom, and the mighty works? ");
INSERT INTO engf35_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Is this not the carpenter's son? Is not his mother called Mary, and his brothers James and Joses and Simon and Jude? ");
INSERT INTO engf35_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","And his sisters, are they not all with us? Where then did this man get all these things?” ");
INSERT INTO engf35_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","So they were offended at him. But Jesus said to them, “A prophet is not without honor except in his hometown and in his own house.” ");
INSERT INTO engf35_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","And He did not do many mighty works there because of their unbelief. ");
INSERT INTO engf35_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","At that time Herod the tetrarch heard the report about Jesus ");
INSERT INTO engf35_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","and said to his servants, “This is John the Baptizer; he has been raised from the dead, and therefore the powers are at work in him.” ");
INSERT INTO engf35_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","For Herod had laid hold of John and bound him, and put him in prison because of Herodias, his brother Philip's wife. ");
INSERT INTO engf35_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","For John would say to him, “It is not lawful for you to have her.” ");
INSERT INTO engf35_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","And although he wanted to kill him, he feared the crowd, because they counted him as a prophet. ");
INSERT INTO engf35_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","But while Herod's birthday was being celebrated, the daughter of Herodias danced before them and she pleased Herod. ");
INSERT INTO engf35_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","So he promised with an oath to give her whatever she might ask. ");
INSERT INTO engf35_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","So she, having been prompted by her mother, she says, “Give me here on a platter the head of John the Baptizer!” ");
INSERT INTO engf35_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","And the king was sorry; nevertheless, because of the oaths and those who were reclining at the table with him, he commanded it to be given. ");
INSERT INTO engf35_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","So he sent and had John beheaded in prison. ");
INSERT INTO engf35_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","And his head was brought on a platter and given to the girl, and she brought it to her mother. ");
INSERT INTO engf35_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Then his disciples came forward and took the body and buried it, and they went and told Jesus. ");
INSERT INTO engf35_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Upon hearing it, Jesus departed from there by boat to a deserted place privately. But when the crowds heard it, they followed Him on foot from the towns. ");
INSERT INTO engf35_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","So when Jesus disembarked He saw a large crowd, and He had compassion on them and healed their sick. ");
INSERT INTO engf35_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Now with evening coming on His disciples approached Him saying: “The place is uninhabited and the hour is already late. Dismiss the crowds, that they may go into the villages and buy themselves food.” ");
INSERT INTO engf35_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","But Jesus said to them: “They do not need to go away. You give them to eat.” ");
INSERT INTO engf35_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","But they say to Him, “We have nothing here except five loaves and two fish.” ");
INSERT INTO engf35_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","So He said, “Bring them here to me.” ");
INSERT INTO engf35_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Then He commanded the crowds to recline on the grass. And taking the five loaves and two fish and looking up to heaven, He blessed; and breaking the loaves He gave to the disciples, and the disciples to the crowds. ");
INSERT INTO engf35_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","So they all ate and were filled; and they took up the fragments that remained, twelve baskets full. ");
INSERT INTO engf35_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Now those who ate were about five thousand men, besides women and children. ");
INSERT INTO engf35_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Immediately Jesus made His disciples get into the boat and go ahead of Him to the other side, while He dismissed the crowds. ");
INSERT INTO engf35_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","And having dismissed the crowds He went up on the mountain by Himself to pray. So when night came He was alone there. ");
INSERT INTO engf35_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","But the boat was already in the middle of the sea, being harassed by the waves, for the wind was contrary. ");
INSERT INTO engf35_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","So in the fourth watch of the night Jesus went to them, walking on the sea. ");
INSERT INTO engf35_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","And when the disciples saw Him walking on the sea, they became agitated saying, “It's a ghost!” And they cried out for fear. ");
INSERT INTO engf35_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","But immediately Jesus spoke to them saying: “Courage! It is I; don't be afraid!” ");
INSERT INTO engf35_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","So in answer Peter said, “Lord, since it's you, command me to come to you on the water.” ");
INSERT INTO engf35_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","So He said to him, “Come!” And stepping down from the boat Peter walked on the water to go to Jesus. ");
INSERT INTO engf35_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","But seeing the strong wind he became afraid, and beginning to sink he cried out saying, “Lord, save me!” ");
INSERT INTO engf35_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","And immediately Jesus reached out His hand and caught him and says to him: “You little-faith! Why did you doubt?” ");
INSERT INTO engf35_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","And when they got into the boat the wind ceased. ");
INSERT INTO engf35_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Then those who were in the boat came and worshiped Him saying, “Truly you are the Son of God!” ");
INSERT INTO engf35_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","When they had crossed over they came to the land of Genesaret. ");
INSERT INTO engf35_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","And when the men of that place recognized Him they sent messengers into all that surrounding region and they brought to Him all who were sick. ");
INSERT INTO engf35_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","And they would beg Him that if only they might at least touch the hem of His garment; and as many as touched were completely healed. ");
INSERT INTO engf35_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Then the scribes and Pharisees from Jerusalem approached Jesus saying: ");
INSERT INTO engf35_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Why do your disciples transgress the tradition of the elders? For they do not wash their hands whenever they eat bread.” ");
INSERT INTO engf35_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","So in answer He said to them: “Why do you even transgress the commandment of God through your tradition? ");
INSERT INTO engf35_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","For God commanded saying, ‘Honor your father and your mother,’ and ‘He who curses father or mother, let him be put to death.’ ");
INSERT INTO engf35_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","But you say: ‘Whoever says to his father or mother, “Whatever you might be profited by me is a gift to God”— ");
INSERT INTO engf35_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","then he must not honor his father or mother.’ Thus you have nullified the commandment of God through your tradition. ");
INSERT INTO engf35_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hypocrites! Well did Isaiah prophesy about you saying: ");
INSERT INTO engf35_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘These people draw near to Me with their mouth and honor Me with their lips, but their heart is far away from Me. ");
INSERT INTO engf35_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","But in vain do they worship Me, teaching as doctrines the commandments of men.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Then summoning the crowd He said to them: “Hear and understand. ");
INSERT INTO engf35_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Not what goes into the mouth defiles the man, but what comes out of the mouth—this defiles the man.” ");
INSERT INTO engf35_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Then His disciples came and said to Him, “Do you know that upon hearing this saying the Pharisees were offended?” ");
INSERT INTO engf35_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","But in answer He said: “Every plant that my heavenly Father did not plant will be uprooted. ");
INSERT INTO engf35_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Leave them alone. They are blind guides of the blind; and if the blind guides the blind, both will fall into a ditch.” ");
INSERT INTO engf35_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Then Peter answered and said to Him, “Explain this parable to us.” ");
INSERT INTO engf35_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","So Jesus said: “Are you also still without understanding? ");
INSERT INTO engf35_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Do you not yet understand that whatever enters the mouth goes into the stomach and is expelled into the sewer? ");
INSERT INTO engf35_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","But the things coming out of the mouth actually come from the heart; those are the things that defile the man. ");
INSERT INTO engf35_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Because out of the heart proceed malignant thoughts, murders, adulteries, fornications, thefts, false witness, blasphemies. ");
INSERT INTO engf35_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","These are the things that defile the man, but to eat with unwashed hands does not defile the man.” ");
INSERT INTO engf35_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Going out from there Jesus withdrew into the region of Tyre and Sidon. ");
INSERT INTO engf35_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","And then, a Canaanite woman coming from those parts cried out to Him saying: “Have mercy on me, Lord, Son of David! My daughter is severely demonized.” ");
INSERT INTO engf35_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","But He answered her not a word. So His disciples came and urged Him saying, “Send her away, because she is crying out after us.” ");
INSERT INTO engf35_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","But in answer He said, “I was not sent except to the lost sheep of the house of Israel.” ");
INSERT INTO engf35_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","So she came and worshiped Him saying, “Lord, help me!” ");
INSERT INTO engf35_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","But in answer He said, “It is not good to take the children's bread and throw it to the little dogs.” ");
INSERT INTO engf35_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","So she said, “Yes, Lord, yet even the little dogs eat the crumbs that fall from their masters' table.” ");
INSERT INTO engf35_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Then Jesus answered and said to her: “O woman, great is your faith! Let it be to you as you desire.” And her daughter was healed from that very hour. ");
INSERT INTO engf35_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Moving on from there, Jesus went alongside the Sea of Galilee, and going up on the mountain He sat down there. ");
INSERT INTO engf35_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","And large crowds approached Him, having with them lame, blind, mute, maimed and many others, and they placed them at Jesus' feet, and He healed them. ");
INSERT INTO engf35_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","So the crowds marveled—seeing mutes speaking, maimed made whole, lame walking, and blind seeing—and they kept glorifying the God of Israel. ");
INSERT INTO engf35_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Then Jesus summoned His disciples and said: “I have compassion on the crowd, because they have already remained with me three days, and have nothing to eat; and I do not want to send them away hungry, lest they faint on the way.” ");
INSERT INTO engf35_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","So His disciples say to Him, “Where could we get, in an uninhabited place, enough bread so as to satisfy such a great crowd?” ");
INSERT INTO engf35_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus says to them, “How many loaves do you have?” And they said, “Seven, and a few small fish.” ");
INSERT INTO engf35_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","So He commanded the crowds to recline on the ground. ");
INSERT INTO engf35_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","And taking the seven loaves and the fish, He gave thanks, broke and gave to His disciples, and the disciples to the crowd. ");
INSERT INTO engf35_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","So they all ate and were filled; and they took up seven hampers full of the fragments that remained. ");
INSERT INTO engf35_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Now those who ate were four thousand men, besides women and children. ");
INSERT INTO engf35_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","And having dismissed the crowds He got into the boat and went to the region of Magdala. ");
INSERT INTO engf35_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","The Pharisees and Sadducees came, and testing Him they asked Him to show them a sign from heaven. ");
INSERT INTO engf35_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","But in answer He said to them: “When it is evening you say, ‘Fair weather, for the sky is red’; ");
INSERT INTO engf35_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","and in the morning, ‘Today will be stormy, for the sky is red and overcast.’ Hypocrites! You know how to discern the face of the sky, but cannot discern the signs of the times. ");
INSERT INTO engf35_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A malignant and adulterous generation seeks a sign, but no sign will be given to it except the sign of the prophet Jonah.” And leaving them behind He went away. ");
INSERT INTO engf35_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Upon arriving at the other side His disciples had forgotten to take bread. ");
INSERT INTO engf35_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Then Jesus said to them, “Watch and beware of the leaven of the Pharisees and Sadducees.” ");
INSERT INTO engf35_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","So they reasoned among themselves saying, “It's because we didn't bring any bread.” ");
INSERT INTO engf35_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","But Jesus, being aware, said to them: “You little-faiths! Why are you reasoning among yourselves because you didn't bring any bread? ");
INSERT INTO engf35_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Do you not yet perceive nor remember the five loaves of the five thousand and how many baskets you took up? ");
INSERT INTO engf35_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nor the seven loaves of the four thousand and how many hampers you took up? ");
INSERT INTO engf35_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","How come you don't perceive that it wasn't about bread that I told you to beware of the leaven of the Pharisees and Sadducees?” ");
INSERT INTO engf35_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Then they understood that He did not say to beware of the leaven of bread, but of the doctrine of the Pharisees and Sadducees. ");
INSERT INTO engf35_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","When Jesus came into the region of Caesarea Philippi He questioned His disciples saying, “Who do people say that I, the Son of the Man, am?” ");
INSERT INTO engf35_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","So they said, “Some say John the Baptizer, others Elijah, and still others Jeremiah or one of the prophets.” ");
INSERT INTO engf35_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","He says to them, “But you, who do you say that I am?” ");
INSERT INTO engf35_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","So in answer Simon Peter said, “You are the Christ, the Son of the Living God!” ");
INSERT INTO engf35_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","And in answer Jesus said to him: “Blessed are you, Simon son of Jonah, because flesh and blood did not reveal this to you, but my Father who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","And I further say to you that you are a stone, but on this bedrock I will build my church, and the gates of Hades will not withstand her. ");
INSERT INTO engf35_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","And I will give you (sg) the keys of the kingdom of the heavens, and whatever you bind on earth will have been bound in the heavens, and whatever you loose on earth will have been loosed in the heavens.” ");
INSERT INTO engf35_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Then He ordered His disciples not to tell anyone that He was the Messiah. ");
INSERT INTO engf35_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","From then on Jesus began to show to His disciples that He had to go to Jerusalem and suffer many things from the elders and chief priests and scribes, and be killed, and be raised on the third day. ");
INSERT INTO engf35_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","So taking Him aside Peter began to rebuke Him saying: “Mercy to you, Lord! This shall not happen to you!” ");
INSERT INTO engf35_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","But turning He said to Peter: “Get behind me, Satan! You are a stumbling block to me, because you are not mindful of God's values, but of men's values.” ");
INSERT INTO engf35_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Then Jesus said to His disciples: “If anyone desires to come after me, let him really deny himself, and take up his cross, and follow me. ");
INSERT INTO engf35_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","For whoever desires to save his life will waste it, but whoever ‘wastes’ his life on my account will find it. ");
INSERT INTO engf35_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","For what is a man profited if he gains the whole world but forfeits his life? Or what will a man give in exchange for his life? ");
INSERT INTO engf35_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","For the Son of the Man will certainly come in the glory of His Father with His angels, and then He will recompense each according to his performance. ");
INSERT INTO engf35_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Assuredly I say to you, there are some standing here who will not taste death until they see the Son of the Man coming in His kingdom.” ");
INSERT INTO engf35_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Now after six days Jesus takes Peter, James and his brother John and leads them up on a high mountain, in private. ");
INSERT INTO engf35_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","And He was transfigured before them and his face shone like the sun, while His clothes became as white as the light. ");
INSERT INTO engf35_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","When wow, Moses and Elijah appeared to them, conversing with Him. ");
INSERT INTO engf35_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Then Peter reacted and said to Jesus, “Lord, it is good for us to be here; if you wish, let us make three booths: one for you, one for Moses and one for Elijah.” ");
INSERT INTO engf35_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","While he was still speaking a brilliant cloud overshadowed them, and then, a Voice came out of the cloud saying: “This is my beloved Son in whom I am always well pleased. Hear Him!” ");
INSERT INTO engf35_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","As the disciples heard it they fell on their faces and were greatly afraid. ");
INSERT INTO engf35_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Then Jesus came and touched them and said, “Get up, don't be afraid.” ");
INSERT INTO engf35_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","So lifting up their eyes they saw no one but Jesus only. ");
INSERT INTO engf35_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","As they were coming down from the mountain, Jesus commanded them saying, “Tell no one the vision until the Son of the Man is risen from the dead.” ");
INSERT INTO engf35_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","So His disciples questioned Him saying, “Why then do the scribes say that Elijah must come first?” ");
INSERT INTO engf35_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","In answer Jesus said to them: “Elijah is indeed coming first, and he will restore all things. ");
INSERT INTO engf35_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","But I say to you that ‘Elijah’ has come already, and they did not recognize him, but did to him whatever they wished. Thus also the Son of the Man is about to suffer at their hands.” ");
INSERT INTO engf35_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Then the disciples understood that He spoke to them of John the Baptizer. ");
INSERT INTO engf35_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","As they came to the crowd a man approached Him and kneeling to Him said: ");
INSERT INTO engf35_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lord, have mercy on my son, because he is moonstruck and suffers badly! For he often falls into the fire and often into the water. ");
INSERT INTO engf35_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","So I brought him to your disciples, but they could not cure him.” ");
INSERT INTO engf35_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Then in answer Jesus said: “O faithless and perverse generation, how long must I be with you? How long must I put up with you? Bring him here to me.” ");
INSERT INTO engf35_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","And Jesus rebuked the demon and it came out of him, and the boy was healed from that very hour. ");
INSERT INTO engf35_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Then the disciples came to Jesus privately and said, “Why were we not able to cast it out?” ");
INSERT INTO engf35_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","So Jesus said to them: “Because of your unbelief; for assuredly I say to you, if you have faith like a mustard seed has, you (ye) will say to this mountain, ‘Move from here to there,’ and it will move; and nothing will be impossible for you. ");
INSERT INTO engf35_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","However, this class does not go out except by prayer and fasting.” ");
INSERT INTO engf35_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","While they were staying in Galilee Jesus said to them, “The Son of the Man is about to be betrayed into the hands of men, ");
INSERT INTO engf35_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","and they will kill Him, and on the third day He will be raised.” And they were seriously grieved. ");
INSERT INTO engf35_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","When they entered Capernaum those who collected the temple tax approached Peter and said, “Does your Teacher not pay the temple tax?” ");
INSERT INTO engf35_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","He says, “Yes.” So when they entered the house Jesus anticipated him saying: “Simon, what do you think? From whom do the kings of the earth take customs or poll tax, from their sons or from strangers?” ");
INSERT INTO engf35_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter says to Him, “From the strangers.” Jesus said to him: “Well then, the sons are free. ");
INSERT INTO engf35_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","But, lest we offend them, go to the sea, cast in a hook, and take the fish that comes up first. And opening its mouth you will find a ‘stater’ a coin; take that and give it to them for me and you.” ");
INSERT INTO engf35_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","At that time the disciples approached Jesus saying, “Who then is greater in the kingdom of the heavens?” ");
INSERT INTO engf35_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","So Jesus called a little child to Him, set him in the midst of them, ");
INSERT INTO engf35_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","and said: “Assuredly I say to you, unless you change and become like little children, you will not enter the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Therefore whoever will humble himself like this little child, he is the greater in the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Whoever receives one little child like this in my name, receives me; ");
INSERT INTO engf35_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","but whoever should cause one of these little ones who believe into me to fall, it would be better for him if a large millstone were hung on his neck and he were drowned in the depth of the sea! ");
INSERT INTO engf35_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Woe to the world because of offenses! Now it is necessary that offenses come, but woe to that person by whom the offense comes! ");
INSERT INTO engf35_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“If your hand or your foot is causing you to fall, cut them off and throw them away! It is better for you to enter into the life lame or maimed than to be thrown into the everlasting fire, having two hands or two feet. ");
INSERT INTO engf35_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","And if your eye is causing you to fall, tear it out and throw it away! It is better for you to enter into the life one eyed than to be thrown into the fiery Hell, having two eyes. ");
INSERT INTO engf35_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“See to it that you do not despise one of these little ones, for I say to you that in heaven their angels always see the face of my Father, who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","For the Son of the Man came to save the lost. ");
INSERT INTO engf35_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","What do you think? If some man has a hundred sheep and one of them goes astray, does he not leave the ninety-nine in the mountains to go and search for the stray? ");
INSERT INTO engf35_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","And if he happens to find it, assuredly I say to you, he rejoices more over it than over the ninety-nine that did not go astray. ");
INSERT INTO engf35_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Likewise it is not a desire, in the view of your Father in heaven, that one of these little ones should be wasted. ");
INSERT INTO engf35_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Now if your brother sins against you, go, confront him between you and him alone. If he hears you, you have won your brother. ");
INSERT INTO engf35_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","But should he not hear, take along with you one or two more, so that every word may be established by the mouth of two or three witnesses. ");
INSERT INTO engf35_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","And should he refuse to hear them, tell it to the congregation. But should he refuse to hear even the congregation, let him be to you just like the heathen and the tax collector. ");
INSERT INTO engf35_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Assuredly I say to you, whatever (pl.) you (pl.) may bind on earth will have been bound in heaven, and whatever you may loose on earth will have been loosed in heaven. ");
INSERT INTO engf35_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Assuredly again, I say to you that if two of you should agree on earth about any subject whatever that they may ask, it will be done for them by my Father who is in heaven. ");
INSERT INTO engf35_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Because where there are two or three gathered together into my name, there I am in their midst!” ");
INSERT INTO engf35_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Then Peter approached Him and said, “Lord, how often shall my brother sin against me and I forgive him; up to seven times?” ");
INSERT INTO engf35_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus says to him: “Not, I tell you, up to seven, but up to seventy-seven times! ");
INSERT INTO engf35_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Therefore the kingdom of the heavens is like a certain king who wanted to settle accounts with his servants. ");
INSERT INTO engf35_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","And as he began to settle up, one debtor of ten thousand talents was brought to him. ");
INSERT INTO engf35_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","But since he had nothing with which to repay, his lord commanded that he be sold, with his wife and children and everything he had, so as to be repaid. ");
INSERT INTO engf35_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","So then the servant fell down and did obeisance to him saying, ‘Lord, be patient with me and I will repay you all.’ ");
INSERT INTO engf35_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","So the lord of that servant, having compassion, released him and forgave him the loan. ");
INSERT INTO engf35_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“But when that servant went out he found one of his fellow servants who owed him a hundred denarii; and grabbing him he started choking him saying, ‘Pay me back what you owe!’ ");
INSERT INTO engf35_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","So his fellow servant fell down at his feet and kept begging him saying, ‘Be patient with me and I will pay you back.’ ");
INSERT INTO engf35_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","But he would not; instead he went and threw him into prison until he should pay back what was owed. ");
INSERT INTO engf35_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","But when his fellow servants saw what had happened they were really grieved, and they went and reported to their lord everything that had happened. ");
INSERT INTO engf35_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Then summoning him the lord says to him: ‘Malignant servant! I forgave you all that debt because you begged me. ");
INSERT INTO engf35_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Were you also not obligated to have mercy on your fellow servant, just as I had mercy on you?’ ");
INSERT INTO engf35_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","So in anger the lord handed him over to the torturers until he should repay all that was owed to him. ");
INSERT INTO engf35_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“My heavenly Father will handle you just like that, if each of you does not forgive his brother his trespasses, from the heart.” ");
INSERT INTO engf35_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Now it happened, when Jesus had finished these words, that He departed from Galilee and went to the borders of Judea beyond the Jordan. ");
INSERT INTO engf35_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","And large crowds followed Him and there He healed them. ");
INSERT INTO engf35_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","The Pharisees also came to Him to test Him, saying to Him, “Is it permissible for a man to divorce his wife for just any cause?” ");
INSERT INTO engf35_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","So in answer He said to them: “Have you never read that the Creator at the beginning made them a male and a female? ");
INSERT INTO engf35_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","And He said, ‘For this reason a man shall leave his father and mother and be joined to his wife, and the two shall be turned into one flesh.’ ");
INSERT INTO engf35_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","So then, they are no longer two, but one flesh. Therefore, what God joined together let not man separate!” ");
INSERT INTO engf35_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","They say to Him, “Why then did Moses command to give a certificate of divorce and to dismiss her?” ");
INSERT INTO engf35_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","He says to them: “Because of your hard-heartedness Moses permitted you to divorce your wives, but from the beginning it has not been so. ");
INSERT INTO engf35_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","And I say to you that whoever divorces his wife, except for fornication, and marries another commits adultery; and whoever marries a divorcee commits adultery.” ");
INSERT INTO engf35_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","His disciples say to Him, “If that's the situation of a man with his wife, it is better not to marry!” ");
INSERT INTO engf35_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","So He said to them: “Not all can assimilate this word, but those to whom it has been given. ");
INSERT INTO engf35_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","For there are eunuchs who were born that way, from their mother's womb; and there are eunuchs who were castrated by men; and there are eunuchs who castrated themselves for the sake of the kingdom of the heavens. He who is able to assimilate it, let him assimilate.” ");
INSERT INTO engf35_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Then little children were brought to Him, that He might lay hands on them and pray; but the disciples rebuked them. ");
INSERT INTO engf35_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","So Jesus said, “Let the little children come to me and do not forbid them, for of such is the kingdom of the heavens.” ");
INSERT INTO engf35_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","And after laying hands on them He moved on from there. ");
INSERT INTO engf35_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","And then, a certain one came and said to Him, “Good teacher, what good thing must I do so that I may have eternal life?” ");
INSERT INTO engf35_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","But He said to him: “Why do you call me good? No one is good except One, God. But if you want to enter into the life, keep the commandments.” ");
INSERT INTO engf35_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","He says to Him, “Which ones?” So Jesus said: “ ‘You shall not murder,’ ‘You shall not commit adultery,’ ‘You shall not steal,’ ‘You shall not give false witness,’ ");
INSERT INTO engf35_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Honor your father and your mother,’ and ‘You shall love your neighbor as yourself.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","The young man says to Him: “I have kept all these things since my youth. What do I still lack?” ");
INSERT INTO engf35_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus said to him, “If you want to be perfect, go sell your possessions and give to the poor, and you will have treasure in heaven; and come follow me.” ");
INSERT INTO engf35_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","So upon hearing that word the young man went away sorrowful, for he had great possessions. ");
INSERT INTO engf35_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Then Jesus said to His disciples: “Assuredly I say to you that only with difficulty will a rich person enter into the kingdom of the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","And again I say to you, it is easier for a camel to pass through the eye of a needle than for a rich person to enter into the kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Upon hearing it His disciples were really flabbergasted saying, “Who then can be saved?” ");
INSERT INTO engf35_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","So looking at them Jesus said, “With men this is impossible, but with God all things are possible.” ");
INSERT INTO engf35_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Then Peter answered and said to Him: “See, we have left all and followed you. So what will we have?” ");
INSERT INTO engf35_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","So Jesus said to them: “Assuredly I say to you that in the Regeneration, when the Son of the Man sits on the throne of His glory, you who have followed me will also sit on twelve thrones, judging the twelve tribes of Israel. ");
INSERT INTO engf35_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","And, everyone who left houses or brothers or sisters or father or mother or wife or children or fields for my name's sake will receive a hundredfold, and will inherit life eternal. ");
INSERT INTO engf35_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","But many ‘first’ will be last, and ‘last’ first. ");
INSERT INTO engf35_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“For the kingdom of the heavens is like a certain landowner who went out early in the morning to hire workers for his vineyard. ");
INSERT INTO engf35_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","And agreeing with the workers for a denarius a day he sent them into his vineyard. ");
INSERT INTO engf35_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","And going out about the third hour 9 a.m. he saw others standing idle in the marketplace. ");
INSERT INTO engf35_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","And he said to them, ‘You also go into the vineyard and I will give you whatever is right.’ So off they went. ");
INSERT INTO engf35_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","He went out again about the sixth hour, and the ninth, and did the same. ");
INSERT INTO engf35_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Now about the eleventh hour he went out and found others standing idle, and he says to them, ‘Why have you stood here idle all day?’ ");
INSERT INTO engf35_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","They say to him, ‘Because no one hired us.’ He says to them, ‘You also go into the vineyard, and you will receive whatever is right.’ ");
INSERT INTO engf35_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","So when evening had come the owner of the vineyard says to his foreman, ‘Call the workers and pay them their wage, beginning at the last to the first.’ ");
INSERT INTO engf35_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","The eleventh hour ones came and each received a denarius. ");
INSERT INTO engf35_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","So when the first ones came they supposed that they would receive more; yet each of them also received a denarius. ");
INSERT INTO engf35_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","When they received it they began grumbling against the landowner ");
INSERT INTO engf35_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","saying, ‘These last worked only one hour, and you made them equal to us who bore the burden and the heat of the day!’ ");
INSERT INTO engf35_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","But in answer he said to one of them: ‘Friend, I am not wronging you. Did you not agree with me for a denarius? ");
INSERT INTO engf35_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Take what is yours and go. I wish to give to this last one just as to you. ");
INSERT INTO engf35_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Or is it not permissible for me to do what I want with what is mine? Is your eye evil because I am good?’ ");
INSERT INTO engf35_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Just so the last will be first, and the first last. For many are called, but few are chosen.” ");
INSERT INTO engf35_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","As Jesus was on His way to Jerusalem He took the twelve disciples aside on the road and said to them privately: ");
INSERT INTO engf35_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Listen! We are going up to Jerusalem and the Son of the Man will be betrayed to the chief priests and scribes; and they will condemn Him to death, ");
INSERT INTO engf35_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","and they will hand Him over to the Gentiles to mock, to scourge and to crucify. And on the third day He will rise!” ");
INSERT INTO engf35_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Then the mother of Zebedee's sons approached Him, with her sons, and kneeling down she asked something from Him. ");
INSERT INTO engf35_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","So He said to her, “What do you wish?” She says to Him, “State that these my two sons may sit one on Your right and one on Your left in Your kingdom.” ");
INSERT INTO engf35_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","But in answer Jesus said: “You (pl.) do not know what you are asking. Are you able to drink the cup which I am about to drink, or to be baptized with the baptism that I am being baptized with?” They say to Him, “We are able.” ");
INSERT INTO engf35_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","And He says to them: “You will indeed drink my cup, and you will be baptized with the baptism that I am being baptized with, but to sit on my right and on my left is not mine to give; rather it is for those for whom it has been prepared by my Father.” ");
INSERT INTO engf35_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Now when the ten heard it they were indignant at the two brothers. ");
INSERT INTO engf35_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","But summoning them Jesus said: “You know that the rulers of the nations lord it over them, and the great exercise authority over them; ");
INSERT INTO engf35_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","but it must not be so among you. Rather, whoever wants to become great among you must be your servant, ");
INSERT INTO engf35_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","and whoever wants to be first among you must be your slave; ");
INSERT INTO engf35_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","just like the Son of the Man—He did not come to be served but to serve, and to give His life as a ransom for many.” ");
INSERT INTO engf35_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Now as they went on from Jericho a large crowd followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","And then, two blind men sitting alongside the road and hearing, “Jesus is passing by!” cried out saying, “Have mercy on us, Lord, Son of David!” ");
INSERT INTO engf35_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","So the crowd threatened them to be quiet, but they cried out all the more saying, “Have mercy on us, Lord, Son of David!!” ");
INSERT INTO engf35_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus stopped, called them and said, “What do you want me to do for you?” ");
INSERT INTO engf35_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","They say to Him, “Lord, that our eyes may be opened!” ");
INSERT INTO engf35_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","So Jesus had compassion and touched their eyes, and immediately their eyes received sight, and they followed Him. ");
INSERT INTO engf35_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Now when they drew near to Jerusalem and came to Bethphage, opposite the Mount of Olives, then Jesus sent two disciples, ");
INSERT INTO engf35_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","saying to them: “Go into the village opposite you and immediately you will find a donkey tied, and a colt with her. Loose her and bring them to me. ");
INSERT INTO engf35_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","And if anyone says anything to you, just say, ‘The Lord needs them,’ and immediately he will send them.” ");
INSERT INTO engf35_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Now all this happened so that what was spoken through the prophet should be fulfilled, namely: ");
INSERT INTO engf35_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Say to the daughter of Zion, ‘Look, your King is coming to you, humble and mounted on a donkey, in fact, a young donkey, foal of a beast of burden.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","So going and doing just as Jesus had commanded them, ");
INSERT INTO engf35_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","the disciples brought the female donkey and the young donkey. And they placed their clothes on them and He sat down on them the clothes. ");
INSERT INTO engf35_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","And the very large crowd spread their clothes on the road, while others were cutting branches from the trees and spreading them on the road. ");
INSERT INTO engf35_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Then the crowds who went in front and those who followed kept crying out, saying: “Hosanna to the Son of David! Blessed is He who comes in the name of the Lord! Hosanna in the highest heaven!” ");
INSERT INTO engf35_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","So when He came into Jerusalem the whole city was stirred up, saying, “Who is this?” ");
INSERT INTO engf35_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","And the crowds kept saying, “This is Jesus, the prophet from Natsareth of Galilee.” ");
INSERT INTO engf35_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus went into the temple of God and drove out all who were selling and buying in the temple, and He overturned the tables of the money changers and the seats of those who sold the doves. ");
INSERT INTO engf35_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","And He says to them, “It is written, ‘My house will be called a house of prayer,’ but you have made it ‘a cave of bandits’.” ");
INSERT INTO engf35_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","And the lame and the blind came to Him in the temple, and He healed them. ");
INSERT INTO engf35_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","But seeing the wonders that He did, and the children calling out in the temple and saying, “Hosanna to the Son of David!” the chief priests and the scribes became indignant ");
INSERT INTO engf35_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","and said to Him, “Do you hear what these are saying?” So Jesus says to them: “Yes. Have you never read that ‘Out of the mouth of babies and nursing infants You have prepared praise for Yourself’?” ");
INSERT INTO engf35_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Leaving them behind He went out of the city to Bethany and lodged there. ");
INSERT INTO engf35_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Now in the early morning, as He returned to the city, He was hungry. ");
INSERT INTO engf35_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","And seeing a lone fig tree by the road, He went up to it and found nothing on it, just leaves. And He says to it, “May you never again produce fruit!” And forthwith the fig tree started to wither. ");
INSERT INTO engf35_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","And seeing it the disciples marveled saying, “How quickly the fig tree became withered!” ");
INSERT INTO engf35_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","So in answer Jesus said to them: “Assuredly I say to you, if you (pl.) have faith and do not doubt, you will not only do what was done to the fig tree, but even if you should say to this mountain, ‘Be taken up and be thrown into the sea,’ it will happen. ");
INSERT INTO engf35_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","And anything whatever you may ask in the believing prayer, you will receive.” ");
INSERT INTO engf35_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","So He came into the temple, and as He was teaching the chief priests and the elders of the people approached Him saying, “By what kind of authority are you doing these things?” and “Who gave you this authority?” ");
INSERT INTO engf35_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","But in answer Jesus said to them: “I also will ask you one question, which if you tell me, I also will tell you by what authority I do these things: ");
INSERT INTO engf35_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","The baptism of John—where was it from; from heaven or from men?” So they reasoned among themselves saying: “If we say, ‘From heaven,’ He will say to us, ‘Why then did you not believe him?’ ");
INSERT INTO engf35_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","But if we say, ‘From men,’ we fear the crowd, for all consider John as a prophet.” ");
INSERT INTO engf35_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","So in answer to Jesus they said, “We do not know.” So He said to them: “Neither do I tell you by what authority I do these things. ");
INSERT INTO engf35_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“But what do you think? A certain man had two sons, and going to the first he said, ‘Son, go work today in my vineyard.’ ");
INSERT INTO engf35_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","But in answer he said, ‘I don't want to’ (but later he changed his mind and went). ");
INSERT INTO engf35_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","And going to the other he said likewise. And in answer he said, ‘I go, Sir’; yet he did not go. ");
INSERT INTO engf35_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Which of the two did the will of the father?” They say to Him, “The first.” Jesus says to them: “Assuredly I say to you that the tax collectors and the prostitutes will go into the kingdom of God before you do. ");
INSERT INTO engf35_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","For John came to you in the way of righteousness, and you did not believe him; but the tax collectors and the prostitutes believed him, yet when you saw it you did not afterward repent, so as to believe him. ");
INSERT INTO engf35_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Hear another parable: There was a certain landowner who planted a vineyard and set a hedge around it, dug a winepress in it and built a tower. And he leased it to farmers and went on a journey. ");
INSERT INTO engf35_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","When vintage-time drew near he sent his servants to the farmers to receive his fruits. ");
INSERT INTO engf35_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","But the farmers took his servants—one they beat, one they killed, one they stoned. ");
INSERT INTO engf35_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Again he sent other servants, more than the first, and they did to them likewise. ");
INSERT INTO engf35_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","So finally he sent his son to them saying, ‘They will respect my son.’ ");
INSERT INTO engf35_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","But when the farmers saw the son they said among themselves: ‘This is the heir. Come, let us kill him and take possession of his inheritance.’ ");
INSERT INTO engf35_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","And taking him they threw him out of the vineyard and killed him. ");
INSERT INTO engf35_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Therefore, when the owner of the vineyard comes, what will he do to those farmers?” ");
INSERT INTO engf35_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","They say to Him: “He will miserably destroy those miserable men! And he will lease the vineyard to other farmers who will render to him the fruits in their seasons.” ");
INSERT INTO engf35_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus says to them: “Did you never read in the Scriptures: ‘A stone which the builders rejected, this one became the cornerstone. This was the Lord's doing, and it is marvelous in our eyes’? ");
INSERT INTO engf35_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Therefore I say to you that the kingdom of God will be taken away from you and given to a nation producing the fruits of it. ");
INSERT INTO engf35_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Also, whoever falls upon this stone will be broken to pieces; but upon whomever it falls, it will grind him to powder.” ");
INSERT INTO engf35_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","As the chief priests and Pharisees heard His parables they knew that He was speaking about them. ");
INSERT INTO engf35_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","And although they wanted to seize Him, they were afraid of the crowds, because they considered Him as a prophet. ");
INSERT INTO engf35_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus answered and spoke to them again in parables saying: ");
INSERT INTO engf35_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“The kingdom of the heavens is like a certain king who prepared a wedding feast for his son. ");
INSERT INTO engf35_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","And he sent out his servants to call those who had been invited to the wedding feast, but they did not want to come. ");
INSERT INTO engf35_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Again he sent out other servants saying: ‘Say to those who have been invited: “See, I have prepared my dinner; my oxen and fatted cattle are butchered, and everything is ready. Come to the wedding feast!” ’ ");
INSERT INTO engf35_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Now the indifferent ones just took off—one to his own field, another to his business. ");
INSERT INTO engf35_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","But the rest, seizing his servants mistreated and killed them! ");
INSERT INTO engf35_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","So when that king heard about it he was furious; and sending his troops he destroyed those murderers and burned up their city. ");
INSERT INTO engf35_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Then he says to his servants: ‘The wedding is ready, but those who were invited were not worthy. ");
INSERT INTO engf35_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","So go on the roads leading out of town, and as many as you may find invite to the wedding feast.’ ");
INSERT INTO engf35_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","And going out on the roads those servants gathered together everyone they found, both evil and good; and the wedding hall was filled with guests. ");
INSERT INTO engf35_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","But when the king came in to look at the guests, he saw there a man who had not been clothed with a wedding garment. ");
INSERT INTO engf35_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","So he says to him, ‘Friend, how did you get in here without a wedding garment?’ And he was speechless. ");
INSERT INTO engf35_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Then the king said to the servants, ‘Tie him up hand and foot, take him away and throw him out into the darkness farthest away.’ There there will be weeping and gnashing of teeth. ");
INSERT INTO engf35_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","For many are called, but few chosen.” ");
INSERT INTO engf35_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Then the Pharisees went and plotted how they might trap Him in some word. ");
INSERT INTO engf35_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","So they send their disciples to Him, with the Herodians, saying: “Teacher, we know that you are truthful and teach the way of God in truth; and you are not impressed by anyone, for you do not look at people's faces. ");
INSERT INTO engf35_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","So tell us, what do you think: is it lawful to pay tax to Caesar, or not?” ");
INSERT INTO engf35_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","But perceiving their malignancy Jesus said: “Hypocrites! Why do you test me? ");
INSERT INTO engf35_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Show me the tax coin.” So they brought Him a denarius. ");
INSERT INTO engf35_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","And He says to them, “Whose image and inscription is this?” ");
INSERT INTO engf35_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","They say to Him, “Caesar's.” Then He says to them, “Render therefore to Caesar the things that are Caesar's, and to God the things that are God's!” ");
INSERT INTO engf35_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","And hearing it they marveled, and leaving Him they went away. ");
INSERT INTO engf35_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","The same day the Sadducees, who say there is no resurrection, came to Him and asked Him ");
INSERT INTO engf35_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","saying: “Teacher, Moses said that if someone dies having no children his brother must marry the widow and raise up offspring for his brother. ");
INSERT INTO engf35_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Now there were seven brothers among us. The first married and died, and having no offspring he left his widow to his brother. ");
INSERT INTO engf35_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","So also the second, and the third, up to the seventh. ");
INSERT INTO engf35_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Last of all, the woman died too. ");
INSERT INTO engf35_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Therefore in the resurrection whose wife, of the seven, will she be? For they all had her.” ");
INSERT INTO engf35_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","So in answer Jesus said to them: “You are deceived, not knowing the Scriptures nor the power of God! ");
INSERT INTO engf35_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","For in the resurrection they neither marry nor are given in marriage, but are like angels of God in heaven. ");
INSERT INTO engf35_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","But concerning the resurrection of the dead, have you not read what was spoken to you by God saying, ");
INSERT INTO engf35_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘I am the God of Abraham, and the God of Isaac, and the God of Jacob’? God is not God of dead people but of living.” ");
INSERT INTO engf35_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Now as the crowds heard Him they were astonished at His teaching. ");
INSERT INTO engf35_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Now when the Pharisees heard that He had silenced the Sadducees, they got together. ");
INSERT INTO engf35_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","And one of them, a lawyer, testing Him, questioned and said, ");
INSERT INTO engf35_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Teacher, which is the great commandment in the Law?” ");
INSERT INTO engf35_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","So Jesus said to him: “ ‘You must love the Lord your God with your whole heart, and with your whole soul, and with your whole mind.’ ");
INSERT INTO engf35_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","This is the first and great commandment. ");
INSERT INTO engf35_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","And the second is like it, ‘You must love your neighbor as yourself.’ ");
INSERT INTO engf35_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","On these two commandments hang the whole Law, and the Prophets.” ");
INSERT INTO engf35_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","While the Pharisees were assembled, Jesus asked them ");
INSERT INTO engf35_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","saying, “What do you think about the Christ; whose Son is He?” They say to Him, “David's.” ");
INSERT INTO engf35_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","He says to them: “How then does David in the Spirit call Him ‘Lord’ saying, ");
INSERT INTO engf35_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘The Lord said to my Lord, “Sit at my right until I place your enemies as a footstool for your feet” ’? ");
INSERT INTO engf35_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Really now, if David calls Him ‘Lord’, how can He be his son?” ");
INSERT INTO engf35_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","And no one was able to answer Him a word, nor from that day on did anyone dare to question Him anymore. ");
INSERT INTO engf35_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Then Jesus spoke to the crowds and to His disciples ");
INSERT INTO engf35_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","saying: “The scribes and the Pharisees are seated upon Moses' chair; ");
INSERT INTO engf35_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","so whatever they may tell you to observe, you should observe and do; but do not do according to their deeds, for they say and do not do. ");
INSERT INTO engf35_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","For they package loads that are heavy and hard to bear, and lay them on the shoulders of the people; but they themselves do not want to move them with one of their fingers. ");
INSERT INTO engf35_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Rather, they do all their works in order to be seen by people. They make their phylacteries broad and the tassels on their garments large; ");
INSERT INTO engf35_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","they love the place of honor at dinners and the first seats in the synagogues, ");
INSERT INTO engf35_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","and the greetings in the marketplaces, namely to be called ‘Rabbi, Rabbi’ by the people. ");
INSERT INTO engf35_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“But you (pl.), do not be called ‘Rabbi’; because your Teacher is one, the Christ, and you are all brothers. ");
INSERT INTO engf35_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","And do not call anyone on earth your ‘father’; because your Father is one, He who is in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neither be called leaders/guides; because your Leader is one, the Christ. ");
INSERT INTO engf35_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","On the contrary, the greatest among you must be your servant. ");
INSERT INTO engf35_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","And whoever exalts himself will be humbled, and whoever humbles himself will be exalted. ");
INSERT INTO engf35_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Woe to you scribes and Pharisees, hypocrites! Because you devour the houses of the widows, while making long prayers as a pretense. Therefore you will receive a greater condemnation. ");
INSERT INTO engf35_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Woe to you scribes and Pharisees, hypocrites!! Because you bar the entrance to the kingdom of the heavens in the face of the people; for you neither go in yourselves nor do you allow those who are trying to enter to go in. ");
INSERT INTO engf35_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Woe to you scribes and Pharisees, hypocrites!!! Because you travel all over, land and sea, to make one convert, and when he joins up you make him twice as much a son of Hell as yourselves. ");
INSERT INTO engf35_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Woe to you blind guides, who say, ‘Whoever swears by the temple, it is nothing; but whoever swears by the gold of the temple is obligated.’ ");
INSERT INTO engf35_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Stupid and blind! For which is greater, the gold or the temple that sanctifies the gold? ");
INSERT INTO engf35_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","And, ‘Whoever swears by the altar, it is nothing; but whoever swears by the gift that is on it is obligated.’ ");
INSERT INTO engf35_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Stupid and blind!! For which is greater, the gift or the altar that sanctifies the gift? ");
INSERT INTO engf35_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Therefore he who swears by the altar swears by it and by all the things on it. ");
INSERT INTO engf35_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","And he who swears by the temple swears by it and by Him who used to dwell in it. ");
INSERT INTO engf35_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","And he who swears by heaven swears by the throne of God and by Him who sits on it. ");
INSERT INTO engf35_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Woe to you scribes and Pharisees, hypocrites! Because you pay a tithe of mint and dill and cummin, but have neglected the weightier items of the law: justice and mercy and faith. These it was obligatory to do, while not neglecting those. ");
INSERT INTO engf35_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Blind guides, who strain out a gnat but gulp down a camel! ");
INSERT INTO engf35_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Woe to you scribes and Pharisees, hypocrites!! Because you cleanse the outside of the cup and the dish, but inside they are full of plunder and injustice. ");
INSERT INTO engf35_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Blind Pharisee! First cleanse the inside of the cup and the dish, so that their outside may also be clean. ");
INSERT INTO engf35_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Woe to you scribes and Pharisees, hypocrites!!! Because you resemble whitewashed tombs, which indeed appear beautiful outwardly but inside are full of dead bones and of all uncleanness. ");
INSERT INTO engf35_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Just so, you also outwardly appear to be righteous to the people, but inside you are full of hypocrisy and lawlessness. ");
INSERT INTO engf35_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Woe to you scribes and Pharisees, hypocrites!!!! Because you build the tombs of the prophets and adorn the monuments of the righteous; ");
INSERT INTO engf35_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","yet you say, ‘If we had lived in the days of our fathers, we would not have been partakers with them in the blood of the prophets.’ ");
INSERT INTO engf35_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Therefore you testify against yourselves that you are sons of those who murdered the prophets. ");
INSERT INTO engf35_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","So fill up the measure of your fathers' guilt! ");
INSERT INTO engf35_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Snakes! Brood of vipers! How can you escape from the condemnation of Hell? ");
INSERT INTO engf35_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","So take note: I will send you prophets and wise men and Biblical scholars; some of them you will kill, even crucify; some of them you will flog in your synagogues and persecute from city to city ");
INSERT INTO engf35_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","—so that upon you may come all the righteous blood shed on the earth, from the blood of righteous Abel up to the blood of Zechariah son of Berechiah, whom you murdered between the temple and the altar. ");
INSERT INTO engf35_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Assuredly I say to you that all these things will come upon this generation. ");
INSERT INTO engf35_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem, she who kills the prophets and stones those who are sent to her! How often I wanted to gather your children, just like a hen gathers her chicks under her wings, but you did not want to. ");
INSERT INTO engf35_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Look, your house is left to you abandoned! ");
INSERT INTO engf35_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","For I say to you, you will not see me again until you say, ‘Blessed is He who comes in the name of the Lord’!” ");
INSERT INTO engf35_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","So as Jesus was going out, departing from the temple, His disciples came up to show Him the buildings of the temple. ");
INSERT INTO engf35_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","But Jesus said to them: “Do you not see all these things? Assuredly I say to you, absolutely not a single stone here will be left upon another, that will not be thrown down.” ");
INSERT INTO engf35_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Now as He was sitting on the Mount of Olives, the disciples came to Him privately saying: “Tell us, when will these things be? And what will be the sign of Your coming and of the completion of the age?” ");
INSERT INTO engf35_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","So in answer Jesus said to them: “Watch out, so that no one deceives you. ");
INSERT INTO engf35_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Because many will come in my name saying, ‘I am the Christ,’ and they will deceive many. ");
INSERT INTO engf35_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","You will be concerned when you hear of wars and rumors of wars; see to it that you not get worked up; for all of it has to happen, but the end is not yet. ");
INSERT INTO engf35_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","For nation will be raised up against nation and kingdom against kingdom, and there will be famines and pestilences and earthquakes in various places; ");
INSERT INTO engf35_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","but all these things are only a beginning of birth pains. ");
INSERT INTO engf35_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Then they will hand you over to oppression and kill you, and you will be hated by all nations for my name's sake. ");
INSERT INTO engf35_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","And then many will be offended, and they will betray one another and will hate one another. ");
INSERT INTO engf35_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","And many false prophets will be raised up and they will deceive many. ");
INSERT INTO engf35_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","And because of the increase of the lawlessness the love of the majority will grow cold. ");
INSERT INTO engf35_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","So the one who perseveres to the end, he will be saved. ");
INSERT INTO engf35_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","And this good news of the kingdom will be proclaimed in the whole inhabited earth as a witness to all the ethnic nations, and then the end will come. ");
INSERT INTO engf35_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“So then, when you (ye) see the ‘abomination of desolation’, spoken of by Daniel the prophet, standing in the holy place” (let the reader understand), ");
INSERT INTO engf35_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“then let those who are in Judea flee to the mountains. ");
INSERT INTO engf35_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Anyone on the housetop should not go down to take things out of his house, ");
INSERT INTO engf35_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","and anyone in the field should not go back to get his cloak. ");
INSERT INTO engf35_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","But woe to those who are pregnant and to those who are nursing a baby in those days! ");
INSERT INTO engf35_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","And pray that your flight may not happen in winter or on a Sabbath. ");
INSERT INTO engf35_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Because then there will be a great tribulation, such as has never been since the beginning of the world until now, and never again will be. ");
INSERT INTO engf35_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","And unless those days were cut short no flesh would be saved; but for the sake of the elect those days will be cut short. ");
INSERT INTO engf35_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Then if anyone says to you, ‘Look, the Messiah is here!’ or ‘there!’ do not believe him. ");
INSERT INTO engf35_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Because false christs and false prophets will be raised up, and they will give great signs and wonders so as to deceive, if possible, even the elect. ");
INSERT INTO engf35_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","See, I have told you beforehand. ");
INSERT INTO engf35_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","So if they should say to you, ‘Look, He is in the wilderness!’ do not go out; ‘Look, in the secret rooms!’ do not believe it. ");
INSERT INTO engf35_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Because just as the lightning comes from east and shines to west, so also will be the coming of the Son of the Man; ");
INSERT INTO engf35_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","for wherever the carcass may be there will be a gathering of vultures. ");
INSERT INTO engf35_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Immediately after the tribulation of those days, the sun will be darkened, and the moon will not give its light, and the stars will fall from the heaven, and the powers of the heavens will be shaken. ");
INSERT INTO engf35_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","And then the sign of the Son of the Man will appear in the sky, and then all the tribes of the earth will mourn—they will see the Son of the Man coming on the clouds of the heaven with power and great glory. ");
INSERT INTO engf35_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","And He will send out His angels with a great sound of a trumpet and they will collect His elect from the four winds, from one extreme of the heavens to the other. ");
INSERT INTO engf35_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Now learn this parable from the fig tree: when its branch has already become tender and it puts forth leaves, you know that the summer is near. ");
INSERT INTO engf35_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","So you also, whenever you see all these things, know that it is near, at the doors! ");
INSERT INTO engf35_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Assuredly I say to you, this generation will not pass away until all these things happen. ");
INSERT INTO engf35_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","The heaven and the earth will pass away, but my words will never pass away. ");
INSERT INTO engf35_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“But no one knows concerning that day and hour, not even the angels of the heavens, except my Father alone. ");
INSERT INTO engf35_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","But just as were the days of Noah, so also will be the coming of the Son of the Man. ");
INSERT INTO engf35_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","For just as they were eating and drinking, marrying and giving in marriage, in the days before the flood until the day that Noah entered the ark, ");
INSERT INTO engf35_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","and were not aware until the flood came and took all away, so also will be the coming of the Son of the Man. ");
INSERT INTO engf35_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Then two men will be in the field; one will be taken and the other will be left. ");
INSERT INTO engf35_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Two women will be grinding at the mill; one will be taken and the other will be left. ");
INSERT INTO engf35_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","So be watchful, because you (pl) do not know in what hour your Lord is coming. ");
INSERT INTO engf35_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","But know this, that if the master of the house had known in what watch the thief was coming, he would have stayed awake and not allowed his house to be broken into. ");
INSERT INTO engf35_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Therefore you also be ready, because the Son of the Man is coming at an hour that you do not suppose. ");
INSERT INTO engf35_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Who then is the faithful and prudent servant whom his lord placed over his corps of servants to give them food on schedule? ");
INSERT INTO engf35_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blessed be that servant whom his master, when he comes, will find doing so. ");
INSERT INTO engf35_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Assuredly I say to you that he will place him over all his possessions. ");
INSERT INTO engf35_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","But if that bad servant should say in his heart, ‘My lord is delaying his return,’ ");
INSERT INTO engf35_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","and should begin to beat his fellow servants, and to eat and drink with the drunkards, ");
INSERT INTO engf35_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","the lord of that servant will come on a day when he is not looking for him and at an hour when he is not aware, ");
INSERT INTO engf35_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","and will cut him in two and appoint his portion with the hypocrites. There, there will be weeping and gnashing of teeth. ");
INSERT INTO engf35_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Then the kingdom of the heavens will be like ten virgins who, taking their lamps, went out to meet the bridegroom. ");
INSERT INTO engf35_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Now five of them were prudent and five foolish. ");
INSERT INTO engf35_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Those who were foolish, taking their lamps, did not take extra oil with them, ");
INSERT INTO engf35_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","but the prudent ones took oil in their vessels along with their lamps. ");
INSERT INTO engf35_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Now while the bridegroom delayed they all dozed and slept, ");
INSERT INTO engf35_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","but at midnight there was a shout: ‘Attention! The bridegroom is coming; go out to meet him.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Then all those virgins got up and trimmed their lamps. ");
INSERT INTO engf35_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","And the foolish ones said to the prudent, ‘Give us some of your oil, because our lamps are going out.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","But the prudent ones answered saying, ‘No, in case there not be enough for you and us; instead, go to those who sell and buy for yourselves.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","But while they went to buy, the bridegroom arrived, and the ones who were ready went in with him to the marriage feast—and the door was shut! ");
INSERT INTO engf35_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Later the other virgins arrived too saying, ‘Lord, lord, open for us!’ ");
INSERT INTO engf35_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","But in answer he said, ‘Assuredly I say to you, I do not know you.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Therefore, keep alert, because you do not know the day nor the hour in which the Son of the Man is coming. ");
INSERT INTO engf35_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Because the kingdom is also like a man about to go on a long journey, who called his own servants and entrusted his possessions to them. ");
INSERT INTO engf35_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","To one he gave five talents, to another two, and to another one, to each according to his own ability; and immediately he went on the journey. ");
INSERT INTO engf35_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","So the one who received the five talents went and traded with them, and made another five talents. ");
INSERT INTO engf35_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","So also the one who received the two gained another two as well. ");
INSERT INTO engf35_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","But he who received the one went off and dug in the ground and hid his lord's silver. ");
INSERT INTO engf35_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Then, after a long time, the lord of those servants comes and settles accounts with them. ");
INSERT INTO engf35_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“So the one who had received the five talents approached and brought five more talents saying, ‘Lord, you entrusted five talents to me; see, I gained five more talents besides them!’ ");
INSERT INTO engf35_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","His lord said to him: ‘Super, you good and faithful servant! You were faithful over a few things, I will put you in charge of many things. Enter into the joy of your lord.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","So the one who had received the two talents also approached and said, ‘Lord, you entrusted two talents to me; see, I gained two more talents besides them!’ ");
INSERT INTO engf35_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","His lord said to him: ‘Super, you good and faithful servant! You were faithful over a few things, I will put you in charge of many things. Enter into the joy of your lord.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Then he who had received the one talent also approached and said: ‘Lord, I knew that you are a hard man, reaping where you did not sow and gathering where you did not scatter. ");
INSERT INTO engf35_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","And being afraid I went off and hid your talent in the ground; here, take what is yours.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","So in answer his lord said to him: ‘You wicked and lazy servant! You knew that I reap where I did not sow and gather where I did not scatter. ");
INSERT INTO engf35_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Therefore you were obligated to deposit my money with the bankers, and at my coming I would have received what is mine with interest. ");
INSERT INTO engf35_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Therefore, take the talent away from him and give it to the one having the ten talents. ");
INSERT INTO engf35_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","For to everyone who has, more will be given, and he will have abundance; but the one who does not have, even what he thinks that he has will be taken away from him. ");
INSERT INTO engf35_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","And throw out the useless servant, into the darkness farthest out!’ There, there will be weeping and gnashing of teeth. ");
INSERT INTO engf35_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“When the Son of the Man comes in His glory, and all the holy angels with Him, then He will sit on His throne of glory. ");
INSERT INTO engf35_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","And all the nations will be gathered before Him, and He will separate them one from another, just as a shepherd separates the sheep from the goats. ");
INSERT INTO engf35_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","And the sheep He will place on His right, but the goats on His left. ");
INSERT INTO engf35_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Then the King will say to those on His right: ‘Come, you blessed of my Father, inherit the kingdom that was prepared for you at the foundation of the world. ");
INSERT INTO engf35_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","For I was hungry and you gave me food; I was thirsty and you gave me drink; I was a stranger and you took me in; ");
INSERT INTO engf35_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I was naked and you clothed me; I was sick and you visited me; I was in prison and you came to me.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Then the righteous will answer Him saying: ‘Lord, when did we see you hungry and feed you, or thirsty and give you drink? ");
INSERT INTO engf35_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","When did we see you a stranger and take you in, or naked and clothe you? ");
INSERT INTO engf35_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Or when did we see you sick or in prison and come to you?’ ");
INSERT INTO engf35_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","And in answer the King will say to them, ‘Assuredly I say to you, inasmuch as you did it to one of the least of these my brothers, you did it to me.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Then He will also say to those on His left: ‘Go away from me, you accursed ones, into the eternal fire that was prepared for the devil and his angels. ");
INSERT INTO engf35_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","For I was hungry and you did not give me food; I was thirsty and you did not give me drink; ");
INSERT INTO engf35_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I was a stranger and you did not take me in; I was naked and you did not clothe me; I was sick and in prison and you did not visit me.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Then they also will answer saying, ‘Lord, when did we see you hungry or thirsty or a stranger or naked or sick or in prison and did not minister to you?’ ");
INSERT INTO engf35_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Then He will answer them saying, ‘Assuredly I say to you, inasmuch as you did not do it to one of the least of these, neither did you do it to me.’ ");
INSERT INTO engf35_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","And they will go away into everlasting punishment, but the righteous into eternal life.” ");
INSERT INTO engf35_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Now it happened, when Jesus had finished all these words, that He said to His disciples, ");
INSERT INTO engf35_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“You know that after two days the Passover takes place, and the Son of the Man will be handed over to be crucified.” ");
INSERT INTO engf35_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Then the chief priests, the scribes and the elders of the people assembled at the palace of the high priest, the one called Caiaphas, ");
INSERT INTO engf35_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","and they plotted to seize Jesus by trickery and kill Him. ");
INSERT INTO engf35_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","But they said, “Not during the feast, in order not to have an uproar among the people.” ");
INSERT INTO engf35_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Now when Jesus was in Bethany at the house of Simon the leper, ");
INSERT INTO engf35_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a woman approached Him, having an alabaster flask of very expensive perfume, and she began to pour it on His head as He reclined at the table. ");
INSERT INTO engf35_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","But upon seeing it His disciples were indignant saying: “Why this waste? ");
INSERT INTO engf35_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","For this perfume could have been sold for a good deal and given to the poor.” ");
INSERT INTO engf35_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","But being aware Jesus said to them: “Why are you bothering the woman? She has done something beautiful to me. ");
INSERT INTO engf35_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","You will always have the poor with you, but you will not always have me. ");
INSERT INTO engf35_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","In putting this perfume on my body she did it with a view to my burial. ");
INSERT INTO engf35_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Assuredly I say to you, wherever this gospel may be proclaimed in the whole world, what this woman did will also be told in her memory.” ");
INSERT INTO engf35_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Then one of the twelve, the one called Judas Iscariot, went to the chief priests ");
INSERT INTO engf35_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","and said, “What are you willing to give me so that I deliver Him to you?” So they counted out to him thirty silver coins. ");
INSERT INTO engf35_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","From then on he kept looking for an opportunity to betray Him. ");
INSERT INTO engf35_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Now on the first day of Unleavened Bread the disciples came to Jesus saying to Him, “Where do you want us to prepare for You to eat the Passover?” ");
INSERT INTO engf35_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","So He said: “Go into the city to ‘you know who’ and say to him, ‘The Teacher says, “My time is near, I will do the Passover with my disciples at your place.” ’ ” ");
INSERT INTO engf35_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","And the disciples did as Jesus directed them and prepared the Passover. ");
INSERT INTO engf35_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","When it was evening He was reclining at the table with the twelve. ");
INSERT INTO engf35_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","And as they were eating He said, “Assuredly I say to you that one of you will betray me.” ");
INSERT INTO engf35_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","This really upset them and they each began to say to Him, “It isn't me, is it, Lord?” ");
INSERT INTO engf35_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","In answer He said: “It is the one who dipped his hand in the bowl with me, he will betray me. ");
INSERT INTO engf35_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","The Son of the Man is really going just as it is written about Him, but woe to that man by whom the Son of the Man is betrayed! It would have been better for that man not to have been born.” ");
INSERT INTO engf35_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Then Judas, who was betraying Him, answered and said, “It isn't me, is it, Rabbi?” He says to him, “You said it!” ");
INSERT INTO engf35_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Now as they were eating, after taking the bread and blessing it, Jesus broke it, gave it to the disciples and said, “Take, eat; this is my body.” ");
INSERT INTO engf35_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","And taking the cup and giving thanks He gave it to them saying: “Drink of it, all of you; ");
INSERT INTO engf35_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","for this is my blood, that of the new covenant, that which is being shed on behalf of many for forgiveness of sins. ");
INSERT INTO engf35_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Furthermore, I tell you that I will not drink of this fruit of the vine from now on until that day when I drink it new with you in my Father's kingdom.” ");
INSERT INTO engf35_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","And after hymn-singing they went out to the Mount of Olives. ");
INSERT INTO engf35_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Then Jesus says to them: “All of you will be caused to stumble because of me this night, for it is written: ‘I will strike the Shepherd and the sheep of the flock will be scattered.’ ");
INSERT INTO engf35_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","But after I am raised I will go before you to Galilee.” ");
INSERT INTO engf35_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter answered and said to Him, “Even if everyone else is caused to stumble because of you, I will never be caused to stumble.” ");
INSERT INTO engf35_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus said to him, “Assuredly I say to you that this night, before any rooster crows, you will deny me three times.” ");
INSERT INTO engf35_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter says to Him, “Even if I have to die with you, I will not deny you!” And all the other disciples said the same. ");
INSERT INTO engf35_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Then Jesus comes with them to a place called Gethsemane, and He says to the disciples, “Sit here while I go over there and pray.” ");
INSERT INTO engf35_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","And taking Peter and the two sons of Zebedee along He began to be troubled and distressed. ");
INSERT INTO engf35_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Then Jesus says to them: “My soul is in anguish, to the point of death. Stay here and watch with me.” ");
INSERT INTO engf35_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","And going a little farther He fell on His face and prayed saying, “My Father, if it is possible, let this cup pass me by; nevertheless not as I wish, but as you do.” ");
INSERT INTO engf35_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Then He comes to the disciples and finds them sleeping, and He says to Peter: “So, you (pl.) were not able to watch with me one hour! ");
INSERT INTO engf35_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Watch and pray, so that you do not enter into temptation. The spirit on its part is willing, but the flesh is weak.” ");
INSERT INTO engf35_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","And going away a second time He prayed saying, “My Father, if this cup cannot pass from me unless I drink it, let your will be done.” ");
INSERT INTO engf35_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","And coming He finds them sleeping again, because their eyes had been weighed down. ");
INSERT INTO engf35_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","So leaving them He went away and prayed a third time, saying the same thing. ");
INSERT INTO engf35_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Then He comes to His disciples and says to them: “Sleep some more and take your rest! Actually, the hour is here and the Son of the Man is being betrayed into sinners' hands. ");
INSERT INTO engf35_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Get up, let's go; see, the one who is betraying me has come!” ");
INSERT INTO engf35_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","And while He was still speaking, there was Judas, one of the twelve, and with him a large crowd with swords and clubs, sent from the chief priests and elders of the people. ");
INSERT INTO engf35_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","(Now His betrayer had given them a sign saying, “Whomever I kiss, it is He; take Him!”) ");
INSERT INTO engf35_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","And he went right up to Jesus and said, “Greetings, Rabbi!” and kissed Him. ");
INSERT INTO engf35_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","So Jesus said to him, “Friend, what brings you here?” Then approaching they laid hands on Jesus and took Him. ");
INSERT INTO engf35_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","And then, one of those with Jesus stretched out his hand and drew his sword, and striking the servant of the high priest he cut off his ear! ");
INSERT INTO engf35_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","But Jesus says to him: “Put your sword back into its place, for all who take the sword will die by the sword. ");
INSERT INTO engf35_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Do you actually suppose that I cannot call upon my Father right now and He will place beside me more than twelve legions of angels? ");
INSERT INTO engf35_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","But how then would the Scriptures be fulfilled that it has to happen this way?” ");
INSERT INTO engf35_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","At that time Jesus said to the crowd: “Have you come out with swords and clubs, as against a bandit, to arrest me? I used to sit daily with you in the temple, teaching, and you did not seize me. ");
INSERT INTO engf35_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","But all this has happened so that the Scriptures of the prophets should be fulfilled.” Then all the disciples forsook Him and ran away. ");
INSERT INTO engf35_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","So those who had seized Jesus led Him away to Caiaphas the high priest, where the scribes and the elders were assembled. ");
INSERT INTO engf35_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Now Peter was following Him at a distance, up to the high priest's courtyard. And going inside he sat down with the attendants, to see the end. ");
INSERT INTO engf35_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","The chief priests and the elders, in fact the whole Council, kept looking for false witnesses against Jesus so that they could put Him to death, ");
INSERT INTO engf35_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","but did not find any. Even though many false witnesses came forward, they did not find any. But at last two false witnesses came forward ");
INSERT INTO engf35_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","and said, “This fellow said, ‘I am able to destroy the temple of God and to rebuild it in three days.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","And standing up the high priest said to Him: “Do you answer nothing? What is it that these men are testifying against you?” ");
INSERT INTO engf35_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","But Jesus kept silent. So reacting the high priest said to Him, “I put you under oath by the Living God so that you tell us if you are the Messiah, the Son of God!” ");
INSERT INTO engf35_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus says to him: “You said it. Furthermore, I tell you, hereafter you will see the Son of the Man sitting at the Power's right, and coming on the clouds of heaven.” ");
INSERT INTO engf35_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Then the high priest tore his clothes saying: “He has blasphemed! Why do we still need witnesses? See, now you have heard His blasphemy! ");
INSERT INTO engf35_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","What do you think?” So in answer they said, “He deserves death!” ");
INSERT INTO engf35_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Then they spat in His face and punched Him, while others slapped Him ");
INSERT INTO engf35_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","saying, “Messiah, prophesy to us! Who is the one who hit you?” ");
INSERT INTO engf35_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Now Peter sat outside in the courtyard. And a certain servant girl approached him saying, “You too were with Jesus the Galilean.” ");
INSERT INTO engf35_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","But he denied before them all saying, “I don't know what you are saying.” ");
INSERT INTO engf35_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","And having gone out to the gateway, another girl saw him and says to those who were there, “This fellow also was with Jesus the Natsorean.” ");
INSERT INTO engf35_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","And he denied again, with an oath, “I do not know the man!” ");
INSERT INTO engf35_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","But a little later the bystanders came up and said to Peter, “Really, you too are one of them, because your very accent gives you away!” ");
INSERT INTO engf35_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Then he began to curse and to swear, “I do not know the man!!” And immediately a rooster crowed. ");
INSERT INTO engf35_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","And Peter remembered the word that Jesus had said to him, “Before any rooster crows, you will deny me three times.” And going out he cried bitterly. ");
INSERT INTO engf35_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","When early morning came, all the chief priests and elders plotted against Jesus to kill Him. ");
INSERT INTO engf35_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","And having bound Him they went and handed Him over to Pontius Pilate, the governor. ");
INSERT INTO engf35_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","(Then Judas, His betrayer, seeing that He had been condemned, felt regret and returned the thirty silver coins to the chief priests and elders ");
INSERT INTO engf35_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","saying, “I sinned, by betraying innocent blood.” But they said: “What do we care? It's your problem!” ");
INSERT INTO engf35_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","So throwing the silver down in the sanctuary he left, and went and hanged himself! ");
INSERT INTO engf35_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Then the chief priests took the coins and said, “It isn't lawful to put them into the treasury, being blood money.” ");
INSERT INTO engf35_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","So after consultation they bought the potter's field with them, as a burial ground for strangers. ");
INSERT INTO engf35_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Therefore that field has been called ‘field of blood’ to this day. ");
INSERT INTO engf35_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Then was fulfilled what was spoken through Jeremiah the prophet, namely: “And they took the thirty silver coins, the value of the one who was priced, whom some of the children of Israel priced, ");
INSERT INTO engf35_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","and they gave them for the potter's field, just as the Lord directed me.”) ");
INSERT INTO engf35_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","So Jesus stood before the governor. And the governor asked Him saying, “Are you the king of the Jews?” Jesus said to him, “As you say.” ");
INSERT INTO engf35_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","But although the chief priests and elders kept accusing Him, He answered nothing. ");
INSERT INTO engf35_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Then Pilate says to Him, “Don't you hear all that they are saying against you?” ");
INSERT INTO engf35_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","But He did not answer him, not even one word, so that the governor was really amazed. ");
INSERT INTO engf35_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Now at the feast the governor was accustomed to release one prisoner to the crowd, whomever they wanted. ");
INSERT INTO engf35_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Just then they had a notorious prisoner called Barabbas. ");
INSERT INTO engf35_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","So while they were assembled Pilate said to them, “Whom do you want me to release to you, Barabbas or Jesus who is called Messiah?” ");
INSERT INTO engf35_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","For he knew that they had handed Him over through envy. ");
INSERT INTO engf35_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Now as he was sitting on the judgment seat, his wife sent to him saying, “Have nothing to do with that righteous man, because I suffered a great deal in a dream today because of Him.” ");
INSERT INTO engf35_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","But the chief priests and elders had persuaded the crowds that they should ask for Barabbas, but destroy Jesus. ");
INSERT INTO engf35_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","So the governor spoke up and said to them, “Which of the two do you want me to release to you?” And they said, “Barabbas!” ");
INSERT INTO engf35_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate says to them, “What then shall I do with Jesus who is called Messiah?” They all say to him, “Let Him be crucified!” ");
INSERT INTO engf35_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","So the governor said, “But, what evil did He do?” But they kept yelling all the more saying, “Let Him be crucified!!” ");
INSERT INTO engf35_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","When Pilate saw that nothing was being gained but rather a riot was starting, he took water and washed his hands in front of the crowd saying: “I am innocent of the blood of this righteous man. It's your problem!” ");
INSERT INTO engf35_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","So in answer all the people said, “His blood be upon us and upon our children!” ");
INSERT INTO engf35_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Then he released Barabbas to them, but Jesus, after flogging Him, he delivered to be crucified. ");
INSERT INTO engf35_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Then the governor's soldiers took Jesus into the Praetorium and gathered the whole garrison around Him. ");
INSERT INTO engf35_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","They stripped Him and put a scarlet cloak on Him. ");
INSERT INTO engf35_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","They plaited a crown out of thorns and put it on His head, and a reed in His right hand; and kneeling before Him they would mock Him saying, “Hail, King of the Jews!” ");
INSERT INTO engf35_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Spitting on Him they took the reed and hit Him repeatedly on the head. ");
INSERT INTO engf35_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","After they had mocked Him they took the cloak off Him and put His own clothes back on; and they led Him away to be crucified. ");
INSERT INTO engf35_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Now as they went out they found a man of Cyrene, named Simon; they compelled him to carry His cross. ");
INSERT INTO engf35_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Upon arriving at a place called Golgotha, which means ‘place of a skull’, ");
INSERT INTO engf35_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","they gave Him sour wine mixed with gall to drink; but having tasted it He would not drink. ");
INSERT INTO engf35_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Having crucified Him they divided up His clothes by casting lots. ");
INSERT INTO engf35_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","And sitting down there they guarded Him. ");
INSERT INTO engf35_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","And they put the charge against Him over His head in writing: THIS IS JESUS THE KING OF THE JEWS. ");
INSERT INTO engf35_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Then they crucified two bandits with Him, one on His right and one on His left. ");
INSERT INTO engf35_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","And the passers-by kept blaspheming Him, wagging their heads ");
INSERT INTO engf35_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","and saying: “You who destroy the temple and rebuild it in three days, save yourself!” “If you are ‘Son of God’, come down from the cross!” ");
INSERT INTO engf35_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Likewise the chief priests also, mocking with the scribes and elders and Pharisees, said: ");
INSERT INTO engf35_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“He saved others; himself he cannot save!” “If he is ‘King of Israel’ let him come down from the cross now and we will believe him!” ");
INSERT INTO engf35_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“He trusted in God; let Him rescue him now, if He wants him; for he said, ‘I am God's Son.’ ” ");
INSERT INTO engf35_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Even the bandits who were crucified with Him were reviling Him in the same way. ");
INSERT INTO engf35_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Now from the sixth hour until the ninth hour a darkness came over all the land. ");
INSERT INTO engf35_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","And about the ninth hour Jesus cried out with a loud voice saying, “Eli, Eli, lima sabachtani?” which means, “My God, my God, why have You abandoned me?” ");
INSERT INTO engf35_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","So upon hearing it some of the bystanders said, “This man is calling Elijah.” ");
INSERT INTO engf35_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Right then one of them ran and took a sponge, filled it with sour wine, put it on a reed and started to give Him a drink; ");
INSERT INTO engf35_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","but the rest said: “Don't! Let's see if Elijah comes to save Him.” ");
INSERT INTO engf35_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Then Jesus called out again with a great shout and dismissed His spirit. ");
INSERT INTO engf35_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","And then, the veil of the temple was ripped in two from top to bottom! And the earth was shaken, and the rocks were split, ");
INSERT INTO engf35_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","and the graves were opened. (And many bodies, of the saints who had fallen asleep, were raised; ");
INSERT INTO engf35_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","and coming forth out of the graves after His resurrection, they entered the holy city and were made visible to many.) ");
INSERT INTO engf35_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Now when the centurion and those with him guarding Jesus saw the earthquake and all that happened they were scared stiff and said, “This Man really was the Son of God!” ");
INSERT INTO engf35_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Many women who followed Jesus from Galilee, ministering to Him, were also there looking on from a distance; ");
INSERT INTO engf35_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","among whom were Mary Magdalene, Mary the mother of James and Joses, and the mother of the sons of Zebedee. ");
INSERT INTO engf35_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Now at evening there appeared a rich man from Arimathea, named Joseph, who himself had also become a disciple of Jesus. ");
INSERT INTO engf35_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","This man went to Pilate and asked for the body of Jesus. Then Pilate ordered that the body be given. ");
INSERT INTO engf35_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","So taking the body Joseph wrapped it in clean linen cloth ");
INSERT INTO engf35_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","and placed it in his own new tomb that he had cut out of the rock. Then he rolled a large stone against the door of the tomb and left. ");
INSERT INTO engf35_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","And Mary Magdalene was there, and the other Mary, sitting opposite the grave. ");
INSERT INTO engf35_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","The next day, which is after the Preparation, the chief priests and the Pharisees went together to Pilate ");
INSERT INTO engf35_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","saying: “Sir, we remember that that deceiver, while still alive, said, ‘After three days I am going to rise.’ ");
INSERT INTO engf35_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Therefore command that the grave be made secure until the third day, lest His disciples come by night and steal Him and say to the people, ‘He was raised from the dead,’ and the last deception will be worse than the first.” ");
INSERT INTO engf35_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","So Pilate said to them, “You have a guard; go make it as secure as you can!” ");
INSERT INTO engf35_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So they went and secured the grave with the guard, having sealed the stone. ");
INSERT INTO engf35_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Now after the Sabbath, at the dawning of the first day of the week, Mary Magdalene, and the other Mary, came to see the tomb. ");
INSERT INTO engf35_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Now then, a big earthquake had occurred, because an angel of the Lord, descending out of heaven, had come and rolled back the stone from the door, and sat on it! ");
INSERT INTO engf35_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","And his appearance was like lightning and his clothing as white as snow. ");
INSERT INTO engf35_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","So the guards were shaken for fear of him, and became like dead men. ");
INSERT INTO engf35_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Now the angel spoke up and said to the women: “Do not be afraid! I know that you are looking for the Jesus who was crucified. ");
INSERT INTO engf35_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","He is not here, because He is risen, just like He said! Come, see the place where the Lord was lying. ");
INSERT INTO engf35_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Now go quickly and tell His disciples that He is risen from the dead; and get this, He is going before you into Galilee; there you will see Him. There, I have told you!” ");
INSERT INTO engf35_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","So they went out quickly from the tomb with fear and great joy, and ran to report to His disciples. ");
INSERT INTO engf35_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","But as they were going to report to His disciples, wow, Jesus met them saying, “Rejoice!” So approaching, they held His feet and worshiped Him. ");
INSERT INTO engf35_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Then Jesus says to them: “Do not be afraid! Go report to my brothers that they must go to Galilee, and there they will see me.” ");
INSERT INTO engf35_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Now while they were going, get this, some of the guard went into the city and reported to the chief priests all that had happened. ");
INSERT INTO engf35_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","When they had met with the elders and consulted together, they gave plenty of money to the soldiers ");
INSERT INTO engf35_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","saying: “Say that his disciples came at night and stole him while you were sleeping. ");
INSERT INTO engf35_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","And should this get to the governor, we will persuade him and make you safe.” ");
INSERT INTO engf35_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","So taking the money they did as they were instructed. Their tale is widely spread among the Jews until this day. ");
INSERT INTO engf35_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","The eleven disciples went into Galilee to the mountain that Jesus had indicated to them. ");
INSERT INTO engf35_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","When they saw Him they worshiped Him; but some doubted. ");
INSERT INTO engf35_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","And approaching Jesus asserted to them saying: “All authority in heaven and on earth has been given to me. ");
INSERT INTO engf35_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","As you go, make disciples in all ethnic nations: baptizing them in the name of the Father, and of the Son, and of the Holy Spirit; ");
INSERT INTO engf35_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","teaching them to obey everything that I commanded you; and take note, I am with you every day, until the end of the age!” Amen. ");
INSERT INTO engf35_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","A beginning of the Gospel of Jesus Christ, Son of God! ");
INSERT INTO engf35_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","As it is written in the prophets —“Take note, I am sending my messenger ahead of you, who will prepare your way before you.” ");
INSERT INTO engf35_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“A voice calling out: ‘In the wilderness prepare the way of the Lord, make His paths straight!’ ”— ");
INSERT INTO engf35_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John started baptizing in the wilderness and proclaiming a baptism of repentance for forgiveness of sins. ");
INSERT INTO engf35_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Well, the whole Judean countryside and the Jerusalemites started going out to him, and were all being baptized by him in the Jordan River, confessing their sins. ");
INSERT INTO engf35_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Now John was clothed with camel's hair and with a leather belt around his waist; and he was eating locusts and wild honey. ");
INSERT INTO engf35_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","And he was proclaiming: “After me my Superior is coming, whose sandal strap I am not worthy to stoop down and loosen. ");
INSERT INTO engf35_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I indeed baptized you with water, but He will baptize you with Holy Spirit.” ");
INSERT INTO engf35_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Well it happened in those days that Jesus came from Natsareth of Galilee and was baptized by John in the Jordan. ");
INSERT INTO engf35_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","And immediately upon coming up from the water He saw the heavens being torn open and the Spirit, like a dove, descending upon Him. ");
INSERT INTO engf35_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","And a Voice came from the heavens: “You are my Son, the beloved, in whom I am well pleased!” ");
INSERT INTO engf35_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Immediately the Spirit impelled Him into the wilderness. ");
INSERT INTO engf35_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","And He was there in the wilderness forty days being tested by Satan, and was with the wild animals; and the angels were ministering to Him. ");
INSERT INTO engf35_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Now after John was put in prison, Jesus went into Galilee proclaiming the Gospel of the Kingdom of God, ");
INSERT INTO engf35_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","and saying: “The time has been fulfilled and the Kingdom of God has approached. Repent and believe in the Gospel.” ");
INSERT INTO engf35_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Then, as He was walking beside the Sea of Galilee, He saw Simon and Andrew his brother, of Simon, casting a circular net onto the water, for they were fishermen. ");
INSERT INTO engf35_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","So Jesus said to them: “Come, follow me and I will turn you into fishers of men.” ");
INSERT INTO engf35_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","At once they left their nets and followed Him. ");
INSERT INTO engf35_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","And going on from there a little ways He saw James, son of Zebedee, and his brother John; they were in their boat mending their nets. ");
INSERT INTO engf35_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Right away He called them, and leaving their father Zebedee in the boat with the hired men they followed Him. ");
INSERT INTO engf35_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Then they went into Capernaum. The very next Sabbath He entered the synagogue and began to teach. ");
INSERT INTO engf35_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","And they kept on being amazed at His teaching, because He was teaching them as one having authority, and not like the scribes. ");
INSERT INTO engf35_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Now there was a man in their synagogue with an unclean spirit; and he cried out, ");
INSERT INTO engf35_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","saying: “Hey, what do you want with us, Jesus Natsarene?! Have you come to destroy us? I know who you are—the Holy One of God!” ");
INSERT INTO engf35_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","So Jesus rebuked him saying: “Shut up and get out of him!” ");
INSERT INTO engf35_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","The unclean spirit, convulsing him and crying with a loud voice, came out of him. ");
INSERT INTO engf35_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","And all were astounded, so that they questioned among themselves, saying: “What is this? What can this new doctrine be? Because with authority he commands even the unclean spirits, and they obey him!” ");
INSERT INTO engf35_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","So His fame spread directly into the whole surrounding area of Galilee. ");
INSERT INTO engf35_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Immediately upon exiting the synagogue they went into the house of Simon and Andrew, with James and John. ");
INSERT INTO engf35_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon's mother-in-law was lying down with a fever, so without delay they told Him about her. ");
INSERT INTO engf35_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","So He went and grasping her hand lifted her up; immediately the fever left her and she began to serve them. ");
INSERT INTO engf35_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","That evening, when the sun had set, they started bringing to Him all who were sick and the demonized. ");
INSERT INTO engf35_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","So much so that the whole town was gathered at the door, ");
INSERT INTO engf35_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","and He healed many who were sick with various diseases and cast out many demons; and He did not allow the demons to speak, because they knew He was Messiah. ");
INSERT INTO engf35_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Now very early, still night, He got up, slipped out, and went off to a solitary place, where He was praying. ");
INSERT INTO engf35_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon and those with him hunted for Him, ");
INSERT INTO engf35_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","and upon finding Him they said to Him, “Everyone is looking for you.” ");
INSERT INTO engf35_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","But He said to them: “Let us go to the neighboring towns, so I can preach there also; that is why I have come.” ");
INSERT INTO engf35_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","He was constantly preaching in their synagogues throughout all Galilee, and also casting out demons. ");
INSERT INTO engf35_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A leper came to Him, imploring Him, kneeling before Him and saying to Him, “If you want to, you are able to cleanse me.” ");
INSERT INTO engf35_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","So being moved with compassion, Jesus stretched out His hand and touched him, and said to him: “I want to; be cleansed!” ");
INSERT INTO engf35_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","And when He said this, immediately the leprosy left him, and he was cleansed. ");
INSERT INTO engf35_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","And He sent him away at once, sternly warning him, ");
INSERT INTO engf35_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","by saying: “See that you say nothing to anyone; but go, show yourself to the priest and offer for your cleansing the things that Moses commanded, as a testimony to them.” ");
INSERT INTO engf35_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","However he went out and began to proclaim it freely, spreading the news, so that He was no longer able to enter a town openly, but remained outside in deserted places; yet they kept coming to Him from all over. ");
INSERT INTO engf35_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Well a few days later, He again entered Capernaum, and it was heard that He was at home. ");
INSERT INTO engf35_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Without delay so many were gathered together that there was no more room, not even around the door, and He was speaking the Word to them. ");
INSERT INTO engf35_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Then four men came, carrying a paralytic to Him. ");
INSERT INTO engf35_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","And not being able to get near Him because of the crowd, they removed the roof where He was; upon breaking through they lowered the pallet on which the paralytic was lying. ");
INSERT INTO engf35_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","So seeing their faith Jesus says to the paralytic, “Son, your sins are forgiven you.” ");
INSERT INTO engf35_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Now some of the scribes were sitting there, and reasoning in their hearts: ");
INSERT INTO engf35_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Why does this guy speak blasphemies like that? Who can forgive sins but God alone?” ");
INSERT INTO engf35_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Immediately Jesus perceived in His spirit what they were reasoning within themselves and said to them: “Why are you reasoning these things in your hearts? ");
INSERT INTO engf35_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Which is easier: to say to the paralytic, ‘Your sins have been forgiven’, or to say, ‘Get up, pick up your pallet and start walking!’? ");
INSERT INTO engf35_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","But so that you may know that the Son of the Man has authority on the earth to forgive sins”—He says to the paralytic: ");
INSERT INTO engf35_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“To you I say, get up, pick up your pallet and go to your house!” ");
INSERT INTO engf35_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","So forthwith he got up, picked up his pallet and went out in front of them all; so that all were amazed and glorified God, saying, “We never saw anything like this!” ");
INSERT INTO engf35_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Then He went out again by the sea; and the whole crowd came to Him, and He began to teach them. ");
INSERT INTO engf35_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","As He passed by, He saw Levi the son of Alphaeus sitting at the tax office, and He said to him, “Follow me!” So he got up and followed Him. ");
INSERT INTO engf35_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Now it happened, as He was reclining at the table in his house, that many tax collectors and sinners joined Jesus and His disciples at the table; for there were many and they followed Him. ");
INSERT INTO engf35_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","The scribes and the Pharisees, seeing Him eating with the tax collectors and sinners, said to His disciples, “Why is it that He is eating and drinking with the tax collectors and sinners?” ");
INSERT INTO engf35_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Upon hearing it Jesus said to them: “It is not the healthy who have need of a doctor, but those who are sick. I did not come to call the righteous, but sinners to repentance.” ");
INSERT INTO engf35_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Now John's disciples and those of the Pharisees were fasting; and they came and said to Him, “Why do John's disciples and those of the Pharisees fast, but your disciples do not?” ");
INSERT INTO engf35_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","So Jesus said to them: “Can the groomsmen fast while the bridegroom is with them? As long as they have the bridegroom to themselves they cannot fast. ");
INSERT INTO engf35_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","But the time will come when the bridegroom will be taken away from them, and then they will fast, in those days. ");
INSERT INTO engf35_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Further, no one sews a patch of unshrunk cloth on an old garment, or else the new tears away some of the old, and a worse hole results. ");
INSERT INTO engf35_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","And no one puts new wine into old wineskins, or else the new wine bursts the wineskins, the wine spills out and the skins will be ruined; rather, new wine must be put into new wineskins.” ");
INSERT INTO engf35_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Now it happened, on a Sabbath, that He was passing through some grain fields, and His disciples began to make a path, picking the heads of grain. ");
INSERT INTO engf35_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","So the Pharisees said to Him, “Just look, why are they doing on a Sabbath that which is not permitted?” ");
INSERT INTO engf35_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","And He said to them: “Did you never read what David did when he was in need and hungry, he and those with him? ");
INSERT INTO engf35_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","How he entered the house of God (making Abiathar high priest) and ate the consecrated bread, which only priests are permitted to eat, and shared it with those who were with him?” ");
INSERT INTO engf35_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Then He said to them: “The Sabbath was made for man, not man for the Sabbath. ");
INSERT INTO engf35_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Therefore the Son of the Man is Lord even of the Sabbath.” ");
INSERT INTO engf35_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Another time He went into the synagogue, and there was a man there with a withered hand. ");
INSERT INTO engf35_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","So they watched Him closely, whether He would heal him on the Sabbath, so that they might accuse Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Well, He says to the man with the withered hand, “Come out in the middle!” ");
INSERT INTO engf35_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Then He said to them: “Is it lawful on the Sabbath to do good or to do evil, to save life or to kill?” But they remained silent. ");
INSERT INTO engf35_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","After looking around at them with anger, being grieved at the hardness of their hearts, He says to the man, “Stretch out your hand!” So he stretched, and his hand was restored as healthy as the other! ");
INSERT INTO engf35_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Then the Pharisees went straight out, and with the Herodians started hatching a plot against Him, how they might destroy Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus withdrew with His disciples to the sea; and a large crowd from Galilee followed Him—also from Judea, ");
INSERT INTO engf35_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","from Jerusalem, from Idumea and beyond Jordan; even those around Tyre and Sidon. A huge crowd came to Him, having heard the sorts of things He kept doing. ");
INSERT INTO engf35_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","So He told His disciples that a small boat should be kept ready for Him because of the crowd, lest they should press in on Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Because He had healed many, so that as many as had afflictions were pushing toward Him so as to touch Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","And the unclean spirits—whenever one saw Him, he would fall down before Him and cry out, saying, “You are the son of God!” ");
INSERT INTO engf35_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","And He kept giving them strict orders that they should not make Him known. ");
INSERT INTO engf35_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","He went up on the mountain and summoned those whom He wanted, and they came to Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","He appointed twelve, that they might be with Him and that He might send them out to preach ");
INSERT INTO engf35_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","—also to have authority to heal sicknesses and to cast out demons: ");
INSERT INTO engf35_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","namely Peter (a name He gave to Simon); ");
INSERT INTO engf35_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James son of Zebedee, and John the brother of James (and a name He gave to them was Boanerges, that is, ‘Sons of thunder’); ");
INSERT INTO engf35_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Phillip, Bartholomew, Matthew, Thomas, James son of Alphaeus, Thaddaeus, Simon the Cananite; ");
INSERT INTO engf35_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","and Judas Iscariot, who also betrayed Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Then they went into a house; and again a multitude gathered, so that they were not even able to eat bread. ");
INSERT INTO engf35_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Well upon hearing this His family came to apprehend Him, because they were saying, “He is out of his mind!” ");
INSERT INTO engf35_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Then some scribes who had come down from Jerusalem started saying, “He has Beelzebul,” and “It is by the ruler of the demons that he casts out demons.” ");
INSERT INTO engf35_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","So summoning them He started saying to them in parables: “How can Satan cast out Satan? ");
INSERT INTO engf35_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","If a kingdom is divided against itself, that kingdom cannot stand. ");
INSERT INTO engf35_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","And if a household is divided against itself, that household cannot stand. ");
INSERT INTO engf35_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","And if Satan has risen up against himself and become divided, he cannot stand, but is finished. ");
INSERT INTO engf35_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","No one can plunder the strong man's goods, invading his house, unless he first binds the strong man—then he may plunder the house. ");
INSERT INTO engf35_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Assuredly I say to you: all the sins of the sons of men can be forgiven, including whatever blasphemies they may utter; ");
INSERT INTO engf35_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","but whoever blasphemes against the Holy Spirit never has forgiveness, but is subject to eternal condemnation” ");
INSERT INTO engf35_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","—because they were saying, “He has an unclean spirit.” ");
INSERT INTO engf35_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Then His brothers and His mother came, and standing outside they sent to Him, calling Him. ");
INSERT INTO engf35_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A crowd was sitting around Him; so they said to Him, “Look, your mother and your brothers and your sisters are outside asking for you.” ");
INSERT INTO engf35_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","He answered them saying, “Who is my mother or my brothers?” ");
INSERT INTO engf35_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","And looking around at those seated in a circle around Him He said: “Behold my mother and my brothers! ");
INSERT INTO engf35_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Because whoever does the will of God, the same is my brother, my sister, my mother.” ");
INSERT INTO engf35_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Once again He began to teach beside the sea. And a large crowd was gathered to Him, so that He got into the boat and sat down, out on the water, while the whole crowd was on the land, at the water's edge. ");
INSERT INTO engf35_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Then He began teaching them many things by parables and said to them in His teaching: ");
INSERT INTO engf35_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Listen! Yes, a sower went out to sow. ");
INSERT INTO engf35_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","And it happened, as he sowed, that some seed fell along the path, and the birds came and devoured it. ");
INSERT INTO engf35_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Some fell on the rocky area where it did not have much soil, and it sprang up quickly because it had no depth of soil. ");
INSERT INTO engf35_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","But upon the sun's rising it was scorched, and because it had no root it was withered up. ");
INSERT INTO engf35_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","And some fell among the thorns, and the thorns grew up and smothered it, and it yielded no fruit. ");
INSERT INTO engf35_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","And some fell into the good ground, and coming up and growing it started to produce fruit—yielding thirty times as much, sixty times as much, even a hundred times as much.” ");
INSERT INTO engf35_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Then He said, “He who has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","But when He was alone, those who were around Him, with the twelve, asked Him about the parable. ");
INSERT INTO engf35_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","So He said to them: “To you it has been given to know the mystery of the Kingdom of God; but to those who are outside, everything is being given in parables, ");
INSERT INTO engf35_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","so that: ‘Seeing they may see, and not perceive; and hearing they may hear, and not understand; so that they should not return and their sins be forgiven them.’ ” ");
INSERT INTO engf35_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Then He said to them: “Don't you understand this parable? How then will you understand all the parables? ");
INSERT INTO engf35_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","The sower sows the Word. ");
INSERT INTO engf35_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","These are the ones where the Word is sown along the path: as soon as they hear it, Satan comes and takes away the Word that was sown in their hearts. ");
INSERT INTO engf35_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Similarly, these are the ones sown on the rocky area: as soon as they hear the Word they receive it with joy, ");
INSERT INTO engf35_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","but since they have no root in themselves they are temporary—when oppression or persecution comes because of the Word, they quickly fall away. ");
INSERT INTO engf35_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","And these are the ones sown among the thorns: they hear the Word, ");
INSERT INTO engf35_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","but the worries of this age, the deceitfulness of wealth, and the undue desires for other things come in and smother the Word, and it becomes unfruitful. ");
INSERT INTO engf35_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","And these are the ones sown on the good ground: such people hear the Word, welcome it and produce fruit—thirty times as much, sixty times as much, even a hundred times as much.” ");
INSERT INTO engf35_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Also He said to them: “The lamp is not brought to be put under a box or under a bed, is it? Is it not to be placed on its stand? ");
INSERT INTO engf35_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","For there is no ‘hidden’ that may not be exposed, nor has anything been concealed but that it should come to light. ");
INSERT INTO engf35_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","If anyone has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Then He said to them: “Pay attention to what you hear. With the same measure you use it will be measured to you in return; and to you who hear, more will be added. ");
INSERT INTO engf35_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Because whoever has, to him more will be given; whoever does not have, even what he has will be taken away from him.” ");
INSERT INTO engf35_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","He also said: “The Kingdom of God is as if a man should scatter the seed on the ground ");
INSERT INTO engf35_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","and should sleep and get up night and day, and the seed should sprout and grow, he himself does not know how. ");
INSERT INTO engf35_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","All by itself the earth produces fruit: first a shoot, then a head of grain, then full grain in the head. ");
INSERT INTO engf35_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","But as soon as the grain is ready, he sends in the sickle, because the harvest has come.” ");
INSERT INTO engf35_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Again He said: “To what shall we compare the Kingdom of God, or with what sort of parable should we illustrate it? ");
INSERT INTO engf35_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","It is like a mustard seed, that when it is sown on the ground is the smallest of all such seeds, ");
INSERT INTO engf35_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","yet when it is sown, it grows up and becomes larger than all the garden herbs and produces big branches, so that the birds of the air are able to rest in its shade.” ");
INSERT INTO engf35_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","It was with many such parables that He was speaking the word to them, as they were able to hear it. ");
INSERT INTO engf35_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","But apart from a parable He did not speak to them; privately, however, He would explain everything to His disciples. ");
INSERT INTO engf35_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","On the same day, when evening had come, He said to them, “Let us go across to the other side.” ");
INSERT INTO engf35_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Since He was already in the boat, they took off with Him, leaving the crowd behind (other little boats were also with Him). ");
INSERT INTO engf35_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Well a strong cyclonic wind came up, such that the waves beat into the boat, so that it was already filling up. ");
INSERT INTO engf35_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","But He was on the poop deck, sleeping on the cushion; so they awakened Him and said to Him, “Teacher, don't you care that we are perishing?” ");
INSERT INTO engf35_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Then, having been awakened, He rebuked the wind and said to the sea, “Shut up; be muzzled!” So the wind stopped and there was a complete calm. ");
INSERT INTO engf35_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","And He said to them: “Why are you so afraid? How is it that you have no faith?” ");
INSERT INTO engf35_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","They were terrified and started saying to one another, “Who can this be, that even the wind and the sea obey Him!?” ");
INSERT INTO engf35_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Then they came to the other side of the sea, to the region of the Gadarenes. ");
INSERT INTO engf35_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","And when He got out of the boat, right away a man with an unclean spirit met Him, coming from the tombs. ");
INSERT INTO engf35_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","—He had his dwelling among the tombs. No one could bind him, not even with chains, ");
INSERT INTO engf35_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","because he had often been bound with shackles and chains, only to have had the chains torn apart by him, and the shackles broken in pieces; no one had been strong enough to tame him. ");
INSERT INTO engf35_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Always, night and day, in the tombs and in the mountains, he was crying out and cutting himself with stones.— ");
INSERT INTO engf35_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","When he saw Jesus from a distance, he ran and kneeled down to Him, ");
INSERT INTO engf35_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","and with a loud cry he said: “What do you want with me, Jesus, Son of the Most High God? I implore you by God, don't torment me!” ");
INSERT INTO engf35_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Because He was saying to him, “You unclean spirit, come out of the man!” ");
INSERT INTO engf35_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Then He asked him, “What is your name?” And he answered, saying, “Legion is my name, because we are many.” ");
INSERT INTO engf35_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","He started begging Him repeatedly that He would not send them out of that region. ");
INSERT INTO engf35_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Now a large herd of pigs was feeding there on the hillside. ");
INSERT INTO engf35_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","So all the demons begged Him saying, “Send us into the pigs, so that we may enter them.” ");
INSERT INTO engf35_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","And forthwith Jesus gave them permission; and coming out the unclean spirits went into the pigs (there were about two thousand); but the herd rushed down the steep bank into the sea, and they were drowned by the sea. ");
INSERT INTO engf35_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","So those who were tending the pigs ran off and reported it in the town and the countryside. And they went out to see what it was that had happened. ");
INSERT INTO engf35_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","They came to Jesus and observed the man who had been demonized, who had the legion, sitting and clothed and in his right mind; and they were afraid. ");
INSERT INTO engf35_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Those who had seen it related to them how it happened to the demonized man, and about the pigs. ");
INSERT INTO engf35_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Then they began to implore Him to depart from their borders. ");
INSERT INTO engf35_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Well upon His getting into the boat, the man who had been demonized started begging Him that he might be with Him. ");
INSERT INTO engf35_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","But Jesus did not permit him, but said to him, “Go home to your family and report to them how much the Lord has done for you; and He had mercy on you.” ");
INSERT INTO engf35_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","So he departed and began to proclaim in Decapolis how much Jesus had done for him; and all were marveling. ");
INSERT INTO engf35_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Now when Jesus had crossed over again by boat to the other side, a large crowd gathered to Him; and He was by the sea. ");
INSERT INTO engf35_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","And then, one of the synagogue rulers, named Jairus, comes, and upon finding Him he falls at His feet ");
INSERT INTO engf35_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","and pleads earnestly with Him, saying, “My little daughter is at the point of death; do come and lay your hands on her so that she may be saved, and she will live.” ");
INSERT INTO engf35_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","So He went with him. A large crowd was also following Him, and they were pressing around Him. ");
INSERT INTO engf35_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Now a certain woman—who had been bleeding for twelve years, ");
INSERT INTO engf35_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","and had suffered many things under many doctors, and had spent all that she had, yet instead of getting better she grew worse— ");
INSERT INTO engf35_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","when she heard about Jesus, she came from behind in the crowd and touched His garment. ");
INSERT INTO engf35_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","(She had kept saying, “If I can just touch His clothes, I will be healed.”) ");
INSERT INTO engf35_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Immediately the flow of her blood was dried up, and she knew in her body that she was healed from the affliction. ");
INSERT INTO engf35_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","And instantly Jesus perceived within Himself that some power had gone out of Him, and turning around in the crowd He said, “Who touched my clothes?” ");
INSERT INTO engf35_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","So His disciples said to Him, “You see the crowd pressing around you, yet you say, ‘Who touched me?’?” ");
INSERT INTO engf35_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","But He kept looking around to see who had done it. ");
INSERT INTO engf35_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","So the woman, fearing and trembling, knowing what had happened to her, came and fell down before Him and told Him the whole truth. ");
INSERT INTO engf35_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","And He said to her: “Daughter, your faith has saved you. Go into peace and be healed from your affliction.” ");
INSERT INTO engf35_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","While He was still speaking, they came from the synagogue ruler's house saying: “Your daughter died. Why trouble the teacher further?” ");
INSERT INTO engf35_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","But immediately upon hearing the spoken message Jesus said to the synagogue ruler, “Don't be afraid; just believe!” ");
INSERT INTO engf35_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","He allowed no one to follow Him except Peter, James, and John, the brother of James. ");
INSERT INTO engf35_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Then He came to the synagogue ruler's house and found a commotion—weeping and loud wailing. ");
INSERT INTO engf35_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","So upon entering He said to them: “Why are you making such a commotion and weeping? The child is not dead, but is asleep.” ");
INSERT INTO engf35_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","But they started ridiculing Him. After He put them all out, He took the child's father and mother, and those with Him, and went in where the child was lying. ");
INSERT INTO engf35_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","And taking the child by the hand He said to her, “Talitha koumi,” which is translated, “Little girl, I say to you, get up!” ");
INSERT INTO engf35_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Immediately the girl got up and started walking around (she was twelve years old). And they were overcome with great amazement. ");
INSERT INTO engf35_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","He gave them strict orders that no one should know about it, and said to give her something to eat. ");
INSERT INTO engf35_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Then He went out from there and came to His hometown, and His disciples followed Him. ");
INSERT INTO engf35_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","And when the Sabbath came He began to teach in the synagogue. And many who heard were astonished, saying: “Where did this man get these things? What wisdom is this that is given to him? Such mighty works are being performed by his hands! ");
INSERT INTO engf35_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Isn't this the carpenter, the son of Mary, and brother of James, Joses, Judas and Simon? And aren't his sisters here with us?” So they took offense at Him. ");
INSERT INTO engf35_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","But Jesus said to them, “A prophet is not without honor, except in his hometown, among his relatives, even in his own house.” ");
INSERT INTO engf35_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","He could do no mighty work there, except that He laid His hands on a few sick people and healed them. ");
INSERT INTO engf35_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","And He marveled at their unbelief. Then He went about the villages in a circuit, teaching. ");
INSERT INTO engf35_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Then He summoned the twelve and began to send them out, two by two, giving them authority over the unclean spirits as He did so. ");
INSERT INTO engf35_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","And He commanded them to take nothing for the road, except just a staff—no knapsack, no bread, no coin in the belt— ");
INSERT INTO engf35_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","but to wear sandals, and not put on two tunics. ");
INSERT INTO engf35_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","And He said to them: “Whenever you enter a house, stay there until you depart from that place. ");
INSERT INTO engf35_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","And whoever will not receive you nor hear you, as you depart from there, shake off the dust that is under your feet as a testimony against them. Assuredly I say to you, it will be more tolerable for Sodom and Gomorrah on Judgment Day than for that city.” ");
INSERT INTO engf35_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","So they went out and started preaching that people should repent, ");
INSERT INTO engf35_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","and they were casting out many demons, and anointing with oil and healing many who were sick. ");
INSERT INTO engf35_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Now King Herod heard of Him, because His name had become well known, and he said, “John the Baptizer has been raised from the dead, and that is why the powers are at work in him.” ");
INSERT INTO engf35_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Others said, “He is Elijah.” Still others said, “He is a prophet like one of the prophets.” ");
INSERT INTO engf35_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","But when Herod heard, he said: “This is John, whom I beheaded; he has been raised from the dead!” ");
INSERT INTO engf35_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","You see, Herod himself had ordered John arrested, and bound him in prison, on account of Herodias, his brother Philip's wife; because he had married her ");
INSERT INTO engf35_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","—John had kept saying to Herod, “It isn't lawful for you to have your brother's wife.” ");
INSERT INTO engf35_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","So Herodias nursed a grudge against him and wanted to kill him; but she couldn't, ");
INSERT INTO engf35_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","because Herod feared John and protected him, knowing him to be a just and holy man. And consulting him he would do many things; indeed, he would hear him with pleasure. ");
INSERT INTO engf35_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Then an opportune day came when on his birthday Herod gave a banquet for his courtiers, the military commanders, and the chief men of Galilee. ");
INSERT INTO engf35_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","When the daughter of Herodias herself came in and danced, and pleased Herod and those reclining with him, the king said to the girl, “Ask me whatever you want, and I will give it to you.” ");
INSERT INTO engf35_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","He even swore to her, “Whatever you may ask me I will give you, up to half of my kingdom!” ");
INSERT INTO engf35_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","So she went out and said to her mother, “What shall I ask?” And she said, “The head of John the Baptist!” ");
INSERT INTO engf35_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Hurrying in directly to the king she requested, saying, “I want you to give me right now the head of John the Baptist on a platter!” ");
INSERT INTO engf35_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Though the king became very sorry, because of his oaths and of his guests he did not want to refuse her. ");
INSERT INTO engf35_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Immediately the king sent an executioner and commanded the head to be brought. So he went and beheaded him in the prison, ");
INSERT INTO engf35_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","brought the head on a platter, and gave it to the girl; and the girl gave it to her mother. ");
INSERT INTO engf35_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Upon hearing of it, his disciples came, removed the corpse and placed it in a tomb. ");
INSERT INTO engf35_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Then the apostles gathered to Jesus and reported all to Him, both what they had done and what they had taught. ");
INSERT INTO engf35_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Because so many were coming and going that they did not even have leisure to eat, He said to them, “Come aside by yourselves to a deserted place and rest awhile.” ");
INSERT INTO engf35_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","So they went away in the boat by themselves to a deserted place. ");
INSERT INTO engf35_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","But many saw them going and recognized them, and they ran there on foot from all the towns and arrived before them, and came together to Him. ");
INSERT INTO engf35_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Well upon disembarking Jesus saw a large crowd and was moved with compassion for them, because they were like sheep without a shepherd, and He began to teach them many things. ");
INSERT INTO engf35_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","When it was late in the day, His disciples came to Him and said: “This is a deserted place, and the hour is already late. ");
INSERT INTO engf35_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Send them away so they may go to the surrounding farms and villages and buy themselves bread; for they have nothing to eat.” ");
INSERT INTO engf35_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","But in reply He said to them, “You feed them!” They say to Him, “Shall we go and buy two hundred denarii worth of bread and feed them?” ");
INSERT INTO engf35_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","So He says to them: “How many loaves do you have? Go and see.” When they knew they said, “Five, and two fish.” ");
INSERT INTO engf35_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Then He directed them all to recline in groups on the green grass. ");
INSERT INTO engf35_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","So they reclined in ‘plots’ of hundreds and of fifties. ");
INSERT INTO engf35_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","And taking the five loaves and the two fish and looking up to heaven, He blessed and broke the loaves and gave them to His disciples to serve the people; He also divided the two fish among them all. ");
INSERT INTO engf35_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Well they all ate and were filled. ");
INSERT INTO engf35_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","And they picked up twelve full baskets of broken pieces; also of the fish. ");
INSERT INTO engf35_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","There were five thousand men who ate the loaves. ");
INSERT INTO engf35_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Immediately He made His disciples get into the boat and go on ahead to the other side, to Bethsaida, while He dismissed the crowd. ");
INSERT INTO engf35_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","And after taking leave of them He went up the mountain to pray. ");
INSERT INTO engf35_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Now when evening had passed, the boat was in the middle of the sea; and He was alone on the land. ");
INSERT INTO engf35_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","And He saw them straining at rowing, because the wind was against them. Well about the fourth watch of the night He comes to them walking on the water, and would have passed by them; ");
INSERT INTO engf35_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","but they saw Him walking on the water, supposed He was a ghost, and yelled! ");
INSERT INTO engf35_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Because they all saw Him and were terrified. Immediately He spoke with them and said: “Have courage! It is I; don't be afraid!” ");
INSERT INTO engf35_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Then He got into the boat with them, and the wind ceased. And they were totally astounded within themselves, and kept marveling. ");
INSERT INTO engf35_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Because they had not understood about the loaves—their hearts had been hardened. ");
INSERT INTO engf35_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","After they had crossed over, they came to the land of Genesaret and anchored there. ");
INSERT INTO engf35_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","When they came out of the boat, immediately the people recognized Him, ");
INSERT INTO engf35_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","and running about that whole surrounding region they began to carry about on their pallets those who were sick to wherever they heard He was. ");
INSERT INTO engf35_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wherever He entered—into villages, towns, or countryside—they would place the sick in the marketplaces, and they would beg Him that they might just touch the hem of His garment; and all who touched Him were healed. ");
INSERT INTO engf35_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Then the Pharisees and some of the scribes gathered around Him, having come from Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","And upon seeing some of His disciples eating bread with ‘unclean’—that is, ceremonially unwashed—hands, they found fault. ");
INSERT INTO engf35_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Because the Pharisees, indeed all the Jews, do not eat unless they wash their hands in a special way, holding to the tradition of the elders. ");
INSERT INTO engf35_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","When they come from the marketplace, they do not eat unless they wash. And there are many other things they have received and hold—washings of cups, pitchers, copper vessels and couches.) ");
INSERT INTO engf35_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Then the Pharisees and the scribes asked Him, “Why don't your disciples walk according to the tradition of the elders, but eat their bread with unwashed hands?” ");
INSERT INTO engf35_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","So in answer He said to them: “Well did Isaiah prophesy about you hypocrites, as it stands written: ‘This people honors me with their lips, but their heart is far from me. ");
INSERT INTO engf35_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","But in vain do they worship me, teaching as doctrines the commandments of men.’ ");
INSERT INTO engf35_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Because having left the commandment of God, you hold to the tradition of men—washings of pitchers and cups, and many other similar things that you do.” ");
INSERT INTO engf35_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Indeed He said to them: “You are very good at nullifying the commandment of God, so that you may keep your tradition. ");
INSERT INTO engf35_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","For Moses said, ‘Honor your father and your mother’ and, ‘He who speaks evil of father or mother must be put to death.’ ");
INSERT INTO engf35_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","But you say that if a man should say to father or mother, ‘Whatever profit you might have received from me is Korban’ (that is, a gift to God), ");
INSERT INTO engf35_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","you don't even allow him to do anything for his father or his mother any more, ");
INSERT INTO engf35_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","making the Word of God of no effect by your tradition that you have handed down. Yes, you do many such things.” ");
INSERT INTO engf35_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Upon summoning the larger crowd He said to them: “Hear me, everyone, and understand: ");
INSERT INTO engf35_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","There is nothing outside a man that can defile him by going into him; rather, the things that come out of him, those are the ones that defile him. ");
INSERT INTO engf35_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","If anyone has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","When He had entered a house away from the crowd, His disciples started to question Him about the parable. ");
INSERT INTO engf35_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","So He said to them: “Can you really be without understanding? Don't you perceive that nothing that enters a man from outside can defile him, ");
INSERT INTO engf35_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","because it doesn't go into his heart, but into his stomach, which then expels the impure aspects of the food?” ");
INSERT INTO engf35_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","He went on to say: “That which comes out of a man, that is what defiles him. ");
INSERT INTO engf35_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Because from within, out of men's hearts, the evil designs proceed—adulteries, fornications, murders, ");
INSERT INTO engf35_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","thefts, covetings, malignancies; deceit, lewdness, an evil eye, blasphemy, arrogance, foolishness— ");
INSERT INTO engf35_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","all these malignant things proceed from within and defile the man.” ");
INSERT INTO engf35_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Then He got ready and went from there into the region of Tyre and Sidon. He went into a house and did not want anyone to know it, but He could not escape notice. ");
INSERT INTO engf35_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","In fact, as soon as she heard about Him, a woman whose little daughter had an unclean spirit came and fell at His feet. ");
INSERT INTO engf35_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Now the woman was a Greek, a Syro-Phoenecian by birth, and she kept asking Him to cast the demon out of her daughter. ");
INSERT INTO engf35_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","But Jesus said to her, “Let the children be filled first; it is not good to take the children's bread and throw it to the little dogs.” ");
INSERT INTO engf35_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","So she answered and said to Him, “Yes, Lord, yet even the little dogs under the table eat from the children's crumbs.” ");
INSERT INTO engf35_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","So He said to her, “Because of this saying you may go; the demon has gone out of your daughter.” ");
INSERT INTO engf35_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","She went away to her house and found that the demon was gone and the daughter had been placed on the bed. ");
INSERT INTO engf35_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Again, departing from the region of Tyre and Sidon, Jesus came to the Sea of Galilee by way of the Decapolis region. ");
INSERT INTO engf35_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Then they brought to Him a deaf man with thick speech and begged Him to place His hand on him. ");
INSERT INTO engf35_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","After taking him aside, away from the crowd, He put His fingers in his ears; He also spat and touched his tongue. ");
INSERT INTO engf35_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Then looking up to heaven He sighed, and said to him, “Ephphatha!” that is, “Be opened!” ");
INSERT INTO engf35_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Immediately his ears were opened, his tongue was released, and he began to speak clearly. ");
INSERT INTO engf35_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Then He commanded them that they should tell no one; but the more He would command them, so much the more they would proclaim it. ");
INSERT INTO engf35_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","People were astonished beyond measure, saying: “He has done everything well. He makes both the deaf to hear and the mute to speak.” ");
INSERT INTO engf35_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","In those days, the multitude being very large and not having anything to eat, Jesus called His disciples and said to them: ");
INSERT INTO engf35_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I have compassion on the multitude, because they have stayed with me three days now and have nothing to eat. ");
INSERT INTO engf35_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","If I send them away hungry to their homes, they will give out on the way, because some of them have come a long distance.” ");
INSERT INTO engf35_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","His disciples answered Him, “From what source could anyone satisfy these people with bread here in a wilderness?” ");
INSERT INTO engf35_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","He asked them, “How many loaves do you have?” And they said, “Seven.” ");
INSERT INTO engf35_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","So He told the crowd to sit down on the ground; then taking the seven loaves and giving thanks, He broke them and gave them to His disciples to set before the crowd, and they did. ");
INSERT INTO engf35_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","They also had a few small fish; so blessing them He said to distribute them as well. ");
INSERT INTO engf35_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Well they ate and were filled; they even took up seven hampers of broken pieces that were left over. ");
INSERT INTO engf35_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Now those who had eaten were about four thousand; and He sent them away. ");
INSERT INTO engf35_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Then He got right into the boat with His disciples and went to the region of Dalmanutha. ");
INSERT INTO engf35_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","The Pharisees came out and began to argue with Him, requesting of Him a sign from heaven, by way of testing Him. ");
INSERT INTO engf35_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","But He sighed deeply in His spirit and said: “Why does this generation seek a sign? I tell you emphatically, no sign shall be given to this generation!” ");
INSERT INTO engf35_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Turning His back on them, He got back into the boat and went off to the other side. ");
INSERT INTO engf35_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","(His disciples had forgotten to take bread; they did not have more than one loaf with them in the boat.) ");
INSERT INTO engf35_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","And He charged them, saying, “Watch out; beware of the leaven of the Pharisees and the leaven of Herod.” ");
INSERT INTO engf35_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","So they started reasoning among themselves, saying, “It's because we have no bread.” ");
INSERT INTO engf35_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Being aware of it Jesus said to them: “Why are you reasoning because you have no bread? Do you still neither perceive nor understand? Do you still have hearts that have been hardened? ");
INSERT INTO engf35_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Having eyes do you not see, and having ears do you not hear, and do you not remember? ");
INSERT INTO engf35_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","When I broke the five loaves for the five thousand, how many baskets full of pieces did you take up?” They say to Him, “Twelve.” ");
INSERT INTO engf35_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“And when I broke the seven for the four thousand, how many hampers full of pieces did you take up?” And they said, “Seven.” ");
INSERT INTO engf35_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","So He said to them, “How is it that you still don't understand?” ");
INSERT INTO engf35_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Then He came to Bethsaida; and they brought a blind man to Him and begged Him to touch him. ");
INSERT INTO engf35_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","So He took the blind man by the hand and led him out of the village; then spitting into his eyes and laying hands on him, He asked him if he saw anything. ");
INSERT INTO engf35_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","And looking up he said, “I do see men, only they look like walking trees.” ");
INSERT INTO engf35_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Then He put His hands on his eyes again, and made him look up; and he was restored and saw everyone clearly. ");
INSERT INTO engf35_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Then He sent him away to his house, saying, “Neither go into the village nor tell anyone in the village.” ");
INSERT INTO engf35_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Then Jesus and His disciples set out for the towns of Caesarea Philippi; and on the way He questioned His disciples, saying to them, “Who are people saying that I am?” ");
INSERT INTO engf35_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","So they answered, “John the Baptist; others Elijah; still others one of the prophets.” ");
INSERT INTO engf35_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","He said to them, “And who do you say that I am?” So Peter answered and said to Him, “You are the Christ!” ");
INSERT INTO engf35_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Then He charged them that they should tell no one about Him. ");
INSERT INTO engf35_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","He then began to teach them that the Son of the Man must suffer many things, and be rejected by the elders, chief priests and the scribes, and be killed, and after three days rise again. ");
INSERT INTO engf35_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","He said these things quite plainly. Then Peter took Him aside and began to rebuke Him. ");
INSERT INTO engf35_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","But He turned, looked at His disciples, and rebuked Peter, saying: “Get behind me, Satan! You have in mind men's values, not God's values.” ");
INSERT INTO engf35_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","He summoned the crowd, along with His disciples, and said to them: “Whoever wants to follow along behind me must deny himself and take up his cross and follow me. ");
INSERT INTO engf35_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Because whoever may resolve to ‘save’ his life will waste it; but whoever may ‘waste’ his life for my sake and the Gospel's, he will save it. ");
INSERT INTO engf35_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Well, what will it profit a man if he gains the whole world, yet forfeits his soul? ");
INSERT INTO engf35_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Or what can a man give in exchange for his soul? ");
INSERT INTO engf35_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yes, whoever is ashamed of me and my words in this adulterous and sinful generation, the Son of the Man will also be ashamed of Him whenever He comes in the glory of His Father with the holy Angels.” ");
INSERT INTO engf35_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","And He said to them, “I tell you assuredly: there are some standing here who will certainly not taste death until they see the Kingdom of God present with power.” ");
INSERT INTO engf35_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","After six days Jesus took Peter, James and John and led them up on a high mountain alone by themselves. Then He was transfigured in front of them; ");
INSERT INTO engf35_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","His clothing became shining, exceedingly white, like snow, such as no launderer on earth is able to whiten. ");
INSERT INTO engf35_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","And Elijah appeared to them, along with Moses, and they were conversing with Jesus. ");
INSERT INTO engf35_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Well Peter reacted by saying to Jesus, “Rabbi, it is good for us to be here; let us make three shelters: one for you, one for Moses and one for Elijah.” ");
INSERT INTO engf35_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Because they were terrified, he didn't know what to say.) ");
INSERT INTO engf35_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","With that a cloud was covering them and a Voice came out of the cloud: “This is my Son, the beloved. Listen to Him!” ");
INSERT INTO engf35_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","And then, looking around, they no longer saw anyone with them except Jesus. ");
INSERT INTO engf35_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Now as they were coming down from the mountain, He ordered them not to recount to any one the things they had seen until the Son of the Man had risen from the dead. ");
INSERT INTO engf35_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","So they kept this word to themselves, questioning what the ‘rising from the dead’ meant. ");
INSERT INTO engf35_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","And they asked Him, saying, “Why do the scribes say that Elijah must come first?” ");
INSERT INTO engf35_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","So in answer He said to them: “Elijah indeed does come first, and restores all things; also how it is written concerning the Son of the Man that He must suffer many things and be treated with contempt. ");
INSERT INTO engf35_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Still, I say to you that ‘Elijah’ has also come, and they did to him as they wished, as it is written about him.” ");
INSERT INTO engf35_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Upon coming to the disciples, He saw a large crowd around them, and scribes arguing with them. ");
INSERT INTO engf35_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Well as soon as the crowd saw Him they were excited and ran to greet Him. ");
INSERT INTO engf35_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","He asked the scribes, “What are you discussing with them?” ");
INSERT INTO engf35_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","In answer a man in the crowd said: “Teacher, I brought you my son, who has a mute spirit. ");
INSERT INTO engf35_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","And wherever it seizes him it throws him down, and he foams at the mouth and gnashes his teeth, and becomes rigid. Indeed, I spoke to your disciples, that they might cast it out, but they could not.” ");
INSERT INTO engf35_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","But He answered him by saying: “O unbelieving generation, how long shall I be with you, how long shall I put up with you? Bring him to me!” ");
INSERT INTO engf35_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","So they brought him to Him. Upon seeing Him the spirit convulsed him, and falling to the ground he started wallowing, foaming at the mouth. ");
INSERT INTO engf35_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Then He asked his father, “How long has this been happening to him?” And he said: “From childhood. ");
INSERT INTO engf35_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Really, it has often thrown him both into fire and into water to destroy him. But if you can do anything, have compassion on us and help us.” ");
INSERT INTO engf35_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus said to him, “It's ‘if you can believe’; all things are possible to the one who believes.” ");
INSERT INTO engf35_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Immediately the father of the child cried out and said, with tears, “Lord, I believe; help my unbelief!” ");
INSERT INTO engf35_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","When Jesus saw that the crowd was running up, He rebuked the unclean spirit, saying to it, “You mute and deaf spirit, I am commanding you, get out of him and never enter him again!” ");
INSERT INTO engf35_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Then it yelled, convulsed him violently, and came out. Well he looked to be dead; so much so that many said, “He's dead.” ");
INSERT INTO engf35_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","But Jesus took him by the hand and lifted him up, and he stayed on his feet. ");
INSERT INTO engf35_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Well upon His entering a house His disciples asked Him privately, “Why couldn't we cast it out?” ");
INSERT INTO engf35_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","He said to them, “This kind can come out by nothing except prayer and fasting.” ");
INSERT INTO engf35_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Having gone out from there they were passing through Galilee, and He did not want anyone to know; ");
INSERT INTO engf35_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","because He was teaching His disciples and saying to them, “The Son of the Man is going to be betrayed into the hands of men, and they will kill him; and once killed he will rise on the third day.” ");
INSERT INTO engf35_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","But they were not understanding this information, yet were afraid to ask Him. ");
INSERT INTO engf35_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Then He came to Capernaum; and once in the house He asked them, “What were you debating among yourselves on the road?” ");
INSERT INTO engf35_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","But they kept silent, because on the road they had debated among themselves who was greater. ");
INSERT INTO engf35_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","So He sat down, called the twelve and said to them, “If anyone desires to be first, he must be last of all and servant of all.” ");
INSERT INTO engf35_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Then He took a child and stood him in their midst, and embracing him said to them, ");
INSERT INTO engf35_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Whoever receives one such child in my name receives me, and whoever receives me receives not only me, but the One who sent me.” ");
INSERT INTO engf35_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","So John answered Him saying, “Teacher, we saw someone casting out demons in your name, one who doesn't follow us; and we forbade him, because he doesn't follow us.” ");
INSERT INTO engf35_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","But Jesus said: “Do not forbid him, because no one who works a miracle in my name can soon afterward speak evil of me. ");
INSERT INTO engf35_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","For he who is not against you is for you. ");
INSERT INTO engf35_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Further, whoever gives you a cup of water to drink in my name, because you are Christ's, I tell you with certainty, he will by no means lose his reward. ");
INSERT INTO engf35_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Whoever causes one of these little ones who believe into me to fall, it would be better for him if a millstone were hung around his neck and he were thrown into the sea. ");
INSERT INTO engf35_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Further, if your hand is causing you to fall, cut it off; it is better for you to enter into the Life maimed than having both hands to go away into Gehenna, into the unquenchable fire— ");
INSERT INTO engf35_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","where ‘their worm does not die, and the fire is not quenched.’ ");
INSERT INTO engf35_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","And if your foot is causing you to fall, cut it off; it is better for you to enter into the Life lame than having both feet to be thrown into Gehenna, into the unquenchable fire— ");
INSERT INTO engf35_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","where ‘their worm does not die, and the fire is not quenched.’ ");
INSERT INTO engf35_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","And if your eye is causing you to fall, pluck it out; it is better for you to enter into the Kingdom of God with one eye than having both eyes to be thrown into the Gehenna of fire— ");
INSERT INTO engf35_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","where ‘the worm does not die, and the fire is not quenched.’ ");
INSERT INTO engf35_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Further, everyone will be seasoned with fire, and every sacrifice will be seasoned with salt. ");
INSERT INTO engf35_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Salt is good, but if the salt loses its saltiness, with what will you season it? Have salt in yourselves, and be at peace with one another.” ");
INSERT INTO engf35_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Then He set out from there and came into the borders of Judea, by way of the other side of the Jordan. Again, crowds gathered to Him, and as was His custom, He began to teach them once more. ");
INSERT INTO engf35_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Then some Pharisees approached to test Him and asked Him, “Is it lawful for a man to divorce a wife?” ");
INSERT INTO engf35_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","So in answer He said to them, “What did Moses command you?” ");
INSERT INTO engf35_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","They said, “Moses permitted one to write a certificate of divorce and to put away.” ");
INSERT INTO engf35_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus answered and said to them: “It was due to your hardness of heart that he wrote you this precept. ");
INSERT INTO engf35_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","But from the beginning of creation, God made them a male and a female. ");
INSERT INTO engf35_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘For this reason a man shall leave his father and mother and be joined to his wife, ");
INSERT INTO engf35_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","and the two will be turned into one flesh.’ So then, they are no longer two but one flesh. ");
INSERT INTO engf35_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Therefore what God has joined together, let man not separate.” ");
INSERT INTO engf35_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","When they were in the house again, His disciples asked Him about the same subject. ");
INSERT INTO engf35_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","So He said to them, “Whoever divorces his wife and marries another commits adultery against her; ");
INSERT INTO engf35_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","and if a woman divorces her husband and gets married to another, she commits adultery.” ");
INSERT INTO engf35_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","People started bringing little children to Him, that He might touch them; so the disciples started rebuking those doing the bringing. ");
INSERT INTO engf35_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","But when Jesus saw it He was indignant and said to them: “Let the little children come to me; do not hinder them, because the Kingdom of God is made up of such. ");
INSERT INTO engf35_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I tell you assuredly, whoever does not receive the Kingdom of God like a little child does will certainly not enter it.” ");
INSERT INTO engf35_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","And taking them in His arms and laying His hands on them, He blessed them. ");
INSERT INTO engf35_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","As Jesus set out on the road, someone came running up, knelt before Him and asked Him, “Good Teacher, what must I do that I may inherit eternal life?” ");
INSERT INTO engf35_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","So Jesus said to Him: “Why do you call me ‘good’? No one is good except one—God. ");
INSERT INTO engf35_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","You know the commandments: ‘Do not commit adultery,’ ‘Do not murder,’ ‘Do not steal,’ ‘Do not give false testimony,’ ‘Do not defraud,’ ‘Honor your father and mother.’ ” ");
INSERT INTO engf35_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","In answer he said to Him, “Teacher, I have kept all these since I was young.” ");
INSERT INTO engf35_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Then Jesus, looking at him, loved him, and said to him: “One thing you lack; go, sell whatever you have and give to the poor, and you will have treasure in heaven. Then come, take up the cross, and follow me.” ");
INSERT INTO engf35_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","But he was dismayed at the suggestion and went away sorrowing, because he had many possessions. ");
INSERT INTO engf35_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Then Jesus looked around and said to His disciples, “How hard it is for those who have riches to get into the Kingdom of God!” ");
INSERT INTO engf35_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","But the disciples were astounded at His words. So Jesus tried again and said to them: “Children, how hard it is for those who trust in riches to enter the Kingdom of God. ");
INSERT INTO engf35_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","It is actually easier for a camel to go through a needle's eye than for a rich man to enter the Kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Then they were totally astonished, saying to each other, “Who then can be saved?” ");
INSERT INTO engf35_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","But Jesus looked at them and said, “With men it is impossible, but not with God; because all things are possible with God.” ");
INSERT INTO engf35_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Then Peter began to say to Him, “So, we have left all and followed you.” ");
INSERT INTO engf35_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","In answer Jesus said: “I tell you assuredly, there is no one who has left house or brothers or sisters or father or mother or wife or children or fields, for my sake and for that of the Gospel, ");
INSERT INTO engf35_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","who will not receive a hundred times more, now in this time—houses and brothers and sisters and father and mother and children and fields (with persecutions)—and in the age to come, eternal life. ");
INSERT INTO engf35_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","But many first will be last, and last first.” ");
INSERT INTO engf35_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Now they were on the road going up to Jerusalem, and Jesus was going ahead of them; this surprised them, and as they followed they started to be afraid. Then He took the twelve aside again and began to tell them the things that were about to happen to Him: ");
INSERT INTO engf35_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Take note, we are going up to Jerusalem, and the Son of the Man will be betrayed to the chief priests and the scribes; and they will condemn Him to death and deliver Him over to the Gentiles; ");
INSERT INTO engf35_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","and they will mock Him, and scourge Him, and spit on Him, and kill Him. And on the third day He will rise again.” ");
INSERT INTO engf35_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Then James and John, the sons of Zebedee, approached Him and said, “Teacher, we want you to do for us whatever we may ask.” ");
INSERT INTO engf35_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","So He said to them, “What do you want me to do for you?” ");
INSERT INTO engf35_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","They said to Him, “Grant to us that we may sit, one at your right and one at your left, in your glory.” ");
INSERT INTO engf35_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","But Jesus said to them: “You do not know what you are asking. Are you able to drink the cup that I drink, and to be baptized with the baptism that I am baptized with?” ");
INSERT INTO engf35_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","They said to Him, “We are able.” So Jesus said to them: “You will indeed drink the cup that I drink, and you will be baptized with the baptism that I am baptized with; ");
INSERT INTO engf35_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","but to sit at my right and at my left is not mine to grant, but is for whom it has been prepared.” ");
INSERT INTO engf35_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Well when the ten heard it they began to be indignant with James and John. ");
INSERT INTO engf35_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","But Jesus summoned them and said to them: “You know that those who are regarded as rulers of the Gentiles lord it over them, and their great ones exercise authority over them. ");
INSERT INTO engf35_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","But it must not be so among you, but whoever desires to become great among you must be your servant, ");
INSERT INTO engf35_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","and whoever desires to be your number one must be slave of all. ");
INSERT INTO engf35_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","For even the Son of the Man did not come to be served, but to serve, and to give His life a ransom for many.” ");
INSERT INTO engf35_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","They came to Jericho. Then as He was going out from Jericho, with His disciples and a large crowd, the blind Bartimaeus (son of Timaeus) was sitting by the roadside begging. ");
INSERT INTO engf35_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","And when he heard that it was Jesus the Natsorean, he began to call out and say, “O Son of David, Jesus, have mercy on me!” ");
INSERT INTO engf35_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Many started telling him to shut up, but he started calling out even louder, “Son of David, have mercy on me!” ");
INSERT INTO engf35_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","So Jesus stood still and said to call him. Then they called the blind man, saying to him: “Courage! Get up! He's calling you!” ");
INSERT INTO engf35_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tossing off his cloak, he got up and went to Jesus. ");
INSERT INTO engf35_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus reacted by saying to him, “What do you want me to do for you?” The blind man said to Him, “Rabouni, that I may see again!” ");
INSERT INTO engf35_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","So Jesus said to him, “Go; your faith has healed you.” And immediately he could see, and followed Jesus on the road. ");
INSERT INTO engf35_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Now when they were drawing near Jerusalem, to Bethphage and Bethany, at the Mount of Olives, He sent two of His disciples, ");
INSERT INTO engf35_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","saying to them: “Go into the village opposite you; and as soon as you enter it you will find a foal tied, on which no man has sat. Untie and bring it. ");
INSERT INTO engf35_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","And if anyone says to you, ‘Why are you doing this?’ say, ‘The Lord has need of it,’ and thereupon he will send it here.” ");
INSERT INTO engf35_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","So they went and found the foal tied at the door, out in the street, and they loosed it. ");
INSERT INTO engf35_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Some of those who stood there said to them, “What are you doing, untying the foal?” ");
INSERT INTO engf35_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","So they answered them just as Jesus had instructed, and they let them go. ");
INSERT INTO engf35_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Then they brought the foal to Jesus, and they placed their clothes on it, and He sat on it. ");
INSERT INTO engf35_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","And many spread their clothes on the road, while others were cutting leafy branches from the trees and spreading them on the road. ");
INSERT INTO engf35_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Both those who went in front and those who followed started calling out, saying: “Hosanna!” “Blessed is He who comes in the name of the Lord!” ");
INSERT INTO engf35_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Blessed is the Kingdom of our father David that is coming in the name of the Lord!” “Hosanna in the highest!” ");
INSERT INTO engf35_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","So Jesus entered Jerusalem and went into the temple. And when He had looked around at everything, the hour being late, He went out to Bethany with the twelve. ");
INSERT INTO engf35_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Now the next day, as they were leaving Bethany, He was hungry. ");
INSERT INTO engf35_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","And seeing from a distance a fig tree having leaves, He went to see if perhaps He would find something on it. When He came to it He found nothing but leaves, because it was not fig season. ");
INSERT INTO engf35_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","So Jesus reacted by saying to it, “Let no one ever eat fruit from you again!” And His disciples were listening. ");
INSERT INTO engf35_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","So they came to Jerusalem, and entering the temple Jesus began to drive out those who sold and bought in the temple, and He overturned the tables of the money changers and the seats of the dove sellers. ");
INSERT INTO engf35_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","And He would not allow anyone to carry a container through the temple. ");
INSERT INTO engf35_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","And He kept teaching them by saying: “Is it not written, ‘My house will be called a house of prayer for all the nations’? but you have made it ‘a den of robbers’!” ");
INSERT INTO engf35_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Well the scribes and the chief priests heard it, and kept on looking for a way to destroy Him; because they were afraid of Him, in that all the people were astonished at His teaching. ");
INSERT INTO engf35_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","When evening came, He went out of the city. ");
INSERT INTO engf35_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Now in the morning, as they passed by, they saw the fig tree dried up from the roots. ");
INSERT INTO engf35_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","And Peter, remembering, said to Him: “Rabbi, look! The fig tree that you cursed has dried up!” ");
INSERT INTO engf35_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","So in answer Jesus said to them: “Have faith in God. ");
INSERT INTO engf35_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Because I tell you assuredly, whoever says to this mountain, ‘Be picked up and be thrown into the sea,’ and does not doubt in his heart but believes that the things he says will happen, he will have whatever he says. ");
INSERT INTO engf35_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","That is why I say to you, whatever things you ask for in prayer, believe that you receive, and you will have them. ");
INSERT INTO engf35_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“And whenever you stand praying, forgive, if you have anything against anyone, so that your Father, who is in heaven, may also forgive you your trespasses. ");
INSERT INTO engf35_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","But if you do not forgive, neither will your Father who is in heaven forgive your trespasses.” ");
INSERT INTO engf35_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Then they came again to Jerusalem. And as He was walking in the temple, the chief priests, the scribes and the elders came to Him. ");
INSERT INTO engf35_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","And they said to Him, “By what authority are you doing these things?” and “Who gave you this authority to do these things?” ");
INSERT INTO engf35_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","So in answer Jesus said to them: “I also will ask you one question; answer me, and I will tell you by what authority I am doing these things. ");
INSERT INTO engf35_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","The baptism of John: was it from heaven or from men?” ");
INSERT INTO engf35_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","They considered among themselves, saying: “If we say, ‘From heaven,’ he will say, ‘So why did you not believe him?’ ");
INSERT INTO engf35_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","But if we say, ‘From men’…”—they feared the people, for everyone held John to really be a prophet. ");
INSERT INTO engf35_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","So they answered Jesus by saying, “We don't know.” And in answer Jesus said to them, “Neither do I tell you by what authority I do these things.” ");
INSERT INTO engf35_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Then He began to speak to them in parables: “A man planted a vineyard—put a hedge around it, dug a wine trough, built a tower—rented it to farmers and went on a journey. ");
INSERT INTO engf35_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","At the proper time he sent a slave to the farmers, that he might receive from them some of the fruit of the vineyard. ");
INSERT INTO engf35_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","But they took him, beat him, and sent him away empty-handed. ");
INSERT INTO engf35_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Again he sent another slave to them, and that one they wounded in the head by stoning, and sent him away shamefully treated. ");
INSERT INTO engf35_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Again he sent another, and him they killed; and many others, beating some and killing some. ");
INSERT INTO engf35_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Finally, still having his one beloved son, he even sent him to them, saying, ‘They will respect my son.’ ");
INSERT INTO engf35_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","But those farmers said to one another: ‘This is the heir. Come, let's kill him and the inheritance will be ours.’ ");
INSERT INTO engf35_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","So they took him, killed him, and threw him out of the vineyard. ");
INSERT INTO engf35_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“What therefore will the owner of the vineyard do? He will come and destroy those farmers, and give the vineyard to others. ");
INSERT INTO engf35_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Have you not even read this Scripture: ‘The stone that the builders rejected, is the very one that became the cornerstone; ");
INSERT INTO engf35_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","this was the Lord's doing, and it is marvelous in our eyes’?” ");
INSERT INTO engf35_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","So they started looking for a way to arrest Him, because they knew He had spoken the parable against them, but they were in fear of the crowd. Then they left Him and went away. ");
INSERT INTO engf35_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Then they sent some of the Pharisees and of the Herodians to Him, in order to trap Him with a question. ");
INSERT INTO engf35_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Upon arriving they said to Him: “Teacher, we know that you are honest—you do not ‘protect’ anyone, because you do not consider the position of people, but teach the way of God in truth—is it right to pay taxes to Caesar, or not? ");
INSERT INTO engf35_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Should we pay, or should we not?” But knowing their hypocrisy, He said to them: “Why are you testing me? Bring me a denarius to look at.” ");
INSERT INTO engf35_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","So they did, and He said to them, “Whose image and inscription is this?” They said to Him, “Caesar's.” ");
INSERT INTO engf35_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Then Jesus answered them by saying, “Render to Caesar the things that are Caesar's, and to God the things that are God's.” And they marveled at Him. ");
INSERT INTO engf35_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Then some Sadducees came to Him—they say there is no resurrection—and asked Him, saying: ");
INSERT INTO engf35_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Teacher, Moses wrote to us that if a man's brother dies and leaves behind a wife, but no children, then his brother should take that wife and raise up offspring for his brother. ");
INSERT INTO engf35_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Well there were seven brothers. The first took a wife, and dying left no offspring. ");
INSERT INTO engf35_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","So the second one took her, and died; and neither did he leave any offspring. The third likewise. ");
INSERT INTO engf35_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","In fact, all seven took her, and left no offspring. Last of all the woman also died. ");
INSERT INTO engf35_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","In the resurrection, whenever they may rise, whose wife will she be?—because all seven had her as wife.” ");
INSERT INTO engf35_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Then in answer Jesus said to them: “You do not know the Scriptures nor the power of God—is this not the reason that you err? ");
INSERT INTO engf35_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Whenever people rise from the dead, they neither marry nor are given in marriage, but are like angels in the heavens. ");
INSERT INTO engf35_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","But concerning the dead, that they rise, have you not read in the book of Moses, about the Bush, how God spoke to him, saying, ‘I am the God of Abraham, and the God of Isaac, and the God of Jacob’? ");
INSERT INTO engf35_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","He is not the God of dead people, but the God of living ones. You are therefore badly mistaken.” ");
INSERT INTO engf35_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Then one of the scribes came on the scene, heard them arguing, realized that He had answered them well, and asked Him, “Which is the first commandment of all?” ");
INSERT INTO engf35_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus answered him: “The first of all the commandments is: ‘Hear, O Israel, the Lord your (pl) God, the Lord is one; ");
INSERT INTO engf35_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","and you (sg) shall love the Lord your (sg) God with all your heart and with all your soul and with all your mind and with all your strength.’ This is the first commandment. ");
INSERT INTO engf35_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","And the second, like it, is this: ‘You shall love your neighbor as yourself.’ There is no other commandment greater than these.” ");
INSERT INTO engf35_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","So the scribe said to Him: “Well said, teacher; you said truly that He is one, and there is no other except He. ");
INSERT INTO engf35_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","And to love Him with all the heart and with all the understanding and with all the soul and with all the strength, and to love the neighbor as oneself, is more than all the whole burnt offerings and sacrifices.” ");
INSERT INTO engf35_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Now when Jesus saw that he answered wisely, He said to him, “You are not far from the Kingdom of God.” And after that no one dared ask Him any question. ");
INSERT INTO engf35_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Then, teaching in the temple, Jesus reacted by saying: “How is it that the scribes say that the Messiah is David's son? ");
INSERT INTO engf35_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Because David himself said by the Holy Spirit: ‘The Lord said to my Lord, “Sit at my right hand, until I place your enemies as a stool for your feet.” ’ ");
INSERT INTO engf35_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Therefore David himself calls Him ‘Lord’; so how can He be his son?” The large crowd listened to Him with pleasure. ");
INSERT INTO engf35_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Then He said to them in His teaching: “Beware of the scribes, who like to walk about in long robes and to get greetings in the market places, ");
INSERT INTO engf35_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","and the best seats in the synagogues, and the best places at feasts; ");
INSERT INTO engf35_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","who devour the houses of widows, while praying long and loud for a show. These will receive a more severe judgment.” ");
INSERT INTO engf35_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Then Jesus sat down opposite the offering chest and started watching how the people were depositing money into the chest. Many rich people put in large amounts. ");
INSERT INTO engf35_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","A certain poor widow also came and put in two ‘lepta’, which equal a ‘quadrans’. ");
INSERT INTO engf35_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","So summoning His disciples He said to them: “I tell you assuredly that this poor widow has put more in the chest than all these contributors; ");
INSERT INTO engf35_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","because they all gave out of their excess, but she, out of her lack, put in all that she had, her whole livelihood.” ");
INSERT INTO engf35_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Then as He was going out from the temple, one of His disciples said to Him: “Teacher, just look! Such stones, such buildings!” ");
INSERT INTO engf35_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","In answer Jesus said to him: “Do you see these great buildings? Here not a single stone will be left upon another; each one will be thrown down.” ");
INSERT INTO engf35_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Then as He was sitting on the Mount of Olives opposite the temple, Peter, James, John and Andrew asked Him privately: ");
INSERT INTO engf35_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tell us, when will these things be? And what will be the sign whenever all these things are about to be fulfilled?” ");
INSERT INTO engf35_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","So by way of an answer to them Jesus began by saying: “Take care that no one deceives you. ");
INSERT INTO engf35_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Because many will come in my name, saying, ‘I am he,’ and will deceive many. ");
INSERT INTO engf35_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","But whenever you hear of wars and rumors of wars, do not let it distress you; because happen they must, but the end is not yet. ");
INSERT INTO engf35_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Because nation will be raised against nation, and kingdom against kingdom; and there will be earthquakes in various places, and there will be famines and tumults. These things are the beginning of birth pains. ");
INSERT INTO engf35_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“But watch out for yourselves, because they will deliver you up to councils and flog you in synagogues, and you will be brought before rulers and kings for my sake, as a testimony to them. ");
INSERT INTO engf35_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Also, the Gospel must first be proclaimed to all the ethnic nations. ");
INSERT INTO engf35_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Now whenever they lead you away and deliver you up, do not worry beforehand nor premeditate what you will say; rather, whatever is given to you in that hour, speak that, because it will not be you doing the speaking, but the Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Further, brother will betray brother to death and a father his child, and children will rise up against parents and cause them to be put to death. ");
INSERT INTO engf35_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","And you will be hated by all for my name's sake, yet he who endures to the end, he will be saved. ");
INSERT INTO engf35_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Now whenever you see the ‘abomination of desolation’, the one spoken of by Daniel the prophet, standing where he should not”—let the reader understand—“then let those who are in Judea flee to the mountains. ");
INSERT INTO engf35_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Let him who is on the housetop not go down into the house, nor enter to take anything out of his house. ");
INSERT INTO engf35_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Let him who is in the field not return to his things to get his cloak. ");
INSERT INTO engf35_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","But woe to those who are pregnant and to those who are nursing babies in those days! ");
INSERT INTO engf35_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","And pray that your flight not take place in winter, ");
INSERT INTO engf35_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","because those will be days of affliction such as there has not been the like from the beginning of the creation that God created until now, and never again shall be. ");
INSERT INTO engf35_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","If the Lord did not cut those days short, no one would be saved; but for the sake of the elect, whom He chose, He did shorten the days. ");
INSERT INTO engf35_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Then if anyone says to you, ‘Look, here is the Christ!’ ‘Look, there!’ do not believe it; ");
INSERT INTO engf35_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","because false christs and false prophets will be raised up, and they will show signs and wonders so as to even mislead the elect, if that were possible. ");
INSERT INTO engf35_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","So you watch out! See, I have told you everything in advance. ");
INSERT INTO engf35_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“But in those days, after that tribulation, ‘the sun will be darkened, and the moon will not give its light; ");
INSERT INTO engf35_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","the stars of heaven will be falling, and the powers that are in the heavens will be shaken.’ ");
INSERT INTO engf35_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","And then they will see the Son of the Man coming in clouds with great power and glory. ");
INSERT INTO engf35_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","And then He will send His angels and gather together His elect from the four winds, from earth's extreme point to heaven's extreme point. ");
INSERT INTO engf35_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Now learn this example from the fig tree: whenever its branch becomes tender and sprouts leaves, one knows that the summer is near. ");
INSERT INTO engf35_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Even so you also, whenever you see these things happening, know that it is near—at the doors! ");
INSERT INTO engf35_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Assuredly I tell you that this generation will certainly not pass away until all these things happen. ");
INSERT INTO engf35_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","The heaven and the earth will pass away, but my words will certainly not pass away. ");
INSERT INTO engf35_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Now concerning that day or hour no one knows, not even the angels who are in heaven, not the Son, but only the Father. ");
INSERT INTO engf35_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Watch! Keep alert! Pray! Because you do not know when that time will be. ");
INSERT INTO engf35_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","It is like a man off on a journey, having left his house and given the authority to his slaves, and to each his work; and he commanded the doorkeeper to keep watch. ");
INSERT INTO engf35_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Therefore be watchful, because you do not know when the master of the house is coming—at evening or at midnight or at cockcrow or early morning— ");
INSERT INTO engf35_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","lest coming suddenly he find you sleeping. ");
INSERT INTO engf35_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","The things I say to you, I say to all: Watch!” ");
INSERT INTO engf35_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","It was two days before the Passover and the Unleavened Bread. The chief priests and the scribes were looking for an underhanded way to seize and kill Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","But they said, “Not during the feast, or the people may riot.” ");
INSERT INTO engf35_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Being in Bethany at the house of Simon the leper, as He was reclining at a meal, a woman came having an alabaster vase of very costly perfume of pure nard. Then she broke the vase and began to pour it over His head. ");
INSERT INTO engf35_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","But there were some who were expressing indignation to one another and saying: “To what purpose was this perfume wasted? ");
INSERT INTO engf35_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","It could have been sold for more than three hundred denarii and given to the poor!” And they started censuring her. ");
INSERT INTO engf35_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","But Jesus said: “Leave her alone! Why are you bothering her? She has done something useful to me. ");
INSERT INTO engf35_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","You will always have the poor with you, and whenever you wish you can do them good; but you will not always have me. ");
INSERT INTO engf35_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","She did what she could. She has perfumed my body for the burying before the fact. ");
INSERT INTO engf35_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Assuredly I tell you, wherever this Gospel may be proclaimed throughout the whole world, what she has done will also be told as a memorial to her.” ");
INSERT INTO engf35_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Then Judas Iscariot, one of the twelve, went off to the chief priests, so as to betray Him to them. ");
INSERT INTO engf35_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Well upon hearing it they rejoiced and promised to give him silver coins. So he started figuring how he might conveniently betray Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Now on the first day of Unleavened Bread, when they would sacrifice the Paschal lamb, His disciples said to Him, “Where do you want us to go and prepare, so that you may eat the Passover?” ");
INSERT INTO engf35_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","So He sent two of His disciples, saying to them: “Go into the city, and a man will meet you carrying a clay jar of water; follow him. ");
INSERT INTO engf35_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wherever he goes in, say to the master of the house, ‘The teacher says, “Where is the guest room where I may eat the Passover with my disciples?” ’ ");
INSERT INTO engf35_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","He will show you a large upper room, furnished and ready; there prepare for us.” ");
INSERT INTO engf35_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","So His disciples set out and came into the city and found it just as He had said to them; and they prepared the Passover. ");
INSERT INTO engf35_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","When it was evening He came with the twelve. ");
INSERT INTO engf35_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Now as they were reclining and eating, Jesus said, “Assuredly I tell you, one of you who is eating with me will betray me.” ");
INSERT INTO engf35_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","So they began to be sorrowful and to say to Him one by one, “Surely not I?” And another, “Surely not I?” ");
INSERT INTO engf35_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","He answered and said to them: “It is one of the twelve, the one dipping with me in the bowl. ");
INSERT INTO engf35_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","The Son of the Man is indeed going just as it is written about him, but woe to that man by whom the Son of the Man is betrayed! It would have been better for that man not to have been born.” ");
INSERT INTO engf35_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","As they were eating, Jesus took bread, blessed and broke it, gave it to them and said, “Take, eat; this is my body.” ");
INSERT INTO engf35_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Then He took the cup, and when He had given thanks He gave it to them, and they all drank it. ");
INSERT INTO engf35_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","And He said to them: “This is my blood, that of the new covenant, that is being shed for many. ");
INSERT INTO engf35_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","I tell you assuredly that I will not drink again of this fruit of the vine until that day when I drink it new in the Kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","And when they had sung a hymn, they went out to the Mount of Olives. ");
INSERT INTO engf35_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Then Jesus said to them: “All of you will be caused to stumble because of me this night, because it is written: ‘I will strike the shepherd, and the sheep will be scattered.’ ");
INSERT INTO engf35_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","But after I have been raised, I will go before you to Galilee.” ");
INSERT INTO engf35_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","But Peter said to Him, “Even if all are caused to stumble, yet not I.” ");
INSERT INTO engf35_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus said to him, “I tell you assuredly that you, today, this very night, before a rooster crows twice, you will deny me three times.” ");
INSERT INTO engf35_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","But he insisted even more vehemently, “If I have to die with you, I will absolutely not deny you!” And all the others said the same. ");
INSERT INTO engf35_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Then they came to a place that was named Gethsemane; and He said to His disciples, “Sit here while I pray.” ");
INSERT INTO engf35_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","But He took with Him Peter, James and John, and began to be greatly troubled and distressed. ");
INSERT INTO engf35_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","And He said to them: “My soul is overwhelmed with grief, to the point of death. Stay here and keep watch.” ");
INSERT INTO engf35_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Going on a little, He fell to the ground and started praying that if it were possible the hour might pass from Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","And He said: “Abba (Father), all things are possible to you. Please remove this cup from me; yet not what I will, but what you will.” ");
INSERT INTO engf35_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Then He came and found them sleeping, and said to Peter: “Simon, are you sleeping? Couldn't you keep watch for even one hour? ");
INSERT INTO engf35_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Watch and pray, that you may not enter into temptation. The spirit indeed is willing, but the flesh is weak.” ");
INSERT INTO engf35_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Again He went away and prayed, saying the same thing. ");
INSERT INTO engf35_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","And when He returned He found them sleeping again, because their eyes were being weighed down; and they did not know how to answer Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Then He came the third time and said to them: “You are still sleeping and resting! It is enough, the hour has come; yes, the Son of the Man is being betrayed into the hands of sinners. ");
INSERT INTO engf35_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Get up, let's be going. See, my betrayer has approached.” ");
INSERT INTO engf35_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","And immediately, while He was still speaking, Judas, one of the twelve, arrived, and with him a considerable crowd with swords and clubs, from the chief priests and the scribes and the elders. ");
INSERT INTO engf35_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Now His betrayer had given them a signal, saying, “Whomever I kiss, he it is; seize him and take him away securely.” ");
INSERT INTO engf35_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","So upon arriving he went directly to Him and said to Him, “Rabbi, Rabbi!” and kissed Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","So they laid their hands on Him and secured Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","But a certain one of those who stood by drew his sword and struck the servant of the high priest, and cut off his ear. ");
INSERT INTO engf35_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Then Jesus reacted by saying to them: “You have come out with swords and clubs to arrest me, as if I were a bandit. ");
INSERT INTO engf35_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","I was with you daily in the temple, teaching, and you did not seize me. But the Scriptures must be fulfilled.” ");
INSERT INTO engf35_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Then they all deserted Him and ran away. ");
INSERT INTO engf35_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Now a certain young man had followed Him, having a linen cloth thrown around his naked body. The young men grabbed him, ");
INSERT INTO engf35_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","so leaving the linen cloth he fled from them naked. ");
INSERT INTO engf35_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","They led Jesus away to the high priest; and with him were assembled all the chief priests, the elders, and the scribes. ");
INSERT INTO engf35_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Well Peter had followed Him at a distance, right into the courtyard of the high priest; and he was sitting with the operatives and warming himself at the fire. ");
INSERT INTO engf35_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Now the chief priests and the whole council were seeking testimony against Jesus so as to kill Him, but were not finding any. ");
INSERT INTO engf35_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","To be sure, many were testifying falsely against Him, but their statements did not agree. ");
INSERT INTO engf35_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Then some stood up and started testifying falsely against Him, saying, ");
INSERT INTO engf35_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“We heard him saying: ‘I will destroy this temple made with hands, and in three days I will build another made without hands.’ ” ");
INSERT INTO engf35_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","But not even then did their testimony agree. ");
INSERT INTO engf35_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Then the high priest stood up in the center and questioned Jesus, saying: “Are you not going to answer? What are these testifying against you?” ");
INSERT INTO engf35_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","But He remained silent and answered nothing. Again the high priest questioned Him and said to Him, “Are you the Christ, the Son of the Blessed?” ");
INSERT INTO engf35_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","So Jesus said: “I am, and you will see the Son of the Man sitting at the right hand of the Power, and coming with the clouds of the heaven.” ");
INSERT INTO engf35_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Then the high priest tore his clothes and said: “What further need do we have of witnesses? ");
INSERT INTO engf35_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","You heard the blasphemy! What do you think?” They all condemned Him to be deserving of death. ");
INSERT INTO engf35_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Then some began to spit on Him, to cover His face, punch Him and say to Him, “Prophesy!” And the operatives started slapping Him. ");
INSERT INTO engf35_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Now as Peter was below in the courtyard, one of the servant girls of the high priest came by. ");
INSERT INTO engf35_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","And seeing Peter warming himself, she looked closely at him and said, “You too were with Jesus the Natsarene!” ");
INSERT INTO engf35_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","But Peter denied, saying, “I neither know nor understand what you are saying.” And he went out into the entryway, and a rooster crowed. ");
INSERT INTO engf35_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","But that servant girl saw him again and began to say to those standing by, “This guy is one of them.” ");
INSERT INTO engf35_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","But again he kept denying it. Again, after a little while, those who were standing by said to Peter, “Surely you are one of them; because you really are a Galilean, and your accent agrees!” ");
INSERT INTO engf35_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Then he began to curse and to swear, “I do not know this man of whom you are speaking!” ");
INSERT INTO engf35_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","And for the second time a rooster crowed. Then Peter remembered the word that Jesus had said to him, “Before a rooster crows twice, you will deny me three times.” He broke down and started to cry. ");
INSERT INTO engf35_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","As soon as it was early morning, having already formed a plan, the chief priests with the elders and scribes, indeed the whole council, bound Jesus, led Him away and handed Him over to Pilate. ");
INSERT INTO engf35_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate asked Him, “Are you the king of the Jews?” So in answer He said to him, “You stated a fact!” ");
INSERT INTO engf35_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","But the chief priests kept accusing Him of many things. ");
INSERT INTO engf35_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","So Pilate asked Him again, saying: “Are you not going to answer? See how many things they are testifying against you!” ");
INSERT INTO engf35_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","But Jesus still gave no answer, so that Pilate marveled. ");
INSERT INTO engf35_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Now at the feast he would release to them one prisoner, whomever they would request. ");
INSERT INTO engf35_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Well there was one called Barabbas, who had been bound with his fellow insurrectionists, who in the insurrection had committed murder. ");
INSERT INTO engf35_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Then the crowd began to call out and request that he do just as he always did for them. ");
INSERT INTO engf35_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","So Pilate answered them, saying, “Do you want me to release to you the king of the Jews?” ");
INSERT INTO engf35_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","(He knew that the chief priests had handed Him over because of envy.) ");
INSERT INTO engf35_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","But the chief priests stirred up the crowd, so that he should release Barabbas to them instead. ");
INSERT INTO engf35_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate answered and said to them again, “What then do you want me to do to him you call ‘king of the Jews’?” ");
INSERT INTO engf35_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Again they shouted, “Crucify him!” ");
INSERT INTO engf35_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","But Pilate said to them, “But what evil did he do?” They just yelled all the louder, “Crucify him!” ");
INSERT INTO engf35_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","So Pilate, wanting to gratify the crowd, released Barabbas to them, and Jesus, after a flogging, he handed over to be crucified. ");
INSERT INTO engf35_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Then the soldiers led Him away into the courtyard (that is, the Praetorium) and assembled the whole garrison. ");
INSERT INTO engf35_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","They clothed Him with purple, plaited a crown of thorns and put it on Him, ");
INSERT INTO engf35_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","and began to ‘acclaim’ Him by saying, “Hail, King of the Jews!” ");
INSERT INTO engf35_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","They kept hitting Him on the head with a rod and spitting on Him, and kneeling down they would ‘worship’ Him. ");
INSERT INTO engf35_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","When they had ridiculed Him, they took the purple off Him and put His own clothes on Him. Then they led Him out to crucify Him. ");
INSERT INTO engf35_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A certain passer-by, Simon a Cyrenian (the father of Alexander and Rufus), coming in from the countryside, was compelled to carry His cross. ");
INSERT INTO engf35_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","They brought Him to a place Golgotha, which is translated, ‘Place of a Skull’. ");
INSERT INTO engf35_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","They offered Him wine mixed with myrrh to drink, but He did not take it. ");
INSERT INTO engf35_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","After crucifying Him, they divided His clothes by casting lots for them, to see who would take what. ");
INSERT INTO engf35_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","It was the third hour when they crucified Him. ");
INSERT INTO engf35_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","The statement of His ‘crime’ that had been written was: THE KING OF THE JEWS. ");
INSERT INTO engf35_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","With Him they also crucified two bandits, one on His right and one on His left. ");
INSERT INTO engf35_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","So the Scripture was fulfilled which says, “And He was numbered with transgressors.” ");
INSERT INTO engf35_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Those who passed by kept ridiculing Him, wagging their heads and saying, “Hey! You who can destroy the temple and build it in three days, ");
INSERT INTO engf35_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","save yourself and come down from the cross!” ");
INSERT INTO engf35_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Similarly, the chief priests, with the scribes, kept mocking among themselves saying: “He saved others; he can't save himself! ");
INSERT INTO engf35_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Let the Christ, the king of Israel, descend now from the cross, that we may see and believe him.” Those who were crucified with Him insulted Him as well. ");
INSERT INTO engf35_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Now when the sixth hour had come noon, darkness came over the whole land until the ninth hour. ");
INSERT INTO engf35_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","At the ninth hour Jesus called out strongly, saying, “Eloi, Eloi, lima sabachthani?” which is translated, “O God, my God, why have You forsaken me?” ");
INSERT INTO engf35_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","When some of the bystanders heard it they said, “Listen, he's calling Elijah.” ");
INSERT INTO engf35_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Then someone ran, filled a sponge with wine vinegar, put it on a reed and started offering it to Him to drink, saying, “You let him be! ‘Let's see if Elijah is coming to take him down’!” ");
INSERT INTO engf35_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Then Jesus gave a loud shout and breathed out His spirit; ");
INSERT INTO engf35_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","and the veil of the temple was torn in two from top to bottom. ");
INSERT INTO engf35_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Well when the centurion, who was standing opposite Him, saw that He breathed out His spirit after giving such a loud shout, he said, “This man really was God's Son!” ");
INSERT INTO engf35_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","There were also women looking on from a distance, among whom were Mary Magdalene, Mary the mother of James the Less and of Joses, and Salome ");
INSERT INTO engf35_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","—they used to follow Him and minister to Him when He was in Galilee—and many other women who had come up with Him to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Now when evening had come, because it was Preparation Day (that is, the day before the Sabbath), ");
INSERT INTO engf35_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph of Arimathea, a prominent council member who also himself was waiting for the Kingdom of God, came and boldly went in to Pilate and asked for the body of Jesus. ");
INSERT INTO engf35_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Well Pilate was surprised that He was already dead; and summoning the centurion he asked him when He had died. ");
INSERT INTO engf35_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Upon the centurion's confirmation he granted the body to Joseph. ");
INSERT INTO engf35_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Having bought linen, he took Him down, wrapped Him in the linen and laid Him in a tomb that had been cut out of rock; then he rolled a stone against the door of the tomb. ");
INSERT INTO engf35_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene and Mary the mother of Joses observed where He was placed. ");
INSERT INTO engf35_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Now when the Sabbath was past, Mary Magdalene, Mary the mother of James, and Salome bought spices, in order to go and anoint Jesus. ");
INSERT INTO engf35_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Very early on the first day of the week, they came to the tomb when the sun had risen. ");
INSERT INTO engf35_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","And they were saying among themselves, “Who will roll away the stone from the door of the tomb for us?” ");
INSERT INTO engf35_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","(because it was very large), but when they looked up, they saw that the stone had been rolled away! ");
INSERT INTO engf35_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Upon entering the tomb they saw a young man dressed in a white robe sitting on the right side, and they were alarmed. ");
INSERT INTO engf35_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","But he said to them: “Don't be alarmed. You are looking for Jesus the Natsarene, who was crucified. He has risen! He isn't here! See, the place where they laid Him. ");
INSERT INTO engf35_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","But go, tell His disciples, also Peter: ‘He is going before you into Galilee; there you will see Him, as He said to you.’ ” ");
INSERT INTO engf35_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Trembling and bewildered they went out and fled from the tomb; and they said nothing to anyone, because they were afraid. ");
INSERT INTO engf35_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Having risen early on the first day of the week, Jesus appeared first to Mary Magdalene, out of whom He had cast seven demons. ");
INSERT INTO engf35_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","She went and reported to those who had been with Him, as they were mourning and weeping. ");
INSERT INTO engf35_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","When they heard that He was alive and had been seen by her, they did not believe. ");
INSERT INTO engf35_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","After these things He appeared in a different form to two of them as they were walking, going into the country. ");
INSERT INTO engf35_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","So they returned and reported to the rest; neither did they believe them. ");
INSERT INTO engf35_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Later He appeared to the eleven as they were reclining at the table; and He rebuked their unbelief and hardness of heart, because they did not believe those who had seen Him after He had risen. ");
INSERT INTO engf35_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Then He said to them: “Go to the whole world and proclaim the Gospel to all creation. ");
INSERT INTO engf35_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","He who believes and is baptized will be saved; but he who does not believe will be condemned. ");
INSERT INTO engf35_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","And these signs will accompany those who believe: in my name they will cast out demons; they will speak with new languages; ");
INSERT INTO engf35_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","they will remove ‘snakes’; and if they drink anything deadly, it will not hurt them at all; they will lay hands on sick people, and they will get well.” ");
INSERT INTO engf35_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","So then, after the Lord had spoken to them, He was received up into heaven and sat down at God's right. ");
INSERT INTO engf35_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","And they went out and preached everywhere, the Lord working with them and confirming the message by the accompanying signs. Amen. ");
INSERT INTO engf35_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Given that many have undertaken to set in order a narrative concerning those things that really did take place among us, ");
INSERT INTO engf35_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","just as those who became eyewitnesses, from the beginning, and ministers of the Word delivered them to us, ");
INSERT INTO engf35_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","it seemed good to me also, most excellent Theophilus, having taken careful note of everything from Above, to write to you with precision and in sequence, ");
INSERT INTO engf35_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","so that you may know the certainty of the things in which you were instructed. ");
INSERT INTO engf35_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","In the days of Herod, the king of Judea, there was a certain priest named Zacharias, of the priestly division of Abijah. His wife was of the daughters of Aaron and her name was Elizabeth. ");
INSERT INTO engf35_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","They were both righteous before God, walking blamelessly in all the commandments and ordinances of the Lord. ");
INSERT INTO engf35_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","But they had no child, because Elizabeth was barren; and they both were well advanced in years. ");
INSERT INTO engf35_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Now it happened, as he was officiating as priest before God in the order of his division, ");
INSERT INTO engf35_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","according to the custom of the priesthood, that his lot was to burn incense, upon entering the sanctuary of the Lord; ");
INSERT INTO engf35_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","and the whole multitude of the people was praying outside at the hour of incense. ");
INSERT INTO engf35_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Then an angel of the Lord appeared to him, standing at the right side of the altar of incense; ");
INSERT INTO engf35_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","and upon seeing him Zacharias was shaken, and a fear fell upon him. ");
INSERT INTO engf35_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","But the angel said to him: “Do not be afraid, Zacharias, because your prayer was heard, and your wife Elizabeth will bear you a son, and you shall call his name John. ");
INSERT INTO engf35_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","And you will have joy and exultation, and many will rejoice over his birth. ");
INSERT INTO engf35_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","For he will be great in the sight of the Lord; he must not drink either wine or strong drink; indeed, he will be filled with Holy Spirit already from his mother's womb. ");
INSERT INTO engf35_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","And he will turn many of the children of Israel to the Lord their God; ");
INSERT INTO engf35_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","in fact he himself will go before Him in the spirit and power of Elijah, ‘to turn the hearts of fathers to children’ and the disobedient to the mindset of the righteous, to prepare a people made ready for the Lord.” ");
INSERT INTO engf35_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","But Zacharias said to the angel: “How can I be sure of this? For I am an old man, and my wife is well advanced in years.” ");
INSERT INTO engf35_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","So in answer the angel said to him: “I am Gabriel, who stands in the presence of God; I was sent to speak to you and bring you this good news. ");
INSERT INTO engf35_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Now look, you will be silent and not able to speak until the day in which these things happen, because you did not believe my words, which will be fulfilled in their proper time.” ");
INSERT INTO engf35_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Now the people were waiting for Zacharias and wondering at his delay in the sanctuary. ");
INSERT INTO engf35_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","But when he came out he was unable to speak to them, and they understood that he had seen a vision in the sanctuary—he kept gesturing to them while remaining mute. ");
INSERT INTO engf35_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","And so, when the days of his service were fulfilled, he took off for home. ");
INSERT INTO engf35_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Well after those days his wife Elizabeth became pregnant and stayed in seclusion five months. She kept saying, ");
INSERT INTO engf35_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“So that's what the Lord has done for me in the days when He concerned Himself to take away my reproach among the people!” ");
INSERT INTO engf35_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Now in the sixth month the angel Gabriel was sent by God to a town of Galilee named Natsareth, ");
INSERT INTO engf35_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","to a virgin betrothed to a man whose name was Joseph, of the house of David; the virgin's name was Mary. ");
INSERT INTO engf35_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","So upon entering where she was the angel said, “Rejoice, recipient of grace, the Lord is with you; blessed are you among women!” ");
INSERT INTO engf35_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","But upon seeing him she was perplexed at his word and was trying to figure out what sort of greeting it might be. ");
INSERT INTO engf35_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","The angel said to her: “Do not be afraid, Mary, because you have found favor with God. ");
INSERT INTO engf35_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Now then, you will conceive in your womb and give birth to a Son, and you shall call His name JESUS. ");
INSERT INTO engf35_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","He will be great, and will be called ‘Son of the Most High’; and the Lord God will give Him the throne of His father David, ");
INSERT INTO engf35_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","and He will reign over the house of Jacob into the ages; indeed, of His kingdom there will be no end!” ");
INSERT INTO engf35_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","So Mary said to the angel, “How shall this be, since I do not know a man?” ");
INSERT INTO engf35_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","In answer the angel said to her: “Holy Spirit will come upon you and the power of the Most High will hover over you; precisely for this reason the holy One who is to be born will be called ‘Son of God’! ");
INSERT INTO engf35_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Furthermore, your relative Elizabeth, she has actually conceived a son in her old age and this is now the sixth month for her who was called barren; ");
INSERT INTO engf35_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","because any word spoken by God will be possible.” ");
INSERT INTO engf35_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","So Mary said: “Yes, I am the Lord's slave! Let it happen to me according to your word.” And the angel departed from her. ");
INSERT INTO engf35_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Then Mary quickly got ready and went into the hill country in those days, to a town of Judah, ");
INSERT INTO engf35_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","and entered the house of Zacharias and saluted Elizabeth. ");
INSERT INTO engf35_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Well it happened that as Elizabeth heard Mary's salutation the babe bounced up and down in her womb, and Elizabeth was filled with Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","And she cried out with a great voice and said: “Blessed are you among women, and blessed is the Fruit of your womb! ");
INSERT INTO engf35_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Why am I so favored that the mother of my Lord should come to me? ");
INSERT INTO engf35_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yes indeed, because as the sound of your salutation came into my ears the babe bounced up and down in my womb for joy. ");
INSERT INTO engf35_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blessed is she who believed, because there will be a fulfillment of the things that have been spoken to her from the Lord.” ");
INSERT INTO engf35_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","So Mary said: “My soul magnifies the Lord, ");
INSERT INTO engf35_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","and my spirit has exulted over God my Savior, ");
INSERT INTO engf35_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","in that He paid attention to the humble station of His slave (f). Yes indeed, because from now on all generations will declare me to be highly favored, ");
INSERT INTO engf35_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","in that the Mighty One did sublime things for me, and Holy is His name. ");
INSERT INTO engf35_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","His mercy is for generations of generations to those fearing Him. ");
INSERT INTO engf35_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","He has done mighty deeds with His arm; He has dispersed the arrogant in the reasoning of their hearts. ");
INSERT INTO engf35_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","He has dethroned rulers and exalted the lowly. ");
INSERT INTO engf35_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","He has filled the hungry with good things and sent the rich away empty. ");
INSERT INTO engf35_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","He has taken the part of His servant Israel, in remembrance of mercy, ");
INSERT INTO engf35_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","just as He spoke to our fathers, to Abraham and to his seed while there is an age.” ");
INSERT INTO engf35_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","So Mary stayed with her about three months, and returned to her house. ");
INSERT INTO engf35_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Now the time for Elizabeth to give birth was completed and she bore a son. ");
INSERT INTO engf35_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Her neighbors and relatives heard that the Lord had used His great mercy with her, and they rejoiced with her. ");
INSERT INTO engf35_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","So it was, on the eighth day, that they came to circumcise the child, and they started calling him by the name of his father, Zacharias. ");
INSERT INTO engf35_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","His mother reacted and said, “Absolutely not; he shall be called John!” ");
INSERT INTO engf35_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","So they said to her, “There is no one among your relatives who is called by this name.” ");
INSERT INTO engf35_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","So they started motioning to his father, as to what he would have him called. ");
INSERT INTO engf35_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Asking for a writing tablet he wrote this: “His name is to be John!” They all marveled. ");
INSERT INTO engf35_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Immediately his mouth was opened and his tongue freed and he started to speak, blessing God. ");
INSERT INTO engf35_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","(Well a fear came on all who lived around them; and all these sayings kept being talked about throughout all the hill country of Judea. ");
INSERT INTO engf35_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","All who heard kept them in their hearts saying, “What then will this child be?” And the hand of the Lord was with him.) ");
INSERT INTO engf35_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Now his father Zacharias was filled with Holy Spirit and prophesied saying: ");
INSERT INTO engf35_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Blessed be the Lord, the God of Israel, because He has visited and provided redemption for His people; ");
INSERT INTO engf35_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","and has raised up a horn of deliverance for us in the house of His servant David ");
INSERT INTO engf35_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","—just as He spoke through the mouth of His holy prophets from antiquity— ");
INSERT INTO engf35_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","deliverance from our enemies and out of the hand of all who hate us; ");
INSERT INTO engf35_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","to use mercy with our fathers, even to remember His Holy covenant, ");
INSERT INTO engf35_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","the oath that He swore to our father Abraham; ");
INSERT INTO engf35_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","to grant to us (having been rescued from the hand of our enemies) to serve Him without fear, ");
INSERT INTO engf35_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","in holiness and righteousness before Him all the days of our life. ");
INSERT INTO engf35_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","And you, child, will be called Prophet of the Most High, because you will go before the face of the Lord to prepare His ways, ");
INSERT INTO engf35_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","to give a knowledge of salvation to His people by the forgiveness of their sins, ");
INSERT INTO engf35_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","through the merciful compassions of our God, with which the divine Dawn has contemplated us, ");
INSERT INTO engf35_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","to give light to those who are sitting in darkness and the shadow of death, to guide our feet into the way of peace.” ");
INSERT INTO engf35_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","So the child kept growing and being strengthened in spirit, and he stayed in uninhabited areas until the day of his manifestation to Israel. ");
INSERT INTO engf35_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Now it happened in those days that a decree went out from Caesar Augustus that the whole inhabited world should be enrolled. ");
INSERT INTO engf35_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","This first census took place while Quirinius was governing Syria. ");
INSERT INTO engf35_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","So everyone was traveling, each to his own town, to enroll himself. ");
INSERT INTO engf35_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","So Joseph also went up from Galilee, out of Natsareth town, into Judea to the city of David, that is called Bethlehem, because he was of David's ‘house’, that is, line of descent, ");
INSERT INTO engf35_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","to enroll himself with Mary, the woman who had been betrothed to him, who was pregnant. ");
INSERT INTO engf35_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","So it happened that when they got there the days for her to give birth were completed; ");
INSERT INTO engf35_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","and she gave birth to her firstborn Son, wrapped Him in pieces of cloth and laid Him in the manger, because there was no room for them in the lodging place. ");
INSERT INTO engf35_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Now there were shepherds in that same area, staying out in the field and keeping the nightly watches over their flock. ");
INSERT INTO engf35_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","When wow, an angel of the Lord stood before them, and the glory of the Lord shone around them, and they were terrified. ");
INSERT INTO engf35_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","The angel said to them: “Do not be afraid because listen, I am announcing the most joyful news to you, which will be to all the people! ");
INSERT INTO engf35_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","You see, today, in David's city, a Savior was born to you, who is Lord Christ! ");
INSERT INTO engf35_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","And this is the sign to you: you will find a Baby wrapped in pieces of cloth, lying in a manger.” ");
INSERT INTO engf35_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Suddenly a multitude of the heavenly army was with the angel praising God and saying, ");
INSERT INTO engf35_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glory to God in the highest and on earth peace, good will toward mankind!” ");
INSERT INTO engf35_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","So when the angels went away from them into the sky the men, the shepherds, said to one another, “Hey, let's go to Bethlehem and see this event that has taken place, that the Lord made known to us!” ");
INSERT INTO engf35_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","So they went in a hurry and located both Mary and Joseph, and the Baby lying in the manger. ");
INSERT INTO engf35_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","And having seen they spread an exact account of the saying that had been spoken to them concerning this Child. ");
INSERT INTO engf35_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","All who heard marveled at the things told them by the shepherds. ");
INSERT INTO engf35_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","As for Mary, she treasured all these sayings, pondering them in her heart. ");
INSERT INTO engf35_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","The shepherds returned, glorifying and praising God over all that they had heard and seen, just as it was told them. ");
INSERT INTO engf35_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","When eight days were completed so as to circumcise Him, His name was indeed called JESUS, the name given by the angel before He was conceived in the womb. ");
INSERT INTO engf35_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","And when the days of their purification according to the law of Moses were completed, they took Him to Jerusalem to present Him to the Lord ");
INSERT INTO engf35_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(just as it is written in the law of the Lord, “Every male who opens a womb shall be called holy to the Lord”), ");
INSERT INTO engf35_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","and to offer a sacrifice according to what was specified in the Lord's Law, “a pair of turtledoves or two young pigeons”. ");
INSERT INTO engf35_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Well now, there was a man in Jerusalem whose name was Simeon; this man was righteous and devout, expectantly waiting for the Consolation of Israel, and Holy Spirit was upon him. ");
INSERT INTO engf35_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","(It had been revealed to him repeatedly by the Holy Spirit that he would not see death until he saw the Lord's Messiah.) ");
INSERT INTO engf35_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","So by the Spirit he came into the temple; and when the parents brought the Child Jesus in, to do concerning Him according to the custom of the law, ");
INSERT INTO engf35_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon took Him into his arms and blessed God and said: ");
INSERT INTO engf35_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sovereign, now You can release your slave in peace, according to Your word, ");
INSERT INTO engf35_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","because my eyes have seen Your salvation, ");
INSERT INTO engf35_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","which You have prepared before the face of all peoples: ");
INSERT INTO engf35_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","a light for revelation to Gentiles, and the glory of Your people Israel.” ");
INSERT INTO engf35_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","And Joseph and His mother were marveling at the things being spoken concerning Him. ");
INSERT INTO engf35_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Then Simeon blessed them, and said to Mary His mother: “Listen, this One is appointed to bring about the fall and rising of many in Israel, and to be a sign that is spoken against, ");
INSERT INTO engf35_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","so that the reasonings of many hearts may be revealed (furthermore, a sword will pass through your own soul also).” ");
INSERT INTO engf35_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Also there was a prophetess Anna, a daughter of Phanuel, of the tribe of Asher—she was of a great age, having lived with a husband seven years from her virginity ");
INSERT INTO engf35_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","and having been a widow for about eighty-four years—who did not depart from the temple, serving God with fastings and petitions night and day. ");
INSERT INTO engf35_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Well she, having come up at that very moment, started praising the Lord, and kept on speaking of Him to all those in Jerusalem who were looking for redemption. ");
INSERT INTO engf35_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","When they had completed everything, according to the law of the Lord, they went back to Galilee, to their own town, Natsareth. ");
INSERT INTO engf35_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","And the Child kept growing and being strengthened in spirit, being filled with wisdom; yes, the grace of God was upon Him. ");
INSERT INTO engf35_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Now every year His parents would go to Jerusalem to the feast of the Passover; ");
INSERT INTO engf35_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","so when He was twelve years old they went up to Jerusalem according to the custom of the feast. ");
INSERT INTO engf35_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","When they had fulfilled the days, as they were returning, the boy Jesus stayed behind in Jerusalem, but Joseph and His mother did not know it. ");
INSERT INTO engf35_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Supposing Him to be in the caravan, they went a day's journey and then started looking for Him among their relatives and acquaintances. ");
INSERT INTO engf35_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Not finding Him, they returned to Jerusalem seeking Him. ");
INSERT INTO engf35_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","So it happened that after three days they found Him in the temple, sitting in the midst of the teachers, both listening to them and asking them questions. ");
INSERT INTO engf35_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","(All who heard Him were astonished at His understanding and answers.) ");
INSERT INTO engf35_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","So upon seeing Him they were amazed, and His mother said to Him: “Son, why have you treated us like this? Look, your father and I have been searching for you in distress.” ");
INSERT INTO engf35_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","So He said to them: “Why were you seeking me? Didn't you know that I must be about my Father's concerns?” ");
INSERT INTO engf35_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","But they did not understand the statement that He made to them. ");
INSERT INTO engf35_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Then He went down with them and came to Natsareth, and continued subordinating Himself to them; His mother kept all these sayings in her heart. ");
INSERT INTO engf35_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","And Jesus kept increasing in wisdom and stature, and in favor with God and men. ");
INSERT INTO engf35_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Now in the fifteenth year of the reign of Tiberius Caesar, Pontius Pilate being governor of Judea and Herod being tetrarch of Galilee, while his brother Philip was tetrarch of the region of Iturea and Trachonitis and Lysanias tetrarch of Abilene, ");
INSERT INTO engf35_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","during the high priesthood of Annas (also Caiaphas), the word of God came upon John the son of Zacharias in the wilderness. ");
INSERT INTO engf35_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","So he went into all the region around the Jordan, proclaiming a baptism of repentance for forgiveness of sins; ");
INSERT INTO engf35_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","as it is written in the book of the words of Isaiah the prophet, saying: “A voice calling out: ‘Prepare the way of the Lord in the wilderness, make His paths straight. ");
INSERT INTO engf35_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Every ravine will be filled up, and every mountain and hill will be leveled; the crooked parts of the roads will be straightened out, and the rough parts will be smoothed out; ");
INSERT INTO engf35_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","and all flesh will see the salvation of God.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Then he said to the crowds that were coming out to be baptized by him: “You sons of poisonous snakes! Who tipped you off to flee from the coming wrath? ");
INSERT INTO engf35_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Well then, produce fruits befitting repentance, and don't even begin to say among yourselves, ‘We have Abraham as father,’ because I say to you that God is able to raise up children to Abraham from these stones! ");
INSERT INTO engf35_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","But even now the axe is being laid to the root of the trees; so then, every tree not producing good fruit is cut down and thrown into the fire.” ");
INSERT INTO engf35_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","So the people started asking him, “What then must we do?” ");
INSERT INTO engf35_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","In answer he said to them, “He who has two coats, let him share with him who has none; and he who has food should do likewise.” ");
INSERT INTO engf35_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Well even tax collectors came to be baptized by him and said to him, “Teacher, what must we do?” ");
INSERT INTO engf35_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","So He said to them, “Don't charge more than what was determined to you.” ");
INSERT INTO engf35_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","So the soldiers started asking him too: “What about us? What must we do?” He said to them, “Don't extort or harass anyone, and be content with your wages.” ");
INSERT INTO engf35_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Now as the people were expectant and all were reasoning in their hearts concerning John, whether he just might be the Messiah, ");
INSERT INTO engf35_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John anticipated them all saying: “I indeed am baptizing you with water, but One mightier than I is coming, whose sandal straps I am not worthy to untie. He will baptize you with Holy Spirit and fire; ");
INSERT INTO engf35_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","whose winnowing shovel is in His hand, and He will thoroughly clean out His threshing floor and gather the wheat into His barn, but He will burn up the chaff with unquenchable fire.” ");
INSERT INTO engf35_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","(Indeed, with many other exhortations as well he kept on preaching to the people; ");
INSERT INTO engf35_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","but Herod the tetrarch—being reproved by him concerning Herodias, his brother's wife, as also about all the wicked things that Herod perpetrated— ");
INSERT INTO engf35_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","added this also to them all: he actually locked John up in his prison.) ");
INSERT INTO engf35_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Now when all the people were baptized, Jesus, having been baptized also, was praying, when the heaven was opened ");
INSERT INTO engf35_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","and the Holy Spirit descended in bodily form like a dove and rested upon Him, and a Voice came out of heaven saying, “You are my beloved Son; in you I am always well pleased.” ");
INSERT INTO engf35_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","(Beginning His ministry at about thirty years of age, being (so it was supposed) a son of Joseph, Jesus Himself was of Eli, ");
INSERT INTO engf35_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","of Matthan, of Levi, of Melchi, of Janna, of Joseph, ");
INSERT INTO engf35_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","of Mattathiah, of Amos, of Nahum, of Esli, of Naggai, ");
INSERT INTO engf35_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","of Maath, of Mattathiah, of Semei, of Joseph, of Judah, ");
INSERT INTO engf35_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","of Joannan, of Rhesa, of Zerubbabel, of Shealtiel, of Neri, ");
INSERT INTO engf35_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","of Melchi, of Addi, of Cosam, of Elmodam, of Er, ");
INSERT INTO engf35_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","of Jose, of Eliezer, of Jorim, of Matthat, of Levi, ");
INSERT INTO engf35_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","of Simeon, of Judah, of Joseph, of Jonam, of Eliakim, ");
INSERT INTO engf35_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","of Melea, of Menan, of Mattatha, of Nathan, of David, ");
INSERT INTO engf35_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","of Jesse, of Obed, of Boaz, of Salmon, of Nahshon, ");
INSERT INTO engf35_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","of Amminadab, of Aram, of Joram, of Hezron, of Perez, of Judah, ");
INSERT INTO engf35_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","of Jacob, of Isaac, of Abraham, of Terah, of Nahor, ");
INSERT INTO engf35_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","of Serug, of Reu, of Peleg, of Eber, of Shela, ");
INSERT INTO engf35_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","of Cainan, of Arphaxad, of Shem, of Noah, of Lamech, ");
INSERT INTO engf35_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","of Methuselah, of Enoch, of Jared, of Mahalaleel, of Cainan, ");
INSERT INTO engf35_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","of Enosh, of Seth, of Adam, of God.) ");
INSERT INTO engf35_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Then Jesus, full of Holy Spirit, returned from the Jordan and was led by the Spirit into the wilderness, ");
INSERT INTO engf35_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","where He was tested for forty days by the devil. He ate nothing at all during those days, so after they were completed He was hungry. ");
INSERT INTO engf35_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","So the devil said to Him, “Since you are Son of God, tell this stone to become bread!” ");
INSERT INTO engf35_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus answered him saying, “It is written: ‘Man shall not live by bread alone, but by every word of God.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","And taking Him up on a high mountain, the devil showed Him all the kingdoms of the world in a moment of time. ");
INSERT INTO engf35_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","The devil said to Him: “To you I will give all this authority, and their glory, because it has been handed over to me, and I give it to whomever I want to. ");
INSERT INTO engf35_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","So you, if you would worship before me, all will be yours.” ");
INSERT INTO engf35_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","In answer Jesus said to him: “Get behind me, Satan! It is written, ‘You shall worship the Lord your God, and Him only shall you serve!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","He also took Him to Jerusalem and set Him on the pinnacle of the temple, and said to Him: “Since you are Son of God, throw yourself down from here; ");
INSERT INTO engf35_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","because it is written, ‘He will give His angels orders concerning you, to protect you,’ ");
INSERT INTO engf35_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","and, ‘They will carry you along on their hands, so you do not stub your foot on a stone.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","In answer Jesus said to him: “The statement stands, ‘You shall not test the Lord your God!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Having finished every test, the devil departed from Him until an opportune time. ");
INSERT INTO engf35_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus returned in the power of the Spirit into Galilee, and news about Him spread throughout the whole surrounding area; ");
INSERT INTO engf35_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","yes, He started teaching in their synagogues, being glorified by all. ");
INSERT INTO engf35_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","So He came to Natsareth, where He had been brought up; as was His custom He went into the synagogue on the Sabbath day, and stood up to read. ");
INSERT INTO engf35_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","The book of the prophet Isaiah was handed to him, so unrolling the scroll He found the place where it was written: ");
INSERT INTO engf35_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“The Spirit of the Lord is upon me, because He has anointed me to evangelize poor people. He has sent me to heal the brokenhearted, to proclaim release to captives and recovery of sight to blind people, to send those who are oppressed out in freedom, ");
INSERT INTO engf35_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","to proclaim the Lord's favorable year.” ");
INSERT INTO engf35_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Then, having rolled up the scroll and returned it to the attendant, He sat down. The eyes of everyone in the synagogue were fastened on Him, ");
INSERT INTO engf35_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","and He began by saying to them, “Today, this Scripture in your ears has been fulfilled.” ");
INSERT INTO engf35_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","(All were bearing witness to Him and were marveling at the gracious words that were coming out of His mouth; and they started saying, “Isn't this the son of Joseph?”) ");
INSERT INTO engf35_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","He said to them: “Doubtless you will quote this parable to me: ‘Physician, heal yourself!’—do here in your hometown the things we have heard were done in Capernaum.” ");
INSERT INTO engf35_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Then He said: “Assuredly I say to you, no prophet is welcome in his hometown. ");
INSERT INTO engf35_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Further, I can assure you that there were many widows in Israel in the days of Elijah, when the sky was shut for three years and six months and a severe famine came over all the land; ");
INSERT INTO engf35_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yet Elijah was not sent to any of them, but to a widow woman in Sarepta, near Sidon. ");
INSERT INTO engf35_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","And there were many lepers in Israel in the time of the prophet Elisha, yet not one of them was cleansed—just Naaman the Syrian.” ");
INSERT INTO engf35_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Well, upon hearing these things everyone in the synagogue was filled with fury, ");
INSERT INTO engf35_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","and rising up they drove Him out of the town and took Him to the brow of the hill on which the town was built, in order to throw Him off the cliff. ");
INSERT INTO engf35_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","But He, passing through the middle of them, went on His way. ");
INSERT INTO engf35_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Then He went down to Capernaum, a town in Galilee; He started teaching them on the Sabbaths. ");
INSERT INTO engf35_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","They kept on being amazed at His teaching, because His word was with authority. ");
INSERT INTO engf35_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Now in the synagogue was a man having a spirit of an unclean demon; he cried out with a loud voice ");
INSERT INTO engf35_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","saying: “Ugh! What do you want with us, Jesus of Natsareth? Did you come to destroy us? I know who you are, the Holy One of God!” ");
INSERT INTO engf35_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","So Jesus rebuked him saying, “Be muzzled, and get out of him!” When the demon had thrown him down in the midst, it came out of him without harming him. ");
INSERT INTO engf35_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Everyone was taken with amazement and they started conversing together, saying: “What is this word! For with authority and power he commands the unclean spirits, and they come out!” ");
INSERT INTO engf35_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","And the news about Him started going out to every place of the surrounding region. ");
INSERT INTO engf35_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Then He left the synagogue and entered Simon's house. But Simon's mother-in-law was suffering with a high fever, and they requested Him on her behalf. ");
INSERT INTO engf35_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","So He stood over her and rebuked the fever, and it left her. Immediately she got up and began to serve them. ");
INSERT INTO engf35_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Now when the sun was setting, all those who had any who were sick with various diseases brought them to Him; and He laid His hands on each one of them and healed them. ");
INSERT INTO engf35_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Moreover, demons came out of many, crying out and saying, “You are the Christ, the Son of God!” But rebuking them He would not allow them to continue speaking, because they knew that He was the Messiah. ");
INSERT INTO engf35_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Now at daybreak He departed and went to a deserted place; so the crowds started looking for Him and came to Him, and tried to keep Him from leaving them. ");
INSERT INTO engf35_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","But He said to them, “I must proclaim the good news of the Kingdom of God to the other towns also, because for this purpose I have been sent.” ");
INSERT INTO engf35_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","So He went preaching in the synagogues of Galilee. ");
INSERT INTO engf35_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Now it happened, as He had come along the Lake of Genesaret, that the multitude crowded Him to hear the Word of God; ");
INSERT INTO engf35_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","He saw two boats standing by the lake (the fishermen were out of them, washing their nets). ");
INSERT INTO engf35_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","So He got into one of the boats, which was Simon's, and asked him to put out a little from the land. Sitting down He began to teach the crowds from the boat. ");
INSERT INTO engf35_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","When He had finished speaking, He said to Simon, “Put out into the deep and let down your nets for a catch.” ");
INSERT INTO engf35_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","And in answer Simon said to Him, “Master, we have worked hard the whole night and caught nothing, but based on your word I will let down the net.” ");
INSERT INTO engf35_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","When they had done this, they caught such a large number of fish that their net began to tear. ");
INSERT INTO engf35_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","So they signaled to their partners who were in the other boat to come help them; they came and filled both the boats, so that they began to sink. ");
INSERT INTO engf35_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Upon experiencing this Simon Peter fell at Jesus' knees, saying, “Depart from me, Lord, for I am a sinful man!” ");
INSERT INTO engf35_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Because astonishment gripped him and all who were with him at the haul of fish which they had caught; ");
INSERT INTO engf35_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","yes, this included James and John, sons of Zebedee, who were partners with Simon. Then Jesus said to Simon, “Don't be afraid; from now on you will be catching people.” ");
INSERT INTO engf35_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pulling the boats up on the shore, they left it all and followed Him. ");
INSERT INTO engf35_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Now it happened, while He was in one of the towns—a man full of leprosy! Upon seeing Jesus he fell on his face and begged Him, saying, “Lord, if you want to, you can cleanse me!” ");
INSERT INTO engf35_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","So He extended His hand and touched him, saying, “I want to; be cleansed!” Immediately the leprosy left him. ");
INSERT INTO engf35_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Then He ordered him to tell no one, “But go and show yourself to the priest and make an offering for your cleansing just as Moses prescribed, as a testimony to them.” ");
INSERT INTO engf35_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","However the news about Him spread all the more, and large crowds kept gathering to hear and to be healed by Him of their sicknesses. ");
INSERT INTO engf35_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","So He Himself would withdraw into deserted places and pray. ");
INSERT INTO engf35_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Now it happened on a certain day that He was teaching, and there were Pharisees and teachers of the law, who had come from every village of Galilee, and from Judea and Jerusalem, sitting there—and the power of the Lord was there to heal them. ");
INSERT INTO engf35_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","And then, some men came carrying a paralyzed man on a cot, and tried to take him in and place him before Him. ");
INSERT INTO engf35_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","When they could not find how to do it, because of the crowd, they went up on the roof and lowered him with the cot through the tiling into the center, in front of Jesus. ");
INSERT INTO engf35_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Seeing their faith He said to him, “Man, your sins are forgiven you!” ");
INSERT INTO engf35_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","So the scribes and the Pharisees began to reason, saying: “Who is this who speaks blasphemies? Who can forgive sins but God alone?” ");
INSERT INTO engf35_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","But Jesus perceived their reasonings and reacted by saying to them: “Why are you reasoning in your hearts? ");
INSERT INTO engf35_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Which is easier to say, ‘Your sins are forgiven you’, or to say, ‘Get up and walk!’? ");
INSERT INTO engf35_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","But that you may know that the Son of the Man has authority on earth to forgive sins”—He said to the paralyzed man: “I say to you, get up! Take your cot and go to your house.” ");
INSERT INTO engf35_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Immediately he stood up in front of them, took up what he had been lying on, and set out to his own house glorifying God. ");
INSERT INTO engf35_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amazement gripped them all and they kept glorifying God; they were also filled with fear, saying, “We have seen strange things today!” ");
INSERT INTO engf35_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","After these things He went out and saw a tax collector named Levi sitting at the tax office; and He said to him, “Follow me!” ");
INSERT INTO engf35_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","So leaving everything he got up and followed Him. ");
INSERT INTO engf35_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Then Levi made a great banquet for Him at his house; and there was a large crowd of tax collectors and others who were reclining with them. ");
INSERT INTO engf35_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Well the scribes and Pharisees complained about them to His disciples, saying, “How can you eat and drink with the tax collectors and sinners?!” ");
INSERT INTO engf35_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","So Jesus reacted and said to them: “Those who are healthy have no need of a physician, just those who are sick. ");
INSERT INTO engf35_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","I have not come to call righteous people to repentance, just sinners.” ");
INSERT INTO engf35_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Then they said to Him, “Why do the disciples of John fast often and make prayers, and likewise those of the Pharisees, but yours keep eating and drinking?” ");
INSERT INTO engf35_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","So He said to them: “Can you make the friends of the bridegroom fast while the bridegroom is with them? ");
INSERT INTO engf35_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","But days are coming when the bridegroom will be taken away from them; then, in those days, they will fast.” ");
INSERT INTO engf35_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Then He also told them a parable: “No one puts a patch from a new garment on an old one; otherwise, both the new makes a tear and that from the new does not match the old. ");
INSERT INTO engf35_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","And no one puts new wine into old wineskins; otherwise the new wine will burst those skins and will itself be spilled and the skins wasted. ");
INSERT INTO engf35_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Rather, new wine must be put into new wineskins, and both are preserved. ");
INSERT INTO engf35_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Further, no one having drunk old wine immediately desires new, for he says, ‘The old is better.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Now it happened on a second-first Sabbath that He was passing through the grain fields, and His disciples began to pick and eat the heads of grain, rubbing them in their hands. ");
INSERT INTO engf35_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","But some of the Pharisees said to them, “Why are you doing that which is not lawful to do on the Sabbath?” ");
INSERT INTO engf35_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","So in answer to them Jesus said: “Have you not even read this, what David did when he was hungry, he and those who were with him: ");
INSERT INTO engf35_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","how he went into the house of God, took and ate the showbread, and even gave it to those with him—that which only the priests are allowed to eat?” ");
INSERT INTO engf35_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Then He said to them, “The Son of the Man is Lord even of the Sabbath!” ");
INSERT INTO engf35_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Now it happened on a different Sabbath that He entered the synagogue and began to teach. Well there was a man there whose right hand was shriveled; ");
INSERT INTO engf35_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","so the scribes and the Pharisees started watching, to see if He would heal on the Sabbath, so that they might find an accusation against Him. ");
INSERT INTO engf35_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","But He knew their thoughts and said to the man with the shriveled hand, “Get up and stand in the center.” So he got up and stood. ");
INSERT INTO engf35_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Then Jesus said to them: “I will ask you something: Is it lawful on the Sabbath to do good or to do evil, to save life or to kill?” ");
INSERT INTO engf35_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","And when He had looked around at them all, He said to him, “Stretch out your hand!” So he did that, and his hand was restored, as sound as the other. ");
INSERT INTO engf35_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","But they were filled with rage, and began to discuss with one another what they might do to Jesus. ");
INSERT INTO engf35_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Now it happened in those days that He went out to the mountain to pray, and He continued all night in prayer to God. ");
INSERT INTO engf35_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","When it was day He called His disciples, and from them He chose twelve, whom He also named apostles: ");
INSERT INTO engf35_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (whom He also named Peter) and Andrew his brother, James and John, Phillip and Bartholomew, ");
INSERT INTO engf35_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew and Thomas, James (the son of Alphaeus) and Simon (the one called ‘Zealot’), ");
INSERT INTO engf35_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas of James and Judas Iscariot (who also became ‘traitor’). ");
INSERT INTO engf35_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Then He came down with them and stood on a level place, with a crowd of His disciples and a great multitude of people from all Judea and Jerusalem, also from the seacoast of Tyre and Sidon, who came to hear Him and to be healed of their diseases, ");
INSERT INTO engf35_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","as well as those who were being harassed by unclean spirits—and they were being healed! ");
INSERT INTO engf35_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","So the whole crowd kept trying to touch Him, because power was going out from Him and was healing all. ");
INSERT INTO engf35_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Then He raised His eyes toward His disciples and said: “Blessed are you poor, because the Kingdom of God is yours. ");
INSERT INTO engf35_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blessed are you who hunger now, because you will be filled. Blessed are you who weep now, because you will laugh. ");
INSERT INTO engf35_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blessed are you whenever men hate you, and whenever they exclude you and heap insults on you and trash your name as ‘malignant’, for the Son of the Man's sake. ");
INSERT INTO engf35_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rejoice in that day and skip about! Because your reward really is great in Heaven; for that is how their fathers treated the prophets. ");
INSERT INTO engf35_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“But woe to you who are rich! because you have already received your comfort. ");
INSERT INTO engf35_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woe to you who are full! because you will go hungry. Woe to you who are presently laughing! because you will mourn and weep. ");
INSERT INTO engf35_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Woe, when all men speak well of you; for that is how their fathers treated the false prophets! ");
INSERT INTO engf35_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Further, to you who are listening I say: Love your enemies, do good to those who hate you; ");
INSERT INTO engf35_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bless those who curse you, pray for those who mistreat you. ");
INSERT INTO engf35_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","To him who strikes you on the cheek, offer also the other; and from him who takes away your cloak, do not withhold the tunic as well. ");
INSERT INTO engf35_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Give to everyone who asks of you; and from him who takes away your things, do not demand them back. ");
INSERT INTO engf35_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yes, like you want people to treat you, that is just how you must treat them. ");
INSERT INTO engf35_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Also, if you love those who love you, what credit is that to you? Even ‘sinners’ love those who love them. ");
INSERT INTO engf35_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","And if you do good to those doing good to you, what credit is that to you? Even ‘sinners’ do the same. ");
INSERT INTO engf35_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","And if you lend to those from whom you expect to get it back, what credit is that to you? Even ‘sinners’ lend to ‘sinners’, to receive an equal value back. ");
INSERT INTO engf35_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“So, love your enemies, and do good, and lend, expecting nothing back; and your reward will be great, and you will be sons of the Most High; because He is kind toward the ungrateful and wicked. ");
INSERT INTO engf35_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","So be compassionate, even as your Father is compassionate. ");
INSERT INTO engf35_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Do not judge, and you will not be judged. Do not condemn, and you will not be condemned. Forgive, and you will be forgiven. ");
INSERT INTO engf35_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Give and it will be given to you: a good measure—pressed down and shaken together and running over—will they deposit in your lap. Because with the same measure that you use it will be measured back to you.” ");
INSERT INTO engf35_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Then He told them a parable: “Can a blind man guide a blind man? Will they not both fall into a ditch? ");
INSERT INTO engf35_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A disciple is not above his teacher, but everyone who is fully trained will be like his teacher. ");
INSERT INTO engf35_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Why do you look at the speck in your brother's eye, but do not consider the plank that is in your own eye? ");
INSERT INTO engf35_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Or how can you say to your brother, ‘Brother, let me remove the speck that is in your eye,’ when you yourself do not see the plank that is in your own eye? Hypocrite! First remove the plank from your own eye, and then you will see clearly to remove the speck that is in your brother's eye. ");
INSERT INTO engf35_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Now no good tree produces rotten fruit, nor does a rotten tree produce good fruit ");
INSERT INTO engf35_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","—each tree is known by its own fruit: people do not gather figs from thorn bushes, nor do they pick a bunch of grapes from a bramble. ");
INSERT INTO engf35_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","The good man produces the good out of the good treasure in his heart, and the malignant man produces the malignant out of the malignant treasure in his heart; because his mouth speaks out of the abundance of the heart. ");
INSERT INTO engf35_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Why do you call me, ‘Lord, Lord’, and not do what I say? ");
INSERT INTO engf35_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Everyone who comes to me and hears my words and does them—I will show you who he is like: ");
INSERT INTO engf35_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","he is like a man building a house, who dug down deep and laid the foundation on the bedrock. When a flood occurred, the torrent burst upon that house but could not shake it, because it was founded on the bedrock. ");
INSERT INTO engf35_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","But he who heard and did nothing is like a man who built his house on the ground without a foundation, against which the torrent burst, and immediately it fell; and the ruin of that house was great.” ");
INSERT INTO engf35_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Now when He concluded all His sayings in the hearing of the people, He entered Capernaum. ");
INSERT INTO engf35_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Well a certain centurion's slave, who was valuable to him, was sick and about to die. ");
INSERT INTO engf35_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","So when he heard about Jesus, he sent elders of the Jews to Him, asking Him to come and rescue his slave. ");
INSERT INTO engf35_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","And when they came to Jesus they started pleading earnestly with Him, saying that the one for whom He would do this was worthy, ");
INSERT INTO engf35_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“Because he loves our nation, and he himself built our synagogue.” ");
INSERT INTO engf35_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","So Jesus went with them. But when He was no longer far from the house, the centurion sent friends to Him, saying to Him: “Lord, do not trouble yourself, for I am not worthy that you should come under my roof. ");
INSERT INTO engf35_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","In fact I did not even consider myself worthy to come to you. Just say a word and my servant will be healed; ");
INSERT INTO engf35_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","because I also am a man placed under authority, having soldiers under me. I say to one, ‘Go!’ and he goes; and to another, ‘Come!’ and he comes; and to my slave, ‘Do this!’ and he does.” ");
INSERT INTO engf35_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Well upon hearing these things Jesus marveled at him, and turning to the crowd following Him, He said, “I say to you, not even in Israel have I found such great faith!” ");
INSERT INTO engf35_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","When those who were sent returned to the house they found that the slave who had been sick was well. ");
INSERT INTO engf35_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Now it happened on the next day that He went to a town called Nain, and many of His disciples went with Him, also a large crowd. ");
INSERT INTO engf35_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","But as He approached the town gate, mercy, a dead man was being carried out, the only son of his mother, and she was a widow; a large crowd from the town was with her. ");
INSERT INTO engf35_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","When the Lord saw her He had compassion on her and said to her, “Don't cry!” ");
INSERT INTO engf35_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","And advancing He took hold of the bier and the bearers stood still. Then He said, “Young man, to you I say, get up!” ");
INSERT INTO engf35_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","So the dead man sat up and began to talk! Yes, He gave him back to his mother. ");
INSERT INTO engf35_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fear took hold of all, and they began glorifying God, saying, “A great prophet has arisen among us!” and, “God has visited His people!” ");
INSERT INTO engf35_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","And this report about Him went throughout Judea, as well as all the surrounding region. ");
INSERT INTO engf35_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Then the disciples of John informed him about all these things. ");
INSERT INTO engf35_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","And summoning a certain two of his disciples, John sent them to Jesus, saying, “Are you the Coming One, or should we look for another?” ");
INSERT INTO engf35_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","When the men had come to Him, they said: “John the Baptizer has sent us to you, saying, ‘Are you the Coming One, or should we look for another?’ ” ");
INSERT INTO engf35_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Well in that very hour He healed many from diseases and torments and malignant spirits, and to many blind He granted sight. ");
INSERT INTO engf35_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","So in answer Jesus said to them: “Go and report to John the things you have seen and heard: that the blind regain sight, the lame walk, lepers are cleansed, the deaf hear, dead are raised, the poor are evangelized. ");
INSERT INTO engf35_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","And, blessed is he who does not take offense at me!” ");
INSERT INTO engf35_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Now when John's messengers had departed, He began to speak to the crowds about John: “What did you go out into the wilderness to observe, a reed being shaken by the wind? ");
INSERT INTO engf35_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","But what did you go out to see, a man clothed in soft garments? Really, those with gorgeous apparel and living in luxury are in palaces. ");
INSERT INTO engf35_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","But what did you go out to see, a prophet? Yes, I say to you, and much more than a prophet. ");
INSERT INTO engf35_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","This is he about whom it is written: ‘Take note, I am sending my messenger before your face, who will prepare your way before you.’ ");
INSERT INTO engf35_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Further, I tell you that among those born of women there is no greater prophet than John the Baptizer; yet he who is least in the Kingdom of God is greater than he.” ");
INSERT INTO engf35_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(When all the people, including the tax collectors, heard this, they declared God to be just, having been baptized with John's baptism. ");
INSERT INTO engf35_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","But the Pharisees and the lawyers rejected the counsel of God for themselves, not having been baptized by him.) ");
INSERT INTO engf35_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“To what then shall I compare the men of this generation, and to what are they similar? ");
INSERT INTO engf35_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","They are like children sitting in the marketplace and calling to one another, saying, ‘We played the flute for you, and you did not dance; we mourned to you, and you did not cry.’ ");
INSERT INTO engf35_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Because John the Baptizer came neither eating bread nor drinking wine, and you say, ‘He has a demon!’ ");
INSERT INTO engf35_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","The Son of the Man has come eating and drinking, and you say, ‘Just look, a glutton and a drunkard, a friend of tax collectors and sinners!’ ");
INSERT INTO engf35_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Still, by all her children wisdom is justified.” ");
INSERT INTO engf35_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Then one of the Pharisees invited Him to eat with Him, so He entered the Pharisee's house and reclined. ");
INSERT INTO engf35_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","But then, a woman in the town who was a sinner, when she found out that He was reclining in the Pharisee's house, she brought an alabaster flask of perfume, ");
INSERT INTO engf35_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","and as she stood behind Him at His feet weeping, she began to wet His feet with her tears and kept wiping them with the hair of her head; and she kept kissing His feet and anointing them with the perfume. ");
INSERT INTO engf35_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Now as the Pharisee who had invited Him observed this, he was saying to himself, “If this man were a prophet, he would know who is touching him, including what sort of woman she is—because she is a sinner!” ");
INSERT INTO engf35_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","So Jesus reacted by saying to him, “Simon, I have something to say to you.” And he said, “Teacher, say on.” ");
INSERT INTO engf35_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“A certain creditor had two debtors. One owed five hundred denarii, and the other fifty. ");
INSERT INTO engf35_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","And when they had no way to repay, he freely forgave them both. Now tell me, which of them will love him more?” ");
INSERT INTO engf35_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","So Simon answered and said, “I suppose the one to whom he forgave more.” And He said to him, “You have judged correctly.” ");
INSERT INTO engf35_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Then He turned toward the woman and said to Simon: “Do you see this woman? I entered your house; you gave me no water for my feet, but she has wet my feet with her tears and wiped them with the hair of her head. ");
INSERT INTO engf35_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","You gave me no kiss, but she has not stopped kissing my feet since the time I came in. ");
INSERT INTO engf35_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","You did not anoint my head with oil, but she has anointed my feet with perfume. ");
INSERT INTO engf35_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","For this reason, I say to you, her many sins have been forgiven, because she loved much; but to whom little is forgiven, the same loves little.” ");
INSERT INTO engf35_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Then He said to her, “Your sins are forgiven.” ");
INSERT INTO engf35_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","The other recliners began to say within themselves, “Who is this who even forgives sins?” ");
INSERT INTO engf35_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Then He said to the woman, “Your faith has saved you; go into peace.” ");
INSERT INTO engf35_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Now it happened after this that He started going around town by town, village by village, preaching and proclaiming the good news of the Kingdom of God, and the twelve were with Him; ");
INSERT INTO engf35_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","also certain women who had been healed of malignant spirits and infirmities: Mary (the one called Magdalene) from whom seven demons had gone out; ");
INSERT INTO engf35_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","and Joanna the wife of Chuza, an official of Herod; and Susanna, and many others—these were providing for Him from their substance. ");
INSERT INTO engf35_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Now when a large crowd had gathered, with people coming to Him from town after town, He spoke by a parable: ");
INSERT INTO engf35_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A sower went out to sow his seed; and as he sowed some fell along the road, and it got trampled, and the birds of the air devoured it. ");
INSERT INTO engf35_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","And some fell on the rock ledge, and upon sprouting it withered, because it had no moisture. ");
INSERT INTO engf35_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","And some fell among thorns, and springing up together the thorns choked it. ");
INSERT INTO engf35_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","The rest fell into the good ground, and growing up it produced fruit a hundredfold.” Upon saying these things He called out, “He who has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Then His disciples asked Him saying, “What does this parable mean?” ");
INSERT INTO engf35_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","So He said: “To you it has been given to know the mysteries of the Kingdom of God, but to the rest only in parables, so that ‘seeing they may not see, and hearing they may not understand.’ ");
INSERT INTO engf35_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Now here is the parable: The seed is the Word of God. ");
INSERT INTO engf35_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Those along the road are those who hear; then the devil comes and takes away the word from their hearts, in order that they not be saved, having believed. ");
INSERT INTO engf35_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Those on the rock ledge are the ones who, whenever they hear, receive the word with joy; yet these have no root, who believe for a while and in time of testing fall away. ");
INSERT INTO engf35_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Now that which fell into the thorns: these are the ones who heard, yet as they go they are choked by cares, riches, and pleasures of life, and bring no fruit to maturity. ");
INSERT INTO engf35_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","But that on the good ground: these are the ones who having heard the word with a noble and good heart, hold on to it and produce fruit with perseverance.” ");
INSERT INTO engf35_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Upon saying these things He called out: “He who has ears to hear, let him hear! No one, when he has lit a lamp, covers it with a vessel or puts it under a bed, but he sets it on a lamp stand, so that those who come in may see the light. ");
INSERT INTO engf35_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Further, there is nothing hidden that will not be revealed, nor anything concealed that will not be made known and come into the open. ");
INSERT INTO engf35_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","So be careful how you hear: Because whoever has, to him more will be given; and whoever does not have, even what he thinks he has will be taken away from him.” ");
INSERT INTO engf35_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Then His mother and brothers came to Him, and they could not get near Him because of the crowd. ");
INSERT INTO engf35_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","And it was told Him by some saying, “Your mother and your brothers are standing outside, wanting to see you.” ");
INSERT INTO engf35_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","But in answer He said to them, “My mother and my brothers are these, the ones who hear the word of God and do it!” ");
INSERT INTO engf35_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Now it happened on one of those days that He got into a boat with His disciples; and He said to them, “Let us go over to the other side of the lake.” So they launched out. ");
INSERT INTO engf35_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","But as they sailed He fell asleep. A windstorm descended on the lake, and they were being swamped and were in jeopardy. ");
INSERT INTO engf35_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","So they came and awakened Him, saying, “Master, Master, we are perishing!” Then He got up and rebuked the wind and the waves of water—and they stopped, and there was a calm! ");
INSERT INTO engf35_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","So He said to them, “Where is your faith?” But being terrified they marveled, saying to each other: “Who can this be? Because He commands even the winds and the water, and they obey Him!” ");
INSERT INTO engf35_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Then they sailed to the district of the Gadarenes, which is opposite Galilee. ");
INSERT INTO engf35_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Well when He stepped out on the land, a certain man of that town met Him, who had had demons for a long time—he wore no clothes, nor did he live in a house, but among the tombs. ");
INSERT INTO engf35_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","When he saw Jesus he gave a yell, fell down before Him, and with a loud voice he said: “What do you want with me, Jesus, Son of the Most High God? I beg you, don't torment me!” ");
INSERT INTO engf35_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","because He had commanded the unclean spirit to get out of the man (it had seized him many times—he would be bound with chains and shackles, being kept under guard; then bursting the bonds he would be driven by the demon into deserted places). ");
INSERT INTO engf35_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Then Jesus asked him, “What is your name?” And he said, “Legion” (because many demons had gone into him). ");
INSERT INTO engf35_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","And he kept imploring Him that He would not order them to go away into the Abyss. ");
INSERT INTO engf35_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Now a herd of many pigs was feeding there on the hillside; and they started begging Him that He would allow them to go into those; so He gave them permission. ");
INSERT INTO engf35_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Then the demons exited the man and entered the pigs—and the herd rushed down the steep bank into the lake and was drowned! ");
INSERT INTO engf35_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Well when the herders saw what had happened they ran away and reported it in the town and in the countryside. ");
INSERT INTO engf35_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","So they went out to see what had happened, and came to Jesus; they found the man from whom the demons had gone out sitting at Jesus' feet, clothed and in his right mind; and they were afraid. ");
INSERT INTO engf35_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Also, the eyewitnesses reported to them how the demonized man was healed. ");
INSERT INTO engf35_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Then the whole multitude from the surrounding region of the Gadarenes asked Him to depart from them, because they were overcome by fear. So He got into the boat and returned. ");
INSERT INTO engf35_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Now the man from whom the demons had gone out had started begging Him that he might be with Him. But Jesus sent him away, saying, ");
INSERT INTO engf35_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Return to your house and recount how much God has done for you.” So he went his way and proclaimed all over town how much Jesus had done for him. ");
INSERT INTO engf35_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Now it happened, when Jesus returned, that the crowd welcomed Him, because they were all waiting for Him. ");
INSERT INTO engf35_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","And then, there came a man named Jairus, and he was a ruler of the synagogue; he fell down at Jesus' feet and started begging Him to come to his house, ");
INSERT INTO engf35_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","because he had an only daughter, about twelve years old, and she was dying. Now as He was going, the crowds were pressing against Him. ");
INSERT INTO engf35_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","And a woman—suffering with a flow of blood for twelve years, who had spent her whole livelihood on physicians, but could not be healed by any— ");
INSERT INTO engf35_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","approaching from behind touched the border of His garment; and immediately the flow of her blood stopped! ");
INSERT INTO engf35_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","So Jesus said, “Who touched me?” When all denied it, Peter and those with him said: “Master, the people are pressing against you and crowding in, and you say, ‘Who touched me?’ ” ");
INSERT INTO engf35_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","But Jesus said, “Someone did touch me, because I noticed power going out from me.” ");
INSERT INTO engf35_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Now when the woman saw that she could not hide, she came trembling, and falling down before Him she told Him in the presence of all the people the reason why she had touched Him, and how she was healed immediately. ");
INSERT INTO engf35_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","So He said: “Courage, daughter, your faith has healed you. Go into peace.” ");
INSERT INTO engf35_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","While He was still speaking, here came someone from the synagogue ruler's house, saying to him: “Your daughter has died. Don't bother the teacher.” ");
INSERT INTO engf35_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","But upon hearing it Jesus reacted by saying to him, “Don't be afraid; just believe and she will be healed.” ");
INSERT INTO engf35_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","When He arrived at the house, He allowed no one to go in except Peter, John, James, the father of the child, and her mother. ");
INSERT INTO engf35_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Now all were weeping and mourning for her; but He said, “Do not weep; she is not dead, but sleeping.” ");
INSERT INTO engf35_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","They started ridiculing Him, knowing that she had died. ");
INSERT INTO engf35_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","So He put them all outside, and grasping her hand He called, saying, “Child, arise!” ");
INSERT INTO engf35_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Then her spirit returned, and she got right up! And He directed that she be given something to eat. ");
INSERT INTO engf35_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Her parents were astonished, but He charged them to tell no one what had happened. ");
INSERT INTO engf35_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Then He called the Twelve together and gave them power and authority over all the demons, and to cure diseases; ");
INSERT INTO engf35_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","and He sent them to proclaim the Kingdom of God and to heal the sick. ");
INSERT INTO engf35_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","And He said to them: “Take nothing for the journey—neither staffs nor knapsack nor bread nor money, neither have two tunics apiece. ");
INSERT INTO engf35_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Whatever house you enter, stay there, and depart from there. ");
INSERT INTO engf35_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","But as many as do not receive you, when you depart from that town, shake off even the dust from your feet as a testimony against them.” ");
INSERT INTO engf35_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","So they set out and went around, village by village, evangelizing and healing everywhere. ");
INSERT INTO engf35_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Now Herod the tetrarch heard of all the things being done by Him; and he was perplexed, because it was said by some that John had risen from the dead, ");
INSERT INTO engf35_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","and by some that Elijah had appeared, and by others that one of the ancient prophets had arisen. ");
INSERT INTO engf35_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","But Herod said, “John I beheaded; so who is this about whom I hear such things?” And he started trying to see Him. ");
INSERT INTO engf35_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","When the Apostles returned they reported to Him all that they had done. Then He took them and withdrew privately to a deserted place belonging to a town called Bethsaida. ");
INSERT INTO engf35_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","But the crowds, being aware, followed Him. So He received them and started speaking to them about the Kingdom of God, and He cured those who needed healing. ");
INSERT INTO engf35_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Now when the day began to decline, the Twelve approached and said to Him, “Dismiss the crowd, so that they may go to the surrounding villages and their farms, lodge and find food; because we are in a deserted place here.” ");
INSERT INTO engf35_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","But He said to them, “You feed them!” So they said, “We have no more than five loaves and two fish—unless we go and buy food for all this crowd” ");
INSERT INTO engf35_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(there were about five thousand men). But He said to His disciples, “Make them recline in groups of fifty!” ");
INSERT INTO engf35_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","They did so, making them all recline. ");
INSERT INTO engf35_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Then He took the five loaves and the two fish, and looking up to heaven He blessed and broke them, and gave them to the disciples to set before the multitude. ");
INSERT INTO engf35_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","So they all ate and were filled, and twelve baskets of the pieces they left were taken up. ");
INSERT INTO engf35_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Now it happened, as He was alone praying, that the disciples joined Him, and He questioned them, saying, “Who do the crowds say I am?” ");
INSERT INTO engf35_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","In answer they said, “John the Baptizer, but others say ‘Elijah,’ while others that one of the ancient prophets has arisen.” ");
INSERT INTO engf35_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Then He said to them, “But you, who do you say that I am?” In answer Peter said, “The Christ of God!” ");
INSERT INTO engf35_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","But He strictly warned and commanded them to tell this to no one, ");
INSERT INTO engf35_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","saying, “The Son of the Man must suffer many things, and be rejected by the elders and chief priests and scribes, and be killed, and the third day be raised up.” ");
INSERT INTO engf35_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Then He said to everyone: “If anyone desires to come after me, let him deny himself and take up his cross, and follow me. ");
INSERT INTO engf35_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Because whoever desires to ‘save’ his life will waste it, but whoever ‘wastes’ his life for my sake, he will save it. ");
INSERT INTO engf35_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Further, what is a man profited if he gains the whole world, yet wastes or forfeits his very self? ");
INSERT INTO engf35_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yes, whoever is ashamed of me and of my words, the Son of the Man will be ashamed of Him, whenever He comes in the glory—His, and the Father's, and of the holy angels. ");
INSERT INTO engf35_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","However, I tell you truly: there are some standing here who will certainly not taste death until they see the Kingdom of God!” ");
INSERT INTO engf35_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Now about eight days after these words, it happened that He took along Peter and John and James and went up on the mountain to pray. ");
INSERT INTO engf35_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","And as He prayed, the appearance of His face became different, and His clothing dazzling white. ");
INSERT INTO engf35_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","And then, two men started talking with Him, who were Moses and Elijah; ");
INSERT INTO engf35_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","they appeared in glory and were explaining His ‘departure’, that He was about to bring to fruition in Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Now Peter and those with him were heavy with sleep; but becoming fully awake, they saw His glory, and the two men who stood with Him. ");
INSERT INTO engf35_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Then it happened: as they were parting from Him, Peter said to Jesus: “Master, it is good for us to be here” and “Should we make three shelters: one for you, and one for Moses, and one for Elijah?”—not knowing what he was saying. ");
INSERT INTO engf35_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","But as he was saying this a cloud came and overshadowed them; and they became afraid as they entered the cloud. ");
INSERT INTO engf35_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","And a Voice came out of the cloud, saying: “This is my beloved Son. Listen to Him!” ");
INSERT INTO engf35_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","When the Voice had ceased, Jesus was found alone. (They kept quiet and told no one in those days any of the things they had seen.) ");
INSERT INTO engf35_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Now it happened on the next day, when they came down from the mountain, that a large crowd met Him. ");
INSERT INTO engf35_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","And then, a man from the crowd called out, saying: “Teacher, I beg you, look upon my son, for he is my only begotten. ");
INSERT INTO engf35_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","And oh, a spirit seizes him and he suddenly screams, and it convulses him with foaming, and it hardly departs from him, destroying him! ");
INSERT INTO engf35_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","And I begged your disciples to cast it out, but they could not.” ");
INSERT INTO engf35_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Then in answer Jesus said: “O unbelieving and perverse generation, how long shall I be with you and put up with you (pl)? Bring your (sg) son here!” ");
INSERT INTO engf35_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","But while he was still coming the demon threw him down and convulsed him. Then Jesus rebuked the unclean spirit, healed the child, and gave him back to his father. ");
INSERT INTO engf35_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Everyone was amazed at the majesty of God. But while all were marveling at all the things which Jesus did, He said to His disciples, ");
INSERT INTO engf35_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Let these words sink into your ears, because the Son of the Man is about to be betrayed into the hands of men.” ");
INSERT INTO engf35_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","But they did not understand this saying; indeed it was concealed from them, in order that they should not perceive it; and they were afraid to ask Him about it. ");
INSERT INTO engf35_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Then an argument started among them as to which of them would be the greatest. ");
INSERT INTO engf35_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","So Jesus, perceiving the reasoning of their heart, took a little child and had him stand beside Him, ");
INSERT INTO engf35_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","and said to them: “Whoever receives this little child in my name receives me; and whoever receives me receives Him who sent me. Further, he who is least among all of you, he will be great.” ");
INSERT INTO engf35_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Then John reacted by saying, “Master, we saw someone casting out demons in your name, and we forbade him because he does not follow with us.” ");
INSERT INTO engf35_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","So Jesus said to him, “Do not forbid, because he who is not against us is for us.” ");
INSERT INTO engf35_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Now it happened, as the days for His Ascension approached, that He set His face to go to Jerusalem, ");
INSERT INTO engf35_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","and He sent messengers ahead of Him. And as they went, they entered a village of the Samaritans, so as to prepare for Him. ");
INSERT INTO engf35_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","But they did not receive Him, because He was heading for Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Well, when His disciples, James and John, saw this, they said, “Lord, do you want us to call fire down from heaven and consume them, just like Elijah did?” ");
INSERT INTO engf35_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","But He turned and rebuked them saying: “You do not know of what sort of spirit you are. ");
INSERT INTO engf35_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Further, the Son of the Man did not come to destroy men's lives, but to save.” And they went to another village. ");
INSERT INTO engf35_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Now as they journeyed on the road, it happened that someone said to Him, “Lord, I will follow you wherever you go.” ");
INSERT INTO engf35_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","So Jesus said to him, “The foxes have dens and the birds of the air have nests, but the Son of the Man has no place to lay His head.” ");
INSERT INTO engf35_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Then He said to another, “Follow me!” But he said, “Lord, permit me first to go and bury my father.” ");
INSERT INTO engf35_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus said to him, “Let the dead bury their own dead, but you go and proclaim the Kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","And another also said, “I will follow you, Lord, but first allow me to bid farewell to those who are at my house.” ");
INSERT INTO engf35_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","But Jesus said to him, “No one who puts his hand to ‘the plow’ and looks back is suitable for the Kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Now after these things, the Lord appointed seventy others also, and sent them two by two ahead of Him to every town and place where He Himself was about to go. ");
INSERT INTO engf35_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Then He said to them: “The harvest is indeed great, but the workers are few; therefore pray to the Lord of the harvest that He may send out workers into His harvest. ");
INSERT INTO engf35_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Go! Yes, I am sending you out like lambs among wolves. ");
INSERT INTO engf35_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Do not carry a purse, nor a knapsack, nor sandals; and greet no one along the road. ");
INSERT INTO engf35_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Into whatever house you enter, first say, ‘Peace to this house.’ ");
INSERT INTO engf35_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","If a son of peace is there, your peace will rest upon him; but if not, it will return to you. ");
INSERT INTO engf35_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Remain in that same house, eating and drinking what they offer, because the worker is worthy of his wages. Do not move around from house to house. ");
INSERT INTO engf35_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“And into whatever town you enter, and they receive you, eat the things that are set before you. ");
INSERT INTO engf35_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Heal the sick therein and say to them, ‘The Kingdom of God has come near to you.’ ");
INSERT INTO engf35_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","But into whatever town you enter, and they do not receive you, go out into its streets and say: ");
INSERT INTO engf35_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Even the dust of your town that clings to us we wipe off against you. Nonetheless know this, that the Kingdom of God has come near to you.’ ");
INSERT INTO engf35_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I say to you that it will be more tolerable in that Day for Sodom than for that town. ");
INSERT INTO engf35_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Woe to you, Chorazin! Woe to you, Bethsaida! Because if the mighty works that were done in you had been done in Tyre and Sidon, they would have repented long ago, sitting in sackcloth and ashes. ");
INSERT INTO engf35_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nevertheless it will be more tolerable for Tyre and Sidon at the Judgment than for you. ");
INSERT INTO engf35_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","And you, Capernaum, who are ‘exalted to heaven’, will be brought down to Hades. ");
INSERT INTO engf35_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“He who listens to you listens to me, and he who rejects you rejects me; but he who rejects me rejects Him who sent me!” ");
INSERT INTO engf35_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Then the seventy returned with joy, saying, “Lord, even the demons are subject to us in your name!” ");
INSERT INTO engf35_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","So He said to them: “I watched Satan fall like lightning out of heaven. ");
INSERT INTO engf35_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Take note, I am giving you the authority to trample on snakes and scorpions, and over all the power of the enemy, and nothing at all may harm you. ");
INSERT INTO engf35_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","However, do not rejoice in this, that the spirits are subject to you; rather rejoice because your names are written in heaven.” ");
INSERT INTO engf35_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","In that same hour Jesus exulted in His spirit and said: “I praise you, Father, Lord of heaven and earth, that you have hidden these things from the wise and intelligent, and have revealed them to ‘infants’. Yes, Father, because it pleased you to do so.” ");
INSERT INTO engf35_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","And turning to the disciples He said: “All things have been entrusted to me by my Father; also, no one knows who the Son is except the Father, and who the Father is except the Son, and to whomever the Son may choose to reveal Him.” ");
INSERT INTO engf35_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Then turning to His disciples privately He said: “Blessed are the eyes that are seeing the things that you see; ");
INSERT INTO engf35_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","for I say to you that many prophets and kings have desired to see what you are seeing but did not, and to hear what you are hearing but did not.” ");
INSERT INTO engf35_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","And then, a certain lawyer stood up to test Him, saying, “Teacher, what must I do to inherit eternal life?” ");
INSERT INTO engf35_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","So He said to him: “What is written in the Law? How do you read it?” ");
INSERT INTO engf35_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","In answer he said: “You shall love the Lord your God with all your heart, and with all your soul, and with all your strength, and with all your mind, and, your neighbor as yourself.” ");
INSERT INTO engf35_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","So He said to him, “You have answered correctly; do this and you will live!” ");
INSERT INTO engf35_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","But he, wanting to justify himself, said to Jesus, “And who is my neighbor?” ");
INSERT INTO engf35_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","By way of reply Jesus said: “A certain man was going down from Jerusalem to Jericho, and as it chanced he ran into robbers, who after having stripped and wounded him, departed, leaving him half dead. ");
INSERT INTO engf35_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Now by coincidence a certain priest was going down that road, and when he saw him he passed by on the other side. ");
INSERT INTO engf35_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","So too, a Levite, when he arrived at the place, came and looked, and passed by on the other side. ");
INSERT INTO engf35_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","But a certain Samaritan, as he traveled, came by there, and upon seeing him was moved with compassion; ");
INSERT INTO engf35_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","and going to him he bound up his wounds, applying oil and wine. Then he placed him on his own mount, brought him to an inn, and took care of him. ");
INSERT INTO engf35_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","On the next day, when he departed, he took out two denarii, gave them to the innkeeper, and said to him, ‘Take care of him; and should you spend more, I will repay you when I return.’ ");
INSERT INTO engf35_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","So which of these three, would you say, was ‘neighbor’ to him who ran into the robbers?” ");
INSERT INTO engf35_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","He said, “The one who showed mercy on him.” So Jesus said to him, “Go and do likewise!” ");
INSERT INTO engf35_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Now it happened as they traveled that He entered a certain village; and a certain woman named Martha welcomed Him into her house. ");
INSERT INTO engf35_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","And she had a sister called Mary, who actually sat at Jesus' feet listening to His words. ");
INSERT INTO engf35_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Well Martha was distracted with much serving; so coming up she said: “Lord, don't you care that my sister has left me to serve alone? Do please tell her to help me!” ");
INSERT INTO engf35_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","But in answer Jesus said to her: “Martha, Martha, you are anxious and agitated about many things, ");
INSERT INTO engf35_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","but only one is needed. However, Mary has chosen the good part, which will not be taken away from her.” ");
INSERT INTO engf35_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Then it happened, when He finished praying in a certain place, that one of His disciples said to Him, “Lord, teach us to pray, just as John also taught his disciples.” ");
INSERT INTO engf35_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","So He said to them: “Whenever you pray, say: Our Father who is in the heavens, your name must be reverenced. Your Kingdom must come. Your will must be done on earth as it is in heaven. ");
INSERT INTO engf35_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Give us day by day our daily bread. ");
INSERT INTO engf35_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Also, forgive us our sins, because we also forgive everyone indebted to us. And, do not lead us into testing, but deliver us from the malignant one.” ");
INSERT INTO engf35_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Then He said to them: “Who among you will have a friend and go to him at midnight and say to him, ‘Friend, lend me three loaves, ");
INSERT INTO engf35_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","because a friend has come to me from a journey, and I have nothing to set before him’; ");
INSERT INTO engf35_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","and he will answer from within and say, ‘Don't bother me; the door is now shut, and my children are with me in bed; I cannot get up and give to you?’ ");
INSERT INTO engf35_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I say to you, even if he will not get up and give to him because he is his friend, yet because of his persistence he will get up and give him as many as he needs. ");
INSERT INTO engf35_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“So I say to you: ask, and it will be given to you; seek, and you will find; knock, and it will be opened to you. ");
INSERT INTO engf35_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Because everyone who asks receives, and he who seeks finds, and to him who knocks it will be opened. ");
INSERT INTO engf35_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","And which father among you, if your son asks for bread, will give him a stone? Or if a fish, will he give him a snake instead of a fish? ");
INSERT INTO engf35_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Or if he asks for an egg, will he give him a scorpion? ");
INSERT INTO engf35_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","If you then, being evil, know how to give good gifts to your children, how much more will the heavenly Father give the Holy Spirit to those who ask Him!” ");
INSERT INTO engf35_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Then He was casting out a demon, and it was mute. As a result, when the demon had gone out the mute spoke! And the crowds marveled. ");
INSERT INTO engf35_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","But some of them said, “It's by Beelzebul, the ruler of the demons, that he casts out demons.” ");
INSERT INTO engf35_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","While others kept asking Him for a sign from heaven, testing. ");
INSERT INTO engf35_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","But He, knowing their thoughts, said to them: “Every kingdom divided against itself is brought to desolation, and a house divided against itself falls. ");
INSERT INTO engf35_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","So if Satan also is divided against himself, how will his kingdom stand?—since you say I cast out demons by Beelzebul! ");
INSERT INTO engf35_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Further, if I am casting out demons by Beelzebul, by whom do your sons cast them out? Therefore they will be your judges. ");
INSERT INTO engf35_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","But if I cast out demons by the finger of God, surely the Kingdom of God has come upon you. ");
INSERT INTO engf35_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“When a strong man, fully armed, guards his own dwelling, his possessions are safe. ");
INSERT INTO engf35_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","But when someone stronger than he attacks, he overcomes him, takes away all his armor in which he trusted, and distributes his spoils. ");
INSERT INTO engf35_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“He who is not with me is against me, and he who does not gather with me scatters. ");
INSERT INTO engf35_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Whenever an unclean spirit goes out from a man, it passes through waterless places seeking rest; and not finding any it says, ‘I will return to my house from which I came out.’ ");
INSERT INTO engf35_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","And coming it finds it swept and put in order. ");
INSERT INTO engf35_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Then it goes and picks up seven other spirits, more malignant than itself, and they go in and live there; so the last state of that man becomes worse than the first.” ");
INSERT INTO engf35_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","And then, as He was saying these things, a woman in the crowd raised her voice and said to Him, “Blessed is the womb that bore you, and the breasts that you sucked!” ");
INSERT INTO engf35_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","But He said, “More than that, blessed are those who hear the word of God and obey it!” ");
INSERT INTO engf35_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Now as the crowds were increasing, He began to say: “This is a malignant generation. It keeps wanting a sign, but no sign will be given to it except the sign of the prophet Jonah. ");
INSERT INTO engf35_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Just as Jonah became a sign to the Ninevites, so also will the Son of the Man be to this generation. ");
INSERT INTO engf35_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","The queen of the South will be raised up in the judgment with the men of this generation, and she will condemn them, because she came from the ends of the earth to hear the wisdom of Solomon, and indeed a greater than Solomon is here. ");
INSERT INTO engf35_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","The men of Nineveh will rise up in the judgment with this generation, and they will condemn it, because they repented at the preaching of Jonah, and indeed a greater than Jonah is here. ");
INSERT INTO engf35_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“No one, having lit a lamp, puts it in hiding or under a basket, but on its stand, so that those who come in may see the light. ");
INSERT INTO engf35_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","The lamp of the body is the eye. Therefore, whenever your ‘eye’ is good, your whole body is illuminated. But when it is malignant, your body also is darkened. ");
INSERT INTO engf35_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","So see to it that the ‘light’ in you not be darkness. ");
INSERT INTO engf35_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","If then your whole body is full of light, not having any part dark, the whole will be illuminated, as when the bright shining of a lamp gives you light.” ");
INSERT INTO engf35_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Now as He spoke, a certain Pharisee invited Him to eat with him. So He went in and reclined. ");
INSERT INTO engf35_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","But the Pharisee, noticing that He did not first wash before the meal, was critical. ");
INSERT INTO engf35_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","So the Lord said to him: “Now you Pharisees clean the outside of the cup and the dish, but your inside is full of greed and malignancy. ");
INSERT INTO engf35_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fools! Did not He who made the outside also make the inside? ");
INSERT INTO engf35_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nevertheless, give what is possible as alms; then indeed all things are clean to you. ");
INSERT INTO engf35_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“But woe to you Pharisees! You tithe mint and rue and every herb, but you ignore justice and the love of God. These it was necessary to do, without leaving those undone. ");
INSERT INTO engf35_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woe to you Pharisees! You love the best seat in the synagogues, and greetings in the marketplaces. ");
INSERT INTO engf35_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woe to you, scribes and Pharisees, hypocrites! You are like unperceived graves, that people walk on without knowing it.” ");
INSERT INTO engf35_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Then one of the lawyers reacted and said to him, “Teacher, by saying these things you insult us also!” ");
INSERT INTO engf35_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","So He said: “Woe to you lawyers also! You load men down with burdens hard to carry, but you yourselves do not touch the burdens with one of your fingers. ");
INSERT INTO engf35_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woe to you! You restore the tombs of the prophets, it being your fathers who killed them. ");
INSERT INTO engf35_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Thereby you witness to and approve of the deeds of your fathers; because they indeed killed them, while you restore their tombs. ");
INSERT INTO engf35_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Also, because of this ‘the wisdom of God’ said: ‘I will send them prophets and apostles, and some of them they will kill and persecute,’ ");
INSERT INTO engf35_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","so that the blood of all the prophets which was shed from the foundation of the world may be required of this generation, ");
INSERT INTO engf35_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","from the blood of Abel to the blood of Zechariah, who perished between the altar and the sanctuary. Yes, I say to you, it shall be required of this generation! ");
INSERT INTO engf35_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Woe to you lawyers! You have taken away the key of knowledge; you yourselves have not entered, and you have hindered those who were entering!” ");
INSERT INTO engf35_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Well when He had said these things to them, the scribes and the Pharisees began to urge Him on vehemently and to cross-examine Him about many things, ");
INSERT INTO engf35_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","lying in wait for Him, trying to catch Him in something He might say, so that they might accuse Him. ");
INSERT INTO engf35_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Meanwhile, when a crowd of thousands had converged, so that they were stepping on each other, He began to speak first to His disciples: “Guard yourselves from the ‘yeast’ of the Pharisees, which is hypocrisy. ");
INSERT INTO engf35_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","There is nothing concealed that will not be revealed, or hidden that will not be known. ");
INSERT INTO engf35_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Therefore whatever you have spoken in the dark will be heard in the light, and what you have whispered in the ear behind closed doors will be proclaimed from the housetops. ");
INSERT INTO engf35_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Further, I say to you, my friends: do not be afraid of those who kill the body and after that have nothing more that they can do. ");
INSERT INTO engf35_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Rather, I will advise you whom you should fear—fear Him who after He kills has authority to cast into Gehenna; yes indeed, fear Him! ");
INSERT INTO engf35_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Are not five sparrows sold for two copper coins? Yet not one of them is forgotten before God. ");
INSERT INTO engf35_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Even the hairs of your head are all numbered! So do not be afraid; you are far more valuable than sparrows! ");
INSERT INTO engf35_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Also I say to you, whoever claims me before men, the Son of the Man will also claim him before the angels of God. ");
INSERT INTO engf35_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","But whoever disclaims me before men will be disclaimed before the angels of God. ");
INSERT INTO engf35_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Anyone who speaks a word against the Son of the Man, it can be forgiven him; but to him who blasphemes against the Holy Spirit it will not be forgiven. ");
INSERT INTO engf35_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Now whenever they bring you before synagogues, rulers and authorities, do not worry about how or what you will answer, or what you should say. ");
INSERT INTO engf35_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Because the Holy Spirit will teach you in that very hour what you need to say.” ");
INSERT INTO engf35_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Then someone from the crowd said to Him, “Teacher, tell my brother to divide the inheritance with me.” ");
INSERT INTO engf35_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","But He said to him, “Man, who appointed me a judge or an arbiter over you?” ");
INSERT INTO engf35_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Then He said to them, “Keep alert and guard against covetousness, because one's life does not consist in the abundance of his possessions.” ");
INSERT INTO engf35_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Then He told them a parable, saying: “The ground of a certain rich man produced well. ");
INSERT INTO engf35_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","And he reasoned within himself saying, ‘What shall I do, because I have no place to store my crops?’ ");
INSERT INTO engf35_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Then he said: ‘This is what I will do. I will tear down my barns and build bigger ones, and there I will store all my produce and my goods. ");
INSERT INTO engf35_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","And I will say to my soul: Soul, you have many goods laid up for many years. Take life easy; eat, drink and enjoy yourself!’ ");
INSERT INTO engf35_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","But God said to him: ‘Stupid! This very night your life is being taken back from you; then who will get the things you have prepared?’ ");
INSERT INTO engf35_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Just like that is he who accumulates treasure for himself and is not rich toward God.” ");
INSERT INTO engf35_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Then He said to His disciples: “Therefore I say to you, do not worry about your life, what you will eat; nor about the body, what you will wear. ");
INSERT INTO engf35_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Life is more than food, and the body more than clothes. ");
INSERT INTO engf35_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Consider the ravens: they neither sow nor reap, they have neither storeroom nor barn, and God feeds them. You are far more valuable than the birds! ");
INSERT INTO engf35_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","And who among you can add one cubit to his height by worrying? ");
INSERT INTO engf35_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","So if you cannot do even such a little thing, why worry about the rest? ");
INSERT INTO engf35_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Consider the lilies, how they grow: they neither toil nor spin; I say to you, not even Solomon in all his splendor was clothed like one of these. ");
INSERT INTO engf35_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","So if God so clothes the grass that today is in the field and tomorrow is thrown into an oven, how much more you, O little-faiths! ");
INSERT INTO engf35_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Do not concentrate on what you may eat or what you may drink; do not be anxious. ");
INSERT INTO engf35_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","All these things really occupy the nations of the world, and your Father knows that you need them. ");
INSERT INTO engf35_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Rather, concentrate on the Kingdom of God, and all these things will be provided for you. ");
INSERT INTO engf35_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Do not fear, little flock, because it pleased the Father to give you the Kingdom. ");
INSERT INTO engf35_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sell your possessions and give to charity. Make for yourselves ‘purses’ that will not wear out, an unfailing treasure in the heavens, where a thief cannot approach, nor a moth destroy. ");
INSERT INTO engf35_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Because where your treasure is, there your heart will be also. ");
INSERT INTO engf35_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Let your waists be belted and your lamps burning, ");
INSERT INTO engf35_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","and you yourselves like men waiting for their master when he returns from the wedding celebration, so that when he comes and knocks they may open to him immediately. ");
INSERT INTO engf35_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blessed are those slaves whom the master will find watching when he comes. Assuredly I say to you that he will gird himself and have them recline, and will come and serve them. ");
INSERT INTO engf35_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","And if he should come in the second watch, or come in the third watch, and find them so, blessed are those slaves. ");
INSERT INTO engf35_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","But know this, that if the master of the house had known in what hour the thief was coming, he would have kept watch and not allowed his house to be broken into. ");
INSERT INTO engf35_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Therefore you also be ready, because the Son of the Man is coming at an hour you do not expect.” ");
INSERT INTO engf35_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Then Peter said to Him, “Lord, are you directing this parable to us, or to everyone?” ");
INSERT INTO engf35_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","So the Lord said: “Who then is the faithful and prudent steward whom his master will place over his household to give them the food allowance at the right time? ");
INSERT INTO engf35_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blessed is that slave whom his master will find so doing when he comes. ");
INSERT INTO engf35_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I tell you truly that he will put him in charge of all his possessions. ");
INSERT INTO engf35_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","But if that servant should say in his heart, ‘My master won't come for a while,’ and should begin to hit the male and female servants, and to eat and drink and get drunk, ");
INSERT INTO engf35_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","the master of that slave will come on a day when he does not expect him, and at an hour that he does not know, and will cut him in two and appoint his portion with the unbelievers. ");
INSERT INTO engf35_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“That servant who knew his master's will, but neither got ready nor did according to that will, will be beaten with many blows. ");
INSERT INTO engf35_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","But he who did not know, yet did things worthy of blows, will be beaten with few. Everyone to whom much has been given, from him much will be required; and to whom much was entrusted, of him much more will be asked. ");
INSERT INTO engf35_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“I came to bring fire to the earth, and how I wish it were already kindled! ");
INSERT INTO engf35_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","But I have a baptism to undergo, and how distressed I am until it is completed! ");
INSERT INTO engf35_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Do you imagine that I came to provide peace on the earth? Not at all, I tell you, but rather division. ");
INSERT INTO engf35_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Because from now on there will be five in one house divided: three against two and two against three. ");
INSERT INTO engf35_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Father will be divided against son and son against father, mother against daughter and daughter against mother, mother-in-law against her daughter-in-law and daughter-in-law against her mother-in-law.” ");
INSERT INTO engf35_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Then He also said to the crowds: “Whenever you see a cloud rising from the west, immediately you say, ‘A rainstorm is coming,’ and so it does. ");
INSERT INTO engf35_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","And whenever a south wind blows, you say, ‘It will be hot,’ and it happens. ");
INSERT INTO engf35_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hypocrites! You know how to interpret the appearance of the sky and of the earth, so how can you not discern this time? ");
INSERT INTO engf35_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Also why, even of yourselves, do you not judge what is right? ");
INSERT INTO engf35_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“When you are going with your adversary to the magistrate, make every effort along the way to settle with him, lest he drag you to the judge, the judge deliver you to the bailiff, and the bailiff throw you into prison. ");
INSERT INTO engf35_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","I tell you, you will by no means get out of there until you have paid the last penny.” ");
INSERT INTO engf35_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Now at that time there were some present who told Him about the Galileans whose blood Herod had mixed with their sacrifices. ");
INSERT INTO engf35_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","So in answer Jesus said to them: “Do you suppose that those Galileans were worse sinners than all the other Galileans, because they suffered such things? ");
INSERT INTO engf35_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Not at all, I tell you, but unless you repent you will all likewise perish! ");
INSERT INTO engf35_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Or those eighteen on whom the tower of Siloam fell and killed them; do you suppose they were worse offenders than all others living in Jerusalem? ");
INSERT INTO engf35_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Not at all, I tell you, but unless you repent you will all likewise perish!” ");
INSERT INTO engf35_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Then He told this parable: “A certain man had a fig tree planted in his vineyard, and he came looking for fruit on it and found none. ");
INSERT INTO engf35_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","So he said to the gardener: ‘Look, for three years I have come looking for fruit on this fig tree and have not found any. Cut it down; just why must it waste the soil?’ ");
INSERT INTO engf35_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","But in answer he said to him, ‘Sir, let it be this year also, until I dig around it and apply fertilizer, ");
INSERT INTO engf35_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","in case it produces fruit—but if not, then cut it down.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Now as Jesus was teaching in one of the synagogues on the Sabbath, ");
INSERT INTO engf35_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","He saw a woman there who had been crippled by a spirit for eighteen years—she was bent over and could not straighten up. ");
INSERT INTO engf35_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","So He called her over and said to her, “Woman, you are loosed from your infirmity!” ");
INSERT INTO engf35_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","He placed His hands on her and immediately she was made straight and started glorifying God. ");
INSERT INTO engf35_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","But the ruler of the synagogue reacted with indignation, because Jesus had healed on the Sabbath, and he said to the crowd, “There are six days in which one should work; therefore come and be healed on them, and not on the Sabbath.” ");
INSERT INTO engf35_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","So the Lord answered him and said: “Hypocrites! Does not each one of you on the Sabbath loose his ox or donkey from the stall and lead it away to water? ");
INSERT INTO engf35_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","So ought not this woman, being a daughter of Abraham, whom Satan kept bound during eighteen long years, be freed from this bond on the Sabbath day?” ");
INSERT INTO engf35_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","When He said these things all His adversaries were put to shame, while all the crowd was rejoicing over all the glorious things that were being done by Him. ");
INSERT INTO engf35_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Then He said: “What is the Kingdom of God like, and to what shall I compare it? ");
INSERT INTO engf35_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","It is like a mustard seed, which a man took and planted in his garden; and it grew and became a sizable tree, and the birds of the air perched on its branches.” ");
INSERT INTO engf35_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Again He said: “To what shall I compare the Kingdom of God? ");
INSERT INTO engf35_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","It is like yeast that a woman took and mixed into three measures of flour, until it was all leavened.” ");
INSERT INTO engf35_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","He was traveling through various towns and villages, teaching and journeying toward Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Then someone said to Him, “Lord, are the ones being saved few?” So He said to them: ");
INSERT INTO engf35_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Exert yourselves to enter through the narrow gate, because many, I say to you, will try to enter and not manage it. ");
INSERT INTO engf35_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","When once the master of the house gets up and shuts the door, and you begin to stand outside and knock on the door saying, ‘Lord, Lord, open to us!’ and in answer he will say to you, ‘I do not know you; where are you from?’ ");
INSERT INTO engf35_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","then you will begin by saying, ‘We ate and drank in your presence, and you taught in our streets.’ ");
INSERT INTO engf35_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","But he will say: ‘I tell you, I do not know where you are from. Depart from me, all you workers of iniquity.’ ");
INSERT INTO engf35_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“There will be weeping there, and gnashing of teeth, when you see Abraham and Isaac and Jacob and all the prophets in the Kingdom of God, but you yourselves being thrown out. ");
INSERT INTO engf35_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","They will even come from the east, the west, the north and the south, and recline in the Kingdom of God. ");
INSERT INTO engf35_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yes indeed, there are last who will be first, and there are first who will be last.” ");
INSERT INTO engf35_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","On that same day some Pharisees approached saying to Him, “Get out of here and go away, because Herod wants to kill you.” ");
INSERT INTO engf35_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","He said to them: “Go tell that ‘fox’, ‘Take note, I am casting out demons and performing cures today and tomorrow, and on the third I will be perfected.’ ");
INSERT INTO engf35_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nevertheless I must keep going today and tomorrow and the day following, because it is not credible that a prophet should perish outside of Jerusalem! ");
INSERT INTO engf35_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, she who kills the prophets and stones those who are sent to her! How often I wanted to gather your children together, like a hen gathers her brood under her wings, but you were not willing! ");
INSERT INTO engf35_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","So then, your house is left to you desolate. I tell you that you will definitely not see me until the time comes when you say, ‘Blessed is He who comes in the name of the Lord!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Then it happened, when He entered the house of one of the rulers of the Pharisees to eat bread on the Sabbath, that they were watching Him closely. ");
INSERT INTO engf35_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","And then, there in front of Him was a man who had dropsy! ");
INSERT INTO engf35_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","And Jesus reacted by saying to the lawyers and Pharisees, “Is it lawful to heal on the Sabbath?” ");
INSERT INTO engf35_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","But they kept silent. So He took hold of him, healed him, and let him go. ");
INSERT INTO engf35_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Then He addressed them saying, “Which of you, if a son or an ox falls into a pit, will not immediately pull him out on the Sabbath day?” ");
INSERT INTO engf35_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","And they could not answer Him regarding these things. ");
INSERT INTO engf35_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Then He told a parable to those who were invited, having observed how they kept trying for the best places, saying to them: ");
INSERT INTO engf35_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Whenever you are invited by someone to a wedding feast, do not recline in the place of honor, in case someone more honorable than you has been invited by him; ");
INSERT INTO engf35_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","then he who invited you both will come and say, ‘You, give this man place!’ and then, with shame, you start to take the lowest place. ");
INSERT INTO engf35_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Rather, whenever you are invited, go and recline in the lowest place, so that when your host comes, he may say to you, ‘Friend, move up higher.’ Then you will have honor in the presence of your fellow guests. ");
INSERT INTO engf35_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Because everyone who exalts himself will be humbled, and he who humbles himself will be exalted.” ");
INSERT INTO engf35_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Then He said directly to His host: “Whenever you give a dinner or a supper, do not invite your friends, nor your brothers, nor your relatives, nor rich neighbors, lest they also invite you back, and you be repaid. ");
INSERT INTO engf35_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","But whenever you make a banquet, invite the poor, the crippled, the lame, the blind; ");
INSERT INTO engf35_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","and you will be blessed, because they cannot repay you—you will be repaid at the resurrection of the righteous.” ");
INSERT INTO engf35_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Well when one of the fellow-recliners heard these things, he said to Him, “Blessed is he who will eat dinner in the Kingdom of God!” ");
INSERT INTO engf35_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","So He said to him: “A certain man prepared a great banquet and invited many. ");
INSERT INTO engf35_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","And at meal time he sent his slave to say to those who were invited, ‘Come, because everything is now ready.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","But they all alike began to make excuses. The first said to him: ‘I bought a field, and I need to go and see it. I ask you to have me excused.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Another said: ‘I bought five yoke of oxen, and I am going to test them. I ask you to have me excused.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yet another said, ‘I have married a wife, and so I cannot come.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","So that slave came and reported these things to his master. Then the owner of the house became angry and said to his slave, ‘Go out quickly into the streets and lanes of the city, and bring in here the poor and crippled and blind and lame.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","And the slave said, ‘Master, what you ordered has been done, and there is still room.’ ");
INSERT INTO engf35_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Then the master said to the slave: ‘Go out to the roads and hedges and make people come in, so that my house may be filled. ");
INSERT INTO engf35_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","For I tell you that none of those men who were invited will get a taste of my banquet!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Now large crowds were traveling with Him, and turning He said to them: ");
INSERT INTO engf35_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“If anyone comes to me and does not hate his father and mother, wife and children, brothers and sisters, yes, and even his own life, he cannot be my disciple. ");
INSERT INTO engf35_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","And whoever does not carry his cross, and come after me, cannot be my disciple. ");
INSERT INTO engf35_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Further, which of you, intending to build a tower, does not sit down first and calculate the cost, whether he has enough to complete it? ");
INSERT INTO engf35_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","This so he does not lay a foundation without being able to finish, and all who see it begin to ridicule him, ");
INSERT INTO engf35_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","saying, ‘This man began to build and was not able to finish!’ ");
INSERT INTO engf35_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Or what king, going to engage another king in battle, does not sit down first and consider whether he is able with ten thousand to meet the one coming against him with twenty thousand? ");
INSERT INTO engf35_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","And if not, while the other is still far away he sends a delegation and asks for terms for peace. ");
INSERT INTO engf35_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“So likewise, any of you who does not renounce all his own possessions cannot be my disciple. ");
INSERT INTO engf35_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Salt is good; but should the salt become insipid, with what can it be seasoned? ");
INSERT INTO engf35_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","It is fit for neither soil nor fertilizer; it is thrown out. He who has ears to hear, let him hear!” ");
INSERT INTO engf35_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Then all the tax collectors and ‘sinners’ were getting close to Him to hear Him. ");
INSERT INTO engf35_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Well the Pharisees and the scribes started complaining, saying, “This man welcomes ‘sinners’ and eats with them.” ");
INSERT INTO engf35_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","So He told them this parable, saying: ");
INSERT INTO engf35_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“What man among you, having a hundred sheep and losing one of them, does not abandon the ninety-nine in the wild and go after the lost one until he finds it? ");
INSERT INTO engf35_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","And upon finding it he joyfully puts it on his shoulders. ");
INSERT INTO engf35_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","And when he comes home, he calls together his friends and neighbors, saying to them, ‘Rejoice with me, for I have found my sheep that was lost!’ ");
INSERT INTO engf35_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","I say to you that likewise there will be more joy in heaven over one sinner who repents than over ninety-nine righteous ones who have no need of repentance. ");
INSERT INTO engf35_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Or what woman having ten silver coins, if she loses one coin, does not light a lamp, sweep the house, and search carefully until she finds it? ");
INSERT INTO engf35_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","And when she finds it, she calls together her friends and neighbors saying, ‘Rejoice with me, for I have found the coin that I lost!’ ");
INSERT INTO engf35_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Just so, I say to you, there is joy in the presence of the angels of God over one sinner who repents.” ");
INSERT INTO engf35_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Then He said: “A certain man had two sons. ");
INSERT INTO engf35_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","And the younger one said to the father, ‘Father, give me the appropriate share of the estate.’ So he divided the property between them. ");
INSERT INTO engf35_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Not many days later the younger son, having converted it all, journeyed to a distant country; and there he squandered his wealth living dissolutely. ");
INSERT INTO engf35_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","But when he had spent it all, there was a severe famine throughout that country, and he began to be in need. ");
INSERT INTO engf35_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Then he went and attached himself to a citizen of that country, who sent him into his fields to feed pigs. ");
INSERT INTO engf35_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","He would gladly have filled his stomach with the carob pods that the pigs were eating, but no one gave him anything. ");
INSERT INTO engf35_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","But when he came to himself he said: ‘How many of my father's hired servants have an abundance of bread, while I am dying of hunger! ");
INSERT INTO engf35_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","I will get up and go to my father and say to him: Father, I have sinned against heaven and before you, ");
INSERT INTO engf35_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","and I am no longer worthy to be called your son; make me as one of your hired servants.’ ");
INSERT INTO engf35_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“So he got up and went to his own father. But while he was still a good ways off, his father saw him and was moved with compassion—he ran and fell on his neck and kissed him! ");
INSERT INTO engf35_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Then the son said to him, ‘Father, I have sinned against heaven and before you, and I am no longer worthy to be called your son.’ ");
INSERT INTO engf35_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","But the father said to his slaves: ‘Bring out the best robe and put it on him, and put a ring on his hand and sandals on his feet. ");
INSERT INTO engf35_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","And bring in and kill the fatted calf, and let us eat and celebrate; ");
INSERT INTO engf35_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","because this son of mine was dead and came to life; he was lost and is found!’ So they began to celebrate. ");
INSERT INTO engf35_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Now his older son was in the field; and as he came approaching the house he heard music and dancing. ");
INSERT INTO engf35_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","So he called one of the servants and asked what these things meant. ");
INSERT INTO engf35_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","He said to him, ‘Your brother has come, and your father has killed the fatted calf, because he has received him back safe and sound.’ ");
INSERT INTO engf35_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","So he became angry and refused to go in. Then his father came out and began to plead with him. ");
INSERT INTO engf35_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","But in answer he said to the father: ‘Just look at how many years I have been serving you without ever transgressing your commandment; yet you never gave me even a young goat that I might celebrate with my friends. ");
INSERT INTO engf35_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","But when this son of yours came, who has devoured your livelihood with prostitutes, you killed the fatted calf for him!’ ");
INSERT INTO engf35_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","So he said to him: ‘Son, you are always with me, and all that I have is yours. ");
INSERT INTO engf35_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","But it was right that we celebrate and be glad, because this brother of yours was dead and came to life; he was lost and is found.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Then He said further to His disciples: “There was a certain rich man who had a manager, who was accused to him of wasting his goods. ");
INSERT INTO engf35_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","So he called him in and said to him: ‘What is this I hear about you? Render an account of your stewardship, because you can no longer be manager.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Then the manager said within himself: ‘What shall I do? My master is taking the management away from me. I do not have strength to dig; I am ashamed to beg ");
INSERT INTO engf35_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","—I know what I will do, so that whenever I am removed from the management they may receive me into their houses.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Summoning each one of his master's debtors, he said to the first, ‘How much do you owe my master?’ ");
INSERT INTO engf35_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","And he said, ‘A hundred baths of olive oil.’ So he said to him, ‘Take your bill and sit down quickly and write fifty.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Then he said to another, ‘And how much do you owe?’ And he said, ‘A hundred measures of wheat.’ So he said to him, ‘Take your bill and write eighty.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","The master even ‘commended’ the dishonest manager, because he had acted shrewdly. The sons of this age are shrewder in their own generation than the sons of the Light. ");
INSERT INTO engf35_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“I even say to you, make friends for yourselves by means of unrighteous mammon, so that whenever you fail, they may receive you into the eternal dwellings! ");
INSERT INTO engf35_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","He who is faithful in a very little is faithful also in much, and he who is dishonest in a very little is dishonest also in much. ");
INSERT INTO engf35_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","If therefore you have not been faithful with the unrighteous mammon, who will commit to your trust the genuine? ");
INSERT INTO engf35_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","And if you have not been faithful in what belongs to another, who will give you what is your own? ");
INSERT INTO engf35_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","No servant can serve two masters; either he will hate the one and love the other, or he will be devoted to the one and despise the other. You cannot serve God and mammon!” ");
INSERT INTO engf35_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Now the Pharisees, who were lovers of money, were also listening to all these things, and they were ridiculing Him. ");
INSERT INTO engf35_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","So He said to them: “You are those who justify yourselves before men, but God knows your hearts. That which is exalted among men is an abomination before God. ");
INSERT INTO engf35_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","The Law and the Prophets were until John; since then the Kingdom of God is being proclaimed, and every one is trying to force his way into it. ");
INSERT INTO engf35_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","But it is easier for heaven and earth to pass away, than for one tittle of the Law to fail. ");
INSERT INTO engf35_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Whoever divorces his wife and marries another woman commits adultery, and whoever marries her who is divorced from her husband commits adultery. ");
INSERT INTO engf35_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Now there was a certain rich man who was dressed in purple and fine linen, living in luxury every day. ");
INSERT INTO engf35_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","And there was a certain beggar named Lazarus, covered with sores, who had been placed at his gate, ");
INSERT INTO engf35_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","just wanting to be fed with the crumbs that fell from the rich man's table—why even the dogs would come and lick his sores! ");
INSERT INTO engf35_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","In due time the beggar died and was carried away to Abraham's bosom by the angels. “The rich man also died and was buried. ");
INSERT INTO engf35_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","And in Hades he looked up and saw Abraham at a distance, and Lazarus very close to him. And being in torment, ");
INSERT INTO engf35_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","he called out, saying, ‘Father Abraham, have mercy on me and send Lazarus, that he may dip the tip of his finger in water and cool my tongue; because I am tormented by this flame!’ ");
INSERT INTO engf35_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","But Abraham said: ‘Child, remember that in your lifetime you received your good things, while Lazarus had bad things; but now he is being comforted, and you tormented. ");
INSERT INTO engf35_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","And besides all this, between us and you a great chasm has been fixed, so that those who want to pass from here to you cannot, nor can anyone from there cross over to us.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Then he said, ‘I beg you therefore, father, that you would send him to my father's house, ");
INSERT INTO engf35_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","because I have five brothers, so that he may testify to them, lest they also come to this place of torment.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham said to him, ‘They have Moses and the prophets; let them hear them.’ ");
INSERT INTO engf35_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","So he said to him, ‘Oh no, father Abraham—if someone from the dead should go to them, they will repent!’ ");
INSERT INTO engf35_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","He said to him, ‘If they do not listen to Moses and the prophets, they will not be persuaded even if someone should rise from the dead.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Then He said to the disciples: “Things that cause people to fall are bound to come, but woe to him through whom they do come! ");
INSERT INTO engf35_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","It would be better for him if a millstone were hung around his neck and he were thrown into the sea, than that he should cause one of these little ones to fall. ");
INSERT INTO engf35_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Watch out for yourselves: if your brother sins against you, rebuke him; and if he repents, forgive him. ");
INSERT INTO engf35_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Even if he sins against you seven times in a day, and seven times in that day returns, saying, ‘I repent,’ you must forgive him.” ");
INSERT INTO engf35_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","The apostles said to the Lord, “Increase our faith.” ");
INSERT INTO engf35_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","So the Lord said: “If you had faith like a mustard seed has, you could say to this mulberry tree, ‘Be uprooted, and be planted in the sea,’ and it would obey you. ");
INSERT INTO engf35_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“And which of you, having a slave plowing or tending sheep, will say to him when he comes in from the field, ‘Come at once and recline to eat’? ");
INSERT INTO engf35_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Will he not rather say to him, ‘Prepare something for me to eat, and gird yourself and serve me until I eat and drink, and afterward you will eat and drink’? ");
INSERT INTO engf35_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Does he thank that slave because he did the things commanded? I guess not! ");
INSERT INTO engf35_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","So likewise you, whenever you have done everything you were told to do, say, ‘We are unworthy slaves, because we have only done what we were supposed to.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Now as He was traveling toward Jerusalem, He went along between Samaria and Galilee. ");
INSERT INTO engf35_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","And as He entered a certain village, ten men met Him—being lepers they stood at a distance. ");
INSERT INTO engf35_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","They called out, saying, “Jesus, Master, have mercy on us!” ");
INSERT INTO engf35_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","And paying attention He said to them, “Go and show yourselves to the priests.” It happened that as they went they were cleansed! ");
INSERT INTO engf35_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Well one of them, when he saw that he was healed, returned, glorifying God with a loud voice; ");
INSERT INTO engf35_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","then he fell on his face at His feet, thanking Him—and he was a Samaritan! ");
INSERT INTO engf35_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","So Jesus reacted by saying: “Were not all ten cleansed? So where are the nine? ");
INSERT INTO engf35_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","None were found to return and give glory to God except this foreigner!” ");
INSERT INTO engf35_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Then He said to him, “Get up and go; your faith has made you well.” ");
INSERT INTO engf35_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Now when He was asked by the Pharisees when the Kingdom of God would come, He answered them and said: “The Kingdom of God does not come with observation; ");
INSERT INTO engf35_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","nor will they say, ‘Look, here!’ or ‘Look, there!’ because indeed the Kingdom of God is within you.” ");
INSERT INTO engf35_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Then He said to the disciples: “Days are coming when you will long to see one of the days of the Son of the Man, and you will not see it. ");
INSERT INTO engf35_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","And they will say to you, ‘Look, here!’ or ‘Look, there!’ Do not go along or follow. ");
INSERT INTO engf35_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Because just like the lightning that lights the whole sky when it flashes, so also will the Son of the Man be in His day. ");
INSERT INTO engf35_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","But first He must suffer many things and be rejected by this generation. ");
INSERT INTO engf35_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Also, just as it was in the days of Noah, so will it also be in the days of the Son of the Man. ");
INSERT INTO engf35_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","They were eating, drinking, marrying and being given in marriage, until the day that Noah entered the ark, and the flood came and destroyed them all. ");
INSERT INTO engf35_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Likewise also as it was in the days of Lot; they were eating, drinking, buying, selling, planting, building— ");
INSERT INTO engf35_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","but on the day Lot went out from Sodom, fire and brimstone rained down from heaven and destroyed them all. ");
INSERT INTO engf35_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Even so will it be in the day when the Son of the Man is revealed. ");
INSERT INTO engf35_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“In that day, he who is on the housetop, and his goods in the house, let him not go down to get them; and likewise he who is in the field, let him not turn back. ");
INSERT INTO engf35_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Remember Lot's wife! ");
INSERT INTO engf35_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Whoever seeks to save his life will lose it, and whoever ‘wastes’ it will preserve it. ");
INSERT INTO engf35_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","I tell you: on that night there will be two men in one bed; one will be taken and the other left. ");
INSERT INTO engf35_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Two women will be grinding together; one will be taken and the other left.” ");
INSERT INTO engf35_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","They reacted by saying to Him, “Where, Lord?” He said to them, “Where there is a carcass, there will the vultures also be gathered.” ");
INSERT INTO engf35_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","And then He told them a parable, the point being that one needs to always pray and not lose heart, ");
INSERT INTO engf35_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","saying: “There was a judge in a certain town who did not fear God nor regard man. ");
INSERT INTO engf35_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","But there was a widow in that town, and she kept coming to him, saying, ‘Get justice for me from my adversary.’ ");
INSERT INTO engf35_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","And for a while he refused; but afterward he said to himself, ‘Even though I don't fear God nor regard man, ");
INSERT INTO engf35_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yet because this widow keeps bothering me, I will defend her, so that her endless coming doesn't wear me out!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Then the Lord said: “Hear what the unjust judge said. ");
INSERT INTO engf35_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","And will not God get justice for His elect who are crying out to Him day and night, indeed being patient with them? ");
INSERT INTO engf35_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","I tell you that He will get justice for them quickly. However, when the Son of the Man comes, will He actually find the faith on the earth?” ");
INSERT INTO engf35_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Then He told this parable to some who trusted in themselves that they were righteous, and despised the rest: ");
INSERT INTO engf35_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Two men went up to the temple to pray, one a Pharisee and the other a tax collector. ");
INSERT INTO engf35_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","The Pharisee stood and started praying to himself like this: ‘God, I thank you that I am not like all the rest—robbers, unjust, adulterers—or even like this tax collector. ");
INSERT INTO engf35_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","I fast twice a week; I tithe all that I get.’ ");
INSERT INTO engf35_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","The tax collector, staying a good ways off, did not even venture to look up to heaven, but started beating on his chest, saying, ‘God, be merciful to me a sinner!’ ");
INSERT INTO engf35_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","I say to you that this one went back home justified rather than that one; because everyone who exalts himself will be humbled, but he who humbles himself will be exalted.” ");
INSERT INTO engf35_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Then they even started bringing their babies to Him, that He might touch them; but when the disciples saw it, they rebuked them. ");
INSERT INTO engf35_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","But Jesus summoned them and said: “Allow the little children to come to me, and do not hinder them; because the Kingdom of God is of such. ");
INSERT INTO engf35_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","I tell you assuredly, whoever does not receive the Kingdom of God the way a little child does will by no means enter it.” ");
INSERT INTO engf35_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A certain ruler asked Him, saying, “Good teacher, what must I do to inherit eternal life?” ");
INSERT INTO engf35_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","So Jesus said to him: “Why do you call me good? No one is good except one—God. ");
INSERT INTO engf35_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","You know the commandments: ‘Do not commit adultery, do not murder, do not steal, do not give false testimony, honor your father and your mother.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","And he said, “All these I have kept from my youth.” ");
INSERT INTO engf35_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Well upon hearing these things Jesus said to him, “You still lack one thing: sell all you have and distribute to the poor, and you will have treasure in heaven; and come, follow me.” ");
INSERT INTO engf35_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","But when he heard this he became very sad, because he was extremely rich. ");
INSERT INTO engf35_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","When Jesus saw that he became sad, He said: “How difficult it is for those who have riches to enter the Kingdom of God! ");
INSERT INTO engf35_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","It is actually easier for a camel to go through the eye of a needle than for a rich man to enter the Kingdom of God!” ");
INSERT INTO engf35_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","So the hearers said, “Who then can be saved?” ");
INSERT INTO engf35_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","And He said, “The things that are impossible with men are possible with God.” ");
INSERT INTO engf35_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Then Peter said, “Notice that we have left all and followed you!” ");
INSERT INTO engf35_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","So He said to them, “Assuredly I say to you, there is no one who has left house or parents or brothers or wife or children, for the sake of the Kingdom of God, ");
INSERT INTO engf35_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","who will not receive many times more in this present time, and in the age to come eternal life.” ");
INSERT INTO engf35_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Then He took the Twelve aside and said to them: “Take note, we are going up to Jerusalem, and all the things that are written by the prophets concerning the Son of the Man will be fulfilled: ");
INSERT INTO engf35_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","He will be betrayed to the Gentiles, and will be mocked and insulted and spit upon, ");
INSERT INTO engf35_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","and they will scourge and kill Him. And on the third day He will rise again.” ");
INSERT INTO engf35_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","But they understood none of these things; this saying was hidden from them, and they did not know what was being said. ");
INSERT INTO engf35_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Then it happened, as He approached Jericho, that a certain blind man was sitting alongside the road begging. ");
INSERT INTO engf35_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hearing a crowd going by, he asked what it was. ");
INSERT INTO engf35_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","So they told him that Jesus the Natsorean was passing by. ");
INSERT INTO engf35_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Well he shouted, saying, “Jesus, Son of David, have mercy on me!” ");
INSERT INTO engf35_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Those who led the way started reproving him, to shut him up; but he kept calling out all the more, “Son of David, have mercy on me!” ");
INSERT INTO engf35_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","So Jesus stopped and ordered that he be brought to Him. When he got close He asked him, saying, ");
INSERT INTO engf35_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“What do you want me to do for you?” So he said, “Lord, that I may see again!” ");
INSERT INTO engf35_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Then Jesus said to him: “See again! Your faith has made you well.” ");
INSERT INTO engf35_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","And immediately he did! and he followed Him, glorifying God. And all who witnessed it gave praise to God. ");
INSERT INTO engf35_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","He entered and started passing through Jericho. ");
INSERT INTO engf35_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A man named Zacchaeus was there—he was a chief tax collector, and he was wealthy! ");
INSERT INTO engf35_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","He was trying to see who Jesus was, but could not because of the crowd, because he was short. ");
INSERT INTO engf35_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","And running on ahead he climbed up into a sycamore tree, in order to see Him, since He was about to pass by there. ");
INSERT INTO engf35_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","And when Jesus came to the place, He looked up and saw him, and said to him, “Zacchaeus, come down quickly, because today I must stay at your house.” ");
INSERT INTO engf35_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","So he came down quickly, and received Him joyfully. ");
INSERT INTO engf35_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","But when they saw it, they all started complaining, saying, “He has entered to lodge with a sinful man!” ");
INSERT INTO engf35_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Then Zacchaeus stood and said to the Lord, “Indeed, Lord, I herewith give half of my goods to the poor, and if I have extorted anything from anyone, I restore fourfold.” ");
INSERT INTO engf35_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","So Jesus said about him, “Today salvation has happened in this house, in that he also is a son of Abraham; ");
INSERT INTO engf35_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","because the Son of the Man has come to seek and to save that which was lost.” ");
INSERT INTO engf35_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Now as they heard these things, He continued with a parable, because He was near Jerusalem and they were supposing that the Kingdom of God was on the verge of being revealed. ");
INSERT INTO engf35_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","So He said: “A certain nobleman went to a distant country to receive for himself a kingdom and return. ");
INSERT INTO engf35_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","He called ten of his slaves, gave them ten ‘minas’, and said to them, ‘Conduct business until I come.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","But his citizens hated him and sent a delegation after him, saying, ‘We do not want this man to reign over us.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","It happened that he did receive the kingdom, and upon returning he ordered that those slaves to whom he had given the money be called to him, to know who had gained what by trading. ");
INSERT INTO engf35_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","So the first one came and said, ‘Master, your mina earned ten minas!’ ");
INSERT INTO engf35_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","He said to him: ‘Super, you good slave! Because you were faithful in a very little, have authority over ten cities!’ ");
INSERT INTO engf35_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","And the second one came and said, ‘Master, your mina made five minas.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Likewise he said to him, ‘You also be over five cities.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Then a different one came, saying: ‘Master, here is your mina, that I kept laid away in a piece of cloth ");
INSERT INTO engf35_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","—I feared you because you are a hard man, removing what you did not place, and reaping what you did not sow.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","So he said to him: ‘I will judge you out of your own mouth, you wicked slave! You knew that I am a hard man, removing what I did not place, and reaping what I did not sow. ");
INSERT INTO engf35_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Why then didn't you put my money on deposit, and upon coming I would have collected it with interest?’ ");
INSERT INTO engf35_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","And to those standing by he said, ‘Take the mina from him and give it to him who has the ten minas.’ ");
INSERT INTO engf35_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(They even said to him, ‘Master, he already has ten minas!’) ");
INSERT INTO engf35_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Indeed I tell you, to everyone who has, more will be given; but from him who does not have, even what he has will be taken from him. ");
INSERT INTO engf35_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","But as for those enemies of mine who did not want me to reign over them, bring them here and slaughter them in front of me!’ ” ");
INSERT INTO engf35_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Having said these things, He went on ahead, going up to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","When He drew near to Bethphage and Bethany, at the mountain called ‘of Olives’, it happened like this: He sent two of His disciples, ");
INSERT INTO engf35_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","saying: “Go to the village opposite you, where as you enter you will find a colt tied, on which no man ever yet sat. Untie and bring it. ");
INSERT INTO engf35_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","And if anyone asks you, ‘Why are you untying it?’ just say this to him: ‘The Lord needs it.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","So those who were sent went and found it just like He told them. ");
INSERT INTO engf35_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","As they were untying the colt, its owners said to them, “Why are you untying the colt?” ");
INSERT INTO engf35_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","So they said, “The Lord needs it.” ");
INSERT INTO engf35_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Then they brought it to Jesus; and throwing their own clothes on the colt, they placed Jesus on it. ");
INSERT INTO engf35_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","And as He went along people were spreading their clothes on the road. ");
INSERT INTO engf35_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Then, as He was approaching the descent of the Mount of Olives, the whole multitude of the disciples began to rejoice and praise God with a loud voice for all the mighty works they had seen, ");
INSERT INTO engf35_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","saying: “Blessed is the King who comes in the name of the Lord! Peace in heaven and glory in the highest!” ");
INSERT INTO engf35_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Some of the Pharisees said to Him from the crowd, “Teacher, rebuke your disciples!” ");
INSERT INTO engf35_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","In answer He said to them, “I tell you that if these should keep silent, the very stones would cry out!” ");
INSERT INTO engf35_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Now as He approached, observing the city He wept over it, ");
INSERT INTO engf35_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","saying: “If you, yes you, especially in this your day, had known the things pertaining to your peace! But now they are hidden from your eyes. ");
INSERT INTO engf35_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yes, the days will come upon you when your enemies will build an embankment around you; indeed they will surround you and hem you in on every side. ");
INSERT INTO engf35_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","And they will raze you, and your children within you, to the ground—they will not leave in you one stone upon another—all because you did not recognize the time of your visitation.” ");
INSERT INTO engf35_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","And upon entering the temple He began to drive out those who were selling and buying in it, ");
INSERT INTO engf35_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","saying to them, “It is written: ‘My house is a house of prayer,’ but you have made it a ‘den of robbers’!” ");
INSERT INTO engf35_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","And He was teaching daily in the temple; but the chief priests and the scribes, as also the leaders of the people, were trying to destroy Him, ");
INSERT INTO engf35_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","but could not figure out how to do it, because all the people were hanging on His words. ");
INSERT INTO engf35_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Now it happened on one of those days, as He was teaching and evangelizing the people in the temple, that the priests and scribes came to Him with the elders ");
INSERT INTO engf35_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","and addressed Him, saying, “Tell us by what authority you are doing these things; or who is he who gave you this authority?” ");
INSERT INTO engf35_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","But in answer He said to them: “I also will ask you one thing; yes, tell me: ");
INSERT INTO engf35_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","the baptism of John—was it from heaven or from men?” ");
INSERT INTO engf35_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","So they reasoned among themselves, saying: “If we say, ‘From heaven,’ he will say, ‘Why did you not believe him?’ ");
INSERT INTO engf35_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","But if we say, ‘From men,’ all the people will stone us, for they are persuaded that John was a prophet.” ");
INSERT INTO engf35_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","So they answered that they did not know where it was from. ");
INSERT INTO engf35_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","And Jesus said to them, “Neither will I tell you by what authority I do these things.” ");
INSERT INTO engf35_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Then He began to tell the people this parable: “A man planted a vineyard, leased it to farmers, and went away on a long journey. ");
INSERT INTO engf35_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","At the proper time he sent a slave to the farmers, that they might give him some of the fruit of the vineyard. But the farmers flogged him and sent him away empty-handed. ");
INSERT INTO engf35_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Again he sent a different slave; so they flogged him also, treated him shamefully, and sent him away empty-handed. ");
INSERT INTO engf35_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","And again he sent a third; but they wounded him also and threw him out. ");
INSERT INTO engf35_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Then the owner of the vineyard said: ‘What shall I do? I will send my beloved son; hopefully they will respect him when they see him.’ ");
INSERT INTO engf35_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","But when the farmers saw him, they reasoned among themselves, saying: ‘This is the heir. Come, let's kill him, so that the inheritance may become ours.’ ");
INSERT INTO engf35_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","So they threw him out of the vineyard and killed him. What therefore will the owner of the vineyard do to them? ");
INSERT INTO engf35_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","He will come and destroy those farmers and give the vineyard to others.” Having heard it they said, “May it never be!” ");
INSERT INTO engf35_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Then He looked directly at them and said: “What then is this that is written: ‘A stone that the builders rejected, the same became the cornerstone’? ");
INSERT INTO engf35_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Everyone who falls on that stone will be broken to pieces, but on whomever it should fall—it will crush him!” ");
INSERT INTO engf35_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","The chief priests and the scribes wanted to lay hands on Him right then, but they were afraid —they knew He had spoken this parable against them. ");
INSERT INTO engf35_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Keeping a close watch on Him, they sent spies, who pretended to be innocent, so that they might latch on to something He said, so as to hand Him over to the power and the authority of the governor. ");
INSERT INTO engf35_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","So they questioned Him, saying: “Teacher, we know that you speak and teach what is right, and you do not show favoritism but teach the way of God in truth. ");
INSERT INTO engf35_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Is it lawful for us to pay taxes to Caesar, or not?” ");
INSERT INTO engf35_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","But He perceived their craftiness and said to them: “Why are you testing me? ");
INSERT INTO engf35_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Show me a denarius—whose image and inscription does it have?” In answer they said, “Caesar's.” ");
INSERT INTO engf35_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","So He said to them, “Then render to Caesar the things that are Caesar's, and to God the things that are God's.” ");
INSERT INTO engf35_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","They were unable to latch on to His word in front of the people; and marveling at His answer they kept silent. ");
INSERT INTO engf35_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Then some of the Sadducees, who deny that there is a resurrection, approached and questioned Him, ");
INSERT INTO engf35_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","saying: “Teacher, Moses wrote to us that if a man's married brother dies childless, then his brother should take the widow and produce offspring for his brother. ");
INSERT INTO engf35_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Now there were seven brothers: the first took a wife and died childless; ");
INSERT INTO engf35_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","then the second took the widow and he died childless; ");
INSERT INTO engf35_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","then the third took her, in fact all seven in sequence—they all died childless. ");
INSERT INTO engf35_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Finally, last of all, the woman died also. ");
INSERT INTO engf35_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Therefore, in the resurrection, whose wife will she be, since all seven had her?” ");
INSERT INTO engf35_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","So in answer Jesus said to them: “The people of this age marry and are given in marriage; ");
INSERT INTO engf35_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","but those who are considered worthy to attain to that age, to the resurrection from among the dead, neither marry nor are given in marriage. ");
INSERT INTO engf35_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Because they cannot die anymore, being like angels—they are sons of God, being sons of the resurrection. ");
INSERT INTO engf35_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","But that the dead are raised, Moses indeed revealed about the Bush when he recorded: ‘The Lord, the God of Abraham and the God of Isaac and the God of Jacob.’ ");
INSERT INTO engf35_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","So He is not the God of the dead, but of the living—to Him all are alive.” ");
INSERT INTO engf35_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Then some of the scribes answered and said, “Teacher, you spoke well.” ");
INSERT INTO engf35_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","And they no longer dared to question Him further. ");
INSERT INTO engf35_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Then He said to them: “How is it that they say that the Messiah is David's Son? ");
INSERT INTO engf35_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Why David himself affirms in the book of Psalms, ‘The Lord said to my Lord: sit at my right hand ");
INSERT INTO engf35_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","until I make your enemies a footstool for your feet.’ ");
INSERT INTO engf35_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Since David calls Him ‘Lord’, how then is He his Son?” ");
INSERT INTO engf35_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Then, in the hearing of the people, He said to His disciples: ");
INSERT INTO engf35_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Beware of the scribes, who like to walk around in long robes, and love greetings in the marketplaces, and the best seats in the synagogues, and the best places at feasts; ");
INSERT INTO engf35_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","who ‘devour’ widows' houses, and for a show make long prayers. These will receive more severe judgment.” ");
INSERT INTO engf35_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Looking up He saw the rich putting their gifts into the treasure chest. ");
INSERT INTO engf35_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","But He also saw a certain poor widow putting in two mites. ");
INSERT INTO engf35_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","So He said: “I tell you truly that this poor widow put in more than all of them; ");
INSERT INTO engf35_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","because all these others put in gifts for God out of their abundance, but she, out of her destitution, put in all she had to live on.” ");
INSERT INTO engf35_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Then, as some were admiring the temple, how it was adorned with beautiful stones and donations, He said, ");
INSERT INTO engf35_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“These things that you see—the days will come in which not one stone will be left upon another that will not be thrown down.” ");
INSERT INTO engf35_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","So they asked Him, saying: “Teacher, so when will these things be?” and “What will be the sign when these things are about to happen?” ");
INSERT INTO engf35_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","So He said: “Be careful, so as not to be deceived, because many will come in my name saying: ‘I am’ and ‘The time is at hand.’ Therefore do not go after them. ");
INSERT INTO engf35_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","But whenever you hear of wars and insurrections, do not be terrified; because these things must happen first, but the end will not come right away.” ");
INSERT INTO engf35_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Then He said to them: “Nation will be raised up against nation, and kingdom against kingdom. ");
INSERT INTO engf35_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","And there will be severe earthquakes in various places, and famines and pestilences; and there will be fearful events and great signs from heaven. ");
INSERT INTO engf35_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","But before all these things, they will lay their hands on you and persecute you, delivering you up to synagogues and prisons, bringing you before kings and governors on account of my name. ");
INSERT INTO engf35_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","But it will turn out for you as an occasion for testimony. ");
INSERT INTO engf35_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","So settle it in your hearts not to practice giving a defense beforehand; ");
INSERT INTO engf35_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","because I will give you a mouth and wisdom such that all your adversaries will not be able to contradict or withstand. ");
INSERT INTO engf35_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","You will be betrayed even by parents and relatives, friends and ‘brothers’; and they will put some of you to death. ");
INSERT INTO engf35_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","And you will be hated by all because of my name. ");
INSERT INTO engf35_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","(Not even one hair of your head will be wasted ");
INSERT INTO engf35_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","—you must secure your souls by your endurance.) ");
INSERT INTO engf35_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“But when you see Jerusalem surrounded by armies, then know that her desolation is at hand. ");
INSERT INTO engf35_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Then let those who are in Judea flee to the mountains; let those who are in the city get out, and let those who are in the country not enter her. ");
INSERT INTO engf35_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Because these are days of vengeance, that all the written things may be fulfilled. ");
INSERT INTO engf35_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","But woe to those who are pregnant and to those nursing babies in those days! There will be great distress in the land, and wrath to this people. ");
INSERT INTO engf35_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yes, they will fall by the edge of the sword, and be led away captive into all nations. And Jerusalem will be trampled by Gentiles, until the times of the Gentiles are fulfilled. ");
INSERT INTO engf35_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“There will be signs in sun, moon, and stars; and on the earth distress of nations, with perplexity, at the roaring and tossing of the sea; ");
INSERT INTO engf35_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","men fainting from fear and expectation of the things coming on the inhabited earth—because the powers of the heavens will be shaken. ");
INSERT INTO engf35_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Then they will see the Son of the Man coming in a cloud with power and great glory. ");
INSERT INTO engf35_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Now when these things begin to happen, straighten up and lift up your heads, because your redemption is drawing near.” ");
INSERT INTO engf35_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Then He told them a parable: “Look at the fig tree and all the trees. ");
INSERT INTO engf35_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Whenever they are already budding, you see and know by yourselves that summer is now near. ");
INSERT INTO engf35_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","So you also, whenever you see these things happening, know that the Kingdom of God is near. ");
INSERT INTO engf35_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","I tell you assuredly, this generation will certainly not pass away until all has happened. ");
INSERT INTO engf35_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Heaven and earth will pass away, but my words will by no means pass away. ");
INSERT INTO engf35_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“But keep a watch on yourselves, lest your hearts be weighed down with dissipation, drunkenness, and cares of life, and that Day come upon you suddenly. ");
INSERT INTO engf35_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Because it will come like a trap upon all those who dwell on the surface of the whole earth. ");
INSERT INTO engf35_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","So be watchful all the time, praying that you may be counted worthy to escape all these things that are about to happen and to stand before the Son of the Man.” ");
INSERT INTO engf35_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","In the daytime He was teaching in the temple, but at night He went out and stayed on the mountain called ‘of Olives.’ ");
INSERT INTO engf35_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Then early in the morning all the people would come to Him in the temple to hear Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Now the feast of unleavened bread, which is called ‘Passover’, drew near. ");
INSERT INTO engf35_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","And the chief priests and the scribes were looking for a way to kill Him, because they feared the people. ");
INSERT INTO engf35_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Then Satan entered Judas (the one surnamed Iscariot), who was numbered among the Twelve. ");
INSERT INTO engf35_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","So he went off and conferred with the chief priests and officers about how he might betray Him to them. ");
INSERT INTO engf35_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","They were glad, and agreed to give him silver coins. ");
INSERT INTO engf35_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","So he promised, and started looking for an opportunity to betray Him to them, without a crowd. ");
INSERT INTO engf35_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Then came the day of unleavened bread, in which it was necessary to kill the Passover lamb. ");
INSERT INTO engf35_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","And He sent Peter and John, saying, “Go and prepare the Passover for us, that we may eat.” ");
INSERT INTO engf35_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","So they said to Him, “Where do you want us to prepare?” ");
INSERT INTO engf35_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","He said to them: “Note, upon entering the city a man carrying a jar of water will meet you; follow him into the house which he enters. ");
INSERT INTO engf35_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Then you must say to the master of the house, ‘The Teacher says to you: Where is the guest room where I may eat the Passover with my disciples?’ ");
INSERT INTO engf35_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","He himself will show you a large upper room, all furnished; make preparations there.” ");
INSERT INTO engf35_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","So off they went and found things just as He had said to them, and they prepared the Passover. ");
INSERT INTO engf35_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","When the hour had come, He reclined, and the twelve apostles with Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Then He said to them: “I have fervently desired to eat this Passover with you before I suffer. ");
INSERT INTO engf35_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","I tell you further that I will not eat of it again until it is fulfilled in the Kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","And taking a cup He gave thanks and said: “Take this and share it among yourselves. ");
INSERT INTO engf35_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","I tell you further that I will not drink again of the fruit of the vine until the Kingdom of God comes.” ");
INSERT INTO engf35_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Then, after the meal, He took bread, gave thanks, broke and gave it to them, saying, “This is my body which is given for you; do this in remembrance of me.” ");
INSERT INTO engf35_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","He also took the cup, saying: “This cup is the new covenant in my blood, which is shed for you. ");
INSERT INTO engf35_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“But alas, the hand of him who betrays me is with me on the table! ");
INSERT INTO engf35_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","To be sure, the Son of the Man is going as it has been determined, but woe to that man by whom He is betrayed!” ");
INSERT INTO engf35_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","(They began to question among themselves which of them it might be who was about to do this.) ");
INSERT INTO engf35_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Now there had actually been a discussion among them as to which of them seemed to be greater. ");
INSERT INTO engf35_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","So He said to them: “The kings of the nations lord it over them, and those who exercise authority over them are called ‘benefactors’. ");
INSERT INTO engf35_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","But not so with you—rather let the greater among you become as the younger, and he who leads as he who serves. ");
INSERT INTO engf35_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Who is greater, the one reclining or the one serving? Is it not the one reclining? Yet I am among you as the one who serves. ");
INSERT INTO engf35_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","However, you are those who have continued with me in my trials. ");
INSERT INTO engf35_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","And I bestow on you a kingdom, just as my Father bestowed one on me, ");
INSERT INTO engf35_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","so that you may eat and drink at my table in my Kingdom; also you will sit on thrones judging the twelve tribes of Israel!” ");
INSERT INTO engf35_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Then the Lord said: “Simon, Simon! Indeed Satan has asked for you (pl) so as to sift you like wheat. ");
INSERT INTO engf35_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","But I have prayed for you (sg) so that your faith not fail completely; so you, when you have recovered, strengthen your brothers.” ");
INSERT INTO engf35_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","But he said to Him, “Lord, I am ready to go with you both to prison and to death!” ");
INSERT INTO engf35_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","So He said, “I say to you, Peter, no rooster can crow today before you deny three times that you know me!” ");
INSERT INTO engf35_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Then He said to them, “When I sent you without money bag, knapsack or sandals, did you lack anything?” And they said, “Nothing.” ");
INSERT INTO engf35_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","So He said to them: “But now, he who has a money bag should take it, and likewise a knapsack; and he who has no sword must sell his garment and buy one. ");
INSERT INTO engf35_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Because I say to you that this which is written must still be fulfilled in me: ‘And he was classed with the lawless’; and because the things concerning me have an end.” ");
INSERT INTO engf35_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","So they said, “Look, Lord, here are two swords.” And He said to them, “It is enough.” ");
INSERT INTO engf35_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Then going out He went to the Mount of Olives, as His custom was, and His disciples followed Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","When He came to the place, He said to them, “Pray, so as not to enter into temptation.” ");
INSERT INTO engf35_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Then He withdrew from them about a stone's throw, knelt down and prayed, ");
INSERT INTO engf35_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","saying, “Father, if you would just remove this cup from me—nevertheless, not my will, but yours, be done!” ");
INSERT INTO engf35_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Then an angel from heaven appeared to Him, strengthening Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","And being in anguish He prayed with total concentration; then His sweat became like clots of blood, falling to the ground. ");
INSERT INTO engf35_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","When He rose up from prayer and came to the disciples, He found them sleeping from sorrow. ");
INSERT INTO engf35_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","He said to them: “Why do you sleep? Get up and pray, that you may not enter into temptation!” ");
INSERT INTO engf35_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","But while He was still speaking—wow, a crowd; and he who was called Judas, one of the twelve, was leading them! He approached Jesus to kiss Him (he had given them this sign, “Whomever I kiss, it is he”). ");
INSERT INTO engf35_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","So Jesus said to him, “Judas, are you betraying the Son of the Man with a kiss?” ");
INSERT INTO engf35_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","When those who were around Him saw what was about to happen, they said to Him, “Lord, shall we strike with the sword?” ");
INSERT INTO engf35_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","And a certain one of them struck the servant of the high priest, and cut off his right ear! ");
INSERT INTO engf35_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","But Jesus reacted by saying, “Allow at least this!” and touching his ear He healed him. ");
INSERT INTO engf35_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Then Jesus said to the chief priests, officers of the temple, and elders who had come against Him: “Have you come out with swords and clubs as against a bandit? ");
INSERT INTO engf35_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","When I was with you daily in the temple, you did not lay a hand on me. But this is your hour; even the authority of the darkness!” ");
INSERT INTO engf35_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Then they seized, took and brought Him to the house of the high priest, with Peter following at a distance. ");
INSERT INTO engf35_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Now when they had kindled a fire in the middle of the courtyard and sat down together, Peter sat among them. ");
INSERT INTO engf35_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Then a certain servant girl, seeing him sitting by the fire, looked intently at him and said, “This man also was with him.” ");
INSERT INTO engf35_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","But he denied Him, saying, “Woman, I do not know him!” ");
INSERT INTO engf35_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","After a little while another saw him and said, “You also are one of them.” But Peter said, “Man, I am not!” ");
INSERT INTO engf35_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Then after about an hour had passed, another started insisting, “Surely this fellow also was with him, because he is a Galilean.” ");
INSERT INTO engf35_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","But Peter said, “Man, I don't know what you're talking about!” And immediately, while he was still speaking, a rooster crowed. ");
INSERT INTO engf35_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","And the Lord turned and looked directly at Peter; then Peter remembered the Lord's word, how He had said to him, “Before a rooster crows, you will deny me three times.” ");
INSERT INTO engf35_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","And going outside he wept bitterly. ");
INSERT INTO engf35_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","The men who were guarding Jesus started mocking and beating Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","And having blindfolded Him they would hit His face and ask Him, saying: “Prophesy! Who was it who struck you?” ");
INSERT INTO engf35_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","And they kept saying many other insulting things to Him. ");
INSERT INTO engf35_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","As soon as it was day, the elders of the people, both the chief priests and scribes, came together and brought Him before their council, saying, ");
INSERT INTO engf35_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“If you are the Messiah, tell us.” But He said to them: “If I tell you, you simply will not believe. ");
INSERT INTO engf35_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","But if I also question you, you will neither answer nor release me. ");
INSERT INTO engf35_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hereafter the Son of the Man will be seated at the right hand of the power of God.” ");
INSERT INTO engf35_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Then they all said, “Are you then the Son of God?” So He said to them, “You say it because I AM!” ");
INSERT INTO engf35_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Then they said: “What further testimony do we need? We ourselves have heard it from his mouth!” ");
INSERT INTO engf35_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Then the whole crowd of them rose up and led Him to Pilate. ");
INSERT INTO engf35_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","And they began to accuse Him, saying, “We found this fellow perverting the nation and forbidding to pay taxes to Caesar, declaring himself to be Christ, a king.” ");
INSERT INTO engf35_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","So Pilate questioned Him, saying, “Are you the king of the Jews?” In reply He said to him, “You said it!” ");
INSERT INTO engf35_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Then Pilate said to the chief priests and the crowds, “I find no guilt in this man.” ");
INSERT INTO engf35_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","But they insisted, saying, “He stirs up the people, teaching throughout all Judea, beginning from Galilee even to here.” ");
INSERT INTO engf35_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","When Pilate heard ‘Galilee’, he asked if the man was a Galilean. ");
INSERT INTO engf35_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Upon learning that He belonged to Herod's jurisdiction, he sent Him to Herod, who was also in Jerusalem during those days. ");
INSERT INTO engf35_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Now when Herod saw Jesus, he was really pleased, because for a long time he had been wanting to see Him, having heard so many things about Him; and he was hoping to see some miracle performed by Him. ");
INSERT INTO engf35_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","He questioned Him with many words, but He gave him no answer. ");
INSERT INTO engf35_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","On their part, the high priests and scribes stood by, vehemently accusing Him. ");
INSERT INTO engf35_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Then Herod and his soldiers, after ridiculing and mocking Him, arrayed Him in a gorgeous robe and sent Him back to Pilate. ");
INSERT INTO engf35_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","(That very day Pilate and Herod became friends with each other—previously having been at odds with each other.) ");
INSERT INTO engf35_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Then Pilate, having called together the chief priests and the rulers and the people, ");
INSERT INTO engf35_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","said to them: “You have brought this man to me as one who misleads the people, and yet, having examined him in your presence, I have found no guilt in this man as to those things of which you accuse him. ");
INSERT INTO engf35_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Further, neither did Herod (for I sent you on to him); indeed, nothing deserving of death has been done by him. ");
INSERT INTO engf35_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","I will therefore flog and release him.” ");
INSERT INTO engf35_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(It was necessary for him to release one to them at the feast.) ");
INSERT INTO engf35_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","But they all cried out together, saying: “Away with this one! Release to us Barabbas!”— ");
INSERT INTO engf35_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","who had been thrown into prison for a certain insurrection in the city, and for murder. ");
INSERT INTO engf35_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Then Pilate, wanting to release Jesus, addressed them again. ");
INSERT INTO engf35_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","But they just kept shouting: “Crucify! Crucify him!” ");
INSERT INTO engf35_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","For the third time he said to them: “But what evil has this man done? I have found no reason for death in him. I will therefore flog and release him.” ");
INSERT INTO engf35_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","But they were insistent, demanding with loud voices that He be crucified! And their voices, especially of the chief priests, prevailed. ");
INSERT INTO engf35_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","So Pilate decided to grant their demand. ");
INSERT INTO engf35_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","He released the one who had been thrown into prison for insurrection and murder, the one they asked for; but he delivered Jesus to their will. ");
INSERT INTO engf35_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Now as they led Him away, they conscripted a certain Simon of Cyrene (coming in from a field), and put the cross on him to carry it behind Jesus. ");
INSERT INTO engf35_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A considerable crowd of people followed Him, including women who were also mourning and lamenting Him. ");
INSERT INTO engf35_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","So Jesus turned to them and said: “Daughters of Jerusalem, do not weep for me; rather weep for yourselves and for your children. ");
INSERT INTO engf35_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Because indeed, the days are coming in which they will say, ‘Blessed are the barren, even the wombs that never bore and the breasts that never nursed!’ ");
INSERT INTO engf35_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Then they will begin ‘to say to the mountains, “Fall on us!” and to the hills, “Cover us!” ’ ");
INSERT INTO engf35_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","For if they do these things in the ‘green tree’, what will happen in the ‘dry’?” ");
INSERT INTO engf35_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","There were also two others, criminals, led with Him to be put to death. ");
INSERT INTO engf35_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","When they arrived at the place called ‘The Skull’, they crucified Him there; also the criminals, one on His right, the other on His left. ");
INSERT INTO engf35_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Then Jesus said, “Father, forgive them, for they do not know what they are doing”; while they were dividing up His clothes by casting a lot. ");
INSERT INTO engf35_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Meanwhile the people stood looking on. And especially the rulers among them were sneering, saying, “He saved others; let him save himself, if such is the Christ, the chosen of God!” ");
INSERT INTO engf35_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yes, even the soldiers mocked Him, approaching and offering Him sour wine, ");
INSERT INTO engf35_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","and saying, “If you are the king of the Jews, save yourself!” ");
INSERT INTO engf35_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","In fact, above Him there was a written notice, in Greek, Latin and Hebrew letters: THIS IS THE KING OF THE JEWS. ");
INSERT INTO engf35_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Then one of the hanged criminals started berating Him, saying, “If you are the Christ, save yourself and us!” ");
INSERT INTO engf35_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","But the other reacted and rebuked him, saying: “Don't you even fear God, since you are under the same condemnation? ");
INSERT INTO engf35_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","And we indeed justly, for we are receiving the due reward for our deeds; but this man did nothing wrong.” ");
INSERT INTO engf35_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Then he said to Jesus, “Please remember me, Lord, when you come in your kingdom.” ");
INSERT INTO engf35_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus said to him, “I tell you assuredly, today you will be with me in Paradise.” ");
INSERT INTO engf35_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Now it was about the sixth hour, and darkness came upon the whole land until the ninth hour. ");
INSERT INTO engf35_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yes, the sun was darkened; also, the veil of the temple was torn in two. ");
INSERT INTO engf35_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Then, after giving a loud shout, Jesus said, “Father, it is into your hands that I will commit my spirit.” And having said this, He breathed out His spirit. ");
INSERT INTO engf35_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Well upon seeing what had happened, the centurion glorified God, saying, “Certainly this man was righteous!” ");
INSERT INTO engf35_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","And the whole crowd that had gathered for the spectacle, when they saw what actually happened, went away beating their breasts. ");
INSERT INTO engf35_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","But all His acquaintances, including the women who had followed Him from Galilee, stood at a distance, watching these things. ");
INSERT INTO engf35_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Now then, there was a man named Joseph, a good and righteous man, a Council member ");
INSERT INTO engf35_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(but he had not agreed with their counsel and action), from Arimathea, a city of the Jews, who himself was waiting for the Kingdom of God: ");
INSERT INTO engf35_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","this man went to Pilate and asked for Jesus' body. ");
INSERT INTO engf35_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Then he took it down, wrapped it in linen, and placed it in a tomb cut out of rock, where no one had ever been laid. ");
INSERT INTO engf35_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","It was a Preparation day; the Sabbath was drawing near. ");
INSERT INTO engf35_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","The women who had come with Him from Galilee followed along, and they saw the tomb and how His body was placed there. ");
INSERT INTO engf35_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Then they returned and prepared spices and perfumes. But they rested on the Sabbath according to the commandment. ");
INSERT INTO engf35_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Then on the first day of the week, at early dawn, they went to the tomb carrying the spices they had prepared, along with some others. ");
INSERT INTO engf35_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","They found the stone rolled away from the tomb, ");
INSERT INTO engf35_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","but upon entering they did not find the body of the Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","And it happened, as they were greatly perplexed about this, that wow, two men stood by them in dazzling clothing! ");
INSERT INTO engf35_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Then, as they were afraid and bowed their faces to the ground, they said to them: “Why do you seek the living One among the dead? ");
INSERT INTO engf35_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","He is not here, but is risen! Remember how He told you while still in Galilee, ");
INSERT INTO engf35_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","saying, ‘The Son of the Man must be delivered into the hands of sinful men, and be crucified, and the third day rise again.’ ” ");
INSERT INTO engf35_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","And they remembered His words. ");
INSERT INTO engf35_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Then they returned from the tomb and reported all these things to the Eleven, and to all the rest. ");
INSERT INTO engf35_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","They were Mary Magdalene, Joanna, Mary the mother of James, and the others with them, who told these things to the apostles. ");
INSERT INTO engf35_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","But their words seemed to them like nonsense, and they disbelieved them. ");
INSERT INTO engf35_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","(But Peter had gotten up and run to the tomb, and stooping down he saw the linen strips lying by themselves; and he departed, marveling to himself at what had happened.) ");
INSERT INTO engf35_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","And then that same day two of them were going to a village called Emmaus, which was about seven miles from Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","And they were conversing with each other about all that had happened. ");
INSERT INTO engf35_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","And then, as they were conversing and discussing, Jesus Himself came up and started going with them. ");
INSERT INTO engf35_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","But their eyes were restrained, in order that they not recognize Him. ");
INSERT INTO engf35_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","So He said to them, “What words are these that you are exchanging with one another as you walk, and are gloomy?” ");
INSERT INTO engf35_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Then the one whose name was Cleopas answered and said to Him, “Are you the only one living in Jerusalem who doesn't know the things that have happened there in these days?” ");
INSERT INTO engf35_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","He said to them, “What things?” So they said to Him: “The things concerning Jesus the Natsorean, how the man was a prophet mighty in deed and word before God and all the people, ");
INSERT INTO engf35_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","and how the chief priests and our rulers handed him over to be condemned to death, and they crucified him. ");
INSERT INTO engf35_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","And we were hoping that it was He who was going to redeem Israel! Further, besides all this, today is the third day since these things happened. ");
INSERT INTO engf35_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Moreover certain women of our group astonished us—arriving early at the tomb, ");
INSERT INTO engf35_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","and not finding his body, they came saying that they had even seen a vision of angels, who said he was alive. ");
INSERT INTO engf35_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","And certain of those who were with us went to the tomb and found it just as the women had said; but him they did not see.” ");
INSERT INTO engf35_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Then He said to them: “O foolish ones, and slow of heart to believe in all that the Prophets have spoken! ");
INSERT INTO engf35_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Was it really not necessary for the Christ to suffer these things, and to enter into His glory?” ");
INSERT INTO engf35_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","And beginning from Moses, and then all the Prophets, He explained to them in all the Scriptures the things concerning Himself. ");
INSERT INTO engf35_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Then they approached the village where they were going, and He made as though He would keep going. ");
INSERT INTO engf35_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","But they constrained Him, saying, “Stay with us, because it is toward evening, and the day is far spent.” So He went in to stay with them. ");
INSERT INTO engf35_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","And then, as He was reclining with them, He took the bread, blessed and broke it, and gave it to them. ");
INSERT INTO engf35_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Then their eyes were opened and they recognized Him; and He became invisible to them. ");
INSERT INTO engf35_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","They said to one another, “Were not our hearts burning within us while He talked to us on the road, and while He opened the Scriptures to us?” ");
INSERT INTO engf35_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","So they got up forthwith and returned to Jerusalem, where they found the Eleven gathered together; also those with them, ");
INSERT INTO engf35_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","who said, “The Lord is risen indeed, and has appeared to Simon!” ");
INSERT INTO engf35_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Then they described what happened on the road, and how He was known to them in the breaking of the bread. ");
INSERT INTO engf35_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","As they were saying these things, indeed, Jesus Himself stood in their midst, and He said to them, “Peace to you.” ");
INSERT INTO engf35_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","But they, terrified, supposed they were seeing a ghost, and were becoming fearful. ");
INSERT INTO engf35_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","And He said to them: “Why are you troubled?” and “Why do doubts arise in your hearts? ");
INSERT INTO engf35_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Look at my hands and feet; it is I myself! Feel me and see; a spirit does not have flesh and bones, as you see I have.” ");
INSERT INTO engf35_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","And saying this He showed them His hands and His feet. ");
INSERT INTO engf35_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","But as they were still disbelieving and marveling, because of the joy, He said to them, “Do you have any food here?” ");
INSERT INTO engf35_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","So they gave Him a piece of broiled fish and some honeycomb. ");
INSERT INTO engf35_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","And taking it He ate in their presence. ");
INSERT INTO engf35_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Then He said to them, “These are the words that I spoke to you while I was still with you, that everything that is written in the Law of Moses and the Prophets and the Psalms concerning me must be fulfilled.” ");
INSERT INTO engf35_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Then He opened their understanding so as to comprehend the Scriptures. ");
INSERT INTO engf35_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","And He said to them: “Thus it is written, and thus it was necessary for the Christ to suffer and to rise from the dead the third day, ");
INSERT INTO engf35_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","and that repentance and forgiveness of sins should be proclaimed in His name to all the nations, beginning from Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","You are witnesses of these things. ");
INSERT INTO engf35_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Take note, I am sending the Promise of my Father upon you; but you must stay in the city of Jerusalem until you are clothed with power from on High.” ");
INSERT INTO engf35_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","He led them out as far as Bethany, and lifting up His hands He blessed them. ");
INSERT INTO engf35_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","And it happened, as He was blessing them, that He left them and was carried up into heaven. ");
INSERT INTO engf35_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Worshiping Him, they returned to Jerusalem with great joy; ");
INSERT INTO engf35_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","and they were continually in the temple, praising and blessing God. Amen. ");
INSERT INTO engf35_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In the beginning was the Word, and the Word was with God, and the Word was God. ");
INSERT INTO engf35_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","He Himself existed in the beginning with God. ");
INSERT INTO engf35_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","All things came to be by Him; that is, apart from Him not even one thing that has come into being came to be. ");
INSERT INTO engf35_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In Him was life, and the Life was the Light of mankind. ");
INSERT INTO engf35_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Now the Light shines in the darkness, and the darkness has not overcome it. ");
INSERT INTO engf35_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","There was a man, sent from God, whose name was John. ");
INSERT INTO engf35_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","This man came as a witness to testify about the Light, so that all might believe through him. ");
INSERT INTO engf35_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","He himself was not the Light but was to testify about the Light— ");
INSERT INTO engf35_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","the true Light which illumines everyone who comes into the world. ");
INSERT INTO engf35_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","He was in the world, the world that came into being by Him, yet the world did not know Him. ");
INSERT INTO engf35_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","He came to His own things, yet His own people did not receive Him. ");
INSERT INTO engf35_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","But, as many as did receive Him, to them He gave the right to become children of God, to those who believe into His name: ");
INSERT INTO engf35_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","who were begotten, not by blood, nor by the desire of the flesh, nor by the will of a man, but by God. ");
INSERT INTO engf35_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","So the Word became flesh and lived among us, and we observed His glory, glory of an Only-begotten, from the Father, full of grace and truth. ");
INSERT INTO engf35_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John testified about Him and called out saying: “This is He of whom I said, ‘The One coming after me is now ahead of me, because He existed before I did.’ ” ");
INSERT INTO engf35_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Now we have all received from His fullness, yes, grace upon grace. ");
INSERT INTO engf35_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Because the Law was given through Moses; the Grace and the Truth came through Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","No one has ever seen God. The Only-begotten Son, who exists in the bosom of the Father, He has interpreted Him. ");
INSERT INTO engf35_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Now this is John's testimony, when the Jews sent priests and Levites from Jerusalem to ask him, “Who are you?” ");
INSERT INTO engf35_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","He confessed, he did not deny but confessed, “I am not the Christ.” ");
INSERT INTO engf35_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","So they asked him, “What then, are you Elijah?” And he says, “I am not.” “Are you ‘the Prophet’?” “No,” he answered. ");
INSERT INTO engf35_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","So they said to him: “Who are you?—so that we may give an answer to those who sent us. What do you say about yourself?” ");
INSERT INTO engf35_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","He said, “I am ‘the voice of one calling out: “Make the Lord's road straight in the wilderness,” ’ just as the prophet Isaiah said.” ");
INSERT INTO engf35_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Now those who had been sent were from the Pharisees. ");
INSERT INTO engf35_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","So they asked him saying, “Why then do you baptize if you are not the Christ, nor Elijah, nor ‘the Prophet’?” ");
INSERT INTO engf35_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John answered them saying: “I baptize with water, but among you stands One whom you do not know. ");
INSERT INTO engf35_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","He is the One coming after me who is now ahead of me, whose sandal strap I am not worthy to loose.” ");
INSERT INTO engf35_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","These things happened in Bithabara, across the Jordan, where John was baptizing. ");
INSERT INTO engf35_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","The next day John sees Jesus coming toward him and says: “Look! The Lamb of God who takes away the sin of the world! ");
INSERT INTO engf35_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","This is He of whom I said, ‘After me comes a man who is now ahead of me, because He existed before I did.’ ");
INSERT INTO engf35_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I did not know Him; but so that He should be revealed to Israel, that is why I came baptizing with water.” ");
INSERT INTO engf35_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","And John testified saying: “I observed the Spirit coming down like a dove out of heaven, and He rested upon Him. ");
INSERT INTO engf35_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Now I did not know Him, but He who sent me to baptize with water, He said to me, ‘The One upon whom you see the Spirit coming down and resting—this is He who baptizes with the Holy Spirit.’ ");
INSERT INTO engf35_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","So I have seen and testified that this is the Son of God.” ");
INSERT INTO engf35_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Again the next day John was standing with two of his disciples. ");
INSERT INTO engf35_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","And seeing Jesus walking by, he says, “Look, the Lamb of God!” ");
INSERT INTO engf35_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","The two disciples heard him speak, and they followed Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","So turning and observing them following Jesus says to them, “What do you want?” So they said to Him, “Rabbi” (which translated means ‘Teacher’), “where are You staying?” ");
INSERT INTO engf35_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","He says to them, “Come and see.” So they went and saw where He was staying, and stayed with Him that day—it was about the tenth hour. ");
INSERT INTO engf35_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","One of the two who heard John and followed Him was Andrew, Simon Peter's brother. ");
INSERT INTO engf35_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","He first finds his own brother Simon and says to him, “We have found the Messiah” (which is translated ‘Christ’). ");
INSERT INTO engf35_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","And he led him to Jesus. Looking at him Jesus said, “You are Simon, the son of Jonah; you will be called Cephas” (which is translated ‘Stone’). ");
INSERT INTO engf35_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","The next day He decided to go to Galilee, so He finds Philip and says to him, “Follow me.” ");
INSERT INTO engf35_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Now Philip was from Bethsaida, the hometown of Andrew and Peter.) ");
INSERT INTO engf35_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip finds Nathanael and says to him, “We have found the One of whom Moses in the Law—and also the prophets—wrote: Jesus the son of Joseph, from Natsareth.” ");
INSERT INTO engf35_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","So Nathanael said to him, “Can anything good come out of Natsareth?” Philip says to him, “Come and see!” ");
INSERT INTO engf35_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus saw Nathanael coming toward Him and says about him, “There, a genuine Israelite in whom there is no deceit!” ");
INSERT INTO engf35_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael says to Him, “From where do You know me?” Jesus answered and said to him, “Before Philip called you, while you were under the fig tree, I saw you.” ");
INSERT INTO engf35_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","In answer Nathanael says to Him: “Rabbi, You are the Son of God! You are the King of Israel!” ");
INSERT INTO engf35_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus answered and said to him: “You believe because I said that I saw you under the fig tree? You will see greater than these.” ");
INSERT INTO engf35_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","And He says to him, “I tell you (pl) most assuredly, later on you will see the heaven opened and the angels of God ascending and descending upon the Son of the Man.” ");
INSERT INTO engf35_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","On the third day a wedding took place in Cana of Galilee, and Jesus' mother was there. ");
INSERT INTO engf35_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Now both Jesus and His disciples had been invited to the wedding. ");
INSERT INTO engf35_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","So when the wine had given out, Jesus' mother says to Him, “They don't have any wine!” ");
INSERT INTO engf35_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus says to her: “What is that to you and me, woman? My time has not yet come.” ");
INSERT INTO engf35_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","His mother says to the servants, “Do whatever He may tell you.” ");
INSERT INTO engf35_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","(Now there were six stone waterpots set there, according to the purification rites of the Jews, containing 20 or 30 gallons each.) ");
INSERT INTO engf35_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus says to them, “Fill the pots with water.” So they filled them to the brim. ");
INSERT INTO engf35_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","So He says to them, “Now, draw some out and take it to the master of ceremonies.” So they took it. ");
INSERT INTO engf35_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Well, when the master of ceremonies tasted the water that had become wine—he did not know where it came from, but the servants who had drawn the water knew—he calls the bridegroom ");
INSERT INTO engf35_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","and says to him: “Everybody serves the good wine first, then, when people are intoxicated, the inferior. You have kept the good wine until now!” ");
INSERT INTO engf35_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","This, the first of the miraculous signs, Jesus performed in Cana of Galilee and revealed His glory; and His disciples believed into Him. ");
INSERT INTO engf35_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","After this He went down to Capernaum—He, His mother, His brothers, and His disciples—but they did not stay there many days. ");
INSERT INTO engf35_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Now the Jewish Passover was near, so Jesus went up to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","And in the Temple He found people selling oxen and sheep and doves, also the moneychangers at work. ");
INSERT INTO engf35_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","When He had made a scourge out of cords, He drove all out of the temple, both the sheep and the oxen; and as for the moneychangers, He overturned the tables and scattered the coins. ");
INSERT INTO engf35_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","And to the dove-sellers He said: “Get these things out of here! Stop turning my Father's House into a marketplace!” ");
INSERT INTO engf35_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Then His disciples remembered that it stands written, “Zeal for Your House consumes me.” ");
INSERT INTO engf35_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","So the Jews answered and said to Him, “What sign do you show us, since you do these things?” ");
INSERT INTO engf35_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus answered and said to them, “Destroy this temple, and in three days I will raise it.” ");
INSERT INTO engf35_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","So the Jews said, “It took forty-six years to build this temple, and you will raise it in three days?!” ");
INSERT INTO engf35_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","But He was speaking about the temple of His body. ");
INSERT INTO engf35_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Therefore, when He was raised from among the dead His disciples remembered that He had said this; so they believed the Scripture, even the word that Jesus had spoken. ");
INSERT INTO engf35_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Now while He was in Jerusalem at the Passover, during the feast, many believed into His name, observing the signs that He was doing. ");
INSERT INTO engf35_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","But as for Jesus Himself, He did not entrust Himself to them, because He knew all men ");
INSERT INTO engf35_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","and that He had no need that anyone should testify about man, because He Himself knew what was in man. ");
INSERT INTO engf35_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Now there was a man among the Pharisees whose name was Nicodemus, a ruler of the Jews. ");
INSERT INTO engf35_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","The same went to Jesus at night and said to Him, “Rabbi, we know that you have come as a teacher from God, because no one can do these signs that you do unless God is with him.” ");
INSERT INTO engf35_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus answered and said to him, “Most assuredly I say to you, unless someone is begotten from Above, he is not able to see the kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus says to Him: “How can a man be begotten, being old? He can't enter his mother's womb a second time and be born, can he?” ");
INSERT INTO engf35_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus answered: “Most assuredly I say to you, unless someone is begotten by water and Spirit he is not able to enter the kingdom of God. ");
INSERT INTO engf35_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","That which has been begotten by the flesh is flesh, and that which has been begotten by the Spirit is spirit. ");
INSERT INTO engf35_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Do not be perplexed that I said to you, ‘You (pl) need to be begotten from Above.’ ");
INSERT INTO engf35_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","The wind blows where it wishes, and you (sg) hear its sound, but you do not know where it comes from or where it goes. So it is with everyone who has been begotten by the Spirit.” ");
INSERT INTO engf35_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus answered and said to Him, “How can these things be?” ");
INSERT INTO engf35_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus answered and said to Him: “You are the teacher of Israel, yet you do not understand these things? ");
INSERT INTO engf35_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Most assuredly I say to you, we speak what we know and testify to what we have seen, but you (pl) do not receive our testimony. ");
INSERT INTO engf35_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","If I have told you earthly things and you do not believe, how will you believe if I should tell you the heavenly? ");
INSERT INTO engf35_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","No one has gone up into Heaven except the One who came down out of Heaven —the Son of the Man, who is in Heaven. ");
INSERT INTO engf35_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Also, just as Moses lifted up the snake in the wilderness, just so the Son of the Man must be lifted up, ");
INSERT INTO engf35_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","so that everyone who believes into Him should not be wasted, but should have eternal life. ");
INSERT INTO engf35_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Because God loved the world so much that He gave His only begotten Son, so that everyone who believes into Him should not be wasted, but should have eternal life. ");
INSERT INTO engf35_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","For God did not send His Son into the world in order to condemn the world, but so that the world might be saved through Him. ");
INSERT INTO engf35_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","The one believing into Him is not condemned, but the one not believing has already been condemned, because he has not believed into the name of the only begotten Son of God. ");
INSERT INTO engf35_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Now this is the basis for the condemning, that the Light has come into the world, but the people loved the darkness rather than the Light, because their deeds were malignant. ");
INSERT INTO engf35_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","For whoever practices evil hates the Light and does not come to the Light, so that his deeds may not be exposed. ");
INSERT INTO engf35_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","But whoever does the truth comes to the Light so that his deeds may be clearly seen, that they are done in God.” ");
INSERT INTO engf35_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","After these things Jesus, with His disciples, went into the Judean countryside, and there He spent time with them and baptized. ");
INSERT INTO engf35_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Now John also was baptizing in Aenon, near Salem, because there was plenty of water there. And people were coming and being baptized; ");
INSERT INTO engf35_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","for John had not yet been thrown into prison. ");
INSERT INTO engf35_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Then some of John's disciples had an argument with a Judean about purification. ");
INSERT INTO engf35_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","So they came to John and said to him, “Rabbi, the One who was with you across the Jordan, about whom you have testified—well, here He is baptizing, and everyone is flocking to Him!” ");
INSERT INTO engf35_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John answered and said: “A person can receive nothing unless it has been given to him from Heaven. ");
INSERT INTO engf35_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","You yourselves can testify that I said, ‘I am not the Christ, but I have been sent ahead of Him.’ ");
INSERT INTO engf35_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","He who has the bride is the bridegroom, but the friend of the bridegroom, who stands by and hears him, has great joy at the bridegroom's voice. So this my joy has been fulfilled. ");
INSERT INTO engf35_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","He must increase, but I must decrease. ");
INSERT INTO engf35_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“He who comes from Above is above all; he who is from the earth is earthly, and speaks of the earth. He who comes from Heaven is above all. ");
INSERT INTO engf35_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","And to what He has seen and heard He testifies, yet no one receives His testimony. ");
INSERT INTO engf35_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","The one who receives His testimony certifies that God is true. ");
INSERT INTO engf35_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","For He whom God sent speaks God's words, because God does not give the Spirit by measure. ");
INSERT INTO engf35_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","The Father loves the Son and has given all things into His hand. ");
INSERT INTO engf35_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","The one believing into the Son has eternal life, but the one disobeying the Son will not see the Life, but the wrath of God will remain upon him.” ");
INSERT INTO engf35_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Now when Jesus knew that the Pharisees had heard, “Jesus is making and baptizing more disciples than John” ");
INSERT INTO engf35_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(although Jesus Himself was not baptizing, but His disciples), ");
INSERT INTO engf35_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","He left Judea and went away into Galilee. ");
INSERT INTO engf35_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Now He needed to go through Samaria; ");
INSERT INTO engf35_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","so He comes to a city of Samaria called Sychar, near the plot of land that Jacob gave to his son Joseph. ");
INSERT INTO engf35_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Now Jacob's well was there; so Jesus, being worn out from the journey, sat as He was by the well. It was about 6 p.m. ");
INSERT INTO engf35_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A woman of Samaria comes to draw water. Jesus says to her, “Give me a drink.” ");
INSERT INTO engf35_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(His disciples had gone into the town to buy food.) ");
INSERT INTO engf35_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","So the Samaritan woman says to Him, “How can you, being a Jew, ask a drink from me, being a Samaritan woman?” (for Jews do not associate with Samaritans). ");
INSERT INTO engf35_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus answered and said to her: “If you knew the gift of God, and who is the one saying to you, ‘Give me a drink,’ you would have asked him and he would have given you living water.” ");
INSERT INTO engf35_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","The woman says to Him: “Sir, you don't even have a bucket, and the well is deep; so where do you get this living water? ");
INSERT INTO engf35_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","You aren't greater than our father Jacob, are you? He gave us the well and drank from it himself, as did his sons and his livestock.” ");
INSERT INTO engf35_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus answered and said to her: “Everyone who drinks of this water will thirst again, ");
INSERT INTO engf35_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","but whoever drinks of the water that I will give him will never ever thirst; rather, the water that I will give him will become in him a spring of water, welling up into eternal life.” ");
INSERT INTO engf35_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","The woman says to Him, “Sir, give me this water! so that I may not thirst, nor come here to draw.” ");
INSERT INTO engf35_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus says to her, “Go, call your husband and come back here.” ");
INSERT INTO engf35_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","The woman answered and said, “I don't have a husband.” Jesus says to her: “You stated correctly that you do not have a husband, ");
INSERT INTO engf35_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","because you have had five husbands, and the one you have now is no husband of yours. You spoke the truth there!” ");
INSERT INTO engf35_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","The woman says to Him: “Sir, I perceive that you are a prophet. ");
INSERT INTO engf35_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Our fathers worshiped on this mountain, while you (pl) say that the place where one must worship is in Jerusalem.” ");
INSERT INTO engf35_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus says to her: “Woman, believe me, a time is coming when neither on this mountain nor in Jerusalem will you worship the Father. ");
INSERT INTO engf35_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","You Samaritans worship what you do not know; we Jews worship what we do know, because the salvation is from the Jews. ");
INSERT INTO engf35_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","But the time is coming, in fact now is, when the genuine worshipers will worship the Father in spirit and truth. Really, because the Father is looking for such people to worship Him. ");
INSERT INTO engf35_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God is Spirit, and those who worship Him must worship in spirit and truth.” ");
INSERT INTO engf35_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","The woman says to Him: “I know that Messiah is coming (who is called Christ). When He comes He will explain everything to us.” ");
INSERT INTO engf35_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus says to her, “I am He, the one who is talking with you!” ");
INSERT INTO engf35_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","At that point His disciples arrived, and they were amazed that He was talking with a woman; yet no one said, “What do you want?” or “Why are You talking with her?” ");
INSERT INTO engf35_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","So the woman left her water jar, went her way into the town, and says to the men: ");
INSERT INTO engf35_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Come see a man who told me everything I ever did! Could this be the Messiah?” ");
INSERT INTO engf35_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","So out they went from the town and started toward Him. ");
INSERT INTO engf35_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Now in the meantime the disciples were urging Him saying, “Rabbi, eat.” ");
INSERT INTO engf35_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","But He said to them, “I have food to eat that you do not know about.” ");
INSERT INTO engf35_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","So the disciples started saying to one another, “Could someone have brought Him something to eat?” ");
INSERT INTO engf35_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus says to them: “My food is to do the will of Him who sent me and to complete His work. ");
INSERT INTO engf35_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Do you not say, ‘There are four months before the harvest comes?’ Well I say, Look! Lift your eyes and observe the fields; they are white for harvest already! ");
INSERT INTO engf35_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Now he who reaps receives pay and gathers fruit into eternal life, so that both he who sows and he who reaps may rejoice together. ");
INSERT INTO engf35_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Now the saying, ‘One is the sower and another the reaper,’ is true in this: ");
INSERT INTO engf35_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I sent you to reap that for which you have not labored; others have labored and you have entered into their labors.” ");
INSERT INTO engf35_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Now many of the Samaritans from that city believed into Him because of the word of the woman, testifying that “He told me everything I ever did!” ");
INSERT INTO engf35_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","So when the Samaritans came to Him they urged Him to stay with them; and He did stay there two days. ");
INSERT INTO engf35_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Many more believed through His own word, ");
INSERT INTO engf35_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","and they kept saying to the woman, “It is not just because of what you said that we believe, because we ourselves have heard Him, and we know that this One is truly the Messiah, the Savior of the world!” ");
INSERT INTO engf35_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","So after the two days He departed from there and went on into Galilee. ");
INSERT INTO engf35_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(For Jesus Himself testified that a prophet does not have honor in his own country.) ");
INSERT INTO engf35_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","So when He came into Galilee the Galileans welcomed Him, having seen all the things that He did in Jerusalem, at the festival; for they too had gone to the festival. ");
INSERT INTO engf35_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","So Jesus went again to Cana of Galilee, where He made the water wine. Now there was a certain royal official whose son was sick in Capernaum. ");
INSERT INTO engf35_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","When this man heard that Jesus had come out of Judea into Galilee, he went to Him and implored Him to come down and heal his son, for he was about to die. ");
INSERT INTO engf35_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","So Jesus said to him, “Unless you people see signs and wonders you will not believe!” ");
INSERT INTO engf35_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","The official says to Him, “Sir, come down before my child dies!” ");
INSERT INTO engf35_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus says to him, “Go; your son lives.” Well the man believed the word that Jesus spoke to him and off he went. ");
INSERT INTO engf35_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Now while he was still going down his slaves met him and reported saying, “Your son lives!” ");
INSERT INTO engf35_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","So he inquired of them the hour in which he got better. And they said to him, “Yesterday at the seventh hour the fever left him.” ");
INSERT INTO engf35_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","So the father knew that it was at the exact hour in which Jesus told him, “Your son lives.” Both he himself and his whole household believed. ");
INSERT INTO engf35_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Again, coming out of Judea into Galilee, Jesus performed this second miraculous sign. ");
INSERT INTO engf35_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","After these things there was the feast of the Jews, so Jesus went up to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Now in Jerusalem, by the Sheep Gate, there is a pool called Bethesda, in Hebrew, which has five porches. ");
INSERT INTO engf35_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","In them a large number of sick people were lying—blind, lame, paralyzed—waiting for the moving of the water; ");
INSERT INTO engf35_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","because an angel would go down from time to time into the pool and stir up the water—then the first one to get in after the stirring of the water became well of whatever disease that was holding him. ");
INSERT INTO engf35_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Now there was a certain man there who had been sick for 38 years. ");
INSERT INTO engf35_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Seeing this man lying there and knowing that he had already been sick a long time, Jesus says to him, “Do you want to get well?” ");
INSERT INTO engf35_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","The sick man answered Him, “Sir, I have no man to throw me into the pool when the water is stirred up, but while I am coming another gets in before me.” ");
INSERT INTO engf35_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus says to him, “Get up, pick up your pallet and walk!” ");
INSERT INTO engf35_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Immediately the man became well and picked up his pallet and started to walk! ");
INSERT INTO engf35_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","But that day was a Sabbath, so the Jews said to the one who had been healed: “It's the Sabbath! You aren't allowed to carry the pallet.” ");
INSERT INTO engf35_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","He answered them: “The one who made me well—He said to me, ‘Pick up your pallet and walk.’ ” ");
INSERT INTO engf35_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","So they asked him, “Who is the man who said to you, ‘Pick up your pallet and walk’?” ");
INSERT INTO engf35_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","But the man who was cured did not know who it was, because Jesus had disappeared, there being a crowd in the place. ");
INSERT INTO engf35_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","After these things Jesus found him in the temple and said to him: “See, you are well. Don't sin any more, so that something worse doesn't happen to you.” ");
INSERT INTO engf35_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","The man went off and told the Jews that it was Jesus who had made him well. ");
INSERT INTO engf35_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","So because of this the Jews began persecuting Jesus and trying to kill Him, because He was doing these things on the Sabbath. ");
INSERT INTO engf35_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","But Jesus answered them, “Until now, my Father works, I also work.” ");
INSERT INTO engf35_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","So because of this they wanted to kill Him all the more, because He was not only breaking the Sabbath but was even saying that God was His own Father, making Himself equal with God! ");
INSERT INTO engf35_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Then Jesus answered and said to them: “Most assuredly I say to you, the Son is not able to do anything from Himself, except something He sees the Father doing; because whatever things He does, precisely these the Son also does. ");
INSERT INTO engf35_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","For the Father loves the Son and shows Him everything that He Himself is doing; and He will show Him greater works than these, so that you may marvel. ");
INSERT INTO engf35_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Now just as the Father raises the dead and gives life, just so the Son also gives life to whom He wishes. ");
INSERT INTO engf35_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","In fact the Father does not judge anyone but has committed all the judging to the Son, ");
INSERT INTO engf35_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","so that all will honor the Son just as they honor the Father. Whoever does not honor the Son does not honor the Father who sent Him. ");
INSERT INTO engf35_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Most assuredly I say to you that the one listening to my word and believing on Him who sent me has eternal life; he will not go into judging but has moved out of the death into the Life. ");
INSERT INTO engf35_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Most assuredly I say to you that a time is coming, and now is, when the dead will hear the voice of the Son of the God, and those who listen will live. ");
INSERT INTO engf35_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Because just as the Father has life in Himself, just so He gave to the Son also to have life in Himself; ");
INSERT INTO engf35_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","furthermore He gave Him the authority to pass judgment, because He is Son of Man. ");
INSERT INTO engf35_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Do not marvel at this, because a time is coming in which all those in the graves will hear His voice ");
INSERT INTO engf35_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","and will come out—those who did good things into the resurrection of life, but those who practiced evil things into the resurrection of condemnation. ");
INSERT INTO engf35_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","I am not able to do anything from myself. As I hear, I judge, and my judging is just, because I do not seek my own will but the will of the Father who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“If I testify about myself, my testimony is not valid. ");
INSERT INTO engf35_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","There is another who testifies about me, and I know that the testimony that He gives about me is true. ");
INSERT INTO engf35_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","You have sent to John and he has testified to the truth. ");
INSERT INTO engf35_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yet I do not accept the testimony from a man; but I say these things so that you may be saved. ");
INSERT INTO engf35_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","That man was a burning, shining lamp, and for a time you were willing to be glad in his light. ");
INSERT INTO engf35_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","But I have a greater testimony than John's, because the works that the Father gave me to complete—the very works that I am doing—they testify about me that the Father has sent me. ");
INSERT INTO engf35_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Further, the Father who sent me has Himself testified about me. You have neither heard His voice nor seen His form at any time. ");
INSERT INTO engf35_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nor do you have His word abiding in you, because you do not believe on the very one whom He sent. ");
INSERT INTO engf35_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","You examine the Scriptures because in them you think you have eternal life, yet they are the very ones that testify about me. ");
INSERT INTO engf35_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","But you are not willing to come to me so that you may have life. ");
INSERT INTO engf35_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“I do not accept glory from people. ");
INSERT INTO engf35_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Rather I have come to know you, that you do not have the love of God in you. ");
INSERT INTO engf35_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","I have come in my Father's name and you do not receive me; should another come in his own name, him you will receive. ");
INSERT INTO engf35_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","How can you believe, who receive glory from men and do not seek the glory that comes from the only God? ");
INSERT INTO engf35_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Do not suppose that I will accuse you before the Father. Moses is the one who accuses you, on whom you have set your hope. ");
INSERT INTO engf35_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Because if you really believed Moses you would believe me, because he wrote about me. ");
INSERT INTO engf35_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","But since you do not believe his writings, how will you believe my sayings?” ");
INSERT INTO engf35_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","After these things Jesus went over the Sea of Galilee, or Tiberias. ");
INSERT INTO engf35_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","And a huge crowd was following Him because they had seen His signs that He kept performing on the sick. ");
INSERT INTO engf35_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","So Jesus went up on the mountain and sat down there with His disciples. ");
INSERT INTO engf35_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Now the Passover, the feast of the Jews, was near.) ");
INSERT INTO engf35_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Then, raising His eyes and observing that a huge crowd was coming toward Him, Jesus says to Philip, “Where shall we buy bread so that these folks may eat?” ");
INSERT INTO engf35_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Now He said this to test him, for He Himself knew what He was about to do. ");
INSERT INTO engf35_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip answered Him, “Two hundred denarii worth of bread would not be enough for them, so that each of them could receive a little.” ");
INSERT INTO engf35_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","One of His disciples, Andrew, Simon Peter's brother, says to Him, ");
INSERT INTO engf35_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“There is a little boy here who has five loaves of barley bread and two small fish, but what are they for so many?” ");
INSERT INTO engf35_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Then Jesus said, “Make the people recline.” Now there was plenty of grass in the place; so the men reclined, about five thousand in number. ");
INSERT INTO engf35_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Then Jesus took the loaves, and having given thanks He distributed them to the disciples, and the disciples to those who were reclining; so too with the fish, as much as they wanted. ");
INSERT INTO engf35_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","So when they were full He says to His disciples, “Collect the leftover fragments so that nothing be wasted.” ");
INSERT INTO engf35_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","So they collected and filled twelve baskets with fragments from the five barley loaves that were left over from those who had eaten. ");
INSERT INTO engf35_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Now then, having seen the miraculous sign that Jesus performed the men said, “This One really is the Prophet who is to come into the world.” ");
INSERT INTO engf35_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","So Jesus, perceiving that they were about to come and take Him by force to make Him king, withdrew up the mountain again by Himself, alone. ");
INSERT INTO engf35_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Now as evening came on His disciples had gone down to the sea, ");
INSERT INTO engf35_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","and getting into the boat they started to go across the sea toward Capernaum. Well it had been dark for a while and Jesus had not come to them. ");
INSERT INTO engf35_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Further, the sea was being agitated by a strong wind blowing. ");
INSERT INTO engf35_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Then, after they had rowed some three or four miles, they see Jesus walking on the sea and coming near the boat; and they were afraid. ");
INSERT INTO engf35_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","But He said to them, “It is I; don't be afraid!” ");
INSERT INTO engf35_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Then they wanted to receive Him into the boat, and immediately the boat was at the land to which they were going. ");
INSERT INTO engf35_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","The next day the crowd that had stayed on the other side of the sea, having seen that there was no other boat there except the one into which His disciples had entered, and that Jesus had not gotten into the boat with His disciples but only His disciples had gone away— ");
INSERT INTO engf35_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","although other boats had come from Tiberias, near the place where they ate the bread after the Lord had given thanks— ");
INSERT INTO engf35_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","so when the crowd saw that neither Jesus nor His disciples were there, they got into the boats and went to Capernaum, looking for Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","When they found Him on another side of the sea they said to Him, “Rabbi, when did you get here?” ");
INSERT INTO engf35_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus answered them and said: “Most assuredly I say to you, you are not seeking me because you saw miraculous signs, but because you ate the bread and were filled. ");
INSERT INTO engf35_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Do not work for the food that wastes away but for the food that endures into life eternal, which the Son of the Man will give you; because on Him God the Father has set His seal.” ");
INSERT INTO engf35_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","So they said to Him, “What should we do so that we may work the works of God?” ");
INSERT INTO engf35_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus answered and said to them, “This is the work of God, that you believe into the One whom He sent.” ");
INSERT INTO engf35_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","So they said to Him: “Well then, what sign are you going to do so we may see and believe you? What are you going to perform? ");
INSERT INTO engf35_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Our fathers ate the manna in the desert, just as it is written: ‘He gave them bread from Heaven to eat.’ ” ");
INSERT INTO engf35_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Then Jesus said to them: “Most assuredly I say to you, Moses did not give you the bread from Heaven, but my Father gives you the true bread from Heaven. ");
INSERT INTO engf35_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","For the bread of God is the One coming down out of Heaven and giving Life to the world.” ");
INSERT INTO engf35_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Then they said to Him, “Lord, give us this bread always.” ");
INSERT INTO engf35_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","So Jesus said to them: “I am the bread of the Life. Whoever comes to me will never hunger, and whoever believes into me will never thirst. ");
INSERT INTO engf35_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","But, as I told you, you have actually seen me, yet you do not believe. ");
INSERT INTO engf35_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","All that the Father gives me will come to me, and the one who comes to me I will not throw out; ");
INSERT INTO engf35_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","because it is not to do my own will that I have come down out of Heaven, but the will of the One who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Now this is the will of the Father who sent me, that I should lose nothing out of all that He has given me, but should raise it up at the last day. ");
INSERT INTO engf35_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Again this is the will of Him who sent me, that everyone who ‘sees’ the Son and believes into Him may have eternal life, and I will raise him up at the last day.” ");
INSERT INTO engf35_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Then the Jews started complaining about Him, because He said, “I am the bread that came down out of Heaven.” ");
INSERT INTO engf35_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","And they were saying: “Isn't this Jesus the son of Joseph, whose father and mother we know? So how can he say, ‘I have come down out of Heaven’?” ");
INSERT INTO engf35_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","So Jesus answered and said to them: “Stop complaining among yourselves. ");
INSERT INTO engf35_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No one is able to come to me unless the Father who sent me draws him, and I will raise him up at the last day. ");
INSERT INTO engf35_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","It is written in the prophets, ‘And they will all be taught by God.’ Therefore everyone who listens and learns from the Father comes to me. ");
INSERT INTO engf35_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","(Not that anyone has seen the Father, except the One who is from God—He has seen the Father.) ");
INSERT INTO engf35_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Most assuredly I say to you: the one believing into me has eternal life. ");
INSERT INTO engf35_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“I am the bread of the Life. ");
INSERT INTO engf35_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Your fathers ate manna in the desert, and they died. ");
INSERT INTO engf35_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","This is the bread that comes down out of Heaven, so that anyone may eat of it and not die. ");
INSERT INTO engf35_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","I am the living bread which came down out of Heaven. If anyone eats of this bread he will live forever. Actually, the bread that I will give is my flesh, which I will give on behalf of the life of the world.” ");
INSERT INTO engf35_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","At that the Jews started quarrelling among themselves, saying, “How can this man give us his flesh to eat?!” ");
INSERT INTO engf35_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","So Jesus said to them: “Most assuredly I say to you, unless you eat the flesh of the Son of the Man and drink His blood, you do not have Life within yourselves. ");
INSERT INTO engf35_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Whoever chews my flesh and drinks my blood has eternal life, and I will raise him up at the last day. ");
INSERT INTO engf35_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Really, my flesh is genuine food and my blood is genuine drink. ");
INSERT INTO engf35_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Whoever chews my flesh and drinks my blood abides in me and I in him. ");
INSERT INTO engf35_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Just as the living Father sent me and I live because of the Father, so also the one who feeds on me will live because of me. ");
INSERT INTO engf35_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","This is the bread that came down out of Heaven. Whoever feeds on this bread of mine will live forever (in contrast to your fathers who ate the manna and died).” ");
INSERT INTO engf35_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","He said these things while teaching in a synagogue in Capernaum. ");
INSERT INTO engf35_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Therefore, upon hearing this many from among His disciples said: “This word is hard! Who is able to hear it?” ");
INSERT INTO engf35_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","So Jesus, knowing in Himself that His disciples were complaining about this, said to them: “Does this offend you? ");
INSERT INTO engf35_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","What if you should see the Son of the Man going up to where He was at first? ");
INSERT INTO engf35_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","The Spirit is the One who makes alive; the flesh does not benefit anything. The words that I speak to you are spirit, are Life. ");
INSERT INTO engf35_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","But there are some among you who do not believe.” (For Jesus knew from the start who they were who did not believe, and who was betraying Him.) ");
INSERT INTO engf35_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","And He said, “That is why I told you that no one can come to me unless it has been granted to him by my Father.” ");
INSERT INTO engf35_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","From that time many of His disciples turned back and stopped going around with Him. ");
INSERT INTO engf35_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","So Jesus said to the twelve, “You don't want to go away too, do you?” ");
INSERT INTO engf35_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","So Simon Peter answered Him: “Lord, to whom shall we go? You have the words of eternal life. ");
INSERT INTO engf35_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Further, we have come to believe and to know that you are the Christ, the Son of the Living God!” ");
INSERT INTO engf35_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","He said to them: “Did I myself not choose you twelve? Yet one of you is a devil.” ");
INSERT INTO engf35_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","He was referring to Judas Iscariot, son of Simon, for it was he who would betray Him, being one of the twelve. ");
INSERT INTO engf35_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","After these things Jesus continued to move about in Galilee, since He did not wish to move about in Judea because the Jews were wanting to kill Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Now the Jews' Feast of Tabernacles was near. ");
INSERT INTO engf35_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","So His brothers said to Him: “Leave here and go up into Judea so your disciples also may see the works that you are doing, ");
INSERT INTO engf35_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","because no one does anything in secret while he actually wants to be in evidence. Since you are doing these things, show yourself to the world!” ");
INSERT INTO engf35_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","For not even His brothers were believing into Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","So Jesus says to them: “My time is not here yet, but your time is always available. ");
INSERT INTO engf35_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","The world cannot hate you, but does hate me, because I testify about it that its works are malignant. ");
INSERT INTO engf35_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","You guys go up to this feast; I am not going up yet to this feast, because my time has not yet fully come.” ");
INSERT INTO engf35_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","So upon saying these things to them He stayed on in Galilee. ");
INSERT INTO engf35_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Now when His brothers had gone up to the feast, then He too went up, not openly but in secret like. ");
INSERT INTO engf35_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","So the Jews were looking for Him at the feast and saying, “Where is he?” ");
INSERT INTO engf35_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","And there was a lot of murmuring about Him among the crowds. Some were saying, “He is good”; others were saying, “On the contrary, he's deceiving the people.” ");
INSERT INTO engf35_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","However, no one was talking openly about Him for fear of the Jews. ");
INSERT INTO engf35_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Now when the feast was already half over Jesus went up into the temple and started to teach. ");
INSERT INTO engf35_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","And the Jews were marveling saying, “How is this man learned, not having been educated?” ");
INSERT INTO engf35_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","So Jesus answered them and said: “What I teach is not mine, but His who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","If anyone wants to do His will, he will know concerning the teaching, whether it is from God or whether I am speaking on my own. ");
INSERT INTO engf35_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Someone who speaks on his own is seeking his own glory; but He who seeks the glory of the One who sent Him, He is true, and there is no unrighteousness in Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Did not Moses give you the Law? And yet not one of you keeps the Law! Why do you want to kill me?” ");
INSERT INTO engf35_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","The crowd answered and said, “You must have a demon! Who wants to kill you?” ");
INSERT INTO engf35_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus answered and said to them: “I did one work, and you all marvel. ");
INSERT INTO engf35_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Consider this: Moses gave you circumcision (not that it comes from Moses, but from the patriarchs), and you circumcise a man on the Sabbath. ");
INSERT INTO engf35_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","If a man receives circumcision on the Sabbath, so that the Law of Moses won't be broken, are you angry at me because I made a whole man well on the Sabbath? ");
INSERT INTO engf35_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Stop judging on the basis of appearances, but judge the righteous judgment.” ");
INSERT INTO engf35_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Now some of the Jerusalemites were saying: “Isn't this the man they are wanting to kill? ");
INSERT INTO engf35_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yet look! He is speaking openly and they are saying nothing to Him. Could it be true that the rulers know that this is really the Christ? ");
INSERT INTO engf35_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","On the other hand, we know where this man is from; but whenever the Christ comes nobody knows where He is from.” ");
INSERT INTO engf35_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","So Jesus called out in the temple, teaching and saying: “You do know me, and you know where I am from. Yet I have not come on my own, but the One who sent me is true, whom you do not know. ");
INSERT INTO engf35_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","I do know Him because I am from Him, and He sent me.” ");
INSERT INTO engf35_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","So they tried to arrest Him, yet no one laid a hand on Him because His hour had not yet come. ");
INSERT INTO engf35_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Now many of the crowd were believing into Him, and they were saying, “Whenever the Christ comes He won't perform more signs than these which this man has done, will He?” ");
INSERT INTO engf35_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","The Pharisees heard the crowd murmuring these things about Him, so the Pharisees and the chief priests sent operatives to arrest Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Then Jesus said: “For a little while I am still with you, and then I go to the One who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","You will look for me and not find me; also, where I am you cannot come.” ");
INSERT INTO engf35_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","So the Jews said among themselves: “Where does this fellow intend to go that we won't find him? He doesn't intend to go to the Dispersion among the Greeks and teach the Greeks, does he? ");
INSERT INTO engf35_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","What word is this that he spoke, ‘You will look for me and not find me’; also, ‘where I am you cannot come’?” ");
INSERT INTO engf35_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Now on the last and most important day of the Feast, Jesus stood up and called out saying: “If anyone thirsts, let him come to me and drink. ");
INSERT INTO engf35_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","The one believing into me, just as the Scripture has said, out from his innermost being will flow rivers of living water.” ");
INSERT INTO engf35_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Now He said this about the Spirit, whom those believing into Him were going to receive, in that the Holy Spirit had not yet been given because Jesus had not yet been glorified.) ");
INSERT INTO engf35_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","So upon hearing this word many from the crowd began to say, “This One really is ‘the Prophet’!” ");
INSERT INTO engf35_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Others were saying, “This One is the Christ!” Others were saying: “Surely the Christ isn't coming out of Galilee, is He? ");
INSERT INTO engf35_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Doesn't the Scripture say that the Christ comes out of the seed of David and from the town of Bethlehem, where David was?” ");
INSERT INTO engf35_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","So there developed a division in the crowd because of Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Further, some of them were wanting to arrest Him, but no one laid a hand on Him. ");
INSERT INTO engf35_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Then the operatives came to the chief priests and Pharisees, who said to them, “Why haven't you brought him?” ");
INSERT INTO engf35_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","The operatives answered, “No man ever spoke like this man!” ");
INSERT INTO engf35_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","So the Pharisees answered them: “You haven't been fooled too, have you? ");
INSERT INTO engf35_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","None of the rulers or the Pharisees have believed into him, have they? ");
INSERT INTO engf35_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","But this crowd that doesn't know the law is accursed!” ");
INSERT INTO engf35_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus (the one who came to Him at night, being one of them) says to them, ");
INSERT INTO engf35_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Our law doesn't judge a man before it hears him and knows what he is doing, does it?” ");
INSERT INTO engf35_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","They answered and said to him: “You aren't from Galilee too, are you? Search and see that no prophet has ever arisen out of Galilee.” ");
INSERT INTO engf35_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","So each one went to his own house. ");
INSERT INTO engf35_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus went to the Mount of Olives. ");
INSERT INTO engf35_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","And at dawn He went again into the temple, and all the people were coming to Him; so sitting down He started to teach them. ");
INSERT INTO engf35_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Then the scribes and the Pharisees bring to Him a woman caught in adultery; and placing her in the center ");
INSERT INTO engf35_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","they say to Him: “Teacher, we found this woman committing adultery, in the very act. ");
INSERT INTO engf35_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Now in our law Moses commanded that such women are to be stoned; so what do you say?” ");
INSERT INTO engf35_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","They said this to test Him, so that they might have an accusation against Him. But stooping down Jesus began to write on the ground with His finger, taking no notice. ");
INSERT INTO engf35_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","But since they kept on asking Him, straightening up He said to them, “Let the one without sin among you throw the first stone at her.” ");
INSERT INTO engf35_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","And stooping down again He continued writing on the ground. ");
INSERT INTO engf35_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Now upon hearing this, and being convicted by their conscience, they began to go out one by one, starting with the older ones down to the least. So only Jesus was left, with the woman in the center. ");
INSERT INTO engf35_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","So straightening up, and not seeing anyone except the woman, Jesus said to her: “Where are those accusers of yours? Has no one condemned you?” ");
INSERT INTO engf35_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","So she said, “No one, Lord.” Jesus said to her: “Neither do I condemn you. Go, and from now on don't sin any more!” ");
INSERT INTO engf35_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Then Jesus spoke to them again, saying: “I am the Light of the world. Whoever follows me will not walk around in the darkness, but will have the light of the Life.” ");
INSERT INTO engf35_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","So the Pharisees said to Him, “You are testifying about yourself; your testimony is not valid.” ");
INSERT INTO engf35_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus answered and said to them: “Even though I testify about myself, my testimony is valid, because I know where I came from and where I am going. But you do not know where I come from or where I am going. ");
INSERT INTO engf35_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","You are judging according to the flesh; I am not judging anyone. ");
INSERT INTO engf35_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yet even if I do judge, my judging is valid, in that I am not alone in judging, but I and the Father who sent me are together. ");
INSERT INTO engf35_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","It is written precisely in your law that the testimony of two men is valid: ");
INSERT INTO engf35_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","I am one testifying concerning myself and the Father who sent me testifies concerning me.” ");
INSERT INTO engf35_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Then they said to Him, “Where is your father?” Jesus answered: “You know neither me nor my Father. If you knew me you would also know my Father.” ");
INSERT INTO engf35_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus spoke these words in the treasury, while teaching in the temple; yet no one arrested Him, because His time had not yet come. ");
INSERT INTO engf35_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Then Jesus said to them again: “I am going away, and you will look for me, and you will die in your sin. Where I am going you cannot come.” ");
INSERT INTO engf35_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","So the Jews said, “He won't kill himself, will he, since he says, ‘Where I am going you cannot come’?” ");
INSERT INTO engf35_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","He said to them: “You are from below; I am from Above. You are of this world; I am not of this world. ");
INSERT INTO engf35_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","That is why I told you that you will die in your sins, because if you do not believe that I am, you will die in your sins.” ");
INSERT INTO engf35_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","So they said to Him, “Who are you?” And Jesus said to them: “Just what I have been saying to you from the beginning. ");
INSERT INTO engf35_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I have many things to say and to judge about you, but He who sent me is true, and what I myself have heard from Him—these things I say to the world.” ");
INSERT INTO engf35_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","They did not understand that He was speaking to them about the Father. ");
INSERT INTO engf35_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Then Jesus said to them: “When you lift up the Son of the Man, then you will know that I am and that I do nothing from myself; but just as my Father has taught me, these things I speak. ");
INSERT INTO engf35_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","And the One who sent me is with me. The Father has not left me alone, because I always do the things that please Him.” ");
INSERT INTO engf35_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","While He was saying these things many believed into Him. ");
INSERT INTO engf35_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","So Jesus said to those Jews who had believed Him: “If you abide in my word, you really are my disciples; ");
INSERT INTO engf35_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","and you will know the Truth, and the Truth will make you free.” ");
INSERT INTO engf35_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","They answered and said to Him: “We are descendants of Abraham and have never been enslaved to anyone. How can you say, ‘You will be made free’?” ");
INSERT INTO engf35_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus answered them: “I tell you most assuredly that everyone committing sin is a slave of sin. ");
INSERT INTO engf35_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Now the slave does not remain in the household forever; the son does remain forever. ");
INSERT INTO engf35_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Therefore, if the Son should make you free, you really will be free. ");
INSERT INTO engf35_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","I know that you are descendants of Abraham, but you are wanting to kill me because my word finds no place in you. ");
INSERT INTO engf35_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","On my part, I speak what I have observed with my Father, while on your part you do what you have observed with your father.” ");
INSERT INTO engf35_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","They answered and said to Him, “Our father is Abraham!” Jesus says to them: “If you were children of Abraham, you would do the works of Abraham; ");
INSERT INTO engf35_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","but now you are wanting to kill me, a man who has told you the truth which I heard from God. This sort of thing Abraham did not do! ");
INSERT INTO engf35_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","You do the works of your father.” Then they said to Him, “We were not born of fornication; we have one Father—God.” ");
INSERT INTO engf35_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","So Jesus said to them: “If God were your Father, you would love me, because I came forth from God and I am here. Further, I have not come on my own, but He sent me. ");
INSERT INTO engf35_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Why don't you understand what I say?—because you are not able to really hear my word. ");
INSERT INTO engf35_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","You are of your father the devil, and it is the desires of your father that you want to do. He was a murderer from the beginning and has not stood in the truth, because there is no truth in him. Whenever he speaks the lie he speaks from his own things, because he is a liar and the father of lying. ");
INSERT INTO engf35_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","But since I speak the truth you do not believe me. ");
INSERT INTO engf35_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Which of you convicts me of sin? So if I speak the truth, why do you not believe me? ");
INSERT INTO engf35_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","The one who is of God hears God's words; that is why you do not hear, because you are not of God.” ");
INSERT INTO engf35_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","So the Jews answered and said to Him, “We say that you are a Samaritan and have a demon—are we wrong?” ");
INSERT INTO engf35_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus answered: “I do not have a demon; rather, I honor my Father, while you dishonor me. ");
INSERT INTO engf35_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yet I do not seek my glory; there is One who seeks and judges. ");
INSERT INTO engf35_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Most assuredly I say to you, if anyone should keep my word he will never ever see death.” ");
INSERT INTO engf35_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","So the Jews said to Him: “Now we know that you have a demon! Abraham died and so did the prophets; yet you say, ‘If anyone should keep my word he will never ever taste death’! ");
INSERT INTO engf35_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Surely you aren't greater than our father Abraham, who died? And the prophets are dead. Who do you make yourself out to be?” ");
INSERT INTO engf35_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus answered: “If I glorify myself, my glory is nothing. It is my Father who glorifies me, of whom you say, ‘He is our God.’ ");
INSERT INTO engf35_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yet you have not known Him, but I do know Him. And if I should say that I do not know Him I would be a liar just like you (pl); but I do know Him and I keep His word. ");
INSERT INTO engf35_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Your father Abraham was overjoyed to see my day; yes, he saw it and rejoiced.” ");
INSERT INTO engf35_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","So the Jews said to Him, “You are not yet fifty years old, and you have seen Abraham?!” ");
INSERT INTO engf35_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus said to them, “Most assuredly I say to you, before Abraham came to be, I AM!” ");
INSERT INTO engf35_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Then they picked up stones to throw at Him; but Jesus was concealed and went out of the temple, going through the middle of them; yes, that is how He got away! ");
INSERT INTO engf35_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Now as He was passing by He saw a man blind from birth. ");
INSERT INTO engf35_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","And His disciples asked Him saying, “Rabbi, who sinned, this man or his parents, in that he was born blind?” ");
INSERT INTO engf35_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus answered: “Neither this man nor his parents sinned, but so that the works of God might be displayed in him. ");
INSERT INTO engf35_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I must accomplish the works of Him who sent me while it is day; night is coming when no one can work. ");
INSERT INTO engf35_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","While I am in the world, I am the Light of the world.” ");
INSERT INTO engf35_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Upon saying these things He spat on the ground and made mud with the saliva, and spread the mud on the blind man's eyes. ");
INSERT INTO engf35_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","And He said to him, “Go wash in the pool of Siloam” (which is translated, ‘Sent’). So he went and washed, and came away seeing! ");
INSERT INTO engf35_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Then the neighbors and those who previously had seen that he was blind started saying, “Isn't this the man who sat begging?” ");
INSERT INTO engf35_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Others said, “This is he”; still others, “He is like him.” He kept saying, “I'm the one!” ");
INSERT INTO engf35_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","So they said to him, “How were your eyes opened?” ");
INSERT INTO engf35_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","He answered and said: “A man called Jesus made mud and anointed my eyes and said to me, ‘Go to the pool of Siloam and wash.’ So when I went and washed, I saw!” ");
INSERT INTO engf35_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Then they said to him, “Where is He?” He says, “I don't know.” ");
INSERT INTO engf35_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","They bring the man who was formerly blind to the Pharisees. ");
INSERT INTO engf35_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Now it was a Sabbath when Jesus made the mud and opened his eyes.) ");
INSERT INTO engf35_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","So once again the Pharisees also asked him how he had received his sight. So he said to them, “He put mud on my eyes, and I washed, and I see.” ");
INSERT INTO engf35_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Then some of the Pharisees said, “This man cannot be from God, because he does not keep the Sabbath,” Others were saying, “How can a sinful man do such signs?” And there was a division among them. ");
INSERT INTO engf35_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","So they address the blind man again, “What do you say about him, in that he opened your eyes?” He said, “He is a prophet.” ");
INSERT INTO engf35_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","However the Jews did not believe concerning him that he was blind and received sight until they summoned the parents of the one who had received sight. ");
INSERT INTO engf35_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","And they asked them saying: “Is this your son, whom you say was born blind? How then does he now see?” ");
INSERT INTO engf35_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","So his parents answered them and said: “We know that this is our son, and that he was born blind; ");
INSERT INTO engf35_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","but by what means he now sees we don't know, or who opened his eyes we don't know. He is of age. Ask him. He will speak for himself.” ");
INSERT INTO engf35_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","His parents said these things because they feared the Jews, because the Jews had already agreed that if anyone confessed Him to be Christ he would be barred from the synagogue. ");
INSERT INTO engf35_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","That is why his parents said, “He is of age; ask him.” ");
INSERT INTO engf35_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","So they summoned the man who had been blind a second time and said to him: “Give glory to God! We know that this man is a sinner.” ");
INSERT INTO engf35_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","So he answered and said: “That He is a sinner, I do not know. One thing I do know, that having been blind I now see!” ");
INSERT INTO engf35_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","So they said to him again: “What did he do to you? How did he open your eyes?” ");
INSERT INTO engf35_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","He answered them: “I already told you and you didn't listen. Why do you want to hear it again? You don't want to become His disciples too, do you?” ");
INSERT INTO engf35_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","They reviled him and said: “You are that fellow's disciple, but we are Moses' disciples. ");
INSERT INTO engf35_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","We know that God spoke to Moses; but this fellow—we don't know where he's from.” ");
INSERT INTO engf35_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","The man answered and said to them: “Why, this is remarkable—you don't know where He is from; yet He opened my eyes! ");
INSERT INTO engf35_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Now we know that God doesn't listen to sinners; but if anyone is God-fearing and does His will, to him He listens. ");
INSERT INTO engf35_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Since time began it was never heard that anyone opened the eyes of a person born blind. ");
INSERT INTO engf35_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","If this man were not from God he would not be able to do anything.” ");
INSERT INTO engf35_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","They answered and said to him, “You were totally born in sins, and you are teaching us?” And they expelled him. ");
INSERT INTO engf35_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus heard that they had expelled him, and finding him He said to him, “Do you believe into the Son of God?” ");
INSERT INTO engf35_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","He answered and said, “And who is He, Lord, that I may believe into Him?” ");
INSERT INTO engf35_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","So Jesus said to him, “You have both seen Him and He is the One who is speaking with you.” ");
INSERT INTO engf35_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","So he said, “Lord, I believe!” And he worshiped Him. ");
INSERT INTO engf35_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","And Jesus said, “I came into this world for judgment, so that those who do not see may see, and those who ‘see’ may become blind.” ");
INSERT INTO engf35_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","And some of the Pharisees who were with Him heard these words and said to Him, “We aren't blind too, are we?” ");
INSERT INTO engf35_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus said to them: “If you were ‘blind’ you would not have sin. But now you say, ‘We see,’ so your sin remains. ");
INSERT INTO engf35_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Most assuredly I say to you, he who does not enter the sheepfold by the door, but climbs up some other way, the same is a thief and a robber. ");
INSERT INTO engf35_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","But he who enters by the door is a shepherd of the sheep. ");
INSERT INTO engf35_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","To him the doorkeeper opens, and the sheep hear his voice; and he calls his own sheep by name and leads them out. ");
INSERT INTO engf35_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","And whenever he takes out his own sheep he goes ahead of them, and the sheep follow him because they know his voice. ");
INSERT INTO engf35_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","But they will not follow a stranger; rather they will run away from him, because they do not know the voice of strangers.” ");
INSERT INTO engf35_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus gave them this illustration, but they did not understand what He was telling them. ");
INSERT INTO engf35_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Then Jesus addressed them again: “Most assuredly I say to you, I am the door of the sheep. ");
INSERT INTO engf35_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","All who ever came before me are thieves and robbers, but the sheep did not listen to them. ");
INSERT INTO engf35_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","I am the door. If anyone enters by me, he will be saved, and will go in and out and find pasture. ");
INSERT INTO engf35_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","The thief comes only in order to steal, and to kill, and to destroy. I have come so that they may have life, and have it abundantly. ");
INSERT INTO engf35_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“I am the good shepherd. The good shepherd lays down his life on behalf of the sheep. ");
INSERT INTO engf35_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","But the hired man, not being the shepherd and not owning the sheep, sees the wolf coming and abandons the sheep, and runs away; and the wolf snatches the sheep and scatters them. ");
INSERT INTO engf35_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Now the hired man runs away because he is a hired man and it does not matter to him about the sheep. ");
INSERT INTO engf35_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“I am the good shepherd, and I know my own sheep, and I am known by them. ");
INSERT INTO engf35_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Just as the Father knows me, I also know the Father, and I lay down my life on behalf of the sheep. ");
INSERT INTO engf35_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","I also have other sheep, that are not of this fold; I must bring them also, and they will listen to my voice; and there will be one flock, one shepherd. ");
INSERT INTO engf35_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Because of this the Father loves me, in that I lay down my life so that I may take it up again. ");
INSERT INTO engf35_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No one takes it from me, but I lay it down of myself. I have authority to lay it down, and I have authority to take it up again. This command I have received from my Father.” ");
INSERT INTO engf35_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Therefore there was another division among the Jews because of these words. ");
INSERT INTO engf35_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Many of them were saying: “He has a demon and is raving mad. Why do you listen to him?” ");
INSERT INTO engf35_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Others were saying: “These are not the sayings of someone who is demonized. A demon cannot open blind people's eyes, can it?” ");
INSERT INTO engf35_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Now it was the Feast of Dedication in Jerusalem; and it was winter. ");
INSERT INTO engf35_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","And Jesus was walking about in the temple, in Solomon's porch. ");
INSERT INTO engf35_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Then the Jews surrounded Him and said to Him: “How long will you keep us in suspense? If you are the Christ, tell us plainly.” ");
INSERT INTO engf35_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus answered them: “I did tell you, and you do not believe. The works that I do in my Father's name—these testify concerning me. ");
INSERT INTO engf35_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","But you do not believe because you are not among my sheep, just like I told you. ");
INSERT INTO engf35_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","My sheep hear my voice, and I know them, and they follow me. ");
INSERT INTO engf35_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","And I give them eternal life, and they will never ever be wasted; and no one will snatch them out of my hand. ");
INSERT INTO engf35_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","My Father, who has given them to me, is greater than all; and no one is able to snatch out of my Father's hand. ");
INSERT INTO engf35_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I and the Father are one.” ");
INSERT INTO engf35_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Therefore the Jews picked up stones again to stone Him. ");
INSERT INTO engf35_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus answered them: “Many good works I have shown you from my Father. For which one of them are you stoning me?” ");
INSERT INTO engf35_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","The Jews answered Him saying, “It is not for a good work that we are stoning you, but for blasphemy; precisely because you, being a man, make yourself God!” ");
INSERT INTO engf35_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus answered them: “Is it not written in your law, ‘I said, you are gods’? ");
INSERT INTO engf35_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","If He called them ‘gods’ to whom the Word of God came—and the Scripture cannot be broken— ");
INSERT INTO engf35_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","do you say ‘You are blaspheming’ to the One the Father sanctified and sent into the world because I said, ‘I am God's Son’? ");
INSERT INTO engf35_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","If I am not doing the works of my Father, do not believe me. ");
INSERT INTO engf35_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","But if I am doing them, even though you do not believe me, believe the works, so that you may know and believe that the Father is in me, and I in Him.” ");
INSERT INTO engf35_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","So they tried again to seize Him, but He escaped from their hand. ");
INSERT INTO engf35_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","He went away again across the Jordan, to the place where John was baptizing at first; and He remained there. ");
INSERT INTO engf35_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","And many came to Him and said, “Though John did not perform any sign, everything John said about this man was true.” ");
INSERT INTO engf35_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","And many of the people there believed into Him. ");
INSERT INTO engf35_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Now a certain man, Lazarus of Bethany, the village of Mary and her sister Martha, was sick. ");
INSERT INTO engf35_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(It was the Mary who later anointed the Lord with myrrh and wiped His feet with her hair whose brother Lazarus was sick.) ");
INSERT INTO engf35_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","So the sisters sent to Him saying, “Lord, please, the one you love is sick!” ");
INSERT INTO engf35_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Upon hearing it Jesus said, “This sickness is not unto death but for the glory of God, so that the Son of God may be glorified through it.” ");
INSERT INTO engf35_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","(Now Jesus loved Martha and her sister and Lazarus.) ");
INSERT INTO engf35_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","So, when He heard that he was sick He stayed where He was two more days! ");
INSERT INTO engf35_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Then after this He says to the disciples, “Let us go into Judea again.” ");
INSERT INTO engf35_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","The disciples say to Him, “Rabbi, the Jews were just now trying to stone you, and you are going back there?” ");
INSERT INTO engf35_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus answered: “Are there not twelve hours in the day? If anyone walks during the day he doesn't stumble, because he sees the light of this world. ");
INSERT INTO engf35_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","But if anyone walks in the night he does stumble, because the light is not in him.” ");
INSERT INTO engf35_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Having said these things He says to them, “Our friend Lazarus has fallen asleep, but I am going in order to awaken him.” ");
INSERT INTO engf35_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","His disciples said to Him, “Lord, if he is sleeping he will get well.” ");
INSERT INTO engf35_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","But Jesus had spoken of his death, while they thought He was talking about natural sleep. ");
INSERT INTO engf35_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","So then Jesus said to them plainly: “Lazarus died. ");
INSERT INTO engf35_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","And I am glad for your sakes that I was not there, so that you may believe. But let us go to him.” ");
INSERT INTO engf35_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Then Thomas (called Twin) said to his fellow disciples, “Let's us go too, so that we may die with Him.” ");
INSERT INTO engf35_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","So when Jesus had come, He found that he had already been in the tomb four days. ");
INSERT INTO engf35_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(Now Bethany was near Jerusalem, about two miles away, ");
INSERT INTO engf35_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","and many of the Jews had joined the women around Martha and Mary, to comfort them concerning their brother.) ");
INSERT INTO engf35_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Then Martha, when she heard that Jesus was coming, went to meet Him; but Mary remained sitting at home. ");
INSERT INTO engf35_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Then Martha said to Jesus: “Lord, if You had been here my brother would not have died. ");
INSERT INTO engf35_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","But even now I know that whatever You ask of God, God will give You.” ");
INSERT INTO engf35_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus says to her, “Your brother will rise again.” ");
INSERT INTO engf35_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha says to Him, “I know that he will rise again in the resurrection at the last day.” ");
INSERT INTO engf35_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus said to her: “I am the resurrection and the life. The one who believes into me, though he may die, will live; ");
INSERT INTO engf35_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","and everyone who both lives and believes into me will never ever die. Do you believe this?” ");
INSERT INTO engf35_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","She says to Him, “Yes, Lord, I have come to believe that You are the Messiah, the Son of God, the One coming into the world.” ");
INSERT INTO engf35_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Having said these things she went and called her sister Mary, saying privately, “The Teacher is here and is calling you!” ");
INSERT INTO engf35_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Upon hearing it she gets up quickly and goes to Him. ");
INSERT INTO engf35_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Now Jesus had not yet entered the village, but was in the place where Martha met Him. ");
INSERT INTO engf35_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Then the Jews who were with her in the house, consoling her, when they saw Mary get up quickly and go out, they followed her saying, “She is going to the tomb to weep there.”) ");
INSERT INTO engf35_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Then, when Mary came where Jesus was, upon seeing Him she fell at His feet, saying to Him, “Lord, if You had been here my brother would not have died!” ");
INSERT INTO engf35_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","So when Jesus saw her crying, and the Jews who had come with her crying, He groaned in the spirit and was troubled. ");
INSERT INTO engf35_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","And He said, “Where have you put him?” They say to Him, “Lord, come and see.” ");
INSERT INTO engf35_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus wept. ");
INSERT INTO engf35_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","So the Jews said, “See how he loved him!” ");
INSERT INTO engf35_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","But some of them said, “Couldn't this man, who opened the eyes of the blind, have also kept this one from dying?” ");
INSERT INTO engf35_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Then, groaning within Himself again, Jesus arrived at the tomb. It was a cave, and a stone was lying against it. ");
INSERT INTO engf35_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus says, “Remove the stone!” Martha, the sister of the deceased, says to Him, “Lord, he already stinks; it's been four days!” ");
INSERT INTO engf35_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus says to her, “Did I not say to you that if you believe you will see the glory of God?” ");
INSERT INTO engf35_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Then they took away the stone from where the deceased was lying. Jesus raised His eyes and said: “Father, I thank You that You heard me. ");
INSERT INTO engf35_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","I know that You always hear me, but I spoke for the sake of the crowd standing around, so that they may believe that You sent me.” ");
INSERT INTO engf35_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Upon saying these things He shouted with a loud voice, “Lazarus, come out!” ");
INSERT INTO engf35_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","And out the deceased came! Bound hand and foot with bandages, and his face wrapped in a cloth. Jesus says to them, “Loose him and let him go.” ");
INSERT INTO engf35_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","So many of the Jews who had come to Mary, and had seen what Jesus did, believed into Him. ");
INSERT INTO engf35_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","But some of them went off to the Pharisees and told them what Jesus had done. ");
INSERT INTO engf35_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Then the chief priests and the Pharisees convened a council and said: “What can we do? Because this man performs many miraculous signs; ");
INSERT INTO engf35_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","if we let him go on like this everybody will believe into him; and the Romans will come and take away both our place and our nation!” ");
INSERT INTO engf35_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","But one of them, Caiaphas, being high priest that year, said to them: “You know nothing at all! ");
INSERT INTO engf35_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nor do you consider that it is advantageous for us that one man should die on behalf of the people, rather than the whole nation perish!” ");
INSERT INTO engf35_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Now he did not say this on his own, but being high priest that year he prophesied that Jesus was about to die on behalf of the nation; ");
INSERT INTO engf35_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","and not only on behalf of the nation, but also to gather into one all the scattered children of God.) ");
INSERT INTO engf35_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","So from that day on they really plotted to kill Him. ");
INSERT INTO engf35_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Therefore Jesus no longer moved about openly among the Jews, but went away from there into the country near the wilderness, to a town called Ephraim; and He stayed there with His disciples. ");
INSERT INTO engf35_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Now the Jewish Passover was near, and many from the country went up to Jerusalem before the Passover in order to purify themselves. ");
INSERT INTO engf35_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","So they were looking for Jesus, and as they stood in the temple they were saying to each other, “What do you think—that he won't come to the feast at all?” ");
INSERT INTO engf35_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Now the chief priests and the Pharisees had together issued an edict that if anyone knew where He was he should report it, so they could arrest Him. ");
INSERT INTO engf35_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Then, six days before the Passover, Jesus came to Bethany, where Lazarus was (the deceased whom He raised from the dead). ");
INSERT INTO engf35_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","So they gave a dinner for Him there—Martha was serving, while Lazarus was one of those reclining at the table with Him. ");
INSERT INTO engf35_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Then Mary, bringing a pound of pure oil of nard, very costly, anointed Jesus' feet, and wiped His feet with her hair! And the house was filled with the fragrance of the oil. ");
INSERT INTO engf35_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Then one of His disciples, Judas Iscariot, Simon's son (who was about to betray Him), said, ");
INSERT INTO engf35_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Why wasn't this oil sold for 300 denarii and given to the poor?” ");
INSERT INTO engf35_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(Now he did not say this because the poor mattered to him, but because he was a thief and had the money box; and used to pilfer what was put in it.) ");
INSERT INTO engf35_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","So Jesus said: “Let her be; she has performed this with a view to my burial. ");
INSERT INTO engf35_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","For you always have the poor with you, but you do not always have me.” ");
INSERT INTO engf35_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Then a large crowd of the Jews learned that He was there; and they came, not only because of Jesus but also to see Lazarus, whom He had raised from the dead. ");
INSERT INTO engf35_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","So the chief priests decided to kill Lazarus as well, ");
INSERT INTO engf35_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","in that because of him many of the Jews were defecting and believing into Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","The next day a large crowd that had come to the feast, when they heard that Jesus was coming into Jerusalem, ");
INSERT INTO engf35_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","took branches from palm trees and went out to meet Him. And they started shouting: “Hosanna!” “Blessed is He who comes in the name of the Lord!” “King of Israel!” ");
INSERT INTO engf35_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","And finding a young donkey Jesus sat on it; just as it is written: ");
INSERT INTO engf35_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Fear no more, daughter of Zion. Look, your King is coming, sitting on a donkey's colt!” ");
INSERT INTO engf35_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Now His disciples did not understand these things at first; but when Jesus was glorified, then they remembered that these things were written about Him, and they had done them to Him.) ");
INSERT INTO engf35_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","So the crowd that had been with Him when He called Lazarus out of the tomb and raised him from the dead continued to testify. ");
INSERT INTO engf35_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","That is also why the crowd met Him, because they heard that He had performed this sign. ");
INSERT INTO engf35_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","So the Pharisees said among themselves: “You can see that you are not making any difference! Just look, the world has gone off after Him!” ");
INSERT INTO engf35_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Now there were some Greeks among those who went up to worship at the feast. ");
INSERT INTO engf35_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","So these men approached Philip, who was from Bethsaida in Galilee, and requested of him saying, “Sir, we want to see Jesus.” ");
INSERT INTO engf35_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip goes and tells Andrew, and in turn Andrew and Philip tell Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","But Jesus answered them saying: “The hour has come for the Son of the Man to be glorified. ");
INSERT INTO engf35_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Most assuredly I say to you, if a grain of wheat, having fallen into the ground, does not die, it remains alone; but if it dies it bears a lot of fruit. ");
INSERT INTO engf35_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","The one ‘loving’ his life will waste it, and the one ‘hating’ his life, in this world, will preserve it into eternal life. ");
INSERT INTO engf35_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","If anyone would serve me, let him follow me; and where I am, my servant will be too. Further, if anyone serves me, the Father will honor him. ");
INSERT INTO engf35_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Now my soul is distressed, and what should I say—‘Father, rescue me from this hour’? But this is why I came to this hour— ");
INSERT INTO engf35_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","‘Father, glorify your name!’ ” Then a Voice came out of Heaven, “I have both glorified it and will glorify it again!” ");
INSERT INTO engf35_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","So the crowd that was standing by and listening said that it had thundered. Others said, “An angel has spoken to Him.” ");
INSERT INTO engf35_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus answered and said: “It was not for my sake that this Voice came, but for your sakes. ");
INSERT INTO engf35_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Now is the judgment of this world; now the ruler of this world will be thrown out. ");
INSERT INTO engf35_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","While I, if I be lifted up from the earth, I will draw all people to myself.” ");
INSERT INTO engf35_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Now He said this to indicate by what kind of death He was about to die.) ");
INSERT INTO engf35_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","The people answered Him: “We have heard from the Law that the Messiah remains forever; and so how can you say, ‘The Son of the Man must be lifted up’? Who is this ‘the Son of the Man’?” ");
INSERT INTO engf35_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Then Jesus said to them: “The Light will be with you just a little longer. Walk while you have the light, so that darkness does not overtake you; the one who walks in the darkness does not know where he is going. ");
INSERT INTO engf35_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","While you have the Light, believe into the Light, so that you may become sons of light.” Jesus said these things, and going away He was hidden from them. ");
INSERT INTO engf35_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Although He had performed so many signs in their presence, they were not believing into Him; ");
INSERT INTO engf35_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","so that the word spoken by Isaiah the prophet should be fulfilled: “Lord, who has believed what we heard? And to whom has the arm of the Lord really been revealed?” ");
INSERT INTO engf35_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Therefore they were unable to believe, in that Isaiah said again: ");
INSERT INTO engf35_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“He has blinded their eyes and hardened their hearts, lest they should see with their eyes and understand with their hearts and should turn around, and I would heal them.” ");
INSERT INTO engf35_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah said these things when he saw His glory and spoke concerning Him. ");
INSERT INTO engf35_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nevertheless, even among the rulers many believed into Him, but because of the Pharisees they did not confess Him, so they would not be expelled from the synagogue; ");
INSERT INTO engf35_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","for they loved the praise of men more than the praise of God. ");
INSERT INTO engf35_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus called out and said: “The one believing into me believes not into me but into Him who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","And the one seeing me sees Him who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","I, Light, have come into the world so that everyone who believes into me will not remain in the darkness. ");
INSERT INTO engf35_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Also, if someone hears my words and does not believe, I do not judge him; because I did not come to judge the world but to save the world. ");
INSERT INTO engf35_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","The one who rejects me and does not receive my sayings has that which judges him—the word that I have spoken, that is what will judge him on the last day; ");
INSERT INTO engf35_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","because I have not spoken on my own, but the Father who sent me, He gave me a command, what I should say and what I should speak. ");
INSERT INTO engf35_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","And I know that His command is eternal life. So whatever I say, I say it just like the Father told me.” ");
INSERT INTO engf35_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Now before the Feast of the Passover, Jesus, knowing that His hour had come that He should depart from this world to the Father, having loved His own who were in the world He loved them to the end. ");
INSERT INTO engf35_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","And after supper (the devil already having put it into the heart of Judas Iscariot, Simon's son, to betray Him), ");
INSERT INTO engf35_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus, knowing that the Father had given everything into His hands, and that He had come from God and was going to God, ");
INSERT INTO engf35_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","He gets up from the meal and lays aside His garments, and taking a towel He tied it around Himself. ");
INSERT INTO engf35_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Then He poured water into the basin and began to wash the disciples' feet and to dry them with the towel with which He was wrapped. ");
INSERT INTO engf35_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","So He comes to Simon Peter, and he says to Him, “Lord, you wash my feet?!” ");
INSERT INTO engf35_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus answered and said to him, “What I am doing you do not understand now, but you will know by experience after this.” ");
INSERT INTO engf35_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter says to Him, “You will never ever wash my feet!!” Jesus answered him, “If I do not wash you, you have no part with me.” ");
INSERT INTO engf35_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter says to Him, “Lord, not only my feet, but also my hands and my head!” ");
INSERT INTO engf35_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus says to him: “One who is bathed has no need except to wash his feet, but is clean all over. And you (pl) are clean, but not all of you.” ");
INSERT INTO engf35_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(He knew who was betraying Him; that is why He said, “Not all of you are clean.”) ");
INSERT INTO engf35_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","So when Jesus had washed their feet and put His garments back on, He reclined again and said to them: “Do you know what I have done to you? ");
INSERT INTO engf35_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","You address me as ‘Teacher’ and ‘Lord’, and you speak correctly, because I am. ");
INSERT INTO engf35_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","So then, if I, Lord and Teacher, washed your feet, you also ought to wash one another's feet. ");
INSERT INTO engf35_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Because I have given you an example, so that you also should do just as I did to you. ");
INSERT INTO engf35_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Most assuredly I say to you, a slave is not greater than his owner, neither is a messenger greater than the one who sent him. ");
INSERT INTO engf35_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","If you understand these things, you are blessed if you do them. ");
INSERT INTO engf35_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“I do not speak concerning all of you—I know whom I chose. But let the Scripture be fulfilled: ‘The one eating bread with me lifted up his heel against me.’ ");
INSERT INTO engf35_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I am telling you now before it happens, so that when it does happen you will believe that I am. ");
INSERT INTO engf35_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Most assuredly I say to you, he who receives whomever I send receives me, and he who receives me receives Him who sent me.” ");
INSERT INTO engf35_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Having said these things, Jesus was distressed in His spirit and testified saying, “Most assuredly I say to you, one of you will betray me!” ");
INSERT INTO engf35_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","So the disciples started looking at each other, at a loss as to whom He meant. ");
INSERT INTO engf35_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Now one of His disciples, whom Jesus loved, was reclining beside Jesus' bosom. ");
INSERT INTO engf35_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","So Simon Peter motions to him to inquire whom it might be that He was referring to. ");
INSERT INTO engf35_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","And leaning back against Jesus' breast he says to Him, “Lord, who is it?” ");
INSERT INTO engf35_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus answers, “It is the one to whom I will give the piece of dunked bread.” And dunking the bread He gives it to Judas Iscariot, Simon's son. ");
INSERT INTO engf35_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","And after the sop, then Satan entered into him. Whereupon Jesus says to him, “What you are doing, do quickly!” ");
INSERT INTO engf35_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Now none of those reclining at the table knew why He said this to him. ");
INSERT INTO engf35_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Since Judas had the money box, some supposed that Jesus was telling him to buy what they needed for the feast, or to give something to the poor.) ");
INSERT INTO engf35_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","So having received the sop, immediately he went out. And it was night. ");
INSERT INTO engf35_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","When he had gone out Jesus says: “Now the Son of the Man has been glorified, and God has been glorified in Him. ");
INSERT INTO engf35_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Since God has been glorified in Him, God will also glorify Him with Himself, and He will do so presently. ");
INSERT INTO engf35_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Little children, I am with you just a little longer. You will look for me, and as I said to the Jews, ‘Where I am going you cannot come,’ so now I say to you. ");
INSERT INTO engf35_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“I give you a new commandment, that you love one another just as I have loved you—that you also love one another. ");
INSERT INTO engf35_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","By this all will know that you are my disciples, if you have love for one another.” ");
INSERT INTO engf35_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter says to Him, “Lord, where are you going?” Jesus answered him, “Where I am going you cannot follow me now, but later you will follow me.” ");
INSERT INTO engf35_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter says to Him: “Lord, why can't I follow you now? I will lay down my life for your sake!” ");
INSERT INTO engf35_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus answered him: “You will lay down your life for my sake? Most assuredly I say to you, no rooster can crow until you have denied me three times! ");
INSERT INTO engf35_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Do not let your (pl) heart be distressed; you believe into God and you believe into me. ");
INSERT INTO engf35_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In my Father's house are many dwellings (otherwise I would have told you). I am going away to prepare a place for you. ");
INSERT INTO engf35_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","And if I go and prepare a place for you, I will come again and take you to myself, so that where I am you may be also. ");
INSERT INTO engf35_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Now you know where I am going, and you know the way.” ");
INSERT INTO engf35_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas says to Him, “Lord, we don't know where you are going, so how can we know the way?” ");
INSERT INTO engf35_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus says to him: “I am the Way and the Truth and the Life. No one goes to the Father except through me. ");
INSERT INTO engf35_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","If you had known me, you would have known my Father as well; from now on you both know Him and have seen Him.” ");
INSERT INTO engf35_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip says to Him, “Lord, show us the Father, and it is enough for us.” ");
INSERT INTO engf35_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus says to him: “Such a long time I have been with you, and you have not known me, Philip? He who has seen me has seen the Father; so how can you say, ‘Show us the Father’? ");
INSERT INTO engf35_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Don't you believe that I am in the Father and the Father is in me? The words that I speak to you I do not speak on my own; rather it is the Father who dwells in me who does the works. ");
INSERT INTO engf35_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Believe me that I am in the Father and the Father is in me; or else, believe me because of the works themselves. ");
INSERT INTO engf35_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Most assuredly I say to you, the one believing into me, he too will do the works that I do; in fact he will do greater works than these, because I am going to my Father. ");
INSERT INTO engf35_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Further, whatever you (pl) may ask in my name, that I will do, so that the Father may be glorified in the Son. ");
INSERT INTO engf35_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","If you ask anything in my name, I will do it! ");
INSERT INTO engf35_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","If you love me, keep my commandments. ");
INSERT INTO engf35_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Also, I will ask the Father and He will give you another Enabler, so that He may stay with you throughout the age ");
INSERT INTO engf35_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","—the Spirit of the Truth, whom the world is unable to receive, because it neither sees Him nor knows Him; but you do know Him, because He is staying with you and will be in you. ");
INSERT INTO engf35_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“I will not leave you orphans; I will come to you shortly. ");
INSERT INTO engf35_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","In a little while the world will no longer see me, but you will see me. Because I live you also will live. ");
INSERT INTO engf35_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","In that day you will know that I am in my Father, and you in me, and I in you. ");
INSERT INTO engf35_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","The one who has my commandments and keeps them, he is the one who loves me. Now the one who loves me will be loved by my Father; and I will love him, and reveal myself to him.” ");
INSERT INTO engf35_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (not the Iscariot) says to Him, “Lord, just how is it that You are going to reveal Yourself to us and not to the world?” ");
INSERT INTO engf35_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus answered and said to him: “If anyone loves me he will keep my word. So my Father will love him, and we will come to him and make our home with him. ");
INSERT INTO engf35_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","The one who does not love me does not keep my words; further, the word which you hear is not mine but the Father's who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“I have spoken these things to you while being with you. ");
INSERT INTO engf35_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","But the Enabler, the Holy Spirit, whom the Father will send in my name, He will teach you all things and remind you of everything I said to you. ");
INSERT INTO engf35_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Peace I leave with you, my peace I give to you; it is not like the world gives that I give to you. Do not let your heart be distressed or intimidated. ");
INSERT INTO engf35_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“You heard me say to you, ‘I am going away and I am coming back to you.’ If you loved me you would have been glad that I said, ‘I am going to the Father,’ because my Father is greater than I. ");
INSERT INTO engf35_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","I have told you now, before it happens, so that when it does happen you may believe. ");
INSERT INTO engf35_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“I will no longer talk much with you, because the ruler of the world is approaching; actually, he has nothing in me. ");
INSERT INTO engf35_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Rather, I habitually do just as the Father commanded me, so that the world may know that I love the Father. “Get up, let us leave here. ");
INSERT INTO engf35_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“I am the vine, the true one, and my Father is the vinedresser. ");
INSERT INTO engf35_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Any branch in me which does not produce fruit He lifts up, and every one producing fruit He prunes, so that it may produce more fruit. ");
INSERT INTO engf35_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","You are already clean because of the word that I have spoken to you. ");
INSERT INTO engf35_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Abide in me and I in you. Just as a branch is incapable of producing fruit by itself, except it remains in the vine, so neither can you unless you abide in me. ");
INSERT INTO engf35_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“I am the vine, and you are the branches. The one who abides in me and I in him, he is the one who produces much fruit, because apart from me you are incapable of doing anything. ");
INSERT INTO engf35_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","If anyone does not abide in me he is thrown out, like a branch, and dries up; well they gather such and throw them into the fire, and he is burned up. ");
INSERT INTO engf35_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","If you abide in me and my sayings abide in you, you will ask whatever you desire and it will happen for you. ");
INSERT INTO engf35_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","My Father is glorified by this: that you produce much fruit; and you will become disciples to me. ");
INSERT INTO engf35_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Just as the Father has loved me, I also have loved you; abide in my love. ");
INSERT INTO engf35_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","If you keep my commandments, you will abide in my love, just as I have kept my Father's commandments and abide in His love. ");
INSERT INTO engf35_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","I have spoken these things to you so that my joy may remain in you, and that your joy may be made full. ");
INSERT INTO engf35_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","This is my commandment, that you love one another just as I have loved you. ");
INSERT INTO engf35_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","No one has greater love than this, that someone should lay down his life for his friends. ");
INSERT INTO engf35_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","You are my friends if you do whatever I command you. ");
INSERT INTO engf35_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“I no longer call you slaves, because a slave does not know what his owner is doing; rather I have called you friends, because I have made known to you everything that I heard from my Father. ");
INSERT INTO engf35_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","It was not you who chose me but I who chose you, and I appointed you so that you should go and produce fruit, and that your fruit should endure, so that whatever you may ask the Father in my name He may give you. ");
INSERT INTO engf35_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","These things I command you so that you love one another. ");
INSERT INTO engf35_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“When the world hates you, you can be sure that it has hated me first. ");
INSERT INTO engf35_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","If you were of the world, the world would be fond of its own. So because you are not of the world, but I chose you out of the world, that is why the world hates you. ");
INSERT INTO engf35_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Remember the word that I said to you, ‘A slave is not greater than his owner.’ If they persecuted me, they will also persecute you. If they kept my word, they will also keep yours. ");
INSERT INTO engf35_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Now they will do all of these things to you because of my name, in that they do not know the One who sent me. ");
INSERT INTO engf35_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","If I had not come and spoken to them, they would not be having sin, but now they have no excuse for their sin. ");
INSERT INTO engf35_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","The one who hates me hates my Father too. ");
INSERT INTO engf35_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","If I had not done among them the works that no one else has done, they would not be having sin; but now they have both seen and hated both me and my Father. ");
INSERT INTO engf35_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","However, this was so that the statement written in their law might be fulfilled, ‘They hated me without cause.’ ");
INSERT INTO engf35_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Now when the Enabler comes, whom I will send to you from the Father, the Spirit of the Truth who proceeds from the Father, He will testify concerning me. ");
INSERT INTO engf35_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","And you also will testify, because you have been with me from the beginning. ");
INSERT INTO engf35_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“I have spoken these things to you to avoid your being caused to stumble ");
INSERT INTO engf35_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","—they will excommunicate you; indeed, a time is coming when anyone who kills you will think he is offering God service! ");
INSERT INTO engf35_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","And they will do these things because they have not known either the Father or me. ");
INSERT INTO engf35_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Now I have told you these things so that when the time comes you may remember that I told you about them; I did not tell you these things from the beginning because I was with you. ");
INSERT INTO engf35_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Now then, I am going away to Him who sent me, yet none of you asks me, ‘Where are you going?’ ");
INSERT INTO engf35_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","But because I have said these things to you, sorrow has filled your heart. ");
INSERT INTO engf35_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nevertheless I am telling you the truth: it is to your advantage that I go away, because if I do not go away the Enabler will not come to you, but if I do go I will send Him to you. ");
INSERT INTO engf35_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Now when He comes he will convict the world about sin and about righteousness and about judgment: ");
INSERT INTO engf35_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","first about sin, because they do not believe into me; ");
INSERT INTO engf35_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","then about righteousness, because I am going away to my Father and you will no longer see me; ");
INSERT INTO engf35_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","then about judgment, because the ruler of this world has been judged. ");
INSERT INTO engf35_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“I still have many things to say to you but you cannot bear it now. ");
INSERT INTO engf35_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","However, when He, the Spirit of the Truth, has come, He will guide you into all the truth; for He will not speak on His own, but He will speak whatever He hears. He will also communicate to you the things that are coming. ");
INSERT INTO engf35_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","He will glorify me because He will take of what is mine and communicate it to you. ");
INSERT INTO engf35_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","All that the Father has is mine; that is why I said that He takes from what is mine and will communicate it to you. ");
INSERT INTO engf35_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“In just a little you will not see me, and in another little you will see me, because I am going to the Father.” ");
INSERT INTO engf35_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Then some of His disciples said among themselves: “What is this that He is telling us, ‘In just a little you will not see me, and in another little you will see me,’ and because ‘I am going to the Father’?” ");
INSERT INTO engf35_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","So they said: “What is this ‘little’ that He mentions? We do not know what He is talking about.” ");
INSERT INTO engf35_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Well Jesus knew that they were wanting to question Him and said to them: “Are you inquiring among yourselves about what I said, ‘In just a little you will not see me, and in another little you will see me’? ");
INSERT INTO engf35_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Most assuredly I say to you that you will weep and lament, but the world will rejoice; you will become grieved, but your grief will be turned into joy. ");
INSERT INTO engf35_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","When a woman gives birth she has pain, because her time has come; but when the child is born she no longer remembers the anguish, for joy that a human being has been born into the world. ");
INSERT INTO engf35_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","So in your turn you are now experiencing grief, but I will see you again and your heart will rejoice, and no one will take your joy from you. ");
INSERT INTO engf35_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","In that day you will not question me about anything. “Most assuredly I say to you that whatever you ask the Father in my name He will give you. ");
INSERT INTO engf35_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Until now you have not asked anything in my name. Ask and you will receive, so that your joy may be made full. ");
INSERT INTO engf35_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“I have told you these things using figures of speech, but a time is coming when I will no longer talk to you with figures of speech; rather I will tell you plainly about the Father. ");
INSERT INTO engf35_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In that day you will ask in my name; I do not say to you that I will request the Father on your behalf, ");
INSERT INTO engf35_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","because the Father Himself is fond of you, in that you have become fond of me and have believed that I came forth from God. ");
INSERT INTO engf35_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I did come forth from the Father and have come into the world. I am leaving the world again and am going to the Father.” ");
INSERT INTO engf35_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","His disciples say to Him: “Hey, now you are speaking plainly and using no figure of speech! ");
INSERT INTO engf35_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now we know that you know everything and don't need anyone to question you. By this we believe that you came forth from God.” ");
INSERT INTO engf35_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus answered them: “Do you believe now, really? ");
INSERT INTO engf35_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Listen, an hour is coming, actually it has already arrived, that you will be scattered, each to his own, and you will leave me alone. Yet I am not alone, because the Father is with me. ");
INSERT INTO engf35_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","I have spoken these things to you so that in me you may have peace. In the world you have oppression; but take heart, I have conquered the world!” ");
INSERT INTO engf35_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus spoke these things, raising His eyes to Heaven and saying: “Father, the hour has come! Glorify Your Son, so that Your Son also may glorify You, ");
INSERT INTO engf35_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","just as You gave Him authority over all humanity, so that He will give eternal life to all those whom You have given Him. ");
INSERT INTO engf35_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Now eternal life is this: that they may know You, the only true God, and the One whom You sent—Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I have glorified You on the earth. I have finished the work that You have given me to do. ");
INSERT INTO engf35_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","So now, Father, You glorify me by Your side with the glory that I had along with You before the world existed! ");
INSERT INTO engf35_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“I have revealed Your name to the men whom You have given me out of the world. They were Yours and You gave them to me, and they have kept Your word. ");
INSERT INTO engf35_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","They now know that everything You have given to me is from You; ");
INSERT INTO engf35_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","because I have given them the sayings which You have given to me; and they have received and known for sure that I came forth from You, and they have believed that You sent me. ");
INSERT INTO engf35_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I am praying for them; I am not praying for the world but for those whom You have given me, because they are yours. ");
INSERT INTO engf35_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Actually, all my things are Yours and Yours are mine, and I have been glorified in them. ");
INSERT INTO engf35_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Now I am no longer in the world, yet these are in the world, and I am coming to You. “Holy Father, keep them in Your name which You have given to me, so that they may be one just as we are. ");
INSERT INTO engf35_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","While I was with them in the world I kept them in Your name. I protected those whom You gave me, and not one of them was lost except the son of perdition, so that the Scripture might be fulfilled. ");
INSERT INTO engf35_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","But now I am coming to You, and I speak these things in the world so that they may have my joy made full in them. ");
INSERT INTO engf35_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“I have given them Your word; and the world has hated them because they are not of the world, just as I am not of the world. ");
INSERT INTO engf35_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I am not asking that You take them out of the world, but that You keep them from the malignant one. ");
INSERT INTO engf35_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","They are not of the world, just as I am not of the world. ");
INSERT INTO engf35_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sanctify them by Your Truth; Your Word is Truth. ");
INSERT INTO engf35_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Just as You sent me into the world, I also have sent them into the world. ");
INSERT INTO engf35_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","And for their sakes I sanctify myself, so that they also may be sanctified in truth. ");
INSERT INTO engf35_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“I pray not only for these, but also for those who believe into me through their word; ");
INSERT INTO engf35_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","that they all may be one, just as You, Father, are in me and I in You; that in Us they also may be one, so that the world may believe that You sent me. ");
INSERT INTO engf35_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","In fact, the glory that You gave to me I have given to them, so that they may be one just as We are one: ");
INSERT INTO engf35_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I in them and You in me, so that they may be perfected into one; also so that the world may know that You sent me, and have loved them just as You have loved me. ");
INSERT INTO engf35_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Father, those whom You have given to me, I desire that they also may be with me where I am, so that they may observe my glory, which You have given me, because You loved me before the founding of the world. ");
INSERT INTO engf35_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Righteous Father! Indeed the world has not known You, but I have known You; and these have known that You sent me. ");
INSERT INTO engf35_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yes, I have made Your name known to them and will make it known, so that the love with which You have loved me may be in them, and I in them.” ");
INSERT INTO engf35_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Having said these things Jesus went out with His disciples across the Kidron ravine, where there was a garden, which He and His disciples entered. ");
INSERT INTO engf35_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Now Judas, the one betraying Him, also knew the place, because Jesus often met there with His disciples. ");
INSERT INTO engf35_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","So Judas, having received the detachment of soldiers and operatives from the chief priests and Pharisees, he arrives there with lanterns, torches and weapons. ");
INSERT INTO engf35_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Then Jesus, knowing everything that was going to happen to Him, went forward and said to them, “Who are you looking for?” ");
INSERT INTO engf35_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","They answered Him, “Jesus the Natsorean.” Jesus says to them, “I am he.” (Now Judas, His betrayer, was also standing with them.) ");
INSERT INTO engf35_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","So when He said to them, “I am he,” they went backward and fell to the ground! ");
INSERT INTO engf35_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Then He asked them again, “Who are you looking for?” And they said, “Jesus the Natsorean.” ");
INSERT INTO engf35_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus answered: “I told you that I am he. So if it is me you are looking for, allow these men to go” ");
INSERT INTO engf35_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(so that the word that He spoke might be fulfilled, “Of those you have given me I did not lose even one”). ");
INSERT INTO engf35_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Then Simon Peter, having a sword, drew it, struck the high priest's servant and cut off his right ear. (The servant's name was Malchus.) ");
INSERT INTO engf35_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","So Jesus said to Peter: “Sheathe the sword! The cup that the Father has given me, must I not drink it?” ");
INSERT INTO engf35_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Then the detachment, the commander and the operatives of the Jews arrested Jesus and bound Him. ");
INSERT INTO engf35_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","They took Him to Annas first, because he was the father-in-law of Caiaphas, who was high priest that year. ");
INSERT INTO engf35_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Now Caiaphas was the one who had advised the Jews that it was expedient that one man should die for the people.) ");
INSERT INTO engf35_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Now Simon Peter kept following Jesus, as also the other disciple. Well that disciple was known to the high priest, so he went into the high priest's courtyard with Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","But Peter was left standing outside by the door. So the other disciple, who was known to the high priest, went out and spoke to the doorkeeper (f), and brought Peter in. ");
INSERT INTO engf35_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","So the servant girl, the doorkeeper, says to Peter, “You aren't one of this man's disciples too, are you?” He says, “I am not!” ");
INSERT INTO engf35_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Now the servants and operatives had made a charcoal fire, because it was cold, and they were standing there warming themselves. So Peter stood with them and warmed himself. ");
INSERT INTO engf35_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Then the high priest questioned Jesus about His disciples and about His teaching. ");
INSERT INTO engf35_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus answered him: “I have spoken openly to the world. I always taught in synagogue and temple, where the Jews always congregate, and I have spoken nothing in secret. ");
INSERT INTO engf35_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Why do you question me? Question those who have heard what I spoke to them. Sure, they know what I said.” ");
INSERT INTO engf35_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","But upon His saying these things one of the operatives standing by slapped Jesus saying, “Is that how you answer the high priest?” ");
INSERT INTO engf35_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus answered him, “If I spoke wrongly, identify the wrong; but if rightly, why do you hit me?” ");
INSERT INTO engf35_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","(Annas had sent Him bound to Caiaphas the high priest.) ");
INSERT INTO engf35_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Well Simon Peter was standing and warming himself. So they said to him, “You aren't one of His disciples too, are you?” So he denied it and said, “I am not!” ");
INSERT INTO engf35_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","One of the servants of the high priest, a relative of the one whose ear Peter had sliced, says, “Didn't I see you with Him in the garden?” ");
INSERT INTO engf35_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","So Peter denied again, and immediately a rooster crowed. ");
INSERT INTO engf35_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Then they led Jesus from Caiaphas to the Praetorium, and it was early morning. They themselves did not enter the Praetorium, so that they would not be defiled but could eat the Passover. ");
INSERT INTO engf35_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","So Pilate went out to them and said, “What accusation do you bring against this man?” ");
INSERT INTO engf35_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","In reply they said to him, “If he were not an evil-doer we would not have handed him over to you.” ");
INSERT INTO engf35_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","So Pilate said to them, “You take him and judge him according to your law.” So the Jews said to him, “We are not permitted to execute anyone.” ");
INSERT INTO engf35_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(This was to fulfill the statement that Jesus made, indicating what sort of death He was about to die.) ");
INSERT INTO engf35_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Then Pilate went back into the Praetorium, called Jesus and said to Him, “Are you the king of the Jews?” ");
INSERT INTO engf35_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus answered him, “Are you saying this on your own, or did others inform you about me?” ");
INSERT INTO engf35_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate answered Him: “I'm not a Jew, am I? Your own nation, that is, the chief priests handed you over to me. What have you done?” ");
INSERT INTO engf35_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus answered: “My kingdom is not of this world. If my kingdom were of this world, my subjects would fight so that I not be delivered to the Jews; but now my kingdom is not from here.” ");
INSERT INTO engf35_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","So Pilate said to Him, “You are a king then?” Jesus answered: “As you say, I am a king; for this I was born. And for this I came into the world, to testify to the Truth. Everyone who is of the Truth hears my voice.” ");
INSERT INTO engf35_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate says to Him, “What is truth?” Upon saying this he went out to the Jews again and says to them: “I find no crime in him at all. ");
INSERT INTO engf35_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Now we have a custom that I should release someone to you at the Passover; so do you want me to release the King of the Jews to you?” ");
INSERT INTO engf35_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Then they all cried out saying, “Not this fellow, but Barabbas!” Well, Barabbas was a bandit! ");
INSERT INTO engf35_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","So then Pilate took Jesus and had Him flogged. ");
INSERT INTO engf35_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","And the soldiers twisted a crown out of poisonous thorns and put it on His head; they also threw a purple robe around Him ");
INSERT INTO engf35_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","and started saying, “Hail, O King of the Jews!” And they slapped Him repeatedly. ");
INSERT INTO engf35_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate then went out again and says to them, “Look, I am bringing him out to you so that you may know that I find no crime in him at all.” ");
INSERT INTO engf35_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Then Jesus came out wearing the crown of thorns and the purple robe; and Pilate says to them, “Look at the man!” ");
INSERT INTO engf35_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Well when the chief priests and the operatives saw Him they shouted, saying, “Crucify! Crucify him!” Pilate says to them, “You take and crucify him, because I find no crime in him.” ");
INSERT INTO engf35_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","The Jews answered him, “We have a law, and according to our law he ought to die, because he made himself ‘Son of God’!” ");
INSERT INTO engf35_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hey, when Pilate heard this statement he was more afraid than ever! ");
INSERT INTO engf35_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","So back into the Praetorium he went and says to Jesus, “Where are you from?” But Jesus did not answer him. ");
INSERT INTO engf35_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","So Pilate says to Him: “Are you not speaking to me? Don't you know that I have authority to crucify you and authority to release you?” ");
INSERT INTO engf35_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus answered: “You would have no authority over me at all if it had not been given to you from Above. Therefore the one who handed me over to you has the greater sin.” ");
INSERT INTO engf35_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","From that moment Pilate really tried to release Him; but the Jews kept shouting, saying: “If you release this fellow you are no friend of Caesar's! Whoever makes himself a king is opposing Caesar!” ");
INSERT INTO engf35_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Well, upon hearing this statement Pilate led Jesus outside and sat down on the judgment seat, in a place called ‘Stone Pavement’, while in Hebrew ‘Gabatha’ ");
INSERT INTO engf35_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","(now it was the day of preparation for the Passover; the hour was about six a.m.), and he says to the Jews, “Look at your king!” ");
INSERT INTO engf35_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","But they shouted, “Out! Out! Crucify him!” Pilate says to them, “Shall I crucify your king?” The chief priests answered, “We have no king but Caesar!” ");
INSERT INTO engf35_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","So then he handed Him over to them to be crucified. So they took Jesus and lead Him away. ");
INSERT INTO engf35_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","And carrying His cross He went out to the place called ‘Skull’, which in Hebrew is called ‘Golgotha’; ");
INSERT INTO engf35_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","there they crucified Him, and two others with Him, one on either side, with Jesus in the middle. ");
INSERT INTO engf35_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Now Pilate had also written a notice, and put it on the cross; and the inscription was: JESUS THE NATSOREAN THE KING OF THE JEWS. ");
INSERT INTO engf35_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","So many of the Jews read this notice, because the place where Jesus was crucified was near the city; further, it was written in Hebrew, Greek and Latin! ");
INSERT INTO engf35_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","So the chief priests of the Jews said to Pilate, “Don't write, ‘The king of the Jews’, but that the fellow said, ‘I am the king of the Jews.’ ” ");
INSERT INTO engf35_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate answered, “What I have written, I have written!” ");
INSERT INTO engf35_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Now when the soldiers had crucified Jesus they took His clothes and made four parts, a part for each soldier. They also took His tunic, but the tunic was seamless, woven in one piece from the top. ");
INSERT INTO engf35_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","So they said among themselves, “Let's not rip it, but toss for it, to see whose it will be,” so that the Scripture might be fulfilled which says: “They divided my clothes among themselves, and for my clothing they cast a lot.” That is why the soldiers did these things. ");
INSERT INTO engf35_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Now Jesus' mother and her sister, Mary of Clopas, and Mary Magdalene were standing by His cross. ");
INSERT INTO engf35_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","So Jesus, seeing His mother, and the disciple whom He loved standing by, He says to His mother, “Woman, there is your son!” ");
INSERT INTO engf35_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Then He says to the disciple, “There is your mother!” And from that hour the disciple took her into his home. ");
INSERT INTO engf35_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","After this, knowing that everything was now accomplished so that the Scripture might be fulfilled, Jesus says, “I'm thirsty!” ");
INSERT INTO engf35_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Now a vessel full of sour wine was sitting there; so they filled a sponge with sour wine, placed it on a hyssop, and put it to His mouth. ");
INSERT INTO engf35_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Then, when He had received the sour wine, Jesus said, “Paid in full!!” And bowing His head He dismissed His spirit. ");
INSERT INTO engf35_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Now then, because it was Preparation Day, so that the bodies should not remain on the cross on the Sabbath (for that Sabbath was a high day), the Jews requested Pilate that their legs might be broken and they be removed. ");
INSERT INTO engf35_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Then the soldiers came and broke the legs of the first man and of the other one who had been crucified with Him. ");
INSERT INTO engf35_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","But upon coming to Jesus, they did not break His legs, since they saw that He had already died. ");
INSERT INTO engf35_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","But one of the soldiers pierced His side with a spear, and immediately blood and water came out. ");
INSERT INTO engf35_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","And the one who saw has testified, and his testimony is true (yes, he knows he is telling the truth), so that you may believe. ");
INSERT INTO engf35_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Because these things happened so that the Scripture should be fulfilled: “Not a bone of His will be broken.” ");
INSERT INTO engf35_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","And again another Scripture says: “They will look on Him whom they pierced.” ");
INSERT INTO engf35_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","After these things Joseph, the one from Arimathea (being a disciple of Jesus, but secretly for fear of the Jews), requested Pilate that he might remove the body of Jesus; and Pilate gave permission. So he came and removed Jesus' body. ");
INSERT INTO engf35_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Now Nicodemus also came (the one who at first came to Jesus by night), bringing a mixture of myrrh and aloes, about a hundred pounds. ");
INSERT INTO engf35_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Then they took Jesus' body and wrapped it in linen strips, with the aromatic spices, according to the burial custom of the Jews. ");
INSERT INTO engf35_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Now at the place where He was crucified there was a garden, and in the garden a new tomb in which no one had yet been buried. ");
INSERT INTO engf35_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","So that is where they put Jesus, because of the Jews' Preparation Day, since the tomb was nearby. ");
INSERT INTO engf35_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Now on the first day of the week Mary Magdalene comes to the tomb early, while it is still dark, and sees that the stone has been removed from the tomb. ");
INSERT INTO engf35_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","So she runs and comes to Simon Peter, and to the other disciple, whom Jesus loved, and says to them, “They have taken the Lord out of the tomb, and we don't know where they put Him!” ");
INSERT INTO engf35_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","So Peter and the other disciple took off, heading for the tomb. ");
INSERT INTO engf35_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Well the two started running together, and the other disciple outran Peter and got to the tomb first. ");
INSERT INTO engf35_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","And stooping to look he sees the linen strips lying there; however he did not go in. ");
INSERT INTO engf35_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Then following him comes Simon Peter and went into the tomb; and he sees the linen strips lying there, ");
INSERT INTO engf35_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","and the facecloth that had been on His head not lying with the linen strips, but folded up in a separate place. ");
INSERT INTO engf35_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","So then the other disciple went in too, the one who got to the tomb first; and he saw and believed. ");
INSERT INTO engf35_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(For they did not yet know the Scripture, that He had to rise from among the dead.) ");
INSERT INTO engf35_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Then the disciples went back home. ");
INSERT INTO engf35_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Well Mary stood outside at the tomb, crying. Then, while she was crying, she stooped to look into the tomb. ");
INSERT INTO engf35_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","And she sees two angels in white, sitting one at the head and one at the feet of where the body of Jesus had lain. ");
INSERT INTO engf35_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","And they say to her, “Woman, why are you crying?” She says to them, “Because they removed my Lord, and I don't know where they put Him.” ");
INSERT INTO engf35_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","And upon saying this she turned around and saw Jesus standing there, yet did not know that it was Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus says to her: “Woman, why are you crying? Whom are you seeking?” She, supposing that He was the gardener, says to Him, “Sir, if you carried Him away, tell me where you put Him, and I will remove Him.” ");
INSERT INTO engf35_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus says to her, “Mary!” Turning she says to Him, “Raboni!” (which means ‘Teacher’). ");
INSERT INTO engf35_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus says to her: “Stop clinging to me, for I have not yet ascended to my Father; but go to my brothers and say to them, ‘I am ascending to my Father and your Father—my God and your God.’ ” ");
INSERT INTO engf35_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene goes to the disciples, reporting that she had seen the Lord and He had said these things to her. ");
INSERT INTO engf35_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Then at evening on that first day of the week, the doors being locked where the disciples were assembled, for fear of the Jews, Jesus came and stood in the middle, and He says to them, “Peace to you!” ");
INSERT INTO engf35_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","And upon saying this He showed them His hands and His side. Well, the disciples were overjoyed when they saw the Lord! ");
INSERT INTO engf35_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","So Jesus said to them again: “Peace to you! Just as the Father sent me, I also send you.” ");
INSERT INTO engf35_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Upon saying this He breathed on them and said: “Receive Holy Spirit! ");
INSERT INTO engf35_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","To whomever you forgive the sins, they are forgiven to them; to whomever you retain, they have been retained.” ");
INSERT INTO engf35_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Now one of the twelve, Thomas (called Twin), was not with them when Jesus came. ");
INSERT INTO engf35_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","So the other disciples said to him, “We have seen the Lord!” But he said to them, “If I do not see the nail prints in His hands and put my finger into the nail prints, and put my hand into His side, I will not believe!” ");
INSERT INTO engf35_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Well after eight days His disciples were inside again, and Thomas with them. The doors were locked again; Jesus came and stood in the middle, and said, “Peace to you!” ");
INSERT INTO engf35_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Then He says to Thomas: “Bring your finger here and perceive my hands; bring your hand and put it into my side; do not be unbelieving but believing!” ");
INSERT INTO engf35_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas answered and said to Him, “My Lord and my God!” ");
INSERT INTO engf35_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus says to him: “Because you have observed me, you have believed. Blessed are those who believe without seeing!” ");
INSERT INTO engf35_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Now then, Jesus actually performed many other miraculous signs in the presence of His disciples, that are not written in this book; ");
INSERT INTO engf35_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","but these have been written so that you may believe that Jesus is the Christ, the Son of God, and that believing you may have Life through His Name. ");
INSERT INTO engf35_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","After these things Jesus, risen from the dead, revealed Himself to His disciples at the Sea of Tiberias, and He did it like this: ");
INSERT INTO engf35_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas (called Twin), Nathanael (from Cana of Galilee), Zebedee's sons and two others of His disciples were together. ");
INSERT INTO engf35_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter says to them, “I'm going fishing.” They say to him, “We're coming with you.” Off they went and got right into the boat, and that whole night they caught nothing. ");
INSERT INTO engf35_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Well when daybreak had now come Jesus stood on the beach; however the disciples did not know that it was Jesus. ");
INSERT INTO engf35_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Then Jesus says to them, “Boys, you don't have any food, do you?” They answered Him, “No.” ");
INSERT INTO engf35_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","So He said to them, “Cast the net on the right side of the boat and you will find.” So they did, and now they were unable to haul it in because of the multitude of fish! ");
INSERT INTO engf35_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Then that disciple whom Jesus loved says to Peter, “It's the Lord!” Upon hearing that it was the Lord, Simon Peter tied on his outer garment (for he was stripped) and plunged into the sea. ");
INSERT INTO engf35_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","But the other disciples came in the little boat dragging the net with the fish (for they were not far from the land, but about 100 yards). ");
INSERT INTO engf35_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Then, as they stepped onto the land they saw a charcoal fire in place with fish lying on it, and bread. ");
INSERT INTO engf35_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus says to them, “Bring some of the fish that you have just caught.” ");
INSERT INTO engf35_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter got up and dragged the net onto the land, full of one hundred and fifty-three large fish !; and although being so many, the net was not torn. ");
INSERT INTO engf35_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus says to them, “Come have breakfast!” Well not one of the disciples dared to ask Him, “Who are you?”—knowing that it was the Lord. ");
INSERT INTO engf35_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Then Jesus comes and takes the bread and gives it to them, as also the fish. ");
INSERT INTO engf35_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","This was already a third time that Jesus appeared to His disciples after He was raised from among the dead. ");
INSERT INTO engf35_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","So, when they had eaten breakfast, Jesus says to Simon Peter, “Simon, son of Jonah, do you love me more than these?” He says to Him, “Yes, Lord, you know that I'm fond of you.” He says to him, “Feed my lambs.” ");
INSERT INTO engf35_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","He says to him again, a second time, “Simon, son of Jonah, do you love me?” He says to Him, “Yes, Lord, you know that I'm fond of you.” He says to him, “Shepherd my sheep.” ");
INSERT INTO engf35_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","The third time He says to him, “Simon, son of Jonah, are you fond of me?” Peter was grieved in that the third time He said to him, “Are you fond of me?” and said to Him: “Lord, you know all things. You know that I'm fond of you!” Jesus says to him: “Feed my sheep. ");
INSERT INTO engf35_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Most assuredly I say to you, when you were younger you used to get dressed and walk where you wished; but when you are old you will stretch out your hands and another will dress you and carry you where you do not wish.” ");
INSERT INTO engf35_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(He said this to indicate the kind of death by which he would glorify God.) And upon saying that He says to him, “Follow me!” ");
INSERT INTO engf35_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","But turning around Peter sees the disciple whom Jesus loved following (that is the one who reclined on His chest at the supper and said, “Lord, who is the one who is betraying you?”). ");
INSERT INTO engf35_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Seeing him, Peter says to Jesus, “Lord, what about him?” ");
INSERT INTO engf35_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus says to him: “If I want him to remain until I come, what is that to you? You follow me.” ");
INSERT INTO engf35_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","So this saying spread among the brothers, that this disciple would not die. Yet Jesus did not say to him Peter that he John would not die, but, “If I want him to remain until I come, what is that to you?” ");
INSERT INTO engf35_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","This is the disciple who is testifying to these things, and who wrote them; and we know that his testimony is true. ");
INSERT INTO engf35_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Indeed, there are also many other things that Jesus did, which if they were written one by one, I suppose that not even the whole world could contain the books that would be written! Amen. ");
INSERT INTO engf35_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","The first account I prepared, Theophilus God-lover, concerned all that Jesus began to do and to teach ");
INSERT INTO engf35_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","until the day in which He was taken back, after He had given commandment, by Holy Spirit, to the apostles whom He had chosen; ");
INSERT INTO engf35_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","to whom He also showed Himself alive, after His suffering, by many convincing evidences, appearing to them during forty days and speaking of things pertaining to the Kingdom of God. ");
INSERT INTO engf35_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","And being together He directed them not to go away from Jerusalem, but to wait for the promise of the Father, “which you heard from me; ");
INSERT INTO engf35_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John baptized with water, but you will be baptized with Holy Spirit not many days from now.” ");
INSERT INTO engf35_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Well then, being together they asked Him saying, “Lord, are you going to restore the kingdom to Israel at this time?” ");
INSERT INTO engf35_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","So He said to them: “It is not for you to know times or seasons that the Father has placed within His own authority. ");
INSERT INTO engf35_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","But you will receive power when the Holy Spirit has come upon you; and you will be witnesses to me—both in Jerusalem, and all Judea and Samaria, and even to the last part of the earth.” ");
INSERT INTO engf35_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Upon saying these things, as they watched, He was lifted up, and a cloud took Him out of their sight. ");
INSERT INTO engf35_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","And as they were staring into the sky, while He was going, suddenly two men in white clothing stood beside them; ");
INSERT INTO engf35_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","and they said: “Men of Galilee, why do you stand gazing up into the sky? This very Jesus who is being taken up from you into the sky, He will come again in the precise manner that you observed Him going into the sky.” ");
INSERT INTO engf35_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","They then returned to Jerusalem from the mount called ‘of Olives’, which is near Jerusalem (a Sabbath day's journey). ");
INSERT INTO engf35_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","When they had entered the city they went up into the upper room where they were staying: namely Peter and James, John and Andrew, Philip and Thomas, Bartholomew and Matthew, James of Alphaeus and Simon the Zealot, and Judas of James. ");
INSERT INTO engf35_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","All these were continuing with one purpose in prayer and petition, along with the women, including Mary the mother of Jesus, and with His brothers. ");
INSERT INTO engf35_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Well in those days Peter stood up in the middle of the disciples (the number of people assembled there was about 120) and said: ");
INSERT INTO engf35_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Men, brothers: It was necessary that this Scripture be fulfilled, which the Holy Spirit spoke before by David's mouth concerning Judas, who was guide to those who arrested Jesus; ");
INSERT INTO engf35_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","in that he was numbered with us and obtained his share in this ministry.” ");
INSERT INTO engf35_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(In fact this man acquired a field with the wages of his wickedness, and falling headlong he burst open in the middle, and all his innards were spilled out. ");
INSERT INTO engf35_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","And it became known to all who lived in Jerusalem, so that in their own language that field came to be called ‘Akeldama’, that is, ‘Field of Blood’.) ");
INSERT INTO engf35_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Because it stands written in Book of Psalms: ‘Let his residence become desolate, and may no one live in it’ and, ‘Let another take his office.’ ");
INSERT INTO engf35_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","So then, of the men who have accompanied us all the time that the Lord Jesus went in and out among us, ");
INSERT INTO engf35_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","beginning from the baptism of John until the day when He was taken up from us, of these one must become a witness with us of His resurrection.” ");
INSERT INTO engf35_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","So they nominated two, Joseph called Barsabas, who was surnamed Justus, and Matthias. ");
INSERT INTO engf35_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","And praying they said: “You, Lord, Knower of all hearts, show which one of these two You have chosen ");
INSERT INTO engf35_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","to receive the portion of this ministry and apostleship, out of which Judas turned aside to go into his own place.” ");
INSERT INTO engf35_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","And they cast their lots, and the lot fell on Matthias, and he was numbered with the eleven Apostles. ");
INSERT INTO engf35_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","When the day of Pentecost had come, they were all together with one purpose. ");
INSERT INTO engf35_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","And suddenly a roar came out of the sky, like the rushing of a violent wind, and it filled the whole house where they were sitting. ");
INSERT INTO engf35_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Fiery tongues appeared and were distributed to them, and it a tongue landed on each one of them. ");
INSERT INTO engf35_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","And they were all filled with Holy Spirit and began to speak different languages, as the Spirit was granting to them to speak out. ");
INSERT INTO engf35_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Now there were devout men, Jews, from every nation under heaven, dwelling in Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","So when that roar occurred, the crowd came together, and was bewildered, because each one was hearing them speaking to him in his own dialect. ");
INSERT INTO engf35_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","So they were amazed and marveled, saying to one another: “Hey, aren't all these who are speaking Galileans? ");
INSERT INTO engf35_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","So how can each of us be hearing our own dialect in which we were born? ");
INSERT INTO engf35_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthians and Medes and Elamites; those dwelling in Mesopotamia, in Judea and Cappadocia, in Pontus and Asia, ");
INSERT INTO engf35_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","in Phrygia and Pamphylia, in Egypt and the parts of Libya adjoining Cyrene; and visitors from Rome—both Jews and proselytes— ");
INSERT INTO engf35_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretans and Arabians; we hear them declaring the great works of God in our own languages.” ");
INSERT INTO engf35_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yes they were all amazed and perplexed, saying one to another, “Whatever is going on?” ");
INSERT INTO engf35_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","But different ones were jeering, saying, “They are full of sweet wine!” ");
INSERT INTO engf35_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","So Peter, standing with the eleven, raised his voice and proclaimed to them: “Men—Jews and all who are dwelling in Jerusalem—let this be known to you; indeed, listen to my speech! ");
INSERT INTO engf35_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Because these are not drunk, as you suppose (since it is only the third hour of the day), ");
INSERT INTO engf35_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","but this is what was spoken through the prophet Joel: ");
INSERT INTO engf35_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘It will be in the last days, says God: I will pour out from my Spirit upon all flesh; your sons and your daughters will prophesy; your young men will see visions; your old men will dream a dream. ");
INSERT INTO engf35_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","In those days I will indeed pour out from my Spirit upon my male slaves and upon my female slaves, and they will prophesy. ");
INSERT INTO engf35_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","I will show wonders in the heaven above and signs on the earth below: blood and fire and smoke vapor. ");
INSERT INTO engf35_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","The sun will be turned into darkness and the moon into ‘blood’ before the great and glorious day of the Lord will come. ");
INSERT INTO engf35_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","And it will be: whoever calls on the name of the Lord will be saved!’ ");
INSERT INTO engf35_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Men of Israel, listen to these words: Jesus the Natsorean, a man from God attested to you by miracles and wonders and signs, which God did by Him in your midst, as you yourselves well know, ");
INSERT INTO engf35_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Him—being delivered up by the established purpose and foreknowledge of God—you murdered, having taken Him with lawless hands and crucified Him; ");
INSERT INTO engf35_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","whom God raised up, ending the labor pains of death, because it was not possible that He should be held by it. ");
INSERT INTO engf35_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","For David says concerning Him: ‘I always saw the Lord before my face, because He is at my right side so that I not be shaken. ");
INSERT INTO engf35_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Therefore my heart was glad and my tongue rejoiced. Furthermore, even my flesh will repose upon hope, ");
INSERT INTO engf35_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","because You will not abandon my soul in Hades, nor will You allow Your Holy One to see decay. ");
INSERT INTO engf35_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","You have made known to me roads of life; with Your presence You make me full of gladness.’ ");
INSERT INTO engf35_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Men, brothers, be it permitted to speak to you plainly about the patriarch David, that he both died and was buried, and his tomb is with us to this day. ");
INSERT INTO engf35_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","So then, he being a prophet and knowing that God had sworn to him with an oath that of the fruit, according to flesh, of his loins He would raise up the Messiah to sit on his throne, ");
INSERT INTO engf35_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","he foreseeing this spoke about the resurrection of the Messiah, that His soul was not abandoned in Hades, nor did His flesh see decay. ");
INSERT INTO engf35_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“This Jesus God raised, to which we all are witnesses. ");
INSERT INTO engf35_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Therefore, having been exalted to God's right hand, and having received from the Father the promise of the Holy Spirit, He poured out this that you now see and hear. ");
INSERT INTO engf35_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Further, David did not ascend into the heavens, but he himself says: ‘The Lord said to my Lord: Sit at my right hand ");
INSERT INTO engf35_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","until I make your enemies a footstool for your feet.’ ");
INSERT INTO engf35_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Therefore, let all the house of Israel know assuredly that God has made Him both Lord and Christ, this Jesus whom you crucified!” ");
INSERT INTO engf35_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Now upon hearing this they were cut to the heart and said to Peter, and the rest of the Apostles, “Men, brothers, what shall we do?!” ");
INSERT INTO engf35_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","So Peter said to them: “Repent and be baptized, each one of you, upon the name of Jesus Christ, for forgiveness of sins, and you will receive the gift of the Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","For the promise is to you, and to your children, and to all who are far away—as many, that is, as the Lord our God may call.” ");
INSERT INTO engf35_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","With many different words he both testified and kept exhorting, saying, “Escape from this perverse generation!” ");
INSERT INTO engf35_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Then those who gladly received his word were baptized, and that day about three thousand souls were added. ");
INSERT INTO engf35_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","And they continued steadfastly in the Apostles' teaching and in the fellowship, both in the breaking of the bread and in the prayers. ");
INSERT INTO engf35_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Fear came upon every soul—many wonders and signs were taking place through the Apostles. ");
INSERT INTO engf35_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Now all who believed were together and had all things in common; ");
INSERT INTO engf35_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","they started selling both possessions and goods and were distributing to all according as anyone had need. ");
INSERT INTO engf35_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","So day by day they continued steadfastly with one purpose in the temple and broke bread from house to house; they received their share of food with gladness and singleness of heart, ");
INSERT INTO engf35_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","praising God and having favor with all the people. And day by day the Lord added to the Church those who were being saved. ");
INSERT INTO engf35_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Now Peter and John were going up together into the temple at the hour (the ninth) of prayer. ");
INSERT INTO engf35_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","And a certain man, who had actually been lame from his mother's womb, was being carried (they would lay him daily at the temple gate, the one called Beautiful, to ask alms from those who entered the temple), ");
INSERT INTO engf35_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","who, upon seeing Peter and John about to go into the temple, began asking for alms. ");
INSERT INTO engf35_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","So Peter, with John, fastening his gaze on him said, “Look at us.” ");
INSERT INTO engf35_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","So he gave them his attention, expecting to receive something from them. ");
INSERT INTO engf35_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","But Peter said: “I do not have silver and gold, but what I do have I give you. In the name of Jesus Christ the Natsorean, get up and walk!” ");
INSERT INTO engf35_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","And grasping him by his right hand he lifted him up; immediately his feet and ankles were strengthened. ");
INSERT INTO engf35_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","So jumping up he stood, and began to walk! And he entered the temple with them, walking and leaping and praising God. ");
INSERT INTO engf35_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Well all the people saw him walking and praising God; ");
INSERT INTO engf35_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","and they recognized him—that he was the one who used to sit at the Beautiful Gate of the temple, with a view to alms—and they were filled with wonder and amazement because of what had happened to him. ");
INSERT INTO engf35_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Now as the lame man who had been healed held on to Peter and John, all the people ran together to them in the portico, the one called ‘Solomon's’, really wondering. ");
INSERT INTO engf35_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","So upon observing this Peter responded to the people: “Men of Israel, why are you marveling at this, or why are you staring at us as if we have made him walk by our own power or godliness? ");
INSERT INTO engf35_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","The God of Abraham and Isaac and Jacob, the God of our fathers, glorified His Servant Jesus, whom you delivered up; and you repudiated Him to Pilate's face, when he was intending to release Him. ");
INSERT INTO engf35_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yes you repudiated the holy and righteous One, and you asked that a murderer be granted to you, ");
INSERT INTO engf35_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","while you killed the Originator of the Life, whom God raised from among the dead, to which we are witnesses. ");
INSERT INTO engf35_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Well His name, based on faith in His name, made this man strong, whom you see and know. Yes, the faith that is through Him has given him this wholeness in the presence of you all. ");
INSERT INTO engf35_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“So now, brothers, I know that you did it in ignorance, as also your rulers. ");
INSERT INTO engf35_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","But the things that God foretold through the mouth of all His prophets, that the Messiah would suffer, He has thus fulfilled. ");
INSERT INTO engf35_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Repent therefore, and turn around, so that your sins may be erased, in order that times of refreshing may come from the Lord's face ");
INSERT INTO engf35_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","and that He may send Jesus, who had been ordained to be your Messiah, ");
INSERT INTO engf35_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","whom Heaven must receive until the times of restoration of all things, of which times God spoke long ago by the mouth of all His holy prophets. ");
INSERT INTO engf35_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“For example, Moses said to the fathers: ‘The Lord our God will raise up for you a Prophet, like me, from among your brothers. You must listen to Him, in all that He may say to you. ");
INSERT INTO engf35_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","It will be that every person who will not listen to that Prophet will be extirpated from among the people.’ ");
INSERT INTO engf35_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Yes and all the prophets, from Samuel on down, as many as have spoken, have also foretold these days. ");
INSERT INTO engf35_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","You are sons of the prophets, and of the covenant which God made with our fathers, saying to Abraham, ‘Yes, in your seed all the families of the earth will be blessed.’ ");
INSERT INTO engf35_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God, having raised up His Servant Jesus, sent Him to you first, to bless you by turning each of you away from your iniquities.” ");
INSERT INTO engf35_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Now as they were speaking to the people, the priests, the captain of the temple and the Sadducees came at them, ");
INSERT INTO engf35_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","being upset because they were teaching the people and proclaiming in Jesus the resurrection from the dead. ");
INSERT INTO engf35_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","And they laid hands on them and put them in custody until the next day, because it was already evening. ");
INSERT INTO engf35_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","(However, many of those who heard the message believed; the number of the men came to be about five thousand.) ");
INSERT INTO engf35_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","So the next day an assembly of their rulers, both elders and scribes, occurred in Jerusalem, ");
INSERT INTO engf35_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","along with Annas the high priest, and Caiaphas, John and Alexander, and as many as were of high-priestly descent. ");
INSERT INTO engf35_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","And having placed them in the middle of the assembly they started questioning: “By what power, or by what name did you do this?” ");
INSERT INTO engf35_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Then Peter, full of Holy Spirit, said to them: “Rulers of the people and elders of Israel: ");
INSERT INTO engf35_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","If we are being examined today about a good deed done to a helpless man, by what means he has been made well, ");
INSERT INTO engf35_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","be it known to you all, and to all the people of Israel, that by the name of Jesus Christ the Natsorean, whom you crucified, whom God raised from the dead, by Him this man stands here before you whole. ");
INSERT INTO engf35_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","This is ‘the stone which was despised by you, the builders, which has become the chief cornerstone.’ ");
INSERT INTO engf35_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Also, the salvation does not exist in anyone else, because there is no other name under heaven, given among men, by which we must be saved.” ");
INSERT INTO engf35_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Now upon observing the boldness of Peter and John and perceiving that they were uneducated and unskilled men, they marveled; and they recognized that they had been with Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Further, seeing the man who had been healed standing with them, they could say nothing against it. ");
INSERT INTO engf35_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","So ordering them to go out from the council they began to confer among themselves, ");
INSERT INTO engf35_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","saying: “What can we do to these men? Because, indeed, that a notable miracle has been done through them is evident to all who dwell in Jerusalem, and we cannot deny it. ");
INSERT INTO engf35_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","But so that it spreads no further among the people, let us severely threaten them to no longer speak to anyone in this name.” ");
INSERT INTO engf35_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","So summoning them they commanded them absolutely not to speak or teach in the name of ‘Jesus’. ");
INSERT INTO engf35_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","But in answer Peter and John said to them: “Whether it is right in the sight of God to listen to you rather than to God, judge for yourselves; ");
INSERT INTO engf35_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","because we cannot help but speak the things we have seen and heard.” ");
INSERT INTO engf35_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","So threatening them some more they released them, not finding any way to punish them, because of the people, since they were all glorifying God over what had happened; ");
INSERT INTO engf35_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","because the man on whom this miracle of healing had been performed was over forty years old. ");
INSERT INTO engf35_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","So upon being released they went to their own group and reported all that the chief priests and elders had said to them. ");
INSERT INTO engf35_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Well upon hearing it, with one mind they called out to God and said: “O Sovereign! You are God, the Maker of sky and earth and ocean, and all that is in them; ");
INSERT INTO engf35_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","You who said through the mouth of Your servant David: ‘Why did nations snort and peoples plot vain things? ");
INSERT INTO engf35_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","The kings of the earth took a stand, and the rulers were gathered together, against the Lord and against His Messiah.’ ");
INSERT INTO engf35_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Well, in fact, both Herod and Pontius Pilate, together with Gentiles and peoples of Israel, were gathered together against Your holy Servant Jesus, whom You anointed, ");
INSERT INTO engf35_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","to do whatever Your hand and Your counsel foreordained to happen. ");
INSERT INTO engf35_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","As for the present, Lord, consider their threats, and grant to Your slaves to speak Your word with all boldness, ");
INSERT INTO engf35_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","while You stretch out Your hand to heal and that signs and wonders may occur through the name of Your holy Servant Jesus.” ");
INSERT INTO engf35_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Well when they had prayed, the place where they were gathered was shaken, and they were all filled with Holy Spirit and spoke the Word of God with boldness. ");
INSERT INTO engf35_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Now the multitude of those who believed was of one heart and soul; indeed not one was saying that any of his belongings was his own, but they had all things in common. ");
INSERT INTO engf35_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","(Also the Apostles were giving witness to the resurrection of the Lord Jesus with great power.) Yes, great grace was on them all, ");
INSERT INTO engf35_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","because there were not any needy among them—as many as were owners of lands or houses were selling them and bringing the proceeds of the sold items ");
INSERT INTO engf35_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","and placing them at the Apostles' feet, and they were distributed to each according as anyone had need. ");
INSERT INTO engf35_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","So Joses, who was named Barnabas by the Apostles (which is, being translated, ‘Son of encouragement’), a Levite of the country of Cyprus, ");
INSERT INTO engf35_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","having a field, sold it, brought the money and placed it at the Apostles' feet. ");
INSERT INTO engf35_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Now a certain man named Ananias, with Sapphira his wife, sold a possession ");
INSERT INTO engf35_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","and kept back part of the price for himself, his wife also being party to it; bringing a certain part he placed it at the Apostles' feet. ");
INSERT INTO engf35_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","So Peter said: “Ananias, on what basis has Satan filled your heart to lie to the Holy Spirit and to keep back for yourself part of the price of the land? ");
INSERT INTO engf35_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","While it remained unsold was it not yours, and once sold was it not in your power? How is it that you have conceived this thing in your heart? You did not lie to men but to God.” ");
INSERT INTO engf35_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Well upon hearing these words Ananias fell down and expired! (Great fear came on all who heard these things.) ");
INSERT INTO engf35_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","So the young men got up and wrapped him, and carrying him out they buried him. ");
INSERT INTO engf35_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Now after an interval of some three hours his wife came in, not knowing what had happened. ");
INSERT INTO engf35_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","So Peter addressed her, “Tell me whether you sold the land for so much.” So she said, “Yes, for so much.” ");
INSERT INTO engf35_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter said to her: “How is it that you have agreed together to test the Spirit of the Lord? Look, the feet of those who buried your husband are at the door, and they will carry you out!” ");
INSERT INTO engf35_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","So she immediately fell down at his feet and expired! So upon entering the young men found her dead, and carrying her out they buried her beside her husband. ");
INSERT INTO engf35_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","So great fear came on the whole assembly and on all who heard these things. ");
INSERT INTO engf35_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Now many signs and wonders were being performed among the people by the hands of the Apostles; and they were all in Solomon's Porch with one purpose. ");
INSERT INTO engf35_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","None of the rest dared to join them, but the people were magnifying them. ");
INSERT INTO engf35_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Believers were increasingly added to the Lord, multitudes of both men and women, ");
INSERT INTO engf35_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","to the point that they kept carrying the sick into the streets, placing them on cots and pallets, so that as Peter came by at least his shadow might fall on some of them. ");
INSERT INTO engf35_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Further, the multitude from the surrounding cities also kept coming into Jerusalem, bringing sick people and those who were tormented by unclean spirits, and they were all healed. ");
INSERT INTO engf35_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Then the high priest rose up, and all those with him (being the sect of the Sadducees); they were filled with jealousy ");
INSERT INTO engf35_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","and laid their hands on the Apostles and put them in the common prison. ");
INSERT INTO engf35_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","But, during the night an angel of the Lord opened the doors of the prison, and leading them out he said, ");
INSERT INTO engf35_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Go, stand in the temple and speak to the people all the words of this Life.” ");
INSERT INTO engf35_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","So upon hearing it they entered the temple about daybreak and started to teach. Then the high priest and those with him arrived and convened the Sanhedrin, even all the council of elders of the sons of Israel, and sent to the prison to have them brought. ");
INSERT INTO engf35_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Well, upon arriving the operatives did not find them in the jail, so they returned and reported, ");
INSERT INTO engf35_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","saying: “We certainly found the prison securely locked, and the guards standing in front of the doors, but upon opening them we found no one inside!” ");
INSERT INTO engf35_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Now when the high priest, the captain of the temple, and the chief priests heard these words, they were really perplexed as to what the implications might be. ");
INSERT INTO engf35_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","But someone came and told them, “Hey, the men whom you put in the jail are standing in the temple and teaching the people!” ");
INSERT INTO engf35_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Then the captain went with the operatives and brought them without violence, because they were afraid that the people might stone them. ");
INSERT INTO engf35_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","So bringing them they set them before the Sanhedrin; and the high priest addressed them ");
INSERT INTO engf35_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","saying: “Did we not emphatically command you not to teach in this name? Just look, you have filled Jerusalem with your teaching, and you intend to bring this man's blood on us!” ");
INSERT INTO engf35_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","So in answer Peter and the Apostles said: “One must obey God rather than men. ");
INSERT INTO engf35_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","The God of our fathers raised up Jesus, whom you murdered by hanging on a tree. ");
INSERT INTO engf35_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Him God has exalted to His right hand as Prince and Savior, to give repentance to Israel, and forgiveness of sins. ");
INSERT INTO engf35_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","And we are witnesses to these statements about Him, as also is the Holy Spirit whom God has given to those obeying Him.” ");
INSERT INTO engf35_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Well upon hearing it they became infuriated and started plotting to kill them. ");
INSERT INTO engf35_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","But someone in the council stood up (a Pharisee named Gamaliel, a teacher of the law respected by all the people) and commanded to put the Apostles out for a bit. ");
INSERT INTO engf35_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","He then said to them: “Men, Israelites, take heed to yourselves concerning these men, as to what you are about to do. ");
INSERT INTO engf35_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","For some time ago Theudas rose up, claiming to be somebody; with whom about four hundred men joined up; who was killed, and all who obeyed him were scattered and came to nothing. ");
INSERT INTO engf35_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Later Judas the Galilean rose up, in the days of the census, and drew away many people after him. He also perished, and all who obeyed him were dispersed. ");
INSERT INTO engf35_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","So now I say to you, keep away from these men and leave them alone; because if this counsel or this work should be of men, it will be abolished; ");
INSERT INTO engf35_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","but if it is of God, you will not be able to overthrow it—lest you even be found to be fighting against God!” ");
INSERT INTO engf35_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Well they were persuaded by him, and summoned the Apostles; after beating them they commanded them not to speak in the name of Jesus, and let them go. ");
INSERT INTO engf35_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","So they went out rejoicing from the presence of the council, in that they were counted worthy to suffer dishonor for the name of the Christ. ");
INSERT INTO engf35_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","And every day, in the temple and from house to house, they did not stop teaching and preaching Jesus as the Christ. ");
INSERT INTO engf35_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Now in those days, as the disciples were multiplying, a complaint arose from the Hellenists against the Hebrews, because their widows were being overlooked in the daily distribution. ");
INSERT INTO engf35_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","So summoning the multitude of the disciples the twelve said: “It is not advantageous that we should forsake the Word of God to serve at tables. ");
INSERT INTO engf35_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Therefore, brothers, select from among you seven men of good reputation, full of Holy Spirit and wisdom, whom we will appoint over this need. ");
INSERT INTO engf35_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","But we will give ourselves continually to prayer and to the ministry of the Word.” ");
INSERT INTO engf35_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","The statement pleased the whole multitude; and they chose Stephen, a man full of faith and Holy Spirit, and Philip and Prochorus and Nicanor and Timon and Parmenas and Nicholas, a proselyte from Antioch, ");
INSERT INTO engf35_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","whom they set before the Apostles; and after praying they laid hands on them. ");
INSERT INTO engf35_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Well the Word of God kept spreading, and the number of disciples in Jerusalem kept multiplying at a great rate, and a large company of the priests were obeying the faith. ");
INSERT INTO engf35_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","While Stephen, full of faith and power, was doing great wonders and signs among the people. ");
INSERT INTO engf35_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Then there arose some from what is called the Synagogue of the Freedmen (Cyrenians, Alexandrians, and those from Cilicia and Asia), disputing with Stephen. ");
INSERT INTO engf35_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","And they were not able to withstand the wisdom and the Spirit with which he spoke. ");
INSERT INTO engf35_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Then they instigated men to say, “We have heard him speaking blasphemous words against Moses and God.” ");
INSERT INTO engf35_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","And they stirred up the people, and the elders and the scribes; and coming upon him they seized him, and brought him in to the Sanhedrin; ");
INSERT INTO engf35_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","and they put forward false witnesses who said: “This man never stops speaking blasphemous words against the holy place and the law; ");
INSERT INTO engf35_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","for we have heard him saying that this Jesus the Natsorean will destroy this place and change the customs that Moses delivered to us.” ");
INSERT INTO engf35_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","All who sat in the council, looking intently at him, saw his face like the face of an angel. ");
INSERT INTO engf35_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Then the high priest said, “Can these things be so?” ");
INSERT INTO engf35_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","So he said: “Men, brothers and fathers, listen: The God of glory appeared to our father Abraham when he was in Mesopotamia, before he resided in Haran, ");
INSERT INTO engf35_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","and said to him, ‘Leave your country and your relatives, and come into a land that I will show you.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Then he left the land of the Chaldeans and resided in Haran. From there, after his father died, God moved him to this land in which you now live; ");
INSERT INTO engf35_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","yet He did not give him an inheritance in it, not even a footstep. He promised to give it to him for a possession, that is, to his seed after him, though he had no child. ");
INSERT INTO engf35_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Further, God spoke like this: that his offspring would be aliens in a foreign land—and that they would be enslaved and oppressed—four hundred years. ");
INSERT INTO engf35_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘I will judge the nation to which they will be in bondage,’ said God, ‘and after that they will come out and serve Me in this place.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","And He gave him a covenant of circumcision; and so he begot Isaac and circumcised him on the eighth day; and Isaac did the same to Jacob, and Jacob to the twelve patriarchs. ");
INSERT INTO engf35_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“The patriarchs, being envious, sold Joseph into Egypt; yet God was with him ");
INSERT INTO engf35_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","and delivered him out of all his adversities, and gave him favor and wisdom before Pharaoh, king of Egypt; and he made him governor over Egypt and all his house. ");
INSERT INTO engf35_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","And a famine came upon all the land of Egypt and Canaan, even a great affliction, and our fathers could not find food. ");
INSERT INTO engf35_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","But upon hearing that there was wheat in Egypt, Jacob first sent our fathers. ");
INSERT INTO engf35_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","On the second trip Joseph was made known to his brothers, and Joseph's family was presented to Pharaoh. ");
INSERT INTO engf35_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joseph sent and summoned his father Jacob and all his relatives, seventy-five souls. ");
INSERT INTO engf35_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","So Jacob went down to Egypt; and he died, he and our fathers; ");
INSERT INTO engf35_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","and they were transferred to Shechem and placed in the tomb that Abraham bought for a sum of money from the sons of Hamor of Shechem. ");
INSERT INTO engf35_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Now as the time of the promise was approaching which God had sworn to Abraham, the people increased and were multiplied in Egypt, ");
INSERT INTO engf35_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","until a different king arose who had not known Joseph. ");
INSERT INTO engf35_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","This man took advantage of our race and oppressed our fathers, making them expose their babies so that they would not stay alive. ");
INSERT INTO engf35_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","At that time Moses was born, and was well pleasing to God; he was nurtured in his father's house for three months. ");
INSERT INTO engf35_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","When he was exposed, Pharaoh's daughter took him to herself and brought him up as her own son. ");
INSERT INTO engf35_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","So Moses was educated in all the wisdom of the Egyptians; he was mighty in words and deeds. ");
INSERT INTO engf35_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Now when he was forty years old, it came into his heart to visit his brothers, the sons of Israel. ");
INSERT INTO engf35_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Well seeing one of them being wronged, he defended and avenged the one being oppressed, striking down the Egyptian. ");
INSERT INTO engf35_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Now he supposed that his brothers understood that God was giving them deliverance by his hand, but they did not understand. ");
INSERT INTO engf35_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","The next day he appeared to them as they were fighting and tried to reconcile them, saying, ‘Men, you are brothers; why do you wrong one another?’ ");
INSERT INTO engf35_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","But the one who was wronging his neighbor pushed Moses away, saying: ‘Who made you a ruler and a judge over us? ");
INSERT INTO engf35_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Do you want to kill me as you did the Egyptian yesterday?’ ");
INSERT INTO engf35_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Well Moses fled at that word, and became a stranger in the land of Midian, where he begot two sons. ");
INSERT INTO engf35_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“And when another forty years had passed, Angel of the Lord appeared to him in the wilderness of Mount Sinai, in a flame of fire in a bush. ");
INSERT INTO engf35_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Well upon seeing it Moses was amazed at the sight, but as he approached for a closer look the voice of the Lord came to him: ");
INSERT INTO engf35_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘I am the God of your fathers—the God of Abraham and the God of Isaac and the God of Jacob.’ Moses started trembling and did not dare to look. ");
INSERT INTO engf35_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","So the Lord said to him: ‘Take your sandals off your feet, for the place where you stand is holy ground. ");
INSERT INTO engf35_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","I have definitely seen the mistreatment of my people in Egypt, and have heard their groaning; and I have come down to deliver them. So now come, I will send you to Egypt.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“This Moses whom they refused, saying, ‘Who made you a ruler and a judge?’—God sent him as leader and deliverer by the hand of the Angel who appeared to him in the bush. ");
INSERT INTO engf35_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","This man led them out, performing wonders and signs in the land of Egypt and in the Red Sea, and for forty years in the wilderness. ");
INSERT INTO engf35_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“This is the Moses who said to the sons of Israel, ‘The Lord our God will raise up to you a Prophet from among your brothers, like me.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","This is he who was in the assembly in the wilderness, who was with the Angel who spoke with him on Mount Sinai and was with our fathers, who received living oracles to give to us; ");
INSERT INTO engf35_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","to whom our fathers did not want to be obedient; rather they rejected him and turned back in their heart to Egypt, ");
INSERT INTO engf35_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","saying to Aaron, ‘Make us gods that will go before us; because this Moses, who led us out of the land of Egypt—we do not know what has become of him.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Well they made a calf in those days and brought a sacrifice to the idol, and started rejoicing in the works of their hands. ");
INSERT INTO engf35_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","But God turned away and gave them over to serve the army of the heaven, just as it is written in Book of the Prophets: ‘House of Israel, did you offer me slaughtered animals and sacrifices during forty years in the wilderness? ");
INSERT INTO engf35_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Actually you took along the tent of Moloch, and the star of your god, Rephan, the images that you made to worship; so I will relocate you beyond Babylon.’ ");
INSERT INTO engf35_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“The tent of the testimony, according to the pattern that Moses had seen, just as the One speaking to him had commanded to make it, was with our fathers in the wilderness; ");
INSERT INTO engf35_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","which, having received it in turn, our fathers with Joshua brought into the possession of the nations, whom God drove out before the face of our fathers, until the days of David; ");
INSERT INTO engf35_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","who found favor before God and asked to find a dwelling for the God of Jacob, ");
INSERT INTO engf35_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","but Solomon built Him a house. ");
INSERT INTO engf35_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","However, the Most High does not dwell in handmade sanctuaries, just as the prophet says: ");
INSERT INTO engf35_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Heaven is my throne, while the earth is a footstool for my feet. What kind of house will you build me,’ says the Lord, ‘or what place for my rest? ");
INSERT INTO engf35_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Did not my hand make all these things?’ ");
INSERT INTO engf35_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“You stiff-necked and uncircumcised in heart and ears! You always oppose the Holy Spirit; as your fathers did, so you do. ");
INSERT INTO engf35_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Which of the prophets did your fathers not persecute? And they killed those who foretold the coming of the Righteous One, of whom you have now become betrayers and murderers; ");
INSERT INTO engf35_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","you who received the Law as ‘ordinances of angels’ and have not kept it!” ");
INSERT INTO engf35_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Well as they heard these things their hearts were being sawed in half, and they started gnashing their teeth at him. ");
INSERT INTO engf35_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","But he, being full of Holy Spirit and looking intently into the heaven, he saw the glory of God and Jesus standing on God's right, ");
INSERT INTO engf35_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","and said, “Wow! I see the heavens opened and the Son of the Man standing at God's right!” ");
INSERT INTO engf35_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yelling at the top of their voice they covered their ears and rushed at him all at once, ");
INSERT INTO engf35_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","and throwing him out of the city they stoned him! (The witnesses placed their garments at the feet of a young man named Saul.) ");
INSERT INTO engf35_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Yes, they stoned Stephen as he called out and said, “Lord Jesus, receive my spirit.” ");
INSERT INTO engf35_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Then kneeling down he called out at the top of his voice, “Lord, do not hold this sin against them!” And upon saying this he fell asleep. (Saul was in full agreement with his murder.) ");
INSERT INTO engf35_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","At that time a major persecution arose against the church that was in Jerusalem, so all, except the Apostles, were scattered throughout the regions of Judea and Samaria. ");
INSERT INTO engf35_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","(Devout men had buried Stephen and made a great lamentation over him.) ");
INSERT INTO engf35_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","As for Saul, he was trying to destroy the Church; invading house after house and dragging away both men and women, he was putting them in prison. ");
INSERT INTO engf35_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","So on their part those who were scattered abroad went about preaching the Word. ");
INSERT INTO engf35_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Now Philip, having gone down to a city of Samaria, was proclaiming the Christ to them; ");
INSERT INTO engf35_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","and the crowds gave heed with one accord to what Philip was saying, as they heard the words and saw the signs that he kept performing. ");
INSERT INTO engf35_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Because unclean spirits came out screaming from many who had them, and many who were paralyzed and lame were healed. ");
INSERT INTO engf35_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yes, there was great joy in that city! ");
INSERT INTO engf35_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Now a certain man named Simon was in the city first, practicing sorcery and astounding the people of Samaria, affirming himself to be someone great, ");
INSERT INTO engf35_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","to whom they used to pay attention, from the least to the greatest, saying, “This man is the great power of God.” ");
INSERT INTO engf35_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","They listened to him because he had amazed them with his sorceries for a long time. ");
INSERT INTO engf35_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","But, when they believed Philip, as he proclaimed the good news concerning the Kingdom of God and the name, Jesus Christ, they were baptized, both men and women. ");
INSERT INTO engf35_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Even Simon himself believed, and having been baptized he stayed right with Philip; observing miracles and signs occurring, he was amazed. ");
INSERT INTO engf35_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Now when the Apostles in Jerusalem heard that Samaria had received the word of God, they sent Peter and John to them, ");
INSERT INTO engf35_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","who upon coming down prayed about them, so that they might receive Holy Spirit, ");
INSERT INTO engf35_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","because He had not yet fallen upon any of them; they had only been baptized into the name of Jesus, the Christ. ");
INSERT INTO engf35_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Then they laid their hands upon them and they received Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Well, upon observing that the Holy Spirit was given through the laying on of the Apostles' hands, Simon offered them money ");
INSERT INTO engf35_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","saying, “Give this power to me also, that anyone on whom I lay hands may receive Holy Spirit.” ");
INSERT INTO engf35_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","But Peter said to him: “May your silver go with you into perdition, for thinking that the gift of God could be acquired with money! ");
INSERT INTO engf35_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","You have neither part nor portion in this matter, because your heart is not right before God. ");
INSERT INTO engf35_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Turn away therefore from this your wickedness and make petition to God, in case the intent of your heart may be forgiven you; ");
INSERT INTO engf35_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","for I see you being into a gall of bitterness and a fetter of unrighteousness.” ");
INSERT INTO engf35_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","So in answer Simon said, “You make petition to the Lord on my behalf, so that nothing of what you have spoken may come upon me!” ");
INSERT INTO engf35_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","So when they had both thoroughly testified and spoken the Word of the Lord, they returned to Jerusalem; they also evangelized many Samaritan villages. ");
INSERT INTO engf35_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Then an angel of the Lord spoke to Philip saying, “Get up and go south on the road that goes down from Jerusalem to Gaza; it is desolate.” ");
INSERT INTO engf35_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","So he got up and went; and there, a man, an Ethiopian, a eunuch, a court-official of Candace the queen of the Ethiopians, who was over all her treasury, who had come worshiping to Jerusalem ");
INSERT INTO engf35_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","—he was returning, sitting in his chariot and reading aloud the prophet Isaiah. ");
INSERT INTO engf35_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","And the Spirit said to Philip, “Go forward and join this chariot.” ");
INSERT INTO engf35_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","So running up Philip heard him reading the prophet Isaiah and said, “Do you really understand what you are reading?” ");
INSERT INTO engf35_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","So he said, “Well how can I, unless someone guides me?” And he urged Philip to come up and sit with him. ");
INSERT INTO engf35_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Now the portion of the Scripture that he was reading was this: “He was led as a sheep to the slaughter; and as a lamb before its shearer is silent, so He does not open His mouth. ");
INSERT INTO engf35_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","In His humiliation His justice was removed, and who will recount His generation? Because His life is removed from the earth.” ");
INSERT INTO engf35_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","So continuing the eunuch said to Philip, “I ask you, about whom does the prophet say this, about himself or about someone else?” ");
INSERT INTO engf35_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","So opening his mouth and beginning from this Scripture, Philip preached Jesus to him. ");
INSERT INTO engf35_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Now as they were going down the road they came upon some water, and the eunuch said: “Look, water! What is keeping me from being baptized?” ");
INSERT INTO engf35_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","So he ordered the chariot to stop, and they both went down into the water, both Philip and the eunuch, and he baptized him. ");
INSERT INTO engf35_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Now when they came up out of the water, Spirit of the Lord snatched Philip away, and the eunuch did not see him any more, because he went on his way rejoicing. ");
INSERT INTO engf35_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip was found at Azotus, and as he passed through he evangelized all the towns until he came to Caesarea. ");
INSERT INTO engf35_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Meanwhile Saul, still exhaling murderous threats against the disciples of the Lord, went to the high priest ");
INSERT INTO engf35_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","and asked for letters from him to the synagogues of Damascus, so that if he should find any who were of the Way, whether men or women, he might bring them bound to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","So it happened, as he was going, that he got close to Damascus, and suddenly a light from heaven shone around him; ");
INSERT INTO engf35_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","and falling to the ground he heard a voice saying to him, “Saul, Saul, why are you persecuting me?” ");
INSERT INTO engf35_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","So he said, “Who are you, Lord?” So the Lord said, “I am Jesus, whom you are persecuting; ");
INSERT INTO engf35_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","but get up and go into the city, and you will be told what you must do.” ");
INSERT INTO engf35_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","The men who were traveling with him stood speechless, hearing the sound but seeing no one. ");
INSERT INTO engf35_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Then Saul got up from the ground, and upon opening his eyes he saw no one; so leading him by the hand they brought him into Damascus. ");
INSERT INTO engf35_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","He was without sight for three days, and neither ate nor drank. ");
INSERT INTO engf35_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Now there was a certain disciple at Damascus named Ananias, and the Lord said to him in a vision, “Ananias!” So he said, “Here I am, Lord.” ");
INSERT INTO engf35_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","So the Lord said to him: “Get up and go to the street called Straight, and at the house of Judas inquire by name for Saul of Tarsus; because, you see, he is praying, ");
INSERT INTO engf35_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","and in a vision he has seen a man named Ananias coming in and placing a hand on him, so that he might recover his sight.” ");
INSERT INTO engf35_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","But Ananias answered: “Lord, I have heard from many about this man, how many evil things he has done to Your saints in Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Moreover here he has authority from the chief priests to bind all who are calling on Your name.” ");
INSERT INTO engf35_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","But the Lord said to him: “Get moving, because this man is a chosen vessel to me, to carry my name before nations and kings, also the children of Israel; ");
INSERT INTO engf35_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","for I will show him how many things he must suffer for my name's sake.” ");
INSERT INTO engf35_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","So Ananias went and entered the house, and placing his hands on him he said, “Brother Saul, the Lord, who appeared to you on the road by which you came, has sent me so that you may recover your sight and be filled by Holy Spirit.” ");
INSERT INTO engf35_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Immediately something like scales fell from his eyes, and he recovered his sight forthwith; and getting up he was baptized, ");
INSERT INTO engf35_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","and upon receiving food he was strengthened. So Saul was with the disciples in Damascus for a number of days. ");
INSERT INTO engf35_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Immediately he started proclaiming Jesus in the synagogues, that He is the Son of the God. ");
INSERT INTO engf35_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Well, all who heard him were astounded and started saying: “Isn't this the one who tried to destroy, in Jerusalem, those who called on this name? Even here he had come with that purpose, that he might take them bound to the high priests.” ");
INSERT INTO engf35_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","But Saul kept growing stronger and kept on confounding the Jews who lived in Damascus, proving that ‘This One is the Christ.’ ");
INSERT INTO engf35_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Now when a good many days had passed, the Jews plotted to kill him; ");
INSERT INTO engf35_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","but their plot became known to Saul. They started watching the gates day and night, so that they might kill him; ");
INSERT INTO engf35_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","so the disciples took him by night and passed him through the wall, lowering him in a hamper. ");
INSERT INTO engf35_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Now upon arriving in Jerusalem Saul kept trying to join himself to the disciples; but they were all afraid of him, not believing that he was a disciple. ");
INSERT INTO engf35_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","But Barnabas took him in tow and brought him to the apostles, and described to them how he had seen the Lord on the road, and that He had spoken to him, and how in Damascus he had spoken fearlessly in the name of the Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","So he was with them in Jerusalem, going in and out, and speaking fearlessly in the name of Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","He kept on speaking and debating with the Hellenists, so they started trying to kill him. ");
INSERT INTO engf35_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Upon finding it out, the brothers brought him down to Caesarea and sent him off to Tarsus. ");
INSERT INTO engf35_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","So then the congregations throughout all Judea and Galilee, and Samaria, had peace and were built up; and proceeding in the fear of the Lord and in the enabling of the Holy Spirit they were being multiplied. ");
INSERT INTO engf35_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Now it happened, as Peter went through all those parts, that he also went down to the saints who were living in Lydda. ");
INSERT INTO engf35_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","And there he found a certain man named Aeneas who was paralyzed—he had been lying on a pallet for eight years. ");
INSERT INTO engf35_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter said to him: “Aeneas, Jesus the Messiah is healing you. Get up and make your bed!” And immediately he stood up! ");
INSERT INTO engf35_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","All who were living in Lydda and Sharon saw him, and they turned to the Lord. ");
INSERT INTO engf35_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Now there was a certain disciple in Joppa named Tabitha, which is translated Dorcas. This woman was full of good works and charitable deeds that she kept doing. ");
INSERT INTO engf35_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","But it happened in those days that she took sick and died; so when they had washed her they placed her in the upper room. ");
INSERT INTO engf35_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Now Lydda was near Joppa; the disciples, having heard that Peter was there, sent to him imploring him not to delay in coming to them. ");
INSERT INTO engf35_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","So Peter got up and went with them; upon arriving they took him up to the upper room; all the widows stood around him weeping and showing the coats and garments that Dorcas was making while she was with them. ");
INSERT INTO engf35_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","So Peter put them all out, kneeled down and prayed. Turning to the body he said, “Tabitha, get up!” So she opened her eyes, and upon seeing Peter she sat up. ");
INSERT INTO engf35_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Then he gave her a hand and lifted her up, and calling the saints and widows he presented her alive. ");
INSERT INTO engf35_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","And it became known throughout all Joppa, and many believed on the Lord. ");
INSERT INTO engf35_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","So it was that he stayed many days in Joppa with a certain Simon, a tanner. ");
INSERT INTO engf35_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Now there was a certain man in Caesarea named Cornelius, a centurion of what was called the Italian Regiment, ");
INSERT INTO engf35_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","devout and fearing God with all his household, both giving alms generously to the people and praying to God about everything. ");
INSERT INTO engf35_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","About the ninth hour of the day, in a vision, he saw clearly an angel of God entering his presence and saying to him, “Cornelius!” ");
INSERT INTO engf35_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Well, staring at him and being frightened he said, “What is it, Lord?” So he said to him: “Your prayers and your alms have come up for a memorial before God. ");
INSERT INTO engf35_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Now send men to Joppa and summon Simon, who is surnamed Peter; ");
INSERT INTO engf35_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","he is lodging with one Simon, a tanner, whose house is by the sea.” ");
INSERT INTO engf35_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","So when the angel who spoke to him had departed, Cornelius called two of his household servants and a devout soldier from among those who were faithful to him, ");
INSERT INTO engf35_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","and explaining everything to them he sent them to Joppa. ");
INSERT INTO engf35_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Now on the next day, as they were traveling and drawing near to the city, Peter went up on the housetop to pray at about noon. ");
INSERT INTO engf35_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Well he became hungry and wanted to eat; but while they were preparing, a trance fell on him, ");
INSERT INTO engf35_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","and he saw the heaven opened and a container like a great sheet descending to him—it was tied at the four corners and was being let down to the earth— ");
INSERT INTO engf35_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","in which were all kinds of four-footed animals of the earth (both wild animals and reptiles) and birds of the sky. ");
INSERT INTO engf35_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Then a voice came to him, “Get up, Peter, slaughter and eat!” ");
INSERT INTO engf35_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","But Peter said: “No way, Lord! Never have I eaten anything ‘common’ or unclean!” ");
INSERT INTO engf35_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","So the voice came to him a second time, “What (pl) God has made clean you must not call ‘common’!” ");
INSERT INTO engf35_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Well this happened three times, and then the object was taken back up into the sky. ");
INSERT INTO engf35_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Now as Peter was really perplexed within himself as to what the vision that he had seen might mean, well the men who had been sent by Cornelius, having inquired and found Simon's house, stood before the gate, ");
INSERT INTO engf35_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","and calling out they inquired whether Simon, who was surnamed Peter, was staying there as a guest. ");
INSERT INTO engf35_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","So as Peter was pondering the vision the Spirit said to him: “Listen, some men are looking for you; ");
INSERT INTO engf35_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","so get up and go downstairs; and go with them, doubting nothing, for I have sent them.” ");
INSERT INTO engf35_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","So going down to the men Peter said: “Yes, I am the one you are looking for. For what reason have you come?” ");
INSERT INTO engf35_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","So they said: “Cornelius, a centurion, a righteous and God-fearing man, well spoken of by all the nation of the Jews, was divinely instructed by an angel to summon you to his house, and to hear words from you.” ");
INSERT INTO engf35_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","So he invited them in and put them up. The next day Peter set out with them, also some of the brothers from Joppa went with him; ");
INSERT INTO engf35_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","and the following day they entered Caesarea. Now Cornelius was waiting for them, having called together his relatives and close friends. ");
INSERT INTO engf35_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","So when Peter actually arrived, Cornelius met him, fell at his feet and worshiped. ");
INSERT INTO engf35_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","But Peter lifted him up, saying: “Stand up! I myself am also a man.” ");
INSERT INTO engf35_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","And conversing with him he went in and found many gathered there. ");
INSERT INTO engf35_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Then he said to them: “You know how it is unlawful for a Jewish man to associate with or to approach a different race; but God has shown me that I should not call any man ‘common’ or unclean. ");
INSERT INTO engf35_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Therefore also I came without objection as soon as I was sent for. So I ask, for what reason did you send for me?” ");
INSERT INTO engf35_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","So Cornelius said: “I have been fasting during four days until this very hour; yes, it was the ninth hour, I was praying in my house when wow, a man stood before me in shining clothing ");
INSERT INTO engf35_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","and said: ‘Cornelius, your prayer has been heard and your alms are remembered before God. ");
INSERT INTO engf35_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Send therefore to Joppa and summon Simon, who is surnamed Peter. He is lodging in the house of Simon, a tanner, by the sea; upon arriving he will speak to you.’ ");
INSERT INTO engf35_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","So I sent to you at once, and you did well to come. Now then, we are all present before God to hear all the things commanded you by God.” ");
INSERT INTO engf35_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","So opening his mouth Peter said: “Really, I comprehend that God is not One to show partiality, ");
INSERT INTO engf35_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","but in every ethnic nation whoever fears Him and works righteousness is acceptable to Him. ");
INSERT INTO engf35_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","The word that He sent to the sons of Israel, preaching good news of peace through Jesus Christ—He is Lord of all— ");
INSERT INTO engf35_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","that spoken word you know, that was proclaimed throughout all Judea, beginning from Galilee, after the baptism that John preached: ");
INSERT INTO engf35_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesus of Natsareth, how God anointed Him with Holy Spirit and power, who went about doing good and healing all those being oppressed by the devil, because God was with Him ");
INSERT INTO engf35_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","—yes, we are witnesses of all that He did, both in the country of the Jews and in Jerusalem—whom they also killed, hanging Him on a tree. ");
INSERT INTO engf35_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Him God raised on the third day, and gave Him to become visible, ");
INSERT INTO engf35_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","not to all the people but to witnesses who had been chosen beforehand by God, to us, who ate and drank with Him after He arose out from the dead. ");
INSERT INTO engf35_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","And He ordered us to proclaim to the people, that is, to testify that He is the One who has been ordained by God as Judge of living and dead. ");
INSERT INTO engf35_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","To Him all the prophets bear witness that through His name everyone who believes into Him will receive forgiveness of sins.” ");
INSERT INTO engf35_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","While Peter was still speaking these words, the Holy Spirit fell on all who were hearing the message. ");
INSERT INTO engf35_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Well the believers of the circumcision Jews who had come with Peter were astonished, because the gift of the Holy Spirit had also been poured out on the Gentiles, ");
INSERT INTO engf35_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","in that they heard them speaking languages and magnifying God. Then Peter responded: ");
INSERT INTO engf35_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Surely no one can forbid the water, can he, that these should not be baptized who received the Holy Spirit just like we did?” ");
INSERT INTO engf35_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","So he commanded them to be baptized in the name of the Lord Jesus. Then they asked him to stay a few days. ");
INSERT INTO engf35_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Now the Apostles and the brothers throughout Judea heard that the Gentiles had also received the word of God. ");
INSERT INTO engf35_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","When Peter went up to Jerusalem, those of the circumcision party started contending with him, ");
INSERT INTO engf35_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","saying, “You went in to uncircumcised men and ate with them!” ");
INSERT INTO engf35_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","So Peter began by explaining it to them in order, saying: ");
INSERT INTO engf35_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“I was in the town of Joppa praying, and in a trance I saw a vision: a certain object like a great sheet coming down out of the sky, being lowered by its four corners; and it came to me. ");
INSERT INTO engf35_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Upon peering into it I observed and distinguished the quadrupeds of the earth—both the wild animals and the reptiles—and the birds of the sky. ");
INSERT INTO engf35_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Then I heard a voice saying to me, ‘Get up, Peter, slaughter and eat!’ ");
INSERT INTO engf35_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","So I said: ‘No way, Lord! Never has anything ‘common’ or unclean entered my mouth!’ ");
INSERT INTO engf35_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","But the voice answered me, a second time, from heaven, ‘Things that God has made clean you must not call ‘common’.’ ");
INSERT INTO engf35_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Well this was done three times, and it was all pulled back up into the sky. ");
INSERT INTO engf35_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","At that very moment three men stopped in front of the house where I was, having been sent from Caesarea to me. ");
INSERT INTO engf35_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","The Spirit told me to go with them, doubting nothing. These six brothers also went with me, and we entered the man's house. ");
INSERT INTO engf35_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","He then related to us how he had seen the angel standing in his house and saying to him, ‘Send to Joppa and summon Simon, who is called Peter, ");
INSERT INTO engf35_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","who will speak words to you by which you and all your household will be saved.’ ");
INSERT INTO engf35_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Well as I began to speak, the Holy Spirit fell on them, just as on us at the beginning. ");
INSERT INTO engf35_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","I remembered the word of the Lord, how He said, ‘John indeed baptized with water, but you will be baptized with Holy Spirit.’ ");
INSERT INTO engf35_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","So if God gave them the same gift as He gave us when we believed upon the Lord Jesus, who was I to be able to withstand God?” ");
INSERT INTO engf35_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Upon hearing these things they acquiesced and started glorifying God, saying, “So then, God has also granted to the Gentiles repentance into life!” ");
INSERT INTO engf35_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Now those who had been scattered by the persecution that came about in connection with Stephen traveled as far as Phoenicia, Cyprus and Antioch, speaking the word to no one except Jews only. ");
INSERT INTO engf35_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","But there were some of them, men of Cyprus and Cyrene, who upon entering Antioch started speaking to the Greek-speakers, preaching the good news of the Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","And the hand of the Lord was with them, and a great number believed and turned to the Lord. ");
INSERT INTO engf35_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Well the report concerning them reached the ears of the church in Jerusalem, and they sent out Barnabas to go as far as Antioch. ");
INSERT INTO engf35_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Upon arriving and seeing the grace of God, he was glad, and he kept encouraging them all to remain true to the Lord with purpose of heart ");
INSERT INTO engf35_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","(for he was a good man, full of Holy Spirit and of faith). And a considerable crowd was added to the Lord. ");
INSERT INTO engf35_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Then Barnabas departed for Tarsus to look for Saul, ");
INSERT INTO engf35_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","and upon finding him he brought him to Antioch. So it was that for a whole year they met with the congregation and taught a great many people. The disciples were first called Christians in Antioch. ");
INSERT INTO engf35_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Now in these days, prophets came from Jerusalem to Antioch. ");
INSERT INTO engf35_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","One of them, named Agabus, stood up and indicated by the Spirit that a great famine was about to come upon the whole world (this indeed happened while Claudius was Caesar). ");
INSERT INTO engf35_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Then the disciples, to the extent that any had plenty, each of them determined to send relief to the brothers who lived in Judea; ");
INSERT INTO engf35_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","which they also did, sending it to the elders by Barnabas and Saul. ");
INSERT INTO engf35_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Now about that time, Herod the king laid hands on some from the church to mistreat them. ");
INSERT INTO engf35_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","James, the brother of John, he put to death by sword. ");
INSERT INTO engf35_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","When he saw that it was pleasing to the Jews, he proceeded to arrest Peter as well (it was during the days of the unleavened loaves) ");
INSERT INTO engf35_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","—upon seizing him he put him in prison, turning him over to sixteen soldiers to guard him, intending to bring him out to the people after the Passover. ");
INSERT INTO engf35_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Well Peter was being held in the prison all right, but the congregation was making earnest prayer to God on his behalf. ");
INSERT INTO engf35_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","So when Herod was about to bring him out, that night Peter was sleeping between two soldiers, bound with two chains, with guards protecting the prison in front of the doors. ");
INSERT INTO engf35_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Suddenly, an angel of the Lord was there, and a light shone in the cell; striking Peter on the side he roused him saying, “Quick, get up!” and the chains fell away from his wrists. ");
INSERT INTO engf35_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Then the angel said to him, “Fasten your belt and put on your sandals.” So he did. Then he said to him, “Put on your cloak and follow me.” ");
INSERT INTO engf35_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","So he went out and started following him, not realizing that what the angel was doing was real; he supposed he was seeing a vision. ");
INSERT INTO engf35_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Passing through the first and second guard posts, they came to the iron gate that leads into the city, that opened for them by itself; upon exiting they advanced one block, and suddenly the angel left him. ");
INSERT INTO engf35_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","When Peter had come to himself he said, “Now I know for certain that the Lord sent His angel and delivered me out of Herod's hand and from all the expectation of the Jewish people.” ");
INSERT INTO engf35_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Upon reflection he went to the house of Mary, the mother of John (the one called Mark), where a considerable number had gathered and were praying. ");
INSERT INTO engf35_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","When Peter knocked at the door of the gate, a servant girl named Rhoda came to answer. ");
INSERT INTO engf35_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Upon recognizing Peter's voice, she was so glad she did not open the gate, but ran in and announced that Peter was standing before the gate! ");
INSERT INTO engf35_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","But they said to her, “You're crazy!” but she kept insisting that it was so. So they said, “It is his angel.” ");
INSERT INTO engf35_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","But Peter kept on knocking; so when they opened the door and saw him, they were astounded. ");
INSERT INTO engf35_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Motioning to them with his hand to be silent, he related to them how the Lord had brought him out of the prison. Then he said, “Tell these things to James and the brothers.” And going out he went off to a different place. ");
INSERT INTO engf35_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Now as soon as it was day, there was no small commotion among the soldiers about what had become of Peter! ");
INSERT INTO engf35_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Well after searching for him and not finding him, Herod examined the guards and ordered that they be executed. Going down from Judea to Caesarea, he stayed there. ");
INSERT INTO engf35_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Now Herod was very angry with the people of Tyre and Sidon; so they came with one accord to him, and having won over Blastus, the king's chamberlain, they asked for peace, because their country was supplied with food from the king's. ");
INSERT INTO engf35_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","So on an appointed day Herod, arrayed in royal apparel, sat on the throne and started to deliver an address to them. ");
INSERT INTO engf35_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","But the crowd started calling out, “The voice of a god and not of a man!” ");
INSERT INTO engf35_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Immediately an angel of the Lord struck him down, because he did not give glory to God, and being eaten by worms, he died. ");
INSERT INTO engf35_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","And the Word of God kept growing and multiplying. ");
INSERT INTO engf35_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Now Barnabas and Saul returned to Antioch, having fulfilled their mission, also taking with them John, the one called Mark. ");
INSERT INTO engf35_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Now in the congregation that was in Antioch there were certain prophets and teachers: Barnabas, Simeon (the one called Niger), Lucius the Cyrenian, Manaen (who had been brought up with Herod the tetrarch), and Saul. ");
INSERT INTO engf35_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","As they were ministering to the Lord and fasting, the Holy Spirit said, “Set apart to me Barnabas and Saul for the work to which I have called them!” ");
INSERT INTO engf35_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Then, having fasted and prayed and laid their hands on them, they sent them off. ");
INSERT INTO engf35_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","So, having been sent out by the Holy Spirit, they went down to Seleucia; and from there they sailed to Cyprus. ");
INSERT INTO engf35_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","And upon arriving in Salamis, they started proclaiming the Word of God in the synagogues of the Jews (also they had John as assistant). ");
INSERT INTO engf35_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Now when they had gone through the island to Paphos, they found a certain sorcerer, a false prophet, a Jew named Bar-Jesus, ");
INSERT INTO engf35_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","who was with the proconsul, Sergius Paulus, an intelligent man. This man summoned Barnabas and Saul, really wanting to hear the Word of God. ");
INSERT INTO engf35_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","But the sorcerer Elymas (for so his name is translated) opposed them, seeking to turn the proconsul away from the faith. ");
INSERT INTO engf35_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Then Saul, also called Paul, filled with Holy Spirit and looking intently at him, ");
INSERT INTO engf35_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","said: “O full of all deceit and all trickery, son of a devil, enemy of all righteousness! Will you not stop perverting the straight ways of the Lord? ");
INSERT INTO engf35_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Well now, the Lord's hand is against you and you will be blind, not seeing the sun until next season!” Immediately mist and darkness engulfed him, and he started going around looking for someone to lead him by the hand. ");
INSERT INTO engf35_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Then the proconsul believed, when he saw what had happened, being astonished at the teaching of the Lord. ");
INSERT INTO engf35_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Then Paul and his party set sail from Paphos and came to Perga in Pamphilia (here John left them and returned to Jerusalem). ");
INSERT INTO engf35_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Going on from Perga they arrived in Antioch of Pisidia; and entering the synagogue on the Sabbath day, they sat down. ");
INSERT INTO engf35_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","After the reading of the Law and the Prophets, the synagogue leaders sent to them, saying, “Men, brothers, if you have a word of encouragement for the people, do speak.” ");
INSERT INTO engf35_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","So standing up and motioning with his hand, Paul said: “Men of Israel and you who fear God, listen. ");
INSERT INTO engf35_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","The God of this people chose our fathers, and prospered the people during their sojourn in the land of Egypt, and brought them out of it with an uplifted arm. ");
INSERT INTO engf35_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","For a period of about forty years He put up with them in the wilderness. ");
INSERT INTO engf35_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","And when He had destroyed seven nations in the land of Canaan, He gave them possession of their land. ");
INSERT INTO engf35_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","After these things, He gave judges for about four hundred and fifty years, until Samuel the prophet. ");
INSERT INTO engf35_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","And then they asked for a king, and God gave them Saul, a son of Kish, a man of the tribe of Benjamin, for forty years. ");
INSERT INTO engf35_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","And removing him He raised up for them David as king, about whom He gave witness and said, ‘I have found David son of Jesse a man after my heart, who will do all my will.’ ");
INSERT INTO engf35_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","God, from this man's seed, according to promise, has brought Salvation to Israel, ");
INSERT INTO engf35_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","John having heralded beforehand, in advance of His coming, a baptism of repentance to Israel. ");
INSERT INTO engf35_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Well, as John was fulfilling his course, he said: ‘Whom do you suppose me to be? No I am not—but indeed He comes after me, the sandals of whose feet I am not worthy to untie.’ ");
INSERT INTO engf35_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Men, brothers, sons of the stock of Abraham, and those among you who fear God: to you the word of this salvation has been sent. ");
INSERT INTO engf35_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","The Jerusalem dwellers and their rulers, understanding neither Him nor the voices of the prophets that are read every Sabbath, fulfilled them by condemning Him. ");
INSERT INTO engf35_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Though they found no cause for death, they asked Pilate to have Him executed. ");
INSERT INTO engf35_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","When they had fulfilled all things that were written about Him, they took Him down from the cross and placed Him in a tomb. ");
INSERT INTO engf35_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","But God raised Him from the dead; ");
INSERT INTO engf35_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","and for many days He was seen by those who came up with Him from Galilee to Jerusalem, who are His witnesses to the people. ");
INSERT INTO engf35_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Yes we proclaim to you the good news: the promise that was made to the fathers, ");
INSERT INTO engf35_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","God has fulfilled the same to us, their children, when He raised up Jesus; as also it stands written in the second Psalm: ‘You are my Son, today I have begotten you.’ ");
INSERT INTO engf35_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","And that He raised Him from the dead, no longer to return to corruption, He has spoken thus, ‘I will give you the holy things guaranteed to David.’ ");
INSERT INTO engf35_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Further, it is stated elsewhere, ‘You will not allow your Holy One to see decay.’ ");
INSERT INTO engf35_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Now David, after he had served his own generation by the will of God, fell asleep, was buried with his fathers, and saw decay; ");
INSERT INTO engf35_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","but the One whom God raised up did not see decay. ");
INSERT INTO engf35_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Therefore, let it be known to you, men, brothers, that through this One forgiveness of sins is proclaimed to you; ");
INSERT INTO engf35_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","and by Him everyone who believes is justified from everything you could not be justified from by the Law of Moses. ");
INSERT INTO engf35_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","So take care, lest there come upon you that which has been spoken in the prophets: ");
INSERT INTO engf35_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Look you despisers, marvel and perish! For I am working a work in your days to which you will not give credence, even if someone were to explain it in detail to you.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Now as the Jews were going out of the synagogue, the Gentiles implored repeatedly that these words might be spoken to them the next Sabbath. ");
INSERT INTO engf35_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","The synagogue service having been dismissed, many of the Jews and the devout proselytes followed Paul and Barnabas, who started addressing them, urging them to continue in the grace of God. ");
INSERT INTO engf35_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Well the next Sabbath almost the whole city was gathered to hear the Word of God. ");
INSERT INTO engf35_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","But when the Jews saw the crowds, they were filled with envy and started speaking against the things said by Paul, contradicting and blaspheming. ");
INSERT INTO engf35_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","But Paul and Barnabas speaking boldly said: “It was necessary that God's Word should be spoken to you first. But since you reject it, and judge yourselves unworthy of eternal life, now we are being turned to the Gentiles. ");
INSERT INTO engf35_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Because that is just how the Lord has commanded us: ‘I have set you to be a light for ethnic nations, that you should be for salvation up to the last place on earth.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Now upon hearing this, the Gentiles rejoiced and glorified the Word of the Lord; and as many as had been appointed to eternal live believed. ");
INSERT INTO engf35_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Well the Word of the Lord was being spread throughout all the region. ");
INSERT INTO engf35_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","But the Jews stirred up the devout and prominent women and the chief men of the city, and raised up a persecution against Paul and Barnabas, and expelled them from their borders. ");
INSERT INTO engf35_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","So they shook off the dust from their feet against them, and went to Iconium. ");
INSERT INTO engf35_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","But the disciples were filled with joy and with Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Now it happened in Iconium that they went together into the synagogue of the Jews, and they spoke to such effect that a large number of both Jews and Greeks believed. ");
INSERT INTO engf35_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","But the disobedient Jews stirred up the Gentiles and poisoned their minds against the brothers. ");
INSERT INTO engf35_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Even so they stayed there a considerable time, speaking boldly for the Lord, who was bearing witness to the word of His grace, giving signs and wonders to take place by their hands. ");
INSERT INTO engf35_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Well the population of the city became divided; some sided with the Jews, others with the apostles. ");
INSERT INTO engf35_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","But when a plot was hatched by both Gentiles and Jews, with their rulers, to mistreat and stone them, ");
INSERT INTO engf35_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","they became aware of it and escaped to the cities of Lycaonia—Lystra, Derbe and the surrounding area— ");
INSERT INTO engf35_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","where they continued to preach the Gospel. ");
INSERT INTO engf35_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Well in Lystra a certain man with helpless feet was sitting (lame from his mother's womb, who had never walked). ");
INSERT INTO engf35_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","This man was listening to Paul speaking; who looking intently at him and seeing that he had faith to be healed, ");
INSERT INTO engf35_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","said with a loud voice, “Stand up straight on your feet!” And the man jumped up and began to walk! ");
INSERT INTO engf35_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Now when the crowd saw what Paul had done, they raised their voices, saying in Lycaonian, “The gods have come down to us in the likeness of men!” ");
INSERT INTO engf35_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","And Barnabas they called Zeus, and Paul, Hermes, because he was the chief speaker. ");
INSERT INTO engf35_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Then the priest of Zeus, whose temple was in front of their city, brought bulls and garlands to the gates, intending to make a sacrifice, along with the crowd. ");
INSERT INTO engf35_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","But when the apostles, Barnabas and Paul, heard of it, they tore their clothes and rushed into the crowd, crying out ");
INSERT INTO engf35_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","and saying: “Men, why are you doing these things? We also are men with the same nature as you, giving you good news, telling you to turn from these useless things to the living God, who made the heaven and the earth and the sea and all that is in them; ");
INSERT INTO engf35_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","who in the former generations allowed all the ethnic nations to walk in their own ways. ");
INSERT INTO engf35_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nevertheless He did not leave Himself without witness, doing good, giving you rain from heaven and fruitful seasons, filling our hearts with food and gladness.” ");
INSERT INTO engf35_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Even saying these things, they barely stopped the crowd from sacrificing to them. ");
INSERT INTO engf35_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Then Jews from Antioch and Iconium came, and having persuaded the crowd and having stoned Paul, they dragged him out of the city, supposing him to have died. ");
INSERT INTO engf35_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","But as the disciples stood around him, he got up and entered the city. The next day he departed with Barnabas to Derbe. ");
INSERT INTO engf35_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","When they had evangelized that city and discipled a good number, they returned to Lystra and Iconium and Antioch, ");
INSERT INTO engf35_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","strengthening the souls of the disciples, exhorting them to continue in the faith, and saying, “We must go through many hardships to enter the kingdom of God.” ");
INSERT INTO engf35_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","When they had appointed elders for them in every congregation, having prayed with fasting, they commended them to the Lord into whom they had believed. ");
INSERT INTO engf35_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","After going through Pisidia, they came to Pamphilia. ");
INSERT INTO engf35_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","When they had declared the Word in Perga, they went down to Attalia. ");
INSERT INTO engf35_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","From there they sailed to Antioch, from where they had been commended to the grace of God for the work that they had completed. ");
INSERT INTO engf35_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","So upon arriving and gathering the congregation, they reported all that God had done with them, and that He had opened the door of faith to the Gentiles. ");
INSERT INTO engf35_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","And they stayed there a long time with the disciples. ");
INSERT INTO engf35_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Then some men came down from Judea and started teaching the brothers, “Unless you are circumcised according to the custom of Moses, you cannot be saved.” ");
INSERT INTO engf35_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Well this provoked serious dissension and argument between Paul and Barnabas and them, so Paul and Barnabas were appointed, along with certain others of them, to go up to Jerusalem to the apostles and elders about this question. ");
INSERT INTO engf35_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","So being sent on their way by the congregation, they passed through Phoenicia and Samaria, describing the conversion of the Gentiles; and they caused great joy to all the brothers. ");
INSERT INTO engf35_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Upon arriving in Jerusalem, they were received by the congregation and the apostles and the elders, and they reported all that God had done with them. ");
INSERT INTO engf35_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","But some of the sect of the Pharisees who believed rose up, saying, “It is necessary to circumcise them, and to command them to keep the Law of Moses.” ");
INSERT INTO engf35_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","So the apostles and the elders came together to consider this matter. ");
INSERT INTO engf35_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","When there had been plenty of discussion, Peter got up and said to them: “Men, brothers, you know that a good while ago God made a choice among you, that by my mouth the Gentiles should hear the message of the Gospel and believe. ");
INSERT INTO engf35_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","And the heart-knowing God acknowledged them by giving them the Holy Spirit, just as He did to us; ");
INSERT INTO engf35_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","and He made no distinction between us and them, purifying their hearts by faith. ");
INSERT INTO engf35_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Now therefore, why do you test God by putting a yoke on the neck of the disciples that neither our fathers nor we have been able to bear? ");
INSERT INTO engf35_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Rather, we believe that we are saved through the grace of the Lord Jesus, in the same manner as they.” ");
INSERT INTO engf35_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Then the whole assembly kept silent and listened to Barnabas and Paul reporting what signs and wonders God had done among the ethnic nations through them. ");
INSERT INTO engf35_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Now when they finished, James reacted saying: “Men, brothers, listen to me. ");
INSERT INTO engf35_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon has described how God first intervened to extract from the Gentiles a people for His name. ");
INSERT INTO engf35_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","And with this the words of the prophets agree, just as it is written: ");
INSERT INTO engf35_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘After these things I will return, and I will rebuild David's tent, the fallen one; yes, I will rebuild its ruins and restore it; ");
INSERT INTO engf35_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","so that the remnant of mankind may seek the Lord, even all the Gentiles—the ones, that is, upon whom my name has been called—says the Lord who does all these things.’ ");
INSERT INTO engf35_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","All His works are known to God from eternity. ");
INSERT INTO engf35_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Therefore I judge that we should not create difficulty for those who are turning to God from among the ethnic nations, ");
INSERT INTO engf35_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","but that we write to them to abstain from things polluted by idols, from fornication, from what is strangled, and from blood. ");
INSERT INTO engf35_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","For from ancient generations Moses has in every city those who preach him, being read in the synagogues every Sabbath.” ");
INSERT INTO engf35_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Then it pleased the apostles and the elders, with the whole congregation, to send chosen men from among them to Antioch with Paul and Barnabas: Judas (the one called Barsabas) and Silas, leading men among the brothers. ");
INSERT INTO engf35_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","They wrote by their hand the following: “The apostles and the elders and the brothers, to the Gentile brothers in Antioch, Syria and Cilicia: Greetings. ");
INSERT INTO engf35_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Since we have heard that some who went out from among us have disturbed you with words, unsettling your souls, saying that you must be circumcised and keep the Law—to whom we gave no such authorization— ");
INSERT INTO engf35_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","it seemed good to us, having come to one accord, to choose men to send to you with our beloved Barnabas and Paul, ");
INSERT INTO engf35_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","men who have risked their lives for the sake of the name of our Lord Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","So we have sent Judas and Silas, who will also confirm these things by word of mouth. ");
INSERT INTO engf35_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","It seemed good to the Holy Spirit, and to us, to place no greater burden upon you than these necessary things: ");
INSERT INTO engf35_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","to abstain from things offered to idols, from ‘blood’, from anything strangled and from fornication; it will be in your own best interest to keep away from these things. Farewell.” ");
INSERT INTO engf35_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","So when they were sent off they came to Antioch, and gathering the crowd they delivered the letter. ");
INSERT INTO engf35_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","When they had read it, they rejoiced over the encouragement. ");
INSERT INTO engf35_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Both Judas and Silas, also being prophets themselves, encouraged and strengthened the brothers with many words. ");
INSERT INTO engf35_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","After some time, they were released with peace from the brothers to the apostles. ");
INSERT INTO engf35_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","But Paul and Barnabas remained in Antioch, teaching and preaching the Word of the Lord, with many others also. ");
INSERT INTO engf35_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Some time later Paul said to Barnabas, “Let us return now and visit our brothers in each city where we proclaimed the word of the Lord, to see how they are doing.” ");
INSERT INTO engf35_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Now Barnabas resolved to take John (the one called Mark) along as well. ");
INSERT INTO engf35_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","But Paul insisted on not taking someone who had deserted them in Pamphilia and not gone with them to the work. ");
INSERT INTO engf35_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Well the contention became so sharp that they separated from each other. Barnabas took Mark and sailed to Cyprus; ");
INSERT INTO engf35_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","while Paul chose Silas and set out, having been commended by the brothers to the grace of God. ");
INSERT INTO engf35_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","He went through Syria and Cilicia, strengthening the congregations. ");
INSERT INTO engf35_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","So he came to Derbe and Lystra. Well now, a certain disciple was there named Timothy, son of a certain Jewish woman who believed, but his father was a Greek; ");
INSERT INTO engf35_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","he was well spoken of by the brothers in Lystra and Iconium. ");
INSERT INTO engf35_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul wanted to have him go on with him, so he took and circumcised him because of the Jews who were in those parts, because they all knew that his father was a Greek. ");
INSERT INTO engf35_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","As they were going through the cities they were delivering the dogmas to them, to keep—the ones that had been determined by the apostles and the elders in Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","So the congregations kept on being strengthened in the faith, and were increasing in number daily. ");
INSERT INTO engf35_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Now when they had gone through Phrygia and the region of Galatia, having been forbidden by the Holy Spirit to speak the word in Asia, ");
INSERT INTO engf35_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","they approached Mysia and tried to go to Bithynia, but the Spirit did not permit them. ");
INSERT INTO engf35_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","So they bypassed Mysia and went down to Troas. ");
INSERT INTO engf35_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A vision appeared to Paul during the night: a man of Macedonia was standing, appealing to him and saying, “Come over to Macedonia and help us.” ");
INSERT INTO engf35_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","So when he saw the vision, we immediately prepared to go over to Macedonia, concluding that the Lord had called us to evangelize them. ");
INSERT INTO engf35_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","So setting sail from Troas, we ran a straight course to Samothrace, and the next day to Neapolis; ");
INSERT INTO engf35_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","and from there to Philippi, which is the foremost city of that part of Macedonia, a colony. We stayed some days in that city. ");
INSERT INTO engf35_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","On the Sabbath day we went outside the city by a river, where prayer was customarily made, and sitting down we started speaking to the assembled women. ");
INSERT INTO engf35_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","A certain woman named Lydia, a dealer in purple cloth from the city of Thyatira, who worshiped God, really listened, whose heart the Lord opened to give heed to the things spoken by Paul. ");
INSERT INTO engf35_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","When she and her household were baptized, she appealed saying, “If you have judged me to be faithful to the Lord, come into my house and stay.” So she persuaded us. ");
INSERT INTO engf35_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Now it happened, as we were going to prayer, that a certain slave girl having a spirit of divination met us, who brought considerable profit to her owners by divination. ");
INSERT INTO engf35_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Following Paul and Silas this girl kept calling out, “These men are servants of the Most High God, who are proclaiming to us the way of salvation!” ");
INSERT INTO engf35_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","She kept this up for many days! So Paul, becoming increasingly annoyed, turned and said to the spirit, “I command you in the name of Jesus Christ to come out of her!” And it came out that very hour. ");
INSERT INTO engf35_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","But when her owners saw that their hope of profit was gone, they seized Paul and Silas and dragged them into the market place to the rulers, ");
INSERT INTO engf35_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","and bringing them before the magistrates they said, “These men, being Jews, are agitating our city, ");
INSERT INTO engf35_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","and are advocating customs that are not lawful for us, being Romans, to receive or do.” ");
INSERT INTO engf35_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","The crowd joined in the attack against them, and the magistrates tore the clothes off of them and ordered a beating with rods. ");
INSERT INTO engf35_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","When they had laid many stripes on them, they threw them into prison, charging the jailer to keep them securely; ");
INSERT INTO engf35_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","who, having received such a charge, threw them into the inner cell and fastened their feet in the stocks. ");
INSERT INTO engf35_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Well about midnight Paul and Silas were singing hymns to God in prayer; and the other prisoners were listening to them. ");
INSERT INTO engf35_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Suddenly there was a great earthquake, enough to shake the foundations of the prison; immediately all the doors were opened and everyone's chains were loosed. ");
INSERT INTO engf35_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","But the jailer, awaking from sleep and seeing the prison doors open, drew sword, intending to kill himself, supposing that the prisoners had escaped. ");
INSERT INTO engf35_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","But Paul shouted out, “Don't harm yourself, because we are all here!” ");
INSERT INTO engf35_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","So calling for a light he ran in and fell down trembling before Paul and Silas. ");
INSERT INTO engf35_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","He then brought them out and said, “Sirs, what must I do to be saved?” ");
INSERT INTO engf35_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","So they said, “Believe upon the Lord Jesus Christ and you will be saved, you and your household.” ");
INSERT INTO engf35_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Then they spoke the Word of the Lord to him and to all who were in his house. ");
INSERT INTO engf35_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","In that same hour of the night he took them aside and washed their wounds, and thereupon he and all his family were baptized. ");
INSERT INTO engf35_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Then he brought them into his house and set a meal before them, and he was really rejoicing, having believed in God with his whole family. ");
INSERT INTO engf35_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Now when it was day the magistrates sent the officers saying, “Let those men go.” ");
INSERT INTO engf35_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","So the jailer reported these words to Paul, “The magistrates have sent to release you; so now you can leave and go in peace.” ");
INSERT INTO engf35_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","But Paul said to them: “After severely beating us in public, although we were uncondemned Romans, they threw us into prison, and now do they toss us out on the sly? No way! Rather, let them come themselves and escort us out!” ");
INSERT INTO engf35_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","So the officers reported these words to the magistrates, and they were afraid when they heard that they were Romans; ");
INSERT INTO engf35_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","and they came and appealed to them, and leading them out they asked them to leave the city. ");
INSERT INTO engf35_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","So exiting the prison they entered Lydia's place, and upon seeing the brothers they encouraged them and departed. ");
INSERT INTO engf35_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Now when they had passed through Amphipolis and Apollonia, they came to Thessalonica, where there was a synagogue of the Jews. ");
INSERT INTO engf35_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","So Paul, as was his custom, went in to them and for three Sabbaths reasoned with them from the Scriptures, ");
INSERT INTO engf35_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","explaining and demonstrating that the Messiah had to suffer and rise again from the dead, and that “this Jesus whom I proclaim to you is the Messiah.” ");
INSERT INTO engf35_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Some of them were persuaded and joined Paul and Silas, as did a large number of devout Greeks and not a few of the prominent women. ");
INSERT INTO engf35_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","But the disobedient Jews rounded up some wicked men from the marketplace, and forming a mob they created an uproar in the city; and attacking the house of Jason, they wanted to bring them out to the crowd. ");
INSERT INTO engf35_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","But not finding them they dragged Jason and some other brothers before the city officials vociferating: “These who have upset the whole world have come here too, ");
INSERT INTO engf35_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","to whom Jason has given lodging. These all act contrary to the decrees of Caesar, saying there is another king—Jesus.” ");
INSERT INTO engf35_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Well they agitated the crowd and the city officials when they heard these things. ");
INSERT INTO engf35_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Then they took a security bond from Jason and the rest and let them go. ");
INSERT INTO engf35_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Immediately, during the night, the brothers sent both Paul and Silas away to Berea; on arriving they went into the synagogue of the Jews. ");
INSERT INTO engf35_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Now these were more noble-minded than those in Thessalonica, in that they received the word with all goodwill, examining the Scriptures daily to see whether these things might be so. ");
INSERT INTO engf35_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Therefore many of them believed, and also not a few of the Greeks, prominent women as well as men. ");
INSERT INTO engf35_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","But when the Jews from Thessalonica learned that the Word of God was also being proclaimed by Paul in Berea, they came too, agitating the crowds. ");
INSERT INTO engf35_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","So then, without delay, the brothers sent Paul away, as if to go by sea, while both Silas and Timothy remained there. ");
INSERT INTO engf35_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","But those who were conducting Paul actually took him all the way to Athens; and receiving a command to Silas and Timothy that they should come to him as quickly as possible, they started back. ");
INSERT INTO engf35_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Now while Paul was waiting for them in Athens, his spirit was increasingly aroused within him as he observed that the city was full of idols. ");
INSERT INTO engf35_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","So he reasoned both in the synagogue with the Jews and devout persons, and in the marketplace day by day with those who happened to be there. ");
INSERT INTO engf35_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Then certain philosophers, both Epicureans and Stoics, encountered him. Some said, “What might this idea-scavenger want to say?” Others said, “He seems to be a proclaimer of foreign deities”—because he was preaching Jesus and the resurrection. ");
INSERT INTO engf35_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","So taking him in tow they led him to the Areopagus and said: “May we know what this new teaching is that you are presenting? ");
INSERT INTO engf35_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Because you are bringing some strange things to our ears, and we would like to know what they might mean.” ");
INSERT INTO engf35_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Now all Athenians and resident foreigners spent their time in nothing else but to tell, or else to hear, some novelty.) ");
INSERT INTO engf35_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","So standing in the middle of the Areopagus Paul said: “Men of Athens, I perceive that in all things you are very religious; ");
INSERT INTO engf35_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","because as I went along and scrutinized the objects of your worship, I even found an altar with this inscription: TO UNKNOWN GOD. Now then, the one you worship as ‘unknown’, this is the One I proclaim to you: ");
INSERT INTO engf35_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","The God who made the world and everything in it, since He is Lord of heaven and earth, does not dwell in temples built by hands, ");
INSERT INTO engf35_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","neither is He cared for by men's hands, as though He needed anything, since He Himself has always given life and breath to all. ");
INSERT INTO engf35_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","And from one blood He made every ethnic nation of men to dwell on all the surface of the earth, having determined their appointed times and the boundaries of their dwellings, ");
INSERT INTO engf35_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","so that they should seek the Lord, if perhaps they might grope for Him and find Him, though He is not far from each one of us; ");
INSERT INTO engf35_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","because in Him we live and move and have our being. As also some of your own poets have said, ‘For we are also his offspring.’ ");
INSERT INTO engf35_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Therefore, since we are God's offspring, we ought not to think that the divinity is like gold or silver or stone—something shaped by human skill and imagination. ");
INSERT INTO engf35_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Such times of ignorance God did indeed overlook, but now He commands all people everywhere to repent, ");
INSERT INTO engf35_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","because He has appointed a day in which He will judge the inhabited world in righteousness by the Man whom He has ordained; He has given assurance of this to all by raising Him from the dead.” ");
INSERT INTO engf35_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Well when they heard about the resurrection of the dead, some started scoffing, while others said, “We will hear you again about this.” ");
INSERT INTO engf35_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","And with that Paul went out from among them. ");
INSERT INTO engf35_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","However some men believed and joined him, among them Dionysius the Areopagite, also a woman named Damaris, and others with them. ");
INSERT INTO engf35_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Now after these things Paul left Athens and went to Corinth. ");
INSERT INTO engf35_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","And encountering a certain Jew named Aquila, a native of Pontus, who had recently come from Italy with his wife Priscilla (because Claudius had ordered all the Jews to depart from Rome), he joined them; ");
INSERT INTO engf35_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","and because he practiced the same trade, he stayed on with them and worked (their trade was tentmaker). ");
INSERT INTO engf35_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Every Sabbath in the synagogue he would reason with both Jews and Greeks, trying to persuade them. ");
INSERT INTO engf35_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","But when Silas and Timothy came down from Macedonia, Paul was constrained by the Spirit, solemnly insisting to the Jews: Jesus is the Christ. ");
INSERT INTO engf35_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","But since they kept contradicting and blaspheming, he shook his clothes and said to them: “Your blood be upon your own heads! I am clean. From now on I will go to the Gentiles.” ");
INSERT INTO engf35_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","So he moved from there into the house of a man named Justus, a worshiper of God, whose house was next door to the synagogue. ");
INSERT INTO engf35_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Then Crispus, the ruler of the synagogue, believed on the Lord with all his household; and as they were hearing, many of the Corinthians were believing and being baptized. ");
INSERT INTO engf35_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Now the Lord said to Paul by a vision at night: “Do not be afraid; rather speak and do not keep silent, ");
INSERT INTO engf35_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","because I am with you and no one will attack you to harm you, because I have many people in this city.” ");
INSERT INTO engf35_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","So he stayed on for a year and six months, teaching the Word of God among them. ");
INSERT INTO engf35_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Now while Gallio was proconsul of Achaia, the Jews with one accord rose up against Paul and brought him to the judgment seat, ");
INSERT INTO engf35_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","saying, “This fellow persuades the people to worship God contrary to the law.” ");
INSERT INTO engf35_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","But when Paul was about to open his mouth, Gallio said to the Jews: “If there really was some misdeed or wicked crime, O Jews, there would be reason for me to bear with you; ");
INSERT INTO engf35_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","but since it is an issue over a word and names and your own law, see to it yourselves; because I refuse to be a judge of such matters.” ");
INSERT INTO engf35_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","And he drove them from the judgment seat. ");
INSERT INTO engf35_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Then all the Greeks took Sosthenes, the ruler of the synagogue, and beat him in front of the judgment seat. But none of this was a delay to Gallio. ");
INSERT INTO engf35_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul still remained there a good while, then took leave of the brothers and sailed for Syria, accompanied by Priscilla and Aquila (he had shaved his head in Cenchrea, because he had a vow). ");
INSERT INTO engf35_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","He came to Ephesus and left them there (after having entered the synagogue and reasoned with the Jews). ");
INSERT INTO engf35_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","When they asked him to stay a longer time with them, he did not consent; ");
INSERT INTO engf35_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","rather he took leave of them saying, “I must by all means keep this coming feast in Jerusalem; but I will return again to you, God willing.” Then he set sail from Ephesus. ");
INSERT INTO engf35_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","When he had landed at Caesarea, and gone up and greeted the church in Jerusalem, he returned to Antioch. ");
INSERT INTO engf35_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","After spending some time there, he departed and went through the region of Galatia and Phrygia in order, strengthening all the disciples. ");
INSERT INTO engf35_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Now a certain Jew named Apollos, a native of Alexandria, an eloquent man, mighty in the Scriptures, arrived in Ephesus. ");
INSERT INTO engf35_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","This man had been instructed in the way of the Lord, and being fervent in the Spirit he was speaking and teaching accurately the things concerning Jesus, although he knew only the baptism of John. ");
INSERT INTO engf35_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","So he began to speak boldly in the synagogue. When Priscilla and Aquila heard him, they took him aside and explained to him the way of God more accurately. ");
INSERT INTO engf35_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","When he decided to go across into Achaia, the brothers encouraged him and wrote to the disciples to receive him; upon arriving he was a great help to those who had believed through the Grace; ");
INSERT INTO engf35_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","because he kept refuting the Jews vigorously, publicly, demonstrating Jesus to be the Christ, from the Scriptures. ");
INSERT INTO engf35_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Now it happened that while Apollos was at Corinth, Paul, having passed through the upper country, came to Ephesus. And finding certain disciples ");
INSERT INTO engf35_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","he said to them, “Did you receive the Holy Spirit when you believed?” So they said to him, “But we have not so much as heard that there is a Holy Spirit!” ");
INSERT INTO engf35_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","So he said, “Into what then were you baptized?” So they said, “Into John's baptism.” ");
INSERT INTO engf35_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","So Paul said, “John indeed baptized with a baptism of repentance, saying to the people that they should believe into the One who would come after him, that is, into Jesus, the Christ.” ");
INSERT INTO engf35_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","So upon hearing this they were baptized into the name of the Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","And as Paul laid his hands on them the Holy Spirit came upon them, and they started speaking languages and prophesying. ");
INSERT INTO engf35_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","There were about twelve men in all. ");
INSERT INTO engf35_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","During three months Paul kept going to the synagogue and speaking boldly, reasoning and persuading concerning the things of the Kingdom of God. ");
INSERT INTO engf35_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","But when some became hardened and disobedient, maligning the Way before the crowd, he withdrew from them and separated the disciples, reasoning daily in the school of a certain Tyrannus. ");
INSERT INTO engf35_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Now this continued for two years, so that all who lived in Asia, both Jews and Greeks, heard the Word of the Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Further, God kept working unusual miracles by the hands of Paul, ");
INSERT INTO engf35_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","so that even handkerchiefs or aprons that he touched were applied to the sick, and the diseases left them and the wicked spirits went out from them. ");
INSERT INTO engf35_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Well some among the itinerant Jewish exorcists attempted to invoke the name of the Lord Jesus over those who had wicked spirits saying, “We adjure you by the Jesus whom Paul preaches.” ");
INSERT INTO engf35_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","In fact there were seven sons of Sceva, a Jewish chief priest, who were doing this. ");
INSERT INTO engf35_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","But a particular wicked spirit reacted and said, “Jesus I know, and I am acquainted with Paul, but who are you?” ");
INSERT INTO engf35_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","And the man in whom the wicked spirit was jumped on them and overpowered them; he was so much stronger that they ran out of that house naked and wounded. ");
INSERT INTO engf35_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Now this became known to all, both Jews and Greeks, who lived in Ephesus; and fear fell on them all, and the name of the Lord Jesus was being exalted. ");
INSERT INTO engf35_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","And many of those who had believed started coming, confessing and disclosing their practices. ");
INSERT INTO engf35_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","In fact, many of those who had practiced magic brought their books together and burned them up, in front of everybody (they had calculated their value and it totaled fifty thousand pieces of silver). ");
INSERT INTO engf35_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","With power like that it was that the word of the Lord kept growing and prevailing. ");
INSERT INTO engf35_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Now after these things were accomplished, Paul resolved in his spirit to go to Jerusalem, passing through Macedonia and Achaia, saying, “After I have been there, I must also see Rome.” ");
INSERT INTO engf35_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","So he sent two of those who ministered to him, Timothy and Erastus, on to Macedonia, while he himself stayed on in Asia for a time. ");
INSERT INTO engf35_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Now it was during that time that a serious disturbance concerning the Way occurred. ");
INSERT INTO engf35_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","A certain man named Demetrius, a silversmith, who made silver shrines of Artemis, habitually brought in plenty of business for the artisans; ");
INSERT INTO engf35_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","he called them together, along with the workmen in related trades, and said: “Men, you know that our prosperity depends on this trade. ");
INSERT INTO engf35_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","And you observe and hear that not only in Ephesus but throughout almost all Asia this Paul has persuaded and turned away many people, saying that handmade things are not gods. ");
INSERT INTO engf35_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","So not only is this trade of ours in danger of falling into disrepute, but also the temple of the great goddess Artemis may be discredited, and even her own majesty be destroyed, whom all Asia and the world worship.” ");
INSERT INTO engf35_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Now upon hearing this they were filled with anger and began shouting, “Great is Artemis of the Ephesians!” ");
INSERT INTO engf35_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","So the whole city was filled with confusion, and they rushed into the theater with one accord (they had seized Gaius and Aristarchus, Macedonians, Paul's traveling companions). ");
INSERT INTO engf35_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","When Paul wanted to go in to the people, the disciples would not let him. ");
INSERT INTO engf35_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Even some of the officials of Asia, being his friends, sent word to him and urged him not to venture into the theater. ");
INSERT INTO engf35_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","The assembly was in confusion: some were shouting one thing and some another; most of them did not know why they had come together. ");
INSERT INTO engf35_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Then the Jews pushed Alexander forward, out from the crowd. So Alexander motioned with his hand and would have made a defense to the people. ");
INSERT INTO engf35_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","But when they realized he was a Jew, they all shouted in unison for about two hours, “Great is Artemis of the Ephesians!” ");
INSERT INTO engf35_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","When the city clerk had quieted the crowd, he said: “Men of Ephesus, what man is there who does not know that the city of the Ephesians is temple guardian of the great goddess Artemis and of what fell from Zeus? ");
INSERT INTO engf35_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Therefore, since these things are undeniable, you ought to be quiet and not do anything rash. ");
INSERT INTO engf35_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","You have arrested these men who are neither temple thieves nor blasphemers of your goddess. ");
INSERT INTO engf35_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Now if Demetrius and his fellow artisans have a complaint against anyone, courts are available, and there are proconsuls; let them bring charges against one another. ");
INSERT INTO engf35_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","But if you want to debate any other matter, it will be settled in the legal assembly. ");
INSERT INTO engf35_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Indeed, we are in danger of being charged with a riot, because of today, there being no reason at all that we can give to account for this commotion.” ");
INSERT INTO engf35_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","And having said these things he dismissed the assembly. ");
INSERT INTO engf35_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Now after the uproar had ended, Paul summoned the disciples, took leave of them, and set out for Macedonia. ");
INSERT INTO engf35_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","When he had gone through those parts and encouraged them with many words, he came into Greece. ");
INSERT INTO engf35_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","When he had stayed three months, as he was about to set sail for Syria, the Jews made a plot against him, so he decided to return through Macedonia. ");
INSERT INTO engf35_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Now Sopater of Berea, Aristarchus and Secundus of the Thessalonians, Gaius of Derbe, Timothy, and Tychicus and Trophimus of Asia were going to accompany him as far as Asia; ");
INSERT INTO engf35_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","so having gone on ahead, these men were waiting for us in Troas. ");
INSERT INTO engf35_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","But it was after the Days of Unleavened Bread that we sailed from Philippi, and in five days we joined them at Troas, where we stayed seven days. ");
INSERT INTO engf35_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Now on the first day of the week, the disciples being assembled to break bread, Paul started addressing them, and because he intended to leave the next day he continued his message until midnight. ");
INSERT INTO engf35_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","There were many lamps in the upper room where we were assembled. ");
INSERT INTO engf35_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Well a certain young man named Eutychus sat in a window and was sinking into a deep sleep as Paul kept on talking; when he was overcome by the sleep he fell down from the third story and was picked up dead. ");
INSERT INTO engf35_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","So Paul went down, threw himself on him and embracing him said, “Do not be distressed, because his life is in him!” ");
INSERT INTO engf35_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Then he went back up and broke bread, ate, and kept on speaking until daybreak—that is how he left! ");
INSERT INTO engf35_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","(On their part, they led the boy away alive, and were greatly comforted.) ");
INSERT INTO engf35_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","As for us, we went to the ship and set sail for Assos, intending to take Paul on board there—so it had been arranged, he himself intending to go on foot. ");
INSERT INTO engf35_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","When he met us at Assos we took him aboard and went on to Mityline. ");
INSERT INTO engf35_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sailing from there, the next day we arrived opposite Chios, and the day after we crossed over to Samos and stopped in Trogylium; the following day we came to Miletus. ");
INSERT INTO engf35_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","(Paul had decided to sail past Ephesus, to avoid being detained in Asia, because he was hurrying to be in Jerusalem on the Day of Pentecost, if he possibly could.) ");
INSERT INTO engf35_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","From Miletus he sent to Ephesus and summoned the elders of the congregation. ");
INSERT INTO engf35_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","So when they had come to him he said to them: “You yourselves know, from the first day that I arrived in Asia, how I lived the whole time I was with you, ");
INSERT INTO engf35_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","serving the Lord with all humility, and with many tears and trials, the ones that happened to me by the plots of the Jews; ");
INSERT INTO engf35_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","how I did not shrink from declaring to you anything that was profitable, teaching you publicly and from house to house, ");
INSERT INTO engf35_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","solemnly proclaiming to both Jews and Greeks the repentance toward God and the faith into our Lord Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Now then, I am going to Jerusalem bound in my spirit, not knowing the things that will happen to me there, ");
INSERT INTO engf35_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","except that the Holy Spirit keeps warning me in every city, saying that fetters and afflictions are just waiting for me. ");
INSERT INTO engf35_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","However none of this moves me, nor do I regard my life as valuable to myself, just so that I may complete my course with joy, even the ministry that I received from the Lord Jesus, to solemnly proclaim the Good News of the grace of God. ");
INSERT INTO engf35_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Furthermore, I know that none of you among whom I have gone about proclaiming the Kingdom of God will ever see my face again. ");
INSERT INTO engf35_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Therefore I testify to you this day that I am innocent of the blood of all; ");
INSERT INTO engf35_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","because I did not shrink from declaring to you the whole counsel of God. ");
INSERT INTO engf35_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","So take heed to yourselves and to all the flock, in which the Holy Spirit has placed you as overseers, to shepherd the congregation of the Lord and God which He purchased with His own blood. ");
INSERT INTO engf35_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Because I know this, that after my departure savage wolves will come in among you, not sparing the flock. ");
INSERT INTO engf35_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yes, men will rise up from among you yourselves, speaking distorted things, to draw away the disciples after them. ");
INSERT INTO engf35_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Therefore be alert, remembering that during three years, night and day, I never stopped admonishing each one, with tears. ");
INSERT INTO engf35_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“And so now, brothers, I entrust you to God and to the Word of His grace, which is able to build you up and to give you an inheritance among all those who have been sanctified. ");
INSERT INTO engf35_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","I have not coveted anyone's silver or gold or clothing. ");
INSERT INTO engf35_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","You yourselves know that these hands have supplied my own needs, and of those who were with me. ");
INSERT INTO engf35_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","In every way I showed you that working hard like this it is necessary to help the weak, and to remember the word of the Lord Jesus, that He Himself said, ‘It is more blessed to give than to receive.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","When he had said these things, he knelt down and prayed with them all. ");
INSERT INTO engf35_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Then they all wept freely, and falling on Paul's neck kept kissing him, ");
INSERT INTO engf35_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","sorrowing most of all because of the word that he had spoken, that they would see his face no more. And they accompanied him to the ship. ");
INSERT INTO engf35_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","So after disengaging ourselves from them we were able to set sail, and running a straight course we came to Cos, and the next day to Rhodes, and from there to Patara. ");
INSERT INTO engf35_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","We found a ship crossing over to Phoenicia, went on board and set sail. ");
INSERT INTO engf35_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","When we had sighted Cyprus we passed it on the left, sailed on to Syria and landed at Tyre, because it was there that the ship was to unload the cargo. ");
INSERT INTO engf35_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Upon finding disciples we stayed there seven days; these, through the Spirit, told Paul not to go on to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","But when our time was up, as we left to go on our way, they all, including women and children, accompanied us out of the city, and kneeling down on the beach, we prayed. ");
INSERT INTO engf35_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","After we had taken our leave of one another, we boarded the ship and they returned to their homes. ");
INSERT INTO engf35_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Now upon arriving in Ptolemais, the voyage from Tyre ended; so greeting the brothers we stayed with them one day. ");
INSERT INTO engf35_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Leaving the next day, we came to Caesarea; and entering the house of Philip the evangelist (being of ‘the Seven’), we stayed with him. ");
INSERT INTO engf35_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","(This man had four virgin daughters who prophesied.) ");
INSERT INTO engf35_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Now as we stayed there a number of days, a certain prophet named Agabus came down from Judea. ");
INSERT INTO engf35_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Joining us he took Paul's belt, bound his feet and hands, and said, “Thus says the Holy Spirit: ‘In this way, in Jerusalem, the Jews will bind the man who owns this belt, and will deliver him into the hands of the Gentiles.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Well, when we heard these things, both we and the local residents, we pleaded with him not to go up to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","But Paul answered: “What are you doing, weeping and breaking my heart? I am ready not only to be bound, but also to die in Jerusalem for the name of the Lord Jesus.” ");
INSERT INTO engf35_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","When he would not be dissuaded, we stopped, saying, “Let the will of the Lord be done.” ");
INSERT INTO engf35_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","So after those days we got ready and went up to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Some of the disciples from Caesarea also went with us, bringing us to a certain Mnason, of Cyprus, an early disciple, with whom we were to lodge. ");
INSERT INTO engf35_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","And when we arrived in Jerusalem the brothers received us gladly. ");
INSERT INTO engf35_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","The next day Paul, with us, went to see James, and all the elders were present. ");
INSERT INTO engf35_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","After greeting them he reported one by one the things that God had done among the Gentiles through his ministry. ");
INSERT INTO engf35_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","But after listening they ‘glorified’ the Lord by saying to him: “You see, brother, how many tens of thousands are the Jews who have believed, and they are all zealous for the law; ");
INSERT INTO engf35_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","but they have been informed about you that you teach all the Jews who are among the Gentiles to forsake Moses, telling them not to circumcise their children nor to walk according to our customs. ");
INSERT INTO engf35_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","What then? The assembly will certainly gather, since they will hear that you have come. ");
INSERT INTO engf35_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","So do this that we say to you: There are four men with us who have taken a vow. ");
INSERT INTO engf35_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Take them and purify yourself with them, and pay their expenses so that they may shave their heads, and that all may know that there is nothing to the things that they have been informed about you; rather that you yourself are in line, keeping the law. ");
INSERT INTO engf35_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","But concerning the Gentiles who believe we have written, having judged that they need observe no such thing, except that they should keep themselves from that offered to idols, from the blood, from anything strangled, and from fornication.” ");
INSERT INTO engf35_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Then Paul took the men and purified himself with them; the next day he entered the temple to give notice of the completion of the days of purification, when the offering would be made for each one of them. ");
INSERT INTO engf35_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Now when the seven days were almost ended, the Jews from Asia, having seen him in the temple, mobilized a whole crowd and seized him, ");
INSERT INTO engf35_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","shouting: “Men of Israel, help! This is the man who teaches all men everywhere against the people, and the law, and this place. Not only that, he has even brought Greeks into the temple and defiled this holy place!” ");
INSERT INTO engf35_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(They had seen Trophimus the Ephesian in the city with him, and they supposed that Paul had brought him into the temple.) ");
INSERT INTO engf35_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","The whole city was aroused and a mob of people formed. So having seized Paul they dragged him out of the temple, and immediately the doors were shut. ");
INSERT INTO engf35_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","As they were trying to kill him, news came to the commander of the garrison that all Jerusalem was in an uproar. ");
INSERT INTO engf35_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","He immediately took soldiers and centurions and ran down among them, and when they saw the commander and the soldiers they stopped beating Paul. ");
INSERT INTO engf35_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Then the commander came up and took hold of him, commanded that he be bound with two chains, and started inquiring who he was and what he had done. ");
INSERT INTO engf35_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Well some in the crowd shouted one thing and some another; so when he could not ascertain the truth, because of the uproar, he commanded him to be taken into the barracks. ");
INSERT INTO engf35_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","When he reached the stairs, he had to be carried by the soldiers, because of the violence of the mob. ");
INSERT INTO engf35_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Because the crowd kept following and shouting, “Away with him!” ");
INSERT INTO engf35_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","As Paul was about to be led into the barracks, he said to the commander, “May I speak to you?” So he said: “Do you know Greek? ");
INSERT INTO engf35_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Aren't you the Egyptian who some time ago started a revolt and led the four thousand men of ‘the Assassins’ out into the wilderness?” ");
INSERT INTO engf35_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","But Paul said, “I am a Jew, from Tarsus in Cilicia, a citizen of a not insignificant city; but I beg you, allow me to speak to the people.” ");
INSERT INTO engf35_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","So when he had given him permission, Paul stood on the stairs and motioned to the people with his hand. When there was a great silence, he addressed them in the Hebrew language, saying: ");
INSERT INTO engf35_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Men, brothers and fathers, listen to my defense before you now.” ");
INSERT INTO engf35_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","When they heard that he spoke to them in the Hebrew language, they were even more quiet, and he said: ");
INSERT INTO engf35_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“I am indeed a Jew, born in Tarsus of Cilicia, but brought up in this city at the feet of Gamaliel, educated strictly according to the law of our fathers, being zealous for God, just as you all are today. ");
INSERT INTO engf35_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","I persecuted this Way to the death, binding and delivering into prisons both men and women, ");
INSERT INTO engf35_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","as also the high priest and all the council of elders can bear me witness. I even obtained letters from them to the brothers in Damascus, to bring those also who were there bound to Jerusalem to be punished. ");
INSERT INTO engf35_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Now it happened, as I was going and approaching Damascus, about noon, suddenly a strong light from heaven shone around me. ");
INSERT INTO engf35_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","I fell to the ground and heard a voice saying to me, ‘Saul, Saul, why are you persecuting me?’ ");
INSERT INTO engf35_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","So I answered, ‘Who are you, Lord?’ He said to me, ‘I am Jesus the Natsorean, whom you are persecuting.’ ");
INSERT INTO engf35_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Those who were with me indeed saw the light and were afraid, but they did not understand the voice of the One speaking to me. ");
INSERT INTO engf35_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","So I said, ‘What shall I do, Lord?’ And the Lord said to me, ‘Get up and go into Damascus, and there you will be told about all that has been appointed to you to do.’ ");
INSERT INTO engf35_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","And since I could not see, because of the brightness of that light, I entered Damascus being led by the hand of those who were with me. ");
INSERT INTO engf35_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Then a certain Ananias, a devout man according to the law, well spoken of by all the Jews who lived in Damascus, ");
INSERT INTO engf35_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","came to me, and standing by me said, ‘Brother Saul, receive your sight!’ And at that very moment I looked up at him. ");
INSERT INTO engf35_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Then he said: ‘The God of our fathers has chosen you to know His will, and to see the Righteous One, and to hear words from His mouth. ");
INSERT INTO engf35_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","For you shall be a witness for Him to all men of the things that you have seen and heard. ");
INSERT INTO engf35_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","And now, why hesitate? Get up, be baptized and wash away your sins, invoking the name of the Lord.’ ");
INSERT INTO engf35_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Now it happened, when I returned to Jerusalem and was praying in the temple, that I came to be in a trance ");
INSERT INTO engf35_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","and saw Him saying to me, ‘Hurry up and get out of Jerusalem quickly, because they will not receive your testimony concerning me.’ ");
INSERT INTO engf35_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","So I said: ‘Lord, they know that I used to imprison and beat those believing into you, from one synagogue to another; ");
INSERT INTO engf35_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","and when the blood of your witness Stephen was shed, I myself was standing there and agreeing to his murder, even guarding the clothes of those who were killing him.’ ");
INSERT INTO engf35_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","And He said to me, ‘Get going, because I will send you far away to the Gentiles.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Well they kept listening to him until this statement, and then they raised their voice and shouted, “Rid the earth of this fellow, for it isn't fitting for him to live!” ");
INSERT INTO engf35_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","As they were shouting, tearing off clothes and throwing dust into the air, ");
INSERT INTO engf35_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","the commander ordered him to be taken into the barracks, directing that he be interrogated with lashes, in order to learn for what crime they kept shouting against him like that. ");
INSERT INTO engf35_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","But as they stretched him out with the thongs, Paul said to the centurion who stood by, “Is it lawful for you to scourge a man who is a Roman, and uncondemned?” ");
INSERT INTO engf35_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Well when the centurion heard that, he went and reported to the commander saying, “Consider what you are about to do, because this man is a Roman!” ");
INSERT INTO engf35_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","So the commander went and said to him, “Tell me, are you a Roman?” So he said, “Yes.” ");
INSERT INTO engf35_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","The commander replied, “I acquired this citizenship at considerable cost.” And Paul said, “But I was so born.” ");
INSERT INTO engf35_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","So those who were about to interrogate him withdrew immediately; and even the commander was apprehensive when he realized that he had put chains on a Roman. ");
INSERT INTO engf35_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","But the next day, desiring to know for certain why he was accused by the Jews, he freed him from the bonds and ordered the chief priests and all their council to come, and brought Paul down and set him before them. ");
INSERT INTO engf35_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Then Paul, looking intently at the council, said, “Men, brothers, I have lived in all good conscience before God until this day.” ");
INSERT INTO engf35_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","So the high priest Ananias commanded those standing by him to strike his mouth. ");
INSERT INTO engf35_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Then Paul said to him: “God will strike you, you whitewashed wall! You sit there to judge me according to the law, yet you command me to be struck contrary to the law!” ");
INSERT INTO engf35_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","So those standing by said, “Do you reproach God's high priest?” ");
INSERT INTO engf35_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Then Paul said, “I did not know, brothers, that he is high priest; for it is written: ‘Do not speak evil of a ruler of your people.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Now when Paul perceived that one part were Pharisees and the other Sadducees, he called out in the council, “Men, brothers, I am a Pharisee, a son of a Pharisee; I am being judged concerning the hope and resurrection of the dead!” ");
INSERT INTO engf35_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","When he had said this, an argument started between the Pharisees and the Sadducees, and the assembly was divided. ");
INSERT INTO engf35_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sadducees say that there is no resurrection, nor angel or spirit, but Pharisees confess both.) ");
INSERT INTO engf35_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","There was a great clamor, and the scribes of the Pharisee party stood up and started arguing vigorously, saying, “We find nothing wrong with this man; but if a spirit or angel has spoken to him, let us not fight against God!” ");
INSERT INTO engf35_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Well the dissension became such that the commander, fearing that Paul might be torn in pieces by them, commanded the soldiers to go down and snatch him out of their midst and bring him into the barracks. ");
INSERT INTO engf35_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Now the following night the Lord stood by him and said, “Take courage, Paul, because as you have testified about me in Jerusalem, so you must also testify in Rome.” ");
INSERT INTO engf35_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","And when it was day, some of the Jews formed a conspiracy by binding themselves with a curse neither to eat nor to drink until they had destroyed Paul. ");
INSERT INTO engf35_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Now there were more than forty who formed this plot. ");
INSERT INTO engf35_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","They came to the chief priests and the elders and said: “We have bound ourselves with a terrible curse not to taste anything until we have killed Paul. ");
INSERT INTO engf35_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Now you, therefore, together with the council, explain to the commander that he should bring him down to you tomorrow, as though you are going to determine more accurately the facts in his case; but we are ready to destroy him before he comes near.” ");
INSERT INTO engf35_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","But when Paul's sister's son heard about the ambush, he went and entered the barracks and told Paul. ");
INSERT INTO engf35_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","So Paul called one of the centurions and said, “Take this young man to the commander, because he has something to tell him.” ");
INSERT INTO engf35_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","So he took him and brought him to the commander and said, “Paul the prisoner called me over and asked me to bring this young man to you because he has something to tell you.” ");
INSERT INTO engf35_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","So taking him by the hand, the commander went aside and asked privately, “What is it that you have to tell me?” ");
INSERT INTO engf35_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","So he said: “The Jews have agreed to ask you to bring Paul down to the council tomorrow as though intending to inquire somewhat more accurately concerning him. ");
INSERT INTO engf35_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","But you should not believe them, because more than forty of their men are lying in wait for him, who have bound themselves with a curse neither to eat not to drink until they have destroyed him; even now they are ready, looking for your promise.” ");
INSERT INTO engf35_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Then the commander dismissed the young man commanding, “Don't tell anyone that you have revealed these things to me!” ");
INSERT INTO engf35_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Summoning two of the centurions he said: “Prepare two hundred soldiers, seventy horsemen and two hundred spearmen to go to Caesarea at the third hour of the night; ");
INSERT INTO engf35_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","and provide mounts to set Paul on so as to deliver him safely to Felix, the governor.” ");
INSERT INTO engf35_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","He wrote a letter with this content: ");
INSERT INTO engf35_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias, to the most excellent governor Felix: Greetings. ");
INSERT INTO engf35_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","This man was seized by the Jews and was about to be killed by them; but I came with the troops and rescued him, having learned that he is a Roman. ");
INSERT INTO engf35_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","And wanting to know the reason they were accusing him, I took him down to their council. ");
INSERT INTO engf35_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","I found that he was being accused about questions of their law, but there was no accusation worthy of death or bonds. ");
INSERT INTO engf35_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","When I was told that the Jews were about to execute a plot against the man, I sent him to you at once, also directing his accusers to state the charges against him before you. Farewell.” ");
INSERT INTO engf35_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","So the soldiers, according to their orders, took Paul and brought him by night to Antipatris. ");
INSERT INTO engf35_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","The next day they left the horsemen to go on with him and returned to the barracks. ");
INSERT INTO engf35_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","When they entered Caesarea and delivered the letter to the governor, they also presented Paul to him. ");
INSERT INTO engf35_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","When the governor read it, he asked what province he was from; learning that it was Cilicia, ");
INSERT INTO engf35_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","he said, “I will give you a hearing when your accusers also arrive.” And he commanded him to be guarded in Herod's Praetorium. ");
INSERT INTO engf35_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Now after five days the high priest Ananias went down with the elders and a certain orator, Tertullus, and they informed the governor against Paul. ");
INSERT INTO engf35_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","So when he had been called in, Tertullus began his accusation, saying: “Seeing that by you we enjoy much peace, and your foresight has brought prosperity to this nation, ");
INSERT INTO engf35_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","we recognize this, most noble Felix, with full gratitude, always and everywhere. ");
INSERT INTO engf35_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","But so as not to detain you unduly, I would request that you be kind enough to hear us briefly. ");
INSERT INTO engf35_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","We have found this man to be a plague, a creator of discord among all the Jews throughout the world, a ringleader of the Natsorean sect, ");
INSERT INTO engf35_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","and he even tried to profane the temple; so we arrested him. ");
INSERT INTO engf35_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","By examining him yourself you may ascertain all these things of which we accuse him.” ");
INSERT INTO engf35_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","And the Jews also joined in the attack, affirming that these things were so. ");
INSERT INTO engf35_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","When the governor had nodded to him to speak, Paul answered: “Knowing, as I do, that you have been an equitable judge of this nation for many years, I do the more cheerfully answer for myself, ");
INSERT INTO engf35_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","because you can ascertain that it is not more than twelve days since I went up to Jerusalem to worship. ");
INSERT INTO engf35_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","They did not find me disputing with anyone or stirring up a crowd—not in the temple, not in the synagogues, not around the city. ");
INSERT INTO engf35_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nor can they prove the things of which they now accuse me. ");
INSERT INTO engf35_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","But I do profess this to you, that according to the Way that they call a sect, that is how I worship the ancestral God, believing all things that stand written throughout the Law and the Prophets, ");
INSERT INTO engf35_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","having hope in God, which these themselves also look for, that there will be a resurrection of the dead, both the just and unjust. ");
INSERT INTO engf35_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","And this is why I apply myself to always have a clear conscience before both God and men. ");
INSERT INTO engf35_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Now after many years I came to bring alms and offerings to my nation, ");
INSERT INTO engf35_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","in the midst of which certain Jews from Asia found me purified in the temple, with neither crowd nor confusion. ");
INSERT INTO engf35_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","They are the ones that had to be here before you and make accusation, if they had anything against me. ");
INSERT INTO engf35_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Or let these themselves say what wrong they found in me, when I stood before the council, ");
INSERT INTO engf35_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","unless it be for this one statement that I called out, standing among them, ‘Concerning the resurrection of the dead I am being judged by you today.’ ” ");
INSERT INTO engf35_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Upon hearing these things Felix, having an accurate knowledge of the things concerning the Way, adjourned the proceedings and said, “When Lysias the commander comes down I will decide your case.” ");
INSERT INTO engf35_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","And he ordered the centurion that Paul should be kept in custody but have some freedom, and not to forbid any of his friends to provide for or to visit him. ");
INSERT INTO engf35_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Now after some days, when Felix came with his wife Drusilla, who was a Jewess, he sent for Paul and heard him concerning the faith into Christ Jesus. ");
INSERT INTO engf35_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","But as he expounded on righteousness, self-control, and the judgment to come, Felix became afraid and answered, “Go away for now; when I have occasion I will summon you.” ");
INSERT INTO engf35_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","At the same time he was also hoping that Paul would give him money, that he might release him; so he frequently summoned and conversed with him. ");
INSERT INTO engf35_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","But after two years, Felix was succeeded by Porcius Festus; so Felix, wanting to do the Jews a favor, left Paul in prison. ");
INSERT INTO engf35_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Now upon assuming the province, after three days Festus went up from Caesarea to Jerusalem. ");
INSERT INTO engf35_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Then the chief priests and the principal men of the Jews informed him against Paul and started importuning him, ");
INSERT INTO engf35_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","begging a favor from him, that he would summon him to Jerusalem—preparing an ambush to kill him along the way. ");
INSERT INTO engf35_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","However Festus answered that Paul should be kept at Caesarea, he himself being about to go there shortly. ");
INSERT INTO engf35_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","He said, “So let those who are competent among you go down with me; if there is anything against this man, let them accuse him.” ");
INSERT INTO engf35_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","When he had stayed among them more than ten days, he went down to Caesarea; the next day he sat on the judgment seat and commanded Paul to be brought. ");
INSERT INTO engf35_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","When he had come, the Jews who had come down from Jerusalem made a circle, bringing against Paul many serious charges that they could not prove, ");
INSERT INTO engf35_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","while he defended himself, “Neither against the law of the Jews, nor against the temple, nor against Caesar did I commit any sin.” ");
INSERT INTO engf35_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","But Festus, wanting to do the Jews a favor, answered Paul by saying, “Are you willing to go up to Jerusalem to be judged by me there concerning these things?” ");
INSERT INTO engf35_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","So Paul said: “I am standing before Caesar's judgment seat, where I ought to be tried. To the Jews I have done no wrong, as even you know very well. ");
INSERT INTO engf35_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Now if I really am in the wrong and have perpetrated anything worthy of death, I do not refuse to die; but if there is nothing to the things of which these are accusing me, no one has the right to give me to them. I appeal to Caesar!” ");
INSERT INTO engf35_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Then Festus, when he had conferred with his counsel, answered: “You have appealed to Caesar. To Caesar you shall go!” ");
INSERT INTO engf35_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Now when some days had passed, Agrippa the king and Bernice arrived in Caesarea to congratulate Festus. ");
INSERT INTO engf35_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Since they were spending many days there, Festus laid Paul's case before the king, saying: “There is a certain man left a prisoner by Felix; ");
INSERT INTO engf35_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","about whom, when I was in Jerusalem, the chief priests and the elders of the Jews informed me, asking for punishment against him; ");
INSERT INTO engf35_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","to whom I answered that it is not a custom with Romans to deliver any man to destruction before the accused has his accusers face to face and has opportunity for defense against the accusation. ");
INSERT INTO engf35_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","So when they had assembled here, without any delay, the next day I sat on the judgment seat and commanded the man to be brought. ");
INSERT INTO engf35_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","When the accusers stood up, they brought no charge against him of such things as I supposed, ");
INSERT INTO engf35_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","but had certain issues against him about their religion, and about a certain dead Jesus whom Paul affirmed to be living. ");
INSERT INTO engf35_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","And since I was at a loss how to investigate such matters, I asked whether he was willing to go to Jerusalem and be judged there concerning these things. ");
INSERT INTO engf35_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","But when Paul appealed to be reserved for the decision of the Emperor, I commanded him to be kept until I can send him to Caesar.” ");
INSERT INTO engf35_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Then Agrippa said to Festus, “I myself would also like to hear the man.” So he said, “Tomorrow you shall hear him.” ");
INSERT INTO engf35_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","So the next day, when Agrippa and Bernice had come with great pomp and entered the auditorium, with the commanding officers and the more prominent men of the city, at Festus' command Paul was brought in. ");
INSERT INTO engf35_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","And Festus said: “King Agrippa, and all you men who are here with us: consider this man, about whom the whole Jewish community petitioned me, both at Jerusalem and here, vociferating that it was not fitting for him to live any longer. ");
INSERT INTO engf35_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","But when I found that he had committed nothing worthy of death, besides he himself having appealed to the Emperor, I decided to send him. ");
INSERT INTO engf35_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","But I have nothing certain to write to my lord concerning him. Therefore I have brought him before all of you, and especially before you, King Agrippa, so that after the examination I may have something to write. ");
INSERT INTO engf35_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Because it seems to me unreasonable to send a prisoner and not to specify the charges against him.” ");
INSERT INTO engf35_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Then Agrippa said to Paul, “You have permission to speak for yourself.” So Paul stretched out his hand and began his defense: ");
INSERT INTO engf35_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“I consider myself fortunate, King Agrippa, in that I am to make my defense before you this day concerning the things of which I am accused by the Jews, ");
INSERT INTO engf35_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","especially because you are expert in all the Jewish customs and issues; therefore I beg you to hear me patiently. ");
INSERT INTO engf35_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Really, the Jews all know my way of life from my youth, which was spent from the beginning among my own nation in Jerusalem, ");
INSERT INTO engf35_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","since they have known me for a long time, if they were willing to testify, that according to the strictest sect of our religion I lived as a Pharisee. ");
INSERT INTO engf35_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","And now I stand here being judged for the hope of the promise made by God to our fathers, ");
INSERT INTO engf35_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","to which our twelve tribes, earnestly serving God night and day, hope to attain. It is because of this hope that I am accused by the Jews, King Agrippa. ");
INSERT INTO engf35_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Why should any of you consider it incredible that God raises the dead? ");
INSERT INTO engf35_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“However, I myself thought that I had to perpetrate many things in opposition to the name of Jesus the Natsorean; ");
INSERT INTO engf35_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","I actually did this in Jerusalem, and many of the saints I shut up in prison, having received authority from the chief priests; and when they were put to death I cast my vote against them. ");
INSERT INTO engf35_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yes, I punished them often in every synagogue, trying to force them to blaspheme; I was so excessively enraged against them that I persecuted them even to foreign cities. ");
INSERT INTO engf35_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“It was on one of those journeys, as I was going to Damascus with authority and a commission from the chief priests, ");
INSERT INTO engf35_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","at midday, O king, as I was on the road, I saw a light from heaven brighter than the sun, blazing around me and those traveling with me. ");
INSERT INTO engf35_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Well we all fell to the ground and I heard a voice speaking to me and saying in the Hebrew language: ‘Saul, Saul, why are you persecuting me? It is hard for you to kick against the goads.’ ");
INSERT INTO engf35_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","So I said, ‘Who are you, Lord?’ And He said: ‘I am Jesus, whom you are persecuting. ");
INSERT INTO engf35_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Now get up and stand on your feet; because I have appeared to you for this purpose, to appoint you as a servant and a witness both of the things you have seen and of the things I will reveal to you, ");
INSERT INTO engf35_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","delivering you from ‘the people’ and the ethnic nations, to which I am sending you: ");
INSERT INTO engf35_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","to open their eyes, so as to bring them back from darkness into light and from the authority of Satan to God, that they may receive forgiveness of sins and an inheritance among those who are sanctified, by faith into me.’ ");
INSERT INTO engf35_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Therefore, King Agrippa, I was not disobedient to the heavenly vision ");
INSERT INTO engf35_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","—first to those in Damascus and Jerusalem, then to all the region of Judea and to the ethnic nations, I still preach: ‘repent and turn back to God, doing works worthy of repentance.’ ");
INSERT INTO engf35_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","That is why the Jews seized me in the temple and tried to kill me. ");
INSERT INTO engf35_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","So then, having experienced the help that is from God, I stand to this day testifying to both small and great, saying nothing beyond what both the prophets and Moses said would happen ");
INSERT INTO engf35_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","—that the Messiah would suffer; that as the first to rise from the dead He would proclaim light to both ‘the people’ and the ethnic nations.” ");
INSERT INTO engf35_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Well as he thus made his defense, Festus said with a loud voice: “Paul, you are crazy! Your great learning is driving you insane!” ");
INSERT INTO engf35_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","So he said: “I am not crazy, most excellent Festus; rather I pronounce words of truth and reasonableness. ");
INSERT INTO engf35_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","For the king knows about these things, before whom I speak freely; for I am convinced that none of this has escaped his notice, since it was not done in a corner. ");
INSERT INTO engf35_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agrippa, do you believe the prophets? I know that you believe.” ");
INSERT INTO engf35_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","So Agrippa said to Paul, “You will soon persuade me to become a Christian!” ");
INSERT INTO engf35_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","So Paul said, “Whether sooner or later, I would to God that not only you but also all who are hearing me this day may become such as I am, except for these chains.” ");
INSERT INTO engf35_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Upon his saying this, the king stood up, along with the governor and Bernice and those sitting with them; ");
INSERT INTO engf35_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","and when they had withdrawn they started talking among themselves, saying, “This man is doing nothing deserving of death or chains.” ");
INSERT INTO engf35_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","And Agrippa said to Festus, “This man could have been set free, if he had not appealed to Caesar.” ");
INSERT INTO engf35_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Now when it was decided that we should sail for Italy, they delivered Paul and certain other prisoners to a centurion named Julius, of the imperial cohort. ");
INSERT INTO engf35_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","So we embarked in a ship of Atramytium, being about to sail to points along the Asian coast, and we put to sea; Aristarchus, a Macedonian of Thessalonica, was with us. ");
INSERT INTO engf35_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","The next day we landed at Sidon; Julius treated Paul kindly and permitted him to go to his friends and receive care. ");
INSERT INTO engf35_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Putting to sea from there, we sailed under the lee of Cyprus, because the winds were contrary. ");
INSERT INTO engf35_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","And when we had sailed across the sea that is off Cilicia and Pamphylia, we landed at Myra in Lycia. ");
INSERT INTO engf35_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","There the centurion found a ship of Alexandria sailing for Italy and put us on board. ");
INSERT INTO engf35_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","When we had sailed slowly many days and scarcely arrived opposite Cnidus, the wind did not allow us to go forward, so we sailed for the lee of Crete by way of Salmone; ");
INSERT INTO engf35_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","sailing along it with difficulty we came to a certain place called Fair Havens, near the town of Lasea. ");
INSERT INTO engf35_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Much time had been lost and sailing was already dangerous, because even the Fast had already taken place; Paul repeatedly warned them ");
INSERT INTO engf35_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","saying, “Men, I perceive that the voyage is about to be with damage and great loss, not only of the cargo and the ship, but even of our lives.” ");
INSERT INTO engf35_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","But the centurion was persuaded by the pilot and ship owner rather than by what Paul said. ");
INSERT INTO engf35_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","And since the harbor was not suitable to winter in, the majority advised sailing on, to see if they could get to Phoenix in order to winter, it being a harbor of Crete facing southwest and northwest. ");
INSERT INTO engf35_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","So when the south wind blew gently, supposing that they had obtained their purpose, they weighed anchor and sailed along Crete, close to shore. ");
INSERT INTO engf35_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","But not long after, a cyclonic wind blasted down from the land (it is called Euroclydon). ");
INSERT INTO engf35_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Well the ship was caught and could not head into the wind, so we gave up and were driven along. ");
INSERT INTO engf35_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Running under the lee of a small island called Clauda, we barely managed to secure the skiff; ");
INSERT INTO engf35_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","when they had hoisted it aboard, they used cables to undergird the ship; and fearing that they might fall into the Syrtis, they lowered the sea anchor and so were driven along. ");
INSERT INTO engf35_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","We were being so violently battered by the storm that the next day they began to jettison things, ");
INSERT INTO engf35_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","and on the third we threw off the ship's tackle with our own hands. ");
INSERT INTO engf35_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","When neither sun nor stars appeared for many days and a major storm was still pounding us, all hope that we would be saved was now taken away. ");
INSERT INTO engf35_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Now after long abstinence from food, Paul stood up in the midst of them and said: “Well men, it would have been better to take my advice and not sail from Crete, only to ‘gain’ this damage and loss. ");
INSERT INTO engf35_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","But now I urge you to take heart, because there will be no loss of life among you, only of the ship. ");
INSERT INTO engf35_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","This night an angel of the God whose I am and whom I serve stood by me ");
INSERT INTO engf35_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","and said: ‘Do not be afraid, Paul; you must stand before Caesar. Furthermore, God has granted you all those who sail with you.’ ");
INSERT INTO engf35_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","So take courage, men, because I believe in God that it will be just as it was told me. ");
INSERT INTO engf35_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Also, we must run aground on a certain island.” ");
INSERT INTO engf35_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Now when the fourteenth night had come, as we were being driven here and there in the Adriatic, about midnight the sailors sensed that they were nearing some land. ");
INSERT INTO engf35_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","They took a sounding and found twenty fathoms; going on a little they took a sounding again and found fifteen fathoms. ");
INSERT INTO engf35_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","So fearing that we might be driven into a rocky area, they dropped four anchors from the stern and started praying for day to come. ");
INSERT INTO engf35_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Now under pretense of putting out anchors from the prow, the sailors lowered the skiff into the sea, intending to flee from the ship; ");
INSERT INTO engf35_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","so Paul said to the centurion and to the soldiers, “Unless these stay in the ship, you cannot be saved.” ");
INSERT INTO engf35_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Then the soldiers severed the ropes of the skiff and let it fall away. ");
INSERT INTO engf35_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","While the day was coming on, Paul started urging them all to receive food, saying: “Today is the fourteenth day of waiting—you continue without eating, having taken nothing. ");
INSERT INTO engf35_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Therefore I urge you to take nourishment, because this is for our survival, since not a hair will fall from the head of any of you.” ");
INSERT INTO engf35_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Upon saying this he picked up some bread and gave thanks to God in front of them all; then he broke it and began to eat. ");
INSERT INTO engf35_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","So they all were encouraged and took food themselves. ");
INSERT INTO engf35_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(In all, we were two hundred seventy-six souls on the ship.) ");
INSERT INTO engf35_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","So when they had eaten enough, they started lightening the ship by throwing out the wheat into the sea. ");
INSERT INTO engf35_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","When it was day, they did not recognize the land, but they noticed a bay with a beach, onto which they planned to run the ship, if possible. ");
INSERT INTO engf35_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Casting off the anchors they left them in the sea, at the same time untying the rudder ropes; and hoisting the foresail to the wind, they made for the beach. ");
INSERT INTO engf35_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","But they fell into a place where two seas met and ran the vessel aground; the prow stuck fast and remained immovable, but the stern began to be broken up by the violence of the waves. ");
INSERT INTO engf35_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Now the plan of the soldiers was to kill the prisoners, lest any of them should swim away and escape. ");
INSERT INTO engf35_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","But the centurion, wanting to save Paul, stopped them from doing it and ordered those who could swim to jump in first and go toward the land, ");
INSERT INTO engf35_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","followed by the rest, some on planks and some on things from the ship. And in this way they all escaped safely to the land. ");
INSERT INTO engf35_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Following the rescue, they learned that the island was called Malta. ");
INSERT INTO engf35_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Now the natives showed us unusual kindness, in that they kindled a fire and welcomed us all, because it had begun to rain and was cold. ");
INSERT INTO engf35_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","But when Paul had gathered a bundle of sticks and placed them on the fire, because of the heat a viper came out and fastened itself on his hand. ");
INSERT INTO engf35_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","So when the natives saw the beast hanging from his hand, they started saying to each other, “This man must be a murderer, whom Justice has not allowed to live, even though rescued from the sea.” ");
INSERT INTO engf35_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","But he just shook the beast off into the fire and suffered no harm. ");
INSERT INTO engf35_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Well they were expecting him to swell up, or suddenly fall down dead; but after waiting for quite a while and seeing nothing unusual happening to him, they changed their mind and started saying he was a god. ");
INSERT INTO engf35_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Now in that region there were properties belonging to the chief man of the island, named Publius, who welcomed us and in a friendly manner took care of us for three days. ");
INSERT INTO engf35_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Well it happened that the father of Publius was sick in bed with fever and dysentery; Paul went in to him, prayed, and laying his hands on him, healed him. ");
INSERT INTO engf35_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","So, when this had happened, the rest of those on the island who had diseases started coming and being healed; ");
INSERT INTO engf35_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","who also honored us in many ways, and when we put to sea they provided the necessary things. ");
INSERT INTO engf35_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Now after three months we put to sea in an Alexandrian ship that had wintered in the island, whose figurehead was ‘the Twin Brothers’. ");
INSERT INTO engf35_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","We put in at Syracuse and stayed there three days; ");
INSERT INTO engf35_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","from there we tacked back and forth and arrived at Rhegium. After one day a south wind sprang up, and on the second day we came to Puteoli, ");
INSERT INTO engf35_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","where we found brothers who urged us to stay there seven days—that was how we went toward Rome. ");
INSERT INTO engf35_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","And the brothers there, when they heard about our circumstances, came out to meet us as far as Appii Forum and Three Inns. When Paul saw them he thanked God and took courage. ");
INSERT INTO engf35_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Now when we entered Rome, the centurion delivered the prisoners to the commander; but Paul was allowed to live by himself, with the soldier who guarded him. ");
INSERT INTO engf35_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","It happened that after three days Paul called together the leaders of the Jews; and when they had assembled he said to them: “Men, brothers, though I had done nothing against ‘the people’ or the ancestral customs, still I was delivered as a prisoner from Jerusalem into the hands of the Romans, ");
INSERT INTO engf35_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","who, when they had examined me, were intending to release me, because I was not guilty of any crime deserving death. ");
INSERT INTO engf35_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","But when the Jews spoke against it, I was compelled to appeal to Caesar; not that I had anything about which to accuse my nation. ");
INSERT INTO engf35_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","For this reason therefore I asked to see you and speak with you; it is because of the hope of Israel that I am bound with this chain.” ");
INSERT INTO engf35_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","So they said to him: “We have neither received letters from Judea concerning you, nor have any of the brothers who came reported or spoken any evil about you. ");
INSERT INTO engf35_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","But we desire to hear from you what you think; because as for this sect, we know that it is spoken against everywhere.” ");
INSERT INTO engf35_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","So arranging a day with him, even more people came to him at his lodging, to whom he kept expounding from morning until evening: solemnly testifying about the Kingdom of God and trying to convince them concerning Jesus, from both the Law of Moses and the Prophets. ");
INSERT INTO engf35_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Well some were persuaded by what had been said, and some kept refusing to believe. ");
INSERT INTO engf35_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","So being in disagreement among themselves they started to leave, after Paul had said this one word: “The Holy Spirit spoke correctly to our fathers through Isaiah the prophet, ");
INSERT INTO engf35_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","saying: ‘Go to this people and say, “You will keep on hearing, but never understand; you will keep on seeing, but never perceive”; ");
INSERT INTO engf35_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","because the heart of this people has become sluggish, and their ears are hard of hearing, and their eyes they have closed; in order that they not see with their eyes, nor hear with their ears, nor understand with their heart, nor turn back, so I could heal them.’ ");
INSERT INTO engf35_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Therefore let it be known to you that the salvation of God has been sent to the Gentiles; they will listen!” ");
INSERT INTO engf35_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","And when he had said these things the Jews went their way, having a great dispute among themselves. ");
INSERT INTO engf35_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul stayed two whole years in his own rented house, and received all who came to see him, ");
INSERT INTO engf35_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","proclaiming the Kingdom of God and teaching the things concerning the Lord Jesus Christ, with all boldness, without hindrance. ");
INSERT INTO engf35_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul, a slave of Jesus Christ, a called apostle, having been set apart to the Gospel of God, ");
INSERT INTO engf35_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","which He promised beforehand through His prophets in the Holy Scriptures: ");
INSERT INTO engf35_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","concerning His Son, who became a physical descendant of David, ");
INSERT INTO engf35_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","who was established to be God's powerful Son (in accordance with Spirit of holiness) by resurrection from the dead—Jesus Christ our Lord— ");
INSERT INTO engf35_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","through whom we have received grace and apostleship to promote obedience of faith among all ethnic nations concerning His name ");
INSERT INTO engf35_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","(among these you also are called by Jesus Christ); ");
INSERT INTO engf35_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","to all the called saints who are in Rome, beloved of God: Grace to you and peace from God our Father and Sovereign Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","First, I thank my God through Jesus Christ for all of you, because your faith is being reported all over the world. ");
INSERT INTO engf35_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Further, the God whom I serve with my spirit in the Gospel of His Son is my witness, how without ceasing I always remember you in my prayers, ");
INSERT INTO engf35_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","begging that perhaps now, at last, I may be prospered by the will of God to come to you. ");
INSERT INTO engf35_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","For I long to see you so that I may impart to you some spiritual gift, so that you may be established ");
INSERT INTO engf35_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","—that is, that I may be encouraged among you by our mutual faith, both yours and mine. ");
INSERT INTO engf35_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","I do not want you to be unaware, brothers, that I often planned to come to you (but was hindered until now), in order that I might have some fruit among you also, just as among the rest of the Gentiles. ");
INSERT INTO engf35_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","I am a debtor both to Greeks and to non-Greeks, both to wise and to foolish. ");
INSERT INTO engf35_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","So, for my part, I am eager to preach the Gospel to you who are in Rome as well. ");
INSERT INTO engf35_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","I am not ashamed of the Gospel of Christ, because it is the power of God for the salvation of each one who believes (for the Jew first, then the Greek); ");
INSERT INTO engf35_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","because in it God's righteousness is revealed, from faith to faith; just as it is written: “The righteous one will live by faith.” ");
INSERT INTO engf35_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Now the wrath of God is revealed from Heaven upon all ungodliness and unrighteousness of the people who suppress the truth by unrighteousness, ");
INSERT INTO engf35_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","precisely because what may be known about God is evident among them, because God has shown it to them. ");
INSERT INTO engf35_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Because His invisible attributes, namely His eternal power and divine nature, are clearly seen from the creation of the world, being understood from what has been made, so that they are inexcusable; ");
INSERT INTO engf35_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","precisely because, knowing God, they neither glorified Him as God nor gave thanks; so their reasonings became worthless and their senseless hearts were darkened. ");
INSERT INTO engf35_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Claiming to be wise, they became fools, ");
INSERT INTO engf35_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","and exchanged for themselves the glory of the incorruptible God for an image resembling a perishable man—even birds and quadrupeds and reptiles! ");
INSERT INTO engf35_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Therefore God also gave them up, through the cravings of their hearts for vileness, to the degrading of their bodies among themselves ");
INSERT INTO engf35_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","—they had exchanged the truth of God for the lie, and worshiped and served the creature rather than the Creator, who is blessed forever. Amen. ");
INSERT INTO engf35_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","For this reason God gave them up to degrading passions; in fact even their females exchanged the natural sexual function for that against nature; ");
INSERT INTO engf35_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","likewise also the males, abandoning the natural use of the female, were inflamed in their lust toward one another, males committing the disgraceful act with males, and receiving in themselves the due penalty for their error. ");
INSERT INTO engf35_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","So precisely because they determined not to retain God in their knowledge, God gave them up to a debased mind, to do wrong things: ");
INSERT INTO engf35_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","having been filled with all unrighteousness, fornication, wickedness, greed, depravity; full of envy, murder, strife, deceit, malignity; gossips, ");
INSERT INTO engf35_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","slanderers, God-haters, insolent, arrogant, braggarts, contrivers of evil things, disobedient to parents, ");
INSERT INTO engf35_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","senseless, faithless, hardhearted, intransigent, unmerciful; ");
INSERT INTO engf35_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","who, knowing full well God's just sentence, that those who practice such things are deserving of death, not only do them but also approve of other practitioners. ");
INSERT INTO engf35_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Now then, you there, whoever you are who judges someone else for things you practice yourself—you condemn yourself and are inexcusable. ");
INSERT INTO engf35_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Further, we know that God's judgment against those who practice such things is according to truth. ");
INSERT INTO engf35_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","So then, you there, you who judge those who practice such things while doing the same, do you really imagine that you will escape God's judgment? ");
INSERT INTO engf35_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Or do you scorn the riches of His kindness, tolerance and longsuffering, not recognizing that the goodness of God is leading you toward repentance? ");
INSERT INTO engf35_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Rather, due to your hardness and unrepentant heart, you are treasuring up wrath for yourself in the day of God's wrath and revelation and righteous judgment, ");
INSERT INTO engf35_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","who will repay each one according to his works: ");
INSERT INTO engf35_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","to those who seek for glory, honor and incorruption, by persevering in doing good—eternal life; ");
INSERT INTO engf35_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","but to those who, due to self-seeking, are actually disobeying the truth (while obeying the unrighteousness)—fury and wrath, ");
INSERT INTO engf35_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","tribulation and anguish, upon every human soul who works at the evil, whether Jew (first) or Greek; ");
INSERT INTO engf35_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","but glory, honor and peace to everyone who works the good, whether Jew (first) or Greek. ");
INSERT INTO engf35_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Now there is no favoritism with God. ");
INSERT INTO engf35_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","For as many as have sinned without law will also perish without law; while as many as have sinned with law will be judged by law. ");
INSERT INTO engf35_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","For it is not the hearers of the law who are righteous before God, but the doers of the law will be justified ");
INSERT INTO engf35_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(indeed, whenever the ethnic nations that do not have law do by nature the things of the law, these, although not having law, are a law to themselves; ");
INSERT INTO engf35_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","who show the work of the law written in their hearts, their conscience also bearing witness, and their reasonings among themselves accusing or even excusing) ");
INSERT INTO engf35_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","in the day when God, according to my Gospel, will judge people's secrets by Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Look, you declare yourself a Jew, and rest on the Law, and boast in God, ");
INSERT INTO engf35_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","and know the Will, and approve the superior things, being instructed out of the Law. ");
INSERT INTO engf35_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Further, you are confident that you yourself are a guide to the blind, a light to those in darkness, ");
INSERT INTO engf35_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","an instructor of the foolish, a teacher of the immature, having in the Law the embodiment of knowledge and truth. ");
INSERT INTO engf35_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","You then, who teach another, do you not teach yourself? You who preach not to steal, do you steal? ");
INSERT INTO engf35_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","You who say not to commit adultery, do you adulterate? You who abhor idols, do you rob temples? ");
INSERT INTO engf35_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","You who boast in the Law, do you dishonor God through the transgression of the Law? ");
INSERT INTO engf35_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","For, just as it is written: “The name of God is blasphemed among the Gentiles because of you.” ");
INSERT INTO engf35_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Now circumcision does have value if you keep the Law, but if you are a transgressor of the Law, your circumcision has become uncircumcision. ");
INSERT INTO engf35_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","So if the uncircumcised keeps the righteous requirements of the Law, will not his uncircumcision be counted as circumcision? ");
INSERT INTO engf35_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","And will not the physically uncircumcised who fulfills the law judge you, complete with written code and circumcision, who are a transgressor of the Law? ");
INSERT INTO engf35_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Because a person is not a true Jew who is only one outwardly, nor is true circumcision something outward in the flesh; ");
INSERT INTO engf35_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","but he is a Jew who is one inwardly, and circumcision is of the heart—in spirit, not letter—whose praise is not from men but from God. ");
INSERT INTO engf35_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","So what advantage does the Jew have, or what is the profit of circumcision? ");
INSERT INTO engf35_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Much in every way! First of all, because they were entrusted with the oracles of God. ");
INSERT INTO engf35_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","So, what if some did not believe? Their unbelief will not nullify God's faithfulness, will it? ");
INSERT INTO engf35_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Of course not! Rather, let God be found true, but every man a liar; just as it is written: “That you may be justified in your words, and may overcome when you are judged.” ");
INSERT INTO engf35_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Now if our unrighteousness highlights God's righteousness, what shall we say? God is not unrighteous for inflicting His wrath, is He? (I speak as a man.) ");
INSERT INTO engf35_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Of course not! Otherwise, how will God judge the world? ");
INSERT INTO engf35_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Still, if the truth of God abounded to His glory by my falsehood, just why am I still judged as a sinner? ");
INSERT INTO engf35_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","However, we must not say, “Let us do evil so that good may come” (as some people slanderously claim that we do)—their condemnation is well deserved! ");
INSERT INTO engf35_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","What then? Are we any better? Not at all! For we have already charged both Jews and Greeks that they are all under sin. ");
INSERT INTO engf35_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Just as it is written: “No one is righteous, not even one; ");
INSERT INTO engf35_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","there is no one who understands, no one who seeks God. ");
INSERT INTO engf35_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","All have turned aside, together they have been made useless; there is no one who shows kindness, no, not so much as one.” ");
INSERT INTO engf35_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Their throat is an opened grave; they habitually deceive with their tongues.” “Viper's venom is under their lips”; ");
INSERT INTO engf35_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“whose mouth is full of cursing and bitterness.” ");
INSERT INTO engf35_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Their feet are swift to shed blood; ");
INSERT INTO engf35_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ruin and wretchedness are in their paths, ");
INSERT INTO engf35_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","and the way of peace they have not known.” ");
INSERT INTO engf35_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“There is no fear of God before their eyes.” ");
INSERT INTO engf35_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Now we know that whatever the law says, it speaks to those who are under the law, so that every mouth may be shut and the whole world become accountable to God. ");
INSERT INTO engf35_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","It follows that no flesh will be justified in His sight by the works of the law, because through the law comes the real knowledge of sin. ");
INSERT INTO engf35_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","But now, apart from law, a righteousness from God has been revealed, being attested by the Law and the Prophets, ");
INSERT INTO engf35_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","namely, a righteousness from God through faith in Jesus Christ, into all and upon all those who believe. There is no difference: ");
INSERT INTO engf35_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","all have sinned and fall short of the glory of God, ");
INSERT INTO engf35_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","being justified freely by His grace through the redemption that is in Christ Jesus; ");
INSERT INTO engf35_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","whom God has openly made available as a propitiation through the faith in His blood, to demonstrate His righteousness because of the passing over, in God's forbearance, of the previously committed sins; ");
INSERT INTO engf35_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","to demonstrate His righteousness at this present time, so as to be just, Himself, and the justifier of him who is of the Faith of Jesus. ");
INSERT INTO engf35_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Where then is the boasting? It is excluded. By what kind of law, that of works? No, but by a law of faith. ");
INSERT INTO engf35_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Therefore we conclude that a person is justified by faith apart from works of law. ");
INSERT INTO engf35_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Or is God for Jews only? Is He not also for Gentiles? Yes, also for Gentiles, ");
INSERT INTO engf35_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","since indeed there is only one God, who will justify the circumcised by faith and the uncircumcised through the Faith. ");
INSERT INTO engf35_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Do we then nullify law through the Faith? Of course not! Rather, we uphold law. ");
INSERT INTO engf35_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","What then shall we say that our father Abraham discovered, as a man? ");
INSERT INTO engf35_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","If Abraham was really justified by works, he has a boast—but not before God. ");
INSERT INTO engf35_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","So what does the Scripture say? “Abraham believed God, and it was credited to him as righteousness.” ");
INSERT INTO engf35_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Now to him who works, the pay is not counted as a gift but as an obligation. ");
INSERT INTO engf35_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","But to him who does not work but believes on Him who justifies the ungodly, his faith is credited as righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Just as David speaks of the blessing of the man to whom God credits righteousness apart from works: ");
INSERT INTO engf35_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blessed are they whose lawless deeds have been forgiven, and whose sins have been covered up. ");
INSERT INTO engf35_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blessed is the man to whom the Lord will not impute sin!” ");
INSERT INTO engf35_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Is this blessing then only for the circumcised, or also for the uncircumcised? Since we say that faith was credited to Abraham as righteousness, ");
INSERT INTO engf35_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","how then was it credited? After he was circumcised or while still uncircumcised? Not circumcised, but uncircumcised! ");
INSERT INTO engf35_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","And he received the sign of circumcision, a seal of the righteousness from his faith while still uncircumcised, so that he might be the father of all those who believe while uncircumcised, in order that this righteousness may be credited to them also, ");
INSERT INTO engf35_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","and the father of the circumcised—not only those who are circumcised, but especially those who follow in the footsteps of the faith of our father Abraham while still uncircumcised. ");
INSERT INTO engf35_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Now the promise that he would be the heir of the world was not to Abraham, or his seed, through law, but through the righteousness of faith. ");
INSERT INTO engf35_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","For if those who are of law are heirs, the faith is made empty and the promise has been invalidated; ");
INSERT INTO engf35_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","because the law produces wrath, since where there is no law neither is there transgression. ");
INSERT INTO engf35_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","For this reason it is of faith so that it may be according to grace, in order that the promise be guaranteed to all the seed—not only to those of law, but also to those of the faith of Abraham, who is the father of us all; ");
INSERT INTO engf35_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","just as it is written: “I have made you a father of many ethnic nations”—in the presence of Him whom he believed: God, who gives life to the dead and calls the nonexistent things as though they did exist. ");
INSERT INTO engf35_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Contrary to hope, Abraham in hope believed, so as to become a father of many ethnic nations, according to what had been spoken: “So shall your seed be.” ");
INSERT INTO engf35_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","And not being weak in faith, he did not consider his own body, already dead (being about a hundred years old), or the deadness of Sarah's womb. ");
INSERT INTO engf35_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","He did not waver at God's promise in unbelief; rather, he was strengthened by the faith, giving glory to God, ");
INSERT INTO engf35_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","being fully convinced that what He had promised He was also able to perform ");
INSERT INTO engf35_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","—that is why it was credited to him as righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Now it was not only for his sake that it was written that it was credited to him, ");
INSERT INTO engf35_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","but for our sake also, to whom it will be credited, we who believe on Him who raised Jesus our Lord from the dead, ");
INSERT INTO engf35_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","who was delivered up because of our transgressions, and was raised because of our justification. ");
INSERT INTO engf35_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Therefore, having been justified by faith, let us be at peace with God through our Lord Jesus Christ, ");
INSERT INTO engf35_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","through whom also we have had the access, by the Faith, into this grace in which we stand, and rejoice in hope of the glory of God. ");
INSERT INTO engf35_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Not only so, but we should also rejoice in the sufferings, knowing that the suffering produces perseverance; ");
INSERT INTO engf35_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","and the perseverance, proven character; and the proven character, hope; ");
INSERT INTO engf35_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","and the hope does not humiliate, because the love of God has been poured out in our hearts by the Holy Spirit who was given to us. ");
INSERT INTO engf35_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Now then, when we were incapacitated, even so Christ died for the ungodly, at the right moment. ");
INSERT INTO engf35_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Now scarcely even for a righteous person will someone offer to die (although on behalf of a good man someone might dare even to die), ");
INSERT INTO engf35_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","but God demonstrates His own love toward us in that while we were still sinners Christ died for us! ");
INSERT INTO engf35_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","So now that we have been justified by His blood, how much more shall we be saved from the wrath through Him! ");
INSERT INTO engf35_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Because since we were reconciled to God through the death of His Son, while we were enemies, how much more, having been reconciled, shall we be saved through His life! ");
INSERT INTO engf35_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","No wonder we rejoice in God through our Lord Jesus Christ, through whom we have now received the reconciliation! ");
INSERT INTO engf35_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Now then, just as sin entered the world through one man, and death through sin, just so death spread to all men, because all sinned ");
INSERT INTO engf35_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","—sin was in the world before the law, to be sure, but sin is not imputed when there is no law. ");
INSERT INTO engf35_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nevertheless, death reigned from Adam to Moses, even over those who did not sin in the likeness of Adam's transgression (he is a type of the coming one). ");
INSERT INTO engf35_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Now the gift is not like the trespass. For if the many died by the trespass of the one, how much more did God's grace and the bounty by the grace of the one man, Jesus Christ, abound to the many! ");
INSERT INTO engf35_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Again, the gift is not like what came from one man's having sinned: because the judgment into condemnation followed one offense, while the gracious gift into justification followed many offenses. ");
INSERT INTO engf35_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Further, if by the offense of the one man death reigned through that man, much more will those who receive the abundance of the grace and of the gift of righteousness reign in life through the One, Jesus Christ. ");
INSERT INTO engf35_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","So then, as through one offense there is condemnation for everyone, so also through one righteous act there is life-giving justification for everyone. ");
INSERT INTO engf35_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","For just as through the disobedience of the one man the many were constituted sinners, so also through the obedience of the One the many will be constituted righteous. ");
INSERT INTO engf35_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","However, law came on the scene so that the offense might abound; but where the sin abounded, the grace superabounded, ");
INSERT INTO engf35_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","so that just as sin reigned in the death, so also the grace might reign through righteousness into eternal life through Jesus Christ our Lord. ");
INSERT INTO engf35_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","So what shall we say? Shall we continue in the sin so that the grace may abound? ");
INSERT INTO engf35_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Of course not! How can we who died to sin keep on living in it? ");
INSERT INTO engf35_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Or are you unaware that as many of us as were baptized into Christ Jesus were baptized into His death? ");
INSERT INTO engf35_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Therefore, we were buried with Him by means of that baptism into that death, so that just as Christ was raised from the dead by means of the Father's glory, we also should walk in newness of life. ");
INSERT INTO engf35_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Now if we have become united with Him in His death, we will certainly be in His resurrection as well; ");
INSERT INTO engf35_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","knowing this, that our old self was crucified with Him in order that the body of the sin might be set aside, so that we no longer be enslaved to that sin— ");
INSERT INTO engf35_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","because he who has died has been released from that sin. ");
INSERT INTO engf35_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Now since we died with Christ, we believe that we will also live with Him, ");
INSERT INTO engf35_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","knowing that Christ, having been raised from the dead, cannot die again; death can no longer master Him ");
INSERT INTO engf35_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","—the death He died He died to sin once for all, while the life He lives He lives to God. ");
INSERT INTO engf35_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Thus you also, consider yourselves to be dead indeed to the sin, but alive to God in Christ Jesus our Lord. ");
INSERT INTO engf35_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Therefore do not let the sin reign in your mortal body, so that you obey it with the body's evil desires ");
INSERT INTO engf35_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","—do not present any part of your body to sin as an implement for unrighteousness, but present yourselves to God as those who are alive from the dead, and your body parts to God as implements for righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Really, sin must not rule over you, because you are not under law but under grace. ");
INSERT INTO engf35_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","What then? Shall we sin because we are not under law but under grace? Of course not! ");
INSERT INTO engf35_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Do you not know that when you offer yourselves to someone to obey them as slaves, you are slaves to the one whom you obey—whether of sin into death, or of obedience into righteousness? ");
INSERT INTO engf35_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","But thanks be to God that although you used to be the slaves of the sin you wholeheartedly obeyed that pattern of doctrine into which you were delivered. ");
INSERT INTO engf35_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","So having been emancipated from the sin, you became enslaved to the righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","I continue to speak on a human level because of the weakness of your flesh. Now just as you used to present your body parts as slaves to uncleanness, and to ever increasing lawlessness, so now present your body parts as slaves to righteousness with a view to sanctification. ");
INSERT INTO engf35_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","For when you were slaves to the sin, you were ‘free’ from the righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","So what ‘fruit’ did you have at that time from the things you are now ashamed of? The end of those things is death! ");
INSERT INTO engf35_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","But now, having been emancipated from the sin, and having become enslaved to God, you have your ‘fruit’ into sanctification—and the end is eternal life! ");
INSERT INTO engf35_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Because the wages of sin is death, but the gracious gift of God is eternal life in Christ Jesus our Lord. ");
INSERT INTO engf35_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Do you not know, brothers (for I am speaking to those who know law), that the law has authority over someone only as long as he lives? ");
INSERT INTO engf35_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","For example, a married woman is bound by law to her husband while he lives, but if the man should die, she is released from the law about the husband. ");
INSERT INTO engf35_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","So then, if she should ‘marry’ another man while her husband is living, she will be labeled an adulteress; but if the husband should die, she is free from that law, not being an adulteress if she marries another man. ");
INSERT INTO engf35_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Therefore, my brothers, you also were put to death to the law through the body of the Christ so as to belong to another—to Him who was raised from the dead—so that we should produce fruit to God. ");
INSERT INTO engf35_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Because when we were in the flesh, the sinful passions aroused by the law were at work in our body parts to produce fruit to death. ");
INSERT INTO engf35_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","But now we have been released from the law, having died to what was gripping us, so as to slave in newness of spirit and not in oldness of letter. ");
INSERT INTO engf35_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","So what shall we say then? Is the law sin? Of course not! Indeed, I would not have come to know the sin except through the law: I would not have recognized covetousness if the law had not said, “You must not covet.” ");
INSERT INTO engf35_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","But the sin, grasping an opportunity through the commandment, produced in me all kinds of coveting. Now without the law sin is dead. ");
INSERT INTO engf35_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Once upon a time, without law, I was actually ‘alive’; but when the commandment came, the sin came to life and I died. ");
INSERT INTO engf35_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Yes, the commandment that was to bring me life turned out to bring death. ");
INSERT INTO engf35_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Because the sin, grasping an opportunity through the commandment, completely deceived me, and used it to ‘kill’ me. ");
INSERT INTO engf35_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","So then, the law itself is holy, and the commandment is holy and righteous and good. ");
INSERT INTO engf35_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","So has what is good become death to me? Of course not! Rather the sin, that it might be exposed as sin, was producing death in me through what is good, so that through the commandment the sin might become extremely sinful. ");
INSERT INTO engf35_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","We know that the law is spiritual, but I am fleshly, having been ‘sold’ under sin ");
INSERT INTO engf35_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","—you see, I do not understand what I am doing: I do not practice what I want to do, but I do what I hate! ");
INSERT INTO engf35_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","But if I do what I do not want to do, I agree with the law that it is good. ");
INSERT INTO engf35_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","So now it is no longer I who am doing it, but the sin dwelling in me. ");
INSERT INTO engf35_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Further, I know that nothing good dwells in me, that is, in my flesh; because to will is present with me, but I do not find how to perform the good. ");
INSERT INTO engf35_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Because I do not do the good that I want to do; rather I practice the evil that I do not want to do. ");
INSERT INTO engf35_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Now if I do what I do not want to do, it is no longer I who do it, but the sin dwelling in me. ");
INSERT INTO engf35_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","So I find this ‘law’: when I want to do good, evil is right there with me. ");
INSERT INTO engf35_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","I joyfully agree with God's law according to the inner man, ");
INSERT INTO engf35_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","but I see a different ‘law’ in my body parts, warring against the law of my mind and taking me captive to the law of the sin that is in my body parts. ");
INSERT INTO engf35_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","What a wretched man I am! Who will deliver me from this body of death? ");
INSERT INTO engf35_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","I thank God—through Jesus Christ our Lord! So then, with the mind I myself serve God's law, but with the flesh, sin's law. ");
INSERT INTO engf35_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Now then, there is no condemnation to those in Christ Jesus who do not walk according to the flesh but according to the Spirit, ");
INSERT INTO engf35_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","because the law of the spirit of life in Christ Jesus has set me free from the law of the sin and the death. ");
INSERT INTO engf35_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Further, what the law could not do, in that it was weak due to the flesh, God has done by sending His own Son in the likeness of sinful flesh, on account of sin: He condemned the sin in the flesh, ");
INSERT INTO engf35_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","so that the righteous requirement of the law might be fulfilled in us who do not walk according to the flesh but according to the Spirit. ");
INSERT INTO engf35_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Those who live according to the flesh set their minds on the things of the flesh, but those who live according to the Spirit, the things of the Spirit. ");
INSERT INTO engf35_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Further, the mindset of the flesh yields death, but the mindset of the Spirit yields life and peace; ");
INSERT INTO engf35_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","because the mindset of the flesh represents enmity against God, since it does not submit to God's law, nor indeed can it. ");
INSERT INTO engf35_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","So, those who are ‘in flesh’ cannot please God. ");
INSERT INTO engf35_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","You, however, are not ‘in flesh’ but ‘in Spirit’, if indeed God's Spirit dwells in you. Now if anyone does not have the Spirit of Christ, he is not His. ");
INSERT INTO engf35_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","But if Christ is in you, the body is dead through sin, but the Spirit is life through righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","And if the Spirit of Him who raised Jesus from the dead dwells in you, then He who raised the Christ from the dead will also give life to your mortal bodies because of His Spirit who dwells in you. ");
INSERT INTO engf35_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","So then, brothers, we have no obligation to the flesh, to live according to it; ");
INSERT INTO engf35_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","because if you live according to the flesh, you are about to die; but if you put to death the practices of the body, by the Spirit, you will live. ");
INSERT INTO engf35_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Because as many as are led by God's Spirit, these are God's sons ");
INSERT INTO engf35_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","—you did not receive a spirit of slavery to fear all over again, but you did receive the Spirit of adoption by whom we cry out, “Abba, Father!” ");
INSERT INTO engf35_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","That Spirit Himself bears witness with our spirit that we are God's children ");
INSERT INTO engf35_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","—if children, also heirs: heirs of God and coheirs with Christ (if indeed we suffer with Him so that we may also be glorified with Him). ");
INSERT INTO engf35_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","I consider that the sufferings of this present time are not worthy to be compared with the glory that is going to be revealed in us. ");
INSERT INTO engf35_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","You see, the creation waits with eager anticipation for the revelation of God's sons; ");
INSERT INTO engf35_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","because without choice the creation was subjected to futility, due to the One who did the subjecting, based on the hope ");
INSERT INTO engf35_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","that the creation itself will also be set free from the bondage to decay into the freedom of the glory of God's children. ");
INSERT INTO engf35_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Yes, we know that the whole creation has been groaning and in labor pains until now. ");
INSERT INTO engf35_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Not only that, we ourselves also who have the firstfruits of the Spirit, even we groan within ourselves, eagerly awaiting adoption, the redemption of our body. ");
INSERT INTO engf35_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Yes, we were saved in the hope, but a hope that is seen is not hope—why would anyone hope for what he sees? ");
INSERT INTO engf35_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","But if we hope for what we do not see, we eagerly await it with endurance. ");
INSERT INTO engf35_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Likewise also the Spirit comes to the aid of the hope in our weaknesses, since we do not know what we need to pray for. Indeed the Spirit Himself intercedes on our behalf with inexpressible groanings, ");
INSERT INTO engf35_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","while He who searches the hearts knows what is on the Spirit's mind, since He prays for the saints in accordance with God. ");
INSERT INTO engf35_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Further, we know that all things work together for good for those who love God, for those who are called according to purpose. ");
INSERT INTO engf35_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Because whom He foreknew He also predestined to be conformed to the image of His Son, so that He would be the firstborn among many brothers. ");
INSERT INTO engf35_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Further, whom He predestined, these He also called; and whom He called, these He also justified; and whom He justified, these He also glorified. ");
INSERT INTO engf35_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","What then shall we say to these things? Since God is for us, who is against us? ");
INSERT INTO engf35_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","He who did not spare His own Son, but delivered Him up on behalf of us all, how shall He not with Him also graciously give us all things? ");
INSERT INTO engf35_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Who will bring a charge against God's chosen ones? God is He who justifies. ");
INSERT INTO engf35_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Who is he who condemns? Christ is He who died, but even more, was indeed raised, who indeed is at the right hand of God, who indeed intercedes on our behalf. ");
INSERT INTO engf35_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Who shall separate us from the love of Christ? Will it be affliction or distress or persecution or famine or nakedness or peril or sword? ");
INSERT INTO engf35_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","(As it is written: “For your sake we are being put to death all day long; we are accounted as sheep for slaughter.”) ");
INSERT INTO engf35_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","No, in all these things we prevail completely through Him who loved us. ");
INSERT INTO engf35_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Because I am persuaded that neither death nor life, neither angels nor principalities nor powers, neither things present nor things to come, ");
INSERT INTO engf35_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","neither height nor depth nor any other created thing will have the power to separate us from the love of God that is in Christ Jesus our Lord. ");
INSERT INTO engf35_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","I am speaking the truth in Christ—I am not lying; my conscience is testifying with me in the Holy Spirit— ");
INSERT INTO engf35_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","I have great sorrow and unceasing distress in my heart. ");
INSERT INTO engf35_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","For I keep wishing that I myself could be accursed away from the Messiah for the sake of my brothers, my physical relatives, ");
INSERT INTO engf35_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","the Israelites. To them belong the adoption, the glory, the covenants, the giving of the law, the temple service, and the promises. ");
INSERT INTO engf35_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","The patriarchs are theirs, and from them came the Christ (the physical part), who is over all, God forever blessed. Amen. ");
INSERT INTO engf35_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","However, it is not as though the Word of God has failed! For not all who have descended from Israel are ‘Israel’. ");
INSERT INTO engf35_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Neither are they all ‘children’ because they are Abraham's descendants; but, “in Isaac will your seed be called.” ");
INSERT INTO engf35_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","That is, it is not the physical children who are God's ‘children’, but the children of the promise are regarded as ‘seed’. ");
INSERT INTO engf35_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","For this is the word of promise: “At this season I will come, and Sarah will have a son.” ");
INSERT INTO engf35_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Not only that, but also when Rebecca had conceived twins by our forefather Isaac ");
INSERT INTO engf35_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","(though they had not yet been born, not having done anything good or bad, so that God's purpose according to election might stand, not of works but of Him who calls), ");
INSERT INTO engf35_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","it was said to her, “The older will serve the younger.” ");
INSERT INTO engf35_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","As it is written: “Jacob I loved, but Esau I hated.” ");
INSERT INTO engf35_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","So what shall we say, there is no injustice with God, is there? Of course not! ");
INSERT INTO engf35_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","For He says to Moses: “I will have mercy on whomever I have mercy, and I will have compassion on whomever I have compassion.” ");
INSERT INTO engf35_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","So then, it is not of him who wills nor of him who strives, but of God who shows mercy. ");
INSERT INTO engf35_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","For the Scripture says to Pharaoh: “I raised you up for this very purpose, that I might display my power in you, and that my name might be proclaimed in all the earth.” ");
INSERT INTO engf35_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","So then, He has mercy on whom He wishes, and He hardens whom He wishes. ");
INSERT INTO engf35_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","You will say to me then, “Why does He still find fault? For who has ever resisted His will?” ");
INSERT INTO engf35_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Really now, just who are you, O man, to talk back to God? What is formed will not say to the one who formed it, “Why did you make me like this,” will it? ");
INSERT INTO engf35_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Or has the potter no right over the clay, to make from the same lump one vessel for honor and another for dishonor? ");
INSERT INTO engf35_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","What if God, wishing to display His wrath and to make His power known, endured with much patience vessels of wrath prepared for destruction, ");
INSERT INTO engf35_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","just in order to make known the riches of His glory on vessels of mercy, which He prepared beforehand for glory, ");
INSERT INTO engf35_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","even us whom He called, not only from the Jews but also from the Gentiles? ");
INSERT INTO engf35_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","As He also says in Hosea: “I will call the ‘not my people’, ‘my people’, and the ‘not loved’ (f), ‘loved’.” ");
INSERT INTO engf35_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","“And it will be in the place where it was said to them, ‘You are not my people,’ there they will be called sons of the living God.” ");
INSERT INTO engf35_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","And Isaiah cries out concerning Israel: “Though the number of the children of Israel be as the sand of the sea, only the remnant will be saved; ");
INSERT INTO engf35_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","because He is finishing and cutting short an accounting in righteousness; yes, the Lord will impose a condensed accounting upon the earth.” ");
INSERT INTO engf35_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","And as Isaiah had said previously: “Unless the Lord of Sabaoth had left us a seed, we would have become like Sodom, and we would have been made like Gomorrah.” ");
INSERT INTO engf35_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","So what shall we say? That Gentiles, who did not pursue righteousness, attained to righteousness, namely the righteousness that comes from faith; ");
INSERT INTO engf35_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","while Israel, pursuing a standard of righteousness, did not attain to that standard. ");
INSERT INTO engf35_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Why not? Because it was not from faith, but as from works of the law. They stumbled over the ‘stumbling stone’; ");
INSERT INTO engf35_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","as it is written: “Look! I am placing in Zion a stumbling stone and a rock of offense, and no one who believes on Him will be put to shame.” ");
INSERT INTO engf35_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Brothers, my heart's desire and prayer to God for Israel is for their salvation. ");
INSERT INTO engf35_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","For I bear them witness that they have a zeal for God, but not according to real knowledge. ");
INSERT INTO engf35_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","For they, failing to understand God's righteousness and seeking to establish their own righteousness, have not submitted to God's righteousness. ");
INSERT INTO engf35_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Now for everyone who believes into righteousness, Christ is the end of the law ");
INSERT INTO engf35_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","—Moses writes about the righteousness that is from the law: “The person who does these things will live by them.” ");
INSERT INTO engf35_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","But the righteousness that is from faith speaks like this: “Do not say in your heart, ‘Who will ascend into heaven?’ ” (that is, to bring Christ down) ");
INSERT INTO engf35_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","“or, ‘Who will descend into the abyss?’ ” (that is, to bring Christ up from the dead). ");
INSERT INTO engf35_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","So what does it say? “The message is near you, in your mouth and in your heart” (that is, the message of faith that we proclaim): ");
INSERT INTO engf35_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","That if you confess with your mouth, “Jesus is Lord,” and believe in your heart that God raised Him from the dead, you will be saved. ");
INSERT INTO engf35_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Because with the heart one believes into righteousness, and with the mouth one promises into salvation. ");
INSERT INTO engf35_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Because the Scripture says: “Everyone who believes on Him will never be put to shame”; ");
INSERT INTO engf35_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","because there is no distinction between Jew and Greek, since the same Lord of all is rich to all who call upon Him; ");
INSERT INTO engf35_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","because: “Everyone who calls on the name of the Lord will be saved.” ");
INSERT INTO engf35_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","How then will they call on Him in whom they have not believed? And how can they believe on Him of whom they have not heard? And how will they hear without someone proclaiming it? ");
INSERT INTO engf35_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","And how will they proclaim unless they are sent? As it is written: “How timely is the arrival of those who bring good news of peace, of those who announce the good things.” ");
INSERT INTO engf35_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","(However, they did not all obey the gospel; because Isaiah says: “Lord, who has believed our message?”) ");
INSERT INTO engf35_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","So, the faith is from a message, and that message is by the Word of God. ");
INSERT INTO engf35_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","But I say, did they really not hear? Indeed yes: “Their voice has gone out into all the earth, and their spoken words to the ends of the inhabited world.” ");
INSERT INTO engf35_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Again I say, did Israel really not know? First Moses says: “I will provoke you to jealousy by a non-nation, I will move you to anger by a senseless nation.” ");
INSERT INTO engf35_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","But Isaiah is so bold as to say: “I was found by those who were not seeking me; I was revealed to those who were not asking for me.” ");
INSERT INTO engf35_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","But concerning Israel he says: “All day long I have held out my hands to a disobedient and contrary people.” ");
INSERT INTO engf35_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","So now I say, God did not reject His people, did He? Of course not! Why I myself am an Israelite, of the seed of Abraham, from the tribe of Benjamin! ");
INSERT INTO engf35_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","God has not rejected His people whom He foreknew. Do you not know what the Scripture says about Elijah, how he appeals to God against Israel saying: ");
INSERT INTO engf35_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Lord, they have killed your prophets and torn down your altars; I am the only one left, and they are trying to take my life!” ");
INSERT INTO engf35_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","But what does the divine response say to him? “I have reserved for myself seven thousand men who have not bowed the knee to Baal.” ");
INSERT INTO engf35_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Even so then at this present time, there is a remnant according to an election by grace. ");
INSERT INTO engf35_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Now if by grace, it is no longer from works; otherwise the grace is no longer grace. But if from works, it is no longer grace; otherwise the work is no longer work. ");
INSERT INTO engf35_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","What then? What Israel is seeking, this it did not obtain; but the election did obtain it, while the rest were dulled. ");
INSERT INTO engf35_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Just as it is written: “God gave them a spirit of stupor, eyes that were not to see and ears that were not to hear, to this very day.” ");
INSERT INTO engf35_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","And David says: “Let their table be made into a snare and into a trap, into a stumbling block and into a retribution to them. ");
INSERT INTO engf35_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Let their eyes be darkened so as not to see, and their back always be bowed down.” ");
INSERT INTO engf35_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","So now I say, surely they have not stumbled so as to fall and stay fallen? Of course not! Rather, through their transgression the salvation has come to the Gentiles, to provoke them to jealousy. ");
INSERT INTO engf35_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Now if their transgression means riches for the world, and their loss riches for the nations, how much more their fulfillment! ");
INSERT INTO engf35_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","So I am speaking to you Gentiles (inasmuch as I am ‘apostle to the Gentiles’, I magnify my ministry), ");
INSERT INTO engf35_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","if somehow I can provoke my own people to jealousy and save some of them. ");
INSERT INTO engf35_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","For if their being rejected means reconciliation for the world, what will their restoration be but life from the dead? ");
INSERT INTO engf35_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Now if the ‘firstfruit’ is holy, so is the whole batch; and if the root is holy, so are the branches. ");
INSERT INTO engf35_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Now if some of the branches were broken off, while you, being a wild olive shoot, were grafted in among them, and with them have become a partaker of the root and the rich sap of the cultivated olive, ");
INSERT INTO engf35_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","do not boast against those branches (since if you do boast—it is not you who support the root but the root you). ");
INSERT INTO engf35_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","You will say then, “Branches were broken off so that I might be grafted in.” ");
INSERT INTO engf35_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Granted. Because of unbelief they were broken off, but you stand by faith. Do not be arrogant, but fear! ");
INSERT INTO engf35_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Because if God did not spare the natural branches, perhaps He will not spare you either! ");
INSERT INTO engf35_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","So consider the kindness and severity of God: upon those who fell, severity; but toward you, kindness, if you continue in that kindness; otherwise you too will be cut off. ");
INSERT INTO engf35_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","And even they, if they do not persist in the unbelief, will be grafted back in, because God has the power to graft them in again. ");
INSERT INTO engf35_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","For if you were cut out of a wild by nature olive tree, and were grafted contrary to nature into a cultivated olive tree, how much more will these, the natural branches, be grafted into their own olive tree? ");
INSERT INTO engf35_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Brothers, I do not want you to be ignorant of this ‘mystery’ (so that you not be conceited): hardening has come upon Israel in part until the full number of the Gentiles has come in. ");
INSERT INTO engf35_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","And so all Israel will be saved, just as it is written: “The Deliverer will come out of Zion, and He will turn ungodliness away from Jacob; ");
INSERT INTO engf35_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","this is my covenant with them, when I take away their sins.” ");
INSERT INTO engf35_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","On the one hand, regarding the Gospel, they are enemies because of you; on the other, regarding the election, they are beloved on account of the forefathers. ");
INSERT INTO engf35_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Because God's gracious gifts and calling are irrevocable. ");
INSERT INTO engf35_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","For just as you also were once disobedient to God, but now have been shown mercy through their disobedience, ");
INSERT INTO engf35_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","so also these have now been disobedient that through the mercy shown to you they also may be shown mercy. ");
INSERT INTO engf35_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Yes, God has given everyone over to disobedience so that He might show mercy to all. ");
INSERT INTO engf35_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Oh, the depth of the riches of God's wisdom and knowledge! How unsearchable His judgments and untraceable His ways! ");
INSERT INTO engf35_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Because “Who has known the mind of the Lord? Or who has been His counselor?” ");
INSERT INTO engf35_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Or “Who has ever given to Him and has to be repaid?” ");
INSERT INTO engf35_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Because from Him and through Him and to Him are all things. To Him be the glory forever! Amen. ");
INSERT INTO engf35_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Now then, brothers, I exhort you, in view of God's compassions, to present your bodies as a living sacrifice, holy, satisfying to God—your intelligent duty. ");
INSERT INTO engf35_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Yes, stop conforming to the pattern of this world; rather, be transformed by the renewing of your mind so as to be able to experience the good and satisfying and perfect will of God. ");
INSERT INTO engf35_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Based on the grace given to me, I say to everyone among you not to set your sights higher than you should, but set them sensibly, as God has apportioned a measure of faith to each. ");
INSERT INTO engf35_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Because just as in one body we have many parts, but all the parts do not have the same function, ");
INSERT INTO engf35_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","so we, who are many, are one body in Christ and individually members of one another. ");
INSERT INTO engf35_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Since we have different spiritual gifts according to the grace that was given us, let us use them: if prophecy, according to the analogy of the Faith; ");
INSERT INTO engf35_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","if serving, in the serving; if teaching, in the teaching; ");
INSERT INTO engf35_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","if exhorting, in the exhortation; the sharer, with simplicity; the leader, with diligence; the mercy-shower, with cheerfulness. ");
INSERT INTO engf35_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Love is to be genuine: abhorring the malignant; clinging to the good; ");
INSERT INTO engf35_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","showing family affection to one another in brotherly love; in honor preferring one another; ");
INSERT INTO engf35_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","not lagging in diligence; serving the Lord with an enthusiastic spirit; ");
INSERT INTO engf35_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","rejoicing in the hope; enduring the affliction; continuing steadfastly in prayer; ");
INSERT INTO engf35_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","distributing to the needs of the saints; practicing hospitality. ");
INSERT INTO engf35_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Bless those who persecute you; bless and do not curse. ");
INSERT INTO engf35_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Rejoice with those who rejoice and weep with those who weep. ");
INSERT INTO engf35_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Regard each other as being on the same level—do not distinguish the upper classes, but associate with the lower classes; do not exalt yourself. ");
INSERT INTO engf35_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Do not repay anyone evil for evil. Have regard for things that everyone considers to be good. ");
INSERT INTO engf35_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","If possible, what depends on you, live at peace with everyone. ");
INSERT INTO engf35_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Dear ones, do not avenge yourselves; rather give place to the wrath; for it is written: “Vengeance is up to me; I will repay,” says the Lord. ");
INSERT INTO engf35_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Therefore, “If your enemy is hungry, feed him; if he is thirsty, give him a drink; for in doing this you will heap coals of fire on his head.” ");
INSERT INTO engf35_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Do not be overcome by evil, but overcome the evil with the good. ");
INSERT INTO engf35_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Let every soul submit to the governing authorities, because there is no authority except under God, and the existing authorities have been placed by God. ");
INSERT INTO engf35_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Therefore whoever resists the authority is opposed to God's ordinance, and those who oppose will bring judgment on themselves. ");
INSERT INTO engf35_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Now rulers are not a terror to good deeds but to bad ones. So if you wish not to fear the authority, do the good and you will have praise from the same; ");
INSERT INTO engf35_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","because it is God's minister to you with a view to the good. But if you do wrong, be afraid, because it does not bear the sword for nothing; because it is God's minister, an avenger with a view to wrath on the wrongdoer. ");
INSERT INTO engf35_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Therefore it is necessary to submit, not only because of the wrath, but also because of the conscience. ");
INSERT INTO engf35_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","This is precisely why you pay taxes, for they are God's servants, continually attending on this very thing. ");
INSERT INTO engf35_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Render therefore to all their due: taxes to whom taxes, customs to whom customs, respect to whom respect, honor to whom honor. ");
INSERT INTO engf35_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Owe no one anything except to love one another, since he who loves the other has fulfilled the law. ");
INSERT INTO engf35_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Because—“You shall not commit adultery,” “You shall not murder,” “You shall not steal,” “You shall not bear false witness,” “You shall not covet,” and whatever further commandment—everything is summed up in this word, namely: “You shall love your neighbor as yourself.” ");
INSERT INTO engf35_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Love does no harm to a neighbor; therefore love is the fulfillment of the law. ");
INSERT INTO engf35_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Besides this, knowing the time, it is high time for us to be awakened from sleep, because our salvation is nearer now than when we first believed. ");
INSERT INTO engf35_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","The night is nearly over, and the day is near; so let us get rid of the works of the darkness, and let us put on the weapons of the light. ");
INSERT INTO engf35_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Let us walk properly, as in the day, not in carousing and drunkenness, not in sexual orgies and licentiousness, not in strife and jealousy. ");
INSERT INTO engf35_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","But put on the Lord Jesus Christ, and make no provision for the flesh, with a view to lusts. ");
INSERT INTO engf35_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Receive someone who is weak in the faith, but not for disputes over arguables. ");
INSERT INTO engf35_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","One man has faith to eat everything, while the weak one eats only vegetables. ");
INSERT INTO engf35_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","One who eats must not look down on one who does not, and one who does not eat must not judge one who does, because God has accepted him. ");
INSERT INTO engf35_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Who are you to judge someone else's household servant? To his own master he stands or falls. And stand he will, for God has the power to make him stand. ");
INSERT INTO engf35_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","One man esteems one day above another; another esteems everyday alike. Let each one be fully convinced in his own mind. ");
INSERT INTO engf35_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","He who observes the day, observes it to the Lord; and he who does not observe the day, to the Lord he does not observe it. And he who eats, eats to the Lord, since he gives thanks to God; while he who does not eat, to the Lord he does not eat, also giving thanks to God. ");
INSERT INTO engf35_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","You see, none of us lives to himself, and no one dies to himself. ");
INSERT INTO engf35_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Because if we live, we live to the Lord; and if we die, we die to the Lord. So whether we live or whether we die, we are the Lord's. ");
INSERT INTO engf35_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","For this very reason Christ both died and rose, and lived, so as to rule both dead and living. ");
INSERT INTO engf35_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","But you, why do you judge your brother? And you too, why do you look down on your brother? Because we will all stand before the Judgment Seat of Christ. ");
INSERT INTO engf35_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","For it is written: “ ‘As I live,’ says the Lord, ‘every knee shall bow to me, and every tongue shall acknowledge God.’ ” ");
INSERT INTO engf35_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","So then, each of us will give an account of himself to God. ");
INSERT INTO engf35_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Therefore let us stop passing judgment on one another, but rather resolve this: not to put a stumbling block or pitfall in a brother's way. ");
INSERT INTO engf35_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","I know and have been convinced by Sovereign Jesus that nothing is unclean of itself (still, to someone who considers a thing to be unclean, to him it is unclean), ");
INSERT INTO engf35_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","but if your brother is offended because of food, you are no longer walking according to love. Do not, with your food, ruin someone for whom Christ died. ");
INSERT INTO engf35_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","So do not let your good be slandered; ");
INSERT INTO engf35_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","because the Kingdom of God is not eating and drinking, but righteousness and peace and joy in Holy Spirit. ");
INSERT INTO engf35_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","For whoever serves the Christ in these things is satisfying to God and approved by men. ");
INSERT INTO engf35_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","So then, let us pursue the things that promote peace and the things by which one may edify another. ");
INSERT INTO engf35_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Do not destroy the work of God for the sake of food. All things indeed are ‘clean’; however it is wrong for the man who gives offence by eating. ");
INSERT INTO engf35_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","It is good not to eat meat nor drink wine nor do anything by which your brother stumbles, or is offended, or is weakened. ");
INSERT INTO engf35_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Do you have faith? Have it privately before God. Happy is he who does not judge himself in what he approves. ");
INSERT INTO engf35_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","But he who eats with doubt stands condemned, because it is not from faith; for whatever is not from faith is sin. ");
INSERT INTO engf35_vpl VALUES ("RM14_24","075_14_24","ROM","14","24","24","Now to Him who has power to establish you according to my Gospel and the proclamation of Jesus Christ, according to the revelation of the mystery kept secret through long ages, ");
INSERT INTO engf35_vpl VALUES ("RM14_25","075_14_25","ROM","14","25","25","but now revealed and made known through the prophetic Scriptures, according to the command of the eternal God, with a view to obedience of faith among all ethnic nations ");
INSERT INTO engf35_vpl VALUES ("RM14_26","075_14_26","ROM","14","26","26","—to the only wise God, through Jesus Christ—to Him be the glory forever! Amen. ");
INSERT INTO engf35_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Now we who are strong ought to bear with the limitations of the weak, and not to please ourselves. ");
INSERT INTO engf35_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Let each of us please the neighbor with a view to what is good for edifying. ");
INSERT INTO engf35_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Because even the Christ did not please Himself; rather, as it is written: “The revilings of those reviling you fell on me.” ");
INSERT INTO engf35_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Whatever things were written before were so written for our instruction, so that through the fortitude and the encouragement of the Scriptures we might have hope. ");
INSERT INTO engf35_vpl VALUES ("RM15_5","075_15_5","ROM","15","5