﻿USE sofia;
DROP TABLE IF EXISTS sofia.engerv_vpl;
CREATE TABLE engerv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engerv_vpl WRITE;
INSERT INTO engerv_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","God created the sky and the earth. At first, ");
INSERT INTO engerv_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","the earth was completely empty. There was nothing on the earth. Darkness covered the ocean, and God’s Spirit moved over the water. ");
INSERT INTO engerv_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Then God said, “Let there be light!” And light began to shine. ");
INSERT INTO engerv_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","He saw the light, and he knew that it was good. Then he separated the light from the darkness. ");
INSERT INTO engerv_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God named the light “day,” and he named the darkness “night.” There was evening, and then there was morning. This was the first day. ");
INSERT INTO engerv_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Then God said, “Let there be a space to separate the water into two parts!” ");
INSERT INTO engerv_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","So God made the space and separated the water. Some of the water was above it, and some of the water was below it. ");
INSERT INTO engerv_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God named that space “sky.” There was evening, and then there was morning. This was the second day. ");
INSERT INTO engerv_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Then God said, “Let the water under the sky be gathered together so that the dry land will appear.” And it happened. ");
INSERT INTO engerv_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God named the dry land “earth,” and he named the water that was gathered together “seas.” And God saw that this was good. ");
INSERT INTO engerv_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Then God said, “Let the earth grow grass, plants that make grain, and fruit trees. The fruit trees will make fruit with seeds in it. And each plant will make its own kind of seed. Let these plants grow on the earth.” And it happened. ");
INSERT INTO engerv_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","The earth grew grass and plants that made grain. And it grew trees that made fruit with seeds in it. Every plant made its own kind of seeds. And God saw that this was good. ");
INSERT INTO engerv_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","There was evening, and then there was morning. This was the third day. ");
INSERT INTO engerv_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Then God said, “Let there be lights in the sky. These lights will separate the days from the nights. They will be used for signs to show when special meetings begin and to show the days and years. ");
INSERT INTO engerv_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","They will be in the sky to shine light on the earth.” And it happened. ");
INSERT INTO engerv_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","So God made the two large lights. He made the larger light to rule during the day and the smaller light to rule during the night. He also made the stars. ");
INSERT INTO engerv_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God put these lights in the sky to shine on the earth. ");
INSERT INTO engerv_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","He put them in the sky to rule over the day and over the night. They separated the light from the darkness. And God saw that this was good. ");
INSERT INTO engerv_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","There was evening, and then there was morning. This was the fourth day. ");
INSERT INTO engerv_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Then God said, “Let the water be filled with many living things, and let there be birds to fly in the air over the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","So God created the large sea animals. He created all the many living things in the sea and every kind of bird that flies in the air. And God saw that this was good. ");
INSERT INTO engerv_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God blessed all the living things in the sea and told them to have many babies and fill the seas. And he blessed the birds on land and told them to have many more babies. ");
INSERT INTO engerv_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","There was evening, and then there was morning. This was the fifth day. ");
INSERT INTO engerv_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Then God said, “Let the earth produce many kinds of living things. Let there be many different kinds of animals. Let there be large animals and small crawling animals of every kind. And let all these animals produce more animals.” And all these things happened. ");
INSERT INTO engerv_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","So God made every kind of animal. He made the wild animals, the tame animals, and all the small crawling things. And God saw that this was good. ");
INSERT INTO engerv_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Then God said, “Now let’s make humans who will be like us. They will rule over all the fish in the sea and the birds in the air. They will rule over all the large animals and all the little things that crawl on the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","So God created humans in his own image. He created them to be like himself. He created them male and female. ");
INSERT INTO engerv_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God blessed them and said to them, “Have many children. Fill the earth and take control of it. Rule over the fish in the sea and the birds in the air. Rule over every living thing that moves on the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God said, “I am giving you all the grain bearing plants and all the fruit trees. These trees make fruit with seeds in it. This grain and fruit will be your food. ");
INSERT INTO engerv_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","And I am giving all the green plants to the animals. These green plants will be their food. Every animal on earth, every bird in the air, and all the little things that crawl on the earth will eat that food.” And all these things happened. ");
INSERT INTO engerv_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God looked at everything he had made. And he saw that everything was very good. There was evening, and then there was morning. This was the sixth day. ");
INSERT INTO engerv_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","So the earth, the sky, and everything in them were finished. ");
INSERT INTO engerv_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","God finished the work he was doing, so on the seventh day he rested from his work. ");
INSERT INTO engerv_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God blessed the seventh day and made it a holy day. He made it special because on that day he rested from all the work he did while creating the world. ");
INSERT INTO engerv_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","This is the story about the creation of the sky and the earth. This is what happened when the LORD God made the earth and the sky. ");
INSERT INTO engerv_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","This was before there were plants on the earth. Nothing was growing in the fields because the LORD God had not yet made it rain on the earth, and there was no one to care for the plants. ");
INSERT INTO engerv_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","So water came up from the earth and spread over the ground. ");
INSERT INTO engerv_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Then the LORD God took dust from the ground and made a man. He breathed the breath of life into the man’s nose, and the man became a living thing. ");
INSERT INTO engerv_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Then the LORD God planted a garden in the East, in a place named Eden. He put the man he made in that garden. ");
INSERT INTO engerv_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Then the LORD God caused all the beautiful trees that were good for food to grow in the garden. In the middle of the garden, he put the tree of life and the tree that gives knowledge about good and evil. ");
INSERT INTO engerv_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","A river flowed from Eden and watered the garden. The river then separated and became four smaller rivers. ");
INSERT INTO engerv_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","The name of the first river was Pishon. This river flowed around the entire country of Havilah. ");
INSERT INTO engerv_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(There is gold in that country, and that gold is pure. A kind of expensive perfume and onyx are also found there.) ");
INSERT INTO engerv_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","The name of the second river was Gihon. This river flowed around the whole land of Cush. ");
INSERT INTO engerv_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","The name of the third river was Tigris. This river flowed east of Assyria. The fourth river was the Euphrates. ");
INSERT INTO engerv_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","The LORD God put the man in the Garden of Eden to work the soil and take care of the garden. ");
INSERT INTO engerv_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","The LORD God gave him this command: “You may eat from any tree in the garden. ");
INSERT INTO engerv_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","But you must not eat from the tree that gives knowledge about good and evil. If you eat fruit from that tree, on that day you will certainly die!” ");
INSERT INTO engerv_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Then the LORD God said, “I see that it is not good for the man to be alone. I will make the companion he needs, one just right for him.” ");
INSERT INTO engerv_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","The LORD God used dust from the ground and made every animal in the fields and every bird in the air. He brought all these animals to the man, and the man gave them all a name. ");
INSERT INTO engerv_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","The man gave names to all the tame animals, to all the birds in the air, and to all the wild animals. He saw many animals and birds, but he could not find a companion that was right for him. ");
INSERT INTO engerv_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","So the LORD God caused the man to sleep very deeply. While he was asleep, God took one of the ribs from the man’s body. Then he closed the man’s skin where the rib had been. ");
INSERT INTO engerv_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","The LORD God used the rib from the man to make a woman. Then he brought the woman to the man. ");
INSERT INTO engerv_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","And the man said, “Finally! One like me, with bones from my bones and a body from my body. She was taken out of a man, so I will call her ‘woman.’” ");
INSERT INTO engerv_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","That is why a man leaves his father and mother and is joined to his wife. In this way two people become one. ");
INSERT INTO engerv_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","The man and his wife were naked, but they were not ashamed. ");
INSERT INTO engerv_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","The snake was the most clever of all the wild animals that the LORD God had made. The snake spoke to the woman and said, “Woman, did God really tell you that you must not eat from any tree in the garden?” ");
INSERT INTO engerv_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","The woman answered the snake, “No, we can eat fruit from the trees in the garden. ");
INSERT INTO engerv_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","But there is one tree we must not eat from. God told us, ‘You must not eat fruit from the tree that is in the middle of the garden. You must not even touch that tree, or you will die.’” ");
INSERT INTO engerv_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","But the snake said to the woman, “You will not die. ");
INSERT INTO engerv_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God knows that if you eat the fruit from that tree you will learn about good and evil, and then you will be like God!” ");
INSERT INTO engerv_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","The woman could see that the tree was beautiful and the fruit looked so good to eat. She also liked the idea that it would make her wise. So she took some of the fruit from the tree and ate it. Her husband was there with her, so she gave him some of the fruit, and he ate it. ");
INSERT INTO engerv_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Then it was as if their eyes opened, and they saw things differently. They saw that they were naked. So they got some fig leaves, sewed them together, and wore them for clothes. ");
INSERT INTO engerv_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","During the cool part of the day, the LORD God was walking in the garden. The man and the woman heard him, and they hid among the trees in the garden. ");
INSERT INTO engerv_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","The LORD God called to the man and said, “Where are you?” ");
INSERT INTO engerv_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","The man said, “I heard you walking in the garden, and I was afraid. I was naked, so I hid.” ");
INSERT INTO engerv_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God said to the man, “Who told you that you were naked? Did you eat fruit from that special tree? I told you not to eat from that tree!” ");
INSERT INTO engerv_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","The man said, “The woman you put here with me gave me fruit from that tree. So I ate it.” ");
INSERT INTO engerv_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Then the LORD God said to the woman, “What have you done?” She said, “The snake tricked me, so I ate the fruit.” ");
INSERT INTO engerv_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","So the LORD God said to the snake, “You did this very bad thing, so bad things will happen to you. It will be worse for you than for any other animal. You must crawl on your belly and eat dust all the days of your life. ");
INSERT INTO engerv_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","I will make you and the woman enemies to each other. Your children and her children will be enemies. You will bite her child’s foot, but he will crush your head.” ");
INSERT INTO engerv_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Then God said to the woman, “I will cause you to have much trouble when you are pregnant. And when you give birth to children, you will have much pain. You will want your husband very much, but he will rule over you.” ");
INSERT INTO engerv_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Then God said to the man, “I commanded you not to eat from that tree. But you listened to your wife and ate from it. So I will curse the ground because of you. You will have to work hard all your life for the food the ground produces. ");
INSERT INTO engerv_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","The ground will grow thorns and weeds for you. And you will have to eat the plants that grow wild in the fields. ");
INSERT INTO engerv_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","You will work hard for your food, until your face is covered with sweat. You will work hard until the day you die, and then you will become dust again. I used dust to make you, and when you die, you will become dust again.” ");
INSERT INTO engerv_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam named his wife Eve. He gave her this name because Eve would be the mother of everyone who ever lived. ");
INSERT INTO engerv_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","The LORD God used animal skins and made some clothes for the man and his wife. Then he put the clothes on them. ");
INSERT INTO engerv_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","The LORD God said, “Look, the man has become like us—he knows about good and evil. And now the man might take the fruit from the tree of life. If the man eats that fruit, he will live forever.” ");
INSERT INTO engerv_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","So the LORD God forced the man out of the Garden of Eden to work the ground he was made from. ");
INSERT INTO engerv_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","God forced the man to leave the garden. Then he put Cherub angels and a sword of fire at the entrance to the garden to protect it. The sword flashed around and around, guarding the way to the tree of life. ");
INSERT INTO engerv_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam had sexual relations with his wife Eve. She became pregnant and gave birth to a son. She named him Cain. Eve said, “With the LORD’S help, I have made a man!” ");
INSERT INTO engerv_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Eve gave birth again to Cain’s brother Abel. Abel became a shepherd, and Cain became a farmer. ");
INSERT INTO engerv_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","At harvest time, Cain brought a gift to the LORD. He brought some of the food that he grew from the ground, but Abel brought some animals from his flock. He chose some of his best sheep and brought the best parts from them. The LORD accepted Abel and his gift. ");
INSERT INTO engerv_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","But he did not accept Cain and his offering. Cain was sad because of this, and he became very angry. ");
INSERT INTO engerv_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","The LORD asked Cain, “Why are you angry? Why does your face look sad? ");
INSERT INTO engerv_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","You know that if you do what is right, I will accept you. But if you don’t, sin is ready to attack you. That sin will want to control you, but you must control it.” ");
INSERT INTO engerv_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain said to his brother Abel, “Let’s go out to the field.” So they went to the field. Then Cain attacked his brother Abel and killed him. ");
INSERT INTO engerv_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Later, the LORD said to Cain, “Where is your brother Abel?” Cain answered, “I don’t know. Is it my job to watch over my brother?” ");
INSERT INTO engerv_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","11","Then the Lord said, “What have you done? You killed your brother and the ground opened up to take his blood from your hands. Now his blood is shouting to me from the ground. So you will be cursed from this ground. ");
INSERT INTO engerv_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Now when you work the soil, the ground will not help your plants grow. You will not have a home in this land. You will wander from place to place.” ");
INSERT INTO engerv_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Then Cain said to the LORD, “This punishment is more than I can bear! ");
INSERT INTO engerv_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","You are forcing me to leave the land, and I will not be able to be near you or have a home! Now I must wander from place to place, and anyone I meet could kill me.” ");
INSERT INTO engerv_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Then the LORD said to Cain, “No, if anyone kills you, I will punish that person much, much more.” Then the LORD put a mark on Cain to show that no one should kill him. ");
INSERT INTO engerv_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Cain went away from the LORD and lived in the land of Nod. ");
INSERT INTO engerv_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain had sexual relations with his wife. She became pregnant and gave birth to a son named Enoch. Cain built a city and gave the city the same name as his son Enoch. ");
INSERT INTO engerv_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch had a son named Irad. Irad had a son named Mehujael. Mehujael had a son named Methushael. And Methushael had a son named Lamech. ");
INSERT INTO engerv_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech married two women. One wife was named Adah, and the other was named Zillah. ");
INSERT INTO engerv_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah gave birth to Jabal. Jabal was the father of people who live in tents and earn their living by keeping cattle. ");
INSERT INTO engerv_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal was Jubal’s brother. Jubal was the father of people who play the harp and flute. ");
INSERT INTO engerv_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah gave birth to Tubal-Cain. Tubal-Cain was the father of people who work with bronze and iron. The sister of Tubal-Cain was named Naamah. ");
INSERT INTO engerv_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamech said to his wives, “Adah and Zillah, hear my voice! You wives of Lamech, listen to me. A man hurt me, so I killed him. I even killed a child for hitting me. ");
INSERT INTO engerv_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","The punishment for killing Cain was very bad. But the punishment for killing me will be many times worse!” ");
INSERT INTO engerv_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam again had sexual relations with his wife, and she gave birth to another son. She named him Seth. Eve said, “God has given me another son. Cain killed Abel, but now I have Seth.” ");
INSERT INTO engerv_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth also had a son. He named him Enosh. At that time people began to pray to the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","This is the history of Adam’s family. When God created people, he made them like himself. ");
INSERT INTO engerv_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","He created them male and female. And on the same day he made them, he blessed them and called them “humans.” ");
INSERT INTO engerv_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","After Adam was 130 years old, he had another son. This son looked just like Adam. Adam named his son Seth. ");
INSERT INTO engerv_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","After Seth was born, Adam lived 800 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","So Adam lived a total of 930 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","After Seth was 105 years old, he had a son named Enosh. ");
INSERT INTO engerv_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","After Enosh was born, Seth lived 807 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","So Seth lived a total of 912 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","After Enosh was 90 years old, he had a son named Kenan. ");
INSERT INTO engerv_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","After Kenan was born, Enosh lived 815 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","So Enosh lived a total of 905 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","After Kenan was 70 years old, he had a son named Mahalalel. ");
INSERT INTO engerv_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","After Mahalalel was born, Kenan lived 840 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","So Kenan lived a total of 910 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","When Mahalalel was 65 years old, he had a son named Jared. ");
INSERT INTO engerv_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","After Jared was born, Mahalalel lived 830 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","So Mahalalel lived a total of 895 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","After Jared was 162 years old, he had a son named Enoch. ");
INSERT INTO engerv_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","After Enoch was born, Jared lived 800 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","So Jared lived a total of 962 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","After Enoch was 65 years old, he had a son named Methuselah. ");
INSERT INTO engerv_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","After Methuselah was born, Enoch walked with God for 300 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","So Enoch lived a total of 365 years. ");
INSERT INTO engerv_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","One day Enoch was walking with God, and he disappeared. God took him. ");
INSERT INTO engerv_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","After Methuselah was 187 years old, he had a son named Lamech. ");
INSERT INTO engerv_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","After Lamech was born, Methuselah lived 782 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","So Methuselah lived a total of 969 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","When Lamech was 182 years old, he had a son. ");
INSERT INTO engerv_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamech named his son Noah. Lamech said, “We work very hard as farmers because God cursed the ground. But Noah will bring us rest.” ");
INSERT INTO engerv_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","After Noah was born, Lamech lived 595 years and had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","So Lamech lived a total of 777 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","After Noah was 500 years old, he had sons named Shem, Ham, and Japheth. ");
INSERT INTO engerv_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","4","The number of people on earth continued to increase. When these people had daughters, the sons of God saw how beautiful they were. So they chose the women they wanted. They married them, and the women had their children. Then the LORD said, “People are only human. I will not let my Spirit be troubled by them forever. I will let them live only 120 years.” During this time and also later, the Nephilim people lived in the land. They have been famous as powerful soldiers since ancient times. ");
INSERT INTO engerv_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","The LORD saw that the people on the earth were very evil. He saw that they thought only about evil things all the time. ");
INSERT INTO engerv_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","The LORD was sorry that he had made people on the earth. It made him very sad in his heart. ");
INSERT INTO engerv_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","So the LORD said, “I will destroy all the people I created on the earth. I will destroy every person and every animal and everything that crawls on the earth. And I will destroy all the birds in the air, because I am sorry that I have made them.” ");
INSERT INTO engerv_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","But Noah pleased the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","This is the history of Noah’s family. He was a good man all his life, and he always followed God. ");
INSERT INTO engerv_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah had three sons: Shem, Ham, and Japheth. ");
INSERT INTO engerv_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","When God looked at the earth, he saw that people had ruined it. Violence was everywhere, and it had ruined their life on earth. ");
INSERT INTO engerv_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","So God said to Noah, “Everyone has filled the earth with anger and violence. So I will destroy all living things. I will remove them from the earth. ");
INSERT INTO engerv_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Use cypress wood and build a boat for yourself. Make rooms in the boat and cover it with tar inside and out. ");
INSERT INTO engerv_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“This is the size I want you to make the boat: 300 cubits long, 50 cubits wide, and 30 cubits high. ");
INSERT INTO engerv_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Make a window for the boat about 1 cubit below the roof. Put a door in the side of the boat. Make three floors in the boat: a top deck, a middle deck, and a lower deck. ");
INSERT INTO engerv_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Understand what I am telling you. I will bring a great flood of water on the earth. I will destroy all living things that live under heaven. Everything on the earth will die. ");
INSERT INTO engerv_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","I will make a special agreement with you. You, your wife, your sons, and their wives will all go into the boat. ");
INSERT INTO engerv_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Also, you will take two of every living thing on the earth with you into the boat. Take a male and female of every kind of animal so that they might survive with you. ");
INSERT INTO engerv_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Two of every kind of bird, animal, and creeping thing will come to you so that you might keep them alive. ");
INSERT INTO engerv_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Also bring every kind of food into the boat, for you and for the animals.” ");
INSERT INTO engerv_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noah did everything God commanded him. ");
INSERT INTO engerv_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Then the LORD said to Noah, “I have seen that you are a good man, even among the evil people of this time. So gather your family, and all of you go into the boat. ");
INSERT INTO engerv_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Get seven pairs (seven males and seven females) of every kind of clean animal. And get one pair (one male and one female) of every other animal on the earth. Lead all these animals into the boat with you. ");
INSERT INTO engerv_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Get seven pairs (seven males and seven females) of all the birds. This will allow all these animals to continue living on the earth after the other animals are destroyed. ");
INSERT INTO engerv_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Seven days from now, I will send much rain on the earth. It will rain for 40 days and 40 nights, and I will wipe everything off the face of the earth. I will destroy everything I made.” ");
INSERT INTO engerv_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noah did everything the LORD told him to do. ");
INSERT INTO engerv_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noah was 600 years old at the time the rains came. ");
INSERT INTO engerv_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","He and his family went into the boat to be saved from the flood. His wife and his sons and their wives were on the boat with him. ");
INSERT INTO engerv_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","All the clean animals, all the other animals on the earth, the birds, and everything that crawls on the earth ");
INSERT INTO engerv_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","went into the boat with Noah. These animals went into the boat in groups of two, male and female, just as God commanded. ");
INSERT INTO engerv_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Seven days later the flood started. The rain began to fall on the earth. ");
INSERT INTO engerv_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","On the 17th day of the second month, when Noah was 600 years old, the springs under the earth broke through the ground, and water flowed out everywhere. The sky also opened like windows and rain poured down. The rain fell on the earth for 40 days and 40 nights. That same day Noah went into the boat with his wife, his sons Shem, Ham, and Japheth, and their wives. ");
INSERT INTO engerv_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","They and every kind of animal on the earth were in the boat. Every kind of cattle, every kind of animal that crawls on the earth, and every kind of bird were in the boat. ");
INSERT INTO engerv_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","All these animals went into the boat with Noah. They came in groups of two from every kind of animal that had the breath of life. ");
INSERT INTO engerv_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","All these animals went into the boat in groups of two, just as God had commanded Noah. Then the LORD closed the door behind Noah. ");
INSERT INTO engerv_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Water flooded the earth for 40 days. The water began rising and lifted the boat off the ground. ");
INSERT INTO engerv_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","The water continued to rise, and the boat floated on the water high above the earth. ");
INSERT INTO engerv_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","The water rose so much that even the highest mountains were covered by the water. ");
INSERT INTO engerv_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","The water continued to rise above the mountains. The water was more than 20 feet above the highest mountain. ");
INSERT INTO engerv_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Every living thing on earth died—every man and woman, every bird, and every kind of animal. All the many kinds of animals and all the things that crawl on the ground died. Every living, breathing thing on dry land died. ");
INSERT INTO engerv_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","In this way God wiped the earth clean—he destroyed every living thing on the earth—every human, every animal, everything that crawls, and every bird. All that was left was Noah and his family and the animals that were with him in the boat. ");
INSERT INTO engerv_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","The water continued to cover the earth for 150 days. ");
INSERT INTO engerv_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","But God did not forget about Noah. God remembered him and all the animals that were with him in the boat. God made a wind blow over the earth, and all the water began to disappear. ");
INSERT INTO engerv_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Rain stopped falling from the sky, and water stopped flowing from under the earth. ");
INSERT INTO engerv_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","The water that covered the earth began to go down. After 150 days the water was low enough that the boat touched land again. The boat stopped on one of the mountains of Ararat. This was the 17th day of the seventh month. ");
INSERT INTO engerv_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","The water continued to go down, and by the first day of the tenth month, the tops of the mountains were above the water. ");
INSERT INTO engerv_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Forty days later Noah opened the window he had made in the boat. ");
INSERT INTO engerv_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Then he sent out a raven. The raven flew from place to place until the ground was dry and the water was gone. ");
INSERT INTO engerv_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noah also sent out a dove. He wanted it to find dry ground. He wanted to know if water still covered the earth. ");
INSERT INTO engerv_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","The dove could not find a place to rest because water still covered the earth, so the dove came back to the boat. Noah reached out his hand and caught the dove and brought it back into the boat. ");
INSERT INTO engerv_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","After seven days Noah again sent out the dove. ");
INSERT INTO engerv_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","And that afternoon the dove came back to Noah. The dove had a fresh olive leaf in its mouth. This was a sign to show Noah that there was dry ground on the earth. ");
INSERT INTO engerv_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Seven days later Noah sent the dove out again. But this time the dove didn’t come back. ");
INSERT INTO engerv_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","After that Noah opened the door of the boat. He looked and saw that the ground was dry. This was the first day of the first month of the year. He was 601 years old. ");
INSERT INTO engerv_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","By the 27th day of the second month, the ground was completely dry. ");
INSERT INTO engerv_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Then God said to Noah, ");
INSERT INTO engerv_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Leave the boat. You, your wife, your sons, and your sons’ wives should go out now. ");
INSERT INTO engerv_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bring every living animal out of the boat with you—all the birds, animals, and everything that crawls on the earth. These animals will make many more animals, and they will fill the earth again.” ");
INSERT INTO engerv_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","So Noah went out with his sons, his wife, and his sons’ wives. ");
INSERT INTO engerv_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","All the animals, everything that crawls, and every bird left the boat. All the animals came out of the boat in family groups. ");
INSERT INTO engerv_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Then Noah built an altar to honor the LORD. Noah took some of all the clean birds and some of all the clean animals and burned them on the altar as a gift to God. ");
INSERT INTO engerv_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","The LORD smelled these sacrifices, and it pleased him. The LORD said to himself, “I will never again curse the earth as a way to punish people. People are evil from the time they are young, but I will never again destroy every living thing on the earth as I did this time. ");
INSERT INTO engerv_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","As long as the earth continues, there will always be a time for planting and a time for harvest. There will always be cold and hot, summer and winter, day and night on earth.” ");
INSERT INTO engerv_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God blessed Noah and his sons and said to them, “Have many children. Fill the earth with your people. ");
INSERT INTO engerv_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Every animal on earth, every bird in the air, every animal that crawls on the ground, and every fish in the sea will be afraid of you. All of them will be under your control. ");
INSERT INTO engerv_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","In the past, I gave you the green plants to eat. Now every animal will also be food for you. I give you everything on earth—it is yours. ");
INSERT INTO engerv_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","But I give you one command. You must not eat meat that still has its life (blood) in it. ");
INSERT INTO engerv_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Also, I will demand your blood for your lives. That is, I will demand the life of any person or animal that takes a human life. ");
INSERT INTO engerv_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“God made humans to be like himself. So whoever kills a person must be killed by another person. ");
INSERT INTO engerv_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Have many children and fill the earth with your people.” ");
INSERT INTO engerv_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Then God said to Noah and his sons, ");
INSERT INTO engerv_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“I now make my promise to you and to your people who will live after you. ");
INSERT INTO engerv_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","I make my promise to all the birds, and to all the cattle, and to all the animals that came out of the boat with you. I make my promise to every living thing on earth. ");
INSERT INTO engerv_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","This is my promise to you: All life on the earth was destroyed by the flood. But that will never happen again. A flood will never again destroy all life on the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","And God said, “I will give you something to prove that I made this promise to you. It will continue forever to show that I have made an agreement with you and every living thing on earth. ");
INSERT INTO engerv_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","I am putting a rainbow in the clouds as proof of the agreement between me and the earth. ");
INSERT INTO engerv_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","When I bring clouds over the earth, you will see the rainbow in the clouds. ");
INSERT INTO engerv_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","When I see this rainbow, I will remember the agreement between me and you and every living thing on the earth. This agreement says that a flood will never again destroy all life on the earth. ");
INSERT INTO engerv_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","When I look and see the rainbow in the clouds, I will remember the agreement that continues forever. I will remember the agreement between me and every living thing on the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","So God said to Noah, “This rainbow is proof of the agreement that I made with all living things on earth.” ");
INSERT INTO engerv_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noah’s sons came out of the boat with him. Their names were Shem, Ham, and Japheth. (Ham was the father of Canaan.) ");
INSERT INTO engerv_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","These three men were Noah’s sons. And all the people on earth came from these three sons. ");
INSERT INTO engerv_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah became a farmer and planted a vineyard. ");
INSERT INTO engerv_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","One day Noah made some wine. He got drunk, went into his tent, and took off all his clothes. ");
INSERT INTO engerv_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, the father of Canaan, saw that his father was naked and told his brothers who were outside the tent. ");
INSERT INTO engerv_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shem and Japheth took a robe, put it across their shoulders, and walked backward into the tent. Then they covered their father without looking at him. ");
INSERT INTO engerv_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Later, Noah woke up. (He was sleeping because of the wine.) When he learned what his youngest son Ham had done to him, ");
INSERT INTO engerv_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","he said, “May there be a curse on Canaan! May he be a slave to his brothers.” ");
INSERT INTO engerv_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noah also said, “May the LORD, the God of Shem, be praised! May Canaan be Shem’s slave. ");
INSERT INTO engerv_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","May God give more land to Japheth. May God live in Shem’s tents, and may Canaan be their slave.” ");
INSERT INTO engerv_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","After the flood Noah lived 350 years. ");
INSERT INTO engerv_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","He lived a total of 950 years; then he died. ");
INSERT INTO engerv_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","This is the history of the families of Shem, Ham, and Japheth. They are Noah’s sons. These men had children after the flood. ");
INSERT INTO engerv_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth’s sons were Gomer, Magog, Madai, Javan, Tubal, Meshech, and Tiras. ");
INSERT INTO engerv_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer’s sons were Ashkenaz, Riphath, and Togarmah. ");
INSERT INTO engerv_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan’s sons were Elishah, Tarshish, Kittim, and Dodanim. ");
INSERT INTO engerv_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","All the people who lived in the area around the Mediterranean Sea came from these sons of Japheth. The people separated and went to different countries according to languages, families, and nations. ");
INSERT INTO engerv_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham’s sons were Cush, Mizraim, Put, and Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cush’s sons were Seba, Havilah, Sabtah, Raamah, and Sabteca. Raamah’s sons were Sheba and Dedan. ");
INSERT INTO engerv_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush also had a son named Nimrod who became a very powerful man on earth. ");
INSERT INTO engerv_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","He was a great hunter before the LORD. That is why people compare other men to him and say, “That man is like Nimrod, a great hunter before the LORD.” ");
INSERT INTO engerv_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod’s kingdom spread from Babylon to Erech, to Akkad, and then to Calneh in the land of Babylonia. ");
INSERT INTO engerv_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrod also went into Assyria. In Assyria, Nimrod built the cities of Nineveh, Rehoboth Ir, Calah, and ");
INSERT INTO engerv_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resen. (Resen is the city between Nineveh and Calah, the big city.) ");
INSERT INTO engerv_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim was the father of the people of Lud, Anam, Lehab, Naphtuh, ");
INSERT INTO engerv_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus, Casluh, and Caphtor. (The Philistine people came from Casluh.) ");
INSERT INTO engerv_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan was the father of Sidon. Sidon was Canaan’s first son. Canaan was also the father of the Hittites, ");
INSERT INTO engerv_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusites, Amorites, Girgashites, ");
INSERT INTO engerv_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivites, Arkites, the Sinites, ");
INSERT INTO engerv_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadites, Zemarites, and Hamathites. The families of Canaan spread to different parts of the world. ");
INSERT INTO engerv_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","The land where the Canaanites lived went from Sidon down along the coast to Gerar and from Gaza as far east as Sodom and Gomorrah and from Admah and Zeboiim as far north as Laish. ");
INSERT INTO engerv_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","All these people were descendants of Ham. They are arranged by families, languages, countries, and nations. ");
INSERT INTO engerv_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem was Japheth’s older brother. One of Shem’s descendants was Eber, the father of all the Hebrew people. ");
INSERT INTO engerv_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem’s sons were Elam, Asshur, Arphaxad, Lud, and Aram. ");
INSERT INTO engerv_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram’s sons were Uz, Hul, Gether, and Mash. ");
INSERT INTO engerv_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad was the father of Shelah. Shelah was the father of Eber. ");
INSERT INTO engerv_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber was the father of two sons. One son was named Peleg. He was given this name because the earth was divided during his life. The other son was named Joktan. ");
INSERT INTO engerv_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan was the father of Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO engerv_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO engerv_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO engerv_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, and Jobab. All these people were Joktan’s sons. ");
INSERT INTO engerv_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","They lived in the area between Mesha and the hill country in the East. Mesha was toward the country of Sephar. ");
INSERT INTO engerv_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","These are the people from the family of Shem. They are arranged by families, languages, countries, and nations. ");
INSERT INTO engerv_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","This is the list of the families from Noah’s sons. They are arranged according to their nations. From these families came all the people who spread across the earth after the flood. ");
INSERT INTO engerv_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","There was a time when the whole world spoke one language. Everyone used the same words. ");
INSERT INTO engerv_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Then people began to move from the East. They found a plain in the land of Babylonia and stayed there to live. ");
INSERT INTO engerv_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Then they said to each other, “Let’s make some bricks of clay and bake them in the fire.” Then they used these bricks as stones, and they used tar as mortar. ");
INSERT INTO engerv_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Then the people said, “Let’s build ourselves a city and a tower that will reach to the sky. Then we will be famous. This will keep us together so that we will not be scattered all over the earth.” ");
INSERT INTO engerv_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Then the LORD came down to see the city and the tower. ");
INSERT INTO engerv_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","The LORD said, “These people all speak the same language. And I see that they are joined together to do this work. This is only the beginning of what they can do. Soon they will be able to do anything they want. ");
INSERT INTO engerv_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Let’s go down and confuse their language. Then they will not understand each other.” ");
INSERT INTO engerv_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","So people stopped building the city, and the LORD scattered them all over the earth. ");
INSERT INTO engerv_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","That is the place where the LORD confused the language of the whole world. That is why it is called Babel. And it was from there that the LORD caused the people to spread out to all the other places on earth. ");
INSERT INTO engerv_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","This is the history of Shem’s family. Two years after the flood, when Shem was 100 years old, his son Arphaxad was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","After that Shem lived 500 years. He had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","When Arphaxad was 35 years old, his son Shelah was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","After Shelah was born, Arphaxad lived 403 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","After Shelah was 30 years old, his son Eber was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","After Eber was born, Shelah lived 403 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","After Eber was 34 years old, his son Peleg was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","After Peleg was born, Eber lived another 430 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","After Peleg was 30 years old, his son Reu was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","After Reu was born, Peleg lived another 209 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","After Reu was 32 years old, his son Serug was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","After Serug was born, Reu lived another 207 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","After Serug was 30 years old, his son Nahor was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","After Nahor was born, Serug lived another 200 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","After Nahor was 29 years old, his son Terah was born. ");
INSERT INTO engerv_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","After Terah was born, Nahor lived another 119 years. During that time he had other sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","After Terah was 70 years old, his sons Abram, Nahor, and Haran were born. ");
INSERT INTO engerv_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","This is the history of Terah’s family. Terah was the father of Abram, Nahor, and Haran. Haran was the father of Lot. ");
INSERT INTO engerv_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran died in his hometown, Ur of Babylonia, while his father Terah was still alive. ");
INSERT INTO engerv_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram and Nahor both married. Abram’s wife was named Sarai. Nahor’s wife was named Milcah. Milcah was the daughter of Haran. Haran was the father of Milcah and Iscah. ");
INSERT INTO engerv_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai did not have any children because she was not able to have children. ");
INSERT INTO engerv_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah took his family and left Ur of Babylonia. They planned to travel to Canaan. Terah took his son Abram, his grandson Lot (Haran’s son), and his daughter-in-law Sarai (Abram’s wife). They traveled to the city of Haran and decided to stay there. ");
INSERT INTO engerv_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah lived to be 205 years old. He died in Haran. ");
INSERT INTO engerv_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","The LORD said to Abram, “Leave your country and your people. Leave your father’s family and go to the country that I will show you. ");
INSERT INTO engerv_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","I will build a great nation from you. I will bless you and make your name famous. People will use your name to bless other people. ");
INSERT INTO engerv_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","I will bless those who bless you, and I will curse those who curse you. I will use you to bless all the people on earth.” ");
INSERT INTO engerv_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","So Abram left Haran just like the LORD said, and Lot went with him. Abram was 75 years old when he left Haran. ");
INSERT INTO engerv_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","He took his wife Sarai, his nephew Lot, all the slaves, and all the other things he had gotten in Haran. Then he and his group moved to the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram traveled through the land as far as the town of Shechem and then to the big tree at Moreh. The Canaanites were living in the land at that time. ");
INSERT INTO engerv_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","The LORD appeared to Abram and said, “I will give this land to your descendants.” Abram built an altar to honor the LORD who appeared to him there. ");
INSERT INTO engerv_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Then he left that place and traveled to the mountains east of Bethel. He set up his tent there. Bethel was to the west, and Ai was to the east. Abram built another altar at that place to honor the LORD, and he worshiped the LORD there. ");
INSERT INTO engerv_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Then he moved on toward the Negev, stopping for a time at several places on the way. ");
INSERT INTO engerv_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","During this time there was not enough food in the land, so Abram went down to Egypt to live. ");
INSERT INTO engerv_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Just before they arrived in Egypt, Abram told Sarai, “Look, I know that you are a very beautiful woman. ");
INSERT INTO engerv_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","When the Egyptian men see you, they will say, ‘This woman is his wife.’ Then they will kill me and keep you alive because they want you. ");
INSERT INTO engerv_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So tell them that you are my sister. Then they will be good to me because of you. In this way you will save my life.” ");
INSERT INTO engerv_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","So when Abram went into Egypt, the Egyptian men saw that Sarai was a very beautiful woman. ");
INSERT INTO engerv_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Even some of Pharaoh’s officials noticed her and told Pharaoh how beautiful she was. So they took her to Pharaoh’s house. ");
INSERT INTO engerv_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pharaoh was kind to Abram because he thought Abram was Sarai’s brother. He gave Abram sheep, cattle, donkeys, camels, and men and women servants. ");
INSERT INTO engerv_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pharaoh took Abram’s wife, so the LORD caused Pharaoh and all the people in his house to have very bad diseases. ");
INSERT INTO engerv_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pharaoh called Abram and said to him, “You have done a very bad thing to me! Why didn’t you tell me Sarai was your wife? ");
INSERT INTO engerv_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","You said, ‘She is my sister.’ Why did you say that? I took her so that she could be my wife, but now I give your wife back to you. Take her and go!” ");
INSERT INTO engerv_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Then Pharaoh commanded his men to lead Abram out of Egypt. So Abram and his wife left that place and took everything they had with them. ");
INSERT INTO engerv_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","So Abram left Egypt. He traveled through the Negev with his wife and everything he owned. Lot was also with them. ");
INSERT INTO engerv_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","At this time Abram was very rich. He had many animals and much silver and gold. ");
INSERT INTO engerv_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram continued traveling around. He left the Negev and went back to Bethel. He went to the place between the city of Bethel and Ai, where he and his family had camped before. ");
INSERT INTO engerv_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","This was where Abram had built an altar earlier. So he worshiped the LORD there. ");
INSERT INTO engerv_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","During this time Lot was also traveling with Abram. Lot had many animals and tents. ");
INSERT INTO engerv_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abram and Lot had so many animals that the land could not support both of them together. ");
INSERT INTO engerv_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","(The Canaanites and the Perizzites were also living in this land at the same time.) The shepherds of Abram and Lot began to argue. ");
INSERT INTO engerv_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","So Abram said to Lot, “There should be no arguing between you and me or between your people and my people. We are all brothers. ");
INSERT INTO engerv_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","We should separate. You can choose any place you want. If you go to the left, I will go to the right. If you go to the right, I will go to the left.” ");
INSERT INTO engerv_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot looked and saw the whole Jordan Valley. He saw that there was much water there. (This was before the LORD destroyed Sodom and Gomorrah. At that time the Jordan Valley all the way to Zoar was like the LORD’S Garden. This was good land, like the land of Egypt.) ");
INSERT INTO engerv_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","So Lot chose to live in the Jordan Valley. The two men separated, and Lot began traveling east. ");
INSERT INTO engerv_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram stayed in the land of Canaan, and Lot lived among the cities in the valley. Lot moved as far as Sodom and made his camp there. ");
INSERT INTO engerv_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","The LORD knew that the people of Sodom were very evil sinners. ");
INSERT INTO engerv_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","After Lot left, the LORD said to Abram, “Look around you. Look north, south, east, west. ");
INSERT INTO engerv_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","All this land that you see I will give to you and your people who live after you. This will be your land forever. ");
INSERT INTO engerv_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","I will make your people so many that they will be like the dust of the earth. If people could count all the particles of dust on earth, they could count your people. ");
INSERT INTO engerv_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","So go. Walk through your land. I now give it to you.” ");
INSERT INTO engerv_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So Abram moved his tents. He went to live near the big trees of Mamre. This was near the city of Hebron. There he built an altar to honor the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Amraphel was the king of Babylonia, Arioch was the king of Ellasar, Kedorlaomer was the king of Elam, and Tidal was the king of Goiim. ");
INSERT INTO engerv_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","All these kings fought a war against King Bera of Sodom: King Birsha of Gomorrah, King Shinab of Admah, King Shemeber of Zeboiim, and the king of Bela. (Bela is also called Zoar.) ");
INSERT INTO engerv_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","All these kings joined their armies in the Valley of Siddim. (The Valley of Siddim is now the Salt Sea.) ");
INSERT INTO engerv_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","These kings had served Kedorlaomer for twelve years. But in the 13th year, they all rebelled against him. ");
INSERT INTO engerv_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","So in the 14th year, King Kedorlaomer and the kings with him came to fight against them. Kedorlaomer and the kings with him defeated the Rephaites in Ashteroth Karnaim. They also defeated the Zuzites in Ham. They defeated the Emites in Shaveh Kiriathaim. ");
INSERT INTO engerv_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","And they defeated the Horites who lived in the area from the hill country of Seir to El Paran. (El Paran is near the desert.) ");
INSERT INTO engerv_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Then King Kedorlaomer turned back, went to En Mishpat (that is, Kadesh), and defeated the Amalekites. He also defeated the Amorites living in Hazezon Tamar. ");
INSERT INTO engerv_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","At that time the kings of Sodom, Gomorrah, Admah, Zeboiim, and Bela (Zoar) joined together to fight against their enemies in the Valley of Siddim. ");
INSERT INTO engerv_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","They fought against King Kedorlaomer of Elam, King Tidal of Goiim, King Amraphel of Babylonia, and King Arioch of Ellasar. So there were four kings fighting against five. ");
INSERT INTO engerv_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","There were many holes filled with tar in the Valley of Siddim. When the kings of Sodom and Gomorrah and their armies ran away, some of the soldiers fell into these holes, but the others ran away to the mountains. ");
INSERT INTO engerv_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","So Kedorlaomer and his armies took everything that the people of Sodom and Gomorrah owned. They took all their food and clothing and left. ");
INSERT INTO engerv_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot, the son of Abram’s brother, was living in Sodom, and they captured him. They also took everything he owned and left. ");
INSERT INTO engerv_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","One of the men who had escaped went to Abram the Hebrew and told him what happened. Abram was camped near the trees of Mamre the Amorite. Mamre, Eshcol, and Aner had made an agreement to help each other, and they had also signed an agreement to help Abram. ");
INSERT INTO engerv_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","When Abram learned that Lot was captured, he called all of his family together. There were 318 trained soldiers. He led the men and chased the enemy all the way to the town of Dan. ");
INSERT INTO engerv_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","That night he and his men made a surprise attack against the enemy. They defeated them and chased them to Hobah, north of Damascus. ");
INSERT INTO engerv_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Then Abram brought back everything the enemy had stolen, as well as the women and servants, his nephew Lot, and everything Lot owned. ");
INSERT INTO engerv_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Then Abram went home after he defeated Kedorlaomer and the kings with him. On his way home, the king of Sodom went out to meet him in the Valley of Shaveh. (This is now called King’s Valley.) ");
INSERT INTO engerv_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchizedek, the king of Salem and a priest of God Most High, also went to meet Abram. He brought bread and wine. ");
INSERT INTO engerv_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","He blessed Abram and said, “Abram, may you be blessed by God Most High, the one who made heaven and earth. ");
INSERT INTO engerv_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","And we praise God Most High, who helped you defeat your enemies.” Abram gave Melchizedek one-tenth of everything he had taken during the battle. ");
INSERT INTO engerv_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Then the king of Sodom told Abram, “Give me my people who were captured. But you can keep everything else.” ");
INSERT INTO engerv_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","But Abram said to the king of Sodom, “I promise to the LORD, the God Most High, the one who made heaven and earth. ");
INSERT INTO engerv_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","I promise that I will not keep anything that is yours—not even a thread or a sandal strap! I don’t want you to say, ‘I made Abram rich.’ ");
INSERT INTO engerv_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","The only thing I will accept is the food that my young men have eaten, but you should give the other men their share. Take what we won in battle and give some to Aner, Eshcol, and Mamre. These men helped me in the battle.” ");
INSERT INTO engerv_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","After all these things happened, the word of the LORD came to Abram in a vision. God said, “Abram, don’t be afraid. I will defend you and give you a great reward.” ");
INSERT INTO engerv_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","But Abram said, “Lord GOD, there is nothing you can give me that will make me happy, because I have no son. My slave Eliezer from Damascus will get everything I own after I die.” ");
INSERT INTO engerv_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram said, “You have given me no son, so a slave born in my house will get everything I have.” ");
INSERT INTO engerv_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Then the LORD spoke to Abram and said, “That slave will not be the one to get what you have. You will have a son who will get everything you own.” ");
INSERT INTO engerv_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Then God led Abram outside and said, “Look at the sky. See the many stars. There are so many you cannot count them. Your family will be like that.” ");
INSERT INTO engerv_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram believed the LORD, and because of this faith the Lord accepted him as one who has done what is right. ");
INSERT INTO engerv_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","He said to Abram, “I am the LORD who led you from Ur of Babylonia. I did this so that I could give you this land. You will own this land.” ");
INSERT INTO engerv_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","But Abram said, “Lord GOD, how can I be sure that I will get this land?” ");
INSERT INTO engerv_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","God said to Abram, “We will make an agreement. Bring me a three-year-old cow, a three-year-old goat, a three-year-old ram, a dove, and a young pigeon.” ");
INSERT INTO engerv_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram brought all these to God. Abram killed these animals and cut each of them into two pieces. Then he laid each half across from the other half. He did not cut the birds into two pieces. ");
INSERT INTO engerv_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Later, large birds flew down to eat the animals, but Abram chased them away. ");
INSERT INTO engerv_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","The sun began to go down and Abram got very sleepy. While he was asleep, a very terrible darkness came over him. ");
INSERT INTO engerv_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Then the Lord said to Abram, “You should know this: Your descendants will live in a country that is not their own. They will be strangers there. The people there will make them slaves and be cruel to them for 400 years. ");
INSERT INTO engerv_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","But then I will punish the nation that made them slaves. Your people will leave that land, and they will take many good things with them. ");
INSERT INTO engerv_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“You yourself will live to be very old. You will die in peace and will be buried with your family. ");
INSERT INTO engerv_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","After four generations your people will come to this land again and defeat the Amorites. That will happen in the future because the Amorites are not yet guilty enough to lose their land.” ");
INSERT INTO engerv_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","After the sun went down, it got very dark. The dead animals were still on the ground, each animal cut into two pieces. Then a smoking firepot and a flaming torch passed between the halves of the dead animals. ");
INSERT INTO engerv_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","So on that day the LORD made a promise and an agreement with Abram. He said, “I will give this land to your descendants. I will give them the land between the River of Egypt and the great river Euphrates. ");
INSERT INTO engerv_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","This is the land of the Kenites, Kenizzites, Kadmonites, ");
INSERT INTO engerv_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hittites, Perizzites, Rephaites, ");
INSERT INTO engerv_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorites, Canaanites, Girgashites, and Jebusites.” ");
INSERT INTO engerv_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai was Abram’s wife, but she did not have any children. She had an Egyptian slave named Hagar. ");
INSERT INTO engerv_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai told Abram, “The LORD has not allowed me to have children, so sleep with my slave. Maybe she can have a son, and I will accept him as my own.” Abram did what Sarai said. ");
INSERT INTO engerv_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","So after living ten years in the land of Canaan, Sarai gave her Egyptian slave to Abram as a second wife. ");
INSERT INTO engerv_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram slept with Hagar, and she became pregnant. When Hagar realized this, she became very proud and began to feel that she was better than Sarai her owner. ");
INSERT INTO engerv_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Then Sarai said to Abram, “My slave girl now hates me, and I blame you for this. I gave her to you, and she became pregnant. Then she began to feel that she is better than I am. I want the LORD to judge which of us is right.” ");
INSERT INTO engerv_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","But Abram said to Sarai, “She is your slave. You can do anything you want to her.” So Sarai was cruel to Hagar, and Hagar ran away. ");
INSERT INTO engerv_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","The angel of the LORD found Hagar near a spring of water in the desert. The spring was by the road to Shur. ");
INSERT INTO engerv_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","The angel said, “Hagar, Sarai’s slave girl, why are you here? Where are you going?” Hagar said, “I am running away from Sarai.” ");
INSERT INTO engerv_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","The angel of the LORD said to her, “Sarai is your owner. Go home to her and obey her.” ");
INSERT INTO engerv_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","The angel of the LORD also said, “From you will come many people—too many people to count.” ");
INSERT INTO engerv_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Then the angel of the LORD said, “Hagar, you are now pregnant, and you will have a son. You will name him Ishmael, because the LORD has heard that you were treated badly. ");
INSERT INTO engerv_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ishmael will be wild and free like a wild donkey. He will be against everyone, and everyone will be against him. He will move from place to place and camp near his brothers.” ");
INSERT INTO engerv_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","The LORD talked to Hagar. She began to use a new name for God. She said to him, “You are ‘God Who Sees Me.’” She said this because she thought, “I see that even in this place God sees me and cares for me!” ");
INSERT INTO engerv_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","So the well there was called Beer Lahai Roi. It is between Kadesh and Bered. ");
INSERT INTO engerv_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar gave birth to Abram’s son, and Abram named the son Ishmael. ");
INSERT INTO engerv_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram was 86 years old when Ishmael was born from Hagar. ");
INSERT INTO engerv_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","When Abram was 99 years old, the LORD appeared to him. He said, “I am God All-Powerful. Obey me and live the right way. ");
INSERT INTO engerv_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","If you do this, I will prepare an agreement between us. I will promise to make your people a great nation.” ");
INSERT INTO engerv_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Then Abram bowed down before God. God said to him, ");
INSERT INTO engerv_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“This is my part of our agreement: I will make you the father of many nations. ");
INSERT INTO engerv_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","I will change your name from Abram to Abraham, because I am making you the father of many nations. ");
INSERT INTO engerv_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","I will give you many descendants. New nations and kings will come from you. ");
INSERT INTO engerv_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","And I will prepare an agreement between me and you. This agreement will also be for all your descendants. It will continue forever. I will be your God and the God of all your descendants. ");
INSERT INTO engerv_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","And I will give this land to you and to all your descendants. I will give you the land you are traveling through—the land of Canaan. I will give you this land forever, and I will be your God.” ");
INSERT INTO engerv_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Then God said to Abraham, “Now, this is your part of the agreement: You and all your descendants will obey my agreement. ");
INSERT INTO engerv_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","This is my agreement that all of you must obey. This is the agreement between me and you and all your descendants. Every male must be circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","You will cut the skin to show that you follow the agreement between me and you. ");
INSERT INTO engerv_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","When the baby boy is eight days old, you will circumcise him. Every boy born among your people and every boy who is a slave of your people must be circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","So every baby boy in your nation will be circumcised. Every boy who is born from your family or bought as a slave will be circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Abraham, this is the agreement between you and me: Any male who is not circumcised will be cut off from his people because he has broken my agreement.” ");
INSERT INTO engerv_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God said to Abraham, “I will give Sarai, your wife, a new name. Her new name will be Sarah. ");
INSERT INTO engerv_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","I will bless her. I will give her a son, and you will be the father. She will be the mother of many new nations. Kings of nations will come from her.” ");
INSERT INTO engerv_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham bowed his face to the ground to show he respected God. But he laughed and said to himself, “I am 100 years old. I cannot have a son, and Sarah is 90 years old. She cannot have a child.” ");
INSERT INTO engerv_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Then Abraham said to God, “I hope Ishmael will live and serve you.” ");
INSERT INTO engerv_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God said, “No, I said that your wife Sarah will have a son. You will name him Isaac. I will make my agreement with him that will continue forever with all his descendants. ");
INSERT INTO engerv_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“You mentioned Ishmael, and I heard you. I will bless him, and he will have many children. He will be the father of twelve great leaders. His family will become a great nation. ");
INSERT INTO engerv_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","But I will make my agreement with Isaac, the son who Sarah will have. He will be born at this same time next year.” ");
INSERT INTO engerv_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","After God finished talking with Abraham, God went up into heaven. ");
INSERT INTO engerv_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Then Abraham gathered together Ishmael and all the slaves born in his house. He also gathered all the slaves he had bought. Every man and boy in Abraham’s house was gathered together, and they were all circumcised. Abraham circumcised them that day, just as God had told him to do. ");
INSERT INTO engerv_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham was 99 years old when he was circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","And Ishmael, his son, was 13 years old when he was circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham and his son were circumcised on the same day. ");
INSERT INTO engerv_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Also, on that day all the men in Abraham’s house were circumcised. All the slaves born in his house and all the slaves he had bought were circumcised. ");
INSERT INTO engerv_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Later, the LORD again appeared to Abraham near the oak trees of Mamre. It was the hottest part of the day, and Abraham was sitting at the door of his tent. ");
INSERT INTO engerv_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","He looked up and saw three men standing in front of him. When he saw the men, he ran to them and bowed before them. ");
INSERT INTO engerv_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraham said, “Sirs, please stay a while with me, your servant. ");
INSERT INTO engerv_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","I will bring some water to wash your feet. You can rest under the trees. ");
INSERT INTO engerv_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","I will get some food for you, and you can eat as much as you want. Then you can continue your journey.” The three men said, “Do as you wish.” ");
INSERT INTO engerv_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham hurried to the tent. He said to Sarah, “Quickly, prepare enough flour for three loaves of bread.” ");
INSERT INTO engerv_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Then Abraham ran to his cattle. He took his best young calf and gave it to the servant there. He told the servant to quickly kill the calf and prepare it for food. ");
INSERT INTO engerv_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abraham brought the meat and some milk and cheese and set them down in front of the three men. Then he stood near the men, ready to serve them while they sat under the tree and ate. ");
INSERT INTO engerv_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Then the men said to Abraham, “Where is your wife Sarah?” Abraham said, “She is there, in the tent.” ");
INSERT INTO engerv_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Then one of them said, “I will come again in the spring. At that time your wife Sarah will have a son.” Sarah was listening in the tent and heard these things. ");
INSERT INTO engerv_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham and Sarah were very old. Sarah was past the right age for women to have children. ");
INSERT INTO engerv_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","So she laughed to herself and said, “I am old, and my husband is old. I am too old to have a baby.” ");
INSERT INTO engerv_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Then the LORD said to Abraham, “Sarah laughed and said she was too old to have a baby. ");
INSERT INTO engerv_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","But is anything too hard for the LORD? I will come again in the spring, just as I said I would, and your wife Sarah will have a son.” ");
INSERT INTO engerv_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah said, “I didn’t laugh!” (She said this because she was afraid.) Then the Lord said, “No, I know that is not true. You did laugh!” ");
INSERT INTO engerv_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Then the men got up to leave. They looked toward Sodom and began walking in that direction. Abraham walked with them to send them on their way. ");
INSERT INTO engerv_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","The LORD said to himself, “Should I tell Abraham what I am going to do now? ");
INSERT INTO engerv_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham will become a great and powerful nation, and all the nations on earth will be blessed because of him. ");
INSERT INTO engerv_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","I have made a special agreement with him. I did this so that he would command his children and his descendants to live the way the LORD wants them to. I did this so that they would live right and be fair. Then I, the LORD, can give him what I promised.” ");
INSERT INTO engerv_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Then the LORD said, “I have heard many times that the people of Sodom and Gomorrah are very evil. ");
INSERT INTO engerv_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","I will go and see if they are as bad as I have heard. Then I will know for sure.” ");
INSERT INTO engerv_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","So the men turned and started walking toward Sodom while Abraham stood there before the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Then Abraham approached him and asked, “Will you destroy the good people while you are destroying those who are evil? ");
INSERT INTO engerv_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","What if there are fifty good people in that city? Will you still destroy it? Surely you will save the city for the fifty good people living there. ");
INSERT INTO engerv_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Surely you would not destroy the city. You would not destroy fifty good people to kill those who are evil. If that happened, those who are good would be the same as those who are evil—both would be punished. As the judge of the whole world, surely you would do the right thing!” ");
INSERT INTO engerv_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Then the LORD said, “If I find fifty good people in the city of Sodom, I will save the whole city.” ");
INSERT INTO engerv_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Then Abraham said, “Compared to you, Lord, I am only dust and ashes. But let me bother you again and ask you this question. ");
INSERT INTO engerv_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","What if there are five less than fifty? Will you destroy a whole city because of just five people?” The Lord said, “If I find forty-five good people there, I will not destroy the city.” ");
INSERT INTO engerv_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham spoke again. He said, “And if you find only forty good people there, will you destroy the city?” The Lord said, “If I find forty good people, I will not destroy the city.” ");
INSERT INTO engerv_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Then Abraham said, “Lord, please don’t be angry with me, but let me ask you this. If only thirty good people are in the city, will you destroy it?” The Lord said, “If I find thirty good people there, I will not destroy the city.” ");
INSERT INTO engerv_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Then Abraham said, “Lord, may I bother you again and ask, what if there are twenty good people?” The Lord answered, “If I find twenty good people, I will not destroy the city.” ");
INSERT INTO engerv_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Then Abraham said, “Lord, please don’t be angry with me, but let me bother you this one last time. If you find ten good people there, what will you do?” The Lord said, “If I find ten good people in the city, I will not destroy it.” ");
INSERT INTO engerv_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","The LORD finished speaking to Abraham and left. Then Abraham went back home. ");
INSERT INTO engerv_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","2","That evening the two angels came to the city of Sodom. Lot was sitting near the city gates and saw them. He got up and went to them. He bowed to show respect and said, “Sirs, please come to my house, and I will serve you. There you can wash your feet and stay the night. Then tomorrow you can continue your journey.” The angels answered, “No, we will stay the night in the city square.” ");
INSERT INTO engerv_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","But Lot continued to ask them to come to his house, so they agreed and went with him. Lot gave them something to drink. He baked some bread for them, and they ate it. ");
INSERT INTO engerv_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","That evening, just before bedtime, men from every part of town came to Lot’s house. They stood around the house and called to Lot. They said, ");
INSERT INTO engerv_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","“Where are the two men who came to you tonight? Bring them out to us. We want to have sex with them.” ");
INSERT INTO engerv_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot went outside and closed the door behind him. ");
INSERT INTO engerv_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","He said to the men, “No, my friends, I beg you, please don’t do this evil thing! ");
INSERT INTO engerv_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Look, I have two daughters who have never slept with a man before. I will give my daughters to you. You can do anything you want with them. But please don’t do anything to these men. They have come to my house, and I must protect them.” ");
INSERT INTO engerv_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","The men surrounding the house answered, “Get out of our way!” They said to themselves, “This man Lot came to our city as a visitor. Now he wants to tell us how we should live!” Then the men said to Lot, “We will do worse things to you than to them.” So the men started moving closer and closer to Lot. They were about to break down the door. ");
INSERT INTO engerv_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","But the two men staying with Lot opened the door, pulled him back inside the house, and closed the door. ");
INSERT INTO engerv_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Then they did something to the men outside the door—they caused all these evil men, young and old, to become blind. So the men trying to get in the house could not find the door. ");
INSERT INTO engerv_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","The two men said to Lot, “Are there any other people from your family living in this city? Do you have any sons-in-law, sons, daughters, or any other people from your family here? If so, you should tell them to leave now. ");
INSERT INTO engerv_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","We are going to destroy this city. The LORD heard how evil this city is, so he sent us to destroy it.” ");
INSERT INTO engerv_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","So Lot went out and spoke to his sons-in-law, the men who had married his other daughters. He said, “Hurry and leave this city! The LORD will soon destroy it!” But they thought he was joking. ");
INSERT INTO engerv_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","The next morning at dawn, the angels were trying to make Lot hurry. They said, “This city will be punished, so take your wife and your two daughters who are still with you and leave this place. Then you will not be destroyed with the city.” ");
INSERT INTO engerv_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","When Lot did not move fast enough, the two men grabbed his hand. They also took the hands of his wife and his two daughters. The two men led Lot and his family safely out of the city. The LORD was kind to Lot and his family. ");
INSERT INTO engerv_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","So after the two men brought Lot and his family out of the city, one of the men said, “Now run to save your life! Don’t look back at the city, and don’t stop anywhere in the valley. Run until you are in the mountains. If you stop, you will be destroyed with the city!” ");
INSERT INTO engerv_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","But Lot said to the two men, “Sirs, please don’t force me to run so far! ");
INSERT INTO engerv_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","You have been very kind to me, your servant. You have been very kind to save me, but I cannot run all the way to the mountains. What if I am too slow and something happens? I will be killed! ");
INSERT INTO engerv_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Look, there is a very small town near here. Let me run to that town. I can run there and be safe.” ");
INSERT INTO engerv_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","The angel said to Lot, “Very well, I’ll let you do that. I will not destroy that town. ");
INSERT INTO engerv_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","But run there quickly. I cannot destroy Sodom until you are safely in that town.” (That town is named Zoar, because it is a small town.) ");
INSERT INTO engerv_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot was entering the town as the sun came up, ");
INSERT INTO engerv_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","and the LORD began to destroy Sodom and Gomorrah. He caused fire and burning sulfur to fall from the sky. ");
INSERT INTO engerv_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","He destroyed the whole valley—all the cities, the people living in the cities, and all the plants in the valley. ");
INSERT INTO engerv_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot’s wife was following behind him and looked back at the city. When she did, she became a block of salt. ");
INSERT INTO engerv_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Early the next morning, Abraham got up and went to the place where he stood before the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Abraham looked down into the valley toward the cities of Sodom and Gomorrah. He saw clouds of smoke rising from the land, like smoke from a furnace. ");
INSERT INTO engerv_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","God destroyed the cities in the valley, but he remembered what Abraham had said. So God sent Lot away from those cities before destroying them. ");
INSERT INTO engerv_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot was afraid to stay in Zoar, so he and his two daughters went to live in the mountains in a cave. ");
INSERT INTO engerv_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","One day the older daughter said to the younger, “Everywhere on the earth, men and women marry and have a family. But our father is old, and there are no men around here to give us children. ");
INSERT INTO engerv_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","So let’s get our father drunk with wine. Then we can have sex with him. That way we can use our father to keep our family alive!” ");
INSERT INTO engerv_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","That night the two girls went to their father and got him drunk with wine. Then the older daughter went and had sexual relations with him. He did not even know when she came to bed or when she got up. ");
INSERT INTO engerv_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","The next day the older daughter said to the younger daughter, “Last night I went to bed with my father. Let’s get him drunk with wine again tonight. Then you can go and have sex with him. In this way we can use our father to have children, and our family will not come to an end.” ");
INSERT INTO engerv_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","So that night the two girls got their father drunk with wine. Then the younger daughter went and had sexual relations with him. Again, Lot did not know when she came to bed or when she got up. ");
INSERT INTO engerv_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Both of Lot’s daughters became pregnant. Their father was the father of their babies. ");
INSERT INTO engerv_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","The older daughter gave birth to a son. She named him Moab. Moab is the ancestor of all the Moabites living today. ");
INSERT INTO engerv_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","The younger daughter also gave birth to a son. She named him Ben-Ammi. Ben-Ammi is the ancestor of all the Ammonites living today. ");
INSERT INTO engerv_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham left that place and traveled to the Negev. He settled in the city of Gerar, between Kadesh and Shur. While in Gerar, ");
INSERT INTO engerv_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham told people that Sarah was his sister. King Abimelech of Gerar heard this. Abimelech wanted Sarah, so he sent some servants to take her. ");
INSERT INTO engerv_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","But one night God spoke to Abimelech in a dream and said, “You will die. The woman you took is married.” ");
INSERT INTO engerv_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","But Abimelech had not yet slept with Sarah, so he said, “Lord, I am not guilty. Would you kill an innocent man? ");
INSERT INTO engerv_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham himself told me, ‘This woman is my sister,’ and she also said, ‘This man is my brother.’ I am innocent. I did not know what I was doing.” ");
INSERT INTO engerv_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Then God said to Abimelech in a dream, “Yes, I know that you are innocent and that you did not know what you were doing. I saved you. I did not allow you to sin against me. I was the one who did not allow you to sleep with her. ");
INSERT INTO engerv_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","So give Abraham his wife again. He is a prophet. He will pray for you, and you will live. But if you don’t give Sarah back to him, I promise that you will die. And all your family will die with you.” ");
INSERT INTO engerv_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","So very early the next morning, Abimelech called all his servants and told them about the dream. The servants were very afraid. ");
INSERT INTO engerv_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Then Abimelech called Abraham and said to him, “Why have you done this to us? What wrong did I do to you? Why did you lie and say that she was your sister? You brought great trouble to my kingdom. You should not have done this to me. ");
INSERT INTO engerv_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","What were you afraid of? Why did you do this to me?” ");
INSERT INTO engerv_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Then Abraham said, “I thought no one in this place respected God. I thought someone would kill me to get Sarah. ");
INSERT INTO engerv_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","She is my wife, but she is also my sister. She is the daughter of my father but not the daughter of my mother. ");
INSERT INTO engerv_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","God led me away from my father’s house. He led me to wander to many different places. When that happened, I told Sarah, ‘Do something for me. Wherever we go, tell people you are my sister.’” ");
INSERT INTO engerv_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","So Abimelech gave Sarah back to Abraham. Abimelech also gave Abraham some sheep, cattle, and slaves. ");
INSERT INTO engerv_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","And Abimelech said, “Look all around you. This is my land. You may live any place you want.” ");
INSERT INTO engerv_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelech said to Sarah, “I gave your brother Abraham 1000 pieces of silver. I did this to show that I am very sorry. I want everyone to see that I did the right thing.” ");
INSERT INTO engerv_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","The LORD made all the women in Abimelech’s family not able to have children. God did this because Abimelech had taken Sarah, Abraham’s wife. But Abraham prayed to God, and God healed Abimelech, his wife, and his servant girls. ");
INSERT INTO engerv_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","The LORD came back to visit Sarah as he said he would, and he kept his promise to her. ");
INSERT INTO engerv_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","At exactly the time God said it would happen, Sarah became pregnant and gave birth to a son for Abraham in his old age. ");
INSERT INTO engerv_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham named his son Isaac. ");
INSERT INTO engerv_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham did what God commanded and circumcised Isaac when he was eight days old. ");
INSERT INTO engerv_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham was 100 years old when his son Isaac was born. ");
INSERT INTO engerv_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah said, “God has made me happy, and everyone who hears about this will be happy with me. ");
INSERT INTO engerv_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","No one thought that I, Sarah, would be able to have Abraham’s child. But I have given Abraham a son, even though he is old.” ");
INSERT INTO engerv_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac continued to grow, and soon he was old enough to begin eating solid food. So Abraham gave a big party. ");
INSERT INTO engerv_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sarah saw Hagar’s son playing. (Hagar was the Egyptian slave woman who gave birth to Abraham’s first son.) ");
INSERT INTO engerv_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sarah said to Abraham, “Get rid of that slave woman and her son. Send them away! When we die, our son Isaac will get everything we have. I don’t want that slave woman’s son sharing these things with my son Isaac!” ");
INSERT INTO engerv_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","This upset Abraham very much. He was worried about his son Ishmael. ");
INSERT INTO engerv_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","But God said to Abraham, “Don’t worry about the boy and the slave woman. Do what Sarah wants. Your descendants will be those who come through Isaac. ");
INSERT INTO engerv_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","But I will also bless the son of your slave woman. He is your son, so I will make a great nation from his family also.” ");
INSERT INTO engerv_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Early the next morning Abraham took some food and water and gave them to Hagar. She carried them and left with her boy. She left that place and wandered in the desert of Beersheba. ");
INSERT INTO engerv_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","After some time, when all their drinking water was gone, Hagar put her son under a bush. ");
INSERT INTO engerv_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Then she walked a short distance away and sat down. She thought her son would die because there was no water. She did not want to watch him die. She sat there and began to cry. ");
INSERT INTO engerv_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God heard the boy crying, and God’s angel called to Hagar from heaven. He said, “What is wrong, Hagar? Don’t be afraid! God has heard the boy crying there. ");
INSERT INTO engerv_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Go help the boy. Hold his hand and lead him. I will make him the father of many people.” ");
INSERT INTO engerv_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Then God allowed Hagar to see a well of water. So she went to the well and filled her bag with water. Then she gave water to the boy to drink. ");
INSERT INTO engerv_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God continued to be with the boy while he grew up. Ishmael lived in the desert and became a hunter. He learned to shoot a bow very well. ");
INSERT INTO engerv_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","His mother found a wife for him in Egypt. They continued to live in the Paran desert. ");
INSERT INTO engerv_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Then Abimelech and Phicol spoke with Abraham. Phicol was the commander of Abimelech’s army. They said to Abraham, “God is with you in everything you do. ");
INSERT INTO engerv_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","So make a promise to me here before God. Promise that you will be fair with me and with my children. Promise that you will be kind to me and this country where you have lived. Promise that you will be as kind to me as I have been to you.” ");
INSERT INTO engerv_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","And Abraham said, “I promise to treat you the same way you have treated me.” ");
INSERT INTO engerv_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Then Abraham complained to Abimelech because Abimelech’s servants had captured a well of water. ");
INSERT INTO engerv_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","But Abimelech said, “I don’t know who did this. You never told me about this before today!” ");
INSERT INTO engerv_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","So Abraham and Abimelech made an agreement. Abraham gave Abimelech some sheep and cattle as proof of the agreement. ");
INSERT INTO engerv_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham also put seven female lambs in front of Abimelech. ");
INSERT INTO engerv_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech asked Abraham, “Why did you put these seven female lambs by themselves?” ");
INSERT INTO engerv_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham answered, “When you accept these lambs from me, it will be proof that I dug this well.” ");
INSERT INTO engerv_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","So after that, the well was called Beersheba. Abraham gave the well this name because it was the place where they made a promise to each other. ");
INSERT INTO engerv_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","So Abraham and Abimelech made an agreement at Beersheba. Then Abimelech and Phicol, his military commander, went back to the country of the Philistines. ");
INSERT INTO engerv_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planted a special tree at Beersheba and prayed to the LORD, the God who lives forever. ");
INSERT INTO engerv_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","And Abraham lived as a stranger for a long time in the country of the Philistines. ");
INSERT INTO engerv_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","After these things God decided to test Abraham’s faith. God said to him, “Abraham!” And he said, “Yes!” ");
INSERT INTO engerv_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Then God said, “Take your son to the land of Moriah and kill your son there as a sacrifice for me. This must be Isaac, your only son, the one you love. Use him as a burnt offering on one of the mountains there. I will tell you which mountain.” ");
INSERT INTO engerv_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","In the morning Abraham got up and saddled his donkey. He took Isaac and two servants with him. He cut the wood for the sacrifice. Then they went to the place where God told them to go. ");
INSERT INTO engerv_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","After they traveled three days, Abraham looked up, and in the distance he saw the place where they were going. ");
INSERT INTO engerv_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Then he said to his servants, “Stay here with the donkey. The boy and I will go to that place and worship. Then we will come back to you later.” ");
INSERT INTO engerv_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham took the wood for the sacrifice and put it on his son’s shoulder. Abraham took the special knife and fire. Then both he and his son went together to the place for worship. ");
INSERT INTO engerv_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac said to his father Abraham, “Father!” Abraham answered, “Yes, son?” Isaac said, “I see the wood and the fire. But where is the lamb we will burn as a sacrifice?” ");
INSERT INTO engerv_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham answered, “God himself is providing the lamb for the sacrifice, my son.” So both Abraham and his son went together to that place. ");
INSERT INTO engerv_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","When they came to the place where God told them to go, Abraham built an altar. He carefully laid the wood on the altar. Then he tied up his son Isaac and laid him on the altar on top of the wood. ");
INSERT INTO engerv_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Then Abraham reached for his knife to kill his son. ");
INSERT INTO engerv_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","But the angel of the LORD stopped him. The angel called from heaven and said, “Abraham, Abraham!” Abraham answered, “Yes?” ");
INSERT INTO engerv_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","The angel said, “Don’t kill your son or hurt him in any way. Now I can see that you do respect and obey God. I see that you are ready to kill your son, your only son, for me.” ");
INSERT INTO engerv_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Then Abraham noticed a ram whose horns were caught in a bush. So Abraham went and took the ram. He offered it, instead of his son, as a sacrifice to God. ");
INSERT INTO engerv_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","So Abraham gave that place a name, “The LORD Provides.” Even today people say, “On the mountain of the LORD, he will give us what we need.” ");
INSERT INTO engerv_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","The angel of the LORD called to Abraham from heaven a second time. ");
INSERT INTO engerv_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","The angel said, “You were ready to kill your only son for me. Since you did this for me, I make you this promise: I, the LORD, promise that ");
INSERT INTO engerv_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","I will surely bless you and give you as many descendants as the stars in the sky. There will be as many people as sand on the seashore. And your people will live in cities that they will take from their enemies. ");
INSERT INTO engerv_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Every nation on the earth will be blessed through your descendants. I will do this because you obeyed me.” ");
INSERT INTO engerv_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Then Abraham went back to his servants. They all traveled back to Beersheba, and Abraham stayed there. ");
INSERT INTO engerv_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","After all these things happened, a message was sent to Abraham. It said, “Your brother Nahor and his wife Milcah have children now. ");
INSERT INTO engerv_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","The first son is Uz. The second son is Buz. The third son is Kemuel, the father of Aram. ");
INSERT INTO engerv_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Then there are Kesed, Hazo, Pildash, Jidlaph, and Bethuel.” ");
INSERT INTO engerv_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel was the father of Rebekah. Milcah was the mother of these eight sons, and Nahor was the father. Nahor was Abraham’s brother. ");
INSERT INTO engerv_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Also Nahor had four other sons from his slave woman Reumah. The sons were Tebah, Gaham, Tahash, and Maacah. ");
INSERT INTO engerv_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah lived to be 127 years old. ");
INSERT INTO engerv_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","She died in the city of Kiriath Arba (Hebron) in the land of Canaan. Abraham was very sad and cried for her there. ");
INSERT INTO engerv_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Then he left his dead wife and went to talk to the Hittites. He said, ");
INSERT INTO engerv_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“I am only a foreigner staying in your country. I have no place to bury my wife. Please give me some land so that I can bury her.” ");
INSERT INTO engerv_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","The Hittites answered Abraham, ");
INSERT INTO engerv_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Sir, you are a great leader among us. You can have the best place we have to bury your dead. You can have any of our burying places that you want. None of us will stop you from burying your wife there.” ");
INSERT INTO engerv_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham got up and bowed to the people. ");
INSERT INTO engerv_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","He said to them, “If you really want to help me bury my dead wife, speak to Ephron the son of Zohar for me. ");
INSERT INTO engerv_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","I would like to buy the cave of Machpelah, which belongs to Ephron. It is at the end of his field. I will pay him the full price. I want all of you to be witnesses that I am buying it as a burial place.” ");
INSERT INTO engerv_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron was sitting there among the people. He answered Abraham, ");
INSERT INTO engerv_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“No, sir. Here in front of my people, I give you that land and the cave on it so that you can bury your wife.” ");
INSERT INTO engerv_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham bowed before the Hittites. ");
INSERT INTO engerv_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","He said to Ephron before all the people, “But I want to give you the full price for the field. Accept my money, and I will bury my dead.” ");
INSERT INTO engerv_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron answered Abraham, ");
INSERT INTO engerv_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Sir, listen to me. Ten pounds of silver mean nothing to you or me. Take the land and bury your dead wife.” ");
INSERT INTO engerv_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham understood that Ephron was telling him the price of the land. So Abraham paid him for the land. He weighed out ten pounds of silver for Ephron and gave it to the merchant. ");
INSERT INTO engerv_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","So the field of Ephron changed owners. This field was in Machpelah, near Mamre. Abraham became the owner of the field, the cave in it, and all the trees in the field. Everyone in the city saw the agreement between Ephron and Abraham. ");
INSERT INTO engerv_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","After this, Abraham buried his wife Sarah in the cave of that field near Mamre (Hebron) in the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Abraham bought the field and the cave in it from the Hittites. So this became his property to be used as a burial place. ");
INSERT INTO engerv_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham lived to be a very old man. The LORD blessed him and everything he did. ");
INSERT INTO engerv_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham’s oldest servant was in charge of everything he owned. Abraham called that servant to him and said, “Put your hand under my leg. ");
INSERT INTO engerv_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Now I want you to make a promise to me. Promise to me before the LORD, the God of heaven and earth, that you will not allow my son to marry a girl from Canaan. We live among these people, but don’t let him marry a Canaanite girl. ");
INSERT INTO engerv_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Go back to my country, to my own people, to find a wife for my son Isaac. Bring her here to him.” ");
INSERT INTO engerv_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","The servant said to him, “Maybe this woman will not want to come back with me to this land. If that happens, should I take your son with me to your homeland?” ");
INSERT INTO engerv_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham said to him, “No, don’t take my son to that place. ");
INSERT INTO engerv_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","The LORD, the God of heaven, brought me from my homeland to this place. That place was the home of my father and the home of my family, but he promised that this new land would belong to my family. May he send his angel before you so that you can choose a wife for my son. ");
INSERT INTO engerv_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","If the girl refuses to come with you, you will be free from this promise. But you must not take my son back to that place.” ");
INSERT INTO engerv_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","So the servant put his hand under his master’s leg and made the promise. ");
INSERT INTO engerv_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","The servant took ten of Abraham’s camels and left that place. The servant carried with him many different kinds of beautiful gifts. He went to Mesopotamia, to Nahor’s city. ");
INSERT INTO engerv_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","In the evening, when the women come out to get water, he went to the water well outside the city. He made the camels kneel down at the well. ");
INSERT INTO engerv_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","The servant said, “LORD, you are the God of my master Abraham. Please show your kindness to my master by helping me find a wife for his son Isaac. ");
INSERT INTO engerv_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Here I am, standing by this well of water, and the young women from the city are coming out to get water. ");
INSERT INTO engerv_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","I will say to one of them, ‘Please put your jar down so that I can drink.’ Let her answer show whether she is the one you have chosen for your servant Isaac. If she says, ‘Drink, and I will also give water to your camels,’ I will know that she is the right one. It will be proof that you have shown kindness to my master.” ");
INSERT INTO engerv_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Before the servant finished praying, a young woman named Rebekah came to the well. She was the daughter of Bethuel. (Bethuel was the son of Milcah and Nahor, Abraham’s brother.) Rebekah came to the well with her water jar on her shoulder. ");
INSERT INTO engerv_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","She was very pretty. She was a virgin; no man had ever had sexual relations with her. She went down to the well and filled her jar. ");
INSERT INTO engerv_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Then the servant ran to her and said, “Please give me a little water to drink from your jar.” ");
INSERT INTO engerv_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekah quickly lowered the jar from her shoulder and gave him a drink. She said, “Drink this, sir.” ");
INSERT INTO engerv_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","As soon as she finished giving him something to drink, Rebekah said, “I will also pour some water for your camels.” ");
INSERT INTO engerv_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","So Rebekah quickly poured all the water from her jar into the drinking trough for the camels. Then she ran to the well to get more water, and she gave water to all the camels. ");
INSERT INTO engerv_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","The servant quietly watched her. He wanted to be sure that the LORD had given him an answer and had made his trip successful. ");
INSERT INTO engerv_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","After the camels finished drinking, he gave Rebekah a gold ring that weighed 1/4 ounce. He also gave her two gold arm bracelets that weighed 2 ounces each. ");
INSERT INTO engerv_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","The servant asked, “Who is your father? And is there a place in your father’s house for me and my men to sleep?” ");
INSERT INTO engerv_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekah answered, “My father is Bethuel, the son of Milcah and Nahor.” ");
INSERT INTO engerv_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Then she said, “Yes, we have straw and other food for your camels and a place for you to sleep.” ");
INSERT INTO engerv_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","The servant bowed and worshiped the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","He said, “Praise be to the LORD, the God of my master Abraham. The LORD has been kind and loyal to him by leading me to his own people.” ");
INSERT INTO engerv_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Then Rebekah ran and told her family about all these things. ");
INSERT INTO engerv_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","She had a brother named Laban. She told him what the man had said to her. Laban was listening to her. And when he saw the ring and the bracelets on his sister’s arms, he ran out to the well. There the man was, standing by the camels at the well. ");
INSERT INTO engerv_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban said, “Sir, you are welcome to come in! You don’t have to stand outside here. I have prepared a room for you to sleep in and a place for your camels.” ");
INSERT INTO engerv_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","So Abraham’s servant went into the house. Laban unloaded his camels and gave them straw and feed. Then he gave Abraham’s servant water so that he and the men with him could wash their feet. ");
INSERT INTO engerv_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Laban then gave him food to eat, but the servant refused to eat. He said, “I will not eat until I have told you why I came.” So Laban said, “Then tell us.” ");
INSERT INTO engerv_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","The servant said, “I am Abraham’s servant. ");
INSERT INTO engerv_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","The LORD has greatly blessed my master in everything. My master has become a great man. The Lord has given him many flocks of sheep and herds of cattle. He has much silver and gold and many servants. He has many camels and donkeys. ");
INSERT INTO engerv_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sarah was my master’s wife. When she was very old, she gave birth to a son, and my master has given everything he owns to that son. ");
INSERT INTO engerv_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","My master forced me to make a promise to him. He said to me, ‘You must not allow my son to marry a girl from Canaan. We live among these people, but I don’t want him to marry one of the Canaanite girls. ");
INSERT INTO engerv_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","So you must promise to go to my father’s country. Go to my family and choose a wife for my son.’ ");
INSERT INTO engerv_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","I said to my master, ‘Maybe the woman will not come back to this place with me.’ ");
INSERT INTO engerv_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","But my master said to me, ‘I serve the LORD, and he will send his angel with you and help you. You will find a wife for my son among my people there. ");
INSERT INTO engerv_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","But if you go to my father’s country, and they refuse to give you a wife for my son, you will be free from this promise.’ ");
INSERT INTO engerv_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Today I came to this well and said, ‘LORD, God of my master Abraham, please make my trip successful. ");
INSERT INTO engerv_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","I will stand by this well and wait for a young woman to come to get water. Then I will say, “Please give me water from your jar to drink.” ");
INSERT INTO engerv_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","The right woman will answer in a special way. She will say, “Drink this water, and I will also get water for your camels.” That way I will know that she is the one the LORD has chosen for my master’s son.’ ");
INSERT INTO engerv_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Before I finished praying, Rebekah came out to the well to get water. She had her water jar on her shoulder as she went to get water from the well. I asked her to give me some water. ");
INSERT INTO engerv_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","She quickly lowered the jar from her shoulder and poured me some water. Then she said, ‘Drink this, and I’ll get some water for your camels.’ So I drank the water, and she gave water to my camels. ");
INSERT INTO engerv_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Then I asked her, ‘Who is your father?’ She answered, ‘My father is Bethuel the son of Milcah and Nahor.’ Then I gave her the ring and bracelets for her arms. ");
INSERT INTO engerv_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","I bowed my head and worshiped the LORD. I praised the LORD, the God of my master Abraham. I thanked him for leading me straight to the granddaughter of my master’s brother. ");
INSERT INTO engerv_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Now, tell me, will you be kind and loyal to my master and give him your daughter? Or will you refuse to give her to him? Tell me so that I will know what I should do.” ");
INSERT INTO engerv_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Then Laban and Bethuel answered, “We see that this is from the LORD, so there is nothing we can say to change it. ");
INSERT INTO engerv_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Here is Rebekah. Take her and go. Let her marry your master’s son. This is what the LORD wants.” ");
INSERT INTO engerv_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","When Abraham’s servant heard this, he bowed to the ground before the LORD. ");
INSERT INTO engerv_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Then he gave Rebekah the gifts he brought. He gave her beautiful clothes and gold and silver jewelry. He also gave expensive gifts to her mother and brother. ");
INSERT INTO engerv_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Then he and his men had something to eat and drink, and they spent the night there. Early the next morning they got up and the servant said, “Now we must go back to my master.” ");
INSERT INTO engerv_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebekah’s mother and her brother said, “Let Rebekah stay with us for a short time. Let her stay with us ten days. After that she can go.” ");
INSERT INTO engerv_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","But the servant said to them, “Don’t make me wait. The LORD has made my trip successful. Now let me go back to my master.” ");
INSERT INTO engerv_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Rebekah’s brother and mother said, “We will call Rebekah and ask her what she wants to do.” ");
INSERT INTO engerv_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","They called her and asked her, “Do you want to go with this man now?” Rebekah said, “Yes, I will go.” ");
INSERT INTO engerv_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So they allowed Rebekah to go with Abraham’s servant and his men. Her nurse also went with them. ");
INSERT INTO engerv_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","While Rebekah was leaving they said to her, “Our sister, may you be the mother of millions of people, and may your descendants defeat their enemies and take their cities.” ");
INSERT INTO engerv_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Then Rebekah and her nurse got on the camels and followed the servant and his men. So the servant took Rebekah and left. ");
INSERT INTO engerv_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac had left Beer Lahai Roi and was now living in the Negev. ");
INSERT INTO engerv_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","One evening he went out to the field to think. He looked up and saw the camels coming from far away. ");
INSERT INTO engerv_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah also looked and saw Isaac. Then she jumped down from the camel. ");
INSERT INTO engerv_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","She said to the servant, “Who is that young man walking in the field to meet us?” The servant said, “That is my master’s son.” So Rebekah covered her face with her veil. ");
INSERT INTO engerv_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","The servant told Isaac everything that had happened. ");
INSERT INTO engerv_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Then Isaac brought the girl into his mother’s tent. Rebekah became his wife that day. Isaac loved her very much. So he was comforted after his mother’s death. ");
INSERT INTO engerv_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham married again. His new wife was named Keturah. ");
INSERT INTO engerv_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","She gave birth to Zimran, Jokshan, Medan, Midian, Ishbak, and Shuah. ");
INSERT INTO engerv_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan was the father of Sheba and Dedan. The people of Asshur, Leum, and Letush were descendants of Dedan. ");
INSERT INTO engerv_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","The sons of Midian were Ephah, Epher, Hanoch, Abida, and Eldaah. All these sons came from the marriage of Abraham and Keturah. ");
INSERT INTO engerv_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Before Abraham died, he gave some gifts to his sons who were from his slave women. He sent them to the East, away from Isaac. Then Abraham gave everything he owned to Isaac. ");
INSERT INTO engerv_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham lived to be 175 years old. ");
INSERT INTO engerv_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Then he grew weak and died. He had lived a long and satisfying life. He died and went to be with his people. ");
INSERT INTO engerv_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","His sons Isaac and Ishmael buried him in the cave of Machpelah. This cave is in the field of Ephron, the son of Zohar. It was east of Mamre. ");
INSERT INTO engerv_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","This is the same cave that Abraham bought from the Hittites. He was buried there with his wife Sarah. ");
INSERT INTO engerv_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","After Abraham died, God blessed Isaac. Isaac was living at Beer Lahai Roi. ");
INSERT INTO engerv_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","This is the list of Ishmael’s family. Ishmael was Abraham and Hagar’s son. (Hagar was Sarah’s Egyptian maid.) ");
INSERT INTO engerv_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","These are the names of Ishmael’s sons: The first son was Nebaioth; then Kedar was born, then Adbeel, Mibsam, ");
INSERT INTO engerv_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO engerv_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish, and Kedemah. ");
INSERT INTO engerv_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","These were the names of Ishmael’s sons. Each son had his own camp that became a small town. The twelve sons were leaders over their own people. ");
INSERT INTO engerv_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael lived to be 137 years old. Then he died and went to be with his people. ");
INSERT INTO engerv_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","His descendants settled throughout the desert area from Havilah to Shur. This area begins near Egypt and goes toward Assyria. Ishmael’s people were often at war with the other descendants of Abraham. ");
INSERT INTO engerv_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","This is the story of Isaac. Abraham had a son named Isaac. ");
INSERT INTO engerv_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","When Isaac was 40 years old, he married Rebekah. Rebekah was from Paddan Aram. She was Bethuel’s daughter and the sister of Laban the Aramean. ");
INSERT INTO engerv_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac’s wife could not have children. So Isaac prayed to the LORD for her. The LORD heard Isaac’s prayer, and he allowed Rebekah to become pregnant. ");
INSERT INTO engerv_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","While Rebekah was pregnant, the babies inside her struggled with one another. She prayed to the LORD and said, “What is happening to me?” ");
INSERT INTO engerv_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","The LORD said to her, “The leaders of two nations are in your body. Two nations will come from you, and they will be divided. One of them will be stronger, and the older will serve the younger.” ");
INSERT INTO engerv_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","When the right time came, Rebekah gave birth to twins. ");
INSERT INTO engerv_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","The first baby was red. His skin was like a hairy robe. So he was named Esau. ");
INSERT INTO engerv_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","When the second baby was born, he was holding tightly to Esau’s heel. So that baby was named Jacob. Isaac was 60 years old when Jacob and Esau were born. ");
INSERT INTO engerv_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","The boys grew up. Esau became a skilled hunter, who loved to be out in the fields. But Jacob was a quiet man, who stayed at home. ");
INSERT INTO engerv_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac loved Esau. He liked to eat the animals Esau killed. But Rebekah loved Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","One day Esau came back from hunting. He was tired and weak from hunger. Jacob was boiling a pot of beans. ");
INSERT INTO engerv_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","So Esau said to Jacob, “I am weak with hunger. Let me have some of that red soup.” (That is why people call him “Red.”) ");
INSERT INTO engerv_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","But Jacob said, “You must sell me your rights as the firstborn son.” ");
INSERT INTO engerv_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau said, “I am almost dead with hunger, so what good are these rights to me now?” ");
INSERT INTO engerv_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","But Jacob said, “First, promise me that you will give them to me.” So Esau made an oath to him and sold his rights as the firstborn son to Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Then Jacob gave Esau bread and lentil soup. Esau ate the food, had something to drink, and then left. So Esau showed that he did not care about his rights as the firstborn son. ");
INSERT INTO engerv_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Now there was a famine. This was like the famine that happened during Abraham’s life. So Isaac went to the town of Gerar, to King Abimelech of the Philistines. ");
INSERT INTO engerv_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","The LORD spoke to Isaac and said, “Don’t go down to Egypt. Live in the land that I commanded you to live in. ");
INSERT INTO engerv_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stay in this land, and I will be with you. I will bless you. I will give you and your family all these lands. I will do what I promised to Abraham your father. ");
INSERT INTO engerv_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","I will make your family as many as the stars of heaven, and I will give all these lands to your family. Through your descendants every nation on earth will be blessed. ");
INSERT INTO engerv_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","I will do this because your father Abraham obeyed my words and did what I said. He obeyed my commands, my laws, and my rules.” ");
INSERT INTO engerv_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","So Isaac settled in Gerar. ");
INSERT INTO engerv_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","His wife Rebekah was very beautiful. The men of that place asked Isaac about Rebekah. He said, “She is my sister.” He was afraid to tell them Rebekah was his wife. He was afraid the men would kill him so that they could have her. ");
INSERT INTO engerv_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","After Isaac had lived there a long time, Abimelech looked out of his window and saw Isaac and his wife enjoying one another. ");
INSERT INTO engerv_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech called for Isaac and said, “This woman is your wife. Why did you tell us that she was your sister?” Isaac said to him, “I was afraid that you would kill me so that you could have her.” ");
INSERT INTO engerv_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech said, “You have done a bad thing to us. One of our men might have had sex with your wife. Then he would be guilty of a great sin.” ");
INSERT INTO engerv_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","So Abimelech gave a warning to all the people. He said, “No one must hurt this man or this woman. If anyone hurts them, they will be killed.” ");
INSERT INTO engerv_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac planted fields in that place, and that year he gathered a great harvest. The LORD blessed him very much. ");
INSERT INTO engerv_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaac became rich. He gathered more and more wealth until he became a very rich man. ");
INSERT INTO engerv_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He had many flocks and herds of animals. He also had many slaves. All the Philistines were jealous of him. ");
INSERT INTO engerv_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","So they destroyed all the wells that Isaac’s father Abraham and his servants had dug many years before. They filled them with sand. ");
INSERT INTO engerv_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelech said to Isaac, “Leave our country. You have become much more powerful than we are.” ");
INSERT INTO engerv_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Isaac left that place and camped near the little river of Gerar. He stayed there and lived. ");
INSERT INTO engerv_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Long before this time, Abraham had dug many wells. After he died, the Philistines filled the wells with sand. So Isaac went back and dug those wells again. He gave them the same names his father had given them. ");
INSERT INTO engerv_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac’s servants also dug a well near the little river and found fresh water. ");
INSERT INTO engerv_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","But the men who herded sheep in the Valley of Gerar argued with Isaac’s servants. They said, “This water is ours.” So Isaac named that well Esek. He gave it that name because it was the place where they had argued with him. ");
INSERT INTO engerv_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Then Isaac’s servants dug another well. But there was an argument over this well too. So Isaac named that well Sitnah. ");
INSERT INTO engerv_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isaac moved from there and dug another well. No one came to argue about this well. So Isaac named it Rehoboth. He said, “Now the LORD has found a place for us. We will grow and be successful in this place.” ");
INSERT INTO engerv_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","From there Isaac went to Beersheba. ");
INSERT INTO engerv_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","The LORD spoke to him that night and said, “I am the God of your father Abraham. Don’t be afraid. I am with you, and I will bless you. I will make your family great. I will do this because of my servant Abraham.” ");
INSERT INTO engerv_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","So Isaac built an altar and worshiped the LORD in that place. He set up camp there, and his servants dug a well. ");
INSERT INTO engerv_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelech came from Gerar to see Isaac. He brought with him Ahuzzath, his advisor, and Phicol, the commander of his army. ");
INSERT INTO engerv_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac asked, “Why have you come to see me? You were not friendly to me before. You even forced me to leave your country.” ");
INSERT INTO engerv_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","They answered, “Now we know that the LORD is with you. We think that we should make an agreement. We want you to make a promise to us. ");
INSERT INTO engerv_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","We did not hurt you; now you should promise not to hurt us. We sent you away, but we sent you away in peace. Now it is clear that the LORD has blessed you.” ");
INSERT INTO engerv_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","So Isaac gave a party for them. They all ate and drank. ");
INSERT INTO engerv_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Early the next morning each man made a promise and a vow. Then the men left in peace. ");
INSERT INTO engerv_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","On that day Isaac’s servants came and told him about the well they had dug. The servants said, “We found water in that well.” ");
INSERT INTO engerv_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","So Isaac named it Shibah. And that city is still called Beersheba. ");
INSERT INTO engerv_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","When Esau was 40 years old, he married two Hittite women. One was Judith the daughter of Beeri. The other was Basemath the daughter of Elon. ");
INSERT INTO engerv_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","These marriages made Isaac and Rebekah very unhappy. ");
INSERT INTO engerv_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac grew old, and his eyes became so weak that he could not see clearly. One day he called his older son Esau to him and said, “Son!” Esau answered, “Here I am.” ");
INSERT INTO engerv_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac said, “I am old. Maybe I will die soon. ");
INSERT INTO engerv_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","So take your bow and arrows and go hunting. Kill an animal for me to eat. ");
INSERT INTO engerv_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Prepare the food that I love. Bring it to me, and I will eat it. Then I will bless you before I die.” ");
INSERT INTO engerv_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","So Esau went hunting. Rebekah was listening when Isaac told this to his son Esau. ");
INSERT INTO engerv_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah said to her son Jacob, “Listen, I heard your father talking to your brother Esau. ");
INSERT INTO engerv_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Your father said, ‘Kill an animal for me to eat. Prepare the food for me, and I will eat it. Then, with the LORD as witness, I will bless you before I die.’ ");
INSERT INTO engerv_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","So listen, son, and do what I tell you. ");
INSERT INTO engerv_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go out to our goats and bring me two young ones. I will prepare them the way your father loves them. ");
INSERT INTO engerv_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Then you will carry the food to your father, and he will bless you before he dies.” ");
INSERT INTO engerv_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","But Jacob told his mother Rebekah, “My brother Esau is a hairy man. I am not hairy like him. ");
INSERT INTO engerv_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","If my father touches me, he will know that I am not Esau. Then he will not bless me—he will curse me because I tried to trick him.” ");
INSERT INTO engerv_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","So Rebekah said to him, “I will accept the blame if there is trouble. Do what I said. Go get the goats for me.” ");
INSERT INTO engerv_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","So Jacob went out and got two goats and brought them to his mother. His mother cooked the goats in the special way that Isaac loved. ");
INSERT INTO engerv_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Then Rebekah took the clothes that her older son Esau loved to wear. She put these clothes on the younger son Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","She took the skins of the goats and put them on Jacob’s hands and on his neck. ");
INSERT INTO engerv_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Then she got the food she had cooked and gave it to Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob went to his father and said, “Father.” His father answered, “Yes, son. Who are you?” ");
INSERT INTO engerv_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob said to his father, “I am Esau, your first son. I have done what you told me. Now sit up and eat the meat from the animals that I hunted for you. Then you can bless me.” ");
INSERT INTO engerv_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","But Isaac said to his son, “How have you hunted and killed the animals so quickly?” Jacob answered, “Because the LORD your God allowed me to find the animals quickly.” ");
INSERT INTO engerv_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Then Isaac said to Jacob, “Come near to me so that I can feel you, my son. If I can feel you, I will know if you are really my son Esau.” ");
INSERT INTO engerv_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","So Jacob went to Isaac his father. Isaac felt him and said, “Your voice sounds like Jacob’s voice, but your arms are hairy like the arms of Esau.” ");
INSERT INTO engerv_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac did not know it was Jacob, because his arms were hairy like Esau’s. So Isaac blessed Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaac said, “Are you really my son Esau?” Jacob answered, “Yes, I am.” ");
INSERT INTO engerv_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Then Isaac said, “Bring me the food. I will eat it and bless you.” So Jacob gave him the food, and he ate it. Then Jacob gave him some wine, and he drank it. ");
INSERT INTO engerv_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Then Isaac said to him. “Son, come near and kiss me.” ");
INSERT INTO engerv_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","So Jacob went to his father and kissed him. When Isaac smelled Esau’s clothes, he blessed him and said, “My son smells like the fields the LORD has blessed. ");
INSERT INTO engerv_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","May God give you plenty of rain, good crops, and wine. ");
INSERT INTO engerv_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","May the nations serve you and many people bow down to you. You will rule over your brothers. Your mother’s sons will bow down to you and obey you. Whoever curses you will be cursed. Whoever blesses you will be blessed.” ");
INSERT INTO engerv_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac finished blessing Jacob. Then, just as Jacob left his father Isaac, Esau came in from hunting. ");
INSERT INTO engerv_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau prepared the food in the special way his father loved. He brought it to his father and said, “Father, I am your son. Get up and eat the meat from the animals that I killed for you. Then you can bless me.” ");
INSERT INTO engerv_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","But Isaac said to him, “Who are you?” He answered, “I am your son—your first son—Esau.” ");
INSERT INTO engerv_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Then Isaac became so upset that he began to shake. He said, “Then who was it that cooked and brought me food before you came? I ate it all, and I blessed him. Now it is too late to take back my blessing.” ");
INSERT INTO engerv_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","When Esau heard his father’s words, he became very angry and bitter. He cried out and said to his father, “Then bless me also, father!” ");
INSERT INTO engerv_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac said, “Your brother tricked me! He came and took your blessing!” ");
INSERT INTO engerv_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau said, “His name is Jacob. That is the right name for him. He has tricked me twice. He took away my rights as the firstborn son. And now he has taken away my blessing.” Then Esau said, “Have you saved any blessing for me?” ");
INSERT INTO engerv_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac answered, “I have already given Jacob the power to rule over you. And I said all his brothers would be his servants. I have given him the blessing for much grain and wine. There is nothing left to give you, my son.” ");
INSERT INTO engerv_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","But Esau continued to beg his father. “Do you have only one blessing, father? Bless me also, father!” Esau began to cry. ");
INSERT INTO engerv_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Then Isaac said to him, “You will not live on good land. You will not have much rain. ");
INSERT INTO engerv_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","You will have to fight to live, and you will be a slave to your brother. But when you fight to be free, you will break away from his control.” ");
INSERT INTO engerv_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","After that Esau hated Jacob because of this blessing. Esau said to himself, “My father will soon die, and after we are finished with that, I will kill Jacob.” ");
INSERT INTO engerv_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebekah heard about Esau’s plan to kill Jacob. She sent for Jacob and said to him, “Listen, your brother Esau is planning to kill you. ");
INSERT INTO engerv_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","So, son, do what I say. My brother Laban is living in Haran. Go to him and hide. ");
INSERT INTO engerv_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Stay with him for a short time until your brother stops being angry. ");
INSERT INTO engerv_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","When your brother forgets what you did to him, I will send a servant to bring you back. I don’t want to lose both of my sons the same day.” ");
INSERT INTO engerv_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Then Rebekah said to Isaac, “Your son Esau married Hittite women. I am very upset about this, because they are not our people. I’ll have nothing to live for if Jacob marries one of these women!” ");
INSERT INTO engerv_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac called Jacob and blessed him. Then Isaac gave him a command and said, “You must not marry a Canaanite woman. ");
INSERT INTO engerv_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","So leave this place and go to Paddan Aram. Go to the house of Bethuel, your mother’s father. Laban, your mother’s brother, lives there. Marry one of his daughters. ");
INSERT INTO engerv_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","I pray that God All-Powerful will bless you and give you many children. I pray that you will become the father of a great nation ");
INSERT INTO engerv_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","and that God will bless you and your children the same way he blessed Abraham. And I pray that you will own the land where you live. This is the land God gave to Abraham.” ");
INSERT INTO engerv_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","So Isaac sent Jacob to Rebekah’s brother in Paddan Aram. Jacob went to Laban, son of Bethuel the Aramean. Laban was the brother of Rebekah, the mother of Jacob and Esau. ");
INSERT INTO engerv_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau learned that his father Isaac blessed Jacob and sent him away to Paddan Aram to find a wife there. He also learned that Isaac commanded Jacob not to marry a Canaanite woman. ");
INSERT INTO engerv_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau learned that Jacob obeyed his father and his mother and went to Paddan Aram. ");
INSERT INTO engerv_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau saw from this that his father did not want his sons to marry Canaanite women. ");
INSERT INTO engerv_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau already had two wives, but he went to Abraham’s son Ishmael and married another woman, Mahalath, the daughter of Ishmael. Mahalath was Nebaioth’s sister. ");
INSERT INTO engerv_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob left Beersheba and went to Haran. ");
INSERT INTO engerv_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","The sun had already set when he came to a good place to spend the night. He took a rock there and laid his head on it to sleep. ");
INSERT INTO engerv_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Jacob had a dream. He dreamed there was a ladder that was on the ground and reached up into heaven. He saw the angels of God going up and down the ladder. ");
INSERT INTO engerv_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","And then Jacob saw the LORD standing by the ladder. He said, “I am the LORD, the God of your grandfather Abraham. I am the God of Isaac. I will give you the land that you are lying on now. I will give this land to you and to your children. ");
INSERT INTO engerv_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","You will have as many descendants as there are particles of dust on the earth. They will spread east and west, north and south. All the families on earth will be blessed because of you and your descendants. ");
INSERT INTO engerv_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“I am with you, and I will protect you everywhere you go. I will bring you back to this land. I will not leave you until I have done what I have promised.” ");
INSERT INTO engerv_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Then Jacob woke up and said, “I know that the LORD is in this place, but I did not know he was here until I slept.” ");
INSERT INTO engerv_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Jacob was afraid and said, “This is a very great place. This is the house of God. This is the gate to heaven.” ");
INSERT INTO engerv_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jacob got up very early in the morning. He took the rock he had slept on and set it up on its edge. Then he poured oil on the rock. In this way he made it a memorial to God. ");
INSERT INTO engerv_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","The name of that place was Luz, but Jacob named it Bethel. ");
INSERT INTO engerv_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Then Jacob made a promise. He said, “If God will be with me, and if he will protect me on this trip, and if he gives me food to eat and clothes to wear, ");
INSERT INTO engerv_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","and if I return in peace to my father’s house—if he does all these things—then the LORD will be my God. ");
INSERT INTO engerv_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","I am setting this stone up as a memorial stone. It will show that this is a holy place for God, and I will give God one-tenth of all he gives me.” ");
INSERT INTO engerv_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Then Jacob continued his trip. He went to the country in the East. ");
INSERT INTO engerv_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","He looked and saw a well in the field. There were three flocks of sheep lying near the well, where the sheep drank water. There was a large rock covering the mouth of the well. ");
INSERT INTO engerv_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","When all the flocks were gathered there, the shepherds would roll the rock away from the well. Then all the sheep could drink from the water. After the sheep were full, the shepherds would put the rock back in its place. ");
INSERT INTO engerv_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob said to the shepherds there, “Brothers, where are you from?” They answered, “We are from Haran.” ");
INSERT INTO engerv_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Then Jacob said, “Do you know Laban, the son of Nahor?” The shepherds answered, “We know him.” ");
INSERT INTO engerv_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Then Jacob said, “How is he?” They answered, “He is well. Look, that is his daughter Rachel coming now with his sheep.” ");
INSERT INTO engerv_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob said, “Look, it is still day and long before the sun sets. It is not yet time for the animals to be gathered together for the night. So give them water and let them go back into the field.” ");
INSERT INTO engerv_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","But they said, “We cannot do that until all the flocks are gathered together. Then we will move the rock from the well, and all the sheep will drink.” ");
INSERT INTO engerv_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","While Jacob was talking with the shepherds, Rachel came with her father’s sheep. (It was her job to take care of the sheep.) ");
INSERT INTO engerv_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Rachel was Laban’s daughter. Laban was the brother of Rebekah, Jacob’s mother. When Jacob saw Rachel, he went and moved the rock and gave water to the sheep. ");
INSERT INTO engerv_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Then Jacob kissed Rachel and cried. ");
INSERT INTO engerv_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","He told her that he was from her father’s family. He told her that he was the son of Rebekah. So Rachel ran home and told her father. ");
INSERT INTO engerv_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","When Laban heard the news about his sister’s son Jacob, he ran to meet him. Laban hugged him and kissed him and brought him to his house. Jacob told Laban everything that had happened. ");
INSERT INTO engerv_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Then Laban said, “This is wonderful! You are from my own family.” So Jacob stayed with Laban for a month. ");
INSERT INTO engerv_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","One day Laban said to Jacob, “You are a relative of mine. It is not right for you to continue working for me without pay. What should I pay you?” ");
INSERT INTO engerv_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Now Laban had two daughters. The older was Leah and the younger was Rachel. ");
INSERT INTO engerv_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah’s eyes were gentle, but Rachel was beautiful. ");
INSERT INTO engerv_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob loved Rachel, so he said to Laban, “I will work seven years for you if you will allow me to marry your daughter Rachel.” ");
INSERT INTO engerv_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban said, “It would be better for her to marry you than someone else. So stay with me.” ");
INSERT INTO engerv_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","So Jacob stayed and worked for Laban for seven years. But it seemed like a very short time because he loved Rachel very much. ");
INSERT INTO engerv_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","After seven years Jacob said to Laban, “Give me Rachel so that I can marry her. My time of work for you is finished.” ");
INSERT INTO engerv_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","So Laban gave a party for all the people in that place. ");
INSERT INTO engerv_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","That night Laban brought his daughter Leah to Jacob. Jacob and Leah had sexual relations together. ");
INSERT INTO engerv_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Laban gave his maid Zilpah to his daughter to be her maid.) ");
INSERT INTO engerv_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","In the morning Jacob saw that it was Leah he had slept with, and he said to Laban, “You have tricked me. I worked hard for you so that I could marry Rachel. Why did you trick me?” ");
INSERT INTO engerv_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban said, “In our country we don’t allow the younger daughter to marry before the older daughter. ");
INSERT INTO engerv_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Continue for the full week of the marriage ceremony, and I will also give you Rachel to marry. But you must serve me another seven years.” ");
INSERT INTO engerv_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","So Jacob did this and finished the week. Then Laban gave him his daughter Rachel as a wife. ");
INSERT INTO engerv_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Laban gave his maid Bilhah to his daughter Rachel to be her maid.) ");
INSERT INTO engerv_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","So Jacob had sexual relations with Rachel also. And Jacob loved Rachel more than Leah. Jacob worked for Laban for another seven years. ");
INSERT INTO engerv_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","The LORD saw that Jacob loved Rachel more than Leah, so he made it possible for Leah to have children. But Rachel did not have any children. ");
INSERT INTO engerv_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah gave birth to a son, and she named him Reuben. She named him this because she said, “The LORD has seen my troubles. My husband does not love me. So now maybe my husband will love me.” ");
INSERT INTO engerv_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leah became pregnant again and had another son. She named this son Simeon. She said, “The LORD has heard that I am not loved, so he gave me this son.” ");
INSERT INTO engerv_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Leah became pregnant again and had another son. She named this son Levi. She said, “Now, surely my husband will love me. I have given him three sons.” ");
INSERT INTO engerv_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Then Leah gave birth to another son. She named this son Judah. Leah named him this because she said, “Now I will praise the LORD.” Then Leah stopped having children. ");
INSERT INTO engerv_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel saw that she was not giving Jacob any children. She became jealous of her sister Leah. So Rachel said to Jacob, “Give me children, or I will die!” ");
INSERT INTO engerv_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob became angry with Rachel and said, “I am not God. He is the one who has caused you to not have children.” ");
INSERT INTO engerv_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Then Rachel said, “You can have my maid Bilhah. Sleep with her, and she will have a child for me. Then I can be a mother through her.” ");
INSERT INTO engerv_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","So Rachel gave Bilhah to her husband Jacob. He had sexual relations with Bilhah. ");
INSERT INTO engerv_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","She became pregnant and gave birth to a son for Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel said, “God has listened to my prayer. He decided to give me a son.” So she named this son Dan. ");
INSERT INTO engerv_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilhah became pregnant again and gave Jacob a second son. ");
INSERT INTO engerv_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel said, “I have fought hard to compete with my sister, and I have won.” So she named that son Naphtali. ");
INSERT INTO engerv_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah saw that she could have no more children. So she gave her slave girl Zilpah to Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Then Zilpah had a son. ");
INSERT INTO engerv_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah said, “I am lucky.” So she named the son Gad. ");
INSERT INTO engerv_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpah gave birth to another son. ");
INSERT INTO engerv_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah said, “I am very happy! Now women will call me happy.” So she named that son Asher. ");
INSERT INTO engerv_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","During the wheat harvest Reuben went into the fields and found some special flowers. He brought them to his mother Leah. But Rachel said to Leah, “Please give me some of your son’s flowers.” ");
INSERT INTO engerv_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah answered, “You have already taken away my husband. Now you are trying to take away my son’s flowers.” But Rachel answered, “If you will give me your son’s flowers, you can sleep with Jacob tonight.” ");
INSERT INTO engerv_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jacob came in from the fields that night. Leah saw him and went out to meet him. She said, “You will sleep with me tonight. I have paid for you with my son’s flowers.” So Jacob slept with Leah that night. ");
INSERT INTO engerv_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Then God allowed Leah to become pregnant again. She gave birth to a fifth son. ");
INSERT INTO engerv_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","She said, “God has given me a reward because I gave my slave to my husband.” So she named her son Issachar. ");
INSERT INTO engerv_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah became pregnant again and gave birth to a sixth son. ");
INSERT INTO engerv_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","She said, “God has given me a fine gift. Now surely Jacob will accept me, because I have given him six sons.” So she named this son Zebulun. ");
INSERT INTO engerv_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Later, Leah gave birth to a daughter. She named her Dinah. ");
INSERT INTO engerv_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Then God heard Rachel’s prayer and made it possible for Rachel to have children. ");
INSERT INTO engerv_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","She became pregnant and gave birth to a son. She said, “God has taken away my shame.” ");
INSERT INTO engerv_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rachel named the son Joseph, saying, “May the Lord give me another son.” ");
INSERT INTO engerv_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","After the birth of Joseph, Jacob said to Laban, “Now let me go back to my own homeland. ");
INSERT INTO engerv_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Give me my wives and my children. I have earned them by working for you. You know that I served you well.” ");
INSERT INTO engerv_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban said to him, “Please, let me say something. I know that the LORD has blessed me because of you. ");
INSERT INTO engerv_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tell me what I should pay you, and I will give it to you.” ");
INSERT INTO engerv_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob answered, “You know that I have worked hard for you. Your flocks have grown and been well while I cared for them. ");
INSERT INTO engerv_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","When I came, you had little. Now you have much, much more. Every time I did something for you, the LORD blessed you. Now it is time for me to work for myself—it is time to do things for my family.” ");
INSERT INTO engerv_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban asked, “Then what should I give you?” Jacob answered, “I don’t want you to give me anything! I only want you to let me do this one thing: I will go back and take care of your sheep. ");
INSERT INTO engerv_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","But let me go through all your flocks today and take every lamb with spots or stripes. Let me take every black young goat and every female goat with stripes or spots. That will be my pay. ");
INSERT INTO engerv_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","In the future you can easily see if I am honest. You can come to look at my flocks. If I have any goat that isn’t spotted or any sheep that isn’t black, you will know that I stole it.” ");
INSERT INTO engerv_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban answered, “I agree to that. We will do what you ask.” ");
INSERT INTO engerv_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","But that day Laban hid all the male goats that had spots. And he hid all the female goats that had spots on them. He also hid all the black sheep. Laban told his sons to watch these sheep. ");
INSERT INTO engerv_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","So the sons took all the spotted animals and led them to another place. They traveled for three days. Jacob stayed and took care of all the animals that were left. ");
INSERT INTO engerv_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Then Jacob cut green branches from poplar and almond trees. He stripped off some of the bark so that the branches had white stripes on them. ");
INSERT INTO engerv_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","He put the branches in front of the flocks at the watering places. When the animals came to drink, they also mated in that place. ");
INSERT INTO engerv_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Then when the goats mated in front of the branches, the young that were born were spotted, striped, or black. ");
INSERT INTO engerv_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob separated the spotted and the black animals from the other animals in the flock. He kept his animals separate from Laban’s. ");
INSERT INTO engerv_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Any time the stronger animals in the flock were mating, Jacob put the branches before their eyes. The animals mated near those branches. ");
INSERT INTO engerv_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","But when the weaker animals mated, Jacob did not put the branches there. So the young animals born from the weak animals were Laban’s. And the young animals born from the stronger animals were Jacob’s. ");
INSERT INTO engerv_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","In this way Jacob became very rich. He had large flocks, many servants, camels, and donkeys. ");
INSERT INTO engerv_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","One day Jacob heard Laban’s sons talking. They said, “Jacob has taken everything that our father owned. He has become rich—and he has taken all this wealth from our father.” ");
INSERT INTO engerv_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Then Jacob noticed that Laban was not as friendly as he had been in the past. ");
INSERT INTO engerv_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","The LORD said to Jacob, “Go back to your own land where your ancestors lived. I will be with you.” ");
INSERT INTO engerv_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","So Jacob told Rachel and Leah to meet him in the field where he kept his flocks of sheep and goats. ");
INSERT INTO engerv_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","He said to them, “I have noticed that your father is not as friendly with me as he used to be. But the God of my father has been with me. ");
INSERT INTO engerv_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","You both know that I have worked as hard as I could for your father. ");
INSERT INTO engerv_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","But he cheated me. He has changed my pay ten times. But during all this time, God protected me from all of Laban’s tricks. ");
INSERT INTO engerv_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“At one time Laban said, ‘You can keep all the goats with spots. This will be your pay.’ After he said this, all the animals gave birth to spotted goats, so they were all mine. But then Laban said, ‘I will keep the spotted goats. You can have all the striped goats. That will be your pay.’ After he said this, all the animals gave birth to striped goats. ");
INSERT INTO engerv_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","So God has taken the animals away from your father and has given them to me. ");
INSERT INTO engerv_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“I had a dream during the time when the animals were mating. I saw that the only male goats that were mating were the ones with stripes and spots. ");
INSERT INTO engerv_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","The angel of God spoke to me in that dream. The angel said, ‘Jacob!’ “I answered, ‘Yes!’ ");
INSERT INTO engerv_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“The angel said, ‘Look, only the striped and spotted goats are mating. I am causing this to happen. I have seen all the wrong things Laban has been doing to you. I am doing this so that you can have all the new baby goats. ");
INSERT INTO engerv_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","I am the God who came to you at Bethel, and there you made an altar, poured olive oil on it, and made a promise to me. Now I want you to be ready to go back to the country where you were born.’” ");
INSERT INTO engerv_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel and Leah answered Jacob, “Our father has nothing to give us when he dies. ");
INSERT INTO engerv_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","He treated us like strangers. He sold us to you, and then he spent all the money that should have been ours. ");
INSERT INTO engerv_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","God took all this wealth from our father, and now it belongs to us and our children. So you should do whatever God told you to do.” ");
INSERT INTO engerv_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","So Jacob prepared for the trip. He put his children and his wives on camels. ");
INSERT INTO engerv_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Then they began traveling back to the land of Canaan, where his father lived. All the flocks of animals that Jacob owned walked ahead of them. He carried everything with him that he had gotten while he lived in Paddan Aram. ");
INSERT INTO engerv_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","While Laban was gone to cut the wool from his sheep, Rachel went into his house and stole the false gods that belonged to her father. ");
INSERT INTO engerv_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob tricked Laban the Aramean. He did not tell Laban he was leaving. ");
INSERT INTO engerv_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jacob took his family and everything he owned and left quickly. They crossed the Euphrates River and traveled toward the hill country of Gilead. ");
INSERT INTO engerv_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Three days later Laban learned that Jacob had run away. ");
INSERT INTO engerv_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","So he gathered his men together and began to chase Jacob. After seven days Laban found Jacob near the hill country of Gilead. ");
INSERT INTO engerv_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","That night God came to Laban in a dream and said, “Be careful! Be careful of every word you say to Jacob.” ");
INSERT INTO engerv_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","The next morning Laban caught up with Jacob. Jacob had set up his camp on the mountain, so Laban and all his men set up their camp in the hill country of Gilead. ");
INSERT INTO engerv_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban said to Jacob, “Why did you trick me? Why did you take my daughters like they were women you captured during war? ");
INSERT INTO engerv_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Why did you run away without telling me? If you had told me, I would have given you a party. There would have been singing and dancing with music. ");
INSERT INTO engerv_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","You didn’t even let me kiss my grandchildren and my daughters goodbye. You were very foolish to do this! ");
INSERT INTO engerv_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","I have the power to really hurt you. But last night the God of your father came to me in a dream. He warned me not to hurt you in any way. ");
INSERT INTO engerv_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","I know that you want to go back to your home. That is why you left. But why did you steal the gods from my house?” ");
INSERT INTO engerv_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob answered, “I left without telling you, because I was afraid. I thought you would take your daughters away from me. ");
INSERT INTO engerv_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","But I did not steal your gods. If you find anyone here with me who has taken your gods, they will be killed. Your men will be my witnesses. You can look for anything that belongs to you. Take anything that is yours.” (Jacob did not know that Rachel had stolen Laban’s gods.) ");
INSERT INTO engerv_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","So Laban went and looked through Jacob’s camp. He looked in Jacob’s tent and then in Leah’s tent. Then he looked in the tent where the two slave women stayed, but he did not find the gods from his house. Then he went into Rachel’s tent. ");
INSERT INTO engerv_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel had hidden the gods inside her camel’s saddle, and she was sitting on them. Laban looked through the whole tent, but he did not find the gods. ");
INSERT INTO engerv_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","And Rachel said to her father, “Father, don’t be angry with me. I am not able to stand up before you. I am having my monthly time of bleeding.” So Laban looked through the camp, but he did not find the gods from his house. ");
INSERT INTO engerv_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Then Jacob became very angry and said, “What wrong have I done? What law have I broken? What right do you have to chase me and stop me? ");
INSERT INTO engerv_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","You looked through everything I own and found nothing that belongs to you. If you found something, show it to me. Put it here where our men can see it. Let our men decide which one of us is right. ");
INSERT INTO engerv_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","I have worked 20 years for you. During all that time none of the baby sheep and goats died during birth. And I have not eaten any of the rams from your flocks. ");
INSERT INTO engerv_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Any time a sheep was killed by wild animals, I always paid for the loss myself. I did not take the dead animal to you and say that it was not my fault. But I was robbed day and night. ");
INSERT INTO engerv_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","In the daytime the sun took away my strength, and at night sleep was taken from my eyes by the cold. ");
INSERT INTO engerv_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I worked 20 years like a slave for you. For the first 14 years I worked to win your two daughters. The last six years I worked to earn your animals. And during that time you changed my pay ten times. ");
INSERT INTO engerv_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","But the God of my ancestors, the God of Abraham and the Fear of Isaac, was with me. If God had not been with me, you would have sent me away with nothing. But he saw the trouble that I had and the work that I did, and last night God proved that I am right.” ");
INSERT INTO engerv_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban said to Jacob, “These women are my daughters. These children belong to me, and these animals are mine. Everything you see here belongs to me, but I can do nothing to keep my daughters and their children. ");
INSERT INTO engerv_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","So I am ready to make an agreement with you. We will set up a pile of stones to show that we have an agreement.” ");
INSERT INTO engerv_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","So Jacob found a large rock and put it there to show that he had made an agreement. ");
INSERT INTO engerv_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","He told his men to find some more rocks and to make a pile of rocks. Then they ate beside the pile of rocks. ");
INSERT INTO engerv_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban named that place Yegar Sahadutha. But Jacob named that place Galeed. ");
INSERT INTO engerv_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban said to Jacob, “This pile of rocks will help us both remember our agreement.” That is why Jacob called the place Galeed. ");
INSERT INTO engerv_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Then Laban said, “Let the LORD watch over us while we are separated from each other.” So that place was also named Mizpah. ");
INSERT INTO engerv_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Then Laban said, “If you hurt my daughters, remember that God will punish you. If you marry other women, remember that God is watching. ");
INSERT INTO engerv_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Here are the rocks that I have put between us, and here is the special rock to show that we made an agreement. ");
INSERT INTO engerv_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","This pile of rocks and this one special rock both help us to remember our agreement. I will never go past these rocks to fight against you, and you must never go on my side of these rocks to fight against me. ");
INSERT INTO engerv_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","May the God of Abraham, the God of Nahor, and the God of their ancestors judge us guilty if we break this agreement.” Jacob’s father, Isaac, called God “Fear.” So Jacob used that name to make the promise. ");
INSERT INTO engerv_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Then Jacob killed an animal and offered it as a sacrifice on the mountain. And he invited his men to come and share a meal. After they finished eating, they spent the night on the mountain. ");
INSERT INTO engerv_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Early the next morning Laban kissed his grandchildren and his daughters goodbye. He blessed them and went back home. ");
INSERT INTO engerv_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob also left that place. While he was traveling, he saw God’s angels. ");
INSERT INTO engerv_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","When he saw them, he said, “This is God’s camp!” So Jacob named that place Mahanaim. ");
INSERT INTO engerv_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob’s brother Esau was living in the area called Seir in the hill country of Edom. Jacob sent messengers to Esau. ");
INSERT INTO engerv_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","He told them, “Tell this to my master Esau: ‘Your servant Jacob says, I have lived with Laban all these years. ");
INSERT INTO engerv_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","I have many cattle, donkeys, flocks, and servants. Sir, I am sending you this message to ask you to accept us.’” ");
INSERT INTO engerv_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","The messengers came back to Jacob and said, “We went to your brother Esau. He is coming to meet you. He has 400 men with him.” ");
INSERT INTO engerv_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob was very frightened and worried. He divided the people who were with him and all the flocks, herds, and camels into two groups. ");
INSERT INTO engerv_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacob thought, “If Esau comes and destroys one group, the other group can run away and be saved.” ");
INSERT INTO engerv_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Then Jacob said, “God of my father Abraham! God of my father Isaac! LORD, you told me to come back to my country and to my family. You said that you would do good to me. ");
INSERT INTO engerv_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","You have been very kind to me. You did many good things for me. The first time I traveled across the Jordan River, I owned nothing—only my walking stick. But now I own enough things to have two full groups. ");
INSERT INTO engerv_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","I ask you to please save me from my brother Esau. I am afraid that he will come and kill us all, even the mothers with the children. ");
INSERT INTO engerv_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lord, you said to me, ‘I will be good to you. I will increase your family and make your children as many as the sands of the sea. There will be too many to count.’” ");
INSERT INTO engerv_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob stayed in that place for the night. He prepared some things to give to Esau as a gift. ");
INSERT INTO engerv_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","He took 200 female goats and 20 male goats, 200 female sheep and 20 male sheep. ");
INSERT INTO engerv_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","He took 30 camels and their colts, 40 cows and 10 bulls, 20 female donkeys and 10 male donkeys. ");
INSERT INTO engerv_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","He gave each flock of animals to his servants. Then he said to them, “Separate each group of animals. Go ahead of me and keep some space between each herd.” ");
INSERT INTO engerv_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jacob gave them their orders. To the servant with the first group of animals he said, “When Esau my brother comes to you and asks you, ‘Whose animals are these? Where are you going? Whose servant are you?’ ");
INSERT INTO engerv_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","then you should answer, ‘These animals belong to your servant Jacob. He sent them as a gift to you, my master Esau. And he also is coming behind us.’” ");
INSERT INTO engerv_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Jacob also ordered the second servant, the third servant, and all the other servants to do the same thing. He said, “You will say the same thing to Esau when you meet him. ");
INSERT INTO engerv_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","You will say, ‘This is a gift to you, and your servant Jacob is behind us.’” Jacob thought, “If I send these men ahead with gifts, maybe Esau will forgive me and accept me.” ");
INSERT INTO engerv_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","So Jacob sent the gifts to Esau, but he stayed that night in the camp. ");
INSERT INTO engerv_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","During the night, Jacob got up and began moving his two wives, his two maids, and his eleven sons across the Jabbok River at the crossing. ");
INSERT INTO engerv_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","After he sent his family across the river, he sent across everything he had. ");
INSERT INTO engerv_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob was left alone, and a man came and wrestled with him. The man fought with him until the sun came up. ");
INSERT INTO engerv_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","When the man saw that he could not defeat Jacob, he touched Jacob’s leg and put it out of joint. ");
INSERT INTO engerv_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Then the man said to Jacob, “Let me go. The sun is coming up.” But Jacob said, “I will not let you go. You must bless me.” ");
INSERT INTO engerv_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","And the man said to him, “What is your name?” And Jacob said, “My name is Jacob.” ");
INSERT INTO engerv_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Then the man said, “Your name will not be Jacob. Your name will now be Israel. I give you this name because you have fought with God and with men, and you have won.” ");
INSERT INTO engerv_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Then Jacob asked him, “Please tell me your name.” But the man said, “Why do you ask my name?” Then the man blessed Jacob at that place. ");
INSERT INTO engerv_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","So Jacob named that place Peniel. He said, “At this place, I saw God face to face, but my life was spared.” ");
INSERT INTO engerv_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Then the sun came up as Jacob left Peniel. He was limping because of his leg. ");
INSERT INTO engerv_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","So even today, the people of Israel don’t eat the muscle that is on the hip joint, because this is the muscle where Jacob was hurt. ");
INSERT INTO engerv_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob looked and saw Esau coming with 400 men. Jacob divided his family into four groups. Leah and her children were in one group, Rachel and Joseph were in one group, and the two maids and their children were in two groups. ");
INSERT INTO engerv_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Jacob put the maids with their children first. Then he put Leah and her children behind them, and he put Rachel and Joseph in the last place. ");
INSERT INTO engerv_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob himself went out before them. While he was walking toward his brother Esau, he bowed down to the ground seven times. ");
INSERT INTO engerv_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","When Esau saw Jacob, he ran to meet him. He put his arms around Jacob, hugged his neck, and kissed him. Then they both cried. ");
INSERT INTO engerv_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau looked up and saw the women and children. He said, “Who are all these people with you?” Jacob answered, “These are the children that God gave me. God has been good to me.” ");
INSERT INTO engerv_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Then the two maids and the children with them went to Esau. They bowed down before him. ");
INSERT INTO engerv_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Then Leah and the children with her went to Esau and bowed down. And then Rachel and Joseph went to him and bowed down. ");
INSERT INTO engerv_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau said, “Who were all those people I saw while I was coming here? And what were all those animals for?” Jacob answered, “These are my gifts to you so that you might accept me.” ");
INSERT INTO engerv_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","But Esau said, “You don’t have to give me gifts, brother. I have enough for myself.” ");
INSERT INTO engerv_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob said, “No, I beg you! If you really accept me, please accept the gifts I give you. I am very happy to see your face again. It is like seeing the face of God. I am very happy to see that you accept me. ");
INSERT INTO engerv_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","So I beg you to also accept the gifts I give you. God has been very good to me. I have more than I need.” Because Jacob begged Esau to take the gifts, he accepted them. ");
INSERT INTO engerv_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Then Esau said, “Now you can continue your journey. I will go with you.” ");
INSERT INTO engerv_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","But Jacob said to him, “You know that my children are weak. And I must be careful with my flocks and their young animals. If I force them to walk too far in one day, all the animals will die. ");
INSERT INTO engerv_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","So you go on ahead. I will follow you slowly. I will go slowly enough for the cattle and other animals to be safe and so that my children will not get too tired. I will meet you in Seir.” ");
INSERT INTO engerv_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","So Esau said, “Then I will leave some of my men to help you.” But Jacob said, “That is very kind of you, but there is no need to do that.” ");
INSERT INTO engerv_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","So that day Esau started on his trip back to Seir. ");
INSERT INTO engerv_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","But Jacob went to Succoth. There he built a house for himself and small barns for his cattle. That is why the place was named Succoth. ");
INSERT INTO engerv_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob safely ended his trip from Paddan Aram when he came to the town of Shechem in Canaan. He made his camp in a field near the city. ");
INSERT INTO engerv_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","He bought the field where he camped from the family of Hamor, father of Shechem. He paid 100 pieces of silver for it. ");
INSERT INTO engerv_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","He built an altar there to honor God. He named the place “El, the God of Israel.” ");
INSERT INTO engerv_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","One day, Dinah, the daughter of Leah and Jacob, went out to see the women of that place. ");
INSERT INTO engerv_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","She was seen by Shechem, the son of Hamor the Hivite, who ruled that area. Shechem took Dinah and raped her. ");
INSERT INTO engerv_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","But he was so attracted to her that he fell in love and began expressing his feelings to her. ");
INSERT INTO engerv_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","He told his father, “Please get this girl for me so that I can marry her.” ");
INSERT INTO engerv_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob learned that Shechem had done this very bad thing to his daughter. But all his sons were out in the fields with the cattle. So he did nothing until they came home. ");
INSERT INTO engerv_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Then Shechem’s father, Hamor, came out to talk with Jacob. ");
INSERT INTO engerv_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","In the fields Jacob’s sons heard the news about what had happened. They were very angry because Shechem had brought shame to Israel by raping Jacob’s daughter. They came in from the fields as soon as they heard about the terrible thing Shechem had done. ");
INSERT INTO engerv_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","But Hamor talked to Dinah’s brothers and said, “My son Shechem wants Dinah very much. Please let him marry her. ");
INSERT INTO engerv_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","This marriage will show we have a special agreement. Then our men can marry your women, and your men can marry our women. ");
INSERT INTO engerv_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","You can live in the same land with us. You will be free to own the land and to trade here.” ");
INSERT INTO engerv_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shechem also talked to Jacob and to Dinah’s brothers and said, “Please accept me. I will do anything you ask me to do. ");
INSERT INTO engerv_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","I will give you any gift you want if you will only allow me to marry Dinah. I will give you anything you ask, but let me marry her.” ");
INSERT INTO engerv_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jacob’s sons decided to lie to Shechem and his father because Shechem had done such a bad thing to their sister Dinah. ");
INSERT INTO engerv_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","The brothers said to them, “We cannot allow our sister to marry you because you are not yet circumcised. That would bring us shame. ");
INSERT INTO engerv_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","But we will allow you to marry her if you do this one thing: Every man in your town must be circumcised like us. ");
INSERT INTO engerv_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Then your men can marry our women, and our men can marry your women. Then we will become one people. ");
INSERT INTO engerv_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","If you refuse to be circumcised, we will take Dinah away.” ");
INSERT INTO engerv_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","This agreement made Hamor and Shechem very happy. ");
INSERT INTO engerv_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem was very happy to do what Dinah’s brothers asked. Shechem was the most honored man in his family. ");
INSERT INTO engerv_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor and Shechem went to the meeting place of their city. They spoke to the men of the city and said, ");
INSERT INTO engerv_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“These people want to be friends with us. We want to let them live in our land and be at peace with us. We have enough land for all of us. We are free to marry their women, and we are happy to give them our women to marry. ");
INSERT INTO engerv_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","But there is one thing that all our men must agree to do. They must agree to be circumcised as they are. ");
INSERT INTO engerv_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","If we do this, we will become rich from all their cattle and other animals. We should make this agreement with them so that they will stay here with us.” ");
INSERT INTO engerv_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","All the men who heard this in the meeting place agreed with Hamor and Shechem. And every man was circumcised at that time. ");
INSERT INTO engerv_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Three days later the men who were circumcised were still sore. Two of Jacob’s sons, Simeon and Levi, knew that the men would be weak at this time. So they went to the city and killed all the men there. ");
INSERT INTO engerv_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Dinah’s brothers, Simeon and Levi, killed Hamor and his son Shechem. Then they took Dinah out of Shechem’s house and left. ");
INSERT INTO engerv_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob’s sons went to the city and stole everything that was there because of what Shechem had done to their sister. ");
INSERT INTO engerv_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","So the brothers took all their animals, all their donkeys, and everything else in the city and in the fields. ");
INSERT INTO engerv_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","The brothers took everything those people owned. They even took their wives and children. ");
INSERT INTO engerv_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","But Jacob said to Simeon and Levi, “You have caused me a lot of trouble. All the people in this place will hate me. All the Canaanites and the Perizzites will turn against me. There are only a few of us. If the people in this place gather together to fight against us, I will be destroyed. And all our people will be destroyed with me.” ");
INSERT INTO engerv_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","But the brothers said, “Should we let these people treat our sister like a prostitute? They were wrong to do that to our sister!” ");
INSERT INTO engerv_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God said to Jacob, “Go to the town of Bethel. That is where I appeared to you when you were running away from your brother Esau. Live there and make an altar to honor me as El, the God who appeared to you.” ");
INSERT INTO engerv_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Jacob told his family and all the other people with him, “Destroy all these foreign gods that you have. Make yourselves pure. Put on clean clothes. ");
INSERT INTO engerv_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","We will leave here and go to Bethel. There I will build an altar to the God who has always helped me during times of trouble. He has been with me wherever I have gone.” ");
INSERT INTO engerv_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","So the people gave Jacob all the foreign gods they had, and they gave him all the rings they were wearing in their ears. He buried everything under an oak tree near the town called Shechem. ");
INSERT INTO engerv_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Then Jacob and his sons left that place. The people in the surrounding cities wanted to follow and kill them, but God filled them with such great fear that they did not go after them. ");
INSERT INTO engerv_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","So Jacob and his people went to Luz, which is now called Bethel. It is in the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Jacob built an altar there. He named the place “El Bethel.” Jacob chose this name because that is the place where God first appeared to him when he was running from his brother. ");
INSERT INTO engerv_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deborah, Rebekah’s nurse, died there. They buried her under the oak tree at Bethel. They named that place Allon Bacuth. ");
INSERT INTO engerv_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","When Jacob came back from Paddan Aram, God appeared to him again. God blessed Jacob ");
INSERT INTO engerv_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","and said to him, “Your name is Jacob, but I will change that name. You will no longer be called Jacob. Your new name will be Israel.” So God named him Israel. ");
INSERT INTO engerv_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","God said to him, “I am God All-Powerful, and I give you this blessing: Have many children and grow into a great nation. Other nations and other kings will come out of you. ");
INSERT INTO engerv_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","I gave Abraham and Isaac some special land. Now I give the land to you and to all your people who will live after you.” ");
INSERT INTO engerv_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Then God left that place. ");
INSERT INTO engerv_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","Jacob set up a memorial stone there. He made the rock holy by pouring wine and oil on it. This was a special place because God spoke to Jacob there, and Jacob named the place Bethel. ");
INSERT INTO engerv_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jacob and his group left Bethel. Before they came to Ephrath, Rachel began giving birth to her baby. ");
INSERT INTO engerv_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","She was having a lot of trouble with this birth. She was in great pain. When her nurse saw this, she said, “Don’t be afraid, Rachel. You are giving birth to another son.” ");
INSERT INTO engerv_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachel died while giving birth to the son. Before dying, she named the boy Benoni. But Jacob called him Benjamin. ");
INSERT INTO engerv_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel was buried on the road to Ephrath (that is, Bethlehem). ");
INSERT INTO engerv_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob put a special rock on Rachel’s grave to honor her. That special rock is still there today. ");
INSERT INTO engerv_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Then Israel continued his journey. He camped just south of Eder tower. ");
INSERT INTO engerv_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel stayed there for a short time. While he was there, Reuben slept with Israel’s slave woman Bilhah. Israel heard about this, and he was very angry. These are the names of Jacob’s twelve sons: ");
INSERT INTO engerv_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","His firstborn son was Reuben, whose mother was Leah. Jacob’s other sons by Leah were Simeon, Levi, Judah, Issachar, and Zebulun. ");
INSERT INTO engerv_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","His sons by Rachel were Joseph and Benjamin. ");
INSERT INTO engerv_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","His sons by Bilhah, Rachel’s maid, were Dan and Naphtali. ");
INSERT INTO engerv_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","His sons by Zilpah, Leah’s maid, were Gad and Asher. These were Jacob’s sons who were born in Paddan Aram. ");
INSERT INTO engerv_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob went to his father Isaac at Mamre in Kiriath Arba (Hebron). This is where Abraham and Isaac had lived. ");
INSERT INTO engerv_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac lived 180 years. ");
INSERT INTO engerv_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Then Isaac became weak and died and went to be with his people. He had lived a long and full life. His sons Esau and Jacob buried him. ");
INSERT INTO engerv_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","This is the history of the family of Esau (Edom). ");
INSERT INTO engerv_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau married women from the land of Canaan. His wives were Adah, the daughter of Elon the Hittite, Oholibamah, the daughter of Anah, the son of Zibeon the Hivite, and ");
INSERT INTO engerv_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemath, Ishmael’s daughter, the sister of Nebaioth. ");
INSERT INTO engerv_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau and Adah had a son named Eliphaz. Basemath had a son named Reuel. ");
INSERT INTO engerv_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah had three sons: Jeush, Jalam, and Korah. These were Esau’s sons who were born in the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Jacob and Esau’s families became too big for the land in Canaan to support them all, so Esau moved away from his brother Jacob. He took his wives, sons, daughters, all his slaves, cattle and other animals, and everything else that he had gotten in Canaan and moved to the hill country of Seir. (Esau is also named Edom.) ");
INSERT INTO engerv_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau is the father of the people of Edom. These are the names of Esau’s family living in the hill country of Seir: ");
INSERT INTO engerv_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau and Adah’s son was Eliphaz. Esau and Basemath’s son was Reuel. ");
INSERT INTO engerv_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphaz had five sons: Teman, Omar, Zepho, Gatam, and Kenaz. ");
INSERT INTO engerv_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eliphaz also had a slave woman named Timna. Timna and Eliphaz had a son named Amalek. ");
INSERT INTO engerv_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel had four sons: Nahath, Zerah, Shammah, and Mizzah. These were Esau’s grandsons from his wife Basemath. ");
INSERT INTO engerv_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau’s third wife was Oholibamah, the daughter of Anah. (Anah was the son of Zibeon.) Esau and Oholibamah’s children were Jeush, Jalam, and Korah. ");
INSERT INTO engerv_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","These are the family groups that came from Esau: Esau’s first son was Eliphaz. From Eliphaz came Teman, Omar, Zepho, Kenaz, ");
INSERT INTO engerv_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam, and Amalek. All these family groups came from Esau’s wife Adah. ");
INSERT INTO engerv_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau’s son Reuel was the father of these families: Nahath, Zerah, Shammah, and Mizzah. All these families came from Esau’s wife Basemath. ");
INSERT INTO engerv_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau’s wife Oholibamah, daughter of Anah, gave birth to Jeush, Jalam, and Korah. These three men were the leaders of their families. ");
INSERT INTO engerv_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","They were all sons of Esau and leaders of the family groups of Edom. ");
INSERT INTO engerv_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seir, a Horite man, lived in Edom before Esau. These are the sons of Seir: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engerv_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, and Dishan. These sons were all Horite family leaders from Seir in Edom. ");
INSERT INTO engerv_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan was the father of Hori and Heman. (Timna was Lotan’s sister.) ");
INSERT INTO engerv_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal was the father of Alvan, Manahath, Ebal, Shepho, and Onam. ");
INSERT INTO engerv_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon had two sons, Aiah and Anah. Anah is the man who found the springs in the desert while he was caring for his father’s donkeys. ");
INSERT INTO engerv_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah was the father of Dishon and Oholibamah. ");
INSERT INTO engerv_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon had four sons. They were Hemdan, Eshban, Ithran, and Keran. ");
INSERT INTO engerv_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer had three sons. They were Bilhan, Zaavan, and Akan. ");
INSERT INTO engerv_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan had two sons. They were Uz and Aran. ");
INSERT INTO engerv_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","These are the names of the leaders of the Horite families: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO engerv_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer, and Dishan. These men were the leaders of the families that lived in the country of Seir. ");
INSERT INTO engerv_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","At that time there were kings in Edom. Edom had kings a long time before Israel did. ");
INSERT INTO engerv_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela son of Beor was a king who ruled in Edom. He ruled over the city of Dinhabah. ");
INSERT INTO engerv_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","When Bela died, Jobab became king. Jobab was the son of Zerah from Bozrah. ");
INSERT INTO engerv_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","When Jobab died, Husham ruled. Husham was from the land of the Temanites. ");
INSERT INTO engerv_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","When Husham died, Hadad ruled that area. Hadad was the son of Bedad. (He was the man who defeated Midian in the country of Moab.) Hadad was from the city of Avith. ");
INSERT INTO engerv_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","When Hadad died, Samlah ruled that country. Samlah was from Masrekah. ");
INSERT INTO engerv_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","When Samlah died, Shaul ruled that area. Shaul was from Rehoboth by the River. ");
INSERT INTO engerv_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","When Shaul died, Baal Hanan ruled that country. Baal Hanan was the son of Acbor. ");
INSERT INTO engerv_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","When Baal Hanan died, Hadad ruled that country. Hadad was from the city of Pau. His wife’s name was Mehetabel, the daughter of Matred. (Mezahab was Matred’s father.) ");
INSERT INTO engerv_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esau was the father of these Edomite families: Timna, Alvah, Jetheth, Oholibamah, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel, and Iram. Each of these families lived in an area that was called by the same name as their family. ");
INSERT INTO engerv_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob stayed and lived in the land of Canaan. This is the same land where his father had lived. ");
INSERT INTO engerv_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","This is the story of Jacob’s family. Joseph was a young man, 17 years old. His job was to take care of the sheep and the goats. Joseph did this work with his brothers, the sons of Bilhah and Zilpah. (Bilhah and Zilpah were his father’s wives.) Joseph told his father about the bad things that his brothers did. ");
INSERT INTO engerv_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Joseph was born at a time when his father Israel was very old, so Israel loved him more than he loved his other sons. Jacob gave him a special coat, which was long and very beautiful. ");
INSERT INTO engerv_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","When Joseph’s brothers saw that their father loved Joseph more than he loved them, they hated their brother because of this. They refused to say nice things to him. ");
INSERT INTO engerv_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","One time Joseph had a special dream. Later, he told his brothers about this dream, and after that his brothers hated him even more. ");
INSERT INTO engerv_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Joseph said, “I had a dream. ");
INSERT INTO engerv_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","We were all working in the field, tying stacks of wheat together. Then my stack got up. It stood there while all of your stacks of wheat made a circle around mine and bowed down to it.” ");
INSERT INTO engerv_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","His brothers said, “Do you think this means that you will be a king and rule over us?” His brothers hated Joseph more now because of the dreams he had about them. ");
INSERT INTO engerv_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Then Joseph had another dream, and he told his brothers about it. He said, “I had another dream. I saw the sun, the moon, and eleven stars bowing down to me.” ");
INSERT INTO engerv_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Joseph also told his father about this dream, but his father criticized him. His father said, “What kind of dream is this? Do you believe that your mother, your brothers, and I will bow down to you?” ");
INSERT INTO engerv_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Joseph’s brothers continued to be jealous of him, but his father thought about all these things and wondered what they could mean. ");
INSERT INTO engerv_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","One day Joseph’s brothers went to Shechem to care for their father’s sheep. ");
INSERT INTO engerv_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Jacob said to Joseph, “Go to Shechem. Your brothers are there with my sheep.” Joseph answered, “I will go.” ");
INSERT INTO engerv_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","His father said, “Go and see if your brothers are safe. Come back and tell me if my sheep are all fine.” So Joseph’s father sent him from the Valley of Hebron to Shechem. ");
INSERT INTO engerv_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","At Shechem, Joseph got lost. A man found him wandering in the fields. The man said, “What are you looking for?” ");
INSERT INTO engerv_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph answered, “I am looking for my brothers. Can you tell me where they are with their sheep?” ");
INSERT INTO engerv_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","The man said, “They have already gone away. I heard them say that they were going to Dothan.” So Joseph followed his brothers and found them in Dothan. ");
INSERT INTO engerv_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Joseph’s brothers saw him coming from far away. They decided to make a plan to kill him. ");
INSERT INTO engerv_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","They said to each other, “Here comes Joseph the dreamer. ");
INSERT INTO engerv_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","We should kill him now while we can. We could throw his body into one of the empty wells and tell our father that a wild animal killed him. Then we will show him that his dreams are useless.” ");
INSERT INTO engerv_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","But Reuben wanted to save Joseph. He said, “Let’s not kill him. ");
INSERT INTO engerv_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","We can put him into a well without hurting him.” Reuben planned to save Joseph and send him back to his father. ");
INSERT INTO engerv_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","When Joseph came to his brothers, they attacked him and tore off his long and beautiful coat. ");
INSERT INTO engerv_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Then they threw him into an empty well that was dry. ");
INSERT INTO engerv_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","While Joseph was in the well, the brothers sat down to eat. They looked up and saw a group of traders traveling from Gilead to Egypt. Their camels were carrying many different spices and riches. ");
INSERT INTO engerv_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","So Judah said to his brothers, “What profit will we get if we kill our brother and hide his death? ");
INSERT INTO engerv_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","We will profit more if we sell him to these traders. Then we will not be guilty of killing our own brother.” The other brothers agreed. ");
INSERT INTO engerv_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","When the Midianite traders came by, the brothers took Joseph out of the well and sold him to the traders for 20 pieces of silver. The traders took him to Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Reuben had been gone, but when he came back to the well, he saw that Joseph was not there. He tore his clothes to show that he was upset. ");
INSERT INTO engerv_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Reuben went to the brothers and said, “The boy is not in the well! What will I do?” ");
INSERT INTO engerv_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","The brothers killed a goat and put the goat’s blood on Joseph’s beautiful coat. ");
INSERT INTO engerv_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Then the brothers showed the coat to their father. And the brothers said, “We found this coat. Is this Joseph’s coat?” ");
INSERT INTO engerv_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","His father saw the coat and knew that it was Joseph’s. He said, “Yes, that is his! Maybe some wild animal has killed him. My son Joseph has been eaten by a wild animal!” ");
INSERT INTO engerv_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob was so sorry about his son that he tore his clothes. Then Jacob put on special clothes to show that he was sad. He continued to be sad about his son for a long time. ");
INSERT INTO engerv_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","All of Jacob’s sons and daughters tried to comfort him, but Jacob was never comforted. He said, “I will be sad about my son until the day I die.” So Jacob continued to mourn his son Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","The Midianite traders later sold Joseph in Egypt. They sold him to Potiphar, the captain of the Pharaoh’s guards. ");
INSERT INTO engerv_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","About that time, Judah left his brothers and went to stay with a man named Hirah from the town of Adullam. ");
INSERT INTO engerv_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Judah met a Canaanite girl there and married her. The girl’s father was named Shua. ");
INSERT INTO engerv_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","The Canaanite girl gave birth to a son and named him Er. ");
INSERT INTO engerv_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Later, she gave birth to another son and named him Onan. ");
INSERT INTO engerv_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Then she had another son named Shelah. Judah lived in Kezib when his third son was born. ");
INSERT INTO engerv_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah chose a woman named Tamar to be the wife of his first son Er. ");
INSERT INTO engerv_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","But Er did many bad things. The LORD was not happy with him, so the LORD killed him. ");
INSERT INTO engerv_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Then Judah said to Er’s brother Onan, “Go and sleep with your dead brother’s wife. Become like a husband to her. If children are born, they will belong to your brother Er.” ");
INSERT INTO engerv_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan knew that the children from this union would not belong to him. He had sexual relations with Tamar, but he did not allow himself to stay inside her. ");
INSERT INTO engerv_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","This made the LORD angry. So he killed Onan also. ");
INSERT INTO engerv_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Then Judah said to his daughter-in-law Tamar, “Go back to your father’s house. Stay there and don’t marry until my young son Shelah grows up.” Judah was afraid that Shelah would also be killed like his brothers. So Tamar went back to her father’s home. ");
INSERT INTO engerv_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Later, Judah’s wife, the daughter of Shua, died. After Judah’s time of sadness, he went to Timnah with his friend Hirah from Adullam. Judah went to Timnah to have the wool cut from his sheep. ");
INSERT INTO engerv_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar learned that Judah, her father-in-law, was going to Timnah to cut the wool from his sheep. ");
INSERT INTO engerv_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar always wore clothes that showed that she was a widow. So she put on some different clothes and covered her face with a veil. Then she sat down near the road going to Enaim, a town near Timnah. Tamar knew that Judah’s younger son Shelah was now grown up, but Judah would not make plans for her to marry him. ");
INSERT INTO engerv_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah traveled on that road and saw her, but he thought that she was a prostitute. (Her face was covered with a veil like a prostitute.) ");
INSERT INTO engerv_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","So he went to her and said, “Let me have sex with you.” (Judah did not know that she was Tamar, his daughter-in-law.) She said, “How much will you give me?” ");
INSERT INTO engerv_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judah answered, “I will send you a young goat from my flock.” She answered, “I agree to that. But first you must give me something to keep until you send me the goat.” ");
INSERT INTO engerv_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judah asked, “What do you want me to give you as proof that I will send you the goat?” Tamar answered, “Give me your seal and its string and your walking stick.” Judah gave these things to her. Then Judah and Tamar had sexual relations, and she became pregnant. ");
INSERT INTO engerv_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Then Tamar went home, took off her veil that covered her face, and again put on the special clothes that showed she was a widow. ");
INSERT INTO engerv_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Later, Judah sent his friend Hirah to Enaim to give the prostitute the goat he promised. Judah also told Hirah to get the special seal and the walking stick from her, but Hirah could not find her. ");
INSERT INTO engerv_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","He asked some of the men at the town of Enaim, “Where is the prostitute who was here by the road?” The men answered, “There has never been a prostitute here.” ");
INSERT INTO engerv_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","So Judah’s friend went back to Judah and said, “I could not find the woman. The men who live in that place said that there was never a prostitute there.” ");
INSERT INTO engerv_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","So Judah said, “Let her keep the things. I don’t want people to laugh at us. I tried to give her the goat, but we could not find her. That is enough.” ");
INSERT INTO engerv_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","About three months later, someone told Judah, “Your daughter-in-law Tamar sinned like a prostitute, and now she is pregnant.” Then Judah said, “Take her out and burn her.” ");
INSERT INTO engerv_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","The men went to Tamar to kill her, but she sent a message to her father-in-law that said, “The man who made me pregnant is the man who owns these things. Look at them. Whose are they? Whose special seal and string is this? Whose walking stick is this?” ");
INSERT INTO engerv_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah recognized these things and said, “She is right. I was wrong. I did not give her my son Shelah like I promised.” And Judah did not sleep with her again. ");
INSERT INTO engerv_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","The time came for Tamar to give birth. She was going to have twins. ");
INSERT INTO engerv_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","While she was giving birth, one baby put his hand out. The nurse tied a red string on the hand and said, “This baby was born first.” ");
INSERT INTO engerv_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","But that baby pulled his hand back in, so the other baby was born first. So the nurse said, “You were able to break out first!” So they named him Perez. ");
INSERT INTO engerv_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","After this, the other baby was born. This was the baby with the red string on his hand. They named him Zerah. ");
INSERT INTO engerv_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","The traders who bought Joseph took him down to Egypt. They sold him to the captain of Pharaoh’s guard, Potiphar. ");
INSERT INTO engerv_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","The LORD helped Joseph become a successful man. Joseph lived in the house of his master, Potiphar the Egyptian. ");
INSERT INTO engerv_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar saw that the LORD was with Joseph and that the LORD helped Joseph be successful in everything he did. ");
INSERT INTO engerv_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","So Potiphar was very happy with Joseph. He allowed Joseph to work for him and to help him rule the house. Joseph was the ruler over everything Potiphar owned. ");
INSERT INTO engerv_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","After Joseph was made the ruler over the house, the LORD blessed the house and everything that Potiphar owned. The LORD also blessed everything that grew in Potiphar’s fields. The Lord did this because of Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","So Potiphar allowed Joseph to take responsibility for everything in the house. Potiphar didn’t have to worry about anything except deciding what to eat. Joseph was a very handsome, good-looking man. ");
INSERT INTO engerv_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","After some time, the wife of Joseph’s master began to pay special attention to him. One day she said to him, “Sleep with me.” ");
INSERT INTO engerv_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","But Joseph refused. He said, “My master trusts me with everything in his house. He has given me responsibility for everything here. ");
INSERT INTO engerv_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","My master has made me almost equal to him in his house. I cannot sleep with his wife! That is wrong! It is a sin against God.” ");
INSERT INTO engerv_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","The woman talked with Joseph every day, but he refused to sleep with her. ");
INSERT INTO engerv_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","One day Joseph went into the house to do his work. He was the only man in the house at the time. ");
INSERT INTO engerv_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","His master’s wife grabbed his coat and said to him, “Come to bed with me.” But Joseph ran out of the house so fast that he left his coat in her hand. ");
INSERT INTO engerv_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","The woman saw that Joseph had left his coat in her hand and had run out of the house. ");
INSERT INTO engerv_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","She called to the men outside and said, “Look! This Hebrew slave was brought here to make fun of us. He came in and tried to attack me, but I screamed. ");
INSERT INTO engerv_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","My scream scared him and he ran away, but he left his coat with me.” ");
INSERT INTO engerv_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Then she kept his coat until her husband, Joseph’s master, came home. ");
INSERT INTO engerv_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","She told her husband the same story. She said, “This Hebrew slave you brought here tried to attack me! ");
INSERT INTO engerv_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","But when he came near me, I screamed. He ran away, but he left his coat.” ");
INSERT INTO engerv_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Joseph’s master listened to what his wife said, and he became very angry. ");
INSERT INTO engerv_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","So Potiphar put Joseph into the prison where the king’s enemies were held, and that is where Joseph remained. ");
INSERT INTO engerv_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","The LORD was with Joseph and continued to show his kindness to him, so the commander of the prison guards began to like Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","The commander of the guards put Joseph in charge of all the prisoners. Joseph was their leader, but he still did the same work they did. ");
INSERT INTO engerv_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","The commander of the guards trusted Joseph with everything that was in the prison. This happened because the LORD was with Joseph. The LORD helped Joseph be successful in everything he did. ");
INSERT INTO engerv_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Later, two of Pharaoh’s servants did something wrong to Pharaoh. These servants were the baker and the man who served wine to Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaoh became angry with his baker and wine server, ");
INSERT INTO engerv_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","so he put them in the same prison as Joseph. Potiphar, the commander of Pharaoh’s guards, was in charge of this prison. ");
INSERT INTO engerv_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","The commander put the two prisoners under Joseph’s care. The two men continued to stay in prison for some time. ");
INSERT INTO engerv_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","One night both of the prisoners had a dream. The baker and the wine server each had his own dream, and each dream had its own meaning. ");
INSERT INTO engerv_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph went to them the next morning and saw that the two men were worried. ");
INSERT INTO engerv_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","He asked them, “Why do you look so worried today?” ");
INSERT INTO engerv_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","The two men answered, “We both had dreams last night, but we don’t understand what we dreamed. There is no one to explain the dreams to us.” Joseph said to them, “God is the only one who can understand and explain dreams. So I beg you, tell me your dreams.” ");
INSERT INTO engerv_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","So the wine server told Joseph his dream. The server said, “I dreamed I saw a vine. ");
INSERT INTO engerv_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","On the vine there were three branches. I watched the branches grow flowers and then become grapes. ");
INSERT INTO engerv_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","I was holding Pharaoh’s cup, so I took the grapes and squeezed the juice into the cup. Then I gave the cup to Pharaoh.” ");
INSERT INTO engerv_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Then Joseph said, “I will explain the dream to you. The three branches mean three days. ");
INSERT INTO engerv_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Before the end of three days, Pharaoh will forgive you and allow you to go back to your work. You will do the same work for Pharaoh as you did before. ");
INSERT INTO engerv_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","But when you are free, remember me. Be good to me and help me. Tell Pharaoh about me so that I can get out of this prison. ");
INSERT INTO engerv_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","I was kidnapped and taken from the land of my people, the Hebrews. I have done nothing wrong! I should not be in prison.” ");
INSERT INTO engerv_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","The baker saw that the other servant’s dream was good, so he said to Joseph, “I also had a dream. I dreamed there were three baskets of bread on my head. ");
INSERT INTO engerv_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","In the top basket there were all kinds of baked food for the king, but birds were eating this food.” ");
INSERT INTO engerv_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph answered, “I will tell you what the dream means. The three baskets mean three days. ");
INSERT INTO engerv_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Before the end of three days, the king will take you out of this prison and cut off your head! He will hang your body on a pole, and the birds will eat it.” ");
INSERT INTO engerv_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Three days later it was Pharaoh’s birthday. He gave a party for all his servants. At the party Pharaoh allowed the wine server and the baker to leave the prison. ");
INSERT INTO engerv_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","He freed the wine server and gave him his job back, and once again the wine server put a cup of wine in Pharaoh’s hand. ");
INSERT INTO engerv_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","But Pharaoh hanged the baker, and everything happened the way Joseph said it would. ");
INSERT INTO engerv_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","But the wine server did not remember to help Joseph. He said nothing about him to Pharaoh. The wine server forgot about Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Two years later Pharaoh dreamed that he was standing by the Nile River. ");
INSERT INTO engerv_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","In the dream, seven cows came out of the river and stood there eating grass. They were healthy, good-looking cows. ");
INSERT INTO engerv_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Then seven more cows came out of the river and stood on the bank of the river by the healthy cows. But these cows were thin and looked sick. ");
INSERT INTO engerv_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","The seven sick cows ate the seven healthy cows. Then Pharaoh woke up. ");
INSERT INTO engerv_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pharaoh went back to sleep and began dreaming again. This time he dreamed that he saw seven heads of grain growing on one plant. They were healthy and full of grain. ");
INSERT INTO engerv_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Then he saw seven more heads of grain sprouting, but they were thin and scorched by the hot wind. ");
INSERT INTO engerv_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","The thin heads of grain ate the seven good heads of grain. Then Pharaoh woke up again and realized it was only a dream. ");
INSERT INTO engerv_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","The next morning Pharaoh was worried about these dreams, so he sent for all the magicians and wise men of Egypt. Pharaoh told these men the dreams, but none of them could explain the dreams. ");
INSERT INTO engerv_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Then the wine servant remembered Joseph and said to Pharaoh, “I remember something that happened to me. ");
INSERT INTO engerv_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","You were angry with the baker and me, and you put us in prison. ");
INSERT INTO engerv_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Then one night he and I had a dream. Each dream had a different meaning. ");
INSERT INTO engerv_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","There was a young Hebrew man in prison with us. He was a servant of the commander of the guards. We told him our dreams, and he explained them to us. He told us the meaning of each dream, ");
INSERT INTO engerv_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","and what he said came true. He said I would be free and have my old job back, and it happened. He also said the baker would die, and it happened!” ");
INSERT INTO engerv_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","So Pharaoh called Joseph from the prison. The guards quickly got Joseph out of prison. Joseph shaved, put on some clean clothes, and went to see Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh said to Joseph, “I had a dream, and no one can explain it for me. I heard that you can explain dreams when someone tells you about them.” ");
INSERT INTO engerv_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph answered, “I cannot! But God can explain the dream for you, Pharaoh.” ");
INSERT INTO engerv_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Then Pharaoh said to Joseph, “In my dream I was standing by the Nile River. ");
INSERT INTO engerv_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Seven cows came up out of the river and stood there eating the grass. They were healthy, good-looking cows. ");
INSERT INTO engerv_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Then I saw seven more cows come up out of the river after them, but these cows were thin and looked sick. They were the worst cows I had ever seen anywhere in Egypt! ");
INSERT INTO engerv_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","The thin, sick cows ate the first healthy cows, ");
INSERT INTO engerv_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","but they still looked thin and sick. You couldn’t even tell they had eaten the healthy cows. They looked as thin and sick as they did in the beginning. Then I woke up. ");
INSERT INTO engerv_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“In my next dream I saw seven heads of grain growing on one plant. They were healthy and full of grain. ");
INSERT INTO engerv_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","And then seven more heads of grain grew after them, but they were thin and scorched by the hot wind. ");
INSERT INTO engerv_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Then the thin heads of grain ate the seven good heads of grain. “I told these dreams to my magicians. But no one could explain the dreams to me. What do they mean?” ");
INSERT INTO engerv_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Then Joseph said to Pharaoh, “Both of these dreams have the same meaning. God is telling you what will happen soon. ");
INSERT INTO engerv_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","The seven good cows and the seven good heads of grain are seven good years. ");
INSERT INTO engerv_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","And the seven thin, sick-looking cows and the seven thin heads of grain mean that there will be seven years of hunger in this area. These seven bad years will come after the seven good years. ");
INSERT INTO engerv_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","God has shown you what will happen soon. He will make these things happen just as I told you. ");
INSERT INTO engerv_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","For seven years there will be plenty of food in Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","But then there will be seven years of hunger. The people will forget how much food there had been in Egypt before. This famine will ruin the country. ");
INSERT INTO engerv_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","It will be so bad that people will forget what it was like to have plenty of food. ");
INSERT INTO engerv_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“Pharaoh, you had two dreams about the same thing. That means God wanted to show you that he really will make this happen, and he will make it happen soon! ");
INSERT INTO engerv_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","So, Pharaoh, you should choose a wise, intelligent man and put him in charge of Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Then you should choose other men to collect food from the people. During the seven good years, the people must give them one-fifth of all the food they grow. ");
INSERT INTO engerv_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","In this way these men will collect all the food during the seven good years and store it in the cities until it is needed. Pharaoh, this food will be under your control. ");
INSERT INTO engerv_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Then during the seven years of hunger, there will be food for the country of Egypt. And Egypt will not be destroyed by the famine.” ");
INSERT INTO engerv_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","This seemed like a very good idea to Pharaoh, and all his officials agreed. ");
INSERT INTO engerv_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Then Pharaoh told them, “I don’t think we can find anyone better than Joseph to take this job! God’s Spirit is in him, making him very wise!” ");
INSERT INTO engerv_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","So Pharaoh said to Joseph, “God showed these things to you, so you must be the wisest man. ");
INSERT INTO engerv_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","I will put you in charge of my country, and the people will obey all your commands. I will be the only one more powerful than you.” ");
INSERT INTO engerv_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaoh said to Joseph, “I now make you governor over all of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Then Pharaoh gave his special ring to Joseph. The royal seal was on this ring. Pharaoh also gave Joseph a fine linen robe and put a gold chain around his neck. ");
INSERT INTO engerv_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Then he told Joseph to ride in his second chariot. Pharaoh’s officials said, “Let him be the governor over the whole land of Egypt!” ");
INSERT INTO engerv_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Then Pharaoh said to him, “I am Pharaoh, the king over everyone in Egypt, but no one else in Egypt can lift a hand or move a foot unless you say he can.” ");
INSERT INTO engerv_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Then Pharaoh gave Joseph another name, Zaphenath Paneah. He also gave Joseph a wife named Asenath. She was the daughter of Potiphera, a priest in the city of On. So Joseph became the governor over the whole country of Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph was 30 years old when he began serving the king of Egypt. He traveled throughout the country of Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","During the seven good years, the crops in Egypt grew very well. ");
INSERT INTO engerv_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph saved the food in Egypt during those seven years and stored the food in the cities. In every city he stored grain that grew in the fields around the city. ");
INSERT INTO engerv_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph stored so much grain that it was like the sands of the sea. He stored so much grain that it could not be measured. ");
INSERT INTO engerv_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Joseph’s wife, Asenath, was the daughter of Potiphera, the priest in the city of On. Before the first year of hunger came, Joseph and Asenath had two sons. ");
INSERT INTO engerv_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph named the first son Manasseh. He was given this name because Joseph said, “God made me forget all my hard work and everything back home in my father’s house.” ");
INSERT INTO engerv_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Joseph named the second son Ephraim. Joseph gave him this name because he said, “I had great troubles, but God has made me successful in everything.” ");
INSERT INTO engerv_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","For seven years people had all the food they needed, but those years ended. ");
INSERT INTO engerv_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Then the seven years of hunger began, just as Joseph had said. No food grew anywhere in any of the countries in that area. But in Egypt people had plenty to eat because Joseph had stored the grain. ");
INSERT INTO engerv_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","The famine began, and the people cried to Pharaoh for food. Pharaoh said to the Egyptian people, “Go ask Joseph what to do.” ");
INSERT INTO engerv_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","There was famine everywhere, so Joseph gave the people grain from the warehouses. He sold the stored grain to the people of Egypt. The famine was bad in Egypt, ");
INSERT INTO engerv_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","but the famine was bad everywhere. So people from the countries around Egypt had to come to Joseph in Egypt to buy grain. ");
INSERT INTO engerv_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","During the famine in Canaan, Jacob learned that there was grain in Egypt. So he said to his sons, “Why are you sitting here doing nothing? ");
INSERT INTO engerv_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","I have heard that there is grain for sale in Egypt. Go there and buy grain for us so that we will live and not die!” ");
INSERT INTO engerv_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","So ten of Joseph’s brothers went to Egypt to buy grain. ");
INSERT INTO engerv_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jacob did not send Benjamin. (Benjamin was Joseph’s only full brother.) Jacob was afraid that something bad might happen to Benjamin. ");
INSERT INTO engerv_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","The famine was very bad in Canaan, so there were many people from Canaan who went to Egypt to buy grain. Among them were the sons of Israel. ");
INSERT INTO engerv_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph was the governor of Egypt at the time. He was the one who checked the sale of grain to people who came to Egypt to buy it. Joseph’s brothers came to him and bowed before him. ");
INSERT INTO engerv_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph saw his brothers and recognized them, but he acted like he didn’t know them. He was rude when he spoke to them. He said, “Where do you come from?” The brothers answered, “We have come from the land of Canaan to buy food.” ");
INSERT INTO engerv_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph recognized his brothers, but they did not know who he was. ");
INSERT INTO engerv_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Then Joseph remembered the dreams that he had dreamed about his brothers. Joseph said to his brothers, “You have not come to buy food! You are spies. You came to learn where we are weak.” ");
INSERT INTO engerv_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","But the brothers said to him, “No, sir, we come as your servants. We have come only to buy food. ");
INSERT INTO engerv_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","We are all brothers—we all have the same father. We are honest men. We have come only to buy food.” ");
INSERT INTO engerv_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Then Joseph said to them, “No, you have come to spy on us!” ");
INSERT INTO engerv_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","And the brothers said, “No, sir, we come as servants from Canaan. We are all brothers, sons of the same father. There were twelve brothers in our family. Our youngest brother is still at home with our father, and the other brother died a long time ago.” ");
INSERT INTO engerv_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","But Joseph said to them, “No! I can see that I am right. You are spies. ");
INSERT INTO engerv_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","But I will let you prove that you are telling the truth. In the name of Pharaoh, I swear that I will not let you go until your youngest brother comes here. ");
INSERT INTO engerv_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","One of you must go back to get your youngest brother while the rest of you stay here in prison. Then we can prove whether you are telling the truth or not. If you are not telling the truth, then by Pharaoh, I swear that you are spies!” ");
INSERT INTO engerv_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Then Joseph put them all in prison for three days. ");
INSERT INTO engerv_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","After three days Joseph said to them, “I am a God-fearing man. Do this, and I will let you live. ");
INSERT INTO engerv_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","If you are honest men, one of your brothers can stay here in prison, and the others can go and carry grain back to your people. ");
INSERT INTO engerv_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","But then you must bring your youngest brother back here to me. Then I will know that you are telling the truth, and you will not have to die.” The brothers agreed to this. ");
INSERT INTO engerv_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","They said to each other, “We are being punished for the bad thing we did to our younger brother Joseph. We saw the trouble he was in. He begged us to save him, but we refused to listen. So now we are in trouble.” ");
INSERT INTO engerv_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Then Reuben said to them, “I told you not to do anything bad to that boy, but you refused to listen to me. Now we are being punished for his death.” ");
INSERT INTO engerv_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","24","Joseph was using an interpreter to talk to his brothers, so the brothers did not know that he understood their language. He heard and understood everything they said, and that made him want to cry. So he turned away and left the room. When he came back, he took one of the brothers, Simeon, and tied him up while the others watched. ");
INSERT INTO engerv_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph told the servants to fill the bags with grain. The brothers had given Joseph the money for the grain, but he didn’t keep the money. He put the money in their bags of grain. Then he gave them what they would need for their trip back home. ");
INSERT INTO engerv_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","So the brothers put the grain on their donkeys and left. ");
INSERT INTO engerv_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","That night the brothers stopped at a place to spend the night. One of the brothers opened his sack to get some grain for his donkey. And there in the sack, he saw his money! ");
INSERT INTO engerv_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","He said to the other brothers, “Look! Here is the money I paid for the grain. Someone put the money back in my sack.” The brothers were very afraid. They said to one another, “What is God doing to us?” ");
INSERT INTO engerv_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","The brothers went back to their father Jacob in the land of Canaan. They told him about everything that had happened. ");
INSERT INTO engerv_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","They said, “The governor of that country spoke rudely to us. He thought that we were spies! ");
INSERT INTO engerv_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","We told him, ‘We are honest men, not spies. ");
INSERT INTO engerv_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","There are twelve of us brothers, all from the same father. But one of our brothers is no longer living, and the youngest is still at home with our father in Canaan.’ ");
INSERT INTO engerv_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Then the governor of that country said to us, ‘Here is a way to prove that you are honest men: Leave one of your brothers here with me. Take your grain back to your families. ");
INSERT INTO engerv_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Bring your youngest brother to me. Then I will know if you are honest men or if you were sent from an army to destroy us. If you are telling the truth, I will give your brother back to you. I will give him to you, and you will be free to buy grain in our country.’” ");
INSERT INTO engerv_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Then the brothers started taking the grain out of their sacks, and every brother found his bag of money in his sack of grain. When the brothers and their father saw the money, they were afraid. ");
INSERT INTO engerv_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob said to them, “Do you want me to lose all of my children? Joseph is gone. Simeon is gone, and now you want to take Benjamin away too!” ");
INSERT INTO engerv_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","But Reuben said to his father, “Father, you may kill my two sons if I don’t bring Benjamin back to you. Trust me. I will bring him back to you.” ");
INSERT INTO engerv_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","But Jacob said, “I will not let Benjamin go with you. His brother is dead, and he is the only son left from my wife Rachel. It would kill me if anything happened to him during the trip to Egypt. You would send me to the grave a very sad, old man.” ");
INSERT INTO engerv_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","The famine was very bad in that country. ");
INSERT INTO engerv_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","The people ate all the grain they had brought from Egypt. When that grain was gone, Jacob said to his sons, “Go to Egypt and buy some more grain for us to eat.” ");
INSERT INTO engerv_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","But Judah said to Jacob, “But the governor of that country warned us. He said, ‘If you don’t bring your brother back to me, I will refuse to talk to you.’ ");
INSERT INTO engerv_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","If you send Benjamin with us, we will go down and buy grain. ");
INSERT INTO engerv_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","But if you refuse to send Benjamin, we will not go. The man warned us to not come back without him.” ");
INSERT INTO engerv_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel said, “Why did you tell him you had another brother? Why did you do such a bad thing to me?” ");
INSERT INTO engerv_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","The brothers answered, “He asked lots of questions. He wanted to know all about us and about our family. He asked us, ‘Is your father still alive? Do you have another brother at home?’ We only answered his questions. We didn’t know he would ask us to bring our brother to him!” ");
INSERT INTO engerv_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Then Judah said to his father Israel, “Let Benjamin go with me. I will take care of him. We have to go to Egypt to get food. If we don’t go, we will all die—including our children. ");
INSERT INTO engerv_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","I will make sure he is safe. I will be responsible for him. If I don’t bring him back to you, you can blame me forever. ");
INSERT INTO engerv_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","If you had let us go before, we could have already made two trips for food.” ");
INSERT INTO engerv_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Then their father Israel said, “If it is really true, take Benjamin with you. But take some gifts to the governor. Take some of the things we have been able to gather in our land. Take him some honey, pistachio nuts, almonds, spices, and myrrh. ");
INSERT INTO engerv_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Take twice as much money with you this time. Take the money that was given back to you after you paid last time. Maybe the governor made a mistake. ");
INSERT INTO engerv_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Take Benjamin, and go back to the man. ");
INSERT INTO engerv_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","I pray that God All-Powerful will help you when you stand before the governor. I pray that he will let Benjamin, and also Simeon, come back safely. If not, I will again be sad from losing my children.” ");
INSERT INTO engerv_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","So the brothers took the gifts to give to the governor. And the brothers took twice as much money with them as they took the first time. This time Benjamin went with the brothers to Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","When Joseph saw Benjamin with them, he said to his servant, “Bring these men into my house. Kill an animal and cook it. They will eat with me at noon today.” ");
INSERT INTO engerv_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","The servant did as he was told. He brought the men into Joseph’s house. ");
INSERT INTO engerv_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","The brothers were afraid when they were taken to Joseph’s house and said, “We have been brought here because of the money that was put back in our sacks the last time. They will use this as proof against us and steal our donkeys and make us slaves.” ");
INSERT INTO engerv_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","So the brothers went to the servant in charge of Joseph’s house. ");
INSERT INTO engerv_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","They said, “Sir, I promise this is the truth. The last time we came, we came to buy food. ");
INSERT INTO engerv_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","On the way home, we opened our sacks and found our money in every sack. We don’t know how it got there, but we brought that money with us to give it back to you. And we have brought more money to pay for the food that we want to buy this time.” ");
INSERT INTO engerv_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","But the servant answered, “Don’t be afraid; believe me. Your God, the God of your father, must have put the money in your sack as a gift. I remember that you paid me for the grain the last time.” Then the servant brought Simeon out of the prison. ");
INSERT INTO engerv_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","The servant led the men into Joseph’s house. He gave them water, and they washed their feet. Then he fed their donkeys. ");
INSERT INTO engerv_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","The brothers heard that they were going to eat with Joseph, so they worked until noon preparing their gifts for him. ");
INSERT INTO engerv_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","When Joseph came home, the brothers gave him the gifts they had brought with them. Then they bowed down to the ground in front of him. ");
INSERT INTO engerv_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joseph asked them how they were doing. He said, “How is your elderly father you told me about. Is he still alive and well?” ");
INSERT INTO engerv_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","The brothers answered, “Yes, sir, our father is still alive.” And they again bowed before Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Then Joseph saw his brother Benjamin. (Benjamin and Joseph had the same mother.) Joseph said, “Is this your youngest brother that you told me about?” Then Joseph said to Benjamin, “God bless you, my son!” ");
INSERT INTO engerv_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph felt a strong desire to show his brother Benjamin that he loved him. He was about to cry and didn’t want his brothers to see him, so he ran into his private room and cried there. ");
INSERT INTO engerv_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Then Joseph washed his face and came out. He regained control of himself and said, “Now it is time to eat.” ");
INSERT INTO engerv_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","The servants seated Joseph at a table by himself. His brothers were at another table by themselves, and the Egyptians were at a table by themselves. The Egyptians believed that it was wrong for them to eat with Hebrews. ");
INSERT INTO engerv_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Joseph’s brothers were seated at a table facing him. The brothers were looking at each other because, to their surprise, they had been seated in order, from the oldest to the youngest. ");
INSERT INTO engerv_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Servants were taking food from Joseph’s table and bringing it to them. But the servants gave Benjamin five times more than the others. The brothers continued to eat and drink with Joseph until they were drunk. ");
INSERT INTO engerv_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Then Joseph gave a command to his servant. He said, “Fill the men’s sacks with as much grain as they can carry. Then put each man’s money into his sack with the grain. ");
INSERT INTO engerv_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Put the youngest brother’s money in his sack too. But also put my special silver cup in his sack.” So the servant obeyed Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Early the next morning the brothers and their donkeys were sent back to their country. ");
INSERT INTO engerv_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","After they had left the city, Joseph said to his servant, “Go and follow the men. Stop them and say to them, ‘We were good to you! So why have you been bad to us? Why did you steal my master’s silver cup? ");
INSERT INTO engerv_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","My master drinks from that cup, and he uses it to learn secret things. What you did was wrong!’” ");
INSERT INTO engerv_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","So the servant obeyed. He rode out to the brothers and stopped them. The servant said to them what Joseph had told him to say. ");
INSERT INTO engerv_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","But the brothers said to the servant, “Why does the governor say these things? We wouldn’t do anything like that! ");
INSERT INTO engerv_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","We brought back the money that we found in our sacks before. So surely we wouldn’t steal silver or gold from your master’s house. ");
INSERT INTO engerv_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","If you find the silver cup in any of our sacks, let that man die. You can kill him, and we will be your slaves.” ");
INSERT INTO engerv_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","The servant said, “I agree, except that only the man who is found to have the cup will be my slave. The others will be free.” ");
INSERT INTO engerv_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Then every brother quickly opened his sack on the ground. ");
INSERT INTO engerv_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","The servant started looking in the sacks. He started with the oldest brother and ended with the youngest. He found the cup in Benjamin’s sack. ");
INSERT INTO engerv_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","The brothers were very sad. They tore their clothes to show their sadness. They put their sacks back on the donkeys and went back to the city. ");
INSERT INTO engerv_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","When Judah and his brothers went back to Joseph’s house, Joseph was still there. The brothers fell to the ground and bowed down before him. ");
INSERT INTO engerv_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph said to them, “Why have you done this? Didn’t you know that I have a special way of learning secrets? No one is better at this than I am!” ");
INSERT INTO engerv_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah said, “Sir, there is nothing we can say. There is no way to explain. There is no way to show that we are not guilty. God has judged us guilty for something else we have done. So all of us, even Benjamin, will be your slaves.” ");
INSERT INTO engerv_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","But Joseph said, “I will not make you all slaves! Only the man who stole the cup will be my slave. You others can go in peace to your father.” ");
INSERT INTO engerv_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Then Judah went to Joseph and said, “Sir, please let me speak plainly with you. Please don’t be angry with me. I know that you are like Pharaoh himself. ");
INSERT INTO engerv_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","When we were here before, you asked us, ‘Do you have a father or a brother?’ ");
INSERT INTO engerv_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","And we answered you, ‘We have a father—he is an old man. And we have a younger brother. Our father loves him because he was born while our father was old. This youngest son’s brother is dead, so he is the only son who is left from that mother. Our father loves him very much.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Then you said to us, ‘Bring that brother to me. I want to see him.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","And we said to you, ‘That young boy cannot come. He cannot leave his father. If his father loses him, his father will be so sad that he will die.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","But you said to us, ‘You must bring your youngest brother, or I will not sell you grain again.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","So we went back to our father and told him what you said. ");
INSERT INTO engerv_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Later, our father said, ‘Go back and buy us some more food.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","We said to our father, ‘We cannot go without our youngest brother. The governor said he will not sell us grain again until he sees our youngest brother.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Then my father said to us, ‘You know that my wife Rachel gave me two sons. ");
INSERT INTO engerv_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","I let one son go away, and he was killed by a wild animal. And I haven’t seen him since. ");
INSERT INTO engerv_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","If you take my other son away from me, and something happens to him, I will be sad enough to die.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Now, imagine what will happen when we go home without our youngest brother—he is the most important thing in our father’s life! ");
INSERT INTO engerv_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Our father will die if he sees that the boy isn’t with us—and it will be our fault. We will send our father to his grave a very sad man. ");
INSERT INTO engerv_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“I took responsibility for the young boy. I told my father, ‘If I don’t bring him back to you, you can blame me for the rest of my life.’ ");
INSERT INTO engerv_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","So now I beg you, please let the boy go back with his brothers, and I will stay and be your slave. ");
INSERT INTO engerv_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","I cannot go back to my father if the boy is not with me. I am very afraid of what would happen to my father.” ");
INSERT INTO engerv_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph could not control himself any longer. He cried in front of all the people who were there. Joseph said, “Tell everyone to leave here.” So all the people left. Only the brothers were left with Joseph. Then he told them who he was. ");
INSERT INTO engerv_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Joseph continued to cry, and all the Egyptian people in Pharaoh’s house heard it. ");
INSERT INTO engerv_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","He said to his brothers, “I am your brother Joseph. Is my father doing well?” But the brothers did not answer him because they were confused and afraid. ");
INSERT INTO engerv_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","So Joseph said to his brothers again, “Come here to me. I beg you, come here.” When the brothers went to him, he said to them, “I am your brother Joseph. I am the one you sold as a slave to Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Now don’t be worried. Don’t be angry with yourselves for what you did. It was God’s plan for me to come here. I am here to save people’s lives. ");
INSERT INTO engerv_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","This terrible famine has continued for two years now, and there will be five more years without planting or harvest. ");
INSERT INTO engerv_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","So God sent me here ahead of you so that I can save your people in this country. ");
INSERT INTO engerv_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","It was not your fault that I was sent here. It was God’s plan. God made me like a father to Pharaoh. I am the governor over all his house and over all Egypt.” ");
INSERT INTO engerv_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Joseph said, “Hurry up and go to my father. Tell him his son Joseph sent this message: ‘God made me the governor of Egypt. So come here to me quickly. Don’t wait. ");
INSERT INTO engerv_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","You can live near me in the land of Goshen. You, your children, your grandchildren, and all of your animals are welcome here. ");
INSERT INTO engerv_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I will take care of you during the next five years of hunger. So you and your family will not lose everything you own.’ ");
INSERT INTO engerv_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Surely you can see that I really am Joseph. Even my brother Benjamin knows it is me, your brother, talking to you. ");
INSERT INTO engerv_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","So tell my father about the honor I have received here in Egypt. Tell him about everything you have seen here. Now hurry, go bring my father back to me.” ");
INSERT INTO engerv_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Then Joseph hugged his brother Benjamin, and they both began crying. ");
INSERT INTO engerv_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Then Joseph cried as he kissed all his brothers. After this, the brothers began talking with him. ");
INSERT INTO engerv_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Pharaoh learned that Joseph’s brothers had come to him. This news spread throughout Pharaoh’s house. Pharaoh and his servants were very excited! ");
INSERT INTO engerv_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","So Pharaoh told Joseph, “Tell your brothers to take all the food they need and go back to the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Tell them to bring your father and their families back here to me. I will give you the best land in Egypt to live on. And your family can eat the best food we have here. ");
INSERT INTO engerv_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Also give your brothers some of our best wagons. Tell them to go to Canaan and bring your father and all the women and children back in the wagons. ");
INSERT INTO engerv_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Don’t worry about bringing all of their belongings. We can give them the best of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","So the sons of Israel did this. Joseph gave them good wagons just as Pharaoh had promised. And Joseph gave them enough food for their trip. ");
INSERT INTO engerv_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","He gave each brother a suit of beautiful clothes. But to Benjamin he gave five suits of beautiful clothes and 300 pieces of silver. ");
INSERT INTO engerv_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Joseph also sent gifts to his father. He sent ten donkeys with bags full of many good things from Egypt. And he sent ten female donkeys loaded with grain, bread, and other food for his father on his trip back. ");
INSERT INTO engerv_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Then Joseph told his brothers to go. While they were leaving, he said to them, “Go straight home, and don’t fight on the way.” ");
INSERT INTO engerv_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","So the brothers left Egypt and went to their father in the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","They told him, “Father, Joseph is still alive! And he is the governor over the whole country of Egypt.” Their father did not know what to think. At first he didn’t believe them. ");
INSERT INTO engerv_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","But then they told him everything Joseph had said. Then their father saw the wagons that Joseph had sent to bring him back to Egypt, and he became excited and very happy. ");
INSERT INTO engerv_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel said, “Now I believe you. My son Joseph is still alive! I am going to see him before I die!” ");
INSERT INTO engerv_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","So Israel began his trip to Egypt. First he went to Beersheba. There he worshiped God, the God of his father Isaac. He offered sacrifices. ");
INSERT INTO engerv_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","During the night God spoke to Israel in a dream and said, “Jacob, Jacob.” Israel answered, “Here I am.” ");
INSERT INTO engerv_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Then God said, “I am God, the God of your father. Don’t be afraid to go to Egypt. In Egypt I will make you a great nation. ");
INSERT INTO engerv_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","I will go to Egypt with you, and I will bring you out of Egypt again. You will die there, but Joseph will be with you. His own hands will close your eyes when you die.” ");
INSERT INTO engerv_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Then Jacob left Beersheba and traveled to Egypt. His sons, the sons of Israel, brought their father, their wives, and all their children to Egypt. They traveled in the wagons the Pharaoh had sent. ");
INSERT INTO engerv_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","They also had their cattle and everything they owned in the land of Canaan. So Israel went to Egypt with all his children and his family. ");
INSERT INTO engerv_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","With him were his sons and his grandsons, his daughters and his granddaughters. All of his family went with him. ");
INSERT INTO engerv_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","These are the names of Israel’s sons and family who went to Egypt with him: Reuben was Jacob’s first son. ");
INSERT INTO engerv_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben’s sons were Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engerv_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon’s sons were Jemuel, Jamin, Ohad, Jakin, and Zohar. There was also Shaul. (Shaul was born from a Canaanite woman.) ");
INSERT INTO engerv_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi’s sons were Gershon, Kohath, and Merari. ");
INSERT INTO engerv_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah’s sons were Er, Onan, Shelah, Perez, and Zerah. (Er and Onan died while still in Canaan.) Perez’s sons were Hezron and Hamul. ");
INSERT INTO engerv_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar’s sons were Tola, Puah, Job, and Shimron. ");
INSERT INTO engerv_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun’s sons were Sered, Elon, and Jahleel. ");
INSERT INTO engerv_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Reuben, Simeon, Levi, Judah, Issachar, and Zebulun were Jacob’s sons from his wife Leah. Leah had these sons in Paddan Aram. She also had a daughter named Dinah. There were 33 people in this family. ");
INSERT INTO engerv_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad’s sons were Zephon, Haggi, Shuni, Ezbon, Eri, Arodi, and Areli. ");
INSERT INTO engerv_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher’s sons were Imnah, Ishvah, Ishvi, Beriah, and their sister Serah. Also there were Beriah’s sons, Heber and Malkiel. ");
INSERT INTO engerv_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","All these were Jacob’s sons from his wife’s servant, Zilpah. (Zilpah was the maid that Laban had given to his daughter Leah.) There were 16 people in this family. ");
INSERT INTO engerv_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Benjamin was also with Jacob. Benjamin was Jacob and Rachel’s son. (Joseph was also Rachel’s son, but he was already in Egypt.) ");
INSERT INTO engerv_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","In Egypt, Joseph had two sons, Manasseh and Ephraim. (Joseph’s wife was Asenath, the daughter of Potiphera, the priest in the city of On.) ");
INSERT INTO engerv_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin’s sons were Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim, and Ard. ");
INSERT INTO engerv_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","These were the sons of Jacob from his wife Rachel. There were 14 people in this family. ");
INSERT INTO engerv_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan’s son was Hushim. ");
INSERT INTO engerv_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali’s sons were Jahziel, Guni, Jezer, and Shillem. ");
INSERT INTO engerv_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","These were the sons of Jacob and Bilhah. (Bilhah was the maid that Laban had given to his daughter Rachel.) There were seven people in this family. ");
INSERT INTO engerv_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","The total number of Jacob’s direct descendants who went with him to Egypt was 66 people. (The wives of Jacob’s sons were not counted in this number.) ");
INSERT INTO engerv_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Also, Joseph had two sons in Egypt. With these two grandsons, Jacob’s family in Egypt numbered 70 people in all. ");
INSERT INTO engerv_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob sent Judah ahead to speak to Joseph. Judah went to Joseph in the land of Goshen. Then Jacob and his people followed into the land. ");
INSERT INTO engerv_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph learned that his father was coming. So he prepared his chariot and went out to meet his father, Israel, in Goshen. When Joseph saw his father, he hugged his neck and cried for a long time. ");
INSERT INTO engerv_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Then Israel said to Joseph, “Now I can die in peace. I have seen your face, and I know that you are still alive.” ");
INSERT INTO engerv_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph said to his brothers and to the rest of his father’s family, “I will go and tell Pharaoh that you are here. I will say to Pharaoh, ‘My brothers and the rest of my father’s family have left the land of Canaan and have come here to me. ");
INSERT INTO engerv_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","They are a family of shepherds. They have always kept sheep and cattle. They have brought all their animals and everything they own with them.’ ");
INSERT INTO engerv_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","When Pharaoh calls you, he will ask, ‘What work do you do?’ ");
INSERT INTO engerv_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","You tell him, ‘We are shepherds. All our lives we have been shepherds, and our ancestors were shepherds before us.’ Then Pharaoh will allow you to live in the land of Goshen. Egyptians don’t like shepherds, so it is better that you stay in Goshen.” ");
INSERT INTO engerv_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph went in to Pharaoh and said, “My father and my brothers and all their families are here. They have all their animals and everything they own from the land of Canaan with them. They are now in the land of Goshen.” ");
INSERT INTO engerv_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Joseph chose five of his brothers to be with him before the Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaoh said to the brothers, “What work do you do?” The brothers said to Pharaoh, “Sir, we are shepherds, just as our ancestors were shepherds before us.” ");
INSERT INTO engerv_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","They said to Pharaoh, “The famine is very bad in Canaan. There are no fields left with grass for our animals, so we have come to live in this land. We ask you to please let us live in Goshen.” ");
INSERT INTO engerv_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Then Pharaoh said to Joseph, “Your father and your brothers have come to you. ");
INSERT INTO engerv_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","You can choose any place in Egypt for them to live. Give your father and your brothers the best land. Let them live in the land of Goshen. And if they are skilled shepherds, they can also care for my cattle.” ");
INSERT INTO engerv_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Then Joseph called his father Jacob to come in to meet Pharaoh. Jacob blessed Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Then Pharaoh said to him, “How old are you?” ");
INSERT INTO engerv_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob said to Pharaoh, “I have had a short life with many troubles. I am only 130 years old. My father and his ancestors lived to be much older than I am.” ");
INSERT INTO engerv_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Then Jacob blessed Pharaoh and left from his meeting with him. ");
INSERT INTO engerv_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph did what Pharaoh said and gave his father and brothers land in Egypt. It was the best land in Egypt, in the eastern part of the country, around Rameses. ");
INSERT INTO engerv_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph also gave his father, his brothers, and all their people the food they needed. ");
INSERT INTO engerv_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","The famine got worse; there was no food anywhere in the land. Egypt and Canaan became very poor because of this bad time. ");
INSERT INTO engerv_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","People in the land bought more and more grain. Joseph saved the money and brought it to Pharaoh’s house. ");
INSERT INTO engerv_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","After some time, the people in Egypt and Canaan had no money left. They had spent all their money to buy grain. So the people of Egypt went to Joseph and said, “Please give us food. Our money is gone. If we don’t eat, we will die while you are watching.” ");
INSERT INTO engerv_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","But Joseph answered, “Give me your cattle, and I will give you food.” ");
INSERT INTO engerv_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So the people used their cattle and horses and all their other animals to buy food. And that year, Joseph gave them food and took their animals. ");
INSERT INTO engerv_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","But the next year the people had no animals and nothing to buy food with. So they went to Joseph and said, “You know that we have no money left, and all our animals belong to you. So we have nothing left—only what you see—our bodies and our land. ");
INSERT INTO engerv_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Surely we will die while you are watching. But if you give us food, we will give Pharaoh our land, and we will be his slaves. Give us seed so that we can plant. Then we will live and not die, and the land will grow food for us again.” ");
INSERT INTO engerv_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","So Joseph bought all the land in Egypt for Pharaoh. All the people in Egypt sold Joseph their fields. They did this because they were very hungry. ");
INSERT INTO engerv_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","And everywhere in Egypt all the people became Pharaoh’s slaves. ");
INSERT INTO engerv_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","The only land Joseph didn’t buy was the land that the priests owned. The priests didn’t need to sell their land because Pharaoh paid them for their work. So they used this money to buy food to eat. ");
INSERT INTO engerv_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph said to the people, “Now I have bought you and your land for Pharaoh. So I will give you seed, and you can plant your fields. ");
INSERT INTO engerv_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","At harvest time, you must give one-fifth of your crops to Pharaoh. You can keep four-fifths for yourselves. You can use the seed you keep for food and planting the next year. Now you can feed your families and your children.” ");
INSERT INTO engerv_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","The people said, “You have saved our lives. We are happy to be slaves to Pharaoh.” ");
INSERT INTO engerv_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","So Joseph made a law at that time in the land, and that law continues today. The law says that one-fifth of everything from the land belongs to the Pharaoh who owns all the land. The only land he does not own is the land of the priests. ");
INSERT INTO engerv_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel stayed in Egypt. He lived in the land of Goshen. His family grew and became very large. They became landowners there and did very well. ");
INSERT INTO engerv_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob lived in Egypt 17 years, so he was 147 years old. ");
INSERT INTO engerv_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","The time came when Israel knew he would soon die, so he called his son Joseph to him. He said, “If you love me, put your hand under my leg and make a promise. Promise that you will do what I say and that you will be truthful with me. When I die, don’t bury me in Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bury me in the place where my ancestors are buried. Carry me out of Egypt and bury me in our family grave.” Joseph answered, “I promise that I will do what you say.” ");
INSERT INTO engerv_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Then Jacob said, “Make a vow to me.” And Joseph vowed to him that he would do this. Then Israel laid his head back down on the bed. ");
INSERT INTO engerv_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Some time later Joseph learned that his father was very sick. So he took his two sons, Manasseh and Ephraim, and went to his father. ");
INSERT INTO engerv_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","When Joseph arrived, someone told Israel, “Your son Joseph has come to see you.” Israel was very weak, but he tried hard and sat up in his bed. ");
INSERT INTO engerv_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Then Israel said to Joseph, “God All-Powerful appeared to me at Luz in the land of Canaan. God blessed me there. ");
INSERT INTO engerv_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","He said to me, ‘I will make you a great family. I will give you many children and you will be a great people. Your family will own this land forever.’ ");
INSERT INTO engerv_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Now you have two sons. These two sons were born here in the country of Egypt before I came. Your two sons, Ephraim and Manasseh, will be like my own sons. They will be like Reuben and Simeon to me. ");
INSERT INTO engerv_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","So these two boys will be my sons. They will share in everything I own. But if you have other sons, they will be your sons. But they will also be like sons to Ephraim and Manasseh—that is, in the future, they will share in everything that Ephraim and Manasseh own. ");
INSERT INTO engerv_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","On the trip from Paddan Aram, Rachel died in the land of Canaan. This made me very sad. We were still traveling toward Ephrath. I buried her there on the road to Ephrath.” (Ephrath is Bethlehem.) ");
INSERT INTO engerv_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Then Israel saw Joseph’s sons. Israel said, “Who are these boys?” ");
INSERT INTO engerv_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph said to his father, “These are my sons. These are the boys God gave me.” Israel said, “Bring your sons to me. I will bless them.” ");
INSERT INTO engerv_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel was old and his eyes were not good. So Joseph brought the boys close to his father. Israel kissed and hugged the boys. ");
INSERT INTO engerv_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Then Israel said to Joseph, “I never thought I would see your face again. But look! God has let me see you and your children.” ");
INSERT INTO engerv_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Then Joseph took the boys off Israel’s lap, and they bowed down in front of his father. ");
INSERT INTO engerv_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph put Ephraim on his right side and Manasseh on his left side. (So Ephraim was on Israel’s left side, and Manasseh was on Israel’s right side.) ");
INSERT INTO engerv_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","But Israel crossed his hands and put his right hand on the head of the younger boy Ephraim. Then he put his left hand on Manasseh, even though Manasseh was the firstborn. ");
INSERT INTO engerv_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","And Israel blessed Joseph and said, “My ancestors, Abraham and Isaac, worshiped our God, and that God has led me all my life. ");
INSERT INTO engerv_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","He was the Angel who saved me from all my troubles. And I pray that he will bless these boys. Now they will have my name and the name of our ancestors, Abraham and Isaac. I pray that they will grow to become great families and nations on earth.” ");
INSERT INTO engerv_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph saw that his father put his right hand on Ephraim’s head. This didn’t make Joseph happy. Joseph took his father’s hand because he wanted to move it from Ephraim’s head and put it on Manasseh’s head. ");
INSERT INTO engerv_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph said to his father, “You have your right hand on the wrong boy. Manasseh is the firstborn. Put your right hand on him.” ");
INSERT INTO engerv_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","But his father refused and said, “I know, son. I know. Manasseh is the firstborn. He will be great and will be the father of many people. But his younger brother will be greater than he is. And the younger brother’s family will be much larger.” ");
INSERT INTO engerv_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So Israel blessed them that day. He said, “The Israelites will use your names whenever they bless someone. They will say, ‘May God make you like Ephraim and Manasseh.’” In this way Israel made Ephraim greater than Manasseh. ");
INSERT INTO engerv_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Then Israel said to Joseph, “Look, my time to die is almost here, but God will still be with you. He will lead you back to the land of your ancestors. ");
INSERT INTO engerv_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","I have given you one portion more than I gave to your brothers. I gave you the land that I won from the Amorites. I used my sword and bow to take that land.” ");
INSERT INTO engerv_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Then Jacob called all his sons to him. He said, “My sons, come here to me. I will tell you what will happen in the future. ");
INSERT INTO engerv_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Children of Jacob, gather around. Come listen to Israel, your father. ");
INSERT INTO engerv_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, my first son, you are my strength, the first proof of my manhood. You were the most honored and powerful of all my sons. ");
INSERT INTO engerv_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","But your passion was like a flood you couldn’t control. So you will not remain my most honored son. You climbed into your father’s bed and slept with one of his wives. You brought shame to my bed, to the bed you lay on. ");
INSERT INTO engerv_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon and Levi are brothers. They are violent with their swords. ");
INSERT INTO engerv_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","I will not join their secret meetings. I will not take part in their evil plans. They have killed people out of anger and crippled animals for fun. ");
INSERT INTO engerv_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Their anger is so strong that it is a curse. They are too cruel when they are angry. They will not get their own land in the land of Jacob. They will be spread throughout Israel. ");
INSERT INTO engerv_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah, your brothers will praise you. You will defeat your enemies. Your brothers will bow down to you. ");
INSERT INTO engerv_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah is like a young lion. My son, you are like a lion standing over the animal it killed. Like a lion, Judah lies down to rest, and no one is brave enough to disturb him. ");
INSERT INTO engerv_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Men from Judah’s family will be kings. The sign that his family rules will not leave his family before the real king comes. Then many people will obey and serve him. ");
INSERT INTO engerv_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","He ties his donkeys to the best grapevines. He washes his clothes in the best wine. ");
INSERT INTO engerv_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","His eyes are red from drinking wine. His teeth are white from drinking milk. ");
INSERT INTO engerv_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun will live near the sea. His seacoast will be a safe place for ships. His land will continue as far as the city of Sidon. ");
INSERT INTO engerv_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issachar is like a donkey that has worked too hard. He will lie down under his heavy load. ");
INSERT INTO engerv_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","He will see his land is pleasant and that his resting place is good. But he will agree to carry heavy loads; he will agree to work as a slave. ");
INSERT INTO engerv_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan will rule his people as one of the tribes of Israel. ");
INSERT INTO engerv_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan will be like a snake at the side of the road. He will be like a dangerous snake lying near the path. That snake bites a horse’s foot, and the rider falls to the ground. ");
INSERT INTO engerv_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“LORD, I am waiting for your salvation. ");
INSERT INTO engerv_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“A group of robbers will attack Gad, but Gad will chase them away. ");
INSERT INTO engerv_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asher’s land will grow much good food. He will have food fit for a king! ");
INSERT INTO engerv_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naphtali is like a deer running free, and his words are beautiful. ");
INSERT INTO engerv_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph is like a wild donkey, like a young donkey by a spring, like colts grazing in a pasture. ");
INSERT INTO engerv_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","People attacked him and made life hard for him. Men with arrows became his enemies. ");
INSERT INTO engerv_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","But he won the fight with his mighty bow and his skillful arms. He gets power from the Mighty One of Jacob, from the Shepherd, the Rock of Israel, ");
INSERT INTO engerv_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","the God of your father who helps you. May God All-Powerful bless you and give you blessings from the sky above and from the deep below. May he give you blessings from breast and womb. ");
INSERT INTO engerv_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","My parents had many good things happen to them. And I, your father, was blessed even more. Your brothers left you with nothing. But now I pile all my blessings on you, as high as a mountain. ");
INSERT INTO engerv_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin is like a hungry wolf. In the morning he kills and eats. In the evening he shares what is left.” ");
INSERT INTO engerv_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","These are the twelve families of Israel. And this is what their father said to them. He gave each son a blessing that was right for him. ");
INSERT INTO engerv_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Then Israel gave them a command. He said, “When I die, I want to be with my people. I want to be buried with my ancestors in the cave in the field of Ephron the Hittite. ");
INSERT INTO engerv_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","That cave is in the field of Machpelah near Mamre in the land of Canaan. Abraham bought that field from Ephron so that he could have a burying place. ");
INSERT INTO engerv_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abraham and his wife Sarah are buried in that cave. Isaac and his wife Rebekah are buried in that cave. I buried my wife Leah in that cave. ");
INSERT INTO engerv_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","That cave is in the field that was bought from the Hittites.” ");
INSERT INTO engerv_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","After Jacob finished talking to his sons, he lay down, put his feet back on the bed, and died. ");
INSERT INTO engerv_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","When Israel died, Joseph was very sad. He hugged his father and cried over him and kissed him. ");
INSERT INTO engerv_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph commanded his servants to prepare his father’s body. (These servants were doctors.) The doctors prepared Jacob’s body to be buried. They prepared the body in the special way of the Egyptians. ");
INSERT INTO engerv_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","When the Egyptians prepared the body in this special way, they waited 40 days before they buried the body. Then the Egyptians had a special time of sadness for Jacob. This time was 70 days. ");
INSERT INTO engerv_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","After the time of sadness was finished, Joseph spoke to Pharaoh’s officers and said, “Please tell this to Pharaoh: ");
INSERT INTO engerv_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘When my father was near death, I made a promise to him. I promised that I would bury him in a cave in the land of Canaan. This is the cave that he prepared for himself. So please let me go and bury my father. Then I will come back here to you.’” ");
INSERT INTO engerv_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh answered, “Keep your promise. Go and bury your father.” ");
INSERT INTO engerv_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","So Joseph went to bury his father. All of Pharaoh’s officials, personal advisors, and all the older leaders of Egypt went with Joseph. ");
INSERT INTO engerv_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","All the people in Joseph’s family, his brothers, and all the people in his father’s family went with him. Only the children and the animals stayed in the land of Goshen. ");
INSERT INTO engerv_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","So there was a large crowd of people with him. There was even a group of soldiers riding in chariots and some on horses. ");
INSERT INTO engerv_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","They went to Goren Atad, east of the Jordan River. There they had a long funeral service for Israel, which continued for seven days. ");
INSERT INTO engerv_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","When the people who lived in Canaan saw the funeral service at Goren Atad, they said, “This is a time of great sorrow for those Egyptians.” So now that place across the Jordan River is named Abel Mizraim. ");
INSERT INTO engerv_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","So Jacob’s sons did what their father told them. ");
INSERT INTO engerv_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","They carried his body to Canaan and buried it in the cave at Machpelah. This was the cave near Mamre in the field that Abraham bought from Ephron the Hittite. Abraham bought that cave to use as a burial place. ");
INSERT INTO engerv_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","After Joseph buried his father, he and everyone in the group with him went back to Egypt. ");
INSERT INTO engerv_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","After Jacob died, Joseph’s brothers were worried. They were afraid that Joseph would still be mad at them for what they had done years before. They said, “Maybe Joseph still hates us for what we did.” ");
INSERT INTO engerv_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","So the brothers sent this message to Joseph: “Before your father died, he told us to give you a message. ");
INSERT INTO engerv_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","He said, ‘Tell Joseph that I beg him to please forgive his brothers for the bad things they did to him.’ So now Joseph, we beg you, please forgive us for the bad things we did to you. We are the servants of God, the God of your father.” That message made Joseph very sad, and he cried. ");
INSERT INTO engerv_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","His brothers went to him and bowed down in front of him. They said, “We will be your servants.” ");
INSERT INTO engerv_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Then Joseph said to them, “Don’t be afraid. I am not God! I have no right to punish you. ");
INSERT INTO engerv_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","It is true that you planned to do something bad to me. But really, God was planning good things. God’s plan was to use me to save the lives of many people. And that is what happened. ");
INSERT INTO engerv_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","So don’t be afraid. I will take care of you and your children.” And so Joseph said kind things to his brothers, and this made them feel better. ");
INSERT INTO engerv_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph continued to live in Egypt with his father’s family. He died when he was 110 years old. ");
INSERT INTO engerv_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","During Joseph’s life Ephraim had children and grandchildren. And his son Manasseh had a son named Makir. Joseph lived to see Makir’s children. ");
INSERT INTO engerv_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","When Joseph was near death, he said to his brothers, “My time to die is almost here. But I know that God will take care of you and lead you out of this country. God will lead you to the land he promised to give Abraham, Isaac, and Jacob.” ");
INSERT INTO engerv_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Then Joseph asked his people to make a promise. Joseph said, “Promise me that you will carry my bones with you when God leads you out of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph died in Egypt when he was 110 years old. Doctors prepared his body for burial and put the body in a coffin in Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","When Jacob (Israel) went to Egypt, his sons and their families went with him. Here are the names of those sons: ");
INSERT INTO engerv_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levi, Judah, ");
INSERT INTO engerv_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, Benjamin, ");
INSERT INTO engerv_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad, and Asher. ");
INSERT INTO engerv_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Another son, Joseph, was already in Egypt. So Jacob’s whole family was with him in Egypt—70 descendants in all. ");
INSERT INTO engerv_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Later, Joseph, his brothers, and all the people of that generation died. ");
INSERT INTO engerv_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","But the Israelites had many children, and their number grew until the country of Egypt was filled with them. ");
INSERT INTO engerv_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Then a new king began to rule Egypt. He did not know Joseph. ");
INSERT INTO engerv_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","This king said to his people, “Look at the Israelites. There are too many of them, and they are stronger than we are! ");
INSERT INTO engerv_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","We must make plans to stop them from growing stronger. If there is a war, they might join our enemies, defeat us, and escape from the land!” ");
INSERT INTO engerv_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","The Egyptians decided to make life hard for the Israelites, so they put slave masters over the people. These masters forced the Israelites to build the cities of Pithom and Rameses for the king. The king used these cities to store grain and other things. ");
INSERT INTO engerv_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","The Egyptians forced the Israelites to work harder and harder. But the harder they worked, the more they grew and spread, and the more the Egyptians became afraid of them. ");
INSERT INTO engerv_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","So the Egyptians made them work even harder. ");
INSERT INTO engerv_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","They made life hard for the Israelites. They forced the Israelites to work hard at making bricks and mortar and to work hard in the fields. The Egyptians showed no mercy in all the hard work they made the Israelites do! ");
INSERT INTO engerv_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","There were two Hebrew nurses who helped the Israelite women give birth. They were named Shiphrah and Puah. The king of Egypt said to the nurses, ");
INSERT INTO engerv_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“You will continue to help the Hebrew women give birth to their children. If a girl baby is born, let the baby live. But if the baby is a boy, you must kill him!” ");
INSERT INTO engerv_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","But the nurses trusted God, so they did not obey the king’s command. They let all the baby boys live. ");
INSERT INTO engerv_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","The king of Egypt called for the nurses and asked them, “Why did you do this? Why did you let the baby boys live?” ");
INSERT INTO engerv_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","The nurses said to the king, “The Hebrew women are much stronger than the Egyptian women. They give birth to their babies before we can go to help them.” ");
INSERT INTO engerv_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","The nurses trusted God, so he was good to them and allowed them to have their own families. The Hebrews continued to have more children, and they became very strong. ");
INSERT INTO engerv_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","So Pharaoh gave this command to his own people: “If the Hebrew women give birth to a baby girl, let it live. But if they have a baby boy, you must throw it into the Nile River.” ");
INSERT INTO engerv_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","There was a man from the family of Levi who decided to marry a woman from the tribe of Levi. ");
INSERT INTO engerv_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","She became pregnant and gave birth to a baby boy. The mother saw how beautiful the baby was and hid him for three months. ");
INSERT INTO engerv_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","She hid him for as long as she could. After three months she made a basket and covered it with tar so that it would float. Then she put the baby in the basket and put the basket in the river in the tall grass. ");
INSERT INTO engerv_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","The baby’s sister stayed and watched to see what would happen to the baby. ");
INSERT INTO engerv_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Just then, Pharaoh’s daughter went to the river to bathe. She saw the basket in the tall grass. Her servants were walking beside the river, so she told one of them to go get the basket. ");
INSERT INTO engerv_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","The king’s daughter opened the basket and saw a baby boy. The baby was crying and she felt sorry for it. Then she noticed that it was one of the Hebrew babies. ");
INSERT INTO engerv_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","The baby’s sister was still hiding. She stood and asked the king’s daughter, “Do you want me to go find a Hebrew woman who can nurse the baby and help you care for it?” ");
INSERT INTO engerv_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","The king’s daughter said, “Yes, please.” So the girl went and brought the baby’s own mother. ");
INSERT INTO engerv_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","The king’s daughter said to the mother, “Take this baby and feed him for me. I’ll pay you to take care of him.” So the woman took her baby and cared for him. ");
INSERT INTO engerv_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","The baby grew, and after some time, the woman gave the baby to the king’s daughter. The king’s daughter accepted the baby as her own son. She named him Moses because she had pulled him from the water. ");
INSERT INTO engerv_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moses grew and became a man. He saw that his own people, the Hebrews, were forced to work very hard. One day he saw an Egyptian man beating a Hebrew man. ");
INSERT INTO engerv_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses looked around and saw that no one was watching, so he killed the Egyptian and buried him in the sand. ");
INSERT INTO engerv_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","The next day Moses saw two Hebrew men fighting each other. He saw that one man was wrong and said to him, “Why are you hurting your neighbor?” ");
INSERT INTO engerv_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","The man answered, “Did anyone say you could be our ruler and judge? Tell me, will you kill me as you killed the Egyptian yesterday?” Then Moses was afraid. He thought to himself, “Now everyone knows what I did.” ");
INSERT INTO engerv_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pharaoh heard about what Moses did, so he decided to kill him. But Moses ran away from Pharaoh and went to the land of Midian. Moses stopped near a well in Midian. ");
INSERT INTO engerv_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","There was a priest there who had seven daughters. These girls came to that well to get water for their father’s sheep. They were trying to fill the water trough with water. ");
INSERT INTO engerv_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","But there were some shepherds there who chased the girls away and would not let them get water. So Moses helped the girls and gave water to their animals. ");
INSERT INTO engerv_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Then they went back to their father, Reuel. He asked them, “Why have you come home early today?” ");
INSERT INTO engerv_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","The girls answered, “The shepherds chased us away, but an Egyptian rescued us. He got water for us and gave it to our animals.” ");
INSERT INTO engerv_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","So Reuel said to his daughters, “Where is this man? Why did you leave him? Go invite him to eat with us.” ");
INSERT INTO engerv_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moses was happy to stay with that man. Reuel let Moses marry his daughter, Zipporah. ");
INSERT INTO engerv_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipporah became pregnant and had a son. Moses named him Gershom because Moses was a stranger in a land that was not his own. ");
INSERT INTO engerv_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A long time passed and that king of Egypt died. But the Israelites were still forced to work very hard. They cried for help, and God heard them. ");
INSERT INTO engerv_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","God heard their painful cries and remembered the agreement he made with Abraham, Isaac, and Jacob. ");
INSERT INTO engerv_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","God saw the troubles of the Israelites, and he knew that he would soon help them. ");
INSERT INTO engerv_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses’ father-in-law was named Jethro. Jethro was a priest of Midian. Moses took care of Jethro’s sheep. One day Moses led the sheep to the west side of the desert. He went to a mountain called Horeb, the mountain of God. ");
INSERT INTO engerv_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","On that mountain, Moses saw the angel of the LORD in a burning bush. Moses saw a bush that was burning without being destroyed. ");
INSERT INTO engerv_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","So he decided to go closer to the bush and see how a bush could continue burning without being burned up. ");
INSERT INTO engerv_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","The LORD saw Moses was coming to look at the bush. So he called to him from the bush. He said, “Moses, Moses!” Moses said, “Yes, Lord.” ");
INSERT INTO engerv_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Then God said, “Don’t come any closer. Take off your sandals. You are standing on holy ground. ");
INSERT INTO engerv_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","I am the God of your ancestors. I am the God of Abraham, the God of Isaac, and the God of Jacob.” Moses covered his face because he was afraid to look at God. ");
INSERT INTO engerv_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Then the LORD said, “I have seen the troubles my people have suffered in Egypt, and I have heard their cries when the Egyptians hurt them. I know about their pain. ");
INSERT INTO engerv_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Now I will go down and save my people from the Egyptians. I will take them from that land and lead them to a good land where they can be free from these troubles. It is a land filled with many good things. Many different people live in that land: the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engerv_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","I have heard the cries of the Israelites, and I have seen the way the Egyptians have made life hard for them. ");
INSERT INTO engerv_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","So now I am sending you to Pharaoh. Go! Lead my people, the Israelites, out of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","But Moses said to God, “I am not a great man! How can I be the one to go to Pharaoh and lead the Israelites out of Egypt?” ");
INSERT INTO engerv_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","God said, “You can do it because I will be with you. This will be the proof that I am sending you: After you lead the people out of Egypt, you will come and worship me on this mountain.” ");
INSERT INTO engerv_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Then Moses said to God, “But if I go to the Israelites and say to them, ‘The God of your ancestors sent me,’ then the people will ask, ‘What is his name?’ What should I tell them?” ");
INSERT INTO engerv_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Then God said to Moses, “Tell them, ‘I AM WHO I AM.’ When you go to the Israelites, tell them, ‘I AM’ sent me to you.” ");
INSERT INTO engerv_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","And God said, “Tell the Israelites that you were sent by YAHWEH, the God of your ancestors—the God of Abraham, the God of Isaac, the God of Jacob. This will always be my name. It is how I want the people to remember me from now on. ");
INSERT INTO engerv_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Now go and call together the elders of the people. Tell them that YAHWEH, the God of your ancestors—the God of Abraham, Isaac, and Jacob—appeared to you. Give them this message from me: ‘I have been watching over you and have seen what people in Egypt have done to you. ");
INSERT INTO engerv_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","And I have decided that I will take you away from the troubles you are suffering in Egypt. I will lead you to the land that now belongs to others—the Canaanites, Hittites, Amorites, Perizzites, Hivites, and Jebusites. I will lead you to a land filled with many good things.’ ");
INSERT INTO engerv_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“The elders will listen to you. And then you and the elders will go to the Pharaoh. You will tell him, ‘YAHWEH is the God of the Hebrews. He came to us and told us to travel three days into the desert. There we must offer sacrifices to YAHWEH our God.’ ");
INSERT INTO engerv_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“But I know that the Pharaoh will not let you go. Only a great power will force him to let you go, ");
INSERT INTO engerv_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","so I will use my great power against Egypt. I will cause amazing things to happen in that land. After I do this, he will let you go. ");
INSERT INTO engerv_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","And I will cause the Egyptians to be kind to the Israelites. They will give many gifts to your people when they leave Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“All the Hebrew women will ask their Egyptian neighbors and the Egyptian women living in their houses for gifts. And those Egyptian women will give them gifts of silver, gold, and fine clothing. Then you will put those gifts on your children. In this way you will take away the wealth of the Egyptians.” ");
INSERT INTO engerv_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Then Moses said to God, “But the Israelites will not believe me when I tell them that you sent me. They will say, ‘The LORD did not appear to you.’” ");
INSERT INTO engerv_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","But the LORD said to Moses, “What is that you have in your hand?” Moses answered, “It is my walking stick.” ");
INSERT INTO engerv_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Then God said, “Throw your walking stick on the ground.” So Moses threw his walking stick on the ground, and it became a snake. Moses ran from it, ");
INSERT INTO engerv_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","but the LORD said to him, “Reach out and grab the snake by its tail.” When Moses reached out and caught the snake’s tail, the snake became a walking stick again. ");
INSERT INTO engerv_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Then God said, “Use your stick in this way, and the people will believe that you saw the LORD, the God of your ancestors, the God of Abraham, the God of Isaac, and the God of Jacob.” ");
INSERT INTO engerv_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Then the LORD said to Moses, “I will give you another proof. Put your hand under your robe.” So Moses opened his robe and put his hand inside. Then he brought his hand out of the robe and it was changed. His hand was covered with spots that were white like snow. ");
INSERT INTO engerv_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Then God said, “Now put your hand into your robe again.” So Moses put his hand into his robe again. Then he brought his hand out, and his hand was changed. Now his hand was good again, as it was before. ");
INSERT INTO engerv_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Then God said, “If the people don’t believe you when you use your walking stick, then they will believe you when you show them this sign. ");
INSERT INTO engerv_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","If they still refuse to believe after you show them both of these signs, then take some water from the Nile River. Pour the water on the ground, and as soon as it touches the ground, it will become blood.” ");
INSERT INTO engerv_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Then Moses said to the LORD, “But, Lord, I am telling you, I am not a good speaker. I have never been able to speak well. And that hasn’t changed since you started talking to me. I am still not a good speaker. You know that I speak slowly and don’t use the best words.” ");
INSERT INTO engerv_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Then the LORD said to him, “Who made a person’s mouth? And who can make someone deaf or not able to speak? Who can make a person blind? Who can make a person able to see? I am the one. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","So go. I will be with you when you speak. I will give you the words to say.” ");
INSERT INTO engerv_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","But Moses said, “My Lord, I beg you to send someone else, not me.” ");
INSERT INTO engerv_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Then the LORD became angry with Moses and said, “All right! I’ll give you someone to help you. Aaron the Levite is your brother, isn’t he? He is a good speaker. In fact, Aaron is already coming to meet you, and he will be happy to see you. ");
INSERT INTO engerv_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","I will tell you what to say. Then you will tell Aaron, and I will help him say it well. I will tell both of you what to do. ");
INSERT INTO engerv_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","So Aaron will speak for you. Like God, you will speak to him, and he will tell the people what you say. ");
INSERT INTO engerv_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","So go and carry your walking stick with you. Use it and the other miracles to show the people that I am with you.” ");
INSERT INTO engerv_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Then Moses went back to Jethro, his father-in-law. Moses said to him, “Please let me go back to Egypt. I want to see if my people are still alive.” Jethro said to Moses, “Go in peace.” ");
INSERT INTO engerv_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Then, while Moses was still in Midian, the LORD said to him, “It is safe for you to go back to Egypt now. The men who wanted to kill you are now dead.” ");
INSERT INTO engerv_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","So Moses put his wife and children on the donkey and returned to Egypt. He carried his walking stick with him—the walking stick with the power of God. ");
INSERT INTO engerv_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","While Moses was traveling back to Egypt, the LORD spoke to him, “When you talk to Pharaoh remember to show him all the miracles that I have given you the power to do. But I will cause Pharaoh to be very stubborn. He will not let the people go. ");
INSERT INTO engerv_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Then you should say to Pharaoh, ‘This is what the LORD says: Israel is my firstborn son. ");
INSERT INTO engerv_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","And I am telling you to let my son go and worship me. If you refuse to let Israel go, then I will kill your firstborn son.’” ");
INSERT INTO engerv_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","On the way to Egypt, Moses stopped at a place to spend the night. The LORD met Moses at that place and tried to kill him. ");
INSERT INTO engerv_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","But Zipporah took a flint knife and circumcised her son. She took the skin and touched his feet. Then she said to Moses, “You are a bridegroom of blood to me.” ");
INSERT INTO engerv_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Zipporah said this because she had to circumcise her son. So God let Moses live. ");
INSERT INTO engerv_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","The LORD had spoken to Aaron and told him, “Go out into the desert and meet Moses.” So Aaron went and met Moses at the Mountain of God. He saw Moses and kissed him. ");
INSERT INTO engerv_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses told Aaron everything the LORD had commanded him to say and all the miracles he must do to prove that God had sent him. ");
INSERT INTO engerv_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","So Moses and Aaron went and gathered together all the elders of the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Then Aaron spoke to the people and told them everything the LORD had told Moses. Then Moses did the miracles for all the people to see, ");
INSERT INTO engerv_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","and they believed what they had heard. Then the Israelites understood that the LORD had seen their troubles and had come to help them. So they bowed down and worshiped God. ");
INSERT INTO engerv_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","After Moses and Aaron talked to the people, they went to Pharaoh and said, “The LORD, the God of Israel, says, ‘Let my people go into the desert so that they can have a festival to honor me.’” ");
INSERT INTO engerv_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","But Pharaoh said, “Who is the LORD? Why should I obey him? Why should I let Israel go? I don’t even know who this LORD is, so I refuse to let Israel go.” ");
INSERT INTO engerv_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Then Aaron and Moses said, “The God of the Hebrews has talked with us. So we beg you to let us travel three days into the desert. There we will offer a sacrifice to the LORD our God. If we don’t do this, he might become angry and destroy us. He might make us die from sickness or war.” ");
INSERT INTO engerv_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","But Pharaoh said to them, “Moses and Aaron, you are bothering the workers. Let them do their work. Go back to your own work! ");
INSERT INTO engerv_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","There are very many workers, and you are keeping them from doing their jobs.” ");
INSERT INTO engerv_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","That same day Pharaoh gave a command to the slave masters and Hebrew foremen. ");
INSERT INTO engerv_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","He said, “You have always given the people straw to use to make bricks. But now, tell them they have to go and find their own straw to make bricks. ");
INSERT INTO engerv_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","But they must still make the same number of bricks as they did before. They have gotten lazy. That is why they are asking me to let them go. They don’t have enough work to do. That is why they asked me to let them make sacrifices to their God. ");
INSERT INTO engerv_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","So make these people work harder. Keep them busy. Then they will not have enough time to listen to the lies of Moses.” ");
INSERT INTO engerv_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","So the Egyptian slave masters and the Hebrew foremen went to the Israelites and said, “Pharaoh has decided that he will not give you straw for your bricks. ");
INSERT INTO engerv_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","You must go and get the straw for yourselves. So go and find straw, but you must still make as many bricks as you made before.” ");
INSERT INTO engerv_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","So the people went everywhere in Egypt looking for straw. ");
INSERT INTO engerv_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","The slave masters forced the people to work even harder. They forced the people to make as many bricks as before. ");
INSERT INTO engerv_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","The Egyptian slave masters had chosen the Hebrew foremen and had made them responsible for the work the people did. The Egyptian slave masters beat these foremen and said to them, “Why aren’t you making as many bricks as you made in the past? If you could do it then, you can do it now!” ");
INSERT INTO engerv_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Then the Hebrew foremen went to Pharaoh. They complained and said, “We are your servants. Why are you treating us like this? ");
INSERT INTO engerv_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","You give us no straw, but you tell us to make as many bricks as before. And now our masters are beating us. Your people are wrong for doing this.” ");
INSERT INTO engerv_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharaoh answered, “You are lazy, and you don’t want to work! That is why you ask me to let you go. And that is why you want to leave here and make sacrifices to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Now, go back to work! We will not give you any straw. And you must still make as many bricks as you did before.” ");
INSERT INTO engerv_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","The Hebrew foremen knew they were in trouble, because the Pharaoh had told them, “You must still make as many bricks as you made before.” ");
INSERT INTO engerv_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","When they were leaving the meeting with Pharaoh, they passed Moses and Aaron. Moses and Aaron were waiting for them. ");
INSERT INTO engerv_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","So they said to Moses and Aaron, “May the LORD judge and punish you for what you did! You made Pharaoh and his rulers hate us. You have given them an excuse to kill us.” ");
INSERT INTO engerv_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Then Moses prayed to the LORD and said, “Lord, why have you done this terrible thing to your people? Why did you send me here? ");
INSERT INTO engerv_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","I went to Pharaoh and said what you told me to say. But since that time he has made the people suffer, and you have done nothing to help them!” ");
INSERT INTO engerv_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Then the LORD said to Moses, “Now you will see what I will do to Pharaoh. I will use my great power against him, and he will let my people go. He will be so ready for them to leave that he will force them to go.” ");
INSERT INTO engerv_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Then God said to Moses, “I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","I appeared to Abraham, Isaac, and Jacob. They called me God All-Powerful. They did not know my name, the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","I made an agreement with them. I promised to give them the land of Canaan. They lived in that land, but it was not their own. ");
INSERT INTO engerv_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Now, I have heard their painful cries. I know that they are slaves in Egypt. And I remember my agreement. ");
INSERT INTO engerv_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","So tell the Israelites that I say to them, ‘I am the LORD. I will save you. You will no longer be slaves of the Egyptians. I will use my great power to make you free, and I will bring terrible punishment to the Egyptians. ");
INSERT INTO engerv_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","You will be my people and I will be your God. I am the LORD your God, and you will know that I made you free from Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","I made a great promise to Abraham, Isaac, and Jacob. I promised to give them a special land. So I will lead you to that land. I will give you that land. It will be yours. I am the LORD.’” ");
INSERT INTO engerv_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","So Moses told this to the Israelites, but the people would not listen to him. They were working so hard that they were not patient with Moses. ");
INSERT INTO engerv_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Go tell Pharaoh that he must let the Israelites leave his land.” ");
INSERT INTO engerv_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","But Moses answered, “LORD, the Israelites refuse to listen to me. So surely Pharaoh will also refuse to listen. I am a very bad speaker.” ");
INSERT INTO engerv_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","But the LORD talked with Moses and Aaron and commanded them to go and talk to the Israelites and to Pharaoh, the king of Egypt. He commanded them to lead the Israelites out of the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","These are the names of the leaders of the families of Israel: Israel’s first son, Reuben, had four sons. They were Hanoch, Pallu, Hezron, and Carmi. ");
INSERT INTO engerv_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon’s sons were Jemuel, Jamin, Ohad, Jakin, Zohar, and Shaul. (Shaul was the son from a Canaanite woman). ");
INSERT INTO engerv_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi lived 137 years. His sons were Gershon, Kohath, and Merari. ");
INSERT INTO engerv_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon had two sons, Libni and Shimei. ");
INSERT INTO engerv_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath lived 133 years. His sons were Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engerv_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari’s sons were Mahli and Mushi. All these families were from Israel’s son Levi. ");
INSERT INTO engerv_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram lived 137 years. He married his father’s sister, Jochebed. Amram and Jochebed gave birth to Aaron and Moses. ");
INSERT INTO engerv_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar’s sons were Korah, Nepheg, and Zicri. ");
INSERT INTO engerv_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel’s sons were Mishael, Elzaphan, and Sithri. ");
INSERT INTO engerv_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron married Elisheba. (Elisheba was the daughter of Amminadab, and the sister of Nahshon.) Aaron and Elisheba gave birth to Nadab, Abihu, Eleazar, and Ithamar. ");
INSERT INTO engerv_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","The sons of Korah (that is, the ancestors of the Korahites) were Assir, Elkanah, and Abiasaph. ");
INSERT INTO engerv_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron’s son, Eleazar, married a daughter of Putiel. She gave birth to Phinehas. All these people were from Israel’s son, Levi. ");
INSERT INTO engerv_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron and Moses were from this tribe. And they are the men the LORD spoke to and said, “Lead my people out of Israel in groups.” ");
INSERT INTO engerv_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aaron and Moses are the men who talked to Pharaoh, the king of Egypt, and told him to let the Israelites leave Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","The LORD spoke to Moses again in the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","He said, “I am the LORD. Tell the king of Egypt everything I tell you.” ");
INSERT INTO engerv_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","But Moses, standing there before the LORD, said, “You know me. I’m a very bad speaker. How will I make the king listen to me?” ");
INSERT INTO engerv_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","The LORD said to Moses, “See how important I have made you? In speaking to Pharaoh, you will be like God, and your brother Aaron will be your prophet. ");
INSERT INTO engerv_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","You will tell Aaron everything that I command you. Then he will tell the king what I say. And Pharaoh will let the Israelites leave this country. ");
INSERT INTO engerv_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","But I will make Pharaoh stubborn so that he will not do what you tell him. Then I will do many miracles in Egypt to prove who I am. ");
INSERT INTO engerv_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","But he will still refuse to listen. So then I will punish Egypt very much. And I will lead my army, my people, out of that land. ");
INSERT INTO engerv_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","I will punish the people of Egypt, and they will learn that I am the LORD. Then I will lead my people out of their country.” ");
INSERT INTO engerv_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moses and Aaron did what the LORD told them. ");
INSERT INTO engerv_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moses was 80 years old at the time, and Aaron was 83. ");
INSERT INTO engerv_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Pharaoh will ask you to prove your power. He will ask you to do a miracle. Tell Aaron to throw his walking stick on the ground. While Pharaoh is watching, the stick will become a snake.” ");
INSERT INTO engerv_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","So Moses and Aaron went to Pharaoh and obeyed the LORD. Aaron threw his walking stick down. While Pharaoh and his officers watched, the stick became a snake. ");
INSERT INTO engerv_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","So Pharaoh called for his wise men and magicians. These men used their magic, and they were able to do the same thing as Aaron. ");
INSERT INTO engerv_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","They threw their walking sticks on the ground, and their sticks became snakes. But then Aaron’s walking stick ate theirs. ");
INSERT INTO engerv_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pharaoh still refused to let the people go, just as the LORD had said. Pharaoh refused to listen to Moses and Aaron. ");
INSERT INTO engerv_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Then the LORD said to Moses, “Pharaoh is being stubborn. He refuses to let the people go. ");
INSERT INTO engerv_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","In the morning Pharaoh will go out to the river. Go to him by the edge of the Nile River. Take the walking stick that became a snake. ");
INSERT INTO engerv_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Tell him this: ‘The LORD, the God of the Hebrews, sent me to you. He told me to tell you to let his people go worship him in the desert. Until now you have not listened to the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","So the LORD says that he will do something to show you that he is the LORD. I will hit the water of the Nile River with this walking stick in my hand, and the river will turn into blood. ");
INSERT INTO engerv_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","The fish in the river will die, and the river will begin to stink. Then the Egyptians will not be able to drink the water from the river.’” ");
INSERT INTO engerv_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","The LORD said to Moses: “Tell Aaron to hold the walking stick in his hand over the rivers, canals, lakes, and every place where they store water. When he does this, all the water will turn into blood. All the water, even the water stored in wood and stone jars, will turn into blood.” ");
INSERT INTO engerv_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","So Moses and Aaron did what the LORD commanded. Aaron raised the walking stick and hit the water in the Nile River. He did this in front of Pharaoh and his officials. So all the water in the river changed into blood. ");
INSERT INTO engerv_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","The fish in the river died, and the river began to stink. So the Egyptians could not drink water from the river. The blood was everywhere in Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","The magicians used their magic to do the same thing. So Pharaoh refused to listen to Moses and Aaron. This happened just as the LORD said. ");
INSERT INTO engerv_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh ignored what Moses and Aaron had done. He turned and went into his house. ");
INSERT INTO engerv_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","The Egyptians could not drink the water from the river, so they dug wells around the river for water to drink. ");
INSERT INTO engerv_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Seven days passed after the LORD changed the Nile River. ");
INSERT INTO engerv_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Then the LORD told Moses, “Go to Pharaoh and tell him that the LORD says, ‘Let my people go to worship me! ");
INSERT INTO engerv_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","If you refuse to let my people go, then I will fill Egypt with frogs. ");
INSERT INTO engerv_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","The Nile River will be filled with frogs. They will come from the river and enter your houses. They will be in your bedrooms and in your beds. They will be in the houses of your officials and in your ovens and in your jars of water. ");
INSERT INTO engerv_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","The frogs will be all over you, your people, and your officials.’” ");
INSERT INTO engerv_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Then the LORD said to Moses, “Tell Aaron to hold the walking stick in his hand over the canals, rivers, and lakes. Then the frogs will come out onto the land of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","So Aaron raised his hand over the waters of Egypt, and the frogs began coming out of the water and covered the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","The magicians used their magic to do the same thing—so even more frogs came out onto the land in Egypt! ");
INSERT INTO engerv_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Pharaoh called for Moses and Aaron and said, “Ask the LORD to remove the frogs from me and my people. I will let the people go to offer sacrifices to the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses said to Pharaoh, “I will pray for you, your people, and your officials. Then the frogs will leave you and your houses. They will remain only in the river. When do you want the frogs to go away?” ");
INSERT INTO engerv_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh said, “Tomorrow.” Moses said, “It will happen as you say. In this way you will know that there is no god like the LORD our God. ");
INSERT INTO engerv_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","The frogs will leave you, your house, your officials, and your people. They will remain only in the river.” ");
INSERT INTO engerv_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moses and Aaron left Pharaoh. Moses prayed to the LORD about the frogs he had sent against Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","And the LORD did what Moses asked. The frogs died in the houses, in the yards, and in the fields. ");
INSERT INTO engerv_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","They began to rot, and the whole country began to stink. ");
INSERT INTO engerv_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","But when Pharaoh saw that they were free of the frogs, he again became stubborn. Pharaoh did not do what Moses and Aaron had asked him to do. This happened just as the LORD had said. ");
INSERT INTO engerv_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Then the LORD said to Moses, “Tell Aaron to raise his stick and hit the dust on the ground, and everywhere in Egypt dust will become lice.” ");
INSERT INTO engerv_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","They did this. Aaron raised the stick in his hand and hit the dust on the ground, and everywhere in Egypt the dust became lice. The lice got on the animals and the people. ");
INSERT INTO engerv_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","The magicians used their magic and tried to do the same thing. But the magicians could not make lice come from the dust. The lice remained on the animals and the people. ");
INSERT INTO engerv_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","So the magicians told Pharaoh that the power of God did this. But Pharaoh refused to listen to them. This happened just as the LORD had said. ");
INSERT INTO engerv_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","The LORD said to Moses, “Get up in the morning and go to Pharaoh. He will go out to the river. Tell him that the LORD says, ‘Let my people go and worship me! ");
INSERT INTO engerv_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","If you don’t let my people go, then flies will come into your houses. The flies will be on you and your officials. The houses of Egypt will be full of flies. They will be all over the ground too! ");
INSERT INTO engerv_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","But I will not treat the Israelites the same as the Egyptians. There will not be any flies in Goshen, where my people live. In this way you will know that I, the LORD, am in this land. ");
INSERT INTO engerv_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","So tomorrow I will treat my people differently from your people. This will be my proof.’” ");
INSERT INTO engerv_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","So the LORD did just what he said. Millions of flies came into Egypt. The flies were in Pharaoh’s house, and they were in all his officials’ houses. They were all over Egypt. The flies were ruining the country. ");
INSERT INTO engerv_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","So Pharaoh called for Moses and Aaron and told them, “Offer sacrifices to your God here in this country.” ");
INSERT INTO engerv_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","But Moses said, “It would not be right to do that. The Egyptians think it is terrible to kill animals as sacrifices for the LORD our God. If we do this here, the Egyptians will see us and throw stones at us and kill us. ");
INSERT INTO engerv_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Let us go three days into the desert and offer sacrifices to the LORD our God. This is what he told us to do.” ");
INSERT INTO engerv_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","So Pharaoh said, “I will let you go and offer sacrifices to the LORD your God in the desert, but you must not go very far. Now, go and pray for me.” ");
INSERT INTO engerv_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses said, “Look, I will leave and ask the LORD to remove the flies from you, your people, and your officials tomorrow. But you must not stop the people from offering sacrifices to the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","So Moses left Pharaoh and prayed to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","And the LORD did what Moses asked. He removed the flies from Pharaoh, his officials, and his people. None of the flies remained. ");
INSERT INTO engerv_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","But Pharaoh again became stubborn and did not let the people go. ");
INSERT INTO engerv_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Then the LORD told Moses to go to Pharaoh and tell him: “The LORD, the God of the Hebrews, says, ‘Let my people go to worship me!’ ");
INSERT INTO engerv_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","If you continue to hold them and refuse to let them go, ");
INSERT INTO engerv_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","then the LORD will use his power against your animals in the fields. He will cause all of your horses, donkeys, camels, cattle, and sheep to get sick with a terrible disease. ");
INSERT INTO engerv_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","But the LORD will treat Israel’s animals differently from the animals of Egypt. None of the animals that belong to the Israelites will die. ");
INSERT INTO engerv_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","The LORD has set the time for this to happen. He said, ‘Tomorrow the LORD will make this happen in this country.’” ");
INSERT INTO engerv_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","The next morning the LORD did what he said. All the farm animals of the Egyptians died, but none of the animals that belonged to the Israelites died. ");
INSERT INTO engerv_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaoh sent people to see if any of the animals of Israel died. Not one of them died. But Pharaoh remained stubborn and did not let the people go. ");
INSERT INTO engerv_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","The LORD said to Moses and Aaron, “Fill your hands with the ashes from a furnace. Moses, you throw the ashes into the air in front of Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","This will become dust that will go throughout the land of Egypt. Whenever the dust touches a person or an animal in Egypt, sores will break out on the skin.” ");
INSERT INTO engerv_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","So Moses and Aaron took ashes from a furnace and went and stood before Pharaoh. Moses threw the ashes into the air, and sores began breaking out on people and animals. ");
INSERT INTO engerv_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","The magicians could not stop Moses from doing this, because even the magicians had the sores. This happened everywhere in Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","But the LORD made Pharaoh stubborn, so he refused to listen to Moses and Aaron, just as the LORD had said. ");
INSERT INTO engerv_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Then the LORD said to Moses, “Get up in the morning and go to Pharaoh. Tell him that the LORD, the God of the Hebrews, says, ‘Let my people go to worship me! ");
INSERT INTO engerv_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","This time, I will use my full power against you, your officials, and your people. Then you will know that there is no god in the world like me. ");
INSERT INTO engerv_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","I could use my power and cause a disease that would wipe you and your people off the earth. ");
INSERT INTO engerv_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","But I have put you here for a reason. I have put you here so that I could show you my power. Then people all over the world will learn about me! ");
INSERT INTO engerv_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","You are still against my people. You are not letting them go free. ");
INSERT INTO engerv_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","So at this time tomorrow, I will cause a very bad hailstorm. There has never been a hailstorm like this in Egypt, not since Egypt became a nation. ");
INSERT INTO engerv_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Now, you must put your animals in a safe place. Everything you own that is now in the fields must be put in a safe place. Any person or animal that remains in the fields will be killed. The hail will fall on everything that is not gathered into your houses.’” ");
INSERT INTO engerv_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Some of Pharaoh’s officials paid attention to the LORD’S message. They quickly put all of their animals and slaves into houses. ");
INSERT INTO engerv_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","But other people ignored the LORD’S message and lost all their slaves and animals that were in the fields. ");
INSERT INTO engerv_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","The LORD told Moses, “Raise your hand into the air and the hail will start falling all over Egypt. The hail will fall on all the people, animals, and plants in all the fields of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","So Moses raised his walking stick into the air, and the LORD sent hail with thunder and lightning down on the earth. The LORD caused hail to fall all over Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","The hail was falling, and lightning was flashing all through it. It was the worst hailstorm that had ever hit Egypt since it had become a nation. ");
INSERT INTO engerv_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","The storm destroyed everything in the fields in Egypt. The hail destroyed people, animals, and plants. The hail also broke all the trees in the fields. ");
INSERT INTO engerv_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","The only place that did not get hail was the land of Goshen, where the Israelites lived. ");
INSERT INTO engerv_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaoh sent for Moses and Aaron and told them, “This time I have sinned. The LORD is right, and I and my people are wrong. ");
INSERT INTO engerv_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","We have had enough of this hail and thunder! Ask the LORD to stop the storm, and I will let you go. You don’t have to stay here.” ");
INSERT INTO engerv_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moses told Pharaoh, “When I leave the city, I will lift my hands in prayer to the LORD, and the thunder and hail will stop. Then you will know that the LORD is in this land. ");
INSERT INTO engerv_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","But I know that you and your officials don’t really fear and respect the LORD yet.” ");
INSERT INTO engerv_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","The flax had already developed its seeds, and the barley was already blooming. So these plants were destroyed. ");
INSERT INTO engerv_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","But wheat and spelt ripen later than the other grains, so these plants were not destroyed. ");
INSERT INTO engerv_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses left Pharaoh and went outside the city. He lifted his hands in prayer to the LORD. And the thunder and hail stopped, and then even the rain stopped. ");
INSERT INTO engerv_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","When Pharaoh saw that the rain, hail, and thunder had stopped, he again did wrong. He and his officials became stubborn again. ");
INSERT INTO engerv_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pharaoh refused to let the Israelites go free, just as the LORD had said through Moses. ");
INSERT INTO engerv_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","The LORD said to Moses, “Go to Pharaoh. I have made him and his officials stubborn. I did this so that I could show them my powerful miracles. ");
INSERT INTO engerv_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","I also did this so that you could tell your children and your grandchildren about the miracles and other wonderful things that I have done in Egypt. Then all of you will know that I am the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","So Moses and Aaron went to Pharaoh. They told him, “The LORD, the God of the Hebrews, says, ‘How long will you refuse to obey me? Let my people go to worship me! ");
INSERT INTO engerv_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","If you refuse to let my people go, then tomorrow I will bring locusts into your country. ");
INSERT INTO engerv_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","The locusts will cover the land. There will be so many locusts that you will not be able to see the ground. Anything that was left from the hailstorm will be eaten by the locusts. The locusts will eat all the leaves from every tree in the field. ");
INSERT INTO engerv_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","They will fill all your houses, and all your officials’ houses, and all the houses in Egypt. There will be more locusts than your fathers or your grandfathers have ever seen. There will be more locusts than there have ever been since people began living in Egypt.’” Then Moses turned and left Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Then the officials asked Pharaoh, “How long will we be trapped by these people? Let the men go to worship the LORD their God. If you don’t let them go, before you know it, Egypt will be destroyed!” ");
INSERT INTO engerv_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","So Pharaoh told his officials to bring Moses and Aaron back to him. Pharaoh said to them, “Go and worship the LORD your God. But tell me, just who is going?” ");
INSERT INTO engerv_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses answered, “All of our people, young and old, will go. And we will take our sons and daughters, and our sheep and cattle with us. We will all go because the LORD’S festival is for all of us.” ");
INSERT INTO engerv_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh said to them, “The LORD really will have to be with you before I let you and all of your children leave Egypt. Look, you are planning something evil. ");
INSERT INTO engerv_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","The men can go worship the LORD. That is what you asked for in the beginning. But all of your people cannot go.” Then Pharaoh sent Moses and Aaron away. ");
INSERT INTO engerv_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","The LORD told Moses, “Raise your hand over the land of Egypt and the locusts will come! They will spread all over the land of Egypt and will eat all the plants that the hail did not destroy.” ");
INSERT INTO engerv_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","So Moses raised his walking stick over the land of Egypt, and the LORD caused a strong wind to blow from the east. The wind blew all that day and night. When morning came, the wind had brought the locusts to the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","The locusts flew into the country of Egypt and landed on the ground. There were more locusts than there had ever been in Egypt. And there will never again be that many locusts there. ");
INSERT INTO engerv_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","They covered the ground, and the whole country became dark. The locusts ate every plant on the ground and all the fruit in the trees that the hail had not destroyed. There were no leaves left on any of the trees or plants anywhere in Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaoh quickly called for Moses and Aaron. Pharaoh said, “I have sinned against the LORD your God and against you. ");
INSERT INTO engerv_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Now, forgive me for my sins this time. Ask the LORD to remove this ‘death’ from me.” ");
INSERT INTO engerv_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moses left Pharaoh and prayed to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","So the LORD changed the wind. He made a very strong wind blow from the west, and it blew the locusts out of Egypt and into the Red Sea. Not one locust was left in Egypt! ");
INSERT INTO engerv_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","But the LORD caused Pharaoh to be stubborn again, and Pharaoh did not let the Israelites go. ");
INSERT INTO engerv_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Then the LORD told Moses, “Raise your hand into the air and darkness will cover Egypt. It will be so dark you can feel it!” ");
INSERT INTO engerv_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","So Moses raised his hand into the air and a cloud of darkness covered Egypt. The darkness stayed in Egypt for three days. ");
INSERT INTO engerv_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","None of the people could see each other, and no one got up to go any place for three days. But there was light in all the places where the Israelites lived. ");
INSERT INTO engerv_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Again Pharaoh called for Moses. He said, “Go and worship the LORD! You can take your children with you. But you must leave your sheep and cattle here.” ");
INSERT INTO engerv_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moses said, “No, we will take them all. In fact, you will give us offerings and sacrifices for us to use in worshiping the LORD our God. ");
INSERT INTO engerv_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Yes, we will take our animals with us to worship the LORD our God. Not one hoof will be left behind. We don’t know yet exactly what we will need to worship the LORD. We will learn that only when we get there.” ");
INSERT INTO engerv_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","The LORD made Pharaoh stubborn again, so he refused to let them go. ");
INSERT INTO engerv_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Then Pharaoh told Moses, “Get out of here. I don’t want you to come here again. The next time you come to see me, you will die!” ");
INSERT INTO engerv_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Then Moses told Pharaoh, “You are right about one thing. I will not come to see you again.” ");
INSERT INTO engerv_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Then the LORD told Moses, “I have one more disaster to bring against Pharaoh and Egypt. After this, he will ask you to leave Egypt. In fact, he will force you to leave this country. ");
INSERT INTO engerv_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","You must give this message to the Israelites: ‘Men and women, you must ask your neighbors to give you things made of silver and gold.’” ");
INSERT INTO engerv_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","The LORD caused the Egyptians to be kind to the Israelites. The Egyptians, even Pharaoh’s own officials, already considered Moses to be a great man. ");
INSERT INTO engerv_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moses said to the king, “The LORD says, ‘At midnight tonight, I will go through Egypt, ");
INSERT INTO engerv_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","and every firstborn son in Egypt will die, from the firstborn son of Pharaoh, the ruler of Egypt, to the firstborn son of the slave girl grinding grain. Even the firstborn animals will die. ");
INSERT INTO engerv_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","The crying in Egypt will be worse than at any time in the past or any time in the future. ");
INSERT INTO engerv_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","But none of the Israelites or their animals will be hurt—not even a dog will bark at them.’ Then you will know that the LORD has treated Israel differently from Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","All these officials of yours will come down and bow to me. They will say, ‘Leave and take all your people with you.’ Only then will I leave!” Then in anger, Moses left the meeting with Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Then the LORD told Moses, “The reason Pharaoh did not listen to you is so that I could show my great power in Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","That is why Moses and Aaron did all these great miracles in front of Pharaoh. And that is why the LORD made Pharaoh so stubborn that he would not let the Israelites leave his country. ");
INSERT INTO engerv_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","While Moses and Aaron were still in Egypt, the LORD spoke to them. He said, ");
INSERT INTO engerv_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“This month will be the first month of the year for you. ");
INSERT INTO engerv_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","This command is for the whole community of Israel: On the tenth day of this month each man must get one lamb for the people in his house. ");
INSERT INTO engerv_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","If there are not enough people in his house to eat a whole lamb, then he should invite some of his neighbors to share the meal. There must be enough lamb for everyone to eat. ");
INSERT INTO engerv_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","The lamb must be a one-year-old male, and it must be completely healthy. This animal can be either a young sheep or a young goat. ");
INSERT INTO engerv_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","You should watch over the animal until the 14th day of the month. On that day all the people of the community of Israel must kill these animals just before dark. ");
INSERT INTO engerv_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","You must collect the blood from these animals and put it on the top and sides of the doorframe of every house where the people eat this meal. ");
INSERT INTO engerv_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“On this night you must roast the lamb and eat all the meat. You must also eat bitter herbs and bread made without yeast. ");
INSERT INTO engerv_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","You must not eat the lamb raw or boiled in water. You must roast the whole lamb over a fire. The lamb must still have its head, legs, and inner parts. ");
INSERT INTO engerv_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","You must eat all the meat that night. If any of the meat is left until morning, you must burn it in the fire. ");
INSERT INTO engerv_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“When you eat the meal, you must be fully dressed and ready to travel. You must have your sandals on your feet and your walking stick in your hand. You must eat in a hurry, because this is the LORD’S Passover. ");
INSERT INTO engerv_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Tonight I will go through Egypt and kill every firstborn man and animal in Egypt. In this way I will judge all the gods of Egypt and show that I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","But the blood on your houses will be a special sign. When I see the blood, I will pass over your house. I will cause bad things to happen to the people of Egypt. But none of these bad diseases will hurt you. ");
INSERT INTO engerv_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“You will always remember tonight—it will be a special festival for you. Your descendants will honor the LORD with this festival forever. ");
INSERT INTO engerv_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","For this festival you will eat bread made without yeast for seven days. On the first day, you will remove all the yeast from your houses. No one should eat any yeast for the full seven days of this festival. Anyone who eats yeast must be separated from the rest of Israel. ");
INSERT INTO engerv_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","There will be holy assemblies on the first day and the last day of the festival. You must not do any work on these days. The only work you can do is preparing the food for your meals. ");
INSERT INTO engerv_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","You must remember the Festival of Unleavened Bread, because on this day I took all of your people out of Egypt in groups. All of your descendants must remember this day. This is a law that will last forever. ");
INSERT INTO engerv_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","So on the evening of the 14th day of the first month, you will begin eating bread without yeast. You will eat this bread until the evening of the 21st day of the same month. ");
INSERT INTO engerv_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","For seven days, there must not be any yeast in your houses. Anyone, either a citizen of Israel or a foreigner living among you, who eats yeast at this time must be separated from the rest of Israel. ");
INSERT INTO engerv_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","During this festival you must not eat any yeast. You must eat bread without yeast wherever you live.” ");
INSERT INTO engerv_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","So Moses called all the elders together and told them, “Get the lambs for your families. Kill the lambs for the Passover. ");
INSERT INTO engerv_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Take bunches of hyssop and dip them in the bowls filled with blood. Paint the blood on the sides and top of each doorframe. No one must leave their house until morning. ");
INSERT INTO engerv_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","At the time the LORD goes through Egypt to kill the firstborn, he will see the blood on the sides and top of each doorframe. Then he will protect that house and not let the Destroyer come into any of your houses and hurt you. ");
INSERT INTO engerv_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","You must remember this command. This law is for you and your descendants forever. ");
INSERT INTO engerv_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","You must remember to do this even when you go to the land the LORD is giving you. ");
INSERT INTO engerv_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","When your children ask you, ‘Why are we doing this ceremony?’ ");
INSERT INTO engerv_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","you will say, ‘This Passover is to honor the LORD, because when we were in Egypt, he passed over the houses of Israel. He killed the Egyptians, but he saved the people in our houses.’” Then the people bowed down and worshiped the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","The LORD had given this command to Moses and Aaron, so the Israelites did what the Lord commanded. ");
INSERT INTO engerv_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","At midnight the LORD killed all the firstborn sons in Egypt, from the firstborn son of Pharaoh (who ruled Egypt) to the firstborn son of the prisoner sitting in jail. Also all the firstborn animals died. ");
INSERT INTO engerv_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","That night someone died in every house in Egypt. Pharaoh, his officials, and all the people of Egypt began to cry loudly. ");
INSERT INTO engerv_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","So that night Pharaoh called for Moses and Aaron and said to them, “Get up and leave my people. You and your people can do as you say. Go and worship the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Take all of your sheep and cattle with you, just as you said you would. Go! And say a blessing for me too.” ");
INSERT INTO engerv_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","The people of Egypt also asked them to hurry and leave. They said, “If you don’t leave, we will all die!” ");
INSERT INTO engerv_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","The Israelites did not have time to put the yeast in their bread. They just wrapped the bowls of dough with cloth and carried them on their shoulders. ");
INSERT INTO engerv_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Then the Israelites did what Moses asked them to do. They went to their Egyptian neighbors and asked for clothing and things made from silver and gold. ");
INSERT INTO engerv_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","The LORD caused the Egyptians to be kind to the Israelites, so the Egyptians gave their riches to the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","The Israelites traveled from Rameses to Succoth. There were about 600,000 men, not counting the small boys. ");
INSERT INTO engerv_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","A great number of people who were not Israelites went with them, along with many sheep, cattle, and other livestock. ");
INSERT INTO engerv_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","The people did not have time to put yeast in their bread or make any special food for their journey. So they had to bake their bread without yeast. ");
INSERT INTO engerv_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","The Israelites had lived in Egypt for 430 years. ");
INSERT INTO engerv_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","After 430 years, to the very day, all the armies of the LORD left Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","The night they left, the LORD watched over them to bring them safely out of Egypt. So the Israelites will always celebrate this night each year to remember what the LORD did. ");
INSERT INTO engerv_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","The LORD told Moses and Aaron, “These are the rules for Passover: No foreigner is allowed to eat the Passover. ");
INSERT INTO engerv_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","A foreigner who is only a hired worker or is only staying in your country is not allowed to eat the Passover. But if someone buys a slave and circumcises him, then the slave can eat the Passover. ");
INSERT INTO engerv_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Each family must eat the meal in one house. None of the food is to be taken outside the house. Don’t break any of the lamb’s bones. ");
INSERT INTO engerv_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","The whole community of Israel must do this ceremony. ");
INSERT INTO engerv_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","If a foreigner living among you wants to share in the LORD’S Passover, he must be circumcised. Then he can share in the meal like any other citizen of Israel. But a man who is not circumcised cannot eat the Passover meal. ");
INSERT INTO engerv_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","The same rules are for everyone. It doesn’t matter if they are citizens or foreigners living among you.” ");
INSERT INTO engerv_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","So all the Israelites obeyed the commands that the LORD gave to Moses and Aaron. ");
INSERT INTO engerv_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","On that same day the LORD led all the Israelites out of the country of Egypt. The people left in groups. ");
INSERT INTO engerv_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“You must give me every male in Israel who is his mother’s first child. That means that every firstborn baby boy and every firstborn male animal will be mine.” ");
INSERT INTO engerv_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses said to the people, “Remember this day. You were slaves in Egypt, but on this day the LORD used his great power and made you free. You must not eat bread with yeast. ");
INSERT INTO engerv_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Today, in the month of Abib, you are leaving Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","The LORD made a special promise to your ancestors. He promised to give you the land of the Canaanites, Hittites, Amorites, Hivites, and Jebusites. After the Lord leads you to the land filled with many good things, then you must remember this day. You must have a special day of worship on this day during the first month of every year. ");
INSERT INTO engerv_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“For seven days, you must eat only bread without yeast. On the seventh day there will be a great festival to show honor to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","So for seven days, you must not eat any bread made with yeast. There must be no bread with yeast any place in your land. ");
INSERT INTO engerv_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","On this day you should tell your children, ‘We are having this festival because the LORD took me out of Egypt.’ ");
INSERT INTO engerv_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“This festival will help you remember; it will be like a string tied on your hand. It will be like a sign before your eyes. This festival will help you remember the LORD’S teachings. It will help you remember that the LORD used his great power to take you out of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","So remember this festival every year at the right time. ");
INSERT INTO engerv_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“The LORD will lead you into the land he promised to give you. The Canaanites live there now. But God promised your ancestors that he would give you this land. When that happens, ");
INSERT INTO engerv_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","you must remember to give the LORD every firstborn boy. And every male animal that is the firstborn must also be given to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Every firstborn donkey can be bought back. You can offer a lamb and keep the donkey. If you don’t want to buy back the donkey like this, then you must break its neck to kill it. But every firstborn baby boy must be bought back from the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“In the future, your children will ask why you do this. They will say, ‘What does all this mean?’ And you will answer, ‘The LORD used his great power to save us from Egypt. We were slaves in that place, but he led us out and brought us here. ");
INSERT INTO engerv_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","In Egypt, Pharaoh was stubborn and refused to let us leave. So the LORD killed every firstborn in all the land. (The Lord killed the firstborn males—animal and human.) That is why I give every firstborn male animal to the LORD, and that is why I buy back each of my firstborn sons from him.’ ");
INSERT INTO engerv_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","This is like a string tied on your hand, like a sign in front of your eyes. It helps you remember that the LORD brought us out of Egypt with his great power.” ");
INSERT INTO engerv_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Pharaoh made the people leave Egypt. God did not let the people take the road leading to the land of the Philistines. That road by the Mediterranean Sea is the shortest way, but God said, “If the people go that way they will have to fight. Then they might change their minds and go back to Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","So God led them another way through the desert by the Red Sea. The Israelites were dressed for war when they left Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moses carried the bones of Joseph with him. Before Joseph died, he made the Israelites promise to do this for him. He said, “When God saves you, remember to carry my bones with you out of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","The Israelites left Succoth and camped at Etham. Etham was near the desert. ");
INSERT INTO engerv_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","The LORD led the way. During the day, he used a tall cloud to lead the people. And during the night, he used a tall column of fire to lead the way. This fire gave them light so that they could also travel at night. ");
INSERT INTO engerv_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","The cloud was always with them during the day, and the column of fire was always with them at night. ");
INSERT INTO engerv_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tell the people to go back to Pi Hahiroth. Tell them to spend the night between Migdol and the Red Sea, near Baal Zephon. ");
INSERT INTO engerv_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh will think that the Israelites are lost in the desert and that the people will have no place to go. ");
INSERT INTO engerv_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","I will make Pharaoh brave, and he will chase you. But I will defeat Pharaoh and his army. This will bring honor to me. Then the people of Egypt will know that I am the LORD.” So the Israelites did what he told them. ");
INSERT INTO engerv_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Pharaoh received a report that the Israelites had escaped. When he heard this, he and his officials changed their minds about what they had done. Pharaoh said, “Why did we let the Israelites leave? Why did we let them run away? Now we have lost our slaves!” ");
INSERT INTO engerv_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","So Pharaoh prepared his chariot and took his men with him. ");
INSERT INTO engerv_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","He took 600 of his best men and all of his chariots. There was an officer in each chariot. ");
INSERT INTO engerv_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","The Israelites were leaving with their arms raised in victory. But the LORD caused Pharaoh, the king of Egypt, to become brave. And Pharaoh chased the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","The Egyptian army had many horse soldiers and chariots. They chased the Israelites and caught up with them while they were camped near the Red Sea at Pi Hahiroth, east of Baal Zephon. ");
INSERT INTO engerv_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","When the Israelites saw Pharaoh and his army coming toward them, they were very frightened and cried to the LORD for help. ");
INSERT INTO engerv_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","They said to Moses, “Why did you bring us out of Egypt? Did you bring us out here in the desert to die? We could have died peacefully in Egypt; there were plenty of graves in Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","We told you this would happen! In Egypt we said, ‘Please don’t bother us. Let us stay and serve the Egyptians.’ It would have been better for us to stay and be slaves than to come out here and die in the desert.” ");
INSERT INTO engerv_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","But Moses answered, “Don’t be afraid! Don’t run away! Stand where you are and watch the LORD save you today. You will never see these Egyptians again. ");
INSERT INTO engerv_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","You will not have to do anything but stay calm. The LORD will do the fighting for you.” ");
INSERT INTO engerv_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Then the LORD said to Moses, “Why are you still crying to me? Tell the Israelites to start moving. ");
INSERT INTO engerv_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Raise the walking stick in your hand over the Red Sea, and the sea will split. Then the people can go across on dry land. ");
INSERT INTO engerv_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","I have made the Egyptians brave, so they will chase you. But I will show you that I am more powerful than Pharaoh and all of his horses and chariots. ");
INSERT INTO engerv_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Then Egypt will know that I am the LORD. They will honor me when I defeat Pharaoh and his horse soldiers and chariots.” ");
INSERT INTO engerv_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Then the angel of God moved to the back of the people. (The angel was usually in front of the people, leading them.) So the tall cloud moved from in front of the people and went to the back of the people. ");
INSERT INTO engerv_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","In this way the cloud stood between the Egyptians and the Israelites. There was light for the Israelites. But there was darkness for the Egyptians. So the Egyptians did not come any closer to the Israelites that night. ");
INSERT INTO engerv_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses raised his hand over the Red Sea, and the LORD caused a strong wind to blow from the east. The wind blew all night long. The sea split, and the wind made the ground dry. ");
INSERT INTO engerv_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","The Israelites went through the sea on dry land. The water was like a wall on their right and on their left. ");
INSERT INTO engerv_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Then all of Pharaoh’s chariots and horse soldiers followed them into the sea. ");
INSERT INTO engerv_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Early that morning the LORD looked down from the tall cloud and column of fire at the Egyptian army. Then he made them panic. ");
INSERT INTO engerv_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","The wheels of the chariots became stuck. It was very hard to control the chariots. The Egyptians shouted, “Let’s get out of here! The LORD is fighting against us. He is fighting for the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Then the LORD told Moses, “Raise your hand over the sea to make the water fall and cover the Egyptian chariots and horse soldiers.” ");
INSERT INTO engerv_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","So just before daylight, Moses raised his hand over the sea. And the water rushed back to its proper level. The Egyptians were running as fast as they could from the water, but the LORD swept them away with the sea. ");
INSERT INTO engerv_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","The water returned to its normal level and covered the chariots and horse soldiers. Pharaoh’s army had been chasing the Israelites, but that army was destroyed. None of them survived! ");
INSERT INTO engerv_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","But the Israelites crossed the sea on dry land. The water was like a wall on their right and on their left. ");
INSERT INTO engerv_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","So that day the LORD saved the Israelites from the Egyptians. Later, the Israelites saw the dead bodies of the Egyptians on the shore of the Red Sea. ");
INSERT INTO engerv_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","The Israelites saw the great power of the LORD when he defeated the Egyptians. So the people feared and respected the LORD, and they began to trust the LORD and his servant Moses. ");
INSERT INTO engerv_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Then Moses and the Israelites began singing this song to the LORD: “I will sing to the LORD! He has done great things. He threw horse and rider into the sea. ");
INSERT INTO engerv_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","The LORD is my strength. He saves me, and I sing songs of praise to him. He is my God, and I praise him. He is the God of my ancestors, and I honor him. ");
INSERT INTO engerv_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","The LORD is a great soldier. The LORD is his name. ");
INSERT INTO engerv_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","He threw Pharaoh’s chariots and soldiers into the sea. Pharaoh’s very best soldiers drowned in the Red Sea. ");
INSERT INTO engerv_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","The deep water covered them, and they sank to the bottom like rocks. ");
INSERT INTO engerv_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“LORD, your right hand is amazingly strong. With your right hand, LORD, you broke the enemy to pieces. ");
INSERT INTO engerv_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","In your great majesty you destroyed those who stood against you. Your anger destroyed them, like fire burning straw. ");
INSERT INTO engerv_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","The wind you sent in anger piled the water high. The flowing water became a wall, solid to its deepest parts. ");
INSERT INTO engerv_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“The enemy said, ‘I’ll chase them and catch them. I’ll take all their riches. I’ll take it all with my sword. I’ll take everything for myself.’ ");
INSERT INTO engerv_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","But you blew on them and covered them with the sea. They sank like lead into the deep sea. ");
INSERT INTO engerv_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Are there any gods like the LORD? No, there are no gods like you— you are wonderfully holy! You are amazingly powerful! You do great miracles! ");
INSERT INTO engerv_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","You raised your right hand to punish the enemy, and the ground opened up to swallow them. ");
INSERT INTO engerv_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","But with your kindness you led the people you saved. And with your strength you led them to your holy land. ");
INSERT INTO engerv_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“The other nations will hear this story, and they will be frightened. The Philistines will shake with fear. ");
INSERT INTO engerv_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","The commanders of Edom will tremble. The leaders of Moab will be afraid. The people of Canaan will lose courage. ");
INSERT INTO engerv_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","They will be filled with fear when they see your strength. They will be as still as a rock, LORD, while your people, the ones you made, pass by. ");
INSERT INTO engerv_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","You will lead your people to your own mountain. You will let them live by the place that you, LORD, prepared as your home. It is the Temple, Lord, that you yourself built. ");
INSERT INTO engerv_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“The LORD will rule forever and ever!” ");
INSERT INTO engerv_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Yes, it really happened! Pharaoh’s horses and riders, and chariots went into the sea. And the LORD brought all the water of the sea down on top of them. But the Israelites walked through that sea on dry land. ");
INSERT INTO engerv_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Then Aaron’s sister, the woman prophet Miriam, took a tambourine. She and the women began singing and dancing. ");
INSERT INTO engerv_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam repeated the words, “Sing to the LORD! He has done great things. He threw horse and rider into the sea ….” ");
INSERT INTO engerv_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moses led the Israelites away from the Red Sea and into the desert of Shur. They traveled for three days in the desert. They could not find any water. ");
INSERT INTO engerv_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Then they came to Marah. There was water at Marah, but it was too bitter to drink. (That is why the place was named Marah.) ");
INSERT INTO engerv_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","The people began complaining to Moses. They said, “Now what will we drink?” ");
INSERT INTO engerv_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","So Moses called to the LORD, and the LORD showed him a large piece of wood. When Moses put the wood in the water, the water became good to drink. There the LORD put in place a law and a command for him and tested him to see if he would obey. ");
INSERT INTO engerv_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","He said to him, “I am the LORD your God. If you listen to me and do what I say is right, and if you obey all my commands and laws, then I will not give you any of the sicknesses that I gave the Egyptians. I am the LORD who heals you.” ");
INSERT INTO engerv_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Then the people traveled to Elim. At Elim there were twelve springs of water and 70 palm trees. So the people made their camp there near that water. ");
INSERT INTO engerv_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Then all the Israelites left Elim. They reached the western Sinai desert, between Elim and Mount Sinai, on the 15th day of the second month after leaving Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Then the whole community of Israelites began complaining again. They complained to Moses and Aaron in the desert. ");
INSERT INTO engerv_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","They said, “It would have been better if the LORD had just killed us in the land of Egypt. At least there we had plenty to eat. We had all the food we needed. But now you have brought us out here into this desert to make us all die from hunger.” ");
INSERT INTO engerv_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Then the LORD said to Moses, “I will cause food to fall from the sky. This food will be for you to eat. Every day the people should go out and gather the food they need that day. I will do this to see if they will do what I tell them. ");
INSERT INTO engerv_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Every day the people will gather only enough food for one day. But on Friday, when the people prepare their food, they will see that they have enough food for two days.” ");
INSERT INTO engerv_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","So Moses and Aaron said to the Israelites, “Tonight you will see the power of the LORD. You will know that he is the one who brought you out of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","You have been complaining about the LORD, and he heard you. So tomorrow morning you will see the Glory of the LORD. You have been complaining and complaining about us. Maybe now we can have a little rest.” ");
INSERT INTO engerv_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Then Moses said, “In the evening the LORD will give you meat to eat, and in the morning you will have all the bread you want. The LORD will do this because he has heard your complaining, which was against him, not us. What can we do? We do only what he tells us to do, so your complaints are really against the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Then Moses said to Aaron, “Tell the whole community of Israelites to come together before the LORD, because he has heard their complaints.” ");
INSERT INTO engerv_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","So Aaron spoke to all the Israelites. While he was talking, the people turned and looked into the desert. And they saw the Glory of the LORD appear in a cloud. ");
INSERT INTO engerv_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“I have heard the complaints of the Israelites. So tell them, ‘Tonight you will eat meat. And in the morning you will have all the bread you want. Then you will know you can trust the LORD, your God.’” ");
INSERT INTO engerv_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","That evening, flocks of quail came and filled the camp, and in the morning dew lay on the ground all around it. ");
INSERT INTO engerv_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","After the dew was gone, something like thin flakes of frost was on the ground. ");
INSERT INTO engerv_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","When the Israelites saw it, they asked each other, “What is that?” because they did not know what it was. So Moses told them, “This is the food the LORD is giving you to eat. ");
INSERT INTO engerv_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","The LORD says, ‘Each of you should gather what you need, a basket of manna for everyone in your family.’” ");
INSERT INTO engerv_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","So that is what the Israelites did. Some people gathered a large amount, some people gathered a little. ");
INSERT INTO engerv_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","But when they measured what they had gathered, there was no shortage and there was none left over. Everyone gathered just what they needed. ");
INSERT INTO engerv_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moses told them, “Don’t save that food to eat the next day.” ");
INSERT INTO engerv_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","But some of the people did not obey Moses. They saved their food for the next day. But worms got into the food and it began to stink. Moses was angry with the people who did this. ");
INSERT INTO engerv_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Every morning the people gathered as much food as they could eat, but by noon the food melted and was gone. ");
INSERT INTO engerv_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","On Friday the people gathered twice as much food—two baskets for every person. So all the leaders of the people came and told this to Moses. ");
INSERT INTO engerv_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moses told them, “This is what the LORD said would happen. It happened because tomorrow is the Sabbath, the special day of rest to honor the LORD. You can cook all the food you need to cook for today, but save the rest of this food for tomorrow morning.” ");
INSERT INTO engerv_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","So the people saved the rest of the food for the next day, as Moses had commanded, and none of the food spoiled or had worms in it. ");
INSERT INTO engerv_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","On Saturday, Moses told the people, “Today is the Sabbath, the special day of rest to honor the LORD. So none of you should be out in the fields. Eat the food you gathered yesterday. ");
INSERT INTO engerv_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","You should gather the food for six days. But the seventh day of the week is a day of rest—so there will not be any of the special food on the ground.” ");
INSERT INTO engerv_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","On Saturday, some of the people went out to gather some of the food, but they could not find any. ");
INSERT INTO engerv_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Then the LORD said to Moses, “How long will you people refuse to obey my commands and teachings? ");
INSERT INTO engerv_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Look, the LORD has made the Sabbath a day of rest for you. So on Friday he will give you enough food for two days. Then, on the Sabbath, each of you should sit down and relax. Stay where you are.” ");
INSERT INTO engerv_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","So the people rested on the Sabbath. ");
INSERT INTO engerv_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","The people called the special food “manna.” It was like small white coriander seeds and tasted like thin cakes made with honey. ");
INSERT INTO engerv_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses told the people what the LORD said: “Save a basket of this food for your descendants. Then they can see the food that I gave to you in the desert when I took you out of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","So Moses told Aaron, “Take a jar and fill it with a full basket of manna. Save this manna to put before the LORD. Save it for our descendants.” ");
INSERT INTO engerv_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","(Aaron did what the LORD had commanded Moses. Aaron put the jar of manna in front of the Box of the Agreement.) ");
INSERT INTO engerv_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","The people ate the manna for 40 years, until they came to the land of rest, that is, until they came to the edge of the land of Canaan. ");
INSERT INTO engerv_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(The measure they used for the manna was an omer. An omer was about 8 cups.) ");
INSERT INTO engerv_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","The Israelites left the western Sinai desert. They traveled all together from place to place as the LORD commanded. They camped at Rephidim, but there was no water for the people to drink. ");
INSERT INTO engerv_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","So they turned against Moses and started arguing with him. They said, “Give us water to drink.” Moses said to them, “Why have you turned against me? Why are you testing the LORD?” ");
INSERT INTO engerv_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","But the people were very thirsty, so they continued complaining to Moses. They said, “Why did you bring us out of Egypt? Did you bring us out here so that we, our children, and our cattle will all die without water?” ");
INSERT INTO engerv_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","So Moses cried to the LORD, “What can I do with these people? They are ready to kill me.” ");
INSERT INTO engerv_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","The LORD said to Moses, “Go before the Israelites. Take some of the elders of the people with you. Carry your walking stick with you. This is the stick that you used when you hit the Nile River. ");
INSERT INTO engerv_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","I will stand before you on a rock at Horeb. Hit that rock with the walking stick and water will come out of it. Then the people can drink.” Moses did these things and the elders of Israel saw it. ");
INSERT INTO engerv_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moses named that place Meribah and Massah, because this was the place that the Israelites turned against him and tested the LORD. The people wanted to know if the LORD was with them or not. ");
INSERT INTO engerv_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","At Rephidim the Amalekites came and fought against the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","So Moses said to Joshua, “Choose some men and go and fight the Amalekites tomorrow. I will stand on the top of the hill and watch you. I will be holding the walking stick God gave me.” ");
INSERT INTO engerv_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua obeyed Moses and went to fight the Amalekites the next day. At the same time Moses, Aaron, and Hur went to the top of the hill. ");
INSERT INTO engerv_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Any time Moses held his hands in the air, the men of Israel would start winning the fight. But when Moses put his hands down, the men of Israel began to lose the fight. ");
INSERT INTO engerv_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","After some time, Moses’ arms became tired. So they put a large rock under Moses for him to sit on. Then Aaron and Hur held Moses’ hands in the air. Aaron was on one side of Moses and Hur was on the other side. They held his hands up like this until the sun went down. ");
INSERT INTO engerv_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","So Joshua and his men defeated the Amalekites in this battle. ");
INSERT INTO engerv_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Then the LORD said to Moses, “Write about this battle. Write these things in a book so that people will remember what happened here. And be sure to tell Joshua that I will completely destroy the Amalekites from the earth.” ");
INSERT INTO engerv_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Then Moses built an altar and named it, “The LORD is My Flag.” ");
INSERT INTO engerv_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moses said, “I lifted my hands toward the LORD’S throne. So the LORD fought against the Amalekites, as he always has.” ");
INSERT INTO engerv_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jethro, Moses’ father-in-law, was a priest in Midian. He heard about the many ways that God helped Moses and the Israelites. He heard about the LORD leading the Israelites out of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","So Jethro went to Moses while Moses was camped near the mountain of God. Jethro brought Moses’ wife, Zipporah, with him. (Zipporah was not with Moses, because Moses had sent her home.) ");
INSERT INTO engerv_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Jethro also brought Moses’ two sons with him. The first son was named Gershom, because when he was born, Moses said, “I am a stranger in a foreign country.” ");
INSERT INTO engerv_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","The other son was named Eliezer, because when he was born, Moses said, “The God of my father helped me and saved me from the king of Egypt.” ");
INSERT INTO engerv_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","So Jethro went to Moses while Moses was camped in the desert near the mountain of God. Moses’ wife and his two sons were with Jethro. ");
INSERT INTO engerv_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethro sent a message to Moses that said, “This is your father-in-law Jethro. I am bringing your wife and her two sons to you.” ");
INSERT INTO engerv_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","So Moses went out to meet his father-in-law. Moses bowed down before him and kissed him. The two men asked about each other’s health. Then they went into Moses’ tent to talk more. ");
INSERT INTO engerv_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moses told Jethro everything the LORD had done for the Israelites. He told what the Lord did to Pharaoh and the people of Egypt. He told about all the problems they had along the way. And he told his father-in-law how the LORD saved the Israelites every time there was trouble. ");
INSERT INTO engerv_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethro was happy when he heard all the good things the LORD had done for Israel. He was glad that the Lord had freed the Israelites from the Egyptians. ");
INSERT INTO engerv_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","He said, “Praise the LORD! He freed you from the power of Egypt. He saved you from Pharaoh. ");
INSERT INTO engerv_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Now I know the LORD is greater than all the gods. They thought they were in control, but look what God did!” ");
INSERT INTO engerv_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jethro got some sacrifices and offerings to honor God. Then Aaron and all the elders of Israel came to eat with Moses’ father-in-law Jethro. They all ate together there with God. ");
INSERT INTO engerv_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","The next day, Moses had the special job of judging the people. There were so many people that they had to stand before him all day. ");
INSERT INTO engerv_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jethro saw Moses judging the people. He asked, “Why are you doing this? Why are you the only judge? And why do people come to you all day?” ");
INSERT INTO engerv_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Then Moses said to his father-in-law, “The people come to me and ask me to ask for God’s decision for their problem. ");
INSERT INTO engerv_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","If people have an argument, they come to me, and I decide which person is right. In this way I teach the people God’s laws and teachings.” ");
INSERT INTO engerv_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","But Moses’ father-in-law said to him, “This isn’t the right way to do this. ");
INSERT INTO engerv_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","It is too much work for you to do alone. You cannot do this job by yourself. It wears you out. And it makes the people tired too. ");
INSERT INTO engerv_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Now, listen to me. Let me give you some advice. And I pray God will be with you. You should continue listening to the problems of the people. And you should continue to speak to God about these things. ");
INSERT INTO engerv_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","You should explain God’s laws and teachings to the people. Warn them not to break the laws. Tell them the right way to live and what they should do. ");
INSERT INTO engerv_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","But you should also choose some of the people to be judges and leaders. “Choose good men you can trust—men who respect God. Choose men who will not change their decisions for money. Make these men rulers over the people. There should be rulers over 1000 people, 100 people, 50 people, and even over ten people. ");
INSERT INTO engerv_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Let these rulers judge the people. If there is a very important case, then they can come to you and let you decide what to do. But they can decide the other cases themselves. In this way these men will share your work with you, and it will be easier for you to lead the people. ");
INSERT INTO engerv_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","If you do this as God directs you, then you will be able to do your job without tiring yourself out. And the people can still have all their problems solved before they return home.” ");
INSERT INTO engerv_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","So Moses did what Jethro told him. ");
INSERT INTO engerv_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moses chose good men from among the Israelites. He made them leaders over the people. There were rulers over 1000 people, 100 people, 50 people, and ten people. ");
INSERT INTO engerv_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","These rulers were judges for the people. The people could always bring their arguments to these rulers, and Moses had to decide only the most important cases. ");
INSERT INTO engerv_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","After a short time Moses said goodbye to his father-in-law Jethro, and Jethro went back to his own home. ");
INSERT INTO engerv_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","The Israelites reached the desert of Sinai in the third month of their trip from Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","They had traveled from Rephidim to the Sinai desert. The Israelites camped in the desert near Mount Sinai. ");
INSERT INTO engerv_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Then Moses climbed up the mountain to meet with God. The LORD spoke to him on the mountain and said, “Tell this to the Israelites, the great family of Jacob: ");
INSERT INTO engerv_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘You people saw what I did to the people of Egypt. You saw that I carried you out of Egypt like an eagle and brought you here to me. ");
INSERT INTO engerv_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","So now I tell you to obey my commands and keep my agreement. So if you do this, you will be my own special people. The whole world belongs to me, but I am choosing you to be my own special people. ");
INSERT INTO engerv_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","You will be a special nation—a kingdom of priests.’ Moses, you must tell the Israelites what I have said.” ");
INSERT INTO engerv_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","So Moses climbed down the mountain and called the elders of the people together. Moses told the elders everything the LORD had commanded him to tell them. ");
INSERT INTO engerv_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","All the people spoke at the same time and said, “We will obey everything the LORD says.” Then Moses went back up the mountain and told the Lord that the people would obey him. ");
INSERT INTO engerv_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Then the LORD said to Moses, “I will come to you in the thick cloud. I will speak to you. All the people will hear me talking to you. I will do this so that they will always believe what you tell them.” Then Moses told God everything the people had said. ");
INSERT INTO engerv_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","And the LORD said to Moses, “Today and tomorrow you must prepare the people for a special meeting. They must wash their clothes ");
INSERT INTO engerv_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","and be ready for me on the third day. On the third day, the LORD will come down to Mount Sinai. And all the people will see me. ");
INSERT INTO engerv_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","But you must tell the people to stay away from the mountain. Make a line and don’t let them cross it. Any person or animal that touches the mountain must be killed with stones or shot with arrows. But don’t let anyone touch them. The people must wait until the trumpet blows. Only then can they go up the mountain.” ");
INSERT INTO engerv_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","So Moses climbed down the mountain and went to the people. He got them ready for the special meeting and they washed their clothes. ");
INSERT INTO engerv_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Then Moses said to the people, “Be ready for the meeting with God in three days. Until that time do not have sexual relations.” ");
INSERT INTO engerv_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","On the morning of the third day, a thick cloud came down onto the mountain. There was thunder and lightning and a very loud sound from a trumpet. All the people in the camp were frightened. ");
INSERT INTO engerv_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Then Moses led the people out of the camp to a place near the mountain to meet God. ");
INSERT INTO engerv_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mount Sinai was covered with smoke. Smoke rose off the mountain like smoke from a furnace. This happened because the LORD came down to the mountain in fire. Also the whole mountain began to shake. ");
INSERT INTO engerv_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","The noise from the trumpet became louder and louder. Every time Moses spoke to God, God answered him with a voice like thunder. ");
INSERT INTO engerv_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","So the LORD came down to Mount Sinai. He came from heaven to the top of the mountain. Then he called Moses to come up to the top of the mountain with him. So Moses went up the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","The LORD said to Moses, “Go down and warn the people not to come near me and look at me. If they do, many will die. ");
INSERT INTO engerv_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Also tell the priests who come near the LORD that they must prepare themselves for this special meeting. If they don’t, I, the LORD, will punish them.” ");
INSERT INTO engerv_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses said to the LORD, “But the people cannot come up the mountain. You yourself told us to make a line and not allow the people to cross the line to holy ground.” ");
INSERT INTO engerv_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","The LORD said to him, “Go down to the people. Get Aaron and bring him back with you. But don’t let the priests or the people come near me. I will punish them if they come too close.” ");
INSERT INTO engerv_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","So Moses went down to the people and told them these things. ");
INSERT INTO engerv_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","These are the things God told his people: ");
INSERT INTO engerv_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“I am the LORD your God. I am the one who freed you from the land of Egypt, where you were slaves. ");
INSERT INTO engerv_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“You must not worship any other gods except me. ");
INSERT INTO engerv_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“You must not make any idols. Don’t make any statues or pictures of anything up in the sky or of anything on the earth or of anything down in the water. ");
INSERT INTO engerv_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Don’t worship or serve idols of any kind, because I, the LORD, am your God. I hate my people worshiping other gods. People who sin against me become my enemies, and I will punish them. And I will punish their children, their grandchildren, and even their great-grandchildren. ");
INSERT INTO engerv_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","But I will be very kind to people who love me and obey my commands. I will be kind to their families for thousands of generations. ");
INSERT INTO engerv_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“You must not use the name of the LORD your God to make empty promises. If you do, the LORD will not let you go unpunished. ");
INSERT INTO engerv_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“You must remember to keep the Sabbath a special day. ");
INSERT INTO engerv_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","You may work six days a week to do your job. ");
INSERT INTO engerv_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","But the seventh day is a day of rest in honor of the LORD your God. So on that day no one should work—not you, your sons and daughters, or your men and women slaves. Even your animals and the foreigners living in your cities must not work! ");
INSERT INTO engerv_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","That is because the LORD worked six days and made the sky, the earth, the sea, and everything in them. And on the seventh day, he rested. In this way the LORD blessed the Sabbath—the day of rest. He made that a very special day. ");
INSERT INTO engerv_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“You must honor and respect your father and your mother. Do this so that you will have a full life in the land that the LORD your God gives you. ");
INSERT INTO engerv_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“You must not murder anyone. ");
INSERT INTO engerv_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“You must not commit adultery. ");
INSERT INTO engerv_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“You must not steal anything. ");
INSERT INTO engerv_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“You must not tell lies about other people. ");
INSERT INTO engerv_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“You must not want to take your neighbor’s house. You must not want his wife. And you must not want his men and women servants or his cattle or his donkeys. You must not want to take anything that belongs to another person.” ");
INSERT INTO engerv_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","During all this time, the people in the valley heard the thundering and saw the lightning on the mountain. They saw smoke rising from the mountain and heard the sound of the trumpet. They were afraid and shook with fear. They stood away from the mountain and watched. ");
INSERT INTO engerv_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Then the people said to Moses, “If you want to speak to us, then we will listen. But please don’t let God speak to us. If this happens, we will die.” ");
INSERT INTO engerv_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Then Moses said to them, “Don’t be afraid! God has come to test you. He wants you to respect him so that you will not sin.” ");
INSERT INTO engerv_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","The people stood far away from the mountain while Moses went to the dark cloud where God was. ");
INSERT INTO engerv_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Then the LORD told Moses to say this to the Israelites: “You people have seen that I talked with you from heaven. ");
INSERT INTO engerv_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","So you must not make idols using gold or silver to compete with me. You must not make these false gods. ");
INSERT INTO engerv_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Make a special altar for me. You should use dirt to make this altar. Offer sheep and cattle as burnt offerings and fellowship offerings on this altar. Do this in every place where I tell you to remember me. Then I will come and bless you. ");
INSERT INTO engerv_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","But if you use stones to make an altar, then don’t use stones that were cut with an iron tool. If you do that, it will make the altar unacceptable. ");
INSERT INTO engerv_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","And you must not make steps leading up to the altar. If there are steps, when people look up to the altar, they will be able to see under your clothes.” ");
INSERT INTO engerv_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Then God said to Moses, “These are the other laws that you will give to the people: ");
INSERT INTO engerv_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“If you buy a Hebrew slave, then that slave will serve for only six years. After six years, he will be free, and he will have to pay nothing. ");
INSERT INTO engerv_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","If he is not married when he becomes your slave, when he becomes free, he will leave without a wife. But if the man is married when he becomes your slave, then he will keep his wife at the time he is made free. ");
INSERT INTO engerv_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","If the slave is not married, the master can give him a wife. If that wife gives birth to sons or daughters, she and her children will belong to the master. After the slave is finished with his years of service, he will be made free. ");
INSERT INTO engerv_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“But if the slave decides that he wants to stay with the master, he must say, ‘I love my master. I love my wife and my children. I will not become free—I will stay.’ ");
INSERT INTO engerv_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","If this happens, the master will bring the slave before God. The master will take the slave to a door or the wooden frame around the door and pierce the slave’s ear using a sharp tool to show that the slave will serve that master for all his life. ");
INSERT INTO engerv_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“A man might decide to sell his daughter as a slave. If this happens, the rules for making her free are not the same as the rules for making the men slaves free. ");
INSERT INTO engerv_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","If the master who chose her for himself is not pleased with her, then he can sell the woman back to her father. If the master broke his promise to marry her, he loses the right to sell her to other people. ");
INSERT INTO engerv_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","If the master promised to let the slave woman marry his son, he must treat her like a daughter, not like a slave. ");
INSERT INTO engerv_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“If the master marries another woman, he must not give less food or clothing to the first wife. And he must continue to give her what she has a right to have in marriage. ");
INSERT INTO engerv_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","The man must do these three things for her. If he does not, the woman is made free, and it will cost her nothing. She owes no money to the man. ");
INSERT INTO engerv_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Whoever hits and kills someone must be killed too. ");
INSERT INTO engerv_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","But if an accident happens, and a person kills someone without planning it, then God allowed that thing to happen. I will choose some special places where people can run to for safety. So that person can run to one of those places. ");
INSERT INTO engerv_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","But whoever plans to kill someone out of anger or hatred must be punished. Take them away from my altar and kill them. ");
INSERT INTO engerv_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Whoever hits their father or their mother must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Whoever steals someone to sell them as a slave or to keep them for their own slave must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Whoever curses their father or mother must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Two men might argue and one might hit the other with a rock or with his fist. If the man who was hurt is not killed, the man who hurt him should not be killed. ");
INSERT INTO engerv_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","If the man was hurt and must stay in bed for some time, the man who hurt him must support him. The man who hurt him must pay for the loss of his time. He must support him until he is completely healed. ");
INSERT INTO engerv_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sometimes people beat their slaves. If the slave dies after being beaten, the killer must be punished. ");
INSERT INTO engerv_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","But if the slave gets up after a few days, then the master will not be punished. That is because someone paid their money for the slave, and the slave belongs to them. ");
INSERT INTO engerv_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Two men might be fighting and hurt a pregnant woman. This might make the woman give birth to her baby before its time. If the woman was not hurt badly, the man who hurt her must pay a fine. The woman’s husband will decide how much the man must pay. The judges will help the man decide how much the fine will be. ");
INSERT INTO engerv_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","But if the woman was hurt badly, then the man who hurt her must be punished. The punishment must fit the crime. You must trade one life for another life. ");
INSERT INTO engerv_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","You must trade an eye for an eye, a tooth for a tooth, a hand for a hand, a foot for a foot, ");
INSERT INTO engerv_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","a burn for a burn, a bruise for a bruise, a cut for a cut. ");
INSERT INTO engerv_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“If a man hits a slave in the eye, and the slave is blinded in that eye, then the slave will be allowed to go free. His eye is the payment for his freedom. This is the same for a man or a woman slave. ");
INSERT INTO engerv_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","If a master hits his slave in the mouth, and the slave loses a tooth, then the slave will be allowed to go free. The slave’s tooth is payment for the slave’s freedom. This is the same for a man or a woman slave. ");
INSERT INTO engerv_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“If a man’s bull kills a man or woman, then you should use stones and kill that bull. You should not eat the bull. The owner of the bull is not guilty. ");
INSERT INTO engerv_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","But if the bull had hurt people in the past, and if the owner was warned, then the owner is guilty. That is because he did not keep the bull tied or locked in its place. So if the bull is allowed to be free and kills someone, the owner is guilty. You should kill the bull with stones and also kill the owner. ");
INSERT INTO engerv_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","But the family of the dead man may accept money. If they accept money, the man who owned the bull should not be killed. But he must pay as much money as the judge decides. ");
INSERT INTO engerv_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“This same law must be followed if the bull kills someone’s son or daughter. ");
INSERT INTO engerv_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","But if the bull kills a slave, the owner of the animal must pay the master 30 pieces of silver. And the bull must also be killed with stones. This law will be the same for men and women slaves. ");
INSERT INTO engerv_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“A man might take a cover off a well or dig a hole and not cover it. If another man’s animal comes and falls into that hole, the man who owns the hole is guilty. ");
INSERT INTO engerv_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","The man who owns the hole must pay for the animal. But after he pays for the animal, he will be allowed to keep the body of that animal. ");
INSERT INTO engerv_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“If one man’s bull kills another man’s bull, they should sell the bull that is alive. Both men will get half of the money that comes from selling the bull, and both men will also get half of the bull that was killed. ");
INSERT INTO engerv_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","But if a man’s bull has hurt other animals in the past, that owner is responsible for his bull. If his bull kills another bull, he is guilty because he allowed the bull to be free. That man must pay bull for bull. He must trade his bull for the bull that was killed. ");
INSERT INTO engerv_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“How should you punish a man who steals a bull or a sheep? If the man kills the animal or sells it, then he cannot give it back. So he must pay five bulls for the one he stole. Or he must pay four sheep for the one he stole. He must pay for stealing. ");
INSERT INTO engerv_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","If he owns nothing, then he will be sold as a slave. But if the man still has the animal and you find it, that man must give the owner two animals for every animal he stole. It doesn’t matter if the animal was a bull, a donkey, or a sheep. “If a thief is killed while trying to break into a house at night, then no one will be guilty for killing him. But if this happens during the day, the one who killed him will be guilty of murder. ");
INSERT INTO engerv_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“A man might let his animal loose to graze in his field or vineyard. If the animal wanders into another person’s field or vineyard, then the owner must pay. The payment must come from the best of his crop. ");
INSERT INTO engerv_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“A man might start a fire to burn thornbushes on his field. But if the fire grows and burns his neighbor’s crops or the grain growing on the neighbor’s field, the man who started the fire must pay for what he burned. ");
INSERT INTO engerv_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Someone might give some money or tools to a neighbor for safekeeping. What should you do if someone steals those things from the neighbor’s house? If you find the one who stole them, then that thief must pay twice as much as the things are worth. ");
INSERT INTO engerv_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","If you don’t find the thief, then the owner of the house must go before the judges who will decide if that person is guilty. ");
INSERT INTO engerv_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“What should you do if two men disagree about a bull or a donkey or sheep or clothing or something that is lost? One man says, ‘This is mine,’ and the other says, ‘No, it is mine.’ Both men should go before the judges who will decide who is guilty. The one who was wrong must pay the other man twice as much as the thing is worth. ");
INSERT INTO engerv_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“A man might ask his neighbor to take care of an animal for a short time. It might be a donkey, a bull, or a sheep. But what should you do if that animal is hurt or dies or someone takes the animal while no one is looking? ");
INSERT INTO engerv_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","That neighbor must explain that he did not steal the animal. If this is true, the neighbor will promise to the LORD that he did not steal it. The owner of the animal must accept this promise. The neighbor does not have to pay the owner for the animal. ");
INSERT INTO engerv_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","But if the neighbor stole the animal, then he must pay the owner for the animal. ");
INSERT INTO engerv_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","If wild animals killed the animal, then the neighbor should bring the body as proof. The neighbor will not have to pay the owner for the animal that was killed. ");
INSERT INTO engerv_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“If a man borrows an animal from his neighbor, and the animal is hurt or dies, then the neighbor must pay the owner for the animal. The neighbor is responsible, because the owner was not there himself. ");
INSERT INTO engerv_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","But if the owner was there, then the neighbor does not have to pay. Or if the neighbor was paying money to use the animal for work, he will not have to pay if the animal dies or is hurt. The money he paid to use the animal will be enough payment. ");
INSERT INTO engerv_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“If a man has sexual relations with a virgin who he is not engaged to, then he must pay her father the full amount necessary to marry her. ");
INSERT INTO engerv_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","If the father refuses to allow his daughter to marry him, then the man must still pay the full amount for her. ");
INSERT INTO engerv_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“You must not allow any woman to do evil magic. If she does magic, you must not let her live. ");
INSERT INTO engerv_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“You must not allow anyone to have sexual relations with an animal. If this happens, that person must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Whoever makes a sacrifice to a false god should be destroyed. The LORD is the only one you should make sacrifices to. ");
INSERT INTO engerv_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Remember, in the past you were foreigners in the land of Egypt. So you should not cheat or hurt anyone who is a foreigner in your land. ");
INSERT INTO engerv_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“You must never do anything bad to women whose husbands are dead or to orphans. ");
INSERT INTO engerv_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","If you do anything wrong to these widows or orphans, I will know it. I will hear about their suffering. ");
INSERT INTO engerv_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","And I will be very angry. I will kill you with a sword. Then your wives will become widows, and your children will become orphans. ");
INSERT INTO engerv_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“If you loan money to any of my people, that is, the poor among you, don’t be like a moneylender and charge them interest. ");
INSERT INTO engerv_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","You might take their cloak to make sure they pay the money back, but you must give that cloak back to them before sunset. ");
INSERT INTO engerv_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","That cloak might be their only protection against the cold when they lie down to sleep. If they call to me for help, I will listen because I am kind. ");
INSERT INTO engerv_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“You must not curse God or the leaders of your people. ");
INSERT INTO engerv_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“At harvest time you should give me the first grain and the first juice from your fruit. Don’t wait until late in the year. “Give me your firstborn sons. ");
INSERT INTO engerv_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Also, give me your firstborn cattle and sheep. Let the firstborn stay with its mother for seven days. Then on the eighth day, give him to me. ");
INSERT INTO engerv_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“You are my special people. So don’t eat the meat from something that was killed by wild animals. Let the dogs eat that dead animal. ");
INSERT INTO engerv_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Don’t tell lies against other people. If you are a witness in court, don’t agree to help a bad person tell lies. ");
INSERT INTO engerv_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Don’t do something just because everyone else is doing it. If you see a group of people doing wrong, don’t join them. You must not let them persuade you to do wrong things—you must do what is right and fair. ");
INSERT INTO engerv_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“In court, don’t treat a person in a special way simply because that person is poor. ");
INSERT INTO engerv_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“If you see a lost bull or donkey, then you must return it to its owner—even if the owner is your enemy. ");
INSERT INTO engerv_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","“If you see an animal that cannot walk because it has too much to carry, you must stop and help that animal. You must help that animal even if it belongs to one of your enemies. ");
INSERT INTO engerv_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“In court, don’t let anyone take advantage of a person simply because that person is poor. ");
INSERT INTO engerv_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Be very careful if you say that someone is guilty of something. Don’t make false charges against a person. Never allow innocent people to be killed as punishment for something they did not do. Whoever kills an innocent person is evil, and I will not treat a guilty person as innocent. ");
INSERT INTO engerv_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“If someone tries to pay you to agree with them when they are wrong, don’t accept that payment. A payment like that can blind judges so that they cannot see the truth. It can make good people tell lies. ");
INSERT INTO engerv_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“You must never do wrong things to a foreigner. Remember, you know what it is like to be a foreigner because at one time you were foreigners in the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Plant seeds, harvest your crops, and work the ground for six years. ");
INSERT INTO engerv_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","But the seventh year must be a special time of rest for the land. Don’t plant anything in your fields. If any crops grow there, allow the poor to have it. And allow the wild animals to eat the food that is left. You should do the same with your vineyards and with your fields of olive trees. ");
INSERT INTO engerv_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Work for six days, but on the seventh day, rest! This will allow your slaves and other workers a time to rest and relax. And your bulls and donkeys will also have a time of rest. ");
INSERT INTO engerv_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Be sure that you obey all these laws. Don’t worship false gods. You should not even speak their names! ");
INSERT INTO engerv_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“You will have three special festivals each year. You must come to my special place to worship me during these festivals. ");
INSERT INTO engerv_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","The first festival is the Festival of Unleavened Bread. This is as I commanded you. During this time you will eat bread that is made without yeast. This will continue for seven days. You will do this during the month of Abib, because this is the time when you came out of Egypt. Everyone must bring a sacrifice to me at that time. ");
INSERT INTO engerv_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“The second festival will be the Festival of Harvest. This festival will be during the early summer when you begin harvesting the first crops that you planted in your fields. “The third festival will be the Festival of Shelters. This will be in the fall, when you finish gathering the rest of the crops from your fields. ");
INSERT INTO engerv_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“So three times each year all the men will come to the special place to be with the Lord GOD. ");
INSERT INTO engerv_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“When you kill an animal and offer its blood as a sacrifice, you must not include anything that has yeast in it. And when you burn the fat from my sacrifice, don’t let any of it remain until morning. ");
INSERT INTO engerv_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“When you gather your crops at harvest time, you should bring the first of everything you harvest to the house of the LORD your God. “You must not eat the meat from a young goat that is boiled in its mother’s milk.” ");
INSERT INTO engerv_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“I am sending an angel before you to protect you along the way and to lead you to the place that I have prepared for you. ");
INSERT INTO engerv_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Obey the angel and follow him. Be careful in his presence, and don’t rebel against him. The angel will not forgive the wrong things you do to him. He has my power in him. ");
INSERT INTO engerv_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","If you listen to what he says and do everything I tell you, then I will be an enemy to all of your enemies. I will be against everyone who is against you. ");
INSERT INTO engerv_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“My angel will lead you through the land. He will lead you against many different people—the Amorites, Hittites, Perizzites, Canaanites, Hivites, and Jebusites. But I will defeat all of them. ");
INSERT INTO engerv_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“Don’t worship their gods. Don’t ever bow down to those gods. You must never live the way those people live. You must destroy their idols. And you must break the stones that help them remember their gods. ");
INSERT INTO engerv_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","You must serve the LORD your God. If you do this, I will bless you with plenty of bread and water. I will take away all sickness from you. ");
INSERT INTO engerv_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Your women will all be able to have babies. None of their babies will die at birth. And I will allow you to live long lives. ");
INSERT INTO engerv_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“When you fight against your enemies, I will send my great power before you. I will help you defeat all your enemies. The people who are against you will become confused in battle and run away. ");
INSERT INTO engerv_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","I will send the hornet in front of you. He will force your enemies to leave. The Hivites, Canaanites, and Hittites will leave your country. ");
INSERT INTO engerv_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","But I will not force all of them out of your land quickly. I will not do this in only one year. The land will be empty if I force the people out too fast. Then all the wild animals would increase and control the land. And they would be much trouble for you. ");
INSERT INTO engerv_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","So I will force them out of your land very slowly. I will do this as you grow and eventually take the land to be your own. ");
INSERT INTO engerv_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“I will give you all the land from the Red Sea to the Mediterranean Sea, and from the desert of Sinai to the Euphrates River. I will let you defeat the people living there and force them all to leave. ");
INSERT INTO engerv_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“You must not make any agreements with any of those people or their gods. ");
INSERT INTO engerv_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Don’t let them stay in your country. If you let them stay, they will be like a trap to you—they will cause you to sin against me. And you will begin worshiping their gods.” ");
INSERT INTO engerv_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","The LORD told Moses, “You, Aaron, Nadab, Abihu, and the 70 elders of Israel must come up the mountain and worship me from a distance. ");
INSERT INTO engerv_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Then only Moses will come close to the LORD. The other men must not come close, and the rest of the people must not even come up the mountain.” ");
INSERT INTO engerv_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses told the people all the rules and commands from the LORD. Then all the people said, “We will obey all the commands that the LORD has spoken.” ");
INSERT INTO engerv_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","So Moses wrote down all the commands of the LORD. The next morning he got up and built an altar near the bottom of the mountain. And he set up twelve stones—one for each of the twelve tribes of Israel. ");
INSERT INTO engerv_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Then Moses sent young men of Israel to offer sacrifices. These men offered bulls to the LORD as burnt offerings and fellowship offerings. ");
INSERT INTO engerv_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moses saved the blood from these animals. He put half of the blood in bowls, and he poured the other half of the blood on the altar. ");
INSERT INTO engerv_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Moses read the scroll with the special agreement written on it. He read the agreement so that all the people could hear him. And the people said, “We have heard the laws that the LORD has given us. And we agree to obey them.” ");
INSERT INTO engerv_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Then Moses held the bowls full of the blood from the sacrifices. He threw that blood on the people. He said, “This blood shows that the LORD has made a special agreement with you. The laws God gave you explain the agreement.” ");
INSERT INTO engerv_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Then Moses, Aaron, Nadab, Abihu, and the 70 elders of Israel went up the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","On the mountain, these men saw the God of Israel. He was standing on something that looked like blue sapphires, as clear as the sky! ");
INSERT INTO engerv_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","All the leaders of Israel saw God, but God did not destroy them. They all ate and drank together. ");
INSERT INTO engerv_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","The LORD said to Moses, “Come to me on the mountain. I have written my teachings and laws on two stone tablets. These teachings and laws are for the people. I will give these stone tablets to you.” ");
INSERT INTO engerv_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","So Moses and his helper, Joshua, went up the mountain of God. ");
INSERT INTO engerv_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moses said to the elders, “Wait here for us until we come back to you. While I am gone, Aaron and Hur will rule over you. Go to them if anyone has a problem.” ");
INSERT INTO engerv_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Then Moses went up the mountain, and the cloud covered the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","The Glory of the LORD came down on Mount Sinai. The cloud covered the mountain for six days. On the seventh day, the LORD spoke to Moses from the cloud. ");
INSERT INTO engerv_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","The Israelites could see the Glory of the LORD. It was like a fire burning on top of the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Then Moses went higher up the mountain into the cloud. He was on the mountain for 40 days and 40 nights. ");
INSERT INTO engerv_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tell the Israelites to bring me gifts. You will accept gifts for me from everyone who is willing to give. ");
INSERT INTO engerv_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Here is the list of the things that you should accept from the people: gold, silver, and bronze; ");
INSERT INTO engerv_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","blue, purple, and red yarn and fine linen; goat hair, ");
INSERT INTO engerv_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ram skins dyed red, and fine leather; acacia wood; ");
INSERT INTO engerv_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oil for the lamps; spices for the anointing oil and spices for the sweet-smelling incense. ");
INSERT INTO engerv_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Also accept onyx stones and other jewels to be put on the ephod and the judgment pouch. ");
INSERT INTO engerv_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“The people will build a holy place for me. Then I can live among them. ");
INSERT INTO engerv_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","I will show you what the Holy Tent and everything in it should look like. Build everything exactly as I show you. ");
INSERT INTO engerv_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Use acacia wood and build a special box. This Holy Box must be 2 1/2 cubits long, 1 1/2 cubits wide, and 1 1/2 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Use pure gold to cover the Box inside and out. Put gold trim around the edges of the Box. ");
INSERT INTO engerv_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Make four gold rings for carrying the Box. Put the gold rings on the four corners, two rings on each side. ");
INSERT INTO engerv_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Then make poles for carrying the Box. These poles should be made from acacia wood and covered with gold. ");
INSERT INTO engerv_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Put the poles through the rings on the corners of the Box. Use these poles to carry the Box. ");
INSERT INTO engerv_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","These poles should always stay in the rings of the Box. Don’t take the poles out. ");
INSERT INTO engerv_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","“I will give you the Agreement. Put it into this Box. ");
INSERT INTO engerv_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Then make a lid, the mercy-cover. Make it from pure gold. Make it 2 1/2 cubits long and 1 1/2 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Then make two Cherub angels and put them on each end of the mercy-cover. Hammer gold to make these angels. ");
INSERT INTO engerv_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Put one angel on one end of the mercy-cover, and put the other angel on the other end. Join the angels together with the mercy-cover to make one piece. ");
INSERT INTO engerv_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","The wings of these angels should spread up toward the sky. The angels should cover the Box with their wings and should face each other, looking toward the mercy-cover. ");
INSERT INTO engerv_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“I will give you the Agreement. Put it in the Box, and put the mercy-cover on the Box. ");
INSERT INTO engerv_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","When I meet with you, I will speak from between the Cherub angels on the mercy-cover that is on the Box of the Agreement. From that place, I will give all my commands to the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Make a table from acacia wood. The table must be 2 cubits long, 1 cubit wide, and 1 1/2 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Cover the table with pure gold and put gold trim around it. ");
INSERT INTO engerv_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Then make a frame 1 handbreadth wide around the table. And put gold trim on the frame. ");
INSERT INTO engerv_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Then make four gold rings and put them on the four corners of the table, where the four legs are. ");
INSERT INTO engerv_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Put the rings close to the frame around the top of the table. These rings will hold the poles used to carry the table. ");
INSERT INTO engerv_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Use acacia wood to make the poles, and cover them with gold. The poles are for carrying the table. ");
INSERT INTO engerv_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Make the plates, the spoons, the pitchers, and the bowls from pure gold. The pitchers and bowls will be used for pouring the drink offerings. ");
INSERT INTO engerv_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Put the special bread before me on the table. It must always be there in front of me. ");
INSERT INTO engerv_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Then you must make a lampstand. Use pure gold and hammer it to make the base and the shaft. Make flowers, buds, and petals from pure gold. Join all these things together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“The lampstand must have six branches—three branches on one side and three branches on the other. ");
INSERT INTO engerv_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Each branch must have three flowers. Make these flowers like almond flowers with buds and petals. ");
INSERT INTO engerv_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Make four more flowers for the lampstand. These flowers must be made like almond flowers with buds and petals. ");
INSERT INTO engerv_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","There will be six branches on the lampstand—three branches coming out from each side of the shaft. Make a flower with buds and petals below each of the three places where the branches join the shaft. ");
INSERT INTO engerv_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","The whole lampstand with the flowers and branches must be made from pure gold. All this gold must be hammered and joined together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Then make seven lamps to go on the lampstand. These lamps will give light to the area in front of the lampstand. ");
INSERT INTO engerv_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Use pure gold to make the lamp snuffers and trays. ");
INSERT INTO engerv_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Use 75 pounds of pure gold to make the lampstand and the things to be used with it. ");
INSERT INTO engerv_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Be very careful to make everything exactly the way I showed you on the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“The Holy Tent should be made from ten curtains. These curtains must be made from fine linen and blue, purple, and red yarn. A skilled worker should sew pictures of Cherub angels with wings into the curtains. ");
INSERT INTO engerv_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Make each curtain the same size. Each curtain should be 28 cubits long and 4 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Join the curtains together into two groups. Join five curtains together to make one group and join five curtains together to make the other group. ");
INSERT INTO engerv_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Use blue cloth to make loops along the edge of the end curtain in one group. Do the same on the end curtain in the other group. ");
INSERT INTO engerv_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","There must be 50 loops on the end curtain of the first group. And there must be 50 loops on the end curtain of the other group. These loops must be opposite each other. ");
INSERT INTO engerv_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Then make 50 gold rings to join the curtains together. This will join the Holy Tent together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Make another tent that will cover the Holy Tent. Use eleven curtains to make this tent. Make these curtains from goat hair. ");
INSERT INTO engerv_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","All these curtains must be the same size. They must be 30 cubits long and 4 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Join five of the curtains together into one group. Then join the other six curtains together into another group. Fold back half of the sixth curtain at the front of the Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Make 50 loops down the edge of the end curtain of one group. Do the same for the end curtain of the other group. ");
INSERT INTO engerv_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Then make 50 bronze rings to join the curtains together. This will join the tent together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Half of the end curtain of this tent will hang down below the back edge of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","On the sides, the curtains of this tent will hang down 1 cubit below the bottom edges of the Holy Tent. So this tent will completely cover the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Make two coverings to go over the outer tent. One covering should be made from ram skins dyed red. The other covering should be made from fine leather. ");
INSERT INTO engerv_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Use acacia wood to make frames to support the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","The frames should be 10 cubits high and 1 1/2 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Two side poles should be joined together with cross pieces to make each frame. All the frames for the Holy Tent must be the same. ");
INSERT INTO engerv_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Make 20 frames for the south side of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","And make 40 silver bases for the frames. Each frame should have two silver bases to go under it—one base for each side pole. ");
INSERT INTO engerv_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Make 20 more frames for the other side (the north side) of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","And make 40 silver bases for these frames—two bases under each frame. ");
INSERT INTO engerv_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Make six more frames for the back (the west side) of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Make two frames for the corners at the back of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","The frames at the corners should be joined together at the bottom. At the top a ring will hold the frames together. Do the same for both corners. ");
INSERT INTO engerv_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","There will be a total of eight frames for the west end of the Tent. There will be 16 silver bases—two bases under each frame. ");
INSERT INTO engerv_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Use acacia wood and make braces for the frames of the Holy Tent. There should be five braces for the first side of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","And there should be five braces for the frames on the other side of the Holy Tent. And there should be five braces for the frames at the back (the west side) of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","The middle brace should pass through the frames from one end to the other. ");
INSERT INTO engerv_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","“Cover the frames with gold. And make rings for the frames to hold the braces. Make these rings from gold. Also cover the braces with gold. ");
INSERT INTO engerv_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Build the Holy Tent the way I showed you on the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Use fine linen and make a special curtain for the inside of the Holy Tent. Use blue, purple, and red yarn and sew pictures of Cherub angels into the curtain. ");
INSERT INTO engerv_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Make four posts from acacia wood, and cover the posts with gold. Put hooks made from gold on the four posts. Put four silver bases under the posts. Then hang the curtain on the gold hooks. ");
INSERT INTO engerv_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Put the curtain under the gold rings. Then put the Box of the Agreement behind the curtain. This curtain will separate the Holy Place from the Most Holy Place. ");
INSERT INTO engerv_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Put the mercy-cover on the Box of the Agreement in the Most Holy Place. ");
INSERT INTO engerv_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“Put the special table you made outside of the curtain. The table should be on the north side of the Holy Tent. Then put the lampstand on the south side, across from the table. ");
INSERT INTO engerv_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Then make a curtain to cover the entrance to the Holy Tent. Use blue, purple, and red yarn and fine linen to make this curtain. Weave pictures into it. ");
INSERT INTO engerv_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Make gold hooks for this curtain. Make five posts using acacia wood covered with gold and make five bronze bases for the five posts. ");
INSERT INTO engerv_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Use acacia wood and build an altar. The altar should be square. It must be 5 cubits long, 5 cubits wide, and 3 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Make a horn for each of the four corners of the altar. Join each horn to its corner so that everything is one piece. Then cover the altar with bronze. ");
INSERT INTO engerv_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“Use bronze to make all the tools and dishes that will be used on the altar. Make pots, shovels, bowls, forks, and pans. These will be used for cleaning ashes from the altar. ");
INSERT INTO engerv_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Make a grating for the altar. This grating will be shaped like a net. And make a bronze ring at each of the four corners of the grating. ");
INSERT INTO engerv_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Put the grating under the ledge at the bottom of the altar. The grating will go halfway up into the altar from below. ");
INSERT INTO engerv_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“Use acacia wood to make poles for the altar, and cover them with bronze. ");
INSERT INTO engerv_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Put the poles through the rings on both sides of the altar. Use these poles for carrying the altar. ");
INSERT INTO engerv_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Make the altar like an empty box with the sides made from boards. Make the altar just as I showed you on the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Make a courtyard for the Holy Tent. The south side should have a wall of curtains 100 cubits long. These curtains must be made from fine linen. ");
INSERT INTO engerv_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Use 20 posts and 20 bronze bases under the posts. The hooks for the posts and the curtain rods should be made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","The north side must also have a wall of curtains 100 cubits long. It must have 20 posts and 20 bronze bases. The hooks for the posts and the curtain rods must be made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“On the west side of the courtyard there must be a wall of curtains 50 cubits long. There must be ten posts and ten bases. ");
INSERT INTO engerv_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","The east side of the courtyard must also be 50 cubits long. ");
INSERT INTO engerv_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Here at the entrance to the courtyard, one side must have curtains 15 cubits long. There must be three posts and three bases on this side. ");
INSERT INTO engerv_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","The other side of the entrance must also have curtains 15 cubits long. There must be three posts and three bases on that side. ");
INSERT INTO engerv_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Make a curtain 20 cubits long to cover the entrance to the courtyard. Make that curtain from fine linen and blue, purple, and red yarn. Weave designs into that curtain. There must be four posts and four bases for that curtain. ");
INSERT INTO engerv_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","All the posts around the courtyard must be joined with silver curtain rods. The hooks on the posts must be made from silver, and the bases for the posts must be bronze. ");
INSERT INTO engerv_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","The courtyard should be 100 cubits long and 50 cubits wide. The wall of curtains around the courtyard should be 5 cubits high. The curtains must be made from fine linen. The bases under the posts must be bronze. ");
INSERT INTO engerv_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","All the tools, tent pegs, and other things used in the Holy Tent must be made from bronze. And all the pegs for the curtains around the courtyard must be made from bronze. ");
INSERT INTO engerv_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Command the Israelites to bring their best olive oil for the lamp that must be lit each evening. ");
INSERT INTO engerv_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","This lamp is in the first room of the Meeting Tent, outside the curtain for the room where the Agreement is. Aaron and his sons will make sure this lamp is burning before the LORD every day from evening until morning. The Israelites and their descendants must obey this law forever. ");
INSERT INTO engerv_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Tell your brother Aaron and his sons, Nadab, Abihu, Eleazar, and Ithamar, to come to you from the Israelites. These men will serve me as priests. ");
INSERT INTO engerv_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“Make special clothes for your brother Aaron. These clothes will give him honor and respect. ");
INSERT INTO engerv_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","I have given special wisdom to some of the skilled men. Tell them to make the clothes for Aaron. These clothes will show that he serves me in a special way. Then he can serve me as a priest. ");
INSERT INTO engerv_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","These are the clothes the men should make: the judgment pouch, the ephod, a blue robe, a white woven robe, a turban, and a cloth belt. They must make these special clothes for your brother Aaron and his sons. Then Aaron and his sons can serve me as priests. ");
INSERT INTO engerv_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Tell the men to use gold thread, fine linen, and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Use gold thread, fine linen, and blue, purple, and red yarn to make the ephod. This must be the work of a very skilled person. ");
INSERT INTO engerv_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","At each shoulder of the ephod, there should be a shoulder piece. These shoulder pieces should be tied to the two corners of the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“The men will very carefully weave a cloth belt for the ephod. This belt must be made the same way as the ephod—use gold threads, fine linen, and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Take two onyx stones. Write the names of the twelve sons of Israel on these jewels. ");
INSERT INTO engerv_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Write six names on one jewel and six names on the other jewel. Write the names in order, from the oldest son to the youngest. ");
INSERT INTO engerv_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Cut the names of the sons of Israel into these stones. Do this the way a worker makes a seal. Put the jewels in gold settings. ");
INSERT INTO engerv_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Then put these two jewels on the shoulder pieces of the ephod. Aaron will wear this special coat when he stands before the LORD. And the two stones with the names of the sons of Israel will be on the ephod. These jewels will cause the Lord to remember the Israelites. ");
INSERT INTO engerv_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Use fine gold to hold the stones on the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Twist chains of pure gold together like a rope. Make two of these gold chains and fasten them to the gold settings. ");
INSERT INTO engerv_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Make the judgment pouch for the high priest. Skilled workers should make this pouch just as they made the ephod. They must use gold threads, fine linen, and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","The judgment pouch should be folded double to make a square pocket. It should be 1 span long and 1 span wide. ");
INSERT INTO engerv_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Put four rows of beautiful jewels on the judgment pouch. The first row of jewels should have a ruby, a topaz, and a beryl. ");
INSERT INTO engerv_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","The second row should have a turquoise, a sapphire, and an emerald. ");
INSERT INTO engerv_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","The third row should have a jacinth, an agate, and an amethyst. ");
INSERT INTO engerv_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","The fourth row should have a chrysolite, an onyx, and a jasper. Set all these jewels in gold. ");
INSERT INTO engerv_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","There will be twelve jewels on the judgment pouch—one stone for each of the sons of Israel. Each stone will be like a seal with the name of one of the twelve tribes cut into it. ");
INSERT INTO engerv_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Make chains of pure gold for the judgment pouch. These chains must be braided like a rope. ");
INSERT INTO engerv_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Make two gold rings and put them on two corners of the judgment pouch. ");
INSERT INTO engerv_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Put the two golden chains through the two rings at the corners of the judgment pouch. ");
INSERT INTO engerv_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Fasten the other ends of the gold chains to the two settings. This will fasten them to the two shoulder pieces of the ephod on the front. ");
INSERT INTO engerv_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Make two more gold rings and put them on the other two corners of the judgment pouch. This will be on the inside edge of the judgment pouch next to the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Make two more gold rings and put them on the bottom of the shoulder pieces on the front of the ephod. Put the gold rings above the cloth belt of the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Use blue ribbon to tie the rings of the judgment pouch to the rings of the ephod. In this way the judgment pouch will rest close to the cloth belt and will be held against the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“When Aaron enters the Holy Place, he must wear the judgment pouch. In this way he will wear the names of the twelve sons of Israel over his heart. And the LORD will always be reminded of them. ");
INSERT INTO engerv_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Put the Urim and Thummim inside the judgment pouch. They will be over Aaron’s heart when he goes before the LORD. So Aaron will always carry with him a way of judging for the Israelites when he is before the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Make a blue robe for the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Make a hole in the center for the head. And sew a piece of cloth around the edge of this hole. This cloth will be like a collar that keeps the hole from tearing. ");
INSERT INTO engerv_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Use blue, purple, and red yarn to make cloth pomegranates. Hang these pomegranates around the bottom edge of the robe, and hang gold bells between the pomegranates. ");
INSERT INTO engerv_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","So around the bottom edge of the robe there should be bells and pomegranates. There should be a bell following each pomegranate. ");
INSERT INTO engerv_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron will wear this robe when he serves as a priest. The bells will ring as Aaron goes into the Holy Place to stand before the LORD, and the bells will ring as he leaves the Holy Place. This way Aaron will not die. ");
INSERT INTO engerv_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Make a strip of pure gold and carve these words into the gold like the writing on a seal: holy to the lord. ");
INSERT INTO engerv_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Fasten the gold strip to a blue ribbon. Tie the blue ribbon around the turban. The gold strip should be on the front of the turban. ");
INSERT INTO engerv_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron will wear this on his head. In this way he will remove the guilt if anything is wrong with the gifts that the Israelites give to God. Aaron will always wear this on his head so that the LORD will accept the gifts of the people. ");
INSERT INTO engerv_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Use fine linen to make the white woven robe and the turban. The cloth belt should have designs sewn into it. ");
INSERT INTO engerv_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Also make coats, belts, and cloth caps for Aaron’s sons. This will give them honor and respect. ");
INSERT INTO engerv_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Put the clothes on your brother Aaron and his sons. Then pour the special oil on them to make them priests. This will make them holy, and they will serve me as priests. ");
INSERT INTO engerv_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Use linen to make underclothes for the priests. These underclothes will cover them from the waist to the thighs. ");
INSERT INTO engerv_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron and his sons must wear these clothes whenever they enter the Meeting Tent. They must wear these clothes when they come near to the altar to serve as priests in the Holy Place. If they don’t wear these clothes, they will be guilty of wrong and will have to die. All this should be a law that continues forever for Aaron and all his family after him. ");
INSERT INTO engerv_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Now I will tell you what you must do to show that Aaron and his sons serve me in a special way as priests. Find one young bull and two rams that have nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Then use fine wheat flour without yeast to make bread. And use the same things to make cakes mixed with olive oil. Make small thin cakes spread with oil. ");
INSERT INTO engerv_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Put this bread and the cakes in a basket. Then give the basket to Aaron and his sons. At the same time, give them the bull and the two rams. ");
INSERT INTO engerv_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Then bring Aaron and his sons to the entrance of the Meeting Tent. Wash them with water. ");
INSERT INTO engerv_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Put the special clothes on Aaron. Put on him the white woven robe and the blue robe that is worn with the ephod. Put the ephod and the judgment pouch on him. Then tie the beautiful cloth belt on him. ");
INSERT INTO engerv_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Put the turban on his head and the special crown around the turban. ");
INSERT INTO engerv_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Take the anointing oil and pour it on Aaron’s head. This will show that he is chosen for this work. ");
INSERT INTO engerv_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Then bring Aaron’s sons to that place. Put the white woven robes on them. ");
INSERT INTO engerv_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Then tie cloth belts around their waists, and give them cloth caps to wear. At that time they will begin to be priests. They will be priests because of the special law that will continue forever. This is the way you will make Aaron and his sons priests. ");
INSERT INTO engerv_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Then bring the bull to that place at the front of the Meeting Tent. Aaron and his sons must put their hands on the bull’s head. ");
INSERT INTO engerv_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Then kill the bull there in the LORD’S presence at the entrance to the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Then take some of the bull’s blood and go to the altar. Use your finger to put some blood on the horns of the altar. Pour out all the blood that is left at the bottom of the altar. ");
INSERT INTO engerv_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Then take all the fat from inside the bull, the fatty part of the liver, both kidneys, and the fat around them. Burn this fat on the altar. ");
INSERT INTO engerv_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Then take the bull’s meat, his skin, and his other parts and go outside your camp and burn them. This bull is an offering to take away the sins of the priests. ");
INSERT INTO engerv_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Then tell Aaron and his sons to put their hands on the head of one of the rams. ");
INSERT INTO engerv_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kill that ram and save the blood. Throw the blood against the altar on all four sides. ");
INSERT INTO engerv_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Then cut the ram into several pieces. Wash all the parts from inside the ram and the legs. Put these things with the head and the other pieces of the ram. ");
INSERT INTO engerv_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Then burn everything on the altar. It is a burnt offering to the LORD. It is a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Tell Aaron and his sons to put their hands on the other ram. ");
INSERT INTO engerv_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kill that ram and save some of its blood. Put that blood on the right ear lobes of Aaron and his sons. Also put some of the blood on the thumbs of their right hands and on the big toes of their right feet. Then throw blood against all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Then take some of the blood from the altar. Mix it with the special oil and sprinkle it on Aaron and his clothes. And sprinkle it on his sons and their clothes. This will show that Aaron and his sons serve me in a special way. And it will show that their clothes are used only at special times. ");
INSERT INTO engerv_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Then take the fat from the ram. (This is the ram that will be used in the ceremony to make Aaron the high priest.) Take the fat from around the tail and the fat that covers the organs inside the body. Then take the fat that covers the liver, both kidneys and the fat on them, and the right leg. ");
INSERT INTO engerv_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Then take the basket of bread that you made without yeast. This is the basket you put before the LORD. Take these things out of the basket: one loaf of bread, one cake made with oil, and one small thin cake. ");
INSERT INTO engerv_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Give them to Aaron and his sons. Tell them to hold these things in their hands before the Lord. This will be a special offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Then take them from Aaron and his sons and put them on the altar with the ram. Then burn everything on the altar. It is a burnt offering to the LORD. It is a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Then take the breast from the ram. (This is the ram that will be used in the ceremony to make Aaron the high priest.) Hold the breast of the ram before the LORD as a special offering. Then take it back and keep it. This part of the animal will be for you. ");
INSERT INTO engerv_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Take the breast and the leg of the ram that was used to make Aaron the high priest and make these parts holy. Then give these special parts to Aaron and his sons. ");
INSERT INTO engerv_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","The Israelites will always give Aaron and his sons these parts. These parts will always belong to the priests when the Israelites make an offering to the LORD. When they give these parts to the priest, it will be the same as giving them to the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Save these special clothes that were made for Aaron and his descendants. They will wear these clothes when they are chosen to be priests. ");
INSERT INTO engerv_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aaron’s son will become the next high priest after him. That son will wear these clothes seven days when he comes to the Meeting Tent to serve in the Holy Place. ");
INSERT INTO engerv_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Cook the meat from the ram that was used to make Aaron the high priest. Cook that meat in a holy place. ");
INSERT INTO engerv_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Then Aaron and his sons must eat the meat at the front door of the Meeting Tent. And they must also eat the bread that is in the basket. ");
INSERT INTO engerv_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","These offerings were used to take away their sins when they were made priests. Now they should eat these offerings. ");
INSERT INTO engerv_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","If any of the meat from that ram or any of the bread is left the next morning, then it must be burned. You must not eat that bread or the meat because it should be eaten only in a special way at a special time. ");
INSERT INTO engerv_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“You must do all these things for Aaron and his sons. You must do them exactly as I told you. The ceremony for appointing them to be priests must continue for seven days. ");
INSERT INTO engerv_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","You must kill one bull every day for seven days. This will be an offering for the sins of Aaron and his sons. You will use these sacrifices to make the altar pure, and pour olive oil on the altar to make it holy. ");
INSERT INTO engerv_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","You will make the altar pure and holy for seven days. At that time the altar will be most holy. Anything that touches the altar will also be holy. ");
INSERT INTO engerv_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Every day you must make an offering on the altar. You must kill two lambs that are one year old. ");
INSERT INTO engerv_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Offer one lamb in the morning and the other in the evening. ");
INSERT INTO engerv_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","When you kill the first lamb, also offer 8 cups of fine wheat flour. Mix that flour with 1 quart of the best oil. Also offer 1 quart of wine as an offering. When you kill the second lamb in the evening, also offer the 8 cups of fine flour mixed with 1 quart of the best oil and offer 1 quart of wine. This is the same as you did in the morning. This will be a sweet-smelling gift to the LORD. When you burn this offering, he will smell it, and it will please him. ");
INSERT INTO engerv_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“You must burn these things as an offering to the Lord every day. Do this at the entrance of the Meeting Tent before the LORD. Continue to do this for all time. When you make the offering, I will meet you there and speak to you. ");
INSERT INTO engerv_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","I will meet with the Israelites at that place, and my Glory will make that place holy. ");
INSERT INTO engerv_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“So I will make the Meeting Tent and the altar holy. I will also make Aaron and his sons holy so that they can serve me as priests. ");
INSERT INTO engerv_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","I will live with the Israelites. I will be their God. ");
INSERT INTO engerv_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","The people will know that I am the LORD their God. They will know that I am the one who led them out of Egypt so that I could live with them. I am the LORD their God. ");
INSERT INTO engerv_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Make an altar from acacia wood. You will use this altar for burning incense. ");
INSERT INTO engerv_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","You must make the altar square—1 cubit long and 1 cubit wide. It must be 2 cubits high. There will be horns at the four corners. These horns must be made as one piece with the altar. ");
INSERT INTO engerv_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Cover the top, the horns, and all four sides of the altar with pure gold. Then put gold trim all around the altar. ");
INSERT INTO engerv_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Below this trim there should be two gold rings. There should be two gold rings on opposite sides of the altar. These gold rings will be used with poles to carry the altar. ");
INSERT INTO engerv_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Make the poles from acacia wood and cover them with gold. ");
INSERT INTO engerv_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Put the altar just outside the special curtain that hangs in front of the Box of the Agreement. So the altar will be in front of the mercy-cover that is above the Agreement. This is the place where I will meet with you. ");
INSERT INTO engerv_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aaron must burn sweet-smelling incense on the altar every morning. He will do this when he comes to care for the lamps. ");
INSERT INTO engerv_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","He must burn incense again when he checks the lamps in the evening so that incense will be burned before the LORD every day forever. ");
INSERT INTO engerv_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Don’t use this altar for offering any other kind of incense or burnt offering or for any kind of grain offering or drink offering. ");
INSERT INTO engerv_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“Once a year Aaron must make a special sacrifice. He will use the blood of the sin offering to erase the sins of the people. He will do this at the horns of this altar. This day will be called the Day of Atonement, and it will be a very special day for the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Count the Israelites so that you will know how many people there are. Every time this is done, each man must make a payment for himself to the LORD so that nothing terrible will happen to the people. ");
INSERT INTO engerv_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Each man who is counted must pay 1/2 shekel of silver. (That is 1/2 shekel by the official measure. This shekel weighs 20 gerahs.) This half shekel is an offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Every man who is at least 20 years old must be counted. And every man who is counted must give the LORD this offering. ");
INSERT INTO engerv_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","The rich must not give more than 1/2 shekel, and the poor must not give less than 1/2 shekel. All people will make the same offering to the LORD. This will be a payment for your life. ");
INSERT INTO engerv_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gather this money from the Israelites. Use the money for the service in the Meeting Tent. This payment will be a way for the LORD to remember his people. They will be paying for their own lives.” ");
INSERT INTO engerv_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Make a bronze bowl and put it on a bronze base. You will use this for washing. Put the bowl between the Meeting Tent and the altar. Fill the bowl with water. ");
INSERT INTO engerv_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron and his sons must wash their hands and feet with the water from this bowl. ");
INSERT INTO engerv_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Every time they enter the Meeting Tent, they must wash with that water so that they will not die. They must also wash every time they come near the altar to burn incense or to offer gifts to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","They must wash their hands and their feet so that they will not die. This will be a law that continues forever for Aaron and his people who will live in the future.” ");
INSERT INTO engerv_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Find the finest spices. Get 12 pounds of liquid myrrh, half that amount (that is, 6 pounds) of sweet-smelling cinnamon, and 12 pounds of sweet-smelling cane, ");
INSERT INTO engerv_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","and 12 pounds of cassia. Use the official measure to measure all these things. Also get 1 gallon of olive oil. ");
INSERT INTO engerv_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“Mix all these things to make a special sweet-smelling anointing oil. ");
INSERT INTO engerv_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Pour this oil on the Meeting Tent and on the Box of the Agreement. This will show that these things have a special purpose. ");
INSERT INTO engerv_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Pour the oil on the table and on all the dishes on the table. And pour this oil on the lamp and on all its tools. Pour the oil on the incense altar. ");
INSERT INTO engerv_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Also, pour the oil on the altar for burning offerings to God. Pour this oil on everything on that altar. Pour this oil on the bowl and on the base under the bowl. ");
INSERT INTO engerv_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","You will make all these things holy. They will be very special to the Lord. Anything that touches these things will also become holy. ");
INSERT INTO engerv_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Pour the oil on Aaron and his sons to show that they are separated from the rest of the people to serve as priests. ");
INSERT INTO engerv_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tell the Israelites that the anointing oil is holy—it must always be used only for me. ");
INSERT INTO engerv_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","This oil is holy and you must treat it as something special. Don’t use the same formula for making perfume and don’t let people use this oil like an ordinary perfume. ");
INSERT INTO engerv_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Whoever makes a perfume like that and puts it on anyone except a priest must be separated from the people.” ");
INSERT INTO engerv_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Then the LORD said to Moses, “Get these sweet-smelling spices: resin, onycha, galbanum, and pure frankincense. Be sure that you have equal amounts of these spices. ");
INSERT INTO engerv_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mix the spices together to make a sweet-smelling incense. Do this the same as a perfume maker would do it. Also mix salt with this incense. This will make it pure and special. ");
INSERT INTO engerv_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Grind some of the incense until it becomes a fine powder. Put the powder in front of the Holy Box that holds the Agreement in the Meeting Tent. This is the place where I meet with you. You must use this incense powder only for its very special purpose. ");
INSERT INTO engerv_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","You must use it only in this special way for the LORD. You must also make it in a special way. Don’t make any other incense in this way. ");
INSERT INTO engerv_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","There may be people who will want to make some of this incense for themselves so that they can enjoy the smell. But whoever does this must be separated from their people.” ");
INSERT INTO engerv_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“I have chosen a man from the tribe of Judah to do some special work for me. His name is Bezalel son of Uri son of Hur. ");
INSERT INTO engerv_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","I have filled Bezalel with the Spirit of God—I have given him the skill and knowledge to do all kinds of things. ");
INSERT INTO engerv_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","He is a very good designer. And he can make things from gold, silver, and bronze. ");
INSERT INTO engerv_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","He can cut and set beautiful jewels. And he can work with wood. He can do all kinds of work. ");
INSERT INTO engerv_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","I have also chosen Oholiab to work with him. Oholiab is the son of Ahisamach from the tribe of Dan. And I have given skills to all the other workers so that they can make everything that I have commanded you: ");
INSERT INTO engerv_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","the Meeting Tent; the Box of the Agreement; the mercy-cover that is on it; ");
INSERT INTO engerv_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","the table and everything on it; the pure gold lampstand and everything used with it; the altar for burning incense; ");
INSERT INTO engerv_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","the altar for burning offerings and the things used at the altar; the bowl and the base under it; ");
INSERT INTO engerv_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","the special clothes for Aaron the priest; the special clothes for Aaron’s sons when they serve as priests; ");
INSERT INTO engerv_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","the sweet-smelling anointing oil; the sweet-smelling incense for the Holy Place. These workers must make everything the way that I have commanded you.” ");
INSERT INTO engerv_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Tell the Israelites this: ‘You must follow the rules about my special days of rest. You must do this because they will be a sign between you and me for all generations. This will show you that I, the LORD, have made you my special people. ");
INSERT INTO engerv_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘Make the Sabbath a special day. If someone treats the Sabbath like any other day, that person must be killed. Whoever works on the Sabbath day must be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","There are six other days in the week for working. But the seventh day is a very special day of rest. That is the special day to honor the LORD. Anyone who works during the Sabbath must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","The Israelites must remember the Sabbath and make it a special day. They must continue to do this forever. It is an agreement between them and me that will continue forever. ");
INSERT INTO engerv_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","The Sabbath will be a sign between me and the Israelites forever.’” (The LORD worked six days and made the sky and the earth, and on the seventh day he rested and relaxed.) ");
INSERT INTO engerv_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","When God finished speaking to Moses on Mount Sinai, he gave him the two stone tablets of the Agreement. God had written on the stones with his finger. ");
INSERT INTO engerv_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","The people saw that a long time had passed and Moses had not come down from the mountain. So they gathered around Aaron. They said to him, “Look, Moses led us out of the land of Egypt, but we don’t know what has happened to him. So make us some gods to go before us and lead us.” ");
INSERT INTO engerv_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron said to the people, “Bring me the gold earrings that belong to your wives, sons, and daughters.” ");
INSERT INTO engerv_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","So the people collected all their gold earrings and brought them to Aaron. ");
INSERT INTO engerv_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","He took the gold from the people and used it to make an idol. Using a special tool, he shaped the gold into a statue of a calf. Then the people said, “Israel, here are your gods! These are the gods that brought you out of the land of Egypt!” ");
INSERT INTO engerv_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron saw all these things, so he built an altar in front of the calf. Then Aaron made an announcement. He said, “Tomorrow will be a special festival to honor the LORD.” ");
INSERT INTO engerv_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","The people woke up very early the next morning. They killed animals and offered them as burnt offerings and fellowship offerings. They sat down to eat and drink. Then they got up and had a wild party. ");
INSERT INTO engerv_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","At the same time, the LORD said to Moses, “Go down from this mountain. Your people, the people you brought out of the land of Egypt, have committed a terrible sin. ");
INSERT INTO engerv_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","They have very quickly turned away from what I commanded them to do. They made a calf from melted gold for themselves. They are worshiping that calf and making sacrifices to it. The people have said, ‘Israel, these are the gods that led you out of Egypt.’” ");
INSERT INTO engerv_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","The LORD said to Moses, “I have seen these people, and I know that they are very stubborn. They will always turn against me. ");
INSERT INTO engerv_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","So now let me destroy them in anger. Then I will make a great nation from you.” ");
INSERT INTO engerv_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","But Moses begged the LORD his God, “LORD, don’t let your anger destroy your people. You brought them out of Egypt with your great power and strength. ");
INSERT INTO engerv_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","But if you destroy your people, the Egyptians will say, ‘God planned to do bad things to his people. That is why he led them out of Egypt. He wanted to kill them in the mountains. He wanted to wipe them off the earth.’ So don’t be angry with your people. Please change your mind! Don’t destroy them. ");
INSERT INTO engerv_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Remember Abraham, Isaac, and Israel. These men served you, and you used your name to make a promise to them. You said, ‘I will make your people as many as the stars in the sky. I will give your people all this land as I promised. This land will be theirs forever.’” ");
INSERT INTO engerv_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","So the LORD felt sorry for the people. He did not do what he said he might do—he did not destroy them. ");
INSERT INTO engerv_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Then Moses went down the mountain. He had the two stone tablets with the agreement on them. The commandments were written on both sides of the stone, front and back. ");
INSERT INTO engerv_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God himself made the stones, and God himself wrote the commandments on them. ");
INSERT INTO engerv_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Joshua heard the noise from the party in camp. He said to Moses, “It sounds like war down in the camp!” ");
INSERT INTO engerv_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses answered, “It is not the noise of an army shouting for victory. And it is not the noise of an army crying from defeat. The noise I hear is the sound of music.” ");
INSERT INTO engerv_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","When Moses came near the camp, he saw the golden calf and the people dancing. He became very angry, and he threw the stone tablets on the ground. The stones broke into several pieces at the bottom of the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Then Moses destroyed the calf that the people had made. He melted it in the fire. Then he ground the gold until it became dust and threw it into the water. Then he forced the Israelites to drink that water. ");
INSERT INTO engerv_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moses said to Aaron, “What did these people do to you that would make you do this? Why did you lead them to do such a terrible sin?” ");
INSERT INTO engerv_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron answered, “Don’t be angry, sir. You know that these people are always ready to do wrong. ");
INSERT INTO engerv_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","The people said to me, ‘Moses led us out of Egypt, but we don’t know what has happened to him. So make us some gods to lead us.’ ");
INSERT INTO engerv_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","So I told the people, ‘If you have any gold rings, then give them to me.’ The people gave me their gold. I threw the gold into the fire, and out of the fire came this calf!” ");
INSERT INTO engerv_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses saw that Aaron had let the people get out of control. They were being wild, and all their enemies could see them acting like fools. ");
INSERT INTO engerv_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","So Moses stood at the entrance to the camp and said, “Anyone who wants to follow the LORD should come to me.” Everyone from the tribe of Levi ran to Moses. ");
INSERT INTO engerv_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Then Moses said to them, “I will tell you what the LORD, the God of Israel, says: ‘Every man must get his sword and go from one end of the camp to the other. You men must kill those who are against the Lord, even if they are your brothers, friends, or neighbors.’” ");
INSERT INTO engerv_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","The people from the tribe of Levi obeyed Moses. That day about 3000 of the people died. ");
INSERT INTO engerv_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Then Moses said, “Take your role today as special servants of the LORD because you were willing to fight against even your own sons and brothers. You will receive a blessing for this.” ");
INSERT INTO engerv_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","The next morning Moses told the people, “You have committed a terrible sin! But now I will go up to the LORD, and maybe I can do something so that he will forgive you for your sin.” ");
INSERT INTO engerv_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","So Moses went back to the LORD and said, “Please listen! These people committed a terrible sin and made a god from gold. ");
INSERT INTO engerv_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Now, forgive them of this sin. If you will not forgive them, then erase my name from your book.” ");
INSERT INTO engerv_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","But the LORD said to Moses, “The only people I erase from my book are those who sin against me. ");
INSERT INTO engerv_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","So now, go down and lead the people where I tell you to go. My angel will go before you and lead you. When the time comes to punish those who sinned, they will be punished.” ");
INSERT INTO engerv_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","So the LORD caused a terrible sickness to come to the people. He did this because they told Aaron to make the golden calf. ");
INSERT INTO engerv_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Then the LORD said to Moses, “You and the people you brought out of Egypt must leave this place. Go to the land that I promised to give to Abraham, Isaac, and Jacob. I promised them that I would give that land to their descendants. ");
INSERT INTO engerv_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","So I will send an angel to go before you, and I will defeat the Canaanites, Amorites, Hittites, Perizzites, Hivites, and Jebusites. I will force them to leave your land. ");
INSERT INTO engerv_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","So go to the land filled with many good things, but I will not go with you. You people are very stubborn. If I go with you, I might destroy you along the way.” ");
INSERT INTO engerv_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","The people heard this bad news and became very sad, so they stopped wearing jewelry. ");
INSERT INTO engerv_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","This was because the LORD said to Moses, “Tell the Israelites, ‘You are a stubborn people. I might destroy you even if I travel with you only a short time. So take off all your jewelry while I decide what to do with you.’” ");
INSERT INTO engerv_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","So the Israelites stopped wearing their jewelry at Mount Horeb. ");
INSERT INTO engerv_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses used to take a tent a short way outside the camp. He called it “the meeting tent.” Anyone who wanted to ask something from the LORD would go to the meeting tent outside the camp. ");
INSERT INTO engerv_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Any time Moses went out to the tent, all the people watched him. They stood at the entrance of their tents and watched Moses until he entered the meeting tent. ");
INSERT INTO engerv_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Whenever Moses went into the tent, the tall cloud would come down and stay at the entrance to the tent. And the Lord would speak with Moses. ");
INSERT INTO engerv_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","So when the people saw the cloud at the entrance of the tent, they would go to the entrance of their own tents and bow down to worship God. ");
INSERT INTO engerv_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","In this way the LORD spoke to Moses face to face like a man speaks with his friend. Then Moses would go back to the camp, but his helper, Joshua son of Nun, always stayed in the tent. ");
INSERT INTO engerv_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses said to the LORD, “You told me to lead these people, but you did not say who you would send with me. You said to me, ‘I know you very well, and I am pleased with you.’ ");
INSERT INTO engerv_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","If I have really pleased you, then teach me your ways. I want to know you. Then I can continue to please you. Remember that these people are your nation.” ");
INSERT INTO engerv_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","The Lord answered, “I myself will go with you. I will lead you.” ");
INSERT INTO engerv_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Then Moses said to him, “If you don’t go with us, then don’t make us leave this place. ");
INSERT INTO engerv_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Also, how will we know if you are pleased with me and these people? If you go with us, we will know for sure. If you don’t go with us, these people and I will be no different from any other people on the earth.” ");
INSERT INTO engerv_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Then the LORD said to Moses, “I will do what you ask. I will do this because I am pleased with you and because I know you very well.” ");
INSERT INTO engerv_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Then Moses said, “Now, please show me your Glory.” ");
INSERT INTO engerv_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Then the Lord answered, “I will show my love and mercy to anyone I want to. So I will cause my perfect goodness to pass by in front of you, and I will speak my name, YAHWEH, so that you can hear it. ");
INSERT INTO engerv_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","But you cannot see my face. No one can see me and continue to live.” ");
INSERT INTO engerv_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Then the LORD said, “Here is a place for you to stand by me on this large rock. ");
INSERT INTO engerv_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","I will put you in a large crack in that rock. Then I will cover you with my hand, and my Glory will pass by. ");
INSERT INTO engerv_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Then I will take away my hand, and you will see my back. But you will not see my face.” ");
INSERT INTO engerv_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Then the LORD said to Moses, “Make two more stone tablets like the first two that were broken. I will write the same words on these stones that were written on the first two stones. ");
INSERT INTO engerv_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Be ready tomorrow morning and come up on Mount Sinai. Stand before me there on the top of the mountain. ");
INSERT INTO engerv_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","No one will be allowed to come with you. No one should even be seen anywhere on the mountain. Even your herds of animals or flocks of sheep will not be allowed to eat grass at the bottom of the mountain.” ");
INSERT INTO engerv_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","So Moses made two more stone tablets like the first ones. Early the next morning Moses went up Mount Sinai, just as the LORD had commanded. Moses carried the two stone tablets with him. ");
INSERT INTO engerv_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Then the LORD came down to him in a cloud, stood there with Moses, and spoke his own name. ");
INSERT INTO engerv_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","That is, the LORD passed in front of Moses and said, “YAHWEH, the LORD, is a kind and merciful God. He is slow to become angry. He is full of great love. He can be trusted. ");
INSERT INTO engerv_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","He shows his faithful love to thousands of people. He forgives people for the wrong things they do, but he does not forget to punish guilty people. Not only will he punish the guilty people, but their children, their grandchildren, and their great-grandchildren will also suffer for the bad things these people do.” ");
INSERT INTO engerv_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Then Moses quickly bowed to the ground and worshiped the Lord. Moses said, ");
INSERT INTO engerv_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Lord, if you are pleased with me, please go with us. I know that these are stubborn people, but forgive us for the bad things we did. Accept us as your people.” ");
INSERT INTO engerv_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Then the Lord said, “I am making this agreement with all of your people. I will do amazing things that have never before been done for any other nation on earth. The people with you will see that I, the LORD, am very great. They will see the wonderful things that I will do for you. ");
INSERT INTO engerv_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Obey what I command you today, and I will force your enemies to leave your land. I will force out the Amorites, Canaanites, Hittites, Perizzites, Hivites, and Jebusites. ");
INSERT INTO engerv_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be careful! Don’t make any agreement with the people who live in the land where you are going. If you make an agreement with them, it will bring you trouble. ");
INSERT INTO engerv_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","So destroy their altars, break the stones they worship, and cut down their idols. ");
INSERT INTO engerv_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Don’t worship any other god. I am YAHWEH KANAH—the jealous LORD. That is my name. I hate for my people to worship other gods. ");
INSERT INTO engerv_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Be careful not to make any agreements with the people who live in that land. If you do this, you might join them when they worship their gods. They will invite you to join them, and you will eat their sacrifices. ");
INSERT INTO engerv_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","You might choose some of their daughters as wives for your sons. Those daughters serve false gods. They might lead your sons to do the same thing. ");
INSERT INTO engerv_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Don’t make idols. ");
INSERT INTO engerv_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Celebrate the Festival of Unleavened Bread. For seven days, eat the bread made without yeast as I commanded you before. Do this during the month I have chosen, the month of Abib, because that is the month you came out of Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“A woman’s first baby always belongs to me. Even the first animals that are born from your cattle or sheep belong to me. ");
INSERT INTO engerv_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","If you want to keep a donkey that is the first born, then you can buy it with a lamb. But if you don’t buy that donkey with a lamb, you must break the donkey’s neck. You must buy back all of your firstborn sons from me. No one should come before me without a gift. ");
INSERT INTO engerv_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“You will work for six days, but on the seventh day you must rest. You must rest even during the times of planting and harvesting. ");
INSERT INTO engerv_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Celebrate the Festival of Harvest. Use the first grain from the wheat harvest for this festival. And in the fall celebrate the Festival of Shelters. ");
INSERT INTO engerv_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Three times each year all your men must go to be with the Lord GOD, the God of Israel. ");
INSERT INTO engerv_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“When you go into your land, I will force your enemies out of that land. I will expand your borders—you will get more and more land. You will go before the LORD your God three times each year. At that time no one will try to take your land from you. ");
INSERT INTO engerv_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“When you kill an animal and offer its blood as a sacrifice, you must not include anything that has yeast in it. “Don’t let any of the meat from the Passover meal remain until morning. ");
INSERT INTO engerv_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Give the Lord the very first crops that you harvest. Bring them to the house of the LORD your God. “Never cook a young goat in its mother’s milk.” ");
INSERT INTO engerv_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Then the LORD said to Moses, “Write everything that I have told you. This is the agreement that I made with you and the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moses stayed there with the LORD for 40 days and 40 nights. Moses did not eat any food or drink any water. And he wrote the words of the agreement (the Ten Commandments) on the two stone tablets. ");
INSERT INTO engerv_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","When Moses came down from Mount Sinai, he carried the two stone tablets of the Agreement. Because he had talked with the Lord, his face was shining, but he did not know it. ");
INSERT INTO engerv_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron and all the people of Israel saw that Moses’ face was shining bright. So they were afraid to go near him. ");
INSERT INTO engerv_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","But Moses called to them. So Aaron and all the leaders of the people went to him. Moses talked with them. ");
INSERT INTO engerv_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","After that all the Israelites came near Moses, and he gave them the commands that the LORD had given him on Mount Sinai. ");
INSERT INTO engerv_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","When Moses finished speaking to the people, he put a covering over his face. ");
INSERT INTO engerv_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Any time Moses went before the LORD to speak with him, Moses took off the covering. Then Moses would come out and tell the Israelites what the Lord commanded. ");
INSERT INTO engerv_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","The people would see that Moses’ face was shining bright, so he would cover his face again. He kept his face covered until the next time he went in to speak with the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moses gathered all the Israelites together and said to them, “I will tell you what the LORD has commanded you to do: ");
INSERT INTO engerv_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“There are six days for working, but the seventh day will be a very special day of rest for you. You will honor the LORD by resting on that special day. Anyone who works on the seventh day must be killed. ");
INSERT INTO engerv_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","On the Sabbath you should not even light a fire in any of the places where you live.” ");
INSERT INTO engerv_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moses said to all the Israelites, “This is what the LORD commanded: ");
INSERT INTO engerv_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Gather special gifts for the LORD. Each of you should decide in your heart what you will give. And then you should bring that gift to the LORD. Bring gold, silver, and bronze; ");
INSERT INTO engerv_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","blue, purple, and red yarn and fine linen; goat hair; ");
INSERT INTO engerv_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ram skins dyed red and fine leather; acacia wood; ");
INSERT INTO engerv_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oil for the lamps; spices for the anointing oil and spices for the sweet-smelling incense. ");
INSERT INTO engerv_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Also, bring onyx stones and other jewels to be put on the ephod and the judgment pouch. ");
INSERT INTO engerv_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“All of you who are skilled workers should make all the things the LORD commanded: ");
INSERT INTO engerv_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","the Holy Tent, its outer tent, and its covering; the hooks, boards, braces, posts, and bases; ");
INSERT INTO engerv_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","the Holy Box, its poles, the mercy-cover, and the curtain that covers the area where the Box stays; ");
INSERT INTO engerv_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","the table and its poles, all the things on the table, and the special bread on the table; ");
INSERT INTO engerv_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","the lampstand that is used for light and the things used with the lampstand, the lamps, and oil for the light; ");
INSERT INTO engerv_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","the altar for burning incense and its poles; the anointing oil and the sweet-smelling incense; the curtain that covers the door at the entrance to the Holy Tent; ");
INSERT INTO engerv_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","the altar for burning offerings and its bronze grating, the poles, and all the things used at the altar; the bronze bowl and its base; ");
INSERT INTO engerv_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","the curtains around the yard, their posts and bases, and the curtain that covers the entrance to the yard; ");
INSERT INTO engerv_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","the pegs used to support the Tent and the wall of curtains around the courtyard, and the ropes that tie to the pegs; ");
INSERT INTO engerv_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","and the special woven clothes for the priest to wear in the Holy Place. These are the special clothes for Aaron the priest and his sons to wear when they serve as priests.” ");
INSERT INTO engerv_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Then all the Israelites went away from Moses. ");
INSERT INTO engerv_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","All the people who wanted to give came and brought a gift to the LORD. These gifts were used for making the Meeting Tent, everything in the Tent, and the special clothes. ");
INSERT INTO engerv_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","All the men and women who wanted to give brought gold jewelry of all kinds. They brought pins, earrings, rings, and other jewelry. They all gave their jewelry as a special offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Everyone who had fine linen and blue, purple, and red yarn brought it to the Lord. Anyone who had goat hair or ram skins dyed red or fine leather brought it to the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Everyone who wanted to give silver or bronze brought that as a gift to the LORD. Everyone who had acacia wood came and gave it to the Lord. ");
INSERT INTO engerv_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Every skilled woman made fine linen and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","And all the women who were skilled and wanted to help made cloth from the goat hair. ");
INSERT INTO engerv_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","The leaders brought onyx stones and other jewels. These stones and jewels were put on the ephod and judgment pouch of the priest. ");
INSERT INTO engerv_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","The people also brought spices and olive oil. These things were used for the sweet-smelling incense, the anointing oil, and the oil for the lamps. ");
INSERT INTO engerv_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","All the Israelites who wanted to help brought gifts to the LORD. They gave these gifts freely, because they wanted to. These gifts were used to make everything the LORD had commanded Moses and the people to make. ");
INSERT INTO engerv_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Then Moses said to the Israelites, “Look, the LORD has chosen Bezalel son of Uri, from the tribe of Judah. (Uri was the son of Hur.) ");
INSERT INTO engerv_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","And he has filled Bezalel with the Spirit of God—he gave Bezalel special skill and knowledge to do all kinds of things. ");
INSERT INTO engerv_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","He can design and make things with gold, silver, and bronze. ");
INSERT INTO engerv_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","He can cut and set stones and jewels. He can work with wood and make all kinds of things. ");
INSERT INTO engerv_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","The Lord has given Bezalel and Oholiab special skills to teach other people. (Oholiab was the son of Ahisamach from the tribe of Dan.) ");
INSERT INTO engerv_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","He has given both of these men special skills to do all kinds of work. They are able to do the work of carpenters and metalworkers. They can weave cloth with designs in it from blue, purple, and red yarn and fine linen. And they are able to weave things with wool. ");
INSERT INTO engerv_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“So Bezalel, Oholiab, and all the other skilled men must do the work the LORD has commanded. The LORD has given these men the wisdom and understanding to do all the skilled work needed to build this holy place.” ");
INSERT INTO engerv_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Then Moses called Bezalel, Oholiab, and all the other skilled men who the LORD had given special skills to. And they came because they wanted to help with the work. ");
INSERT INTO engerv_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moses gave them everything the Israelites had brought as gifts, and they used these things to build the holy place. The people continued to bring gifts each morning. ");
INSERT INTO engerv_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Finally, all the skilled workers left the work they were doing on the holy place, and they went to speak to Moses. They said, ");
INSERT INTO engerv_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“The people have brought too much. We have more than we need to finish the work the LORD told us to do.” ");
INSERT INTO engerv_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Then Moses sent this message throughout the camp: “No man or woman should make anything else as a gift for the holy place.” So the people were forced to stop giving more. ");
INSERT INTO engerv_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","The people had brought more than enough things to finish the work of building God’s holy place. ");
INSERT INTO engerv_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Then the skilled workers began making the Holy Tent. They made the ten curtains from fine linen and blue, purple, and red yarn. And they sewed pictures of Cherub angels with wings into the curtains. ");
INSERT INTO engerv_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Each curtain was the same size—28 cubits long and 4 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","The workers joined the curtains together into two groups of curtains. They joined five curtains together to make one group and five curtains together to make the other group. ");
INSERT INTO engerv_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Then they used blue cloth to make loops along the edge of the end curtain of one group. And they did the same on the end curtain in the other group. ");
INSERT INTO engerv_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","There were 50 loops on the end curtain in one group and 50 loops on the end curtain in the other group. The loops were opposite each other. ");
INSERT INTO engerv_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Then they made 50 gold rings to join the two curtains together. So the Holy Tent was joined together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Then the workers made another tent to cover the Holy Tent. They used goat hair to make eleven curtains. ");
INSERT INTO engerv_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","All the curtains were the same size—30 cubits long and 4 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","The workers joined five curtains together into one group and six curtains together into another group. ");
INSERT INTO engerv_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","They put 50 loops along the edge of the end curtain of one group. And they did the same on the end curtain of the other group. ");
INSERT INTO engerv_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","The workers made 50 bronze rings to join the two groups of curtains together to form one tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Then they made two more coverings for the Holy Tent. One covering was made from ram skins dyed red. The other covering was made from fine leather. ");
INSERT INTO engerv_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Then the workers made frames from acacia wood to support the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Each frame was 10 cubits long and 1 1/2 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","There were two side poles joined together with cross pieces to make each frame. Every frame for the Holy Tent was made the same. ");
INSERT INTO engerv_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","They made 20 frames for the south side of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Then they made 40 silver bases for the frames. There were two bases for each frame—one base for each side pole. ");
INSERT INTO engerv_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","They also made 20 frames for the other side (the north side) of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","They made 40 silver bases for the frames—two bases for each frame. ");
INSERT INTO engerv_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","They made six more frames for the back (the west side) of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","They also made two frames for the corners at the back of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","These frames were joined together at the bottom. And at the top a ring held the corner frames together. They did the same for both corners. ");
INSERT INTO engerv_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","There were eight frames for the west side of the Holy Tent. And there were 16 silver bases—two bases for each frame. ");
INSERT INTO engerv_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Then the workers used acacia wood to make the braces for the frames—five braces for the first side of the Holy Tent, ");
INSERT INTO engerv_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","five braces for the other side, and five braces for the back of the Holy Tent (that is, the west side). ");
INSERT INTO engerv_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","They made the middle brace so that it passed through the frames from one end to the other. ");
INSERT INTO engerv_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","They covered these frames with gold. Then they used gold to make the rings to hold the braces, and they covered the braces with gold. ");
INSERT INTO engerv_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","They used fine linen and blue, purple, and red yarn to make the special curtain for the entrance to the Most Holy Place. And they sewed pictures of Cherub angels into the curtain. ");
INSERT INTO engerv_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","They made four posts using acacia wood, and they covered the posts with gold. Then they made gold hooks for the posts and four silver bases for the posts. ");
INSERT INTO engerv_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Then they made the curtain to cover the entrance to the Tent. They used blue, purple, and red yarn and fine linen to make this curtain. And they wove pictures into it. ");
INSERT INTO engerv_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Then they made the five posts and the hooks for this curtain over the entrance. They covered the tops of the posts and the curtain rods with gold. And they made the five bronze bases for the posts. ");
INSERT INTO engerv_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel made the Holy Box from acacia wood. The Box was 2 1/2 cubits long, 1 1/2 cubits wide, and 1 1/2 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","He covered the inside and outside of the Box with pure gold. Then he put gold trim around the Box. ");
INSERT INTO engerv_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","He made four rings of gold and put them on the four corners. These rings were used for carrying the Box. There were two rings on each side. ");
INSERT INTO engerv_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Then he made the poles for carrying the Box. He used acacia wood and covered the poles with pure gold. ");
INSERT INTO engerv_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","He put the poles through the rings on each side of the Box. ");
INSERT INTO engerv_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Then he made the mercy-cover from pure gold. It was 2 1/2 cubits long and 1 1/2 cubits wide. ");
INSERT INTO engerv_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Then Bezalel hammered gold to make two Cherub angels. He put the Cherub angels on each end of the mercy-cover. ");
INSERT INTO engerv_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","He put one angel on one end and the other angel on the other end. The angels were joined together with the mercy-cover to make one piece. ");
INSERT INTO engerv_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","The wings of the angels were spread up toward the sky. The angels covered the Box with their wings and faced each other, looking toward the mercy-cover. ");
INSERT INTO engerv_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Then he made the table from acacia wood. The table was 2 cubits long, 1 cubit wide, and 1 1/2 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","He covered it with pure gold and put gold trim around it. ");
INSERT INTO engerv_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Then he made a frame 1 handbreadth wide around the table. He put gold trim on the frame. ");
INSERT INTO engerv_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Then he made four gold rings and put them at the four corners of the table, where the four legs were. ");
INSERT INTO engerv_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","He put the rings close to the frame. The rings were to hold the poles used to carry the table. ");
INSERT INTO engerv_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Then he used acacia wood to make the poles for carrying the table. He covered the poles with pure gold. ");
INSERT INTO engerv_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Then he made everything that was used on the table. He made the plates, the spoons, the bowls, and the pitchers from pure gold. The bowls and pitchers are used for pouring the drink offerings. ");
INSERT INTO engerv_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Then he made the lampstand. He used pure gold and hammered it to make the base and the shaft. Then he made flowers, buds, and petals and joined everything together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","The lampstand had six branches—three branches on one side and three branches on the other side. ");
INSERT INTO engerv_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Each branch had three flowers on it. These flowers were made like almond flowers with buds and petals. ");
INSERT INTO engerv_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","The shaft of the lampstand had four more flowers. They were also made like almond flowers with buds and petals. ");
INSERT INTO engerv_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","There were six branches—three branches coming out from each side of the shaft. And there was a flower with buds and petals below each of the three places where the branches joined the shaft. ");
INSERT INTO engerv_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","The whole lampstand, with the flowers and branches, was made from pure gold. All this gold was hammered and joined together into one piece. ");
INSERT INTO engerv_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","He made seven lamps for this lampstand. Then he made lamp snuffers and trays from pure gold. ");
INSERT INTO engerv_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","He used 75 pounds of pure gold to make the lampstand and the things used with it. ");
INSERT INTO engerv_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","He made the altar for burning incense from acacia wood. The altar was square. It was 1 cubit long, 1 cubit wide, and 2 cubits high. There were four horns on the altar. There was one horn on each corner. These horns were joined together with the altar to make one piece. ");
INSERT INTO engerv_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","He covered the top, all the sides, and the horns with pure gold. Then he put gold trim around the altar. ");
INSERT INTO engerv_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","He made two gold rings for the altar. He put the gold rings below the trim on each side of the altar. These gold rings held the poles for carrying the altar. ");
INSERT INTO engerv_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","He made the poles from acacia wood and covered them with gold. ");
INSERT INTO engerv_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Then he made the holy anointing oil. He also made the pure, sweet-smelling incense. These things were made the same way that a perfume maker would make them. ");
INSERT INTO engerv_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Then Bezalel used acacia wood to build the altar. This was the altar used for burning offerings. The altar was square. It was 5 cubits long, 5 cubits wide, and 3 cubits high. ");
INSERT INTO engerv_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","He made a horn for each of the four corners of the altar. He joined each horn to its corner so that everything was one piece. He covered the altar with bronze. ");
INSERT INTO engerv_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Then he used bronze to make all the tools to be used on the altar. He made the pots, shovels, bowls, forks, and pans. ");
INSERT INTO engerv_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Then he made a bronze grating for the altar. This grating was shaped like a net. The grating was put under the ledge at the bottom of the altar. It went halfway up into the altar from below. ");
INSERT INTO engerv_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Then he made bronze rings to hold the poles for carrying the altar. He put the rings at the four corners of the grating. ");
INSERT INTO engerv_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Then he used acacia wood to make the poles and covered them with bronze. ");
INSERT INTO engerv_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","He put the poles through the rings on the sides of the altar to carry it. He used boards to make the sides of the altar. It was hollow, like an empty box. ");
INSERT INTO engerv_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","He made the bowl and its base with bronze. He used the bronze mirrors that the women gave. These were the women who served at the entrance to the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Then he made a wall of curtains around the courtyard. On the south side, he made a wall of curtains 100 cubits long. The curtains were made from fine linen. ");
INSERT INTO engerv_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","The curtains on the south side were supported by 20 posts. The posts were on 20 bronze bases. The hooks for the posts and the curtain rods were made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","The north side of the courtyard also had a wall of curtains 100 cubits long. There were 20 posts with 20 bronze bases. The hooks for the posts and the curtain rods were made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","On the west side of the courtyard the wall of curtains was 50 cubits long. There were 10 posts and 10 bases. The hooks for the posts and the curtain rods were made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","The east side of the courtyard was 50 cubits wide. The entrance to the courtyard was on this side. ");
INSERT INTO engerv_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","On one side of the entrance the wall of curtains was 15 cubits long. There were three posts and three bases on this side. ");
INSERT INTO engerv_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","The wall of curtains on the other side of the entrance was also 15 cubits long. There were three posts and three bases on that side. ");
INSERT INTO engerv_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","All the curtains around the courtyard were made from fine linen. ");
INSERT INTO engerv_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","The bases for the posts were made from bronze. The hooks and the curtain rods were made from silver. The tops of the posts were covered with silver also. All the posts in the courtyard had silver curtain rods. ");
INSERT INTO engerv_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","The curtain for the entrance of the courtyard was made from fine linen and blue, purple, and red yarn. Designs were woven into that curtain. The curtain was 20 cubits long and 5 cubits high. It was the same height as the curtains around the courtyard. ");
INSERT INTO engerv_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","The curtain was supported by four posts and four bronze bases. The hooks on the posts were made from silver. The tops on the posts were covered with silver, and the curtain rods were also made from silver. ");
INSERT INTO engerv_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","All the tent pegs for the Holy Tent and for the curtains around the courtyard were made from bronze. ");
INSERT INTO engerv_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Moses commanded the Levites to write down everything that was used to make the Holy Tent, that is, the Tent of the Agreement. Ithamar son of Aaron was in charge of keeping the list. ");
INSERT INTO engerv_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezalel son of Uri, the son of Hur, from the tribe of Judah, made everything the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Also Oholiab son of Ahisamach, from the tribe of Dan, helped him. Oholiab was a skilled worker and designer. He was skilled at weaving fine linen and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","The people gave over a ton of gold as an offering to the Lord for his holy place. (This was weighed using the official measure.) ");
INSERT INTO engerv_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","All the men 20 years old or older were counted. Each man had to pay a tax of 1 beka of silver. (Using the official measure, 1 beka is 1/2 shekel.) There were 603,550 men. So they collected about 7550 pounds of silver. ");
INSERT INTO engerv_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","They used most of the silver to make 100 bases for the Holy Tent and its curtains, 75 pounds for each base. ");
INSERT INTO engerv_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","They used the remaining 44 pounds of silver to make the hooks, the curtain rods, and the silver covers for the posts. ");
INSERT INTO engerv_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","They gave more than 2 1/2 tons of bronze. ");
INSERT INTO engerv_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","That bronze was used to make the bases at the entrance of the Meeting Tent. They also used the bronze to make the altar and the bronze grating. And the bronze was used to make all the tools and dishes for the altar. ");
INSERT INTO engerv_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","It was also used to make the bases for the curtains around the courtyard and the bases for the curtains at the entrance. And the bronze was used to make the tent pegs for the Holy Tent and for the curtains around the courtyard. ");
INSERT INTO engerv_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","The workers used the blue, purple, and red yarn to make special clothes for the priests to wear when they served in the holy place. They also made the special clothes for Aaron as the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","They made the ephod from gold thread, fine linen, and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","(They hammered the gold into thin strips and cut the gold into long threads. They wove the gold into the blue, purple, and red yarn and fine linen. This was the work of a very skilled person.) ");
INSERT INTO engerv_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","They made the shoulder pieces for the ephod. They tied these shoulder pieces to the two corners of the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","They wove the cloth belt and fastened it to the ephod. It was made the same way as the ephod—they used gold thread, fine linen, and blue, purple, and red yarn, just as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","The workers put the onyx stones for the ephod in gold settings. They wrote the names of the sons of Israel on these stones. ");
INSERT INTO engerv_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Then they put these jewels on the shoulder pieces of the ephod. These jewels were to help God to remember the Israelites. This was done as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Then they made the judgment pouch. It was the work of a skilled person, just like the ephod. It was made from gold threads, fine linen, and blue, purple, and red yarn. ");
INSERT INTO engerv_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","The judgment pouch was folded in half to make a square pocket. It was 1 span long and 1 span wide. ");
INSERT INTO engerv_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Then the workers put four rows of beautiful jewels on the judgment pouch. The first row had a ruby, a topaz, and a beryl. ");
INSERT INTO engerv_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","The second row had a turquoise, a sapphire, and an emerald. ");
INSERT INTO engerv_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","The third row had a jacinth, an agate, and an amethyst. ");
INSERT INTO engerv_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","The fourth row had a chrysolite, an onyx, and a jasper. All these jewels were set in gold. ");
INSERT INTO engerv_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","There were twelve jewels on the judgment pouch—one jewel for each of the sons of Israel. Each stone had the name of one of the sons of Israel carved onto it, like a seal. ");
INSERT INTO engerv_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","The workers made two chains from pure gold for the judgment pouch. The chains were braided like a rope. ");
INSERT INTO engerv_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","The workers made two gold rings and fastened them to two corners of the judgment pouch. Then they made two gold settings for the shoulder pieces. ");
INSERT INTO engerv_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","They fastened the gold chains to the rings at the corners of the judgment pouch. ");
INSERT INTO engerv_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","They fastened the other ends of the gold chains to the settings on the shoulder pieces. They fastened these to the front of the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Then they made two more gold rings and put them on the other two corners of the judgment pouch. This was on the inside edge of the judgment pouch next to the ephod. ");
INSERT INTO engerv_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","They also put two gold rings on the bottom of the shoulder pieces on the front of the ephod. These rings were near the fastener, just above the cloth belt. ");
INSERT INTO engerv_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Then they used a blue ribbon and tied the rings of the judgment pouch to the rings of the ephod. In this way the judgment pouch would rest close to the cloth belt and would be held tight against the ephod. They did everything just as the LORD commanded. ");
INSERT INTO engerv_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Then they made the robe for the ephod from blue cloth. It was woven by a skilled worker. ");
INSERT INTO engerv_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","They made a hole in the center of the robe and sewed a piece of cloth around the edge of this hole. This cloth kept the hole from tearing. ");
INSERT INTO engerv_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Then they used fine linen and blue, purple, and red yarn to make the cloth pomegranates. They hung these pomegranates around the bottom edge of the robe. ");
INSERT INTO engerv_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Then they made bells from pure gold. They hung these bells around the bottom edge of the robe between the pomegranates. ");
INSERT INTO engerv_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Around the bottom edge of the robe there were bells and pomegranates. There was a bell following each pomegranate. This robe was for the priest to wear when he served the Lord. It was made just as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Skilled workers wove shirts for Aaron and his sons. These shirts were made from fine linen. ");
INSERT INTO engerv_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","And the workers made a turban from fine linen. They also used fine linen to make cloth caps and underclothes. ");
INSERT INTO engerv_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Then they made the cloth belt from fine linen and blue, purple, and red yarn. Designs were sewn into the cloth. These things were made as the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Then they made a strip of pure gold for the holy crown. They carved these words into the gold like the writing on a seal: holy to the lord. ");
INSERT INTO engerv_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","They fastened the gold strip to a blue ribbon. Then they tied the blue ribbon around the turban like the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","So all the work on the Holy Tent, that is, the Meeting Tent, was finished. The Israelites did everything just as the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Then they showed the Holy Tent and everything in it to Moses. They showed him the rings, the frames, the braces, the posts, and the bases. ");
INSERT INTO engerv_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","They showed him the covering of the Tent that was made from ram skins dyed red and the covering that was made from fine leather. And they showed him the curtain that covered the entrance to the Most Holy Place. ");
INSERT INTO engerv_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","They showed Moses the Box of the Agreement, the poles used for carrying it, and the mercy-cover. ");
INSERT INTO engerv_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","They showed him the table with everything on it and the special bread. ");
INSERT INTO engerv_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","They showed him the pure gold lampstand and the lamps on it, the oil, and all the other things that were used with the lamps. ");
INSERT INTO engerv_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","They showed Moses the golden altar, the anointing oil, the sweet-smelling incense, and the curtain that covered the entrance to the Tent. ");
INSERT INTO engerv_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","They showed him the bronze altar, the bronze screen, the poles used for carrying the altar, and everything that was used on the altar. They showed him the bowl and the base under the bowl. ");
INSERT INTO engerv_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","They showed Moses the wall of curtains around the courtyard with the posts and bases. They showed him the curtain that covered the entrance to the courtyard. They showed him the ropes and the tent pegs. They showed him everything in the Holy Tent, that is, the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Then they showed Moses the clothes that were made for the priests serving in the holy area. They showed him the special clothes for Aaron the priest and his sons to wear when they served as priests. ");
INSERT INTO engerv_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","The Israelites did all this work exactly as the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moses looked closely at all the work and saw that it was done exactly as the LORD had commanded. So Moses blessed them. ");
INSERT INTO engerv_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“On the first day of the first month, set up the Holy Tent, that is, the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Put the Box of the Agreement in the Holy Tent. Cover the Box with the curtain. ");
INSERT INTO engerv_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Then bring in the table. Put the things on the table that should be there. Then put the lampstand in the Tent. Put the lamps on the lampstand in the right places. ");
INSERT INTO engerv_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Put the golden altar for offering incense in the Tent in front of the Box of the Agreement. Then put the curtain at the entrance to the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Put the altar for burning offerings in front of the entrance of the Holy Tent, that is, the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Put the bowl between the Meeting Tent and the altar. Put water in the bowl. ");
INSERT INTO engerv_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Set up the wall of curtains around the courtyard. Then put the curtain at the entrance to the courtyard. ");
INSERT INTO engerv_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Use the anointing oil and anoint the Holy Tent and everything in it. When you put the oil on these things, you will make them holy. ");
INSERT INTO engerv_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Anoint the altar for burning offerings. Anoint everything on the altar. You will make the altar holy. It will be very holy. ");
INSERT INTO engerv_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Then anoint the bowl and the base under it to make these things holy. ");
INSERT INTO engerv_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Bring Aaron and his sons to the entrance of the Meeting Tent. Wash them with water. ");
INSERT INTO engerv_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Then put the special clothes on Aaron. Anoint him with the oil and make him holy. Then he can serve me as a priest. ");
INSERT INTO engerv_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Then put the clothes on his sons. ");
INSERT INTO engerv_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Anoint the sons in the same way you anointed their father. Then they can also serve me as priests. When you anoint them, they will become priests. That family will continue to be priests for all time to come.” ");
INSERT INTO engerv_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moses obeyed the Lord. He did everything that the LORD commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","So the Holy Tent was set up at the right time. It was the first day of the first month during the second year from the time they left Egypt. ");
INSERT INTO engerv_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moses set up the Holy Tent just as the Lord had said. He put the bases down first. Then he put the frames on the bases. Then he put the braces on and set up the posts. ");
INSERT INTO engerv_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","After that Moses put the outer tent over the Holy Tent. Then he put the covering over the outer tent. He did these things just as the LORD had commanded. ");
INSERT INTO engerv_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Moses took the Agreement and put it in the Holy Box. He put the poles on the Box and put the mercy-cover on it. ");
INSERT INTO engerv_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Then Moses put the Holy Box into the Holy Tent. He hung the curtain in the right place to protect it. In this way he protected the Box of the Agreement behind the curtain just as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Then Moses put the table in the Meeting Tent on the north side of the Holy Tent. He put it in the Holy Place, in front of the curtain. ");
INSERT INTO engerv_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Then he put the bread on the table before the LORD. He did this just as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Then Moses put the lampstand in the Meeting Tent on the south side of the Tent, across from the table. ");
INSERT INTO engerv_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Then Moses put the lamps on the lampstand before the LORD. He did this just as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Then Moses put the golden altar in the Meeting Tent, in front of the curtain. ");
INSERT INTO engerv_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Then he burned sweet-smelling incense on the altar. He did this as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Then Moses put the curtain at the entrance to the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Moses put the altar for burning offerings at the entrance to the Holy Tent, that is, the Meeting Tent. Then Moses offered a burnt offering on that altar. He also offered grain offerings to the Lord. He did these things just as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Then Moses put the bowl between the Meeting Tent and the altar. He put water in the bowl for washing. ");
INSERT INTO engerv_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moses, Aaron, and Aaron’s sons used this bowl to wash their hands and feet. ");
INSERT INTO engerv_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","They washed themselves every time they entered the Meeting Tent. They also washed themselves every time they went near the altar. They did these things just as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Then Moses set up the curtains around the courtyard of the Holy Tent. He put the altar in the courtyard. Then he put the curtain at the entrance to the courtyard. So he finished all the work. ");
INSERT INTO engerv_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Then the cloud covered the Meeting Tent and the Glory of the LORD filled the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moses could not go into the Meeting Tent because the cloud had settled on it, and the Glory of the LORD had filled the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","When the cloud rose from the Holy Tent, the Israelites would begin to travel. ");
INSERT INTO engerv_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","But when the cloud stayed on the Holy Tent, the people did not try to move. They stayed in that place until the cloud rose. ");
INSERT INTO engerv_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","So the cloud of the LORD was over the Holy Tent during the day, and at night there was a fire in the cloud. So all the Israelites could see the cloud while they traveled. ");
INSERT INTO engerv_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","So the LORD called out to Moses from inside the Meeting Tent and said, ");
INSERT INTO engerv_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Tell the Israelites: When you bring an offering to the LORD, the offering must be one of your tame animals—it can be a sheep, a goat, or one of your cattle. ");
INSERT INTO engerv_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“If you offer one of your cattle as a burnt offering, it must be a bull that has nothing wrong with it. You must take the animal to the entrance of the Meeting Tent where the LORD will accept the offering. ");
INSERT INTO engerv_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","You must put your hand on the animal’s head while it is being killed. So the Lord will accept it as your burnt offering to make you pure. ");
INSERT INTO engerv_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“You must kill the young bull in front of the LORD. Then Aaron’s sons, the priests, will bring the blood to the altar that is near the entrance of the Meeting Tent. He will splash the blood on all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","You must remove the skin from that animal and then cut the animal into pieces. ");
INSERT INTO engerv_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aaron’s sons, the priests, will put the fire on the altar and arrange the wood on the fire. ");
INSERT INTO engerv_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","They will lay the pieces of the animal, including the head and fat, on top of the burning wood. ");
INSERT INTO engerv_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","You must wash the legs and inner parts of the animal with water. Then the priest will bring all these parts to the altar to be offered as a burnt offering, a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“If you offer a sheep or a goat as a burnt offering, it must be a male that has nothing wrong with it. ");
INSERT INTO engerv_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","You must kill the animal on the north side of the altar in front of the LORD. Then Aaron’s sons, the priests, will splash the animal’s blood on all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","You must cut the animal into pieces and remove the head and the fat. The priest will then lay them on the wood that is on the fire of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","You must wash the legs and inner parts of the animal with water. Then the priest will bring all these parts to the altar to be offered as a burnt offering, a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“If you offer a bird as a burnt offering to the LORD, that bird must be a dove or a young pigeon. ");
INSERT INTO engerv_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","The priest will bring the offering to the altar. There the priest will remove the bird’s head, drain out the blood on the side of the altar, and burn the bird on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","He will remove the bird’s tail and inner parts and throw them onto the pile of ashes east of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Then the priest will tear the bird open by its wings, but he must not divide it completely into two parts. So he will bring the bird to the altar to be offered as a burnt offering, a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“When you give a grain offering to the LORD, your offering must be made from fine flour. You must pour oil on this flour and put frankincense on it. ");
INSERT INTO engerv_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Then you must bring it to Aaron’s sons, the priests. One of them will take a handful of the fine flour with oil and frankincense in it. He will bring this part, which represents the whole grain offering, to the altar. There it will be burned up as a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","The rest of that grain offering will belong to Aaron and his sons. This gift to the LORD is very holy. ");
INSERT INTO engerv_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“If you give a grain offering that was baked in the oven, it must be unleavened bread made from fine flour mixed with oil, or it must be wafers with oil poured over them. ");
INSERT INTO engerv_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","If you bring a grain offering cooked in a baking pan, it must be made from fine flour without yeast and mixed with oil. ");
INSERT INTO engerv_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","You must break it into pieces and pour oil over it. It is a grain offering. ");
INSERT INTO engerv_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","If you bring a grain offering cooked in a frying pan, it must be made from fine flour mixed with oil. ");
INSERT INTO engerv_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“When you bring grain offerings made from these things to the LORD, you must give them to the priest, and he will take them to the altar. ");
INSERT INTO engerv_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Then the priest will take part of the grain offering and lift it up as a memorial offering. He will bring it to the altar to be burned up as a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","The rest of that grain offering will belong to Aaron and his sons. This gift to the LORD is very holy. ");
INSERT INTO engerv_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“You must not give any grain offering to the LORD that has yeast in it. You must not burn yeast or honey as a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","You may bring yeast and honey to the LORD as an offering from the first harvest, but they must not be put on the altar to be burned as a sweet smell. ");
INSERT INTO engerv_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Also, you must put salt on every grain offering you bring. You must not forget to add salt, because it represents God’s agreement with you. Always put salt on these offerings. ");
INSERT INTO engerv_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“If you bring a grain offering from the first harvest to the LORD, you must bring roasted heads of grain. They must be crushed heads of fresh grain. This will be your grain offering from the first harvest. ");
INSERT INTO engerv_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","You must put oil and frankincense on it. It is a grain offering. ");
INSERT INTO engerv_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","The priest must burn part of the crushed grain, the oil, and all the frankincense on it as a memorial offering. It is a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“If you offer one of your cattle as a fellowship offering, it can be a bull or a cow. But the animal you offer to the LORD must have nothing wrong with it. ");
INSERT INTO engerv_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","You must put your hand on the animal’s head and kill the animal at the entrance of the Meeting Tent. Then Aaron’s sons, the priests, will splash the blood on all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","The priest will take a part of that fellowship offering as a gift to the LORD. He will take the fat that is over and around the inner parts. ");
INSERT INTO engerv_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","He will take the two kidneys and the fat covering them near the lower back muscle. He will also remove the fat part of the liver that is near the kidneys. ");
INSERT INTO engerv_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Then Aaron’s sons will bring the fat to the altar and put it on the burnt offering that is on the wood on the fire. It is a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“If you offer a sheep or a goat as a fellowship offering to the LORD, whether it is a male or a female, it must have nothing wrong with it. ");
INSERT INTO engerv_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","If you bring a lamb as an offering to the LORD, ");
INSERT INTO engerv_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","you must put your hand on the animal’s head and kill it in front of the Meeting Tent. Then Aaron’s sons will splash the animal’s blood on all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","The priest will take part of the fellowship offering to the altar as a gift to the LORD. The priest must cut off the tail close to the backbone. Then he will offer the tail with all its fat and the fat that is over and around the animal’s inner parts. ");
INSERT INTO engerv_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","He will also offer the two kidneys and the fat covering them near the lower back muscles. He will also offer the fat part of the liver. He must remove it with the kidneys. ");
INSERT INTO engerv_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Then the priest will take that part to the altar to be burned up as food, a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“If the offering is a goat, you must bring it before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","You must put your hand on the goat’s head and kill it in front of the Meeting Tent. Then Aaron’s sons, the priests, must splash the goat’s blood on all four sides of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","The priest will give part of the fellowship offering as a gift to the LORD. He will offer the fat that is over and around the animal’s inner parts. ");
INSERT INTO engerv_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","He will offer the two kidneys and the fat covering them near the lower back muscle. He will also offer the fat part of the liver. He will remove it with the kidneys. ");
INSERT INTO engerv_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Then the priest will bring that food as a sweet-smelling gift to the Lord. The fat belongs to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","This rule will continue forever through all your generations. Wherever you live, you must never eat fat or blood.” ");
INSERT INTO engerv_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","The LORD spoke to Moses and said, ");
INSERT INTO engerv_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Tell the Israelites this: A person might sin without meaning to and do something that the LORD commanded should not be done. For example: ");
INSERT INTO engerv_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“If the anointed priest makes a mistake that leaves the people guilty for their sin, he must offer a young bull to the LORD as a sin offering. The bull must have nothing wrong with it. ");
INSERT INTO engerv_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","The anointed priest must bring the bull to the entrance of the Meeting Tent in front of the LORD. He must put his hand on the bull’s head and kill the bull in front of the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Then the anointed priest must get some of the blood from the bull and take it into the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","He must put his finger in the blood and sprinkle the blood seven times before the LORD in front of the curtain of the Most Holy Place. ");
INSERT INTO engerv_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","The priest must put some of the blood on the corners of the incense altar. (This altar is in the Meeting Tent, in front of the LORD.) He must pour out the rest of the bull’s blood at the base of the altar of burnt offering. (This altar is at the entrance of the Meeting Tent.) ");
INSERT INTO engerv_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Then the priest must take all the fat from the bull of the sin offering. He must take the fat that is on and around the inner parts. ");
INSERT INTO engerv_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","He must take the two kidneys and the fat covering them near the lower back muscle. He must also take the fat part of the liver. He must remove it with the kidneys. ");
INSERT INTO engerv_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","The priest must lift up these things and burn them on the altar for burnt offerings, just as he does for the fellowship offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","But the priest must carry out the bull’s skin, inner parts and body waste, and all the meat, including the head and legs. He must carry those parts outside the camp to the special place where the ashes are poured out. He must put those parts on the wood and burn them there on the ash pile. ");
INSERT INTO engerv_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“The whole nation of Israel might sin without knowing it. They might break one of the commands of the LORD and become guilty of doing something he said must not be done. ");
INSERT INTO engerv_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","When they learn about that sin, the community of Israel must offer a young bull as a sin offering for the whole nation. They must bring the bull to the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","The elders of the people must put their hands on the bull’s head in front of the LORD. Then they must kill the bull in front of the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","The anointed priest must get some of the bull’s blood and take it into the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","He must put his finger in the blood and sprinkle it seven times in front of the curtain before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","He must put some of the blood on the corners of the altar. (This altar is inside the Meeting Tent, in front of the LORD.) He must then pour out all the blood at the base of the altar of burnt offering. (This altar is at the entrance of the Meeting Tent.) ");
INSERT INTO engerv_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Then he must take all the fat from the animal and bring it to the altar. ");
INSERT INTO engerv_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","He must offer these parts, just as he offered the bull of the sin offering. In this way the priest will make the people pure, and God will forgive them. ");
INSERT INTO engerv_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","The priest must carry this bull outside the camp and burn it, just as he burned the other bull. This is the sin offering for the whole community. ");
INSERT INTO engerv_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“A ruler might sin without meaning to and break one of the commands of the LORD. He might do something that his God said must not be done. ");
INSERT INTO engerv_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","If he learns about his sin, he must bring a male goat that has nothing wrong with it as his offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","The ruler must put his hand on the goat’s head and kill the goat at the place where they kill the burnt offering before the LORD. The goat is a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","The priest will take some of the blood of the sin offering on his finger and put it on the corners of the altar of burnt offering. He will pour out the rest of the blood at the base of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","The priest will burn all the goat’s fat on the altar, just as he does for the fellowship offerings. In this way the priest will make the ruler pure, and God will forgive him. ");
INSERT INTO engerv_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Finally, one of you common people might sin without meaning to. You might break one of the commands of the LORD and become guilty of doing something he said must not be done. ");
INSERT INTO engerv_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","If you learn about that sin, you must bring a female goat that has nothing wrong with it as your sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","You must put your hand on the animal’s head and kill it at the place for the burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Then the priest will take some of the goat’s blood on his finger and put it on the corners of the altar of burnt offering. He will pour out the rest of its blood at the base of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","The priest will then remove all of its fat, just as he does for the fellowship offerings. Then he will bring it to the altar as a sweet smell to the LORD. The priest will do this to make you pure, and God will forgive you. ");
INSERT INTO engerv_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“If you bring a lamb as your sin offering, then you must bring a female lamb that has nothing wrong with it. ");
INSERT INTO engerv_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","You must put your hand on the animal’s head and kill it as a sin offering in the place where people kill the burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","The priest will take some of the blood from the sin offering on his finger and put it on the corners of the altar of burnt offering. He will pour out the rest of the lamb’s blood at the base of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","He will then remove all the lamb’s fat, just as he does for the fellowship offerings. Then he will bring it to the altar as a gift to the LORD. The priest will do this to make you pure, and God will forgive you. ");
INSERT INTO engerv_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“You might be called as a witness and take an oath to tell the truth. If you saw something or knew something but did not tell it, you are guilty of doing wrong and must bear the responsibility for your guilt. ");
INSERT INTO engerv_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“You might touch something unclean. It might be the dead body of any kind of animal. You might not know that you touched these things, but you will still become unclean and must pay a fine. ");
INSERT INTO engerv_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“You might touch any of the many things that can make a person unclean. You might touch something unclean, but not know about it. When you learn that you have touched something unclean, you must pay a fine. ");
INSERT INTO engerv_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“You might make a quick promise to do something—it makes no difference if it is bad or good. People make many kinds of quick promises. You might make such a promise and forget it. When you remember your promise, you must pay a fine because you did not keep it. ");
INSERT INTO engerv_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","If you are guilty of any of these things, you must confess whatever you did wrong. ");
INSERT INTO engerv_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Then you must bring your guilt offering to the LORD for the sin you did. You must bring a female lamb or a female goat as a sin offering. The priest will do this to make you pure from your sin. ");
INSERT INTO engerv_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“If you cannot afford a lamb, you must bring two doves or two young pigeons to the LORD. These will be the guilt offering for your sin. One bird must be for a sin offering, and the other must be for a burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Take them to the priest. First, the priest will offer one bird for the sin offering. The priest will pull the bird’s head from its neck but he will not pull it off completely. ");
INSERT INTO engerv_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","The priest will sprinkle the blood from the sin offering on the side of the altar. Then he will pour out the rest of the blood at the base of the altar. It is a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Then he will offer the second bird according to the rules for a burnt offering. The priest will do this to make you pure from the sin you did, and God will forgive you. ");
INSERT INTO engerv_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“If you cannot afford two doves or two pigeons, you must bring 8 cups of fine flour as your sin offering. You must not put oil or frankincense on the flour because it is a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","You must bring the flour to the priest. The priest will take a handful of the flour as the memorial offering and bring it to the altar as a gift to the LORD. It is a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","The priest will do this to make you pure, and God will forgive you. The part that is left will belong to the priest, just as the regular grain offering.” ");
INSERT INTO engerv_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","The LORD gave this command to Moses for the people: ");
INSERT INTO engerv_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“You might promise to give something to the LORD. You might sin against me without meaning to by not giving what you promised. If you do that, you must bring a ram that has nothing wrong with it (or the same amount in silver using the official measure) as a guilt offering. ");
INSERT INTO engerv_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","You must give what you promised and add one-fifth of that amount as a fine. Give it to the priest and he will use the ram to make you pure, and God will forgive you. ");
INSERT INTO engerv_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“If you sin and break any of the commands that the LORD said must not be done, you are guilty. Even if you did not know about it, you are still responsible for your sin. ");
INSERT INTO engerv_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","You must bring a ram that has nothing wrong with it (or the same amount in silver) to the priest. The priest will offer the ram, and God will forgive you for the sin you did without knowing it. ");
INSERT INTO engerv_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","You are guilty, and you must pay the guilt offering to the LORD.” ");
INSERT INTO engerv_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","The LORD told Moses these rules for the people: ");
INSERT INTO engerv_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“You are guilty of sin against the LORD when you do any of these things: when you lie about what happened to something you were taking care of for someone else; when you lie about a deposit you received; when you steal something; when you cheat someone; ");
INSERT INTO engerv_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","when you find something that was lost and lie about having it; when you fail to keep a promise; or when you do any other bad things like these. ");
INSERT INTO engerv_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","If you do any of these things, you are guilty of doing wrong. You must give back whatever you stole or whatever you took by cheating. You must return whatever you took that another person asked you to hold, or whatever you found and lied about having, ");
INSERT INTO engerv_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","or whatever you made a false promise about. You must pay the full price and then add one-fifth of that amount as a fine and give it all to the true owner. ");
INSERT INTO engerv_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","You must also bring a ram to the LORD that has nothing wrong with it (or the same amount in silver) to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Then the priest will go to the LORD to make you pure, and God will forgive you for whichever of these things you did that made you guilty.” ");
INSERT INTO engerv_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Give this command to Aaron and his sons: This is the law of the burnt offering. The burnt offering must stay on the hearth of the altar all night until morning. The altar’s fire must be kept burning. ");
INSERT INTO engerv_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","The priest must change clothes and put on the special linen underwear and linen robe. Then he must gather up the ashes from the fire and burnt offerings and set them down by the altar. ");
INSERT INTO engerv_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Then he must take off the special clothes and put on the other clothes and carry the ashes outside the camp to a special place that is pure. ");
INSERT INTO engerv_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","The fire that was started on the altar must never be allowed to stop burning. Every morning the priests must put wood on the altar. They must arrange the burnt offerings on the wood, and they must burn the fat of the fellowship offerings on it. ");
INSERT INTO engerv_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","That fire must always be kept burning on the altar. It must never be allowed to stop burning. ");
INSERT INTO engerv_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“This is the law for the grain offering: The sons of Aaron will bring it to the front of the altar as an offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","There must be some oil and frankincense on the grain offering. The priest will take a handful of fine flour from the grain offering and burn it on the altar as a sweet-smelling memorial offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“Aaron and his sons will use the rest of that grain to make bread without yeast. This must be eaten in a holy place—in the courtyard around the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","I have given this part of the grain offering as the priests’ share of the gifts offered to me. Like the sin offering and the guilt offering, it is most holy. It must not be baked with yeast. ");
INSERT INTO engerv_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Any male descendant of Aaron may eat from these gifts to the LORD. This is their share forever throughout your generations. Whatever touches these offerings will be made holy.” ");
INSERT INTO engerv_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“This is the offering that Aaron and his sons must bring to the LORD when Aaron is anointed to be the high priest. They must bring 8 cups of fine flour for a grain offering. This will be offered at the times of the daily offering—half of it in the morning and half of it in the evening. ");
INSERT INTO engerv_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","The fine flour must be mixed with oil and baked on a pan. After it is cooked, you must bring it in, break it into pieces, and offer it as a sweet-smelling gift to LORD. ");
INSERT INTO engerv_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“In the future, when Aaron’s descendants take their place as the anointed priests, they will continue to make this grain offering to the Lord. This rule will continue forever. The grain offering must be completely burned for the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Every grain offering that a priest gives must be completely burned. It must not be eaten.” ");
INSERT INTO engerv_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Tell Aaron and his sons: This is the law of the sin offering. The sin offering must be killed in the place where the burnt offering is killed before the LORD. It is most holy. ");
INSERT INTO engerv_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","The priest who offers the sin offering must eat it. But he must eat it in a holy place, in the courtyard around the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Touching the meat of the sin offering makes a person or a thing holy. “If any of the sprinkled blood falls on a person’s clothes, you must wash the clothes in a holy place. ");
INSERT INTO engerv_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","If the sin offering was boiled in a clay pot, the pot must be broken. If the sin offering was boiled in a bronze pot, the pot must be washed and rinsed in water. ");
INSERT INTO engerv_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“Any male in a priest’s family may eat the sin offering. It is very holy. ");
INSERT INTO engerv_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","But if the blood of the sin offering was taken into the Meeting Tent and used in the Holy Place to make people pure, that sin offering must not be eaten. It must be completely burned in the fire. ");
INSERT INTO engerv_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“These are the rules for the guilt offering, which is very holy: ");
INSERT INTO engerv_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","A priest must kill the guilt offering in the same place where they kill the burnt offerings. Then he must sprinkle the blood from the guilt offering around the altar. ");
INSERT INTO engerv_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“The priest must offer all the fat from the guilt offering. He must offer the fat tail and the fat that covers the inner parts. ");
INSERT INTO engerv_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","He must offer the two kidneys and the fat covering them at the lower back muscle. He must also offer the fat part of the liver. He must remove it with the kidneys. ");
INSERT INTO engerv_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","He must bring these things to the altar as a gift to the LORD. It is a guilt offering. ");
INSERT INTO engerv_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“Any male in a priest’s family may eat the guilt offering. It is very holy, so it must be eaten in a holy place. ");
INSERT INTO engerv_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","The guilt offering is like the sin offering. The same rules are for both offerings. The priest who does the sacrificing will get the meat for food. ");
INSERT INTO engerv_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","He will also get the skin from the burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Every grain offering belongs to the priest who offers it. That priest will get the grain offerings that were baked in an oven, or cooked on a frying pan, or in a baking dish. ");
INSERT INTO engerv_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","The grain offerings will belong to Aaron’s sons. It doesn’t make any difference if the grain offerings are dry or mixed with oil. The sons of Aaron will all share this food. ");
INSERT INTO engerv_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“This is the law of the sacrifice of fellowship offerings that you bring to the LORD: ");
INSERT INTO engerv_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","People can bring fellowship offerings to show their thanks to God. If you bring your sacrifice to give thanks, you should also bring unleavened bread mixed with oil, wafers with oil poured over them, and loaves of fine flour mixed with oil. ");
INSERT INTO engerv_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","You must also bring loaves of bread made with yeast to go with your fellowship offering. ");
INSERT INTO engerv_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Offer one each of these different kinds of bread as a gift to the LORD. Then it will belong to the priest who sprinkles the blood of the fellowship offerings. ");
INSERT INTO engerv_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","The meat of the fellowship offering must be eaten on the same day it is offered as a way of showing thanks to God. None of the meat should remain until the next morning. ");
INSERT INTO engerv_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“If you bring a fellowship offering simply because you want to give a gift to God or because it is part of a special promise you made to him, the sacrifice should be eaten the same day you offer it. But if there is any left, it must be eaten the next day. ");
INSERT INTO engerv_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","If any meat from this sacrifice is still left over on the third day, it must be burned in the fire. ");
INSERT INTO engerv_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","If anyone eats the meat from the fellowship offering on the third day, the Lord will not accept it as a sacrifice. It will have no value for that person, and to the Lord it will be like rotten meat! Whoever eats it will be responsible for their sin. ");
INSERT INTO engerv_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“People must not eat any of the meat that touches anything unclean. They must burn this meat in the fire. Whoever is clean may eat the meat from the fellowship offering. ");
INSERT INTO engerv_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","But anyone who is unclean and eats the meat from the fellowship offerings that was offered to the LORD must be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“If you touch something that is unclean, it doesn’t matter if it was made unclean by a person, an animal, or some disgusting thing, you will become unclean. And if you eat any of the meat from the fellowship offerings that was given to the LORD, you must be separated from your people.” ");
INSERT INTO engerv_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Tell the Israelites: You must not eat any fat from your cattle, sheep, or goats. ");
INSERT INTO engerv_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","You may use the fat from any animal that has died by itself or was torn by other animals, but you must never eat it. ");
INSERT INTO engerv_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Whoever eats the fat from an animal that was offered as a gift to the LORD must be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“No matter where you live, you must never eat blood from any bird or any animal. ");
INSERT INTO engerv_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Anyone who eats blood must be separated from their people.” ");
INSERT INTO engerv_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Tell the Israelites: If you bring a fellowship offering to the LORD, you must present that gift to the LORD yourself. ");
INSERT INTO engerv_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","You must bring the fat and the breast of the animal to the priest. Then he will lift up the breast in front of the LORD to show it was presented to God. ");
INSERT INTO engerv_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","The priest will burn the fat on the altar, but the breast of the animal will belong to Aaron and his sons. ");
INSERT INTO engerv_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","You must also give the right thigh from the fellowship offering as a gift to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","That part of the fellowship offering will belong to the priest who carries the blood and fat to the altar. ");
INSERT INTO engerv_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","I will accept the breast that was lifted up and the gift of the right thigh from the Israelites. Then I will give these things to Aaron and his sons. This is their share from the fellowship offerings of the Israelites forever.” ");
INSERT INTO engerv_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Those parts from the gifts offered to the LORD were given to Aaron and his sons. Whenever Aaron and his sons serve as the LORD’S priests, they get that share of the sacrifices. ");
INSERT INTO engerv_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","The LORD commanded the Israelites to give those parts to the priests once they have been anointed. That will be their share from the Israelites forever. ");
INSERT INTO engerv_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","These are the laws about burnt offerings, grain offerings, sin offerings, guilt offerings, fellowship offerings, and offerings for when the priests are appointed. ");
INSERT INTO engerv_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","The LORD gave these laws to Moses on Mount Sinai when he commanded the Israelites to bring their offerings to the LORD in the desert of Sinai. ");
INSERT INTO engerv_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Take Aaron and his sons with him and the clothes, the anointing oil, the bull of the sin offering, the two rams, and the basket of unleavened bread. ");
INSERT INTO engerv_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Then gather the people together at the entrance of the Meeting Tent.” ");
INSERT INTO engerv_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moses did what the LORD commanded him. The people met together at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Then Moses said to them, “This is what the LORD has commanded must be done.” ");
INSERT INTO engerv_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moses brought Aaron and his sons forward and washed them with water. ");
INSERT INTO engerv_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Moses put the woven shirt on Aaron and tied the cloth belt around him. Then Moses put the robe and the ephod on Aaron and tied the beautiful cloth belt around him. ");
INSERT INTO engerv_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Moses put the judgment pouch on Aaron and put the Urim and Thummim inside its pocket. ");
INSERT INTO engerv_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","He also put the turban on Aaron’s head. He put the strip of gold on the front of the turban. This strip of gold is the holy crown. Moses did this just as the LORD had commanded. ");
INSERT INTO engerv_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Then Moses took the anointing oil and sprinkled it on the Holy Tent and on everything in it. In this way he made them holy. ");
INSERT INTO engerv_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He sprinkled some of the anointing oil on the altar seven times. He sprinkled the oil on the altar, on all its tools and dishes, and on the bowl and its base. In this way he made them holy. ");
INSERT INTO engerv_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He poured some of the anointing oil on Aaron’s head to make him holy. ");
INSERT INTO engerv_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Then Moses brought Aaron’s sons forward. He put their woven shirts on them, tied belts around them, and put cloth caps on their heads. He did everything just as the LORD had commanded. ");
INSERT INTO engerv_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Then Moses brought out the bull of the sin offering. Aaron and his sons put their hands on the bull’s head. ");
INSERT INTO engerv_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Then Moses killed the bull and collected its blood. He used his finger to put some of the blood on all the corners of the altar. In this way he made the altar ready for sacrifices. Then he poured out the blood at the base of the altar to make the altar ready for sacrifices to make the people pure. ");
INSERT INTO engerv_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moses took all the fat from the inner parts of the bull. He took the fat part of the liver with the two kidneys and the fat on them. Then he burned them on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Moses took the bull’s skin, its meat, and its body waste outside the camp. He burned these things in a fire outside the camp. He did everything just as the LORD commanded him. ");
INSERT INTO engerv_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Then Moses brought the ram of the burnt offering. Aaron and his sons put their hands on the ram’s head. ");
INSERT INTO engerv_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Then Moses killed the ram. He sprinkled the blood around on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","He cut the ram into pieces. He washed the inner parts and legs with water. Then he burned the whole ram on the altar. He burned the head, the pieces, and the fat as a burnt offering. It was a sweet-smelling gift to the LORD. Moses did everything just as the LORD commanded. ");
INSERT INTO engerv_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Then Moses brought the other ram. This ram was used for appointing Aaron and his sons to become priests. Aaron and his sons put their hands on the ram’s head. ");
INSERT INTO engerv_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Then Moses killed the ram. He put some of its blood on the tip of Aaron’s ear, on the thumb of his right hand, and on the big toe of his right foot. ");
INSERT INTO engerv_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Then Moses brought Aaron’s sons close to the altar. He put some of the blood on the tip of their right ears, on the thumb of their right hands, and on the big toe of their right feet. Then he sprinkled the blood around on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","He took the fat, the fat tail, all the fat on the inner parts, the fat covering of the liver, the two kidneys and their fat, and the right thigh. ");
INSERT INTO engerv_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","A basket of unleavened bread is put before the LORD each day. Moses took one of those loaves of bread, one loaf of bread mixed with oil, and one unleavened wafer. He put these pieces of bread on the fat and on the right thigh of the ram. ");
INSERT INTO engerv_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Then he put all of it in the hands of Aaron and his sons. Moses lifted these pieces to show he was offering them before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Then Moses took these things from the hands of Aaron and his sons and burned them on the altar on top of the burnt offering. So this was the offering for appointing Aaron and his sons as priests. It was a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moses took the breast and lifted it to show he had presented it to the LORD. It was Moses’ share of the ram for appointing the priests. This was just as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moses took some of the anointing oil and some of the blood that was on the altar. He sprinkled some on Aaron and on Aaron’s clothes. He sprinkled some on Aaron’s sons who were with Aaron and on their clothes. In this way Moses made Aaron, his clothes, his sons, and his sons’ clothes holy. ");
INSERT INTO engerv_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Then Moses said to Aaron and his sons, “I told you, ‘Aaron and his sons must eat these things.’ So take the basket of bread and meat from the ceremony for appointing the priests. Boil that meat at the entrance of the Meeting Tent. Eat the meat and bread at that place. Do this as I told you. ");
INSERT INTO engerv_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","If any of the meat or bread is left, burn it. ");
INSERT INTO engerv_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","The ceremony for appointing the priests will last for seven days. You must not leave the entrance of the Meeting Tent until that time is finished. ");
INSERT INTO engerv_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Everything we did today was what the LORD commanded us to do in order to make you pure. ");
INSERT INTO engerv_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","You must stay at the entrance of the Meeting Tent day and night for seven days. If you don’t obey the LORD’S commands, you will die! The LORD gave me these commands.” ");
INSERT INTO engerv_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","So Aaron and his sons did everything that the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","On the eighth day, Moses called for Aaron and his sons and the elders of Israel. ");
INSERT INTO engerv_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","He said to Aaron, “Take a bull and a ram. There must be nothing wrong with them. The bull will be a sin offering, and the ram will be a burnt offering. Offer these animals to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Tell the Israelites, ‘Take a male goat for a sin offering, and take a calf and a lamb for a burnt offering. The calf and the lamb must each be one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Take a bull and a ram for fellowship offerings. Take these animals and a grain offering mixed with oil for an offering to the LORD. Do this because the LORD will appear to you today.’” ");
INSERT INTO engerv_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","So all the people came to the Meeting Tent. They all brought the things that Moses had commanded. All the people stood before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moses said, “You must do what the LORD commanded. Then the Glory of the LORD will appear to you.” ");
INSERT INTO engerv_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Then Moses told Aaron: “Go do what the LORD commanded. Go to the altar and offer sin offerings and burnt offerings. Do what will make you and the people pure. Take the people’s sacrifices and make them pure.” ");
INSERT INTO engerv_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","So Aaron went to the altar. He killed the bull for the sin offering. This sin offering was for himself. ");
INSERT INTO engerv_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Then the sons of Aaron brought the blood to Aaron. Aaron put his finger in the blood and put it on the corners of the altar. Then he poured out the blood at the base of the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","He took the fat, the kidneys, and the fat part of the liver from the sin offering. He burned them on the altar just as the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Then Aaron burned the meat and skin on a fire outside the camp. ");
INSERT INTO engerv_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Next, Aaron killed the animal for the burnt offering. His sons brought the blood to him, and he sprinkled the blood around on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Aaron’s sons gave the pieces and head of the burnt offering to Aaron, and he burned them on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","He also washed the inner parts and the legs of the burnt offering and burned them on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Then Aaron brought the people’s offering. He killed the goat of the sin offering that was for the people. He offered the goat for sin, like the earlier sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","He brought the burnt offering and offered it, just as the Lord had commanded. ");
INSERT INTO engerv_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","He brought the grain offering to the altar. He took a handful of the grain and put it on the altar beside that morning’s daily sacrifice. ");
INSERT INTO engerv_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aaron also killed the bull and the ram that were the fellowship offerings from the people. His sons brought the blood to him, and he sprinkled this blood around on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Aaron’s sons also brought him the fat of the bull and the ram. They brought the fat tail, the fat covering the inner parts, the kidneys, and the fat part of the liver. ");
INSERT INTO engerv_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Aaron’s sons put these fat parts on the breasts of the bull and the ram. Aaron burned them on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","He lifted the breasts and the gift of the right thigh to show he was offering them before the LORD, just as Moses had commanded. ");
INSERT INTO engerv_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Then Aaron lifted up his hands toward the people and blessed them. After he finished offering the sin offering, the burnt offering, and the fellowship offerings, he came down from the altar. ");
INSERT INTO engerv_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moses and Aaron went into the Meeting Tent. They came out and blessed the people. Then the Glory of the LORD appeared to all the people. ");
INSERT INTO engerv_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Fire came out from the LORD and burned the burnt offering and fat on the altar. When all the people saw this, they shouted with joy and then bowed to the ground to show their respect. ");
INSERT INTO engerv_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Then Aaron’s sons Nadab and Abihu made a mistake. They took their incense dishes and put some fire and incense in them. But they did not use the fire that was on the altar—they took fire from some other place and brought it to the LORD. This was not what he had commanded. ");
INSERT INTO engerv_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","So fire came from the LORD and destroyed Nadab and Abihu, and they died there in front of the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Then Moses said to Aaron, “The LORD says, ‘The priests who come near me must respect me. I must be holy to them and to all the people.’” So Aaron did not say anything about his sons dying. ");
INSERT INTO engerv_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Aaron’s uncle Uzziel had two sons. They were Mishael and Elzaphan. Moses said to these sons, “Come here and get your cousins’ bodies and carry them away from this holy place and take them outside the camp.” ");
INSERT INTO engerv_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","So Mishael and Elzaphan obeyed Moses. They carried the bodies of Nadab and Abihu outside the camp. Nadab and Abihu were still wearing their special woven shirts. ");
INSERT INTO engerv_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Then Moses spoke to Aaron and his other sons Eleazar and Ithamar. He said, “Don’t show any sadness! Don’t tear your clothes or mess up your hair! If you do anything to show your sadness, you will be killed, and the Lord will show his anger against everyone. But let all the other people of Israel, your relatives, cry for those the LORD destroyed with fire. ");
INSERT INTO engerv_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","But you must not even leave the entrance of the Meeting Tent. If you leave, you will die because the LORD’S anointing oil is on you.” So Aaron, Eleazar, and Ithamar obeyed Moses. ");
INSERT INTO engerv_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Then the LORD said to Aaron, ");
INSERT INTO engerv_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“You and your sons must not drink wine or beer when you come into the Meeting Tent. If you do, you will die. This law continues forever through your generations. ");
INSERT INTO engerv_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","You must be able to clearly tell the difference between what is holy and what is not holy, between what is clean and what is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","And you must teach the people about all the laws that the LORD gave them through Moses.” ");
INSERT INTO engerv_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Aaron had two sons who were still alive, Eleazar and Ithamar. Moses said to Aaron and his two sons, “When people give sacrifices as a gift to the LORD, some of the grain offering is not burned. Use that grain to make bread without yeast. You priests must eat that bread near the altar because that grain is very holy. ");
INSERT INTO engerv_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","The portion of food for you and your sons will come from the special gifts to the LORD, so you must eat that food in a holy place. ");
INSERT INTO engerv_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“You, your sons, and your daughters may all eat the breast and thigh that were lifted up before the Lord as an offering. But you must eat these in a place that is clean because they come from the fellowship offerings. They are your share of those offerings that the Israelites give to God. ");
INSERT INTO engerv_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","The people must bring the gifts of fat from their animals as part of the sacrifice. They must also bring the thigh of the fellowship offering and the breast that is lifted up to show it is offered in front of the LORD. Then it will be your share of the offering. It will belong to you and your children. That part of the sacrifices will be your share forever, just as the LORD said.” ");
INSERT INTO engerv_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moses looked for the goat of the sin offering, but it was already burned up. Moses became very angry with Aaron’s other sons Eleazar and Ithamar. Moses said, ");
INSERT INTO engerv_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Why did you not eat the sin offering in the holy area! That meat is very holy! God gave it to you to carry away the guilt of the people—to make the people pure before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","That goat’s blood was not brought into the Holy Place. So you should have eaten the meat in the holy area, just as I commanded!” ");
INSERT INTO engerv_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","But Aaron said to Moses, “Look, today they brought their sin offering and burnt offering before the LORD. But you know what happened to me today! Do you think the LORD would be happy if I ate the sin offering today?” ");
INSERT INTO engerv_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","When Moses heard this, he agreed. ");
INSERT INTO engerv_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Tell the Israelites: These are the animals you can eat: ");
INSERT INTO engerv_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","If an animal has hooves that are split into two parts, and if that animal also chews the cud, then you may eat the meat from that animal. ");
INSERT INTO engerv_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“Some animals chew the cud, but they don’t have split hooves. Don’t eat these animals. Camels, rock badgers, and rabbits are like that, so they are unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Other animals have hooves that are split into two parts, but they don’t chew the cud. Don’t eat these animals. Pigs are like that, so they are unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Don’t eat the meat from these animals. Don’t even touch their dead bodies! They are unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“You may eat everything that lives in the sea or in a river that has fins and scales. ");
INSERT INTO engerv_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","But you must not eat anything that lives in the sea or in a river and does not have fins and scales. Just the thought of eating such a creature should make you sick. This will never change. So don’t ever eat meat from anything like that. Don’t even touch its dead body! ");
INSERT INTO engerv_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","It is a sickening thought for you to touch anything that lives in the water and does not have fins and scales. ");
INSERT INTO engerv_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“You must also treat some birds as things that are wrong to eat. Stay away from them. It is a sickening thought for you to eat any of these birds: eagles, vultures, buzzards, ");
INSERT INTO engerv_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kites, all kinds of falcons, ");
INSERT INTO engerv_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","all kinds of black birds, ");
INSERT INTO engerv_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ostriches, nighthawks, sea gulls, all kinds of hawks, ");
INSERT INTO engerv_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","owls, cormorants, great owls, ");
INSERT INTO engerv_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","water hens, pelicans, carrion vultures, ");
INSERT INTO engerv_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","storks, all kinds of herons, hoopoes, and bats. ");
INSERT INTO engerv_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Don’t eat insects that have wings and crawl. Even the thought of eating them should make you sick! ");
INSERT INTO engerv_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","But you may eat insects if they have legs with joints above their feet so that they can jump. ");
INSERT INTO engerv_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","You may also eat all kinds of locusts, all kinds of winged locusts, all kinds of crickets, and all kinds of grasshoppers. ");
INSERT INTO engerv_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“But stay away from all the other insects that have wings and crawl. ");
INSERT INTO engerv_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","They will make you unclean. If you touch the dead bodies of these insects, you will become unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","If you pick up one of these dead insects, you must wash your clothes. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“Some animals have split hooves, but the hooves don’t make exactly two parts. Some animals don’t chew the cud. Some animals don’t have hooves—they walk on their paws. All these animals are unclean for you. If you touch them, you will become unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","If you pick up the dead bodies of these unclean animals, you must wash your clothes. You will be unclean until evening. These animals are unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“These small animals are unclean for you: moles, mice, all kinds of great lizards, ");
INSERT INTO engerv_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geckos, crocodiles, lizards, sand reptiles, and chameleons. ");
INSERT INTO engerv_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Whoever touches their dead bodies will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“If any of these unclean animals dies and falls on something, that thing will become unclean. It might be something made from wood, cloth, leather, or sackcloth. Whatever it is or is used for, it must be washed with water. It will be unclean until evening. Then it will become clean again. ");
INSERT INTO engerv_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","If any of these unclean animals dies and falls into a clay dish, anything in the dish will become unclean. And you must break the dish. ");
INSERT INTO engerv_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","If water from the unclean clay dish touches any food, that food will become unclean. Any drink in the unclean dish will become unclean. ");
INSERT INTO engerv_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","If any part of a dead, unclean animal falls on something, that thing is unclean. It may be a clay oven or a clay baking pan. It must be broken into pieces. These things will remain unclean. They will always be unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“A spring or a well that collects water will remain clean, but anyone who touches the dead bodies of any unclean animal in that water will become unclean. ");
INSERT INTO engerv_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","If any part of a dead, unclean animal falls on seed that is to be planted, that seed is still clean. ");
INSERT INTO engerv_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","But if you put water on some seed and if any part of a dead, unclean animal falls on those seeds, they are unclean for you. ");
INSERT INTO engerv_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Also, if an animal which you use for food dies, whoever touches its dead body will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","If you eat meat from this animal’s body, you must wash your clothes. You will be unclean until evening. If you pick up the dead body of the animal, you must wash your clothes. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“You must treat all the crawling animals that live on the dirt as disgusting things that you must not eat. ");
INSERT INTO engerv_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","You must not eat any of the reptiles that crawl on their bellies or that walk on all four feet or that have many feet. Don’t eat these animals! ");
INSERT INTO engerv_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Don’t let them make you filthy. You must not become unclean, ");
INSERT INTO engerv_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","because I am the LORD your God. I am holy, so you should keep yourselves holy. Don’t make yourselves unclean with these crawling things. ");
INSERT INTO engerv_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","I, the LORD, brought you out of Egypt so that you could be my special people and I could be your God. I am holy, so you must be holy too.” ");
INSERT INTO engerv_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","These are the rules about all the tame animals, birds, all the animals in the sea, and all the animals that crawl on the ground. ");
INSERT INTO engerv_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","These rules will help the people know which animals are unclean and which animals they are allowed to eat and which ones they cannot eat. ");
INSERT INTO engerv_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Tell the Israelites: “When a woman gives birth, she will be unclean, just as she is during her monthly time of bleeding. If the baby is a boy, the mother will be unclean for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","The baby boy must be circumcised on the eighth day. ");
INSERT INTO engerv_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Because of the blood from childbirth, another 33 days must pass before she can touch anything that is holy. She must not enter the Holy Place until the time of her purification is finished. ");
INSERT INTO engerv_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","But if she gives birth to a girl, the mother will be unclean for 14 days, just as she is during her monthly time of bleeding. Because of the blood from childbirth, another 66 days must pass before she becomes clean. ");
INSERT INTO engerv_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“After the time of her purification is finished, the new mother of a baby girl or boy must bring special sacrifices to the Meeting Tent. She must give her sacrifices to the priest at the entrance of the Meeting Tent. She must bring a one-year-old lamb for a burnt offering and a dove or young pigeon for a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","If the woman cannot afford a lamb, she may bring two doves or two young pigeons. One bird will be for a burnt offering and one for a sin offering. The priest will offer them before the LORD. In this way the priest will make her pure, and she will be clean from the blood of childbirth. These are the rules for a woman who gives birth to a baby boy or a baby girl.” ");
INSERT INTO engerv_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Someone might have a swelling on their skin, or it may be a rash or a bright spot. If the sore looks like the disease of leprosy, the person must be brought to Aaron the priest or to one of his sons, the priests. ");
INSERT INTO engerv_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","The priest must look at the sore on the person’s skin. If the hair in the sore has become white, and if the sore seems deeper than the person’s skin, it is leprosy. When the priest has finished looking at the person, he must announce that the person is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Sometimes there is a white spot on a person’s skin that does not seem deeper than the skin. If that is true, the priest must separate that person from other people for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","On the seventh day the priest must look at the person again. If the priest sees that the sore has not changed and has not spread on the skin, he must separate the person for seven more days. ");
INSERT INTO engerv_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Seven days later the priest must look at the person again. If the sore has faded and has not spread on the skin, the priest must announce that the person is clean. The sore is only a rash. After washing the clothes, that person will be clean again. ");
INSERT INTO engerv_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“But if the rash spreads over the skin after the person has shown himself to the priest to be made clean again, that person must come again to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","The priest must look, and if the rash has spread, he must announce that the person is unclean. The disease is leprosy. ");
INSERT INTO engerv_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Whoever has leprosy must be brought to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","He must look at that person. If there is a white swelling on the skin, if the hair has become white, and if the skin looks raw in the swelling, ");
INSERT INTO engerv_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","it is leprosy that has been there for a long time. The priest must announce that the person is unclean. He does not have to wait until after a period of separation, because he already knows that the person is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Sometimes a skin disease will spread all over a person’s body, covering the skin from head to foot. The priest must look at that person’s whole body. ");
INSERT INTO engerv_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","If the priest sees that the skin disease covers the whole body and that it has turned all the skin white, the priest must announce that the person is clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","But if the skin is raw, that person is not clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","When the priest sees the raw skin, he must announce that the person is unclean. The raw skin is not clean. It is leprosy. ");
INSERT INTO engerv_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“If the raw skin changes and becomes white, the person must come to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","The priest must look at the person. If the skin has become white, the person who had the infection is clean, and the priest must announce this. ");
INSERT INTO engerv_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Someone might get a boil on their skin that heals over. ");
INSERT INTO engerv_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Then that boil might become a white swelling or a bright, white spot with red streaks in it. If this happens, the person must show that spot to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","The priest must look at it. If the swelling is deeper than the skin, and the hair on it has become white, the priest must announce that the person is unclean. The spot is leprosy that has broken out from inside the boil. ");
INSERT INTO engerv_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","But if the priest looks at the spot, and there are no white hairs in it, and the spot is not deeper than the skin but is faded, the priest must separate the person for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","If the spot spreads on the skin, the priest must announce that the person is unclean; it is an infection. ");
INSERT INTO engerv_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","But if the bright spot stays in its place and does not spread, it is only the scar from the old boil. The priest must announce that the person is clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“Someone might get a burn on the skin. If the raw skin becomes a white spot or a white spot with red streaks in it, the priest must look at it. If that white spot seems to be deeper than the skin, and the hair at that spot has become white, it is leprosy that has broken out in the burn. The priest must announce that the person is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","But if the priest looks at the spot, and there is no white hair in the bright spot, and the spot is not deeper than the skin but is faded, the priest must separate the person for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","On the seventh day, the priest must look at the person again. If the spot has spread on the skin, the priest must announce that the person is unclean. It is leprosy. ");
INSERT INTO engerv_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","But if the bright spot has not spread on the skin but has faded, it is only a scar from the burn. The priest must announce that the person is clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Someone might get an infection on the scalp or beard. ");
INSERT INTO engerv_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","A priest must look at the infection. If the infection seems to be deeper than the skin, and if the hair around it is thin and yellow, the priest must announce that the person is unclean. It is a serious skin disease. ");
INSERT INTO engerv_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","If the disease does not seem deeper than the skin, but there is no dark hair in it, the priest must separate that person for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","On the seventh day, the priest must look at it again. If the disease has not spread, and there are no yellow hairs growing in it, and the disease does not seem deeper than the skin, ");
INSERT INTO engerv_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","the person must shave. But the diseased area should not be shaved. The priest must separate that person for seven more days. ");
INSERT INTO engerv_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","On the seventh day, the priest must look at it again. If the disease has not spread, and it does not seem deeper than the skin, the priest must announce that the person is clean. After washing those clothes, that person will be clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","But if the disease spreads on the skin after the person has become clean, ");
INSERT INTO engerv_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","then the priest must look at the person again. If the disease has spread, the priest does not need to look for yellow hair. The person is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","But if the priest thinks that the disease has stopped, and black hair is growing in it, the disease has healed. The person is clean, and the priest must announce this. ");
INSERT INTO engerv_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“If anyone has white spots on the skin, ");
INSERT INTO engerv_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","a priest must look at them. If the spots on that person’s skin are dull white, the disease is only a harmless rash. That person is clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“A man might begin to lose the hair on his head. It is only baldness, so he is clean. ");
INSERT INTO engerv_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","A man might lose hair from the sides of his head. He is clean. It is only another kind of baldness. ");
INSERT INTO engerv_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","But if there is a red and white infection on his scalp, it is a skin disease. ");
INSERT INTO engerv_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","A priest must look at him. If the swelling of the infection is red and white and looks like the leprosy on other parts of his body, ");
INSERT INTO engerv_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","then he has leprosy on his scalp. The person is unclean. The priest must announce that he is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“People with leprosy must warn other people. They must shout, ‘Unclean, unclean!’ They must tear their clothes at the seams. They must let their hair grow wild, and they must cover their mouth. ");
INSERT INTO engerv_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","They are unclean the whole time that they have the infection. They are unclean and must live outside the camp. ");
INSERT INTO engerv_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","“Some clothing might have mildew on it. The cloth could be linen or wool, woven or knitted. Or the mildew might be on a piece of leather or on something made from leather. ");
INSERT INTO engerv_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","If the mildew is green or red, it must be shown to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","The priest must look at it and put it in a separate place for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","On the seventh day, he must look at it again. It doesn’t matter if the mildew is on leather or cloth or if the cloth is woven or knitted. And it doesn’t matter what the leather was used for. If the mildew has spread, the object is unclean because of the infection. The priest must burn it. ");
INSERT INTO engerv_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“If the priest sees that the mildew did not spread on the object, it must be washed. It doesn’t matter if it is leather or cloth, or if the cloth is knitted or woven, it must be washed. ");
INSERT INTO engerv_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","He must order the people to wash it. Then he must separate the clothing for seven more days. ");
INSERT INTO engerv_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","After that time, the priest must look at it again. If the mildew still looks the same, the object is unclean. It doesn’t matter if the infection has not spread; you must burn that cloth or piece of leather. ");
INSERT INTO engerv_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“But if the priest looks at that piece of leather or cloth, and the mildew has faded, he must tear the infected spot out of the piece of leather or cloth. It doesn’t matter if the cloth is woven or knitted. ");
INSERT INTO engerv_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","But the mildew might come back to that piece of leather or cloth. If that happens, the mildew is spreading, and the object must be burned. ");
INSERT INTO engerv_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","But if the mildew did not come back after washing, that piece of leather or cloth is clean, whether the cloth was woven or knitted.” ");
INSERT INTO engerv_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","These are the rules for mildew on pieces of leather or cloth, whether the cloth is woven or knitted. ");
INSERT INTO engerv_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“These are the rules for people who have had a skin disease and have been made well. These rules are for making them clean. “A priest must look at those who had the skin disease. ");
INSERT INTO engerv_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","The priest must go to them outside the camp and look to see if the skin disease is healed. ");
INSERT INTO engerv_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","If they are healthy, the priest will tell them to do these things: They must bring two clean birds that are still alive, a piece of cedar wood, a piece of red cloth, and a hyssop plant. ");
INSERT INTO engerv_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Then the priest must order one bird to be killed in a clay bowl over running water. ");
INSERT INTO engerv_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","He must take the other bird that is still alive and the piece of cedar wood, the piece of red cloth, and the hyssop plant and dip them in the blood of the bird that was killed over the running water. ");
INSERT INTO engerv_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","He must sprinkle the blood seven times on those who had the skin disease. Then he must announce that they are clean. After that the priest must go to an open field and let the living bird go free. ");
INSERT INTO engerv_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“The people going through this purification ceremony must wash their clothes, shave off all their hair, and wash with water. Then they will be clean. They may then go into the camp, but they must stay outside their tent for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","On the seventh day, they must shave off all their hair. They must shave their head, their beard, and their eyebrows—yes, all their hair. Then they must wash their clothes and bathe their bodies in water. Then they will be clean. ");
INSERT INTO engerv_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“On the eighth day, anyone who had a skin disease must take two male lambs that have nothing wrong with them and a one-year-old female lamb that has nothing wrong with it. They must also take 24 cups of fine flour mixed with oil for a grain offering and 2/3 of a pint of olive oil. ");
INSERT INTO engerv_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","The priest must bring that person and those sacrifices before the LORD at the entrance of the Meeting Tent. (This must be the same priest who announced that the person is clean.) ");
INSERT INTO engerv_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","The priest will take one of the lambs and the oil as a guilt offering. He will lift them in front of the LORD to show they were presented to God. ");
INSERT INTO engerv_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Then the priest will kill the male lamb in the holy place where they kill the sin offering and the burnt offering. Like the sin offering, the guilt offering belongs to the priest. It is very holy. ");
INSERT INTO engerv_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“The priest will take some of the blood of the guilt offering. He will put some of this blood on the tip of the right ear of the person to be made clean. The priest will put some of this blood on the thumb of the right hand and on the big toe of the right foot of that person. ");
INSERT INTO engerv_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","The priest will also take some of the oil and pour it into his own left palm. ");
INSERT INTO engerv_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Then the priest will dip the finger of his right hand into the oil that is in his left palm. He will use his finger to sprinkle some of the oil seven times before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Then he will put some of the oil that is in his palm on the person to be made clean. He will put that oil on the same places he put the blood of the guilt offering. The priest will put some of the oil on the tip of the person’s right ear, on the thumb of the right hand, and on the big toe of the person’s right foot. ");
INSERT INTO engerv_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","He will put the oil that is left in his palm on the head of the person to be made clean. In this way he will make that person pure before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Then the priest must offer the sin offering to make that person pure. After that he will kill the animal for the burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","He will then offer up the burnt offering and the grain offering on the altar. In this way the priest will make that person pure, and that person will become clean. ");
INSERT INTO engerv_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“A poor person might not be able to afford all these offerings. So that poor person can use one male lamb as a guilt offering. It will be presented to God so that the priest can make that person pure. The poor person must take 8 cups of fine flour mixed with oil. This flour will be used for a grain offering. The poor person must also take 2/3 of a pint of olive oil ");
INSERT INTO engerv_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","and two doves or two young pigeons. Even poor people can afford these things. One bird will be a sin offering, and the other will be a burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“On the eighth day, that person will bring these things to the priest at the entrance of the Meeting Tent. These things will be offered before the LORD so that the person can become clean. ");
INSERT INTO engerv_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","The priest will take the lamb for the guilt offering and the oil, and he will lift them up to show they were offered before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Then he will kill the lamb of the guilt offering, take some of its blood, and put it on the tip of the right ear of the person to be made clean. The priest will put some of this blood on the thumb of the right hand and on the big toe of the right foot of this person. ");
INSERT INTO engerv_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","He will also pour some of this oil into his own left palm. ");
INSERT INTO engerv_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","He will use the finger of his right hand to sprinkle some of the oil that is in his left palm seven times before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Then he will put some of the oil that is in his palm on the same places he put the blood from the guilt offering. He will put some of the oil on the tip of the right ear of the person to be made clean. The priest will put some of the oil on the thumb of the right hand and on the big toe of the person’s right foot. ");
INSERT INTO engerv_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","He will put the oil that is left in his palm on the head of the person to be made clean. In this way he will make that person pure before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“Then the priest must offer one of the doves or young pigeons. (He must offer whichever the person can afford.) ");
INSERT INTO engerv_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","He must offer one of these birds as a sin offering and the other bird as a burnt offering. He must offer the birds with the grain offering. In this way the priest will make that person pure before the LORD, and that person will become clean.” ");
INSERT INTO engerv_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","These are the rules for making people clean after they become well from a skin disease. These are the rules for those who cannot afford the regular sacrifices for becoming clean. ");
INSERT INTO engerv_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","The LORD also said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“I am giving the land of Canaan to your people. Your people will enter that land. At that time I might cause mildew to grow in someone’s house. ");
INSERT INTO engerv_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","The person who owns that house must come and tell the priest, ‘I see something like mildew in my house.’ ");
INSERT INTO engerv_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“Then the priest must order the people to take everything out of the house before he goes in to look at the mildew. Then the priest will not have to say everything in the house is unclean. After the people have taken everything out of the house, the priest will go in to look at the house. ");
INSERT INTO engerv_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","He will look at the mildew. If the mildew on the walls of the house has holes that are a green or red color, and if the mildew goes into the wall’s surface, ");
INSERT INTO engerv_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","he must go out of the house and lock the house for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“On the seventh day the priest must come back and check the house. If the mildew has spread on the walls of the house, ");
INSERT INTO engerv_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","then he must order the people to tear out the stones with the mildew on them and throw them away. They must put these stones at a special unclean place outside the city. ");
INSERT INTO engerv_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Then the priest must have the entire house scraped inside. The people must throw away the plaster that was scraped off the walls. They must put that plaster at a special unclean place outside the city. ");
INSERT INTO engerv_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Then new stones must be put in the walls, and the walls must be covered with new plaster. ");
INSERT INTO engerv_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Maybe someone took away the old stones and plaster and put in new stones and plaster. And maybe mildew again appears in that house. ");
INSERT INTO engerv_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Then the priest must come in and check the house. If the infection has spread in the house, it is a disease that spreads quickly to other places. So the house is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","The house must be torn down. All the stones, plaster, and pieces of wood must be taken to the special unclean place outside the city. ");
INSERT INTO engerv_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Anyone who goes into that house will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Anyone who eats in that house or lies down in there must wash their clothes. ");
INSERT INTO engerv_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“After new stones and plaster are put in a house, the priest must check the house. If the mildew has not spread through the house, the priest will announce that the house is clean, because the mildew is gone. ");
INSERT INTO engerv_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“Then, to make the house clean, the priest must take two birds, a piece of cedar wood, a piece of red cloth, and a hyssop plant. ");
INSERT INTO engerv_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","He will kill one bird in a clay bowl over running water. ");
INSERT INTO engerv_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Then he will take the cedar wood, the hyssop, the piece of red cloth, and the living bird and dip them in the blood of the bird that was killed over running water. Then he will sprinkle that blood on the house seven times. ");
INSERT INTO engerv_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","In this way he will use these things to make the house clean. ");
INSERT INTO engerv_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","He will go to an open field outside the city and let the living bird go free. In this way the priest will make the house pure. The house will be clean.” ");
INSERT INTO engerv_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","These are the rules for any infection of leprosy, ");
INSERT INTO engerv_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","for mildew on pieces of cloth or in a house. ");
INSERT INTO engerv_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","These are the rules for swellings, rashes, or bright spots on the skin. ");
INSERT INTO engerv_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","These rules teach when something is clean and when something is unclean. These are the rules about these kinds of disease. ");
INSERT INTO engerv_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","The LORD also said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Say to the Israelites: Whoever has a genital discharge is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","The person is unclean whether the discharge continues to flow or whether it stops. ");
INSERT INTO engerv_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“If a man with a discharge lies on a bed, that bed becomes unclean. Everything he sits on will become unclean. ");
INSERT INTO engerv_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","If you touch that bed, you must wash your clothes and bathe in water. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","If you sit on anything that he sat on, you must wash your clothes and bathe in water. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","If you touch him, you must wash your clothes and bathe in water. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","If he spits on you, you must wash your clothes and bathe in water. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","If that man sits on a saddle, it will become unclean. ");
INSERT INTO engerv_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","If you touch or carry anything that was under him, you will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","If he touches you, you must wash your clothes and bathe in water. You will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“If a man with a discharge touches a clay bowl, that bowl must be broken. If he touches a wooden bowl, that bowl must be washed in water. ");
INSERT INTO engerv_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“When it comes time for a man with a discharge to be made clean, he must wait seven days. Then he must wash his clothes and bathe his body in running water. Then he will become clean. ");
INSERT INTO engerv_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","On the eighth day, he must take for himself two doves or two young pigeons and come before the LORD at the entrance of the Meeting Tent. He will give the two birds to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","The priest will offer the birds, one for a sin offering, and the other for a burnt offering. In this way the priest will make that man pure before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“If a man has a flow of semen, he must bathe his whole body in water. He will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","If the semen is on any clothing or leather, that clothing or leather must be washed with water. It will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","If a woman has sexual relations with a man, and he has a flow of semen, both the man and the woman must bathe in water. They will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“If a woman has a discharge from her monthly time of bleeding, she will be unclean for seven days. Anyone who touches her will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Everything she lies on during her monthly time of bleeding will be unclean. And everything she sits on during that time will be unclean. ");
INSERT INTO engerv_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Whoever touches her bed must wash their clothes and bathe in water. They will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Whoever touches anything she has sat on must wash their clothes and bathe in water. They will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","It doesn’t matter if they touched the woman’s bed or if they touched something she sat on, they will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“If a man has sexual relations with a woman during her monthly time of bleeding, he will be unclean for seven days. Every bed he lies on will be unclean. ");
INSERT INTO engerv_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“If a woman has a discharge of blood for many days, not during her time of monthly bleeding, or if she has a discharge after that time, she will be unclean, just as during the time of her monthly bleeding. She will be unclean for as long as she has a discharge. ");
INSERT INTO engerv_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Any bed she lies on during the time of her discharge will be like her bed during the time of her monthly bleeding. Everything she sits on will be unclean, just as it is during the time she is unclean from her monthly bleeding. ");
INSERT INTO engerv_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Whoever touches these things will be unclean until evening. They must wash their own clothes and bathe in water. ");
INSERT INTO engerv_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","After the woman’s discharge stops, she must wait seven days. After that she will be clean. ");
INSERT INTO engerv_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Then on the eighth day, she must bring two doves or two young pigeons to the priest at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Then the priest must offer one bird for a sin offering and the other bird for a burnt offering. In this way the priest will make her pure before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“So you must warn the Israelites about being unclean. If you don’t warn the people, they might make my Holy Tent unclean. And then they would have to die!” ");
INSERT INTO engerv_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","These are the rules for anyone with a discharge from the body. These rules are for men who become unclean from a flow of semen. ");
INSERT INTO engerv_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","And these rules are for women who become unclean from their monthly time of bleeding. And these are the rules for anyone who becomes unclean by sleeping with another person who is unclean. ");
INSERT INTO engerv_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Two of Aaron’s sons died while offering incense to the LORD. After that time, the LORD spoke to Moses. ");
INSERT INTO engerv_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","The LORD said, “Talk to your brother Aaron. Tell him that he cannot go behind the curtain into the Most Holy Place anytime he wants to. The mercy-cover is in the room behind that curtain on top of the Holy Box, and I appear in a cloud over that mercy-cover. If Aaron goes into that room, he will die! ");
INSERT INTO engerv_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Before Aaron enters the Most Holy Place, he will offer a bull for a sin offering and a ram for a burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Aaron will wash his whole body with water and put on the special clothes. He will put on the linen underwear next to his body, the linen robe, the linen belt, and then he will put the linen turban on his head. ");
INSERT INTO engerv_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“From the whole community of Israel, Aaron will accept two male goats for a sin offering and one ram for a burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Then he will offer the bull for the sin offering. This sin offering is for himself. He will do this to purify himself and his family. ");
INSERT INTO engerv_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“Then Aaron will take the two goats and bring them before the LORD at the doorway of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron will throw lots for the two goats. One lot will be for the LORD. The other lot will be for Azazel. ");
INSERT INTO engerv_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“Then Aaron will offer the goat chosen by the lot for the LORD. Aaron will make this goat a sin offering. ");
INSERT INTO engerv_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","But the goat chosen by the lot for Azazel will be brought alive before the LORD. Then this goat will be sent out to Azazel in the desert. This is to make the people pure. ");
INSERT INTO engerv_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Then Aaron will offer the bull as a sin offering for himself. He will purify himself and his family. He will kill the bull for the sin offering for himself. ");
INSERT INTO engerv_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Then he will take a firepan full of coals of fire from the altar before the LORD. Aaron will take two handfuls of sweet incense that has been ground into powder and take it into the room behind the curtain. ");
INSERT INTO engerv_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","He will put the incense on the fire before the LORD. Then the cloud of incense will hide the mercy-cover that is over the Box that holds the Agreement. This way Aaron will not die. ");
INSERT INTO engerv_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Aaron will dip his finger into the bull’s blood and sprinkle it on the front of the Holy Box. Then he will sprinkle the blood seven times onto the front of the mercy-cover. ");
INSERT INTO engerv_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Then Aaron will kill the goat of the sin offering for the people. He will bring this goat’s blood into the room behind the curtain. He will do with the goat’s blood as he did with the bull’s blood. He will sprinkle the goat’s blood on the mercy-cover and in front of it. ");
INSERT INTO engerv_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","In this way Aaron will purify the Most Holy Place from all the uncleanness and sins of the Israelites. He will also purify the Meeting Tent, because it stands in the middle of people whose sins have made them unclean. ");
INSERT INTO engerv_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“No one must be in the Meeting Tent when Aaron goes in to purify the Most Holy Place. No one is to go in there until Aaron comes out after purifying himself, his family, and all the Israelites. ");
INSERT INTO engerv_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Then Aaron will go out to the altar that is before the LORD. Aaron will make the altar pure. He will take some of the blood from the bull and from the goat and put it on the corners of the altar on all four sides. ");
INSERT INTO engerv_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Then he will dip his finger in the blood and sprinkle it on the altar seven times. In this way Aaron will make the altar holy and clean from all the sins of the Israelites. ");
INSERT INTO engerv_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“So Aaron will make the Most Holy Place, the Meeting Tent, and the altar pure. Then he will bring the living goat to the front of the tent. ");
INSERT INTO engerv_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","He will put both his hands on the head of the living goat. Then he will confess the sins and crimes of the Israelites over the goat. In this way Aaron will lay the people’s sins on the goat’s head. Then he will send the goat away into the desert. A man will be standing by, ready to lead this goat away. ");
INSERT INTO engerv_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","So the goat will carry all the people’s sins on itself into the empty desert. The man who leads the goat will let it loose in the desert. ");
INSERT INTO engerv_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Then Aaron will enter the Meeting Tent. He will take off the linen clothes that he put on when he went into the Holy Place. He will leave these clothes there. ");
INSERT INTO engerv_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","He will wash his whole body with water in a holy place. Then he will put on his clothes. He will come out and offer his burnt offering and the people’s burnt offering. He will make himself and the people pure. ");
INSERT INTO engerv_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Then he will burn the fat of the sin offering on the altar. ");
INSERT INTO engerv_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“The man who led the goat to Azazel must wash his clothes and his whole body with water. After that he may come into the camp. ");
INSERT INTO engerv_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“The bull and the goat for the sin offerings will be taken outside the camp. (The blood from these animals was brought into the Holy Place to make the holy things pure.) The skins, bodies, and body waste of those animals will be burned in the fire. ");
INSERT INTO engerv_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Then the man who burns them must wash his clothes and bathe his whole body with water. After that he may come into the camp. ");
INSERT INTO engerv_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“This law will always continue for you: On the tenth day of the seventh month, you must not eat food. You must not do any work. None of the travelers or foreigners living in your land can do any work either. ");
INSERT INTO engerv_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Because on this day, the priest will do this to make you pure and wash away your sins. Then you will be clean to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","You must humble yourselves because this day is a very important day of rest for you. This law will continue forever. ");
INSERT INTO engerv_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“In the future, this ceremony will be done by the priest who will be anointed and appointed to serve after his father. That priest will put on the holy linen clothes ");
INSERT INTO engerv_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","and make the Most Holy Place, the Meeting Tent, and the altar pure. He will also make the priests and all the people pure. ");
INSERT INTO engerv_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","That law will continue forever. Once every year you will purify the Israelites from all their sins.” So they did everything that the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Speak to Aaron and to his sons, and to all the Israelites. Tell them this is what the LORD has commanded: ");
INSERT INTO engerv_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Any one of you Israelites might kill a bull, a lamb, or a goat. You might be in the camp or outside the camp. ");
INSERT INTO engerv_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","It doesn’t matter; you must bring that animal to the entrance of the Meeting Tent. You must give a part of that animal as a gift to the LORD. You spilled blood, so you must take a gift to the LORD’S Holy Tent. If you don’t take part of the animal as a gift to the LORD, you must be separated from your people! ");
INSERT INTO engerv_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","This rule is so that you will bring your fellowship offering to the LORD. You must bring any animal that you kill in the field to the LORD at the entrance of the Meeting Tent. Bring those animals to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Then the priest will throw their blood onto the LORD’S altar near the entrance of the Meeting Tent. And the priest will burn the fat from those animals on the altar as a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","In this way you will stop being unfaithful to me by offering sacrifices to your ‘goat gods.’ This law will continue forever. ");
INSERT INTO engerv_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Tell the people: Any citizen of Israel, traveler, or foreigner living among you might want to offer a burnt offering or some other sacrifice. ");
INSERT INTO engerv_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","They must take the sacrifice to the entrance of the Meeting Tent and offer it to the LORD. Whoever does not do this will be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“I will turn against those who eat blood whether they are citizens of Israel or foreigners living among you, I will separate them from their people. ");
INSERT INTO engerv_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","This is because the life of the body is in the blood. I have told you that you must pour the blood on the altar to purify yourselves. It is the blood that makes a person pure. ");
INSERT INTO engerv_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","That is why I am telling you Israelites and the foreigners living among you that you must not eat blood. ");
INSERT INTO engerv_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“If any of you, whether Israelite or foreigner living among you, goes hunting and kills a wild animal or bird that you are allowed to eat, you must pour the blood of that animal on the ground and cover it with dirt. ");
INSERT INTO engerv_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","This is because the life of every kind of animal is in its blood. So I give this command to the Israelites: Don’t eat meat that still has blood in it! Whoever eats blood must be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“If any of you, whether Israelite or foreigner living among you, eats an animal that died by itself or was killed by some other animal, you will be unclean until evening. You must wash your clothes and bathe your whole body with water. ");
INSERT INTO engerv_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","If you don’t wash your clothes and bathe your whole body, you will be responsible for your guilt.” ");
INSERT INTO engerv_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Tell the Israelites: I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","You must not follow the customs of Egypt where you lived, and you must not follow the customs of the Canaanites where I am leading you. You must not live the way they do. ");
INSERT INTO engerv_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","You must obey my rules and follow my laws. Be sure to follow my rules because I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","You must obey my rules and my laws, because whoever obeys them will live. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“You must never have sexual relations with your close relatives. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“You must never have sexual relations with your father or mother. She is your mother, so you must not have sexual relations with her. ");
INSERT INTO engerv_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","You must not have sexual relations with your father’s wife, even if she is not your mother, because that is like having sexual relations with your father. ");
INSERT INTO engerv_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“You must not have sexual relations with your sister. It doesn’t matter if she is the daughter of your father or your mother. And it doesn’t matter if your sister was born in your house or at some other place. ");
INSERT INTO engerv_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“You must not have sexual relations with your granddaughter. It doesn’t matter whether she is the daughter of your son or the daughter of your daughter—they are all a part of you! ");
INSERT INTO engerv_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“If your father and his wife have a daughter, she is your sister. You must not have sexual relations with her. ");
INSERT INTO engerv_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“You must not have sexual relations with your father’s sister. She is your father’s close relative. ");
INSERT INTO engerv_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","You must not have sexual relations with your mother’s sister. She is your mother’s close relative. ");
INSERT INTO engerv_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","You must not have sexual relations with the wife of your father’s brother. You must not go near your uncle’s wife for sexual relations. She is your aunt. ");
INSERT INTO engerv_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“You must not have sexual relations with your daughter-in-law. She is your son’s wife, so you must not have sexual relations with her. ");
INSERT INTO engerv_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“You must not have sexual relations with your brother’s wife. That would be like having sexual relations with your brother. ");
INSERT INTO engerv_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“You must not have sexual relations with a mother and her daughter or her granddaughter. It doesn’t matter if this granddaughter is the daughter of this woman’s son or daughter. Her granddaughters are her close relatives. It is wrong to do this. ");
INSERT INTO engerv_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“While your wife is still living, you must not take her sister as another wife. This will make the sisters become enemies. You must not have sexual relations with your wife’s sister. ");
INSERT INTO engerv_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“You must not go near a woman to have sexual relations with her during her monthly time of bleeding. She is unclean during this time. ");
INSERT INTO engerv_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“You must not have sexual relations with your neighbor’s wife. This will only make you filthy. ");
INSERT INTO engerv_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“You must not give any of your children through the fire to Molech. If you do this, you will show that you don’t respect the name of your God. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Men, you must not have sexual relations with another man as with a woman. That is a terrible sin! ");
INSERT INTO engerv_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Men, you must not have sexual relations with any animal. This will make you filthy. And women, you must not have sexual relations with any animal. It is against nature! ");
INSERT INTO engerv_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Don’t make yourself unclean by doing any of these wrong things! I am throwing nations off their land and giving it to you because they did those terrible sins. ");
INSERT INTO engerv_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","They made the land filthy. Now the land is sick of those things, and it will vomit out the people who live there. ");
INSERT INTO engerv_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“So you must obey my laws and rules. You must not do any of these terrible sins. These rules are for the citizens of Israel and the people living among you. ");
INSERT INTO engerv_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Those who lived in the land before you have done all these terrible things. So the land became filthy. ");
INSERT INTO engerv_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","If you do these things, you will make the land filthy. And it will vomit you out as it vomited out the nations that were there before you. ");
INSERT INTO engerv_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Whoever does any of these terrible sins must be separated from their people! ");
INSERT INTO engerv_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Other people have done these terrible sins, but you must obey my laws. You must not do any of these terrible sins. Do not make yourself filthy with these terrible sins. I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Tell all the Israelites: I am the LORD your God. I am holy, so you must be holy. ");
INSERT INTO engerv_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Each of you must honor your mother and father and keep my special days of rest. I am the LORD your God! ");
INSERT INTO engerv_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Do not worship idols. Do not make statues of gods for yourselves. I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“When you offer a sacrifice of fellowship offerings to the LORD, you must offer it in the right way so that you will be accepted. ");
INSERT INTO engerv_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","You may eat it the same day you offer it and on the next day. But if any of that sacrifice is left on the third day, you must burn it in the fire. ");
INSERT INTO engerv_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","You must not eat any of that sacrifice on the third day. It will be unclean, and it will not be accepted. ");
INSERT INTO engerv_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","You will be guilty of sin if you do that because you did not respect the holy things that belong to the LORD. If you do that, you will be separated from your people. ");
INSERT INTO engerv_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“When you cut your crops at harvest time, don’t cut all the way to the corners of your fields. And if grain falls on the ground, you must not gather up that grain. ");
INSERT INTO engerv_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Don’t pick all the grapes in your vineyards or pick up the grapes that fall to the ground. You must leave those things for your poor people and for people traveling through your country. I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“You must not steal. You must not cheat people. You must not lie to each other. ");
INSERT INTO engerv_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","You must not use my name to make false promises. If you do that, you will show that you don’t respect the name of your God. I am the LORD! ");
INSERT INTO engerv_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“You must not cheat or rob your neighbor. You must not hold a hired worker’s salary overnight until morning. ");
INSERT INTO engerv_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“You must not curse anyone who is deaf. You must not do anything to make a blind person fall. But you must respect your God. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“You must be fair in judgment. You must not show special favor to the poor. And you must not show special favor to important people. You must be fair when you judge your neighbor. ");
INSERT INTO engerv_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","You must not go around spreading false stories against other people. Don’t do anything that would put your neighbor’s life in danger. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Don’t secretly hate any of your neighbors. But tell them openly what they have done wrong so that you will not be just as guilty of sin as they are. ");
INSERT INTO engerv_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Forget about the wrong things people do to you. Don’t try to get even. Love your neighbor as yourself. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“You must obey my laws. You must not let your animals mate with animals of a different kind. You must not sow your field with two kinds of seed. You must not wear clothing made from two kinds of material mixed together. ");
INSERT INTO engerv_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“It may happen that a man has sexual relations with a woman who is the slave of another man. But this slave woman has not been bought or given her freedom. If this happens, there must be punishment. But they will not be put to death because the woman was not free. ");
INSERT INTO engerv_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","The man must bring his guilt offering to the LORD at the entrance of the Meeting Tent. He must bring a ram for a guilt offering. ");
INSERT INTO engerv_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","The priest will make him pure by offering the ram as a guilt offering before the LORD. The offering is for the man’s sins, which will then be forgiven. ");
INSERT INTO engerv_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“In the future, when you enter your country, you will plant many kinds of trees for food. After planting a tree, you must wait three years before you can use any of the fruit from that tree. You must not use that fruit. ");
INSERT INTO engerv_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","In the fourth year, the fruit from that tree will belong to the LORD, a holy offering of praise to him. ");
INSERT INTO engerv_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Then, in the fifth year, you can eat the fruit from that tree. And the tree will produce more and more fruit for you. I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“You must not eat any meat with blood still in it. “You must not try to use different kinds of magic to tell the future. ");
INSERT INTO engerv_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“You must not round off the hair that grows on the side of your face. You must not cut your beard that grows on the side of your face. ");
INSERT INTO engerv_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","You must not cut your body as a way to remember the dead. You must not make any tattoo marks on yourselves. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Do not dishonor your daughters by making them become prostitutes. If you do that, your whole country will turn away from God and be filled with all kinds of sinful things. ");
INSERT INTO engerv_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“You must not work on my special days of rest. You must honor my holy place. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Do not go to mediums or wizards for advice—they will only make you unclean. I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Show honor to old people. Stand up when they come into the room. And show respect to your leaders. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Do not do bad things to foreigners living in your country. ");
INSERT INTO engerv_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","You must treat them the same as you treat your own citizens. Love them as you love yourselves. Remember, you were foreigners in Egypt. I am the LORD your God! ");
INSERT INTO engerv_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“You must be fair when you judge people, and you must be fair when you measure and weigh things. ");
INSERT INTO engerv_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Your baskets should be the right size. Your jars should hold the right amount of liquids. Your weights and balances should weigh things correctly. I am the LORD your God. I brought you out of the land of Egypt. ");
INSERT INTO engerv_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“You must remember all my laws and rules. And you must obey them. I am the LORD.” ");
INSERT INTO engerv_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“You must also tell the Israelites these things: Anyone living in Israel who gives one of their children to the false god Molech must be killed! It doesn’t matter if they are a citizen of Israel or a foreigner, you must throw stones at them and kill them. ");
INSERT INTO engerv_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","I will be against them and separate them from their people, because they gave their children to Molech. They showed that they did not respect my holy name. And they made my holy place unclean. ");
INSERT INTO engerv_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Maybe the common people will ignore them. Maybe they will not kill those who gave their children to Molech. ");
INSERT INTO engerv_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","But I will be against these people and their families. I will separate them from their people. I will separate anyone who is unfaithful to me and chases after Molech. ");
INSERT INTO engerv_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“I will be against anyone who goes to mediums and wizards for advice. Whoever does this is being unfaithful to me. So I will separate them from their people. ");
INSERT INTO engerv_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Be special. Make yourselves holy, because I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Remember and obey my laws. I am the LORD. And I have made you my special people. ");
INSERT INTO engerv_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Whoever curses their father or mother must be put to death. They cursed their father or mother, so they are responsible for their own death! ");
INSERT INTO engerv_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“If a man has sexual relations with his neighbor’s wife, both the man and the woman are guilty of adultery and must be put to death! ");
INSERT INTO engerv_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","If a man has sexual relations with his father’s wife, both the man and the woman must be put to death. They are responsible for their own death. It is as if that man had sexual relations with his father! ");
INSERT INTO engerv_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“If a man has sexual relations with his daughter-in-law, both of them must be put to death. They have committed a terrible sexual sin! They are responsible for their own death. ");
INSERT INTO engerv_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“If a man has sexual relations with another man as with a woman, they have committed a terrible sin. They must be put to death. They are responsible for their own death. ");
INSERT INTO engerv_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“It is a sexual sin if a man has sexual relations with a woman and her mother. The people must burn that man and the two women in fire! Don’t let this sexual sin happen among your people. ");
INSERT INTO engerv_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“If a man has sexual relations with an animal, both the man and the animal must be put to death. ");
INSERT INTO engerv_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","If a woman has sexual relations with an animal, you must kill the woman and the animal. They must be put to death. They are responsible for their own death. ");
INSERT INTO engerv_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“It is a shameful thing for a brother and his sister or half-sister to marry each other and have sexual relations with each other. They must be punished in public. They must be separated from their people. The man who has sexual relations with his sister must be punished for his sin. ");
INSERT INTO engerv_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“If a man has sexual relations with a woman during her monthly time of bleeding, both the woman and the man must be separated from their people. They sinned because they exposed her source of blood. ");
INSERT INTO engerv_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“You must not have sexual relations with your mother’s sister or your father’s sister. That is a sin of incest. You must be punished for your sins. ");
INSERT INTO engerv_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“A man must not have sexual relations with his uncle’s wife. It would be like having sexual relations with his uncle. That man and his uncle’s wife will be punished for their sins. They will die without children. ");
INSERT INTO engerv_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“It is wrong for a man to take his brother’s wife. It would be like having sexual relations with his brother! They will have no children. ");
INSERT INTO engerv_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“You must remember all my laws and rules. And you must obey them. I am leading you to your land. You will live in that country. If you obey my laws and rules, that land will not vomit you out. ");
INSERT INTO engerv_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","I am forcing other people to leave that country because they committed all those sins. I hate those sins! So don’t live the way those people lived. ");
INSERT INTO engerv_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","But I have told you that you will get their land. I will give their land to you. It will be your land! It is a land filled with many good things. I am the LORD your God. “I have treated you differently from other people. ");
INSERT INTO engerv_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","So you must treat clean animals differently from unclean animals. You must also treat clean birds differently from unclean birds. Don’t eat any of these unclean birds or animals or things that crawl on the ground. I have made these things unclean. ");
INSERT INTO engerv_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I have separated you from other nations to be my own special people. So you must be holy because I am the LORD, and I am holy. ");
INSERT INTO engerv_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“A man or a woman who is a medium or a wizard must be put to death. The people must kill them with stones. They are responsible for their own death.” ");
INSERT INTO engerv_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","The LORD said to Moses, “Tell these things to Aaron’s sons, the priests: A priest must not make himself unclean by touching a dead person. ");
INSERT INTO engerv_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","But if the dead person was one of his close relatives, he can touch the dead body. The priest can make himself unclean if the dead person is his mother or father, his son or daughter, his brother or ");
INSERT INTO engerv_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","his unmarried sister. (This sister is close to him because she has no husband. So the priest may make himself unclean for her if she dies.) ");
INSERT INTO engerv_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","But a priest must not make himself unclean if the dead person was only one of his slaves. ");
INSERT INTO engerv_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Priests must not shave their heads bald. They must not shave off the edges of their beards. They must not make any cuts in their bodies. ");
INSERT INTO engerv_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Priests must be holy for their God. They must show respect for God’s name. They offer the bread and special gifts to the LORD, so they must be holy. ");
INSERT INTO engerv_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“A priest serves God in a special way, so he must not marry a woman who has had sexual relations with any other man. He must not marry a prostitute or a divorced woman. ");
INSERT INTO engerv_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","A priest serves God in a special way. So you must treat him in a special way, because he carries holy things. He brings the holy bread to me, and I am holy. I am the LORD, and I make you holy. ");
INSERT INTO engerv_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“If a priest’s daughter becomes a prostitute, she ruins her reputation and brings shame to her father. She must be burned to death in the fire! ");
INSERT INTO engerv_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“The high priest was chosen from among his brothers. The anointing oil was poured on his head. In this way he was chosen for the special job of being high priest. He was chosen to wear the special clothes, so he must not do things to show his sadness in public. He must not let his hair grow wild. He must not tear his clothes. ");
INSERT INTO engerv_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","He must not make himself unclean by touching a dead body. He must not go near a dead body, even if it is his own father or mother. ");
INSERT INTO engerv_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","The high priest must not leave God’s holy place, because he might become unclean and then make God’s holy place unclean. The anointing oil was poured on the high priest’s head. This separated him from the rest of the people. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“The high priest must marry a woman who is a virgin. ");
INSERT INTO engerv_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","He must not marry a woman who has had sexual relations with any man. He must not marry a prostitute, a divorced woman, or a widow. The high priest must marry a virgin from his own people. ");
INSERT INTO engerv_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","In this way people will show respect for his children. I, the LORD, have separated the high priest for his special work.” ");
INSERT INTO engerv_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Tell Aaron: If any of your descendants have anything wrong with them, they must not carry the special bread to God. ");
INSERT INTO engerv_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Any man who has something wrong with him must not serve as priest and bring sacrifices to me. These men cannot serve as priests: blind men, crippled men, men with bad scars on their faces, men with arms or legs that are too long, ");
INSERT INTO engerv_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","men with broken feet or hands, ");
INSERT INTO engerv_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","men with bent backs, men who are dwarfs, men who are cross-eyed, men with rashes or bad skin diseases, and men with crushed testicles. ");
INSERT INTO engerv_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“If one of Aaron’s descendants has something wrong with him, he cannot approach the altar to bring gifts to the LORD. And he cannot carry the special bread to God. ");
INSERT INTO engerv_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","He is from the family of priests, so he can eat the holy bread. He can also eat the very holy bread. ");
INSERT INTO engerv_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","But he cannot go through the curtain into the Most Holy Place and he cannot go near the altar. This is because he has something wrong with him. He must not make my holy places unholy. I am the LORD, and I make these places holy.” ");
INSERT INTO engerv_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","So Moses told these things to Aaron, Aaron’s sons, and all the Israelites. ");
INSERT INTO engerv_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","The LORD God said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Tell Aaron and his sons: The gifts that the Israelites bring to me become holy. They belong to me, so you priests must show respect for these things. If you don’t, you will show that you don’t respect my holy name. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","If any one of your descendants touches these things, that person will become unclean. That person must be separated from me. The Israelites gave these things to me. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“If any of Aaron’s descendants has a serious skin disease or a discharge, he cannot eat the holy food until he becomes clean. This rule is for any priest who becomes unclean. That priest can become unclean from a dead body or from his own semen. ");
INSERT INTO engerv_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","He can also become unclean if he touches any unclean crawling animal. And he can become unclean if he touches an unclean person. It doesn’t matter what made that person unclean. ");
INSERT INTO engerv_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","If he touches any of these things, he will become unclean until evening. He must not eat any of the holy food. Even if he washes with water, he cannot eat the holy food. ");
INSERT INTO engerv_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","He will be clean only after the sun goes down. Then he can eat the holy food because it is his share. ");
INSERT INTO engerv_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“A priest must not eat any animal that died by itself or that was killed by wild animals. If he eats that animal, he will be unclean. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“The priests must be very careful when it comes time to serve me. They must be careful not to dishonor the holy things. If they are careful, they will not die. I, the LORD, have separated them from the rest of the people for this special job. ");
INSERT INTO engerv_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Only a priest’s family can eat the holy food. A visitor staying with the priest or a hired worker must not eat any of the holy food. ");
INSERT INTO engerv_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","But if the priest buys a person as a slave with his own money, that person may eat some of the holy things. Slaves who were born in the priest’s house may also eat some of the priest’s food. ");
INSERT INTO engerv_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","A priest’s daughter might marry a man who is not a priest. If she does that, she cannot eat any of the holy offerings. ");
INSERT INTO engerv_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","A priest’s daughter might become a widow, or she might be divorced. If she does not have any children to support her, and she goes back to her father’s house where she lived as a child, she can eat some of her father’s food. But only people from a priest’s family can eat this food. ");
INSERT INTO engerv_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Whoever eats some of the holy food by mistake must give the priest the price of that food and add another one-fifth of the price as a fine. ");
INSERT INTO engerv_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“The Israelites will bring offerings to the LORD. These offerings become holy, so the priests must not let them be used in a wrong way. ");
INSERT INTO engerv_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","They must not let the people eat these offerings. If they do, they are guilty of doing wrong, and they must pay for it. I am the LORD, the one who makes these offerings holy.” ");
INSERT INTO engerv_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","The LORD God said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Tell Aaron and his sons and all the Israelites: A citizen of Israel or a foreigner might want to bring an offering. It might be because of a promise that person made, or it might just be a special sacrifice that person wanted to give to the LORD as a burnt offering. ");
INSERT INTO engerv_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","These are gifts that the people bring because they really want to give a gift to God. If the gift is a bull, or a sheep, or a goat, the animal must be a male. And it must not have anything wrong with it. You must not accept any offering that has anything wrong with it. I will not accept that gift. ");
INSERT INTO engerv_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“You might bring a fellowship offering to the LORD. That fellowship offering might be payment for a special promise that you made. Or maybe it is a special gift that you wanted to give to the Lord. It can be a bull or a sheep, but it must be healthy. There must be nothing wrong with that animal. ");
INSERT INTO engerv_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","You must not offer to the LORD any animal that is blind, that has broken bones or is crippled, or that has a discharge or a serious skin disease. You must not offer sick animals as a gift to the LORD. You must not put anything like that on his altar. ");
INSERT INTO engerv_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“Sometimes a bull or lamb will have a leg that is too long, or a foot that did not grow right. If you want to give that animal as a special gift to the Lord, it will be accepted. But it will not be accepted as payment for a special promise that you made. ");
INSERT INTO engerv_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“If an animal has bruised, crushed, or torn testicles, you must not offer that animal to the LORD. You must not do this anywhere in your land. ");
INSERT INTO engerv_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“You must not take animals from foreigners as sacrifices to your God. The animals might have been hurt in some way. They might have something wrong with them, so they will not be accepted.” ");
INSERT INTO engerv_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“When a calf, or a sheep, or a goat is born, it must stay seven days with its mother. Then from the eighth day on, this animal will be accepted as a sacrifice offered as a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","But you must not kill the animal and its mother on the same day. This rule is the same for cattle and sheep. ");
INSERT INTO engerv_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“If you want to offer some special offering of thanks to the LORD, you are free to offer that gift. But you must do it in a way that pleases God. ");
INSERT INTO engerv_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","You must eat the whole animal that day. You must not leave any of the meat for the next morning. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Remember my commands, and obey them. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Show respect for my holy name. I must be very special to the Israelites. I, the LORD, have made you my special people. ");
INSERT INTO engerv_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","I brought you out of Egypt in order to be your God. I am the LORD.” ");
INSERT INTO engerv_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Tell the Israelites: You will announce the LORD’S chosen festivals as holy meetings. These are my special festivals. ");
INSERT INTO engerv_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Work for six days, but the seventh day, the Sabbath, will be a special day of rest, a holy meeting. You must not do any work. It is a day of rest to honor the LORD in all your homes. ");
INSERT INTO engerv_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“These are the LORD’S chosen festivals. You will announce the holy meetings at the times chosen for them. ");
INSERT INTO engerv_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","The LORD’S Passover is on the 14th day of the first month just before dark. ");
INSERT INTO engerv_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“The LORD’S Festival of Unleavened Bread is on the 15th day of the same month. You will eat unleavened bread for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","On the first day of this festival, you will have a special meeting. You must not do any work on that day. ");
INSERT INTO engerv_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","For seven days, you will bring sacrifices offered as gifts to the LORD. Then there will be another special meeting on the seventh day. You must not do any work on that day.” ");
INSERT INTO engerv_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Tell the Israelites: You will enter the land that I will give you and reap its harvest. At that time you must bring in the first sheaf of your harvest to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","The priest will lift the sheaf to show it was offered before the LORD. Then you will be accepted. The priest will present the sheaf on Sunday morning. ");
INSERT INTO engerv_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“On the day when you present the sheaf, you will offer a one-year-old male lamb. There must be nothing wrong with that lamb. That lamb will be a burnt offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","You must also offer a grain offering of 16 cups of fine flour mixed with olive oil. You must also offer 1 quart of wine. The smell of that offering will please the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","You must not eat any of the new grain, or fruit, or bread made from the new grain until you bring that offering to your God. This law will always continue through your generations, wherever you live. ");
INSERT INTO engerv_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“From that Sunday morning (the day you bring the sheaf to be presented to God), count seven weeks. ");
INSERT INTO engerv_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","On the Sunday following the seventh week (that is, 50 days later), you will bring a new grain offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","On that day bring two loaves of bread from your homes. That bread will be lifted up to show it was offered to God. Use yeast and 16 cups of flour to make those loaves of bread. That will be your gift to the LORD from your first harvest. ");
INSERT INTO engerv_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“With these grain offerings bring one bull, one ram, and seven one-year-old male lambs for burnt offerings to the LORD. There must be nothing wrong with these animals. Offer them together with the grain offerings and the drink offerings. The smell of these offerings made by fire will be pleasing to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","You will also offer one male goat for a sin offering and two one-year-old male lambs as a fellowship offering. ");
INSERT INTO engerv_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“The priest will lift them up with the bread from the first harvest to show they were offered with the two lambs before the LORD. They are holy to the LORD. They will belong to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","On that same day you will call a holy meeting. You must not do any work. This law continues forever in all your homes. ");
INSERT INTO engerv_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Also, when you harvest the crops on your land, don’t cut all the way to the corners of your field. Don’t pick up the grain that falls on the ground. Leave it for poor people and for foreigners traveling through your country. I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Again the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Tell the Israelites: On the first day of the seventh month, you must have a special day of rest. Blow the trumpet to remind the people that this is a holy meeting. ");
INSERT INTO engerv_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","You must not do any work. You must bring an offering as a gift to the LORD.” ");
INSERT INTO engerv_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“The Day of Atonement will be on the tenth day of the seventh month. There will be a holy meeting. You must not eat food, and you must bring an offering as a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","You must not do any work on that day, because it is the Day of Atonement. On that day the priests will go before the LORD and perform the ceremony that makes you pure. ");
INSERT INTO engerv_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“Anyone who refuses to fast on this day must be separated from their people. ");
INSERT INTO engerv_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","If anyone does any work on this day, I will destroy that person from among the people. ");
INSERT INTO engerv_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","You must not do any work at all. This is a law that continues forever for you, wherever you live. ");
INSERT INTO engerv_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","It will be a special day of rest for you. You must not eat food. You will start this special day of rest on the evening following the ninth day of the month. This special day of rest continues from that evening until the next evening.” ");
INSERT INTO engerv_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Again the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Tell the Israelites: On the 15th day of the seventh month is the Festival of Shelters. This festival to the LORD will continue for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","There will be a holy meeting on the first day. You must not do any work. ");
INSERT INTO engerv_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","You will bring offerings as gifts to the LORD for seven days. On the eighth day, you will have another holy meeting. You must not do any work. You will bring an offering as a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“These are the LORD’S special festivals. There will be holy meetings during these festivals. You will bring offerings as gifts to the LORD—burnt offerings, grain offerings, sacrifices, and drink offerings. You will bring these gifts at the right time. ");
INSERT INTO engerv_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","You will celebrate these festivals in addition to remembering the LORD’S Sabbath days. You will offer these gifts in addition to your other gifts and any offerings you give as payment for your special promises. They will be in addition to any special offerings you want to give to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“On the 15th day of the seventh month, when you have gathered in the crops of the land, you will celebrate the LORD’S festival for seven days. The first day will be a special day of rest, and then the eighth day will also be a special day of rest. ");
INSERT INTO engerv_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","On the first day you will take good fruit from fruit trees. And you will take branches from palm trees, poplar trees, and willow trees by the brook. You will celebrate before the LORD your God for seven days. ");
INSERT INTO engerv_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","You will celebrate this festival to the LORD for seven days each year. This law will continue forever. You will celebrate this festival in the seventh month. ");
INSERT INTO engerv_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","You will live in temporary shelters for seven days. All the people born in Israel will live in them. ");
INSERT INTO engerv_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Why? So all your descendants will know that I made the Israelites live in temporary shelters during the time I brought them out of Egypt. I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","So Moses told the Israelites about all the special meetings to honor the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Command the Israelites to bring to you pure oil from crushed olives. That oil is for the lamps that must burn without stopping. ");
INSERT INTO engerv_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaron will keep the light burning in the Meeting Tent before the LORD from evening until morning. This light will be outside the curtain that hangs in front of the Box that holds the Agreement. This law will continue forever. ");
INSERT INTO engerv_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron must always keep the lamps burning on the lampstand of pure gold before the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Take fine flour and bake twelve loaves with it. Use 16 cups of flour for each loaf. ");
INSERT INTO engerv_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Put them in two rows on the golden table before the LORD. Six loaves will be in each row. ");
INSERT INTO engerv_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Put pure frankincense on each row. This will help the LORD remember the gift. ");
INSERT INTO engerv_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Every Sabbath day Aaron will put the bread in order before the LORD. This must be done forever. This agreement with the Israelites will continue forever. ");
INSERT INTO engerv_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","That bread will belong to Aaron and his sons. They will eat the bread in a holy place, because that bread is one of the special gifts to the LORD. It is Aaron’s share forever.” ");
INSERT INTO engerv_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","There was a son of an Israelite woman and an Egyptian father. He was walking among the Israelites, and he started fighting in camp. ");
INSERT INTO engerv_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","The Israelite woman’s son began cursing, using the Lord’s name in a bad way, so the people brought him to Moses. (The name of the man’s mother was Shelomith, the daughter of Dibri, from the tribe of Dan.) ");
INSERT INTO engerv_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","The people held him as a prisoner and waited for the LORD’S command to be made clear to them. ");
INSERT INTO engerv_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Bring the man who cursed to a place outside the camp. Then bring together everyone who heard him curse. They will put their hands on his head. And then all the people must throw stones at him and kill him. ");
INSERT INTO engerv_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","You must tell the Israelites: Anyone who curses their God must be punished. ");
INSERT INTO engerv_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Anyone who speaks against the name of the LORD must be put to death. All the people must stone him. Any foreigner or anyone born in Israel who uses the Lord’s name in a bad way must be put to death. ");
INSERT INTO engerv_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“And whoever kills another person must be put to death. ");
INSERT INTO engerv_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Whoever kills an animal that belongs to another person must give another animal to take its place. ");
INSERT INTO engerv_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“And whoever causes an injury to their neighbor must be given the same kind of injury: ");
INSERT INTO engerv_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","a broken bone for a broken bone, an eye for an eye, and a tooth for a tooth. The same kind of injury a person gives another person must be given that person. ");
INSERT INTO engerv_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Whoever kills an animal must pay for the animal. But whoever kills another person must be put to death. ");
INSERT INTO engerv_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“The law will be the same for foreigners and for people from your own country. This is because I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Then Moses spoke to the Israelites, and they took the man who cursed to a place outside the camp. Then they killed him with stones. So the Israelites did just what the LORD had commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","The LORD spoke to Moses at Mount Sinai. He said, ");
INSERT INTO engerv_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Tell the Israelites: When you enter the land that I am giving to you, you must let the land have a special time of rest. This will be a special time of rest to honor the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","You will plant seed in your field for six years. You will trim your vineyards for six years and bring in its fruits. ");
INSERT INTO engerv_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","But during the seventh year, you will let the land rest. This will be a special time of rest to honor the LORD. You must not plant seed in your field or trim your vineyards. ");
INSERT INTO engerv_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","You must not cut the crops that grow by themselves after your harvest. You must not gather the grapes from your vines that are not trimmed. The land will have a year of rest. ");
INSERT INTO engerv_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“The land will have a year of rest, but you will still have enough food. There will be enough food for your men and women servants. There will be food for your hired workers and for the foreigners living in your country. ");
INSERT INTO engerv_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","And there will be enough food for your cattle and other animals to eat. ");
INSERT INTO engerv_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“You will also count seven groups of seven years. This will be 49 years. During that time there will be seven years of rest for the land. ");
INSERT INTO engerv_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","On the Day of Atonement, you must blow a ram’s horn. That will be on the tenth day of the seventh month. You must blow the ram’s horn through the whole country. ");
INSERT INTO engerv_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","You will make the 50th year a special year. You will announce freedom for everyone living in your country. This time will be called ‘Jubilee.’ Each of you will go back to your own property. And each of you will go back to your own family. ");
INSERT INTO engerv_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","The 50th year will be a special celebration for you. Don’t plant seeds, don’t harvest the crops that grow by themselves, and don’t gather grapes from the vines that are not trimmed. ");
INSERT INTO engerv_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","That year is Jubilee. It will be a holy time for you. You will eat the crops that come from the field. ");
INSERT INTO engerv_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","In the year of Jubilee, you will go back to your own property. ");
INSERT INTO engerv_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“Don’t cheat your neighbors when you sell your land to them. Don’t cheat one another when you buy or sell land. ");
INSERT INTO engerv_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","If you want to buy your neighbor’s land, count the number of years since the last Jubilee, and use that number to decide the right price. You are only buying the rights for harvesting crops until the next Jubilee. ");
INSERT INTO engerv_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","If there are many years before the next Jubilee, the price will be high. If the years are few, the price will be lower. So your neighbor is really only selling a number of crops to you. At the next Jubilee, the land will again belong to that family. ");
INSERT INTO engerv_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","You must not cheat each other. You must honor your God. I am the LORD your God. ");
INSERT INTO engerv_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Remember my laws and rules. Obey them and you will live safely in your country. ");
INSERT INTO engerv_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","And the land will produce good crops for you. Then you will have plenty of food, and you will live safely on the land. ");
INSERT INTO engerv_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“But maybe you will say, ‘If we don’t plant seeds or gather our crops, we will not have anything to eat during the seventh year.’ ");
INSERT INTO engerv_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","I will order my blessing to come to you during the sixth year. The land will continue growing crops for three years. ");
INSERT INTO engerv_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","When you plant in the eighth year, you will still be eating from the old crop. You will eat the old crop until the ninth year, when the crop you planted in the eighth year comes in. ");
INSERT INTO engerv_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“The land really belongs to me, so you cannot sell it permanently. You are only foreigners and travelers living on my land with me. ");
INSERT INTO engerv_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","People might sell their land, but the family will always get their land back. ");
INSERT INTO engerv_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","If someone in your country becomes very poor and must sell their property, a close relative must come and buy it back. ");
INSERT INTO engerv_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","If there is not a close relative to buy back the land, the person might get enough money to buy it back. ");
INSERT INTO engerv_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Then the years must be counted since the land was sold. That number must be used to decide how much to pay for the land. The person must then buy back the land, and it will be their property again. ");
INSERT INTO engerv_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","But if this first owner cannot find enough money to buy the land back, it will stay in the hands of the one who bought it until the year of Jubilee. Then during that special celebration, the land will go back to the first owner’s family. So the property will again belong to the right family. ");
INSERT INTO engerv_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Anyone who sells a home in a walled city still has the right to get it back until a full year after it was sold. Their right to get the house back will continue one year. ");
INSERT INTO engerv_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","But if the owner does not buy back the house before a full year is finished, the house that is in the walled city will belong to the one who bought it and to their descendants. The house will not go back to the first owner at the time of Jubilee. ");
INSERT INTO engerv_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Towns without walls around them will be treated like open fields. So houses built in these small towns will go back to the first owners at the time of Jubilee. ");
INSERT INTO engerv_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“But about the cities of the Levites: The Levites can buy back at any time their houses in the cities that belong to them. ");
INSERT INTO engerv_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","If someone buys a house from a Levite, that house in the Levites’ city will again belong to the Levites at the time of Jubilee. This is because houses in Levite cities belong to those from the tribe of Levi. The Israelites gave these cities to the Levites. ");
INSERT INTO engerv_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Also, the fields and pastures around the Levite cities cannot be sold. They belong to the Levites forever. ");
INSERT INTO engerv_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“If anyone from your own country becomes too poor to support themselves, you must let them live with you like a visitor. ");
INSERT INTO engerv_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Don’t charge them any interest on money you might loan to them. Respect your God and let those from your own country live with you. ");
INSERT INTO engerv_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Don’t charge them interest on any money you lend them. And don’t try to make a profit from the food you sell them. ");
INSERT INTO engerv_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","I am the LORD your God. I brought you out of the land of Egypt to give the land of Canaan to you and to become your God. ");
INSERT INTO engerv_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“If anyone from your own country becomes so poor that they must sell themselves to you, don’t make them work like slaves. ");
INSERT INTO engerv_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","They will be like hired workers and visitors with you until the year of Jubilee. ");
INSERT INTO engerv_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Then they can leave you, take their children, and go back to their family. They can go back to the property of their ancestors, ");
INSERT INTO engerv_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","because they are my servants. I brought them out of slavery in Egypt. They must not become slaves again. ");
INSERT INTO engerv_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","You must not be a cruel master to them. You must respect your God. ");
INSERT INTO engerv_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“About your men and women slaves: You may get men and women slaves from the other nations around you. ");
INSERT INTO engerv_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Also, you may get children as slaves if they come from the families of the foreigners living in your land. These child slaves will belong to you. ");
INSERT INTO engerv_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","You may even pass these foreign slaves on to your children after you die so that they will belong to them. They will be your slaves forever. You may make slaves of these foreigners. But you must not be a cruel master over your own brothers, the Israelites. ");
INSERT INTO engerv_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Maybe a foreigner or visitor among you becomes rich. Or maybe someone from your own country becomes so poor that they sell themselves as slaves to a foreigner living among you or to a member of a foreigner’s family. ");
INSERT INTO engerv_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","These people have the right to be bought back and become free. Someone from their own country can buy them back. ");
INSERT INTO engerv_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Or their uncle, their cousin, or one of their close relatives from their family can buy him back. Or if they get enough money, they can pay the money themselves and become free again. ");
INSERT INTO engerv_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“You must count the years from the time they sold themselves to the foreigner up to the next year of Jubilee. Use that number to decide the price, because really the person only ‘hired’ them for a few years. ");
INSERT INTO engerv_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","If there are still many years before the year of Jubilee, the one sold must give back a large part of the price. It all depends on the number of years. ");
INSERT INTO engerv_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","If only a few years are left until the year of Jubilee, the one who was sold must pay a small part of the original price. ");
INSERT INTO engerv_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","But that person will live like a hired worker with the foreigner every year. Don’t let the foreigner be a cruel master over that person. ");
INSERT INTO engerv_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Those who sold themselves will become free, even if no one buys them back. At the year of Jubilee, they and their children will become free. ");
INSERT INTO engerv_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","This is because the Israelites are my servants. They are the servants who I brought out of slavery in Egypt. I am the LORD your God! ");
INSERT INTO engerv_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Don’t make idols for yourselves. Don’t set up statues or memorial stones in your land to bow down to, because I am the LORD your God! ");
INSERT INTO engerv_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Remember my special days of rest and honor my holy place. I am the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Remember my laws and commands, and obey them. ");
INSERT INTO engerv_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","If you do these things, I will give you rains at the time they should come. The land will grow crops and the trees of the field will grow their fruit. ");
INSERT INTO engerv_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Your threshing will continue until it is time to gather grapes. And your grape gathering will continue until it is time to plant. Then you will have plenty to eat. And you will live safely in your land. ");
INSERT INTO engerv_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","I will give peace to your country. You will lie down in peace. No one will come to make you afraid. I will keep harmful animals out of your country. And armies will not come through your country. ");
INSERT INTO engerv_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“You will chase your enemies and defeat them. You will kill them with your swords. ");
INSERT INTO engerv_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Five of you will chase 100 men, and 100 of you will chase 10,000 men. You will defeat your enemies and kill them with your sword. ");
INSERT INTO engerv_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Then I will turn to you. I will let you have many children. I will keep my agreement with you. ");
INSERT INTO engerv_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","You will have enough crops to last for more than a year. You will harvest the new crops. But then you will have to throw out the old crops to make room for the new crops. ");
INSERT INTO engerv_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Also, I will place my Holy Tent among you. I will not turn away from you. ");
INSERT INTO engerv_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","I will walk with you and be your God. And you will be my people. ");
INSERT INTO engerv_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","I am the LORD your God. You were slaves in Egypt, but I brought you out of Egypt. You were bent low from the heavy weights you carried as slaves, but I broke the poles that were on your shoulders. I let you walk proudly again. ");
INSERT INTO engerv_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“But if you don’t obey me and all my commands, bad things will happen to you. ");
INSERT INTO engerv_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","If you refuse to obey my laws and commands, you have broken my agreement. ");
INSERT INTO engerv_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","If you do that, I will cause terrible things to happen to you. I will cause you to have disease and fever. They will destroy your eyes and take away your life. You will not have success when you plant your seed. And your enemies will eat your crops. ");
INSERT INTO engerv_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","I will be against you, so your enemies will defeat you. These enemies will hate you and rule over you. You will run away even when no one is chasing you. ");
INSERT INTO engerv_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“After these things, if you still don’t obey me, I will punish you seven times more for your sins. ");
INSERT INTO engerv_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","And I will also destroy the great cities that make you proud. The skies will not give rain, and the earth will not produce crops. ");
INSERT INTO engerv_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","You will work hard, but it will not help. Your land will not give any crops, and your trees will not grow their fruit. ");
INSERT INTO engerv_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“If you still turn against me and refuse to obey me, I will beat you seven times harder! The more you sin, the more you will be punished. ");
INSERT INTO engerv_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","I will send wild animals against you. They will take your children away from you. They will destroy your animals. They will kill many of your people. The roads will all be empty. ");
INSERT INTO engerv_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“If you don’t learn your lesson after all this, and if you still turn against me, ");
INSERT INTO engerv_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","then I will also turn against you. I—yes, I myself—will punish you seven times for your sins. ");
INSERT INTO engerv_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","You will have broken my agreement, so I will punish you. I will bring armies against you. You will go into your cities for safety, but I will cause diseases to spread among you. And your enemies will defeat you. ");
INSERT INTO engerv_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","I will give you a share of the grain left in that city. But there will be very little food to eat. Ten women will be able to cook all their bread in one oven. They will measure each piece of bread. You will eat, but you will still be hungry. ");
INSERT INTO engerv_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“If you still refuse to listen to me, and if you still turn against me, ");
INSERT INTO engerv_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","then I will really show my anger! I—yes, I myself—will punish you seven times for your sins. ");
INSERT INTO engerv_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","You will become so hungry that you will eat the bodies of your sons and daughters. ");
INSERT INTO engerv_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","I will destroy your high places. I will cut down your incense altars. I will put your dead bodies on the dead bodies of your idols. You will be disgusting to me. ");
INSERT INTO engerv_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","I will destroy your cities. I will make your holy places empty. I will stop smelling your offerings. ");
INSERT INTO engerv_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","I will make your land empty. And your enemies who come to live there will be shocked at it. ");
INSERT INTO engerv_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","I will scatter you among the nations. I will pull out my sword and destroy you. Your land will become empty, and your cities will be destroyed. ");
INSERT INTO engerv_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“You will be taken to your enemy’s country. Your country will be empty. So your land will finally get its rest. The land will enjoy its time of rest. ");
INSERT INTO engerv_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","During the time that the land is empty, it will get the time of rest that you did not give it while you lived there. ");
INSERT INTO engerv_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","The survivors will lose their courage in the land of their enemies. They will be afraid of everything. They will run around like a leaf blown by the wind. They will run as if someone is chasing them with a sword. They will fall even when no one is chasing them. ");
INSERT INTO engerv_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","They will run as if someone is chasing them with a sword. They will fall over each other—even when no one is chasing them. “You will not be strong enough to stand up against your enemies. ");
INSERT INTO engerv_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","You will be lost in other nations. You will disappear in the land of your enemies. ");
INSERT INTO engerv_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","So the survivors will rot away in their sin in their enemies’ countries. They will rot away in their sins just as their ancestors did. ");
INSERT INTO engerv_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“But maybe the people will confess their sins. And maybe they will confess the sins of their ancestors. Maybe they will admit that they turned against me. Maybe they will admit that they sinned against me. ");
INSERT INTO engerv_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Maybe they will admit that I turned against them and brought them into the land of their enemies. These people will be like strangers to me. But maybe they will become humble and accept the punishment for their sin. ");
INSERT INTO engerv_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","If they do, I will remember my agreement with Jacob. I will remember my agreement with Isaac. I will remember my agreement with Abraham, and I will remember the land. ");
INSERT INTO engerv_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“The land will be empty. The land will enjoy its time of rest. Then the survivors will accept the punishment for their sins. They will learn that they were punished because they hated my laws and refused to obey my rules. ");
INSERT INTO engerv_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","They have sinned. But if they come to me for help, I will not turn away from them. I will listen to them, even if they are in the land of their enemies. I will not completely destroy them. I will not break my agreement with them, because I am the LORD their God. ");
INSERT INTO engerv_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","For them, I will remember the agreement with their ancestors. I brought their ancestors out of the land of Egypt so that I could become their God. The other nations saw these things. I am the LORD.” ");
INSERT INTO engerv_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","These are the laws, rules, and teachings that the LORD gave to the Israelites. These laws are the agreement between the Lord and the Israelites. The Lord gave these laws to Moses at Mount Sinai. ");
INSERT INTO engerv_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Tell the Israelites: You might promise to give someone to the LORD as a servant. The priest must set a price for that person. ");
INSERT INTO engerv_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","The price for a man from 20 to 60 years old is 50 shekels of silver. (You must use the official measure for the silver.) ");
INSERT INTO engerv_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","The price for a woman who is 20 to 60 years old is 30 shekels. ");
INSERT INTO engerv_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","The price for a man from 5 to 20 years old is 20 shekels. For a woman the price is 10 shekels. ");
INSERT INTO engerv_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","The price for a boy from one month to five years old is 5 shekels. For a girl, the price is 3 shekels. ");
INSERT INTO engerv_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","The price for a man who is 60 years old or older is 15 shekels. The price for a woman is 10 shekels. ");
INSERT INTO engerv_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“If anyone is too poor to pay the price, bring that person to the priest. The priest will decide how much money the person can afford to pay. ");
INSERT INTO engerv_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“You might promise to give an animal to the Lord. If it is a clean animal—one that is acceptable as an offering to the LORD—then the animal you bring will become holy. ");
INSERT INTO engerv_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","You must not put any other animal in its place. Don’t try to trade a good animal for a bad one or a bad animal for a good one. If you try to change animals, both animals will become holy—they will both belong to the Lord. ");
INSERT INTO engerv_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“The animal you promised might be one that is not acceptable as an offering to the LORD. If you promised one of these unclean animals, you must bring it to the priest. ");
INSERT INTO engerv_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","The priest will decide a price for that animal. It doesn’t make any difference if the animal is good or bad. If the priest decides on a price, that is the price for the animal. ");
INSERT INTO engerv_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","If you want to buy back the animal, then you must add one-fifth to the price. ");
INSERT INTO engerv_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“If you dedicate your house as holy to the LORD, the priest must decide its price. It doesn’t make any difference if the house is good or bad. If the priest decides on a price, that is the price for the house. ");
INSERT INTO engerv_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","But if you want to get the house back, you must add one-fifth to the price. Then you will get the house back. ");
INSERT INTO engerv_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“You might dedicate a field to the LORD. The value of this field will depend on how much seed is needed to plant it. It will be 50 shekels of silver for each homer of barley seed. ");
INSERT INTO engerv_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","If you give your field to God during the year of Jubilee, then its value will be whatever the priest decides. ");
INSERT INTO engerv_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","But if you give your field after the Jubilee, the priest must decide its exact price. He must count the number of years to the next year of Jubilee and use that number to decide the price. ");
INSERT INTO engerv_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","If you want to buy the field back, you must add one-fifth to that price. Then you will get the field back. ");
INSERT INTO engerv_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","If you don’t buy the field back and the land is sold to someone else, you cannot get the land back. ");
INSERT INTO engerv_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","If you don’t buy the land back by the year of Jubilee, the field will remain holy to the LORD—it will belong to the priest forever. It will be treated like any other thing that was given completely to the Lord. ");
INSERT INTO engerv_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“If you dedicate a field to the LORD that you had bought, and it is not a part of your family’s property, ");
INSERT INTO engerv_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","then the priest must count the years to the year of Jubilee and decide the price for the land. Then that land will belong to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","At the year of Jubilee, the land will go to the family that originally owned the land. ");
INSERT INTO engerv_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“You must use the official measure in paying these prices. The shekel by that measure weighs 20 gerahs. ");
INSERT INTO engerv_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“You can give cattle and sheep as special gifts to the LORD. But if the animal is the firstborn, it already belongs to the LORD. So you cannot give these animals as special gifts. ");
INSERT INTO engerv_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","If the firstborn animal is an unclean animal, you must buy back that animal. The priest will decide the price of the animal, and you must add one-fifth to that price. If you don’t buy that animal back, the priest will sell the animal for whatever price he decides. ");
INSERT INTO engerv_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“There is a special kind of gift that people give to the LORD. It belongs only to him, and it cannot be bought back or sold. This gift belongs to the LORD. This type of gift includes people, animals, and fields from the family property. ");
INSERT INTO engerv_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","If this gift is a person, that person cannot be bought back. That person must be killed. ");
INSERT INTO engerv_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“A tenth of all crops belongs to the LORD. This means the crops from fields and the fruit from trees—a tenth belongs to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","So if you want to get back your tenth, you must add one-fifth to its price and then buy it back. ");
INSERT INTO engerv_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“The priests will take every tenth animal from a person’s cattle or sheep. Every tenth animal will belong to the LORD. ");
INSERT INTO engerv_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","The owner should not worry if the chosen animal is good or bad or change the animal for another animal. If this happens, both animals will belong to the LORD. That animal cannot be bought back.” ");
INSERT INTO engerv_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","These are the commands that the LORD gave Moses at Mount Sinai for the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","The LORD spoke to Moses in the Meeting Tent. This was in the desert of Sinai. It was on the first day of the second month of the second year after the Israelites left Egypt. He said to Moses: ");
INSERT INTO engerv_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Count all the Israelites. List the name of each man with his family and his family group. ");
INSERT INTO engerv_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","You and Aaron must count the men of Israel who are 20 years old or older. (These are all the men who are able to serve in the army of Israel.) List them by their divisions. ");
INSERT INTO engerv_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","One man from each tribe will help you. This man will be the leader of his tribe. ");
INSERT INTO engerv_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","These are the names of the men who will stand with you and help you: from the tribe of Reuben—Elizur son of Shedeur; ");
INSERT INTO engerv_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","from the tribe of Simeon—Shelumiel son of Zurishaddai; ");
INSERT INTO engerv_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","from the tribe of Judah—Nahshon son of Amminadab; ");
INSERT INTO engerv_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","from the tribe of Issachar—Nethanel son of Zuar; ");
INSERT INTO engerv_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","from the tribe of Zebulun—Eliab son of Helon; ");
INSERT INTO engerv_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","from the descendants of Joseph: from the tribe of Ephraim—Elishama son of Ammihud; from the tribe of Manasseh—Gamaliel son of Pedahzur; ");
INSERT INTO engerv_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","from the tribe of Benjamin—Abidan son of Gideoni; ");
INSERT INTO engerv_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","from the tribe of Dan—Ahiezer son of Ammishaddai; ");
INSERT INTO engerv_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","from the tribe of Asher—Pagiel son of Ocran; ");
INSERT INTO engerv_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","from the tribe of Gad—Eliasaph son of Deuel; ");
INSERT INTO engerv_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","from the tribe of Naphtali—Ahira son of Enan.” ");
INSERT INTO engerv_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","All these men were the leaders of their families. The people also chose them to be leaders of their tribes. ");
INSERT INTO engerv_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moses and Aaron took the men who had been chosen to be leaders ");
INSERT INTO engerv_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","and called all the Israelites together on the first day of the second month. Then the people were listed by their families and their family groups. All the men who were 20 years old or older were listed. ");
INSERT INTO engerv_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Moses did exactly what the LORD commanded—he counted the people while they were in the desert of Sinai. ");
INSERT INTO engerv_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","The tribe of Reuben was counted. (Reuben was the firstborn son of Israel.) The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","The total number of men counted from the tribe of Reuben was 46,500. ");
INSERT INTO engerv_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","The tribe of Simeon was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","The total number of men counted from the tribe of Simeon was 59,300. ");
INSERT INTO engerv_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","The tribe of Gad was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","The total number of men counted from the tribe of Gad was 45,650. ");
INSERT INTO engerv_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","The tribe of Judah was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","The total number of men counted from the tribe of Judah was 74,600. ");
INSERT INTO engerv_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","The tribe of Issachar was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","The total number of men counted from the tribe of Issachar was 54,400. ");
INSERT INTO engerv_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","The tribe of Zebulun was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","The total number of men counted from the tribe of Zebulun was 57,400. ");
INSERT INTO engerv_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","The tribe of Ephraim was counted. (Ephraim was Joseph’s son.) The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","The total number of men counted from the tribe of Ephraim was 40,500. ");
INSERT INTO engerv_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","The tribe of Manasseh was counted. (Manasseh was also Joseph’s son.) The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","The total number of men counted from the tribe of Manasseh was 32,200. ");
INSERT INTO engerv_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","The tribe of Benjamin was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","The total number of men counted from the tribe of Benjamin was 35,400. ");
INSERT INTO engerv_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","The tribe of Dan was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","The total number of men counted from the tribe of Dan was 62,700. ");
INSERT INTO engerv_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","The tribe of Asher was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","The total number of men counted from the tribe of Asher was 41,500. ");
INSERT INTO engerv_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","The tribe of Naphtali was counted. The names of all the men who were 20 years old or older and able to serve in the army were listed. They were listed by name with their families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","The total number of men counted from the tribe of Naphtali was 53,400. ");
INSERT INTO engerv_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Moses, Aaron, and the twelve leaders of Israel counted these men. (There was one leader from each tribe.) ");
INSERT INTO engerv_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","They counted every man who was 20 years old or older and able to serve in the army. Each man was listed with his family. ");
INSERT INTO engerv_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","The total number of men counted was 603,550 men. ");
INSERT INTO engerv_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","The families from the tribe of Levi were not counted with the other Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","The LORD had told Moses: ");
INSERT INTO engerv_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Don’t count the men from the tribe of Levi or include them with the other Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Tell the Levites that they are responsible for the Tent of the Agreement. They must take care of that tent and everything that is with it. They must carry the Holy Tent and everything in it. They must make their camp around it and take care of it. ");
INSERT INTO engerv_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Whenever the Holy Tent is moved, the Levites must do it. Whenever the Holy Tent is set up, the Levites must do it. They are the men who will take care of the Holy Tent. Anyone else who tries to take care of the tent must be killed. ");
INSERT INTO engerv_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","The Israelites will make their camps in separate divisions. Everyone must camp near their family flag. ");
INSERT INTO engerv_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","The Levites will set up their tents so that they surround the Tent of the Agreement. They will serve as guards and keep the people away from the Tent. This will protect the Israelites from the Lord’s anger.” ");
INSERT INTO engerv_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","The LORD had given these commandments to Moses. So the Israelites did everything he commanded. ");
INSERT INTO engerv_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","The LORD said to Moses and Aaron: ");
INSERT INTO engerv_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“The Israelites should make their camps around the Meeting Tent. Each division will have its own special flag, and everyone will camp near their group’s flag. ");
INSERT INTO engerv_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“The flag of the camp of Judah will be on the east side, where the sun rises. The people of Judah will camp near its flag. The leader of the people of Judah is Nahshon son of Amminadab. ");
INSERT INTO engerv_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","There are 74,600 men in his division. ");
INSERT INTO engerv_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“The tribe of Issachar will camp next to the tribe of Judah. The leader of the tribe of Issachar is Nethanel son of Zuar. ");
INSERT INTO engerv_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","There are 54,400 men in his division. ");
INSERT INTO engerv_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“The tribe of Zebulun will also camp next to the tribe of Judah. The leader of the tribe of Zebulun is Eliab son of Helon. ");
INSERT INTO engerv_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","There are 57,400 men in his division. ");
INSERT INTO engerv_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“The total number of men in Judah’s camp is 186,400. All these men are divided into their different tribes. Judah will be the first group to move when the people travel from one place to another. ");
INSERT INTO engerv_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“The flag of Reuben’s camp will be south of the Holy Tent. Each group will camp near its flag. The leader of the tribe of Reuben is Elizur son of Shedeur. ");
INSERT INTO engerv_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","There are 46,500 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“The tribe of Simeon will camp next to the tribe of Reuben. The leader of the tribe of Simeon is Shelumiel son of Zurishaddai. ");
INSERT INTO engerv_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","There are 59,300 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“The tribe of Gad will also camp next to the tribe of Reuben. The leader of the tribe of Gad is Eliasaph son of Deuel. ");
INSERT INTO engerv_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","There are 45,650 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“The total number of men in all the divisions of Reuben’s camp is 151,450. His camp will be the second group to move when the people travel from place to place. ");
INSERT INTO engerv_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“When the people travel, Levi’s camp will move next. The Meeting Tent will be with them between the other camps. The people will make their camps in the same order that they move. ");
INSERT INTO engerv_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“The flag of the camp of Ephraim will be on the west side. The division of Ephraim will camp there. The leader of the tribe of Ephraim is Elishama son of Ammihud. ");
INSERT INTO engerv_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","There are 40,500 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“The tribe of Manasseh will camp next to Ephraim’s family. The leader of the tribe of Manasseh is Gamaliel son of Pedahzur. ");
INSERT INTO engerv_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","There are 32,200 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“The tribe of Benjamin will also camp next to Ephraim’s family. The leader of the tribe of Benjamin is Abidan son of Gideoni. ");
INSERT INTO engerv_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","There are 35,400 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“The total number of men in Ephraim’s camp is 108,100. They will be the third family to move when the people travel from one place to another. ");
INSERT INTO engerv_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“The flag of Dan’s camp will be on the north side. The tribes of Dan will camp there. The leader of the tribe of Dan is Ahiezer son of Ammishaddai. ");
INSERT INTO engerv_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","There are 62,700 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“The people from the tribe of Asher will camp next to the tribe of Dan. The leader of the tribe of Asher is Pagiel son of Ocran. ");
INSERT INTO engerv_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","There are 41,500 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“The tribe of Naphtali will also camp next to the tribe of Dan. The leader of the tribe of Naphtali is Ahira son of Enan. ");
INSERT INTO engerv_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","There are 53,400 men in this division. ");
INSERT INTO engerv_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“There are 157,600 men in Dan’s camp. They will be the last to move when the people travel from place to place. Each group will have its own flag.” ");
INSERT INTO engerv_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","So these were the Israelites. They were counted by families. The total number of Israelite men in the camps, counted by divisions, is 603,550. ");
INSERT INTO engerv_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Moses obeyed the LORD and did not count the Levites with the other Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","So the Israelites did everything the LORD told Moses. Each group camped under its own flag. And everyone stayed with their own family and family group. ");
INSERT INTO engerv_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","This is the family history of Aaron and Moses at the time the LORD talked to Moses on Mount Sinai. ");
INSERT INTO engerv_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron had four sons. Nadab was the firstborn son. Then there were Abihu, Eleazar, and Ithamar. ");
INSERT INTO engerv_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","These sons were the chosen priests. They were given the special work of serving the LORD as priests. ");
INSERT INTO engerv_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","But Nadab and Abihu died while serving the LORD. They used fire that the LORD did not allow when they made an offering to him. So Nadab and Abihu died there, in the desert of Sinai. They had no sons, so Eleazar and Ithamar took their place and served the Lord as priests. This happened while their father Aaron was still alive. ");
INSERT INTO engerv_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bring all the men from the tribe of Levi. Bring them to Aaron the priest. These men will be his helpers. ");
INSERT INTO engerv_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","The Levites will help him when he serves at the Meeting Tent. And they will help all the Israelites when they come to worship at the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","The Israelites should protect everything in the Meeting Tent; it is their duty. But the Levites will serve the Israelites by caring for these things. This will be their way of serving at the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“Give the Levites to Aaron and his sons. The Levites were chosen from all the Israelites to help Aaron and his sons. ");
INSERT INTO engerv_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“Appoint Aaron and his sons to be priests. They must do their duty and serve as priests. Anyone else who tries to come near the holy things must be killed.” ");
INSERT INTO engerv_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","The LORD also said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“I destroyed all the firstborn in Egypt. At that time I chose all the firstborn from every family in Israel to be mine in a special way. That included all the firstborn men and animals. But now I am choosing the Levites to take their place. Now they will be my special servants. I, the LORD, give this command!” ");
INSERT INTO engerv_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","The LORD again said to Moses in the desert of Sinai, ");
INSERT INTO engerv_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Count all the families and family groups in the tribe of Levi. Count every man or boy who is one month old or older.” ");
INSERT INTO engerv_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","So Moses obeyed the LORD. He counted them all. ");
INSERT INTO engerv_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi had three sons. Their names were Gershon, Kohath, and Merari. ");
INSERT INTO engerv_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Each son was the leader of several family groups. The Gershon family groups were Libni and Shimei. ");
INSERT INTO engerv_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","The Kohath family groups were Amram, Izhar, Hebron, and Uzziel. ");
INSERT INTO engerv_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","The Merari family groups were Mahli and Mushi. These are the families that belonged to Levi’s family group. ");
INSERT INTO engerv_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","The families of Libni and Shimei belonged to the family of Gershon. They were the Gershonite family groups. ");
INSERT INTO engerv_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","There were 7500 men and boys over one month old in these two family groups. ");
INSERT INTO engerv_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","The Gershonite family groups were told to camp in the west. They made their camp behind the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","The leader of the family groups of the Gershonites was Eliasaph son of Lael. ");
INSERT INTO engerv_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","In the Meeting Tent, the Gershonites had the job of taking care of the Holy Tent, the outer tent, and the covering. They also took care of the curtain at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","They cared for the curtain in the courtyard. And they cared for the curtain at the entrance of the courtyard. This courtyard was around the Holy Tent and the altar. And they cared for the ropes and for everything that was used with the curtains. ");
INSERT INTO engerv_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","The families of Amram, Izhar, Hebron, and Uzziel belonged to the family of Kohath. They were the Kohathite family groups. ");
INSERT INTO engerv_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","In this family group there were 8300 men and boys a month old or over. The Kohathites were given the job of taking care of the things in the Holy Place. ");
INSERT INTO engerv_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","The Kohathite family groups were given the area to the south of the Holy Tent. This was the area where they camped. ");
INSERT INTO engerv_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","The leader of the Kohathite family groups was Elizaphan son of Uzziel. ");
INSERT INTO engerv_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Their job was to take care of the Holy Box, the table, the lampstand, the altars, and the dishes of the Holy Place. They also cared for the curtain and all the things that were used with the curtain. ");
INSERT INTO engerv_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","The leader over the leaders of the Levites was Eleazar son of Aaron the priest. Eleazar was in charge of everyone who took care of the holy things. ");
INSERT INTO engerv_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","The family groups of Mahli and Mushi belonged to the Merari family. There were 6200 men and boys who were one month old or older in the Mahli family group. ");
INSERT INTO engerv_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","The leader of the Merari family group was Zuriel son of Abihail. This family group was given the area to the north of the Holy Tent. This is the area where they camped. ");
INSERT INTO engerv_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","The people from the Merari family were given the job of caring for the frames of the Holy Tent. They cared for all the braces, posts, bases, and everything that was used with the frames of the Holy Tent. ");
INSERT INTO engerv_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","They also cared for all the posts in the courtyard around the Holy Tent. This included all the bases, tent pegs, and ropes. ");
INSERT INTO engerv_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moses, Aaron, and his sons camped east of the Holy Tent, in front of the Meeting Tent. They were given the work of caring for the Holy Place. They did this for all the Israelites. Anyone else who came near the Holy Place was to be killed. ");
INSERT INTO engerv_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","The LORD commanded Moses and Aaron to count all the men and boys one month old or older in Levi’s family group. The total number was 22,000. ");
INSERT INTO engerv_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","The LORD said to Moses, “Count all the firstborn men and boys in Israel who are at least one month old. Write their names on a list. ");
INSERT INTO engerv_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","I am the LORD. I will take the Levites instead of all the firstborn men and boys of Israel. I will also take the animals from the Levites instead of taking all the firstborn animals from the other people in Israel.” ");
INSERT INTO engerv_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","So Moses did what the LORD commanded. He counted all the firstborn children of the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","He listed all the firstborn men and boys who were one month old or older. There were 22,273 names on that list. ");
INSERT INTO engerv_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","The LORD also said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“I, the LORD, give this command: ‘Take the Levites instead of all the firstborn men from the other families of Israel. And I will take the animals of the Levites instead of the animals of the other people. The Levites are mine. ");
INSERT INTO engerv_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","There are 22,000 Levites, but there are 22,273 firstborn sons from the other families. This leaves 273 more firstborn sons than Levites. ");
INSERT INTO engerv_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Using the official measure, collect five shekels of silver for each of the 273 people. (The shekel by the official measure weighs 20 gerahs.) Collect that silver from the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Give the silver to Aaron and his sons as payment for the 273 Israelites.’” ");
INSERT INTO engerv_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","There were not enough Levites to take the place of all the men from the other family groups, so Moses gathered the money for them. ");
INSERT INTO engerv_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Moses collected the silver from the firstborn men of the Israelites. He collected 1365 shekels of silver, using the official measure. ");
INSERT INTO engerv_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moses obeyed the LORD’S command and gave the silver to Aaron and his sons. He did it just as the LORD had told him. ");
INSERT INTO engerv_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Count the men in the families of the Kohath family group. (The Kohath family group is a part of Levi’s family group.) ");
INSERT INTO engerv_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Count all the men from 30 to 50 years old who come to serve. These men will work in the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Their job is to take care of the most holy things in the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“When the Israelites travel to a new place, Aaron and his sons must go into the Meeting Tent and take down the curtain and cover the Box of the Agreement with it. ");
INSERT INTO engerv_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Then they must cover all of this with covering made from fine leather. Then they must spread the solid blue cloth over the leather and put the poles in the rings on the Holy Box. ");
INSERT INTO engerv_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Then they must spread a blue cloth over the holy table. Then they must put the plates, spoons, bowls, and the jars for drink offerings on the table. Put the special bread on the table. ");
INSERT INTO engerv_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Then you must put a red cloth over all these things, cover everything with fine leather, and put the poles in the rings of the table. ");
INSERT INTO engerv_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Then they must cover the lampstand and its lamps with a blue cloth. They must also cover all the things used to keep the lamps burning and all the jars of oil that are used in the lamps. ");
INSERT INTO engerv_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Then wrap everything in fine leather. Then they must put all these things on poles used for carrying them. ");
INSERT INTO engerv_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“They must spread a blue cloth over the golden altar. They must cover that with fine leather. Then they must put the poles for carrying it in the rings on the altar. ");
INSERT INTO engerv_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Then they must gather together all the special things that are used for worship in the Holy Place. They must gather them together and wrap them in a blue cloth. Then they must cover that with fine leather. They must put these things on a frame for carrying them. ");
INSERT INTO engerv_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“They must clean the ashes out of the bronze altar and spread a purple cloth over it. ");
INSERT INTO engerv_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Then they must gather together all the things that are used for worship at the altar. These are the firepans, forks, shovels, and the bowls. They must put these things on the bronze altar. Then they must spread a covering of fine leather over the altar and put the poles for carrying it in the rings on the altar. ");
INSERT INTO engerv_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Aaron and his sons must finish covering all the holy things in the Holy Place. Then the men from the Kohath family can go in and begin carrying these things. In this way they will not touch the holy things and die. ");
INSERT INTO engerv_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazar son of Aaron the priest will be responsible for the Holy Tent. He will be responsible for everything in it, including the holy things. He will be responsible for the oil for the lamp, the sweet-smelling incense, the daily offering, and the anointing oil.” ");
INSERT INTO engerv_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Be careful! Don’t let these Kohathite men be destroyed. ");
INSERT INTO engerv_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","You must do these things so that the Kohathite men can go near the most holy things and not die. Aaron and his sons must go in and show each Kohathite man what to do and what to carry. ");
INSERT INTO engerv_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","If you don’t do this, the Kohathite men might go in and look at the holy things. If they look at these things, even for a moment, they must die.” ");
INSERT INTO engerv_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Count all the people of the Gershon family. List them by family and family group. ");
INSERT INTO engerv_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Count all the men who are from 30 to 50 years old who come to serve. These men will have the job of caring for the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“This is what the Gershonite family must do and the things they must carry: ");
INSERT INTO engerv_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","They must carry the curtains of the Holy Tent, the Meeting Tent, its covering, and the covering made from fine leather. They must also carry the curtain at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","They must carry the curtains of the courtyard that are around the Holy Tent and the altar. And they must carry the curtain for the entrance of the courtyard. They must also carry all the ropes and all the things that are used with the curtains. The Gershonite men will be responsible for anything that needs to be done with these things. ");
INSERT INTO engerv_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron and his sons will watch all the work that is done. Everything the Gershonites carry and the other work they do will be watched by Aaron and his sons. You must tell them what they are responsible for carrying. ");
INSERT INTO engerv_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","This is the work that the men of the Gershonite family group must do for the Meeting Tent. Ithamar son of Aaron the priest will be responsible for their work.” ");
INSERT INTO engerv_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Count all the men in the families and family groups in the Merari family group. ");
INSERT INTO engerv_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Count all the men who are from 30 to 50 years old and come to serve. These men will do a special work for the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","When you travel, it is their job to carry the frames of the Meeting Tent. They must carry the braces, the posts, and the bases. ");
INSERT INTO engerv_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","They must also carry the posts that are around the courtyard. They must carry the bases, the tent pegs, the ropes, and everything that is used for the poles around the courtyard. List the names and tell each man exactly what he must carry. ");
INSERT INTO engerv_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","This is what the people from the Merari family will do to serve in the work for the Meeting Tent. Ithamar son of Aaron the priest will be responsible for their work.” ");
INSERT INTO engerv_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moses, Aaron, and the leaders of the Israelites counted the Kohathites. They counted them by families and family groups. ");
INSERT INTO engerv_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","They counted all the men from 30 to 50 years old who were able to serve. These men were given special work to do for the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","There were 2750 men in the Kohath family group who were qualified to do this work. ");
INSERT INTO engerv_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","So these men from the Kohath family group were given their special work to do for the Meeting Tent. Moses and Aaron did this the way the LORD had told Moses to do. ");
INSERT INTO engerv_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Also, the Gershonite family group was counted. ");
INSERT INTO engerv_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","All the men from 30 to 50 years old who qualified to serve were counted. These men were given their special work to do for the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","There were 2630 men in the families of the Gershon family group who were qualified. ");
INSERT INTO engerv_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","So these men from the Gershon family group were given their special work to do for the Meeting Tent. Moses and Aaron did this the way the LORD had told Moses to do. ");
INSERT INTO engerv_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Also, the men in the families and family groups of the Merari family were counted. ");
INSERT INTO engerv_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","All the men from 30 to 50 years old who qualified to serve were counted. These men were given their special work to do for the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","There were 3200 men in the families of the Merari family group who were qualified. ");
INSERT INTO engerv_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","So these men from the Merari family group were given their special work. Moses and Aaron did this the way the LORD told Moses to do. ");
INSERT INTO engerv_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","So Moses, Aaron, and the leaders of the Israelites counted all the people in Levi’s family group. They had counted each family and each family group. ");
INSERT INTO engerv_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","All the men between the ages of 30 and 50 who qualified to serve were counted. These men were given a special work to do for the Meeting Tent. They did the work of carrying the Meeting Tent when they traveled. ");
INSERT INTO engerv_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","The total number was 8580. ");
INSERT INTO engerv_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Each man was counted just as the LORD commanded Moses. Each man was given his own work and told what he must carry just as the LORD had said. ");
INSERT INTO engerv_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Tell the people to send away from the camp anyone who is unclean, that is, anyone who has a serious skin disease or discharge and anyone who has touched a dead body. ");
INSERT INTO engerv_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Whether they are a man or a woman, send them away so that the camp where I am living among you will not be made unclean.” ");
INSERT INTO engerv_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","So the Israelites obeyed God’s command. They sent those people outside the camp. They did what the LORD had told Moses. ");
INSERT INTO engerv_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Tell this to the Israelites: You might do something wrong to another person. When you do that, you are really sinning against God. So you are guilty of doing wrong. ");
INSERT INTO engerv_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","You must confess that sin. Then you must fully pay for that wrong thing you did. You must add one-fifth to the payment and give it all to the person you had done wrong to. ");
INSERT INTO engerv_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","But maybe the person is dead and does not have any close relatives to accept the payment. In that case, you will give the payment to the LORD. That is, you will give the full payment to the priest. The priest must sacrifice the ram that makes people pure. This ram will be sacrificed to cover over your sins, but the priest will keep the rest of the payment. ");
INSERT INTO engerv_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“If any of you Israelites gives a special gift to God, the priest who accepts that gift can keep it. It is his. ");
INSERT INTO engerv_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","You don’t have to give these special gifts, but if you do, the gifts belong to the priest.” ");
INSERT INTO engerv_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Tell the Israelites this: A man’s wife might be unfaithful to him. ");
INSERT INTO engerv_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","She might have sexual relations with another man and hide this from her husband. And there might not be anyone to tell him that his wife committed this sin. Her husband might never know about the wrong thing she did, and she might not tell her husband about her sin. ");
INSERT INTO engerv_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","But the husband might begin to think that his wife sinned against him, whether she has or not. He might become jealous. He might begin to believe that she is not pure and true to him. ");
INSERT INTO engerv_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","If that happens, he must take his wife to the priest. The husband must also take an offering of 8 cups of barley flour. He must not pour oil or incense on the barley flour. This barley flour is a grain offering to the LORD that is given because the husband is jealous. This offering will show that he thinks his wife has been unfaithful to him. ");
INSERT INTO engerv_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“The priest will take the woman before the LORD and make her stand there. ");
INSERT INTO engerv_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Then he will take some special water and put it in a clay jar. He will put some dirt from the floor of the Holy Tent into the water. ");
INSERT INTO engerv_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","He will force the woman to stand before the LORD. Then he will loosen her hair and put the grain offering in her hand. This is the barley flour that her husband gave because he was jealous. At the same time, he will hold the clay jar of special water. This is the special water that can bring trouble to the woman. ");
INSERT INTO engerv_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“Then the priest will make the woman promise to tell the truth and say to her: ‘If you have not slept with another man, and if you have not sinned against your husband while you were married to him, then this water that causes trouble will not hurt you. ");
INSERT INTO engerv_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","But if you have sinned against your husband—if you had sexual relations with a man who is not your husband—then you are not pure. ");
INSERT INTO engerv_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","If that is true, you will have much trouble when you drink this special water. You will not be able to have any children. And if you are pregnant now, your baby will die. And the LORD will cause your people to speak evil of you and curse you.’ “Then the priest must tell the woman to make an oath. She must agree for the LORD to cause these things to happen to her if she lies. ");
INSERT INTO engerv_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","The priest must say, ‘You must drink this water that causes trouble. If you have sinned, you will not be able to have children. Any baby you have will die before it is born.’ And the woman should say, ‘I agree to do as you say.’ ");
INSERT INTO engerv_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“The priest should write these warnings on a scroll. Then he should wash the words off into the water. ");
INSERT INTO engerv_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Then the woman must drink the water that brings trouble. This water will enter her and, if she is guilty, it will cause her much suffering. ");
INSERT INTO engerv_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“Then the priest will take the grain offering from her (the offering for jealousy) and raise it before the LORD. Then he will carry it to the altar. ");
INSERT INTO engerv_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","The priest will fill his hands with some of the grain and put it on the altar and let it burn there. After that he will tell the woman to drink the water. ");
INSERT INTO engerv_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","If the woman has sinned against her husband, the water will bring her trouble. The water will go into her body and cause her much suffering. Any baby that is in her will die before it is born, and she will never be able to have children. All the people will turn against her. ");
INSERT INTO engerv_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","But if the woman has not sinned against her husband and she is pure, the priest will say that she is not guilty. Then she will be normal and able to have children. ");
INSERT INTO engerv_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“So this is the law about jealousy. This is what you should do when a woman sins against her husband while she is married to him. ");
INSERT INTO engerv_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Or if the man becomes jealous and thinks his wife has sinned against him, this is what the man should do. The priest must tell her to stand before the LORD. Then the priest will do all these things. This is the law. ");
INSERT INTO engerv_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","The husband will not be guilty of doing anything wrong, but the woman will suffer if she has sinned.” ");
INSERT INTO engerv_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Tell the Israelites this: If there are people, men or women, who want to make a vow dedicating themselves to the LORD as Nazirites for a time, this is what they must do: ");
INSERT INTO engerv_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","They must stay away from wine or other strong drink. They must not drink vinegar that is made from wine or from other strong drink. They must not drink grape juice or eat grapes or raisins. ");
INSERT INTO engerv_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","During that special time of dedication, they must not eat anything that comes from grapes. They must not even eat the seeds or the skins from grapes. ");
INSERT INTO engerv_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“The whole time of their Nazirite vow they must not cut their hair. They must be holy until this time of special dedication to the LORD is ended. They must let their hair grow long. ");
INSERT INTO engerv_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“If you have taken the Nazirite vow, you must not go near someone who is dying during that special time of dedication. You have given yourself fully to the LORD, ");
INSERT INTO engerv_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","so you must not let yourself become unclean like this—even for your own father or mother, brother or sister when they die. This is because you have the hair that you dedicated to God on your head! ");
INSERT INTO engerv_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","It is holy because you have given yourself fully to the LORD for the full time of that dedication. ");
INSERT INTO engerv_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","So if you are with someone when they suddenly die, you will be unclean and you will have to shave the hair from your head. You must do that on the seventh day of your purification ceremony when you are made clean. ");
INSERT INTO engerv_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Then on the eighth day, you must bring two doves or two young pigeons and give them to the priest at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Then the priest will offer one bird as a sin offering and the other one as a burnt offering. The burnt offering will be a payment for the sin of touching a dead body during your special time of dedication. Then you must again promise to give the hair on your head as a gift to God. ");
INSERT INTO engerv_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","This means you must again give yourself to the LORD for another time of dedication. You must bring a one-year-old male lamb to offer as a guilt offering. You must start over from the beginning with a new time of dedication because you touched a dead body during your first time of dedication. ");
INSERT INTO engerv_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“After their time of dedication is ended, Nazirites must go to the entrance of the Meeting Tent ");
INSERT INTO engerv_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","and give their offering to the LORD. Their offering must be: a one-year-old male lamb that has nothing wrong with it for a burnt offering; a one-year-old female lamb that has nothing wrong with it for a sin offering; one ram that has nothing wrong with it for a fellowship offering; ");
INSERT INTO engerv_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","a basket of bread made without yeast—bread made with fine flour mixed with oil and wafers with oil spread on top; and the grain offerings and drink offerings that are a part of these gifts. ");
INSERT INTO engerv_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“The priest will give these things to the LORD, and then the priest will make the sin offering and the burnt offering. ");
INSERT INTO engerv_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","He will give the basket of bread without yeast to the LORD. Then he will kill the ram as a fellowship offering to the Lord. He will give it to the Lord with the grain offering and the drink offering. ");
INSERT INTO engerv_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“The Nazirites must go to the entrance of the Meeting Tent. There they must shave off their hair that they grew as a dedication to the Lord. That hair will be put in the fire that is burning under the sacrifice of the fellowship offering. ");
INSERT INTO engerv_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“After the Nazirites have cut off their hair, the priest will give them a boiled shoulder from the ram and a large and a small cake from the basket. Both of these cakes are made without yeast. ");
INSERT INTO engerv_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Then the priest will lift these things up to show that they were presented before the LORD. These things are holy and belong to the priest. Also, the ram’s breast and thigh that were lifted up and presented belong to the priest. After that the Nazirites can drink wine. ");
INSERT INTO engerv_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“These are the rules for those who decide to make the Nazirite vow. They must give all these gifts to the LORD. But they might be able to give much more. If they promise to do more, they must keep their promise. But they must give at least all the things listed in these rules for the Nazirite vow.” ");
INSERT INTO engerv_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tell Aaron and his sons that when they bless the Israelites, this is what they should say: ");
INSERT INTO engerv_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘May the LORD bless you and keep you. ");
INSERT INTO engerv_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","May the LORD smile down on you and show you his kindness. ");
INSERT INTO engerv_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","May the LORD answer your prayers and give you peace.’ ");
INSERT INTO engerv_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","In this way Aaron and his sons will use my name to give a blessing to the Israelites, and I will bless them.” ");
INSERT INTO engerv_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moses finished setting up the Holy Tent. On that day he dedicated it to God. Moses anointed the Tent and everything in it. He also anointed the altar and all the things used with it. ");
INSERT INTO engerv_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Then the leaders of Israel gave offerings to God. These men were the heads of their families and leaders of their tribes. These were the same men who were in charge of counting the people. ");
INSERT INTO engerv_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","These leaders brought gifts and gave them to the LORD in front of the Holy Tent. They brought six covered wagons and twelve oxen for pulling the wagons. Each leader gave an ox and joined with another leader to give a wagon. ");
INSERT INTO engerv_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Accept these gifts from the leaders. These gifts can be used in the work of the Meeting Tent. Give them to the Levites to help them do their work.” ");
INSERT INTO engerv_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","So Moses accepted the wagons and the oxen and gave them to the Levites. ");
INSERT INTO engerv_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","He gave two wagons and four oxen to the men in Gershon’s group. They needed the wagons and the oxen for their work. ");
INSERT INTO engerv_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Then Moses gave four wagons and eight oxen to the men in Merari’s group. They needed the wagons and oxen for their work. Ithamar son of Aaron the priest was responsible for the work of all these men. ");
INSERT INTO engerv_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Moses did not give any oxen or wagons to the men in Kohath’s group, because their job was to carry the holy things on their shoulders. ");
INSERT INTO engerv_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","When Moses anointed the altar, the leaders brought offerings for its dedication. They gave their offerings to the Lord at the altar. ");
INSERT INTO engerv_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","The LORD told Moses, “Each day one leader must bring his gift for the dedication of the altar.” ");
INSERT INTO engerv_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Each of the twelve leaders brought these gifts: Each leader brought one silver plate that weighed about 3 1/4 pounds. Each leader brought one silver bowl that weighed about 1 3/4 pounds. Both of these gifts were weighed by the official measure. The bowl and the plate were each filled with fine flour mixed with oil. This was to be used as a grain offering. Each leader also brought a large gold spoon that weighed about 4 ounces. The spoon was filled with incense. Each leader also brought 1 young bull, 1 ram, and 1 male lamb a year old. These animals were for a burnt offering. Each leader also brought 1 male goat to be used as a sin offering. Each leader brought 2 cattle, 5 rams, 5 male goats, and 5 male lambs a year old. All of them were sacrificed for a fellowship offering. On the first day, the leader of the tribe of Judah, Nahshon son of Amminadab brought his gifts. On the second day, the leader of the tribe of Issachar, Nethanel son of Zuar brought his gifts. On the third day, the leader of the tribe of Zebulun, Eliab son of Helon brought his gifts. On the fourth day, the leader of the tribe of Reuben, Elizur son of Shedeur brought his gifts. On the fifth day, the leader of the tribe of Simeon, Shelumiel son of Zurishaddai brought his gifts. On the sixth day, the leader of the tribe of Gad, Eliasaph son of Deuel brought his gifts. On the seventh day, the leader of the tribe of Ephraim, Elishama son of Ammihud brought his gifts. On the eighth day, the leader of the tribe of Manasseh, Gamaliel son of Pedahzur brought his gifts. On the ninth day, the leader of the tribe of Benjamin, Abidan son of Gideoni brought his gifts. On the tenth day, the leader of the tribe of Dan, Ahiezer son of Ammishaddai brought his gifts. On the eleventh day, the leader of the tribe of Asher, Pagiel son of Ocran brought his gifts. On the twelfth day, the leader of the tribe of Naphtali, Ahira son of Enan brought his gifts. ");
INSERT INTO engerv_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","So all these things were the gifts from the leaders of the Israelites. They brought them during the time that Moses dedicated the altar by anointing it. They brought 12 silver plates, 12 silver bowls, and 12 gold spoons. ");
INSERT INTO engerv_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Each silver plate weighed about 3 1/4 pounds. And each bowl weighed about 1 3/4 pounds. The silver plates and the silver bowls together all weighed about 60 pounds, using the official measure. ");
INSERT INTO engerv_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","The 12 gold spoons filled with incense weighed 4 ounces each, using the official measure. The 12 gold spoons all together weighed about 3 pounds. ");
INSERT INTO engerv_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","The total number of animals for the burnt offering was 12 bulls, 12 rams, and 12 one-year-old male lambs. There were also the grain offerings that must be given with these offerings. And there were 12 male goats to be used for a sin offering. ");
INSERT INTO engerv_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","The leaders also gave animals to be killed and used as a fellowship offering. The total number of these animals was 24 bulls, 60 rams, 60 male goats, and 60 one-year-old male lambs. In this way they dedicated the altar after Moses anointed it. ");
INSERT INTO engerv_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","When Moses went into the Meeting Tent to speak to the Lord, he heard the Lord’s voice speaking to him. The voice was coming from the area between the two Cherub angels on the mercy-cover on top of the Box of the Agreement. In this way the Lord spoke to Moses. ");
INSERT INTO engerv_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Tell Aaron to put the seven lamps in the place I showed you. These lamps will light the area in front of the lampstand.” ");
INSERT INTO engerv_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron did this. He put the lamps in the right place so that they lighted the area in front of the lampstand. He obeyed the command that the LORD gave Moses. ");
INSERT INTO engerv_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","This is how the lampstand was made: It was made from hammered gold, all the way from the gold base at the bottom to the gold flowers at the top. It looked just like the pattern that the LORD had shown to Moses. ");
INSERT INTO engerv_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Separate the Levites from the other Israelites. Make these Levites clean. ");
INSERT INTO engerv_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","This is what you should do to make them clean: Sprinkle the special water from the sin offering on them. This water will make them clean. Then they must shave their bodies and wash their clothes. This will make their bodies clean. ");
INSERT INTO engerv_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“They must take a young bull and the grain offering that must be offered with it. This grain offering will be flour mixed with oil. Then take another young bull for a sin offering. ");
INSERT INTO engerv_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Bring the Levites to the area in front of the Meeting Tent. Then bring all the Israelites together at that place. ");
INSERT INTO engerv_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Bring the Levites before the LORD. The Israelites will put their hands on them. ");
INSERT INTO engerv_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron will give the Levites to the LORD as an offering from the Israelites. Then the Levites will be ready to do their special work for the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Tell the Levites to put their hands on the heads of the bulls. One bull will be a sin offering and the other bull will be used as a burnt offering to the LORD. These offerings will make the Levites pure. ");
INSERT INTO engerv_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tell the Levites to stand in front of Aaron and his sons. Then give the Levites to the LORD. They will be like an offering. ");
INSERT INTO engerv_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","This will make the Levites holy. They will be different from the other Israelites. The Levites will belong to me. ");
INSERT INTO engerv_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“So make the Levites pure and give them to the Lord as a special offering. After you do this, they can come and do their work at the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","The Israelites will give me the Levites. They will belong to me. In the past I told every Israelite family to give me their firstborn son. But now I am taking the Levites in place of these firstborn sons from the other families in Israel. ");
INSERT INTO engerv_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Every firstborn in Israel—man or animal—is mine, because I killed all the firstborn children and animals in Egypt. And I chose to take the firstborn sons to belong to me. ");
INSERT INTO engerv_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","But now I will take the Levites in their place. I will take the Levites in place of all the firstborn sons from the other families in Israel. ");
INSERT INTO engerv_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","I chose the Levites from among all the Israelites. And I give them as gifts to Aaron and his sons. I want them to do the work at the Meeting Tent. They will serve for all the Israelites. They will help make the sacrifices that make the Israelites pure. Then no great sickness or trouble will come to the Israelites when they come near the holy place.” ");
INSERT INTO engerv_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","So Moses, Aaron, and all the Israelites obeyed the LORD. They did with the Levites everything that the Lord commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","The Levites washed themselves and their clothes. Then Aaron gave them to the LORD as special offerings. Aaron gave the offerings that covered their sins and made them pure. ");
INSERT INTO engerv_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","After that the Levites came to the Meeting Tent to do their work. Aaron and his sons watched them. They were responsible for the work of the Levites. Aaron and his sons did what the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“This is a special command for the Levites: Every Levite man who is 25 years old or older must come and share in the work at the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","But when a man is 50 years old, he will retire from this hard work. ");
INSERT INTO engerv_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Men who are at least 50 years old will be on duty to help their brothers, but they will not do the work themselves. That is what you must do for the Levites so that they can do their duty.” ");
INSERT INTO engerv_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","The LORD spoke to Moses in the desert of Sinai. This was during the first month of the second year after the Israelites came out of Egypt. He said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Tell the Israelites to celebrate Passover at the chosen time. ");
INSERT INTO engerv_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","They must eat the Passover meal just before dark on the 14th day of this month. They must do this at the chosen time, and they must follow all the rules about Passover.” ");
INSERT INTO engerv_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","So Moses told the Israelites to celebrate Passover. ");
INSERT INTO engerv_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","The people did this in the desert of Sinai just before dark on the 14th day of the first month. The Israelites did everything just as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","But some of the people could not celebrate Passover that day. They were unclean because they had touched a dead body. So they went to Moses and Aaron that day ");
INSERT INTO engerv_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","and said to Moses, “We touched a dead body and became unclean. But why must we be kept from offering our gifts to the LORD at the chosen time with the rest of the Israelites?” ");
INSERT INTO engerv_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moses said to them, “I will ask the LORD what he says about this.” ");
INSERT INTO engerv_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Tell the Israelites this: It might happen sometimes that you or your descendants cannot celebrate the LORD’S Passover at the right time. Someone might be unclean because they touched a dead body, or they might be away on a trip. They will still be able to celebrate Passover at another time. ");
INSERT INTO engerv_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","They must celebrate Passover just before dark on the 14th day of the second month. At that time they must eat the lamb, the bread made without yeast, and the bitter herbs. ");
INSERT INTO engerv_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","They must not leave any of that food until the next morning. And they must not break any of the bones of the lamb. They must follow all the rules about Passover. ");
INSERT INTO engerv_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","But anyone who is able must celebrate Passover at the right time. If they are clean and they are not away on a trip, there is no excuse for them not to do it. If they don’t celebrate Passover at the right time, they must be separated from their people. They are guilty and must be punished, because they did not give the LORD his gift at the right time. ");
INSERT INTO engerv_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“A foreigner living among you might want to share in the LORD’S Passover with you. This is allowed, but that person must follow all the rules about Passover. The same rules are for everyone.” ");
INSERT INTO engerv_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","On the day the Holy Tent, the Tent of the Agreement, was set up, a cloud covered it. At night the cloud over the Holy Tent looked like fire. ");
INSERT INTO engerv_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","The cloud stayed over the Holy Tent all the time. And at night the cloud looked like fire. ");
INSERT INTO engerv_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","When the cloud moved from its place over the Holy Tent, the Israelites followed it. When the cloud stopped, that is the place where the Israelites camped. ");
INSERT INTO engerv_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","This was the way the LORD showed the Israelites when to move and when to stop and set up camp. While the cloud stayed over the Holy Tent, the people continued to camp in that same place. ");
INSERT INTO engerv_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Sometimes the cloud would stay over the Holy Tent for a long time. The Israelites obeyed the LORD and did not move. ");
INSERT INTO engerv_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Sometimes the cloud was over the Holy Tent for only a few days. So the people obeyed the LORD’S command—they followed the cloud when it moved. ");
INSERT INTO engerv_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Sometimes the cloud stayed only during the night—the next morning the cloud moved. So the people gathered their things and followed it. If the cloud moved, during the day or during the night, they followed it. ");
INSERT INTO engerv_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","If the cloud stayed over the Holy Tent for two days, a month, or a year, the people stayed at that place. They did not leave until the cloud moved. When the cloud rose from its place and moved, they also moved. ");
INSERT INTO engerv_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","So the people obeyed the LORD’S commands. They camped when the LORD told them to, and they moved when he told them to. They watched carefully and obeyed the LORD’S commands to Moses. ");
INSERT INTO engerv_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Make two trumpets. Use silver and hammer it to make the trumpets. These trumpets will be for calling the people together and for telling them when it is time to move the camp. ");
INSERT INTO engerv_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","If you blow long blasts on both trumpets, all the people must meet together at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","But if you blow long blasts on only one trumpet, only the leaders will come to meet with you. (These are the leaders of the twelve tribes of Israel.) ");
INSERT INTO engerv_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“Short blasts on the trumpets will be the way to tell the people to move the camp. The first time you blow a short blast on the trumpets, the tribes camping on the east side of the Meeting Tent must begin to move. ");
INSERT INTO engerv_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","The second time you blow a short blast on the trumpets, the tribes camping on the south side of the Meeting Tent will begin to move. ");
INSERT INTO engerv_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","But if you want to gather the people together for a special meeting, blow the trumpets in a different way—blow a long steady blast on the trumpets. ");
INSERT INTO engerv_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Only Aaron’s sons, the priests, should blow the trumpets. This is a law for you that will continue forever, for generations to come. ");
INSERT INTO engerv_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“If you are fighting an enemy in your own land, blow loudly on the trumpets before you go to fight them. The LORD your God will hear you, and he will save you from your enemies. ");
INSERT INTO engerv_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Also blow these trumpets for your special meetings, New Moon celebrations, and all your happy times together. Blow the trumpets when you give your burnt offerings and fellowship offerings. This will be a special way for your God to remember you. I command you to do this; I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","On the 20th day of the second month of the second year after the Israelites left Egypt, the cloud rose from above the Tent of the Agreement. ");
INSERT INTO engerv_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","So the Israelites began their journey. They left the desert of Sinai and traveled until the cloud stopped in the desert of Paran. ");
INSERT INTO engerv_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","This was the first time the people moved their camp. They moved it the way the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","The three divisions from Judah’s camp went first. They traveled under their flag. The first group was the tribe of Judah. Nahshon son of Amminadab was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Next came the tribe of Issachar. Nethanel son of Zuar was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","And then came the tribe of Zebulun. Eliab son of Helon was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Then the Holy Tent was taken down. And the men from the Gershon and the Merari families carried the Holy Tent. So the people from these families were next in line. ");
INSERT INTO engerv_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Then came the three divisions from Reuben’s camp. They traveled under their flag. The first group was the tribe of Reuben. Elizur son of Shedeur was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Next came the tribe of Simeon. Shelumiel son of Zurishaddai was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","And then came the tribe of Gad. Eliasaph son of Deuel was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Then came the Kohath family. They carried the holy things from inside the Holy Tent. These people came at this time so that the other people could set up the Holy Tent and make it ready at the new camp before these people arrived. ");
INSERT INTO engerv_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Next came the three groups from Ephraim’s camp. They traveled under their flag. The first group was the tribe of Ephraim. Elishama son of Ammihud was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Next came the tribe of Manasseh. Gamaliel son of Pedahzur was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Then came the tribe of Benjamin. Abidan son of Gideoni was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","The last three tribes in the line were the rear guard for all the other tribes. These were the groups from Dan’s camp. They traveled under their flag. The first group was the tribe of Dan. Ahiezer son of Ammishaddai was their commander. ");
INSERT INTO engerv_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Next came the tribe of Asher. Pagiel son of Ocran was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Then came the tribe of Naphtali. Ahira son of Enan was the commander of that group. ");
INSERT INTO engerv_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","That was the way the Israelites marched when they moved from place to place. ");
INSERT INTO engerv_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Hobab was the son of Reuel, the Midianite. (Reuel was Moses’ father-in-law.) Moses said to Hobab, “We are traveling to the land that the LORD promised to give to us. Come with us and we will be good to you. The LORD has promised good things to the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","But Hobab answered, “No, I will not go with you. I will go back to my homeland and to my own people.” ");
INSERT INTO engerv_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Then Moses said, “Please don’t leave us. You know more about the desert than we do. You can be our guide. ");
INSERT INTO engerv_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","If you come with us, we will share with you all the good things that the LORD gives us.” ");
INSERT INTO engerv_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","So they began traveling from the mountain of the LORD. The priests took the Box of the LORD’S Agreement and walked in front of the people. They carried the Holy Box for three days, looking for a place to camp. ");
INSERT INTO engerv_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","The LORD’S cloud was over them every day. And when they left their camp every morning, the cloud was there to lead them. ");
INSERT INTO engerv_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","When the people lifted the Holy Box to move the camp, Moses always said, “Get up, LORD! May your enemies be scattered. May your enemies run away from you.” ");
INSERT INTO engerv_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","And when the Holy Box was put in its place, Moses always said, “Come back, LORD, to the millions of Israelites.” ");
INSERT INTO engerv_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","The people started complaining about their troubles. The LORD heard their complaints. He heard these things and became angry. Fire from the LORD burned among the people. The fire burned some of the areas at the edge of the camp. ");
INSERT INTO engerv_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","So the people cried to Moses for help. He prayed to the LORD and the fire stopped burning. ");
INSERT INTO engerv_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","So that place was called Taberah. The people gave the place that name because the LORD caused a fire to burn in their camp. ");
INSERT INTO engerv_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","The foreigners who had joined the Israelites began wanting other things to eat. Soon all the Israelites began complaining again. The people said, “We want to eat meat! ");
INSERT INTO engerv_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","We remember the fish we ate in Egypt. That fish cost us nothing. We also had good vegetables like cucumbers, melons, chives, onions, and garlic. ");
INSERT INTO engerv_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","But now we have lost our strength. We never eat anything—only this manna!” ");
INSERT INTO engerv_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(The manna was like small coriander seeds, and it looked like sap from a tree. ");
INSERT INTO engerv_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","The people gathered the manna. Then they used rocks to crush it and cooked it in a pot. Or they ground it into flour and made thin cakes with it. The cakes tasted like sweet cakes cooked with olive oil. ");
INSERT INTO engerv_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","The manna fell on the ground each night when the ground became wet with dew.) ");
INSERT INTO engerv_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moses heard the people complaining. People from every family were sitting by their tents and complaining. The LORD became very angry, and this made Moses very upset. ");
INSERT INTO engerv_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","He asked the LORD, “Why did you bring this trouble on me? I am your servant. What did I do wrong? What did I do to upset you? Why did you give me responsibility over all these people? ");
INSERT INTO engerv_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","You know that I am not the father of all these people. You know that I did not give birth to them. But I must take care of them, like a nurse carrying a baby in her arms. Why do you force me to do this? Why do you force me to carry them to the land that you promised to our fathers? ");
INSERT INTO engerv_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","I don’t have enough meat for all these people! And they continue complaining to me. They say, ‘Give us meat to eat!’ ");
INSERT INTO engerv_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","I cannot take care of all these people alone. The burden is too heavy for me. ");
INSERT INTO engerv_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","If you plan to continue giving me their troubles, kill me now. If you accept me as your servant, let me die now. Then I will be finished with all my troubles!” ");
INSERT INTO engerv_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","The LORD said to Moses, “Bring to me 70 of the elders of Israel. These men are the leaders among the people. Bring them to the Meeting Tent. Let them stand there with you. ");
INSERT INTO engerv_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Then I will come down and speak with you there. The Spirit is on you now. But I will also give some of that Spirit to them. Then they will help you take care of the people. In this way you will not have to be responsible for these people alone. ");
INSERT INTO engerv_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Tell the people this: Make yourselves ready for tomorrow. Tomorrow you will eat meat. The LORD heard you when you cried out and said, ‘We need meat to eat! It was better for us in Egypt!’ So now the LORD will give you meat. And you will eat it. ");
INSERT INTO engerv_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","You will eat it for more than one, or two, or five, or ten, or even twenty days! ");
INSERT INTO engerv_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","You will eat that meat for a whole month until you are sick of it. This will happen to you because you complained against the LORD. He lives among you and knows what you need, but you cried and complained to him! You said, ‘Why did we ever leave Egypt?’” ");
INSERT INTO engerv_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moses said, “There are 600,000 soldiers here, and you say, ‘I will give them enough meat to eat for a whole month!’ ");
INSERT INTO engerv_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","If we were to kill all the sheep and cattle, that would still not be enough to feed this many people for a month. And if we caught all the fish in the sea, it would not be enough for them!” ");
INSERT INTO engerv_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","But the LORD said to Moses, “Don’t limit my power! You will see that I can do what I say I can do.” ");
INSERT INTO engerv_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","So Moses went out to speak with the people. He told them what the LORD said. Then he gathered 70 of the elders together and told them to stand around the Tent. ");
INSERT INTO engerv_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Then the LORD came down in the cloud and spoke to Moses. He put on the 70 elders some of the same Spirit that was on Moses. After the Spirit came down on them, they began to prophesy. But that was the only time they ever did this. ");
INSERT INTO engerv_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Two of the elders, Eldad and Medad, did not go out to the Tent. Their names were on the list of elders, but they stayed in camp. But the Spirit also came on them, and they began prophesying in camp. ");
INSERT INTO engerv_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","A young man ran and told Moses. The man said, “Eldad and Medad are prophesying in camp.” ");
INSERT INTO engerv_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua son of Nun said to Moses, “Moses, sir, you must stop them!” (Joshua had been Moses’ helper since Joshua was a boy.) ");
INSERT INTO engerv_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","But Moses answered, “Are you afraid the people will think that I am not the leader now? I wish that all the LORD’S people were able to prophesy. I wish that the LORD would put his Spirit on all of them!” ");
INSERT INTO engerv_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Then Moses and the leaders of Israel went back to the camp. ");
INSERT INTO engerv_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Then the LORD made a powerful wind to blow in from the sea, and it blew quail into the area all around the camp. There were so many birds that the ground was covered. They were about three feet deep on the ground. There were quail in every direction as far as a man can walk in one day. ");
INSERT INTO engerv_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","They went out and gathered quail all that day and all that night. And they gathered quail all the next day too! The smallest amount anyone gathered was 60 bushels. Then the people spread the quail meat all around the camp to dry in the sun. ");
INSERT INTO engerv_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","People began to eat the meat, but the LORD became very angry. While the meat was still in their mouths, before the people could finish eating it, the LORD caused the people to become very sick and die. ");
INSERT INTO engerv_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","So the people named that place Kibroth Hattaavah, because there they buried those who had the strong desire for meat. ");
INSERT INTO engerv_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","From Kibroth Hattaavah the people traveled to Hazeroth and stayed there. ");
INSERT INTO engerv_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriam and Aaron began to talk against Moses. They criticized him because he married an Ethiopian woman. ");
INSERT INTO engerv_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","They said to themselves, “Moses is not the only one the LORD has used to speak to the people. He has also spoken through us!” The LORD heard this. ");
INSERT INTO engerv_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Moses was a very humble man. He was more humble than any other man on earth.) ");
INSERT INTO engerv_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","So suddenly, the LORD came and spoke to Moses, Aaron, and Miriam. He said, “You three, come to the Meeting Tent, now!” So Moses, Aaron, and Miriam went to the Tent. ");
INSERT INTO engerv_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","The LORD came down in the tall cloud and stood at the entrance to the Tent. He called out, “Aaron and Miriam!” They went to him. ");
INSERT INTO engerv_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","God said, “Listen to me! You will have prophets. I, the LORD, will let them learn about me through visions. I will speak to them in dreams. ");
INSERT INTO engerv_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","But Moses is not like that. He is my faithful servant—I trust him with everyone in my house. ");
INSERT INTO engerv_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","When I speak to him, I talk face to face with him. I don’t use stories with hidden meanings—I show him clearly what I want him to know. And Moses can look at the very image of the LORD. So why were you brave enough to speak against my servant Moses?” ");
INSERT INTO engerv_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","The LORD was very angry with them, and he left them. ");
INSERT INTO engerv_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","The cloud rose from the Tent. Aaron turned and looked at Miriam. Her skin was white like snow—she had a terrible skin disease! ");
INSERT INTO engerv_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Then Aaron said to Moses, “Please, sir, forgive us for the foolish sin that we did. ");
INSERT INTO engerv_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Don’t let her lose her skin like a baby who is born dead.” (Sometimes a baby will be born like that, with half of its skin eaten away.) ");
INSERT INTO engerv_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","So Moses prayed to the LORD, “God, please heal her from this sickness!” ");
INSERT INTO engerv_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","The LORD answered Moses, “If her father spit in her face, she would be shamed for seven days. So put her outside the camp for seven days. After that she can come back into the camp.” ");
INSERT INTO engerv_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","So they took Miriam outside the camp for seven days. And the people did not move from that place until she was brought in again. ");
INSERT INTO engerv_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","After that the people left Hazeroth and traveled to the desert of Paran where they set up camp. ");
INSERT INTO engerv_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Send some men to explore the land of Canaan. I will give this land to the Israelites. Send one leader from each of the twelve tribes.” ");
INSERT INTO engerv_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","So Moses obeyed the LORD’S command and sent out the Israelite leaders while the people were camped in the desert of Paran. ");
INSERT INTO engerv_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","These are their names: from the tribe of Reuben—Shammua son of Zaccur; ");
INSERT INTO engerv_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","from the tribe of Simeon—Shaphat son of Hori; ");
INSERT INTO engerv_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","from the tribe of Judah—Caleb son of Jephunneh; ");
INSERT INTO engerv_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","from the tribe of Issachar—Igal son of Joseph; ");
INSERT INTO engerv_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","from the tribe of Ephraim—Hoshea son of Nun; ");
INSERT INTO engerv_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","from the tribe of Benjamin—Palti son of Raphu; ");
INSERT INTO engerv_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","from the tribe of Zebulun—Gaddiel son of Sodi; ");
INSERT INTO engerv_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","from the tribe of Manasseh (a tribe from Joseph)—Gaddi son of Susi; ");
INSERT INTO engerv_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","from the tribe of Dan—Ammiel son of Gemalli; ");
INSERT INTO engerv_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","from the tribe of Asher—Sethur son of Michael; ");
INSERT INTO engerv_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","from the tribe of Naphtali—Nahbi son of Vophsi; ");
INSERT INTO engerv_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","from the tribe of Gad—Geuel son of Maki. ");
INSERT INTO engerv_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","These are the names of the men Moses sent to look at and study the land. (Moses called Hoshea son of Nun by another name. Moses called him Joshua.) ");
INSERT INTO engerv_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","When Moses was sending them out to explore Canaan, he said, “Go through the Negev and then into the hill country. ");
INSERT INTO engerv_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","See what the land looks like. Learn about the people who live there. Are they strong or are they weak? Are they few or are they many? ");
INSERT INTO engerv_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Learn about the land that they live in. Is it good land or bad land? What kind of towns do they live in? Do the towns have walls protecting them? Are the towns strongly defended? ");
INSERT INTO engerv_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","And learn other things about the land. Is the soil good for growing things, or is it poor soil? Are there trees on the land? Try to bring back some of the fruit from that land.” (This was during the time when the first grapes should be ripe.) ");
INSERT INTO engerv_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","So they went to explore the country. They explored the area from the desert of Zin to Rehob and Lebo Hamath. ");
INSERT INTO engerv_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","They entered the country through the Negev and went to Hebron. (The town of Hebron was built seven years before the town of Zoan in Egypt.) Ahiman, Sheshai, and Talmai lived there. These men were descendants of Anak. ");
INSERT INTO engerv_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Then the men went to Eshcol Valley. There they cut off a branch from a grapevine that had a bunch of grapes on it. They put that branch on a pole, and two men carried it between them. They also carried some pomegranates and figs. ");
INSERT INTO engerv_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","That place is called the Eshcol Valley, because there the men of Israel cut off the bunch of grapes. ");
INSERT INTO engerv_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","The men explored that country for 40 days, and then they went back to the camp. ");
INSERT INTO engerv_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","The Israelites were camped near Kadesh, in the desert of Paran. The men went to Moses and Aaron and all the Israelites. They told Moses, Aaron, and all the people what they saw and showed them the fruit from the land. ");
INSERT INTO engerv_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","The men told Moses, “We went to the land where you sent us. It is a land filled with many good things! Here is some of the fruit that grows there. ");
INSERT INTO engerv_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","But the people living there are very powerful. The cities are very large and strongly defended. We even saw some Anakites there. ");
INSERT INTO engerv_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","The Amalekites live in the Negev. The Hittites, Jebusites, and Amorites live in the hill country. The Canaanites live near the sea and by the Jordan River.” ");
INSERT INTO engerv_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb told the people near Moses to be quiet. Then Caleb said, “We should go up and take that land for ourselves. We can easily take that land.” ");
INSERT INTO engerv_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","But the men who had gone with him said, “We cannot fight those people! They are much stronger than we are.” ");
INSERT INTO engerv_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","So those men gave a report that discouraged the people. They said, “The land we saw is full of strong people. They are strong enough to easily defeat anyone who goes there. ");
INSERT INTO engerv_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","We saw the giant Nephilim people there! (The descendants of Anak come from the Nephilim.) We felt like little grasshoppers. Yes, we were like grasshoppers to them!” ");
INSERT INTO engerv_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","That night all the people in the camp began shouting loudly. ");
INSERT INTO engerv_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","The Israelites complained against Moses and Aaron. All the people came together and said to Moses and Aaron, “We should have died in Egypt or in the desert. ");
INSERT INTO engerv_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Did the LORD bring us to this new land to be killed in war? The enemy will kill us and take our wives and children! It would be better for us to go back to Egypt.” ");
INSERT INTO engerv_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Then the people said to each other, “Let’s choose another leader and go back to Egypt.” ");
INSERT INTO engerv_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moses and Aaron bowed low to the ground in front of all the people gathered there. ");
INSERT INTO engerv_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua and Caleb became very upset. (Joshua son of Nun and Caleb son of Jephunneh were two of the men who explored the land.) ");
INSERT INTO engerv_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","These two men said to all the Israelites gathered there, “The land that we saw is very good. ");
INSERT INTO engerv_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","It is a land filled with many good things. If the LORD is pleased with us, he will lead us into that land. And he will give that land to us. ");
INSERT INTO engerv_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","So don’t turn against the LORD! Don’t be afraid of the people in that land. We can defeat them. They have no protection, nothing to keep them safe. But we have the LORD with us, so don’t be afraid!” ");
INSERT INTO engerv_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","All the people began talking about killing Joshua and Caleb with stones. But the Glory of the LORD appeared over the Meeting Tent where all the people could see it. ");
INSERT INTO engerv_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","The LORD spoke to Moses and said, “How long will these people continue to turn against me? They show that they don’t trust me or believe in my power, in spite of the many miracles I have done among them. ");
INSERT INTO engerv_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","I will kill them all with a terrible sickness. I will destroy them, and I will use you to make another nation. Your nation will be greater and stronger than these people.” ");
INSERT INTO engerv_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Then Moses said to the LORD, “If you do that, the Egyptians will hear about it! They know that you used your great power to bring your people out of Egypt. ");
INSERT INTO engerv_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","The Egyptians have already told the people in Canaan about it. They already know you are the LORD. They know that you are with your people. They know that the people saw you. Those people know about the special cloud. They know you use the cloud to lead your people during the day. And they know the cloud becomes a fire to lead your people at night. ");
INSERT INTO engerv_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","So you must not kill these people now. If you kill them, all the nations who have heard about your power will say, ");
INSERT INTO engerv_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘The LORD was not able to bring them into the land he promised them. So he killed them in the desert.’ ");
INSERT INTO engerv_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“So now, Lord, show your strength! Show it the way you said you would. ");
INSERT INTO engerv_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","You said, ‘The LORD is slow to become angry. He is full of great love. He forgives those who are guilty and break the law. But he always punishes those who are guilty. He punishes them, and he also punishes their children, their grandchildren, and even their great-grandchildren for those bad things.’ ");
INSERT INTO engerv_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Now, show your great love to these people. Forgive their sin. Forgive them the same way you have been forgiving them since the time they left Egypt until now.” ");
INSERT INTO engerv_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","The LORD answered, “Yes, I will forgive the people as you asked. ");
INSERT INTO engerv_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","But I tell you the truth. As surely as I live and as surely as the Glory of the LORD fills the whole earth, I make you this promise: ");
INSERT INTO engerv_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","None of the people I led out of Egypt will ever see the land of Canaan. They saw my glory and the great signs that I did in Egypt and in the desert. But they disobeyed me and tested me ten times. ");
INSERT INTO engerv_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","I promised their ancestors that I would give them that land. But none of those people who turned against me will ever enter that land! ");
INSERT INTO engerv_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","But my servant Caleb was different. He follows me completely. So I will bring him into the land that he has already seen, and his people will get that land. ");
INSERT INTO engerv_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","The Amalekites and the Canaanites are living in the valley. So tomorrow you must leave this place. Go back to the desert on the road to the Red Sea.” ");
INSERT INTO engerv_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“How long will these evil people continue to complain against me? I have heard their complaints and their griping. ");
INSERT INTO engerv_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","So tell them, ‘The LORD says that he will surely do all those things to you that you complained about. This is what will happen to you: ");
INSERT INTO engerv_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","You will die in this desert. Every person who is 20 years old or older and was counted as one of my people will die. You complained against me. ");
INSERT INTO engerv_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","So none of you will ever enter and live in the land that I promised to give you. Only Caleb son of Jephunneh and Joshua son of Nun will enter that land. ");
INSERT INTO engerv_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","You were afraid and complained that your enemies in that new land would take your children away from you. But I tell you that I will bring them into the land. They will enjoy what you refused to accept. ");
INSERT INTO engerv_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","As for you people, you will die in this desert. ");
INSERT INTO engerv_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘Your children will wander around like shepherds here in the desert for 40 years. They will suffer because you were not faithful to me. They must suffer until all of you lie dead in the desert. ");
INSERT INTO engerv_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","For 40 years you will suffer for your sins. (That is one year for each of the 40 days that the men explored the land.) You will know that it is a terrible thing for me to be against you.’ ");
INSERT INTO engerv_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“I am the LORD, and I have spoken. And I promise that I will do these things to all these evil people. They have come together against me. So they will all die here in this desert.” ");
INSERT INTO engerv_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","The men Moses sent to explore the new land were the ones who came back complaining about him to all the Israelites. They said that the people were not strong enough to enter that land. ");
INSERT INTO engerv_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","The men were responsible for spreading the trouble among the Israelites. So the LORD caused a sickness to kill all those men. ");
INSERT INTO engerv_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","But Joshua son of Nun and Caleb son of Jephunneh were among the men who were sent out to explore the land. They are the only ones who did not get the sickness that caused the others to die. ");
INSERT INTO engerv_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","When Moses told the Israelites this, they were very sad. ");
INSERT INTO engerv_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Early the next morning the people started to go up to the high hill country. They said, “We have sinned. We are sorry that we did not trust the Lord. We will go to the place that the LORD promised.” ");
INSERT INTO engerv_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","But Moses said, “Why are you not obeying the LORD’S command? You will not be successful! ");
INSERT INTO engerv_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Don’t go into that land. The LORD is not with you, so your enemies will easily defeat you. ");
INSERT INTO engerv_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","The Amalekites and Canaanites will fight against you there. You have turned away from the LORD, so he will not be with you when you fight them. And you will all be killed in battle.” ");
INSERT INTO engerv_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","But the people did not believe Moses. They went toward the high hill country. But Moses and the Box of the LORD’S Agreement did not go with the people. ");
INSERT INTO engerv_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","The Amalekites and the Canaanites living in the hill country came down and attacked the Israelites and easily defeated them and chased them all the way to Hormah. ");
INSERT INTO engerv_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Speak to the Israelites and say to them: I am giving you a land to be your home. When you enter that land, ");
INSERT INTO engerv_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","you must give special gifts to the LORD. Their smell will please the LORD. You will use your cattle, sheep, and goats for burnt offerings, sacrifices, special promises, special gifts, fellowship offerings, or at your special festivals. ");
INSERT INTO engerv_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“At the time someone brings their offering, they must also give a grain offering to the LORD. The grain offering will be 8 cups of fine flour mixed with 1 quart of olive oil. ");
INSERT INTO engerv_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Each time you offer a lamb as a burnt offering or sacrifice, you must also prepare a quart of wine as a drink offering. ");
INSERT INTO engerv_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“If you are giving a ram, you must also prepare a grain offering. This grain offering should be 16 cups of fine flour mixed with 1 1/4 quarts of olive oil. ");
INSERT INTO engerv_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","And you must prepare 1 1/4 quarts of wine as a drink offering. Its smell will please the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“You might prepare a young bull as a burnt offering, a sacrifice, a fellowship offering, or to keep a special promise to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","At that time you must also bring a grain offering with the bull. That grain offering should be 24 cups of fine flour mixed with 2 quarts of olive oil. ");
INSERT INTO engerv_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Also bring 2 quarts of wine as a drink offering as a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Each bull or ram, or lamb or young goat that you give must be prepared in this way. ");
INSERT INTO engerv_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Do this for every one of these animals that you give. ");
INSERT INTO engerv_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“This is the way every citizen of Israel must give gifts to please the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Foreigners will live among you. If they give gifts to please the LORD, they must offer them the same way you do. ");
INSERT INTO engerv_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","The same rules will be for everyone—the Israelites and the foreigners living among you. This law will continue forever. You and the people living among you will be the same before the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","This means that you must follow the same laws and the same rules. These laws and rules are for you Israelites and for the other people who are living among you.” ");
INSERT INTO engerv_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Tell the Israelites this: I am taking you to another land. ");
INSERT INTO engerv_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","When you eat the food that grows in that land, you must give part of that food as an offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","You will gather grain and grind it into flour to make dough for bread. You must give the first bread from that flour as a gift to the Lord. It will be like the grain offering that comes from the threshing floor. ");
INSERT INTO engerv_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","You and all your descendants must give part of the first dough you make from that flour as a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“As you try to obey all the commands that the LORD gave Moses, you might fail and make a mistake. ");
INSERT INTO engerv_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","The LORD gave you those commands through Moses, and they have been in effect from the day they were given throughout the generations until today. ");
INSERT INTO engerv_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","If you made this mistake where everyone could see it, the whole community must offer a young bull as a burnt offering, as a sweet-smelling gift to the LORD. You must also offer the grain offering and the drink offering with the bull. And you must also give a male goat as a sin offering. ");
INSERT INTO engerv_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“So the priest will make the whole community of Israel pure, and they will be forgiven for the mistake they made. Since they made the mistake, they must bring a gift and a sin offering to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Then the whole community of Israel and any foreigners among them will be forgiven for the mistake. ");
INSERT INTO engerv_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“But if only one person makes a mistake and sins, that person must bring a female goat that is one year old. That goat will be the sin offering. ");
INSERT INTO engerv_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","The priest will make purification before the LORD for the one who sinned, and that person will be forgiven. ");
INSERT INTO engerv_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","This law is for everyone who makes a mistake and sins. The same law is for the people born in the family of Israel and for the foreigners living among you. ");
INSERT INTO engerv_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“If someone sins and knows they are doing wrong, they are rebelling against the LORD. They must be separated from their people. The same law applies to citizens of Israel and to foreigners living among you. ");
INSERT INTO engerv_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","They thought the LORD’S word was not important, so they broke his commands. That is why they must be separated from their people—they must bear the responsibility for their guilt.” ");
INSERT INTO engerv_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","While the Israelites were in the desert, some of them saw a man gathering firewood on the Sabbath day. ");
INSERT INTO engerv_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","The people who saw him gathering the wood brought him to Moses and Aaron and the whole community of Israel. ");
INSERT INTO engerv_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","They guarded the man carefully because they did not know how they should punish him. ");
INSERT INTO engerv_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Then the LORD said to Moses, “The man must die. All the people must throw stones at him outside the camp.” ");
INSERT INTO engerv_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","So the people took him outside the camp and killed him with stones. They did this just as the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Speak to the Israelites. Tell them this: Tie several pieces of thread together and tie them in the corner of your clothes. Put a piece of blue thread in each one of these tassels. You must wear these things now and forever. ");
INSERT INTO engerv_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","You will be able to look at these tassels and remember all the commands that the LORD has given you. Then you will obey the commands. You will not do wrong by forgetting about the commands and doing the things that your own bodies and eyes want. ");
INSERT INTO engerv_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","You will remember to obey all my commands. Then you will be God’s special people. ");
INSERT INTO engerv_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","I am the LORD your God. I am the one who brought you out of Egypt. I did this to be your God. I am the LORD your God.” ");
INSERT INTO engerv_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Korah, Dathan, Abiram, and On turned against Moses. (Korah was the son of Izhar. Izhar was the son of Kohath, and Kohath was the son of Levi. Dathan and Abiram were brothers, the sons of Eliab. And On was the son of Peleth. Dathan, Abiram, and On were descendants of Reuben.) ");
INSERT INTO engerv_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","These four men gathered 250 other men from Israel together and came against Moses. They were leaders who had been chosen by the people. All the people knew them. ");
INSERT INTO engerv_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","They came as a group to speak against Moses and Aaron and said, “You have gone too far—you are wrong! All the Israelites are holy—the LORD still lives among them. You are making yourselves more important than the rest of the LORD’S people.” ");
INSERT INTO engerv_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","When Moses heard this, he bowed his face to the ground to show he was not being proud. ");
INSERT INTO engerv_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Then Moses said to Korah and all his followers, “Tomorrow morning the LORD will show who belongs to him. He will show who is holy, and he will bring that man near to him. He will choose him and bring that man near to him. ");
INSERT INTO engerv_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","So Korah, you and all your followers should do this: ");
INSERT INTO engerv_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Tomorrow put fire and incense in some special pans. Then bring those pans before the LORD. He will choose the man who is holy. You Levites have gone too far—you are wrong!” ");
INSERT INTO engerv_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moses also said to Korah, “You Levites, listen to me. ");
INSERT INTO engerv_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","You should be happy that the God of Israel chose you to be different from the rest of the Israelites. He lets you come near to him to do the special work in the LORD’S Holy Tent to help the Israelites worship him. Isn’t that enough? ");
INSERT INTO engerv_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","He brought you Levites near to him to help the priests, but now you are trying to become priests also. ");
INSERT INTO engerv_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","You and your followers have joined together and turned against the LORD! Did Aaron do anything wrong? No, so why are you complaining against Aaron?” ");
INSERT INTO engerv_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Then Moses called Dathan and Abiram, the sons of Eliab. But the two men said, “We will not come! ");
INSERT INTO engerv_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","You have brought us out of a land filled with many good things. You brought us to the desert to kill us. And now you want to show that you have even more power over us. ");
INSERT INTO engerv_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Why should we follow you? You did not bring us into the new land filled with many good things. You did not give us the land God promised. You did not give us the fields or the vineyards. Will you make these men your slaves? No! We will not come.” ");
INSERT INTO engerv_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","So Moses became very angry. He said to the LORD, “I never did anything wrong to these people. I never took anything from them—not even a donkey! Don’t accept their gifts!” ");
INSERT INTO engerv_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Then Moses said to Korah, “You and all your followers will stand before the LORD tomorrow. Aaron will also be there with you and your followers. ");
INSERT INTO engerv_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Each of you must bring a pan, put incense in it, and present it to the LORD. There will be 250 pans for the leaders and one pan for you and one pan for Aaron.” ");
INSERT INTO engerv_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","So each man got a pan and put burning incense in it. Then they stood at the entrance of the Meeting Tent. Moses and Aaron also stood there. ");
INSERT INTO engerv_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Korah also gathered all the people together at the entrance of the Meeting Tent. Then the Glory of the LORD appeared to everyone there. ");
INSERT INTO engerv_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Move away from these men! I want to destroy them now!” ");
INSERT INTO engerv_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","But Moses and Aaron bowed to the ground and cried out, “God, you know what people are thinking. Please don’t be angry with all these people. Only one man really sinned.” ");
INSERT INTO engerv_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tell the people to move away from the tents of Korah, Dathan, and Abiram.” ");
INSERT INTO engerv_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moses stood and went to Dathan and Abiram. All the elders of Israel followed him. ");
INSERT INTO engerv_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Moses warned the people, “Move away from the tents of these evil men. Don’t touch anything that belongs to them! If you do, you will be destroyed because of their sins.” ");
INSERT INTO engerv_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","So the men moved away from the tents of Korah, Dathan, and Abiram. Dathan and Abiram went to their tents. They stood outside of their tents with their wives, children, and little babies. ");
INSERT INTO engerv_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Then Moses said, “I will show you proof that the LORD sent me to do all the things I told you. I will show you that all these things were not my own idea. ");
INSERT INTO engerv_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","These men will die, but if they die in a normal way—the way people always die—then that will show that the LORD did not really send me. ");
INSERT INTO engerv_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","But if the LORD causes them to die in a different way, then you will know that these men have sinned against the LORD. This is the proof: The earth will open and swallow them. They will go down to their grave still alive. And everything that belongs to these men will go down with them.” ");
INSERT INTO engerv_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","When Moses finished saying these things, the ground under the men opened. ");
INSERT INTO engerv_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","It was as if the earth opened its mouth and swallowed them. All of Korah’s men, their families, and everything they owned went down into the earth. ");
INSERT INTO engerv_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","They went down into their grave alive. Everything they owned went with them. Then the earth closed over them. They were finished—gone from the camp! ");
INSERT INTO engerv_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","The Israelites heard the cries of the men being destroyed. So they all ran in different directions and said, “The earth will swallow us too!” ");
INSERT INTO engerv_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Then a fire came from the LORD and destroyed the 250 men who were offering the incense. ");
INSERT INTO engerv_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“Tell Eleazar son of Aaron the priest to get all the incense pans from the fire. Tell him to scatter the coals and ashes. These men sinned against me, and their sin cost them their lives. But the incense pans are still holy. The pans became holy when people gave them to the LORD. Hammer the pans into flat sheets. Use the metal sheets to cover the altar. This will be a warning to all the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","So Eleazar the priest gathered together all the bronze pans that the men had brought. These men were all burned up, but the pans were still there. Then Eleazar told some men to hammer the pans into flat metal. Then he put the metal sheets on the altar. ");
INSERT INTO engerv_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","He did this the way the LORD commanded him through Moses. This was a sign to help the Israelites remember that only someone from the family of Aaron should burn incense before the LORD. Any other person who burns incense before the Lord will die like Korah and his followers. ");
INSERT INTO engerv_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","The next day all the Israelites complained against Moses and Aaron. They said, “You killed the LORD’S people.” ");
INSERT INTO engerv_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Moses and Aaron were standing at the entrance of the Meeting Tent. The people gathered together at that place to complain against Moses and Aaron. But when they looked toward the Meeting Tent, the cloud covered it and the Glory of the LORD appeared there. ");
INSERT INTO engerv_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Then Moses and Aaron went to the front of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Move away from these people so that I can destroy them now.” So Moses and Aaron bowed with their faces to the ground. ");
INSERT INTO engerv_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Then Moses said to Aaron, “Get your bronze pan and some fire from the altar. Then put incense in it. Hurry to the people and do the things that will make them pure. The LORD is angry with them. The trouble has already started.” ");
INSERT INTO engerv_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","48","So Aaron got the incense and the fire, and he ran to the middle of the people. But the sickness had already started among them. So Aaron stood between the dead and those who were still alive. He did what Moses said to remove their sin, and the sickness stopped there. ");
INSERT INTO engerv_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","But 14,700 people died from that sickness—and that is not counting the people who died because of Korah. ");
INSERT INTO engerv_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","So the terrible sickness was stopped, and Aaron went back to Moses at the entrance of the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Speak to the Israelites. Get twelve wooden walking sticks from them. Get one from the leader of each of the twelve tribes. Write the name of each man on his walking stick. ");
INSERT INTO engerv_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","On the stick from Levi, write Aaron’s name. There must be one stick for the head of each of the twelve tribes. ");
INSERT INTO engerv_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Put these walking sticks in the Meeting Tent in front of the Box of the Agreement. This is the place where I meet with you. ");
INSERT INTO engerv_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","I will choose one man to be the true priest. You will know which man I choose because his walking stick will begin to grow new leaves. In this way I will stop the people from always complaining against you and me.” ");
INSERT INTO engerv_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","So Moses spoke to the Israelites. Each of the leaders gave him a walking stick. There were twelve walking sticks. There was one stick from each leader of each tribe. One of the walking sticks belonged to Aaron. ");
INSERT INTO engerv_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moses put the walking sticks before the LORD in the Tent of the Agreement. ");
INSERT INTO engerv_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","The next day Moses entered the Tent. He saw that Aaron’s walking stick, the stick from the family of Levi, was the one that had grown new leaves. That walking stick had even grown branches and made almonds. ");
INSERT INTO engerv_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","So Moses brought out all the sticks from the LORD’S place. He showed the walking sticks to the Israelites. They all looked at the sticks, and each man took his own stick back. ");
INSERT INTO engerv_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Then the LORD said to Moses, “Put Aaron’s walking stick back in front of the Box that holds the Agreement. This will be a warning for these people who are always turning against me. This will stop their complaining against me so that I will not destroy them.” ");
INSERT INTO engerv_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","So Moses did what the LORD commanded him. ");
INSERT INTO engerv_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","The Israelites said to Moses, “We know that we will die! We are lost! We will all be destroyed! ");
INSERT INTO engerv_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Anyone who even comes near the LORD’S holy place will die. Is it true that we will all die?” ");
INSERT INTO engerv_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","The LORD said to Aaron, “You, your sons, and all the people in your father’s family must bear the responsibility for any wrong that is done against the holy place or against the priests. ");
INSERT INTO engerv_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","To prevent that from happening, you must bring the rest of the men from the tribe of Levi to join you. These Levites will help you and your sons do your work in the Tent of the Agreement. ");
INSERT INTO engerv_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","These Levites will be under your control. They will do all the work that needs to be done in the Tent. But they must not go near the things in the Holy Place or the altar. If they do, they will die—and you also will die. ");
INSERT INTO engerv_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","They will join you and work with you. They will be responsible for caring for the Meeting Tent. All the work that must be done in the Tent will be done by them. No one else may come near the place where you are. ");
INSERT INTO engerv_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“You are responsible for caring for the holy place and the altar. I don’t want to become angry with the Israelites again. ");
INSERT INTO engerv_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","I myself chose the Levites from among all the Israelites. They are as a gift to you. I gave them to you to serve the LORD and work in the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","But, Aaron, only you and your sons may serve as priests. You are the only ones who can go near the altar or behind the curtain into the Most Holy Place. I am giving you a gift—your service as a priest. Anyone else who tries to come too close must be killed.” ");
INSERT INTO engerv_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Then the LORD said to Aaron, “I myself gave you responsibility over all the special gifts people give to me. All the holy gifts that the Israelites give to me, I give to you. You and your sons can share in these gifts. They will always belong to you. ");
INSERT INTO engerv_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","The people will bring gifts, grain offerings, sin offerings, and guilt offerings. These offerings are most holy. Your share in the most holy offerings will come from the parts that are not burned. All these things will be for you and your sons. ");
INSERT INTO engerv_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Eat these things only in a very holy place. Every male in your family may eat them, but you must remember that these offerings are holy. ");
INSERT INTO engerv_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“The Israelites will bring special gifts that you will lift up to me. I give these gifts to you and your sons and daughters. That is your share. Everyone in your family who is clean will be able to eat it. ");
INSERT INTO engerv_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“And I give you all the best olive oil and all the best new wine and grain. These are the things that the Israelites give to me, the LORD. These are the first things that they gather in their harvest. ");
INSERT INTO engerv_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","When the people gather a harvest, they bring all the first things to the LORD. So these things I will give to you. And everyone in your family who is clean may eat it. ");
INSERT INTO engerv_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Anything in Israel that is a special gift to God is yours. ");
INSERT INTO engerv_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“A woman’s first baby and an animal’s first baby must be given to the LORD. That baby will belong to you. If the firstborn animal is unclean, then it must be bought back. If the baby is a child, that child must be bought back. ");
INSERT INTO engerv_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","They must make the payment when the baby is one month old. The cost will be 5 shekels of silver. You must use the official measure to weigh this silver. A shekel by the official measure is 20 gerahs. ");
INSERT INTO engerv_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“But you must not make a payment for the firstborn cow, sheep, or goat. These animals are holy. Sprinkle their blood on the altar and burn their fat as a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","But the meat from these animals will be yours. And also the breast that was lifted up to the Lord will be yours. And the right thigh from other offerings will be yours. ");
INSERT INTO engerv_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","I, the LORD, give you everything that the people offer as holy gifts. This is your share. I give it to you and your sons and daughters. This law will continue forever. It is an agreement with the LORD that cannot be broken. I make this promise to you and to your descendants.” ");
INSERT INTO engerv_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","The LORD also said to Aaron, “You will not get any of the land. And you will not own anything that the other people own. I myself will be yours. The Israelites will get the land that I promised, but I am my gift to you. ");
INSERT INTO engerv_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“The Israelites will give one-tenth of everything they have. So I give that one-tenth to the Levites. This is their payment for the work that they do while they serve at the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","But the other Israelites must never go near that Meeting Tent. If they do, they must be put to death! ");
INSERT INTO engerv_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","The Levites will do the work of caring for the Meeting Tent. They must bear the responsibility for anything done against it. This is a law that will continue forever. The Levites will not get any of the land that I promised to the other Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","But the Israelites will give one-tenth of everything they have to the LORD, and I will give that one-tenth to the Levites. That is why I said these words about the Levites: They will not get the land that I promised the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Speak to the Levites and tell them: The Israelites will give one-tenth of everything they own to the LORD. That one-tenth will belong to the Levites. But you must give one-tenth of that to the Lord as your offering. ");
INSERT INTO engerv_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","That tenth will be your offering to the Lord. It will be like grain from your own threshing floor or wine from your own winepress. ");
INSERT INTO engerv_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","In this way you will also give an offering to the LORD just as the other Israelites do. You will get the one-tenth that the Israelites give to the LORD, and then you will give one-tenth of that to Aaron the priest. ");
INSERT INTO engerv_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","When the Israelites give you one-tenth of everything that they own, then you must give the best and the holiest part of these things as your gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Moses, tell this to the Levites: When you give the best part of what you receive to the Lord, it will be the same as grain from your own threshing floor and wine from your own winepress. ");
INSERT INTO engerv_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","You and your families can eat all that is left. This is your payment for the work you do in the Meeting Tent. ");
INSERT INTO engerv_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","And if you always give the best part of it to the Lord, you will never be guilty. You will always remember that these gifts are the holy offerings from the Israelites. And you will not die.” ");
INSERT INTO engerv_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","The LORD spoke to Moses and Aaron. He said, ");
INSERT INTO engerv_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“These are the laws from the teachings that the LORD gave to the Israelites. Get a red cow that has nothing wrong with it. That cow must not have any bruises. And it must never have worn a yoke. ");
INSERT INTO engerv_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Give that cow to Eleazar, and he will take it outside the camp and kill it there. ");
INSERT INTO engerv_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Then Eleazar the priest must put some of its blood on his finger and sprinkle some of the blood toward the Holy Tent. He must do this seven times. ");
INSERT INTO engerv_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Then the whole cow must be burned in front of him; the skin, the meat, the blood, and the intestines must all be burned. ");
INSERT INTO engerv_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Then the priest must take a cedar stick, a hyssop branch, and some red string. He must throw these things into the fire where the cow is burning. ");
INSERT INTO engerv_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Then the priest must wash himself and his clothes with water. Then he must come back into the camp. He will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","The man who burns that cow must wash himself and his clothes in water. He will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Then someone who is clean will collect the ashes from the cow and put them in a clean place outside the camp. These ashes will be used when someone must keep a special ceremony to become clean. These ashes will also be used to remove a person’s sins. ");
INSERT INTO engerv_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“The man who collected the cow’s ashes must wash his clothes. He will be unclean until evening. “This rule will continue forever. This rule is for the citizens of Israel and for the foreigners living with you. ");
INSERT INTO engerv_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Those who touch a dead body will be unclean for seven days. ");
INSERT INTO engerv_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","They must wash themselves with the special water on the third day and again on the seventh day. If they don’t do this, they will remain unclean. ");
INSERT INTO engerv_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Those who touch the body of someone who has died are unclean. If they stay unclean and then go to the LORD’S Holy Tent, they make it unclean. So they must be separated from the Israelites. Because the special water was not thrown on them, they remain unclean. ");
INSERT INTO engerv_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“This is the rule about those who die in their tents: If someone dies in the tent, everyone in the tent will be unclean for seven days. ");
INSERT INTO engerv_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","And every jar or pot without a lid becomes unclean. ");
INSERT INTO engerv_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","If there is a dead body out in a field, whether the person died in battle or for some other reason, whoever touches that dead body, or its bones, or even its grave will be unclean for seven days. ");
INSERT INTO engerv_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“If you have become unclean, someone must use the ashes from the burned cow to make you clean again. They must pour fresh water over the ashes into a jar. ");
INSERT INTO engerv_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","That clean person must take a hyssop branch and dip it into the water. The clean person must sprinkle it over the tent, the dishes, and any people who were in the tent. That clean person must do this for anyone who touches a dead body, its bones, or even a grave. ");
INSERT INTO engerv_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“Then that clean person must sprinkle this water on you on the third day and again on the seventh day. On the seventh day you will become clean. You must wash your clothes in water and you will become clean in the evening. ");
INSERT INTO engerv_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Whoever becomes unclean and does not become clean must be separated from the community. If an unclean person is not sprinkled with that special water and does not become clean, that person might make the LORD’S Holy Tent unclean. ");
INSERT INTO engerv_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","This rule will be for you forever. And whoever sprinkled the special water must wash their clothes because they will be unclean until evening. ");
INSERT INTO engerv_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","And whoever an unclean person touches will be unclean until evening.” ");
INSERT INTO engerv_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","The Israelites arrived at the desert of Zin in the first month of the year. The people stayed at Kadesh. Miriam died and was buried there. ");
INSERT INTO engerv_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","There was not enough water for the people at that place. So the people met together to complain against Moses and Aaron. ");
INSERT INTO engerv_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","The people argued with Moses and said, “Maybe we should have died in front of the LORD like our brothers did. ");
INSERT INTO engerv_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Why did you bring the LORD’S people into this desert? Do you want us and our animals to die here? ");
INSERT INTO engerv_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Why did you bring us from Egypt? Why did you bring us to this bad place? There is no grain. There are no figs, grapes, or pomegranates, and there is no water to drink.” ");
INSERT INTO engerv_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","So Moses and Aaron left the crowd of people and went to the entrance of the Meeting Tent. They bowed down to the ground, and the Glory of the LORD appeared to them. ");
INSERT INTO engerv_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","The LORD spoke to Moses and said, ");
INSERT INTO engerv_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Get the special walking stick. Take your brother Aaron and the crowd of people and go to that rock. Speak to the rock in front of the people. Then water will flow from the rock, and you can give that water to the people and to their animals.” ");
INSERT INTO engerv_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","The walking stick was in the Holy Tent, in front of the LORD. Moses took the walking stick as the Lord said. ");
INSERT INTO engerv_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moses and Aaron told the people to meet together in front of the rock. Then Moses said, “You people are always complaining. Now listen to me. I will cause water to flow from this rock.” ");
INSERT INTO engerv_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moses lifted his arm and hit the rock twice. Water began flowing from the rock, and the people and their animals drank that water. ");
INSERT INTO engerv_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","But the LORD said to Moses and Aaron, “You did not trust me enough to honor me and show the people that I am holy. You did not show the Israelites that the power to make the water came from me. So you will not lead the people into the land that I have given them.” ");
INSERT INTO engerv_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","This place was called the waters of Meribah. This is where the Israelites argued with the LORD and where he showed them that he was holy. ");
INSERT INTO engerv_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","While Moses was at Kadesh, he sent some men with a message to the king of Edom. The message said, “This is what your brothers, the Israelites, say to you: You know about all the troubles we have had. ");
INSERT INTO engerv_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Many years ago our ancestors went down into Egypt, and we lived there for many years. The people of Egypt were cruel to us. ");
INSERT INTO engerv_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","But we asked the LORD for help, and he heard us and sent an angel to help us. The Lord has brought us out of Egypt. “Now we are here at Kadesh, where your land begins. ");
INSERT INTO engerv_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Please let us travel through your country. We will not travel through any fields or vineyards. We will not drink water from any of your wells. We will travel only along King’s Road. We will not leave that road to the right or to the left. We will stay on the road until we have traveled through your country.” ");
INSERT INTO engerv_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","But the king of Edom answered, “You may not travel through our land. If you try to travel through our land, we will come and fight you with swords.” ");
INSERT INTO engerv_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","The Israelites answered, “We will travel along the main road. If our animals drink any of your water, we will pay you for it. We only want to walk through your country. We don’t want to take it for ourselves.” ");
INSERT INTO engerv_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","But again the king of Edom answered, “We will not allow you to come through our country.” Then the king of Edom gathered a large and powerful army and went out to fight against the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","The king of Edom refused to let the Israelites travel through his country, so the Israelites turned around and went another way. ");
INSERT INTO engerv_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","All the Israelites traveled from Kadesh to Mount Hor. ");
INSERT INTO engerv_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Mount Hor was near the border of Edom. The LORD said to Moses and Aaron, ");
INSERT INTO engerv_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“It is time for Aaron to die and go to be with his ancestors. Aaron will not enter the land that I promised to the Israelites. Moses, I say this to you because both you and Aaron did not fully obey the command I gave you at the waters of Meribah. ");
INSERT INTO engerv_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“Now, bring Aaron and his son Eleazar up to Mount Hor. ");
INSERT INTO engerv_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Take Aaron’s special clothes from him and put these clothes on his son Eleazar. Aaron will die there on the mountain. And he will go to be with his ancestors.” ");
INSERT INTO engerv_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moses obeyed the LORD’S command. Moses, Aaron, and Eleazar went up on Mount Hor. All the Israelites watched them go. ");
INSERT INTO engerv_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moses removed Aaron’s special clothes and put them on Aaron’s son Eleazar. Then Aaron died there on top of the mountain. Moses and Eleazar came back down the mountain. ");
INSERT INTO engerv_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","All the Israelites learned that Aaron was dead. So everyone in Israel mourned for 30 days. ");
INSERT INTO engerv_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","The Canaanite king of Arad lived in the Negev. He heard that the Israelites were coming on the road to Atharim, so the king went out and attacked the Israelites. Arad captured some of the people and made them prisoners. ");
INSERT INTO engerv_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Then the Israelites made a special promise to the LORD: “Please help us defeat these people. If you do this, we will give their cities to you. We will totally destroy them.” ");
INSERT INTO engerv_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","The LORD listened to the Israelites and helped them defeat the Canaanites. They completely destroyed the Canaanites and their cities. So that place was named Hormah. ");
INSERT INTO engerv_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","The Israelites left Mount Hor and traveled on the road that goes to the Red Sea. They did this to go around the country of Edom. But the people became impatient. ");
INSERT INTO engerv_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","They began complaining against God and Moses. The people said, “Why did you bring us out of Egypt? We will die here in the desert! There is no bread and no water! And we hate this terrible food!” ");
INSERT INTO engerv_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","So the LORD sent poisonous snakes among the people. The snakes bit the people, and many of the Israelites died. ");
INSERT INTO engerv_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","The people came to Moses and said, “We know that we sinned when we spoke against the LORD and against you. Pray to the LORD. Ask him to take away these snakes.” So Moses prayed for them. ");
INSERT INTO engerv_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","The LORD said to Moses, “Make a bronze snake and put it on a pole. If anyone is bitten by a snake, that person should look at the bronze snake on the pole. Then that person will not die.” ");
INSERT INTO engerv_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","So Moses made a bronze snake and put it on a pole. Then when a snake bit anyone, that person looked at the bronze snake on the pole and lived. ");
INSERT INTO engerv_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","The Israelites left that place and camped at Oboth. ");
INSERT INTO engerv_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Then they left Oboth and camped at Iye Abarim in the desert east of Moab. ");
INSERT INTO engerv_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","They left that place and camped in Zered Valley. ");
INSERT INTO engerv_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Then they moved and camped across from the Arnon River in the desert. This river started at the Ammonite border. The valley was the border between Moab and the Amorites. ");
INSERT INTO engerv_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","That is why these words are written in the Book of the Wars of the LORD: “… and Waheb in Suphah, and the Valleys of the Arnon, ");
INSERT INTO engerv_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","and the hills by the valleys that lead to the town of Ar. These places are at the border of Moab.” ");
INSERT INTO engerv_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","The Israelites left that place and traveled to Beer. There is a well in Beer, where the LORD said to Moses, “Bring the people together here, and I will give them water.” ");
INSERT INTO engerv_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Then the Israelites sang this song: “Well, flow with water! Sing about it! ");
INSERT INTO engerv_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Great men dug this well. Important leaders dug this well. They dug this well with their staffs and walking sticks. It is a gift in the desert.” ");
INSERT INTO engerv_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","The people traveled from Mattanah to Nahaliel. Then they traveled from Nahaliel to Bamoth. ");
INSERT INTO engerv_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","They traveled from Bamoth to the Valley of Moab. In this place the top of the Pisgah Mountain looks over the desert. ");
INSERT INTO engerv_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","The Israelites sent some men to King Sihon of the Amorites. The men said to the king, ");
INSERT INTO engerv_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Allow us to travel through your country. We will not go through any field or vineyard. We will not drink water from any of your wells. We will travel only along King’s Road. We will stay on that road until we have traveled through your country.” ");
INSERT INTO engerv_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","But King Sihon would not allow the Israelites to travel through his country. He gathered together his army and marched out to the desert to fight against the Israelites. The king’s army fought against the Israelites at Jahaz. ");
INSERT INTO engerv_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","But the Israelites defeated the king and took his land from the Arnon River to the Jabbok River. The Israelites took the land as far as the Ammonite border. They stopped at that border because it was strongly defended by the Ammonites. ");
INSERT INTO engerv_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israel took all the Amorite cities and began living in them. They even defeated the city of Heshbon and all the small towns around it. ");
INSERT INTO engerv_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon was the city where Sihon, the Amorite king, lived. In the past Sihon had fought with the king of Moab. Sihon had taken the land as far as the Arnon River. ");
INSERT INTO engerv_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","That is why the singers sing this song: “Go in and rebuild Heshbon! Make Sihon’s city strong. ");
INSERT INTO engerv_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","A fire began in Heshbon. That fire began in Sihon’s city. The fire destroyed Ar in Moab. It burned the hills above Arnon River. ");
INSERT INTO engerv_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","It is bad for you, Moab. You lost Chemosh’s people. His sons ran away. His daughters were taken prisoners by Sihon, king of the Amorites. ");
INSERT INTO engerv_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","But we defeated those Amorites. We destroyed their towns from Heshbon to Dibon, from Nashim to Nophah, near Medeba.” ");
INSERT INTO engerv_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","So the Israelites made their camp in the land of the Amorites. ");
INSERT INTO engerv_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moses sent some men to look at the town of Jazer. Then the Israelites captured that town and the small towns that were around it. They forced the Amorites who were living there to leave. ");
INSERT INTO engerv_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Then the Israelites traveled on the road toward Bashan. King Og of Bashan got his army and marched out to meet the Israelites. He fought against them at Edrei. ");
INSERT INTO engerv_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","But the LORD said to Moses, “Don’t be afraid of that king. I will allow you to defeat him. You will take his whole army and all his land. Do the same to him as you did to Sihon, the Amorite king who lived in Heshbon.” ");
INSERT INTO engerv_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","So the Israelites defeated Og and his army. They killed him, his sons, and all his army. Then the Israelites took all his land. ");
INSERT INTO engerv_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Then the Israelites traveled to the Jordan Valley in Moab. They camped near the Jordan River across from Jericho. ");
INSERT INTO engerv_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","Balak son of Zippor saw everything the Israelites had done to the Amorites. The king of Moab was very frightened of the Israelites because there were so many of them. He was very afraid. ");
INSERT INTO engerv_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","The king of Moab said to the leaders of Midian, “This large group of people will destroy everything around us, the way an ox eats all the grass in a field.” Balak son of Zippor was the king of Moab at this time. ");
INSERT INTO engerv_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","He sent some men to Balaam son of Beor. Balaam was at Pethor, near the Euphrates River. This was where Balaam’s people lived. This was Balak’s message: “A new nation of people has come out of Egypt. There are so many people that they cover all the land. They have camped next to me. ");
INSERT INTO engerv_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Come and help me. These people are too powerful for me. I know that you have great power. If you bless people, good things happen to them. And if you curse people, bad things happen to them. So come and curse these people. Maybe then I will be able to defeat them and force them to leave my country.” ");
INSERT INTO engerv_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","The leaders of Moab and Midian left. They went to talk to Balaam. They carried with them money to pay him for his service. Then they told him what Balak had said. ");
INSERT INTO engerv_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam said to them, “Stay here for the night. I will talk to the LORD and tell you the answer he gives me.” So the leaders of Moab stayed there with Balaam that night. ");
INSERT INTO engerv_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","God came to Balaam and asked, “Who are these men with you?” ");
INSERT INTO engerv_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam said to God, “The king of Moab, Balak son of Zippor, sent them to give me a message. ");
INSERT INTO engerv_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","This is the message: A new nation of people has come out of Egypt. There are so many people that they cover the land. So come and curse these people. Then maybe I will be able to fight them and force them to leave my land.” ");
INSERT INTO engerv_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","But God said to Balaam, “Don’t go with them. You must not curse those people. They are my people.” ");
INSERT INTO engerv_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","The next morning Balaam got up and said to leaders from Balak, “Go back to your own country. The LORD will not let me go with you.” ");
INSERT INTO engerv_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","So the leaders of Moab went back to Balak and told him this. They said, “Balaam refused to come with us.” ");
INSERT INTO engerv_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","So Balak sent other leaders to Balaam. This time he sent many more than the first time. And these leaders were much more important than the first ones he sent. ");
INSERT INTO engerv_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","They went to Balaam and said, “This is what Balak son of Zippor says to you: Please don’t let anything stop you from coming. ");
INSERT INTO engerv_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","I will pay you very much, and I will do whatever you ask. Come and curse these people for me.” ");
INSERT INTO engerv_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam gave Balak’s officials his answer. He said, “I must obey the LORD my God. I cannot do anything, great or small, against his command. Even if King Balak gives me his beautiful home filled with silver and gold, I will not do anything against the Lord’s command. ");
INSERT INTO engerv_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","But you can stay here tonight like the other men did, and during the night I will learn what the LORD wants to tell me.” ");
INSERT INTO engerv_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","That night, God came to Balaam. God said, “These men have come again to ask you to go with them. So you can go with them. But do only what I tell you to do.” ");
INSERT INTO engerv_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","The next morning, Balaam got up, put a saddle on his donkey, and went with the Moabite leaders. ");
INSERT INTO engerv_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Balaam was riding on his donkey. Two of his servants were with him. While Balaam was traveling, God became angry. So the LORD’S angel stood in the road in front of Balaam to stop him. ");
INSERT INTO engerv_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","When Balaam’s donkey saw the LORD’S angel standing in the road with a sword in his hand, the donkey turned from the road and went into the field. Balaam could not see the angel, so he was very angry at the donkey. He hit the donkey and forced it to go back on the road. ");
INSERT INTO engerv_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Later, the LORD’S angel stood at a place where the road became narrow. This was between two vineyards. There were walls on both sides of the road. ");
INSERT INTO engerv_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Again the donkey saw the LORD’S angel. So the donkey walked very close to one wall. This crushed Balaam’s foot against the wall. So Balaam hit his donkey again. ");
INSERT INTO engerv_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Later, the LORD’S angel stood at another place where the road became narrow. There was no place where the donkey could go around him. It could not turn to the left or to the right. ");
INSERT INTO engerv_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","The donkey saw the LORD’S angel. So the donkey lay down with Balaam sitting on top of it. Balaam was very angry at the donkey. So he hit it with his walking stick. ");
INSERT INTO engerv_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Then the LORD caused the donkey to speak. The donkey said to Balaam, “Why are you angry at me? What have I done to you? You have hit me three times!” ");
INSERT INTO engerv_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam answered the donkey, “You have made me look foolish. If I had a sword in my hand, I would kill you right now!” ");
INSERT INTO engerv_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","But the donkey said to Balaam, “Look, I am your donkey. You have ridden me for so many years. And you know that I have never done this to you before!” “That is true,” Balaam said. ");
INSERT INTO engerv_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Then the LORD allowed Balaam to see the angel. The LORD’S angel was standing in the road, holding a sword in his hand. Balaam bowed low to the ground. ");
INSERT INTO engerv_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Then the LORD’S angel asked Balaam, “Why did you hit your donkey three times? I am the one who came to stop you. But just in time, ");
INSERT INTO engerv_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","your donkey saw me and turned away from me. That happened three times. If the donkey had not turned away, I probably would have killed you already. And I would have let your donkey live.” ");
INSERT INTO engerv_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Then Balaam said to the LORD’S angel, “I have sinned. I did not know that you were standing in the road. If I am doing wrong, I will go back home.” ");
INSERT INTO engerv_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Then the LORD’S angel said to Balaam, “No, you can go with these men. But be careful. Speak only the words that I will tell you to say.” So Balaam went with the leaders that Balak had sent. ");
INSERT INTO engerv_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak heard that Balaam was coming. So Balak went out to meet him at the Moabite town near the Arnon River. This was at the northern border of his country. ");
INSERT INTO engerv_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","When Balak saw Balaam, he said to him, “I asked you before to come. I told you it was very important. Why didn’t you come to me? Did you think I might not be able to pay you?” ");
INSERT INTO engerv_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam answered, “Well, I am here now. I came, but I might not be able to do what you asked. I can only say the words God tells me to say.” ");
INSERT INTO engerv_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Then Balaam went with Balak to Kiriath Huzoth. ");
INSERT INTO engerv_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak killed some cattle and some sheep as his sacrifice. He gave some of the meat to Balaam and some to the leaders who were with him. ");
INSERT INTO engerv_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","The next morning Balak took Balaam to the town of Bamoth Baal. From there they could see part of the Israelite camp. ");
INSERT INTO engerv_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam said, “Build seven altars here. And prepare seven bulls and seven rams for me.” ");
INSERT INTO engerv_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak did what Balaam asked. Then Balak and Balaam killed a ram and a bull on each of the altars. ");
INSERT INTO engerv_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Then Balaam said to Balak, “Stay here near this altar. I will go to another place. Then the LORD will come to me, and he will tell me what I must say.” Then Balaam went away to a higher place. ");
INSERT INTO engerv_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","God came to Balaam at that place, and Balaam said, “I have prepared seven altars. And I have killed a bull and a ram as a sacrifice on each altar.” ");
INSERT INTO engerv_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Then the LORD gave Balaam a message for Balak and said, “Go back to Balak and say the things that I have given you to say.” ");
INSERT INTO engerv_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","So Balaam went back to Balak. Balak was still standing near the altar, and all the leaders of Moab were standing there with them. ");
INSERT INTO engerv_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Then Balaam spoke, and this was his message: “Balak, the king of Moab, brought me here from the eastern mountains of Aram. Balak said to me, ‘Come, curse Jacob for me. Come, speak against the Israelites.’ ");
INSERT INTO engerv_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","But God is not against them, so I cannot speak against them either! The LORD has not asked for bad things to happen to these people. So I cannot do that either. ");
INSERT INTO engerv_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","I see these people from the mountain. I see them from the high hills. They live alone. They are not part of another nation. ");
INSERT INTO engerv_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Who can count Jacob’s people? They are as many as the grains of dust. No one can count even a fourth of the Israelites. Let me die like a good man. Let my life end as happy as theirs!” ");
INSERT INTO engerv_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak said to Balaam, “What have you done to me? I brought you here to curse my enemies, but you have blessed them!” ");
INSERT INTO engerv_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","But Balaam answered, “I must say the things that the LORD tells me to say.” ");
INSERT INTO engerv_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Then Balak said to him, “So come with me to another place. At that place you can see more of these people. You cannot see all of them—you can only see part of them. Maybe from that place you can curse them for me.” ");
INSERT INTO engerv_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","So Balak led Balaam to Watchmen Hills. This was on top of Mount Pisgah. There Balak built seven altars and killed a bull and a ram on each altar as a sacrifice. ");
INSERT INTO engerv_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Then Balaam said to Balak, “Stay here by this altar while I go meet with God over there.” ");
INSERT INTO engerv_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","So the LORD came to Balaam and told Balaam what to say. Then he told Balaam to go back to Balak and say these things. ");
INSERT INTO engerv_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","So Balaam went to Balak. Balak was still standing near the altar. The leaders of Moab were there with him. Balak saw Balaam coming and said, “What did the LORD say?” ");
INSERT INTO engerv_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Then Balaam said this: “Stand up, Balak, and listen to me. Hear me, Balak son of Zippor. ");
INSERT INTO engerv_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","God is not a man; he will not lie. God is not a human being; his decisions will not change. If he says he will do something, then he will do it. If he makes a promise, then he will do what he promised. ");
INSERT INTO engerv_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","He told me to bless them. He blessed them, so I cannot change that. ");
INSERT INTO engerv_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","God saw no wrong in Jacob’s people. He saw no sin in the Israelites. The LORD is their God, and he is with them. The Great King is with them! ");
INSERT INTO engerv_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","God brought them out of Egypt. They are as strong as a wild ox. ");
INSERT INTO engerv_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","There is no power that can defeat the people of Jacob. There is no magic that can stop the Israelites. People will say this about Jacob and the Israelites: ‘Look at the great things God did!’ ");
INSERT INTO engerv_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","The people are as strong as lions, and they fight like lions. And a lion will not rest until it eats what it has caught, until it drinks the blood of what it has killed.” ");
INSERT INTO engerv_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Then Balak said to Balaam, “You didn’t ask for good things to happen to these people, but you didn’t ask for bad things to happen to them either!” ");
INSERT INTO engerv_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam answered, “I told you before that I can only say what the LORD tells me to say.” ");
INSERT INTO engerv_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Then Balak said to Balaam, “So come with me to another place. Maybe God will be pleased and will allow you to curse them from that place.” ");
INSERT INTO engerv_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","So Balak led Balaam to the top of Mount Peor, which looks out over the desert. ");
INSERT INTO engerv_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam said, “Build seven altars here. Then prepare seven bulls and seven rams for the altars.” ");
INSERT INTO engerv_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak did what Balaam asked. Balak offered the bulls and rams on the altars. ");
INSERT INTO engerv_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam saw that the LORD wanted to bless Israel, so he did not try to change that by using any kind of magic. But Balaam turned and looked toward the desert. ");
INSERT INTO engerv_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","He looked out across the desert and saw all the Israelites. They were camped with the tribes in their different areas. Then the Spirit of God came on him, ");
INSERT INTO engerv_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","and he gave this message: “This message is from Balaam son of Beor. I am speaking about things I see clearly. ");
INSERT INTO engerv_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","These are the words I heard from God. I saw what God All-Powerful showed me. I humbly tell what I clearly see. ");
INSERT INTO engerv_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“People of Jacob, your tents are beautiful! Israelites, your homes are beautiful! ");
INSERT INTO engerv_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","You are like rows of palm trees planted by the streams. You are like gardens growing by the rivers. You are like sweet-smelling bushes planted by the LORD. You are like cedar trees growing by the water. ");
INSERT INTO engerv_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","You will always have enough water, enough water for your seeds to grow. Your king will be greater than King Agag. Your kingdom will be very great. ");
INSERT INTO engerv_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“God brought them out of Egypt. They are as strong as a wild ox. They will defeat all their enemies. They will break their bones and shatter their arrows. ");
INSERT INTO engerv_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Israel is like a lion, curled up and lying down. Yes, they are like a young lion, and no one wants to wake him! Anyone who blesses you will be blessed. And anyone who curses you will have great troubles.” ");
INSERT INTO engerv_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","When Balak heard this, he angrily struck his fist against his hand and said to Balaam, “I called you to come and curse my enemies. But you have blessed them. You have blessed them three times. ");
INSERT INTO engerv_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Now leave and go home! I told you that I would give you a very good payment, but the LORD has caused you to lose your reward.” ");
INSERT INTO engerv_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam said to Balak, “You sent men to ask me to come. Don’t you remember what I told them? I said, ");
INSERT INTO engerv_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Even if Balak gives me his most beautiful house filled with silver and gold, I can still say only what the LORD commands me to say. I cannot do anything myself, good or bad. I must say what the LORD commands.’ ");
INSERT INTO engerv_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Now I am going back to my own people. But I will give you this warning. I will tell you what these Israelites will do to you and your people in the future.” ");
INSERT INTO engerv_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Then Balaam gave this message: “This message is from Balaam son of Beor. I am speaking about things I see clearly. ");
INSERT INTO engerv_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","I heard this message from God. I learned what God Most High taught me. I saw what God All-Powerful showed me. I humbly tell what I clearly see. ");
INSERT INTO engerv_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“I see him coming, but not now. I see him coming, but not soon. A star will come from the family of Jacob. A new ruler will come from the Israelites. He will smash the heads of the Moabites and crush the heads of all the sons of Sheth. ");
INSERT INTO engerv_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Israel will grow strong! He will get the land of Edom. He will get the land of Seir, his enemy. ");
INSERT INTO engerv_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“A new ruler will come from the family of Jacob. That ruler will destroy the people left alive in that city.” ");
INSERT INTO engerv_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Then Balaam saw the Amalekites and said this: “Amalek is the strongest of all nations, but even Amalek will be destroyed!” ");
INSERT INTO engerv_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Then Balaam saw the Kenites and said this: “You believe that your country is safe, like a bird’s nest high on a mountain. ");
INSERT INTO engerv_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","But you Kenites will be destroyed, just as the Lord destroyed Cain. Assyria will make you prisoners.” ");
INSERT INTO engerv_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Then Balaam said this: “No one can live when God does this. ");
INSERT INTO engerv_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ships will come from Cyprus. They will defeat Assyria and Eber, but those ships will also be destroyed.” ");
INSERT INTO engerv_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Then Balaam got up and went back home, and Balak went his own way. ");
INSERT INTO engerv_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","While the Israelites were camped near Acacia, the men committed sexual sins with Moabite women. ");
INSERT INTO engerv_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","The Moabite women invited the men to come and join in their sacrifices to their false gods. So the Israelites joined in worshiping these false gods—they ate the sacrifices and worshiped these gods. There the Israelites began worshiping the false god, Baal of Peor. And the LORD became very angry with them. ");
INSERT INTO engerv_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","The LORD said to Moses, “Get all the leaders of these people. Then kill them so that all the people can see. Lay their bodies before the LORD. Then the LORD will not show his anger against all the Israelites.” ");
INSERT INTO engerv_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","So Moses said to Israel’s judges, “Each of you must find the men in your tribe who have led people to worship the false god, Baal of Peor. Then you must kill these men.” ");
INSERT INTO engerv_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","At the time Moses and all the elders of Israel were gathered together at the entrance to the Meeting Tent. An Israelite man brought a Midianite woman home to his brothers. He did this where Moses and all the leaders could see. Moses and the leaders were very sad. ");
INSERT INTO engerv_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Phinehas was the son of Eleazar and the grandson of Aaron the priest. Phinehas saw this man bring the woman into camp. So he left the meeting and got his spear. ");
INSERT INTO engerv_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","He followed the Israelite into the tent. Then he used the spear to kill the Israelite man and the Midianite woman in her tent. He pushed the spear through both of their bodies. At that time there was a great sickness among the Israelites. But when Phinehas killed these two people, the sickness stopped. ");
INSERT INTO engerv_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","A total of 24,000 people died from that sickness. ");
INSERT INTO engerv_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“I was so angry with the Israelites that I wanted to kill them. But Phinehas, son of Eleazar and grandson of Aaron the priest, has saved them from my anger. He did this by showing that he feels strongly, just as I do, that my people must worship only me. ");
INSERT INTO engerv_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Tell Phinehas that I am making a peace agreement with him. ");
INSERT INTO engerv_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","This is the agreement: He and all of his family who live after him will always be priests, because he had strong feelings for his God. And he did what was needed to make the Israelites pure.” ");
INSERT INTO engerv_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","The Israelite man who was killed with the Midianite woman was named Zimri son of Salu. He was the leader of a family in the tribe of Simeon. ");
INSERT INTO engerv_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","And the name of the Midianite woman who was killed was Cozbi. She was the daughter of Zur. Zur was the head of a family and leader of a Midianite tribe. ");
INSERT INTO engerv_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“The Midianites are your enemies. You must kill them. ");
INSERT INTO engerv_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","They have already made you their enemies. They tricked you at Peor. And they tricked you with the woman named Cozbi. She was the daughter of a Midianite leader, but she was killed when the sickness came to the Israelites. That sickness was caused because the people were tricked into worshiping the false god Baal of Peor.” ");
INSERT INTO engerv_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","After the great sickness, the LORD spoke to Moses and Eleazar son of Aaron the priest. ");
INSERT INTO engerv_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","He said, “Count the Israelites. Count all the men who are 20 years old or older and list them by families. These are the men who are able to serve in the army of Israel.” ");
INSERT INTO engerv_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","At this time the people were camped in the Jordan Valley in Moab. This was near the Jordan River, across from Jericho. So Moses and Eleazar the priest spoke to the people. They said, ");
INSERT INTO engerv_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“You must count every man who is 20 years old or older. The LORD gave Moses this command.” Here is the list of the Israelites who came out of Egypt: ");
INSERT INTO engerv_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","These are the people from the tribe of Reuben. (Reuben was the firstborn son of Israel.) The family groups were Hanoch—the Hanochite family group; Pallu—the Palluite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron—the Hezronite family group; Carmi—the Carmite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","The total number of men in these family groups from the tribe of Reuben was 43,730. ");
INSERT INTO engerv_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu’s son was Eliab. ");
INSERT INTO engerv_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab had three sons—Nemuel, Dathan, and Abiram. Remember, Dathan and Abiram were the two leaders who turned against Moses and Aaron. They followed Korah when Korah turned against the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","That was the time when the earth opened and swallowed Korah and all of his followers. And 250 men died! That was a warning to all the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","But the other people who were from the family of Korah did not die. ");
INSERT INTO engerv_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","These are the family groups from the tribe of Simeon: Nemuel—the Nemuelite family group; Jamin—the Jaminite family group; Jakin—the Jakinite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah—the Zerahite family group; Shaul—the Shaulite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","The total number of men in these family groups from the tribe of Simeon was 22,200. ");
INSERT INTO engerv_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","These are the family groups in the tribe of Gad: Zephon—the Zephonite family group; Haggi—the Haggite family group; Shuni—the Shunite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni—the Oznite family group; Eri—the Erite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi—the Arodite family group; Areli—the Arelite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","The total number of men in these family groups from the tribe of Gad was 40,500. ");
INSERT INTO engerv_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","These are the family groups from the tribe of Judah: Shelah—the Shelanite family group; Perez—the Perezite family group; Zerah—the Zerahite family group. (Two of Judah’s sons, Er and Onan, died in Canaan.) ");
INSERT INTO engerv_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","These are the family groups from Perez: Hezron—the Hezronite family group; Hamul—the Hamulite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","These were the family groups from the tribe of Judah. The total number of men was 76,500. ");
INSERT INTO engerv_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","The family groups from the tribe of Issachar were Tola—the Tolaite family group; Puah—the Puite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub—the Jashubite family group; Shimron—the Shimronite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","These were the family groups from the tribe of Issachar. The total number of men was 64,300. ");
INSERT INTO engerv_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","The family groups from the tribe of Zebulun were Sered—the Seredite family group; Elon—the Elonite family group; Jahleel—the Jahleelite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","These were the family groups from the tribe of Zebulun. The total number of men was 60,500. ");
INSERT INTO engerv_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Joseph’s two sons were Manasseh and Ephraim. Each son became a tribe with its own family groups. ");
INSERT INTO engerv_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasseh’s family groups were Makir—the Makirite family groups. (Makir was the father of Gilead.) Gilead—the Gileadite family groups. ");
INSERT INTO engerv_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","The family groups from Gilead were Iezer—the Iezerite family group; Helek—the Helekite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel—the Asrielite family group; Shechem—the Shechemite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida—the Shemidaite family group; Hepher—the Hepherite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelophehad was the son of Hepher. But he had no sons—only daughters. His daughters’ names were Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engerv_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","These are all the family groups from the tribe of Manasseh. The total number of men was 52,700. ");
INSERT INTO engerv_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","The family groups from the tribe of Ephraim were Shuthelah—the Shuthelahite family group; Beker—the Bekerite family group; Tahan—the Tahanite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Eran was from Shuthelah’s family group; Eran—the Eranite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","These were the family groups from the tribe of Ephraim. The total number of men was 32,500. These family groups of Manasseh and Ephraim are all the descendants of Joseph. ");
INSERT INTO engerv_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","The family groups from the tribe of Benjamin were Bela—the Belaite family group; Ashbel—the Ashbelite family group; Ahiram—the Ahiramite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shupham—the Shuphamite family group; Hupham—the Huphamite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","The family groups from Bela were Ard—the Ardite family group; Naaman—the Naamanite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","These were all the family groups from the tribe of Benjamin. The total number of men was 45,600. ");
INSERT INTO engerv_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","The family groups from the tribe of Dan were Shuham—the Shuhamite family group. That was the family group from the tribe of Dan. ");
INSERT INTO engerv_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","There were many family groups in the Shuhamite tribe. The total number of men was 64,400. ");
INSERT INTO engerv_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","The family groups from the tribe of Asher were Imnah—the Imnite family group; Ishvi—the Ishvite family group; Beriah—the Beriite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","The family groups from Beriah were Heber—the Heberite family group; Malkiel—the Malkielite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Asher also had a daughter named Serah.) ");
INSERT INTO engerv_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","These were the family groups in the tribe of Asher. The total number of men was 53,400. ");
INSERT INTO engerv_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","The family groups from the tribe of Naphtali were Jahzeel—the Jahzeelite family group; Guni—the Gunite family group; ");
INSERT INTO engerv_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer—the Jezerite family group; Shillem—the Shillemite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","These were the family groups from the tribe of Naphtali. The total number of men was 45,400. ");
INSERT INTO engerv_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","So the total number of men of Israel was 601,730. ");
INSERT INTO engerv_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","The LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“The land will be divided and given to these people. Each tribe will get enough land for all the people who were counted. ");
INSERT INTO engerv_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A large tribe will get much land, and a small tribe will get less land. The land that they get will be equal to the number of people who were counted. ");
INSERT INTO engerv_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","But you must use lots to decide which tribe gets which part of the land. Each tribe will get its share of the land, and that land will be given the name of that tribe. ");
INSERT INTO engerv_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Land will be given to each tribe—large and small. And you will throw lots to make the decisions.” ");
INSERT INTO engerv_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","They also counted the tribe of Levi. These are the family groups from the tribe of Levi: Gershon—the Gershonite family group; Kohath—the Kohathite family group; Merari—the Merarite family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","These are also family groups from the tribe of Levi: the Libnite family group; the Hebronite family group; the Mahlite family group; the Mushite family group; the Korahite family group. Amram was from the Kohath family group. ");
INSERT INTO engerv_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram’s wife was named Jochebed. She was also from the tribe of Levi. She was born in Egypt. Amram and Jochebed had two sons, Aaron and Moses. They also had a daughter, Miriam. ");
INSERT INTO engerv_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron was the father of Nadab, Abihu, Eleazar, and Ithamar. ");
INSERT INTO engerv_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","But Nadab and Abihu died. They died because they made an offering to the LORD with fire that was not allowed. ");
INSERT INTO engerv_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","The total number of males one month or older from the tribe of Levi was 23,000. But these men were not counted with the other Israelites. They did not get a share of the land that the Lord gave to the other people. ");
INSERT INTO engerv_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Moses and Eleazar the priest counted all these people. They counted the Israelites while they were in the Jordan Valley in Moab. This was near the Jordan River across from Jericho. ");
INSERT INTO engerv_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Many years before, in the desert of Sinai, Moses and Aaron the priest counted the Israelites. But all these people were dead. Not one of them was still alive, ");
INSERT INTO engerv_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","because the LORD told them that they would all die in the desert. The only two men who were left alive were Caleb son of Jephunneh and Joshua son of Nun. ");
INSERT INTO engerv_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Zelophehad was the son of Hepher. Hepher was the son of Gilead. Gilead was the son of Makir. Makir was the son of Manasseh. Manasseh was the son of Joseph. Zelophehad had five daughters. Their names were Mahlah, Noah, Hoglah, Milcah, and Tirzah. ");
INSERT INTO engerv_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","These five women went to the Meeting Tent and stood before Moses, Eleazar the priest, the leaders, and all the Israelites. The five daughters said, ");
INSERT INTO engerv_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Our father died while we were traveling through the desert. He died a natural death. He was not one of the men who joined Korah’s group. (Korah was the man who turned against the LORD.) But our father had no sons. ");
INSERT INTO engerv_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","This means that our father’s name will not continue. It is not fair that our father’s name will not continue. His name will end because he had no sons. So we ask you to give us some of the land that our father’s brothers will get.” ");
INSERT INTO engerv_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","So Moses asked the LORD what he should do. ");
INSERT INTO engerv_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","The LORD said to him, ");
INSERT INTO engerv_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“The daughters of Zelophehad are right. They should share the land with their father’s brothers. So give them the land that you would have given to their father. ");
INSERT INTO engerv_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“So tell the Israelites, ‘If a man has no son, when he dies everything he owns will be given to his daughter. ");
INSERT INTO engerv_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","If he has no daughter, everything he owns will be given to his brothers. ");
INSERT INTO engerv_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","If he has no brothers, everything he owns will be given to his father’s brothers. ");
INSERT INTO engerv_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","If his father had no brothers, everything he owns will be given to the closest relative in his family. This will be a law among the Israelites. The LORD has given this command to Moses.’” ");
INSERT INTO engerv_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Then the LORD said to Moses, “Go up on one of mountains in the desert east of the Jordan River. There you will see the land that I am giving to the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","After you have seen this land, you will die like your brother Aaron. ");
INSERT INTO engerv_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Remember when the people became angry at the water in the desert of Zin. Both you and Aaron refused to obey my command. You did not honor me and show the people that I am holy.” (This was at the water of Meribah near Kadesh in the desert of Zin.) ");
INSERT INTO engerv_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moses said to the LORD, ");
INSERT INTO engerv_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“LORD, you are the God who knows what people are thinking. I pray that you will choose a leader for these people. ");
INSERT INTO engerv_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","I pray that you will choose a leader who will lead them out of this land and bring them into the new land. Then your people will not be like sheep without a shepherd.” ");
INSERT INTO engerv_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","So the LORD said to Moses, “Joshua son of Nun is very wise. You will place your hand on him and make him the new leader. ");
INSERT INTO engerv_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Tell him to stand before Eleazar the priest and all the people. Then make him the new leader. ");
INSERT INTO engerv_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“Show the people that you are making him leader, then all the people will obey him. ");
INSERT INTO engerv_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","If Joshua needs to make a decision, he will go to Eleazar the priest. Eleazar will use the Urim to learn the LORD’S answer. Then Joshua and all the Israelites will do the things God says. If he says, ‘go to war,’ they will go to war. And if he says, ‘go home,’ they will go home.” ");
INSERT INTO engerv_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moses obeyed the LORD. Moses told Joshua to stand before Eleazar the priest and all the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Then Moses put his hands on him to show that he was the new leader. He did this just as the LORD told him to. ");
INSERT INTO engerv_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Then the LORD spoke to Moses. He said, ");
INSERT INTO engerv_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Give this command to the Israelites. Tell them to be sure to give the grain offerings and sacrifices to me at the right time as sweet-smelling gifts. ");
INSERT INTO engerv_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","These are gifts that they must give to the LORD. Every day they must give 2 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Offer one of the lambs in the morning and the other lamb just before dark. ");
INSERT INTO engerv_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Also give a grain offering of 8 cups of fine flour mixed with 1 quart of olive oil.” ");
INSERT INTO engerv_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(They started giving the daily offerings at Mount Sinai as sweet-smelling gifts to the LORD.) ");
INSERT INTO engerv_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","“The people must also give the drink offerings that go with the gifts. They must give 1 quart of wine with every lamb. Pour that drink offering on the altar in the Holy Place. This is a gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Offer the second lamb just before dark. Offer it just as the morning offering. Also give the drink offering that goes with it. This will be a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“On the Sabbath you must give 2 lambs that are one year old. There must be nothing wrong with them. You must also give a grain offering of 16 cups of fine flour mixed with olive oil, and a drink offering. ");
INSERT INTO engerv_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","This is a special offering for the day of rest. This offering is in addition to the regular daily offering and drink offering. ");
INSERT INTO engerv_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“On the first day of each month you will offer a special burnt offering to the LORD. This offering will be 2 male bulls, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","With each bull, you must give a grain offering of 24 cups of fine flour mixed with olive oil. And with the ram, you must give a grain offering of 16 cups of fine flour mixed with olive oil. ");
INSERT INTO engerv_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Also give a grain offering of 8 cups of fine flour mixed with olive oil with each lamb. This will be a sweet-smelling gift to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","The drink offering will be 2 quarts of wine with each bull, 1 1/4 quarts of wine with the ram, and 1 quart of wine with each lamb. That is the burnt offering that must be offered each month of the year. ");
INSERT INTO engerv_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","In addition to the regular daily burnt offering and drink offering, you must also give 1 male goat to the LORD. That goat will be a sin offering. ");
INSERT INTO engerv_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“The LORD’S Passover will be on the 14th day of the first month. ");
INSERT INTO engerv_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","The Festival of Unleavened Bread begins on the 15th day of that month. This festival lasts for seven days. The only bread you can eat is bread made without yeast. ");
INSERT INTO engerv_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","You must have a special meeting on the first day of this festival. You will not do any work on that day. ");
INSERT INTO engerv_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","You will give burnt offerings to the LORD. The burnt offerings will be 2 bulls, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","21","You must also give a grain offering of 24 cups of fine flour mixed with olive oil with each bull, and 16 cups of fine flour mixed with oil with the ram, and 8 cups of fine flour mixed with oil for each lamb. ");
INSERT INTO engerv_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","You must also give a male goat as a sin offering to make you pure. ");
INSERT INTO engerv_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","You must give these offerings in addition to the morning burnt offerings that you give every day. ");
INSERT INTO engerv_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“In this way, each day for seven days, you must bring the food that is offered by fire. The smell of these offerings will please the LORD. You must give these offerings in addition to the daily burnt offering and the drink offering that goes with it. ");
INSERT INTO engerv_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“Then, on the seventh day of this festival, you will have another special meeting. You will not do any work on that day. ");
INSERT INTO engerv_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“The first day of the Festival of Harvest is the day you bring the first of your new crops and give them as a grain offering to the LORD. At that time you must also call a special meeting. You must not do any work on that day. ");
INSERT INTO engerv_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","You must offer a burnt offering as a sweet-smelling gift to the LORD. You must offer 2 bulls, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","You must also give 24 cups of fine flour mixed with oil with each bull, and 16 cups with each ram, ");
INSERT INTO engerv_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","and 8 cups with each lamb. ");
INSERT INTO engerv_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","You must also sacrifice a male goat to make you pure. ");
INSERT INTO engerv_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","You must give these offerings in addition to the daily burnt offerings and the grain offering you give with them. Be sure there is nothing wrong with the animals or the drink offerings that you give with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“There will be a special meeting on the first day of the seventh month. You will not do any work on that day. That is the day for blowing the trumpets. ");
INSERT INTO engerv_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","You will offer burnt offerings. Their smell will please the LORD. You will offer 1 bull, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","You will also offer 24 cups of fine flour mixed with oil with the bull, 16 cups with the ram, ");
INSERT INTO engerv_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","and 8 cups with each of the 7 lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Also offer a male goat as a sin offering to make you pure. ");
INSERT INTO engerv_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","These offerings are in addition to the New Moon sacrifice and its grain offering. And they are in addition to the daily sacrifice and its grain offerings and drink offerings. These must be done according to the rules. They will be sweet-smelling gifts to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“There will be a special meeting on the tenth day of the seventh month. During that day you must not eat any food, and you must not do any work. ");
INSERT INTO engerv_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","You will offer burnt offerings. Their smell will please the LORD. You must offer 1 bull, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","You must also offer 24 cups of fine flour mixed with olive oil with the bull, 16 cups with the ram, ");
INSERT INTO engerv_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","and 8 cups with each of the 7 lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","You will also offer 1 male goat as a sin offering. This will be in addition to the sin offering for the Day of Atonement. This will also be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“There will be a special meeting on the 15th day of the seventh month. You must not do any work on that day. You must celebrate a special festival for the LORD for seven days. ");
INSERT INTO engerv_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","You will offer burnt offerings as sweet-smelling gifts to the LORD. You will offer 13 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","You must also offer 24 cups of fine flour mixed with oil with each of the 13 bulls, 16 cups with each of the 2 rams, ");
INSERT INTO engerv_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","and 8 cups with each of the 14 lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","You must also offer 1 male goat. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“On the second day of this festival, you must offer 12 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","You must also give the right amount of grain and drink offerings with the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","You must also offer 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“On the third day of this festival, you must offer 11 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","You must also give the right amount of grain and drink offerings with the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","You must also give 1 goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“On the fourth day of this festival, you must offer 10 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","You must also give the right amount of grain and drink offerings with the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","You must also give 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“On the fifth day of this festival, you must offer 9 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","You must also give the right amount of grain and drink offerings with the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","You must also give 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“On the sixth day of this festival, you must offer 8 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","You must also give the right amount of grain and drink offerings for the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","You must also give 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“On the seventh day of this festival, you must offer 7 bulls, 2 rams, and 14 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","You must also give the right amount of grain and drink offerings with the bulls, rams, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","You must also give 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“The eighth day of this festival is a very special meeting for you. You must not do any work on that day. ");
INSERT INTO engerv_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","You must offer a burnt offering as a sweet-smelling gift to the LORD. You must offer 1 bull, 1 ram, and 7 lambs that are one year old. There must be nothing wrong with them. ");
INSERT INTO engerv_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","You must also give the right amount of grain and drink offerings with the bull, ram, and lambs. ");
INSERT INTO engerv_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","You must also give 1 male goat as a sin offering. This must be in addition to the daily sacrifice and its grain offerings and drink offerings. ");
INSERT INTO engerv_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“At the special festivals you must bring your burnt offerings, grain offerings, drink offerings, and fellowship offerings. You must give these offerings to the LORD. They are in addition to any special gift you might want to give him and any offering that is part of a special promise you make.” ");
INSERT INTO engerv_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moses told the Israelites everything the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moses spoke with all the leaders of the Israelite tribes and told them about these commands from the LORD: ");
INSERT INTO engerv_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“If a man makes a special promise to the LORD or makes a promise with an oath, he must not break his promise. He must do everything he said he would do. ");
INSERT INTO engerv_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“A young woman might still be living in her father’s house. And that young woman might make a special promise to give something to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","If her father hears about the promise and agrees, the young woman must do what she promised. ");
INSERT INTO engerv_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","But if her father hears about the promise and does not agree, she is free from her promise. She does not have to do what she promised. Her father stopped her, so the LORD will forgive her. ");
INSERT INTO engerv_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“A woman might make a special promise to give something to the Lord and then get married. ");
INSERT INTO engerv_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","If the husband hears about the promise and does not object, the woman must do what she promised. ");
INSERT INTO engerv_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","But if the husband hears about the promise and refuses to let her keep her promise, the wife does not have to do what she promised. Her husband broke the promise—he did not let her do what she said. So the LORD will forgive her. ");
INSERT INTO engerv_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“A widow or a divorced woman might make a special promise. If she does, she must do exactly what she promised. ");
INSERT INTO engerv_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“A married woman might make a promise to give something to the Lord. ");
INSERT INTO engerv_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","If her husband hears about the promise and lets her keep her promise, she must do exactly what she promised. She must give everything she promised. ");
INSERT INTO engerv_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","But if her husband hears about the promise and refuses to let her keep the promise, she does not have to do what she promised. It doesn’t matter what she promised to do; if her husband is against it, this ends her duty to do it. And the LORD will forgive her. ");
INSERT INTO engerv_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","A married woman might promise to give something to the LORD, or she might promise to do without something, or she might make some other special promise to God. The husband can stop any of these promises, and the husband can let her keep any of these promises. ");
INSERT INTO engerv_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","How does the husband let his wife keep her promises? If he hears about the promises and does not stop them, the woman must do exactly what she promised. ");
INSERT INTO engerv_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","But if the husband hears about the promises and stops them, he is responsible for breaking her promises.” ");
INSERT INTO engerv_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","These are the commands that the LORD gave to Moses. These are the commands about a man and his wife, and about a father and his daughter who is still young and living at home in her father’s house. ");
INSERT INTO engerv_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","The LORD spoke to Moses and said, ");
INSERT INTO engerv_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Moses, tell the Israelites this: ‘Go and attack the Midianites, and do to them what they did to you.’ After that Moses, you will die.” ");
INSERT INTO engerv_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","So Moses spoke to the people. He said, “Choose some of your men to be soldiers. The LORD will use these men to do to the Midianites what they did to you. ");
INSERT INTO engerv_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Choose 1000 men from each of the tribes of Israel. ");
INSERT INTO engerv_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","There will be a total of 12,000 soldiers from the tribes of Israel.” ");
INSERT INTO engerv_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moses sent these 12,000 men to war. He sent Phineas son of Eleazar with them as the priest. Phineas took the holy things and the horns and trumpets with him. ");
INSERT INTO engerv_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","The Israelites fought the Midianites as the LORD had commanded. They killed all the Midianite men. ");
INSERT INTO engerv_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Among the people who they killed were Evi, Rekem, Zur, Hur, and Reba—the five kings of Midian. They also killed Balaam son of Beor with a sword. ");
INSERT INTO engerv_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","The Israelites took the Midianite women and children as prisoners. They also took all their sheep, cattle, and other things. ");
INSERT INTO engerv_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Then they burned all their towns and villages. ");
INSERT INTO engerv_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","They took all the people and animals ");
INSERT INTO engerv_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","and brought them to Moses, Eleazar the priest, and all the other Israelites. They brought all the things they took in war to the camp of Israel. The Israelites were camped in the Jordan Valley in Moab, on the east side of the Jordan River across from Jericho. ");
INSERT INTO engerv_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Then Moses, Eleazar the priest, and the leaders of the people went out of the camp to meet with the soldiers. ");
INSERT INTO engerv_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moses was very angry with the leaders of the army, the commanders of 1000 men, and the commanders of 100 men, who came back from the war. ");
INSERT INTO engerv_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moses said to them, “Why did you let the women live? ");
INSERT INTO engerv_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","These are the women who listened to Balaam and caused the men of Israel to turn away from the LORD that time at Peor. The disease will come to the LORD’S people again. ");
INSERT INTO engerv_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Now, kill all the Midianite boys, and kill all the Midianite women who have had sexual relations with a man. ");
INSERT INTO engerv_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","You can let all the young girls live—but only if they never had sexual relations with any man. ");
INSERT INTO engerv_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","And then, all you men who killed other people must stay outside the camp for seven days. You must stay outside the camp even if you just touched a dead body. On the third day you and your prisoners must make yourselves pure. You must do the same thing again on the seventh day. ");
INSERT INTO engerv_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","You must wash all of your clothes. You must wash anything made with leather, wool, or wood. You must purify yourselves.” ");
INSERT INTO engerv_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Then Eleazar the priest spoke to the soldiers. He said, “These are the rules that the LORD gave to Moses for soldiers coming back from war. ");
INSERT INTO engerv_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","You must put gold, silver, bronze, iron, tin, or lead into the fire and then wash these things with the special water to make them pure. If something can be put in the fire, you must put it in fire to purify it. If things cannot be put in fire, you must still wash them with the special water. ");
INSERT INTO engerv_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","On the seventh day you must wash all of your clothes. Then you will be pure. After that you can come into camp.” ");
INSERT INTO engerv_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Then the LORD said to Moses, ");
INSERT INTO engerv_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“You, Eleazar the priest, and all the leaders should count all the prisoners, animals, and everything the soldiers took in war. ");
INSERT INTO engerv_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Then divide these things between the soldiers who went to war and the rest of the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Take part of these things from the soldiers who went to war. That part will belong to the LORD. His share is one from every 500 items. This includes people, cattle, donkeys, and sheep. ");
INSERT INTO engerv_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Take that share from the soldiers’ half of the things they took in war. Then give these things to Eleazar the priest. That part will belong to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","And then, from the people’s half, take one thing for every 50 items. This includes people, cattle, donkeys, sheep, or any other animal. Give that share to the Levites, because they take care of the LORD’S Holy Tent.” ");
INSERT INTO engerv_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","So Moses and Eleazar did what the LORD commanded Moses. ");
INSERT INTO engerv_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","The soldiers had taken 675,000 sheep, ");
INSERT INTO engerv_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","72,000 cattle, ");
INSERT INTO engerv_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","61,000 donkeys, ");
INSERT INTO engerv_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","and 32,000 women. (These are only the women who had not had sexual relations with any man.) ");
INSERT INTO engerv_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","The soldiers who went to war got 337,500 sheep. ");
INSERT INTO engerv_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","They gave 675 sheep to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","The soldiers got 36,000 cattle. They gave 72 cattle to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","The soldiers got 30,500 donkeys. They gave 61 donkeys to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","The soldiers got 16,000 women. They gave 32 women to the LORD. ");
INSERT INTO engerv_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moses gave all these gifts for the LORD to Eleazar the priest, as the LORD had commanded him. ");
INSERT INTO engerv_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Then Moses counted the people’s half. This was their share that Moses had taken from the soldiers who had gone to war. ");
INSERT INTO engerv_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","The people got 337,500 sheep, ");
INSERT INTO engerv_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","36,000 cattle, ");
INSERT INTO engerv_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","30,500 donkeys, ");
INSERT INTO engerv_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","and 16,000 women. ");
INSERT INTO engerv_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Moses took one out of every 50 women and animals. He gave them to the Levites because they took care of the LORD’S Holy Tent. Moses did this as the LORD had commanded. ");
INSERT INTO engerv_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Then the leaders of the army (the leaders over 1000 men and the leaders over 100 men) came to Moses. ");
INSERT INTO engerv_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","They told Moses, “We, your servants, have counted our soldiers. We have not missed any of them. ");
INSERT INTO engerv_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","So we are bringing the LORD’S gift from every soldier. We are bringing things that are made of gold—armbands, bracelets, rings, earrings, and necklaces. This gift to the LORD is to make us pure.” ");
INSERT INTO engerv_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","So Moses and Eleazar the priest accepted all these gold items from them. ");
INSERT INTO engerv_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","The gold that the commanders and captains gave to the LORD weighed about 424 pounds. ");
INSERT INTO engerv_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","The soldiers kept the rest of their share of the things they took in war. ");
INSERT INTO engerv_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moses and Eleazar the priest took the gold from the commanders and captains and then put that gold in the Meeting Tent. This present was a memorial before the LORD for the Israelites. ");
INSERT INTO engerv_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","The tribes of Reuben and Gad had many cattle. These people looked at the land near Jazer and Gilead. They saw that this land was good for their cattle. ");
INSERT INTO engerv_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","So the people from the tribes of Reuben and Gad came to Moses. They spoke to Moses, Eleazar the priest, and the leaders of the people. ");
INSERT INTO engerv_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","They said, “We, your servants, have many cattle. And the land that the LORD let the people of Israel capture is good land for cattle. This land includes the area around Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sibmah, Nebo, and Beon. ");
INSERT INTO engerv_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","If it pleases you, we would like this land to be given to us. Don’t take us to the other side of the Jordan River.” ");
INSERT INTO engerv_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moses told the people from the tribes of Reuben and Gad, “Will you let your brothers go and fight while you settle here? ");
INSERT INTO engerv_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Why are you trying to discourage the Israelites? You will make them not want to cross the river and take the land that the LORD has given to them! ");
INSERT INTO engerv_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Your fathers did the same thing to me. In Kadesh Barnea I sent spies to look at the land. ");
INSERT INTO engerv_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","These men went as far as Eshcol Valley. They saw the land, and they discouraged the Israelites. These men made the Israelites not want to go into the land that the LORD had given to them. ");
INSERT INTO engerv_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","The LORD became very angry with the people. He made this promise: ");
INSERT INTO engerv_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘None of the people who came from Egypt and are 20 years old or older will be allowed to see this land. I made a promise to Abraham, Isaac, and Jacob. I promised to give this land to these people, but they did not really follow me. ");
INSERT INTO engerv_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Only Caleb son of Jephunneh the Kenizzite and Joshua son of Nun really followed the LORD!’ ");
INSERT INTO engerv_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“The LORD was very angry with the Israelites. So he made the people stay in the desert for 40 years. He made them stay there until all the people who had sinned against the LORD were dead. ");
INSERT INTO engerv_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","And now you are doing the same thing that your fathers did. You sinful people, do you want the LORD to be even more angry with his people? ");
INSERT INTO engerv_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","If you stop following the Lord, he will make Israel stay even longer in the desert. Then you will destroy all these people!” ");
INSERT INTO engerv_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","But the people from the tribes of Reuben and Gad went to Moses. They said, “We will build cities for our children and barns for our animals here. ");
INSERT INTO engerv_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Then our children can be safe from the other people who live in this land. But we will gladly come and help the other Israelites. We will bring them to their land. ");
INSERT INTO engerv_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","We will not come back home until everyone in Israel has taken his part of the land. ");
INSERT INTO engerv_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","We will not take any of the land west of the Jordan River. No, our part of the land is east of the Jordan River.” ");
INSERT INTO engerv_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","So Moses told them, “If you do all these things, this land will belong to you. But your soldiers must go before the LORD into battle. ");
INSERT INTO engerv_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Your soldiers must cross the Jordan River and be ready to fight for the LORD until he forces the enemy to leave. ");
INSERT INTO engerv_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","After the LORD helps us all take the land, you can go back home. Then the LORD and Israel will not think that you are guilty. And the LORD will let you have this land. ");
INSERT INTO engerv_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","But if you don’t do these things, you will be sinning against the LORD. And know for sure that you will be punished for your sin. ");
INSERT INTO engerv_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Build cities for your children and barns for your animals. But then, you must do what you promised.” ");
INSERT INTO engerv_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Then the people from the tribes of Gad and Reuben said to Moses, “We are your servants. You are our master, so we will do what you say. ");
INSERT INTO engerv_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Our wives, children, and all our animals will stay in the cities of Gilead. ");
INSERT INTO engerv_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","But we, your servants, will cross the Jordan River. We will march before the LORD into battle, as our master says.” ");
INSERT INTO engerv_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","So Moses, Eleazar the priest, Joshua son of Nun, and all the leaders of the tribes of Israel heard them make that promise. ");
INSERT INTO engerv_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moses said to them, “The people of Gad and Reuben will cross the Jordan River. They will march before the LORD into battle. They will help you take the land. And you will give the land of Gilead as their part of the country. ");
INSERT INTO engerv_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","But if they do not cross the river with you ready to fight, they will not get any land on this side. They will get only a share of the land of Canaan with the rest of you.” ");
INSERT INTO engerv_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","The people of Gad and Reuben answered, “We promise to do what the LORD commanded. ");
INSERT INTO engerv_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","We will cross the Jordan River and march before the LORD into the land of Canaan. And our part of the country is the land east of the Jordan River.” ");
INSERT INTO engerv_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","So Moses gave that land to the people of Gad, to the people of Reuben, and to half the tribe of Manasseh. (Manasseh was Joseph’s son.) That land included the kingdom of Sihon the Amorite and the kingdom of King Og of Bashan and all the cities around that area. ");
INSERT INTO engerv_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","The people of Gad built the cities of Dibon, Ataroth, Aroer, ");
INSERT INTO engerv_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth Shophan, Jazer, Jogbehah, ");
INSERT INTO engerv_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimrah, and Beth Haran. They built cities with strong walls, and they built barns for their animals. ");
INSERT INTO engerv_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","The people of Reuben built Heshbon, Elealeh, Kiriathaim, ");
INSERT INTO engerv_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon, and Sibmah. They used the names of the cities that they rebuilt. But they changed the names of Nebo and Baal Meon. ");
INSERT INTO engerv_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","People from Makir’s family group went to Gilead. (Makir was Manasseh’s son.) They defeated the city. They defeated the Amorites who lived there. ");
INSERT INTO engerv_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","So Moses gave Gilead to Makir from the tribe of Manasseh, and his family settled there. ");
INSERT INTO engerv_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jair, from the family of Manasseh, defeated the small towns there. Then he called them Towns of Jair. ");
INSERT INTO engerv_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah defeated Kenath and the small towns near it. Then he called that place by his own name. ");
INSERT INTO engerv_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Here is a list of the places the Israelites went when they left Egypt. They were organized in groups like an army and were led by Moses and Aaron. ");
INSERT INTO engerv_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Following the LORD’S command, Moses kept a record of each place they stayed before moving on to the next place. These are all the places they went: ");
INSERT INTO engerv_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","On the 15th day of the first month, they left Rameses. That morning after Passover, the Israelites marched out of Egypt with their arms raised in victory. All the people of Egypt saw them. ");
INSERT INTO engerv_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","The Egyptians were burying all the people the LORD killed. They were burying all their firstborn sons. The LORD had shown his judgment against the gods of Egypt. ");
INSERT INTO engerv_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","The Israelites left Rameses and traveled to Succoth. ");
INSERT INTO engerv_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","From Succoth they traveled to Etham. They camped there at the edge of the desert. ");
INSERT INTO engerv_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","They left Etham and went to Pi Hahiroth. This was near Baal Zephon. They camped near Migdol. ");
INSERT INTO engerv_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","They left Pi Hahiroth and walked through the middle of the sea. They went toward the desert. Then they traveled for three days through the desert of Etham. The people camped at Marah. ");
INSERT INTO engerv_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","They left Marah and went to Elim and camped there. There were 12 springs of water and 70 