﻿USE sofia;
DROP TABLE IF EXISTS sofia.engemtv_vpl;
CREATE TABLE engemtv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES engemtv_vpl WRITE;
INSERT INTO engemtv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","The book of the genealogy of Jesus Christ, the Son of David, the Son of Abraham: ");
INSERT INTO engemtv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham fathered Isaac, Isaac fathered Jacob, and Jacob fathered Judah and his brothers. ");
INSERT INTO engemtv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah fathered Perez and Zerah by Tamar, Perez fathered Hezron, and Hezron fathered Ram. ");
INSERT INTO engemtv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram fathered Amminadab, Amminadab fathered Nahshon, and Nahshon fathered Salmon. ");
INSERT INTO engemtv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon fathered Boaz by Rahab, Boaz fathered Obed by Ruth, Obed fathered Jesse, ");
INSERT INTO engemtv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","and Jesse fathered David the king. David the king fathered Solomon by her who had been the wife of Uriah. ");
INSERT INTO engemtv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon fathered Rehoboam, Rehoboam fathered Abijah, and Abijah fathered Asa. ");
INSERT INTO engemtv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa fathered Jehoshaphat, Jehoshaphat fathered Joram, and Joram fathered Uzziah. ");
INSERT INTO engemtv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah fathered Jotham, Jotham fathered Ahaz, and Ahaz fathered Hezekiah. ");
INSERT INTO engemtv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah fathered Manasseh, Manasseh fathered Amon, and Amon fathered Josiah. ");
INSERT INTO engemtv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah fathered Jeconiah and his brothers at the time of the captivity in Babylon. ");
INSERT INTO engemtv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","And after the captivity in Babylon, Jeconiah fathered Shealtiel, and Shealtiel fathered Zerubbabel. ");
INSERT INTO engemtv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel fathered Abiud, Abiud fathered Eliakim, and Eliakim fathered Azor. ");
INSERT INTO engemtv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor fathered Zadok, Zadok fathered Achim, and Achim fathered Eliud. ");
INSERT INTO engemtv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud fathered Eleazar, Eleazar fathered Matthan, and Matthan fathered Jacob. ");
INSERT INTO engemtv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","And Jacob fathered Joseph the husband of Mary, of whom was born Jesus who is called Christ. ");
INSERT INTO engemtv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","So all the generations from Abraham till David were fourteen generations, from David until the captivity in Babylon were fourteen generations, and from the captivity in Babylon until the Christ were fourteen generations. ");
INSERT INTO engemtv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Now the birth of Jesus Christ was like this: After His mother Mary had been betrothed to Joseph, before they came together, she was found pregnant by the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Then Joseph her husband, being righteous and not wanting to disgrace her, purposed to put her away secretly. ");
INSERT INTO engemtv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","But while he was thinking about these things, behold, an angel of the Lord appeared to him in a dream, saying, “Joseph, son of David, do not fear to take unto you Mary your wife, for that which is begotten in her is of the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","And she shall bring forth a Son, and you shall call His name Jesus, for He shall save His people from their sins.” ");
INSERT INTO engemtv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Now all this came to pass that the thing spoken by the Lord through the prophet might be fulfilled, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Behold, the virgin shall be with child, and shall bring forth a Son, and they shall call His name Immanuel,” which is translated, “God with us.” ");
INSERT INTO engemtv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Then Joseph, having been aroused from sleep, did as the angel of the Lord had ordered him and took to him his wife, ");
INSERT INTO engemtv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","but did not know her till she brought forth her firstborn Son. And he called His name Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Now after Jesus was born in Bethlehem of Judea, in the days of Herod the king, behold, wise men from the East arrived in Jerusalem, ");
INSERT INTO engemtv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","saying, “Where is He who has been born King of the Jews? For we have seen His star in the East, and have come to worship Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","But when Herod the king heard this, he was troubled, and all Jerusalem with him. ");
INSERT INTO engemtv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","And having gathered together all the chief priests and scribes of the people, he inquired from them where the Christ would be born. ");
INSERT INTO engemtv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","So they said to him, “In Bethlehem of Judea, for thus it is written by the prophet: ");
INSERT INTO engemtv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘But you, Bethlehem, in the land of Judah, are by no means least among the rulers of Judah; for out of you shall come forth a Ruler who will shepherd My people Israel.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Then Herod, secretly having called the wise men, ascertained from them the time that the star appeared. ");
INSERT INTO engemtv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","And having sent them to Bethlehem, he said, “Go and search diligently for the young Child, and as soon as you find Him, report back to me, so that I also may come and worship Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","When they heard the king, they departed; and behold, the star which they had seen in the East went before them, till it came and stood over where the young Child was. ");
INSERT INTO engemtv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","And when they saw the star, they rejoiced with exceedingly great joy. ");
INSERT INTO engemtv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","And having come into the house, they saw the young Child with Mary His mother, and falling down, they worshiped Him, and opening their treasures, they presented gifts to Him: gold, frankincense, and myrrh. ");
INSERT INTO engemtv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","And having been divinely instructed in a dream not to return to Herod, they withdrew into their own country by another way. ");
INSERT INTO engemtv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Now when they had departed, behold, an angel of the Lord appeared to Joseph in a dream, saying, “Arise, and take along the young Child and His mother, flee to Egypt, and stay there until I tell you; for Herod is about to seek the young Child to destroy Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","When he arose, he took along the young Child and His mother by night and withdrew into Egypt, ");
INSERT INTO engemtv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","and was there until the death of Herod, so that it might be fulfilled which was spoken by the Lord through the prophet, saying, “Out of Egypt I called My Son.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Then Herod, seeing that he had been deceived by the wise men, was greatly enraged; and he sent and executed all the boys in Bethlehem and in all its districts, from two years old and under, according to the time which he had ascertained from the wise men. ");
INSERT INTO engemtv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Then was fulfilled what was spoken by Jeremiah the prophet, saying: ");
INSERT INTO engemtv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A voice was heard in Ramah, lamentation and weeping, and great mourning, Rachel weeping for her children, refusing to be comforted, because they are no more.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Now after Herod died, behold, an angel of the Lord appeared in a dream to Joseph in Egypt, ");
INSERT INTO engemtv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","saying, “Arise, and take with you the young Child and His mother, and go into the land of Israel, for those who were seeking the life of the young Child have died.” ");
INSERT INTO engemtv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Then he rose and took along the young Child and His mother, and came into the land of Israel. ");
INSERT INTO engemtv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","But hearing that Archelaus was reigning over Judea instead of his father Herod, he was afraid to go there. And being divinely instructed in a dream, he withdrew into the regions of Galilee. ");
INSERT INTO engemtv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","And when he arrived, he settled down in a city called Nazareth, so that it might be fulfilled which was spoken by the prophets, “He shall be called a Nazarene.” ");
INSERT INTO engemtv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","In those days John the Baptist arrived preaching in the wilderness of Judea, ");
INSERT INTO engemtv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","and saying, “Repent, for the kingdom of heaven is at hand!” ");
INSERT INTO engemtv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","For this is he who was spoken of by the prophet Isaiah, saying: “A voice of one crying in the wilderness: ‘Prepare the way of the Lord; make His paths straight.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","And John himself had his clothing made from camel's hair, with a leather belt around his waist; and his food was locusts and wild honey. ");
INSERT INTO engemtv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Then Jerusalem, and all Judea, and all the region around the Jordan were going out to him ");
INSERT INTO engemtv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","and they were being baptized by him in the Jordan, confessing their sins. ");
INSERT INTO engemtv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","But seeing many of the Pharisees and Sadducees coming to his baptism, he said to them, “Brood of vipers! Who warned you to flee from the coming wrath? ");
INSERT INTO engemtv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Therefore produce fruits worthy of repentance, ");
INSERT INTO engemtv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","and do not think to say among yourselves, ‘We have Abraham as our father.’ For I say to you that God is able to raise up children to Abraham out of these stones. ");
INSERT INTO engemtv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","But even now, the ax is laid to the root of the trees. Therefore every tree not producing good fruit is cut down and cast into the fire. ");
INSERT INTO engemtv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","I indeed baptize you with water unto repentance, but He who is coming after me is mightier than I, whose sandals I am not worthy to carry. He will baptize you with the Holy Spirit, ");
INSERT INTO engemtv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","whose winnowing shovel is in His hand, and He will thoroughly purge His threshing floor, and He will gather His wheat into the barn; but the chaff He will burn up with unquenchable fire.” ");
INSERT INTO engemtv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Then Jesus arrived from Galilee to John at the Jordan, to be baptized by him. ");
INSERT INTO engemtv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","But John tried to prevent Him, saying, “I have need to be baptized by You, and are You coming to me?” ");
INSERT INTO engemtv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","But Jesus answered and said to him, “Permit it now, for thus it is fitting for us to fulfill all righteousness.” Then he permitted Him. ");
INSERT INTO engemtv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","And having been baptized, Jesus came up immediately from the water; and behold, the heavens were opened to Him, and He saw the Spirit of God descending like a dove and coming to rest on Him. ");
INSERT INTO engemtv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","And behold, a voice came out of the heavens, saying, “This is My beloved Son, in whom I am well pleased.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Then Jesus was led up into the wilderness by the Spirit, to be tempted by the devil. ");
INSERT INTO engemtv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","And having fasted forty days and forty nights, afterward He was hungry. ");
INSERT INTO engemtv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","And approaching Him, the tempter said, “If You are the Son of God, command that these stones may become bread.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","But He answered and said, “It is written, ‘Man shall not live by bread alone, but by every word that proceeds out of the mouth of God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Then the devil took Him up into the holy city, and set Him on the pinnacle of the temple, ");
INSERT INTO engemtv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","and said to Him, “If You are the Son of God, throw Yourself down. For it is written: ‘He shall give His angels charge concerning you,’ and, ‘In their hands they will lift you up, lest you dash your foot against a stone.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus said to him, “Again, it is written, ‘You shall not tempt the Lord your God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Again, the devil took Him up on a very high mountain, and showed Him all the kingdoms of the world, and their glory. ");
INSERT INTO engemtv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","And he said to Him, “All these things will I give You, if You will fall down and worship me.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Then Jesus said to him, “Get behind Me, Satan! For it is written, ‘You shall worship the Lord your God, and Him alone you shall serve.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Then the devil left Him, and behold, angels came and ministered to Him. ");
INSERT INTO engemtv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Now when Jesus heard that John had been imprisoned, He departed into Galilee. ");
INSERT INTO engemtv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","And leaving Nazareth behind, He came and settled down in Capernaum, which is by the sea, in the regions of Zebulun and Naphtali, ");
INSERT INTO engemtv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","so that it might be fulfilled which was spoken by Isaiah the prophet, saying: ");
INSERT INTO engemtv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“The land of Zebulun and the land of Naphtali, by the way of the sea, beyond the Jordan, Galilee of the Gentiles, ");
INSERT INTO engemtv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","the people sitting in darkness have seen a great light, and to those who sat in the land and the shadow of death, light has dawned.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","From that time Jesus began to preach and to say, “Repent, for the kingdom of heaven is at hand.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Now as He was walking alongside the Sea of Galilee, He saw two brothers, Simon called Peter, and Andrew his brother, casting a net into the sea; for they were fishermen. ");
INSERT INTO engemtv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Then He said to them, “Come after Me, and I will make you fishers of men.” ");
INSERT INTO engemtv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","They immediately left their nets and followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","And having gone forth from there, He saw two other brothers, James the son of Zebedee, and John his brother, in the boat with Zebedee their father, mending their nets. And He called them. ");
INSERT INTO engemtv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","And immediately they left the boat and their father, and followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","And Jesus went about all of Galilee, teaching in their synagogues, preaching the gospel of the kingdom, and healing every disease and every illness among the people. ");
INSERT INTO engemtv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","And the report of Him went throughout all Syria; and they brought to Him all those who were sick, and who were suffering with various diseases and torments, and those who were demon-possessed, epileptics, and paralytics; and He healed them. ");
INSERT INTO engemtv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","And large crowds followed Him from Galilee and from Decapolis, and Jerusalem, and Judea, and beyond the Jordan. ");
INSERT INTO engemtv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","And seeing the crowds, He went up into the mountain, and after He had sat down, His disciples approached Him. ");
INSERT INTO engemtv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","And opening His mouth, He began to teach them, saying: ");
INSERT INTO engemtv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Blessed are the poor in spirit, for theirs is the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Blessed are those who mourn, for they shall be comforted. ");
INSERT INTO engemtv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Blessed are the meek, for they shall inherit the earth. ");
INSERT INTO engemtv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Blessed are those who hunger and thirst after righteousness, for they shall be filled. ");
INSERT INTO engemtv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Blessed are the merciful, for they shall obtain mercy. ");
INSERT INTO engemtv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Blessed are the pure in heart, for they shall see God. ");
INSERT INTO engemtv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Blessed are the peacemakers, for they shall be called sons of God. ");
INSERT INTO engemtv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Blessed are those who have been persecuted for righteousness' sake, for theirs is the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Blessed are you whenever they revile you, and they persecute you, and they say all kinds of evil against you falsely for My sake. ");
INSERT INTO engemtv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","“Rejoice and be exceedingly glad, for great is your reward in heaven, for so they persecuted the prophets who were before you. ");
INSERT INTO engemtv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“You are the salt of the earth; but if the salt becomes tasteless, with what shall it be salted? It is then good for nothing but to be cast out and to be trampled underfoot by men. ");
INSERT INTO engemtv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“You are the light of the world. A city that is set on a hill cannot be hidden. ");
INSERT INTO engemtv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nor do they light a lamp and put it under a basket, but on a lampstand, and it shines on everything in the house. ");
INSERT INTO engemtv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Let your light so shine before men, that they may see your good works, and glorify your Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Do not think that I came to abolish the Law or the Prophets. I did not come to abolish, but to fulfill. ");
INSERT INTO engemtv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","For assuredly I say to you, until heaven and earth may pass away, one iota or one tittle shall by no means pass away from the law until all things are fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Whoever therefore shall break one of the least of these commandments, and shall teach men so, will be called least in the kingdom of heaven; but whoever does them and teaches them, he shall be called great in the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","For I say to you, that unless your righteousness exceeds that of the scribes and Pharisees, you shall by no means enter the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“You have heard that it was said to the ancients, ‘You shall not murder,’ and whoever murders will be in danger of the judgment. ");
INSERT INTO engemtv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","But I say to you that whoever gets angry with his brother without cause will be in danger of the judgment. And whoever says to his brother, ‘Empty-head!’ will be in danger of the council. But whoever says, ‘fool!’ will be in danger of hell fire. ");
INSERT INTO engemtv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Therefore if you offer your gift on the altar, and there you remember that your brother has something against you, ");
INSERT INTO engemtv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","leave your gift there before the altar, and go, first be reconciled with your brother, and then come and offer your gift. ");
INSERT INTO engemtv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Make friends with your adversary quickly, while you are on the road with him, lest your adversary hand you over to the judge, and the judge hand you over to the officer, and you be cast into prison. ");
INSERT INTO engemtv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Assuredly I say to you, you will by no means get out of there till you have paid the last penny. ");
INSERT INTO engemtv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“You have heard that it was said, ‘You shall not commit adultery.’ ");
INSERT INTO engemtv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","But I say to you, that whoever looks at a woman in order to lust after her has already committed adultery with her in his heart. ");
INSERT INTO engemtv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","If your right eye causes you to stumble, pluck it out and cast it from you; for it is better for you that one of your members be lost, than for your whole body to be cast into hell. ");
INSERT INTO engemtv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","And if your right hand causes you to stumble, cut it off and cast it from you; for it is better for you that one of your members be lost, than for your whole body to be cast into hell. ");
INSERT INTO engemtv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Furthermore it has been said, ‘Whoever divorces his wife, let him give her a divorce certificate.’ ");
INSERT INTO engemtv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","But I say to you that whoever divorces his wife, except for a matter of sexual immorality, makes her commit adultery; and whoever marries a divorcee commits adultery. ");
INSERT INTO engemtv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Again you have heard that it was said to the ancients, ‘You shall not swear falsely, but you shall pay your oaths to the Lord.’ ");
INSERT INTO engemtv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","But I say to you, do not swear at all: neither by heaven, for it is God's throne; ");
INSERT INTO engemtv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nor by the earth, for it is His footstool; nor by Jerusalem, for it is the city of the great King. ");
INSERT INTO engemtv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nor shall you swear by your head, because you are not able to make one hair white or black. ");
INSERT INTO engemtv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","But let your word be ‘Yes’, ‘yes,’ or ‘No,’ ‘no.’ For whatever is more than these is from the evil one. ");
INSERT INTO engemtv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“You have heard that it was said, ‘An eye for an eye and a tooth for a tooth.’ ");
INSERT INTO engemtv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","But I say to you not to resist an evil person. But whoever shall slap you on your right cheek, turn to him the other also. ");
INSERT INTO engemtv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","And to the one desiring to sue you and to take your tunic, let him have your cloak also. ");
INSERT INTO engemtv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","And whoever compels you to go one mile, go with him two. ");
INSERT INTO engemtv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Give to the one asking you, and to the one desiring to borrow from you, do not turn away. ");
INSERT INTO engemtv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“You have heard that it was said, ‘You shall love your neighbor, and you shall hate your enemy.’ ");
INSERT INTO engemtv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","But I say to you, love your enemies, bless those who curse you, do good to those who hate you, and pray for those who mistreat you and persecute you, ");
INSERT INTO engemtv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","so that you may prove to be sons of your Father in heaven; because He makes His sun rise on the evil and on the good, and He sends rain on the just and on the unjust. ");
INSERT INTO engemtv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","For if you love those who love you, what reward do you have? Do not even the tax collectors do the same? ");
INSERT INTO engemtv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","And if you greet your friends only, what more are you doing than others? Do not even the tax collectors do the same? ");
INSERT INTO engemtv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","You therefore be perfect, just as your Father in heaven is perfect. ");
INSERT INTO engemtv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Take care not to be doing your charitable giving before men, so as to be seen by them. Otherwise, you have not a reward from your Father in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Whenever therefore you do charitable giving, do not sound a trumpet before you as the hypocrites do in the synagogues and in the streets, so that they may be praised by men. Assuredly I say to you, they receive their reward in full. ");
INSERT INTO engemtv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","But when you do charitable giving, do not let your left hand know what your right hand is doing, ");
INSERT INTO engemtv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","so that your charitable giving may be in secret; and your Father, who sees in secret, will Himself reward you openly. ");
INSERT INTO engemtv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“And whenever you pray, you shall not be like the hypocrites, because they love to pray standing in the synagogues, and on the street corners, so that they may be seen by men. Assuredly I say to you, that they receive their reward in full. ");
INSERT INTO engemtv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","But you, whenever you pray, enter into your room, and when you have shut your door, pray to your Father who is in secret; and your Father, who sees in secret, will reward you openly. ");
INSERT INTO engemtv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","But when you pray, do not babble like the heathen, for they think that they will be heard for their many words. ");
INSERT INTO engemtv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Therefore do not be like them. For your Father knows what things you have need of before you ask Him. ");
INSERT INTO engemtv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Therefore pray in this manner: Our Father in heaven, Hallowed be Your name. ");
INSERT INTO engemtv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Your kingdom come, Your will be done, On earth as it is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Give us this day our daily bread. ");
INSERT INTO engemtv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","And forgive us our debts, As we forgive our debtors. ");
INSERT INTO engemtv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","And lead us not into temptation, But deliver us from the evil one. For Yours is the kingdom and the power and the glory forever. Amen. ");
INSERT INTO engemtv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“For if you forgive men their trespasses, your heavenly Father will also forgive you. ");
INSERT INTO engemtv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","But if you do not forgive men their trespasses, neither will your Father forgive your trespasses. ");
INSERT INTO engemtv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Moreover, when you fast, do not become gloomy, like the hypocrites, for they disfigure their faces that they may appear to men to be fasting. Assuredly I say to you, that they receive their reward in full. ");
INSERT INTO engemtv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","But you, when you fast, anoint your head and wash your face, ");
INSERT INTO engemtv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","so that you do not appear to men to be fasting, but to your Father who is in secret; and your Father, who sees in secret, will reward you. ");
INSERT INTO engemtv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Do not lay up for yourselves treasures on earth, where moth and rust corrupt, and where thieves dig through and steal; ");
INSERT INTO engemtv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","but lay up for yourselves treasures in heaven, where neither moth nor rust corrupts, and where thieves do not dig through and steal. ");
INSERT INTO engemtv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","For where your treasure is, there your heart will be also. ");
INSERT INTO engemtv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“The lamp of the body is the eye. If therefore your eye is sound, your whole body will be full of light. ");
INSERT INTO engemtv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","But if your eye is evil, your whole body will be dark. If therefore the light that is in you is darkness, how great is that darkness! ");
INSERT INTO engemtv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“No one is able to serve two masters; for either he will hate the one, and he will love the other, or else he will be devoted to the one, and he will despise the other. You cannot serve God and money. ");
INSERT INTO engemtv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Because of this I say to you, do not worry about your life—what you shall eat, or what you shall drink—nor about your body, what you shall put on. Is not life more than food and the body more than clothing? ");
INSERT INTO engemtv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Look at the birds of the air, for they neither sow nor reap, nor do they gather into barns; yet your heavenly Father feeds them. Are you not worth more than they? ");
INSERT INTO engemtv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Which of you by worrying is able to add one cubit to his stature? ");
INSERT INTO engemtv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“So why do you worry about clothes? Consider the lilies of the field, how they grow; they neither labor, nor spin; ");
INSERT INTO engemtv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","and yet I say to you, that not even Solomon in all his glory was arrayed like one of these. ");
INSERT INTO engemtv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","But if God thus clothes the grass of the field, which exists today, and tomorrow is cast into the oven, will He not much more clothe you, O you of little faith? ");
INSERT INTO engemtv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Therefore do not worry, saying, ‘What shall we eat?’ or ‘What shall we drink?’ or ‘What shall we put on?’ ");
INSERT INTO engemtv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","For after all these things the Gentiles seek. For your heavenly Father knows that you need all these things. ");
INSERT INTO engemtv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","But seek first the kingdom of God and His righteousness, and all these things shall be added unto you. ");
INSERT INTO engemtv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Therefore do not worry about tomorrow, for tomorrow will worry about its own affairs. Each day has enough trouble of its own. ");
INSERT INTO engemtv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Judge not, lest you be judged. ");
INSERT INTO engemtv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","For with what judgment you judge, you will be judged; and with what measure you measure, it will be measured back to you. ");
INSERT INTO engemtv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","And why do you look at the speck in your brother's eye, but do not notice the plank in your own eye? ");
INSERT INTO engemtv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Or how will you say to your brother, ‘Permit me to remove the speck from your eye’; and look, there is a plank in your own eye? ");
INSERT INTO engemtv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hypocrite! First remove the plank out of your own eye, and then you will see clearly to remove the speck out of your brother's eye. ");
INSERT INTO engemtv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Do not give what is holy to the dogs; nor cast your pearls before swine, lest they trample them under their feet, and turn and tear you to pieces. ");
INSERT INTO engemtv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ask, and it shall be given to you; seek, and you shall find; knock, and it shall be opened to you. ");
INSERT INTO engemtv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","For everyone that asks receives, and he that seeks finds, and to him that knocks, it shall be opened. ");
INSERT INTO engemtv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Or what man is there among you who, if his son should ask for bread, will give him a stone? ");
INSERT INTO engemtv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","And if he should ask for a fish, he will give him a serpent? ");
INSERT INTO engemtv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","If you then, being evil, know how to give good gifts to your children, by how much more will your Father who is in heaven give good things to those who ask Him! ");
INSERT INTO engemtv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Therefore, whatever you want men to do to you, thus also you do to them, for this is the Law and the Prophets. ");
INSERT INTO engemtv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Enter in through the narrow gate; for wide is the gate and broad is the way which leads to destruction, and many are those who enter in through it. ");
INSERT INTO engemtv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","O how narrow the gate, and confined is the way which leads to life, and there are few who find it! ");
INSERT INTO engemtv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“But beware of false prophets, who come to you in sheep's clothing, but inwardly they are ravenous wolves. ");
INSERT INTO engemtv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","You will know them by their fruits. Do men gather grape clusters from thorns, or figs from thistles? ");
INSERT INTO engemtv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Thus every good tree produces good fruit, but a corrupt tree produces evil fruit. ");
INSERT INTO engemtv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A good tree cannot produce evil fruit, neither can a corrupt tree produce good fruit. ");
INSERT INTO engemtv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Every tree not producing good fruit is cut down and cast into the fire. ");
INSERT INTO engemtv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Consequently, by their fruits you shall know them. ");
INSERT INTO engemtv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Not everyone who says to Me, ‘Lord, Lord,’ will enter the kingdom of heaven, but he who does the will of My Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Many will say to Me in that day, ‘Lord, Lord, did we not prophesy in Your name, and in Your name we cast out demons, and in Your name we did many mighty works?’ ");
INSERT INTO engemtv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","And then I will confess to them, ‘I never knew you! Depart from Me, you who work iniquity!’ ");
INSERT INTO engemtv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Therefore, everyone who hears these words of Mine and does them, I will compare him to a wise man who built his house upon the rock: ");
INSERT INTO engemtv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","and the rain came down, and the floods came, and the winds blew and beat against that house; and it did not fall, for it had been founded on the rock. ");
INSERT INTO engemtv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“And everyone who hears these words of Mine and does not do them, will be compared to a foolish man who built his house on the sand: ");
INSERT INTO engemtv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","and the rain came down, and the floods came, and the winds blew and beat on that house; and it fell. And its fall was great.” ");
INSERT INTO engemtv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","And so it was, when Jesus had finished these words, the crowds were astonished at His teaching, ");
INSERT INTO engemtv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","for He taught them as one having authority, and not like the scribes. ");
INSERT INTO engemtv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","When He had come down from the mountain, great crowds followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","And behold, a leper came and worshiped Him, saying, “Lord, if You are willing, You can make me clean.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","And reaching out His hand, Jesus touched him, saying, “I am willing; be cleansed.” Immediately his leprosy was cleansed. ");
INSERT INTO engemtv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","And Jesus said to him, “See that you tell no one; but go, show yourself to the priest, and offer the gift which Moses commanded, as a testimony to them.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Now when He had entered Capernaum, a centurion approached Him, begging Him, ");
INSERT INTO engemtv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","and saying, “Lord, my servant has been laid up in the house a paralytic, being tormented terribly.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","And Jesus said to him, “I will come and heal him.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","The centurion answered and said, “Lord, I am not worthy that You should come under my roof. But just say the word and my servant will be healed. ");
INSERT INTO engemtv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","For I also am a man under authority, having soldiers under me. And I say to this one, ‘Go,’ and he goes; and to another, ‘Come,’ and he comes; and to my servant, ‘Do this,’ and he does it.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","When Jesus heard it, He marveled, and said to those who were following, “Assuredly, I say to you, I have not found such great faith, not even in Israel! ");
INSERT INTO engemtv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","And I say to you that many shall come from east and west, and recline to eat with Abraham, Isaac, and Jacob in the kingdom of heaven; ");
INSERT INTO engemtv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","but the sons of the kingdom will be cast out into outer darkness. There will be weeping and gnashing of teeth.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Then Jesus said to the centurion, “Go; and as you believed, may it be unto you.” And his servant was healed that very hour. ");
INSERT INTO engemtv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Now when Jesus had come into Peter's house, He saw his wife's mother having been laid up, and burning with fever. ");
INSERT INTO engemtv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","And He touched her hand, and the fever left her; and she got up, and began to serve Him. ");
INSERT INTO engemtv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","When evening had come, they brought to Him many who were demon-possessed. And He cast out the spirits with a word, and He healed all that were sick, ");
INSERT INTO engemtv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","so that it might be fulfilled which was spoken through Isaiah the prophet, saying: “He Himself took our infirmities, and bore our diseases.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","And when Jesus saw great crowds around Him, He gave orders to depart to the other side. ");
INSERT INTO engemtv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Then a certain scribe approached, and said to Him, “Teacher, I will follow You wherever You go.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","And Jesus said to him, “Foxes have dens, and birds of the air have nests, but the Son of Man has nowhere to lay His head.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Then another of His disciples said to Him, “Lord, permit me first to go and bury my father.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","But Jesus said to him, “Follow Me, and leave the dead to bury their own dead.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Now when He got into a boat, His disciples followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","And behold, a great tempest arose on the sea, so that the boat was covered by waves; but He was sleeping. ");
INSERT INTO engemtv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Then the disciples came and awoke Him, saying, “Lord, save us! We are perishing!” ");
INSERT INTO engemtv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","But He said to them, “Why are you fearful, O you of little faith?” Then having risen, He rebuked the winds and the sea, and there was a great calm. ");
INSERT INTO engemtv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","So the men marveled, saying, “What kind of Man is this, that even the winds and the sea obey Him?” ");
INSERT INTO engemtv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","And when He came to the other side, to the region of the Gergesenes, there met Him two demon-possessed men, coming out of the tombs; exceedingly violent, so that no one was able to pass by that way. ");
INSERT INTO engemtv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","And suddenly they cried out, saying, “What have we to do with You, Jesus, Son of God? Have You come here to torment us before the time?” ");
INSERT INTO engemtv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Now there was far off from them a herd of many swine feeding. ");
INSERT INTO engemtv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","So the demons implored Him, saying, “If You cast us out, permit us to go off into the herd of swine.” ");
INSERT INTO engemtv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","And He said to them, “Go.” So they came out, and went off into the herd of swine. And behold, the whole herd of swine rushed violently down the steep bank into the sea, and died in the waters. ");
INSERT INTO engemtv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Then those who tended them fled; and going off into the city, they reported everything, including what had happened to the demon-possessed men. ");
INSERT INTO engemtv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","And behold, the whole city came out to meet Jesus. And seeing Him, they implored Him that He might go away from their region. ");
INSERT INTO engemtv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","And getting into the boat, He crossed over and went into His own city. ");
INSERT INTO engemtv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","And behold, they were carrying a paralytic to Him lying on a bed. And when Jesus saw their faith, He said to the paralytic, “Have courage, child; your sins are forgiven you.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","And at once some of the scribes said among themselves, “This Man blasphemes!” ");
INSERT INTO engemtv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","But Jesus, knowing their thoughts, said, “Why do you think evil in your hearts? ");
INSERT INTO engemtv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","For which is easier, to say, ‘Your sins are forgiven,’ or to say, ‘Arise and walk’? ");
INSERT INTO engemtv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","But that you may know that the Son of Man has authority on the earth to forgive sins”—then He said to the paralytic, “Arise, take up your bed, and go to your house.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","And he arose, and went to his house. ");
INSERT INTO engemtv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Now when the crowds saw, they marveled and glorified God, who had given such authority to men. ");
INSERT INTO engemtv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","And as Jesus passed on from there, He saw a man named Matthew sitting at the tax office. And He said to him, “Follow Me.” And he arose and followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Now it came to pass, as He reclined to eat in the house, that behold, many tax collectors and sinners, having come, were reclining to eat with Jesus and His disciples. ");
INSERT INTO engemtv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","And when the Pharisees saw this, they said to His disciples, “Why does your Teacher eat with tax collectors and sinners?” ");
INSERT INTO engemtv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","When Jesus heard that, He said to them, “Those who are healthy have no need of a physician, but those who are sick. ");
INSERT INTO engemtv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","But go and learn what this means: ‘I desire mercy and not sacrifice.’ For I did not come to call the righteous, but sinners, to repentance.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Then the disciples of John approached Him, saying, “Why do we and the Pharisees fast often, but Your disciples do not fast?” ");
INSERT INTO engemtv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","And Jesus said to them, “Can the groomsmen mourn as long as the bridegroom is with them? But the days will come when the bridegroom will be taken away from them, and then they will fast. ");
INSERT INTO engemtv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","No one puts a piece of new cloth on an old garment; for the patch pulls away from the garment, and the tear is made worse. ");
INSERT INTO engemtv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nor do they put new wine into old wineskins, or else the wineskins burst, and the wine spills out, and the wineskins will be ruined. But they put new wine into new wineskins, and both are preserved.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","As He spoke these things to them, behold, a certain leader came and worshiped Him, saying, “My daughter has just died, but come and lay Your hand on her, and she shall live.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","So Jesus arose and followed him, likewise His disciples. ");
INSERT INTO engemtv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","And behold, a woman hemorrhaging for twelve years, approaching from behind, touched the hem of His garment. ");
INSERT INTO engemtv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","For she said to herself, “If only I may touch His garment, I will be healed.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","But Jesus, turning around and seeing her, said, “Take courage, daughter; your faith has healed you.” And the woman was healed from that hour. ");
INSERT INTO engemtv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","And when Jesus came into the house of the leader, and saw the flute players and the crowd making a commotion, ");
INSERT INTO engemtv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","He said to them, “Make room, for the girl has not died, but she is sleeping.” And they were ridiculing Him. ");
INSERT INTO engemtv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","But when the crowd had been put out, He went in and grasped her hand, and the little girl arose. ");
INSERT INTO engemtv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","And the report of this went out into that whole land. ");
INSERT INTO engemtv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","And as Jesus passed by from there, two blind men followed Him, crying out and saying, “Son of David, have pity on us!” ");
INSERT INTO engemtv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","And when He came into the house, the blind men approached Him, and Jesus said to them, “Do you believe that I am able to do this?” They said to Him, “Yes, Lord.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Then He touched their eyes, saying, “According to your faith, let it be unto you.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","And their eyes were opened. And Jesus sternly warned them, saying, “See that you let no one know.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","But they, having gone out, spread the news about Him in that whole land. ");
INSERT INTO engemtv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","And as they were going out, behold, they brought to Him a mute man who was demon-possessed. ");
INSERT INTO engemtv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","And when the demon was cast out, the mute spoke. And the crowds marveled, saying, “It was never seen like this in Israel!” ");
INSERT INTO engemtv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","But the Pharisees said, “By the ruler of the demons He casts out demons.” ");
INSERT INTO engemtv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","And Jesus was going about all the cities and villages, teaching in their synagogues, and preaching the gospel of the kingdom, and healing every illness and every disease among the people. ");
INSERT INTO engemtv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","But seeing the crowds, He was moved with compassion for them, because they were harassed and prostrated, like sheep having no shepherd. ");
INSERT INTO engemtv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Then He said to His disciples, “Indeed the harvest is plentiful, but the workers are few. ");
INSERT INTO engemtv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Therefore pray to the Lord of the harvest, that He may send forth workers into His harvest.” ");
INSERT INTO engemtv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","And summoning His twelve disciples, He gave them authority over unclean spirits, to cast them out, and to heal every disease and every illness. ");
INSERT INTO engemtv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Now the names of the twelve apostles are these: first, Simon, who was called Peter, and Andrew his brother; James the son of Zebedee, and John his brother; ");
INSERT INTO engemtv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip and Bartholomew; Thomas and Matthew the tax collector; James the son of Alphaeus, and Lebbaeus, who was surnamed Thaddaeus; ");
INSERT INTO engemtv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon the Canaanite, and Judas Iscariot, who also betrayed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","These twelve Jesus sent forth, commanding them, saying, “Do not go in the way of the Gentiles, and do not enter any city of the Samaritans. ");
INSERT INTO engemtv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","But go rather to the lost sheep of the house of Israel. ");
INSERT INTO engemtv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","And as you go, preach, saying, ‘The kingdom of heaven is at hand.’ ");
INSERT INTO engemtv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Heal the sick, cleanse the lepers, cast out demons. Freely you have received, freely give. ");
INSERT INTO engemtv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Do not acquire gold nor silver nor copper in your money belts, ");
INSERT INTO engemtv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","not a knapsack for the road, nor two tunics, nor sandals, nor staffs; for a worker is worthy of his food. ");
INSERT INTO engemtv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“And whatever city or village you enter, inquire who in it is worthy, and stay there until you go out. ");
INSERT INTO engemtv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","And as you enter into a household, greet it. ");
INSERT INTO engemtv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","And if indeed the house should be worthy, let your peace come upon it. But if it should not be worthy, let your peace return to you. ");
INSERT INTO engemtv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","And whoever will not receive you nor hear your words, when you depart from that house or city, shake off the dust from your feet. ");
INSERT INTO engemtv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Assuredly I say to you, it will be more tolerable for the land of Sodom and Gomorrah in the day of judgment than for that city! ");
INSERT INTO engemtv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Behold, I am sending you forth like sheep in the midst of wolves. Therefore be as wise as serpents and innocent as doves. ");
INSERT INTO engemtv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","But beware of men, for they will hand you over to councils and they will flog you in their synagogues. ");
INSERT INTO engemtv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","And you will be brought before governors and kings for My sake, as a testimony to them and to the nations. ");
INSERT INTO engemtv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","But whenever they hand you over, do not worry how or what you should speak. For it will be given to you in that hour what you should speak; ");
INSERT INTO engemtv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","for you are not the ones speaking, but the Spirit of your Father who is speaking in you. ");
INSERT INTO engemtv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Now brother will hand over brother to death, and a father his child; and children will rise up against parents, and put them to death. ");
INSERT INTO engemtv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","And you will be hated by all people for My name's sake. But he who endures to the end shall be saved. ");
INSERT INTO engemtv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","But whenever they persecute you in this city, flee to another. For assuredly I say to you, by no means will you have gone through the cities of Israel before the Son of Man comes. ");
INSERT INTO engemtv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A disciple is not above his teacher, nor a servant above his master. ");
INSERT INTO engemtv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","It is enough for a disciple that he become like his teacher, and the servant like his master. If they have called the master of the house Beelzebub, how much more will they call his household members! ");
INSERT INTO engemtv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Therefore do not fear them. For nothing is concealed that shall not be unveiled, and secret that shall not be made known. ");
INSERT INTO engemtv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“What I say to you in the dark, say in the light; and what you hear in the ear, proclaim on the housetops. ");
INSERT INTO engemtv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","And do not fear those who kill the body but cannot kill the soul. But rather fear Him who is able to destroy both soul and body in hell. ");
INSERT INTO engemtv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Are not two sparrows sold for a copper coin? And not one of them shall fall on the ground apart from the will of your Father. ");
INSERT INTO engemtv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","But even the hairs of your head are all numbered. ");
INSERT INTO engemtv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Therefore do not fear; you are worth more than many sparrows. ");
INSERT INTO engemtv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Therefore whoever who will confess Me before men, I also will confess Him before My Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","But whoever denies Me before men, I also will deny him before My Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Do not suppose that I came to bring peace on earth. I did not come to bring peace, but a sword. ");
INSERT INTO engemtv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","For I have come to ‘turn a man against his father, and a daughter against her mother, and a daughter-in-law against her mother-in-law’; ");
INSERT INTO engemtv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","and ‘A man's enemies will be his own household members.’ ");
INSERT INTO engemtv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","He who loves father or mother more than Me is not worthy of Me. And he who loves son or daughter more than Me is not worthy of Me. ");
INSERT INTO engemtv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","And he who does not take his cross and follow after Me is not worthy of Me. ");
INSERT INTO engemtv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","He who finds his life will lose it, and he who loses his life for My sake will find it. ");
INSERT INTO engemtv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“He that receives you receives Me, and he that receives Me receives Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","He that receives a prophet in the name of a prophet shall receive a prophet's reward. And he that receives a righteous man in the name of a righteous man shall receive a righteous man's reward. ");
INSERT INTO engemtv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","And whoever gives one of these little ones only a cup of cold water in the name of a disciple, assuredly I say to you, he shall by no means lose his reward.” ");
INSERT INTO engemtv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Now it came to pass, when Jesus finished directing His twelve disciples, that He moved on from there to teach and to preach in their cities. ");
INSERT INTO engemtv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","And when John had heard in prison about the works of the Messiah, having sent two of his disciples, ");
INSERT INTO engemtv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","he said to Him, “Are You the Coming One, or do we look for another?” ");
INSERT INTO engemtv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus answered and said to them, “Go and report to John the things which you hear and see: ");
INSERT INTO engemtv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","The blind receive sight, and the lame walk; the lepers are cleansed, and the deaf hear; the dead are raised up, and the poor have the gospel preached to them. ");
INSERT INTO engemtv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","And blessed is the one who is not offended because of Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Now as these men were going, Jesus began to say to the crowds concerning John: “What did you go out into the wilderness to see? A reed shaken by the wind? ");
INSERT INTO engemtv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","But what did you go out to see? A man clothed in soft garments? Indeed, those who wear soft garments are in kings' houses. ");
INSERT INTO engemtv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","But what did you go out to see? A prophet? Yes, I say to you, and far more than a prophet. ");
INSERT INTO engemtv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","For this is he about whom it is written: ‘Behold, I send My messenger before Your face, who will prepare Your way before You.’ ");
INSERT INTO engemtv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Assuredly I say to you, among those born of women there has not risen one greater than John the Baptist; but he that is least in the kingdom of heaven is greater than he. ");
INSERT INTO engemtv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","And from the days of John the Baptist until now the kingdom of heaven suffers violence, and violent men seize it. ");
INSERT INTO engemtv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","For all the prophets and the law prophesied until John. ");
INSERT INTO engemtv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","And if you are willing to receive it, he is Elijah who is to come. ");
INSERT INTO engemtv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","He who has ears to hear, let him hear. ");
INSERT INTO engemtv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","But to what shall I compare this generation? It is similar to children who sit in the marketplaces and call to their playmates, ");
INSERT INTO engemtv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","and say, ‘We played the flute for you, And you did not dance; We mourned to you, And you did not lament.’ ");
INSERT INTO engemtv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","For John came neither eating nor drinking, and they say, ‘He has a demon.’ ");
INSERT INTO engemtv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","The Son of Man came eating and drinking, and they say, ‘Look, a glutton and a drunkard, a friend of tax collectors and sinners!’ And so wisdom is justified by her children.” ");
INSERT INTO engemtv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Then He began to reproach the cities in which His very many miracles had been done, because they did not repent: ");
INSERT INTO engemtv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Woe to you, Chorazin! Woe to you, Bethsaida! Because if the miracles which were done in you had been done in Tyre and Sidon, they would have repented long ago in sackcloth and ashes. ");
INSERT INTO engemtv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nevertheless I say to you, it will be more tolerable for Tyre and Sidon in the day of judgment than for you. ");
INSERT INTO engemtv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","And you, Capernaum, the one having been exalted to heaven, you will be brought down to Hades; because if the miracles which were done in you had been done in Sodom, it would have remained to this day. ");
INSERT INTO engemtv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","But I say to you that it will be more tolerable for the land of Sodom in the day of judgment than for you.” ");
INSERT INTO engemtv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","At that time Jesus answered and said, “I praise You, Father, Lord of heaven and earth, that You have hidden these things from the wise and prudent, and have revealed them to babes. ");
INSERT INTO engemtv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yes, Father, for so it seemed good in Your sight. ");
INSERT INTO engemtv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","All things have been delivered to Me by My Father, and no one fully knows the Son except the Father, nor does anyone fully know the Father except the Son, and the one to whom the Son wills to reveal Him. ");
INSERT INTO engemtv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Come to Me, all you who labor and are heavy-laden, and I will give you rest. ");
INSERT INTO engemtv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Take My yoke upon you and learn from Me, for I am gentle and lowly in heart, and you will find rest for your souls. ");
INSERT INTO engemtv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","For My yoke is easy and My burden is light.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","At that time Jesus went through the grain fields on the Sabbath. And His disciples became hungry, and they began to pluck heads of grain and to eat. ");
INSERT INTO engemtv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","But when the Pharisees saw it, they said to Him, “Look, Your disciples are doing what is not lawful to do on the Sabbath!” ");
INSERT INTO engemtv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","But He said to them, “Have you not read what David did when he became hungry, he and those who were with him: ");
INSERT INTO engemtv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","how they entered the house of God, and ate the showbread which was not lawful for him to eat, nor for those who were with him, except only for the priests? ");
INSERT INTO engemtv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Or have you not read in the law that on the Sabbath the priests in the temple profane the Sabbath, and are guiltless? ");
INSERT INTO engemtv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yet I say to you that One greater than the temple is here. ");
INSERT INTO engemtv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","But if you had known what this means, ‘I desire mercy and not sacrifice,’ you would not have condemned the guiltless. ");
INSERT INTO engemtv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","For the Son of Man is Lord of the Sabbath.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","And having departed from there, He went into their synagogue. ");
INSERT INTO engemtv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","And behold, there was a man who had a withered hand. And they asked Him, saying, “Is it lawful to heal on the Sabbath?”—that they might accuse Him. ");
INSERT INTO engemtv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Then He said to them, “What man is there among you who shall have one sheep, and if it should fall into a ditch on the Sabbath, will not lay hold of it and lift it out? ");
INSERT INTO engemtv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","How much more valuable then is a man than a sheep! So then it is lawful to do good on the Sabbath.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Then He said to the man, “Stretch out your hand.” And he stretched it out, and it was restored whole like the other. ");
INSERT INTO engemtv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","But the Pharisees went out and conspired against Him, how they might destroy Him. ");
INSERT INTO engemtv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","But when Jesus knew it, He withdrew from there. And great crowds followed Him, and He healed them all. ");
INSERT INTO engemtv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","And He warned them that they should not make Him known, ");
INSERT INTO engemtv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","so that it might be fulfilled which was spoken by Isaiah the prophet, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Behold, My Servant whom I have chosen, My Beloved in whom My soul is well pleased! I will put My Spirit upon Him, and He will announce justice to the Gentiles. ");
INSERT INTO engemtv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","He will not quarrel nor cry out, nor will anyone hear His voice in the streets. ");
INSERT INTO engemtv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A bruised reed He shall not break, and a smoldering wick He shall not quench, till He bring forth justice to victory; ");
INSERT INTO engemtv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","And in His name the nations shall hope.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Then one was brought to Him who was demon-possessed, blind and mute; and He healed him, so that the blind and mute man both spoke and saw. ");
INSERT INTO engemtv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","And all the crowds were amazed and said, “This is not the Son of David, is it?” ");
INSERT INTO engemtv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","But the Pharisees, having heard, said, “This Man does not cast out demons except by Beelzebub, ruler of the demons.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","But Jesus, knowing their thoughts, said to them: “Every kingdom divided against itself is made desolate, and every city or house divided against itself shall not stand. ");
INSERT INTO engemtv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","And if Satan casts out Satan, he is divided against himself. How then will his kingdom stand? ");
INSERT INTO engemtv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","And if I cast out demons by Beelzebub, by whom do your sons cast them out? Therefore they shall be your judges. ");
INSERT INTO engemtv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","But if I cast out demons by the Spirit of God, then the kingdom of God has come upon you. ");
INSERT INTO engemtv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Or how is one able to enter a strong man's house to plunder his goods, unless he first binds the strong man? And then he will plunder his household. ");
INSERT INTO engemtv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","He who is not with Me is against Me, and he who does not gather with Me scatters. ");
INSERT INTO engemtv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Therefore I say to you, every sin and blasphemy shall be forgiven unto men, but the blasphemy against the Spirit shall not be forgiven unto men. ");
INSERT INTO engemtv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","And whoever says a word against the Son of Man, it shall be forgiven him; but whoever speaks against the Holy Spirit, it shall not be forgiven him, either in this age, or in the age to come. ");
INSERT INTO engemtv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Either make the tree good and its fruit good, or else make the tree corrupt and its fruit corrupt; for a tree is known by its fruit. ");
INSERT INTO engemtv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Brood of vipers! How can you, being evil, speak good things? For out of the abundance of the heart the mouth speaks. ");
INSERT INTO engemtv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A good man out of his good treasure brings forth good things, and an evil man out of his evil treasure brings forth evil things. ");
INSERT INTO engemtv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","But I say to you, that for every idle word men may speak, they will give account of it in the Day of Judgment. ");
INSERT INTO engemtv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","For by your words you shall be justified, and by your words you shall be condemned.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Then some of the scribes and Pharisees answered, saying, “Teacher, we wish to see a sign from You.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","But He answered and said to them, “An evil and adulterous generation seeks after a sign, and no sign will be given to it except the sign of the prophet Jonah. ");
INSERT INTO engemtv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","For just as Jonah was three days and three nights in the belly of the great fish, so will the Son of Man be three days and three nights in the heart of the earth. ");
INSERT INTO engemtv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","The men of Nineveh shall stand up in the judgment with this generation and shall condemn it, because they repented at the preaching of Jonah; and behold, a greater than Jonah is here. ");
INSERT INTO engemtv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","The queen of the South shall rise up in the judgment with this generation and she shall condemn it, because she came from the ends of the earth to hear the wisdom of Solomon; and behold, a greater than Solomon is here. ");
INSERT INTO engemtv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“When an unclean spirit goes out from a man, he goes through dry places, seeking rest, and does not find any. ");
INSERT INTO engemtv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Then he says, ‘I will return to my house from where I came out.’ And when he comes, he finds it unoccupied, swept, and adorned. ");
INSERT INTO engemtv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Then he goes and takes along with himself seven other spirits more wicked than himself, and entering in they dwell there; and the last state of that man is worse than the first. Thus it shall also be with this wicked generation.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","And while He was still speaking to the crowds, behold, His mother and brothers stood outside, seeking to speak with Him. ");
INSERT INTO engemtv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Then one said to Him, “Look, Your mother and Your brothers are standing outside, seeking to speak with You.” ");
INSERT INTO engemtv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","But He answered and said to him that told Him, “Who is My mother? And who are My brothers?” ");
INSERT INTO engemtv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","And stretching out His hand toward His disciples, He said, “Behold; My mother, and My brothers! ");
INSERT INTO engemtv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","For whoever does the will of My Father in heaven, he is My brother and sister and mother.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","On the same day Jesus went out of the house and sat beside the sea. ");
INSERT INTO engemtv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","And great crowds were gathered together to Him, so that He got into the boat and sat; and the crowd stood on the shore. ");
INSERT INTO engemtv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","And He spoke to them many things in parables, saying: “Behold, the sower went out to sow. ");
INSERT INTO engemtv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","And as he sowed, some seed fell alongside the road; and the birds came and devoured them. ");
INSERT INTO engemtv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","But others fell on the stony ground, where it did not have much earth; and immediately it sprang up, because it had no depth of earth. ");
INSERT INTO engemtv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","But when the sun rose, it was scorched, and because it had no root, it withered away. ");
INSERT INTO engemtv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","But others fell among thorns, and the thorns sprang up and choked them out. ");
INSERT INTO engemtv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","But others fell on good ground and it was yielding fruit: some a hundredfold, some sixty, some thirty. ");
INSERT INTO engemtv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","He who has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","And the disciples approached and said to Him, “Why do You speak to them in parables?” ");
INSERT INTO engemtv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","He answered and said to them, “To you it has been given to know the mysteries of the kingdom of heaven, but to them it has not been given. ");
INSERT INTO engemtv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","For whoever has, to him more shall be given, and he shall have an abundance; but whoever does not have, even what he has shall be taken away from him. ");
INSERT INTO engemtv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Therefore I speak to them in parables, because seeing they do not see, and hearing they do not hear, nor do they understand. ");
INSERT INTO engemtv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","And in them is fulfilled the prophecy of Isaiah, which says: ‘Hearing you shall hear and by no means understand, and seeing you shall see and by no means perceive. ");
INSERT INTO engemtv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","For the heart of this people has become dull, and their ears are hard of hearing, and their eyes have closed, lest they should see with their eyes, and hear with their ears, lest they should understand with their hearts and turn back, that I should heal them.’ ");
INSERT INTO engemtv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","But blessed are your eyes because they see, and your ears, because they hear. ");
INSERT INTO engemtv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","For assuredly I say to you, that many prophets and righteous men desired to see what you see, and they did not see, and to hear what you hear, and they did not hear.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Therefore hear the parable of the sower: ");
INSERT INTO engemtv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","When anyone hears the word of the kingdom, and does not understand, then the evil one comes and snatches away what was sown in his heart. This is the seed that was sown beside the road. ");
INSERT INTO engemtv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","But the seed sown on stony ground, is he who hears the word and immediately receives it with joy; ");
INSERT INTO engemtv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","yet he has no root in himself, but is short-lived. For when tribulation or persecution comes because of the word, immediately he falls away. ");
INSERT INTO engemtv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","But the seed sown in the thorns is he who hears the word, and the anxiety of this age, and the deceitfulness of riches chokes out the word, and it becomes fruitless. ");
INSERT INTO engemtv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","But the seed sown on the good ground is he who hears the word and understands it, who indeed bears fruit and produces: some a hundredfold some sixty, some thirty.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Another parable He set before them, saying: “The kingdom of heaven is like a man sowing good seed in his field. ");
INSERT INTO engemtv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","But while the men were sleeping, his enemy came and sowed tares among the wheat and went away. ");
INSERT INTO engemtv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","But when the stalk had sprouted and produced fruit, then the tares also appeared. ");
INSERT INTO engemtv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","So the servants of the master of the house approached and said to him, ‘Sir, did you not sow good seed in your field? From where then does it have tares?’ ");
INSERT INTO engemtv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","He said to them, ‘An enemy has done this.’ So the servants said to him, ‘Do you wish then that we should go and gather them up?’ ");
INSERT INTO engemtv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","But he said, ‘No, lest gathering up the tares you also uproot the wheat with them. ");
INSERT INTO engemtv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Leave both to grow together until the harvest; and at the time of harvest I will say to the reapers, “First gather together the tares, and bind them into bundles to burn them, but gather together the wheat into my barn.” ’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Another parable He set before them, saying: “The kingdom of heaven is like a mustard seed, which a man took and sowed in his field, ");
INSERT INTO engemtv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","which indeed is smaller than all the seeds; but whenever it is grown, it is greater than the garden vegetables and becomes a tree, so that the birds of the air come and nest in its branches.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Another parable He spoke to them: “The kingdom of heaven is like leaven, which a woman took and hid in three measures of meal, until it was all leavened.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus spoke all these things in parables to the crowds, and without a parable He did not speak to them, ");
INSERT INTO engemtv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","so that it might be fulfilled which was spoken by the prophet, saying: “I will open My mouth in parables; I will utter things having been hidden from the foundation of the world.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Then having dismissed the crowds, Jesus went into the house. And His disciples came to Him, saying, “Explain to us the parable of the tares of the field.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","He answered and said to them: “He that sows the good seed is the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","And the field is the world, and the good seed, these are the sons of the kingdom, but the tares are the sons of the evil one. ");
INSERT INTO engemtv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","The enemy who sowed them is the devil, the harvest is the end of the age, and the reapers are the angels. ");
INSERT INTO engemtv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Therefore just as the tares are gathered and burned with fire, thus it will be at the end of this age. ");
INSERT INTO engemtv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","The Son of Man will send forth His angels, and they will gather out of His kingdom all things that offend, and those who work iniquity, ");
INSERT INTO engemtv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","and will cast them into the furnace of fire. There will be weeping and gnashing of teeth. ");
INSERT INTO engemtv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Then the righteous will shine forth like the sun in the kingdom of their Father. He who has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Again, the kingdom of heaven is like treasure having been hidden in a field, which a man found and hid; and for joy over it, he went and sold everything he had, and bought that field.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Again, the kingdom of heaven is like a merchant seeking beautiful pearls, ");
INSERT INTO engemtv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","who, when he found one very precious pearl, went and sold everything he had and bought it.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Again, the kingdom of heaven is like a dragnet having been cast into the sea, and gathering some of every kind, ");
INSERT INTO engemtv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","which, when it was filled, they pulled up on the shore; and sitting down, they collected the good into vessels, but the rotten they threw out. ");
INSERT INTO engemtv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Thus it shall be at the end of the age: the angels shall go forth and separate the evil from among the righteous, ");
INSERT INTO engemtv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","and cast them into the furnace of fire. There will be weeping and gnashing of teeth.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus said to them, “Have you understood all these things?” They said to Him, “Yes, Lord.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Then He said to them, “Therefore every scribe who has become a disciple in the kingdom of heaven is like the master of a house who brings out of his treasure both new things and old.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Now it came to pass, when Jesus had finished these parables, He went away from there. ");
INSERT INTO engemtv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","And coming into His hometown, He began to teach them in their synagogue, so that they were astonished and said, “Where did this Man get this wisdom and the powerful works? ");
INSERT INTO engemtv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Is this not the carpenter's son? Is not His mother called Mary? And His brothers James, Joses, Simon, and Jude? ");
INSERT INTO engemtv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","And His sisters, are they not all with us? From where then did this Man get all these things?” ");
INSERT INTO engemtv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","So they were offended at Him. But Jesus said to them, “A prophet is not without honor except in his hometown, and in his own house.” ");
INSERT INTO engemtv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","And He did not do many miracles there because of their unbelief. ");
INSERT INTO engemtv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","At that time Herod the tetrarch heard the report about Jesus, ");
INSERT INTO engemtv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","and said to his servants, “This is John the Baptist; he has been raised from the dead, and therefore these powers are at work in him.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","For Herod had laid hold of John and bound him, and put him in prison on account of Herodias, his brother Philip's wife. ");
INSERT INTO engemtv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","For John said to him, “It is not lawful for you to have her.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Though desiring to kill him, he feared the crowd, because they regarded him as a prophet. ");
INSERT INTO engemtv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Now when Herod's birthday was being celebrated, the daughter of Herodias danced before them, and she pleased Herod. ");
INSERT INTO engemtv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Therefore he promised with an oath to give her whatever she should ask. ");
INSERT INTO engemtv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","So she, being urged on by her mother, said, “Give me here on a platter the head of John the Baptist.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","And the king was grieved, but because of the oaths, and because of those who reclined to eat with him, he commanded it to be given. ");
INSERT INTO engemtv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","And having sent, he beheaded John in the prison. ");
INSERT INTO engemtv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","And his head was brought on a platter and it was given to the girl, and she brought it to her mother. ");
INSERT INTO engemtv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Then his disciples came forward and took the body and buried it, and coming, they reported it to Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","When Jesus heard it, He withdrew from there in a boat for a deserted place privately. But when the crowds heard it, they followed Him on foot from the cities. ");
INSERT INTO engemtv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","And coming out, Jesus saw a large crowd, and He was moved with compassion towards them, and healed their sick. ");
INSERT INTO engemtv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Now when evening came, His disciples came to Him, saying, “The place is deserted, and the hour is already late. Dismiss the crowds, that they may go to the villages and buy food for themselves.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","But Jesus said to them, “They do not need to go away. You give them food to eat.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","And they said to Him, “We do not have anything here except five loaves of bread and two fish.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","But He said, “Bring them here to Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","And commanding the crowds to recline on the grass, taking the five loaves of bread and the two fish, looking up to heaven, He blessed, and breaking them, He gave the loaves to the disciples; and the disciples gave to the crowds. ");
INSERT INTO engemtv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","So they all ate and were satisfied, and they took up what they had left of the fragments, twelve baskets full. ");
INSERT INTO engemtv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Now those who had eaten were about five thousand men, apart from women and children. ");
INSERT INTO engemtv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","And immediately Jesus compelled the disciples to get into the boat, and to go ahead of Him to the other side, until He could dismiss the crowds. ");
INSERT INTO engemtv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","And having dismissed the crowds, He went up on the mountain privately to pray. And when evening had come, He was there alone. ");
INSERT INTO engemtv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","But the boat was now in the middle of the sea, being harassed by the waves, for the wind was against them. ");
INSERT INTO engemtv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Now in the fourth watch of the night Jesus went to them, walking on the sea. ");
INSERT INTO engemtv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","And when the disciples saw Him walking on the sea, they were terrified, and said, “It is a ghost!” And they cried out for fear. ");
INSERT INTO engemtv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","But immediately Jesus spoke to them, saying, “Have courage! It is I AM; do not fear.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","But Peter answered Him and said, “Lord, if it is You, command me to come to You on the waters.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","So He said, “Come.” And stepping down from the boat, Peter walked on the waters to go toward Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","But seeing the strong wind, he was afraid, and beginning to sink he cried out, saying, “Lord, save me!” ");
INSERT INTO engemtv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","And immediately, Jesus reaching out His hand, laid hold of him, and said to him, “O you of little faith, why did you doubt?” ");
INSERT INTO engemtv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","And when they had gotten into the boat, the wind ceased. ");
INSERT INTO engemtv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Then those who were in the boat came and worshiped Him, saying, “Truly You are the Son of God.” ");
INSERT INTO engemtv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","And having crossed over, they came to the land of Gennesaret. ");
INSERT INTO engemtv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","And when the men of that place recognized Him, they sent out into all that surrounding region, and they brought to Him all those who were sick, ");
INSERT INTO engemtv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","and implored Him that they might only touch the hem of His garment. And as many as touched Him were completely healed. ");
INSERT INTO engemtv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Then the scribes and Pharisees who were from Jerusalem approached Jesus, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Why do Your disciples transgress the tradition of the elders? For they do not wash their hands whenever they eat bread.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","He answered and said to them, “Why do you also transgress the commandment of God on account of your tradition? ");
INSERT INTO engemtv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","For God commanded, saying, ‘Honor your father and your mother’; and, ‘He who curses father or mother, with death let him die.’ ");
INSERT INTO engemtv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","But you say, ‘Whoever says to his father or mother, “It is a gift to God, whatever profit you might have received from me”— ");
INSERT INTO engemtv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","then by no means should he honor his father or mother.’ Thus you have invalidated the commandment of God for the sake of your tradition. ");
INSERT INTO engemtv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hypocrites! Well did Isaiah prophesy about you, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘These people draw near to Me with their mouth, and they honor Me with their lips, but their heart is far away from Me. ");
INSERT INTO engemtv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","And in vain they worship Me, teaching as doctrines the commandments of men.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","And having summoned the crowd, He said to them, “Hear and understand: ");
INSERT INTO engemtv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","It is not what goes into the mouth that defiles a man; but what comes out of the mouth, this defiles a man.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Then His disciples approached and said to Him, “You know that when the Pharisees heard this message they were offended?” ");
INSERT INTO engemtv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","But He answered and said, “Every plant which My heavenly Father has not planted will be uprooted. ");
INSERT INTO engemtv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Leave them alone. They are blind guides of the blind. And if the blind guides the blind, both will fall into a ditch.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Then Peter answered and said to Him, “Explain to us this parable.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","So Jesus said, “Are you also still without understanding? ");
INSERT INTO engemtv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Do you not yet understand that whatever enters the mouth goes into the stomach, and is cast out into a latrine? ");
INSERT INTO engemtv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","But those things which proceed out of the mouth come from the heart, and they defile a man. ");
INSERT INTO engemtv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","For out of the heart come forth evil thoughts, murders, adulteries, fornications, thefts, false witness, blasphemies. ");
INSERT INTO engemtv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","These are the things which defile a man, but to eat with unwashed hands does not defile a man.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","And going out from there, Jesus withdrew into the region of Tyre and Sidon. ");
INSERT INTO engemtv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","And behold, a Canaanite woman coming forth from that region cried out to Him, saying, “Have mercy on me, O Lord, Son of David! My daughter is severely demon-possessed.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","But He answered her not a word. And His disciples approached and urged Him, saying, “Send her away, for she cries out after us.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","But He answered and said, “I was not sent except to the lost sheep of the house of Israel.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Then she came and worshiped Him, saying, “Lord, help me!” ");
INSERT INTO engemtv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","But He answered and said, “It is not good to take the children's bread and to throw it to the little dogs.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","But she said, “Yes, Lord, yet even the little dogs eat from the crumbs falling from their masters' table.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Then Jesus answered and said to her, “O woman, great is your faith! Let it be to you as you desire.” And her daughter was healed from that very hour. ");
INSERT INTO engemtv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","And moving on from there, Jesus came alongside the Sea of Galilee, and going up into a mountain, He sat down there. ");
INSERT INTO engemtv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","And great crowds came to Him, having with them the lame, blind, mute, maimed, and many others; and they put them down at Jesus' feet, and He healed them. ");
INSERT INTO engemtv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","So the multitude marveled when they saw the mute speaking, the maimed made whole, the lame walking, and the blind seeing; and they glorified the God of Israel. ");
INSERT INTO engemtv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Now Jesus, having summoned His disciples, He said, “I have compassion on the crowd, because they have been remaining with Me three days, and they do not have anything to eat. And I do not desire to send them away hungry, lest they faint on the way.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Then His disciples said to Him, “Where could we get so many loaves of bread in this deserted place, so as to satisfy so great a crowd?” ");
INSERT INTO engemtv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus said to them, “How many loaves do you have?” And they said, “Seven, and a few small fish.” ");
INSERT INTO engemtv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","So He commanded the crowds to recline on the ground. ");
INSERT INTO engemtv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","And He took the seven loaves and the fish, and having given thanks, He broke them, and gave them to His disciples; and the disciples gave to the crowd. ");
INSERT INTO engemtv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","So they all ate and were satisfied. And they took up what they had left of the fragments, seven hampers full. ");
INSERT INTO engemtv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Now those who ate were four thousand men, apart from women and children. ");
INSERT INTO engemtv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","And having dismissed the crowds, He went up into the boat, and came to the region of Magdala. ");
INSERT INTO engemtv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Then the Pharisees and Sadducees came, and testing Him, they asked Him to show them a sign out of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","He answered and said to them, “When evening comes you say, ‘Fine weather, for the sky is red’. ");
INSERT INTO engemtv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","And in the morning, ‘Today will be stormy, for the sky is red and overcast.’ Hypocrites! Indeed you know how to discern the face of the sky, but you cannot discern the signs of the times. ");
INSERT INTO engemtv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","An evil and adulterous generation seeks after a sign, and no sign will be given to it except the sign of the prophet Jonah.” And leaving them behind He went away. ");
INSERT INTO engemtv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Now when His disciples had come to the other side, they forgot to take bread. ");
INSERT INTO engemtv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Then Jesus said to them, “Look out and beware of the leaven of the Pharisees and the Sadducees.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","But they were reasoning among themselves, saying, “We did not take bread.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","But Jesus, knowing about it, said to them, “O you of little faith, why are you reasoning among yourselves, because you did not take bread? ");
INSERT INTO engemtv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Do you not yet perceive, or remember the five loaves of the five thousand and how many baskets you took up? ");
INSERT INTO engemtv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nor the seven loaves of the four thousand and how many hampers you took up? ");
INSERT INTO engemtv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","How is it you do not perceive that I did not speak to you about bread, but to beware of the leaven of the Pharisees and Sadducees?” ");
INSERT INTO engemtv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Then they understood that He did not say to beware of the leaven of bread, but of the doctrine of the Pharisees and Sadducees. ");
INSERT INTO engemtv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","When Jesus came into the region of Caesarea Philippi, He was questioning His disciples, saying, “Who do men pronounce Me, the Son of Man, to be?” ");
INSERT INTO engemtv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","So they said, “Some say John the Baptist, but others say Elijah, and yet others say Jeremiah, or one of the prophets.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","He said to them, “But who do you pronounce Me to be?” ");
INSERT INTO engemtv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","And Simon Peter answered and said, “You are the Christ, the Son of the living God.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus answered and said to him, “Blessed are you, Simon Bar-Jonah, because flesh and blood did not reveal this to you, but My Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","And I also say to you that you are Peter, and upon this rock I shall build My church, and the gates of hell shall not prevail against it. ");
INSERT INTO engemtv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","And I will give you the keys of the kingdom of heaven, and whatever you bind on the earth will have been bound in heaven, and whatever you loose on the earth will have been loosed in heaven.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Then He commanded His disciples that they should tell no one that He was Jesus the Christ. ");
INSERT INTO engemtv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","From that time Jesus began to show to His disciples that He must go off to Jerusalem, and suffer many things from the elders and chief priests and scribes, and to be killed, and to be raised the third day. ");
INSERT INTO engemtv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","And taking Him aside, Peter began to rebuke Him, saying, “God be gracious to You, Lord! This shall by no means happen to You!” ");
INSERT INTO engemtv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","But He turned and said to Peter, “Get behind Me, Satan! You are a stumbling block to Me, because you are not mindful of the things of God, but the things of men.” ");
INSERT INTO engemtv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Then Jesus said to His disciples, “If anyone desires to come after Me, let him deny himself, and take up his cross, and follow Me. ");
INSERT INTO engemtv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","For whoever desires to save his life shall lose it, but whoever loses his life on account of Me shall find it. ");
INSERT INTO engemtv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","For what is a man profited if he gains the whole world, but forfeits his soul? Or what will a man give in exchange for his soul? ");
INSERT INTO engemtv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","For the Son of Man is going to come in the glory of His Father with His angels, and then He will render to each according to his works. ");
INSERT INTO engemtv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Assuredly I say to you, there are some standing here who will by no means taste death till they see the Son of Man coming in His kingdom.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Now after six days Jesus took Peter, James, and John his brother, and led them up on a high mountain in private; ");
INSERT INTO engemtv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","and He was transfigured before them, and His face shone like the sun, and His clothes became as white as light. ");
INSERT INTO engemtv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","And behold, Moses and Elijah appeared to them, talking with Him. ");
INSERT INTO engemtv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Then Peter answered and said to Jesus, “Lord, it is good for us to be here; if You desire, let us make here three tents: one for You, one for Moses, and one for Elijah.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","While he was still speaking, behold, a bright cloud overshadowed them; and behold, a voice came out of the cloud, saying, “This is My beloved Son, in whom I am well pleased. Listen to Him!” ");
INSERT INTO engemtv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","And when the disciples heard this, they fell on their faces and they were greatly afraid. ");
INSERT INTO engemtv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","But Jesus approached and touched them and said, “Arise, and do not be afraid.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","And lifting up their eyes, they saw no one except Jesus alone. ");
INSERT INTO engemtv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","And as they came down from the mountain, Jesus commanded them, saying, “Tell the vision to no one until the Son of Man is risen from the dead.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","And His disciples asked Him, saying, “Why then do the scribes say that Elijah must come first?” ");
INSERT INTO engemtv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus answered and said to them, “Elijah truly does come first, and shall restore all things. ");
INSERT INTO engemtv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","But I say to you that Elijah has come already, and they did not recognize him, but did to him whatever they desired. Thus also the Son of Man is about to suffer by them.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Then the disciples understood that He spoke to them of John the Baptist. ");
INSERT INTO engemtv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","And when they came to the crowd, a man approached Him, kneeling down to Him, and saying, ");
INSERT INTO engemtv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lord, have pity on my son, for he is moonstruck and suffers severely; for he often falls into the fire and often into the water. ");
INSERT INTO engemtv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","So I brought him to Your disciples, but they were not able to heal him.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Then Jesus answered and said, “O unfaithful and perverted generation, how long shall I be with you? How long shall I bear with you? Bring him here to Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","And Jesus rebuked the demon, and it came out from him; and the boy was healed from that very hour. ");
INSERT INTO engemtv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Then the disciples came to Jesus privately and said, “Why could we not cast it out?” ");
INSERT INTO engemtv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","So Jesus said to them, “Because of your unbelief; for assuredly I say to you, if you have faith like a mustard seed, you shall say to this mountain, ‘Be moved from here to there,’ and it shall move; and nothing shall be impossible for you. ");
INSERT INTO engemtv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","However, this kind does not go out except by prayer and fasting.” ");
INSERT INTO engemtv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","And while they were staying in Galilee, Jesus said to them, “The Son of Man is about to be betrayed into the hands of men, ");
INSERT INTO engemtv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","and they will kill Him, and on the third day He shall be raised.” And they were exceedingly sorrowful. ");
INSERT INTO engemtv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","When they had come to Capernaum, those who collected the temple tax came to Peter and said, “Does your Teacher not pay the temple tax?” ");
INSERT INTO engemtv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","He said, “Yes.” And when he entered into the house, Jesus anticipated him, saying, “What do you think, Simon? From whom do the kings of the earth take customs or taxes, from their sons or from strangers?” ");
INSERT INTO engemtv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter said to Him, “From strangers.” Jesus said to him, “Then the sons are free. ");
INSERT INTO engemtv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nevertheless, lest we offend them, go to the sea, and cast in a hook, and take the first fish that comes up. And when you have opened its mouth, you will find a coin. Take that, and give it to them for Me and for yourself.” ");
INSERT INTO engemtv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","At that time the disciples came to Jesus, saying, “Who then is the greatest in the kingdom of heaven?” ");
INSERT INTO engemtv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Then Jesus called a little child, and set him in their midst, ");
INSERT INTO engemtv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","and said, “Assuredly I say to you, unless you are converted and become as little children, you shall by no means enter the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Therefore whoever humbles himself as this little child, he is the greatest in the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","And whoever receives one such little child in My name, receives Me. ");
INSERT INTO engemtv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“But whoever causes one of these little ones who believe in Me to stumble, it would be better for him that a huge millstone be hanged on his neck, and he be drowned in the depth of the sea. ");
INSERT INTO engemtv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Woe to the world because of offenses! For offenses must come, but woe to that man through whom the offense comes! ");
INSERT INTO engemtv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“And if your hand or your foot causes you to stumble, cut them off and cast them from you. It is better for you to enter into life lame or maimed, than having two hands or two feet, to be thrown into the eternal fire. ");
INSERT INTO engemtv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","And if your eye causes you to stumble, pluck it out and cast it from you. It is better for you to enter into life with one eye, than having two eyes, to be thrown into the fiery hell. ");
INSERT INTO engemtv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“See that you do not despise one of these little ones, for I say to you that in heaven their angels always see the face of My Father who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","For the Son of Man came to save that which was lost. ");
INSERT INTO engemtv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“What do you think? If a certain man has a hundred sheep, and one of them goes astray, does he not leave the ninety-nine on the mountains, and go and search for the one gone astray? ");
INSERT INTO engemtv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","And if he happens to find it, assuredly I say to you that he rejoices over it more than over the ninety-nine which did not go astray. ");
INSERT INTO engemtv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Thus it is not the will before your Father who is in heaven that one of these little ones should perish. ");
INSERT INTO engemtv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“And if your brother sins against you, go and show him his fault between you and him alone. If he hears you, you have won your brother. ");
INSERT INTO engemtv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","But if he does not hear, take along with you one or two more, so that ‘by the mouth of two or three witnesses every word may be established.’ ");
INSERT INTO engemtv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","But if he refuses to hear them, tell it to the church. But if he refuses even to hear the church, let him be to you as a heathen and a tax collector. ");
INSERT INTO engemtv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Assuredly I say to you, whatever you bind on earth shall have been bound in heaven, and whatever you loose on earth shall have been loosed in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Again, assuredly I say to you that if two of you agree on earth about anything that they may ask, it will be done for them by My Father in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","For where two or three are gathered together in My name, I am there in their midst.” ");
INSERT INTO engemtv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Then Peter came to Him and said, “Lord, how often shall my brother sin against me, and I forgive him? Up to seven times?” ");
INSERT INTO engemtv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus said to him, “I do not say to you, up to seven times, but up to seventy times seven. ");
INSERT INTO engemtv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Therefore the kingdom of heaven is like a certain king who wanted to settle accounts with his servants. ");
INSERT INTO engemtv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","And when he began to settle up, one debtor was brought to him owing ten thousand talents. ");
INSERT INTO engemtv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","But since he had nothing with which to repay, his master commanded that he be sold, with his wife and children and everything that he had, and to be repaid. ");
INSERT INTO engemtv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Therefore falling down before him, the servant said, ‘Master, have patience with me, and I will repay everything to you.’ ");
INSERT INTO engemtv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","And having compassion, the master of that servant released him, and forgave him the debt. ");
INSERT INTO engemtv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“But when that servant went out, he found one of his fellow servants who owed him a hundred denarii. And taking hold of him, he was choking him, saying, ‘Pay me what you owe!’ ");
INSERT INTO engemtv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","So his fellow servant fell down at his feet and kept begging him, saying, ‘Have patience with me, and I will pay you back.’ ");
INSERT INTO engemtv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","But he was not willing, but going off, he cast him into prison till he should pay back what was owed. ");
INSERT INTO engemtv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","So when his fellow servants saw what had been done, they were deeply grieved, and they came and narrated to their master all that had taken place. ");
INSERT INTO engemtv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Then summoning him, his master said to him, ‘You wicked servant! I forgave you all that debt because you begged me. ");
INSERT INTO engemtv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Should you not also have had compassion on your fellow servant, as I also had compassion on you?’ ");
INSERT INTO engemtv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","And being angered, his master handed him over to the tormentors until he should pay all that was owed to him. ");
INSERT INTO engemtv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Thus also My heavenly Father will do to you, if you do not forgive each one his brother their trespasses, from your hearts.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Now it came to pass, when Jesus had finished these words, that He departed from Galilee and went to the region of Judea beyond the Jordan. ");
INSERT INTO engemtv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","And great crowds followed Him, and He healed them there. ");
INSERT INTO engemtv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","The Pharisees also came to Him, testing Him, and saying to Him, “Is it lawful for a man to divorce his wife for just any reason?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","And He answered and said to them, “Have you not read that He who made them at the beginning ‘made them male and female,’ ");
INSERT INTO engemtv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","and He said, ‘For this reason a man shall leave his father and mother and shall be joined to his wife, and the two shall become one flesh’? ");
INSERT INTO engemtv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","So then, they are no longer two but one flesh. Therefore what God has joined together, let not man separate.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","They said to Him, “Why then did Moses command to give a certificate of divorce, and to put her away?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","He said to them, “Moses, because of the hardness of your hearts, permitted you to divorce your wives, but from the beginning it has not been this way. ");
INSERT INTO engemtv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","And I say to you, that whoever shall put away his wife, except it be for sexual immorality, and marries another, commits adultery; and whoever marrying a divorcee commits adultery.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","His disciples said to Him, “If such is the case of the man with his wife, it is better not to marry.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","But He said to them, “All cannot accept this saying, but it is for those to whom it has been given: ");
INSERT INTO engemtv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","For there are eunuchs who were born this way from their mother's womb, and there are eunuchs who were made eunuchs by men, and there are eunuchs who have made themselves eunuchs for the kingdom of heaven's sake. He who is able to accept this, let him accept it.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Then little children were brought to Him, that He might put His hands on them and pray; but the disciples rebuked them. ");
INSERT INTO engemtv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","But Jesus said, “Allow the little children to come to Me, and do not forbid them; for of such is the kingdom of heaven.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","And having put His hands on them, He departed from there. ");
INSERT INTO engemtv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","And behold, one came and said to Him, “Good Teacher, what good thing shall I do that I may have eternal life?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","So He said to him, “Why do you call Me good? No one is good except One, that is, God. But if you want to enter into life, keep the commandments.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","He said to Him, “Which ones?” Jesus said, “ ‘You shall not murder,’ ‘You shall not commit adultery,’ ‘You shall not steal,’ ‘You shall not bear false witness,’ ");
INSERT INTO engemtv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Honor your father and your mother,’ and, ‘You shall love your neighbor as yourself.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","The young man said to Him, “All these have I kept from my youth. What do I still lack?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus said to him, “If you desire to be perfect, go, sell your belongings and give to the poor, and you shall have treasure in heaven; and come, follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","But when the young man heard this statement, he went away grieved, for he had many possessions. ");
INSERT INTO engemtv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Then Jesus said to His disciples, “Assuredly I say to you, that with difficulty a rich man shall enter the kingdom of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","And again I say to you, it is easier for a camel to pass through the eye of a needle than for a rich man to enter the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","And when His disciples heard, they were greatly astonished, and said, “Who then is able to be saved?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","And looking at them, Jesus said to them, “With men this is impossible, but with God all things are possible.” ");
INSERT INTO engemtv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Then Peter answered and said to Him, “See, we have left all and followed You. What then shall we have?” ");
INSERT INTO engemtv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","So Jesus said to them, “Assuredly I say to you, that in the Regeneration, when the Son of Man sits on His glorious throne, you who have followed Me will also sit on twelve thrones, judging the twelve tribes of Israel. ");
INSERT INTO engemtv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","And everyone who has left houses or brothers or sisters or father or mother or wife or children or lands, for My name's sake, shall receive a hundredfold, and shall inherit eternal life. ");
INSERT INTO engemtv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","But many who are first will be last, and the last first. ");
INSERT INTO engemtv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“For the kingdom of heaven is like a certain landowner who went out early in the morning to hire workers for his vineyard. ");
INSERT INTO engemtv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","And having agreed with the workers for a denarius a day, he sent them into his vineyard. ");
INSERT INTO engemtv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","And going out about the third hour, he saw others standing idle in the marketplace. ");
INSERT INTO engemtv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","And said to them, ‘You also go into the vineyard, and whatever may be right I will give you.’ So they went. ");
INSERT INTO engemtv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Again going out about the sixth and the ninth hour, he did likewise. ");
INSERT INTO engemtv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","And about the eleventh hour, going out he found others standing idle, and said to them, ‘Why do you stand here idle all day?’ ");
INSERT INTO engemtv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","They said to him, ‘Because no one has hired us.’ He said to them, ‘You also go into the vineyard, and whatever is right you shall receive.’ ");
INSERT INTO engemtv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“So when evening came, the owner of the vineyard said to his foreman, ‘Call the workers and pay them their wages, beginning with the last to the first.’ ");
INSERT INTO engemtv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","And when those came who were hired about the eleventh hour, they each received a denarius. ");
INSERT INTO engemtv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","But when the first came, they supposed that they would receive more; and they also received each a denarius. ");
INSERT INTO engemtv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","And when they had received it, they began grumbling against the landowner, ");
INSERT INTO engemtv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","saying, ‘These last men have worked only one hour, and you made them equal to us who have borne the burden and the heat of the day.’ ");
INSERT INTO engemtv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","But he answered one of them and said, ‘Friend, I am not wronging you. Did you not agree with me for a denarius? ");
INSERT INTO engemtv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Take what is yours and go. But I want to give to this last man the same as to you. ");
INSERT INTO engemtv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Is it not lawful for me to do what I wish with my own things? Or is your eye evil because I am good?’ ");
INSERT INTO engemtv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Thus the last shall be first, and the first last. For many are called, but few are chosen.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","And as Jesus was going up to Jerusalem, He took aside the twelve disciples privately on the road, and He said to them, ");
INSERT INTO engemtv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Behold, we are going up to Jerusalem, and the Son of Man will be betrayed to the chief priests and scribes, and they will condemn Him to death, ");
INSERT INTO engemtv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","and they will hand Him over to the Gentiles to mock and to scourge and to crucify. And the third day He shall rise again.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Then the mother of Zebedee's sons came to Him with her sons, worshiping Him, and asking something from Him. ");
INSERT INTO engemtv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","And He said to her, “What do you desire?” She said to Him, “Grant that these two sons of mine may sit, one on Your right hand and one on Your left, in Your kingdom.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","But Jesus answered and said, “You do not know what you ask. Are you able to drink the cup which I am about to drink, or to be baptized with the baptism that I am baptized with?” They said to Him, “We are able.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","So He said to them, “You will indeed drink My cup, and be baptized with the baptism with which I am baptized with; but to sit on My right hand and on My left is not Mine to give, but it is to those for whom it has been prepared by My Father.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","And when the ten heard it, they were indignant with the two brothers. ");
INSERT INTO engemtv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","But Jesus, having summoned them, said, “You know that the rulers of the Gentiles lord it over them, and their great ones exercise authority over them. ");
INSERT INTO engemtv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yet it shall not be so among you; but whoever desires to become great among you, shall be your servant. ");
INSERT INTO engemtv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","And whoever desires to be first among you, let him be your slave; ");
INSERT INTO engemtv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","just as the Son of Man did not come to be served, but to serve, and to give His life as a ransom for many.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Now as they went out from Jericho, a great crowd followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","And behold, two blind men sitting alongside the road, when they heard that Jesus was passing by, cried out, saying, “Have pity on us, O Lord, Son of David!” ");
INSERT INTO engemtv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","But the crowd warned them that they should be silent; but they cried out all the more, saying, “Have pity on us, O Lord, Son of David!” ");
INSERT INTO engemtv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","And having stood still, Jesus called them, and said, “What do you desire that I should do for you?” ");
INSERT INTO engemtv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","They said to Him, “Lord, that our eyes may be opened.” ");
INSERT INTO engemtv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","And Jesus, having compassion, touched their eyes, and immediately their eyes received sight, and they followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Now when they drew near Jerusalem, and came to Bethphage, towards the Mount of Olives, then Jesus sent two disciples, ");
INSERT INTO engemtv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","saying to them, “Go into the village opposite you, and immediately you will find a donkey tied up, and a colt with her. Loose them and bring them to Me. ");
INSERT INTO engemtv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","And if anyone asks you anything, you shall say, ‘The Lord has need of them,’ and immediately he will send them.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Now all this took place so that it might be fulfilled which was spoken by the prophet, saying: ");
INSERT INTO engemtv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Say to the daughter of Zion, ‘Behold, your King is coming to you, humble, and sitting on a donkey, a colt, the foal of a donkey.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","So the disciples went, and did just as Jesus ordered them. ");
INSERT INTO engemtv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","They brought the donkey and the colt, and they laid their clothes on them, and they set Him on them. ");
INSERT INTO engemtv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","And a very large crowd spread their clothes on the road; but others were cutting down branches from the trees and were spreading them on the road. ");
INSERT INTO engemtv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Then the crowds who went before, and those following were crying out, saying: “Hosanna to the Son of David! ‘Blessed is He who comes in the name of the Lord!’ Hosanna in the highest!” ");
INSERT INTO engemtv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","And when He entered into Jerusalem, all the city was stirred up, saying, “Who is this?” ");
INSERT INTO engemtv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","And the crowds were saying, “This is Jesus, the prophet from Nazareth of Galilee.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Then Jesus went into the temple of God and He cast out all those buying and selling in the temple, and He overturned the tables of the moneychangers and the seats of those selling doves. ");
INSERT INTO engemtv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","And He said to them, “It is written, ‘My house shall be called a house of prayer,’ but you have made it a ‘den of thieves.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Then the lame and the blind came to Him in the temple, and He healed them. ");
INSERT INTO engemtv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","But when the chief priests and scribes saw the wonders which He did, and the children crying out in the temple and saying, “Hosanna to the Son of David,” they became indignant, ");
INSERT INTO engemtv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","and said to Him, “Do You hear what these children are saying?” And Jesus said to them, “Yes. Have you never read, ‘Out of the mouth of babes and nursing infants You have perfected praise’?” ");
INSERT INTO engemtv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","And having left them, He went out of the city to Bethany, and lodged there. ");
INSERT INTO engemtv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Now in the early morning, returning to the city, He became hungry. ");
INSERT INTO engemtv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","And seeing a fig tree by the road, He went up to it and found nothing on it but leaves, and said to it, “May no fruit come from you ever again!” And immediately the fig tree withered away. ");
INSERT INTO engemtv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","And when the disciples saw it, they marveled, saying, “How did the fig tree wither away so soon?” ");
INSERT INTO engemtv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","So Jesus answered and said to them, “Assuredly I say to you, if you have faith and do not doubt, you will not only do what was done to the fig tree, but even if you should say to this mountain, ‘Be taken up and cast into the sea,’ it will happen. ");
INSERT INTO engemtv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","And all things, as many as you may ask in prayer, believing, you shall receive.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Now as He came into the temple, the chief priests and the elders of the people confronted Him as He was teaching, and said, “By what authority are You doing these things? And who gave You this authority?” ");
INSERT INTO engemtv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","But Jesus answered and said to them, “I also will ask you one thing, which if you tell Me, I likewise will tell you by what authority I do these things: ");
INSERT INTO engemtv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","The baptism of John—where was it from? From heaven or from men?” And they were arguing among themselves, saying, “If we say, ‘From heaven,’ He will say to us, ‘Why then did you not believe him?’ ");
INSERT INTO engemtv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","But if we should say, ‘From men,’ we fear the crowd, for all regard John as a prophet.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","So they answered Jesus and said, “We do not know.” And He said to them, “Neither will I tell you by what authority I do these things. ");
INSERT INTO engemtv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“But what do you think? A man had two children. And having come to the first, he said, ‘Son, go work today in my vineyard.’ ");
INSERT INTO engemtv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","But he answered and said, ‘I will not,’ but later he regretted it and went. ");
INSERT INTO engemtv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","And having come to the other, he said likewise. And he answered and said, ‘I am going, sir,’ but he did not go. ");
INSERT INTO engemtv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Which of the two did the will of his father?” They said to Him, “The first.” Jesus said to them, “Assuredly I say to you, that tax collectors and harlots enter the kingdom of God before you. ");
INSERT INTO engemtv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","For John came to you in the way of righteousness, and you did not believe him; but tax collectors and harlots believed him; but you, having seen, did not repent afterwards, that you might believe him. ");
INSERT INTO engemtv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Hear another parable: There was a certain landowner who planted a vineyard and set a hedge around it, dug a winepress in it and built a tower. And he leased it to farmers and went away on a journey. ");
INSERT INTO engemtv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Now when the harvest time of fruits drew near, he sent his servants to the farmers, that they might collect his fruits. ");
INSERT INTO engemtv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","And the farmers took his servants, and they beat one, and killed another, and stoned another. ");
INSERT INTO engemtv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Again he sent other servants, more than the first, and they did to them likewise. ");
INSERT INTO engemtv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","And at last he sent to them his son, saying, ‘Surely they will respect my son.’ ");
INSERT INTO engemtv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","But when the farmers saw the son, they said among themselves, ‘This is the heir. Come, let us kill him, and let us gain possession of his inheritance.’ ");
INSERT INTO engemtv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","And taking him, they cast him out of the vineyard and killed him. ");
INSERT INTO engemtv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Therefore, when the owner of the vineyard comes, what will he do to those farmers?” ");
INSERT INTO engemtv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","They said to Him, “He will destroy those wicked men miserably, and lease his vineyard to other farmers, who will render to him the fruits in their seasons.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus said to them, “Have you never read in the Scriptures: ‘The stone which the builders rejected has become the chief cornerstone. This was the Lord's doing, and it is marvelous in our eyes’? ");
INSERT INTO engemtv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Therefore I say to you, the kingdom of God shall be taken away from you, and it shall be given to a nation producing the fruits of it. ");
INSERT INTO engemtv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","And he who falls on this stone will be broken to pieces; but on whomever it falls, it will grind him to powder.” ");
INSERT INTO engemtv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Now when the chief priests and Pharisees heard His parables, they knew that He was speaking about them. ");
INSERT INTO engemtv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","And seeking to seize Him, they feared the crowds, since they considered Him to be a prophet. ");
INSERT INTO engemtv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","And Jesus answered and spoke to them again in parables, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“The kingdom of heaven is like a certain king who arranged a wedding for his son, ");
INSERT INTO engemtv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","and sent out his servants to call those who were invited to the wedding; and they did not want to come. ");
INSERT INTO engemtv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Again, he sent out other servants, saying, ‘Say to those who are invited, “See, I have prepared my dinner; my oxen and fatted cattle are killed, and all things are ready. Come to the wedding.” ’ ");
INSERT INTO engemtv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","But not caring, they went away, one to his own field, another to his business. ");
INSERT INTO engemtv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","And the rest seized his servants, mistreated them, and killed them. ");
INSERT INTO engemtv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","And when that king heard, he was furious. And he sent out his troops, and he destroyed those murderers, and he burned up their city. ");
INSERT INTO engemtv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Then he said to his servants, ‘The wedding indeed is ready, but those who were invited were not worthy. ");
INSERT INTO engemtv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Therefore go into the highways, and as many as you find, invite to the wedding.’ ");
INSERT INTO engemtv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","So those servants went out into the highways and gathered together all whom they found, both bad and good. And the wedding hall was filled with guests. ");
INSERT INTO engemtv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“But when the king came in to see the guests, he saw a man there not dressed with wedding clothes. ");
INSERT INTO engemtv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","So he said to him, ‘Friend, how did you come in here not having wedding clothes?’ And he was speechless. ");
INSERT INTO engemtv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Then the king said to the servants, ‘Tie him up hands and feet, take him away, and cast him into outer darkness; there shall be weeping and gnashing of teeth.’ ");
INSERT INTO engemtv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“For many are called, but few are chosen.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Then the Pharisees went and plotted how they might trap Him in His speech. ");
INSERT INTO engemtv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","And they sent their disciples to Him with the Herodians, saying, “Teacher, we know that You are true, and teach the way of God in truth; nor do You show favoritism to anyone. ");
INSERT INTO engemtv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tell us, therefore, what do You think? Is it lawful to pay taxes to Caesar, or not?” ");
INSERT INTO engemtv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","But Jesus, knowing their wickedness, said, “Why do you test Me, you hypocrites? ");
INSERT INTO engemtv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Show Me the tax money.” So they brought Him a denarius. ");
INSERT INTO engemtv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","And He said to them, “Whose image and inscription is this?” ");
INSERT INTO engemtv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","They said to Him, “Caesar's.” And He said to them, “Render therefore to Caesar the things that are Caesar's, and to God the things that are God's.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","When they had heard these words, they marveled, and leaving Him, they went away. ");
INSERT INTO engemtv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","The same day the Sadducees, who say there is no resurrection, came to Him, and they questioned Him, ");
INSERT INTO engemtv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","saying: “Teacher, Moses said that if a man dies, having no children, his brother shall marry his wife as next of kin, and shall raise up offspring for his brother. ");
INSERT INTO engemtv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Now there were with us seven brothers. The first died, after having married, and having no offspring, he left his wife to his brother. ");
INSERT INTO engemtv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Likewise the second also, and the third, down to the seventh. ");
INSERT INTO engemtv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Last of all the woman died also. ");
INSERT INTO engemtv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Therefore, in the resurrection, whose wife of the seven will she be? For they all had married her.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus answered and said to them, “You err, not knowing the Scriptures, nor the power of God! ");
INSERT INTO engemtv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","For in the resurrection neither do they marry, nor are they given in marriage, but they are like angels of God in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","But concerning the resurrection of the dead, have you not read what was spoken to you by God, saying, ");
INSERT INTO engemtv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘I am the God of Abraham, and the God of Isaac, and the God of Jacob’? God is not the God of the dead, but of the living.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","And when the crowds heard this, they were astonished at His teaching. ");
INSERT INTO engemtv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","But when the Pharisees heard that He had silenced the Sadducees, they gathered together. ");
INSERT INTO engemtv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Then one of them, a lawyer, asked Him a question, testing Him, and saying, ");
INSERT INTO engemtv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Teacher, which is the great commandment in the law?” ");
INSERT INTO engemtv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus said to him, “ ‘You shall love the Lord your God with all your heart, and with all your soul, and with all your mind.’ ");
INSERT INTO engemtv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","This is the first and great commandment. ");
INSERT INTO engemtv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","And the second is like it: ‘You shall love your neighbor as yourself.’ ");
INSERT INTO engemtv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","On these two commandments hang all the Law and the Prophets.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","And when the Pharisees were gathered together, Jesus asked them, ");
INSERT INTO engemtv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","saying, “What do you think about the Christ? Whose Son is He?” They said to Him, “David's.” ");
INSERT INTO engemtv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","He said to them, “How then does David in the Spirit call Him ‘Lord,’ saying: ");
INSERT INTO engemtv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘The Lord said to my Lord, “Sit at My right hand, till I make Your enemies a footstool for Your feet” ’? ");
INSERT INTO engemtv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","If David therefore calls Him ‘Lord,’ how is He his Son?” ");
INSERT INTO engemtv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","And no one was able to answer Him a word, nor from that day on did anyone dare question Him any longer. ");
INSERT INTO engemtv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Then Jesus spoke to the crowds and to His disciples, ");
INSERT INTO engemtv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","saying: “The scribes and the Pharisees sit on Moses' seat. ");
INSERT INTO engemtv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Therefore whatever they may say to you to observe, observe and do, but do not do according to their works; for they say, and do not do. ");
INSERT INTO engemtv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","For they bind heavy burdens, hard to bear, and lay them on men's shoulders; but they do not desire to move them with their finger. ");
INSERT INTO engemtv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","But all their works they do in order to be seen by men. They make their phylacteries broad and they enlarge the borders of their garments. ");
INSERT INTO engemtv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","They love the first couch at banquets, and the best seats in the synagogues, ");
INSERT INTO engemtv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","and greetings in the marketplaces, and to be called by men, ‘Rabbi, Rabbi.’ ");
INSERT INTO engemtv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","But you, do not be called ‘Rabbi’; for One is your Teacher, the Christ, and you are all brothers. ");
INSERT INTO engemtv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Do not call anyone on earth your father; for One is your Father, He who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Neither be called teachers; for One is your Teacher, the Christ. ");
INSERT INTO engemtv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","But the greatest of you shall be your servant. ");
INSERT INTO engemtv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","And whoever exalts himself shall be humbled, and whoever humbles himself shall be exalted. ");
INSERT INTO engemtv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“But woe to you, scribes and Pharisees, hypocrites! Because you devour widows' houses, and for a pretense make long prayers. Therefore you will receive greater condemnation. ");
INSERT INTO engemtv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Woe to you, scribes and Pharisees, hypocrites! Because you shut up the kingdom of heaven before men; for you do not enter, nor do you allow those who are entering to go in. ");
INSERT INTO engemtv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Woe to you, scribes and Pharisees, hypocrites! Because you travel around land and sea to make one proselyte, and whenever he becomes one, you make him twice as much a son of hell as you. ");
INSERT INTO engemtv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Woe to you, blind guides, who say, ‘Whoever swears by the temple, it is nothing; but whoever swears by the gold of the temple, is obligated.’ ");
INSERT INTO engemtv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fools and blind! For which is greater, the gold or the temple that sanctifies the gold? ");
INSERT INTO engemtv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","And, ‘Whoever swears by the altar, it is nothing; but whoever swears by the gift that is on it, is obligated.’ ");
INSERT INTO engemtv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fools and blind! For which is greater, the gift, or the altar that sanctifies the gift? ");
INSERT INTO engemtv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Therefore he that swears by the altar, swears by it and by all the things on it. ");
INSERT INTO engemtv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","He that swears by the temple, swears by it and by Him who dwelt in it. ");
INSERT INTO engemtv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","And he that swears by heaven, swears by the throne of God and by Him who sits on it. ");
INSERT INTO engemtv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Woe to you, scribes and Pharisees, hypocrites! Because you pay tithes of mint and dill and cummin, and have neglected the more important things of the law: justice and mercy and faith. These things you ought to have done, and not have neglected the others. ");
INSERT INTO engemtv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Blind guides, you who strain out a gnat, but swallow a camel! ");
INSERT INTO engemtv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Woe to you, scribes and Pharisees, hypocrites! Because you clean the outside of the cup and dish, but inside they are full of greed and unrighteousness. ");
INSERT INTO engemtv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Blind Pharisee, first clean the inside of the cup and dish, so that the outside of them may be clean also. ");
INSERT INTO engemtv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Woe to you, scribes and Pharisees, hypocrites! For you are like whitewashed tombs, which indeed appear beautiful outwardly, but inside are full of dead men's bones and of all uncleanness. ");
INSERT INTO engemtv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Thus also you outwardly appear righteous to men, but inside you are full of hypocrisy and lawlessness. ");
INSERT INTO engemtv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Woe to you, scribes and Pharisees, hypocrites! Because you build the tombs of the prophets and adorn the monuments of the righteous, ");
INSERT INTO engemtv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","and say, ‘If we had lived in the days of our fathers, we would not have been partakers with them in the blood of the prophets.’ ");
INSERT INTO engemtv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","“So that you testify against yourselves that you are sons of those who killed the prophets. ");
INSERT INTO engemtv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","And you, fill up then, the measure of your fathers' guilt. ");
INSERT INTO engemtv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Serpents! Brood of vipers! How shall you escape from the condemnation of hell? ");
INSERT INTO engemtv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Therefore, behold, I send you prophets, wise men, and scribes: some of them you will kill and you will crucify, and some of them you will flog in your synagogues and you will persecute from city to city, ");
INSERT INTO engemtv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","so that on you may come all the righteous blood being shed on the earth, from the blood of righteous Abel to the blood of Zechariah, son of Berechiah, whom you murdered between the temple and the altar. ");
INSERT INTO engemtv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Assuredly I say to you, all these things shall come upon this generation. ");
INSERT INTO engemtv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem, you who kills the prophets and stones those who are sent to her! How often would I have gathered your children together, as a hen gathers her chicks under her wings, but you were not willing! ");
INSERT INTO engemtv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Behold, your house is left to you desolate. ");
INSERT INTO engemtv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","For I say to you, you shall by no means see Me from now until you say, ‘Blessed is He who comes in the name of the Lord!’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Then Jesus went out and departed from the temple, and His disciples came to Him to point out to Him the buildings of the temple. ");
INSERT INTO engemtv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","But Jesus said to them, “Do you not see all these things? Assuredly I say to you, by no means will a stone be left here upon a stone, which shall not be thrown down.” ");
INSERT INTO engemtv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","And as He was sitting on the Mount of Olives, the disciples came to Him privately, saying, “Tell us, when shall these things be? And what shall be the sign of Your coming, and of the end of the age?” ");
INSERT INTO engemtv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","And Jesus answered and said to them: “Take heed that no one deceives you. ");
INSERT INTO engemtv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","For many will come in My name, saying, ‘I am the Christ,’ and will deceive many. ");
INSERT INTO engemtv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","And you will hear of wars and rumors of wars. See that you are not disturbed; for all these things must come to pass, but the end is not yet. ");
INSERT INTO engemtv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","For nation shall rise up against nation, and kingdom against kingdom, and there will be famines, pestilences, and earthquakes in various places. ");
INSERT INTO engemtv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","But all these things are the beginning of birth pains. ");
INSERT INTO engemtv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Then they will hand you over to tribulation and they will kill you, and you will be hated by all nations, on account of My name. ");
INSERT INTO engemtv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","And then many will fall away, and they will betray one another, and they will hate one another. ");
INSERT INTO engemtv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Then many false prophets will be raised up, and they will deceive many. ");
INSERT INTO engemtv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","And because lawlessness will increase, the love of many will grow cold. ");
INSERT INTO engemtv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","But he who endures to the end shall be saved. ");
INSERT INTO engemtv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","And this gospel of the kingdom will be proclaimed in all the world for a testimony to all the nations, and then the end will come. ");
INSERT INTO engemtv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Therefore when you see the ‘abomination of desolation,’ spoken of through Daniel the prophet, standing in the holy place” (whoever reads, let him understand), ");
INSERT INTO engemtv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“then let those who are in Judea flee upon the mountains. ");
INSERT INTO engemtv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Let the one on the housetop not go down to take the things out of his house. ");
INSERT INTO engemtv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","And let the one in the field not turn back to take his clothes. ");
INSERT INTO engemtv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","But woe to those women who are pregnant, and to the women nursing a baby in those days! ");
INSERT INTO engemtv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","But pray that your flight may not take place in winter, nor on the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","For then there shall be great tribulation, such as has not been since the beginning of the world until now, nor by any means shall be. ");
INSERT INTO engemtv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","And unless those days were cut short, no flesh would be saved; but for the elect's sake, those days will be cut short. ");
INSERT INTO engemtv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Then if someone says to you, ‘Look, here is the Christ!’ or ‘There!’ do not believe it. ");
INSERT INTO engemtv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","For false christs and false prophets will be raised up, and they will show great signs and wonders so as to deceive, if possible, even the elect. ");
INSERT INTO engemtv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","See, I have told you in advance. ");
INSERT INTO engemtv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Therefore if they should say to you, ‘Look, He is in the desert!’ do not go out; or ‘Look, He is in the inner rooms!’ do not believe it. ");
INSERT INTO engemtv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","For as the lightning comes out from the east and flashes to the west, so also will be the coming of the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","For wherever the carcass may be, there the eagles will be gathered together. ");
INSERT INTO engemtv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Immediately after the tribulation of those days, the sun shall be darkened, and the moon shall not give its light; and the stars shall fall from heaven, and the powers of the heavens shall be shaken. ");
INSERT INTO engemtv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","And then shall appear the sign of the Son of Man in heaven, and then all the tribes of the earth shall mourn, and they shall see the Son of Man coming on the clouds of heaven with power and great glory. ");
INSERT INTO engemtv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","And He shall send His angels with a great sound of a trumpet, and they shall gather together His elect from the four winds, from one end of heaven to the other. ");
INSERT INTO engemtv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Now learn this parable from the fig tree: Whenever its branch already becomes tender and puts forth leaves, you know that summer is near. ");
INSERT INTO engemtv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","So you also, whenever you see all these things, know that it is near—at the doors! ");
INSERT INTO engemtv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Assuredly I say to you, this generation shall by no means pass away till all these things are fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Heaven and earth shall pass away, but My words shall by no means pass away. ");
INSERT INTO engemtv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“But concerning that day and hour no one knows, not even the angels of heaven, but My Father only. ");
INSERT INTO engemtv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","But just as the days of Noah were, so also shall be the coming of the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","For just as they were in the days before the flood, eating and drinking, marrying and giving in marriage, until the day that Noah entered into the ark, ");
INSERT INTO engemtv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","and they didn't know a thing until the flood came and took them all away, so also shall be the coming of the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Then two will be in the field: one will be taken, and one will be left. ");
INSERT INTO engemtv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Two will be grinding at the mill: one will be taken, and one will be left. ");
INSERT INTO engemtv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Watch therefore, for you do not know in what hour your Lord is coming. ");
INSERT INTO engemtv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","But know this, that if the master of the house had known in what hour the thief was coming, he would have kept watch, and he would not have allowed his house to be broken into. ");
INSERT INTO engemtv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","For this reason you also must be ready, for at an hour that you think not, the Son of Man comes. ");
INSERT INTO engemtv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Who then is a faithful and wise servant, whom his master appointed over his household, to give them food in due season? ");
INSERT INTO engemtv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Blessed is that servant whom his master, when he comes, will find so doing. ");
INSERT INTO engemtv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Assuredly I say to you that he will make him ruler over all his possessions. ");
INSERT INTO engemtv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","But if that evil servant should say in his heart, ‘My master is delaying to come,’ ");
INSERT INTO engemtv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","and should begin to beat his fellow servants, and to eat and drink with the drunkards, ");
INSERT INTO engemtv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","the master of that servant will come on a day which he does not expect, and in an hour which he does not know, ");
INSERT INTO engemtv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","and he will cut him in two, and will appoint his share with the hypocrites. There shall be weeping and gnashing of teeth. ");
INSERT INTO engemtv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Then shall the kingdom of heaven be likened unto ten virgins, who having taken their lamps, went out to meet the bridegroom. ");
INSERT INTO engemtv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Now five of them were wise, and five were foolish. ");
INSERT INTO engemtv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Those who were foolish, having taken their lamps, did not take oil with them, ");
INSERT INTO engemtv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","but the wise took oil in their vessels along with their lamps. ");
INSERT INTO engemtv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","But while the bridegroom was delayed, they all became drowsy and slept. ");
INSERT INTO engemtv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“And at midnight a cry was heard: ‘Behold, the bridegroom is coming; go out to meet him!’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Then all those virgins arose, and they trimmed their lamps. ");
INSERT INTO engemtv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","And the foolish said to the wise, ‘Give us some of your oil, for our lamps are going out.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","But the wise answered, saying, ‘No, lest there should not be enough for you and us; but go rather to those who sell, and buy for yourselves.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","But as they went away to buy, the bridegroom came, and those who were ready went in with him to the wedding; and the door was shut. ");
INSERT INTO engemtv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Afterward the remaining virgins came also, saying, ‘Lord, Lord, open to us!’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","But he answered and said, ‘Assuredly I say to you, I do not know you.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Watch therefore, for you do not know the day nor the hour in which the Son of Man is coming. ");
INSERT INTO engemtv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“For it is as if a man leaving on a journey, who called his own servants and handed over his possessions to them. ");
INSERT INTO engemtv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","And to the one he gave five talents, and to another two, and to another one, to each according to his own ability; and immediately he went on a journey. ");
INSERT INTO engemtv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Then the one receiving the five talents went and traded with them, and made five other talents. ");
INSERT INTO engemtv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","And likewise the one receiving the two gained two more also. ");
INSERT INTO engemtv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","But the one receiving one went away and dug in the ground, and hid his lord's money. ");
INSERT INTO engemtv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Then after much time, the lord of those servants returned and settled accounts with them. ");
INSERT INTO engemtv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“And the one who had received five talents came and brought five other talents, saying, ‘Lord, you delivered to me five talents; look, I gained five more talents besides them.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","His lord said to him, ‘Well done, good and faithful servant; you were faithful over a few things, I will make you ruler over many things. Enter into the joy of your lord.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","And also the one receiving the two talents came and said, ‘Lord, you delivered to me two talents; look, I have gained two more talents besides them.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","His lord said to him, ‘Well done, good and faithful servant; you have been faithful over a few things, I will make you ruler over many things. Enter into the joy of your lord.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Then the one having received the one talent came and said, ‘Lord, I knew you, that you are a hard man, reaping where you did not sow, and gathering where you did not scatter. ");
INSERT INTO engemtv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","And being afraid, I went off and hid your talent in the ground. Look, you have what is yours.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“But his lord answered and said to him, ‘You wicked and slothful servant, you knew that I reap where I did not sow, and gather where I did not scatter. ");
INSERT INTO engemtv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Therefore you should have deposited my money with the bankers, and at my coming I would have received what is mine with interest. ");
INSERT INTO engemtv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Therefore take the talent from him, and give it to him who has the ten talents. ");
INSERT INTO engemtv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“ ‘For to everyone who has, more shall be given, and he shall have abundance; but to him who does not have, even what he has shall be taken away from him. ");
INSERT INTO engemtv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","And cast the useless servant into outer darkness. There shall be weeping and gnashing of teeth.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“And when the Son of Man comes in His glory, and all the holy angels with Him, then will He sit upon His glorious throne. ");
INSERT INTO engemtv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","All the nations will be gathered before Him, and He will separate them one from another, as a shepherd separates the sheep from the goats. ");
INSERT INTO engemtv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","And He will set the sheep on His right hand, but the goats on His left. ");
INSERT INTO engemtv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Then the King will say to those on His right hand, ‘Come, you blessed of My Father, inherit the kingdom prepared for you from the foundation of the world: ");
INSERT INTO engemtv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","for I was hungry and you gave Me food; I was thirsty and you gave Me drink; I was a stranger and you took Me in; ");
INSERT INTO engemtv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","I was naked and you clothed Me; I was sick and you visited Me; I was in prison and you came to Me.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Then the righteous will answer Him, saying, ‘Lord, when did we see You hungry and feed You, or thirsty and give You drink? ");
INSERT INTO engemtv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","When did we see You a stranger and take You in, or naked and clothe You? ");
INSERT INTO engemtv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Or when did we see You sick, or in prison, and come to You?’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","And the King will answer and say to them, ‘Assuredly I say to you, inasmuch as you did it to one of the least of these My brothers, you did it to Me.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Then He will also say to those on the left, ‘Depart from Me, you cursed, into the eternal fire prepared for the devil and his angels: ");
INSERT INTO engemtv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","for I was hungry and you gave Me no food; I was thirsty and you gave Me no drink; ");
INSERT INTO engemtv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","I was a stranger and you did not take Me in, naked and you did not clothe Me, sick and in prison and you did not visit Me.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Then they also will answer, saying, ‘Lord, when did we see You hungry or thirsty or a stranger or naked or sick or in prison, and we did not minister to You?’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Then He will answer them, saying, ‘Assuredly I say to you, inasmuch as you did not do it to one of the least of these, neither did you do it to Me.’ ");
INSERT INTO engemtv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","And these shall go away into eternal punishment, but the righteous into eternal life.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Now it came to pass, when Jesus had finished all these words, that He said to His disciples, ");
INSERT INTO engemtv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“You know that after two days the Passover takes place, and the Son of Man will be handed over to be crucified.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Then the chief priests, the scribes, and the elders of the people were assembled into the court of the high priest, who was called Caiaphas, ");
INSERT INTO engemtv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","and plotted to take Jesus by guile and kill Him. ");
INSERT INTO engemtv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","But they said, “Not during the feast, lest a disturbance take place among the people.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","And when Jesus was in Bethany in the house of Simon the leper, ");
INSERT INTO engemtv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a woman came to Him having an alabaster flask of very expensive perfume, and she began to pour it on His head as He reclined to eat. ");
INSERT INTO engemtv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","But when His disciples saw it, they became indignant, saying, “Why this waste? ");
INSERT INTO engemtv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","For this perfume could have been sold for much, and given to the poor.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","But when Jesus became aware of it, He said to them, “Why do you trouble the woman? For she has done a beautiful work for Me. ");
INSERT INTO engemtv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","For you have the poor with you always, but Me you do not have always. ");
INSERT INTO engemtv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","For this woman, having put this perfume on My body, has done this for My burial. ");
INSERT INTO engemtv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Assuredly I say to you, wherever this gospel is proclaimed in the whole world, what this woman has done will be spoken of as a memorial to her.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Then one of the twelve, called Judas Iscariot, went to the chief priests ");
INSERT INTO engemtv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","and said, “What are you willing to give me if I deliver Him to you?” And they weighed out for him thirty silver coins. ");
INSERT INTO engemtv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","And from then on he sought an opportunity to betray Him. ");
INSERT INTO engemtv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Now on the first day of the Feast of the Unleavened Bread, the disciples came to Jesus, saying to Him, “Where do You desire that we shall prepare for You to eat the Passover?” ");
INSERT INTO engemtv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","And He said, “Go into the city to a certain man, and say to him, ‘The Teacher says, “My time is near; I will keep the Passover at your house with My disciples.” ’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","So the disciples did as Jesus had directed them; and they prepared the Passover. ");
INSERT INTO engemtv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","And when it was evening, He was reclining to eat with the twelve. ");
INSERT INTO engemtv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Now while they were eating, He said, “Assuredly I say to you, that one of you will betray Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","And becoming exceedingly sorrowful, each of them began to say to Him, “Surely not I, Lord?” ");
INSERT INTO engemtv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","He answered and said, “He who dipped his hand with Me in the bowl will betray Me. ");
INSERT INTO engemtv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Indeed, the Son of Man goes just as it is written about Him, but woe to that man through whom the Son of Man is betrayed! It would have been good for that man if he had not been born.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Then Judas, the one betraying Him, answered and said, “Surely not I am the one, Rabbi?” He said to him, “You have said it.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","And as they were eating, Jesus took the bread, and giving thanks, He broke it, and gave it to the disciples and said, “Take, eat; this is My body.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Then He took the cup, and gave thanks, and gave it to them, saying, “Drink of it, all of you, ");
INSERT INTO engemtv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","for this is My blood of the new covenant, which is shed for many, for the forgiveness of sins. ");
INSERT INTO engemtv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","But I say to you, that I will by no means drink of this fruit of the vine from now on, until that day when I drink it new with you in My Father's kingdom.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","And having sung hymns, they went out to the Mount of Olives. ");
INSERT INTO engemtv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Then Jesus said to them, “All of you will be made to stumble because of Me on this night, for it is written: ‘I will strike the Shepherd, and the sheep of the flock will be scattered.’ ");
INSERT INTO engemtv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","But after I have been raised, I will go before you to Galilee.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter answered and said to Him, “Even if all may fall away because of You, yet I will never fall away.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus said to him, “Assuredly I say to you that on this night, before the rooster crows, you will deny Me three times.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter said to Him, “Even if I have to die with You, by no means will I deny You!” And likewise said all the disciples. ");
INSERT INTO engemtv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Then Jesus came with them to a place called Gethsemane, and said to the disciples, “Sit here while I go off and pray over there.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","And taking along Peter and the two sons of Zebedee, He began to be sorrowful and deeply distressed. ");
INSERT INTO engemtv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Then Jesus said to them, “My soul is deeply grieved, to the point of death. Stay here and keep watch with Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","He went a little farther and fell on His face, and prayed, saying, “O My Father, if it is possible, let this cup pass from Me; nevertheless, not as I will, but as You will.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Then He came to the disciples and found them sleeping, and said to Peter, “What? Were you not strong enough to watch with Me one hour? ");
INSERT INTO engemtv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Watch and pray, lest you enter into temptation. Indeed the spirit is willing, but the flesh is weak.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Again, a second time, He went away and prayed, saying, “O My Father, if this cup cannot pass away from Me unless I drink it, let Your will be done.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","And He came and found them sleeping again, for their eyes were heavy. ");
INSERT INTO engemtv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","And leaving them, He went away again, and prayed a third time, saying the same words. ");
INSERT INTO engemtv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Then He came to His disciples and said to them, “Sleep now, and rest. Behold, the hour is at hand, and the Son of Man is being betrayed into the hands of sinners. ");
INSERT INTO engemtv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Rise up, let us be going. See, he who betrays Me is at hand.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","And while He was still speaking, behold, Judas, one of the twelve came, and with him a great crowd with swords and clubs, sent from the chief priests and elders of the people. ");
INSERT INTO engemtv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Now the one betraying Him had given them a sign, saying, “Whomever I shall kiss, He is the One; seize Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","And immediately he went up to Jesus and said, “Greetings, Rabbi!” and kissed Him. ");
INSERT INTO engemtv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","But Jesus said to him, “Friend, why have you come?” Then they came and laid hands on Jesus and seized Him. ");
INSERT INTO engemtv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","And behold, one of those with Jesus stretched out his hand and drew his sword, and striking the servant of the high priest, he cut off his ear. ");
INSERT INTO engemtv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","But Jesus said to him, “Put your sword back into its place, for all those who take the sword shall perish by the sword. ");
INSERT INTO engemtv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Or do you think that I cannot now call upon My Father, and He will furnish Me with more than twelve legions of angels? ");
INSERT INTO engemtv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","How then would the Scriptures be fulfilled, that it must happen thus?” ");
INSERT INTO engemtv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","In that hour Jesus said to the crowds, “Have you come out as against a robber, with swords and clubs to arrest Me? I sat daily with you, teaching in the temple, and you did not seize Me. ");
INSERT INTO engemtv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","But all this has happened so that the Scriptures of the prophets may be fulfilled.” Then all the disciples forsook Him and fled. ");
INSERT INTO engemtv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","And those having seized Jesus led Him away to Caiaphas the high priest, where the scribes and the elders were gathered together. ");
INSERT INTO engemtv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","But Peter was following Him from a distance, up to the courtyard of the high priest. And entering inside, he sat down with the attendants to see the end. ");
INSERT INTO engemtv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Now the chief priests, the elders, and all the Sanhedrin were seeking false witnesses against Jesus, so that they might put Him to death, ");
INSERT INTO engemtv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","and they did not find any. And though many false witnesses came forward, they did not find any. But at last two false witnesses came forward ");
INSERT INTO engemtv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","and said, “This Man said, ‘I am able to destroy the temple of God, and after three days to rebuild it.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","And standing up the high priest said to Him, “Do You answer nothing? What is it these men are testifying against You?” ");
INSERT INTO engemtv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","But Jesus kept silent. And the high priest answered and said to Him, “I adjure You by the living God: Tell us if You are the Christ, the Son of God!” ");
INSERT INTO engemtv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus said to him, “You said it. Nevertheless, I say to you, from now on, you will see the Son of Man sitting at the right hand of the Power, and coming on the clouds of heaven.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Then the high priest tore his clothes, saying, “He has blasphemed! What further need do we have of witnesses? Look, now you have heard His blasphemy! ");
INSERT INTO engemtv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","What do you think?” They answered and said, “He is deserving of death.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Then they spat in His face, and beat Him with their fists; and they slapped Him, ");
INSERT INTO engemtv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","saying, “Prophesy to us, Christ! Who is he that struck You?” ");
INSERT INTO engemtv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Now Peter sat outside in the courtyard. And a servant girl came to him, saying, “You also were with Jesus of Galilee.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","But he denied it before them all, saying, “I do not know what you are saying.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","And when he had gone out to the gateway, another girl saw him and said to them there, “This man was with Jesus the Nazarene.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","But again he denied with an oath, “I do not know the Man!” ");
INSERT INTO engemtv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","And after a little while, those standing by came up and said to Peter, “Surely you also are one of them, for your accent gives you away.” ");
INSERT INTO engemtv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Then he began to curse and swear, saying, “I do not know the Man!” And immediately a rooster crowed. ");
INSERT INTO engemtv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","And Peter remembered the word of Jesus which He said to him, “Before the rooster crows, you will deny Me three times.” And going out, he wept bitterly. ");
INSERT INTO engemtv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","When morning came, all the chief priests and elders of the people plotted against Jesus, so as to put Him to death. ");
INSERT INTO engemtv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","And having bound Him, they led Him away and delivered Him to Pontius Pilate the governor. ");
INSERT INTO engemtv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Then Judas, the one betraying Him, seeing that He was condemned, feeling regret, returned the thirty silver coins to the chief priests and elders, ");
INSERT INTO engemtv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","saying, “I have sinned by betraying innocent blood.” And they said, “What is that to us? You see to it!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","And throwing the silver coins in the sanctuary, he departed; and going away, he hanged himself. ");
INSERT INTO engemtv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","But the chief priests, taking the silver coins said, “It is not lawful to put them into the temple treasury, since they are the price of blood.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","And taking counsel, they bought with them the potter's field, to bury strangers in. ");
INSERT INTO engemtv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Therefore that field has been called the Field of Blood to this day. ");
INSERT INTO engemtv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Then was fulfilled the thing spoken through Jeremiah the prophet, saying, “And they took the thirty coins, the value of Him who was priced,” whom they of the sons of Israel priced, ");
INSERT INTO engemtv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","“and they gave them for the potter's field, as the Lord directed me.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Now Jesus stood before the governor. And the governor asked Him, saying, “Are You the King of the Jews?” So Jesus said to him, “It is as you say.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","And while He was being accused by the chief priests and elders, He answered nothing. ");
INSERT INTO engemtv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Then Pilate said to Him, “Do You not hear how many things they testify against You?” ");
INSERT INTO engemtv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","And He answered him not one word, so that the governor was greatly amazed. ");
INSERT INTO engemtv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Now at the feast, the governor was accustomed to release to the crowd one prisoner whom they wished. ");
INSERT INTO engemtv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","And they had then a notorious prisoner called Barabbas. ");
INSERT INTO engemtv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Therefore when they had assembled, Pilate said to them, “Whom do you wish that I should release to you, Barabbas, or Jesus who is called Christ?” ");
INSERT INTO engemtv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","For he knew that they had handed Him over because of envy. ");
INSERT INTO engemtv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Now as he was sitting on the judgment seat, his wife sent to him, saying, “Have nothing to do with that just Man, for I have suffered many things today in a dream because of Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","But the chief priests and elders persuaded the crowds that they should ask for Barabbas, but they should destroy Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","The governor answered and said to them, “Which of the two do you wish me to release to you?” They said, “Barabbas!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate said to them, “What then shall I do with Jesus who is called Christ?” They all said to him, “Let Him be crucified!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Then the governor said, “Why, what evil did He do?” But they cried out all the more, saying, “Let Him be crucified!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","And Pilate, seeing that nothing was being gained, but rather a riot was starting, taking water, he washed his hands clean in front of the crowd, saying, “I am innocent of the blood of this just Man. You see to it.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","And all the people answered and said, “His blood be on us and on our children.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Then he released Barabbas to them; and having scourged Jesus, he delivered Him to be crucified. ");
INSERT INTO engemtv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Then the soldiers of the governor, having taken Jesus to the Praetorium, gathered the whole garrison around Him. ");
INSERT INTO engemtv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","And having stripped Him, they put a scarlet robe on Him. ");
INSERT INTO engemtv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","When they had twisted a crown of thorns, they put it on His head, and a reed in His right hand. And kneeling before Him, they mocked Him, saying, “Hail, King of the Jews!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","And spitting on Him, they took the reed and were striking Him on His head. ");
INSERT INTO engemtv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","And when they had mocked Him, they stripped Him of the robe, and dressed Him in His own clothes, and led Him away in order to crucify Him. ");
INSERT INTO engemtv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","And going out, they found a man of Cyrene, Simon by name. Him they pressed into service that he might carry His cross. ");
INSERT INTO engemtv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","And coming to a place called Golgotha, that is to say, Place of a Skull, ");
INSERT INTO engemtv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","they gave Him sour wine mingled with gall to drink. But having tasted it, He would not drink. ");
INSERT INTO engemtv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","And having crucified Him, they divided His clothes among themselves, casting lots. ");
INSERT INTO engemtv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","And sitting down, they kept watch over Him there. ");
INSERT INTO engemtv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","And they put up over His head the crime having been written against Him: THIS IS JESUS THE KING OF THE JEWS. ");
INSERT INTO engemtv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Then they crucified two thieves with Him, one on His right, and another on His left. ");
INSERT INTO engemtv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","And those passing by were blaspheming Him, shaking their heads ");
INSERT INTO engemtv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","and saying, “You who destroy the temple and build it in three days, save Yourself! If You are the Son of God, come down from the cross.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Likewise the chief priests also, mocking Him with the scribes and elders, and Pharisees, said, ");
INSERT INTO engemtv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“He saved others; Himself He cannot save. If He is the King of Israel, let Him now come down from the cross, and we will believe on Him. ");
INSERT INTO engemtv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","He trusted in God; let Him deliver Him now, if He will have Him; for He said, ‘I am the Son of God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Even the thieves who were crucified with Him were reviling Him with the same insult. ");
INSERT INTO engemtv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Now from the sixth hour until the ninth hour, darkness came upon all the land. ");
INSERT INTO engemtv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","And about the ninth hour Jesus cried out with a loud voice, saying, “Eli, Eli, lima sabachthani?” that is, “My God, My God, why have You forsaken Me?” ");
INSERT INTO engemtv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Some of those standing by, when they heard this, said, “This Man is calling Elijah!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Immediately one of them ran and took a sponge, and filled it with sour wine and put it around a reed, and offered it to Him to drink. ");
INSERT INTO engemtv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","But the rest said, “Leave Him alone; let us see if Elijah is coming to save Him.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","But Jesus, again crying out with a loud voice, released His spirit. ");
INSERT INTO engemtv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","And behold, the veil of the temple was torn in two from top to bottom; and the earth was shaken, and the rocks were split, ");
INSERT INTO engemtv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","and the tombs were opened; and many bodies of the saints who had passed away were raised; ");
INSERT INTO engemtv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","and coming forth out of the tombs after His resurrection, they entered into the holy city and appeared to many. ");
INSERT INTO engemtv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","So when the centurion and those with him guarding Jesus, when they saw the earthquake and the things that had happened, they were greatly afraid, saying, “Truly this was the Son of God!” ");
INSERT INTO engemtv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","And there were many women there observing from a distance, who followed Jesus from Galilee, ministering to Him, ");
INSERT INTO engemtv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","among whom were Mary Magdalene, Mary the mother of James and Joses, and the mother of the sons of Zebedee. ");
INSERT INTO engemtv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Now when evening had come, there came a rich man from Arimathea, named Joseph, who himself had also become a disciple of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","This man went to Pilate and asked for the body of Jesus. Then Pilate commanded the body to be given to him. ");
INSERT INTO engemtv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","And taking the body, Joseph wrapped it up in a clean linen cloth, ");
INSERT INTO engemtv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","and placed it in his new tomb which he had cut in the rock; and having rolled a large stone against the door of the tomb, he departed. ");
INSERT INTO engemtv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","And Mary Magdalene was there, and the other Mary, sitting opposite the grave. ");
INSERT INTO engemtv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","On the next day, which is after the Preparation Day, the chief priests and Pharisees were gathered together to Pilate, ");
INSERT INTO engemtv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","saying, “Sir, we remember how that deceiver said while He was still alive, ‘After three days I will rise.’ ");
INSERT INTO engemtv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Therefore command that the grave be made secure until the third day, lest His disciples come by night and steal Him, and say to the people, ‘He was raised from the dead.’ So the last deception will be worse than the first.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate said to them, “You have a guard; go make it as secure as you know how.” ");
INSERT INTO engemtv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So they went and secured the grave, sealing the stone, with the guard. ");
INSERT INTO engemtv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","But after the Sabbath, at the dawning toward the first day of the week, Mary Magdalene and the other Mary came to see the tomb. ");
INSERT INTO engemtv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","And behold, a great earthquake occurred; for an angel of the Lord, having come down out of heaven, came and rolled back the stone from the door, and sat on it. ");
INSERT INTO engemtv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","And his appearance was like lightning, and his clothing as white as snow. ");
INSERT INTO engemtv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","And the guards were shaken for fear of him, and became like dead men. ");
INSERT INTO engemtv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","But the angel answered and said to the women, “Do not be afraid, for I know that you seek Jesus who was crucified. ");
INSERT INTO engemtv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","He is not here! For He is risen, just as He said. Come; see the place where the Lord was lying. ");
INSERT INTO engemtv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","And go quickly and tell His disciples that He is risen from the dead, and behold, He is going before you into Galilee; there you will see Him. Behold, I have told you.” ");
INSERT INTO engemtv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","And going out quickly from the tomb with fear and great joy, they ran to report to His disciples. ");
INSERT INTO engemtv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","And as they were going to report to His disciples, that behold, Jesus met them, saying, “Rejoice!” So they came and held His feet and worshiped Him. ");
INSERT INTO engemtv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Then Jesus said to them, “Do not be afraid. Go, report to My brothers that they should go to Galilee, and there they will see Me.” ");
INSERT INTO engemtv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Now while they were going, behold, some of the guard came into the city and reported to the chief priests everything that had happened. ");
INSERT INTO engemtv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","When they had assembled with the elders and taking counsel, they gave sufficient silver coins to the soldiers, ");
INSERT INTO engemtv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","saying, “Tell them, ‘His disciples came at night and stole Him away while we were sleeping.’ ");
INSERT INTO engemtv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","And if this reaches the governor's ears, we will influence him and make you secure.” ");
INSERT INTO engemtv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","So they took the silver and did as they were instructed. And this saying has been widely spread among the Jews until this day. ");
INSERT INTO engemtv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Then the eleven disciples went to Galilee, to the mountain which Jesus had appointed for them. ");
INSERT INTO engemtv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","When they saw Him, they worshiped Him; but some doubted. ");
INSERT INTO engemtv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","And Jesus came and spoke to them, saying, “All authority in heaven and on earth has been given to Me. ");
INSERT INTO engemtv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Go therefore and make disciples of all nations, baptizing them in the name of the Father and of the Son and of the Holy Spirit, ");
INSERT INTO engemtv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","teaching them to observe everything that I have commanded you; and lo, I am with you always, even to the end of the age.” Amen. ");
INSERT INTO engemtv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","The beginning of the gospel of Jesus Christ, the Son of God. ");
INSERT INTO engemtv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","As it is written in the Prophets: “Behold, I send My messenger before Your face, who will prepare Your way before You.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“The voice of one crying in the wilderness: ‘In the wilderness prepare the way of the Lord; make His paths straight.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John came baptizing in the wilderness and preaching a baptism of repentance for the forgiveness of sins. ");
INSERT INTO engemtv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","And all the Judean country and the inhabitants of Jerusalem went out to him and were all baptized by him in the Jordan River, confessing their sins. ");
INSERT INTO engemtv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Now John was clothed with camel's hair and with a leather belt around his waist, and was eating locusts and wild honey. ");
INSERT INTO engemtv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","And he was preaching, saying, “There comes One after me who is stronger than me, of whom I am not worthy to stoop down and to loose the strap of His sandal. ");
INSERT INTO engemtv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","I baptized you in water, but He will baptize you in the Holy Spirit.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","It came to pass in those days that Jesus came from Nazareth of Galilee, and was baptized by John in the Jordan. ");
INSERT INTO engemtv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","And immediately, coming up from the water, He saw the heavens parting and the Spirit coming down upon Him like a dove. ");
INSERT INTO engemtv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Then a voice came from the heavens, “You are My beloved Son, in whom I am well pleased.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","And immediately the Spirit drove Him into the wilderness. ");
INSERT INTO engemtv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","And He was there in the wilderness forty days, being tempted by Satan, and was with the wild animals; and the angels were ministering to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Now after John was imprisoned, Jesus came to Galilee, preaching the gospel of the kingdom of God, ");
INSERT INTO engemtv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","and saying, “The time has been fulfilled, and the kingdom of God is at hand. Repent, and believe in the gospel.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","And as He was walking alongside the Sea of Galilee, He saw Simon and Andrew his brother casting a net into the sea; for they were fishermen. ");
INSERT INTO engemtv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Then Jesus said to them, “Come after Me, and I will make you become fishers of men.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","And immediately leaving their nets they followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","And having gone forth from there a little, He saw James the son of Zebedee, and John his brother, who also were in the boat mending their nets. ");
INSERT INTO engemtv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","And immediately He called them. And after they left their father Zebedee in the boat with the hired workers, they went away after Him. ");
INSERT INTO engemtv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","And they were going into Capernaum. And immediately on the Sabbath, He entered the synagogue and began teaching. ");
INSERT INTO engemtv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","And they were astonished at His doctrine, for He was teaching them as one who had authority, and not as the scribes. ");
INSERT INTO engemtv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Now there was a man in their synagogue with an unclean spirit, and he cried out, ");
INSERT INTO engemtv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","saying, “Let us alone! What have we to do with You, Jesus of Nazareth? Have You come to destroy us? I know who You are—the Holy One of God!” ");
INSERT INTO engemtv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","But Jesus rebuked him, saying, “Be silent, and come out of him!” ");
INSERT INTO engemtv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","And when the unclean spirit threw him into a convulsion, and crying out with a loud voice, he came out of him. ");
INSERT INTO engemtv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Then they were all amazed, so that they were disputing among themselves, saying, “What is this? What new doctrine is this, that He commands even the unclean spirits with authority, and they obey Him?” ");
INSERT INTO engemtv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","And immediately the report of Him went out into the whole surrounding region of Galilee. ");
INSERT INTO engemtv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","And immediately when they went out from the synagogue, they came to the house of Simon and Andrew, with James and John. ");
INSERT INTO engemtv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","And the mother-in-law of Simon was lying sick with a fever, and immediately they spoke to Him about her. ");
INSERT INTO engemtv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","So He came and He raised her up, grasping her hand; and immediately the fever left her. And she began to serve them. ");
INSERT INTO engemtv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Now when evening came, when the sun had set, they were bringing to Him all those who were sick, and those who were demon-possessed. ");
INSERT INTO engemtv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","And the whole city was gathered together at the door. ");
INSERT INTO engemtv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","And He healed many who were sick with various diseases, and He cast out many demons; and He did not allow the demons to speak, because they knew who He was. ");
INSERT INTO engemtv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","And in the very early morning before dawn, He arose and He went out, and went away to a deserted place; and there He was praying. ");
INSERT INTO engemtv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","And Simon and those who were with Him sought Him out. ");
INSERT INTO engemtv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","When they found Him, they said to Him, “Everyone is looking for You.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","But He said to them, “Let us go to the neighboring towns, that I may preach there also, because for this reason I have come forth.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","And He was preaching in their synagogues throughout all Galilee, and casting out demons. ");
INSERT INTO engemtv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Then a leper came to Him, beseeching Him, kneeling before Him and saying to Him, “If You are willing, You can make me clean.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","And Jesus, being moved with compassion, and reaching out His hand, touched him, and said to him, “I am willing, be cleansed.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","And when He said this, immediately the leprosy left from him, and he was cleansed. ");
INSERT INTO engemtv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","And after sternly warning him, immediately He sent him away, ");
INSERT INTO engemtv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","and said to him, “See that you say nothing to anyone; but go, show yourself to the priest, and bring as an offering concerning your cleansing those things which Moses prescribed, as a testimony to them.” ");
INSERT INTO engemtv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","But he went out and began to proclaim it freely, and to spread widely the report, so that He was no longer able to enter into a city, but was outside in deserted places; and they were coming to Him from everywhere. ");
INSERT INTO engemtv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","And He entered again into Capernaum after some days, and it was heard that He was in a certain house. ");
INSERT INTO engemtv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","And immediately many were gathered together, so that there was no longer any room, not even near the door. And He was speaking the word to them. ");
INSERT INTO engemtv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","And they came to Him, bringing a paralytic being carried by four men. ");
INSERT INTO engemtv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","And not being able to get near Him because of the crowd, they removed the tiles from the roof where He was, and having dug through they let down the bed on which the paralytic was lying. ");
INSERT INTO engemtv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","And Jesus, seeing their faith, He said to the paralytic, “Child, your sins have been forgiven you.” ");
INSERT INTO engemtv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","And some of the scribes were sitting there and reasoning in their hearts, ");
INSERT INTO engemtv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Why does this Man speak blasphemies like this? Who is able to forgive sins except God alone?” ");
INSERT INTO engemtv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","And immediately, when Jesus recognized in His spirit that they were reasoning thus among themselves, He said to them, “Why are you reasoning these things in your hearts? ");
INSERT INTO engemtv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Which is easier, to say to the paralytic, ‘Your sins have been forgiven,’ or to say, ‘Arise, take up your bed and walk’? ");
INSERT INTO engemtv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","But in order that you may know that the Son of Man has authority on the earth to forgive sins”—He said to the paralytic, ");
INSERT INTO engemtv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“I say to you, arise, and take up your bed, and go to your house.” ");
INSERT INTO engemtv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","And immediately he arose, and taking his bed, he went out before them all, so that all were amazed and glorified God, saying, “We never saw anything like this!” ");
INSERT INTO engemtv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Then He went out again alongside the sea; and all the crowd was coming to Him, and He was teaching them. ");
INSERT INTO engemtv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","And passing by, He saw Levi the son of Alphaeus sitting at the tax office, and He said to him, “Follow Me.” And arising, he followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Now it came about, as He was dining in Levi's house, that many tax collectors and sinners were dining together with Jesus and His disciples; for there were many, and they followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","And the scribes and Pharisees, seeing Him eating with the tax collectors and sinners, said to His disciples, “Why does He eat and drink with tax collectors and sinners?” ");
INSERT INTO engemtv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","When Jesus heard it, He said to them, “Those who are healthy have no need of a physician, but those who are sick. I did not come to call the righteous, but sinners, to repentance.” ");
INSERT INTO engemtv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","And the disciples of John and of the Pharisees were fasting. Then they came and said to Him, “Why do the disciples of John and of the Pharisees fast, but Your disciples do not fast?” ");
INSERT INTO engemtv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","And Jesus said to them, “Can the friends of the bridegroom fast while the bridegroom is with them? As long as they have the bridegroom with them they are not able to fast. ");
INSERT INTO engemtv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","But the days shall come when the bridegroom shall be taken away from them, and then they shall fast in those days. ");
INSERT INTO engemtv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","No one sews a patch of a piece of new cloth on an old garment; or else the new piece pulls away from the old, and the tear becomes worse. ");
INSERT INTO engemtv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","And no one puts new wine into old wineskins; otherwise the new wine bursts the wineskins, the wine spills out, and the wineskins will be ruined. But new wine must be put into new wineskins.” ");
INSERT INTO engemtv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Now it came about as He was going through the grain fields on the Sabbath, that His disciples began to make their way picking the heads of grain. ");
INSERT INTO engemtv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","And the Pharisees said to Him, “Look, why do they do what is not lawful on the Sabbath?” ");
INSERT INTO engemtv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","But He said to them, “Have you never read what David did when he was in need, and became hungry, he and those with him? ");
INSERT INTO engemtv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","How he entered into the house of God at the time Abiathar was high priest, and ate the showbread, which is not lawful to eat, except for the priests, and also gave to those who were with him?” ");
INSERT INTO engemtv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","And He said to them, “The Sabbath was made for man, and not man for the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","So then the Son of Man is Lord, even of the Sabbath.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","And He entered again into the synagogue. And a man was there who had a withered hand. ");
INSERT INTO engemtv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","And they were observing Him, to see if He would heal him on the Sabbath, so that they might accuse Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","And He said to the one who had the withered hand, “Step forward.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Then He said to them, “Is it lawful on the Sabbath to do good or to do evil, to save life or to kill?” But they kept silent. ");
INSERT INTO engemtv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","And looking around at them with anger, being grieved at the hardness of their hearts, He said to the man, “Stretch out your hand.” And he stretched it out, and his hand was restored as whole as the other. ");
INSERT INTO engemtv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Then the Pharisees went out with the Herodians and immediately conspired against Him, how they might destroy Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","But Jesus withdrew with His disciples to the sea. And a large multitude from Galilee followed Him, and from Judea ");
INSERT INTO engemtv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","and from Jerusalem and Idumea and beyond the Jordan, and those around Tyre and Sidon, a large multitude, when they heard everything He was doing, came to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","So He told His disciples that a small boat should be kept ready for Him because of the crowd, lest they should crush Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","For He had healed many, so that all who had afflictions were crowding upon Him, so that they might touch Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","And the unclean spirits, whenever they saw Him, fell down before Him and would cry out, saying, “You are the Son of God.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","And He strictly charged them that they should not make Him known. ");
INSERT INTO engemtv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","And He went up on the mountain and summoned those whom He wanted, and they came to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","And He appointed twelve, so that they might be with Him, and so that He might send them out to preach, ");
INSERT INTO engemtv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","and to have authority to heal diseases and to cast out demons. ");
INSERT INTO engemtv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","And He gave Simon the name Peter, ");
INSERT INTO engemtv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James the son of Zebedee and John the brother of James, He gave them the names Boanerges, which is, “Sons of Thunder”; ");
INSERT INTO engemtv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James the son of Alphaeus, Thaddaeus, Simon the Cananite; ");
INSERT INTO engemtv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","and Judas Iscariot, who also betrayed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","And they came into a house. Then again a crowd assembled, so that they were not even able to eat food. ");
INSERT INTO engemtv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","But when His relatives heard, they came out to seize Him, for they were saying, “He has lost His mind.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","And the scribes who were from Jerusalem came down and were saying, “He has Beelzebul,” and, “By the ruler of the demons He casts out demons.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","And having summoned them, he began to say to them in parables: “How can Satan cast out Satan? ");
INSERT INTO engemtv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","And if a kingdom is divided against itself, that kingdom cannot stand. ");
INSERT INTO engemtv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","And if a household is divided against itself, that household cannot stand. ");
INSERT INTO engemtv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","And if Satan has risen up against himself and has become divided, he cannot stand, but is finished. ");
INSERT INTO engemtv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","No one can enter a strong man's house and plunder his possessions, unless he first binds the strong man, and then he may plunder his house. ");
INSERT INTO engemtv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Assuredly I say to you, all sins will be forgiven the sons of men, also blasphemies, as many as they may blaspheme; ");
INSERT INTO engemtv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","but whoever blasphemes against the Holy Spirit never has forgiveness, but is in danger of eternal damnation”— ");
INSERT INTO engemtv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","because they were saying, “He has an unclean spirit.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Then His brothers and His mother came, and as they stood outside they sent to Him, calling for Him. ");
INSERT INTO engemtv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","And a crowd was sitting around Him; and they said to Him, “Look, Your mother and Your brothers and Your sisters are seeking You outside.” ");
INSERT INTO engemtv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","But He answered them, saying, “Who is My mother, or My brothers?” ");
INSERT INTO engemtv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","And when He had looked around in a circle at those sitting around Him, He said, “Here are My mother and My brothers! ");
INSERT INTO engemtv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","For whoever does the will of God is My brother and My sister and mother.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","And again He began to teach beside the sea. And a large crowd was gathered to Him, so that He got aboard into the boat, and sat on the sea; and all the crowd was upon the land by the sea. ");
INSERT INTO engemtv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","And He was teaching them many things by parables, and said to them in His teaching: ");
INSERT INTO engemtv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Listen! Behold, a sower went out to sow. ");
INSERT INTO engemtv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","And it happened, as he sowed, that some seed fell alongside the road; and the birds came and devoured it. ");
INSERT INTO engemtv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","And some fell on stony ground, where it did not have much earth; and immediately it sprang up because it had no depth of earth. ");
INSERT INTO engemtv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","But when the sun rose it was scorched, and because it had no root, it withered away. ");
INSERT INTO engemtv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","And some seed fell among thorns; and the thorns came up and choked it, and it yielded no fruit. ");
INSERT INTO engemtv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","But other seed fell on good ground, and it was yielding fruit coming up and growing, and it was producing—some thirtyfold, some sixty, and some a hundred.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","And He said, “He that has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","But when He was by himself, those around Him together with the twelve asked Him about the parable. ");
INSERT INTO engemtv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","And He said to them, “Unto you it has been given to know the mystery of the kingdom of God; but to those who are outside, all things are spoken in parables, ");
INSERT INTO engemtv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","so that ‘Seeing they may see and not perceive, and hearing they may hear and not understand; Lest they should turn, and their sins be forgiven them.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","And He said to them, “Do you not know this parable? How then will you know all the parables? ");
INSERT INTO engemtv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","The sower sows the word. ");
INSERT INTO engemtv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","And these are the ones beside the road where the word is sown, and whenever they hear, immediately Satan comes and takes away the word which was sown in their hearts. ");
INSERT INTO engemtv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","And these are the ones sown on stony ground; which, whenever they hear the word, immediately they receive it with joy; ");
INSERT INTO engemtv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","and they have no root in themselves, but are short-lived. Afterward, when trials or persecution arise because of the word, immediately they fall away. ");
INSERT INTO engemtv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","And these are the ones sown among thorns; they are those who hear the word, ");
INSERT INTO engemtv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","and the cares of this world, and the deceitfulness of riches, and the desires for other things enter in and choke the word, and it becomes unfruitful. ");
INSERT INTO engemtv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","And these are the ones sown on good ground, such as who hear the word and welcome it, and bear fruit: some thirtyfold, some sixty, and some a hundred.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","And He said to them, “A lamp is not brought so that it may be put under a measuring basket or under a bed, is it? Is it not brought so that it may be put on a lampstand? ");
INSERT INTO engemtv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","For there is nothing hidden which shall not be made manifest, nor was it hidden but that it might come to light. ");
INSERT INTO engemtv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","If anyone has ears to hear, let him hear.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Then He said to them, “Watch what you hear. By what measure you measure, it will be measured out to you; and more will be added to you who hear. ");
INSERT INTO engemtv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","For whoever has, more will be given to him; and he who does not have, even what he has will be taken away from him.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","And He said, “Thus is the kingdom of God as if a man should cast seed on the ground, ");
INSERT INTO engemtv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","and should sleep by night and rise by day, and the seed should sprout and should grow, he himself does not know how. ");
INSERT INTO engemtv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","For the earth produces crops by itself: first a shoot, then a head of grain, then full wheat in the head of grain. ");
INSERT INTO engemtv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","But whenever the crop permits, immediately he sends forth the sickle, because the harvest has come.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Then He said, “To what shall we compare the kingdom of God? Or by what sort of parable shall we illustrate it? ");
INSERT INTO engemtv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","It is like a mustard seed, which whenever it is sown on the ground, is smaller than all the seeds on the earth; ");
INSERT INTO engemtv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","but whenever it is sown, it grows up and becomes greater than all the garden vegetables, and produces great branches, so that the birds of heaven are able to nest under its shade.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","And by many such parables He would speak the word to them, just as they were able to hear it. ");
INSERT INTO engemtv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","And apart from a parable He did not speak to them, however, privately to His disciples, he would explain all things. ");
INSERT INTO engemtv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","On the same day, when evening had come, He said to them, “Let us go across to the other side.” ");
INSERT INTO engemtv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","And leaving the crowd, they took Him along as He was in the boat. And other little boats were also with Him. ");
INSERT INTO engemtv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","And there was a severe windstorm, and the waves dashed up into the boat, so that it was already filling up. ");
INSERT INTO engemtv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","But He was in the stern, sleeping upon the cushion. And they woke Him up and said to Him, “Teacher! Does it not matter to You that we are perishing?” ");
INSERT INTO engemtv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","And having awakened He rebuked the wind, and He said to the sea, “Peace, be still.” And the wind abated and there was a great calm. ");
INSERT INTO engemtv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","But He said to them, “Why are you so fearful? How is it that you do not have faith?” ");
INSERT INTO engemtv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","And they feared exceedingly, and were saying to one another, “Who then is this, that even the wind and the sea obey Him!” ");
INSERT INTO engemtv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Then they came to the other side of the sea, to the region of the Gadarenes. ");
INSERT INTO engemtv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","And when He got out of the boat, immediately there met Him from the tombs a man with an unclean spirit, ");
INSERT INTO engemtv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","who had his dwelling among the tombs. And no one could bind him, not even with chains, ");
INSERT INTO engemtv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","because he often had been bound with shackles and chains, and the chains had been torn apart by him, and the shackles had been broken, and no one was able to subdue him. ");
INSERT INTO engemtv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","And always, night and day, he was in the mountains and in the tombs, crying out and bruising himself with stones. ");
INSERT INTO engemtv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","But seeing Jesus from a distance, he ran and worshiped Him, ");
INSERT INTO engemtv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","and crying out with a great voice he said, “What have I to do with You, Jesus, Son of the Most High God? I adjure You by God, do not torment me!” ");
INSERT INTO engemtv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","For He was saying to him, “Come out from the man, unclean spirit!” ");
INSERT INTO engemtv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","And He was asking him, “What is your name?” And he answered, saying, “My name is Legion; for we are many.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","And he was imploring Him many times that He would not send them out of the region. ");
INSERT INTO engemtv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Now there was a large herd of swine feeding there near the mountain. ");
INSERT INTO engemtv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","So all the demons implored Him, saying, “Send us into the swine, that we may enter them.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","And immediately Jesus gave them permission. And when the unclean spirits came out, they entered into the swine, and the herd rushed down the steep bank into the sea, (there were about two thousand) and drowned in the sea. ");
INSERT INTO engemtv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","But those feeding the swine fled, and they reported it in the city and in the country. And they came out to see what it was that had happened. ");
INSERT INTO engemtv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Then they came to Jesus, and observed him who had been demon-possessed and had the legion, sitting and having been clothed and being of sound mind, and they were afraid. ");
INSERT INTO engemtv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","And those who saw it related to them how it happened to him who had been demon-possessed, and about the swine. ");
INSERT INTO engemtv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Then they began to implore Him to go away from their region. ");
INSERT INTO engemtv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","And when He got into the boat, he who had been demon-possessed implored Him that he might be with Him. ");
INSERT INTO engemtv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","But Jesus did not permit him, but said to him, “Go home to your own family, and report to them all the things that the Lord has done for you, and how He had compassion on you.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","And he departed and began to proclaim in Decapolis all the things Jesus did for him; and all were marveling. ");
INSERT INTO engemtv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Now when Jesus had crossed over again in the boat to the other side, a large crowd was gathered to Him; and He was beside the sea. ");
INSERT INTO engemtv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","And behold, there came one of the rulers of the synagogue, named Jairus. And seeing Him, he fell at His feet, ");
INSERT INTO engemtv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","and was imploring Him many times, saying, “My little daughter is near death, please come and lay Your hands on her, so that she may be healed, and live.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","And He went away with him. And a large crowd was following Him, and they were pressing against Him. ");
INSERT INTO engemtv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Now a certain woman, suffering from a flow of blood for twelve years, ");
INSERT INTO engemtv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","and who had suffered many things under many physicians, and who had spent everything at her disposal, and was no better, but rather having become worse, ");
INSERT INTO engemtv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","when she heard about Jesus, she came from behind Him in the crowd and touched His clothing. ");
INSERT INTO engemtv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","For she was saying, “If only I may touch His clothes, I will be healed.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","And immediately the flow of her blood was dried up, and she knew in her body that she had been healed from her affliction. ");
INSERT INTO engemtv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","And Jesus, immediately knowing in Himself that power had gone out of Him, He turned in the crowd and said, “Who touched My clothes?” ");
INSERT INTO engemtv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","But His disciples said to Him, “You see the crowd pressing against You, and You say, ‘Who touched Me?’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","And He was looking around to see her who had done this thing. ");
INSERT INTO engemtv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","But the woman, fearing and trembling, knowing what had happened to her, came and fell down before Him and told Him the whole truth. ");
INSERT INTO engemtv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","And He said to her, “Daughter, your faith has healed you. Go in peace, and be healed of your affliction.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","While He was still speaking, they came from the synagogue leader, saying, “Your daughter has died. Why do you still trouble the Teacher?” ");
INSERT INTO engemtv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","But Jesus, immediately when He heard the word being spoken, said to the synagogue leader, “Do not be afraid; only believe.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","And He did not permit anyone to follow along with Him except for Peter, James, and John the brother of James. ");
INSERT INTO engemtv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","And He went to the house of the synagogue leader, and observed a commotion, and people weeping and wailing, very much. ");
INSERT INTO engemtv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","And when He went in, He said to them, “Why are you making such commotion and weeping? The child is not dead, but she is asleep.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","And they were ridiculing Him. But putting them all out, He took along the father and the mother of the child, and those with Him, and He went in where the child was lying. ");
INSERT INTO engemtv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","And having grasped the hand of the child, He said to her, “Talitha, koumi,” which means, “Little girl, I say to you, arise.” ");
INSERT INTO engemtv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","And immediately the little girl arose and was walking about, for she was twelve years old. And they were overcome with great amazement. ");
INSERT INTO engemtv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","But He ordered them strictly that no one should know this, and said that something should be given her to eat. ");
INSERT INTO engemtv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Then He went out from there and came to His hometown, and His disciples followed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","And when the Sabbath had come, He began to teach in the synagogue. And many when they heard were astonished, saying, “Where did this Man get these things? And what wisdom is this which is given to Him, and such miracles are coming about by His hands? ");
INSERT INTO engemtv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Is this not the carpenter, the son of Mary, and brother of James, Joses, Judas, and Simon? And are not His sisters here with us?” And they were offended at Him. ");
INSERT INTO engemtv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","But Jesus said to them, “A prophet is not without honor except in his own hometown, and among his relatives, and in his own house.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","And He could do no miracle there, except that He laid His hands on a few sick people and healed them. ");
INSERT INTO engemtv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","And He marveled because of their unbelief. Then He went about the villages in a circuit, teaching. ");
INSERT INTO engemtv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","And He called the twelve to Himself, and began to send them out two by two, and gave them power over unclean spirits. ");
INSERT INTO engemtv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","He commanded them that they should take nothing for the journey except a staff, only—no knapsack, no bread, nor a copper coin for their money belts— ");
INSERT INTO engemtv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","but to wear sandals, and not to put on two tunics. ");
INSERT INTO engemtv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","And He said to them, “Wherever you may enter into a house, stay there until you go out from there. ");
INSERT INTO engemtv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","And as many as do not receive you nor hear you, as you leave from there, shake off the dust underneath your feet as a testimony against them. Assuredly I say to you, it will be more tolerable for Sodom or for Gomorrah in the Day of Judgment than for that city!” ");
INSERT INTO engemtv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","And when they went out, they were preaching that people should repent. ");
INSERT INTO engemtv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","And they were casting out many demons, and they were anointing with oil many who were sick, and were healing them. ");
INSERT INTO engemtv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","And King Herod heard, for His name became well known. And he said, “John the Baptizer has been raised from the dead, and for this reason the miracles are at work in him.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Others said, “He is Elijah.” But others said, “He is a prophet, like one of the prophets.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","But when he heard, Herod said, “It is John, whom I beheaded; he has been raised from the dead!” ");
INSERT INTO engemtv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","For Herod himself had sent and laid hold of John, and bound him in prison for the sake of Herodias, his brother Philip's wife; because he had married her. ");
INSERT INTO engemtv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","For John would say to Herod, “It is not lawful for you to have your brother's wife.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Therefore Herodias held a grudge against him and was desiring to kill him, but she was not able; ");
INSERT INTO engemtv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","for Herod was afraid of John, knowing that he was a just and holy man, and he was protecting him. And when he heard him, he did many things, and he would hear him gladly. ");
INSERT INTO engemtv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","And when an opportune day arrived, when Herod for his birthday festivities was putting on a supper for his nobles, the high officers, and the chief men of Galilee, ");
INSERT INTO engemtv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","and when Herodias' daughter herself came in and danced, and pleased Herod and his dinner guests, the king said to the girl, “Ask me whatever you may want, and I will give it to you.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","He also swore to her, “Whatever you may ask me, I will give you, up to half of my kingdom.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","And when she had gone out, she said to her mother, “What shall I ask?” And she said, “The head of John the Baptist!” ");
INSERT INTO engemtv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Immediately she came in with haste to the king and she requested, saying, “I want you to give me at once the head of John the Baptist on a platter.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","And the king became exceedingly sorry; yet, because of his oaths and of those who reclined with him, he did not want to refuse her. ");
INSERT INTO engemtv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","And immediately the king, having sent an executioner, commanded his head to be brought. And having departed, he beheaded him in the prison, ");
INSERT INTO engemtv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","and brought his head on a platter, and gave it to the girl; and the girl gave it to her mother. ");
INSERT INTO engemtv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","And when his disciples heard, they came and took away his body and placed it in a tomb. ");
INSERT INTO engemtv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Then the apostles gathered to Jesus and they reported to Him all things, both everything they had done and everything they had taught. ");
INSERT INTO engemtv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","And He said to them, “Come, you yourselves privately, to a deserted place and rest a little.” For there were many coming and going, and they were not even finding opportunity to eat. ");
INSERT INTO engemtv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","And they went away to a deserted place in the boat privately. ");
INSERT INTO engemtv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","But the multitudes saw them going, and many recognized Him, and ran together there on foot from all the cities, and preceded them, and they came together to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","And when He came out, Jesus saw a large crowd, and He had compassion on them, because they were like sheep not having a shepherd. So He began to teach them many things. ");
INSERT INTO engemtv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","And when it grew late, His disciples came to Him and said, “The place is deserted, and already the hour is late. ");
INSERT INTO engemtv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dismiss them, so that they may go into the surrounding farms and villages and may buy themselves food; for they have nothing to eat.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","But answering, He said to them, “You give them something to eat.” And they said to Him, “Shall we go and buy two hundred denarii worth of bread and give them something to eat?” ");
INSERT INTO engemtv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","But He said to them, “How many loaves do you have? Go and see.” And when they found out they said, “Five, and two fish.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Then He gave orders for them all to recline in groups on the green grass. ");
INSERT INTO engemtv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","And they reclined in parties of hundreds and of fifties. ");
INSERT INTO engemtv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","And taking the five loaves and the two fish, looking up to heaven, He blessed and broke the loaves, and was giving them to His disciples, so that they might set them before them; and the two fish He divided to all. ");
INSERT INTO engemtv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","So they all ate and were filled. ");
INSERT INTO engemtv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","And they took up twelve baskets full of fragments and from the fish. ");
INSERT INTO engemtv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Now those who had eaten the loaves were five thousand men. ");
INSERT INTO engemtv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","And immediately He compelled His disciples to step into the boat and to go on ahead to the other side, to Bethsaida, until He could dismiss the crowd. ");
INSERT INTO engemtv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","And having taken leave of them, He departed to the mountain to pray. ");
INSERT INTO engemtv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Now when it was evening, the boat was in the middle of the sea; and He was alone on the land. ");
INSERT INTO engemtv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Then He saw them straining at rowing, for the wind was against them. Now about the fourth watch of the night He came to them walking on the sea, and He intended to pass by them. ");
INSERT INTO engemtv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","And seeing Him walking on the sea, they supposed Him to be a spirit, and they cried out; ");
INSERT INTO engemtv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","for they all saw Him and were troubled. But immediately He spoke with them, and said to them, “Have courage! It is I AM; do not be afraid.” ");
INSERT INTO engemtv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Then He went up with them into the boat and the wind ceased. And they were greatly astounded among themselves beyond measure, and were marveling. ");
INSERT INTO engemtv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","For they had not understood concerning the loaves, because their heart was hardened. ");
INSERT INTO engemtv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","And having crossed over, they came to the land of Gennesaret and anchored there. ");
INSERT INTO engemtv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","And when they came out of the boat, immediately having recognized Him, ");
INSERT INTO engemtv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","running about that whole surrounding region, they began to carry about on beds those who were sick to wherever they would hear that He was. ");
INSERT INTO engemtv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","And wherever He would enter into villages, or towns, or the country, they laid the sick in the marketplaces, and they would beg Him at least that they might touch the hem of His garment. And as many as touched Him were healed. ");
INSERT INTO engemtv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Then the Pharisees and some of the scribes gathered together to Him, having come from Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Now when they saw some of His disciples eat bread with ceremonially unclean, that is, with unwashed hands, they found fault. ");
INSERT INTO engemtv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","For the Pharisees and all the Jews do not eat unless they wash their hands with their fist, holding the tradition of the elders. ");
INSERT INTO engemtv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","And coming from the marketplace, unless they bathe, they do not eat. And there are many other things which they have received by tradition, like the washing of cups and pitchers, copper vessels and couches. ");
INSERT INTO engemtv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Then the Pharisees and scribes asked Him, “Why do Your disciples not walk according to the tradition of the elders, but they eat bread with unwashed hands?” ");
INSERT INTO engemtv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","And answering He said to them, “Well did Isaiah prophesy about you hypocrites, as it is written: ‘This people honors Me with their lips, but their heart is far from Me. ");
INSERT INTO engemtv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","And in vain they worship Me, teaching as doctrines the commandments of men.’ ");
INSERT INTO engemtv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","For having left the commandment of God, you hold to the tradition of men—the washing of pitchers and cups, and many other similar things you do.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","And He said to them, “Well do you set aside the commandment of God, so that you may keep your tradition. ");
INSERT INTO engemtv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","For Moses said, ‘Honor your father and your mother’; and, ‘Whoever speaks evil of father or mother, let him surely die.’ ");
INSERT INTO engemtv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","But you say, ‘If a man says to his father or to his mother, “Whatever you might be profited by me is Corban” ’—(that is, a gift), ");
INSERT INTO engemtv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","then you no longer allow him to do anything for his father or his mother, ");
INSERT INTO engemtv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","thus nullifying the word of God by your tradition which you have handed down. And many similar things you do.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","And having summoned all the crowd, He said to them, “Hear Me, all of you and understand: ");
INSERT INTO engemtv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","There is nothing from outside a man, that entering into him, can defile him; but the things which come out of him, those are the things that defile a man. ");
INSERT INTO engemtv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","If anyone has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","When He had entered a house away from the crowd, His disciples were asking Him about the parable. ");
INSERT INTO engemtv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","So He said to them, “Are you also without understanding? Do you not understand that everything entering a man from outside cannot defile him, ");
INSERT INTO engemtv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","because it does not enter into his heart but into his stomach, and passes into the latrine, thus purifying all foods?” ");
INSERT INTO engemtv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","And He said, “That which comes out of a man, that defiles a man. ");
INSERT INTO engemtv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","For from within, out of the heart of men, come forth evil thoughts, adulteries, fornications, murders, ");
INSERT INTO engemtv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","thefts, covetousness, wickedness, deceit, lewdness, an evil eye, blasphemy, arrogance, foolishness. ");
INSERT INTO engemtv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","All these evil things come from within and defile a man.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","From there He arose and He went away into the region of Tyre and Sidon. And having entered into a house, He wanted no one to know it, but He was not able to escape notice. ");
INSERT INTO engemtv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","For a woman whose young daughter had an unclean spirit heard about Him, and she came and fell at His feet. ");
INSERT INTO engemtv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Now the woman was a Greek, a Syro-Phoenician by race, and she was asking Him to cast the demon out from her daughter. ");
INSERT INTO engemtv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","But Jesus said to her, “Let the children be filled first, for it is not good to take the children's bread and throw it to the little dogs.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","And she answered and said to Him, “Yes, Lord, yet even the little dogs underneath the table eat from the crumbs of the children.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Then He said to her, “Because of this saying, go; the demon has gone out of your daughter.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","And going away to her house, she found the demon having gone out, and her daughter having been placed on the bed. ");
INSERT INTO engemtv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Again, coming out from the region of Tyre and Sidon, He went to the Sea of Galilee, in the midst of the region of Decapolis. ");
INSERT INTO engemtv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Then they brought to Him a deaf man impeded in speech, and they begged Him that He would lay His hand upon him. ");
INSERT INTO engemtv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","And when he had taken him aside from the crowd privately, He put His fingers in his ears, and having spit, He touched his tongue. ");
INSERT INTO engemtv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Then looking up into heaven, He sighed, and said to him, “Ephphatha,” that is, “Be opened.” ");
INSERT INTO engemtv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Immediately his ears were opened, and the bond of his tongue was loosed, and he was speaking correctly. ");
INSERT INTO engemtv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","And He ordered them that they should tell no one; but the more He ordered them, the more exceedingly they would proclaim it. ");
INSERT INTO engemtv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","And they were astonished beyond measure, saying, “He has done all things well. He makes both the deaf to hear and the mute to speak.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","In those days, when a great crowd had gathered, and not having anything to eat, Jesus, having summoned His disciples, said to them, ");
INSERT INTO engemtv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“I have compassion on the crowd, because they have been remaining with Me three days and have nothing to eat. ");
INSERT INTO engemtv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","And if I dismiss them hungry to their own houses, they will faint on the way; for some of them have come from a great distance.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Then His disciples answered Him, “From where will anyone be able to satisfy these people with bread here in this deserted place?” ");
INSERT INTO engemtv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","He asked them, “How many loaves do you have?” And they said, “Seven.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","So He commanded the crowd to recline on the ground. And He took the seven loaves, and having given thanks, He broke them and was giving them to His disciples, so that they might set them before the people; and they set them before the crowd. ");
INSERT INTO engemtv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","And they had a few small fish; and having blessed them, He said to set them before the people. ");
INSERT INTO engemtv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","So they ate and were filled, and they took up an abundance of fragments, seven hampers full. ");
INSERT INTO engemtv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Now those having eaten were about four thousand. And He dismissed them. ");
INSERT INTO engemtv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","And immediately stepping into the boat with His disciples, He came to the region of Dalmanutha. ");
INSERT INTO engemtv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Then the Pharisees came out and began to question Him, seeking from Him a sign from heaven, testing Him. ");
INSERT INTO engemtv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","And sighing deeply in His spirit, He said, “Why does this generation seek a sign? Assuredly I say to you, no sign shall be given to this generation.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","And having dismissed them, and stepping into the boat again, He went away to the other side. ");
INSERT INTO engemtv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","And they forgot to take bread, and except for one loaf, they did not have any with themselves in the boat. ");
INSERT INTO engemtv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Then He charged them, saying, “Look out, beware of the leaven of the Pharisees and the leaven of Herod.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","And they were reasoning among themselves, saying, “Because we have no bread.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","But Jesus, knowing about it, said to them, “Why are you reasoning because you have no bread? Do you not yet perceive or understand? Is your heart still hardened? ");
INSERT INTO engemtv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Having eyes, do you not see? And having ears, do you not hear? And do you not remember? ");
INSERT INTO engemtv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","When I broke the five loaves for the five thousand, how many baskets full of fragments did you take up?” They said to Him, “Twelve.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“And when I broke the seven for the four thousand, how many hampers full of fragments did you take up?” And they said, “Seven.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","So He said to them, “How is it you do not understand?” ");
INSERT INTO engemtv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Then He came to Bethsaida; and they brought a blind man to Him, and implored Him to touch him. ");
INSERT INTO engemtv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","And having taken the hand of the blind man, He led him outside the village, and having spit on his eyes, and having laid His hands on him, He asked him if he saw anything. ");
INSERT INTO engemtv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","And when he looked up he said, “I see men like trees, walking.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Then He put His hands on his eyes again and made him to look up. And he was restored and saw everyone clearly again. ");
INSERT INTO engemtv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Then He sent him away to his house, saying, “Neither go into the village, nor tell anyone in the village.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Now Jesus and His disciples went out to the villages of Caesarea Philippi; and on the road He was questioning His disciples, saying to them, “Who do men pronounce Me to be?” ");
INSERT INTO engemtv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","So they answered, “John the Baptist; and others say, Elijah; but others, one of the prophets.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","He said to them, “But who do you pronounce Me to be?” Peter answered and said to Him, “You are the Christ.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Then He warned them that they should tell no one about Him. ");
INSERT INTO engemtv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","And He began to teach them that it was necessary for the Son of Man to suffer many things, and to be rejected by the elders and the chief priests and the scribes, and to be killed, and after three days to rise. ");
INSERT INTO engemtv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","He was speaking this word with boldness. And Peter, taking Him aside, began to rebuke Him. ");
INSERT INTO engemtv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","But when He had turned and saw His disciples, He rebuked Peter, saying, “Get behind Me, Satan! For you are not mindful of the things of God, but the things of men.” ");
INSERT INTO engemtv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","And having summoned the crowd together with His disciples, He said to them, “Whoever is willing to come after Me, let him deny himself, and take up his cross, and follow Me. ");
INSERT INTO engemtv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","For whoever desires to save his life will lose it, but whoever loses his life for My sake and the gospel's, will save it. ");
INSERT INTO engemtv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","For what shall it profit a man if he gains the whole world, and forfeits his soul? ");
INSERT INTO engemtv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Or what shall a man give in exchange for his soul? ");
INSERT INTO engemtv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","For whosoever is ashamed of Me and My words among this adulterous and sinful generation, the Son of Man will also be ashamed of him, whenever He comes in the glory of His Father with the holy angels.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","And He said to them, “Assuredly, I say to you that there are some standing here who will by no means taste death till they see the kingdom of God actually come in power.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Now after six days Jesus took Peter, James, and John, and led them up into a high mountain alone by themselves. And He was transfigured before them, ");
INSERT INTO engemtv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","and His clothes became shining, exceedingly white, like snow, such as no launderer on earth is able to whiten. ");
INSERT INTO engemtv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","And Elijah appeared to them together with Moses, and they were talking with Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Then Peter answered and said to Jesus, “Rabbi, it is good for us to be here; and let us make three tents: one for You, one for Moses, and one for Elijah”— ");
INSERT INTO engemtv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","for he did not know what he should say, for they were terrified. ");
INSERT INTO engemtv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","And a cloud appeared overshadowing them, and a voice came out of the cloud, saying, “This is My beloved Son. Listen to Him!” ");
INSERT INTO engemtv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","And suddenly, looking around, they no longer saw anyone, but only Jesus with themselves. ");
INSERT INTO engemtv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","And as they came down from the mountain, He commanded them that they should relate to no one the things they had seen, till the Son of Man should rise from the dead. ");
INSERT INTO engemtv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","And this word they kept to themselves, questioning what it meant to rise from the dead. ");
INSERT INTO engemtv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","And they asked Him, saying, “Why do the scribes say that Elijah must come first?” ");
INSERT INTO engemtv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","And answering He said to them, “Indeed, Elijah is coming first and restores all things. And how is it written concerning the Son of Man, that He must suffer many things and be treated with contempt? ");
INSERT INTO engemtv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","But I say to you that indeed Elijah has come, and they did to him whatever they wished, just as it is written concerning him.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","And when He came to the disciples, He saw a large crowd around them, and scribes disputing with them. ");
INSERT INTO engemtv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Immediately, when they saw Him, all the people were greatly amazed, and running to Him, they greeted Him. ");
INSERT INTO engemtv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","And He asked the scribes, “What are you disputing about with them?” ");
INSERT INTO engemtv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Then one of the crowd answered and said, “Teacher, I brought my son to You, because he has a mute spirit. ");
INSERT INTO engemtv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","And wherever it seizes him, it throws him down, and he foams at the mouth, and gnashes his teeth, and he becomes rigid. So I spoke to Your disciples, that they might cast it out, but they were not able.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","He answered him and said, “O unbelieving generation, how long shall I be with you? How long shall I bear with you? Bring him to Me.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Then they brought the boy to Him. And when he saw Him, immediately the spirit convulsed him, and having fallen on the ground he was rolling about, foaming at the mouth. ");
INSERT INTO engemtv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","So He asked his father, “How long has this been happening to him?” And he said, “From childhood. ");
INSERT INTO engemtv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","And often it threw him both into the fire and into the waters so that it may destroy him. But if You are able to do anything, help us and have compassion on us.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus said to him, “If you are able to believe: all things are possible to him that believes.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","And immediately crying out, the father of the child said with tears, “I believe, Lord; help my unbelief!” ");
INSERT INTO engemtv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","When Jesus saw that a crowd was running together, He rebuked the unclean spirit, saying to him, “Mute and deaf spirit, I command you, come out of him and enter him no more!” ");
INSERT INTO engemtv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Then having cried out and having convulsed him greatly, it came out. And he became as one dead, so that many were saying, “He is dead.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","But Jesus, having grasped him by the hand, lifted him up, and he arose. ");
INSERT INTO engemtv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","And after He entered into a house, His disciples asked Him privately, “Why were we not able to cast it out?” ");
INSERT INTO engemtv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","So He said to them, “This kind can come out by nothing but prayer and fasting.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","And having gone out from there they were passing through Galilee, and He did not wish that anyone should know. ");
INSERT INTO engemtv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","For He was teaching His disciples and said to them, “The Son of Man is being betrayed into the hands of men, and they will kill Him. And after He is killed, He will rise on the third day.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","But they did not understand this saying, and were afraid to ask Him. ");
INSERT INTO engemtv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Then He came to Capernaum. And being in the house He asked them, “What were you disputing about with one another on the road?” ");
INSERT INTO engemtv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","But they were silent, for on the road they had discussed with one another who was the greatest. ");
INSERT INTO engemtv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","And having sat down He called the twelve, and said to them, “If anyone desires to be first, he shall be last of all and servant of all.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","And taking a child, He stood him in their midst. And taking him in His arms, He said to them, ");
INSERT INTO engemtv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Whoever receives one of these little children in My name receives Me; and whoever receives Me, receives not Me, but Him who sent Me.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Now John answered Him, saying, “Teacher, we saw someone who does not follow with us casting out demons in Your name, and we forbade him because he does not follow with us.” ");
INSERT INTO engemtv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","But Jesus said, “Do not forbid him, for there is no one who will perform a miracle in My name that will be able to soon speak evil of Me. ");
INSERT INTO engemtv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","For he who is not against you is for you. ");
INSERT INTO engemtv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","For whoever gives you a cup of water to drink in My name, because you are Christ's, assuredly, I say to you, he will by no means lose his reward. ");
INSERT INTO engemtv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“But whoever causes one of these little ones who believe in Me to stumble, it would be better for him if a millstone were around his neck, and he be cast into the sea. ");
INSERT INTO engemtv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","If your hand causes you to stumble, cut it off. It would be better for you to enter into life maimed, than to enter having two hands, to go into hell, into the fire that shall never be quenched— ");
INSERT INTO engemtv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","where ‘Their worm does not die, and the fire is not quenched.’ ");
INSERT INTO engemtv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","And if your foot causes you to stumble, cut it off. It would be better for you to enter into life lame, than having two feet to be cast into hell, into the fire that shall never be quenched— ");
INSERT INTO engemtv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","where ‘Their worm does not die, and the fire is not quenched.’ ");
INSERT INTO engemtv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","And if your eye causes you to stumble, cast it out. It would be better for you to enter into the kingdom of God with one eye, than having two eyes to be cast into the fiery hell, ");
INSERT INTO engemtv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","where ‘Their worm does not die, and the fire is not quenched.’ ");
INSERT INTO engemtv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“For everyone will be salted with fire, and every sacrifice will be seasoned with salt. ");
INSERT INTO engemtv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Salt is good, but if the salt becomes unsalty, by what will you season it? Have salt in yourselves, and be at peace with one another.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Then He arose from there and came to the region of Judea by the other side of the Jordan. And again crowds came together to Him, and as He was accustomed, He was teaching them. ");
INSERT INTO engemtv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","And some Pharisees approached and asked Him, “Is it lawful for a husband to put away his wife?” testing Him. ");
INSERT INTO engemtv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","But answering He said to them, “What did Moses command you?” ");
INSERT INTO engemtv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","They said, “Moses permitted a man to write a certificate of divorce, and to put her away.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","And Jesus answered and said to them, “In view of your hardheartedness he wrote this commandment for you. ");
INSERT INTO engemtv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","But from the beginning of the creation, God ‘made them male and female.’ ");
INSERT INTO engemtv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘For this reason a man shall leave his father and mother and be joined to his wife,’ ");
INSERT INTO engemtv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","‘and the two shall become one flesh’; so then they are no longer two, but one flesh. ");
INSERT INTO engemtv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Therefore what God has united together, let not man separate.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","In the house His disciples also asked Him again concerning the same matter. ");
INSERT INTO engemtv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","So He said to them, “Whoever should put away his wife and marry another commits adultery against her. ");
INSERT INTO engemtv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","And if a wife should put away her husband and be married to another, she commits adultery.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","And they were bringing to Him little children, that He might touch them; but the disciples were rebuking those who brought them. ");
INSERT INTO engemtv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","But when Jesus saw this, He was indignant and said to them, “Allow the little children to come to Me, do not hinder them; for of such is the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Assuredly, I say to you, whoever does not receive the kingdom of God as a little child will by no means enter it.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","And taking them in His arms, laying His hands on them, He blessed them. ");
INSERT INTO engemtv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Now as He was going out into the road, one came running up, and having knelt before Him, he asked Him, “Good Teacher, what shall I do that I may inherit eternal life?” ");
INSERT INTO engemtv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","So Jesus said to him, “Why do you call Me good? No one is good except One, God. ");
INSERT INTO engemtv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","You know the commandments: ‘Do not commit adultery,’ ‘Do not commit murder,’ ‘Do not steal,’ ‘Do not bear false witness,’ ‘Do not defraud,’ ‘Honor your father and your mother.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","And he answered and said to Him, “Teacher, all these I have observed from my youth.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Then Jesus, looking at him, loved him, and said to him, “One thing you lack: Go, sell all that you have, and give to the poor, and you will have treasure in heaven; and come, take up the cross, and follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","But having become gloomy at this saying, he went away grieving, for he had many possessions. ");
INSERT INTO engemtv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","And looking around, Jesus said to His disciples, “How difficult it is for those having riches to enter the kingdom of God!” ");
INSERT INTO engemtv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","And the disciples were astonished at His words. But Jesus, answering again, said to them, “Children, how difficult it is for those who trust in riches to enter into the kingdom of God! ");
INSERT INTO engemtv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","It is easier for a camel to pass through the eye of a needle than for a rich person to enter into the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","And they were exceedingly astonished, saying among themselves, “Who then is able to be saved?” ");
INSERT INTO engemtv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","But looking at them Jesus said, “With men it is impossible, but not with God; for all things are possible with God.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Then Peter began to say to Him, “See, we have left all things and have followed You.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","So Jesus answered and said, “Assuredly I say to you, there is no one who has left house or brothers or sisters or father or mother or wife or children or fields, for My sake and for the gospel's, ");
INSERT INTO engemtv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","who shall not receive a hundredfold now in this time—houses and brothers and sisters and mothers and children and fields, along with persecutions—and in the age to come, eternal life. ");
INSERT INTO engemtv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","But many who are first shall be last, and the last first.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Now they were on the road, going up to Jerusalem, and Jesus was going ahead of them; and they were astonished, and as they were following they were afraid. And taking the twelve aside again, He began to tell them the things which were about to happen to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Behold, we are going up to Jerusalem, and the Son of Man will be delivered up to the chief priests and to the scribes; and they will condemn Him to death and will deliver Him over to the Gentiles; ");
INSERT INTO engemtv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","and they will mock Him, and scourge Him, and spit on Him, and kill Him. And on the third day He will rise again.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Then James and John, the sons of Zebedee, came to Him, saying, “Teacher, we desire that You to do for us whatever we may ask.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","And He said to them, “What do you desire Me to do for you?” ");
INSERT INTO engemtv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","They said to Him, “Grant us that we may sit, one on Your right hand and one on Your left, in Your glory.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","But Jesus said to them, “You do not know what you are asking. Are you able to drink the cup which I drink, and to be baptized with the baptism with which I am baptized?” ");
INSERT INTO engemtv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","They said to Him, “We are able.” So Jesus said to them, “You will indeed drink the cup which I drink, and with the baptism with which I am baptized you will be baptized with; ");
INSERT INTO engemtv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","but to sit on My right hand and on My left is not Mine to give, but to those for whom it has been prepared.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","And having heard this, the ten began to be indignant with James and John. ");
INSERT INTO engemtv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","But Jesus, having called them to Himself, said to them, “You know that those being reputed to be ruling the Gentiles lord it over them, and their great ones exercise authority over them. ");
INSERT INTO engemtv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yet it will not be so among you; but whoever desires to become great among you shall be your servant. ");
INSERT INTO engemtv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","And whoever of you desires to be first shall be servant of all. ");
INSERT INTO engemtv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","For even the Son of Man did not come to be served, but to serve, and to give His life a ransom for many.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","And they came to Jericho. And as He was going out from Jericho along with His disciples and a large crowd, Bartimaeus the blind man, the son of Timaeus, was sitting alongside the road begging. ");
INSERT INTO engemtv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","And when he heard that it was Jesus the Nazarene, he began to cry out and say, “Jesus, Son of David, have pity on me!” ");
INSERT INTO engemtv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","And many rebuked him, that he should be silent. But he cried out all the more, “Jesus, Son of David, have pity on me!” ");
INSERT INTO engemtv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","And having stopped, Jesus asked for him to be called. Then they called the blind man, saying to him, “Have courage, rise up; He is calling you.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","And casting away his garment, he rose up and came to Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","So Jesus answered and said to him, “What do you desire that I should do for you?” And the blind man said to Him, “Rabboni, that I may receive sight.” ");
INSERT INTO engemtv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Then Jesus said to him, “Go; your faith has healed you.” And immediately he received sight, and he followed Jesus on the road. ");
INSERT INTO engemtv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","And when they drew near to Jerusalem, to Bethphage and Bethany, towards the Mount of Olives, He sent two of His disciples; ");
INSERT INTO engemtv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","and He said to them, “Go into the village opposite you; and immediately entering into it you will find a colt tied up on which no one has sat. When you have untied him, bring him. ");
INSERT INTO engemtv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","And if anyone says to you, ‘Why are you doing this?’ say, ‘The Lord has need of him,’ and immediately he will send it here.” ");
INSERT INTO engemtv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","And they departed, and found the colt tied up by the door outside in the street, and they untied him. ");
INSERT INTO engemtv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","But some of those standing there said to them, “What are you doing, loosing the colt?” ");
INSERT INTO engemtv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","And they told them just as Jesus had commanded. And they gave them permission. ");
INSERT INTO engemtv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Then they led the colt to Jesus, and placed their clothes on him, and He sat on him. ");
INSERT INTO engemtv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","And many spread their garments on the road, and others were cutting down branches from the trees and were spreading them on the road. ");
INSERT INTO engemtv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","And those going before, and those that were following were crying out, saying: “Hosanna! ‘Blessed is He who comes in the name of the Lord!’ ");
INSERT INTO engemtv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Blessed is the kingdom of our father David that comes in the name of the Lord! Hosanna in the highest!” ");
INSERT INTO engemtv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","And Jesus entered into Jerusalem, and into the temple. And having looked around at all things, the hour already being late, He went out to Bethany with the twelve. ");
INSERT INTO engemtv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Now the next day, after they had come out from Bethany, He was hungry. ");
INSERT INTO engemtv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","And seeing from a distance a fig tree having leaves, He went to see if perhaps He would find something on it. And having come to it, He found nothing but leaves, for it was not the season for figs. ");
INSERT INTO engemtv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","And answering, Jesus said to it, “May no one eat fruit from you ever again.” And His disciples were listening. ");
INSERT INTO engemtv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","And they came to Jerusalem. And when Jesus entered into the temple, He began to throw out those selling and buying in the temple, and He overturned the tables of the moneychangers and the seats of those that sold doves. ");
INSERT INTO engemtv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","And He would not permit anyone to carry a vessel through the temple. ");
INSERT INTO engemtv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","And He was teaching, saying to them, “Is it not written, ‘My house shall be called a house of prayer for all the nations’? But you have made it a ‘den of thieves!’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","And the scribes and chief priests heard it and they sought how they might destroy Him; for they were afraid of Him, because all the people were astonished at His teaching. ");
INSERT INTO engemtv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","And when it became evening, He was going forth outside of the city. ");
INSERT INTO engemtv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Now in the morning while passing by, they saw the fig tree dried up from its roots. ");
INSERT INTO engemtv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","And Peter, remembering, said to Him, “Rabbi, look! The fig tree which You cursed has dried up!” ");
INSERT INTO engemtv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","So Jesus answered and said to them, “Have faith in God. ");
INSERT INTO engemtv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","For assuredly I say to you, whoever says to this mountain, ‘Be taken up and cast into the sea,’ and does not doubt in his heart, but believes that the things which he says are coming to pass, whatever he says shall be his. ");
INSERT INTO engemtv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","For this reason I say to you, all things whatsoever you ask for in prayer, believe that you will receive them, and they will be yours. ");
INSERT INTO engemtv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“And whenever you stand praying, if you have anything against anyone, forgive them, that your Father in heaven may forgive you your trespasses. ");
INSERT INTO engemtv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","But if you do not forgive, neither will your Father who is in heaven forgive your trespasses.” ");
INSERT INTO engemtv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Then they came again to Jerusalem. And as He was walking about in the temple, the chief priests, the scribes, and the elders came to Him. ");
INSERT INTO engemtv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","And they said to Him, “By what authority are You doing these things? And who gave You this authority to do these things?” ");
INSERT INTO engemtv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","But Jesus answered and said to them, “I also will ask you one thing, and you answer Me, and I will tell you by what authority I do these things: ");
INSERT INTO engemtv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","The baptism of John—was it from heaven or from men? Answer Me.” ");
INSERT INTO engemtv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","And they were debating among themselves, saying, “If we say, ‘From heaven,’ He will say, ‘Why then did you not believe him?’ ");
INSERT INTO engemtv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","But should we say, ‘From men’ ”—they feared the people, for all had considered John to have been a prophet indeed. ");
INSERT INTO engemtv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","And answering they said to Jesus, “We do not know.” And Jesus answered and said to them, “Neither do I tell you by what authority I do these things.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Then He began to speak to them in parables: “A man planted a vineyard and set a fence around it, dug a wine vat and built a tower. And he leased it to farmers, and went on a journey. ");
INSERT INTO engemtv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","And at harvest time he sent a servant to the farmers, in order that he might receive his part from the fruit of the vineyard. ");
INSERT INTO engemtv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","And they took him and beat him and sent him away empty-handed. ");
INSERT INTO engemtv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Again he sent them another servant, and that one they wounded in the head with stones, and they sent him away shamefully treated. ");
INSERT INTO engemtv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","And again he sent another, and that one they killed, and so with many others, beating some and killing others. ");
INSERT INTO engemtv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Therefore still having one son, his beloved, he even sent him to them last, saying, ‘Surely they will respect my son.’ ");
INSERT INTO engemtv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","But those farmers said to one another, ‘This is the heir. Come, let us kill him, and the inheritance will be ours.’ ");
INSERT INTO engemtv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","And taking him they killed him, and cast him out of the vineyard. ");
INSERT INTO engemtv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Therefore what will the owner of the vineyard do? He will come and will destroy the farmers, and give the vineyard to others. ");
INSERT INTO engemtv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Have you not even read this Scripture: ‘The stone which the builders rejected has become the chief cornerstone. ");
INSERT INTO engemtv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","This was the Lord's doing, and it is marvelous in our eyes’?” ");
INSERT INTO engemtv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","And they sought to lay hold of Him, but they feared the crowd, for they knew that He had spoken the parable against them. And leaving Him, they went away. ");
INSERT INTO engemtv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Then they sent to Him some of the Pharisees and the Herodians, in order that they might catch Him in His discourse. ");
INSERT INTO engemtv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","And they came and said to Him, “Teacher, we know that You are true, and it does not make a difference to you about anyone; for You do not look on the face of men, but you teach the way of God in truth. Is it lawful to pay taxes to Caesar, or not? ");
INSERT INTO engemtv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Should we give, or should we not give?” But He, knowing their hypocrisy, said to them, “Why do you test Me? Bring Me a denarius, that I may see it.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","So they brought one. And He said to them, “Whose image and inscription is this?” And they said to Him, “Caesar's.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","And Jesus answered and said to them, “Render to Caesar the things that are Caesar's, and to God the things that are God's.” And they marveled at Him. ");
INSERT INTO engemtv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Then some Sadducees came to Him, who say that there is no resurrection, and they asked Him, saying: ");
INSERT INTO engemtv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Teacher, Moses wrote to us that if a man's brother dies and leaves behind a wife and leaves no children, that his brother should take his wife and raise up offspring for his brother. ");
INSERT INTO engemtv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Now there were seven brothers. The first took a wife and he died, and left no offspring. ");
INSERT INTO engemtv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","And the second took her, and died; nor did he leave any offspring. And the third likewise. ");
INSERT INTO engemtv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","So the seven had her and left no offspring. Last of all the woman died also. ");
INSERT INTO engemtv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Therefore, in the resurrection, when they shall arise, whose wife of them will she be? For all seven had her as wife.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus answered and said to them, “Is this not the reason you are mistaken, because you know neither the Scriptures nor the power of God? ");
INSERT INTO engemtv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","For whenever they rise from among the dead, neither do they marry nor are they given in marriage, but they are like angels in heaven. ");
INSERT INTO engemtv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","But concerning the dead, that they rise, have you not read in the book of Moses, in connection with the burning bush passage, how God spoke to him, saying, ‘I am the God of Abraham, and the God of Isaac, and the God of Jacob’? ");
INSERT INTO engemtv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","He is not the God of the dead, but the God of the living. Therefore you are greatly mistaken.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Then one of the scribes came, after he heard them reasoning together, and perceiving that He had answered them well, asked Him, “Which is the first commandment of all?” ");
INSERT INTO engemtv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus answered him, “The first of all the commandments is: ‘Hear, O Israel, the Lord our God is one Lord.’ ");
INSERT INTO engemtv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘And you shall love the Lord your God with all your heart, with all your soul, with all your mind, and with all your strength.’ This is the first commandment. ");
INSERT INTO engemtv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","And the second, like it, is this: ‘You shall love your neighbor as yourself.’ There is no other commandment greater than these.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","So the scribe said to Him, “Well said, Teacher, in truth You said that He is one, and there is no other besides Him. ");
INSERT INTO engemtv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","And to love Him with the whole heart, and with the whole understanding, with all the soul, and with all the strength, and to love one's neighbor as oneself, is more than all the burnt offerings and sacrifices.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Now when Jesus saw that he answered intelligently, He said to him, “You are not far from the kingdom of God.” And no one dared any longer to question Him. ");
INSERT INTO engemtv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Then Jesus answered and said, as He was teaching in the temple, “How is it that the scribes say that the Christ is the Son of David? ");
INSERT INTO engemtv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","For David himself said by the Holy Spirit: ‘The Lord said to my Lord, “Sit at My right hand, Till I make Your enemies a footstool for Your feet.” ’ ");
INSERT INTO engemtv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Therefore David himself calls Him ‘Lord’; how then is He his son?” And the large crowd was hearing Him gladly. ");
INSERT INTO engemtv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Then He said to them in His teaching, “Take heed of the scribes, who like to walk about in long robes, and like greetings in the marketplaces, ");
INSERT INTO engemtv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","and the first seats in the synagogues, and the first couches at the suppers; ");
INSERT INTO engemtv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","who devour widows' houses, and for a pretense make long prayers. These will receive greater condemnation.” ");
INSERT INTO engemtv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","And Jesus sat down opposite the treasury, and was observing how the crowd was putting money into the treasury. And many rich people were putting in much. ");
INSERT INTO engemtv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Then one poor widow came and put in two lepta, which equals a quadrans. ");
INSERT INTO engemtv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","And having summoned His disciples, He said to them, “Assuredly I say to you that this poor widow has put in more than all those who are putting into the treasury. ");
INSERT INTO engemtv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","For they all put in out of their excess, but this woman, out of her destitution, put in everything she had, her whole livelihood.” ");
INSERT INTO engemtv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","And as He was going out from the temple, one of His disciples said to Him, “Teacher, see what sort of stones and what sort of buildings!” ");
INSERT INTO engemtv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","And Jesus answered and said to him, “Do you see these great buildings? By no means shall one stone be left upon another, which shall in any way escape destruction.” ");
INSERT INTO engemtv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","And as He was sitting on the Mount of Olives opposite the temple, Peter, James, John, and Andrew asked Him privately, ");
INSERT INTO engemtv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tell us, when will these things be? And what will be the sign when all these things are about to be fulfilled?” ");
INSERT INTO engemtv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","And Jesus, answering them, began to say: “See that no one deceives you. ");
INSERT INTO engemtv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","For many will come in My name, saying, ‘I AM,’ and they will deceive many. ");
INSERT INTO engemtv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","But whenever you hear of wars and rumors of wars, do not be disturbed; for these things must occur, but the end is not yet. ");
INSERT INTO engemtv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","For nation will be raised up against nation, and kingdom against kingdom. And there will be earthquakes in various places, and there will be famines and disturbances. These are the beginnings of birth pains. ");
INSERT INTO engemtv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“But take heed to yourselves, for they will deliver you up to councils, and you will be flogged in the synagogues. You will stand before rulers and kings for My sake, as a testimony to them. ");
INSERT INTO engemtv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","And the gospel must first be proclaimed to all the nations. ");
INSERT INTO engemtv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","But whenever they lead you forth to deliver you over, do not worry beforehand as to what you will say, nor rack your brains. But whatever is given you in that hour, speak this; for it is not you who is speaking, but the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Now brother will deliver up brother to death, and a father his child; and children will rise up against parents and will cause them to be put to death. ");
INSERT INTO engemtv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","And you will be hated by all on account of My name. But he who endures to the end shall be saved. ");
INSERT INTO engemtv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“So whenever you see the ‘abomination of desolation,’ spoken of by Daniel the prophet, standing where he must not”—he who reads, let him understand—“then let those who are in Judea flee to the mountains. ");
INSERT INTO engemtv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","And let him on the housetop not go down into the house, nor enter to take anything out of his house. ");
INSERT INTO engemtv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","And let him who is in the field not return to the things behind, to take his garment. ");
INSERT INTO engemtv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","But woe to those who are pregnant and to those who are nursing babies in those days! ");
INSERT INTO engemtv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","And pray that your flight does not take place in winter. ");
INSERT INTO engemtv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","For in those days will be tribulation, such as there has not been the like from the beginning of creation which God created until now, and never again shall be. ");
INSERT INTO engemtv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","And unless the Lord had cut short the days, no flesh would be saved; but on account of the elect, whom He chose, He cut short the days. ");
INSERT INTO engemtv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Then if anyone says to you, ‘Look, here is the Christ!’ or, ‘Look, there He is!’ do not believe it. ");
INSERT INTO engemtv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","For false christs and false prophets will arise, and they will show signs and wonders to deceive, if possible, even the elect. ");
INSERT INTO engemtv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","But you take heed! See, I have foretold to you all things. ");
INSERT INTO engemtv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“But in those days, after that tribulation, the sun will be darkened, and the moon will not give its radiance; ");
INSERT INTO engemtv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","and the stars shall fall out of the heavens, and the powers in the heavens shall be shaken. ");
INSERT INTO engemtv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","And then they shall see the Son of Man coming in the clouds with great power and glory. ");
INSERT INTO engemtv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","And then He will send His angels, and they will gather together His elect from the four winds, from the extremity of earth to the extremity of heaven. ");
INSERT INTO engemtv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Now learn this parable from the fig tree: When its branch has already become tender, and puts forth its leaves, you know that summer is near. ");
INSERT INTO engemtv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","So also you, when you see these things coming to pass, know that it is near—even at the doors! ");
INSERT INTO engemtv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Assuredly I say to you, that by no means will this generation have passed away until all these things have taken place. ");
INSERT INTO engemtv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Heaven and earth shall pass away, but My words shall by no means pass away. ");
INSERT INTO engemtv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“But concerning that day or hour no one knows, not even the angels in heaven, nor the Son, but the Father. ");
INSERT INTO engemtv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Take heed, stay awake and pray; for you do not know when the time is. ");
INSERT INTO engemtv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","It is like a man going away on a journey, having left his house and having given authority to his servants, and to each his work, and commanded the doorkeeper that he should watch. ");
INSERT INTO engemtv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Watch therefore, for you do not know when the master of the house is coming—at evening, or at midnight, or at dawn, or early in the morning— ");
INSERT INTO engemtv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","lest having come suddenly, he should find you sleeping. ");
INSERT INTO engemtv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","And the things I say to you, I say to all: watch!” ");
INSERT INTO engemtv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Now after two days it was the Passover and the Feast of Unleavened Bread. And the chief priests and the scribes were seeking how they might get hold of Him by guile, and how they might kill Him. ");
INSERT INTO engemtv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","But they said, “Not during the feast, lest there be an uproar among the people.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","And while He was in Bethany in the house of Simon the leper, as He was reclining for a meal, a woman came having an alabaster flask of very costly pure nard. And having broken the flask, she began to pour it out over His head. ");
INSERT INTO engemtv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","But some were expressing indignation to one another and saying, “Why has this waste of the perfume occurred? ");
INSERT INTO engemtv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","For it was possible for this to be sold for more than three hundred denarii, and to be given to the poor.” And they were scolding her. ");
INSERT INTO engemtv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","But Jesus said, “Leave her alone. Why do you trouble her? She has worked a beautiful work for Me. ");
INSERT INTO engemtv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","For you always have the poor with you, and whenever you wish you are able to do them good; but you do not always have Me. ");
INSERT INTO engemtv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","This woman did what she could; she undertook beforehand to anoint My body for burial. ");
INSERT INTO engemtv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","And assuredly I say to you, wherever this gospel is proclaimed in the whole world, what this woman did will also be spoken as a memorial of her.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Then Judas Iscariot, one of the twelve, went off to the chief priests to betray Him to them. ");
INSERT INTO engemtv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","And having heard, they rejoiced and promised to give him money. So he was seeking how at some good time he might deliver Him up. ");
INSERT INTO engemtv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Now on the first day of Unleavened Bread, when the Passover lamb was sacrificed, His disciples said to Him, “Where do You desire that we go and prepare, that You may eat the Passover?” ");
INSERT INTO engemtv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","And He sent two of His disciples and said to them, “Go into the city, and a man will meet you carrying a pitcher of water. Follow him; ");
INSERT INTO engemtv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","and wherever he may enter, say to the master of the house, ‘The Teacher says, “Where is the guest room where I may eat the Passover with My disciples?” ’ ");
INSERT INTO engemtv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Then he will show you a large upper room, furnished and ready; there prepare for us.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","So His disciples went away, and came into the city, and found it just as He had said to them; and they prepared the Passover. ");
INSERT INTO engemtv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","And when it was evening, He came with the twelve. ");
INSERT INTO engemtv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","And while they were reclining and eating, Jesus said, “Assuredly, I say to you, one of you eating with Me will betray Me.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","And they began to be sorrowful, and to say to Him one by one, “Is it I?” And another said, “Is it I?” ");
INSERT INTO engemtv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","But answering He said to them, “It is one of the twelve, the one dipping with Me in the bowl. ");
INSERT INTO engemtv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","The Son of Man indeed is going away just as it is written of Him, but woe to that man through whom the Son of Man is betrayed! It would have been better for that man not to have been born.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","And as they were eating, Jesus took bread, blessed and broke it, and gave it to them and said, “Take, eat; this is My body.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","And taking the cup and giving thanks, He gave it to them, and they all drank from it. ");
INSERT INTO engemtv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","And He said to them, “This is My blood of the new covenant, which is shed for many. ");
INSERT INTO engemtv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Assuredly I say to you, I will no longer drink of the fruit of the vine until that day when I drink it new in the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","And having sung hymns, they went out to the Mount of Olives. ");
INSERT INTO engemtv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Then Jesus said to them, “You all will be made to stumble because of Me on this night, for it is written: ‘I will strike the Shepherd, and the sheep will be scattered.’ ");
INSERT INTO engemtv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“But after I am raised, I will go before you into Galilee.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","But Peter said to Him, “Even if all should fall away, I certainly will not!” ");
INSERT INTO engemtv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus said to him, “Assuredly I say to you, that you, today on this night, before the rooster crows twice, you shall deny Me three times.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","But he kept saying all the more profusely, “If it is necessary for me to die with You, by no means will I deny You!” And they all said likewise. ");
INSERT INTO engemtv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","And they came to a place which was named Gethsemane; and He said to His disciples, “Sit here while I pray.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","And He took Peter, James, and John with Him, and He began to be greatly amazed, and deeply depressed. ");
INSERT INTO engemtv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Then He said to them, “My soul is deeply grieved to the point of death. Remain here and watch.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","And having gone forward a little, He fell on the ground, and He was praying, that if it were possible, the hour might pass from Him. ");
INSERT INTO engemtv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","And He said, “Abba, Father, all things are possible for You. Take this cup away from Me; nevertheless, not what I will, but what You will.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Then He came and found them sleeping, and He said to Peter, “Simon, are you sleeping? Were you not strong enough to watch one hour? ");
INSERT INTO engemtv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Watch and pray, lest you enter into temptation. Indeed the spirit is eager, but the flesh is weak.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","And He went away again and He prayed, saying the same thing. ");
INSERT INTO engemtv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","And having returned, He found them sleeping again, for their eyes were heavy; and they did not know what they should answer Him. ");
INSERT INTO engemtv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Then He came the third time and said to them, “Sleep on now, and take your rest. It is enough! The hour has come. Behold, the Son of Man is being betrayed into the hands of sinners. ");
INSERT INTO engemtv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Rise up, let us go. See, the one who betrays Me is at hand.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","And immediately, while He was still speaking, Judas arrived, being one of the twelve, and with him a large crowd with swords and clubs, sent from the chief priests and the scribes and the elders. ");
INSERT INTO engemtv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Now His betrayer had given to them a sign, saying, “Whomever I shall kiss, He is the One; take Him and lead Him away safely.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","And when he arrived, immediately he approached Him and said to Him, “Rabbi, Rabbi!” and he affectionately kissed Him. ");
INSERT INTO engemtv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Then they laid their hands on Him and seized Him. ");
INSERT INTO engemtv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","But a certain one of those standing by drew his sword and struck the servant of the high priest, and cut off his ear. ");
INSERT INTO engemtv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Then Jesus answered and said to them, “Have you come out, as against a bandit, with swords and clubs to arrest Me? ");
INSERT INTO engemtv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Daily I was with you in the temple teaching, and you did not seize Me. But that the Scriptures may be fulfilled.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Then they all forsook Him and fled. ");
INSERT INTO engemtv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Now a certain young man had followed Him, having a linen cloth thrown around his naked body. And the young men seized him, ");
INSERT INTO engemtv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","but leaving behind the linen cloth, he fled from them naked. ");
INSERT INTO engemtv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","And they led Jesus away to the high priest; and with him were assembled all the chief priests, the elders, and the scribes. ");
INSERT INTO engemtv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","But Peter followed Him from a distance, right into the courtyard of the high priest, and he was sitting together with the attendants and warming himself at the fire. ");
INSERT INTO engemtv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Now the chief priests and the whole council were seeking testimony against Jesus, in order to put Him to death, but found none. ");
INSERT INTO engemtv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","For many were testifying falsely against Him, but their testimonies did not agree. ");
INSERT INTO engemtv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Then some stood up and were testifying falsely against Him, saying, ");
INSERT INTO engemtv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“We heard Him saying, ‘I will destroy this temple made with hands, and after three days I will build another one not made with hands.’ ” ");
INSERT INTO engemtv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","But not even in this way did their testimony agree. ");
INSERT INTO engemtv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","And the high priest stood up and came forward and questioned Jesus, saying, “Do You answer nothing? What are these men testifying against You?” ");
INSERT INTO engemtv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","But He kept silent and answered nothing. Again the high priest was questioning Him, saying to Him, “Are You the Christ, the Son of the Blessed?” ");
INSERT INTO engemtv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","And Jesus said, “I am. And you will see the Son of Man sitting at the right hand of the Power, and coming with the clouds of heaven.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Then the high priest tore his clothes and said, “What further need do we have of witnesses? ");
INSERT INTO engemtv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","You have heard the blasphemy! How does it appear to you?” And they all condemned Him to be deserving of death. ");
INSERT INTO engemtv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Then some began to spit on Him, and to blindfold Him, and to beat Him with their fists, and to say to Him, “Prophesy!” And the attendants were striking Him with slaps to His face. ");
INSERT INTO engemtv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Now as Peter was below in the courtyard, one of the servant girls of the high priest came. ");
INSERT INTO engemtv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","And when she saw Peter warming himself, she looked at him and said, “You also were with Jesus the Nazarene.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","But he denied it, saying, “I neither know nor understand what you are saying.” And he went outside into the forecourt, and a rooster crowed. ");
INSERT INTO engemtv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","And the servant girl seeing him again, began to say to those standing by, “This man is one of them.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","But again he was denying it. And a little later those who were standing by said to Peter again, “Truly you are one of them; for you are also a Galilean, and your accent is like theirs.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Then he began to curse and to swear, “I do not know this Man whom you are speaking of.” ");
INSERT INTO engemtv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","And for the second time a rooster crowed. Then Peter remembered the word that Jesus had said to him, “Before a rooster crows twice, you will deny Me three times.” And when he thought about it, he began to weep. ");
INSERT INTO engemtv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Immediately, in the morning, the chief priests held a consultation, along with the elders and scribes and the whole Sanhedrin; and having bound Jesus, they led Him away, and delivered Him to Pilate. ");
INSERT INTO engemtv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Then Pilate asked Him, “Are You the King of the Jews?” And He answered and said to him, “It is as you say.” ");
INSERT INTO engemtv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","And the chief priests were accusing Him of many things. ");
INSERT INTO engemtv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Then Pilate questioned Him again, saying, “Do You answer nothing? See how many things they testify against You!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","But Jesus no longer answered anything, so that Pilate marveled. ");
INSERT INTO engemtv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Now at the feast he would release one prisoner to them, whomever they would request. ");
INSERT INTO engemtv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","And there was one called Barabbas, having been bound with his fellow rebels, who had committed murder in the rebellion. ");
INSERT INTO engemtv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Then the crowd cried out and began to request that just as always he would do this for them. ");
INSERT INTO engemtv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","But Pilate answered them, saying, “Do you desire that I release to you the King of the Jews?” ");
INSERT INTO engemtv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","For he knew that because of envy the chief priests had delivered Him up. ");
INSERT INTO engemtv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","But the chief priests stirred up the crowd, so that he should rather release Barabbas to them. ");
INSERT INTO engemtv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","But Pilate answered and said to them again, “What then do you desire that I should do with Him whom you call King of the Jews?” ");
INSERT INTO engemtv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","And again they cried, “Crucify Him!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","But Pilate said to them, “Why, what evil did He do?” But they cried out all the more, “Crucify Him!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","So Pilate, wanting to gratify the crowd, released Barabbas to them; and he delivered up Jesus, after he had Him flogged, so that He might be crucified. ");
INSERT INTO engemtv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Then the soldiers led Him away into the courtyard, which is the Praetorium, and assembled the whole garrison. ");
INSERT INTO engemtv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","And they clothed Him with purple; and they twisted a crown of thorns, and they put it around His head, ");
INSERT INTO engemtv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","and they began to salute Him, “Hail, King of the Jews!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","And they were striking His head with a reed and were spitting on Him; and bowing the knee, they mockingly worshiped Him. ");
INSERT INTO engemtv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","And when they had mocked Him, they stripped Him of the purple, and dressed Him in His own clothing. And they led Him out so that they might crucify Him. ");
INSERT INTO engemtv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","And they pressed into service a certain man that was passing by named Simon, a Cyrenian, the father of Alexander and Rufus, as he was coming from the country, that he might carry His cross. ");
INSERT INTO engemtv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","And they brought Him to the place called Golgotha, which is translated, Place of a Skull. ");
INSERT INTO engemtv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","And they gave Him wine mingled with myrrh to drink, but He did not take it. ");
INSERT INTO engemtv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","And having crucified Him, they divided His clothes by casting lots over them, to determine who would take what. ");
INSERT INTO engemtv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Now it was the third hour, and they crucified Him. ");
INSERT INTO engemtv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","And there was the inscription of His charge having been inscribed: THE KING OF THE JEWS. ");
INSERT INTO engemtv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","And together with Him they crucified two bandits, one on His right side and the one on His left. ");
INSERT INTO engemtv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","So the Scripture was fulfilled which says, “And He was numbered with the transgressors.” ");
INSERT INTO engemtv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","And those passing by were blaspheming Him, shaking their heads and saying, “Aha! You who destroy the temple and build it in three days, ");
INSERT INTO engemtv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","save Yourself, and come down from the cross!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Likewise the chief priests also, mocking Him to each other with the scribes said, “He saved others; Himself He is not able to save. ");
INSERT INTO engemtv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Let the Christ, the King of Israel, come down now from the cross, so that we may see and believe.” Even those who were crucified with Him were reviling Him. ");
INSERT INTO engemtv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Now when the sixth hour had come, darkness came upon the whole land until the ninth hour. ");
INSERT INTO engemtv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","And at the ninth hour Jesus cried out with a loud voice, saying, “Eloi, Eloi, lima sabachthani?” which is translated, “My God, My God, why have You forsaken Me?” ");
INSERT INTO engemtv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Some of those standing by when they heard, said, “Look, He is calling Elijah.” ");
INSERT INTO engemtv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","And one, running and having filled a sponge with vinegar, and having put it around a reed, was giving a drink to Him, saying, “Leave Him alone; let us see if Elijah is coming to take Him down.” ");
INSERT INTO engemtv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","And Jesus, uttering a loud cry, breathed His last. ");
INSERT INTO engemtv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Then the veil of the temple was torn in two from top to bottom. ");
INSERT INTO engemtv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Now when the centurion who stood across from Him saw that He cried out like this and breathed His last, he said, “Truly this Man was the Son of God!” ");
INSERT INTO engemtv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","There were also women looking on from a distance, among whom were both Mary Magdalene, Mary the mother of James the Less and of Joses, and Salome, ");
INSERT INTO engemtv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","who also would follow Him and would minister to Him when He was in Galilee; and many other women who had come up together with Him to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","And now evening having come, since it was Preparation Day, which is the day before the Sabbath, ");
INSERT INTO engemtv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph of Arimathea, a prominent council member, who was himself waiting for the kingdom of God, coming and taking courage, he went in to Pilate and asked for the body of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","And Pilate wondered if He was already dead; and having summoned the centurion, he questioned him if He had been dead long. ");
INSERT INTO engemtv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","And when he found out from the centurion, he granted the body to Joseph. ");
INSERT INTO engemtv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","And having bought linen cloth, and having taken Him down, he wrapped Him in the linen cloth and set Him down in a tomb which had been cut out of a rock, and rolled a stone upon the door of the tomb. ");
INSERT INTO engemtv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","And Mary Magdalene and Mary the mother of Joses were observing where He was placed. ");
INSERT INTO engemtv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Now when the Sabbath was past, Mary Magdalene, and Mary the mother of James, and Salome bought spices, so that they might come and anoint Him. ");
INSERT INTO engemtv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","And very early on the first day of the week, they came to the tomb when the sun had risen. ");
INSERT INTO engemtv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","And they said to one another, “Who will roll away the stone from the door of the tomb for us?” ");
INSERT INTO engemtv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","And having looked up, they saw that the stone had been rolled away—for it was exceedingly large. ");
INSERT INTO engemtv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","And entering into the tomb, they saw a young man sitting on the right clothed with a white robe, and they were alarmed. ");
INSERT INTO engemtv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","But he said to them, “Do not be alarmed. You are seeking Jesus the Nazarene, who was crucified. He has arisen! He is not here! See the place where they put Him. ");
INSERT INTO engemtv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","But go, say to His disciples, and Peter, that He is going before you into Galilee; there you shall see Him, just as He said to you.” ");
INSERT INTO engemtv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","And going out, they fled from the tomb, but trembling and amazement held them; and they said nothing to anyone, for they were afraid. ");
INSERT INTO engemtv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Now having arisen early on the first day of the week, He appeared first to Mary Magdalene, from whom He had cast out seven demons. ");
INSERT INTO engemtv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","She went and reported to those who had been with Him, as they were grieving and weeping. ");
INSERT INTO engemtv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","And those, when they heard that He was alive and had been seen by her, did not believe. ");
INSERT INTO engemtv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","After that, He appeared in a different form to two of them as they were going into the country. ");
INSERT INTO engemtv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","And those returned and reported it to the rest; but neither did they believe them. ");
INSERT INTO engemtv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Afterwards He appeared to the eleven as they were reclining at the table; and He rebuked their unbelief and hardness of heart, because they did not believe those who saw Him after He had been raised. ");
INSERT INTO engemtv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","And He said to them, “Go into all the world and proclaim the gospel to all creation. ");
INSERT INTO engemtv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","He that believes and is baptized shall be saved; but he that does not believe shall be condemned. ");
INSERT INTO engemtv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","And these signs shall accompany those who have believed: In My name they shall cast out demons; they shall speak with new tongues; ");
INSERT INTO engemtv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","they shall pick up serpents; and if they drink anything deadly, it shall by no means hurt them; they shall lay hands on the sick, and they shall be well.” ");
INSERT INTO engemtv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","So then, after the Lord had spoken to them, He was taken up into heaven, and sat down at the right hand of God. ");
INSERT INTO engemtv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","And they went out and preached everywhere, the Lord working with them and confirming the word through the accompanying signs. Amen. ");
INSERT INTO engemtv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Since many have attempted to arrange a narrative about the matters which have taken place among us, ");
INSERT INTO engemtv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","just as those who from the beginning were eyewitnesses and ministers of the word delivered them to us, ");
INSERT INTO engemtv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","it seemed good to me also, having followed up accurately all things from above, to write to you in orderly fashion, most distinguished Theophilus, ");
INSERT INTO engemtv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","so that you may know the certainty of those things in which you were instructed. ");
INSERT INTO engemtv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","There was in the days of Herod, the king of Judea, a certain priest named Zacharias, of the division of Abijah. His wife was of the daughters of Aaron, and her name was Elizabeth. ");
INSERT INTO engemtv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","And they were both righteous before God, walking in all the commandments and ordinances of the Lord blameless. ");
INSERT INTO engemtv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","But they had no children, because Elizabeth was barren, and they were both well advanced in years. ");
INSERT INTO engemtv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","So it was, that while he was serving as priest before God in the order of his division, ");
INSERT INTO engemtv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","according to the custom of the priesthood, he was selected to burn incense when he entered into the temple of the Lord. ");
INSERT INTO engemtv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","And all the multitude of the people were praying outside at the hour of incense. ");
INSERT INTO engemtv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Then an angel of the Lord appeared to him, standing on the right side of the altar of incense. ");
INSERT INTO engemtv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","And when Zacharias saw him, he was troubled, and fear fell upon him. ");
INSERT INTO engemtv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","But the angel said to him, “Do not be afraid, Zacharias, because your prayer has been heard; and your wife Elizabeth will bear a son to you, and you shall call his name John. ");
INSERT INTO engemtv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","And you will have joy and gladness, and many will rejoice at his birth. ");
INSERT INTO engemtv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","For he shall be great before the Lord, and shall drink neither wine nor strong drink. He will also be filled with the Holy Spirit, while still in his mother's womb. ");
INSERT INTO engemtv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","And he will turn many of the sons of Israel to the Lord their God. ");
INSERT INTO engemtv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","And he himself will go before Him in the spirit and power of Elijah, ‘to turn the hearts of the fathers to the children,’ and the disobedient to the wisdom of the righteous, to make ready a people prepared for the Lord.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","And Zacharias said to the angel, “How shall I know this? For I am an old man, and my wife is well advanced in years.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","And the angel answered and said to him, “I am Gabriel, who stands before God, and I was sent to speak to you and to proclaim the good news to you of these things. ");
INSERT INTO engemtv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","But behold, you shall be silent and not able to speak until the day these things take place, because you did not believe my words which shall be fulfilled in their season.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","And the people waited for Zacharias, and they marveled at his delaying in the temple. ");
INSERT INTO engemtv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","But having come out, he was unable to speak to them; and they recognized that he had seen a vision in the temple, for he was making signs to them and remained speechless. ");
INSERT INTO engemtv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","And it happened, as soon as the days of his service were fulfilled, that he went away to his house. ");
INSERT INTO engemtv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Now after those days Elizabeth his wife conceived; and stayed in seclusion five months, saying, ");
INSERT INTO engemtv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Thus the Lord has dealt with me, in the days when He looked on me, to take away my reproach among men.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Now in the sixth month the angel Gabriel was sent by God to a city of Galilee named Nazareth, ");
INSERT INTO engemtv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","to a virgin betrothed to a man named Joseph, of the house of David. The virgin's name was Mary. ");
INSERT INTO engemtv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","And the angel came to her and said, “Greetings, O favored one, the Lord is with you; blessed are you among women!” ");
INSERT INTO engemtv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","But when she saw him, she was greatly perplexed by his saying, and she wondered what sort of greeting this was. ");
INSERT INTO engemtv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Then the angel said to her, “Do not fear, Mary, for you have found grace with God. ");
INSERT INTO engemtv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","And behold, you shall conceive in your womb and bring forth a Son, and you shall call His name JESUS. ");
INSERT INTO engemtv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","He shall be great, and shall be called the Son of the Most High; and the Lord God shall give Him the throne of His father David. ");
INSERT INTO engemtv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","And He shall reign over the house of Jacob forever, and of His kingdom there shall be no end.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Then Mary said to the angel, “How can this be, since I do not know a man?” ");
INSERT INTO engemtv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","And the angel answered and said to her, “The Holy Spirit shall come upon you, and the power of the Most High shall overshadow you; therefore, also, that holy child which is to be born shall be called the Son of God. ");
INSERT INTO engemtv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","And behold, Elizabeth your relative has also conceived a son in her old age; and this is now the sixth month for she who was called barren. ");
INSERT INTO engemtv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","For with God nothing shall be impossible.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Then Mary said, “Behold the maidservant of the Lord! May it be to me according to your word.” And the angel departed from her. ");
INSERT INTO engemtv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Now Mary rose up in those days and traveled into the hill country with haste, to a city of Judah, ");
INSERT INTO engemtv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","and entered the house of Zacharias and greeted Elizabeth. ");
INSERT INTO engemtv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","And it came to pass, that when Elizabeth heard the greeting of Mary, that the baby leaped in her womb; and Elizabeth was filled with the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Then she spoke out with a loud voice and said, “Blessed are you among women, and blessed is the fruit of your womb! ");
INSERT INTO engemtv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","And why am I so favored, that the mother of my Lord should come to me? ");
INSERT INTO engemtv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","For behold, as soon as the voice of your greeting sounded in my ears, the baby leaped for joy in my womb. ");
INSERT INTO engemtv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","And blessed is she who has believed, because there shall be a fulfillment to the things having been spoken to her from the Lord.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","And Mary said: “My soul magnifies the Lord, ");
INSERT INTO engemtv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","And my spirit has rejoiced in God my Savior. ");
INSERT INTO engemtv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Because He looked upon the lowly state of His maidservant; For behold, henceforth all generations will call me blessed. ");
INSERT INTO engemtv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","For He that is mighty has done great things for me, And holy is His name. ");
INSERT INTO engemtv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","And His mercy is on those who fear Him From generation to generation. ");
INSERT INTO engemtv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","He has shown strength with His arm; He has scattered the proud in the imagination of their hearts. ");
INSERT INTO engemtv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","He has overthrown the mighty from their thrones, And exalted the lowly. ");
INSERT INTO engemtv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","He has filled the hungry with good things, And the rich He has sent away empty. ");
INSERT INTO engemtv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","He has helped His servant Israel, In remembrance of His mercy, ");
INSERT INTO engemtv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","As He spoke to our fathers, To Abraham and to his seed forever.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","And Mary remained with her about three months, and she returned to her house. ");
INSERT INTO engemtv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Now Elizabeth's full time came for her to be delivered, and she bore a son. ");
INSERT INTO engemtv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","And when her neighbors and relatives heard how the Lord had shown great mercy to her, they rejoiced with her. ");
INSERT INTO engemtv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Now it came to pass on the eighth day, that they came to circumcise the child; and they started to call him by the name of his father, Zacharias. ");
INSERT INTO engemtv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","His mother answered and said, “No; he shall be called John.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","But they said to her, “There is no one among your relatives who is called by this name.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","So they made signs to his father about what he wished him to be called. ");
INSERT INTO engemtv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","And asking for a writing tablet, he wrote, saying, “His name is John.” And they all marveled. ");
INSERT INTO engemtv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Immediately his mouth was opened and his tongue loosed, and he started to speak, praising God. ");
INSERT INTO engemtv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Then fear came on all who lived around them; and all these things were being talked about throughout all the hill country of Judea. ");
INSERT INTO engemtv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","And all those who heard them kept them in their hearts, saying, “What kind of child will this be?” And the hand of the Lord was with him. ");
INSERT INTO engemtv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Now his father Zacharias was filled with the Holy Spirit, and he prophesied, saying, ");
INSERT INTO engemtv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Blessed be the Lord God of Israel, For He has visited and redeemed His people, ");
INSERT INTO engemtv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","And has raised up a horn of salvation for us In the house of His servant David, ");
INSERT INTO engemtv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","As He spoke by the mouth of His holy prophets, Who have been since the world began, ");
INSERT INTO engemtv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","That we should be saved from our enemies And from the hand of all who hate us, ");
INSERT INTO engemtv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","To perform the mercy promised to our fathers And to remember His holy covenant, ");
INSERT INTO engemtv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","The oath which He swore to our father Abraham: ");
INSERT INTO engemtv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","To grant us that we, Being delivered from the hand of our enemies, Might serve Him without fear, ");
INSERT INTO engemtv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","In holiness and righteousness before Him All the days of our life. ");
INSERT INTO engemtv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","And you, child, will be called the prophet of the Most High; For you will go before the face of the Lord To prepare His ways, ");
INSERT INTO engemtv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","To give knowledge of salvation to His people By the remission of their sins, ");
INSERT INTO engemtv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Through the tender mercy of our God, With which the Dayspring from on high has visited us; ");
INSERT INTO engemtv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","To give light to them that sit in darkness and in the shadow of death, To guide our feet into the way of peace.” ");
INSERT INTO engemtv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","So the child grew and became strong in spirit, and was in the deserts till the day of his manifestation to Israel. ");
INSERT INTO engemtv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","And it came to pass in those days that a decree went out from Caesar Augustus that a census be taken of all the empire. ");
INSERT INTO engemtv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","This census was the first one while Quirinius was governing Syria. ");
INSERT INTO engemtv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","And all were traveling to be registered, each to his own city. ");
INSERT INTO engemtv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph also went up from Galilee, out of the city of Nazareth, into Judea, to the city of David, which is called Bethlehem, because he was of the house and family of David, ");
INSERT INTO engemtv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","to be registered with Mary, his betrothed wife, who was pregnant. ");
INSERT INTO engemtv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","So it was, that while they were there, the days were completed for her to bear. ");
INSERT INTO engemtv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","And she bore her firstborn Son, and wrapped Him in swaddling cloths, and laid Him in a manger, because there was no place for them in the inn. ");
INSERT INTO engemtv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","And shepherds were in the same country, living in the fields and keeping watch over their flock by night. ");
INSERT INTO engemtv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","And behold, an angel of the Lord stood before them, and the glory of the Lord shone around them, and they were greatly afraid. ");
INSERT INTO engemtv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Then the angel said to them, “Do not fear, for behold, I bring you good tidings of great joy which will be to all people. ");
INSERT INTO engemtv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","For unto you is born this day in the city of David a Savior, who is Christ the Lord. ");
INSERT INTO engemtv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","And this will be the sign to you: You will find a baby wrapped in swaddling cloths, lying in a manger.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","And suddenly there was with the angel a multitude of the heavenly host praising God and saying: ");
INSERT INTO engemtv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Glory to God in the highest, And on earth peace, goodwill toward men!” ");
INSERT INTO engemtv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","So it was, when the angels had departed from them into heaven, that the shepherds said to one another, “Let us go then to Bethlehem and see this thing that has come to pass, which the Lord has made known to us.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","And they came with haste and found Mary and Joseph, and the baby lying in a manger. ");
INSERT INTO engemtv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","And when they had seen Him, they made widely known the saying which was told them concerning this Child. ");
INSERT INTO engemtv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","And all those who heard it marveled about the things spoken by the shepherds to them. ");
INSERT INTO engemtv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","But Mary treasured all these things and pondered them in her heart. ");
INSERT INTO engemtv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Then the shepherds returned, glorifying and praising God for all the things that they had heard and seen, as it was spoken to them. ");
INSERT INTO engemtv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","And when eight days were completed, so they could circumcise Him, His name was called Jesus, the name given by the angel before He was conceived in the womb. ");
INSERT INTO engemtv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Now when the days of their purification according to the law of Moses were completed, they brought Him to Jerusalem to present Him to the Lord ");
INSERT INTO engemtv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(just as it is written in the law of the Lord, “Every male who opens the womb shall be called holy to the Lord”), ");
INSERT INTO engemtv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","and to offer a sacrifice according to what had been said in the law of the Lord, “A pair of doves or two young pigeons.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","And behold, there was a man in Jerusalem whose name was Simeon, and this man was just and devout, waiting for the Consolation of Israel, and the Holy Spirit was upon him. ");
INSERT INTO engemtv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","And it had been revealed to him by the Holy Spirit that he would not see death before he should see the Lord's Christ. ");
INSERT INTO engemtv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","So he came by the Spirit into the temple. And when the parents brought in the Child Jesus, that they might do for Him according to the custom of the law, ");
INSERT INTO engemtv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","he took Him up in his arms and blessed God and said: ");
INSERT INTO engemtv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lord, now You are releasing Your servant in peace, According to Your word; ");
INSERT INTO engemtv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","For my eyes have seen Your salvation ");
INSERT INTO engemtv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Which You have prepared before the face of all peoples, ");
INSERT INTO engemtv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A light for a revelation to the Gentiles, And a glory to Your people Israel.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","And Joseph and His mother were marveling at the things being spoken about Him. ");
INSERT INTO engemtv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Then Simeon blessed them, and said to Mary His mother, “Behold, this Child is destined for the fall and rise of many in Israel, and for a sign which will be spoken against ");
INSERT INTO engemtv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(yes, a sword will pierce through your own soul also), so that the thoughts of many hearts may be revealed.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Now there was one, Hannah, a prophetess, a daughter of Phanuel, of the tribe of Asher. She was very old, and had lived with a husband seven years from her virginity; ");
INSERT INTO engemtv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","and she was a widow of about eighty-four years, who did not depart from the temple, but served God with fastings and prayers night and day. ");
INSERT INTO engemtv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","And coming in that instant she was giving thanks to the Lord, and was speaking about Him to all those who waited for redemption in Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","So when they had performed all things according to the law of the Lord, they returned to Galilee, to their own city, Nazareth. ");
INSERT INTO engemtv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","And the Child was growing and becoming strong in spirit, being filled with wisdom; and the grace of God was upon Him. ");
INSERT INTO engemtv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","And His parents traveled to Jerusalem every year to the Feast of the Passover. ");
INSERT INTO engemtv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","And when He was twelve years old, when they went up to Jerusalem according to the custom of the feast, ");
INSERT INTO engemtv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","and when they completed the days, while they were returning, the Child Jesus remained in Jerusalem; and Joseph and His mother did not know it. ");
INSERT INTO engemtv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","But supposing Him to be in the caravan, they went a day's journey, and sought Him among their relatives and among their acquaintances. ");
INSERT INTO engemtv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","And when they did not find Him, they returned to Jerusalem, seeking Him. ");
INSERT INTO engemtv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Now it came to pass that after three days they found Him in the temple, sitting in the midst of the teachers, both hearing them and questioning them. ");
INSERT INTO engemtv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","And those who heard Him were astonished at His understanding and His answers. ");
INSERT INTO engemtv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","And when they saw Him, they were amazed; and His mother said to Him, “Child, why have You treated us this way? Look, Your father and I were seeking You anxiously.” ");
INSERT INTO engemtv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","And He said to them, “Why is it that you were seeking Me? Did you not know that I must be about My Father's business?” ");
INSERT INTO engemtv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","But they did not understand the statement which He spoke to them. ");
INSERT INTO engemtv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Then He went down with them and came to Nazareth, and was subject to them. And His mother kept all these things in her heart. ");
INSERT INTO engemtv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","And Jesus increased in wisdom and stature, and in favor with God and men. ");
INSERT INTO engemtv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Now in the fifteenth year of the reign of Tiberius Caesar, while Pontius Pilate was governing Judea, and while Herod governed as tetrarch of Galilee, and while Philip his brother governed as tetrarch of Iturea and the region of Trachonitis, and while Lysanias governed as tetrarch of Abilene, ");
INSERT INTO engemtv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","in the time of the high priest Annas and the high priest Caiaphas, the word of God came to John the son of Zacharias in the wilderness. ");
INSERT INTO engemtv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","And he went into all the surrounding region of the Jordan, preaching a baptism of repentance for the forgiveness of sins, ");
INSERT INTO engemtv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","as it is written in the book of the words of Isaiah the prophet, saying: “A voice of one crying in the wilderness: ‘Prepare the way of the Lord, make His paths straight. ");
INSERT INTO engemtv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Every valley shall be filled and every mountain and hill shall be humbled; the crooked roads shall become straight, and the rough roads shall become smooth; ");
INSERT INTO engemtv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","and all flesh shall see the salvation of God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Then he said to the crowds which came out to be baptized by him, “Brood of vipers! Who warned you to flee from the coming wrath? ");
INSERT INTO engemtv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Therefore produce fruits worthy of repentance, and do not begin to say among yourselves, ‘We have Abraham as our father.’ For I say to you that God is able to raise up children to Abraham out of these stones! ");
INSERT INTO engemtv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","And even now the ax is being laid to the root of the trees. Therefore every tree which does not bear good fruit is cut down and is thrown into the fire.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","So the people were asking him, saying, “What shall we do then?” ");
INSERT INTO engemtv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","He answered and said to them, “He who has two shirts, let him give to him who has none; and he who has food, let him do likewise.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Then tax collectors also came to be baptized, and said to him, “Teacher, what shall we do?” ");
INSERT INTO engemtv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","And he said to them, “Collect nothing more than the amount which has been commanded to you.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Likewise the soldiers also were asking him, saying, “And what shall we do?” So he said to them, “Do not intimidate anyone or accuse anyone falsely, and be content with your wages.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Now while the people waited, and all considered in their hearts about John, whether he might be the Christ, ");
INSERT INTO engemtv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John answered, saying to all, “I indeed baptize you with water; but One mightier than I is coming, whose sandal strap I am not worthy to loose. He will baptize you with the Holy Spirit and fire; ");
INSERT INTO engemtv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","whose winnowing shovel is in His hand, and He will thoroughly purge His threshing floor, and will gather the wheat into His barn; but the chaff He will burn up with unquenchable fire.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","And with many other exhortations he proclaimed the good news to the people. ");
INSERT INTO engemtv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","But Herod the tetrarch, being rebuked by him concerning Herodias, his brother's wife, and for all the evils which Herod had done, ");
INSERT INTO engemtv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","he also added this to all his other sins, and locked up John in the prison. ");
INSERT INTO engemtv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Now it came to pass that when all the people were baptized, that Jesus also was baptized. And while He was praying, heaven was opened; ");
INSERT INTO engemtv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","and the Holy Spirit descended in bodily form like a dove upon Him, and a voice came out of heaven, saying, “You are My beloved Son; in You I am well pleased.” ");
INSERT INTO engemtv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Now Jesus Himself began His ministry at about thirty years of age, being (as it was supposed) the son of Joseph, the son of Heli, ");
INSERT INTO engemtv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","the son of Matthat, the son of Levi, the son of Melchi, the son of Janna, the son of Joseph, ");
INSERT INTO engemtv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","the son of Mattathiah, the son of Amos, the son of Nahum, the son of Esli, the son of Naggai, ");
INSERT INTO engemtv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","the son of Maath, the son of Mattathiah, the son of Semei, the son of Joseph, the son of Judah, ");
INSERT INTO engemtv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","the son of Joannas, the son of Rhesa, the son of Zerubbabel, the son of Shealtiel, the son of Neri, ");
INSERT INTO engemtv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","the son of Melchi, the son of Addi, the son of Cosam, the son of Elmodam, the son of Er, ");
INSERT INTO engemtv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","the son of Jose, the son of Eliezer, the son of Jorim, the son of Matthat, the son of Levi, ");
INSERT INTO engemtv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","the son of Simeon, the son of Judah, the son of Joseph, the son of Jonan, the son of Eliakim, ");
INSERT INTO engemtv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","the son of Melea, the son of Menan, the son of Mattathah, the son of Nathan, the son of David, ");
INSERT INTO engemtv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","the son of Jesse, the son of Obed, the son of Boaz, the son of Salmon, the son of Nahshon, ");
INSERT INTO engemtv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","the son of Amminadab, the son of Aram, the son of Joram, the son of Hezron, the son of Perez, the son of Judah, ");
INSERT INTO engemtv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","the son of Jacob, the son of Isaac, the son of Abraham, the son of Terah, the son of Nahor, ");
INSERT INTO engemtv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","the son of Serug, the son of Reu, the son of Peleg, the son of Eber, the son of Shelah, ");
INSERT INTO engemtv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","the son of Cainan, the son of Arphaxad, the son of Shem, the son of Noah, the son of Lamech, ");
INSERT INTO engemtv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","the son of Methuselah, the son of Enoch, the son of Jared, the son of Mahalalel, the son of Cainan, ");
INSERT INTO engemtv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","the son of Enos, the son of Seth, the son of Adam, the son of God. ");
INSERT INTO engemtv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Then Jesus, being filled with the Holy Spirit, returned from the Jordan and was led by the Spirit into the wilderness, ");
INSERT INTO engemtv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","being tempted for forty days by the devil. And in those days He ate nothing, and afterward, when they were completed, He was hungry. ");
INSERT INTO engemtv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","And the devil said to Him, “If You are the Son of God, speak to this stone that it may become bread.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","But Jesus answered him, saying, “It is written, ‘Man shall not live by bread alone, but by every word of God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Then the devil, leading Him up on a high mountain, showed Him all the kingdoms of the world in a moment of time. ");
INSERT INTO engemtv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","And the devil said to Him, “All this authority I will give You, and their glory; because it has been given to me, and I give it to whomever I wish. ");
INSERT INTO engemtv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Therefore, if You will worship before me, all will be Yours.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","And Jesus answered and said to him, “Get behind Me, Satan! It is written, ‘You shall worship the Lord your God, and Him only you shall serve.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Then he brought Him to Jerusalem, set Him on the pinnacle of the temple, and said to Him, “If You are the Son of God, throw Yourself down from here. ");
INSERT INTO engemtv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","For it is written: ‘He shall give His angels charge over You, to guard You,’ ");
INSERT INTO engemtv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","and, ‘In their hands they shall bear you up, lest you dash your foot against a stone.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","And Jesus answered and said to him, “It has been said, ‘You shall not tempt the Lord your God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Now when the devil had completed every temptation, he departed from Him for a season. ");
INSERT INTO engemtv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Then Jesus returned in the power of the Spirit to Galilee, and news about Him spread throughout all the surrounding region. ");
INSERT INTO engemtv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","And He taught in their synagogues, being glorified by all. ");
INSERT INTO engemtv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","And He came to Nazareth, where He had been brought up. And as His custom was, He entered into the synagogue on the Sabbath day, and He stood up to read. ");
INSERT INTO engemtv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","And the book of Isaiah the prophet was given to Him. And having unrolled the scroll, He found the place where it was written: ");
INSERT INTO engemtv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“The Spirit of the Lord is upon Me, because He has anointed Me to preach the gospel to the poor; He has sent Me to heal the brokenhearted, to proclaim liberty to the captives and recovery of sight to the blind, to set at liberty those who are oppressed; ");
INSERT INTO engemtv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","to preach the acceptable year of the Lord.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","And having rolled up the scroll, when He had given it to the attendant, He sat down. And the eyes of all who were in the synagogue were looking intently at Him. ");
INSERT INTO engemtv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","And He began to say to them, “Today this Scripture is fulfilled in your hearing.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","And all were bearing witness to Him, and were marveling at the gracious words which came out of His mouth. And they said, “Is this not Joseph's son?” ");
INSERT INTO engemtv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","He said to them, “You will surely say this proverb to Me, ‘Physician, heal yourself! Whatever we have heard done in Capernaum, do also here in Your hometown.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Then He said, “Assuredly I say to you, no prophet is accepted in his hometown. ");
INSERT INTO engemtv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","But I tell you truly, there were many widows in Israel in the days of Elijah, when the heaven was shut up three years and six months, and there was a great famine all over the land; ");
INSERT INTO engemtv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","but to none of them was Elijah sent except to Zarephath, in the region of Sidon, to a widow woman. ");
INSERT INTO engemtv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","And there were many lepers in Israel in the time of Elisha the prophet, and none of them was cleansed except Naaman the Syrian.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","So all those in the synagogue, when they heard these things, were filled with wrath, ");
INSERT INTO engemtv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","and rising up they threw Him out of the city; and brought Him to the brow of the hill on which their city was built, in order to throw Him down. ");
INSERT INTO engemtv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","But having passed through the midst of them, He went on. ");
INSERT INTO engemtv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Then He went down to Capernaum, a city of Galilee, and He was teaching them on the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","And they were astonished at His teaching, because His word was with authority. ");
INSERT INTO engemtv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Now in the synagogue there was a man who had a spirit of an unclean demon. And he cried out with a loud voice, ");
INSERT INTO engemtv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","saying, “Ah! What have we to do with You, Jesus of Nazareth? Did You come to destroy us? I know who You are—the Holy One of God!” ");
INSERT INTO engemtv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","But Jesus rebuked him, saying, “Be silenced, and come out from him!” And when the demon had thrown him down in their midst, it came out from him, and did not hurt him. ");
INSERT INTO engemtv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","And amazement came upon all, and they spoke among themselves, saying, “What is this word! For with authority and power He commands the unclean spirits, and they come out.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","And the report about Him was spreading into every place of the surrounding region. ");
INSERT INTO engemtv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","And when He arose from the synagogue, He entered into the house of Simon. But Simon's mother-in-law was sick with a high fever, and they made request of Him about her. ");
INSERT INTO engemtv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","And when He stood over her, He rebuked the fever, and it left her. And immediately rising up, she began to serve them. ");
INSERT INTO engemtv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Now when the sun was setting, all those who had any that were sick with various diseases brought them to Him; and He laid His hands on each one of them and healed them. ");
INSERT INTO engemtv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","And also demons were coming out of many, crying out and saying, “You are the Christ, the Son of God!” And rebuking them, He did not allow them to speak, because they knew that He was the Messiah. ");
INSERT INTO engemtv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Now when it was day, He departed and went into a deserted place. And the crowds were searching for Him, and they came to Him, and tried to restrain Him from leaving them; ");
INSERT INTO engemtv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","but He said to them, “I must proclaim the good news of the kingdom of God to the other cities also, because for this purpose I have been sent.” ");
INSERT INTO engemtv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","And He was preaching in the synagogues of Galilee. ");
INSERT INTO engemtv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Now it came to pass, while the crowd pressed upon Him to hear the word of God, that He stood by the Lake of Gennesaret, ");
INSERT INTO engemtv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","and He saw two boats standing by the lake; but the fishermen, after getting out of them, were washing their nets. ");
INSERT INTO engemtv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Then He got into one of the boats, which was Simon's, and He asked him to put out a little from the land. And sitting down, He began to teach the crowds from the boat. ");
INSERT INTO engemtv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Now when He had stopped speaking, He said to Simon, “Put out into the deep and lower your nets for a catch.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","But Simon answered and said to Him, “Master, we have labored all night and caught nothing; nevertheless at Your word I will lower the net.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","And when they had done this, they caught a great multitude of fish, and their net was tearing. ");
INSERT INTO engemtv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","So they beckoned to their partners who were in the other boat to come and help them. And they came and filled both the boats, so that they were sinking. ");
INSERT INTO engemtv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","When Simon Peter saw it, he fell down at Jesus' knees, saying, “Depart from me, for I am a sinful man, O Lord!” ");
INSERT INTO engemtv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","For astonishment gripped him and all who were with him at the haul of fish which they had taken. ");
INSERT INTO engemtv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","And likewise also it gripped James and John, the sons of Zebedee, who were partners with Simon. And Jesus said to Simon, “Do not fear; from now on you shall be catching men.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","And having brought the boats to land, they left everything and followed Him. ");
INSERT INTO engemtv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","And it came to pass while He was in a certain city, that behold, there was a man full of leprosy. And when he saw Jesus, falling on his face he begged Him, saying, “Lord, if You are willing, You can cleanse me.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","And reaching out His hand, He touched him, saying, “I am willing; be cleansed.” Immediately the leprosy departed from him. ");
INSERT INTO engemtv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","And He ordered him to tell no one, “But go and show yourself to the priest, and bring an offering for your cleansing, as a testimony to them, just as Moses prescribed.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","But the report about Him spread all the more; and great crowds came together to hear, and to be healed by Him from their sicknesses. ");
INSERT INTO engemtv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","But He Himself would withdraw into the wilderness and would pray. ");
INSERT INTO engemtv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Now it happened on a certain day that He was teaching, and Pharisees and teachers of the law were sitting there, who had come out of every village of Galilee, Judea, and Jerusalem. And the power of the Lord was present to heal them. ");
INSERT INTO engemtv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","And behold, men were carrying on a bed a man who was paralyzed, and they were seeking to bring him in and to lay him before Him. ");
INSERT INTO engemtv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","And when they could not find how they might bring him in, because of the crowd, going up on the roof, they lowered him down with his bed through the tiles into the midst in front of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","And seeing their faith, He said to him, “Man, your sins have been forgiven you.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","And the scribes and the Pharisees began to reason, saying, “Who is this Man who speaks blasphemies? Who can forgive sins except God alone?” ");
INSERT INTO engemtv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","But when Jesus perceived their reasonings, He answered and said to them, “Why are you reasoning in your hearts? ");
INSERT INTO engemtv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Which is easier, to say, ‘Your sins are forgiven you,’ or to say, ‘Arise and walk’? ");
INSERT INTO engemtv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","But that you may know that the Son of Man has authority on earth to forgive sins”—He said to the man who was paralyzed, “I say to you, arise, take up your bed, and go to your house.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Immediately he rose up before them, taking up the bed which he had been lying on, he went off to his own house, glorifying God. ");
INSERT INTO engemtv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","And amazement gripped them all, and they were glorifying God, and they were filled with fear, saying, “We have seen extraordinary things today!” ");
INSERT INTO engemtv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","After these things He went out and saw a tax collector named Levi, sitting at the tax office. And He said to him, “Follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","And leaving everything, he arose and followed Him. ");
INSERT INTO engemtv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Then Levi made a great banquet for Him in his own house. And there was a great number of tax collectors and others who were reclining with them to eat. ");
INSERT INTO engemtv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","And their scribes and the Pharisees complained against His disciples, saying, “Why do You eat and drink with tax collectors and sinners?” ");
INSERT INTO engemtv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus answered and said to them, “Those who are healthy have no need of a physician, but those who are sick. ");
INSERT INTO engemtv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","I have not come to call the righteous, but sinners, to repentance.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Then they said to Him, “Why do the disciples of John fast often and make prayers, and likewise also the disciples of the Pharisees, but Yours eat and drink?” ");
INSERT INTO engemtv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","And He said to them, “Can you make the groomsmen fast while the bridegroom is with them? ");
INSERT INTO engemtv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","But the days will come when the bridegroom will be taken away from them; then they will fast in those days.” ");
INSERT INTO engemtv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Then He spoke a parable to them: “No one puts a patch of a new garment on an old one; otherwise both the new garment tears, and also the patch that was taken out of the new garment does not match with the old garment. ");
INSERT INTO engemtv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","And no one puts new wine into old wineskins; otherwise the new wine will burst the wineskins and it will be spilled, and the wineskins will be ruined. ");
INSERT INTO engemtv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","But one must put new wine into new wineskins, and both are preserved together. ");
INSERT INTO engemtv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","And no one, having drunk old wine, immediately desires new; for he says, ‘The old is better.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Now it came to pass on the second chief Sabbath, that He was going through the grain fields. And His disciples were picking the heads of grain and were eating them, rubbing them in their hands. ");
INSERT INTO engemtv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","But some of the Pharisees said to them, “Why do you do what is not lawful to do on the Sabbath?” ");
INSERT INTO engemtv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","But Jesus answering them said, “Have you not even read this, what David did when he became hungry, he and those who were with him: ");
INSERT INTO engemtv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","how he entered into the house of God, took and ate the showbread, and also gave some to those with him, which is not lawful for any but the priests to eat?” ");
INSERT INTO engemtv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","And He said to them, “The Son of Man is Lord even of the Sabbath.” ");
INSERT INTO engemtv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Now it happened that on another Sabbath, He entered the synagogue and was teaching. And there was a man there whose right hand was withered. ");
INSERT INTO engemtv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","And the scribes and Pharisees were observing if whether He would heal on the Sabbath, that they might find an accusation against Him. ");
INSERT INTO engemtv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","But He knew their thoughts, and said to the man who had the withered hand, “Arise and stand in the midst.” And he arose and stood. ");
INSERT INTO engemtv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Then Jesus said to them, “I will ask you one thing: Is it lawful on the Sabbath to do good or to do evil, to save life or to destroy it?” ");
INSERT INTO engemtv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","And when He had looked around at them all, He said to him, “Stretch out your hand.” And he did so, and his hand was restored as whole as the other. ");
INSERT INTO engemtv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","But they were filled with fury, and they were discussing with one another what they might do to Jesus. ");
INSERT INTO engemtv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Now it came to pass in those days that He went out to the mountain to pray, and He was spending the night in prayer to God. ");
INSERT INTO engemtv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","And when it became day, He summoned His disciples, and having chosen twelve from them, whom He also named apostles: ");
INSERT INTO engemtv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","He chose Simon, whom He also named Peter, and Andrew his brother; James and John; Philip and Bartholomew; ");
INSERT INTO engemtv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew and Thomas; James the son of Alphaeus, and Simon called the Zealot; ");
INSERT INTO engemtv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas the son of James, and Judas Iscariot who also became a traitor. ");
INSERT INTO engemtv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","And having come down with them, He stood on a level place, with a crowd of His disciples and a great multitude of people from all Judea and Jerusalem, and from the seacoast of Tyre and Sidon, who came to hear Him and be healed of their diseases, ");
INSERT INTO engemtv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","as well as those who were tormented by unclean spirits, and they were being healed. ");
INSERT INTO engemtv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","And all the crowd was trying to touch Him, because power was going out from Him, and was healing them all. ");
INSERT INTO engemtv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Then He lifted up His eyes toward His disciples, and said: “Blessed are you who are poor, For yours is the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Blessed are you who hunger now, For you shall be filled. Blessed are you who weep now, For you shall laugh. ");
INSERT INTO engemtv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Blessed are you when men shall hate you, And when they shall exclude you, And shall revile you, and cast out your name as evil, Because of the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rejoice in that day and leap for joy! For behold, your reward is great in heaven; For in like manner their fathers did to the prophets. ");
INSERT INTO engemtv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","But woe to you who are rich, Because you have received your consolation. ");
INSERT INTO engemtv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Woe to you who have been filled, For you shall be hungry. Woe to you who laugh now, For you shall mourn and weep. ");
INSERT INTO engemtv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Woe to you when men speak well of you, For in like manner their fathers would do to the false prophets. ");
INSERT INTO engemtv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“But I say to you who hear: Love your enemies, do good to those who hate you, ");
INSERT INTO engemtv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bless those who curse you; pray for those who mistreat you. ");
INSERT INTO engemtv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","To him who strikes you on the one cheek, offer the other also. And from him who takes your outer garment, do not forbid the tunic either. ");
INSERT INTO engemtv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Give to everyone who asks of you. And from him who takes away your belongings, do not ask for them back. ");
INSERT INTO engemtv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","And just as you want men to do to you, you also do to them likewise. ");
INSERT INTO engemtv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“But if you love those who love you, what credit is that to you? For even sinners love those who love them. ");
INSERT INTO engemtv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","And if you do good to those who do good to you, what credit is that to you? For even sinners do the same. ");
INSERT INTO engemtv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","And if you lend to those from whom you hope to receive it back, what credit is that to you? For even sinners lend to sinners, so that they may receive the same amount back. ");
INSERT INTO engemtv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","But love your enemies, and do good, and lend, hoping to receive nothing back; and your reward shall be great, and you will be sons of the Most High. For He is kind to the unthankful and evil. ");
INSERT INTO engemtv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Therefore be compassionate, just as your Father also is compassionate. ");
INSERT INTO engemtv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“And do not judge, and you shall not be judged. Do not condemn, and you shall not be condemned. Forgive, and you shall be forgiven. ");
INSERT INTO engemtv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Give, and it shall be given to you: good measure, pressed down and shaken and running over they shall give into your bosom. For with the same measure that you use, it shall be measured back to you.” ");
INSERT INTO engemtv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","And He spoke a parable to them: “Can the blind lead the blind? Will they not both fall into a pit? ");
INSERT INTO engemtv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A disciple is not above his teacher, but everyone, having been fully trained, will be like his teacher. ");
INSERT INTO engemtv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","And why do you look at the speck in your brother's eye, but do not notice the plank in your own eye? ");
INSERT INTO engemtv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Or how can you say to your brother, ‘Brother, permit me to remove the speck which is in your eye,’ when you yourself do not see the plank that is in your own eye? Hypocrite! First remove the plank out of your own eye, and then you will see clearly to remove the speck which is in your brother's eye. ");
INSERT INTO engemtv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“For a good tree does not produce corrupt fruit, nor does a corrupt tree produce good fruit. ");
INSERT INTO engemtv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","For each tree is known by its own fruit. For men do not gather figs from thorns, nor do they gather grapes from a thorn bush. ");
INSERT INTO engemtv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A good man out of the good treasure of his heart brings forth that which is good; and an evil man out of the evil treasure of his heart brings forth that which is evil. For out of the abundance of the heart his mouth speaks. ");
INSERT INTO engemtv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“But why do you call Me ‘Lord, Lord,’ and do not do the things which I say? ");
INSERT INTO engemtv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Everyone who comes to Me, and hears My words and does them, I will show you to whom he is like: ");
INSERT INTO engemtv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","He is like a man building a house, who dug and went deep and laid a foundation on the rock. And when a flood came, the stream burst upon that house, and could not shake it, for it was founded on the rock. ");
INSERT INTO engemtv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","But he who hears and does not do is like a man building a house on the ground without a foundation, against which the stream burst upon; and immediately it fell. And the destruction of that house was great.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Now when He finished all His sayings in the hearing of the people, He entered Capernaum. ");
INSERT INTO engemtv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","And a certain centurion's servant, who was highly valued by him, was sick and about to die. ");
INSERT INTO engemtv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","And when he heard about Jesus, he sent elders of the Jews to Him, asking Him that He might come and heal his servant. ");
INSERT INTO engemtv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","And when they came to Jesus, they begged Him earnestly, saying, “He is worthy for whom He should grant this, ");
INSERT INTO engemtv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","for he loves our nation, and he himself has built us a synagogue.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Then Jesus went with them. And when He was already not far away from the house, the centurion sent friends to Him, saying to Him, “Lord, do not trouble Yourself, for I am not worthy that You should enter under my roof. ");
INSERT INTO engemtv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Therefore I did not even consider myself worthy to come to You. But just say the word, and my servant shall be healed. ");
INSERT INTO engemtv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","For I also am a man appointed under authority, having soldiers under me. And I say to one, ‘Go,’ and he goes; and to another, ‘Come,’ and he comes; and to my servant, ‘Do this,’ and he does it.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","When Jesus heard these things, He marveled at him, and turning to the crowd following Him, He said, “I say to you, I have not found such great faith, not even in Israel!” ");
INSERT INTO engemtv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","And when those who were sent returned to the house, they found the servant well who had been sick. ");
INSERT INTO engemtv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Now it happened on the next day, that He went into a city called Nain; and many of His disciples went with Him, and a great crowd. ");
INSERT INTO engemtv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","And when He came near the gate of the city, that behold, a dead man was being carried out, the only son of his mother; and she was a widow. And many people from the city was with her. ");
INSERT INTO engemtv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","When the Lord saw her, He had compassion on her and said to her, “Do not weep.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Then He came and touched the open coffin, and those who carried him stood still. And He said, “Young man, I say to you, arise.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","So he who was dead sat up and began to speak. And He gave him to his mother. ");
INSERT INTO engemtv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Then fear took hold of all, and they were glorifying God, saying, “A great prophet has risen up among us”; and, “God has visited His people.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","And this report about Him went out in all Judea, and all the surrounding region. ");
INSERT INTO engemtv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Then the disciples of John reported to him concerning all these things. ");
INSERT INTO engemtv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","And summoning two of his disciples, John sent them to Jesus, saying, “Are You the Coming One, or do we look for another?” ");
INSERT INTO engemtv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","And when they came to Him, the men said, “John the Baptist has sent us to You, saying, ‘Are You the Coming One, or do we look for another?’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","And in that very hour He healed many from diseases, and torments, and evil spirits; and to many blind people He granted sight. ");
INSERT INTO engemtv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Then Jesus answered and said to them, “Go and report to John what you have seen and heard: that the blind regain sight, the lame walk, the lepers are cleansed, the deaf hear, the dead are raised, the poor have the gospel preached to them. ");
INSERT INTO engemtv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","And blessed is he who is not offended because of Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Now when John's messengers had departed, He began to speak to the crowds concerning John: “What have you gone out into the wilderness to see? A reed shaken by the wind? ");
INSERT INTO engemtv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","But what have you gone out to see? A man clothed in soft garments? Indeed those who are gorgeously appareled and live in luxury are in royal palaces. ");
INSERT INTO engemtv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","But what have you gone out to see? A prophet? Yes, I say to you, and much more than a prophet. ");
INSERT INTO engemtv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","This is he about whom it is written: ‘Behold, I send My messenger before Your face, who will prepare Your way before You.’ ");
INSERT INTO engemtv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","For I say to you, among those born of women there is not a greater prophet than John the Baptist; but he who is least in the kingdom of God is greater than he.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","And when all the people heard Him, even the tax collectors justified God, having been baptized with the baptism of John. ");
INSERT INTO engemtv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","But the Pharisees and lawyers rejected the counsel of God for themselves, because they had not been baptized by him. ");
INSERT INTO engemtv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Therefore to what shall I compare the men of this generation, and what are they like? ");
INSERT INTO engemtv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","They are like children sitting in the marketplace and calling to one another, saying: ‘We played the flute for you, and you did not dance; We mourned for you, and you did not weep.’ ");
INSERT INTO engemtv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","For John the Baptist has come neither eating bread nor drinking wine, and you say, ‘He has a demon.’ ");
INSERT INTO engemtv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","The Son of Man has come eating and drinking, and you say, ‘Look, a glutton and a drunkard, a friend of tax collectors and sinners!’ ");
INSERT INTO engemtv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","And so wisdom is justified by all her children.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Then one of the Pharisees asked Him to eat with him. And entering into the Pharisee's house, He reclined to eat. ");
INSERT INTO engemtv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","And behold, a woman in the city who was a sinner, when she found out that He was reclining in the Pharisee's house, brought an alabaster flask of perfume, ");
INSERT INTO engemtv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","and standing by His feet behind Him weeping; she began to wash His feet with her tears, and was wiping them with the hair of her head; and she was kissing His feet and anointing them with the perfume. ");
INSERT INTO engemtv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Now when the Pharisee who had invited Him saw this, he spoke within himself, saying, “This Man, if He were a prophet, would know who and what sort of woman this is who touches Him, for she is a sinner.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","And Jesus answered and said to him, “Simon, I have something to say to you.” And he said, “Teacher, say it.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“There was a certain creditor who had two debtors. One owed five hundred denarii, and the other owed fifty. ");
INSERT INTO engemtv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","And when they had nothing with which to pay back, he freely forgave them both. Tell Me, therefore, which of them will love him more?” ");
INSERT INTO engemtv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon answered and said, “I suppose it is the one to whom he forgave more.” And He said to him, “You have judged correctly.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","And turning to the woman, He said to Simon, “Do you see this woman? I entered into your house; you gave Me no water for My feet, but this woman has washed My feet with her tears and wiped them with the hair of her head. ");
INSERT INTO engemtv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","You gave Me no kiss, but this woman has not stopped kissing My feet since the time I came in. ");
INSERT INTO engemtv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","You did not anoint My head with oil, but this woman has anointed My feet with perfume. ");
INSERT INTO engemtv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","For which reason I say to you, her many sins have been forgiven, because she loved much. But to whom little is forgiven, the same loves little.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Then He said to her, “Your sins are forgiven.” ");
INSERT INTO engemtv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","And those who were reclining at the table with Him began to say within themselves, “Who is this who even forgives sins?” ");
INSERT INTO engemtv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Then He said to the woman, “Your faith has saved you. Go in peace.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Now it came to pass afterward, that He was traveling through every city and village, preaching and proclaiming the gospel of the kingdom of God, and the twelve were with Him, ");
INSERT INTO engemtv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","and certain women who had been healed of evil spirits and infirmities; Mary called Magdalene, from whom seven demons had gone out, ");
INSERT INTO engemtv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","and Joanna the wife of Chuza, a supervisor of Herod, and Susanna, and many others who were ministering to them from their belongings. ");
INSERT INTO engemtv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","And when a large crowd had gathered, and the people came to Him from every city, He spoke by a parable: ");
INSERT INTO engemtv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“The sower went out to sow his seed. And as he sowed, some fell alongside the road; and it was trampled down, and the birds of the air devoured it. ");
INSERT INTO engemtv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","And other seed fell on rock; and when it grew up, it withered away because it had no moisture. ");
INSERT INTO engemtv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","And other seed fell among thorns, and when the thorns grew up with it, they choked it. ");
INSERT INTO engemtv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","But other seed fell into good ground, and when it grew up, it produced fruit a hundredfold.” Saying these things He was calling out, “He who has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Then His disciples asked Him, saying, “What does this parable mean?” ");
INSERT INTO engemtv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","And He said, “To you it has been given to know the mysteries of the kingdom of God, but to the rest they are in parables, that ‘Seeing they may not see, And hearing they may not understand.’ ");
INSERT INTO engemtv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Now this is the parable: The seed is the word of God. ");
INSERT INTO engemtv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","And those beside the road are they that hear; then the devil comes and takes away the word from their hearts, lest they believe and be saved. ");
INSERT INTO engemtv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","But those on the rock are they that, whenever they hear, receive the word with joy; and these have no root, who believe for a while and in time of testing fall away. ");
INSERT INTO engemtv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","And that which fell among thorns, these are those, who when they have heard, go out and are choked with anxieties, riches, and pleasures of this life, and bring no fruit to maturity. ");
INSERT INTO engemtv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","But that which fell on the good ground, these are such who when they heard the word, with a noble and good heart, hold on to it and bear fruit with endurance. ");
INSERT INTO engemtv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“No one, when he has lit a lamp, covers it with a vessel or puts it under a bed, but sets it on a lampstand, so that those who enter may see the light. ");
INSERT INTO engemtv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","For there is nothing hidden which will not become manifest, nor anything concealed which will not be known and come to light. ");
INSERT INTO engemtv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Therefore take heed how you hear. For whoever has, more shall be given to him; and whoever does not have, even what he thinks he has shall be taken away from him.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Then His mother and brothers came to Him, and could not approach Him because of the crowd. ");
INSERT INTO engemtv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","And it was told Him by some, who said, “Your mother and Your brothers are standing outside, desiring to see You.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","But He answered and said to them, “My mother and My brothers are these who hear the word of God and do it.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Now it came to pass on a certain day, that He got into a boat with His disciples. And He said to them, “Let us go across to the other side of the lake.” And they put out to sea. ");
INSERT INTO engemtv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","But as they sailed, He fell asleep. And a windstorm came down onto the lake, and they were being filled with water, and were in danger. ");
INSERT INTO engemtv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","And they came to Him and awoke Him, saying, “Master, Master, we are perishing!” Then He arose and rebuked the wind and the raging of the water. And they ceased, and there was a calm. ");
INSERT INTO engemtv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","But He said to them, “Where is your faith?” But becoming afraid, they marveled, saying to one another, “Who then is this? For He commands even the winds and the water, and they obey Him!” ");
INSERT INTO engemtv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Then they sailed to the region of the Gadarenes, which is opposite Galilee. ");
INSERT INTO engemtv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","And when He got out on the land, there met Him a certain man from the city who had demons for a long time. And he wore no clothes, nor did he live in a house, but among the tombs. ");
INSERT INTO engemtv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","And seeing Jesus and crying out, he fell down before Him, and with a loud voice he said, “What have I to do with You, Jesus, Son of the Most High God? I beg You, do not torment me!” ");
INSERT INTO engemtv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","For He had commanded the unclean spirit to come out from the man. For it had seized him at times, and he was bound, kept under guard, with chains and shackles; and he broke the bonds and was driven by the demon into the wilderness. ");
INSERT INTO engemtv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus asked him, saying, “What is your name?” And he said, “Legion,” because many demons had entered into him. ");
INSERT INTO engemtv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","And he kept imploring Him that He would not command them to go out into the abyss. ");
INSERT INTO engemtv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Now there was a herd of many swine feeding there on the mountain. And they kept imploring Him that He would permit them to enter them. And He permitted them. ");
INSERT INTO engemtv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Then when the demons came out from the man, they entered into the swine, and the herd ran violently down the steep bank into the lake and drowned. ");
INSERT INTO engemtv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","And when those who fed them saw what had happened, they fled and reported it in the city and in the country. ");
INSERT INTO engemtv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Then they went out to see what had happened, and they came to Jesus, and found the man from whom the demons had come out of, sitting at the feet of Jesus, clothed and being of sound mind. And they were afraid. ");
INSERT INTO engemtv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","And those also who saw reported to them how the demon-possessed man was healed. ");
INSERT INTO engemtv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Then the whole multitude from the surrounding region of the Gadarenes asked Him to go away from them, because they were gripped with great fear. And He got into the boat and returned. ");
INSERT INTO engemtv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Now the man from whom the demons had come out was begging Him that he might be with Him. But Jesus sent him away, saying, ");
INSERT INTO engemtv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Return to your house, and tell what great things God has done for you.” And he departed, proclaiming throughout the whole city all the things that Jesus did for him. ");
INSERT INTO engemtv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","So it was, when Jesus returned, that the crowd welcomed Him, for they were all waiting for Him. ");
INSERT INTO engemtv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","And behold, there came a man named Jairus, and he was a leader of the synagogue. And falling at the feet of Jesus, he was imploring Him to enter into his house, ");
INSERT INTO engemtv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","for he had an only daughter about twelve years of age, and she was dying. But as He was going, the crowds were pressing against Him. ");
INSERT INTO engemtv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Now a woman, having a flow of blood for twelve years, who though she had spent her whole livelihood on physicians, was not able to be healed by anyone, ");
INSERT INTO engemtv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","approaching from behind, touched the hem of His garment. And immediately her flow of blood stopped. ");
INSERT INTO engemtv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","And Jesus said, “Who touched Me?” When all denied it, Peter and those with him said, “Master, the crowds are pressing You hard and crowding You, and You say, ‘Who touched Me?’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","But Jesus said, “Someone touched Me, for I perceived that power has gone out from Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Now when the woman saw that she was not hidden, she came trembling; and falling down before Him, she recounted to Him before all the people the reason why she had touched Him and how she was healed immediately. ");
INSERT INTO engemtv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","And He said to her, “Take courage, daughter, your faith has healed you. Go in peace.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","While He was still speaking, someone came from the ruler of the synagogue's house, saying to him, “Your daughter has died. Do not trouble the Teacher.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","But when Jesus heard it, He answered him, saying, “Do not be afraid; only believe, and she will be healed.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","When He came into the house, He permitted no one to enter except Peter, John, and James, and the father and mother of the child. ");
INSERT INTO engemtv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Now all were weeping and mourning for her; but He said, “Do not weep; she is not dead, but asleep.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","And they were ridiculing Him, knowing that she had died. ");
INSERT INTO engemtv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","But He sent them all outside, and having grasped her hand, He called, saying, “Child, arise.” ");
INSERT INTO engemtv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Then her spirit returned, and she arose immediately. And He commanded something to be given to her to eat. ");
INSERT INTO engemtv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","And her parents were amazed, but He charged them to tell no one what had happened. ");
INSERT INTO engemtv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","And having called together the twelve, He gave them power and authority over all demons, and to heal diseases. ");
INSERT INTO engemtv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","And He sent them to preach the kingdom of God and to heal the sick. ");
INSERT INTO engemtv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","And He said to them, “Take nothing for the journey, neither staffs nor knapsack nor bread nor silver; and do not have two tunics apiece. ");
INSERT INTO engemtv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Whatever house you may enter, stay there, and from there go out. ");
INSERT INTO engemtv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","And as many as will not receive you, when you go out from that city, shake off the very dust from your feet as a testimony against them.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","As they went out, they were going about village by village, preaching the gospel and healing everywhere. ");
INSERT INTO engemtv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Now Herod the tetrarch heard of all the things being done by Him; and he was perplexed, because it was said by some that John had risen from the dead, ");
INSERT INTO engemtv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","and by others that Elijah had appeared, and by others that one of the ancient prophets had arisen. ");
INSERT INTO engemtv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","And Herod said, “John I have beheaded, but who is this about whom I hear such things?” And he was seeking to see Him. ");
INSERT INTO engemtv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","And the apostles, when they had returned, recounted to Him all that they had done. And taking them along, He withdrew privately into a deserted place belonging to the city called Bethsaida. ");
INSERT INTO engemtv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","But when the crowds found out, they followed Him; and He welcomed them, and was speaking to them about the kingdom of God, and He cured those who needed healing. ");
INSERT INTO engemtv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Now when the day began to decline, the twelve came and said to Him, “Dismiss the crowd, so that they may go into the surrounding villages and farms, and they may find lodging and find provisions; for we are in a deserted place here.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","But He said to them, “You give them something to eat.” And they said, “We have no more than five loaves of bread and two fish, unless we go and buy food for all these people.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","For there were about five thousand men. And He said to His disciples, “Make them recline in groups of fifty.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","And they did so, and made them all recline. ");
INSERT INTO engemtv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","And taking the five loaves and the two fish, and looking up to heaven, He blessed and broke them, and gave them to the disciples to set before the crowd. ");
INSERT INTO engemtv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","So they all ate and were satisfied, and twelve baskets of the remaining fragments were taken up by them. ");
INSERT INTO engemtv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","And it came to pass, while He was alone praying, that His disciples joined Him, and He questioned them, saying, “Who do the crowds pronounce Me to be?” ");
INSERT INTO engemtv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","So they answered and said, “John the Baptist, but some say Elijah; and others say that one of the ancient prophets has arisen.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","He said to them, “But who do you pronounce Me to be?” Peter answered and said, “The Christ of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","And He strictly warned and commanded them to tell this to no one, ");
INSERT INTO engemtv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","saying, “The Son of Man must suffer many things, and be rejected by the elders and chief priests and scribes, and to be killed, and to be raised on the third day.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Then He said to them all, “If anyone desires to come after Me, let him deny himself, and take up his cross, and follow Me. ");
INSERT INTO engemtv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","For whoever desires to save his life shall lose it, but whoever loses his life for My sake shall save it. ");
INSERT INTO engemtv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","For what is a man profited if he gains the whole world, and is himself destroyed or lost? ");
INSERT INTO engemtv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","For whoever is ashamed of Me and My words, of him the Son of Man will be ashamed when He comes in His own glory, and in His Father's, and of the holy angels. ");
INSERT INTO engemtv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","But I tell you truly, there are some standing here who will by no means taste death until they see the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Now it came to pass, about eight days after these words, that He took Peter, John, and James and went up on the mountain to pray. ");
INSERT INTO engemtv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","And while He was praying, the appearance of His face became different, and His clothing became white and glistening. ");
INSERT INTO engemtv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","And behold, two men were talking with Him, who were Moses and Elijah, ");
INSERT INTO engemtv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","who appearing in glory were talking about His decease which He was about to accomplish in Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","But Peter and those with him were heavy with sleep; but becoming fully awake, they saw His glory and the two men who stood with Him. ");
INSERT INTO engemtv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","And it happened, as they were parting from Him, that Peter said to Jesus, “Master, it is good for us to be here; and let us make three tents: one for You, one for Moses, and one for Elijah,” not knowing what he was saying. ");
INSERT INTO engemtv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Now as he said these things, a cloud appeared and overshadowed them; and they were afraid as they entered into the cloud. ");
INSERT INTO engemtv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","And a voice came out of the cloud, saying, “This is My beloved Son. Listen to Him!” ");
INSERT INTO engemtv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","When the voice had ceased, Jesus was found alone. But they kept silent, and reported to no one in those days any of the things they had seen. ");
INSERT INTO engemtv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Now it happened on the next day, when they came down from the mountain, that a great crowd met Him. ");
INSERT INTO engemtv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","And behold, a man from the crowd cried out, saying, “Teacher, I beg You, look upon my son, for he is my only child. ");
INSERT INTO engemtv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","And behold, a spirit seizes him, and he suddenly cries out, and it convulses him so that he foams at the mouth, and it departs from him with great difficulty, bruising him. ");
INSERT INTO engemtv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","So I begged Your disciples that they might cast it out, but they could not.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Then Jesus answered and said, “O faithless and perverted generation, how long shall I be with you and bear with you? Bring your son here.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","And as he was still coming, the demon threw him down and convulsed him. Then Jesus rebuked the unclean spirit, and healed the child, and gave him back to his father. ");
INSERT INTO engemtv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","And they were all amazed at the majesty of God. But while everyone marveled at all the things which Jesus did, He said to His disciples, ");
INSERT INTO engemtv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Let these words sink down into your ears, for the Son of Man is about to be betrayed into the hands of men.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","But they did not understand this saying, and it was concealed from them so that they did not perceive it; and they were afraid to ask Him about this saying. ");
INSERT INTO engemtv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Then a dispute came up among them as to which of them might be the greatest. ");
INSERT INTO engemtv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","But Jesus, having seen the thought of their heart, taking a little child, He stood him beside Himself, ");
INSERT INTO engemtv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","and said to them, “Whoever receives this little child in My name receives Me; and whoever receives Me receives Him who sent Me. For he who is least among you all shall be great.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Now John answered and said, “Master, we saw someone casting out demons in Your name, and we forbade him because he does not follow with us.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","But Jesus said to him, “Do not forbid him, for he who is not against us is for us.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Now it came to pass, when the time had come for Him to be received up, that He steadfastly set His face to go to Jerusalem, ");
INSERT INTO engemtv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","and sent messengers before His face. And as they went, they entered a village of the Samaritans, so they might prepare for Him. ");
INSERT INTO engemtv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","But they did not receive Him, because He was determined to go to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","And when they saw this, James and John His disciples said, “Lord, do You wish that we should call down fire from heaven and consume them, as Elijah did?” ");
INSERT INTO engemtv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","But turning, He rebuked them, and said, “You do not know of what sort of spirit you are. ");
INSERT INTO engemtv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","For the Son of Man did not come to destroy men's lives but to save them.” And they went to another village. ");
INSERT INTO engemtv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Now it happened as they journeyed on the road, that someone said to Him, “Lord, I will follow You wherever You go.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","And Jesus said to him, “Foxes have holes and birds of the air have nests, but the Son of Man has nowhere to lay His head.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Then He said to another, “Follow Me.” But he said, “Lord, permit me first to go and bury my father.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus said to him, “Leave the dead to bury their own dead, but you go and proclaim the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","And another also said, “Lord, I will follow You, but first permit me to say farewell to those who are at my house.” ");
INSERT INTO engemtv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","But Jesus said to him, “No one, having put his hand to the plow, and looking back, is fit for the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Now after these things the Lord appointed seventy others also, and He sent them two by two before His face into every city and place where He Himself was about to come. ");
INSERT INTO engemtv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Then He said to them, “The harvest indeed is great, but the workers are few; therefore pray to the Lord of the harvest that He may send forth workers into His harvest. ");
INSERT INTO engemtv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Go; behold, I send you out as lambs in the midst of wolves. ");
INSERT INTO engemtv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Do not carry a money bag, nor a knapsack, nor sandals; and greet no one along the road. ");
INSERT INTO engemtv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","But whatever house you enter, first say, ‘Peace to this house.’ ");
INSERT INTO engemtv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","And if a son of peace is there, your peace will rest upon it; if not, it will return to you. ");
INSERT INTO engemtv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","And remain in that very house, eating and drinking what they have, for the worker is worthy of his wages. Do not move from house to house. ");
INSERT INTO engemtv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","And into which ever city you enter, and they receive you, eat what is set before you. ");
INSERT INTO engemtv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","And heal the sick there, and say to them, ‘The kingdom of God has drawn near to you.’ ");
INSERT INTO engemtv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","But whatever city you enter, and they do not receive you, go out into its streets and say, ");
INSERT INTO engemtv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘The very dust from your city which clings to us we wipe off against you. Nevertheless know this, that the kingdom of God has drawn near to you.’ ");
INSERT INTO engemtv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I say to you that it will be more tolerable in that Day for Sodom than for that city. ");
INSERT INTO engemtv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Woe to you, Chorazin! Woe to you, Bethsaida! Because if the miracles which were done in you had been done in Tyre and Sidon, they would have repented long ago, sitting in sackcloth and ashes. ");
INSERT INTO engemtv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nevertheless it will be more tolerable for Tyre and Sidon in the judgment than for you. ");
INSERT INTO engemtv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","And you, Capernaum, who are exalted to heaven, will be brought down to Hades. ");
INSERT INTO engemtv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","He who hears you hears Me, he who rejects you rejects Me, and he who rejects Me rejects Him who sent Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Then the seventy returned with joy, saying, “Lord, even the demons are subject to us in Your name.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","And He said to them, “I saw Satan having fallen like lightning out of heaven. ");
INSERT INTO engemtv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Behold, I give you the authority to trample on serpents and scorpions, and over all the power of the enemy, and nothing shall by any means hurt you. ");
INSERT INTO engemtv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nevertheless do not rejoice in this, that the spirits are subject to you, but rejoice because your names have been written in heaven.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","In that hour Jesus rejoiced in the Spirit and said, “I praise You, Father, Lord of heaven and earth, that You have hidden these things from the wise and intelligent, and have revealed them to babes. Yes, Father, for so it seemed good in Your sight.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","And turning to His disciples He said, “All things have been delivered to Me by My Father, and no one knows who the Son is except the Father, and who the Father is except the Son, and the one to whom the Son wills to reveal Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","And turning to His disciples He said privately, “Blessed are the eyes which see what you see; ");
INSERT INTO engemtv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","for I tell you that many prophets and kings have desired to see what you see, and they did not see it, and to hear what you hear, and they did not hear it.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","And behold, a certain lawyer stood up and tested Him, saying, “Teacher, what shall I do to inherit eternal life?” ");
INSERT INTO engemtv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","He said to him, “What is written in the law? How do you read it?” ");
INSERT INTO engemtv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","So he answered and said, “ ‘You shall love the Lord your God with all your heart, with all your soul, with all your strength, and with all your mind,’ and ‘your neighbor as yourself.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","And He said to him, “You have answered correctly; do this and you shall live.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","But he, wanting to justify himself, said to Jesus, “And who is my neighbor?” ");
INSERT INTO engemtv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Then Jesus answered and said: “A certain man was going down from Jerusalem to Jericho, and encountered bandits, who after having stripped him of his clothing and having wounded him, departed, leaving him half dead. ");
INSERT INTO engemtv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Now by coincidence a certain priest was coming down that road. And when he saw him, he passed by on the opposite side. ");
INSERT INTO engemtv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Likewise a Levite, arriving at the place, came and saw, and passed by on the opposite side. ");
INSERT INTO engemtv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","But a certain Samaritan, as he traveled, came by him; and when he saw him, he was moved with compassion. ");
INSERT INTO engemtv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","And coming to him, he bandaged his wounds, pouring on oil and wine; and putting him on his own animal, he brought him to an inn, and took care of him. ");
INSERT INTO engemtv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","On the next day, when he departed, he took out two denarii, and gave them to the innkeeper, and said to him, ‘Take care of him; and whatever you spend in addition, when I come back, I will repay you.’ ");
INSERT INTO engemtv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","So which of these three does it seem to you proved to be a neighbor to the man who fell among the bandits?” ");
INSERT INTO engemtv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","And he said, “the one who showed mercy to him.” Then Jesus said to him, “Go and do likewise.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Now it came to pass as they traveled, that He entered into a certain village; and a certain woman named Martha welcomed Him into her house. ");
INSERT INTO engemtv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","And the woman had a sister called Mary, who also sat at Jesus' feet and was listening to His word. ");
INSERT INTO engemtv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","But Martha was distracted with much serving, and she approached Him and said, “Lord, don't You care that my sister has left me to serve alone? Therefore tell her to help me.” ");
INSERT INTO engemtv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","And Jesus answered and said to her, “Martha, Martha, you are worried and troubled about many things. ");
INSERT INTO engemtv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","But one thing is needed, and Mary has chosen that good part, which shall not be taken away from her.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Now it came to pass, as He was praying in a certain place, when He ceased, that one of His disciples said to Him, “Lord, teach us to pray, just as John also taught his disciples.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","So He said to them, “Whenever you pray, say: Our Father in the heavens, Hallowed be Your name. Your kingdom come. Your will be done, On earth as it is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Give us day by day our daily bread. ");
INSERT INTO engemtv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","And forgive us our sins, For we also forgive everyone who is indebted to us. And lead us not into temptation, But deliver us from the evil one.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","And He said to them, “Which of you shall have a friend, and go to him at midnight and say to him, ‘Friend, lend me three loaves; ");
INSERT INTO engemtv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","for a friend has come to me on his journey, and I have nothing to set before him’; ");
INSERT INTO engemtv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","and he will answer from within and say, ‘Do not trouble me; the door has already been shut, and my children are with me in bed; I cannot get up and give to you’? ");
INSERT INTO engemtv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I say to you, even if he will not get up and give to him, because he is his friend, yet on account of his persistence he will get up and give him as much as he needs. ");
INSERT INTO engemtv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“So I say to you, ask, and it shall be given to you; seek, and you shall find; knock, and it shall be opened to you. ");
INSERT INTO engemtv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","For everyone who asks receives, and he who seeks finds, and to him who knocks it will be opened. ");
INSERT INTO engemtv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","And which father among you, if his son asks for bread, will he give him a stone? Or if he asks for a fish, will he give him a serpent instead of a fish? ");
INSERT INTO engemtv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Or if he asks for an egg, will he give him a scorpion? ");
INSERT INTO engemtv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","If you then, being evil, know how to give good gifts to your children, by how much more will your heavenly Father give the Holy Spirit to those who ask Him!” ");
INSERT INTO engemtv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","And He was casting out a demon, and it was mute. So it was, when the demon came out, that the mute man spoke; and the crowds marveled. ");
INSERT INTO engemtv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","But some of them said, “He casts out demons by Beelzebub, the ruler of the demons.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","But others, testing Him, were seeking from Him a sign from heaven. ");
INSERT INTO engemtv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","But He, knowing their thoughts, said to them: “Every kingdom divided against itself is made desolate, and a house divided against a house falls. ");
INSERT INTO engemtv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","And if Satan also is divided against himself, how will his kingdom stand? Because you say that I cast out demons by Beelzebub. ");
INSERT INTO engemtv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","And if I cast out demons by Beelzebub, by whom do your sons cast them out? Therefore they will be your judges. ");
INSERT INTO engemtv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","But if I cast out demons by the finger of God, then the kingdom of God has come upon you. ");
INSERT INTO engemtv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","When a strong man, fully armed, guards his own palace, his possessions are in peace. ");
INSERT INTO engemtv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","But when someone stronger than he comes upon him, he overcomes him, and he takes away his full armor in which he had trusted, and distributes his spoils. ");
INSERT INTO engemtv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","He who is not with Me is against Me, and he who does not gather with Me scatters. ");
INSERT INTO engemtv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“When an unclean spirit goes out of a man, he goes through dry places, seeking rest; and not finding any, he says, ‘I will return to my house from where I came out.’ ");
INSERT INTO engemtv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","And coming, he finds it swept and adorned. ");
INSERT INTO engemtv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Then he goes and takes along seven other spirits more wicked than himself, and they come and dwell there; and the last state of that man is worse than the first.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","And it happened, while He spoke these things, that a certain woman from the crowd raised her voice and said to Him, “Blessed is the womb which bore You, and the breasts which nursed You!” ");
INSERT INTO engemtv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","But He said, “More than that, blessed are those who hear the word of God and keep it!” ");
INSERT INTO engemtv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Now as the crowds gathered even more, He began to say, “This generation is evil. It seeks a sign, and no sign will be given to it except the sign of Jonah the prophet. ");
INSERT INTO engemtv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","For just as Jonah became a sign to the Ninevites, so also the Son of Man will be to this generation. ");
INSERT INTO engemtv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","The queen of the South shall rise up in the judgment with the men of this generation and shall condemn them, because she came from the ends of the earth to hear the wisdom of Solomon; and indeed one greater than Solomon is here. ");
INSERT INTO engemtv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","The men of Nineveh shall stand up in the judgment with this generation and shall condemn it, because they repented at the preaching of Jonah; and indeed one greater than Jonah is here. ");
INSERT INTO engemtv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“No one, having lit a lamp, puts it in a secret place or under a basket, but on a lampstand, so that those who come in may see the light. ");
INSERT INTO engemtv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","The lamp of the body is the eye. Therefore, when your eye is clear, your whole body also is full of light. But when your eye is evil, your body also is dark. ");
INSERT INTO engemtv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Therefore take heed that the light which is in you is not darkness. ");
INSERT INTO engemtv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Therefore if your whole body is full of light, having no part dark, the whole body will be full of light, as when the bright shining of a lamp gives light to you.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","And as He spoke, a certain Pharisee asked that He would eat with him. And having entered, He reclined to eat. ");
INSERT INTO engemtv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","And when the Pharisee saw it, he marveled that He had not first washed before the meal. ");
INSERT INTO engemtv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","But the Lord said to him, “Now you Pharisees clean the outside of the cup and of the dish, but the inside of you is full of greed and evil. ");
INSERT INTO engemtv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fools! Did not He who made the outside also make the inside? ");
INSERT INTO engemtv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nevertheless give what is inside as alms; and see, all things are clean to you. ");
INSERT INTO engemtv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“But woe to you Pharisees! Because you pay a tithe of mint and rue and every vegetable, and you pass over justice and the love of God. These things you ought to have done, and not have neglected the others. ");
INSERT INTO engemtv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Woe to you Pharisees! Because you love the first seat in the synagogues and greetings in the marketplaces. ");
INSERT INTO engemtv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Woe to you, scribes and Pharisees, hypocrites! Because you are like unmarked graves, and the men walking over them do not know it.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Then one of the lawyers answered and said to Him, “Teacher, by saying these things You insult us also.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","And He said, “Woe to you lawyers as well! Because you load men with burdens hard to bear, and you yourselves do not touch the burdens with one of your fingers. ");
INSERT INTO engemtv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Woe to you! Because you build the tombs of the prophets, and your fathers killed them. ");
INSERT INTO engemtv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Consequently, you bear witness to and approve of the deeds of your fathers; because they indeed killed them, and you build their tombs. ");
INSERT INTO engemtv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","For this reason also the wisdom of God said, ‘I will send to them prophets and apostles, and some of them they will kill and persecute,’ ");
INSERT INTO engemtv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","so that the blood of all the prophets which was shed from the foundation of the world may be required of this generation, ");
INSERT INTO engemtv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","from the blood of Abel to the blood of Zechariah who perished between the altar and the temple. Yes, I say to you, it shall be required of this generation. ");
INSERT INTO engemtv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Woe to you lawyers! Because you have taken away the key of knowledge. You yourselves did not enter in, and those who were entering in you hindered.” ");
INSERT INTO engemtv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","And as He said these things to them, the scribes and the Pharisees began to be dreadfully hostile, and to cross-examine Him about many things, ");
INSERT INTO engemtv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","lying in wait for Him, and seeking to catch Him in something He might say, so that they might accuse Him. ");
INSERT INTO engemtv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Now in the meantime, as an innumerable crowd had gathered together so that they were stepping on one another, He began to say to His disciples first of all, “Beware of the leaven of the Pharisees, which is hypocrisy. ");
INSERT INTO engemtv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","For there is nothing covered that shall not be unveiled, and nothing secret that shall not be made known. ");
INSERT INTO engemtv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Therefore whatever you have spoken in the dark shall be heard in the light, and what you have spoken in the ear behind closed doors shall be proclaimed on the housetops. ");
INSERT INTO engemtv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“And I say to you, My friends, do not be afraid of those who kill the body, and after that have nothing further they can do. ");
INSERT INTO engemtv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","But I will show you whom you should fear: fear Him who after He kills, has authority to cast into hell; yes, I say to you, fear Him! ");
INSERT INTO engemtv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Are not five sparrows sold for two copper coins? And not one of them is forgotten before God. ");
INSERT INTO engemtv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","But the very hairs of your head have all been numbered. Do not fear therefore; you are of more value than many sparrows. ");
INSERT INTO engemtv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Also I say to you, whoever confesses Me before men, him the Son of Man also will confess before the angels of God. ");
INSERT INTO engemtv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","But he who denies Me before men will be denied before the angels of God. ");
INSERT INTO engemtv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“And anyone who speaks a word against the Son of Man, it will be forgiven him; but to him who blasphemes against the Holy Spirit, it will not be forgiven. ");
INSERT INTO engemtv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Now whenever they bring you to the synagogues and rulers and authorities, do not worry about how or what you should answer, or what you should say. ");
INSERT INTO engemtv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","For the Holy Spirit will teach you in that very hour what you must say.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Then someone from the crowd said to Him, “Teacher, tell my brother to divide the inheritance with me.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","But He said to him, “Man, who appointed Me a judge or an arbitrator over you?” ");
INSERT INTO engemtv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","And He said to them, “Take heed and beware of covetousness, for one's life does not consist in the abundance of his possessions.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Then He told a parable to them, saying: “The field of a certain rich man produced well. ");
INSERT INTO engemtv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","And he reasoned within himself, saying, ‘What shall I do, because I have nowhere to gather my crops?’ ");
INSERT INTO engemtv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","So he said, ‘I will do this: I will tear down my barns and I will build bigger ones, and there I will gather all my crops and my goods. ");
INSERT INTO engemtv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","And I will say to my soul, “Soul, you have many goods laid away for many years; relax; eat, drink, and be merry.” ’ ");
INSERT INTO engemtv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","But God said to him, ‘You fool! This night your soul will be required of you; then whose will those things be which you have prepared?’ ");
INSERT INTO engemtv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“So is he who accumulates treasure for himself, and is not rich toward God.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Then He said to His disciples, “Therefore I say to you, do not worry about your life, what you will eat; nor about the body, what you will wear. ");
INSERT INTO engemtv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Life is more than food, and the body is more than clothing. ");
INSERT INTO engemtv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Consider the ravens, for they neither sow nor reap, which have neither storeroom nor barn; and yet God feeds them. How much more are you worth than birds? ");
INSERT INTO engemtv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","And which of you by worrying can add one cubit to his stature? ");
INSERT INTO engemtv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Therefore if you cannot do a very little thing, why do you worry about the rest? ");
INSERT INTO engemtv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Consider the lilies, how they grow: they neither toil nor spin; and yet I say to you, not even Solomon in all his glory was arrayed like one of these. ");
INSERT INTO engemtv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","But if God so clothes the grass, although it is in the field today, and tomorrow is cast into the oven, by how much rather will He clothe you, O you of little faith? ");
INSERT INTO engemtv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“And do not seek what you may eat or what you may drink, and do not be anxious. ");
INSERT INTO engemtv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","For all these things the nations of the world seek after, but your Father knows that you need these things. ");
INSERT INTO engemtv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","But seek the kingdom of God, and all these things shall be added to you. ");
INSERT INTO engemtv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Do not fear, little flock, because your Father is well pleased to give to you the kingdom. ");
INSERT INTO engemtv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sell your possessions and give alms; make for yourselves money bags which do not grow old, an unfailing treasure in the heavens, where a thief does not come near, nor does a moth destroy. ");
INSERT INTO engemtv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","For where your treasure is, there your heart will be also. ");
INSERT INTO engemtv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Let your waist be girded and your lamps burning; ");
INSERT INTO engemtv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","and you yourselves be like men who wait for their master, when he will return from the wedding celebration, so that when he comes and knocks, immediately they may open to him. ");
INSERT INTO engemtv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blessed are those servants whom the master, when he comes, will find watching. Assuredly I say to you, that he will gird himself and have them recline to eat, and he will come and serve them. ");
INSERT INTO engemtv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","And if he comes in the second watch, or comes in the third watch, and find them so, blessed are those servants. ");
INSERT INTO engemtv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","But know this, that if the master of the house had known in what hour the thief was coming, he would have kept watch, and not allowed his house to be broken into. ");
INSERT INTO engemtv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Therefore you also be ready, for in an hour that you think not, the Son of Man comes.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Then Peter said to Him, “Lord, do You speak this parable only to us, or to all people?” ");
INSERT INTO engemtv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","And the Lord said, “Who then is a faithful and wise manager, whom his master will make ruler over his household, to give them their portion of food in due season? ");
INSERT INTO engemtv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blessed is that servant whom his master will find so doing when he comes. ");
INSERT INTO engemtv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Truly I say to you, that he will appoint him over all his possessions. ");
INSERT INTO engemtv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","But if that servant says in his heart, ‘My master is delaying his coming,’ and begins to beat the male and female servants, and to eat and drink and be drunk, ");
INSERT INTO engemtv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","the master of that servant will come on a day which he does not expect, and at an hour which he does not know, and he will cut him in two and appoint him his portion with the unbelievers. ");
INSERT INTO engemtv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","And that servant who knew his master's will, and did not get ready or do according to his will, shall be beaten with many blows. ");
INSERT INTO engemtv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","But he who did not know, yet did things worthy of blows, shall be beaten with few. For everyone to whom much is given, from him much will be required; and to whom much has been entrusted, of him they will ask much more. ");
INSERT INTO engemtv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“I have come to cast fire to the earth, and how I wish it were already kindled! ");
INSERT INTO engemtv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","But I have a baptism to be baptized with, and how distressed I am till it is completed! ");
INSERT INTO engemtv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Do you think that I came to give peace on earth? I tell you, not at all, but rather division. ");
INSERT INTO engemtv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","For from now on five in one house will be divided: three against two, and two against three. ");
INSERT INTO engemtv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Father will be divided against a son and a son against father, a mother against a daughter and a daughter against a mother, a mother-in-law against her daughter-in-law and daughter-in-law against her mother-in-law.” ");
INSERT INTO engemtv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Then He also said to the crowds, “Whenever you see a cloud rising from the west, immediately you say, ‘A rainstorm is coming’; and so it happens. ");
INSERT INTO engemtv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","And whenever you see the south wind blow, you say, ‘There will be hot weather’; and it happens. ");
INSERT INTO engemtv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hypocrites! You know how to discern the face of the earth and sky, but how is it you do not discern this time? ");
INSERT INTO engemtv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","And why do you not judge what is right, even of yourselves? ");
INSERT INTO engemtv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","When you go with your adversary to the magistrate, make an effort to make a settlement with him on the road, lest he drag you to the judge, and the judge deliver you to the bailiff, and the bailiff throw you into prison. ");
INSERT INTO engemtv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","I tell you, you shall by no means depart from there till you have paid the very last mite.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","And some people were present at that very time, reporting to Him about the Galileans whose blood Pilate had mixed with their sacrifices. ");
INSERT INTO engemtv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","And Jesus answered and said to them, “Do you think that these Galileans were worse sinners than all other Galileans, because they suffered such things? ");
INSERT INTO engemtv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Not at all, I tell you; but unless you repent you will all likewise perish. ");
INSERT INTO engemtv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Or those eighteen on whom the tower in Siloam fell and killed them, do you think that these were offenders more than all other men who dwelt in Jerusalem? ");
INSERT INTO engemtv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Not at all, I tell you; but unless you repent you will all likewise perish.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","He also spoke this parable: “A certain man had a fig tree planted in his vineyard, and he came looking for fruit on it and found none. ");
INSERT INTO engemtv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Then he said to the vinedresser, ‘Look, for three years I have come looking for fruit on this fig tree, and I haven't found any. Cut it down; why does it even waste the ground?’ ");
INSERT INTO engemtv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","But he answered and said to him, ‘Sir, let it alone this year also, until I dig around it and fertilize it. ");
INSERT INTO engemtv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","And if it produces fruit, fine. But if not, in the coming year, you can cut it down.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Now He was teaching in one of the synagogues on the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","And behold, there was a woman who had a spirit of infirmity eighteen years, and she was bent over and was not able to straighten herself up. ");
INSERT INTO engemtv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","And seeing her, Jesus called her to Him and said, “Woman, you are loosed from your infirmity.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","And He laid His hands on her, and immediately she was made straight, and was glorifying God. ");
INSERT INTO engemtv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","But the ruler of the synagogue answered with indignation, because Jesus had healed on the Sabbath, and he said to the crowd, “There are six days in which one should work; therefore come and be healed on them, and not on the Sabbath day.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","The Lord then answered him and said, “Hypocrites! Does not each one of you on the Sabbath loose his ox or donkey from the stall, and lead it away to water it? ");
INSERT INTO engemtv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","So ought not this woman, being a daughter of Abraham, whom Satan has bound these eighteen years, should she not be loosed from this bond on the Sabbath?” ");
INSERT INTO engemtv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","And when He said these things, all His adversaries were put to shame; and all the crowd was rejoicing over all the glorious things which were done by Him. ");
INSERT INTO engemtv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Then He said, “What is the kingdom of God like? And to what shall I compare it? ");
INSERT INTO engemtv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","It is like a mustard seed, which a man took and put in his garden; and it grew and became a large tree, and the birds of the air nested in its branches.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Again He said, “To what shall I compare the kingdom of God? ");
INSERT INTO engemtv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","It is like leaven, which a woman took and hid in three measures of meal until it was all leavened.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","And He was traveling through various cities and villages, teaching, and journeying toward Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Then one said to Him, “Lord, are there few who are saved?” And He said to them, ");
INSERT INTO engemtv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Strive to enter through the narrow gate, because many, I say to you, will seek to enter and will not be able. ");
INSERT INTO engemtv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","When once the Master of the house has risen up and shuts the door, and you begin to stand outside and to knock at the door, saying, ‘Lord, Lord, open for us,’ and answering He will say to you, ‘I do not know you, where you are from.’ ");
INSERT INTO engemtv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Then you will begin to say, ‘We ate and drank in Your presence, and You taught in our streets.’ ");
INSERT INTO engemtv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","But He will say, ‘I tell you I do not know you, where you are from. Depart from Me, all you workers of iniquity.’ ");
INSERT INTO engemtv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","There shall be weeping and gnashing of teeth, when you see Abraham and Isaac and Jacob and all the prophets in the kingdom of God, but yourselves being cast out. ");
INSERT INTO engemtv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","And they will come from the east and the west, and the north and the south, and will recline to eat in the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","And behold, there are last who shall be first, and there are first who shall be last.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","On that very day some Pharisees came, saying to Him, “Get out and go from here, for Herod wants to kill You.” ");
INSERT INTO engemtv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","And He said to them, “Go and say to that fox, ‘Behold, I cast out demons and perform cures today and tomorrow, and the third day I shall be perfected.’ ");
INSERT INTO engemtv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nevertheless I must journey today, tomorrow, and the next day; for it is not possible for a prophet to perish outside of Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, the one who kills the prophets and stones those who are sent to her! How often I wanted to gather your children together, like a hen gathers her chicks under her wings, but you were not willing! ");
INSERT INTO engemtv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","See! Your house is left to you desolate; and I say to you, you shall by no means see Me until the time comes when you say, ‘Blessed is He who comes in the name of the Lord!’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Now it came to pass, when He came into the house of one of the rulers of the Pharisees to eat bread on the Sabbath, that they were watching Him closely. ");
INSERT INTO engemtv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","And behold, there was a certain man before Him who had dropsy. ");
INSERT INTO engemtv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","And Jesus, answering, spoke to the lawyers and Pharisees, saying, “Is it lawful to heal on the Sabbath?” ");
INSERT INTO engemtv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","But they were silent. And taking hold of him, He healed him, and let him go. ");
INSERT INTO engemtv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Then He answered them, saying, “Which of you, having a son or an ox that has fallen into a pit, will not immediately pull him out on the Sabbath day?” ");
INSERT INTO engemtv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","And they were not able to answer Him regarding these things. ");
INSERT INTO engemtv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","So He told a parable to those who were invited, when He noted how they chose the places of honor, saying to them: ");
INSERT INTO engemtv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Whenever you are invited by someone to a wedding celebration, do not sit down in the place of honor, lest one more honorable than you be invited by him; ");
INSERT INTO engemtv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","and he who invited you and him shall come and say to you, ‘Give place to this man,’ and then you begin with shame to take the last place. ");
INSERT INTO engemtv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","But when you are invited, go and sit down in the last place, so that when he who invited you comes, he shall say to you, ‘Friend, go up higher.’ Then you will have glory in the presence of those who recline with you. ");
INSERT INTO engemtv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","For everyone who exalts himself shall be humbled, and he who humbles himself shall be exalted.” ");
INSERT INTO engemtv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Then He also said to him who invited Him, “When you give a dinner or a supper, do not call your friends, nor your brothers, nor your relatives, nor rich neighbors, lest they also invite you back, and you be repaid. ");
INSERT INTO engemtv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","But whenever you give a banquet, invite the poor, the crippled, the lame, the blind; ");
INSERT INTO engemtv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","and you will be blessed, because they do not have anything to repay you; for it will be repaid to you in the resurrection of the just.” ");
INSERT INTO engemtv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Now when one of those who sat at the table with Him heard these things, he said to Him, “Blessed is he who shall eat breakfast in the kingdom of God!” ");
INSERT INTO engemtv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Then He said to him, “A certain man gave a great banquet, and he invited many, ");
INSERT INTO engemtv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","and he sent his servant at supper time to say to those who were invited, ‘Come, for all things are now ready.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","But they all with one accord began to excuse themselves. The first said to him, ‘I bought a field, and I must go and see it. I ask you, have me excused.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","And another said, ‘I bought five yoke of oxen, and I am going to test them. I ask you, have me excused.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Still another said, ‘I have married a wife, therefore I cannot come.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","So that servant came and reported these things to his master. Then the master of the house, being angry, said to his servant, ‘Go out quickly into the streets and lanes of the city, and bring in here the poor and the maimed and the lame and the blind.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","And the servant said, ‘Master, it is done as you commanded, and still there is room.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Then the master said to the servant, ‘Go out into the roads and hedges, and compel them to come in, so that my house may be filled. ");
INSERT INTO engemtv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","For I say to you that none of those men who were invited shall taste of my supper.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Now great crowds were traveling with Him. And turning, He said to them, ");
INSERT INTO engemtv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“If anyone comes to Me and does not hate his father and mother, wife and children, brothers and sisters, yes, and his own life also, he cannot be My disciple. ");
INSERT INTO engemtv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","And whoever does not bear his cross and come after Me cannot be My disciple. ");
INSERT INTO engemtv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","For which of you, intending to build a tower, does not first sit down and count up the cost, whether he has the resources to complete it? ");
INSERT INTO engemtv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Lest perhaps after he has laid a foundation, and is not able to finish, all those who see it begin to mock him, ");
INSERT INTO engemtv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","saying, ‘This man began to build and was not able to finish.’ ");
INSERT INTO engemtv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Or what king, going to engage another king in battle, does not sit down first and consider whether he is able with ten thousand to meet him who comes against him with twenty thousand? ");
INSERT INTO engemtv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Otherwise, while the other is still far away, he sends a delegation and asks the terms for peace. ");
INSERT INTO engemtv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","So likewise, every one of you who does not renounce all his possessions cannot be My disciple. ");
INSERT INTO engemtv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Salt is good; but if the salt becomes tasteless, with what shall it be seasoned? ");
INSERT INTO engemtv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","It is neither fit for the land nor for the dunghill, but men cast it out. He who has ears to hear, let him hear!” ");
INSERT INTO engemtv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Now all the tax collectors and the sinners were drawing near to Him to hear Him. ");
INSERT INTO engemtv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","And the Pharisees and scribes were grumbling, saying, “This man receives sinners and eats with them.” ");
INSERT INTO engemtv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","And He told them this parable, saying, ");
INSERT INTO engemtv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“What man among you, having a hundred sheep, and loses one of them, does not leave behind the ninety-nine in the wilderness, and goes after the one which is lost until he finds it? ");
INSERT INTO engemtv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","And having found it, he puts it on his own shoulders, rejoicing. ");
INSERT INTO engemtv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","And coming into the house, he calls together his friends and neighbors, saying to them, ‘Rejoice with me, for I have found my sheep which was lost!’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","I say to you that likewise there shall be more joy in heaven over one sinner repenting than over ninety-nine righteous who need no repentance. ");
INSERT INTO engemtv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Or what woman, having ten silver coins, if she loses one coin, does not light a lamp and sweep the house, and search carefully until she finds it? ");
INSERT INTO engemtv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","And when she finds it, she calls her friends and neighbors together, saying, ‘Rejoice with me, for I have found the coin which I lost!’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Just so, I say to you, there is joy in the presence of the angels of God over one sinner who repents.” ");
INSERT INTO engemtv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Then He said: “A certain man had two sons. ");
INSERT INTO engemtv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","And the younger of them said to his father, ‘Father, give to me the share of the wealth which falls to me.’ So he divided to them his livelihood. ");
INSERT INTO engemtv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","And not many days after, having gathered together all things, the younger son went on a journey to a distant country, and there wasted his possessions with prodigal living. ");
INSERT INTO engemtv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","But when he had spent everything, there arose a severe famine throughout that country, and he began to be in need. ");
INSERT INTO engemtv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Then he went and joined himself to a citizen of that country, and he sent him into his fields to feed swine. ");
INSERT INTO engemtv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","And he was longing to fill his stomach with the carob pods which the swine were eating, and no one gave him anything. ");
INSERT INTO engemtv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“But having come to himself, he said, ‘How many of my father's hired servants have an abundance of bread, and I am perishing with hunger! ");
INSERT INTO engemtv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","I will arise and go to my father, and I will say to him, “Father, I have sinned against heaven and before you, ");
INSERT INTO engemtv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","and I am no longer worthy to be called your son. Make me like one of your hired servants.” ’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“And he arose and went to his father. But when he was still far off, his father saw him and was moved with compassion, and he ran and fell on his neck and kissed him. ");
INSERT INTO engemtv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","And the son said to him, ‘Father, I have sinned against heaven and before you, and am no longer worthy to be called your son.’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“But the father said to his servants, ‘Bring out the best robe and put it on him, and put a ring on his hand and sandals on his feet. ");
INSERT INTO engemtv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","And bring the fatted calf here and slaughter it, and let us eat and be merry; ");
INSERT INTO engemtv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","for this my son was dead and came to life, and he was lost and was found.’ And they began to be merry. ");
INSERT INTO engemtv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Now his older son was in the field. And as he came and drew near to the house, he heard music and dancing. ");
INSERT INTO engemtv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","And having summoned one of the servants, he was inquiring what these things might be. ");
INSERT INTO engemtv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","And he said to him, ‘Your brother has come, and because he has received him back in good health, your father has killed the fatted calf.’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“But he was angry and would not go in. Therefore his father came out and began to plead with him. ");
INSERT INTO engemtv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","So he answered and said to his father, ‘Lo, so many years I have been serving you and I never transgressed your commandment; and yet you never gave me a young goat, that I might make merry with my friends. ");
INSERT INTO engemtv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","But when this son of yours came, who has devoured your livelihood with prostitutes, you slaughtered the fatted calf for him.’ ");
INSERT INTO engemtv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“And he said to him, ‘Son, you are always with me, and all that I have is yours. ");
INSERT INTO engemtv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","But it was necessary to be merry and to rejoice, because your brother was dead and is alive again, and was lost and is found.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","He also said to His disciples: “There was a certain rich man who had a manager, and this manager was reported to him as squandering his possessions. ");
INSERT INTO engemtv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","And calling him, he said to him, ‘What is this I hear about you? Render an account of your management, for you can no longer be manager.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Then the manager said within himself, ‘What shall I do? For my master is taking the management away from me. I cannot dig; I am ashamed to beg. ");
INSERT INTO engemtv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","I know what I will do, so that whenever I am removed from the management, they will receive me into their houses.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“And having summoned each one of his master's debtors to him, he said to the first, ‘How much do you owe my master?’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","And he said, ‘A hundred baths of olive oil.’ So he said to him, ‘Take your bill, and sit down quickly and write fifty.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Then he said to another, ‘And how much do you owe?’ So he said, ‘A hundred measures of wheat.’ And he said to him, ‘Take your bill, and write eighty.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","So the master praised the unrighteous manager because he had dealt shrewdly. For the sons of this age are shrewder in their own generation than the sons of light. ");
INSERT INTO engemtv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“And I say to you, make friends for yourselves by the mammon of unrighteousness, so that whenever you fail, they may receive you into the eternal dwellings. ");
INSERT INTO engemtv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","He that is faithful in what is least is faithful also in much; and he that is unjust in what is least is also unjust in much. ");
INSERT INTO engemtv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Therefore if you were not faithful with the unrighteous mammon, who will entrust to you what is genuine? ");
INSERT INTO engemtv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","And if you were not faithful in what belongs to another, who will give to you what is yours? ");
INSERT INTO engemtv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“No servant can serve two masters, for either he will hate the one and love the other, or else he will be devoted to the one and despise the other. You cannot serve God and mammon.” ");
INSERT INTO engemtv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Now the Pharisees, who were lovers of money, were hearing all these things, and they were mocking Him. ");
INSERT INTO engemtv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","And He said to them, “You are those who justify yourselves before men, but God knows your hearts. Because that which is exalted among men is an abomination before God. ");
INSERT INTO engemtv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“The law and the prophets were until John. Since that time the kingdom of God has been preached, and everyone enters forcibly into it. ");
INSERT INTO engemtv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","And it is easier for heaven and earth to pass away than for one tittle of the law to fail. ");
INSERT INTO engemtv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Everyone who divorces his wife and marries another commits adultery; and everyone who marries a woman who is divorced from her husband commits adultery. ");
INSERT INTO engemtv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Now there was a certain rich man who was clothed in purple and fine linen, enjoying himself splendidly every day. ");
INSERT INTO engemtv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","But there was a certain beggar named Lazarus, covered with sores, who had been placed at his gate, ");
INSERT INTO engemtv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","and longing to be fed with the crumbs which fell from the rich man's table. And even the dogs came and would lick his sores. ");
INSERT INTO engemtv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","And it came to pass that the beggar died, and he was carried away by the angels to Abraham's bosom. The rich man also died and was buried. ");
INSERT INTO engemtv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","And being in torments in Hades, he lifted up his eyes and saw Abraham from afar, and Lazarus in his bosom. ");
INSERT INTO engemtv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Then he cried and said, ‘Father Abraham, have mercy on me, and send Lazarus so that he may dip the tip of his finger in water and cool my tongue; for I am suffering in this flame.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","But Abraham said, ‘Son, remember that in your lifetime you received your good things, and likewise Lazarus bad things, but now here he is comforted and you are suffering. ");
INSERT INTO engemtv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","And besides all this, between us and you a great gulf has been fixed, so that those who desire to cross over from here to you are not able, nor may those from there cross over to us.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Then he said, ‘Therefore I beseech you, father, that you would send him to my father's house, ");
INSERT INTO engemtv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","for I have five brothers, so that he may testify to them, lest they also come to this place of torment.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham said to him, ‘They have Moses and the prophets; let them hear them.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","And he said, ‘No, father Abraham; but if someone from the dead should go to them, they will repent.’ ");
INSERT INTO engemtv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","But he said to him, ‘If they do not hear Moses and the prophets, neither will they be persuaded should one rise from the dead.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Then He said to the disciples, “It is impossible for offenses not to come, but woe to the one through whom they do come! ");
INSERT INTO engemtv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","It would be better for him if a millstone were around his neck, and he be cast into the sea, than that he should offend one of these little ones. ");
INSERT INTO engemtv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Take heed to yourselves. If your brother sins against you, rebuke him; and if he repents, forgive him. ");
INSERT INTO engemtv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","And if he sins against you seven times in a day, and seven times in a day he returns, saying, ‘I repent,’ you shall forgive him.” ");
INSERT INTO engemtv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","And the apostles said to the Lord, “Increase our faith.” ");
INSERT INTO engemtv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","So the Lord said, “If you have faith as a mustard seed, you can say to this mulberry tree, ‘Be uprooted and be planted in the sea,’ and it would obey you. ");
INSERT INTO engemtv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","And which of you, having a servant plowing or tending sheep, will say to him when he has come in from the field, ‘Come and recline to eat’? ");
INSERT INTO engemtv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","But will he not say to him, ‘Prepare something for me to eat, and gird yourself and serve me until I eat and drink, and afterward you will eat and drink’? ");
INSERT INTO engemtv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Does he thank that servant because he did the things that were commanded? I think not. ");
INSERT INTO engemtv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","So likewise you, whenever you do all the things having been commanded to you, say, ‘We are unprofitable servants. We have done what we ought to do.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","And it happened while He was traveling to Jerusalem that He passed through the midst of Samaria and Galilee. ");
INSERT INTO engemtv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Then as He entered a certain village, there met Him ten men who were lepers, who stood at a distance. ");
INSERT INTO engemtv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","And they lifted their voice and said, “Jesus, Master, have mercy on us!” ");
INSERT INTO engemtv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","And seeing them, He said to them, “Go, show yourselves to the priests.” And so it was that as they went away, they were cleansed. ");
INSERT INTO engemtv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","And one of them, seeing that he was healed, turned back, glorifying God with a loud voice, ");
INSERT INTO engemtv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","and fell down on his face at His feet, thanking Him. And he was a Samaritan. ");
INSERT INTO engemtv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","So Jesus answered and said, “Were there not ten cleansed? But where are the nine? ");
INSERT INTO engemtv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Were not any found returning to give glory to God except this foreigner?” ");
INSERT INTO engemtv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","And He said to him, “Arise, go your way. Your faith has made you well.” ");
INSERT INTO engemtv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Now when He was asked by the Pharisees when the kingdom of God was coming, He answered them and said, “The kingdom of God does not come with observation; ");
INSERT INTO engemtv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","neither will they say, ‘Look here!’ or ‘Look, there it is!’ For behold, the kingdom of God is among you.” ");
INSERT INTO engemtv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Then He said to the disciples, “Days will come when you will desire to see one of the days of the Son of Man, and you shall not see it. ");
INSERT INTO engemtv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","And they will say to you, ‘Look here!’ or ‘Look there!’ Do not go forth, nor follow them. ");
INSERT INTO engemtv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","For just as the lightning which flashes out of the one part under heaven shines to the other part under heaven, so also the Son of Man will be in His day. ");
INSERT INTO engemtv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","But first He must suffer many things and be rejected by this generation. ");
INSERT INTO engemtv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","And just as it happened in the days of Noah, so it will be also in the days of the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","They were eating, they were drinking, they were marrying, they were given in marriage, until the day that Noah entered the ark, and the flood came and destroyed them all. ");
INSERT INTO engemtv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Likewise also as it happened in the days of Lot; they were eating, they were drinking, they were buying, they were selling, they were planting, they were building; ");
INSERT INTO engemtv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","but on the day that Lot went out from Sodom, it rained fire and brimstone from heaven and destroyed them all. ");
INSERT INTO engemtv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","In the same way it shall be in the day when the Son of Man is revealed. ");
INSERT INTO engemtv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“In that day, he who shall be on the housetop, and his goods in the house, let him not come down to take them away. And likewise he who is in the field, let him not turn back for the things left behind. ");
INSERT INTO engemtv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Remember Lot's wife. ");
INSERT INTO engemtv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Whoever seeks to save his life shall lose it, and whoever loses his life shall preserve it. ");
INSERT INTO engemtv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","I say to you, in that night two shall be on one bed: one shall be taken, and the other shall be left. ");
INSERT INTO engemtv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Two shall be grinding together: one shall be taken, and the other shall be left.” ");
INSERT INTO engemtv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","And they answered and said to Him, “Where, Lord?” So He said to them, “Wherever the body is, there the eagles will be gathered together.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Then He spoke a parable to them, that one must always pray and not lose heart, ");
INSERT INTO engemtv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","saying: “A certain judge was in a certain city, who did not fear God nor have regard for men. ");
INSERT INTO engemtv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Now there was a widow in that city; and she kept coming to him, saying, ‘Give justice to me against my adversary.’ ");
INSERT INTO engemtv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","And he did not want to for a time; but afterward he said within himself, ‘although I do not fear God, nor have regard for man, ");
INSERT INTO engemtv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","yet because this widow bothers me I will give justice to her, lest she wear me out by forever coming to me.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Then the Lord said, “Hear what the unjust judge said. ");
INSERT INTO engemtv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","And God, shall He not execute justice for His own elect, who cry out day and night to Him, and yet He is patient with them? ");
INSERT INTO engemtv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","I tell you that He will execute justice for them speedily. Nevertheless, when the Son of Man comes, will He find faith on the earth?” ");
INSERT INTO engemtv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Also He spoke this parable to some who trusted in themselves that they were righteous, and despised the others: ");
INSERT INTO engemtv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Two men went up to the temple to pray, the one a Pharisee and the other a tax collector. ");
INSERT INTO engemtv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","The Pharisee stood and prayed thus with himself, ‘God, I thank You that I am not like other men—swindlers, unjust, adulterers, or even like this tax collector. ");
INSERT INTO engemtv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","I fast twice a week, I tithe on all things, as many as I acquire.’ ");
INSERT INTO engemtv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","And the tax collector, standing far away, would not so much as lift his eyes towards heaven, but beat on his chest, saying, ‘God, be merciful to me a sinner!’ ");
INSERT INTO engemtv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","I say to you, this man went down to his house justified rather than the other; for everyone who exalts himself shall be humbled, and he who humbles himself shall be exalted.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","And they were bringing infants to Him, that He might touch them; but when the disciples saw it, they rebuked them. ");
INSERT INTO engemtv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","But Jesus, summoning them, said, “Allow the little children to come to Me, and do not forbid them; for of such is the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Assuredly I say to you, whoever does not receive the kingdom of God as a little child will by no means enter into it.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Now a certain ruler asked Him, saying, “Good Teacher, what shall I do to inherit eternal life?” ");
INSERT INTO engemtv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","So Jesus said to him, “Why do you call Me good? No one is good except One, that is, God. ");
INSERT INTO engemtv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","You know the commandments: ‘Do not commit adultery,’ ‘Do not murder,’ ‘Do not steal,’ ‘Do not bear false witness,’ ‘Honor your father and your mother.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","And he said, “All these I have kept from my youth.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","So when Jesus heard these things, He said to him, “Still one thing you lack: sell all that you have and give to the poor, and you shall have treasure in heaven; and come, follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","But when he heard this, he became very sad, for he was extremely rich. ");
INSERT INTO engemtv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","And when Jesus saw that he became very sad, He said, “How hard it is for those who have riches to enter the kingdom of God! ");
INSERT INTO engemtv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","For it is easier for a camel to go through the eye of a needle than for a rich man to enter the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","And those who heard it said, “Who then is able to be saved?” ");
INSERT INTO engemtv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","But He said, “These things which are impossible with men are possible with God.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Then Peter said, “See, we have left all and followed You.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","So He said to them, “Assuredly I say to you, there is no one who has left house or parents or brothers or wife or children, for the sake of the kingdom of God, ");
INSERT INTO engemtv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","who shall not receive many times more in this present time, and in the age to come eternal life.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Then taking the twelve aside, He said to them, “Behold, we are going up to Jerusalem, and all things that are written by the prophets concerning the Son of Man will be accomplished. ");
INSERT INTO engemtv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","For He will be betrayed to the Gentiles, and will be mocked and insulted and spit upon, ");
INSERT INTO engemtv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","and having scourged Him, they will kill Him. And on the third day He will rise again.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","But they understood none of these things; this saying was hidden from them, and they did not know what was being said. ");
INSERT INTO engemtv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Now it came to pass, as He was coming near Jericho, that a certain blind man sat alongside the road begging. ");
INSERT INTO engemtv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","And hearing a crowd traveling through the city, he asked what this was. ");
INSERT INTO engemtv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","And they reported to him that Jesus the Nazarene was passing by. ");
INSERT INTO engemtv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","And he shouted, saying, “Jesus, Son of David, have mercy on me!” ");
INSERT INTO engemtv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Then those who went before warned him that he should be quiet; but he cried out all the more, “Son of David, have pity on me!” ");
INSERT INTO engemtv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","And having stopped, Jesus commanded him to be brought to Him. And when he drew near, He asked him, ");
INSERT INTO engemtv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","saying, “What do you desire that I should do for you?” And he said, “Lord, that I may receive my sight.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Then Jesus said to him, “Receive your sight; your faith has made you well.” ");
INSERT INTO engemtv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","And immediately he received his sight, and was following Him, glorifying God. And all the people, when they saw this, gave praise to God. ");
INSERT INTO engemtv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","And having entered, He passed through Jericho. ");
INSERT INTO engemtv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","And behold, there was a man named Zacchaeus, and he was a chief tax collector, and he was rich. ");
INSERT INTO engemtv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","And he was trying to see who Jesus was, but could not because of the crowd, for he was of short stature. ");
INSERT INTO engemtv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","And running up ahead in front, he went up into a sycamore tree so that he might see Him, because He was about to pass by that way. ");
INSERT INTO engemtv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","And when He came upon that place, Jesus looked up and saw him, and said to him, “Zacchaeus, hurry and come down, for today I must stay in your house.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","So he hurried and came down, and received Him, rejoicing. ");
INSERT INTO engemtv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","But when they saw it, they all were complaining, saying, “He has gone to be a guest with a sinner.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Then Zacchaeus stood and said to the Lord, “Look, Lord, I give half of my possessions to the poor; and if I have extorted anything from anyone, I restore fourfold.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","And Jesus said to him, “Today salvation has come to this house, because he also is a son of Abraham; ");
INSERT INTO engemtv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","for the Son of Man has come to seek and to save that which was lost.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Now as they heard these things, He told another parable, because He was near Jerusalem and because they thought the kingdom of God would appear immediately. ");
INSERT INTO engemtv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Therefore He said: “A certain nobleman went into a far country to receive for himself a kingdom and to return. ");
INSERT INTO engemtv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","And having called ten of his servants, he gave them ten minas, and said to them, ‘Do business till I come.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","But his citizens hated him, and sent a delegation after him, saying, ‘We will not have this man to reign over us.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“And so it was that when he returned, having received the kingdom, that he commanded those servants to whom he had given the money, to be called to him, so that he might know who gained what by trading. ");
INSERT INTO engemtv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Then came the first, saying, ‘Master, your mina has earned ten minas.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","And he said to him, ‘Well done, good servant; because you were faithful in a very little, have authority over ten cities.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","And the second came, saying, ‘Master, your mina made five minas.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Likewise he said to him, ‘You also be over five cities.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Then another came, saying, ‘Master, behold your mina, which I had laid away in a handkerchief. ");
INSERT INTO engemtv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","For I feared you, because you are a harsh man. You take up what you did not deposit, and reap what you did not sow.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","And he said to him, ‘Out of your own mouth I will judge you, you wicked servant. You knew that I was a harsh man, taking up what I did not deposit, and reaping what I did not sow. ");
INSERT INTO engemtv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Why then did you not give my money to a bank, and when I came, I would have collected it with interest?’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“And he said to those standing by, ‘Take the mina away from him, and give it to him who has ten minas.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","But they said to him, ‘Master, he has ten minas.’ ");
INSERT INTO engemtv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘For I say to you that to everyone who has, more shall be given; and from him who does not have, even what he has shall be taken away from him. ");
INSERT INTO engemtv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nevertheless bring here those enemies of mine, who did not want me to reign over them, and slay them before me.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","And having said these things, He went on ahead, going up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","And it came to pass, as He drew near to Bethphage and Bethany, to the mountain which is called Olivet, that He sent two of His disciples, ");
INSERT INTO engemtv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","saying, “Go into the village opposite you, in which when you enter you will find a colt tied up, on which no one of men has ever sat. Loose him and bring him here. ");
INSERT INTO engemtv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","And if anyone asks you, ‘Why are you loosing him?’ thus you shall say to him, ‘Because the Lord has need of him.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","So those who were sent departed and found it just as He told them. ");
INSERT INTO engemtv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","But as they were loosing the colt, the owners of it said to them, “Why are you loosing the colt?” ");
INSERT INTO engemtv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","And they said, “The Lord has need of him.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Then they brought him to Jesus. And when they threw their own clothes on the colt, they set Jesus on him. ");
INSERT INTO engemtv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","And as He went, they were spreading their clothes under Him on the road. ");
INSERT INTO engemtv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","And as He was approaching the descent of the Mount of Olives, the whole multitude of the disciples began to rejoice and praise God with a loud voice for all the miracles which they had seen, ");
INSERT INTO engemtv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","saying: “ ‘Blessed is the King who comes in the name of the Lord!’ Peace in heaven and glory in the highest!” ");
INSERT INTO engemtv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","And some of the Pharisees said to Him from the crowd, “Teacher, rebuke Your disciples.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","But He answered and said to them, “I tell you that if these should keep silent, the stones would immediately cry out.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","And as He drew near, seeing the city, He wept over it, ");
INSERT INTO engemtv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","saying, “If you had known, even you, especially in this your day, the things pertaining to your peace! But now they have been hidden from your eyes. ");
INSERT INTO engemtv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","For the days will come upon you when your enemies will build an embankment around you, surround you and hem you in from every side, ");
INSERT INTO engemtv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","and they will level you to the ground, and your children with you; and they will not leave in you one stone upon another, because you did not know the season of your visitation.” ");
INSERT INTO engemtv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","And when He entered into the temple, He began to drive out those buying and selling in it, ");
INSERT INTO engemtv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","saying to them, “It is written, ‘My house is a house of prayer,’ but you have made it a ‘den of thieves.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","And He was teaching daily in the temple. But the chief priests, the scribes, and the leaders of the people were seeking to destroy Him, ");
INSERT INTO engemtv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","and were unable to do anything; for all the people were very attentive to hear Him. ");
INSERT INTO engemtv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Now it came to pass on one of those days, as He taught the people in the temple and preached the gospel, that the priests and the scribes, together with the elders, confronted Him, ");
INSERT INTO engemtv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","and they spoke to Him, saying, “Tell us, by what authority are You doing these things? Or who is he who gave You this authority?” ");
INSERT INTO engemtv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","But He answered and said to them, “I also will ask you one thing, and so tell Me: ");
INSERT INTO engemtv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","The baptism of John—was it from heaven or from men?” ");
INSERT INTO engemtv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","And they debated among themselves, saying, “If we say, ‘From heaven,’ He will say, ‘Why then did you not believe him?’ ");
INSERT INTO engemtv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","But if we say, ‘From men,’ all the people will stone us, for they are convinced that John was a prophet.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","So they answered that they did not know where it was from. ");
INSERT INTO engemtv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","And Jesus said to them, “Neither will I tell you by what authority I do these things.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Then He began to tell the people this parable: “A man planted a vineyard, leased it to farmers, and went on a journey for a long time. ");
INSERT INTO engemtv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Now at vintage-time he sent a servant to the farmers, that they might give him some of the fruit of the vineyard. But the farmers flogged him and sent him away empty-handed. ");
INSERT INTO engemtv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","And again he sent another servant; and they flogged him also, treated him shamefully, and sent him away empty-handed. ");
INSERT INTO engemtv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","And again he sent a third; and they wounded him also and threw him out. ");
INSERT INTO engemtv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Then the owner of the vineyard said, ‘What shall I do? I will send my beloved son. Perhaps when they see him they will respect him.’ ");
INSERT INTO engemtv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","But when the farmers saw him, they reasoned among themselves, saying, ‘This is the heir. Come, let us kill him, so that the inheritance may be ours.’ ");
INSERT INTO engemtv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","And casting him out of the vineyard, they killed him. What then will the owner of the vineyard do to them? ");
INSERT INTO engemtv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","He will come and destroy those farmers and give the vineyard to others.” And when they heard it they said, “May it never be!” ");
INSERT INTO engemtv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Then He looked at them and said, “What then is this which is written: ‘The stone which the builders rejected Has become the chief cornerstone’? ");
INSERT INTO engemtv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Everyone who falls on that stone will be broken to pieces; but on whomever it falls, it will grind him to powder.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","And the chief priests and the scribes sought to lay hands on Him that very hour, but they were afraid—for they knew that He had spoken this parable against them. ");
INSERT INTO engemtv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","And having watched Him closely, they sent spies who pretended to be righteous, that they might seize on His words, in order to deliver Him to the rule and the authority of the governor. ");
INSERT INTO engemtv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Then they asked Him, saying, “Teacher, we know that You say and teach rightly, and You do not show favoritism, but teach the way of God in truth: ");
INSERT INTO engemtv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Is it lawful for us to pay taxes to Caesar or not?” ");
INSERT INTO engemtv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","But perceiving their craftiness, He said to them, “Why do you test Me? ");
INSERT INTO engemtv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Show Me a denarius. Whose image and inscription does it have?” They answered and said, “Caesar's.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","And He said to them, “Render therefore to Caesar the things that are Caesar's, and to God the things that are God's.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","But they could not catch Him in His words in front of the people. And marveling at His answer, they kept silent. ");
INSERT INTO engemtv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Then some of the Sadducees, those who deny that there is a resurrection, coming to Him and asked Him, ");
INSERT INTO engemtv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","saying: “Teacher, Moses wrote to us that if a man's brother dies, having a wife, and this man dies childless, that his brother should take his wife and raise up offspring for his brother. ");
INSERT INTO engemtv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Now there were seven brothers. And the first, having taken a wife, died childless. ");
INSERT INTO engemtv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","And the second took her as wife, and this man died childless. ");
INSERT INTO engemtv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Then the third took her, and in like manner the seven also; and they left no children, and they died. ");
INSERT INTO engemtv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Last of all the woman died also. ");
INSERT INTO engemtv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Therefore, in the resurrection, whose wife will she be? For all seven had her as wife.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","And Jesus answered and said to them, “The sons of this age marry and are given in marriage. ");
INSERT INTO engemtv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","But those who have been counted worthy to attain that age, and the resurrection from the dead, neither marry nor are given in marriage; ");
INSERT INTO engemtv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","nor can they die anymore, for they are equal to the angels and are sons of God, being sons of the resurrection. ");
INSERT INTO engemtv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Now even Moses revealed that the dead are raised, in the burning bush passage, when he called the Lord ‘the God of Abraham, the God of Isaac, and the God of Jacob.’ ");
INSERT INTO engemtv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","For He is not the God of the dead but of the living, for all are alive to Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Then some of the scribes answered and said, “Teacher, You have spoken well.” ");
INSERT INTO engemtv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","But after that they dared not question Him anymore. ");
INSERT INTO engemtv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","And He said to them, “How is it that they say the Christ is the Son of David? ");
INSERT INTO engemtv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Even David himself said in the Book of Psalms, ‘The Lord said to my Lord, “Sit at My right hand, ");
INSERT INTO engemtv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","till I make Your enemies a footstool for Your feet.” ’ ");
INSERT INTO engemtv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Therefore David calls Him ‘Lord’; how is He then his Son?” ");
INSERT INTO engemtv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","And as all the people listened, He said to His disciples, ");
INSERT INTO engemtv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Beware of the scribes, who desire to walk about in long robes, and love greetings in the market places, and the first seats in the synagogues, and the places of honor at dinners, ");
INSERT INTO engemtv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","who devour widows' houses, and for a show make long prayers. These will receive greater condemnation.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","And looking up, He saw the rich putting their gifts into the treasury, ");
INSERT INTO engemtv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","and He saw also a certain poor widow putting in two mites. ");
INSERT INTO engemtv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","And He said, “Truly I say to you that this poor widow has put in more than all. ");
INSERT INTO engemtv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","For all these out of their abundance have put in offerings for God, but she out of her poverty put in all the livelihood which she had.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Then, as some spoke about the temple, how it was adorned with beautiful stones and donations, He said, ");
INSERT INTO engemtv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“These things which you see—the days will come in which not one stone shall be left upon another that shall not be thrown down.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","So they asked Him, saying, “Teacher, when will these things be? And what will be the sign when these things are about to happen?” ");
INSERT INTO engemtv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","And He said: “Take heed that no one deceive you. For many will come in My name, saying, ‘I AM,’ and, ‘The time has drawn near.’ Therefore do not go after them. ");
INSERT INTO engemtv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","But whenever you hear of wars and insurrections, do not be terrified; for these things must happen first, but the end will not come immediately.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Then He said to them, “Nation will rise against nation, and kingdom against kingdom. ");
INSERT INTO engemtv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","And there will be great earthquakes in various places, and famines and pestilences; and there will be fearful events and great signs from heaven. ");
INSERT INTO engemtv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","But before all these things, they will lay their hands on you and they will persecute you, delivering you up to the synagogues and prisons. You will be brought before kings and rulers on account of My name. ");
INSERT INTO engemtv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","But it shall turn out for you for a testimony. ");
INSERT INTO engemtv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Put it then in your hearts not to practice beforehand giving your defense; ");
INSERT INTO engemtv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","for I will give you a mouth and wisdom which all your adversaries will not be able to contradict, nor to withstand. ");
INSERT INTO engemtv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","You will be betrayed even by parents and relatives, friends and brothers; and they will put some of you to death. ");
INSERT INTO engemtv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","And you will be hated by all people for My name's sake. ");
INSERT INTO engemtv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","But not a hair of your head shall by any means perish. ");
INSERT INTO engemtv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","By your patient endurance you shall possess your souls. ");
INSERT INTO engemtv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“But when you see Jerusalem surrounded by armies, then know that its desolation has drawn near. ");
INSERT INTO engemtv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Then let those who are in Judea flee to the mountains, let those who are in the midst of her depart, and let not those who are in the fields enter into her. ");
INSERT INTO engemtv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","For these are the days of vengeance, to fulfill all that has been written. ");
INSERT INTO engemtv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","But woe to those who are pregnant and to those who are nursing a baby in those days! For there will be great distress in the land and wrath among this people. ");
INSERT INTO engemtv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","And they will fall by the edge of the sword, and be led away captive into all nations. And Jerusalem will be trampled by Gentiles until the times of the Gentiles are fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“And there shall be signs in the sun, in the moon, and in the stars; and on the earth distress of nations, with perplexity, as the sea and the waves roar, ");
INSERT INTO engemtv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","men's hearts failing them from fear and the expectation of those things which are coming upon the earth, for the powers of heaven shall be shaken. ");
INSERT INTO engemtv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Then they will see the Son of Man coming in a cloud with power and great glory. ");
INSERT INTO engemtv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Now when these things begin to happen, look up and lift up your heads, because your redemption draws near.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Then He spoke to them a parable: “Look at the fig tree, and all the trees. ");
INSERT INTO engemtv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","When they are already budding, you see and know for yourselves that summer is now near. ");
INSERT INTO engemtv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","So you also, when you see these things coming to pass, know that the kingdom of God is near. ");
INSERT INTO engemtv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Assuredly I say to you, this generation shall by no means pass away till all things are fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Heaven and earth shall pass away, but My words shall by no means pass away. ");
INSERT INTO engemtv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“But take heed to yourselves, lest your hearts be weighed down with carousing, drunkenness, and worries of life, and that Day come upon you unexpectedly. ");
INSERT INTO engemtv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","For it will come as a snare on all those who live on the face of the whole earth. ");
INSERT INTO engemtv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Watch therefore, praying always that you may be counted worthy to escape everything that is about to happen, and to stand before the Son of Man.” ");
INSERT INTO engemtv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","And in the daytime He was teaching in the temple, but at night He went out and stayed on the mountain called Olivet. ");
INSERT INTO engemtv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Then early in the morning all the people came to Him in the temple to hear Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Now the Feast of Unleavened Bread drew near, which is called Passover. ");
INSERT INTO engemtv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","And the chief priests and the scribes were seeking how they might kill Him, for they feared the people. ");
INSERT INTO engemtv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Then Satan entered into Judas, surnamed Iscariot, who was numbered among the twelve. ");
INSERT INTO engemtv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","And he went off and spoke with the chief priests and captains about how he might betray Him to them. ");
INSERT INTO engemtv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","And they were glad, and agreed to give him money. ");
INSERT INTO engemtv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","And he promised, and was seeking an opportunity to betray Him to them in the absence of the crowd. ");
INSERT INTO engemtv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Then came the Day of Unleavened Bread, when the Passover lamb had to be sacrificed. ");
INSERT INTO engemtv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","And He sent Peter and John, saying, “Go and prepare the Passover for us, so that we may eat it.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","So they said to Him, “Where do You desire that we shall prepare it?” ");
INSERT INTO engemtv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","And He said to them, “Behold, when you have entered the city, a man will meet you carrying a pitcher of water; follow him into the house where he goes in. ");
INSERT INTO engemtv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Then you shall say to the master of the house, ‘The Teacher says to you, “Where is the guest room in which I may eat the Passover with My disciples?” ’ ");
INSERT INTO engemtv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","And that man will show you a large, furnished upper room; there prepare it.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","So they went and found it just as He had said to them, and they prepared the Passover. ");
INSERT INTO engemtv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","When the hour had come, He reclined to eat, and the twelve apostles with Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Then He said to them, “I have fervently desired to eat this Passover with you before I suffer; ");
INSERT INTO engemtv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","for I say to you, that no longer will I eat of it until it is fulfilled in the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Then He took the cup, and gave thanks, and said, “Take this and divide it among yourselves; ");
INSERT INTO engemtv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","for I say to you, that I will by no means drink of the fruit of the vine until the kingdom of God comes.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","And He took bread, gave thanks and broke it, and gave it to them, saying, “This is My body which is given for you; do this in remembrance of Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Likewise He also took the cup after supper, saying, “This cup is the new covenant in My blood, which is shed for you. ");
INSERT INTO engemtv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nevertheless behold, the hand of him that betrays Me is with Me on the table. ");
INSERT INTO engemtv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","And indeed the Son of Man goes according to what is determined, but woe to that man by whom He is betrayed!” ");
INSERT INTO engemtv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Then they began to discuss with one another, which of them might be the one who was about to do this. ");
INSERT INTO engemtv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","And there arose also a dispute among them, as to which one of them was the greatest. ");
INSERT INTO engemtv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","But He said to them, “The kings of the Gentiles lord it over them, and those who exercise authority over them are called ‘benefactors.’ ");
INSERT INTO engemtv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","But it is not this way with you; let the greatest among you, let him be as the youngest, and he who leads as he who serves. ");
INSERT INTO engemtv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","For who is greater, he who sits at the table, or he who serves? Is it not he who sits at the table? Yet I am among you as the One who serves. ");
INSERT INTO engemtv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Now you are those who have remained with Me in My trials. ");
INSERT INTO engemtv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","And I bestow upon you a kingdom, just as My Father bestowed one upon Me, ");
INSERT INTO engemtv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","so that you may eat and drink at My table in My kingdom, and you will sit on thrones judging the twelve tribes of Israel.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","And the Lord said, “Simon, Simon! Behold, Satan has asked for you, that he may sift you as wheat. ");
INSERT INTO engemtv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","But I have prayed for you, that your faith should not fail; and when you have turned back, strengthen your brothers.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","But he said to Him, “Lord, I am ready to go with You, both to prison and to death.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Then He said, “I say to you, Peter, the rooster will by no means crow this day before you will deny three times that you know Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","And He said to them, “When I sent you without a money bag, and a knapsack, and sandals, did you lack anything?” And they said, “Nothing.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Then He said to them, “But now, he who has a money bag, let him take it, and likewise also a knapsack; and he who has no sword shall sell his garment and buy one. ");
INSERT INTO engemtv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","For I say to you that this which has been written must still be accomplished in Me—the saying, ‘And He was numbered with the transgressors.’ For the things concerning Me have a fulfillment.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","So they said, “Lord, look, here are two swords.” And He said to them, “It is enough.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","And going out, He went to the Mount of Olives, according to His custom, and His disciples also followed Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","And having come to the place, He said to them, “Pray that you may not enter into temptation.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","And He was withdrawn from them about a stone's throw, and He knelt down and prayed, ");
INSERT INTO engemtv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","saying, “Father, if You will, remove this cup from Me—nevertheless not My will, but Yours, be done.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Then an angel appeared to Him from heaven, strengthening Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","And being in agony, He prayed more fervently. Then His sweat became like great drops of blood falling down onto the ground. ");
INSERT INTO engemtv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","And rising up from prayer, coming to the disciples, He found them sleeping from sorrow. ");
INSERT INTO engemtv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Then He said to them, “Why do you sleep? Rise up and pray, lest you enter into temptation.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","And while He was still speaking, behold, a crowd came; and he who was called Judas, one of the twelve, was going before them and drew near to Jesus to kiss Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","But Jesus said to him, “Judas, do you betray the Son of Man with a kiss?” ");
INSERT INTO engemtv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","And those around Him, seeing what was about to happen, they said to Him, “Lord, shall we strike with the sword?” ");
INSERT INTO engemtv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","And a certain one of them struck the servant of the high priest and cut off his right ear. ");
INSERT INTO engemtv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","But Jesus answered and said, “Stop right there.” And touching his ear, He healed him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Then Jesus said to the chief priests, the captains of the temple, and the elders who had come to Him, “Have you come out, as against a bandit, with swords and clubs? ");
INSERT INTO engemtv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","When I was with you daily in the temple, you did not try to seize Me. But this is your hour, and the power of darkness.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","And having arrested Him, they led Him and brought Him into the house of the high priest. And Peter was following from a distance. ");
INSERT INTO engemtv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Now when they had lit a fire in the midst of the courtyard and sat down together, Peter sat in their midst. ");
INSERT INTO engemtv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","And a certain servant girl, seeing him sitting at the fire and gazing at him, said, “This man was also with Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","But he denied Him, saying, “Woman, I do not know Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","And after a little while another person saw him and said, “You also are one of them.” But Peter said, “Man, I am not!” ");
INSERT INTO engemtv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Then after about one hour had passed, another was firmly insisting, saying, “Surely this fellow also was with Him, for he is a Galilean.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","But Peter said, “Man, I do not know what you are saying!” And immediately, while he was still speaking, a rooster crowed. ");
INSERT INTO engemtv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","And the Lord turned and looked at Peter. And Peter remembered the word of the Lord, how He had said to him, “Before a rooster crows, you will deny Me three times.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","And going outside, Peter wept bitterly. ");
INSERT INTO engemtv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Now the men who were holding Jesus were mocking Him and beating Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","And having blindfolded Him, they were striking His face and asking Him, saying, “Prophesy! Who is the one who struck You?” ");
INSERT INTO engemtv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","And many other things they blasphemously spoke against Him. ");
INSERT INTO engemtv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","And when it became day, the council of the elders of the people, the chief priests and scribes, came together and led Him into their council, saying, ");
INSERT INTO engemtv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“If You are the Messiah, tell us.” But He said to them, “If I tell you, you will by no means believe. ");
INSERT INTO engemtv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","But if I also question you, you will by no means answer Me or release Me. ");
INSERT INTO engemtv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hereafter the Son of Man will sit on the right hand of the power of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Then they all said, “Are You then the Son of God?” So He said to them, “You rightly say that I am.” ");
INSERT INTO engemtv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","And they said, “What further testimony do we need? For we have heard it ourselves from His own mouth!” ");
INSERT INTO engemtv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Then the whole multitude of them arose and led Him to Pilate. ");
INSERT INTO engemtv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","And they began to accuse Him, saying, “We found this Man perverting the nation, and forbidding to pay taxes to Caesar, saying that He Himself is Christ, a King.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Then Pilate questioned Him, saying, “Are You the King of the Jews?” He answered him and said, “You are saying what is so.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","But Pilate said to the chief priests and the crowds, “I find no guilt in this Man.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","But they insisted, saying, “He stirs up the people, teaching throughout all Judea, beginning from Galilee to here.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","When Pilate heard of Galilee, he asked if the Man were a Galilean. ");
INSERT INTO engemtv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","And when he found out that He belonged to Herod's jurisdiction, he sent Him to Herod, who was also in Jerusalem in those days. ");
INSERT INTO engemtv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Now when Herod saw Jesus, he was exceedingly glad; for he had desired for a long time to see Him, because he had heard many things about Him, and he was hoping to see some miracle done by Him. ");
INSERT INTO engemtv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Then he questioned Him with many words, but He answered him nothing. ");
INSERT INTO engemtv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","And the chief priests and scribes stood, vehemently accusing Him. ");
INSERT INTO engemtv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Then Herod, with his men of war, having treated Him with contempt, and having mocked Him, arrayed Him in a gorgeous robe, and sent Him back to Pilate. ");
INSERT INTO engemtv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","That very day Pilate and Herod became friends with each other, for previously they had been at enmity with each other. ");
INSERT INTO engemtv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","And Pilate, having called together the chief priests, the rulers, and the people, ");
INSERT INTO engemtv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","said to them, “You have brought this Man to me, on the charge of misleading the people. And indeed, when I examined Him in your presence, I found no guilt in this Man in the matters which you bring as charges against Him; ");
INSERT INTO engemtv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","and neither did Herod, for I sent you back to him; and indeed nothing worthy of death has been done by Him. ");
INSERT INTO engemtv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Therefore when I have flogged Him, I will release Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(For it was necessary for him to release one to them at the feast.) ");
INSERT INTO engemtv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","But they all cried out together, saying, “Away with this Man, and release to us Barabbas”— ");
INSERT INTO engemtv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","who because of a certain insurrection having occurred in the city had been thrown into prison, and for murder. ");
INSERT INTO engemtv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate, therefore, wishing to release Jesus, again called out to them. ");
INSERT INTO engemtv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","But they cried out, saying, “Crucify, crucify Him!” ");
INSERT INTO engemtv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Then he said to them the third time, “Why, what evil has He done? I have found no guilt deserving death in Him. Therefore when I have flogged Him, I will release Him.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","But they were insistent, demanding with loud voices that He be crucified. And their voices and those of the chief priests prevailed. ");
INSERT INTO engemtv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","So Pilate decided that their request should be carried out. ");
INSERT INTO engemtv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","And he released whom they were requesting, who because of insurrection and murder had been thrown into prison; but he delivered Jesus to their will. ");
INSERT INTO engemtv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","And as they led Him away, they laid hold of a certain man, Simon a Cyrenian, as he was coming from the country, and on him they laid the cross, that he might carry it behind Jesus. ");
INSERT INTO engemtv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","And a great multitude of the people followed Him, and women who also were mourning and lamenting Him. ");
INSERT INTO engemtv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","But Jesus, turning to them, said, “Daughters of Jerusalem, do not weep for Me, but weep for yourselves and for your children. ");
INSERT INTO engemtv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","For behold, the days are coming in which they will say, ‘Blessed are the barren, and the wombs which did not give birth, and breasts which did not nurse!’ ");
INSERT INTO engemtv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Then they will begin ‘to say to the mountains, “Fall on us!” and to the hills, “Cover us!” ’ ");
INSERT INTO engemtv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","For if they do these things in the green tree, what will happen in the dry?” ");
INSERT INTO engemtv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","And they also were leading two others with Him, evildoers, to be put to death. ");
INSERT INTO engemtv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","And when they came to the place which is called Calvary, there they crucified Him and the evildoers, one on the right, and one on the left. ");
INSERT INTO engemtv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Then Jesus said, “Father, forgive them, for they know not what they do.” And dividing His garments, they cast lots. ");
INSERT INTO engemtv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","And the people stood, watching. And the rulers with them also were sneering, saying, “He saved others; let Him save Himself if He is the Christ, the elect of God.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","The soldiers also mocked Him, coming and offering Him sour wine, ");
INSERT INTO engemtv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","and saying, “If You are the King of the Jews, save Yourself.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","And an inscription also was written over Him, in Greek, Latin, and Hebrew letters: THIS IS THE KING OF THE JEWS. ");
INSERT INTO engemtv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Then one of the evildoers who were hanged blasphemed Him, saying, “If You are the Christ, save Yourself and us.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","But the other, answering, rebuked him, saying, “Do you not even fear God, seeing you are under the same condemnation? ");
INSERT INTO engemtv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","And we indeed justly, for we are receiving the due reward of our deeds; but this Man did nothing wrong.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Then he said to Jesus, “Lord, remember me when You come in Your kingdom.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","And Jesus said to him, “Assuredly I say to you, today you shall be with Me in Paradise.” ");
INSERT INTO engemtv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Now it was about the sixth hour, and darkness came upon the whole land until the ninth hour. ");
INSERT INTO engemtv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Then the sun was darkened, and the veil of the temple was torn in two. ");
INSERT INTO engemtv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","And Jesus, calling out with a loud voice, said, “Father, ‘into Your hands I will commit My spirit.’ ” And after He said these things, He breathed His last. ");
INSERT INTO engemtv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","And when the centurion saw what had happened, he glorified God, saying, “Certainly this was a righteous Man!” ");
INSERT INTO engemtv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","And all the crowds which came together for this spectacle, when they saw what had happened, beat their own chests and returned. ");
INSERT INTO engemtv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","But all His acquaintances, and the women who followed Him from Galilee, stood at a distance, watching these things. ");
INSERT INTO engemtv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","And behold, there was a man named Joseph, a council member, a good and righteous man ");
INSERT INTO engemtv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(this man had not agreed to their decision and deed), from Arimathea, a city of the Jews, who himself was also waiting for the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","This man went to Pilate and asked for the body of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","And having taken it down, he wrapped it in a linen cloth, and put it in a tomb cut out of rock, where no one had ever lain before. ");
INSERT INTO engemtv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","That day was the Preparation; the Sabbath was drawing near. ");
INSERT INTO engemtv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","And the women who had come with Him from Galilee followed after, and they observed the tomb and how His body was placed. ");
INSERT INTO engemtv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Then they returned and prepared spices and perfumes. And they rested on the Sabbath, according to the commandment. ");
INSERT INTO engemtv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","And on the first day of the week, very early in the morning, they, and certain other women with them, came to the tomb bringing the spices which they had prepared. ");
INSERT INTO engemtv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","But they found the stone having been rolled away from the tomb. ");
INSERT INTO engemtv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","And going in they did not find the body of the Lord Jesus. ");
INSERT INTO engemtv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","And it happened, as they were greatly perplexed about this, that behold, two men stood by them in dazzling apparel. ");
INSERT INTO engemtv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Then, as they became afraid and bowed their faces to the ground, they said to them, “Why do you seek the living among the dead? ");
INSERT INTO engemtv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","He is not here, but is risen! Remember how He spoke to you when He was still in Galilee, ");
INSERT INTO engemtv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","saying, ‘The Son of Man must be delivered into the hands of sinful men, and be crucified, and on the third day rise again.’ ” ");
INSERT INTO engemtv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","And they remembered His words. ");
INSERT INTO engemtv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","And returning from the tomb, they reported all these things to the eleven and to all the rest. ");
INSERT INTO engemtv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","It was Mary Magdalene, Joanna, Mary the mother of James, and the rest with them, who told these things to the apostles. ");
INSERT INTO engemtv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","And their words seemed like nonsense before them, and they disbelieved them. ");
INSERT INTO engemtv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","But Peter rose up and ran to the tomb; and stooping down, he saw the linen strips lying by themselves; and he departed, marveling to himself at what had happened. ");
INSERT INTO engemtv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Now behold, two of them were traveling that same day to a village called Emmaus, which was about seven miles from Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","And they were conversing with one another about all these things which had happened. ");
INSERT INTO engemtv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","So it was, as they were conversing and discussing, that Jesus Himself drew near and started to travel with them. ");
INSERT INTO engemtv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","But their eyes were restrained, so that they did not recognize Him. ");
INSERT INTO engemtv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","And He said to them, “What are these words which you are exchanging with one another as you walk, and you have a gloomy look?” ");
INSERT INTO engemtv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Then the one whose name was Cleopas answered and said to Him, “Are You the only stranger in Jerusalem, and do not know what has happened in it in these days?” ");
INSERT INTO engemtv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","And He said to them, “What things?” So they said to Him, “The things concerning Jesus the Nazarene, who proved to be a man who was a Prophet mighty in deed and word before God and all the people, ");
INSERT INTO engemtv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","and how the chief priests and our rulers handed Him over to be condemned to death, and they crucified Him. ");
INSERT INTO engemtv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","But we were hoping that it was He who was going to redeem Israel. Indeed, besides all this, today is the third day since these things happened. ");
INSERT INTO engemtv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Moreover certain women of our group astonished us, after they arrived early at the tomb. ");
INSERT INTO engemtv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","And not finding His body, they came saying that they had also seen a vision of angels who said He was alive. ");
INSERT INTO engemtv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","And certain of those who were with us went to the tomb, and found it just as the women had said; but Him they did not see.” ");
INSERT INTO engemtv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Then He said to them, “O you foolish, and slow of heart to believe in all that the prophets have spoken! ");
INSERT INTO engemtv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ought not the Christ to have suffered these things and to enter into His glory?” ");
INSERT INTO engemtv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","And beginning at Moses and all the Prophets, He expounded to them in all the Scriptures the things concerning Himself. ");
INSERT INTO engemtv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Then they drew near to the village where they were going, and He made as though He was going farther. ");
INSERT INTO engemtv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","But they constrained Him, saying, “Stay with us, for it is toward evening, and the day is far spent.” And He went in to stay with them. ");
INSERT INTO engemtv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Now it came to pass, as He was reclining to eat with them, having taken bread, He blessed and broke it, and He gave it to them. ");
INSERT INTO engemtv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Then their eyes were opened and they recognized Him; and He vanished from their sight. ");
INSERT INTO engemtv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","And they said to one another, “Was not our heart burning within us while He was speaking to us on the road, and while He was interpreting the Scriptures to us?” ");
INSERT INTO engemtv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","So they rose up that very hour and returned to Jerusalem, and they found the eleven and those who were with them gathered together, ");
INSERT INTO engemtv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","saying, “The Lord is risen indeed, and has appeared to Simon!” ");
INSERT INTO engemtv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","And they described the things that had happened on the road, and how He was known to them in the breaking of bread. ");
INSERT INTO engemtv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Now as they said these things, Jesus Himself stood in the midst of them, and said to them, “Peace to you.” ");
INSERT INTO engemtv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","But being alarmed and becoming fearful, they thought they saw a spirit. ");
INSERT INTO engemtv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","And He said to them, “Why are you troubled? And why do doubts arise in your hearts? ");
INSERT INTO engemtv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Behold My hands and My feet, that it is I Myself. Handle Me and see, for a spirit does not have flesh and bones as you see I have.” ");
INSERT INTO engemtv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","When He had said this, He showed them His hands and His feet. ");
INSERT INTO engemtv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","But as they still disbelieved for joy, and marveled, He said to them, “Do you have any food here?” ");
INSERT INTO engemtv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","So they gave Him a piece of a broiled fish and some honeycomb. ");
INSERT INTO engemtv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","And taking it, He ate it in their presence. ");
INSERT INTO engemtv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Then He said to them, “These are the words which I spoke to you while I was still with you, that all things must be fulfilled which were written in the Law of Moses and the Prophets and the Psalms concerning Me.” ");
INSERT INTO engemtv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","And He opened their understanding, that they might comprehend the Scriptures. ");
INSERT INTO engemtv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Then He said to them, “Thus it is written, and thus it was necessary for the Christ to suffer and to rise from the dead the third day, ");
INSERT INTO engemtv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","and that repentance and forgiveness of sins should be preached in His name to all nations, beginning at Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","And you are witnesses of these things. ");
INSERT INTO engemtv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","And behold, I am sending the Promise of My Father upon you; but tarry in the city of Jerusalem until you are endued with power from on high.” ");
INSERT INTO engemtv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","And He led them out as far as Bethany, and lifting up His hands, He blessed them. ");
INSERT INTO engemtv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","And it happened, while He blessed them, that He was parted from them and was carried up into heaven. ");
INSERT INTO engemtv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","And after they had worshiped Him, they returned to Jerusalem with great joy, ");
INSERT INTO engemtv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","and they were continually in the temple praising and blessing God. Amen. ");
INSERT INTO engemtv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","In the beginning was the Word, and the Word was with God, and the Word was God. ");
INSERT INTO engemtv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","He was in the beginning with God. ");
INSERT INTO engemtv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","All things were made through Him, and without Him nothing was made that was made. ");
INSERT INTO engemtv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In Him was life, and the life was the light of men. ");
INSERT INTO engemtv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","And the light shines in the darkness, and the darkness did not comprehend it. ");
INSERT INTO engemtv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","There was a man sent from God, whose name was John. ");
INSERT INTO engemtv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","This man came for a testimony, so that he might testify concerning the Light, so that all through him might believe. ");
INSERT INTO engemtv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","He was not that Light, but was sent so that he might testify concerning the Light. ");
INSERT INTO engemtv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","That was the true Light which lightens every man coming into the world. ");
INSERT INTO engemtv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","He was in the world, and the world was made through Him, and the world did not know Him. ");
INSERT INTO engemtv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","He came to His own, and His own did not receive Him. ");
INSERT INTO engemtv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","But as many as received Him, to them He gave the authority to become children of God, even to those who believe in His name; ");
INSERT INTO engemtv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","who were born, not of blood, nor of the will of the flesh, nor of the will of man, but of God. ");
INSERT INTO engemtv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","And the Word became flesh and dwelt among us, and we beheld His glory, the glory as of the only begotten of the Father, full of grace and truth. ");
INSERT INTO engemtv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John testified concerning Him and has cried out, saying, “This was He of whom I said, ‘He who comes after me ranks before me, because He was before me.’ ” ");
INSERT INTO engemtv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","And out of His fullness we have all received, and grace upon grace. ");
INSERT INTO engemtv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","For the law was given through Moses, but grace and truth came through Jesus Christ. ");
INSERT INTO engemtv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","No one has seen God at any time. The only begotten Son, who is in the bosom of the Father, He has revealed Him. ");
INSERT INTO engemtv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","And this is the testimony of John, when the Jews sent priests and Levites from Jerusalem so that they might ask him, “Who are you?” ");
INSERT INTO engemtv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","He confessed, and did not deny, but confessed, “I am not the Messiah.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","And they asked him, “What then? Are you Elijah?” He said, “I am not.” “Are you the Prophet?” And he answered, “No.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Then they said to him, “Who are you, that we may give an answer to those who sent us? What do you say about yourself?” ");
INSERT INTO engemtv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","He said: “I am ‘The voice of one crying in the wilderness: “Make straight the way of the Lord,” ’ as Isaiah the prophet said.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Now those who had been sent were from the Pharisees. ");
INSERT INTO engemtv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","And they asked him, saying, “Why then do you baptize if you are not the Messiah, nor Elijah, nor the Prophet?” ");
INSERT INTO engemtv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John answered them, saying, “I baptize with water, but there stands One among you whom you do not know. ");
INSERT INTO engemtv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","He is the One who comes after me, who ranks before me, of whom I am not worthy that I should loose the strap of His sandal.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","These things happened in Bethany, beyond the Jordan, where John was baptizing. ");
INSERT INTO engemtv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","The next day he saw Jesus coming toward him, and said, “Behold! The Lamb of God who takes away the sin of the world! ");
INSERT INTO engemtv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","This is the One about whom I said, ‘After me comes a Man who ranks before me, because He was before me.’ ");
INSERT INTO engemtv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I did not know Him; but that He should be made manifest to Israel, therefore I came baptizing with water.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","And John testified, saying, “I saw the Spirit coming down from heaven like a dove, and He remained upon Him. ");
INSERT INTO engemtv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I did not know Him, but He who sent me to baptize with water said to me, ‘Upon whom you see the Spirit descending and abiding on Him, this is He who baptizes with the Holy Spirit.’ ");
INSERT INTO engemtv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","And I have seen and have testified that this is the Son of God.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Again, the next day, John stood with two of his disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","And looking at Jesus as He was walking, he said, “Behold the Lamb of God!” ");
INSERT INTO engemtv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","The two disciples heard him speaking, and they followed Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Then Jesus turned and observed them following, and said to them, “What are you seeking?” They said to Him, “Rabbi” (which is translated, Teacher), “where are You staying?” ");
INSERT INTO engemtv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","He said to them, “Come and see.” They came and saw where He was staying, and they stayed with Him that day. It was about the tenth hour. ");
INSERT INTO engemtv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","One of the two who heard John speak, and followed Him, was Andrew, Simon Peter's brother. ");
INSERT INTO engemtv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","He first found his own brother Simon, and said to him, “We have found the Messiah” (which is translated, the Christ). ");
INSERT INTO engemtv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","And he led him to Jesus. Now when Jesus looked at him, He said, “You are Simon the son of Jonah. You shall be called Cephas” (which means Peter). ");
INSERT INTO engemtv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","On the next day He wanted to go to Galilee, and He found Philip and said to him, “Follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Now Philip was from Bethsaida, the city of Andrew and Peter. ");
INSERT INTO engemtv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip found Nathanael and said to him, “We have found the One about whom Moses wrote in the Law and the Prophets—Jesus of Nazareth, the son of Joseph.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","And Nathanael said to him, “Can anything good come out of Nazareth?” Philip said to him, “Come and see.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus saw Nathanael coming toward Him, and said about him, “Behold, an Israelite indeed, in whom is no guile!” ");
INSERT INTO engemtv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael said to Him, “From where do You know me?” Jesus answered and said to him, “Before Philip called you, while you were under the fig tree, I saw you.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael answered and said to Him, “Rabbi, You are the Son of God! You are the King of Israel!” ");
INSERT INTO engemtv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus answered and said to him, “Because I said to you, ‘I saw you under the fig tree,’ do you believe? You will see greater things than these.” ");
INSERT INTO engemtv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","And He said to him, “Most assuredly I say to you, from now on you shall see heaven opened, and the angels of God ascending and descending upon the Son of Man.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","And on the third day there was a wedding in Cana of Galilee, and the mother of Jesus was there. ");
INSERT INTO engemtv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Now both Jesus and His disciples were invited to the wedding. ");
INSERT INTO engemtv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","And when the wine had given out, the mother of Jesus said to Him, “They have no wine.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus said to her, “Woman, what have I to do with you? My hour has not yet come.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","His mother said to the servants, “Whatever He may say to you, do.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Now there were six stone water jars standing there, according to the purification rites of the Jews, each holding two or three measures. ");
INSERT INTO engemtv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus said to them, “Fill the water jars with water.” And they filled them up to the top. ");
INSERT INTO engemtv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","And He said to them, “Draw some out now, and take it to the head steward.” And they took it. ");
INSERT INTO engemtv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Now when the head steward tasted the water which had become wine, and did not know where it came from (but the servants who had drawn the water knew), the head steward called the bridegroom ");
INSERT INTO engemtv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","and said to him, “Every man first sets out the good wine, and when they have well drunk, then the inferior. But you have kept the good wine until now!” ");
INSERT INTO engemtv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","This beginning of the signs Jesus did in Cana of Galilee, and manifested His glory; and His disciples believed in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","After this He went down to Capernaum, He, His mother, His brothers, and His disciples; and there they remained not many days. ");
INSERT INTO engemtv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Now the Passover of the Jews was near, and Jesus went up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","And He found in the temple those who sold oxen and sheep and doves, and the moneychangers sitting there. ");
INSERT INTO engemtv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","And having made a scourge out of cords, He drove them all out of the temple, with the sheep and the oxen, and He poured out the coins of the moneychangers, and He overturned the tables. ");
INSERT INTO engemtv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","And He said to those selling the doves, “Take these things away from here! Do not make My Father's house a house of merchandise!” ");
INSERT INTO engemtv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Then His disciples remembered that it was written, “The zeal for Your house will consume Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Therefore the Jews answered and said to Him, “What sign do You show us, seeing that You do these things?” ");
INSERT INTO engemtv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus answered and said to them, “Destroy this temple, and in three days I will raise it up.” ");
INSERT INTO engemtv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Then the Jews said, “It has taken forty-six years to build this temple, and will You raise it up in three days?” ");
INSERT INTO engemtv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","But He was speaking about the temple of His body. ");
INSERT INTO engemtv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Therefore, when He was raised up from among the dead, His disciples remembered that He spoke this thing, and they believed the Scripture and the word which Jesus had spoken. ");
INSERT INTO engemtv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Now when He was in Jerusalem at the Passover Feast, many believed on His name when they saw the signs that He was doing. ");
INSERT INTO engemtv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","But Jesus did not trust Himself to them, because He knew all men, ");
INSERT INTO engemtv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","and had no need that anyone should testify concerning man, for He himself knew what was in man. ");
INSERT INTO engemtv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Now there was a man of the Pharisees whose name was Nicodemus, a ruler of the Jews. ");
INSERT INTO engemtv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","This man came to Him by night and said to Him, “Rabbi, we know that You have come from God as a teacher; for no one can do these signs that You do unless God is with him.” ");
INSERT INTO engemtv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus answered and said to him, “Most assuredly I say to you, unless one is born again, he cannot see the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus said to Him, “How can a man be born, being old? Can he enter a second time into his mother's womb and be born?” ");
INSERT INTO engemtv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus answered, “Most assuredly I say to you, unless one is born of water and the Spirit, he cannot enter the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","That which is born of the flesh is flesh, and that which is born of the Spirit is spirit. ");
INSERT INTO engemtv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Do not marvel that I said to you, ‘You must be born again.’ ");
INSERT INTO engemtv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","The wind blows where it wills, and you hear its sound, but you do not know from where it comes and where it goes. So is everyone who has been born of the Spirit.” ");
INSERT INTO engemtv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus answered and said to Him, “How can these things be?” ");
INSERT INTO engemtv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus answered and said to him, “Are you the teacher of Israel, and do not know these things? ");
INSERT INTO engemtv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Most assuredly I say to you, that which We know, We speak, and that which We have seen, We bear witness to, and you do not receive Our witness. ");
INSERT INTO engemtv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","If I have told you earthly things and you do not believe, how will you believe if I tell you heavenly things? ");
INSERT INTO engemtv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","And no one has gone up into heaven except He who came down out of heaven, the Son of Man, who is in heaven. ");
INSERT INTO engemtv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","And just as Moses lifted up the serpent in the wilderness, even so must the Son of Man be lifted up, ");
INSERT INTO engemtv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","that everyone who believes in Him should not perish but have eternal life. ");
INSERT INTO engemtv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","For God so loved the world that He gave His only begotten Son, that whoever believes in Him should not perish but have eternal life. ");
INSERT INTO engemtv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","For God did not send His Son into the world so that He might condemn the world, but that the world through Him might be saved. ");
INSERT INTO engemtv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“He who believes in Him is not condemned; but he who does not believe has been condemned already, because he has not believed in the name of the only begotten Son of God. ");
INSERT INTO engemtv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","And this is the condemnation, that the light has come into the world, and men loved the darkness more than the light, because their works were evil. ");
INSERT INTO engemtv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","For everyone that does evil hates the light and does not come to the light, lest his works be exposed. ");
INSERT INTO engemtv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","But he who does the truth comes to the light, that his works may be revealed, that they have been done in God.” ");
INSERT INTO engemtv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","After these things Jesus, along with His disciples, came into the land of Judea, and there He was staying with them and He was baptizing. ");
INSERT INTO engemtv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Now John also was baptizing in Aenon near Salem, because there was much water there. And they came and were baptized. ");
INSERT INTO engemtv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(For John was not yet cast into prison). ");
INSERT INTO engemtv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Then there came to be a dispute between John's disciples and a Jew about purification. ");
INSERT INTO engemtv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","And they came to John and said to him, “Rabbi, He who was with you beyond the Jordan, to whom you have testified—behold, this Man is baptizing, and all men are coming to Him!” ");
INSERT INTO engemtv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John answered and said, “A man can receive nothing unless it has been given to him from heaven. ");
INSERT INTO engemtv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","You yourselves bear witness that I said, ‘I am not the Messiah,’ but, ‘I have been sent before Him.’ ");
INSERT INTO engemtv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","He who has the bride is the bridegroom; but the friend of the bridegroom, who stands and hears him, rejoices greatly because of the voice of the bridegroom. Therefore my joy has been fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","He must increase, but I must decrease. ");
INSERT INTO engemtv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","He who comes from above is above all; he who is from the earth is earthly and speaks of the earth. He who comes from heaven is above all. ");
INSERT INTO engemtv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","And what He has seen and heard, that He testifies; and no one receives His testimony. ");
INSERT INTO engemtv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","He who receives His testimony has certified that God is true. ");
INSERT INTO engemtv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","For He whom God has sent speaks the words of God, for God does not give the Spirit by measure. ");
INSERT INTO engemtv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","The Father loves the Son, and has given all things into His hand. ");
INSERT INTO engemtv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","He who believes in the Son has eternal life; and he who does not believe the Son will not see life, but the wrath of God abides on him.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Therefore, when the Lord knew that the Pharisees had heard that Jesus was making and was baptizing more disciples than John ");
INSERT INTO engemtv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(although Jesus Himself was not baptizing, but His disciples), ");
INSERT INTO engemtv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","He left Judea and went away into Galilee. ");
INSERT INTO engemtv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","But He needed to pass through Samaria. ");
INSERT INTO engemtv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Therefore He came to a city of Samaria, which is called Sychar, near the piece of land which Jacob gave to his son Joseph. ");
INSERT INTO engemtv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Now Jacob's well was there. Therefore Jesus, having become tired from the journey, was sitting beside the well. It was about the sixth hour. ");
INSERT INTO engemtv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A woman of Samaria came to draw water. Jesus said to her, “Give Me a drink.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(For His disciples had gone away into the city, that they might buy provisions). ");
INSERT INTO engemtv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Then the woman of Samaria said to Him, “How is it that You, being a Jew, ask a drink from me, a Samaritan woman?” For Jews do not associate with Samaritans. ");
INSERT INTO engemtv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus answered and said to her, “If you had known the gift of God, and who it is that says to you, ‘Give Me a drink,’ you would have asked Him, and He would have given to you living water.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","The woman said to Him, “Sir, You have nothing to draw with, and the well is deep. Where then do You get that living water? ");
INSERT INTO engemtv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Are You greater than our father Jacob, who gave us the well, and drank of it himself, as well as his sons and his livestock?” ");
INSERT INTO engemtv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus answered and said to her, “Whoever drinks of this water will thirst again, ");
INSERT INTO engemtv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","but whoever drinks of the water which I shall give him will by no means ever thirst again. But the water which I shall give him will become in him a fountain of water springing up into eternal life.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","The woman said to Him, “Sir, give me this water, that I may not thirst, nor come here to draw.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus said to her, “Go, call your husband, and come here.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","The woman answered and said, “I have no husband.” Jesus said to her, “You have said well, ‘I have no husband,’ ");
INSERT INTO engemtv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","for you have had five husbands, and the one whom you now have is not your husband; in this you have said truly.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","The woman said to Him, “Sir, I perceive that You are a prophet. ");
INSERT INTO engemtv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Our fathers worshiped on this mountain, and you Jews say that in Jerusalem is the place where it is necessary to worship.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus said to her, “Woman, believe Me, the hour is coming when you will neither on this mountain, nor in Jerusalem, worship the Father. ");
INSERT INTO engemtv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","You worship what you do not know; we Jews worship what we know, because salvation is of the Jews. ");
INSERT INTO engemtv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","But the hour is coming, and now is, when the true worshipers will worship the Father in spirit and truth; for the Father is seeking such to worship Him. ");
INSERT INTO engemtv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God is Spirit, and those who worship Him must worship in spirit and truth.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","The woman said to Him, “I know that Messiah is coming” (who is called Christ). “When He comes, He will proclaim to us all things.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus said to her, “I am He, the One speaking to you.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","And at this point His disciples came, and they marveled that He was speaking with a woman; however no one said, “What do You seek?” or, “Why are You speaking with her?” ");
INSERT INTO engemtv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","The woman then left her water jar, went her way into the city, and said to the men, ");
INSERT INTO engemtv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Come, see a Man who told me everything I ever did. Could this be the Christ?” ");
INSERT INTO engemtv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","They went out of the city and were coming to Him. ");
INSERT INTO engemtv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","But in the meantime the disciples urged Him, saying, “Rabbi, eat.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","But He said to them, “I have food to eat of which you do not know.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Therefore the disciples were saying to one another, “Has anyone brought Him something to eat?” ");
INSERT INTO engemtv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus said to them, “My food is to do the will of Him who sent Me, and to finish His work. ");
INSERT INTO engemtv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Do you not say, ‘There are still four months and the harvest comes’? Behold, I say to you, lift up your eyes and see the fields, for they are already white for harvest! ");
INSERT INTO engemtv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","And he who reaps receives wages, and gathers fruit unto eternal life, that both he who sows and he who reaps may rejoice together. ");
INSERT INTO engemtv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","For in this the saying is true: ‘One sows and another reaps.’ ");
INSERT INTO engemtv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I sent you to reap that for which you have not labored; others have labored, and you have entered into their labors.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","And many of the Samaritans of that city believed in Him because of the word of the woman testifying, “He told me everything I ever did.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","So when the Samaritans had come to Him, they were asking Him to stay with them; and He stayed there two days. ");
INSERT INTO engemtv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","And many more believed because of His word. ");
INSERT INTO engemtv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Then they were saying to the woman, “No longer because of your speech do we believe, for we ourselves have heard and know that this is truly the Christ, the Savior of the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Now after the two days He went out from there and went to Galilee. ");
INSERT INTO engemtv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","For Jesus Himself testified that a prophet has no honor in his own country. ");
INSERT INTO engemtv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Therefore when He came into Galilee, the Galileans received Him, having seen all the things which He did in Jerusalem at the feast; for they also went to the feast. ");
INSERT INTO engemtv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Then Jesus came again to Cana of Galilee where He had turned the water into wine. And there was a certain nobleman whose son was sick in Capernaum. ");
INSERT INTO engemtv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","When he heard that Jesus had come out of Judea into Galilee, he went to Him and asked Him that He might come down and heal his son, for he was about to die. ");
INSERT INTO engemtv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Then Jesus said to him, “Unless you people see signs and wonders, you will by no means believe.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","The nobleman said to Him, “Sir, come down before my child dies!” ");
INSERT INTO engemtv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus said to him, “Go; your son lives.” And the man believed the word that Jesus spoke to him, and went away. ");
INSERT INTO engemtv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","And already as he was going, his servants met him and reported, saying, “Your child lives!” ");
INSERT INTO engemtv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Then he inquired from them the hour at which he got better. And they said to him, “Yesterday at the seventh hour the fever left him.” ");
INSERT INTO engemtv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Therefore the father knew that it was at the same hour in which Jesus said to him, “Your son lives.” And he himself believed, and his whole household. ");
INSERT INTO engemtv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","This was now the second sign that Jesus did, after He had come out of Judea into Galilee. ");
INSERT INTO engemtv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","After these things there was a feast of the Jews, and Jesus went up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Now there is in Jerusalem by the Sheep Gate a pool, which is called in Hebrew, Bethesda, having five porches. ");
INSERT INTO engemtv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","In these porches were lying a great multitude of those who were sick, blind, lame, paralyzed, waiting for the moving of the water. ");
INSERT INTO engemtv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","For an angel from time to time descended into the pool and stirred up the water; therefore the first one having gone in after the stirring up of the water, became well of whatever disease he was suffering from. ");
INSERT INTO engemtv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Now there was a certain man there who had an ailment for thirty-eight years. ");
INSERT INTO engemtv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","When Jesus saw this man lying there, and knew that he already had been in that condition a long time, He said to him, “Do you wish to become well?” ");
INSERT INTO engemtv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","The sick man answered Him, “Sir, I do not have a man, so that whenever the water is stirred up, he may put me into the pool; but while I am coming, another steps down before me.” ");
INSERT INTO engemtv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus said to him, “Arise, take up your bed and walk.” ");
INSERT INTO engemtv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","And immediately the man became well, and took up his bed, and began to walk. And that day was the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Therefore the Jews said to the man who was healed, “It is the Sabbath; it is not lawful for you to carry your bed.” ");
INSERT INTO engemtv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","He answered them, “He that made me whole, He said to me, ‘Take up your bed and walk.’ ” ");
INSERT INTO engemtv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Then they asked him, “Who is the Man who said to you, ‘Take up your bed and walk’?” ");
INSERT INTO engemtv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","But the one who was healed did not know who it was, for Jesus had turned aside, while a crowd was in that place. ");
INSERT INTO engemtv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","After these things Jesus found him in the temple, and said to him, “Behold, you have become well. Sin no more, lest something worse happens to you.” ");
INSERT INTO engemtv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","The man went away and reported to the Jews that Jesus was the One who had made him well. ");
INSERT INTO engemtv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","And on account of this the Jews began to persecute Jesus, and were seeking to kill Him, because He was doing these things on the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","But Jesus answered them, “My Father has been working until now, and I am working.” ");
INSERT INTO engemtv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Because of this the Jews were seeking all the more to kill Him, because not only was He breaking the Sabbath, but also He called God His own Father, making Himself equal with God. ");
INSERT INTO engemtv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Then Jesus answered and said to them, “Most assuredly I say to you, the Son can do nothing of Himself, but what He sees the Father doing; for whatever He does, the Son also does in like manner. ");
INSERT INTO engemtv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","For the Father loves the Son, and shows to Him all things which He Himself does; and greater works than these He will show Him, so that you may marvel. ");
INSERT INTO engemtv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","For as the Father raises up the dead and gives life, thus also the Son gives life to whom He wills. ");
INSERT INTO engemtv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","For the Father judges no one, but He has committed all judgment to the Son, ");
INSERT INTO engemtv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","so that all may honor the Son even as they honor the Father. He who does not honor the Son does not honor the Father who sent Him. ");
INSERT INTO engemtv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Most assuredly I say to you, he who hears My word and believes in Him who sent Me has eternal life, and shall not come into judgment, but has passed out of death into life. ");
INSERT INTO engemtv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Most assuredly I say to you, that an hour is coming, and now is, when the dead will hear the voice of the Son of God; and those having heard shall live. ");
INSERT INTO engemtv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","For just as the Father has life in Himself, so He has granted the Son to have life in Himself, ");
INSERT INTO engemtv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","and has given Him authority to execute judgment also, because He is the Son of Man. ");
INSERT INTO engemtv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Do not marvel at this; for an hour is coming in which all those in the tombs will hear His voice ");
INSERT INTO engemtv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","and shall come forth—those who have done good, to the resurrection of life, and those who have done evil, to the resurrection of damnation. ");
INSERT INTO engemtv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","I can of My own self do nothing. Even as I hear, I judge; and My judgment is just, because I do not seek My own will but the will of the Father who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“If I alone testify of Myself, My testimony is not true. ");
INSERT INTO engemtv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","There is another who testifies about Me, and I know that the testimony which He testifies concerning Me is true. ");
INSERT INTO engemtv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","You have sent to John, and he has testified to the truth. ");
INSERT INTO engemtv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","But I do not receive the testimony from man, but these things I say so that you may be saved. ");
INSERT INTO engemtv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","He was the burning and shining lamp, and you were willing to rejoice for a while in his light. ");
INSERT INTO engemtv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","But I have a testimony greater than John's; for the works which the Father gave to Me, that I should complete them, these very works which I do, testify of Me, that the Father has sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","And the Father Himself, who sent Me, has testified about Me. You have neither heard His voice at any time, nor seen His form. ");
INSERT INTO engemtv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","But you do not have His word abiding in you, because Him whom He sent, Him you do not believe. ");
INSERT INTO engemtv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","You search the Scriptures, because you think that in them you have eternal life; and these are they which testify about Me. ");
INSERT INTO engemtv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","But you are unwilling to come to Me, so that you may have life. ");
INSERT INTO engemtv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“I do not receive glory from men. ");
INSERT INTO engemtv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","But I have known you, that you do not have the love of God in yourselves. ");
INSERT INTO engemtv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","I have come in My Father's name, and you do not receive Me; if another comes in his own name, him you will receive. ");
INSERT INTO engemtv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","How can you believe, who receive glory from one another, and do not seek the glory which is from the only God? ");
INSERT INTO engemtv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Do not think that I will accuse you to the Father; there is one who accuses you—Moses, in whom you have hoped. ");
INSERT INTO engemtv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","For if you believed Moses, you would have believed Me; for he wrote about Me. ");
INSERT INTO engemtv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","But if you do not believe his writings, how will you believe My words?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","After these things Jesus went over the Sea of Galilee, that is, of Tiberias. ");
INSERT INTO engemtv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","And a large crowd was following Him, because they were seeing His signs which He was doing upon those who were sick. ");
INSERT INTO engemtv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","And Jesus went up on the mountain, and there He sat down with His disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Now the Passover, the feast of the Jews, was near. ");
INSERT INTO engemtv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Then Jesus lifted up His eyes, and seeing that a large crowd was coming toward Him, He said to Philip, “Where shall we buy bread, that these people may eat?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","But this He said to test him, for He Himself knew what He was about to do. ");
INSERT INTO engemtv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip answered Him, “Two hundred denarii worth of bread is not enough for them, that each of them might receive a little.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","One of His disciples, Andrew, Simon Peter's brother, said to Him, ");
INSERT INTO engemtv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“There is a little boy here who has five barley loaves and two small fish, but what are they for so many?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Then Jesus said, “Make the people to recline.” Now there was much grass in that place. Therefore the men reclined, in number about five thousand. ");
INSERT INTO engemtv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","And Jesus took the loaves, and having given thanks He distributed them to the disciples, and the disciples to those who were reclining; and likewise of the fish, as much as they wished. ");
INSERT INTO engemtv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","And when they were filled, He said to His disciples, “Gather up the leftover fragments, so that nothing may be lost.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Therefore they gathered them up, and they filled twelve baskets of fragments from the five barley loaves which were left over by those who had eaten. ");
INSERT INTO engemtv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Then those men, when they had seen the sign that Jesus did, said, “This is truly the Prophet who is to come into the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Therefore Jesus, knowing that they were about to come and seize Him, that they might make Him king, withdrew to the mountain by Himself. ");
INSERT INTO engemtv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Now when evening came, His disciples went down to the sea, ");
INSERT INTO engemtv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","and having entered into the boat, they were going across the sea to Capernaum. And darkness had already come, and Jesus had not come to them. ");
INSERT INTO engemtv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","And the sea was agitated by a great blowing wind. ");
INSERT INTO engemtv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Therefore having rowed about three or four miles, they saw Jesus walking on the sea and drawing near to the boat; and they were frightened. ");
INSERT INTO engemtv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","But He said to them, “It is I AM; do not fear.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Then they were willing to receive Him into the boat, and immediately the boat arrived at the land to which they were going. ");
INSERT INTO engemtv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","On the next day, when the crowd which had remained on the other side of the sea, having seen that there was no other boat there, except that one in which His disciples had entered, and that Jesus had not entered into the boat with His disciples, but His disciples had gone away alone— ");
INSERT INTO engemtv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","however, other boats came from Tiberias, near the place where they ate bread after the Lord had given thanks— ");
INSERT INTO engemtv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","when the crowd therefore saw that Jesus was not there, nor His disciples, they got into boats and came to Capernaum, seeking Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","And having found Him on the other side of the sea, they said to Him, “Rabbi, when did You come here?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus answered them and said, “Most assuredly I say to you, you seek Me, not because you saw the signs, but because you ate of the loaves and were filled. ");
INSERT INTO engemtv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Do not work for the food that perishes, but for the food that endures to eternal life, which the Son of Man will give to you; for upon Him God the Father has set His seal.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Then they said to Him, “What should we do, that we may work the works of God?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus answered and said to them, “This is the work of God, that you believe in Him whom He sent.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Therefore they said to Him, “What sign will You do then, so that we may see it and believe You? What work do You perform? ");
INSERT INTO engemtv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Our fathers ate the manna in the wilderness; as it is written, ‘He gave them bread from heaven to eat.’ ” ");
INSERT INTO engemtv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Then Jesus said to them, “Most assuredly I say to you, Moses has not given you the bread from heaven, but My Father gives you the true bread from heaven. ");
INSERT INTO engemtv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","For the bread of God is He who comes down from heaven and gives life to the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Then they said to Him, “Lord, give us this bread always.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","And Jesus said to them, “I am the bread of life. He who comes to Me shall never hunger, and he who believes in Me shall never thirst. ");
INSERT INTO engemtv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","But I told you that you have both seen Me and you do not believe. ");
INSERT INTO engemtv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","All that the Father gives Me will come to Me, and whoever comes to Me I will by no means cast out. ");
INSERT INTO engemtv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","For I have come down from heaven, not that I might do My will, but the will of Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","And this is the will of the Father who sent Me, that of all He has given Me, I should lose nothing, but should raise it up at the last day. ");
INSERT INTO engemtv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","And this is the will of Him who sent Me, that everyone who sees the Son and believes in Him may have eternal life; and I will raise him up at the last day.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Therefore the Jews were murmuring about Him, because He said, “I am the bread which came down from heaven.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","And they were saying, “Is not this Jesus, the son of Joseph, whose father and mother we know? How then does this Man say, ‘I have come down from heaven’?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus therefore answered and said to them, “Do not murmur among yourselves. ");
INSERT INTO engemtv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","No one can come to Me unless the Father who sent Me should draw him; and I will raise him up at the last day. ");
INSERT INTO engemtv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","It is written in the prophets, ‘And they shall all be taught of God.’ Therefore everyone who hears from the Father, and has learned, comes to Me. ");
INSERT INTO engemtv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Not that anyone has seen the Father, except He who is from God; He has seen the Father. ");
INSERT INTO engemtv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Most assuredly I say to you, he who believes in Me has eternal life. ");
INSERT INTO engemtv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","I am the bread of life. ");
INSERT INTO engemtv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Your fathers ate the manna in the wilderness, and they died. ");
INSERT INTO engemtv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","This is the bread which comes down from heaven, that one may eat of it and not die. ");
INSERT INTO engemtv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","I am the living bread which came down from heaven. If anyone eats of this bread, he will live forever; and the bread that I shall give is My flesh, which I shall give for the life of the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Therefore the Jews were contending with one another, saying, “How can this Man give us His flesh to eat?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Then Jesus said to them, “Most assuredly I say to you, unless you eat the flesh of the Son of Man and drink His blood, you have no life in yourselves. ");
INSERT INTO engemtv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Whoever eats My flesh and drinks My blood has eternal life, and I will raise him up in the last day. ");
INSERT INTO engemtv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","For My flesh truly is food, and My blood truly is drink. ");
INSERT INTO engemtv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","He who eats My flesh and drinks My blood abides in Me, and I in him. ");
INSERT INTO engemtv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Just as the living Father sent Me, and I live because of the Father, so he who feeds on Me will live because of Me. ");
INSERT INTO engemtv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","This is the bread which came down from heaven, not as your fathers ate the manna, and died. Whoever eats this bread shall live forever.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","These things He said in the synagogue as He taught in Capernaum. ");
INSERT INTO engemtv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Therefore many of His disciples, when they heard this, said, “This is a hard saying; who can hear it?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","And Jesus, knowing in Himself that His disciples were murmuring about this, He said to them, “Does this offend you? ");
INSERT INTO engemtv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","What then if you should see the Son of Man ascending where He was before? ");
INSERT INTO engemtv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","It is the Spirit who makes alive; the flesh profits nothing. The words that I speak to you are spirit, and they are life. ");
INSERT INTO engemtv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","But there are some of you who do not believe.” (For Jesus knew from the beginning who were the ones who did not believe, and who was the one who would betray Him). ");
INSERT INTO engemtv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","And He said, “Because of this I have said to you that no one can come to Me unless it has been granted to him by My Father.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","From this time many of His disciples turned back and no longer walked with Him. ");
INSERT INTO engemtv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Then Jesus said to the twelve, “Do you also want to go away?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","But Simon Peter answered Him, “Lord, to whom shall we go? You have the words of eternal life. ");
INSERT INTO engemtv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Also we have come to believe and know that You are the Christ, the Son of the living God.” ");
INSERT INTO engemtv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus answered them, “Did I not choose you, the twelve, and one of you is a devil?” ");
INSERT INTO engemtv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Now He was speaking about Judas Iscariot, the son of Simon, for he was intending to betray Him, though he was one of the twelve. ");
INSERT INTO engemtv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","And after these things Jesus was walking in Galilee; for He did not wish to walk in Judea, because the Jews were seeking to kill Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Now the Jewish Feast of Tabernacles was near. ");
INSERT INTO engemtv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","His brothers therefore said to Him, “Depart from here and go into Judea, so that Your disciples also may see the works that You do. ");
INSERT INTO engemtv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","For no one does anything in secret while he himself seeks to be known publicly. If You do these things, show Yourself to the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","For not even His brothers believed in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Then Jesus said to them, “My time has not yet come, but your time is always ready. ");
INSERT INTO engemtv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","The world cannot hate you, but it hates Me because I testify about it, that its works are evil. ");
INSERT INTO engemtv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","You go up to this feast. I am not yet going up to this feast, because My time has not yet been fulfilled.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","When He had said these things to them, He remained in Galilee. ");
INSERT INTO engemtv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","But when His brothers had gone up, then also He Himself went up to the feast, not openly, but in private. ");
INSERT INTO engemtv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Then the Jews were seeking Him at the feast, and said, “Where is He?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","And there was much murmuring among the crowds concerning Him. Some on the one hand were saying, “He is a good Man”; while others were saying, “No, on the contrary, He deceives the people.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","However, no one spoke openly of Him for fear of the Jews. ");
INSERT INTO engemtv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","But now about the middle of the feast Jesus went up into the temple and began to teach. ");
INSERT INTO engemtv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","And the Jews were marveling, saying, “How has this Man become learned, since He has not been educated?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Therefore Jesus answered them and said, “My doctrine is not Mine, but His who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","If anyone desires to do His will, he will know about the doctrine, whether it is from God, or whether I am speaking on My own authority. ");
INSERT INTO engemtv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","He who speaks from himself is seeking his own glory; but He who seeks the glory of the One who sent Him is true, and there is no unrighteousness in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Has not Moses given you the law, yet none of you keeps the law? Why are you seeking to kill Me?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","The crowd answered and said, “You have a demon. Who is seeking to kill You?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus answered and said to them, “I did one work, and you all marvel. ");
INSERT INTO engemtv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Because of this Moses has given you circumcision (not that it is from Moses, but from the fathers), and you circumcise a man on the Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","If a man receives circumcision on the Sabbath, so that the law of Moses should not be broken, are you angry with Me because I made a man completely well on the Sabbath? ");
INSERT INTO engemtv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Do not judge according to appearance, but judge with righteous judgment.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Therefore some of the people of Jerusalem were saying, “Is this not He whom they are seeking to kill? ");
INSERT INTO engemtv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","And look! He is speaking publicly, and they say nothing to Him. Can it be that the rulers know indeed that this is truly the Messiah? ");
INSERT INTO engemtv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","However, we know where this Man is from; but whenever the Messiah comes, no one knows where He is from.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Therefore Jesus cried out, as He was teaching in the temple, saying, “You both know Me, and you know where I am from; and I have not come of my own accord, but He who sent Me is true, whom you do not know. ");
INSERT INTO engemtv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","I know Him, for I am from Him, and He sent Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Therefore they were seeking to arrest Him; but no one laid a hand on Him, because His hour had not yet come. ");
INSERT INTO engemtv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","But many of the crowd believed in Him, and were saying, “When the Messiah comes, will He do more signs than these which this Man has done?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","The Pharisees heard the crowd murmuring these things about Him, and the Pharisees and the chief priests sent attendants so that they might arrest Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Then Jesus said, “Yet a little while am I with you, and then I go to Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","You will seek Me and you will not find Me, and where I am you cannot come.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Therefore the Jews said among themselves, “Where does this man intend to go that we will not find Him? Does He intend to go into the Dispersion among the Greeks and teach the Greeks? ");
INSERT INTO engemtv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","What is this thing which He said, ‘You will seek Me and you will not find Me, and where I am you cannot come’?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Now on the last day, the great day of the feast, Jesus stood and cried out, saying, “If anyone thirsts, let him come to Me and drink. ");
INSERT INTO engemtv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","He that believes in Me, as the Scripture has said, out of his belly will flow rivers of living water.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(But this He spoke concerning the Spirit, whom those believing in Him were about to receive; for the Holy Spirit was not yet given, because Jesus was not yet glorified). ");
INSERT INTO engemtv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Therefore many from the crowd, when they heard this saying, said, “Truly this is the Prophet.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Others said, “This is the Messiah.” Others said, “Surely the Messiah is not to come out of Galilee, is He? ");
INSERT INTO engemtv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Has not the Scripture said that the Messiah comes from the seed of David and from the village of Bethlehem, where David was?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Therefore a division occurred among the crowd because of Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Now some of them wished to arrest Him, but no one laid a hand on Him. ");
INSERT INTO engemtv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Then the attendants came to the chief priests and Pharisees, who said to them, “Why did you not bring Him?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","The attendants answered them, “No man ever spoke like this Man!” ");
INSERT INTO engemtv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Then the Pharisees answered them, “Have you also been deceived? ");
INSERT INTO engemtv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Have any of the rulers or the Pharisees believed in Him? ");
INSERT INTO engemtv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","But this crowd which does not know the law is accursed.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus (he who came to Him by night, being one of them) said to them, ");
INSERT INTO engemtv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Does our law judge a man before it hears from him first, and knows what he is doing?” ");
INSERT INTO engemtv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","They answered and said to him, “Are you also from Galilee? Search and see, because no prophet has arisen out of Galilee.” ");
INSERT INTO engemtv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","And everyone went to his own house. ");
INSERT INTO engemtv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","But Jesus went to the Mount of Olives. ");
INSERT INTO engemtv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","And early in the morning, He came again into the temple, and all the people came to Him; and having sat down, He began to teach them. ");
INSERT INTO engemtv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Then the scribes and Pharisees brought to Him a woman who had been caught in adultery, and having stood her in the midst, ");
INSERT INTO engemtv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","they said to Him, “Teacher, we found this woman committing adultery, in the very act. ");
INSERT INTO engemtv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Now Moses, in our law, commanded to cast stones at such. Therefore what do You say?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","But this they said, testing Him, that they might have an accusation against Him. But Jesus, stooping down, began to write on the ground with His finger, not taking notice. ");
INSERT INTO engemtv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","And while they were continuing questioning Him, rising up, He said unto them, “He who is without sin among you, let him be the first to cast a stone at her.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","And again He stooped down and wrote on the ground. ");
INSERT INTO engemtv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","And those who heard it began to go out one by one, beginning with the oldest even to the last. And Jesus was left alone, and the woman being in the midst. ");
INSERT INTO engemtv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","And standing up and seeing no one but the woman, Jesus said to her, “Woman, where are those accusers of yours? Has no one condemned you?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","She said, “No one, Lord.” And Jesus said to her, “Neither do I condemn you; go, and from now on sin no more.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Then Jesus spoke to them again, saying, “I am the light of the world. He that follows Me shall by no means walk in darkness, but will have the light of life.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Therefore the Pharisees said to Him, “You testify about Yourself; Your testimony is not true.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus answered and said to them, “Even if I should testify about Myself, My testimony is true, because I know where I came from and where I am going; but you do not know where I come from or where I am going. ");
INSERT INTO engemtv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","You judge according to the flesh; I judge no one. ");
INSERT INTO engemtv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","But even if I do judge, My judgment is true; because I am not alone, but I am with the Father who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","It is also written in your law that the testimony of two men is true. ");
INSERT INTO engemtv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","I am the One testifying about Myself, and the Father who sent Me testifies about Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Then they said to Him, “Where is Your Father?” Jesus answered, “You know neither Me nor My Father. If you knew Me, you would also know My Father.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","These words Jesus spoke in the treasury, while teaching in the temple; and no one seized Him, for His time had not yet come. ");
INSERT INTO engemtv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Then Jesus said to them again, “I am going away, and you will seek Me, and will die in your sin. Where I go you cannot come.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","So the Jews said, “Surely He will not kill Himself, will He, since He says, ‘Where I am going you cannot come’?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","And He said to them, “You are from below; I am from above. You are from this world; I am not from this world. ");
INSERT INTO engemtv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Therefore I said to you that you will die in your sins; for if you do not believe that I AM, you will die in your sins.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Then they said to Him, “Who are You?” And Jesus said to them, “Just what I have been saying to you from the beginning. ");
INSERT INTO engemtv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","I have many things to say and to judge concerning you, but He who sent Me is true; and the things which I heard from Him, these things I say to the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","They did not know that He was speaking to them about the Father. ");
INSERT INTO engemtv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Therefore Jesus said to them, “When you lift up the Son of Man, then you will know that I AM, and from Myself I do nothing; but just as My Father taught Me, these things I speak. ");
INSERT INTO engemtv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","And He who sent Me is with Me. The Father has not left Me alone, because I always do the things that are pleasing to Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","While He spoke these words, many believed in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Then Jesus said to those Jews who had believed Him, “If you abide in My word, truly you are My disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","And you shall know the truth, and the truth shall set you free.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","They answered Him, “We are Abraham's descendants, and have never been in bondage to anyone. How can you say, ‘You will become free’?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus answered them, “Most assuredly I say to you, that everyone that practices sin is a slave of sin. ");
INSERT INTO engemtv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","And a slave does not remain in the house forever, but a son remains forever. ");
INSERT INTO engemtv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Therefore if the Son sets you free, you will be truly free. ");
INSERT INTO engemtv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“I know that you are Abraham's seed, but you seek to kill Me, because My word finds no place in you. ");
INSERT INTO engemtv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","I speak what I have seen with My Father, and you do what you have seen with your father.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","They answered and said to Him, “Abraham is our father.” Jesus said to them, “If you were Abraham's children, you would do the works of Abraham. ");
INSERT INTO engemtv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","But now you seek to kill Me, a Man who has spoken to you the truth which I heard from God. Abraham did not do this. ");
INSERT INTO engemtv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","You do the works of your father.” Then they said to Him, “We were not born of fornication; we have one Father—God.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Therefore Jesus said to them, “If God were your Father, you would have loved Me, for I came forth and have come from God; nor have I come from Myself, but He sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Why do you not understand what I say? Because you are unable to hear My word. ");
INSERT INTO engemtv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","You are of your father the devil, and the lusts of your father you desire to do. He was a murderer from the beginning, and has not stood in the truth, because there is no truth in him. When he tells a lie, he speaks from his own resources, for he is a liar, and the father of lies. ");
INSERT INTO engemtv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","But because I tell the truth, you do not believe Me. ");
INSERT INTO engemtv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Which of you convicts Me of sin? And if I tell the truth, why do you not believe Me? ");
INSERT INTO engemtv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","He who is of God hears God's words; therefore you do not hear them, because you are not of God.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Then the Jews answered and said to Him, “Do we not say well that You are a Samaritan, and You have a demon?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus answered, “I do not have a demon; but I honor My Father, and you dishonor Me. ");
INSERT INTO engemtv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","And I do not seek My own glory; there is One who seeks it and who judges. ");
INSERT INTO engemtv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Most assuredly I say to you, if anyone keeps My word he shall by no means experience death.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Then the Jews said to Him, “Now we know that You have a demon! Abraham and the prophets died, and You say, ‘If anyone keeps My word he shall by no means taste death.’ ");
INSERT INTO engemtv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Are You greater than our father Abraham, who died? Also the prophets died. Whom do You make Yourself out to be?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus answered, “If I glorify Myself, My glory is nothing. It is My Father who glorifies Me, of whom you say that He is our God. ");
INSERT INTO engemtv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","And yet you have not known Him, but I know Him. And if I would say that I do not know Him, I would be like you, a liar; but I do know Him, and I keep His word. ");
INSERT INTO engemtv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Your father Abraham rejoiced to see My day, and he saw it and was glad.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Then the Jews said to Him, “You are not yet fifty years old, and have You seen Abraham?” ");
INSERT INTO engemtv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus said to them, “Most assuredly I say to you, before Abraham was, I AM.” ");
INSERT INTO engemtv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Therefore they picked up stones to throw at Him; but Jesus hid Himself and went out of the temple, having gone through their midst, and so passed by. ");
INSERT INTO engemtv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","And passing by, He saw a man blind from birth. ");
INSERT INTO engemtv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","And His disciples asked Him, saying, “Rabbi, who sinned, this man or his parents, that he was born blind?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus answered, “Neither this man nor his parents sinned, but so that the works of God should be manifest in him. ");
INSERT INTO engemtv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I must work the works of Him who sent Me while it is day; the night is coming when no one can work. ");
INSERT INTO engemtv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","While I am in the world, I am the light of the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Having said these things, He spat on the ground and made clay from the saliva; and He applied the clay on the eyes of the blind man. ");
INSERT INTO engemtv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","And He said to him, “Go, wash in the pool of Siloam” (which is translated, Sent). So he went and washed, and came back seeing. ");
INSERT INTO engemtv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Therefore the neighbors and those who previously saw him, that he was blind, were saying, “Is not this he who sat and begged?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Some said, “This is he.” Others said, “He looks like him.” But he kept saying, “I am he.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Therefore they said to him, “How were your eyes opened?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","He answered and said, “A Man called Jesus made clay and anointed my eyes, and He said to me, ‘Go to the pool of Siloam and wash.’ When I had gone and washed, I received my sight.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Then they said to him, “Where is He?” He said, “I do not know.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","They brought him who was once blind to the Pharisees. ");
INSERT INTO engemtv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Now it was the Sabbath day when Jesus made the clay and opened his eyes. ");
INSERT INTO engemtv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Then again the Pharisees were asking him how he received his sight. And he said to them, “He put clay on my eyes, and I washed, and I see.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Therefore some of the Pharisees were saying, “This Man is not from God, because He does not keep the Sabbath.” Others said, “How can a sinful man do such signs?” And there was a division among them. ");
INSERT INTO engemtv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","They said to the blind man again, “What do you say about Him, since He has opened your eyes?” He said, “He is a prophet.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","But the Jews did not believe concerning him, that he was blind and received his sight, until they called the parents of him who had received his sight. ");
INSERT INTO engemtv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","And they asked them, saying, “Is this your son, who you say was born blind? How then does he now see?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","And his parents answered them and said, “We know that this is our son, and that he was born blind; ");
INSERT INTO engemtv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","but how he now sees we do not know, or who opened his eyes we do not know. He is of age; ask him. He will speak for himself.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","These things his parents said because they feared the Jews, for the Jews had agreed already that if anyone should confess that He was Christ, he would be excommunicated. ");
INSERT INTO engemtv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","On account of this his parents said, “He is of age; ask him.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Therefore they called a second time the man who was blind, and said to him, “Give glory to God! We know that this Man is a sinner.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","He answered and said, “Whether He is a sinner or not I do not know. One thing I do know: that although I was blind, now I see.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Then they said to him again, “What did He do to you? How did He open your eyes?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","He answered them, “I told you already, and you did not listen. Why do you wish to hear it again? Do you also want to become His disciples?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Then they reviled him and said, “You are His disciple, but we are Moses' disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","We know that God has spoken to Moses; but as for this Man, we do not know where He is from.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","The man answered and said to them, “Why, this is a remarkable thing, that you do not know where He is from; yet He opened my eyes! ");
INSERT INTO engemtv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Now we know that God does not hear sinners; but if anyone is God-fearing and does His will, He hears him. ");
INSERT INTO engemtv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Since eternity past it was unheard of that anyone opened the eyes of one having been born blind. ");
INSERT INTO engemtv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","If this Man were not from God, He could do nothing.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","They answered and said to him, “You were completely born in sins, and do you teach us?” And they cast him out. ");
INSERT INTO engemtv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus heard that they had cast him out; and having found him, He said to him, “Do you believe in the Son of God?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","He answered and said, “And who is He, Lord, that I may believe in Him?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","And Jesus said to him, “You have both seen Him and it is He who is speaking with you.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Then he said, “Lord, I believe!” And he worshiped Him. ");
INSERT INTO engemtv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","And Jesus said, “For judgment I came into this world, that those who do not see may see, and those who see might become blind.” ");
INSERT INTO engemtv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Then some of the Pharisees who were with Him heard these things, and said to Him, “Are we blind also?” ");
INSERT INTO engemtv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus said to them, “If you were blind, you would have no sin; but now you say, ‘We see.’ Therefore your sin remains. ");
INSERT INTO engemtv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Most assuredly I say to you, he who does not enter the sheepfold through the door, but climbs up some other way, he is a thief and a robber. ");
INSERT INTO engemtv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","But he who enters through the door is the shepherd of the sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","To him the doorkeeper opens, and the sheep hear his voice; and he calls his own sheep by name and he leads them out. ");
INSERT INTO engemtv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","And whenever he brings out his own sheep, he goes before them; and the sheep follow him, because they know his voice. ");
INSERT INTO engemtv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","But they will by no means follow a stranger, but they will flee from him, for they do not know the voice of strangers.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","This illustration Jesus spoke to them, but they did not understand the things which He spoke to them. ");
INSERT INTO engemtv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Then Jesus said to them again, “Most assuredly I say to you, I am the door of the sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","All who came before Me are thieves and robbers, but the sheep did not hear them. ");
INSERT INTO engemtv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","I am the door. If anyone enters by Me, he will be saved, and will go in and go out, and will find pasture. ");
INSERT INTO engemtv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","The thief does not come except to steal, and to kill, and to destroy. I have come that they may have life, and that they may have it more abundantly. ");
INSERT INTO engemtv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“I am the good shepherd. The good shepherd lays down His life for the sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","But a hired hand, he who is not the shepherd, one who does not own the sheep, sees the wolf coming and leaves the sheep and flees; and the wolf catches the sheep and scatters them. ");
INSERT INTO engemtv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","But the hired hand flees because he is a hired hand, and is not concerned about the sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","I am the good shepherd; and I know My own, and I am known by My own. ");
INSERT INTO engemtv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Just as the Father knows Me, I also know the Father; and I lay down My life for the sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","And other sheep I have which are not of this fold; those also I must bring, and they will hear My voice; and there shall be one flock and one shepherd. ");
INSERT INTO engemtv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“For this reason My Father loves Me, because I lay down My life that I may take it up again. ");
INSERT INTO engemtv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No one takes it from Me, but I lay it down of Myself. I have authority to lay it down, and I have authority to take it up again. This command I have received from My Father.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Therefore there was a division again among the Jews because of these words. ");
INSERT INTO engemtv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","And many of them said, “He has a demon and is raving mad. Why do you listen to Him?” ");
INSERT INTO engemtv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Others said, “These are not the words of one being demon-possessed. Can a demon open the eyes of the blind?” ");
INSERT INTO engemtv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Now it was the Feast of Dedication in Jerusalem, and it was winter. ");
INSERT INTO engemtv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","And Jesus was walking in the temple, in Solomon's porch. ");
INSERT INTO engemtv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Then the Jews encircled Him and said to Him, “How long will You keep us in suspense? If You are the Christ, tell us plainly.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus answered them, “I told you, and you do not believe. The works that I do in My Father's name, these things testify about Me. ");
INSERT INTO engemtv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","But you do not believe, because you are not of My sheep, just as I said to you. ");
INSERT INTO engemtv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","My sheep hear My voice, and I know them, and they follow Me. ");
INSERT INTO engemtv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","And I give to them eternal life, and they shall never perish; and no one will snatch them out of My hand. ");
INSERT INTO engemtv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","My Father, who has given them to Me, is greater than all; and no one is able to snatch them out of My Father's hand. ");
INSERT INTO engemtv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","I and the Father are one.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Therefore the Jews took up stones again to stone Him. ");
INSERT INTO engemtv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus answered them, “Many good works I have shown you from My Father. For which of those works do you stone Me?” ");
INSERT INTO engemtv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","The Jews answered Him, saying, “For a good work we do not stone You, but for blasphemy, and because You, being a Man, make Yourself God.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus answered them, “Is it not written in your law, ‘I said, “You are gods” ’? ");
INSERT INTO engemtv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","If He called those gods, to whom the word of God came (and the Scripture cannot be broken), ");
INSERT INTO engemtv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","do you say of Him whom the Father sanctified and sent into the world, ‘You are blaspheming,’ because I said, ‘I am the Son of God’? ");
INSERT INTO engemtv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","If I am not doing the works of My Father, do not believe Me; ");
INSERT INTO engemtv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","but if I am doing them, even if you do not believe Me, believe the works, so that you may know and believe that the Father is in Me, and I in Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Therefore they were seeking again to seize Him, but He escaped from their hand. ");
INSERT INTO engemtv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","And He went away again beyond the Jordan to the place where John was first baptizing, and He stayed there. ");
INSERT INTO engemtv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","And many came to Him and said, “John indeed performed no sign, but everything which John said about this Man was true.” ");
INSERT INTO engemtv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","And many believed in Him there. ");
INSERT INTO engemtv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Now there was a certain man who was sick, Lazarus from Bethany, of the village of Mary and her sister Martha. ");
INSERT INTO engemtv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Now it was that Mary who had anointed the Lord with myrrh, and wiped His feet with her hair, whose brother Lazarus was sick. ");
INSERT INTO engemtv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Therefore the sisters sent to Him, saying, “Lord, behold, he whom You love is sick.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","And when Jesus heard, He said, “This sickness is not unto death, but for the glory of God, that the Son of God may be glorified through it.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Now Jesus loved Martha and her sister and Lazarus. ");
INSERT INTO engemtv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Therefore when He heard that he was sick, He then stayed in the place where He was for two days. ");
INSERT INTO engemtv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Then after this He said to the disciples, “Let us go into Judea again.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","The disciples said to Him, “Rabbi, just now the Jews were seeking to stone You, and are You going there again?” ");
INSERT INTO engemtv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus answered, “Are there not twelve hours in the day? If anyone walks in the day, he does not stumble, because he sees the light of this world. ");
INSERT INTO engemtv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","But if anyone walks in the night, he stumbles, because the light is not in him.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","These things He said, and after this He said to them, “Our friend Lazarus has fallen asleep, but I am going so that I may awaken him.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Then His disciples said, “Lord, if he has fallen asleep he will get well.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","However, Jesus spoke about his death, but they thought that He was speaking about resting in sleep. ");
INSERT INTO engemtv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Then Jesus said to them plainly, “Lazarus is dead. ");
INSERT INTO engemtv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","And I rejoice for your sakes that I was not there, so that you may believe. Nevertheless let us go to him.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Then Thomas, who is called the Twin, said to his fellow disciples, “Let us also go, so that we may die with Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Therefore when He had come, Jesus found that he had already been in the tomb four days. ");
INSERT INTO engemtv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Now Bethany was near Jerusalem, about two miles away. ");
INSERT INTO engemtv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","And many of the Jews had come to the women around Martha and Mary, so that they might console them concerning their brother. ");
INSERT INTO engemtv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Then Martha, when she heard that Jesus was coming, met Him, but Mary was sitting in the house. ");
INSERT INTO engemtv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Then Martha said to Jesus, “Lord, if You had been here, my brother would not have died. ");
INSERT INTO engemtv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","But even now I know that whatever You may ask of God, God will give You.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus said to her, “Your brother will rise again.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha said to Him, “I know that he will rise again in the resurrection on the last day.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus said to her, “I am the resurrection and the life. He that believes in Me, though he may die, he shall live. ");
INSERT INTO engemtv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","And everyone who lives and believes in Me shall never die. Do you believe this?” ");
INSERT INTO engemtv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","She said to Him, “Yes, Lord, I believe that You are the Christ, the Son of God, who is to come into the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","And when she had said these things, she went out and secretly called Mary her sister, saying, “The Teacher is here and is calling for you.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","As soon as she heard that, she arose quickly and came to Him. ");
INSERT INTO engemtv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Now Jesus had not yet come into the village, but was in the place where Martha met Him. ");
INSERT INTO engemtv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Then the Jews who were with her in the house and consoling her, when they saw that Mary rose up quickly and went out, followed her, saying, “She is going to the tomb, so that she may weep there.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Then, when Mary came where Jesus was, seeing Him, she fell down at His feet, saying to Him, “Lord, if You had been here, my brother would not have died.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Therefore, when Jesus saw her weeping, and the Jews who had come along with her weeping, He groaned in the spirit and was troubled. ");
INSERT INTO engemtv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","And He said, “Where have you laid him?” They said to Him, “Lord, come and see.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus wept. ");
INSERT INTO engemtv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Therefore the Jews were saying, “Look how He loved him!” ");
INSERT INTO engemtv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","But some of them said, “Could not this Man, who opened the eyes of the blind, have done something to keep this man from dying?” ");
INSERT INTO engemtv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Then Jesus, again groaning in Himself, came to the tomb. Now it was a cave, and a stone was lying upon it. ");
INSERT INTO engemtv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus said, “Take away the stone.” Martha, the sister of the one having died, said to Him, “Lord, already there is a stench, for he has been dead four days.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus said to her, “Did I not say to you that if you would believe you would see the glory of God?” ");
INSERT INTO engemtv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Then they took away the stone from the place where the dead man was lying. And Jesus lifted up His eyes and said, “Father, I thank You that You have heard Me. ");
INSERT INTO engemtv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","And I knew that You always hear Me, but because of the people standing around I said this, so that they may believe that You sent Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","And having said these things, He cried out with a loud voice, “Lazarus, come forth!” ");
INSERT INTO engemtv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","And the one having died came out, bound hands and feet with grave clothes, and his face was wrapped in a handkerchief. Jesus said to them, “Loose him, and let him go.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Therefore many of the Jews who had come to Mary, and seeing the things which Jesus had done, believed in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","But some of them went away to the Pharisees, and told them the things which Jesus had done. ");
INSERT INTO engemtv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Therefore the chief priests and the Pharisees gathered a council and said, “What are we doing? For this Man works many signs. ");
INSERT INTO engemtv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","If we leave Him alone in this way, all will believe in Him, and the Romans will come and will take away both our place and nation.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","But a certain one of them, Caiaphas, being high priest that year, said to them, “You don't know anything, ");
INSERT INTO engemtv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nor do you consider that it is advantageous for us that one man should die for the people, and not that the whole nation should perish.” ");
INSERT INTO engemtv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Now this he did not say on his own, but being high priest that year, he prophesied that Jesus was about to die for the nation, ");
INSERT INTO engemtv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","and not for that nation only, but also that He would gather together in one the children of God who were scattered abroad. ");
INSERT INTO engemtv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Therefore from that day on they took counsel together, that they might kill Him. ");
INSERT INTO engemtv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Therefore Jesus no longer walked openly among the Jews, but He went away from there into the country near the desert, to a city called Ephraim, and there He stayed with His disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Now the Passover of the Jews was near, and many went from the country up to Jerusalem before the Passover, so that they might purify themselves. ");
INSERT INTO engemtv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Then they were seeking Jesus, and they were speaking with one another, standing in the temple, “What do you think—that He will definitely not come to the feast?” ");
INSERT INTO engemtv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Now both the chief priests and the Pharisees had given a command, that if anyone knew where He was, he should report it, so that they might seize Him. ");
INSERT INTO engemtv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Then Jesus, six days before the Passover, came to Bethany, where Lazarus was who had died, whom He raised from the dead. ");
INSERT INTO engemtv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Then they made for Him a supper there; and Martha was serving, but Lazarus was one of those reclining to eat with Him. ");
INSERT INTO engemtv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Then Mary, having taken a pound of very costly pure nard, anointed the feet of Jesus, and wiped His feet with her hair. And the house was filled with the fragrance of the perfume. ");
INSERT INTO engemtv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Then one of His disciples, Judas Iscariot, son of Simon, who was about to betray Him, said, ");
INSERT INTO engemtv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Why was this perfume not sold for three hundred denarii and given to the poor?” ");
INSERT INTO engemtv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","This he said, not because he cared for the poor, but because he was a thief, and had the money box; and he used to pilfer the things which were placed in it. ");
INSERT INTO engemtv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","But Jesus said, “Let her alone; she has kept this for the day of My burial. ");
INSERT INTO engemtv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","For the poor you have with you always, but Me you do not have always.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Now a large crowd from the Jews knew that He was there; and they came, not for Jesus' sake only, but that they might also see Lazarus, whom He had raised from the dead. ");
INSERT INTO engemtv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","But the chief priests took counsel, that they might also kill Lazarus, ");
INSERT INTO engemtv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","because on account of him many of the Jews were going away, and were believing in Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","On the next day a large crowd which was coming to the feast, having heard that Jesus was coming to Jerusalem, ");
INSERT INTO engemtv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","took the branches of the palm trees and went out to meet Him, and they were crying out, “Hosanna! ‘Blessed is He who comes in the name of the Lord!’ The King of Israel!” ");
INSERT INTO engemtv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Then Jesus, when He had found a young donkey, He sat on it; as it is written: ");
INSERT INTO engemtv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Do not fear, daughter of Zion; behold, your King is coming, sitting on the colt of a donkey.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","His disciples did not understand these things at first; but when Jesus was glorified, then they remembered that these things were written about Him, and that they did these things to Him. ");
INSERT INTO engemtv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Therefore the crowd which was with Him when He called Lazarus out of his tomb and raised him from the dead, was testifying. ");
INSERT INTO engemtv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","On account of this the crowd also met Him, because they heard that He had done this sign. ");
INSERT INTO engemtv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","The Pharisees therefore said among themselves, “You see that you are not doing any good. Look, the world has gone after Him!” ");
INSERT INTO engemtv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","And there were some Greeks among those coming up, so that they might worship at the feast. ");
INSERT INTO engemtv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Then they approached Philip, who was from Bethsaida of Galilee, and they asked him, saying, “Sir, we wish to see Jesus.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip came and told Andrew, and in turn Andrew and Philip told Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","But Jesus answered them, saying, “The hour has come that the Son of Man should be glorified. ");
INSERT INTO engemtv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Most assuredly I say to you, unless a grain of wheat falls into the ground and dies, it remains alone; but if it dies, it bears much fruit. ");
INSERT INTO engemtv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","He that loves his life shall lose it, and he that hates his life in this world shall keep it for eternal life. ");
INSERT INTO engemtv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","And if anyone serve Me, let him follow Me; and where I am, there My servant shall be also. If anyone serve Me, him My Father will honor. ");
INSERT INTO engemtv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Now My soul has been troubled, and what shall I say? ‘Father, save Me from this hour’? But for this reason I came to this hour. ");
INSERT INTO engemtv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Father, glorify Your name.” Then a voice came out of heaven, saying, “I have both glorified it, and will glorify it again.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Therefore the crowd which was standing and heard were saying that it had thundered. Others were saying, “An angel has spoken to Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus answered and said, “This voice did not come for My sake, but for your sake. ");
INSERT INTO engemtv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Now is the judgment of this world; now the ruler of this world shall be cast out. ");
INSERT INTO engemtv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","And I, if I be lifted up from the earth, will draw all peoples to Myself.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","This He said, signifying by what kind of death He was about to die. ");
INSERT INTO engemtv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","The crowd answered Him, “We heard from the law that the Christ abides forever; and so how do You say, ‘The Son of Man must be lifted up’? Who is this Son of Man?” ");
INSERT INTO engemtv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Then Jesus said to them, “For yet a little while longer the light is with you. Walk while you have the light, lest darkness overtake you; he who walks in darkness does not know where he is going. ");
INSERT INTO engemtv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","While you have the light, believe in the light, so that you may become sons of light.” These things Jesus spoke, and departing, He was hidden from them. ");
INSERT INTO engemtv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","But even though He had done so many signs in their presence, they did not believe in Him, ");
INSERT INTO engemtv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","that the word of Isaiah the prophet might be fulfilled, which he said: “Lord, who has believed our report? And to whom has the arm of the Lord been revealed?” ");
INSERT INTO engemtv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Therefore they could not believe, because Isaiah said again: ");
INSERT INTO engemtv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“He has blinded their eyes and hardened their hearts, lest they should see with their eyes, lest they should understand with their hearts and turn, and I would heal them.” ");
INSERT INTO engemtv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","These things Isaiah said when he saw His glory and spoke about Him. ");
INSERT INTO engemtv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nevertheless even from among the rulers many believed in Him, but because of the Pharisees they did not confess Him, lest they should be excommunicated; ");
INSERT INTO engemtv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","for they loved the praise of men more than the praise of God. ");
INSERT INTO engemtv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Then Jesus cried out and said, “He who believes in Me, believes not in Me but in Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","And he who sees Me sees Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","I have come as a light into the world, so that whoever believes in Me may not abide in darkness. ");
INSERT INTO engemtv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","And if anyone hears My words and does not believe, I do not judge him; for I did not come that I might judge the world, but that I might save the world. ");
INSERT INTO engemtv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","He that rejects Me, and does not receive My words, has that which judges him—the word which I spoke, that word will judge him in the last day. ");
INSERT INTO engemtv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","For I have not spoken on My own authority; but the Father who sent Me gave Me a command, what I should say and what I should speak. ");
INSERT INTO engemtv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","And I know that His command is eternal life. Therefore, whatever I speak, as the Father has said to Me, so I speak.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Now before the feast of the Passover, when Jesus knew that His hour had come that He should depart from this world to the Father, having loved His own who were in the world, He loved them to the end. ");
INSERT INTO engemtv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","And after supper, the devil having already put it into the heart of Judas Iscariot, the son of Simon, to betray Him, ");
INSERT INTO engemtv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus, knowing that the Father had given all things into His hands, and that He had come from God and was going to God, ");
INSERT INTO engemtv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","He rose from supper and laid aside His garments, and having taken a towel, He girded Himself. ");
INSERT INTO engemtv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Then He poured water into a basin and began to wash the feet of the disciples, and to dry them with the towel with which He was girded. ");
INSERT INTO engemtv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Then He came to Simon Peter. And Peter said to Him, “Lord, do You wash my feet?” ");
INSERT INTO engemtv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus answered and said to him, “What I am doing you do not understand now, but afterward you will understand.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter said to Him, “You shall never wash my feet!” Jesus answered him, “Unless I wash you, you have no part with Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter said to Him, “Lord, not my feet only, but also my hands and my head!” ");
INSERT INTO engemtv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus said to him, “He that is bathed need only to wash his feet, but is completely clean; and you are clean, but not all of you.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","For He knew who would betray Him; for this reason He said, “You are not all clean.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","So when He had washed their feet, and had taken His garments, He reclined again, and said to them, “Do you know what I have done to you? ");
INSERT INTO engemtv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","You call me Teacher and Lord, and you say correctly, for so I am. ");
INSERT INTO engemtv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Therefore if I, your Lord and your Teacher, have washed your feet, you also ought to wash one another's feet. ");
INSERT INTO engemtv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","For I gave you an example, that just as I did to you, you also should do. ");
INSERT INTO engemtv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Most assuredly I say to you, a servant is not greater than his master, nor a messenger greater than he who sent him. ");
INSERT INTO engemtv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","If you know these things, blessed are you if you do them. ");
INSERT INTO engemtv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“I do not speak concerning all of you. I know those whom I chose; but that the Scripture may be fulfilled, ‘He who eats bread with Me has lifted up his heel against Me.’ ");
INSERT INTO engemtv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","From now on I tell you before it happens, so that when it happens, you may believe that I AM. ");
INSERT INTO engemtv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Most assuredly I say to you, he who receives whomever I send receives Me; and he who receives Me receives Him who sent Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","When Jesus had said these things, He was troubled in His spirit, and testified and said, “Most assuredly I say to you, one of you will betray Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Therefore the disciples were looking at one another, perplexed about whom He was speaking. ");
INSERT INTO engemtv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Now there was reclining on Jesus' bosom one of His disciples, the one whom Jesus loved. ");
INSERT INTO engemtv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter therefore motioned to him to inquire who it might be about whom He was speaking. ");
INSERT INTO engemtv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Then, leaning back thus on Jesus' chest, he said to Him, “Lord, who is it?” ");
INSERT INTO engemtv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus answered, “It is the one to whom I shall give a piece of bread when I have dipped it.” And having dipped the bread, He gave it to Judas Iscariot, the son of Simon. ");
INSERT INTO engemtv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","And after the piece of bread, then Satan entered him. Therefore Jesus said to him, “What you do, do quickly.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","But no one reclining at the table knew for what purpose He said this to him. ");
INSERT INTO engemtv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","For some were thinking, since Judas had the money box, that Jesus was saying to him, “Buy the things of which we need for the feast,” or that he should give something to the poor. ");
INSERT INTO engemtv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Therefore having received the piece of bread, he then went out immediately. And it was night. ");
INSERT INTO engemtv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","When he had gone out, Jesus said, “Now the Son of Man has been glorified, and God has been glorified in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","If God has been glorified in Him, God will also glorify Him in Himself, and will glorify Him immediately. ");
INSERT INTO engemtv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Little children, yet a little while I am with you. You will seek Me; and as I said to the Jews, ‘Where I am going, you cannot come,’ so now I say to you. ");
INSERT INTO engemtv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A new commandment I give to you, that you love one another; just as I have loved you, that you also love one another. ");
INSERT INTO engemtv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","By this all will know that you are My disciples, if you have love for one another.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter said to Him, “Lord, where are You going?” Jesus answered him, “Where I am going you cannot follow Me now, but later you will follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter said to Him, “Lord, why can I not follow You now? I will lay down my life for You.” ");
INSERT INTO engemtv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus answered him, “Will you lay down your life for Me? Most assuredly I say to you, the rooster shall by no means crow till you deny Me three times. ");
INSERT INTO engemtv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Let not your heart be troubled; you believe in God, believe also in Me. ");
INSERT INTO engemtv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In My Father's house are many mansions; if it were not so, I would have told you. I go to prepare a place for you. ");
INSERT INTO engemtv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","And if I go and prepare a place for you, I will come again and I will receive you unto Myself; so that where I am, there you may be also. ");
INSERT INTO engemtv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","And where I am going you know, and the way you know.” ");
INSERT INTO engemtv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas said to Him, “Lord, we do not know where You are going, and how can we know the way?” ");
INSERT INTO engemtv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus said to him, “I am the way, the truth, and the life. No one comes to the Father except through Me. ");
INSERT INTO engemtv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","“If you had known Me, you would have known My Father also; and from now on you know Him and you have seen Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip said to Him, “Lord, show us the Father, and it is sufficient for us.” ");
INSERT INTO engemtv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus said to him, “Have I been with you for so long a time, and yet you have not known Me, Philip? He that has seen Me has seen the Father; so how can you say, ‘Show us the Father’? ");
INSERT INTO engemtv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Do you not believe that I am in the Father, and the Father in Me? The words which I speak to you I do not speak on My own authority; but the Father who abides in Me does the works. ");
INSERT INTO engemtv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Believe Me that I am in the Father and the Father is in Me, but if not, believe Me for the sake of the works themselves. ");
INSERT INTO engemtv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Most assuredly I say to you, he that believes in Me, the works which I do he will do also; and greater works than these he will do, because I go to My Father. ");
INSERT INTO engemtv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","And whatever you may ask in My name, this I will do, so that the Father may be glorified in the Son. ");
INSERT INTO engemtv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","If you should ask anything in My name, I will do it. ");
INSERT INTO engemtv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“If you love Me, keep My commandments. ");
INSERT INTO engemtv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","And I will ask the Father, and He will give you another Helper, so that He may abide with you forever, ");
INSERT INTO engemtv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","the Spirit of truth, whom the world cannot receive, because it neither sees Him nor knows Him; but you know Him, because He abides with you and shall be in you. ");
INSERT INTO engemtv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","I will not leave you orphans; I am coming to you. ");
INSERT INTO engemtv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Yet a little while and the world will see Me no more, but you will see Me. Because I live, you will live also. ");
INSERT INTO engemtv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","In that day you will know that I am in My Father, and you in Me, and I in you. ");
INSERT INTO engemtv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","He that has My commandments and keeps them, it is he who loves Me. And he who loves Me shall be loved by My Father, and I will love him and will manifest Myself to him.” ");
INSERT INTO engemtv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (not Iscariot) said to Him, “Lord, and what has happened that You are about to manifest Yourself to us, and not to the world?” ");
INSERT INTO engemtv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus answered and said to him, “If anyone loves Me, he will keep My word; and My Father will love him, and We will come to him and we will make Our home with him. ");
INSERT INTO engemtv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","He who does not love Me does not keep My words; and the word which you hear is not Mine but the Father's who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“These things I have spoken to you while I remain. ");
INSERT INTO engemtv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","But the Helper, the Holy Spirit, whom the Father will send in My name, He will teach you all things, and will remind you of all things which I said to you. ");
INSERT INTO engemtv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Peace I leave with you, My peace I give to you; not as the world gives do I give to you. Let not your heart be troubled, neither let it be afraid. ");
INSERT INTO engemtv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","You have heard that I said to you, ‘I am going away and coming back to you.’ If you loved Me, you would have rejoiced that I said, ‘I am going to the Father,’ for My Father is greater than I. ");
INSERT INTO engemtv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","“And now I have told you before it happens, so that whenever it may happen, you may believe. ");
INSERT INTO engemtv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","I will no longer speak many things with you, for the ruler of the world is coming, and he has nothing in Me. ");
INSERT INTO engemtv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","But that the world may know that I love the Father, and as the Father has charged Me, thus I do. Rise up, let us go from here. ");
INSERT INTO engemtv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“I am the true vine, and My Father is the vinedresser. ");
INSERT INTO engemtv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Every branch in Me which does not bear fruit He takes away; and every branch which bears fruit He prunes, so that it may bear more fruit. ");
INSERT INTO engemtv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","You are already clean because of the word which I have spoken to you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Abide in Me, and I in you. Just as the branch cannot bear fruit on its own, unless it abides in the vine, so neither can you unless you abide in Me. ");
INSERT INTO engemtv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","I am the vine, you are the branches. He who abides in Me, and I in him, bears much fruit; because apart from Me you can do nothing. ");
INSERT INTO engemtv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","If anyone does not abide in Me, he is cast out like a branch and dries up; and they gather them and throw them into the fire, and they are burned. ");
INSERT INTO engemtv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","If you abide in Me, and My words abide in you, you will ask whatever you may desire, and it shall be done for you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","By this My Father is glorified, that you may bear much fruit; and you will become My disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Just as the Father loved Me, I also have loved you; abide in My love. ");
INSERT INTO engemtv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","If you keep My commandments, you will abide in My love, just as I have kept My Father's commandments and I abide in His love. ");
INSERT INTO engemtv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“These things I have spoken to you, that My joy may abide in you, and that your joy may be full. ");
INSERT INTO engemtv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","This is My commandment, that you love one another as I have loved you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Greater love has no one than this, that one should lay down his life for his friends. ");
INSERT INTO engemtv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","You are My friends if you do what I command you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","No longer do I call you servants, because a servant does not know what his master is doing; but I have called you friends, because all things which I heard from My Father I have made known to you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","You did not choose Me, but I chose you, and appointed you, that you should go and bear fruit, and that your fruit should remain, so that whatever you may ask the Father in My name He may give to you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","These things I command you, that you may love one another. ");
INSERT INTO engemtv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“If the world hates you, you know that it hated Me before it hated you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","If you were of the world, the world would love its own. Yet because you are not of the world, but I chose you out of the world, because of this the world hates you. ");
INSERT INTO engemtv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Remember the word which I said to you, ‘A servant is not greater than his master.’ If they persecuted Me, they will also persecute you. If they kept My word, they will keep yours also. ");
INSERT INTO engemtv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","But all these things they will do to you for My name's sake, because they do not know Him who sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","If I had not come and spoken to them, they would have no sin, but now they have no excuse for their sin. ");
INSERT INTO engemtv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","He who hates Me hates My Father also. ");
INSERT INTO engemtv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","If I had not done the works among them which no one else has done, they would have no sin; but now they have both seen and they have hated both Me and My Father. ");
INSERT INTO engemtv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","But this was so that the word might be fulfilled which is written in their law, ‘They hated Me without a cause.’ ");
INSERT INTO engemtv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“But when the Helper comes, whom I shall send to you from the Father, the Spirit of truth who proceeds from the Father, He will testify about Me. ");
INSERT INTO engemtv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","And you also will testify, because you have been with Me from the beginning. ");
INSERT INTO engemtv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","These things I have spoken to you, so that you should not be made to stumble. ");
INSERT INTO engemtv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","They will excommunicate you; but the time is coming when everyone who kills you will think that he is offering God a service. ");
INSERT INTO engemtv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","And these things they will do to you because they did not know the Father nor Me. ");
INSERT INTO engemtv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","But these things I have spoken to you, so that when the time comes, you may remember them, that I told you. But these things I did not say to you from the beginning, because I was with you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“But now I am going to Him who sent Me, and none of you asks Me, ‘Where are You going?’ ");
INSERT INTO engemtv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","But because I have spoken these things to you, sorrow has filled your heart. ");
INSERT INTO engemtv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nevertheless I speak the truth to you. It is profitable for you that I go away; for if I do not go away, the Helper will not come to you; but if I depart, I will send Him to you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","And when He comes, He will convict the world of sin, and of righteousness, and of judgment: ");
INSERT INTO engemtv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","of sin, because they do not believe in Me; ");
INSERT INTO engemtv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","of righteousness, because I am going to My Father and you see Me no more; ");
INSERT INTO engemtv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","of judgment, because the ruler of this world has been judged. ");
INSERT INTO engemtv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“I still have many things to say to you, but you cannot bear them now. ");
INSERT INTO engemtv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","However, when He, the Spirit of truth, has come, He will guide you into all truth; for He will not speak on His own authority, but whatever He hears He will speak; and He will announce to you things to come. ");
INSERT INTO engemtv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","He will glorify Me, for He will take from what is Mine and He will announce it to you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","All things which the Father has are Mine. Therefore I said that He takes from what is Mine and will announce it to you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“A little while and you will not see Me; and again a little while and you will see Me, because I am going to the Father.” ");
INSERT INTO engemtv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Then some of His disciples said to one another, “What is this that He says to us, ‘A little while and you will not see Me; and again a little while and you will see Me’; and, ‘I am going to the Father’?” ");
INSERT INTO engemtv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Therefore they said, “What is this that He says, ‘A little while’? We do not understand what He is saying.” ");
INSERT INTO engemtv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Now Jesus knew that they were desiring to ask Him, and He said to them, “Are you inquiring with one another that I said, ‘A little while and you will not see Me; and again a little while and you will see Me’? ");
INSERT INTO engemtv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Most assuredly I say to you that you will weep and lament, but the world will rejoice; and you will be grieved, but your grief will be turned into joy. ");
INSERT INTO engemtv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A woman, whenever she gives birth, has sorrow, because her hour has come; but whenever the child is born, she no longer remembers the anguish, on account of the joy that a child has been born into the world. ");
INSERT INTO engemtv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Therefore you also now have sorrow; but I will see you again and your heart will rejoice, and your joy no one will take from you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","And in that day you will ask Me nothing. Most assuredly, I say to you, whatever you ask the Father in My name He will give you. ");
INSERT INTO engemtv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Until now you have asked nothing in My name. Ask, and you will receive, that your joy may be full. ");
INSERT INTO engemtv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“These things I have spoken to you in figures of speech; but the time is coming when I will no longer speak to you in figures of speech, but I will tell you plainly about the Father. ");
INSERT INTO engemtv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In that day you will ask in My name, and I do not say to you that I will beseech the Father for you; ");
INSERT INTO engemtv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","for the Father Himself loves you, because you have loved Me, and have believed that I came forth from God. ");
INSERT INTO engemtv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","I came forth from the Father and I have come into the world. Again, I am leaving the world and I am going to the Father.” ");
INSERT INTO engemtv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","His disciples said to Him, “See, now You are speaking plainly, and using no figure of speech! ");
INSERT INTO engemtv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now we are sure that You know all things, and have no need that anyone should question You. By this we believe that You came forth from God.” ");
INSERT INTO engemtv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus answered them, “Now do you believe? ");
INSERT INTO engemtv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Behold, the hour is coming, and has now come, that you will be scattered, each to his own, and you will leave Me alone. And yet I am not alone, because the Father is with Me. ");
INSERT INTO engemtv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","These things I have spoken to you, that in Me you may have peace. In the world you have tribulation; but take courage, I have overcome the world.” ");
INSERT INTO engemtv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus spoke these words, lifted up His eyes to heaven, and said: “Father, the time has come. Glorify Your Son, that Your Son also may glorify You, ");
INSERT INTO engemtv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","just as You have given Him authority over all flesh, so that He will give eternal life to all You have given Him. ");
INSERT INTO engemtv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","And this is eternal life, that they may know You, the only true God, and Jesus Christ, whom You have sent. ");
INSERT INTO engemtv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","I have glorified You on the earth. I have finished the work which You have given Me to do. ");
INSERT INTO engemtv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","And now, O Father, glorify Me alongside Yourself, with the glory which I had with You before the world was. ");
INSERT INTO engemtv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“I have manifested Your name to the men whom You have given Me out of the world. They were Yours, You have given them to Me, and they have kept Your word. ");
INSERT INTO engemtv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Now they have known that all things which You have given Me are from You. ");
INSERT INTO engemtv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Because I have given to them the words which You have given Me; and they have received them, and they knew truly that I came forth from You; and they have believed that You sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“I pray for them. I do not pray for the world but for those whom You have given Me, for they are Yours. ");
INSERT INTO engemtv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","And all Mine are Yours, and Yours are Mine, and I have been glorified in them. ");
INSERT INTO engemtv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","And I am no longer in the world, yet these are in the world, and I am coming to You. Holy Father, keep them in Your name which You have given to Me, that they may be one just as We are. ");
INSERT INTO engemtv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","When I was with them in the world, I kept them in Your name. Those whom You have given to Me I guarded; and not one of them is lost except the son of perdition, so that the Scripture might be fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","But now I am coming to You, and these things I speak in the world, so that they may have My joy fulfilled in themselves. ");
INSERT INTO engemtv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","I have given them Your word; and the world has hated them because they are not of the world, just as I am not of the world. ");
INSERT INTO engemtv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I do not ask that You should take them out of the world, but that You should keep them from the evil one. ");
INSERT INTO engemtv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","They are not of the world, just as I am not of the world. ");
INSERT INTO engemtv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sanctify them by Your truth; Your word is truth. ");
INSERT INTO engemtv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Just as You sent Me into the world, I also have sent them into the world. ");
INSERT INTO engemtv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","And for their sakes I sanctify Myself, that they also may be sanctified by the truth. ");
INSERT INTO engemtv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“I am not praying for these alone, but also for those who believe in Me through their word; ");
INSERT INTO engemtv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","so that they all may be one, just as You, Father, are in Me, and I in You; that they also may be one in Us, so that the world may believe that You sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","And the glory which You have given to Me, I have given to them, so that they may be one just as We are one: ");
INSERT INTO engemtv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I in them, and You in Me; so that they may be perfected in unity, and so that the world may know that You have sent Me, and You loved them just as You loved Me. ");
INSERT INTO engemtv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Father, I desire that those also whom You gave Me may be with Me where I am, so that they may behold My glory which You gave to Me; because You loved Me before the foundation of the world. ");
INSERT INTO engemtv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O righteous Father! Indeed the world has not known You, but I have known You; and these have known that You sent Me. ");
INSERT INTO engemtv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","And I made known to them Your name, and I will make it known, so that the love with which You loved Me may be in them, and I in them.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","After saying these things, Jesus went out with His disciples across the winter stream Kidron, where there was a garden, into which He and His disciples entered. ");
INSERT INTO engemtv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Now Judas, who was betraying Him, also knew the place, because Jesus often gathered there also with His disciples. ");
INSERT INTO engemtv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Then Judas, having taken the detachment of soldiers and attendants from the chief priests and Pharisees, came there with lanterns, torches, and weapons. ");
INSERT INTO engemtv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus therefore, knowing all things coming upon Him, went out and said to them, “Whom do you seek?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","They answered Him, “Jesus the Nazarene.” Jesus said to them, “I AM.” And Judas, the one betraying Him, was standing with them. ");
INSERT INTO engemtv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Therefore when He said to them, “I AM,” they stepped back and fell to the ground. ");
INSERT INTO engemtv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Then He asked them again, “Whom do you seek?” And they said, “Jesus the Nazarene.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus answered, “I have told you that I AM! Therefore if you seek Me, allow these men to go,” ");
INSERT INTO engemtv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","so that the word might be fulfilled which He said, “Those whom You have given Me I have lost none.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Then Simon Peter, having a sword, drew it and struck the servant of the high priest, and cut off his right ear. And the servant's name was Malchus. ");
INSERT INTO engemtv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Then Jesus said to Peter, “Put your sword into its sheath. Shall I not drink the cup which My Father has given Me?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Then the detachment of soldiers and the captain and the attendants of the Jews arrested Jesus and bound Him. ");
INSERT INTO engemtv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","And they led Him away to Annas first, for he was the father-in-law of Caiaphas who was high priest that year. ");
INSERT INTO engemtv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Now it was Caiaphas who advised the Jews that it was profitable for one man to perish for the people. ");
INSERT INTO engemtv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","And Simon Peter was following Jesus, as was the other disciple. Now that disciple was known to the high priest, and entered with Jesus into the courtyard of the high priest. ");
INSERT INTO engemtv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","But Peter stood at the door outside. Then the other disciple, who was known to the high priest, went out and spoke to the doorkeeper, and brought Peter in. ");
INSERT INTO engemtv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Then the servant girl who kept the door said to Peter, “You are not also one of this Man's disciples, are you?” He said, “I am not.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","And the servants and attendants who had made a fire of coals stood there, for it was cold, and they were warming themselves. Now Peter was standing with them and warming himself. ");
INSERT INTO engemtv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Then high priest asked Jesus about His disciples and His doctrine. ");
INSERT INTO engemtv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus answered him, “I spoke openly to the world. I always taught in synagogues and in the temple, where the Jews always come together, and in secret I spoke nothing. ");
INSERT INTO engemtv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Why do you question Me? Question those who have heard Me, what I spoke to them. Indeed they know what I said.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","And when He had said these things, one of the attendants who stood by slapped Jesus with the palm of his hand, saying, “Is this how You answer the high priest?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus answered him, “If I have spoken evil, testify of the evil; but if well, why do you strike Me?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Then Annas sent Him bound to Caiaphas the high priest. ");
INSERT INTO engemtv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Now Simon Peter was standing and warming himself. Therefore they said to him, “You are not also one of His disciples, are you?” Then he denied it and said, “I am not!” ");
INSERT INTO engemtv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","One of the servants of the high priest, a relative of him whose ear Peter cut off, said, “Did I not see you in the garden with Him?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter then denied again; and immediately a rooster crowed. ");
INSERT INTO engemtv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Then they led Jesus from Caiaphas to the Praetorium, and it was early morning. But they themselves did not enter into the Praetorium, lest they might be defiled, but so that they might eat the Passover. ");
INSERT INTO engemtv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Then Pilate went out to them and said, “What accusation do you bring against this Man?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","They answered and said to him, “If He were not an evildoer, we would not have delivered Him over to you.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Then Pilate said to them, “You take Him and judge Him according to your law.” Therefore the Jews said to him, “It is not lawful for us to kill anyone,” ");
INSERT INTO engemtv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","that the word of Jesus might be fulfilled which He said, signifying by what sort of death He was about to die. ");
INSERT INTO engemtv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Then Pilate entered the Praetorium again, and called Jesus, and said to Him, “Are You the King of the Jews?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus answered him, “For yourself do you say this, or did others tell you about Me?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate answered, “Am I a Jew? Your own nation and the chief priests have delivered You to me. What have You done?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus answered, “My kingdom is not of this world. If My kingdom were of this world, My servants would fight, so that I might not be delivered to the Jews; but now My kingdom is not from here.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate therefore said to Him, “Are You a king then?” Jesus answered, “You say rightly that I am a king. For this reason I have been born, and for this reason I have come into the world, that I should testify to the truth. Everyone who is of the truth hears My voice.” ");
INSERT INTO engemtv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate said to Him, “What is truth?” And having said this, he went out again to the Jews, and said to them, “I find no fault in Him. ");
INSERT INTO engemtv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“But you have a custom that I should release someone to you at the Passover. Therefore do you wish that I should release the King of the Jews?” ");
INSERT INTO engemtv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Then they all cried out again, saying, “Not this Man, but Barabbas!” Now Barabbas was a bandit. ");
INSERT INTO engemtv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","So then Pilate took Jesus and flogged Him. ");
INSERT INTO engemtv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","And the soldiers twisted a crown out of thorns and put it on His head, and they put a purple robe around Him. ");
INSERT INTO engemtv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","And they kept saying, “Hail, King of the Jews!” And they were striking Him with their hands. ");
INSERT INTO engemtv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate then went out again, and said to them, “Behold, I am bringing Him out to you, so that you may know that I find no fault in Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Then Jesus came out, wearing the crown of thorns and the purple robe. And Pilate said to them, “Behold, the Man!” ");
INSERT INTO engemtv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Therefore, when the chief priests and the attendants saw Him, they cried out, saying, “Crucify, crucify Him!” Pilate said to them, “You take Him and crucify Him, for I find no fault in Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","The Jews answered him, “We have a law, and according to our law He ought to die, because He made Himself the Son of God.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Therefore, when Pilate heard this saying, he was even more afraid, ");
INSERT INTO engemtv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","and he entered into the Praetorium again, and said to Jesus, “Where are You from?” But Jesus gave him no answer. ");
INSERT INTO engemtv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Then Pilate said to Him, “Are You not speaking to me? Do You not know that I have authority to crucify You, and I have authority to release You?” ");
INSERT INTO engemtv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus answered, “You would have no authority at all against Me unless it had been given to you from above. Therefore the one who betrayed Me to you has a greater sin.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","From this point Pilate was seeking to release Him, but the Jews kept crying out, saying, “If you release this Man, you are no friend of Caesar's. Whoever makes himself a king speaks against Caesar.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Therefore Pilate, having heard this saying, led Jesus outside and sat down on the judgment seat in a place that is called The Pavement, but in Hebrew, Gabbatha. ");
INSERT INTO engemtv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Now it was the Preparation Day of the Passover, and about the sixth hour. And he said to the Jews, “Behold your King!” ");
INSERT INTO engemtv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","But they cried out, “Away with Him, away with Him! Crucify Him!” Pilate said to them, “Shall I crucify your King?” The chief priests answered, “We have no king but Caesar!” ");
INSERT INTO engemtv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Then he delivered Him to them to be crucified. So they took Jesus and led Him away. ");
INSERT INTO engemtv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","And bearing His cross, He went out to a place called the Place of a Skull, which is called in Hebrew, Golgotha, ");
INSERT INTO engemtv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","where they crucified Him, and two others with Him, one on each side, and Jesus in the middle. ");
INSERT INTO engemtv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Now Pilate wrote a title and he put it on the cross. And it was written: JESUS THE NAZARENE, THE KING OF THE JEWS. ");
INSERT INTO engemtv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Then many of the Jews read this title, because the place where Jesus was crucified was near the city; and it was written in Hebrew, in Greek, and in Latin. ");
INSERT INTO engemtv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Therefore the chief priests of the Jews said to Pilate, “Do not write, ‘The King of the Jews,’ but, ‘He said, “I am the King of the Jews.” ’ ” ");
INSERT INTO engemtv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate answered, “What I have written, I have written.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Then the soldiers, when they crucified Jesus, took His garments and made four parts, to each soldier a part, and also the tunic. Now the tunic was seamless, woven from the top in one piece. ");
INSERT INTO engemtv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Therefore they said to one another, “Let us not tear it, but let us cast lots for it, whose it will be,” so that the Scripture might be fulfilled which says: “They divided My garments among them, and for My clothing they cast lots.” Therefore the soldiers did these things. ");
INSERT INTO engemtv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Now there stood by the cross of Jesus His mother, and His mother's sister, Mary the wife of Clopas, and Mary Magdalene. ");
INSERT INTO engemtv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Therefore Jesus, seeing His mother, and the disciple whom He loved standing by, He said to His mother, “Woman, behold your son!” ");
INSERT INTO engemtv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Then He said to the disciple, “Behold your mother!” And from that hour that disciple took her into his own care. ");
INSERT INTO engemtv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","After this, Jesus, seeing that all things already had been fulfilled, so that the Scripture might be fulfilled, He said, “I thirst!” ");
INSERT INTO engemtv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Now a vessel was set full of sour wine; and they, having filled a sponge with sour wine, put it around a hyssop, they held it to His mouth. ");
INSERT INTO engemtv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Therefore when Jesus received the sour wine, He said, “It is finished!” And bowing His head, He gave up His spirit. ");
INSERT INTO engemtv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Therefore the Jews, since it was the Preparation Day, that the bodies should not remain on the cross on the Sabbath (for that Sabbath was a high day), asked Pilate that their legs might be broken, and they might be taken away. ");
INSERT INTO engemtv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Then the soldiers came and they broke the legs of the first man, and of the other who was crucified with Him. ");
INSERT INTO engemtv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","But having come to Jesus, when they saw that He was already dead, they did not break His legs. ");
INSERT INTO engemtv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","But one of the soldiers pierced His side with a spear, and immediately blood and water came out. ");
INSERT INTO engemtv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","And he who has seen has testified, and his testimony is true; and he knows that he tells the truth, so that you may believe. ");
INSERT INTO engemtv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","For these things were done that the Scripture should be fulfilled, “Not a bone of His shall be broken.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","And again another Scripture says, “They shall look at Him whom they pierced.” ");
INSERT INTO engemtv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","After these things, Joseph of Arimathea, being a disciple of Jesus, but secretly, for fear of the Jews, asked Pilate that he might take away the body of Jesus; and Pilate gave him permission. So he came and took away the body of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","And Nicodemus, who at first came to Jesus by night, also came, bringing a mixture of myrrh and aloes, about a hundred pounds. ");
INSERT INTO engemtv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Then they took the body of Jesus, and bound it in linen strips with the spices, as the custom of the Jews is to bury. ");
INSERT INTO engemtv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Now in the place where He was crucified there was a garden, and in the garden a new tomb in which no one had yet been buried. ");
INSERT INTO engemtv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","So there they laid Jesus, because of the Jews' Preparation Day, because the tomb was near. ");
INSERT INTO engemtv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","On the first day of the week Mary Magdalene went to the tomb early, while it was still dark, and saw that the stone had been taken away from the tomb. ");
INSERT INTO engemtv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Therefore she ran and came to Simon Peter, and to the other disciple, whom Jesus loved, and said to them, “They have taken the Lord out of the tomb, and we do not know where they have laid Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter therefore went out, and the other disciple, and were going to the tomb. ");
INSERT INTO engemtv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","And the two together were running, and the other disciple outran Peter and came to the tomb first. ");
INSERT INTO engemtv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","And stooping to look in, he saw the linen strips lying there; however he did not go in. ");
INSERT INTO engemtv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Then Simon Peter came, following him, and entered into the tomb; and he saw the linen strips lying there, ");
INSERT INTO engemtv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","and the facecloth which had been on His head, not lying with the linen strips, but apart from them, having been rolled up in one place. ");
INSERT INTO engemtv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Then the other disciple, who came to the tomb first, went in also; and he saw and believed. ");
INSERT INTO engemtv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","For as yet they did not know the Scripture, that He must rise again from the dead. ");
INSERT INTO engemtv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Then the disciples went away again to their own homes. ");
INSERT INTO engemtv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","But Mary stood outside facing the tomb weeping. Therefore as she was weeping, she stooped down and looked into the tomb. ");
INSERT INTO engemtv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","And she saw two angels in white sitting, one at the head and the other at the feet, where the body of Jesus had lain. ");
INSERT INTO engemtv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Then they said to her, “Woman, why are you weeping?” She said to them, “Because they have taken away my Lord, and I do not know where they put Him.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","And having said these things, she turned back and saw Jesus standing there, and did not know that it was Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus said to her, “Woman, why are you weeping? Whom do you seek?” She, supposing Him to be the gardener, said to Him, “Sir, if You carried Him away, tell me where You put Him, and I will take Him away.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus said to her, “Mary!” She turned and said to Him, “Rabboni!” (which means, Teacher). ");
INSERT INTO engemtv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus said to her, “Do not cling to Me, for I have not yet ascended to My Father; but go to My brothers and say to them, ‘I am ascending to My Father and your Father, and to My God and your God.’ ” ");
INSERT INTO engemtv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene went reporting to the disciples that she had seen the Lord, and that He had spoken these things to her. ");
INSERT INTO engemtv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Then, the same day at evening, being the first day of the week, when the doors were shut where the disciples were assembled, for fear of the Jews, Jesus came and stood in the midst, and said to them, “Peace to you.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","And having said this, He showed them His hands and His side. Then the disciples rejoiced when they saw the Lord. ");
INSERT INTO engemtv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Therefore Jesus said to them again, “Peace to you! Just as the Father has sent Me, I also send you.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","And when He had said this, He breathed on them, and said to them, “Receive the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","If you forgive the sins of any, they are forgiven them; if you retain the sins of any, they have been retained.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","But Thomas, one of the twelve, the one called the Twin, was not with them when Jesus came. ");
INSERT INTO engemtv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","The other disciples therefore said to him, “We have seen the Lord.” So he said to them, “Unless I see in His hands the print of the nails, and put my finger into the print of the nails, and put my hand into His side, I will by no means believe.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","And after eight days His disciples were again inside, and Thomas with them. Jesus came, the doors having been closed, and stood in the midst, and said, “Peace to you!” ");
INSERT INTO engemtv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Then He said to Thomas, “Bring your finger here, and see My hands; and bring your hand here, and put it into My side. Be not unbelieving, but believing.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","And Thomas answered and said to Him, “My Lord and my God!” ");
INSERT INTO engemtv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus said to him, “Because you have seen Me, you have believed. Blessed are those who have not seen and yet have believed.” ");
INSERT INTO engemtv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","And truly Jesus did many other signs in the presence of His disciples, which are not written in this book; ");
INSERT INTO engemtv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","but these have been written so that you may believe that Jesus is the Christ, the Son of God, and that by believing you may have life in His name. ");
INSERT INTO engemtv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","After these things Jesus showed Himself again to the disciples at the Sea of Tiberias, and in this manner He showed Himself: ");
INSERT INTO engemtv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas called the Twin, Nathanael of Cana in Galilee, the sons of Zebedee, and two others of His disciples were together. ");
INSERT INTO engemtv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter said to them, “I am going fishing.” They said to him, “We are coming with you also.” They went out and immediately got into the boat, and that night they caught nothing. ");
INSERT INTO engemtv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","But as daybreak had already come, Jesus stood upon the shore; however the disciples did not know that it was Jesus. ");
INSERT INTO engemtv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Then Jesus said to them, “Children, have you any food?” They answered Him, “No.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","And He said to them, “Cast the net on the right side of the boat, and you will find some.” Therefore they cast, and they were not able to haul it in because of the multitude of fish. ");
INSERT INTO engemtv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Therefore that disciple whom Jesus loved said to Peter, “It is the Lord!” Now when Simon Peter heard that it was the Lord, he put on his outer garment (for he had removed it), and he threw himself into the sea. ");
INSERT INTO engemtv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","But the other disciples came in the little boat (for they were not far from the land, but about two hundred cubits), dragging the net with fish. ");
INSERT INTO engemtv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Then as they got off onto the land, they saw a charcoal fire laid there, and fish placed on it, and bread. ");
INSERT INTO engemtv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus said to them, “Bring some of the fish which you have just caught.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter went up and hauled the net onto the land, full of large fish, one hundred and fifty-three; and although there were so many, the net was not torn. ");
INSERT INTO engemtv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus said to them, “Come, eat breakfast.” Yet none of the disciples dared ask Him, “Who are You?”—knowing that it was the Lord. ");
INSERT INTO engemtv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus then came and took the bread and gave it to them, and likewise the fish. ");
INSERT INTO engemtv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","This was now the third time Jesus was manifested to His disciples, having been raised from the dead. ");
INSERT INTO engemtv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","So when they had eaten breakfast, Jesus said to Simon Peter, “Simon, son of Jonah, do you love Me more than these?” He said to Him, “Yes, Lord; You know that I care for You.” He said to him, “Feed My lambs.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","He said to him again a second time, “Simon, son of Jonah, do you love Me?” He said to Him, “Yes, Lord; You know that I care for You.” He said to him, “Shepherd My sheep.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","He said to him the third time, “Simon, son of Jonah, do you care for Me?” Peter was grieved because He said to him the third time, “Do you care for Me?” And he said to Him, “Lord, You know all things; You know that I care for You.” Jesus said to him, “Feed My sheep. ");
INSERT INTO engemtv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Most assuredly I say to you, when you were younger, you used to dress yourself and used to walk where you wished; but when you are old, you will stretch out your hands, and another will dress you and will carry you where you do not wish.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","But this He said, signifying by what kind of death he would glorify God. And when He had spoken this, He said to him, “Follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Then Peter, turning around, saw the disciple whom Jesus loved following, who also had reclined on His chest at the supper, and said, “Lord, who is the one who betrays You?” ");
INSERT INTO engemtv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter, seeing him, said to Jesus, “But Lord, what about this man?” ");
INSERT INTO engemtv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus said to him, “If I will that he remain till I come, what is that to you? You follow Me.” ");
INSERT INTO engemtv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Therefore this saying went out among the brothers that this disciple would not die. Yet Jesus did not say to him that he would not die, but, “If I will that he remain till I come, what is that to you?” ");
INSERT INTO engemtv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","This is the disciple who testifies of these things, and wrote these things; and we know that his testimony is true. ");
INSERT INTO engemtv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","And there are also many other things which Jesus did, which if they were written one by one, I suppose that not even the world itself would have room for the books which would be written. Amen. ");
INSERT INTO engemtv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","The former account I made concerning all things, O Theophilus, which Jesus began both to do and teach, ");
INSERT INTO engemtv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","until the day in which He was taken up, after He through the Holy Spirit had given commandments to the apostles whom He had chosen, ");
INSERT INTO engemtv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","to whom He also presented Himself alive after His suffering by many convincing proofs, appearing to them during forty days and speaking of the things concerning the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","And being assembled together with them, He commanded them not to leave Jerusalem, but to await for the promise of the Father, “which,” He said, “you have heard from Me; ");
INSERT INTO engemtv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","for John baptized with water, but you shall be baptized with the Holy Spirit not many days from now.” ");
INSERT INTO engemtv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Therefore, when they had come together, they asked Him, saying, “Lord, will You at this time restore the kingdom to Israel?” ");
INSERT INTO engemtv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","And He said to them, “It is not for you to know times or seasons which the Father has placed in His own authority. ");
INSERT INTO engemtv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","But you shall receive power when the Holy Spirit has come upon you; and you shall be witnesses to Me in Jerusalem, and in all Judea and Samaria, and to the end of the earth.” ");
INSERT INTO engemtv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Now after He said these things, while they were beholding Him, He was lifted up, and a cloud withdrew Him from their sight. ");
INSERT INTO engemtv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","And while they looked intently into heaven, while He was going, behold, two men stood along side them in white apparel, ");
INSERT INTO engemtv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","who also said, “Men of Galilee, why do you stand looking up into heaven? This same Jesus, who was taken up from you into heaven, will so come in like manner as you watched Him go into heaven.” ");
INSERT INTO engemtv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Then they returned to Jerusalem from the mount called Olivet, which is near Jerusalem, a Sabbath day's journey. ");
INSERT INTO engemtv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","And when they had entered, they went up into the upper room where they were staying; both Peter and James and John and Andrew, Philip and Thomas, Bartholomew and Matthew, James the son of Alphaeus and Simon the Zealot, and Judas the son of James. ");
INSERT INTO engemtv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","These were continuing with one mind in prayer and petition, together with the women and Mary the mother of Jesus, and with His brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","And in those days Peter, rising up in the midst of the disciples (altogether the number of names was about a hundred and twenty), said, ");
INSERT INTO engemtv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Men and brothers; it was necessary for this Scripture to be fulfilled, which the Holy Spirit spoke before by the mouth of David concerning Judas, who became a guide to those who arrested Jesus; ");
INSERT INTO engemtv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","‘for he was numbered with us and obtained a portion in this ministry.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Now this man purchased a field by means of the wages of his iniquity, and falling headlong, he burst open in the middle and all his intestines gushed out. ");
INSERT INTO engemtv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","And it became known to all those dwelling in Jerusalem; so that field is called in their own language, Akel Dama, that is, Field of Blood). ");
INSERT INTO engemtv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“For it is written in the book of Psalms: ‘Let his homestead become desolate, and let no one dwell in it’; and, ‘May another take his office of overseer.’ ");
INSERT INTO engemtv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Therefore, of these men who have accompanied us in every time that the Lord Jesus went in and out among us, ");
INSERT INTO engemtv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","beginning from the baptism of John until the day in which He was taken up from us, one of these must become a witness with us of His resurrection.” ");
INSERT INTO engemtv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","And they nominated two: Joseph who is called Barsabas, who was surnamed Justus, and Matthias. ");
INSERT INTO engemtv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","And they prayed and said, “You, O Lord, knower of all hearts, show whom You have chosen of these two ");
INSERT INTO engemtv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","to receive a portion in this ministry and apostleship, from which Judas turned aside to go to his own place.” ");
INSERT INTO engemtv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","And they cast their lots. And the lot fell on Matthias; and he was numbered with the eleven apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","And when the day of Pentecost had fully come, they were all with one accord in one place. ");
INSERT INTO engemtv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","And suddenly a sound came out of heaven, as being borne along by a violent wind, and it filled the whole house where they were sitting. ");
INSERT INTO engemtv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Then there appeared to them divided tongues, as of fire, and rested on each one of them. ");
INSERT INTO engemtv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","And they were all filled with the Holy Spirit, and began to speak in different languages, as the Spirit gave them utterance. ");
INSERT INTO engemtv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","And there were dwelling in Jerusalem Jews, devout men, from every nation of those under heaven. ");
INSERT INTO engemtv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","And when this sound occurred, the multitude came together, and were confounded, because they were hearing each one speaking in his own language. ");
INSERT INTO engemtv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","And they were all amazed and were marveling, saying to one another, “Behold, are not all these who are speaking Galileans? ");
INSERT INTO engemtv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","And how is it that we hear, each in our own language in which we were born? ");
INSERT INTO engemtv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parthians and Medes and Elamites, those dwelling in Mesopotamia, Judea and Cappadocia, Pontus and Asia, ");
INSERT INTO engemtv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia and Pamphylia, Egypt and the parts of Libya toward Cyrene, visitors from Rome, both Jews and proselytes, ");
INSERT INTO engemtv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretans and Arabs—we hear them speaking in our own tongues the mighty deeds of God.” ");
INSERT INTO engemtv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","So they were all amazed and perplexed, saying to one another, “What does this mean?” ");
INSERT INTO engemtv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Others were mocking and saying, “They are full of new wine.” ");
INSERT INTO engemtv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","But Peter, standing up with the eleven, lifted up his voice and spoke out to them, “Men of Judea and all who dwell in Jerusalem, let this be known to you, and give ear to my words. ");
INSERT INTO engemtv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","For these are not drunk, as you suppose, for it is just the third hour of the day. ");
INSERT INTO engemtv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","But this is what was spoken by the prophet Joel: ");
INSERT INTO engemtv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘ “And it shall be in the last days,” says God, “that I will pour out My Spirit on all flesh, and your sons and your daughters shall prophesy; and your young men shall see visions, and your old men shall dream dreams; ");
INSERT INTO engemtv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","and on My menservants and on My maidservants I will pour out My Spirit in those days; and they shall prophesy. ");
INSERT INTO engemtv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","And I will give wonders in the heaven above, and signs on the earth below, blood and fire and vapor of smoke. ");
INSERT INTO engemtv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","The sun shall be turned into darkness, and the moon into blood, before the coming of the great and magnificent Day of the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","And it shall be that everyone who calls on the name of the Lord shall be saved.” ’ ");
INSERT INTO engemtv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Men of Israel, hear these words: Jesus of Nazareth, a Man attested by God to you by miracles, wonders, and signs which God did through Him in your midst, just as you yourselves also know— ");
INSERT INTO engemtv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Him, being delivered by the determined counsel and foreknowledge of God, you took, and by lawless hands, nailing Him to a cross, you killed Him; ");
INSERT INTO engemtv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","whom God raised, thus doing away with the labor pains of death, because it was not possible for Him to be held by it. ");
INSERT INTO engemtv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","For David says concerning Him, ‘I foresaw the Lord always before me, because He is at my right hand, that I may not be shaken. ");
INSERT INTO engemtv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Therefore my heart was glad, and my tongue rejoiced; moreover my flesh also will dwell in hope. ");
INSERT INTO engemtv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Because You will not abandon my soul in Hades, nor will You allow Your Holy One to see corruption. ");
INSERT INTO engemtv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","You have made known to me the ways of life; You will fill me full of joy with Your presence.’ ");
INSERT INTO engemtv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Men, brothers, let me speak with boldness to you about the patriarch David, that he both died and was buried, and his tomb is with us to this day. ");
INSERT INTO engemtv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Therefore, being a prophet, and knowing that God had sworn with an oath to him that of the fruit of his loins, according to the flesh, He would raise up the Christ to seat Him on his throne, ");
INSERT INTO engemtv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","foreseeing this, he spoke about the resurrection of the Christ, ‘that His soul was not left in Hades, nor did His flesh see corruption.’ ");
INSERT INTO engemtv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","This Jesus God has raised up, of which we all are witnesses. ");
INSERT INTO engemtv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Therefore having being exalted to the right hand of God, and having received from the Father the promise of the Holy Spirit, He poured out this which you now see and hear. ");
INSERT INTO engemtv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","For David did not ascend into the heavens, but he says himself: ‘The Lord said to my Lord, “Sit at My right hand, ");
INSERT INTO engemtv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","till I make Your enemies a footstool for Your feet.” ’ ");
INSERT INTO engemtv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Therefore let all the house of Israel know assuredly that God has made this Jesus, whom you crucified, both Lord and Christ.” ");
INSERT INTO engemtv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Now having heard this, they were cut to the heart, and they said to Peter and the rest of the apostles, “Men and brothers, what shall we do?” ");
INSERT INTO engemtv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Then Peter said to them, “Repent, and let each of you be baptized in the name of Jesus Christ for the forgiveness of sins; and you shall receive the gift of the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","For the promise is for you and for your children, and for all who are far off, as many as the Lord our God will call.” ");
INSERT INTO engemtv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","And with many other words he testified and exhorted them, saying, “Be saved from this crooked generation.” ");
INSERT INTO engemtv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Then those who gladly received his word were baptized; and that day about three thousand souls were added. ");
INSERT INTO engemtv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","And they were continuing in the teaching of the apostles, and in fellowship, and in the breaking of bread, and in prayers. ");
INSERT INTO engemtv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Then fear came upon every soul, and many wonders and signs were taking place through the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Now all who believed were together, and they had all things in common, ");
INSERT INTO engemtv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","and they were selling their possessions and goods, and were dividing them among all, to the degree that anyone had need. ");
INSERT INTO engemtv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","So continuing daily with one accord in the temple, and breaking bread from house to house, they were sharing food with joy and simplicity of heart, ");
INSERT INTO engemtv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","praising God and having favor with all the people. And the Lord was adding to the church daily those who were being saved. ");
INSERT INTO engemtv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Now Peter and John were going up together to the temple at the hour of prayer, which was the ninth hour. ");
INSERT INTO engemtv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","And a man lame from his mother's womb was being carried, whom they would lay each day at the gate of the temple which is called Beautiful, to ask alms from those who entered the temple; ");
INSERT INTO engemtv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","who, when he saw Peter and John about to enter into the temple, began asking for alms. ");
INSERT INTO engemtv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","And looking intently on him, Peter together with John, said, “Look at us.” ");
INSERT INTO engemtv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","And he fixed his attention on them, expecting to receive something from them. ");
INSERT INTO engemtv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","But Peter said, “Silver and gold I do not have, but that which I do have, I give to you: In the name of Jesus Christ the Nazarene, get up and walk.” ");
INSERT INTO engemtv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","And taking hold of him by his right hand, he raised him; and immediately his feet and ankles were strengthened. ");
INSERT INTO engemtv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","So he, leaping up, stood and walked and entered with them into the temple, walking and leaping, and praising God. ");
INSERT INTO engemtv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","And all the people saw him walking and praising God. ");
INSERT INTO engemtv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Then they recognized that this was the one sitting for the alms at the Beautiful Gate of the temple; and they were filled with astonishment and amazement because of that which had happened to him. ");
INSERT INTO engemtv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","And while the lame man who had been healed held on to Peter and John, all the people ran together to them in the porch which is called Solomon's, utterly astonished. ");
INSERT INTO engemtv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","So when Peter saw this, he replied to the people: “Men of Israel, why do you marvel at this? Or why look so intently at us, as though by our own power or godliness we had made him to walk? ");
INSERT INTO engemtv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","The God of Abraham, Isaac, and Jacob, the God of our fathers, glorified His Servant Jesus, whom you indeed delivered up and denied Him in the presence of Pilate, when he had decided to release Him. ");
INSERT INTO engemtv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","But you denied the Holy and Righteous One, and asked that a murderer be released to you, ");
INSERT INTO engemtv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","and killed the Author of life, whom God raised from the dead, of which we are witnesses. ");
INSERT INTO engemtv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","And on the basis of faith in His name, this one whom you observe and know, was made strong by His name. And the faith, which is by Him, has given to him this wholeness before you all. ");
INSERT INTO engemtv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“And now, brothers, I know that you acted in ignorance, as your rulers did also. ");
INSERT INTO engemtv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","But those things which God announced beforehand by the mouth of all His prophets, that the Christ would suffer, He has thus fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Repent therefore and turn back, that your sins may be wiped away, in order that times of refreshing may come from the presence of the Lord, ");
INSERT INTO engemtv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","and that He may send He who had been ordained to be your Messiah, Jesus, ");
INSERT INTO engemtv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","whom heaven must receive until the times of restoration of all things, which God has spoken by the mouth of all His holy prophets since the world began. ");
INSERT INTO engemtv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","For Moses said to the fathers, ‘The Lord our God will raise up for you a Prophet like me from your brothers. Him you shall hear in all things, whatever He says to you.’ ");
INSERT INTO engemtv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","‘And it shall be that every person who does not hear that Prophet shall be utterly destroyed from among the people.’ ");
INSERT INTO engemtv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yes, and all the prophets, from Samuel and his successors, as many as have spoken, have proclaimed these days. ");
INSERT INTO engemtv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","You are sons of the prophets, and of the covenant which God made with our fathers, saying to Abraham, ‘And in your offspring all the families of the earth shall be blessed.’ ");
INSERT INTO engemtv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","To you first, God, having raised up His Servant Jesus, sent Him to bless you, in turning away every one of you from your iniquities.” ");
INSERT INTO engemtv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Now while they were speaking to the people, the priests, the captain of the temple, and the Sadducees came upon them, ");
INSERT INTO engemtv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","being greatly annoyed because they were teaching the people and proclaiming in Jesus the resurrection of the dead. ");
INSERT INTO engemtv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","And they laid hands on them, and put them in custody until the next day, for it was already evening. ");
INSERT INTO engemtv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","However, many of those who heard the word believed; and the number of the men came to be about five thousand. ");
INSERT INTO engemtv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Now it came to pass on the next day, that their rulers, elders, and scribes were gathered together at Jerusalem, ");
INSERT INTO engemtv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","as well as Annas the high priest, Caiaphas, John, and Alexander, and as many as were of high priestly descent. ");
INSERT INTO engemtv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","And they brought them forward and began to inquire, “By what power or by what name have you done this?” ");
INSERT INTO engemtv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Then Peter, having been filled with the Holy Spirit, said to them, “Rulers of the people and elders of Israel: ");
INSERT INTO engemtv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","If we today are being judged for a good work to a weak man, by what means he has been made well, ");
INSERT INTO engemtv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","let it be known to you all, and to all the people of Israel, that by the name of Jesus Christ the Nazarene, whom you crucified, whom God raised from the dead, by this name this man stands here before you whole. ");
INSERT INTO engemtv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","This is the ‘stone which was rejected by you, the builders, which became the chief cornerstone.’ ");
INSERT INTO engemtv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nor is there salvation in no one else, for there is no other name under heaven which has been given among men by which we must be saved.” ");
INSERT INTO engemtv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Now when they observed the boldness of Peter and John, and understood that they were uneducated and untrained men, they marveled. And they recognized that they had been with Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","But seeing the man that had been healed standing with them, they had nothing to say against them. ");
INSERT INTO engemtv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","And they commanded them to go away outside the council, and began to confer among themselves, ");
INSERT INTO engemtv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","saying, “What shall we do to these men? For indeed, that a known sign has come to pass by them is evident to all those who are dwelling in Jerusalem, and we cannot deny it. ");
INSERT INTO engemtv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","But lest it be spread further among the people, let us threaten them with a threat, that they speak no longer to any man in this name.” ");
INSERT INTO engemtv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","And summoning them, they commanded them not to speak at all nor to teach in the name of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","But Peter and John answered them and said, “Whether it is right in the sight of God to listen to you rather than God, you be the judge. ");
INSERT INTO engemtv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","For we can do none other but to speak the things which we have seen and heard.” ");
INSERT INTO engemtv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","So having threatened them further, they released them, finding no way of punishing them, on account of the people, because they all were glorifying God over that which had occurred. ");
INSERT INTO engemtv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","For the man was over forty, on whom had come about this sign of healing. ");
INSERT INTO engemtv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","And being released, they came to their own, and reported all that the chief priests and elders had said to them. ");
INSERT INTO engemtv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","So when they heard that, they raised their voice to God with one mind and said: “Lord, You are God, who made heaven and the earth and the sea, and all that is in them, ");
INSERT INTO engemtv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","who by the mouth of Your servant David have said: ‘Why did the nations rage, and the people conspired vain things? ");
INSERT INTO engemtv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","The kings of the earth took their stand, and the rulers were assembled together against the Lord and against His Christ.’ ");
INSERT INTO engemtv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“For truly they were assembled against Your holy Servant Jesus, whom You anointed, both Herod and Pontius Pilate, with the Gentiles and the people of Israel, ");
INSERT INTO engemtv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","to do all that Your hand and Your counsel foreordained to come to pass. ");
INSERT INTO engemtv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Now, Lord, look upon their threats, and grant to Your servants that with all boldness they may speak Your word, ");
INSERT INTO engemtv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","by extending Your hand to heal, and that signs and wonders may come about through the name of Your holy Servant Jesus.” ");
INSERT INTO engemtv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","And when they had prayed, the place where they were gathered was shaken; and they were all filled with the Holy Spirit, and they spoke the word of God with boldness. ");
INSERT INTO engemtv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Now the multitude of those who believed were of one heart and one soul; neither did anyone say that any of the things belonging to him was his own, but they had all things in common. ");
INSERT INTO engemtv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","And with great power the apostles were giving forth their witness of the resurrection of the Lord Jesus. And great grace was upon them all. ");
INSERT INTO engemtv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nor was there anyone needy among them; for all who were owners of lands or houses were selling them, and were bringing the proceeds of the things which had been sold, ");
INSERT INTO engemtv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","and were placing them beside the feet of the apostles; and they were distributing to each, to the degree that anyone had need. ");
INSERT INTO engemtv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","And Joses, who was also named Barnabas by the apostles (which is translated Son of Encouragement), a Levite, a native of Cyprus, ");
INSERT INTO engemtv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","who, possessing a field, sold it and brought the money and placed it beside the feet of the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","But a certain man named Ananias, together with Sapphira his wife, sold a piece of property. ");
INSERT INTO engemtv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","And he kept back for himself from the price, his wife also being aware of it, and brought a certain part and placed it beside the feet of the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","But Peter said, “Ananias, why has Satan filled your heart for you to lie to the Holy Spirit, and for you to keep back for yourself from the price of the land? ");
INSERT INTO engemtv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","While it remained unsold, did it not remain yours? And after it was sold, was it not at your disposal? Why have you purposed this thing in your heart? You have not lied to men, but to God.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Then Ananias, hearing these words, fell down and died. And great fear came upon all those who heard of it. ");
INSERT INTO engemtv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","And the young men rose up and covered him up, carried him out, and buried him. ");
INSERT INTO engemtv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","And it happened about three hours later, that his wife, not knowing what had happened, came in. ");
INSERT INTO engemtv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","And Peter said to her, “Tell me whether you sold the land for so much?” She said, “Yes, for so much.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Then Peter said to her, “Why is it that it was agreed by you to tempt the Spirit of the Lord? Behold, the feet of those who have buried your husband are at the door, and they shall carry you out as well.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Then immediately she fell down beside his feet and died. And the young men came in and found her dead, and carrying her out, buried her with her husband. ");
INSERT INTO engemtv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","And great fear fell on all the church, and upon all those who were hearing these things. ");
INSERT INTO engemtv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Now by the hands of the apostles, many signs and wonders took place among the people. And they were all with one mind in Solomon's Porch. ");
INSERT INTO engemtv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","But none of the rest dared join them, but the people were magnifying them. ");
INSERT INTO engemtv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","And more than ever, believers were added to the Lord, multitudes of both men and women, ");
INSERT INTO engemtv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","so that they were bringing the sick out into the streets, and placing them on couches and pallets, so that as Peter was passing, at least his shadow might fall on some of them. ");
INSERT INTO engemtv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","And also the multitude from the surrounding cities were coming together into Jerusalem, bringing the sick and those who were tormented by unclean spirits, who were all being healed. ");
INSERT INTO engemtv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Then the high priest rose up, and all those who were with him (which is the sect of the Sadducees), and they were filled with jealousy, ");
INSERT INTO engemtv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","and laid their hands on the apostles and put them in the public prison. ");
INSERT INTO engemtv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","But an angel of the Lord during the night opened the doors of the prison, and leading them out, he said, ");
INSERT INTO engemtv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Go, stand in the temple and speak to the people all the words of this life.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","And when they heard that, they entered the temple about daybreak and were teaching. Now when the high priest and those with him arrived, they called together the council, even all the elders of the sons of Israel, and sent to the prison for them to be brought. ");
INSERT INTO engemtv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","But when the attendants arrived, and did not find them in the jail, they returned and announced, ");
INSERT INTO engemtv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","saying, “Indeed we found the prison shut in all security, and the guards standing before the doors; but when we opened them, we found no one inside!” ");
INSERT INTO engemtv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Now when they heard these words, both the high priest and the captain of the temple, and the chief priests, they were greatly perplexed about them, as to what would come of this. ");
INSERT INTO engemtv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","So one came and reported to them, saying, “Behold, the men whom you put in jail are standing in the temple and teaching the people!” ");
INSERT INTO engemtv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Then the captain went with the officers and brought them without violence, for they were afraid of the people, lest they be stoned. ");
INSERT INTO engemtv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","And they brought them, and set them before the council. And the high priest asked them, ");
INSERT INTO engemtv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","saying, “Did we not give you strict orders not to continue teaching in this name? And behold, you have filled Jerusalem with your teaching, and you want to bring on us the blood of this Man!” ");
INSERT INTO engemtv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","But Peter and the apostles answered, and said: “We must obey God rather than men. ");
INSERT INTO engemtv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","The God of our fathers raised up Jesus, whom you murdered by hanging on a tree. ");
INSERT INTO engemtv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Him God has exalted to His right hand as Prince and Savior, to give repentance to Israel and forgiveness of sins. ");
INSERT INTO engemtv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","And we are His witnesses of these words, and so also is the Holy Spirit, whom God has given to those who obey Him.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","But when they heard this, they were infuriated and were resolving to kill them. ");
INSERT INTO engemtv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Then someone in the council stood up, a Pharisee named Gamaliel, a teacher of the law held in honor by all the people, and commanded them to put the apostles outside for a short time. ");
INSERT INTO engemtv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","And he said to them: “Men of Israel, take heed to yourselves to these men, as to what you are about to do. ");
INSERT INTO engemtv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","For before these days, Theudas rose up, claiming himself to be someone, to whom was joined a number of men, about four hundred. He was slain, and all who obeyed him were scattered and came to nothing. ");
INSERT INTO engemtv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","After this arose Judas the Galilean, in the days of the census, and caused considerable number of people after him to revolt. He too perished, and as many as were persuaded by him were scattered. ");
INSERT INTO engemtv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","And now I say to you, keep away from these men and let them alone; for if this counsel or this work is of men, it will fail; ");
INSERT INTO engemtv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","but if it is of God, you cannot overthrow it—lest you even be found fighting against God.” ");
INSERT INTO engemtv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","And they were persuaded by him, and when they had called the apostles and beaten them, they commanded that they should not speak in the name of Jesus, and released them. ");
INSERT INTO engemtv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Then they departed from the presence of the council, rejoicing because they were counted worthy to be dishonored on behalf of the name of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","And daily in the temple, and from house to house, they did not cease teaching and proclaiming the gospel of Jesus the Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Now in those days, as the disciples were increasing in number, there arose a complaint from the Greek speaking Jews against the Aramaic speaking Jews, because their widows were being overlooked in the daily distribution. ");
INSERT INTO engemtv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Then the twelve summoned the multitude of the disciples and said, “It is not pleasing to us that we should forsake the word of God to serve tables. ");
INSERT INTO engemtv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Therefore, brothers, select seven men from among you, of good reputation, full of the Holy Spirit and wisdom, whom we may appoint for this need. ");
INSERT INTO engemtv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","But we will faithfully engage in prayer and in the ministry of the word.” ");
INSERT INTO engemtv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","And the word was pleasing before all the congregation, and they chose Stephen, a man full of faith and the Holy Spirit, and Philip, Prochorus, Nicanor, Timon, Parmenas, and Nicolas, a proselyte from Antioch, ");
INSERT INTO engemtv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","whom they set before the apostles; and when they had prayed, they laid their hands on them. ");
INSERT INTO engemtv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","And the word of God was growing, and the number of the disciples in Jerusalem was being multiplied exceedingly, and a great many of the priests were obeying the faith. ");
INSERT INTO engemtv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","And Stephen, full of faith and power, was performing great wonders and signs among the people. ");
INSERT INTO engemtv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","But there arose some men from what was called the Synagogue of the Freedmen, both of the Cyrenians and the Alexandrians, and of those from Cilicia and Asia, debating with Stephen. ");
INSERT INTO engemtv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","And they were not able to withstand the wisdom and the Spirit with which he spoke. ");
INSERT INTO engemtv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Then they secretly instigated men to say, “We have heard him speaking blasphemous words against Moses and God.” ");
INSERT INTO engemtv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","And they aroused the people and the elders and the scribes; and coming upon him, they seized him, and led him to the council. ");
INSERT INTO engemtv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","And they put forward false witnesses saying, “This man does not cease to speak blasphemous words against this holy place and the law; ");
INSERT INTO engemtv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","for we have heard him say that this Nazarene, Jesus, will destroy this place and change the customs which Moses handed down to us.” ");
INSERT INTO engemtv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","And looking intently at him, all those who sat in the council saw his face like the face of an angel. ");
INSERT INTO engemtv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Then the high priest said, “Are these things so?” ");
INSERT INTO engemtv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","And he said, “Men, brothers and fathers, listen: The God of glory appeared to our father Abraham when he was in Mesopotamia, before he dwelt in Haran, ");
INSERT INTO engemtv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","and said to him, ‘Go out from your land and from your relatives, and come to a land which I will show you.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Then he went forth from the land of the Chaldeans and settled down in Haran. And from there, after his father was dead, He moved him to this land in which you now dwell. ");
INSERT INTO engemtv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","And He gave him no inheritance in it, not even a place to put his foot on, and He promised to give it to him for a possession, and to his descendants after him, though he had no child. ");
INSERT INTO engemtv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","But God spoke in this way: that his offspring would dwell in a foreign land, and that they would enslave them, and they would treat them badly four hundred years. ");
INSERT INTO engemtv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘And the nation which they will serve, I will judge,’ said God, ‘and after these things they will come out and serve Me in this place.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Then He gave him the covenant of circumcision; and so Abraham fathered Isaac and circumcised him on the eighth day; and Isaac fathered Jacob, and Jacob fathered the twelve patriarchs. ");
INSERT INTO engemtv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“And the patriarchs, being jealous of Joseph, sold him into Egypt; and God was with him, ");
INSERT INTO engemtv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","and delivered him out of all his afflictions, and gave him favor and wisdom before Pharaoh, king of Egypt; and he made him ruler over Egypt and all his house. ");
INSERT INTO engemtv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Now a famine came over all the land of Egypt and Canaan, and great affliction, and our fathers could find no provisions. ");
INSERT INTO engemtv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","And Jacob, hearing that there was grain in Egypt, he sent out our fathers first. ");
INSERT INTO engemtv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","And on the second visit Joseph was made known to his brothers, and Joseph's family became known to Pharaoh. ");
INSERT INTO engemtv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Then Joseph sent and summoned his father Jacob and all his relatives, seventy-five people. ");
INSERT INTO engemtv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","So Jacob went down to Egypt; and he died, he and our fathers. ");
INSERT INTO engemtv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","And they were brought back to Shechem, and were placed in the tomb which Abraham bought for a price of silver from the sons of Hamor, the father of Shechem. ");
INSERT INTO engemtv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Now when the time of the promise drew near which God swore to Abraham, the people increased and multiplied in Egypt, ");
INSERT INTO engemtv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","until there arose a different king, who did not know Joseph. ");
INSERT INTO engemtv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","This king took advantage of our race, and oppressed our fathers, to make their babies exposed, in order that they might not preserve their lives. ");
INSERT INTO engemtv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","At this time Moses was born, and he was well pleasing to God; who was brought up in his father's house for three months. ");
INSERT INTO engemtv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","But when he was exposed, the daughter of Pharaoh took him up, and brought him up for herself as a son. ");
INSERT INTO engemtv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","And Moses was educated in all the wisdom of the Egyptians, and he was mighty in words and deeds. ");
INSERT INTO engemtv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Now when he had turned forty years old, it came into his heart to look upon his brothers, the sons of Israel. ");
INSERT INTO engemtv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","And seeing someone being wronged, he retaliated, and avenged him who was being oppressed, and struck the Egyptian. ");
INSERT INTO engemtv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","For he supposed that his brothers understood that God was giving to them deliverance by his hand, but they did not understand. ");
INSERT INTO engemtv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","And on the next day he appeared to them as they were fighting, and tried to reconcile them to peace, saying, ‘Men, you are brothers; why do you wrong one another?’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","But the one wronging his neighbor pushed him away, saying, ‘Who appointed you a ruler and a judge over us? ");
INSERT INTO engemtv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Do you desire to kill me as you killed the Egyptian yesterday?’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Now Moses, at this saying, fled and became a stranger in the land of Midian, where he fathered two sons. ");
INSERT INTO engemtv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“And forty years having been fulfilled, an Angel of the Lord appeared to him in a flame of fire in a bush, in the wilderness of Mount Sinai. ");
INSERT INTO engemtv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","And Moses, seeing it, marveled at the sight; and as he approached it to observe closely, the voice of the Lord came to him, ");
INSERT INTO engemtv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","saying, ‘I am the God of your fathers—the God of Abraham, and the God of Isaac, and the God of Jacob.’ And Moses was trembling and was not bold enough to look closely. ");
INSERT INTO engemtv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Then the Lord said to him, ‘Remove your sandals from your feet, for the place where you stand is holy ground. ");
INSERT INTO engemtv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","I have certainly seen the mistreatment of My people in Egypt. I have heard their groaning and I have come down to deliver them. And now come, I will send you to Egypt.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“This Moses whom they denied, saying, ‘Who appointed you a ruler and a judge?’ This man God sent as a ruler and redeemer by the hand of the Angel who appeared to him in the bush. ");
INSERT INTO engemtv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","He led them out, and did wonders and signs in the land of Egypt, and at the Red Sea, and in the wilderness forty years. ");
INSERT INTO engemtv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“This is that Moses who said to the sons of Israel, ‘The Lord our God will raise up for you a Prophet like me from your brothers.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“This is he who was in the congregation in the wilderness with the Angel who was speaking to him on Mount Sinai, and with our fathers, the one who received the living oracles to give to us, ");
INSERT INTO engemtv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","whom our fathers did not desire to be obedient, but they rejected him and returned in their heart back to Egypt, ");
INSERT INTO engemtv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","saying to Aaron, ‘Make for us gods who will go before us: as for this Moses who led us out of the land of Egypt, we do not know what has happened to him.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","And they made a calf in those days, offered a sacrifice to the idol, and were rejoicing in the works of their hands. ");
INSERT INTO engemtv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","But God turned away and gave them over to serve the host of heaven, just as it is written in the book of the Prophets: ‘Did you offer Me slaughtered animals and sacrifices during forty years in the wilderness, O house of Israel? ");
INSERT INTO engemtv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Indeed you carried up the tabernacle of Moloch, and the star of your god Remphan, the images which you made to worship them; and I will relocate you beyond Babylon.’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“The tabernacle of the testimony was with our fathers in the wilderness, just as the One speaking to Moses commanded him, to make it according to the pattern that he had seen, ");
INSERT INTO engemtv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","which also our fathers, having received in turn, also brought in with Joshua into the possession of the Gentiles, whom God drove out before the face of our fathers until the days of David, ");
INSERT INTO engemtv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","who found favor before God and asked opportunity to find a dwelling place for the God of Jacob. ");
INSERT INTO engemtv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","But Solomon built Him a house. ");
INSERT INTO engemtv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“However, the Most High does not dwell in handmade sanctuaries, just as the prophet says: ");
INSERT INTO engemtv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Heaven is My throne, and the earth is My footstool. What kind of house will you build for Me? says the Lord, or what is the place of My rest? ");
INSERT INTO engemtv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","has not My hand made all these things?’ ");
INSERT INTO engemtv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“You stiff-necked and uncircumcised in heart and ears! You always resist the Holy Spirit; as your fathers did, you also do. ");
INSERT INTO engemtv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Which of the prophets did your fathers not persecute? And they killed those who foretold about the coming of the Righteous One, of whom you have now become betrayers and murderers, ");
INSERT INTO engemtv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","who have received the law as the ordinances of angels and you did not keep it.” ");
INSERT INTO engemtv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Now hearing these things they were infuriated in their hearts, and were gnashing their teeth against him. ");
INSERT INTO engemtv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","But being full of the Holy Spirit, looking intently into heaven, he saw the glory of God, and Jesus standing at the right hand of God, ");
INSERT INTO engemtv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","and he said, “Behold! I see the heavens opened, and the Son of Man standing at the right hand of God!” ");
INSERT INTO engemtv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Then they cried out with a loud voice, stopped their ears, and ran at him with one purpose; ");
INSERT INTO engemtv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","and casting him outside the city, they stoned him. And the witnesses laid down their clothes beside the feet of a young man named Saul. ");
INSERT INTO engemtv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","And they stoned Stephen as he was calling on God and saying, “Lord Jesus, receive my spirit.” ");
INSERT INTO engemtv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Then he knelt down and cried out with a loud voice, “Lord, do not charge them with this sin.” And having said this, he fell asleep. ");
INSERT INTO engemtv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Now Saul was agreeing with them in his murder. And in that day there arose a great persecution against the church which was in Jerusalem; and they all were scattered throughout the regions of Judea and Samaria, except the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","And godly men buried Stephen, and they mourned deeply for him. ");
INSERT INTO engemtv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","But Saul was doing injury to the church, going in from house to house, and dragging away both men and women, and putting them in prison. ");
INSERT INTO engemtv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Therefore those who were scattered went about preaching the word. ");
INSERT INTO engemtv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","And Philip, going down to a city of Samaria, was preaching to them the Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","And the crowds with one accord gave heed to the things spoken by Philip, hearing and seeing the signs which he was doing. ");
INSERT INTO engemtv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","For many of those having unclean spirits had cried out with a loud voice, and the spirits came out; and many who were paralyzed and lame were healed. ");
INSERT INTO engemtv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","And there was great joy in that city. ");
INSERT INTO engemtv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Now a certain man named Simon was previously in the city practicing magic and astounding the people of Samaria, claiming himself to be someone great, ");
INSERT INTO engemtv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","to whom they gave heed, from the least to the greatest, saying, “This man is the great power of God.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","But they gave heed to him because of the long time that he had astonished them with the magic arts. ");
INSERT INTO engemtv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","But when they believed Philip as he preached the good news of the things concerning the kingdom of God and the name of Jesus Christ, they were baptized, both men and women. ");
INSERT INTO engemtv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Then Simon himself also believed; and having been baptized, he was continuing with Philip, and observing miracles and signs occurring, he was astounded. ");
INSERT INTO engemtv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Now when the apostles who were at Jerusalem heard that Samaria had received the word of God, they sent to them Peter and John, ");
INSERT INTO engemtv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","who, coming down, prayed concerning them in order that they might receive the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","For He had not yet fallen upon any of them, but they had only been baptized in the name of Christ Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Then they laid hands upon them, and they received the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Now when Simon observed that by the laying on of the apostles' hands the Holy Spirit was given, he offered them money, ");
INSERT INTO engemtv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","saying, “Give me this power also, that on whom ever I lay my hands he may receive the Holy Spirit.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","But Peter said to him, “Your money perish with you, because you thought to acquire the gift of God with money! ");
INSERT INTO engemtv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","You have neither part nor portion in this matter, for your heart is not right before God. ");
INSERT INTO engemtv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Repent therefore from this your wickedness, and make petition to God, if perhaps the intent of your heart will be forgiven you. ");
INSERT INTO engemtv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","For I see that you are in the gall of bitterness and the bond of unrighteousness.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Then Simon answered and said, “Pray to the Lord for me, that none of the things of which you have spoken may come upon me.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Then solemnly bearing witness to and speaking the word of the Lord, they returned to Jerusalem, and preached the gospel to many villages of the Samaritans. ");
INSERT INTO engemtv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Now an angel of the Lord spoke to Philip, saying, “Get up and go toward the south on the road which goes down from Jerusalem to Gaza.” This is desolate. ");
INSERT INTO engemtv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","So he got up and went; and behold, a man of Ethiopia, a eunuch, a court official of Candace the queen of the Ethiopians, who was over all her treasury, and had come to Jerusalem to worship, ");
INSERT INTO engemtv_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","and he was returning. And sitting upon his chariot, he was reading the prophet Isaiah. ");
INSERT INTO engemtv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Then the Spirit said to Philip, “Go near, and join yourself to this chariot.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","And Phillip, running up to it, heard him reading the prophet Isaiah, and said, “Do you understand what you are reading?” ");
INSERT INTO engemtv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","And he said, “How can I, unless someone helps me?” And he urged Philip to come up and sit with him. ");
INSERT INTO engemtv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Now the portion of the Scripture which he was reading was this: “He was led as a sheep to the slaughter; and as a lamb before its shearer is silent, so He opened not His mouth. ");
INSERT INTO engemtv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","In His humiliation His justice was taken away, and who will recount His generation? For His life is taken away from the earth.” ");
INSERT INTO engemtv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","So the eunuch answered Philip and said, “Please tell me, of whom does the prophet say this; of himself, or of someone else?” ");
INSERT INTO engemtv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","And Philip, opening his mouth, and beginning from this Scripture, preached the good news about Jesus to him. ");
INSERT INTO engemtv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Now as they were going down the road, they came upon some water. And the eunuch said, “Behold, here is water: what prevents me from being baptized?” ");
INSERT INTO engemtv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","And he ordered the chariot to stop, and they both went down into the water, both Phillip and the eunuch, and he baptized him. ");
INSERT INTO engemtv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Now when they came up out of the water, the Spirit of the Lord caught up Philip, and the eunuch did not see him any longer; and he went on his way rejoicing. ");
INSERT INTO engemtv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","But Philip was found at Azotus. And as he passed through, he preached the gospel to all the cities until he came to Caesarea. ");
INSERT INTO engemtv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Then Saul, still breathing murderous threats against the disciples of the Lord, went to the high priest ");
INSERT INTO engemtv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","and requested from him letters of authority to the synagogues of Damascus, that if he should find any who were of the Way, both men and women, he might bring them, having been bound, to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","And as he was going, it came about that he drew near to Damascus, and suddenly a light shone around him from heaven. ");
INSERT INTO engemtv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","And falling on the ground, he heard a voice saying to him, “Saul, Saul, why are you persecuting Me?” ");
INSERT INTO engemtv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","And he said, “Who are You, Lord?” And the Lord said, “I am Jesus, whom you are persecuting. ");
INSERT INTO engemtv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“But rise up and enter into the city, and it will be spoken to you what you must do.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","And the men who were traveling with him stood speechless, hearing the voice but seeing no one. ");
INSERT INTO engemtv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","And Saul got up from the ground, and although his eyes were open, he saw no one; and leading him by the hand, they brought him into Damascus. ");
INSERT INTO engemtv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","And he was three days not seeing, and neither ate nor drank. ");
INSERT INTO engemtv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Now there was a certain disciple at Damascus named Ananias; and the Lord said to him in a vision, “Ananias.” And he said, “Behold I am here, Lord.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","And the Lord said to him, “Arise and go to Straight Street, and seek out in the house of Judas a man named Saul, of Tarsus; for behold, he is praying. ");
INSERT INTO engemtv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","And he has seen in a vision a man named Ananias come in and lay his hands on him, so that he might see again.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","But Ananias answered, “Lord, I have heard from many about this man, how many wicked things he has done to Your saints in Jerusalem; ");
INSERT INTO engemtv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","and here he has authority from the chief priests to bind all who are calling on Your name.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","But the Lord said to him, “Go, for he is a chosen vessel to Me to bear My name before Gentiles and kings, and the sons of Israel. ");
INSERT INTO engemtv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","For I will show him all the things that he must suffer for My name's sake.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","And Ananias departed and entered the house; and putting his hands on him, he said, “Brother Saul, the Lord has sent me, the One who appeared to you in the way which you were coming, so that you may see again and be filled with the Holy Spirit.” ");
INSERT INTO engemtv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","And immediately something like scales fell from his eyes, and he could see again; and he got up and was baptized. ");
INSERT INTO engemtv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","And when he had received food, he was strengthened. Now Saul was with the disciples in Damascus for several days. ");
INSERT INTO engemtv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","And immediately in the synagogues he was proclaiming Christ, that He is the Son of God. ");
INSERT INTO engemtv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","And all those who heard were astounded, and were saying, “Is this not the one who destroyed those who called on this name in Jerusalem, and has come here for that purpose, so that he might bring them bound to the chief priests?” ");
INSERT INTO engemtv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","But Saul all the more was growing strong, and was confounding the Jews who were dwelling in Damascus, proving that Jesus was the Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Now when many days had passed, the Jews plotted to kill him. ");
INSERT INTO engemtv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","But their plot became known to Saul. And they closely watched the city gates both day and night, in order that they might kill him. ");
INSERT INTO engemtv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","But the disciples, taking him by night, they let him down through the wall, lowering him in a basket. ");
INSERT INTO engemtv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Now when Saul arrived in Jerusalem, he tried to join himself to the disciples; but they all were afraid of him, not believing that he was a disciple. ");
INSERT INTO engemtv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","But Barnabas, taking hold of him, brought him to the apostles, and related to them how he had seen the Lord on the road, and that He had spoken to him, and how in Damascus he spoke boldly in the name of Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","So he went in and out among them at Jerusalem, ");
INSERT INTO engemtv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","and speaking boldly in the name of the Lord Jesus, and he was speaking and disputing with the Greek-speaking Jews, but they were attempting to kill him. ");
INSERT INTO engemtv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","But the brothers, learning about it, brought him down to Caesarea and sent him off to Tarsus. ");
INSERT INTO engemtv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Then the churches throughout all Judea, Galilee, and Samaria had peace and were edified, and walking in the fear of the Lord and in the encouragement of the Holy Spirit, they were multiplied. ");
INSERT INTO engemtv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Now it came to pass, as Peter went through all parts of the country, that he went down to the saints who were dwelling in Lydda. ");
INSERT INTO engemtv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","And he found there a certain man named Aeneas, who had been confined to a bed for eight years, who was paralyzed. ");
INSERT INTO engemtv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","And Peter said to him, “Aeneas, Jesus the Christ heals you. Arise and make your bed.” Then he arose immediately. ");
INSERT INTO engemtv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","And all who were dwelling at Lydda and Sharon saw him, and they turned to the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Now in Joppa there was a certain disciple named Tabitha, which, being translated, means Dorcas. This woman was full of good works and charitable giving which she was doing. ");
INSERT INTO engemtv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","But it came about in those days that she became sick and died; and they washed her, and put her in an upper room. ");
INSERT INTO engemtv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Now since Lydda was near Joppa, the disciples, having heard that Peter was in Joppa, sent to him, urging him not to delay in coming to them. ");
INSERT INTO engemtv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","And arising, Peter went with them. When he arrived, they took him into the upper room, and all the widows stood beside him weeping, showing him tunics and cloaks which Dorcas was making, while she was with them. ");
INSERT INTO engemtv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","But Peter, having put them all outside, knelt down and prayed. And turning to the body he said, “Tabitha, arise.” And she opened her eyes, and seeing Peter, she sat up. ");
INSERT INTO engemtv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","And giving to her his hand, he raised her up; and when he called the saints and the widows, he presented her alive. ");
INSERT INTO engemtv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","And it became known throughout all of Joppa, and many believed on the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","And he stayed for some time in Joppa with a tanner named Simon. ");
INSERT INTO engemtv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Now there was a certain man in Caesarea named Cornelius, a centurion of what was called the Italian Regiment, ");
INSERT INTO engemtv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","a devout man, and one that feared God, together with all his household, who often gave alms to the people, and making petition to God always. ");
INSERT INTO engemtv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","About the ninth hour of the day, he saw clearly in a vision an angel of God coming to him and saying to him, “Cornelius!” ");
INSERT INTO engemtv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","And looking intently at him and becoming fearful he said, “What is it, lord?” And he said to him, “Your prayers and your alms have come up for a memorial before God. ");
INSERT INTO engemtv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Now send men to Joppa, and send for Simon whose surname is Peter. ");
INSERT INTO engemtv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","He is staying as a guest with one Simon, a tanner, whose house is beside the sea.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Now when the angel who had been speaking to Cornelius had departed, he called two of his servants and a devout soldier from among those who waited on him continually. ");
INSERT INTO engemtv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","And explaining to them everything, he sent them to Joppa. ");
INSERT INTO engemtv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Now on the next day, as they were traveling and drawing near to the city, Peter went up on the housetop to pray, at about the sixth hour. ");
INSERT INTO engemtv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","And he became hungry and wanted to eat; but while they were preparing, he fell into a trance. ");
INSERT INTO engemtv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","And he saw heaven having been opened, and descending to him a certain vessel like a great sheet, having been bound at the four corners, and being let down upon the ground, ");
INSERT INTO engemtv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","in which were all the four-footed animals of the earth and the wild animals, and the reptiles, and the birds of the air. ");
INSERT INTO engemtv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","And there came a voice to him, saying, “Arise, Peter; kill and eat.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","But Peter said, “By no means, Lord! For never did I eat anything common or unclean.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","And a voice spoke again the second time to him, “That which God has made clean, you must not make common.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","And this happened three times, and again the vessel was taken up into heaven. ");
INSERT INTO engemtv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Now as Peter was very perplexed within himself as to what the vision which he had seen might mean, behold, the men who had been sent from Cornelius, having found by inquiry the house of Simon, stood at the gateway. ");
INSERT INTO engemtv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","And they called and asked whether Simon, whose surname was Peter, was lodging there. ");
INSERT INTO engemtv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Now while Peter pondered about the vision, the Spirit said to him, “Behold, men are seeking you. ");
INSERT INTO engemtv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Arise therefore, go down and go with them, without wavering; for I have sent them.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","And Peter, going down to the men, said, “Behold, I am he whom you seek. Why have you come?” ");
INSERT INTO engemtv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","And they said, “Cornelius the centurion, a just man, and fearing God, having a good reputation among all the nation of the Jews, was given a revelation by a holy angel to send for you to his house, and to hear a message from you.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Therefore he invited them in and received them as guests. Now on the next day Peter went forth with them, and some brothers from Joppa went with him. ");
INSERT INTO engemtv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","And on the next day they entered into Caesarea. And Cornelius was waiting for them, having called together his relatives and close friends. ");
INSERT INTO engemtv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Now when it happened that Peter entered, Cornelius met him, and fell at his feet and worshiped him. ");
INSERT INTO engemtv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","But Peter raised him up, saying, “Stand up; I too am just a man.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","And talking with him he went in, and found many having gathered, ");
INSERT INTO engemtv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","and he said to them, “You know how unlawful it is for a Jewish man to associate with or to approach a Gentile; and yet God has shown to me that I should call no man common or unclean; ");
INSERT INTO engemtv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","therefore also without objecting, I came when I was sent for. I ask, then, for what reason have you sent for me?” ");
INSERT INTO engemtv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","So Cornelius said, “From the fourth day until this hour I was fasting, and at the ninth hour I was praying in my house, and behold, a man stood before me in shining clothing, ");
INSERT INTO engemtv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","and said, ‘Cornelius, your prayer has been heard, and your alms are remembered before God. ");
INSERT INTO engemtv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Send therefore to Joppa and summon Simon, whose surname is Peter. He is staying as a guest in the house of Simon, a tanner, beside the sea. When he arrives, he will speak to you.’ ");
INSERT INTO engemtv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Therefore immediately I sent to you, and you have done well to come. Now then we are all present before God, to hear all the things having been commanded you by God.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","And Peter, opening his mouth, said: “In truth I comprehend that God is not One to show partiality. ");
INSERT INTO engemtv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","But in every nation, he that fears Him and works righteousness is acceptable to Him. ");
INSERT INTO engemtv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","The word which God sent to the sons of Israel, preaching the good news of peace through Jesus Christ—He being Lord of all— ");
INSERT INTO engemtv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","you know, the word coming to be throughout all of Judea, and beginning from Galilee after the baptism which John proclaimed, ");
INSERT INTO engemtv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jesus of Nazareth, how God anointed Him with the Holy Spirit and with power, who went about doing good and healing all those who were oppressed by the devil, because God was with Him. ");
INSERT INTO engemtv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","And we are witnesses of all things which He did, both in the country of the Jews and in Jerusalem, whom they also killed by hanging on a tree. ");
INSERT INTO engemtv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","This Jesus God raised up on the third day, and caused Him to be seen, ");
INSERT INTO engemtv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","not to all the people, but to witnesses, who having been chosen beforehand by God, even to us, who ate and drank together with Him after He arose from the dead. ");
INSERT INTO engemtv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","And He commanded us to proclaim to the people, and to testify solemnly that He is the One having been appointed by God to be Judge of the living and the dead. ");
INSERT INTO engemtv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","To Him all the prophets bear witness, that through His name, everyone believing in Him shall receive forgiveness of sins.” ");
INSERT INTO engemtv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","While Peter was still speaking these words, the Holy Spirit fell upon all those who heard the word. ");
INSERT INTO engemtv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","And those of the circumcision who believed were astounded, as many as had come with Peter, because the gift of the Holy Spirit had been poured out on the Gentiles also. ");
INSERT INTO engemtv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","For they heard them speaking in tongues and magnifying God. Then Peter answered, ");
INSERT INTO engemtv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Surely no one can forbid water, can he, that these should not be baptized who received the Holy Spirit just as we have?” ");
INSERT INTO engemtv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","And he commanded them to be baptized in the name of the Lord. Then they asked him to stay for some days. ");
INSERT INTO engemtv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Now the apostles and the brothers who were in Judea heard that the Gentiles had also received the word of God. ");
INSERT INTO engemtv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","And when Peter came up to Jerusalem, those of the circumcision were contending with him, ");
INSERT INTO engemtv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","saying, “You went in to uncircumcised men and ate with them!” ");
INSERT INTO engemtv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","But Peter, beginning to speak, was setting forth to them in order, saying, ");
INSERT INTO engemtv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“I was in the city of Joppa praying; and in a trance I saw a vision, a certain vessel coming down like a great sheet, being lowered by the four corners from heaven; and it came as far as me; ");
INSERT INTO engemtv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","on which, looking intently, I was contemplating, and I saw the four-footed animals of the earth, and the wild beasts, and the reptiles, and the birds of the air. ");
INSERT INTO engemtv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","And I heard a voice saying to me, ‘Arise, Peter; kill and eat.’ ");
INSERT INTO engemtv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","But I said, ‘By no means, Lord! For nothing common or unclean has ever entered into my mouth.’ ");
INSERT INTO engemtv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","But the voice answered me a second time from heaven, ‘What God has made clean, you must not make common.’ ");
INSERT INTO engemtv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","And this was done three times, and again all things were drawn up into heaven. ");
INSERT INTO engemtv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","And behold, immediately three men stood before the house in which I was, having been sent from Caesarea to me. ");
INSERT INTO engemtv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","And the Spirit told me to go with them, without wavering. Now these six brothers also went with me, and we entered into the house of the man. ");
INSERT INTO engemtv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","And he related to us how he had seen the angel in his house, standing and saying to him, ‘Send men to Joppa, and send for Simon whose surname is Peter, ");
INSERT INTO engemtv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","who will speak words to you by which you and all your household shall be saved.’ ");
INSERT INTO engemtv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","And when I began to speak, the Holy Spirit fell on them, as also on us in the beginning. ");
INSERT INTO engemtv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","And I remembered the word of the Lord, how He said, ‘John indeed baptized with water, but you shall be baptized with the Holy Spirit.’ ");
INSERT INTO engemtv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","If then God has given to them the same gift as He gave to us, when we believed on the Lord Jesus Christ, who was I to hinder God?” ");
INSERT INTO engemtv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","And hearing these things, they remained silent, and they glorified God, saying, “Then God has also granted even the Gentiles repentance unto life.” ");
INSERT INTO engemtv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Then those who were scattered because of the tribulation coming about over Stephen, went about as far as Phoenicia, and Cyprus, and Antioch, speaking the word to no one except Jews only. ");
INSERT INTO engemtv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","But some of them were men from Cyprus and Cyrene, who, entering into Antioch spoke to the Greek speaking Jews, preaching the good news of the Lord Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","And the hand of the Lord was with them, and a great number believed, and turned to the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","And the word about them was heard in the ears of the church in Jerusalem, and they sent forth Barnabas to go as far as Antioch; ");
INSERT INTO engemtv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","who, arriving and seeing the grace of God, was glad, and encouraged them all with purpose of heart to continue with the Lord, ");
INSERT INTO engemtv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","for he was a good man, full of the Holy Spirit and of faith. And a great many people were added to the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","And Barnabas went to Tarsus to look for Saul, ");
INSERT INTO engemtv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","and having found him, he brought him to Antioch. And it came about that for a whole year they assembled with the church and instructed many people. And the disciples were first called Christians in Antioch. ");
INSERT INTO engemtv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Now in these days prophets went down from Jerusalem to Antioch. ");
INSERT INTO engemtv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","And rising up, one of them named Agabus, foretold by the Spirit of a great famine about to happen in all the world, which also came to pass in the time of Claudius Caesar. ");
INSERT INTO engemtv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Then the disciples, each according to his ability, determined as a ministry to send relief to the brothers dwelling in Judea; ");
INSERT INTO engemtv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","which they also did, sending it to the elders by the hand of Barnabas and Saul. ");
INSERT INTO engemtv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Now at that time Herod the king put forth his hands to harm some from the church. ");
INSERT INTO engemtv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","And he put to death James the brother of John with the sword. ");
INSERT INTO engemtv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","And seeing that it was pleasing to the Jews, he proceeded further to arrest Peter also (these were during the days of Unleavened Bread), ");
INSERT INTO engemtv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","whom also seizing, he put him in prison, and handed him over to four four-man squads of soldiers to guard him, planning after the Passover to bring him again to the people. ");
INSERT INTO engemtv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Therefore Peter was kept in prison; but earnest prayer was being made by the church to God on his behalf. ");
INSERT INTO engemtv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","But when Herod was about to bring him forth, on that night Peter was sleeping, between two soldiers, having been bound with two chains; and guards before the door were keeping the prison. ");
INSERT INTO engemtv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","And behold, an angel of the Lord stood there, and a light shined in the prison room; and striking the side of Peter, he roused him saying, “Arise quickly!” And his chains fell away from his hands. ");
INSERT INTO engemtv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","And the angel said to him, “Gird yourself and put on your sandals”; and he did so. And he said to him, “Put on your cloak and follow me.” ");
INSERT INTO engemtv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","And going out, he was following him, and did not know that the thing taking place by the angel was real, but he was thinking that he was seeing a vision. ");
INSERT INTO engemtv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","And going though the first and the second guard posts, they came to the iron gate which leads into the city, which was opened to them of its own accord; and going out, they went forward one street, and immediately the angel withdrew from him. ");
INSERT INTO engemtv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","And Peter, having come to himself, said, “Now I know truly that the Lord has sent forth His angel, and has delivered me from the hand of Herod and from all the expectation of the Jews.” ");
INSERT INTO engemtv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","And realizing this, he came to the house of Mary, the mother of John whose surname was Mark, where a considerable number were gathered together and were praying. ");
INSERT INTO engemtv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","And when Peter knocked at the door of the gate, a servant girl came to answer, named Rhoda. ");
INSERT INTO engemtv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","When she recognized Peter's voice, because of her gladness she did not open the gate, but running in, she announced that Peter stood at the gate. ");
INSERT INTO engemtv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","But they said to her, “You are mad!” Yet she kept insisting that it was so. So they said, “It is his angel.” ");
INSERT INTO engemtv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","But Peter was continuing knocking; and opening the door they saw him, and were astounded. ");
INSERT INTO engemtv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","And motioning to them with his hand to be silent, he related to them how the Lord had led him out of the prison. And he said, “Tell these things to James and to the brothers.” And going out, he went to another place. ");
INSERT INTO engemtv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Now when day came, there was no small disturbance among the soldiers, as to what had become of Peter. ");
INSERT INTO engemtv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","And Herod, seeking for him and not finding him, he examined the guards, and commanded that they be executed. And going down from Judea to Caesarea, he was spending time there. ");
INSERT INTO engemtv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Now Herod was very angry with the people of Tyre and Sidon; and with one purpose they came to him, and persuading Blastus, the one over the king's bedroom, they asked for peace, because their country was fed from the king's country. ");
INSERT INTO engemtv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","And on an appointed day Herod, clothing himself with royal apparel, and sitting on the judgment seat, was delivering an address to them. ");
INSERT INTO engemtv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","And the crowds kept calling out, “This is the voice of a god and not of a man!” ");
INSERT INTO engemtv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Then immediately an angel of the Lord struck him, because he did not give glory to God. And he was eaten by worms and died. ");
INSERT INTO engemtv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","But the word of God increased and multiplied. ");
INSERT INTO engemtv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","And Barnabas and Saul returned to Jerusalem, having fulfilled their ministry, taking along with them John also, whose surname was Mark. ");
INSERT INTO engemtv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Now there were some in the church being in Antioch who were prophets and teachers: both Barnabas, and Simeon who was called Niger, Lucius of Cyrene, Manaen, brought up with Herod the tetrarch, and Saul. ");
INSERT INTO engemtv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Now as they were ministering to the Lord and fasting, the Holy Spirit said, “Now separate to Me Barnabas and Saul for the work to which I have called them.” ");
INSERT INTO engemtv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Then, fasting and praying, and laying their hands on them, they sent them away. ");
INSERT INTO engemtv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","So these two, having been sent forth by the Holy Spirit, went down to Seleucia, and from there they sailed to Cyprus. ");
INSERT INTO engemtv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","And arriving in Salamis, they proclaimed the word of God in the synagogues of the Jews. They also had John as their assistant. ");
INSERT INTO engemtv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","And going across the island as far as Paphos, they found a certain sorcerer, a false prophet, a Jew whose name was Bar-Jesus, ");
INSERT INTO engemtv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","who was with the proconsul, Sergius Paulus, an intelligent man. This man summoned Barnabas and Saul, and desired to hear the word of God. ");
INSERT INTO engemtv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","But Elymas the sorcerer (for so his name is translated) resisted them, seeking to turn away the proconsul from the faith. ");
INSERT INTO engemtv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","But Saul, who also is called Paul, was filled with the Holy Spirit, and gazing intently at him, ");
INSERT INTO engemtv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","he said, “O full of all guile and all craft, you son of the devil, you enemy of all righteousness, will you not cease perverting the straight ways of the Lord? ");
INSERT INTO engemtv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","And now behold, the hand of the Lord is upon you, and you shall be blind, not seeing the sun for a season.” And immediately a mistiness and darkness fell upon him, and going about, he sought someone to lead him by the hand. ");
INSERT INTO engemtv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Then when the proconsul saw what had happened, he believed, being amazed at the teaching of the Lord. ");
INSERT INTO engemtv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Now Paul and his companions put to sea from Paphos, and came to Perga of Pamphylia; But John deserted them and returned to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","But they went from Perga, and arrived in Antioch of Pisidia, and entering into the synagogue on the Sabbath day, they sat down. ");
INSERT INTO engemtv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Now after the reading of the Law and the Prophets, the synagogue leaders sent to them, saying, “Men and brothers, if you have any word of exhortation for the people, speak.” ");
INSERT INTO engemtv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","And Paul, arising and motioning with his hand, said, “Men, Israelites, and you who fear God, listen: ");
INSERT INTO engemtv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","The God of this people chose our fathers, and lifting up the people during their sojourn in the land of Egypt, and with an uplifted arm brought them out from it. ");
INSERT INTO engemtv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Now for a time of about forty years He put up with them in the wilderness. ");
INSERT INTO engemtv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","And destroying seven nations in the land of Canaan, He gave their land to them as an inheritance. ");
INSERT INTO engemtv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“And after these things, for about four hundred and fifty years, He gave them judges until the time of Samuel the prophet. ");
INSERT INTO engemtv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","And then they asked for a king, and God gave them Saul the son of Kish, a man of the tribe of Benjamin, for forty years. ");
INSERT INTO engemtv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","And removing him, He raised up for them David as king, to whom He also said bearing witness, ‘I have found David the son of Jesse, to be a man after My own heart, who will do all My will.’ ");
INSERT INTO engemtv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","God, from the seed of this man, according to the promise, has brought to Israel salvation, ");
INSERT INTO engemtv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","after John had first proclaimed before His coming, the baptism of repentance to Israel. ");
INSERT INTO engemtv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Now as John was finishing his course, he said, ‘Whom do you suppose me to be? I am not He. But behold, there comes One after me, the sandal of whose feet I am not worthy to loosen.’ ");
INSERT INTO engemtv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Men, brothers, sons of the family of Abraham, and those among you who fear God, to you the message of this salvation has been sent. ");
INSERT INTO engemtv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","For those dwelling in Jerusalem, and their rulers, because they did not know Him, nor the voices of the Prophets which are read according to each Sabbath, condemning him, they fulfilled the Scriptures. ");
INSERT INTO engemtv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","And finding no cause for death, they asked Pilate that He be executed. ");
INSERT INTO engemtv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","And when they finished all the things having been written about Him, taking Him down from the tree, they put Him in a tomb. ");
INSERT INTO engemtv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","But God raised Him from the dead; ");
INSERT INTO engemtv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","who appeared for many days more to those going up with Him from Galilee to Jerusalem, who are His witnesses to the people. ");
INSERT INTO engemtv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","And we proclaim to you the good news of the promise which was made to the fathers, ");
INSERT INTO engemtv_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","that God has fulfilled this promise for us to their children, when He raised up Jesus, as it is also written in the second Psalm: ‘You are My Son, today I have begotten You.’ ");
INSERT INTO engemtv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","And that He raised Him from the dead, no longer being about to return to corruption, thus He has said: ‘I will give you the holy and sure blessings of David.’ ");
INSERT INTO engemtv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Therefore also in another Psalm He says, ‘You will not allow Your Holy One to see corruption.’ ");
INSERT INTO engemtv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“For David indeed in his own generation, having served by the purpose of God, died, and was buried with his fathers, and saw corruption; ");
INSERT INTO engemtv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","but He whom God raised up did not see corruption. ");
INSERT INTO engemtv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Therefore let it be known to you, brothers, that through this Man forgiveness of sins is proclaimed to you, ");
INSERT INTO engemtv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","and from all things from which you could not (by the Law of Moses) be justified, by Him everyone that believes is justified. ");
INSERT INTO engemtv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Watch therefore, lest there come upon you that which was spoken of in the prophets: ");
INSERT INTO engemtv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Behold, you despisers, and marvel and perish! For I will work a work in your days which you will by no means believe, though one were to declare it to you.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Now as the Jews were going out of the synagogue, the Gentiles begged that these words might be spoken to them the next Sabbath. ");
INSERT INTO engemtv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","And when the synagogue service was broken up, many of the Jews and of the devout proselytes followed Paul and Barnabas, who, speaking to them, persuaded them to continue in the grace of God. ");
INSERT INTO engemtv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","On the coming Sabbath, almost all the city was assembled to hear the word of God. ");
INSERT INTO engemtv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","And the Jews, seeing the crowds, were filled with jealousy and spoke against the things being said by Paul, contradicting and blaspheming. ");
INSERT INTO engemtv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","But Paul and Barnabas, speaking boldly said, “It was necessary for the word of God to be spoken to you first; but since you thrust it away, and judge yourselves not worthy of eternal life; behold, we turn to the Gentiles. ");
INSERT INTO engemtv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","For so the Lord has commanded us: ‘I have set you to be a light of the nations, that you should be for salvation to the end of the earth.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Now when the Gentiles heard this, they rejoiced and glorified the word of the Lord. And as many as were appointed to eternal life believed. ");
INSERT INTO engemtv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","And the word of the Lord was being spread throughout all the region. ");
INSERT INTO engemtv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","But the Jews incited the devout and prominent women and the leading men of the city, and raised up a persecution against Paul and Barnabas, and cast them out from their borders. ");
INSERT INTO engemtv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","But shaking off the dust from their feet against them, they went to Iconium. ");
INSERT INTO engemtv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","And the disciples were filled with joy and with the Holy Spirit. ");
INSERT INTO engemtv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","And it came to pass in Iconium that they went in together into the synagogue of the Jews, and they spoke in a way so that a great multitude, both of the Jews and of the Greeks, believed. ");
INSERT INTO engemtv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","But the disbelieving Jews aroused and embittered the souls of the Gentiles against the brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Therefore they spent a considerable time there, speaking boldly in the Lord, who was bearing witness to the word of His grace, giving signs and wonders to take place by their hands. ");
INSERT INTO engemtv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","And the multitude of the city was divided: and some were with the Jews, and others with the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","And when an attempt was made by both the Gentiles and the Jews, together with their rulers, to mistreat and to stone them, ");
INSERT INTO engemtv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","they became aware of it and fled to the cities of Lycaonia, Lystra and Derbe, and to the surrounding region. ");
INSERT INTO engemtv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","And there, they were preaching the gospel. ");
INSERT INTO engemtv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","And a certain man in Lystra, powerless in his feet, was sitting, lame from his mother's womb, who had never walked. ");
INSERT INTO engemtv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","This man heard Paul speaking; who, gazing intently on him and seeing that he had faith to be healed, ");
INSERT INTO engemtv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","said with a loud voice, “Stand up straight on your feet!” And he was jumping and walking about. ");
INSERT INTO engemtv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","And the crowds, seeing what Paul had done, raised their voice, saying in the Lycaonian language, “The gods have been made like men and have come down to us!” ");
INSERT INTO engemtv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","And Barnabas they called Zeus, and Paul, Hermes, since he was the leader in speaking. ");
INSERT INTO engemtv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","And the priest of Zeus, whose temple was before their city, bearing bulls and garlands to the gates, together with the crowds, was desiring to sacrifice to them. ");
INSERT INTO engemtv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","But when the apostles, Barnabas and Paul, heard this, they tore their garments and rushed in to the crowd, crying out ");
INSERT INTO engemtv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","and saying, “Men! Why are you doing these things? We men are of the same nature as you, preaching the gospel to you, that you must turn from these useless things to turn to the living God, who made the heaven, and the earth, and the sea, and all the things in them, ");
INSERT INTO engemtv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","who in the generations gone by permitted all the Gentiles to walk in their ways. ");
INSERT INTO engemtv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","And yet He did not leave Himself without witness, in that He did good, giving to you rain from heaven and fruit-bearing seasons, filling our hearts with food and gladness.” ");
INSERT INTO engemtv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","And saying these things, they scarcely stopped the crowds from sacrificing to them. ");
INSERT INTO engemtv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","But there arrived from Antioch and Iconium certain Jews, and having persuaded the crowds and having stoned Paul, they dragged him outside the city, thinking he was dead. ");
INSERT INTO engemtv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","But when the disciples encircled him, he stood and entered into the city. And the next day he went out together with Barnabas to Derbe. ");
INSERT INTO engemtv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","And having preached the gospel to that city and having made many disciples, they returned to Lystra, and Iconium, and Antioch, ");
INSERT INTO engemtv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","strengthening the souls of the disciples, urging them to continue in the faith, saying, “Through many tribulations we must enter into the kingdom of God.” ");
INSERT INTO engemtv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","And having chosen elders for them in every church, and having prayed with fasting, they commended them to the Lord in whom they had believed. ");
INSERT INTO engemtv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","And having crossed Pisidia, they came to Pamphylia. ");
INSERT INTO engemtv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","And having spoken the word in Perga, they went down to Attalia. ");
INSERT INTO engemtv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","From there they sailed to Antioch, where they were commended to the grace of God for the work which they had fulfilled. ");
INSERT INTO engemtv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Now arriving and gathering the church together, they related all that God had done with them, and that He had opened the door of faith for the Gentiles. ");
INSERT INTO engemtv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","And they spent a long time there with the disciples. ");
INSERT INTO engemtv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","And certain men coming down from Judea were teaching the brothers, “If you are not circumcised in the custom of Moses, you cannot be saved.” ");
INSERT INTO engemtv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Therefore when there arose a serious dissension and debate with Paul and Barnabas, they determined that Paul and Barnabas and some others of them should go up to the apostles and elders in Jerusalem concerning this issue. ");
INSERT INTO engemtv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Therefore, being sent forth by the church, they were passing through Phoenicia and Samaria, telling in detail about the conversion of the Gentiles; and they were causing great joy to all the brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","And having come to Jerusalem, they were received by the church and the apostles and the elders; and they declared all that God had done with them. ");
INSERT INTO engemtv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","But some of those from the sect of the Pharisees rose up, saying, “It is necessary to circumcise them, and to command them to keep the law of Moses.” ");
INSERT INTO engemtv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","And the apostles and elders gathered together to see about this matter. ");
INSERT INTO engemtv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","And after much debate, Peter arose and said to them: “Men and brothers, you know that from early days God chose among us, that by my mouth the Gentiles should hear the word of the gospel and believe. ");
INSERT INTO engemtv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","And God, who knows the heart, bore witness to them by giving them the Holy Spirit, just as also He did to us, ");
INSERT INTO engemtv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","and made no distinction between us and them, purifying their hearts by faith. ");
INSERT INTO engemtv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Now therefore, why do you test God by putting a yoke upon the neck of the disciples, which neither our fathers nor we were able to bear? ");
INSERT INTO engemtv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","But through the grace of the Lord Jesus, we believe that we will be saved in the same manner as they.” ");
INSERT INTO engemtv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Then all the multitude stopped speaking and listened to Barnabas and Paul telling as many signs and wonders as God had done among the Gentiles through them. ");
INSERT INTO engemtv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Now after they had finished speaking, James answered, saying, “Men and brothers, listen to me: ");
INSERT INTO engemtv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon has related how God first visited them to take from the Gentiles a people for His name. ");
INSERT INTO engemtv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","And with this the words of the prophets agree, just as it is written: ");
INSERT INTO engemtv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘After this I will return, and I will build again the tabernacle of David, which has fallen; and its ruins I will rebuild, and I will restore it, ");
INSERT INTO engemtv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","in order that the rest of men may seek out the Lord, and all the Gentiles who are called by My name, says the Lord who does all these things.’ ");
INSERT INTO engemtv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","“Known from everlasting to God are all His works. ");
INSERT INTO engemtv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Therefore I judge that we must not cause trouble for those who are turning to God from among the Gentiles; ");
INSERT INTO engemtv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","but that we write to them to abstain from things polluted by idols, and from sexual immorality, from things strangled, and from blood. ");
INSERT INTO engemtv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","For Moses has had from ancient generations those who proclaim him in each city, being read in the synagogues from one Sabbath to another.” ");
INSERT INTO engemtv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Then it seemed best to the apostles and the elders, together with the whole church, to send men being chosen from them to Antioch, together with Paul and Barnabas, namely, Judas who was also named Barsabas, and Silas, leading men among the brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Writing by their hand these things: The apostles, the elders, and the brothers, to the brothers in Antioch, and Syria, and Cilicia who are of the Gentiles: Greetings. ");
INSERT INTO engemtv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Inasmuch as we have heard that some went out from among us and troubled you with words, unsettling your souls, saying, “that you must be circumcised and keep the law”—to whom we gave no such command— ");
INSERT INTO engemtv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","it seemed best to us, being like-minded, to send chosen men to you, with our beloved brothers Barnabas and Paul, ");
INSERT INTO engemtv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","men who have risked their lives for the sake of the name of our Lord Jesus Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","We have therefore sent Judas and Silas, who will also tell you the same things by word of mouth. ");
INSERT INTO engemtv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","For it seemed best to the Holy Spirit, and to us, to put on you no greater burden except for these necessary things: ");
INSERT INTO engemtv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","that you abstain from meat offered to idols, and from blood, and from anything strangled, and from sexual immorality; from which keeping yourselves back, you will do well. Farewell. ");
INSERT INTO engemtv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Then having been dismissed, they came to Antioch; and having gathered the multitude together, they delivered the letter. ");
INSERT INTO engemtv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","And when they had read it, they rejoiced over its encouragement. ");
INSERT INTO engemtv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Now Judas and Silas, themselves being prophets also, encouraged and strengthened the brothers with many words. ");
INSERT INTO engemtv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","And after some time, they were dismissed with peace from the brothers to the apostles. ");
INSERT INTO engemtv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","But Paul and Barnabas spent time in Antioch, teaching and preaching the good news of the word of the Lord, with many others also. ");
INSERT INTO engemtv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Then after some days Paul said to Barnabas, “Let us return now and visit our brothers in each city in which we proclaimed the word of the Lord, and see how they are.” ");
INSERT INTO engemtv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","But Barnabas desired to take along with them John called Mark. ");
INSERT INTO engemtv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","But Paul considered it fitting not to take along with them the one who withdrew from them in Pamphylia, and who had not gone together with them to the work. ");
INSERT INTO engemtv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Therefore a sharp disagreement arose so that they were separated from one another. And Barnabas, taking along Mark, sailed to Cyprus. ");
INSERT INTO engemtv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","But Paul, choosing Silas, departed, being given over to the grace of God by the brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","And he passed through Syria and Cilicia, strengthening the churches. ");
INSERT INTO engemtv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Now he arrived at Derbe and Lystra. And behold, a certain disciple was there named Timothy, the son of a certain Jewish woman who believed, but his father was Greek, ");
INSERT INTO engemtv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","who had a good testimony by the brothers in Lystra and Iconium. ");
INSERT INTO engemtv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul wanted Timothy to accompany him, and he took him and circumcised him, because of the Jews who were in those places, for they all knew that his father was Greek. ");
INSERT INTO engemtv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","And as they were going through the cities, they were delivering to them the decrees to keep, which had been decided by the apostles and the elders at Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Therefore the churches were strengthened in the faith, and were growing in number each day. ");
INSERT INTO engemtv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Now when they had gone through Phrygia and the Galatian region, they were forbidden by the Holy Spirit from speaking the word in Asia. ");
INSERT INTO engemtv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","And having come to Mysia they attempted to go to Bithynia, but the Spirit did not permit them. ");
INSERT INTO engemtv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","So they bypassed Mysia, and went down to Troas. ");
INSERT INTO engemtv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","And a vision appeared during the night to Paul. A certain man of Macedonia was standing, urging him, and saying, “Come across to Macedonia and help us.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Now when he saw the vision, immediately we sought to go out to Macedonia, concluding that the Lord had called us to preach the gospel to them. ");
INSERT INTO engemtv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Therefore, putting to sea from Troas, we ran a straight course to Samothrace, and the next day came to Neapolis, ");
INSERT INTO engemtv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","and from there to Philippi, which is chief of that part of Macedonia, a colony. And we were spending some days in that very city. ");
INSERT INTO engemtv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","And on the Sabbath day we went outside the city beside a river, where prayer was customarily made; and having sat down we spoke to the women who assembled together there. ");
INSERT INTO engemtv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","And a certain woman named Lydia, a dealer of purple cloth of the city of Thyatira, who worshiped God, heard us, whose heart the Lord opened to give heed to the things spoken by Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","And when she and her household were baptized, she urged us, saying, “If you have judged me to be faithful to the Lord, come to my house and stay.” So she persuaded us. ");
INSERT INTO engemtv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Now it came to pass, as we went to prayer, that a certain slave girl, having a spirit of Python, met us, who brought much profit to her masters by fortune telling. ");
INSERT INTO engemtv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","This girl, following after Paul and us, was crying out, saying, “These men are the servants of the Most High God, who proclaim to us the way of salvation.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","And this she did for many days. But Paul, being greatly annoyed and turning around, said to the spirit, “I command you in the name of Jesus Christ to come out of her.” And he came out in that very hour. ");
INSERT INTO engemtv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","And when her masters saw that the hope of their profit was gone, they took Paul and Silas, and dragged them to the marketplace before the rulers. ");
INSERT INTO engemtv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","And bringing them to the magistrates they said, “These men, being Jews, are agitating our city; ");
INSERT INTO engemtv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","and they are proclaiming customs which are not lawful for us to receive or to do, since we are Romans.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","And the crowd rose up together against them; and the magistrates tore their clothes and ordered men to beat them with rods. ");
INSERT INTO engemtv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","And when they laid many strokes on them, they cast them into prison, commanding the prison keeper to keep them securely; ");
INSERT INTO engemtv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","who, having received such a command, cast them into the inner prison and fastened their feet in the stocks. ");
INSERT INTO engemtv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Now about midnight Paul and Silas were praying and singing hymns to God, and the prisoners were listening to them. ");
INSERT INTO engemtv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","And suddenly there was a great earthquake, so that the foundations of the prison were shaken; and immediately all the doors were opened and all the bonds were loosed. ");
INSERT INTO engemtv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","And becoming awake, the prison keeper, seeing the doors of the prison open, drawing a sword, he was about to kill himself, supposing the prisoners to have escaped. ");
INSERT INTO engemtv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","But Paul called out with a loud voice, saying, “Do not harm yourself, for we are all here.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","And asking for a light he rushed in, and he came trembling, and fell before Paul and Silas, ");
INSERT INTO engemtv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","and he brought them forth outside and said, “Sirs, what must I do to be saved?” ");
INSERT INTO engemtv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","And they said, “Believe on the Lord Jesus Christ, and you shall be saved, you and your household.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","And they spoke the word of the Lord to him and to all those in his house. ");
INSERT INTO engemtv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","And he took them along in that same hour of the night and washed their wounds, and immediately he and all his family were baptized. ");
INSERT INTO engemtv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","And bringing them up into his house, he set a meal before them; and he rejoiced with his whole house, having believed in God. ");
INSERT INTO engemtv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Now when it became day, the magistrates sent the officers, saying, “Release those men.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","And the prison keeper told these words to Paul, saying, “The magistrates have sent so that you may be released. Now therefore depart, and go in peace.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","But Paul said to them, “They beat us publicly, although we were uncondemned Romans, and they cast us into prison, and now do they cast us out secretly? No indeed! Let them come themselves and lead us out.” ");
INSERT INTO engemtv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","And the officers related to the magistrates these words, and they were afraid when they heard that they were Romans. ");
INSERT INTO engemtv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","And coming, they appealed to them, and bringing them out, they asked them to depart from the city. ");
INSERT INTO engemtv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","And coming out from the prison, they entered into the house of Lydia; and seeing the brothers, they encouraged them and departed. ");
INSERT INTO engemtv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Now traveling through Amphipolis and Apollonia, they came to Thessalonica, where there was a synagogue of the Jews. ");
INSERT INTO engemtv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","And according to Paul's custom, he went in to them, and for three Sabbaths he reasoned with them from the Scriptures, ");
INSERT INTO engemtv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","interpreting and pointing out that it was necessary for the Christ to suffer, and to arise from the dead, and saying that “This Jesus, whom I preach to you, is the Christ.” ");
INSERT INTO engemtv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","And some of them were persuaded and were joined with Paul and Silas, both of the devout Greeks, a great multitude, and not a few of the chief women. ");
INSERT INTO engemtv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","And the Jews who did not believe took some wicked men from the marketplace, and forming a mob, they threw the city into disorder, and came upon the house of Jason, and sought to bring them to the people. ");
INSERT INTO engemtv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","But when they did not find them, they dragged Jason and some brothers to the rulers of the city, crying out, “The men who have turned the world upside down have come here, too; ");
INSERT INTO engemtv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","whom Jason has received; and these all practice contrary to the decrees of Caesar, saying there is another king—Jesus.” ");
INSERT INTO engemtv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","And they troubled the crowd and the rulers of the city when they heard these things. ");
INSERT INTO engemtv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","And having taken the security bond from Jason and the rest, they released them. ");
INSERT INTO engemtv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Then the brothers immediately sent Paul and Silas away during the night to Berea. When they arrived, they went into the synagogue of the Jews. ");
INSERT INTO engemtv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Now these were more noble-minded than those in Thessalonica, who received the word with all readiness, each day examining the Scriptures to see whether these things might be so. ");
INSERT INTO engemtv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Therefore many of them believed, and not a few of the prominent Greek women and men. ");
INSERT INTO engemtv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","But when the Jews from Thessalonica found out that the word of God was proclaimed by Paul in Berea, they came there also, agitating the crowds. ");
INSERT INTO engemtv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Then immediately the brothers sent Paul away to go toward the sea; but both Silas and Timothy remained there. ");
INSERT INTO engemtv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Now those who escorted Paul brought him to Athens; and receiving a command for Silas and Timothy, that as quickly as possible they should come to him, they departed. ");
INSERT INTO engemtv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","And in Athens, while Paul waited for them, his spirit was provoked within him when he saw that the city was full of idols. ");
INSERT INTO engemtv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Therefore he reasoned in the synagogue with the Jews and with the Gentile worshipers, and in the marketplace daily with those coming by. ");
INSERT INTO engemtv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","And also some of the Epicurean and of the Stoic philosophers were conversing with him. And some were saying, “What does this seed-picker wish to say?” But others said, “He seems to be a proclaimer of foreign deities,” because he was preaching the good news of Jesus and the resurrection. ");
INSERT INTO engemtv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","And taking hold of him, they brought him to the Areopagus, saying, “May we know what this new doctrine is you speak about? ");
INSERT INTO engemtv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","For you are bringing some strange things to our ears. Therefore we desire to know what these things might mean.” ");
INSERT INTO engemtv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Now all the Athenians and the strangers staying there as visitors spent their time in nothing other than to say or to hear some new thing. ");
INSERT INTO engemtv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Then Paul stood in the midst of the Areopagus and said, “Men, Athenians, according to all things I perceive you as being very religious; ");
INSERT INTO engemtv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","for as I passed by and considered the objects of your worship, I found also an altar on which it had been inscribed: TO THE UNKNOWN GOD. Therefore, Him whom being ignorant of you worship, this One I announce to you: ");
INSERT INTO engemtv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","The God who made the world and all the things in it, He being Lord of heaven and earth, does not dwell in temples made with hands, ");
INSERT INTO engemtv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nor by the hands of men is He served, as though He needed anything, for He gives to all life and breath with respect to all things. ");
INSERT INTO engemtv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","And He made from one blood every nation of men to dwell upon all the face of the earth, and He ordained their preappointed times and the boundaries of their dwellings, ");
INSERT INTO engemtv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","in order for them to seek the Lord, if perhaps indeed they might grope for Him and find Him, and yet being indeed not far from each one of us; ");
INSERT INTO engemtv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","for in Him we live and move and have our being, as also some of your own poets have said, ‘For we are also His offspring.’ ");
INSERT INTO engemtv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Therefore, being the offspring of God, we ought not to suppose that the Godhead is like gold or silver or stone, something shaped by art and the imagination of man. ");
INSERT INTO engemtv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","So then these times of ignorance God overlooked, but now He commands all men everywhere to repent, ");
INSERT INTO engemtv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","because He has appointed a day in which He is going to judge the world in righteousness by the Man whom He has appointed, having given proof to all, by raising Him from the dead.” ");
INSERT INTO engemtv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","But when they heard of the resurrection of the dead, some were scoffing, but others said, “We will hear you again concerning this.” ");
INSERT INTO engemtv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","And thus Paul went forth from their midst. ");
INSERT INTO engemtv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","However, some men were joined to him and believed, among whom were also Dionysius the Areopagite, a woman named Damaris, and others with them. ");
INSERT INTO engemtv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Now after these things, having departed from Athens, Paul came to Corinth. ");
INSERT INTO engemtv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","And he found a certain Jew named Aquila, a native of Pontus, having recently come from Italy with Priscilla his wife (because Claudius had ordered all the Jews to depart from Rome); and he came to them, ");
INSERT INTO engemtv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","and because he was of the same trade, he remained with them and worked, for they were tentmakers by trade. ");
INSERT INTO engemtv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","And he reasoned in the synagogue every Sabbath, and persuaded both Jews and Greeks. ");
INSERT INTO engemtv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Now when both Silas and Timothy came down from Macedonia, Paul was compelled by the Spirit, solemnly bearing witness to the Jews that Jesus is the Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","And when they opposed and reviled him, he shook out his clothes and said to them, “Your blood be on your own heads; I am clean. From now on I will go to the Gentiles.” ");
INSERT INTO engemtv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","And having gone over from there, he went into the house of a certain man named Justus, who worshiped God, whose house was next door to the synagogue. ");
INSERT INTO engemtv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","And Crispus, the ruler of the synagogue, believed in the Lord, together with all his household. And many of the Corinthians, hearing, were believing and were being baptized. ");
INSERT INTO engemtv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Now the Lord spoke to Paul by a vision in the night, saying, “Do not fear, but speak, and do not keep silent; ");
INSERT INTO engemtv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","for I am with you, and no one will attack you to harm you; for I have many people in this city.” ");
INSERT INTO engemtv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","And he settled there a year and six months, teaching the word of God among them. ");
INSERT INTO engemtv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Now while Gallio was proconsul of Achaia, the Jews with one purpose rose up against Paul and brought him before the judgment seat, ");
INSERT INTO engemtv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","saying, “This man persuades men to worship God contrary to the law.” ");
INSERT INTO engemtv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","And when Paul was about to open his mouth, Gallio said to the Jews, “If then it was some misdeed or wicked crime, O Jews, according to reason I would bear with you. ");
INSERT INTO engemtv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","But if it is a question about a word and names and your own law, see to it yourselves; for I do not wish to be a judge of these things.” ");
INSERT INTO engemtv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","And he drove them away from the judgment seat. ");
INSERT INTO engemtv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Then all the Greeks, taking hold of Sosthenes the ruler of the synagogue, were beating him before the judgment seat. And none of these things was a concern to Gallio. ");
INSERT INTO engemtv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Now Paul still remained there a good while, then bid farewell to the brothers, and sailed away for Syria, and Priscilla and Aquila were with him. He had his hair cut off in Cenchrea, for he had taken a vow. ");
INSERT INTO engemtv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","And he arrived in Ephesus, and he left those two there; but he, having entered into the synagogue, reasoned with the Jews. ");
INSERT INTO engemtv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","And when they asked him to remain with them for a longer time, he declined, ");
INSERT INTO engemtv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","but bid farewell to them saying, “I must by all means keep this coming feast which is in Jerusalem; but I will return again to you, God willing.” And he put out to sea from Ephesus. ");
INSERT INTO engemtv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","And having gone down to Caesarea, and having gone up and greeted the church, he went down to Antioch. ");
INSERT INTO engemtv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","After having spent some time there, he departed, and went from place to place through the Galatian region and the Phrygian region, strengthening all the disciples. ");
INSERT INTO engemtv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Now a certain Jew named Apollos, a native of Alexandria, an eloquent man and mighty in the Scriptures, had arrived in Ephesus. ");
INSERT INTO engemtv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","This man had been instructed in the way of the Lord; and being fervent in spirit, he spoke and taught accurately the things about the Lord, although he knew only the baptism of John. ");
INSERT INTO engemtv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","And he began to speak boldly in the synagogue. And when Aquila and Priscilla heard him, they took him aside and explained to him the way of God more accurately. ");
INSERT INTO engemtv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","And when he desired to go across to Achaia, having urged him on, the brothers wrote to the disciples there to receive him; and when he arrived, he assisted greatly with those who had believed through grace; ");
INSERT INTO engemtv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","for he was powerfully refuting the Jews publicly, demonstrating by the Scriptures that Jesus was the Messiah. ");
INSERT INTO engemtv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","And it came about, while Apollos was in Corinth, that Paul, having gone through the interior regions, came to Ephesus. And finding some disciples ");
INSERT INTO engemtv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","he said to them, “Did you receive the Holy Spirit, having believed?” So they said to him, “We have not even heard whether there is a Holy Spirit.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","And he said to them, “Into what then were you baptized?” So they said, “Into John's baptism.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","But Paul said, “John indeed baptized with a baptism of repentance, saying to the people that they should believe in the One coming after him, that is, in Christ Jesus.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","And when they heard this, they were baptized in the name of the Lord Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","And when Paul laid his hands on them, the Holy Spirit came upon them, and they spoke in tongues and prophesied. ");
INSERT INTO engemtv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Now all the men were about twelve. ");
INSERT INTO engemtv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","And he entered into the synagogue and spoke boldly for three months, debating and persuading the things concerning the kingdom of God. ");
INSERT INTO engemtv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","But when some became hardened and disbelieving, speaking evil against the Way before the multitude, he withdrew from them and separated the disciples, each day debating in the school of Tyrannus. ");
INSERT INTO engemtv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Now this took place for two years, so that all who were dwelling in Asia heard the word of the Lord Jesus, both Jews and Greeks. ");
INSERT INTO engemtv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","And God was doing extraordinary miracles by the hands of Paul, ");
INSERT INTO engemtv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","so that even handkerchiefs or aprons from his body were brought to those who were sick, and the diseases departed from them, and the evil spirits went out from them. ");
INSERT INTO engemtv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Then some of the wandering Jews, exorcists, attempted to name the name of the Lord Jesus over those having the evil spirits, saying, “We adjure you by the Jesus whom Paul preaches.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Now there were seven sons of Sceva, a Jewish high priest, doing this. ");
INSERT INTO engemtv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","But the evil spirit answered and said, “Jesus I know, and Paul I recognize, but who are you?” ");
INSERT INTO engemtv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Then the man in whom was the evil spirit leaped upon them, and having subdued them, prevailed against them, so that they ran out of the house naked and wounded. ");
INSERT INTO engemtv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Now this became known to all both Jews and Greeks who were dwelling in Ephesus; and fear fell upon them all, and they were praising the name of the Lord Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","And many of those who had believed were coming, confessing and disclosing their deeds. ");
INSERT INTO engemtv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","And many of those who were practicing magic brought together their books and burned them up before everyone. And they counted up the prices of them, and found it to be fifty thousand pieces of silver. ");
INSERT INTO engemtv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Thus the word of the Lord was growing powerfully and prevailed. ");
INSERT INTO engemtv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Now after these events, Paul resolved in his spirit to go to Jerusalem, after he went through Macedonia and Achaia, saying, “After I have been there, I must also see Rome.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","And having sent to Macedonia two of those who were ministering to him, Timothy and Erastus, he himself stayed on for a time in Asia. ");
INSERT INTO engemtv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Now there arose during that time a serious disturbance concerning the Way. ");
INSERT INTO engemtv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","For a certain man named Demetrius, a silversmith, who made silver shrines of Artemis, providing no little trade for the craftsmen, ");
INSERT INTO engemtv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","whom he gathered, with the workers of similar occupation, and said: “Men, you know that from this business we have our wealth. ");
INSERT INTO engemtv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","And you observe and hear that not only at Ephesus, but almost in all of Asia, this Paul has persuaded and turned away a great multitude, saying that they are not gods which are made by human hands. ");
INSERT INTO engemtv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","And not only is this business of ours in danger to come into disrepute, but also the temple of the great goddess Artemis may be despised and also her magnificence, and is about to be destroyed, she whom all Asia and the world worship.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","And hearing this, and becoming full of anger, they were crying out saying, “Great is Artemis of the Ephesians!” ");
INSERT INTO engemtv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","And the whole city was filled with confusion, and they rushed with one purpose into the theater, having seized Gaius and Aristarchus, Macedonians, traveling companions of Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Now when Paul desired to enter into the people, the disciples would not permit him. ");
INSERT INTO engemtv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","And also some of the officials of Asia, being friends with him, sent word to him and urged him not to present himself in the theater. ");
INSERT INTO engemtv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Then others were calling out something different, for the assembly was confused, and the majority did not know for what reason they had come together. ");
INSERT INTO engemtv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","And from the crowd they brought forward Alexander, the Jews putting him forward. And Alexander motioned with his hand, and desired to make a defense to the people. ");
INSERT INTO engemtv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","But recognizing he was a Jew, there arose one voice from them all, calling out for two hours, “Great is Artemis of the Ephesians!” ");
INSERT INTO engemtv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","And having quieted the crowd, the city clerk said: “Men of Ephesus, for what man is there who does not know that the city of the Ephesians is the temple keeper of the great goddess Artemis, and of the image fallen from heaven? ");
INSERT INTO engemtv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Therefore, since these things are undeniable, it is necessary for you to be quieted and to do nothing rash. ");
INSERT INTO engemtv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","For you have brought these men here who are neither temple thieves nor blasphemers of your goddess. ");
INSERT INTO engemtv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Therefore, if Demetrius and his fellow craftsmen have a word against anyone, the courts are in session, and there are proconsuls. Let them bring charges against one another. ");
INSERT INTO engemtv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","But if you are wanting to know anything about other matters, it shall be determined by a lawful assembly. ");
INSERT INTO engemtv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","For we also are in danger of being accused of insurrection concerning today's events, there being no cause for which we will be able to give, as an explanation for this commotion.” ");
INSERT INTO engemtv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","And having said these things, he dismissed the assembly. ");
INSERT INTO engemtv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Now after the disturbance had ceased, Paul, summoning the disciples and greeting them, went away to go to Macedonia. ");
INSERT INTO engemtv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","And going through those parts, and encouraging them with many words, he came to Greece ");
INSERT INTO engemtv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","and spent three months there. And as a plot by the Jews developed against him, as he was to put to sea for Syria, a decision came about to return through Macedonia. ");
INSERT INTO engemtv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","And Sopater, a Berean, was accompanying him to Asia—also Aristarchus of the Thessalonians, and Secundus, and Gaius of Derbe, and Timothy, and Tychicus and Trophimus, the Asians. ");
INSERT INTO engemtv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","These men, having gone ahead, were waiting for us in Troas. ");
INSERT INTO engemtv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","And we sailed away after the days of Unleavened Bread, from Philippi, and we came to them in Troas within five days, where we spent seven days. ");
INSERT INTO engemtv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Now on the first day of the week, the disciples being assembled to break bread, Paul was discussing with them, being about to leave on the next day, and extended his message until midnight. ");
INSERT INTO engemtv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","And there were a considerable number of lamps in the upper room where we were assembled. ");
INSERT INTO engemtv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","And a certain young man named Eutychus sat in the window, being overwhelmed by a deep sleep. While Paul was speaking for a while longer, having been overwhelmed by sleep, he fell down from the third story and was taken up dead. ");
INSERT INTO engemtv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","But Paul, going down, fell upon him, and embracing him said, “Do not be troubled, for his life is in him.” ");
INSERT INTO engemtv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","And going up and breaking bread and eating, and talking for a considerable time, until daybreak, thus he departed. ");
INSERT INTO engemtv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","And they brought the boy living, and they were encouraged greatly. ");
INSERT INTO engemtv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Now we, having gone ahead on the ship, put to sea for Assos, from there intending to take Paul on board; for thus it had been arranged, since he intended to go on foot. ");
INSERT INTO engemtv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","And when he met us at Assos, having taken him aboard, we came to Mitylene. ");
INSERT INTO engemtv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","And having sailing away from there, on the next day we arrived opposite Chios. The following day we approached to Samos and remained in Trogyllium. The following day we came to Miletus. ");
INSERT INTO engemtv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","For Paul had decided to sail past Ephesus, in order that it might not happen to him to spend time in Asia; for he was hurrying, if it was possible for him to be in Jerusalem on the day of Pentecost. ");
INSERT INTO engemtv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Now from Miletus, having sent to Ephesus, he summoned the elders of the church. ");
INSERT INTO engemtv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","And when they were present with him, he said to them: “You know from the first day which I arrived in Asia, how I was with you the whole time, ");
INSERT INTO engemtv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","serving the Lord with all humility, and with many tears and trials which happened to me by the plots of the Jews; ");
INSERT INTO engemtv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","how I kept back nothing that was profitable, but declared it to you, teaching you publicly and from house to house, ");
INSERT INTO engemtv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","solemnly bearing witness to both Jews and to Greeks, repentance toward God and faith toward our Lord Jesus. ");
INSERT INTO engemtv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","And now behold, I, having been bound in the spirit, am going to Jerusalem, not knowing the things that will happen to me there, ");
INSERT INTO engemtv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","except that the Holy Spirit in every city is solemnly bearing witness, saying that bonds and tribulations are waiting for me. ");
INSERT INTO engemtv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","But I count myself as nothing; nor do I regard my life as valuable to myself, so that I may complete my course with joy, and the ministry which I received from the Lord Jesus, to bear solemn testimony to the gospel of the grace of God. ");
INSERT INTO engemtv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“And now behold, now I know that you all, among whom I have passed through preaching the kingdom of God, will no longer see my face. ");
INSERT INTO engemtv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Therefore I testify to you this very day, that I am innocent of all blood. ");
INSERT INTO engemtv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","For I did not draw back from declaring to you the whole counsel of God. ");
INSERT INTO engemtv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Therefore take heed to yourselves and to all the flock, in which the Holy Spirit placed you as overseers, to shepherd the church of the Lord, and of God, which He purchased with His own blood. ");
INSERT INTO engemtv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","For I know this, that savage wolves will come in after my departure, not sparing the flock. ");
INSERT INTO engemtv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Also from among you yourselves will arise men speaking things having been distorted, in order to draw away the disciples after them. ");
INSERT INTO engemtv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Therefore be alert, remembering that for three years, night and day I did not cease, with tears, exhorting each one. ");
INSERT INTO engemtv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“So for the present, I entrust you, brothers, to God and to the word of His grace, which is able to build you up and give you an inheritance among all those who have been sanctified. ");
INSERT INTO engemtv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","I have coveted the silver or gold or clothes of no one. ");
INSERT INTO engemtv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","You yourselves know that these hands have rendered service to my needs, and those who were with me. ");
INSERT INTO engemtv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","By all things I have shown you, that thus laboring it is necessary to help the weak, and to remember the words of the Lord Jesus, that He said, ‘It is more blessed to give than to receive.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","And having said these things, he knelt down, together with them all, and prayed. ");
INSERT INTO engemtv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","And there was considerable weeping by all, and falling on Paul's neck, they kissed him, ");
INSERT INTO engemtv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","feeling pain most of all for the words which he said, that they were about to see his face no more. And they accompanied him to the ship. ");
INSERT INTO engemtv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Now when it came to pass that we had put to sea, having withdrawn from them, running a straight course we came to Cos, and on the next day to Rhodes, and from there to Patara. ");
INSERT INTO engemtv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","And having found a ship crossing over to Phoenicia, we boarded it and put to sea. ");
INSERT INTO engemtv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","When we had sighted Cyprus, and had left it behind on the left, we sailed to Syria, and put in to harbor in Tyre, for the ship was unloading its cargo. ");
INSERT INTO engemtv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","And having discovered disciples, we stayed there seven days. They said to Paul through the Spirit not to go up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","But when it came about that we had completed the days there, having gone out we departed, all of them accompanying us, together with their wives and children, until we were outside the city. And having bowed our knees on the shore, we prayed. ");
INSERT INTO engemtv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","And having greeted one another, we went up into the ship, and they returned to their own homes. ");
INSERT INTO engemtv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","And completing our voyage from Tyre, we arrived in Ptolemais, and having greeted the brothers, we stayed one day with them. ");
INSERT INTO engemtv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","On the next day those accompanying Paul went forth and came to Caesarea, and entering into the house of Philip the evangelist, who was one of the seven, we stayed with him. ");
INSERT INTO engemtv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Now this man had four virgin daughters who prophesied. ");
INSERT INTO engemtv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","And while we remained there several days, a certain prophet from Judea named Agabus came down. ");
INSERT INTO engemtv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","And coming to us and taking Paul's belt, and binding his feet and hands, he said, “Thus says the Holy Spirit: ‘The man whose belt this is, the Jews will bind in this way in Jerusalem, and they will deliver him into the hands of the Gentiles.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Now when we heard these things, both we and the local residents urged him not to go up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Then Paul answered, “Why are you weeping and breaking my heart? For I am ready not only to be bound, but also to die at Jerusalem, for the name of the Lord Jesus.” ");
INSERT INTO engemtv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","And when he remained unpersuaded, we were silent and said, “Let the will of the Lord be done.” ");
INSERT INTO engemtv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Now after those days, having prepared, we went up to Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Also some of the disciples from Caesarea went with us and brought with them a certain Cypriot named Mnason, a long-standing disciple, with whom we would stay as a guest. ");
INSERT INTO engemtv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","And when we arrived in Jerusalem, the brothers gladly received us. ");
INSERT INTO engemtv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","On the next day Paul was going in with us to James, and all the elders were present. ");
INSERT INTO engemtv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","And having greeted them, he reported one by one those things which God had done among the Gentiles through his ministry. ");
INSERT INTO engemtv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","And hearing this, they were glorifying the Lord, saying to him, “You see, brother, how many thousands of Jews there are who have believed, and they are all zealous for the law; ");
INSERT INTO engemtv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","and they have been informed about you, that you are teaching defection from Moses, to all the Jews who are among the Gentiles, saying for them not to circumcise their children nor to walk in our customs. ");
INSERT INTO engemtv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","What then? It is certainly necessary for an assembly to come together; for they will hear that you have come. ");
INSERT INTO engemtv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Therefore do this, which we say to you: There are four men with us who have taken a vow upon themselves. ");
INSERT INTO engemtv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Take them and purify yourself with them, and pay for them that they may have their heads shaved, and that all may know that those things of which they have been informed about you are nothing, but that you are agreeing with and keeping the law yourself. ");
INSERT INTO engemtv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","But as for the Gentile believers, we wrote, having judged that they should keep no such thing, except that they should keep themselves from things offered to idols, from blood, and from anything strangled, and from sexual immorality.” ");
INSERT INTO engemtv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Then Paul, having taken the men, on the next day having been purified with them, entered into the temple, thus giving notice to the completion of the days of the purification, until the time when the offering was offered in behalf of each one of them. ");
INSERT INTO engemtv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Now when the seven days were about to be completed, the Jews from Asia, seeing him in the temple, were stirring up all the crowd and put their hands on him, ");
INSERT INTO engemtv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","crying out, “Men of Israel, help us! This is the man who is teaching all people everywhere against the people and the Law and this place; and furthermore he has brought Greeks into the temple and has defiled this holy place.” ");
INSERT INTO engemtv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","For they had seen Trophimus the Ephesian in the city with him, whom they supposed that Paul had brought into the temple. ");
INSERT INTO engemtv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","And all the city was aroused; and there was a mob forming among the people, and taking hold of Paul they were dragging him outside the temple; and immediately the doors were shut. ");
INSERT INTO engemtv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","And seeking to kill him, a report went up to the commander of the garrison that all Jerusalem had been stirred up, ");
INSERT INTO engemtv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","who immediately having taken along soldiers and centurions, ran down among them. And when they saw the commander and the soldiers, they stopped beating Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","And the commander, approaching, took hold of him, and ordered him to be bound with two chains; and he was inquiring who he might be and what he had done. ");
INSERT INTO engemtv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","But others among the crowd were crying out one thing and some another; and because he was unable to ascertain the truth because of the noise, he commanded him to be brought into the barracks. ");
INSERT INTO engemtv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","But when he arrived at the stairs, he had to be carried by the soldiers because of the violence of the crowd. ");
INSERT INTO engemtv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","For the multitude of the people was following, calling out, “Take him away!” ");
INSERT INTO engemtv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Then as Paul was about to be led into the barracks, he said to the commander, “Is it permitted for me to speak to you?” And he said, “Do you know Greek? ");
INSERT INTO engemtv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Are you not then the Egyptian who rose up before these days, and led forth the four thousand men of the assassins into the wilderness?” ");
INSERT INTO engemtv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","But Paul said, “I am a Jew from Tarsus of Cilicia, a citizen of no obscure city; and I request of you, permit me to speak to the people.” ");
INSERT INTO engemtv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","And permitting him, Paul stood on the stairs and motioned with his hand to the people. And when there was a great silence, he addressed them in the Hebrew language, saying, ");
INSERT INTO engemtv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Men, brothers and fathers, hear my defense to you now.” ");
INSERT INTO engemtv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","And hearing that he was addressing them in the Hebrew language, they granted him more silence. And he said: ");
INSERT INTO engemtv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“I am indeed a Jew, having been born in Tarsus of Cilicia, but having been brought up in this city at the feet of Gamaliel, having been educated according to the exactness of the law of our forefathers, being zealous for God just as you all are today. ");
INSERT INTO engemtv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","I, who persecuted this Way to the death, binding and handing over to prisons both men and women, ");
INSERT INTO engemtv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","as also the high priest testifies of me, along with the council of the elders, from whom I also received letters to the brothers, and went to Damascus in order to bring those who were there, having been bound, to Jerusalem, that they might be punished. ");
INSERT INTO engemtv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Now it happened, as I was going and approaching Damascus, about midday, suddenly from heaven a great light shone about me. ");
INSERT INTO engemtv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","And I fell to the ground and heard a voice saying to me, ‘Saul, Saul, why are you persecuting Me?’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","So I answered, ‘Who are You, Lord?’ And He said to me, ‘I am Jesus the Nazarene, whom you are persecuting.’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","“And those who were with me observed the light and became terrified, but they did not hear the voice of the One speaking to me. ");
INSERT INTO engemtv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","So I said, ‘What shall I do, Lord?’ And the Lord said to me, ‘Arise and go into Damascus, and it will be told to you about all the things which it has been appointed for you to do.’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","And since I could not see because of the brightness of that light, being led by the hand by those who were with me, I came into Damascus. ");
INSERT INTO engemtv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“And Ananias, a certain devout man according to the law, being testified of by all the Jews dwelling in Damascus, ");
INSERT INTO engemtv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","came to me and he stood and said to me, ‘Brother Saul, receive your sight.’ And I, in that very hour, looked up at him. ");
INSERT INTO engemtv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","And he said, ‘The God of our fathers has chosen you to know His will, and to see the Righteous One, and hear the voice from His mouth. ");
INSERT INTO engemtv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","For you shall be a witness for Him to all men of what you have seen and heard. ");
INSERT INTO engemtv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","And now, what are you going to do? Arise and be baptized, and wash away your sins, calling on the name of the Lord.’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“And it happened to me, having returned to Jerusalem and praying in the temple, that I came to be in a trance, ");
INSERT INTO engemtv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","and saw Him saying to me, ‘Hurry and go out quickly from Jerusalem, for they will not receive your witness about Me.’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","And I said, ‘Lord, they know that in every synagogue I was imprisoning and beating those believing on You. ");
INSERT INTO engemtv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","And when the blood of Your witness Stephen was shed, I myself was standing by consenting to his murder, and guarding the clothes of those murdering him.’ ");
INSERT INTO engemtv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Then He said to me, ‘Go, for I will send you far away to the Gentiles.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Now they were listening to him until this statement, and they lifted their voice saying, “Take away such a man from the earth, for it is not fitting for him to live!” ");
INSERT INTO engemtv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","And as they were crying out and throwing off their clothes, and throwing dust in the air, ");
INSERT INTO engemtv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","the commander ordered him to be brought into the barracks, and said for him that he should be given a hearing with scourging, so that he might learn why they were shouting at him like this. ");
INSERT INTO engemtv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","But as they were stretching him out with the thongs, Paul said to the centurion standing there, “Is it lawful for you to scourge a man who is a Roman, and uncondemned?” ");
INSERT INTO engemtv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","And the centurion, hearing this, going to the commander he reported, saying, “Watch what you are about to do, for this man is a Roman.” ");
INSERT INTO engemtv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Then the commander came and said to him, “Tell me, are you a Roman?” He said, “Yes.” ");
INSERT INTO engemtv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","And the commander answered, “I acquired this citizenship with much money.” And Paul said, “But I was born a citizen.” ");
INSERT INTO engemtv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Then immediately those who were about to interrogate him withdrew from him; and even the commander was afraid, having learned that he was a Roman, and that he had bound him. ");
INSERT INTO engemtv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Now on the next day, desiring to know the truth as to why he was accused by the Jews, he released him from the bonds, and ordered the chief priests and their whole council to come, and brought Paul down and presented him to them. ");
INSERT INTO engemtv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Then Paul, looking intently at the council, said, “Men, brothers, I have lived with all good conscience toward God until this day.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","But the high priest Ananias commanded those standing by him to strike him on the mouth. ");
INSERT INTO engemtv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Then Paul said to him, “God is about to strike you, you whitewashed wall! For you sit judging me according to the law, and contrary to the law do you command that I should be struck?” ");
INSERT INTO engemtv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","But those standing by said, “Do you revile the high priest of God?” ");
INSERT INTO engemtv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Then Paul said, “I did not know, brothers, that he is the high priest; for it is written, ‘You shall not speak wickedly of a ruler of your people.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","But when Paul perceived that one part was of the Sadducees and the other of the Pharisees, he cried out in the Sanhedrin, “Men and brothers, I am a Pharisee, a son of a Pharisee; concerning the hope and resurrection of the dead I am being judged!” ");
INSERT INTO engemtv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","And when he had spoken this, there came to be a dispute between the Pharisees and the Sadducees, and the assembly was divided. ");
INSERT INTO engemtv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","For the Sadducees say that there is no resurrection—nor angel nor spirit; but the Pharisees confess both. ");
INSERT INTO engemtv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","And there came to be a great outcry, and the scribes of the Pharisees' party stood up and contended sharply, saying, “We find no evil in this man; but if a spirit or an angel has spoken to him, let us not fight against God.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","And when much dissension developed, the commander, fearing lest Paul might be torn apart by them, commanded the detachment of soldiers to go down and seize him from the midst of them, and to bring him into the barracks. ");
INSERT INTO engemtv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Now on the next night the Lord stood by him and said, “Take courage, Paul; for as you solemnly testified about the things concerning Me in Jerusalem, so you must also testify in Rome.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Now when it was day, some of the Jews joined in a conspiracy and bound themselves by a curse, saying neither would they eat nor drink until they had killed Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","And there were over forty who had made this plot; ");
INSERT INTO engemtv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","who came to the chief priests and to the elders and said, “We have bound ourselves by oath with a curse to taste nothing until we have killed Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Now you, therefore, together with the council, suggest to the commander that he be brought down to you tomorrow, as though you are going to determine more accurately the things concerning him; but we, before he comes near, are prepared to kill him.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","But when Paul's sister's son heard about the ambush, he came and entered into the barracks, and told this to Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","And Paul, summoning one of the centurions, said, “Lead this young man away to the commander, for he has something to tell him.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Therefore taking him along, he brought him to the commander and said, “The prisoner Paul, having summoned me, asked me to bring this young man to you, for he has something to tell you.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","And the commander, taking him by his hand, withdrew to a private place and inquired, “What is it that you have to tell me?” ");
INSERT INTO engemtv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","And he said, “The Jews have agreed to ask that tomorrow you bring Paul down to the Sanhedrin, as though they are going to learn something more accurate concerning him. ");
INSERT INTO engemtv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Therefore you must not be persuaded by them; for more than forty of them are lying in wait for him, who have bound themselves by a curse neither to eat nor to drink until they have killed him; and now they are prepared, waiting for the promise from you.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Then the commander dismissed the young man, and commanded him, “Tell no one that you have made known these things to me.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","And having summoned two of the centurions he said, “Make ready two hundred soldiers, and seventy horsemen, and two hundred spearmen, in order that they may go to Caesarea, to leave at the third hour of the night; ");
INSERT INTO engemtv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","and place mounts at their disposal, in order that they may put Paul on them, and bring him safely to Felix the governor.” ");
INSERT INTO engemtv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","And he wrote a letter which contained this content: ");
INSERT INTO engemtv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Claudius Lysias, to the most excellent governor Felix: Greetings. ");
INSERT INTO engemtv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","This man, having been arrested by the Jews, was about to be killed by them. I came upon them with the detachment of soldiers and rescued him, having learned that he is a Roman. ");
INSERT INTO engemtv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","And desiring to know the cause for which they were accusing him, I took him down to their council; ");
INSERT INTO engemtv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","and I found that he was accused concerning questions of their law, but had no accusation against him worthy of death or chains. ");
INSERT INTO engemtv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","And when it became known to me that a plot against the man by the Jews was about to happen, I sent him at once to you, and also commanded the accusers to state the charges against him before you. Farewell. ");
INSERT INTO engemtv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Then the soldiers, as they were commanded, took Paul and brought him during the night to Antipatris. ");
INSERT INTO engemtv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","And on the next day they left the horsemen to go on with him, and returned to the barracks. ");
INSERT INTO engemtv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","When they entered into Caesarea and delivered the letter to the governor, they also presented Paul to him. ");
INSERT INTO engemtv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","And when the governor read the letter, he asked what province he was from. And learning that he was from Cilicia, ");
INSERT INTO engemtv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","he said, “I will give you a hearing when your accusers arrive.” And he commanded him to be guarded in Herod's Praetorium. ");
INSERT INTO engemtv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Now after five days Ananias the high priest came down with the elders and a certain attorney named Tertullus, who made known to the governor the charges against Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","And when he had been called, Tertullus began to accuse him, saying: “Attaining much peace by you and successes coming about for this nation by your foresight, ");
INSERT INTO engemtv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","both in everything and everywhere we accept it, most excellent Felix, with all thanksgiving. ");
INSERT INTO engemtv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","But that I not weary you any longer, I beseech you to hear us briefly in your graciousness. ");
INSERT INTO engemtv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","For we have found this man to be a plague, and one causing discord among all the Jews throughout the world, and a leader of the Nazarenes sect, ");
INSERT INTO engemtv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","who also attempted to profane the temple, whom we also arrested, ");
INSERT INTO engemtv_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","(This verse omitted in Majority Text) ");
INSERT INTO engemtv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","from whom you will be able, having judged him yourself, to learn about all these things of which we are accusing him.” ");
INSERT INTO engemtv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","And the Jews also joined in the attack, asserting that these things were so. ");
INSERT INTO engemtv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","But Paul answered (the governor, having nodded for him to speak): “Knowing that you have been a judge of this nation for many years, the more cheerfully I defend the things concerning myself, ");
INSERT INTO engemtv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","because you being able to know that it has not been more than twelve days since I went up to worship in Jerusalem. ");
INSERT INTO engemtv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","And they did not find me with anyone in the temple disputing, or inciting a crowd to rise up, neither in the synagogues nor in the city. ");
INSERT INTO engemtv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nor are they able to prove against me the things about which they are now accusing me. ");
INSERT INTO engemtv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","But I confess this to you, that according to the Way which they call a sect, so I worship the God of my fathers, believing in all things which are written throughout the Law and in the Prophets, ");
INSERT INTO engemtv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","having hope in God, which even they themselves are waiting for, that there is going to be a resurrection of the dead, both of the just and the unjust. ");
INSERT INTO engemtv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","And in this I myself am engaging, having a conscience blameless toward God and men through everything. ");
INSERT INTO engemtv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“And after many years I arrived to bring alms and offerings to my nation, ");
INSERT INTO engemtv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","among whom some Jews from Asia found me, having been purified in the temple, not with a crowd nor with turmoil, ");
INSERT INTO engemtv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","who ought to be present before you and to make accusation if anything they might have against me. ");
INSERT INTO engemtv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Or let these themselves say what wrong they found in me, when I stood before the council, ");
INSERT INTO engemtv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","unless it is because of this one statement which I cried out, standing among them, ‘Concerning the resurrection of the dead I am being judged by you today.’ ” ");
INSERT INTO engemtv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","And when he heard these things, Felix adjourned them, knowing more accurately the things concerning the Way, and said, “When Lysias the commander comes down, I will decide your case.” ");
INSERT INTO engemtv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","And ordering the centurion to keep watch over Paul and to let him have some liberty, and not to forbid any of his own to serve or to come to him. ");
INSERT INTO engemtv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Now after some days, when Felix arrived with Drusilla his wife, who was Jewish, he sent for Paul and heard him concerning the faith in Christ. ");
INSERT INTO engemtv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","And as he reasoned about righteousness, self-control, and the judgment to come, Felix became afraid and answered, “Go away for now; but when I have opportunity I will summon you.” ");
INSERT INTO engemtv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Meanwhile he also hoped that money would be given him by Paul, that he might release him. Therefore sending for him more often, he was conversing with him. ");
INSERT INTO engemtv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","But after two years had passed, Felix was succeeded by Porcius Festus; and Felix, desiring to grant favors to the Jews, left Paul in prison. ");
INSERT INTO engemtv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Now when Festus had set foot in the province, after three days he went up to Jerusalem from Caesarea. ");
INSERT INTO engemtv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","And the high priest and the prominent men of the Jews made known to him the case against Paul; and they were appealing to him, ");
INSERT INTO engemtv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","asking for favor against him, that he would summon him to Jerusalem—while planning an ambush to kill him along the way. ");
INSERT INTO engemtv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","But Festus answered that Paul should be kept at Caesarea, and that he was about to go there shortly. ");
INSERT INTO engemtv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Therefore,” he said, “the prominent men among you, let them go with me and accuse this man, if there is anything in this man.” ");
INSERT INTO engemtv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","And when he had stayed among them more than ten days, he went down to Caesarea. And the next day, sitting on the judgment seat, he commanded Paul to be brought. ");
INSERT INTO engemtv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","When he arrived, the Jews who had come down from Jerusalem stood around him, bringing many and serious accusations against Paul, which they were not able to prove, ");
INSERT INTO engemtv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","while he defended himself, saying, “Neither against the law of the Jews, nor against the temple, nor against Caesar did I commit any sin.” ");
INSERT INTO engemtv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","But Festus, desiring to grant a favor to the Jews, answered Paul and said, “Are you willing to go up to Jerusalem and there be judged before me concerning these things?” ");
INSERT INTO engemtv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","But Paul said, “I am standing before the judicial bench of Caesar, by whom it is necessary for me to be judged. I have done no wrong to the Jews, as also you know very well. ");
INSERT INTO engemtv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","For if I am doing wrong, and have done anything worthy of death, I am not trying to escape a death sentence; but if there is nothing in these things of which these people are accusing me, no one is able to deliver me to them. I appeal to Caesar.” ");
INSERT INTO engemtv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Then Festus, having talked together with the council, answered, “Have you appealed to Caesar? Before Caesar you shall go!” ");
INSERT INTO engemtv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","And after some days King Agrippa and Bernice arrived in Caesarea and greeted Festus. ");
INSERT INTO engemtv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","And as he was spending many days there, Festus laid before the king the charges against Paul, saying: “There is a certain man who was left a prisoner by Felix, ");
INSERT INTO engemtv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","about whom the chief priests and the elders of the Jews informed me, when I was in Jerusalem, asking for punishment against him. ");
INSERT INTO engemtv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","To them I answered, ‘It is not a custom with Romans to deliver any man to destruction before the one being accused may meet his accusers face to face, and may receive an opportunity for defense concerning the charge.’ ");
INSERT INTO engemtv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Therefore when they had assembled here, having made no delay, on the next day I took my seat at the judicial bench, and I commanded the man to be brought in; ");
INSERT INTO engemtv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","concerning whom, when the accusers stood, they brought no accusation of the things which I was supposing, ");
INSERT INTO engemtv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","but had some questions against him about their own religion and about a certain Jesus, who had died, whom Paul professed to be alive. ");
INSERT INTO engemtv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","And being uncertain as to the investigation concerning this, I asked whether he was willing to go to Jerusalem and there be judged concerning these charges. ");
INSERT INTO engemtv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","But when Paul appealed that he be kept for the decision of His Majesty the Emperor, I commanded him to be kept until I may send him to Caesar.” ");
INSERT INTO engemtv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Then Agrippa said to Festus, “I also was wishing to hear the man myself.” “Tomorrow,” he said, “you shall hear him.” ");
INSERT INTO engemtv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Therefore on the next day, when Agrippa and Bernice had come with all pomp, and had entered into the auditorium together with the commanders and the prominent men of the city, and when Festus had commanded, Paul was brought. ");
INSERT INTO engemtv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","And Festus said: “King Agrippa and all the men who are with us, observe this man about whom the people of the Jews petitioned me, both in Jerusalem and here, crying against him that it is not fitting for him to live any longer. ");
INSERT INTO engemtv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","But when I came to understand him to have done nothing worthy of death, and also he had appealed to His Majesty the Emperor, I decided to send him. ");
INSERT INTO engemtv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","About whom I have nothing certain to write to my lord. Therefore I have brought him before you, and especially before you King Agrippa, in order that when this hearing is finished I may have something to write. ");
INSERT INTO engemtv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","For it seems unreasonable to me to send a prisoner and not to signify the accusations against him.” ");
INSERT INTO engemtv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Then Agrippa said to Paul, “It is permitted for you to speak for yourself.” So Paul, having extended his hand, spoke in his own defense: ");
INSERT INTO engemtv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“I have considered myself fortunate, King Agrippa, being able to speak in my own defense today, concerning all the things of which I am accused of by the Jews, ");
INSERT INTO engemtv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","especially since you are well versed both in all the customs and questions in relation to the Jews; therefore I beg you to hear me patiently. ");
INSERT INTO engemtv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Therefore my way of life from my youth, which from the beginning was spent among my own nation in Jerusalem, all the Jews know, ");
INSERT INTO engemtv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","since they have known me for a long time, if they are willing to testify, that according to the strictest sect of our religion I lived as a Pharisee. ");
INSERT INTO engemtv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","And now for the hope of the promise having been made by God to the fathers, I stand before you judged, ");
INSERT INTO engemtv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","a promise to which our twelve tribes, as they earnestly serve God night and day, hope to attain. Concerning which hope I am accused by the Jews, King Agrippa. ");
INSERT INTO engemtv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Why is it considered such an unbelievable thing by you people if God raises the dead? ");
INSERT INTO engemtv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Therefore I thought in myself that it was necessary to do many hostile things against the name of Jesus the Nazarene; ");
INSERT INTO engemtv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","which also I did in Jerusalem, and many of the saints I shut up in prisons, having received authority from the chief priests; and when they were being put to death, I cast my vote against them. ");
INSERT INTO engemtv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","And I punished them often in all the synagogues, and compelled them to blaspheme; and being exceedingly enraged against them, I persecuted them even as far as to foreign cities. ");
INSERT INTO engemtv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“In which pursuits also, as I traveled to Damascus with authority and commission from the chief priests, ");
INSERT INTO engemtv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","at midday, O king, along the road I saw a light from heaven, brighter than the sun, shining around me and those traveling with me. ");
INSERT INTO engemtv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","And when we all had fallen down to the ground, I heard a voice speaking to me and saying in the Hebrew language, ‘Saul, Saul, why are you persecuting Me? It is hard for you to kick against the goads.’ ");
INSERT INTO engemtv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","So I said, ‘Who are You, Lord?’ And He said, ‘I am Jesus, whom you are persecuting. ");
INSERT INTO engemtv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","But arise and stand on your feet; for I have appeared to you, to appoint you a minister and a witness both of the things which you have seen, and of the things which I will appear to you, ");
INSERT INTO engemtv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","delivering you from the people, and from the Gentiles, to whom I am sending you, ");
INSERT INTO engemtv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","to open their eyes, in order to turn them from darkness to light, and from the authority of Satan to God, in order for them to receive forgiveness of sins and an inheritance among those who are sanctified by faith in Me.’ ");
INSERT INTO engemtv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Therefore, King Agrippa, I was not disobedient to the heavenly vision, ");
INSERT INTO engemtv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","but to those first in Damascus and in Jerusalem, and throughout all the region of Judea, and to the Gentiles, proclaiming that they must repent and turn to God, and do works worthy of repentance. ");
INSERT INTO engemtv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Because of these things the Jews arrested me in the temple and attempted to kill me. ");
INSERT INTO engemtv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Therefore, having obtained help from God, until this day I stand, witnessing both to common people and great people, saying nothing except the things which both the prophets and Moses spoke of as being about to happen, ");
INSERT INTO engemtv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","that the Christ was to suffer, that as the first to rise from the dead, He was about to proclaim light to the Jewish people and to the Gentiles.” ");
INSERT INTO engemtv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Now as he spoke these things, Festus said with a loud voice, “You are mad, Paul! Your higher learning is driving you to madness!” ");
INSERT INTO engemtv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","But he said, “I am not mad, most excellent Festus, but I boldly declare words of truth and reason. ");
INSERT INTO engemtv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","For the king knows about these things, to whom also I speak freely; for I am persuaded that none of these things escapes his notice, since this thing was not done in a corner. ");
INSERT INTO engemtv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Do you believe the prophets, King Agrippa? I know that you believe.” ");
INSERT INTO engemtv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","And Agrippa said to Paul, “In a short time, you are persuading me to become a Christian!” ");
INSERT INTO engemtv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","And Paul said, “I would to God, both in a short time and a long time, that not only you, but also all who are hearing me today, would become such as I am, except for these chains.” ");
INSERT INTO engemtv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","When he had said these things, the king stood up, as well as the governor and Bernice and those sitting together with them; ");
INSERT INTO engemtv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","and when they withdrew, they were speaking among themselves, saying, “This man practices nothing worthy of death or chains.” ");
INSERT INTO engemtv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Then Agrippa said to Festus, “This man could have been released if he had not appealed to Caesar.” ");
INSERT INTO engemtv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Now when it was decided that we should sail away to Italy, they handed over both Paul and certain other prisoners to a centurion named Julius, of the Augustan Regiment. ");
INSERT INTO engemtv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","And having boarded a ship of Adramyttium, scheduled to sail to the ports along the Asian coasts, we put to sea. Aristarchus, a Macedonian of Thessalonica, being with us. ");
INSERT INTO engemtv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","And the next day we put in to harbor at Sidon. And Julius treated Paul kindly, and permitted him to go to his friends to find care. ");
INSERT INTO engemtv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","And from there having put to sea, we sailed under the sheltered side of Cyprus, because the winds were against us. ");
INSERT INTO engemtv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","And having sailed across the sea which is off Cilicia and Pamphylia, we docked at Myra, in Lycia. ");
INSERT INTO engemtv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","And there the centurion found an Alexandrian ship sailing to Italy, and he put us aboard in it. ");
INSERT INTO engemtv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","And sailing slowly many days, and with difficulty arriving down off Cnidus, since the wind would not permit us to go on, we sailed under the sheltered side of Crete, down off Salmone. ");
INSERT INTO engemtv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","And with difficulty sailing past it, we came to a place called Fair Havens, near the city of Lasea. ");
INSERT INTO engemtv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Now when much time had been spent, the voyage having already become dangerous, because the Fast had already gone by, Paul recommended, ");
INSERT INTO engemtv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","saying to them, “Men, I perceive this voyage is going to be with hardship and much loss, not only of the cargo and of the ship but also our lives.” ");
INSERT INTO engemtv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","But the centurion was persuaded by the helmsman and the ship owner, rather than by the things being said by Paul. ");
INSERT INTO engemtv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","And because the harbor was not suitable to winter in, the majority gave counsel to put to sea from there, if perhaps they might be able to get to Phoenix to spend the winter there, a harbor of Crete opening toward the southwest and to the northwest. ");
INSERT INTO engemtv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","And when a south wind blew gently, supposing they had attained their purpose, they weighed anchor and sailed along close in shore to Crete. ");
INSERT INTO engemtv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","But not long after, a head wind like a hurricane arose, called a Euroclydon; ");
INSERT INTO engemtv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","and when the ship was seized by it, and not being able to face into the wind, we were being driven along, having given in to the wind. ");
INSERT INTO engemtv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","And running under the sheltered side of a certain little island called Clauda, we secured the skiff with difficulty. ");
INSERT INTO engemtv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","And having hoisted it up, they used cables for undergirding the ship; and being afraid lest they run aground in the Syrtes Shallows, they let down the driving anchor, thus they were being driven along by the wind. ");
INSERT INTO engemtv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","And because we were exceedingly tempest-tossed, the next day they lightened the ship. ");
INSERT INTO engemtv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","And on the third day we threw off the equipment of the ship with our own hands. ");
INSERT INTO engemtv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","And neither the sun nor stars appeared for many days, and no small storm pressed on us, finally all hope for us to be saved was taken away. ");
INSERT INTO engemtv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Now when they had abstained from food for a long time, then stood Paul in the midst of them and said, “Men, you should have followed my advice and not put to sea from Crete, and to spare yourselves this hardship and loss. ");
INSERT INTO engemtv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","And now I urge you to keep up your courage, for there will be loss of not one life among you, only of the ship. ");
INSERT INTO engemtv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","For there stood by me this night an angel of the God to whom I belong, whom also I serve, ");
INSERT INTO engemtv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","saying, ‘Do not be afraid, Paul; for it is necessary for you to stand before Caesar; and behold, God has granted you all those sailing with you.’ ");
INSERT INTO engemtv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Therefore keep up your courage, men; for I believe God that it will be in the very manner it has been spoken to me. ");
INSERT INTO engemtv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","However, it is necessary for us to run aground on a certain island.” ");
INSERT INTO engemtv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Now when it was the fourteenth night, as we were driven about in the Adriatic Sea, in the middle of the night the sailors sensed that land was approaching them. ");
INSERT INTO engemtv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","And having taken a sounding, they found it to be twenty fathoms; and when they had gone a little farther, they took soundings again and found it to be fifteen fathoms; ");
INSERT INTO engemtv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","and being afraid lest we should run aground on the rocks, they threw out four anchors from the stern, and were praying for day to come. ");
INSERT INTO engemtv_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Now as the sailors were seeking to flee from the ship, and letting down the skiff into the sea, in pretense of spreading out anchors from the prow, ");
INSERT INTO engemtv_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul said to the centurion and the soldiers, “If these men do not remain in the ship, you cannot be saved.” ");
INSERT INTO engemtv_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Then the soldiers cut off the ropes of the skiff and let it fall off. ");
INSERT INTO engemtv_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","And until the time was about to be day, Paul was urging them all to receive their share of food, saying, “Today is the fourteenth day you continue waiting without eating, having taken nothing. ");
INSERT INTO engemtv_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Therefore I urge you to take food, for this is for your deliverance; for not a hair from your head shall fall.” ");
INSERT INTO engemtv_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","And having said these things and having taken bread, he gave thanks to God in the presence of all, and having broken it, he began to eat. ");
INSERT INTO engemtv_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","And they all became cheerful and also took food themselves. ");
INSERT INTO engemtv_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","And in all we were two hundred and seventy-six persons on the ship. ");
INSERT INTO engemtv_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","And having eaten enough, they began lightening the ship and throwing out the wheat into the sea. ");
INSERT INTO engemtv_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Now when it became day, they did not recognize the land; but they noticed a certain bay which had a beach, on which they resolved, if possible, to run the ship ashore. ");
INSERT INTO engemtv_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","And casting off the anchors, they were leaving them in the sea, meanwhile loosening the ropes of the rudders; and having raised the mainsail to the wind, they began steering toward the beach. ");
INSERT INTO engemtv_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","But they struck a reef and ran the vessel aground, and the prow became stuck and remained unmoved, but the stern was being broken up by the violence of the waves. ");
INSERT INTO engemtv_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","And the soldiers' decision was that they would kill the prisoners, lest any should swim away and escape. ");
INSERT INTO engemtv_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","But the centurion, wanting to rescue Paul, hindered them in their intention, and commanded that those who were able to swim to jump down first to go toward the land, ");
INSERT INTO engemtv_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","and the rest, some on boards and others on parts from the ship. And in this way it came about that all were brought to safety. ");
INSERT INTO engemtv_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","And when they were rescued, then they learned that the island was called Malta. ");
INSERT INTO engemtv_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","And the natives were showing us extraordinary kindness; for having kindled a fire they accepted us all into their society, because of the rain which had begun, and because of the cold. ");
INSERT INTO engemtv_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","But when Paul had gathered a large bundle of sticks and put them on the fire, a viper having come out because of the heat, fastened on his hand. ");
INSERT INTO engemtv_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","And when the natives saw the creature hanging from his hand, they said to one another, “Certainly this man is a murderer, whom though he was rescued from the sea, justice does not permit to continue living.” ");
INSERT INTO engemtv_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Then, having shaken off the creature into the fire, he suffered nothing harmful. ");
INSERT INTO engemtv_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","And they were expecting him to be about to swell up or suddenly fall down dead. But after they had waited for a long time and observed nothing unusual happening to him, they changed their minds and said that he was a god. ");
INSERT INTO engemtv_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Now in the areas around that place were pieces of land belonging to the leading citizen of the island, named Publius, who welcomed us, and received us hospitably as guests for three days. ");
INSERT INTO engemtv_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","And it came to pass that the father of Publius lay sick of a fever and dysentery, to whom Paul came in and prayed, and laying his hands on him, healed him. ");
INSERT INTO engemtv_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Then after this happened, also the rest who were ill on the island were coming to him and were being healed, ");
INSERT INTO engemtv_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","who also honored us with many honors, and when we put to sea, they gave us the things that we needed. ");
INSERT INTO engemtv_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Now after three months we put to sea in a ship that had wintered on the island, belonging to Alexandria, with the figurehead of the Twin Brothers. ");
INSERT INTO engemtv_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","And putting in to harbor at Syracuse, we stayed there three days, ");
INSERT INTO engemtv_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","from where having sailed around we arrived at Rhegium. And after one day arose a south wind, on the second day we came to Puteoli, ");
INSERT INTO engemtv_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","where having found brothers, we were urged by them to stay for seven days; and so we came to Rome. ");
INSERT INTO engemtv_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","And from there the brothers, when they heard about our circumstances, they came to meet with us as far as Appii Forum and Three Inns, whom when Paul saw, he gave thanks to God and took courage. ");
INSERT INTO engemtv_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Now when we came to Rome, the centurion handed over the prisoners to the captain of the guard; but Paul was allowed to stay by himself with the soldier guarding him. ");
INSERT INTO engemtv_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","And it came to pass after three days that Paul called together those who were prominent among the Jews; and when they had come together, he said to them: “Men, brothers, though I have done nothing against the people or the customs of our forefathers, yet I was handed over as a prisoner from Jerusalem, into the hands of the Romans, ");
INSERT INTO engemtv_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","who, when they had examined me, were wanting to release me because there was no cause for my case. ");
INSERT INTO engemtv_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","But when the Jews spoke in opposition, I was compelled to appeal to Caesar, not that I had anything of which to accuse my nation. ");
INSERT INTO engemtv_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Therefore for this reason I have requested you, to see and to speak to you, for because of the hope of Israel I am wearing this chain.” ");
INSERT INTO engemtv_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Then they said to him, “We neither received letters from Judea concerning you, nor have any of the brothers who arrived report or speak anything evil about you. ");
INSERT INTO engemtv_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","But we request to hear from you the things which you think; for concerning this sect, it is known to us that everywhere it is spoken against.” ");
INSERT INTO engemtv_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","And having appointed for him a day, many came to him at his house, to whom he was explaining and solemnly testifying to the kingdom of God, and persuading them of the things concerning Jesus from both the Law of Moses and from the Prophets, from morning till evening. ");
INSERT INTO engemtv_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","And some were persuaded by the things being said, but others refused to believe. ");
INSERT INTO engemtv_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","And being in disagreement with one another, they went away after Paul had said one word: “The Holy Spirit spoke rightly through Isaiah the prophet to our fathers, ");
INSERT INTO engemtv_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","saying, ‘Go to this people and say: “Hearing you will hear, and by no means understand; and seeing you shall see, and by no means perceive; ");
INSERT INTO engemtv_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","For the hearts of this people has become dull. Their ears are hard of hearing, and their eyes have closed, lest they should see with their eyes and they should hear with their ears, lest they should understand with their heart and turn back, so that I should heal them.” ’ ");
INSERT INTO engemtv_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Therefore let it be known to you that the salvation of God has been sent to the Gentiles, and they will hear it!” ");
INSERT INTO engemtv_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","And when he had said these things, the Jews went away, having a great dispute among themselves. ");
INSERT INTO engemtv_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Then Paul remained two full years in his own rented house, and he was receiving all those who were coming to him, ");
INSERT INTO engemtv_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","preaching the kingdom of God and teaching the things concerning the Lord Jesus Christ with all boldness, without hindrance. ");
INSERT INTO engemtv_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul, a bondservant of Jesus Christ, called to be an apostle, having been separated unto the gospel of God ");
INSERT INTO engemtv_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","which He promised beforehand through His prophets in the Holy Scriptures, ");
INSERT INTO engemtv_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","concerning His Son, who was descended from David according to the flesh, ");
INSERT INTO engemtv_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","who was declared Son of God with power according to the Spirit of holiness by the resurrection of the dead, Jesus Christ our Lord, ");
INSERT INTO engemtv_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","through whom we received grace and apostleship for the obedience of faith among all the nations for His name, ");
INSERT INTO engemtv_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","among whom you also are the called of Jesus Christ: ");
INSERT INTO engemtv_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","To all those who are in Rome, beloved of God, called to be saints: Grace to you and peace from God our Father and the Lord Jesus Christ. ");
INSERT INTO engemtv_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","First, I thank my God through Jesus Christ for you all, that your faith is spoken of throughout the whole world. ");
INSERT INTO engemtv_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","For God is my witness, whom I serve with my spirit in the gospel of His Son, that without ceasing I make mention of you always in my prayers, ");
INSERT INTO engemtv_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","requesting if somehow now at sometime I shall succeed in the will of God to come to you. ");
INSERT INTO engemtv_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","For I long to see you, so that I may impart to you some spiritual gift, that you may be established— ");
INSERT INTO engemtv_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","that is, that I may be encouraged together with you through our mutual faith—both yours and mine. ");
INSERT INTO engemtv_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Now I do not want you to be ignorant, brothers, that often I planned to come to you (and I was hindered until now), that I might have some fruit among you also, just as among the other Gentiles. ");
INSERT INTO engemtv_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","I am a debtor both to Greeks and to barbarians, both to the wise and to the unwise. ");
INSERT INTO engemtv_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","So, as much as is in me, I am eager to preach the gospel to you who are in Rome also. ");
INSERT INTO engemtv_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","For I am not ashamed of the gospel of Christ, for it is the power of God unto salvation to everyone who believes, both to the Jew first and to the Greek. ");
INSERT INTO engemtv_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","For in it the righteousness of God is revealed from faith to faith; as it is written, “The just shall live by faith.” ");
INSERT INTO engemtv_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","For the wrath of God is revealed from heaven upon all ungodliness and unrighteousness of men who suppress the truth in unrighteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Because that which is known of God is manifest in them, for God has shown it to them. ");
INSERT INTO engemtv_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","For the invisible things of Him from the creation of the world are clearly seen, being understood by the things made, both His eternal power and divinity, so that they are without excuse. ");
INSERT INTO engemtv_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Because, having known God, they did not glorify Him as God, or give thanks, but became vain in their reasonings, and their foolish heart was darkened. ");
INSERT INTO engemtv_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Asserting themselves to be wise, they became fools, ");
INSERT INTO engemtv_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","and changed the glory of the incorruptible God for a likeness of an image of corruptible man and of birds and four-footed animals and reptiles. ");
INSERT INTO engemtv_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Therefore God also gave them up to uncleanness through the lusts of the own hearts, to dishonor their own bodies among themselves, ");
INSERT INTO engemtv_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","who exchanged the truth of God for the lie, and worshiped and served the creature rather than the Creator, who is blessed forever. Amen. ");
INSERT INTO engemtv_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","For this reason God gave them up to shameful lusts; for even their women exchanged the natural use for that which is contrary to nature, ");
INSERT INTO engemtv_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","and likewise also the men, having forsaken the natural use of the woman, were inflamed by their lust for one another, men with men, committing what is shameful, and receiving in themselves the recompense which was fitting for their error. ");
INSERT INTO engemtv_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","And just as they did not approve to have God in their knowledge, God gave them up to a depraved mind, to do the things which are not fitting; ");
INSERT INTO engemtv_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","having been filled with all unrighteousness, sexual immorality, wickedness, greed, malice; full of envy, murder, strife, deceit, maliciousness; they are whisperers, ");
INSERT INTO engemtv_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","slanderers, haters of God, insolent men, proud, braggarts, inventors of evil things, disobedient to parents, ");
INSERT INTO engemtv_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","without understanding, untrustworthy, unloving, unforgiving, unmerciful; ");
INSERT INTO engemtv_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","who, having known the righteous judgment of God, that those practicing such things are worthy of death, not only do them, but also approve of those who practice them. ");
INSERT INTO engemtv_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Therefore you are inexcusable, O man, everyone who judges, for in whatever you judge another you condemn yourself, for you who judge are practicing the same things. ");
INSERT INTO engemtv_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","But we know that the judgment of God is according to truth upon those practicing such things. ");
INSERT INTO engemtv_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","But do you suppose this, O man, you who judge those practicing such things yet doing them, that you will escape the judgment of God? ");
INSERT INTO engemtv_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Or do you despise the riches of His kindness and tolerance and patience, not knowing that the kindness of God leads you to repentance? ");
INSERT INTO engemtv_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","But according to your hardness and impenitent heart you are storing up for yourself wrath in the day of wrath and revelation, and of the righteous judgment of God, ");
INSERT INTO engemtv_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","who “will recompense to each one according to his works”: ");
INSERT INTO engemtv_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","to those who by the endurance of good works are seeking glory and honor and incorruption—eternal life. ");
INSERT INTO engemtv_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","But to those who are contentious, and who disobey the truth, but obey unrighteousness—indignation and wrath, ");
INSERT INTO engemtv_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","tribulation and anguish, upon every soul of man that works evil, of the Jew first and also of the Greek; ");
INSERT INTO engemtv_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","but glory, honor, and peace to everyone that works good, both to the Jew first and to the Greek. ");
INSERT INTO engemtv_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","For there is no partiality with God. ");
INSERT INTO engemtv_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","For all who have sinned without the law shall also perish without the law, and all who have sinned under the law shall be judged by the law ");
INSERT INTO engemtv_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","(for it is not the hearers of the law who are righteous before God, but the doers of the law shall be justified; ");
INSERT INTO engemtv_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","for whenever Gentiles, who do not have the law, by nature do what the law requires, these, not having the law, are a law unto themselves, ");
INSERT INTO engemtv_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","who show the work of the law written in their hearts, their conscience witnessing with them, and among themselves their thoughts accuse or even defend them), ");
INSERT INTO engemtv_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","in the day when God shall judge the secrets of men according to my gospel through Jesus Christ. ");
INSERT INTO engemtv_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Behold, you are called a Jew, and rely on the law, and boast in God, ");
INSERT INTO engemtv_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","and know His will, and approve the things that are more excellent, being instructed out of the law, ");
INSERT INTO engemtv_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","and are convinced that you are a guide to the blind, a light to those in darkness, ");
INSERT INTO engemtv_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","an instructor of the foolish, a teacher of the immature, having the embodiment of knowledge and of the truth in the law. ");
INSERT INTO engemtv_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","You, therefore, who teach another, do you not teach yourself? You who preach that a man should not steal, do you steal? ");
INSERT INTO engemtv_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","You who say, “Do not commit adultery,” do you commit adultery? You who abhor idols, do you commit sacrilege? ");
INSERT INTO engemtv_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","You who boast in the law, do you dishonor God through the transgression of the law? ");
INSERT INTO engemtv_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","For “The name of God is blasphemed among the Gentiles because of you,” just as it is written. ");
INSERT INTO engemtv_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","For indeed circumcision profits if you keep the law; but if you are a transgressor of the law, your circumcision has become uncircumcision. ");
INSERT INTO engemtv_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Therefore, if an uncircumcised man keeps the righteous requirements of the law, will not his uncircumcision be regarded as circumcision? ");
INSERT INTO engemtv_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","And will not the physically uncircumcised, who keeps the law, judge you along with your written code and circumcision, as a lawbreaker? ");
INSERT INTO engemtv_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","For he is not a Jew who is one outwardly, nor is circumcision that which is outward in flesh; ");
INSERT INTO engemtv_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","but he is a Jew that is one inwardly; and circumcision is of the heart, in the spirit, not in the letter, whose praise is not from men but from God. ");
INSERT INTO engemtv_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","What then is the superiority of the Jew, or what is the profit of circumcision? ");
INSERT INTO engemtv_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Much in every way! First of all, that they were entrusted with the very words of God! ");
INSERT INTO engemtv_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","For what if some did not believe? Will their unbelief nullify the faithfulness of God? ");
INSERT INTO engemtv_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","By no means! Indeed, let God be true but every man a liar, just as it is written: “That You may be justified in Your words, and You may prevail when You are judged.” ");
INSERT INTO engemtv_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","But if our unrighteousness demonstrates the righteousness of God, what shall we say? Surely God, the One inflicting wrath is not unrighteous, is He? (I speak as a man.) ");
INSERT INTO engemtv_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","By no means! For otherwise how shall God judge the world? ");
INSERT INTO engemtv_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","For if by my lie the truth of God has abounded to His glory, why am I also still judged as a sinner? ");
INSERT INTO engemtv_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","And why not say, “Let us do evil so that good may come”?—just as we are slandered, and just as some affirm that we say. The judgment of whom is just. ");
INSERT INTO engemtv_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","What then? Are we any better? Not at all. For we previously charged both Jews and Greeks that they are all under sin. ");
INSERT INTO engemtv_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Just as it is written: “There is none righteous, no not one. ");
INSERT INTO engemtv_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","There is none who understands; there is none who seeks God. ");
INSERT INTO engemtv_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","All have turned aside; together they became unprofitable; there is not one doing kindness, there is not so much as one. ");
INSERT INTO engemtv_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Their throat is an opened grave; with their tongues they deceived; the poison of asps is under their lips; ");
INSERT INTO engemtv_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Whose mouth is full of cursing and bitterness. ");
INSERT INTO engemtv_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Their feet are swift to shed blood; ");
INSERT INTO engemtv_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ruin and misery are in their ways; ");
INSERT INTO engemtv_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","and the way of peace they did not know. ");
INSERT INTO engemtv_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","There is no fear of God before their eyes.” ");
INSERT INTO engemtv_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Now we know that as many things as the law says, it speaks to those under the law, so that every mouth may be stopped, and all the world may be held accountable to God. ");
INSERT INTO engemtv_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Therefore by works of the law no flesh shall be justified in His sight, for through the law comes the knowledge of sin. ");
INSERT INTO engemtv_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","But now the righteousness of God apart from the law has been revealed, being witnessed by the Law and the Prophets, ");
INSERT INTO engemtv_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","even the righteousness of God, through faith in Jesus Christ, to all and upon all those that believe. For there is no distinction; ");
INSERT INTO engemtv_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","for all have sinned and come short of the glory of God, ");
INSERT INTO engemtv_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","being justified freely by His grace through the redemption that is in Christ Jesus, ");
INSERT INTO engemtv_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","whom God set forth as a propitiation through faith in His blood, for a demonstration of His righteousness through the passing over of the sins having previously committed, in the forbearance of God, ");
INSERT INTO engemtv_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","for a demonstration of His righteousness in the present time, that He might be just and the justifier of he who has faith in Jesus. ");
INSERT INTO engemtv_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Where then is boasting? It is excluded. Through what law? Of works? No, but through the law of faith. ");
INSERT INTO engemtv_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Therefore we conclude that a man is justified by faith apart from works of the law. ");
INSERT INTO engemtv_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Or is He the God of the Jews only? But is He not also the God of the Gentiles? Yes, of the Gentiles also, ");
INSERT INTO engemtv_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","since there is one God who will justify the circumcision by faith, and the uncircumcised through faith. ");
INSERT INTO engemtv_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Therefore do we nullify the law through faith? By no means! On the contrary, we uphold the law. ");
INSERT INTO engemtv_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","What then shall we say that Abraham our father has found according to the flesh? ");
INSERT INTO engemtv_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","For if Abraham was justified by works, he has grounds for boasting, but not before God. ");
INSERT INTO engemtv_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","For what does the Scripture say? “Abraham believed God, and it was credited to him as righteousness.” ");
INSERT INTO engemtv_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Now to him who works, his wage is not credited as a gift, but as his due. ");
INSERT INTO engemtv_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","But to him who does not work but believes on Him who justifies the ungodly, his faith is credited as righteousness, ");
INSERT INTO engemtv_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","just as David also speaks of the blessing of the man to whom God credits righteousness apart from works: ");
INSERT INTO engemtv_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Blessed are they whose lawless deeds have been forgiven, and whose sins have been covered; ");
INSERT INTO engemtv_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Blessed is the man to whom the Lord shall by no means impute sin.” ");
INSERT INTO engemtv_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Does this blessing then come upon the circumcision, or also upon the uncircumcised? For we say that faith was credited to Abraham as righteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","How then was it credited? While he was circumcised, or in uncircumcision? Not in circumcision, but in uncircumcision. ");
INSERT INTO engemtv_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","And he received the sign of circumcision, a seal of the righteousness of the faith which he had while in uncircumcision, so that he should be the father of all those that believe, although uncircumcised, so that righteousness should also be credited to them, ");
INSERT INTO engemtv_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","and the father of circumcision to those not only of circumcision, but also to those following in the steps of the faith which our father Abraham had while in uncircumcision. ");
INSERT INTO engemtv_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","For the promise that he should be heir of the world was not to Abraham or to his seed through the law, but through the righteousness of faith. ");
INSERT INTO engemtv_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","For if those who are of the law are heirs, faith is made void and the promise made of no effect, ");
INSERT INTO engemtv_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","because the law produces wrath; for where there is no law neither is there transgression. ");
INSERT INTO engemtv_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Therefore it is of faith that it may be according to grace, so that the promise might be sure to all the seed, not only to those of the law, but also to those of the faith of Abraham, who is the father of us all, ");
INSERT INTO engemtv_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(just as it is written, “I have appointed you a father of many nations”) before God, whom he believed, the One who gives life to the dead and calls those things which are not as though they were; ");
INSERT INTO engemtv_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","who, contrary to hope, on hope believed, so that he should become a father of many nations, according to what was spoken, “So shall your descendants be.” ");
INSERT INTO engemtv_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","And not weakening in faith, he did not consider his own body, already having been worn out (being about a hundred years old), and the deadness of Sarah's womb, ");
INSERT INTO engemtv_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","he did not waver at the promise of God in unbelief, but was empowered by faith, giving glory to God, ");
INSERT INTO engemtv_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","and being fully convinced that what He had promised He was also able to do. ");
INSERT INTO engemtv_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","And therefore “it was credited to him as righteousness.” ");
INSERT INTO engemtv_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Now it was not written for his sake alone that it was credited to him, ");
INSERT INTO engemtv_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","but for us also, to whom it was going to be credited, those believing on Him who raised up Jesus our Lord from the dead, ");
INSERT INTO engemtv_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","who was delivered up for our transgressions, and was raised for our justification. ");
INSERT INTO engemtv_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Therefore, having been justified by faith, we have peace with God through our Lord Jesus Christ, ");
INSERT INTO engemtv_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","through whom we have also gained access by faith into this grace in which we stand, and we rejoice in hope of the glory of God. ");
INSERT INTO engemtv_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","And not only that, but we also rejoice in tribulations, knowing that tribulation produces endurance; ");
INSERT INTO engemtv_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","and endurance, approved character; and approved character, hope. ");
INSERT INTO engemtv_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","And hope does not disappoint, because the love of God has been poured out in our hearts by the Holy Spirit who was given to us. ");
INSERT INTO engemtv_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","For while we were still weak, in due time Christ died for the ungodly. ");
INSERT INTO engemtv_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","For scarcely on behalf of a righteous man will anyone die; though perhaps for a good man someone might even dare to die. ");
INSERT INTO engemtv_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","But God demonstrates His own love toward us, in that while we were still sinners, Christ died for us. ");
INSERT INTO engemtv_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Much more then, having now been justified by His blood, we shall be saved from wrath through Him. ");
INSERT INTO engemtv_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","For if while we were enemies we were reconciled to God through the death of His Son, much more, having been reconciled, shall we be saved by His life. ");
INSERT INTO engemtv_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","And not only that, but we also rejoice in God through our Lord Jesus Christ, through whom now we received the reconciliation. ");
INSERT INTO engemtv_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Therefore, just as through one man sin entered the world, and death through sin, and thus death passed to all men, because all sinned— ");
INSERT INTO engemtv_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","(For until the law sin was in the world, but sin is not imputed when there is no law. ");
INSERT INTO engemtv_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Yet death reigned from Adam until Moses, even over those who did not sin according to the likeness of the transgression of Adam, who is a type of Him who was to come. ");
INSERT INTO engemtv_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","But the free gift is not like the transgression. For if by the transgression of the one man many died, much more the grace of God and the gift by the grace of the one Man, Jesus Christ, abounded to the many. ");
INSERT INTO engemtv_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","And the gift is not as by one having sinned. For the judgment which came from one offense brought condemnation, but the free gift from many offenses brought justification. ");
INSERT INTO engemtv_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","For if by the transgression of one man death reigned through that one man, much more those receiving the abundance of the grace and of the gift of righteousness will reign in life through the One, Jesus Christ.) ");
INSERT INTO engemtv_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","So then, as through one man's transgression judgment came to all men, resulting in condemnation, even so through one Man's righteous act the free gift came to all men, resulting in justification of life. ");
INSERT INTO engemtv_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","For through the disobedience of one man many were constituted sinners, so also through the obedience of one Man many shall be constituted righteous. ");
INSERT INTO engemtv_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","But the law came in alongside, so that the offense might abound. But where sin abounded, grace superabounded, ");
INSERT INTO engemtv_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","so that just as sin reigned in death, so also grace might reign through righteousness to eternal life through Jesus Christ our Lord. ");
INSERT INTO engemtv_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","What shall we say then? Shall we go on sinning so that grace may abound? ");
INSERT INTO engemtv_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","By no means! We died to sin—how shall we live any longer in it? ");
INSERT INTO engemtv_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Or do you not know that as many of us as were baptized into Christ Jesus have been baptized into His death? ");
INSERT INTO engemtv_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Therefore we were buried with Him through baptism into death, so that just as Christ was raised from the dead through the glory of the Father, so we also should walk in newness of life. ");
INSERT INTO engemtv_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","For if we have been united together in the likeness of His death, certainly we shall also be in the likeness of His resurrection; ");
INSERT INTO engemtv_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","knowing this, that our old man was crucified with Him, so that the body of sin may be done away with, that we should no longer serve sin. ");
INSERT INTO engemtv_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","For he who has died has been justified from sin. ");
INSERT INTO engemtv_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","But if we died with Christ, we believe that we also shall live together with Him, ");
INSERT INTO engemtv_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","knowing that Christ, having been raised from the dead, no longer dies. Death is no longer master over Him. ");
INSERT INTO engemtv_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","For what death He died, He died to sin once for all; but what life He lives, He lives to God. ");
INSERT INTO engemtv_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Likewise you also, consider yourselves to be dead indeed to sin, but alive to God in Christ Jesus our Lord. ");
INSERT INTO engemtv_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Therefore do not let sin reign in your mortal body, that you should obey it in its lusts, ");
INSERT INTO engemtv_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","nor present your members as instruments of unrighteousness to sin, but present yourselves to God as being alive from the dead, and your members as instruments of righteousness to God. ");
INSERT INTO engemtv_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","For sin shall not be master over you, for you are not under law but under grace. ");
INSERT INTO engemtv_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","What then? Shall we sin because we are not under law but under grace? By no means! ");
INSERT INTO engemtv_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Do you not know that to whom you present yourselves as obedient slaves, you are slaves to whom you obey, whether of sin resulting in death, or of obedience resulting in righteousness? ");
INSERT INTO engemtv_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","But thanks be to God, that though you used to be slaves of sin, yet you obeyed from your heart that form of doctrine to which you were delivered. ");
INSERT INTO engemtv_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","And having been freed from sin, you became enslaved to righteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","I speak in human terms on account of the weakness of your flesh. For just as you presented your members as slaves to uncleanness, and to lawlessness resulting in more lawlessness, so now present your members as slaves to righteousness resulting in sanctification. ");
INSERT INTO engemtv_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","For when you were slaves of sin, you were free in regard to righteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","So what fruit did you have then of which things you are now ashamed? For the end of those things is death. ");
INSERT INTO engemtv_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","But now having been freed from sin, and having become enslaved to God, you have your fruit resulting in sanctification, and the outcome, eternal life. ");
INSERT INTO engemtv_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","For the wages of sin is death, but the gift of God is eternal life in Christ Jesus our Lord. ");
INSERT INTO engemtv_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Or do you not know, brothers (for I speak to those knowing the law), that the law has jurisdiction over a man as long as he lives? ");
INSERT INTO engemtv_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","For the woman who is under a man has been bound by law to the living husband. But if the husband should die, she is released from the law of the husband. ");
INSERT INTO engemtv_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","So then, while the husband is living, she will be called an adulteress if she becomes married to a different husband; but if her husband should die, she is free from the law, so that she is not an adulteress, having become married to a different husband. ");
INSERT INTO engemtv_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Therefore, my brothers, you also were put to death to the law through the body of Christ, that you may be married to another—to Him who was raised from the dead, so that we might bear fruit to God. ");
INSERT INTO engemtv_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","For when we were in the flesh, the sinful passions aroused through the law were at work in our members to bear fruit to death. ");
INSERT INTO engemtv_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","But now we were released from the law, having died in that to which we were held fast, so that we should serve as slaves in the newness of the Spirit and not in the oldness of the letter. ");
INSERT INTO engemtv_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","What shall we say then? Is the law sin? By no means! On the contrary, I would not have known sin except through the law. For I would not have known lust unless the law had said, “You shall not covet.” ");
INSERT INTO engemtv_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","But sin, taking opportunity through the commandment, produced in me every kind of lust. For apart from the law sin was dead. ");
INSERT INTO engemtv_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","For I was alive apart from the law once, but when the commandment came, sin revived, but I died. ");
INSERT INTO engemtv_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","And the commandment, which was to bring life, I found to bring death. ");
INSERT INTO engemtv_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","For sin, taking opportunity through the commandment, deceived me, and by it, killed me. ");
INSERT INTO engemtv_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Therefore the law indeed is holy, and the commandment holy and righteous and good. ");
INSERT INTO engemtv_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Then has that which is good become death to me? By no means! But sin, that it might appear sin, was producing death in me through that which is good, so that sin through the commandment might become exceedingly sinful. ");
INSERT INTO engemtv_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","For we know that the law is spiritual, but I am carnal, sold under sin. ");
INSERT INTO engemtv_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","For what I am doing, I do not know. For what I want to do, I do not do; but what I hate, this I do. ");
INSERT INTO engemtv_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","But if I do what I do not want to do, I agree with the law that it is good. ");
INSERT INTO engemtv_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","But now it is no longer I who am doing it, but the sin living in me. ");
INSERT INTO engemtv_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","For I know that in me (that is, in my flesh) nothing good dwells; for to will is present with me, but how to do what is good, I do not find. ");
INSERT INTO engemtv_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","For the good that I want to do I do not do; but the evil I do not want to do, this I practice. ");
INSERT INTO engemtv_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","But if I do what I do not want to do, it is no longer I who do it, but the sin living in me. ");
INSERT INTO engemtv_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Therefore I find this law, that when I wish to do the right thing, evil is right there with me. ");
INSERT INTO engemtv_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","For I delight in the law of God in my inner being. ");
INSERT INTO engemtv_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","But I see a different law in my members, waging war against the law of my mind, and capturing me by the law of sin which is in my members. ");
INSERT INTO engemtv_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","O wretched man that I am! Who shall deliver me from this body of death? ");
INSERT INTO engemtv_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","I thank God through Jesus Christ our Lord! So then, I myself with the mind serve the law of God, but with the flesh the law of sin. ");
INSERT INTO engemtv_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","There is therefore now no condemnation to those who are in Christ Jesus, who do not walk according to the flesh, but according to the Spirit. ");
INSERT INTO engemtv_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","For the law of the Spirit of life in Christ Jesus has set me free from the law of sin and of death. ");
INSERT INTO engemtv_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","For what was impossible for the law to do in that it was weak through the flesh, God did by sending His own Son in the likeness of sinful flesh, and concerning sin, He condemned sin in the flesh, ");
INSERT INTO engemtv_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","so that the righteous requirement of the law might be fulfilled in us who do not walk according to the flesh but according to the Spirit. ");
INSERT INTO engemtv_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","For those who live according to the flesh set their minds on the things of the flesh, but those who live according to the Spirit, the things of the Spirit. ");
INSERT INTO engemtv_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","For the mind set on the flesh is death, but the mind set on the Spirit is life and peace. ");
INSERT INTO engemtv_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Because the mind set on the flesh is hostile toward God; for it does not submit to the law of God, nor indeed can it. ");
INSERT INTO engemtv_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","And those that are in the flesh cannot please God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","But you are not in the flesh but in the Spirit, if in fact the Spirit of God dwells in you. But if anyone does not have the Spirit of Christ, he is not His. ");
INSERT INTO engemtv_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","But if Christ is in you, the body indeed is dead because of sin, but the Spirit is alive because of righteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","But if the Spirit of Him who raised Jesus from the dead dwells in you, He who raised Christ from the dead will also give life to your mortal bodies through His Spirit who dwells in you. ");
INSERT INTO engemtv_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Therefore, brothers, we are debtors—not to the flesh, to live according to the flesh. ");
INSERT INTO engemtv_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","For if you live according to the flesh you shall die; but if by the Spirit you put to death the practices of the body, you will live. ");
INSERT INTO engemtv_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","For as many as are led by the Spirit of God, these are sons of God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","For you did not receive the spirit of bondage again unto fear, but you received the Spirit of adoption by whom we cry out, “Abba, Father.” ");
INSERT INTO engemtv_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","The Spirit Himself bears witness with our spirit that we are children of God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","And if children, then heirs—heirs of God and joint heirs with Christ, if indeed we suffer together, so that we may also be glorified together. ");
INSERT INTO engemtv_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","For I consider that the sufferings of this present time are not worthy to be compared with the coming glory to be revealed in us. ");
INSERT INTO engemtv_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","For the earnest expectation of the creation eagerly awaits the unveiling of the sons of God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","For the creation was subjected to futility, not willingly, but on account of Him who subjected it in hope; ");
INSERT INTO engemtv_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","because even the creation itself shall be freed from the slavery of corruption into the freedom of the glory of the children of God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","For we know that all the creation groans together and labors in birth together until now. ");
INSERT INTO engemtv_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","And not only that, but also we ourselves having the firstfruits of the Spirit, even we ourselves groan within ourselves, eagerly waiting adoption, the redemption of our body. ");
INSERT INTO engemtv_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","For by this hope we were saved, but hope that is seen is not hope; for why does one still hope for what he already sees? ");
INSERT INTO engemtv_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","But if we hope for what we do not see, we eagerly await it with endurance. ");
INSERT INTO engemtv_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Likewise the Spirit also helps in our weaknesses. For we do not know what we should pray for as we ought, but the Spirit Himself intercedes for us with inexpressible groanings. ");
INSERT INTO engemtv_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","But He that searches the hearts knows what the mind of the Spirit is, because He intercedes on behalf of the saints according to the will of God. ");
INSERT INTO engemtv_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","And we know that all things work together for good to those who love God, to those who are called according to His purpose. ");
INSERT INTO engemtv_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Because whom He foreknew, He also predestined to be conformed to the image of His Son, that He might be the firstborn among many brothers. ");
INSERT INTO engemtv_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Moreover whom He predestined, these He also called; and whom He called, these He also justified; and whom He justified, these He also glorified. ");
INSERT INTO engemtv_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","What then shall we say to these things? If God is for us, who can be against us? ");
INSERT INTO engemtv_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","He who did not spare His own Son, but gave Him up on behalf of us all, how shall He not with Him also freely give us all things? ");
INSERT INTO engemtv_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Who shall bring an accusation against God's elect? It is God who justifies. ");
INSERT INTO engemtv_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Who is he that condemns? Christ is the One having died, but rather also having been raised, who is even at the right hand of God, who also intercedes on our behalf. ");
INSERT INTO engemtv_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Who shall separate us from the love of Christ? Shall tribulation, or distress, or persecution, or famine, or nakedness, or danger, or sword? ");
INSERT INTO engemtv_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","As it is written: “For Your sake we are put to death the whole day long; we are accounted as sheep for slaughter.” ");
INSERT INTO engemtv_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","But in all these things we are more than conquerors through Him who loved us. ");
INSERT INTO engemtv_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","For I am convinced that neither death nor life, nor angels nor principalities nor powers, nor things present nor things to come, ");
INSERT INTO engemtv_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nor height nor depth, nor anything else in creation, shall be able to separate us from the love of God which is in Christ Jesus our Lord. ");
INSERT INTO engemtv_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","I am speaking the truth in Christ, I am not lying, my conscience witnessing with me in the Holy Spirit, ");
INSERT INTO engemtv_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","that I have great sorrow and unceasing pain in my heart. ");
INSERT INTO engemtv_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","For I could wish that I myself to be accursed from Christ on behalf of my brothers, my kinsmen according to the flesh, ");
INSERT INTO engemtv_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","who are Israelites, of whom are the adoption, and the glory, and the covenants, and the law-giving, and the worship, and the promises; ");
INSERT INTO engemtv_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","of whom are the fathers and from whom Christ came, according to the flesh, He who is God over all, blessed forever. Amen. ");
INSERT INTO engemtv_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","But it is not as though the word of God has failed. For not all those of Israel are of Israel, ");
INSERT INTO engemtv_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","nor are they all children because they are the seed of Abraham; but, “In Isaac your descendants shall be called.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","That is, those who are the children of the flesh are not the children of God; but it is the children of the promise that are regarded as descendants. ");
INSERT INTO engemtv_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","For this is the word of promise: “At this time I will come and Sarah shall have a son.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","And not only this, but also Rebecca, having conceived from the one man, our father Isaac; ");
INSERT INTO engemtv_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","(for the children not yet being born, nor having done anything good or evil, that the purpose of God according to election might stand, not of works but of Him who calls), ");
INSERT INTO engemtv_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","it was said to her, “The older shall serve the younger.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","As it is written, “Jacob I loved, but Esau I hated.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","What shall we say then? Is there unrighteousness with God? By no means! ");
INSERT INTO engemtv_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","For He says to Moses, “I will have mercy on whomever I will have mercy, and I will have compassion on whomever I will have compassion.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","So then it is not of him that wills, nor of him that runs, but of God who shows mercy. ");
INSERT INTO engemtv_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","For the Scripture says to Pharaoh, “For this very purpose I have raised you up, that I may show My power in you, and that My name may be proclaimed in all the earth.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","So then He has mercy on whom He wills, and whom He wills He hardens. ");
INSERT INTO engemtv_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","You will say to me then, “Why does He still find fault? For who can resist His will?” ");
INSERT INTO engemtv_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","But indeed, O man, who are you to be answering back against God? Shall the thing formed say to him who formed it, “Why have you made me like this?” ");
INSERT INTO engemtv_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Or does not the potter have the right over the clay, from the same lump to make one vessel for honor and the other for dishonor? ");
INSERT INTO engemtv_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","But what if God, wanting to show His wrath, and to make His power known, endured with much longsuffering the vessels of wrath prepared for destruction, ");
INSERT INTO engemtv_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","and so that He might make known the riches of His glory on the vessels of mercy, which He had prepared beforehand for glory, ");
INSERT INTO engemtv_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","even us whom He called, not only of the Jews, but also of the Gentiles? ");
INSERT INTO engemtv_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","As also in Hosea He says: “I will call those My people who were not My people, and her beloved, who was not beloved.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","“And it shall be in the place where it was said to them, ‘You are not My people,’ there they shall be called sons of the living God.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaiah also cries out concerning Israel: “Though the number of the sons of Israel be as the sand of the sea, the remnant shall be saved; ");
INSERT INTO engemtv_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","For He is finishing and cutting short an account in righteousness, because the Lord will make a short account upon the earth.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","And just as Isaiah foretold: “If the Lord of hosts had not left us a seed, we would have become like Sodom, and would have resembled Gomorrah.” ");
INSERT INTO engemtv_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","What shall we say then? That Gentiles, who did not pursue righteousness, have attained righteousness, even the righteousness of faith; ");
INSERT INTO engemtv_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","but Israel, pursuing a law of righteousness, did not attain to the law of righteousness. ");
INSERT INTO engemtv_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Why? Because they did not seek it by faith, but rather by the works of the law. For they stumbled at that stone of stumbling. ");
INSERT INTO engemtv_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Just as it is written: “Behold, I lay in Zion a stone of stumbling and a rock of offense, and everyone believing on Him will not be put to shame.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Brothers, the good pleasure of my heart and my supplication to God on behalf of Israel, is for their salvation. ");
INSERT INTO engemtv_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","For I testify concerning them, that they have a zeal for God, but not according to knowledge. ");
INSERT INTO engemtv_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","For they, being ignorant of the righteousness of God, and seeking to establish their own righteousness, have not submitted themselves unto the righteousness of God. ");
INSERT INTO engemtv_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","For Christ is the end of the law for righteousness to everyone that believes. ");
INSERT INTO engemtv_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","For Moses writes about the righteousness which is of the law, “That the man who does those things shall live by them.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","But the righteousness of faith says, “Do not say in your heart, ‘Who shall ascend into heaven?’ ” (that is, to bring Christ down) ");
INSERT INTO engemtv_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","or, “ ‘Who shall descend into the abyss?’ ” (that is, to bring up Christ from the dead). ");
INSERT INTO engemtv_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","But what does it say? “The word is near you, in your mouth and in your heart” (that is, the word of faith which we proclaim): ");
INSERT INTO engemtv_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","that if you confess with your mouth the Lord Jesus, and you believe in your heart that God has raised Him from the dead, you shall be saved. ");
INSERT INTO engemtv_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","For with the heart one believes unto righteousness, and with the mouth confession is made unto salvation. ");
INSERT INTO engemtv_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","For the Scripture says, “Whoever believes on Him shall not be put to shame.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","For there is no distinction between Jew and Greek, for the same Lord of all is rich to all who call on Him. ");
INSERT INTO engemtv_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","For “whosoever shall call upon the name of the Lord shall be saved.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","How then shall they call on Him in whom they have not believed? And how are they to believe in Him of whom they have not heard? And how shall they hear apart from a preacher? ");
INSERT INTO engemtv_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","And how shall they preach unless they are sent? Just as it is written: “How beautiful are the feet of those who preach the gospel of peace, of those preaching the gospel of good things!” ");
INSERT INTO engemtv_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","But they have not all obeyed the gospel. For Isaiah says, “Lord, who has believed our report?” ");
INSERT INTO engemtv_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","So then faith comes by hearing, and hearing by the word of God. ");
INSERT INTO engemtv_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","But I say, have they not heard? Yes, indeed they have: “Their voice went out to all the earth, and their words to the ends of the world.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","But I say, did Israel not know? First Moses says: “I will provoke you to jealousy by those who are not a nation, by a foolish nation I will anger you.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","But Isaiah is very bold and says: “I was found by those who did not seek Me; I was made manifest to those who did not ask for Me.” ");
INSERT INTO engemtv_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","But to Israel he says: “the whole day long I have stretched out My hands to a disobedient and obstinate people.” ");
INSERT INTO engemtv_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","I say then, has God cast away His people? By no means! For I too am an Israelite, of the seed of Abraham, of the tribe of Benjamin. ");
INSERT INTO engemtv_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","God has not cast away His people whom He foreknew. Or do you not know what the Scripture says in Elijah, how he pleads with God against Israel, saying, ");
INSERT INTO engemtv_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Lord, they have killed Your prophets and torn down Your altars, and I alone am left, and they are seeking my life”? ");
INSERT INTO engemtv_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","But what is God's reply to him? “I have reserved for Myself seven thousand men who have not bowed the knee to Baal.” ");
INSERT INTO engemtv_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","So too then, at this present time, there is also a remnant according to the election of grace. ");
INSERT INTO engemtv_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","And if by grace, it is no longer of works; otherwise grace is no longer grace. But if it is of works, it is no longer grace; otherwise work is no longer work. ");
INSERT INTO engemtv_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","What then? Israel has not obtained what it seeks; but the elect have obtained it, and the rest were blinded. ");
INSERT INTO engemtv_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Just as it is written: “God has given them a spirit of stupor, eyes that they should not see, and ears that they should not hear, down to this very day.” ");
INSERT INTO engemtv_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","And David says: “Let their table become a snare and a trap, a stumbling block and a recompense to them. ");
INSERT INTO engemtv_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Let their eyes be darkened so that they cannot see, and their backs be bent forever!” ");
INSERT INTO engemtv_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","I say then, have they stumbled that they should fall? By no means! But by their transgression, salvation has come to the Gentiles, to provoke them to jealousy. ");
INSERT INTO engemtv_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","But if their transgression is riches for the world, and their defeat is riches for the Gentiles, how much more will their fullness be! ");
INSERT INTO engemtv_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","For I speak to you Gentiles; inasmuch as I am indeed an apostle to the Gentiles, I magnify my ministry, ");
INSERT INTO engemtv_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","if somehow I may provoke to jealousy my fellow Jews, and thus save some of them. ");
INSERT INTO engemtv_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","For if their casting away means reconciliation for the world, what will their acceptance be, if not life from the dead? ");
INSERT INTO engemtv_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","For if the firstfruit is holy, so also the lump; and if the root is holy, so also the branches. ");
INSERT INTO engemtv_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","But if some of the branches were broken off, and you, being a wild olive tree, were grafted in among them, and became a partaker o